# t00046 - Test case for root namespace handling with packages
## Config
```yaml
diagrams:
  t00046_class:
    type: class
    generate_packages: true
    glob:
      - t00046.cc
    exclude:
      namespaces:
        - std
```
## Source code
File `tests/t00046/t00046.cc`
```cpp
#include <cstdint>
#include <vector>

class A { };

class AA { };

namespace ns1 {

class A { };

namespace ns2 {

class A { };

class B : public A { };

class C : public ns1::A { };

class D : public ns1::ns2::A { };

class E : public ::A { };

class R {
public:
    A *a;
    ns1::A *ns1_a;
    ns1::ns2::A *ns1_ns2_a;
    ::A *root_a;
    std::vector<std::uint8_t> i;

    void foo(::AA &aa) { (void)aa; }
};
} // namespace ns2
} // namespace ns1

```
## Generated PlantUML diagrams
![t00046_class](./t00046_class.svg "Test case for root namespace handling with packages")
## Generated Mermaid diagrams
![t00046_class](./t00046_class_mermaid.svg "Test case for root namespace handling with packages")
## Generated JSON models
```json
{
  "diagram_type": "class",
  "elements": [
    {
      "bases": [],
      "display_name": "A",
      "id": "6919333181322027406",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "A",
      "namespace": "",
      "source_location": {
        "column": 7,
        "file": "t00046.cc",
        "line": 4,
        "translation_unit": "t00046.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "AA",
      "id": "3094982628479217459",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "AA",
      "namespace": "",
      "source_location": {
        "column": 7,
        "file": "t00046.cc",
        "line": 6,
        "translation_unit": "t00046.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "display_name": "ns1",
      "elements": [
        {
          "bases": [],
          "display_name": "A",
          "id": "4957137863549307995",
          "is_abstract": false,
          "is_nested": false,
          "is_struct": false,
          "is_template": false,
          "is_union": false,
          "members": [],
          "methods": [],
          "name": "A",
          "namespace": "ns1",
          "source_location": {
            "column": 7,
            "file": "t00046.cc",
            "line": 10,
            "translation_unit": "t00046.cc"
          },
          "template_parameters": [],
          "type": "class"
        },
        {
          "display_name": "ns2",
          "elements": [
            {
              "bases": [],
              "display_name": "A",
              "id": "17656057552237354746",
              "is_abstract": false,
              "is_nested": false,
              "is_struct": false,
              "is_template": false,
              "is_union": false,
              "members": [],
              "methods": [],
              "name": "A",
              "namespace": "ns1::ns2",
              "source_location": {
                "column": 7,
                "file": "t00046.cc",
                "line": 14,
                "translation_unit": "t00046.cc"
              },
              "template_parameters": [],
              "type": "class"
            },
            {
              "bases": [
                {
                  "access": "public",
                  "id": "17656057552237354746",
                  "is_virtual": false
                }
              ],
              "display_name": "B",
              "id": "1632415880994984623",
              "is_abstract": false,
              "is_nested": false,
              "is_struct": false,
              "is_template": false,
              "is_union": false,
              "members": [],
              "methods": [],
              "name": "B",
              "namespace": "ns1::ns2",
              "source_location": {
                "column": 7,
                "file": "t00046.cc",
                "line": 16,
                "translation_unit": "t00046.cc"
              },
              "template_parameters": [],
              "type": "class"
            },
            {
              "bases": [
                {
                  "access": "public",
                  "id": "4957137863549307995",
                  "is_virtual": false
                }
              ],
              "display_name": "C",
              "id": "14696076436517940251",
              "is_abstract": false,
              "is_nested": false,
              "is_struct": false,
              "is_template": false,
              "is_union": false,
              "members": [],
              "methods": [],
              "name": "C",
              "namespace": "ns1::ns2",
              "source_location": {
                "column": 7,
                "file": "t00046.cc",
                "line": 18,
                "translation_unit": "t00046.cc"
              },
              "template_parameters": [],
              "type": "class"
            },
            {
              "bases": [
                {
                  "access": "public",
                  "id": "17656057552237354746",
                  "is_virtual": false
                }
              ],
              "display_name": "D",
              "id": "16239436487454399847",
              "is_abstract": false,
              "is_nested": false,
              "is_struct": false,
              "is_template": false,
              "is_union": false,
              "members": [],
              "methods": [],
              "name": "D",
              "namespace": "ns1::ns2",
              "source_location": {
                "column": 7,
                "file": "t00046.cc",
                "line": 20,
                "translation_unit": "t00046.cc"
              },
              "template_parameters": [],
              "type": "class"
            },
            {
              "bases": [
                {
                  "access": "public",
                  "id": "6919333181322027406",
                  "is_virtual": false
                }
              ],
              "display_name": "E",
              "id": "18442868286060638176",
              "is_abstract": false,
              "is_nested": false,
              "is_struct": false,
              "is_template": false,
              "is_union": false,
              "members": [],
              "methods": [],
              "name": "E",
              "namespace": "ns1::ns2",
              "source_location": {
                "column": 7,
                "file": "t00046.cc",
                "line": 22,
                "translation_unit": "t00046.cc"
              },
              "template_parameters": [],
              "type": "class"
            },
            {
              "bases": [],
              "display_name": "R",
              "id": "7795444762564711929",
              "is_abstract": false,
              "is_nested": false,
              "is_struct": false,
              "is_template": false,
              "is_union": false,
              "members": [
                {
                  "access": "public",
                  "is_static": false,
                  "name": "a",
                  "source_location": {
                    "column": 8,
                    "file": "t00046.cc",
                    "line": 26,
                    "translation_unit": "t00046.cc"
                  },
                  "type": "A *"
                },
                {
                  "access": "public",
                  "is_static": false,
                  "name": "ns1_a",
                  "source_location": {
                    "column": 13,
                    "file": "t00046.cc",
                    "line": 27,
                    "translation_unit": "t00046.cc"
                  },
                  "type": "ns1::A *"
                },
                {
                  "access": "public",
                  "is_static": false,
                  "name": "ns1_ns2_a",
                  "source_location": {
                    "column": 18,
                    "file": "t00046.cc",
                    "line": 28,
                    "translation_unit": "t00046.cc"
                  },
                  "type": "ns1::ns2::A *"
                },
                {
                  "access": "public",
                  "is_static": false,
                  "name": "root_a",
                  "source_location": {
                    "column": 10,
                    "file": "t00046.cc",
                    "line": 29,
                    "translation_unit": "t00046.cc"
                  },
                  "type": "::A *"
                },
                {
                  "access": "public",
                  "is_static": false,
                  "name": "i",
                  "source_location": {
                    "column": 31,
                    "file": "t00046.cc",
                    "line": 30,
                    "translation_unit": "t00046.cc"
                  },
                  "type": "std::vector<std::uint8_t>"
                }
              ],
              "methods": [
                {
                  "access": "public",
                  "display_name": "foo",
                  "is_const": false,
                  "is_consteval": false,
                  "is_constexpr": false,
                  "is_constructor": false,
                  "is_copy_assignment": false,
                  "is_coroutine": false,
                  "is_defaulted": false,
                  "is_deleted": false,
                  "is_move_assignment": false,
                  "is_noexcept": false,
                  "is_operator": false,
                  "is_pure_virtual": false,
                  "is_static": false,
                  "is_virtual": false,
                  "name": "foo",
                  "parameters": [
                    {
                      "name": "aa",
                      "type": "::AA &"
                    }
                  ],
                  "source_location": {
                    "column": 10,
                    "file": "t00046.cc",
                    "line": 32,
                    "translation_unit": "t00046.cc"
                  },
                  "template_parameters": [],
                  "type": "void"
                }
              ],
              "name": "R",
              "namespace": "ns1::ns2",
              "source_location": {
                "column": 7,
                "file": "t00046.cc",
                "line": 24,
                "translation_unit": "t00046.cc"
              },
              "template_parameters": [],
              "type": "class"
            }
          ],
          "name": "ns2",
          "type": "namespace"
        }
      ],
      "name": "ns1",
      "type": "namespace"
    }
  ],
  "name": "t00046_class",
  "package_type": "namespace",
  "relationships": [
    {
      "access": "public",
      "destination": "17656057552237354746",
      "source": "1632415880994984623",
      "type": "extension"
    },
    {
      "access": "public",
      "destination": "4957137863549307995",
      "source": "14696076436517940251",
      "type": "extension"
    },
    {
      "access": "public",
      "destination": "17656057552237354746",
      "source": "16239436487454399847",
      "type": "extension"
    },
    {
      "access": "public",
      "destination": "6919333181322027406",
      "source": "18442868286060638176",
      "type": "extension"
    },
    {
      "access": "public",
      "destination": "3094982628479217459",
      "source": "7795444762564711929",
      "type": "dependency"
    },
    {
      "access": "public",
      "destination": "17656057552237354746",
      "label": "a",
      "source": "7795444762564711929",
      "type": "association"
    },
    {
      "access": "public",
      "destination": "4957137863549307995",
      "label": "ns1_a",
      "source": "7795444762564711929",
      "type": "association"
    },
    {
      "access": "public",
      "destination": "17656057552237354746",
      "label": "ns1_ns2_a",
      "source": "7795444762564711929",
      "type": "association"
    },
    {
      "access": "public",
      "destination": "6919333181322027406",
      "label": "root_a",
      "source": "7795444762564711929",
      "type": "association"
    }
  ]
}
```
## Generated GraphML models
```xml
<?xml version="1.0"?>
<graphml xmlns="http://graphml.graphdrawing.org/xmlns" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://graphml.graphdrawing.org/xmlns http://graphml.graphdrawing.org/xmlns/1.0/graphml.xsd">
 <key attr.name="id" attr.type="string" for="graph" id="gd0" />
 <key attr.name="diagram_type" attr.type="string" for="graph" id="gd1" />
 <key attr.name="name" attr.type="string" for="graph" id="gd2" />
 <key attr.name="using_namespace" attr.type="string" for="graph" id="gd3" />
 <key attr.name="id" attr.type="string" for="node" id="nd0" />
 <key attr.name="type" attr.type="string" for="node" id="nd1" />
 <key attr.name="name" attr.type="string" for="node" id="nd2" />
 <key attr.name="stereotype" attr.type="string" for="node" id="nd3" />
 <key attr.name="url" attr.type="string" for="node" id="nd4" />
 <key attr.name="tooltip" attr.type="string" for="node" id="nd5" />
 <key attr.name="is_template" attr.type="boolean" for="node" id="nd6" />
 <key attr.name="type" attr.type="string" for="edge" id="ed0" />
 <key attr.name="access" attr.type="string" for="edge" id="ed1" />
 <key attr.name="label" attr.type="string" for="edge" id="ed2" />
 <key attr.name="url" attr.type="string" for="edge" id="ed3" />
 <graph id="g0" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst">
  <node id="n0">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[A]]></data>
   <data key="nd6">false</data>
  </node>
  <node id="n1">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[AA]]></data>
   <data key="nd6">false</data>
  </node>
  <node id="n2">
   <data key="nd2">ns1</data>
   <data key="nd1">namespace</data>
   <graph id="g1" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst">
    <node id="n3">
     <data key="nd1">class</data>
     <data key="nd2"><![CDATA[A]]></data>
     <data key="nd6">false</data>
    </node>
    <node id="n4">
     <data key="nd2">ns2</data>
     <data key="nd1">namespace</data>
     <graph id="g2" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst">
      <node id="n5">
       <data key="nd1">class</data>
       <data key="nd2"><![CDATA[A]]></data>
       <data key="nd6">false</data>
      </node>
      <node id="n6">
       <data key="nd1">class</data>
       <data key="nd2"><![CDATA[B]]></data>
       <data key="nd6">false</data>
      </node>
      <node id="n7">
       <data key="nd1">class</data>
       <data key="nd2"><![CDATA[C]]></data>
       <data key="nd6">false</data>
      </node>
      <node id="n8">
       <data key="nd1">class</data>
       <data key="nd2"><![CDATA[D]]></data>
       <data key="nd6">false</data>
      </node>
      <node id="n9">
       <data key="nd1">class</data>
       <data key="nd2"><![CDATA[E]]></data>
       <data key="nd6">false</data>
      </node>
      <node id="n10">
       <data key="nd1">class</data>
       <data key="nd2"><![CDATA[R]]></data>
       <data key="nd6">false</data>
      </node>
     </graph>
    </node>
   </graph>
  </node>
  <edge id="e0" source="n6" target="n5">
   <data key="ed0">extension</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e1" source="n7" target="n3">
   <data key="ed0">extension</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e2" source="n8" target="n5">
   <data key="ed0">extension</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e3" source="n9" target="n0">
   <data key="ed0">extension</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e4" source="n10" target="n1">
   <data key="ed0">dependency</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e5" source="n10" target="n5">
   <data key="ed0">association</data>
   <data key="ed2">a</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e6" source="n10" target="n3">
   <data key="ed0">association</data>
   <data key="ed2">ns1_a</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e7" source="n10" target="n5">
   <data key="ed0">association</data>
   <data key="ed2">ns1_ns2_a</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e8" source="n10" target="n0">
   <data key="ed0">association</data>
   <data key="ed2">root_a</data>
   <data key="ed1">public</data>
  </edge>
 </graph>
</graphml>

```
