# t00042 - Specialization class template diagram filter test
## Config
```yaml
diagrams:
  t00042_class:
    type: class
    generate_packages: false
    glob:
      - t00042.cc
    using_namespace: clanguml::t00042
    plantuml:
      style:
        instantiation: up
    include:
      specializations:
        - clanguml::t00042::A<T>
        - clanguml::t00042::B<T,K>
      relationships:
        - instantiation
    exclude:
      specializations:
        - clanguml::t00042::C<T>
      namespaces:
        - std
```
## Source code
File `tests/t00042/t00042.cc`
```cpp
#include <string>

namespace clanguml::t00042 {

template <typename T> struct A {
    T a;
};

template <> struct A<void> {
    void *a;
};

template <typename T, typename K> struct B {
    T b;
    K bb;
};

template <typename T> struct C {
    T c;
};

struct R {
    A<double> a_double;
    A<std::string> a_string;

    B<int, float> b_int_float;

    C<int> c_int;
};

} // namespace clanguml::t00042

```
## Generated PlantUML diagrams
![t00042_class](./t00042_class.svg "Specialization class template diagram filter test")
## Generated Mermaid diagrams
![t00042_class](./t00042_class_mermaid.svg "Specialization class template diagram filter test")
## Generated JSON models
```json
{
  "diagram_type": "class",
  "elements": [
    {
      "bases": [],
      "display_name": "A<T>",
      "id": "3697287612638683703",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": true,
      "is_union": false,
      "members": [
        {
          "access": "public",
          "is_static": false,
          "name": "a",
          "source_location": {
            "column": 7,
            "file": "t00042.cc",
            "line": 6,
            "translation_unit": "t00042.cc"
          },
          "type": "T"
        }
      ],
      "methods": [],
      "name": "A",
      "namespace": "clanguml::t00042",
      "source_location": {
        "column": 30,
        "file": "t00042.cc",
        "line": 5,
        "translation_unit": "t00042.cc"
      },
      "template_parameters": [
        {
          "is_variadic": false,
          "kind": "template_type",
          "name": "T",
          "template_parameters": []
        }
      ],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "A<void>",
      "id": "11382418736477356364",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": true,
      "is_union": false,
      "members": [
        {
          "access": "public",
          "is_static": false,
          "name": "a",
          "source_location": {
            "column": 11,
            "file": "t00042.cc",
            "line": 10,
            "translation_unit": "t00042.cc"
          },
          "type": "void *"
        }
      ],
      "methods": [],
      "name": "A",
      "namespace": "clanguml::t00042",
      "source_location": {
        "column": 20,
        "file": "t00042.cc",
        "line": 9,
        "translation_unit": "t00042.cc"
      },
      "template_parameters": [
        {
          "is_variadic": false,
          "kind": "argument",
          "template_parameters": [],
          "type": "void"
        }
      ],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "B<T,K>",
      "id": "11315655475109424087",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": true,
      "is_union": false,
      "members": [
        {
          "access": "public",
          "is_static": false,
          "name": "b",
          "source_location": {
            "column": 7,
            "file": "t00042.cc",
            "line": 14,
            "translation_unit": "t00042.cc"
          },
          "type": "T"
        },
        {
          "access": "public",
          "is_static": false,
          "name": "bb",
          "source_location": {
            "column": 7,
            "file": "t00042.cc",
            "line": 15,
            "translation_unit": "t00042.cc"
          },
          "type": "K"
        }
      ],
      "methods": [],
      "name": "B",
      "namespace": "clanguml::t00042",
      "source_location": {
        "column": 42,
        "file": "t00042.cc",
        "line": 13,
        "translation_unit": "t00042.cc"
      },
      "template_parameters": [
        {
          "is_variadic": false,
          "kind": "template_type",
          "name": "T",
          "template_parameters": []
        },
        {
          "is_variadic": false,
          "kind": "template_type",
          "name": "K",
          "template_parameters": []
        }
      ],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "A<double>",
      "id": "2916307832630615909",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": true,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "A",
      "namespace": "clanguml::t00042",
      "source_location": {
        "column": 15,
        "file": "t00042.cc",
        "line": 23,
        "translation_unit": "t00042.cc"
      },
      "template_parameters": [
        {
          "is_variadic": false,
          "kind": "argument",
          "template_parameters": [],
          "type": "double"
        }
      ],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "A<std::string>",
      "id": "3974186100308641490",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": true,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "A",
      "namespace": "clanguml::t00042",
      "source_location": {
        "column": 20,
        "file": "t00042.cc",
        "line": 24,
        "translation_unit": "t00042.cc"
      },
      "template_parameters": [
        {
          "is_variadic": false,
          "kind": "argument",
          "template_parameters": [],
          "type": "std::string"
        }
      ],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "B<int,float>",
      "id": "14667775452241290878",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": true,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "B",
      "namespace": "clanguml::t00042",
      "source_location": {
        "column": 19,
        "file": "t00042.cc",
        "line": 26,
        "translation_unit": "t00042.cc"
      },
      "template_parameters": [
        {
          "is_variadic": false,
          "kind": "argument",
          "template_parameters": [],
          "type": "int"
        },
        {
          "is_variadic": false,
          "kind": "argument",
          "template_parameters": [],
          "type": "float"
        }
      ],
      "type": "class"
    }
  ],
  "name": "t00042_class",
  "package_type": "namespace",
  "relationships": [
    {
      "access": "public",
      "destination": "3697287612638683703",
      "source": "11382418736477356364",
      "type": "instantiation"
    },
    {
      "access": "public",
      "destination": "3697287612638683703",
      "source": "2916307832630615909",
      "type": "instantiation"
    },
    {
      "access": "public",
      "destination": "3697287612638683703",
      "source": "3974186100308641490",
      "type": "instantiation"
    },
    {
      "access": "public",
      "destination": "11315655475109424087",
      "source": "14667775452241290878",
      "type": "instantiation"
    }
  ],
  "using_namespace": "clanguml::t00042"
}
```
## Generated GraphML models
```xml
<?xml version="1.0"?>
<graphml xmlns="http://graphml.graphdrawing.org/xmlns" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://graphml.graphdrawing.org/xmlns http://graphml.graphdrawing.org/xmlns/1.0/graphml.xsd">
 <key attr.name="id" attr.type="string" for="graph" id="gd0" />
 <key attr.name="diagram_type" attr.type="string" for="graph" id="gd1" />
 <key attr.name="name" attr.type="string" for="graph" id="gd2" />
 <key attr.name="using_namespace" attr.type="string" for="graph" id="gd3" />
 <key attr.name="id" attr.type="string" for="node" id="nd0" />
 <key attr.name="type" attr.type="string" for="node" id="nd1" />
 <key attr.name="name" attr.type="string" for="node" id="nd2" />
 <key attr.name="stereotype" attr.type="string" for="node" id="nd3" />
 <key attr.name="url" attr.type="string" for="node" id="nd4" />
 <key attr.name="tooltip" attr.type="string" for="node" id="nd5" />
 <key attr.name="is_template" attr.type="boolean" for="node" id="nd6" />
 <key attr.name="type" attr.type="string" for="edge" id="ed0" />
 <key attr.name="access" attr.type="string" for="edge" id="ed1" />
 <key attr.name="label" attr.type="string" for="edge" id="ed2" />
 <key attr.name="url" attr.type="string" for="edge" id="ed3" />
 <graph id="g0" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst">
  <data key="gd3">clanguml::t00042</data>
  <node id="n0">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[A<T>]]></data>
   <data key="nd6">true</data>
  </node>
  <node id="n1">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[A<void>]]></data>
   <data key="nd6">true</data>
  </node>
  <node id="n2">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[B<T,K>]]></data>
   <data key="nd6">true</data>
  </node>
  <node id="n3">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[A<double>]]></data>
   <data key="nd6">true</data>
  </node>
  <node id="n4">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[A<std::string>]]></data>
   <data key="nd6">true</data>
  </node>
  <node id="n5">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[B<int,float>]]></data>
   <data key="nd6">true</data>
  </node>
  <edge id="e0" source="n1" target="n0">
   <data key="ed0">instantiation</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e1" source="n3" target="n0">
   <data key="ed0">instantiation</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e2" source="n4" target="n0">
   <data key="ed0">instantiation</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e3" source="n5" target="n2">
   <data key="ed0">instantiation</data>
   <data key="ed1">public</data>
  </edge>
 </graph>
</graphml>

```
