# t00033 - Nested template instantiation dependency test case
## Config
```yaml
diagrams:
  t00033_class:
    type: class
    glob:
      - t00033.cc
    using_namespace: clanguml::t00033
    plantuml:
      style:
        instantiation: up
    include:
      namespaces:
        - clanguml::t00033

```
## Source code
File `tests/t00033/t00033.cc`
```cpp
#include <memory>
#include <vector>

namespace clanguml {
namespace t00033 {

template <typename T> struct A {
    T aaa;
};

template <typename T> struct B {
    T bbb;
};

template <typename T> struct C {
    T ccc;
};

struct D {
    int ddd;
};

struct R {
    A<B<std::unique_ptr<C<D>>>> abc;
};

} // namespace t00033
} // namespace clanguml

```
## Generated PlantUML diagrams
![t00033_class](./t00033_class.svg "Nested template instantiation dependency test case")
## Generated Mermaid diagrams
![t00033_class](./t00033_class_mermaid.svg "Nested template instantiation dependency test case")
## Generated JSON models
```json
{
  "diagram_type": "class",
  "elements": [
    {
      "bases": [],
      "display_name": "A<T>",
      "id": "16288255991845070974",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": true,
      "is_union": false,
      "members": [
        {
          "access": "public",
          "is_static": false,
          "name": "aaa",
          "source_location": {
            "column": 7,
            "file": "t00033.cc",
            "line": 8,
            "translation_unit": "t00033.cc"
          },
          "type": "T"
        }
      ],
      "methods": [],
      "name": "A",
      "namespace": "clanguml::t00033",
      "source_location": {
        "column": 30,
        "file": "t00033.cc",
        "line": 7,
        "translation_unit": "t00033.cc"
      },
      "template_parameters": [
        {
          "is_variadic": false,
          "kind": "template_type",
          "name": "T",
          "template_parameters": []
        }
      ],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "B<T>",
      "id": "6124121870766872188",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": true,
      "is_union": false,
      "members": [
        {
          "access": "public",
          "is_static": false,
          "name": "bbb",
          "source_location": {
            "column": 7,
            "file": "t00033.cc",
            "line": 12,
            "translation_unit": "t00033.cc"
          },
          "type": "T"
        }
      ],
      "methods": [],
      "name": "B",
      "namespace": "clanguml::t00033",
      "source_location": {
        "column": 30,
        "file": "t00033.cc",
        "line": 11,
        "translation_unit": "t00033.cc"
      },
      "template_parameters": [
        {
          "is_variadic": false,
          "kind": "template_type",
          "name": "T",
          "template_parameters": []
        }
      ],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "C<T>",
      "id": "11494683074124422953",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": true,
      "is_union": false,
      "members": [
        {
          "access": "public",
          "is_static": false,
          "name": "ccc",
          "source_location": {
            "column": 7,
            "file": "t00033.cc",
            "line": 16,
            "translation_unit": "t00033.cc"
          },
          "type": "T"
        }
      ],
      "methods": [],
      "name": "C",
      "namespace": "clanguml::t00033",
      "source_location": {
        "column": 30,
        "file": "t00033.cc",
        "line": 15,
        "translation_unit": "t00033.cc"
      },
      "template_parameters": [
        {
          "is_variadic": false,
          "kind": "template_type",
          "name": "T",
          "template_parameters": []
        }
      ],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "D",
      "id": "17596650934155389102",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": false,
      "is_union": false,
      "members": [
        {
          "access": "public",
          "is_static": false,
          "name": "ddd",
          "source_location": {
            "column": 9,
            "file": "t00033.cc",
            "line": 20,
            "translation_unit": "t00033.cc"
          },
          "type": "int"
        }
      ],
      "methods": [],
      "name": "D",
      "namespace": "clanguml::t00033",
      "source_location": {
        "column": 8,
        "file": "t00033.cc",
        "line": 19,
        "translation_unit": "t00033.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "C<D>",
      "id": "12875568356832433931",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": true,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "C",
      "namespace": "clanguml::t00033",
      "source_location": {
        "column": 33,
        "file": "t00033.cc",
        "line": 24,
        "translation_unit": "t00033.cc"
      },
      "template_parameters": [
        {
          "is_variadic": false,
          "kind": "argument",
          "template_parameters": [],
          "type": "D"
        }
      ],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "B<std::unique_ptr<C<D>>>",
      "id": "3079418528655831151",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": true,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "B",
      "namespace": "clanguml::t00033",
      "source_location": {
        "column": 33,
        "file": "t00033.cc",
        "line": 24,
        "translation_unit": "t00033.cc"
      },
      "template_parameters": [
        {
          "is_variadic": false,
          "kind": "argument",
          "template_parameters": [
            {
              "is_variadic": false,
              "kind": "argument",
              "template_parameters": [
                {
                  "is_variadic": false,
                  "kind": "argument",
                  "template_parameters": [],
                  "type": "clanguml::t00033::D"
                }
              ],
              "type": "clanguml::t00033::C"
            }
          ],
          "type": "std::unique_ptr"
        }
      ],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "A<B<std::unique_ptr<C<D>>>>",
      "id": "13979951723362730013",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": true,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "A",
      "namespace": "clanguml::t00033",
      "source_location": {
        "column": 33,
        "file": "t00033.cc",
        "line": 24,
        "translation_unit": "t00033.cc"
      },
      "template_parameters": [
        {
          "is_variadic": false,
          "kind": "argument",
          "template_parameters": [
            {
              "is_variadic": false,
              "kind": "argument",
              "template_parameters": [
                {
                  "is_variadic": false,
                  "kind": "argument",
                  "template_parameters": [
                    {
                      "is_variadic": false,
                      "kind": "argument",
                      "template_parameters": [],
                      "type": "clanguml::t00033::D"
                    }
                  ],
                  "type": "clanguml::t00033::C"
                }
              ],
              "type": "std::unique_ptr"
            }
          ],
          "type": "B"
        }
      ],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "R",
      "id": "14931141650502131764",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": false,
      "is_union": false,
      "members": [
        {
          "access": "public",
          "is_static": false,
          "name": "abc",
          "source_location": {
            "column": 33,
            "file": "t00033.cc",
            "line": 24,
            "translation_unit": "t00033.cc"
          },
          "type": "A<B<std::unique_ptr<C<D>>>>"
        }
      ],
      "methods": [],
      "name": "R",
      "namespace": "clanguml::t00033",
      "source_location": {
        "column": 8,
        "file": "t00033.cc",
        "line": 23,
        "translation_unit": "t00033.cc"
      },
      "template_parameters": [],
      "type": "class"
    }
  ],
  "name": "t00033_class",
  "package_type": "namespace",
  "relationships": [
    {
      "access": "public",
      "destination": "17596650934155389102",
      "source": "12875568356832433931",
      "type": "dependency"
    },
    {
      "access": "public",
      "destination": "11494683074124422953",
      "source": "12875568356832433931",
      "type": "instantiation"
    },
    {
      "access": "public",
      "destination": "12875568356832433931",
      "source": "3079418528655831151",
      "type": "dependency"
    },
    {
      "access": "public",
      "destination": "6124121870766872188",
      "source": "3079418528655831151",
      "type": "instantiation"
    },
    {
      "access": "public",
      "destination": "3079418528655831151",
      "source": "13979951723362730013",
      "type": "dependency"
    },
    {
      "access": "public",
      "destination": "16288255991845070974",
      "source": "13979951723362730013",
      "type": "instantiation"
    },
    {
      "access": "public",
      "destination": "13979951723362730013",
      "label": "abc",
      "source": "14931141650502131764",
      "type": "aggregation"
    }
  ],
  "using_namespace": "clanguml::t00033"
}
```
## Generated GraphML models
```xml
<?xml version="1.0"?>
<graphml xmlns="http://graphml.graphdrawing.org/xmlns" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://graphml.graphdrawing.org/xmlns http://graphml.graphdrawing.org/xmlns/1.0/graphml.xsd">
 <key attr.name="id" attr.type="string" for="graph" id="gd0" />
 <key attr.name="diagram_type" attr.type="string" for="graph" id="gd1" />
 <key attr.name="name" attr.type="string" for="graph" id="gd2" />
 <key attr.name="using_namespace" attr.type="string" for="graph" id="gd3" />
 <key attr.name="id" attr.type="string" for="node" id="nd0" />
 <key attr.name="type" attr.type="string" for="node" id="nd1" />
 <key attr.name="name" attr.type="string" for="node" id="nd2" />
 <key attr.name="stereotype" attr.type="string" for="node" id="nd3" />
 <key attr.name="url" attr.type="string" for="node" id="nd4" />
 <key attr.name="tooltip" attr.type="string" for="node" id="nd5" />
 <key attr.name="is_template" attr.type="boolean" for="node" id="nd6" />
 <key attr.name="type" attr.type="string" for="edge" id="ed0" />
 <key attr.name="access" attr.type="string" for="edge" id="ed1" />
 <key attr.name="label" attr.type="string" for="edge" id="ed2" />
 <key attr.name="url" attr.type="string" for="edge" id="ed3" />
 <graph id="g0" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst">
  <data key="gd3">clanguml::t00033</data>
  <node id="n0">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[A<T>]]></data>
   <data key="nd6">true</data>
  </node>
  <node id="n1">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[B<T>]]></data>
   <data key="nd6">true</data>
  </node>
  <node id="n2">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[C<T>]]></data>
   <data key="nd6">true</data>
  </node>
  <node id="n3">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[D]]></data>
   <data key="nd6">false</data>
  </node>
  <node id="n4">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[C<D>]]></data>
   <data key="nd6">true</data>
  </node>
  <node id="n5">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[B<std::unique_ptr<C<D>>>]]></data>
   <data key="nd6">true</data>
  </node>
  <node id="n6">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[A<B<std::unique_ptr<C<D>>>>]]></data>
   <data key="nd6">true</data>
  </node>
  <node id="n7">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[R]]></data>
   <data key="nd6">false</data>
  </node>
  <edge id="e0" source="n4" target="n3">
   <data key="ed0">dependency</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e1" source="n4" target="n2">
   <data key="ed0">instantiation</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e2" source="n5" target="n4">
   <data key="ed0">dependency</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e3" source="n5" target="n1">
   <data key="ed0">instantiation</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e4" source="n6" target="n5">
   <data key="ed0">dependency</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e5" source="n6" target="n0">
   <data key="ed0">instantiation</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e6" source="n7" target="n6">
   <data key="ed0">aggregation</data>
   <data key="ed2">abc</data>
   <data key="ed1">public</data>
  </edge>
 </graph>
</graphml>

```
