# t00011 - Friend relationships
## Config
```yaml
diagrams:
  t00011_class:
    type: class
    glob:
      - t00011.cc
    using_namespace: clanguml::t00011
    include:
      namespaces:
        - clanguml::t00011

```
## Source code
File `tests/t00011/t00011.cc`
```cpp
namespace external {
class C { };
}

namespace clanguml {
namespace t00011 {

class B;

template <typename T> class D {
    T value;
};

class A {
public:
    void foo() { }
    friend class B;
    friend class external::C;
    // TODO
    template <typename T> friend class D;
    // TODO
    friend class D<int>;
    friend class D<A>;
};

class B {
public:
    void foo() { m_a->foo(); }
    A *m_a;
};
} // namespace t00011
} // namespace clanguml

```
## Generated PlantUML diagrams
![t00011_class](./t00011_class.svg "Friend relationships")
## Generated Mermaid diagrams
![t00011_class](./t00011_class_mermaid.svg "Friend relationships")
## Generated JSON models
```json
{
  "diagram_type": "class",
  "elements": [
    {
      "bases": [],
      "display_name": "D<T>",
      "id": "9205119221984418212",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": true,
      "is_union": false,
      "members": [
        {
          "access": "private",
          "is_static": false,
          "name": "value",
          "source_location": {
            "column": 7,
            "file": "t00011.cc",
            "line": 11,
            "translation_unit": "t00011.cc"
          },
          "type": "T"
        }
      ],
      "methods": [],
      "name": "D",
      "namespace": "clanguml::t00011",
      "source_location": {
        "column": 29,
        "file": "t00011.cc",
        "line": 10,
        "translation_unit": "t00011.cc"
      },
      "template_parameters": [
        {
          "is_variadic": false,
          "kind": "template_type",
          "name": "T",
          "template_parameters": []
        }
      ],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "A",
      "id": "11364135622862429756",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [
        {
          "access": "public",
          "display_name": "foo",
          "is_const": false,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": false,
          "is_pure_virtual": false,
          "is_static": false,
          "is_virtual": false,
          "name": "foo",
          "parameters": [],
          "source_location": {
            "column": 10,
            "file": "t00011.cc",
            "line": 16,
            "translation_unit": "t00011.cc"
          },
          "template_parameters": [],
          "type": "void"
        }
      ],
      "name": "A",
      "namespace": "clanguml::t00011",
      "source_location": {
        "column": 7,
        "file": "t00011.cc",
        "line": 14,
        "translation_unit": "t00011.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "B",
      "id": "13499420831616398636",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": false,
      "is_union": false,
      "members": [
        {
          "access": "public",
          "is_static": false,
          "name": "m_a",
          "source_location": {
            "column": 8,
            "file": "t00011.cc",
            "line": 29,
            "translation_unit": "t00011.cc"
          },
          "type": "A *"
        }
      ],
      "methods": [
        {
          "access": "public",
          "display_name": "foo",
          "is_const": false,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": false,
          "is_pure_virtual": false,
          "is_static": false,
          "is_virtual": false,
          "name": "foo",
          "parameters": [],
          "source_location": {
            "column": 10,
            "file": "t00011.cc",
            "line": 28,
            "translation_unit": "t00011.cc"
          },
          "template_parameters": [],
          "type": "void"
        }
      ],
      "name": "B",
      "namespace": "clanguml::t00011",
      "source_location": {
        "column": 7,
        "file": "t00011.cc",
        "line": 26,
        "translation_unit": "t00011.cc"
      },
      "template_parameters": [],
      "type": "class"
    }
  ],
  "name": "t00011_class",
  "package_type": "namespace",
  "relationships": [
    {
      "access": "public",
      "destination": "13499420831616398636",
      "label": "<<friend>>",
      "source": "11364135622862429756",
      "type": "friendship"
    },
    {
      "access": "public",
      "destination": "11364135622862429756",
      "label": "m_a",
      "source": "13499420831616398636",
      "type": "association"
    }
  ],
  "using_namespace": "clanguml::t00011"
}
```
## Generated GraphML models
```xml
<?xml version="1.0"?>
<graphml xmlns="http://graphml.graphdrawing.org/xmlns" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://graphml.graphdrawing.org/xmlns http://graphml.graphdrawing.org/xmlns/1.0/graphml.xsd">
 <key attr.name="id" attr.type="string" for="graph" id="gd0" />
 <key attr.name="diagram_type" attr.type="string" for="graph" id="gd1" />
 <key attr.name="name" attr.type="string" for="graph" id="gd2" />
 <key attr.name="using_namespace" attr.type="string" for="graph" id="gd3" />
 <key attr.name="id" attr.type="string" for="node" id="nd0" />
 <key attr.name="type" attr.type="string" for="node" id="nd1" />
 <key attr.name="name" attr.type="string" for="node" id="nd2" />
 <key attr.name="stereotype" attr.type="string" for="node" id="nd3" />
 <key attr.name="url" attr.type="string" for="node" id="nd4" />
 <key attr.name="tooltip" attr.type="string" for="node" id="nd5" />
 <key attr.name="is_template" attr.type="boolean" for="node" id="nd6" />
 <key attr.name="type" attr.type="string" for="edge" id="ed0" />
 <key attr.name="access" attr.type="string" for="edge" id="ed1" />
 <key attr.name="label" attr.type="string" for="edge" id="ed2" />
 <key attr.name="url" attr.type="string" for="edge" id="ed3" />
 <graph id="g0" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst">
  <data key="gd3">clanguml::t00011</data>
  <node id="n0">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[D<T>]]></data>
   <data key="nd6">true</data>
  </node>
  <node id="n1">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[A]]></data>
   <data key="nd6">false</data>
  </node>
  <node id="n2">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[B]]></data>
   <data key="nd6">false</data>
  </node>
  <edge id="e0" source="n1" target="n2">
   <data key="ed0">friendship</data>
   <data key="ed2">&lt;&lt;friend&gt;&gt;</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e1" source="n2" target="n1">
   <data key="ed0">association</data>
   <data key="ed2">m_a</data>
   <data key="ed1">public</data>
  </edge>
 </graph>
</graphml>

```
