(in-package :cl-isaac/test)

(define-test (cl-isaac isaac32)
  (with-fixtures '(*isaac32-ctx*)
    (setf *isaac32-ctx* (isaac:init-null-seed))
    (of-type isaac:isaac-ctx *isaac32-ctx*)
    (of-type null (isaac:generate-next-isaac-block *isaac32-ctx*))
    (of-type (unsigned-byte 32) (isaac:rand32 *isaac32-ctx*))
    (is <= #xFF (integer-length (isaac:rand-bits *isaac32-ctx* #xFF)))
    (true (isaac::incf-wrap32 (aref (isaac-ctx-randrsl *isaac32-ctx*) (random #xFF))
                              (aref (isaac-ctx-randrsl *isaac32-ctx*) (random #xFF))))
    (true (isaac:mix (aref (isaac-ctx-randrsl *isaac32-ctx*) (random #xFF))
                     (aref (isaac-ctx-randrsl *isaac32-ctx*) (random #xFF))
                     (aref (isaac-ctx-randrsl *isaac32-ctx*) (random #xFF))
                     (aref (isaac-ctx-randrsl *isaac32-ctx*) (random #xFF))
                     (aref (isaac-ctx-randrsl *isaac32-ctx*) (random #xFF))
                     (aref (isaac-ctx-randrsl *isaac32-ctx*) (random #xFF))
                     (aref (isaac-ctx-randrsl *isaac32-ctx*) (random #xFF))
                     (aref (isaac-ctx-randrsl *isaac32-ctx*) (random #xFF))))
    (true (isaac:scramble *isaac32-ctx*))))
