(in-package :gtk-testsuite)

(def-suite gio-content-type :in gio-suite)
(in-suite gio-content-type)

;;;   g_content_type_equals
;;;   g_content_type_is_a
;;;   g_content_type_is_unknown

;;;   g_content_type_get_description

#+nil
(test g-content-type-get-description
  (is (equal '("WebM-Video" "CGM-Datei" "XPInstall-Installermodul"
 "Linux-PSF-Konsolenschrift (gzip-komprimiert)" "DTSHD-Audio"
 "OpenOffice.org 1.0 Zeichnung" "JavaFX-Video" "Matroska-Video"
 "Haansoft-Hangul-Dokumentvorlage" "RTF-Textdokument" "Flash-Video"
 "Haansoft-Hangul-Dokument" "ODC-Vorlage" "Comic-Book-Archiv" "StuffIt-Archiv"
 "OpenDocument Zeichnung (Flaches XML)" "SGML-Dokument" "AbiWord-Dokument"
 "Comic-Book-Archiv" "Comic-Book-Archiv" "WWF-Dokument" "SubViewer-Untertitel"
 "Angereichertes Textdokument" "TeX-Schrift" "Sieve-E-Mail-Filterskript"
 "RTF-Dokument" "ATK-Inset" "SystemVerilog-Quellcode"
 "Liste widerrufener Zertifikate" "OpenOffice.org 1.0 Textdokumentvorlage"
 "SMAF-Audio" "SX/Xspread-Tabelle" "Einhängepunkt" "Haskell-Quelltext"
 "SPSS portable Datendatei" "Olympus-ORF-Rohbild" "Lilypond-Notenblatt"
 "E-Mail-Nachrichtenfragment" "VRML-Dokument" "Scribus-Dokument" "WML-Dokument"
 "txt2tags-Dokument" "Shell-Skript" "SQL-Befehle" "RAR-Archiv" "X11-Zeiger"
 "Photoshop-Bild" "OpenDocument Zeichnungsdokumentvorlage" "RIFF-Audio"
 "Audio-DVD" "FLAC-Audio" "Wissenschaftlicher Graphite-Graph"
 "Animierter Windows-Cursor" "Tar-Archiv (komprimiert)" "PNM-Bild"
 "MacOS-X-Symbol" "MathML-Dokument" "Komprimiertes SVG-Bild"
 "StarChart-Diagramm" "Übersetzte Meldungen (maschinenlesbar)"
 "Isolierte OpenPGP-Signatur" "Zoo-Archiv" "Java-Bytecode" "WRI-Dokument"
 "GSM-06.10-Audio" "Windows-Media-Streamingbeschreibung" "Comic-Book-Archiv"
 "WMF-Bild" "Dreamcast-ROM" "SMIL-Dokument" "PDF-Dokument (bzip-komprimiert)"
 "XFig-Bild" "Quicken-Dokument" "Go-Quellcode"
 "Portables Audio-Wiedergabegerät" "XML-Dokument-Entitäten" "COBOL-Quelldatei"
 "LZO-Archiv" "FPX-Bild" "NFO-Dokument" "Webanwendungscache-Manifest"
 "Plucker-Dokument" "V-Schrift" "UNIX Software" "BitTorrent-Seed-Datei"
 "Microsoft-Document-Imaging-Bildformat" "Kivio-Flussdiagramm"
 "»Pathetic Writer«-Dokument" "Tar-Archiv (LZO-komprimiert)" "Video-DVD"
 "Nachrichtensammlung" "WebM-Audio" "Microsoft PowerPoint Präsentationsvorlage"
 "Apple-Datenträgerabbild" "Nachrichtenkatalog" "MacPaint-Bitmap-Datei"
 "LIBGRX-Schrift" "Socket" "Sony-SRF-Rohbild"
 "KML geographische komprimierte Daten" "OCL-Datei" "ODI-Bild"
 "E-Mail-Zustellungsbericht" "PlanPerfect-Tabelle" "ACE-Archiv" "TIFF-Bild"
 "T602-Dokument" "Verweis auf entfernte Datei" "Kodak-KDC-Rohbild"
 "Excel Add-in" "Adobe-FrameMaker-MIF-Dokument" "Eiffel-Quelltext" "XMF-Audio"
 "Annodex-Audio" "Pascal-Quelltext" "PGP/MIME-verschlüsselter Nachrichtenkopf"
 "Unbekannt" "MPEG-Video" "Makefile" "OpenDocument Text"
 "Datenstrom (Server-Push)" "eMusic-Download-Paket" "WavPack-Audio"
 "Tar-Archiv (bzip-komprimiert)" "RealAudio-Dokument"
 "iptables-Konfigurationsdatei" "CD-Inhaltsverzeichnis" "ISI-Video" "ASF-Video"
 "OpenOffice.org 1.0 Zeichnungsvorlage" "VHDL-Quellcode" "EPS-Bild"
 "KFormula-Formel" "X-Window-Bild" "Microsoft-Symbol" "LibreOffice Extension"
 "LZMA-Archiv" "WBMP-Bild" "7zip-Archiv" "Blu-ray-Videoscheibe" "XPM-Bild"
 "Sony-SR2-Rohbild" "Signierte Nachricht" "Scala-Quellcode" "C++-Quelltext"
 "Musepack-Audio" "Unterschiede zwischen Dateien" "TrueAudio-Audio"
 "PAK-Archiv" "Ogg-Theora-Video" "Applix-Graphics-Bild"
 "Microsoft Excel Arbeitsblatt" "Game-Boy-Advance-ROM" "Office-Zeichnung"
 "Bild-CD" "SystemVerilog-Header" "Glade-Projekt" "ANIM-Animation"
 "KSysV-Init-Paket" "XMI-Datei" "XSLT-Stylesheet" "StarWriter-Dokument"
 "WMLScript-Programm" "OpenDocument Formel" "VOC-Audio"
 "RPM-Spezifikationsdatei" "Word-Dokument mit aktivierten Makros"
 "Dateibasiertes Kexi-Datenbankprojekt" "Dateibasiertes Kexi-Datenbankprojekt"
 "PPM-Bild" "LHZ-Archiv" "Matroska 3D Video" "Internet-Verweis"
 "Erlang-Quelltext" "Zeichenorientiertes Gerät" "Mathematica-Dokument"
 "Ressourcenort" "Windows-Media-Audio" "FreeFileSync database file" "MXF-Video"
 "PGN-Schachspielnotation" "JNLP-Datei" "Ustar-Archiv" "README-Dokument"
 "RealTimeSync configuration file" "ODF-Vorlage" "LDIF-Adressbuch"
 "C#-Quelltext" "FLTK-Fluid-Datei" "»Scream Tracker«-Audio"
 "PKCS#10-Zertifikatanfrage" "LHA-Archiv" "Blockorientiertes Gerät"
 "TriG-RDF-Dokument" "WordPerfect/DrawPerfect-Bild" "PBM-Bild"
 "Microsoft Excel Arbeitsblattsvorlage" "Apport crash file" "Speedo-Schrift"
 "Microsoft PowerPoint Präsentationsvorlage" "MHTML-Web-Archiv" "Android-Paket"
 "YAML-Dokument" "Adobe-FrameMaker-Dokument" "OCaml-Quelltext"
 "KChart-Diagramm" "Microsoft-Works-Dokument" "SIS-Paket" "Speex-Audio"
 "Annodex-Video" "NullSoft-Video" "Bzip-Archiv" "Matroska-Audio"
 "Quelltext-RPM-Paket" "Adobe-Schriftmetriken" "EMF-Bild" "Vivo-Video"
 "Nikon-NEF-Rohbild" "BDF-Schrift" "Enlightenment-Thema" "MP3-Audio" "M4-Makro"
 "AR-Archiv" "DTD-Datei" "OpenDocument Präsentation (Flaches XML)"
 "SunOS-News-Schrift" "QuickTime-Metalink-Wiedergabeliste" "Lzip-Archiv"
 "PCD-Bild" "Objective-C-Quelltext" "SPSS-Datendatei" "JPEG-2000-Bild"
 "DTS-Audio" "TeX-DVI-Dokument (bzip-komprimiert)"
 "OpenRaster-Archivierungsbild" "MPSub-Untertitel" "Nautilus-Verknüpfung"
 "Siag-Tabelle" "Tar-Archiv (lrzip-komprimiert)" "3GPP2-Multimediadatei"
 "WebVTT-Untertitel" "Sun-Rasterbild" "Sony-ARW-Rohbild" "DICOM-Bild"
 "»Lotus AmiPro«-Dokument" "Ada-Quelltext" "TeX-DVI-Dokument"
 "Gnuplot-Dokument" "WOFF-Schrift" "XBM-Bild"
 "PostScript-Dokument (gzip-komprimiert)" "Digitale Fotos" "Audio-CD"
 "Autorendanksagung" "Verschlüsselte Nachricht" "DSSSL-Dokument"
 "HTML-Dokument" "GIMP-Bild" "AportisDoc-Dokument" "PEF-Programm"
 "Scream-Tracker-3-Audio" "StarImpress-Präsentation" "Microsoft Word Dokument"
 "OpenDocument Präsentationsdokumentvorlage" "Gemeinsame libtool-Bibliothek"
 "Ogg-Speex-Audio" "WAIS-Quelltext" "Minolta-MRW-Rohbild" "SSA-Untertitel"
 "FLIC-Animation" "BibTeX-Dokument" "Java JCE-Schlüsselbund" "GNUnet-Suchdatei"
 "PKCS#7-Nachricht oder -Zertifikat" "Shell-Archiv" "Adobe-FrameMaker-Schrift"
 "Markaby-Skript" "MPEG-Video (Datenstrom)" "GNU-Mail-Nachricht" "PCL-Datei"
 "Word-Dokumentvorlage mit aktivierten Makros" "PCF-Schrift"
 "Microsoft Publisher Dokument" "Karbon14-Zeichnung" "OGM-Video"
 "Vala-Quelltext" "G3-Faxbild" "Windows-Software" "Scheme-Quelltext"
 "OpenDocument Präsentation" "Hilfeseite" "Qt-Designer-Datei"
 "KIllustrator-Zeichnung" "Windows-Imaging-Format-Datenträgerabbild"
 "CD-Roh-Abbild" "CPIO-Archiv (gzip-komprimiert)" "C++-Header" "Nintendo64-ROM"
 "E-Mail-Kopfzeilen" "CD-Abbild-Cuesheet" "SV4-CPIO-Archiv" "TNEF-Nachricht"
 "»Impulse Tracker«-Audio"
 "Kexi-Einstellungen für Verbindung zum Datenbankserver" "AIFF/Amiga/Mac-Audio"
 "PkiPath-Zertifikatspfad" "Microsoft Excel Arbeitsblatt" "AIFC-Audio"
 "Cisco-VPN-Einstellungen" "AmazonMP3-Download-Datei" "PowerPoint Add-in"
 "TeXInfo-Dokument" "Java-Quelltext" "GTK+ Builder" "Emacs-Lisp-Quelltext"
 "Troff-MS-Eingabedokument" "PDF-Dokument (gzip-komprimiert)"
 "Elektronisches Buch" "JavaScript-Programm" "Troff-MM-Eingabedokument"
 "GML-Dokument" "FITS-Dokument" "CHM-Dokument" "PDF-Dokument (XZ-komprimiert)"
 "SAMI-Untertitel" "Troff-ME-Eingabedokument" "»Applix Spreadsheets«-Tabelle"
 "Modelica-Modell" "Microsoft PowerPoint Präsentation" "PSFlib-Audiobibliothek"
 "Quattro-Pro-Tabelle" "RELAX NG XML-Schema" "Shorten-Audio" "BCPIO-Dokument"
 "DV-Video" "SubRip-Untertitel" "CCMX-Farbverbesserungsdatei"
 "E-Mail-Systembericht" "TeX-Schriftmetriken" "Python-Skript"
 "Panasonic raw2-Bild" "Genesis-ROM" "SDP-Multicast-Datenstromdatei"
 "Corel-Draw-Zeichnung" "OpenOffice.org 1.0 Präsentationsvorlage"
 "JBuilder-Projekt" "LightWave-Szene" "DIB-Bild" "TGA-Bild"
 "HTTP Live-Streaming-Wiedergabeliste" "LightWave-Objekt"
 "Microsoft-ASX-Wiedergabeliste" "C-Shell-Skript" "PSF-Audio" "AWK-Skript"
 "KML geographische Daten" "PowerPoint-Präsentation mit aktivierten Makros"
 "Leere CD" "Troff-Dokument" "Rohes Disk-Abbild (XZ-komprimiert)"
 "Gepackte Schriftdatei" "PKCS#8 Geheimer Schlüssel" "Commodore-64-Audio"
 "Microsoft Visio-Dokument" "iRiver-Wiedergabeliste" "IDL-Dokument" "PCM-Audio"
 "SPKAC Certificate Request" "Tar-Archiv (gzip-komprimiert)"
 "Linux-PSF-Konsolenschrift" "IFF-Datei" "WavPack-Audiokorrekturdatei"
 "GnuCash-Finanzdaten" "RDF-Datei" "MPEG-4-Video" "MNG-Animation"
 "X-Motif-UIL-Tabelle" "DOS/Windows-Programm"
 "Tabellenkalkulations-Austauschdokument" "Leeres Blu-Ray-Medium"
 "Ogg-Vorbis-Audio" "EPS-Bild (bzip-komprimiert)"
 "Excel-Tabelle mit aktivierten Makros" "Microsoft PowerPoint Präsentation"
 "Daten zu Programmabsturz" "Macintosh-Datei (BinHex-kodiert)"
 "Microsoft-Cabinet-Archiv" "Opus Tondatei" "PGM-Bild" "Verilog-Quellcode"
 "NewzBin-Usenet-Index" "Tar-Archiv (LZMA-komprimiert)" "KWord-Dokument"
 "Microsoft Word Dokument" "SGI-Bild" "CCITT-G3-Fax" "PS-Dokument"
 "Excel 2007-Tabelle (binär)" "Video-CD" "Lrzip-Archiv" "Pocket-Word-Dokument"
 "Sega-Master-System/Game-Gear-ROM" "Markdown-Dokument" "TrueType-XML-Schrift"
 "RealPix-Dokument" "Dia-Diagramm"
 "SPKAC Certificate Request in OpenSSL format"
 "FreeFileSync configuration file" "Microsoft Word Dokument" "D-Quelltext"
 "Super-NES-ROM" "StarMath-Formel" "Applix-Words-Dokument"
 "PowerPoint-Präsentation mit aktivierten Makros" "TrueType-Schrift"
 "MPEG-4-Audio" "MP2-Audio" "HPGL-Datei" "KPovModeler-Szene" "Thema"
 "Skencil-Dokument" "XUL-Oberflächendokument" "Übersetzungsdatei"
 "SGF-Aufzeichnung" "Java-Archiv" "RPM-Paket" "Setext-Dokument"
 "Monkey's-Audio" "Brasero-Projektdatei" "WAV-Audio" "Windows-Registry-Auszug"
 "Gzip-Archiv" "KPresenter-Präsentation" "Lotus Word Pro" "KSpread-Tabelle"
 "Excel-Tabellenvorlage mit aktivierten Makros" "AMR-Audio" "Software"
 "E-Book-Leser" "CSS-Stilvorlage" "CSV-Dokument" "RGB-Bild" "GMC-Verweis"
 "Profiler-Ergebnisse" "Netzwerk-Paketmitschnitt"
 "Citrix-ICA-Einstellungsdatei" "Themenpaket für Microsoft Windows"
 "ODB-Datenbank" "ASP-Seite" "Perl-Skript" "OLE2-Verbunddokumentenspeicher"
 "PostScript-Dokument (bzip-komprimiert)" "QtiPlot-Dokument" "Ogg-Video"
 "XLIFF-Übersetzung" "Pack200-Java-Archiv" "Metalink-Datei"
 "DirectDraw-Oberfläche" "Canon-CRW-Rohbild" "Kodak-DCR-Rohbild" "DPX-Bild"
 "Leeres Dokument" "Digitales Rohbild" "WPL-Wiedergabeliste"
 "Einfaches Textdokument" "AVI-Video" "Annodex-Wechselformat"
 "PowerPoint 2007-Folie" "OpenDocument Textdokumentvorlage" "Stampede-Paket"
 "HDF-Dokument" "RealMedia-Metadatei" "Metalink-Datei" "MP3-Audio (Stream)"
 "»Macintosh Quickdraw/PICT«-Zeichnung" "ARJ-Archiv" "XBEL-Lesezeichen"
 "PGP-Schlüssel" "Ogg-Multimediadatei" "TeX-DVI-Dokument (gzip-komprimiert)"
 "Ruby-Skript" "ARC-Archiv" "Sicherungsdatei" "WordPerfect-Dokument"
 "Blender-Szene" "QuickTime-Video" "OPML-Nachrichtenquelle"
 "Änderungsprotokoll" "IEF-Bild" "Ogg-Audio" "Komprimiertes GIMP-Bild"
 "Qt-Auszeichnungssprachendatei" "Pentax-PEF-Rohbild" "GIF-Bild" "LyX-Dokument"
 "Microsoft Word Dokument" "Fuji-RAF-Rohbild" "uuencoded-Datei"
 "PKCS#7 Message and Certificates in PEM format" "Programm"
 "Mup-Veröffentlichung" "PDF-Dokument" "Macintosh-MacBinary-Datei" "JPEG-Bild"
 "OpenDocument Text (Flaches XML)" "Gnumeric-Tabelle" "»Game Boy«-ROM"
 "LHS-Quelltext" "Usenet-News-Nachricht" "Canon-CR2-Rohbild"
 "PKCS#12 Personal Key and Certificates in PEM format"
 "Postscript-Typ-1-Schrift" "ECMAScript-Programm" "RealText-Dokument"
 "Microsoft Word Dokumentvorlage" "Abgelehnter Patch" "CMake-Quelltext"
 "Troff-Dokument (mit man-Seitenmakros)" "Desktop-Konfigurationsdatei"
 "PowerPoint-2007-Präsentation" "Atom-Nachrichtenquelle" "DocBook-Dokument"
 "Isolierte S/MIME-Signatur" "Gemeinsame Bibliothek" "WinHelp-Hilfedatei"
 "Openssl PEM format" "MATLAB-Skript/-Funktion" "PKCS#12-Zertifikatspaket"
 "SGI-Video" "TeX-Dokument" "MPEG-4-Hörbuch"
 "OpenOffice.org 1.0 Tabellendokumentvorlage" "Matroska-Datenstrom"
 "Autorenliste" "OpenDocument Globaldokument" "JAD-Dokument"
 "MicroDVD-Untertitel" "CPIO-Archiv" "HD-DVD-Videoscheibe"
 "Shockwave-Flash-Datei" "FictionBook-Dokument" "Kontour-Zeichnung"
 "OOC-Quellcode" "JET-Datenbank" "RealVideo-Dokument" "eml document"
 "Rohes Disk-Abbild" "VCS/ICS-Kalender" "Lua-Skript" "Egon-Animator-Animation"
 "C-Quelltext" "PKCS#10 Certificate Request in PEM format"
 "Software sources list" "MSX-ROM" "ODA-Dokument" "OpenOffice.org 1.0 Formel"
 "Graphviz-DOT-Graph" "SV4-CPIO-Archiv (mit CRC)" "Super-Video-CD"
 "GNU-Oleo-Tabelle" "OpenDocument Zeichnung" "Google Video Pointer"
 "PKCS#8 Personal Key in PEM format" "Tcl-Skript"
 "OpenDocument Tabellendokument" "Macintosh-Datei (AppleDouble-kodiert)"
 "CMU-Rasterbild" "PKCS#7-Nachricht oder -Zertifikat" "Pipe" "DXF-Vektorbild"
 "MIDI-Audio" "DOS-Schrift" "AutoCAD-Bild" "GEDCOM-Stammbaum"
 "ToutDoux-Dokument" "NES-ROM" "»Dolby Digital«-Audio" "DjVu-Bild"
 "»Lotus 1-2-3«-Tabelle" "MPEG-2-Transportstrom" "Panasonic-Rohbild"
 "Nintendo-DS-ROM" "OpenOffice.org 1.0 Präsentation" "Allgemeine Schriftdatei"
 "Installationsanleitung" "StarCalc-Tabelle" "Mailbox-Datei" "Objekt-Code"
 "StarDraw-Zeichnung" "AAC-Audio" "Gespeicherte Suche"
 "OpenOffice.org 1.0 Textdokument" "Kodak-K25-Rohbild"
 "Unidata-NetCDF-Dokument" "XSPF-Wiedergabeliste" "SQLite3-Datenbank"
 "SQLite2-Datenbank" "Mozilla-Lesezeichen" "Amiga-SoundTracker-Audio"
 "Python-Bytecode" "Windows Installationspaket" "RealMedia-Dokument"
 "»Adobe Illustrator«-Dokument" "OpenOffice.org 1.0 Globaldokument"
 "ICC-Profil" "Alzip-Archiv" "XSL-FO-Datei"
 "OpenDocument Tabellendokument (Flaches XML)" "GTKtalog-Katalog"
 "Java-Schlüsselbund" "RSS-Zusammenfassung" "UNIX-komprimierte Datei"
 "Microsoft Word Dokumentvorlage" "Tar-Archiv (XZ-komprimiert)"
 "Lauflängenkodiertes Bitmap-Bild" "Zip-Archiv" "Word-Vorlage" "PCX-Bild"
 "XML-Dokument" "Verbunddokumente" "XZ-Archiv" "Leere HD-DVD" "Krita-Dokument"
 "3GPP-Multimediadatei" "Komprimiertes Tracker-Audio" "DCL-Skript"
 "Windows-BMP-Bild" "Ordner" "Windows-Media-Video" "ILBM-Bild"
 "FreeFileSync batch file" "Debian-Paket" "Übersetzungsvorlage"
 "KWord-Dokument (verschlüsselt)" "EPS-Bild (gzip-komprimiert)"
 "Nachricht in mehreren Formaten" "Qt-MOC-Datei" "Dia-Form" "QuickTime-Bild"
 "Fortran-Quelltext" "Schnellzugriff zum Kexi-Projekt auf dem Datenbankserver"
 "MP3-ShoutCast-Wiedergabeliste" "Managed Object Format"
 "Apple-optimierte PNG-Grafik" "OpenDocument Tabellendokumentvorlage"
 "3D-Studio-Bild" "Microsoft PowerPoint Präsentation" "iPod-Firmware"
 "OpenType-Schrift" "Symbolische Verknüpfung" "Mobipocket E-Book" "Leere DVD"
 "Wavelet-Video" "Format zur Linear- und Ganzzahlenprogrammierung"
 "HTML-Dokumentvorlage" "StarMail-E-Mail" "C-Header" "XPS-Dokument"
 "Private Key in PEM format" "Sigma-X3F-Rohbild" "PNG-Bild" "EXR-Bild"
 "JNG-Bild" "X.509 Certificate in PEM format" "Lizenzbedingungen"
 "Certificate Revocation List in PEM format" "Tar-Archiv" "Windows-Cursor"
 "Microsoft Excel Arbeitsblattsvorlage" "IT 8.7 Farbkalibrierungsdatei"
 "Ogg-FLAC-Audio" "AMR-WB-Audio" "ODC-Diagramm" "Parchive-Archiv"
 "PowerPoint-Präsentationsvorlage mit aktivierten Makros" "TSV-Dokument"
 "E-Mail-Nachricht" "X.509-Zertifikat" "UFRaw-Bildbeschreibungsdatei"
 "NIFF-Bild" "Handbuchseite (komprimiert)" "»Palm OS«-Datenbank"
 "»FastTracker II«-Audio" "Java-Klasse" "Scream-Tracker-Instrument"
 "Anwendungsprotokoll" "KeePass 2 Datenbank" "Microsoft Excel Arbeitsblatt"
 "iMelody-Klingelton" "SVG-Bild" "ULAW-Audio (Sun)" "Xbase-Dokument"
 "OpenDocument Datenbank" "Elektronische Visitenkarte" "X.509-Zertifikat"
 "PHP-Skript" "KSpread-Tabelle (verschlüsselt)" "XMCD-CD-Datenbank"
 "MagicPoint-Präsentation" "MiniPSF-Audio"
 "PowerPoint-Folie mit aktivierten Makros" "Microsoft Excel Arbeitsblatt"
 "GDBM-Datenbank" "Adobe Digitales Negativ" "XHTML-Seite" "Verbunddokument"
 "SISX-Paket" "TGIF-Dokument" "DAR-Archiv" "MRML-Wiedergabeliste"
 "Kugar-Dokument" "E-Mail-Übertragungsbericht"
 "OpenOffice.org 1.0 Tabellendokument")

            (mapcar #'g-content-type-get-description
                    (g-content-types-get-registered)))))

;;;   g_content_type_get_mime_type

#+nil
(test g-content-type-get-mime-type
  (is (equal '("video/webm" "image/cgm" "application/x-xpinstall"
 "application/x-gz-font-linux-psf" "audio/vnd.dts.hd"
 "application/vnd.sun.xml.draw" "video/x-javafx" "video/x-matroska"
 "application/x-hwt" "text/richtext" "video/x-flv" "application/x-hwp"
 "application/vnd.oasis.opendocument.chart-template" "application/x-cbz"
 "application/x-stuffit" "application/vnd.oasis.opendocument.graphics-flat-xml"
 "text/sgml" "application/x-abiword" "application/x-cbt" "application/x-cbr"
 "application/x-wwf" "text/x-subviewer" "text/enriched"
 "application/x-font-tex" "application/sieve" "application/rtf"
 "application/andrew-inset" "text/x-svsrc" "application/pkix-crl"
 "application/vnd.sun.xml.writer.template" "application/x-smaf"
 "application/x-sc" "inode/mount-point" "text/x-haskell"
 "application/x-spss-por" "image/x-olympus-orf" "text/x-lilypond"
 "message/partial" "model/vrml" "application/vnd.scribus" "text/vnd.wap.wml"
 "text/x-txt2tags" "application/x-shellscript" "application/sql"
 "application/x-rar" "image/x-xcursor" "image/vnd.adobe.photoshop"
 "application/vnd.oasis.opendocument.graphics-template" "audio/x-riff"
 "x-content/audio-dvd" "audio/flac" "application/x-graphite"
 "application/x-navi-animation" "application/x-tarz" "image/x-portable-anymap"
 "image/x-icns" "application/mathml+xml" "image/svg+xml-compressed"
 "application/vnd.stardivision.chart" "application/x-gettext-translation"
 "application/pgp-signature" "application/x-zoo" "application/x-class-file"
 "application/x-mswrite" "audio/x-gsm" "application/x-netshow-channel"
 "application/x-cb7" "image/x-wmf" "application/x-dc-rom" "application/smil"
 "application/x-bzpdf" "image/x-xfig" "application/x-qw" "text/x-go"
 "x-content/audio-player" "application/xml-external-parsed-entity"
 "text/x-cobol" "application/x-lzop" "image/x-fpx" "text/x-nfo"
 "text/cache-manifest" "application/prs.plucker" "application/x-font-vfont"
 "x-content/unix-software" "application/x-bittorrent" "image/vnd.ms-modi"
 "application/x-kivio" "application/x-pw" "application/x-tzo"
 "x-content/video-dvd" "multipart/digest" "audio/webm"
 "application/vnd.openxmlformats-officedocument.presentationml.template"
 "application/x-apple-diskimage" "text/vnd.trolltech.linguist"
 "image/x-macpaint" "application/x-font-libgrx" "inode/socket"
 "image/x-sony-srf" "application/vnd.google-earth.kmz" "text/x-ocl"
 "application/vnd.oasis.opendocument.image" "message/delivery-status"
 "application/x-planperfect" "application/x-ace" "image/tiff"
 "application/x-t602" "message/external-body" "image/x-kodak-kdc"
 "application/vnd.ms-excel.addin.macroEnabled.12" "application/x-mif"
 "text/x-eiffel" "audio/x-xmf" "audio/annodex" "text/x-pascal"
 "application/pgp-encrypted" "application/octet-stream" "video/mpeg"
 "text/x-makefile" "application/vnd.oasis.opendocument.text"
 "multipart/x-mixed-replace" "application/vnd.emusic-emusic_package"
 "audio/x-wavpack" "application/x-bzip-compressed-tar" "audio/vnd.rn-realaudio"
 "text/x-iptables" "application/x-cdrdao-toc" "video/isivideo" "video/x-ms-asf"
 "application/vnd.sun.xml.draw.template" "text/x-vhdl" "image/x-eps"
 "application/x-kformula" "image/x-xwindowdump" "image/vnd.microsoft.icon"
 "application/vnd.openofficeorg.extension" "application/x-lzma"
 "image/vnd.wap.wbmp" "application/x-7z-compressed" "x-content/video-bluray"
 "image/x-xpixmap" "image/x-sony-sr2" "multipart/signed" "text/x-scala"
 "text/x-c++src" "audio/x-musepack" "text/x-patch" "audio/x-tta"
 "application/x-pak" "video/x-theora+ogg" "image/x-applix-graphics"
 "application/vnd.ms-excel" "application/x-gba-rom" "image/x-msod"
 "x-content/image-picturecd" "text/x-svhdr" "application/x-glade"
 "video/x-anim" "application/x-ksysv-package" "text/x-xmi"
 "application/xslt+xml" "application/vnd.stardivision.writer"
 "text/vnd.wap.wmlscript" "application/vnd.oasis.opendocument.formula"
 "audio/x-voc" "text/x-rpm-spec"
 "application/vnd.ms-word.document.macroEnabled.12"
 "application/x-kexiproject-sqlite3" "application/x-kexiproject-sqlite2"
 "image/x-portable-pixmap" "application/x-lhz" "video/x-matroska-3d"
 "application/x-mswinurl" "text/x-erlang" "inode/chardevice"
 "application/mathematica" "text/x-uri" "audio/x-ms-wma"
 "application/x-freefilesync-db" "application/mxf" "application/x-chess-pgn"
 "application/x-java-jnlp-file" "application/x-ustar" "text/x-readme"
 "application/x-freefilesync-real"
 "application/vnd.oasis.opendocument.formula-template" "text/x-ldif"
 "text/x-csharp" "application/x-fluid" "audio/x-stm" "application/pkcs10"
 "application/x-lha" "inode/blockdevice" "application/x-trig"
 "application/x-wpg" "image/x-portable-bitmap"
 "application/vnd.openxmlformats-officedocument.spreadsheetml.template"
 "text/x-apport" "application/x-font-speedo"
 "application/vnd.ms-powerpoint.template.macroenabled.12"
 "application/x-mimearchive" "application/vnd.android.package-archive"
 "application/x-yaml" "application/x-frame" "text/x-ocaml"
 "application/x-kchart" "application/vnd.ms-works"
 "application/vnd.symbian.install" "audio/x-speex" "video/annodex"
 "video/x-nsv" "application/x-bzip" "audio/x-matroska"
 "application/x-source-rpm" "application/x-font-afm" "image/x-emf" "video/vivo"
 "image/x-nikon-nef" "application/x-font-bdf" "application/x-e-theme"
 "audio/mpeg" "application/x-m4" "application/x-archive" "application/xml-dtd"
 "application/vnd.oasis.opendocument.presentation-flat-xml"
 "application/x-font-sunos-news" "application/x-quicktime-media-link"
 "application/x-lzip" "image/x-photo-cd" "text/x-objcsrc"
 "application/x-spss-sav" "image/jp2" "audio/vnd.dts" "application/x-bzdvi"
 "image/openraster" "text/x-mpsub" "application/x-nautilus-link"
 "application/x-siag" "application/x-lrzip-compressed-tar" "video/3gpp2"
 "text/vtt" "image/x-sun-raster" "image/x-sony-arw" "application/dicom"
 "application/x-amipro" "text/x-adasrc" "application/x-dvi"
 "application/x-gnuplot" "application/font-woff" "image/x-xbitmap"
 "application/x-gzpostscript" "x-content/image-dcf" "x-content/audio-cdda"
 "text/x-credits" "multipart/encrypted" "text/x-dsl" "text/html" "image/x-xcf"
 "application/x-aportisdoc" "application/x-pef-executable" "audio/x-s3m"
 "application/vnd.stardivision.impress" "application/vnd.ms-word"
 "application/vnd.oasis.opendocument.presentation-template"
 "application/x-shared-library-la" "audio/x-speex+ogg"
 "application/x-wais-source" "image/x-minolta-mrw" "text/x-ssa" "video/x-flic"
 "text/x-bibtex" "application/x-java-jce-keystore"
 "application/gnunet-directory" "application/x-pkcs7-certificates"
 "application/x-shar" "application/x-font-framemaker" "application/x-markaby"
 "video/vnd.mpegurl" "message/x-gnu-rmail" "application/vnd.hp-pcl"
 "application/vnd.ms-word.template.macroEnabled.12" "application/x-font-pcf"
 "application/vnd.ms-publisher" "application/x-karbon" "video/x-ogm+ogg"
 "text/x-vala" "image/g3fax" "x-content/win32-software" "text/x-scheme"
 "application/vnd.oasis.opendocument.presentation" "text/htmlh"
 "application/x-designer" "application/x-killustrator" "application/x-ms-wim"
 "application/x-cd-image" "application/x-cpio-compressed" "text/x-c++hdr"
 "application/x-n64-rom" "text/rfc822-headers" "application/x-cue"
 "application/x-sv4cpio" "application/vnd.ms-tnef" "audio/x-it"
 "application/x-kexi-connectiondata" "audio/x-aiff" "application/pkix-pkipath"
 "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"
 "audio/x-aifc" "application/x-cisco-vpn-settings" "audio/x-amzxml"
 "application/vnd.ms-powerpoint.addin.macroEnabled.12" "text/x-texinfo"
 "text/x-java" "application/x-gtk-builder" "text/x-emacs-lisp"
 "text/x-troff-ms" "application/x-gzpdf" "application/epub+zip"
 "application/javascript" "text/x-troff-mm" "application/gml+xml" "image/fits"
 "application/vnd.ms-htmlhelp" "application/x-xzpdf" "application/x-sami"
 "text/x-troff-me" "application/x-applix-spreadsheet" "text/x-modelica"
 "application/vnd.ms-powerpoint" "audio/x-psflib" "application/x-quattropro"
 "application/relax-ng-compact-syntax" "application/x-shorten"
 "application/x-bcpio" "video/dv" "application/x-subrip" "application/x-ccmx"
 "multipart/report" "application/x-font-tex-tfm" "text/x-python"
 "image/x-panasonic-raw2" "application/x-genesis-rom" "application/sdp"
 "application/vnd.corel-draw" "application/vnd.sun.xml.impress.template"
 "application/x-jbuilder-project" "image/x-lws" "image/x-dib" "image/x-tga"
 "application/vnd.apple.mpegurl" "image/x-lwo" "audio/x-ms-asx"
 "application/x-csh" "audio/x-psf" "application/x-awk"
 "application/vnd.google-earth.kml+xml"
 "application/vnd.ms-powerpoint.slideshow.macroEnabled.12" "x-content/blank-cd"
 "text/troff" "application/x-raw-disk-image-xz-compressed"
 "application/x-tex-pk" "application/pkcs8" "audio/prs.sid"
 "application/vnd.visio" "audio/x-iriver-pla" "text/x-idl" "audio/x-adpcm"
 "application/x-spkac" "application/x-compressed-tar"
 "application/x-font-linux-psf" "application/x-iff"
 "audio/x-wavpack-correction" "application/x-gnucash" "application/rdf+xml"
 "video/mp4" "video/x-mng" "text/x-uil" "application/x-ms-dos-executable"
 "text/spreadsheet" "x-content/blank-bd" "audio/x-vorbis+ogg" "image/x-bzeps"
 "application/vnd.ms-excel.sheet.macroEnabled.12"
 "application/vnd.openxmlformats-officedocument.presentationml.presentation"
 "application/x-core" "application/mac-binhex40"
 "application/vnd.ms-cab-compressed" "audio/x-opus+ogg"
 "image/x-portable-graymap" "text/x-verilog" "application/x-nzb"
 "application/x-lzma-compressed-tar" "application/x-kword" "application/msword"
 "image/x-sgi" "image/fax-g3" "application/postscript"
 "application/vnd.ms-excel.sheet.binary.macroEnabled.12" "x-content/video-vcd"
 "application/x-lrzip" "application/x-pocket-word" "application/x-sms-rom"
 "text/x-markdown" "application/x-font-ttx" "image/vnd.rn-realpix"
 "application/x-dia-diagram" "application/x-spkac+base64"
 "application/x-freefilesync-ffs"
 "application/vnd.ms-word.document.macroenabled.12" "text/x-dsrc"
 "application/vnd.nintendo.snes.rom" "application/vnd.stardivision.math"
 "application/x-applix-word"
 "application/vnd.ms-powerpoint.presentation.macroEnabled.12"
 "application/x-font-ttf" "audio/mp4" "audio/mp2" "application/vnd.hp-hpgl"
 "application/x-kpovmodeler" "application/x-theme" "image/x-skencil"
 "application/vnd.mozilla.xul+xml" "text/x-gettext-translation"
 "application/x-go-sgf" "application/x-java-archive" "application/x-rpm"
 "text/x-setext" "audio/x-ape" "application/x-brasero" "audio/x-wav"
 "text/x-ms-regedit" "application/gzip" "application/x-kpresenter"
 "application/vnd.lotus-wordpro" "application/x-kspread"
 "application/vnd.ms-excel.template.macroEnabled.12" "audio/AMR"
 "x-content/software" "x-content/ebook-reader" "text/css" "text/csv"
 "image/x-rgb" "application/x-gmc-link" "application/x-profile"
 "application/vnd.tcpdump.pcap" "application/x-ica"
 "application/x-windows-themepack"
 "application/vnd.oasis.opendocument.database" "application/x-asp"
 "application/x-perl" "application/x-ole-storage" "application/x-bzpostscript"
 "application/x-qtiplot" "video/ogg" "application/x-xliff"
 "application/x-java-pack200" "application/metalink+xml" "image/x-dds"
 "image/x-canon-crw" "image/x-kodak-dcr" "image/dpx" "application/x-zerosize"
 "image/x-dcraw" "application/vnd.ms-wpl" "text/plain" "video/x-msvideo"
 "application/annodex"
 "application/vnd.openxmlformats-officedocument.presentationml.slide"
 "application/vnd.oasis.opendocument.text-template" "application/x-slp"
 "application/x-hdf" "application/ram" "application/metalink4+xml"
 "audio/x-mpegurl" "image/x-pict" "application/x-arj" "application/x-xbel"
 "application/pgp-keys" "application/ogg" "application/x-gzdvi"
 "application/x-ruby" "application/x-arc" "application/x-trash"
 "application/vnd.wordperfect" "application/x-blender" "video/quicktime"
 "text/x-opml+xml" "text/x-changelog" "image/ief" "audio/ogg"
 "image/x-compressed-xcf" "text/x-qml" "image/x-pentax-pef" "image/gif"
 "application/x-lyx"
 "application/vnd.openxmlformats-officedocument.wordprocessingml.document"
 "image/x-fuji-raf" "text/x-uuencode" "application/pkcs7-mime+pem"
 "application/x-executable" "text/x-mup" "application/pdf"
 "application/x-macbinary" "image/jpeg"
 "application/vnd.oasis.opendocument.text-flat-xml" "application/x-gnumeric"
 "application/x-gameboy-rom" "text/x-literate-haskell" "message/news"
 "image/x-canon-cr2" "application/pkcs12+pem" "application/x-font-type1"
 "application/ecmascript" "text/vnd.rn-realtext"
 "application/vnd.ms-word.template.macroenabled.12" "text/x-reject"
 "text/x-cmake" "application/x-troff-man" "application/x-desktop"
 "application/vnd.openxmlformats-officedocument.presentationml.slideshow"
 "application/atom+xml" "application/x-docbook+xml"
 "application/pkcs7-signature" "application/x-sharedlib" "application/winhlp"
 "application/x-pem-file" "text/x-matlab" "application/x-pkcs12"
 "video/x-sgi-movie" "text/x-tex" "audio/x-m4b"
 "application/vnd.sun.xml.calc.template" "application/x-matroska"
 "text/x-authors" "application/vnd.oasis.opendocument.text-master"
 "text/vnd.sun.j2me.app-descriptor" "text/x-microdvd" "application/x-cpio"
 "x-content/video-hddvd" "application/vnd.adobe.flash.movie"
 "application/x-fictionbook+xml" "application/x-kontour" "text/x-ooc"
 "application/vnd.ms-access" "video/vnd.rn-realvideo"
 "application/x-extension-eml" "application/x-raw-disk-image" "text/calendar"
 "text/x-lua" "application/x-egon" "text/x-csrc" "application/pkcs10+pem"
 "text/x-apt-sources-list" "application/x-msx-rom" "application/oda"
 "application/vnd.sun.xml.math" "text/vnd.graphviz" "application/x-sv4crc"
 "x-content/video-svcd" "application/x-oleo"
 "application/vnd.oasis.opendocument.graphics" "text/x-google-video-pointer"
 "application/pkcs8+pem" "text/x-tcl"
 "application/vnd.oasis.opendocument.spreadsheet" "multipart/appledouble"
 "image/x-cmu-raster" "application/pkcs7-mime" "inode/fifo" "image/vnd.dxf"
 "audio/midi" "application/x-font-dos" "image/vnd.dwg" "application/x-gedcom"
 "application/x-toutdoux" "application/x-nes-rom" "audio/ac3" "image/vnd.djvu"
 "application/vnd.lotus-1-2-3" "video/mp2t" "image/x-panasonic-raw"
 "application/x-nintendo-ds-rom" "application/vnd.sun.xml.impress"
 "application/x-tex-gf" "text/x-install" "application/vnd.stardivision.calc"
 "application/mbox" "application/x-object" "application/vnd.stardivision.draw"
 "audio/aac" "application/x-gnome-saved-search"
 "application/vnd.sun.xml.writer" "image/x-kodak-k25" "application/x-netcdf"
 "application/xspf+xml" "application/x-sqlite3" "application/x-sqlite2"
 "application/x-mozilla-bookmarks" "audio/x-mod"
 "application/x-python-bytecode" "application/x-msi"
 "application/vnd.rn-realmedia" "application/illustrator"
 "application/vnd.sun.xml.writer.global" "application/vnd.iccprofile"
 "application/x-alz" "text/x-xslfo"
 "application/vnd.oasis.opendocument.spreadsheet-flat-xml"
 "application/x-gtktalog" "application/x-java-keystore" "application/rss+xml"
 "application/x-compress"
 "application/vnd.openxmlformats-officedocument.wordprocessingml.template"
 "application/x-xz-compressed-tar" "image/rle" "application/zip"
 "application/msword-template" "image/x-pcx" "application/xml"
 "multipart/mixed" "application/x-xz" "x-content/blank-hddvd"
 "application/x-krita" "video/3gpp" "audio/x-mo3" "text/x-dcl" "image/bmp"
 "inode/directory" "video/x-ms-wmv" "image/x-ilbm"
 "application/x-freefilesync-batch" "application/x-deb"
 "text/x-gettext-translation-template" "application/x-kword-crypt"
 "image/x-gzeps" "multipart/alternative" "text/x-moc" "application/x-dia-shape"
 "image/x-quicktime" "text/x-fortran" "application/x-kexiproject-shortcut"
 "audio/x-scpls" "text/x-mof" "image/x-apple-ios-png"
 "application/vnd.oasis.opendocument.spreadsheet-template" "image/x-3ds"
 "application/vnd.ms-powerpoint.presentation.macroenabled.12"
 "application/x-ipod-firmware" "application/x-font-otf" "inode/symlink"
 "application/x-mobipocket-ebook" "x-content/blank-dvd" "video/wavelet"
 "application/x-mps" "application/vnd.oasis.opendocument.text-web"
 "application/vnd.stardivision.mail" "text/x-chdr" "application/oxps"
 "application/x-pem-key" "image/x-sigma-x3f" "image/png" "image/x-exr"
 "image/x-jng" "application/pkix-cert+pem" "text/x-copying"
 "application/pkix-crl+pem" "application/x-tar" "image/x-win-bitmap"
 "application/vnd.ms-excel.template.macroenabled.12" "application/x-it87"
 "audio/x-flac+ogg" "audio/AMR-WB" "application/vnd.oasis.opendocument.chart"
 "application/x-par2" "application/vnd.ms-powerpoint.template.macroEnabled.12"
 "text/tab-separated-values" "message/rfc822" "application/x-x509-ca-cert"
 "application/x-ufraw" "image/x-niff" "application/x-troff-man-compressed"
 "application/vnd.palm" "audio/x-xm" "application/x-java" "audio/x-xi"
 "text/x-log" "application/x-keepass2"
 "application/vnd.ms-excel.sheet.macroenabled.12" "text/x-iMelody"
 "image/svg+xml" "audio/basic" "application/x-dbf"
 "application/vnd.sun.xml.base" "text/vcard" "application/pkix-cert"
 "application/x-php" "application/x-kspread-crypt" "text/xmcd"
 "application/x-magicpoint" "audio/x-minipsf"
 "application/vnd.ms-powerpoint.slide.macroEnabled.12"
 "application/vnd.ms-excel.sheet.binary.macroenabled.12" "application/x-gdbm"
 "image/x-adobe-dng" "application/xhtml+xml" "multipart/related"
 "x-epoc/x-sisx-app" "application/x-tgif" "application/x-dar" "text/x-mrml"
 "application/x-kugar" "message/disposition-notification"
 "application/vnd.sun.xml.calc")

             (mapcar #'g-content-type-get-mime-type
                     (g-content-types-get-registered)))))

;;;   g_content_type_get_icon

(test g-content-type-get-icon
  (is (eq 'g-themed-icon
          (type-of (g-content-type-get-icon "image/cgm")))))

;;;   g_content_type_get_symbolic_icon

(test g-content-type-get-symbolic-icon
  (is (eq 'g-themed-icon
          (type-of (g-content-type-get-symbolic-icon "image/cgm")))))

;;;   g_content_type_get_generic_icon_name

#+nil
(test g-content-type-get-generic-icon-name
  (is (equal '("video-x-generic" "image-x-generic" "application-x-generic" "font-x-generic"
 "audio-x-generic" "image-x-generic" "video-x-generic" "video-x-generic"
 "x-office-document" "text-x-generic" "video-x-generic" "x-office-document"
 "x-office-spreadsheet" "x-office-document" "package-x-generic"
 "image-x-generic" "text-x-generic" "x-office-document" "x-office-document"
 "x-office-document" "x-office-document" "text-x-generic" "text-x-generic"
 "font-x-generic" "text-x-script" "x-office-document" "x-office-document"
 "text-x-generic" "application-x-generic" "x-office-document" "audio-x-generic"
 "x-office-spreadsheet" "inode-x-generic" "text-x-generic"
 "application-x-generic" "image-x-generic" "text-x-generic" "text-x-generic"
 "x-office-document" "application-x-generic" "text-x-generic" "text-x-generic"
 "text-x-script" "application-x-generic" "package-x-generic" "image-x-generic"
 "image-x-generic" "image-x-generic" "audio-x-generic" "x-content-x-generic"
 "audio-x-generic" "x-office-document" "application-x-generic"
 "package-x-generic" "image-x-generic" "image-x-generic"
 "application-x-generic" "image-x-generic" "x-office-spreadsheet"
 "application-x-generic" "text-x-generic" "package-x-generic"
 "application-x-generic" "x-office-document" "audio-x-generic"
 "video-x-generic" "x-office-document" "image-x-generic"
 "application-x-executable" "video-x-generic" "x-office-document"
 "image-x-generic" "x-office-spreadsheet" "text-x-generic"
 "x-content-x-generic" "text-html" "text-x-generic" "package-x-generic"
 "image-x-generic" "text-x-generic" "text-x-generic" "x-office-document"
 "font-x-generic" "x-content-x-generic" "application-x-generic"
 "image-x-generic" "x-office-document" "x-office-document" "package-x-generic"
 "x-content-x-generic" "multipart-x-generic" "audio-x-generic"
 "x-office-presentation" "application-x-generic" "text-x-generic"
 "image-x-generic" "font-x-generic" "inode-x-generic" "image-x-generic"
 "application-x-generic" "text-x-generic" "image-x-generic" "text-x-generic"
 "x-office-spreadsheet" "package-x-generic" "image-x-generic"
 "x-office-document" "text-x-generic" "image-x-generic" "x-office-spreadsheet"
 "application-x-generic" "text-x-generic" "audio-x-generic" "audio-x-generic"
 "text-x-generic" "text-x-generic" "application-x-generic" "video-x-generic"
 "text-x-generic" "x-office-document" "multipart-x-generic" "package-x-generic"
 "audio-x-generic" "package-x-generic" "audio-x-generic" "text-x-generic"
 "text-x-generic" "video-x-generic" "video-x-generic" "image-x-generic"
 "text-x-generic" "image-x-generic" "x-office-document" "image-x-generic"
 "image-x-generic" "x-office-document" "package-x-generic" "image-x-generic"
 "package-x-generic" "x-content-x-generic" "image-x-generic" "image-x-generic"
 "multipart-x-generic" "text-x-generic" "text-x-generic" "audio-x-generic"
 "text-x-generic" "audio-x-generic" "package-x-generic" "video-x-generic"
 "image-x-generic" "x-office-spreadsheet" "application-x-executable"
 "image-x-generic" "x-content-x-generic" "text-x-generic" "x-office-document"
 "video-x-generic" "package-x-generic" "text-x-generic" "text-x-generic"
 "x-office-document" "text-x-generic" "x-office-document" "audio-x-generic"
 "text-x-generic" "x-office-document" "application-x-generic"
 "application-x-generic" "image-x-generic" "package-x-generic"
 "video-x-generic" "application-x-generic" "text-x-generic" "inode-x-generic"
 "x-office-document" "text-x-generic" "audio-x-generic" "application-x-generic"
 "video-x-generic" "text-x-generic" "text-x-script" "package-x-generic"
 "text-x-generic" "application-x-generic" "x-office-document" "text-x-generic"
 "text-x-generic" "x-office-document" "audio-x-generic" "text-x-generic"
 "package-x-generic" "inode-x-generic" "application-x-generic"
 "image-x-generic" "image-x-generic" "x-office-spreadsheet" "text-x-generic"
 "font-x-generic" "application-x-generic" "application-x-generic"
 "application-x-generic" "text-x-generic" "x-office-document" "text-x-generic"
 "x-office-spreadsheet" "x-office-document" "package-x-generic"
 "audio-x-generic" "video-x-generic" "video-x-generic" "package-x-generic"
 "audio-x-generic" "package-x-generic" "font-x-generic" "image-x-generic"
 "video-x-generic" "image-x-generic" "font-x-generic" "application-x-generic"
 "audio-x-generic" "text-x-script" "package-x-generic" "text-x-generic"
 "x-office-presentation" "font-x-generic" "video-x-generic" "package-x-generic"
 "image-x-generic" "text-x-generic" "application-x-generic" "image-x-generic"
 "audio-x-generic" "x-office-document" "image-x-generic" "text-x-generic"
 "text-x-generic" "x-office-spreadsheet" "package-x-generic" "video-x-generic"
 "text-x-generic" "image-x-generic" "image-x-generic" "image-x-generic"
 "x-office-document" "text-x-generic" "x-office-document" "x-office-document"
 "font-x-generic" "image-x-generic" "x-office-document" "x-content-x-generic"
 "x-content-x-generic" "text-x-generic" "multipart-x-generic" "text-x-generic"
 "text-x-generic" "image-x-generic" "x-office-document"
 "application-x-executable" "audio-x-generic" "x-office-presentation"
 "application-x-generic" "x-office-presentation" "text-x-script"
 "audio-x-generic" "text-x-generic" "image-x-generic" "text-x-generic"
 "video-x-generic" "text-x-generic" "application-x-generic"
 "application-x-generic" "application-x-generic" "package-x-generic"
 "font-x-generic" "text-x-script" "video-x-generic" "text-x-generic"
 "image-x-generic" "x-office-document" "font-x-generic" "application-x-generic"
 "image-x-generic" "video-x-generic" "text-x-generic" "image-x-generic"
 "x-content-x-generic" "text-x-generic" "x-office-presentation"
 "text-x-generic" "x-office-document" "image-x-generic" "application-x-generic"
 "application-x-generic" "package-x-generic" "text-x-generic"
 "application-x-executable" "text-x-generic" "text-x-generic"
 "package-x-generic" "application-x-generic" "audio-x-generic"
 "application-x-generic" "audio-x-generic" "application-x-generic"
 "x-office-spreadsheet" "audio-x-generic" "text-x-generic" "audio-x-generic"
 "x-office-presentation" "text-x-generic" "text-x-generic" "x-office-document"
 "text-x-generic" "text-x-generic" "x-office-document" "x-office-document"
 "text-x-script" "text-x-generic" "application-x-generic" "image-x-generic"
 "x-office-document" "x-office-document" "text-x-generic" "text-x-generic"
 "x-office-spreadsheet" "text-x-generic" "x-office-presentation"
 "audio-x-generic" "x-office-spreadsheet" "text-x-generic" "audio-x-generic"
 "package-x-generic" "video-x-generic" "text-x-generic" "text-x-generic"
 "multipart-x-generic" "font-x-generic" "text-x-generic" "image-x-generic"
 "application-x-executable" "video-x-generic" "image-x-generic"
 "x-office-presentation" "x-office-document" "image-x-generic"
 "image-x-generic" "image-x-generic" "application-x-generic" "image-x-generic"
 "audio-x-generic" "text-x-script" "audio-x-generic" "text-x-script"
 "application-x-generic" "x-office-presentation" "x-content-x-generic"
 "text-x-generic" "application-x-generic" "font-x-generic"
 "application-x-generic" "audio-x-generic" "x-office-document"
 "audio-x-generic" "text-x-generic" "audio-x-generic" "application-x-generic"
 "package-x-generic" "font-x-generic" "application-x-generic" "audio-x-generic"
 "x-office-spreadsheet" "application-x-generic" "video-x-generic"
 "video-x-generic" "text-x-generic" "application-x-executable" "text-x-generic"
 "x-content-x-generic" "audio-x-generic" "image-x-generic"
 "x-office-spreadsheet" "x-office-presentation" "application-x-generic"
 "package-x-generic" "package-x-generic" "audio-x-generic" "image-x-generic"
 "text-x-generic" "application-x-generic" "package-x-generic"
 "x-office-document" "x-office-document" "image-x-generic" "image-x-generic"
 "x-office-document" "x-office-spreadsheet" "x-content-x-generic"
 "package-x-generic" "x-office-document" "application-x-executable"
 "text-x-generic" "font-x-generic" "image-x-generic" "image-x-generic"
 "application-x-generic" "application-x-generic" "application-x-generic"
 "text-x-generic" "application-x-executable" "x-office-document"
 "x-office-document" "x-office-presentation" "font-x-generic" "audio-x-generic"
 "audio-x-generic" "image-x-generic" "image-x-generic" "package-x-generic"
 "image-x-generic" "x-office-document" "text-x-generic" "text-x-generic"
 "package-x-generic" "package-x-generic" "text-x-generic" "audio-x-generic"
 "application-x-generic" "audio-x-generic" "text-x-generic" "package-x-generic"
 "x-office-presentation" "x-office-document" "x-office-spreadsheet"
 "x-office-spreadsheet" "audio-x-generic" "x-content-x-generic"
 "x-content-x-generic" "text-x-generic" "text-x-generic" "image-x-generic"
 "text-x-generic" "text-x-generic" "application-x-generic" "text-x-generic"
 "package-x-generic" "x-office-document" "text-x-script" "text-x-script"
 "x-office-document" "x-office-document" "x-office-document" "video-x-generic"
 "text-x-generic" "package-x-generic" "application-x-generic" "image-x-generic"
 "image-x-generic" "image-x-generic" "image-x-generic" "application-x-generic"
 "image-x-generic" "video-x-generic" "text-x-generic" "video-x-generic"
 "video-x-generic" "x-office-presentation" "x-office-document"
 "package-x-generic" "x-office-document" "application-x-generic"
 "application-x-generic" "audio-x-generic" "image-x-generic"
 "package-x-generic" "text-html" "text-x-generic" "video-x-generic"
 "x-office-document" "text-x-script" "package-x-generic"
 "application-x-generic" "x-office-document" "image-x-generic"
 "video-x-generic" "text-html" "text-x-generic" "image-x-generic"
 "audio-x-generic" "image-x-generic" "text-x-generic" "image-x-generic"
 "image-x-generic" "x-office-document" "x-office-document" "image-x-generic"
 "text-x-generic" "application-x-generic" "application-x-executable"
 "text-x-generic" "x-office-document" "package-x-generic" "image-x-generic"
 "x-office-document" "x-office-spreadsheet" "application-x-executable"
 "text-x-generic" "text-x-generic" "image-x-generic" "application-x-generic"
 "font-x-generic" "text-x-script" "text-x-generic" "application-x-generic"
 "text-x-generic" "text-x-generic" "text-x-generic" "text-x-generic"
 "x-office-presentation" "text-html" "x-office-document" "text-x-generic"
 "application-x-generic" "application-x-generic" "application-x-generic"
 "text-x-generic" "application-x-generic" "video-x-generic" "text-x-generic"
 "audio-x-generic" "x-office-spreadsheet" "video-x-generic" "text-x-generic"
 "x-office-document" "text-x-generic" "text-x-generic" "package-x-generic"
 "x-content-x-generic" "video-x-generic" "application-x-generic"
 "image-x-generic" "text-x-generic" "x-office-document" "video-x-generic"
 "application-x-generic" "application-x-generic" "text-x-generic"
 "text-x-generic" "image-x-generic" "text-x-generic" "application-x-generic"
 "text-x-generic" "application-x-executable" "x-office-document"
 "x-office-document" "x-office-document" "package-x-generic"
 "x-content-x-generic" "x-office-spreadsheet" "image-x-generic"
 "text-x-generic" "application-x-generic" "text-x-generic"
 "x-office-spreadsheet" "multipart-x-generic" "image-x-generic"
 "text-x-generic" "inode-x-generic" "image-x-generic" "audio-x-generic"
 "font-x-generic" "image-x-generic" "x-office-document" "x-office-document"
 "application-x-executable" "audio-x-generic" "image-x-generic"
 "x-office-spreadsheet" "video-x-generic" "image-x-generic"
 "application-x-executable" "x-office-presentation" "font-x-generic"
 "text-x-generic" "x-office-spreadsheet" "text-x-generic" "x-office-document"
 "image-x-generic" "audio-x-generic" "application-x-generic"
 "x-office-document" "image-x-generic" "x-office-document" "audio-x-generic"
 "application-x-generic" "application-x-generic" "text-html" "audio-x-generic"
 "application-x-generic" "application-x-generic" "video-x-generic"
 "image-x-generic" "x-office-document" "application-x-generic"
 "package-x-generic" "text-x-generic" "x-office-spreadsheet"
 "x-office-document" "application-x-generic" "text-html" "package-x-generic"
 "x-office-document" "package-x-generic" "image-x-generic" "package-x-generic"
 "x-office-document" "image-x-generic" "text-html" "multipart-x-generic"
 "package-x-generic" "x-content-x-generic" "x-office-document"
 "video-x-generic" "audio-x-generic" "text-x-generic" "image-x-generic"
 "inode-x-generic" "video-x-generic" "image-x-generic" "application-x-generic"
 "package-x-generic" "text-x-generic" "x-office-document" "image-x-generic"
 "multipart-x-generic" "text-x-generic" "image-x-generic" "image-x-generic"
 "text-x-generic" "application-x-generic" "audio-x-generic" "text-x-generic"
 "image-x-generic" "x-office-spreadsheet" "image-x-generic"
 "application-x-generic" "application-x-generic" "font-x-generic"
 "inode-x-generic" "x-office-document" "x-content-x-generic" "video-x-generic"
 "application-x-generic" "text-html" "application-x-generic" "text-x-generic"
 "x-office-document" "application-x-generic" "image-x-generic"
 "image-x-generic" "image-x-generic" "image-x-generic" "application-x-generic"
 "text-x-generic" "application-x-generic" "package-x-generic" "image-x-generic"
 "application-x-generic" "text-x-generic" "audio-x-generic" "audio-x-generic"
 "x-office-spreadsheet" "package-x-generic" "x-office-presentation"
 "text-x-generic" "text-x-generic" "text-x-generic" "image-x-generic"
 "image-x-generic" "text-x-generic" "application-x-generic" "audio-x-generic"
 "application-x-generic" "audio-x-generic" "text-x-generic"
 "application-x-generic" "application-x-generic" "text-x-generic"
 "image-x-generic" "audio-x-generic" "x-office-document"
 "application-x-generic" "text-x-generic" "application-x-generic"
 "text-x-script" "x-office-spreadsheet" "text-x-generic"
 "x-office-presentation" "audio-x-generic" "x-office-presentation"
 "application-x-generic" "application-x-generic" "image-x-generic" "text-html"
 "multipart-x-generic" "package-x-generic" "x-office-document"
 "package-x-generic" "text-x-generic" "x-office-document" "text-x-generic"
 "x-office-spreadsheet")

             (mapcar #'g-content-type-get-generic-icon-name
                     (g-content-types-get-registered)))))

;;;   g_content_type_can_be_executable
;;;   g_content_type_from_mime_type
;;;   g_content_type_guess
;;;   g_content_type_guess_for_tree

;;;   g_content_types_get_registered

#+nil
(test g-content-types-get-registered
  (is (equal '("video/webm" "image/cgm" "application/x-xpinstall"
 "application/x-gz-font-linux-psf" "audio/vnd.dts.hd"
 "application/vnd.sun.xml.draw" "video/x-javafx" "video/x-matroska"
 "application/x-hwt" "text/richtext" "video/x-flv" "application/x-hwp"
 "application/vnd.oasis.opendocument.chart-template" "application/x-cbz"
 "application/x-stuffit" "application/vnd.oasis.opendocument.graphics-flat-xml"
 "text/sgml" "application/x-abiword" "application/x-cbt" "application/x-cbr"
 "application/x-wwf" "text/x-subviewer" "text/enriched"
 "application/x-font-tex" "application/sieve" "application/rtf"
 "application/andrew-inset" "text/x-svsrc" "application/pkix-crl"
 "application/vnd.sun.xml.writer.template" "application/x-smaf"
 "application/x-sc" "inode/mount-point" "text/x-haskell"
 "application/x-spss-por" "image/x-olympus-orf" "text/x-lilypond"
 "message/partial" "model/vrml" "application/vnd.scribus" "text/vnd.wap.wml"
 "text/x-txt2tags" "application/x-shellscript" "application/sql"
 "application/x-rar" "image/x-xcursor" "image/vnd.adobe.photoshop"
 "application/vnd.oasis.opendocument.graphics-template" "audio/x-riff"
 "x-content/audio-dvd" "audio/flac" "application/x-graphite"
 "application/x-navi-animation" "application/x-tarz" "image/x-portable-anymap"
 "image/x-icns" "application/mathml+xml" "image/svg+xml-compressed"
 "application/vnd.stardivision.chart" "application/x-gettext-translation"
 "application/pgp-signature" "application/x-zoo" "application/x-class-file"
 "application/x-mswrite" "audio/x-gsm" "application/x-netshow-channel"
 "application/x-cb7" "image/x-wmf" "application/x-dc-rom" "application/smil"
 "application/x-bzpdf" "image/x-xfig" "application/x-qw" "text/x-go"
 "x-content/audio-player" "application/xml-external-parsed-entity"
 "text/x-cobol" "application/x-lzop" "image/x-fpx" "text/x-nfo"
 "text/cache-manifest" "application/prs.plucker" "application/x-font-vfont"
 "x-content/unix-software" "application/x-bittorrent" "image/vnd.ms-modi"
 "application/x-kivio" "application/x-pw" "application/x-tzo"
 "x-content/video-dvd" "multipart/digest" "audio/webm"
 "application/vnd.openxmlformats-officedocument.presentationml.template"
 "application/x-apple-diskimage" "text/vnd.trolltech.linguist"
 "image/x-macpaint" "application/x-font-libgrx" "inode/socket"
 "image/x-sony-srf" "application/vnd.google-earth.kmz" "text/x-ocl"
 "application/vnd.oasis.opendocument.image" "message/delivery-status"
 "application/x-planperfect" "application/x-ace" "image/tiff"
 "application/x-t602" "message/external-body" "image/x-kodak-kdc"
 "application/vnd.ms-excel.addin.macroEnabled.12" "application/x-mif"
 "text/x-eiffel" "audio/x-xmf" "audio/annodex" "text/x-pascal"
 "application/pgp-encrypted" "application/octet-stream" "video/mpeg"
 "text/x-makefile" "application/vnd.oasis.opendocument.text"
 "multipart/x-mixed-replace" "application/vnd.emusic-emusic_package"
 "audio/x-wavpack" "application/x-bzip-compressed-tar" "audio/vnd.rn-realaudio"
 "text/x-iptables" "application/x-cdrdao-toc" "video/isivideo" "video/x-ms-asf"
 "application/vnd.sun.xml.draw.template" "text/x-vhdl" "image/x-eps"
 "application/x-kformula" "image/x-xwindowdump" "image/vnd.microsoft.icon"
 "application/vnd.openofficeorg.extension" "application/x-lzma"
 "image/vnd.wap.wbmp" "application/x-7z-compressed" "x-content/video-bluray"
 "image/x-xpixmap" "image/x-sony-sr2" "multipart/signed" "text/x-scala"
 "text/x-c++src" "audio/x-musepack" "text/x-patch" "audio/x-tta"
 "application/x-pak" "video/x-theora+ogg" "image/x-applix-graphics"
 "application/vnd.ms-excel" "application/x-gba-rom" "image/x-msod"
 "x-content/image-picturecd" "text/x-svhdr" "application/x-glade"
 "video/x-anim" "application/x-ksysv-package" "text/x-xmi"
 "application/xslt+xml" "application/vnd.stardivision.writer"
 "text/vnd.wap.wmlscript" "application/vnd.oasis.opendocument.formula"
 "audio/x-voc" "text/x-rpm-spec"
 "application/vnd.ms-word.document.macroEnabled.12"
 "application/x-kexiproject-sqlite3" "application/x-kexiproject-sqlite2"
 "image/x-portable-pixmap" "application/x-lhz" "video/x-matroska-3d"
 "application/x-mswinurl" "text/x-erlang" "inode/chardevice"
 "application/mathematica" "text/x-uri" "audio/x-ms-wma"
 "application/x-freefilesync-db" "application/mxf" "application/x-chess-pgn"
 "application/x-java-jnlp-file" "application/x-ustar" "text/x-readme"
 "application/x-freefilesync-real"
 "application/vnd.oasis.opendocument.formula-template" "text/x-ldif"
 "text/x-csharp" "application/x-fluid" "audio/x-stm" "application/pkcs10"
 "application/x-lha" "inode/blockdevice" "application/x-trig"
 "application/x-wpg" "image/x-portable-bitmap"
 "application/vnd.openxmlformats-officedocument.spreadsheetml.template"
 "text/x-apport" "application/x-font-speedo"
 "application/vnd.ms-powerpoint.template.macroenabled.12"
 "application/x-mimearchive" "application/vnd.android.package-archive"
 "application/x-yaml" "application/x-frame" "text/x-ocaml"
 "application/x-kchart" "application/vnd.ms-works"
 "application/vnd.symbian.install" "audio/x-speex" "video/annodex"
 "video/x-nsv" "application/x-bzip" "audio/x-matroska"
 "application/x-source-rpm" "application/x-font-afm" "image/x-emf" "video/vivo"
 "image/x-nikon-nef" "application/x-font-bdf" "application/x-e-theme"
 "audio/mpeg" "application/x-m4" "application/x-archive" "application/xml-dtd"
 "application/vnd.oasis.opendocument.presentation-flat-xml"
 "application/x-font-sunos-news" "application/x-quicktime-media-link"
 "application/x-lzip" "image/x-photo-cd" "text/x-objcsrc"
 "application/x-spss-sav" "image/jp2" "audio/vnd.dts" "application/x-bzdvi"
 "image/openraster" "text/x-mpsub" "application/x-nautilus-link"
 "application/x-siag" "application/x-lrzip-compressed-tar" "video/3gpp2"
 "text/vtt" "image/x-sun-raster" "image/x-sony-arw" "application/dicom"
 "application/x-amipro" "text/x-adasrc" "application/x-dvi"
 "application/x-gnuplot" "application/font-woff" "image/x-xbitmap"
 "application/x-gzpostscript" "x-content/image-dcf" "x-content/audio-cdda"
 "text/x-credits" "multipart/encrypted" "text/x-dsl" "text/html" "image/x-xcf"
 "application/x-aportisdoc" "application/x-pef-executable" "audio/x-s3m"
 "application/vnd.stardivision.impress" "application/vnd.ms-word"
 "application/vnd.oasis.opendocument.presentation-template"
 "application/x-shared-library-la" "audio/x-speex+ogg"
 "application/x-wais-source" "image/x-minolta-mrw" "text/x-ssa" "video/x-flic"
 "text/x-bibtex" "application/x-java-jce-keystore"
 "application/gnunet-directory" "application/x-pkcs7-certificates"
 "application/x-shar" "application/x-font-framemaker" "application/x-markaby"
 "video/vnd.mpegurl" "message/x-gnu-rmail" "application/vnd.hp-pcl"
 "application/vnd.ms-word.template.macroEnabled.12" "application/x-font-pcf"
 "application/vnd.ms-publisher" "application/x-karbon" "video/x-ogm+ogg"
 "text/x-vala" "image/g3fax" "x-content/win32-software" "text/x-scheme"
 "application/vnd.oasis.opendocument.presentation" "text/htmlh"
 "application/x-designer" "application/x-killustrator" "application/x-ms-wim"
 "application/x-cd-image" "application/x-cpio-compressed" "text/x-c++hdr"
 "application/x-n64-rom" "text/rfc822-headers" "application/x-cue"
 "application/x-sv4cpio" "application/vnd.ms-tnef" "audio/x-it"
 "application/x-kexi-connectiondata" "audio/x-aiff" "application/pkix-pkipath"
 "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"
 "audio/x-aifc" "application/x-cisco-vpn-settings" "audio/x-amzxml"
 "application/vnd.ms-powerpoint.addin.macroEnabled.12" "text/x-texinfo"
 "text/x-java" "application/x-gtk-builder" "text/x-emacs-lisp"
 "text/x-troff-ms" "application/x-gzpdf" "application/epub+zip"
 "application/javascript" "text/x-troff-mm" "application/gml+xml" "image/fits"
 "application/vnd.ms-htmlhelp" "application/x-xzpdf" "application/x-sami"
 "text/x-troff-me" "application/x-applix-spreadsheet" "text/x-modelica"
 "application/vnd.ms-powerpoint" "audio/x-psflib" "application/x-quattropro"
 "application/relax-ng-compact-syntax" "application/x-shorten"
 "application/x-bcpio" "video/dv" "application/x-subrip" "application/x-ccmx"
 "multipart/report" "application/x-font-tex-tfm" "text/x-python"
 "image/x-panasonic-raw2" "application/x-genesis-rom" "application/sdp"
 "application/vnd.corel-draw" "application/vnd.sun.xml.impress.template"
 "application/x-jbuilder-project" "image/x-lws" "image/x-dib" "image/x-tga"
 "application/vnd.apple.mpegurl" "image/x-lwo" "audio/x-ms-asx"
 "application/x-csh" "audio/x-psf" "application/x-awk"
 "application/vnd.google-earth.kml+xml"
 "application/vnd.ms-powerpoint.slideshow.macroEnabled.12" "x-content/blank-cd"
 "text/troff" "application/x-raw-disk-image-xz-compressed"
 "application/x-tex-pk" "application/pkcs8" "audio/prs.sid"
 "application/vnd.visio" "audio/x-iriver-pla" "text/x-idl" "audio/x-adpcm"
 "application/x-spkac" "application/x-compressed-tar"
 "application/x-font-linux-psf" "application/x-iff"
 "audio/x-wavpack-correction" "application/x-gnucash" "application/rdf+xml"
 "video/mp4" "video/x-mng" "text/x-uil" "application/x-ms-dos-executable"
 "text/spreadsheet" "x-content/blank-bd" "audio/x-vorbis+ogg" "image/x-bzeps"
 "application/vnd.ms-excel.sheet.macroEnabled.12"
 "application/vnd.openxmlformats-officedocument.presentationml.presentation"
 "application/x-core" "application/mac-binhex40"
 "application/vnd.ms-cab-compressed" "audio/x-opus+ogg"
 "image/x-portable-graymap" "text/x-verilog" "application/x-nzb"
 "application/x-lzma-compressed-tar" "application/x-kword" "application/msword"
 "image/x-sgi" "image/fax-g3" "application/postscript"
 "application/vnd.ms-excel.sheet.binary.macroEnabled.12" "x-content/video-vcd"
 "application/x-lrzip" "application/x-pocket-word" "application/x-sms-rom"
 "text/x-markdown" "application/x-font-ttx" "image/vnd.rn-realpix"
 "application/x-dia-diagram" "application/x-spkac+base64"
 "application/x-freefilesync-ffs"
 "application/vnd.ms-word.document.macroenabled.12" "text/x-dsrc"
 "application/vnd.nintendo.snes.rom" "application/vnd.stardivision.math"
 "application/x-applix-word"
 "application/vnd.ms-powerpoint.presentation.macroEnabled.12"
 "application/x-font-ttf" "audio/mp4" "audio/mp2" "application/vnd.hp-hpgl"
 "application/x-kpovmodeler" "application/x-theme" "image/x-skencil"
 "application/vnd.mozilla.xul+xml" "text/x-gettext-translation"
 "application/x-go-sgf" "application/x-java-archive" "application/x-rpm"
 "text/x-setext" "audio/x-ape" "application/x-brasero" "audio/x-wav"
 "text/x-ms-regedit" "application/gzip" "application/x-kpresenter"
 "application/vnd.lotus-wordpro" "application/x-kspread"
 "application/vnd.ms-excel.template.macroEnabled.12" "audio/AMR"
 "x-content/software" "x-content/ebook-reader" "text/css" "text/csv"
 "image/x-rgb" "application/x-gmc-link" "application/x-profile"
 "application/vnd.tcpdump.pcap" "application/x-ica"
 "application/x-windows-themepack"
 "application/vnd.oasis.opendocument.database" "application/x-asp"
 "application/x-perl" "application/x-ole-storage" "application/x-bzpostscript"
 "application/x-qtiplot" "video/ogg" "application/x-xliff"
 "application/x-java-pack200" "application/metalink+xml" "image/x-dds"
 "image/x-canon-crw" "image/x-kodak-dcr" "image/dpx" "application/x-zerosize"
 "image/x-dcraw" "application/vnd.ms-wpl" "text/plain" "video/x-msvideo"
 "application/annodex"
 "application/vnd.openxmlformats-officedocument.presentationml.slide"
 "application/vnd.oasis.opendocument.text-template" "application/x-slp"
 "application/x-hdf" "application/ram" "application/metalink4+xml"
 "audio/x-mpegurl" "image/x-pict" "application/x-arj" "application/x-xbel"
 "application/pgp-keys" "application/ogg" "application/x-gzdvi"
 "application/x-ruby" "application/x-arc" "application/x-trash"
 "application/vnd.wordperfect" "application/x-blender" "video/quicktime"
 "text/x-opml+xml" "text/x-changelog" "image/ief" "audio/ogg"
 "image/x-compressed-xcf" "text/x-qml" "image/x-pentax-pef" "image/gif"
 "application/x-lyx"
 "application/vnd.openxmlformats-officedocument.wordprocessingml.document"
 "image/x-fuji-raf" "text/x-uuencode" "application/pkcs7-mime+pem"
 "application/x-executable" "text/x-mup" "application/pdf"
 "application/x-macbinary" "image/jpeg"
 "application/vnd.oasis.opendocument.text-flat-xml" "application/x-gnumeric"
 "application/x-gameboy-rom" "text/x-literate-haskell" "message/news"
 "image/x-canon-cr2" "application/pkcs12+pem" "application/x-font-type1"
 "application/ecmascript" "text/vnd.rn-realtext"
 "application/vnd.ms-word.template.macroenabled.12" "text/x-reject"
 "text/x-cmake" "application/x-troff-man" "application/x-desktop"
 "application/vnd.openxmlformats-officedocument.presentationml.slideshow"
 "application/atom+xml" "application/x-docbook+xml"
 "application/pkcs7-signature" "application/x-sharedlib" "application/winhlp"
 "application/x-pem-file" "text/x-matlab" "application/x-pkcs12"
 "video/x-sgi-movie" "text/x-tex" "audio/x-m4b"
 "application/vnd.sun.xml.calc.template" "application/x-matroska"
 "text/x-authors" "application/vnd.oasis.opendocument.text-master"
 "text/vnd.sun.j2me.app-descriptor" "text/x-microdvd" "application/x-cpio"
 "x-content/video-hddvd" "application/vnd.adobe.flash.movie"
 "application/x-fictionbook+xml" "application/x-kontour" "text/x-ooc"
 "application/vnd.ms-access" "video/vnd.rn-realvideo"
 "application/x-extension-eml" "application/x-raw-disk-image" "text/calendar"
 "text/x-lua" "application/x-egon" "text/x-csrc" "application/pkcs10+pem"
 "text/x-apt-sources-list" "application/x-msx-rom" "application/oda"
 "application/vnd.sun.xml.math" "text/vnd.graphviz" "application/x-sv4crc"
 "x-content/video-svcd" "application/x-oleo"
 "application/vnd.oasis.opendocument.graphics" "text/x-google-video-pointer"
 "application/pkcs8+pem" "text/x-tcl"
 "application/vnd.oasis.opendocument.spreadsheet" "multipart/appledouble"
 "image/x-cmu-raster" "application/pkcs7-mime" "inode/fifo" "image/vnd.dxf"
 "audio/midi" "application/x-font-dos" "image/vnd.dwg" "application/x-gedcom"
 "application/x-toutdoux" "application/x-nes-rom" "audio/ac3" "image/vnd.djvu"
 "application/vnd.lotus-1-2-3" "video/mp2t" "image/x-panasonic-raw"
 "application/x-nintendo-ds-rom" "application/vnd.sun.xml.impress"
 "application/x-tex-gf" "text/x-install" "application/vnd.stardivision.calc"
 "application/mbox" "application/x-object" "application/vnd.stardivision.draw"
 "audio/aac" "application/x-gnome-saved-search"
 "application/vnd.sun.xml.writer" "image/x-kodak-k25" "application/x-netcdf"
 "application/xspf+xml" "application/x-sqlite3" "application/x-sqlite2"
 "application/x-mozilla-bookmarks" "audio/x-mod"
 "application/x-python-bytecode" "application/x-msi"
 "application/vnd.rn-realmedia" "application/illustrator"
 "application/vnd.sun.xml.writer.global" "application/vnd.iccprofile"
 "application/x-alz" "text/x-xslfo"
 "application/vnd.oasis.opendocument.spreadsheet-flat-xml"
 "application/x-gtktalog" "application/x-java-keystore" "application/rss+xml"
 "application/x-compress"
 "application/vnd.openxmlformats-officedocument.wordprocessingml.template"
 "application/x-xz-compressed-tar" "image/rle" "application/zip"
 "application/msword-template" "image/x-pcx" "application/xml"
 "multipart/mixed" "application/x-xz" "x-content/blank-hddvd"
 "application/x-krita" "video/3gpp" "audio/x-mo3" "text/x-dcl" "image/bmp"
 "inode/directory" "video/x-ms-wmv" "image/x-ilbm"
 "application/x-freefilesync-batch" "application/x-deb"
 "text/x-gettext-translation-template" "application/x-kword-crypt"
 "image/x-gzeps" "multipart/alternative" "text/x-moc" "application/x-dia-shape"
 "image/x-quicktime" "text/x-fortran" "application/x-kexiproject-shortcut"
 "audio/x-scpls" "text/x-mof" "image/x-apple-ios-png"
 "application/vnd.oasis.opendocument.spreadsheet-template" "image/x-3ds"
 "application/vnd.ms-powerpoint.presentation.macroenabled.12"
 "application/x-ipod-firmware" "application/x-font-otf" "inode/symlink"
 "application/x-mobipocket-ebook" "x-content/blank-dvd" "video/wavelet"
 "application/x-mps" "application/vnd.oasis.opendocument.text-web"
 "application/vnd.stardivision.mail" "text/x-chdr" "application/oxps"
 "application/x-pem-key" "image/x-sigma-x3f" "image/png" "image/x-exr"
 "image/x-jng" "application/pkix-cert+pem" "text/x-copying"
 "application/pkix-crl+pem" "application/x-tar" "image/x-win-bitmap"
 "application/vnd.ms-excel.template.macroenabled.12" "application/x-it87"
 "audio/x-flac+ogg" "audio/AMR-WB" "application/vnd.oasis.opendocument.chart"
 "application/x-par2" "application/vnd.ms-powerpoint.template.macroEnabled.12"
 "text/tab-separated-values" "message/rfc822" "application/x-x509-ca-cert"
 "application/x-ufraw" "image/x-niff" "application/x-troff-man-compressed"
 "application/vnd.palm" "audio/x-xm" "application/x-java" "audio/x-xi"
 "text/x-log" "application/x-keepass2"
 "application/vnd.ms-excel.sheet.macroenabled.12" "text/x-iMelody"
 "image/svg+xml" "audio/basic" "application/x-dbf"
 "application/vnd.sun.xml.base" "text/vcard" "application/pkix-cert"
 "application/x-php" "application/x-kspread-crypt" "text/xmcd"
 "application/x-magicpoint" "audio/x-minipsf"
 "application/vnd.ms-powerpoint.slide.macroEnabled.12"
 "application/vnd.ms-excel.sheet.binary.macroenabled.12" "application/x-gdbm"
 "image/x-adobe-dng" "application/xhtml+xml" "multipart/related"
 "x-epoc/x-sisx-app" "application/x-tgif" "application/x-dar" "text/x-mrml"
 "application/x-kugar" "message/disposition-notification"
 "application/vnd.sun.xml.calc")
 (g-content-types-get-registered))))

