(in-package #:gtk-demo)

(defun popover-demo ()
  (within-main-loop
    (let ((window (gtk-window-new :toplevel)))
      (g-signal-connect window "destroy"
                        (lambda (widget)
                          (declare (ignore widget))
                          (leave-gtk-main)))
      (setf (gtk-widget-size-request window) '(200 200))
      (let ((group (g-simple-action-group-new))
            (menu (g-menu-new)))
        (let ((action (g-simple-action-new "close" nil)))
          (g-action-map-add-action group action)
          (g-simple-action-set-enabled action t)
          (g-signal-connect action "activate"
                            (lambda (action parameter)
                              (declare (ignore action parameter))
                              (gtk-widget-destroy window))))
        (g-menu-append menu "_Close" "app.close")
        (let* ((box (gtk-box-new :horizontal 60))
               (button (gtk-button-new-with-label "Toggle popover"))
               (popover (gtk-popover-new-from-model button menu)))
          (gtk-widget-insert-action-group button "app" group)
          (g-signal-connect button "clicked" (lambda (widget)
                                               (declare (ignore widget))
                                               (if (gtk-widget-visible popover)
                                                   (gtk-popover-popdown popover)
                                                   (gtk-popover-popup popover))))
          (gtk-container-add box button)
          (gtk-container-add window box)))
      (gtk-widget-show-all window))))
