;;;; cl-cffi-gtk-demo-gtk.asd

(asdf:load-system :cffi-toolchain)
(asdf:load-system :split-sequence)

;; copied from CFFI

(defclass c-test-lib (asdf:c-source-file)
  ())

(defmethod asdf:perform ((o asdf:load-op) (c c-test-lib))
  nil)

(defmethod asdf:perform ((o asdf:load-source-op) (c c-test-lib))
  nil)

(defmethod asdf:output-files ((o asdf:compile-op) (c c-test-lib))
  (let ((p (asdf:component-pathname c)))
    (values
     (list (make-pathname :defaults p :type (asdf/bundle:bundle-pathname-type :shared-library)))
     t)))

(defmethod asdf:perform ((o asdf:compile-op) (c c-test-lib))
  (let ((cffi-toolchain:*cc-flags* `(,@cffi-toolchain:*cc-flags* "-Wall" "-std=c99" "-pedantic" ,@(split-sequence:split-sequence #\Space (uiop:run-program "pkg-config --cflags gtk+-3.0" :output '(:string :stripped T)) :remove-empty-subseqs T)))
        (cffi-toolchain:*ld-dll-flags* `(,@cffi-toolchain:*ld-dll-flags* "-shared" ,@(split-sequence:split-sequence #\Space (uiop:run-program "pkg-config --libs gtk+-3.0" :output '(:string :stripped T)) :remove-empty-subseqs T))))
    (let ((dll (car (output-files o c))))
      (uiop:with-temporary-file (:pathname obj)
        (cffi-toolchain:cc-compile obj (input-files o c))
        (apply 'cffi-toolchain:invoke cffi-toolchain:*ld* "-o" dll (append cffi-toolchain:*ld-dll-flags* (list obj)))))))

(asdf:defsystem :cl-cffi-gtk-demo-gtk
  :author "Dieter Kaiser"
  :license "LLGPL"
  :description "GTK demos for CL-CFFI-GTK"
  :serial t
  :depends-on (:cl-cffi-gtk)
  :components ((:file "package")
               (:file "action-bar")
               (:file "alignment")
               (:file "app-chooser-button")
               (:file "app-chooser-dialog")
               (:file "arrows")
               (:file "aspect-frame")
               (:file "application")
               (:file "application-window")
               (:file "assistant")
               (:file "box")
               (:file "box-packing")
               (:file "builder")
               (:file "button")
               (:file "button-box")
               (:file "buttons")
               (:file "calendar")
               (:file "clipboard")
               (:file "color-button")
               (:file "color-chooser-dialog")
               (:file "combo-box")
               (:file "combo-box-text")
               (:file "drag-and-drop")
               (:file "css-accordion")
               (:file "css-pixbufs")
               (:file "dialog-alternative-order")
               (:file "dialog-toplevel")
               (:file "dialogs")
               (:file "drawing")
               (:file "entry-completion")
               (:file "entry-buffer")
               (:file "event-box")
               (:file "file-chooser-button")
               (:file "fixed")
               (:file "flow-box")
               (:file "font-button")
               (:file "frame")
               (:file "grid")
               (:file "grid-packing")
               (:file "header-bar")
               (:file "image")
               (:file "info-bar")
               (:file "labels")
               (:file "link-button")
               (:file "list-box")
               (:file "menu")
               (:file "more-labels")
               (:file "notebook")
               (:file "numerable-icon")
               (:file "paned-window")
               (:file "pixbuf-scale")
               (:file "pixbufs")
               (:file "places-sidebar")
               (:file "popover")
               (:file "progress-bar")
               (:file "revealer")
               (:file "scale-widgets")
               (:file "scrolled-window")
               (:file "search-entry")
               (:file "selections-1")
               (:file "size-management")
               (:file "simple-application-window")
               (:file "simple-drag-and-drop")
               (:file "simple-file-chooser")
               (:file "simple-message")
               (:file "simple-text-view")
               (:file "simple-tree-view")
               (:file "simple-window")
               (:file "spin-button")
               (:file "stack")
               (:file "statusbar")
               (:c-test-lib "subclass")
               (:file "subclass-window")
               (:file "switch")
               (:file "table-packing")
               (:file "text-entry")
               (:file "text-view-attributes")
               (:file "toggle-buttons")
               (:file "tool-palette")
               (:file "gtk-demo")))
