#ifndef __UTILS__BITPACK64_IMPL__HPP__
#define __UTILS__BITPACK64_IMPL__HPP__ 1
namespace utils {
namespace bitpack {
template <typename Tp>
struct __struct_bitpack_impl<Tp,8,1>
{
  static const size_t unit_size = 64;
  static const size_t bits_total = 64;
  static const size_t loop_total = 64;
  static const size_t bit_size = 1;
  static const Tp     mask = 0x01;
  static inline
  void pack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] & 0x01) << 63;
    destination[0] |= (source[1] & 0x01) << 62;
    destination[0] |= (source[2] & 0x01) << 61;
    destination[0] |= (source[3] & 0x01) << 60;
    destination[0] |= (source[4] & 0x01) << 59;
    destination[0] |= (source[5] & 0x01) << 58;
    destination[0] |= (source[6] & 0x01) << 57;
    destination[0] |= (source[7] & 0x01) << 56;
    destination[0] |= (source[8] & 0x01) << 55;
    destination[0] |= (source[9] & 0x01) << 54;
    destination[0] |= (source[10] & 0x01) << 53;
    destination[0] |= (source[11] & 0x01) << 52;
    destination[0] |= (source[12] & 0x01) << 51;
    destination[0] |= (source[13] & 0x01) << 50;
    destination[0] |= (source[14] & 0x01) << 49;
    destination[0] |= (source[15] & 0x01) << 48;
    destination[0] |= (source[16] & 0x01) << 47;
    destination[0] |= (source[17] & 0x01) << 46;
    destination[0] |= (source[18] & 0x01) << 45;
    destination[0] |= (source[19] & 0x01) << 44;
    destination[0] |= (source[20] & 0x01) << 43;
    destination[0] |= (source[21] & 0x01) << 42;
    destination[0] |= (source[22] & 0x01) << 41;
    destination[0] |= (source[23] & 0x01) << 40;
    destination[0] |= (source[24] & 0x01) << 39;
    destination[0] |= (source[25] & 0x01) << 38;
    destination[0] |= (source[26] & 0x01) << 37;
    destination[0] |= (source[27] & 0x01) << 36;
    destination[0] |= (source[28] & 0x01) << 35;
    destination[0] |= (source[29] & 0x01) << 34;
    destination[0] |= (source[30] & 0x01) << 33;
    destination[0] |= (source[31] & 0x01) << 32;
    destination[0] |= (source[32] & 0x01) << 31;
    destination[0] |= (source[33] & 0x01) << 30;
    destination[0] |= (source[34] & 0x01) << 29;
    destination[0] |= (source[35] & 0x01) << 28;
    destination[0] |= (source[36] & 0x01) << 27;
    destination[0] |= (source[37] & 0x01) << 26;
    destination[0] |= (source[38] & 0x01) << 25;
    destination[0] |= (source[39] & 0x01) << 24;
    destination[0] |= (source[40] & 0x01) << 23;
    destination[0] |= (source[41] & 0x01) << 22;
    destination[0] |= (source[42] & 0x01) << 21;
    destination[0] |= (source[43] & 0x01) << 20;
    destination[0] |= (source[44] & 0x01) << 19;
    destination[0] |= (source[45] & 0x01) << 18;
    destination[0] |= (source[46] & 0x01) << 17;
    destination[0] |= (source[47] & 0x01) << 16;
    destination[0] |= (source[48] & 0x01) << 15;
    destination[0] |= (source[49] & 0x01) << 14;
    destination[0] |= (source[50] & 0x01) << 13;
    destination[0] |= (source[51] & 0x01) << 12;
    destination[0] |= (source[52] & 0x01) << 11;
    destination[0] |= (source[53] & 0x01) << 10;
    destination[0] |= (source[54] & 0x01) << 9;
    destination[0] |= (source[55] & 0x01) << 8;
    destination[0] |= (source[56] & 0x01) << 7;
    destination[0] |= (source[57] & 0x01) << 6;
    destination[0] |= (source[58] & 0x01) << 5;
    destination[0] |= (source[59] & 0x01) << 4;
    destination[0] |= (source[60] & 0x01) << 3;
    destination[0] |= (source[61] & 0x01) << 2;
    destination[0] |= (source[62] & 0x01) << 1;
    destination[0] |= (source[63] & 0x01) << 0;
  }
  static inline
  void unpack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] >> 63) & 0x01;
    destination[1]  = (source[0] >> 62) & 0x01;
    destination[2]  = (source[0] >> 61) & 0x01;
    destination[3]  = (source[0] >> 60) & 0x01;
    destination[4]  = (source[0] >> 59) & 0x01;
    destination[5]  = (source[0] >> 58) & 0x01;
    destination[6]  = (source[0] >> 57) & 0x01;
    destination[7]  = (source[0] >> 56) & 0x01;
    destination[8]  = (source[0] >> 55) & 0x01;
    destination[9]  = (source[0] >> 54) & 0x01;
    destination[10]  = (source[0] >> 53) & 0x01;
    destination[11]  = (source[0] >> 52) & 0x01;
    destination[12]  = (source[0] >> 51) & 0x01;
    destination[13]  = (source[0] >> 50) & 0x01;
    destination[14]  = (source[0] >> 49) & 0x01;
    destination[15]  = (source[0] >> 48) & 0x01;
    destination[16]  = (source[0] >> 47) & 0x01;
    destination[17]  = (source[0] >> 46) & 0x01;
    destination[18]  = (source[0] >> 45) & 0x01;
    destination[19]  = (source[0] >> 44) & 0x01;
    destination[20]  = (source[0] >> 43) & 0x01;
    destination[21]  = (source[0] >> 42) & 0x01;
    destination[22]  = (source[0] >> 41) & 0x01;
    destination[23]  = (source[0] >> 40) & 0x01;
    destination[24]  = (source[0] >> 39) & 0x01;
    destination[25]  = (source[0] >> 38) & 0x01;
    destination[26]  = (source[0] >> 37) & 0x01;
    destination[27]  = (source[0] >> 36) & 0x01;
    destination[28]  = (source[0] >> 35) & 0x01;
    destination[29]  = (source[0] >> 34) & 0x01;
    destination[30]  = (source[0] >> 33) & 0x01;
    destination[31]  = (source[0] >> 32) & 0x01;
    destination[32]  = (source[0] >> 31) & 0x01;
    destination[33]  = (source[0] >> 30) & 0x01;
    destination[34]  = (source[0] >> 29) & 0x01;
    destination[35]  = (source[0] >> 28) & 0x01;
    destination[36]  = (source[0] >> 27) & 0x01;
    destination[37]  = (source[0] >> 26) & 0x01;
    destination[38]  = (source[0] >> 25) & 0x01;
    destination[39]  = (source[0] >> 24) & 0x01;
    destination[40]  = (source[0] >> 23) & 0x01;
    destination[41]  = (source[0] >> 22) & 0x01;
    destination[42]  = (source[0] >> 21) & 0x01;
    destination[43]  = (source[0] >> 20) & 0x01;
    destination[44]  = (source[0] >> 19) & 0x01;
    destination[45]  = (source[0] >> 18) & 0x01;
    destination[46]  = (source[0] >> 17) & 0x01;
    destination[47]  = (source[0] >> 16) & 0x01;
    destination[48]  = (source[0] >> 15) & 0x01;
    destination[49]  = (source[0] >> 14) & 0x01;
    destination[50]  = (source[0] >> 13) & 0x01;
    destination[51]  = (source[0] >> 12) & 0x01;
    destination[52]  = (source[0] >> 11) & 0x01;
    destination[53]  = (source[0] >> 10) & 0x01;
    destination[54]  = (source[0] >> 9) & 0x01;
    destination[55]  = (source[0] >> 8) & 0x01;
    destination[56]  = (source[0] >> 7) & 0x01;
    destination[57]  = (source[0] >> 6) & 0x01;
    destination[58]  = (source[0] >> 5) & 0x01;
    destination[59]  = (source[0] >> 4) & 0x01;
    destination[60]  = (source[0] >> 3) & 0x01;
    destination[61]  = (source[0] >> 2) & 0x01;
    destination[62]  = (source[0] >> 1) & 0x01;
    destination[63]  = (source[0] >> 0) & 0x01;
  }
};
template <typename Tp>
struct __struct_bitpack_impl<Tp,8,2>
{
  static const size_t unit_size = 64;
  static const size_t bits_total = 128;
  static const size_t loop_total = 64;
  static const size_t bit_size = 2;
  static const Tp     mask = 0x03;
  static inline
  void pack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] & 0x03) << 62;
    destination[0] |= (source[1] & 0x03) << 60;
    destination[0] |= (source[2] & 0x03) << 58;
    destination[0] |= (source[3] & 0x03) << 56;
    destination[0] |= (source[4] & 0x03) << 54;
    destination[0] |= (source[5] & 0x03) << 52;
    destination[0] |= (source[6] & 0x03) << 50;
    destination[0] |= (source[7] & 0x03) << 48;
    destination[0] |= (source[8] & 0x03) << 46;
    destination[0] |= (source[9] & 0x03) << 44;
    destination[0] |= (source[10] & 0x03) << 42;
    destination[0] |= (source[11] & 0x03) << 40;
    destination[0] |= (source[12] & 0x03) << 38;
    destination[0] |= (source[13] & 0x03) << 36;
    destination[0] |= (source[14] & 0x03) << 34;
    destination[0] |= (source[15] & 0x03) << 32;
    destination[0] |= (source[16] & 0x03) << 30;
    destination[0] |= (source[17] & 0x03) << 28;
    destination[0] |= (source[18] & 0x03) << 26;
    destination[0] |= (source[19] & 0x03) << 24;
    destination[0] |= (source[20] & 0x03) << 22;
    destination[0] |= (source[21] & 0x03) << 20;
    destination[0] |= (source[22] & 0x03) << 18;
    destination[0] |= (source[23] & 0x03) << 16;
    destination[0] |= (source[24] & 0x03) << 14;
    destination[0] |= (source[25] & 0x03) << 12;
    destination[0] |= (source[26] & 0x03) << 10;
    destination[0] |= (source[27] & 0x03) << 8;
    destination[0] |= (source[28] & 0x03) << 6;
    destination[0] |= (source[29] & 0x03) << 4;
    destination[0] |= (source[30] & 0x03) << 2;
    destination[0] |= (source[31] & 0x03) << 0;
    destination[1]  = (source[32] & 0x03) << 62;
    destination[1] |= (source[33] & 0x03) << 60;
    destination[1] |= (source[34] & 0x03) << 58;
    destination[1] |= (source[35] & 0x03) << 56;
    destination[1] |= (source[36] & 0x03) << 54;
    destination[1] |= (source[37] & 0x03) << 52;
    destination[1] |= (source[38] & 0x03) << 50;
    destination[1] |= (source[39] & 0x03) << 48;
    destination[1] |= (source[40] & 0x03) << 46;
    destination[1] |= (source[41] & 0x03) << 44;
    destination[1] |= (source[42] & 0x03) << 42;
    destination[1] |= (source[43] & 0x03) << 40;
    destination[1] |= (source[44] & 0x03) << 38;
    destination[1] |= (source[45] & 0x03) << 36;
    destination[1] |= (source[46] & 0x03) << 34;
    destination[1] |= (source[47] & 0x03) << 32;
    destination[1] |= (source[48] & 0x03) << 30;
    destination[1] |= (source[49] & 0x03) << 28;
    destination[1] |= (source[50] & 0x03) << 26;
    destination[1] |= (source[51] & 0x03) << 24;
    destination[1] |= (source[52] & 0x03) << 22;
    destination[1] |= (source[53] & 0x03) << 20;
    destination[1] |= (source[54] & 0x03) << 18;
    destination[1] |= (source[55] & 0x03) << 16;
    destination[1] |= (source[56] & 0x03) << 14;
    destination[1] |= (source[57] & 0x03) << 12;
    destination[1] |= (source[58] & 0x03) << 10;
    destination[1] |= (source[59] & 0x03) << 8;
    destination[1] |= (source[60] & 0x03) << 6;
    destination[1] |= (source[61] & 0x03) << 4;
    destination[1] |= (source[62] & 0x03) << 2;
    destination[1] |= (source[63] & 0x03) << 0;
  }
  static inline
  void unpack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] >> 62) & 0x03;
    destination[1]  = (source[0] >> 60) & 0x03;
    destination[2]  = (source[0] >> 58) & 0x03;
    destination[3]  = (source[0] >> 56) & 0x03;
    destination[4]  = (source[0] >> 54) & 0x03;
    destination[5]  = (source[0] >> 52) & 0x03;
    destination[6]  = (source[0] >> 50) & 0x03;
    destination[7]  = (source[0] >> 48) & 0x03;
    destination[8]  = (source[0] >> 46) & 0x03;
    destination[9]  = (source[0] >> 44) & 0x03;
    destination[10]  = (source[0] >> 42) & 0x03;
    destination[11]  = (source[0] >> 40) & 0x03;
    destination[12]  = (source[0] >> 38) & 0x03;
    destination[13]  = (source[0] >> 36) & 0x03;
    destination[14]  = (source[0] >> 34) & 0x03;
    destination[15]  = (source[0] >> 32) & 0x03;
    destination[16]  = (source[0] >> 30) & 0x03;
    destination[17]  = (source[0] >> 28) & 0x03;
    destination[18]  = (source[0] >> 26) & 0x03;
    destination[19]  = (source[0] >> 24) & 0x03;
    destination[20]  = (source[0] >> 22) & 0x03;
    destination[21]  = (source[0] >> 20) & 0x03;
    destination[22]  = (source[0] >> 18) & 0x03;
    destination[23]  = (source[0] >> 16) & 0x03;
    destination[24]  = (source[0] >> 14) & 0x03;
    destination[25]  = (source[0] >> 12) & 0x03;
    destination[26]  = (source[0] >> 10) & 0x03;
    destination[27]  = (source[0] >> 8) & 0x03;
    destination[28]  = (source[0] >> 6) & 0x03;
    destination[29]  = (source[0] >> 4) & 0x03;
    destination[30]  = (source[0] >> 2) & 0x03;
    destination[31]  = (source[0] >> 0) & 0x03;
    destination[32]  = (source[1] >> 62) & 0x03;
    destination[33]  = (source[1] >> 60) & 0x03;
    destination[34]  = (source[1] >> 58) & 0x03;
    destination[35]  = (source[1] >> 56) & 0x03;
    destination[36]  = (source[1] >> 54) & 0x03;
    destination[37]  = (source[1] >> 52) & 0x03;
    destination[38]  = (source[1] >> 50) & 0x03;
    destination[39]  = (source[1] >> 48) & 0x03;
    destination[40]  = (source[1] >> 46) & 0x03;
    destination[41]  = (source[1] >> 44) & 0x03;
    destination[42]  = (source[1] >> 42) & 0x03;
    destination[43]  = (source[1] >> 40) & 0x03;
    destination[44]  = (source[1] >> 38) & 0x03;
    destination[45]  = (source[1] >> 36) & 0x03;
    destination[46]  = (source[1] >> 34) & 0x03;
    destination[47]  = (source[1] >> 32) & 0x03;
    destination[48]  = (source[1] >> 30) & 0x03;
    destination[49]  = (source[1] >> 28) & 0x03;
    destination[50]  = (source[1] >> 26) & 0x03;
    destination[51]  = (source[1] >> 24) & 0x03;
    destination[52]  = (source[1] >> 22) & 0x03;
    destination[53]  = (source[1] >> 20) & 0x03;
    destination[54]  = (source[1] >> 18) & 0x03;
    destination[55]  = (source[1] >> 16) & 0x03;
    destination[56]  = (source[1] >> 14) & 0x03;
    destination[57]  = (source[1] >> 12) & 0x03;
    destination[58]  = (source[1] >> 10) & 0x03;
    destination[59]  = (source[1] >> 8) & 0x03;
    destination[60]  = (source[1] >> 6) & 0x03;
    destination[61]  = (source[1] >> 4) & 0x03;
    destination[62]  = (source[1] >> 2) & 0x03;
    destination[63]  = (source[1] >> 0) & 0x03;
  }
};
template <typename Tp>
struct __struct_bitpack_impl<Tp,8,3>
{
  static const size_t unit_size = 64;
  static const size_t bits_total = 192;
  static const size_t loop_total = 64;
  static const size_t bit_size = 3;
  static const Tp     mask = 0x07;
  static inline
  void pack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] & 0x07) << 61;
    destination[0] |= (source[1] & 0x07) << 58;
    destination[0] |= (source[2] & 0x07) << 55;
    destination[0] |= (source[3] & 0x07) << 52;
    destination[0] |= (source[4] & 0x07) << 49;
    destination[0] |= (source[5] & 0x07) << 46;
    destination[0] |= (source[6] & 0x07) << 43;
    destination[0] |= (source[7] & 0x07) << 40;
    destination[0] |= (source[8] & 0x07) << 37;
    destination[0] |= (source[9] & 0x07) << 34;
    destination[0] |= (source[10] & 0x07) << 31;
    destination[0] |= (source[11] & 0x07) << 28;
    destination[0] |= (source[12] & 0x07) << 25;
    destination[0] |= (source[13] & 0x07) << 22;
    destination[0] |= (source[14] & 0x07) << 19;
    destination[0] |= (source[15] & 0x07) << 16;
    destination[0] |= (source[16] & 0x07) << 13;
    destination[0] |= (source[17] & 0x07) << 10;
    destination[0] |= (source[18] & 0x07) << 7;
    destination[0] |= (source[19] & 0x07) << 4;
    destination[0] |= (source[20] & 0x07) << 1;
    destination[0] |= (source[21] & 0x07) >> 2;
    destination[1]  = (source[21] & 0x07) << 62;
    destination[1] |= (source[22] & 0x07) << 59;
    destination[1] |= (source[23] & 0x07) << 56;
    destination[1] |= (source[24] & 0x07) << 53;
    destination[1] |= (source[25] & 0x07) << 50;
    destination[1] |= (source[26] & 0x07) << 47;
    destination[1] |= (source[27] & 0x07) << 44;
    destination[1] |= (source[28] & 0x07) << 41;
    destination[1] |= (source[29] & 0x07) << 38;
    destination[1] |= (source[30] & 0x07) << 35;
    destination[1] |= (source[31] & 0x07) << 32;
    destination[1] |= (source[32] & 0x07) << 29;
    destination[1] |= (source[33] & 0x07) << 26;
    destination[1] |= (source[34] & 0x07) << 23;
    destination[1] |= (source[35] & 0x07) << 20;
    destination[1] |= (source[36] & 0x07) << 17;
    destination[1] |= (source[37] & 0x07) << 14;
    destination[1] |= (source[38] & 0x07) << 11;
    destination[1] |= (source[39] & 0x07) << 8;
    destination[1] |= (source[40] & 0x07) << 5;
    destination[1] |= (source[41] & 0x07) << 2;
    destination[1] |= (source[42] & 0x07) >> 1;
    destination[2]  = (source[42] & 0x07) << 63;
    destination[2] |= (source[43] & 0x07) << 60;
    destination[2] |= (source[44] & 0x07) << 57;
    destination[2] |= (source[45] & 0x07) << 54;
    destination[2] |= (source[46] & 0x07) << 51;
    destination[2] |= (source[47] & 0x07) << 48;
    destination[2] |= (source[48] & 0x07) << 45;
    destination[2] |= (source[49] & 0x07) << 42;
    destination[2] |= (source[50] & 0x07) << 39;
    destination[2] |= (source[51] & 0x07) << 36;
    destination[2] |= (source[52] & 0x07) << 33;
    destination[2] |= (source[53] & 0x07) << 30;
    destination[2] |= (source[54] & 0x07) << 27;
    destination[2] |= (source[55] & 0x07) << 24;
    destination[2] |= (source[56] & 0x07) << 21;
    destination[2] |= (source[57] & 0x07) << 18;
    destination[2] |= (source[58] & 0x07) << 15;
    destination[2] |= (source[59] & 0x07) << 12;
    destination[2] |= (source[60] & 0x07) << 9;
    destination[2] |= (source[61] & 0x07) << 6;
    destination[2] |= (source[62] & 0x07) << 3;
    destination[2] |= (source[63] & 0x07) << 0;
  }
  static inline
  void unpack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] >> 61) & 0x07;
    destination[1]  = (source[0] >> 58) & 0x07;
    destination[2]  = (source[0] >> 55) & 0x07;
    destination[3]  = (source[0] >> 52) & 0x07;
    destination[4]  = (source[0] >> 49) & 0x07;
    destination[5]  = (source[0] >> 46) & 0x07;
    destination[6]  = (source[0] >> 43) & 0x07;
    destination[7]  = (source[0] >> 40) & 0x07;
    destination[8]  = (source[0] >> 37) & 0x07;
    destination[9]  = (source[0] >> 34) & 0x07;
    destination[10]  = (source[0] >> 31) & 0x07;
    destination[11]  = (source[0] >> 28) & 0x07;
    destination[12]  = (source[0] >> 25) & 0x07;
    destination[13]  = (source[0] >> 22) & 0x07;
    destination[14]  = (source[0] >> 19) & 0x07;
    destination[15]  = (source[0] >> 16) & 0x07;
    destination[16]  = (source[0] >> 13) & 0x07;
    destination[17]  = (source[0] >> 10) & 0x07;
    destination[18]  = (source[0] >> 7) & 0x07;
    destination[19]  = (source[0] >> 4) & 0x07;
    destination[20]  = (source[0] >> 1) & 0x07;
    destination[21]  = (source[0] << 2) & 0x07;
    destination[21] |= (source[1] >> 62) & 0x07;
    destination[22]  = (source[1] >> 59) & 0x07;
    destination[23]  = (source[1] >> 56) & 0x07;
    destination[24]  = (source[1] >> 53) & 0x07;
    destination[25]  = (source[1] >> 50) & 0x07;
    destination[26]  = (source[1] >> 47) & 0x07;
    destination[27]  = (source[1] >> 44) & 0x07;
    destination[28]  = (source[1] >> 41) & 0x07;
    destination[29]  = (source[1] >> 38) & 0x07;
    destination[30]  = (source[1] >> 35) & 0x07;
    destination[31]  = (source[1] >> 32) & 0x07;
    destination[32]  = (source[1] >> 29) & 0x07;
    destination[33]  = (source[1] >> 26) & 0x07;
    destination[34]  = (source[1] >> 23) & 0x07;
    destination[35]  = (source[1] >> 20) & 0x07;
    destination[36]  = (source[1] >> 17) & 0x07;
    destination[37]  = (source[1] >> 14) & 0x07;
    destination[38]  = (source[1] >> 11) & 0x07;
    destination[39]  = (source[1] >> 8) & 0x07;
    destination[40]  = (source[1] >> 5) & 0x07;
    destination[41]  = (source[1] >> 2) & 0x07;
    destination[42]  = (source[1] << 1) & 0x07;
    destination[42] |= (source[2] >> 63) & 0x07;
    destination[43]  = (source[2] >> 60) & 0x07;
    destination[44]  = (source[2] >> 57) & 0x07;
    destination[45]  = (source[2] >> 54) & 0x07;
    destination[46]  = (source[2] >> 51) & 0x07;
    destination[47]  = (source[2] >> 48) & 0x07;
    destination[48]  = (source[2] >> 45) & 0x07;
    destination[49]  = (source[2] >> 42) & 0x07;
    destination[50]  = (source[2] >> 39) & 0x07;
    destination[51]  = (source[2] >> 36) & 0x07;
    destination[52]  = (source[2] >> 33) & 0x07;
    destination[53]  = (source[2] >> 30) & 0x07;
    destination[54]  = (source[2] >> 27) & 0x07;
    destination[55]  = (source[2] >> 24) & 0x07;
    destination[56]  = (source[2] >> 21) & 0x07;
    destination[57]  = (source[2] >> 18) & 0x07;
    destination[58]  = (source[2] >> 15) & 0x07;
    destination[59]  = (source[2] >> 12) & 0x07;
    destination[60]  = (source[2] >> 9) & 0x07;
    destination[61]  = (source[2] >> 6) & 0x07;
    destination[62]  = (source[2] >> 3) & 0x07;
    destination[63]  = (source[2] >> 0) & 0x07;
  }
};
template <typename Tp>
struct __struct_bitpack_impl<Tp,8,4>
{
  static const size_t unit_size = 64;
  static const size_t bits_total = 256;
  static const size_t loop_total = 64;
  static const size_t bit_size = 4;
  static const Tp     mask = 0x0f;
  static inline
  void pack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] & 0x0f) << 60;
    destination[0] |= (source[1] & 0x0f) << 56;
    destination[0] |= (source[2] & 0x0f) << 52;
    destination[0] |= (source[3] & 0x0f) << 48;
    destination[0] |= (source[4] & 0x0f) << 44;
    destination[0] |= (source[5] & 0x0f) << 40;
    destination[0] |= (source[6] & 0x0f) << 36;
    destination[0] |= (source[7] & 0x0f) << 32;
    destination[0] |= (source[8] & 0x0f) << 28;
    destination[0] |= (source[9] & 0x0f) << 24;
    destination[0] |= (source[10] & 0x0f) << 20;
    destination[0] |= (source[11] & 0x0f) << 16;
    destination[0] |= (source[12] & 0x0f) << 12;
    destination[0] |= (source[13] & 0x0f) << 8;
    destination[0] |= (source[14] & 0x0f) << 4;
    destination[0] |= (source[15] & 0x0f) << 0;
    destination[1]  = (source[16] & 0x0f) << 60;
    destination[1] |= (source[17] & 0x0f) << 56;
    destination[1] |= (source[18] & 0x0f) << 52;
    destination[1] |= (source[19] & 0x0f) << 48;
    destination[1] |= (source[20] & 0x0f) << 44;
    destination[1] |= (source[21] & 0x0f) << 40;
    destination[1] |= (source[22] & 0x0f) << 36;
    destination[1] |= (source[23] & 0x0f) << 32;
    destination[1] |= (source[24] & 0x0f) << 28;
    destination[1] |= (source[25] & 0x0f) << 24;
    destination[1] |= (source[26] & 0x0f) << 20;
    destination[1] |= (source[27] & 0x0f) << 16;
    destination[1] |= (source[28] & 0x0f) << 12;
    destination[1] |= (source[29] & 0x0f) << 8;
    destination[1] |= (source[30] & 0x0f) << 4;
    destination[1] |= (source[31] & 0x0f) << 0;
    destination[2]  = (source[32] & 0x0f) << 60;
    destination[2] |= (source[33] & 0x0f) << 56;
    destination[2] |= (source[34] & 0x0f) << 52;
    destination[2] |= (source[35] & 0x0f) << 48;
    destination[2] |= (source[36] & 0x0f) << 44;
    destination[2] |= (source[37] & 0x0f) << 40;
    destination[2] |= (source[38] & 0x0f) << 36;
    destination[2] |= (source[39] & 0x0f) << 32;
    destination[2] |= (source[40] & 0x0f) << 28;
    destination[2] |= (source[41] & 0x0f) << 24;
    destination[2] |= (source[42] & 0x0f) << 20;
    destination[2] |= (source[43] & 0x0f) << 16;
    destination[2] |= (source[44] & 0x0f) << 12;
    destination[2] |= (source[45] & 0x0f) << 8;
    destination[2] |= (source[46] & 0x0f) << 4;
    destination[2] |= (source[47] & 0x0f) << 0;
    destination[3]  = (source[48] & 0x0f) << 60;
    destination[3] |= (source[49] & 0x0f) << 56;
    destination[3] |= (source[50] & 0x0f) << 52;
    destination[3] |= (source[51] & 0x0f) << 48;
    destination[3] |= (source[52] & 0x0f) << 44;
    destination[3] |= (source[53] & 0x0f) << 40;
    destination[3] |= (source[54] & 0x0f) << 36;
    destination[3] |= (source[55] & 0x0f) << 32;
    destination[3] |= (source[56] & 0x0f) << 28;
    destination[3] |= (source[57] & 0x0f) << 24;
    destination[3] |= (source[58] & 0x0f) << 20;
    destination[3] |= (source[59] & 0x0f) << 16;
    destination[3] |= (source[60] & 0x0f) << 12;
    destination[3] |= (source[61] & 0x0f) << 8;
    destination[3] |= (source[62] & 0x0f) << 4;
    destination[3] |= (source[63] & 0x0f) << 0;
  }
  static inline
  void unpack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] >> 60) & 0x0f;
    destination[1]  = (source[0] >> 56) & 0x0f;
    destination[2]  = (source[0] >> 52) & 0x0f;
    destination[3]  = (source[0] >> 48) & 0x0f;
    destination[4]  = (source[0] >> 44) & 0x0f;
    destination[5]  = (source[0] >> 40) & 0x0f;
    destination[6]  = (source[0] >> 36) & 0x0f;
    destination[7]  = (source[0] >> 32) & 0x0f;
    destination[8]  = (source[0] >> 28) & 0x0f;
    destination[9]  = (source[0] >> 24) & 0x0f;
    destination[10]  = (source[0] >> 20) & 0x0f;
    destination[11]  = (source[0] >> 16) & 0x0f;
    destination[12]  = (source[0] >> 12) & 0x0f;
    destination[13]  = (source[0] >> 8) & 0x0f;
    destination[14]  = (source[0] >> 4) & 0x0f;
    destination[15]  = (source[0] >> 0) & 0x0f;
    destination[16]  = (source[1] >> 60) & 0x0f;
    destination[17]  = (source[1] >> 56) & 0x0f;
    destination[18]  = (source[1] >> 52) & 0x0f;
    destination[19]  = (source[1] >> 48) & 0x0f;
    destination[20]  = (source[1] >> 44) & 0x0f;
    destination[21]  = (source[1] >> 40) & 0x0f;
    destination[22]  = (source[1] >> 36) & 0x0f;
    destination[23]  = (source[1] >> 32) & 0x0f;
    destination[24]  = (source[1] >> 28) & 0x0f;
    destination[25]  = (source[1] >> 24) & 0x0f;
    destination[26]  = (source[1] >> 20) & 0x0f;
    destination[27]  = (source[1] >> 16) & 0x0f;
    destination[28]  = (source[1] >> 12) & 0x0f;
    destination[29]  = (source[1] >> 8) & 0x0f;
    destination[30]  = (source[1] >> 4) & 0x0f;
    destination[31]  = (source[1] >> 0) & 0x0f;
    destination[32]  = (source[2] >> 60) & 0x0f;
    destination[33]  = (source[2] >> 56) & 0x0f;
    destination[34]  = (source[2] >> 52) & 0x0f;
    destination[35]  = (source[2] >> 48) & 0x0f;
    destination[36]  = (source[2] >> 44) & 0x0f;
    destination[37]  = (source[2] >> 40) & 0x0f;
    destination[38]  = (source[2] >> 36) & 0x0f;
    destination[39]  = (source[2] >> 32) & 0x0f;
    destination[40]  = (source[2] >> 28) & 0x0f;
    destination[41]  = (source[2] >> 24) & 0x0f;
    destination[42]  = (source[2] >> 20) & 0x0f;
    destination[43]  = (source[2] >> 16) & 0x0f;
    destination[44]  = (source[2] >> 12) & 0x0f;
    destination[45]  = (source[2] >> 8) & 0x0f;
    destination[46]  = (source[2] >> 4) & 0x0f;
    destination[47]  = (source[2] >> 0) & 0x0f;
    destination[48]  = (source[3] >> 60) & 0x0f;
    destination[49]  = (source[3] >> 56) & 0x0f;
    destination[50]  = (source[3] >> 52) & 0x0f;
    destination[51]  = (source[3] >> 48) & 0x0f;
    destination[52]  = (source[3] >> 44) & 0x0f;
    destination[53]  = (source[3] >> 40) & 0x0f;
    destination[54]  = (source[3] >> 36) & 0x0f;
    destination[55]  = (source[3] >> 32) & 0x0f;
    destination[56]  = (source[3] >> 28) & 0x0f;
    destination[57]  = (source[3] >> 24) & 0x0f;
    destination[58]  = (source[3] >> 20) & 0x0f;
    destination[59]  = (source[3] >> 16) & 0x0f;
    destination[60]  = (source[3] >> 12) & 0x0f;
    destination[61]  = (source[3] >> 8) & 0x0f;
    destination[62]  = (source[3] >> 4) & 0x0f;
    destination[63]  = (source[3] >> 0) & 0x0f;
  }
};
template <typename Tp>
struct __struct_bitpack_impl<Tp,8,5>
{
  static const size_t unit_size = 64;
  static const size_t bits_total = 320;
  static const size_t loop_total = 64;
  static const size_t bit_size = 5;
  static const Tp     mask = 0x1f;
  static inline
  void pack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] & 0x1f) << 59;
    destination[0] |= (source[1] & 0x1f) << 54;
    destination[0] |= (source[2] & 0x1f) << 49;
    destination[0] |= (source[3] & 0x1f) << 44;
    destination[0] |= (source[4] & 0x1f) << 39;
    destination[0] |= (source[5] & 0x1f) << 34;
    destination[0] |= (source[6] & 0x1f) << 29;
    destination[0] |= (source[7] & 0x1f) << 24;
    destination[0] |= (source[8] & 0x1f) << 19;
    destination[0] |= (source[9] & 0x1f) << 14;
    destination[0] |= (source[10] & 0x1f) << 9;
    destination[0] |= (source[11] & 0x1f) << 4;
    destination[0] |= (source[12] & 0x1f) >> 1;
    destination[1]  = (source[12] & 0x1f) << 63;
    destination[1] |= (source[13] & 0x1f) << 58;
    destination[1] |= (source[14] & 0x1f) << 53;
    destination[1] |= (source[15] & 0x1f) << 48;
    destination[1] |= (source[16] & 0x1f) << 43;
    destination[1] |= (source[17] & 0x1f) << 38;
    destination[1] |= (source[18] & 0x1f) << 33;
    destination[1] |= (source[19] & 0x1f) << 28;
    destination[1] |= (source[20] & 0x1f) << 23;
    destination[1] |= (source[21] & 0x1f) << 18;
    destination[1] |= (source[22] & 0x1f) << 13;
    destination[1] |= (source[23] & 0x1f) << 8;
    destination[1] |= (source[24] & 0x1f) << 3;
    destination[1] |= (source[25] & 0x1f) >> 2;
    destination[2]  = (source[25] & 0x1f) << 62;
    destination[2] |= (source[26] & 0x1f) << 57;
    destination[2] |= (source[27] & 0x1f) << 52;
    destination[2] |= (source[28] & 0x1f) << 47;
    destination[2] |= (source[29] & 0x1f) << 42;
    destination[2] |= (source[30] & 0x1f) << 37;
    destination[2] |= (source[31] & 0x1f) << 32;
    destination[2] |= (source[32] & 0x1f) << 27;
    destination[2] |= (source[33] & 0x1f) << 22;
    destination[2] |= (source[34] & 0x1f) << 17;
    destination[2] |= (source[35] & 0x1f) << 12;
    destination[2] |= (source[36] & 0x1f) << 7;
    destination[2] |= (source[37] & 0x1f) << 2;
    destination[2] |= (source[38] & 0x1f) >> 3;
    destination[3]  = (source[38] & 0x1f) << 61;
    destination[3] |= (source[39] & 0x1f) << 56;
    destination[3] |= (source[40] & 0x1f) << 51;
    destination[3] |= (source[41] & 0x1f) << 46;
    destination[3] |= (source[42] & 0x1f) << 41;
    destination[3] |= (source[43] & 0x1f) << 36;
    destination[3] |= (source[44] & 0x1f) << 31;
    destination[3] |= (source[45] & 0x1f) << 26;
    destination[3] |= (source[46] & 0x1f) << 21;
    destination[3] |= (source[47] & 0x1f) << 16;
    destination[3] |= (source[48] & 0x1f) << 11;
    destination[3] |= (source[49] & 0x1f) << 6;
    destination[3] |= (source[50] & 0x1f) << 1;
    destination[3] |= (source[51] & 0x1f) >> 4;
    destination[4]  = (source[51] & 0x1f) << 60;
    destination[4] |= (source[52] & 0x1f) << 55;
    destination[4] |= (source[53] & 0x1f) << 50;
    destination[4] |= (source[54] & 0x1f) << 45;
    destination[4] |= (source[55] & 0x1f) << 40;
    destination[4] |= (source[56] & 0x1f) << 35;
    destination[4] |= (source[57] & 0x1f) << 30;
    destination[4] |= (source[58] & 0x1f) << 25;
    destination[4] |= (source[59] & 0x1f) << 20;
    destination[4] |= (source[60] & 0x1f) << 15;
    destination[4] |= (source[61] & 0x1f) << 10;
    destination[4] |= (source[62] & 0x1f) << 5;
    destination[4] |= (source[63] & 0x1f) << 0;
  }
  static inline
  void unpack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] >> 59) & 0x1f;
    destination[1]  = (source[0] >> 54) & 0x1f;
    destination[2]  = (source[0] >> 49) & 0x1f;
    destination[3]  = (source[0] >> 44) & 0x1f;
    destination[4]  = (source[0] >> 39) & 0x1f;
    destination[5]  = (source[0] >> 34) & 0x1f;
    destination[6]  = (source[0] >> 29) & 0x1f;
    destination[7]  = (source[0] >> 24) & 0x1f;
    destination[8]  = (source[0] >> 19) & 0x1f;
    destination[9]  = (source[0] >> 14) & 0x1f;
    destination[10]  = (source[0] >> 9) & 0x1f;
    destination[11]  = (source[0] >> 4) & 0x1f;
    destination[12]  = (source[0] << 1) & 0x1f;
    destination[12] |= (source[1] >> 63) & 0x1f;
    destination[13]  = (source[1] >> 58) & 0x1f;
    destination[14]  = (source[1] >> 53) & 0x1f;
    destination[15]  = (source[1] >> 48) & 0x1f;
    destination[16]  = (source[1] >> 43) & 0x1f;
    destination[17]  = (source[1] >> 38) & 0x1f;
    destination[18]  = (source[1] >> 33) & 0x1f;
    destination[19]  = (source[1] >> 28) & 0x1f;
    destination[20]  = (source[1] >> 23) & 0x1f;
    destination[21]  = (source[1] >> 18) & 0x1f;
    destination[22]  = (source[1] >> 13) & 0x1f;
    destination[23]  = (source[1] >> 8) & 0x1f;
    destination[24]  = (source[1] >> 3) & 0x1f;
    destination[25]  = (source[1] << 2) & 0x1f;
    destination[25] |= (source[2] >> 62) & 0x1f;
    destination[26]  = (source[2] >> 57) & 0x1f;
    destination[27]  = (source[2] >> 52) & 0x1f;
    destination[28]  = (source[2] >> 47) & 0x1f;
    destination[29]  = (source[2] >> 42) & 0x1f;
    destination[30]  = (source[2] >> 37) & 0x1f;
    destination[31]  = (source[2] >> 32) & 0x1f;
    destination[32]  = (source[2] >> 27) & 0x1f;
    destination[33]  = (source[2] >> 22) & 0x1f;
    destination[34]  = (source[2] >> 17) & 0x1f;
    destination[35]  = (source[2] >> 12) & 0x1f;
    destination[36]  = (source[2] >> 7) & 0x1f;
    destination[37]  = (source[2] >> 2) & 0x1f;
    destination[38]  = (source[2] << 3) & 0x1f;
    destination[38] |= (source[3] >> 61) & 0x1f;
    destination[39]  = (source[3] >> 56) & 0x1f;
    destination[40]  = (source[3] >> 51) & 0x1f;
    destination[41]  = (source[3] >> 46) & 0x1f;
    destination[42]  = (source[3] >> 41) & 0x1f;
    destination[43]  = (source[3] >> 36) & 0x1f;
    destination[44]  = (source[3] >> 31) & 0x1f;
    destination[45]  = (source[3] >> 26) & 0x1f;
    destination[46]  = (source[3] >> 21) & 0x1f;
    destination[47]  = (source[3] >> 16) & 0x1f;
    destination[48]  = (source[3] >> 11) & 0x1f;
    destination[49]  = (source[3] >> 6) & 0x1f;
    destination[50]  = (source[3] >> 1) & 0x1f;
    destination[51]  = (source[3] << 4) & 0x1f;
    destination[51] |= (source[4] >> 60) & 0x1f;
    destination[52]  = (source[4] >> 55) & 0x1f;
    destination[53]  = (source[4] >> 50) & 0x1f;
    destination[54]  = (source[4] >> 45) & 0x1f;
    destination[55]  = (source[4] >> 40) & 0x1f;
    destination[56]  = (source[4] >> 35) & 0x1f;
    destination[57]  = (source[4] >> 30) & 0x1f;
    destination[58]  = (source[4] >> 25) & 0x1f;
    destination[59]  = (source[4] >> 20) & 0x1f;
    destination[60]  = (source[4] >> 15) & 0x1f;
    destination[61]  = (source[4] >> 10) & 0x1f;
    destination[62]  = (source[4] >> 5) & 0x1f;
    destination[63]  = (source[4] >> 0) & 0x1f;
  }
};
template <typename Tp>
struct __struct_bitpack_impl<Tp,8,6>
{
  static const size_t unit_size = 64;
  static const size_t bits_total = 384;
  static const size_t loop_total = 64;
  static const size_t bit_size = 6;
  static const Tp     mask = 0x3f;
  static inline
  void pack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] & 0x3f) << 58;
    destination[0] |= (source[1] & 0x3f) << 52;
    destination[0] |= (source[2] & 0x3f) << 46;
    destination[0] |= (source[3] & 0x3f) << 40;
    destination[0] |= (source[4] & 0x3f) << 34;
    destination[0] |= (source[5] & 0x3f) << 28;
    destination[0] |= (source[6] & 0x3f) << 22;
    destination[0] |= (source[7] & 0x3f) << 16;
    destination[0] |= (source[8] & 0x3f) << 10;
    destination[0] |= (source[9] & 0x3f) << 4;
    destination[0] |= (source[10] & 0x3f) >> 2;
    destination[1]  = (source[10] & 0x3f) << 62;
    destination[1] |= (source[11] & 0x3f) << 56;
    destination[1] |= (source[12] & 0x3f) << 50;
    destination[1] |= (source[13] & 0x3f) << 44;
    destination[1] |= (source[14] & 0x3f) << 38;
    destination[1] |= (source[15] & 0x3f) << 32;
    destination[1] |= (source[16] & 0x3f) << 26;
    destination[1] |= (source[17] & 0x3f) << 20;
    destination[1] |= (source[18] & 0x3f) << 14;
    destination[1] |= (source[19] & 0x3f) << 8;
    destination[1] |= (source[20] & 0x3f) << 2;
    destination[1] |= (source[21] & 0x3f) >> 4;
    destination[2]  = (source[21] & 0x3f) << 60;
    destination[2] |= (source[22] & 0x3f) << 54;
    destination[2] |= (source[23] & 0x3f) << 48;
    destination[2] |= (source[24] & 0x3f) << 42;
    destination[2] |= (source[25] & 0x3f) << 36;
    destination[2] |= (source[26] & 0x3f) << 30;
    destination[2] |= (source[27] & 0x3f) << 24;
    destination[2] |= (source[28] & 0x3f) << 18;
    destination[2] |= (source[29] & 0x3f) << 12;
    destination[2] |= (source[30] & 0x3f) << 6;
    destination[2] |= (source[31] & 0x3f) << 0;
    destination[3]  = (source[32] & 0x3f) << 58;
    destination[3] |= (source[33] & 0x3f) << 52;
    destination[3] |= (source[34] & 0x3f) << 46;
    destination[3] |= (source[35] & 0x3f) << 40;
    destination[3] |= (source[36] & 0x3f) << 34;
    destination[3] |= (source[37] & 0x3f) << 28;
    destination[3] |= (source[38] & 0x3f) << 22;
    destination[3] |= (source[39] & 0x3f) << 16;
    destination[3] |= (source[40] & 0x3f) << 10;
    destination[3] |= (source[41] & 0x3f) << 4;
    destination[3] |= (source[42] & 0x3f) >> 2;
    destination[4]  = (source[42] & 0x3f) << 62;
    destination[4] |= (source[43] & 0x3f) << 56;
    destination[4] |= (source[44] & 0x3f) << 50;
    destination[4] |= (source[45] & 0x3f) << 44;
    destination[4] |= (source[46] & 0x3f) << 38;
    destination[4] |= (source[47] & 0x3f) << 32;
    destination[4] |= (source[48] & 0x3f) << 26;
    destination[4] |= (source[49] & 0x3f) << 20;
    destination[4] |= (source[50] & 0x3f) << 14;
    destination[4] |= (source[51] & 0x3f) << 8;
    destination[4] |= (source[52] & 0x3f) << 2;
    destination[4] |= (source[53] & 0x3f) >> 4;
    destination[5]  = (source[53] & 0x3f) << 60;
    destination[5] |= (source[54] & 0x3f) << 54;
    destination[5] |= (source[55] & 0x3f) << 48;
    destination[5] |= (source[56] & 0x3f) << 42;
    destination[5] |= (source[57] & 0x3f) << 36;
    destination[5] |= (source[58] & 0x3f) << 30;
    destination[5] |= (source[59] & 0x3f) << 24;
    destination[5] |= (source[60] & 0x3f) << 18;
    destination[5] |= (source[61] & 0x3f) << 12;
    destination[5] |= (source[62] & 0x3f) << 6;
    destination[5] |= (source[63] & 0x3f) << 0;
  }
  static inline
  void unpack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] >> 58) & 0x3f;
    destination[1]  = (source[0] >> 52) & 0x3f;
    destination[2]  = (source[0] >> 46) & 0x3f;
    destination[3]  = (source[0] >> 40) & 0x3f;
    destination[4]  = (source[0] >> 34) & 0x3f;
    destination[5]  = (source[0] >> 28) & 0x3f;
    destination[6]  = (source[0] >> 22) & 0x3f;
    destination[7]  = (source[0] >> 16) & 0x3f;
    destination[8]  = (source[0] >> 10) & 0x3f;
    destination[9]  = (source[0] >> 4) & 0x3f;
    destination[10]  = (source[0] << 2) & 0x3f;
    destination[10] |= (source[1] >> 62) & 0x3f;
    destination[11]  = (source[1] >> 56) & 0x3f;
    destination[12]  = (source[1] >> 50) & 0x3f;
    destination[13]  = (source[1] >> 44) & 0x3f;
    destination[14]  = (source[1] >> 38) & 0x3f;
    destination[15]  = (source[1] >> 32) & 0x3f;
    destination[16]  = (source[1] >> 26) & 0x3f;
    destination[17]  = (source[1] >> 20) & 0x3f;
    destination[18]  = (source[1] >> 14) & 0x3f;
    destination[19]  = (source[1] >> 8) & 0x3f;
    destination[20]  = (source[1] >> 2) & 0x3f;
    destination[21]  = (source[1] << 4) & 0x3f;
    destination[21] |= (source[2] >> 60) & 0x3f;
    destination[22]  = (source[2] >> 54) & 0x3f;
    destination[23]  = (source[2] >> 48) & 0x3f;
    destination[24]  = (source[2] >> 42) & 0x3f;
    destination[25]  = (source[2] >> 36) & 0x3f;
    destination[26]  = (source[2] >> 30) & 0x3f;
    destination[27]  = (source[2] >> 24) & 0x3f;
    destination[28]  = (source[2] >> 18) & 0x3f;
    destination[29]  = (source[2] >> 12) & 0x3f;
    destination[30]  = (source[2] >> 6) & 0x3f;
    destination[31]  = (source[2] >> 0) & 0x3f;
    destination[32]  = (source[3] >> 58) & 0x3f;
    destination[33]  = (source[3] >> 52) & 0x3f;
    destination[34]  = (source[3] >> 46) & 0x3f;
    destination[35]  = (source[3] >> 40) & 0x3f;
    destination[36]  = (source[3] >> 34) & 0x3f;
    destination[37]  = (source[3] >> 28) & 0x3f;
    destination[38]  = (source[3] >> 22) & 0x3f;
    destination[39]  = (source[3] >> 16) & 0x3f;
    destination[40]  = (source[3] >> 10) & 0x3f;
    destination[41]  = (source[3] >> 4) & 0x3f;
    destination[42]  = (source[3] << 2) & 0x3f;
    destination[42] |= (source[4] >> 62) & 0x3f;
    destination[43]  = (source[4] >> 56) & 0x3f;
    destination[44]  = (source[4] >> 50) & 0x3f;
    destination[45]  = (source[4] >> 44) & 0x3f;
    destination[46]  = (source[4] >> 38) & 0x3f;
    destination[47]  = (source[4] >> 32) & 0x3f;
    destination[48]  = (source[4] >> 26) & 0x3f;
    destination[49]  = (source[4] >> 20) & 0x3f;
    destination[50]  = (source[4] >> 14) & 0x3f;
    destination[51]  = (source[4] >> 8) & 0x3f;
    destination[52]  = (source[4] >> 2) & 0x3f;
    destination[53]  = (source[4] << 4) & 0x3f;
    destination[53] |= (source[5] >> 60) & 0x3f;
    destination[54]  = (source[5] >> 54) & 0x3f;
    destination[55]  = (source[5] >> 48) & 0x3f;
    destination[56]  = (source[5] >> 42) & 0x3f;
    destination[57]  = (source[5] >> 36) & 0x3f;
    destination[58]  = (source[5] >> 30) & 0x3f;
    destination[59]  = (source[5] >> 24) & 0x3f;
    destination[60]  = (source[5] >> 18) & 0x3f;
    destination[61]  = (source[5] >> 12) & 0x3f;
    destination[62]  = (source[5] >> 6) & 0x3f;
    destination[63]  = (source[5] >> 0) & 0x3f;
  }
};
template <typename Tp>
struct __struct_bitpack_impl<Tp,8,7>
{
  static const size_t unit_size = 64;
  static const size_t bits_total = 448;
  static const size_t loop_total = 64;
  static const size_t bit_size = 7;
  static const Tp     mask = 0x7f;
  static inline
  void pack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] & 0x7f) << 57;
    destination[0] |= (source[1] & 0x7f) << 50;
    destination[0] |= (source[2] & 0x7f) << 43;
    destination[0] |= (source[3] & 0x7f) << 36;
    destination[0] |= (source[4] & 0x7f) << 29;
    destination[0] |= (source[5] & 0x7f) << 22;
    destination[0] |= (source[6] & 0x7f) << 15;
    destination[0] |= (source[7] & 0x7f) << 8;
    destination[0] |= (source[8] & 0x7f) << 1;
    destination[0] |= (source[9] & 0x7f) >> 6;
    destination[1]  = (source[9] & 0x7f) << 58;
    destination[1] |= (source[10] & 0x7f) << 51;
    destination[1] |= (source[11] & 0x7f) << 44;
    destination[1] |= (source[12] & 0x7f) << 37;
    destination[1] |= (source[13] & 0x7f) << 30;
    destination[1] |= (source[14] & 0x7f) << 23;
    destination[1] |= (source[15] & 0x7f) << 16;
    destination[1] |= (source[16] & 0x7f) << 9;
    destination[1] |= (source[17] & 0x7f) << 2;
    destination[1] |= (source[18] & 0x7f) >> 5;
    destination[2]  = (source[18] & 0x7f) << 59;
    destination[2] |= (source[19] & 0x7f) << 52;
    destination[2] |= (source[20] & 0x7f) << 45;
    destination[2] |= (source[21] & 0x7f) << 38;
    destination[2] |= (source[22] & 0x7f) << 31;
    destination[2] |= (source[23] & 0x7f) << 24;
    destination[2] |= (source[24] & 0x7f) << 17;
    destination[2] |= (source[25] & 0x7f) << 10;
    destination[2] |= (source[26] & 0x7f) << 3;
    destination[2] |= (source[27] & 0x7f) >> 4;
    destination[3]  = (source[27] & 0x7f) << 60;
    destination[3] |= (source[28] & 0x7f) << 53;
    destination[3] |= (source[29] & 0x7f) << 46;
    destination[3] |= (source[30] & 0x7f) << 39;
    destination[3] |= (source[31] & 0x7f) << 32;
    destination[3] |= (source[32] & 0x7f) << 25;
    destination[3] |= (source[33] & 0x7f) << 18;
    destination[3] |= (source[34] & 0x7f) << 11;
    destination[3] |= (source[35] & 0x7f) << 4;
    destination[3] |= (source[36] & 0x7f) >> 3;
    destination[4]  = (source[36] & 0x7f) << 61;
    destination[4] |= (source[37] & 0x7f) << 54;
    destination[4] |= (source[38] & 0x7f) << 47;
    destination[4] |= (source[39] & 0x7f) << 40;
    destination[4] |= (source[40] & 0x7f) << 33;
    destination[4] |= (source[41] & 0x7f) << 26;
    destination[4] |= (source[42] & 0x7f) << 19;
    destination[4] |= (source[43] & 0x7f) << 12;
    destination[4] |= (source[44] & 0x7f) << 5;
    destination[4] |= (source[45] & 0x7f) >> 2;
    destination[5]  = (source[45] & 0x7f) << 62;
    destination[5] |= (source[46] & 0x7f) << 55;
    destination[5] |= (source[47] & 0x7f) << 48;
    destination[5] |= (source[48] & 0x7f) << 41;
    destination[5] |= (source[49] & 0x7f) << 34;
    destination[5] |= (source[50] & 0x7f) << 27;
    destination[5] |= (source[51] & 0x7f) << 20;
    destination[5] |= (source[52] & 0x7f) << 13;
    destination[5] |= (source[53] & 0x7f) << 6;
    destination[5] |= (source[54] & 0x7f) >> 1;
    destination[6]  = (source[54] & 0x7f) << 63;
    destination[6] |= (source[55] & 0x7f) << 56;
    destination[6] |= (source[56] & 0x7f) << 49;
    destination[6] |= (source[57] & 0x7f) << 42;
    destination[6] |= (source[58] & 0x7f) << 35;
    destination[6] |= (source[59] & 0x7f) << 28;
    destination[6] |= (source[60] & 0x7f) << 21;
    destination[6] |= (source[61] & 0x7f) << 14;
    destination[6] |= (source[62] & 0x7f) << 7;
    destination[6] |= (source[63] & 0x7f) << 0;
  }
  static inline
  void unpack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] >> 57) & 0x7f;
    destination[1]  = (source[0] >> 50) & 0x7f;
    destination[2]  = (source[0] >> 43) & 0x7f;
    destination[3]  = (source[0] >> 36) & 0x7f;
    destination[4]  = (source[0] >> 29) & 0x7f;
    destination[5]  = (source[0] >> 22) & 0x7f;
    destination[6]  = (source[0] >> 15) & 0x7f;
    destination[7]  = (source[0] >> 8) & 0x7f;
    destination[8]  = (source[0] >> 1) & 0x7f;
    destination[9]  = (source[0] << 6) & 0x7f;
    destination[9] |= (source[1] >> 58) & 0x7f;
    destination[10]  = (source[1] >> 51) & 0x7f;
    destination[11]  = (source[1] >> 44) & 0x7f;
    destination[12]  = (source[1] >> 37) & 0x7f;
    destination[13]  = (source[1] >> 30) & 0x7f;
    destination[14]  = (source[1] >> 23) & 0x7f;
    destination[15]  = (source[1] >> 16) & 0x7f;
    destination[16]  = (source[1] >> 9) & 0x7f;
    destination[17]  = (source[1] >> 2) & 0x7f;
    destination[18]  = (source[1] << 5) & 0x7f;
    destination[18] |= (source[2] >> 59) & 0x7f;
    destination[19]  = (source[2] >> 52) & 0x7f;
    destination[20]  = (source[2] >> 45) & 0x7f;
    destination[21]  = (source[2] >> 38) & 0x7f;
    destination[22]  = (source[2] >> 31) & 0x7f;
    destination[23]  = (source[2] >> 24) & 0x7f;
    destination[24]  = (source[2] >> 17) & 0x7f;
    destination[25]  = (source[2] >> 10) & 0x7f;
    destination[26]  = (source[2] >> 3) & 0x7f;
    destination[27]  = (source[2] << 4) & 0x7f;
    destination[27] |= (source[3] >> 60) & 0x7f;
    destination[28]  = (source[3] >> 53) & 0x7f;
    destination[29]  = (source[3] >> 46) & 0x7f;
    destination[30]  = (source[3] >> 39) & 0x7f;
    destination[31]  = (source[3] >> 32) & 0x7f;
    destination[32]  = (source[3] >> 25) & 0x7f;
    destination[33]  = (source[3] >> 18) & 0x7f;
    destination[34]  = (source[3] >> 11) & 0x7f;
    destination[35]  = (source[3] >> 4) & 0x7f;
    destination[36]  = (source[3] << 3) & 0x7f;
    destination[36] |= (source[4] >> 61) & 0x7f;
    destination[37]  = (source[4] >> 54) & 0x7f;
    destination[38]  = (source[4] >> 47) & 0x7f;
    destination[39]  = (source[4] >> 40) & 0x7f;
    destination[40]  = (source[4] >> 33) & 0x7f;
    destination[41]  = (source[4] >> 26) & 0x7f;
    destination[42]  = (source[4] >> 19) & 0x7f;
    destination[43]  = (source[4] >> 12) & 0x7f;
    destination[44]  = (source[4] >> 5) & 0x7f;
    destination[45]  = (source[4] << 2) & 0x7f;
    destination[45] |= (source[5] >> 62) & 0x7f;
    destination[46]  = (source[5] >> 55) & 0x7f;
    destination[47]  = (source[5] >> 48) & 0x7f;
    destination[48]  = (source[5] >> 41) & 0x7f;
    destination[49]  = (source[5] >> 34) & 0x7f;
    destination[50]  = (source[5] >> 27) & 0x7f;
    destination[51]  = (source[5] >> 20) & 0x7f;
    destination[52]  = (source[5] >> 13) & 0x7f;
    destination[53]  = (source[5] >> 6) & 0x7f;
    destination[54]  = (source[5] << 1) & 0x7f;
    destination[54] |= (source[6] >> 63) & 0x7f;
    destination[55]  = (source[6] >> 56) & 0x7f;
    destination[56]  = (source[6] >> 49) & 0x7f;
    destination[57]  = (source[6] >> 42) & 0x7f;
    destination[58]  = (source[6] >> 35) & 0x7f;
    destination[59]  = (source[6] >> 28) & 0x7f;
    destination[60]  = (source[6] >> 21) & 0x7f;
    destination[61]  = (source[6] >> 14) & 0x7f;
    destination[62]  = (source[6] >> 7) & 0x7f;
    destination[63]  = (source[6] >> 0) & 0x7f;
  }
};
template <typename Tp>
struct __struct_bitpack_impl<Tp,8,8>
{
  static const size_t unit_size = 64;
  static const size_t bits_total = 512;
  static const size_t loop_total = 64;
  static const size_t bit_size = 8;
  static const Tp     mask = 0xff;
  static inline
  void pack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] & 0xff) << 56;
    destination[0] |= (source[1] & 0xff) << 48;
    destination[0] |= (source[2] & 0xff) << 40;
    destination[0] |= (source[3] & 0xff) << 32;
    destination[0] |= (source[4] & 0xff) << 24;
    destination[0] |= (source[5] & 0xff) << 16;
    destination[0] |= (source[6] & 0xff) << 8;
    destination[0] |= (source[7] & 0xff) << 0;
    destination[1]  = (source[8] & 0xff) << 56;
    destination[1] |= (source[9] & 0xff) << 48;
    destination[1] |= (source[10] & 0xff) << 40;
    destination[1] |= (source[11] & 0xff) << 32;
    destination[1] |= (source[12] & 0xff) << 24;
    destination[1] |= (source[13] & 0xff) << 16;
    destination[1] |= (source[14] & 0xff) << 8;
    destination[1] |= (source[15] & 0xff) << 0;
    destination[2]  = (source[16] & 0xff) << 56;
    destination[2] |= (source[17] & 0xff) << 48;
    destination[2] |= (source[18] & 0xff) << 40;
    destination[2] |= (source[19] & 0xff) << 32;
    destination[2] |= (source[20] & 0xff) << 24;
    destination[2] |= (source[21] & 0xff) << 16;
    destination[2] |= (source[22] & 0xff) << 8;
    destination[2] |= (source[23] & 0xff) << 0;
    destination[3]  = (source[24] & 0xff) << 56;
    destination[3] |= (source[25] & 0xff) << 48;
    destination[3] |= (source[26] & 0xff) << 40;
    destination[3] |= (source[27] & 0xff) << 32;
    destination[3] |= (source[28] & 0xff) << 24;
    destination[3] |= (source[29] & 0xff) << 16;
    destination[3] |= (source[30] & 0xff) << 8;
    destination[3] |= (source[31] & 0xff) << 0;
    destination[4]  = (source[32] & 0xff) << 56;
    destination[4] |= (source[33] & 0xff) << 48;
    destination[4] |= (source[34] & 0xff) << 40;
    destination[4] |= (source[35] & 0xff) << 32;
    destination[4] |= (source[36] & 0xff) << 24;
    destination[4] |= (source[37] & 0xff) << 16;
    destination[4] |= (source[38] & 0xff) << 8;
    destination[4] |= (source[39] & 0xff) << 0;
    destination[5]  = (source[40] & 0xff) << 56;
    destination[5] |= (source[41] & 0xff) << 48;
    destination[5] |= (source[42] & 0xff) << 40;
    destination[5] |= (source[43] & 0xff) << 32;
    destination[5] |= (source[44] & 0xff) << 24;
    destination[5] |= (source[45] & 0xff) << 16;
    destination[5] |= (source[46] & 0xff) << 8;
    destination[5] |= (source[47] & 0xff) << 0;
    destination[6]  = (source[48] & 0xff) << 56;
    destination[6] |= (source[49] & 0xff) << 48;
    destination[6] |= (source[50] & 0xff) << 40;
    destination[6] |= (source[51] & 0xff) << 32;
    destination[6] |= (source[52] & 0xff) << 24;
    destination[6] |= (source[53] & 0xff) << 16;
    destination[6] |= (source[54] & 0xff) << 8;
    destination[6] |= (source[55] & 0xff) << 0;
    destination[7]  = (source[56] & 0xff) << 56;
    destination[7] |= (source[57] & 0xff) << 48;
    destination[7] |= (source[58] & 0xff) << 40;
    destination[7] |= (source[59] & 0xff) << 32;
    destination[7] |= (source[60] & 0xff) << 24;
    destination[7] |= (source[61] & 0xff) << 16;
    destination[7] |= (source[62] & 0xff) << 8;
    destination[7] |= (source[63] & 0xff) << 0;
  }
  static inline
  void unpack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] >> 56) & 0xff;
    destination[1]  = (source[0] >> 48) & 0xff;
    destination[2]  = (source[0] >> 40) & 0xff;
    destination[3]  = (source[0] >> 32) & 0xff;
    destination[4]  = (source[0] >> 24) & 0xff;
    destination[5]  = (source[0] >> 16) & 0xff;
    destination[6]  = (source[0] >> 8) & 0xff;
    destination[7]  = (source[0] >> 0) & 0xff;
    destination[8]  = (source[1] >> 56) & 0xff;
    destination[9]  = (source[1] >> 48) & 0xff;
    destination[10]  = (source[1] >> 40) & 0xff;
    destination[11]  = (source[1] >> 32) & 0xff;
    destination[12]  = (source[1] >> 24) & 0xff;
    destination[13]  = (source[1] >> 16) & 0xff;
    destination[14]  = (source[1] >> 8) & 0xff;
    destination[15]  = (source[1] >> 0) & 0xff;
    destination[16]  = (source[2] >> 56) & 0xff;
    destination[17]  = (source[2] >> 48) & 0xff;
    destination[18]  = (source[2] >> 40) & 0xff;
    destination[19]  = (source[2] >> 32) & 0xff;
    destination[20]  = (source[2] >> 24) & 0xff;
    destination[21]  = (source[2] >> 16) & 0xff;
    destination[22]  = (source[2] >> 8) & 0xff;
    destination[23]  = (source[2] >> 0) & 0xff;
    destination[24]  = (source[3] >> 56) & 0xff;
    destination[25]  = (source[3] >> 48) & 0xff;
    destination[26]  = (source[3] >> 40) & 0xff;
    destination[27]  = (source[3] >> 32) & 0xff;
    destination[28]  = (source[3] >> 24) & 0xff;
    destination[29]  = (source[3] >> 16) & 0xff;
    destination[30]  = (source[3] >> 8) & 0xff;
    destination[31]  = (source[3] >> 0) & 0xff;
    destination[32]  = (source[4] >> 56) & 0xff;
    destination[33]  = (source[4] >> 48) & 0xff;
    destination[34]  = (source[4] >> 40) & 0xff;
    destination[35]  = (source[4] >> 32) & 0xff;
    destination[36]  = (source[4] >> 24) & 0xff;
    destination[37]  = (source[4] >> 16) & 0xff;
    destination[38]  = (source[4] >> 8) & 0xff;
    destination[39]  = (source[4] >> 0) & 0xff;
    destination[40]  = (source[5] >> 56) & 0xff;
    destination[41]  = (source[5] >> 48) & 0xff;
    destination[42]  = (source[5] >> 40) & 0xff;
    destination[43]  = (source[5] >> 32) & 0xff;
    destination[44]  = (source[5] >> 24) & 0xff;
    destination[45]  = (source[5] >> 16) & 0xff;
    destination[46]  = (source[5] >> 8) & 0xff;
    destination[47]  = (source[5] >> 0) & 0xff;
    destination[48]  = (source[6] >> 56) & 0xff;
    destination[49]  = (source[6] >> 48) & 0xff;
    destination[50]  = (source[6] >> 40) & 0xff;
    destination[51]  = (source[6] >> 32) & 0xff;
    destination[52]  = (source[6] >> 24) & 0xff;
    destination[53]  = (source[6] >> 16) & 0xff;
    destination[54]  = (source[6] >> 8) & 0xff;
    destination[55]  = (source[6] >> 0) & 0xff;
    destination[56]  = (source[7] >> 56) & 0xff;
    destination[57]  = (source[7] >> 48) & 0xff;
    destination[58]  = (source[7] >> 40) & 0xff;
    destination[59]  = (source[7] >> 32) & 0xff;
    destination[60]  = (source[7] >> 24) & 0xff;
    destination[61]  = (source[7] >> 16) & 0xff;
    destination[62]  = (source[7] >> 8) & 0xff;
    destination[63]  = (source[7] >> 0) & 0xff;
  }
};
template <typename Tp>
struct __struct_bitpack_impl<Tp,8,9>
{
  static const size_t unit_size = 64;
  static const size_t bits_total = 576;
  static const size_t loop_total = 64;
  static const size_t bit_size = 9;
  static const Tp     mask = 0x1ff;
  static inline
  void pack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] & 0x1ff) << 55;
    destination[0] |= (source[1] & 0x1ff) << 46;
    destination[0] |= (source[2] & 0x1ff) << 37;
    destination[0] |= (source[3] & 0x1ff) << 28;
    destination[0] |= (source[4] & 0x1ff) << 19;
    destination[0] |= (source[5] & 0x1ff) << 10;
    destination[0] |= (source[6] & 0x1ff) << 1;
    destination[0] |= (source[7] & 0x1ff) >> 8;
    destination[1]  = (source[7] & 0x1ff) << 56;
    destination[1] |= (source[8] & 0x1ff) << 47;
    destination[1] |= (source[9] & 0x1ff) << 38;
    destination[1] |= (source[10] & 0x1ff) << 29;
    destination[1] |= (source[11] & 0x1ff) << 20;
    destination[1] |= (source[12] & 0x1ff) << 11;
    destination[1] |= (source[13] & 0x1ff) << 2;
    destination[1] |= (source[14] & 0x1ff) >> 7;
    destination[2]  = (source[14] & 0x1ff) << 57;
    destination[2] |= (source[15] & 0x1ff) << 48;
    destination[2] |= (source[16] & 0x1ff) << 39;
    destination[2] |= (source[17] & 0x1ff) << 30;
    destination[2] |= (source[18] & 0x1ff) << 21;
    destination[2] |= (source[19] & 0x1ff) << 12;
    destination[2] |= (source[20] & 0x1ff) << 3;
    destination[2] |= (source[21] & 0x1ff) >> 6;
    destination[3]  = (source[21] & 0x1ff) << 58;
    destination[3] |= (source[22] & 0x1ff) << 49;
    destination[3] |= (source[23] & 0x1ff) << 40;
    destination[3] |= (source[24] & 0x1ff) << 31;
    destination[3] |= (source[25] & 0x1ff) << 22;
    destination[3] |= (source[26] & 0x1ff) << 13;
    destination[3] |= (source[27] & 0x1ff) << 4;
    destination[3] |= (source[28] & 0x1ff) >> 5;
    destination[4]  = (source[28] & 0x1ff) << 59;
    destination[4] |= (source[29] & 0x1ff) << 50;
    destination[4] |= (source[30] & 0x1ff) << 41;
    destination[4] |= (source[31] & 0x1ff) << 32;
    destination[4] |= (source[32] & 0x1ff) << 23;
    destination[4] |= (source[33] & 0x1ff) << 14;
    destination[4] |= (source[34] & 0x1ff) << 5;
    destination[4] |= (source[35] & 0x1ff) >> 4;
    destination[5]  = (source[35] & 0x1ff) << 60;
    destination[5] |= (source[36] & 0x1ff) << 51;
    destination[5] |= (source[37] & 0x1ff) << 42;
    destination[5] |= (source[38] & 0x1ff) << 33;
    destination[5] |= (source[39] & 0x1ff) << 24;
    destination[5] |= (source[40] & 0x1ff) << 15;
    destination[5] |= (source[41] & 0x1ff) << 6;
    destination[5] |= (source[42] & 0x1ff) >> 3;
    destination[6]  = (source[42] & 0x1ff) << 61;
    destination[6] |= (source[43] & 0x1ff) << 52;
    destination[6] |= (source[44] & 0x1ff) << 43;
    destination[6] |= (source[45] & 0x1ff) << 34;
    destination[6] |= (source[46] & 0x1ff) << 25;
    destination[6] |= (source[47] & 0x1ff) << 16;
    destination[6] |= (source[48] & 0x1ff) << 7;
    destination[6] |= (source[49] & 0x1ff) >> 2;
    destination[7]  = (source[49] & 0x1ff) << 62;
    destination[7] |= (source[50] & 0x1ff) << 53;
    destination[7] |= (source[51] & 0x1ff) << 44;
    destination[7] |= (source[52] & 0x1ff) << 35;
    destination[7] |= (source[53] & 0x1ff) << 26;
    destination[7] |= (source[54] & 0x1ff) << 17;
    destination[7] |= (source[55] & 0x1ff) << 8;
    destination[7] |= (source[56] & 0x1ff) >> 1;
    destination[8]  = (source[56] & 0x1ff) << 63;
    destination[8] |= (source[57] & 0x1ff) << 54;
    destination[8] |= (source[58] & 0x1ff) << 45;
    destination[8] |= (source[59] & 0x1ff) << 36;
    destination[8] |= (source[60] & 0x1ff) << 27;
    destination[8] |= (source[61] & 0x1ff) << 18;
    destination[8] |= (source[62] & 0x1ff) << 9;
    destination[8] |= (source[63] & 0x1ff) << 0;
  }
  static inline
  void unpack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] >> 55) & 0x1ff;
    destination[1]  = (source[0] >> 46) & 0x1ff;
    destination[2]  = (source[0] >> 37) & 0x1ff;
    destination[3]  = (source[0] >> 28) & 0x1ff;
    destination[4]  = (source[0] >> 19) & 0x1ff;
    destination[5]  = (source[0] >> 10) & 0x1ff;
    destination[6]  = (source[0] >> 1) & 0x1ff;
    destination[7]  = (source[0] << 8) & 0x1ff;
    destination[7] |= (source[1] >> 56) & 0x1ff;
    destination[8]  = (source[1] >> 47) & 0x1ff;
    destination[9]  = (source[1] >> 38) & 0x1ff;
    destination[10]  = (source[1] >> 29) & 0x1ff;
    destination[11]  = (source[1] >> 20) & 0x1ff;
    destination[12]  = (source[1] >> 11) & 0x1ff;
    destination[13]  = (source[1] >> 2) & 0x1ff;
    destination[14]  = (source[1] << 7) & 0x1ff;
    destination[14] |= (source[2] >> 57) & 0x1ff;
    destination[15]  = (source[2] >> 48) & 0x1ff;
    destination[16]  = (source[2] >> 39) & 0x1ff;
    destination[17]  = (source[2] >> 30) & 0x1ff;
    destination[18]  = (source[2] >> 21) & 0x1ff;
    destination[19]  = (source[2] >> 12) & 0x1ff;
    destination[20]  = (source[2] >> 3) & 0x1ff;
    destination[21]  = (source[2] << 6) & 0x1ff;
    destination[21] |= (source[3] >> 58) & 0x1ff;
    destination[22]  = (source[3] >> 49) & 0x1ff;
    destination[23]  = (source[3] >> 40) & 0x1ff;
    destination[24]  = (source[3] >> 31) & 0x1ff;
    destination[25]  = (source[3] >> 22) & 0x1ff;
    destination[26]  = (source[3] >> 13) & 0x1ff;
    destination[27]  = (source[3] >> 4) & 0x1ff;
    destination[28]  = (source[3] << 5) & 0x1ff;
    destination[28] |= (source[4] >> 59) & 0x1ff;
    destination[29]  = (source[4] >> 50) & 0x1ff;
    destination[30]  = (source[4] >> 41) & 0x1ff;
    destination[31]  = (source[4] >> 32) & 0x1ff;
    destination[32]  = (source[4] >> 23) & 0x1ff;
    destination[33]  = (source[4] >> 14) & 0x1ff;
    destination[34]  = (source[4] >> 5) & 0x1ff;
    destination[35]  = (source[4] << 4) & 0x1ff;
    destination[35] |= (source[5] >> 60) & 0x1ff;
    destination[36]  = (source[5] >> 51) & 0x1ff;
    destination[37]  = (source[5] >> 42) & 0x1ff;
    destination[38]  = (source[5] >> 33) & 0x1ff;
    destination[39]  = (source[5] >> 24) & 0x1ff;
    destination[40]  = (source[5] >> 15) & 0x1ff;
    destination[41]  = (source[5] >> 6) & 0x1ff;
    destination[42]  = (source[5] << 3) & 0x1ff;
    destination[42] |= (source[6] >> 61) & 0x1ff;
    destination[43]  = (source[6] >> 52) & 0x1ff;
    destination[44]  = (source[6] >> 43) & 0x1ff;
    destination[45]  = (source[6] >> 34) & 0x1ff;
    destination[46]  = (source[6] >> 25) & 0x1ff;
    destination[47]  = (source[6] >> 16) & 0x1ff;
    destination[48]  = (source[6] >> 7) & 0x1ff;
    destination[49]  = (source[6] << 2) & 0x1ff;
    destination[49] |= (source[7] >> 62) & 0x1ff;
    destination[50]  = (source[7] >> 53) & 0x1ff;
    destination[51]  = (source[7] >> 44) & 0x1ff;
    destination[52]  = (source[7] >> 35) & 0x1ff;
    destination[53]  = (source[7] >> 26) & 0x1ff;
    destination[54]  = (source[7] >> 17) & 0x1ff;
    destination[55]  = (source[7] >> 8) & 0x1ff;
    destination[56]  = (source[7] << 1) & 0x1ff;
    destination[56] |= (source[8] >> 63) & 0x1ff;
    destination[57]  = (source[8] >> 54) & 0x1ff;
    destination[58]  = (source[8] >> 45) & 0x1ff;
    destination[59]  = (source[8] >> 36) & 0x1ff;
    destination[60]  = (source[8] >> 27) & 0x1ff;
    destination[61]  = (source[8] >> 18) & 0x1ff;
    destination[62]  = (source[8] >> 9) & 0x1ff;
    destination[63]  = (source[8] >> 0) & 0x1ff;
  }
};
template <typename Tp>
struct __struct_bitpack_impl<Tp,8,10>
{
  static const size_t unit_size = 64;
  static const size_t bits_total = 640;
  static const size_t loop_total = 64;
  static const size_t bit_size = 10;
  static const Tp     mask = 0x3ff;
  static inline
  void pack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] & 0x3ff) << 54;
    destination[0] |= (source[1] & 0x3ff) << 44;
    destination[0] |= (source[2] & 0x3ff) << 34;
    destination[0] |= (source[3] & 0x3ff) << 24;
    destination[0] |= (source[4] & 0x3ff) << 14;
    destination[0] |= (source[5] & 0x3ff) << 4;
    destination[0] |= (source[6] & 0x3ff) >> 6;
    destination[1]  = (source[6] & 0x3ff) << 58;
    destination[1] |= (source[7] & 0x3ff) << 48;
    destination[1] |= (source[8] & 0x3ff) << 38;
    destination[1] |= (source[9] & 0x3ff) << 28;
    destination[1] |= (source[10] & 0x3ff) << 18;
    destination[1] |= (source[11] & 0x3ff) << 8;
    destination[1] |= (source[12] & 0x3ff) >> 2;
    destination[2]  = (source[12] & 0x3ff) << 62;
    destination[2] |= (source[13] & 0x3ff) << 52;
    destination[2] |= (source[14] & 0x3ff) << 42;
    destination[2] |= (source[15] & 0x3ff) << 32;
    destination[2] |= (source[16] & 0x3ff) << 22;
    destination[2] |= (source[17] & 0x3ff) << 12;
    destination[2] |= (source[18] & 0x3ff) << 2;
    destination[2] |= (source[19] & 0x3ff) >> 8;
    destination[3]  = (source[19] & 0x3ff) << 56;
    destination[3] |= (source[20] & 0x3ff) << 46;
    destination[3] |= (source[21] & 0x3ff) << 36;
    destination[3] |= (source[22] & 0x3ff) << 26;
    destination[3] |= (source[23] & 0x3ff) << 16;
    destination[3] |= (source[24] & 0x3ff) << 6;
    destination[3] |= (source[25] & 0x3ff) >> 4;
    destination[4]  = (source[25] & 0x3ff) << 60;
    destination[4] |= (source[26] & 0x3ff) << 50;
    destination[4] |= (source[27] & 0x3ff) << 40;
    destination[4] |= (source[28] & 0x3ff) << 30;
    destination[4] |= (source[29] & 0x3ff) << 20;
    destination[4] |= (source[30] & 0x3ff) << 10;
    destination[4] |= (source[31] & 0x3ff) << 0;
    destination[5]  = (source[32] & 0x3ff) << 54;
    destination[5] |= (source[33] & 0x3ff) << 44;
    destination[5] |= (source[34] & 0x3ff) << 34;
    destination[5] |= (source[35] & 0x3ff) << 24;
    destination[5] |= (source[36] & 0x3ff) << 14;
    destination[5] |= (source[37] & 0x3ff) << 4;
    destination[5] |= (source[38] & 0x3ff) >> 6;
    destination[6]  = (source[38] & 0x3ff) << 58;
    destination[6] |= (source[39] & 0x3ff) << 48;
    destination[6] |= (source[40] & 0x3ff) << 38;
    destination[6] |= (source[41] & 0x3ff) << 28;
    destination[6] |= (source[42] & 0x3ff) << 18;
    destination[6] |= (source[43] & 0x3ff) << 8;
    destination[6] |= (source[44] & 0x3ff) >> 2;
    destination[7]  = (source[44] & 0x3ff) << 62;
    destination[7] |= (source[45] & 0x3ff) << 52;
    destination[7] |= (source[46] & 0x3ff) << 42;
    destination[7] |= (source[47] & 0x3ff) << 32;
    destination[7] |= (source[48] & 0x3ff) << 22;
    destination[7] |= (source[49] & 0x3ff) << 12;
    destination[7] |= (source[50] & 0x3ff) << 2;
    destination[7] |= (source[51] & 0x3ff) >> 8;
    destination[8]  = (source[51] & 0x3ff) << 56;
    destination[8] |= (source[52] & 0x3ff) << 46;
    destination[8] |= (source[53] & 0x3ff) << 36;
    destination[8] |= (source[54] & 0x3ff) << 26;
    destination[8] |= (source[55] & 0x3ff) << 16;
    destination[8] |= (source[56] & 0x3ff) << 6;
    destination[8] |= (source[57] & 0x3ff) >> 4;
    destination[9]  = (source[57] & 0x3ff) << 60;
    destination[9] |= (source[58] & 0x3ff) << 50;
    destination[9] |= (source[59] & 0x3ff) << 40;
    destination[9] |= (source[60] & 0x3ff) << 30;
    destination[9] |= (source[61] & 0x3ff) << 20;
    destination[9] |= (source[62] & 0x3ff) << 10;
    destination[9] |= (source[63] & 0x3ff) << 0;
  }
  static inline
  void unpack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] >> 54) & 0x3ff;
    destination[1]  = (source[0] >> 44) & 0x3ff;
    destination[2]  = (source[0] >> 34) & 0x3ff;
    destination[3]  = (source[0] >> 24) & 0x3ff;
    destination[4]  = (source[0] >> 14) & 0x3ff;
    destination[5]  = (source[0] >> 4) & 0x3ff;
    destination[6]  = (source[0] << 6) & 0x3ff;
    destination[6] |= (source[1] >> 58) & 0x3ff;
    destination[7]  = (source[1] >> 48) & 0x3ff;
    destination[8]  = (source[1] >> 38) & 0x3ff;
    destination[9]  = (source[1] >> 28) & 0x3ff;
    destination[10]  = (source[1] >> 18) & 0x3ff;
    destination[11]  = (source[1] >> 8) & 0x3ff;
    destination[12]  = (source[1] << 2) & 0x3ff;
    destination[12] |= (source[2] >> 62) & 0x3ff;
    destination[13]  = (source[2] >> 52) & 0x3ff;
    destination[14]  = (source[2] >> 42) & 0x3ff;
    destination[15]  = (source[2] >> 32) & 0x3ff;
    destination[16]  = (source[2] >> 22) & 0x3ff;
    destination[17]  = (source[2] >> 12) & 0x3ff;
    destination[18]  = (source[2] >> 2) & 0x3ff;
    destination[19]  = (source[2] << 8) & 0x3ff;
    destination[19] |= (source[3] >> 56) & 0x3ff;
    destination[20]  = (source[3] >> 46) & 0x3ff;
    destination[21]  = (source[3] >> 36) & 0x3ff;
    destination[22]  = (source[3] >> 26) & 0x3ff;
    destination[23]  = (source[3] >> 16) & 0x3ff;
    destination[24]  = (source[3] >> 6) & 0x3ff;
    destination[25]  = (source[3] << 4) & 0x3ff;
    destination[25] |= (source[4] >> 60) & 0x3ff;
    destination[26]  = (source[4] >> 50) & 0x3ff;
    destination[27]  = (source[4] >> 40) & 0x3ff;
    destination[28]  = (source[4] >> 30) & 0x3ff;
    destination[29]  = (source[4] >> 20) & 0x3ff;
    destination[30]  = (source[4] >> 10) & 0x3ff;
    destination[31]  = (source[4] >> 0) & 0x3ff;
    destination[32]  = (source[5] >> 54) & 0x3ff;
    destination[33]  = (source[5] >> 44) & 0x3ff;
    destination[34]  = (source[5] >> 34) & 0x3ff;
    destination[35]  = (source[5] >> 24) & 0x3ff;
    destination[36]  = (source[5] >> 14) & 0x3ff;
    destination[37]  = (source[5] >> 4) & 0x3ff;
    destination[38]  = (source[5] << 6) & 0x3ff;
    destination[38] |= (source[6] >> 58) & 0x3ff;
    destination[39]  = (source[6] >> 48) & 0x3ff;
    destination[40]  = (source[6] >> 38) & 0x3ff;
    destination[41]  = (source[6] >> 28) & 0x3ff;
    destination[42]  = (source[6] >> 18) & 0x3ff;
    destination[43]  = (source[6] >> 8) & 0x3ff;
    destination[44]  = (source[6] << 2) & 0x3ff;
    destination[44] |= (source[7] >> 62) & 0x3ff;
    destination[45]  = (source[7] >> 52) & 0x3ff;
    destination[46]  = (source[7] >> 42) & 0x3ff;
    destination[47]  = (source[7] >> 32) & 0x3ff;
    destination[48]  = (source[7] >> 22) & 0x3ff;
    destination[49]  = (source[7] >> 12) & 0x3ff;
    destination[50]  = (source[7] >> 2) & 0x3ff;
    destination[51]  = (source[7] << 8) & 0x3ff;
    destination[51] |= (source[8] >> 56) & 0x3ff;
    destination[52]  = (source[8] >> 46) & 0x3ff;
    destination[53]  = (source[8] >> 36) & 0x3ff;
    destination[54]  = (source[8] >> 26) & 0x3ff;
    destination[55]  = (source[8] >> 16) & 0x3ff;
    destination[56]  = (source[8] >> 6) & 0x3ff;
    destination[57]  = (source[8] << 4) & 0x3ff;
    destination[57] |= (source[9] >> 60) & 0x3ff;
    destination[58]  = (source[9] >> 50) & 0x3ff;
    destination[59]  = (source[9] >> 40) & 0x3ff;
    destination[60]  = (source[9] >> 30) & 0x3ff;
    destination[61]  = (source[9] >> 20) & 0x3ff;
    destination[62]  = (source[9] >> 10) & 0x3ff;
    destination[63]  = (source[9] >> 0) & 0x3ff;
  }
};
template <typename Tp>
struct __struct_bitpack_impl<Tp,8,11>
{
  static const size_t unit_size = 64;
  static const size_t bits_total = 704;
  static const size_t loop_total = 64;
  static const size_t bit_size = 11;
  static const Tp     mask = 0x7ff;
  static inline
  void pack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] & 0x7ff) << 53;
    destination[0] |= (source[1] & 0x7ff) << 42;
    destination[0] |= (source[2] & 0x7ff) << 31;
    destination[0] |= (source[3] & 0x7ff) << 20;
    destination[0] |= (source[4] & 0x7ff) << 9;
    destination[0] |= (source[5] & 0x7ff) >> 2;
    destination[1]  = (source[5] & 0x7ff) << 62;
    destination[1] |= (source[6] & 0x7ff) << 51;
    destination[1] |= (source[7] & 0x7ff) << 40;
    destination[1] |= (source[8] & 0x7ff) << 29;
    destination[1] |= (source[9] & 0x7ff) << 18;
    destination[1] |= (source[10] & 0x7ff) << 7;
    destination[1] |= (source[11] & 0x7ff) >> 4;
    destination[2]  = (source[11] & 0x7ff) << 60;
    destination[2] |= (source[12] & 0x7ff) << 49;
    destination[2] |= (source[13] & 0x7ff) << 38;
    destination[2] |= (source[14] & 0x7ff) << 27;
    destination[2] |= (source[15] & 0x7ff) << 16;
    destination[2] |= (source[16] & 0x7ff) << 5;
    destination[2] |= (source[17] & 0x7ff) >> 6;
    destination[3]  = (source[17] & 0x7ff) << 58;
    destination[3] |= (source[18] & 0x7ff) << 47;
    destination[3] |= (source[19] & 0x7ff) << 36;
    destination[3] |= (source[20] & 0x7ff) << 25;
    destination[3] |= (source[21] & 0x7ff) << 14;
    destination[3] |= (source[22] & 0x7ff) << 3;
    destination[3] |= (source[23] & 0x7ff) >> 8;
    destination[4]  = (source[23] & 0x7ff) << 56;
    destination[4] |= (source[24] & 0x7ff) << 45;
    destination[4] |= (source[25] & 0x7ff) << 34;
    destination[4] |= (source[26] & 0x7ff) << 23;
    destination[4] |= (source[27] & 0x7ff) << 12;
    destination[4] |= (source[28] & 0x7ff) << 1;
    destination[4] |= (source[29] & 0x7ff) >> 10;
    destination[5]  = (source[29] & 0x7ff) << 54;
    destination[5] |= (source[30] & 0x7ff) << 43;
    destination[5] |= (source[31] & 0x7ff) << 32;
    destination[5] |= (source[32] & 0x7ff) << 21;
    destination[5] |= (source[33] & 0x7ff) << 10;
    destination[5] |= (source[34] & 0x7ff) >> 1;
    destination[6]  = (source[34] & 0x7ff) << 63;
    destination[6] |= (source[35] & 0x7ff) << 52;
    destination[6] |= (source[36] & 0x7ff) << 41;
    destination[6] |= (source[37] & 0x7ff) << 30;
    destination[6] |= (source[38] & 0x7ff) << 19;
    destination[6] |= (source[39] & 0x7ff) << 8;
    destination[6] |= (source[40] & 0x7ff) >> 3;
    destination[7]  = (source[40] & 0x7ff) << 61;
    destination[7] |= (source[41] & 0x7ff) << 50;
    destination[7] |= (source[42] & 0x7ff) << 39;
    destination[7] |= (source[43] & 0x7ff) << 28;
    destination[7] |= (source[44] & 0x7ff) << 17;
    destination[7] |= (source[45] & 0x7ff) << 6;
    destination[7] |= (source[46] & 0x7ff) >> 5;
    destination[8]  = (source[46] & 0x7ff) << 59;
    destination[8] |= (source[47] & 0x7ff) << 48;
    destination[8] |= (source[48] & 0x7ff) << 37;
    destination[8] |= (source[49] & 0x7ff) << 26;
    destination[8] |= (source[50] & 0x7ff) << 15;
    destination[8] |= (source[51] & 0x7ff) << 4;
    destination[8] |= (source[52] & 0x7ff) >> 7;
    destination[9]  = (source[52] & 0x7ff) << 57;
    destination[9] |= (source[53] & 0x7ff) << 46;
    destination[9] |= (source[54] & 0x7ff) << 35;
    destination[9] |= (source[55] & 0x7ff) << 24;
    destination[9] |= (source[56] & 0x7ff) << 13;
    destination[9] |= (source[57] & 0x7ff) << 2;
    destination[9] |= (source[58] & 0x7ff) >> 9;
    destination[10]  = (source[58] & 0x7ff) << 55;
    destination[10] |= (source[59] & 0x7ff) << 44;
    destination[10] |= (source[60] & 0x7ff) << 33;
    destination[10] |= (source[61] & 0x7ff) << 22;
    destination[10] |= (source[62] & 0x7ff) << 11;
    destination[10] |= (source[63] & 0x7ff) << 0;
  }
  static inline
  void unpack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] >> 53) & 0x7ff;
    destination[1]  = (source[0] >> 42) & 0x7ff;
    destination[2]  = (source[0] >> 31) & 0x7ff;
    destination[3]  = (source[0] >> 20) & 0x7ff;
    destination[4]  = (source[0] >> 9) & 0x7ff;
    destination[5]  = (source[0] << 2) & 0x7ff;
    destination[5] |= (source[1] >> 62) & 0x7ff;
    destination[6]  = (source[1] >> 51) & 0x7ff;
    destination[7]  = (source[1] >> 40) & 0x7ff;
    destination[8]  = (source[1] >> 29) & 0x7ff;
    destination[9]  = (source[1] >> 18) & 0x7ff;
    destination[10]  = (source[1] >> 7) & 0x7ff;
    destination[11]  = (source[1] << 4) & 0x7ff;
    destination[11] |= (source[2] >> 60) & 0x7ff;
    destination[12]  = (source[2] >> 49) & 0x7ff;
    destination[13]  = (source[2] >> 38) & 0x7ff;
    destination[14]  = (source[2] >> 27) & 0x7ff;
    destination[15]  = (source[2] >> 16) & 0x7ff;
    destination[16]  = (source[2] >> 5) & 0x7ff;
    destination[17]  = (source[2] << 6) & 0x7ff;
    destination[17] |= (source[3] >> 58) & 0x7ff;
    destination[18]  = (source[3] >> 47) & 0x7ff;
    destination[19]  = (source[3] >> 36) & 0x7ff;
    destination[20]  = (source[3] >> 25) & 0x7ff;
    destination[21]  = (source[3] >> 14) & 0x7ff;
    destination[22]  = (source[3] >> 3) & 0x7ff;
    destination[23]  = (source[3] << 8) & 0x7ff;
    destination[23] |= (source[4] >> 56) & 0x7ff;
    destination[24]  = (source[4] >> 45) & 0x7ff;
    destination[25]  = (source[4] >> 34) & 0x7ff;
    destination[26]  = (source[4] >> 23) & 0x7ff;
    destination[27]  = (source[4] >> 12) & 0x7ff;
    destination[28]  = (source[4] >> 1) & 0x7ff;
    destination[29]  = (source[4] << 10) & 0x7ff;
    destination[29] |= (source[5] >> 54) & 0x7ff;
    destination[30]  = (source[5] >> 43) & 0x7ff;
    destination[31]  = (source[5] >> 32) & 0x7ff;
    destination[32]  = (source[5] >> 21) & 0x7ff;
    destination[33]  = (source[5] >> 10) & 0x7ff;
    destination[34]  = (source[5] << 1) & 0x7ff;
    destination[34] |= (source[6] >> 63) & 0x7ff;
    destination[35]  = (source[6] >> 52) & 0x7ff;
    destination[36]  = (source[6] >> 41) & 0x7ff;
    destination[37]  = (source[6] >> 30) & 0x7ff;
    destination[38]  = (source[6] >> 19) & 0x7ff;
    destination[39]  = (source[6] >> 8) & 0x7ff;
    destination[40]  = (source[6] << 3) & 0x7ff;
    destination[40] |= (source[7] >> 61) & 0x7ff;
    destination[41]  = (source[7] >> 50) & 0x7ff;
    destination[42]  = (source[7] >> 39) & 0x7ff;
    destination[43]  = (source[7] >> 28) & 0x7ff;
    destination[44]  = (source[7] >> 17) & 0x7ff;
    destination[45]  = (source[7] >> 6) & 0x7ff;
    destination[46]  = (source[7] << 5) & 0x7ff;
    destination[46] |= (source[8] >> 59) & 0x7ff;
    destination[47]  = (source[8] >> 48) & 0x7ff;
    destination[48]  = (source[8] >> 37) & 0x7ff;
    destination[49]  = (source[8] >> 26) & 0x7ff;
    destination[50]  = (source[8] >> 15) & 0x7ff;
    destination[51]  = (source[8] >> 4) & 0x7ff;
    destination[52]  = (source[8] << 7) & 0x7ff;
    destination[52] |= (source[9] >> 57) & 0x7ff;
    destination[53]  = (source[9] >> 46) & 0x7ff;
    destination[54]  = (source[9] >> 35) & 0x7ff;
    destination[55]  = (source[9] >> 24) & 0x7ff;
    destination[56]  = (source[9] >> 13) & 0x7ff;
    destination[57]  = (source[9] >> 2) & 0x7ff;
    destination[58]  = (source[9] << 9) & 0x7ff;
    destination[58] |= (source[10] >> 55) & 0x7ff;
    destination[59]  = (source[10] >> 44) & 0x7ff;
    destination[60]  = (source[10] >> 33) & 0x7ff;
    destination[61]  = (source[10] >> 22) & 0x7ff;
    destination[62]  = (source[10] >> 11) & 0x7ff;
    destination[63]  = (source[10] >> 0) & 0x7ff;
  }
};
template <typename Tp>
struct __struct_bitpack_impl<Tp,8,12>
{
  static const size_t unit_size = 64;
  static const size_t bits_total = 768;
  static const size_t loop_total = 64;
  static const size_t bit_size = 12;
  static const Tp     mask = 0xfff;
  static inline
  void pack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] & 0xfff) << 52;
    destination[0] |= (source[1] & 0xfff) << 40;
    destination[0] |= (source[2] & 0xfff) << 28;
    destination[0] |= (source[3] & 0xfff) << 16;
    destination[0] |= (source[4] & 0xfff) << 4;
    destination[0] |= (source[5] & 0xfff) >> 8;
    destination[1]  = (source[5] & 0xfff) << 56;
    destination[1] |= (source[6] & 0xfff) << 44;
    destination[1] |= (source[7] & 0xfff) << 32;
    destination[1] |= (source[8] & 0xfff) << 20;
    destination[1] |= (source[9] & 0xfff) << 8;
    destination[1] |= (source[10] & 0xfff) >> 4;
    destination[2]  = (source[10] & 0xfff) << 60;
    destination[2] |= (source[11] & 0xfff) << 48;
    destination[2] |= (source[12] & 0xfff) << 36;
    destination[2] |= (source[13] & 0xfff) << 24;
    destination[2] |= (source[14] & 0xfff) << 12;
    destination[2] |= (source[15] & 0xfff) << 0;
    destination[3]  = (source[16] & 0xfff) << 52;
    destination[3] |= (source[17] & 0xfff) << 40;
    destination[3] |= (source[18] & 0xfff) << 28;
    destination[3] |= (source[19] & 0xfff) << 16;
    destination[3] |= (source[20] & 0xfff) << 4;
    destination[3] |= (source[21] & 0xfff) >> 8;
    destination[4]  = (source[21] & 0xfff) << 56;
    destination[4] |= (source[22] & 0xfff) << 44;
    destination[4] |= (source[23] & 0xfff) << 32;
    destination[4] |= (source[24] & 0xfff) << 20;
    destination[4] |= (source[25] & 0xfff) << 8;
    destination[4] |= (source[26] & 0xfff) >> 4;
    destination[5]  = (source[26] & 0xfff) << 60;
    destination[5] |= (source[27] & 0xfff) << 48;
    destination[5] |= (source[28] & 0xfff) << 36;
    destination[5] |= (source[29] & 0xfff) << 24;
    destination[5] |= (source[30] & 0xfff) << 12;
    destination[5] |= (source[31] & 0xfff) << 0;
    destination[6]  = (source[32] & 0xfff) << 52;
    destination[6] |= (source[33] & 0xfff) << 40;
    destination[6] |= (source[34] & 0xfff) << 28;
    destination[6] |= (source[35] & 0xfff) << 16;
    destination[6] |= (source[36] & 0xfff) << 4;
    destination[6] |= (source[37] & 0xfff) >> 8;
    destination[7]  = (source[37] & 0xfff) << 56;
    destination[7] |= (source[38] & 0xfff) << 44;
    destination[7] |= (source[39] & 0xfff) << 32;
    destination[7] |= (source[40] & 0xfff) << 20;
    destination[7] |= (source[41] & 0xfff) << 8;
    destination[7] |= (source[42] & 0xfff) >> 4;
    destination[8]  = (source[42] & 0xfff) << 60;
    destination[8] |= (source[43] & 0xfff) << 48;
    destination[8] |= (source[44] & 0xfff) << 36;
    destination[8] |= (source[45] & 0xfff) << 24;
    destination[8] |= (source[46] & 0xfff) << 12;
    destination[8] |= (source[47] & 0xfff) << 0;
    destination[9]  = (source[48] & 0xfff) << 52;
    destination[9] |= (source[49] & 0xfff) << 40;
    destination[9] |= (source[50] & 0xfff) << 28;
    destination[9] |= (source[51] & 0xfff) << 16;
    destination[9] |= (source[52] & 0xfff) << 4;
    destination[9] |= (source[53] & 0xfff) >> 8;
    destination[10]  = (source[53] & 0xfff) << 56;
    destination[10] |= (source[54] & 0xfff) << 44;
    destination[10] |= (source[55] & 0xfff) << 32;
    destination[10] |= (source[56] & 0xfff) << 20;
    destination[10] |= (source[57] & 0xfff) << 8;
    destination[10] |= (source[58] & 0xfff) >> 4;
    destination[11]  = (source[58] & 0xfff) << 60;
    destination[11] |= (source[59] & 0xfff) << 48;
    destination[11] |= (source[60] & 0xfff) << 36;
    destination[11] |= (source[61] & 0xfff) << 24;
    destination[11] |= (source[62] & 0xfff) << 12;
    destination[11] |= (source[63] & 0xfff) << 0;
  }
  static inline
  void unpack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] >> 52) & 0xfff;
    destination[1]  = (source[0] >> 40) & 0xfff;
    destination[2]  = (source[0] >> 28) & 0xfff;
    destination[3]  = (source[0] >> 16) & 0xfff;
    destination[4]  = (source[0] >> 4) & 0xfff;
    destination[5]  = (source[0] << 8) & 0xfff;
    destination[5] |= (source[1] >> 56) & 0xfff;
    destination[6]  = (source[1] >> 44) & 0xfff;
    destination[7]  = (source[1] >> 32) & 0xfff;
    destination[8]  = (source[1] >> 20) & 0xfff;
    destination[9]  = (source[1] >> 8) & 0xfff;
    destination[10]  = (source[1] << 4) & 0xfff;
    destination[10] |= (source[2] >> 60) & 0xfff;
    destination[11]  = (source[2] >> 48) & 0xfff;
    destination[12]  = (source[2] >> 36) & 0xfff;
    destination[13]  = (source[2] >> 24) & 0xfff;
    destination[14]  = (source[2] >> 12) & 0xfff;
    destination[15]  = (source[2] >> 0) & 0xfff;
    destination[16]  = (source[3] >> 52) & 0xfff;
    destination[17]  = (source[3] >> 40) & 0xfff;
    destination[18]  = (source[3] >> 28) & 0xfff;
    destination[19]  = (source[3] >> 16) & 0xfff;
    destination[20]  = (source[3] >> 4) & 0xfff;
    destination[21]  = (source[3] << 8) & 0xfff;
    destination[21] |= (source[4] >> 56) & 0xfff;
    destination[22]  = (source[4] >> 44) & 0xfff;
    destination[23]  = (source[4] >> 32) & 0xfff;
    destination[24]  = (source[4] >> 20) & 0xfff;
    destination[25]  = (source[4] >> 8) & 0xfff;
    destination[26]  = (source[4] << 4) & 0xfff;
    destination[26] |= (source[5] >> 60) & 0xfff;
    destination[27]  = (source[5] >> 48) & 0xfff;
    destination[28]  = (source[5] >> 36) & 0xfff;
    destination[29]  = (source[5] >> 24) & 0xfff;
    destination[30]  = (source[5] >> 12) & 0xfff;
    destination[31]  = (source[5] >> 0) & 0xfff;
    destination[32]  = (source[6] >> 52) & 0xfff;
    destination[33]  = (source[6] >> 40) & 0xfff;
    destination[34]  = (source[6] >> 28) & 0xfff;
    destination[35]  = (source[6] >> 16) & 0xfff;
    destination[36]  = (source[6] >> 4) & 0xfff;
    destination[37]  = (source[6] << 8) & 0xfff;
    destination[37] |= (source[7] >> 56) & 0xfff;
    destination[38]  = (source[7] >> 44) & 0xfff;
    destination[39]  = (source[7] >> 32) & 0xfff;
    destination[40]  = (source[7] >> 20) & 0xfff;
    destination[41]  = (source[7] >> 8) & 0xfff;
    destination[42]  = (source[7] << 4) & 0xfff;
    destination[42] |= (source[8] >> 60) & 0xfff;
    destination[43]  = (source[8] >> 48) & 0xfff;
    destination[44]  = (source[8] >> 36) & 0xfff;
    destination[45]  = (source[8] >> 24) & 0xfff;
    destination[46]  = (source[8] >> 12) & 0xfff;
    destination[47]  = (source[8] >> 0) & 0xfff;
    destination[48]  = (source[9] >> 52) & 0xfff;
    destination[49]  = (source[9] >> 40) & 0xfff;
    destination[50]  = (source[9] >> 28) & 0xfff;
    destination[51]  = (source[9] >> 16) & 0xfff;
    destination[52]  = (source[9] >> 4) & 0xfff;
    destination[53]  = (source[9] << 8) & 0xfff;
    destination[53] |= (source[10] >> 56) & 0xfff;
    destination[54]  = (source[10] >> 44) & 0xfff;
    destination[55]  = (source[10] >> 32) & 0xfff;
    destination[56]  = (source[10] >> 20) & 0xfff;
    destination[57]  = (source[10] >> 8) & 0xfff;
    destination[58]  = (source[10] << 4) & 0xfff;
    destination[58] |= (source[11] >> 60) & 0xfff;
    destination[59]  = (source[11] >> 48) & 0xfff;
    destination[60]  = (source[11] >> 36) & 0xfff;
    destination[61]  = (source[11] >> 24) & 0xfff;
    destination[62]  = (source[11] >> 12) & 0xfff;
    destination[63]  = (source[11] >> 0) & 0xfff;
  }
};
template <typename Tp>
struct __struct_bitpack_impl<Tp,8,13>
{
  static const size_t unit_size = 64;
  static const size_t bits_total = 832;
  static const size_t loop_total = 64;
  static const size_t bit_size = 13;
  static const Tp     mask = 0x1fff;
  static inline
  void pack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] & 0x1fff) << 51;
    destination[0] |= (source[1] & 0x1fff) << 38;
    destination[0] |= (source[2] & 0x1fff) << 25;
    destination[0] |= (source[3] & 0x1fff) << 12;
    destination[0] |= (source[4] & 0x1fff) >> 1;
    destination[1]  = (source[4] & 0x1fff) << 63;
    destination[1] |= (source[5] & 0x1fff) << 50;
    destination[1] |= (source[6] & 0x1fff) << 37;
    destination[1] |= (source[7] & 0x1fff) << 24;
    destination[1] |= (source[8] & 0x1fff) << 11;
    destination[1] |= (source[9] & 0x1fff) >> 2;
    destination[2]  = (source[9] & 0x1fff) << 62;
    destination[2] |= (source[10] & 0x1fff) << 49;
    destination[2] |= (source[11] & 0x1fff) << 36;
    destination[2] |= (source[12] & 0x1fff) << 23;
    destination[2] |= (source[13] & 0x1fff) << 10;
    destination[2] |= (source[14] & 0x1fff) >> 3;
    destination[3]  = (source[14] & 0x1fff) << 61;
    destination[3] |= (source[15] & 0x1fff) << 48;
    destination[3] |= (source[16] & 0x1fff) << 35;
    destination[3] |= (source[17] & 0x1fff) << 22;
    destination[3] |= (source[18] & 0x1fff) << 9;
    destination[3] |= (source[19] & 0x1fff) >> 4;
    destination[4]  = (source[19] & 0x1fff) << 60;
    destination[4] |= (source[20] & 0x1fff) << 47;
    destination[4] |= (source[21] & 0x1fff) << 34;
    destination[4] |= (source[22] & 0x1fff) << 21;
    destination[4] |= (source[23] & 0x1fff) << 8;
    destination[4] |= (source[24] & 0x1fff) >> 5;
    destination[5]  = (source[24] & 0x1fff) << 59;
    destination[5] |= (source[25] & 0x1fff) << 46;
    destination[5] |= (source[26] & 0x1fff) << 33;
    destination[5] |= (source[27] & 0x1fff) << 20;
    destination[5] |= (source[28] & 0x1fff) << 7;
    destination[5] |= (source[29] & 0x1fff) >> 6;
    destination[6]  = (source[29] & 0x1fff) << 58;
    destination[6] |= (source[30] & 0x1fff) << 45;
    destination[6] |= (source[31] & 0x1fff) << 32;
    destination[6] |= (source[32] & 0x1fff) << 19;
    destination[6] |= (source[33] & 0x1fff) << 6;
    destination[6] |= (source[34] & 0x1fff) >> 7;
    destination[7]  = (source[34] & 0x1fff) << 57;
    destination[7] |= (source[35] & 0x1fff) << 44;
    destination[7] |= (source[36] & 0x1fff) << 31;
    destination[7] |= (source[37] & 0x1fff) << 18;
    destination[7] |= (source[38] & 0x1fff) << 5;
    destination[7] |= (source[39] & 0x1fff) >> 8;
    destination[8]  = (source[39] & 0x1fff) << 56;
    destination[8] |= (source[40] & 0x1fff) << 43;
    destination[8] |= (source[41] & 0x1fff) << 30;
    destination[8] |= (source[42] & 0x1fff) << 17;
    destination[8] |= (source[43] & 0x1fff) << 4;
    destination[8] |= (source[44] & 0x1fff) >> 9;
    destination[9]  = (source[44] & 0x1fff) << 55;
    destination[9] |= (source[45] & 0x1fff) << 42;
    destination[9] |= (source[46] & 0x1fff) << 29;
    destination[9] |= (source[47] & 0x1fff) << 16;
    destination[9] |= (source[48] & 0x1fff) << 3;
    destination[9] |= (source[49] & 0x1fff) >> 10;
    destination[10]  = (source[49] & 0x1fff) << 54;
    destination[10] |= (source[50] & 0x1fff) << 41;
    destination[10] |= (source[51] & 0x1fff) << 28;
    destination[10] |= (source[52] & 0x1fff) << 15;
    destination[10] |= (source[53] & 0x1fff) << 2;
    destination[10] |= (source[54] & 0x1fff) >> 11;
    destination[11]  = (source[54] & 0x1fff) << 53;
    destination[11] |= (source[55] & 0x1fff) << 40;
    destination[11] |= (source[56] & 0x1fff) << 27;
    destination[11] |= (source[57] & 0x1fff) << 14;
    destination[11] |= (source[58] & 0x1fff) << 1;
    destination[11] |= (source[59] & 0x1fff) >> 12;
    destination[12]  = (source[59] & 0x1fff) << 52;
    destination[12] |= (source[60] & 0x1fff) << 39;
    destination[12] |= (source[61] & 0x1fff) << 26;
    destination[12] |= (source[62] & 0x1fff) << 13;
    destination[12] |= (source[63] & 0x1fff) << 0;
  }
  static inline
  void unpack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] >> 51) & 0x1fff;
    destination[1]  = (source[0] >> 38) & 0x1fff;
    destination[2]  = (source[0] >> 25) & 0x1fff;
    destination[3]  = (source[0] >> 12) & 0x1fff;
    destination[4]  = (source[0] << 1) & 0x1fff;
    destination[4] |= (source[1] >> 63) & 0x1fff;
    destination[5]  = (source[1] >> 50) & 0x1fff;
    destination[6]  = (source[1] >> 37) & 0x1fff;
    destination[7]  = (source[1] >> 24) & 0x1fff;
    destination[8]  = (source[1] >> 11) & 0x1fff;
    destination[9]  = (source[1] << 2) & 0x1fff;
    destination[9] |= (source[2] >> 62) & 0x1fff;
    destination[10]  = (source[2] >> 49) & 0x1fff;
    destination[11]  = (source[2] >> 36) & 0x1fff;
    destination[12]  = (source[2] >> 23) & 0x1fff;
    destination[13]  = (source[2] >> 10) & 0x1fff;
    destination[14]  = (source[2] << 3) & 0x1fff;
    destination[14] |= (source[3] >> 61) & 0x1fff;
    destination[15]  = (source[3] >> 48) & 0x1fff;
    destination[16]  = (source[3] >> 35) & 0x1fff;
    destination[17]  = (source[3] >> 22) & 0x1fff;
    destination[18]  = (source[3] >> 9) & 0x1fff;
    destination[19]  = (source[3] << 4) & 0x1fff;
    destination[19] |= (source[4] >> 60) & 0x1fff;
    destination[20]  = (source[4] >> 47) & 0x1fff;
    destination[21]  = (source[4] >> 34) & 0x1fff;
    destination[22]  = (source[4] >> 21) & 0x1fff;
    destination[23]  = (source[4] >> 8) & 0x1fff;
    destination[24]  = (source[4] << 5) & 0x1fff;
    destination[24] |= (source[5] >> 59) & 0x1fff;
    destination[25]  = (source[5] >> 46) & 0x1fff;
    destination[26]  = (source[5] >> 33) & 0x1fff;
    destination[27]  = (source[5] >> 20) & 0x1fff;
    destination[28]  = (source[5] >> 7) & 0x1fff;
    destination[29]  = (source[5] << 6) & 0x1fff;
    destination[29] |= (source[6] >> 58) & 0x1fff;
    destination[30]  = (source[6] >> 45) & 0x1fff;
    destination[31]  = (source[6] >> 32) & 0x1fff;
    destination[32]  = (source[6] >> 19) & 0x1fff;
    destination[33]  = (source[6] >> 6) & 0x1fff;
    destination[34]  = (source[6] << 7) & 0x1fff;
    destination[34] |= (source[7] >> 57) & 0x1fff;
    destination[35]  = (source[7] >> 44) & 0x1fff;
    destination[36]  = (source[7] >> 31) & 0x1fff;
    destination[37]  = (source[7] >> 18) & 0x1fff;
    destination[38]  = (source[7] >> 5) & 0x1fff;
    destination[39]  = (source[7] << 8) & 0x1fff;
    destination[39] |= (source[8] >> 56) & 0x1fff;
    destination[40]  = (source[8] >> 43) & 0x1fff;
    destination[41]  = (source[8] >> 30) & 0x1fff;
    destination[42]  = (source[8] >> 17) & 0x1fff;
    destination[43]  = (source[8] >> 4) & 0x1fff;
    destination[44]  = (source[8] << 9) & 0x1fff;
    destination[44] |= (source[9] >> 55) & 0x1fff;
    destination[45]  = (source[9] >> 42) & 0x1fff;
    destination[46]  = (source[9] >> 29) & 0x1fff;
    destination[47]  = (source[9] >> 16) & 0x1fff;
    destination[48]  = (source[9] >> 3) & 0x1fff;
    destination[49]  = (source[9] << 10) & 0x1fff;
    destination[49] |= (source[10] >> 54) & 0x1fff;
    destination[50]  = (source[10] >> 41) & 0x1fff;
    destination[51]  = (source[10] >> 28) & 0x1fff;
    destination[52]  = (source[10] >> 15) & 0x1fff;
    destination[53]  = (source[10] >> 2) & 0x1fff;
    destination[54]  = (source[10] << 11) & 0x1fff;
    destination[54] |= (source[11] >> 53) & 0x1fff;
    destination[55]  = (source[11] >> 40) & 0x1fff;
    destination[56]  = (source[11] >> 27) & 0x1fff;
    destination[57]  = (source[11] >> 14) & 0x1fff;
    destination[58]  = (source[11] >> 1) & 0x1fff;
    destination[59]  = (source[11] << 12) & 0x1fff;
    destination[59] |= (source[12] >> 52) & 0x1fff;
    destination[60]  = (source[12] >> 39) & 0x1fff;
    destination[61]  = (source[12] >> 26) & 0x1fff;
    destination[62]  = (source[12] >> 13) & 0x1fff;
    destination[63]  = (source[12] >> 0) & 0x1fff;
  }
};
template <typename Tp>
struct __struct_bitpack_impl<Tp,8,14>
{
  static const size_t unit_size = 64;
  static const size_t bits_total = 896;
  static const size_t loop_total = 64;
  static const size_t bit_size = 14;
  static const Tp     mask = 0x3fff;
  static inline
  void pack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] & 0x3fff) << 50;
    destination[0] |= (source[1] & 0x3fff) << 36;
    destination[0] |= (source[2] & 0x3fff) << 22;
    destination[0] |= (source[3] & 0x3fff) << 8;
    destination[0] |= (source[4] & 0x3fff) >> 6;
    destination[1]  = (source[4] & 0x3fff) << 58;
    destination[1] |= (source[5] & 0x3fff) << 44;
    destination[1] |= (source[6] & 0x3fff) << 30;
    destination[1] |= (source[7] & 0x3fff) << 16;
    destination[1] |= (source[8] & 0x3fff) << 2;
    destination[1] |= (source[9] & 0x3fff) >> 12;
    destination[2]  = (source[9] & 0x3fff) << 52;
    destination[2] |= (source[10] & 0x3fff) << 38;
    destination[2] |= (source[11] & 0x3fff) << 24;
    destination[2] |= (source[12] & 0x3fff) << 10;
    destination[2] |= (source[13] & 0x3fff) >> 4;
    destination[3]  = (source[13] & 0x3fff) << 60;
    destination[3] |= (source[14] & 0x3fff) << 46;
    destination[3] |= (source[15] & 0x3fff) << 32;
    destination[3] |= (source[16] & 0x3fff) << 18;
    destination[3] |= (source[17] & 0x3fff) << 4;
    destination[3] |= (source[18] & 0x3fff) >> 10;
    destination[4]  = (source[18] & 0x3fff) << 54;
    destination[4] |= (source[19] & 0x3fff) << 40;
    destination[4] |= (source[20] & 0x3fff) << 26;
    destination[4] |= (source[21] & 0x3fff) << 12;
    destination[4] |= (source[22] & 0x3fff) >> 2;
    destination[5]  = (source[22] & 0x3fff) << 62;
    destination[5] |= (source[23] & 0x3fff) << 48;
    destination[5] |= (source[24] & 0x3fff) << 34;
    destination[5] |= (source[25] & 0x3fff) << 20;
    destination[5] |= (source[26] & 0x3fff) << 6;
    destination[5] |= (source[27] & 0x3fff) >> 8;
    destination[6]  = (source[27] & 0x3fff) << 56;
    destination[6] |= (source[28] & 0x3fff) << 42;
    destination[6] |= (source[29] & 0x3fff) << 28;
    destination[6] |= (source[30] & 0x3fff) << 14;
    destination[6] |= (source[31] & 0x3fff) << 0;
    destination[7]  = (source[32] & 0x3fff) << 50;
    destination[7] |= (source[33] & 0x3fff) << 36;
    destination[7] |= (source[34] & 0x3fff) << 22;
    destination[7] |= (source[35] & 0x3fff) << 8;
    destination[7] |= (source[36] & 0x3fff) >> 6;
    destination[8]  = (source[36] & 0x3fff) << 58;
    destination[8] |= (source[37] & 0x3fff) << 44;
    destination[8] |= (source[38] & 0x3fff) << 30;
    destination[8] |= (source[39] & 0x3fff) << 16;
    destination[8] |= (source[40] & 0x3fff) << 2;
    destination[8] |= (source[41] & 0x3fff) >> 12;
    destination[9]  = (source[41] & 0x3fff) << 52;
    destination[9] |= (source[42] & 0x3fff) << 38;
    destination[9] |= (source[43] & 0x3fff) << 24;
    destination[9] |= (source[44] & 0x3fff) << 10;
    destination[9] |= (source[45] & 0x3fff) >> 4;
    destination[10]  = (source[45] & 0x3fff) << 60;
    destination[10] |= (source[46] & 0x3fff) << 46;
    destination[10] |= (source[47] & 0x3fff) << 32;
    destination[10] |= (source[48] & 0x3fff) << 18;
    destination[10] |= (source[49] & 0x3fff) << 4;
    destination[10] |= (source[50] & 0x3fff) >> 10;
    destination[11]  = (source[50] & 0x3fff) << 54;
    destination[11] |= (source[51] & 0x3fff) << 40;
    destination[11] |= (source[52] & 0x3fff) << 26;
    destination[11] |= (source[53] & 0x3fff) << 12;
    destination[11] |= (source[54] & 0x3fff) >> 2;
    destination[12]  = (source[54] & 0x3fff) << 62;
    destination[12] |= (source[55] & 0x3fff) << 48;
    destination[12] |= (source[56] & 0x3fff) << 34;
    destination[12] |= (source[57] & 0x3fff) << 20;
    destination[12] |= (source[58] & 0x3fff) << 6;
    destination[12] |= (source[59] & 0x3fff) >> 8;
    destination[13]  = (source[59] & 0x3fff) << 56;
    destination[13] |= (source[60] & 0x3fff) << 42;
    destination[13] |= (source[61] & 0x3fff) << 28;
    destination[13] |= (source[62] & 0x3fff) << 14;
    destination[13] |= (source[63] & 0x3fff) << 0;
  }
  static inline
  void unpack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] >> 50) & 0x3fff;
    destination[1]  = (source[0] >> 36) & 0x3fff;
    destination[2]  = (source[0] >> 22) & 0x3fff;
    destination[3]  = (source[0] >> 8) & 0x3fff;
    destination[4]  = (source[0] << 6) & 0x3fff;
    destination[4] |= (source[1] >> 58) & 0x3fff;
    destination[5]  = (source[1] >> 44) & 0x3fff;
    destination[6]  = (source[1] >> 30) & 0x3fff;
    destination[7]  = (source[1] >> 16) & 0x3fff;
    destination[8]  = (source[1] >> 2) & 0x3fff;
    destination[9]  = (source[1] << 12) & 0x3fff;
    destination[9] |= (source[2] >> 52) & 0x3fff;
    destination[10]  = (source[2] >> 38) & 0x3fff;
    destination[11]  = (source[2] >> 24) & 0x3fff;
    destination[12]  = (source[2] >> 10) & 0x3fff;
    destination[13]  = (source[2] << 4) & 0x3fff;
    destination[13] |= (source[3] >> 60) & 0x3fff;
    destination[14]  = (source[3] >> 46) & 0x3fff;
    destination[15]  = (source[3] >> 32) & 0x3fff;
    destination[16]  = (source[3] >> 18) & 0x3fff;
    destination[17]  = (source[3] >> 4) & 0x3fff;
    destination[18]  = (source[3] << 10) & 0x3fff;
    destination[18] |= (source[4] >> 54) & 0x3fff;
    destination[19]  = (source[4] >> 40) & 0x3fff;
    destination[20]  = (source[4] >> 26) & 0x3fff;
    destination[21]  = (source[4] >> 12) & 0x3fff;
    destination[22]  = (source[4] << 2) & 0x3fff;
    destination[22] |= (source[5] >> 62) & 0x3fff;
    destination[23]  = (source[5] >> 48) & 0x3fff;
    destination[24]  = (source[5] >> 34) & 0x3fff;
    destination[25]  = (source[5] >> 20) & 0x3fff;
    destination[26]  = (source[5] >> 6) & 0x3fff;
    destination[27]  = (source[5] << 8) & 0x3fff;
    destination[27] |= (source[6] >> 56) & 0x3fff;
    destination[28]  = (source[6] >> 42) & 0x3fff;
    destination[29]  = (source[6] >> 28) & 0x3fff;
    destination[30]  = (source[6] >> 14) & 0x3fff;
    destination[31]  = (source[6] >> 0) & 0x3fff;
    destination[32]  = (source[7] >> 50) & 0x3fff;
    destination[33]  = (source[7] >> 36) & 0x3fff;
    destination[34]  = (source[7] >> 22) & 0x3fff;
    destination[35]  = (source[7] >> 8) & 0x3fff;
    destination[36]  = (source[7] << 6) & 0x3fff;
    destination[36] |= (source[8] >> 58) & 0x3fff;
    destination[37]  = (source[8] >> 44) & 0x3fff;
    destination[38]  = (source[8] >> 30) & 0x3fff;
    destination[39]  = (source[8] >> 16) & 0x3fff;
    destination[40]  = (source[8] >> 2) & 0x3fff;
    destination[41]  = (source[8] << 12) & 0x3fff;
    destination[41] |= (source[9] >> 52) & 0x3fff;
    destination[42]  = (source[9] >> 38) & 0x3fff;
    destination[43]  = (source[9] >> 24) & 0x3fff;
    destination[44]  = (source[9] >> 10) & 0x3fff;
    destination[45]  = (source[9] << 4) & 0x3fff;
    destination[45] |= (source[10] >> 60) & 0x3fff;
    destination[46]  = (source[10] >> 46) & 0x3fff;
    destination[47]  = (source[10] >> 32) & 0x3fff;
    destination[48]  = (source[10] >> 18) & 0x3fff;
    destination[49]  = (source[10] >> 4) & 0x3fff;
    destination[50]  = (source[10] << 10) & 0x3fff;
    destination[50] |= (source[11] >> 54) & 0x3fff;
    destination[51]  = (source[11] >> 40) & 0x3fff;
    destination[52]  = (source[11] >> 26) & 0x3fff;
    destination[53]  = (source[11] >> 12) & 0x3fff;
    destination[54]  = (source[11] << 2) & 0x3fff;
    destination[54] |= (source[12] >> 62) & 0x3fff;
    destination[55]  = (source[12] >> 48) & 0x3fff;
    destination[56]  = (source[12] >> 34) & 0x3fff;
    destination[57]  = (source[12] >> 20) & 0x3fff;
    destination[58]  = (source[12] >> 6) & 0x3fff;
    destination[59]  = (source[12] << 8) & 0x3fff;
    destination[59] |= (source[13] >> 56) & 0x3fff;
    destination[60]  = (source[13] >> 42) & 0x3fff;
    destination[61]  = (source[13] >> 28) & 0x3fff;
    destination[62]  = (source[13] >> 14) & 0x3fff;
    destination[63]  = (source[13] >> 0) & 0x3fff;
  }
};
template <typename Tp>
struct __struct_bitpack_impl<Tp,8,15>
{
  static const size_t unit_size = 64;
  static const size_t bits_total = 960;
  static const size_t loop_total = 64;
  static const size_t bit_size = 15;
  static const Tp     mask = 0x7fff;
  static inline
  void pack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] & 0x7fff) << 49;
    destination[0] |= (source[1] & 0x7fff) << 34;
    destination[0] |= (source[2] & 0x7fff) << 19;
    destination[0] |= (source[3] & 0x7fff) << 4;
    destination[0] |= (source[4] & 0x7fff) >> 11;
    destination[1]  = (source[4] & 0x7fff) << 53;
    destination[1] |= (source[5] & 0x7fff) << 38;
    destination[1] |= (source[6] & 0x7fff) << 23;
    destination[1] |= (source[7] & 0x7fff) << 8;
    destination[1] |= (source[8] & 0x7fff) >> 7;
    destination[2]  = (source[8] & 0x7fff) << 57;
    destination[2] |= (source[9] & 0x7fff) << 42;
    destination[2] |= (source[10] & 0x7fff) << 27;
    destination[2] |= (source[11] & 0x7fff) << 12;
    destination[2] |= (source[12] & 0x7fff) >> 3;
    destination[3]  = (source[12] & 0x7fff) << 61;
    destination[3] |= (source[13] & 0x7fff) << 46;
    destination[3] |= (source[14] & 0x7fff) << 31;
    destination[3] |= (source[15] & 0x7fff) << 16;
    destination[3] |= (source[16] & 0x7fff) << 1;
    destination[3] |= (source[17] & 0x7fff) >> 14;
    destination[4]  = (source[17] & 0x7fff) << 50;
    destination[4] |= (source[18] & 0x7fff) << 35;
    destination[4] |= (source[19] & 0x7fff) << 20;
    destination[4] |= (source[20] & 0x7fff) << 5;
    destination[4] |= (source[21] & 0x7fff) >> 10;
    destination[5]  = (source[21] & 0x7fff) << 54;
    destination[5] |= (source[22] & 0x7fff) << 39;
    destination[5] |= (source[23] & 0x7fff) << 24;
    destination[5] |= (source[24] & 0x7fff) << 9;
    destination[5] |= (source[25] & 0x7fff) >> 6;
    destination[6]  = (source[25] & 0x7fff) << 58;
    destination[6] |= (source[26] & 0x7fff) << 43;
    destination[6] |= (source[27] & 0x7fff) << 28;
    destination[6] |= (source[28] & 0x7fff) << 13;
    destination[6] |= (source[29] & 0x7fff) >> 2;
    destination[7]  = (source[29] & 0x7fff) << 62;
    destination[7] |= (source[30] & 0x7fff) << 47;
    destination[7] |= (source[31] & 0x7fff) << 32;
    destination[7] |= (source[32] & 0x7fff) << 17;
    destination[7] |= (source[33] & 0x7fff) << 2;
    destination[7] |= (source[34] & 0x7fff) >> 13;
    destination[8]  = (source[34] & 0x7fff) << 51;
    destination[8] |= (source[35] & 0x7fff) << 36;
    destination[8] |= (source[36] & 0x7fff) << 21;
    destination[8] |= (source[37] & 0x7fff) << 6;
    destination[8] |= (source[38] & 0x7fff) >> 9;
    destination[9]  = (source[38] & 0x7fff) << 55;
    destination[9] |= (source[39] & 0x7fff) << 40;
    destination[9] |= (source[40] & 0x7fff) << 25;
    destination[9] |= (source[41] & 0x7fff) << 10;
    destination[9] |= (source[42] & 0x7fff) >> 5;
    destination[10]  = (source[42] & 0x7fff) << 59;
    destination[10] |= (source[43] & 0x7fff) << 44;
    destination[10] |= (source[44] & 0x7fff) << 29;
    destination[10] |= (source[45] & 0x7fff) << 14;
    destination[10] |= (source[46] & 0x7fff) >> 1;
    destination[11]  = (source[46] & 0x7fff) << 63;
    destination[11] |= (source[47] & 0x7fff) << 48;
    destination[11] |= (source[48] & 0x7fff) << 33;
    destination[11] |= (source[49] & 0x7fff) << 18;
    destination[11] |= (source[50] & 0x7fff) << 3;
    destination[11] |= (source[51] & 0x7fff) >> 12;
    destination[12]  = (source[51] & 0x7fff) << 52;
    destination[12] |= (source[52] & 0x7fff) << 37;
    destination[12] |= (source[53] & 0x7fff) << 22;
    destination[12] |= (source[54] & 0x7fff) << 7;
    destination[12] |= (source[55] & 0x7fff) >> 8;
    destination[13]  = (source[55] & 0x7fff) << 56;
    destination[13] |= (source[56] & 0x7fff) << 41;
    destination[13] |= (source[57] & 0x7fff) << 26;
    destination[13] |= (source[58] & 0x7fff) << 11;
    destination[13] |= (source[59] & 0x7fff) >> 4;
    destination[14]  = (source[59] & 0x7fff) << 60;
    destination[14] |= (source[60] & 0x7fff) << 45;
    destination[14] |= (source[61] & 0x7fff) << 30;
    destination[14] |= (source[62] & 0x7fff) << 15;
    destination[14] |= (source[63] & 0x7fff) << 0;
  }
  static inline
  void unpack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] >> 49) & 0x7fff;
    destination[1]  = (source[0] >> 34) & 0x7fff;
    destination[2]  = (source[0] >> 19) & 0x7fff;
    destination[3]  = (source[0] >> 4) & 0x7fff;
    destination[4]  = (source[0] << 11) & 0x7fff;
    destination[4] |= (source[1] >> 53) & 0x7fff;
    destination[5]  = (source[1] >> 38) & 0x7fff;
    destination[6]  = (source[1] >> 23) & 0x7fff;
    destination[7]  = (source[1] >> 8) & 0x7fff;
    destination[8]  = (source[1] << 7) & 0x7fff;
    destination[8] |= (source[2] >> 57) & 0x7fff;
    destination[9]  = (source[2] >> 42) & 0x7fff;
    destination[10]  = (source[2] >> 27) & 0x7fff;
    destination[11]  = (source[2] >> 12) & 0x7fff;
    destination[12]  = (source[2] << 3) & 0x7fff;
    destination[12] |= (source[3] >> 61) & 0x7fff;
    destination[13]  = (source[3] >> 46) & 0x7fff;
    destination[14]  = (source[3] >> 31) & 0x7fff;
    destination[15]  = (source[3] >> 16) & 0x7fff;
    destination[16]  = (source[3] >> 1) & 0x7fff;
    destination[17]  = (source[3] << 14) & 0x7fff;
    destination[17] |= (source[4] >> 50) & 0x7fff;
    destination[18]  = (source[4] >> 35) & 0x7fff;
    destination[19]  = (source[4] >> 20) & 0x7fff;
    destination[20]  = (source[4] >> 5) & 0x7fff;
    destination[21]  = (source[4] << 10) & 0x7fff;
    destination[21] |= (source[5] >> 54) & 0x7fff;
    destination[22]  = (source[5] >> 39) & 0x7fff;
    destination[23]  = (source[5] >> 24) & 0x7fff;
    destination[24]  = (source[5] >> 9) & 0x7fff;
    destination[25]  = (source[5] << 6) & 0x7fff;
    destination[25] |= (source[6] >> 58) & 0x7fff;
    destination[26]  = (source[6] >> 43) & 0x7fff;
    destination[27]  = (source[6] >> 28) & 0x7fff;
    destination[28]  = (source[6] >> 13) & 0x7fff;
    destination[29]  = (source[6] << 2) & 0x7fff;
    destination[29] |= (source[7] >> 62) & 0x7fff;
    destination[30]  = (source[7] >> 47) & 0x7fff;
    destination[31]  = (source[7] >> 32) & 0x7fff;
    destination[32]  = (source[7] >> 17) & 0x7fff;
    destination[33]  = (source[7] >> 2) & 0x7fff;
    destination[34]  = (source[7] << 13) & 0x7fff;
    destination[34] |= (source[8] >> 51) & 0x7fff;
    destination[35]  = (source[8] >> 36) & 0x7fff;
    destination[36]  = (source[8] >> 21) & 0x7fff;
    destination[37]  = (source[8] >> 6) & 0x7fff;
    destination[38]  = (source[8] << 9) & 0x7fff;
    destination[38] |= (source[9] >> 55) & 0x7fff;
    destination[39]  = (source[9] >> 40) & 0x7fff;
    destination[40]  = (source[9] >> 25) & 0x7fff;
    destination[41]  = (source[9] >> 10) & 0x7fff;
    destination[42]  = (source[9] << 5) & 0x7fff;
    destination[42] |= (source[10] >> 59) & 0x7fff;
    destination[43]  = (source[10] >> 44) & 0x7fff;
    destination[44]  = (source[10] >> 29) & 0x7fff;
    destination[45]  = (source[10] >> 14) & 0x7fff;
    destination[46]  = (source[10] << 1) & 0x7fff;
    destination[46] |= (source[11] >> 63) & 0x7fff;
    destination[47]  = (source[11] >> 48) & 0x7fff;
    destination[48]  = (source[11] >> 33) & 0x7fff;
    destination[49]  = (source[11] >> 18) & 0x7fff;
    destination[50]  = (source[11] >> 3) & 0x7fff;
    destination[51]  = (source[11] << 12) & 0x7fff;
    destination[51] |= (source[12] >> 52) & 0x7fff;
    destination[52]  = (source[12] >> 37) & 0x7fff;
    destination[53]  = (source[12] >> 22) & 0x7fff;
    destination[54]  = (source[12] >> 7) & 0x7fff;
    destination[55]  = (source[12] << 8) & 0x7fff;
    destination[55] |= (source[13] >> 56) & 0x7fff;
    destination[56]  = (source[13] >> 41) & 0x7fff;
    destination[57]  = (source[13] >> 26) & 0x7fff;
    destination[58]  = (source[13] >> 11) & 0x7fff;
    destination[59]  = (source[13] << 4) & 0x7fff;
    destination[59] |= (source[14] >> 60) & 0x7fff;
    destination[60]  = (source[14] >> 45) & 0x7fff;
    destination[61]  = (source[14] >> 30) & 0x7fff;
    destination[62]  = (source[14] >> 15) & 0x7fff;
    destination[63]  = (source[14] >> 0) & 0x7fff;
  }
};
template <typename Tp>
struct __struct_bitpack_impl<Tp,8,16>
{
  static const size_t unit_size = 64;
  static const size_t bits_total = 1024;
  static const size_t loop_total = 64;
  static const size_t bit_size = 16;
  static const Tp     mask = 0xffff;
  static inline
  void pack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] & 0xffff) << 48;
    destination[0] |= (source[1] & 0xffff) << 32;
    destination[0] |= (source[2] & 0xffff) << 16;
    destination[0] |= (source[3] & 0xffff) << 0;
    destination[1]  = (source[4] & 0xffff) << 48;
    destination[1] |= (source[5] & 0xffff) << 32;
    destination[1] |= (source[6] & 0xffff) << 16;
    destination[1] |= (source[7] & 0xffff) << 0;
    destination[2]  = (source[8] & 0xffff) << 48;
    destination[2] |= (source[9] & 0xffff) << 32;
    destination[2] |= (source[10] & 0xffff) << 16;
    destination[2] |= (source[11] & 0xffff) << 0;
    destination[3]  = (source[12] & 0xffff) << 48;
    destination[3] |= (source[13] & 0xffff) << 32;
    destination[3] |= (source[14] & 0xffff) << 16;
    destination[3] |= (source[15] & 0xffff) << 0;
    destination[4]  = (source[16] & 0xffff) << 48;
    destination[4] |= (source[17] & 0xffff) << 32;
    destination[4] |= (source[18] & 0xffff) << 16;
    destination[4] |= (source[19] & 0xffff) << 0;
    destination[5]  = (source[20] & 0xffff) << 48;
    destination[5] |= (source[21] & 0xffff) << 32;
    destination[5] |= (source[22] & 0xffff) << 16;
    destination[5] |= (source[23] & 0xffff) << 0;
    destination[6]  = (source[24] & 0xffff) << 48;
    destination[6] |= (source[25] & 0xffff) << 32;
    destination[6] |= (source[26] & 0xffff) << 16;
    destination[6] |= (source[27] & 0xffff) << 0;
    destination[7]  = (source[28] & 0xffff) << 48;
    destination[7] |= (source[29] & 0xffff) << 32;
    destination[7] |= (source[30] & 0xffff) << 16;
    destination[7] |= (source[31] & 0xffff) << 0;
    destination[8]  = (source[32] & 0xffff) << 48;
    destination[8] |= (source[33] & 0xffff) << 32;
    destination[8] |= (source[34] & 0xffff) << 16;
    destination[8] |= (source[35] & 0xffff) << 0;
    destination[9]  = (source[36] & 0xffff) << 48;
    destination[9] |= (source[37] & 0xffff) << 32;
    destination[9] |= (source[38] & 0xffff) << 16;
    destination[9] |= (source[39] & 0xffff) << 0;
    destination[10]  = (source[40] & 0xffff) << 48;
    destination[10] |= (source[41] & 0xffff) << 32;
    destination[10] |= (source[42] & 0xffff) << 16;
    destination[10] |= (source[43] & 0xffff) << 0;
    destination[11]  = (source[44] & 0xffff) << 48;
    destination[11] |= (source[45] & 0xffff) << 32;
    destination[11] |= (source[46] & 0xffff) << 16;
    destination[11] |= (source[47] & 0xffff) << 0;
    destination[12]  = (source[48] & 0xffff) << 48;
    destination[12] |= (source[49] & 0xffff) << 32;
    destination[12] |= (source[50] & 0xffff) << 16;
    destination[12] |= (source[51] & 0xffff) << 0;
    destination[13]  = (source[52] & 0xffff) << 48;
    destination[13] |= (source[53] & 0xffff) << 32;
    destination[13] |= (source[54] & 0xffff) << 16;
    destination[13] |= (source[55] & 0xffff) << 0;
    destination[14]  = (source[56] & 0xffff) << 48;
    destination[14] |= (source[57] & 0xffff) << 32;
    destination[14] |= (source[58] & 0xffff) << 16;
    destination[14] |= (source[59] & 0xffff) << 0;
    destination[15]  = (source[60] & 0xffff) << 48;
    destination[15] |= (source[61] & 0xffff) << 32;
    destination[15] |= (source[62] & 0xffff) << 16;
    destination[15] |= (source[63] & 0xffff) << 0;
  }
  static inline
  void unpack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] >> 48) & 0xffff;
    destination[1]  = (source[0] >> 32) & 0xffff;
    destination[2]  = (source[0] >> 16) & 0xffff;
    destination[3]  = (source[0] >> 0) & 0xffff;
    destination[4]  = (source[1] >> 48) & 0xffff;
    destination[5]  = (source[1] >> 32) & 0xffff;
    destination[6]  = (source[1] >> 16) & 0xffff;
    destination[7]  = (source[1] >> 0) & 0xffff;
    destination[8]  = (source[2] >> 48) & 0xffff;
    destination[9]  = (source[2] >> 32) & 0xffff;
    destination[10]  = (source[2] >> 16) & 0xffff;
    destination[11]  = (source[2] >> 0) & 0xffff;
    destination[12]  = (source[3] >> 48) & 0xffff;
    destination[13]  = (source[3] >> 32) & 0xffff;
    destination[14]  = (source[3] >> 16) & 0xffff;
    destination[15]  = (source[3] >> 0) & 0xffff;
    destination[16]  = (source[4] >> 48) & 0xffff;
    destination[17]  = (source[4] >> 32) & 0xffff;
    destination[18]  = (source[4] >> 16) & 0xffff;
    destination[19]  = (source[4] >> 0) & 0xffff;
    destination[20]  = (source[5] >> 48) & 0xffff;
    destination[21]  = (source[5] >> 32) & 0xffff;
    destination[22]  = (source[5] >> 16) & 0xffff;
    destination[23]  = (source[5] >> 0) & 0xffff;
    destination[24]  = (source[6] >> 48) & 0xffff;
    destination[25]  = (source[6] >> 32) & 0xffff;
    destination[26]  = (source[6] >> 16) & 0xffff;
    destination[27]  = (source[6] >> 0) & 0xffff;
    destination[28]  = (source[7] >> 48) & 0xffff;
    destination[29]  = (source[7] >> 32) & 0xffff;
    destination[30]  = (source[7] >> 16) & 0xffff;
    destination[31]  = (source[7] >> 0) & 0xffff;
    destination[32]  = (source[8] >> 48) & 0xffff;
    destination[33]  = (source[8] >> 32) & 0xffff;
    destination[34]  = (source[8] >> 16) & 0xffff;
    destination[35]  = (source[8] >> 0) & 0xffff;
    destination[36]  = (source[9] >> 48) & 0xffff;
    destination[37]  = (source[9] >> 32) & 0xffff;
    destination[38]  = (source[9] >> 16) & 0xffff;
    destination[39]  = (source[9] >> 0) & 0xffff;
    destination[40]  = (source[10] >> 48) & 0xffff;
    destination[41]  = (source[10] >> 32) & 0xffff;
    destination[42]  = (source[10] >> 16) & 0xffff;
    destination[43]  = (source[10] >> 0) & 0xffff;
    destination[44]  = (source[11] >> 48) & 0xffff;
    destination[45]  = (source[11] >> 32) & 0xffff;
    destination[46]  = (source[11] >> 16) & 0xffff;
    destination[47]  = (source[11] >> 0) & 0xffff;
    destination[48]  = (source[12] >> 48) & 0xffff;
    destination[49]  = (source[12] >> 32) & 0xffff;
    destination[50]  = (source[12] >> 16) & 0xffff;
    destination[51]  = (source[12] >> 0) & 0xffff;
    destination[52]  = (source[13] >> 48) & 0xffff;
    destination[53]  = (source[13] >> 32) & 0xffff;
    destination[54]  = (source[13] >> 16) & 0xffff;
    destination[55]  = (source[13] >> 0) & 0xffff;
    destination[56]  = (source[14] >> 48) & 0xffff;
    destination[57]  = (source[14] >> 32) & 0xffff;
    destination[58]  = (source[14] >> 16) & 0xffff;
    destination[59]  = (source[14] >> 0) & 0xffff;
    destination[60]  = (source[15] >> 48) & 0xffff;
    destination[61]  = (source[15] >> 32) & 0xffff;
    destination[62]  = (source[15] >> 16) & 0xffff;
    destination[63]  = (source[15] >> 0) & 0xffff;
  }
};
template <typename Tp>
struct __struct_bitpack_impl<Tp,8,17>
{
  static const size_t unit_size = 64;
  static const size_t bits_total = 1088;
  static const size_t loop_total = 64;
  static const size_t bit_size = 17;
  static const Tp     mask = 0x1ffff;
  static inline
  void pack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] & 0x1ffff) << 47;
    destination[0] |= (source[1] & 0x1ffff) << 30;
    destination[0] |= (source[2] & 0x1ffff) << 13;
    destination[0] |= (source[3] & 0x1ffff) >> 4;
    destination[1]  = (source[3] & 0x1ffff) << 60;
    destination[1] |= (source[4] & 0x1ffff) << 43;
    destination[1] |= (source[5] & 0x1ffff) << 26;
    destination[1] |= (source[6] & 0x1ffff) << 9;
    destination[1] |= (source[7] & 0x1ffff) >> 8;
    destination[2]  = (source[7] & 0x1ffff) << 56;
    destination[2] |= (source[8] & 0x1ffff) << 39;
    destination[2] |= (source[9] & 0x1ffff) << 22;
    destination[2] |= (source[10] & 0x1ffff) << 5;
    destination[2] |= (source[11] & 0x1ffff) >> 12;
    destination[3]  = (source[11] & 0x1ffff) << 52;
    destination[3] |= (source[12] & 0x1ffff) << 35;
    destination[3] |= (source[13] & 0x1ffff) << 18;
    destination[3] |= (source[14] & 0x1ffff) << 1;
    destination[3] |= (source[15] & 0x1ffff) >> 16;
    destination[4]  = (source[15] & 0x1ffff) << 48;
    destination[4] |= (source[16] & 0x1ffff) << 31;
    destination[4] |= (source[17] & 0x1ffff) << 14;
    destination[4] |= (source[18] & 0x1ffff) >> 3;
    destination[5]  = (source[18] & 0x1ffff) << 61;
    destination[5] |= (source[19] & 0x1ffff) << 44;
    destination[5] |= (source[20] & 0x1ffff) << 27;
    destination[5] |= (source[21] & 0x1ffff) << 10;
    destination[5] |= (source[22] & 0x1ffff) >> 7;
    destination[6]  = (source[22] & 0x1ffff) << 57;
    destination[6] |= (source[23] & 0x1ffff) << 40;
    destination[6] |= (source[24] & 0x1ffff) << 23;
    destination[6] |= (source[25] & 0x1ffff) << 6;
    destination[6] |= (source[26] & 0x1ffff) >> 11;
    destination[7]  = (source[26] & 0x1ffff) << 53;
    destination[7] |= (source[27] & 0x1ffff) << 36;
    destination[7] |= (source[28] & 0x1ffff) << 19;
    destination[7] |= (source[29] & 0x1ffff) << 2;
    destination[7] |= (source[30] & 0x1ffff) >> 15;
    destination[8]  = (source[30] & 0x1ffff) << 49;
    destination[8] |= (source[31] & 0x1ffff) << 32;
    destination[8] |= (source[32] & 0x1ffff) << 15;
    destination[8] |= (source[33] & 0x1ffff) >> 2;
    destination[9]  = (source[33] & 0x1ffff) << 62;
    destination[9] |= (source[34] & 0x1ffff) << 45;
    destination[9] |= (source[35] & 0x1ffff) << 28;
    destination[9] |= (source[36] & 0x1ffff) << 11;
    destination[9] |= (source[37] & 0x1ffff) >> 6;
    destination[10]  = (source[37] & 0x1ffff) << 58;
    destination[10] |= (source[38] & 0x1ffff) << 41;
    destination[10] |= (source[39] & 0x1ffff) << 24;
    destination[10] |= (source[40] & 0x1ffff) << 7;
    destination[10] |= (source[41] & 0x1ffff) >> 10;
    destination[11]  = (source[41] & 0x1ffff) << 54;
    destination[11] |= (source[42] & 0x1ffff) << 37;
    destination[11] |= (source[43] & 0x1ffff) << 20;
    destination[11] |= (source[44] & 0x1ffff) << 3;
    destination[11] |= (source[45] & 0x1ffff) >> 14;
    destination[12]  = (source[45] & 0x1ffff) << 50;
    destination[12] |= (source[46] & 0x1ffff) << 33;
    destination[12] |= (source[47] & 0x1ffff) << 16;
    destination[12] |= (source[48] & 0x1ffff) >> 1;
    destination[13]  = (source[48] & 0x1ffff) << 63;
    destination[13] |= (source[49] & 0x1ffff) << 46;
    destination[13] |= (source[50] & 0x1ffff) << 29;
    destination[13] |= (source[51] & 0x1ffff) << 12;
    destination[13] |= (source[52] & 0x1ffff) >> 5;
    destination[14]  = (source[52] & 0x1ffff) << 59;
    destination[14] |= (source[53] & 0x1ffff) << 42;
    destination[14] |= (source[54] & 0x1ffff) << 25;
    destination[14] |= (source[55] & 0x1ffff) << 8;
    destination[14] |= (source[56] & 0x1ffff) >> 9;
    destination[15]  = (source[56] & 0x1ffff) << 55;
    destination[15] |= (source[57] & 0x1ffff) << 38;
    destination[15] |= (source[58] & 0x1ffff) << 21;
    destination[15] |= (source[59] & 0x1ffff) << 4;
    destination[15] |= (source[60] & 0x1ffff) >> 13;
    destination[16]  = (source[60] & 0x1ffff) << 51;
    destination[16] |= (source[61] & 0x1ffff) << 34;
    destination[16] |= (source[62] & 0x1ffff) << 17;
    destination[16] |= (source[63] & 0x1ffff) << 0;
  }
  static inline
  void unpack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] >> 47) & 0x1ffff;
    destination[1]  = (source[0] >> 30) & 0x1ffff;
    destination[2]  = (source[0] >> 13) & 0x1ffff;
    destination[3]  = (source[0] << 4) & 0x1ffff;
    destination[3] |= (source[1] >> 60) & 0x1ffff;
    destination[4]  = (source[1] >> 43) & 0x1ffff;
    destination[5]  = (source[1] >> 26) & 0x1ffff;
    destination[6]  = (source[1] >> 9) & 0x1ffff;
    destination[7]  = (source[1] << 8) & 0x1ffff;
    destination[7] |= (source[2] >> 56) & 0x1ffff;
    destination[8]  = (source[2] >> 39) & 0x1ffff;
    destination[9]  = (source[2] >> 22) & 0x1ffff;
    destination[10]  = (source[2] >> 5) & 0x1ffff;
    destination[11]  = (source[2] << 12) & 0x1ffff;
    destination[11] |= (source[3] >> 52) & 0x1ffff;
    destination[12]  = (source[3] >> 35) & 0x1ffff;
    destination[13]  = (source[3] >> 18) & 0x1ffff;
    destination[14]  = (source[3] >> 1) & 0x1ffff;
    destination[15]  = (source[3] << 16) & 0x1ffff;
    destination[15] |= (source[4] >> 48) & 0x1ffff;
    destination[16]  = (source[4] >> 31) & 0x1ffff;
    destination[17]  = (source[4] >> 14) & 0x1ffff;
    destination[18]  = (source[4] << 3) & 0x1ffff;
    destination[18] |= (source[5] >> 61) & 0x1ffff;
    destination[19]  = (source[5] >> 44) & 0x1ffff;
    destination[20]  = (source[5] >> 27) & 0x1ffff;
    destination[21]  = (source[5] >> 10) & 0x1ffff;
    destination[22]  = (source[5] << 7) & 0x1ffff;
    destination[22] |= (source[6] >> 57) & 0x1ffff;
    destination[23]  = (source[6] >> 40) & 0x1ffff;
    destination[24]  = (source[6] >> 23) & 0x1ffff;
    destination[25]  = (source[6] >> 6) & 0x1ffff;
    destination[26]  = (source[6] << 11) & 0x1ffff;
    destination[26] |= (source[7] >> 53) & 0x1ffff;
    destination[27]  = (source[7] >> 36) & 0x1ffff;
    destination[28]  = (source[7] >> 19) & 0x1ffff;
    destination[29]  = (source[7] >> 2) & 0x1ffff;
    destination[30]  = (source[7] << 15) & 0x1ffff;
    destination[30] |= (source[8] >> 49) & 0x1ffff;
    destination[31]  = (source[8] >> 32) & 0x1ffff;
    destination[32]  = (source[8] >> 15) & 0x1ffff;
    destination[33]  = (source[8] << 2) & 0x1ffff;
    destination[33] |= (source[9] >> 62) & 0x1ffff;
    destination[34]  = (source[9] >> 45) & 0x1ffff;
    destination[35]  = (source[9] >> 28) & 0x1ffff;
    destination[36]  = (source[9] >> 11) & 0x1ffff;
    destination[37]  = (source[9] << 6) & 0x1ffff;
    destination[37] |= (source[10] >> 58) & 0x1ffff;
    destination[38]  = (source[10] >> 41) & 0x1ffff;
    destination[39]  = (source[10] >> 24) & 0x1ffff;
    destination[40]  = (source[10] >> 7) & 0x1ffff;
    destination[41]  = (source[10] << 10) & 0x1ffff;
    destination[41] |= (source[11] >> 54) & 0x1ffff;
    destination[42]  = (source[11] >> 37) & 0x1ffff;
    destination[43]  = (source[11] >> 20) & 0x1ffff;
    destination[44]  = (source[11] >> 3) & 0x1ffff;
    destination[45]  = (source[11] << 14) & 0x1ffff;
    destination[45] |= (source[12] >> 50) & 0x1ffff;
    destination[46]  = (source[12] >> 33) & 0x1ffff;
    destination[47]  = (source[12] >> 16) & 0x1ffff;
    destination[48]  = (source[12] << 1) & 0x1ffff;
    destination[48] |= (source[13] >> 63) & 0x1ffff;
    destination[49]  = (source[13] >> 46) & 0x1ffff;
    destination[50]  = (source[13] >> 29) & 0x1ffff;
    destination[51]  = (source[13] >> 12) & 0x1ffff;
    destination[52]  = (source[13] << 5) & 0x1ffff;
    destination[52] |= (source[14] >> 59) & 0x1ffff;
    destination[53]  = (source[14] >> 42) & 0x1ffff;
    destination[54]  = (source[14] >> 25) & 0x1ffff;
    destination[55]  = (source[14] >> 8) & 0x1ffff;
    destination[56]  = (source[14] << 9) & 0x1ffff;
    destination[56] |= (source[15] >> 55) & 0x1ffff;
    destination[57]  = (source[15] >> 38) & 0x1ffff;
    destination[58]  = (source[15] >> 21) & 0x1ffff;
    destination[59]  = (source[15] >> 4) & 0x1ffff;
    destination[60]  = (source[15] << 13) & 0x1ffff;
    destination[60] |= (source[16] >> 51) & 0x1ffff;
    destination[61]  = (source[16] >> 34) & 0x1ffff;
    destination[62]  = (source[16] >> 17) & 0x1ffff;
    destination[63]  = (source[16] >> 0) & 0x1ffff;
  }
};
template <typename Tp>
struct __struct_bitpack_impl<Tp,8,18>
{
  static const size_t unit_size = 64;
  static const size_t bits_total = 1152;
  static const size_t loop_total = 64;
  static const size_t bit_size = 18;
  static const Tp     mask = 0x3ffff;
  static inline
  void pack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] & 0x3ffff) << 46;
    destination[0] |= (source[1] & 0x3ffff) << 28;
    destination[0] |= (source[2] & 0x3ffff) << 10;
    destination[0] |= (source[3] & 0x3ffff) >> 8;
    destination[1]  = (source[3] & 0x3ffff) << 56;
    destination[1] |= (source[4] & 0x3ffff) << 38;
    destination[1] |= (source[5] & 0x3ffff) << 20;
    destination[1] |= (source[6] & 0x3ffff) << 2;
    destination[1] |= (source[7] & 0x3ffff) >> 16;
    destination[2]  = (source[7] & 0x3ffff) << 48;
    destination[2] |= (source[8] & 0x3ffff) << 30;
    destination[2] |= (source[9] & 0x3ffff) << 12;
    destination[2] |= (source[10] & 0x3ffff) >> 6;
    destination[3]  = (source[10] & 0x3ffff) << 58;
    destination[3] |= (source[11] & 0x3ffff) << 40;
    destination[3] |= (source[12] & 0x3ffff) << 22;
    destination[3] |= (source[13] & 0x3ffff) << 4;
    destination[3] |= (source[14] & 0x3ffff) >> 14;
    destination[4]  = (source[14] & 0x3ffff) << 50;
    destination[4] |= (source[15] & 0x3ffff) << 32;
    destination[4] |= (source[16] & 0x3ffff) << 14;
    destination[4] |= (source[17] & 0x3ffff) >> 4;
    destination[5]  = (source[17] & 0x3ffff) << 60;
    destination[5] |= (source[18] & 0x3ffff) << 42;
    destination[5] |= (source[19] & 0x3ffff) << 24;
    destination[5] |= (source[20] & 0x3ffff) << 6;
    destination[5] |= (source[21] & 0x3ffff) >> 12;
    destination[6]  = (source[21] & 0x3ffff) << 52;
    destination[6] |= (source[22] & 0x3ffff) << 34;
    destination[6] |= (source[23] & 0x3ffff) << 16;
    destination[6] |= (source[24] & 0x3ffff) >> 2;
    destination[7]  = (source[24] & 0x3ffff) << 62;
    destination[7] |= (source[25] & 0x3ffff) << 44;
    destination[7] |= (source[26] & 0x3ffff) << 26;
    destination[7] |= (source[27] & 0x3ffff) << 8;
    destination[7] |= (source[28] & 0x3ffff) >> 10;
    destination[8]  = (source[28] & 0x3ffff) << 54;
    destination[8] |= (source[29] & 0x3ffff) << 36;
    destination[8] |= (source[30] & 0x3ffff) << 18;
    destination[8] |= (source[31] & 0x3ffff) << 0;
    destination[9]  = (source[32] & 0x3ffff) << 46;
    destination[9] |= (source[33] & 0x3ffff) << 28;
    destination[9] |= (source[34] & 0x3ffff) << 10;
    destination[9] |= (source[35] & 0x3ffff) >> 8;
    destination[10]  = (source[35] & 0x3ffff) << 56;
    destination[10] |= (source[36] & 0x3ffff) << 38;
    destination[10] |= (source[37] & 0x3ffff) << 20;
    destination[10] |= (source[38] & 0x3ffff) << 2;
    destination[10] |= (source[39] & 0x3ffff) >> 16;
    destination[11]  = (source[39] & 0x3ffff) << 48;
    destination[11] |= (source[40] & 0x3ffff) << 30;
    destination[11] |= (source[41] & 0x3ffff) << 12;
    destination[11] |= (source[42] & 0x3ffff) >> 6;
    destination[12]  = (source[42] & 0x3ffff) << 58;
    destination[12] |= (source[43] & 0x3ffff) << 40;
    destination[12] |= (source[44] & 0x3ffff) << 22;
    destination[12] |= (source[45] & 0x3ffff) << 4;
    destination[12] |= (source[46] & 0x3ffff) >> 14;
    destination[13]  = (source[46] & 0x3ffff) << 50;
    destination[13] |= (source[47] & 0x3ffff) << 32;
    destination[13] |= (source[48] & 0x3ffff) << 14;
    destination[13] |= (source[49] & 0x3ffff) >> 4;
    destination[14]  = (source[49] & 0x3ffff) << 60;
    destination[14] |= (source[50] & 0x3ffff) << 42;
    destination[14] |= (source[51] & 0x3ffff) << 24;
    destination[14] |= (source[52] & 0x3ffff) << 6;
    destination[14] |= (source[53] & 0x3ffff) >> 12;
    destination[15]  = (source[53] & 0x3ffff) << 52;
    destination[15] |= (source[54] & 0x3ffff) << 34;
    destination[15] |= (source[55] & 0x3ffff) << 16;
    destination[15] |= (source[56] & 0x3ffff) >> 2;
    destination[16]  = (source[56] & 0x3ffff) << 62;
    destination[16] |= (source[57] & 0x3ffff) << 44;
    destination[16] |= (source[58] & 0x3ffff) << 26;
    destination[16] |= (source[59] & 0x3ffff) << 8;
    destination[16] |= (source[60] & 0x3ffff) >> 10;
    destination[17]  = (source[60] & 0x3ffff) << 54;
    destination[17] |= (source[61] & 0x3ffff) << 36;
    destination[17] |= (source[62] & 0x3ffff) << 18;
    destination[17] |= (source[63] & 0x3ffff) << 0;
  }
  static inline
  void unpack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] >> 46) & 0x3ffff;
    destination[1]  = (source[0] >> 28) & 0x3ffff;
    destination[2]  = (source[0] >> 10) & 0x3ffff;
    destination[3]  = (source[0] << 8) & 0x3ffff;
    destination[3] |= (source[1] >> 56) & 0x3ffff;
    destination[4]  = (source[1] >> 38) & 0x3ffff;
    destination[5]  = (source[1] >> 20) & 0x3ffff;
    destination[6]  = (source[1] >> 2) & 0x3ffff;
    destination[7]  = (source[1] << 16) & 0x3ffff;
    destination[7] |= (source[2] >> 48) & 0x3ffff;
    destination[8]  = (source[2] >> 30) & 0x3ffff;
    destination[9]  = (source[2] >> 12) & 0x3ffff;
    destination[10]  = (source[2] << 6) & 0x3ffff;
    destination[10] |= (source[3] >> 58) & 0x3ffff;
    destination[11]  = (source[3] >> 40) & 0x3ffff;
    destination[12]  = (source[3] >> 22) & 0x3ffff;
    destination[13]  = (source[3] >> 4) & 0x3ffff;
    destination[14]  = (source[3] << 14) & 0x3ffff;
    destination[14] |= (source[4] >> 50) & 0x3ffff;
    destination[15]  = (source[4] >> 32) & 0x3ffff;
    destination[16]  = (source[4] >> 14) & 0x3ffff;
    destination[17]  = (source[4] << 4) & 0x3ffff;
    destination[17] |= (source[5] >> 60) & 0x3ffff;
    destination[18]  = (source[5] >> 42) & 0x3ffff;
    destination[19]  = (source[5] >> 24) & 0x3ffff;
    destination[20]  = (source[5] >> 6) & 0x3ffff;
    destination[21]  = (source[5] << 12) & 0x3ffff;
    destination[21] |= (source[6] >> 52) & 0x3ffff;
    destination[22]  = (source[6] >> 34) & 0x3ffff;
    destination[23]  = (source[6] >> 16) & 0x3ffff;
    destination[24]  = (source[6] << 2) & 0x3ffff;
    destination[24] |= (source[7] >> 62) & 0x3ffff;
    destination[25]  = (source[7] >> 44) & 0x3ffff;
    destination[26]  = (source[7] >> 26) & 0x3ffff;
    destination[27]  = (source[7] >> 8) & 0x3ffff;
    destination[28]  = (source[7] << 10) & 0x3ffff;
    destination[28] |= (source[8] >> 54) & 0x3ffff;
    destination[29]  = (source[8] >> 36) & 0x3ffff;
    destination[30]  = (source[8] >> 18) & 0x3ffff;
    destination[31]  = (source[8] >> 0) & 0x3ffff;
    destination[32]  = (source[9] >> 46) & 0x3ffff;
    destination[33]  = (source[9] >> 28) & 0x3ffff;
    destination[34]  = (source[9] >> 10) & 0x3ffff;
    destination[35]  = (source[9] << 8) & 0x3ffff;
    destination[35] |= (source[10] >> 56) & 0x3ffff;
    destination[36]  = (source[10] >> 38) & 0x3ffff;
    destination[37]  = (source[10] >> 20) & 0x3ffff;
    destination[38]  = (source[10] >> 2) & 0x3ffff;
    destination[39]  = (source[10] << 16) & 0x3ffff;
    destination[39] |= (source[11] >> 48) & 0x3ffff;
    destination[40]  = (source[11] >> 30) & 0x3ffff;
    destination[41]  = (source[11] >> 12) & 0x3ffff;
    destination[42]  = (source[11] << 6) & 0x3ffff;
    destination[42] |= (source[12] >> 58) & 0x3ffff;
    destination[43]  = (source[12] >> 40) & 0x3ffff;
    destination[44]  = (source[12] >> 22) & 0x3ffff;
    destination[45]  = (source[12] >> 4) & 0x3ffff;
    destination[46]  = (source[12] << 14) & 0x3ffff;
    destination[46] |= (source[13] >> 50) & 0x3ffff;
    destination[47]  = (source[13] >> 32) & 0x3ffff;
    destination[48]  = (source[13] >> 14) & 0x3ffff;
    destination[49]  = (source[13] << 4) & 0x3ffff;
    destination[49] |= (source[14] >> 60) & 0x3ffff;
    destination[50]  = (source[14] >> 42) & 0x3ffff;
    destination[51]  = (source[14] >> 24) & 0x3ffff;
    destination[52]  = (source[14] >> 6) & 0x3ffff;
    destination[53]  = (source[14] << 12) & 0x3ffff;
    destination[53] |= (source[15] >> 52) & 0x3ffff;
    destination[54]  = (source[15] >> 34) & 0x3ffff;
    destination[55]  = (source[15] >> 16) & 0x3ffff;
    destination[56]  = (source[15] << 2) & 0x3ffff;
    destination[56] |= (source[16] >> 62) & 0x3ffff;
    destination[57]  = (source[16] >> 44) & 0x3ffff;
    destination[58]  = (source[16] >> 26) & 0x3ffff;
    destination[59]  = (source[16] >> 8) & 0x3ffff;
    destination[60]  = (source[16] << 10) & 0x3ffff;
    destination[60] |= (source[17] >> 54) & 0x3ffff;
    destination[61]  = (source[17] >> 36) & 0x3ffff;
    destination[62]  = (source[17] >> 18) & 0x3ffff;
    destination[63]  = (source[17] >> 0) & 0x3ffff;
  }
};
template <typename Tp>
struct __struct_bitpack_impl<Tp,8,19>
{
  static const size_t unit_size = 64;
  static const size_t bits_total = 1216;
  static const size_t loop_total = 64;
  static const size_t bit_size = 19;
  static const Tp     mask = 0x7ffff;
  static inline
  void pack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] & 0x7ffff) << 45;
    destination[0] |= (source[1] & 0x7ffff) << 26;
    destination[0] |= (source[2] & 0x7ffff) << 7;
    destination[0] |= (source[3] & 0x7ffff) >> 12;
    destination[1]  = (source[3] & 0x7ffff) << 52;
    destination[1] |= (source[4] & 0x7ffff) << 33;
    destination[1] |= (source[5] & 0x7ffff) << 14;
    destination[1] |= (source[6] & 0x7ffff) >> 5;
    destination[2]  = (source[6] & 0x7ffff) << 59;
    destination[2] |= (source[7] & 0x7ffff) << 40;
    destination[2] |= (source[8] & 0x7ffff) << 21;
    destination[2] |= (source[9] & 0x7ffff) << 2;
    destination[2] |= (source[10] & 0x7ffff) >> 17;
    destination[3]  = (source[10] & 0x7ffff) << 47;
    destination[3] |= (source[11] & 0x7ffff) << 28;
    destination[3] |= (source[12] & 0x7ffff) << 9;
    destination[3] |= (source[13] & 0x7ffff) >> 10;
    destination[4]  = (source[13] & 0x7ffff) << 54;
    destination[4] |= (source[14] & 0x7ffff) << 35;
    destination[4] |= (source[15] & 0x7ffff) << 16;
    destination[4] |= (source[16] & 0x7ffff) >> 3;
    destination[5]  = (source[16] & 0x7ffff) << 61;
    destination[5] |= (source[17] & 0x7ffff) << 42;
    destination[5] |= (source[18] & 0x7ffff) << 23;
    destination[5] |= (source[19] & 0x7ffff) << 4;
    destination[5] |= (source[20] & 0x7ffff) >> 15;
    destination[6]  = (source[20] & 0x7ffff) << 49;
    destination[6] |= (source[21] & 0x7ffff) << 30;
    destination[6] |= (source[22] & 0x7ffff) << 11;
    destination[6] |= (source[23] & 0x7ffff) >> 8;
    destination[7]  = (source[23] & 0x7ffff) << 56;
    destination[7] |= (source[24] & 0x7ffff) << 37;
    destination[7] |= (source[25] & 0x7ffff) << 18;
    destination[7] |= (source[26] & 0x7ffff) >> 1;
    destination[8]  = (source[26] & 0x7ffff) << 63;
    destination[8] |= (source[27] & 0x7ffff) << 44;
    destination[8] |= (source[28] & 0x7ffff) << 25;
    destination[8] |= (source[29] & 0x7ffff) << 6;
    destination[8] |= (source[30] & 0x7ffff) >> 13;
    destination[9]  = (source[30] & 0x7ffff) << 51;
    destination[9] |= (source[31] & 0x7ffff) << 32;
    destination[9] |= (source[32] & 0x7ffff) << 13;
    destination[9] |= (source[33] & 0x7ffff) >> 6;
    destination[10]  = (source[33] & 0x7ffff) << 58;
    destination[10] |= (source[34] & 0x7ffff) << 39;
    destination[10] |= (source[35] & 0x7ffff) << 20;
    destination[10] |= (source[36] & 0x7ffff) << 1;
    destination[10] |= (source[37] & 0x7ffff) >> 18;
    destination[11]  = (source[37] & 0x7ffff) << 46;
    destination[11] |= (source[38] & 0x7ffff) << 27;
    destination[11] |= (source[39] & 0x7ffff) << 8;
    destination[11] |= (source[40] & 0x7ffff) >> 11;
    destination[12]  = (source[40] & 0x7ffff) << 53;
    destination[12] |= (source[41] & 0x7ffff) << 34;
    destination[12] |= (source[42] & 0x7ffff) << 15;
    destination[12] |= (source[43] & 0x7ffff) >> 4;
    destination[13]  = (source[43] & 0x7ffff) << 60;
    destination[13] |= (source[44] & 0x7ffff) << 41;
    destination[13] |= (source[45] & 0x7ffff) << 22;
    destination[13] |= (source[46] & 0x7ffff) << 3;
    destination[13] |= (source[47] & 0x7ffff) >> 16;
    destination[14]  = (source[47] & 0x7ffff) << 48;
    destination[14] |= (source[48] & 0x7ffff) << 29;
    destination[14] |= (source[49] & 0x7ffff) << 10;
    destination[14] |= (source[50] & 0x7ffff) >> 9;
    destination[15]  = (source[50] & 0x7ffff) << 55;
    destination[15] |= (source[51] & 0x7ffff) << 36;
    destination[15] |= (source[52] & 0x7ffff) << 17;
    destination[15] |= (source[53] & 0x7ffff) >> 2;
    destination[16]  = (source[53] & 0x7ffff) << 62;
    destination[16] |= (source[54] & 0x7ffff) << 43;
    destination[16] |= (source[55] & 0x7ffff) << 24;
    destination[16] |= (source[56] & 0x7ffff) << 5;
    destination[16] |= (source[57] & 0x7ffff) >> 14;
    destination[17]  = (source[57] & 0x7ffff) << 50;
    destination[17] |= (source[58] & 0x7ffff) << 31;
    destination[17] |= (source[59] & 0x7ffff) << 12;
    destination[17] |= (source[60] & 0x7ffff) >> 7;
    destination[18]  = (source[60] & 0x7ffff) << 57;
    destination[18] |= (source[61] & 0x7ffff) << 38;
    destination[18] |= (source[62] & 0x7ffff) << 19;
    destination[18] |= (source[63] & 0x7ffff) << 0;
  }
  static inline
  void unpack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] >> 45) & 0x7ffff;
    destination[1]  = (source[0] >> 26) & 0x7ffff;
    destination[2]  = (source[0] >> 7) & 0x7ffff;
    destination[3]  = (source[0] << 12) & 0x7ffff;
    destination[3] |= (source[1] >> 52) & 0x7ffff;
    destination[4]  = (source[1] >> 33) & 0x7ffff;
    destination[5]  = (source[1] >> 14) & 0x7ffff;
    destination[6]  = (source[1] << 5) & 0x7ffff;
    destination[6] |= (source[2] >> 59) & 0x7ffff;
    destination[7]  = (source[2] >> 40) & 0x7ffff;
    destination[8]  = (source[2] >> 21) & 0x7ffff;
    destination[9]  = (source[2] >> 2) & 0x7ffff;
    destination[10]  = (source[2] << 17) & 0x7ffff;
    destination[10] |= (source[3] >> 47) & 0x7ffff;
    destination[11]  = (source[3] >> 28) & 0x7ffff;
    destination[12]  = (source[3] >> 9) & 0x7ffff;
    destination[13]  = (source[3] << 10) & 0x7ffff;
    destination[13] |= (source[4] >> 54) & 0x7ffff;
    destination[14]  = (source[4] >> 35) & 0x7ffff;
    destination[15]  = (source[4] >> 16) & 0x7ffff;
    destination[16]  = (source[4] << 3) & 0x7ffff;
    destination[16] |= (source[5] >> 61) & 0x7ffff;
    destination[17]  = (source[5] >> 42) & 0x7ffff;
    destination[18]  = (source[5] >> 23) & 0x7ffff;
    destination[19]  = (source[5] >> 4) & 0x7ffff;
    destination[20]  = (source[5] << 15) & 0x7ffff;
    destination[20] |= (source[6] >> 49) & 0x7ffff;
    destination[21]  = (source[6] >> 30) & 0x7ffff;
    destination[22]  = (source[6] >> 11) & 0x7ffff;
    destination[23]  = (source[6] << 8) & 0x7ffff;
    destination[23] |= (source[7] >> 56) & 0x7ffff;
    destination[24]  = (source[7] >> 37) & 0x7ffff;
    destination[25]  = (source[7] >> 18) & 0x7ffff;
    destination[26]  = (source[7] << 1) & 0x7ffff;
    destination[26] |= (source[8] >> 63) & 0x7ffff;
    destination[27]  = (source[8] >> 44) & 0x7ffff;
    destination[28]  = (source[8] >> 25) & 0x7ffff;
    destination[29]  = (source[8] >> 6) & 0x7ffff;
    destination[30]  = (source[8] << 13) & 0x7ffff;
    destination[30] |= (source[9] >> 51) & 0x7ffff;
    destination[31]  = (source[9] >> 32) & 0x7ffff;
    destination[32]  = (source[9] >> 13) & 0x7ffff;
    destination[33]  = (source[9] << 6) & 0x7ffff;
    destination[33] |= (source[10] >> 58) & 0x7ffff;
    destination[34]  = (source[10] >> 39) & 0x7ffff;
    destination[35]  = (source[10] >> 20) & 0x7ffff;
    destination[36]  = (source[10] >> 1) & 0x7ffff;
    destination[37]  = (source[10] << 18) & 0x7ffff;
    destination[37] |= (source[11] >> 46) & 0x7ffff;
    destination[38]  = (source[11] >> 27) & 0x7ffff;
    destination[39]  = (source[11] >> 8) & 0x7ffff;
    destination[40]  = (source[11] << 11) & 0x7ffff;
    destination[40] |= (source[12] >> 53) & 0x7ffff;
    destination[41]  = (source[12] >> 34) & 0x7ffff;
    destination[42]  = (source[12] >> 15) & 0x7ffff;
    destination[43]  = (source[12] << 4) & 0x7ffff;
    destination[43] |= (source[13] >> 60) & 0x7ffff;
    destination[44]  = (source[13] >> 41) & 0x7ffff;
    destination[45]  = (source[13] >> 22) & 0x7ffff;
    destination[46]  = (source[13] >> 3) & 0x7ffff;
    destination[47]  = (source[13] << 16) & 0x7ffff;
    destination[47] |= (source[14] >> 48) & 0x7ffff;
    destination[48]  = (source[14] >> 29) & 0x7ffff;
    destination[49]  = (source[14] >> 10) & 0x7ffff;
    destination[50]  = (source[14] << 9) & 0x7ffff;
    destination[50] |= (source[15] >> 55) & 0x7ffff;
    destination[51]  = (source[15] >> 36) & 0x7ffff;
    destination[52]  = (source[15] >> 17) & 0x7ffff;
    destination[53]  = (source[15] << 2) & 0x7ffff;
    destination[53] |= (source[16] >> 62) & 0x7ffff;
    destination[54]  = (source[16] >> 43) & 0x7ffff;
    destination[55]  = (source[16] >> 24) & 0x7ffff;
    destination[56]  = (source[16] >> 5) & 0x7ffff;
    destination[57]  = (source[16] << 14) & 0x7ffff;
    destination[57] |= (source[17] >> 50) & 0x7ffff;
    destination[58]  = (source[17] >> 31) & 0x7ffff;
    destination[59]  = (source[17] >> 12) & 0x7ffff;
    destination[60]  = (source[17] << 7) & 0x7ffff;
    destination[60] |= (source[18] >> 57) & 0x7ffff;
    destination[61]  = (source[18] >> 38) & 0x7ffff;
    destination[62]  = (source[18] >> 19) & 0x7ffff;
    destination[63]  = (source[18] >> 0) & 0x7ffff;
  }
};
template <typename Tp>
struct __struct_bitpack_impl<Tp,8,20>
{
  static const size_t unit_size = 64;
  static const size_t bits_total = 1280;
  static const size_t loop_total = 64;
  static const size_t bit_size = 20;
  static const Tp     mask = 0xfffff;
  static inline
  void pack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] & 0xfffff) << 44;
    destination[0] |= (source[1] & 0xfffff) << 24;
    destination[0] |= (source[2] & 0xfffff) << 4;
    destination[0] |= (source[3] & 0xfffff) >> 16;
    destination[1]  = (source[3] & 0xfffff) << 48;
    destination[1] |= (source[4] & 0xfffff) << 28;
    destination[1] |= (source[5] & 0xfffff) << 8;
    destination[1] |= (source[6] & 0xfffff) >> 12;
    destination[2]  = (source[6] & 0xfffff) << 52;
    destination[2] |= (source[7] & 0xfffff) << 32;
    destination[2] |= (source[8] & 0xfffff) << 12;
    destination[2] |= (source[9] & 0xfffff) >> 8;
    destination[3]  = (source[9] & 0xfffff) << 56;
    destination[3] |= (source[10] & 0xfffff) << 36;
    destination[3] |= (source[11] & 0xfffff) << 16;
    destination[3] |= (source[12] & 0xfffff) >> 4;
    destination[4]  = (source[12] & 0xfffff) << 60;
    destination[4] |= (source[13] & 0xfffff) << 40;
    destination[4] |= (source[14] & 0xfffff) << 20;
    destination[4] |= (source[15] & 0xfffff) << 0;
    destination[5]  = (source[16] & 0xfffff) << 44;
    destination[5] |= (source[17] & 0xfffff) << 24;
    destination[5] |= (source[18] & 0xfffff) << 4;
    destination[5] |= (source[19] & 0xfffff) >> 16;
    destination[6]  = (source[19] & 0xfffff) << 48;
    destination[6] |= (source[20] & 0xfffff) << 28;
    destination[6] |= (source[21] & 0xfffff) << 8;
    destination[6] |= (source[22] & 0xfffff) >> 12;
    destination[7]  = (source[22] & 0xfffff) << 52;
    destination[7] |= (source[23] & 0xfffff) << 32;
    destination[7] |= (source[24] & 0xfffff) << 12;
    destination[7] |= (source[25] & 0xfffff) >> 8;
    destination[8]  = (source[25] & 0xfffff) << 56;
    destination[8] |= (source[26] & 0xfffff) << 36;
    destination[8] |= (source[27] & 0xfffff) << 16;
    destination[8] |= (source[28] & 0xfffff) >> 4;
    destination[9]  = (source[28] & 0xfffff) << 60;
    destination[9] |= (source[29] & 0xfffff) << 40;
    destination[9] |= (source[30] & 0xfffff) << 20;
    destination[9] |= (source[31] & 0xfffff) << 0;
    destination[10]  = (source[32] & 0xfffff) << 44;
    destination[10] |= (source[33] & 0xfffff) << 24;
    destination[10] |= (source[34] & 0xfffff) << 4;
    destination[10] |= (source[35] & 0xfffff) >> 16;
    destination[11]  = (source[35] & 0xfffff) << 48;
    destination[11] |= (source[36] & 0xfffff) << 28;
    destination[11] |= (source[37] & 0xfffff) << 8;
    destination[11] |= (source[38] & 0xfffff) >> 12;
    destination[12]  = (source[38] & 0xfffff) << 52;
    destination[12] |= (source[39] & 0xfffff) << 32;
    destination[12] |= (source[40] & 0xfffff) << 12;
    destination[12] |= (source[41] & 0xfffff) >> 8;
    destination[13]  = (source[41] & 0xfffff) << 56;
    destination[13] |= (source[42] & 0xfffff) << 36;
    destination[13] |= (source[43] & 0xfffff) << 16;
    destination[13] |= (source[44] & 0xfffff) >> 4;
    destination[14]  = (source[44] & 0xfffff) << 60;
    destination[14] |= (source[45] & 0xfffff) << 40;
    destination[14] |= (source[46] & 0xfffff) << 20;
    destination[14] |= (source[47] & 0xfffff) << 0;
    destination[15]  = (source[48] & 0xfffff) << 44;
    destination[15] |= (source[49] & 0xfffff) << 24;
    destination[15] |= (source[50] & 0xfffff) << 4;
    destination[15] |= (source[51] & 0xfffff) >> 16;
    destination[16]  = (source[51] & 0xfffff) << 48;
    destination[16] |= (source[52] & 0xfffff) << 28;
    destination[16] |= (source[53] & 0xfffff) << 8;
    destination[16] |= (source[54] & 0xfffff) >> 12;
    destination[17]  = (source[54] & 0xfffff) << 52;
    destination[17] |= (source[55] & 0xfffff) << 32;
    destination[17] |= (source[56] & 0xfffff) << 12;
    destination[17] |= (source[57] & 0xfffff) >> 8;
    destination[18]  = (source[57] & 0xfffff) << 56;
    destination[18] |= (source[58] & 0xfffff) << 36;
    destination[18] |= (source[59] & 0xfffff) << 16;
    destination[18] |= (source[60] & 0xfffff) >> 4;
    destination[19]  = (source[60] & 0xfffff) << 60;
    destination[19] |= (source[61] & 0xfffff) << 40;
    destination[19] |= (source[62] & 0xfffff) << 20;
    destination[19] |= (source[63] & 0xfffff) << 0;
  }
  static inline
  void unpack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] >> 44) & 0xfffff;
    destination[1]  = (source[0] >> 24) & 0xfffff;
    destination[2]  = (source[0] >> 4) & 0xfffff;
    destination[3]  = (source[0] << 16) & 0xfffff;
    destination[3] |= (source[1] >> 48) & 0xfffff;
    destination[4]  = (source[1] >> 28) & 0xfffff;
    destination[5]  = (source[1] >> 8) & 0xfffff;
    destination[6]  = (source[1] << 12) & 0xfffff;
    destination[6] |= (source[2] >> 52) & 0xfffff;
    destination[7]  = (source[2] >> 32) & 0xfffff;
    destination[8]  = (source[2] >> 12) & 0xfffff;
    destination[9]  = (source[2] << 8) & 0xfffff;
    destination[9] |= (source[3] >> 56) & 0xfffff;
    destination[10]  = (source[3] >> 36) & 0xfffff;
    destination[11]  = (source[3] >> 16) & 0xfffff;
    destination[12]  = (source[3] << 4) & 0xfffff;
    destination[12] |= (source[4] >> 60) & 0xfffff;
    destination[13]  = (source[4] >> 40) & 0xfffff;
    destination[14]  = (source[4] >> 20) & 0xfffff;
    destination[15]  = (source[4] >> 0) & 0xfffff;
    destination[16]  = (source[5] >> 44) & 0xfffff;
    destination[17]  = (source[5] >> 24) & 0xfffff;
    destination[18]  = (source[5] >> 4) & 0xfffff;
    destination[19]  = (source[5] << 16) & 0xfffff;
    destination[19] |= (source[6] >> 48) & 0xfffff;
    destination[20]  = (source[6] >> 28) & 0xfffff;
    destination[21]  = (source[6] >> 8) & 0xfffff;
    destination[22]  = (source[6] << 12) & 0xfffff;
    destination[22] |= (source[7] >> 52) & 0xfffff;
    destination[23]  = (source[7] >> 32) & 0xfffff;
    destination[24]  = (source[7] >> 12) & 0xfffff;
    destination[25]  = (source[7] << 8) & 0xfffff;
    destination[25] |= (source[8] >> 56) & 0xfffff;
    destination[26]  = (source[8] >> 36) & 0xfffff;
    destination[27]  = (source[8] >> 16) & 0xfffff;
    destination[28]  = (source[8] << 4) & 0xfffff;
    destination[28] |= (source[9] >> 60) & 0xfffff;
    destination[29]  = (source[9] >> 40) & 0xfffff;
    destination[30]  = (source[9] >> 20) & 0xfffff;
    destination[31]  = (source[9] >> 0) & 0xfffff;
    destination[32]  = (source[10] >> 44) & 0xfffff;
    destination[33]  = (source[10] >> 24) & 0xfffff;
    destination[34]  = (source[10] >> 4) & 0xfffff;
    destination[35]  = (source[10] << 16) & 0xfffff;
    destination[35] |= (source[11] >> 48) & 0xfffff;
    destination[36]  = (source[11] >> 28) & 0xfffff;
    destination[37]  = (source[11] >> 8) & 0xfffff;
    destination[38]  = (source[11] << 12) & 0xfffff;
    destination[38] |= (source[12] >> 52) & 0xfffff;
    destination[39]  = (source[12] >> 32) & 0xfffff;
    destination[40]  = (source[12] >> 12) & 0xfffff;
    destination[41]  = (source[12] << 8) & 0xfffff;
    destination[41] |= (source[13] >> 56) & 0xfffff;
    destination[42]  = (source[13] >> 36) & 0xfffff;
    destination[43]  = (source[13] >> 16) & 0xfffff;
    destination[44]  = (source[13] << 4) & 0xfffff;
    destination[44] |= (source[14] >> 60) & 0xfffff;
    destination[45]  = (source[14] >> 40) & 0xfffff;
    destination[46]  = (source[14] >> 20) & 0xfffff;
    destination[47]  = (source[14] >> 0) & 0xfffff;
    destination[48]  = (source[15] >> 44) & 0xfffff;
    destination[49]  = (source[15] >> 24) & 0xfffff;
    destination[50]  = (source[15] >> 4) & 0xfffff;
    destination[51]  = (source[15] << 16) & 0xfffff;
    destination[51] |= (source[16] >> 48) & 0xfffff;
    destination[52]  = (source[16] >> 28) & 0xfffff;
    destination[53]  = (source[16] >> 8) & 0xfffff;
    destination[54]  = (source[16] << 12) & 0xfffff;
    destination[54] |= (source[17] >> 52) & 0xfffff;
    destination[55]  = (source[17] >> 32) & 0xfffff;
    destination[56]  = (source[17] >> 12) & 0xfffff;
    destination[57]  = (source[17] << 8) & 0xfffff;
    destination[57] |= (source[18] >> 56) & 0xfffff;
    destination[58]  = (source[18] >> 36) & 0xfffff;
    destination[59]  = (source[18] >> 16) & 0xfffff;
    destination[60]  = (source[18] << 4) & 0xfffff;
    destination[60] |= (source[19] >> 60) & 0xfffff;
    destination[61]  = (source[19] >> 40) & 0xfffff;
    destination[62]  = (source[19] >> 20) & 0xfffff;
    destination[63]  = (source[19] >> 0) & 0xfffff;
  }
};
template <typename Tp>
struct __struct_bitpack_impl<Tp,8,21>
{
  static const size_t unit_size = 64;
  static const size_t bits_total = 1344;
  static const size_t loop_total = 64;
  static const size_t bit_size = 21;
  static const Tp     mask = 0x1fffff;
  static inline
  void pack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] & 0x1fffff) << 43;
    destination[0] |= (source[1] & 0x1fffff) << 22;
    destination[0] |= (source[2] & 0x1fffff) << 1;
    destination[0] |= (source[3] & 0x1fffff) >> 20;
    destination[1]  = (source[3] & 0x1fffff) << 44;
    destination[1] |= (source[4] & 0x1fffff) << 23;
    destination[1] |= (source[5] & 0x1fffff) << 2;
    destination[1] |= (source[6] & 0x1fffff) >> 19;
    destination[2]  = (source[6] & 0x1fffff) << 45;
    destination[2] |= (source[7] & 0x1fffff) << 24;
    destination[2] |= (source[8] & 0x1fffff) << 3;
    destination[2] |= (source[9] & 0x1fffff) >> 18;
    destination[3]  = (source[9] & 0x1fffff) << 46;
    destination[3] |= (source[10] & 0x1fffff) << 25;
    destination[3] |= (source[11] & 0x1fffff) << 4;
    destination[3] |= (source[12] & 0x1fffff) >> 17;
    destination[4]  = (source[12] & 0x1fffff) << 47;
    destination[4] |= (source[13] & 0x1fffff) << 26;
    destination[4] |= (source[14] & 0x1fffff) << 5;
    destination[4] |= (source[15] & 0x1fffff) >> 16;
    destination[5]  = (source[15] & 0x1fffff) << 48;
    destination[5] |= (source[16] & 0x1fffff) << 27;
    destination[5] |= (source[17] & 0x1fffff) << 6;
    destination[5] |= (source[18] & 0x1fffff) >> 15;
    destination[6]  = (source[18] & 0x1fffff) << 49;
    destination[6] |= (source[19] & 0x1fffff) << 28;
    destination[6] |= (source[20] & 0x1fffff) << 7;
    destination[6] |= (source[21] & 0x1fffff) >> 14;
    destination[7]  = (source[21] & 0x1fffff) << 50;
    destination[7] |= (source[22] & 0x1fffff) << 29;
    destination[7] |= (source[23] & 0x1fffff) << 8;
    destination[7] |= (source[24] & 0x1fffff) >> 13;
    destination[8]  = (source[24] & 0x1fffff) << 51;
    destination[8] |= (source[25] & 0x1fffff) << 30;
    destination[8] |= (source[26] & 0x1fffff) << 9;
    destination[8] |= (source[27] & 0x1fffff) >> 12;
    destination[9]  = (source[27] & 0x1fffff) << 52;
    destination[9] |= (source[28] & 0x1fffff) << 31;
    destination[9] |= (source[29] & 0x1fffff) << 10;
    destination[9] |= (source[30] & 0x1fffff) >> 11;
    destination[10]  = (source[30] & 0x1fffff) << 53;
    destination[10] |= (source[31] & 0x1fffff) << 32;
    destination[10] |= (source[32] & 0x1fffff) << 11;
    destination[10] |= (source[33] & 0x1fffff) >> 10;
    destination[11]  = (source[33] & 0x1fffff) << 54;
    destination[11] |= (source[34] & 0x1fffff) << 33;
    destination[11] |= (source[35] & 0x1fffff) << 12;
    destination[11] |= (source[36] & 0x1fffff) >> 9;
    destination[12]  = (source[36] & 0x1fffff) << 55;
    destination[12] |= (source[37] & 0x1fffff) << 34;
    destination[12] |= (source[38] & 0x1fffff) << 13;
    destination[12] |= (source[39] & 0x1fffff) >> 8;
    destination[13]  = (source[39] & 0x1fffff) << 56;
    destination[13] |= (source[40] & 0x1fffff) << 35;
    destination[13] |= (source[41] & 0x1fffff) << 14;
    destination[13] |= (source[42] & 0x1fffff) >> 7;
    destination[14]  = (source[42] & 0x1fffff) << 57;
    destination[14] |= (source[43] & 0x1fffff) << 36;
    destination[14] |= (source[44] & 0x1fffff) << 15;
    destination[14] |= (source[45] & 0x1fffff) >> 6;
    destination[15]  = (source[45] & 0x1fffff) << 58;
    destination[15] |= (source[46] & 0x1fffff) << 37;
    destination[15] |= (source[47] & 0x1fffff) << 16;
    destination[15] |= (source[48] & 0x1fffff) >> 5;
    destination[16]  = (source[48] & 0x1fffff) << 59;
    destination[16] |= (source[49] & 0x1fffff) << 38;
    destination[16] |= (source[50] & 0x1fffff) << 17;
    destination[16] |= (source[51] & 0x1fffff) >> 4;
    destination[17]  = (source[51] & 0x1fffff) << 60;
    destination[17] |= (source[52] & 0x1fffff) << 39;
    destination[17] |= (source[53] & 0x1fffff) << 18;
    destination[17] |= (source[54] & 0x1fffff) >> 3;
    destination[18]  = (source[54] & 0x1fffff) << 61;
    destination[18] |= (source[55] & 0x1fffff) << 40;
    destination[18] |= (source[56] & 0x1fffff) << 19;
    destination[18] |= (source[57] & 0x1fffff) >> 2;
    destination[19]  = (source[57] & 0x1fffff) << 62;
    destination[19] |= (source[58] & 0x1fffff) << 41;
    destination[19] |= (source[59] & 0x1fffff) << 20;
    destination[19] |= (source[60] & 0x1fffff) >> 1;
    destination[20]  = (source[60] & 0x1fffff) << 63;
    destination[20] |= (source[61] & 0x1fffff) << 42;
    destination[20] |= (source[62] & 0x1fffff) << 21;
    destination[20] |= (source[63] & 0x1fffff) << 0;
  }
  static inline
  void unpack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] >> 43) & 0x1fffff;
    destination[1]  = (source[0] >> 22) & 0x1fffff;
    destination[2]  = (source[0] >> 1) & 0x1fffff;
    destination[3]  = (source[0] << 20) & 0x1fffff;
    destination[3] |= (source[1] >> 44) & 0x1fffff;
    destination[4]  = (source[1] >> 23) & 0x1fffff;
    destination[5]  = (source[1] >> 2) & 0x1fffff;
    destination[6]  = (source[1] << 19) & 0x1fffff;
    destination[6] |= (source[2] >> 45) & 0x1fffff;
    destination[7]  = (source[2] >> 24) & 0x1fffff;
    destination[8]  = (source[2] >> 3) & 0x1fffff;
    destination[9]  = (source[2] << 18) & 0x1fffff;
    destination[9] |= (source[3] >> 46) & 0x1fffff;
    destination[10]  = (source[3] >> 25) & 0x1fffff;
    destination[11]  = (source[3] >> 4) & 0x1fffff;
    destination[12]  = (source[3] << 17) & 0x1fffff;
    destination[12] |= (source[4] >> 47) & 0x1fffff;
    destination[13]  = (source[4] >> 26) & 0x1fffff;
    destination[14]  = (source[4] >> 5) & 0x1fffff;
    destination[15]  = (source[4] << 16) & 0x1fffff;
    destination[15] |= (source[5] >> 48) & 0x1fffff;
    destination[16]  = (source[5] >> 27) & 0x1fffff;
    destination[17]  = (source[5] >> 6) & 0x1fffff;
    destination[18]  = (source[5] << 15) & 0x1fffff;
    destination[18] |= (source[6] >> 49) & 0x1fffff;
    destination[19]  = (source[6] >> 28) & 0x1fffff;
    destination[20]  = (source[6] >> 7) & 0x1fffff;
    destination[21]  = (source[6] << 14) & 0x1fffff;
    destination[21] |= (source[7] >> 50) & 0x1fffff;
    destination[22]  = (source[7] >> 29) & 0x1fffff;
    destination[23]  = (source[7] >> 8) & 0x1fffff;
    destination[24]  = (source[7] << 13) & 0x1fffff;
    destination[24] |= (source[8] >> 51) & 0x1fffff;
    destination[25]  = (source[8] >> 30) & 0x1fffff;
    destination[26]  = (source[8] >> 9) & 0x1fffff;
    destination[27]  = (source[8] << 12) & 0x1fffff;
    destination[27] |= (source[9] >> 52) & 0x1fffff;
    destination[28]  = (source[9] >> 31) & 0x1fffff;
    destination[29]  = (source[9] >> 10) & 0x1fffff;
    destination[30]  = (source[9] << 11) & 0x1fffff;
    destination[30] |= (source[10] >> 53) & 0x1fffff;
    destination[31]  = (source[10] >> 32) & 0x1fffff;
    destination[32]  = (source[10] >> 11) & 0x1fffff;
    destination[33]  = (source[10] << 10) & 0x1fffff;
    destination[33] |= (source[11] >> 54) & 0x1fffff;
    destination[34]  = (source[11] >> 33) & 0x1fffff;
    destination[35]  = (source[11] >> 12) & 0x1fffff;
    destination[36]  = (source[11] << 9) & 0x1fffff;
    destination[36] |= (source[12] >> 55) & 0x1fffff;
    destination[37]  = (source[12] >> 34) & 0x1fffff;
    destination[38]  = (source[12] >> 13) & 0x1fffff;
    destination[39]  = (source[12] << 8) & 0x1fffff;
    destination[39] |= (source[13] >> 56) & 0x1fffff;
    destination[40]  = (source[13] >> 35) & 0x1fffff;
    destination[41]  = (source[13] >> 14) & 0x1fffff;
    destination[42]  = (source[13] << 7) & 0x1fffff;
    destination[42] |= (source[14] >> 57) & 0x1fffff;
    destination[43]  = (source[14] >> 36) & 0x1fffff;
    destination[44]  = (source[14] >> 15) & 0x1fffff;
    destination[45]  = (source[14] << 6) & 0x1fffff;
    destination[45] |= (source[15] >> 58) & 0x1fffff;
    destination[46]  = (source[15] >> 37) & 0x1fffff;
    destination[47]  = (source[15] >> 16) & 0x1fffff;
    destination[48]  = (source[15] << 5) & 0x1fffff;
    destination[48] |= (source[16] >> 59) & 0x1fffff;
    destination[49]  = (source[16] >> 38) & 0x1fffff;
    destination[50]  = (source[16] >> 17) & 0x1fffff;
    destination[51]  = (source[16] << 4) & 0x1fffff;
    destination[51] |= (source[17] >> 60) & 0x1fffff;
    destination[52]  = (source[17] >> 39) & 0x1fffff;
    destination[53]  = (source[17] >> 18) & 0x1fffff;
    destination[54]  = (source[17] << 3) & 0x1fffff;
    destination[54] |= (source[18] >> 61) & 0x1fffff;
    destination[55]  = (source[18] >> 40) & 0x1fffff;
    destination[56]  = (source[18] >> 19) & 0x1fffff;
    destination[57]  = (source[18] << 2) & 0x1fffff;
    destination[57] |= (source[19] >> 62) & 0x1fffff;
    destination[58]  = (source[19] >> 41) & 0x1fffff;
    destination[59]  = (source[19] >> 20) & 0x1fffff;
    destination[60]  = (source[19] << 1) & 0x1fffff;
    destination[60] |= (source[20] >> 63) & 0x1fffff;
    destination[61]  = (source[20] >> 42) & 0x1fffff;
    destination[62]  = (source[20] >> 21) & 0x1fffff;
    destination[63]  = (source[20] >> 0) & 0x1fffff;
  }
};
template <typename Tp>
struct __struct_bitpack_impl<Tp,8,22>
{
  static const size_t unit_size = 64;
  static const size_t bits_total = 1408;
  static const size_t loop_total = 64;
  static const size_t bit_size = 22;
  static const Tp     mask = 0x3fffff;
  static inline
  void pack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] & 0x3fffff) << 42;
    destination[0] |= (source[1] & 0x3fffff) << 20;
    destination[0] |= (source[2] & 0x3fffff) >> 2;
    destination[1]  = (source[2] & 0x3fffff) << 62;
    destination[1] |= (source[3] & 0x3fffff) << 40;
    destination[1] |= (source[4] & 0x3fffff) << 18;
    destination[1] |= (source[5] & 0x3fffff) >> 4;
    destination[2]  = (source[5] & 0x3fffff) << 60;
    destination[2] |= (source[6] & 0x3fffff) << 38;
    destination[2] |= (source[7] & 0x3fffff) << 16;
    destination[2] |= (source[8] & 0x3fffff) >> 6;
    destination[3]  = (source[8] & 0x3fffff) << 58;
    destination[3] |= (source[9] & 0x3fffff) << 36;
    destination[3] |= (source[10] & 0x3fffff) << 14;
    destination[3] |= (source[11] & 0x3fffff) >> 8;
    destination[4]  = (source[11] & 0x3fffff) << 56;
    destination[4] |= (source[12] & 0x3fffff) << 34;
    destination[4] |= (source[13] & 0x3fffff) << 12;
    destination[4] |= (source[14] & 0x3fffff) >> 10;
    destination[5]  = (source[14] & 0x3fffff) << 54;
    destination[5] |= (source[15] & 0x3fffff) << 32;
    destination[5] |= (source[16] & 0x3fffff) << 10;
    destination[5] |= (source[17] & 0x3fffff) >> 12;
    destination[6]  = (source[17] & 0x3fffff) << 52;
    destination[6] |= (source[18] & 0x3fffff) << 30;
    destination[6] |= (source[19] & 0x3fffff) << 8;
    destination[6] |= (source[20] & 0x3fffff) >> 14;
    destination[7]  = (source[20] & 0x3fffff) << 50;
    destination[7] |= (source[21] & 0x3fffff) << 28;
    destination[7] |= (source[22] & 0x3fffff) << 6;
    destination[7] |= (source[23] & 0x3fffff) >> 16;
    destination[8]  = (source[23] & 0x3fffff) << 48;
    destination[8] |= (source[24] & 0x3fffff) << 26;
    destination[8] |= (source[25] & 0x3fffff) << 4;
    destination[8] |= (source[26] & 0x3fffff) >> 18;
    destination[9]  = (source[26] & 0x3fffff) << 46;
    destination[9] |= (source[27] & 0x3fffff) << 24;
    destination[9] |= (source[28] & 0x3fffff) << 2;
    destination[9] |= (source[29] & 0x3fffff) >> 20;
    destination[10]  = (source[29] & 0x3fffff) << 44;
    destination[10] |= (source[30] & 0x3fffff) << 22;
    destination[10] |= (source[31] & 0x3fffff) << 0;
    destination[11]  = (source[32] & 0x3fffff) << 42;
    destination[11] |= (source[33] & 0x3fffff) << 20;
    destination[11] |= (source[34] & 0x3fffff) >> 2;
    destination[12]  = (source[34] & 0x3fffff) << 62;
    destination[12] |= (source[35] & 0x3fffff) << 40;
    destination[12] |= (source[36] & 0x3fffff) << 18;
    destination[12] |= (source[37] & 0x3fffff) >> 4;
    destination[13]  = (source[37] & 0x3fffff) << 60;
    destination[13] |= (source[38] & 0x3fffff) << 38;
    destination[13] |= (source[39] & 0x3fffff) << 16;
    destination[13] |= (source[40] & 0x3fffff) >> 6;
    destination[14]  = (source[40] & 0x3fffff) << 58;
    destination[14] |= (source[41] & 0x3fffff) << 36;
    destination[14] |= (source[42] & 0x3fffff) << 14;
    destination[14] |= (source[43] & 0x3fffff) >> 8;
    destination[15]  = (source[43] & 0x3fffff) << 56;
    destination[15] |= (source[44] & 0x3fffff) << 34;
    destination[15] |= (source[45] & 0x3fffff) << 12;
    destination[15] |= (source[46] & 0x3fffff) >> 10;
    destination[16]  = (source[46] & 0x3fffff) << 54;
    destination[16] |= (source[47] & 0x3fffff) << 32;
    destination[16] |= (source[48] & 0x3fffff) << 10;
    destination[16] |= (source[49] & 0x3fffff) >> 12;
    destination[17]  = (source[49] & 0x3fffff) << 52;
    destination[17] |= (source[50] & 0x3fffff) << 30;
    destination[17] |= (source[51] & 0x3fffff) << 8;
    destination[17] |= (source[52] & 0x3fffff) >> 14;
    destination[18]  = (source[52] & 0x3fffff) << 50;
    destination[18] |= (source[53] & 0x3fffff) << 28;
    destination[18] |= (source[54] & 0x3fffff) << 6;
    destination[18] |= (source[55] & 0x3fffff) >> 16;
    destination[19]  = (source[55] & 0x3fffff) << 48;
    destination[19] |= (source[56] & 0x3fffff) << 26;
    destination[19] |= (source[57] & 0x3fffff) << 4;
    destination[19] |= (source[58] & 0x3fffff) >> 18;
    destination[20]  = (source[58] & 0x3fffff) << 46;
    destination[20] |= (source[59] & 0x3fffff) << 24;
    destination[20] |= (source[60] & 0x3fffff) << 2;
    destination[20] |= (source[61] & 0x3fffff) >> 20;
    destination[21]  = (source[61] & 0x3fffff) << 44;
    destination[21] |= (source[62] & 0x3fffff) << 22;
    destination[21] |= (source[63] & 0x3fffff) << 0;
  }
  static inline
  void unpack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] >> 42) & 0x3fffff;
    destination[1]  = (source[0] >> 20) & 0x3fffff;
    destination[2]  = (source[0] << 2) & 0x3fffff;
    destination[2] |= (source[1] >> 62) & 0x3fffff;
    destination[3]  = (source[1] >> 40) & 0x3fffff;
    destination[4]  = (source[1] >> 18) & 0x3fffff;
    destination[5]  = (source[1] << 4) & 0x3fffff;
    destination[5] |= (source[2] >> 60) & 0x3fffff;
    destination[6]  = (source[2] >> 38) & 0x3fffff;
    destination[7]  = (source[2] >> 16) & 0x3fffff;
    destination[8]  = (source[2] << 6) & 0x3fffff;
    destination[8] |= (source[3] >> 58) & 0x3fffff;
    destination[9]  = (source[3] >> 36) & 0x3fffff;
    destination[10]  = (source[3] >> 14) & 0x3fffff;
    destination[11]  = (source[3] << 8) & 0x3fffff;
    destination[11] |= (source[4] >> 56) & 0x3fffff;
    destination[12]  = (source[4] >> 34) & 0x3fffff;
    destination[13]  = (source[4] >> 12) & 0x3fffff;
    destination[14]  = (source[4] << 10) & 0x3fffff;
    destination[14] |= (source[5] >> 54) & 0x3fffff;
    destination[15]  = (source[5] >> 32) & 0x3fffff;
    destination[16]  = (source[5] >> 10) & 0x3fffff;
    destination[17]  = (source[5] << 12) & 0x3fffff;
    destination[17] |= (source[6] >> 52) & 0x3fffff;
    destination[18]  = (source[6] >> 30) & 0x3fffff;
    destination[19]  = (source[6] >> 8) & 0x3fffff;
    destination[20]  = (source[6] << 14) & 0x3fffff;
    destination[20] |= (source[7] >> 50) & 0x3fffff;
    destination[21]  = (source[7] >> 28) & 0x3fffff;
    destination[22]  = (source[7] >> 6) & 0x3fffff;
    destination[23]  = (source[7] << 16) & 0x3fffff;
    destination[23] |= (source[8] >> 48) & 0x3fffff;
    destination[24]  = (source[8] >> 26) & 0x3fffff;
    destination[25]  = (source[8] >> 4) & 0x3fffff;
    destination[26]  = (source[8] << 18) & 0x3fffff;
    destination[26] |= (source[9] >> 46) & 0x3fffff;
    destination[27]  = (source[9] >> 24) & 0x3fffff;
    destination[28]  = (source[9] >> 2) & 0x3fffff;
    destination[29]  = (source[9] << 20) & 0x3fffff;
    destination[29] |= (source[10] >> 44) & 0x3fffff;
    destination[30]  = (source[10] >> 22) & 0x3fffff;
    destination[31]  = (source[10] >> 0) & 0x3fffff;
    destination[32]  = (source[11] >> 42) & 0x3fffff;
    destination[33]  = (source[11] >> 20) & 0x3fffff;
    destination[34]  = (source[11] << 2) & 0x3fffff;
    destination[34] |= (source[12] >> 62) & 0x3fffff;
    destination[35]  = (source[12] >> 40) & 0x3fffff;
    destination[36]  = (source[12] >> 18) & 0x3fffff;
    destination[37]  = (source[12] << 4) & 0x3fffff;
    destination[37] |= (source[13] >> 60) & 0x3fffff;
    destination[38]  = (source[13] >> 38) & 0x3fffff;
    destination[39]  = (source[13] >> 16) & 0x3fffff;
    destination[40]  = (source[13] << 6) & 0x3fffff;
    destination[40] |= (source[14] >> 58) & 0x3fffff;
    destination[41]  = (source[14] >> 36) & 0x3fffff;
    destination[42]  = (source[14] >> 14) & 0x3fffff;
    destination[43]  = (source[14] << 8) & 0x3fffff;
    destination[43] |= (source[15] >> 56) & 0x3fffff;
    destination[44]  = (source[15] >> 34) & 0x3fffff;
    destination[45]  = (source[15] >> 12) & 0x3fffff;
    destination[46]  = (source[15] << 10) & 0x3fffff;
    destination[46] |= (source[16] >> 54) & 0x3fffff;
    destination[47]  = (source[16] >> 32) & 0x3fffff;
    destination[48]  = (source[16] >> 10) & 0x3fffff;
    destination[49]  = (source[16] << 12) & 0x3fffff;
    destination[49] |= (source[17] >> 52) & 0x3fffff;
    destination[50]  = (source[17] >> 30) & 0x3fffff;
    destination[51]  = (source[17] >> 8) & 0x3fffff;
    destination[52]  = (source[17] << 14) & 0x3fffff;
    destination[52] |= (source[18] >> 50) & 0x3fffff;
    destination[53]  = (source[18] >> 28) & 0x3fffff;
    destination[54]  = (source[18] >> 6) & 0x3fffff;
    destination[55]  = (source[18] << 16) & 0x3fffff;
    destination[55] |= (source[19] >> 48) & 0x3fffff;
    destination[56]  = (source[19] >> 26) & 0x3fffff;
    destination[57]  = (source[19] >> 4) & 0x3fffff;
    destination[58]  = (source[19] << 18) & 0x3fffff;
    destination[58] |= (source[20] >> 46) & 0x3fffff;
    destination[59]  = (source[20] >> 24) & 0x3fffff;
    destination[60]  = (source[20] >> 2) & 0x3fffff;
    destination[61]  = (source[20] << 20) & 0x3fffff;
    destination[61] |= (source[21] >> 44) & 0x3fffff;
    destination[62]  = (source[21] >> 22) & 0x3fffff;
    destination[63]  = (source[21] >> 0) & 0x3fffff;
  }
};
template <typename Tp>
struct __struct_bitpack_impl<Tp,8,23>
{
  static const size_t unit_size = 64;
  static const size_t bits_total = 1472;
  static const size_t loop_total = 64;
  static const size_t bit_size = 23;
  static const Tp     mask = 0x7fffff;
  static inline
  void pack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] & 0x7fffff) << 41;
    destination[0] |= (source[1] & 0x7fffff) << 18;
    destination[0] |= (source[2] & 0x7fffff) >> 5;
    destination[1]  = (source[2] & 0x7fffff) << 59;
    destination[1] |= (source[3] & 0x7fffff) << 36;
    destination[1] |= (source[4] & 0x7fffff) << 13;
    destination[1] |= (source[5] & 0x7fffff) >> 10;
    destination[2]  = (source[5] & 0x7fffff) << 54;
    destination[2] |= (source[6] & 0x7fffff) << 31;
    destination[2] |= (source[7] & 0x7fffff) << 8;
    destination[2] |= (source[8] & 0x7fffff) >> 15;
    destination[3]  = (source[8] & 0x7fffff) << 49;
    destination[3] |= (source[9] & 0x7fffff) << 26;
    destination[3] |= (source[10] & 0x7fffff) << 3;
    destination[3] |= (source[11] & 0x7fffff) >> 20;
    destination[4]  = (source[11] & 0x7fffff) << 44;
    destination[4] |= (source[12] & 0x7fffff) << 21;
    destination[4] |= (source[13] & 0x7fffff) >> 2;
    destination[5]  = (source[13] & 0x7fffff) << 62;
    destination[5] |= (source[14] & 0x7fffff) << 39;
    destination[5] |= (source[15] & 0x7fffff) << 16;
    destination[5] |= (source[16] & 0x7fffff) >> 7;
    destination[6]  = (source[16] & 0x7fffff) << 57;
    destination[6] |= (source[17] & 0x7fffff) << 34;
    destination[6] |= (source[18] & 0x7fffff) << 11;
    destination[6] |= (source[19] & 0x7fffff) >> 12;
    destination[7]  = (source[19] & 0x7fffff) << 52;
    destination[7] |= (source[20] & 0x7fffff) << 29;
    destination[7] |= (source[21] & 0x7fffff) << 6;
    destination[7] |= (source[22] & 0x7fffff) >> 17;
    destination[8]  = (source[22] & 0x7fffff) << 47;
    destination[8] |= (source[23] & 0x7fffff) << 24;
    destination[8] |= (source[24] & 0x7fffff) << 1;
    destination[8] |= (source[25] & 0x7fffff) >> 22;
    destination[9]  = (source[25] & 0x7fffff) << 42;
    destination[9] |= (source[26] & 0x7fffff) << 19;
    destination[9] |= (source[27] & 0x7fffff) >> 4;
    destination[10]  = (source[27] & 0x7fffff) << 60;
    destination[10] |= (source[28] & 0x7fffff) << 37;
    destination[10] |= (source[29] & 0x7fffff) << 14;
    destination[10] |= (source[30] & 0x7fffff) >> 9;
    destination[11]  = (source[30] & 0x7fffff) << 55;
    destination[11] |= (source[31] & 0x7fffff) << 32;
    destination[11] |= (source[32] & 0x7fffff) << 9;
    destination[11] |= (source[33] & 0x7fffff) >> 14;
    destination[12]  = (source[33] & 0x7fffff) << 50;
    destination[12] |= (source[34] & 0x7fffff) << 27;
    destination[12] |= (source[35] & 0x7fffff) << 4;
    destination[12] |= (source[36] & 0x7fffff) >> 19;
    destination[13]  = (source[36] & 0x7fffff) << 45;
    destination[13] |= (source[37] & 0x7fffff) << 22;
    destination[13] |= (source[38] & 0x7fffff) >> 1;
    destination[14]  = (source[38] & 0x7fffff) << 63;
    destination[14] |= (source[39] & 0x7fffff) << 40;
    destination[14] |= (source[40] & 0x7fffff) << 17;
    destination[14] |= (source[41] & 0x7fffff) >> 6;
    destination[15]  = (source[41] & 0x7fffff) << 58;
    destination[15] |= (source[42] & 0x7fffff) << 35;
    destination[15] |= (source[43] & 0x7fffff) << 12;
    destination[15] |= (source[44] & 0x7fffff) >> 11;
    destination[16]  = (source[44] & 0x7fffff) << 53;
    destination[16] |= (source[45] & 0x7fffff) << 30;
    destination[16] |= (source[46] & 0x7fffff) << 7;
    destination[16] |= (source[47] & 0x7fffff) >> 16;
    destination[17]  = (source[47] & 0x7fffff) << 48;
    destination[17] |= (source[48] & 0x7fffff) << 25;
    destination[17] |= (source[49] & 0x7fffff) << 2;
    destination[17] |= (source[50] & 0x7fffff) >> 21;
    destination[18]  = (source[50] & 0x7fffff) << 43;
    destination[18] |= (source[51] & 0x7fffff) << 20;
    destination[18] |= (source[52] & 0x7fffff) >> 3;
    destination[19]  = (source[52] & 0x7fffff) << 61;
    destination[19] |= (source[53] & 0x7fffff) << 38;
    destination[19] |= (source[54] & 0x7fffff) << 15;
    destination[19] |= (source[55] & 0x7fffff) >> 8;
    destination[20]  = (source[55] & 0x7fffff) << 56;
    destination[20] |= (source[56] & 0x7fffff) << 33;
    destination[20] |= (source[57] & 0x7fffff) << 10;
    destination[20] |= (source[58] & 0x7fffff) >> 13;
    destination[21]  = (source[58] & 0x7fffff) << 51;
    destination[21] |= (source[59] & 0x7fffff) << 28;
    destination[21] |= (source[60] & 0x7fffff) << 5;
    destination[21] |= (source[61] & 0x7fffff) >> 18;
    destination[22]  = (source[61] & 0x7fffff) << 46;
    destination[22] |= (source[62] & 0x7fffff) << 23;
    destination[22] |= (source[63] & 0x7fffff) << 0;
  }
  static inline
  void unpack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] >> 41) & 0x7fffff;
    destination[1]  = (source[0] >> 18) & 0x7fffff;
    destination[2]  = (source[0] << 5) & 0x7fffff;
    destination[2] |= (source[1] >> 59) & 0x7fffff;
    destination[3]  = (source[1] >> 36) & 0x7fffff;
    destination[4]  = (source[1] >> 13) & 0x7fffff;
    destination[5]  = (source[1] << 10) & 0x7fffff;
    destination[5] |= (source[2] >> 54) & 0x7fffff;
    destination[6]  = (source[2] >> 31) & 0x7fffff;
    destination[7]  = (source[2] >> 8) & 0x7fffff;
    destination[8]  = (source[2] << 15) & 0x7fffff;
    destination[8] |= (source[3] >> 49) & 0x7fffff;
    destination[9]  = (source[3] >> 26) & 0x7fffff;
    destination[10]  = (source[3] >> 3) & 0x7fffff;
    destination[11]  = (source[3] << 20) & 0x7fffff;
    destination[11] |= (source[4] >> 44) & 0x7fffff;
    destination[12]  = (source[4] >> 21) & 0x7fffff;
    destination[13]  = (source[4] << 2) & 0x7fffff;
    destination[13] |= (source[5] >> 62) & 0x7fffff;
    destination[14]  = (source[5] >> 39) & 0x7fffff;
    destination[15]  = (source[5] >> 16) & 0x7fffff;
    destination[16]  = (source[5] << 7) & 0x7fffff;
    destination[16] |= (source[6] >> 57) & 0x7fffff;
    destination[17]  = (source[6] >> 34) & 0x7fffff;
    destination[18]  = (source[6] >> 11) & 0x7fffff;
    destination[19]  = (source[6] << 12) & 0x7fffff;
    destination[19] |= (source[7] >> 52) & 0x7fffff;
    destination[20]  = (source[7] >> 29) & 0x7fffff;
    destination[21]  = (source[7] >> 6) & 0x7fffff;
    destination[22]  = (source[7] << 17) & 0x7fffff;
    destination[22] |= (source[8] >> 47) & 0x7fffff;
    destination[23]  = (source[8] >> 24) & 0x7fffff;
    destination[24]  = (source[8] >> 1) & 0x7fffff;
    destination[25]  = (source[8] << 22) & 0x7fffff;
    destination[25] |= (source[9] >> 42) & 0x7fffff;
    destination[26]  = (source[9] >> 19) & 0x7fffff;
    destination[27]  = (source[9] << 4) & 0x7fffff;
    destination[27] |= (source[10] >> 60) & 0x7fffff;
    destination[28]  = (source[10] >> 37) & 0x7fffff;
    destination[29]  = (source[10] >> 14) & 0x7fffff;
    destination[30]  = (source[10] << 9) & 0x7fffff;
    destination[30] |= (source[11] >> 55) & 0x7fffff;
    destination[31]  = (source[11] >> 32) & 0x7fffff;
    destination[32]  = (source[11] >> 9) & 0x7fffff;
    destination[33]  = (source[11] << 14) & 0x7fffff;
    destination[33] |= (source[12] >> 50) & 0x7fffff;
    destination[34]  = (source[12] >> 27) & 0x7fffff;
    destination[35]  = (source[12] >> 4) & 0x7fffff;
    destination[36]  = (source[12] << 19) & 0x7fffff;
    destination[36] |= (source[13] >> 45) & 0x7fffff;
    destination[37]  = (source[13] >> 22) & 0x7fffff;
    destination[38]  = (source[13] << 1) & 0x7fffff;
    destination[38] |= (source[14] >> 63) & 0x7fffff;
    destination[39]  = (source[14] >> 40) & 0x7fffff;
    destination[40]  = (source[14] >> 17) & 0x7fffff;
    destination[41]  = (source[14] << 6) & 0x7fffff;
    destination[41] |= (source[15] >> 58) & 0x7fffff;
    destination[42]  = (source[15] >> 35) & 0x7fffff;
    destination[43]  = (source[15] >> 12) & 0x7fffff;
    destination[44]  = (source[15] << 11) & 0x7fffff;
    destination[44] |= (source[16] >> 53) & 0x7fffff;
    destination[45]  = (source[16] >> 30) & 0x7fffff;
    destination[46]  = (source[16] >> 7) & 0x7fffff;
    destination[47]  = (source[16] << 16) & 0x7fffff;
    destination[47] |= (source[17] >> 48) & 0x7fffff;
    destination[48]  = (source[17] >> 25) & 0x7fffff;
    destination[49]  = (source[17] >> 2) & 0x7fffff;
    destination[50]  = (source[17] << 21) & 0x7fffff;
    destination[50] |= (source[18] >> 43) & 0x7fffff;
    destination[51]  = (source[18] >> 20) & 0x7fffff;
    destination[52]  = (source[18] << 3) & 0x7fffff;
    destination[52] |= (source[19] >> 61) & 0x7fffff;
    destination[53]  = (source[19] >> 38) & 0x7fffff;
    destination[54]  = (source[19] >> 15) & 0x7fffff;
    destination[55]  = (source[19] << 8) & 0x7fffff;
    destination[55] |= (source[20] >> 56) & 0x7fffff;
    destination[56]  = (source[20] >> 33) & 0x7fffff;
    destination[57]  = (source[20] >> 10) & 0x7fffff;
    destination[58]  = (source[20] << 13) & 0x7fffff;
    destination[58] |= (source[21] >> 51) & 0x7fffff;
    destination[59]  = (source[21] >> 28) & 0x7fffff;
    destination[60]  = (source[21] >> 5) & 0x7fffff;
    destination[61]  = (source[21] << 18) & 0x7fffff;
    destination[61] |= (source[22] >> 46) & 0x7fffff;
    destination[62]  = (source[22] >> 23) & 0x7fffff;
    destination[63]  = (source[22] >> 0) & 0x7fffff;
  }
};
template <typename Tp>
struct __struct_bitpack_impl<Tp,8,24>
{
  static const size_t unit_size = 64;
  static const size_t bits_total = 1536;
  static const size_t loop_total = 64;
  static const size_t bit_size = 24;
  static const Tp     mask = 0xffffff;
  static inline
  void pack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] & 0xffffff) << 40;
    destination[0] |= (source[1] & 0xffffff) << 16;
    destination[0] |= (source[2] & 0xffffff) >> 8;
    destination[1]  = (source[2] & 0xffffff) << 56;
    destination[1] |= (source[3] & 0xffffff) << 32;
    destination[1] |= (source[4] & 0xffffff) << 8;
    destination[1] |= (source[5] & 0xffffff) >> 16;
    destination[2]  = (source[5] & 0xffffff) << 48;
    destination[2] |= (source[6] & 0xffffff) << 24;
    destination[2] |= (source[7] & 0xffffff) << 0;
    destination[3]  = (source[8] & 0xffffff) << 40;
    destination[3] |= (source[9] & 0xffffff) << 16;
    destination[3] |= (source[10] & 0xffffff) >> 8;
    destination[4]  = (source[10] & 0xffffff) << 56;
    destination[4] |= (source[11] & 0xffffff) << 32;
    destination[4] |= (source[12] & 0xffffff) << 8;
    destination[4] |= (source[13] & 0xffffff) >> 16;
    destination[5]  = (source[13] & 0xffffff) << 48;
    destination[5] |= (source[14] & 0xffffff) << 24;
    destination[5] |= (source[15] & 0xffffff) << 0;
    destination[6]  = (source[16] & 0xffffff) << 40;
    destination[6] |= (source[17] & 0xffffff) << 16;
    destination[6] |= (source[18] & 0xffffff) >> 8;
    destination[7]  = (source[18] & 0xffffff) << 56;
    destination[7] |= (source[19] & 0xffffff) << 32;
    destination[7] |= (source[20] & 0xffffff) << 8;
    destination[7] |= (source[21] & 0xffffff) >> 16;
    destination[8]  = (source[21] & 0xffffff) << 48;
    destination[8] |= (source[22] & 0xffffff) << 24;
    destination[8] |= (source[23] & 0xffffff) << 0;
    destination[9]  = (source[24] & 0xffffff) << 40;
    destination[9] |= (source[25] & 0xffffff) << 16;
    destination[9] |= (source[26] & 0xffffff) >> 8;
    destination[10]  = (source[26] & 0xffffff) << 56;
    destination[10] |= (source[27] & 0xffffff) << 32;
    destination[10] |= (source[28] & 0xffffff) << 8;
    destination[10] |= (source[29] & 0xffffff) >> 16;
    destination[11]  = (source[29] & 0xffffff) << 48;
    destination[11] |= (source[30] & 0xffffff) << 24;
    destination[11] |= (source[31] & 0xffffff) << 0;
    destination[12]  = (source[32] & 0xffffff) << 40;
    destination[12] |= (source[33] & 0xffffff) << 16;
    destination[12] |= (source[34] & 0xffffff) >> 8;
    destination[13]  = (source[34] & 0xffffff) << 56;
    destination[13] |= (source[35] & 0xffffff) << 32;
    destination[13] |= (source[36] & 0xffffff) << 8;
    destination[13] |= (source[37] & 0xffffff) >> 16;
    destination[14]  = (source[37] & 0xffffff) << 48;
    destination[14] |= (source[38] & 0xffffff) << 24;
    destination[14] |= (source[39] & 0xffffff) << 0;
    destination[15]  = (source[40] & 0xffffff) << 40;
    destination[15] |= (source[41] & 0xffffff) << 16;
    destination[15] |= (source[42] & 0xffffff) >> 8;
    destination[16]  = (source[42] & 0xffffff) << 56;
    destination[16] |= (source[43] & 0xffffff) << 32;
    destination[16] |= (source[44] & 0xffffff) << 8;
    destination[16] |= (source[45] & 0xffffff) >> 16;
    destination[17]  = (source[45] & 0xffffff) << 48;
    destination[17] |= (source[46] & 0xffffff) << 24;
    destination[17] |= (source[47] & 0xffffff) << 0;
    destination[18]  = (source[48] & 0xffffff) << 40;
    destination[18] |= (source[49] & 0xffffff) << 16;
    destination[18] |= (source[50] & 0xffffff) >> 8;
    destination[19]  = (source[50] & 0xffffff) << 56;
    destination[19] |= (source[51] & 0xffffff) << 32;
    destination[19] |= (source[52] & 0xffffff) << 8;
    destination[19] |= (source[53] & 0xffffff) >> 16;
    destination[20]  = (source[53] & 0xffffff) << 48;
    destination[20] |= (source[54] & 0xffffff) << 24;
    destination[20] |= (source[55] & 0xffffff) << 0;
    destination[21]  = (source[56] & 0xffffff) << 40;
    destination[21] |= (source[57] & 0xffffff) << 16;
    destination[21] |= (source[58] & 0xffffff) >> 8;
    destination[22]  = (source[58] & 0xffffff) << 56;
    destination[22] |= (source[59] & 0xffffff) << 32;
    destination[22] |= (source[60] & 0xffffff) << 8;
    destination[22] |= (source[61] & 0xffffff) >> 16;
    destination[23]  = (source[61] & 0xffffff) << 48;
    destination[23] |= (source[62] & 0xffffff) << 24;
    destination[23] |= (source[63] & 0xffffff) << 0;
  }
  static inline
  void unpack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] >> 40) & 0xffffff;
    destination[1]  = (source[0] >> 16) & 0xffffff;
    destination[2]  = (source[0] << 8) & 0xffffff;
    destination[2] |= (source[1] >> 56) & 0xffffff;
    destination[3]  = (source[1] >> 32) & 0xffffff;
    destination[4]  = (source[1] >> 8) & 0xffffff;
    destination[5]  = (source[1] << 16) & 0xffffff;
    destination[5] |= (source[2] >> 48) & 0xffffff;
    destination[6]  = (source[2] >> 24) & 0xffffff;
    destination[7]  = (source[2] >> 0) & 0xffffff;
    destination[8]  = (source[3] >> 40) & 0xffffff;
    destination[9]  = (source[3] >> 16) & 0xffffff;
    destination[10]  = (source[3] << 8) & 0xffffff;
    destination[10] |= (source[4] >> 56) & 0xffffff;
    destination[11]  = (source[4] >> 32) & 0xffffff;
    destination[12]  = (source[4] >> 8) & 0xffffff;
    destination[13]  = (source[4] << 16) & 0xffffff;
    destination[13] |= (source[5] >> 48) & 0xffffff;
    destination[14]  = (source[5] >> 24) & 0xffffff;
    destination[15]  = (source[5] >> 0) & 0xffffff;
    destination[16]  = (source[6] >> 40) & 0xffffff;
    destination[17]  = (source[6] >> 16) & 0xffffff;
    destination[18]  = (source[6] << 8) & 0xffffff;
    destination[18] |= (source[7] >> 56) & 0xffffff;
    destination[19]  = (source[7] >> 32) & 0xffffff;
    destination[20]  = (source[7] >> 8) & 0xffffff;
    destination[21]  = (source[7] << 16) & 0xffffff;
    destination[21] |= (source[8] >> 48) & 0xffffff;
    destination[22]  = (source[8] >> 24) & 0xffffff;
    destination[23]  = (source[8] >> 0) & 0xffffff;
    destination[24]  = (source[9] >> 40) & 0xffffff;
    destination[25]  = (source[9] >> 16) & 0xffffff;
    destination[26]  = (source[9] << 8) & 0xffffff;
    destination[26] |= (source[10] >> 56) & 0xffffff;
    destination[27]  = (source[10] >> 32) & 0xffffff;
    destination[28]  = (source[10] >> 8) & 0xffffff;
    destination[29]  = (source[10] << 16) & 0xffffff;
    destination[29] |= (source[11] >> 48) & 0xffffff;
    destination[30]  = (source[11] >> 24) & 0xffffff;
    destination[31]  = (source[11] >> 0) & 0xffffff;
    destination[32]  = (source[12] >> 40) & 0xffffff;
    destination[33]  = (source[12] >> 16) & 0xffffff;
    destination[34]  = (source[12] << 8) & 0xffffff;
    destination[34] |= (source[13] >> 56) & 0xffffff;
    destination[35]  = (source[13] >> 32) & 0xffffff;
    destination[36]  = (source[13] >> 8) & 0xffffff;
    destination[37]  = (source[13] << 16) & 0xffffff;
    destination[37] |= (source[14] >> 48) & 0xffffff;
    destination[38]  = (source[14] >> 24) & 0xffffff;
    destination[39]  = (source[14] >> 0) & 0xffffff;
    destination[40]  = (source[15] >> 40) & 0xffffff;
    destination[41]  = (source[15] >> 16) & 0xffffff;
    destination[42]  = (source[15] << 8) & 0xffffff;
    destination[42] |= (source[16] >> 56) & 0xffffff;
    destination[43]  = (source[16] >> 32) & 0xffffff;
    destination[44]  = (source[16] >> 8) & 0xffffff;
    destination[45]  = (source[16] << 16) & 0xffffff;
    destination[45] |= (source[17] >> 48) & 0xffffff;
    destination[46]  = (source[17] >> 24) & 0xffffff;
    destination[47]  = (source[17] >> 0) & 0xffffff;
    destination[48]  = (source[18] >> 40) & 0xffffff;
    destination[49]  = (source[18] >> 16) & 0xffffff;
    destination[50]  = (source[18] << 8) & 0xffffff;
    destination[50] |= (source[19] >> 56) & 0xffffff;
    destination[51]  = (source[19] >> 32) & 0xffffff;
    destination[52]  = (source[19] >> 8) & 0xffffff;
    destination[53]  = (source[19] << 16) & 0xffffff;
    destination[53] |= (source[20] >> 48) & 0xffffff;
    destination[54]  = (source[20] >> 24) & 0xffffff;
    destination[55]  = (source[20] >> 0) & 0xffffff;
    destination[56]  = (source[21] >> 40) & 0xffffff;
    destination[57]  = (source[21] >> 16) & 0xffffff;
    destination[58]  = (source[21] << 8) & 0xffffff;
    destination[58] |= (source[22] >> 56) & 0xffffff;
    destination[59]  = (source[22] >> 32) & 0xffffff;
    destination[60]  = (source[22] >> 8) & 0xffffff;
    destination[61]  = (source[22] << 16) & 0xffffff;
    destination[61] |= (source[23] >> 48) & 0xffffff;
    destination[62]  = (source[23] >> 24) & 0xffffff;
    destination[63]  = (source[23] >> 0) & 0xffffff;
  }
};
template <typename Tp>
struct __struct_bitpack_impl<Tp,8,25>
{
  static const size_t unit_size = 64;
  static const size_t bits_total = 1600;
  static const size_t loop_total = 64;
  static const size_t bit_size = 25;
  static const Tp     mask = 0x1ffffff;
  static inline
  void pack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] & 0x1ffffff) << 39;
    destination[0] |= (source[1] & 0x1ffffff) << 14;
    destination[0] |= (source[2] & 0x1ffffff) >> 11;
    destination[1]  = (source[2] & 0x1ffffff) << 53;
    destination[1] |= (source[3] & 0x1ffffff) << 28;
    destination[1] |= (source[4] & 0x1ffffff) << 3;
    destination[1] |= (source[5] & 0x1ffffff) >> 22;
    destination[2]  = (source[5] & 0x1ffffff) << 42;
    destination[2] |= (source[6] & 0x1ffffff) << 17;
    destination[2] |= (source[7] & 0x1ffffff) >> 8;
    destination[3]  = (source[7] & 0x1ffffff) << 56;
    destination[3] |= (source[8] & 0x1ffffff) << 31;
    destination[3] |= (source[9] & 0x1ffffff) << 6;
    destination[3] |= (source[10] & 0x1ffffff) >> 19;
    destination[4]  = (source[10] & 0x1ffffff) << 45;
    destination[4] |= (source[11] & 0x1ffffff) << 20;
    destination[4] |= (source[12] & 0x1ffffff) >> 5;
    destination[5]  = (source[12] & 0x1ffffff) << 59;
    destination[5] |= (source[13] & 0x1ffffff) << 34;
    destination[5] |= (source[14] & 0x1ffffff) << 9;
    destination[5] |= (source[15] & 0x1ffffff) >> 16;
    destination[6]  = (source[15] & 0x1ffffff) << 48;
    destination[6] |= (source[16] & 0x1ffffff) << 23;
    destination[6] |= (source[17] & 0x1ffffff) >> 2;
    destination[7]  = (source[17] & 0x1ffffff) << 62;
    destination[7] |= (source[18] & 0x1ffffff) << 37;
    destination[7] |= (source[19] & 0x1ffffff) << 12;
    destination[7] |= (source[20] & 0x1ffffff) >> 13;
    destination[8]  = (source[20] & 0x1ffffff) << 51;
    destination[8] |= (source[21] & 0x1ffffff) << 26;
    destination[8] |= (source[22] & 0x1ffffff) << 1;
    destination[8] |= (source[23] & 0x1ffffff) >> 24;
    destination[9]  = (source[23] & 0x1ffffff) << 40;
    destination[9] |= (source[24] & 0x1ffffff) << 15;
    destination[9] |= (source[25] & 0x1ffffff) >> 10;
    destination[10]  = (source[25] & 0x1ffffff) << 54;
    destination[10] |= (source[26] & 0x1ffffff) << 29;
    destination[10] |= (source[27] & 0x1ffffff) << 4;
    destination[10] |= (source[28] & 0x1ffffff) >> 21;
    destination[11]  = (source[28] & 0x1ffffff) << 43;
    destination[11] |= (source[29] & 0x1ffffff) << 18;
    destination[11] |= (source[30] & 0x1ffffff) >> 7;
    destination[12]  = (source[30] & 0x1ffffff) << 57;
    destination[12] |= (source[31] & 0x1ffffff) << 32;
    destination[12] |= (source[32] & 0x1ffffff) << 7;
    destination[12] |= (source[33] & 0x1ffffff) >> 18;
    destination[13]  = (source[33] & 0x1ffffff) << 46;
    destination[13] |= (source[34] & 0x1ffffff) << 21;
    destination[13] |= (source[35] & 0x1ffffff) >> 4;
    destination[14]  = (source[35] & 0x1ffffff) << 60;
    destination[14] |= (source[36] & 0x1ffffff) << 35;
    destination[14] |= (source[37] & 0x1ffffff) << 10;
    destination[14] |= (source[38] & 0x1ffffff) >> 15;
    destination[15]  = (source[38] & 0x1ffffff) << 49;
    destination[15] |= (source[39] & 0x1ffffff) << 24;
    destination[15] |= (source[40] & 0x1ffffff) >> 1;
    destination[16]  = (source[40] & 0x1ffffff) << 63;
    destination[16] |= (source[41] & 0x1ffffff) << 38;
    destination[16] |= (source[42] & 0x1ffffff) << 13;
    destination[16] |= (source[43] & 0x1ffffff) >> 12;
    destination[17]  = (source[43] & 0x1ffffff) << 52;
    destination[17] |= (source[44] & 0x1ffffff) << 27;
    destination[17] |= (source[45] & 0x1ffffff) << 2;
    destination[17] |= (source[46] & 0x1ffffff) >> 23;
    destination[18]  = (source[46] & 0x1ffffff) << 41;
    destination[18] |= (source[47] & 0x1ffffff) << 16;
    destination[18] |= (source[48] & 0x1ffffff) >> 9;
    destination[19]  = (source[48] & 0x1ffffff) << 55;
    destination[19] |= (source[49] & 0x1ffffff) << 30;
    destination[19] |= (source[50] & 0x1ffffff) << 5;
    destination[19] |= (source[51] & 0x1ffffff) >> 20;
    destination[20]  = (source[51] & 0x1ffffff) << 44;
    destination[20] |= (source[52] & 0x1ffffff) << 19;
    destination[20] |= (source[53] & 0x1ffffff) >> 6;
    destination[21]  = (source[53] & 0x1ffffff) << 58;
    destination[21] |= (source[54] & 0x1ffffff) << 33;
    destination[21] |= (source[55] & 0x1ffffff) << 8;
    destination[21] |= (source[56] & 0x1ffffff) >> 17;
    destination[22]  = (source[56] & 0x1ffffff) << 47;
    destination[22] |= (source[57] & 0x1ffffff) << 22;
    destination[22] |= (source[58] & 0x1ffffff) >> 3;
    destination[23]  = (source[58] & 0x1ffffff) << 61;
    destination[23] |= (source[59] & 0x1ffffff) << 36;
    destination[23] |= (source[60] & 0x1ffffff) << 11;
    destination[23] |= (source[61] & 0x1ffffff) >> 14;
    destination[24]  = (source[61] & 0x1ffffff) << 50;
    destination[24] |= (source[62] & 0x1ffffff) << 25;
    destination[24] |= (source[63] & 0x1ffffff) << 0;
  }
  static inline
  void unpack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] >> 39) & 0x1ffffff;
    destination[1]  = (source[0] >> 14) & 0x1ffffff;
    destination[2]  = (source[0] << 11) & 0x1ffffff;
    destination[2] |= (source[1] >> 53) & 0x1ffffff;
    destination[3]  = (source[1] >> 28) & 0x1ffffff;
    destination[4]  = (source[1] >> 3) & 0x1ffffff;
    destination[5]  = (source[1] << 22) & 0x1ffffff;
    destination[5] |= (source[2] >> 42) & 0x1ffffff;
    destination[6]  = (source[2] >> 17) & 0x1ffffff;
    destination[7]  = (source[2] << 8) & 0x1ffffff;
    destination[7] |= (source[3] >> 56) & 0x1ffffff;
    destination[8]  = (source[3] >> 31) & 0x1ffffff;
    destination[9]  = (source[3] >> 6) & 0x1ffffff;
    destination[10]  = (source[3] << 19) & 0x1ffffff;
    destination[10] |= (source[4] >> 45) & 0x1ffffff;
    destination[11]  = (source[4] >> 20) & 0x1ffffff;
    destination[12]  = (source[4] << 5) & 0x1ffffff;
    destination[12] |= (source[5] >> 59) & 0x1ffffff;
    destination[13]  = (source[5] >> 34) & 0x1ffffff;
    destination[14]  = (source[5] >> 9) & 0x1ffffff;
    destination[15]  = (source[5] << 16) & 0x1ffffff;
    destination[15] |= (source[6] >> 48) & 0x1ffffff;
    destination[16]  = (source[6] >> 23) & 0x1ffffff;
    destination[17]  = (source[6] << 2) & 0x1ffffff;
    destination[17] |= (source[7] >> 62) & 0x1ffffff;
    destination[18]  = (source[7] >> 37) & 0x1ffffff;
    destination[19]  = (source[7] >> 12) & 0x1ffffff;
    destination[20]  = (source[7] << 13) & 0x1ffffff;
    destination[20] |= (source[8] >> 51) & 0x1ffffff;
    destination[21]  = (source[8] >> 26) & 0x1ffffff;
    destination[22]  = (source[8] >> 1) & 0x1ffffff;
    destination[23]  = (source[8] << 24) & 0x1ffffff;
    destination[23] |= (source[9] >> 40) & 0x1ffffff;
    destination[24]  = (source[9] >> 15) & 0x1ffffff;
    destination[25]  = (source[9] << 10) & 0x1ffffff;
    destination[25] |= (source[10] >> 54) & 0x1ffffff;
    destination[26]  = (source[10] >> 29) & 0x1ffffff;
    destination[27]  = (source[10] >> 4) & 0x1ffffff;
    destination[28]  = (source[10] << 21) & 0x1ffffff;
    destination[28] |= (source[11] >> 43) & 0x1ffffff;
    destination[29]  = (source[11] >> 18) & 0x1ffffff;
    destination[30]  = (source[11] << 7) & 0x1ffffff;
    destination[30] |= (source[12] >> 57) & 0x1ffffff;
    destination[31]  = (source[12] >> 32) & 0x1ffffff;
    destination[32]  = (source[12] >> 7) & 0x1ffffff;
    destination[33]  = (source[12] << 18) & 0x1ffffff;
    destination[33] |= (source[13] >> 46) & 0x1ffffff;
    destination[34]  = (source[13] >> 21) & 0x1ffffff;
    destination[35]  = (source[13] << 4) & 0x1ffffff;
    destination[35] |= (source[14] >> 60) & 0x1ffffff;
    destination[36]  = (source[14] >> 35) & 0x1ffffff;
    destination[37]  = (source[14] >> 10) & 0x1ffffff;
    destination[38]  = (source[14] << 15) & 0x1ffffff;
    destination[38] |= (source[15] >> 49) & 0x1ffffff;
    destination[39]  = (source[15] >> 24) & 0x1ffffff;
    destination[40]  = (source[15] << 1) & 0x1ffffff;
    destination[40] |= (source[16] >> 63) & 0x1ffffff;
    destination[41]  = (source[16] >> 38) & 0x1ffffff;
    destination[42]  = (source[16] >> 13) & 0x1ffffff;
    destination[43]  = (source[16] << 12) & 0x1ffffff;
    destination[43] |= (source[17] >> 52) & 0x1ffffff;
    destination[44]  = (source[17] >> 27) & 0x1ffffff;
    destination[45]  = (source[17] >> 2) & 0x1ffffff;
    destination[46]  = (source[17] << 23) & 0x1ffffff;
    destination[46] |= (source[18] >> 41) & 0x1ffffff;
    destination[47]  = (source[18] >> 16) & 0x1ffffff;
    destination[48]  = (source[18] << 9) & 0x1ffffff;
    destination[48] |= (source[19] >> 55) & 0x1ffffff;
    destination[49]  = (source[19] >> 30) & 0x1ffffff;
    destination[50]  = (source[19] >> 5) & 0x1ffffff;
    destination[51]  = (source[19] << 20) & 0x1ffffff;
    destination[51] |= (source[20] >> 44) & 0x1ffffff;
    destination[52]  = (source[20] >> 19) & 0x1ffffff;
    destination[53]  = (source[20] << 6) & 0x1ffffff;
    destination[53] |= (source[21] >> 58) & 0x1ffffff;
    destination[54]  = (source[21] >> 33) & 0x1ffffff;
    destination[55]  = (source[21] >> 8) & 0x1ffffff;
    destination[56]  = (source[21] << 17) & 0x1ffffff;
    destination[56] |= (source[22] >> 47) & 0x1ffffff;
    destination[57]  = (source[22] >> 22) & 0x1ffffff;
    destination[58]  = (source[22] << 3) & 0x1ffffff;
    destination[58] |= (source[23] >> 61) & 0x1ffffff;
    destination[59]  = (source[23] >> 36) & 0x1ffffff;
    destination[60]  = (source[23] >> 11) & 0x1ffffff;
    destination[61]  = (source[23] << 14) & 0x1ffffff;
    destination[61] |= (source[24] >> 50) & 0x1ffffff;
    destination[62]  = (source[24] >> 25) & 0x1ffffff;
    destination[63]  = (source[24] >> 0) & 0x1ffffff;
  }
};
template <typename Tp>
struct __struct_bitpack_impl<Tp,8,26>
{
  static const size_t unit_size = 64;
  static const size_t bits_total = 1664;
  static const size_t loop_total = 64;
  static const size_t bit_size = 26;
  static const Tp     mask = 0x3ffffff;
  static inline
  void pack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] & 0x3ffffff) << 38;
    destination[0] |= (source[1] & 0x3ffffff) << 12;
    destination[0] |= (source[2] & 0x3ffffff) >> 14;
    destination[1]  = (source[2] & 0x3ffffff) << 50;
    destination[1] |= (source[3] & 0x3ffffff) << 24;
    destination[1] |= (source[4] & 0x3ffffff) >> 2;
    destination[2]  = (source[4] & 0x3ffffff) << 62;
    destination[2] |= (source[5] & 0x3ffffff) << 36;
    destination[2] |= (source[6] & 0x3ffffff) << 10;
    destination[2] |= (source[7] & 0x3ffffff) >> 16;
    destination[3]  = (source[7] & 0x3ffffff) << 48;
    destination[3] |= (source[8] & 0x3ffffff) << 22;
    destination[3] |= (source[9] & 0x3ffffff) >> 4;
    destination[4]  = (source[9] & 0x3ffffff) << 60;
    destination[4] |= (source[10] & 0x3ffffff) << 34;
    destination[4] |= (source[11] & 0x3ffffff) << 8;
    destination[4] |= (source[12] & 0x3ffffff) >> 18;
    destination[5]  = (source[12] & 0x3ffffff) << 46;
    destination[5] |= (source[13] & 0x3ffffff) << 20;
    destination[5] |= (source[14] & 0x3ffffff) >> 6;
    destination[6]  = (source[14] & 0x3ffffff) << 58;
    destination[6] |= (source[15] & 0x3ffffff) << 32;
    destination[6] |= (source[16] & 0x3ffffff) << 6;
    destination[6] |= (source[17] & 0x3ffffff) >> 20;
    destination[7]  = (source[17] & 0x3ffffff) << 44;
    destination[7] |= (source[18] & 0x3ffffff) << 18;
    destination[7] |= (source[19] & 0x3ffffff) >> 8;
    destination[8]  = (source[19] & 0x3ffffff) << 56;
    destination[8] |= (source[20] & 0x3ffffff) << 30;
    destination[8] |= (source[21] & 0x3ffffff) << 4;
    destination[8] |= (source[22] & 0x3ffffff) >> 22;
    destination[9]  = (source[22] & 0x3ffffff) << 42;
    destination[9] |= (source[23] & 0x3ffffff) << 16;
    destination[9] |= (source[24] & 0x3ffffff) >> 10;
    destination[10]  = (source[24] & 0x3ffffff) << 54;
    destination[10] |= (source[25] & 0x3ffffff) << 28;
    destination[10] |= (source[26] & 0x3ffffff) << 2;
    destination[10] |= (source[27] & 0x3ffffff) >> 24;
    destination[11]  = (source[27] & 0x3ffffff) << 40;
    destination[11] |= (source[28] & 0x3ffffff) << 14;
    destination[11] |= (source[29] & 0x3ffffff) >> 12;
    destination[12]  = (source[29] & 0x3ffffff) << 52;
    destination[12] |= (source[30] & 0x3ffffff) << 26;
    destination[12] |= (source[31] & 0x3ffffff) << 0;
    destination[13]  = (source[32] & 0x3ffffff) << 38;
    destination[13] |= (source[33] & 0x3ffffff) << 12;
    destination[13] |= (source[34] & 0x3ffffff) >> 14;
    destination[14]  = (source[34] & 0x3ffffff) << 50;
    destination[14] |= (source[35] & 0x3ffffff) << 24;
    destination[14] |= (source[36] & 0x3ffffff) >> 2;
    destination[15]  = (source[36] & 0x3ffffff) << 62;
    destination[15] |= (source[37] & 0x3ffffff) << 36;
    destination[15] |= (source[38] & 0x3ffffff) << 10;
    destination[15] |= (source[39] & 0x3ffffff) >> 16;
    destination[16]  = (source[39] & 0x3ffffff) << 48;
    destination[16] |= (source[40] & 0x3ffffff) << 22;
    destination[16] |= (source[41] & 0x3ffffff) >> 4;
    destination[17]  = (source[41] & 0x3ffffff) << 60;
    destination[17] |= (source[42] & 0x3ffffff) << 34;
    destination[17] |= (source[43] & 0x3ffffff) << 8;
    destination[17] |= (source[44] & 0x3ffffff) >> 18;
    destination[18]  = (source[44] & 0x3ffffff) << 46;
    destination[18] |= (source[45] & 0x3ffffff) << 20;
    destination[18] |= (source[46] & 0x3ffffff) >> 6;
    destination[19]  = (source[46] & 0x3ffffff) << 58;
    destination[19] |= (source[47] & 0x3ffffff) << 32;
    destination[19] |= (source[48] & 0x3ffffff) << 6;
    destination[19] |= (source[49] & 0x3ffffff) >> 20;
    destination[20]  = (source[49] & 0x3ffffff) << 44;
    destination[20] |= (source[50] & 0x3ffffff) << 18;
    destination[20] |= (source[51] & 0x3ffffff) >> 8;
    destination[21]  = (source[51] & 0x3ffffff) << 56;
    destination[21] |= (source[52] & 0x3ffffff) << 30;
    destination[21] |= (source[53] & 0x3ffffff) << 4;
    destination[21] |= (source[54] & 0x3ffffff) >> 22;
    destination[22]  = (source[54] & 0x3ffffff) << 42;
    destination[22] |= (source[55] & 0x3ffffff) << 16;
    destination[22] |= (source[56] & 0x3ffffff) >> 10;
    destination[23]  = (source[56] & 0x3ffffff) << 54;
    destination[23] |= (source[57] & 0x3ffffff) << 28;
    destination[23] |= (source[58] & 0x3ffffff) << 2;
    destination[23] |= (source[59] & 0x3ffffff) >> 24;
    destination[24]  = (source[59] & 0x3ffffff) << 40;
    destination[24] |= (source[60] & 0x3ffffff) << 14;
    destination[24] |= (source[61] & 0x3ffffff) >> 12;
    destination[25]  = (source[61] & 0x3ffffff) << 52;
    destination[25] |= (source[62] & 0x3ffffff) << 26;
    destination[25] |= (source[63] & 0x3ffffff) << 0;
  }
  static inline
  void unpack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] >> 38) & 0x3ffffff;
    destination[1]  = (source[0] >> 12) & 0x3ffffff;
    destination[2]  = (source[0] << 14) & 0x3ffffff;
    destination[2] |= (source[1] >> 50) & 0x3ffffff;
    destination[3]  = (source[1] >> 24) & 0x3ffffff;
    destination[4]  = (source[1] << 2) & 0x3ffffff;
    destination[4] |= (source[2] >> 62) & 0x3ffffff;
    destination[5]  = (source[2] >> 36) & 0x3ffffff;
    destination[6]  = (source[2] >> 10) & 0x3ffffff;
    destination[7]  = (source[2] << 16) & 0x3ffffff;
    destination[7] |= (source[3] >> 48) & 0x3ffffff;
    destination[8]  = (source[3] >> 22) & 0x3ffffff;
    destination[9]  = (source[3] << 4) & 0x3ffffff;
    destination[9] |= (source[4] >> 60) & 0x3ffffff;
    destination[10]  = (source[4] >> 34) & 0x3ffffff;
    destination[11]  = (source[4] >> 8) & 0x3ffffff;
    destination[12]  = (source[4] << 18) & 0x3ffffff;
    destination[12] |= (source[5] >> 46) & 0x3ffffff;
    destination[13]  = (source[5] >> 20) & 0x3ffffff;
    destination[14]  = (source[5] << 6) & 0x3ffffff;
    destination[14] |= (source[6] >> 58) & 0x3ffffff;
    destination[15]  = (source[6] >> 32) & 0x3ffffff;
    destination[16]  = (source[6] >> 6) & 0x3ffffff;
    destination[17]  = (source[6] << 20) & 0x3ffffff;
    destination[17] |= (source[7] >> 44) & 0x3ffffff;
    destination[18]  = (source[7] >> 18) & 0x3ffffff;
    destination[19]  = (source[7] << 8) & 0x3ffffff;
    destination[19] |= (source[8] >> 56) & 0x3ffffff;
    destination[20]  = (source[8] >> 30) & 0x3ffffff;
    destination[21]  = (source[8] >> 4) & 0x3ffffff;
    destination[22]  = (source[8] << 22) & 0x3ffffff;
    destination[22] |= (source[9] >> 42) & 0x3ffffff;
    destination[23]  = (source[9] >> 16) & 0x3ffffff;
    destination[24]  = (source[9] << 10) & 0x3ffffff;
    destination[24] |= (source[10] >> 54) & 0x3ffffff;
    destination[25]  = (source[10] >> 28) & 0x3ffffff;
    destination[26]  = (source[10] >> 2) & 0x3ffffff;
    destination[27]  = (source[10] << 24) & 0x3ffffff;
    destination[27] |= (source[11] >> 40) & 0x3ffffff;
    destination[28]  = (source[11] >> 14) & 0x3ffffff;
    destination[29]  = (source[11] << 12) & 0x3ffffff;
    destination[29] |= (source[12] >> 52) & 0x3ffffff;
    destination[30]  = (source[12] >> 26) & 0x3ffffff;
    destination[31]  = (source[12] >> 0) & 0x3ffffff;
    destination[32]  = (source[13] >> 38) & 0x3ffffff;
    destination[33]  = (source[13] >> 12) & 0x3ffffff;
    destination[34]  = (source[13] << 14) & 0x3ffffff;
    destination[34] |= (source[14] >> 50) & 0x3ffffff;
    destination[35]  = (source[14] >> 24) & 0x3ffffff;
    destination[36]  = (source[14] << 2) & 0x3ffffff;
    destination[36] |= (source[15] >> 62) & 0x3ffffff;
    destination[37]  = (source[15] >> 36) & 0x3ffffff;
    destination[38]  = (source[15] >> 10) & 0x3ffffff;
    destination[39]  = (source[15] << 16) & 0x3ffffff;
    destination[39] |= (source[16] >> 48) & 0x3ffffff;
    destination[40]  = (source[16] >> 22) & 0x3ffffff;
    destination[41]  = (source[16] << 4) & 0x3ffffff;
    destination[41] |= (source[17] >> 60) & 0x3ffffff;
    destination[42]  = (source[17] >> 34) & 0x3ffffff;
    destination[43]  = (source[17] >> 8) & 0x3ffffff;
    destination[44]  = (source[17] << 18) & 0x3ffffff;
    destination[44] |= (source[18] >> 46) & 0x3ffffff;
    destination[45]  = (source[18] >> 20) & 0x3ffffff;
    destination[46]  = (source[18] << 6) & 0x3ffffff;
    destination[46] |= (source[19] >> 58) & 0x3ffffff;
    destination[47]  = (source[19] >> 32) & 0x3ffffff;
    destination[48]  = (source[19] >> 6) & 0x3ffffff;
    destination[49]  = (source[19] << 20) & 0x3ffffff;
    destination[49] |= (source[20] >> 44) & 0x3ffffff;
    destination[50]  = (source[20] >> 18) & 0x3ffffff;
    destination[51]  = (source[20] << 8) & 0x3ffffff;
    destination[51] |= (source[21] >> 56) & 0x3ffffff;
    destination[52]  = (source[21] >> 30) & 0x3ffffff;
    destination[53]  = (source[21] >> 4) & 0x3ffffff;
    destination[54]  = (source[21] << 22) & 0x3ffffff;
    destination[54] |= (source[22] >> 42) & 0x3ffffff;
    destination[55]  = (source[22] >> 16) & 0x3ffffff;
    destination[56]  = (source[22] << 10) & 0x3ffffff;
    destination[56] |= (source[23] >> 54) & 0x3ffffff;
    destination[57]  = (source[23] >> 28) & 0x3ffffff;
    destination[58]  = (source[23] >> 2) & 0x3ffffff;
    destination[59]  = (source[23] << 24) & 0x3ffffff;
    destination[59] |= (source[24] >> 40) & 0x3ffffff;
    destination[60]  = (source[24] >> 14) & 0x3ffffff;
    destination[61]  = (source[24] << 12) & 0x3ffffff;
    destination[61] |= (source[25] >> 52) & 0x3ffffff;
    destination[62]  = (source[25] >> 26) & 0x3ffffff;
    destination[63]  = (source[25] >> 0) & 0x3ffffff;
  }
};
template <typename Tp>
struct __struct_bitpack_impl<Tp,8,27>
{
  static const size_t unit_size = 64;
  static const size_t bits_total = 1728;
  static const size_t loop_total = 64;
  static const size_t bit_size = 27;
  static const Tp     mask = 0x7ffffff;
  static inline
  void pack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] & 0x7ffffff) << 37;
    destination[0] |= (source[1] & 0x7ffffff) << 10;
    destination[0] |= (source[2] & 0x7ffffff) >> 17;
    destination[1]  = (source[2] & 0x7ffffff) << 47;
    destination[1] |= (source[3] & 0x7ffffff) << 20;
    destination[1] |= (source[4] & 0x7ffffff) >> 7;
    destination[2]  = (source[4] & 0x7ffffff) << 57;
    destination[2] |= (source[5] & 0x7ffffff) << 30;
    destination[2] |= (source[6] & 0x7ffffff) << 3;
    destination[2] |= (source[7] & 0x7ffffff) >> 24;
    destination[3]  = (source[7] & 0x7ffffff) << 40;
    destination[3] |= (source[8] & 0x7ffffff) << 13;
    destination[3] |= (source[9] & 0x7ffffff) >> 14;
    destination[4]  = (source[9] & 0x7ffffff) << 50;
    destination[4] |= (source[10] & 0x7ffffff) << 23;
    destination[4] |= (source[11] & 0x7ffffff) >> 4;
    destination[5]  = (source[11] & 0x7ffffff) << 60;
    destination[5] |= (source[12] & 0x7ffffff) << 33;
    destination[5] |= (source[13] & 0x7ffffff) << 6;
    destination[5] |= (source[14] & 0x7ffffff) >> 21;
    destination[6]  = (source[14] & 0x7ffffff) << 43;
    destination[6] |= (source[15] & 0x7ffffff) << 16;
    destination[6] |= (source[16] & 0x7ffffff) >> 11;
    destination[7]  = (source[16] & 0x7ffffff) << 53;
    destination[7] |= (source[17] & 0x7ffffff) << 26;
    destination[7] |= (source[18] & 0x7ffffff) >> 1;
    destination[8]  = (source[18] & 0x7ffffff) << 63;
    destination[8] |= (source[19] & 0x7ffffff) << 36;
    destination[8] |= (source[20] & 0x7ffffff) << 9;
    destination[8] |= (source[21] & 0x7ffffff) >> 18;
    destination[9]  = (source[21] & 0x7ffffff) << 46;
    destination[9] |= (source[22] & 0x7ffffff) << 19;
    destination[9] |= (source[23] & 0x7ffffff) >> 8;
    destination[10]  = (source[23] & 0x7ffffff) << 56;
    destination[10] |= (source[24] & 0x7ffffff) << 29;
    destination[10] |= (source[25] & 0x7ffffff) << 2;
    destination[10] |= (source[26] & 0x7ffffff) >> 25;
    destination[11]  = (source[26] & 0x7ffffff) << 39;
    destination[11] |= (source[27] & 0x7ffffff) << 12;
    destination[11] |= (source[28] & 0x7ffffff) >> 15;
    destination[12]  = (source[28] & 0x7ffffff) << 49;
    destination[12] |= (source[29] & 0x7ffffff) << 22;
    destination[12] |= (source[30] & 0x7ffffff) >> 5;
    destination[13]  = (source[30] & 0x7ffffff) << 59;
    destination[13] |= (source[31] & 0x7ffffff) << 32;
    destination[13] |= (source[32] & 0x7ffffff) << 5;
    destination[13] |= (source[33] & 0x7ffffff) >> 22;
    destination[14]  = (source[33] & 0x7ffffff) << 42;
    destination[14] |= (source[34] & 0x7ffffff) << 15;
    destination[14] |= (source[35] & 0x7ffffff) >> 12;
    destination[15]  = (source[35] & 0x7ffffff) << 52;
    destination[15] |= (source[36] & 0x7ffffff) << 25;
    destination[15] |= (source[37] & 0x7ffffff) >> 2;
    destination[16]  = (source[37] & 0x7ffffff) << 62;
    destination[16] |= (source[38] & 0x7ffffff) << 35;
    destination[16] |= (source[39] & 0x7ffffff) << 8;
    destination[16] |= (source[40] & 0x7ffffff) >> 19;
    destination[17]  = (source[40] & 0x7ffffff) << 45;
    destination[17] |= (source[41] & 0x7ffffff) << 18;
    destination[17] |= (source[42] & 0x7ffffff) >> 9;
    destination[18]  = (source[42] & 0x7ffffff) << 55;
    destination[18] |= (source[43] & 0x7ffffff) << 28;
    destination[18] |= (source[44] & 0x7ffffff) << 1;
    destination[18] |= (source[45] & 0x7ffffff) >> 26;
    destination[19]  = (source[45] & 0x7ffffff) << 38;
    destination[19] |= (source[46] & 0x7ffffff) << 11;
    destination[19] |= (source[47] & 0x7ffffff) >> 16;
    destination[20]  = (source[47] & 0x7ffffff) << 48;
    destination[20] |= (source[48] & 0x7ffffff) << 21;
    destination[20] |= (source[49] & 0x7ffffff) >> 6;
    destination[21]  = (source[49] & 0x7ffffff) << 58;
    destination[21] |= (source[50] & 0x7ffffff) << 31;
    destination[21] |= (source[51] & 0x7ffffff) << 4;
    destination[21] |= (source[52] & 0x7ffffff) >> 23;
    destination[22]  = (source[52] & 0x7ffffff) << 41;
    destination[22] |= (source[53] & 0x7ffffff) << 14;
    destination[22] |= (source[54] & 0x7ffffff) >> 13;
    destination[23]  = (source[54] & 0x7ffffff) << 51;
    destination[23] |= (source[55] & 0x7ffffff) << 24;
    destination[23] |= (source[56] & 0x7ffffff) >> 3;
    destination[24]  = (source[56] & 0x7ffffff) << 61;
    destination[24] |= (source[57] & 0x7ffffff) << 34;
    destination[24] |= (source[58] & 0x7ffffff) << 7;
    destination[24] |= (source[59] & 0x7ffffff) >> 20;
    destination[25]  = (source[59] & 0x7ffffff) << 44;
    destination[25] |= (source[60] & 0x7ffffff) << 17;
    destination[25] |= (source[61] & 0x7ffffff) >> 10;
    destination[26]  = (source[61] & 0x7ffffff) << 54;
    destination[26] |= (source[62] & 0x7ffffff) << 27;
    destination[26] |= (source[63] & 0x7ffffff) << 0;
  }
  static inline
  void unpack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] >> 37) & 0x7ffffff;
    destination[1]  = (source[0] >> 10) & 0x7ffffff;
    destination[2]  = (source[0] << 17) & 0x7ffffff;
    destination[2] |= (source[1] >> 47) & 0x7ffffff;
    destination[3]  = (source[1] >> 20) & 0x7ffffff;
    destination[4]  = (source[1] << 7) & 0x7ffffff;
    destination[4] |= (source[2] >> 57) & 0x7ffffff;
    destination[5]  = (source[2] >> 30) & 0x7ffffff;
    destination[6]  = (source[2] >> 3) & 0x7ffffff;
    destination[7]  = (source[2] << 24) & 0x7ffffff;
    destination[7] |= (source[3] >> 40) & 0x7ffffff;
    destination[8]  = (source[3] >> 13) & 0x7ffffff;
    destination[9]  = (source[3] << 14) & 0x7ffffff;
    destination[9] |= (source[4] >> 50) & 0x7ffffff;
    destination[10]  = (source[4] >> 23) & 0x7ffffff;
    destination[11]  = (source[4] << 4) & 0x7ffffff;
    destination[11] |= (source[5] >> 60) & 0x7ffffff;
    destination[12]  = (source[5] >> 33) & 0x7ffffff;
    destination[13]  = (source[5] >> 6) & 0x7ffffff;
    destination[14]  = (source[5] << 21) & 0x7ffffff;
    destination[14] |= (source[6] >> 43) & 0x7ffffff;
    destination[15]  = (source[6] >> 16) & 0x7ffffff;
    destination[16]  = (source[6] << 11) & 0x7ffffff;
    destination[16] |= (source[7] >> 53) & 0x7ffffff;
    destination[17]  = (source[7] >> 26) & 0x7ffffff;
    destination[18]  = (source[7] << 1) & 0x7ffffff;
    destination[18] |= (source[8] >> 63) & 0x7ffffff;
    destination[19]  = (source[8] >> 36) & 0x7ffffff;
    destination[20]  = (source[8] >> 9) & 0x7ffffff;
    destination[21]  = (source[8] << 18) & 0x7ffffff;
    destination[21] |= (source[9] >> 46) & 0x7ffffff;
    destination[22]  = (source[9] >> 19) & 0x7ffffff;
    destination[23]  = (source[9] << 8) & 0x7ffffff;
    destination[23] |= (source[10] >> 56) & 0x7ffffff;
    destination[24]  = (source[10] >> 29) & 0x7ffffff;
    destination[25]  = (source[10] >> 2) & 0x7ffffff;
    destination[26]  = (source[10] << 25) & 0x7ffffff;
    destination[26] |= (source[11] >> 39) & 0x7ffffff;
    destination[27]  = (source[11] >> 12) & 0x7ffffff;
    destination[28]  = (source[11] << 15) & 0x7ffffff;
    destination[28] |= (source[12] >> 49) & 0x7ffffff;
    destination[29]  = (source[12] >> 22) & 0x7ffffff;
    destination[30]  = (source[12] << 5) & 0x7ffffff;
    destination[30] |= (source[13] >> 59) & 0x7ffffff;
    destination[31]  = (source[13] >> 32) & 0x7ffffff;
    destination[32]  = (source[13] >> 5) & 0x7ffffff;
    destination[33]  = (source[13] << 22) & 0x7ffffff;
    destination[33] |= (source[14] >> 42) & 0x7ffffff;
    destination[34]  = (source[14] >> 15) & 0x7ffffff;
    destination[35]  = (source[14] << 12) & 0x7ffffff;
    destination[35] |= (source[15] >> 52) & 0x7ffffff;
    destination[36]  = (source[15] >> 25) & 0x7ffffff;
    destination[37]  = (source[15] << 2) & 0x7ffffff;
    destination[37] |= (source[16] >> 62) & 0x7ffffff;
    destination[38]  = (source[16] >> 35) & 0x7ffffff;
    destination[39]  = (source[16] >> 8) & 0x7ffffff;
    destination[40]  = (source[16] << 19) & 0x7ffffff;
    destination[40] |= (source[17] >> 45) & 0x7ffffff;
    destination[41]  = (source[17] >> 18) & 0x7ffffff;
    destination[42]  = (source[17] << 9) & 0x7ffffff;
    destination[42] |= (source[18] >> 55) & 0x7ffffff;
    destination[43]  = (source[18] >> 28) & 0x7ffffff;
    destination[44]  = (source[18] >> 1) & 0x7ffffff;
    destination[45]  = (source[18] << 26) & 0x7ffffff;
    destination[45] |= (source[19] >> 38) & 0x7ffffff;
    destination[46]  = (source[19] >> 11) & 0x7ffffff;
    destination[47]  = (source[19] << 16) & 0x7ffffff;
    destination[47] |= (source[20] >> 48) & 0x7ffffff;
    destination[48]  = (source[20] >> 21) & 0x7ffffff;
    destination[49]  = (source[20] << 6) & 0x7ffffff;
    destination[49] |= (source[21] >> 58) & 0x7ffffff;
    destination[50]  = (source[21] >> 31) & 0x7ffffff;
    destination[51]  = (source[21] >> 4) & 0x7ffffff;
    destination[52]  = (source[21] << 23) & 0x7ffffff;
    destination[52] |= (source[22] >> 41) & 0x7ffffff;
    destination[53]  = (source[22] >> 14) & 0x7ffffff;
    destination[54]  = (source[22] << 13) & 0x7ffffff;
    destination[54] |= (source[23] >> 51) & 0x7ffffff;
    destination[55]  = (source[23] >> 24) & 0x7ffffff;
    destination[56]  = (source[23] << 3) & 0x7ffffff;
    destination[56] |= (source[24] >> 61) & 0x7ffffff;
    destination[57]  = (source[24] >> 34) & 0x7ffffff;
    destination[58]  = (source[24] >> 7) & 0x7ffffff;
    destination[59]  = (source[24] << 20) & 0x7ffffff;
    destination[59] |= (source[25] >> 44) & 0x7ffffff;
    destination[60]  = (source[25] >> 17) & 0x7ffffff;
    destination[61]  = (source[25] << 10) & 0x7ffffff;
    destination[61] |= (source[26] >> 54) & 0x7ffffff;
    destination[62]  = (source[26] >> 27) & 0x7ffffff;
    destination[63]  = (source[26] >> 0) & 0x7ffffff;
  }
};
template <typename Tp>
struct __struct_bitpack_impl<Tp,8,28>
{
  static const size_t unit_size = 64;
  static const size_t bits_total = 1792;
  static const size_t loop_total = 64;
  static const size_t bit_size = 28;
  static const Tp     mask = 0xfffffff;
  static inline
  void pack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] & 0xfffffff) << 36;
    destination[0] |= (source[1] & 0xfffffff) << 8;
    destination[0] |= (source[2] & 0xfffffff) >> 20;
    destination[1]  = (source[2] & 0xfffffff) << 44;
    destination[1] |= (source[3] & 0xfffffff) << 16;
    destination[1] |= (source[4] & 0xfffffff) >> 12;
    destination[2]  = (source[4] & 0xfffffff) << 52;
    destination[2] |= (source[5] & 0xfffffff) << 24;
    destination[2] |= (source[6] & 0xfffffff) >> 4;
    destination[3]  = (source[6] & 0xfffffff) << 60;
    destination[3] |= (source[7] & 0xfffffff) << 32;
    destination[3] |= (source[8] & 0xfffffff) << 4;
    destination[3] |= (source[9] & 0xfffffff) >> 24;
    destination[4]  = (source[9] & 0xfffffff) << 40;
    destination[4] |= (source[10] & 0xfffffff) << 12;
    destination[4] |= (source[11] & 0xfffffff) >> 16;
    destination[5]  = (source[11] & 0xfffffff) << 48;
    destination[5] |= (source[12] & 0xfffffff) << 20;
    destination[5] |= (source[13] & 0xfffffff) >> 8;
    destination[6]  = (source[13] & 0xfffffff) << 56;
    destination[6] |= (source[14] & 0xfffffff) << 28;
    destination[6] |= (source[15] & 0xfffffff) << 0;
    destination[7]  = (source[16] & 0xfffffff) << 36;
    destination[7] |= (source[17] & 0xfffffff) << 8;
    destination[7] |= (source[18] & 0xfffffff) >> 20;
    destination[8]  = (source[18] & 0xfffffff) << 44;
    destination[8] |= (source[19] & 0xfffffff) << 16;
    destination[8] |= (source[20] & 0xfffffff) >> 12;
    destination[9]  = (source[20] & 0xfffffff) << 52;
    destination[9] |= (source[21] & 0xfffffff) << 24;
    destination[9] |= (source[22] & 0xfffffff) >> 4;
    destination[10]  = (source[22] & 0xfffffff) << 60;
    destination[10] |= (source[23] & 0xfffffff) << 32;
    destination[10] |= (source[24] & 0xfffffff) << 4;
    destination[10] |= (source[25] & 0xfffffff) >> 24;
    destination[11]  = (source[25] & 0xfffffff) << 40;
    destination[11] |= (source[26] & 0xfffffff) << 12;
    destination[11] |= (source[27] & 0xfffffff) >> 16;
    destination[12]  = (source[27] & 0xfffffff) << 48;
    destination[12] |= (source[28] & 0xfffffff) << 20;
    destination[12] |= (source[29] & 0xfffffff) >> 8;
    destination[13]  = (source[29] & 0xfffffff) << 56;
    destination[13] |= (source[30] & 0xfffffff) << 28;
    destination[13] |= (source[31] & 0xfffffff) << 0;
    destination[14]  = (source[32] & 0xfffffff) << 36;
    destination[14] |= (source[33] & 0xfffffff) << 8;
    destination[14] |= (source[34] & 0xfffffff) >> 20;
    destination[15]  = (source[34] & 0xfffffff) << 44;
    destination[15] |= (source[35] & 0xfffffff) << 16;
    destination[15] |= (source[36] & 0xfffffff) >> 12;
    destination[16]  = (source[36] & 0xfffffff) << 52;
    destination[16] |= (source[37] & 0xfffffff) << 24;
    destination[16] |= (source[38] & 0xfffffff) >> 4;
    destination[17]  = (source[38] & 0xfffffff) << 60;
    destination[17] |= (source[39] & 0xfffffff) << 32;
    destination[17] |= (source[40] & 0xfffffff) << 4;
    destination[17] |= (source[41] & 0xfffffff) >> 24;
    destination[18]  = (source[41] & 0xfffffff) << 40;
    destination[18] |= (source[42] & 0xfffffff) << 12;
    destination[18] |= (source[43] & 0xfffffff) >> 16;
    destination[19]  = (source[43] & 0xfffffff) << 48;
    destination[19] |= (source[44] & 0xfffffff) << 20;
    destination[19] |= (source[45] & 0xfffffff) >> 8;
    destination[20]  = (source[45] & 0xfffffff) << 56;
    destination[20] |= (source[46] & 0xfffffff) << 28;
    destination[20] |= (source[47] & 0xfffffff) << 0;
    destination[21]  = (source[48] & 0xfffffff) << 36;
    destination[21] |= (source[49] & 0xfffffff) << 8;
    destination[21] |= (source[50] & 0xfffffff) >> 20;
    destination[22]  = (source[50] & 0xfffffff) << 44;
    destination[22] |= (source[51] & 0xfffffff) << 16;
    destination[22] |= (source[52] & 0xfffffff) >> 12;
    destination[23]  = (source[52] & 0xfffffff) << 52;
    destination[23] |= (source[53] & 0xfffffff) << 24;
    destination[23] |= (source[54] & 0xfffffff) >> 4;
    destination[24]  = (source[54] & 0xfffffff) << 60;
    destination[24] |= (source[55] & 0xfffffff) << 32;
    destination[24] |= (source[56] & 0xfffffff) << 4;
    destination[24] |= (source[57] & 0xfffffff) >> 24;
    destination[25]  = (source[57] & 0xfffffff) << 40;
    destination[25] |= (source[58] & 0xfffffff) << 12;
    destination[25] |= (source[59] & 0xfffffff) >> 16;
    destination[26]  = (source[59] & 0xfffffff) << 48;
    destination[26] |= (source[60] & 0xfffffff) << 20;
    destination[26] |= (source[61] & 0xfffffff) >> 8;
    destination[27]  = (source[61] & 0xfffffff) << 56;
    destination[27] |= (source[62] & 0xfffffff) << 28;
    destination[27] |= (source[63] & 0xfffffff) << 0;
  }
  static inline
  void unpack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] >> 36) & 0xfffffff;
    destination[1]  = (source[0] >> 8) & 0xfffffff;
    destination[2]  = (source[0] << 20) & 0xfffffff;
    destination[2] |= (source[1] >> 44) & 0xfffffff;
    destination[3]  = (source[1] >> 16) & 0xfffffff;
    destination[4]  = (source[1] << 12) & 0xfffffff;
    destination[4] |= (source[2] >> 52) & 0xfffffff;
    destination[5]  = (source[2] >> 24) & 0xfffffff;
    destination[6]  = (source[2] << 4) & 0xfffffff;
    destination[6] |= (source[3] >> 60) & 0xfffffff;
    destination[7]  = (source[3] >> 32) & 0xfffffff;
    destination[8]  = (source[3] >> 4) & 0xfffffff;
    destination[9]  = (source[3] << 24) & 0xfffffff;
    destination[9] |= (source[4] >> 40) & 0xfffffff;
    destination[10]  = (source[4] >> 12) & 0xfffffff;
    destination[11]  = (source[4] << 16) & 0xfffffff;
    destination[11] |= (source[5] >> 48) & 0xfffffff;
    destination[12]  = (source[5] >> 20) & 0xfffffff;
    destination[13]  = (source[5] << 8) & 0xfffffff;
    destination[13] |= (source[6] >> 56) & 0xfffffff;
    destination[14]  = (source[6] >> 28) & 0xfffffff;
    destination[15]  = (source[6] >> 0) & 0xfffffff;
    destination[16]  = (source[7] >> 36) & 0xfffffff;
    destination[17]  = (source[7] >> 8) & 0xfffffff;
    destination[18]  = (source[7] << 20) & 0xfffffff;
    destination[18] |= (source[8] >> 44) & 0xfffffff;
    destination[19]  = (source[8] >> 16) & 0xfffffff;
    destination[20]  = (source[8] << 12) & 0xfffffff;
    destination[20] |= (source[9] >> 52) & 0xfffffff;
    destination[21]  = (source[9] >> 24) & 0xfffffff;
    destination[22]  = (source[9] << 4) & 0xfffffff;
    destination[22] |= (source[10] >> 60) & 0xfffffff;
    destination[23]  = (source[10] >> 32) & 0xfffffff;
    destination[24]  = (source[10] >> 4) & 0xfffffff;
    destination[25]  = (source[10] << 24) & 0xfffffff;
    destination[25] |= (source[11] >> 40) & 0xfffffff;
    destination[26]  = (source[11] >> 12) & 0xfffffff;
    destination[27]  = (source[11] << 16) & 0xfffffff;
    destination[27] |= (source[12] >> 48) & 0xfffffff;
    destination[28]  = (source[12] >> 20) & 0xfffffff;
    destination[29]  = (source[12] << 8) & 0xfffffff;
    destination[29] |= (source[13] >> 56) & 0xfffffff;
    destination[30]  = (source[13] >> 28) & 0xfffffff;
    destination[31]  = (source[13] >> 0) & 0xfffffff;
    destination[32]  = (source[14] >> 36) & 0xfffffff;
    destination[33]  = (source[14] >> 8) & 0xfffffff;
    destination[34]  = (source[14] << 20) & 0xfffffff;
    destination[34] |= (source[15] >> 44) & 0xfffffff;
    destination[35]  = (source[15] >> 16) & 0xfffffff;
    destination[36]  = (source[15] << 12) & 0xfffffff;
    destination[36] |= (source[16] >> 52) & 0xfffffff;
    destination[37]  = (source[16] >> 24) & 0xfffffff;
    destination[38]  = (source[16] << 4) & 0xfffffff;
    destination[38] |= (source[17] >> 60) & 0xfffffff;
    destination[39]  = (source[17] >> 32) & 0xfffffff;
    destination[40]  = (source[17] >> 4) & 0xfffffff;
    destination[41]  = (source[17] << 24) & 0xfffffff;
    destination[41] |= (source[18] >> 40) & 0xfffffff;
    destination[42]  = (source[18] >> 12) & 0xfffffff;
    destination[43]  = (source[18] << 16) & 0xfffffff;
    destination[43] |= (source[19] >> 48) & 0xfffffff;
    destination[44]  = (source[19] >> 20) & 0xfffffff;
    destination[45]  = (source[19] << 8) & 0xfffffff;
    destination[45] |= (source[20] >> 56) & 0xfffffff;
    destination[46]  = (source[20] >> 28) & 0xfffffff;
    destination[47]  = (source[20] >> 0) & 0xfffffff;
    destination[48]  = (source[21] >> 36) & 0xfffffff;
    destination[49]  = (source[21] >> 8) & 0xfffffff;
    destination[50]  = (source[21] << 20) & 0xfffffff;
    destination[50] |= (source[22] >> 44) & 0xfffffff;
    destination[51]  = (source[22] >> 16) & 0xfffffff;
    destination[52]  = (source[22] << 12) & 0xfffffff;
    destination[52] |= (source[23] >> 52) & 0xfffffff;
    destination[53]  = (source[23] >> 24) & 0xfffffff;
    destination[54]  = (source[23] << 4) & 0xfffffff;
    destination[54] |= (source[24] >> 60) & 0xfffffff;
    destination[55]  = (source[24] >> 32) & 0xfffffff;
    destination[56]  = (source[24] >> 4) & 0xfffffff;
    destination[57]  = (source[24] << 24) & 0xfffffff;
    destination[57] |= (source[25] >> 40) & 0xfffffff;
    destination[58]  = (source[25] >> 12) & 0xfffffff;
    destination[59]  = (source[25] << 16) & 0xfffffff;
    destination[59] |= (source[26] >> 48) & 0xfffffff;
    destination[60]  = (source[26] >> 20) & 0xfffffff;
    destination[61]  = (source[26] << 8) & 0xfffffff;
    destination[61] |= (source[27] >> 56) & 0xfffffff;
    destination[62]  = (source[27] >> 28) & 0xfffffff;
    destination[63]  = (source[27] >> 0) & 0xfffffff;
  }
};
template <typename Tp>
struct __struct_bitpack_impl<Tp,8,29>
{
  static const size_t unit_size = 64;
  static const size_t bits_total = 1856;
  static const size_t loop_total = 64;
  static const size_t bit_size = 29;
  static const Tp     mask = 0x1fffffff;
  static inline
  void pack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] & 0x1fffffff) << 35;
    destination[0] |= (source[1] & 0x1fffffff) << 6;
    destination[0] |= (source[2] & 0x1fffffff) >> 23;
    destination[1]  = (source[2] & 0x1fffffff) << 41;
    destination[1] |= (source[3] & 0x1fffffff) << 12;
    destination[1] |= (source[4] & 0x1fffffff) >> 17;
    destination[2]  = (source[4] & 0x1fffffff) << 47;
    destination[2] |= (source[5] & 0x1fffffff) << 18;
    destination[2] |= (source[6] & 0x1fffffff) >> 11;
    destination[3]  = (source[6] & 0x1fffffff) << 53;
    destination[3] |= (source[7] & 0x1fffffff) << 24;
    destination[3] |= (source[8] & 0x1fffffff) >> 5;
    destination[4]  = (source[8] & 0x1fffffff) << 59;
    destination[4] |= (source[9] & 0x1fffffff) << 30;
    destination[4] |= (source[10] & 0x1fffffff) << 1;
    destination[4] |= (source[11] & 0x1fffffff) >> 28;
    destination[5]  = (source[11] & 0x1fffffff) << 36;
    destination[5] |= (source[12] & 0x1fffffff) << 7;
    destination[5] |= (source[13] & 0x1fffffff) >> 22;
    destination[6]  = (source[13] & 0x1fffffff) << 42;
    destination[6] |= (source[14] & 0x1fffffff) << 13;
    destination[6] |= (source[15] & 0x1fffffff) >> 16;
    destination[7]  = (source[15] & 0x1fffffff) << 48;
    destination[7] |= (source[16] & 0x1fffffff) << 19;
    destination[7] |= (source[17] & 0x1fffffff) >> 10;
    destination[8]  = (source[17] & 0x1fffffff) << 54;
    destination[8] |= (source[18] & 0x1fffffff) << 25;
    destination[8] |= (source[19] & 0x1fffffff) >> 4;
    destination[9]  = (source[19] & 0x1fffffff) << 60;
    destination[9] |= (source[20] & 0x1fffffff) << 31;
    destination[9] |= (source[21] & 0x1fffffff) << 2;
    destination[9] |= (source[22] & 0x1fffffff) >> 27;
    destination[10]  = (source[22] & 0x1fffffff) << 37;
    destination[10] |= (source[23] & 0x1fffffff) << 8;
    destination[10] |= (source[24] & 0x1fffffff) >> 21;
    destination[11]  = (source[24] & 0x1fffffff) << 43;
    destination[11] |= (source[25] & 0x1fffffff) << 14;
    destination[11] |= (source[26] & 0x1fffffff) >> 15;
    destination[12]  = (source[26] & 0x1fffffff) << 49;
    destination[12] |= (source[27] & 0x1fffffff) << 20;
    destination[12] |= (source[28] & 0x1fffffff) >> 9;
    destination[13]  = (source[28] & 0x1fffffff) << 55;
    destination[13] |= (source[29] & 0x1fffffff) << 26;
    destination[13] |= (source[30] & 0x1fffffff) >> 3;
    destination[14]  = (source[30] & 0x1fffffff) << 61;
    destination[14] |= (source[31] & 0x1fffffff) << 32;
    destination[14] |= (source[32] & 0x1fffffff) << 3;
    destination[14] |= (source[33] & 0x1fffffff) >> 26;
    destination[15]  = (source[33] & 0x1fffffff) << 38;
    destination[15] |= (source[34] & 0x1fffffff) << 9;
    destination[15] |= (source[35] & 0x1fffffff) >> 20;
    destination[16]  = (source[35] & 0x1fffffff) << 44;
    destination[16] |= (source[36] & 0x1fffffff) << 15;
    destination[16] |= (source[37] & 0x1fffffff) >> 14;
    destination[17]  = (source[37] & 0x1fffffff) << 50;
    destination[17] |= (source[38] & 0x1fffffff) << 21;
    destination[17] |= (source[39] & 0x1fffffff) >> 8;
    destination[18]  = (source[39] & 0x1fffffff) << 56;
    destination[18] |= (source[40] & 0x1fffffff) << 27;
    destination[18] |= (source[41] & 0x1fffffff) >> 2;
    destination[19]  = (source[41] & 0x1fffffff) << 62;
    destination[19] |= (source[42] & 0x1fffffff) << 33;
    destination[19] |= (source[43] & 0x1fffffff) << 4;
    destination[19] |= (source[44] & 0x1fffffff) >> 25;
    destination[20]  = (source[44] & 0x1fffffff) << 39;
    destination[20] |= (source[45] & 0x1fffffff) << 10;
    destination[20] |= (source[46] & 0x1fffffff) >> 19;
    destination[21]  = (source[46] & 0x1fffffff) << 45;
    destination[21] |= (source[47] & 0x1fffffff) << 16;
    destination[21] |= (source[48] & 0x1fffffff) >> 13;
    destination[22]  = (source[48] & 0x1fffffff) << 51;
    destination[22] |= (source[49] & 0x1fffffff) << 22;
    destination[22] |= (source[50] & 0x1fffffff) >> 7;
    destination[23]  = (source[50] & 0x1fffffff) << 57;
    destination[23] |= (source[51] & 0x1fffffff) << 28;
    destination[23] |= (source[52] & 0x1fffffff) >> 1;
    destination[24]  = (source[52] & 0x1fffffff) << 63;
    destination[24] |= (source[53] & 0x1fffffff) << 34;
    destination[24] |= (source[54] & 0x1fffffff) << 5;
    destination[24] |= (source[55] & 0x1fffffff) >> 24;
    destination[25]  = (source[55] & 0x1fffffff) << 40;
    destination[25] |= (source[56] & 0x1fffffff) << 11;
    destination[25] |= (source[57] & 0x1fffffff) >> 18;
    destination[26]  = (source[57] & 0x1fffffff) << 46;
    destination[26] |= (source[58] & 0x1fffffff) << 17;
    destination[26] |= (source[59] & 0x1fffffff) >> 12;
    destination[27]  = (source[59] & 0x1fffffff) << 52;
    destination[27] |= (source[60] & 0x1fffffff) << 23;
    destination[27] |= (source[61] & 0x1fffffff) >> 6;
    destination[28]  = (source[61] & 0x1fffffff) << 58;
    destination[28] |= (source[62] & 0x1fffffff) << 29;
    destination[28] |= (source[63] & 0x1fffffff) << 0;
  }
  static inline
  void unpack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] >> 35) & 0x1fffffff;
    destination[1]  = (source[0] >> 6) & 0x1fffffff;
    destination[2]  = (source[0] << 23) & 0x1fffffff;
    destination[2] |= (source[1] >> 41) & 0x1fffffff;
    destination[3]  = (source[1] >> 12) & 0x1fffffff;
    destination[4]  = (source[1] << 17) & 0x1fffffff;
    destination[4] |= (source[2] >> 47) & 0x1fffffff;
    destination[5]  = (source[2] >> 18) & 0x1fffffff;
    destination[6]  = (source[2] << 11) & 0x1fffffff;
    destination[6] |= (source[3] >> 53) & 0x1fffffff;
    destination[7]  = (source[3] >> 24) & 0x1fffffff;
    destination[8]  = (source[3] << 5) & 0x1fffffff;
    destination[8] |= (source[4] >> 59) & 0x1fffffff;
    destination[9]  = (source[4] >> 30) & 0x1fffffff;
    destination[10]  = (source[4] >> 1) & 0x1fffffff;
    destination[11]  = (source[4] << 28) & 0x1fffffff;
    destination[11] |= (source[5] >> 36) & 0x1fffffff;
    destination[12]  = (source[5] >> 7) & 0x1fffffff;
    destination[13]  = (source[5] << 22) & 0x1fffffff;
    destination[13] |= (source[6] >> 42) & 0x1fffffff;
    destination[14]  = (source[6] >> 13) & 0x1fffffff;
    destination[15]  = (source[6] << 16) & 0x1fffffff;
    destination[15] |= (source[7] >> 48) & 0x1fffffff;
    destination[16]  = (source[7] >> 19) & 0x1fffffff;
    destination[17]  = (source[7] << 10) & 0x1fffffff;
    destination[17] |= (source[8] >> 54) & 0x1fffffff;
    destination[18]  = (source[8] >> 25) & 0x1fffffff;
    destination[19]  = (source[8] << 4) & 0x1fffffff;
    destination[19] |= (source[9] >> 60) & 0x1fffffff;
    destination[20]  = (source[9] >> 31) & 0x1fffffff;
    destination[21]  = (source[9] >> 2) & 0x1fffffff;
    destination[22]  = (source[9] << 27) & 0x1fffffff;
    destination[22] |= (source[10] >> 37) & 0x1fffffff;
    destination[23]  = (source[10] >> 8) & 0x1fffffff;
    destination[24]  = (source[10] << 21) & 0x1fffffff;
    destination[24] |= (source[11] >> 43) & 0x1fffffff;
    destination[25]  = (source[11] >> 14) & 0x1fffffff;
    destination[26]  = (source[11] << 15) & 0x1fffffff;
    destination[26] |= (source[12] >> 49) & 0x1fffffff;
    destination[27]  = (source[12] >> 20) & 0x1fffffff;
    destination[28]  = (source[12] << 9) & 0x1fffffff;
    destination[28] |= (source[13] >> 55) & 0x1fffffff;
    destination[29]  = (source[13] >> 26) & 0x1fffffff;
    destination[30]  = (source[13] << 3) & 0x1fffffff;
    destination[30] |= (source[14] >> 61) & 0x1fffffff;
    destination[31]  = (source[14] >> 32) & 0x1fffffff;
    destination[32]  = (source[14] >> 3) & 0x1fffffff;
    destination[33]  = (source[14] << 26) & 0x1fffffff;
    destination[33] |= (source[15] >> 38) & 0x1fffffff;
    destination[34]  = (source[15] >> 9) & 0x1fffffff;
    destination[35]  = (source[15] << 20) & 0x1fffffff;
    destination[35] |= (source[16] >> 44) & 0x1fffffff;
    destination[36]  = (source[16] >> 15) & 0x1fffffff;
    destination[37]  = (source[16] << 14) & 0x1fffffff;
    destination[37] |= (source[17] >> 50) & 0x1fffffff;
    destination[38]  = (source[17] >> 21) & 0x1fffffff;
    destination[39]  = (source[17] << 8) & 0x1fffffff;
    destination[39] |= (source[18] >> 56) & 0x1fffffff;
    destination[40]  = (source[18] >> 27) & 0x1fffffff;
    destination[41]  = (source[18] << 2) & 0x1fffffff;
    destination[41] |= (source[19] >> 62) & 0x1fffffff;
    destination[42]  = (source[19] >> 33) & 0x1fffffff;
    destination[43]  = (source[19] >> 4) & 0x1fffffff;
    destination[44]  = (source[19] << 25) & 0x1fffffff;
    destination[44] |= (source[20] >> 39) & 0x1fffffff;
    destination[45]  = (source[20] >> 10) & 0x1fffffff;
    destination[46]  = (source[20] << 19) & 0x1fffffff;
    destination[46] |= (source[21] >> 45) & 0x1fffffff;
    destination[47]  = (source[21] >> 16) & 0x1fffffff;
    destination[48]  = (source[21] << 13) & 0x1fffffff;
    destination[48] |= (source[22] >> 51) & 0x1fffffff;
    destination[49]  = (source[22] >> 22) & 0x1fffffff;
    destination[50]  = (source[22] << 7) & 0x1fffffff;
    destination[50] |= (source[23] >> 57) & 0x1fffffff;
    destination[51]  = (source[23] >> 28) & 0x1fffffff;
    destination[52]  = (source[23] << 1) & 0x1fffffff;
    destination[52] |= (source[24] >> 63) & 0x1fffffff;
    destination[53]  = (source[24] >> 34) & 0x1fffffff;
    destination[54]  = (source[24] >> 5) & 0x1fffffff;
    destination[55]  = (source[24] << 24) & 0x1fffffff;
    destination[55] |= (source[25] >> 40) & 0x1fffffff;
    destination[56]  = (source[25] >> 11) & 0x1fffffff;
    destination[57]  = (source[25] << 18) & 0x1fffffff;
    destination[57] |= (source[26] >> 46) & 0x1fffffff;
    destination[58]  = (source[26] >> 17) & 0x1fffffff;
    destination[59]  = (source[26] << 12) & 0x1fffffff;
    destination[59] |= (source[27] >> 52) & 0x1fffffff;
    destination[60]  = (source[27] >> 23) & 0x1fffffff;
    destination[61]  = (source[27] << 6) & 0x1fffffff;
    destination[61] |= (source[28] >> 58) & 0x1fffffff;
    destination[62]  = (source[28] >> 29) & 0x1fffffff;
    destination[63]  = (source[28] >> 0) & 0x1fffffff;
  }
};
template <typename Tp>
struct __struct_bitpack_impl<Tp,8,30>
{
  static const size_t unit_size = 64;
  static const size_t bits_total = 1920;
  static const size_t loop_total = 64;
  static const size_t bit_size = 30;
  static const Tp     mask = 0x3fffffff;
  static inline
  void pack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] & 0x3fffffff) << 34;
    destination[0] |= (source[1] & 0x3fffffff) << 4;
    destination[0] |= (source[2] & 0x3fffffff) >> 26;
    destination[1]  = (source[2] & 0x3fffffff) << 38;
    destination[1] |= (source[3] & 0x3fffffff) << 8;
    destination[1] |= (source[4] & 0x3fffffff) >> 22;
    destination[2]  = (source[4] & 0x3fffffff) << 42;
    destination[2] |= (source[5] & 0x3fffffff) << 12;
    destination[2] |= (source[6] & 0x3fffffff) >> 18;
    destination[3]  = (source[6] & 0x3fffffff) << 46;
    destination[3] |= (source[7] & 0x3fffffff) << 16;
    destination[3] |= (source[8] & 0x3fffffff) >> 14;
    destination[4]  = (source[8] & 0x3fffffff) << 50;
    destination[4] |= (source[9] & 0x3fffffff) << 20;
    destination[4] |= (source[10] & 0x3fffffff) >> 10;
    destination[5]  = (source[10] & 0x3fffffff) << 54;
    destination[5] |= (source[11] & 0x3fffffff) << 24;
    destination[5] |= (source[12] & 0x3fffffff) >> 6;
    destination[6]  = (source[12] & 0x3fffffff) << 58;
    destination[6] |= (source[13] & 0x3fffffff) << 28;
    destination[6] |= (source[14] & 0x3fffffff) >> 2;
    destination[7]  = (source[14] & 0x3fffffff) << 62;
    destination[7] |= (source[15] & 0x3fffffff) << 32;
    destination[7] |= (source[16] & 0x3fffffff) << 2;
    destination[7] |= (source[17] & 0x3fffffff) >> 28;
    destination[8]  = (source[17] & 0x3fffffff) << 36;
    destination[8] |= (source[18] & 0x3fffffff) << 6;
    destination[8] |= (source[19] & 0x3fffffff) >> 24;
    destination[9]  = (source[19] & 0x3fffffff) << 40;
    destination[9] |= (source[20] & 0x3fffffff) << 10;
    destination[9] |= (source[21] & 0x3fffffff) >> 20;
    destination[10]  = (source[21] & 0x3fffffff) << 44;
    destination[10] |= (source[22] & 0x3fffffff) << 14;
    destination[10] |= (source[23] & 0x3fffffff) >> 16;
    destination[11]  = (source[23] & 0x3fffffff) << 48;
    destination[11] |= (source[24] & 0x3fffffff) << 18;
    destination[11] |= (source[25] & 0x3fffffff) >> 12;
    destination[12]  = (source[25] & 0x3fffffff) << 52;
    destination[12] |= (source[26] & 0x3fffffff) << 22;
    destination[12] |= (source[27] & 0x3fffffff) >> 8;
    destination[13]  = (source[27] & 0x3fffffff) << 56;
    destination[13] |= (source[28] & 0x3fffffff) << 26;
    destination[13] |= (source[29] & 0x3fffffff) >> 4;
    destination[14]  = (source[29] & 0x3fffffff) << 60;
    destination[14] |= (source[30] & 0x3fffffff) << 30;
    destination[14] |= (source[31] & 0x3fffffff) << 0;
    destination[15]  = (source[32] & 0x3fffffff) << 34;
    destination[15] |= (source[33] & 0x3fffffff) << 4;
    destination[15] |= (source[34] & 0x3fffffff) >> 26;
    destination[16]  = (source[34] & 0x3fffffff) << 38;
    destination[16] |= (source[35] & 0x3fffffff) << 8;
    destination[16] |= (source[36] & 0x3fffffff) >> 22;
    destination[17]  = (source[36] & 0x3fffffff) << 42;
    destination[17] |= (source[37] & 0x3fffffff) << 12;
    destination[17] |= (source[38] & 0x3fffffff) >> 18;
    destination[18]  = (source[38] & 0x3fffffff) << 46;
    destination[18] |= (source[39] & 0x3fffffff) << 16;
    destination[18] |= (source[40] & 0x3fffffff) >> 14;
    destination[19]  = (source[40] & 0x3fffffff) << 50;
    destination[19] |= (source[41] & 0x3fffffff) << 20;
    destination[19] |= (source[42] & 0x3fffffff) >> 10;
    destination[20]  = (source[42] & 0x3fffffff) << 54;
    destination[20] |= (source[43] & 0x3fffffff) << 24;
    destination[20] |= (source[44] & 0x3fffffff) >> 6;
    destination[21]  = (source[44] & 0x3fffffff) << 58;
    destination[21] |= (source[45] & 0x3fffffff) << 28;
    destination[21] |= (source[46] & 0x3fffffff) >> 2;
    destination[22]  = (source[46] & 0x3fffffff) << 62;
    destination[22] |= (source[47] & 0x3fffffff) << 32;
    destination[22] |= (source[48] & 0x3fffffff) << 2;
    destination[22] |= (source[49] & 0x3fffffff) >> 28;
    destination[23]  = (source[49] & 0x3fffffff) << 36;
    destination[23] |= (source[50] & 0x3fffffff) << 6;
    destination[23] |= (source[51] & 0x3fffffff) >> 24;
    destination[24]  = (source[51] & 0x3fffffff) << 40;
    destination[24] |= (source[52] & 0x3fffffff) << 10;
    destination[24] |= (source[53] & 0x3fffffff) >> 20;
    destination[25]  = (source[53] & 0x3fffffff) << 44;
    destination[25] |= (source[54] & 0x3fffffff) << 14;
    destination[25] |= (source[55] & 0x3fffffff) >> 16;
    destination[26]  = (source[55] & 0x3fffffff) << 48;
    destination[26] |= (source[56] & 0x3fffffff) << 18;
    destination[26] |= (source[57] & 0x3fffffff) >> 12;
    destination[27]  = (source[57] & 0x3fffffff) << 52;
    destination[27] |= (source[58] & 0x3fffffff) << 22;
    destination[27] |= (source[59] & 0x3fffffff) >> 8;
    destination[28]  = (source[59] & 0x3fffffff) << 56;
    destination[28] |= (source[60] & 0x3fffffff) << 26;
    destination[28] |= (source[61] & 0x3fffffff) >> 4;
    destination[29]  = (source[61] & 0x3fffffff) << 60;
    destination[29] |= (source[62] & 0x3fffffff) << 30;
    destination[29] |= (source[63] & 0x3fffffff) << 0;
  }
  static inline
  void unpack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] >> 34) & 0x3fffffff;
    destination[1]  = (source[0] >> 4) & 0x3fffffff;
    destination[2]  = (source[0] << 26) & 0x3fffffff;
    destination[2] |= (source[1] >> 38) & 0x3fffffff;
    destination[3]  = (source[1] >> 8) & 0x3fffffff;
    destination[4]  = (source[1] << 22) & 0x3fffffff;
    destination[4] |= (source[2] >> 42) & 0x3fffffff;
    destination[5]  = (source[2] >> 12) & 0x3fffffff;
    destination[6]  = (source[2] << 18) & 0x3fffffff;
    destination[6] |= (source[3] >> 46) & 0x3fffffff;
    destination[7]  = (source[3] >> 16) & 0x3fffffff;
    destination[8]  = (source[3] << 14) & 0x3fffffff;
    destination[8] |= (source[4] >> 50) & 0x3fffffff;
    destination[9]  = (source[4] >> 20) & 0x3fffffff;
    destination[10]  = (source[4] << 10) & 0x3fffffff;
    destination[10] |= (source[5] >> 54) & 0x3fffffff;
    destination[11]  = (source[5] >> 24) & 0x3fffffff;
    destination[12]  = (source[5] << 6) & 0x3fffffff;
    destination[12] |= (source[6] >> 58) & 0x3fffffff;
    destination[13]  = (source[6] >> 28) & 0x3fffffff;
    destination[14]  = (source[6] << 2) & 0x3fffffff;
    destination[14] |= (source[7] >> 62) & 0x3fffffff;
    destination[15]  = (source[7] >> 32) & 0x3fffffff;
    destination[16]  = (source[7] >> 2) & 0x3fffffff;
    destination[17]  = (source[7] << 28) & 0x3fffffff;
    destination[17] |= (source[8] >> 36) & 0x3fffffff;
    destination[18]  = (source[8] >> 6) & 0x3fffffff;
    destination[19]  = (source[8] << 24) & 0x3fffffff;
    destination[19] |= (source[9] >> 40) & 0x3fffffff;
    destination[20]  = (source[9] >> 10) & 0x3fffffff;
    destination[21]  = (source[9] << 20) & 0x3fffffff;
    destination[21] |= (source[10] >> 44) & 0x3fffffff;
    destination[22]  = (source[10] >> 14) & 0x3fffffff;
    destination[23]  = (source[10] << 16) & 0x3fffffff;
    destination[23] |= (source[11] >> 48) & 0x3fffffff;
    destination[24]  = (source[11] >> 18) & 0x3fffffff;
    destination[25]  = (source[11] << 12) & 0x3fffffff;
    destination[25] |= (source[12] >> 52) & 0x3fffffff;
    destination[26]  = (source[12] >> 22) & 0x3fffffff;
    destination[27]  = (source[12] << 8) & 0x3fffffff;
    destination[27] |= (source[13] >> 56) & 0x3fffffff;
    destination[28]  = (source[13] >> 26) & 0x3fffffff;
    destination[29]  = (source[13] << 4) & 0x3fffffff;
    destination[29] |= (source[14] >> 60) & 0x3fffffff;
    destination[30]  = (source[14] >> 30) & 0x3fffffff;
    destination[31]  = (source[14] >> 0) & 0x3fffffff;
    destination[32]  = (source[15] >> 34) & 0x3fffffff;
    destination[33]  = (source[15] >> 4) & 0x3fffffff;
    destination[34]  = (source[15] << 26) & 0x3fffffff;
    destination[34] |= (source[16] >> 38) & 0x3fffffff;
    destination[35]  = (source[16] >> 8) & 0x3fffffff;
    destination[36]  = (source[16] << 22) & 0x3fffffff;
    destination[36] |= (source[17] >> 42) & 0x3fffffff;
    destination[37]  = (source[17] >> 12) & 0x3fffffff;
    destination[38]  = (source[17] << 18) & 0x3fffffff;
    destination[38] |= (source[18] >> 46) & 0x3fffffff;
    destination[39]  = (source[18] >> 16) & 0x3fffffff;
    destination[40]  = (source[18] << 14) & 0x3fffffff;
    destination[40] |= (source[19] >> 50) & 0x3fffffff;
    destination[41]  = (source[19] >> 20) & 0x3fffffff;
    destination[42]  = (source[19] << 10) & 0x3fffffff;
    destination[42] |= (source[20] >> 54) & 0x3fffffff;
    destination[43]  = (source[20] >> 24) & 0x3fffffff;
    destination[44]  = (source[20] << 6) & 0x3fffffff;
    destination[44] |= (source[21] >> 58) & 0x3fffffff;
    destination[45]  = (source[21] >> 28) & 0x3fffffff;
    destination[46]  = (source[21] << 2) & 0x3fffffff;
    destination[46] |= (source[22] >> 62) & 0x3fffffff;
    destination[47]  = (source[22] >> 32) & 0x3fffffff;
    destination[48]  = (source[22] >> 2) & 0x3fffffff;
    destination[49]  = (source[22] << 28) & 0x3fffffff;
    destination[49] |= (source[23] >> 36) & 0x3fffffff;
    destination[50]  = (source[23] >> 6) & 0x3fffffff;
    destination[51]  = (source[23] << 24) & 0x3fffffff;
    destination[51] |= (source[24] >> 40) & 0x3fffffff;
    destination[52]  = (source[24] >> 10) & 0x3fffffff;
    destination[53]  = (source[24] << 20) & 0x3fffffff;
    destination[53] |= (source[25] >> 44) & 0x3fffffff;
    destination[54]  = (source[25] >> 14) & 0x3fffffff;
    destination[55]  = (source[25] << 16) & 0x3fffffff;
    destination[55] |= (source[26] >> 48) & 0x3fffffff;
    destination[56]  = (source[26] >> 18) & 0x3fffffff;
    destination[57]  = (source[26] << 12) & 0x3fffffff;
    destination[57] |= (source[27] >> 52) & 0x3fffffff;
    destination[58]  = (source[27] >> 22) & 0x3fffffff;
    destination[59]  = (source[27] << 8) & 0x3fffffff;
    destination[59] |= (source[28] >> 56) & 0x3fffffff;
    destination[60]  = (source[28] >> 26) & 0x3fffffff;
    destination[61]  = (source[28] << 4) & 0x3fffffff;
    destination[61] |= (source[29] >> 60) & 0x3fffffff;
    destination[62]  = (source[29] >> 30) & 0x3fffffff;
    destination[63]  = (source[29] >> 0) & 0x3fffffff;
  }
};
template <typename Tp>
struct __struct_bitpack_impl<Tp,8,31>
{
  static const size_t unit_size = 64;
  static const size_t bits_total = 1984;
  static const size_t loop_total = 64;
  static const size_t bit_size = 31;
  static const Tp     mask = 0x7fffffff;
  static inline
  void pack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] & 0x7fffffff) << 33;
    destination[0] |= (source[1] & 0x7fffffff) << 2;
    destination[0] |= (source[2] & 0x7fffffff) >> 29;
    destination[1]  = (source[2] & 0x7fffffff) << 35;
    destination[1] |= (source[3] & 0x7fffffff) << 4;
    destination[1] |= (source[4] & 0x7fffffff) >> 27;
    destination[2]  = (source[4] & 0x7fffffff) << 37;
    destination[2] |= (source[5] & 0x7fffffff) << 6;
    destination[2] |= (source[6] & 0x7fffffff) >> 25;
    destination[3]  = (source[6] & 0x7fffffff) << 39;
    destination[3] |= (source[7] & 0x7fffffff) << 8;
    destination[3] |= (source[8] & 0x7fffffff) >> 23;
    destination[4]  = (source[8] & 0x7fffffff) << 41;
    destination[4] |= (source[9] & 0x7fffffff) << 10;
    destination[4] |= (source[10] & 0x7fffffff) >> 21;
    destination[5]  = (source[10] & 0x7fffffff) << 43;
    destination[5] |= (source[11] & 0x7fffffff) << 12;
    destination[5] |= (source[12] & 0x7fffffff) >> 19;
    destination[6]  = (source[12] & 0x7fffffff) << 45;
    destination[6] |= (source[13] & 0x7fffffff) << 14;
    destination[6] |= (source[14] & 0x7fffffff) >> 17;
    destination[7]  = (source[14] & 0x7fffffff) << 47;
    destination[7] |= (source[15] & 0x7fffffff) << 16;
    destination[7] |= (source[16] & 0x7fffffff) >> 15;
    destination[8]  = (source[16] & 0x7fffffff) << 49;
    destination[8] |= (source[17] & 0x7fffffff) << 18;
    destination[8] |= (source[18] & 0x7fffffff) >> 13;
    destination[9]  = (source[18] & 0x7fffffff) << 51;
    destination[9] |= (source[19] & 0x7fffffff) << 20;
    destination[9] |= (source[20] & 0x7fffffff) >> 11;
    destination[10]  = (source[20] & 0x7fffffff) << 53;
    destination[10] |= (source[21] & 0x7fffffff) << 22;
    destination[10] |= (source[22] & 0x7fffffff) >> 9;
    destination[11]  = (source[22] & 0x7fffffff) << 55;
    destination[11] |= (source[23] & 0x7fffffff) << 24;
    destination[11] |= (source[24] & 0x7fffffff) >> 7;
    destination[12]  = (source[24] & 0x7fffffff) << 57;
    destination[12] |= (source[25] & 0x7fffffff) << 26;
    destination[12] |= (source[26] & 0x7fffffff) >> 5;
    destination[13]  = (source[26] & 0x7fffffff) << 59;
    destination[13] |= (source[27] & 0x7fffffff) << 28;
    destination[13] |= (source[28] & 0x7fffffff) >> 3;
    destination[14]  = (source[28] & 0x7fffffff) << 61;
    destination[14] |= (source[29] & 0x7fffffff) << 30;
    destination[14] |= (source[30] & 0x7fffffff) >> 1;
    destination[15]  = (source[30] & 0x7fffffff) << 63;
    destination[15] |= (source[31] & 0x7fffffff) << 32;
    destination[15] |= (source[32] & 0x7fffffff) << 1;
    destination[15] |= (source[33] & 0x7fffffff) >> 30;
    destination[16]  = (source[33] & 0x7fffffff) << 34;
    destination[16] |= (source[34] & 0x7fffffff) << 3;
    destination[16] |= (source[35] & 0x7fffffff) >> 28;
    destination[17]  = (source[35] & 0x7fffffff) << 36;
    destination[17] |= (source[36] & 0x7fffffff) << 5;
    destination[17] |= (source[37] & 0x7fffffff) >> 26;
    destination[18]  = (source[37] & 0x7fffffff) << 38;
    destination[18] |= (source[38] & 0x7fffffff) << 7;
    destination[18] |= (source[39] & 0x7fffffff) >> 24;
    destination[19]  = (source[39] & 0x7fffffff) << 40;
    destination[19] |= (source[40] & 0x7fffffff) << 9;
    destination[19] |= (source[41] & 0x7fffffff) >> 22;
    destination[20]  = (source[41] & 0x7fffffff) << 42;
    destination[20] |= (source[42] & 0x7fffffff) << 11;
    destination[20] |= (source[43] & 0x7fffffff) >> 20;
    destination[21]  = (source[43] & 0x7fffffff) << 44;
    destination[21] |= (source[44] & 0x7fffffff) << 13;
    destination[21] |= (source[45] & 0x7fffffff) >> 18;
    destination[22]  = (source[45] & 0x7fffffff) << 46;
    destination[22] |= (source[46] & 0x7fffffff) << 15;
    destination[22] |= (source[47] & 0x7fffffff) >> 16;
    destination[23]  = (source[47] & 0x7fffffff) << 48;
    destination[23] |= (source[48] & 0x7fffffff) << 17;
    destination[23] |= (source[49] & 0x7fffffff) >> 14;
    destination[24]  = (source[49] & 0x7fffffff) << 50;
    destination[24] |= (source[50] & 0x7fffffff) << 19;
    destination[24] |= (source[51] & 0x7fffffff) >> 12;
    destination[25]  = (source[51] & 0x7fffffff) << 52;
    destination[25] |= (source[52] & 0x7fffffff) << 21;
    destination[25] |= (source[53] & 0x7fffffff) >> 10;
    destination[26]  = (source[53] & 0x7fffffff) << 54;
    destination[26] |= (source[54] & 0x7fffffff) << 23;
    destination[26] |= (source[55] & 0x7fffffff) >> 8;
    destination[27]  = (source[55] & 0x7fffffff) << 56;
    destination[27] |= (source[56] & 0x7fffffff) << 25;
    destination[27] |= (source[57] & 0x7fffffff) >> 6;
    destination[28]  = (source[57] & 0x7fffffff) << 58;
    destination[28] |= (source[58] & 0x7fffffff) << 27;
    destination[28] |= (source[59] & 0x7fffffff) >> 4;
    destination[29]  = (source[59] & 0x7fffffff) << 60;
    destination[29] |= (source[60] & 0x7fffffff) << 29;
    destination[29] |= (source[61] & 0x7fffffff) >> 2;
    destination[30]  = (source[61] & 0x7fffffff) << 62;
    destination[30] |= (source[62] & 0x7fffffff) << 31;
    destination[30] |= (source[63] & 0x7fffffff) << 0;
  }
  static inline
  void unpack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] >> 33) & 0x7fffffff;
    destination[1]  = (source[0] >> 2) & 0x7fffffff;
    destination[2]  = (source[0] << 29) & 0x7fffffff;
    destination[2] |= (source[1] >> 35) & 0x7fffffff;
    destination[3]  = (source[1] >> 4) & 0x7fffffff;
    destination[4]  = (source[1] << 27) & 0x7fffffff;
    destination[4] |= (source[2] >> 37) & 0x7fffffff;
    destination[5]  = (source[2] >> 6) & 0x7fffffff;
    destination[6]  = (source[2] << 25) & 0x7fffffff;
    destination[6] |= (source[3] >> 39) & 0x7fffffff;
    destination[7]  = (source[3] >> 8) & 0x7fffffff;
    destination[8]  = (source[3] << 23) & 0x7fffffff;
    destination[8] |= (source[4] >> 41) & 0x7fffffff;
    destination[9]  = (source[4] >> 10) & 0x7fffffff;
    destination[10]  = (source[4] << 21) & 0x7fffffff;
    destination[10] |= (source[5] >> 43) & 0x7fffffff;
    destination[11]  = (source[5] >> 12) & 0x7fffffff;
    destination[12]  = (source[5] << 19) & 0x7fffffff;
    destination[12] |= (source[6] >> 45) & 0x7fffffff;
    destination[13]  = (source[6] >> 14) & 0x7fffffff;
    destination[14]  = (source[6] << 17) & 0x7fffffff;
    destination[14] |= (source[7] >> 47) & 0x7fffffff;
    destination[15]  = (source[7] >> 16) & 0x7fffffff;
    destination[16]  = (source[7] << 15) & 0x7fffffff;
    destination[16] |= (source[8] >> 49) & 0x7fffffff;
    destination[17]  = (source[8] >> 18) & 0x7fffffff;
    destination[18]  = (source[8] << 13) & 0x7fffffff;
    destination[18] |= (source[9] >> 51) & 0x7fffffff;
    destination[19]  = (source[9] >> 20) & 0x7fffffff;
    destination[20]  = (source[9] << 11) & 0x7fffffff;
    destination[20] |= (source[10] >> 53) & 0x7fffffff;
    destination[21]  = (source[10] >> 22) & 0x7fffffff;
    destination[22]  = (source[10] << 9) & 0x7fffffff;
    destination[22] |= (source[11] >> 55) & 0x7fffffff;
    destination[23]  = (source[11] >> 24) & 0x7fffffff;
    destination[24]  = (source[11] << 7) & 0x7fffffff;
    destination[24] |= (source[12] >> 57) & 0x7fffffff;
    destination[25]  = (source[12] >> 26) & 0x7fffffff;
    destination[26]  = (source[12] << 5) & 0x7fffffff;
    destination[26] |= (source[13] >> 59) & 0x7fffffff;
    destination[27]  = (source[13] >> 28) & 0x7fffffff;
    destination[28]  = (source[13] << 3) & 0x7fffffff;
    destination[28] |= (source[14] >> 61) & 0x7fffffff;
    destination[29]  = (source[14] >> 30) & 0x7fffffff;
    destination[30]  = (source[14] << 1) & 0x7fffffff;
    destination[30] |= (source[15] >> 63) & 0x7fffffff;
    destination[31]  = (source[15] >> 32) & 0x7fffffff;
    destination[32]  = (source[15] >> 1) & 0x7fffffff;
    destination[33]  = (source[15] << 30) & 0x7fffffff;
    destination[33] |= (source[16] >> 34) & 0x7fffffff;
    destination[34]  = (source[16] >> 3) & 0x7fffffff;
    destination[35]  = (source[16] << 28) & 0x7fffffff;
    destination[35] |= (source[17] >> 36) & 0x7fffffff;
    destination[36]  = (source[17] >> 5) & 0x7fffffff;
    destination[37]  = (source[17] << 26) & 0x7fffffff;
    destination[37] |= (source[18] >> 38) & 0x7fffffff;
    destination[38]  = (source[18] >> 7) & 0x7fffffff;
    destination[39]  = (source[18] << 24) & 0x7fffffff;
    destination[39] |= (source[19] >> 40) & 0x7fffffff;
    destination[40]  = (source[19] >> 9) & 0x7fffffff;
    destination[41]  = (source[19] << 22) & 0x7fffffff;
    destination[41] |= (source[20] >> 42) & 0x7fffffff;
    destination[42]  = (source[20] >> 11) & 0x7fffffff;
    destination[43]  = (source[20] << 20) & 0x7fffffff;
    destination[43] |= (source[21] >> 44) & 0x7fffffff;
    destination[44]  = (source[21] >> 13) & 0x7fffffff;
    destination[45]  = (source[21] << 18) & 0x7fffffff;
    destination[45] |= (source[22] >> 46) & 0x7fffffff;
    destination[46]  = (source[22] >> 15) & 0x7fffffff;
    destination[47]  = (source[22] << 16) & 0x7fffffff;
    destination[47] |= (source[23] >> 48) & 0x7fffffff;
    destination[48]  = (source[23] >> 17) & 0x7fffffff;
    destination[49]  = (source[23] << 14) & 0x7fffffff;
    destination[49] |= (source[24] >> 50) & 0x7fffffff;
    destination[50]  = (source[24] >> 19) & 0x7fffffff;
    destination[51]  = (source[24] << 12) & 0x7fffffff;
    destination[51] |= (source[25] >> 52) & 0x7fffffff;
    destination[52]  = (source[25] >> 21) & 0x7fffffff;
    destination[53]  = (source[25] << 10) & 0x7fffffff;
    destination[53] |= (source[26] >> 54) & 0x7fffffff;
    destination[54]  = (source[26] >> 23) & 0x7fffffff;
    destination[55]  = (source[26] << 8) & 0x7fffffff;
    destination[55] |= (source[27] >> 56) & 0x7fffffff;
    destination[56]  = (source[27] >> 25) & 0x7fffffff;
    destination[57]  = (source[27] << 6) & 0x7fffffff;
    destination[57] |= (source[28] >> 58) & 0x7fffffff;
    destination[58]  = (source[28] >> 27) & 0x7fffffff;
    destination[59]  = (source[28] << 4) & 0x7fffffff;
    destination[59] |= (source[29] >> 60) & 0x7fffffff;
    destination[60]  = (source[29] >> 29) & 0x7fffffff;
    destination[61]  = (source[29] << 2) & 0x7fffffff;
    destination[61] |= (source[30] >> 62) & 0x7fffffff;
    destination[62]  = (source[30] >> 31) & 0x7fffffff;
    destination[63]  = (source[30] >> 0) & 0x7fffffff;
  }
};
template <typename Tp>
struct __struct_bitpack_impl<Tp,8,32>
{
  static const size_t unit_size = 64;
  static const size_t bits_total = 2048;
  static const size_t loop_total = 64;
  static const size_t bit_size = 32;
  static const Tp     mask = 0xffffffffull;
  static inline
  void pack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] & 0xffffffffull) << 32;
    destination[0] |= (source[1] & 0xffffffffull) << 0;
    destination[1]  = (source[2] & 0xffffffffull) << 32;
    destination[1] |= (source[3] & 0xffffffffull) << 0;
    destination[2]  = (source[4] & 0xffffffffull) << 32;
    destination[2] |= (source[5] & 0xffffffffull) << 0;
    destination[3]  = (source[6] & 0xffffffffull) << 32;
    destination[3] |= (source[7] & 0xffffffffull) << 0;
    destination[4]  = (source[8] & 0xffffffffull) << 32;
    destination[4] |= (source[9] & 0xffffffffull) << 0;
    destination[5]  = (source[10] & 0xffffffffull) << 32;
    destination[5] |= (source[11] & 0xffffffffull) << 0;
    destination[6]  = (source[12] & 0xffffffffull) << 32;
    destination[6] |= (source[13] & 0xffffffffull) << 0;
    destination[7]  = (source[14] & 0xffffffffull) << 32;
    destination[7] |= (source[15] & 0xffffffffull) << 0;
    destination[8]  = (source[16] & 0xffffffffull) << 32;
    destination[8] |= (source[17] & 0xffffffffull) << 0;
    destination[9]  = (source[18] & 0xffffffffull) << 32;
    destination[9] |= (source[19] & 0xffffffffull) << 0;
    destination[10]  = (source[20] & 0xffffffffull) << 32;
    destination[10] |= (source[21] & 0xffffffffull) << 0;
    destination[11]  = (source[22] & 0xffffffffull) << 32;
    destination[11] |= (source[23] & 0xffffffffull) << 0;
    destination[12]  = (source[24] & 0xffffffffull) << 32;
    destination[12] |= (source[25] & 0xffffffffull) << 0;
    destination[13]  = (source[26] & 0xffffffffull) << 32;
    destination[13] |= (source[27] & 0xffffffffull) << 0;
    destination[14]  = (source[28] & 0xffffffffull) << 32;
    destination[14] |= (source[29] & 0xffffffffull) << 0;
    destination[15]  = (source[30] & 0xffffffffull) << 32;
    destination[15] |= (source[31] & 0xffffffffull) << 0;
    destination[16]  = (source[32] & 0xffffffffull) << 32;
    destination[16] |= (source[33] & 0xffffffffull) << 0;
    destination[17]  = (source[34] & 0xffffffffull) << 32;
    destination[17] |= (source[35] & 0xffffffffull) << 0;
    destination[18]  = (source[36] & 0xffffffffull) << 32;
    destination[18] |= (source[37] & 0xffffffffull) << 0;
    destination[19]  = (source[38] & 0xffffffffull) << 32;
    destination[19] |= (source[39] & 0xffffffffull) << 0;
    destination[20]  = (source[40] & 0xffffffffull) << 32;
    destination[20] |= (source[41] & 0xffffffffull) << 0;
    destination[21]  = (source[42] & 0xffffffffull) << 32;
    destination[21] |= (source[43] & 0xffffffffull) << 0;
    destination[22]  = (source[44] & 0xffffffffull) << 32;
    destination[22] |= (source[45] & 0xffffffffull) << 0;
    destination[23]  = (source[46] & 0xffffffffull) << 32;
    destination[23] |= (source[47] & 0xffffffffull) << 0;
    destination[24]  = (source[48] & 0xffffffffull) << 32;
    destination[24] |= (source[49] & 0xffffffffull) << 0;
    destination[25]  = (source[50] & 0xffffffffull) << 32;
    destination[25] |= (source[51] & 0xffffffffull) << 0;
    destination[26]  = (source[52] & 0xffffffffull) << 32;
    destination[26] |= (source[53] & 0xffffffffull) << 0;
    destination[27]  = (source[54] & 0xffffffffull) << 32;
    destination[27] |= (source[55] & 0xffffffffull) << 0;
    destination[28]  = (source[56] & 0xffffffffull) << 32;
    destination[28] |= (source[57] & 0xffffffffull) << 0;
    destination[29]  = (source[58] & 0xffffffffull) << 32;
    destination[29] |= (source[59] & 0xffffffffull) << 0;
    destination[30]  = (source[60] & 0xffffffffull) << 32;
    destination[30] |= (source[61] & 0xffffffffull) << 0;
    destination[31]  = (source[62] & 0xffffffffull) << 32;
    destination[31] |= (source[63] & 0xffffffffull) << 0;
  }
  static inline
  void unpack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] >> 32) & 0xffffffffull;
    destination[1]  = (source[0] >> 0) & 0xffffffffull;
    destination[2]  = (source[1] >> 32) & 0xffffffffull;
    destination[3]  = (source[1] >> 0) & 0xffffffffull;
    destination[4]  = (source[2] >> 32) & 0xffffffffull;
    destination[5]  = (source[2] >> 0) & 0xffffffffull;
    destination[6]  = (source[3] >> 32) & 0xffffffffull;
    destination[7]  = (source[3] >> 0) & 0xffffffffull;
    destination[8]  = (source[4] >> 32) & 0xffffffffull;
    destination[9]  = (source[4] >> 0) & 0xffffffffull;
    destination[10]  = (source[5] >> 32) & 0xffffffffull;
    destination[11]  = (source[5] >> 0) & 0xffffffffull;
    destination[12]  = (source[6] >> 32) & 0xffffffffull;
    destination[13]  = (source[6] >> 0) & 0xffffffffull;
    destination[14]  = (source[7] >> 32) & 0xffffffffull;
    destination[15]  = (source[7] >> 0) & 0xffffffffull;
    destination[16]  = (source[8] >> 32) & 0xffffffffull;
    destination[17]  = (source[8] >> 0) & 0xffffffffull;
    destination[18]  = (source[9] >> 32) & 0xffffffffull;
    destination[19]  = (source[9] >> 0) & 0xffffffffull;
    destination[20]  = (source[10] >> 32) & 0xffffffffull;
    destination[21]  = (source[10] >> 0) & 0xffffffffull;
    destination[22]  = (source[11] >> 32) & 0xffffffffull;
    destination[23]  = (source[11] >> 0) & 0xffffffffull;
    destination[24]  = (source[12] >> 32) & 0xffffffffull;
    destination[25]  = (source[12] >> 0) & 0xffffffffull;
    destination[26]  = (source[13] >> 32) & 0xffffffffull;
    destination[27]  = (source[13] >> 0) & 0xffffffffull;
    destination[28]  = (source[14] >> 32) & 0xffffffffull;
    destination[29]  = (source[14] >> 0) & 0xffffffffull;
    destination[30]  = (source[15] >> 32) & 0xffffffffull;
    destination[31]  = (source[15] >> 0) & 0xffffffffull;
    destination[32]  = (source[16] >> 32) & 0xffffffffull;
    destination[33]  = (source[16] >> 0) & 0xffffffffull;
    destination[34]  = (source[17] >> 32) & 0xffffffffull;
    destination[35]  = (source[17] >> 0) & 0xffffffffull;
    destination[36]  = (source[18] >> 32) & 0xffffffffull;
    destination[37]  = (source[18] >> 0) & 0xffffffffull;
    destination[38]  = (source[19] >> 32) & 0xffffffffull;
    destination[39]  = (source[19] >> 0) & 0xffffffffull;
    destination[40]  = (source[20] >> 32) & 0xffffffffull;
    destination[41]  = (source[20] >> 0) & 0xffffffffull;
    destination[42]  = (source[21] >> 32) & 0xffffffffull;
    destination[43]  = (source[21] >> 0) & 0xffffffffull;
    destination[44]  = (source[22] >> 32) & 0xffffffffull;
    destination[45]  = (source[22] >> 0) & 0xffffffffull;
    destination[46]  = (source[23] >> 32) & 0xffffffffull;
    destination[47]  = (source[23] >> 0) & 0xffffffffull;
    destination[48]  = (source[24] >> 32) & 0xffffffffull;
    destination[49]  = (source[24] >> 0) & 0xffffffffull;
    destination[50]  = (source[25] >> 32) & 0xffffffffull;
    destination[51]  = (source[25] >> 0) & 0xffffffffull;
    destination[52]  = (source[26] >> 32) & 0xffffffffull;
    destination[53]  = (source[26] >> 0) & 0xffffffffull;
    destination[54]  = (source[27] >> 32) & 0xffffffffull;
    destination[55]  = (source[27] >> 0) & 0xffffffffull;
    destination[56]  = (source[28] >> 32) & 0xffffffffull;
    destination[57]  = (source[28] >> 0) & 0xffffffffull;
    destination[58]  = (source[29] >> 32) & 0xffffffffull;
    destination[59]  = (source[29] >> 0) & 0xffffffffull;
    destination[60]  = (source[30] >> 32) & 0xffffffffull;
    destination[61]  = (source[30] >> 0) & 0xffffffffull;
    destination[62]  = (source[31] >> 32) & 0xffffffffull;
    destination[63]  = (source[31] >> 0) & 0xffffffffull;
  }
};
template <typename Tp>
struct __struct_bitpack_impl<Tp,8,33>
{
  static const size_t unit_size = 64;
  static const size_t bits_total = 2112;
  static const size_t loop_total = 64;
  static const size_t bit_size = 33;
  static const Tp     mask = 0x1ffffffffull;
  static inline
  void pack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] & 0x1ffffffffull) << 31;
    destination[0] |= (source[1] & 0x1ffffffffull) >> 2;
    destination[1]  = (source[1] & 0x1ffffffffull) << 62;
    destination[1] |= (source[2] & 0x1ffffffffull) << 29;
    destination[1] |= (source[3] & 0x1ffffffffull) >> 4;
    destination[2]  = (source[3] & 0x1ffffffffull) << 60;
    destination[2] |= (source[4] & 0x1ffffffffull) << 27;
    destination[2] |= (source[5] & 0x1ffffffffull) >> 6;
    destination[3]  = (source[5] & 0x1ffffffffull) << 58;
    destination[3] |= (source[6] & 0x1ffffffffull) << 25;
    destination[3] |= (source[7] & 0x1ffffffffull) >> 8;
    destination[4]  = (source[7] & 0x1ffffffffull) << 56;
    destination[4] |= (source[8] & 0x1ffffffffull) << 23;
    destination[4] |= (source[9] & 0x1ffffffffull) >> 10;
    destination[5]  = (source[9] & 0x1ffffffffull) << 54;
    destination[5] |= (source[10] & 0x1ffffffffull) << 21;
    destination[5] |= (source[11] & 0x1ffffffffull) >> 12;
    destination[6]  = (source[11] & 0x1ffffffffull) << 52;
    destination[6] |= (source[12] & 0x1ffffffffull) << 19;
    destination[6] |= (source[13] & 0x1ffffffffull) >> 14;
    destination[7]  = (source[13] & 0x1ffffffffull) << 50;
    destination[7] |= (source[14] & 0x1ffffffffull) << 17;
    destination[7] |= (source[15] & 0x1ffffffffull) >> 16;
    destination[8]  = (source[15] & 0x1ffffffffull) << 48;
    destination[8] |= (source[16] & 0x1ffffffffull) << 15;
    destination[8] |= (source[17] & 0x1ffffffffull) >> 18;
    destination[9]  = (source[17] & 0x1ffffffffull) << 46;
    destination[9] |= (source[18] & 0x1ffffffffull) << 13;
    destination[9] |= (source[19] & 0x1ffffffffull) >> 20;
    destination[10]  = (source[19] & 0x1ffffffffull) << 44;
    destination[10] |= (source[20] & 0x1ffffffffull) << 11;
    destination[10] |= (source[21] & 0x1ffffffffull) >> 22;
    destination[11]  = (source[21] & 0x1ffffffffull) << 42;
    destination[11] |= (source[22] & 0x1ffffffffull) << 9;
    destination[11] |= (source[23] & 0x1ffffffffull) >> 24;
    destination[12]  = (source[23] & 0x1ffffffffull) << 40;
    destination[12] |= (source[24] & 0x1ffffffffull) << 7;
    destination[12] |= (source[25] & 0x1ffffffffull) >> 26;
    destination[13]  = (source[25] & 0x1ffffffffull) << 38;
    destination[13] |= (source[26] & 0x1ffffffffull) << 5;
    destination[13] |= (source[27] & 0x1ffffffffull) >> 28;
    destination[14]  = (source[27] & 0x1ffffffffull) << 36;
    destination[14] |= (source[28] & 0x1ffffffffull) << 3;
    destination[14] |= (source[29] & 0x1ffffffffull) >> 30;
    destination[15]  = (source[29] & 0x1ffffffffull) << 34;
    destination[15] |= (source[30] & 0x1ffffffffull) << 1;
    destination[15] |= (source[31] & 0x1ffffffffull) >> 32;
    destination[16]  = (source[31] & 0x1ffffffffull) << 32;
    destination[16] |= (source[32] & 0x1ffffffffull) >> 1;
    destination[17]  = (source[32] & 0x1ffffffffull) << 63;
    destination[17] |= (source[33] & 0x1ffffffffull) << 30;
    destination[17] |= (source[34] & 0x1ffffffffull) >> 3;
    destination[18]  = (source[34] & 0x1ffffffffull) << 61;
    destination[18] |= (source[35] & 0x1ffffffffull) << 28;
    destination[18] |= (source[36] & 0x1ffffffffull) >> 5;
    destination[19]  = (source[36] & 0x1ffffffffull) << 59;
    destination[19] |= (source[37] & 0x1ffffffffull) << 26;
    destination[19] |= (source[38] & 0x1ffffffffull) >> 7;
    destination[20]  = (source[38] & 0x1ffffffffull) << 57;
    destination[20] |= (source[39] & 0x1ffffffffull) << 24;
    destination[20] |= (source[40] & 0x1ffffffffull) >> 9;
    destination[21]  = (source[40] & 0x1ffffffffull) << 55;
    destination[21] |= (source[41] & 0x1ffffffffull) << 22;
    destination[21] |= (source[42] & 0x1ffffffffull) >> 11;
    destination[22]  = (source[42] & 0x1ffffffffull) << 53;
    destination[22] |= (source[43] & 0x1ffffffffull) << 20;
    destination[22] |= (source[44] & 0x1ffffffffull) >> 13;
    destination[23]  = (source[44] & 0x1ffffffffull) << 51;
    destination[23] |= (source[45] & 0x1ffffffffull) << 18;
    destination[23] |= (source[46] & 0x1ffffffffull) >> 15;
    destination[24]  = (source[46] & 0x1ffffffffull) << 49;
    destination[24] |= (source[47] & 0x1ffffffffull) << 16;
    destination[24] |= (source[48] & 0x1ffffffffull) >> 17;
    destination[25]  = (source[48] & 0x1ffffffffull) << 47;
    destination[25] |= (source[49] & 0x1ffffffffull) << 14;
    destination[25] |= (source[50] & 0x1ffffffffull) >> 19;
    destination[26]  = (source[50] & 0x1ffffffffull) << 45;
    destination[26] |= (source[51] & 0x1ffffffffull) << 12;
    destination[26] |= (source[52] & 0x1ffffffffull) >> 21;
    destination[27]  = (source[52] & 0x1ffffffffull) << 43;
    destination[27] |= (source[53] & 0x1ffffffffull) << 10;
    destination[27] |= (source[54] & 0x1ffffffffull) >> 23;
    destination[28]  = (source[54] & 0x1ffffffffull) << 41;
    destination[28] |= (source[55] & 0x1ffffffffull) << 8;
    destination[28] |= (source[56] & 0x1ffffffffull) >> 25;
    destination[29]  = (source[56] & 0x1ffffffffull) << 39;
    destination[29] |= (source[57] & 0x1ffffffffull) << 6;
    destination[29] |= (source[58] & 0x1ffffffffull) >> 27;
    destination[30]  = (source[58] & 0x1ffffffffull) << 37;
    destination[30] |= (source[59] & 0x1ffffffffull) << 4;
    destination[30] |= (source[60] & 0x1ffffffffull) >> 29;
    destination[31]  = (source[60] & 0x1ffffffffull) << 35;
    destination[31] |= (source[61] & 0x1ffffffffull) << 2;
    destination[31] |= (source[62] & 0x1ffffffffull) >> 31;
    destination[32]  = (source[62] & 0x1ffffffffull) << 33;
    destination[32] |= (source[63] & 0x1ffffffffull) << 0;
  }
  static inline
  void unpack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] >> 31) & 0x1ffffffffull;
    destination[1]  = (source[0] << 2) & 0x1ffffffffull;
    destination[1] |= (source[1] >> 62) & 0x1ffffffffull;
    destination[2]  = (source[1] >> 29) & 0x1ffffffffull;
    destination[3]  = (source[1] << 4) & 0x1ffffffffull;
    destination[3] |= (source[2] >> 60) & 0x1ffffffffull;
    destination[4]  = (source[2] >> 27) & 0x1ffffffffull;
    destination[5]  = (source[2] << 6) & 0x1ffffffffull;
    destination[5] |= (source[3] >> 58) & 0x1ffffffffull;
    destination[6]  = (source[3] >> 25) & 0x1ffffffffull;
    destination[7]  = (source[3] << 8) & 0x1ffffffffull;
    destination[7] |= (source[4] >> 56) & 0x1ffffffffull;
    destination[8]  = (source[4] >> 23) & 0x1ffffffffull;
    destination[9]  = (source[4] << 10) & 0x1ffffffffull;
    destination[9] |= (source[5] >> 54) & 0x1ffffffffull;
    destination[10]  = (source[5] >> 21) & 0x1ffffffffull;
    destination[11]  = (source[5] << 12) & 0x1ffffffffull;
    destination[11] |= (source[6] >> 52) & 0x1ffffffffull;
    destination[12]  = (source[6] >> 19) & 0x1ffffffffull;
    destination[13]  = (source[6] << 14) & 0x1ffffffffull;
    destination[13] |= (source[7] >> 50) & 0x1ffffffffull;
    destination[14]  = (source[7] >> 17) & 0x1ffffffffull;
    destination[15]  = (source[7] << 16) & 0x1ffffffffull;
    destination[15] |= (source[8] >> 48) & 0x1ffffffffull;
    destination[16]  = (source[8] >> 15) & 0x1ffffffffull;
    destination[17]  = (source[8] << 18) & 0x1ffffffffull;
    destination[17] |= (source[9] >> 46) & 0x1ffffffffull;
    destination[18]  = (source[9] >> 13) & 0x1ffffffffull;
    destination[19]  = (source[9] << 20) & 0x1ffffffffull;
    destination[19] |= (source[10] >> 44) & 0x1ffffffffull;
    destination[20]  = (source[10] >> 11) & 0x1ffffffffull;
    destination[21]  = (source[10] << 22) & 0x1ffffffffull;
    destination[21] |= (source[11] >> 42) & 0x1ffffffffull;
    destination[22]  = (source[11] >> 9) & 0x1ffffffffull;
    destination[23]  = (source[11] << 24) & 0x1ffffffffull;
    destination[23] |= (source[12] >> 40) & 0x1ffffffffull;
    destination[24]  = (source[12] >> 7) & 0x1ffffffffull;
    destination[25]  = (source[12] << 26) & 0x1ffffffffull;
    destination[25] |= (source[13] >> 38) & 0x1ffffffffull;
    destination[26]  = (source[13] >> 5) & 0x1ffffffffull;
    destination[27]  = (source[13] << 28) & 0x1ffffffffull;
    destination[27] |= (source[14] >> 36) & 0x1ffffffffull;
    destination[28]  = (source[14] >> 3) & 0x1ffffffffull;
    destination[29]  = (source[14] << 30) & 0x1ffffffffull;
    destination[29] |= (source[15] >> 34) & 0x1ffffffffull;
    destination[30]  = (source[15] >> 1) & 0x1ffffffffull;
    destination[31]  = (source[15] << 32) & 0x1ffffffffull;
    destination[31] |= (source[16] >> 32) & 0x1ffffffffull;
    destination[32]  = (source[16] << 1) & 0x1ffffffffull;
    destination[32] |= (source[17] >> 63) & 0x1ffffffffull;
    destination[33]  = (source[17] >> 30) & 0x1ffffffffull;
    destination[34]  = (source[17] << 3) & 0x1ffffffffull;
    destination[34] |= (source[18] >> 61) & 0x1ffffffffull;
    destination[35]  = (source[18] >> 28) & 0x1ffffffffull;
    destination[36]  = (source[18] << 5) & 0x1ffffffffull;
    destination[36] |= (source[19] >> 59) & 0x1ffffffffull;
    destination[37]  = (source[19] >> 26) & 0x1ffffffffull;
    destination[38]  = (source[19] << 7) & 0x1ffffffffull;
    destination[38] |= (source[20] >> 57) & 0x1ffffffffull;
    destination[39]  = (source[20] >> 24) & 0x1ffffffffull;
    destination[40]  = (source[20] << 9) & 0x1ffffffffull;
    destination[40] |= (source[21] >> 55) & 0x1ffffffffull;
    destination[41]  = (source[21] >> 22) & 0x1ffffffffull;
    destination[42]  = (source[21] << 11) & 0x1ffffffffull;
    destination[42] |= (source[22] >> 53) & 0x1ffffffffull;
    destination[43]  = (source[22] >> 20) & 0x1ffffffffull;
    destination[44]  = (source[22] << 13) & 0x1ffffffffull;
    destination[44] |= (source[23] >> 51) & 0x1ffffffffull;
    destination[45]  = (source[23] >> 18) & 0x1ffffffffull;
    destination[46]  = (source[23] << 15) & 0x1ffffffffull;
    destination[46] |= (source[24] >> 49) & 0x1ffffffffull;
    destination[47]  = (source[24] >> 16) & 0x1ffffffffull;
    destination[48]  = (source[24] << 17) & 0x1ffffffffull;
    destination[48] |= (source[25] >> 47) & 0x1ffffffffull;
    destination[49]  = (source[25] >> 14) & 0x1ffffffffull;
    destination[50]  = (source[25] << 19) & 0x1ffffffffull;
    destination[50] |= (source[26] >> 45) & 0x1ffffffffull;
    destination[51]  = (source[26] >> 12) & 0x1ffffffffull;
    destination[52]  = (source[26] << 21) & 0x1ffffffffull;
    destination[52] |= (source[27] >> 43) & 0x1ffffffffull;
    destination[53]  = (source[27] >> 10) & 0x1ffffffffull;
    destination[54]  = (source[27] << 23) & 0x1ffffffffull;
    destination[54] |= (source[28] >> 41) & 0x1ffffffffull;
    destination[55]  = (source[28] >> 8) & 0x1ffffffffull;
    destination[56]  = (source[28] << 25) & 0x1ffffffffull;
    destination[56] |= (source[29] >> 39) & 0x1ffffffffull;
    destination[57]  = (source[29] >> 6) & 0x1ffffffffull;
    destination[58]  = (source[29] << 27) & 0x1ffffffffull;
    destination[58] |= (source[30] >> 37) & 0x1ffffffffull;
    destination[59]  = (source[30] >> 4) & 0x1ffffffffull;
    destination[60]  = (source[30] << 29) & 0x1ffffffffull;
    destination[60] |= (source[31] >> 35) & 0x1ffffffffull;
    destination[61]  = (source[31] >> 2) & 0x1ffffffffull;
    destination[62]  = (source[31] << 31) & 0x1ffffffffull;
    destination[62] |= (source[32] >> 33) & 0x1ffffffffull;
    destination[63]  = (source[32] >> 0) & 0x1ffffffffull;
  }
};
template <typename Tp>
struct __struct_bitpack_impl<Tp,8,34>
{
  static const size_t unit_size = 64;
  static const size_t bits_total = 2176;
  static const size_t loop_total = 64;
  static const size_t bit_size = 34;
  static const Tp     mask = 0x3ffffffffull;
  static inline
  void pack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] & 0x3ffffffffull) << 30;
    destination[0] |= (source[1] & 0x3ffffffffull) >> 4;
    destination[1]  = (source[1] & 0x3ffffffffull) << 60;
    destination[1] |= (source[2] & 0x3ffffffffull) << 26;
    destination[1] |= (source[3] & 0x3ffffffffull) >> 8;
    destination[2]  = (source[3] & 0x3ffffffffull) << 56;
    destination[2] |= (source[4] & 0x3ffffffffull) << 22;
    destination[2] |= (source[5] & 0x3ffffffffull) >> 12;
    destination[3]  = (source[5] & 0x3ffffffffull) << 52;
    destination[3] |= (source[6] & 0x3ffffffffull) << 18;
    destination[3] |= (source[7] & 0x3ffffffffull) >> 16;
    destination[4]  = (source[7] & 0x3ffffffffull) << 48;
    destination[4] |= (source[8] & 0x3ffffffffull) << 14;
    destination[4] |= (source[9] & 0x3ffffffffull) >> 20;
    destination[5]  = (source[9] & 0x3ffffffffull) << 44;
    destination[5] |= (source[10] & 0x3ffffffffull) << 10;
    destination[5] |= (source[11] & 0x3ffffffffull) >> 24;
    destination[6]  = (source[11] & 0x3ffffffffull) << 40;
    destination[6] |= (source[12] & 0x3ffffffffull) << 6;
    destination[6] |= (source[13] & 0x3ffffffffull) >> 28;
    destination[7]  = (source[13] & 0x3ffffffffull) << 36;
    destination[7] |= (source[14] & 0x3ffffffffull) << 2;
    destination[7] |= (source[15] & 0x3ffffffffull) >> 32;
    destination[8]  = (source[15] & 0x3ffffffffull) << 32;
    destination[8] |= (source[16] & 0x3ffffffffull) >> 2;
    destination[9]  = (source[16] & 0x3ffffffffull) << 62;
    destination[9] |= (source[17] & 0x3ffffffffull) << 28;
    destination[9] |= (source[18] & 0x3ffffffffull) >> 6;
    destination[10]  = (source[18] & 0x3ffffffffull) << 58;
    destination[10] |= (source[19] & 0x3ffffffffull) << 24;
    destination[10] |= (source[20] & 0x3ffffffffull) >> 10;
    destination[11]  = (source[20] & 0x3ffffffffull) << 54;
    destination[11] |= (source[21] & 0x3ffffffffull) << 20;
    destination[11] |= (source[22] & 0x3ffffffffull) >> 14;
    destination[12]  = (source[22] & 0x3ffffffffull) << 50;
    destination[12] |= (source[23] & 0x3ffffffffull) << 16;
    destination[12] |= (source[24] & 0x3ffffffffull) >> 18;
    destination[13]  = (source[24] & 0x3ffffffffull) << 46;
    destination[13] |= (source[25] & 0x3ffffffffull) << 12;
    destination[13] |= (source[26] & 0x3ffffffffull) >> 22;
    destination[14]  = (source[26] & 0x3ffffffffull) << 42;
    destination[14] |= (source[27] & 0x3ffffffffull) << 8;
    destination[14] |= (source[28] & 0x3ffffffffull) >> 26;
    destination[15]  = (source[28] & 0x3ffffffffull) << 38;
    destination[15] |= (source[29] & 0x3ffffffffull) << 4;
    destination[15] |= (source[30] & 0x3ffffffffull) >> 30;
    destination[16]  = (source[30] & 0x3ffffffffull) << 34;
    destination[16] |= (source[31] & 0x3ffffffffull) << 0;
    destination[17]  = (source[32] & 0x3ffffffffull) << 30;
    destination[17] |= (source[33] & 0x3ffffffffull) >> 4;
    destination[18]  = (source[33] & 0x3ffffffffull) << 60;
    destination[18] |= (source[34] & 0x3ffffffffull) << 26;
    destination[18] |= (source[35] & 0x3ffffffffull) >> 8;
    destination[19]  = (source[35] & 0x3ffffffffull) << 56;
    destination[19] |= (source[36] & 0x3ffffffffull) << 22;
    destination[19] |= (source[37] & 0x3ffffffffull) >> 12;
    destination[20]  = (source[37] & 0x3ffffffffull) << 52;
    destination[20] |= (source[38] & 0x3ffffffffull) << 18;
    destination[20] |= (source[39] & 0x3ffffffffull) >> 16;
    destination[21]  = (source[39] & 0x3ffffffffull) << 48;
    destination[21] |= (source[40] & 0x3ffffffffull) << 14;
    destination[21] |= (source[41] & 0x3ffffffffull) >> 20;
    destination[22]  = (source[41] & 0x3ffffffffull) << 44;
    destination[22] |= (source[42] & 0x3ffffffffull) << 10;
    destination[22] |= (source[43] & 0x3ffffffffull) >> 24;
    destination[23]  = (source[43] & 0x3ffffffffull) << 40;
    destination[23] |= (source[44] & 0x3ffffffffull) << 6;
    destination[23] |= (source[45] & 0x3ffffffffull) >> 28;
    destination[24]  = (source[45] & 0x3ffffffffull) << 36;
    destination[24] |= (source[46] & 0x3ffffffffull) << 2;
    destination[24] |= (source[47] & 0x3ffffffffull) >> 32;
    destination[25]  = (source[47] & 0x3ffffffffull) << 32;
    destination[25] |= (source[48] & 0x3ffffffffull) >> 2;
    destination[26]  = (source[48] & 0x3ffffffffull) << 62;
    destination[26] |= (source[49] & 0x3ffffffffull) << 28;
    destination[26] |= (source[50] & 0x3ffffffffull) >> 6;
    destination[27]  = (source[50] & 0x3ffffffffull) << 58;
    destination[27] |= (source[51] & 0x3ffffffffull) << 24;
    destination[27] |= (source[52] & 0x3ffffffffull) >> 10;
    destination[28]  = (source[52] & 0x3ffffffffull) << 54;
    destination[28] |= (source[53] & 0x3ffffffffull) << 20;
    destination[28] |= (source[54] & 0x3ffffffffull) >> 14;
    destination[29]  = (source[54] & 0x3ffffffffull) << 50;
    destination[29] |= (source[55] & 0x3ffffffffull) << 16;
    destination[29] |= (source[56] & 0x3ffffffffull) >> 18;
    destination[30]  = (source[56] & 0x3ffffffffull) << 46;
    destination[30] |= (source[57] & 0x3ffffffffull) << 12;
    destination[30] |= (source[58] & 0x3ffffffffull) >> 22;
    destination[31]  = (source[58] & 0x3ffffffffull) << 42;
    destination[31] |= (source[59] & 0x3ffffffffull) << 8;
    destination[31] |= (source[60] & 0x3ffffffffull) >> 26;
    destination[32]  = (source[60] & 0x3ffffffffull) << 38;
    destination[32] |= (source[61] & 0x3ffffffffull) << 4;
    destination[32] |= (source[62] & 0x3ffffffffull) >> 30;
    destination[33]  = (source[62] & 0x3ffffffffull) << 34;
    destination[33] |= (source[63] & 0x3ffffffffull) << 0;
  }
  static inline
  void unpack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] >> 30) & 0x3ffffffffull;
    destination[1]  = (source[0] << 4) & 0x3ffffffffull;
    destination[1] |= (source[1] >> 60) & 0x3ffffffffull;
    destination[2]  = (source[1] >> 26) & 0x3ffffffffull;
    destination[3]  = (source[1] << 8) & 0x3ffffffffull;
    destination[3] |= (source[2] >> 56) & 0x3ffffffffull;
    destination[4]  = (source[2] >> 22) & 0x3ffffffffull;
    destination[5]  = (source[2] << 12) & 0x3ffffffffull;
    destination[5] |= (source[3] >> 52) & 0x3ffffffffull;
    destination[6]  = (source[3] >> 18) & 0x3ffffffffull;
    destination[7]  = (source[3] << 16) & 0x3ffffffffull;
    destination[7] |= (source[4] >> 48) & 0x3ffffffffull;
    destination[8]  = (source[4] >> 14) & 0x3ffffffffull;
    destination[9]  = (source[4] << 20) & 0x3ffffffffull;
    destination[9] |= (source[5] >> 44) & 0x3ffffffffull;
    destination[10]  = (source[5] >> 10) & 0x3ffffffffull;
    destination[11]  = (source[5] << 24) & 0x3ffffffffull;
    destination[11] |= (source[6] >> 40) & 0x3ffffffffull;
    destination[12]  = (source[6] >> 6) & 0x3ffffffffull;
    destination[13]  = (source[6] << 28) & 0x3ffffffffull;
    destination[13] |= (source[7] >> 36) & 0x3ffffffffull;
    destination[14]  = (source[7] >> 2) & 0x3ffffffffull;
    destination[15]  = (source[7] << 32) & 0x3ffffffffull;
    destination[15] |= (source[8] >> 32) & 0x3ffffffffull;
    destination[16]  = (source[8] << 2) & 0x3ffffffffull;
    destination[16] |= (source[9] >> 62) & 0x3ffffffffull;
    destination[17]  = (source[9] >> 28) & 0x3ffffffffull;
    destination[18]  = (source[9] << 6) & 0x3ffffffffull;
    destination[18] |= (source[10] >> 58) & 0x3ffffffffull;
    destination[19]  = (source[10] >> 24) & 0x3ffffffffull;
    destination[20]  = (source[10] << 10) & 0x3ffffffffull;
    destination[20] |= (source[11] >> 54) & 0x3ffffffffull;
    destination[21]  = (source[11] >> 20) & 0x3ffffffffull;
    destination[22]  = (source[11] << 14) & 0x3ffffffffull;
    destination[22] |= (source[12] >> 50) & 0x3ffffffffull;
    destination[23]  = (source[12] >> 16) & 0x3ffffffffull;
    destination[24]  = (source[12] << 18) & 0x3ffffffffull;
    destination[24] |= (source[13] >> 46) & 0x3ffffffffull;
    destination[25]  = (source[13] >> 12) & 0x3ffffffffull;
    destination[26]  = (source[13] << 22) & 0x3ffffffffull;
    destination[26] |= (source[14] >> 42) & 0x3ffffffffull;
    destination[27]  = (source[14] >> 8) & 0x3ffffffffull;
    destination[28]  = (source[14] << 26) & 0x3ffffffffull;
    destination[28] |= (source[15] >> 38) & 0x3ffffffffull;
    destination[29]  = (source[15] >> 4) & 0x3ffffffffull;
    destination[30]  = (source[15] << 30) & 0x3ffffffffull;
    destination[30] |= (source[16] >> 34) & 0x3ffffffffull;
    destination[31]  = (source[16] >> 0) & 0x3ffffffffull;
    destination[32]  = (source[17] >> 30) & 0x3ffffffffull;
    destination[33]  = (source[17] << 4) & 0x3ffffffffull;
    destination[33] |= (source[18] >> 60) & 0x3ffffffffull;
    destination[34]  = (source[18] >> 26) & 0x3ffffffffull;
    destination[35]  = (source[18] << 8) & 0x3ffffffffull;
    destination[35] |= (source[19] >> 56) & 0x3ffffffffull;
    destination[36]  = (source[19] >> 22) & 0x3ffffffffull;
    destination[37]  = (source[19] << 12) & 0x3ffffffffull;
    destination[37] |= (source[20] >> 52) & 0x3ffffffffull;
    destination[38]  = (source[20] >> 18) & 0x3ffffffffull;
    destination[39]  = (source[20] << 16) & 0x3ffffffffull;
    destination[39] |= (source[21] >> 48) & 0x3ffffffffull;
    destination[40]  = (source[21] >> 14) & 0x3ffffffffull;
    destination[41]  = (source[21] << 20) & 0x3ffffffffull;
    destination[41] |= (source[22] >> 44) & 0x3ffffffffull;
    destination[42]  = (source[22] >> 10) & 0x3ffffffffull;
    destination[43]  = (source[22] << 24) & 0x3ffffffffull;
    destination[43] |= (source[23] >> 40) & 0x3ffffffffull;
    destination[44]  = (source[23] >> 6) & 0x3ffffffffull;
    destination[45]  = (source[23] << 28) & 0x3ffffffffull;
    destination[45] |= (source[24] >> 36) & 0x3ffffffffull;
    destination[46]  = (source[24] >> 2) & 0x3ffffffffull;
    destination[47]  = (source[24] << 32) & 0x3ffffffffull;
    destination[47] |= (source[25] >> 32) & 0x3ffffffffull;
    destination[48]  = (source[25] << 2) & 0x3ffffffffull;
    destination[48] |= (source[26] >> 62) & 0x3ffffffffull;
    destination[49]  = (source[26] >> 28) & 0x3ffffffffull;
    destination[50]  = (source[26] << 6) & 0x3ffffffffull;
    destination[50] |= (source[27] >> 58) & 0x3ffffffffull;
    destination[51]  = (source[27] >> 24) & 0x3ffffffffull;
    destination[52]  = (source[27] << 10) & 0x3ffffffffull;
    destination[52] |= (source[28] >> 54) & 0x3ffffffffull;
    destination[53]  = (source[28] >> 20) & 0x3ffffffffull;
    destination[54]  = (source[28] << 14) & 0x3ffffffffull;
    destination[54] |= (source[29] >> 50) & 0x3ffffffffull;
    destination[55]  = (source[29] >> 16) & 0x3ffffffffull;
    destination[56]  = (source[29] << 18) & 0x3ffffffffull;
    destination[56] |= (source[30] >> 46) & 0x3ffffffffull;
    destination[57]  = (source[30] >> 12) & 0x3ffffffffull;
    destination[58]  = (source[30] << 22) & 0x3ffffffffull;
    destination[58] |= (source[31] >> 42) & 0x3ffffffffull;
    destination[59]  = (source[31] >> 8) & 0x3ffffffffull;
    destination[60]  = (source[31] << 26) & 0x3ffffffffull;
    destination[60] |= (source[32] >> 38) & 0x3ffffffffull;
    destination[61]  = (source[32] >> 4) & 0x3ffffffffull;
    destination[62]  = (source[32] << 30) & 0x3ffffffffull;
    destination[62] |= (source[33] >> 34) & 0x3ffffffffull;
    destination[63]  = (source[33] >> 0) & 0x3ffffffffull;
  }
};
template <typename Tp>
struct __struct_bitpack_impl<Tp,8,35>
{
  static const size_t unit_size = 64;
  static const size_t bits_total = 2240;
  static const size_t loop_total = 64;
  static const size_t bit_size = 35;
  static const Tp     mask = 0x7ffffffffull;
  static inline
  void pack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] & 0x7ffffffffull) << 29;
    destination[0] |= (source[1] & 0x7ffffffffull) >> 6;
    destination[1]  = (source[1] & 0x7ffffffffull) << 58;
    destination[1] |= (source[2] & 0x7ffffffffull) << 23;
    destination[1] |= (source[3] & 0x7ffffffffull) >> 12;
    destination[2]  = (source[3] & 0x7ffffffffull) << 52;
    destination[2] |= (source[4] & 0x7ffffffffull) << 17;
    destination[2] |= (source[5] & 0x7ffffffffull) >> 18;
    destination[3]  = (source[5] & 0x7ffffffffull) << 46;
    destination[3] |= (source[6] & 0x7ffffffffull) << 11;
    destination[3] |= (source[7] & 0x7ffffffffull) >> 24;
    destination[4]  = (source[7] & 0x7ffffffffull) << 40;
    destination[4] |= (source[8] & 0x7ffffffffull) << 5;
    destination[4] |= (source[9] & 0x7ffffffffull) >> 30;
    destination[5]  = (source[9] & 0x7ffffffffull) << 34;
    destination[5] |= (source[10] & 0x7ffffffffull) >> 1;
    destination[6]  = (source[10] & 0x7ffffffffull) << 63;
    destination[6] |= (source[11] & 0x7ffffffffull) << 28;
    destination[6] |= (source[12] & 0x7ffffffffull) >> 7;
    destination[7]  = (source[12] & 0x7ffffffffull) << 57;
    destination[7] |= (source[13] & 0x7ffffffffull) << 22;
    destination[7] |= (source[14] & 0x7ffffffffull) >> 13;
    destination[8]  = (source[14] & 0x7ffffffffull) << 51;
    destination[8] |= (source[15] & 0x7ffffffffull) << 16;
    destination[8] |= (source[16] & 0x7ffffffffull) >> 19;
    destination[9]  = (source[16] & 0x7ffffffffull) << 45;
    destination[9] |= (source[17] & 0x7ffffffffull) << 10;
    destination[9] |= (source[18] & 0x7ffffffffull) >> 25;
    destination[10]  = (source[18] & 0x7ffffffffull) << 39;
    destination[10] |= (source[19] & 0x7ffffffffull) << 4;
    destination[10] |= (source[20] & 0x7ffffffffull) >> 31;
    destination[11]  = (source[20] & 0x7ffffffffull) << 33;
    destination[11] |= (source[21] & 0x7ffffffffull) >> 2;
    destination[12]  = (source[21] & 0x7ffffffffull) << 62;
    destination[12] |= (source[22] & 0x7ffffffffull) << 27;
    destination[12] |= (source[23] & 0x7ffffffffull) >> 8;
    destination[13]  = (source[23] & 0x7ffffffffull) << 56;
    destination[13] |= (source[24] & 0x7ffffffffull) << 21;
    destination[13] |= (source[25] & 0x7ffffffffull) >> 14;
    destination[14]  = (source[25] & 0x7ffffffffull) << 50;
    destination[14] |= (source[26] & 0x7ffffffffull) << 15;
    destination[14] |= (source[27] & 0x7ffffffffull) >> 20;
    destination[15]  = (source[27] & 0x7ffffffffull) << 44;
    destination[15] |= (source[28] & 0x7ffffffffull) << 9;
    destination[15] |= (source[29] & 0x7ffffffffull) >> 26;
    destination[16]  = (source[29] & 0x7ffffffffull) << 38;
    destination[16] |= (source[30] & 0x7ffffffffull) << 3;
    destination[16] |= (source[31] & 0x7ffffffffull) >> 32;
    destination[17]  = (source[31] & 0x7ffffffffull) << 32;
    destination[17] |= (source[32] & 0x7ffffffffull) >> 3;
    destination[18]  = (source[32] & 0x7ffffffffull) << 61;
    destination[18] |= (source[33] & 0x7ffffffffull) << 26;
    destination[18] |= (source[34] & 0x7ffffffffull) >> 9;
    destination[19]  = (source[34] & 0x7ffffffffull) << 55;
    destination[19] |= (source[35] & 0x7ffffffffull) << 20;
    destination[19] |= (source[36] & 0x7ffffffffull) >> 15;
    destination[20]  = (source[36] & 0x7ffffffffull) << 49;
    destination[20] |= (source[37] & 0x7ffffffffull) << 14;
    destination[20] |= (source[38] & 0x7ffffffffull) >> 21;
    destination[21]  = (source[38] & 0x7ffffffffull) << 43;
    destination[21] |= (source[39] & 0x7ffffffffull) << 8;
    destination[21] |= (source[40] & 0x7ffffffffull) >> 27;
    destination[22]  = (source[40] & 0x7ffffffffull) << 37;
    destination[22] |= (source[41] & 0x7ffffffffull) << 2;
    destination[22] |= (source[42] & 0x7ffffffffull) >> 33;
    destination[23]  = (source[42] & 0x7ffffffffull) << 31;
    destination[23] |= (source[43] & 0x7ffffffffull) >> 4;
    destination[24]  = (source[43] & 0x7ffffffffull) << 60;
    destination[24] |= (source[44] & 0x7ffffffffull) << 25;
    destination[24] |= (source[45] & 0x7ffffffffull) >> 10;
    destination[25]  = (source[45] & 0x7ffffffffull) << 54;
    destination[25] |= (source[46] & 0x7ffffffffull) << 19;
    destination[25] |= (source[47] & 0x7ffffffffull) >> 16;
    destination[26]  = (source[47] & 0x7ffffffffull) << 48;
    destination[26] |= (source[48] & 0x7ffffffffull) << 13;
    destination[26] |= (source[49] & 0x7ffffffffull) >> 22;
    destination[27]  = (source[49] & 0x7ffffffffull) << 42;
    destination[27] |= (source[50] & 0x7ffffffffull) << 7;
    destination[27] |= (source[51] & 0x7ffffffffull) >> 28;
    destination[28]  = (source[51] & 0x7ffffffffull) << 36;
    destination[28] |= (source[52] & 0x7ffffffffull) << 1;
    destination[28] |= (source[53] & 0x7ffffffffull) >> 34;
    destination[29]  = (source[53] & 0x7ffffffffull) << 30;
    destination[29] |= (source[54] & 0x7ffffffffull) >> 5;
    destination[30]  = (source[54] & 0x7ffffffffull) << 59;
    destination[30] |= (source[55] & 0x7ffffffffull) << 24;
    destination[30] |= (source[56] & 0x7ffffffffull) >> 11;
    destination[31]  = (source[56] & 0x7ffffffffull) << 53;
    destination[31] |= (source[57] & 0x7ffffffffull) << 18;
    destination[31] |= (source[58] & 0x7ffffffffull) >> 17;
    destination[32]  = (source[58] & 0x7ffffffffull) << 47;
    destination[32] |= (source[59] & 0x7ffffffffull) << 12;
    destination[32] |= (source[60] & 0x7ffffffffull) >> 23;
    destination[33]  = (source[60] & 0x7ffffffffull) << 41;
    destination[33] |= (source[61] & 0x7ffffffffull) << 6;
    destination[33] |= (source[62] & 0x7ffffffffull) >> 29;
    destination[34]  = (source[62] & 0x7ffffffffull) << 35;
    destination[34] |= (source[63] & 0x7ffffffffull) << 0;
  }
  static inline
  void unpack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] >> 29) & 0x7ffffffffull;
    destination[1]  = (source[0] << 6) & 0x7ffffffffull;
    destination[1] |= (source[1] >> 58) & 0x7ffffffffull;
    destination[2]  = (source[1] >> 23) & 0x7ffffffffull;
    destination[3]  = (source[1] << 12) & 0x7ffffffffull;
    destination[3] |= (source[2] >> 52) & 0x7ffffffffull;
    destination[4]  = (source[2] >> 17) & 0x7ffffffffull;
    destination[5]  = (source[2] << 18) & 0x7ffffffffull;
    destination[5] |= (source[3] >> 46) & 0x7ffffffffull;
    destination[6]  = (source[3] >> 11) & 0x7ffffffffull;
    destination[7]  = (source[3] << 24) & 0x7ffffffffull;
    destination[7] |= (source[4] >> 40) & 0x7ffffffffull;
    destination[8]  = (source[4] >> 5) & 0x7ffffffffull;
    destination[9]  = (source[4] << 30) & 0x7ffffffffull;
    destination[9] |= (source[5] >> 34) & 0x7ffffffffull;
    destination[10]  = (source[5] << 1) & 0x7ffffffffull;
    destination[10] |= (source[6] >> 63) & 0x7ffffffffull;
    destination[11]  = (source[6] >> 28) & 0x7ffffffffull;
    destination[12]  = (source[6] << 7) & 0x7ffffffffull;
    destination[12] |= (source[7] >> 57) & 0x7ffffffffull;
    destination[13]  = (source[7] >> 22) & 0x7ffffffffull;
    destination[14]  = (source[7] << 13) & 0x7ffffffffull;
    destination[14] |= (source[8] >> 51) & 0x7ffffffffull;
    destination[15]  = (source[8] >> 16) & 0x7ffffffffull;
    destination[16]  = (source[8] << 19) & 0x7ffffffffull;
    destination[16] |= (source[9] >> 45) & 0x7ffffffffull;
    destination[17]  = (source[9] >> 10) & 0x7ffffffffull;
    destination[18]  = (source[9] << 25) & 0x7ffffffffull;
    destination[18] |= (source[10] >> 39) & 0x7ffffffffull;
    destination[19]  = (source[10] >> 4) & 0x7ffffffffull;
    destination[20]  = (source[10] << 31) & 0x7ffffffffull;
    destination[20] |= (source[11] >> 33) & 0x7ffffffffull;
    destination[21]  = (source[11] << 2) & 0x7ffffffffull;
    destination[21] |= (source[12] >> 62) & 0x7ffffffffull;
    destination[22]  = (source[12] >> 27) & 0x7ffffffffull;
    destination[23]  = (source[12] << 8) & 0x7ffffffffull;
    destination[23] |= (source[13] >> 56) & 0x7ffffffffull;
    destination[24]  = (source[13] >> 21) & 0x7ffffffffull;
    destination[25]  = (source[13] << 14) & 0x7ffffffffull;
    destination[25] |= (source[14] >> 50) & 0x7ffffffffull;
    destination[26]  = (source[14] >> 15) & 0x7ffffffffull;
    destination[27]  = (source[14] << 20) & 0x7ffffffffull;
    destination[27] |= (source[15] >> 44) & 0x7ffffffffull;
    destination[28]  = (source[15] >> 9) & 0x7ffffffffull;
    destination[29]  = (source[15] << 26) & 0x7ffffffffull;
    destination[29] |= (source[16] >> 38) & 0x7ffffffffull;
    destination[30]  = (source[16] >> 3) & 0x7ffffffffull;
    destination[31]  = (source[16] << 32) & 0x7ffffffffull;
    destination[31] |= (source[17] >> 32) & 0x7ffffffffull;
    destination[32]  = (source[17] << 3) & 0x7ffffffffull;
    destination[32] |= (source[18] >> 61) & 0x7ffffffffull;
    destination[33]  = (source[18] >> 26) & 0x7ffffffffull;
    destination[34]  = (source[18] << 9) & 0x7ffffffffull;
    destination[34] |= (source[19] >> 55) & 0x7ffffffffull;
    destination[35]  = (source[19] >> 20) & 0x7ffffffffull;
    destination[36]  = (source[19] << 15) & 0x7ffffffffull;
    destination[36] |= (source[20] >> 49) & 0x7ffffffffull;
    destination[37]  = (source[20] >> 14) & 0x7ffffffffull;
    destination[38]  = (source[20] << 21) & 0x7ffffffffull;
    destination[38] |= (source[21] >> 43) & 0x7ffffffffull;
    destination[39]  = (source[21] >> 8) & 0x7ffffffffull;
    destination[40]  = (source[21] << 27) & 0x7ffffffffull;
    destination[40] |= (source[22] >> 37) & 0x7ffffffffull;
    destination[41]  = (source[22] >> 2) & 0x7ffffffffull;
    destination[42]  = (source[22] << 33) & 0x7ffffffffull;
    destination[42] |= (source[23] >> 31) & 0x7ffffffffull;
    destination[43]  = (source[23] << 4) & 0x7ffffffffull;
    destination[43] |= (source[24] >> 60) & 0x7ffffffffull;
    destination[44]  = (source[24] >> 25) & 0x7ffffffffull;
    destination[45]  = (source[24] << 10) & 0x7ffffffffull;
    destination[45] |= (source[25] >> 54) & 0x7ffffffffull;
    destination[46]  = (source[25] >> 19) & 0x7ffffffffull;
    destination[47]  = (source[25] << 16) & 0x7ffffffffull;
    destination[47] |= (source[26] >> 48) & 0x7ffffffffull;
    destination[48]  = (source[26] >> 13) & 0x7ffffffffull;
    destination[49]  = (source[26] << 22) & 0x7ffffffffull;
    destination[49] |= (source[27] >> 42) & 0x7ffffffffull;
    destination[50]  = (source[27] >> 7) & 0x7ffffffffull;
    destination[51]  = (source[27] << 28) & 0x7ffffffffull;
    destination[51] |= (source[28] >> 36) & 0x7ffffffffull;
    destination[52]  = (source[28] >> 1) & 0x7ffffffffull;
    destination[53]  = (source[28] << 34) & 0x7ffffffffull;
    destination[53] |= (source[29] >> 30) & 0x7ffffffffull;
    destination[54]  = (source[29] << 5) & 0x7ffffffffull;
    destination[54] |= (source[30] >> 59) & 0x7ffffffffull;
    destination[55]  = (source[30] >> 24) & 0x7ffffffffull;
    destination[56]  = (source[30] << 11) & 0x7ffffffffull;
    destination[56] |= (source[31] >> 53) & 0x7ffffffffull;
    destination[57]  = (source[31] >> 18) & 0x7ffffffffull;
    destination[58]  = (source[31] << 17) & 0x7ffffffffull;
    destination[58] |= (source[32] >> 47) & 0x7ffffffffull;
    destination[59]  = (source[32] >> 12) & 0x7ffffffffull;
    destination[60]  = (source[32] << 23) & 0x7ffffffffull;
    destination[60] |= (source[33] >> 41) & 0x7ffffffffull;
    destination[61]  = (source[33] >> 6) & 0x7ffffffffull;
    destination[62]  = (source[33] << 29) & 0x7ffffffffull;
    destination[62] |= (source[34] >> 35) & 0x7ffffffffull;
    destination[63]  = (source[34] >> 0) & 0x7ffffffffull;
  }
};
template <typename Tp>
struct __struct_bitpack_impl<Tp,8,36>
{
  static const size_t unit_size = 64;
  static const size_t bits_total = 2304;
  static const size_t loop_total = 64;
  static const size_t bit_size = 36;
  static const Tp     mask = 0xfffffffffull;
  static inline
  void pack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] & 0xfffffffffull) << 28;
    destination[0] |= (source[1] & 0xfffffffffull) >> 8;
    destination[1]  = (source[1] & 0xfffffffffull) << 56;
    destination[1] |= (source[2] & 0xfffffffffull) << 20;
    destination[1] |= (source[3] & 0xfffffffffull) >> 16;
    destination[2]  = (source[3] & 0xfffffffffull) << 48;
    destination[2] |= (source[4] & 0xfffffffffull) << 12;
    destination[2] |= (source[5] & 0xfffffffffull) >> 24;
    destination[3]  = (source[5] & 0xfffffffffull) << 40;
    destination[3] |= (source[6] & 0xfffffffffull) << 4;
    destination[3] |= (source[7] & 0xfffffffffull) >> 32;
    destination[4]  = (source[7] & 0xfffffffffull) << 32;
    destination[4] |= (source[8] & 0xfffffffffull) >> 4;
    destination[5]  = (source[8] & 0xfffffffffull) << 60;
    destination[5] |= (source[9] & 0xfffffffffull) << 24;
    destination[5] |= (source[10] & 0xfffffffffull) >> 12;
    destination[6]  = (source[10] & 0xfffffffffull) << 52;
    destination[6] |= (source[11] & 0xfffffffffull) << 16;
    destination[6] |= (source[12] & 0xfffffffffull) >> 20;
    destination[7]  = (source[12] & 0xfffffffffull) << 44;
    destination[7] |= (source[13] & 0xfffffffffull) << 8;
    destination[7] |= (source[14] & 0xfffffffffull) >> 28;
    destination[8]  = (source[14] & 0xfffffffffull) << 36;
    destination[8] |= (source[15] & 0xfffffffffull) << 0;
    destination[9]  = (source[16] & 0xfffffffffull) << 28;
    destination[9] |= (source[17] & 0xfffffffffull) >> 8;
    destination[10]  = (source[17] & 0xfffffffffull) << 56;
    destination[10] |= (source[18] & 0xfffffffffull) << 20;
    destination[10] |= (source[19] & 0xfffffffffull) >> 16;
    destination[11]  = (source[19] & 0xfffffffffull) << 48;
    destination[11] |= (source[20] & 0xfffffffffull) << 12;
    destination[11] |= (source[21] & 0xfffffffffull) >> 24;
    destination[12]  = (source[21] & 0xfffffffffull) << 40;
    destination[12] |= (source[22] & 0xfffffffffull) << 4;
    destination[12] |= (source[23] & 0xfffffffffull) >> 32;
    destination[13]  = (source[23] & 0xfffffffffull) << 32;
    destination[13] |= (source[24] & 0xfffffffffull) >> 4;
    destination[14]  = (source[24] & 0xfffffffffull) << 60;
    destination[14] |= (source[25] & 0xfffffffffull) << 24;
    destination[14] |= (source[26] & 0xfffffffffull) >> 12;
    destination[15]  = (source[26] & 0xfffffffffull) << 52;
    destination[15] |= (source[27] & 0xfffffffffull) << 16;
    destination[15] |= (source[28] & 0xfffffffffull) >> 20;
    destination[16]  = (source[28] & 0xfffffffffull) << 44;
    destination[16] |= (source[29] & 0xfffffffffull) << 8;
    destination[16] |= (source[30] & 0xfffffffffull) >> 28;
    destination[17]  = (source[30] & 0xfffffffffull) << 36;
    destination[17] |= (source[31] & 0xfffffffffull) << 0;
    destination[18]  = (source[32] & 0xfffffffffull) << 28;
    destination[18] |= (source[33] & 0xfffffffffull) >> 8;
    destination[19]  = (source[33] & 0xfffffffffull) << 56;
    destination[19] |= (source[34] & 0xfffffffffull) << 20;
    destination[19] |= (source[35] & 0xfffffffffull) >> 16;
    destination[20]  = (source[35] & 0xfffffffffull) << 48;
    destination[20] |= (source[36] & 0xfffffffffull) << 12;
    destination[20] |= (source[37] & 0xfffffffffull) >> 24;
    destination[21]  = (source[37] & 0xfffffffffull) << 40;
    destination[21] |= (source[38] & 0xfffffffffull) << 4;
    destination[21] |= (source[39] & 0xfffffffffull) >> 32;
    destination[22]  = (source[39] & 0xfffffffffull) << 32;
    destination[22] |= (source[40] & 0xfffffffffull) >> 4;
    destination[23]  = (source[40] & 0xfffffffffull) << 60;
    destination[23] |= (source[41] & 0xfffffffffull) << 24;
    destination[23] |= (source[42] & 0xfffffffffull) >> 12;
    destination[24]  = (source[42] & 0xfffffffffull) << 52;
    destination[24] |= (source[43] & 0xfffffffffull) << 16;
    destination[24] |= (source[44] & 0xfffffffffull) >> 20;
    destination[25]  = (source[44] & 0xfffffffffull) << 44;
    destination[25] |= (source[45] & 0xfffffffffull) << 8;
    destination[25] |= (source[46] & 0xfffffffffull) >> 28;
    destination[26]  = (source[46] & 0xfffffffffull) << 36;
    destination[26] |= (source[47] & 0xfffffffffull) << 0;
    destination[27]  = (source[48] & 0xfffffffffull) << 28;
    destination[27] |= (source[49] & 0xfffffffffull) >> 8;
    destination[28]  = (source[49] & 0xfffffffffull) << 56;
    destination[28] |= (source[50] & 0xfffffffffull) << 20;
    destination[28] |= (source[51] & 0xfffffffffull) >> 16;
    destination[29]  = (source[51] & 0xfffffffffull) << 48;
    destination[29] |= (source[52] & 0xfffffffffull) << 12;
    destination[29] |= (source[53] & 0xfffffffffull) >> 24;
    destination[30]  = (source[53] & 0xfffffffffull) << 40;
    destination[30] |= (source[54] & 0xfffffffffull) << 4;
    destination[30] |= (source[55] & 0xfffffffffull) >> 32;
    destination[31]  = (source[55] & 0xfffffffffull) << 32;
    destination[31] |= (source[56] & 0xfffffffffull) >> 4;
    destination[32]  = (source[56] & 0xfffffffffull) << 60;
    destination[32] |= (source[57] & 0xfffffffffull) << 24;
    destination[32] |= (source[58] & 0xfffffffffull) >> 12;
    destination[33]  = (source[58] & 0xfffffffffull) << 52;
    destination[33] |= (source[59] & 0xfffffffffull) << 16;
    destination[33] |= (source[60] & 0xfffffffffull) >> 20;
    destination[34]  = (source[60] & 0xfffffffffull) << 44;
    destination[34] |= (source[61] & 0xfffffffffull) << 8;
    destination[34] |= (source[62] & 0xfffffffffull) >> 28;
    destination[35]  = (source[62] & 0xfffffffffull) << 36;
    destination[35] |= (source[63] & 0xfffffffffull) << 0;
  }
  static inline
  void unpack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] >> 28) & 0xfffffffffull;
    destination[1]  = (source[0] << 8) & 0xfffffffffull;
    destination[1] |= (source[1] >> 56) & 0xfffffffffull;
    destination[2]  = (source[1] >> 20) & 0xfffffffffull;
    destination[3]  = (source[1] << 16) & 0xfffffffffull;
    destination[3] |= (source[2] >> 48) & 0xfffffffffull;
    destination[4]  = (source[2] >> 12) & 0xfffffffffull;
    destination[5]  = (source[2] << 24) & 0xfffffffffull;
    destination[5] |= (source[3] >> 40) & 0xfffffffffull;
    destination[6]  = (source[3] >> 4) & 0xfffffffffull;
    destination[7]  = (source[3] << 32) & 0xfffffffffull;
    destination[7] |= (source[4] >> 32) & 0xfffffffffull;
    destination[8]  = (source[4] << 4) & 0xfffffffffull;
    destination[8] |= (source[5] >> 60) & 0xfffffffffull;
    destination[9]  = (source[5] >> 24) & 0xfffffffffull;
    destination[10]  = (source[5] << 12) & 0xfffffffffull;
    destination[10] |= (source[6] >> 52) & 0xfffffffffull;
    destination[11]  = (source[6] >> 16) & 0xfffffffffull;
    destination[12]  = (source[6] << 20) & 0xfffffffffull;
    destination[12] |= (source[7] >> 44) & 0xfffffffffull;
    destination[13]  = (source[7] >> 8) & 0xfffffffffull;
    destination[14]  = (source[7] << 28) & 0xfffffffffull;
    destination[14] |= (source[8] >> 36) & 0xfffffffffull;
    destination[15]  = (source[8] >> 0) & 0xfffffffffull;
    destination[16]  = (source[9] >> 28) & 0xfffffffffull;
    destination[17]  = (source[9] << 8) & 0xfffffffffull;
    destination[17] |= (source[10] >> 56) & 0xfffffffffull;
    destination[18]  = (source[10] >> 20) & 0xfffffffffull;
    destination[19]  = (source[10] << 16) & 0xfffffffffull;
    destination[19] |= (source[11] >> 48) & 0xfffffffffull;
    destination[20]  = (source[11] >> 12) & 0xfffffffffull;
    destination[21]  = (source[11] << 24) & 0xfffffffffull;
    destination[21] |= (source[12] >> 40) & 0xfffffffffull;
    destination[22]  = (source[12] >> 4) & 0xfffffffffull;
    destination[23]  = (source[12] << 32) & 0xfffffffffull;
    destination[23] |= (source[13] >> 32) & 0xfffffffffull;
    destination[24]  = (source[13] << 4) & 0xfffffffffull;
    destination[24] |= (source[14] >> 60) & 0xfffffffffull;
    destination[25]  = (source[14] >> 24) & 0xfffffffffull;
    destination[26]  = (source[14] << 12) & 0xfffffffffull;
    destination[26] |= (source[15] >> 52) & 0xfffffffffull;
    destination[27]  = (source[15] >> 16) & 0xfffffffffull;
    destination[28]  = (source[15] << 20) & 0xfffffffffull;
    destination[28] |= (source[16] >> 44) & 0xfffffffffull;
    destination[29]  = (source[16] >> 8) & 0xfffffffffull;
    destination[30]  = (source[16] << 28) & 0xfffffffffull;
    destination[30] |= (source[17] >> 36) & 0xfffffffffull;
    destination[31]  = (source[17] >> 0) & 0xfffffffffull;
    destination[32]  = (source[18] >> 28) & 0xfffffffffull;
    destination[33]  = (source[18] << 8) & 0xfffffffffull;
    destination[33] |= (source[19] >> 56) & 0xfffffffffull;
    destination[34]  = (source[19] >> 20) & 0xfffffffffull;
    destination[35]  = (source[19] << 16) & 0xfffffffffull;
    destination[35] |= (source[20] >> 48) & 0xfffffffffull;
    destination[36]  = (source[20] >> 12) & 0xfffffffffull;
    destination[37]  = (source[20] << 24) & 0xfffffffffull;
    destination[37] |= (source[21] >> 40) & 0xfffffffffull;
    destination[38]  = (source[21] >> 4) & 0xfffffffffull;
    destination[39]  = (source[21] << 32) & 0xfffffffffull;
    destination[39] |= (source[22] >> 32) & 0xfffffffffull;
    destination[40]  = (source[22] << 4) & 0xfffffffffull;
    destination[40] |= (source[23] >> 60) & 0xfffffffffull;
    destination[41]  = (source[23] >> 24) & 0xfffffffffull;
    destination[42]  = (source[23] << 12) & 0xfffffffffull;
    destination[42] |= (source[24] >> 52) & 0xfffffffffull;
    destination[43]  = (source[24] >> 16) & 0xfffffffffull;
    destination[44]  = (source[24] << 20) & 0xfffffffffull;
    destination[44] |= (source[25] >> 44) & 0xfffffffffull;
    destination[45]  = (source[25] >> 8) & 0xfffffffffull;
    destination[46]  = (source[25] << 28) & 0xfffffffffull;
    destination[46] |= (source[26] >> 36) & 0xfffffffffull;
    destination[47]  = (source[26] >> 0) & 0xfffffffffull;
    destination[48]  = (source[27] >> 28) & 0xfffffffffull;
    destination[49]  = (source[27] << 8) & 0xfffffffffull;
    destination[49] |= (source[28] >> 56) & 0xfffffffffull;
    destination[50]  = (source[28] >> 20) & 0xfffffffffull;
    destination[51]  = (source[28] << 16) & 0xfffffffffull;
    destination[51] |= (source[29] >> 48) & 0xfffffffffull;
    destination[52]  = (source[29] >> 12) & 0xfffffffffull;
    destination[53]  = (source[29] << 24) & 0xfffffffffull;
    destination[53] |= (source[30] >> 40) & 0xfffffffffull;
    destination[54]  = (source[30] >> 4) & 0xfffffffffull;
    destination[55]  = (source[30] << 32) & 0xfffffffffull;
    destination[55] |= (source[31] >> 32) & 0xfffffffffull;
    destination[56]  = (source[31] << 4) & 0xfffffffffull;
    destination[56] |= (source[32] >> 60) & 0xfffffffffull;
    destination[57]  = (source[32] >> 24) & 0xfffffffffull;
    destination[58]  = (source[32] << 12) & 0xfffffffffull;
    destination[58] |= (source[33] >> 52) & 0xfffffffffull;
    destination[59]  = (source[33] >> 16) & 0xfffffffffull;
    destination[60]  = (source[33] << 20) & 0xfffffffffull;
    destination[60] |= (source[34] >> 44) & 0xfffffffffull;
    destination[61]  = (source[34] >> 8) & 0xfffffffffull;
    destination[62]  = (source[34] << 28) & 0xfffffffffull;
    destination[62] |= (source[35] >> 36) & 0xfffffffffull;
    destination[63]  = (source[35] >> 0) & 0xfffffffffull;
  }
};
template <typename Tp>
struct __struct_bitpack_impl<Tp,8,37>
{
  static const size_t unit_size = 64;
  static const size_t bits_total = 2368;
  static const size_t loop_total = 64;
  static const size_t bit_size = 37;
  static const Tp     mask = 0x1fffffffffull;
  static inline
  void pack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] & 0x1fffffffffull) << 27;
    destination[0] |= (source[1] & 0x1fffffffffull) >> 10;
    destination[1]  = (source[1] & 0x1fffffffffull) << 54;
    destination[1] |= (source[2] & 0x1fffffffffull) << 17;
    destination[1] |= (source[3] & 0x1fffffffffull) >> 20;
    destination[2]  = (source[3] & 0x1fffffffffull) << 44;
    destination[2] |= (source[4] & 0x1fffffffffull) << 7;
    destination[2] |= (source[5] & 0x1fffffffffull) >> 30;
    destination[3]  = (source[5] & 0x1fffffffffull) << 34;
    destination[3] |= (source[6] & 0x1fffffffffull) >> 3;
    destination[4]  = (source[6] & 0x1fffffffffull) << 61;
    destination[4] |= (source[7] & 0x1fffffffffull) << 24;
    destination[4] |= (source[8] & 0x1fffffffffull) >> 13;
    destination[5]  = (source[8] & 0x1fffffffffull) << 51;
    destination[5] |= (source[9] & 0x1fffffffffull) << 14;
    destination[5] |= (source[10] & 0x1fffffffffull) >> 23;
    destination[6]  = (source[10] & 0x1fffffffffull) << 41;
    destination[6] |= (source[11] & 0x1fffffffffull) << 4;
    destination[6] |= (source[12] & 0x1fffffffffull) >> 33;
    destination[7]  = (source[12] & 0x1fffffffffull) << 31;
    destination[7] |= (source[13] & 0x1fffffffffull) >> 6;
    destination[8]  = (source[13] & 0x1fffffffffull) << 58;
    destination[8] |= (source[14] & 0x1fffffffffull) << 21;
    destination[8] |= (source[15] & 0x1fffffffffull) >> 16;
    destination[9]  = (source[15] & 0x1fffffffffull) << 48;
    destination[9] |= (source[16] & 0x1fffffffffull) << 11;
    destination[9] |= (source[17] & 0x1fffffffffull) >> 26;
    destination[10]  = (source[17] & 0x1fffffffffull) << 38;
    destination[10] |= (source[18] & 0x1fffffffffull) << 1;
    destination[10] |= (source[19] & 0x1fffffffffull) >> 36;
    destination[11]  = (source[19] & 0x1fffffffffull) << 28;
    destination[11] |= (source[20] & 0x1fffffffffull) >> 9;
    destination[12]  = (source[20] & 0x1fffffffffull) << 55;
    destination[12] |= (source[21] & 0x1fffffffffull) << 18;
    destination[12] |= (source[22] & 0x1fffffffffull) >> 19;
    destination[13]  = (source[22] & 0x1fffffffffull) << 45;
    destination[13] |= (source[23] & 0x1fffffffffull) << 8;
    destination[13] |= (source[24] & 0x1fffffffffull) >> 29;
    destination[14]  = (source[24] & 0x1fffffffffull) << 35;
    destination[14] |= (source[25] & 0x1fffffffffull) >> 2;
    destination[15]  = (source[25] & 0x1fffffffffull) << 62;
    destination[15] |= (source[26] & 0x1fffffffffull) << 25;
    destination[15] |= (source[27] & 0x1fffffffffull) >> 12;
    destination[16]  = (source[27] & 0x1fffffffffull) << 52;
    destination[16] |= (source[28] & 0x1fffffffffull) << 15;
    destination[16] |= (source[29] & 0x1fffffffffull) >> 22;
    destination[17]  = (source[29] & 0x1fffffffffull) << 42;
    destination[17] |= (source[30] & 0x1fffffffffull) << 5;
    destination[17] |= (source[31] & 0x1fffffffffull) >> 32;
    destination[18]  = (source[31] & 0x1fffffffffull) << 32;
    destination[18] |= (source[32] & 0x1fffffffffull) >> 5;
    destination[19]  = (source[32] & 0x1fffffffffull) << 59;
    destination[19] |= (source[33] & 0x1fffffffffull) << 22;
    destination[19] |= (source[34] & 0x1fffffffffull) >> 15;
    destination[20]  = (source[34] & 0x1fffffffffull) << 49;
    destination[20] |= (source[35] & 0x1fffffffffull) << 12;
    destination[20] |= (source[36] & 0x1fffffffffull) >> 25;
    destination[21]  = (source[36] & 0x1fffffffffull) << 39;
    destination[21] |= (source[37] & 0x1fffffffffull) << 2;
    destination[21] |= (source[38] & 0x1fffffffffull) >> 35;
    destination[22]  = (source[38] & 0x1fffffffffull) << 29;
    destination[22] |= (source[39] & 0x1fffffffffull) >> 8;
    destination[23]  = (source[39] & 0x1fffffffffull) << 56;
    destination[23] |= (source[40] & 0x1fffffffffull) << 19;
    destination[23] |= (source[41] & 0x1fffffffffull) >> 18;
    destination[24]  = (source[41] & 0x1fffffffffull) << 46;
    destination[24] |= (source[42] & 0x1fffffffffull) << 9;
    destination[24] |= (source[43] & 0x1fffffffffull) >> 28;
    destination[25]  = (source[43] & 0x1fffffffffull) << 36;
    destination[25] |= (source[44] & 0x1fffffffffull) >> 1;
    destination[26]  = (source[44] & 0x1fffffffffull) << 63;
    destination[26] |= (source[45] & 0x1fffffffffull) << 26;
    destination[26] |= (source[46] & 0x1fffffffffull) >> 11;
    destination[27]  = (source[46] & 0x1fffffffffull) << 53;
    destination[27] |= (source[47] & 0x1fffffffffull) << 16;
    destination[27] |= (source[48] & 0x1fffffffffull) >> 21;
    destination[28]  = (source[48] & 0x1fffffffffull) << 43;
    destination[28] |= (source[49] & 0x1fffffffffull) << 6;
    destination[28] |= (source[50] & 0x1fffffffffull) >> 31;
    destination[29]  = (source[50] & 0x1fffffffffull) << 33;
    destination[29] |= (source[51] & 0x1fffffffffull) >> 4;
    destination[30]  = (source[51] & 0x1fffffffffull) << 60;
    destination[30] |= (source[52] & 0x1fffffffffull) << 23;
    destination[30] |= (source[53] & 0x1fffffffffull) >> 14;
    destination[31]  = (source[53] & 0x1fffffffffull) << 50;
    destination[31] |= (source[54] & 0x1fffffffffull) << 13;
    destination[31] |= (source[55] & 0x1fffffffffull) >> 24;
    destination[32]  = (source[55] & 0x1fffffffffull) << 40;
    destination[32] |= (source[56] & 0x1fffffffffull) << 3;
    destination[32] |= (source[57] & 0x1fffffffffull) >> 34;
    destination[33]  = (source[57] & 0x1fffffffffull) << 30;
    destination[33] |= (source[58] & 0x1fffffffffull) >> 7;
    destination[34]  = (source[58] & 0x1fffffffffull) << 57;
    destination[34] |= (source[59] & 0x1fffffffffull) << 20;
    destination[34] |= (source[60] & 0x1fffffffffull) >> 17;
    destination[35]  = (source[60] & 0x1fffffffffull) << 47;
    destination[35] |= (source[61] & 0x1fffffffffull) << 10;
    destination[35] |= (source[62] & 0x1fffffffffull) >> 27;
    destination[36]  = (source[62] & 0x1fffffffffull) << 37;
    destination[36] |= (source[63] & 0x1fffffffffull) << 0;
  }
  static inline
  void unpack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] >> 27) & 0x1fffffffffull;
    destination[1]  = (source[0] << 10) & 0x1fffffffffull;
    destination[1] |= (source[1] >> 54) & 0x1fffffffffull;
    destination[2]  = (source[1] >> 17) & 0x1fffffffffull;
    destination[3]  = (source[1] << 20) & 0x1fffffffffull;
    destination[3] |= (source[2] >> 44) & 0x1fffffffffull;
    destination[4]  = (source[2] >> 7) & 0x1fffffffffull;
    destination[5]  = (source[2] << 30) & 0x1fffffffffull;
    destination[5] |= (source[3] >> 34) & 0x1fffffffffull;
    destination[6]  = (source[3] << 3) & 0x1fffffffffull;
    destination[6] |= (source[4] >> 61) & 0x1fffffffffull;
    destination[7]  = (source[4] >> 24) & 0x1fffffffffull;
    destination[8]  = (source[4] << 13) & 0x1fffffffffull;
    destination[8] |= (source[5] >> 51) & 0x1fffffffffull;
    destination[9]  = (source[5] >> 14) & 0x1fffffffffull;
    destination[10]  = (source[5] << 23) & 0x1fffffffffull;
    destination[10] |= (source[6] >> 41) & 0x1fffffffffull;
    destination[11]  = (source[6] >> 4) & 0x1fffffffffull;
    destination[12]  = (source[6] << 33) & 0x1fffffffffull;
    destination[12] |= (source[7] >> 31) & 0x1fffffffffull;
    destination[13]  = (source[7] << 6) & 0x1fffffffffull;
    destination[13] |= (source[8] >> 58) & 0x1fffffffffull;
    destination[14]  = (source[8] >> 21) & 0x1fffffffffull;
    destination[15]  = (source[8] << 16) & 0x1fffffffffull;
    destination[15] |= (source[9] >> 48) & 0x1fffffffffull;
    destination[16]  = (source[9] >> 11) & 0x1fffffffffull;
    destination[17]  = (source[9] << 26) & 0x1fffffffffull;
    destination[17] |= (source[10] >> 38) & 0x1fffffffffull;
    destination[18]  = (source[10] >> 1) & 0x1fffffffffull;
    destination[19]  = (source[10] << 36) & 0x1fffffffffull;
    destination[19] |= (source[11] >> 28) & 0x1fffffffffull;
    destination[20]  = (source[11] << 9) & 0x1fffffffffull;
    destination[20] |= (source[12] >> 55) & 0x1fffffffffull;
    destination[21]  = (source[12] >> 18) & 0x1fffffffffull;
    destination[22]  = (source[12] << 19) & 0x1fffffffffull;
    destination[22] |= (source[13] >> 45) & 0x1fffffffffull;
    destination[23]  = (source[13] >> 8) & 0x1fffffffffull;
    destination[24]  = (source[13] << 29) & 0x1fffffffffull;
    destination[24] |= (source[14] >> 35) & 0x1fffffffffull;
    destination[25]  = (source[14] << 2) & 0x1fffffffffull;
    destination[25] |= (source[15] >> 62) & 0x1fffffffffull;
    destination[26]  = (source[15] >> 25) & 0x1fffffffffull;
    destination[27]  = (source[15] << 12) & 0x1fffffffffull;
    destination[27] |= (source[16] >> 52) & 0x1fffffffffull;
    destination[28]  = (source[16] >> 15) & 0x1fffffffffull;
    destination[29]  = (source[16] << 22) & 0x1fffffffffull;
    destination[29] |= (source[17] >> 42) & 0x1fffffffffull;
    destination[30]  = (source[17] >> 5) & 0x1fffffffffull;
    destination[31]  = (source[17] << 32) & 0x1fffffffffull;
    destination[31] |= (source[18] >> 32) & 0x1fffffffffull;
    destination[32]  = (source[18] << 5) & 0x1fffffffffull;
    destination[32] |= (source[19] >> 59) & 0x1fffffffffull;
    destination[33]  = (source[19] >> 22) & 0x1fffffffffull;
    destination[34]  = (source[19] << 15) & 0x1fffffffffull;
    destination[34] |= (source[20] >> 49) & 0x1fffffffffull;
    destination[35]  = (source[20] >> 12) & 0x1fffffffffull;
    destination[36]  = (source[20] << 25) & 0x1fffffffffull;
    destination[36] |= (source[21] >> 39) & 0x1fffffffffull;
    destination[37]  = (source[21] >> 2) & 0x1fffffffffull;
    destination[38]  = (source[21] << 35) & 0x1fffffffffull;
    destination[38] |= (source[22] >> 29) & 0x1fffffffffull;
    destination[39]  = (source[22] << 8) & 0x1fffffffffull;
    destination[39] |= (source[23] >> 56) & 0x1fffffffffull;
    destination[40]  = (source[23] >> 19) & 0x1fffffffffull;
    destination[41]  = (source[23] << 18) & 0x1fffffffffull;
    destination[41] |= (source[24] >> 46) & 0x1fffffffffull;
    destination[42]  = (source[24] >> 9) & 0x1fffffffffull;
    destination[43]  = (source[24] << 28) & 0x1fffffffffull;
    destination[43] |= (source[25] >> 36) & 0x1fffffffffull;
    destination[44]  = (source[25] << 1) & 0x1fffffffffull;
    destination[44] |= (source[26] >> 63) & 0x1fffffffffull;
    destination[45]  = (source[26] >> 26) & 0x1fffffffffull;
    destination[46]  = (source[26] << 11) & 0x1fffffffffull;
    destination[46] |= (source[27] >> 53) & 0x1fffffffffull;
    destination[47]  = (source[27] >> 16) & 0x1fffffffffull;
    destination[48]  = (source[27] << 21) & 0x1fffffffffull;
    destination[48] |= (source[28] >> 43) & 0x1fffffffffull;
    destination[49]  = (source[28] >> 6) & 0x1fffffffffull;
    destination[50]  = (source[28] << 31) & 0x1fffffffffull;
    destination[50] |= (source[29] >> 33) & 0x1fffffffffull;
    destination[51]  = (source[29] << 4) & 0x1fffffffffull;
    destination[51] |= (source[30] >> 60) & 0x1fffffffffull;
    destination[52]  = (source[30] >> 23) & 0x1fffffffffull;
    destination[53]  = (source[30] << 14) & 0x1fffffffffull;
    destination[53] |= (source[31] >> 50) & 0x1fffffffffull;
    destination[54]  = (source[31] >> 13) & 0x1fffffffffull;
    destination[55]  = (source[31] << 24) & 0x1fffffffffull;
    destination[55] |= (source[32] >> 40) & 0x1fffffffffull;
    destination[56]  = (source[32] >> 3) & 0x1fffffffffull;
    destination[57]  = (source[32] << 34) & 0x1fffffffffull;
    destination[57] |= (source[33] >> 30) & 0x1fffffffffull;
    destination[58]  = (source[33] << 7) & 0x1fffffffffull;
    destination[58] |= (source[34] >> 57) & 0x1fffffffffull;
    destination[59]  = (source[34] >> 20) & 0x1fffffffffull;
    destination[60]  = (source[34] << 17) & 0x1fffffffffull;
    destination[60] |= (source[35] >> 47) & 0x1fffffffffull;
    destination[61]  = (source[35] >> 10) & 0x1fffffffffull;
    destination[62]  = (source[35] << 27) & 0x1fffffffffull;
    destination[62] |= (source[36] >> 37) & 0x1fffffffffull;
    destination[63]  = (source[36] >> 0) & 0x1fffffffffull;
  }
};
template <typename Tp>
struct __struct_bitpack_impl<Tp,8,38>
{
  static const size_t unit_size = 64;
  static const size_t bits_total = 2432;
  static const size_t loop_total = 64;
  static const size_t bit_size = 38;
  static const Tp     mask = 0x3fffffffffull;
  static inline
  void pack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] & 0x3fffffffffull) << 26;
    destination[0] |= (source[1] & 0x3fffffffffull) >> 12;
    destination[1]  = (source[1] & 0x3fffffffffull) << 52;
    destination[1] |= (source[2] & 0x3fffffffffull) << 14;
    destination[1] |= (source[3] & 0x3fffffffffull) >> 24;
    destination[2]  = (source[3] & 0x3fffffffffull) << 40;
    destination[2] |= (source[4] & 0x3fffffffffull) << 2;
    destination[2] |= (source[5] & 0x3fffffffffull) >> 36;
    destination[3]  = (source[5] & 0x3fffffffffull) << 28;
    destination[3] |= (source[6] & 0x3fffffffffull) >> 10;
    destination[4]  = (source[6] & 0x3fffffffffull) << 54;
    destination[4] |= (source[7] & 0x3fffffffffull) << 16;
    destination[4] |= (source[8] & 0x3fffffffffull) >> 22;
    destination[5]  = (source[8] & 0x3fffffffffull) << 42;
    destination[5] |= (source[9] & 0x3fffffffffull) << 4;
    destination[5] |= (source[10] & 0x3fffffffffull) >> 34;
    destination[6]  = (source[10] & 0x3fffffffffull) << 30;
    destination[6] |= (source[11] & 0x3fffffffffull) >> 8;
    destination[7]  = (source[11] & 0x3fffffffffull) << 56;
    destination[7] |= (source[12] & 0x3fffffffffull) << 18;
    destination[7] |= (source[13] & 0x3fffffffffull) >> 20;
    destination[8]  = (source[13] & 0x3fffffffffull) << 44;
    destination[8] |= (source[14] & 0x3fffffffffull) << 6;
    destination[8] |= (source[15] & 0x3fffffffffull) >> 32;
    destination[9]  = (source[15] & 0x3fffffffffull) << 32;
    destination[9] |= (source[16] & 0x3fffffffffull) >> 6;
    destination[10]  = (source[16] & 0x3fffffffffull) << 58;
    destination[10] |= (source[17] & 0x3fffffffffull) << 20;
    destination[10] |= (source[18] & 0x3fffffffffull) >> 18;
    destination[11]  = (source[18] & 0x3fffffffffull) << 46;
    destination[11] |= (source[19] & 0x3fffffffffull) << 8;
    destination[11] |= (source[20] & 0x3fffffffffull) >> 30;
    destination[12]  = (source[20] & 0x3fffffffffull) << 34;
    destination[12] |= (source[21] & 0x3fffffffffull) >> 4;
    destination[13]  = (source[21] & 0x3fffffffffull) << 60;
    destination[13] |= (source[22] & 0x3fffffffffull) << 22;
    destination[13] |= (source[23] & 0x3fffffffffull) >> 16;
    destination[14]  = (source[23] & 0x3fffffffffull) << 48;
    destination[14] |= (source[24] & 0x3fffffffffull) << 10;
    destination[14] |= (source[25] & 0x3fffffffffull) >> 28;
    destination[15]  = (source[25] & 0x3fffffffffull) << 36;
    destination[15] |= (source[26] & 0x3fffffffffull) >> 2;
    destination[16]  = (source[26] & 0x3fffffffffull) << 62;
    destination[16] |= (source[27] & 0x3fffffffffull) << 24;
    destination[16] |= (source[28] & 0x3fffffffffull) >> 14;
    destination[17]  = (source[28] & 0x3fffffffffull) << 50;
    destination[17] |= (source[29] & 0x3fffffffffull) << 12;
    destination[17] |= (source[30] & 0x3fffffffffull) >> 26;
    destination[18]  = (source[30] & 0x3fffffffffull) << 38;
    destination[18] |= (source[31] & 0x3fffffffffull) << 0;
    destination[19]  = (source[32] & 0x3fffffffffull) << 26;
    destination[19] |= (source[33] & 0x3fffffffffull) >> 12;
    destination[20]  = (source[33] & 0x3fffffffffull) << 52;
    destination[20] |= (source[34] & 0x3fffffffffull) << 14;
    destination[20] |= (source[35] & 0x3fffffffffull) >> 24;
    destination[21]  = (source[35] & 0x3fffffffffull) << 40;
    destination[21] |= (source[36] & 0x3fffffffffull) << 2;
    destination[21] |= (source[37] & 0x3fffffffffull) >> 36;
    destination[22]  = (source[37] & 0x3fffffffffull) << 28;
    destination[22] |= (source[38] & 0x3fffffffffull) >> 10;
    destination[23]  = (source[38] & 0x3fffffffffull) << 54;
    destination[23] |= (source[39] & 0x3fffffffffull) << 16;
    destination[23] |= (source[40] & 0x3fffffffffull) >> 22;
    destination[24]  = (source[40] & 0x3fffffffffull) << 42;
    destination[24] |= (source[41] & 0x3fffffffffull) << 4;
    destination[24] |= (source[42] & 0x3fffffffffull) >> 34;
    destination[25]  = (source[42] & 0x3fffffffffull) << 30;
    destination[25] |= (source[43] & 0x3fffffffffull) >> 8;
    destination[26]  = (source[43] & 0x3fffffffffull) << 56;
    destination[26] |= (source[44] & 0x3fffffffffull) << 18;
    destination[26] |= (source[45] & 0x3fffffffffull) >> 20;
    destination[27]  = (source[45] & 0x3fffffffffull) << 44;
    destination[27] |= (source[46] & 0x3fffffffffull) << 6;
    destination[27] |= (source[47] & 0x3fffffffffull) >> 32;
    destination[28]  = (source[47] & 0x3fffffffffull) << 32;
    destination[28] |= (source[48] & 0x3fffffffffull) >> 6;
    destination[29]  = (source[48] & 0x3fffffffffull) << 58;
    destination[29] |= (source[49] & 0x3fffffffffull) << 20;
    destination[29] |= (source[50] & 0x3fffffffffull) >> 18;
    destination[30]  = (source[50] & 0x3fffffffffull) << 46;
    destination[30] |= (source[51] & 0x3fffffffffull) << 8;
    destination[30] |= (source[52] & 0x3fffffffffull) >> 30;
    destination[31]  = (source[52] & 0x3fffffffffull) << 34;
    destination[31] |= (source[53] & 0x3fffffffffull) >> 4;
    destination[32]  = (source[53] & 0x3fffffffffull) << 60;
    destination[32] |= (source[54] & 0x3fffffffffull) << 22;
    destination[32] |= (source[55] & 0x3fffffffffull) >> 16;
    destination[33]  = (source[55] & 0x3fffffffffull) << 48;
    destination[33] |= (source[56] & 0x3fffffffffull) << 10;
    destination[33] |= (source[57] & 0x3fffffffffull) >> 28;
    destination[34]  = (source[57] & 0x3fffffffffull) << 36;
    destination[34] |= (source[58] & 0x3fffffffffull) >> 2;
    destination[35]  = (source[58] & 0x3fffffffffull) << 62;
    destination[35] |= (source[59] & 0x3fffffffffull) << 24;
    destination[35] |= (source[60] & 0x3fffffffffull) >> 14;
    destination[36]  = (source[60] & 0x3fffffffffull) << 50;
    destination[36] |= (source[61] & 0x3fffffffffull) << 12;
    destination[36] |= (source[62] & 0x3fffffffffull) >> 26;
    destination[37]  = (source[62] & 0x3fffffffffull) << 38;
    destination[37] |= (source[63] & 0x3fffffffffull) << 0;
  }
  static inline
  void unpack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] >> 26) & 0x3fffffffffull;
    destination[1]  = (source[0] << 12) & 0x3fffffffffull;
    destination[1] |= (source[1] >> 52) & 0x3fffffffffull;
    destination[2]  = (source[1] >> 14) & 0x3fffffffffull;
    destination[3]  = (source[1] << 24) & 0x3fffffffffull;
    destination[3] |= (source[2] >> 40) & 0x3fffffffffull;
    destination[4]  = (source[2] >> 2) & 0x3fffffffffull;
    destination[5]  = (source[2] << 36) & 0x3fffffffffull;
    destination[5] |= (source[3] >> 28) & 0x3fffffffffull;
    destination[6]  = (source[3] << 10) & 0x3fffffffffull;
    destination[6] |= (source[4] >> 54) & 0x3fffffffffull;
    destination[7]  = (source[4] >> 16) & 0x3fffffffffull;
    destination[8]  = (source[4] << 22) & 0x3fffffffffull;
    destination[8] |= (source[5] >> 42) & 0x3fffffffffull;
    destination[9]  = (source[5] >> 4) & 0x3fffffffffull;
    destination[10]  = (source[5] << 34) & 0x3fffffffffull;
    destination[10] |= (source[6] >> 30) & 0x3fffffffffull;
    destination[11]  = (source[6] << 8) & 0x3fffffffffull;
    destination[11] |= (source[7] >> 56) & 0x3fffffffffull;
    destination[12]  = (source[7] >> 18) & 0x3fffffffffull;
    destination[13]  = (source[7] << 20) & 0x3fffffffffull;
    destination[13] |= (source[8] >> 44) & 0x3fffffffffull;
    destination[14]  = (source[8] >> 6) & 0x3fffffffffull;
    destination[15]  = (source[8] << 32) & 0x3fffffffffull;
    destination[15] |= (source[9] >> 32) & 0x3fffffffffull;
    destination[16]  = (source[9] << 6) & 0x3fffffffffull;
    destination[16] |= (source[10] >> 58) & 0x3fffffffffull;
    destination[17]  = (source[10] >> 20) & 0x3fffffffffull;
    destination[18]  = (source[10] << 18) & 0x3fffffffffull;
    destination[18] |= (source[11] >> 46) & 0x3fffffffffull;
    destination[19]  = (source[11] >> 8) & 0x3fffffffffull;
    destination[20]  = (source[11] << 30) & 0x3fffffffffull;
    destination[20] |= (source[12] >> 34) & 0x3fffffffffull;
    destination[21]  = (source[12] << 4) & 0x3fffffffffull;
    destination[21] |= (source[13] >> 60) & 0x3fffffffffull;
    destination[22]  = (source[13] >> 22) & 0x3fffffffffull;
    destination[23]  = (source[13] << 16) & 0x3fffffffffull;
    destination[23] |= (source[14] >> 48) & 0x3fffffffffull;
    destination[24]  = (source[14] >> 10) & 0x3fffffffffull;
    destination[25]  = (source[14] << 28) & 0x3fffffffffull;
    destination[25] |= (source[15] >> 36) & 0x3fffffffffull;
    destination[26]  = (source[15] << 2) & 0x3fffffffffull;
    destination[26] |= (source[16] >> 62) & 0x3fffffffffull;
    destination[27]  = (source[16] >> 24) & 0x3fffffffffull;
    destination[28]  = (source[16] << 14) & 0x3fffffffffull;
    destination[28] |= (source[17] >> 50) & 0x3fffffffffull;
    destination[29]  = (source[17] >> 12) & 0x3fffffffffull;
    destination[30]  = (source[17] << 26) & 0x3fffffffffull;
    destination[30] |= (source[18] >> 38) & 0x3fffffffffull;
    destination[31]  = (source[18] >> 0) & 0x3fffffffffull;
    destination[32]  = (source[19] >> 26) & 0x3fffffffffull;
    destination[33]  = (source[19] << 12) & 0x3fffffffffull;
    destination[33] |= (source[20] >> 52) & 0x3fffffffffull;
    destination[34]  = (source[20] >> 14) & 0x3fffffffffull;
    destination[35]  = (source[20] << 24) & 0x3fffffffffull;
    destination[35] |= (source[21] >> 40) & 0x3fffffffffull;
    destination[36]  = (source[21] >> 2) & 0x3fffffffffull;
    destination[37]  = (source[21] << 36) & 0x3fffffffffull;
    destination[37] |= (source[22] >> 28) & 0x3fffffffffull;
    destination[38]  = (source[22] << 10) & 0x3fffffffffull;
    destination[38] |= (source[23] >> 54) & 0x3fffffffffull;
    destination[39]  = (source[23] >> 16) & 0x3fffffffffull;
    destination[40]  = (source[23] << 22) & 0x3fffffffffull;
    destination[40] |= (source[24] >> 42) & 0x3fffffffffull;
    destination[41]  = (source[24] >> 4) & 0x3fffffffffull;
    destination[42]  = (source[24] << 34) & 0x3fffffffffull;
    destination[42] |= (source[25] >> 30) & 0x3fffffffffull;
    destination[43]  = (source[25] << 8) & 0x3fffffffffull;
    destination[43] |= (source[26] >> 56) & 0x3fffffffffull;
    destination[44]  = (source[26] >> 18) & 0x3fffffffffull;
    destination[45]  = (source[26] << 20) & 0x3fffffffffull;
    destination[45] |= (source[27] >> 44) & 0x3fffffffffull;
    destination[46]  = (source[27] >> 6) & 0x3fffffffffull;
    destination[47]  = (source[27] << 32) & 0x3fffffffffull;
    destination[47] |= (source[28] >> 32) & 0x3fffffffffull;
    destination[48]  = (source[28] << 6) & 0x3fffffffffull;
    destination[48] |= (source[29] >> 58) & 0x3fffffffffull;
    destination[49]  = (source[29] >> 20) & 0x3fffffffffull;
    destination[50]  = (source[29] << 18) & 0x3fffffffffull;
    destination[50] |= (source[30] >> 46) & 0x3fffffffffull;
    destination[51]  = (source[30] >> 8) & 0x3fffffffffull;
    destination[52]  = (source[30] << 30) & 0x3fffffffffull;
    destination[52] |= (source[31] >> 34) & 0x3fffffffffull;
    destination[53]  = (source[31] << 4) & 0x3fffffffffull;
    destination[53] |= (source[32] >> 60) & 0x3fffffffffull;
    destination[54]  = (source[32] >> 22) & 0x3fffffffffull;
    destination[55]  = (source[32] << 16) & 0x3fffffffffull;
    destination[55] |= (source[33] >> 48) & 0x3fffffffffull;
    destination[56]  = (source[33] >> 10) & 0x3fffffffffull;
    destination[57]  = (source[33] << 28) & 0x3fffffffffull;
    destination[57] |= (source[34] >> 36) & 0x3fffffffffull;
    destination[58]  = (source[34] << 2) & 0x3fffffffffull;
    destination[58] |= (source[35] >> 62) & 0x3fffffffffull;
    destination[59]  = (source[35] >> 24) & 0x3fffffffffull;
    destination[60]  = (source[35] << 14) & 0x3fffffffffull;
    destination[60] |= (source[36] >> 50) & 0x3fffffffffull;
    destination[61]  = (source[36] >> 12) & 0x3fffffffffull;
    destination[62]  = (source[36] << 26) & 0x3fffffffffull;
    destination[62] |= (source[37] >> 38) & 0x3fffffffffull;
    destination[63]  = (source[37] >> 0) & 0x3fffffffffull;
  }
};
template <typename Tp>
struct __struct_bitpack_impl<Tp,8,39>
{
  static const size_t unit_size = 64;
  static const size_t bits_total = 2496;
  static const size_t loop_total = 64;
  static const size_t bit_size = 39;
  static const Tp     mask = 0x7fffffffffull;
  static inline
  void pack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] & 0x7fffffffffull) << 25;
    destination[0] |= (source[1] & 0x7fffffffffull) >> 14;
    destination[1]  = (source[1] & 0x7fffffffffull) << 50;
    destination[1] |= (source[2] & 0x7fffffffffull) << 11;
    destination[1] |= (source[3] & 0x7fffffffffull) >> 28;
    destination[2]  = (source[3] & 0x7fffffffffull) << 36;
    destination[2] |= (source[4] & 0x7fffffffffull) >> 3;
    destination[3]  = (source[4] & 0x7fffffffffull) << 61;
    destination[3] |= (source[5] & 0x7fffffffffull) << 22;
    destination[3] |= (source[6] & 0x7fffffffffull) >> 17;
    destination[4]  = (source[6] & 0x7fffffffffull) << 47;
    destination[4] |= (source[7] & 0x7fffffffffull) << 8;
    destination[4] |= (source[8] & 0x7fffffffffull) >> 31;
    destination[5]  = (source[8] & 0x7fffffffffull) << 33;
    destination[5] |= (source[9] & 0x7fffffffffull) >> 6;
    destination[6]  = (source[9] & 0x7fffffffffull) << 58;
    destination[6] |= (source[10] & 0x7fffffffffull) << 19;
    destination[6] |= (source[11] & 0x7fffffffffull) >> 20;
    destination[7]  = (source[11] & 0x7fffffffffull) << 44;
    destination[7] |= (source[12] & 0x7fffffffffull) << 5;
    destination[7] |= (source[13] & 0x7fffffffffull) >> 34;
    destination[8]  = (source[13] & 0x7fffffffffull) << 30;
    destination[8] |= (source[14] & 0x7fffffffffull) >> 9;
    destination[9]  = (source[14] & 0x7fffffffffull) << 55;
    destination[9] |= (source[15] & 0x7fffffffffull) << 16;
    destination[9] |= (source[16] & 0x7fffffffffull) >> 23;
    destination[10]  = (source[16] & 0x7fffffffffull) << 41;
    destination[10] |= (source[17] & 0x7fffffffffull) << 2;
    destination[10] |= (source[18] & 0x7fffffffffull) >> 37;
    destination[11]  = (source[18] & 0x7fffffffffull) << 27;
    destination[11] |= (source[19] & 0x7fffffffffull) >> 12;
    destination[12]  = (source[19] & 0x7fffffffffull) << 52;
    destination[12] |= (source[20] & 0x7fffffffffull) << 13;
    destination[12] |= (source[21] & 0x7fffffffffull) >> 26;
    destination[13]  = (source[21] & 0x7fffffffffull) << 38;
    destination[13] |= (source[22] & 0x7fffffffffull) >> 1;
    destination[14]  = (source[22] & 0x7fffffffffull) << 63;
    destination[14] |= (source[23] & 0x7fffffffffull) << 24;
    destination[14] |= (source[24] & 0x7fffffffffull) >> 15;
    destination[15]  = (source[24] & 0x7fffffffffull) << 49;
    destination[15] |= (source[25] & 0x7fffffffffull) << 10;
    destination[15] |= (source[26] & 0x7fffffffffull) >> 29;
    destination[16]  = (source[26] & 0x7fffffffffull) << 35;
    destination[16] |= (source[27] & 0x7fffffffffull) >> 4;
    destination[17]  = (source[27] & 0x7fffffffffull) << 60;
    destination[17] |= (source[28] & 0x7fffffffffull) << 21;
    destination[17] |= (source[29] & 0x7fffffffffull) >> 18;
    destination[18]  = (source[29] & 0x7fffffffffull) << 46;
    destination[18] |= (source[30] & 0x7fffffffffull) << 7;
    destination[18] |= (source[31] & 0x7fffffffffull) >> 32;
    destination[19]  = (source[31] & 0x7fffffffffull) << 32;
    destination[19] |= (source[32] & 0x7fffffffffull) >> 7;
    destination[20]  = (source[32] & 0x7fffffffffull) << 57;
    destination[20] |= (source[33] & 0x7fffffffffull) << 18;
    destination[20] |= (source[34] & 0x7fffffffffull) >> 21;
    destination[21]  = (source[34] & 0x7fffffffffull) << 43;
    destination[21] |= (source[35] & 0x7fffffffffull) << 4;
    destination[21] |= (source[36] & 0x7fffffffffull) >> 35;
    destination[22]  = (source[36] & 0x7fffffffffull) << 29;
    destination[22] |= (source[37] & 0x7fffffffffull) >> 10;
    destination[23]  = (source[37] & 0x7fffffffffull) << 54;
    destination[23] |= (source[38] & 0x7fffffffffull) << 15;
    destination[23] |= (source[39] & 0x7fffffffffull) >> 24;
    destination[24]  = (source[39] & 0x7fffffffffull) << 40;
    destination[24] |= (source[40] & 0x7fffffffffull) << 1;
    destination[24] |= (source[41] & 0x7fffffffffull) >> 38;
    destination[25]  = (source[41] & 0x7fffffffffull) << 26;
    destination[25] |= (source[42] & 0x7fffffffffull) >> 13;
    destination[26]  = (source[42] & 0x7fffffffffull) << 51;
    destination[26] |= (source[43] & 0x7fffffffffull) << 12;
    destination[26] |= (source[44] & 0x7fffffffffull) >> 27;
    destination[27]  = (source[44] & 0x7fffffffffull) << 37;
    destination[27] |= (source[45] & 0x7fffffffffull) >> 2;
    destination[28]  = (source[45] & 0x7fffffffffull) << 62;
    destination[28] |= (source[46] & 0x7fffffffffull) << 23;
    destination[28] |= (source[47] & 0x7fffffffffull) >> 16;
    destination[29]  = (source[47] & 0x7fffffffffull) << 48;
    destination[29] |= (source[48] & 0x7fffffffffull) << 9;
    destination[29] |= (source[49] & 0x7fffffffffull) >> 30;
    destination[30]  = (source[49] & 0x7fffffffffull) << 34;
    destination[30] |= (source[50] & 0x7fffffffffull) >> 5;
    destination[31]  = (source[50] & 0x7fffffffffull) << 59;
    destination[31] |= (source[51] & 0x7fffffffffull) << 20;
    destination[31] |= (source[52] & 0x7fffffffffull) >> 19;
    destination[32]  = (source[52] & 0x7fffffffffull) << 45;
    destination[32] |= (source[53] & 0x7fffffffffull) << 6;
    destination[32] |= (source[54] & 0x7fffffffffull) >> 33;
    destination[33]  = (source[54] & 0x7fffffffffull) << 31;
    destination[33] |= (source[55] & 0x7fffffffffull) >> 8;
    destination[34]  = (source[55] & 0x7fffffffffull) << 56;
    destination[34] |= (source[56] & 0x7fffffffffull) << 17;
    destination[34] |= (source[57] & 0x7fffffffffull) >> 22;
    destination[35]  = (source[57] & 0x7fffffffffull) << 42;
    destination[35] |= (source[58] & 0x7fffffffffull) << 3;
    destination[35] |= (source[59] & 0x7fffffffffull) >> 36;
    destination[36]  = (source[59] & 0x7fffffffffull) << 28;
    destination[36] |= (source[60] & 0x7fffffffffull) >> 11;
    destination[37]  = (source[60] & 0x7fffffffffull) << 53;
    destination[37] |= (source[61] & 0x7fffffffffull) << 14;
    destination[37] |= (source[62] & 0x7fffffffffull) >> 25;
    destination[38]  = (source[62] & 0x7fffffffffull) << 39;
    destination[38] |= (source[63] & 0x7fffffffffull) << 0;
  }
  static inline
  void unpack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] >> 25) & 0x7fffffffffull;
    destination[1]  = (source[0] << 14) & 0x7fffffffffull;
    destination[1] |= (source[1] >> 50) & 0x7fffffffffull;
    destination[2]  = (source[1] >> 11) & 0x7fffffffffull;
    destination[3]  = (source[1] << 28) & 0x7fffffffffull;
    destination[3] |= (source[2] >> 36) & 0x7fffffffffull;
    destination[4]  = (source[2] << 3) & 0x7fffffffffull;
    destination[4] |= (source[3] >> 61) & 0x7fffffffffull;
    destination[5]  = (source[3] >> 22) & 0x7fffffffffull;
    destination[6]  = (source[3] << 17) & 0x7fffffffffull;
    destination[6] |= (source[4] >> 47) & 0x7fffffffffull;
    destination[7]  = (source[4] >> 8) & 0x7fffffffffull;
    destination[8]  = (source[4] << 31) & 0x7fffffffffull;
    destination[8] |= (source[5] >> 33) & 0x7fffffffffull;
    destination[9]  = (source[5] << 6) & 0x7fffffffffull;
    destination[9] |= (source[6] >> 58) & 0x7fffffffffull;
    destination[10]  = (source[6] >> 19) & 0x7fffffffffull;
    destination[11]  = (source[6] << 20) & 0x7fffffffffull;
    destination[11] |= (source[7] >> 44) & 0x7fffffffffull;
    destination[12]  = (source[7] >> 5) & 0x7fffffffffull;
    destination[13]  = (source[7] << 34) & 0x7fffffffffull;
    destination[13] |= (source[8] >> 30) & 0x7fffffffffull;
    destination[14]  = (source[8] << 9) & 0x7fffffffffull;
    destination[14] |= (source[9] >> 55) & 0x7fffffffffull;
    destination[15]  = (source[9] >> 16) & 0x7fffffffffull;
    destination[16]  = (source[9] << 23) & 0x7fffffffffull;
    destination[16] |= (source[10] >> 41) & 0x7fffffffffull;
    destination[17]  = (source[10] >> 2) & 0x7fffffffffull;
    destination[18]  = (source[10] << 37) & 0x7fffffffffull;
    destination[18] |= (source[11] >> 27) & 0x7fffffffffull;
    destination[19]  = (source[11] << 12) & 0x7fffffffffull;
    destination[19] |= (source[12] >> 52) & 0x7fffffffffull;
    destination[20]  = (source[12] >> 13) & 0x7fffffffffull;
    destination[21]  = (source[12] << 26) & 0x7fffffffffull;
    destination[21] |= (source[13] >> 38) & 0x7fffffffffull;
    destination[22]  = (source[13] << 1) & 0x7fffffffffull;
    destination[22] |= (source[14] >> 63) & 0x7fffffffffull;
    destination[23]  = (source[14] >> 24) & 0x7fffffffffull;
    destination[24]  = (source[14] << 15) & 0x7fffffffffull;
    destination[24] |= (source[15] >> 49) & 0x7fffffffffull;
    destination[25]  = (source[15] >> 10) & 0x7fffffffffull;
    destination[26]  = (source[15] << 29) & 0x7fffffffffull;
    destination[26] |= (source[16] >> 35) & 0x7fffffffffull;
    destination[27]  = (source[16] << 4) & 0x7fffffffffull;
    destination[27] |= (source[17] >> 60) & 0x7fffffffffull;
    destination[28]  = (source[17] >> 21) & 0x7fffffffffull;
    destination[29]  = (source[17] << 18) & 0x7fffffffffull;
    destination[29] |= (source[18] >> 46) & 0x7fffffffffull;
    destination[30]  = (source[18] >> 7) & 0x7fffffffffull;
    destination[31]  = (source[18] << 32) & 0x7fffffffffull;
    destination[31] |= (source[19] >> 32) & 0x7fffffffffull;
    destination[32]  = (source[19] << 7) & 0x7fffffffffull;
    destination[32] |= (source[20] >> 57) & 0x7fffffffffull;
    destination[33]  = (source[20] >> 18) & 0x7fffffffffull;
    destination[34]  = (source[20] << 21) & 0x7fffffffffull;
    destination[34] |= (source[21] >> 43) & 0x7fffffffffull;
    destination[35]  = (source[21] >> 4) & 0x7fffffffffull;
    destination[36]  = (source[21] << 35) & 0x7fffffffffull;
    destination[36] |= (source[22] >> 29) & 0x7fffffffffull;
    destination[37]  = (source[22] << 10) & 0x7fffffffffull;
    destination[37] |= (source[23] >> 54) & 0x7fffffffffull;
    destination[38]  = (source[23] >> 15) & 0x7fffffffffull;
    destination[39]  = (source[23] << 24) & 0x7fffffffffull;
    destination[39] |= (source[24] >> 40) & 0x7fffffffffull;
    destination[40]  = (source[24] >> 1) & 0x7fffffffffull;
    destination[41]  = (source[24] << 38) & 0x7fffffffffull;
    destination[41] |= (source[25] >> 26) & 0x7fffffffffull;
    destination[42]  = (source[25] << 13) & 0x7fffffffffull;
    destination[42] |= (source[26] >> 51) & 0x7fffffffffull;
    destination[43]  = (source[26] >> 12) & 0x7fffffffffull;
    destination[44]  = (source[26] << 27) & 0x7fffffffffull;
    destination[44] |= (source[27] >> 37) & 0x7fffffffffull;
    destination[45]  = (source[27] << 2) & 0x7fffffffffull;
    destination[45] |= (source[28] >> 62) & 0x7fffffffffull;
    destination[46]  = (source[28] >> 23) & 0x7fffffffffull;
    destination[47]  = (source[28] << 16) & 0x7fffffffffull;
    destination[47] |= (source[29] >> 48) & 0x7fffffffffull;
    destination[48]  = (source[29] >> 9) & 0x7fffffffffull;
    destination[49]  = (source[29] << 30) & 0x7fffffffffull;
    destination[49] |= (source[30] >> 34) & 0x7fffffffffull;
    destination[50]  = (source[30] << 5) & 0x7fffffffffull;
    destination[50] |= (source[31] >> 59) & 0x7fffffffffull;
    destination[51]  = (source[31] >> 20) & 0x7fffffffffull;
    destination[52]  = (source[31] << 19) & 0x7fffffffffull;
    destination[52] |= (source[32] >> 45) & 0x7fffffffffull;
    destination[53]  = (source[32] >> 6) & 0x7fffffffffull;
    destination[54]  = (source[32] << 33) & 0x7fffffffffull;
    destination[54] |= (source[33] >> 31) & 0x7fffffffffull;
    destination[55]  = (source[33] << 8) & 0x7fffffffffull;
    destination[55] |= (source[34] >> 56) & 0x7fffffffffull;
    destination[56]  = (source[34] >> 17) & 0x7fffffffffull;
    destination[57]  = (source[34] << 22) & 0x7fffffffffull;
    destination[57] |= (source[35] >> 42) & 0x7fffffffffull;
    destination[58]  = (source[35] >> 3) & 0x7fffffffffull;
    destination[59]  = (source[35] << 36) & 0x7fffffffffull;
    destination[59] |= (source[36] >> 28) & 0x7fffffffffull;
    destination[60]  = (source[36] << 11) & 0x7fffffffffull;
    destination[60] |= (source[37] >> 53) & 0x7fffffffffull;
    destination[61]  = (source[37] >> 14) & 0x7fffffffffull;
    destination[62]  = (source[37] << 25) & 0x7fffffffffull;
    destination[62] |= (source[38] >> 39) & 0x7fffffffffull;
    destination[63]  = (source[38] >> 0) & 0x7fffffffffull;
  }
};
template <typename Tp>
struct __struct_bitpack_impl<Tp,8,40>
{
  static const size_t unit_size = 64;
  static const size_t bits_total = 2560;
  static const size_t loop_total = 64;
  static const size_t bit_size = 40;
  static const Tp     mask = 0xffffffffffull;
  static inline
  void pack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] & 0xffffffffffull) << 24;
    destination[0] |= (source[1] & 0xffffffffffull) >> 16;
    destination[1]  = (source[1] & 0xffffffffffull) << 48;
    destination[1] |= (source[2] & 0xffffffffffull) << 8;
    destination[1] |= (source[3] & 0xffffffffffull) >> 32;
    destination[2]  = (source[3] & 0xffffffffffull) << 32;
    destination[2] |= (source[4] & 0xffffffffffull) >> 8;
    destination[3]  = (source[4] & 0xffffffffffull) << 56;
    destination[3] |= (source[5] & 0xffffffffffull) << 16;
    destination[3] |= (source[6] & 0xffffffffffull) >> 24;
    destination[4]  = (source[6] & 0xffffffffffull) << 40;
    destination[4] |= (source[7] & 0xffffffffffull) << 0;
    destination[5]  = (source[8] & 0xffffffffffull) << 24;
    destination[5] |= (source[9] & 0xffffffffffull) >> 16;
    destination[6]  = (source[9] & 0xffffffffffull) << 48;
    destination[6] |= (source[10] & 0xffffffffffull) << 8;
    destination[6] |= (source[11] & 0xffffffffffull) >> 32;
    destination[7]  = (source[11] & 0xffffffffffull) << 32;
    destination[7] |= (source[12] & 0xffffffffffull) >> 8;
    destination[8]  = (source[12] & 0xffffffffffull) << 56;
    destination[8] |= (source[13] & 0xffffffffffull) << 16;
    destination[8] |= (source[14] & 0xffffffffffull) >> 24;
    destination[9]  = (source[14] & 0xffffffffffull) << 40;
    destination[9] |= (source[15] & 0xffffffffffull) << 0;
    destination[10]  = (source[16] & 0xffffffffffull) << 24;
    destination[10] |= (source[17] & 0xffffffffffull) >> 16;
    destination[11]  = (source[17] & 0xffffffffffull) << 48;
    destination[11] |= (source[18] & 0xffffffffffull) << 8;
    destination[11] |= (source[19] & 0xffffffffffull) >> 32;
    destination[12]  = (source[19] & 0xffffffffffull) << 32;
    destination[12] |= (source[20] & 0xffffffffffull) >> 8;
    destination[13]  = (source[20] & 0xffffffffffull) << 56;
    destination[13] |= (source[21] & 0xffffffffffull) << 16;
    destination[13] |= (source[22] & 0xffffffffffull) >> 24;
    destination[14]  = (source[22] & 0xffffffffffull) << 40;
    destination[14] |= (source[23] & 0xffffffffffull) << 0;
    destination[15]  = (source[24] & 0xffffffffffull) << 24;
    destination[15] |= (source[25] & 0xffffffffffull) >> 16;
    destination[16]  = (source[25] & 0xffffffffffull) << 48;
    destination[16] |= (source[26] & 0xffffffffffull) << 8;
    destination[16] |= (source[27] & 0xffffffffffull) >> 32;
    destination[17]  = (source[27] & 0xffffffffffull) << 32;
    destination[17] |= (source[28] & 0xffffffffffull) >> 8;
    destination[18]  = (source[28] & 0xffffffffffull) << 56;
    destination[18] |= (source[29] & 0xffffffffffull) << 16;
    destination[18] |= (source[30] & 0xffffffffffull) >> 24;
    destination[19]  = (source[30] & 0xffffffffffull) << 40;
    destination[19] |= (source[31] & 0xffffffffffull) << 0;
    destination[20]  = (source[32] & 0xffffffffffull) << 24;
    destination[20] |= (source[33] & 0xffffffffffull) >> 16;
    destination[21]  = (source[33] & 0xffffffffffull) << 48;
    destination[21] |= (source[34] & 0xffffffffffull) << 8;
    destination[21] |= (source[35] & 0xffffffffffull) >> 32;
    destination[22]  = (source[35] & 0xffffffffffull) << 32;
    destination[22] |= (source[36] & 0xffffffffffull) >> 8;
    destination[23]  = (source[36] & 0xffffffffffull) << 56;
    destination[23] |= (source[37] & 0xffffffffffull) << 16;
    destination[23] |= (source[38] & 0xffffffffffull) >> 24;
    destination[24]  = (source[38] & 0xffffffffffull) << 40;
    destination[24] |= (source[39] & 0xffffffffffull) << 0;
    destination[25]  = (source[40] & 0xffffffffffull) << 24;
    destination[25] |= (source[41] & 0xffffffffffull) >> 16;
    destination[26]  = (source[41] & 0xffffffffffull) << 48;
    destination[26] |= (source[42] & 0xffffffffffull) << 8;
    destination[26] |= (source[43] & 0xffffffffffull) >> 32;
    destination[27]  = (source[43] & 0xffffffffffull) << 32;
    destination[27] |= (source[44] & 0xffffffffffull) >> 8;
    destination[28]  = (source[44] & 0xffffffffffull) << 56;
    destination[28] |= (source[45] & 0xffffffffffull) << 16;
    destination[28] |= (source[46] & 0xffffffffffull) >> 24;
    destination[29]  = (source[46] & 0xffffffffffull) << 40;
    destination[29] |= (source[47] & 0xffffffffffull) << 0;
    destination[30]  = (source[48] & 0xffffffffffull) << 24;
    destination[30] |= (source[49] & 0xffffffffffull) >> 16;
    destination[31]  = (source[49] & 0xffffffffffull) << 48;
    destination[31] |= (source[50] & 0xffffffffffull) << 8;
    destination[31] |= (source[51] & 0xffffffffffull) >> 32;
    destination[32]  = (source[51] & 0xffffffffffull) << 32;
    destination[32] |= (source[52] & 0xffffffffffull) >> 8;
    destination[33]  = (source[52] & 0xffffffffffull) << 56;
    destination[33] |= (source[53] & 0xffffffffffull) << 16;
    destination[33] |= (source[54] & 0xffffffffffull) >> 24;
    destination[34]  = (source[54] & 0xffffffffffull) << 40;
    destination[34] |= (source[55] & 0xffffffffffull) << 0;
    destination[35]  = (source[56] & 0xffffffffffull) << 24;
    destination[35] |= (source[57] & 0xffffffffffull) >> 16;
    destination[36]  = (source[57] & 0xffffffffffull) << 48;
    destination[36] |= (source[58] & 0xffffffffffull) << 8;
    destination[36] |= (source[59] & 0xffffffffffull) >> 32;
    destination[37]  = (source[59] & 0xffffffffffull) << 32;
    destination[37] |= (source[60] & 0xffffffffffull) >> 8;
    destination[38]  = (source[60] & 0xffffffffffull) << 56;
    destination[38] |= (source[61] & 0xffffffffffull) << 16;
    destination[38] |= (source[62] & 0xffffffffffull) >> 24;
    destination[39]  = (source[62] & 0xffffffffffull) << 40;
    destination[39] |= (source[63] & 0xffffffffffull) << 0;
  }
  static inline
  void unpack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] >> 24) & 0xffffffffffull;
    destination[1]  = (source[0] << 16) & 0xffffffffffull;
    destination[1] |= (source[1] >> 48) & 0xffffffffffull;
    destination[2]  = (source[1] >> 8) & 0xffffffffffull;
    destination[3]  = (source[1] << 32) & 0xffffffffffull;
    destination[3] |= (source[2] >> 32) & 0xffffffffffull;
    destination[4]  = (source[2] << 8) & 0xffffffffffull;
    destination[4] |= (source[3] >> 56) & 0xffffffffffull;
    destination[5]  = (source[3] >> 16) & 0xffffffffffull;
    destination[6]  = (source[3] << 24) & 0xffffffffffull;
    destination[6] |= (source[4] >> 40) & 0xffffffffffull;
    destination[7]  = (source[4] >> 0) & 0xffffffffffull;
    destination[8]  = (source[5] >> 24) & 0xffffffffffull;
    destination[9]  = (source[5] << 16) & 0xffffffffffull;
    destination[9] |= (source[6] >> 48) & 0xffffffffffull;
    destination[10]  = (source[6] >> 8) & 0xffffffffffull;
    destination[11]  = (source[6] << 32) & 0xffffffffffull;
    destination[11] |= (source[7] >> 32) & 0xffffffffffull;
    destination[12]  = (source[7] << 8) & 0xffffffffffull;
    destination[12] |= (source[8] >> 56) & 0xffffffffffull;
    destination[13]  = (source[8] >> 16) & 0xffffffffffull;
    destination[14]  = (source[8] << 24) & 0xffffffffffull;
    destination[14] |= (source[9] >> 40) & 0xffffffffffull;
    destination[15]  = (source[9] >> 0) & 0xffffffffffull;
    destination[16]  = (source[10] >> 24) & 0xffffffffffull;
    destination[17]  = (source[10] << 16) & 0xffffffffffull;
    destination[17] |= (source[11] >> 48) & 0xffffffffffull;
    destination[18]  = (source[11] >> 8) & 0xffffffffffull;
    destination[19]  = (source[11] << 32) & 0xffffffffffull;
    destination[19] |= (source[12] >> 32) & 0xffffffffffull;
    destination[20]  = (source[12] << 8) & 0xffffffffffull;
    destination[20] |= (source[13] >> 56) & 0xffffffffffull;
    destination[21]  = (source[13] >> 16) & 0xffffffffffull;
    destination[22]  = (source[13] << 24) & 0xffffffffffull;
    destination[22] |= (source[14] >> 40) & 0xffffffffffull;
    destination[23]  = (source[14] >> 0) & 0xffffffffffull;
    destination[24]  = (source[15] >> 24) & 0xffffffffffull;
    destination[25]  = (source[15] << 16) & 0xffffffffffull;
    destination[25] |= (source[16] >> 48) & 0xffffffffffull;
    destination[26]  = (source[16] >> 8) & 0xffffffffffull;
    destination[27]  = (source[16] << 32) & 0xffffffffffull;
    destination[27] |= (source[17] >> 32) & 0xffffffffffull;
    destination[28]  = (source[17] << 8) & 0xffffffffffull;
    destination[28] |= (source[18] >> 56) & 0xffffffffffull;
    destination[29]  = (source[18] >> 16) & 0xffffffffffull;
    destination[30]  = (source[18] << 24) & 0xffffffffffull;
    destination[30] |= (source[19] >> 40) & 0xffffffffffull;
    destination[31]  = (source[19] >> 0) & 0xffffffffffull;
    destination[32]  = (source[20] >> 24) & 0xffffffffffull;
    destination[33]  = (source[20] << 16) & 0xffffffffffull;
    destination[33] |= (source[21] >> 48) & 0xffffffffffull;
    destination[34]  = (source[21] >> 8) & 0xffffffffffull;
    destination[35]  = (source[21] << 32) & 0xffffffffffull;
    destination[35] |= (source[22] >> 32) & 0xffffffffffull;
    destination[36]  = (source[22] << 8) & 0xffffffffffull;
    destination[36] |= (source[23] >> 56) & 0xffffffffffull;
    destination[37]  = (source[23] >> 16) & 0xffffffffffull;
    destination[38]  = (source[23] << 24) & 0xffffffffffull;
    destination[38] |= (source[24] >> 40) & 0xffffffffffull;
    destination[39]  = (source[24] >> 0) & 0xffffffffffull;
    destination[40]  = (source[25] >> 24) & 0xffffffffffull;
    destination[41]  = (source[25] << 16) & 0xffffffffffull;
    destination[41] |= (source[26] >> 48) & 0xffffffffffull;
    destination[42]  = (source[26] >> 8) & 0xffffffffffull;
    destination[43]  = (source[26] << 32) & 0xffffffffffull;
    destination[43] |= (source[27] >> 32) & 0xffffffffffull;
    destination[44]  = (source[27] << 8) & 0xffffffffffull;
    destination[44] |= (source[28] >> 56) & 0xffffffffffull;
    destination[45]  = (source[28] >> 16) & 0xffffffffffull;
    destination[46]  = (source[28] << 24) & 0xffffffffffull;
    destination[46] |= (source[29] >> 40) & 0xffffffffffull;
    destination[47]  = (source[29] >> 0) & 0xffffffffffull;
    destination[48]  = (source[30] >> 24) & 0xffffffffffull;
    destination[49]  = (source[30] << 16) & 0xffffffffffull;
    destination[49] |= (source[31] >> 48) & 0xffffffffffull;
    destination[50]  = (source[31] >> 8) & 0xffffffffffull;
    destination[51]  = (source[31] << 32) & 0xffffffffffull;
    destination[51] |= (source[32] >> 32) & 0xffffffffffull;
    destination[52]  = (source[32] << 8) & 0xffffffffffull;
    destination[52] |= (source[33] >> 56) & 0xffffffffffull;
    destination[53]  = (source[33] >> 16) & 0xffffffffffull;
    destination[54]  = (source[33] << 24) & 0xffffffffffull;
    destination[54] |= (source[34] >> 40) & 0xffffffffffull;
    destination[55]  = (source[34] >> 0) & 0xffffffffffull;
    destination[56]  = (source[35] >> 24) & 0xffffffffffull;
    destination[57]  = (source[35] << 16) & 0xffffffffffull;
    destination[57] |= (source[36] >> 48) & 0xffffffffffull;
    destination[58]  = (source[36] >> 8) & 0xffffffffffull;
    destination[59]  = (source[36] << 32) & 0xffffffffffull;
    destination[59] |= (source[37] >> 32) & 0xffffffffffull;
    destination[60]  = (source[37] << 8) & 0xffffffffffull;
    destination[60] |= (source[38] >> 56) & 0xffffffffffull;
    destination[61]  = (source[38] >> 16) & 0xffffffffffull;
    destination[62]  = (source[38] << 24) & 0xffffffffffull;
    destination[62] |= (source[39] >> 40) & 0xffffffffffull;
    destination[63]  = (source[39] >> 0) & 0xffffffffffull;
  }
};
template <typename Tp>
struct __struct_bitpack_impl<Tp,8,41>
{
  static const size_t unit_size = 64;
  static const size_t bits_total = 2624;
  static const size_t loop_total = 64;
  static const size_t bit_size = 41;
  static const Tp     mask = 0x1ffffffffffull;
  static inline
  void pack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] & 0x1ffffffffffull) << 23;
    destination[0] |= (source[1] & 0x1ffffffffffull) >> 18;
    destination[1]  = (source[1] & 0x1ffffffffffull) << 46;
    destination[1] |= (source[2] & 0x1ffffffffffull) << 5;
    destination[1] |= (source[3] & 0x1ffffffffffull) >> 36;
    destination[2]  = (source[3] & 0x1ffffffffffull) << 28;
    destination[2] |= (source[4] & 0x1ffffffffffull) >> 13;
    destination[3]  = (source[4] & 0x1ffffffffffull) << 51;
    destination[3] |= (source[5] & 0x1ffffffffffull) << 10;
    destination[3] |= (source[6] & 0x1ffffffffffull) >> 31;
    destination[4]  = (source[6] & 0x1ffffffffffull) << 33;
    destination[4] |= (source[7] & 0x1ffffffffffull) >> 8;
    destination[5]  = (source[7] & 0x1ffffffffffull) << 56;
    destination[5] |= (source[8] & 0x1ffffffffffull) << 15;
    destination[5] |= (source[9] & 0x1ffffffffffull) >> 26;
    destination[6]  = (source[9] & 0x1ffffffffffull) << 38;
    destination[6] |= (source[10] & 0x1ffffffffffull) >> 3;
    destination[7]  = (source[10] & 0x1ffffffffffull) << 61;
    destination[7] |= (source[11] & 0x1ffffffffffull) << 20;
    destination[7] |= (source[12] & 0x1ffffffffffull) >> 21;
    destination[8]  = (source[12] & 0x1ffffffffffull) << 43;
    destination[8] |= (source[13] & 0x1ffffffffffull) << 2;
    destination[8] |= (source[14] & 0x1ffffffffffull) >> 39;
    destination[9]  = (source[14] & 0x1ffffffffffull) << 25;
    destination[9] |= (source[15] & 0x1ffffffffffull) >> 16;
    destination[10]  = (source[15] & 0x1ffffffffffull) << 48;
    destination[10] |= (source[16] & 0x1ffffffffffull) << 7;
    destination[10] |= (source[17] & 0x1ffffffffffull) >> 34;
    destination[11]  = (source[17] & 0x1ffffffffffull) << 30;
    destination[11] |= (source[18] & 0x1ffffffffffull) >> 11;
    destination[12]  = (source[18] & 0x1ffffffffffull) << 53;
    destination[12] |= (source[19] & 0x1ffffffffffull) << 12;
    destination[12] |= (source[20] & 0x1ffffffffffull) >> 29;
    destination[13]  = (source[20] & 0x1ffffffffffull) << 35;
    destination[13] |= (source[21] & 0x1ffffffffffull) >> 6;
    destination[14]  = (source[21] & 0x1ffffffffffull) << 58;
    destination[14] |= (source[22] & 0x1ffffffffffull) << 17;
    destination[14] |= (source[23] & 0x1ffffffffffull) >> 24;
    destination[15]  = (source[23] & 0x1ffffffffffull) << 40;
    destination[15] |= (source[24] & 0x1ffffffffffull) >> 1;
    destination[16]  = (source[24] & 0x1ffffffffffull) << 63;
    destination[16] |= (source[25] & 0x1ffffffffffull) << 22;
    destination[16] |= (source[26] & 0x1ffffffffffull) >> 19;
    destination[17]  = (source[26] & 0x1ffffffffffull) << 45;
    destination[17] |= (source[27] & 0x1ffffffffffull) << 4;
    destination[17] |= (source[28] & 0x1ffffffffffull) >> 37;
    destination[18]  = (source[28] & 0x1ffffffffffull) << 27;
    destination[18] |= (source[29] & 0x1ffffffffffull) >> 14;
    destination[19]  = (source[29] & 0x1ffffffffffull) << 50;
    destination[19] |= (source[30] & 0x1ffffffffffull) << 9;
    destination[19] |= (source[31] & 0x1ffffffffffull) >> 32;
    destination[20]  = (source[31] & 0x1ffffffffffull) << 32;
    destination[20] |= (source[32] & 0x1ffffffffffull) >> 9;
    destination[21]  = (source[32] & 0x1ffffffffffull) << 55;
    destination[21] |= (source[33] & 0x1ffffffffffull) << 14;
    destination[21] |= (source[34] & 0x1ffffffffffull) >> 27;
    destination[22]  = (source[34] & 0x1ffffffffffull) << 37;
    destination[22] |= (source[35] & 0x1ffffffffffull) >> 4;
    destination[23]  = (source[35] & 0x1ffffffffffull) << 60;
    destination[23] |= (source[36] & 0x1ffffffffffull) << 19;
    destination[23] |= (source[37] & 0x1ffffffffffull) >> 22;
    destination[24]  = (source[37] & 0x1ffffffffffull) << 42;
    destination[24] |= (source[38] & 0x1ffffffffffull) << 1;
    destination[24] |= (source[39] & 0x1ffffffffffull) >> 40;
    destination[25]  = (source[39] & 0x1ffffffffffull) << 24;
    destination[25] |= (source[40] & 0x1ffffffffffull) >> 17;
    destination[26]  = (source[40] & 0x1ffffffffffull) << 47;
    destination[26] |= (source[41] & 0x1ffffffffffull) << 6;
    destination[26] |= (source[42] & 0x1ffffffffffull) >> 35;
    destination[27]  = (source[42] & 0x1ffffffffffull) << 29;
    destination[27] |= (source[43] & 0x1ffffffffffull) >> 12;
    destination[28]  = (source[43] & 0x1ffffffffffull) << 52;
    destination[28] |= (source[44] & 0x1ffffffffffull) << 11;
    destination[28] |= (source[45] & 0x1ffffffffffull) >> 30;
    destination[29]  = (source[45] & 0x1ffffffffffull) << 34;
    destination[29] |= (source[46] & 0x1ffffffffffull) >> 7;
    destination[30]  = (source[46] & 0x1ffffffffffull) << 57;
    destination[30] |= (source[47] & 0x1ffffffffffull) << 16;
    destination[30] |= (source[48] & 0x1ffffffffffull) >> 25;
    destination[31]  = (source[48] & 0x1ffffffffffull) << 39;
    destination[31] |= (source[49] & 0x1ffffffffffull) >> 2;
    destination[32]  = (source[49] & 0x1ffffffffffull) << 62;
    destination[32] |= (source[50] & 0x1ffffffffffull) << 21;
    destination[32] |= (source[51] & 0x1ffffffffffull) >> 20;
    destination[33]  = (source[51] & 0x1ffffffffffull) << 44;
    destination[33] |= (source[52] & 0x1ffffffffffull) << 3;
    destination[33] |= (source[53] & 0x1ffffffffffull) >> 38;
    destination[34]  = (source[53] & 0x1ffffffffffull) << 26;
    destination[34] |= (source[54] & 0x1ffffffffffull) >> 15;
    destination[35]  = (source[54] & 0x1ffffffffffull) << 49;
    destination[35] |= (source[55] & 0x1ffffffffffull) << 8;
    destination[35] |= (source[56] & 0x1ffffffffffull) >> 33;
    destination[36]  = (source[56] & 0x1ffffffffffull) << 31;
    destination[36] |= (source[57] & 0x1ffffffffffull) >> 10;
    destination[37]  = (source[57] & 0x1ffffffffffull) << 54;
    destination[37] |= (source[58] & 0x1ffffffffffull) << 13;
    destination[37] |= (source[59] & 0x1ffffffffffull) >> 28;
    destination[38]  = (source[59] & 0x1ffffffffffull) << 36;
    destination[38] |= (source[60] & 0x1ffffffffffull) >> 5;
    destination[39]  = (source[60] & 0x1ffffffffffull) << 59;
    destination[39] |= (source[61] & 0x1ffffffffffull) << 18;
    destination[39] |= (source[62] & 0x1ffffffffffull) >> 23;
    destination[40]  = (source[62] & 0x1ffffffffffull) << 41;
    destination[40] |= (source[63] & 0x1ffffffffffull) << 0;
  }
  static inline
  void unpack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] >> 23) & 0x1ffffffffffull;
    destination[1]  = (source[0] << 18) & 0x1ffffffffffull;
    destination[1] |= (source[1] >> 46) & 0x1ffffffffffull;
    destination[2]  = (source[1] >> 5) & 0x1ffffffffffull;
    destination[3]  = (source[1] << 36) & 0x1ffffffffffull;
    destination[3] |= (source[2] >> 28) & 0x1ffffffffffull;
    destination[4]  = (source[2] << 13) & 0x1ffffffffffull;
    destination[4] |= (source[3] >> 51) & 0x1ffffffffffull;
    destination[5]  = (source[3] >> 10) & 0x1ffffffffffull;
    destination[6]  = (source[3] << 31) & 0x1ffffffffffull;
    destination[6] |= (source[4] >> 33) & 0x1ffffffffffull;
    destination[7]  = (source[4] << 8) & 0x1ffffffffffull;
    destination[7] |= (source[5] >> 56) & 0x1ffffffffffull;
    destination[8]  = (source[5] >> 15) & 0x1ffffffffffull;
    destination[9]  = (source[5] << 26) & 0x1ffffffffffull;
    destination[9] |= (source[6] >> 38) & 0x1ffffffffffull;
    destination[10]  = (source[6] << 3) & 0x1ffffffffffull;
    destination[10] |= (source[7] >> 61) & 0x1ffffffffffull;
    destination[11]  = (source[7] >> 20) & 0x1ffffffffffull;
    destination[12]  = (source[7] << 21) & 0x1ffffffffffull;
    destination[12] |= (source[8] >> 43) & 0x1ffffffffffull;
    destination[13]  = (source[8] >> 2) & 0x1ffffffffffull;
    destination[14]  = (source[8] << 39) & 0x1ffffffffffull;
    destination[14] |= (source[9] >> 25) & 0x1ffffffffffull;
    destination[15]  = (source[9] << 16) & 0x1ffffffffffull;
    destination[15] |= (source[10] >> 48) & 0x1ffffffffffull;
    destination[16]  = (source[10] >> 7) & 0x1ffffffffffull;
    destination[17]  = (source[10] << 34) & 0x1ffffffffffull;
    destination[17] |= (source[11] >> 30) & 0x1ffffffffffull;
    destination[18]  = (source[11] << 11) & 0x1ffffffffffull;
    destination[18] |= (source[12] >> 53) & 0x1ffffffffffull;
    destination[19]  = (source[12] >> 12) & 0x1ffffffffffull;
    destination[20]  = (source[12] << 29) & 0x1ffffffffffull;
    destination[20] |= (source[13] >> 35) & 0x1ffffffffffull;
    destination[21]  = (source[13] << 6) & 0x1ffffffffffull;
    destination[21] |= (source[14] >> 58) & 0x1ffffffffffull;
    destination[22]  = (source[14] >> 17) & 0x1ffffffffffull;
    destination[23]  = (source[14] << 24) & 0x1ffffffffffull;
    destination[23] |= (source[15] >> 40) & 0x1ffffffffffull;
    destination[24]  = (source[15] << 1) & 0x1ffffffffffull;
    destination[24] |= (source[16] >> 63) & 0x1ffffffffffull;
    destination[25]  = (source[16] >> 22) & 0x1ffffffffffull;
    destination[26]  = (source[16] << 19) & 0x1ffffffffffull;
    destination[26] |= (source[17] >> 45) & 0x1ffffffffffull;
    destination[27]  = (source[17] >> 4) & 0x1ffffffffffull;
    destination[28]  = (source[17] << 37) & 0x1ffffffffffull;
    destination[28] |= (source[18] >> 27) & 0x1ffffffffffull;
    destination[29]  = (source[18] << 14) & 0x1ffffffffffull;
    destination[29] |= (source[19] >> 50) & 0x1ffffffffffull;
    destination[30]  = (source[19] >> 9) & 0x1ffffffffffull;
    destination[31]  = (source[19] << 32) & 0x1ffffffffffull;
    destination[31] |= (source[20] >> 32) & 0x1ffffffffffull;
    destination[32]  = (source[20] << 9) & 0x1ffffffffffull;
    destination[32] |= (source[21] >> 55) & 0x1ffffffffffull;
    destination[33]  = (source[21] >> 14) & 0x1ffffffffffull;
    destination[34]  = (source[21] << 27) & 0x1ffffffffffull;
    destination[34] |= (source[22] >> 37) & 0x1ffffffffffull;
    destination[35]  = (source[22] << 4) & 0x1ffffffffffull;
    destination[35] |= (source[23] >> 60) & 0x1ffffffffffull;
    destination[36]  = (source[23] >> 19) & 0x1ffffffffffull;
    destination[37]  = (source[23] << 22) & 0x1ffffffffffull;
    destination[37] |= (source[24] >> 42) & 0x1ffffffffffull;
    destination[38]  = (source[24] >> 1) & 0x1ffffffffffull;
    destination[39]  = (source[24] << 40) & 0x1ffffffffffull;
    destination[39] |= (source[25] >> 24) & 0x1ffffffffffull;
    destination[40]  = (source[25] << 17) & 0x1ffffffffffull;
    destination[40] |= (source[26] >> 47) & 0x1ffffffffffull;
    destination[41]  = (source[26] >> 6) & 0x1ffffffffffull;
    destination[42]  = (source[26] << 35) & 0x1ffffffffffull;
    destination[42] |= (source[27] >> 29) & 0x1ffffffffffull;
    destination[43]  = (source[27] << 12) & 0x1ffffffffffull;
    destination[43] |= (source[28] >> 52) & 0x1ffffffffffull;
    destination[44]  = (source[28] >> 11) & 0x1ffffffffffull;
    destination[45]  = (source[28] << 30) & 0x1ffffffffffull;
    destination[45] |= (source[29] >> 34) & 0x1ffffffffffull;
    destination[46]  = (source[29] << 7) & 0x1ffffffffffull;
    destination[46] |= (source[30] >> 57) & 0x1ffffffffffull;
    destination[47]  = (source[30] >> 16) & 0x1ffffffffffull;
    destination[48]  = (source[30] << 25) & 0x1ffffffffffull;
    destination[48] |= (source[31] >> 39) & 0x1ffffffffffull;
    destination[49]  = (source[31] << 2) & 0x1ffffffffffull;
    destination[49] |= (source[32] >> 62) & 0x1ffffffffffull;
    destination[50]  = (source[32] >> 21) & 0x1ffffffffffull;
    destination[51]  = (source[32] << 20) & 0x1ffffffffffull;
    destination[51] |= (source[33] >> 44) & 0x1ffffffffffull;
    destination[52]  = (source[33] >> 3) & 0x1ffffffffffull;
    destination[53]  = (source[33] << 38) & 0x1ffffffffffull;
    destination[53] |= (source[34] >> 26) & 0x1ffffffffffull;
    destination[54]  = (source[34] << 15) & 0x1ffffffffffull;
    destination[54] |= (source[35] >> 49) & 0x1ffffffffffull;
    destination[55]  = (source[35] >> 8) & 0x1ffffffffffull;
    destination[56]  = (source[35] << 33) & 0x1ffffffffffull;
    destination[56] |= (source[36] >> 31) & 0x1ffffffffffull;
    destination[57]  = (source[36] << 10) & 0x1ffffffffffull;
    destination[57] |= (source[37] >> 54) & 0x1ffffffffffull;
    destination[58]  = (source[37] >> 13) & 0x1ffffffffffull;
    destination[59]  = (source[37] << 28) & 0x1ffffffffffull;
    destination[59] |= (source[38] >> 36) & 0x1ffffffffffull;
    destination[60]  = (source[38] << 5) & 0x1ffffffffffull;
    destination[60] |= (source[39] >> 59) & 0x1ffffffffffull;
    destination[61]  = (source[39] >> 18) & 0x1ffffffffffull;
    destination[62]  = (source[39] << 23) & 0x1ffffffffffull;
    destination[62] |= (source[40] >> 41) & 0x1ffffffffffull;
    destination[63]  = (source[40] >> 0) & 0x1ffffffffffull;
  }
};
template <typename Tp>
struct __struct_bitpack_impl<Tp,8,42>
{
  static const size_t unit_size = 64;
  static const size_t bits_total = 2688;
  static const size_t loop_total = 64;
  static const size_t bit_size = 42;
  static const Tp     mask = 0x3ffffffffffull;
  static inline
  void pack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] & 0x3ffffffffffull) << 22;
    destination[0] |= (source[1] & 0x3ffffffffffull) >> 20;
    destination[1]  = (source[1] & 0x3ffffffffffull) << 44;
    destination[1] |= (source[2] & 0x3ffffffffffull) << 2;
    destination[1] |= (source[3] & 0x3ffffffffffull) >> 40;
    destination[2]  = (source[3] & 0x3ffffffffffull) << 24;
    destination[2] |= (source[4] & 0x3ffffffffffull) >> 18;
    destination[3]  = (source[4] & 0x3ffffffffffull) << 46;
    destination[3] |= (source[5] & 0x3ffffffffffull) << 4;
    destination[3] |= (source[6] & 0x3ffffffffffull) >> 38;
    destination[4]  = (source[6] & 0x3ffffffffffull) << 26;
    destination[4] |= (source[7] & 0x3ffffffffffull) >> 16;
    destination[5]  = (source[7] & 0x3ffffffffffull) << 48;
    destination[5] |= (source[8] & 0x3ffffffffffull) << 6;
    destination[5] |= (source[9] & 0x3ffffffffffull) >> 36;
    destination[6]  = (source[9] & 0x3ffffffffffull) << 28;
    destination[6] |= (source[10] & 0x3ffffffffffull) >> 14;
    destination[7]  = (source[10] & 0x3ffffffffffull) << 50;
    destination[7] |= (source[11] & 0x3ffffffffffull) << 8;
    destination[7] |= (source[12] & 0x3ffffffffffull) >> 34;
    destination[8]  = (source[12] & 0x3ffffffffffull) << 30;
    destination[8] |= (source[13] & 0x3ffffffffffull) >> 12;
    destination[9]  = (source[13] & 0x3ffffffffffull) << 52;
    destination[9] |= (source[14] & 0x3ffffffffffull) << 10;
    destination[9] |= (source[15] & 0x3ffffffffffull) >> 32;
    destination[10]  = (source[15] & 0x3ffffffffffull) << 32;
    destination[10] |= (source[16] & 0x3ffffffffffull) >> 10;
    destination[11]  = (source[16] & 0x3ffffffffffull) << 54;
    destination[11] |= (source[17] & 0x3ffffffffffull) << 12;
    destination[11] |= (source[18] & 0x3ffffffffffull) >> 30;
    destination[12]  = (source[18] & 0x3ffffffffffull) << 34;
    destination[12] |= (source[19] & 0x3ffffffffffull) >> 8;
    destination[13]  = (source[19] & 0x3ffffffffffull) << 56;
    destination[13] |= (source[20] & 0x3ffffffffffull) << 14;
    destination[13] |= (source[21] & 0x3ffffffffffull) >> 28;
    destination[14]  = (source[21] & 0x3ffffffffffull) << 36;
    destination[14] |= (source[22] & 0x3ffffffffffull) >> 6;
    destination[15]  = (source[22] & 0x3ffffffffffull) << 58;
    destination[15] |= (source[23] & 0x3ffffffffffull) << 16;
    destination[15] |= (source[24] & 0x3ffffffffffull) >> 26;
    destination[16]  = (source[24] & 0x3ffffffffffull) << 38;
    destination[16] |= (source[25] & 0x3ffffffffffull) >> 4;
    destination[17]  = (source[25] & 0x3ffffffffffull) << 60;
    destination[17] |= (source[26] & 0x3ffffffffffull) << 18;
    destination[17] |= (source[27] & 0x3ffffffffffull) >> 24;
    destination[18]  = (source[27] & 0x3ffffffffffull) << 40;
    destination[18] |= (source[28] & 0x3ffffffffffull) >> 2;
    destination[19]  = (source[28] & 0x3ffffffffffull) << 62;
    destination[19] |= (source[29] & 0x3ffffffffffull) << 20;
    destination[19] |= (source[30] & 0x3ffffffffffull) >> 22;
    destination[20]  = (source[30] & 0x3ffffffffffull) << 42;
    destination[20] |= (source[31] & 0x3ffffffffffull) << 0;
    destination[21]  = (source[32] & 0x3ffffffffffull) << 22;
    destination[21] |= (source[33] & 0x3ffffffffffull) >> 20;
    destination[22]  = (source[33] & 0x3ffffffffffull) << 44;
    destination[22] |= (source[34] & 0x3ffffffffffull) << 2;
    destination[22] |= (source[35] & 0x3ffffffffffull) >> 40;
    destination[23]  = (source[35] & 0x3ffffffffffull) << 24;
    destination[23] |= (source[36] & 0x3ffffffffffull) >> 18;
    destination[24]  = (source[36] & 0x3ffffffffffull) << 46;
    destination[24] |= (source[37] & 0x3ffffffffffull) << 4;
    destination[24] |= (source[38] & 0x3ffffffffffull) >> 38;
    destination[25]  = (source[38] & 0x3ffffffffffull) << 26;
    destination[25] |= (source[39] & 0x3ffffffffffull) >> 16;
    destination[26]  = (source[39] & 0x3ffffffffffull) << 48;
    destination[26] |= (source[40] & 0x3ffffffffffull) << 6;
    destination[26] |= (source[41] & 0x3ffffffffffull) >> 36;
    destination[27]  = (source[41] & 0x3ffffffffffull) << 28;
    destination[27] |= (source[42] & 0x3ffffffffffull) >> 14;
    destination[28]  = (source[42] & 0x3ffffffffffull) << 50;
    destination[28] |= (source[43] & 0x3ffffffffffull) << 8;
    destination[28] |= (source[44] & 0x3ffffffffffull) >> 34;
    destination[29]  = (source[44] & 0x3ffffffffffull) << 30;
    destination[29] |= (source[45] & 0x3ffffffffffull) >> 12;
    destination[30]  = (source[45] & 0x3ffffffffffull) << 52;
    destination[30] |= (source[46] & 0x3ffffffffffull) << 10;
    destination[30] |= (source[47] & 0x3ffffffffffull) >> 32;
    destination[31]  = (source[47] & 0x3ffffffffffull) << 32;
    destination[31] |= (source[48] & 0x3ffffffffffull) >> 10;
    destination[32]  = (source[48] & 0x3ffffffffffull) << 54;
    destination[32] |= (source[49] & 0x3ffffffffffull) << 12;
    destination[32] |= (source[50] & 0x3ffffffffffull) >> 30;
    destination[33]  = (source[50] & 0x3ffffffffffull) << 34;
    destination[33] |= (source[51] & 0x3ffffffffffull) >> 8;
    destination[34]  = (source[51] & 0x3ffffffffffull) << 56;
    destination[34] |= (source[52] & 0x3ffffffffffull) << 14;
    destination[34] |= (source[53] & 0x3ffffffffffull) >> 28;
    destination[35]  = (source[53] & 0x3ffffffffffull) << 36;
    destination[35] |= (source[54] & 0x3ffffffffffull) >> 6;
    destination[36]  = (source[54] & 0x3ffffffffffull) << 58;
    destination[36] |= (source[55] & 0x3ffffffffffull) << 16;
    destination[36] |= (source[56] & 0x3ffffffffffull) >> 26;
    destination[37]  = (source[56] & 0x3ffffffffffull) << 38;
    destination[37] |= (source[57] & 0x3ffffffffffull) >> 4;
    destination[38]  = (source[57] & 0x3ffffffffffull) << 60;
    destination[38] |= (source[58] & 0x3ffffffffffull) << 18;
    destination[38] |= (source[59] & 0x3ffffffffffull) >> 24;
    destination[39]  = (source[59] & 0x3ffffffffffull) << 40;
    destination[39] |= (source[60] & 0x3ffffffffffull) >> 2;
    destination[40]  = (source[60] & 0x3ffffffffffull) << 62;
    destination[40] |= (source[61] & 0x3ffffffffffull) << 20;
    destination[40] |= (source[62] & 0x3ffffffffffull) >> 22;
    destination[41]  = (source[62] & 0x3ffffffffffull) << 42;
    destination[41] |= (source[63] & 0x3ffffffffffull) << 0;
  }
  static inline
  void unpack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] >> 22) & 0x3ffffffffffull;
    destination[1]  = (source[0] << 20) & 0x3ffffffffffull;
    destination[1] |= (source[1] >> 44) & 0x3ffffffffffull;
    destination[2]  = (source[1] >> 2) & 0x3ffffffffffull;
    destination[3]  = (source[1] << 40) & 0x3ffffffffffull;
    destination[3] |= (source[2] >> 24) & 0x3ffffffffffull;
    destination[4]  = (source[2] << 18) & 0x3ffffffffffull;
    destination[4] |= (source[3] >> 46) & 0x3ffffffffffull;
    destination[5]  = (source[3] >> 4) & 0x3ffffffffffull;
    destination[6]  = (source[3] << 38) & 0x3ffffffffffull;
    destination[6] |= (source[4] >> 26) & 0x3ffffffffffull;
    destination[7]  = (source[4] << 16) & 0x3ffffffffffull;
    destination[7] |= (source[5] >> 48) & 0x3ffffffffffull;
    destination[8]  = (source[5] >> 6) & 0x3ffffffffffull;
    destination[9]  = (source[5] << 36) & 0x3ffffffffffull;
    destination[9] |= (source[6] >> 28) & 0x3ffffffffffull;
    destination[10]  = (source[6] << 14) & 0x3ffffffffffull;
    destination[10] |= (source[7] >> 50) & 0x3ffffffffffull;
    destination[11]  = (source[7] >> 8) & 0x3ffffffffffull;
    destination[12]  = (source[7] << 34) & 0x3ffffffffffull;
    destination[12] |= (source[8] >> 30) & 0x3ffffffffffull;
    destination[13]  = (source[8] << 12) & 0x3ffffffffffull;
    destination[13] |= (source[9] >> 52) & 0x3ffffffffffull;
    destination[14]  = (source[9] >> 10) & 0x3ffffffffffull;
    destination[15]  = (source[9] << 32) & 0x3ffffffffffull;
    destination[15] |= (source[10] >> 32) & 0x3ffffffffffull;
    destination[16]  = (source[10] << 10) & 0x3ffffffffffull;
    destination[16] |= (source[11] >> 54) & 0x3ffffffffffull;
    destination[17]  = (source[11] >> 12) & 0x3ffffffffffull;
    destination[18]  = (source[11] << 30) & 0x3ffffffffffull;
    destination[18] |= (source[12] >> 34) & 0x3ffffffffffull;
    destination[19]  = (source[12] << 8) & 0x3ffffffffffull;
    destination[19] |= (source[13] >> 56) & 0x3ffffffffffull;
    destination[20]  = (source[13] >> 14) & 0x3ffffffffffull;
    destination[21]  = (source[13] << 28) & 0x3ffffffffffull;
    destination[21] |= (source[14] >> 36) & 0x3ffffffffffull;
    destination[22]  = (source[14] << 6) & 0x3ffffffffffull;
    destination[22] |= (source[15] >> 58) & 0x3ffffffffffull;
    destination[23]  = (source[15] >> 16) & 0x3ffffffffffull;
    destination[24]  = (source[15] << 26) & 0x3ffffffffffull;
    destination[24] |= (source[16] >> 38) & 0x3ffffffffffull;
    destination[25]  = (source[16] << 4) & 0x3ffffffffffull;
    destination[25] |= (source[17] >> 60) & 0x3ffffffffffull;
    destination[26]  = (source[17] >> 18) & 0x3ffffffffffull;
    destination[27]  = (source[17] << 24) & 0x3ffffffffffull;
    destination[27] |= (source[18] >> 40) & 0x3ffffffffffull;
    destination[28]  = (source[18] << 2) & 0x3ffffffffffull;
    destination[28] |= (source[19] >> 62) & 0x3ffffffffffull;
    destination[29]  = (source[19] >> 20) & 0x3ffffffffffull;
    destination[30]  = (source[19] << 22) & 0x3ffffffffffull;
    destination[30] |= (source[20] >> 42) & 0x3ffffffffffull;
    destination[31]  = (source[20] >> 0) & 0x3ffffffffffull;
    destination[32]  = (source[21] >> 22) & 0x3ffffffffffull;
    destination[33]  = (source[21] << 20) & 0x3ffffffffffull;
    destination[33] |= (source[22] >> 44) & 0x3ffffffffffull;
    destination[34]  = (source[22] >> 2) & 0x3ffffffffffull;
    destination[35]  = (source[22] << 40) & 0x3ffffffffffull;
    destination[35] |= (source[23] >> 24) & 0x3ffffffffffull;
    destination[36]  = (source[23] << 18) & 0x3ffffffffffull;
    destination[36] |= (source[24] >> 46) & 0x3ffffffffffull;
    destination[37]  = (source[24] >> 4) & 0x3ffffffffffull;
    destination[38]  = (source[24] << 38) & 0x3ffffffffffull;
    destination[38] |= (source[25] >> 26) & 0x3ffffffffffull;
    destination[39]  = (source[25] << 16) & 0x3ffffffffffull;
    destination[39] |= (source[26] >> 48) & 0x3ffffffffffull;
    destination[40]  = (source[26] >> 6) & 0x3ffffffffffull;
    destination[41]  = (source[26] << 36) & 0x3ffffffffffull;
    destination[41] |= (source[27] >> 28) & 0x3ffffffffffull;
    destination[42]  = (source[27] << 14) & 0x3ffffffffffull;
    destination[42] |= (source[28] >> 50) & 0x3ffffffffffull;
    destination[43]  = (source[28] >> 8) & 0x3ffffffffffull;
    destination[44]  = (source[28] << 34) & 0x3ffffffffffull;
    destination[44] |= (source[29] >> 30) & 0x3ffffffffffull;
    destination[45]  = (source[29] << 12) & 0x3ffffffffffull;
    destination[45] |= (source[30] >> 52) & 0x3ffffffffffull;
    destination[46]  = (source[30] >> 10) & 0x3ffffffffffull;
    destination[47]  = (source[30] << 32) & 0x3ffffffffffull;
    destination[47] |= (source[31] >> 32) & 0x3ffffffffffull;
    destination[48]  = (source[31] << 10) & 0x3ffffffffffull;
    destination[48] |= (source[32] >> 54) & 0x3ffffffffffull;
    destination[49]  = (source[32] >> 12) & 0x3ffffffffffull;
    destination[50]  = (source[32] << 30) & 0x3ffffffffffull;
    destination[50] |= (source[33] >> 34) & 0x3ffffffffffull;
    destination[51]  = (source[33] << 8) & 0x3ffffffffffull;
    destination[51] |= (source[34] >> 56) & 0x3ffffffffffull;
    destination[52]  = (source[34] >> 14) & 0x3ffffffffffull;
    destination[53]  = (source[34] << 28) & 0x3ffffffffffull;
    destination[53] |= (source[35] >> 36) & 0x3ffffffffffull;
    destination[54]  = (source[35] << 6) & 0x3ffffffffffull;
    destination[54] |= (source[36] >> 58) & 0x3ffffffffffull;
    destination[55]  = (source[36] >> 16) & 0x3ffffffffffull;
    destination[56]  = (source[36] << 26) & 0x3ffffffffffull;
    destination[56] |= (source[37] >> 38) & 0x3ffffffffffull;
    destination[57]  = (source[37] << 4) & 0x3ffffffffffull;
    destination[57] |= (source[38] >> 60) & 0x3ffffffffffull;
    destination[58]  = (source[38] >> 18) & 0x3ffffffffffull;
    destination[59]  = (source[38] << 24) & 0x3ffffffffffull;
    destination[59] |= (source[39] >> 40) & 0x3ffffffffffull;
    destination[60]  = (source[39] << 2) & 0x3ffffffffffull;
    destination[60] |= (source[40] >> 62) & 0x3ffffffffffull;
    destination[61]  = (source[40] >> 20) & 0x3ffffffffffull;
    destination[62]  = (source[40] << 22) & 0x3ffffffffffull;
    destination[62] |= (source[41] >> 42) & 0x3ffffffffffull;
    destination[63]  = (source[41] >> 0) & 0x3ffffffffffull;
  }
};
template <typename Tp>
struct __struct_bitpack_impl<Tp,8,43>
{
  static const size_t unit_size = 64;
  static const size_t bits_total = 2752;
  static const size_t loop_total = 64;
  static const size_t bit_size = 43;
  static const Tp     mask = 0x7ffffffffffull;
  static inline
  void pack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] & 0x7ffffffffffull) << 21;
    destination[0] |= (source[1] & 0x7ffffffffffull) >> 22;
    destination[1]  = (source[1] & 0x7ffffffffffull) << 42;
    destination[1] |= (source[2] & 0x7ffffffffffull) >> 1;
    destination[2]  = (source[2] & 0x7ffffffffffull) << 63;
    destination[2] |= (source[3] & 0x7ffffffffffull) << 20;
    destination[2] |= (source[4] & 0x7ffffffffffull) >> 23;
    destination[3]  = (source[4] & 0x7ffffffffffull) << 41;
    destination[3] |= (source[5] & 0x7ffffffffffull) >> 2;
    destination[4]  = (source[5] & 0x7ffffffffffull) << 62;
    destination[4] |= (source[6] & 0x7ffffffffffull) << 19;
    destination[4] |= (source[7] & 0x7ffffffffffull) >> 24;
    destination[5]  = (source[7] & 0x7ffffffffffull) << 40;
    destination[5] |= (source[8] & 0x7ffffffffffull) >> 3;
    destination[6]  = (source[8] & 0x7ffffffffffull) << 61;
    destination[6] |= (source[9] & 0x7ffffffffffull) << 18;
    destination[6] |= (source[10] & 0x7ffffffffffull) >> 25;
    destination[7]  = (source[10] & 0x7ffffffffffull) << 39;
    destination[7] |= (source[11] & 0x7ffffffffffull) >> 4;
    destination[8]  = (source[11] & 0x7ffffffffffull) << 60;
    destination[8] |= (source[12] & 0x7ffffffffffull) << 17;
    destination[8] |= (source[13] & 0x7ffffffffffull) >> 26;
    destination[9]  = (source[13] & 0x7ffffffffffull) << 38;
    destination[9] |= (source[14] & 0x7ffffffffffull) >> 5;
    destination[10]  = (source[14] & 0x7ffffffffffull) << 59;
    destination[10] |= (source[15] & 0x7ffffffffffull) << 16;
    destination[10] |= (source[16] & 0x7ffffffffffull) >> 27;
    destination[11]  = (source[16] & 0x7ffffffffffull) << 37;
    destination[11] |= (source[17] & 0x7ffffffffffull) >> 6;
    destination[12]  = (source[17] & 0x7ffffffffffull) << 58;
    destination[12] |= (source[18] & 0x7ffffffffffull) << 15;
    destination[12] |= (source[19] & 0x7ffffffffffull) >> 28;
    destination[13]  = (source[19] & 0x7ffffffffffull) << 36;
    destination[13] |= (source[20] & 0x7ffffffffffull) >> 7;
    destination[14]  = (source[20] & 0x7ffffffffffull) << 57;
    destination[14] |= (source[21] & 0x7ffffffffffull) << 14;
    destination[14] |= (source[22] & 0x7ffffffffffull) >> 29;
    destination[15]  = (source[22] & 0x7ffffffffffull) << 35;
    destination[15] |= (source[23] & 0x7ffffffffffull) >> 8;
    destination[16]  = (source[23] & 0x7ffffffffffull) << 56;
    destination[16] |= (source[24] & 0x7ffffffffffull) << 13;
    destination[16] |= (source[25] & 0x7ffffffffffull) >> 30;
    destination[17]  = (source[25] & 0x7ffffffffffull) << 34;
    destination[17] |= (source[26] & 0x7ffffffffffull) >> 9;
    destination[18]  = (source[26] & 0x7ffffffffffull) << 55;
    destination[18] |= (source[27] & 0x7ffffffffffull) << 12;
    destination[18] |= (source[28] & 0x7ffffffffffull) >> 31;
    destination[19]  = (source[28] & 0x7ffffffffffull) << 33;
    destination[19] |= (source[29] & 0x7ffffffffffull) >> 10;
    destination[20]  = (source[29] & 0x7ffffffffffull) << 54;
    destination[20] |= (source[30] & 0x7ffffffffffull) << 11;
    destination[20] |= (source[31] & 0x7ffffffffffull) >> 32;
    destination[21]  = (source[31] & 0x7ffffffffffull) << 32;
    destination[21] |= (source[32] & 0x7ffffffffffull) >> 11;
    destination[22]  = (source[32] & 0x7ffffffffffull) << 53;
    destination[22] |= (source[33] & 0x7ffffffffffull) << 10;
    destination[22] |= (source[34] & 0x7ffffffffffull) >> 33;
    destination[23]  = (source[34] & 0x7ffffffffffull) << 31;
    destination[23] |= (source[35] & 0x7ffffffffffull) >> 12;
    destination[24]  = (source[35] & 0x7ffffffffffull) << 52;
    destination[24] |= (source[36] & 0x7ffffffffffull) << 9;
    destination[24] |= (source[37] & 0x7ffffffffffull) >> 34;
    destination[25]  = (source[37] & 0x7ffffffffffull) << 30;
    destination[25] |= (source[38] & 0x7ffffffffffull) >> 13;
    destination[26]  = (source[38] & 0x7ffffffffffull) << 51;
    destination[26] |= (source[39] & 0x7ffffffffffull) << 8;
    destination[26] |= (source[40] & 0x7ffffffffffull) >> 35;
    destination[27]  = (source[40] & 0x7ffffffffffull) << 29;
    destination[27] |= (source[41] & 0x7ffffffffffull) >> 14;
    destination[28]  = (source[41] & 0x7ffffffffffull) << 50;
    destination[28] |= (source[42] & 0x7ffffffffffull) << 7;
    destination[28] |= (source[43] & 0x7ffffffffffull) >> 36;
    destination[29]  = (source[43] & 0x7ffffffffffull) << 28;
    destination[29] |= (source[44] & 0x7ffffffffffull) >> 15;
    destination[30]  = (source[44] & 0x7ffffffffffull) << 49;
    destination[30] |= (source[45] & 0x7ffffffffffull) << 6;
    destination[30] |= (source[46] & 0x7ffffffffffull) >> 37;
    destination[31]  = (source[46] & 0x7ffffffffffull) << 27;
    destination[31] |= (source[47] & 0x7ffffffffffull) >> 16;
    destination[32]  = (source[47] & 0x7ffffffffffull) << 48;
    destination[32] |= (source[48] & 0x7ffffffffffull) << 5;
    destination[32] |= (source[49] & 0x7ffffffffffull) >> 38;
    destination[33]  = (source[49] & 0x7ffffffffffull) << 26;
    destination[33] |= (source[50] & 0x7ffffffffffull) >> 17;
    destination[34]  = (source[50] & 0x7ffffffffffull) << 47;
    destination[34] |= (source[51] & 0x7ffffffffffull) << 4;
    destination[34] |= (source[52] & 0x7ffffffffffull) >> 39;
    destination[35]  = (source[52] & 0x7ffffffffffull) << 25;
    destination[35] |= (source[53] & 0x7ffffffffffull) >> 18;
    destination[36]  = (source[53] & 0x7ffffffffffull) << 46;
    destination[36] |= (source[54] & 0x7ffffffffffull) << 3;
    destination[36] |= (source[55] & 0x7ffffffffffull) >> 40;
    destination[37]  = (source[55] & 0x7ffffffffffull) << 24;
    destination[37] |= (source[56] & 0x7ffffffffffull) >> 19;
    destination[38]  = (source[56] & 0x7ffffffffffull) << 45;
    destination[38] |= (source[57] & 0x7ffffffffffull) << 2;
    destination[38] |= (source[58] & 0x7ffffffffffull) >> 41;
    destination[39]  = (source[58] & 0x7ffffffffffull) << 23;
    destination[39] |= (source[59] & 0x7ffffffffffull) >> 20;
    destination[40]  = (source[59] & 0x7ffffffffffull) << 44;
    destination[40] |= (source[60] & 0x7ffffffffffull) << 1;
    destination[40] |= (source[61] & 0x7ffffffffffull) >> 42;
    destination[41]  = (source[61] & 0x7ffffffffffull) << 22;
    destination[41] |= (source[62] & 0x7ffffffffffull) >> 21;
    destination[42]  = (source[62] & 0x7ffffffffffull) << 43;
    destination[42] |= (source[63] & 0x7ffffffffffull) << 0;
  }
  static inline
  void unpack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] >> 21) & 0x7ffffffffffull;
    destination[1]  = (source[0] << 22) & 0x7ffffffffffull;
    destination[1] |= (source[1] >> 42) & 0x7ffffffffffull;
    destination[2]  = (source[1] << 1) & 0x7ffffffffffull;
    destination[2] |= (source[2] >> 63) & 0x7ffffffffffull;
    destination[3]  = (source[2] >> 20) & 0x7ffffffffffull;
    destination[4]  = (source[2] << 23) & 0x7ffffffffffull;
    destination[4] |= (source[3] >> 41) & 0x7ffffffffffull;
    destination[5]  = (source[3] << 2) & 0x7ffffffffffull;
    destination[5] |= (source[4] >> 62) & 0x7ffffffffffull;
    destination[6]  = (source[4] >> 19) & 0x7ffffffffffull;
    destination[7]  = (source[4] << 24) & 0x7ffffffffffull;
    destination[7] |= (source[5] >> 40) & 0x7ffffffffffull;
    destination[8]  = (source[5] << 3) & 0x7ffffffffffull;
    destination[8] |= (source[6] >> 61) & 0x7ffffffffffull;
    destination[9]  = (source[6] >> 18) & 0x7ffffffffffull;
    destination[10]  = (source[6] << 25) & 0x7ffffffffffull;
    destination[10] |= (source[7] >> 39) & 0x7ffffffffffull;
    destination[11]  = (source[7] << 4) & 0x7ffffffffffull;
    destination[11] |= (source[8] >> 60) & 0x7ffffffffffull;
    destination[12]  = (source[8] >> 17) & 0x7ffffffffffull;
    destination[13]  = (source[8] << 26) & 0x7ffffffffffull;
    destination[13] |= (source[9] >> 38) & 0x7ffffffffffull;
    destination[14]  = (source[9] << 5) & 0x7ffffffffffull;
    destination[14] |= (source[10] >> 59) & 0x7ffffffffffull;
    destination[15]  = (source[10] >> 16) & 0x7ffffffffffull;
    destination[16]  = (source[10] << 27) & 0x7ffffffffffull;
    destination[16] |= (source[11] >> 37) & 0x7ffffffffffull;
    destination[17]  = (source[11] << 6) & 0x7ffffffffffull;
    destination[17] |= (source[12] >> 58) & 0x7ffffffffffull;
    destination[18]  = (source[12] >> 15) & 0x7ffffffffffull;
    destination[19]  = (source[12] << 28) & 0x7ffffffffffull;
    destination[19] |= (source[13] >> 36) & 0x7ffffffffffull;
    destination[20]  = (source[13] << 7) & 0x7ffffffffffull;
    destination[20] |= (source[14] >> 57) & 0x7ffffffffffull;
    destination[21]  = (source[14] >> 14) & 0x7ffffffffffull;
    destination[22]  = (source[14] << 29) & 0x7ffffffffffull;
    destination[22] |= (source[15] >> 35) & 0x7ffffffffffull;
    destination[23]  = (source[15] << 8) & 0x7ffffffffffull;
    destination[23] |= (source[16] >> 56) & 0x7ffffffffffull;
    destination[24]  = (source[16] >> 13) & 0x7ffffffffffull;
    destination[25]  = (source[16] << 30) & 0x7ffffffffffull;
    destination[25] |= (source[17] >> 34) & 0x7ffffffffffull;
    destination[26]  = (source[17] << 9) & 0x7ffffffffffull;
    destination[26] |= (source[18] >> 55) & 0x7ffffffffffull;
    destination[27]  = (source[18] >> 12) & 0x7ffffffffffull;
    destination[28]  = (source[18] << 31) & 0x7ffffffffffull;
    destination[28] |= (source[19] >> 33) & 0x7ffffffffffull;
    destination[29]  = (source[19] << 10) & 0x7ffffffffffull;
    destination[29] |= (source[20] >> 54) & 0x7ffffffffffull;
    destination[30]  = (source[20] >> 11) & 0x7ffffffffffull;
    destination[31]  = (source[20] << 32) & 0x7ffffffffffull;
    destination[31] |= (source[21] >> 32) & 0x7ffffffffffull;
    destination[32]  = (source[21] << 11) & 0x7ffffffffffull;
    destination[32] |= (source[22] >> 53) & 0x7ffffffffffull;
    destination[33]  = (source[22] >> 10) & 0x7ffffffffffull;
    destination[34]  = (source[22] << 33) & 0x7ffffffffffull;
    destination[34] |= (source[23] >> 31) & 0x7ffffffffffull;
    destination[35]  = (source[23] << 12) & 0x7ffffffffffull;
    destination[35] |= (source[24] >> 52) & 0x7ffffffffffull;
    destination[36]  = (source[24] >> 9) & 0x7ffffffffffull;
    destination[37]  = (source[24] << 34) & 0x7ffffffffffull;
    destination[37] |= (source[25] >> 30) & 0x7ffffffffffull;
    destination[38]  = (source[25] << 13) & 0x7ffffffffffull;
    destination[38] |= (source[26] >> 51) & 0x7ffffffffffull;
    destination[39]  = (source[26] >> 8) & 0x7ffffffffffull;
    destination[40]  = (source[26] << 35) & 0x7ffffffffffull;
    destination[40] |= (source[27] >> 29) & 0x7ffffffffffull;
    destination[41]  = (source[27] << 14) & 0x7ffffffffffull;
    destination[41] |= (source[28] >> 50) & 0x7ffffffffffull;
    destination[42]  = (source[28] >> 7) & 0x7ffffffffffull;
    destination[43]  = (source[28] << 36) & 0x7ffffffffffull;
    destination[43] |= (source[29] >> 28) & 0x7ffffffffffull;
    destination[44]  = (source[29] << 15) & 0x7ffffffffffull;
    destination[44] |= (source[30] >> 49) & 0x7ffffffffffull;
    destination[45]  = (source[30] >> 6) & 0x7ffffffffffull;
    destination[46]  = (source[30] << 37) & 0x7ffffffffffull;
    destination[46] |= (source[31] >> 27) & 0x7ffffffffffull;
    destination[47]  = (source[31] << 16) & 0x7ffffffffffull;
    destination[47] |= (source[32] >> 48) & 0x7ffffffffffull;
    destination[48]  = (source[32] >> 5) & 0x7ffffffffffull;
    destination[49]  = (source[32] << 38) & 0x7ffffffffffull;
    destination[49] |= (source[33] >> 26) & 0x7ffffffffffull;
    destination[50]  = (source[33] << 17) & 0x7ffffffffffull;
    destination[50] |= (source[34] >> 47) & 0x7ffffffffffull;
    destination[51]  = (source[34] >> 4) & 0x7ffffffffffull;
    destination[52]  = (source[34] << 39) & 0x7ffffffffffull;
    destination[52] |= (source[35] >> 25) & 0x7ffffffffffull;
    destination[53]  = (source[35] << 18) & 0x7ffffffffffull;
    destination[53] |= (source[36] >> 46) & 0x7ffffffffffull;
    destination[54]  = (source[36] >> 3) & 0x7ffffffffffull;
    destination[55]  = (source[36] << 40) & 0x7ffffffffffull;
    destination[55] |= (source[37] >> 24) & 0x7ffffffffffull;
    destination[56]  = (source[37] << 19) & 0x7ffffffffffull;
    destination[56] |= (source[38] >> 45) & 0x7ffffffffffull;
    destination[57]  = (source[38] >> 2) & 0x7ffffffffffull;
    destination[58]  = (source[38] << 41) & 0x7ffffffffffull;
    destination[58] |= (source[39] >> 23) & 0x7ffffffffffull;
    destination[59]  = (source[39] << 20) & 0x7ffffffffffull;
    destination[59] |= (source[40] >> 44) & 0x7ffffffffffull;
    destination[60]  = (source[40] >> 1) & 0x7ffffffffffull;
    destination[61]  = (source[40] << 42) & 0x7ffffffffffull;
    destination[61] |= (source[41] >> 22) & 0x7ffffffffffull;
    destination[62]  = (source[41] << 21) & 0x7ffffffffffull;
    destination[62] |= (source[42] >> 43) & 0x7ffffffffffull;
    destination[63]  = (source[42] >> 0) & 0x7ffffffffffull;
  }
};
template <typename Tp>
struct __struct_bitpack_impl<Tp,8,44>
{
  static const size_t unit_size = 64;
  static const size_t bits_total = 2816;
  static const size_t loop_total = 64;
  static const size_t bit_size = 44;
  static const Tp     mask = 0xfffffffffffull;
  static inline
  void pack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] & 0xfffffffffffull) << 20;
    destination[0] |= (source[1] & 0xfffffffffffull) >> 24;
    destination[1]  = (source[1] & 0xfffffffffffull) << 40;
    destination[1] |= (source[2] & 0xfffffffffffull) >> 4;
    destination[2]  = (source[2] & 0xfffffffffffull) << 60;
    destination[2] |= (source[3] & 0xfffffffffffull) << 16;
    destination[2] |= (source[4] & 0xfffffffffffull) >> 28;
    destination[3]  = (source[4] & 0xfffffffffffull) << 36;
    destination[3] |= (source[5] & 0xfffffffffffull) >> 8;
    destination[4]  = (source[5] & 0xfffffffffffull) << 56;
    destination[4] |= (source[6] & 0xfffffffffffull) << 12;
    destination[4] |= (source[7] & 0xfffffffffffull) >> 32;
    destination[5]  = (source[7] & 0xfffffffffffull) << 32;
    destination[5] |= (source[8] & 0xfffffffffffull) >> 12;
    destination[6]  = (source[8] & 0xfffffffffffull) << 52;
    destination[6] |= (source[9] & 0xfffffffffffull) << 8;
    destination[6] |= (source[10] & 0xfffffffffffull) >> 36;
    destination[7]  = (source[10] & 0xfffffffffffull) << 28;
    destination[7] |= (source[11] & 0xfffffffffffull) >> 16;
    destination[8]  = (source[11] & 0xfffffffffffull) << 48;
    destination[8] |= (source[12] & 0xfffffffffffull) << 4;
    destination[8] |= (source[13] & 0xfffffffffffull) >> 40;
    destination[9]  = (source[13] & 0xfffffffffffull) << 24;
    destination[9] |= (source[14] & 0xfffffffffffull) >> 20;
    destination[10]  = (source[14] & 0xfffffffffffull) << 44;
    destination[10] |= (source[15] & 0xfffffffffffull) << 0;
    destination[11]  = (source[16] & 0xfffffffffffull) << 20;
    destination[11] |= (source[17] & 0xfffffffffffull) >> 24;
    destination[12]  = (source[17] & 0xfffffffffffull) << 40;
    destination[12] |= (source[18] & 0xfffffffffffull) >> 4;
    destination[13]  = (source[18] & 0xfffffffffffull) << 60;
    destination[13] |= (source[19] & 0xfffffffffffull) << 16;
    destination[13] |= (source[20] & 0xfffffffffffull) >> 28;
    destination[14]  = (source[20] & 0xfffffffffffull) << 36;
    destination[14] |= (source[21] & 0xfffffffffffull) >> 8;
    destination[15]  = (source[21] & 0xfffffffffffull) << 56;
    destination[15] |= (source[22] & 0xfffffffffffull) << 12;
    destination[15] |= (source[23] & 0xfffffffffffull) >> 32;
    destination[16]  = (source[23] & 0xfffffffffffull) << 32;
    destination[16] |= (source[24] & 0xfffffffffffull) >> 12;
    destination[17]  = (source[24] & 0xfffffffffffull) << 52;
    destination[17] |= (source[25] & 0xfffffffffffull) << 8;
    destination[17] |= (source[26] & 0xfffffffffffull) >> 36;
    destination[18]  = (source[26] & 0xfffffffffffull) << 28;
    destination[18] |= (source[27] & 0xfffffffffffull) >> 16;
    destination[19]  = (source[27] & 0xfffffffffffull) << 48;
    destination[19] |= (source[28] & 0xfffffffffffull) << 4;
    destination[19] |= (source[29] & 0xfffffffffffull) >> 40;
    destination[20]  = (source[29] & 0xfffffffffffull) << 24;
    destination[20] |= (source[30] & 0xfffffffffffull) >> 20;
    destination[21]  = (source[30] & 0xfffffffffffull) << 44;
    destination[21] |= (source[31] & 0xfffffffffffull) << 0;
    destination[22]  = (source[32] & 0xfffffffffffull) << 20;
    destination[22] |= (source[33] & 0xfffffffffffull) >> 24;
    destination[23]  = (source[33] & 0xfffffffffffull) << 40;
    destination[23] |= (source[34] & 0xfffffffffffull) >> 4;
    destination[24]  = (source[34] & 0xfffffffffffull) << 60;
    destination[24] |= (source[35] & 0xfffffffffffull) << 16;
    destination[24] |= (source[36] & 0xfffffffffffull) >> 28;
    destination[25]  = (source[36] & 0xfffffffffffull) << 36;
    destination[25] |= (source[37] & 0xfffffffffffull) >> 8;
    destination[26]  = (source[37] & 0xfffffffffffull) << 56;
    destination[26] |= (source[38] & 0xfffffffffffull) << 12;
    destination[26] |= (source[39] & 0xfffffffffffull) >> 32;
    destination[27]  = (source[39] & 0xfffffffffffull) << 32;
    destination[27] |= (source[40] & 0xfffffffffffull) >> 12;
    destination[28]  = (source[40] & 0xfffffffffffull) << 52;
    destination[28] |= (source[41] & 0xfffffffffffull) << 8;
    destination[28] |= (source[42] & 0xfffffffffffull) >> 36;
    destination[29]  = (source[42] & 0xfffffffffffull) << 28;
    destination[29] |= (source[43] & 0xfffffffffffull) >> 16;
    destination[30]  = (source[43] & 0xfffffffffffull) << 48;
    destination[30] |= (source[44] & 0xfffffffffffull) << 4;
    destination[30] |= (source[45] & 0xfffffffffffull) >> 40;
    destination[31]  = (source[45] & 0xfffffffffffull) << 24;
    destination[31] |= (source[46] & 0xfffffffffffull) >> 20;
    destination[32]  = (source[46] & 0xfffffffffffull) << 44;
    destination[32] |= (source[47] & 0xfffffffffffull) << 0;
    destination[33]  = (source[48] & 0xfffffffffffull) << 20;
    destination[33] |= (source[49] & 0xfffffffffffull) >> 24;
    destination[34]  = (source[49] & 0xfffffffffffull) << 40;
    destination[34] |= (source[50] & 0xfffffffffffull) >> 4;
    destination[35]  = (source[50] & 0xfffffffffffull) << 60;
    destination[35] |= (source[51] & 0xfffffffffffull) << 16;
    destination[35] |= (source[52] & 0xfffffffffffull) >> 28;
    destination[36]  = (source[52] & 0xfffffffffffull) << 36;
    destination[36] |= (source[53] & 0xfffffffffffull) >> 8;
    destination[37]  = (source[53] & 0xfffffffffffull) << 56;
    destination[37] |= (source[54] & 0xfffffffffffull) << 12;
    destination[37] |= (source[55] & 0xfffffffffffull) >> 32;
    destination[38]  = (source[55] & 0xfffffffffffull) << 32;
    destination[38] |= (source[56] & 0xfffffffffffull) >> 12;
    destination[39]  = (source[56] & 0xfffffffffffull) << 52;
    destination[39] |= (source[57] & 0xfffffffffffull) << 8;
    destination[39] |= (source[58] & 0xfffffffffffull) >> 36;
    destination[40]  = (source[58] & 0xfffffffffffull) << 28;
    destination[40] |= (source[59] & 0xfffffffffffull) >> 16;
    destination[41]  = (source[59] & 0xfffffffffffull) << 48;
    destination[41] |= (source[60] & 0xfffffffffffull) << 4;
    destination[41] |= (source[61] & 0xfffffffffffull) >> 40;
    destination[42]  = (source[61] & 0xfffffffffffull) << 24;
    destination[42] |= (source[62] & 0xfffffffffffull) >> 20;
    destination[43]  = (source[62] & 0xfffffffffffull) << 44;
    destination[43] |= (source[63] & 0xfffffffffffull) << 0;
  }
  static inline
  void unpack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] >> 20) & 0xfffffffffffull;
    destination[1]  = (source[0] << 24) & 0xfffffffffffull;
    destination[1] |= (source[1] >> 40) & 0xfffffffffffull;
    destination[2]  = (source[1] << 4) & 0xfffffffffffull;
    destination[2] |= (source[2] >> 60) & 0xfffffffffffull;
    destination[3]  = (source[2] >> 16) & 0xfffffffffffull;
    destination[4]  = (source[2] << 28) & 0xfffffffffffull;
    destination[4] |= (source[3] >> 36) & 0xfffffffffffull;
    destination[5]  = (source[3] << 8) & 0xfffffffffffull;
    destination[5] |= (source[4] >> 56) & 0xfffffffffffull;
    destination[6]  = (source[4] >> 12) & 0xfffffffffffull;
    destination[7]  = (source[4] << 32) & 0xfffffffffffull;
    destination[7] |= (source[5] >> 32) & 0xfffffffffffull;
    destination[8]  = (source[5] << 12) & 0xfffffffffffull;
    destination[8] |= (source[6] >> 52) & 0xfffffffffffull;
    destination[9]  = (source[6] >> 8) & 0xfffffffffffull;
    destination[10]  = (source[6] << 36) & 0xfffffffffffull;
    destination[10] |= (source[7] >> 28) & 0xfffffffffffull;
    destination[11]  = (source[7] << 16) & 0xfffffffffffull;
    destination[11] |= (source[8] >> 48) & 0xfffffffffffull;
    destination[12]  = (source[8] >> 4) & 0xfffffffffffull;
    destination[13]  = (source[8] << 40) & 0xfffffffffffull;
    destination[13] |= (source[9] >> 24) & 0xfffffffffffull;
    destination[14]  = (source[9] << 20) & 0xfffffffffffull;
    destination[14] |= (source[10] >> 44) & 0xfffffffffffull;
    destination[15]  = (source[10] >> 0) & 0xfffffffffffull;
    destination[16]  = (source[11] >> 20) & 0xfffffffffffull;
    destination[17]  = (source[11] << 24) & 0xfffffffffffull;
    destination[17] |= (source[12] >> 40) & 0xfffffffffffull;
    destination[18]  = (source[12] << 4) & 0xfffffffffffull;
    destination[18] |= (source[13] >> 60) & 0xfffffffffffull;
    destination[19]  = (source[13] >> 16) & 0xfffffffffffull;
    destination[20]  = (source[13] << 28) & 0xfffffffffffull;
    destination[20] |= (source[14] >> 36) & 0xfffffffffffull;
    destination[21]  = (source[14] << 8) & 0xfffffffffffull;
    destination[21] |= (source[15] >> 56) & 0xfffffffffffull;
    destination[22]  = (source[15] >> 12) & 0xfffffffffffull;
    destination[23]  = (source[15] << 32) & 0xfffffffffffull;
    destination[23] |= (source[16] >> 32) & 0xfffffffffffull;
    destination[24]  = (source[16] << 12) & 0xfffffffffffull;
    destination[24] |= (source[17] >> 52) & 0xfffffffffffull;
    destination[25]  = (source[17] >> 8) & 0xfffffffffffull;
    destination[26]  = (source[17] << 36) & 0xfffffffffffull;
    destination[26] |= (source[18] >> 28) & 0xfffffffffffull;
    destination[27]  = (source[18] << 16) & 0xfffffffffffull;
    destination[27] |= (source[19] >> 48) & 0xfffffffffffull;
    destination[28]  = (source[19] >> 4) & 0xfffffffffffull;
    destination[29]  = (source[19] << 40) & 0xfffffffffffull;
    destination[29] |= (source[20] >> 24) & 0xfffffffffffull;
    destination[30]  = (source[20] << 20) & 0xfffffffffffull;
    destination[30] |= (source[21] >> 44) & 0xfffffffffffull;
    destination[31]  = (source[21] >> 0) & 0xfffffffffffull;
    destination[32]  = (source[22] >> 20) & 0xfffffffffffull;
    destination[33]  = (source[22] << 24) & 0xfffffffffffull;
    destination[33] |= (source[23] >> 40) & 0xfffffffffffull;
    destination[34]  = (source[23] << 4) & 0xfffffffffffull;
    destination[34] |= (source[24] >> 60) & 0xfffffffffffull;
    destination[35]  = (source[24] >> 16) & 0xfffffffffffull;
    destination[36]  = (source[24] << 28) & 0xfffffffffffull;
    destination[36] |= (source[25] >> 36) & 0xfffffffffffull;
    destination[37]  = (source[25] << 8) & 0xfffffffffffull;
    destination[37] |= (source[26] >> 56) & 0xfffffffffffull;
    destination[38]  = (source[26] >> 12) & 0xfffffffffffull;
    destination[39]  = (source[26] << 32) & 0xfffffffffffull;
    destination[39] |= (source[27] >> 32) & 0xfffffffffffull;
    destination[40]  = (source[27] << 12) & 0xfffffffffffull;
    destination[40] |= (source[28] >> 52) & 0xfffffffffffull;
    destination[41]  = (source[28] >> 8) & 0xfffffffffffull;
    destination[42]  = (source[28] << 36) & 0xfffffffffffull;
    destination[42] |= (source[29] >> 28) & 0xfffffffffffull;
    destination[43]  = (source[29] << 16) & 0xfffffffffffull;
    destination[43] |= (source[30] >> 48) & 0xfffffffffffull;
    destination[44]  = (source[30] >> 4) & 0xfffffffffffull;
    destination[45]  = (source[30] << 40) & 0xfffffffffffull;
    destination[45] |= (source[31] >> 24) & 0xfffffffffffull;
    destination[46]  = (source[31] << 20) & 0xfffffffffffull;
    destination[46] |= (source[32] >> 44) & 0xfffffffffffull;
    destination[47]  = (source[32] >> 0) & 0xfffffffffffull;
    destination[48]  = (source[33] >> 20) & 0xfffffffffffull;
    destination[49]  = (source[33] << 24) & 0xfffffffffffull;
    destination[49] |= (source[34] >> 40) & 0xfffffffffffull;
    destination[50]  = (source[34] << 4) & 0xfffffffffffull;
    destination[50] |= (source[35] >> 60) & 0xfffffffffffull;
    destination[51]  = (source[35] >> 16) & 0xfffffffffffull;
    destination[52]  = (source[35] << 28) & 0xfffffffffffull;
    destination[52] |= (source[36] >> 36) & 0xfffffffffffull;
    destination[53]  = (source[36] << 8) & 0xfffffffffffull;
    destination[53] |= (source[37] >> 56) & 0xfffffffffffull;
    destination[54]  = (source[37] >> 12) & 0xfffffffffffull;
    destination[55]  = (source[37] << 32) & 0xfffffffffffull;
    destination[55] |= (source[38] >> 32) & 0xfffffffffffull;
    destination[56]  = (source[38] << 12) & 0xfffffffffffull;
    destination[56] |= (source[39] >> 52) & 0xfffffffffffull;
    destination[57]  = (source[39] >> 8) & 0xfffffffffffull;
    destination[58]  = (source[39] << 36) & 0xfffffffffffull;
    destination[58] |= (source[40] >> 28) & 0xfffffffffffull;
    destination[59]  = (source[40] << 16) & 0xfffffffffffull;
    destination[59] |= (source[41] >> 48) & 0xfffffffffffull;
    destination[60]  = (source[41] >> 4) & 0xfffffffffffull;
    destination[61]  = (source[41] << 40) & 0xfffffffffffull;
    destination[61] |= (source[42] >> 24) & 0xfffffffffffull;
    destination[62]  = (source[42] << 20) & 0xfffffffffffull;
    destination[62] |= (source[43] >> 44) & 0xfffffffffffull;
    destination[63]  = (source[43] >> 0) & 0xfffffffffffull;
  }
};
template <typename Tp>
struct __struct_bitpack_impl<Tp,8,45>
{
  static const size_t unit_size = 64;
  static const size_t bits_total = 2880;
  static const size_t loop_total = 64;
  static const size_t bit_size = 45;
  static const Tp     mask = 0x1fffffffffffull;
  static inline
  void pack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] & 0x1fffffffffffull) << 19;
    destination[0] |= (source[1] & 0x1fffffffffffull) >> 26;
    destination[1]  = (source[1] & 0x1fffffffffffull) << 38;
    destination[1] |= (source[2] & 0x1fffffffffffull) >> 7;
    destination[2]  = (source[2] & 0x1fffffffffffull) << 57;
    destination[2] |= (source[3] & 0x1fffffffffffull) << 12;
    destination[2] |= (source[4] & 0x1fffffffffffull) >> 33;
    destination[3]  = (source[4] & 0x1fffffffffffull) << 31;
    destination[3] |= (source[5] & 0x1fffffffffffull) >> 14;
    destination[4]  = (source[5] & 0x1fffffffffffull) << 50;
    destination[4] |= (source[6] & 0x1fffffffffffull) << 5;
    destination[4] |= (source[7] & 0x1fffffffffffull) >> 40;
    destination[5]  = (source[7] & 0x1fffffffffffull) << 24;
    destination[5] |= (source[8] & 0x1fffffffffffull) >> 21;
    destination[6]  = (source[8] & 0x1fffffffffffull) << 43;
    destination[6] |= (source[9] & 0x1fffffffffffull) >> 2;
    destination[7]  = (source[9] & 0x1fffffffffffull) << 62;
    destination[7] |= (source[10] & 0x1fffffffffffull) << 17;
    destination[7] |= (source[11] & 0x1fffffffffffull) >> 28;
    destination[8]  = (source[11] & 0x1fffffffffffull) << 36;
    destination[8] |= (source[12] & 0x1fffffffffffull) >> 9;
    destination[9]  = (source[12] & 0x1fffffffffffull) << 55;
    destination[9] |= (source[13] & 0x1fffffffffffull) << 10;
    destination[9] |= (source[14] & 0x1fffffffffffull) >> 35;
    destination[10]  = (source[14] & 0x1fffffffffffull) << 29;
    destination[10] |= (source[15] & 0x1fffffffffffull) >> 16;
    destination[11]  = (source[15] & 0x1fffffffffffull) << 48;
    destination[11] |= (source[16] & 0x1fffffffffffull) << 3;
    destination[11] |= (source[17] & 0x1fffffffffffull) >> 42;
    destination[12]  = (source[17] & 0x1fffffffffffull) << 22;
    destination[12] |= (source[18] & 0x1fffffffffffull) >> 23;
    destination[13]  = (source[18] & 0x1fffffffffffull) << 41;
    destination[13] |= (source[19] & 0x1fffffffffffull) >> 4;
    destination[14]  = (source[19] & 0x1fffffffffffull) << 60;
    destination[14] |= (source[20] & 0x1fffffffffffull) << 15;
    destination[14] |= (source[21] & 0x1fffffffffffull) >> 30;
    destination[15]  = (source[21] & 0x1fffffffffffull) << 34;
    destination[15] |= (source[22] & 0x1fffffffffffull) >> 11;
    destination[16]  = (source[22] & 0x1fffffffffffull) << 53;
    destination[16] |= (source[23] & 0x1fffffffffffull) << 8;
    destination[16] |= (source[24] & 0x1fffffffffffull) >> 37;
    destination[17]  = (source[24] & 0x1fffffffffffull) << 27;
    destination[17] |= (source[25] & 0x1fffffffffffull) >> 18;
    destination[18]  = (source[25] & 0x1fffffffffffull) << 46;
    destination[18] |= (source[26] & 0x1fffffffffffull) << 1;
    destination[18] |= (source[27] & 0x1fffffffffffull) >> 44;
    destination[19]  = (source[27] & 0x1fffffffffffull) << 20;
    destination[19] |= (source[28] & 0x1fffffffffffull) >> 25;
    destination[20]  = (source[28] & 0x1fffffffffffull) << 39;
    destination[20] |= (source[29] & 0x1fffffffffffull) >> 6;
    destination[21]  = (source[29] & 0x1fffffffffffull) << 58;
    destination[21] |= (source[30] & 0x1fffffffffffull) << 13;
    destination[21] |= (source[31] & 0x1fffffffffffull) >> 32;
    destination[22]  = (source[31] & 0x1fffffffffffull) << 32;
    destination[22] |= (source[32] & 0x1fffffffffffull) >> 13;
    destination[23]  = (source[32] & 0x1fffffffffffull) << 51;
    destination[23] |= (source[33] & 0x1fffffffffffull) << 6;
    destination[23] |= (source[34] & 0x1fffffffffffull) >> 39;
    destination[24]  = (source[34] & 0x1fffffffffffull) << 25;
    destination[24] |= (source[35] & 0x1fffffffffffull) >> 20;
    destination[25]  = (source[35] & 0x1fffffffffffull) << 44;
    destination[25] |= (source[36] & 0x1fffffffffffull) >> 1;
    destination[26]  = (source[36] & 0x1fffffffffffull) << 63;
    destination[26] |= (source[37] & 0x1fffffffffffull) << 18;
    destination[26] |= (source[38] & 0x1fffffffffffull) >> 27;
    destination[27]  = (source[38] & 0x1fffffffffffull) << 37;
    destination[27] |= (source[39] & 0x1fffffffffffull) >> 8;
    destination[28]  = (source[39] & 0x1fffffffffffull) << 56;
    destination[28] |= (source[40] & 0x1fffffffffffull) << 11;
    destination[28] |= (source[41] & 0x1fffffffffffull) >> 34;
    destination[29]  = (source[41] & 0x1fffffffffffull) << 30;
    destination[29] |= (source[42] & 0x1fffffffffffull) >> 15;
    destination[30]  = (source[42] & 0x1fffffffffffull) << 49;
    destination[30] |= (source[43] & 0x1fffffffffffull) << 4;
    destination[30] |= (source[44] & 0x1fffffffffffull) >> 41;
    destination[31]  = (source[44] & 0x1fffffffffffull) << 23;
    destination[31] |= (source[45] & 0x1fffffffffffull) >> 22;
    destination[32]  = (source[45] & 0x1fffffffffffull) << 42;
    destination[32] |= (source[46] & 0x1fffffffffffull) >> 3;
    destination[33]  = (source[46] & 0x1fffffffffffull) << 61;
    destination[33] |= (source[47] & 0x1fffffffffffull) << 16;
    destination[33] |= (source[48] & 0x1fffffffffffull) >> 29;
    destination[34]  = (source[48] & 0x1fffffffffffull) << 35;
    destination[34] |= (source[49] & 0x1fffffffffffull) >> 10;
    destination[35]  = (source[49] & 0x1fffffffffffull) << 54;
    destination[35] |= (source[50] & 0x1fffffffffffull) << 9;
    destination[35] |= (source[51] & 0x1fffffffffffull) >> 36;
    destination[36]  = (source[51] & 0x1fffffffffffull) << 28;
    destination[36] |= (source[52] & 0x1fffffffffffull) >> 17;
    destination[37]  = (source[52] & 0x1fffffffffffull) << 47;
    destination[37] |= (source[53] & 0x1fffffffffffull) << 2;
    destination[37] |= (source[54] & 0x1fffffffffffull) >> 43;
    destination[38]  = (source[54] & 0x1fffffffffffull) << 21;
    destination[38] |= (source[55] & 0x1fffffffffffull) >> 24;
    destination[39]  = (source[55] & 0x1fffffffffffull) << 40;
    destination[39] |= (source[56] & 0x1fffffffffffull) >> 5;
    destination[40]  = (source[56] & 0x1fffffffffffull) << 59;
    destination[40] |= (source[57] & 0x1fffffffffffull) << 14;
    destination[40] |= (source[58] & 0x1fffffffffffull) >> 31;
    destination[41]  = (source[58] & 0x1fffffffffffull) << 33;
    destination[41] |= (source[59] & 0x1fffffffffffull) >> 12;
    destination[42]  = (source[59] & 0x1fffffffffffull) << 52;
    destination[42] |= (source[60] & 0x1fffffffffffull) << 7;
    destination[42] |= (source[61] & 0x1fffffffffffull) >> 38;
    destination[43]  = (source[61] & 0x1fffffffffffull) << 26;
    destination[43] |= (source[62] & 0x1fffffffffffull) >> 19;
    destination[44]  = (source[62] & 0x1fffffffffffull) << 45;
    destination[44] |= (source[63] & 0x1fffffffffffull) << 0;
  }
  static inline
  void unpack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] >> 19) & 0x1fffffffffffull;
    destination[1]  = (source[0] << 26) & 0x1fffffffffffull;
    destination[1] |= (source[1] >> 38) & 0x1fffffffffffull;
    destination[2]  = (source[1] << 7) & 0x1fffffffffffull;
    destination[2] |= (source[2] >> 57) & 0x1fffffffffffull;
    destination[3]  = (source[2] >> 12) & 0x1fffffffffffull;
    destination[4]  = (source[2] << 33) & 0x1fffffffffffull;
    destination[4] |= (source[3] >> 31) & 0x1fffffffffffull;
    destination[5]  = (source[3] << 14) & 0x1fffffffffffull;
    destination[5] |= (source[4] >> 50) & 0x1fffffffffffull;
    destination[6]  = (source[4] >> 5) & 0x1fffffffffffull;
    destination[7]  = (source[4] << 40) & 0x1fffffffffffull;
    destination[7] |= (source[5] >> 24) & 0x1fffffffffffull;
    destination[8]  = (source[5] << 21) & 0x1fffffffffffull;
    destination[8] |= (source[6] >> 43) & 0x1fffffffffffull;
    destination[9]  = (source[6] << 2) & 0x1fffffffffffull;
    destination[9] |= (source[7] >> 62) & 0x1fffffffffffull;
    destination[10]  = (source[7] >> 17) & 0x1fffffffffffull;
    destination[11]  = (source[7] << 28) & 0x1fffffffffffull;
    destination[11] |= (source[8] >> 36) & 0x1fffffffffffull;
    destination[12]  = (source[8] << 9) & 0x1fffffffffffull;
    destination[12] |= (source[9] >> 55) & 0x1fffffffffffull;
    destination[13]  = (source[9] >> 10) & 0x1fffffffffffull;
    destination[14]  = (source[9] << 35) & 0x1fffffffffffull;
    destination[14] |= (source[10] >> 29) & 0x1fffffffffffull;
    destination[15]  = (source[10] << 16) & 0x1fffffffffffull;
    destination[15] |= (source[11] >> 48) & 0x1fffffffffffull;
    destination[16]  = (source[11] >> 3) & 0x1fffffffffffull;
    destination[17]  = (source[11] << 42) & 0x1fffffffffffull;
    destination[17] |= (source[12] >> 22) & 0x1fffffffffffull;
    destination[18]  = (source[12] << 23) & 0x1fffffffffffull;
    destination[18] |= (source[13] >> 41) & 0x1fffffffffffull;
    destination[19]  = (source[13] << 4) & 0x1fffffffffffull;
    destination[19] |= (source[14] >> 60) & 0x1fffffffffffull;
    destination[20]  = (source[14] >> 15) & 0x1fffffffffffull;
    destination[21]  = (source[14] << 30) & 0x1fffffffffffull;
    destination[21] |= (source[15] >> 34) & 0x1fffffffffffull;
    destination[22]  = (source[15] << 11) & 0x1fffffffffffull;
    destination[22] |= (source[16] >> 53) & 0x1fffffffffffull;
    destination[23]  = (source[16] >> 8) & 0x1fffffffffffull;
    destination[24]  = (source[16] << 37) & 0x1fffffffffffull;
    destination[24] |= (source[17] >> 27) & 0x1fffffffffffull;
    destination[25]  = (source[17] << 18) & 0x1fffffffffffull;
    destination[25] |= (source[18] >> 46) & 0x1fffffffffffull;
    destination[26]  = (source[18] >> 1) & 0x1fffffffffffull;
    destination[27]  = (source[18] << 44) & 0x1fffffffffffull;
    destination[27] |= (source[19] >> 20) & 0x1fffffffffffull;
    destination[28]  = (source[19] << 25) & 0x1fffffffffffull;
    destination[28] |= (source[20] >> 39) & 0x1fffffffffffull;
    destination[29]  = (source[20] << 6) & 0x1fffffffffffull;
    destination[29] |= (source[21] >> 58) & 0x1fffffffffffull;
    destination[30]  = (source[21] >> 13) & 0x1fffffffffffull;
    destination[31]  = (source[21] << 32) & 0x1fffffffffffull;
    destination[31] |= (source[22] >> 32) & 0x1fffffffffffull;
    destination[32]  = (source[22] << 13) & 0x1fffffffffffull;
    destination[32] |= (source[23] >> 51) & 0x1fffffffffffull;
    destination[33]  = (source[23] >> 6) & 0x1fffffffffffull;
    destination[34]  = (source[23] << 39) & 0x1fffffffffffull;
    destination[34] |= (source[24] >> 25) & 0x1fffffffffffull;
    destination[35]  = (source[24] << 20) & 0x1fffffffffffull;
    destination[35] |= (source[25] >> 44) & 0x1fffffffffffull;
    destination[36]  = (source[25] << 1) & 0x1fffffffffffull;
    destination[36] |= (source[26] >> 63) & 0x1fffffffffffull;
    destination[37]  = (source[26] >> 18) & 0x1fffffffffffull;
    destination[38]  = (source[26] << 27) & 0x1fffffffffffull;
    destination[38] |= (source[27] >> 37) & 0x1fffffffffffull;
    destination[39]  = (source[27] << 8) & 0x1fffffffffffull;
    destination[39] |= (source[28] >> 56) & 0x1fffffffffffull;
    destination[40]  = (source[28] >> 11) & 0x1fffffffffffull;
    destination[41]  = (source[28] << 34) & 0x1fffffffffffull;
    destination[41] |= (source[29] >> 30) & 0x1fffffffffffull;
    destination[42]  = (source[29] << 15) & 0x1fffffffffffull;
    destination[42] |= (source[30] >> 49) & 0x1fffffffffffull;
    destination[43]  = (source[30] >> 4) & 0x1fffffffffffull;
    destination[44]  = (source[30] << 41) & 0x1fffffffffffull;
    destination[44] |= (source[31] >> 23) & 0x1fffffffffffull;
    destination[45]  = (source[31] << 22) & 0x1fffffffffffull;
    destination[45] |= (source[32] >> 42) & 0x1fffffffffffull;
    destination[46]  = (source[32] << 3) & 0x1fffffffffffull;
    destination[46] |= (source[33] >> 61) & 0x1fffffffffffull;
    destination[47]  = (source[33] >> 16) & 0x1fffffffffffull;
    destination[48]  = (source[33] << 29) & 0x1fffffffffffull;
    destination[48] |= (source[34] >> 35) & 0x1fffffffffffull;
    destination[49]  = (source[34] << 10) & 0x1fffffffffffull;
    destination[49] |= (source[35] >> 54) & 0x1fffffffffffull;
    destination[50]  = (source[35] >> 9) & 0x1fffffffffffull;
    destination[51]  = (source[35] << 36) & 0x1fffffffffffull;
    destination[51] |= (source[36] >> 28) & 0x1fffffffffffull;
    destination[52]  = (source[36] << 17) & 0x1fffffffffffull;
    destination[52] |= (source[37] >> 47) & 0x1fffffffffffull;
    destination[53]  = (source[37] >> 2) & 0x1fffffffffffull;
    destination[54]  = (source[37] << 43) & 0x1fffffffffffull;
    destination[54] |= (source[38] >> 21) & 0x1fffffffffffull;
    destination[55]  = (source[38] << 24) & 0x1fffffffffffull;
    destination[55] |= (source[39] >> 40) & 0x1fffffffffffull;
    destination[56]  = (source[39] << 5) & 0x1fffffffffffull;
    destination[56] |= (source[40] >> 59) & 0x1fffffffffffull;
    destination[57]  = (source[40] >> 14) & 0x1fffffffffffull;
    destination[58]  = (source[40] << 31) & 0x1fffffffffffull;
    destination[58] |= (source[41] >> 33) & 0x1fffffffffffull;
    destination[59]  = (source[41] << 12) & 0x1fffffffffffull;
    destination[59] |= (source[42] >> 52) & 0x1fffffffffffull;
    destination[60]  = (source[42] >> 7) & 0x1fffffffffffull;
    destination[61]  = (source[42] << 38) & 0x1fffffffffffull;
    destination[61] |= (source[43] >> 26) & 0x1fffffffffffull;
    destination[62]  = (source[43] << 19) & 0x1fffffffffffull;
    destination[62] |= (source[44] >> 45) & 0x1fffffffffffull;
    destination[63]  = (source[44] >> 0) & 0x1fffffffffffull;
  }
};
template <typename Tp>
struct __struct_bitpack_impl<Tp,8,46>
{
  static const size_t unit_size = 64;
  static const size_t bits_total = 2944;
  static const size_t loop_total = 64;
  static const size_t bit_size = 46;
  static const Tp     mask = 0x3fffffffffffull;
  static inline
  void pack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] & 0x3fffffffffffull) << 18;
    destination[0] |= (source[1] & 0x3fffffffffffull) >> 28;
    destination[1]  = (source[1] & 0x3fffffffffffull) << 36;
    destination[1] |= (source[2] & 0x3fffffffffffull) >> 10;
    destination[2]  = (source[2] & 0x3fffffffffffull) << 54;
    destination[2] |= (source[3] & 0x3fffffffffffull) << 8;
    destination[2] |= (source[4] & 0x3fffffffffffull) >> 38;
    destination[3]  = (source[4] & 0x3fffffffffffull) << 26;
    destination[3] |= (source[5] & 0x3fffffffffffull) >> 20;
    destination[4]  = (source[5] & 0x3fffffffffffull) << 44;
    destination[4] |= (source[6] & 0x3fffffffffffull) >> 2;
    destination[5]  = (source[6] & 0x3fffffffffffull) << 62;
    destination[5] |= (source[7] & 0x3fffffffffffull) << 16;
    destination[5] |= (source[8] & 0x3fffffffffffull) >> 30;
    destination[6]  = (source[8] & 0x3fffffffffffull) << 34;
    destination[6] |= (source[9] & 0x3fffffffffffull) >> 12;
    destination[7]  = (source[9] & 0x3fffffffffffull) << 52;
    destination[7] |= (source[10] & 0x3fffffffffffull) << 6;
    destination[7] |= (source[11] & 0x3fffffffffffull) >> 40;
    destination[8]  = (source[11] & 0x3fffffffffffull) << 24;
    destination[8] |= (source[12] & 0x3fffffffffffull) >> 22;
    destination[9]  = (source[12] & 0x3fffffffffffull) << 42;
    destination[9] |= (source[13] & 0x3fffffffffffull) >> 4;
    destination[10]  = (source[13] & 0x3fffffffffffull) << 60;
    destination[10] |= (source[14] & 0x3fffffffffffull) << 14;
    destination[10] |= (source[15] & 0x3fffffffffffull) >> 32;
    destination[11]  = (source[15] & 0x3fffffffffffull) << 32;
    destination[11] |= (source[16] & 0x3fffffffffffull) >> 14;
    destination[12]  = (source[16] & 0x3fffffffffffull) << 50;
    destination[12] |= (source[17] & 0x3fffffffffffull) << 4;
    destination[12] |= (source[18] & 0x3fffffffffffull) >> 42;
    destination[13]  = (source[18] & 0x3fffffffffffull) << 22;
    destination[13] |= (source[19] & 0x3fffffffffffull) >> 24;
    destination[14]  = (source[19] & 0x3fffffffffffull) << 40;
    destination[14] |= (source[20] & 0x3fffffffffffull) >> 6;
    destination[15]  = (source[20] & 0x3fffffffffffull) << 58;
    destination[15] |= (source[21] & 0x3fffffffffffull) << 12;
    destination[15] |= (source[22] & 0x3fffffffffffull) >> 34;
    destination[16]  = (source[22] & 0x3fffffffffffull) << 30;
    destination[16] |= (source[23] & 0x3fffffffffffull) >> 16;
    destination[17]  = (source[23] & 0x3fffffffffffull) << 48;
    destination[17] |= (source[24] & 0x3fffffffffffull) << 2;
    destination[17] |= (source[25] & 0x3fffffffffffull) >> 44;
    destination[18]  = (source[25] & 0x3fffffffffffull) << 20;
    destination[18] |= (source[26] & 0x3fffffffffffull) >> 26;
    destination[19]  = (source[26] & 0x3fffffffffffull) << 38;
    destination[19] |= (source[27] & 0x3fffffffffffull) >> 8;
    destination[20]  = (source[27] & 0x3fffffffffffull) << 56;
    destination[20] |= (source[28] & 0x3fffffffffffull) << 10;
    destination[20] |= (source[29] & 0x3fffffffffffull) >> 36;
    destination[21]  = (source[29] & 0x3fffffffffffull) << 28;
    destination[21] |= (source[30] & 0x3fffffffffffull) >> 18;
    destination[22]  = (source[30] & 0x3fffffffffffull) << 46;
    destination[22] |= (source[31] & 0x3fffffffffffull) << 0;
    destination[23]  = (source[32] & 0x3fffffffffffull) << 18;
    destination[23] |= (source[33] & 0x3fffffffffffull) >> 28;
    destination[24]  = (source[33] & 0x3fffffffffffull) << 36;
    destination[24] |= (source[34] & 0x3fffffffffffull) >> 10;
    destination[25]  = (source[34] & 0x3fffffffffffull) << 54;
    destination[25] |= (source[35] & 0x3fffffffffffull) << 8;
    destination[25] |= (source[36] & 0x3fffffffffffull) >> 38;
    destination[26]  = (source[36] & 0x3fffffffffffull) << 26;
    destination[26] |= (source[37] & 0x3fffffffffffull) >> 20;
    destination[27]  = (source[37] & 0x3fffffffffffull) << 44;
    destination[27] |= (source[38] & 0x3fffffffffffull) >> 2;
    destination[28]  = (source[38] & 0x3fffffffffffull) << 62;
    destination[28] |= (source[39] & 0x3fffffffffffull) << 16;
    destination[28] |= (source[40] & 0x3fffffffffffull) >> 30;
    destination[29]  = (source[40] & 0x3fffffffffffull) << 34;
    destination[29] |= (source[41] & 0x3fffffffffffull) >> 12;
    destination[30]  = (source[41] & 0x3fffffffffffull) << 52;
    destination[30] |= (source[42] & 0x3fffffffffffull) << 6;
    destination[30] |= (source[43] & 0x3fffffffffffull) >> 40;
    destination[31]  = (source[43] & 0x3fffffffffffull) << 24;
    destination[31] |= (source[44] & 0x3fffffffffffull) >> 22;
    destination[32]  = (source[44] & 0x3fffffffffffull) << 42;
    destination[32] |= (source[45] & 0x3fffffffffffull) >> 4;
    destination[33]  = (source[45] & 0x3fffffffffffull) << 60;
    destination[33] |= (source[46] & 0x3fffffffffffull) << 14;
    destination[33] |= (source[47] & 0x3fffffffffffull) >> 32;
    destination[34]  = (source[47] & 0x3fffffffffffull) << 32;
    destination[34] |= (source[48] & 0x3fffffffffffull) >> 14;
    destination[35]  = (source[48] & 0x3fffffffffffull) << 50;
    destination[35] |= (source[49] & 0x3fffffffffffull) << 4;
    destination[35] |= (source[50] & 0x3fffffffffffull) >> 42;
    destination[36]  = (source[50] & 0x3fffffffffffull) << 22;
    destination[36] |= (source[51] & 0x3fffffffffffull) >> 24;
    destination[37]  = (source[51] & 0x3fffffffffffull) << 40;
    destination[37] |= (source[52] & 0x3fffffffffffull) >> 6;
    destination[38]  = (source[52] & 0x3fffffffffffull) << 58;
    destination[38] |= (source[53] & 0x3fffffffffffull) << 12;
    destination[38] |= (source[54] & 0x3fffffffffffull) >> 34;
    destination[39]  = (source[54] & 0x3fffffffffffull) << 30;
    destination[39] |= (source[55] & 0x3fffffffffffull) >> 16;
    destination[40]  = (source[55] & 0x3fffffffffffull) << 48;
    destination[40] |= (source[56] & 0x3fffffffffffull) << 2;
    destination[40] |= (source[57] & 0x3fffffffffffull) >> 44;
    destination[41]  = (source[57] & 0x3fffffffffffull) << 20;
    destination[41] |= (source[58] & 0x3fffffffffffull) >> 26;
    destination[42]  = (source[58] & 0x3fffffffffffull) << 38;
    destination[42] |= (source[59] & 0x3fffffffffffull) >> 8;
    destination[43]  = (source[59] & 0x3fffffffffffull) << 56;
    destination[43] |= (source[60] & 0x3fffffffffffull) << 10;
    destination[43] |= (source[61] & 0x3fffffffffffull) >> 36;
    destination[44]  = (source[61] & 0x3fffffffffffull) << 28;
    destination[44] |= (source[62] & 0x3fffffffffffull) >> 18;
    destination[45]  = (source[62] & 0x3fffffffffffull) << 46;
    destination[45] |= (source[63] & 0x3fffffffffffull) << 0;
  }
  static inline
  void unpack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] >> 18) & 0x3fffffffffffull;
    destination[1]  = (source[0] << 28) & 0x3fffffffffffull;
    destination[1] |= (source[1] >> 36) & 0x3fffffffffffull;
    destination[2]  = (source[1] << 10) & 0x3fffffffffffull;
    destination[2] |= (source[2] >> 54) & 0x3fffffffffffull;
    destination[3]  = (source[2] >> 8) & 0x3fffffffffffull;
    destination[4]  = (source[2] << 38) & 0x3fffffffffffull;
    destination[4] |= (source[3] >> 26) & 0x3fffffffffffull;
    destination[5]  = (source[3] << 20) & 0x3fffffffffffull;
    destination[5] |= (source[4] >> 44) & 0x3fffffffffffull;
    destination[6]  = (source[4] << 2) & 0x3fffffffffffull;
    destination[6] |= (source[5] >> 62) & 0x3fffffffffffull;
    destination[7]  = (source[5] >> 16) & 0x3fffffffffffull;
    destination[8]  = (source[5] << 30) & 0x3fffffffffffull;
    destination[8] |= (source[6] >> 34) & 0x3fffffffffffull;
    destination[9]  = (source[6] << 12) & 0x3fffffffffffull;
    destination[9] |= (source[7] >> 52) & 0x3fffffffffffull;
    destination[10]  = (source[7] >> 6) & 0x3fffffffffffull;
    destination[11]  = (source[7] << 40) & 0x3fffffffffffull;
    destination[11] |= (source[8] >> 24) & 0x3fffffffffffull;
    destination[12]  = (source[8] << 22) & 0x3fffffffffffull;
    destination[12] |= (source[9] >> 42) & 0x3fffffffffffull;
    destination[13]  = (source[9] << 4) & 0x3fffffffffffull;
    destination[13] |= (source[10] >> 60) & 0x3fffffffffffull;
    destination[14]  = (source[10] >> 14) & 0x3fffffffffffull;
    destination[15]  = (source[10] << 32) & 0x3fffffffffffull;
    destination[15] |= (source[11] >> 32) & 0x3fffffffffffull;
    destination[16]  = (source[11] << 14) & 0x3fffffffffffull;
    destination[16] |= (source[12] >> 50) & 0x3fffffffffffull;
    destination[17]  = (source[12] >> 4) & 0x3fffffffffffull;
    destination[18]  = (source[12] << 42) & 0x3fffffffffffull;
    destination[18] |= (source[13] >> 22) & 0x3fffffffffffull;
    destination[19]  = (source[13] << 24) & 0x3fffffffffffull;
    destination[19] |= (source[14] >> 40) & 0x3fffffffffffull;
    destination[20]  = (source[14] << 6) & 0x3fffffffffffull;
    destination[20] |= (source[15] >> 58) & 0x3fffffffffffull;
    destination[21]  = (source[15] >> 12) & 0x3fffffffffffull;
    destination[22]  = (source[15] << 34) & 0x3fffffffffffull;
    destination[22] |= (source[16] >> 30) & 0x3fffffffffffull;
    destination[23]  = (source[16] << 16) & 0x3fffffffffffull;
    destination[23] |= (source[17] >> 48) & 0x3fffffffffffull;
    destination[24]  = (source[17] >> 2) & 0x3fffffffffffull;
    destination[25]  = (source[17] << 44) & 0x3fffffffffffull;
    destination[25] |= (source[18] >> 20) & 0x3fffffffffffull;
    destination[26]  = (source[18] << 26) & 0x3fffffffffffull;
    destination[26] |= (source[19] >> 38) & 0x3fffffffffffull;
    destination[27]  = (source[19] << 8) & 0x3fffffffffffull;
    destination[27] |= (source[20] >> 56) & 0x3fffffffffffull;
    destination[28]  = (source[20] >> 10) & 0x3fffffffffffull;
    destination[29]  = (source[20] << 36) & 0x3fffffffffffull;
    destination[29] |= (source[21] >> 28) & 0x3fffffffffffull;
    destination[30]  = (source[21] << 18) & 0x3fffffffffffull;
    destination[30] |= (source[22] >> 46) & 0x3fffffffffffull;
    destination[31]  = (source[22] >> 0) & 0x3fffffffffffull;
    destination[32]  = (source[23] >> 18) & 0x3fffffffffffull;
    destination[33]  = (source[23] << 28) & 0x3fffffffffffull;
    destination[33] |= (source[24] >> 36) & 0x3fffffffffffull;
    destination[34]  = (source[24] << 10) & 0x3fffffffffffull;
    destination[34] |= (source[25] >> 54) & 0x3fffffffffffull;
    destination[35]  = (source[25] >> 8) & 0x3fffffffffffull;
    destination[36]  = (source[25] << 38) & 0x3fffffffffffull;
    destination[36] |= (source[26] >> 26) & 0x3fffffffffffull;
    destination[37]  = (source[26] << 20) & 0x3fffffffffffull;
    destination[37] |= (source[27] >> 44) & 0x3fffffffffffull;
    destination[38]  = (source[27] << 2) & 0x3fffffffffffull;
    destination[38] |= (source[28] >> 62) & 0x3fffffffffffull;
    destination[39]  = (source[28] >> 16) & 0x3fffffffffffull;
    destination[40]  = (source[28] << 30) & 0x3fffffffffffull;
    destination[40] |= (source[29] >> 34) & 0x3fffffffffffull;
    destination[41]  = (source[29] << 12) & 0x3fffffffffffull;
    destination[41] |= (source[30] >> 52) & 0x3fffffffffffull;
    destination[42]  = (source[30] >> 6) & 0x3fffffffffffull;
    destination[43]  = (source[30] << 40) & 0x3fffffffffffull;
    destination[43] |= (source[31] >> 24) & 0x3fffffffffffull;
    destination[44]  = (source[31] << 22) & 0x3fffffffffffull;
    destination[44] |= (source[32] >> 42) & 0x3fffffffffffull;
    destination[45]  = (source[32] << 4) & 0x3fffffffffffull;
    destination[45] |= (source[33] >> 60) & 0x3fffffffffffull;
    destination[46]  = (source[33] >> 14) & 0x3fffffffffffull;
    destination[47]  = (source[33] << 32) & 0x3fffffffffffull;
    destination[47] |= (source[34] >> 32) & 0x3fffffffffffull;
    destination[48]  = (source[34] << 14) & 0x3fffffffffffull;
    destination[48] |= (source[35] >> 50) & 0x3fffffffffffull;
    destination[49]  = (source[35] >> 4) & 0x3fffffffffffull;
    destination[50]  = (source[35] << 42) & 0x3fffffffffffull;
    destination[50] |= (source[36] >> 22) & 0x3fffffffffffull;
    destination[51]  = (source[36] << 24) & 0x3fffffffffffull;
    destination[51] |= (source[37] >> 40) & 0x3fffffffffffull;
    destination[52]  = (source[37] << 6) & 0x3fffffffffffull;
    destination[52] |= (source[38] >> 58) & 0x3fffffffffffull;
    destination[53]  = (source[38] >> 12) & 0x3fffffffffffull;
    destination[54]  = (source[38] << 34) & 0x3fffffffffffull;
    destination[54] |= (source[39] >> 30) & 0x3fffffffffffull;
    destination[55]  = (source[39] << 16) & 0x3fffffffffffull;
    destination[55] |= (source[40] >> 48) & 0x3fffffffffffull;
    destination[56]  = (source[40] >> 2) & 0x3fffffffffffull;
    destination[57]  = (source[40] << 44) & 0x3fffffffffffull;
    destination[57] |= (source[41] >> 20) & 0x3fffffffffffull;
    destination[58]  = (source[41] << 26) & 0x3fffffffffffull;
    destination[58] |= (source[42] >> 38) & 0x3fffffffffffull;
    destination[59]  = (source[42] << 8) & 0x3fffffffffffull;
    destination[59] |= (source[43] >> 56) & 0x3fffffffffffull;
    destination[60]  = (source[43] >> 10) & 0x3fffffffffffull;
    destination[61]  = (source[43] << 36) & 0x3fffffffffffull;
    destination[61] |= (source[44] >> 28) & 0x3fffffffffffull;
    destination[62]  = (source[44] << 18) & 0x3fffffffffffull;
    destination[62] |= (source[45] >> 46) & 0x3fffffffffffull;
    destination[63]  = (source[45] >> 0) & 0x3fffffffffffull;
  }
};
template <typename Tp>
struct __struct_bitpack_impl<Tp,8,47>
{
  static const size_t unit_size = 64;
  static const size_t bits_total = 3008;
  static const size_t loop_total = 64;
  static const size_t bit_size = 47;
  static const Tp     mask = 0x7fffffffffffull;
  static inline
  void pack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] & 0x7fffffffffffull) << 17;
    destination[0] |= (source[1] & 0x7fffffffffffull) >> 30;
    destination[1]  = (source[1] & 0x7fffffffffffull) << 34;
    destination[1] |= (source[2] & 0x7fffffffffffull) >> 13;
    destination[2]  = (source[2] & 0x7fffffffffffull) << 51;
    destination[2] |= (source[3] & 0x7fffffffffffull) << 4;
    destination[2] |= (source[4] & 0x7fffffffffffull) >> 43;
    destination[3]  = (source[4] & 0x7fffffffffffull) << 21;
    destination[3] |= (source[5] & 0x7fffffffffffull) >> 26;
    destination[4]  = (source[5] & 0x7fffffffffffull) << 38;
    destination[4] |= (source[6] & 0x7fffffffffffull) >> 9;
    destination[5]  = (source[6] & 0x7fffffffffffull) << 55;
    destination[5] |= (source[7] & 0x7fffffffffffull) << 8;
    destination[5] |= (source[8] & 0x7fffffffffffull) >> 39;
    destination[6]  = (source[8] & 0x7fffffffffffull) << 25;
    destination[6] |= (source[9] & 0x7fffffffffffull) >> 22;
    destination[7]  = (source[9] & 0x7fffffffffffull) << 42;
    destination[7] |= (source[10] & 0x7fffffffffffull) >> 5;
    destination[8]  = (source[10] & 0x7fffffffffffull) << 59;
    destination[8] |= (source[11] & 0x7fffffffffffull) << 12;
    destination[8] |= (source[12] & 0x7fffffffffffull) >> 35;
    destination[9]  = (source[12] & 0x7fffffffffffull) << 29;
    destination[9] |= (source[13] & 0x7fffffffffffull) >> 18;
    destination[10]  = (source[13] & 0x7fffffffffffull) << 46;
    destination[10] |= (source[14] & 0x7fffffffffffull) >> 1;
    destination[11]  = (source[14] & 0x7fffffffffffull) << 63;
    destination[11] |= (source[15] & 0x7fffffffffffull) << 16;
    destination[11] |= (source[16] & 0x7fffffffffffull) >> 31;
    destination[12]  = (source[16] & 0x7fffffffffffull) << 33;
    destination[12] |= (source[17] & 0x7fffffffffffull) >> 14;
    destination[13]  = (source[17] & 0x7fffffffffffull) << 50;
    destination[13] |= (source[18] & 0x7fffffffffffull) << 3;
    destination[13] |= (source[19] & 0x7fffffffffffull) >> 44;
    destination[14]  = (source[19] & 0x7fffffffffffull) << 20;
    destination[14] |= (source[20] & 0x7fffffffffffull) >> 27;
    destination[15]  = (source[20] & 0x7fffffffffffull) << 37;
    destination[15] |= (source[21] & 0x7fffffffffffull) >> 10;
    destination[16]  = (source[21] & 0x7fffffffffffull) << 54;
    destination[16] |= (source[22] & 0x7fffffffffffull) << 7;
    destination[16] |= (source[23] & 0x7fffffffffffull) >> 40;
    destination[17]  = (source[23] & 0x7fffffffffffull) << 24;
    destination[17] |= (source[24] & 0x7fffffffffffull) >> 23;
    destination[18]  = (source[24] & 0x7fffffffffffull) << 41;
    destination[18] |= (source[25] & 0x7fffffffffffull) >> 6;
    destination[19]  = (source[25] & 0x7fffffffffffull) << 58;
    destination[19] |= (source[26] & 0x7fffffffffffull) << 11;
    destination[19] |= (source[27] & 0x7fffffffffffull) >> 36;
    destination[20]  = (source[27] & 0x7fffffffffffull) << 28;
    destination[20] |= (source[28] & 0x7fffffffffffull) >> 19;
    destination[21]  = (source[28] & 0x7fffffffffffull) << 45;
    destination[21] |= (source[29] & 0x7fffffffffffull) >> 2;
    destination[22]  = (source[29] & 0x7fffffffffffull) << 62;
    destination[22] |= (source[30] & 0x7fffffffffffull) << 15;
    destination[22] |= (source[31] & 0x7fffffffffffull) >> 32;
    destination[23]  = (source[31] & 0x7fffffffffffull) << 32;
    destination[23] |= (source[32] & 0x7fffffffffffull) >> 15;
    destination[24]  = (source[32] & 0x7fffffffffffull) << 49;
    destination[24] |= (source[33] & 0x7fffffffffffull) << 2;
    destination[24] |= (source[34] & 0x7fffffffffffull) >> 45;
    destination[25]  = (source[34] & 0x7fffffffffffull) << 19;
    destination[25] |= (source[35] & 0x7fffffffffffull) >> 28;
    destination[26]  = (source[35] & 0x7fffffffffffull) << 36;
    destination[26] |= (source[36] & 0x7fffffffffffull) >> 11;
    destination[27]  = (source[36] & 0x7fffffffffffull) << 53;
    destination[27] |= (source[37] & 0x7fffffffffffull) << 6;
    destination[27] |= (source[38] & 0x7fffffffffffull) >> 41;
    destination[28]  = (source[38] & 0x7fffffffffffull) << 23;
    destination[28] |= (source[39] & 0x7fffffffffffull) >> 24;
    destination[29]  = (source[39] & 0x7fffffffffffull) << 40;
    destination[29] |= (source[40] & 0x7fffffffffffull) >> 7;
    destination[30]  = (source[40] & 0x7fffffffffffull) << 57;
    destination[30] |= (source[41] & 0x7fffffffffffull) << 10;
    destination[30] |= (source[42] & 0x7fffffffffffull) >> 37;
    destination[31]  = (source[42] & 0x7fffffffffffull) << 27;
    destination[31] |= (source[43] & 0x7fffffffffffull) >> 20;
    destination[32]  = (source[43] & 0x7fffffffffffull) << 44;
    destination[32] |= (source[44] & 0x7fffffffffffull) >> 3;
    destination[33]  = (source[44] & 0x7fffffffffffull) << 61;
    destination[33] |= (source[45] & 0x7fffffffffffull) << 14;
    destination[33] |= (source[46] & 0x7fffffffffffull) >> 33;
    destination[34]  = (source[46] & 0x7fffffffffffull) << 31;
    destination[34] |= (source[47] & 0x7fffffffffffull) >> 16;
    destination[35]  = (source[47] & 0x7fffffffffffull) << 48;
    destination[35] |= (source[48] & 0x7fffffffffffull) << 1;
    destination[35] |= (source[49] & 0x7fffffffffffull) >> 46;
    destination[36]  = (source[49] & 0x7fffffffffffull) << 18;
    destination[36] |= (source[50] & 0x7fffffffffffull) >> 29;
    destination[37]  = (source[50] & 0x7fffffffffffull) << 35;
    destination[37] |= (source[51] & 0x7fffffffffffull) >> 12;
    destination[38]  = (source[51] & 0x7fffffffffffull) << 52;
    destination[38] |= (source[52] & 0x7fffffffffffull) << 5;
    destination[38] |= (source[53] & 0x7fffffffffffull) >> 42;
    destination[39]  = (source[53] & 0x7fffffffffffull) << 22;
    destination[39] |= (source[54] & 0x7fffffffffffull) >> 25;
    destination[40]  = (source[54] & 0x7fffffffffffull) << 39;
    destination[40] |= (source[55] & 0x7fffffffffffull) >> 8;
    destination[41]  = (source[55] & 0x7fffffffffffull) << 56;
    destination[41] |= (source[56] & 0x7fffffffffffull) << 9;
    destination[41] |= (source[57] & 0x7fffffffffffull) >> 38;
    destination[42]  = (source[57] & 0x7fffffffffffull) << 26;
    destination[42] |= (source[58] & 0x7fffffffffffull) >> 21;
    destination[43]  = (source[58] & 0x7fffffffffffull) << 43;
    destination[43] |= (source[59] & 0x7fffffffffffull) >> 4;
    destination[44]  = (source[59] & 0x7fffffffffffull) << 60;
    destination[44] |= (source[60] & 0x7fffffffffffull) << 13;
    destination[44] |= (source[61] & 0x7fffffffffffull) >> 34;
    destination[45]  = (source[61] & 0x7fffffffffffull) << 30;
    destination[45] |= (source[62] & 0x7fffffffffffull) >> 17;
    destination[46]  = (source[62] & 0x7fffffffffffull) << 47;
    destination[46] |= (source[63] & 0x7fffffffffffull) << 0;
  }
  static inline
  void unpack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] >> 17) & 0x7fffffffffffull;
    destination[1]  = (source[0] << 30) & 0x7fffffffffffull;
    destination[1] |= (source[1] >> 34) & 0x7fffffffffffull;
    destination[2]  = (source[1] << 13) & 0x7fffffffffffull;
    destination[2] |= (source[2] >> 51) & 0x7fffffffffffull;
    destination[3]  = (source[2] >> 4) & 0x7fffffffffffull;
    destination[4]  = (source[2] << 43) & 0x7fffffffffffull;
    destination[4] |= (source[3] >> 21) & 0x7fffffffffffull;
    destination[5]  = (source[3] << 26) & 0x7fffffffffffull;
    destination[5] |= (source[4] >> 38) & 0x7fffffffffffull;
    destination[6]  = (source[4] << 9) & 0x7fffffffffffull;
    destination[6] |= (source[5] >> 55) & 0x7fffffffffffull;
    destination[7]  = (source[5] >> 8) & 0x7fffffffffffull;
    destination[8]  = (source[5] << 39) & 0x7fffffffffffull;
    destination[8] |= (source[6] >> 25) & 0x7fffffffffffull;
    destination[9]  = (source[6] << 22) & 0x7fffffffffffull;
    destination[9] |= (source[7] >> 42) & 0x7fffffffffffull;
    destination[10]  = (source[7] << 5) & 0x7fffffffffffull;
    destination[10] |= (source[8] >> 59) & 0x7fffffffffffull;
    destination[11]  = (source[8] >> 12) & 0x7fffffffffffull;
    destination[12]  = (source[8] << 35) & 0x7fffffffffffull;
    destination[12] |= (source[9] >> 29) & 0x7fffffffffffull;
    destination[13]  = (source[9] << 18) & 0x7fffffffffffull;
    destination[13] |= (source[10] >> 46) & 0x7fffffffffffull;
    destination[14]  = (source[10] << 1) & 0x7fffffffffffull;
    destination[14] |= (source[11] >> 63) & 0x7fffffffffffull;
    destination[15]  = (source[11] >> 16) & 0x7fffffffffffull;
    destination[16]  = (source[11] << 31) & 0x7fffffffffffull;
    destination[16] |= (source[12] >> 33) & 0x7fffffffffffull;
    destination[17]  = (source[12] << 14) & 0x7fffffffffffull;
    destination[17] |= (source[13] >> 50) & 0x7fffffffffffull;
    destination[18]  = (source[13] >> 3) & 0x7fffffffffffull;
    destination[19]  = (source[13] << 44) & 0x7fffffffffffull;
    destination[19] |= (source[14] >> 20) & 0x7fffffffffffull;
    destination[20]  = (source[14] << 27) & 0x7fffffffffffull;
    destination[20] |= (source[15] >> 37) & 0x7fffffffffffull;
    destination[21]  = (source[15] << 10) & 0x7fffffffffffull;
    destination[21] |= (source[16] >> 54) & 0x7fffffffffffull;
    destination[22]  = (source[16] >> 7) & 0x7fffffffffffull;
    destination[23]  = (source[16] << 40) & 0x7fffffffffffull;
    destination[23] |= (source[17] >> 24) & 0x7fffffffffffull;
    destination[24]  = (source[17] << 23) & 0x7fffffffffffull;
    destination[24] |= (source[18] >> 41) & 0x7fffffffffffull;
    destination[25]  = (source[18] << 6) & 0x7fffffffffffull;
    destination[25] |= (source[19] >> 58) & 0x7fffffffffffull;
    destination[26]  = (source[19] >> 11) & 0x7fffffffffffull;
    destination[27]  = (source[19] << 36) & 0x7fffffffffffull;
    destination[27] |= (source[20] >> 28) & 0x7fffffffffffull;
    destination[28]  = (source[20] << 19) & 0x7fffffffffffull;
    destination[28] |= (source[21] >> 45) & 0x7fffffffffffull;
    destination[29]  = (source[21] << 2) & 0x7fffffffffffull;
    destination[29] |= (source[22] >> 62) & 0x7fffffffffffull;
    destination[30]  = (source[22] >> 15) & 0x7fffffffffffull;
    destination[31]  = (source[22] << 32) & 0x7fffffffffffull;
    destination[31] |= (source[23] >> 32) & 0x7fffffffffffull;
    destination[32]  = (source[23] << 15) & 0x7fffffffffffull;
    destination[32] |= (source[24] >> 49) & 0x7fffffffffffull;
    destination[33]  = (source[24] >> 2) & 0x7fffffffffffull;
    destination[34]  = (source[24] << 45) & 0x7fffffffffffull;
    destination[34] |= (source[25] >> 19) & 0x7fffffffffffull;
    destination[35]  = (source[25] << 28) & 0x7fffffffffffull;
    destination[35] |= (source[26] >> 36) & 0x7fffffffffffull;
    destination[36]  = (source[26] << 11) & 0x7fffffffffffull;
    destination[36] |= (source[27] >> 53) & 0x7fffffffffffull;
    destination[37]  = (source[27] >> 6) & 0x7fffffffffffull;
    destination[38]  = (source[27] << 41) & 0x7fffffffffffull;
    destination[38] |= (source[28] >> 23) & 0x7fffffffffffull;
    destination[39]  = (source[28] << 24) & 0x7fffffffffffull;
    destination[39] |= (source[29] >> 40) & 0x7fffffffffffull;
    destination[40]  = (source[29] << 7) & 0x7fffffffffffull;
    destination[40] |= (source[30] >> 57) & 0x7fffffffffffull;
    destination[41]  = (source[30] >> 10) & 0x7fffffffffffull;
    destination[42]  = (source[30] << 37) & 0x7fffffffffffull;
    destination[42] |= (source[31] >> 27) & 0x7fffffffffffull;
    destination[43]  = (source[31] << 20) & 0x7fffffffffffull;
    destination[43] |= (source[32] >> 44) & 0x7fffffffffffull;
    destination[44]  = (source[32] << 3) & 0x7fffffffffffull;
    destination[44] |= (source[33] >> 61) & 0x7fffffffffffull;
    destination[45]  = (source[33] >> 14) & 0x7fffffffffffull;
    destination[46]  = (source[33] << 33) & 0x7fffffffffffull;
    destination[46] |= (source[34] >> 31) & 0x7fffffffffffull;
    destination[47]  = (source[34] << 16) & 0x7fffffffffffull;
    destination[47] |= (source[35] >> 48) & 0x7fffffffffffull;
    destination[48]  = (source[35] >> 1) & 0x7fffffffffffull;
    destination[49]  = (source[35] << 46) & 0x7fffffffffffull;
    destination[49] |= (source[36] >> 18) & 0x7fffffffffffull;
    destination[50]  = (source[36] << 29) & 0x7fffffffffffull;
    destination[50] |= (source[37] >> 35) & 0x7fffffffffffull;
    destination[51]  = (source[37] << 12) & 0x7fffffffffffull;
    destination[51] |= (source[38] >> 52) & 0x7fffffffffffull;
    destination[52]  = (source[38] >> 5) & 0x7fffffffffffull;
    destination[53]  = (source[38] << 42) & 0x7fffffffffffull;
    destination[53] |= (source[39] >> 22) & 0x7fffffffffffull;
    destination[54]  = (source[39] << 25) & 0x7fffffffffffull;
    destination[54] |= (source[40] >> 39) & 0x7fffffffffffull;
    destination[55]  = (source[40] << 8) & 0x7fffffffffffull;
    destination[55] |= (source[41] >> 56) & 0x7fffffffffffull;
    destination[56]  = (source[41] >> 9) & 0x7fffffffffffull;
    destination[57]  = (source[41] << 38) & 0x7fffffffffffull;
    destination[57] |= (source[42] >> 26) & 0x7fffffffffffull;
    destination[58]  = (source[42] << 21) & 0x7fffffffffffull;
    destination[58] |= (source[43] >> 43) & 0x7fffffffffffull;
    destination[59]  = (source[43] << 4) & 0x7fffffffffffull;
    destination[59] |= (source[44] >> 60) & 0x7fffffffffffull;
    destination[60]  = (source[44] >> 13) & 0x7fffffffffffull;
    destination[61]  = (source[44] << 34) & 0x7fffffffffffull;
    destination[61] |= (source[45] >> 30) & 0x7fffffffffffull;
    destination[62]  = (source[45] << 17) & 0x7fffffffffffull;
    destination[62] |= (source[46] >> 47) & 0x7fffffffffffull;
    destination[63]  = (source[46] >> 0) & 0x7fffffffffffull;
  }
};
template <typename Tp>
struct __struct_bitpack_impl<Tp,8,48>
{
  static const size_t unit_size = 64;
  static const size_t bits_total = 3072;
  static const size_t loop_total = 64;
  static const size_t bit_size = 48;
  static const Tp     mask = 0xffffffffffffull;
  static inline
  void pack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] & 0xffffffffffffull) << 16;
    destination[0] |= (source[1] & 0xffffffffffffull) >> 32;
    destination[1]  = (source[1] & 0xffffffffffffull) << 32;
    destination[1] |= (source[2] & 0xffffffffffffull) >> 16;
    destination[2]  = (source[2] & 0xffffffffffffull) << 48;
    destination[2] |= (source[3] & 0xffffffffffffull) << 0;
    destination[3]  = (source[4] & 0xffffffffffffull) << 16;
    destination[3] |= (source[5] & 0xffffffffffffull) >> 32;
    destination[4]  = (source[5] & 0xffffffffffffull) << 32;
    destination[4] |= (source[6] & 0xffffffffffffull) >> 16;
    destination[5]  = (source[6] & 0xffffffffffffull) << 48;
    destination[5] |= (source[7] & 0xffffffffffffull) << 0;
    destination[6]  = (source[8] & 0xffffffffffffull) << 16;
    destination[6] |= (source[9] & 0xffffffffffffull) >> 32;
    destination[7]  = (source[9] & 0xffffffffffffull) << 32;
    destination[7] |= (source[10] & 0xffffffffffffull) >> 16;
    destination[8]  = (source[10] & 0xffffffffffffull) << 48;
    destination[8] |= (source[11] & 0xffffffffffffull) << 0;
    destination[9]  = (source[12] & 0xffffffffffffull) << 16;
    destination[9] |= (source[13] & 0xffffffffffffull) >> 32;
    destination[10]  = (source[13] & 0xffffffffffffull) << 32;
    destination[10] |= (source[14] & 0xffffffffffffull) >> 16;
    destination[11]  = (source[14] & 0xffffffffffffull) << 48;
    destination[11] |= (source[15] & 0xffffffffffffull) << 0;
    destination[12]  = (source[16] & 0xffffffffffffull) << 16;
    destination[12] |= (source[17] & 0xffffffffffffull) >> 32;
    destination[13]  = (source[17] & 0xffffffffffffull) << 32;
    destination[13] |= (source[18] & 0xffffffffffffull) >> 16;
    destination[14]  = (source[18] & 0xffffffffffffull) << 48;
    destination[14] |= (source[19] & 0xffffffffffffull) << 0;
    destination[15]  = (source[20] & 0xffffffffffffull) << 16;
    destination[15] |= (source[21] & 0xffffffffffffull) >> 32;
    destination[16]  = (source[21] & 0xffffffffffffull) << 32;
    destination[16] |= (source[22] & 0xffffffffffffull) >> 16;
    destination[17]  = (source[22] & 0xffffffffffffull) << 48;
    destination[17] |= (source[23] & 0xffffffffffffull) << 0;
    destination[18]  = (source[24] & 0xffffffffffffull) << 16;
    destination[18] |= (source[25] & 0xffffffffffffull) >> 32;
    destination[19]  = (source[25] & 0xffffffffffffull) << 32;
    destination[19] |= (source[26] & 0xffffffffffffull) >> 16;
    destination[20]  = (source[26] & 0xffffffffffffull) << 48;
    destination[20] |= (source[27] & 0xffffffffffffull) << 0;
    destination[21]  = (source[28] & 0xffffffffffffull) << 16;
    destination[21] |= (source[29] & 0xffffffffffffull) >> 32;
    destination[22]  = (source[29] & 0xffffffffffffull) << 32;
    destination[22] |= (source[30] & 0xffffffffffffull) >> 16;
    destination[23]  = (source[30] & 0xffffffffffffull) << 48;
    destination[23] |= (source[31] & 0xffffffffffffull) << 0;
    destination[24]  = (source[32] & 0xffffffffffffull) << 16;
    destination[24] |= (source[33] & 0xffffffffffffull) >> 32;
    destination[25]  = (source[33] & 0xffffffffffffull) << 32;
    destination[25] |= (source[34] & 0xffffffffffffull) >> 16;
    destination[26]  = (source[34] & 0xffffffffffffull) << 48;
    destination[26] |= (source[35] & 0xffffffffffffull) << 0;
    destination[27]  = (source[36] & 0xffffffffffffull) << 16;
    destination[27] |= (source[37] & 0xffffffffffffull) >> 32;
    destination[28]  = (source[37] & 0xffffffffffffull) << 32;
    destination[28] |= (source[38] & 0xffffffffffffull) >> 16;
    destination[29]  = (source[38] & 0xffffffffffffull) << 48;
    destination[29] |= (source[39] & 0xffffffffffffull) << 0;
    destination[30]  = (source[40] & 0xffffffffffffull) << 16;
    destination[30] |= (source[41] & 0xffffffffffffull) >> 32;
    destination[31]  = (source[41] & 0xffffffffffffull) << 32;
    destination[31] |= (source[42] & 0xffffffffffffull) >> 16;
    destination[32]  = (source[42] & 0xffffffffffffull) << 48;
    destination[32] |= (source[43] & 0xffffffffffffull) << 0;
    destination[33]  = (source[44] & 0xffffffffffffull) << 16;
    destination[33] |= (source[45] & 0xffffffffffffull) >> 32;
    destination[34]  = (source[45] & 0xffffffffffffull) << 32;
    destination[34] |= (source[46] & 0xffffffffffffull) >> 16;
    destination[35]  = (source[46] & 0xffffffffffffull) << 48;
    destination[35] |= (source[47] & 0xffffffffffffull) << 0;
    destination[36]  = (source[48] & 0xffffffffffffull) << 16;
    destination[36] |= (source[49] & 0xffffffffffffull) >> 32;
    destination[37]  = (source[49] & 0xffffffffffffull) << 32;
    destination[37] |= (source[50] & 0xffffffffffffull) >> 16;
    destination[38]  = (source[50] & 0xffffffffffffull) << 48;
    destination[38] |= (source[51] & 0xffffffffffffull) << 0;
    destination[39]  = (source[52] & 0xffffffffffffull) << 16;
    destination[39] |= (source[53] & 0xffffffffffffull) >> 32;
    destination[40]  = (source[53] & 0xffffffffffffull) << 32;
    destination[40] |= (source[54] & 0xffffffffffffull) >> 16;
    destination[41]  = (source[54] & 0xffffffffffffull) << 48;
    destination[41] |= (source[55] & 0xffffffffffffull) << 0;
    destination[42]  = (source[56] & 0xffffffffffffull) << 16;
    destination[42] |= (source[57] & 0xffffffffffffull) >> 32;
    destination[43]  = (source[57] & 0xffffffffffffull) << 32;
    destination[43] |= (source[58] & 0xffffffffffffull) >> 16;
    destination[44]  = (source[58] & 0xffffffffffffull) << 48;
    destination[44] |= (source[59] & 0xffffffffffffull) << 0;
    destination[45]  = (source[60] & 0xffffffffffffull) << 16;
    destination[45] |= (source[61] & 0xffffffffffffull) >> 32;
    destination[46]  = (source[61] & 0xffffffffffffull) << 32;
    destination[46] |= (source[62] & 0xffffffffffffull) >> 16;
    destination[47]  = (source[62] & 0xffffffffffffull) << 48;
    destination[47] |= (source[63] & 0xffffffffffffull) << 0;
  }
  static inline
  void unpack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] >> 16) & 0xffffffffffffull;
    destination[1]  = (source[0] << 32) & 0xffffffffffffull;
    destination[1] |= (source[1] >> 32) & 0xffffffffffffull;
    destination[2]  = (source[1] << 16) & 0xffffffffffffull;
    destination[2] |= (source[2] >> 48) & 0xffffffffffffull;
    destination[3]  = (source[2] >> 0) & 0xffffffffffffull;
    destination[4]  = (source[3] >> 16) & 0xffffffffffffull;
    destination[5]  = (source[3] << 32) & 0xffffffffffffull;
    destination[5] |= (source[4] >> 32) & 0xffffffffffffull;
    destination[6]  = (source[4] << 16) & 0xffffffffffffull;
    destination[6] |= (source[5] >> 48) & 0xffffffffffffull;
    destination[7]  = (source[5] >> 0) & 0xffffffffffffull;
    destination[8]  = (source[6] >> 16) & 0xffffffffffffull;
    destination[9]  = (source[6] << 32) & 0xffffffffffffull;
    destination[9] |= (source[7] >> 32) & 0xffffffffffffull;
    destination[10]  = (source[7] << 16) & 0xffffffffffffull;
    destination[10] |= (source[8] >> 48) & 0xffffffffffffull;
    destination[11]  = (source[8] >> 0) & 0xffffffffffffull;
    destination[12]  = (source[9] >> 16) & 0xffffffffffffull;
    destination[13]  = (source[9] << 32) & 0xffffffffffffull;
    destination[13] |= (source[10] >> 32) & 0xffffffffffffull;
    destination[14]  = (source[10] << 16) & 0xffffffffffffull;
    destination[14] |= (source[11] >> 48) & 0xffffffffffffull;
    destination[15]  = (source[11] >> 0) & 0xffffffffffffull;
    destination[16]  = (source[12] >> 16) & 0xffffffffffffull;
    destination[17]  = (source[12] << 32) & 0xffffffffffffull;
    destination[17] |= (source[13] >> 32) & 0xffffffffffffull;
    destination[18]  = (source[13] << 16) & 0xffffffffffffull;
    destination[18] |= (source[14] >> 48) & 0xffffffffffffull;
    destination[19]  = (source[14] >> 0) & 0xffffffffffffull;
    destination[20]  = (source[15] >> 16) & 0xffffffffffffull;
    destination[21]  = (source[15] << 32) & 0xffffffffffffull;
    destination[21] |= (source[16] >> 32) & 0xffffffffffffull;
    destination[22]  = (source[16] << 16) & 0xffffffffffffull;
    destination[22] |= (source[17] >> 48) & 0xffffffffffffull;
    destination[23]  = (source[17] >> 0) & 0xffffffffffffull;
    destination[24]  = (source[18] >> 16) & 0xffffffffffffull;
    destination[25]  = (source[18] << 32) & 0xffffffffffffull;
    destination[25] |= (source[19] >> 32) & 0xffffffffffffull;
    destination[26]  = (source[19] << 16) & 0xffffffffffffull;
    destination[26] |= (source[20] >> 48) & 0xffffffffffffull;
    destination[27]  = (source[20] >> 0) & 0xffffffffffffull;
    destination[28]  = (source[21] >> 16) & 0xffffffffffffull;
    destination[29]  = (source[21] << 32) & 0xffffffffffffull;
    destination[29] |= (source[22] >> 32) & 0xffffffffffffull;
    destination[30]  = (source[22] << 16) & 0xffffffffffffull;
    destination[30] |= (source[23] >> 48) & 0xffffffffffffull;
    destination[31]  = (source[23] >> 0) & 0xffffffffffffull;
    destination[32]  = (source[24] >> 16) & 0xffffffffffffull;
    destination[33]  = (source[24] << 32) & 0xffffffffffffull;
    destination[33] |= (source[25] >> 32) & 0xffffffffffffull;
    destination[34]  = (source[25] << 16) & 0xffffffffffffull;
    destination[34] |= (source[26] >> 48) & 0xffffffffffffull;
    destination[35]  = (source[26] >> 0) & 0xffffffffffffull;
    destination[36]  = (source[27] >> 16) & 0xffffffffffffull;
    destination[37]  = (source[27] << 32) & 0xffffffffffffull;
    destination[37] |= (source[28] >> 32) & 0xffffffffffffull;
    destination[38]  = (source[28] << 16) & 0xffffffffffffull;
    destination[38] |= (source[29] >> 48) & 0xffffffffffffull;
    destination[39]  = (source[29] >> 0) & 0xffffffffffffull;
    destination[40]  = (source[30] >> 16) & 0xffffffffffffull;
    destination[41]  = (source[30] << 32) & 0xffffffffffffull;
    destination[41] |= (source[31] >> 32) & 0xffffffffffffull;
    destination[42]  = (source[31] << 16) & 0xffffffffffffull;
    destination[42] |= (source[32] >> 48) & 0xffffffffffffull;
    destination[43]  = (source[32] >> 0) & 0xffffffffffffull;
    destination[44]  = (source[33] >> 16) & 0xffffffffffffull;
    destination[45]  = (source[33] << 32) & 0xffffffffffffull;
    destination[45] |= (source[34] >> 32) & 0xffffffffffffull;
    destination[46]  = (source[34] << 16) & 0xffffffffffffull;
    destination[46] |= (source[35] >> 48) & 0xffffffffffffull;
    destination[47]  = (source[35] >> 0) & 0xffffffffffffull;
    destination[48]  = (source[36] >> 16) & 0xffffffffffffull;
    destination[49]  = (source[36] << 32) & 0xffffffffffffull;
    destination[49] |= (source[37] >> 32) & 0xffffffffffffull;
    destination[50]  = (source[37] << 16) & 0xffffffffffffull;
    destination[50] |= (source[38] >> 48) & 0xffffffffffffull;
    destination[51]  = (source[38] >> 0) & 0xffffffffffffull;
    destination[52]  = (source[39] >> 16) & 0xffffffffffffull;
    destination[53]  = (source[39] << 32) & 0xffffffffffffull;
    destination[53] |= (source[40] >> 32) & 0xffffffffffffull;
    destination[54]  = (source[40] << 16) & 0xffffffffffffull;
    destination[54] |= (source[41] >> 48) & 0xffffffffffffull;
    destination[55]  = (source[41] >> 0) & 0xffffffffffffull;
    destination[56]  = (source[42] >> 16) & 0xffffffffffffull;
    destination[57]  = (source[42] << 32) & 0xffffffffffffull;
    destination[57] |= (source[43] >> 32) & 0xffffffffffffull;
    destination[58]  = (source[43] << 16) & 0xffffffffffffull;
    destination[58] |= (source[44] >> 48) & 0xffffffffffffull;
    destination[59]  = (source[44] >> 0) & 0xffffffffffffull;
    destination[60]  = (source[45] >> 16) & 0xffffffffffffull;
    destination[61]  = (source[45] << 32) & 0xffffffffffffull;
    destination[61] |= (source[46] >> 32) & 0xffffffffffffull;
    destination[62]  = (source[46] << 16) & 0xffffffffffffull;
    destination[62] |= (source[47] >> 48) & 0xffffffffffffull;
    destination[63]  = (source[47] >> 0) & 0xffffffffffffull;
  }
};
template <typename Tp>
struct __struct_bitpack_impl<Tp,8,49>
{
  static const size_t unit_size = 64;
  static const size_t bits_total = 3136;
  static const size_t loop_total = 64;
  static const size_t bit_size = 49;
  static const Tp     mask = 0x1ffffffffffffull;
  static inline
  void pack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] & 0x1ffffffffffffull) << 15;
    destination[0] |= (source[1] & 0x1ffffffffffffull) >> 34;
    destination[1]  = (source[1] & 0x1ffffffffffffull) << 30;
    destination[1] |= (source[2] & 0x1ffffffffffffull) >> 19;
    destination[2]  = (source[2] & 0x1ffffffffffffull) << 45;
    destination[2] |= (source[3] & 0x1ffffffffffffull) >> 4;
    destination[3]  = (source[3] & 0x1ffffffffffffull) << 60;
    destination[3] |= (source[4] & 0x1ffffffffffffull) << 11;
    destination[3] |= (source[5] & 0x1ffffffffffffull) >> 38;
    destination[4]  = (source[5] & 0x1ffffffffffffull) << 26;
    destination[4] |= (source[6] & 0x1ffffffffffffull) >> 23;
    destination[5]  = (source[6] & 0x1ffffffffffffull) << 41;
    destination[5] |= (source[7] & 0x1ffffffffffffull) >> 8;
    destination[6]  = (source[7] & 0x1ffffffffffffull) << 56;
    destination[6] |= (source[8] & 0x1ffffffffffffull) << 7;
    destination[6] |= (source[9] & 0x1ffffffffffffull) >> 42;
    destination[7]  = (source[9] & 0x1ffffffffffffull) << 22;
    destination[7] |= (source[10] & 0x1ffffffffffffull) >> 27;
    destination[8]  = (source[10] & 0x1ffffffffffffull) << 37;
    destination[8] |= (source[11] & 0x1ffffffffffffull) >> 12;
    destination[9]  = (source[11] & 0x1ffffffffffffull) << 52;
    destination[9] |= (source[12] & 0x1ffffffffffffull) << 3;
    destination[9] |= (source[13] & 0x1ffffffffffffull) >> 46;
    destination[10]  = (source[13] & 0x1ffffffffffffull) << 18;
    destination[10] |= (source[14] & 0x1ffffffffffffull) >> 31;
    destination[11]  = (source[14] & 0x1ffffffffffffull) << 33;
    destination[11] |= (source[15] & 0x1ffffffffffffull) >> 16;
    destination[12]  = (source[15] & 0x1ffffffffffffull) << 48;
    destination[12] |= (source[16] & 0x1ffffffffffffull) >> 1;
    destination[13]  = (source[16] & 0x1ffffffffffffull) << 63;
    destination[13] |= (source[17] & 0x1ffffffffffffull) << 14;
    destination[13] |= (source[18] & 0x1ffffffffffffull) >> 35;
    destination[14]  = (source[18] & 0x1ffffffffffffull) << 29;
    destination[14] |= (source[19] & 0x1ffffffffffffull) >> 20;
    destination[15]  = (source[19] & 0x1ffffffffffffull) << 44;
    destination[15] |= (source[20] & 0x1ffffffffffffull) >> 5;
    destination[16]  = (source[20] & 0x1ffffffffffffull) << 59;
    destination[16] |= (source[21] & 0x1ffffffffffffull) << 10;
    destination[16] |= (source[22] & 0x1ffffffffffffull) >> 39;
    destination[17]  = (source[22] & 0x1ffffffffffffull) << 25;
    destination[17] |= (source[23] & 0x1ffffffffffffull) >> 24;
    destination[18]  = (source[23] & 0x1ffffffffffffull) << 40;
    destination[18] |= (source[24] & 0x1ffffffffffffull) >> 9;
    destination[19]  = (source[24] & 0x1ffffffffffffull) << 55;
    destination[19] |= (source[25] & 0x1ffffffffffffull) << 6;
    destination[19] |= (source[26] & 0x1ffffffffffffull) >> 43;
    destination[20]  = (source[26] & 0x1ffffffffffffull) << 21;
    destination[20] |= (source[27] & 0x1ffffffffffffull) >> 28;
    destination[21]  = (source[27] & 0x1ffffffffffffull) << 36;
    destination[21] |= (source[28] & 0x1ffffffffffffull) >> 13;
    destination[22]  = (source[28] & 0x1ffffffffffffull) << 51;
    destination[22] |= (source[29] & 0x1ffffffffffffull) << 2;
    destination[22] |= (source[30] & 0x1ffffffffffffull) >> 47;
    destination[23]  = (source[30] & 0x1ffffffffffffull) << 17;
    destination[23] |= (source[31] & 0x1ffffffffffffull) >> 32;
    destination[24]  = (source[31] & 0x1ffffffffffffull) << 32;
    destination[24] |= (source[32] & 0x1ffffffffffffull) >> 17;
    destination[25]  = (source[32] & 0x1ffffffffffffull) << 47;
    destination[25] |= (source[33] & 0x1ffffffffffffull) >> 2;
    destination[26]  = (source[33] & 0x1ffffffffffffull) << 62;
    destination[26] |= (source[34] & 0x1ffffffffffffull) << 13;
    destination[26] |= (source[35] & 0x1ffffffffffffull) >> 36;
    destination[27]  = (source[35] & 0x1ffffffffffffull) << 28;
    destination[27] |= (source[36] & 0x1ffffffffffffull) >> 21;
    destination[28]  = (source[36] & 0x1ffffffffffffull) << 43;
    destination[28] |= (source[37] & 0x1ffffffffffffull) >> 6;
    destination[29]  = (source[37] & 0x1ffffffffffffull) << 58;
    destination[29] |= (source[38] & 0x1ffffffffffffull) << 9;
    destination[29] |= (source[39] & 0x1ffffffffffffull) >> 40;
    destination[30]  = (source[39] & 0x1ffffffffffffull) << 24;
    destination[30] |= (source[40] & 0x1ffffffffffffull) >> 25;
    destination[31]  = (source[40] & 0x1ffffffffffffull) << 39;
    destination[31] |= (source[41] & 0x1ffffffffffffull) >> 10;
    destination[32]  = (source[41] & 0x1ffffffffffffull) << 54;
    destination[32] |= (source[42] & 0x1ffffffffffffull) << 5;
    destination[32] |= (source[43] & 0x1ffffffffffffull) >> 44;
    destination[33]  = (source[43] & 0x1ffffffffffffull) << 20;
    destination[33] |= (source[44] & 0x1ffffffffffffull) >> 29;
    destination[34]  = (source[44] & 0x1ffffffffffffull) << 35;
    destination[34] |= (source[45] & 0x1ffffffffffffull) >> 14;
    destination[35]  = (source[45] & 0x1ffffffffffffull) << 50;
    destination[35] |= (source[46] & 0x1ffffffffffffull) << 1;
    destination[35] |= (source[47] & 0x1ffffffffffffull) >> 48;
    destination[36]  = (source[47] & 0x1ffffffffffffull) << 16;
    destination[36] |= (source[48] & 0x1ffffffffffffull) >> 33;
    destination[37]  = (source[48] & 0x1ffffffffffffull) << 31;
    destination[37] |= (source[49] & 0x1ffffffffffffull) >> 18;
    destination[38]  = (source[49] & 0x1ffffffffffffull) << 46;
    destination[38] |= (source[50] & 0x1ffffffffffffull) >> 3;
    destination[39]  = (source[50] & 0x1ffffffffffffull) << 61;
    destination[39] |= (source[51] & 0x1ffffffffffffull) << 12;
    destination[39] |= (source[52] & 0x1ffffffffffffull) >> 37;
    destination[40]  = (source[52] & 0x1ffffffffffffull) << 27;
    destination[40] |= (source[53] & 0x1ffffffffffffull) >> 22;
    destination[41]  = (source[53] & 0x1ffffffffffffull) << 42;
    destination[41] |= (source[54] & 0x1ffffffffffffull) >> 7;
    destination[42]  = (source[54] & 0x1ffffffffffffull) << 57;
    destination[42] |= (source[55] & 0x1ffffffffffffull) << 8;
    destination[42] |= (source[56] & 0x1ffffffffffffull) >> 41;
    destination[43]  = (source[56] & 0x1ffffffffffffull) << 23;
    destination[43] |= (source[57] & 0x1ffffffffffffull) >> 26;
    destination[44]  = (source[57] & 0x1ffffffffffffull) << 38;
    destination[44] |= (source[58] & 0x1ffffffffffffull) >> 11;
    destination[45]  = (source[58] & 0x1ffffffffffffull) << 53;
    destination[45] |= (source[59] & 0x1ffffffffffffull) << 4;
    destination[45] |= (source[60] & 0x1ffffffffffffull) >> 45;
    destination[46]  = (source[60] & 0x1ffffffffffffull) << 19;
    destination[46] |= (source[61] & 0x1ffffffffffffull) >> 30;
    destination[47]  = (source[61] & 0x1ffffffffffffull) << 34;
    destination[47] |= (source[62] & 0x1ffffffffffffull) >> 15;
    destination[48]  = (source[62] & 0x1ffffffffffffull) << 49;
    destination[48] |= (source[63] & 0x1ffffffffffffull) << 0;
  }
  static inline
  void unpack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] >> 15) & 0x1ffffffffffffull;
    destination[1]  = (source[0] << 34) & 0x1ffffffffffffull;
    destination[1] |= (source[1] >> 30) & 0x1ffffffffffffull;
    destination[2]  = (source[1] << 19) & 0x1ffffffffffffull;
    destination[2] |= (source[2] >> 45) & 0x1ffffffffffffull;
    destination[3]  = (source[2] << 4) & 0x1ffffffffffffull;
    destination[3] |= (source[3] >> 60) & 0x1ffffffffffffull;
    destination[4]  = (source[3] >> 11) & 0x1ffffffffffffull;
    destination[5]  = (source[3] << 38) & 0x1ffffffffffffull;
    destination[5] |= (source[4] >> 26) & 0x1ffffffffffffull;
    destination[6]  = (source[4] << 23) & 0x1ffffffffffffull;
    destination[6] |= (source[5] >> 41) & 0x1ffffffffffffull;
    destination[7]  = (source[5] << 8) & 0x1ffffffffffffull;
    destination[7] |= (source[6] >> 56) & 0x1ffffffffffffull;
    destination[8]  = (source[6] >> 7) & 0x1ffffffffffffull;
    destination[9]  = (source[6] << 42) & 0x1ffffffffffffull;
    destination[9] |= (source[7] >> 22) & 0x1ffffffffffffull;
    destination[10]  = (source[7] << 27) & 0x1ffffffffffffull;
    destination[10] |= (source[8] >> 37) & 0x1ffffffffffffull;
    destination[11]  = (source[8] << 12) & 0x1ffffffffffffull;
    destination[11] |= (source[9] >> 52) & 0x1ffffffffffffull;
    destination[12]  = (source[9] >> 3) & 0x1ffffffffffffull;
    destination[13]  = (source[9] << 46) & 0x1ffffffffffffull;
    destination[13] |= (source[10] >> 18) & 0x1ffffffffffffull;
    destination[14]  = (source[10] << 31) & 0x1ffffffffffffull;
    destination[14] |= (source[11] >> 33) & 0x1ffffffffffffull;
    destination[15]  = (source[11] << 16) & 0x1ffffffffffffull;
    destination[15] |= (source[12] >> 48) & 0x1ffffffffffffull;
    destination[16]  = (source[12] << 1) & 0x1ffffffffffffull;
    destination[16] |= (source[13] >> 63) & 0x1ffffffffffffull;
    destination[17]  = (source[13] >> 14) & 0x1ffffffffffffull;
    destination[18]  = (source[13] << 35) & 0x1ffffffffffffull;
    destination[18] |= (source[14] >> 29) & 0x1ffffffffffffull;
    destination[19]  = (source[14] << 20) & 0x1ffffffffffffull;
    destination[19] |= (source[15] >> 44) & 0x1ffffffffffffull;
    destination[20]  = (source[15] << 5) & 0x1ffffffffffffull;
    destination[20] |= (source[16] >> 59) & 0x1ffffffffffffull;
    destination[21]  = (source[16] >> 10) & 0x1ffffffffffffull;
    destination[22]  = (source[16] << 39) & 0x1ffffffffffffull;
    destination[22] |= (source[17] >> 25) & 0x1ffffffffffffull;
    destination[23]  = (source[17] << 24) & 0x1ffffffffffffull;
    destination[23] |= (source[18] >> 40) & 0x1ffffffffffffull;
    destination[24]  = (source[18] << 9) & 0x1ffffffffffffull;
    destination[24] |= (source[19] >> 55) & 0x1ffffffffffffull;
    destination[25]  = (source[19] >> 6) & 0x1ffffffffffffull;
    destination[26]  = (source[19] << 43) & 0x1ffffffffffffull;
    destination[26] |= (source[20] >> 21) & 0x1ffffffffffffull;
    destination[27]  = (source[20] << 28) & 0x1ffffffffffffull;
    destination[27] |= (source[21] >> 36) & 0x1ffffffffffffull;
    destination[28]  = (source[21] << 13) & 0x1ffffffffffffull;
    destination[28] |= (source[22] >> 51) & 0x1ffffffffffffull;
    destination[29]  = (source[22] >> 2) & 0x1ffffffffffffull;
    destination[30]  = (source[22] << 47) & 0x1ffffffffffffull;
    destination[30] |= (source[23] >> 17) & 0x1ffffffffffffull;
    destination[31]  = (source[23] << 32) & 0x1ffffffffffffull;
    destination[31] |= (source[24] >> 32) & 0x1ffffffffffffull;
    destination[32]  = (source[24] << 17) & 0x1ffffffffffffull;
    destination[32] |= (source[25] >> 47) & 0x1ffffffffffffull;
    destination[33]  = (source[25] << 2) & 0x1ffffffffffffull;
    destination[33] |= (source[26] >> 62) & 0x1ffffffffffffull;
    destination[34]  = (source[26] >> 13) & 0x1ffffffffffffull;
    destination[35]  = (source[26] << 36) & 0x1ffffffffffffull;
    destination[35] |= (source[27] >> 28) & 0x1ffffffffffffull;
    destination[36]  = (source[27] << 21) & 0x1ffffffffffffull;
    destination[36] |= (source[28] >> 43) & 0x1ffffffffffffull;
    destination[37]  = (source[28] << 6) & 0x1ffffffffffffull;
    destination[37] |= (source[29] >> 58) & 0x1ffffffffffffull;
    destination[38]  = (source[29] >> 9) & 0x1ffffffffffffull;
    destination[39]  = (source[29] << 40) & 0x1ffffffffffffull;
    destination[39] |= (source[30] >> 24) & 0x1ffffffffffffull;
    destination[40]  = (source[30] << 25) & 0x1ffffffffffffull;
    destination[40] |= (source[31] >> 39) & 0x1ffffffffffffull;
    destination[41]  = (source[31] << 10) & 0x1ffffffffffffull;
    destination[41] |= (source[32] >> 54) & 0x1ffffffffffffull;
    destination[42]  = (source[32] >> 5) & 0x1ffffffffffffull;
    destination[43]  = (source[32] << 44) & 0x1ffffffffffffull;
    destination[43] |= (source[33] >> 20) & 0x1ffffffffffffull;
    destination[44]  = (source[33] << 29) & 0x1ffffffffffffull;
    destination[44] |= (source[34] >> 35) & 0x1ffffffffffffull;
    destination[45]  = (source[34] << 14) & 0x1ffffffffffffull;
    destination[45] |= (source[35] >> 50) & 0x1ffffffffffffull;
    destination[46]  = (source[35] >> 1) & 0x1ffffffffffffull;
    destination[47]  = (source[35] << 48) & 0x1ffffffffffffull;
    destination[47] |= (source[36] >> 16) & 0x1ffffffffffffull;
    destination[48]  = (source[36] << 33) & 0x1ffffffffffffull;
    destination[48] |= (source[37] >> 31) & 0x1ffffffffffffull;
    destination[49]  = (source[37] << 18) & 0x1ffffffffffffull;
    destination[49] |= (source[38] >> 46) & 0x1ffffffffffffull;
    destination[50]  = (source[38] << 3) & 0x1ffffffffffffull;
    destination[50] |= (source[39] >> 61) & 0x1ffffffffffffull;
    destination[51]  = (source[39] >> 12) & 0x1ffffffffffffull;
    destination[52]  = (source[39] << 37) & 0x1ffffffffffffull;
    destination[52] |= (source[40] >> 27) & 0x1ffffffffffffull;
    destination[53]  = (source[40] << 22) & 0x1ffffffffffffull;
    destination[53] |= (source[41] >> 42) & 0x1ffffffffffffull;
    destination[54]  = (source[41] << 7) & 0x1ffffffffffffull;
    destination[54] |= (source[42] >> 57) & 0x1ffffffffffffull;
    destination[55]  = (source[42] >> 8) & 0x1ffffffffffffull;
    destination[56]  = (source[42] << 41) & 0x1ffffffffffffull;
    destination[56] |= (source[43] >> 23) & 0x1ffffffffffffull;
    destination[57]  = (source[43] << 26) & 0x1ffffffffffffull;
    destination[57] |= (source[44] >> 38) & 0x1ffffffffffffull;
    destination[58]  = (source[44] << 11) & 0x1ffffffffffffull;
    destination[58] |= (source[45] >> 53) & 0x1ffffffffffffull;
    destination[59]  = (source[45] >> 4) & 0x1ffffffffffffull;
    destination[60]  = (source[45] << 45) & 0x1ffffffffffffull;
    destination[60] |= (source[46] >> 19) & 0x1ffffffffffffull;
    destination[61]  = (source[46] << 30) & 0x1ffffffffffffull;
    destination[61] |= (source[47] >> 34) & 0x1ffffffffffffull;
    destination[62]  = (source[47] << 15) & 0x1ffffffffffffull;
    destination[62] |= (source[48] >> 49) & 0x1ffffffffffffull;
    destination[63]  = (source[48] >> 0) & 0x1ffffffffffffull;
  }
};
template <typename Tp>
struct __struct_bitpack_impl<Tp,8,50>
{
  static const size_t unit_size = 64;
  static const size_t bits_total = 3200;
  static const size_t loop_total = 64;
  static const size_t bit_size = 50;
  static const Tp     mask = 0x3ffffffffffffull;
  static inline
  void pack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] & 0x3ffffffffffffull) << 14;
    destination[0] |= (source[1] & 0x3ffffffffffffull) >> 36;
    destination[1]  = (source[1] & 0x3ffffffffffffull) << 28;
    destination[1] |= (source[2] & 0x3ffffffffffffull) >> 22;
    destination[2]  = (source[2] & 0x3ffffffffffffull) << 42;
    destination[2] |= (source[3] & 0x3ffffffffffffull) >> 8;
    destination[3]  = (source[3] & 0x3ffffffffffffull) << 56;
    destination[3] |= (source[4] & 0x3ffffffffffffull) << 6;
    destination[3] |= (source[5] & 0x3ffffffffffffull) >> 44;
    destination[4]  = (source[5] & 0x3ffffffffffffull) << 20;
    destination[4] |= (source[6] & 0x3ffffffffffffull) >> 30;
    destination[5]  = (source[6] & 0x3ffffffffffffull) << 34;
    destination[5] |= (source[7] & 0x3ffffffffffffull) >> 16;
    destination[6]  = (source[7] & 0x3ffffffffffffull) << 48;
    destination[6] |= (source[8] & 0x3ffffffffffffull) >> 2;
    destination[7]  = (source[8] & 0x3ffffffffffffull) << 62;
    destination[7] |= (source[9] & 0x3ffffffffffffull) << 12;
    destination[7] |= (source[10] & 0x3ffffffffffffull) >> 38;
    destination[8]  = (source[10] & 0x3ffffffffffffull) << 26;
    destination[8] |= (source[11] & 0x3ffffffffffffull) >> 24;
    destination[9]  = (source[11] & 0x3ffffffffffffull) << 40;
    destination[9] |= (source[12] & 0x3ffffffffffffull) >> 10;
    destination[10]  = (source[12] & 0x3ffffffffffffull) << 54;
    destination[10] |= (source[13] & 0x3ffffffffffffull) << 4;
    destination[10] |= (source[14] & 0x3ffffffffffffull) >> 46;
    destination[11]  = (source[14] & 0x3ffffffffffffull) << 18;
    destination[11] |= (source[15] & 0x3ffffffffffffull) >> 32;
    destination[12]  = (source[15] & 0x3ffffffffffffull) << 32;
    destination[12] |= (source[16] & 0x3ffffffffffffull) >> 18;
    destination[13]  = (source[16] & 0x3ffffffffffffull) << 46;
    destination[13] |= (source[17] & 0x3ffffffffffffull) >> 4;
    destination[14]  = (source[17] & 0x3ffffffffffffull) << 60;
    destination[14] |= (source[18] & 0x3ffffffffffffull) << 10;
    destination[14] |= (source[19] & 0x3ffffffffffffull) >> 40;
    destination[15]  = (source[19] & 0x3ffffffffffffull) << 24;
    destination[15] |= (source[20] & 0x3ffffffffffffull) >> 26;
    destination[16]  = (source[20] & 0x3ffffffffffffull) << 38;
    destination[16] |= (source[21] & 0x3ffffffffffffull) >> 12;
    destination[17]  = (source[21] & 0x3ffffffffffffull) << 52;
    destination[17] |= (source[22] & 0x3ffffffffffffull) << 2;
    destination[17] |= (source[23] & 0x3ffffffffffffull) >> 48;
    destination[18]  = (source[23] & 0x3ffffffffffffull) << 16;
    destination[18] |= (source[24] & 0x3ffffffffffffull) >> 34;
    destination[19]  = (source[24] & 0x3ffffffffffffull) << 30;
    destination[19] |= (source[25] & 0x3ffffffffffffull) >> 20;
    destination[20]  = (source[25] & 0x3ffffffffffffull) << 44;
    destination[20] |= (source[26] & 0x3ffffffffffffull) >> 6;
    destination[21]  = (source[26] & 0x3ffffffffffffull) << 58;
    destination[21] |= (source[27] & 0x3ffffffffffffull) << 8;
    destination[21] |= (source[28] & 0x3ffffffffffffull) >> 42;
    destination[22]  = (source[28] & 0x3ffffffffffffull) << 22;
    destination[22] |= (source[29] & 0x3ffffffffffffull) >> 28;
    destination[23]  = (source[29] & 0x3ffffffffffffull) << 36;
    destination[23] |= (source[30] & 0x3ffffffffffffull) >> 14;
    destination[24]  = (source[30] & 0x3ffffffffffffull) << 50;
    destination[24] |= (source[31] & 0x3ffffffffffffull) << 0;
    destination[25]  = (source[32] & 0x3ffffffffffffull) << 14;
    destination[25] |= (source[33] & 0x3ffffffffffffull) >> 36;
    destination[26]  = (source[33] & 0x3ffffffffffffull) << 28;
    destination[26] |= (source[34] & 0x3ffffffffffffull) >> 22;
    destination[27]  = (source[34] & 0x3ffffffffffffull) << 42;
    destination[27] |= (source[35] & 0x3ffffffffffffull) >> 8;
    destination[28]  = (source[35] & 0x3ffffffffffffull) << 56;
    destination[28] |= (source[36] & 0x3ffffffffffffull) << 6;
    destination[28] |= (source[37] & 0x3ffffffffffffull) >> 44;
    destination[29]  = (source[37] & 0x3ffffffffffffull) << 20;
    destination[29] |= (source[38] & 0x3ffffffffffffull) >> 30;
    destination[30]  = (source[38] & 0x3ffffffffffffull) << 34;
    destination[30] |= (source[39] & 0x3ffffffffffffull) >> 16;
    destination[31]  = (source[39] & 0x3ffffffffffffull) << 48;
    destination[31] |= (source[40] & 0x3ffffffffffffull) >> 2;
    destination[32]  = (source[40] & 0x3ffffffffffffull) << 62;
    destination[32] |= (source[41] & 0x3ffffffffffffull) << 12;
    destination[32] |= (source[42] & 0x3ffffffffffffull) >> 38;
    destination[33]  = (source[42] & 0x3ffffffffffffull) << 26;
    destination[33] |= (source[43] & 0x3ffffffffffffull) >> 24;
    destination[34]  = (source[43] & 0x3ffffffffffffull) << 40;
    destination[34] |= (source[44] & 0x3ffffffffffffull) >> 10;
    destination[35]  = (source[44] & 0x3ffffffffffffull) << 54;
    destination[35] |= (source[45] & 0x3ffffffffffffull) << 4;
    destination[35] |= (source[46] & 0x3ffffffffffffull) >> 46;
    destination[36]  = (source[46] & 0x3ffffffffffffull) << 18;
    destination[36] |= (source[47] & 0x3ffffffffffffull) >> 32;
    destination[37]  = (source[47] & 0x3ffffffffffffull) << 32;
    destination[37] |= (source[48] & 0x3ffffffffffffull) >> 18;
    destination[38]  = (source[48] & 0x3ffffffffffffull) << 46;
    destination[38] |= (source[49] & 0x3ffffffffffffull) >> 4;
    destination[39]  = (source[49] & 0x3ffffffffffffull) << 60;
    destination[39] |= (source[50] & 0x3ffffffffffffull) << 10;
    destination[39] |= (source[51] & 0x3ffffffffffffull) >> 40;
    destination[40]  = (source[51] & 0x3ffffffffffffull) << 24;
    destination[40] |= (source[52] & 0x3ffffffffffffull) >> 26;
    destination[41]  = (source[52] & 0x3ffffffffffffull) << 38;
    destination[41] |= (source[53] & 0x3ffffffffffffull) >> 12;
    destination[42]  = (source[53] & 0x3ffffffffffffull) << 52;
    destination[42] |= (source[54] & 0x3ffffffffffffull) << 2;
    destination[42] |= (source[55] & 0x3ffffffffffffull) >> 48;
    destination[43]  = (source[55] & 0x3ffffffffffffull) << 16;
    destination[43] |= (source[56] & 0x3ffffffffffffull) >> 34;
    destination[44]  = (source[56] & 0x3ffffffffffffull) << 30;
    destination[44] |= (source[57] & 0x3ffffffffffffull) >> 20;
    destination[45]  = (source[57] & 0x3ffffffffffffull) << 44;
    destination[45] |= (source[58] & 0x3ffffffffffffull) >> 6;
    destination[46]  = (source[58] & 0x3ffffffffffffull) << 58;
    destination[46] |= (source[59] & 0x3ffffffffffffull) << 8;
    destination[46] |= (source[60] & 0x3ffffffffffffull) >> 42;
    destination[47]  = (source[60] & 0x3ffffffffffffull) << 22;
    destination[47] |= (source[61] & 0x3ffffffffffffull) >> 28;
    destination[48]  = (source[61] & 0x3ffffffffffffull) << 36;
    destination[48] |= (source[62] & 0x3ffffffffffffull) >> 14;
    destination[49]  = (source[62] & 0x3ffffffffffffull) << 50;
    destination[49] |= (source[63] & 0x3ffffffffffffull) << 0;
  }
  static inline
  void unpack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] >> 14) & 0x3ffffffffffffull;
    destination[1]  = (source[0] << 36) & 0x3ffffffffffffull;
    destination[1] |= (source[1] >> 28) & 0x3ffffffffffffull;
    destination[2]  = (source[1] << 22) & 0x3ffffffffffffull;
    destination[2] |= (source[2] >> 42) & 0x3ffffffffffffull;
    destination[3]  = (source[2] << 8) & 0x3ffffffffffffull;
    destination[3] |= (source[3] >> 56) & 0x3ffffffffffffull;
    destination[4]  = (source[3] >> 6) & 0x3ffffffffffffull;
    destination[5]  = (source[3] << 44) & 0x3ffffffffffffull;
    destination[5] |= (source[4] >> 20) & 0x3ffffffffffffull;
    destination[6]  = (source[4] << 30) & 0x3ffffffffffffull;
    destination[6] |= (source[5] >> 34) & 0x3ffffffffffffull;
    destination[7]  = (source[5] << 16) & 0x3ffffffffffffull;
    destination[7] |= (source[6] >> 48) & 0x3ffffffffffffull;
    destination[8]  = (source[6] << 2) & 0x3ffffffffffffull;
    destination[8] |= (source[7] >> 62) & 0x3ffffffffffffull;
    destination[9]  = (source[7] >> 12) & 0x3ffffffffffffull;
    destination[10]  = (source[7] << 38) & 0x3ffffffffffffull;
    destination[10] |= (source[8] >> 26) & 0x3ffffffffffffull;
    destination[11]  = (source[8] << 24) & 0x3ffffffffffffull;
    destination[11] |= (source[9] >> 40) & 0x3ffffffffffffull;
    destination[12]  = (source[9] << 10) & 0x3ffffffffffffull;
    destination[12] |= (source[10] >> 54) & 0x3ffffffffffffull;
    destination[13]  = (source[10] >> 4) & 0x3ffffffffffffull;
    destination[14]  = (source[10] << 46) & 0x3ffffffffffffull;
    destination[14] |= (source[11] >> 18) & 0x3ffffffffffffull;
    destination[15]  = (source[11] << 32) & 0x3ffffffffffffull;
    destination[15] |= (source[12] >> 32) & 0x3ffffffffffffull;
    destination[16]  = (source[12] << 18) & 0x3ffffffffffffull;
    destination[16] |= (source[13] >> 46) & 0x3ffffffffffffull;
    destination[17]  = (source[13] << 4) & 0x3ffffffffffffull;
    destination[17] |= (source[14] >> 60) & 0x3ffffffffffffull;
    destination[18]  = (source[14] >> 10) & 0x3ffffffffffffull;
    destination[19]  = (source[14] << 40) & 0x3ffffffffffffull;
    destination[19] |= (source[15] >> 24) & 0x3ffffffffffffull;
    destination[20]  = (source[15] << 26) & 0x3ffffffffffffull;
    destination[20] |= (source[16] >> 38) & 0x3ffffffffffffull;
    destination[21]  = (source[16] << 12) & 0x3ffffffffffffull;
    destination[21] |= (source[17] >> 52) & 0x3ffffffffffffull;
    destination[22]  = (source[17] >> 2) & 0x3ffffffffffffull;
    destination[23]  = (source[17] << 48) & 0x3ffffffffffffull;
    destination[23] |= (source[18] >> 16) & 0x3ffffffffffffull;
    destination[24]  = (source[18] << 34) & 0x3ffffffffffffull;
    destination[24] |= (source[19] >> 30) & 0x3ffffffffffffull;
    destination[25]  = (source[19] << 20) & 0x3ffffffffffffull;
    destination[25] |= (source[20] >> 44) & 0x3ffffffffffffull;
    destination[26]  = (source[20] << 6) & 0x3ffffffffffffull;
    destination[26] |= (source[21] >> 58) & 0x3ffffffffffffull;
    destination[27]  = (source[21] >> 8) & 0x3ffffffffffffull;
    destination[28]  = (source[21] << 42) & 0x3ffffffffffffull;
    destination[28] |= (source[22] >> 22) & 0x3ffffffffffffull;
    destination[29]  = (source[22] << 28) & 0x3ffffffffffffull;
    destination[29] |= (source[23] >> 36) & 0x3ffffffffffffull;
    destination[30]  = (source[23] << 14) & 0x3ffffffffffffull;
    destination[30] |= (source[24] >> 50) & 0x3ffffffffffffull;
    destination[31]  = (source[24] >> 0) & 0x3ffffffffffffull;
    destination[32]  = (source[25] >> 14) & 0x3ffffffffffffull;
    destination[33]  = (source[25] << 36) & 0x3ffffffffffffull;
    destination[33] |= (source[26] >> 28) & 0x3ffffffffffffull;
    destination[34]  = (source[26] << 22) & 0x3ffffffffffffull;
    destination[34] |= (source[27] >> 42) & 0x3ffffffffffffull;
    destination[35]  = (source[27] << 8) & 0x3ffffffffffffull;
    destination[35] |= (source[28] >> 56) & 0x3ffffffffffffull;
    destination[36]  = (source[28] >> 6) & 0x3ffffffffffffull;
    destination[37]  = (source[28] << 44) & 0x3ffffffffffffull;
    destination[37] |= (source[29] >> 20) & 0x3ffffffffffffull;
    destination[38]  = (source[29] << 30) & 0x3ffffffffffffull;
    destination[38] |= (source[30] >> 34) & 0x3ffffffffffffull;
    destination[39]  = (source[30] << 16) & 0x3ffffffffffffull;
    destination[39] |= (source[31] >> 48) & 0x3ffffffffffffull;
    destination[40]  = (source[31] << 2) & 0x3ffffffffffffull;
    destination[40] |= (source[32] >> 62) & 0x3ffffffffffffull;
    destination[41]  = (source[32] >> 12) & 0x3ffffffffffffull;
    destination[42]  = (source[32] << 38) & 0x3ffffffffffffull;
    destination[42] |= (source[33] >> 26) & 0x3ffffffffffffull;
    destination[43]  = (source[33] << 24) & 0x3ffffffffffffull;
    destination[43] |= (source[34] >> 40) & 0x3ffffffffffffull;
    destination[44]  = (source[34] << 10) & 0x3ffffffffffffull;
    destination[44] |= (source[35] >> 54) & 0x3ffffffffffffull;
    destination[45]  = (source[35] >> 4) & 0x3ffffffffffffull;
    destination[46]  = (source[35] << 46) & 0x3ffffffffffffull;
    destination[46] |= (source[36] >> 18) & 0x3ffffffffffffull;
    destination[47]  = (source[36] << 32) & 0x3ffffffffffffull;
    destination[47] |= (source[37] >> 32) & 0x3ffffffffffffull;
    destination[48]  = (source[37] << 18) & 0x3ffffffffffffull;
    destination[48] |= (source[38] >> 46) & 0x3ffffffffffffull;
    destination[49]  = (source[38] << 4) & 0x3ffffffffffffull;
    destination[49] |= (source[39] >> 60) & 0x3ffffffffffffull;
    destination[50]  = (source[39] >> 10) & 0x3ffffffffffffull;
    destination[51]  = (source[39] << 40) & 0x3ffffffffffffull;
    destination[51] |= (source[40] >> 24) & 0x3ffffffffffffull;
    destination[52]  = (source[40] << 26) & 0x3ffffffffffffull;
    destination[52] |= (source[41] >> 38) & 0x3ffffffffffffull;
    destination[53]  = (source[41] << 12) & 0x3ffffffffffffull;
    destination[53] |= (source[42] >> 52) & 0x3ffffffffffffull;
    destination[54]  = (source[42] >> 2) & 0x3ffffffffffffull;
    destination[55]  = (source[42] << 48) & 0x3ffffffffffffull;
    destination[55] |= (source[43] >> 16) & 0x3ffffffffffffull;
    destination[56]  = (source[43] << 34) & 0x3ffffffffffffull;
    destination[56] |= (source[44] >> 30) & 0x3ffffffffffffull;
    destination[57]  = (source[44] << 20) & 0x3ffffffffffffull;
    destination[57] |= (source[45] >> 44) & 0x3ffffffffffffull;
    destination[58]  = (source[45] << 6) & 0x3ffffffffffffull;
    destination[58] |= (source[46] >> 58) & 0x3ffffffffffffull;
    destination[59]  = (source[46] >> 8) & 0x3ffffffffffffull;
    destination[60]  = (source[46] << 42) & 0x3ffffffffffffull;
    destination[60] |= (source[47] >> 22) & 0x3ffffffffffffull;
    destination[61]  = (source[47] << 28) & 0x3ffffffffffffull;
    destination[61] |= (source[48] >> 36) & 0x3ffffffffffffull;
    destination[62]  = (source[48] << 14) & 0x3ffffffffffffull;
    destination[62] |= (source[49] >> 50) & 0x3ffffffffffffull;
    destination[63]  = (source[49] >> 0) & 0x3ffffffffffffull;
  }
};
template <typename Tp>
struct __struct_bitpack_impl<Tp,8,51>
{
  static const size_t unit_size = 64;
  static const size_t bits_total = 3264;
  static const size_t loop_total = 64;
  static const size_t bit_size = 51;
  static const Tp     mask = 0x7ffffffffffffull;
  static inline
  void pack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] & 0x7ffffffffffffull) << 13;
    destination[0] |= (source[1] & 0x7ffffffffffffull) >> 38;
    destination[1]  = (source[1] & 0x7ffffffffffffull) << 26;
    destination[1] |= (source[2] & 0x7ffffffffffffull) >> 25;
    destination[2]  = (source[2] & 0x7ffffffffffffull) << 39;
    destination[2] |= (source[3] & 0x7ffffffffffffull) >> 12;
    destination[3]  = (source[3] & 0x7ffffffffffffull) << 52;
    destination[3] |= (source[4] & 0x7ffffffffffffull) << 1;
    destination[3] |= (source[5] & 0x7ffffffffffffull) >> 50;
    destination[4]  = (source[5] & 0x7ffffffffffffull) << 14;
    destination[4] |= (source[6] & 0x7ffffffffffffull) >> 37;
    destination[5]  = (source[6] & 0x7ffffffffffffull) << 27;
    destination[5] |= (source[7] & 0x7ffffffffffffull) >> 24;
    destination[6]  = (source[7] & 0x7ffffffffffffull) << 40;
    destination[6] |= (source[8] & 0x7ffffffffffffull) >> 11;
    destination[7]  = (source[8] & 0x7ffffffffffffull) << 53;
    destination[7] |= (source[9] & 0x7ffffffffffffull) << 2;
    destination[7] |= (source[10] & 0x7ffffffffffffull) >> 49;
    destination[8]  = (source[10] & 0x7ffffffffffffull) << 15;
    destination[8] |= (source[11] & 0x7ffffffffffffull) >> 36;
    destination[9]  = (source[11] & 0x7ffffffffffffull) << 28;
    destination[9] |= (source[12] & 0x7ffffffffffffull) >> 23;
    destination[10]  = (source[12] & 0x7ffffffffffffull) << 41;
    destination[10] |= (source[13] & 0x7ffffffffffffull) >> 10;
    destination[11]  = (source[13] & 0x7ffffffffffffull) << 54;
    destination[11] |= (source[14] & 0x7ffffffffffffull) << 3;
    destination[11] |= (source[15] & 0x7ffffffffffffull) >> 48;
    destination[12]  = (source[15] & 0x7ffffffffffffull) << 16;
    destination[12] |= (source[16] & 0x7ffffffffffffull) >> 35;
    destination[13]  = (source[16] & 0x7ffffffffffffull) << 29;
    destination[13] |= (source[17] & 0x7ffffffffffffull) >> 22;
    destination[14]  = (source[17] & 0x7ffffffffffffull) << 42;
    destination[14] |= (source[18] & 0x7ffffffffffffull) >> 9;
    destination[15]  = (source[18] & 0x7ffffffffffffull) << 55;
    destination[15] |= (source[19] & 0x7ffffffffffffull) << 4;
    destination[15] |= (source[20] & 0x7ffffffffffffull) >> 47;
    destination[16]  = (source[20] & 0x7ffffffffffffull) << 17;
    destination[16] |= (source[21] & 0x7ffffffffffffull) >> 34;
    destination[17]  = (source[21] & 0x7ffffffffffffull) << 30;
    destination[17] |= (source[22] & 0x7ffffffffffffull) >> 21;
    destination[18]  = (source[22] & 0x7ffffffffffffull) << 43;
    destination[18] |= (source[23] & 0x7ffffffffffffull) >> 8;
    destination[19]  = (source[23] & 0x7ffffffffffffull) << 56;
    destination[19] |= (source[24] & 0x7ffffffffffffull) << 5;
    destination[19] |= (source[25] & 0x7ffffffffffffull) >> 46;
    destination[20]  = (source[25] & 0x7ffffffffffffull) << 18;
    destination[20] |= (source[26] & 0x7ffffffffffffull) >> 33;
    destination[21]  = (source[26] & 0x7ffffffffffffull) << 31;
    destination[21] |= (source[27] & 0x7ffffffffffffull) >> 20;
    destination[22]  = (source[27] & 0x7ffffffffffffull) << 44;
    destination[22] |= (source[28] & 0x7ffffffffffffull) >> 7;
    destination[23]  = (source[28] & 0x7ffffffffffffull) << 57;
    destination[23] |= (source[29] & 0x7ffffffffffffull) << 6;
    destination[23] |= (source[30] & 0x7ffffffffffffull) >> 45;
    destination[24]  = (source[30] & 0x7ffffffffffffull) << 19;
    destination[24] |= (source[31] & 0x7ffffffffffffull) >> 32;
    destination[25]  = (source[31] & 0x7ffffffffffffull) << 32;
    destination[25] |= (source[32] & 0x7ffffffffffffull) >> 19;
    destination[26]  = (source[32] & 0x7ffffffffffffull) << 45;
    destination[26] |= (source[33] & 0x7ffffffffffffull) >> 6;
    destination[27]  = (source[33] & 0x7ffffffffffffull) << 58;
    destination[27] |= (source[34] & 0x7ffffffffffffull) << 7;
    destination[27] |= (source[35] & 0x7ffffffffffffull) >> 44;
    destination[28]  = (source[35] & 0x7ffffffffffffull) << 20;
    destination[28] |= (source[36] & 0x7ffffffffffffull) >> 31;
    destination[29]  = (source[36] & 0x7ffffffffffffull) << 33;
    destination[29] |= (source[37] & 0x7ffffffffffffull) >> 18;
    destination[30]  = (source[37] & 0x7ffffffffffffull) << 46;
    destination[30] |= (source[38] & 0x7ffffffffffffull) >> 5;
    destination[31]  = (source[38] & 0x7ffffffffffffull) << 59;
    destination[31] |= (source[39] & 0x7ffffffffffffull) << 8;
    destination[31] |= (source[40] & 0x7ffffffffffffull) >> 43;
    destination[32]  = (source[40] & 0x7ffffffffffffull) << 21;
    destination[32] |= (source[41] & 0x7ffffffffffffull) >> 30;
    destination[33]  = (source[41] & 0x7ffffffffffffull) << 34;
    destination[33] |= (source[42] & 0x7ffffffffffffull) >> 17;
    destination[34]  = (source[42] & 0x7ffffffffffffull) << 47;
    destination[34] |= (source[43] & 0x7ffffffffffffull) >> 4;
    destination[35]  = (source[43] & 0x7ffffffffffffull) << 60;
    destination[35] |= (source[44] & 0x7ffffffffffffull) << 9;
    destination[35] |= (source[45] & 0x7ffffffffffffull) >> 42;
    destination[36]  = (source[45] & 0x7ffffffffffffull) << 22;
    destination[36] |= (source[46] & 0x7ffffffffffffull) >> 29;
    destination[37]  = (source[46] & 0x7ffffffffffffull) << 35;
    destination[37] |= (source[47] & 0x7ffffffffffffull) >> 16;
    destination[38]  = (source[47] & 0x7ffffffffffffull) << 48;
    destination[38] |= (source[48] & 0x7ffffffffffffull) >> 3;
    destination[39]  = (source[48] & 0x7ffffffffffffull) << 61;
    destination[39] |= (source[49] & 0x7ffffffffffffull) << 10;
    destination[39] |= (source[50] & 0x7ffffffffffffull) >> 41;
    destination[40]  = (source[50] & 0x7ffffffffffffull) << 23;
    destination[40] |= (source[51] & 0x7ffffffffffffull) >> 28;
    destination[41]  = (source[51] & 0x7ffffffffffffull) << 36;
    destination[41] |= (source[52] & 0x7ffffffffffffull) >> 15;
    destination[42]  = (source[52] & 0x7ffffffffffffull) << 49;
    destination[42] |= (source[53] & 0x7ffffffffffffull) >> 2;
    destination[43]  = (source[53] & 0x7ffffffffffffull) << 62;
    destination[43] |= (source[54] & 0x7ffffffffffffull) << 11;
    destination[43] |= (source[55] & 0x7ffffffffffffull) >> 40;
    destination[44]  = (source[55] & 0x7ffffffffffffull) << 24;
    destination[44] |= (source[56] & 0x7ffffffffffffull) >> 27;
    destination[45]  = (source[56] & 0x7ffffffffffffull) << 37;
    destination[45] |= (source[57] & 0x7ffffffffffffull) >> 14;
    destination[46]  = (source[57] & 0x7ffffffffffffull) << 50;
    destination[46] |= (source[58] & 0x7ffffffffffffull) >> 1;
    destination[47]  = (source[58] & 0x7ffffffffffffull) << 63;
    destination[47] |= (source[59] & 0x7ffffffffffffull) << 12;
    destination[47] |= (source[60] & 0x7ffffffffffffull) >> 39;
    destination[48]  = (source[60] & 0x7ffffffffffffull) << 25;
    destination[48] |= (source[61] & 0x7ffffffffffffull) >> 26;
    destination[49]  = (source[61] & 0x7ffffffffffffull) << 38;
    destination[49] |= (source[62] & 0x7ffffffffffffull) >> 13;
    destination[50]  = (source[62] & 0x7ffffffffffffull) << 51;
    destination[50] |= (source[63] & 0x7ffffffffffffull) << 0;
  }
  static inline
  void unpack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] >> 13) & 0x7ffffffffffffull;
    destination[1]  = (source[0] << 38) & 0x7ffffffffffffull;
    destination[1] |= (source[1] >> 26) & 0x7ffffffffffffull;
    destination[2]  = (source[1] << 25) & 0x7ffffffffffffull;
    destination[2] |= (source[2] >> 39) & 0x7ffffffffffffull;
    destination[3]  = (source[2] << 12) & 0x7ffffffffffffull;
    destination[3] |= (source[3] >> 52) & 0x7ffffffffffffull;
    destination[4]  = (source[3] >> 1) & 0x7ffffffffffffull;
    destination[5]  = (source[3] << 50) & 0x7ffffffffffffull;
    destination[5] |= (source[4] >> 14) & 0x7ffffffffffffull;
    destination[6]  = (source[4] << 37) & 0x7ffffffffffffull;
    destination[6] |= (source[5] >> 27) & 0x7ffffffffffffull;
    destination[7]  = (source[5] << 24) & 0x7ffffffffffffull;
    destination[7] |= (source[6] >> 40) & 0x7ffffffffffffull;
    destination[8]  = (source[6] << 11) & 0x7ffffffffffffull;
    destination[8] |= (source[7] >> 53) & 0x7ffffffffffffull;
    destination[9]  = (source[7] >> 2) & 0x7ffffffffffffull;
    destination[10]  = (source[7] << 49) & 0x7ffffffffffffull;
    destination[10] |= (source[8] >> 15) & 0x7ffffffffffffull;
    destination[11]  = (source[8] << 36) & 0x7ffffffffffffull;
    destination[11] |= (source[9] >> 28) & 0x7ffffffffffffull;
    destination[12]  = (source[9] << 23) & 0x7ffffffffffffull;
    destination[12] |= (source[10] >> 41) & 0x7ffffffffffffull;
    destination[13]  = (source[10] << 10) & 0x7ffffffffffffull;
    destination[13] |= (source[11] >> 54) & 0x7ffffffffffffull;
    destination[14]  = (source[11] >> 3) & 0x7ffffffffffffull;
    destination[15]  = (source[11] << 48) & 0x7ffffffffffffull;
    destination[15] |= (source[12] >> 16) & 0x7ffffffffffffull;
    destination[16]  = (source[12] << 35) & 0x7ffffffffffffull;
    destination[16] |= (source[13] >> 29) & 0x7ffffffffffffull;
    destination[17]  = (source[13] << 22) & 0x7ffffffffffffull;
    destination[17] |= (source[14] >> 42) & 0x7ffffffffffffull;
    destination[18]  = (source[14] << 9) & 0x7ffffffffffffull;
    destination[18] |= (source[15] >> 55) & 0x7ffffffffffffull;
    destination[19]  = (source[15] >> 4) & 0x7ffffffffffffull;
    destination[20]  = (source[15] << 47) & 0x7ffffffffffffull;
    destination[20] |= (source[16] >> 17) & 0x7ffffffffffffull;
    destination[21]  = (source[16] << 34) & 0x7ffffffffffffull;
    destination[21] |= (source[17] >> 30) & 0x7ffffffffffffull;
    destination[22]  = (source[17] << 21) & 0x7ffffffffffffull;
    destination[22] |= (source[18] >> 43) & 0x7ffffffffffffull;
    destination[23]  = (source[18] << 8) & 0x7ffffffffffffull;
    destination[23] |= (source[19] >> 56) & 0x7ffffffffffffull;
    destination[24]  = (source[19] >> 5) & 0x7ffffffffffffull;
    destination[25]  = (source[19] << 46) & 0x7ffffffffffffull;
    destination[25] |= (source[20] >> 18) & 0x7ffffffffffffull;
    destination[26]  = (source[20] << 33) & 0x7ffffffffffffull;
    destination[26] |= (source[21] >> 31) & 0x7ffffffffffffull;
    destination[27]  = (source[21] << 20) & 0x7ffffffffffffull;
    destination[27] |= (source[22] >> 44) & 0x7ffffffffffffull;
    destination[28]  = (source[22] << 7) & 0x7ffffffffffffull;
    destination[28] |= (source[23] >> 57) & 0x7ffffffffffffull;
    destination[29]  = (source[23] >> 6) & 0x7ffffffffffffull;
    destination[30]  = (source[23] << 45) & 0x7ffffffffffffull;
    destination[30] |= (source[24] >> 19) & 0x7ffffffffffffull;
    destination[31]  = (source[24] << 32) & 0x7ffffffffffffull;
    destination[31] |= (source[25] >> 32) & 0x7ffffffffffffull;
    destination[32]  = (source[25] << 19) & 0x7ffffffffffffull;
    destination[32] |= (source[26] >> 45) & 0x7ffffffffffffull;
    destination[33]  = (source[26] << 6) & 0x7ffffffffffffull;
    destination[33] |= (source[27] >> 58) & 0x7ffffffffffffull;
    destination[34]  = (source[27] >> 7) & 0x7ffffffffffffull;
    destination[35]  = (source[27] << 44) & 0x7ffffffffffffull;
    destination[35] |= (source[28] >> 20) & 0x7ffffffffffffull;
    destination[36]  = (source[28] << 31) & 0x7ffffffffffffull;
    destination[36] |= (source[29] >> 33) & 0x7ffffffffffffull;
    destination[37]  = (source[29] << 18) & 0x7ffffffffffffull;
    destination[37] |= (source[30] >> 46) & 0x7ffffffffffffull;
    destination[38]  = (source[30] << 5) & 0x7ffffffffffffull;
    destination[38] |= (source[31] >> 59) & 0x7ffffffffffffull;
    destination[39]  = (source[31] >> 8) & 0x7ffffffffffffull;
    destination[40]  = (source[31] << 43) & 0x7ffffffffffffull;
    destination[40] |= (source[32] >> 21) & 0x7ffffffffffffull;
    destination[41]  = (source[32] << 30) & 0x7ffffffffffffull;
    destination[41] |= (source[33] >> 34) & 0x7ffffffffffffull;
    destination[42]  = (source[33] << 17) & 0x7ffffffffffffull;
    destination[42] |= (source[34] >> 47) & 0x7ffffffffffffull;
    destination[43]  = (source[34] << 4) & 0x7ffffffffffffull;
    destination[43] |= (source[35] >> 60) & 0x7ffffffffffffull;
    destination[44]  = (source[35] >> 9) & 0x7ffffffffffffull;
    destination[45]  = (source[35] << 42) & 0x7ffffffffffffull;
    destination[45] |= (source[36] >> 22) & 0x7ffffffffffffull;
    destination[46]  = (source[36] << 29) & 0x7ffffffffffffull;
    destination[46] |= (source[37] >> 35) & 0x7ffffffffffffull;
    destination[47]  = (source[37] << 16) & 0x7ffffffffffffull;
    destination[47] |= (source[38] >> 48) & 0x7ffffffffffffull;
    destination[48]  = (source[38] << 3) & 0x7ffffffffffffull;
    destination[48] |= (source[39] >> 61) & 0x7ffffffffffffull;
    destination[49]  = (source[39] >> 10) & 0x7ffffffffffffull;
    destination[50]  = (source[39] << 41) & 0x7ffffffffffffull;
    destination[50] |= (source[40] >> 23) & 0x7ffffffffffffull;
    destination[51]  = (source[40] << 28) & 0x7ffffffffffffull;
    destination[51] |= (source[41] >> 36) & 0x7ffffffffffffull;
    destination[52]  = (source[41] << 15) & 0x7ffffffffffffull;
    destination[52] |= (source[42] >> 49) & 0x7ffffffffffffull;
    destination[53]  = (source[42] << 2) & 0x7ffffffffffffull;
    destination[53] |= (source[43] >> 62) & 0x7ffffffffffffull;
    destination[54]  = (source[43] >> 11) & 0x7ffffffffffffull;
    destination[55]  = (source[43] << 40) & 0x7ffffffffffffull;
    destination[55] |= (source[44] >> 24) & 0x7ffffffffffffull;
    destination[56]  = (source[44] << 27) & 0x7ffffffffffffull;
    destination[56] |= (source[45] >> 37) & 0x7ffffffffffffull;
    destination[57]  = (source[45] << 14) & 0x7ffffffffffffull;
    destination[57] |= (source[46] >> 50) & 0x7ffffffffffffull;
    destination[58]  = (source[46] << 1) & 0x7ffffffffffffull;
    destination[58] |= (source[47] >> 63) & 0x7ffffffffffffull;
    destination[59]  = (source[47] >> 12) & 0x7ffffffffffffull;
    destination[60]  = (source[47] << 39) & 0x7ffffffffffffull;
    destination[60] |= (source[48] >> 25) & 0x7ffffffffffffull;
    destination[61]  = (source[48] << 26) & 0x7ffffffffffffull;
    destination[61] |= (source[49] >> 38) & 0x7ffffffffffffull;
    destination[62]  = (source[49] << 13) & 0x7ffffffffffffull;
    destination[62] |= (source[50] >> 51) & 0x7ffffffffffffull;
    destination[63]  = (source[50] >> 0) & 0x7ffffffffffffull;
  }
};
template <typename Tp>
struct __struct_bitpack_impl<Tp,8,52>
{
  static const size_t unit_size = 64;
  static const size_t bits_total = 3328;
  static const size_t loop_total = 64;
  static const size_t bit_size = 52;
  static const Tp     mask = 0xfffffffffffffull;
  static inline
  void pack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] & 0xfffffffffffffull) << 12;
    destination[0] |= (source[1] & 0xfffffffffffffull) >> 40;
    destination[1]  = (source[1] & 0xfffffffffffffull) << 24;
    destination[1] |= (source[2] & 0xfffffffffffffull) >> 28;
    destination[2]  = (source[2] & 0xfffffffffffffull) << 36;
    destination[2] |= (source[3] & 0xfffffffffffffull) >> 16;
    destination[3]  = (source[3] & 0xfffffffffffffull) << 48;
    destination[3] |= (source[4] & 0xfffffffffffffull) >> 4;
    destination[4]  = (source[4] & 0xfffffffffffffull) << 60;
    destination[4] |= (source[5] & 0xfffffffffffffull) << 8;
    destination[4] |= (source[6] & 0xfffffffffffffull) >> 44;
    destination[5]  = (source[6] & 0xfffffffffffffull) << 20;
    destination[5] |= (source[7] & 0xfffffffffffffull) >> 32;
    destination[6]  = (source[7] & 0xfffffffffffffull) << 32;
    destination[6] |= (source[8] & 0xfffffffffffffull) >> 20;
    destination[7]  = (source[8] & 0xfffffffffffffull) << 44;
    destination[7] |= (source[9] & 0xfffffffffffffull) >> 8;
    destination[8]  = (source[9] & 0xfffffffffffffull) << 56;
    destination[8] |= (source[10] & 0xfffffffffffffull) << 4;
    destination[8] |= (source[11] & 0xfffffffffffffull) >> 48;
    destination[9]  = (source[11] & 0xfffffffffffffull) << 16;
    destination[9] |= (source[12] & 0xfffffffffffffull) >> 36;
    destination[10]  = (source[12] & 0xfffffffffffffull) << 28;
    destination[10] |= (source[13] & 0xfffffffffffffull) >> 24;
    destination[11]  = (source[13] & 0xfffffffffffffull) << 40;
    destination[11] |= (source[14] & 0xfffffffffffffull) >> 12;
    destination[12]  = (source[14] & 0xfffffffffffffull) << 52;
    destination[12] |= (source[15] & 0xfffffffffffffull) << 0;
    destination[13]  = (source[16] & 0xfffffffffffffull) << 12;
    destination[13] |= (source[17] & 0xfffffffffffffull) >> 40;
    destination[14]  = (source[17] & 0xfffffffffffffull) << 24;
    destination[14] |= (source[18] & 0xfffffffffffffull) >> 28;
    destination[15]  = (source[18] & 0xfffffffffffffull) << 36;
    destination[15] |= (source[19] & 0xfffffffffffffull) >> 16;
    destination[16]  = (source[19] & 0xfffffffffffffull) << 48;
    destination[16] |= (source[20] & 0xfffffffffffffull) >> 4;
    destination[17]  = (source[20] & 0xfffffffffffffull) << 60;
    destination[17] |= (source[21] & 0xfffffffffffffull) << 8;
    destination[17] |= (source[22] & 0xfffffffffffffull) >> 44;
    destination[18]  = (source[22] & 0xfffffffffffffull) << 20;
    destination[18] |= (source[23] & 0xfffffffffffffull) >> 32;
    destination[19]  = (source[23] & 0xfffffffffffffull) << 32;
    destination[19] |= (source[24] & 0xfffffffffffffull) >> 20;
    destination[20]  = (source[24] & 0xfffffffffffffull) << 44;
    destination[20] |= (source[25] & 0xfffffffffffffull) >> 8;
    destination[21]  = (source[25] & 0xfffffffffffffull) << 56;
    destination[21] |= (source[26] & 0xfffffffffffffull) << 4;
    destination[21] |= (source[27] & 0xfffffffffffffull) >> 48;
    destination[22]  = (source[27] & 0xfffffffffffffull) << 16;
    destination[22] |= (source[28] & 0xfffffffffffffull) >> 36;
    destination[23]  = (source[28] & 0xfffffffffffffull) << 28;
    destination[23] |= (source[29] & 0xfffffffffffffull) >> 24;
    destination[24]  = (source[29] & 0xfffffffffffffull) << 40;
    destination[24] |= (source[30] & 0xfffffffffffffull) >> 12;
    destination[25]  = (source[30] & 0xfffffffffffffull) << 52;
    destination[25] |= (source[31] & 0xfffffffffffffull) << 0;
    destination[26]  = (source[32] & 0xfffffffffffffull) << 12;
    destination[26] |= (source[33] & 0xfffffffffffffull) >> 40;
    destination[27]  = (source[33] & 0xfffffffffffffull) << 24;
    destination[27] |= (source[34] & 0xfffffffffffffull) >> 28;
    destination[28]  = (source[34] & 0xfffffffffffffull) << 36;
    destination[28] |= (source[35] & 0xfffffffffffffull) >> 16;
    destination[29]  = (source[35] & 0xfffffffffffffull) << 48;
    destination[29] |= (source[36] & 0xfffffffffffffull) >> 4;
    destination[30]  = (source[36] & 0xfffffffffffffull) << 60;
    destination[30] |= (source[37] & 0xfffffffffffffull) << 8;
    destination[30] |= (source[38] & 0xfffffffffffffull) >> 44;
    destination[31]  = (source[38] & 0xfffffffffffffull) << 20;
    destination[31] |= (source[39] & 0xfffffffffffffull) >> 32;
    destination[32]  = (source[39] & 0xfffffffffffffull) << 32;
    destination[32] |= (source[40] & 0xfffffffffffffull) >> 20;
    destination[33]  = (source[40] & 0xfffffffffffffull) << 44;
    destination[33] |= (source[41] & 0xfffffffffffffull) >> 8;
    destination[34]  = (source[41] & 0xfffffffffffffull) << 56;
    destination[34] |= (source[42] & 0xfffffffffffffull) << 4;
    destination[34] |= (source[43] & 0xfffffffffffffull) >> 48;
    destination[35]  = (source[43] & 0xfffffffffffffull) << 16;
    destination[35] |= (source[44] & 0xfffffffffffffull) >> 36;
    destination[36]  = (source[44] & 0xfffffffffffffull) << 28;
    destination[36] |= (source[45] & 0xfffffffffffffull) >> 24;
    destination[37]  = (source[45] & 0xfffffffffffffull) << 40;
    destination[37] |= (source[46] & 0xfffffffffffffull) >> 12;
    destination[38]  = (source[46] & 0xfffffffffffffull) << 52;
    destination[38] |= (source[47] & 0xfffffffffffffull) << 0;
    destination[39]  = (source[48] & 0xfffffffffffffull) << 12;
    destination[39] |= (source[49] & 0xfffffffffffffull) >> 40;
    destination[40]  = (source[49] & 0xfffffffffffffull) << 24;
    destination[40] |= (source[50] & 0xfffffffffffffull) >> 28;
    destination[41]  = (source[50] & 0xfffffffffffffull) << 36;
    destination[41] |= (source[51] & 0xfffffffffffffull) >> 16;
    destination[42]  = (source[51] & 0xfffffffffffffull) << 48;
    destination[42] |= (source[52] & 0xfffffffffffffull) >> 4;
    destination[43]  = (source[52] & 0xfffffffffffffull) << 60;
    destination[43] |= (source[53] & 0xfffffffffffffull) << 8;
    destination[43] |= (source[54] & 0xfffffffffffffull) >> 44;
    destination[44]  = (source[54] & 0xfffffffffffffull) << 20;
    destination[44] |= (source[55] & 0xfffffffffffffull) >> 32;
    destination[45]  = (source[55] & 0xfffffffffffffull) << 32;
    destination[45] |= (source[56] & 0xfffffffffffffull) >> 20;
    destination[46]  = (source[56] & 0xfffffffffffffull) << 44;
    destination[46] |= (source[57] & 0xfffffffffffffull) >> 8;
    destination[47]  = (source[57] & 0xfffffffffffffull) << 56;
    destination[47] |= (source[58] & 0xfffffffffffffull) << 4;
    destination[47] |= (source[59] & 0xfffffffffffffull) >> 48;
    destination[48]  = (source[59] & 0xfffffffffffffull) << 16;
    destination[48] |= (source[60] & 0xfffffffffffffull) >> 36;
    destination[49]  = (source[60] & 0xfffffffffffffull) << 28;
    destination[49] |= (source[61] & 0xfffffffffffffull) >> 24;
    destination[50]  = (source[61] & 0xfffffffffffffull) << 40;
    destination[50] |= (source[62] & 0xfffffffffffffull) >> 12;
    destination[51]  = (source[62] & 0xfffffffffffffull) << 52;
    destination[51] |= (source[63] & 0xfffffffffffffull) << 0;
  }
  static inline
  void unpack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] >> 12) & 0xfffffffffffffull;
    destination[1]  = (source[0] << 40) & 0xfffffffffffffull;
    destination[1] |= (source[1] >> 24) & 0xfffffffffffffull;
    destination[2]  = (source[1] << 28) & 0xfffffffffffffull;
    destination[2] |= (source[2] >> 36) & 0xfffffffffffffull;
    destination[3]  = (source[2] << 16) & 0xfffffffffffffull;
    destination[3] |= (source[3] >> 48) & 0xfffffffffffffull;
    destination[4]  = (source[3] << 4) & 0xfffffffffffffull;
    destination[4] |= (source[4] >> 60) & 0xfffffffffffffull;
    destination[5]  = (source[4] >> 8) & 0xfffffffffffffull;
    destination[6]  = (source[4] << 44) & 0xfffffffffffffull;
    destination[6] |= (source[5] >> 20) & 0xfffffffffffffull;
    destination[7]  = (source[5] << 32) & 0xfffffffffffffull;
    destination[7] |= (source[6] >> 32) & 0xfffffffffffffull;
    destination[8]  = (source[6] << 20) & 0xfffffffffffffull;
    destination[8] |= (source[7] >> 44) & 0xfffffffffffffull;
    destination[9]  = (source[7] << 8) & 0xfffffffffffffull;
    destination[9] |= (source[8] >> 56) & 0xfffffffffffffull;
    destination[10]  = (source[8] >> 4) & 0xfffffffffffffull;
    destination[11]  = (source[8] << 48) & 0xfffffffffffffull;
    destination[11] |= (source[9] >> 16) & 0xfffffffffffffull;
    destination[12]  = (source[9] << 36) & 0xfffffffffffffull;
    destination[12] |= (source[10] >> 28) & 0xfffffffffffffull;
    destination[13]  = (source[10] << 24) & 0xfffffffffffffull;
    destination[13] |= (source[11] >> 40) & 0xfffffffffffffull;
    destination[14]  = (source[11] << 12) & 0xfffffffffffffull;
    destination[14] |= (source[12] >> 52) & 0xfffffffffffffull;
    destination[15]  = (source[12] >> 0) & 0xfffffffffffffull;
    destination[16]  = (source[13] >> 12) & 0xfffffffffffffull;
    destination[17]  = (source[13] << 40) & 0xfffffffffffffull;
    destination[17] |= (source[14] >> 24) & 0xfffffffffffffull;
    destination[18]  = (source[14] << 28) & 0xfffffffffffffull;
    destination[18] |= (source[15] >> 36) & 0xfffffffffffffull;
    destination[19]  = (source[15] << 16) & 0xfffffffffffffull;
    destination[19] |= (source[16] >> 48) & 0xfffffffffffffull;
    destination[20]  = (source[16] << 4) & 0xfffffffffffffull;
    destination[20] |= (source[17] >> 60) & 0xfffffffffffffull;
    destination[21]  = (source[17] >> 8) & 0xfffffffffffffull;
    destination[22]  = (source[17] << 44) & 0xfffffffffffffull;
    destination[22] |= (source[18] >> 20) & 0xfffffffffffffull;
    destination[23]  = (source[18] << 32) & 0xfffffffffffffull;
    destination[23] |= (source[19] >> 32) & 0xfffffffffffffull;
    destination[24]  = (source[19] << 20) & 0xfffffffffffffull;
    destination[24] |= (source[20] >> 44) & 0xfffffffffffffull;
    destination[25]  = (source[20] << 8) & 0xfffffffffffffull;
    destination[25] |= (source[21] >> 56) & 0xfffffffffffffull;
    destination[26]  = (source[21] >> 4) & 0xfffffffffffffull;
    destination[27]  = (source[21] << 48) & 0xfffffffffffffull;
    destination[27] |= (source[22] >> 16) & 0xfffffffffffffull;
    destination[28]  = (source[22] << 36) & 0xfffffffffffffull;
    destination[28] |= (source[23] >> 28) & 0xfffffffffffffull;
    destination[29]  = (source[23] << 24) & 0xfffffffffffffull;
    destination[29] |= (source[24] >> 40) & 0xfffffffffffffull;
    destination[30]  = (source[24] << 12) & 0xfffffffffffffull;
    destination[30] |= (source[25] >> 52) & 0xfffffffffffffull;
    destination[31]  = (source[25] >> 0) & 0xfffffffffffffull;
    destination[32]  = (source[26] >> 12) & 0xfffffffffffffull;
    destination[33]  = (source[26] << 40) & 0xfffffffffffffull;
    destination[33] |= (source[27] >> 24) & 0xfffffffffffffull;
    destination[34]  = (source[27] << 28) & 0xfffffffffffffull;
    destination[34] |= (source[28] >> 36) & 0xfffffffffffffull;
    destination[35]  = (source[28] << 16) & 0xfffffffffffffull;
    destination[35] |= (source[29] >> 48) & 0xfffffffffffffull;
    destination[36]  = (source[29] << 4) & 0xfffffffffffffull;
    destination[36] |= (source[30] >> 60) & 0xfffffffffffffull;
    destination[37]  = (source[30] >> 8) & 0xfffffffffffffull;
    destination[38]  = (source[30] << 44) & 0xfffffffffffffull;
    destination[38] |= (source[31] >> 20) & 0xfffffffffffffull;
    destination[39]  = (source[31] << 32) & 0xfffffffffffffull;
    destination[39] |= (source[32] >> 32) & 0xfffffffffffffull;
    destination[40]  = (source[32] << 20) & 0xfffffffffffffull;
    destination[40] |= (source[33] >> 44) & 0xfffffffffffffull;
    destination[41]  = (source[33] << 8) & 0xfffffffffffffull;
    destination[41] |= (source[34] >> 56) & 0xfffffffffffffull;
    destination[42]  = (source[34] >> 4) & 0xfffffffffffffull;
    destination[43]  = (source[34] << 48) & 0xfffffffffffffull;
    destination[43] |= (source[35] >> 16) & 0xfffffffffffffull;
    destination[44]  = (source[35] << 36) & 0xfffffffffffffull;
    destination[44] |= (source[36] >> 28) & 0xfffffffffffffull;
    destination[45]  = (source[36] << 24) & 0xfffffffffffffull;
    destination[45] |= (source[37] >> 40) & 0xfffffffffffffull;
    destination[46]  = (source[37] << 12) & 0xfffffffffffffull;
    destination[46] |= (source[38] >> 52) & 0xfffffffffffffull;
    destination[47]  = (source[38] >> 0) & 0xfffffffffffffull;
    destination[48]  = (source[39] >> 12) & 0xfffffffffffffull;
    destination[49]  = (source[39] << 40) & 0xfffffffffffffull;
    destination[49] |= (source[40] >> 24) & 0xfffffffffffffull;
    destination[50]  = (source[40] << 28) & 0xfffffffffffffull;
    destination[50] |= (source[41] >> 36) & 0xfffffffffffffull;
    destination[51]  = (source[41] << 16) & 0xfffffffffffffull;
    destination[51] |= (source[42] >> 48) & 0xfffffffffffffull;
    destination[52]  = (source[42] << 4) & 0xfffffffffffffull;
    destination[52] |= (source[43] >> 60) & 0xfffffffffffffull;
    destination[53]  = (source[43] >> 8) & 0xfffffffffffffull;
    destination[54]  = (source[43] << 44) & 0xfffffffffffffull;
    destination[54] |= (source[44] >> 20) & 0xfffffffffffffull;
    destination[55]  = (source[44] << 32) & 0xfffffffffffffull;
    destination[55] |= (source[45] >> 32) & 0xfffffffffffffull;
    destination[56]  = (source[45] << 20) & 0xfffffffffffffull;
    destination[56] |= (source[46] >> 44) & 0xfffffffffffffull;
    destination[57]  = (source[46] << 8) & 0xfffffffffffffull;
    destination[57] |= (source[47] >> 56) & 0xfffffffffffffull;
    destination[58]  = (source[47] >> 4) & 0xfffffffffffffull;
    destination[59]  = (source[47] << 48) & 0xfffffffffffffull;
    destination[59] |= (source[48] >> 16) & 0xfffffffffffffull;
    destination[60]  = (source[48] << 36) & 0xfffffffffffffull;
    destination[60] |= (source[49] >> 28) & 0xfffffffffffffull;
    destination[61]  = (source[49] << 24) & 0xfffffffffffffull;
    destination[61] |= (source[50] >> 40) & 0xfffffffffffffull;
    destination[62]  = (source[50] << 12) & 0xfffffffffffffull;
    destination[62] |= (source[51] >> 52) & 0xfffffffffffffull;
    destination[63]  = (source[51] >> 0) & 0xfffffffffffffull;
  }
};
template <typename Tp>
struct __struct_bitpack_impl<Tp,8,53>
{
  static const size_t unit_size = 64;
  static const size_t bits_total = 3392;
  static const size_t loop_total = 64;
  static const size_t bit_size = 53;
  static const Tp     mask = 0x1fffffffffffffull;
  static inline
  void pack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] & 0x1fffffffffffffull) << 11;
    destination[0] |= (source[1] & 0x1fffffffffffffull) >> 42;
    destination[1]  = (source[1] & 0x1fffffffffffffull) << 22;
    destination[1] |= (source[2] & 0x1fffffffffffffull) >> 31;
    destination[2]  = (source[2] & 0x1fffffffffffffull) << 33;
    destination[2] |= (source[3] & 0x1fffffffffffffull) >> 20;
    destination[3]  = (source[3] & 0x1fffffffffffffull) << 44;
    destination[3] |= (source[4] & 0x1fffffffffffffull) >> 9;
    destination[4]  = (source[4] & 0x1fffffffffffffull) << 55;
    destination[4] |= (source[5] & 0x1fffffffffffffull) << 2;
    destination[4] |= (source[6] & 0x1fffffffffffffull) >> 51;
    destination[5]  = (source[6] & 0x1fffffffffffffull) << 13;
    destination[5] |= (source[7] & 0x1fffffffffffffull) >> 40;
    destination[6]  = (source[7] & 0x1fffffffffffffull) << 24;
    destination[6] |= (source[8] & 0x1fffffffffffffull) >> 29;
    destination[7]  = (source[8] & 0x1fffffffffffffull) << 35;
    destination[7] |= (source[9] & 0x1fffffffffffffull) >> 18;
    destination[8]  = (source[9] & 0x1fffffffffffffull) << 46;
    destination[8] |= (source[10] & 0x1fffffffffffffull) >> 7;
    destination[9]  = (source[10] & 0x1fffffffffffffull) << 57;
    destination[9] |= (source[11] & 0x1fffffffffffffull) << 4;
    destination[9] |= (source[12] & 0x1fffffffffffffull) >> 49;
    destination[10]  = (source[12] & 0x1fffffffffffffull) << 15;
    destination[10] |= (source[13] & 0x1fffffffffffffull) >> 38;
    destination[11]  = (source[13] & 0x1fffffffffffffull) << 26;
    destination[11] |= (source[14] & 0x1fffffffffffffull) >> 27;
    destination[12]  = (source[14] & 0x1fffffffffffffull) << 37;
    destination[12] |= (source[15] & 0x1fffffffffffffull) >> 16;
    destination[13]  = (source[15] & 0x1fffffffffffffull) << 48;
    destination[13] |= (source[16] & 0x1fffffffffffffull) >> 5;
    destination[14]  = (source[16] & 0x1fffffffffffffull) << 59;
    destination[14] |= (source[17] & 0x1fffffffffffffull) << 6;
    destination[14] |= (source[18] & 0x1fffffffffffffull) >> 47;
    destination[15]  = (source[18] & 0x1fffffffffffffull) << 17;
    destination[15] |= (source[19] & 0x1fffffffffffffull) >> 36;
    destination[16]  = (source[19] & 0x1fffffffffffffull) << 28;
    destination[16] |= (source[20] & 0x1fffffffffffffull) >> 25;
    destination[17]  = (source[20] & 0x1fffffffffffffull) << 39;
    destination[17] |= (source[21] & 0x1fffffffffffffull) >> 14;
    destination[18]  = (source[21] & 0x1fffffffffffffull) << 50;
    destination[18] |= (source[22] & 0x1fffffffffffffull) >> 3;
    destination[19]  = (source[22] & 0x1fffffffffffffull) << 61;
    destination[19] |= (source[23] & 0x1fffffffffffffull) << 8;
    destination[19] |= (source[24] & 0x1fffffffffffffull) >> 45;
    destination[20]  = (source[24] & 0x1fffffffffffffull) << 19;
    destination[20] |= (source[25] & 0x1fffffffffffffull) >> 34;
    destination[21]  = (source[25] & 0x1fffffffffffffull) << 30;
    destination[21] |= (source[26] & 0x1fffffffffffffull) >> 23;
    destination[22]  = (source[26] & 0x1fffffffffffffull) << 41;
    destination[22] |= (source[27] & 0x1fffffffffffffull) >> 12;
    destination[23]  = (source[27] & 0x1fffffffffffffull) << 52;
    destination[23] |= (source[28] & 0x1fffffffffffffull) >> 1;
    destination[24]  = (source[28] & 0x1fffffffffffffull) << 63;
    destination[24] |= (source[29] & 0x1fffffffffffffull) << 10;
    destination[24] |= (source[30] & 0x1fffffffffffffull) >> 43;
    destination[25]  = (source[30] & 0x1fffffffffffffull) << 21;
    destination[25] |= (source[31] & 0x1fffffffffffffull) >> 32;
    destination[26]  = (source[31] & 0x1fffffffffffffull) << 32;
    destination[26] |= (source[32] & 0x1fffffffffffffull) >> 21;
    destination[27]  = (source[32] & 0x1fffffffffffffull) << 43;
    destination[27] |= (source[33] & 0x1fffffffffffffull) >> 10;
    destination[28]  = (source[33] & 0x1fffffffffffffull) << 54;
    destination[28] |= (source[34] & 0x1fffffffffffffull) << 1;
    destination[28] |= (source[35] & 0x1fffffffffffffull) >> 52;
    destination[29]  = (source[35] & 0x1fffffffffffffull) << 12;
    destination[29] |= (source[36] & 0x1fffffffffffffull) >> 41;
    destination[30]  = (source[36] & 0x1fffffffffffffull) << 23;
    destination[30] |= (source[37] & 0x1fffffffffffffull) >> 30;
    destination[31]  = (source[37] & 0x1fffffffffffffull) << 34;
    destination[31] |= (source[38] & 0x1fffffffffffffull) >> 19;
    destination[32]  = (source[38] & 0x1fffffffffffffull) << 45;
    destination[32] |= (source[39] & 0x1fffffffffffffull) >> 8;
    destination[33]  = (source[39] & 0x1fffffffffffffull) << 56;
    destination[33] |= (source[40] & 0x1fffffffffffffull) << 3;
    destination[33] |= (source[41] & 0x1fffffffffffffull) >> 50;
    destination[34]  = (source[41] & 0x1fffffffffffffull) << 14;
    destination[34] |= (source[42] & 0x1fffffffffffffull) >> 39;
    destination[35]  = (source[42] & 0x1fffffffffffffull) << 25;
    destination[35] |= (source[43] & 0x1fffffffffffffull) >> 28;
    destination[36]  = (source[43] & 0x1fffffffffffffull) << 36;
    destination[36] |= (source[44] & 0x1fffffffffffffull) >> 17;
    destination[37]  = (source[44] & 0x1fffffffffffffull) << 47;
    destination[37] |= (source[45] & 0x1fffffffffffffull) >> 6;
    destination[38]  = (source[45] & 0x1fffffffffffffull) << 58;
    destination[38] |= (source[46] & 0x1fffffffffffffull) << 5;
    destination[38] |= (source[47] & 0x1fffffffffffffull) >> 48;
    destination[39]  = (source[47] & 0x1fffffffffffffull) << 16;
    destination[39] |= (source[48] & 0x1fffffffffffffull) >> 37;
    destination[40]  = (source[48] & 0x1fffffffffffffull) << 27;
    destination[40] |= (source[49] & 0x1fffffffffffffull) >> 26;
    destination[41]  = (source[49] & 0x1fffffffffffffull) << 38;
    destination[41] |= (source[50] & 0x1fffffffffffffull) >> 15;
    destination[42]  = (source[50] & 0x1fffffffffffffull) << 49;
    destination[42] |= (source[51] & 0x1fffffffffffffull) >> 4;
    destination[43]  = (source[51] & 0x1fffffffffffffull) << 60;
    destination[43] |= (source[52] & 0x1fffffffffffffull) << 7;
    destination[43] |= (source[53] & 0x1fffffffffffffull) >> 46;
    destination[44]  = (source[53] & 0x1fffffffffffffull) << 18;
    destination[44] |= (source[54] & 0x1fffffffffffffull) >> 35;
    destination[45]  = (source[54] & 0x1fffffffffffffull) << 29;
    destination[45] |= (source[55] & 0x1fffffffffffffull) >> 24;
    destination[46]  = (source[55] & 0x1fffffffffffffull) << 40;
    destination[46] |= (source[56] & 0x1fffffffffffffull) >> 13;
    destination[47]  = (source[56] & 0x1fffffffffffffull) << 51;
    destination[47] |= (source[57] & 0x1fffffffffffffull) >> 2;
    destination[48]  = (source[57] & 0x1fffffffffffffull) << 62;
    destination[48] |= (source[58] & 0x1fffffffffffffull) << 9;
    destination[48] |= (source[59] & 0x1fffffffffffffull) >> 44;
    destination[49]  = (source[59] & 0x1fffffffffffffull) << 20;
    destination[49] |= (source[60] & 0x1fffffffffffffull) >> 33;
    destination[50]  = (source[60] & 0x1fffffffffffffull) << 31;
    destination[50] |= (source[61] & 0x1fffffffffffffull) >> 22;
    destination[51]  = (source[61] & 0x1fffffffffffffull) << 42;
    destination[51] |= (source[62] & 0x1fffffffffffffull) >> 11;
    destination[52]  = (source[62] & 0x1fffffffffffffull) << 53;
    destination[52] |= (source[63] & 0x1fffffffffffffull) << 0;
  }
  static inline
  void unpack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] >> 11) & 0x1fffffffffffffull;
    destination[1]  = (source[0] << 42) & 0x1fffffffffffffull;
    destination[1] |= (source[1] >> 22) & 0x1fffffffffffffull;
    destination[2]  = (source[1] << 31) & 0x1fffffffffffffull;
    destination[2] |= (source[2] >> 33) & 0x1fffffffffffffull;
    destination[3]  = (source[2] << 20) & 0x1fffffffffffffull;
    destination[3] |= (source[3] >> 44) & 0x1fffffffffffffull;
    destination[4]  = (source[3] << 9) & 0x1fffffffffffffull;
    destination[4] |= (source[4] >> 55) & 0x1fffffffffffffull;
    destination[5]  = (source[4] >> 2) & 0x1fffffffffffffull;
    destination[6]  = (source[4] << 51) & 0x1fffffffffffffull;
    destination[6] |= (source[5] >> 13) & 0x1fffffffffffffull;
    destination[7]  = (source[5] << 40) & 0x1fffffffffffffull;
    destination[7] |= (source[6] >> 24) & 0x1fffffffffffffull;
    destination[8]  = (source[6] << 29) & 0x1fffffffffffffull;
    destination[8] |= (source[7] >> 35) & 0x1fffffffffffffull;
    destination[9]  = (source[7] << 18) & 0x1fffffffffffffull;
    destination[9] |= (source[8] >> 46) & 0x1fffffffffffffull;
    destination[10]  = (source[8] << 7) & 0x1fffffffffffffull;
    destination[10] |= (source[9] >> 57) & 0x1fffffffffffffull;
    destination[11]  = (source[9] >> 4) & 0x1fffffffffffffull;
    destination[12]  = (source[9] << 49) & 0x1fffffffffffffull;
    destination[12] |= (source[10] >> 15) & 0x1fffffffffffffull;
    destination[13]  = (source[10] << 38) & 0x1fffffffffffffull;
    destination[13] |= (source[11] >> 26) & 0x1fffffffffffffull;
    destination[14]  = (source[11] << 27) & 0x1fffffffffffffull;
    destination[14] |= (source[12] >> 37) & 0x1fffffffffffffull;
    destination[15]  = (source[12] << 16) & 0x1fffffffffffffull;
    destination[15] |= (source[13] >> 48) & 0x1fffffffffffffull;
    destination[16]  = (source[13] << 5) & 0x1fffffffffffffull;
    destination[16] |= (source[14] >> 59) & 0x1fffffffffffffull;
    destination[17]  = (source[14] >> 6) & 0x1fffffffffffffull;
    destination[18]  = (source[14] << 47) & 0x1fffffffffffffull;
    destination[18] |= (source[15] >> 17) & 0x1fffffffffffffull;
    destination[19]  = (source[15] << 36) & 0x1fffffffffffffull;
    destination[19] |= (source[16] >> 28) & 0x1fffffffffffffull;
    destination[20]  = (source[16] << 25) & 0x1fffffffffffffull;
    destination[20] |= (source[17] >> 39) & 0x1fffffffffffffull;
    destination[21]  = (source[17] << 14) & 0x1fffffffffffffull;
    destination[21] |= (source[18] >> 50) & 0x1fffffffffffffull;
    destination[22]  = (source[18] << 3) & 0x1fffffffffffffull;
    destination[22] |= (source[19] >> 61) & 0x1fffffffffffffull;
    destination[23]  = (source[19] >> 8) & 0x1fffffffffffffull;
    destination[24]  = (source[19] << 45) & 0x1fffffffffffffull;
    destination[24] |= (source[20] >> 19) & 0x1fffffffffffffull;
    destination[25]  = (source[20] << 34) & 0x1fffffffffffffull;
    destination[25] |= (source[21] >> 30) & 0x1fffffffffffffull;
    destination[26]  = (source[21] << 23) & 0x1fffffffffffffull;
    destination[26] |= (source[22] >> 41) & 0x1fffffffffffffull;
    destination[27]  = (source[22] << 12) & 0x1fffffffffffffull;
    destination[27] |= (source[23] >> 52) & 0x1fffffffffffffull;
    destination[28]  = (source[23] << 1) & 0x1fffffffffffffull;
    destination[28] |= (source[24] >> 63) & 0x1fffffffffffffull;
    destination[29]  = (source[24] >> 10) & 0x1fffffffffffffull;
    destination[30]  = (source[24] << 43) & 0x1fffffffffffffull;
    destination[30] |= (source[25] >> 21) & 0x1fffffffffffffull;
    destination[31]  = (source[25] << 32) & 0x1fffffffffffffull;
    destination[31] |= (source[26] >> 32) & 0x1fffffffffffffull;
    destination[32]  = (source[26] << 21) & 0x1fffffffffffffull;
    destination[32] |= (source[27] >> 43) & 0x1fffffffffffffull;
    destination[33]  = (source[27] << 10) & 0x1fffffffffffffull;
    destination[33] |= (source[28] >> 54) & 0x1fffffffffffffull;
    destination[34]  = (source[28] >> 1) & 0x1fffffffffffffull;
    destination[35]  = (source[28] << 52) & 0x1fffffffffffffull;
    destination[35] |= (source[29] >> 12) & 0x1fffffffffffffull;
    destination[36]  = (source[29] << 41) & 0x1fffffffffffffull;
    destination[36] |= (source[30] >> 23) & 0x1fffffffffffffull;
    destination[37]  = (source[30] << 30) & 0x1fffffffffffffull;
    destination[37] |= (source[31] >> 34) & 0x1fffffffffffffull;
    destination[38]  = (source[31] << 19) & 0x1fffffffffffffull;
    destination[38] |= (source[32] >> 45) & 0x1fffffffffffffull;
    destination[39]  = (source[32] << 8) & 0x1fffffffffffffull;
    destination[39] |= (source[33] >> 56) & 0x1fffffffffffffull;
    destination[40]  = (source[33] >> 3) & 0x1fffffffffffffull;
    destination[41]  = (source[33] << 50) & 0x1fffffffffffffull;
    destination[41] |= (source[34] >> 14) & 0x1fffffffffffffull;
    destination[42]  = (source[34] << 39) & 0x1fffffffffffffull;
    destination[42] |= (source[35] >> 25) & 0x1fffffffffffffull;
    destination[43]  = (source[35] << 28) & 0x1fffffffffffffull;
    destination[43] |= (source[36] >> 36) & 0x1fffffffffffffull;
    destination[44]  = (source[36] << 17) & 0x1fffffffffffffull;
    destination[44] |= (source[37] >> 47) & 0x1fffffffffffffull;
    destination[45]  = (source[37] << 6) & 0x1fffffffffffffull;
    destination[45] |= (source[38] >> 58) & 0x1fffffffffffffull;
    destination[46]  = (source[38] >> 5) & 0x1fffffffffffffull;
    destination[47]  = (source[38] << 48) & 0x1fffffffffffffull;
    destination[47] |= (source[39] >> 16) & 0x1fffffffffffffull;
    destination[48]  = (source[39] << 37) & 0x1fffffffffffffull;
    destination[48] |= (source[40] >> 27) & 0x1fffffffffffffull;
    destination[49]  = (source[40] << 26) & 0x1fffffffffffffull;
    destination[49] |= (source[41] >> 38) & 0x1fffffffffffffull;
    destination[50]  = (source[41] << 15) & 0x1fffffffffffffull;
    destination[50] |= (source[42] >> 49) & 0x1fffffffffffffull;
    destination[51]  = (source[42] << 4) & 0x1fffffffffffffull;
    destination[51] |= (source[43] >> 60) & 0x1fffffffffffffull;
    destination[52]  = (source[43] >> 7) & 0x1fffffffffffffull;
    destination[53]  = (source[43] << 46) & 0x1fffffffffffffull;
    destination[53] |= (source[44] >> 18) & 0x1fffffffffffffull;
    destination[54]  = (source[44] << 35) & 0x1fffffffffffffull;
    destination[54] |= (source[45] >> 29) & 0x1fffffffffffffull;
    destination[55]  = (source[45] << 24) & 0x1fffffffffffffull;
    destination[55] |= (source[46] >> 40) & 0x1fffffffffffffull;
    destination[56]  = (source[46] << 13) & 0x1fffffffffffffull;
    destination[56] |= (source[47] >> 51) & 0x1fffffffffffffull;
    destination[57]  = (source[47] << 2) & 0x1fffffffffffffull;
    destination[57] |= (source[48] >> 62) & 0x1fffffffffffffull;
    destination[58]  = (source[48] >> 9) & 0x1fffffffffffffull;
    destination[59]  = (source[48] << 44) & 0x1fffffffffffffull;
    destination[59] |= (source[49] >> 20) & 0x1fffffffffffffull;
    destination[60]  = (source[49] << 33) & 0x1fffffffffffffull;
    destination[60] |= (source[50] >> 31) & 0x1fffffffffffffull;
    destination[61]  = (source[50] << 22) & 0x1fffffffffffffull;
    destination[61] |= (source[51] >> 42) & 0x1fffffffffffffull;
    destination[62]  = (source[51] << 11) & 0x1fffffffffffffull;
    destination[62] |= (source[52] >> 53) & 0x1fffffffffffffull;
    destination[63]  = (source[52] >> 0) & 0x1fffffffffffffull;
  }
};
template <typename Tp>
struct __struct_bitpack_impl<Tp,8,54>
{
  static const size_t unit_size = 64;
  static const size_t bits_total = 3456;
  static const size_t loop_total = 64;
  static const size_t bit_size = 54;
  static const Tp     mask = 0x3fffffffffffffull;
  static inline
  void pack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] & 0x3fffffffffffffull) << 10;
    destination[0] |= (source[1] & 0x3fffffffffffffull) >> 44;
    destination[1]  = (source[1] & 0x3fffffffffffffull) << 20;
    destination[1] |= (source[2] & 0x3fffffffffffffull) >> 34;
    destination[2]  = (source[2] & 0x3fffffffffffffull) << 30;
    destination[2] |= (source[3] & 0x3fffffffffffffull) >> 24;
    destination[3]  = (source[3] & 0x3fffffffffffffull) << 40;
    destination[3] |= (source[4] & 0x3fffffffffffffull) >> 14;
    destination[4]  = (source[4] & 0x3fffffffffffffull) << 50;
    destination[4] |= (source[5] & 0x3fffffffffffffull) >> 4;
    destination[5]  = (source[5] & 0x3fffffffffffffull) << 60;
    destination[5] |= (source[6] & 0x3fffffffffffffull) << 6;
    destination[5] |= (source[7] & 0x3fffffffffffffull) >> 48;
    destination[6]  = (source[7] & 0x3fffffffffffffull) << 16;
    destination[6] |= (source[8] & 0x3fffffffffffffull) >> 38;
    destination[7]  = (source[8] & 0x3fffffffffffffull) << 26;
    destination[7] |= (source[9] & 0x3fffffffffffffull) >> 28;
    destination[8]  = (source[9] & 0x3fffffffffffffull) << 36;
    destination[8] |= (source[10] & 0x3fffffffffffffull) >> 18;
    destination[9]  = (source[10] & 0x3fffffffffffffull) << 46;
    destination[9] |= (source[11] & 0x3fffffffffffffull) >> 8;
    destination[10]  = (source[11] & 0x3fffffffffffffull) << 56;
    destination[10] |= (source[12] & 0x3fffffffffffffull) << 2;
    destination[10] |= (source[13] & 0x3fffffffffffffull) >> 52;
    destination[11]  = (source[13] & 0x3fffffffffffffull) << 12;
    destination[11] |= (source[14] & 0x3fffffffffffffull) >> 42;
    destination[12]  = (source[14] & 0x3fffffffffffffull) << 22;
    destination[12] |= (source[15] & 0x3fffffffffffffull) >> 32;
    destination[13]  = (source[15] & 0x3fffffffffffffull) << 32;
    destination[13] |= (source[16] & 0x3fffffffffffffull) >> 22;
    destination[14]  = (source[16] & 0x3fffffffffffffull) << 42;
    destination[14] |= (source[17] & 0x3fffffffffffffull) >> 12;
    destination[15]  = (source[17] & 0x3fffffffffffffull) << 52;
    destination[15] |= (source[18] & 0x3fffffffffffffull) >> 2;
    destination[16]  = (source[18] & 0x3fffffffffffffull) << 62;
    destination[16] |= (source[19] & 0x3fffffffffffffull) << 8;
    destination[16] |= (source[20] & 0x3fffffffffffffull) >> 46;
    destination[17]  = (source[20] & 0x3fffffffffffffull) << 18;
    destination[17] |= (source[21] & 0x3fffffffffffffull) >> 36;
    destination[18]  = (source[21] & 0x3fffffffffffffull) << 28;
    destination[18] |= (source[22] & 0x3fffffffffffffull) >> 26;
    destination[19]  = (source[22] & 0x3fffffffffffffull) << 38;
    destination[19] |= (source[23] & 0x3fffffffffffffull) >> 16;
    destination[20]  = (source[23] & 0x3fffffffffffffull) << 48;
    destination[20] |= (source[24] & 0x3fffffffffffffull) >> 6;
    destination[21]  = (source[24] & 0x3fffffffffffffull) << 58;
    destination[21] |= (source[25] & 0x3fffffffffffffull) << 4;
    destination[21] |= (source[26] & 0x3fffffffffffffull) >> 50;
    destination[22]  = (source[26] & 0x3fffffffffffffull) << 14;
    destination[22] |= (source[27] & 0x3fffffffffffffull) >> 40;
    destination[23]  = (source[27] & 0x3fffffffffffffull) << 24;
    destination[23] |= (source[28] & 0x3fffffffffffffull) >> 30;
    destination[24]  = (source[28] & 0x3fffffffffffffull) << 34;
    destination[24] |= (source[29] & 0x3fffffffffffffull) >> 20;
    destination[25]  = (source[29] & 0x3fffffffffffffull) << 44;
    destination[25] |= (source[30] & 0x3fffffffffffffull) >> 10;
    destination[26]  = (source[30] & 0x3fffffffffffffull) << 54;
    destination[26] |= (source[31] & 0x3fffffffffffffull) << 0;
    destination[27]  = (source[32] & 0x3fffffffffffffull) << 10;
    destination[27] |= (source[33] & 0x3fffffffffffffull) >> 44;
    destination[28]  = (source[33] & 0x3fffffffffffffull) << 20;
    destination[28] |= (source[34] & 0x3fffffffffffffull) >> 34;
    destination[29]  = (source[34] & 0x3fffffffffffffull) << 30;
    destination[29] |= (source[35] & 0x3fffffffffffffull) >> 24;
    destination[30]  = (source[35] & 0x3fffffffffffffull) << 40;
    destination[30] |= (source[36] & 0x3fffffffffffffull) >> 14;
    destination[31]  = (source[36] & 0x3fffffffffffffull) << 50;
    destination[31] |= (source[37] & 0x3fffffffffffffull) >> 4;
    destination[32]  = (source[37] & 0x3fffffffffffffull) << 60;
    destination[32] |= (source[38] & 0x3fffffffffffffull) << 6;
    destination[32] |= (source[39] & 0x3fffffffffffffull) >> 48;
    destination[33]  = (source[39] & 0x3fffffffffffffull) << 16;
    destination[33] |= (source[40] & 0x3fffffffffffffull) >> 38;
    destination[34]  = (source[40] & 0x3fffffffffffffull) << 26;
    destination[34] |= (source[41] & 0x3fffffffffffffull) >> 28;
    destination[35]  = (source[41] & 0x3fffffffffffffull) << 36;
    destination[35] |= (source[42] & 0x3fffffffffffffull) >> 18;
    destination[36]  = (source[42] & 0x3fffffffffffffull) << 46;
    destination[36] |= (source[43] & 0x3fffffffffffffull) >> 8;
    destination[37]  = (source[43] & 0x3fffffffffffffull) << 56;
    destination[37] |= (source[44] & 0x3fffffffffffffull) << 2;
    destination[37] |= (source[45] & 0x3fffffffffffffull) >> 52;
    destination[38]  = (source[45] & 0x3fffffffffffffull) << 12;
    destination[38] |= (source[46] & 0x3fffffffffffffull) >> 42;
    destination[39]  = (source[46] & 0x3fffffffffffffull) << 22;
    destination[39] |= (source[47] & 0x3fffffffffffffull) >> 32;
    destination[40]  = (source[47] & 0x3fffffffffffffull) << 32;
    destination[40] |= (source[48] & 0x3fffffffffffffull) >> 22;
    destination[41]  = (source[48] & 0x3fffffffffffffull) << 42;
    destination[41] |= (source[49] & 0x3fffffffffffffull) >> 12;
    destination[42]  = (source[49] & 0x3fffffffffffffull) << 52;
    destination[42] |= (source[50] & 0x3fffffffffffffull) >> 2;
    destination[43]  = (source[50] & 0x3fffffffffffffull) << 62;
    destination[43] |= (source[51] & 0x3fffffffffffffull) << 8;
    destination[43] |= (source[52] & 0x3fffffffffffffull) >> 46;
    destination[44]  = (source[52] & 0x3fffffffffffffull) << 18;
    destination[44] |= (source[53] & 0x3fffffffffffffull) >> 36;
    destination[45]  = (source[53] & 0x3fffffffffffffull) << 28;
    destination[45] |= (source[54] & 0x3fffffffffffffull) >> 26;
    destination[46]  = (source[54] & 0x3fffffffffffffull) << 38;
    destination[46] |= (source[55] & 0x3fffffffffffffull) >> 16;
    destination[47]  = (source[55] & 0x3fffffffffffffull) << 48;
    destination[47] |= (source[56] & 0x3fffffffffffffull) >> 6;
    destination[48]  = (source[56] & 0x3fffffffffffffull) << 58;
    destination[48] |= (source[57] & 0x3fffffffffffffull) << 4;
    destination[48] |= (source[58] & 0x3fffffffffffffull) >> 50;
    destination[49]  = (source[58] & 0x3fffffffffffffull) << 14;
    destination[49] |= (source[59] & 0x3fffffffffffffull) >> 40;
    destination[50]  = (source[59] & 0x3fffffffffffffull) << 24;
    destination[50] |= (source[60] & 0x3fffffffffffffull) >> 30;
    destination[51]  = (source[60] & 0x3fffffffffffffull) << 34;
    destination[51] |= (source[61] & 0x3fffffffffffffull) >> 20;
    destination[52]  = (source[61] & 0x3fffffffffffffull) << 44;
    destination[52] |= (source[62] & 0x3fffffffffffffull) >> 10;
    destination[53]  = (source[62] & 0x3fffffffffffffull) << 54;
    destination[53] |= (source[63] & 0x3fffffffffffffull) << 0;
  }
  static inline
  void unpack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] >> 10) & 0x3fffffffffffffull;
    destination[1]  = (source[0] << 44) & 0x3fffffffffffffull;
    destination[1] |= (source[1] >> 20) & 0x3fffffffffffffull;
    destination[2]  = (source[1] << 34) & 0x3fffffffffffffull;
    destination[2] |= (source[2] >> 30) & 0x3fffffffffffffull;
    destination[3]  = (source[2] << 24) & 0x3fffffffffffffull;
    destination[3] |= (source[3] >> 40) & 0x3fffffffffffffull;
    destination[4]  = (source[3] << 14) & 0x3fffffffffffffull;
    destination[4] |= (source[4] >> 50) & 0x3fffffffffffffull;
    destination[5]  = (source[4] << 4) & 0x3fffffffffffffull;
    destination[5] |= (source[5] >> 60) & 0x3fffffffffffffull;
    destination[6]  = (source[5] >> 6) & 0x3fffffffffffffull;
    destination[7]  = (source[5] << 48) & 0x3fffffffffffffull;
    destination[7] |= (source[6] >> 16) & 0x3fffffffffffffull;
    destination[8]  = (source[6] << 38) & 0x3fffffffffffffull;
    destination[8] |= (source[7] >> 26) & 0x3fffffffffffffull;
    destination[9]  = (source[7] << 28) & 0x3fffffffffffffull;
    destination[9] |= (source[8] >> 36) & 0x3fffffffffffffull;
    destination[10]  = (source[8] << 18) & 0x3fffffffffffffull;
    destination[10] |= (source[9] >> 46) & 0x3fffffffffffffull;
    destination[11]  = (source[9] << 8) & 0x3fffffffffffffull;
    destination[11] |= (source[10] >> 56) & 0x3fffffffffffffull;
    destination[12]  = (source[10] >> 2) & 0x3fffffffffffffull;
    destination[13]  = (source[10] << 52) & 0x3fffffffffffffull;
    destination[13] |= (source[11] >> 12) & 0x3fffffffffffffull;
    destination[14]  = (source[11] << 42) & 0x3fffffffffffffull;
    destination[14] |= (source[12] >> 22) & 0x3fffffffffffffull;
    destination[15]  = (source[12] << 32) & 0x3fffffffffffffull;
    destination[15] |= (source[13] >> 32) & 0x3fffffffffffffull;
    destination[16]  = (source[13] << 22) & 0x3fffffffffffffull;
    destination[16] |= (source[14] >> 42) & 0x3fffffffffffffull;
    destination[17]  = (source[14] << 12) & 0x3fffffffffffffull;
    destination[17] |= (source[15] >> 52) & 0x3fffffffffffffull;
    destination[18]  = (source[15] << 2) & 0x3fffffffffffffull;
    destination[18] |= (source[16] >> 62) & 0x3fffffffffffffull;
    destination[19]  = (source[16] >> 8) & 0x3fffffffffffffull;
    destination[20]  = (source[16] << 46) & 0x3fffffffffffffull;
    destination[20] |= (source[17] >> 18) & 0x3fffffffffffffull;
    destination[21]  = (source[17] << 36) & 0x3fffffffffffffull;
    destination[21] |= (source[18] >> 28) & 0x3fffffffffffffull;
    destination[22]  = (source[18] << 26) & 0x3fffffffffffffull;
    destination[22] |= (source[19] >> 38) & 0x3fffffffffffffull;
    destination[23]  = (source[19] << 16) & 0x3fffffffffffffull;
    destination[23] |= (source[20] >> 48) & 0x3fffffffffffffull;
    destination[24]  = (source[20] << 6) & 0x3fffffffffffffull;
    destination[24] |= (source[21] >> 58) & 0x3fffffffffffffull;
    destination[25]  = (source[21] >> 4) & 0x3fffffffffffffull;
    destination[26]  = (source[21] << 50) & 0x3fffffffffffffull;
    destination[26] |= (source[22] >> 14) & 0x3fffffffffffffull;
    destination[27]  = (source[22] << 40) & 0x3fffffffffffffull;
    destination[27] |= (source[23] >> 24) & 0x3fffffffffffffull;
    destination[28]  = (source[23] << 30) & 0x3fffffffffffffull;
    destination[28] |= (source[24] >> 34) & 0x3fffffffffffffull;
    destination[29]  = (source[24] << 20) & 0x3fffffffffffffull;
    destination[29] |= (source[25] >> 44) & 0x3fffffffffffffull;
    destination[30]  = (source[25] << 10) & 0x3fffffffffffffull;
    destination[30] |= (source[26] >> 54) & 0x3fffffffffffffull;
    destination[31]  = (source[26] >> 0) & 0x3fffffffffffffull;
    destination[32]  = (source[27] >> 10) & 0x3fffffffffffffull;
    destination[33]  = (source[27] << 44) & 0x3fffffffffffffull;
    destination[33] |= (source[28] >> 20) & 0x3fffffffffffffull;
    destination[34]  = (source[28] << 34) & 0x3fffffffffffffull;
    destination[34] |= (source[29] >> 30) & 0x3fffffffffffffull;
    destination[35]  = (source[29] << 24) & 0x3fffffffffffffull;
    destination[35] |= (source[30] >> 40) & 0x3fffffffffffffull;
    destination[36]  = (source[30] << 14) & 0x3fffffffffffffull;
    destination[36] |= (source[31] >> 50) & 0x3fffffffffffffull;
    destination[37]  = (source[31] << 4) & 0x3fffffffffffffull;
    destination[37] |= (source[32] >> 60) & 0x3fffffffffffffull;
    destination[38]  = (source[32] >> 6) & 0x3fffffffffffffull;
    destination[39]  = (source[32] << 48) & 0x3fffffffffffffull;
    destination[39] |= (source[33] >> 16) & 0x3fffffffffffffull;
    destination[40]  = (source[33] << 38) & 0x3fffffffffffffull;
    destination[40] |= (source[34] >> 26) & 0x3fffffffffffffull;
    destination[41]  = (source[34] << 28) & 0x3fffffffffffffull;
    destination[41] |= (source[35] >> 36) & 0x3fffffffffffffull;
    destination[42]  = (source[35] << 18) & 0x3fffffffffffffull;
    destination[42] |= (source[36] >> 46) & 0x3fffffffffffffull;
    destination[43]  = (source[36] << 8) & 0x3fffffffffffffull;
    destination[43] |= (source[37] >> 56) & 0x3fffffffffffffull;
    destination[44]  = (source[37] >> 2) & 0x3fffffffffffffull;
    destination[45]  = (source[37] << 52) & 0x3fffffffffffffull;
    destination[45] |= (source[38] >> 12) & 0x3fffffffffffffull;
    destination[46]  = (source[38] << 42) & 0x3fffffffffffffull;
    destination[46] |= (source[39] >> 22) & 0x3fffffffffffffull;
    destination[47]  = (source[39] << 32) & 0x3fffffffffffffull;
    destination[47] |= (source[40] >> 32) & 0x3fffffffffffffull;
    destination[48]  = (source[40] << 22) & 0x3fffffffffffffull;
    destination[48] |= (source[41] >> 42) & 0x3fffffffffffffull;
    destination[49]  = (source[41] << 12) & 0x3fffffffffffffull;
    destination[49] |= (source[42] >> 52) & 0x3fffffffffffffull;
    destination[50]  = (source[42] << 2) & 0x3fffffffffffffull;
    destination[50] |= (source[43] >> 62) & 0x3fffffffffffffull;
    destination[51]  = (source[43] >> 8) & 0x3fffffffffffffull;
    destination[52]  = (source[43] << 46) & 0x3fffffffffffffull;
    destination[52] |= (source[44] >> 18) & 0x3fffffffffffffull;
    destination[53]  = (source[44] << 36) & 0x3fffffffffffffull;
    destination[53] |= (source[45] >> 28) & 0x3fffffffffffffull;
    destination[54]  = (source[45] << 26) & 0x3fffffffffffffull;
    destination[54] |= (source[46] >> 38) & 0x3fffffffffffffull;
    destination[55]  = (source[46] << 16) & 0x3fffffffffffffull;
    destination[55] |= (source[47] >> 48) & 0x3fffffffffffffull;
    destination[56]  = (source[47] << 6) & 0x3fffffffffffffull;
    destination[56] |= (source[48] >> 58) & 0x3fffffffffffffull;
    destination[57]  = (source[48] >> 4) & 0x3fffffffffffffull;
    destination[58]  = (source[48] << 50) & 0x3fffffffffffffull;
    destination[58] |= (source[49] >> 14) & 0x3fffffffffffffull;
    destination[59]  = (source[49] << 40) & 0x3fffffffffffffull;
    destination[59] |= (source[50] >> 24) & 0x3fffffffffffffull;
    destination[60]  = (source[50] << 30) & 0x3fffffffffffffull;
    destination[60] |= (source[51] >> 34) & 0x3fffffffffffffull;
    destination[61]  = (source[51] << 20) & 0x3fffffffffffffull;
    destination[61] |= (source[52] >> 44) & 0x3fffffffffffffull;
    destination[62]  = (source[52] << 10) & 0x3fffffffffffffull;
    destination[62] |= (source[53] >> 54) & 0x3fffffffffffffull;
    destination[63]  = (source[53] >> 0) & 0x3fffffffffffffull;
  }
};
template <typename Tp>
struct __struct_bitpack_impl<Tp,8,55>
{
  static const size_t unit_size = 64;
  static const size_t bits_total = 3520;
  static const size_t loop_total = 64;
  static const size_t bit_size = 55;
  static const Tp     mask = 0x7fffffffffffffull;
  static inline
  void pack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] & 0x7fffffffffffffull) << 9;
    destination[0] |= (source[1] & 0x7fffffffffffffull) >> 46;
    destination[1]  = (source[1] & 0x7fffffffffffffull) << 18;
    destination[1] |= (source[2] & 0x7fffffffffffffull) >> 37;
    destination[2]  = (source[2] & 0x7fffffffffffffull) << 27;
    destination[2] |= (source[3] & 0x7fffffffffffffull) >> 28;
    destination[3]  = (source[3] & 0x7fffffffffffffull) << 36;
    destination[3] |= (source[4] & 0x7fffffffffffffull) >> 19;
    destination[4]  = (source[4] & 0x7fffffffffffffull) << 45;
    destination[4] |= (source[5] & 0x7fffffffffffffull) >> 10;
    destination[5]  = (source[5] & 0x7fffffffffffffull) << 54;
    destination[5] |= (source[6] & 0x7fffffffffffffull) >> 1;
    destination[6]  = (source[6] & 0x7fffffffffffffull) << 63;
    destination[6] |= (source[7] & 0x7fffffffffffffull) << 8;
    destination[6] |= (source[8] & 0x7fffffffffffffull) >> 47;
    destination[7]  = (source[8] & 0x7fffffffffffffull) << 17;
    destination[7] |= (source[9] & 0x7fffffffffffffull) >> 38;
    destination[8]  = (source[9] & 0x7fffffffffffffull) << 26;
    destination[8] |= (source[10] & 0x7fffffffffffffull) >> 29;
    destination[9]  = (source[10] & 0x7fffffffffffffull) << 35;
    destination[9] |= (source[11] & 0x7fffffffffffffull) >> 20;
    destination[10]  = (source[11] & 0x7fffffffffffffull) << 44;
    destination[10] |= (source[12] & 0x7fffffffffffffull) >> 11;
    destination[11]  = (source[12] & 0x7fffffffffffffull) << 53;
    destination[11] |= (source[13] & 0x7fffffffffffffull) >> 2;
    destination[12]  = (source[13] & 0x7fffffffffffffull) << 62;
    destination[12] |= (source[14] & 0x7fffffffffffffull) << 7;
    destination[12] |= (source[15] & 0x7fffffffffffffull) >> 48;
    destination[13]  = (source[15] & 0x7fffffffffffffull) << 16;
    destination[13] |= (source[16] & 0x7fffffffffffffull) >> 39;
    destination[14]  = (source[16] & 0x7fffffffffffffull) << 25;
    destination[14] |= (source[17] & 0x7fffffffffffffull) >> 30;
    destination[15]  = (source[17] & 0x7fffffffffffffull) << 34;
    destination[15] |= (source[18] & 0x7fffffffffffffull) >> 21;
    destination[16]  = (source[18] & 0x7fffffffffffffull) << 43;
    destination[16] |= (source[19] & 0x7fffffffffffffull) >> 12;
    destination[17]  = (source[19] & 0x7fffffffffffffull) << 52;
    destination[17] |= (source[20] & 0x7fffffffffffffull) >> 3;
    destination[18]  = (source[20] & 0x7fffffffffffffull) << 61;
    destination[18] |= (source[21] & 0x7fffffffffffffull) << 6;
    destination[18] |= (source[22] & 0x7fffffffffffffull) >> 49;
    destination[19]  = (source[22] & 0x7fffffffffffffull) << 15;
    destination[19] |= (source[23] & 0x7fffffffffffffull) >> 40;
    destination[20]  = (source[23] & 0x7fffffffffffffull) << 24;
    destination[20] |= (source[24] & 0x7fffffffffffffull) >> 31;
    destination[21]  = (source[24] & 0x7fffffffffffffull) << 33;
    destination[21] |= (source[25] & 0x7fffffffffffffull) >> 22;
    destination[22]  = (source[25] & 0x7fffffffffffffull) << 42;
    destination[22] |= (source[26] & 0x7fffffffffffffull) >> 13;
    destination[23]  = (source[26] & 0x7fffffffffffffull) << 51;
    destination[23] |= (source[27] & 0x7fffffffffffffull) >> 4;
    destination[24]  = (source[27] & 0x7fffffffffffffull) << 60;
    destination[24] |= (source[28] & 0x7fffffffffffffull) << 5;
    destination[24] |= (source[29] & 0x7fffffffffffffull) >> 50;
    destination[25]  = (source[29] & 0x7fffffffffffffull) << 14;
    destination[25] |= (source[30] & 0x7fffffffffffffull) >> 41;
    destination[26]  = (source[30] & 0x7fffffffffffffull) << 23;
    destination[26] |= (source[31] & 0x7fffffffffffffull) >> 32;
    destination[27]  = (source[31] & 0x7fffffffffffffull) << 32;
    destination[27] |= (source[32] & 0x7fffffffffffffull) >> 23;
    destination[28]  = (source[32] & 0x7fffffffffffffull) << 41;
    destination[28] |= (source[33] & 0x7fffffffffffffull) >> 14;
    destination[29]  = (source[33] & 0x7fffffffffffffull) << 50;
    destination[29] |= (source[34] & 0x7fffffffffffffull) >> 5;
    destination[30]  = (source[34] & 0x7fffffffffffffull) << 59;
    destination[30] |= (source[35] & 0x7fffffffffffffull) << 4;
    destination[30] |= (source[36] & 0x7fffffffffffffull) >> 51;
    destination[31]  = (source[36] & 0x7fffffffffffffull) << 13;
    destination[31] |= (source[37] & 0x7fffffffffffffull) >> 42;
    destination[32]  = (source[37] & 0x7fffffffffffffull) << 22;
    destination[32] |= (source[38] & 0x7fffffffffffffull) >> 33;
    destination[33]  = (source[38] & 0x7fffffffffffffull) << 31;
    destination[33] |= (source[39] & 0x7fffffffffffffull) >> 24;
    destination[34]  = (source[39] & 0x7fffffffffffffull) << 40;
    destination[34] |= (source[40] & 0x7fffffffffffffull) >> 15;
    destination[35]  = (source[40] & 0x7fffffffffffffull) << 49;
    destination[35] |= (source[41] & 0x7fffffffffffffull) >> 6;
    destination[36]  = (source[41] & 0x7fffffffffffffull) << 58;
    destination[36] |= (source[42] & 0x7fffffffffffffull) << 3;
    destination[36] |= (source[43] & 0x7fffffffffffffull) >> 52;
    destination[37]  = (source[43] & 0x7fffffffffffffull) << 12;
    destination[37] |= (source[44] & 0x7fffffffffffffull) >> 43;
    destination[38]  = (source[44] & 0x7fffffffffffffull) << 21;
    destination[38] |= (source[45] & 0x7fffffffffffffull) >> 34;
    destination[39]  = (source[45] & 0x7fffffffffffffull) << 30;
    destination[39] |= (source[46] & 0x7fffffffffffffull) >> 25;
    destination[40]  = (source[46] & 0x7fffffffffffffull) << 39;
    destination[40] |= (source[47] & 0x7fffffffffffffull) >> 16;
    destination[41]  = (source[47] & 0x7fffffffffffffull) << 48;
    destination[41] |= (source[48] & 0x7fffffffffffffull) >> 7;
    destination[42]  = (source[48] & 0x7fffffffffffffull) << 57;
    destination[42] |= (source[49] & 0x7fffffffffffffull) << 2;
    destination[42] |= (source[50] & 0x7fffffffffffffull) >> 53;
    destination[43]  = (source[50] & 0x7fffffffffffffull) << 11;
    destination[43] |= (source[51] & 0x7fffffffffffffull) >> 44;
    destination[44]  = (source[51] & 0x7fffffffffffffull) << 20;
    destination[44] |= (source[52] & 0x7fffffffffffffull) >> 35;
    destination[45]  = (source[52] & 0x7fffffffffffffull) << 29;
    destination[45] |= (source[53] & 0x7fffffffffffffull) >> 26;
    destination[46]  = (source[53] & 0x7fffffffffffffull) << 38;
    destination[46] |= (source[54] & 0x7fffffffffffffull) >> 17;
    destination[47]  = (source[54] & 0x7fffffffffffffull) << 47;
    destination[47] |= (source[55] & 0x7fffffffffffffull) >> 8;
    destination[48]  = (source[55] & 0x7fffffffffffffull) << 56;
    destination[48] |= (source[56] & 0x7fffffffffffffull) << 1;
    destination[48] |= (source[57] & 0x7fffffffffffffull) >> 54;
    destination[49]  = (source[57] & 0x7fffffffffffffull) << 10;
    destination[49] |= (source[58] & 0x7fffffffffffffull) >> 45;
    destination[50]  = (source[58] & 0x7fffffffffffffull) << 19;
    destination[50] |= (source[59] & 0x7fffffffffffffull) >> 36;
    destination[51]  = (source[59] & 0x7fffffffffffffull) << 28;
    destination[51] |= (source[60] & 0x7fffffffffffffull) >> 27;
    destination[52]  = (source[60] & 0x7fffffffffffffull) << 37;
    destination[52] |= (source[61] & 0x7fffffffffffffull) >> 18;
    destination[53]  = (source[61] & 0x7fffffffffffffull) << 46;
    destination[53] |= (source[62] & 0x7fffffffffffffull) >> 9;
    destination[54]  = (source[62] & 0x7fffffffffffffull) << 55;
    destination[54] |= (source[63] & 0x7fffffffffffffull) << 0;
  }
  static inline
  void unpack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] >> 9) & 0x7fffffffffffffull;
    destination[1]  = (source[0] << 46) & 0x7fffffffffffffull;
    destination[1] |= (source[1] >> 18) & 0x7fffffffffffffull;
    destination[2]  = (source[1] << 37) & 0x7fffffffffffffull;
    destination[2] |= (source[2] >> 27) & 0x7fffffffffffffull;
    destination[3]  = (source[2] << 28) & 0x7fffffffffffffull;
    destination[3] |= (source[3] >> 36) & 0x7fffffffffffffull;
    destination[4]  = (source[3] << 19) & 0x7fffffffffffffull;
    destination[4] |= (source[4] >> 45) & 0x7fffffffffffffull;
    destination[5]  = (source[4] << 10) & 0x7fffffffffffffull;
    destination[5] |= (source[5] >> 54) & 0x7fffffffffffffull;
    destination[6]  = (source[5] << 1) & 0x7fffffffffffffull;
    destination[6] |= (source[6] >> 63) & 0x7fffffffffffffull;
    destination[7]  = (source[6] >> 8) & 0x7fffffffffffffull;
    destination[8]  = (source[6] << 47) & 0x7fffffffffffffull;
    destination[8] |= (source[7] >> 17) & 0x7fffffffffffffull;
    destination[9]  = (source[7] << 38) & 0x7fffffffffffffull;
    destination[9] |= (source[8] >> 26) & 0x7fffffffffffffull;
    destination[10]  = (source[8] << 29) & 0x7fffffffffffffull;
    destination[10] |= (source[9] >> 35) & 0x7fffffffffffffull;
    destination[11]  = (source[9] << 20) & 0x7fffffffffffffull;
    destination[11] |= (source[10] >> 44) & 0x7fffffffffffffull;
    destination[12]  = (source[10] << 11) & 0x7fffffffffffffull;
    destination[12] |= (source[11] >> 53) & 0x7fffffffffffffull;
    destination[13]  = (source[11] << 2) & 0x7fffffffffffffull;
    destination[13] |= (source[12] >> 62) & 0x7fffffffffffffull;
    destination[14]  = (source[12] >> 7) & 0x7fffffffffffffull;
    destination[15]  = (source[12] << 48) & 0x7fffffffffffffull;
    destination[15] |= (source[13] >> 16) & 0x7fffffffffffffull;
    destination[16]  = (source[13] << 39) & 0x7fffffffffffffull;
    destination[16] |= (source[14] >> 25) & 0x7fffffffffffffull;
    destination[17]  = (source[14] << 30) & 0x7fffffffffffffull;
    destination[17] |= (source[15] >> 34) & 0x7fffffffffffffull;
    destination[18]  = (source[15] << 21) & 0x7fffffffffffffull;
    destination[18] |= (source[16] >> 43) & 0x7fffffffffffffull;
    destination[19]  = (source[16] << 12) & 0x7fffffffffffffull;
    destination[19] |= (source[17] >> 52) & 0x7fffffffffffffull;
    destination[20]  = (source[17] << 3) & 0x7fffffffffffffull;
    destination[20] |= (source[18] >> 61) & 0x7fffffffffffffull;
    destination[21]  = (source[18] >> 6) & 0x7fffffffffffffull;
    destination[22]  = (source[18] << 49) & 0x7fffffffffffffull;
    destination[22] |= (source[19] >> 15) & 0x7fffffffffffffull;
    destination[23]  = (source[19] << 40) & 0x7fffffffffffffull;
    destination[23] |= (source[20] >> 24) & 0x7fffffffffffffull;
    destination[24]  = (source[20] << 31) & 0x7fffffffffffffull;
    destination[24] |= (source[21] >> 33) & 0x7fffffffffffffull;
    destination[25]  = (source[21] << 22) & 0x7fffffffffffffull;
    destination[25] |= (source[22] >> 42) & 0x7fffffffffffffull;
    destination[26]  = (source[22] << 13) & 0x7fffffffffffffull;
    destination[26] |= (source[23] >> 51) & 0x7fffffffffffffull;
    destination[27]  = (source[23] << 4) & 0x7fffffffffffffull;
    destination[27] |= (source[24] >> 60) & 0x7fffffffffffffull;
    destination[28]  = (source[24] >> 5) & 0x7fffffffffffffull;
    destination[29]  = (source[24] << 50) & 0x7fffffffffffffull;
    destination[29] |= (source[25] >> 14) & 0x7fffffffffffffull;
    destination[30]  = (source[25] << 41) & 0x7fffffffffffffull;
    destination[30] |= (source[26] >> 23) & 0x7fffffffffffffull;
    destination[31]  = (source[26] << 32) & 0x7fffffffffffffull;
    destination[31] |= (source[27] >> 32) & 0x7fffffffffffffull;
    destination[32]  = (source[27] << 23) & 0x7fffffffffffffull;
    destination[32] |= (source[28] >> 41) & 0x7fffffffffffffull;
    destination[33]  = (source[28] << 14) & 0x7fffffffffffffull;
    destination[33] |= (source[29] >> 50) & 0x7fffffffffffffull;
    destination[34]  = (source[29] << 5) & 0x7fffffffffffffull;
    destination[34] |= (source[30] >> 59) & 0x7fffffffffffffull;
    destination[35]  = (source[30] >> 4) & 0x7fffffffffffffull;
    destination[36]  = (source[30] << 51) & 0x7fffffffffffffull;
    destination[36] |= (source[31] >> 13) & 0x7fffffffffffffull;
    destination[37]  = (source[31] << 42) & 0x7fffffffffffffull;
    destination[37] |= (source[32] >> 22) & 0x7fffffffffffffull;
    destination[38]  = (source[32] << 33) & 0x7fffffffffffffull;
    destination[38] |= (source[33] >> 31) & 0x7fffffffffffffull;
    destination[39]  = (source[33] << 24) & 0x7fffffffffffffull;
    destination[39] |= (source[34] >> 40) & 0x7fffffffffffffull;
    destination[40]  = (source[34] << 15) & 0x7fffffffffffffull;
    destination[40] |= (source[35] >> 49) & 0x7fffffffffffffull;
    destination[41]  = (source[35] << 6) & 0x7fffffffffffffull;
    destination[41] |= (source[36] >> 58) & 0x7fffffffffffffull;
    destination[42]  = (source[36] >> 3) & 0x7fffffffffffffull;
    destination[43]  = (source[36] << 52) & 0x7fffffffffffffull;
    destination[43] |= (source[37] >> 12) & 0x7fffffffffffffull;
    destination[44]  = (source[37] << 43) & 0x7fffffffffffffull;
    destination[44] |= (source[38] >> 21) & 0x7fffffffffffffull;
    destination[45]  = (source[38] << 34) & 0x7fffffffffffffull;
    destination[45] |= (source[39] >> 30) & 0x7fffffffffffffull;
    destination[46]  = (source[39] << 25) & 0x7fffffffffffffull;
    destination[46] |= (source[40] >> 39) & 0x7fffffffffffffull;
    destination[47]  = (source[40] << 16) & 0x7fffffffffffffull;
    destination[47] |= (source[41] >> 48) & 0x7fffffffffffffull;
    destination[48]  = (source[41] << 7) & 0x7fffffffffffffull;
    destination[48] |= (source[42] >> 57) & 0x7fffffffffffffull;
    destination[49]  = (source[42] >> 2) & 0x7fffffffffffffull;
    destination[50]  = (source[42] << 53) & 0x7fffffffffffffull;
    destination[50] |= (source[43] >> 11) & 0x7fffffffffffffull;
    destination[51]  = (source[43] << 44) & 0x7fffffffffffffull;
    destination[51] |= (source[44] >> 20) & 0x7fffffffffffffull;
    destination[52]  = (source[44] << 35) & 0x7fffffffffffffull;
    destination[52] |= (source[45] >> 29) & 0x7fffffffffffffull;
    destination[53]  = (source[45] << 26) & 0x7fffffffffffffull;
    destination[53] |= (source[46] >> 38) & 0x7fffffffffffffull;
    destination[54]  = (source[46] << 17) & 0x7fffffffffffffull;
    destination[54] |= (source[47] >> 47) & 0x7fffffffffffffull;
    destination[55]  = (source[47] << 8) & 0x7fffffffffffffull;
    destination[55] |= (source[48] >> 56) & 0x7fffffffffffffull;
    destination[56]  = (source[48] >> 1) & 0x7fffffffffffffull;
    destination[57]  = (source[48] << 54) & 0x7fffffffffffffull;
    destination[57] |= (source[49] >> 10) & 0x7fffffffffffffull;
    destination[58]  = (source[49] << 45) & 0x7fffffffffffffull;
    destination[58] |= (source[50] >> 19) & 0x7fffffffffffffull;
    destination[59]  = (source[50] << 36) & 0x7fffffffffffffull;
    destination[59] |= (source[51] >> 28) & 0x7fffffffffffffull;
    destination[60]  = (source[51] << 27) & 0x7fffffffffffffull;
    destination[60] |= (source[52] >> 37) & 0x7fffffffffffffull;
    destination[61]  = (source[52] << 18) & 0x7fffffffffffffull;
    destination[61] |= (source[53] >> 46) & 0x7fffffffffffffull;
    destination[62]  = (source[53] << 9) & 0x7fffffffffffffull;
    destination[62] |= (source[54] >> 55) & 0x7fffffffffffffull;
    destination[63]  = (source[54] >> 0) & 0x7fffffffffffffull;
  }
};
template <typename Tp>
struct __struct_bitpack_impl<Tp,8,56>
{
  static const size_t unit_size = 64;
  static const size_t bits_total = 3584;
  static const size_t loop_total = 64;
  static const size_t bit_size = 56;
  static const Tp     mask = 0xffffffffffffffull;
  static inline
  void pack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] & 0xffffffffffffffull) << 8;
    destination[0] |= (source[1] & 0xffffffffffffffull) >> 48;
    destination[1]  = (source[1] & 0xffffffffffffffull) << 16;
    destination[1] |= (source[2] & 0xffffffffffffffull) >> 40;
    destination[2]  = (source[2] & 0xffffffffffffffull) << 24;
    destination[2] |= (source[3] & 0xffffffffffffffull) >> 32;
    destination[3]  = (source[3] & 0xffffffffffffffull) << 32;
    destination[3] |= (source[4] & 0xffffffffffffffull) >> 24;
    destination[4]  = (source[4] & 0xffffffffffffffull) << 40;
    destination[4] |= (source[5] & 0xffffffffffffffull) >> 16;
    destination[5]  = (source[5] & 0xffffffffffffffull) << 48;
    destination[5] |= (source[6] & 0xffffffffffffffull) >> 8;
    destination[6]  = (source[6] & 0xffffffffffffffull) << 56;
    destination[6] |= (source[7] & 0xffffffffffffffull) << 0;
    destination[7]  = (source[8] & 0xffffffffffffffull) << 8;
    destination[7] |= (source[9] & 0xffffffffffffffull) >> 48;
    destination[8]  = (source[9] & 0xffffffffffffffull) << 16;
    destination[8] |= (source[10] & 0xffffffffffffffull) >> 40;
    destination[9]  = (source[10] & 0xffffffffffffffull) << 24;
    destination[9] |= (source[11] & 0xffffffffffffffull) >> 32;
    destination[10]  = (source[11] & 0xffffffffffffffull) << 32;
    destination[10] |= (source[12] & 0xffffffffffffffull) >> 24;
    destination[11]  = (source[12] & 0xffffffffffffffull) << 40;
    destination[11] |= (source[13] & 0xffffffffffffffull) >> 16;
    destination[12]  = (source[13] & 0xffffffffffffffull) << 48;
    destination[12] |= (source[14] & 0xffffffffffffffull) >> 8;
    destination[13]  = (source[14] & 0xffffffffffffffull) << 56;
    destination[13] |= (source[15] & 0xffffffffffffffull) << 0;
    destination[14]  = (source[16] & 0xffffffffffffffull) << 8;
    destination[14] |= (source[17] & 0xffffffffffffffull) >> 48;
    destination[15]  = (source[17] & 0xffffffffffffffull) << 16;
    destination[15] |= (source[18] & 0xffffffffffffffull) >> 40;
    destination[16]  = (source[18] & 0xffffffffffffffull) << 24;
    destination[16] |= (source[19] & 0xffffffffffffffull) >> 32;
    destination[17]  = (source[19] & 0xffffffffffffffull) << 32;
    destination[17] |= (source[20] & 0xffffffffffffffull) >> 24;
    destination[18]  = (source[20] & 0xffffffffffffffull) << 40;
    destination[18] |= (source[21] & 0xffffffffffffffull) >> 16;
    destination[19]  = (source[21] & 0xffffffffffffffull) << 48;
    destination[19] |= (source[22] & 0xffffffffffffffull) >> 8;
    destination[20]  = (source[22] & 0xffffffffffffffull) << 56;
    destination[20] |= (source[23] & 0xffffffffffffffull) << 0;
    destination[21]  = (source[24] & 0xffffffffffffffull) << 8;
    destination[21] |= (source[25] & 0xffffffffffffffull) >> 48;
    destination[22]  = (source[25] & 0xffffffffffffffull) << 16;
    destination[22] |= (source[26] & 0xffffffffffffffull) >> 40;
    destination[23]  = (source[26] & 0xffffffffffffffull) << 24;
    destination[23] |= (source[27] & 0xffffffffffffffull) >> 32;
    destination[24]  = (source[27] & 0xffffffffffffffull) << 32;
    destination[24] |= (source[28] & 0xffffffffffffffull) >> 24;
    destination[25]  = (source[28] & 0xffffffffffffffull) << 40;
    destination[25] |= (source[29] & 0xffffffffffffffull) >> 16;
    destination[26]  = (source[29] & 0xffffffffffffffull) << 48;
    destination[26] |= (source[30] & 0xffffffffffffffull) >> 8;
    destination[27]  = (source[30] & 0xffffffffffffffull) << 56;
    destination[27] |= (source[31] & 0xffffffffffffffull) << 0;
    destination[28]  = (source[32] & 0xffffffffffffffull) << 8;
    destination[28] |= (source[33] & 0xffffffffffffffull) >> 48;
    destination[29]  = (source[33] & 0xffffffffffffffull) << 16;
    destination[29] |= (source[34] & 0xffffffffffffffull) >> 40;
    destination[30]  = (source[34] & 0xffffffffffffffull) << 24;
    destination[30] |= (source[35] & 0xffffffffffffffull) >> 32;
    destination[31]  = (source[35] & 0xffffffffffffffull) << 32;
    destination[31] |= (source[36] & 0xffffffffffffffull) >> 24;
    destination[32]  = (source[36] & 0xffffffffffffffull) << 40;
    destination[32] |= (source[37] & 0xffffffffffffffull) >> 16;
    destination[33]  = (source[37] & 0xffffffffffffffull) << 48;
    destination[33] |= (source[38] & 0xffffffffffffffull) >> 8;
    destination[34]  = (source[38] & 0xffffffffffffffull) << 56;
    destination[34] |= (source[39] & 0xffffffffffffffull) << 0;
    destination[35]  = (source[40] & 0xffffffffffffffull) << 8;
    destination[35] |= (source[41] & 0xffffffffffffffull) >> 48;
    destination[36]  = (source[41] & 0xffffffffffffffull) << 16;
    destination[36] |= (source[42] & 0xffffffffffffffull) >> 40;
    destination[37]  = (source[42] & 0xffffffffffffffull) << 24;
    destination[37] |= (source[43] & 0xffffffffffffffull) >> 32;
    destination[38]  = (source[43] & 0xffffffffffffffull) << 32;
    destination[38] |= (source[44] & 0xffffffffffffffull) >> 24;
    destination[39]  = (source[44] & 0xffffffffffffffull) << 40;
    destination[39] |= (source[45] & 0xffffffffffffffull) >> 16;
    destination[40]  = (source[45] & 0xffffffffffffffull) << 48;
    destination[40] |= (source[46] & 0xffffffffffffffull) >> 8;
    destination[41]  = (source[46] & 0xffffffffffffffull) << 56;
    destination[41] |= (source[47] & 0xffffffffffffffull) << 0;
    destination[42]  = (source[48] & 0xffffffffffffffull) << 8;
    destination[42] |= (source[49] & 0xffffffffffffffull) >> 48;
    destination[43]  = (source[49] & 0xffffffffffffffull) << 16;
    destination[43] |= (source[50] & 0xffffffffffffffull) >> 40;
    destination[44]  = (source[50] & 0xffffffffffffffull) << 24;
    destination[44] |= (source[51] & 0xffffffffffffffull) >> 32;
    destination[45]  = (source[51] & 0xffffffffffffffull) << 32;
    destination[45] |= (source[52] & 0xffffffffffffffull) >> 24;
    destination[46]  = (source[52] & 0xffffffffffffffull) << 40;
    destination[46] |= (source[53] & 0xffffffffffffffull) >> 16;
    destination[47]  = (source[53] & 0xffffffffffffffull) << 48;
    destination[47] |= (source[54] & 0xffffffffffffffull) >> 8;
    destination[48]  = (source[54] & 0xffffffffffffffull) << 56;
    destination[48] |= (source[55] & 0xffffffffffffffull) << 0;
    destination[49]  = (source[56] & 0xffffffffffffffull) << 8;
    destination[49] |= (source[57] & 0xffffffffffffffull) >> 48;
    destination[50]  = (source[57] & 0xffffffffffffffull) << 16;
    destination[50] |= (source[58] & 0xffffffffffffffull) >> 40;
    destination[51]  = (source[58] & 0xffffffffffffffull) << 24;
    destination[51] |= (source[59] & 0xffffffffffffffull) >> 32;
    destination[52]  = (source[59] & 0xffffffffffffffull) << 32;
    destination[52] |= (source[60] & 0xffffffffffffffull) >> 24;
    destination[53]  = (source[60] & 0xffffffffffffffull) << 40;
    destination[53] |= (source[61] & 0xffffffffffffffull) >> 16;
    destination[54]  = (source[61] & 0xffffffffffffffull) << 48;
    destination[54] |= (source[62] & 0xffffffffffffffull) >> 8;
    destination[55]  = (source[62] & 0xffffffffffffffull) << 56;
    destination[55] |= (source[63] & 0xffffffffffffffull) << 0;
  }
  static inline
  void unpack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] >> 8) & 0xffffffffffffffull;
    destination[1]  = (source[0] << 48) & 0xffffffffffffffull;
    destination[1] |= (source[1] >> 16) & 0xffffffffffffffull;
    destination[2]  = (source[1] << 40) & 0xffffffffffffffull;
    destination[2] |= (source[2] >> 24) & 0xffffffffffffffull;
    destination[3]  = (source[2] << 32) & 0xffffffffffffffull;
    destination[3] |= (source[3] >> 32) & 0xffffffffffffffull;
    destination[4]  = (source[3] << 24) & 0xffffffffffffffull;
    destination[4] |= (source[4] >> 40) & 0xffffffffffffffull;
    destination[5]  = (source[4] << 16) & 0xffffffffffffffull;
    destination[5] |= (source[5] >> 48) & 0xffffffffffffffull;
    destination[6]  = (source[5] << 8) & 0xffffffffffffffull;
    destination[6] |= (source[6] >> 56) & 0xffffffffffffffull;
    destination[7]  = (source[6] >> 0) & 0xffffffffffffffull;
    destination[8]  = (source[7] >> 8) & 0xffffffffffffffull;
    destination[9]  = (source[7] << 48) & 0xffffffffffffffull;
    destination[9] |= (source[8] >> 16) & 0xffffffffffffffull;
    destination[10]  = (source[8] << 40) & 0xffffffffffffffull;
    destination[10] |= (source[9] >> 24) & 0xffffffffffffffull;
    destination[11]  = (source[9] << 32) & 0xffffffffffffffull;
    destination[11] |= (source[10] >> 32) & 0xffffffffffffffull;
    destination[12]  = (source[10] << 24) & 0xffffffffffffffull;
    destination[12] |= (source[11] >> 40) & 0xffffffffffffffull;
    destination[13]  = (source[11] << 16) & 0xffffffffffffffull;
    destination[13] |= (source[12] >> 48) & 0xffffffffffffffull;
    destination[14]  = (source[12] << 8) & 0xffffffffffffffull;
    destination[14] |= (source[13] >> 56) & 0xffffffffffffffull;
    destination[15]  = (source[13] >> 0) & 0xffffffffffffffull;
    destination[16]  = (source[14] >> 8) & 0xffffffffffffffull;
    destination[17]  = (source[14] << 48) & 0xffffffffffffffull;
    destination[17] |= (source[15] >> 16) & 0xffffffffffffffull;
    destination[18]  = (source[15] << 40) & 0xffffffffffffffull;
    destination[18] |= (source[16] >> 24) & 0xffffffffffffffull;
    destination[19]  = (source[16] << 32) & 0xffffffffffffffull;
    destination[19] |= (source[17] >> 32) & 0xffffffffffffffull;
    destination[20]  = (source[17] << 24) & 0xffffffffffffffull;
    destination[20] |= (source[18] >> 40) & 0xffffffffffffffull;
    destination[21]  = (source[18] << 16) & 0xffffffffffffffull;
    destination[21] |= (source[19] >> 48) & 0xffffffffffffffull;
    destination[22]  = (source[19] << 8) & 0xffffffffffffffull;
    destination[22] |= (source[20] >> 56) & 0xffffffffffffffull;
    destination[23]  = (source[20] >> 0) & 0xffffffffffffffull;
    destination[24]  = (source[21] >> 8) & 0xffffffffffffffull;
    destination[25]  = (source[21] << 48) & 0xffffffffffffffull;
    destination[25] |= (source[22] >> 16) & 0xffffffffffffffull;
    destination[26]  = (source[22] << 40) & 0xffffffffffffffull;
    destination[26] |= (source[23] >> 24) & 0xffffffffffffffull;
    destination[27]  = (source[23] << 32) & 0xffffffffffffffull;
    destination[27] |= (source[24] >> 32) & 0xffffffffffffffull;
    destination[28]  = (source[24] << 24) & 0xffffffffffffffull;
    destination[28] |= (source[25] >> 40) & 0xffffffffffffffull;
    destination[29]  = (source[25] << 16) & 0xffffffffffffffull;
    destination[29] |= (source[26] >> 48) & 0xffffffffffffffull;
    destination[30]  = (source[26] << 8) & 0xffffffffffffffull;
    destination[30] |= (source[27] >> 56) & 0xffffffffffffffull;
    destination[31]  = (source[27] >> 0) & 0xffffffffffffffull;
    destination[32]  = (source[28] >> 8) & 0xffffffffffffffull;
    destination[33]  = (source[28] << 48) & 0xffffffffffffffull;
    destination[33] |= (source[29] >> 16) & 0xffffffffffffffull;
    destination[34]  = (source[29] << 40) & 0xffffffffffffffull;
    destination[34] |= (source[30] >> 24) & 0xffffffffffffffull;
    destination[35]  = (source[30] << 32) & 0xffffffffffffffull;
    destination[35] |= (source[31] >> 32) & 0xffffffffffffffull;
    destination[36]  = (source[31] << 24) & 0xffffffffffffffull;
    destination[36] |= (source[32] >> 40) & 0xffffffffffffffull;
    destination[37]  = (source[32] << 16) & 0xffffffffffffffull;
    destination[37] |= (source[33] >> 48) & 0xffffffffffffffull;
    destination[38]  = (source[33] << 8) & 0xffffffffffffffull;
    destination[38] |= (source[34] >> 56) & 0xffffffffffffffull;
    destination[39]  = (source[34] >> 0) & 0xffffffffffffffull;
    destination[40]  = (source[35] >> 8) & 0xffffffffffffffull;
    destination[41]  = (source[35] << 48) & 0xffffffffffffffull;
    destination[41] |= (source[36] >> 16) & 0xffffffffffffffull;
    destination[42]  = (source[36] << 40) & 0xffffffffffffffull;
    destination[42] |= (source[37] >> 24) & 0xffffffffffffffull;
    destination[43]  = (source[37] << 32) & 0xffffffffffffffull;
    destination[43] |= (source[38] >> 32) & 0xffffffffffffffull;
    destination[44]  = (source[38] << 24) & 0xffffffffffffffull;
    destination[44] |= (source[39] >> 40) & 0xffffffffffffffull;
    destination[45]  = (source[39] << 16) & 0xffffffffffffffull;
    destination[45] |= (source[40] >> 48) & 0xffffffffffffffull;
    destination[46]  = (source[40] << 8) & 0xffffffffffffffull;
    destination[46] |= (source[41] >> 56) & 0xffffffffffffffull;
    destination[47]  = (source[41] >> 0) & 0xffffffffffffffull;
    destination[48]  = (source[42] >> 8) & 0xffffffffffffffull;
    destination[49]  = (source[42] << 48) & 0xffffffffffffffull;
    destination[49] |= (source[43] >> 16) & 0xffffffffffffffull;
    destination[50]  = (source[43] << 40) & 0xffffffffffffffull;
    destination[50] |= (source[44] >> 24) & 0xffffffffffffffull;
    destination[51]  = (source[44] << 32) & 0xffffffffffffffull;
    destination[51] |= (source[45] >> 32) & 0xffffffffffffffull;
    destination[52]  = (source[45] << 24) & 0xffffffffffffffull;
    destination[52] |= (source[46] >> 40) & 0xffffffffffffffull;
    destination[53]  = (source[46] << 16) & 0xffffffffffffffull;
    destination[53] |= (source[47] >> 48) & 0xffffffffffffffull;
    destination[54]  = (source[47] << 8) & 0xffffffffffffffull;
    destination[54] |= (source[48] >> 56) & 0xffffffffffffffull;
    destination[55]  = (source[48] >> 0) & 0xffffffffffffffull;
    destination[56]  = (source[49] >> 8) & 0xffffffffffffffull;
    destination[57]  = (source[49] << 48) & 0xffffffffffffffull;
    destination[57] |= (source[50] >> 16) & 0xffffffffffffffull;
    destination[58]  = (source[50] << 40) & 0xffffffffffffffull;
    destination[58] |= (source[51] >> 24) & 0xffffffffffffffull;
    destination[59]  = (source[51] << 32) & 0xffffffffffffffull;
    destination[59] |= (source[52] >> 32) & 0xffffffffffffffull;
    destination[60]  = (source[52] << 24) & 0xffffffffffffffull;
    destination[60] |= (source[53] >> 40) & 0xffffffffffffffull;
    destination[61]  = (source[53] << 16) & 0xffffffffffffffull;
    destination[61] |= (source[54] >> 48) & 0xffffffffffffffull;
    destination[62]  = (source[54] << 8) & 0xffffffffffffffull;
    destination[62] |= (source[55] >> 56) & 0xffffffffffffffull;
    destination[63]  = (source[55] >> 0) & 0xffffffffffffffull;
  }
};
template <typename Tp>
struct __struct_bitpack_impl<Tp,8,57>
{
  static const size_t unit_size = 64;
  static const size_t bits_total = 3648;
  static const size_t loop_total = 64;
  static const size_t bit_size = 57;
  static const Tp     mask = 0x1ffffffffffffffull;
  static inline
  void pack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] & 0x1ffffffffffffffull) << 7;
    destination[0] |= (source[1] & 0x1ffffffffffffffull) >> 50;
    destination[1]  = (source[1] & 0x1ffffffffffffffull) << 14;
    destination[1] |= (source[2] & 0x1ffffffffffffffull) >> 43;
    destination[2]  = (source[2] & 0x1ffffffffffffffull) << 21;
    destination[2] |= (source[3] & 0x1ffffffffffffffull) >> 36;
    destination[3]  = (source[3] & 0x1ffffffffffffffull) << 28;
    destination[3] |= (source[4] & 0x1ffffffffffffffull) >> 29;
    destination[4]  = (source[4] & 0x1ffffffffffffffull) << 35;
    destination[4] |= (source[5] & 0x1ffffffffffffffull) >> 22;
    destination[5]  = (source[5] & 0x1ffffffffffffffull) << 42;
    destination[5] |= (source[6] & 0x1ffffffffffffffull) >> 15;
    destination[6]  = (source[6] & 0x1ffffffffffffffull) << 49;
    destination[6] |= (source[7] & 0x1ffffffffffffffull) >> 8;
    destination[7]  = (source[7] & 0x1ffffffffffffffull) << 56;
    destination[7] |= (source[8] & 0x1ffffffffffffffull) >> 1;
    destination[8]  = (source[8] & 0x1ffffffffffffffull) << 63;
    destination[8] |= (source[9] & 0x1ffffffffffffffull) << 6;
    destination[8] |= (source[10] & 0x1ffffffffffffffull) >> 51;
    destination[9]  = (source[10] & 0x1ffffffffffffffull) << 13;
    destination[9] |= (source[11] & 0x1ffffffffffffffull) >> 44;
    destination[10]  = (source[11] & 0x1ffffffffffffffull) << 20;
    destination[10] |= (source[12] & 0x1ffffffffffffffull) >> 37;
    destination[11]  = (source[12] & 0x1ffffffffffffffull) << 27;
    destination[11] |= (source[13] & 0x1ffffffffffffffull) >> 30;
    destination[12]  = (source[13] & 0x1ffffffffffffffull) << 34;
    destination[12] |= (source[14] & 0x1ffffffffffffffull) >> 23;
    destination[13]  = (source[14] & 0x1ffffffffffffffull) << 41;
    destination[13] |= (source[15] & 0x1ffffffffffffffull) >> 16;
    destination[14]  = (source[15] & 0x1ffffffffffffffull) << 48;
    destination[14] |= (source[16] & 0x1ffffffffffffffull) >> 9;
    destination[15]  = (source[16] & 0x1ffffffffffffffull) << 55;
    destination[15] |= (source[17] & 0x1ffffffffffffffull) >> 2;
    destination[16]  = (source[17] & 0x1ffffffffffffffull) << 62;
    destination[16] |= (source[18] & 0x1ffffffffffffffull) << 5;
    destination[16] |= (source[19] & 0x1ffffffffffffffull) >> 52;
    destination[17]  = (source[19] & 0x1ffffffffffffffull) << 12;
    destination[17] |= (source[20] & 0x1ffffffffffffffull) >> 45;
    destination[18]  = (source[20] & 0x1ffffffffffffffull) << 19;
    destination[18] |= (source[21] & 0x1ffffffffffffffull) >> 38;
    destination[19]  = (source[21] & 0x1ffffffffffffffull) << 26;
    destination[19] |= (source[22] & 0x1ffffffffffffffull) >> 31;
    destination[20]  = (source[22] & 0x1ffffffffffffffull) << 33;
    destination[20] |= (source[23] & 0x1ffffffffffffffull) >> 24;
    destination[21]  = (source[23] & 0x1ffffffffffffffull) << 40;
    destination[21] |= (source[24] & 0x1ffffffffffffffull) >> 17;
    destination[22]  = (source[24] & 0x1ffffffffffffffull) << 47;
    destination[22] |= (source[25] & 0x1ffffffffffffffull) >> 10;
    destination[23]  = (source[25] & 0x1ffffffffffffffull) << 54;
    destination[23] |= (source[26] & 0x1ffffffffffffffull) >> 3;
    destination[24]  = (source[26] & 0x1ffffffffffffffull) << 61;
    destination[24] |= (source[27] & 0x1ffffffffffffffull) << 4;
    destination[24] |= (source[28] & 0x1ffffffffffffffull) >> 53;
    destination[25]  = (source[28] & 0x1ffffffffffffffull) << 11;
    destination[25] |= (source[29] & 0x1ffffffffffffffull) >> 46;
    destination[26]  = (source[29] & 0x1ffffffffffffffull) << 18;
    destination[26] |= (source[30] & 0x1ffffffffffffffull) >> 39;
    destination[27]  = (source[30] & 0x1ffffffffffffffull) << 25;
    destination[27] |= (source[31] & 0x1ffffffffffffffull) >> 32;
    destination[28]  = (source[31] & 0x1ffffffffffffffull) << 32;
    destination[28] |= (source[32] & 0x1ffffffffffffffull) >> 25;
    destination[29]  = (source[32] & 0x1ffffffffffffffull) << 39;
    destination[29] |= (source[33] & 0x1ffffffffffffffull) >> 18;
    destination[30]  = (source[33] & 0x1ffffffffffffffull) << 46;
    destination[30] |= (source[34] & 0x1ffffffffffffffull) >> 11;
    destination[31]  = (source[34] & 0x1ffffffffffffffull) << 53;
    destination[31] |= (source[35] & 0x1ffffffffffffffull) >> 4;
    destination[32]  = (source[35] & 0x1ffffffffffffffull) << 60;
    destination[32] |= (source[36] & 0x1ffffffffffffffull) << 3;
    destination[32] |= (source[37] & 0x1ffffffffffffffull) >> 54;
    destination[33]  = (source[37] & 0x1ffffffffffffffull) << 10;
    destination[33] |= (source[38] & 0x1ffffffffffffffull) >> 47;
    destination[34]  = (source[38] & 0x1ffffffffffffffull) << 17;
    destination[34] |= (source[39] & 0x1ffffffffffffffull) >> 40;
    destination[35]  = (source[39] & 0x1ffffffffffffffull) << 24;
    destination[35] |= (source[40] & 0x1ffffffffffffffull) >> 33;
    destination[36]  = (source[40] & 0x1ffffffffffffffull) << 31;
    destination[36] |= (source[41] & 0x1ffffffffffffffull) >> 26;
    destination[37]  = (source[41] & 0x1ffffffffffffffull) << 38;
    destination[37] |= (source[42] & 0x1ffffffffffffffull) >> 19;
    destination[38]  = (source[42] & 0x1ffffffffffffffull) << 45;
    destination[38] |= (source[43] & 0x1ffffffffffffffull) >> 12;
    destination[39]  = (source[43] & 0x1ffffffffffffffull) << 52;
    destination[39] |= (source[44] & 0x1ffffffffffffffull) >> 5;
    destination[40]  = (source[44] & 0x1ffffffffffffffull) << 59;
    destination[40] |= (source[45] & 0x1ffffffffffffffull) << 2;
    destination[40] |= (source[46] & 0x1ffffffffffffffull) >> 55;
    destination[41]  = (source[46] & 0x1ffffffffffffffull) << 9;
    destination[41] |= (source[47] & 0x1ffffffffffffffull) >> 48;
    destination[42]  = (source[47] & 0x1ffffffffffffffull) << 16;
    destination[42] |= (source[48] & 0x1ffffffffffffffull) >> 41;
    destination[43]  = (source[48] & 0x1ffffffffffffffull) << 23;
    destination[43] |= (source[49] & 0x1ffffffffffffffull) >> 34;
    destination[44]  = (source[49] & 0x1ffffffffffffffull) << 30;
    destination[44] |= (source[50] & 0x1ffffffffffffffull) >> 27;
    destination[45]  = (source[50] & 0x1ffffffffffffffull) << 37;
    destination[45] |= (source[51] & 0x1ffffffffffffffull) >> 20;
    destination[46]  = (source[51] & 0x1ffffffffffffffull) << 44;
    destination[46] |= (source[52] & 0x1ffffffffffffffull) >> 13;
    destination[47]  = (source[52] & 0x1ffffffffffffffull) << 51;
    destination[47] |= (source[53] & 0x1ffffffffffffffull) >> 6;
    destination[48]  = (source[53] & 0x1ffffffffffffffull) << 58;
    destination[48] |= (source[54] & 0x1ffffffffffffffull) << 1;
    destination[48] |= (source[55] & 0x1ffffffffffffffull) >> 56;
    destination[49]  = (source[55] & 0x1ffffffffffffffull) << 8;
    destination[49] |= (source[56] & 0x1ffffffffffffffull) >> 49;
    destination[50]  = (source[56] & 0x1ffffffffffffffull) << 15;
    destination[50] |= (source[57] & 0x1ffffffffffffffull) >> 42;
    destination[51]  = (source[57] & 0x1ffffffffffffffull) << 22;
    destination[51] |= (source[58] & 0x1ffffffffffffffull) >> 35;
    destination[52]  = (source[58] & 0x1ffffffffffffffull) << 29;
    destination[52] |= (source[59] & 0x1ffffffffffffffull) >> 28;
    destination[53]  = (source[59] & 0x1ffffffffffffffull) << 36;
    destination[53] |= (source[60] & 0x1ffffffffffffffull) >> 21;
    destination[54]  = (source[60] & 0x1ffffffffffffffull) << 43;
    destination[54] |= (source[61] & 0x1ffffffffffffffull) >> 14;
    destination[55]  = (source[61] & 0x1ffffffffffffffull) << 50;
    destination[55] |= (source[62] & 0x1ffffffffffffffull) >> 7;
    destination[56]  = (source[62] & 0x1ffffffffffffffull) << 57;
    destination[56] |= (source[63] & 0x1ffffffffffffffull) << 0;
  }
  static inline
  void unpack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] >> 7) & 0x1ffffffffffffffull;
    destination[1]  = (source[0] << 50) & 0x1ffffffffffffffull;
    destination[1] |= (source[1] >> 14) & 0x1ffffffffffffffull;
    destination[2]  = (source[1] << 43) & 0x1ffffffffffffffull;
    destination[2] |= (source[2] >> 21) & 0x1ffffffffffffffull;
    destination[3]  = (source[2] << 36) & 0x1ffffffffffffffull;
    destination[3] |= (source[3] >> 28) & 0x1ffffffffffffffull;
    destination[4]  = (source[3] << 29) & 0x1ffffffffffffffull;
    destination[4] |= (source[4] >> 35) & 0x1ffffffffffffffull;
    destination[5]  = (source[4] << 22) & 0x1ffffffffffffffull;
    destination[5] |= (source[5] >> 42) & 0x1ffffffffffffffull;
    destination[6]  = (source[5] << 15) & 0x1ffffffffffffffull;
    destination[6] |= (source[6] >> 49) & 0x1ffffffffffffffull;
    destination[7]  = (source[6] << 8) & 0x1ffffffffffffffull;
    destination[7] |= (source[7] >> 56) & 0x1ffffffffffffffull;
    destination[8]  = (source[7] << 1) & 0x1ffffffffffffffull;
    destination[8] |= (source[8] >> 63) & 0x1ffffffffffffffull;
    destination[9]  = (source[8] >> 6) & 0x1ffffffffffffffull;
    destination[10]  = (source[8] << 51) & 0x1ffffffffffffffull;
    destination[10] |= (source[9] >> 13) & 0x1ffffffffffffffull;
    destination[11]  = (source[9] << 44) & 0x1ffffffffffffffull;
    destination[11] |= (source[10] >> 20) & 0x1ffffffffffffffull;
    destination[12]  = (source[10] << 37) & 0x1ffffffffffffffull;
    destination[12] |= (source[11] >> 27) & 0x1ffffffffffffffull;
    destination[13]  = (source[11] << 30) & 0x1ffffffffffffffull;
    destination[13] |= (source[12] >> 34) & 0x1ffffffffffffffull;
    destination[14]  = (source[12] << 23) & 0x1ffffffffffffffull;
    destination[14] |= (source[13] >> 41) & 0x1ffffffffffffffull;
    destination[15]  = (source[13] << 16) & 0x1ffffffffffffffull;
    destination[15] |= (source[14] >> 48) & 0x1ffffffffffffffull;
    destination[16]  = (source[14] << 9) & 0x1ffffffffffffffull;
    destination[16] |= (source[15] >> 55) & 0x1ffffffffffffffull;
    destination[17]  = (source[15] << 2) & 0x1ffffffffffffffull;
    destination[17] |= (source[16] >> 62) & 0x1ffffffffffffffull;
    destination[18]  = (source[16] >> 5) & 0x1ffffffffffffffull;
    destination[19]  = (source[16] << 52) & 0x1ffffffffffffffull;
    destination[19] |= (source[17] >> 12) & 0x1ffffffffffffffull;
    destination[20]  = (source[17] << 45) & 0x1ffffffffffffffull;
    destination[20] |= (source[18] >> 19) & 0x1ffffffffffffffull;
    destination[21]  = (source[18] << 38) & 0x1ffffffffffffffull;
    destination[21] |= (source[19] >> 26) & 0x1ffffffffffffffull;
    destination[22]  = (source[19] << 31) & 0x1ffffffffffffffull;
    destination[22] |= (source[20] >> 33) & 0x1ffffffffffffffull;
    destination[23]  = (source[20] << 24) & 0x1ffffffffffffffull;
    destination[23] |= (source[21] >> 40) & 0x1ffffffffffffffull;
    destination[24]  = (source[21] << 17) & 0x1ffffffffffffffull;
    destination[24] |= (source[22] >> 47) & 0x1ffffffffffffffull;
    destination[25]  = (source[22] << 10) & 0x1ffffffffffffffull;
    destination[25] |= (source[23] >> 54) & 0x1ffffffffffffffull;
    destination[26]  = (source[23] << 3) & 0x1ffffffffffffffull;
    destination[26] |= (source[24] >> 61) & 0x1ffffffffffffffull;
    destination[27]  = (source[24] >> 4) & 0x1ffffffffffffffull;
    destination[28]  = (source[24] << 53) & 0x1ffffffffffffffull;
    destination[28] |= (source[25] >> 11) & 0x1ffffffffffffffull;
    destination[29]  = (source[25] << 46) & 0x1ffffffffffffffull;
    destination[29] |= (source[26] >> 18) & 0x1ffffffffffffffull;
    destination[30]  = (source[26] << 39) & 0x1ffffffffffffffull;
    destination[30] |= (source[27] >> 25) & 0x1ffffffffffffffull;
    destination[31]  = (source[27] << 32) & 0x1ffffffffffffffull;
    destination[31] |= (source[28] >> 32) & 0x1ffffffffffffffull;
    destination[32]  = (source[28] << 25) & 0x1ffffffffffffffull;
    destination[32] |= (source[29] >> 39) & 0x1ffffffffffffffull;
    destination[33]  = (source[29] << 18) & 0x1ffffffffffffffull;
    destination[33] |= (source[30] >> 46) & 0x1ffffffffffffffull;
    destination[34]  = (source[30] << 11) & 0x1ffffffffffffffull;
    destination[34] |= (source[31] >> 53) & 0x1ffffffffffffffull;
    destination[35]  = (source[31] << 4) & 0x1ffffffffffffffull;
    destination[35] |= (source[32] >> 60) & 0x1ffffffffffffffull;
    destination[36]  = (source[32] >> 3) & 0x1ffffffffffffffull;
    destination[37]  = (source[32] << 54) & 0x1ffffffffffffffull;
    destination[37] |= (source[33] >> 10) & 0x1ffffffffffffffull;
    destination[38]  = (source[33] << 47) & 0x1ffffffffffffffull;
    destination[38] |= (source[34] >> 17) & 0x1ffffffffffffffull;
    destination[39]  = (source[34] << 40) & 0x1ffffffffffffffull;
    destination[39] |= (source[35] >> 24) & 0x1ffffffffffffffull;
    destination[40]  = (source[35] << 33) & 0x1ffffffffffffffull;
    destination[40] |= (source[36] >> 31) & 0x1ffffffffffffffull;
    destination[41]  = (source[36] << 26) & 0x1ffffffffffffffull;
    destination[41] |= (source[37] >> 38) & 0x1ffffffffffffffull;
    destination[42]  = (source[37] << 19) & 0x1ffffffffffffffull;
    destination[42] |= (source[38] >> 45) & 0x1ffffffffffffffull;
    destination[43]  = (source[38] << 12) & 0x1ffffffffffffffull;
    destination[43] |= (source[39] >> 52) & 0x1ffffffffffffffull;
    destination[44]  = (source[39] << 5) & 0x1ffffffffffffffull;
    destination[44] |= (source[40] >> 59) & 0x1ffffffffffffffull;
    destination[45]  = (source[40] >> 2) & 0x1ffffffffffffffull;
    destination[46]  = (source[40] << 55) & 0x1ffffffffffffffull;
    destination[46] |= (source[41] >> 9) & 0x1ffffffffffffffull;
    destination[47]  = (source[41] << 48) & 0x1ffffffffffffffull;
    destination[47] |= (source[42] >> 16) & 0x1ffffffffffffffull;
    destination[48]  = (source[42] << 41) & 0x1ffffffffffffffull;
    destination[48] |= (source[43] >> 23) & 0x1ffffffffffffffull;
    destination[49]  = (source[43] << 34) & 0x1ffffffffffffffull;
    destination[49] |= (source[44] >> 30) & 0x1ffffffffffffffull;
    destination[50]  = (source[44] << 27) & 0x1ffffffffffffffull;
    destination[50] |= (source[45] >> 37) & 0x1ffffffffffffffull;
    destination[51]  = (source[45] << 20) & 0x1ffffffffffffffull;
    destination[51] |= (source[46] >> 44) & 0x1ffffffffffffffull;
    destination[52]  = (source[46] << 13) & 0x1ffffffffffffffull;
    destination[52] |= (source[47] >> 51) & 0x1ffffffffffffffull;
    destination[53]  = (source[47] << 6) & 0x1ffffffffffffffull;
    destination[53] |= (source[48] >> 58) & 0x1ffffffffffffffull;
    destination[54]  = (source[48] >> 1) & 0x1ffffffffffffffull;
    destination[55]  = (source[48] << 56) & 0x1ffffffffffffffull;
    destination[55] |= (source[49] >> 8) & 0x1ffffffffffffffull;
    destination[56]  = (source[49] << 49) & 0x1ffffffffffffffull;
    destination[56] |= (source[50] >> 15) & 0x1ffffffffffffffull;
    destination[57]  = (source[50] << 42) & 0x1ffffffffffffffull;
    destination[57] |= (source[51] >> 22) & 0x1ffffffffffffffull;
    destination[58]  = (source[51] << 35) & 0x1ffffffffffffffull;
    destination[58] |= (source[52] >> 29) & 0x1ffffffffffffffull;
    destination[59]  = (source[52] << 28) & 0x1ffffffffffffffull;
    destination[59] |= (source[53] >> 36) & 0x1ffffffffffffffull;
    destination[60]  = (source[53] << 21) & 0x1ffffffffffffffull;
    destination[60] |= (source[54] >> 43) & 0x1ffffffffffffffull;
    destination[61]  = (source[54] << 14) & 0x1ffffffffffffffull;
    destination[61] |= (source[55] >> 50) & 0x1ffffffffffffffull;
    destination[62]  = (source[55] << 7) & 0x1ffffffffffffffull;
    destination[62] |= (source[56] >> 57) & 0x1ffffffffffffffull;
    destination[63]  = (source[56] >> 0) & 0x1ffffffffffffffull;
  }
};
template <typename Tp>
struct __struct_bitpack_impl<Tp,8,58>
{
  static const size_t unit_size = 64;
  static const size_t bits_total = 3712;
  static const size_t loop_total = 64;
  static const size_t bit_size = 58;
  static const Tp     mask = 0x3ffffffffffffffull;
  static inline
  void pack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] & 0x3ffffffffffffffull) << 6;
    destination[0] |= (source[1] & 0x3ffffffffffffffull) >> 52;
    destination[1]  = (source[1] & 0x3ffffffffffffffull) << 12;
    destination[1] |= (source[2] & 0x3ffffffffffffffull) >> 46;
    destination[2]  = (source[2] & 0x3ffffffffffffffull) << 18;
    destination[2] |= (source[3] & 0x3ffffffffffffffull) >> 40;
    destination[3]  = (source[3] & 0x3ffffffffffffffull) << 24;
    destination[3] |= (source[4] & 0x3ffffffffffffffull) >> 34;
    destination[4]  = (source[4] & 0x3ffffffffffffffull) << 30;
    destination[4] |= (source[5] & 0x3ffffffffffffffull) >> 28;
    destination[5]  = (source[5] & 0x3ffffffffffffffull) << 36;
    destination[5] |= (source[6] & 0x3ffffffffffffffull) >> 22;
    destination[6]  = (source[6] & 0x3ffffffffffffffull) << 42;
    destination[6] |= (source[7] & 0x3ffffffffffffffull) >> 16;
    destination[7]  = (source[7] & 0x3ffffffffffffffull) << 48;
    destination[7] |= (source[8] & 0x3ffffffffffffffull) >> 10;
    destination[8]  = (source[8] & 0x3ffffffffffffffull) << 54;
    destination[8] |= (source[9] & 0x3ffffffffffffffull) >> 4;
    destination[9]  = (source[9] & 0x3ffffffffffffffull) << 60;
    destination[9] |= (source[10] & 0x3ffffffffffffffull) << 2;
    destination[9] |= (source[11] & 0x3ffffffffffffffull) >> 56;
    destination[10]  = (source[11] & 0x3ffffffffffffffull) << 8;
    destination[10] |= (source[12] & 0x3ffffffffffffffull) >> 50;
    destination[11]  = (source[12] & 0x3ffffffffffffffull) << 14;
    destination[11] |= (source[13] & 0x3ffffffffffffffull) >> 44;
    destination[12]  = (source[13] & 0x3ffffffffffffffull) << 20;
    destination[12] |= (source[14] & 0x3ffffffffffffffull) >> 38;
    destination[13]  = (source[14] & 0x3ffffffffffffffull) << 26;
    destination[13] |= (source[15] & 0x3ffffffffffffffull) >> 32;
    destination[14]  = (source[15] & 0x3ffffffffffffffull) << 32;
    destination[14] |= (source[16] & 0x3ffffffffffffffull) >> 26;
    destination[15]  = (source[16] & 0x3ffffffffffffffull) << 38;
    destination[15] |= (source[17] & 0x3ffffffffffffffull) >> 20;
    destination[16]  = (source[17] & 0x3ffffffffffffffull) << 44;
    destination[16] |= (source[18] & 0x3ffffffffffffffull) >> 14;
    destination[17]  = (source[18] & 0x3ffffffffffffffull) << 50;
    destination[17] |= (source[19] & 0x3ffffffffffffffull) >> 8;
    destination[18]  = (source[19] & 0x3ffffffffffffffull) << 56;
    destination[18] |= (source[20] & 0x3ffffffffffffffull) >> 2;
    destination[19]  = (source[20] & 0x3ffffffffffffffull) << 62;
    destination[19] |= (source[21] & 0x3ffffffffffffffull) << 4;
    destination[19] |= (source[22] & 0x3ffffffffffffffull) >> 54;
    destination[20]  = (source[22] & 0x3ffffffffffffffull) << 10;
    destination[20] |= (source[23] & 0x3ffffffffffffffull) >> 48;
    destination[21]  = (source[23] & 0x3ffffffffffffffull) << 16;
    destination[21] |= (source[24] & 0x3ffffffffffffffull) >> 42;
    destination[22]  = (source[24] & 0x3ffffffffffffffull) << 22;
    destination[22] |= (source[25] & 0x3ffffffffffffffull) >> 36;
    destination[23]  = (source[25] & 0x3ffffffffffffffull) << 28;
    destination[23] |= (source[26] & 0x3ffffffffffffffull) >> 30;
    destination[24]  = (source[26] & 0x3ffffffffffffffull) << 34;
    destination[24] |= (source[27] & 0x3ffffffffffffffull) >> 24;
    destination[25]  = (source[27] & 0x3ffffffffffffffull) << 40;
    destination[25] |= (source[28] & 0x3ffffffffffffffull) >> 18;
    destination[26]  = (source[28] & 0x3ffffffffffffffull) << 46;
    destination[26] |= (source[29] & 0x3ffffffffffffffull) >> 12;
    destination[27]  = (source[29] & 0x3ffffffffffffffull) << 52;
    destination[27] |= (source[30] & 0x3ffffffffffffffull) >> 6;
    destination[28]  = (source[30] & 0x3ffffffffffffffull) << 58;
    destination[28] |= (source[31] & 0x3ffffffffffffffull) << 0;
    destination[29]  = (source[32] & 0x3ffffffffffffffull) << 6;
    destination[29] |= (source[33] & 0x3ffffffffffffffull) >> 52;
    destination[30]  = (source[33] & 0x3ffffffffffffffull) << 12;
    destination[30] |= (source[34] & 0x3ffffffffffffffull) >> 46;
    destination[31]  = (source[34] & 0x3ffffffffffffffull) << 18;
    destination[31] |= (source[35] & 0x3ffffffffffffffull) >> 40;
    destination[32]  = (source[35] & 0x3ffffffffffffffull) << 24;
    destination[32] |= (source[36] & 0x3ffffffffffffffull) >> 34;
    destination[33]  = (source[36] & 0x3ffffffffffffffull) << 30;
    destination[33] |= (source[37] & 0x3ffffffffffffffull) >> 28;
    destination[34]  = (source[37] & 0x3ffffffffffffffull) << 36;
    destination[34] |= (source[38] & 0x3ffffffffffffffull) >> 22;
    destination[35]  = (source[38] & 0x3ffffffffffffffull) << 42;
    destination[35] |= (source[39] & 0x3ffffffffffffffull) >> 16;
    destination[36]  = (source[39] & 0x3ffffffffffffffull) << 48;
    destination[36] |= (source[40] & 0x3ffffffffffffffull) >> 10;
    destination[37]  = (source[40] & 0x3ffffffffffffffull) << 54;
    destination[37] |= (source[41] & 0x3ffffffffffffffull) >> 4;
    destination[38]  = (source[41] & 0x3ffffffffffffffull) << 60;
    destination[38] |= (source[42] & 0x3ffffffffffffffull) << 2;
    destination[38] |= (source[43] & 0x3ffffffffffffffull) >> 56;
    destination[39]  = (source[43] & 0x3ffffffffffffffull) << 8;
    destination[39] |= (source[44] & 0x3ffffffffffffffull) >> 50;
    destination[40]  = (source[44] & 0x3ffffffffffffffull) << 14;
    destination[40] |= (source[45] & 0x3ffffffffffffffull) >> 44;
    destination[41]  = (source[45] & 0x3ffffffffffffffull) << 20;
    destination[41] |= (source[46] & 0x3ffffffffffffffull) >> 38;
    destination[42]  = (source[46] & 0x3ffffffffffffffull) << 26;
    destination[42] |= (source[47] & 0x3ffffffffffffffull) >> 32;
    destination[43]  = (source[47] & 0x3ffffffffffffffull) << 32;
    destination[43] |= (source[48] & 0x3ffffffffffffffull) >> 26;
    destination[44]  = (source[48] & 0x3ffffffffffffffull) << 38;
    destination[44] |= (source[49] & 0x3ffffffffffffffull) >> 20;
    destination[45]  = (source[49] & 0x3ffffffffffffffull) << 44;
    destination[45] |= (source[50] & 0x3ffffffffffffffull) >> 14;
    destination[46]  = (source[50] & 0x3ffffffffffffffull) << 50;
    destination[46] |= (source[51] & 0x3ffffffffffffffull) >> 8;
    destination[47]  = (source[51] & 0x3ffffffffffffffull) << 56;
    destination[47] |= (source[52] & 0x3ffffffffffffffull) >> 2;
    destination[48]  = (source[52] & 0x3ffffffffffffffull) << 62;
    destination[48] |= (source[53] & 0x3ffffffffffffffull) << 4;
    destination[48] |= (source[54] & 0x3ffffffffffffffull) >> 54;
    destination[49]  = (source[54] & 0x3ffffffffffffffull) << 10;
    destination[49] |= (source[55] & 0x3ffffffffffffffull) >> 48;
    destination[50]  = (source[55] & 0x3ffffffffffffffull) << 16;
    destination[50] |= (source[56] & 0x3ffffffffffffffull) >> 42;
    destination[51]  = (source[56] & 0x3ffffffffffffffull) << 22;
    destination[51] |= (source[57] & 0x3ffffffffffffffull) >> 36;
    destination[52]  = (source[57] & 0x3ffffffffffffffull) << 28;
    destination[52] |= (source[58] & 0x3ffffffffffffffull) >> 30;
    destination[53]  = (source[58] & 0x3ffffffffffffffull) << 34;
    destination[53] |= (source[59] & 0x3ffffffffffffffull) >> 24;
    destination[54]  = (source[59] & 0x3ffffffffffffffull) << 40;
    destination[54] |= (source[60] & 0x3ffffffffffffffull) >> 18;
    destination[55]  = (source[60] & 0x3ffffffffffffffull) << 46;
    destination[55] |= (source[61] & 0x3ffffffffffffffull) >> 12;
    destination[56]  = (source[61] & 0x3ffffffffffffffull) << 52;
    destination[56] |= (source[62] & 0x3ffffffffffffffull) >> 6;
    destination[57]  = (source[62] & 0x3ffffffffffffffull) << 58;
    destination[57] |= (source[63] & 0x3ffffffffffffffull) << 0;
  }
  static inline
  void unpack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] >> 6) & 0x3ffffffffffffffull;
    destination[1]  = (source[0] << 52) & 0x3ffffffffffffffull;
    destination[1] |= (source[1] >> 12) & 0x3ffffffffffffffull;
    destination[2]  = (source[1] << 46) & 0x3ffffffffffffffull;
    destination[2] |= (source[2] >> 18) & 0x3ffffffffffffffull;
    destination[3]  = (source[2] << 40) & 0x3ffffffffffffffull;
    destination[3] |= (source[3] >> 24) & 0x3ffffffffffffffull;
    destination[4]  = (source[3] << 34) & 0x3ffffffffffffffull;
    destination[4] |= (source[4] >> 30) & 0x3ffffffffffffffull;
    destination[5]  = (source[4] << 28) & 0x3ffffffffffffffull;
    destination[5] |= (source[5] >> 36) & 0x3ffffffffffffffull;
    destination[6]  = (source[5] << 22) & 0x3ffffffffffffffull;
    destination[6] |= (source[6] >> 42) & 0x3ffffffffffffffull;
    destination[7]  = (source[6] << 16) & 0x3ffffffffffffffull;
    destination[7] |= (source[7] >> 48) & 0x3ffffffffffffffull;
    destination[8]  = (source[7] << 10) & 0x3ffffffffffffffull;
    destination[8] |= (source[8] >> 54) & 0x3ffffffffffffffull;
    destination[9]  = (source[8] << 4) & 0x3ffffffffffffffull;
    destination[9] |= (source[9] >> 60) & 0x3ffffffffffffffull;
    destination[10]  = (source[9] >> 2) & 0x3ffffffffffffffull;
    destination[11]  = (source[9] << 56) & 0x3ffffffffffffffull;
    destination[11] |= (source[10] >> 8) & 0x3ffffffffffffffull;
    destination[12]  = (source[10] << 50) & 0x3ffffffffffffffull;
    destination[12] |= (source[11] >> 14) & 0x3ffffffffffffffull;
    destination[13]  = (source[11] << 44) & 0x3ffffffffffffffull;
    destination[13] |= (source[12] >> 20) & 0x3ffffffffffffffull;
    destination[14]  = (source[12] << 38) & 0x3ffffffffffffffull;
    destination[14] |= (source[13] >> 26) & 0x3ffffffffffffffull;
    destination[15]  = (source[13] << 32) & 0x3ffffffffffffffull;
    destination[15] |= (source[14] >> 32) & 0x3ffffffffffffffull;
    destination[16]  = (source[14] << 26) & 0x3ffffffffffffffull;
    destination[16] |= (source[15] >> 38) & 0x3ffffffffffffffull;
    destination[17]  = (source[15] << 20) & 0x3ffffffffffffffull;
    destination[17] |= (source[16] >> 44) & 0x3ffffffffffffffull;
    destination[18]  = (source[16] << 14) & 0x3ffffffffffffffull;
    destination[18] |= (source[17] >> 50) & 0x3ffffffffffffffull;
    destination[19]  = (source[17] << 8) & 0x3ffffffffffffffull;
    destination[19] |= (source[18] >> 56) & 0x3ffffffffffffffull;
    destination[20]  = (source[18] << 2) & 0x3ffffffffffffffull;
    destination[20] |= (source[19] >> 62) & 0x3ffffffffffffffull;
    destination[21]  = (source[19] >> 4) & 0x3ffffffffffffffull;
    destination[22]  = (source[19] << 54) & 0x3ffffffffffffffull;
    destination[22] |= (source[20] >> 10) & 0x3ffffffffffffffull;
    destination[23]  = (source[20] << 48) & 0x3ffffffffffffffull;
    destination[23] |= (source[21] >> 16) & 0x3ffffffffffffffull;
    destination[24]  = (source[21] << 42) & 0x3ffffffffffffffull;
    destination[24] |= (source[22] >> 22) & 0x3ffffffffffffffull;
    destination[25]  = (source[22] << 36) & 0x3ffffffffffffffull;
    destination[25] |= (source[23] >> 28) & 0x3ffffffffffffffull;
    destination[26]  = (source[23] << 30) & 0x3ffffffffffffffull;
    destination[26] |= (source[24] >> 34) & 0x3ffffffffffffffull;
    destination[27]  = (source[24] << 24) & 0x3ffffffffffffffull;
    destination[27] |= (source[25] >> 40) & 0x3ffffffffffffffull;
    destination[28]  = (source[25] << 18) & 0x3ffffffffffffffull;
    destination[28] |= (source[26] >> 46) & 0x3ffffffffffffffull;
    destination[29]  = (source[26] << 12) & 0x3ffffffffffffffull;
    destination[29] |= (source[27] >> 52) & 0x3ffffffffffffffull;
    destination[30]  = (source[27] << 6) & 0x3ffffffffffffffull;
    destination[30] |= (source[28] >> 58) & 0x3ffffffffffffffull;
    destination[31]  = (source[28] >> 0) & 0x3ffffffffffffffull;
    destination[32]  = (source[29] >> 6) & 0x3ffffffffffffffull;
    destination[33]  = (source[29] << 52) & 0x3ffffffffffffffull;
    destination[33] |= (source[30] >> 12) & 0x3ffffffffffffffull;
    destination[34]  = (source[30] << 46) & 0x3ffffffffffffffull;
    destination[34] |= (source[31] >> 18) & 0x3ffffffffffffffull;
    destination[35]  = (source[31] << 40) & 0x3ffffffffffffffull;
    destination[35] |= (source[32] >> 24) & 0x3ffffffffffffffull;
    destination[36]  = (source[32] << 34) & 0x3ffffffffffffffull;
    destination[36] |= (source[33] >> 30) & 0x3ffffffffffffffull;
    destination[37]  = (source[33] << 28) & 0x3ffffffffffffffull;
    destination[37] |= (source[34] >> 36) & 0x3ffffffffffffffull;
    destination[38]  = (source[34] << 22) & 0x3ffffffffffffffull;
    destination[38] |= (source[35] >> 42) & 0x3ffffffffffffffull;
    destination[39]  = (source[35] << 16) & 0x3ffffffffffffffull;
    destination[39] |= (source[36] >> 48) & 0x3ffffffffffffffull;
    destination[40]  = (source[36] << 10) & 0x3ffffffffffffffull;
    destination[40] |= (source[37] >> 54) & 0x3ffffffffffffffull;
    destination[41]  = (source[37] << 4) & 0x3ffffffffffffffull;
    destination[41] |= (source[38] >> 60) & 0x3ffffffffffffffull;
    destination[42]  = (source[38] >> 2) & 0x3ffffffffffffffull;
    destination[43]  = (source[38] << 56) & 0x3ffffffffffffffull;
    destination[43] |= (source[39] >> 8) & 0x3ffffffffffffffull;
    destination[44]  = (source[39] << 50) & 0x3ffffffffffffffull;
    destination[44] |= (source[40] >> 14) & 0x3ffffffffffffffull;
    destination[45]  = (source[40] << 44) & 0x3ffffffffffffffull;
    destination[45] |= (source[41] >> 20) & 0x3ffffffffffffffull;
    destination[46]  = (source[41] << 38) & 0x3ffffffffffffffull;
    destination[46] |= (source[42] >> 26) & 0x3ffffffffffffffull;
    destination[47]  = (source[42] << 32) & 0x3ffffffffffffffull;
    destination[47] |= (source[43] >> 32) & 0x3ffffffffffffffull;
    destination[48]  = (source[43] << 26) & 0x3ffffffffffffffull;
    destination[48] |= (source[44] >> 38) & 0x3ffffffffffffffull;
    destination[49]  = (source[44] << 20) & 0x3ffffffffffffffull;
    destination[49] |= (source[45] >> 44) & 0x3ffffffffffffffull;
    destination[50]  = (source[45] << 14) & 0x3ffffffffffffffull;
    destination[50] |= (source[46] >> 50) & 0x3ffffffffffffffull;
    destination[51]  = (source[46] << 8) & 0x3ffffffffffffffull;
    destination[51] |= (source[47] >> 56) & 0x3ffffffffffffffull;
    destination[52]  = (source[47] << 2) & 0x3ffffffffffffffull;
    destination[52] |= (source[48] >> 62) & 0x3ffffffffffffffull;
    destination[53]  = (source[48] >> 4) & 0x3ffffffffffffffull;
    destination[54]  = (source[48] << 54) & 0x3ffffffffffffffull;
    destination[54] |= (source[49] >> 10) & 0x3ffffffffffffffull;
    destination[55]  = (source[49] << 48) & 0x3ffffffffffffffull;
    destination[55] |= (source[50] >> 16) & 0x3ffffffffffffffull;
    destination[56]  = (source[50] << 42) & 0x3ffffffffffffffull;
    destination[56] |= (source[51] >> 22) & 0x3ffffffffffffffull;
    destination[57]  = (source[51] << 36) & 0x3ffffffffffffffull;
    destination[57] |= (source[52] >> 28) & 0x3ffffffffffffffull;
    destination[58]  = (source[52] << 30) & 0x3ffffffffffffffull;
    destination[58] |= (source[53] >> 34) & 0x3ffffffffffffffull;
    destination[59]  = (source[53] << 24) & 0x3ffffffffffffffull;
    destination[59] |= (source[54] >> 40) & 0x3ffffffffffffffull;
    destination[60]  = (source[54] << 18) & 0x3ffffffffffffffull;
    destination[60] |= (source[55] >> 46) & 0x3ffffffffffffffull;
    destination[61]  = (source[55] << 12) & 0x3ffffffffffffffull;
    destination[61] |= (source[56] >> 52) & 0x3ffffffffffffffull;
    destination[62]  = (source[56] << 6) & 0x3ffffffffffffffull;
    destination[62] |= (source[57] >> 58) & 0x3ffffffffffffffull;
    destination[63]  = (source[57] >> 0) & 0x3ffffffffffffffull;
  }
};
template <typename Tp>
struct __struct_bitpack_impl<Tp,8,59>
{
  static const size_t unit_size = 64;
  static const size_t bits_total = 3776;
  static const size_t loop_total = 64;
  static const size_t bit_size = 59;
  static const Tp     mask = 0x7ffffffffffffffull;
  static inline
  void pack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] & 0x7ffffffffffffffull) << 5;
    destination[0] |= (source[1] & 0x7ffffffffffffffull) >> 54;
    destination[1]  = (source[1] & 0x7ffffffffffffffull) << 10;
    destination[1] |= (source[2] & 0x7ffffffffffffffull) >> 49;
    destination[2]  = (source[2] & 0x7ffffffffffffffull) << 15;
    destination[2] |= (source[3] & 0x7ffffffffffffffull) >> 44;
    destination[3]  = (source[3] & 0x7ffffffffffffffull) << 20;
    destination[3] |= (source[4] & 0x7ffffffffffffffull) >> 39;
    destination[4]  = (source[4] & 0x7ffffffffffffffull) << 25;
    destination[4] |= (source[5] & 0x7ffffffffffffffull) >> 34;
    destination[5]  = (source[5] & 0x7ffffffffffffffull) << 30;
    destination[5] |= (source[6] & 0x7ffffffffffffffull) >> 29;
    destination[6]  = (source[6] & 0x7ffffffffffffffull) << 35;
    destination[6] |= (source[7] & 0x7ffffffffffffffull) >> 24;
    destination[7]  = (source[7] & 0x7ffffffffffffffull) << 40;
    destination[7] |= (source[8] & 0x7ffffffffffffffull) >> 19;
    destination[8]  = (source[8] & 0x7ffffffffffffffull) << 45;
    destination[8] |= (source[9] & 0x7ffffffffffffffull) >> 14;
    destination[9]  = (source[9] & 0x7ffffffffffffffull) << 50;
    destination[9] |= (source[10] & 0x7ffffffffffffffull) >> 9;
    destination[10]  = (source[10] & 0x7ffffffffffffffull) << 55;
    destination[10] |= (source[11] & 0x7ffffffffffffffull) >> 4;
    destination[11]  = (source[11] & 0x7ffffffffffffffull) << 60;
    destination[11] |= (source[12] & 0x7ffffffffffffffull) << 1;
    destination[11] |= (source[13] & 0x7ffffffffffffffull) >> 58;
    destination[12]  = (source[13] & 0x7ffffffffffffffull) << 6;
    destination[12] |= (source[14] & 0x7ffffffffffffffull) >> 53;
    destination[13]  = (source[14] & 0x7ffffffffffffffull) << 11;
    destination[13] |= (source[15] & 0x7ffffffffffffffull) >> 48;
    destination[14]  = (source[15] & 0x7ffffffffffffffull) << 16;
    destination[14] |= (source[16] & 0x7ffffffffffffffull) >> 43;
    destination[15]  = (source[16] & 0x7ffffffffffffffull) << 21;
    destination[15] |= (source[17] & 0x7ffffffffffffffull) >> 38;
    destination[16]  = (source[17] & 0x7ffffffffffffffull) << 26;
    destination[16] |= (source[18] & 0x7ffffffffffffffull) >> 33;
    destination[17]  = (source[18] & 0x7ffffffffffffffull) << 31;
    destination[17] |= (source[19] & 0x7ffffffffffffffull) >> 28;
    destination[18]  = (source[19] & 0x7ffffffffffffffull) << 36;
    destination[18] |= (source[20] & 0x7ffffffffffffffull) >> 23;
    destination[19]  = (source[20] & 0x7ffffffffffffffull) << 41;
    destination[19] |= (source[21] & 0x7ffffffffffffffull) >> 18;
    destination[20]  = (source[21] & 0x7ffffffffffffffull) << 46;
    destination[20] |= (source[22] & 0x7ffffffffffffffull) >> 13;
    destination[21]  = (source[22] & 0x7ffffffffffffffull) << 51;
    destination[21] |= (source[23] & 0x7ffffffffffffffull) >> 8;
    destination[22]  = (source[23] & 0x7ffffffffffffffull) << 56;
    destination[22] |= (source[24] & 0x7ffffffffffffffull) >> 3;
    destination[23]  = (source[24] & 0x7ffffffffffffffull) << 61;
    destination[23] |= (source[25] & 0x7ffffffffffffffull) << 2;
    destination[23] |= (source[26] & 0x7ffffffffffffffull) >> 57;
    destination[24]  = (source[26] & 0x7ffffffffffffffull) << 7;
    destination[24] |= (source[27] & 0x7ffffffffffffffull) >> 52;
    destination[25]  = (source[27] & 0x7ffffffffffffffull) << 12;
    destination[25] |= (source[28] & 0x7ffffffffffffffull) >> 47;
    destination[26]  = (source[28] & 0x7ffffffffffffffull) << 17;
    destination[26] |= (source[29] & 0x7ffffffffffffffull) >> 42;
    destination[27]  = (source[29] & 0x7ffffffffffffffull) << 22;
    destination[27] |= (source[30] & 0x7ffffffffffffffull) >> 37;
    destination[28]  = (source[30] & 0x7ffffffffffffffull) << 27;
    destination[28] |= (source[31] & 0x7ffffffffffffffull) >> 32;
    destination[29]  = (source[31] & 0x7ffffffffffffffull) << 32;
    destination[29] |= (source[32] & 0x7ffffffffffffffull) >> 27;
    destination[30]  = (source[32] & 0x7ffffffffffffffull) << 37;
    destination[30] |= (source[33] & 0x7ffffffffffffffull) >> 22;
    destination[31]  = (source[33] & 0x7ffffffffffffffull) << 42;
    destination[31] |= (source[34] & 0x7ffffffffffffffull) >> 17;
    destination[32]  = (source[34] & 0x7ffffffffffffffull) << 47;
    destination[32] |= (source[35] & 0x7ffffffffffffffull) >> 12;
    destination[33]  = (source[35] & 0x7ffffffffffffffull) << 52;
    destination[33] |= (source[36] & 0x7ffffffffffffffull) >> 7;
    destination[34]  = (source[36] & 0x7ffffffffffffffull) << 57;
    destination[34] |= (source[37] & 0x7ffffffffffffffull) >> 2;
    destination[35]  = (source[37] & 0x7ffffffffffffffull) << 62;
    destination[35] |= (source[38] & 0x7ffffffffffffffull) << 3;
    destination[35] |= (source[39] & 0x7ffffffffffffffull) >> 56;
    destination[36]  = (source[39] & 0x7ffffffffffffffull) << 8;
    destination[36] |= (source[40] & 0x7ffffffffffffffull) >> 51;
    destination[37]  = (source[40] & 0x7ffffffffffffffull) << 13;
    destination[37] |= (source[41] & 0x7ffffffffffffffull) >> 46;
    destination[38]  = (source[41] & 0x7ffffffffffffffull) << 18;
    destination[38] |= (source[42] & 0x7ffffffffffffffull) >> 41;
    destination[39]  = (source[42] & 0x7ffffffffffffffull) << 23;
    destination[39] |= (source[43] & 0x7ffffffffffffffull) >> 36;
    destination[40]  = (source[43] & 0x7ffffffffffffffull) << 28;
    destination[40] |= (source[44] & 0x7ffffffffffffffull) >> 31;
    destination[41]  = (source[44] & 0x7ffffffffffffffull) << 33;
    destination[41] |= (source[45] & 0x7ffffffffffffffull) >> 26;
    destination[42]  = (source[45] & 0x7ffffffffffffffull) << 38;
    destination[42] |= (source[46] & 0x7ffffffffffffffull) >> 21;
    destination[43]  = (source[46] & 0x7ffffffffffffffull) << 43;
    destination[43] |= (source[47] & 0x7ffffffffffffffull) >> 16;
    destination[44]  = (source[47] & 0x7ffffffffffffffull) << 48;
    destination[44] |= (source[48] & 0x7ffffffffffffffull) >> 11;
    destination[45]  = (source[48] & 0x7ffffffffffffffull) << 53;
    destination[45] |= (source[49] & 0x7ffffffffffffffull) >> 6;
    destination[46]  = (source[49] & 0x7ffffffffffffffull) << 58;
    destination[46] |= (source[50] & 0x7ffffffffffffffull) >> 1;
    destination[47]  = (source[50] & 0x7ffffffffffffffull) << 63;
    destination[47] |= (source[51] & 0x7ffffffffffffffull) << 4;
    destination[47] |= (source[52] & 0x7ffffffffffffffull) >> 55;
    destination[48]  = (source[52] & 0x7ffffffffffffffull) << 9;
    destination[48] |= (source[53] & 0x7ffffffffffffffull) >> 50;
    destination[49]  = (source[53] & 0x7ffffffffffffffull) << 14;
    destination[49] |= (source[54] & 0x7ffffffffffffffull) >> 45;
    destination[50]  = (source[54] & 0x7ffffffffffffffull) << 19;
    destination[50] |= (source[55] & 0x7ffffffffffffffull) >> 40;
    destination[51]  = (source[55] & 0x7ffffffffffffffull) << 24;
    destination[51] |= (source[56] & 0x7ffffffffffffffull) >> 35;
    destination[52]  = (source[56] & 0x7ffffffffffffffull) << 29;
    destination[52] |= (source[57] & 0x7ffffffffffffffull) >> 30;
    destination[53]  = (source[57] & 0x7ffffffffffffffull) << 34;
    destination[53] |= (source[58] & 0x7ffffffffffffffull) >> 25;
    destination[54]  = (source[58] & 0x7ffffffffffffffull) << 39;
    destination[54] |= (source[59] & 0x7ffffffffffffffull) >> 20;
    destination[55]  = (source[59] & 0x7ffffffffffffffull) << 44;
    destination[55] |= (source[60] & 0x7ffffffffffffffull) >> 15;
    destination[56]  = (source[60] & 0x7ffffffffffffffull) << 49;
    destination[56] |= (source[61] & 0x7ffffffffffffffull) >> 10;
    destination[57]  = (source[61] & 0x7ffffffffffffffull) << 54;
    destination[57] |= (source[62] & 0x7ffffffffffffffull) >> 5;
    destination[58]  = (source[62] & 0x7ffffffffffffffull) << 59;
    destination[58] |= (source[63] & 0x7ffffffffffffffull) << 0;
  }
  static inline
  void unpack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] >> 5) & 0x7ffffffffffffffull;
    destination[1]  = (source[0] << 54) & 0x7ffffffffffffffull;
    destination[1] |= (source[1] >> 10) & 0x7ffffffffffffffull;
    destination[2]  = (source[1] << 49) & 0x7ffffffffffffffull;
    destination[2] |= (source[2] >> 15) & 0x7ffffffffffffffull;
    destination[3]  = (source[2] << 44) & 0x7ffffffffffffffull;
    destination[3] |= (source[3] >> 20) & 0x7ffffffffffffffull;
    destination[4]  = (source[3] << 39) & 0x7ffffffffffffffull;
    destination[4] |= (source[4] >> 25) & 0x7ffffffffffffffull;
    destination[5]  = (source[4] << 34) & 0x7ffffffffffffffull;
    destination[5] |= (source[5] >> 30) & 0x7ffffffffffffffull;
    destination[6]  = (source[5] << 29) & 0x7ffffffffffffffull;
    destination[6] |= (source[6] >> 35) & 0x7ffffffffffffffull;
    destination[7]  = (source[6] << 24) & 0x7ffffffffffffffull;
    destination[7] |= (source[7] >> 40) & 0x7ffffffffffffffull;
    destination[8]  = (source[7] << 19) & 0x7ffffffffffffffull;
    destination[8] |= (source[8] >> 45) & 0x7ffffffffffffffull;
    destination[9]  = (source[8] << 14) & 0x7ffffffffffffffull;
    destination[9] |= (source[9] >> 50) & 0x7ffffffffffffffull;
    destination[10]  = (source[9] << 9) & 0x7ffffffffffffffull;
    destination[10] |= (source[10] >> 55) & 0x7ffffffffffffffull;
    destination[11]  = (source[10] << 4) & 0x7ffffffffffffffull;
    destination[11] |= (source[11] >> 60) & 0x7ffffffffffffffull;
    destination[12]  = (source[11] >> 1) & 0x7ffffffffffffffull;
    destination[13]  = (source[11] << 58) & 0x7ffffffffffffffull;
    destination[13] |= (source[12] >> 6) & 0x7ffffffffffffffull;
    destination[14]  = (source[12] << 53) & 0x7ffffffffffffffull;
    destination[14] |= (source[13] >> 11) & 0x7ffffffffffffffull;
    destination[15]  = (source[13] << 48) & 0x7ffffffffffffffull;
    destination[15] |= (source[14] >> 16) & 0x7ffffffffffffffull;
    destination[16]  = (source[14] << 43) & 0x7ffffffffffffffull;
    destination[16] |= (source[15] >> 21) & 0x7ffffffffffffffull;
    destination[17]  = (source[15] << 38) & 0x7ffffffffffffffull;
    destination[17] |= (source[16] >> 26) & 0x7ffffffffffffffull;
    destination[18]  = (source[16] << 33) & 0x7ffffffffffffffull;
    destination[18] |= (source[17] >> 31) & 0x7ffffffffffffffull;
    destination[19]  = (source[17] << 28) & 0x7ffffffffffffffull;
    destination[19] |= (source[18] >> 36) & 0x7ffffffffffffffull;
    destination[20]  = (source[18] << 23) & 0x7ffffffffffffffull;
    destination[20] |= (source[19] >> 41) & 0x7ffffffffffffffull;
    destination[21]  = (source[19] << 18) & 0x7ffffffffffffffull;
    destination[21] |= (source[20] >> 46) & 0x7ffffffffffffffull;
    destination[22]  = (source[20] << 13) & 0x7ffffffffffffffull;
    destination[22] |= (source[21] >> 51) & 0x7ffffffffffffffull;
    destination[23]  = (source[21] << 8) & 0x7ffffffffffffffull;
    destination[23] |= (source[22] >> 56) & 0x7ffffffffffffffull;
    destination[24]  = (source[22] << 3) & 0x7ffffffffffffffull;
    destination[24] |= (source[23] >> 61) & 0x7ffffffffffffffull;
    destination[25]  = (source[23] >> 2) & 0x7ffffffffffffffull;
    destination[26]  = (source[23] << 57) & 0x7ffffffffffffffull;
    destination[26] |= (source[24] >> 7) & 0x7ffffffffffffffull;
    destination[27]  = (source[24] << 52) & 0x7ffffffffffffffull;
    destination[27] |= (source[25] >> 12) & 0x7ffffffffffffffull;
    destination[28]  = (source[25] << 47) & 0x7ffffffffffffffull;
    destination[28] |= (source[26] >> 17) & 0x7ffffffffffffffull;
    destination[29]  = (source[26] << 42) & 0x7ffffffffffffffull;
    destination[29] |= (source[27] >> 22) & 0x7ffffffffffffffull;
    destination[30]  = (source[27] << 37) & 0x7ffffffffffffffull;
    destination[30] |= (source[28] >> 27) & 0x7ffffffffffffffull;
    destination[31]  = (source[28] << 32) & 0x7ffffffffffffffull;
    destination[31] |= (source[29] >> 32) & 0x7ffffffffffffffull;
    destination[32]  = (source[29] << 27) & 0x7ffffffffffffffull;
    destination[32] |= (source[30] >> 37) & 0x7ffffffffffffffull;
    destination[33]  = (source[30] << 22) & 0x7ffffffffffffffull;
    destination[33] |= (source[31] >> 42) & 0x7ffffffffffffffull;
    destination[34]  = (source[31] << 17) & 0x7ffffffffffffffull;
    destination[34] |= (source[32] >> 47) & 0x7ffffffffffffffull;
    destination[35]  = (source[32] << 12) & 0x7ffffffffffffffull;
    destination[35] |= (source[33] >> 52) & 0x7ffffffffffffffull;
    destination[36]  = (source[33] << 7) & 0x7ffffffffffffffull;
    destination[36] |= (source[34] >> 57) & 0x7ffffffffffffffull;
    destination[37]  = (source[34] << 2) & 0x7ffffffffffffffull;
    destination[37] |= (source[35] >> 62) & 0x7ffffffffffffffull;
    destination[38]  = (source[35] >> 3) & 0x7ffffffffffffffull;
    destination[39]  = (source[35] << 56) & 0x7ffffffffffffffull;
    destination[39] |= (source[36] >> 8) & 0x7ffffffffffffffull;
    destination[40]  = (source[36] << 51) & 0x7ffffffffffffffull;
    destination[40] |= (source[37] >> 13) & 0x7ffffffffffffffull;
    destination[41]  = (source[37] << 46) & 0x7ffffffffffffffull;
    destination[41] |= (source[38] >> 18) & 0x7ffffffffffffffull;
    destination[42]  = (source[38] << 41) & 0x7ffffffffffffffull;
    destination[42] |= (source[39] >> 23) & 0x7ffffffffffffffull;
    destination[43]  = (source[39] << 36) & 0x7ffffffffffffffull;
    destination[43] |= (source[40] >> 28) & 0x7ffffffffffffffull;
    destination[44]  = (source[40] << 31) & 0x7ffffffffffffffull;
    destination[44] |= (source[41] >> 33) & 0x7ffffffffffffffull;
    destination[45]  = (source[41] << 26) & 0x7ffffffffffffffull;
    destination[45] |= (source[42] >> 38) & 0x7ffffffffffffffull;
    destination[46]  = (source[42] << 21) & 0x7ffffffffffffffull;
    destination[46] |= (source[43] >> 43) & 0x7ffffffffffffffull;
    destination[47]  = (source[43] << 16) & 0x7ffffffffffffffull;
    destination[47] |= (source[44] >> 48) & 0x7ffffffffffffffull;
    destination[48]  = (source[44] << 11) & 0x7ffffffffffffffull;
    destination[48] |= (source[45] >> 53) & 0x7ffffffffffffffull;
    destination[49]  = (source[45] << 6) & 0x7ffffffffffffffull;
    destination[49] |= (source[46] >> 58) & 0x7ffffffffffffffull;
    destination[50]  = (source[46] << 1) & 0x7ffffffffffffffull;
    destination[50] |= (source[47] >> 63) & 0x7ffffffffffffffull;
    destination[51]  = (source[47] >> 4) & 0x7ffffffffffffffull;
    destination[52]  = (source[47] << 55) & 0x7ffffffffffffffull;
    destination[52] |= (source[48] >> 9) & 0x7ffffffffffffffull;
    destination[53]  = (source[48] << 50) & 0x7ffffffffffffffull;
    destination[53] |= (source[49] >> 14) & 0x7ffffffffffffffull;
    destination[54]  = (source[49] << 45) & 0x7ffffffffffffffull;
    destination[54] |= (source[50] >> 19) & 0x7ffffffffffffffull;
    destination[55]  = (source[50] << 40) & 0x7ffffffffffffffull;
    destination[55] |= (source[51] >> 24) & 0x7ffffffffffffffull;
    destination[56]  = (source[51] << 35) & 0x7ffffffffffffffull;
    destination[56] |= (source[52] >> 29) & 0x7ffffffffffffffull;
    destination[57]  = (source[52] << 30) & 0x7ffffffffffffffull;
    destination[57] |= (source[53] >> 34) & 0x7ffffffffffffffull;
    destination[58]  = (source[53] << 25) & 0x7ffffffffffffffull;
    destination[58] |= (source[54] >> 39) & 0x7ffffffffffffffull;
    destination[59]  = (source[54] << 20) & 0x7ffffffffffffffull;
    destination[59] |= (source[55] >> 44) & 0x7ffffffffffffffull;
    destination[60]  = (source[55] << 15) & 0x7ffffffffffffffull;
    destination[60] |= (source[56] >> 49) & 0x7ffffffffffffffull;
    destination[61]  = (source[56] << 10) & 0x7ffffffffffffffull;
    destination[61] |= (source[57] >> 54) & 0x7ffffffffffffffull;
    destination[62]  = (source[57] << 5) & 0x7ffffffffffffffull;
    destination[62] |= (source[58] >> 59) & 0x7ffffffffffffffull;
    destination[63]  = (source[58] >> 0) & 0x7ffffffffffffffull;
  }
};
template <typename Tp>
struct __struct_bitpack_impl<Tp,8,60>
{
  static const size_t unit_size = 64;
  static const size_t bits_total = 3840;
  static const size_t loop_total = 64;
  static const size_t bit_size = 60;
  static const Tp     mask = 0xfffffffffffffffull;
  static inline
  void pack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] & 0xfffffffffffffffull) << 4;
    destination[0] |= (source[1] & 0xfffffffffffffffull) >> 56;
    destination[1]  = (source[1] & 0xfffffffffffffffull) << 8;
    destination[1] |= (source[2] & 0xfffffffffffffffull) >> 52;
    destination[2]  = (source[2] & 0xfffffffffffffffull) << 12;
    destination[2] |= (source[3] & 0xfffffffffffffffull) >> 48;
    destination[3]  = (source[3] & 0xfffffffffffffffull) << 16;
    destination[3] |= (source[4] & 0xfffffffffffffffull) >> 44;
    destination[4]  = (source[4] & 0xfffffffffffffffull) << 20;
    destination[4] |= (source[5] & 0xfffffffffffffffull) >> 40;
    destination[5]  = (source[5] & 0xfffffffffffffffull) << 24;
    destination[5] |= (source[6] & 0xfffffffffffffffull) >> 36;
    destination[6]  = (source[6] & 0xfffffffffffffffull) << 28;
    destination[6] |= (source[7] & 0xfffffffffffffffull) >> 32;
    destination[7]  = (source[7] & 0xfffffffffffffffull) << 32;
    destination[7] |= (source[8] & 0xfffffffffffffffull) >> 28;
    destination[8]  = (source[8] & 0xfffffffffffffffull) << 36;
    destination[8] |= (source[9] & 0xfffffffffffffffull) >> 24;
    destination[9]  = (source[9] & 0xfffffffffffffffull) << 40;
    destination[9] |= (source[10] & 0xfffffffffffffffull) >> 20;
    destination[10]  = (source[10] & 0xfffffffffffffffull) << 44;
    destination[10] |= (source[11] & 0xfffffffffffffffull) >> 16;
    destination[11]  = (source[11] & 0xfffffffffffffffull) << 48;
    destination[11] |= (source[12] & 0xfffffffffffffffull) >> 12;
    destination[12]  = (source[12] & 0xfffffffffffffffull) << 52;
    destination[12] |= (source[13] & 0xfffffffffffffffull) >> 8;
    destination[13]  = (source[13] & 0xfffffffffffffffull) << 56;
    destination[13] |= (source[14] & 0xfffffffffffffffull) >> 4;
    destination[14]  = (source[14] & 0xfffffffffffffffull) << 60;
    destination[14] |= (source[15] & 0xfffffffffffffffull) << 0;
    destination[15]  = (source[16] & 0xfffffffffffffffull) << 4;
    destination[15] |= (source[17] & 0xfffffffffffffffull) >> 56;
    destination[16]  = (source[17] & 0xfffffffffffffffull) << 8;
    destination[16] |= (source[18] & 0xfffffffffffffffull) >> 52;
    destination[17]  = (source[18] & 0xfffffffffffffffull) << 12;
    destination[17] |= (source[19] & 0xfffffffffffffffull) >> 48;
    destination[18]  = (source[19] & 0xfffffffffffffffull) << 16;
    destination[18] |= (source[20] & 0xfffffffffffffffull) >> 44;
    destination[19]  = (source[20] & 0xfffffffffffffffull) << 20;
    destination[19] |= (source[21] & 0xfffffffffffffffull) >> 40;
    destination[20]  = (source[21] & 0xfffffffffffffffull) << 24;
    destination[20] |= (source[22] & 0xfffffffffffffffull) >> 36;
    destination[21]  = (source[22] & 0xfffffffffffffffull) << 28;
    destination[21] |= (source[23] & 0xfffffffffffffffull) >> 32;
    destination[22]  = (source[23] & 0xfffffffffffffffull) << 32;
    destination[22] |= (source[24] & 0xfffffffffffffffull) >> 28;
    destination[23]  = (source[24] & 0xfffffffffffffffull) << 36;
    destination[23] |= (source[25] & 0xfffffffffffffffull) >> 24;
    destination[24]  = (source[25] & 0xfffffffffffffffull) << 40;
    destination[24] |= (source[26] & 0xfffffffffffffffull) >> 20;
    destination[25]  = (source[26] & 0xfffffffffffffffull) << 44;
    destination[25] |= (source[27] & 0xfffffffffffffffull) >> 16;
    destination[26]  = (source[27] & 0xfffffffffffffffull) << 48;
    destination[26] |= (source[28] & 0xfffffffffffffffull) >> 12;
    destination[27]  = (source[28] & 0xfffffffffffffffull) << 52;
    destination[27] |= (source[29] & 0xfffffffffffffffull) >> 8;
    destination[28]  = (source[29] & 0xfffffffffffffffull) << 56;
    destination[28] |= (source[30] & 0xfffffffffffffffull) >> 4;
    destination[29]  = (source[30] & 0xfffffffffffffffull) << 60;
    destination[29] |= (source[31] & 0xfffffffffffffffull) << 0;
    destination[30]  = (source[32] & 0xfffffffffffffffull) << 4;
    destination[30] |= (source[33] & 0xfffffffffffffffull) >> 56;
    destination[31]  = (source[33] & 0xfffffffffffffffull) << 8;
    destination[31] |= (source[34] & 0xfffffffffffffffull) >> 52;
    destination[32]  = (source[34] & 0xfffffffffffffffull) << 12;
    destination[32] |= (source[35] & 0xfffffffffffffffull) >> 48;
    destination[33]  = (source[35] & 0xfffffffffffffffull) << 16;
    destination[33] |= (source[36] & 0xfffffffffffffffull) >> 44;
    destination[34]  = (source[36] & 0xfffffffffffffffull) << 20;
    destination[34] |= (source[37] & 0xfffffffffffffffull) >> 40;
    destination[35]  = (source[37] & 0xfffffffffffffffull) << 24;
    destination[35] |= (source[38] & 0xfffffffffffffffull) >> 36;
    destination[36]  = (source[38] & 0xfffffffffffffffull) << 28;
    destination[36] |= (source[39] & 0xfffffffffffffffull) >> 32;
    destination[37]  = (source[39] & 0xfffffffffffffffull) << 32;
    destination[37] |= (source[40] & 0xfffffffffffffffull) >> 28;
    destination[38]  = (source[40] & 0xfffffffffffffffull) << 36;
    destination[38] |= (source[41] & 0xfffffffffffffffull) >> 24;
    destination[39]  = (source[41] & 0xfffffffffffffffull) << 40;
    destination[39] |= (source[42] & 0xfffffffffffffffull) >> 20;
    destination[40]  = (source[42] & 0xfffffffffffffffull) << 44;
    destination[40] |= (source[43] & 0xfffffffffffffffull) >> 16;
    destination[41]  = (source[43] & 0xfffffffffffffffull) << 48;
    destination[41] |= (source[44] & 0xfffffffffffffffull) >> 12;
    destination[42]  = (source[44] & 0xfffffffffffffffull) << 52;
    destination[42] |= (source[45] & 0xfffffffffffffffull) >> 8;
    destination[43]  = (source[45] & 0xfffffffffffffffull) << 56;
    destination[43] |= (source[46] & 0xfffffffffffffffull) >> 4;
    destination[44]  = (source[46] & 0xfffffffffffffffull) << 60;
    destination[44] |= (source[47] & 0xfffffffffffffffull) << 0;
    destination[45]  = (source[48] & 0xfffffffffffffffull) << 4;
    destination[45] |= (source[49] & 0xfffffffffffffffull) >> 56;
    destination[46]  = (source[49] & 0xfffffffffffffffull) << 8;
    destination[46] |= (source[50] & 0xfffffffffffffffull) >> 52;
    destination[47]  = (source[50] & 0xfffffffffffffffull) << 12;
    destination[47] |= (source[51] & 0xfffffffffffffffull) >> 48;
    destination[48]  = (source[51] & 0xfffffffffffffffull) << 16;
    destination[48] |= (source[52] & 0xfffffffffffffffull) >> 44;
    destination[49]  = (source[52] & 0xfffffffffffffffull) << 20;
    destination[49] |= (source[53] & 0xfffffffffffffffull) >> 40;
    destination[50]  = (source[53] & 0xfffffffffffffffull) << 24;
    destination[50] |= (source[54] & 0xfffffffffffffffull) >> 36;
    destination[51]  = (source[54] & 0xfffffffffffffffull) << 28;
    destination[51] |= (source[55] & 0xfffffffffffffffull) >> 32;
    destination[52]  = (source[55] & 0xfffffffffffffffull) << 32;
    destination[52] |= (source[56] & 0xfffffffffffffffull) >> 28;
    destination[53]  = (source[56] & 0xfffffffffffffffull) << 36;
    destination[53] |= (source[57] & 0xfffffffffffffffull) >> 24;
    destination[54]  = (source[57] & 0xfffffffffffffffull) << 40;
    destination[54] |= (source[58] & 0xfffffffffffffffull) >> 20;
    destination[55]  = (source[58] & 0xfffffffffffffffull) << 44;
    destination[55] |= (source[59] & 0xfffffffffffffffull) >> 16;
    destination[56]  = (source[59] & 0xfffffffffffffffull) << 48;
    destination[56] |= (source[60] & 0xfffffffffffffffull) >> 12;
    destination[57]  = (source[60] & 0xfffffffffffffffull) << 52;
    destination[57] |= (source[61] & 0xfffffffffffffffull) >> 8;
    destination[58]  = (source[61] & 0xfffffffffffffffull) << 56;
    destination[58] |= (source[62] & 0xfffffffffffffffull) >> 4;
    destination[59]  = (source[62] & 0xfffffffffffffffull) << 60;
    destination[59] |= (source[63] & 0xfffffffffffffffull) << 0;
  }
  static inline
  void unpack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] >> 4) & 0xfffffffffffffffull;
    destination[1]  = (source[0] << 56) & 0xfffffffffffffffull;
    destination[1] |= (source[1] >> 8) & 0xfffffffffffffffull;
    destination[2]  = (source[1] << 52) & 0xfffffffffffffffull;
    destination[2] |= (source[2] >> 12) & 0xfffffffffffffffull;
    destination[3]  = (source[2] << 48) & 0xfffffffffffffffull;
    destination[3] |= (source[3] >> 16) & 0xfffffffffffffffull;
    destination[4]  = (source[3] << 44) & 0xfffffffffffffffull;
    destination[4] |= (source[4] >> 20) & 0xfffffffffffffffull;
    destination[5]  = (source[4] << 40) & 0xfffffffffffffffull;
    destination[5] |= (source[5] >> 24) & 0xfffffffffffffffull;
    destination[6]  = (source[5] << 36) & 0xfffffffffffffffull;
    destination[6] |= (source[6] >> 28) & 0xfffffffffffffffull;
    destination[7]  = (source[6] << 32) & 0xfffffffffffffffull;
    destination[7] |= (source[7] >> 32) & 0xfffffffffffffffull;
    destination[8]  = (source[7] << 28) & 0xfffffffffffffffull;
    destination[8] |= (source[8] >> 36) & 0xfffffffffffffffull;
    destination[9]  = (source[8] << 24) & 0xfffffffffffffffull;
    destination[9] |= (source[9] >> 40) & 0xfffffffffffffffull;
    destination[10]  = (source[9] << 20) & 0xfffffffffffffffull;
    destination[10] |= (source[10] >> 44) & 0xfffffffffffffffull;
    destination[11]  = (source[10] << 16) & 0xfffffffffffffffull;
    destination[11] |= (source[11] >> 48) & 0xfffffffffffffffull;
    destination[12]  = (source[11] << 12) & 0xfffffffffffffffull;
    destination[12] |= (source[12] >> 52) & 0xfffffffffffffffull;
    destination[13]  = (source[12] << 8) & 0xfffffffffffffffull;
    destination[13] |= (source[13] >> 56) & 0xfffffffffffffffull;
    destination[14]  = (source[13] << 4) & 0xfffffffffffffffull;
    destination[14] |= (source[14] >> 60) & 0xfffffffffffffffull;
    destination[15]  = (source[14] >> 0) & 0xfffffffffffffffull;
    destination[16]  = (source[15] >> 4) & 0xfffffffffffffffull;
    destination[17]  = (source[15] << 56) & 0xfffffffffffffffull;
    destination[17] |= (source[16] >> 8) & 0xfffffffffffffffull;
    destination[18]  = (source[16] << 52) & 0xfffffffffffffffull;
    destination[18] |= (source[17] >> 12) & 0xfffffffffffffffull;
    destination[19]  = (source[17] << 48) & 0xfffffffffffffffull;
    destination[19] |= (source[18] >> 16) & 0xfffffffffffffffull;
    destination[20]  = (source[18] << 44) & 0xfffffffffffffffull;
    destination[20] |= (source[19] >> 20) & 0xfffffffffffffffull;
    destination[21]  = (source[19] << 40) & 0xfffffffffffffffull;
    destination[21] |= (source[20] >> 24) & 0xfffffffffffffffull;
    destination[22]  = (source[20] << 36) & 0xfffffffffffffffull;
    destination[22] |= (source[21] >> 28) & 0xfffffffffffffffull;
    destination[23]  = (source[21] << 32) & 0xfffffffffffffffull;
    destination[23] |= (source[22] >> 32) & 0xfffffffffffffffull;
    destination[24]  = (source[22] << 28) & 0xfffffffffffffffull;
    destination[24] |= (source[23] >> 36) & 0xfffffffffffffffull;
    destination[25]  = (source[23] << 24) & 0xfffffffffffffffull;
    destination[25] |= (source[24] >> 40) & 0xfffffffffffffffull;
    destination[26]  = (source[24] << 20) & 0xfffffffffffffffull;
    destination[26] |= (source[25] >> 44) & 0xfffffffffffffffull;
    destination[27]  = (source[25] << 16) & 0xfffffffffffffffull;
    destination[27] |= (source[26] >> 48) & 0xfffffffffffffffull;
    destination[28]  = (source[26] << 12) & 0xfffffffffffffffull;
    destination[28] |= (source[27] >> 52) & 0xfffffffffffffffull;
    destination[29]  = (source[27] << 8) & 0xfffffffffffffffull;
    destination[29] |= (source[28] >> 56) & 0xfffffffffffffffull;
    destination[30]  = (source[28] << 4) & 0xfffffffffffffffull;
    destination[30] |= (source[29] >> 60) & 0xfffffffffffffffull;
    destination[31]  = (source[29] >> 0) & 0xfffffffffffffffull;
    destination[32]  = (source[30] >> 4) & 0xfffffffffffffffull;
    destination[33]  = (source[30] << 56) & 0xfffffffffffffffull;
    destination[33] |= (source[31] >> 8) & 0xfffffffffffffffull;
    destination[34]  = (source[31] << 52) & 0xfffffffffffffffull;
    destination[34] |= (source[32] >> 12) & 0xfffffffffffffffull;
    destination[35]  = (source[32] << 48) & 0xfffffffffffffffull;
    destination[35] |= (source[33] >> 16) & 0xfffffffffffffffull;
    destination[36]  = (source[33] << 44) & 0xfffffffffffffffull;
    destination[36] |= (source[34] >> 20) & 0xfffffffffffffffull;
    destination[37]  = (source[34] << 40) & 0xfffffffffffffffull;
    destination[37] |= (source[35] >> 24) & 0xfffffffffffffffull;
    destination[38]  = (source[35] << 36) & 0xfffffffffffffffull;
    destination[38] |= (source[36] >> 28) & 0xfffffffffffffffull;
    destination[39]  = (source[36] << 32) & 0xfffffffffffffffull;
    destination[39] |= (source[37] >> 32) & 0xfffffffffffffffull;
    destination[40]  = (source[37] << 28) & 0xfffffffffffffffull;
    destination[40] |= (source[38] >> 36) & 0xfffffffffffffffull;
    destination[41]  = (source[38] << 24) & 0xfffffffffffffffull;
    destination[41] |= (source[39] >> 40) & 0xfffffffffffffffull;
    destination[42]  = (source[39] << 20) & 0xfffffffffffffffull;
    destination[42] |= (source[40] >> 44) & 0xfffffffffffffffull;
    destination[43]  = (source[40] << 16) & 0xfffffffffffffffull;
    destination[43] |= (source[41] >> 48) & 0xfffffffffffffffull;
    destination[44]  = (source[41] << 12) & 0xfffffffffffffffull;
    destination[44] |= (source[42] >> 52) & 0xfffffffffffffffull;
    destination[45]  = (source[42] << 8) & 0xfffffffffffffffull;
    destination[45] |= (source[43] >> 56) & 0xfffffffffffffffull;
    destination[46]  = (source[43] << 4) & 0xfffffffffffffffull;
    destination[46] |= (source[44] >> 60) & 0xfffffffffffffffull;
    destination[47]  = (source[44] >> 0) & 0xfffffffffffffffull;
    destination[48]  = (source[45] >> 4) & 0xfffffffffffffffull;
    destination[49]  = (source[45] << 56) & 0xfffffffffffffffull;
    destination[49] |= (source[46] >> 8) & 0xfffffffffffffffull;
    destination[50]  = (source[46] << 52) & 0xfffffffffffffffull;
    destination[50] |= (source[47] >> 12) & 0xfffffffffffffffull;
    destination[51]  = (source[47] << 48) & 0xfffffffffffffffull;
    destination[51] |= (source[48] >> 16) & 0xfffffffffffffffull;
    destination[52]  = (source[48] << 44) & 0xfffffffffffffffull;
    destination[52] |= (source[49] >> 20) & 0xfffffffffffffffull;
    destination[53]  = (source[49] << 40) & 0xfffffffffffffffull;
    destination[53] |= (source[50] >> 24) & 0xfffffffffffffffull;
    destination[54]  = (source[50] << 36) & 0xfffffffffffffffull;
    destination[54] |= (source[51] >> 28) & 0xfffffffffffffffull;
    destination[55]  = (source[51] << 32) & 0xfffffffffffffffull;
    destination[55] |= (source[52] >> 32) & 0xfffffffffffffffull;
    destination[56]  = (source[52] << 28) & 0xfffffffffffffffull;
    destination[56] |= (source[53] >> 36) & 0xfffffffffffffffull;
    destination[57]  = (source[53] << 24) & 0xfffffffffffffffull;
    destination[57] |= (source[54] >> 40) & 0xfffffffffffffffull;
    destination[58]  = (source[54] << 20) & 0xfffffffffffffffull;
    destination[58] |= (source[55] >> 44) & 0xfffffffffffffffull;
    destination[59]  = (source[55] << 16) & 0xfffffffffffffffull;
    destination[59] |= (source[56] >> 48) & 0xfffffffffffffffull;
    destination[60]  = (source[56] << 12) & 0xfffffffffffffffull;
    destination[60] |= (source[57] >> 52) & 0xfffffffffffffffull;
    destination[61]  = (source[57] << 8) & 0xfffffffffffffffull;
    destination[61] |= (source[58] >> 56) & 0xfffffffffffffffull;
    destination[62]  = (source[58] << 4) & 0xfffffffffffffffull;
    destination[62] |= (source[59] >> 60) & 0xfffffffffffffffull;
    destination[63]  = (source[59] >> 0) & 0xfffffffffffffffull;
  }
};
template <typename Tp>
struct __struct_bitpack_impl<Tp,8,61>
{
  static const size_t unit_size = 64;
  static const size_t bits_total = 3904;
  static const size_t loop_total = 64;
  static const size_t bit_size = 61;
  static const Tp     mask = 0x1fffffffffffffffull;
  static inline
  void pack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] & 0x1fffffffffffffffull) << 3;
    destination[0] |= (source[1] & 0x1fffffffffffffffull) >> 58;
    destination[1]  = (source[1] & 0x1fffffffffffffffull) << 6;
    destination[1] |= (source[2] & 0x1fffffffffffffffull) >> 55;
    destination[2]  = (source[2] & 0x1fffffffffffffffull) << 9;
    destination[2] |= (source[3] & 0x1fffffffffffffffull) >> 52;
    destination[3]  = (source[3] & 0x1fffffffffffffffull) << 12;
    destination[3] |= (source[4] & 0x1fffffffffffffffull) >> 49;
    destination[4]  = (source[4] & 0x1fffffffffffffffull) << 15;
    destination[4] |= (source[5] & 0x1fffffffffffffffull) >> 46;
    destination[5]  = (source[5] & 0x1fffffffffffffffull) << 18;
    destination[5] |= (source[6] & 0x1fffffffffffffffull) >> 43;
    destination[6]  = (source[6] & 0x1fffffffffffffffull) << 21;
    destination[6] |= (source[7] & 0x1fffffffffffffffull) >> 40;
    destination[7]  = (source[7] & 0x1fffffffffffffffull) << 24;
    destination[7] |= (source[8] & 0x1fffffffffffffffull) >> 37;
    destination[8]  = (source[8] & 0x1fffffffffffffffull) << 27;
    destination[8] |= (source[9] & 0x1fffffffffffffffull) >> 34;
    destination[9]  = (source[9] & 0x1fffffffffffffffull) << 30;
    destination[9] |= (source[10] & 0x1fffffffffffffffull) >> 31;
    destination[10]  = (source[10] & 0x1fffffffffffffffull) << 33;
    destination[10] |= (source[11] & 0x1fffffffffffffffull) >> 28;
    destination[11]  = (source[11] & 0x1fffffffffffffffull) << 36;
    destination[11] |= (source[12] & 0x1fffffffffffffffull) >> 25;
    destination[12]  = (source[12] & 0x1fffffffffffffffull) << 39;
    destination[12] |= (source[13] & 0x1fffffffffffffffull) >> 22;
    destination[13]  = (source[13] & 0x1fffffffffffffffull) << 42;
    destination[13] |= (source[14] & 0x1fffffffffffffffull) >> 19;
    destination[14]  = (source[14] & 0x1fffffffffffffffull) << 45;
    destination[14] |= (source[15] & 0x1fffffffffffffffull) >> 16;
    destination[15]  = (source[15] & 0x1fffffffffffffffull) << 48;
    destination[15] |= (source[16] & 0x1fffffffffffffffull) >> 13;
    destination[16]  = (source[16] & 0x1fffffffffffffffull) << 51;
    destination[16] |= (source[17] & 0x1fffffffffffffffull) >> 10;
    destination[17]  = (source[17] & 0x1fffffffffffffffull) << 54;
    destination[17] |= (source[18] & 0x1fffffffffffffffull) >> 7;
    destination[18]  = (source[18] & 0x1fffffffffffffffull) << 57;
    destination[18] |= (source[19] & 0x1fffffffffffffffull) >> 4;
    destination[19]  = (source[19] & 0x1fffffffffffffffull) << 60;
    destination[19] |= (source[20] & 0x1fffffffffffffffull) >> 1;
    destination[20]  = (source[20] & 0x1fffffffffffffffull) << 63;
    destination[20] |= (source[21] & 0x1fffffffffffffffull) << 2;
    destination[20] |= (source[22] & 0x1fffffffffffffffull) >> 59;
    destination[21]  = (source[22] & 0x1fffffffffffffffull) << 5;
    destination[21] |= (source[23] & 0x1fffffffffffffffull) >> 56;
    destination[22]  = (source[23] & 0x1fffffffffffffffull) << 8;
    destination[22] |= (source[24] & 0x1fffffffffffffffull) >> 53;
    destination[23]  = (source[24] & 0x1fffffffffffffffull) << 11;
    destination[23] |= (source[25] & 0x1fffffffffffffffull) >> 50;
    destination[24]  = (source[25] & 0x1fffffffffffffffull) << 14;
    destination[24] |= (source[26] & 0x1fffffffffffffffull) >> 47;
    destination[25]  = (source[26] & 0x1fffffffffffffffull) << 17;
    destination[25] |= (source[27] & 0x1fffffffffffffffull) >> 44;
    destination[26]  = (source[27] & 0x1fffffffffffffffull) << 20;
    destination[26] |= (source[28] & 0x1fffffffffffffffull) >> 41;
    destination[27]  = (source[28] & 0x1fffffffffffffffull) << 23;
    destination[27] |= (source[29] & 0x1fffffffffffffffull) >> 38;
    destination[28]  = (source[29] & 0x1fffffffffffffffull) << 26;
    destination[28] |= (source[30] & 0x1fffffffffffffffull) >> 35;
    destination[29]  = (source[30] & 0x1fffffffffffffffull) << 29;
    destination[29] |= (source[31] & 0x1fffffffffffffffull) >> 32;
    destination[30]  = (source[31] & 0x1fffffffffffffffull) << 32;
    destination[30] |= (source[32] & 0x1fffffffffffffffull) >> 29;
    destination[31]  = (source[32] & 0x1fffffffffffffffull) << 35;
    destination[31] |= (source[33] & 0x1fffffffffffffffull) >> 26;
    destination[32]  = (source[33] & 0x1fffffffffffffffull) << 38;
    destination[32] |= (source[34] & 0x1fffffffffffffffull) >> 23;
    destination[33]  = (source[34] & 0x1fffffffffffffffull) << 41;
    destination[33] |= (source[35] & 0x1fffffffffffffffull) >> 20;
    destination[34]  = (source[35] & 0x1fffffffffffffffull) << 44;
    destination[34] |= (source[36] & 0x1fffffffffffffffull) >> 17;
    destination[35]  = (source[36] & 0x1fffffffffffffffull) << 47;
    destination[35] |= (source[37] & 0x1fffffffffffffffull) >> 14;
    destination[36]  = (source[37] & 0x1fffffffffffffffull) << 50;
    destination[36] |= (source[38] & 0x1fffffffffffffffull) >> 11;
    destination[37]  = (source[38] & 0x1fffffffffffffffull) << 53;
    destination[37] |= (source[39] & 0x1fffffffffffffffull) >> 8;
    destination[38]  = (source[39] & 0x1fffffffffffffffull) << 56;
    destination[38] |= (source[40] & 0x1fffffffffffffffull) >> 5;
    destination[39]  = (source[40] & 0x1fffffffffffffffull) << 59;
    destination[39] |= (source[41] & 0x1fffffffffffffffull) >> 2;
    destination[40]  = (source[41] & 0x1fffffffffffffffull) << 62;
    destination[40] |= (source[42] & 0x1fffffffffffffffull) << 1;
    destination[40] |= (source[43] & 0x1fffffffffffffffull) >> 60;
    destination[41]  = (source[43] & 0x1fffffffffffffffull) << 4;
    destination[41] |= (source[44] & 0x1fffffffffffffffull) >> 57;
    destination[42]  = (source[44] & 0x1fffffffffffffffull) << 7;
    destination[42] |= (source[45] & 0x1fffffffffffffffull) >> 54;
    destination[43]  = (source[45] & 0x1fffffffffffffffull) << 10;
    destination[43] |= (source[46] & 0x1fffffffffffffffull) >> 51;
    destination[44]  = (source[46] & 0x1fffffffffffffffull) << 13;
    destination[44] |= (source[47] & 0x1fffffffffffffffull) >> 48;
    destination[45]  = (source[47] & 0x1fffffffffffffffull) << 16;
    destination[45] |= (source[48] & 0x1fffffffffffffffull) >> 45;
    destination[46]  = (source[48] & 0x1fffffffffffffffull) << 19;
    destination[46] |= (source[49] & 0x1fffffffffffffffull) >> 42;
    destination[47]  = (source[49] & 0x1fffffffffffffffull) << 22;
    destination[47] |= (source[50] & 0x1fffffffffffffffull) >> 39;
    destination[48]  = (source[50] & 0x1fffffffffffffffull) << 25;
    destination[48] |= (source[51] & 0x1fffffffffffffffull) >> 36;
    destination[49]  = (source[51] & 0x1fffffffffffffffull) << 28;
    destination[49] |= (source[52] & 0x1fffffffffffffffull) >> 33;
    destination[50]  = (source[52] & 0x1fffffffffffffffull) << 31;
    destination[50] |= (source[53] & 0x1fffffffffffffffull) >> 30;
    destination[51]  = (source[53] & 0x1fffffffffffffffull) << 34;
    destination[51] |= (source[54] & 0x1fffffffffffffffull) >> 27;
    destination[52]  = (source[54] & 0x1fffffffffffffffull) << 37;
    destination[52] |= (source[55] & 0x1fffffffffffffffull) >> 24;
    destination[53]  = (source[55] & 0x1fffffffffffffffull) << 40;
    destination[53] |= (source[56] & 0x1fffffffffffffffull) >> 21;
    destination[54]  = (source[56] & 0x1fffffffffffffffull) << 43;
    destination[54] |= (source[57] & 0x1fffffffffffffffull) >> 18;
    destination[55]  = (source[57] & 0x1fffffffffffffffull) << 46;
    destination[55] |= (source[58] & 0x1fffffffffffffffull) >> 15;
    destination[56]  = (source[58] & 0x1fffffffffffffffull) << 49;
    destination[56] |= (source[59] & 0x1fffffffffffffffull) >> 12;
    destination[57]  = (source[59] & 0x1fffffffffffffffull) << 52;
    destination[57] |= (source[60] & 0x1fffffffffffffffull) >> 9;
    destination[58]  = (source[60] & 0x1fffffffffffffffull) << 55;
    destination[58] |= (source[61] & 0x1fffffffffffffffull) >> 6;
    destination[59]  = (source[61] & 0x1fffffffffffffffull) << 58;
    destination[59] |= (source[62] & 0x1fffffffffffffffull) >> 3;
    destination[60]  = (source[62] & 0x1fffffffffffffffull) << 61;
    destination[60] |= (source[63] & 0x1fffffffffffffffull) << 0;
  }
  static inline
  void unpack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] >> 3) & 0x1fffffffffffffffull;
    destination[1]  = (source[0] << 58) & 0x1fffffffffffffffull;
    destination[1] |= (source[1] >> 6) & 0x1fffffffffffffffull;
    destination[2]  = (source[1] << 55) & 0x1fffffffffffffffull;
    destination[2] |= (source[2] >> 9) & 0x1fffffffffffffffull;
    destination[3]  = (source[2] << 52) & 0x1fffffffffffffffull;
    destination[3] |= (source[3] >> 12) & 0x1fffffffffffffffull;
    destination[4]  = (source[3] << 49) & 0x1fffffffffffffffull;
    destination[4] |= (source[4] >> 15) & 0x1fffffffffffffffull;
    destination[5]  = (source[4] << 46) & 0x1fffffffffffffffull;
    destination[5] |= (source[5] >> 18) & 0x1fffffffffffffffull;
    destination[6]  = (source[5] << 43) & 0x1fffffffffffffffull;
    destination[6] |= (source[6] >> 21) & 0x1fffffffffffffffull;
    destination[7]  = (source[6] << 40) & 0x1fffffffffffffffull;
    destination[7] |= (source[7] >> 24) & 0x1fffffffffffffffull;
    destination[8]  = (source[7] << 37) & 0x1fffffffffffffffull;
    destination[8] |= (source[8] >> 27) & 0x1fffffffffffffffull;
    destination[9]  = (source[8] << 34) & 0x1fffffffffffffffull;
    destination[9] |= (source[9] >> 30) & 0x1fffffffffffffffull;
    destination[10]  = (source[9] << 31) & 0x1fffffffffffffffull;
    destination[10] |= (source[10] >> 33) & 0x1fffffffffffffffull;
    destination[11]  = (source[10] << 28) & 0x1fffffffffffffffull;
    destination[11] |= (source[11] >> 36) & 0x1fffffffffffffffull;
    destination[12]  = (source[11] << 25) & 0x1fffffffffffffffull;
    destination[12] |= (source[12] >> 39) & 0x1fffffffffffffffull;
    destination[13]  = (source[12] << 22) & 0x1fffffffffffffffull;
    destination[13] |= (source[13] >> 42) & 0x1fffffffffffffffull;
    destination[14]  = (source[13] << 19) & 0x1fffffffffffffffull;
    destination[14] |= (source[14] >> 45) & 0x1fffffffffffffffull;
    destination[15]  = (source[14] << 16) & 0x1fffffffffffffffull;
    destination[15] |= (source[15] >> 48) & 0x1fffffffffffffffull;
    destination[16]  = (source[15] << 13) & 0x1fffffffffffffffull;
    destination[16] |= (source[16] >> 51) & 0x1fffffffffffffffull;
    destination[17]  = (source[16] << 10) & 0x1fffffffffffffffull;
    destination[17] |= (source[17] >> 54) & 0x1fffffffffffffffull;
    destination[18]  = (source[17] << 7) & 0x1fffffffffffffffull;
    destination[18] |= (source[18] >> 57) & 0x1fffffffffffffffull;
    destination[19]  = (source[18] << 4) & 0x1fffffffffffffffull;
    destination[19] |= (source[19] >> 60) & 0x1fffffffffffffffull;
    destination[20]  = (source[19] << 1) & 0x1fffffffffffffffull;
    destination[20] |= (source[20] >> 63) & 0x1fffffffffffffffull;
    destination[21]  = (source[20] >> 2) & 0x1fffffffffffffffull;
    destination[22]  = (source[20] << 59) & 0x1fffffffffffffffull;
    destination[22] |= (source[21] >> 5) & 0x1fffffffffffffffull;
    destination[23]  = (source[21] << 56) & 0x1fffffffffffffffull;
    destination[23] |= (source[22] >> 8) & 0x1fffffffffffffffull;
    destination[24]  = (source[22] << 53) & 0x1fffffffffffffffull;
    destination[24] |= (source[23] >> 11) & 0x1fffffffffffffffull;
    destination[25]  = (source[23] << 50) & 0x1fffffffffffffffull;
    destination[25] |= (source[24] >> 14) & 0x1fffffffffffffffull;
    destination[26]  = (source[24] << 47) & 0x1fffffffffffffffull;
    destination[26] |= (source[25] >> 17) & 0x1fffffffffffffffull;
    destination[27]  = (source[25] << 44) & 0x1fffffffffffffffull;
    destination[27] |= (source[26] >> 20) & 0x1fffffffffffffffull;
    destination[28]  = (source[26] << 41) & 0x1fffffffffffffffull;
    destination[28] |= (source[27] >> 23) & 0x1fffffffffffffffull;
    destination[29]  = (source[27] << 38) & 0x1fffffffffffffffull;
    destination[29] |= (source[28] >> 26) & 0x1fffffffffffffffull;
    destination[30]  = (source[28] << 35) & 0x1fffffffffffffffull;
    destination[30] |= (source[29] >> 29) & 0x1fffffffffffffffull;
    destination[31]  = (source[29] << 32) & 0x1fffffffffffffffull;
    destination[31] |= (source[30] >> 32) & 0x1fffffffffffffffull;
    destination[32]  = (source[30] << 29) & 0x1fffffffffffffffull;
    destination[32] |= (source[31] >> 35) & 0x1fffffffffffffffull;
    destination[33]  = (source[31] << 26) & 0x1fffffffffffffffull;
    destination[33] |= (source[32] >> 38) & 0x1fffffffffffffffull;
    destination[34]  = (source[32] << 23) & 0x1fffffffffffffffull;
    destination[34] |= (source[33] >> 41) & 0x1fffffffffffffffull;
    destination[35]  = (source[33] << 20) & 0x1fffffffffffffffull;
    destination[35] |= (source[34] >> 44) & 0x1fffffffffffffffull;
    destination[36]  = (source[34] << 17) & 0x1fffffffffffffffull;
    destination[36] |= (source[35] >> 47) & 0x1fffffffffffffffull;
    destination[37]  = (source[35] << 14) & 0x1fffffffffffffffull;
    destination[37] |= (source[36] >> 50) & 0x1fffffffffffffffull;
    destination[38]  = (source[36] << 11) & 0x1fffffffffffffffull;
    destination[38] |= (source[37] >> 53) & 0x1fffffffffffffffull;
    destination[39]  = (source[37] << 8) & 0x1fffffffffffffffull;
    destination[39] |= (source[38] >> 56) & 0x1fffffffffffffffull;
    destination[40]  = (source[38] << 5) & 0x1fffffffffffffffull;
    destination[40] |= (source[39] >> 59) & 0x1fffffffffffffffull;
    destination[41]  = (source[39] << 2) & 0x1fffffffffffffffull;
    destination[41] |= (source[40] >> 62) & 0x1fffffffffffffffull;
    destination[42]  = (source[40] >> 1) & 0x1fffffffffffffffull;
    destination[43]  = (source[40] << 60) & 0x1fffffffffffffffull;
    destination[43] |= (source[41] >> 4) & 0x1fffffffffffffffull;
    destination[44]  = (source[41] << 57) & 0x1fffffffffffffffull;
    destination[44] |= (source[42] >> 7) & 0x1fffffffffffffffull;
    destination[45]  = (source[42] << 54) & 0x1fffffffffffffffull;
    destination[45] |= (source[43] >> 10) & 0x1fffffffffffffffull;
    destination[46]  = (source[43] << 51) & 0x1fffffffffffffffull;
    destination[46] |= (source[44] >> 13) & 0x1fffffffffffffffull;
    destination[47]  = (source[44] << 48) & 0x1fffffffffffffffull;
    destination[47] |= (source[45] >> 16) & 0x1fffffffffffffffull;
    destination[48]  = (source[45] << 45) & 0x1fffffffffffffffull;
    destination[48] |= (source[46] >> 19) & 0x1fffffffffffffffull;
    destination[49]  = (source[46] << 42) & 0x1fffffffffffffffull;
    destination[49] |= (source[47] >> 22) & 0x1fffffffffffffffull;
    destination[50]  = (source[47] << 39) & 0x1fffffffffffffffull;
    destination[50] |= (source[48] >> 25) & 0x1fffffffffffffffull;
    destination[51]  = (source[48] << 36) & 0x1fffffffffffffffull;
    destination[51] |= (source[49] >> 28) & 0x1fffffffffffffffull;
    destination[52]  = (source[49] << 33) & 0x1fffffffffffffffull;
    destination[52] |= (source[50] >> 31) & 0x1fffffffffffffffull;
    destination[53]  = (source[50] << 30) & 0x1fffffffffffffffull;
    destination[53] |= (source[51] >> 34) & 0x1fffffffffffffffull;
    destination[54]  = (source[51] << 27) & 0x1fffffffffffffffull;
    destination[54] |= (source[52] >> 37) & 0x1fffffffffffffffull;
    destination[55]  = (source[52] << 24) & 0x1fffffffffffffffull;
    destination[55] |= (source[53] >> 40) & 0x1fffffffffffffffull;
    destination[56]  = (source[53] << 21) & 0x1fffffffffffffffull;
    destination[56] |= (source[54] >> 43) & 0x1fffffffffffffffull;
    destination[57]  = (source[54] << 18) & 0x1fffffffffffffffull;
    destination[57] |= (source[55] >> 46) & 0x1fffffffffffffffull;
    destination[58]  = (source[55] << 15) & 0x1fffffffffffffffull;
    destination[58] |= (source[56] >> 49) & 0x1fffffffffffffffull;
    destination[59]  = (source[56] << 12) & 0x1fffffffffffffffull;
    destination[59] |= (source[57] >> 52) & 0x1fffffffffffffffull;
    destination[60]  = (source[57] << 9) & 0x1fffffffffffffffull;
    destination[60] |= (source[58] >> 55) & 0x1fffffffffffffffull;
    destination[61]  = (source[58] << 6) & 0x1fffffffffffffffull;
    destination[61] |= (source[59] >> 58) & 0x1fffffffffffffffull;
    destination[62]  = (source[59] << 3) & 0x1fffffffffffffffull;
    destination[62] |= (source[60] >> 61) & 0x1fffffffffffffffull;
    destination[63]  = (source[60] >> 0) & 0x1fffffffffffffffull;
  }
};
template <typename Tp>
struct __struct_bitpack_impl<Tp,8,62>
{
  static const size_t unit_size = 64;
  static const size_t bits_total = 3968;
  static const size_t loop_total = 64;
  static const size_t bit_size = 62;
  static const Tp     mask = 0x3fffffffffffffffull;
  static inline
  void pack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] & 0x3fffffffffffffffull) << 2;
    destination[0] |= (source[1] & 0x3fffffffffffffffull) >> 60;
    destination[1]  = (source[1] & 0x3fffffffffffffffull) << 4;
    destination[1] |= (source[2] & 0x3fffffffffffffffull) >> 58;
    destination[2]  = (source[2] & 0x3fffffffffffffffull) << 6;
    destination[2] |= (source[3] & 0x3fffffffffffffffull) >> 56;
    destination[3]  = (source[3] & 0x3fffffffffffffffull) << 8;
    destination[3] |= (source[4] & 0x3fffffffffffffffull) >> 54;
    destination[4]  = (source[4] & 0x3fffffffffffffffull) << 10;
    destination[4] |= (source[5] & 0x3fffffffffffffffull) >> 52;
    destination[5]  = (source[5] & 0x3fffffffffffffffull) << 12;
    destination[5] |= (source[6] & 0x3fffffffffffffffull) >> 50;
    destination[6]  = (source[6] & 0x3fffffffffffffffull) << 14;
    destination[6] |= (source[7] & 0x3fffffffffffffffull) >> 48;
    destination[7]  = (source[7] & 0x3fffffffffffffffull) << 16;
    destination[7] |= (source[8] & 0x3fffffffffffffffull) >> 46;
    destination[8]  = (source[8] & 0x3fffffffffffffffull) << 18;
    destination[8] |= (source[9] & 0x3fffffffffffffffull) >> 44;
    destination[9]  = (source[9] & 0x3fffffffffffffffull) << 20;
    destination[9] |= (source[10] & 0x3fffffffffffffffull) >> 42;
    destination[10]  = (source[10] & 0x3fffffffffffffffull) << 22;
    destination[10] |= (source[11] & 0x3fffffffffffffffull) >> 40;
    destination[11]  = (source[11] & 0x3fffffffffffffffull) << 24;
    destination[11] |= (source[12] & 0x3fffffffffffffffull) >> 38;
    destination[12]  = (source[12] & 0x3fffffffffffffffull) << 26;
    destination[12] |= (source[13] & 0x3fffffffffffffffull) >> 36;
    destination[13]  = (source[13] & 0x3fffffffffffffffull) << 28;
    destination[13] |= (source[14] & 0x3fffffffffffffffull) >> 34;
    destination[14]  = (source[14] & 0x3fffffffffffffffull) << 30;
    destination[14] |= (source[15] & 0x3fffffffffffffffull) >> 32;
    destination[15]  = (source[15] & 0x3fffffffffffffffull) << 32;
    destination[15] |= (source[16] & 0x3fffffffffffffffull) >> 30;
    destination[16]  = (source[16] & 0x3fffffffffffffffull) << 34;
    destination[16] |= (source[17] & 0x3fffffffffffffffull) >> 28;
    destination[17]  = (source[17] & 0x3fffffffffffffffull) << 36;
    destination[17] |= (source[18] & 0x3fffffffffffffffull) >> 26;
    destination[18]  = (source[18] & 0x3fffffffffffffffull) << 38;
    destination[18] |= (source[19] & 0x3fffffffffffffffull) >> 24;
    destination[19]  = (source[19] & 0x3fffffffffffffffull) << 40;
    destination[19] |= (source[20] & 0x3fffffffffffffffull) >> 22;
    destination[20]  = (source[20] & 0x3fffffffffffffffull) << 42;
    destination[20] |= (source[21] & 0x3fffffffffffffffull) >> 20;
    destination[21]  = (source[21] & 0x3fffffffffffffffull) << 44;
    destination[21] |= (source[22] & 0x3fffffffffffffffull) >> 18;
    destination[22]  = (source[22] & 0x3fffffffffffffffull) << 46;
    destination[22] |= (source[23] & 0x3fffffffffffffffull) >> 16;
    destination[23]  = (source[23] & 0x3fffffffffffffffull) << 48;
    destination[23] |= (source[24] & 0x3fffffffffffffffull) >> 14;
    destination[24]  = (source[24] & 0x3fffffffffffffffull) << 50;
    destination[24] |= (source[25] & 0x3fffffffffffffffull) >> 12;
    destination[25]  = (source[25] & 0x3fffffffffffffffull) << 52;
    destination[25] |= (source[26] & 0x3fffffffffffffffull) >> 10;
    destination[26]  = (source[26] & 0x3fffffffffffffffull) << 54;
    destination[26] |= (source[27] & 0x3fffffffffffffffull) >> 8;
    destination[27]  = (source[27] & 0x3fffffffffffffffull) << 56;
    destination[27] |= (source[28] & 0x3fffffffffffffffull) >> 6;
    destination[28]  = (source[28] & 0x3fffffffffffffffull) << 58;
    destination[28] |= (source[29] & 0x3fffffffffffffffull) >> 4;
    destination[29]  = (source[29] & 0x3fffffffffffffffull) << 60;
    destination[29] |= (source[30] & 0x3fffffffffffffffull) >> 2;
    destination[30]  = (source[30] & 0x3fffffffffffffffull) << 62;
    destination[30] |= (source[31] & 0x3fffffffffffffffull) << 0;
    destination[31]  = (source[32] & 0x3fffffffffffffffull) << 2;
    destination[31] |= (source[33] & 0x3fffffffffffffffull) >> 60;
    destination[32]  = (source[33] & 0x3fffffffffffffffull) << 4;
    destination[32] |= (source[34] & 0x3fffffffffffffffull) >> 58;
    destination[33]  = (source[34] & 0x3fffffffffffffffull) << 6;
    destination[33] |= (source[35] & 0x3fffffffffffffffull) >> 56;
    destination[34]  = (source[35] & 0x3fffffffffffffffull) << 8;
    destination[34] |= (source[36] & 0x3fffffffffffffffull) >> 54;
    destination[35]  = (source[36] & 0x3fffffffffffffffull) << 10;
    destination[35] |= (source[37] & 0x3fffffffffffffffull) >> 52;
    destination[36]  = (source[37] & 0x3fffffffffffffffull) << 12;
    destination[36] |= (source[38] & 0x3fffffffffffffffull) >> 50;
    destination[37]  = (source[38] & 0x3fffffffffffffffull) << 14;
    destination[37] |= (source[39] & 0x3fffffffffffffffull) >> 48;
    destination[38]  = (source[39] & 0x3fffffffffffffffull) << 16;
    destination[38] |= (source[40] & 0x3fffffffffffffffull) >> 46;
    destination[39]  = (source[40] & 0x3fffffffffffffffull) << 18;
    destination[39] |= (source[41] & 0x3fffffffffffffffull) >> 44;
    destination[40]  = (source[41] & 0x3fffffffffffffffull) << 20;
    destination[40] |= (source[42] & 0x3fffffffffffffffull) >> 42;
    destination[41]  = (source[42] & 0x3fffffffffffffffull) << 22;
    destination[41] |= (source[43] & 0x3fffffffffffffffull) >> 40;
    destination[42]  = (source[43] & 0x3fffffffffffffffull) << 24;
    destination[42] |= (source[44] & 0x3fffffffffffffffull) >> 38;
    destination[43]  = (source[44] & 0x3fffffffffffffffull) << 26;
    destination[43] |= (source[45] & 0x3fffffffffffffffull) >> 36;
    destination[44]  = (source[45] & 0x3fffffffffffffffull) << 28;
    destination[44] |= (source[46] & 0x3fffffffffffffffull) >> 34;
    destination[45]  = (source[46] & 0x3fffffffffffffffull) << 30;
    destination[45] |= (source[47] & 0x3fffffffffffffffull) >> 32;
    destination[46]  = (source[47] & 0x3fffffffffffffffull) << 32;
    destination[46] |= (source[48] & 0x3fffffffffffffffull) >> 30;
    destination[47]  = (source[48] & 0x3fffffffffffffffull) << 34;
    destination[47] |= (source[49] & 0x3fffffffffffffffull) >> 28;
    destination[48]  = (source[49] & 0x3fffffffffffffffull) << 36;
    destination[48] |= (source[50] & 0x3fffffffffffffffull) >> 26;
    destination[49]  = (source[50] & 0x3fffffffffffffffull) << 38;
    destination[49] |= (source[51] & 0x3fffffffffffffffull) >> 24;
    destination[50]  = (source[51] & 0x3fffffffffffffffull) << 40;
    destination[50] |= (source[52] & 0x3fffffffffffffffull) >> 22;
    destination[51]  = (source[52] & 0x3fffffffffffffffull) << 42;
    destination[51] |= (source[53] & 0x3fffffffffffffffull) >> 20;
    destination[52]  = (source[53] & 0x3fffffffffffffffull) << 44;
    destination[52] |= (source[54] & 0x3fffffffffffffffull) >> 18;
    destination[53]  = (source[54] & 0x3fffffffffffffffull) << 46;
    destination[53] |= (source[55] & 0x3fffffffffffffffull) >> 16;
    destination[54]  = (source[55] & 0x3fffffffffffffffull) << 48;
    destination[54] |= (source[56] & 0x3fffffffffffffffull) >> 14;
    destination[55]  = (source[56] & 0x3fffffffffffffffull) << 50;
    destination[55] |= (source[57] & 0x3fffffffffffffffull) >> 12;
    destination[56]  = (source[57] & 0x3fffffffffffffffull) << 52;
    destination[56] |= (source[58] & 0x3fffffffffffffffull) >> 10;
    destination[57]  = (source[58] & 0x3fffffffffffffffull) << 54;
    destination[57] |= (source[59] & 0x3fffffffffffffffull) >> 8;
    destination[58]  = (source[59] & 0x3fffffffffffffffull) << 56;
    destination[58] |= (source[60] & 0x3fffffffffffffffull) >> 6;
    destination[59]  = (source[60] & 0x3fffffffffffffffull) << 58;
    destination[59] |= (source[61] & 0x3fffffffffffffffull) >> 4;
    destination[60]  = (source[61] & 0x3fffffffffffffffull) << 60;
    destination[60] |= (source[62] & 0x3fffffffffffffffull) >> 2;
    destination[61]  = (source[62] & 0x3fffffffffffffffull) << 62;
    destination[61] |= (source[63] & 0x3fffffffffffffffull) << 0;
  }
  static inline
  void unpack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] >> 2) & 0x3fffffffffffffffull;
    destination[1]  = (source[0] << 60) & 0x3fffffffffffffffull;
    destination[1] |= (source[1] >> 4) & 0x3fffffffffffffffull;
    destination[2]  = (source[1] << 58) & 0x3fffffffffffffffull;
    destination[2] |= (source[2] >> 6) & 0x3fffffffffffffffull;
    destination[3]  = (source[2] << 56) & 0x3fffffffffffffffull;
    destination[3] |= (source[3] >> 8) & 0x3fffffffffffffffull;
    destination[4]  = (source[3] << 54) & 0x3fffffffffffffffull;
    destination[4] |= (source[4] >> 10) & 0x3fffffffffffffffull;
    destination[5]  = (source[4] << 52) & 0x3fffffffffffffffull;
    destination[5] |= (source[5] >> 12) & 0x3fffffffffffffffull;
    destination[6]  = (source[5] << 50) & 0x3fffffffffffffffull;
    destination[6] |= (source[6] >> 14) & 0x3fffffffffffffffull;
    destination[7]  = (source[6] << 48) & 0x3fffffffffffffffull;
    destination[7] |= (source[7] >> 16) & 0x3fffffffffffffffull;
    destination[8]  = (source[7] << 46) & 0x3fffffffffffffffull;
    destination[8] |= (source[8] >> 18) & 0x3fffffffffffffffull;
    destination[9]  = (source[8] << 44) & 0x3fffffffffffffffull;
    destination[9] |= (source[9] >> 20) & 0x3fffffffffffffffull;
    destination[10]  = (source[9] << 42) & 0x3fffffffffffffffull;
    destination[10] |= (source[10] >> 22) & 0x3fffffffffffffffull;
    destination[11]  = (source[10] << 40) & 0x3fffffffffffffffull;
    destination[11] |= (source[11] >> 24) & 0x3fffffffffffffffull;
    destination[12]  = (source[11] << 38) & 0x3fffffffffffffffull;
    destination[12] |= (source[12] >> 26) & 0x3fffffffffffffffull;
    destination[13]  = (source[12] << 36) & 0x3fffffffffffffffull;
    destination[13] |= (source[13] >> 28) & 0x3fffffffffffffffull;
    destination[14]  = (source[13] << 34) & 0x3fffffffffffffffull;
    destination[14] |= (source[14] >> 30) & 0x3fffffffffffffffull;
    destination[15]  = (source[14] << 32) & 0x3fffffffffffffffull;
    destination[15] |= (source[15] >> 32) & 0x3fffffffffffffffull;
    destination[16]  = (source[15] << 30) & 0x3fffffffffffffffull;
    destination[16] |= (source[16] >> 34) & 0x3fffffffffffffffull;
    destination[17]  = (source[16] << 28) & 0x3fffffffffffffffull;
    destination[17] |= (source[17] >> 36) & 0x3fffffffffffffffull;
    destination[18]  = (source[17] << 26) & 0x3fffffffffffffffull;
    destination[18] |= (source[18] >> 38) & 0x3fffffffffffffffull;
    destination[19]  = (source[18] << 24) & 0x3fffffffffffffffull;
    destination[19] |= (source[19] >> 40) & 0x3fffffffffffffffull;
    destination[20]  = (source[19] << 22) & 0x3fffffffffffffffull;
    destination[20] |= (source[20] >> 42) & 0x3fffffffffffffffull;
    destination[21]  = (source[20] << 20) & 0x3fffffffffffffffull;
    destination[21] |= (source[21] >> 44) & 0x3fffffffffffffffull;
    destination[22]  = (source[21] << 18) & 0x3fffffffffffffffull;
    destination[22] |= (source[22] >> 46) & 0x3fffffffffffffffull;
    destination[23]  = (source[22] << 16) & 0x3fffffffffffffffull;
    destination[23] |= (source[23] >> 48) & 0x3fffffffffffffffull;
    destination[24]  = (source[23] << 14) & 0x3fffffffffffffffull;
    destination[24] |= (source[24] >> 50) & 0x3fffffffffffffffull;
    destination[25]  = (source[24] << 12) & 0x3fffffffffffffffull;
    destination[25] |= (source[25] >> 52) & 0x3fffffffffffffffull;
    destination[26]  = (source[25] << 10) & 0x3fffffffffffffffull;
    destination[26] |= (source[26] >> 54) & 0x3fffffffffffffffull;
    destination[27]  = (source[26] << 8) & 0x3fffffffffffffffull;
    destination[27] |= (source[27] >> 56) & 0x3fffffffffffffffull;
    destination[28]  = (source[27] << 6) & 0x3fffffffffffffffull;
    destination[28] |= (source[28] >> 58) & 0x3fffffffffffffffull;
    destination[29]  = (source[28] << 4) & 0x3fffffffffffffffull;
    destination[29] |= (source[29] >> 60) & 0x3fffffffffffffffull;
    destination[30]  = (source[29] << 2) & 0x3fffffffffffffffull;
    destination[30] |= (source[30] >> 62) & 0x3fffffffffffffffull;
    destination[31]  = (source[30] >> 0) & 0x3fffffffffffffffull;
    destination[32]  = (source[31] >> 2) & 0x3fffffffffffffffull;
    destination[33]  = (source[31] << 60) & 0x3fffffffffffffffull;
    destination[33] |= (source[32] >> 4) & 0x3fffffffffffffffull;
    destination[34]  = (source[32] << 58) & 0x3fffffffffffffffull;
    destination[34] |= (source[33] >> 6) & 0x3fffffffffffffffull;
    destination[35]  = (source[33] << 56) & 0x3fffffffffffffffull;
    destination[35] |= (source[34] >> 8) & 0x3fffffffffffffffull;
    destination[36]  = (source[34] << 54) & 0x3fffffffffffffffull;
    destination[36] |= (source[35] >> 10) & 0x3fffffffffffffffull;
    destination[37]  = (source[35] << 52) & 0x3fffffffffffffffull;
    destination[37] |= (source[36] >> 12) & 0x3fffffffffffffffull;
    destination[38]  = (source[36] << 50) & 0x3fffffffffffffffull;
    destination[38] |= (source[37] >> 14) & 0x3fffffffffffffffull;
    destination[39]  = (source[37] << 48) & 0x3fffffffffffffffull;
    destination[39] |= (source[38] >> 16) & 0x3fffffffffffffffull;
    destination[40]  = (source[38] << 46) & 0x3fffffffffffffffull;
    destination[40] |= (source[39] >> 18) & 0x3fffffffffffffffull;
    destination[41]  = (source[39] << 44) & 0x3fffffffffffffffull;
    destination[41] |= (source[40] >> 20) & 0x3fffffffffffffffull;
    destination[42]  = (source[40] << 42) & 0x3fffffffffffffffull;
    destination[42] |= (source[41] >> 22) & 0x3fffffffffffffffull;
    destination[43]  = (source[41] << 40) & 0x3fffffffffffffffull;
    destination[43] |= (source[42] >> 24) & 0x3fffffffffffffffull;
    destination[44]  = (source[42] << 38) & 0x3fffffffffffffffull;
    destination[44] |= (source[43] >> 26) & 0x3fffffffffffffffull;
    destination[45]  = (source[43] << 36) & 0x3fffffffffffffffull;
    destination[45] |= (source[44] >> 28) & 0x3fffffffffffffffull;
    destination[46]  = (source[44] << 34) & 0x3fffffffffffffffull;
    destination[46] |= (source[45] >> 30) & 0x3fffffffffffffffull;
    destination[47]  = (source[45] << 32) & 0x3fffffffffffffffull;
    destination[47] |= (source[46] >> 32) & 0x3fffffffffffffffull;
    destination[48]  = (source[46] << 30) & 0x3fffffffffffffffull;
    destination[48] |= (source[47] >> 34) & 0x3fffffffffffffffull;
    destination[49]  = (source[47] << 28) & 0x3fffffffffffffffull;
    destination[49] |= (source[48] >> 36) & 0x3fffffffffffffffull;
    destination[50]  = (source[48] << 26) & 0x3fffffffffffffffull;
    destination[50] |= (source[49] >> 38) & 0x3fffffffffffffffull;
    destination[51]  = (source[49] << 24) & 0x3fffffffffffffffull;
    destination[51] |= (source[50] >> 40) & 0x3fffffffffffffffull;
    destination[52]  = (source[50] << 22) & 0x3fffffffffffffffull;
    destination[52] |= (source[51] >> 42) & 0x3fffffffffffffffull;
    destination[53]  = (source[51] << 20) & 0x3fffffffffffffffull;
    destination[53] |= (source[52] >> 44) & 0x3fffffffffffffffull;
    destination[54]  = (source[52] << 18) & 0x3fffffffffffffffull;
    destination[54] |= (source[53] >> 46) & 0x3fffffffffffffffull;
    destination[55]  = (source[53] << 16) & 0x3fffffffffffffffull;
    destination[55] |= (source[54] >> 48) & 0x3fffffffffffffffull;
    destination[56]  = (source[54] << 14) & 0x3fffffffffffffffull;
    destination[56] |= (source[55] >> 50) & 0x3fffffffffffffffull;
    destination[57]  = (source[55] << 12) & 0x3fffffffffffffffull;
    destination[57] |= (source[56] >> 52) & 0x3fffffffffffffffull;
    destination[58]  = (source[56] << 10) & 0x3fffffffffffffffull;
    destination[58] |= (source[57] >> 54) & 0x3fffffffffffffffull;
    destination[59]  = (source[57] << 8) & 0x3fffffffffffffffull;
    destination[59] |= (source[58] >> 56) & 0x3fffffffffffffffull;
    destination[60]  = (source[58] << 6) & 0x3fffffffffffffffull;
    destination[60] |= (source[59] >> 58) & 0x3fffffffffffffffull;
    destination[61]  = (source[59] << 4) & 0x3fffffffffffffffull;
    destination[61] |= (source[60] >> 60) & 0x3fffffffffffffffull;
    destination[62]  = (source[60] << 2) & 0x3fffffffffffffffull;
    destination[62] |= (source[61] >> 62) & 0x3fffffffffffffffull;
    destination[63]  = (source[61] >> 0) & 0x3fffffffffffffffull;
  }
};
template <typename Tp>
struct __struct_bitpack_impl<Tp,8,63>
{
  static const size_t unit_size = 64;
  static const size_t bits_total = 4032;
  static const size_t loop_total = 64;
  static const size_t bit_size = 63;
  static const Tp     mask = 0x7fffffffffffffffull;
  static inline
  void pack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] & 0x7fffffffffffffffull) << 1;
    destination[0] |= (source[1] & 0x7fffffffffffffffull) >> 62;
    destination[1]  = (source[1] & 0x7fffffffffffffffull) << 2;
    destination[1] |= (source[2] & 0x7fffffffffffffffull) >> 61;
    destination[2]  = (source[2] & 0x7fffffffffffffffull) << 3;
    destination[2] |= (source[3] & 0x7fffffffffffffffull) >> 60;
    destination[3]  = (source[3] & 0x7fffffffffffffffull) << 4;
    destination[3] |= (source[4] & 0x7fffffffffffffffull) >> 59;
    destination[4]  = (source[4] & 0x7fffffffffffffffull) << 5;
    destination[4] |= (source[5] & 0x7fffffffffffffffull) >> 58;
    destination[5]  = (source[5] & 0x7fffffffffffffffull) << 6;
    destination[5] |= (source[6] & 0x7fffffffffffffffull) >> 57;
    destination[6]  = (source[6] & 0x7fffffffffffffffull) << 7;
    destination[6] |= (source[7] & 0x7fffffffffffffffull) >> 56;
    destination[7]  = (source[7] & 0x7fffffffffffffffull) << 8;
    destination[7] |= (source[8] & 0x7fffffffffffffffull) >> 55;
    destination[8]  = (source[8] & 0x7fffffffffffffffull) << 9;
    destination[8] |= (source[9] & 0x7fffffffffffffffull) >> 54;
    destination[9]  = (source[9] & 0x7fffffffffffffffull) << 10;
    destination[9] |= (source[10] & 0x7fffffffffffffffull) >> 53;
    destination[10]  = (source[10] & 0x7fffffffffffffffull) << 11;
    destination[10] |= (source[11] & 0x7fffffffffffffffull) >> 52;
    destination[11]  = (source[11] & 0x7fffffffffffffffull) << 12;
    destination[11] |= (source[12] & 0x7fffffffffffffffull) >> 51;
    destination[12]  = (source[12] & 0x7fffffffffffffffull) << 13;
    destination[12] |= (source[13] & 0x7fffffffffffffffull) >> 50;
    destination[13]  = (source[13] & 0x7fffffffffffffffull) << 14;
    destination[13] |= (source[14] & 0x7fffffffffffffffull) >> 49;
    destination[14]  = (source[14] & 0x7fffffffffffffffull) << 15;
    destination[14] |= (source[15] & 0x7fffffffffffffffull) >> 48;
    destination[15]  = (source[15] & 0x7fffffffffffffffull) << 16;
    destination[15] |= (source[16] & 0x7fffffffffffffffull) >> 47;
    destination[16]  = (source[16] & 0x7fffffffffffffffull) << 17;
    destination[16] |= (source[17] & 0x7fffffffffffffffull) >> 46;
    destination[17]  = (source[17] & 0x7fffffffffffffffull) << 18;
    destination[17] |= (source[18] & 0x7fffffffffffffffull) >> 45;
    destination[18]  = (source[18] & 0x7fffffffffffffffull) << 19;
    destination[18] |= (source[19] & 0x7fffffffffffffffull) >> 44;
    destination[19]  = (source[19] & 0x7fffffffffffffffull) << 20;
    destination[19] |= (source[20] & 0x7fffffffffffffffull) >> 43;
    destination[20]  = (source[20] & 0x7fffffffffffffffull) << 21;
    destination[20] |= (source[21] & 0x7fffffffffffffffull) >> 42;
    destination[21]  = (source[21] & 0x7fffffffffffffffull) << 22;
    destination[21] |= (source[22] & 0x7fffffffffffffffull) >> 41;
    destination[22]  = (source[22] & 0x7fffffffffffffffull) << 23;
    destination[22] |= (source[23] & 0x7fffffffffffffffull) >> 40;
    destination[23]  = (source[23] & 0x7fffffffffffffffull) << 24;
    destination[23] |= (source[24] & 0x7fffffffffffffffull) >> 39;
    destination[24]  = (source[24] & 0x7fffffffffffffffull) << 25;
    destination[24] |= (source[25] & 0x7fffffffffffffffull) >> 38;
    destination[25]  = (source[25] & 0x7fffffffffffffffull) << 26;
    destination[25] |= (source[26] & 0x7fffffffffffffffull) >> 37;
    destination[26]  = (source[26] & 0x7fffffffffffffffull) << 27;
    destination[26] |= (source[27] & 0x7fffffffffffffffull) >> 36;
    destination[27]  = (source[27] & 0x7fffffffffffffffull) << 28;
    destination[27] |= (source[28] & 0x7fffffffffffffffull) >> 35;
    destination[28]  = (source[28] & 0x7fffffffffffffffull) << 29;
    destination[28] |= (source[29] & 0x7fffffffffffffffull) >> 34;
    destination[29]  = (source[29] & 0x7fffffffffffffffull) << 30;
    destination[29] |= (source[30] & 0x7fffffffffffffffull) >> 33;
    destination[30]  = (source[30] & 0x7fffffffffffffffull) << 31;
    destination[30] |= (source[31] & 0x7fffffffffffffffull) >> 32;
    destination[31]  = (source[31] & 0x7fffffffffffffffull) << 32;
    destination[31] |= (source[32] & 0x7fffffffffffffffull) >> 31;
    destination[32]  = (source[32] & 0x7fffffffffffffffull) << 33;
    destination[32] |= (source[33] & 0x7fffffffffffffffull) >> 30;
    destination[33]  = (source[33] & 0x7fffffffffffffffull) << 34;
    destination[33] |= (source[34] & 0x7fffffffffffffffull) >> 29;
    destination[34]  = (source[34] & 0x7fffffffffffffffull) << 35;
    destination[34] |= (source[35] & 0x7fffffffffffffffull) >> 28;
    destination[35]  = (source[35] & 0x7fffffffffffffffull) << 36;
    destination[35] |= (source[36] & 0x7fffffffffffffffull) >> 27;
    destination[36]  = (source[36] & 0x7fffffffffffffffull) << 37;
    destination[36] |= (source[37] & 0x7fffffffffffffffull) >> 26;
    destination[37]  = (source[37] & 0x7fffffffffffffffull) << 38;
    destination[37] |= (source[38] & 0x7fffffffffffffffull) >> 25;
    destination[38]  = (source[38] & 0x7fffffffffffffffull) << 39;
    destination[38] |= (source[39] & 0x7fffffffffffffffull) >> 24;
    destination[39]  = (source[39] & 0x7fffffffffffffffull) << 40;
    destination[39] |= (source[40] & 0x7fffffffffffffffull) >> 23;
    destination[40]  = (source[40] & 0x7fffffffffffffffull) << 41;
    destination[40] |= (source[41] & 0x7fffffffffffffffull) >> 22;
    destination[41]  = (source[41] & 0x7fffffffffffffffull) << 42;
    destination[41] |= (source[42] & 0x7fffffffffffffffull) >> 21;
    destination[42]  = (source[42] & 0x7fffffffffffffffull) << 43;
    destination[42] |= (source[43] & 0x7fffffffffffffffull) >> 20;
    destination[43]  = (source[43] & 0x7fffffffffffffffull) << 44;
    destination[43] |= (source[44] & 0x7fffffffffffffffull) >> 19;
    destination[44]  = (source[44] & 0x7fffffffffffffffull) << 45;
    destination[44] |= (source[45] & 0x7fffffffffffffffull) >> 18;
    destination[45]  = (source[45] & 0x7fffffffffffffffull) << 46;
    destination[45] |= (source[46] & 0x7fffffffffffffffull) >> 17;
    destination[46]  = (source[46] & 0x7fffffffffffffffull) << 47;
    destination[46] |= (source[47] & 0x7fffffffffffffffull) >> 16;
    destination[47]  = (source[47] & 0x7fffffffffffffffull) << 48;
    destination[47] |= (source[48] & 0x7fffffffffffffffull) >> 15;
    destination[48]  = (source[48] & 0x7fffffffffffffffull) << 49;
    destination[48] |= (source[49] & 0x7fffffffffffffffull) >> 14;
    destination[49]  = (source[49] & 0x7fffffffffffffffull) << 50;
    destination[49] |= (source[50] & 0x7fffffffffffffffull) >> 13;
    destination[50]  = (source[50] & 0x7fffffffffffffffull) << 51;
    destination[50] |= (source[51] & 0x7fffffffffffffffull) >> 12;
    destination[51]  = (source[51] & 0x7fffffffffffffffull) << 52;
    destination[51] |= (source[52] & 0x7fffffffffffffffull) >> 11;
    destination[52]  = (source[52] & 0x7fffffffffffffffull) << 53;
    destination[52] |= (source[53] & 0x7fffffffffffffffull) >> 10;
    destination[53]  = (source[53] & 0x7fffffffffffffffull) << 54;
    destination[53] |= (source[54] & 0x7fffffffffffffffull) >> 9;
    destination[54]  = (source[54] & 0x7fffffffffffffffull) << 55;
    destination[54] |= (source[55] & 0x7fffffffffffffffull) >> 8;
    destination[55]  = (source[55] & 0x7fffffffffffffffull) << 56;
    destination[55] |= (source[56] & 0x7fffffffffffffffull) >> 7;
    destination[56]  = (source[56] & 0x7fffffffffffffffull) << 57;
    destination[56] |= (source[57] & 0x7fffffffffffffffull) >> 6;
    destination[57]  = (source[57] & 0x7fffffffffffffffull) << 58;
    destination[57] |= (source[58] & 0x7fffffffffffffffull) >> 5;
    destination[58]  = (source[58] & 0x7fffffffffffffffull) << 59;
    destination[58] |= (source[59] & 0x7fffffffffffffffull) >> 4;
    destination[59]  = (source[59] & 0x7fffffffffffffffull) << 60;
    destination[59] |= (source[60] & 0x7fffffffffffffffull) >> 3;
    destination[60]  = (source[60] & 0x7fffffffffffffffull) << 61;
    destination[60] |= (source[61] & 0x7fffffffffffffffull) >> 2;
    destination[61]  = (source[61] & 0x7fffffffffffffffull) << 62;
    destination[61] |= (source[62] & 0x7fffffffffffffffull) >> 1;
    destination[62]  = (source[62] & 0x7fffffffffffffffull) << 63;
    destination[62] |= (source[63] & 0x7fffffffffffffffull) << 0;
  }
  static inline
  void unpack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] >> 1) & 0x7fffffffffffffffull;
    destination[1]  = (source[0] << 62) & 0x7fffffffffffffffull;
    destination[1] |= (source[1] >> 2) & 0x7fffffffffffffffull;
    destination[2]  = (source[1] << 61) & 0x7fffffffffffffffull;
    destination[2] |= (source[2] >> 3) & 0x7fffffffffffffffull;
    destination[3]  = (source[2] << 60) & 0x7fffffffffffffffull;
    destination[3] |= (source[3] >> 4) & 0x7fffffffffffffffull;
    destination[4]  = (source[3] << 59) & 0x7fffffffffffffffull;
    destination[4] |= (source[4] >> 5) & 0x7fffffffffffffffull;
    destination[5]  = (source[4] << 58) & 0x7fffffffffffffffull;
    destination[5] |= (source[5] >> 6) & 0x7fffffffffffffffull;
    destination[6]  = (source[5] << 57) & 0x7fffffffffffffffull;
    destination[6] |= (source[6] >> 7) & 0x7fffffffffffffffull;
    destination[7]  = (source[6] << 56) & 0x7fffffffffffffffull;
    destination[7] |= (source[7] >> 8) & 0x7fffffffffffffffull;
    destination[8]  = (source[7] << 55) & 0x7fffffffffffffffull;
    destination[8] |= (source[8] >> 9) & 0x7fffffffffffffffull;
    destination[9]  = (source[8] << 54) & 0x7fffffffffffffffull;
    destination[9] |= (source[9] >> 10) & 0x7fffffffffffffffull;
    destination[10]  = (source[9] << 53) & 0x7fffffffffffffffull;
    destination[10] |= (source[10] >> 11) & 0x7fffffffffffffffull;
    destination[11]  = (source[10] << 52) & 0x7fffffffffffffffull;
    destination[11] |= (source[11] >> 12) & 0x7fffffffffffffffull;
    destination[12]  = (source[11] << 51) & 0x7fffffffffffffffull;
    destination[12] |= (source[12] >> 13) & 0x7fffffffffffffffull;
    destination[13]  = (source[12] << 50) & 0x7fffffffffffffffull;
    destination[13] |= (source[13] >> 14) & 0x7fffffffffffffffull;
    destination[14]  = (source[13] << 49) & 0x7fffffffffffffffull;
    destination[14] |= (source[14] >> 15) & 0x7fffffffffffffffull;
    destination[15]  = (source[14] << 48) & 0x7fffffffffffffffull;
    destination[15] |= (source[15] >> 16) & 0x7fffffffffffffffull;
    destination[16]  = (source[15] << 47) & 0x7fffffffffffffffull;
    destination[16] |= (source[16] >> 17) & 0x7fffffffffffffffull;
    destination[17]  = (source[16] << 46) & 0x7fffffffffffffffull;
    destination[17] |= (source[17] >> 18) & 0x7fffffffffffffffull;
    destination[18]  = (source[17] << 45) & 0x7fffffffffffffffull;
    destination[18] |= (source[18] >> 19) & 0x7fffffffffffffffull;
    destination[19]  = (source[18] << 44) & 0x7fffffffffffffffull;
    destination[19] |= (source[19] >> 20) & 0x7fffffffffffffffull;
    destination[20]  = (source[19] << 43) & 0x7fffffffffffffffull;
    destination[20] |= (source[20] >> 21) & 0x7fffffffffffffffull;
    destination[21]  = (source[20] << 42) & 0x7fffffffffffffffull;
    destination[21] |= (source[21] >> 22) & 0x7fffffffffffffffull;
    destination[22]  = (source[21] << 41) & 0x7fffffffffffffffull;
    destination[22] |= (source[22] >> 23) & 0x7fffffffffffffffull;
    destination[23]  = (source[22] << 40) & 0x7fffffffffffffffull;
    destination[23] |= (source[23] >> 24) & 0x7fffffffffffffffull;
    destination[24]  = (source[23] << 39) & 0x7fffffffffffffffull;
    destination[24] |= (source[24] >> 25) & 0x7fffffffffffffffull;
    destination[25]  = (source[24] << 38) & 0x7fffffffffffffffull;
    destination[25] |= (source[25] >> 26) & 0x7fffffffffffffffull;
    destination[26]  = (source[25] << 37) & 0x7fffffffffffffffull;
    destination[26] |= (source[26] >> 27) & 0x7fffffffffffffffull;
    destination[27]  = (source[26] << 36) & 0x7fffffffffffffffull;
    destination[27] |= (source[27] >> 28) & 0x7fffffffffffffffull;
    destination[28]  = (source[27] << 35) & 0x7fffffffffffffffull;
    destination[28] |= (source[28] >> 29) & 0x7fffffffffffffffull;
    destination[29]  = (source[28] << 34) & 0x7fffffffffffffffull;
    destination[29] |= (source[29] >> 30) & 0x7fffffffffffffffull;
    destination[30]  = (source[29] << 33) & 0x7fffffffffffffffull;
    destination[30] |= (source[30] >> 31) & 0x7fffffffffffffffull;
    destination[31]  = (source[30] << 32) & 0x7fffffffffffffffull;
    destination[31] |= (source[31] >> 32) & 0x7fffffffffffffffull;
    destination[32]  = (source[31] << 31) & 0x7fffffffffffffffull;
    destination[32] |= (source[32] >> 33) & 0x7fffffffffffffffull;
    destination[33]  = (source[32] << 30) & 0x7fffffffffffffffull;
    destination[33] |= (source[33] >> 34) & 0x7fffffffffffffffull;
    destination[34]  = (source[33] << 29) & 0x7fffffffffffffffull;
    destination[34] |= (source[34] >> 35) & 0x7fffffffffffffffull;
    destination[35]  = (source[34] << 28) & 0x7fffffffffffffffull;
    destination[35] |= (source[35] >> 36) & 0x7fffffffffffffffull;
    destination[36]  = (source[35] << 27) & 0x7fffffffffffffffull;
    destination[36] |= (source[36] >> 37) & 0x7fffffffffffffffull;
    destination[37]  = (source[36] << 26) & 0x7fffffffffffffffull;
    destination[37] |= (source[37] >> 38) & 0x7fffffffffffffffull;
    destination[38]  = (source[37] << 25) & 0x7fffffffffffffffull;
    destination[38] |= (source[38] >> 39) & 0x7fffffffffffffffull;
    destination[39]  = (source[38] << 24) & 0x7fffffffffffffffull;
    destination[39] |= (source[39] >> 40) & 0x7fffffffffffffffull;
    destination[40]  = (source[39] << 23) & 0x7fffffffffffffffull;
    destination[40] |= (source[40] >> 41) & 0x7fffffffffffffffull;
    destination[41]  = (source[40] << 22) & 0x7fffffffffffffffull;
    destination[41] |= (source[41] >> 42) & 0x7fffffffffffffffull;
    destination[42]  = (source[41] << 21) & 0x7fffffffffffffffull;
    destination[42] |= (source[42] >> 43) & 0x7fffffffffffffffull;
    destination[43]  = (source[42] << 20) & 0x7fffffffffffffffull;
    destination[43] |= (source[43] >> 44) & 0x7fffffffffffffffull;
    destination[44]  = (source[43] << 19) & 0x7fffffffffffffffull;
    destination[44] |= (source[44] >> 45) & 0x7fffffffffffffffull;
    destination[45]  = (source[44] << 18) & 0x7fffffffffffffffull;
    destination[45] |= (source[45] >> 46) & 0x7fffffffffffffffull;
    destination[46]  = (source[45] << 17) & 0x7fffffffffffffffull;
    destination[46] |= (source[46] >> 47) & 0x7fffffffffffffffull;
    destination[47]  = (source[46] << 16) & 0x7fffffffffffffffull;
    destination[47] |= (source[47] >> 48) & 0x7fffffffffffffffull;
    destination[48]  = (source[47] << 15) & 0x7fffffffffffffffull;
    destination[48] |= (source[48] >> 49) & 0x7fffffffffffffffull;
    destination[49]  = (source[48] << 14) & 0x7fffffffffffffffull;
    destination[49] |= (source[49] >> 50) & 0x7fffffffffffffffull;
    destination[50]  = (source[49] << 13) & 0x7fffffffffffffffull;
    destination[50] |= (source[50] >> 51) & 0x7fffffffffffffffull;
    destination[51]  = (source[50] << 12) & 0x7fffffffffffffffull;
    destination[51] |= (source[51] >> 52) & 0x7fffffffffffffffull;
    destination[52]  = (source[51] << 11) & 0x7fffffffffffffffull;
    destination[52] |= (source[52] >> 53) & 0x7fffffffffffffffull;
    destination[53]  = (source[52] << 10) & 0x7fffffffffffffffull;
    destination[53] |= (source[53] >> 54) & 0x7fffffffffffffffull;
    destination[54]  = (source[53] << 9) & 0x7fffffffffffffffull;
    destination[54] |= (source[54] >> 55) & 0x7fffffffffffffffull;
    destination[55]  = (source[54] << 8) & 0x7fffffffffffffffull;
    destination[55] |= (source[55] >> 56) & 0x7fffffffffffffffull;
    destination[56]  = (source[55] << 7) & 0x7fffffffffffffffull;
    destination[56] |= (source[56] >> 57) & 0x7fffffffffffffffull;
    destination[57]  = (source[56] << 6) & 0x7fffffffffffffffull;
    destination[57] |= (source[57] >> 58) & 0x7fffffffffffffffull;
    destination[58]  = (source[57] << 5) & 0x7fffffffffffffffull;
    destination[58] |= (source[58] >> 59) & 0x7fffffffffffffffull;
    destination[59]  = (source[58] << 4) & 0x7fffffffffffffffull;
    destination[59] |= (source[59] >> 60) & 0x7fffffffffffffffull;
    destination[60]  = (source[59] << 3) & 0x7fffffffffffffffull;
    destination[60] |= (source[60] >> 61) & 0x7fffffffffffffffull;
    destination[61]  = (source[60] << 2) & 0x7fffffffffffffffull;
    destination[61] |= (source[61] >> 62) & 0x7fffffffffffffffull;
    destination[62]  = (source[61] << 1) & 0x7fffffffffffffffull;
    destination[62] |= (source[62] >> 63) & 0x7fffffffffffffffull;
    destination[63]  = (source[62] >> 0) & 0x7fffffffffffffffull;
  }
};
};
};
#endif
