#ifndef __UTILS__BITPACK32_IMPL__HPP__
#define __UTILS__BITPACK32_IMPL__HPP__ 1
namespace utils {
namespace bitpack {
template <typename Tp>
struct __struct_bitpack_impl<Tp,4,1>
{
  static const size_t unit_size = 32;
  static const size_t bits_total = 32;
  static const size_t loop_total = 32;
  static const size_t bit_size = 1;
  static const Tp     mask = 0x01;
  static inline
  void pack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] & 0x01) << 31;
    destination[0] |= (source[1] & 0x01) << 30;
    destination[0] |= (source[2] & 0x01) << 29;
    destination[0] |= (source[3] & 0x01) << 28;
    destination[0] |= (source[4] & 0x01) << 27;
    destination[0] |= (source[5] & 0x01) << 26;
    destination[0] |= (source[6] & 0x01) << 25;
    destination[0] |= (source[7] & 0x01) << 24;
    destination[0] |= (source[8] & 0x01) << 23;
    destination[0] |= (source[9] & 0x01) << 22;
    destination[0] |= (source[10] & 0x01) << 21;
    destination[0] |= (source[11] & 0x01) << 20;
    destination[0] |= (source[12] & 0x01) << 19;
    destination[0] |= (source[13] & 0x01) << 18;
    destination[0] |= (source[14] & 0x01) << 17;
    destination[0] |= (source[15] & 0x01) << 16;
    destination[0] |= (source[16] & 0x01) << 15;
    destination[0] |= (source[17] & 0x01) << 14;
    destination[0] |= (source[18] & 0x01) << 13;
    destination[0] |= (source[19] & 0x01) << 12;
    destination[0] |= (source[20] & 0x01) << 11;
    destination[0] |= (source[21] & 0x01) << 10;
    destination[0] |= (source[22] & 0x01) << 9;
    destination[0] |= (source[23] & 0x01) << 8;
    destination[0] |= (source[24] & 0x01) << 7;
    destination[0] |= (source[25] & 0x01) << 6;
    destination[0] |= (source[26] & 0x01) << 5;
    destination[0] |= (source[27] & 0x01) << 4;
    destination[0] |= (source[28] & 0x01) << 3;
    destination[0] |= (source[29] & 0x01) << 2;
    destination[0] |= (source[30] & 0x01) << 1;
    destination[0] |= (source[31] & 0x01) << 0;
  }
  static inline
  void unpack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] >> 31) & 0x01;
    destination[1]  = (source[0] >> 30) & 0x01;
    destination[2]  = (source[0] >> 29) & 0x01;
    destination[3]  = (source[0] >> 28) & 0x01;
    destination[4]  = (source[0] >> 27) & 0x01;
    destination[5]  = (source[0] >> 26) & 0x01;
    destination[6]  = (source[0] >> 25) & 0x01;
    destination[7]  = (source[0] >> 24) & 0x01;
    destination[8]  = (source[0] >> 23) & 0x01;
    destination[9]  = (source[0] >> 22) & 0x01;
    destination[10]  = (source[0] >> 21) & 0x01;
    destination[11]  = (source[0] >> 20) & 0x01;
    destination[12]  = (source[0] >> 19) & 0x01;
    destination[13]  = (source[0] >> 18) & 0x01;
    destination[14]  = (source[0] >> 17) & 0x01;
    destination[15]  = (source[0] >> 16) & 0x01;
    destination[16]  = (source[0] >> 15) & 0x01;
    destination[17]  = (source[0] >> 14) & 0x01;
    destination[18]  = (source[0] >> 13) & 0x01;
    destination[19]  = (source[0] >> 12) & 0x01;
    destination[20]  = (source[0] >> 11) & 0x01;
    destination[21]  = (source[0] >> 10) & 0x01;
    destination[22]  = (source[0] >> 9) & 0x01;
    destination[23]  = (source[0] >> 8) & 0x01;
    destination[24]  = (source[0] >> 7) & 0x01;
    destination[25]  = (source[0] >> 6) & 0x01;
    destination[26]  = (source[0] >> 5) & 0x01;
    destination[27]  = (source[0] >> 4) & 0x01;
    destination[28]  = (source[0] >> 3) & 0x01;
    destination[29]  = (source[0] >> 2) & 0x01;
    destination[30]  = (source[0] >> 1) & 0x01;
    destination[31]  = (source[0] >> 0) & 0x01;
  }
};
template <typename Tp>
struct __struct_bitpack_impl<Tp,4,2>
{
  static const size_t unit_size = 32;
  static const size_t bits_total = 64;
  static const size_t loop_total = 32;
  static const size_t bit_size = 2;
  static const Tp     mask = 0x03;
  static inline
  void pack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] & 0x03) << 30;
    destination[0] |= (source[1] & 0x03) << 28;
    destination[0] |= (source[2] & 0x03) << 26;
    destination[0] |= (source[3] & 0x03) << 24;
    destination[0] |= (source[4] & 0x03) << 22;
    destination[0] |= (source[5] & 0x03) << 20;
    destination[0] |= (source[6] & 0x03) << 18;
    destination[0] |= (source[7] & 0x03) << 16;
    destination[0] |= (source[8] & 0x03) << 14;
    destination[0] |= (source[9] & 0x03) << 12;
    destination[0] |= (source[10] & 0x03) << 10;
    destination[0] |= (source[11] & 0x03) << 8;
    destination[0] |= (source[12] & 0x03) << 6;
    destination[0] |= (source[13] & 0x03) << 4;
    destination[0] |= (source[14] & 0x03) << 2;
    destination[0] |= (source[15] & 0x03) << 0;
    destination[1]  = (source[16] & 0x03) << 30;
    destination[1] |= (source[17] & 0x03) << 28;
    destination[1] |= (source[18] & 0x03) << 26;
    destination[1] |= (source[19] & 0x03) << 24;
    destination[1] |= (source[20] & 0x03) << 22;
    destination[1] |= (source[21] & 0x03) << 20;
    destination[1] |= (source[22] & 0x03) << 18;
    destination[1] |= (source[23] & 0x03) << 16;
    destination[1] |= (source[24] & 0x03) << 14;
    destination[1] |= (source[25] & 0x03) << 12;
    destination[1] |= (source[26] & 0x03) << 10;
    destination[1] |= (source[27] & 0x03) << 8;
    destination[1] |= (source[28] & 0x03) << 6;
    destination[1] |= (source[29] & 0x03) << 4;
    destination[1] |= (source[30] & 0x03) << 2;
    destination[1] |= (source[31] & 0x03) << 0;
  }
  static inline
  void unpack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] >> 30) & 0x03;
    destination[1]  = (source[0] >> 28) & 0x03;
    destination[2]  = (source[0] >> 26) & 0x03;
    destination[3]  = (source[0] >> 24) & 0x03;
    destination[4]  = (source[0] >> 22) & 0x03;
    destination[5]  = (source[0] >> 20) & 0x03;
    destination[6]  = (source[0] >> 18) & 0x03;
    destination[7]  = (source[0] >> 16) & 0x03;
    destination[8]  = (source[0] >> 14) & 0x03;
    destination[9]  = (source[0] >> 12) & 0x03;
    destination[10]  = (source[0] >> 10) & 0x03;
    destination[11]  = (source[0] >> 8) & 0x03;
    destination[12]  = (source[0] >> 6) & 0x03;
    destination[13]  = (source[0] >> 4) & 0x03;
    destination[14]  = (source[0] >> 2) & 0x03;
    destination[15]  = (source[0] >> 0) & 0x03;
    destination[16]  = (source[1] >> 30) & 0x03;
    destination[17]  = (source[1] >> 28) & 0x03;
    destination[18]  = (source[1] >> 26) & 0x03;
    destination[19]  = (source[1] >> 24) & 0x03;
    destination[20]  = (source[1] >> 22) & 0x03;
    destination[21]  = (source[1] >> 20) & 0x03;
    destination[22]  = (source[1] >> 18) & 0x03;
    destination[23]  = (source[1] >> 16) & 0x03;
    destination[24]  = (source[1] >> 14) & 0x03;
    destination[25]  = (source[1] >> 12) & 0x03;
    destination[26]  = (source[1] >> 10) & 0x03;
    destination[27]  = (source[1] >> 8) & 0x03;
    destination[28]  = (source[1] >> 6) & 0x03;
    destination[29]  = (source[1] >> 4) & 0x03;
    destination[30]  = (source[1] >> 2) & 0x03;
    destination[31]  = (source[1] >> 0) & 0x03;
  }
};
template <typename Tp>
struct __struct_bitpack_impl<Tp,4,3>
{
  static const size_t unit_size = 32;
  static const size_t bits_total = 96;
  static const size_t loop_total = 32;
  static const size_t bit_size = 3;
  static const Tp     mask = 0x07;
  static inline
  void pack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] & 0x07) << 29;
    destination[0] |= (source[1] & 0x07) << 26;
    destination[0] |= (source[2] & 0x07) << 23;
    destination[0] |= (source[3] & 0x07) << 20;
    destination[0] |= (source[4] & 0x07) << 17;
    destination[0] |= (source[5] & 0x07) << 14;
    destination[0] |= (source[6] & 0x07) << 11;
    destination[0] |= (source[7] & 0x07) << 8;
    destination[0] |= (source[8] & 0x07) << 5;
    destination[0] |= (source[9] & 0x07) << 2;
    destination[0] |= (source[10] & 0x07) >> 1;
    destination[1]  = (source[10] & 0x07) << 31;
    destination[1] |= (source[11] & 0x07) << 28;
    destination[1] |= (source[12] & 0x07) << 25;
    destination[1] |= (source[13] & 0x07) << 22;
    destination[1] |= (source[14] & 0x07) << 19;
    destination[1] |= (source[15] & 0x07) << 16;
    destination[1] |= (source[16] & 0x07) << 13;
    destination[1] |= (source[17] & 0x07) << 10;
    destination[1] |= (source[18] & 0x07) << 7;
    destination[1] |= (source[19] & 0x07) << 4;
    destination[1] |= (source[20] & 0x07) << 1;
    destination[1] |= (source[21] & 0x07) >> 2;
    destination[2]  = (source[21] & 0x07) << 30;
    destination[2] |= (source[22] & 0x07) << 27;
    destination[2] |= (source[23] & 0x07) << 24;
    destination[2] |= (source[24] & 0x07) << 21;
    destination[2] |= (source[25] & 0x07) << 18;
    destination[2] |= (source[26] & 0x07) << 15;
    destination[2] |= (source[27] & 0x07) << 12;
    destination[2] |= (source[28] & 0x07) << 9;
    destination[2] |= (source[29] & 0x07) << 6;
    destination[2] |= (source[30] & 0x07) << 3;
    destination[2] |= (source[31] & 0x07) << 0;
  }
  static inline
  void unpack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] >> 29) & 0x07;
    destination[1]  = (source[0] >> 26) & 0x07;
    destination[2]  = (source[0] >> 23) & 0x07;
    destination[3]  = (source[0] >> 20) & 0x07;
    destination[4]  = (source[0] >> 17) & 0x07;
    destination[5]  = (source[0] >> 14) & 0x07;
    destination[6]  = (source[0] >> 11) & 0x07;
    destination[7]  = (source[0] >> 8) & 0x07;
    destination[8]  = (source[0] >> 5) & 0x07;
    destination[9]  = (source[0] >> 2) & 0x07;
    destination[10]  = (source[0] << 1) & 0x07;
    destination[10] |= (source[1] >> 31) & 0x07;
    destination[11]  = (source[1] >> 28) & 0x07;
    destination[12]  = (source[1] >> 25) & 0x07;
    destination[13]  = (source[1] >> 22) & 0x07;
    destination[14]  = (source[1] >> 19) & 0x07;
    destination[15]  = (source[1] >> 16) & 0x07;
    destination[16]  = (source[1] >> 13) & 0x07;
    destination[17]  = (source[1] >> 10) & 0x07;
    destination[18]  = (source[1] >> 7) & 0x07;
    destination[19]  = (source[1] >> 4) & 0x07;
    destination[20]  = (source[1] >> 1) & 0x07;
    destination[21]  = (source[1] << 2) & 0x07;
    destination[21] |= (source[2] >> 30) & 0x07;
    destination[22]  = (source[2] >> 27) & 0x07;
    destination[23]  = (source[2] >> 24) & 0x07;
    destination[24]  = (source[2] >> 21) & 0x07;
    destination[25]  = (source[2] >> 18) & 0x07;
    destination[26]  = (source[2] >> 15) & 0x07;
    destination[27]  = (source[2] >> 12) & 0x07;
    destination[28]  = (source[2] >> 9) & 0x07;
    destination[29]  = (source[2] >> 6) & 0x07;
    destination[30]  = (source[2] >> 3) & 0x07;
    destination[31]  = (source[2] >> 0) & 0x07;
  }
};
template <typename Tp>
struct __struct_bitpack_impl<Tp,4,4>
{
  static const size_t unit_size = 32;
  static const size_t bits_total = 128;
  static const size_t loop_total = 32;
  static const size_t bit_size = 4;
  static const Tp     mask = 0x0f;
  static inline
  void pack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] & 0x0f) << 28;
    destination[0] |= (source[1] & 0x0f) << 24;
    destination[0] |= (source[2] & 0x0f) << 20;
    destination[0] |= (source[3] & 0x0f) << 16;
    destination[0] |= (source[4] & 0x0f) << 12;
    destination[0] |= (source[5] & 0x0f) << 8;
    destination[0] |= (source[6] & 0x0f) << 4;
    destination[0] |= (source[7] & 0x0f) << 0;
    destination[1]  = (source[8] & 0x0f) << 28;
    destination[1] |= (source[9] & 0x0f) << 24;
    destination[1] |= (source[10] & 0x0f) << 20;
    destination[1] |= (source[11] & 0x0f) << 16;
    destination[1] |= (source[12] & 0x0f) << 12;
    destination[1] |= (source[13] & 0x0f) << 8;
    destination[1] |= (source[14] & 0x0f) << 4;
    destination[1] |= (source[15] & 0x0f) << 0;
    destination[2]  = (source[16] & 0x0f) << 28;
    destination[2] |= (source[17] & 0x0f) << 24;
    destination[2] |= (source[18] & 0x0f) << 20;
    destination[2] |= (source[19] & 0x0f) << 16;
    destination[2] |= (source[20] & 0x0f) << 12;
    destination[2] |= (source[21] & 0x0f) << 8;
    destination[2] |= (source[22] & 0x0f) << 4;
    destination[2] |= (source[23] & 0x0f) << 0;
    destination[3]  = (source[24] & 0x0f) << 28;
    destination[3] |= (source[25] & 0x0f) << 24;
    destination[3] |= (source[26] & 0x0f) << 20;
    destination[3] |= (source[27] & 0x0f) << 16;
    destination[3] |= (source[28] & 0x0f) << 12;
    destination[3] |= (source[29] & 0x0f) << 8;
    destination[3] |= (source[30] & 0x0f) << 4;
    destination[3] |= (source[31] & 0x0f) << 0;
  }
  static inline
  void unpack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] >> 28) & 0x0f;
    destination[1]  = (source[0] >> 24) & 0x0f;
    destination[2]  = (source[0] >> 20) & 0x0f;
    destination[3]  = (source[0] >> 16) & 0x0f;
    destination[4]  = (source[0] >> 12) & 0x0f;
    destination[5]  = (source[0] >> 8) & 0x0f;
    destination[6]  = (source[0] >> 4) & 0x0f;
    destination[7]  = (source[0] >> 0) & 0x0f;
    destination[8]  = (source[1] >> 28) & 0x0f;
    destination[9]  = (source[1] >> 24) & 0x0f;
    destination[10]  = (source[1] >> 20) & 0x0f;
    destination[11]  = (source[1] >> 16) & 0x0f;
    destination[12]  = (source[1] >> 12) & 0x0f;
    destination[13]  = (source[1] >> 8) & 0x0f;
    destination[14]  = (source[1] >> 4) & 0x0f;
    destination[15]  = (source[1] >> 0) & 0x0f;
    destination[16]  = (source[2] >> 28) & 0x0f;
    destination[17]  = (source[2] >> 24) & 0x0f;
    destination[18]  = (source[2] >> 20) & 0x0f;
    destination[19]  = (source[2] >> 16) & 0x0f;
    destination[20]  = (source[2] >> 12) & 0x0f;
    destination[21]  = (source[2] >> 8) & 0x0f;
    destination[22]  = (source[2] >> 4) & 0x0f;
    destination[23]  = (source[2] >> 0) & 0x0f;
    destination[24]  = (source[3] >> 28) & 0x0f;
    destination[25]  = (source[3] >> 24) & 0x0f;
    destination[26]  = (source[3] >> 20) & 0x0f;
    destination[27]  = (source[3] >> 16) & 0x0f;
    destination[28]  = (source[3] >> 12) & 0x0f;
    destination[29]  = (source[3] >> 8) & 0x0f;
    destination[30]  = (source[3] >> 4) & 0x0f;
    destination[31]  = (source[3] >> 0) & 0x0f;
  }
};
template <typename Tp>
struct __struct_bitpack_impl<Tp,4,5>
{
  static const size_t unit_size = 32;
  static const size_t bits_total = 160;
  static const size_t loop_total = 32;
  static const size_t bit_size = 5;
  static const Tp     mask = 0x1f;
  static inline
  void pack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] & 0x1f) << 27;
    destination[0] |= (source[1] & 0x1f) << 22;
    destination[0] |= (source[2] & 0x1f) << 17;
    destination[0] |= (source[3] & 0x1f) << 12;
    destination[0] |= (source[4] & 0x1f) << 7;
    destination[0] |= (source[5] & 0x1f) << 2;
    destination[0] |= (source[6] & 0x1f) >> 3;
    destination[1]  = (source[6] & 0x1f) << 29;
    destination[1] |= (source[7] & 0x1f) << 24;
    destination[1] |= (source[8] & 0x1f) << 19;
    destination[1] |= (source[9] & 0x1f) << 14;
    destination[1] |= (source[10] & 0x1f) << 9;
    destination[1] |= (source[11] & 0x1f) << 4;
    destination[1] |= (source[12] & 0x1f) >> 1;
    destination[2]  = (source[12] & 0x1f) << 31;
    destination[2] |= (source[13] & 0x1f) << 26;
    destination[2] |= (source[14] & 0x1f) << 21;
    destination[2] |= (source[15] & 0x1f) << 16;
    destination[2] |= (source[16] & 0x1f) << 11;
    destination[2] |= (source[17] & 0x1f) << 6;
    destination[2] |= (source[18] & 0x1f) << 1;
    destination[2] |= (source[19] & 0x1f) >> 4;
    destination[3]  = (source[19] & 0x1f) << 28;
    destination[3] |= (source[20] & 0x1f) << 23;
    destination[3] |= (source[21] & 0x1f) << 18;
    destination[3] |= (source[22] & 0x1f) << 13;
    destination[3] |= (source[23] & 0x1f) << 8;
    destination[3] |= (source[24] & 0x1f) << 3;
    destination[3] |= (source[25] & 0x1f) >> 2;
    destination[4]  = (source[25] & 0x1f) << 30;
    destination[4] |= (source[26] & 0x1f) << 25;
    destination[4] |= (source[27] & 0x1f) << 20;
    destination[4] |= (source[28] & 0x1f) << 15;
    destination[4] |= (source[29] & 0x1f) << 10;
    destination[4] |= (source[30] & 0x1f) << 5;
    destination[4] |= (source[31] & 0x1f) << 0;
  }
  static inline
  void unpack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] >> 27) & 0x1f;
    destination[1]  = (source[0] >> 22) & 0x1f;
    destination[2]  = (source[0] >> 17) & 0x1f;
    destination[3]  = (source[0] >> 12) & 0x1f;
    destination[4]  = (source[0] >> 7) & 0x1f;
    destination[5]  = (source[0] >> 2) & 0x1f;
    destination[6]  = (source[0] << 3) & 0x1f;
    destination[6] |= (source[1] >> 29) & 0x1f;
    destination[7]  = (source[1] >> 24) & 0x1f;
    destination[8]  = (source[1] >> 19) & 0x1f;
    destination[9]  = (source[1] >> 14) & 0x1f;
    destination[10]  = (source[1] >> 9) & 0x1f;
    destination[11]  = (source[1] >> 4) & 0x1f;
    destination[12]  = (source[1] << 1) & 0x1f;
    destination[12] |= (source[2] >> 31) & 0x1f;
    destination[13]  = (source[2] >> 26) & 0x1f;
    destination[14]  = (source[2] >> 21) & 0x1f;
    destination[15]  = (source[2] >> 16) & 0x1f;
    destination[16]  = (source[2] >> 11) & 0x1f;
    destination[17]  = (source[2] >> 6) & 0x1f;
    destination[18]  = (source[2] >> 1) & 0x1f;
    destination[19]  = (source[2] << 4) & 0x1f;
    destination[19] |= (source[3] >> 28) & 0x1f;
    destination[20]  = (source[3] >> 23) & 0x1f;
    destination[21]  = (source[3] >> 18) & 0x1f;
    destination[22]  = (source[3] >> 13) & 0x1f;
    destination[23]  = (source[3] >> 8) & 0x1f;
    destination[24]  = (source[3] >> 3) & 0x1f;
    destination[25]  = (source[3] << 2) & 0x1f;
    destination[25] |= (source[4] >> 30) & 0x1f;
    destination[26]  = (source[4] >> 25) & 0x1f;
    destination[27]  = (source[4] >> 20) & 0x1f;
    destination[28]  = (source[4] >> 15) & 0x1f;
    destination[29]  = (source[4] >> 10) & 0x1f;
    destination[30]  = (source[4] >> 5) & 0x1f;
    destination[31]  = (source[4] >> 0) & 0x1f;
  }
};
template <typename Tp>
struct __struct_bitpack_impl<Tp,4,6>
{
  static const size_t unit_size = 32;
  static const size_t bits_total = 192;
  static const size_t loop_total = 32;
  static const size_t bit_size = 6;
  static const Tp     mask = 0x3f;
  static inline
  void pack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] & 0x3f) << 26;
    destination[0] |= (source[1] & 0x3f) << 20;
    destination[0] |= (source[2] & 0x3f) << 14;
    destination[0] |= (source[3] & 0x3f) << 8;
    destination[0] |= (source[4] & 0x3f) << 2;
    destination[0] |= (source[5] & 0x3f) >> 4;
    destination[1]  = (source[5] & 0x3f) << 28;
    destination[1] |= (source[6] & 0x3f) << 22;
    destination[1] |= (source[7] & 0x3f) << 16;
    destination[1] |= (source[8] & 0x3f) << 10;
    destination[1] |= (source[9] & 0x3f) << 4;
    destination[1] |= (source[10] & 0x3f) >> 2;
    destination[2]  = (source[10] & 0x3f) << 30;
    destination[2] |= (source[11] & 0x3f) << 24;
    destination[2] |= (source[12] & 0x3f) << 18;
    destination[2] |= (source[13] & 0x3f) << 12;
    destination[2] |= (source[14] & 0x3f) << 6;
    destination[2] |= (source[15] & 0x3f) << 0;
    destination[3]  = (source[16] & 0x3f) << 26;
    destination[3] |= (source[17] & 0x3f) << 20;
    destination[3] |= (source[18] & 0x3f) << 14;
    destination[3] |= (source[19] & 0x3f) << 8;
    destination[3] |= (source[20] & 0x3f) << 2;
    destination[3] |= (source[21] & 0x3f) >> 4;
    destination[4]  = (source[21] & 0x3f) << 28;
    destination[4] |= (source[22] & 0x3f) << 22;
    destination[4] |= (source[23] & 0x3f) << 16;
    destination[4] |= (source[24] & 0x3f) << 10;
    destination[4] |= (source[25] & 0x3f) << 4;
    destination[4] |= (source[26] & 0x3f) >> 2;
    destination[5]  = (source[26] & 0x3f) << 30;
    destination[5] |= (source[27] & 0x3f) << 24;
    destination[5] |= (source[28] & 0x3f) << 18;
    destination[5] |= (source[29] & 0x3f) << 12;
    destination[5] |= (source[30] & 0x3f) << 6;
    destination[5] |= (source[31] & 0x3f) << 0;
  }
  static inline
  void unpack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] >> 26) & 0x3f;
    destination[1]  = (source[0] >> 20) & 0x3f;
    destination[2]  = (source[0] >> 14) & 0x3f;
    destination[3]  = (source[0] >> 8) & 0x3f;
    destination[4]  = (source[0] >> 2) & 0x3f;
    destination[5]  = (source[0] << 4) & 0x3f;
    destination[5] |= (source[1] >> 28) & 0x3f;
    destination[6]  = (source[1] >> 22) & 0x3f;
    destination[7]  = (source[1] >> 16) & 0x3f;
    destination[8]  = (source[1] >> 10) & 0x3f;
    destination[9]  = (source[1] >> 4) & 0x3f;
    destination[10]  = (source[1] << 2) & 0x3f;
    destination[10] |= (source[2] >> 30) & 0x3f;
    destination[11]  = (source[2] >> 24) & 0x3f;
    destination[12]  = (source[2] >> 18) & 0x3f;
    destination[13]  = (source[2] >> 12) & 0x3f;
    destination[14]  = (source[2] >> 6) & 0x3f;
    destination[15]  = (source[2] >> 0) & 0x3f;
    destination[16]  = (source[3] >> 26) & 0x3f;
    destination[17]  = (source[3] >> 20) & 0x3f;
    destination[18]  = (source[3] >> 14) & 0x3f;
    destination[19]  = (source[3] >> 8) & 0x3f;
    destination[20]  = (source[3] >> 2) & 0x3f;
    destination[21]  = (source[3] << 4) & 0x3f;
    destination[21] |= (source[4] >> 28) & 0x3f;
    destination[22]  = (source[4] >> 22) & 0x3f;
    destination[23]  = (source[4] >> 16) & 0x3f;
    destination[24]  = (source[4] >> 10) & 0x3f;
    destination[25]  = (source[4] >> 4) & 0x3f;
    destination[26]  = (source[4] << 2) & 0x3f;
    destination[26] |= (source[5] >> 30) & 0x3f;
    destination[27]  = (source[5] >> 24) & 0x3f;
    destination[28]  = (source[5] >> 18) & 0x3f;
    destination[29]  = (source[5] >> 12) & 0x3f;
    destination[30]  = (source[5] >> 6) & 0x3f;
    destination[31]  = (source[5] >> 0) & 0x3f;
  }
};
template <typename Tp>
struct __struct_bitpack_impl<Tp,4,7>
{
  static const size_t unit_size = 32;
  static const size_t bits_total = 224;
  static const size_t loop_total = 32;
  static const size_t bit_size = 7;
  static const Tp     mask = 0x7f;
  static inline
  void pack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] & 0x7f) << 25;
    destination[0] |= (source[1] & 0x7f) << 18;
    destination[0] |= (source[2] & 0x7f) << 11;
    destination[0] |= (source[3] & 0x7f) << 4;
    destination[0] |= (source[4] & 0x7f) >> 3;
    destination[1]  = (source[4] & 0x7f) << 29;
    destination[1] |= (source[5] & 0x7f) << 22;
    destination[1] |= (source[6] & 0x7f) << 15;
    destination[1] |= (source[7] & 0x7f) << 8;
    destination[1] |= (source[8] & 0x7f) << 1;
    destination[1] |= (source[9] & 0x7f) >> 6;
    destination[2]  = (source[9] & 0x7f) << 26;
    destination[2] |= (source[10] & 0x7f) << 19;
    destination[2] |= (source[11] & 0x7f) << 12;
    destination[2] |= (source[12] & 0x7f) << 5;
    destination[2] |= (source[13] & 0x7f) >> 2;
    destination[3]  = (source[13] & 0x7f) << 30;
    destination[3] |= (source[14] & 0x7f) << 23;
    destination[3] |= (source[15] & 0x7f) << 16;
    destination[3] |= (source[16] & 0x7f) << 9;
    destination[3] |= (source[17] & 0x7f) << 2;
    destination[3] |= (source[18] & 0x7f) >> 5;
    destination[4]  = (source[18] & 0x7f) << 27;
    destination[4] |= (source[19] & 0x7f) << 20;
    destination[4] |= (source[20] & 0x7f) << 13;
    destination[4] |= (source[21] & 0x7f) << 6;
    destination[4] |= (source[22] & 0x7f) >> 1;
    destination[5]  = (source[22] & 0x7f) << 31;
    destination[5] |= (source[23] & 0x7f) << 24;
    destination[5] |= (source[24] & 0x7f) << 17;
    destination[5] |= (source[25] & 0x7f) << 10;
    destination[5] |= (source[26] & 0x7f) << 3;
    destination[5] |= (source[27] & 0x7f) >> 4;
    destination[6]  = (source[27] & 0x7f) << 28;
    destination[6] |= (source[28] & 0x7f) << 21;
    destination[6] |= (source[29] & 0x7f) << 14;
    destination[6] |= (source[30] & 0x7f) << 7;
    destination[6] |= (source[31] & 0x7f) << 0;
  }
  static inline
  void unpack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] >> 25) & 0x7f;
    destination[1]  = (source[0] >> 18) & 0x7f;
    destination[2]  = (source[0] >> 11) & 0x7f;
    destination[3]  = (source[0] >> 4) & 0x7f;
    destination[4]  = (source[0] << 3) & 0x7f;
    destination[4] |= (source[1] >> 29) & 0x7f;
    destination[5]  = (source[1] >> 22) & 0x7f;
    destination[6]  = (source[1] >> 15) & 0x7f;
    destination[7]  = (source[1] >> 8) & 0x7f;
    destination[8]  = (source[1] >> 1) & 0x7f;
    destination[9]  = (source[1] << 6) & 0x7f;
    destination[9] |= (source[2] >> 26) & 0x7f;
    destination[10]  = (source[2] >> 19) & 0x7f;
    destination[11]  = (source[2] >> 12) & 0x7f;
    destination[12]  = (source[2] >> 5) & 0x7f;
    destination[13]  = (source[2] << 2) & 0x7f;
    destination[13] |= (source[3] >> 30) & 0x7f;
    destination[14]  = (source[3] >> 23) & 0x7f;
    destination[15]  = (source[3] >> 16) & 0x7f;
    destination[16]  = (source[3] >> 9) & 0x7f;
    destination[17]  = (source[3] >> 2) & 0x7f;
    destination[18]  = (source[3] << 5) & 0x7f;
    destination[18] |= (source[4] >> 27) & 0x7f;
    destination[19]  = (source[4] >> 20) & 0x7f;
    destination[20]  = (source[4] >> 13) & 0x7f;
    destination[21]  = (source[4] >> 6) & 0x7f;
    destination[22]  = (source[4] << 1) & 0x7f;
    destination[22] |= (source[5] >> 31) & 0x7f;
    destination[23]  = (source[5] >> 24) & 0x7f;
    destination[24]  = (source[5] >> 17) & 0x7f;
    destination[25]  = (source[5] >> 10) & 0x7f;
    destination[26]  = (source[5] >> 3) & 0x7f;
    destination[27]  = (source[5] << 4) & 0x7f;
    destination[27] |= (source[6] >> 28) & 0x7f;
    destination[28]  = (source[6] >> 21) & 0x7f;
    destination[29]  = (source[6] >> 14) & 0x7f;
    destination[30]  = (source[6] >> 7) & 0x7f;
    destination[31]  = (source[6] >> 0) & 0x7f;
  }
};
template <typename Tp>
struct __struct_bitpack_impl<Tp,4,8>
{
  static const size_t unit_size = 32;
  static const size_t bits_total = 256;
  static const size_t loop_total = 32;
  static const size_t bit_size = 8;
  static const Tp     mask = 0xff;
  static inline
  void pack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] & 0xff) << 24;
    destination[0] |= (source[1] & 0xff) << 16;
    destination[0] |= (source[2] & 0xff) << 8;
    destination[0] |= (source[3] & 0xff) << 0;
    destination[1]  = (source[4] & 0xff) << 24;
    destination[1] |= (source[5] & 0xff) << 16;
    destination[1] |= (source[6] & 0xff) << 8;
    destination[1] |= (source[7] & 0xff) << 0;
    destination[2]  = (source[8] & 0xff) << 24;
    destination[2] |= (source[9] & 0xff) << 16;
    destination[2] |= (source[10] & 0xff) << 8;
    destination[2] |= (source[11] & 0xff) << 0;
    destination[3]  = (source[12] & 0xff) << 24;
    destination[3] |= (source[13] & 0xff) << 16;
    destination[3] |= (source[14] & 0xff) << 8;
    destination[3] |= (source[15] & 0xff) << 0;
    destination[4]  = (source[16] & 0xff) << 24;
    destination[4] |= (source[17] & 0xff) << 16;
    destination[4] |= (source[18] & 0xff) << 8;
    destination[4] |= (source[19] & 0xff) << 0;
    destination[5]  = (source[20] & 0xff) << 24;
    destination[5] |= (source[21] & 0xff) << 16;
    destination[5] |= (source[22] & 0xff) << 8;
    destination[5] |= (source[23] & 0xff) << 0;
    destination[6]  = (source[24] & 0xff) << 24;
    destination[6] |= (source[25] & 0xff) << 16;
    destination[6] |= (source[26] & 0xff) << 8;
    destination[6] |= (source[27] & 0xff) << 0;
    destination[7]  = (source[28] & 0xff) << 24;
    destination[7] |= (source[29] & 0xff) << 16;
    destination[7] |= (source[30] & 0xff) << 8;
    destination[7] |= (source[31] & 0xff) << 0;
  }
  static inline
  void unpack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] >> 24) & 0xff;
    destination[1]  = (source[0] >> 16) & 0xff;
    destination[2]  = (source[0] >> 8) & 0xff;
    destination[3]  = (source[0] >> 0) & 0xff;
    destination[4]  = (source[1] >> 24) & 0xff;
    destination[5]  = (source[1] >> 16) & 0xff;
    destination[6]  = (source[1] >> 8) & 0xff;
    destination[7]  = (source[1] >> 0) & 0xff;
    destination[8]  = (source[2] >> 24) & 0xff;
    destination[9]  = (source[2] >> 16) & 0xff;
    destination[10]  = (source[2] >> 8) & 0xff;
    destination[11]  = (source[2] >> 0) & 0xff;
    destination[12]  = (source[3] >> 24) & 0xff;
    destination[13]  = (source[3] >> 16) & 0xff;
    destination[14]  = (source[3] >> 8) & 0xff;
    destination[15]  = (source[3] >> 0) & 0xff;
    destination[16]  = (source[4] >> 24) & 0xff;
    destination[17]  = (source[4] >> 16) & 0xff;
    destination[18]  = (source[4] >> 8) & 0xff;
    destination[19]  = (source[4] >> 0) & 0xff;
    destination[20]  = (source[5] >> 24) & 0xff;
    destination[21]  = (source[5] >> 16) & 0xff;
    destination[22]  = (source[5] >> 8) & 0xff;
    destination[23]  = (source[5] >> 0) & 0xff;
    destination[24]  = (source[6] >> 24) & 0xff;
    destination[25]  = (source[6] >> 16) & 0xff;
    destination[26]  = (source[6] >> 8) & 0xff;
    destination[27]  = (source[6] >> 0) & 0xff;
    destination[28]  = (source[7] >> 24) & 0xff;
    destination[29]  = (source[7] >> 16) & 0xff;
    destination[30]  = (source[7] >> 8) & 0xff;
    destination[31]  = (source[7] >> 0) & 0xff;
  }
};
template <typename Tp>
struct __struct_bitpack_impl<Tp,4,9>
{
  static const size_t unit_size = 32;
  static const size_t bits_total = 288;
  static const size_t loop_total = 32;
  static const size_t bit_size = 9;
  static const Tp     mask = 0x1ff;
  static inline
  void pack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] & 0x1ff) << 23;
    destination[0] |= (source[1] & 0x1ff) << 14;
    destination[0] |= (source[2] & 0x1ff) << 5;
    destination[0] |= (source[3] & 0x1ff) >> 4;
    destination[1]  = (source[3] & 0x1ff) << 28;
    destination[1] |= (source[4] & 0x1ff) << 19;
    destination[1] |= (source[5] & 0x1ff) << 10;
    destination[1] |= (source[6] & 0x1ff) << 1;
    destination[1] |= (source[7] & 0x1ff) >> 8;
    destination[2]  = (source[7] & 0x1ff) << 24;
    destination[2] |= (source[8] & 0x1ff) << 15;
    destination[2] |= (source[9] & 0x1ff) << 6;
    destination[2] |= (source[10] & 0x1ff) >> 3;
    destination[3]  = (source[10] & 0x1ff) << 29;
    destination[3] |= (source[11] & 0x1ff) << 20;
    destination[3] |= (source[12] & 0x1ff) << 11;
    destination[3] |= (source[13] & 0x1ff) << 2;
    destination[3] |= (source[14] & 0x1ff) >> 7;
    destination[4]  = (source[14] & 0x1ff) << 25;
    destination[4] |= (source[15] & 0x1ff) << 16;
    destination[4] |= (source[16] & 0x1ff) << 7;
    destination[4] |= (source[17] & 0x1ff) >> 2;
    destination[5]  = (source[17] & 0x1ff) << 30;
    destination[5] |= (source[18] & 0x1ff) << 21;
    destination[5] |= (source[19] & 0x1ff) << 12;
    destination[5] |= (source[20] & 0x1ff) << 3;
    destination[5] |= (source[21] & 0x1ff) >> 6;
    destination[6]  = (source[21] & 0x1ff) << 26;
    destination[6] |= (source[22] & 0x1ff) << 17;
    destination[6] |= (source[23] & 0x1ff) << 8;
    destination[6] |= (source[24] & 0x1ff) >> 1;
    destination[7]  = (source[24] & 0x1ff) << 31;
    destination[7] |= (source[25] & 0x1ff) << 22;
    destination[7] |= (source[26] & 0x1ff) << 13;
    destination[7] |= (source[27] & 0x1ff) << 4;
    destination[7] |= (source[28] & 0x1ff) >> 5;
    destination[8]  = (source[28] & 0x1ff) << 27;
    destination[8] |= (source[29] & 0x1ff) << 18;
    destination[8] |= (source[30] & 0x1ff) << 9;
    destination[8] |= (source[31] & 0x1ff) << 0;
  }
  static inline
  void unpack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] >> 23) & 0x1ff;
    destination[1]  = (source[0] >> 14) & 0x1ff;
    destination[2]  = (source[0] >> 5) & 0x1ff;
    destination[3]  = (source[0] << 4) & 0x1ff;
    destination[3] |= (source[1] >> 28) & 0x1ff;
    destination[4]  = (source[1] >> 19) & 0x1ff;
    destination[5]  = (source[1] >> 10) & 0x1ff;
    destination[6]  = (source[1] >> 1) & 0x1ff;
    destination[7]  = (source[1] << 8) & 0x1ff;
    destination[7] |= (source[2] >> 24) & 0x1ff;
    destination[8]  = (source[2] >> 15) & 0x1ff;
    destination[9]  = (source[2] >> 6) & 0x1ff;
    destination[10]  = (source[2] << 3) & 0x1ff;
    destination[10] |= (source[3] >> 29) & 0x1ff;
    destination[11]  = (source[3] >> 20) & 0x1ff;
    destination[12]  = (source[3] >> 11) & 0x1ff;
    destination[13]  = (source[3] >> 2) & 0x1ff;
    destination[14]  = (source[3] << 7) & 0x1ff;
    destination[14] |= (source[4] >> 25) & 0x1ff;
    destination[15]  = (source[4] >> 16) & 0x1ff;
    destination[16]  = (source[4] >> 7) & 0x1ff;
    destination[17]  = (source[4] << 2) & 0x1ff;
    destination[17] |= (source[5] >> 30) & 0x1ff;
    destination[18]  = (source[5] >> 21) & 0x1ff;
    destination[19]  = (source[5] >> 12) & 0x1ff;
    destination[20]  = (source[5] >> 3) & 0x1ff;
    destination[21]  = (source[5] << 6) & 0x1ff;
    destination[21] |= (source[6] >> 26) & 0x1ff;
    destination[22]  = (source[6] >> 17) & 0x1ff;
    destination[23]  = (source[6] >> 8) & 0x1ff;
    destination[24]  = (source[6] << 1) & 0x1ff;
    destination[24] |= (source[7] >> 31) & 0x1ff;
    destination[25]  = (source[7] >> 22) & 0x1ff;
    destination[26]  = (source[7] >> 13) & 0x1ff;
    destination[27]  = (source[7] >> 4) & 0x1ff;
    destination[28]  = (source[7] << 5) & 0x1ff;
    destination[28] |= (source[8] >> 27) & 0x1ff;
    destination[29]  = (source[8] >> 18) & 0x1ff;
    destination[30]  = (source[8] >> 9) & 0x1ff;
    destination[31]  = (source[8] >> 0) & 0x1ff;
  }
};
template <typename Tp>
struct __struct_bitpack_impl<Tp,4,10>
{
  static const size_t unit_size = 32;
  static const size_t bits_total = 320;
  static const size_t loop_total = 32;
  static const size_t bit_size = 10;
  static const Tp     mask = 0x3ff;
  static inline
  void pack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] & 0x3ff) << 22;
    destination[0] |= (source[1] & 0x3ff) << 12;
    destination[0] |= (source[2] & 0x3ff) << 2;
    destination[0] |= (source[3] & 0x3ff) >> 8;
    destination[1]  = (source[3] & 0x3ff) << 24;
    destination[1] |= (source[4] & 0x3ff) << 14;
    destination[1] |= (source[5] & 0x3ff) << 4;
    destination[1] |= (source[6] & 0x3ff) >> 6;
    destination[2]  = (source[6] & 0x3ff) << 26;
    destination[2] |= (source[7] & 0x3ff) << 16;
    destination[2] |= (source[8] & 0x3ff) << 6;
    destination[2] |= (source[9] & 0x3ff) >> 4;
    destination[3]  = (source[9] & 0x3ff) << 28;
    destination[3] |= (source[10] & 0x3ff) << 18;
    destination[3] |= (source[11] & 0x3ff) << 8;
    destination[3] |= (source[12] & 0x3ff) >> 2;
    destination[4]  = (source[12] & 0x3ff) << 30;
    destination[4] |= (source[13] & 0x3ff) << 20;
    destination[4] |= (source[14] & 0x3ff) << 10;
    destination[4] |= (source[15] & 0x3ff) << 0;
    destination[5]  = (source[16] & 0x3ff) << 22;
    destination[5] |= (source[17] & 0x3ff) << 12;
    destination[5] |= (source[18] & 0x3ff) << 2;
    destination[5] |= (source[19] & 0x3ff) >> 8;
    destination[6]  = (source[19] & 0x3ff) << 24;
    destination[6] |= (source[20] & 0x3ff) << 14;
    destination[6] |= (source[21] & 0x3ff) << 4;
    destination[6] |= (source[22] & 0x3ff) >> 6;
    destination[7]  = (source[22] & 0x3ff) << 26;
    destination[7] |= (source[23] & 0x3ff) << 16;
    destination[7] |= (source[24] & 0x3ff) << 6;
    destination[7] |= (source[25] & 0x3ff) >> 4;
    destination[8]  = (source[25] & 0x3ff) << 28;
    destination[8] |= (source[26] & 0x3ff) << 18;
    destination[8] |= (source[27] & 0x3ff) << 8;
    destination[8] |= (source[28] & 0x3ff) >> 2;
    destination[9]  = (source[28] & 0x3ff) << 30;
    destination[9] |= (source[29] & 0x3ff) << 20;
    destination[9] |= (source[30] & 0x3ff) << 10;
    destination[9] |= (source[31] & 0x3ff) << 0;
  }
  static inline
  void unpack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] >> 22) & 0x3ff;
    destination[1]  = (source[0] >> 12) & 0x3ff;
    destination[2]  = (source[0] >> 2) & 0x3ff;
    destination[3]  = (source[0] << 8) & 0x3ff;
    destination[3] |= (source[1] >> 24) & 0x3ff;
    destination[4]  = (source[1] >> 14) & 0x3ff;
    destination[5]  = (source[1] >> 4) & 0x3ff;
    destination[6]  = (source[1] << 6) & 0x3ff;
    destination[6] |= (source[2] >> 26) & 0x3ff;
    destination[7]  = (source[2] >> 16) & 0x3ff;
    destination[8]  = (source[2] >> 6) & 0x3ff;
    destination[9]  = (source[2] << 4) & 0x3ff;
    destination[9] |= (source[3] >> 28) & 0x3ff;
    destination[10]  = (source[3] >> 18) & 0x3ff;
    destination[11]  = (source[3] >> 8) & 0x3ff;
    destination[12]  = (source[3] << 2) & 0x3ff;
    destination[12] |= (source[4] >> 30) & 0x3ff;
    destination[13]  = (source[4] >> 20) & 0x3ff;
    destination[14]  = (source[4] >> 10) & 0x3ff;
    destination[15]  = (source[4] >> 0) & 0x3ff;
    destination[16]  = (source[5] >> 22) & 0x3ff;
    destination[17]  = (source[5] >> 12) & 0x3ff;
    destination[18]  = (source[5] >> 2) & 0x3ff;
    destination[19]  = (source[5] << 8) & 0x3ff;
    destination[19] |= (source[6] >> 24) & 0x3ff;
    destination[20]  = (source[6] >> 14) & 0x3ff;
    destination[21]  = (source[6] >> 4) & 0x3ff;
    destination[22]  = (source[6] << 6) & 0x3ff;
    destination[22] |= (source[7] >> 26) & 0x3ff;
    destination[23]  = (source[7] >> 16) & 0x3ff;
    destination[24]  = (source[7] >> 6) & 0x3ff;
    destination[25]  = (source[7] << 4) & 0x3ff;
    destination[25] |= (source[8] >> 28) & 0x3ff;
    destination[26]  = (source[8] >> 18) & 0x3ff;
    destination[27]  = (source[8] >> 8) & 0x3ff;
    destination[28]  = (source[8] << 2) & 0x3ff;
    destination[28] |= (source[9] >> 30) & 0x3ff;
    destination[29]  = (source[9] >> 20) & 0x3ff;
    destination[30]  = (source[9] >> 10) & 0x3ff;
    destination[31]  = (source[9] >> 0) & 0x3ff;
  }
};
template <typename Tp>
struct __struct_bitpack_impl<Tp,4,11>
{
  static const size_t unit_size = 32;
  static const size_t bits_total = 352;
  static const size_t loop_total = 32;
  static const size_t bit_size = 11;
  static const Tp     mask = 0x7ff;
  static inline
  void pack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] & 0x7ff) << 21;
    destination[0] |= (source[1] & 0x7ff) << 10;
    destination[0] |= (source[2] & 0x7ff) >> 1;
    destination[1]  = (source[2] & 0x7ff) << 31;
    destination[1] |= (source[3] & 0x7ff) << 20;
    destination[1] |= (source[4] & 0x7ff) << 9;
    destination[1] |= (source[5] & 0x7ff) >> 2;
    destination[2]  = (source[5] & 0x7ff) << 30;
    destination[2] |= (source[6] & 0x7ff) << 19;
    destination[2] |= (source[7] & 0x7ff) << 8;
    destination[2] |= (source[8] & 0x7ff) >> 3;
    destination[3]  = (source[8] & 0x7ff) << 29;
    destination[3] |= (source[9] & 0x7ff) << 18;
    destination[3] |= (source[10] & 0x7ff) << 7;
    destination[3] |= (source[11] & 0x7ff) >> 4;
    destination[4]  = (source[11] & 0x7ff) << 28;
    destination[4] |= (source[12] & 0x7ff) << 17;
    destination[4] |= (source[13] & 0x7ff) << 6;
    destination[4] |= (source[14] & 0x7ff) >> 5;
    destination[5]  = (source[14] & 0x7ff) << 27;
    destination[5] |= (source[15] & 0x7ff) << 16;
    destination[5] |= (source[16] & 0x7ff) << 5;
    destination[5] |= (source[17] & 0x7ff) >> 6;
    destination[6]  = (source[17] & 0x7ff) << 26;
    destination[6] |= (source[18] & 0x7ff) << 15;
    destination[6] |= (source[19] & 0x7ff) << 4;
    destination[6] |= (source[20] & 0x7ff) >> 7;
    destination[7]  = (source[20] & 0x7ff) << 25;
    destination[7] |= (source[21] & 0x7ff) << 14;
    destination[7] |= (source[22] & 0x7ff) << 3;
    destination[7] |= (source[23] & 0x7ff) >> 8;
    destination[8]  = (source[23] & 0x7ff) << 24;
    destination[8] |= (source[24] & 0x7ff) << 13;
    destination[8] |= (source[25] & 0x7ff) << 2;
    destination[8] |= (source[26] & 0x7ff) >> 9;
    destination[9]  = (source[26] & 0x7ff) << 23;
    destination[9] |= (source[27] & 0x7ff) << 12;
    destination[9] |= (source[28] & 0x7ff) << 1;
    destination[9] |= (source[29] & 0x7ff) >> 10;
    destination[10]  = (source[29] & 0x7ff) << 22;
    destination[10] |= (source[30] & 0x7ff) << 11;
    destination[10] |= (source[31] & 0x7ff) << 0;
  }
  static inline
  void unpack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] >> 21) & 0x7ff;
    destination[1]  = (source[0] >> 10) & 0x7ff;
    destination[2]  = (source[0] << 1) & 0x7ff;
    destination[2] |= (source[1] >> 31) & 0x7ff;
    destination[3]  = (source[1] >> 20) & 0x7ff;
    destination[4]  = (source[1] >> 9) & 0x7ff;
    destination[5]  = (source[1] << 2) & 0x7ff;
    destination[5] |= (source[2] >> 30) & 0x7ff;
    destination[6]  = (source[2] >> 19) & 0x7ff;
    destination[7]  = (source[2] >> 8) & 0x7ff;
    destination[8]  = (source[2] << 3) & 0x7ff;
    destination[8] |= (source[3] >> 29) & 0x7ff;
    destination[9]  = (source[3] >> 18) & 0x7ff;
    destination[10]  = (source[3] >> 7) & 0x7ff;
    destination[11]  = (source[3] << 4) & 0x7ff;
    destination[11] |= (source[4] >> 28) & 0x7ff;
    destination[12]  = (source[4] >> 17) & 0x7ff;
    destination[13]  = (source[4] >> 6) & 0x7ff;
    destination[14]  = (source[4] << 5) & 0x7ff;
    destination[14] |= (source[5] >> 27) & 0x7ff;
    destination[15]  = (source[5] >> 16) & 0x7ff;
    destination[16]  = (source[5] >> 5) & 0x7ff;
    destination[17]  = (source[5] << 6) & 0x7ff;
    destination[17] |= (source[6] >> 26) & 0x7ff;
    destination[18]  = (source[6] >> 15) & 0x7ff;
    destination[19]  = (source[6] >> 4) & 0x7ff;
    destination[20]  = (source[6] << 7) & 0x7ff;
    destination[20] |= (source[7] >> 25) & 0x7ff;
    destination[21]  = (source[7] >> 14) & 0x7ff;
    destination[22]  = (source[7] >> 3) & 0x7ff;
    destination[23]  = (source[7] << 8) & 0x7ff;
    destination[23] |= (source[8] >> 24) & 0x7ff;
    destination[24]  = (source[8] >> 13) & 0x7ff;
    destination[25]  = (source[8] >> 2) & 0x7ff;
    destination[26]  = (source[8] << 9) & 0x7ff;
    destination[26] |= (source[9] >> 23) & 0x7ff;
    destination[27]  = (source[9] >> 12) & 0x7ff;
    destination[28]  = (source[9] >> 1) & 0x7ff;
    destination[29]  = (source[9] << 10) & 0x7ff;
    destination[29] |= (source[10] >> 22) & 0x7ff;
    destination[30]  = (source[10] >> 11) & 0x7ff;
    destination[31]  = (source[10] >> 0) & 0x7ff;
  }
};
template <typename Tp>
struct __struct_bitpack_impl<Tp,4,12>
{
  static const size_t unit_size = 32;
  static const size_t bits_total = 384;
  static const size_t loop_total = 32;
  static const size_t bit_size = 12;
  static const Tp     mask = 0xfff;
  static inline
  void pack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] & 0xfff) << 20;
    destination[0] |= (source[1] & 0xfff) << 8;
    destination[0] |= (source[2] & 0xfff) >> 4;
    destination[1]  = (source[2] & 0xfff) << 28;
    destination[1] |= (source[3] & 0xfff) << 16;
    destination[1] |= (source[4] & 0xfff) << 4;
    destination[1] |= (source[5] & 0xfff) >> 8;
    destination[2]  = (source[5] & 0xfff) << 24;
    destination[2] |= (source[6] & 0xfff) << 12;
    destination[2] |= (source[7] & 0xfff) << 0;
    destination[3]  = (source[8] & 0xfff) << 20;
    destination[3] |= (source[9] & 0xfff) << 8;
    destination[3] |= (source[10] & 0xfff) >> 4;
    destination[4]  = (source[10] & 0xfff) << 28;
    destination[4] |= (source[11] & 0xfff) << 16;
    destination[4] |= (source[12] & 0xfff) << 4;
    destination[4] |= (source[13] & 0xfff) >> 8;
    destination[5]  = (source[13] & 0xfff) << 24;
    destination[5] |= (source[14] & 0xfff) << 12;
    destination[5] |= (source[15] & 0xfff) << 0;
    destination[6]  = (source[16] & 0xfff) << 20;
    destination[6] |= (source[17] & 0xfff) << 8;
    destination[6] |= (source[18] & 0xfff) >> 4;
    destination[7]  = (source[18] & 0xfff) << 28;
    destination[7] |= (source[19] & 0xfff) << 16;
    destination[7] |= (source[20] & 0xfff) << 4;
    destination[7] |= (source[21] & 0xfff) >> 8;
    destination[8]  = (source[21] & 0xfff) << 24;
    destination[8] |= (source[22] & 0xfff) << 12;
    destination[8] |= (source[23] & 0xfff) << 0;
    destination[9]  = (source[24] & 0xfff) << 20;
    destination[9] |= (source[25] & 0xfff) << 8;
    destination[9] |= (source[26] & 0xfff) >> 4;
    destination[10]  = (source[26] & 0xfff) << 28;
    destination[10] |= (source[27] & 0xfff) << 16;
    destination[10] |= (source[28] & 0xfff) << 4;
    destination[10] |= (source[29] & 0xfff) >> 8;
    destination[11]  = (source[29] & 0xfff) << 24;
    destination[11] |= (source[30] & 0xfff) << 12;
    destination[11] |= (source[31] & 0xfff) << 0;
  }
  static inline
  void unpack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] >> 20) & 0xfff;
    destination[1]  = (source[0] >> 8) & 0xfff;
    destination[2]  = (source[0] << 4) & 0xfff;
    destination[2] |= (source[1] >> 28) & 0xfff;
    destination[3]  = (source[1] >> 16) & 0xfff;
    destination[4]  = (source[1] >> 4) & 0xfff;
    destination[5]  = (source[1] << 8) & 0xfff;
    destination[5] |= (source[2] >> 24) & 0xfff;
    destination[6]  = (source[2] >> 12) & 0xfff;
    destination[7]  = (source[2] >> 0) & 0xfff;
    destination[8]  = (source[3] >> 20) & 0xfff;
    destination[9]  = (source[3] >> 8) & 0xfff;
    destination[10]  = (source[3] << 4) & 0xfff;
    destination[10] |= (source[4] >> 28) & 0xfff;
    destination[11]  = (source[4] >> 16) & 0xfff;
    destination[12]  = (source[4] >> 4) & 0xfff;
    destination[13]  = (source[4] << 8) & 0xfff;
    destination[13] |= (source[5] >> 24) & 0xfff;
    destination[14]  = (source[5] >> 12) & 0xfff;
    destination[15]  = (source[5] >> 0) & 0xfff;
    destination[16]  = (source[6] >> 20) & 0xfff;
    destination[17]  = (source[6] >> 8) & 0xfff;
    destination[18]  = (source[6] << 4) & 0xfff;
    destination[18] |= (source[7] >> 28) & 0xfff;
    destination[19]  = (source[7] >> 16) & 0xfff;
    destination[20]  = (source[7] >> 4) & 0xfff;
    destination[21]  = (source[7] << 8) & 0xfff;
    destination[21] |= (source[8] >> 24) & 0xfff;
    destination[22]  = (source[8] >> 12) & 0xfff;
    destination[23]  = (source[8] >> 0) & 0xfff;
    destination[24]  = (source[9] >> 20) & 0xfff;
    destination[25]  = (source[9] >> 8) & 0xfff;
    destination[26]  = (source[9] << 4) & 0xfff;
    destination[26] |= (source[10] >> 28) & 0xfff;
    destination[27]  = (source[10] >> 16) & 0xfff;
    destination[28]  = (source[10] >> 4) & 0xfff;
    destination[29]  = (source[10] << 8) & 0xfff;
    destination[29] |= (source[11] >> 24) & 0xfff;
    destination[30]  = (source[11] >> 12) & 0xfff;
    destination[31]  = (source[11] >> 0) & 0xfff;
  }
};
template <typename Tp>
struct __struct_bitpack_impl<Tp,4,13>
{
  static const size_t unit_size = 32;
  static const size_t bits_total = 416;
  static const size_t loop_total = 32;
  static const size_t bit_size = 13;
  static const Tp     mask = 0x1fff;
  static inline
  void pack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] & 0x1fff) << 19;
    destination[0] |= (source[1] & 0x1fff) << 6;
    destination[0] |= (source[2] & 0x1fff) >> 7;
    destination[1]  = (source[2] & 0x1fff) << 25;
    destination[1] |= (source[3] & 0x1fff) << 12;
    destination[1] |= (source[4] & 0x1fff) >> 1;
    destination[2]  = (source[4] & 0x1fff) << 31;
    destination[2] |= (source[5] & 0x1fff) << 18;
    destination[2] |= (source[6] & 0x1fff) << 5;
    destination[2] |= (source[7] & 0x1fff) >> 8;
    destination[3]  = (source[7] & 0x1fff) << 24;
    destination[3] |= (source[8] & 0x1fff) << 11;
    destination[3] |= (source[9] & 0x1fff) >> 2;
    destination[4]  = (source[9] & 0x1fff) << 30;
    destination[4] |= (source[10] & 0x1fff) << 17;
    destination[4] |= (source[11] & 0x1fff) << 4;
    destination[4] |= (source[12] & 0x1fff) >> 9;
    destination[5]  = (source[12] & 0x1fff) << 23;
    destination[5] |= (source[13] & 0x1fff) << 10;
    destination[5] |= (source[14] & 0x1fff) >> 3;
    destination[6]  = (source[14] & 0x1fff) << 29;
    destination[6] |= (source[15] & 0x1fff) << 16;
    destination[6] |= (source[16] & 0x1fff) << 3;
    destination[6] |= (source[17] & 0x1fff) >> 10;
    destination[7]  = (source[17] & 0x1fff) << 22;
    destination[7] |= (source[18] & 0x1fff) << 9;
    destination[7] |= (source[19] & 0x1fff) >> 4;
    destination[8]  = (source[19] & 0x1fff) << 28;
    destination[8] |= (source[20] & 0x1fff) << 15;
    destination[8] |= (source[21] & 0x1fff) << 2;
    destination[8] |= (source[22] & 0x1fff) >> 11;
    destination[9]  = (source[22] & 0x1fff) << 21;
    destination[9] |= (source[23] & 0x1fff) << 8;
    destination[9] |= (source[24] & 0x1fff) >> 5;
    destination[10]  = (source[24] & 0x1fff) << 27;
    destination[10] |= (source[25] & 0x1fff) << 14;
    destination[10] |= (source[26] & 0x1fff) << 1;
    destination[10] |= (source[27] & 0x1fff) >> 12;
    destination[11]  = (source[27] & 0x1fff) << 20;
    destination[11] |= (source[28] & 0x1fff) << 7;
    destination[11] |= (source[29] & 0x1fff) >> 6;
    destination[12]  = (source[29] & 0x1fff) << 26;
    destination[12] |= (source[30] & 0x1fff) << 13;
    destination[12] |= (source[31] & 0x1fff) << 0;
  }
  static inline
  void unpack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] >> 19) & 0x1fff;
    destination[1]  = (source[0] >> 6) & 0x1fff;
    destination[2]  = (source[0] << 7) & 0x1fff;
    destination[2] |= (source[1] >> 25) & 0x1fff;
    destination[3]  = (source[1] >> 12) & 0x1fff;
    destination[4]  = (source[1] << 1) & 0x1fff;
    destination[4] |= (source[2] >> 31) & 0x1fff;
    destination[5]  = (source[2] >> 18) & 0x1fff;
    destination[6]  = (source[2] >> 5) & 0x1fff;
    destination[7]  = (source[2] << 8) & 0x1fff;
    destination[7] |= (source[3] >> 24) & 0x1fff;
    destination[8]  = (source[3] >> 11) & 0x1fff;
    destination[9]  = (source[3] << 2) & 0x1fff;
    destination[9] |= (source[4] >> 30) & 0x1fff;
    destination[10]  = (source[4] >> 17) & 0x1fff;
    destination[11]  = (source[4] >> 4) & 0x1fff;
    destination[12]  = (source[4] << 9) & 0x1fff;
    destination[12] |= (source[5] >> 23) & 0x1fff;
    destination[13]  = (source[5] >> 10) & 0x1fff;
    destination[14]  = (source[5] << 3) & 0x1fff;
    destination[14] |= (source[6] >> 29) & 0x1fff;
    destination[15]  = (source[6] >> 16) & 0x1fff;
    destination[16]  = (source[6] >> 3) & 0x1fff;
    destination[17]  = (source[6] << 10) & 0x1fff;
    destination[17] |= (source[7] >> 22) & 0x1fff;
    destination[18]  = (source[7] >> 9) & 0x1fff;
    destination[19]  = (source[7] << 4) & 0x1fff;
    destination[19] |= (source[8] >> 28) & 0x1fff;
    destination[20]  = (source[8] >> 15) & 0x1fff;
    destination[21]  = (source[8] >> 2) & 0x1fff;
    destination[22]  = (source[8] << 11) & 0x1fff;
    destination[22] |= (source[9] >> 21) & 0x1fff;
    destination[23]  = (source[9] >> 8) & 0x1fff;
    destination[24]  = (source[9] << 5) & 0x1fff;
    destination[24] |= (source[10] >> 27) & 0x1fff;
    destination[25]  = (source[10] >> 14) & 0x1fff;
    destination[26]  = (source[10] >> 1) & 0x1fff;
    destination[27]  = (source[10] << 12) & 0x1fff;
    destination[27] |= (source[11] >> 20) & 0x1fff;
    destination[28]  = (source[11] >> 7) & 0x1fff;
    destination[29]  = (source[11] << 6) & 0x1fff;
    destination[29] |= (source[12] >> 26) & 0x1fff;
    destination[30]  = (source[12] >> 13) & 0x1fff;
    destination[31]  = (source[12] >> 0) & 0x1fff;
  }
};
template <typename Tp>
struct __struct_bitpack_impl<Tp,4,14>
{
  static const size_t unit_size = 32;
  static const size_t bits_total = 448;
  static const size_t loop_total = 32;
  static const size_t bit_size = 14;
  static const Tp     mask = 0x3fff;
  static inline
  void pack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] & 0x3fff) << 18;
    destination[0] |= (source[1] & 0x3fff) << 4;
    destination[0] |= (source[2] & 0x3fff) >> 10;
    destination[1]  = (source[2] & 0x3fff) << 22;
    destination[1] |= (source[3] & 0x3fff) << 8;
    destination[1] |= (source[4] & 0x3fff) >> 6;
    destination[2]  = (source[4] & 0x3fff) << 26;
    destination[2] |= (source[5] & 0x3fff) << 12;
    destination[2] |= (source[6] & 0x3fff) >> 2;
    destination[3]  = (source[6] & 0x3fff) << 30;
    destination[3] |= (source[7] & 0x3fff) << 16;
    destination[3] |= (source[8] & 0x3fff) << 2;
    destination[3] |= (source[9] & 0x3fff) >> 12;
    destination[4]  = (source[9] & 0x3fff) << 20;
    destination[4] |= (source[10] & 0x3fff) << 6;
    destination[4] |= (source[11] & 0x3fff) >> 8;
    destination[5]  = (source[11] & 0x3fff) << 24;
    destination[5] |= (source[12] & 0x3fff) << 10;
    destination[5] |= (source[13] & 0x3fff) >> 4;
    destination[6]  = (source[13] & 0x3fff) << 28;
    destination[6] |= (source[14] & 0x3fff) << 14;
    destination[6] |= (source[15] & 0x3fff) << 0;
    destination[7]  = (source[16] & 0x3fff) << 18;
    destination[7] |= (source[17] & 0x3fff) << 4;
    destination[7] |= (source[18] & 0x3fff) >> 10;
    destination[8]  = (source[18] & 0x3fff) << 22;
    destination[8] |= (source[19] & 0x3fff) << 8;
    destination[8] |= (source[20] & 0x3fff) >> 6;
    destination[9]  = (source[20] & 0x3fff) << 26;
    destination[9] |= (source[21] & 0x3fff) << 12;
    destination[9] |= (source[22] & 0x3fff) >> 2;
    destination[10]  = (source[22] & 0x3fff) << 30;
    destination[10] |= (source[23] & 0x3fff) << 16;
    destination[10] |= (source[24] & 0x3fff) << 2;
    destination[10] |= (source[25] & 0x3fff) >> 12;
    destination[11]  = (source[25] & 0x3fff) << 20;
    destination[11] |= (source[26] & 0x3fff) << 6;
    destination[11] |= (source[27] & 0x3fff) >> 8;
    destination[12]  = (source[27] & 0x3fff) << 24;
    destination[12] |= (source[28] & 0x3fff) << 10;
    destination[12] |= (source[29] & 0x3fff) >> 4;
    destination[13]  = (source[29] & 0x3fff) << 28;
    destination[13] |= (source[30] & 0x3fff) << 14;
    destination[13] |= (source[31] & 0x3fff) << 0;
  }
  static inline
  void unpack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] >> 18) & 0x3fff;
    destination[1]  = (source[0] >> 4) & 0x3fff;
    destination[2]  = (source[0] << 10) & 0x3fff;
    destination[2] |= (source[1] >> 22) & 0x3fff;
    destination[3]  = (source[1] >> 8) & 0x3fff;
    destination[4]  = (source[1] << 6) & 0x3fff;
    destination[4] |= (source[2] >> 26) & 0x3fff;
    destination[5]  = (source[2] >> 12) & 0x3fff;
    destination[6]  = (source[2] << 2) & 0x3fff;
    destination[6] |= (source[3] >> 30) & 0x3fff;
    destination[7]  = (source[3] >> 16) & 0x3fff;
    destination[8]  = (source[3] >> 2) & 0x3fff;
    destination[9]  = (source[3] << 12) & 0x3fff;
    destination[9] |= (source[4] >> 20) & 0x3fff;
    destination[10]  = (source[4] >> 6) & 0x3fff;
    destination[11]  = (source[4] << 8) & 0x3fff;
    destination[11] |= (source[5] >> 24) & 0x3fff;
    destination[12]  = (source[5] >> 10) & 0x3fff;
    destination[13]  = (source[5] << 4) & 0x3fff;
    destination[13] |= (source[6] >> 28) & 0x3fff;
    destination[14]  = (source[6] >> 14) & 0x3fff;
    destination[15]  = (source[6] >> 0) & 0x3fff;
    destination[16]  = (source[7] >> 18) & 0x3fff;
    destination[17]  = (source[7] >> 4) & 0x3fff;
    destination[18]  = (source[7] << 10) & 0x3fff;
    destination[18] |= (source[8] >> 22) & 0x3fff;
    destination[19]  = (source[8] >> 8) & 0x3fff;
    destination[20]  = (source[8] << 6) & 0x3fff;
    destination[20] |= (source[9] >> 26) & 0x3fff;
    destination[21]  = (source[9] >> 12) & 0x3fff;
    destination[22]  = (source[9] << 2) & 0x3fff;
    destination[22] |= (source[10] >> 30) & 0x3fff;
    destination[23]  = (source[10] >> 16) & 0x3fff;
    destination[24]  = (source[10] >> 2) & 0x3fff;
    destination[25]  = (source[10] << 12) & 0x3fff;
    destination[25] |= (source[11] >> 20) & 0x3fff;
    destination[26]  = (source[11] >> 6) & 0x3fff;
    destination[27]  = (source[11] << 8) & 0x3fff;
    destination[27] |= (source[12] >> 24) & 0x3fff;
    destination[28]  = (source[12] >> 10) & 0x3fff;
    destination[29]  = (source[12] << 4) & 0x3fff;
    destination[29] |= (source[13] >> 28) & 0x3fff;
    destination[30]  = (source[13] >> 14) & 0x3fff;
    destination[31]  = (source[13] >> 0) & 0x3fff;
  }
};
template <typename Tp>
struct __struct_bitpack_impl<Tp,4,15>
{
  static const size_t unit_size = 32;
  static const size_t bits_total = 480;
  static const size_t loop_total = 32;
  static const size_t bit_size = 15;
  static const Tp     mask = 0x7fff;
  static inline
  void pack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] & 0x7fff) << 17;
    destination[0] |= (source[1] & 0x7fff) << 2;
    destination[0] |= (source[2] & 0x7fff) >> 13;
    destination[1]  = (source[2] & 0x7fff) << 19;
    destination[1] |= (source[3] & 0x7fff) << 4;
    destination[1] |= (source[4] & 0x7fff) >> 11;
    destination[2]  = (source[4] & 0x7fff) << 21;
    destination[2] |= (source[5] & 0x7fff) << 6;
    destination[2] |= (source[6] & 0x7fff) >> 9;
    destination[3]  = (source[6] & 0x7fff) << 23;
    destination[3] |= (source[7] & 0x7fff) << 8;
    destination[3] |= (source[8] & 0x7fff) >> 7;
    destination[4]  = (source[8] & 0x7fff) << 25;
    destination[4] |= (source[9] & 0x7fff) << 10;
    destination[4] |= (source[10] & 0x7fff) >> 5;
    destination[5]  = (source[10] & 0x7fff) << 27;
    destination[5] |= (source[11] & 0x7fff) << 12;
    destination[5] |= (source[12] & 0x7fff) >> 3;
    destination[6]  = (source[12] & 0x7fff) << 29;
    destination[6] |= (source[13] & 0x7fff) << 14;
    destination[6] |= (source[14] & 0x7fff) >> 1;
    destination[7]  = (source[14] & 0x7fff) << 31;
    destination[7] |= (source[15] & 0x7fff) << 16;
    destination[7] |= (source[16] & 0x7fff) << 1;
    destination[7] |= (source[17] & 0x7fff) >> 14;
    destination[8]  = (source[17] & 0x7fff) << 18;
    destination[8] |= (source[18] & 0x7fff) << 3;
    destination[8] |= (source[19] & 0x7fff) >> 12;
    destination[9]  = (source[19] & 0x7fff) << 20;
    destination[9] |= (source[20] & 0x7fff) << 5;
    destination[9] |= (source[21] & 0x7fff) >> 10;
    destination[10]  = (source[21] & 0x7fff) << 22;
    destination[10] |= (source[22] & 0x7fff) << 7;
    destination[10] |= (source[23] & 0x7fff) >> 8;
    destination[11]  = (source[23] & 0x7fff) << 24;
    destination[11] |= (source[24] & 0x7fff) << 9;
    destination[11] |= (source[25] & 0x7fff) >> 6;
    destination[12]  = (source[25] & 0x7fff) << 26;
    destination[12] |= (source[26] & 0x7fff) << 11;
    destination[12] |= (source[27] & 0x7fff) >> 4;
    destination[13]  = (source[27] & 0x7fff) << 28;
    destination[13] |= (source[28] & 0x7fff) << 13;
    destination[13] |= (source[29] & 0x7fff) >> 2;
    destination[14]  = (source[29] & 0x7fff) << 30;
    destination[14] |= (source[30] & 0x7fff) << 15;
    destination[14] |= (source[31] & 0x7fff) << 0;
  }
  static inline
  void unpack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] >> 17) & 0x7fff;
    destination[1]  = (source[0] >> 2) & 0x7fff;
    destination[2]  = (source[0] << 13) & 0x7fff;
    destination[2] |= (source[1] >> 19) & 0x7fff;
    destination[3]  = (source[1] >> 4) & 0x7fff;
    destination[4]  = (source[1] << 11) & 0x7fff;
    destination[4] |= (source[2] >> 21) & 0x7fff;
    destination[5]  = (source[2] >> 6) & 0x7fff;
    destination[6]  = (source[2] << 9) & 0x7fff;
    destination[6] |= (source[3] >> 23) & 0x7fff;
    destination[7]  = (source[3] >> 8) & 0x7fff;
    destination[8]  = (source[3] << 7) & 0x7fff;
    destination[8] |= (source[4] >> 25) & 0x7fff;
    destination[9]  = (source[4] >> 10) & 0x7fff;
    destination[10]  = (source[4] << 5) & 0x7fff;
    destination[10] |= (source[5] >> 27) & 0x7fff;
    destination[11]  = (source[5] >> 12) & 0x7fff;
    destination[12]  = (source[5] << 3) & 0x7fff;
    destination[12] |= (source[6] >> 29) & 0x7fff;
    destination[13]  = (source[6] >> 14) & 0x7fff;
    destination[14]  = (source[6] << 1) & 0x7fff;
    destination[14] |= (source[7] >> 31) & 0x7fff;
    destination[15]  = (source[7] >> 16) & 0x7fff;
    destination[16]  = (source[7] >> 1) & 0x7fff;
    destination[17]  = (source[7] << 14) & 0x7fff;
    destination[17] |= (source[8] >> 18) & 0x7fff;
    destination[18]  = (source[8] >> 3) & 0x7fff;
    destination[19]  = (source[8] << 12) & 0x7fff;
    destination[19] |= (source[9] >> 20) & 0x7fff;
    destination[20]  = (source[9] >> 5) & 0x7fff;
    destination[21]  = (source[9] << 10) & 0x7fff;
    destination[21] |= (source[10] >> 22) & 0x7fff;
    destination[22]  = (source[10] >> 7) & 0x7fff;
    destination[23]  = (source[10] << 8) & 0x7fff;
    destination[23] |= (source[11] >> 24) & 0x7fff;
    destination[24]  = (source[11] >> 9) & 0x7fff;
    destination[25]  = (source[11] << 6) & 0x7fff;
    destination[25] |= (source[12] >> 26) & 0x7fff;
    destination[26]  = (source[12] >> 11) & 0x7fff;
    destination[27]  = (source[12] << 4) & 0x7fff;
    destination[27] |= (source[13] >> 28) & 0x7fff;
    destination[28]  = (source[13] >> 13) & 0x7fff;
    destination[29]  = (source[13] << 2) & 0x7fff;
    destination[29] |= (source[14] >> 30) & 0x7fff;
    destination[30]  = (source[14] >> 15) & 0x7fff;
    destination[31]  = (source[14] >> 0) & 0x7fff;
  }
};
template <typename Tp>
struct __struct_bitpack_impl<Tp,4,16>
{
  static const size_t unit_size = 32;
  static const size_t bits_total = 512;
  static const size_t loop_total = 32;
  static const size_t bit_size = 16;
  static const Tp     mask = 0xffff;
  static inline
  void pack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] & 0xffff) << 16;
    destination[0] |= (source[1] & 0xffff) << 0;
    destination[1]  = (source[2] & 0xffff) << 16;
    destination[1] |= (source[3] & 0xffff) << 0;
    destination[2]  = (source[4] & 0xffff) << 16;
    destination[2] |= (source[5] & 0xffff) << 0;
    destination[3]  = (source[6] & 0xffff) << 16;
    destination[3] |= (source[7] & 0xffff) << 0;
    destination[4]  = (source[8] & 0xffff) << 16;
    destination[4] |= (source[9] & 0xffff) << 0;
    destination[5]  = (source[10] & 0xffff) << 16;
    destination[5] |= (source[11] & 0xffff) << 0;
    destination[6]  = (source[12] & 0xffff) << 16;
    destination[6] |= (source[13] & 0xffff) << 0;
    destination[7]  = (source[14] & 0xffff) << 16;
    destination[7] |= (source[15] & 0xffff) << 0;
    destination[8]  = (source[16] & 0xffff) << 16;
    destination[8] |= (source[17] & 0xffff) << 0;
    destination[9]  = (source[18] & 0xffff) << 16;
    destination[9] |= (source[19] & 0xffff) << 0;
    destination[10]  = (source[20] & 0xffff) << 16;
    destination[10] |= (source[21] & 0xffff) << 0;
    destination[11]  = (source[22] & 0xffff) << 16;
    destination[11] |= (source[23] & 0xffff) << 0;
    destination[12]  = (source[24] & 0xffff) << 16;
    destination[12] |= (source[25] & 0xffff) << 0;
    destination[13]  = (source[26] & 0xffff) << 16;
    destination[13] |= (source[27] & 0xffff) << 0;
    destination[14]  = (source[28] & 0xffff) << 16;
    destination[14] |= (source[29] & 0xffff) << 0;
    destination[15]  = (source[30] & 0xffff) << 16;
    destination[15] |= (source[31] & 0xffff) << 0;
  }
  static inline
  void unpack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] >> 16) & 0xffff;
    destination[1]  = (source[0] >> 0) & 0xffff;
    destination[2]  = (source[1] >> 16) & 0xffff;
    destination[3]  = (source[1] >> 0) & 0xffff;
    destination[4]  = (source[2] >> 16) & 0xffff;
    destination[5]  = (source[2] >> 0) & 0xffff;
    destination[6]  = (source[3] >> 16) & 0xffff;
    destination[7]  = (source[3] >> 0) & 0xffff;
    destination[8]  = (source[4] >> 16) & 0xffff;
    destination[9]  = (source[4] >> 0) & 0xffff;
    destination[10]  = (source[5] >> 16) & 0xffff;
    destination[11]  = (source[5] >> 0) & 0xffff;
    destination[12]  = (source[6] >> 16) & 0xffff;
    destination[13]  = (source[6] >> 0) & 0xffff;
    destination[14]  = (source[7] >> 16) & 0xffff;
    destination[15]  = (source[7] >> 0) & 0xffff;
    destination[16]  = (source[8] >> 16) & 0xffff;
    destination[17]  = (source[8] >> 0) & 0xffff;
    destination[18]  = (source[9] >> 16) & 0xffff;
    destination[19]  = (source[9] >> 0) & 0xffff;
    destination[20]  = (source[10] >> 16) & 0xffff;
    destination[21]  = (source[10] >> 0) & 0xffff;
    destination[22]  = (source[11] >> 16) & 0xffff;
    destination[23]  = (source[11] >> 0) & 0xffff;
    destination[24]  = (source[12] >> 16) & 0xffff;
    destination[25]  = (source[12] >> 0) & 0xffff;
    destination[26]  = (source[13] >> 16) & 0xffff;
    destination[27]  = (source[13] >> 0) & 0xffff;
    destination[28]  = (source[14] >> 16) & 0xffff;
    destination[29]  = (source[14] >> 0) & 0xffff;
    destination[30]  = (source[15] >> 16) & 0xffff;
    destination[31]  = (source[15] >> 0) & 0xffff;
  }
};
template <typename Tp>
struct __struct_bitpack_impl<Tp,4,17>
{
  static const size_t unit_size = 32;
  static const size_t bits_total = 544;
  static const size_t loop_total = 32;
  static const size_t bit_size = 17;
  static const Tp     mask = 0x1ffff;
  static inline
  void pack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] & 0x1ffff) << 15;
    destination[0] |= (source[1] & 0x1ffff) >> 2;
    destination[1]  = (source[1] & 0x1ffff) << 30;
    destination[1] |= (source[2] & 0x1ffff) << 13;
    destination[1] |= (source[3] & 0x1ffff) >> 4;
    destination[2]  = (source[3] & 0x1ffff) << 28;
    destination[2] |= (source[4] & 0x1ffff) << 11;
    destination[2] |= (source[5] & 0x1ffff) >> 6;
    destination[3]  = (source[5] & 0x1ffff) << 26;
    destination[3] |= (source[6] & 0x1ffff) << 9;
    destination[3] |= (source[7] & 0x1ffff) >> 8;
    destination[4]  = (source[7] & 0x1ffff) << 24;
    destination[4] |= (source[8] & 0x1ffff) << 7;
    destination[4] |= (source[9] & 0x1ffff) >> 10;
    destination[5]  = (source[9] & 0x1ffff) << 22;
    destination[5] |= (source[10] & 0x1ffff) << 5;
    destination[5] |= (source[11] & 0x1ffff) >> 12;
    destination[6]  = (source[11] & 0x1ffff) << 20;
    destination[6] |= (source[12] & 0x1ffff) << 3;
    destination[6] |= (source[13] & 0x1ffff) >> 14;
    destination[7]  = (source[13] & 0x1ffff) << 18;
    destination[7] |= (source[14] & 0x1ffff) << 1;
    destination[7] |= (source[15] & 0x1ffff) >> 16;
    destination[8]  = (source[15] & 0x1ffff) << 16;
    destination[8] |= (source[16] & 0x1ffff) >> 1;
    destination[9]  = (source[16] & 0x1ffff) << 31;
    destination[9] |= (source[17] & 0x1ffff) << 14;
    destination[9] |= (source[18] & 0x1ffff) >> 3;
    destination[10]  = (source[18] & 0x1ffff) << 29;
    destination[10] |= (source[19] & 0x1ffff) << 12;
    destination[10] |= (source[20] & 0x1ffff) >> 5;
    destination[11]  = (source[20] & 0x1ffff) << 27;
    destination[11] |= (source[21] & 0x1ffff) << 10;
    destination[11] |= (source[22] & 0x1ffff) >> 7;
    destination[12]  = (source[22] & 0x1ffff) << 25;
    destination[12] |= (source[23] & 0x1ffff) << 8;
    destination[12] |= (source[24] & 0x1ffff) >> 9;
    destination[13]  = (source[24] & 0x1ffff) << 23;
    destination[13] |= (source[25] & 0x1ffff) << 6;
    destination[13] |= (source[26] & 0x1ffff) >> 11;
    destination[14]  = (source[26] & 0x1ffff) << 21;
    destination[14] |= (source[27] & 0x1ffff) << 4;
    destination[14] |= (source[28] & 0x1ffff) >> 13;
    destination[15]  = (source[28] & 0x1ffff) << 19;
    destination[15] |= (source[29] & 0x1ffff) << 2;
    destination[15] |= (source[30] & 0x1ffff) >> 15;
    destination[16]  = (source[30] & 0x1ffff) << 17;
    destination[16] |= (source[31] & 0x1ffff) << 0;
  }
  static inline
  void unpack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] >> 15) & 0x1ffff;
    destination[1]  = (source[0] << 2) & 0x1ffff;
    destination[1] |= (source[1] >> 30) & 0x1ffff;
    destination[2]  = (source[1] >> 13) & 0x1ffff;
    destination[3]  = (source[1] << 4) & 0x1ffff;
    destination[3] |= (source[2] >> 28) & 0x1ffff;
    destination[4]  = (source[2] >> 11) & 0x1ffff;
    destination[5]  = (source[2] << 6) & 0x1ffff;
    destination[5] |= (source[3] >> 26) & 0x1ffff;
    destination[6]  = (source[3] >> 9) & 0x1ffff;
    destination[7]  = (source[3] << 8) & 0x1ffff;
    destination[7] |= (source[4] >> 24) & 0x1ffff;
    destination[8]  = (source[4] >> 7) & 0x1ffff;
    destination[9]  = (source[4] << 10) & 0x1ffff;
    destination[9] |= (source[5] >> 22) & 0x1ffff;
    destination[10]  = (source[5] >> 5) & 0x1ffff;
    destination[11]  = (source[5] << 12) & 0x1ffff;
    destination[11] |= (source[6] >> 20) & 0x1ffff;
    destination[12]  = (source[6] >> 3) & 0x1ffff;
    destination[13]  = (source[6] << 14) & 0x1ffff;
    destination[13] |= (source[7] >> 18) & 0x1ffff;
    destination[14]  = (source[7] >> 1) & 0x1ffff;
    destination[15]  = (source[7] << 16) & 0x1ffff;
    destination[15] |= (source[8] >> 16) & 0x1ffff;
    destination[16]  = (source[8] << 1) & 0x1ffff;
    destination[16] |= (source[9] >> 31) & 0x1ffff;
    destination[17]  = (source[9] >> 14) & 0x1ffff;
    destination[18]  = (source[9] << 3) & 0x1ffff;
    destination[18] |= (source[10] >> 29) & 0x1ffff;
    destination[19]  = (source[10] >> 12) & 0x1ffff;
    destination[20]  = (source[10] << 5) & 0x1ffff;
    destination[20] |= (source[11] >> 27) & 0x1ffff;
    destination[21]  = (source[11] >> 10) & 0x1ffff;
    destination[22]  = (source[11] << 7) & 0x1ffff;
    destination[22] |= (source[12] >> 25) & 0x1ffff;
    destination[23]  = (source[12] >> 8) & 0x1ffff;
    destination[24]  = (source[12] << 9) & 0x1ffff;
    destination[24] |= (source[13] >> 23) & 0x1ffff;
    destination[25]  = (source[13] >> 6) & 0x1ffff;
    destination[26]  = (source[13] << 11) & 0x1ffff;
    destination[26] |= (source[14] >> 21) & 0x1ffff;
    destination[27]  = (source[14] >> 4) & 0x1ffff;
    destination[28]  = (source[14] << 13) & 0x1ffff;
    destination[28] |= (source[15] >> 19) & 0x1ffff;
    destination[29]  = (source[15] >> 2) & 0x1ffff;
    destination[30]  = (source[15] << 15) & 0x1ffff;
    destination[30] |= (source[16] >> 17) & 0x1ffff;
    destination[31]  = (source[16] >> 0) & 0x1ffff;
  }
};
template <typename Tp>
struct __struct_bitpack_impl<Tp,4,18>
{
  static const size_t unit_size = 32;
  static const size_t bits_total = 576;
  static const size_t loop_total = 32;
  static const size_t bit_size = 18;
  static const Tp     mask = 0x3ffff;
  static inline
  void pack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] & 0x3ffff) << 14;
    destination[0] |= (source[1] & 0x3ffff) >> 4;
    destination[1]  = (source[1] & 0x3ffff) << 28;
    destination[1] |= (source[2] & 0x3ffff) << 10;
    destination[1] |= (source[3] & 0x3ffff) >> 8;
    destination[2]  = (source[3] & 0x3ffff) << 24;
    destination[2] |= (source[4] & 0x3ffff) << 6;
    destination[2] |= (source[5] & 0x3ffff) >> 12;
    destination[3]  = (source[5] & 0x3ffff) << 20;
    destination[3] |= (source[6] & 0x3ffff) << 2;
    destination[3] |= (source[7] & 0x3ffff) >> 16;
    destination[4]  = (source[7] & 0x3ffff) << 16;
    destination[4] |= (source[8] & 0x3ffff) >> 2;
    destination[5]  = (source[8] & 0x3ffff) << 30;
    destination[5] |= (source[9] & 0x3ffff) << 12;
    destination[5] |= (source[10] & 0x3ffff) >> 6;
    destination[6]  = (source[10] & 0x3ffff) << 26;
    destination[6] |= (source[11] & 0x3ffff) << 8;
    destination[6] |= (source[12] & 0x3ffff) >> 10;
    destination[7]  = (source[12] & 0x3ffff) << 22;
    destination[7] |= (source[13] & 0x3ffff) << 4;
    destination[7] |= (source[14] & 0x3ffff) >> 14;
    destination[8]  = (source[14] & 0x3ffff) << 18;
    destination[8] |= (source[15] & 0x3ffff) << 0;
    destination[9]  = (source[16] & 0x3ffff) << 14;
    destination[9] |= (source[17] & 0x3ffff) >> 4;
    destination[10]  = (source[17] & 0x3ffff) << 28;
    destination[10] |= (source[18] & 0x3ffff) << 10;
    destination[10] |= (source[19] & 0x3ffff) >> 8;
    destination[11]  = (source[19] & 0x3ffff) << 24;
    destination[11] |= (source[20] & 0x3ffff) << 6;
    destination[11] |= (source[21] & 0x3ffff) >> 12;
    destination[12]  = (source[21] & 0x3ffff) << 20;
    destination[12] |= (source[22] & 0x3ffff) << 2;
    destination[12] |= (source[23] & 0x3ffff) >> 16;
    destination[13]  = (source[23] & 0x3ffff) << 16;
    destination[13] |= (source[24] & 0x3ffff) >> 2;
    destination[14]  = (source[24] & 0x3ffff) << 30;
    destination[14] |= (source[25] & 0x3ffff) << 12;
    destination[14] |= (source[26] & 0x3ffff) >> 6;
    destination[15]  = (source[26] & 0x3ffff) << 26;
    destination[15] |= (source[27] & 0x3ffff) << 8;
    destination[15] |= (source[28] & 0x3ffff) >> 10;
    destination[16]  = (source[28] & 0x3ffff) << 22;
    destination[16] |= (source[29] & 0x3ffff) << 4;
    destination[16] |= (source[30] & 0x3ffff) >> 14;
    destination[17]  = (source[30] & 0x3ffff) << 18;
    destination[17] |= (source[31] & 0x3ffff) << 0;
  }
  static inline
  void unpack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] >> 14) & 0x3ffff;
    destination[1]  = (source[0] << 4) & 0x3ffff;
    destination[1] |= (source[1] >> 28) & 0x3ffff;
    destination[2]  = (source[1] >> 10) & 0x3ffff;
    destination[3]  = (source[1] << 8) & 0x3ffff;
    destination[3] |= (source[2] >> 24) & 0x3ffff;
    destination[4]  = (source[2] >> 6) & 0x3ffff;
    destination[5]  = (source[2] << 12) & 0x3ffff;
    destination[5] |= (source[3] >> 20) & 0x3ffff;
    destination[6]  = (source[3] >> 2) & 0x3ffff;
    destination[7]  = (source[3] << 16) & 0x3ffff;
    destination[7] |= (source[4] >> 16) & 0x3ffff;
    destination[8]  = (source[4] << 2) & 0x3ffff;
    destination[8] |= (source[5] >> 30) & 0x3ffff;
    destination[9]  = (source[5] >> 12) & 0x3ffff;
    destination[10]  = (source[5] << 6) & 0x3ffff;
    destination[10] |= (source[6] >> 26) & 0x3ffff;
    destination[11]  = (source[6] >> 8) & 0x3ffff;
    destination[12]  = (source[6] << 10) & 0x3ffff;
    destination[12] |= (source[7] >> 22) & 0x3ffff;
    destination[13]  = (source[7] >> 4) & 0x3ffff;
    destination[14]  = (source[7] << 14) & 0x3ffff;
    destination[14] |= (source[8] >> 18) & 0x3ffff;
    destination[15]  = (source[8] >> 0) & 0x3ffff;
    destination[16]  = (source[9] >> 14) & 0x3ffff;
    destination[17]  = (source[9] << 4) & 0x3ffff;
    destination[17] |= (source[10] >> 28) & 0x3ffff;
    destination[18]  = (source[10] >> 10) & 0x3ffff;
    destination[19]  = (source[10] << 8) & 0x3ffff;
    destination[19] |= (source[11] >> 24) & 0x3ffff;
    destination[20]  = (source[11] >> 6) & 0x3ffff;
    destination[21]  = (source[11] << 12) & 0x3ffff;
    destination[21] |= (source[12] >> 20) & 0x3ffff;
    destination[22]  = (source[12] >> 2) & 0x3ffff;
    destination[23]  = (source[12] << 16) & 0x3ffff;
    destination[23] |= (source[13] >> 16) & 0x3ffff;
    destination[24]  = (source[13] << 2) & 0x3ffff;
    destination[24] |= (source[14] >> 30) & 0x3ffff;
    destination[25]  = (source[14] >> 12) & 0x3ffff;
    destination[26]  = (source[14] << 6) & 0x3ffff;
    destination[26] |= (source[15] >> 26) & 0x3ffff;
    destination[27]  = (source[15] >> 8) & 0x3ffff;
    destination[28]  = (source[15] << 10) & 0x3ffff;
    destination[28] |= (source[16] >> 22) & 0x3ffff;
    destination[29]  = (source[16] >> 4) & 0x3ffff;
    destination[30]  = (source[16] << 14) & 0x3ffff;
    destination[30] |= (source[17] >> 18) & 0x3ffff;
    destination[31]  = (source[17] >> 0) & 0x3ffff;
  }
};
template <typename Tp>
struct __struct_bitpack_impl<Tp,4,19>
{
  static const size_t unit_size = 32;
  static const size_t bits_total = 608;
  static const size_t loop_total = 32;
  static const size_t bit_size = 19;
  static const Tp     mask = 0x7ffff;
  static inline
  void pack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] & 0x7ffff) << 13;
    destination[0] |= (source[1] & 0x7ffff) >> 6;
    destination[1]  = (source[1] & 0x7ffff) << 26;
    destination[1] |= (source[2] & 0x7ffff) << 7;
    destination[1] |= (source[3] & 0x7ffff) >> 12;
    destination[2]  = (source[3] & 0x7ffff) << 20;
    destination[2] |= (source[4] & 0x7ffff) << 1;
    destination[2] |= (source[5] & 0x7ffff) >> 18;
    destination[3]  = (source[5] & 0x7ffff) << 14;
    destination[3] |= (source[6] & 0x7ffff) >> 5;
    destination[4]  = (source[6] & 0x7ffff) << 27;
    destination[4] |= (source[7] & 0x7ffff) << 8;
    destination[4] |= (source[8] & 0x7ffff) >> 11;
    destination[5]  = (source[8] & 0x7ffff) << 21;
    destination[5] |= (source[9] & 0x7ffff) << 2;
    destination[5] |= (source[10] & 0x7ffff) >> 17;
    destination[6]  = (source[10] & 0x7ffff) << 15;
    destination[6] |= (source[11] & 0x7ffff) >> 4;
    destination[7]  = (source[11] & 0x7ffff) << 28;
    destination[7] |= (source[12] & 0x7ffff) << 9;
    destination[7] |= (source[13] & 0x7ffff) >> 10;
    destination[8]  = (source[13] & 0x7ffff) << 22;
    destination[8] |= (source[14] & 0x7ffff) << 3;
    destination[8] |= (source[15] & 0x7ffff) >> 16;
    destination[9]  = (source[15] & 0x7ffff) << 16;
    destination[9] |= (source[16] & 0x7ffff) >> 3;
    destination[10]  = (source[16] & 0x7ffff) << 29;
    destination[10] |= (source[17] & 0x7ffff) << 10;
    destination[10] |= (source[18] & 0x7ffff) >> 9;
    destination[11]  = (source[18] & 0x7ffff) << 23;
    destination[11] |= (source[19] & 0x7ffff) << 4;
    destination[11] |= (source[20] & 0x7ffff) >> 15;
    destination[12]  = (source[20] & 0x7ffff) << 17;
    destination[12] |= (source[21] & 0x7ffff) >> 2;
    destination[13]  = (source[21] & 0x7ffff) << 30;
    destination[13] |= (source[22] & 0x7ffff) << 11;
    destination[13] |= (source[23] & 0x7ffff) >> 8;
    destination[14]  = (source[23] & 0x7ffff) << 24;
    destination[14] |= (source[24] & 0x7ffff) << 5;
    destination[14] |= (source[25] & 0x7ffff) >> 14;
    destination[15]  = (source[25] & 0x7ffff) << 18;
    destination[15] |= (source[26] & 0x7ffff) >> 1;
    destination[16]  = (source[26] & 0x7ffff) << 31;
    destination[16] |= (source[27] & 0x7ffff) << 12;
    destination[16] |= (source[28] & 0x7ffff) >> 7;
    destination[17]  = (source[28] & 0x7ffff) << 25;
    destination[17] |= (source[29] & 0x7ffff) << 6;
    destination[17] |= (source[30] & 0x7ffff) >> 13;
    destination[18]  = (source[30] & 0x7ffff) << 19;
    destination[18] |= (source[31] & 0x7ffff) << 0;
  }
  static inline
  void unpack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] >> 13) & 0x7ffff;
    destination[1]  = (source[0] << 6) & 0x7ffff;
    destination[1] |= (source[1] >> 26) & 0x7ffff;
    destination[2]  = (source[1] >> 7) & 0x7ffff;
    destination[3]  = (source[1] << 12) & 0x7ffff;
    destination[3] |= (source[2] >> 20) & 0x7ffff;
    destination[4]  = (source[2] >> 1) & 0x7ffff;
    destination[5]  = (source[2] << 18) & 0x7ffff;
    destination[5] |= (source[3] >> 14) & 0x7ffff;
    destination[6]  = (source[3] << 5) & 0x7ffff;
    destination[6] |= (source[4] >> 27) & 0x7ffff;
    destination[7]  = (source[4] >> 8) & 0x7ffff;
    destination[8]  = (source[4] << 11) & 0x7ffff;
    destination[8] |= (source[5] >> 21) & 0x7ffff;
    destination[9]  = (source[5] >> 2) & 0x7ffff;
    destination[10]  = (source[5] << 17) & 0x7ffff;
    destination[10] |= (source[6] >> 15) & 0x7ffff;
    destination[11]  = (source[6] << 4) & 0x7ffff;
    destination[11] |= (source[7] >> 28) & 0x7ffff;
    destination[12]  = (source[7] >> 9) & 0x7ffff;
    destination[13]  = (source[7] << 10) & 0x7ffff;
    destination[13] |= (source[8] >> 22) & 0x7ffff;
    destination[14]  = (source[8] >> 3) & 0x7ffff;
    destination[15]  = (source[8] << 16) & 0x7ffff;
    destination[15] |= (source[9] >> 16) & 0x7ffff;
    destination[16]  = (source[9] << 3) & 0x7ffff;
    destination[16] |= (source[10] >> 29) & 0x7ffff;
    destination[17]  = (source[10] >> 10) & 0x7ffff;
    destination[18]  = (source[10] << 9) & 0x7ffff;
    destination[18] |= (source[11] >> 23) & 0x7ffff;
    destination[19]  = (source[11] >> 4) & 0x7ffff;
    destination[20]  = (source[11] << 15) & 0x7ffff;
    destination[20] |= (source[12] >> 17) & 0x7ffff;
    destination[21]  = (source[12] << 2) & 0x7ffff;
    destination[21] |= (source[13] >> 30) & 0x7ffff;
    destination[22]  = (source[13] >> 11) & 0x7ffff;
    destination[23]  = (source[13] << 8) & 0x7ffff;
    destination[23] |= (source[14] >> 24) & 0x7ffff;
    destination[24]  = (source[14] >> 5) & 0x7ffff;
    destination[25]  = (source[14] << 14) & 0x7ffff;
    destination[25] |= (source[15] >> 18) & 0x7ffff;
    destination[26]  = (source[15] << 1) & 0x7ffff;
    destination[26] |= (source[16] >> 31) & 0x7ffff;
    destination[27]  = (source[16] >> 12) & 0x7ffff;
    destination[28]  = (source[16] << 7) & 0x7ffff;
    destination[28] |= (source[17] >> 25) & 0x7ffff;
    destination[29]  = (source[17] >> 6) & 0x7ffff;
    destination[30]  = (source[17] << 13) & 0x7ffff;
    destination[30] |= (source[18] >> 19) & 0x7ffff;
    destination[31]  = (source[18] >> 0) & 0x7ffff;
  }
};
template <typename Tp>
struct __struct_bitpack_impl<Tp,4,20>
{
  static const size_t unit_size = 32;
  static const size_t bits_total = 640;
  static const size_t loop_total = 32;
  static const size_t bit_size = 20;
  static const Tp     mask = 0xfffff;
  static inline
  void pack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] & 0xfffff) << 12;
    destination[0] |= (source[1] & 0xfffff) >> 8;
    destination[1]  = (source[1] & 0xfffff) << 24;
    destination[1] |= (source[2] & 0xfffff) << 4;
    destination[1] |= (source[3] & 0xfffff) >> 16;
    destination[2]  = (source[3] & 0xfffff) << 16;
    destination[2] |= (source[4] & 0xfffff) >> 4;
    destination[3]  = (source[4] & 0xfffff) << 28;
    destination[3] |= (source[5] & 0xfffff) << 8;
    destination[3] |= (source[6] & 0xfffff) >> 12;
    destination[4]  = (source[6] & 0xfffff) << 20;
    destination[4] |= (source[7] & 0xfffff) << 0;
    destination[5]  = (source[8] & 0xfffff) << 12;
    destination[5] |= (source[9] & 0xfffff) >> 8;
    destination[6]  = (source[9] & 0xfffff) << 24;
    destination[6] |= (source[10] & 0xfffff) << 4;
    destination[6] |= (source[11] & 0xfffff) >> 16;
    destination[7]  = (source[11] & 0xfffff) << 16;
    destination[7] |= (source[12] & 0xfffff) >> 4;
    destination[8]  = (source[12] & 0xfffff) << 28;
    destination[8] |= (source[13] & 0xfffff) << 8;
    destination[8] |= (source[14] & 0xfffff) >> 12;
    destination[9]  = (source[14] & 0xfffff) << 20;
    destination[9] |= (source[15] & 0xfffff) << 0;
    destination[10]  = (source[16] & 0xfffff) << 12;
    destination[10] |= (source[17] & 0xfffff) >> 8;
    destination[11]  = (source[17] & 0xfffff) << 24;
    destination[11] |= (source[18] & 0xfffff) << 4;
    destination[11] |= (source[19] & 0xfffff) >> 16;
    destination[12]  = (source[19] & 0xfffff) << 16;
    destination[12] |= (source[20] & 0xfffff) >> 4;
    destination[13]  = (source[20] & 0xfffff) << 28;
    destination[13] |= (source[21] & 0xfffff) << 8;
    destination[13] |= (source[22] & 0xfffff) >> 12;
    destination[14]  = (source[22] & 0xfffff) << 20;
    destination[14] |= (source[23] & 0xfffff) << 0;
    destination[15]  = (source[24] & 0xfffff) << 12;
    destination[15] |= (source[25] & 0xfffff) >> 8;
    destination[16]  = (source[25] & 0xfffff) << 24;
    destination[16] |= (source[26] & 0xfffff) << 4;
    destination[16] |= (source[27] & 0xfffff) >> 16;
    destination[17]  = (source[27] & 0xfffff) << 16;
    destination[17] |= (source[28] & 0xfffff) >> 4;
    destination[18]  = (source[28] & 0xfffff) << 28;
    destination[18] |= (source[29] & 0xfffff) << 8;
    destination[18] |= (source[30] & 0xfffff) >> 12;
    destination[19]  = (source[30] & 0xfffff) << 20;
    destination[19] |= (source[31] & 0xfffff) << 0;
  }
  static inline
  void unpack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] >> 12) & 0xfffff;
    destination[1]  = (source[0] << 8) & 0xfffff;
    destination[1] |= (source[1] >> 24) & 0xfffff;
    destination[2]  = (source[1] >> 4) & 0xfffff;
    destination[3]  = (source[1] << 16) & 0xfffff;
    destination[3] |= (source[2] >> 16) & 0xfffff;
    destination[4]  = (source[2] << 4) & 0xfffff;
    destination[4] |= (source[3] >> 28) & 0xfffff;
    destination[5]  = (source[3] >> 8) & 0xfffff;
    destination[6]  = (source[3] << 12) & 0xfffff;
    destination[6] |= (source[4] >> 20) & 0xfffff;
    destination[7]  = (source[4] >> 0) & 0xfffff;
    destination[8]  = (source[5] >> 12) & 0xfffff;
    destination[9]  = (source[5] << 8) & 0xfffff;
    destination[9] |= (source[6] >> 24) & 0xfffff;
    destination[10]  = (source[6] >> 4) & 0xfffff;
    destination[11]  = (source[6] << 16) & 0xfffff;
    destination[11] |= (source[7] >> 16) & 0xfffff;
    destination[12]  = (source[7] << 4) & 0xfffff;
    destination[12] |= (source[8] >> 28) & 0xfffff;
    destination[13]  = (source[8] >> 8) & 0xfffff;
    destination[14]  = (source[8] << 12) & 0xfffff;
    destination[14] |= (source[9] >> 20) & 0xfffff;
    destination[15]  = (source[9] >> 0) & 0xfffff;
    destination[16]  = (source[10] >> 12) & 0xfffff;
    destination[17]  = (source[10] << 8) & 0xfffff;
    destination[17] |= (source[11] >> 24) & 0xfffff;
    destination[18]  = (source[11] >> 4) & 0xfffff;
    destination[19]  = (source[11] << 16) & 0xfffff;
    destination[19] |= (source[12] >> 16) & 0xfffff;
    destination[20]  = (source[12] << 4) & 0xfffff;
    destination[20] |= (source[13] >> 28) & 0xfffff;
    destination[21]  = (source[13] >> 8) & 0xfffff;
    destination[22]  = (source[13] << 12) & 0xfffff;
    destination[22] |= (source[14] >> 20) & 0xfffff;
    destination[23]  = (source[14] >> 0) & 0xfffff;
    destination[24]  = (source[15] >> 12) & 0xfffff;
    destination[25]  = (source[15] << 8) & 0xfffff;
    destination[25] |= (source[16] >> 24) & 0xfffff;
    destination[26]  = (source[16] >> 4) & 0xfffff;
    destination[27]  = (source[16] << 16) & 0xfffff;
    destination[27] |= (source[17] >> 16) & 0xfffff;
    destination[28]  = (source[17] << 4) & 0xfffff;
    destination[28] |= (source[18] >> 28) & 0xfffff;
    destination[29]  = (source[18] >> 8) & 0xfffff;
    destination[30]  = (source[18] << 12) & 0xfffff;
    destination[30] |= (source[19] >> 20) & 0xfffff;
    destination[31]  = (source[19] >> 0) & 0xfffff;
  }
};
template <typename Tp>
struct __struct_bitpack_impl<Tp,4,21>
{
  static const size_t unit_size = 32;
  static const size_t bits_total = 672;
  static const size_t loop_total = 32;
  static const size_t bit_size = 21;
  static const Tp     mask = 0x1fffff;
  static inline
  void pack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] & 0x1fffff) << 11;
    destination[0] |= (source[1] & 0x1fffff) >> 10;
    destination[1]  = (source[1] & 0x1fffff) << 22;
    destination[1] |= (source[2] & 0x1fffff) << 1;
    destination[1] |= (source[3] & 0x1fffff) >> 20;
    destination[2]  = (source[3] & 0x1fffff) << 12;
    destination[2] |= (source[4] & 0x1fffff) >> 9;
    destination[3]  = (source[4] & 0x1fffff) << 23;
    destination[3] |= (source[5] & 0x1fffff) << 2;
    destination[3] |= (source[6] & 0x1fffff) >> 19;
    destination[4]  = (source[6] & 0x1fffff) << 13;
    destination[4] |= (source[7] & 0x1fffff) >> 8;
    destination[5]  = (source[7] & 0x1fffff) << 24;
    destination[5] |= (source[8] & 0x1fffff) << 3;
    destination[5] |= (source[9] & 0x1fffff) >> 18;
    destination[6]  = (source[9] & 0x1fffff) << 14;
    destination[6] |= (source[10] & 0x1fffff) >> 7;
    destination[7]  = (source[10] & 0x1fffff) << 25;
    destination[7] |= (source[11] & 0x1fffff) << 4;
    destination[7] |= (source[12] & 0x1fffff) >> 17;
    destination[8]  = (source[12] & 0x1fffff) << 15;
    destination[8] |= (source[13] & 0x1fffff) >> 6;
    destination[9]  = (source[13] & 0x1fffff) << 26;
    destination[9] |= (source[14] & 0x1fffff) << 5;
    destination[9] |= (source[15] & 0x1fffff) >> 16;
    destination[10]  = (source[15] & 0x1fffff) << 16;
    destination[10] |= (source[16] & 0x1fffff) >> 5;
    destination[11]  = (source[16] & 0x1fffff) << 27;
    destination[11] |= (source[17] & 0x1fffff) << 6;
    destination[11] |= (source[18] & 0x1fffff) >> 15;
    destination[12]  = (source[18] & 0x1fffff) << 17;
    destination[12] |= (source[19] & 0x1fffff) >> 4;
    destination[13]  = (source[19] & 0x1fffff) << 28;
    destination[13] |= (source[20] & 0x1fffff) << 7;
    destination[13] |= (source[21] & 0x1fffff) >> 14;
    destination[14]  = (source[21] & 0x1fffff) << 18;
    destination[14] |= (source[22] & 0x1fffff) >> 3;
    destination[15]  = (source[22] & 0x1fffff) << 29;
    destination[15] |= (source[23] & 0x1fffff) << 8;
    destination[15] |= (source[24] & 0x1fffff) >> 13;
    destination[16]  = (source[24] & 0x1fffff) << 19;
    destination[16] |= (source[25] & 0x1fffff) >> 2;
    destination[17]  = (source[25] & 0x1fffff) << 30;
    destination[17] |= (source[26] & 0x1fffff) << 9;
    destination[17] |= (source[27] & 0x1fffff) >> 12;
    destination[18]  = (source[27] & 0x1fffff) << 20;
    destination[18] |= (source[28] & 0x1fffff) >> 1;
    destination[19]  = (source[28] & 0x1fffff) << 31;
    destination[19] |= (source[29] & 0x1fffff) << 10;
    destination[19] |= (source[30] & 0x1fffff) >> 11;
    destination[20]  = (source[30] & 0x1fffff) << 21;
    destination[20] |= (source[31] & 0x1fffff) << 0;
  }
  static inline
  void unpack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] >> 11) & 0x1fffff;
    destination[1]  = (source[0] << 10) & 0x1fffff;
    destination[1] |= (source[1] >> 22) & 0x1fffff;
    destination[2]  = (source[1] >> 1) & 0x1fffff;
    destination[3]  = (source[1] << 20) & 0x1fffff;
    destination[3] |= (source[2] >> 12) & 0x1fffff;
    destination[4]  = (source[2] << 9) & 0x1fffff;
    destination[4] |= (source[3] >> 23) & 0x1fffff;
    destination[5]  = (source[3] >> 2) & 0x1fffff;
    destination[6]  = (source[3] << 19) & 0x1fffff;
    destination[6] |= (source[4] >> 13) & 0x1fffff;
    destination[7]  = (source[4] << 8) & 0x1fffff;
    destination[7] |= (source[5] >> 24) & 0x1fffff;
    destination[8]  = (source[5] >> 3) & 0x1fffff;
    destination[9]  = (source[5] << 18) & 0x1fffff;
    destination[9] |= (source[6] >> 14) & 0x1fffff;
    destination[10]  = (source[6] << 7) & 0x1fffff;
    destination[10] |= (source[7] >> 25) & 0x1fffff;
    destination[11]  = (source[7] >> 4) & 0x1fffff;
    destination[12]  = (source[7] << 17) & 0x1fffff;
    destination[12] |= (source[8] >> 15) & 0x1fffff;
    destination[13]  = (source[8] << 6) & 0x1fffff;
    destination[13] |= (source[9] >> 26) & 0x1fffff;
    destination[14]  = (source[9] >> 5) & 0x1fffff;
    destination[15]  = (source[9] << 16) & 0x1fffff;
    destination[15] |= (source[10] >> 16) & 0x1fffff;
    destination[16]  = (source[10] << 5) & 0x1fffff;
    destination[16] |= (source[11] >> 27) & 0x1fffff;
    destination[17]  = (source[11] >> 6) & 0x1fffff;
    destination[18]  = (source[11] << 15) & 0x1fffff;
    destination[18] |= (source[12] >> 17) & 0x1fffff;
    destination[19]  = (source[12] << 4) & 0x1fffff;
    destination[19] |= (source[13] >> 28) & 0x1fffff;
    destination[20]  = (source[13] >> 7) & 0x1fffff;
    destination[21]  = (source[13] << 14) & 0x1fffff;
    destination[21] |= (source[14] >> 18) & 0x1fffff;
    destination[22]  = (source[14] << 3) & 0x1fffff;
    destination[22] |= (source[15] >> 29) & 0x1fffff;
    destination[23]  = (source[15] >> 8) & 0x1fffff;
    destination[24]  = (source[15] << 13) & 0x1fffff;
    destination[24] |= (source[16] >> 19) & 0x1fffff;
    destination[25]  = (source[16] << 2) & 0x1fffff;
    destination[25] |= (source[17] >> 30) & 0x1fffff;
    destination[26]  = (source[17] >> 9) & 0x1fffff;
    destination[27]  = (source[17] << 12) & 0x1fffff;
    destination[27] |= (source[18] >> 20) & 0x1fffff;
    destination[28]  = (source[18] << 1) & 0x1fffff;
    destination[28] |= (source[19] >> 31) & 0x1fffff;
    destination[29]  = (source[19] >> 10) & 0x1fffff;
    destination[30]  = (source[19] << 11) & 0x1fffff;
    destination[30] |= (source[20] >> 21) & 0x1fffff;
    destination[31]  = (source[20] >> 0) & 0x1fffff;
  }
};
template <typename Tp>
struct __struct_bitpack_impl<Tp,4,22>
{
  static const size_t unit_size = 32;
  static const size_t bits_total = 704;
  static const size_t loop_total = 32;
  static const size_t bit_size = 22;
  static const Tp     mask = 0x3fffff;
  static inline
  void pack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] & 0x3fffff) << 10;
    destination[0] |= (source[1] & 0x3fffff) >> 12;
    destination[1]  = (source[1] & 0x3fffff) << 20;
    destination[1] |= (source[2] & 0x3fffff) >> 2;
    destination[2]  = (source[2] & 0x3fffff) << 30;
    destination[2] |= (source[3] & 0x3fffff) << 8;
    destination[2] |= (source[4] & 0x3fffff) >> 14;
    destination[3]  = (source[4] & 0x3fffff) << 18;
    destination[3] |= (source[5] & 0x3fffff) >> 4;
    destination[4]  = (source[5] & 0x3fffff) << 28;
    destination[4] |= (source[6] & 0x3fffff) << 6;
    destination[4] |= (source[7] & 0x3fffff) >> 16;
    destination[5]  = (source[7] & 0x3fffff) << 16;
    destination[5] |= (source[8] & 0x3fffff) >> 6;
    destination[6]  = (source[8] & 0x3fffff) << 26;
    destination[6] |= (source[9] & 0x3fffff) << 4;
    destination[6] |= (source[10] & 0x3fffff) >> 18;
    destination[7]  = (source[10] & 0x3fffff) << 14;
    destination[7] |= (source[11] & 0x3fffff) >> 8;
    destination[8]  = (source[11] & 0x3fffff) << 24;
    destination[8] |= (source[12] & 0x3fffff) << 2;
    destination[8] |= (source[13] & 0x3fffff) >> 20;
    destination[9]  = (source[13] & 0x3fffff) << 12;
    destination[9] |= (source[14] & 0x3fffff) >> 10;
    destination[10]  = (source[14] & 0x3fffff) << 22;
    destination[10] |= (source[15] & 0x3fffff) << 0;
    destination[11]  = (source[16] & 0x3fffff) << 10;
    destination[11] |= (source[17] & 0x3fffff) >> 12;
    destination[12]  = (source[17] & 0x3fffff) << 20;
    destination[12] |= (source[18] & 0x3fffff) >> 2;
    destination[13]  = (source[18] & 0x3fffff) << 30;
    destination[13] |= (source[19] & 0x3fffff) << 8;
    destination[13] |= (source[20] & 0x3fffff) >> 14;
    destination[14]  = (source[20] & 0x3fffff) << 18;
    destination[14] |= (source[21] & 0x3fffff) >> 4;
    destination[15]  = (source[21] & 0x3fffff) << 28;
    destination[15] |= (source[22] & 0x3fffff) << 6;
    destination[15] |= (source[23] & 0x3fffff) >> 16;
    destination[16]  = (source[23] & 0x3fffff) << 16;
    destination[16] |= (source[24] & 0x3fffff) >> 6;
    destination[17]  = (source[24] & 0x3fffff) << 26;
    destination[17] |= (source[25] & 0x3fffff) << 4;
    destination[17] |= (source[26] & 0x3fffff) >> 18;
    destination[18]  = (source[26] & 0x3fffff) << 14;
    destination[18] |= (source[27] & 0x3fffff) >> 8;
    destination[19]  = (source[27] & 0x3fffff) << 24;
    destination[19] |= (source[28] & 0x3fffff) << 2;
    destination[19] |= (source[29] & 0x3fffff) >> 20;
    destination[20]  = (source[29] & 0x3fffff) << 12;
    destination[20] |= (source[30] & 0x3fffff) >> 10;
    destination[21]  = (source[30] & 0x3fffff) << 22;
    destination[21] |= (source[31] & 0x3fffff) << 0;
  }
  static inline
  void unpack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] >> 10) & 0x3fffff;
    destination[1]  = (source[0] << 12) & 0x3fffff;
    destination[1] |= (source[1] >> 20) & 0x3fffff;
    destination[2]  = (source[1] << 2) & 0x3fffff;
    destination[2] |= (source[2] >> 30) & 0x3fffff;
    destination[3]  = (source[2] >> 8) & 0x3fffff;
    destination[4]  = (source[2] << 14) & 0x3fffff;
    destination[4] |= (source[3] >> 18) & 0x3fffff;
    destination[5]  = (source[3] << 4) & 0x3fffff;
    destination[5] |= (source[4] >> 28) & 0x3fffff;
    destination[6]  = (source[4] >> 6) & 0x3fffff;
    destination[7]  = (source[4] << 16) & 0x3fffff;
    destination[7] |= (source[5] >> 16) & 0x3fffff;
    destination[8]  = (source[5] << 6) & 0x3fffff;
    destination[8] |= (source[6] >> 26) & 0x3fffff;
    destination[9]  = (source[6] >> 4) & 0x3fffff;
    destination[10]  = (source[6] << 18) & 0x3fffff;
    destination[10] |= (source[7] >> 14) & 0x3fffff;
    destination[11]  = (source[7] << 8) & 0x3fffff;
    destination[11] |= (source[8] >> 24) & 0x3fffff;
    destination[12]  = (source[8] >> 2) & 0x3fffff;
    destination[13]  = (source[8] << 20) & 0x3fffff;
    destination[13] |= (source[9] >> 12) & 0x3fffff;
    destination[14]  = (source[9] << 10) & 0x3fffff;
    destination[14] |= (source[10] >> 22) & 0x3fffff;
    destination[15]  = (source[10] >> 0) & 0x3fffff;
    destination[16]  = (source[11] >> 10) & 0x3fffff;
    destination[17]  = (source[11] << 12) & 0x3fffff;
    destination[17] |= (source[12] >> 20) & 0x3fffff;
    destination[18]  = (source[12] << 2) & 0x3fffff;
    destination[18] |= (source[13] >> 30) & 0x3fffff;
    destination[19]  = (source[13] >> 8) & 0x3fffff;
    destination[20]  = (source[13] << 14) & 0x3fffff;
    destination[20] |= (source[14] >> 18) & 0x3fffff;
    destination[21]  = (source[14] << 4) & 0x3fffff;
    destination[21] |= (source[15] >> 28) & 0x3fffff;
    destination[22]  = (source[15] >> 6) & 0x3fffff;
    destination[23]  = (source[15] << 16) & 0x3fffff;
    destination[23] |= (source[16] >> 16) & 0x3fffff;
    destination[24]  = (source[16] << 6) & 0x3fffff;
    destination[24] |= (source[17] >> 26) & 0x3fffff;
    destination[25]  = (source[17] >> 4) & 0x3fffff;
    destination[26]  = (source[17] << 18) & 0x3fffff;
    destination[26] |= (source[18] >> 14) & 0x3fffff;
    destination[27]  = (source[18] << 8) & 0x3fffff;
    destination[27] |= (source[19] >> 24) & 0x3fffff;
    destination[28]  = (source[19] >> 2) & 0x3fffff;
    destination[29]  = (source[19] << 20) & 0x3fffff;
    destination[29] |= (source[20] >> 12) & 0x3fffff;
    destination[30]  = (source[20] << 10) & 0x3fffff;
    destination[30] |= (source[21] >> 22) & 0x3fffff;
    destination[31]  = (source[21] >> 0) & 0x3fffff;
  }
};
template <typename Tp>
struct __struct_bitpack_impl<Tp,4,23>
{
  static const size_t unit_size = 32;
  static const size_t bits_total = 736;
  static const size_t loop_total = 32;
  static const size_t bit_size = 23;
  static const Tp     mask = 0x7fffff;
  static inline
  void pack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] & 0x7fffff) << 9;
    destination[0] |= (source[1] & 0x7fffff) >> 14;
    destination[1]  = (source[1] & 0x7fffff) << 18;
    destination[1] |= (source[2] & 0x7fffff) >> 5;
    destination[2]  = (source[2] & 0x7fffff) << 27;
    destination[2] |= (source[3] & 0x7fffff) << 4;
    destination[2] |= (source[4] & 0x7fffff) >> 19;
    destination[3]  = (source[4] & 0x7fffff) << 13;
    destination[3] |= (source[5] & 0x7fffff) >> 10;
    destination[4]  = (source[5] & 0x7fffff) << 22;
    destination[4] |= (source[6] & 0x7fffff) >> 1;
    destination[5]  = (source[6] & 0x7fffff) << 31;
    destination[5] |= (source[7] & 0x7fffff) << 8;
    destination[5] |= (source[8] & 0x7fffff) >> 15;
    destination[6]  = (source[8] & 0x7fffff) << 17;
    destination[6] |= (source[9] & 0x7fffff) >> 6;
    destination[7]  = (source[9] & 0x7fffff) << 26;
    destination[7] |= (source[10] & 0x7fffff) << 3;
    destination[7] |= (source[11] & 0x7fffff) >> 20;
    destination[8]  = (source[11] & 0x7fffff) << 12;
    destination[8] |= (source[12] & 0x7fffff) >> 11;
    destination[9]  = (source[12] & 0x7fffff) << 21;
    destination[9] |= (source[13] & 0x7fffff) >> 2;
    destination[10]  = (source[13] & 0x7fffff) << 30;
    destination[10] |= (source[14] & 0x7fffff) << 7;
    destination[10] |= (source[15] & 0x7fffff) >> 16;
    destination[11]  = (source[15] & 0x7fffff) << 16;
    destination[11] |= (source[16] & 0x7fffff) >> 7;
    destination[12]  = (source[16] & 0x7fffff) << 25;
    destination[12] |= (source[17] & 0x7fffff) << 2;
    destination[12] |= (source[18] & 0x7fffff) >> 21;
    destination[13]  = (source[18] & 0x7fffff) << 11;
    destination[13] |= (source[19] & 0x7fffff) >> 12;
    destination[14]  = (source[19] & 0x7fffff) << 20;
    destination[14] |= (source[20] & 0x7fffff) >> 3;
    destination[15]  = (source[20] & 0x7fffff) << 29;
    destination[15] |= (source[21] & 0x7fffff) << 6;
    destination[15] |= (source[22] & 0x7fffff) >> 17;
    destination[16]  = (source[22] & 0x7fffff) << 15;
    destination[16] |= (source[23] & 0x7fffff) >> 8;
    destination[17]  = (source[23] & 0x7fffff) << 24;
    destination[17] |= (source[24] & 0x7fffff) << 1;
    destination[17] |= (source[25] & 0x7fffff) >> 22;
    destination[18]  = (source[25] & 0x7fffff) << 10;
    destination[18] |= (source[26] & 0x7fffff) >> 13;
    destination[19]  = (source[26] & 0x7fffff) << 19;
    destination[19] |= (source[27] & 0x7fffff) >> 4;
    destination[20]  = (source[27] & 0x7fffff) << 28;
    destination[20] |= (source[28] & 0x7fffff) << 5;
    destination[20] |= (source[29] & 0x7fffff) >> 18;
    destination[21]  = (source[29] & 0x7fffff) << 14;
    destination[21] |= (source[30] & 0x7fffff) >> 9;
    destination[22]  = (source[30] & 0x7fffff) << 23;
    destination[22] |= (source[31] & 0x7fffff) << 0;
  }
  static inline
  void unpack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] >> 9) & 0x7fffff;
    destination[1]  = (source[0] << 14) & 0x7fffff;
    destination[1] |= (source[1] >> 18) & 0x7fffff;
    destination[2]  = (source[1] << 5) & 0x7fffff;
    destination[2] |= (source[2] >> 27) & 0x7fffff;
    destination[3]  = (source[2] >> 4) & 0x7fffff;
    destination[4]  = (source[2] << 19) & 0x7fffff;
    destination[4] |= (source[3] >> 13) & 0x7fffff;
    destination[5]  = (source[3] << 10) & 0x7fffff;
    destination[5] |= (source[4] >> 22) & 0x7fffff;
    destination[6]  = (source[4] << 1) & 0x7fffff;
    destination[6] |= (source[5] >> 31) & 0x7fffff;
    destination[7]  = (source[5] >> 8) & 0x7fffff;
    destination[8]  = (source[5] << 15) & 0x7fffff;
    destination[8] |= (source[6] >> 17) & 0x7fffff;
    destination[9]  = (source[6] << 6) & 0x7fffff;
    destination[9] |= (source[7] >> 26) & 0x7fffff;
    destination[10]  = (source[7] >> 3) & 0x7fffff;
    destination[11]  = (source[7] << 20) & 0x7fffff;
    destination[11] |= (source[8] >> 12) & 0x7fffff;
    destination[12]  = (source[8] << 11) & 0x7fffff;
    destination[12] |= (source[9] >> 21) & 0x7fffff;
    destination[13]  = (source[9] << 2) & 0x7fffff;
    destination[13] |= (source[10] >> 30) & 0x7fffff;
    destination[14]  = (source[10] >> 7) & 0x7fffff;
    destination[15]  = (source[10] << 16) & 0x7fffff;
    destination[15] |= (source[11] >> 16) & 0x7fffff;
    destination[16]  = (source[11] << 7) & 0x7fffff;
    destination[16] |= (source[12] >> 25) & 0x7fffff;
    destination[17]  = (source[12] >> 2) & 0x7fffff;
    destination[18]  = (source[12] << 21) & 0x7fffff;
    destination[18] |= (source[13] >> 11) & 0x7fffff;
    destination[19]  = (source[13] << 12) & 0x7fffff;
    destination[19] |= (source[14] >> 20) & 0x7fffff;
    destination[20]  = (source[14] << 3) & 0x7fffff;
    destination[20] |= (source[15] >> 29) & 0x7fffff;
    destination[21]  = (source[15] >> 6) & 0x7fffff;
    destination[22]  = (source[15] << 17) & 0x7fffff;
    destination[22] |= (source[16] >> 15) & 0x7fffff;
    destination[23]  = (source[16] << 8) & 0x7fffff;
    destination[23] |= (source[17] >> 24) & 0x7fffff;
    destination[24]  = (source[17] >> 1) & 0x7fffff;
    destination[25]  = (source[17] << 22) & 0x7fffff;
    destination[25] |= (source[18] >> 10) & 0x7fffff;
    destination[26]  = (source[18] << 13) & 0x7fffff;
    destination[26] |= (source[19] >> 19) & 0x7fffff;
    destination[27]  = (source[19] << 4) & 0x7fffff;
    destination[27] |= (source[20] >> 28) & 0x7fffff;
    destination[28]  = (source[20] >> 5) & 0x7fffff;
    destination[29]  = (source[20] << 18) & 0x7fffff;
    destination[29] |= (source[21] >> 14) & 0x7fffff;
    destination[30]  = (source[21] << 9) & 0x7fffff;
    destination[30] |= (source[22] >> 23) & 0x7fffff;
    destination[31]  = (source[22] >> 0) & 0x7fffff;
  }
};
template <typename Tp>
struct __struct_bitpack_impl<Tp,4,24>
{
  static const size_t unit_size = 32;
  static const size_t bits_total = 768;
  static const size_t loop_total = 32;
  static const size_t bit_size = 24;
  static const Tp     mask = 0xffffff;
  static inline
  void pack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] & 0xffffff) << 8;
    destination[0] |= (source[1] & 0xffffff) >> 16;
    destination[1]  = (source[1] & 0xffffff) << 16;
    destination[1] |= (source[2] & 0xffffff) >> 8;
    destination[2]  = (source[2] & 0xffffff) << 24;
    destination[2] |= (source[3] & 0xffffff) << 0;
    destination[3]  = (source[4] & 0xffffff) << 8;
    destination[3] |= (source[5] & 0xffffff) >> 16;
    destination[4]  = (source[5] & 0xffffff) << 16;
    destination[4] |= (source[6] & 0xffffff) >> 8;
    destination[5]  = (source[6] & 0xffffff) << 24;
    destination[5] |= (source[7] & 0xffffff) << 0;
    destination[6]  = (source[8] & 0xffffff) << 8;
    destination[6] |= (source[9] & 0xffffff) >> 16;
    destination[7]  = (source[9] & 0xffffff) << 16;
    destination[7] |= (source[10] & 0xffffff) >> 8;
    destination[8]  = (source[10] & 0xffffff) << 24;
    destination[8] |= (source[11] & 0xffffff) << 0;
    destination[9]  = (source[12] & 0xffffff) << 8;
    destination[9] |= (source[13] & 0xffffff) >> 16;
    destination[10]  = (source[13] & 0xffffff) << 16;
    destination[10] |= (source[14] & 0xffffff) >> 8;
    destination[11]  = (source[14] & 0xffffff) << 24;
    destination[11] |= (source[15] & 0xffffff) << 0;
    destination[12]  = (source[16] & 0xffffff) << 8;
    destination[12] |= (source[17] & 0xffffff) >> 16;
    destination[13]  = (source[17] & 0xffffff) << 16;
    destination[13] |= (source[18] & 0xffffff) >> 8;
    destination[14]  = (source[18] & 0xffffff) << 24;
    destination[14] |= (source[19] & 0xffffff) << 0;
    destination[15]  = (source[20] & 0xffffff) << 8;
    destination[15] |= (source[21] & 0xffffff) >> 16;
    destination[16]  = (source[21] & 0xffffff) << 16;
    destination[16] |= (source[22] & 0xffffff) >> 8;
    destination[17]  = (source[22] & 0xffffff) << 24;
    destination[17] |= (source[23] & 0xffffff) << 0;
    destination[18]  = (source[24] & 0xffffff) << 8;
    destination[18] |= (source[25] & 0xffffff) >> 16;
    destination[19]  = (source[25] & 0xffffff) << 16;
    destination[19] |= (source[26] & 0xffffff) >> 8;
    destination[20]  = (source[26] & 0xffffff) << 24;
    destination[20] |= (source[27] & 0xffffff) << 0;
    destination[21]  = (source[28] & 0xffffff) << 8;
    destination[21] |= (source[29] & 0xffffff) >> 16;
    destination[22]  = (source[29] & 0xffffff) << 16;
    destination[22] |= (source[30] & 0xffffff) >> 8;
    destination[23]  = (source[30] & 0xffffff) << 24;
    destination[23] |= (source[31] & 0xffffff) << 0;
  }
  static inline
  void unpack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] >> 8) & 0xffffff;
    destination[1]  = (source[0] << 16) & 0xffffff;
    destination[1] |= (source[1] >> 16) & 0xffffff;
    destination[2]  = (source[1] << 8) & 0xffffff;
    destination[2] |= (source[2] >> 24) & 0xffffff;
    destination[3]  = (source[2] >> 0) & 0xffffff;
    destination[4]  = (source[3] >> 8) & 0xffffff;
    destination[5]  = (source[3] << 16) & 0xffffff;
    destination[5] |= (source[4] >> 16) & 0xffffff;
    destination[6]  = (source[4] << 8) & 0xffffff;
    destination[6] |= (source[5] >> 24) & 0xffffff;
    destination[7]  = (source[5] >> 0) & 0xffffff;
    destination[8]  = (source[6] >> 8) & 0xffffff;
    destination[9]  = (source[6] << 16) & 0xffffff;
    destination[9] |= (source[7] >> 16) & 0xffffff;
    destination[10]  = (source[7] << 8) & 0xffffff;
    destination[10] |= (source[8] >> 24) & 0xffffff;
    destination[11]  = (source[8] >> 0) & 0xffffff;
    destination[12]  = (source[9] >> 8) & 0xffffff;
    destination[13]  = (source[9] << 16) & 0xffffff;
    destination[13] |= (source[10] >> 16) & 0xffffff;
    destination[14]  = (source[10] << 8) & 0xffffff;
    destination[14] |= (source[11] >> 24) & 0xffffff;
    destination[15]  = (source[11] >> 0) & 0xffffff;
    destination[16]  = (source[12] >> 8) & 0xffffff;
    destination[17]  = (source[12] << 16) & 0xffffff;
    destination[17] |= (source[13] >> 16) & 0xffffff;
    destination[18]  = (source[13] << 8) & 0xffffff;
    destination[18] |= (source[14] >> 24) & 0xffffff;
    destination[19]  = (source[14] >> 0) & 0xffffff;
    destination[20]  = (source[15] >> 8) & 0xffffff;
    destination[21]  = (source[15] << 16) & 0xffffff;
    destination[21] |= (source[16] >> 16) & 0xffffff;
    destination[22]  = (source[16] << 8) & 0xffffff;
    destination[22] |= (source[17] >> 24) & 0xffffff;
    destination[23]  = (source[17] >> 0) & 0xffffff;
    destination[24]  = (source[18] >> 8) & 0xffffff;
    destination[25]  = (source[18] << 16) & 0xffffff;
    destination[25] |= (source[19] >> 16) & 0xffffff;
    destination[26]  = (source[19] << 8) & 0xffffff;
    destination[26] |= (source[20] >> 24) & 0xffffff;
    destination[27]  = (source[20] >> 0) & 0xffffff;
    destination[28]  = (source[21] >> 8) & 0xffffff;
    destination[29]  = (source[21] << 16) & 0xffffff;
    destination[29] |= (source[22] >> 16) & 0xffffff;
    destination[30]  = (source[22] << 8) & 0xffffff;
    destination[30] |= (source[23] >> 24) & 0xffffff;
    destination[31]  = (source[23] >> 0) & 0xffffff;
  }
};
template <typename Tp>
struct __struct_bitpack_impl<Tp,4,25>
{
  static const size_t unit_size = 32;
  static const size_t bits_total = 800;
  static const size_t loop_total = 32;
  static const size_t bit_size = 25;
  static const Tp     mask = 0x1ffffff;
  static inline
  void pack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] & 0x1ffffff) << 7;
    destination[0] |= (source[1] & 0x1ffffff) >> 18;
    destination[1]  = (source[1] & 0x1ffffff) << 14;
    destination[1] |= (source[2] & 0x1ffffff) >> 11;
    destination[2]  = (source[2] & 0x1ffffff) << 21;
    destination[2] |= (source[3] & 0x1ffffff) >> 4;
    destination[3]  = (source[3] & 0x1ffffff) << 28;
    destination[3] |= (source[4] & 0x1ffffff) << 3;
    destination[3] |= (source[5] & 0x1ffffff) >> 22;
    destination[4]  = (source[5] & 0x1ffffff) << 10;
    destination[4] |= (source[6] & 0x1ffffff) >> 15;
    destination[5]  = (source[6] & 0x1ffffff) << 17;
    destination[5] |= (source[7] & 0x1ffffff) >> 8;
    destination[6]  = (source[7] & 0x1ffffff) << 24;
    destination[6] |= (source[8] & 0x1ffffff) >> 1;
    destination[7]  = (source[8] & 0x1ffffff) << 31;
    destination[7] |= (source[9] & 0x1ffffff) << 6;
    destination[7] |= (source[10] & 0x1ffffff) >> 19;
    destination[8]  = (source[10] & 0x1ffffff) << 13;
    destination[8] |= (source[11] & 0x1ffffff) >> 12;
    destination[9]  = (source[11] & 0x1ffffff) << 20;
    destination[9] |= (source[12] & 0x1ffffff) >> 5;
    destination[10]  = (source[12] & 0x1ffffff) << 27;
    destination[10] |= (source[13] & 0x1ffffff) << 2;
    destination[10] |= (source[14] & 0x1ffffff) >> 23;
    destination[11]  = (source[14] & 0x1ffffff) << 9;
    destination[11] |= (source[15] & 0x1ffffff) >> 16;
    destination[12]  = (source[15] & 0x1ffffff) << 16;
    destination[12] |= (source[16] & 0x1ffffff) >> 9;
    destination[13]  = (source[16] & 0x1ffffff) << 23;
    destination[13] |= (source[17] & 0x1ffffff) >> 2;
    destination[14]  = (source[17] & 0x1ffffff) << 30;
    destination[14] |= (source[18] & 0x1ffffff) << 5;
    destination[14] |= (source[19] & 0x1ffffff) >> 20;
    destination[15]  = (source[19] & 0x1ffffff) << 12;
    destination[15] |= (source[20] & 0x1ffffff) >> 13;
    destination[16]  = (source[20] & 0x1ffffff) << 19;
    destination[16] |= (source[21] & 0x1ffffff) >> 6;
    destination[17]  = (source[21] & 0x1ffffff) << 26;
    destination[17] |= (source[22] & 0x1ffffff) << 1;
    destination[17] |= (source[23] & 0x1ffffff) >> 24;
    destination[18]  = (source[23] & 0x1ffffff) << 8;
    destination[18] |= (source[24] & 0x1ffffff) >> 17;
    destination[19]  = (source[24] & 0x1ffffff) << 15;
    destination[19] |= (source[25] & 0x1ffffff) >> 10;
    destination[20]  = (source[25] & 0x1ffffff) << 22;
    destination[20] |= (source[26] & 0x1ffffff) >> 3;
    destination[21]  = (source[26] & 0x1ffffff) << 29;
    destination[21] |= (source[27] & 0x1ffffff) << 4;
    destination[21] |= (source[28] & 0x1ffffff) >> 21;
    destination[22]  = (source[28] & 0x1ffffff) << 11;
    destination[22] |= (source[29] & 0x1ffffff) >> 14;
    destination[23]  = (source[29] & 0x1ffffff) << 18;
    destination[23] |= (source[30] & 0x1ffffff) >> 7;
    destination[24]  = (source[30] & 0x1ffffff) << 25;
    destination[24] |= (source[31] & 0x1ffffff) << 0;
  }
  static inline
  void unpack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] >> 7) & 0x1ffffff;
    destination[1]  = (source[0] << 18) & 0x1ffffff;
    destination[1] |= (source[1] >> 14) & 0x1ffffff;
    destination[2]  = (source[1] << 11) & 0x1ffffff;
    destination[2] |= (source[2] >> 21) & 0x1ffffff;
    destination[3]  = (source[2] << 4) & 0x1ffffff;
    destination[3] |= (source[3] >> 28) & 0x1ffffff;
    destination[4]  = (source[3] >> 3) & 0x1ffffff;
    destination[5]  = (source[3] << 22) & 0x1ffffff;
    destination[5] |= (source[4] >> 10) & 0x1ffffff;
    destination[6]  = (source[4] << 15) & 0x1ffffff;
    destination[6] |= (source[5] >> 17) & 0x1ffffff;
    destination[7]  = (source[5] << 8) & 0x1ffffff;
    destination[7] |= (source[6] >> 24) & 0x1ffffff;
    destination[8]  = (source[6] << 1) & 0x1ffffff;
    destination[8] |= (source[7] >> 31) & 0x1ffffff;
    destination[9]  = (source[7] >> 6) & 0x1ffffff;
    destination[10]  = (source[7] << 19) & 0x1ffffff;
    destination[10] |= (source[8] >> 13) & 0x1ffffff;
    destination[11]  = (source[8] << 12) & 0x1ffffff;
    destination[11] |= (source[9] >> 20) & 0x1ffffff;
    destination[12]  = (source[9] << 5) & 0x1ffffff;
    destination[12] |= (source[10] >> 27) & 0x1ffffff;
    destination[13]  = (source[10] >> 2) & 0x1ffffff;
    destination[14]  = (source[10] << 23) & 0x1ffffff;
    destination[14] |= (source[11] >> 9) & 0x1ffffff;
    destination[15]  = (source[11] << 16) & 0x1ffffff;
    destination[15] |= (source[12] >> 16) & 0x1ffffff;
    destination[16]  = (source[12] << 9) & 0x1ffffff;
    destination[16] |= (source[13] >> 23) & 0x1ffffff;
    destination[17]  = (source[13] << 2) & 0x1ffffff;
    destination[17] |= (source[14] >> 30) & 0x1ffffff;
    destination[18]  = (source[14] >> 5) & 0x1ffffff;
    destination[19]  = (source[14] << 20) & 0x1ffffff;
    destination[19] |= (source[15] >> 12) & 0x1ffffff;
    destination[20]  = (source[15] << 13) & 0x1ffffff;
    destination[20] |= (source[16] >> 19) & 0x1ffffff;
    destination[21]  = (source[16] << 6) & 0x1ffffff;
    destination[21] |= (source[17] >> 26) & 0x1ffffff;
    destination[22]  = (source[17] >> 1) & 0x1ffffff;
    destination[23]  = (source[17] << 24) & 0x1ffffff;
    destination[23] |= (source[18] >> 8) & 0x1ffffff;
    destination[24]  = (source[18] << 17) & 0x1ffffff;
    destination[24] |= (source[19] >> 15) & 0x1ffffff;
    destination[25]  = (source[19] << 10) & 0x1ffffff;
    destination[25] |= (source[20] >> 22) & 0x1ffffff;
    destination[26]  = (source[20] << 3) & 0x1ffffff;
    destination[26] |= (source[21] >> 29) & 0x1ffffff;
    destination[27]  = (source[21] >> 4) & 0x1ffffff;
    destination[28]  = (source[21] << 21) & 0x1ffffff;
    destination[28] |= (source[22] >> 11) & 0x1ffffff;
    destination[29]  = (source[22] << 14) & 0x1ffffff;
    destination[29] |= (source[23] >> 18) & 0x1ffffff;
    destination[30]  = (source[23] << 7) & 0x1ffffff;
    destination[30] |= (source[24] >> 25) & 0x1ffffff;
    destination[31]  = (source[24] >> 0) & 0x1ffffff;
  }
};
template <typename Tp>
struct __struct_bitpack_impl<Tp,4,26>
{
  static const size_t unit_size = 32;
  static const size_t bits_total = 832;
  static const size_t loop_total = 32;
  static const size_t bit_size = 26;
  static const Tp     mask = 0x3ffffff;
  static inline
  void pack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] & 0x3ffffff) << 6;
    destination[0] |= (source[1] & 0x3ffffff) >> 20;
    destination[1]  = (source[1] & 0x3ffffff) << 12;
    destination[1] |= (source[2] & 0x3ffffff) >> 14;
    destination[2]  = (source[2] & 0x3ffffff) << 18;
    destination[2] |= (source[3] & 0x3ffffff) >> 8;
    destination[3]  = (source[3] & 0x3ffffff) << 24;
    destination[3] |= (source[4] & 0x3ffffff) >> 2;
    destination[4]  = (source[4] & 0x3ffffff) << 30;
    destination[4] |= (source[5] & 0x3ffffff) << 4;
    destination[4] |= (source[6] & 0x3ffffff) >> 22;
    destination[5]  = (source[6] & 0x3ffffff) << 10;
    destination[5] |= (source[7] & 0x3ffffff) >> 16;
    destination[6]  = (source[7] & 0x3ffffff) << 16;
    destination[6] |= (source[8] & 0x3ffffff) >> 10;
    destination[7]  = (source[8] & 0x3ffffff) << 22;
    destination[7] |= (source[9] & 0x3ffffff) >> 4;
    destination[8]  = (source[9] & 0x3ffffff) << 28;
    destination[8] |= (source[10] & 0x3ffffff) << 2;
    destination[8] |= (source[11] & 0x3ffffff) >> 24;
    destination[9]  = (source[11] & 0x3ffffff) << 8;
    destination[9] |= (source[12] & 0x3ffffff) >> 18;
    destination[10]  = (source[12] & 0x3ffffff) << 14;
    destination[10] |= (source[13] & 0x3ffffff) >> 12;
    destination[11]  = (source[13] & 0x3ffffff) << 20;
    destination[11] |= (source[14] & 0x3ffffff) >> 6;
    destination[12]  = (source[14] & 0x3ffffff) << 26;
    destination[12] |= (source[15] & 0x3ffffff) << 0;
    destination[13]  = (source[16] & 0x3ffffff) << 6;
    destination[13] |= (source[17] & 0x3ffffff) >> 20;
    destination[14]  = (source[17] & 0x3ffffff) << 12;
    destination[14] |= (source[18] & 0x3ffffff) >> 14;
    destination[15]  = (source[18] & 0x3ffffff) << 18;
    destination[15] |= (source[19] & 0x3ffffff) >> 8;
    destination[16]  = (source[19] & 0x3ffffff) << 24;
    destination[16] |= (source[20] & 0x3ffffff) >> 2;
    destination[17]  = (source[20] & 0x3ffffff) << 30;
    destination[17] |= (source[21] & 0x3ffffff) << 4;
    destination[17] |= (source[22] & 0x3ffffff) >> 22;
    destination[18]  = (source[22] & 0x3ffffff) << 10;
    destination[18] |= (source[23] & 0x3ffffff) >> 16;
    destination[19]  = (source[23] & 0x3ffffff) << 16;
    destination[19] |= (source[24] & 0x3ffffff) >> 10;
    destination[20]  = (source[24] & 0x3ffffff) << 22;
    destination[20] |= (source[25] & 0x3ffffff) >> 4;
    destination[21]  = (source[25] & 0x3ffffff) << 28;
    destination[21] |= (source[26] & 0x3ffffff) << 2;
    destination[21] |= (source[27] & 0x3ffffff) >> 24;
    destination[22]  = (source[27] & 0x3ffffff) << 8;
    destination[22] |= (source[28] & 0x3ffffff) >> 18;
    destination[23]  = (source[28] & 0x3ffffff) << 14;
    destination[23] |= (source[29] & 0x3ffffff) >> 12;
    destination[24]  = (source[29] & 0x3ffffff) << 20;
    destination[24] |= (source[30] & 0x3ffffff) >> 6;
    destination[25]  = (source[30] & 0x3ffffff) << 26;
    destination[25] |= (source[31] & 0x3ffffff) << 0;
  }
  static inline
  void unpack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] >> 6) & 0x3ffffff;
    destination[1]  = (source[0] << 20) & 0x3ffffff;
    destination[1] |= (source[1] >> 12) & 0x3ffffff;
    destination[2]  = (source[1] << 14) & 0x3ffffff;
    destination[2] |= (source[2] >> 18) & 0x3ffffff;
    destination[3]  = (source[2] << 8) & 0x3ffffff;
    destination[3] |= (source[3] >> 24) & 0x3ffffff;
    destination[4]  = (source[3] << 2) & 0x3ffffff;
    destination[4] |= (source[4] >> 30) & 0x3ffffff;
    destination[5]  = (source[4] >> 4) & 0x3ffffff;
    destination[6]  = (source[4] << 22) & 0x3ffffff;
    destination[6] |= (source[5] >> 10) & 0x3ffffff;
    destination[7]  = (source[5] << 16) & 0x3ffffff;
    destination[7] |= (source[6] >> 16) & 0x3ffffff;
    destination[8]  = (source[6] << 10) & 0x3ffffff;
    destination[8] |= (source[7] >> 22) & 0x3ffffff;
    destination[9]  = (source[7] << 4) & 0x3ffffff;
    destination[9] |= (source[8] >> 28) & 0x3ffffff;
    destination[10]  = (source[8] >> 2) & 0x3ffffff;
    destination[11]  = (source[8] << 24) & 0x3ffffff;
    destination[11] |= (source[9] >> 8) & 0x3ffffff;
    destination[12]  = (source[9] << 18) & 0x3ffffff;
    destination[12] |= (source[10] >> 14) & 0x3ffffff;
    destination[13]  = (source[10] << 12) & 0x3ffffff;
    destination[13] |= (source[11] >> 20) & 0x3ffffff;
    destination[14]  = (source[11] << 6) & 0x3ffffff;
    destination[14] |= (source[12] >> 26) & 0x3ffffff;
    destination[15]  = (source[12] >> 0) & 0x3ffffff;
    destination[16]  = (source[13] >> 6) & 0x3ffffff;
    destination[17]  = (source[13] << 20) & 0x3ffffff;
    destination[17] |= (source[14] >> 12) & 0x3ffffff;
    destination[18]  = (source[14] << 14) & 0x3ffffff;
    destination[18] |= (source[15] >> 18) & 0x3ffffff;
    destination[19]  = (source[15] << 8) & 0x3ffffff;
    destination[19] |= (source[16] >> 24) & 0x3ffffff;
    destination[20]  = (source[16] << 2) & 0x3ffffff;
    destination[20] |= (source[17] >> 30) & 0x3ffffff;
    destination[21]  = (source[17] >> 4) & 0x3ffffff;
    destination[22]  = (source[17] << 22) & 0x3ffffff;
    destination[22] |= (source[18] >> 10) & 0x3ffffff;
    destination[23]  = (source[18] << 16) & 0x3ffffff;
    destination[23] |= (source[19] >> 16) & 0x3ffffff;
    destination[24]  = (source[19] << 10) & 0x3ffffff;
    destination[24] |= (source[20] >> 22) & 0x3ffffff;
    destination[25]  = (source[20] << 4) & 0x3ffffff;
    destination[25] |= (source[21] >> 28) & 0x3ffffff;
    destination[26]  = (source[21] >> 2) & 0x3ffffff;
    destination[27]  = (source[21] << 24) & 0x3ffffff;
    destination[27] |= (source[22] >> 8) & 0x3ffffff;
    destination[28]  = (source[22] << 18) & 0x3ffffff;
    destination[28] |= (source[23] >> 14) & 0x3ffffff;
    destination[29]  = (source[23] << 12) & 0x3ffffff;
    destination[29] |= (source[24] >> 20) & 0x3ffffff;
    destination[30]  = (source[24] << 6) & 0x3ffffff;
    destination[30] |= (source[25] >> 26) & 0x3ffffff;
    destination[31]  = (source[25] >> 0) & 0x3ffffff;
  }
};
template <typename Tp>
struct __struct_bitpack_impl<Tp,4,27>
{
  static const size_t unit_size = 32;
  static const size_t bits_total = 864;
  static const size_t loop_total = 32;
  static const size_t bit_size = 27;
  static const Tp     mask = 0x7ffffff;
  static inline
  void pack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] & 0x7ffffff) << 5;
    destination[0] |= (source[1] & 0x7ffffff) >> 22;
    destination[1]  = (source[1] & 0x7ffffff) << 10;
    destination[1] |= (source[2] & 0x7ffffff) >> 17;
    destination[2]  = (source[2] & 0x7ffffff) << 15;
    destination[2] |= (source[3] & 0x7ffffff) >> 12;
    destination[3]  = (source[3] & 0x7ffffff) << 20;
    destination[3] |= (source[4] & 0x7ffffff) >> 7;
    destination[4]  = (source[4] & 0x7ffffff) << 25;
    destination[4] |= (source[5] & 0x7ffffff) >> 2;
    destination[5]  = (source[5] & 0x7ffffff) << 30;
    destination[5] |= (source[6] & 0x7ffffff) << 3;
    destination[5] |= (source[7] & 0x7ffffff) >> 24;
    destination[6]  = (source[7] & 0x7ffffff) << 8;
    destination[6] |= (source[8] & 0x7ffffff) >> 19;
    destination[7]  = (source[8] & 0x7ffffff) << 13;
    destination[7] |= (source[9] & 0x7ffffff) >> 14;
    destination[8]  = (source[9] & 0x7ffffff) << 18;
    destination[8] |= (source[10] & 0x7ffffff) >> 9;
    destination[9]  = (source[10] & 0x7ffffff) << 23;
    destination[9] |= (source[11] & 0x7ffffff) >> 4;
    destination[10]  = (source[11] & 0x7ffffff) << 28;
    destination[10] |= (source[12] & 0x7ffffff) << 1;
    destination[10] |= (source[13] & 0x7ffffff) >> 26;
    destination[11]  = (source[13] & 0x7ffffff) << 6;
    destination[11] |= (source[14] & 0x7ffffff) >> 21;
    destination[12]  = (source[14] & 0x7ffffff) << 11;
    destination[12] |= (source[15] & 0x7ffffff) >> 16;
    destination[13]  = (source[15] & 0x7ffffff) << 16;
    destination[13] |= (source[16] & 0x7ffffff) >> 11;
    destination[14]  = (source[16] & 0x7ffffff) << 21;
    destination[14] |= (source[17] & 0x7ffffff) >> 6;
    destination[15]  = (source[17] & 0x7ffffff) << 26;
    destination[15] |= (source[18] & 0x7ffffff) >> 1;
    destination[16]  = (source[18] & 0x7ffffff) << 31;
    destination[16] |= (source[19] & 0x7ffffff) << 4;
    destination[16] |= (source[20] & 0x7ffffff) >> 23;
    destination[17]  = (source[20] & 0x7ffffff) << 9;
    destination[17] |= (source[21] & 0x7ffffff) >> 18;
    destination[18]  = (source[21] & 0x7ffffff) << 14;
    destination[18] |= (source[22] & 0x7ffffff) >> 13;
    destination[19]  = (source[22] & 0x7ffffff) << 19;
    destination[19] |= (source[23] & 0x7ffffff) >> 8;
    destination[20]  = (source[23] & 0x7ffffff) << 24;
    destination[20] |= (source[24] & 0x7ffffff) >> 3;
    destination[21]  = (source[24] & 0x7ffffff) << 29;
    destination[21] |= (source[25] & 0x7ffffff) << 2;
    destination[21] |= (source[26] & 0x7ffffff) >> 25;
    destination[22]  = (source[26] & 0x7ffffff) << 7;
    destination[22] |= (source[27] & 0x7ffffff) >> 20;
    destination[23]  = (source[27] & 0x7ffffff) << 12;
    destination[23] |= (source[28] & 0x7ffffff) >> 15;
    destination[24]  = (source[28] & 0x7ffffff) << 17;
    destination[24] |= (source[29] & 0x7ffffff) >> 10;
    destination[25]  = (source[29] & 0x7ffffff) << 22;
    destination[25] |= (source[30] & 0x7ffffff) >> 5;
    destination[26]  = (source[30] & 0x7ffffff) << 27;
    destination[26] |= (source[31] & 0x7ffffff) << 0;
  }
  static inline
  void unpack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] >> 5) & 0x7ffffff;
    destination[1]  = (source[0] << 22) & 0x7ffffff;
    destination[1] |= (source[1] >> 10) & 0x7ffffff;
    destination[2]  = (source[1] << 17) & 0x7ffffff;
    destination[2] |= (source[2] >> 15) & 0x7ffffff;
    destination[3]  = (source[2] << 12) & 0x7ffffff;
    destination[3] |= (source[3] >> 20) & 0x7ffffff;
    destination[4]  = (source[3] << 7) & 0x7ffffff;
    destination[4] |= (source[4] >> 25) & 0x7ffffff;
    destination[5]  = (source[4] << 2) & 0x7ffffff;
    destination[5] |= (source[5] >> 30) & 0x7ffffff;
    destination[6]  = (source[5] >> 3) & 0x7ffffff;
    destination[7]  = (source[5] << 24) & 0x7ffffff;
    destination[7] |= (source[6] >> 8) & 0x7ffffff;
    destination[8]  = (source[6] << 19) & 0x7ffffff;
    destination[8] |= (source[7] >> 13) & 0x7ffffff;
    destination[9]  = (source[7] << 14) & 0x7ffffff;
    destination[9] |= (source[8] >> 18) & 0x7ffffff;
    destination[10]  = (source[8] << 9) & 0x7ffffff;
    destination[10] |= (source[9] >> 23) & 0x7ffffff;
    destination[11]  = (source[9] << 4) & 0x7ffffff;
    destination[11] |= (source[10] >> 28) & 0x7ffffff;
    destination[12]  = (source[10] >> 1) & 0x7ffffff;
    destination[13]  = (source[10] << 26) & 0x7ffffff;
    destination[13] |= (source[11] >> 6) & 0x7ffffff;
    destination[14]  = (source[11] << 21) & 0x7ffffff;
    destination[14] |= (source[12] >> 11) & 0x7ffffff;
    destination[15]  = (source[12] << 16) & 0x7ffffff;
    destination[15] |= (source[13] >> 16) & 0x7ffffff;
    destination[16]  = (source[13] << 11) & 0x7ffffff;
    destination[16] |= (source[14] >> 21) & 0x7ffffff;
    destination[17]  = (source[14] << 6) & 0x7ffffff;
    destination[17] |= (source[15] >> 26) & 0x7ffffff;
    destination[18]  = (source[15] << 1) & 0x7ffffff;
    destination[18] |= (source[16] >> 31) & 0x7ffffff;
    destination[19]  = (source[16] >> 4) & 0x7ffffff;
    destination[20]  = (source[16] << 23) & 0x7ffffff;
    destination[20] |= (source[17] >> 9) & 0x7ffffff;
    destination[21]  = (source[17] << 18) & 0x7ffffff;
    destination[21] |= (source[18] >> 14) & 0x7ffffff;
    destination[22]  = (source[18] << 13) & 0x7ffffff;
    destination[22] |= (source[19] >> 19) & 0x7ffffff;
    destination[23]  = (source[19] << 8) & 0x7ffffff;
    destination[23] |= (source[20] >> 24) & 0x7ffffff;
    destination[24]  = (source[20] << 3) & 0x7ffffff;
    destination[24] |= (source[21] >> 29) & 0x7ffffff;
    destination[25]  = (source[21] >> 2) & 0x7ffffff;
    destination[26]  = (source[21] << 25) & 0x7ffffff;
    destination[26] |= (source[22] >> 7) & 0x7ffffff;
    destination[27]  = (source[22] << 20) & 0x7ffffff;
    destination[27] |= (source[23] >> 12) & 0x7ffffff;
    destination[28]  = (source[23] << 15) & 0x7ffffff;
    destination[28] |= (source[24] >> 17) & 0x7ffffff;
    destination[29]  = (source[24] << 10) & 0x7ffffff;
    destination[29] |= (source[25] >> 22) & 0x7ffffff;
    destination[30]  = (source[25] << 5) & 0x7ffffff;
    destination[30] |= (source[26] >> 27) & 0x7ffffff;
    destination[31]  = (source[26] >> 0) & 0x7ffffff;
  }
};
template <typename Tp>
struct __struct_bitpack_impl<Tp,4,28>
{
  static const size_t unit_size = 32;
  static const size_t bits_total = 896;
  static const size_t loop_total = 32;
  static const size_t bit_size = 28;
  static const Tp     mask = 0xfffffff;
  static inline
  void pack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] & 0xfffffff) << 4;
    destination[0] |= (source[1] & 0xfffffff) >> 24;
    destination[1]  = (source[1] & 0xfffffff) << 8;
    destination[1] |= (source[2] & 0xfffffff) >> 20;
    destination[2]  = (source[2] & 0xfffffff) << 12;
    destination[2] |= (source[3] & 0xfffffff) >> 16;
    destination[3]  = (source[3] & 0xfffffff) << 16;
    destination[3] |= (source[4] & 0xfffffff) >> 12;
    destination[4]  = (source[4] & 0xfffffff) << 20;
    destination[4] |= (source[5] & 0xfffffff) >> 8;
    destination[5]  = (source[5] & 0xfffffff) << 24;
    destination[5] |= (source[6] & 0xfffffff) >> 4;
    destination[6]  = (source[6] & 0xfffffff) << 28;
    destination[6] |= (source[7] & 0xfffffff) << 0;
    destination[7]  = (source[8] & 0xfffffff) << 4;
    destination[7] |= (source[9] & 0xfffffff) >> 24;
    destination[8]  = (source[9] & 0xfffffff) << 8;
    destination[8] |= (source[10] & 0xfffffff) >> 20;
    destination[9]  = (source[10] & 0xfffffff) << 12;
    destination[9] |= (source[11] & 0xfffffff) >> 16;
    destination[10]  = (source[11] & 0xfffffff) << 16;
    destination[10] |= (source[12] & 0xfffffff) >> 12;
    destination[11]  = (source[12] & 0xfffffff) << 20;
    destination[11] |= (source[13] & 0xfffffff) >> 8;
    destination[12]  = (source[13] & 0xfffffff) << 24;
    destination[12] |= (source[14] & 0xfffffff) >> 4;
    destination[13]  = (source[14] & 0xfffffff) << 28;
    destination[13] |= (source[15] & 0xfffffff) << 0;
    destination[14]  = (source[16] & 0xfffffff) << 4;
    destination[14] |= (source[17] & 0xfffffff) >> 24;
    destination[15]  = (source[17] & 0xfffffff) << 8;
    destination[15] |= (source[18] & 0xfffffff) >> 20;
    destination[16]  = (source[18] & 0xfffffff) << 12;
    destination[16] |= (source[19] & 0xfffffff) >> 16;
    destination[17]  = (source[19] & 0xfffffff) << 16;
    destination[17] |= (source[20] & 0xfffffff) >> 12;
    destination[18]  = (source[20] & 0xfffffff) << 20;
    destination[18] |= (source[21] & 0xfffffff) >> 8;
    destination[19]  = (source[21] & 0xfffffff) << 24;
    destination[19] |= (source[22] & 0xfffffff) >> 4;
    destination[20]  = (source[22] & 0xfffffff) << 28;
    destination[20] |= (source[23] & 0xfffffff) << 0;
    destination[21]  = (source[24] & 0xfffffff) << 4;
    destination[21] |= (source[25] & 0xfffffff) >> 24;
    destination[22]  = (source[25] & 0xfffffff) << 8;
    destination[22] |= (source[26] & 0xfffffff) >> 20;
    destination[23]  = (source[26] & 0xfffffff) << 12;
    destination[23] |= (source[27] & 0xfffffff) >> 16;
    destination[24]  = (source[27] & 0xfffffff) << 16;
    destination[24] |= (source[28] & 0xfffffff) >> 12;
    destination[25]  = (source[28] & 0xfffffff) << 20;
    destination[25] |= (source[29] & 0xfffffff) >> 8;
    destination[26]  = (source[29] & 0xfffffff) << 24;
    destination[26] |= (source[30] & 0xfffffff) >> 4;
    destination[27]  = (source[30] & 0xfffffff) << 28;
    destination[27] |= (source[31] & 0xfffffff) << 0;
  }
  static inline
  void unpack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] >> 4) & 0xfffffff;
    destination[1]  = (source[0] << 24) & 0xfffffff;
    destination[1] |= (source[1] >> 8) & 0xfffffff;
    destination[2]  = (source[1] << 20) & 0xfffffff;
    destination[2] |= (source[2] >> 12) & 0xfffffff;
    destination[3]  = (source[2] << 16) & 0xfffffff;
    destination[3] |= (source[3] >> 16) & 0xfffffff;
    destination[4]  = (source[3] << 12) & 0xfffffff;
    destination[4] |= (source[4] >> 20) & 0xfffffff;
    destination[5]  = (source[4] << 8) & 0xfffffff;
    destination[5] |= (source[5] >> 24) & 0xfffffff;
    destination[6]  = (source[5] << 4) & 0xfffffff;
    destination[6] |= (source[6] >> 28) & 0xfffffff;
    destination[7]  = (source[6] >> 0) & 0xfffffff;
    destination[8]  = (source[7] >> 4) & 0xfffffff;
    destination[9]  = (source[7] << 24) & 0xfffffff;
    destination[9] |= (source[8] >> 8) & 0xfffffff;
    destination[10]  = (source[8] << 20) & 0xfffffff;
    destination[10] |= (source[9] >> 12) & 0xfffffff;
    destination[11]  = (source[9] << 16) & 0xfffffff;
    destination[11] |= (source[10] >> 16) & 0xfffffff;
    destination[12]  = (source[10] << 12) & 0xfffffff;
    destination[12] |= (source[11] >> 20) & 0xfffffff;
    destination[13]  = (source[11] << 8) & 0xfffffff;
    destination[13] |= (source[12] >> 24) & 0xfffffff;
    destination[14]  = (source[12] << 4) & 0xfffffff;
    destination[14] |= (source[13] >> 28) & 0xfffffff;
    destination[15]  = (source[13] >> 0) & 0xfffffff;
    destination[16]  = (source[14] >> 4) & 0xfffffff;
    destination[17]  = (source[14] << 24) & 0xfffffff;
    destination[17] |= (source[15] >> 8) & 0xfffffff;
    destination[18]  = (source[15] << 20) & 0xfffffff;
    destination[18] |= (source[16] >> 12) & 0xfffffff;
    destination[19]  = (source[16] << 16) & 0xfffffff;
    destination[19] |= (source[17] >> 16) & 0xfffffff;
    destination[20]  = (source[17] << 12) & 0xfffffff;
    destination[20] |= (source[18] >> 20) & 0xfffffff;
    destination[21]  = (source[18] << 8) & 0xfffffff;
    destination[21] |= (source[19] >> 24) & 0xfffffff;
    destination[22]  = (source[19] << 4) & 0xfffffff;
    destination[22] |= (source[20] >> 28) & 0xfffffff;
    destination[23]  = (source[20] >> 0) & 0xfffffff;
    destination[24]  = (source[21] >> 4) & 0xfffffff;
    destination[25]  = (source[21] << 24) & 0xfffffff;
    destination[25] |= (source[22] >> 8) & 0xfffffff;
    destination[26]  = (source[22] << 20) & 0xfffffff;
    destination[26] |= (source[23] >> 12) & 0xfffffff;
    destination[27]  = (source[23] << 16) & 0xfffffff;
    destination[27] |= (source[24] >> 16) & 0xfffffff;
    destination[28]  = (source[24] << 12) & 0xfffffff;
    destination[28] |= (source[25] >> 20) & 0xfffffff;
    destination[29]  = (source[25] << 8) & 0xfffffff;
    destination[29] |= (source[26] >> 24) & 0xfffffff;
    destination[30]  = (source[26] << 4) & 0xfffffff;
    destination[30] |= (source[27] >> 28) & 0xfffffff;
    destination[31]  = (source[27] >> 0) & 0xfffffff;
  }
};
template <typename Tp>
struct __struct_bitpack_impl<Tp,4,29>
{
  static const size_t unit_size = 32;
  static const size_t bits_total = 928;
  static const size_t loop_total = 32;
  static const size_t bit_size = 29;
  static const Tp     mask = 0x1fffffff;
  static inline
  void pack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] & 0x1fffffff) << 3;
    destination[0] |= (source[1] & 0x1fffffff) >> 26;
    destination[1]  = (source[1] & 0x1fffffff) << 6;
    destination[1] |= (source[2] & 0x1fffffff) >> 23;
    destination[2]  = (source[2] & 0x1fffffff) << 9;
    destination[2] |= (source[3] & 0x1fffffff) >> 20;
    destination[3]  = (source[3] & 0x1fffffff) << 12;
    destination[3] |= (source[4] & 0x1fffffff) >> 17;
    destination[4]  = (source[4] & 0x1fffffff) << 15;
    destination[4] |= (source[5] & 0x1fffffff) >> 14;
    destination[5]  = (source[5] & 0x1fffffff) << 18;
    destination[5] |= (source[6] & 0x1fffffff) >> 11;
    destination[6]  = (source[6] & 0x1fffffff) << 21;
    destination[6] |= (source[7] & 0x1fffffff) >> 8;
    destination[7]  = (source[7] & 0x1fffffff) << 24;
    destination[7] |= (source[8] & 0x1fffffff) >> 5;
    destination[8]  = (source[8] & 0x1fffffff) << 27;
    destination[8] |= (source[9] & 0x1fffffff) >> 2;
    destination[9]  = (source[9] & 0x1fffffff) << 30;
    destination[9] |= (source[10] & 0x1fffffff) << 1;
    destination[9] |= (source[11] & 0x1fffffff) >> 28;
    destination[10]  = (source[11] & 0x1fffffff) << 4;
    destination[10] |= (source[12] & 0x1fffffff) >> 25;
    destination[11]  = (source[12] & 0x1fffffff) << 7;
    destination[11] |= (source[13] & 0x1fffffff) >> 22;
    destination[12]  = (source[13] & 0x1fffffff) << 10;
    destination[12] |= (source[14] & 0x1fffffff) >> 19;
    destination[13]  = (source[14] & 0x1fffffff) << 13;
    destination[13] |= (source[15] & 0x1fffffff) >> 16;
    destination[14]  = (source[15] & 0x1fffffff) << 16;
    destination[14] |= (source[16] & 0x1fffffff) >> 13;
    destination[15]  = (source[16] & 0x1fffffff) << 19;
    destination[15] |= (source[17] & 0x1fffffff) >> 10;
    destination[16]  = (source[17] & 0x1fffffff) << 22;
    destination[16] |= (source[18] & 0x1fffffff) >> 7;
    destination[17]  = (source[18] & 0x1fffffff) << 25;
    destination[17] |= (source[19] & 0x1fffffff) >> 4;
    destination[18]  = (source[19] & 0x1fffffff) << 28;
    destination[18] |= (source[20] & 0x1fffffff) >> 1;
    destination[19]  = (source[20] & 0x1fffffff) << 31;
    destination[19] |= (source[21] & 0x1fffffff) << 2;
    destination[19] |= (source[22] & 0x1fffffff) >> 27;
    destination[20]  = (source[22] & 0x1fffffff) << 5;
    destination[20] |= (source[23] & 0x1fffffff) >> 24;
    destination[21]  = (source[23] & 0x1fffffff) << 8;
    destination[21] |= (source[24] & 0x1fffffff) >> 21;
    destination[22]  = (source[24] & 0x1fffffff) << 11;
    destination[22] |= (source[25] & 0x1fffffff) >> 18;
    destination[23]  = (source[25] & 0x1fffffff) << 14;
    destination[23] |= (source[26] & 0x1fffffff) >> 15;
    destination[24]  = (source[26] & 0x1fffffff) << 17;
    destination[24] |= (source[27] & 0x1fffffff) >> 12;
    destination[25]  = (source[27] & 0x1fffffff) << 20;
    destination[25] |= (source[28] & 0x1fffffff) >> 9;
    destination[26]  = (source[28] & 0x1fffffff) << 23;
    destination[26] |= (source[29] & 0x1fffffff) >> 6;
    destination[27]  = (source[29] & 0x1fffffff) << 26;
    destination[27] |= (source[30] & 0x1fffffff) >> 3;
    destination[28]  = (source[30] & 0x1fffffff) << 29;
    destination[28] |= (source[31] & 0x1fffffff) << 0;
  }
  static inline
  void unpack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] >> 3) & 0x1fffffff;
    destination[1]  = (source[0] << 26) & 0x1fffffff;
    destination[1] |= (source[1] >> 6) & 0x1fffffff;
    destination[2]  = (source[1] << 23) & 0x1fffffff;
    destination[2] |= (source[2] >> 9) & 0x1fffffff;
    destination[3]  = (source[2] << 20) & 0x1fffffff;
    destination[3] |= (source[3] >> 12) & 0x1fffffff;
    destination[4]  = (source[3] << 17) & 0x1fffffff;
    destination[4] |= (source[4] >> 15) & 0x1fffffff;
    destination[5]  = (source[4] << 14) & 0x1fffffff;
    destination[5] |= (source[5] >> 18) & 0x1fffffff;
    destination[6]  = (source[5] << 11) & 0x1fffffff;
    destination[6] |= (source[6] >> 21) & 0x1fffffff;
    destination[7]  = (source[6] << 8) & 0x1fffffff;
    destination[7] |= (source[7] >> 24) & 0x1fffffff;
    destination[8]  = (source[7] << 5) & 0x1fffffff;
    destination[8] |= (source[8] >> 27) & 0x1fffffff;
    destination[9]  = (source[8] << 2) & 0x1fffffff;
    destination[9] |= (source[9] >> 30) & 0x1fffffff;
    destination[10]  = (source[9] >> 1) & 0x1fffffff;
    destination[11]  = (source[9] << 28) & 0x1fffffff;
    destination[11] |= (source[10] >> 4) & 0x1fffffff;
    destination[12]  = (source[10] << 25) & 0x1fffffff;
    destination[12] |= (source[11] >> 7) & 0x1fffffff;
    destination[13]  = (source[11] << 22) & 0x1fffffff;
    destination[13] |= (source[12] >> 10) & 0x1fffffff;
    destination[14]  = (source[12] << 19) & 0x1fffffff;
    destination[14] |= (source[13] >> 13) & 0x1fffffff;
    destination[15]  = (source[13] << 16) & 0x1fffffff;
    destination[15] |= (source[14] >> 16) & 0x1fffffff;
    destination[16]  = (source[14] << 13) & 0x1fffffff;
    destination[16] |= (source[15] >> 19) & 0x1fffffff;
    destination[17]  = (source[15] << 10) & 0x1fffffff;
    destination[17] |= (source[16] >> 22) & 0x1fffffff;
    destination[18]  = (source[16] << 7) & 0x1fffffff;
    destination[18] |= (source[17] >> 25) & 0x1fffffff;
    destination[19]  = (source[17] << 4) & 0x1fffffff;
    destination[19] |= (source[18] >> 28) & 0x1fffffff;
    destination[20]  = (source[18] << 1) & 0x1fffffff;
    destination[20] |= (source[19] >> 31) & 0x1fffffff;
    destination[21]  = (source[19] >> 2) & 0x1fffffff;
    destination[22]  = (source[19] << 27) & 0x1fffffff;
    destination[22] |= (source[20] >> 5) & 0x1fffffff;
    destination[23]  = (source[20] << 24) & 0x1fffffff;
    destination[23] |= (source[21] >> 8) & 0x1fffffff;
    destination[24]  = (source[21] << 21) & 0x1fffffff;
    destination[24] |= (source[22] >> 11) & 0x1fffffff;
    destination[25]  = (source[22] << 18) & 0x1fffffff;
    destination[25] |= (source[23] >> 14) & 0x1fffffff;
    destination[26]  = (source[23] << 15) & 0x1fffffff;
    destination[26] |= (source[24] >> 17) & 0x1fffffff;
    destination[27]  = (source[24] << 12) & 0x1fffffff;
    destination[27] |= (source[25] >> 20) & 0x1fffffff;
    destination[28]  = (source[25] << 9) & 0x1fffffff;
    destination[28] |= (source[26] >> 23) & 0x1fffffff;
    destination[29]  = (source[26] << 6) & 0x1fffffff;
    destination[29] |= (source[27] >> 26) & 0x1fffffff;
    destination[30]  = (source[27] << 3) & 0x1fffffff;
    destination[30] |= (source[28] >> 29) & 0x1fffffff;
    destination[31]  = (source[28] >> 0) & 0x1fffffff;
  }
};
template <typename Tp>
struct __struct_bitpack_impl<Tp,4,30>
{
  static const size_t unit_size = 32;
  static const size_t bits_total = 960;
  static const size_t loop_total = 32;
  static const size_t bit_size = 30;
  static const Tp     mask = 0x3fffffff;
  static inline
  void pack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] & 0x3fffffff) << 2;
    destination[0] |= (source[1] & 0x3fffffff) >> 28;
    destination[1]  = (source[1] & 0x3fffffff) << 4;
    destination[1] |= (source[2] & 0x3fffffff) >> 26;
    destination[2]  = (source[2] & 0x3fffffff) << 6;
    destination[2] |= (source[3] & 0x3fffffff) >> 24;
    destination[3]  = (source[3] & 0x3fffffff) << 8;
    destination[3] |= (source[4] & 0x3fffffff) >> 22;
    destination[4]  = (source[4] & 0x3fffffff) << 10;
    destination[4] |= (source[5] & 0x3fffffff) >> 20;
    destination[5]  = (source[5] & 0x3fffffff) << 12;
    destination[5] |= (source[6] & 0x3fffffff) >> 18;
    destination[6]  = (source[6] & 0x3fffffff) << 14;
    destination[6] |= (source[7] & 0x3fffffff) >> 16;
    destination[7]  = (source[7] & 0x3fffffff) << 16;
    destination[7] |= (source[8] & 0x3fffffff) >> 14;
    destination[8]  = (source[8] & 0x3fffffff) << 18;
    destination[8] |= (source[9] & 0x3fffffff) >> 12;
    destination[9]  = (source[9] & 0x3fffffff) << 20;
    destination[9] |= (source[10] & 0x3fffffff) >> 10;
    destination[10]  = (source[10] & 0x3fffffff) << 22;
    destination[10] |= (source[11] & 0x3fffffff) >> 8;
    destination[11]  = (source[11] & 0x3fffffff) << 24;
    destination[11] |= (source[12] & 0x3fffffff) >> 6;
    destination[12]  = (source[12] & 0x3fffffff) << 26;
    destination[12] |= (source[13] & 0x3fffffff) >> 4;
    destination[13]  = (source[13] & 0x3fffffff) << 28;
    destination[13] |= (source[14] & 0x3fffffff) >> 2;
    destination[14]  = (source[14] & 0x3fffffff) << 30;
    destination[14] |= (source[15] & 0x3fffffff) << 0;
    destination[15]  = (source[16] & 0x3fffffff) << 2;
    destination[15] |= (source[17] & 0x3fffffff) >> 28;
    destination[16]  = (source[17] & 0x3fffffff) << 4;
    destination[16] |= (source[18] & 0x3fffffff) >> 26;
    destination[17]  = (source[18] & 0x3fffffff) << 6;
    destination[17] |= (source[19] & 0x3fffffff) >> 24;
    destination[18]  = (source[19] & 0x3fffffff) << 8;
    destination[18] |= (source[20] & 0x3fffffff) >> 22;
    destination[19]  = (source[20] & 0x3fffffff) << 10;
    destination[19] |= (source[21] & 0x3fffffff) >> 20;
    destination[20]  = (source[21] & 0x3fffffff) << 12;
    destination[20] |= (source[22] & 0x3fffffff) >> 18;
    destination[21]  = (source[22] & 0x3fffffff) << 14;
    destination[21] |= (source[23] & 0x3fffffff) >> 16;
    destination[22]  = (source[23] & 0x3fffffff) << 16;
    destination[22] |= (source[24] & 0x3fffffff) >> 14;
    destination[23]  = (source[24] & 0x3fffffff) << 18;
    destination[23] |= (source[25] & 0x3fffffff) >> 12;
    destination[24]  = (source[25] & 0x3fffffff) << 20;
    destination[24] |= (source[26] & 0x3fffffff) >> 10;
    destination[25]  = (source[26] & 0x3fffffff) << 22;
    destination[25] |= (source[27] & 0x3fffffff) >> 8;
    destination[26]  = (source[27] & 0x3fffffff) << 24;
    destination[26] |= (source[28] & 0x3fffffff) >> 6;
    destination[27]  = (source[28] & 0x3fffffff) << 26;
    destination[27] |= (source[29] & 0x3fffffff) >> 4;
    destination[28]  = (source[29] & 0x3fffffff) << 28;
    destination[28] |= (source[30] & 0x3fffffff) >> 2;
    destination[29]  = (source[30] & 0x3fffffff) << 30;
    destination[29] |= (source[31] & 0x3fffffff) << 0;
  }
  static inline
  void unpack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] >> 2) & 0x3fffffff;
    destination[1]  = (source[0] << 28) & 0x3fffffff;
    destination[1] |= (source[1] >> 4) & 0x3fffffff;
    destination[2]  = (source[1] << 26) & 0x3fffffff;
    destination[2] |= (source[2] >> 6) & 0x3fffffff;
    destination[3]  = (source[2] << 24) & 0x3fffffff;
    destination[3] |= (source[3] >> 8) & 0x3fffffff;
    destination[4]  = (source[3] << 22) & 0x3fffffff;
    destination[4] |= (source[4] >> 10) & 0x3fffffff;
    destination[5]  = (source[4] << 20) & 0x3fffffff;
    destination[5] |= (source[5] >> 12) & 0x3fffffff;
    destination[6]  = (source[5] << 18) & 0x3fffffff;
    destination[6] |= (source[6] >> 14) & 0x3fffffff;
    destination[7]  = (source[6] << 16) & 0x3fffffff;
    destination[7] |= (source[7] >> 16) & 0x3fffffff;
    destination[8]  = (source[7] << 14) & 0x3fffffff;
    destination[8] |= (source[8] >> 18) & 0x3fffffff;
    destination[9]  = (source[8] << 12) & 0x3fffffff;
    destination[9] |= (source[9] >> 20) & 0x3fffffff;
    destination[10]  = (source[9] << 10) & 0x3fffffff;
    destination[10] |= (source[10] >> 22) & 0x3fffffff;
    destination[11]  = (source[10] << 8) & 0x3fffffff;
    destination[11] |= (source[11] >> 24) & 0x3fffffff;
    destination[12]  = (source[11] << 6) & 0x3fffffff;
    destination[12] |= (source[12] >> 26) & 0x3fffffff;
    destination[13]  = (source[12] << 4) & 0x3fffffff;
    destination[13] |= (source[13] >> 28) & 0x3fffffff;
    destination[14]  = (source[13] << 2) & 0x3fffffff;
    destination[14] |= (source[14] >> 30) & 0x3fffffff;
    destination[15]  = (source[14] >> 0) & 0x3fffffff;
    destination[16]  = (source[15] >> 2) & 0x3fffffff;
    destination[17]  = (source[15] << 28) & 0x3fffffff;
    destination[17] |= (source[16] >> 4) & 0x3fffffff;
    destination[18]  = (source[16] << 26) & 0x3fffffff;
    destination[18] |= (source[17] >> 6) & 0x3fffffff;
    destination[19]  = (source[17] << 24) & 0x3fffffff;
    destination[19] |= (source[18] >> 8) & 0x3fffffff;
    destination[20]  = (source[18] << 22) & 0x3fffffff;
    destination[20] |= (source[19] >> 10) & 0x3fffffff;
    destination[21]  = (source[19] << 20) & 0x3fffffff;
    destination[21] |= (source[20] >> 12) & 0x3fffffff;
    destination[22]  = (source[20] << 18) & 0x3fffffff;
    destination[22] |= (source[21] >> 14) & 0x3fffffff;
    destination[23]  = (source[21] << 16) & 0x3fffffff;
    destination[23] |= (source[22] >> 16) & 0x3fffffff;
    destination[24]  = (source[22] << 14) & 0x3fffffff;
    destination[24] |= (source[23] >> 18) & 0x3fffffff;
    destination[25]  = (source[23] << 12) & 0x3fffffff;
    destination[25] |= (source[24] >> 20) & 0x3fffffff;
    destination[26]  = (source[24] << 10) & 0x3fffffff;
    destination[26] |= (source[25] >> 22) & 0x3fffffff;
    destination[27]  = (source[25] << 8) & 0x3fffffff;
    destination[27] |= (source[26] >> 24) & 0x3fffffff;
    destination[28]  = (source[26] << 6) & 0x3fffffff;
    destination[28] |= (source[27] >> 26) & 0x3fffffff;
    destination[29]  = (source[27] << 4) & 0x3fffffff;
    destination[29] |= (source[28] >> 28) & 0x3fffffff;
    destination[30]  = (source[28] << 2) & 0x3fffffff;
    destination[30] |= (source[29] >> 30) & 0x3fffffff;
    destination[31]  = (source[29] >> 0) & 0x3fffffff;
  }
};
template <typename Tp>
struct __struct_bitpack_impl<Tp,4,31>
{
  static const size_t unit_size = 32;
  static const size_t bits_total = 992;
  static const size_t loop_total = 32;
  static const size_t bit_size = 31;
  static const Tp     mask = 0x7fffffff;
  static inline
  void pack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] & 0x7fffffff) << 1;
    destination[0] |= (source[1] & 0x7fffffff) >> 30;
    destination[1]  = (source[1] & 0x7fffffff) << 2;
    destination[1] |= (source[2] & 0x7fffffff) >> 29;
    destination[2]  = (source[2] & 0x7fffffff) << 3;
    destination[2] |= (source[3] & 0x7fffffff) >> 28;
    destination[3]  = (source[3] & 0x7fffffff) << 4;
    destination[3] |= (source[4] & 0x7fffffff) >> 27;
    destination[4]  = (source[4] & 0x7fffffff) << 5;
    destination[4] |= (source[5] & 0x7fffffff) >> 26;
    destination[5]  = (source[5] & 0x7fffffff) << 6;
    destination[5] |= (source[6] & 0x7fffffff) >> 25;
    destination[6]  = (source[6] & 0x7fffffff) << 7;
    destination[6] |= (source[7] & 0x7fffffff) >> 24;
    destination[7]  = (source[7] & 0x7fffffff) << 8;
    destination[7] |= (source[8] & 0x7fffffff) >> 23;
    destination[8]  = (source[8] & 0x7fffffff) << 9;
    destination[8] |= (source[9] & 0x7fffffff) >> 22;
    destination[9]  = (source[9] & 0x7fffffff) << 10;
    destination[9] |= (source[10] & 0x7fffffff) >> 21;
    destination[10]  = (source[10] & 0x7fffffff) << 11;
    destination[10] |= (source[11] & 0x7fffffff) >> 20;
    destination[11]  = (source[11] & 0x7fffffff) << 12;
    destination[11] |= (source[12] & 0x7fffffff) >> 19;
    destination[12]  = (source[12] & 0x7fffffff) << 13;
    destination[12] |= (source[13] & 0x7fffffff) >> 18;
    destination[13]  = (source[13] & 0x7fffffff) << 14;
    destination[13] |= (source[14] & 0x7fffffff) >> 17;
    destination[14]  = (source[14] & 0x7fffffff) << 15;
    destination[14] |= (source[15] & 0x7fffffff) >> 16;
    destination[15]  = (source[15] & 0x7fffffff) << 16;
    destination[15] |= (source[16] & 0x7fffffff) >> 15;
    destination[16]  = (source[16] & 0x7fffffff) << 17;
    destination[16] |= (source[17] & 0x7fffffff) >> 14;
    destination[17]  = (source[17] & 0x7fffffff) << 18;
    destination[17] |= (source[18] & 0x7fffffff) >> 13;
    destination[18]  = (source[18] & 0x7fffffff) << 19;
    destination[18] |= (source[19] & 0x7fffffff) >> 12;
    destination[19]  = (source[19] & 0x7fffffff) << 20;
    destination[19] |= (source[20] & 0x7fffffff) >> 11;
    destination[20]  = (source[20] & 0x7fffffff) << 21;
    destination[20] |= (source[21] & 0x7fffffff) >> 10;
    destination[21]  = (source[21] & 0x7fffffff) << 22;
    destination[21] |= (source[22] & 0x7fffffff) >> 9;
    destination[22]  = (source[22] & 0x7fffffff) << 23;
    destination[22] |= (source[23] & 0x7fffffff) >> 8;
    destination[23]  = (source[23] & 0x7fffffff) << 24;
    destination[23] |= (source[24] & 0x7fffffff) >> 7;
    destination[24]  = (source[24] & 0x7fffffff) << 25;
    destination[24] |= (source[25] & 0x7fffffff) >> 6;
    destination[25]  = (source[25] & 0x7fffffff) << 26;
    destination[25] |= (source[26] & 0x7fffffff) >> 5;
    destination[26]  = (source[26] & 0x7fffffff) << 27;
    destination[26] |= (source[27] & 0x7fffffff) >> 4;
    destination[27]  = (source[27] & 0x7fffffff) << 28;
    destination[27] |= (source[28] & 0x7fffffff) >> 3;
    destination[28]  = (source[28] & 0x7fffffff) << 29;
    destination[28] |= (source[29] & 0x7fffffff) >> 2;
    destination[29]  = (source[29] & 0x7fffffff) << 30;
    destination[29] |= (source[30] & 0x7fffffff) >> 1;
    destination[30]  = (source[30] & 0x7fffffff) << 31;
    destination[30] |= (source[31] & 0x7fffffff) << 0;
  }
  static inline
  void unpack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] >> 1) & 0x7fffffff;
    destination[1]  = (source[0] << 30) & 0x7fffffff;
    destination[1] |= (source[1] >> 2) & 0x7fffffff;
    destination[2]  = (source[1] << 29) & 0x7fffffff;
    destination[2] |= (source[2] >> 3) & 0x7fffffff;
    destination[3]  = (source[2] << 28) & 0x7fffffff;
    destination[3] |= (source[3] >> 4) & 0x7fffffff;
    destination[4]  = (source[3] << 27) & 0x7fffffff;
    destination[4] |= (source[4] >> 5) & 0x7fffffff;
    destination[5]  = (source[4] << 26) & 0x7fffffff;
    destination[5] |= (source[5] >> 6) & 0x7fffffff;
    destination[6]  = (source[5] << 25) & 0x7fffffff;
    destination[6] |= (source[6] >> 7) & 0x7fffffff;
    destination[7]  = (source[6] << 24) & 0x7fffffff;
    destination[7] |= (source[7] >> 8) & 0x7fffffff;
    destination[8]  = (source[7] << 23) & 0x7fffffff;
    destination[8] |= (source[8] >> 9) & 0x7fffffff;
    destination[9]  = (source[8] << 22) & 0x7fffffff;
    destination[9] |= (source[9] >> 10) & 0x7fffffff;
    destination[10]  = (source[9] << 21) & 0x7fffffff;
    destination[10] |= (source[10] >> 11) & 0x7fffffff;
    destination[11]  = (source[10] << 20) & 0x7fffffff;
    destination[11] |= (source[11] >> 12) & 0x7fffffff;
    destination[12]  = (source[11] << 19) & 0x7fffffff;
    destination[12] |= (source[12] >> 13) & 0x7fffffff;
    destination[13]  = (source[12] << 18) & 0x7fffffff;
    destination[13] |= (source[13] >> 14) & 0x7fffffff;
    destination[14]  = (source[13] << 17) & 0x7fffffff;
    destination[14] |= (source[14] >> 15) & 0x7fffffff;
    destination[15]  = (source[14] << 16) & 0x7fffffff;
    destination[15] |= (source[15] >> 16) & 0x7fffffff;
    destination[16]  = (source[15] << 15) & 0x7fffffff;
    destination[16] |= (source[16] >> 17) & 0x7fffffff;
    destination[17]  = (source[16] << 14) & 0x7fffffff;
    destination[17] |= (source[17] >> 18) & 0x7fffffff;
    destination[18]  = (source[17] << 13) & 0x7fffffff;
    destination[18] |= (source[18] >> 19) & 0x7fffffff;
    destination[19]  = (source[18] << 12) & 0x7fffffff;
    destination[19] |= (source[19] >> 20) & 0x7fffffff;
    destination[20]  = (source[19] << 11) & 0x7fffffff;
    destination[20] |= (source[20] >> 21) & 0x7fffffff;
    destination[21]  = (source[20] << 10) & 0x7fffffff;
    destination[21] |= (source[21] >> 22) & 0x7fffffff;
    destination[22]  = (source[21] << 9) & 0x7fffffff;
    destination[22] |= (source[22] >> 23) & 0x7fffffff;
    destination[23]  = (source[22] << 8) & 0x7fffffff;
    destination[23] |= (source[23] >> 24) & 0x7fffffff;
    destination[24]  = (source[23] << 7) & 0x7fffffff;
    destination[24] |= (source[24] >> 25) & 0x7fffffff;
    destination[25]  = (source[24] << 6) & 0x7fffffff;
    destination[25] |= (source[25] >> 26) & 0x7fffffff;
    destination[26]  = (source[25] << 5) & 0x7fffffff;
    destination[26] |= (source[26] >> 27) & 0x7fffffff;
    destination[27]  = (source[26] << 4) & 0x7fffffff;
    destination[27] |= (source[27] >> 28) & 0x7fffffff;
    destination[28]  = (source[27] << 3) & 0x7fffffff;
    destination[28] |= (source[28] >> 29) & 0x7fffffff;
    destination[29]  = (source[28] << 2) & 0x7fffffff;
    destination[29] |= (source[29] >> 30) & 0x7fffffff;
    destination[30]  = (source[29] << 1) & 0x7fffffff;
    destination[30] |= (source[30] >> 31) & 0x7fffffff;
    destination[31]  = (source[30] >> 0) & 0x7fffffff;
  }
};
};
};
#endif
