#ifndef __UTILS__BITPACK16_IMPL__HPP__
#define __UTILS__BITPACK16_IMPL__HPP__ 1
namespace utils {
namespace bitpack {
template <typename Tp>
struct __struct_bitpack_impl<Tp,2,1>
{
  static const size_t unit_size = 16;
  static const size_t bits_total = 16;
  static const size_t loop_total = 16;
  static const size_t bit_size = 1;
  static const Tp     mask = 0x01;
  static inline
  void pack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] & 0x01) << 15;
    destination[0] |= (source[1] & 0x01) << 14;
    destination[0] |= (source[2] & 0x01) << 13;
    destination[0] |= (source[3] & 0x01) << 12;
    destination[0] |= (source[4] & 0x01) << 11;
    destination[0] |= (source[5] & 0x01) << 10;
    destination[0] |= (source[6] & 0x01) << 9;
    destination[0] |= (source[7] & 0x01) << 8;
    destination[0] |= (source[8] & 0x01) << 7;
    destination[0] |= (source[9] & 0x01) << 6;
    destination[0] |= (source[10] & 0x01) << 5;
    destination[0] |= (source[11] & 0x01) << 4;
    destination[0] |= (source[12] & 0x01) << 3;
    destination[0] |= (source[13] & 0x01) << 2;
    destination[0] |= (source[14] & 0x01) << 1;
    destination[0] |= (source[15] & 0x01) << 0;
  }
  static inline
  void unpack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] >> 15) & 0x01;
    destination[1]  = (source[0] >> 14) & 0x01;
    destination[2]  = (source[0] >> 13) & 0x01;
    destination[3]  = (source[0] >> 12) & 0x01;
    destination[4]  = (source[0] >> 11) & 0x01;
    destination[5]  = (source[0] >> 10) & 0x01;
    destination[6]  = (source[0] >> 9) & 0x01;
    destination[7]  = (source[0] >> 8) & 0x01;
    destination[8]  = (source[0] >> 7) & 0x01;
    destination[9]  = (source[0] >> 6) & 0x01;
    destination[10]  = (source[0] >> 5) & 0x01;
    destination[11]  = (source[0] >> 4) & 0x01;
    destination[12]  = (source[0] >> 3) & 0x01;
    destination[13]  = (source[0] >> 2) & 0x01;
    destination[14]  = (source[0] >> 1) & 0x01;
    destination[15]  = (source[0] >> 0) & 0x01;
  }
};
template <typename Tp>
struct __struct_bitpack_impl<Tp,2,2>
{
  static const size_t unit_size = 16;
  static const size_t bits_total = 32;
  static const size_t loop_total = 16;
  static const size_t bit_size = 2;
  static const Tp     mask = 0x03;
  static inline
  void pack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] & 0x03) << 14;
    destination[0] |= (source[1] & 0x03) << 12;
    destination[0] |= (source[2] & 0x03) << 10;
    destination[0] |= (source[3] & 0x03) << 8;
    destination[0] |= (source[4] & 0x03) << 6;
    destination[0] |= (source[5] & 0x03) << 4;
    destination[0] |= (source[6] & 0x03) << 2;
    destination[0] |= (source[7] & 0x03) << 0;
    destination[1]  = (source[8] & 0x03) << 14;
    destination[1] |= (source[9] & 0x03) << 12;
    destination[1] |= (source[10] & 0x03) << 10;
    destination[1] |= (source[11] & 0x03) << 8;
    destination[1] |= (source[12] & 0x03) << 6;
    destination[1] |= (source[13] & 0x03) << 4;
    destination[1] |= (source[14] & 0x03) << 2;
    destination[1] |= (source[15] & 0x03) << 0;
  }
  static inline
  void unpack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] >> 14) & 0x03;
    destination[1]  = (source[0] >> 12) & 0x03;
    destination[2]  = (source[0] >> 10) & 0x03;
    destination[3]  = (source[0] >> 8) & 0x03;
    destination[4]  = (source[0] >> 6) & 0x03;
    destination[5]  = (source[0] >> 4) & 0x03;
    destination[6]  = (source[0] >> 2) & 0x03;
    destination[7]  = (source[0] >> 0) & 0x03;
    destination[8]  = (source[1] >> 14) & 0x03;
    destination[9]  = (source[1] >> 12) & 0x03;
    destination[10]  = (source[1] >> 10) & 0x03;
    destination[11]  = (source[1] >> 8) & 0x03;
    destination[12]  = (source[1] >> 6) & 0x03;
    destination[13]  = (source[1] >> 4) & 0x03;
    destination[14]  = (source[1] >> 2) & 0x03;
    destination[15]  = (source[1] >> 0) & 0x03;
  }
};
template <typename Tp>
struct __struct_bitpack_impl<Tp,2,3>
{
  static const size_t unit_size = 16;
  static const size_t bits_total = 48;
  static const size_t loop_total = 16;
  static const size_t bit_size = 3;
  static const Tp     mask = 0x07;
  static inline
  void pack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] & 0x07) << 13;
    destination[0] |= (source[1] & 0x07) << 10;
    destination[0] |= (source[2] & 0x07) << 7;
    destination[0] |= (source[3] & 0x07) << 4;
    destination[0] |= (source[4] & 0x07) << 1;
    destination[0] |= (source[5] & 0x07) >> 2;
    destination[1]  = (source[5] & 0x07) << 14;
    destination[1] |= (source[6] & 0x07) << 11;
    destination[1] |= (source[7] & 0x07) << 8;
    destination[1] |= (source[8] & 0x07) << 5;
    destination[1] |= (source[9] & 0x07) << 2;
    destination[1] |= (source[10] & 0x07) >> 1;
    destination[2]  = (source[10] & 0x07) << 15;
    destination[2] |= (source[11] & 0x07) << 12;
    destination[2] |= (source[12] & 0x07) << 9;
    destination[2] |= (source[13] & 0x07) << 6;
    destination[2] |= (source[14] & 0x07) << 3;
    destination[2] |= (source[15] & 0x07) << 0;
  }
  static inline
  void unpack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] >> 13) & 0x07;
    destination[1]  = (source[0] >> 10) & 0x07;
    destination[2]  = (source[0] >> 7) & 0x07;
    destination[3]  = (source[0] >> 4) & 0x07;
    destination[4]  = (source[0] >> 1) & 0x07;
    destination[5]  = (source[0] << 2) & 0x07;
    destination[5] |= (source[1] >> 14) & 0x07;
    destination[6]  = (source[1] >> 11) & 0x07;
    destination[7]  = (source[1] >> 8) & 0x07;
    destination[8]  = (source[1] >> 5) & 0x07;
    destination[9]  = (source[1] >> 2) & 0x07;
    destination[10]  = (source[1] << 1) & 0x07;
    destination[10] |= (source[2] >> 15) & 0x07;
    destination[11]  = (source[2] >> 12) & 0x07;
    destination[12]  = (source[2] >> 9) & 0x07;
    destination[13]  = (source[2] >> 6) & 0x07;
    destination[14]  = (source[2] >> 3) & 0x07;
    destination[15]  = (source[2] >> 0) & 0x07;
  }
};
template <typename Tp>
struct __struct_bitpack_impl<Tp,2,4>
{
  static const size_t unit_size = 16;
  static const size_t bits_total = 64;
  static const size_t loop_total = 16;
  static const size_t bit_size = 4;
  static const Tp     mask = 0x0f;
  static inline
  void pack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] & 0x0f) << 12;
    destination[0] |= (source[1] & 0x0f) << 8;
    destination[0] |= (source[2] & 0x0f) << 4;
    destination[0] |= (source[3] & 0x0f) << 0;
    destination[1]  = (source[4] & 0x0f) << 12;
    destination[1] |= (source[5] & 0x0f) << 8;
    destination[1] |= (source[6] & 0x0f) << 4;
    destination[1] |= (source[7] & 0x0f) << 0;
    destination[2]  = (source[8] & 0x0f) << 12;
    destination[2] |= (source[9] & 0x0f) << 8;
    destination[2] |= (source[10] & 0x0f) << 4;
    destination[2] |= (source[11] & 0x0f) << 0;
    destination[3]  = (source[12] & 0x0f) << 12;
    destination[3] |= (source[13] & 0x0f) << 8;
    destination[3] |= (source[14] & 0x0f) << 4;
    destination[3] |= (source[15] & 0x0f) << 0;
  }
  static inline
  void unpack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] >> 12) & 0x0f;
    destination[1]  = (source[0] >> 8) & 0x0f;
    destination[2]  = (source[0] >> 4) & 0x0f;
    destination[3]  = (source[0] >> 0) & 0x0f;
    destination[4]  = (source[1] >> 12) & 0x0f;
    destination[5]  = (source[1] >> 8) & 0x0f;
    destination[6]  = (source[1] >> 4) & 0x0f;
    destination[7]  = (source[1] >> 0) & 0x0f;
    destination[8]  = (source[2] >> 12) & 0x0f;
    destination[9]  = (source[2] >> 8) & 0x0f;
    destination[10]  = (source[2] >> 4) & 0x0f;
    destination[11]  = (source[2] >> 0) & 0x0f;
    destination[12]  = (source[3] >> 12) & 0x0f;
    destination[13]  = (source[3] >> 8) & 0x0f;
    destination[14]  = (source[3] >> 4) & 0x0f;
    destination[15]  = (source[3] >> 0) & 0x0f;
  }
};
template <typename Tp>
struct __struct_bitpack_impl<Tp,2,5>
{
  static const size_t unit_size = 16;
  static const size_t bits_total = 80;
  static const size_t loop_total = 16;
  static const size_t bit_size = 5;
  static const Tp     mask = 0x1f;
  static inline
  void pack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] & 0x1f) << 11;
    destination[0] |= (source[1] & 0x1f) << 6;
    destination[0] |= (source[2] & 0x1f) << 1;
    destination[0] |= (source[3] & 0x1f) >> 4;
    destination[1]  = (source[3] & 0x1f) << 12;
    destination[1] |= (source[4] & 0x1f) << 7;
    destination[1] |= (source[5] & 0x1f) << 2;
    destination[1] |= (source[6] & 0x1f) >> 3;
    destination[2]  = (source[6] & 0x1f) << 13;
    destination[2] |= (source[7] & 0x1f) << 8;
    destination[2] |= (source[8] & 0x1f) << 3;
    destination[2] |= (source[9] & 0x1f) >> 2;
    destination[3]  = (source[9] & 0x1f) << 14;
    destination[3] |= (source[10] & 0x1f) << 9;
    destination[3] |= (source[11] & 0x1f) << 4;
    destination[3] |= (source[12] & 0x1f) >> 1;
    destination[4]  = (source[12] & 0x1f) << 15;
    destination[4] |= (source[13] & 0x1f) << 10;
    destination[4] |= (source[14] & 0x1f) << 5;
    destination[4] |= (source[15] & 0x1f) << 0;
  }
  static inline
  void unpack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] >> 11) & 0x1f;
    destination[1]  = (source[0] >> 6) & 0x1f;
    destination[2]  = (source[0] >> 1) & 0x1f;
    destination[3]  = (source[0] << 4) & 0x1f;
    destination[3] |= (source[1] >> 12) & 0x1f;
    destination[4]  = (source[1] >> 7) & 0x1f;
    destination[5]  = (source[1] >> 2) & 0x1f;
    destination[6]  = (source[1] << 3) & 0x1f;
    destination[6] |= (source[2] >> 13) & 0x1f;
    destination[7]  = (source[2] >> 8) & 0x1f;
    destination[8]  = (source[2] >> 3) & 0x1f;
    destination[9]  = (source[2] << 2) & 0x1f;
    destination[9] |= (source[3] >> 14) & 0x1f;
    destination[10]  = (source[3] >> 9) & 0x1f;
    destination[11]  = (source[3] >> 4) & 0x1f;
    destination[12]  = (source[3] << 1) & 0x1f;
    destination[12] |= (source[4] >> 15) & 0x1f;
    destination[13]  = (source[4] >> 10) & 0x1f;
    destination[14]  = (source[4] >> 5) & 0x1f;
    destination[15]  = (source[4] >> 0) & 0x1f;
  }
};
template <typename Tp>
struct __struct_bitpack_impl<Tp,2,6>
{
  static const size_t unit_size = 16;
  static const size_t bits_total = 96;
  static const size_t loop_total = 16;
  static const size_t bit_size = 6;
  static const Tp     mask = 0x3f;
  static inline
  void pack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] & 0x3f) << 10;
    destination[0] |= (source[1] & 0x3f) << 4;
    destination[0] |= (source[2] & 0x3f) >> 2;
    destination[1]  = (source[2] & 0x3f) << 14;
    destination[1] |= (source[3] & 0x3f) << 8;
    destination[1] |= (source[4] & 0x3f) << 2;
    destination[1] |= (source[5] & 0x3f) >> 4;
    destination[2]  = (source[5] & 0x3f) << 12;
    destination[2] |= (source[6] & 0x3f) << 6;
    destination[2] |= (source[7] & 0x3f) << 0;
    destination[3]  = (source[8] & 0x3f) << 10;
    destination[3] |= (source[9] & 0x3f) << 4;
    destination[3] |= (source[10] & 0x3f) >> 2;
    destination[4]  = (source[10] & 0x3f) << 14;
    destination[4] |= (source[11] & 0x3f) << 8;
    destination[4] |= (source[12] & 0x3f) << 2;
    destination[4] |= (source[13] & 0x3f) >> 4;
    destination[5]  = (source[13] & 0x3f) << 12;
    destination[5] |= (source[14] & 0x3f) << 6;
    destination[5] |= (source[15] & 0x3f) << 0;
  }
  static inline
  void unpack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] >> 10) & 0x3f;
    destination[1]  = (source[0] >> 4) & 0x3f;
    destination[2]  = (source[0] << 2) & 0x3f;
    destination[2] |= (source[1] >> 14) & 0x3f;
    destination[3]  = (source[1] >> 8) & 0x3f;
    destination[4]  = (source[1] >> 2) & 0x3f;
    destination[5]  = (source[1] << 4) & 0x3f;
    destination[5] |= (source[2] >> 12) & 0x3f;
    destination[6]  = (source[2] >> 6) & 0x3f;
    destination[7]  = (source[2] >> 0) & 0x3f;
    destination[8]  = (source[3] >> 10) & 0x3f;
    destination[9]  = (source[3] >> 4) & 0x3f;
    destination[10]  = (source[3] << 2) & 0x3f;
    destination[10] |= (source[4] >> 14) & 0x3f;
    destination[11]  = (source[4] >> 8) & 0x3f;
    destination[12]  = (source[4] >> 2) & 0x3f;
    destination[13]  = (source[4] << 4) & 0x3f;
    destination[13] |= (source[5] >> 12) & 0x3f;
    destination[14]  = (source[5] >> 6) & 0x3f;
    destination[15]  = (source[5] >> 0) & 0x3f;
  }
};
template <typename Tp>
struct __struct_bitpack_impl<Tp,2,7>
{
  static const size_t unit_size = 16;
  static const size_t bits_total = 112;
  static const size_t loop_total = 16;
  static const size_t bit_size = 7;
  static const Tp     mask = 0x7f;
  static inline
  void pack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] & 0x7f) << 9;
    destination[0] |= (source[1] & 0x7f) << 2;
    destination[0] |= (source[2] & 0x7f) >> 5;
    destination[1]  = (source[2] & 0x7f) << 11;
    destination[1] |= (source[3] & 0x7f) << 4;
    destination[1] |= (source[4] & 0x7f) >> 3;
    destination[2]  = (source[4] & 0x7f) << 13;
    destination[2] |= (source[5] & 0x7f) << 6;
    destination[2] |= (source[6] & 0x7f) >> 1;
    destination[3]  = (source[6] & 0x7f) << 15;
    destination[3] |= (source[7] & 0x7f) << 8;
    destination[3] |= (source[8] & 0x7f) << 1;
    destination[3] |= (source[9] & 0x7f) >> 6;
    destination[4]  = (source[9] & 0x7f) << 10;
    destination[4] |= (source[10] & 0x7f) << 3;
    destination[4] |= (source[11] & 0x7f) >> 4;
    destination[5]  = (source[11] & 0x7f) << 12;
    destination[5] |= (source[12] & 0x7f) << 5;
    destination[5] |= (source[13] & 0x7f) >> 2;
    destination[6]  = (source[13] & 0x7f) << 14;
    destination[6] |= (source[14] & 0x7f) << 7;
    destination[6] |= (source[15] & 0x7f) << 0;
  }
  static inline
  void unpack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] >> 9) & 0x7f;
    destination[1]  = (source[0] >> 2) & 0x7f;
    destination[2]  = (source[0] << 5) & 0x7f;
    destination[2] |= (source[1] >> 11) & 0x7f;
    destination[3]  = (source[1] >> 4) & 0x7f;
    destination[4]  = (source[1] << 3) & 0x7f;
    destination[4] |= (source[2] >> 13) & 0x7f;
    destination[5]  = (source[2] >> 6) & 0x7f;
    destination[6]  = (source[2] << 1) & 0x7f;
    destination[6] |= (source[3] >> 15) & 0x7f;
    destination[7]  = (source[3] >> 8) & 0x7f;
    destination[8]  = (source[3] >> 1) & 0x7f;
    destination[9]  = (source[3] << 6) & 0x7f;
    destination[9] |= (source[4] >> 10) & 0x7f;
    destination[10]  = (source[4] >> 3) & 0x7f;
    destination[11]  = (source[4] << 4) & 0x7f;
    destination[11] |= (source[5] >> 12) & 0x7f;
    destination[12]  = (source[5] >> 5) & 0x7f;
    destination[13]  = (source[5] << 2) & 0x7f;
    destination[13] |= (source[6] >> 14) & 0x7f;
    destination[14]  = (source[6] >> 7) & 0x7f;
    destination[15]  = (source[6] >> 0) & 0x7f;
  }
};
template <typename Tp>
struct __struct_bitpack_impl<Tp,2,8>
{
  static const size_t unit_size = 16;
  static const size_t bits_total = 128;
  static const size_t loop_total = 16;
  static const size_t bit_size = 8;
  static const Tp     mask = 0xff;
  static inline
  void pack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] & 0xff) << 8;
    destination[0] |= (source[1] & 0xff) << 0;
    destination[1]  = (source[2] & 0xff) << 8;
    destination[1] |= (source[3] & 0xff) << 0;
    destination[2]  = (source[4] & 0xff) << 8;
    destination[2] |= (source[5] & 0xff) << 0;
    destination[3]  = (source[6] & 0xff) << 8;
    destination[3] |= (source[7] & 0xff) << 0;
    destination[4]  = (source[8] & 0xff) << 8;
    destination[4] |= (source[9] & 0xff) << 0;
    destination[5]  = (source[10] & 0xff) << 8;
    destination[5] |= (source[11] & 0xff) << 0;
    destination[6]  = (source[12] & 0xff) << 8;
    destination[6] |= (source[13] & 0xff) << 0;
    destination[7]  = (source[14] & 0xff) << 8;
    destination[7] |= (source[15] & 0xff) << 0;
  }
  static inline
  void unpack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] >> 8) & 0xff;
    destination[1]  = (source[0] >> 0) & 0xff;
    destination[2]  = (source[1] >> 8) & 0xff;
    destination[3]  = (source[1] >> 0) & 0xff;
    destination[4]  = (source[2] >> 8) & 0xff;
    destination[5]  = (source[2] >> 0) & 0xff;
    destination[6]  = (source[3] >> 8) & 0xff;
    destination[7]  = (source[3] >> 0) & 0xff;
    destination[8]  = (source[4] >> 8) & 0xff;
    destination[9]  = (source[4] >> 0) & 0xff;
    destination[10]  = (source[5] >> 8) & 0xff;
    destination[11]  = (source[5] >> 0) & 0xff;
    destination[12]  = (source[6] >> 8) & 0xff;
    destination[13]  = (source[6] >> 0) & 0xff;
    destination[14]  = (source[7] >> 8) & 0xff;
    destination[15]  = (source[7] >> 0) & 0xff;
  }
};
template <typename Tp>
struct __struct_bitpack_impl<Tp,2,9>
{
  static const size_t unit_size = 16;
  static const size_t bits_total = 144;
  static const size_t loop_total = 16;
  static const size_t bit_size = 9;
  static const Tp     mask = 0x1ff;
  static inline
  void pack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] & 0x1ff) << 7;
    destination[0] |= (source[1] & 0x1ff) >> 2;
    destination[1]  = (source[1] & 0x1ff) << 14;
    destination[1] |= (source[2] & 0x1ff) << 5;
    destination[1] |= (source[3] & 0x1ff) >> 4;
    destination[2]  = (source[3] & 0x1ff) << 12;
    destination[2] |= (source[4] & 0x1ff) << 3;
    destination[2] |= (source[5] & 0x1ff) >> 6;
    destination[3]  = (source[5] & 0x1ff) << 10;
    destination[3] |= (source[6] & 0x1ff) << 1;
    destination[3] |= (source[7] & 0x1ff) >> 8;
    destination[4]  = (source[7] & 0x1ff) << 8;
    destination[4] |= (source[8] & 0x1ff) >> 1;
    destination[5]  = (source[8] & 0x1ff) << 15;
    destination[5] |= (source[9] & 0x1ff) << 6;
    destination[5] |= (source[10] & 0x1ff) >> 3;
    destination[6]  = (source[10] & 0x1ff) << 13;
    destination[6] |= (source[11] & 0x1ff) << 4;
    destination[6] |= (source[12] & 0x1ff) >> 5;
    destination[7]  = (source[12] & 0x1ff) << 11;
    destination[7] |= (source[13] & 0x1ff) << 2;
    destination[7] |= (source[14] & 0x1ff) >> 7;
    destination[8]  = (source[14] & 0x1ff) << 9;
    destination[8] |= (source[15] & 0x1ff) << 0;
  }
  static inline
  void unpack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] >> 7) & 0x1ff;
    destination[1]  = (source[0] << 2) & 0x1ff;
    destination[1] |= (source[1] >> 14) & 0x1ff;
    destination[2]  = (source[1] >> 5) & 0x1ff;
    destination[3]  = (source[1] << 4) & 0x1ff;
    destination[3] |= (source[2] >> 12) & 0x1ff;
    destination[4]  = (source[2] >> 3) & 0x1ff;
    destination[5]  = (source[2] << 6) & 0x1ff;
    destination[5] |= (source[3] >> 10) & 0x1ff;
    destination[6]  = (source[3] >> 1) & 0x1ff;
    destination[7]  = (source[3] << 8) & 0x1ff;
    destination[7] |= (source[4] >> 8) & 0x1ff;
    destination[8]  = (source[4] << 1) & 0x1ff;
    destination[8] |= (source[5] >> 15) & 0x1ff;
    destination[9]  = (source[5] >> 6) & 0x1ff;
    destination[10]  = (source[5] << 3) & 0x1ff;
    destination[10] |= (source[6] >> 13) & 0x1ff;
    destination[11]  = (source[6] >> 4) & 0x1ff;
    destination[12]  = (source[6] << 5) & 0x1ff;
    destination[12] |= (source[7] >> 11) & 0x1ff;
    destination[13]  = (source[7] >> 2) & 0x1ff;
    destination[14]  = (source[7] << 7) & 0x1ff;
    destination[14] |= (source[8] >> 9) & 0x1ff;
    destination[15]  = (source[8] >> 0) & 0x1ff;
  }
};
template <typename Tp>
struct __struct_bitpack_impl<Tp,2,10>
{
  static const size_t unit_size = 16;
  static const size_t bits_total = 160;
  static const size_t loop_total = 16;
  static const size_t bit_size = 10;
  static const Tp     mask = 0x3ff;
  static inline
  void pack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] & 0x3ff) << 6;
    destination[0] |= (source[1] & 0x3ff) >> 4;
    destination[1]  = (source[1] & 0x3ff) << 12;
    destination[1] |= (source[2] & 0x3ff) << 2;
    destination[1] |= (source[3] & 0x3ff) >> 8;
    destination[2]  = (source[3] & 0x3ff) << 8;
    destination[2] |= (source[4] & 0x3ff) >> 2;
    destination[3]  = (source[4] & 0x3ff) << 14;
    destination[3] |= (source[5] & 0x3ff) << 4;
    destination[3] |= (source[6] & 0x3ff) >> 6;
    destination[4]  = (source[6] & 0x3ff) << 10;
    destination[4] |= (source[7] & 0x3ff) << 0;
    destination[5]  = (source[8] & 0x3ff) << 6;
    destination[5] |= (source[9] & 0x3ff) >> 4;
    destination[6]  = (source[9] & 0x3ff) << 12;
    destination[6] |= (source[10] & 0x3ff) << 2;
    destination[6] |= (source[11] & 0x3ff) >> 8;
    destination[7]  = (source[11] & 0x3ff) << 8;
    destination[7] |= (source[12] & 0x3ff) >> 2;
    destination[8]  = (source[12] & 0x3ff) << 14;
    destination[8] |= (source[13] & 0x3ff) << 4;
    destination[8] |= (source[14] & 0x3ff) >> 6;
    destination[9]  = (source[14] & 0x3ff) << 10;
    destination[9] |= (source[15] & 0x3ff) << 0;
  }
  static inline
  void unpack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] >> 6) & 0x3ff;
    destination[1]  = (source[0] << 4) & 0x3ff;
    destination[1] |= (source[1] >> 12) & 0x3ff;
    destination[2]  = (source[1] >> 2) & 0x3ff;
    destination[3]  = (source[1] << 8) & 0x3ff;
    destination[3] |= (source[2] >> 8) & 0x3ff;
    destination[4]  = (source[2] << 2) & 0x3ff;
    destination[4] |= (source[3] >> 14) & 0x3ff;
    destination[5]  = (source[3] >> 4) & 0x3ff;
    destination[6]  = (source[3] << 6) & 0x3ff;
    destination[6] |= (source[4] >> 10) & 0x3ff;
    destination[7]  = (source[4] >> 0) & 0x3ff;
    destination[8]  = (source[5] >> 6) & 0x3ff;
    destination[9]  = (source[5] << 4) & 0x3ff;
    destination[9] |= (source[6] >> 12) & 0x3ff;
    destination[10]  = (source[6] >> 2) & 0x3ff;
    destination[11]  = (source[6] << 8) & 0x3ff;
    destination[11] |= (source[7] >> 8) & 0x3ff;
    destination[12]  = (source[7] << 2) & 0x3ff;
    destination[12] |= (source[8] >> 14) & 0x3ff;
    destination[13]  = (source[8] >> 4) & 0x3ff;
    destination[14]  = (source[8] << 6) & 0x3ff;
    destination[14] |= (source[9] >> 10) & 0x3ff;
    destination[15]  = (source[9] >> 0) & 0x3ff;
  }
};
template <typename Tp>
struct __struct_bitpack_impl<Tp,2,11>
{
  static const size_t unit_size = 16;
  static const size_t bits_total = 176;
  static const size_t loop_total = 16;
  static const size_t bit_size = 11;
  static const Tp     mask = 0x7ff;
  static inline
  void pack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] & 0x7ff) << 5;
    destination[0] |= (source[1] & 0x7ff) >> 6;
    destination[1]  = (source[1] & 0x7ff) << 10;
    destination[1] |= (source[2] & 0x7ff) >> 1;
    destination[2]  = (source[2] & 0x7ff) << 15;
    destination[2] |= (source[3] & 0x7ff) << 4;
    destination[2] |= (source[4] & 0x7ff) >> 7;
    destination[3]  = (source[4] & 0x7ff) << 9;
    destination[3] |= (source[5] & 0x7ff) >> 2;
    destination[4]  = (source[5] & 0x7ff) << 14;
    destination[4] |= (source[6] & 0x7ff) << 3;
    destination[4] |= (source[7] & 0x7ff) >> 8;
    destination[5]  = (source[7] & 0x7ff) << 8;
    destination[5] |= (source[8] & 0x7ff) >> 3;
    destination[6]  = (source[8] & 0x7ff) << 13;
    destination[6] |= (source[9] & 0x7ff) << 2;
    destination[6] |= (source[10] & 0x7ff) >> 9;
    destination[7]  = (source[10] & 0x7ff) << 7;
    destination[7] |= (source[11] & 0x7ff) >> 4;
    destination[8]  = (source[11] & 0x7ff) << 12;
    destination[8] |= (source[12] & 0x7ff) << 1;
    destination[8] |= (source[13] & 0x7ff) >> 10;
    destination[9]  = (source[13] & 0x7ff) << 6;
    destination[9] |= (source[14] & 0x7ff) >> 5;
    destination[10]  = (source[14] & 0x7ff) << 11;
    destination[10] |= (source[15] & 0x7ff) << 0;
  }
  static inline
  void unpack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] >> 5) & 0x7ff;
    destination[1]  = (source[0] << 6) & 0x7ff;
    destination[1] |= (source[1] >> 10) & 0x7ff;
    destination[2]  = (source[1] << 1) & 0x7ff;
    destination[2] |= (source[2] >> 15) & 0x7ff;
    destination[3]  = (source[2] >> 4) & 0x7ff;
    destination[4]  = (source[2] << 7) & 0x7ff;
    destination[4] |= (source[3] >> 9) & 0x7ff;
    destination[5]  = (source[3] << 2) & 0x7ff;
    destination[5] |= (source[4] >> 14) & 0x7ff;
    destination[6]  = (source[4] >> 3) & 0x7ff;
    destination[7]  = (source[4] << 8) & 0x7ff;
    destination[7] |= (source[5] >> 8) & 0x7ff;
    destination[8]  = (source[5] << 3) & 0x7ff;
    destination[8] |= (source[6] >> 13) & 0x7ff;
    destination[9]  = (source[6] >> 2) & 0x7ff;
    destination[10]  = (source[6] << 9) & 0x7ff;
    destination[10] |= (source[7] >> 7) & 0x7ff;
    destination[11]  = (source[7] << 4) & 0x7ff;
    destination[11] |= (source[8] >> 12) & 0x7ff;
    destination[12]  = (source[8] >> 1) & 0x7ff;
    destination[13]  = (source[8] << 10) & 0x7ff;
    destination[13] |= (source[9] >> 6) & 0x7ff;
    destination[14]  = (source[9] << 5) & 0x7ff;
    destination[14] |= (source[10] >> 11) & 0x7ff;
    destination[15]  = (source[10] >> 0) & 0x7ff;
  }
};
template <typename Tp>
struct __struct_bitpack_impl<Tp,2,12>
{
  static const size_t unit_size = 16;
  static const size_t bits_total = 192;
  static const size_t loop_total = 16;
  static const size_t bit_size = 12;
  static const Tp     mask = 0xfff;
  static inline
  void pack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] & 0xfff) << 4;
    destination[0] |= (source[1] & 0xfff) >> 8;
    destination[1]  = (source[1] & 0xfff) << 8;
    destination[1] |= (source[2] & 0xfff) >> 4;
    destination[2]  = (source[2] & 0xfff) << 12;
    destination[2] |= (source[3] & 0xfff) << 0;
    destination[3]  = (source[4] & 0xfff) << 4;
    destination[3] |= (source[5] & 0xfff) >> 8;
    destination[4]  = (source[5] & 0xfff) << 8;
    destination[4] |= (source[6] & 0xfff) >> 4;
    destination[5]  = (source[6] & 0xfff) << 12;
    destination[5] |= (source[7] & 0xfff) << 0;
    destination[6]  = (source[8] & 0xfff) << 4;
    destination[6] |= (source[9] & 0xfff) >> 8;
    destination[7]  = (source[9] & 0xfff) << 8;
    destination[7] |= (source[10] & 0xfff) >> 4;
    destination[8]  = (source[10] & 0xfff) << 12;
    destination[8] |= (source[11] & 0xfff) << 0;
    destination[9]  = (source[12] & 0xfff) << 4;
    destination[9] |= (source[13] & 0xfff) >> 8;
    destination[10]  = (source[13] & 0xfff) << 8;
    destination[10] |= (source[14] & 0xfff) >> 4;
    destination[11]  = (source[14] & 0xfff) << 12;
    destination[11] |= (source[15] & 0xfff) << 0;
  }
  static inline
  void unpack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] >> 4) & 0xfff;
    destination[1]  = (source[0] << 8) & 0xfff;
    destination[1] |= (source[1] >> 8) & 0xfff;
    destination[2]  = (source[1] << 4) & 0xfff;
    destination[2] |= (source[2] >> 12) & 0xfff;
    destination[3]  = (source[2] >> 0) & 0xfff;
    destination[4]  = (source[3] >> 4) & 0xfff;
    destination[5]  = (source[3] << 8) & 0xfff;
    destination[5] |= (source[4] >> 8) & 0xfff;
    destination[6]  = (source[4] << 4) & 0xfff;
    destination[6] |= (source[5] >> 12) & 0xfff;
    destination[7]  = (source[5] >> 0) & 0xfff;
    destination[8]  = (source[6] >> 4) & 0xfff;
    destination[9]  = (source[6] << 8) & 0xfff;
    destination[9] |= (source[7] >> 8) & 0xfff;
    destination[10]  = (source[7] << 4) & 0xfff;
    destination[10] |= (source[8] >> 12) & 0xfff;
    destination[11]  = (source[8] >> 0) & 0xfff;
    destination[12]  = (source[9] >> 4) & 0xfff;
    destination[13]  = (source[9] << 8) & 0xfff;
    destination[13] |= (source[10] >> 8) & 0xfff;
    destination[14]  = (source[10] << 4) & 0xfff;
    destination[14] |= (source[11] >> 12) & 0xfff;
    destination[15]  = (source[11] >> 0) & 0xfff;
  }
};
template <typename Tp>
struct __struct_bitpack_impl<Tp,2,13>
{
  static const size_t unit_size = 16;
  static const size_t bits_total = 208;
  static const size_t loop_total = 16;
  static const size_t bit_size = 13;
  static const Tp     mask = 0x1fff;
  static inline
  void pack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] & 0x1fff) << 3;
    destination[0] |= (source[1] & 0x1fff) >> 10;
    destination[1]  = (source[1] & 0x1fff) << 6;
    destination[1] |= (source[2] & 0x1fff) >> 7;
    destination[2]  = (source[2] & 0x1fff) << 9;
    destination[2] |= (source[3] & 0x1fff) >> 4;
    destination[3]  = (source[3] & 0x1fff) << 12;
    destination[3] |= (source[4] & 0x1fff) >> 1;
    destination[4]  = (source[4] & 0x1fff) << 15;
    destination[4] |= (source[5] & 0x1fff) << 2;
    destination[4] |= (source[6] & 0x1fff) >> 11;
    destination[5]  = (source[6] & 0x1fff) << 5;
    destination[5] |= (source[7] & 0x1fff) >> 8;
    destination[6]  = (source[7] & 0x1fff) << 8;
    destination[6] |= (source[8] & 0x1fff) >> 5;
    destination[7]  = (source[8] & 0x1fff) << 11;
    destination[7] |= (source[9] & 0x1fff) >> 2;
    destination[8]  = (source[9] & 0x1fff) << 14;
    destination[8] |= (source[10] & 0x1fff) << 1;
    destination[8] |= (source[11] & 0x1fff) >> 12;
    destination[9]  = (source[11] & 0x1fff) << 4;
    destination[9] |= (source[12] & 0x1fff) >> 9;
    destination[10]  = (source[12] & 0x1fff) << 7;
    destination[10] |= (source[13] & 0x1fff) >> 6;
    destination[11]  = (source[13] & 0x1fff) << 10;
    destination[11] |= (source[14] & 0x1fff) >> 3;
    destination[12]  = (source[14] & 0x1fff) << 13;
    destination[12] |= (source[15] & 0x1fff) << 0;
  }
  static inline
  void unpack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] >> 3) & 0x1fff;
    destination[1]  = (source[0] << 10) & 0x1fff;
    destination[1] |= (source[1] >> 6) & 0x1fff;
    destination[2]  = (source[1] << 7) & 0x1fff;
    destination[2] |= (source[2] >> 9) & 0x1fff;
    destination[3]  = (source[2] << 4) & 0x1fff;
    destination[3] |= (source[3] >> 12) & 0x1fff;
    destination[4]  = (source[3] << 1) & 0x1fff;
    destination[4] |= (source[4] >> 15) & 0x1fff;
    destination[5]  = (source[4] >> 2) & 0x1fff;
    destination[6]  = (source[4] << 11) & 0x1fff;
    destination[6] |= (source[5] >> 5) & 0x1fff;
    destination[7]  = (source[5] << 8) & 0x1fff;
    destination[7] |= (source[6] >> 8) & 0x1fff;
    destination[8]  = (source[6] << 5) & 0x1fff;
    destination[8] |= (source[7] >> 11) & 0x1fff;
    destination[9]  = (source[7] << 2) & 0x1fff;
    destination[9] |= (source[8] >> 14) & 0x1fff;
    destination[10]  = (source[8] >> 1) & 0x1fff;
    destination[11]  = (source[8] << 12) & 0x1fff;
    destination[11] |= (source[9] >> 4) & 0x1fff;
    destination[12]  = (source[9] << 9) & 0x1fff;
    destination[12] |= (source[10] >> 7) & 0x1fff;
    destination[13]  = (source[10] << 6) & 0x1fff;
    destination[13] |= (source[11] >> 10) & 0x1fff;
    destination[14]  = (source[11] << 3) & 0x1fff;
    destination[14] |= (source[12] >> 13) & 0x1fff;
    destination[15]  = (source[12] >> 0) & 0x1fff;
  }
};
template <typename Tp>
struct __struct_bitpack_impl<Tp,2,14>
{
  static const size_t unit_size = 16;
  static const size_t bits_total = 224;
  static const size_t loop_total = 16;
  static const size_t bit_size = 14;
  static const Tp     mask = 0x3fff;
  static inline
  void pack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] & 0x3fff) << 2;
    destination[0] |= (source[1] & 0x3fff) >> 12;
    destination[1]  = (source[1] & 0x3fff) << 4;
    destination[1] |= (source[2] & 0x3fff) >> 10;
    destination[2]  = (source[2] & 0x3fff) << 6;
    destination[2] |= (source[3] & 0x3fff) >> 8;
    destination[3]  = (source[3] & 0x3fff) << 8;
    destination[3] |= (source[4] & 0x3fff) >> 6;
    destination[4]  = (source[4] & 0x3fff) << 10;
    destination[4] |= (source[5] & 0x3fff) >> 4;
    destination[5]  = (source[5] & 0x3fff) << 12;
    destination[5] |= (source[6] & 0x3fff) >> 2;
    destination[6]  = (source[6] & 0x3fff) << 14;
    destination[6] |= (source[7] & 0x3fff) << 0;
    destination[7]  = (source[8] & 0x3fff) << 2;
    destination[7] |= (source[9] & 0x3fff) >> 12;
    destination[8]  = (source[9] & 0x3fff) << 4;
    destination[8] |= (source[10] & 0x3fff) >> 10;
    destination[9]  = (source[10] & 0x3fff) << 6;
    destination[9] |= (source[11] & 0x3fff) >> 8;
    destination[10]  = (source[11] & 0x3fff) << 8;
    destination[10] |= (source[12] & 0x3fff) >> 6;
    destination[11]  = (source[12] & 0x3fff) << 10;
    destination[11] |= (source[13] & 0x3fff) >> 4;
    destination[12]  = (source[13] & 0x3fff) << 12;
    destination[12] |= (source[14] & 0x3fff) >> 2;
    destination[13]  = (source[14] & 0x3fff) << 14;
    destination[13] |= (source[15] & 0x3fff) << 0;
  }
  static inline
  void unpack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] >> 2) & 0x3fff;
    destination[1]  = (source[0] << 12) & 0x3fff;
    destination[1] |= (source[1] >> 4) & 0x3fff;
    destination[2]  = (source[1] << 10) & 0x3fff;
    destination[2] |= (source[2] >> 6) & 0x3fff;
    destination[3]  = (source[2] << 8) & 0x3fff;
    destination[3] |= (source[3] >> 8) & 0x3fff;
    destination[4]  = (source[3] << 6) & 0x3fff;
    destination[4] |= (source[4] >> 10) & 0x3fff;
    destination[5]  = (source[4] << 4) & 0x3fff;
    destination[5] |= (source[5] >> 12) & 0x3fff;
    destination[6]  = (source[5] << 2) & 0x3fff;
    destination[6] |= (source[6] >> 14) & 0x3fff;
    destination[7]  = (source[6] >> 0) & 0x3fff;
    destination[8]  = (source[7] >> 2) & 0x3fff;
    destination[9]  = (source[7] << 12) & 0x3fff;
    destination[9] |= (source[8] >> 4) & 0x3fff;
    destination[10]  = (source[8] << 10) & 0x3fff;
    destination[10] |= (source[9] >> 6) & 0x3fff;
    destination[11]  = (source[9] << 8) & 0x3fff;
    destination[11] |= (source[10] >> 8) & 0x3fff;
    destination[12]  = (source[10] << 6) & 0x3fff;
    destination[12] |= (source[11] >> 10) & 0x3fff;
    destination[13]  = (source[11] << 4) & 0x3fff;
    destination[13] |= (source[12] >> 12) & 0x3fff;
    destination[14]  = (source[12] << 2) & 0x3fff;
    destination[14] |= (source[13] >> 14) & 0x3fff;
    destination[15]  = (source[13] >> 0) & 0x3fff;
  }
};
template <typename Tp>
struct __struct_bitpack_impl<Tp,2,15>
{
  static const size_t unit_size = 16;
  static const size_t bits_total = 240;
  static const size_t loop_total = 16;
  static const size_t bit_size = 15;
  static const Tp     mask = 0x7fff;
  static inline
  void pack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] & 0x7fff) << 1;
    destination[0] |= (source[1] & 0x7fff) >> 14;
    destination[1]  = (source[1] & 0x7fff) << 2;
    destination[1] |= (source[2] & 0x7fff) >> 13;
    destination[2]  = (source[2] & 0x7fff) << 3;
    destination[2] |= (source[3] & 0x7fff) >> 12;
    destination[3]  = (source[3] & 0x7fff) << 4;
    destination[3] |= (source[4] & 0x7fff) >> 11;
    destination[4]  = (source[4] & 0x7fff) << 5;
    destination[4] |= (source[5] & 0x7fff) >> 10;
    destination[5]  = (source[5] & 0x7fff) << 6;
    destination[5] |= (source[6] & 0x7fff) >> 9;
    destination[6]  = (source[6] & 0x7fff) << 7;
    destination[6] |= (source[7] & 0x7fff) >> 8;
    destination[7]  = (source[7] & 0x7fff) << 8;
    destination[7] |= (source[8] & 0x7fff) >> 7;
    destination[8]  = (source[8] & 0x7fff) << 9;
    destination[8] |= (source[9] & 0x7fff) >> 6;
    destination[9]  = (source[9] & 0x7fff) << 10;
    destination[9] |= (source[10] & 0x7fff) >> 5;
    destination[10]  = (source[10] & 0x7fff) << 11;
    destination[10] |= (source[11] & 0x7fff) >> 4;
    destination[11]  = (source[11] & 0x7fff) << 12;
    destination[11] |= (source[12] & 0x7fff) >> 3;
    destination[12]  = (source[12] & 0x7fff) << 13;
    destination[12] |= (source[13] & 0x7fff) >> 2;
    destination[13]  = (source[13] & 0x7fff) << 14;
    destination[13] |= (source[14] & 0x7fff) >> 1;
    destination[14]  = (source[14] & 0x7fff) << 15;
    destination[14] |= (source[15] & 0x7fff) << 0;
  }
  static inline
  void unpack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] >> 1) & 0x7fff;
    destination[1]  = (source[0] << 14) & 0x7fff;
    destination[1] |= (source[1] >> 2) & 0x7fff;
    destination[2]  = (source[1] << 13) & 0x7fff;
    destination[2] |= (source[2] >> 3) & 0x7fff;
    destination[3]  = (source[2] << 12) & 0x7fff;
    destination[3] |= (source[3] >> 4) & 0x7fff;
    destination[4]  = (source[3] << 11) & 0x7fff;
    destination[4] |= (source[4] >> 5) & 0x7fff;
    destination[5]  = (source[4] << 10) & 0x7fff;
    destination[5] |= (source[5] >> 6) & 0x7fff;
    destination[6]  = (source[5] << 9) & 0x7fff;
    destination[6] |= (source[6] >> 7) & 0x7fff;
    destination[7]  = (source[6] << 8) & 0x7fff;
    destination[7] |= (source[7] >> 8) & 0x7fff;
    destination[8]  = (source[7] << 7) & 0x7fff;
    destination[8] |= (source[8] >> 9) & 0x7fff;
    destination[9]  = (source[8] << 6) & 0x7fff;
    destination[9] |= (source[9] >> 10) & 0x7fff;
    destination[10]  = (source[9] << 5) & 0x7fff;
    destination[10] |= (source[10] >> 11) & 0x7fff;
    destination[11]  = (source[10] << 4) & 0x7fff;
    destination[11] |= (source[11] >> 12) & 0x7fff;
    destination[12]  = (source[11] << 3) & 0x7fff;
    destination[12] |= (source[12] >> 13) & 0x7fff;
    destination[13]  = (source[12] << 2) & 0x7fff;
    destination[13] |= (source[13] >> 14) & 0x7fff;
    destination[14]  = (source[13] << 1) & 0x7fff;
    destination[14] |= (source[14] >> 15) & 0x7fff;
    destination[15]  = (source[14] >> 0) & 0x7fff;
  }
};
};
};
#endif
