#ifndef __UTILS__BITPACK8_IMPL__HPP__
#define __UTILS__BITPACK8_IMPL__HPP__ 1
namespace utils {
namespace bitpack {
template <typename Tp>
struct __struct_bitpack_impl<Tp,1,1>
{
  static const size_t unit_size = 8;
  static const size_t bits_total = 8;
  static const size_t loop_total = 8;
  static const size_t bit_size = 1;
  static const Tp     mask = 0x01;
  static inline
  void pack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] & 0x01) << 7;
    destination[0] |= (source[1] & 0x01) << 6;
    destination[0] |= (source[2] & 0x01) << 5;
    destination[0] |= (source[3] & 0x01) << 4;
    destination[0] |= (source[4] & 0x01) << 3;
    destination[0] |= (source[5] & 0x01) << 2;
    destination[0] |= (source[6] & 0x01) << 1;
    destination[0] |= (source[7] & 0x01) << 0;
  }
  static inline
  void unpack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] >> 7) & 0x01;
    destination[1]  = (source[0] >> 6) & 0x01;
    destination[2]  = (source[0] >> 5) & 0x01;
    destination[3]  = (source[0] >> 4) & 0x01;
    destination[4]  = (source[0] >> 3) & 0x01;
    destination[5]  = (source[0] >> 2) & 0x01;
    destination[6]  = (source[0] >> 1) & 0x01;
    destination[7]  = (source[0] >> 0) & 0x01;
  }
};
template <typename Tp>
struct __struct_bitpack_impl<Tp,1,2>
{
  static const size_t unit_size = 8;
  static const size_t bits_total = 16;
  static const size_t loop_total = 8;
  static const size_t bit_size = 2;
  static const Tp     mask = 0x03;
  static inline
  void pack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] & 0x03) << 6;
    destination[0] |= (source[1] & 0x03) << 4;
    destination[0] |= (source[2] & 0x03) << 2;
    destination[0] |= (source[3] & 0x03) << 0;
    destination[1]  = (source[4] & 0x03) << 6;
    destination[1] |= (source[5] & 0x03) << 4;
    destination[1] |= (source[6] & 0x03) << 2;
    destination[1] |= (source[7] & 0x03) << 0;
  }
  static inline
  void unpack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] >> 6) & 0x03;
    destination[1]  = (source[0] >> 4) & 0x03;
    destination[2]  = (source[0] >> 2) & 0x03;
    destination[3]  = (source[0] >> 0) & 0x03;
    destination[4]  = (source[1] >> 6) & 0x03;
    destination[5]  = (source[1] >> 4) & 0x03;
    destination[6]  = (source[1] >> 2) & 0x03;
    destination[7]  = (source[1] >> 0) & 0x03;
  }
};
template <typename Tp>
struct __struct_bitpack_impl<Tp,1,3>
{
  static const size_t unit_size = 8;
  static const size_t bits_total = 24;
  static const size_t loop_total = 8;
  static const size_t bit_size = 3;
  static const Tp     mask = 0x07;
  static inline
  void pack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] & 0x07) << 5;
    destination[0] |= (source[1] & 0x07) << 2;
    destination[0] |= (source[2] & 0x07) >> 1;
    destination[1]  = (source[2] & 0x07) << 7;
    destination[1] |= (source[3] & 0x07) << 4;
    destination[1] |= (source[4] & 0x07) << 1;
    destination[1] |= (source[5] & 0x07) >> 2;
    destination[2]  = (source[5] & 0x07) << 6;
    destination[2] |= (source[6] & 0x07) << 3;
    destination[2] |= (source[7] & 0x07) << 0;
  }
  static inline
  void unpack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] >> 5) & 0x07;
    destination[1]  = (source[0] >> 2) & 0x07;
    destination[2]  = (source[0] << 1) & 0x07;
    destination[2] |= (source[1] >> 7) & 0x07;
    destination[3]  = (source[1] >> 4) & 0x07;
    destination[4]  = (source[1] >> 1) & 0x07;
    destination[5]  = (source[1] << 2) & 0x07;
    destination[5] |= (source[2] >> 6) & 0x07;
    destination[6]  = (source[2] >> 3) & 0x07;
    destination[7]  = (source[2] >> 0) & 0x07;
  }
};
template <typename Tp>
struct __struct_bitpack_impl<Tp,1,4>
{
  static const size_t unit_size = 8;
  static const size_t bits_total = 32;
  static const size_t loop_total = 8;
  static const size_t bit_size = 4;
  static const Tp     mask = 0x0f;
  static inline
  void pack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] & 0x0f) << 4;
    destination[0] |= (source[1] & 0x0f) << 0;
    destination[1]  = (source[2] & 0x0f) << 4;
    destination[1] |= (source[3] & 0x0f) << 0;
    destination[2]  = (source[4] & 0x0f) << 4;
    destination[2] |= (source[5] & 0x0f) << 0;
    destination[3]  = (source[6] & 0x0f) << 4;
    destination[3] |= (source[7] & 0x0f) << 0;
  }
  static inline
  void unpack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] >> 4) & 0x0f;
    destination[1]  = (source[0] >> 0) & 0x0f;
    destination[2]  = (source[1] >> 4) & 0x0f;
    destination[3]  = (source[1] >> 0) & 0x0f;
    destination[4]  = (source[2] >> 4) & 0x0f;
    destination[5]  = (source[2] >> 0) & 0x0f;
    destination[6]  = (source[3] >> 4) & 0x0f;
    destination[7]  = (source[3] >> 0) & 0x0f;
  }
};
template <typename Tp>
struct __struct_bitpack_impl<Tp,1,5>
{
  static const size_t unit_size = 8;
  static const size_t bits_total = 40;
  static const size_t loop_total = 8;
  static const size_t bit_size = 5;
  static const Tp     mask = 0x1f;
  static inline
  void pack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] & 0x1f) << 3;
    destination[0] |= (source[1] & 0x1f) >> 2;
    destination[1]  = (source[1] & 0x1f) << 6;
    destination[1] |= (source[2] & 0x1f) << 1;
    destination[1] |= (source[3] & 0x1f) >> 4;
    destination[2]  = (source[3] & 0x1f) << 4;
    destination[2] |= (source[4] & 0x1f) >> 1;
    destination[3]  = (source[4] & 0x1f) << 7;
    destination[3] |= (source[5] & 0x1f) << 2;
    destination[3] |= (source[6] & 0x1f) >> 3;
    destination[4]  = (source[6] & 0x1f) << 5;
    destination[4] |= (source[7] & 0x1f) << 0;
  }
  static inline
  void unpack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] >> 3) & 0x1f;
    destination[1]  = (source[0] << 2) & 0x1f;
    destination[1] |= (source[1] >> 6) & 0x1f;
    destination[2]  = (source[1] >> 1) & 0x1f;
    destination[3]  = (source[1] << 4) & 0x1f;
    destination[3] |= (source[2] >> 4) & 0x1f;
    destination[4]  = (source[2] << 1) & 0x1f;
    destination[4] |= (source[3] >> 7) & 0x1f;
    destination[5]  = (source[3] >> 2) & 0x1f;
    destination[6]  = (source[3] << 3) & 0x1f;
    destination[6] |= (source[4] >> 5) & 0x1f;
    destination[7]  = (source[4] >> 0) & 0x1f;
  }
};
template <typename Tp>
struct __struct_bitpack_impl<Tp,1,6>
{
  static const size_t unit_size = 8;
  static const size_t bits_total = 48;
  static const size_t loop_total = 8;
  static const size_t bit_size = 6;
  static const Tp     mask = 0x3f;
  static inline
  void pack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] & 0x3f) << 2;
    destination[0] |= (source[1] & 0x3f) >> 4;
    destination[1]  = (source[1] & 0x3f) << 4;
    destination[1] |= (source[2] & 0x3f) >> 2;
    destination[2]  = (source[2] & 0x3f) << 6;
    destination[2] |= (source[3] & 0x3f) << 0;
    destination[3]  = (source[4] & 0x3f) << 2;
    destination[3] |= (source[5] & 0x3f) >> 4;
    destination[4]  = (source[5] & 0x3f) << 4;
    destination[4] |= (source[6] & 0x3f) >> 2;
    destination[5]  = (source[6] & 0x3f) << 6;
    destination[5] |= (source[7] & 0x3f) << 0;
  }
  static inline
  void unpack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] >> 2) & 0x3f;
    destination[1]  = (source[0] << 4) & 0x3f;
    destination[1] |= (source[1] >> 4) & 0x3f;
    destination[2]  = (source[1] << 2) & 0x3f;
    destination[2] |= (source[2] >> 6) & 0x3f;
    destination[3]  = (source[2] >> 0) & 0x3f;
    destination[4]  = (source[3] >> 2) & 0x3f;
    destination[5]  = (source[3] << 4) & 0x3f;
    destination[5] |= (source[4] >> 4) & 0x3f;
    destination[6]  = (source[4] << 2) & 0x3f;
    destination[6] |= (source[5] >> 6) & 0x3f;
    destination[7]  = (source[5] >> 0) & 0x3f;
  }
};
template <typename Tp>
struct __struct_bitpack_impl<Tp,1,7>
{
  static const size_t unit_size = 8;
  static const size_t bits_total = 56;
  static const size_t loop_total = 8;
  static const size_t bit_size = 7;
  static const Tp     mask = 0x7f;
  static inline
  void pack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] & 0x7f) << 1;
    destination[0] |= (source[1] & 0x7f) >> 6;
    destination[1]  = (source[1] & 0x7f) << 2;
    destination[1] |= (source[2] & 0x7f) >> 5;
    destination[2]  = (source[2] & 0x7f) << 3;
    destination[2] |= (source[3] & 0x7f) >> 4;
    destination[3]  = (source[3] & 0x7f) << 4;
    destination[3] |= (source[4] & 0x7f) >> 3;
    destination[4]  = (source[4] & 0x7f) << 5;
    destination[4] |= (source[5] & 0x7f) >> 2;
    destination[5]  = (source[5] & 0x7f) << 6;
    destination[5] |= (source[6] & 0x7f) >> 1;
    destination[6]  = (source[6] & 0x7f) << 7;
    destination[6] |= (source[7] & 0x7f) << 0;
  }
  static inline
  void unpack(const Tp* source, Tp* destination)
  {
    destination[0]  = (source[0] >> 1) & 0x7f;
    destination[1]  = (source[0] << 6) & 0x7f;
    destination[1] |= (source[1] >> 2) & 0x7f;
    destination[2]  = (source[1] << 5) & 0x7f;
    destination[2] |= (source[2] >> 3) & 0x7f;
    destination[3]  = (source[2] << 4) & 0x7f;
    destination[3] |= (source[3] >> 4) & 0x7f;
    destination[4]  = (source[3] << 3) & 0x7f;
    destination[4] |= (source[4] >> 5) & 0x7f;
    destination[5]  = (source[4] << 2) & 0x7f;
    destination[5] |= (source[5] >> 6) & 0x7f;
    destination[6]  = (source[5] << 1) & 0x7f;
    destination[6] |= (source[6] >> 7) & 0x7f;
    destination[7]  = (source[6] >> 0) & 0x7f;
  }
};
};
};
#endif
