cHg
===

A bit faster Mercurial client for Unix with per-user cmdserver daemon.

Install
-------

For local use:

1. Run `make local` (or `gmake local` on FreeBSD)
2. Create symlink to `chg` from your `PATH`

Debian:

1. Run `make deb`
2. Install by `sudo dpkg -i ../mercurial-chg_*.deb`

Other platforms:

1. Run `make install`

If you see `failed to import extension chgserver` error, extension modules
wouldn't be installed to the right path. In that case, you'll need to copy
`chgserver.py*` and `_chgutil.so` (or `_chgutil.dylib`) to the `hgext`
directory. You can get the installation path by `hg debuginstall`.

Usage
-----

Same as `hg`. e.g.

    % chg stat

You may want to add the alias:

    % alias hg=chg

To terminate background cmdserver:

    % chg --kill-chg-daemon

To reload configuration files:

    % chg --reload-chg-daemon

Environment Variables
---------------------

cHg updates `os.environ` on each request, but some variables cannot make an
effect. The following variables are specially handled by cHg:

* reload config if `HGPLAIN` or `HGPLAINEXCEPT` changed, but some behaviors
  may not change.
* `CHGHG` or `HG` is the path to the 'hg' executable spawned as the background
  cmdserver.

The following variables are available for testing purpose:

* `CHGDEBUG` enables debug message of cHg.
* `CHGSOCKNAME` specifies socket path of background cmdserver.
