/*
 * Description: GASNet Extended API Implementation for MXM conduit
 * Copyright (c)  2012, Mellanox Technologies LTD. All rights reserved.
 * Terms of use are as specified in license.txt
 */

#ifndef _GASNET_EXTENDED_FWD_H
#define _GASNET_EXTENDED_FWD_H

#define GASNET_EXTENDED_VERSION      1.0
#define GASNET_EXTENDED_VERSION_STR  _STRINGIFY(GASNET_EXTENDED_VERSION)
#define GASNET_EXTENDED_NAME         MXM
#define GASNET_EXTENDED_NAME_STR     _STRINGIFY(GASNET_EXTENDED_NAME)


#define _GASNET_HANDLE_T
/*  an opaque type representing a non-blocking operation in-progress initiated using the extended API */
struct _gasnete_op_t;

typedef enum {
    MXM_HANDLE_TYPE = 0,
    OP_HANDLE_TYPE = 1
} handle_type_t;

struct gasnet_handle_t {
    void *handle;
    handle_type_t type;
};
typedef struct gasnet_handle_t * gasnet_handle_t;

#define GASNET_INVALID_HANDLE ((gasnet_handle_t)0)
#define GASNETI_EOP_IS_HANDLE 0

/* this can be used to add statistical collection values
 *      specific to the extended API implementation (see gasnet_help.h) */
#define GASNETE_CONDUIT_STATS(CNT,VAL,TIME)  \
            GASNETI_VIS_STATS(CNT,VAL,TIME)      \
        GASNETI_COLL_STATS(CNT,VAL,TIME)     \
        CNT(C, DYNAMIC_THREADLOOKUP, cnt)


#define GASNETI_DIRECT_PUT      1
#define GASNETI_DIRECT_PUT_BULK 1
#define GASNETI_DIRECT_GET      1
#define GASNETI_DIRECT_GET_BULK 1
#define GASNETI_DIRECT_GET_NB   1
#define GASNETI_DIRECT_GET_NBI  1
#define GASNETI_DIRECT_PUT_NBI  1

#define GASNETE_CONDUIT_PRE_BARRIER(x) gasnetc_barrier_fence()

/* XXX: RDMADISSEM leads to error which need to be investigated! */
#define GASNETE_BARRIER_DEFAULT "AMDISSEM"

#define GASNETE_AUXSEG_DECLS \
                   extern gasneti_auxseg_request_t gasnete_barr_auxseg_alloc(gasnet_seginfo_t *auxseg_info);
#define GASNETE_AUXSEG_FNS() gasnete_barr_auxseg_alloc,

#endif //_GASNET_EXTENDED_FWD_H
