/***************************************************************
This code was generated by  Spiral 5.0 beta, www.spiral.net --
Copyright (c) 2005, Carnegie Mellon University
All rights reserved.
The code is distributed under a BSD style license
(see http://www.opensource.org/licenses/bsd-license.php)

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are
met:

* Redistributions of source code must retain the above copyright
  notice, reference to Spiral, this list of conditions and the
  following disclaimer.
* Redistributions in binary form must reproduce the above
  copyright notice, this list of conditions and the following
  disclaimer in the documentation and/or other materials provided
  with the distribution.
* Neither the name of Carnegie Mellon University nor the name of its
  contributors may be used to endorse or promote products derived from
  this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
*AS IS* AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
******************************************************************/

/*	CPU: Intel Core2Duo at 2660 MHz, 2 cores, SSE3
	OS: Microsoft WindowsXP 32-bit
	SVN: 5591 (modified)
	language: c.icl.opt
	timestamp: Dec 6, 2007; 13:44:5
	transform: DFT(512, 1)
	source file: "fft_512.c(.c)"
	performance: 20982 cycles, 2920 Mflop/s

algorithm: DFT_GT_CT( DFT(512, 1),
  GT_NthLoop( GT(DFT(16, 1), XChain([ 0, 1 ]), XChain([ 0, 1 ]), [ 32 ]),
    GT_Base( GT(DFT(16, 1), XChain([ 0 ]), XChain([ 0 ]), [  ]),
      DFT_CT( "T", DFT(16, 1),
        DFT_GT_CT( DFT(4, 1),
          GT_NthLoop( GT(DFT(2, 1), XChain([ 0, 1 ]), XChain([ 0, 1 ]), [ 2 ]),
            GT_Base( GT(DFT(2, 1), XChain([ 0 ]), XChain([ 0 ]), [  ]),
              DFT_Base( DFT(2, 1) ) ),
            Info_Base( InfoNt(1) ) ),
          GT_NthLoop( GT(DFT(2, 1), XChain([ 0, 1 ]), XChain([ 1, 0 ]), [ 2 ]),
            GT_Base( GT(DFT(2, 1), XChain([ 0 ]), XChain([ 0 ]), [  ]),
              DFT_Base( DFT(2, 1) ) ),
            Info_Base( InfoNt(1) ) ) ),
        DFT_GT_CT( DFT(4, 1),
          GT_NthLoop( GT(DFT(2, 1), XChain([ 0, 1 ]), XChain([ 0, 1 ]), [ 2 ]),
            GT_Base( GT(DFT(2, 1), XChain([ 0 ]), XChain([ 0 ]), [  ]),
              DFT_Base( DFT(2, 1) ) ),
            Info_Base( InfoNt(1) ) ),
          GT_NthLoop( GT(DFT(2, 1), XChain([ 0, 1 ]), XChain([ 1, 0 ]), [ 2 ]),
            GT_Base( GT(DFT(2, 1), XChain([ 0 ]), XChain([ 0 ]), [  ]),
              DFT_Base( DFT(2, 1) ) ),
            Info_Base( InfoNt(1) ) ) ) ) ),
    Info_Base( InfoNt(1) ) ),
  GT_NthLoop( GT(DFT(32, 1), XChain([ 0, 1 ]), XChain([ 1, 0 ]), [ 16 ]),
    GT_Base( GT(DFT(32, 1), XChain([ 0 ]), XChain([ 0 ]), [  ]),
      DFT_GT_CT( DFT(32, 1),
        GT_NthLoop( GT(DFT(4, 1), XChain([ 0, 1 ]), XChain([ 0, 1 ]), [ 8 ]),
          GT_Base( GT(DFT(4, 1), XChain([ 0 ]), XChain([ 0 ]), [  ]),
            DFT_GT_CT( DFT(4, 1),
              GT_NthLoop( GT(DFT(2, 1), XChain([ 0, 1 ]), XChain([ 0, 1 ]), [ 2 ]),
                GT_Base( GT(DFT(2, 1), XChain([ 0 ]), XChain([ 0 ]), [  ]),
                  DFT_Base( DFT(2, 1) ) ),
                Info_Base( InfoNt(1) ) ),
              GT_NthLoop( GT(DFT(2, 1), XChain([ 0, 1 ]), XChain([ 1, 0 ]), [ 2 ]),
                GT_Base( GT(DFT(2, 1), XChain([ 0 ]), XChain([ 0 ]), [  ]),
                  DFT_Base( DFT(2, 1) ) ),
                Info_Base( InfoNt(1) ) ) ) ),
          Info_Base( InfoNt(1) ) ),
        GT_NthLoop( GT(DFT(8, 1), XChain([ 0, 1 ]), XChain([ 1, 0 ]), [ 4 ]),
          GT_Base( GT(DFT(8, 1), XChain([ 0 ]), XChain([ 0 ]), [  ]),
            DFT_GT_CT( DFT(8, 1),
              GT_NthLoop( GT(DFT(2, 1), XChain([ 0, 1 ]), XChain([ 0, 1 ]), [ 4 ]),
                GT_Base( GT(DFT(2, 1), XChain([ 0 ]), XChain([ 0 ]), [  ]),
                  DFT_Base( DFT(2, 1) ) ),
                Info_Base( InfoNt(1) ) ),
              GT_NthLoop( GT(DFT(4, 1), XChain([ 0, 1 ]), XChain([ 1, 0 ]), [ 2 ]),
                GT_Base( GT(DFT(4, 1), XChain([ 0 ]), XChain([ 0 ]), [  ]),
                  DFT_GT_CT( DFT(4, 1),
                    GT_NthLoop( GT(DFT(2, 1), XChain([ 0, 1 ]), XChain([ 0, 1 ]), [ 2 ]),
                      GT_Base( GT(DFT(2, 1), XChain([ 0 ]), XChain([ 0 ]), [  ]),
                        DFT_Base( DFT(2, 1) ) ),
                      Info_Base( InfoNt(1) ) ),
                    GT_NthLoop( GT(DFT(2, 1), XChain([ 0, 1 ]), XChain([ 1, 0 ]), [ 2 ]),
                      GT_Base( GT(DFT(2, 1), XChain([ 0 ]), XChain([ 0 ]), [  ]),
                        DFT_Base( DFT(2, 1) ) ),
                      Info_Base( InfoNt(1) ) ) ) ),
                Info_Base( InfoNt(1) ) ) ) ),
          Info_Base( InfoNt(1) ) ) ) ),
    Info_Base( InfoNt(1) ) ) )
*/

#include <include/omega64c.h>
static _Complex double D4[512];

void init_fft512() {
    for(int i537 = 0; i537 <= 31; i537++) {
        for(int i542 = 0; i542 <= 3; i542++) {
            for(int i548 = 0; i548 <= 1; i548++) {
                D4[((i537*16) + (i542*4) + (i548*2))] = omega(512, ((i542 + (i548*4))*i537));
                D4[((i537*16) + (i542*4) + (i548*2) + 1)] = omega(512, ((i542 + (i548*4) + 8)*i537));
            }
        }
    }
}

void fft512(_Complex double  *Y, _Complex double  *X) {
    static _Complex double T127[512];
    for(int i538 = 0; i538 <= 15; i538++) {
        _Complex double s1078, s1079, s1080, s1081, s1082, s1083, s1084, 
            s1085, s1086, s1087, s1088, s1089, s1090, s1091, s1092, 
            s1093, s1094, s1095, s1096, s1097, s1098, s1099, s1100, 
            s1101, s1102, s1103, s1104, s1105, s1106, s1107, s1108, 
            s1109, s1110, s1111, s1112, s1113, s1114, s1115, s1116, 
            s1117, s1118, s1119, s1120, s1121, s1122, s1123, s1124, 
            s1125, s1126, s1127, s1128, s1129, s1130, s1131, s1132, 
            s1133, s1134, s1135, s1136, s1137, s1138, s1139, s1140, 
            s1141, s1142, s1143, s1144, s1145, s1146, s1147, s1148, 
            s1149, s1150, s1151, s1152, s1153, s1154, s1155, s1156, 
            s1157, s1158, t1966, t1967, t1968, t1969, t1970, t1971, 
            t1972, t1973, t1974, t1975, t1976, t1977, t1978, t1979, 
            t1980, t1981, t1982, t1983, t1984, t1985, t1986, t1987, 
            t1988, t1989, t1990, t1991, t1992, t1993, t1994, t1995, 
            t1996, t1997, t1998, t1999, t2000, t2001, t2002, t2003, 
            t2004, t2005, t2006, t2007, t2008, t2009, t2010, t2011, 
            t2012, t2013, t2014, t2015, t2016, t2017, t2018, t2019, 
            t2020, t2021, t2022, t2023, t2024, t2025, t2026, t2027, 
            t2028, t2029, t2030, t2031, t2032, t2033, t2034, t2035, 
            t2036, t2037, t2038, t2039, t2040, t2041, t2042, t2043, 
            t2044;
        int a961;
        s1078 = X[i538];
        s1079 = X[(i538 + 256)];
        t1966 = (s1078 + s1079);
        t1967 = (s1078 - s1079);
        s1080 = X[(i538 + 128)];
        s1081 = X[(384 + i538)];
        t1968 = (s1080 + s1081);
        t1969 = (t1966 + t1968);
        t1970 = (t1966 - t1968);
        s1082 = (__I__*(s1080 - s1081));
        t1971 = (t1967 + s1082);
        t1972 = (t1967 - s1082);
        s1083 = X[(i538 + 64)];
        s1084 = X[(320 + i538)];
        t1973 = (s1083 + s1084);
        t1974 = (s1083 - s1084);
        s1085 = X[(i538 + 192)];
        s1086 = X[(448 + i538)];
        t1975 = (s1085 + s1086);
        t1976 = (t1973 + t1975);
        s1087 = (__I__*(s1085 - s1086));
        t1977 = (t1969 + t1976);
        t1978 = (t1969 - t1976);
        s1088 = ((0.70710678118654757 + __I__ * 0.70710678118654757)*(t1974 + s1087));
        t1979 = (t1971 + s1088);
        t1980 = (t1971 - s1088);
        s1089 = (__I__*(t1973 - t1975));
        t1981 = (t1970 + s1089);
        t1982 = (t1970 - s1089);
        s1090 = ((-0.70710678118654757 + __I__ * 0.70710678118654757)*(t1974 - s1087));
        t1983 = (t1972 + s1090);
        t1984 = (t1972 - s1090);
        s1091 = X[(i538 + 16)];
        s1092 = X[(272 + i538)];
        t1985 = (s1091 + s1092);
        t1986 = (s1091 - s1092);
        s1093 = X[(i538 + 144)];
        s1094 = X[(400 + i538)];
        t1987 = (s1093 + s1094);
        t1988 = (t1985 + t1987);
        t1989 = (t1985 - t1987);
        s1095 = (__I__*(s1093 - s1094));
        t1990 = (t1986 + s1095);
        t1991 = (t1986 - s1095);
        s1096 = X[(i538 + 80)];
        s1097 = X[(336 + i538)];
        t1992 = (s1096 + s1097);
        t1993 = (s1096 - s1097);
        s1098 = X[(i538 + 208)];
        s1099 = X[(464 + i538)];
        t1994 = (s1098 + s1099);
        t1995 = (t1992 + t1994);
        s1100 = (__I__*(s1098 - s1099));
        t1996 = (t1988 + t1995);
        s1101 = ((0.70710678118654757 + __I__ * 0.70710678118654757)*(t1993 + s1100));
        s1102 = (__I__*(t1992 - t1994));
        s1103 = ((-0.70710678118654757 + __I__ * 0.70710678118654757)*(t1993 - s1100));
        s1104 = X[(i538 + 32)];
        s1105 = X[(288 + i538)];
        t1997 = (s1104 + s1105);
        t1998 = (s1104 - s1105);
        s1106 = X[(i538 + 160)];
        s1107 = X[(416 + i538)];
        t1999 = (s1106 + s1107);
        t2000 = (t1997 + t1999);
        t2001 = (t1997 - t1999);
        s1108 = (__I__*(s1106 - s1107));
        t2002 = (t1998 + s1108);
        t2003 = (t1998 - s1108);
        s1109 = X[(i538 + 96)];
        s1110 = X[(352 + i538)];
        t2004 = (s1109 + s1110);
        t2005 = (s1109 - s1110);
        s1111 = X[(i538 + 224)];
        s1112 = X[(480 + i538)];
        t2006 = (s1111 + s1112);
        t2007 = (t2004 + t2006);
        s1113 = (__I__*(s1111 - s1112));
        t2008 = (t2000 + t2007);
        s1114 = ((0.70710678118654757 + __I__ * 0.70710678118654757)*(t2005 + s1113));
        s1115 = (__I__*(t2004 - t2006));
        s1116 = ((-0.70710678118654757 + __I__ * 0.70710678118654757)*(t2005 - s1113));
        s1117 = X[(i538 + 48)];
        s1118 = X[(304 + i538)];
        t2009 = (s1117 + s1118);
        t2010 = (s1117 - s1118);
        s1119 = X[(i538 + 176)];
        s1120 = X[(432 + i538)];
        t2011 = (s1119 + s1120);
        t2012 = (t2009 + t2011);
        t2013 = (t2009 - t2011);
        s1121 = (__I__*(s1119 - s1120));
        t2014 = (t2010 + s1121);
        t2015 = (t2010 - s1121);
        s1122 = X[(i538 + 112)];
        s1123 = X[(368 + i538)];
        t2016 = (s1122 + s1123);
        t2017 = (s1122 - s1123);
        s1124 = X[(i538 + 240)];
        s1125 = X[(496 + i538)];
        t2018 = (s1124 + s1125);
        t2019 = (t2016 + t2018);
        s1126 = (__I__*(s1124 - s1125));
        t2020 = (t2012 + t2019);
        s1127 = ((0.70710678118654757 + __I__ * 0.70710678118654757)*(t2017 + s1126));
        s1128 = (__I__*(t2016 - t2018));
        s1129 = ((-0.70710678118654757 + __I__ * 0.70710678118654757)*(t2017 - s1126));
        t2021 = (t1977 + t2008);
        t2022 = (t1977 - t2008);
        t2023 = (t1996 + t2020);
        a961 = (32*i538);
        T127[a961] = (t2021 + t2023);
        T127[(16 + a961)] = (t2021 - t2023);
        s1130 = (__I__*(t1996 - t2020));
        T127[(8 + a961)] = (t2022 + s1130);
        T127[(24 + a961)] = (t2022 - s1130);
        s1131 = ((0.92387953251128674 + __I__ * 0.38268343236508978)*(t2002 + s1114));
        t2024 = (t1979 + s1131);
        t2025 = (t1979 - s1131);
        s1132 = ((0.98078528040323043 + __I__ * 0.19509032201612825)*(t1990 + s1101));
        s1133 = ((0.83146961230254524 + __I__ * 0.55557023301960218)*(t2014 + s1127));
        t2026 = (s1132 + s1133);
        T127[(1 + a961)] = (t2024 + t2026);
        T127[(17 + a961)] = (t2024 - t2026);
        s1134 = (__I__*(s1132 - s1133));
        T127[(9 + a961)] = (t2025 + s1134);
        T127[(25 + a961)] = (t2025 - s1134);
        s1135 = ((0.70710678118654757 + __I__ * 0.70710678118654757)*(t2001 + s1115));
        t2027 = (t1981 + s1135);
        t2028 = (t1981 - s1135);
        s1136 = ((0.92387953251128674 + __I__ * 0.38268343236508978)*(t1989 + s1102));
        s1137 = ((0.38268343236508978 + __I__ * 0.92387953251128674)*(t2013 + s1128));
        t2029 = (s1136 + s1137);
        T127[(2 + a961)] = (t2027 + t2029);
        T127[(18 + a961)] = (t2027 - t2029);
        s1138 = (__I__*(s1136 - s1137));
        T127[(10 + a961)] = (t2028 + s1138);
        T127[(26 + a961)] = (t2028 - s1138);
        s1139 = ((0.38268343236508978 + __I__ * 0.92387953251128674)*(t2003 + s1116));
        t2030 = (t1983 + s1139);
        t2031 = (t1983 - s1139);
        s1140 = ((0.83146961230254524 + __I__ * 0.55557023301960218)*(t1991 + s1103));
        s1141 = ((-0.19509032201612825 + __I__ * 0.98078528040323043)*(t2015 + s1129));
        t2032 = (s1140 + s1141);
        T127[(3 + a961)] = (t2030 + t2032);
        T127[(19 + a961)] = (t2030 - t2032);
        s1142 = (__I__*(s1140 - s1141));
        T127[(11 + a961)] = (t2031 + s1142);
        T127[(27 + a961)] = (t2031 - s1142);
        s1143 = (__I__*(t2000 - t2007));
        t2033 = (t1978 + s1143);
        t2034 = (t1978 - s1143);
        s1144 = ((0.70710678118654757 + __I__ * 0.70710678118654757)*(t1988 - t1995));
        s1145 = ((-0.70710678118654757 + __I__ * 0.70710678118654757)*(t2012 - t2019));
        t2035 = (s1144 + s1145);
        T127[(4 + a961)] = (t2033 + t2035);
        T127[(20 + a961)] = (t2033 - t2035);
        s1146 = (__I__*(s1144 - s1145));
        T127[(12 + a961)] = (t2034 + s1146);
        T127[(28 + a961)] = (t2034 - s1146);
        s1147 = ((-0.38268343236508978 + __I__ * 0.92387953251128674)*(t2002 - s1114));
        t2036 = (t1980 + s1147);
        t2037 = (t1980 - s1147);
        s1148 = ((0.55557023301960218 + __I__ * 0.83146961230254524)*(t1990 - s1101));
        s1149 = ((-0.98078528040323043 + __I__ * 0.19509032201612825)*(t2014 - s1127));
        t2038 = (s1148 + s1149);
        T127[(5 + a961)] = (t2036 + t2038);
        T127[(21 + a961)] = (t2036 - t2038);
        s1150 = (__I__*(s1148 - s1149));
        T127[(13 + a961)] = (t2037 + s1150);
        T127[(29 + a961)] = (t2037 - s1150);
        s1151 = ((-0.70710678118654757 + __I__ * 0.70710678118654757)*(t2001 - s1115));
        t2039 = (t1982 + s1151);
        t2040 = (t1982 - s1151);
        s1152 = ((0.38268343236508978 + __I__ * 0.92387953251128674)*(t1989 - s1102));
        s1153 = ((-0.92387953251128674 - __I__ * 0.38268343236508978)*(t2013 - s1128));
        t2041 = (s1152 + s1153);
        T127[(6 + a961)] = (t2039 + t2041);
        T127[(22 + a961)] = (t2039 - t2041);
        s1154 = (__I__*(s1152 - s1153));
        T127[(14 + a961)] = (t2040 + s1154);
        T127[(30 + a961)] = (t2040 - s1154);
        s1155 = ((-0.92387953251128674 + __I__ * 0.38268343236508978)*(t2003 - s1116));
        t2042 = (t1984 + s1155);
        t2043 = (t1984 - s1155);
        s1156 = ((0.19509032201612825 + __I__ * 0.98078528040323043)*(t1991 - s1103));
        s1157 = ((-0.55557023301960218 - __I__ * 0.83146961230254524)*(t2015 - s1129));
        t2044 = (s1156 + s1157);
        T127[(7 + a961)] = (t2042 + t2044);
        T127[(23 + a961)] = (t2042 - t2044);
        s1158 = (__I__*(s1156 - s1157));
        T127[(15 + a961)] = (t2043 + s1158);
        T127[(31 + a961)] = (t2043 - s1158);
    }
    for(int i537 = 0; i537 <= 31; i537++) {
        _Complex double s1257, s1258, s1259, s1260, s1261, s1262, s1263, 
            s1264, s1265, s1266, s1267, s1268, s1269, s1270, s1271, 
            s1272, s1273, s1274, s1275, s1276, s1277, s1278, s1279, 
            s1280, s1281, s1282, s1283, s1284, s1285, s1286, s1287, 
            s1288, s1289, t2173, t2174, t2175, t2176, t2177, t2178, 
            t2179, t2180, t2181, t2182, t2183, t2184, t2185, t2186, 
            t2187, t2188, t2189, t2190, t2191, t2192, t2193, t2194, 
            t2195, t2196, t2197, t2198, t2199, t2200, t2201, t2202, 
            t2203;
        int a1086, a1087, a1088, a1089, a1090, a1091, a1092, 
            a1093, a1094, a1095, a1096, a1097, a1098, a1099, a1100, 
            a1101;
        a1086 = (i537 + 256);
        a1087 = (16*i537);
        s1257 = (D4[a1087]*T127[i537]);
        s1258 = (D4[(1 + a1087)]*T127[a1086]);
        t2173 = (s1257 + s1258);
        t2174 = (s1257 - s1258);
        a1088 = (i537 + 128);
        a1089 = (384 + i537);
        s1259 = (D4[(2 + a1087)]*T127[a1088]);
        s1260 = (D4[(3 + a1087)]*T127[a1089]);
        t2175 = (s1259 + s1260);
        t2176 = (t2173 + t2175);
        t2177 = (t2173 - t2175);
        s1261 = (__I__*(s1259 - s1260));
        t2178 = (t2174 + s1261);
        t2179 = (t2174 - s1261);
        a1090 = (i537 + 32);
        a1091 = (288 + i537);
        s1262 = (D4[(4 + a1087)]*T127[a1090]);
        s1263 = (D4[(5 + a1087)]*T127[a1091]);
        t2180 = (s1262 + s1263);
        t2181 = (s1262 - s1263);
        a1092 = (i537 + 160);
        a1093 = (416 + i537);
        s1264 = (D4[(6 + a1087)]*T127[a1092]);
        s1265 = (D4[(7 + a1087)]*T127[a1093]);
        t2182 = (s1264 + s1265);
        t2183 = (t2180 + t2182);
        s1266 = ((0.70710678118654757 + __I__ * 0.70710678118654757)*(t2180 - t2182));
        s1267 = (__I__*(s1264 - s1265));
        s1268 = ((0.92387953251128674 + __I__ * 0.38268343236508978)*(t2181 + s1267));
        s1269 = ((0.38268343236508978 + __I__ * 0.92387953251128674)*(t2181 - s1267));
        a1094 = (i537 + 64);
        a1095 = (320 + i537);
        s1270 = (D4[(8 + a1087)]*T127[a1094]);
        s1271 = (D4[(9 + a1087)]*T127[a1095]);
        t2184 = (s1270 + s1271);
        t2185 = (s1270 - s1271);
        a1096 = (i537 + 192);
        a1097 = (448 + i537);
        s1272 = (D4[(10 + a1087)]*T127[a1096]);
        s1273 = (D4[(11 + a1087)]*T127[a1097]);
        t2186 = (s1272 + s1273);
        t2187 = (t2184 + t2186);
        s1274 = (__I__*(t2184 - t2186));
        s1275 = (__I__*(s1272 - s1273));
        s1276 = ((0.70710678118654757 + __I__ * 0.70710678118654757)*(t2185 + s1275));
        s1277 = ((-0.70710678118654757 + __I__ * 0.70710678118654757)*(t2185 - s1275));
        a1098 = (i537 + 96);
        a1099 = (352 + i537);
        s1278 = (D4[(12 + a1087)]*T127[a1098]);
        s1279 = (D4[(13 + a1087)]*T127[a1099]);
        t2188 = (s1278 + s1279);
        t2189 = (s1278 - s1279);
        a1100 = (i537 + 224);
        a1101 = (480 + i537);
        s1280 = (D4[(14 + a1087)]*T127[a1100]);
        s1281 = (D4[(15 + a1087)]*T127[a1101]);
        t2190 = (s1280 + s1281);
        t2191 = (t2188 + t2190);
        s1282 = ((-0.70710678118654757 + __I__ * 0.70710678118654757)*(t2188 - t2190));
        s1283 = (__I__*(s1280 - s1281));
        s1284 = ((0.38268343236508978 + __I__ * 0.92387953251128674)*(t2189 + s1283));
        s1285 = ((-0.92387953251128674 - __I__ * 0.38268343236508978)*(t2189 - s1283));
        t2192 = (t2176 + t2187);
        t2193 = (t2176 - t2187);
        t2194 = (t2183 + t2191);
        Y[i537] = (t2192 + t2194);
        Y[a1086] = (t2192 - t2194);
        s1286 = (__I__*(t2183 - t2191));
        Y[a1088] = (t2193 + s1286);
        Y[a1089] = (t2193 - s1286);
        t2195 = (t2178 + s1276);
        t2196 = (t2178 - s1276);
        t2197 = (s1268 + s1284);
        Y[a1090] = (t2195 + t2197);
        Y[a1091] = (t2195 - t2197);
        s1287 = (__I__*(s1268 - s1284));
        Y[a1092] = (t2196 + s1287);
        Y[a1093] = (t2196 - s1287);
        t2198 = (t2177 + s1274);
        t2199 = (t2177 - s1274);
        t2200 = (s1266 + s1282);
        Y[a1094] = (t2198 + t2200);
        Y[a1095] = (t2198 - t2200);
        s1288 = (__I__*(s1266 - s1282));
        Y[a1096] = (t2199 + s1288);
        Y[a1097] = (t2199 - s1288);
        t2201 = (t2179 + s1277);
        t2202 = (t2179 - s1277);
        t2203 = (s1269 + s1285);
        Y[a1098] = (t2201 + t2203);
        Y[a1099] = (t2201 - t2203);
        s1289 = (__I__*(s1269 - s1285));
        Y[a1100] = (t2202 + s1289);
        Y[a1101] = (t2202 - s1289);
    }
}
