/***************************************************************
This code was generated by  Spiral 5.0 beta, www.spiral.net --
Copyright (c) 2005, Carnegie Mellon University
All rights reserved.
The code is distributed under a BSD style license
(see http://www.opensource.org/licenses/bsd-license.php)

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are
met:

* Redistributions of source code must retain the above copyright
  notice, reference to Spiral, this list of conditions and the
  following disclaimer.
* Redistributions in binary form must reproduce the above
  copyright notice, this list of conditions and the following
  disclaimer in the documentation and/or other materials provided
  with the distribution.
* Neither the name of Carnegie Mellon University nor the name of its
  contributors may be used to endorse or promote products derived from
  this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
*AS IS* AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
******************************************************************/

/*	CPU: Intel Core2Duo at 2660 MHz, 2 cores, SSE3
	OS: Microsoft WindowsXP 32-bit
	SVN: 5591 (modified)
	language: c.icl.opt
	timestamp: Dec 6, 2007; 13:43:57
	transform: DFT(128, 1)
	source file: "fft_128.c(.c)"
	performance: 3880 cycles, 3071 Mflop/s

algorithm: DFT_GT_CT( DFT(128, 1),
  GT_NthLoop( GT(DFT(32, 1), XChain([ 0, 1 ]), XChain([ 0, 1 ]), [ 4 ]),
    GT_Base( GT(DFT(32, 1), XChain([ 0 ]), XChain([ 0 ]), [  ]),
      DFT_GT_CT( DFT(32, 1),
        GT_NthLoop( GT(DFT(4, 1), XChain([ 0, 1 ]), XChain([ 0, 1 ]), [ 8 ]),
          GT_Base( GT(DFT(4, 1), XChain([ 0 ]), XChain([ 0 ]), [  ]),
            DFT_GT_CT( DFT(4, 1),
              GT_NthLoop( GT(DFT(2, 1), XChain([ 0, 1 ]), XChain([ 0, 1 ]), [ 2 ]),
                GT_Base( GT(DFT(2, 1), XChain([ 0 ]), XChain([ 0 ]), [  ]),
                  DFT_Base( DFT(2, 1) ) ),
                Info_Base( InfoNt(1) ) ),
              GT_NthLoop( GT(DFT(2, 1), XChain([ 0, 1 ]), XChain([ 1, 0 ]), [ 2 ]),
                GT_Base( GT(DFT(2, 1), XChain([ 0 ]), XChain([ 0 ]), [  ]),
                  DFT_Base( DFT(2, 1) ) ),
                Info_Base( InfoNt(1) ) ) ) ),
          Info_Base( InfoNt(1) ) ),
        GT_NthLoop( GT(DFT(8, 1), XChain([ 0, 1 ]), XChain([ 1, 0 ]), [ 4 ]),
          GT_Base( GT(DFT(8, 1), XChain([ 0 ]), XChain([ 0 ]), [  ]),
            DFT_GT_CT( DFT(8, 1),
              GT_NthLoop( GT(DFT(2, 1), XChain([ 0, 1 ]), XChain([ 0, 1 ]), [ 4 ]),
                GT_Base( GT(DFT(2, 1), XChain([ 0 ]), XChain([ 0 ]), [  ]),
                  DFT_Base( DFT(2, 1) ) ),
                Info_Base( InfoNt(1) ) ),
              GT_NthLoop( GT(DFT(4, 1), XChain([ 0, 1 ]), XChain([ 1, 0 ]), [ 2 ]),
                GT_Base( GT(DFT(4, 1), XChain([ 0 ]), XChain([ 0 ]), [  ]),
                  DFT_GT_CT( DFT(4, 1),
                    GT_NthLoop( GT(DFT(2, 1), XChain([ 0, 1 ]), XChain([ 0, 1 ]), [ 2 ]),
                      GT_Base( GT(DFT(2, 1), XChain([ 0 ]), XChain([ 0 ]), [  ]),
                        DFT_Base( DFT(2, 1) ) ),
                      Info_Base( InfoNt(1) ) ),
                    GT_NthLoop( GT(DFT(2, 1), XChain([ 0, 1 ]), XChain([ 1, 0 ]), [ 2 ]),
                      GT_Base( GT(DFT(2, 1), XChain([ 0 ]), XChain([ 0 ]), [  ]),
                        DFT_Base( DFT(2, 1) ) ),
                      Info_Base( InfoNt(1) ) ) ) ),
                Info_Base( InfoNt(1) ) ) ) ),
          Info_Base( InfoNt(1) ) ) ) ),
    Info_Base( InfoNt(1) ) ),
  GT_NthLoop( GT(DFT(4, 1), XChain([ 0, 1 ]), XChain([ 1, 0 ]), [ 32 ]),
    GT_Base( GT(DFT(4, 1), XChain([ 0 ]), XChain([ 0 ]), [  ]),
      DFT_GT_CT( DFT(4, 1),
        GT_NthLoop( GT(DFT(2, 1), XChain([ 0, 1 ]), XChain([ 0, 1 ]), [ 2 ]),
          GT_Base( GT(DFT(2, 1), XChain([ 0 ]), XChain([ 0 ]), [  ]),
            DFT_Base( DFT(2, 1) ) ),
          Info_Base( InfoNt(1) ) ),
        GT_NthLoop( GT(DFT(2, 1), XChain([ 0, 1 ]), XChain([ 1, 0 ]), [ 2 ]),
          GT_Base( GT(DFT(2, 1), XChain([ 0 ]), XChain([ 0 ]), [  ]),
            DFT_Base( DFT(2, 1) ) ),
          Info_Base( InfoNt(1) ) ) ) ),
    Info_Base( InfoNt(1) ) ) )
*/

#include <include/omega64c.h>
static _Complex double D2[128];

void init_fft128() {
    for(int i289 = 0; i289 <= 3; i289++) {
        for(int i292 = 0; i292 <= 3; i292++) {
            for(int i298 = 0; i298 <= 1; i298++) {
                for(int i300 = 0; i300 <= 1; i300++) {
                    D2[((i289*32) + (i292*8) + (i298*4) + (i300*2))] = omega(128, ((i292 + ((i298 + (i300*2))*4))*i289));
                    D2[((i289*32) + (i292*8) + (i298*4) + (i300*2) + 1)] = omega(128, ((i292 + ((i298 + (i300*2))*4) + 16)*i289));
                }
            }
        }
    }
}

void fft128(_Complex double  *Y, _Complex double  *X) {
    static _Complex double T71[128];
    for(int i290 = 0; i290 <= 31; i290++) {
        _Complex double s373, s374, s375, s376, s377, t892, t893, 
            t894;
        int a300;
        s373 = X[i290];
        s374 = X[(i290 + 64)];
        t892 = (s373 + s374);
        t893 = (s373 - s374);
        s375 = X[(i290 + 32)];
        s376 = X[(96 + i290)];
        t894 = (s375 + s376);
        a300 = (4*i290);
        T71[a300] = (t892 + t894);
        T71[(a300 + 2)] = (t892 - t894);
        s377 = (__I__*(s375 - s376));
        T71[(a300 + 1)] = (t893 + s377);
        T71[(3 + a300)] = (t893 - s377);
    }
    for(int i289 = 0; i289 <= 3; i289++) {
        _Complex double s605, s606, s607, s608, s609, s610, s611, 
            s612, s613, s614, s615, s616, s617, s618, s619, 
            s620, s621, s622, s623, s624, s625, s626, s627, 
            s628, s629, s630, s631, s632, s633, s634, s635, 
            s636, s637, s638, s639, s640, s641, s642, s643, 
            s644, s645, s646, s647, s648, s649, s650, s651, 
            s652, s653, s654, s655, s656, s657, s658, s659, 
            s660, s661, s662, s663, s664, s665, s666, s667, 
            s668, s669, s670, s671, s672, s673, s674, s675, 
            s676, s677, s678, s679, s680, s681, s682, s683, 
            s684, s685, t1215, t1216, t1217, t1218, t1219, t1220, 
            t1221, t1222, t1223, t1224, t1225, t1226, t1227, t1228, 
            t1229, t1230, t1231, t1232, t1233, t1234, t1235, t1236, 
            t1237, t1238, t1239, t1240, t1241, t1242, t1243, t1244, 
            t1245, t1246, t1247, t1248, t1249, t1250, t1251, t1252, 
            t1253, t1254, t1255, t1256, t1257, t1258, t1259, t1260, 
            t1261, t1262, t1263, t1264, t1265, t1266, t1267, t1268, 
            t1269, t1270, t1271, t1272, t1273, t1274, t1275, t1276, 
            t1277, t1278, t1279, t1280, t1281, t1282, t1283, t1284, 
            t1285, t1286, t1287, t1288, t1289, t1290, t1291, t1292, 
            t1293;
        int a554, a555, a556, a557, a558, a559, a560, 
            a561, a562, a563, a564, a565, a566, a567, a568, 
            a569, a570, a571, a572, a573, a574, a575, a576, 
            a577, a578, a579, a580, a581, a582, a583, a584, 
            a585;
        a554 = (i289 + 64);
        a555 = (32*i289);
        s605 = (D2[a555]*T71[i289]);
        s606 = (D2[(1 + a555)]*T71[a554]);
        t1215 = (s605 + s606);
        t1216 = (s605 - s606);
        a556 = (i289 + 32);
        a557 = (96 + i289);
        s607 = (D2[(2 + a555)]*T71[a556]);
        s608 = (D2[(3 + a555)]*T71[a557]);
        t1217 = (s607 + s608);
        t1218 = (t1215 + t1217);
        t1219 = (t1215 - t1217);
        s609 = (__I__*(s607 - s608));
        t1220 = (t1216 + s609);
        t1221 = (t1216 - s609);
        a558 = (i289 + 16);
        a559 = (80 + i289);
        s610 = (D2[(4 + a555)]*T71[a558]);
        s611 = (D2[(5 + a555)]*T71[a559]);
        t1222 = (s610 + s611);
        t1223 = (s610 - s611);
        a560 = (i289 + 48);
        a561 = (112 + i289);
        s612 = (D2[(6 + a555)]*T71[a560]);
        s613 = (D2[(7 + a555)]*T71[a561]);
        t1224 = (s612 + s613);
        t1225 = (t1222 + t1224);
        s614 = (__I__*(s612 - s613));
        t1226 = (t1218 + t1225);
        t1227 = (t1218 - t1225);
        s615 = ((0.70710678118654757 + __I__ * 0.70710678118654757)*(t1223 + s614));
        t1228 = (t1220 + s615);
        t1229 = (t1220 - s615);
        s616 = (__I__*(t1222 - t1224));
        t1230 = (t1219 + s616);
        t1231 = (t1219 - s616);
        s617 = ((-0.70710678118654757 + __I__ * 0.70710678118654757)*(t1223 - s614));
        t1232 = (t1221 + s617);
        t1233 = (t1221 - s617);
        a562 = (i289 + 4);
        a563 = (68 + i289);
        s618 = (D2[(8 + a555)]*T71[a562]);
        s619 = (D2[(9 + a555)]*T71[a563]);
        t1234 = (s618 + s619);
        t1235 = (s618 - s619);
        a564 = (i289 + 36);
        a565 = (100 + i289);
        s620 = (D2[(10 + a555)]*T71[a564]);
        s621 = (D2[(11 + a555)]*T71[a565]);
        t1236 = (s620 + s621);
        t1237 = (t1234 + t1236);
        t1238 = (t1234 - t1236);
        s622 = (__I__*(s620 - s621));
        t1239 = (t1235 + s622);
        t1240 = (t1235 - s622);
        a566 = (i289 + 20);
        a567 = (84 + i289);
        s623 = (D2[(12 + a555)]*T71[a566]);
        s624 = (D2[(13 + a555)]*T71[a567]);
        t1241 = (s623 + s624);
        t1242 = (s623 - s624);
        a568 = (i289 + 52);
        a569 = (116 + i289);
        s625 = (D2[(14 + a555)]*T71[a568]);
        s626 = (D2[(15 + a555)]*T71[a569]);
        t1243 = (s625 + s626);
        t1244 = (t1241 + t1243);
        s627 = (__I__*(s625 - s626));
        t1245 = (t1237 + t1244);
        s628 = ((0.70710678118654757 + __I__ * 0.70710678118654757)*(t1242 + s627));
        s629 = (__I__*(t1241 - t1243));
        s630 = ((-0.70710678118654757 + __I__ * 0.70710678118654757)*(t1242 - s627));
        a570 = (i289 + 8);
        a571 = (72 + i289);
        s631 = (D2[(16 + a555)]*T71[a570]);
        s632 = (D2[(17 + a555)]*T71[a571]);
        t1246 = (s631 + s632);
        t1247 = (s631 - s632);
        a572 = (i289 + 40);
        a573 = (104 + i289);
        s633 = (D2[(18 + a555)]*T71[a572]);
        s634 = (D2[(19 + a555)]*T71[a573]);
        t1248 = (s633 + s634);
        t1249 = (t1246 + t1248);
        t1250 = (t1246 - t1248);
        s635 = (__I__*(s633 - s634));
        t1251 = (t1247 + s635);
        t1252 = (t1247 - s635);
        a574 = (i289 + 24);
        a575 = (88 + i289);
        s636 = (D2[(20 + a555)]*T71[a574]);
        s637 = (D2[(21 + a555)]*T71[a575]);
        t1253 = (s636 + s637);
        t1254 = (s636 - s637);
        a576 = (i289 + 56);
        a577 = (120 + i289);
        s638 = (D2[(22 + a555)]*T71[a576]);
        s639 = (D2[(23 + a555)]*T71[a577]);
        t1255 = (s638 + s639);
        t1256 = (t1253 + t1255);
        s640 = (__I__*(s638 - s639));
        t1257 = (t1249 + t1256);
        s641 = ((0.70710678118654757 + __I__ * 0.70710678118654757)*(t1254 + s640));
        s642 = (__I__*(t1253 - t1255));
        s643 = ((-0.70710678118654757 + __I__ * 0.70710678118654757)*(t1254 - s640));
        a578 = (i289 + 12);
        a579 = (76 + i289);
        s644 = (D2[(24 + a555)]*T71[a578]);
        s645 = (D2[(25 + a555)]*T71[a579]);
        t1258 = (s644 + s645);
        t1259 = (s644 - s645);
        a580 = (i289 + 44);
        a581 = (108 + i289);
        s646 = (D2[(26 + a555)]*T71[a580]);
        s647 = (D2[(27 + a555)]*T71[a581]);
        t1260 = (s646 + s647);
        t1261 = (t1258 + t1260);
        t1262 = (t1258 - t1260);
        s648 = (__I__*(s646 - s647));
        t1263 = (t1259 + s648);
        t1264 = (t1259 - s648);
        a582 = (i289 + 28);
        a583 = (92 + i289);
        s649 = (D2[(28 + a555)]*T71[a582]);
        s650 = (D2[(29 + a555)]*T71[a583]);
        t1265 = (s649 + s650);
        t1266 = (s649 - s650);
        a584 = (i289 + 60);
        a585 = (124 + i289);
        s651 = (D2[(30 + a555)]*T71[a584]);
        s652 = (D2[(31 + a555)]*T71[a585]);
        t1267 = (s651 + s652);
        t1268 = (t1265 + t1267);
        s653 = (__I__*(s651 - s652));
        t1269 = (t1261 + t1268);
        s654 = ((0.70710678118654757 + __I__ * 0.70710678118654757)*(t1266 + s653));
        s655 = (__I__*(t1265 - t1267));
        s656 = ((-0.70710678118654757 + __I__ * 0.70710678118654757)*(t1266 - s653));
        t1270 = (t1226 + t1257);
        t1271 = (t1226 - t1257);
        t1272 = (t1245 + t1269);
        Y[i289] = (t1270 + t1272);
        Y[a554] = (t1270 - t1272);
        s657 = (__I__*(t1245 - t1269));
        Y[a556] = (t1271 + s657);
        Y[a557] = (t1271 - s657);
        s658 = ((0.92387953251128674 + __I__ * 0.38268343236508978)*(t1251 + s641));
        t1273 = (t1228 + s658);
        t1274 = (t1228 - s658);
        s659 = ((0.98078528040323043 + __I__ * 0.19509032201612825)*(t1239 + s628));
        s660 = ((0.83146961230254524 + __I__ * 0.55557023301960218)*(t1263 + s654));
        t1275 = (s659 + s660);
        Y[a562] = (t1273 + t1275);
        Y[a563] = (t1273 - t1275);
        s661 = (__I__*(s659 - s660));
        Y[a564] = (t1274 + s661);
        Y[a565] = (t1274 - s661);
        s662 = ((0.70710678118654757 + __I__ * 0.70710678118654757)*(t1250 + s642));
        t1276 = (t1230 + s662);
        t1277 = (t1230 - s662);
        s663 = ((0.92387953251128674 + __I__ * 0.38268343236508978)*(t1238 + s629));
        s664 = ((0.38268343236508978 + __I__ * 0.92387953251128674)*(t1262 + s655));
        t1278 = (s663 + s664);
        Y[a570] = (t1276 + t1278);
        Y[a571] = (t1276 - t1278);
        s665 = (__I__*(s663 - s664));
        Y[a572] = (t1277 + s665);
        Y[a573] = (t1277 - s665);
        s666 = ((0.38268343236508978 + __I__ * 0.92387953251128674)*(t1252 + s643));
        t1279 = (t1232 + s666);
        t1280 = (t1232 - s666);
        s667 = ((0.83146961230254524 + __I__ * 0.55557023301960218)*(t1240 + s630));
        s668 = ((-0.19509032201612825 + __I__ * 0.98078528040323043)*(t1264 + s656));
        t1281 = (s667 + s668);
        Y[a578] = (t1279 + t1281);
        Y[a579] = (t1279 - t1281);
        s669 = (__I__*(s667 - s668));
        Y[a580] = (t1280 + s669);
        Y[a581] = (t1280 - s669);
        s670 = (__I__*(t1249 - t1256));
        t1282 = (t1227 + s670);
        t1283 = (t1227 - s670);
        s671 = ((0.70710678118654757 + __I__ * 0.70710678118654757)*(t1237 - t1244));
        s672 = ((-0.70710678118654757 + __I__ * 0.70710678118654757)*(t1261 - t1268));
        t1284 = (s671 + s672);
        Y[a558] = (t1282 + t1284);
        Y[a559] = (t1282 - t1284);
        s673 = (__I__*(s671 - s672));
        Y[a560] = (t1283 + s673);
        Y[a561] = (t1283 - s673);
        s674 = ((-0.38268343236508978 + __I__ * 0.92387953251128674)*(t1251 - s641));
        t1285 = (t1229 + s674);
        t1286 = (t1229 - s674);
        s675 = ((0.55557023301960218 + __I__ * 0.83146961230254524)*(t1239 - s628));
        s676 = ((-0.98078528040323043 + __I__ * 0.19509032201612825)*(t1263 - s654));
        t1287 = (s675 + s676);
        Y[a566] = (t1285 + t1287);
        Y[a567] = (t1285 - t1287);
        s677 = (__I__*(s675 - s676));
        Y[a568] = (t1286 + s677);
        Y[a569] = (t1286 - s677);
        s678 = ((-0.70710678118654757 + __I__ * 0.70710678118654757)*(t1250 - s642));
        t1288 = (t1231 + s678);
        t1289 = (t1231 - s678);
        s679 = ((0.38268343236508978 + __I__ * 0.92387953251128674)*(t1238 - s629));
        s680 = ((-0.92387953251128674 - __I__ * 0.38268343236508978)*(t1262 - s655));
        t1290 = (s679 + s680);
        Y[a574] = (t1288 + t1290);
        Y[a575] = (t1288 - t1290);
        s681 = (__I__*(s679 - s680));
        Y[a576] = (t1289 + s681);
        Y[a577] = (t1289 - s681);
        s682 = ((-0.92387953251128674 + __I__ * 0.38268343236508978)*(t1252 - s643));
        t1291 = (t1233 + s682);
        t1292 = (t1233 - s682);
        s683 = ((0.19509032201612825 + __I__ * 0.98078528040323043)*(t1240 - s630));
        s684 = ((-0.55557023301960218 - __I__ * 0.83146961230254524)*(t1264 - s656));
        t1293 = (s683 + s684);
        Y[a582] = (t1291 + t1293);
        Y[a583] = (t1291 - t1293);
        s685 = (__I__*(s683 - s684));
        Y[a584] = (t1292 + s685);
        Y[a585] = (t1292 - s685);
    }
}
