/***************************************************************
This code was generated by  Spiral 5.0 beta, www.spiral.net --
Copyright (c) 2005, Carnegie Mellon University
All rights reserved.
The code is distributed under a BSD style license
(see http://www.opensource.org/licenses/bsd-license.php)

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are
met:

* Redistributions of source code must retain the above copyright
  notice, reference to Spiral, this list of conditions and the
  following disclaimer.
* Redistributions in binary form must reproduce the above
  copyright notice, this list of conditions and the following
  disclaimer in the documentation and/or other materials provided
  with the distribution.
* Neither the name of Carnegie Mellon University nor the name of its
  contributors may be used to endorse or promote products derived from
  this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
*AS IS* AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
******************************************************************/

/*	CPU: Intel Core2Duo at 2660 MHz, 2 cores, SSE3
	OS: Microsoft WindowsXP 32-bit
	SVN: 5591 (modified)
	language: c.icl.opt
	timestamp: Dec 6, 2007; 13:44:13
	transform: DFT(1024, 1)
	source file: "fft_1024.c(.c)"
	performance: 44913 cycles, 3032 Mflop/s

algorithm: DFT_GT_CT( DFT(1024, 1),
  GT_NthLoop( GT(DFT(32, 1), XChain([ 0, 1 ]), XChain([ 0, 1 ]), [ 32 ]),
    GT_Base( GT(DFT(32, 1), XChain([ 0 ]), XChain([ 0 ]), [  ]),
      DFT_GT_CT( DFT(32, 1),
        GT_NthLoop( GT(DFT(4, 1), XChain([ 0, 1 ]), XChain([ 0, 1 ]), [ 8 ]),
          GT_Base( GT(DFT(4, 1), XChain([ 0 ]), XChain([ 0 ]), [  ]),
            DFT_GT_CT( DFT(4, 1),
              GT_NthLoop( GT(DFT(2, 1), XChain([ 0, 1 ]), XChain([ 0, 1 ]), [ 2 ]),
                GT_Base( GT(DFT(2, 1), XChain([ 0 ]), XChain([ 0 ]), [  ]),
                  DFT_Base( DFT(2, 1) ) ),
                Info_Base( InfoNt(1) ) ),
              GT_NthLoop( GT(DFT(2, 1), XChain([ 0, 1 ]), XChain([ 1, 0 ]), [ 2 ]),
                GT_Base( GT(DFT(2, 1), XChain([ 0 ]), XChain([ 0 ]), [  ]),
                  DFT_Base( DFT(2, 1) ) ),
                Info_Base( InfoNt(1) ) ) ) ),
          Info_Base( InfoNt(1) ) ),
        GT_NthLoop( GT(DFT(8, 1), XChain([ 0, 1 ]), XChain([ 1, 0 ]), [ 4 ]),
          GT_Base( GT(DFT(8, 1), XChain([ 0 ]), XChain([ 0 ]), [  ]),
            DFT_GT_CT( DFT(8, 1),
              GT_NthLoop( GT(DFT(2, 1), XChain([ 0, 1 ]), XChain([ 0, 1 ]), [ 4 ]),
                GT_Base( GT(DFT(2, 1), XChain([ 0 ]), XChain([ 0 ]), [  ]),
                  DFT_Base( DFT(2, 1) ) ),
                Info_Base( InfoNt(1) ) ),
              GT_NthLoop( GT(DFT(4, 1), XChain([ 0, 1 ]), XChain([ 1, 0 ]), [ 2 ]),
                GT_Base( GT(DFT(4, 1), XChain([ 0 ]), XChain([ 0 ]), [  ]),
                  DFT_GT_CT( DFT(4, 1),
                    GT_NthLoop( GT(DFT(2, 1), XChain([ 0, 1 ]), XChain([ 0, 1 ]), [ 2 ]),
                      GT_Base( GT(DFT(2, 1), XChain([ 0 ]), XChain([ 0 ]), [  ]),
                        DFT_Base( DFT(2, 1) ) ),
                      Info_Base( InfoNt(1) ) ),
                    GT_NthLoop( GT(DFT(2, 1), XChain([ 0, 1 ]), XChain([ 1, 0 ]), [ 2 ]),
                      GT_Base( GT(DFT(2, 1), XChain([ 0 ]), XChain([ 0 ]), [  ]),
                        DFT_Base( DFT(2, 1) ) ),
                      Info_Base( InfoNt(1) ) ) ) ),
                Info_Base( InfoNt(1) ) ) ) ),
          Info_Base( InfoNt(1) ) ) ) ),
    Info_Base( InfoNt(1) ) ),
  GT_NthLoop( GT(DFT(32, 1), XChain([ 0, 1 ]), XChain([ 1, 0 ]), [ 32 ]),
    GT_Base( GT(DFT(32, 1), XChain([ 0 ]), XChain([ 0 ]), [  ]),
      DFT_GT_CT( DFT(32, 1),
        GT_NthLoop( GT(DFT(4, 1), XChain([ 0, 1 ]), XChain([ 0, 1 ]), [ 8 ]),
          GT_Base( GT(DFT(4, 1), XChain([ 0 ]), XChain([ 0 ]), [  ]),
            DFT_GT_CT( DFT(4, 1),
              GT_NthLoop( GT(DFT(2, 1), XChain([ 0, 1 ]), XChain([ 0, 1 ]), [ 2 ]),
                GT_Base( GT(DFT(2, 1), XChain([ 0 ]), XChain([ 0 ]), [  ]),
                  DFT_Base( DFT(2, 1) ) ),
                Info_Base( InfoNt(1) ) ),
              GT_NthLoop( GT(DFT(2, 1), XChain([ 0, 1 ]), XChain([ 1, 0 ]), [ 2 ]),
                GT_Base( GT(DFT(2, 1), XChain([ 0 ]), XChain([ 0 ]), [  ]),
                  DFT_Base( DFT(2, 1) ) ),
                Info_Base( InfoNt(1) ) ) ) ),
          Info_Base( InfoNt(1) ) ),
        GT_NthLoop( GT(DFT(8, 1), XChain([ 0, 1 ]), XChain([ 1, 0 ]), [ 4 ]),
          GT_Base( GT(DFT(8, 1), XChain([ 0 ]), XChain([ 0 ]), [  ]),
            DFT_GT_CT( DFT(8, 1),
              GT_NthLoop( GT(DFT(2, 1), XChain([ 0, 1 ]), XChain([ 0, 1 ]), [ 4 ]),
                GT_Base( GT(DFT(2, 1), XChain([ 0 ]), XChain([ 0 ]), [  ]),
                  DFT_Base( DFT(2, 1) ) ),
                Info_Base( InfoNt(1) ) ),
              GT_NthLoop( GT(DFT(4, 1), XChain([ 0, 1 ]), XChain([ 1, 0 ]), [ 2 ]),
                GT_Base( GT(DFT(4, 1), XChain([ 0 ]), XChain([ 0 ]), [  ]),
                  DFT_GT_CT( DFT(4, 1),
                    GT_NthLoop( GT(DFT(2, 1), XChain([ 0, 1 ]), XChain([ 0, 1 ]), [ 2 ]),
                      GT_Base( GT(DFT(2, 1), XChain([ 0 ]), XChain([ 0 ]), [  ]),
                        DFT_Base( DFT(2, 1) ) ),
                      Info_Base( InfoNt(1) ) ),
                    GT_NthLoop( GT(DFT(2, 1), XChain([ 0, 1 ]), XChain([ 1, 0 ]), [ 2 ]),
                      GT_Base( GT(DFT(2, 1), XChain([ 0 ]), XChain([ 0 ]), [  ]),
                        DFT_Base( DFT(2, 1) ) ),
                      Info_Base( InfoNt(1) ) ) ) ),
                Info_Base( InfoNt(1) ) ) ) ),
          Info_Base( InfoNt(1) ) ) ) ),
    Info_Base( InfoNt(1) ) ) )
*/

#include <include/omega64c.h>
static _Complex double D5[1024];

void init_fft1024() {
    for(int i684 = 0; i684 <= 31; i684++) {
        for(int i687 = 0; i687 <= 3; i687++) {
            for(int i693 = 0; i693 <= 1; i693++) {
                for(int i699 = 0; i699 <= 1; i699++) {
                    D5[((i684*32) + (i687*8) + (i693*4) + (i699*2))] = omega(1024, ((i687 + ((i693 + (i699*2))*4))*i684));
                    D5[((i684*32) + (i687*8) + (i693*4) + (i699*2) + 1)] = omega(1024, ((i687 + ((i693 + (i699*2))*4) + 16)*i684));
                }
            }
        }
    }
}

void fft1024(_Complex double  *Y, _Complex double  *X) {
    static _Complex double T161[1024];
    for(int i685 = 0; i685 <= 31; i685++) {
        _Complex double s1452, s1453, s1454, s1455, s1456, s1457, s1458, 
            s1459, s1460, s1461, s1462, s1463, s1464, s1465, s1466, 
            s1467, s1468, s1469, s1470, s1471, s1472, s1473, s1474, 
            s1475, s1476, s1477, s1478, s1479, s1480, s1481, s1482, 
            s1483, s1484, s1485, s1486, s1487, s1488, s1489, s1490, 
            s1491, s1492, s1493, s1494, s1495, s1496, s1497, s1498, 
            s1499, s1500, s1501, s1502, s1503, s1504, s1505, s1506, 
            s1507, s1508, s1509, s1510, s1511, s1512, s1513, s1514, 
            s1515, s1516, s1517, s1518, s1519, s1520, s1521, s1522, 
            s1523, s1524, s1525, s1526, s1527, s1528, s1529, s1530, 
            s1531, s1532, t2544, t2545, t2546, t2547, t2548, t2549, 
            t2550, t2551, t2552, t2553, t2554, t2555, t2556, t2557, 
            t2558, t2559, t2560, t2561, t2562, t2563, t2564, t2565, 
            t2566, t2567, t2568, t2569, t2570, t2571, t2572, t2573, 
            t2574, t2575, t2576, t2577, t2578, t2579, t2580, t2581, 
            t2582, t2583, t2584, t2585, t2586, t2587, t2588, t2589, 
            t2590, t2591, t2592, t2593, t2594, t2595, t2596, t2597, 
            t2598, t2599, t2600, t2601, t2602, t2603, t2604, t2605, 
            t2606, t2607, t2608, t2609, t2610, t2611, t2612, t2613, 
            t2614, t2615, t2616, t2617, t2618, t2619, t2620, t2621, 
            t2622;
        int a1259;
        s1452 = X[i685];
        s1453 = X[(i685 + 512)];
        t2544 = (s1452 + s1453);
        t2545 = (s1452 - s1453);
        s1454 = X[(i685 + 256)];
        s1455 = X[(768 + i685)];
        t2546 = (s1454 + s1455);
        t2547 = (t2544 + t2546);
        t2548 = (t2544 - t2546);
        s1456 = (__I__*(s1454 - s1455));
        t2549 = (t2545 + s1456);
        t2550 = (t2545 - s1456);
        s1457 = X[(i685 + 128)];
        s1458 = X[(640 + i685)];
        t2551 = (s1457 + s1458);
        t2552 = (s1457 - s1458);
        s1459 = X[(i685 + 384)];
        s1460 = X[(896 + i685)];
        t2553 = (s1459 + s1460);
        t2554 = (t2551 + t2553);
        s1461 = (__I__*(s1459 - s1460));
        t2555 = (t2547 + t2554);
        t2556 = (t2547 - t2554);
        s1462 = ((0.70710678118654757 + __I__ * 0.70710678118654757)*(t2552 + s1461));
        t2557 = (t2549 + s1462);
        t2558 = (t2549 - s1462);
        s1463 = (__I__*(t2551 - t2553));
        t2559 = (t2548 + s1463);
        t2560 = (t2548 - s1463);
        s1464 = ((-0.70710678118654757 + __I__ * 0.70710678118654757)*(t2552 - s1461));
        t2561 = (t2550 + s1464);
        t2562 = (t2550 - s1464);
        s1465 = X[(i685 + 32)];
        s1466 = X[(544 + i685)];
        t2563 = (s1465 + s1466);
        t2564 = (s1465 - s1466);
        s1467 = X[(i685 + 288)];
        s1468 = X[(800 + i685)];
        t2565 = (s1467 + s1468);
        t2566 = (t2563 + t2565);
        t2567 = (t2563 - t2565);
        s1469 = (__I__*(s1467 - s1468));
        t2568 = (t2564 + s1469);
        t2569 = (t2564 - s1469);
        s1470 = X[(i685 + 160)];
        s1471 = X[(672 + i685)];
        t2570 = (s1470 + s1471);
        t2571 = (s1470 - s1471);
        s1472 = X[(i685 + 416)];
        s1473 = X[(928 + i685)];
        t2572 = (s1472 + s1473);
        t2573 = (t2570 + t2572);
        s1474 = (__I__*(s1472 - s1473));
        t2574 = (t2566 + t2573);
        s1475 = ((0.70710678118654757 + __I__ * 0.70710678118654757)*(t2571 + s1474));
        s1476 = (__I__*(t2570 - t2572));
        s1477 = ((-0.70710678118654757 + __I__ * 0.70710678118654757)*(t2571 - s1474));
        s1478 = X[(i685 + 64)];
        s1479 = X[(576 + i685)];
        t2575 = (s1478 + s1479);
        t2576 = (s1478 - s1479);
        s1480 = X[(i685 + 320)];
        s1481 = X[(832 + i685)];
        t2577 = (s1480 + s1481);
        t2578 = (t2575 + t2577);
        t2579 = (t2575 - t2577);
        s1482 = (__I__*(s1480 - s1481));
        t2580 = (t2576 + s1482);
        t2581 = (t2576 - s1482);
        s1483 = X[(i685 + 192)];
        s1484 = X[(704 + i685)];
        t2582 = (s1483 + s1484);
        t2583 = (s1483 - s1484);
        s1485 = X[(i685 + 448)];
        s1486 = X[(960 + i685)];
        t2584 = (s1485 + s1486);
        t2585 = (t2582 + t2584);
        s1487 = (__I__*(s1485 - s1486));
        t2586 = (t2578 + t2585);
        s1488 = ((0.70710678118654757 + __I__ * 0.70710678118654757)*(t2583 + s1487));
        s1489 = (__I__*(t2582 - t2584));
        s1490 = ((-0.70710678118654757 + __I__ * 0.70710678118654757)*(t2583 - s1487));
        s1491 = X[(i685 + 96)];
        s1492 = X[(608 + i685)];
        t2587 = (s1491 + s1492);
        t2588 = (s1491 - s1492);
        s1493 = X[(i685 + 352)];
        s1494 = X[(864 + i685)];
        t2589 = (s1493 + s1494);
        t2590 = (t2587 + t2589);
        t2591 = (t2587 - t2589);
        s1495 = (__I__*(s1493 - s1494));
        t2592 = (t2588 + s1495);
        t2593 = (t2588 - s1495);
        s1496 = X[(i685 + 224)];
        s1497 = X[(736 + i685)];
        t2594 = (s1496 + s1497);
        t2595 = (s1496 - s1497);
        s1498 = X[(i685 + 480)];
        s1499 = X[(992 + i685)];
        t2596 = (s1498 + s1499);
        t2597 = (t2594 + t2596);
        s1500 = (__I__*(s1498 - s1499));
        t2598 = (t2590 + t2597);
        s1501 = ((0.70710678118654757 + __I__ * 0.70710678118654757)*(t2595 + s1500));
        s1502 = (__I__*(t2594 - t2596));
        s1503 = ((-0.70710678118654757 + __I__ * 0.70710678118654757)*(t2595 - s1500));
        t2599 = (t2555 + t2586);
        t2600 = (t2555 - t2586);
        t2601 = (t2574 + t2598);
        a1259 = (32*i685);
        T161[a1259] = (t2599 + t2601);
        T161[(16 + a1259)] = (t2599 - t2601);
        s1504 = (__I__*(t2574 - t2598));
        T161[(8 + a1259)] = (t2600 + s1504);
        T161[(24 + a1259)] = (t2600 - s1504);
        s1505 = ((0.92387953251128674 + __I__ * 0.38268343236508978)*(t2580 + s1488));
        t2602 = (t2557 + s1505);
        t2603 = (t2557 - s1505);
        s1506 = ((0.98078528040323043 + __I__ * 0.19509032201612825)*(t2568 + s1475));
        s1507 = ((0.83146961230254524 + __I__ * 0.55557023301960218)*(t2592 + s1501));
        t2604 = (s1506 + s1507);
        T161[(1 + a1259)] = (t2602 + t2604);
        T161[(17 + a1259)] = (t2602 - t2604);
        s1508 = (__I__*(s1506 - s1507));
        T161[(9 + a1259)] = (t2603 + s1508);
        T161[(25 + a1259)] = (t2603 - s1508);
        s1509 = ((0.70710678118654757 + __I__ * 0.70710678118654757)*(t2579 + s1489));
        t2605 = (t2559 + s1509);
        t2606 = (t2559 - s1509);
        s1510 = ((0.92387953251128674 + __I__ * 0.38268343236508978)*(t2567 + s1476));
        s1511 = ((0.38268343236508978 + __I__ * 0.92387953251128674)*(t2591 + s1502));
        t2607 = (s1510 + s1511);
        T161[(2 + a1259)] = (t2605 + t2607);
        T161[(18 + a1259)] = (t2605 - t2607);
        s1512 = (__I__*(s1510 - s1511));
        T161[(10 + a1259)] = (t2606 + s1512);
        T161[(26 + a1259)] = (t2606 - s1512);
        s1513 = ((0.38268343236508978 + __I__ * 0.92387953251128674)*(t2581 + s1490));
        t2608 = (t2561 + s1513);
        t2609 = (t2561 - s1513);
        s1514 = ((0.83146961230254524 + __I__ * 0.55557023301960218)*(t2569 + s1477));
        s1515 = ((-0.19509032201612825 + __I__ * 0.98078528040323043)*(t2593 + s1503));
        t2610 = (s1514 + s1515);
        T161[(3 + a1259)] = (t2608 + t2610);
        T161[(19 + a1259)] = (t2608 - t2610);
        s1516 = (__I__*(s1514 - s1515));
        T161[(11 + a1259)] = (t2609 + s1516);
        T161[(27 + a1259)] = (t2609 - s1516);
        s1517 = (__I__*(t2578 - t2585));
        t2611 = (t2556 + s1517);
        t2612 = (t2556 - s1517);
        s1518 = ((0.70710678118654757 + __I__ * 0.70710678118654757)*(t2566 - t2573));
        s1519 = ((-0.70710678118654757 + __I__ * 0.70710678118654757)*(t2590 - t2597));
        t2613 = (s1518 + s1519);
        T161[(4 + a1259)] = (t2611 + t2613);
        T161[(20 + a1259)] = (t2611 - t2613);
        s1520 = (__I__*(s1518 - s1519));
        T161[(12 + a1259)] = (t2612 + s1520);
        T161[(28 + a1259)] = (t2612 - s1520);
        s1521 = ((-0.38268343236508978 + __I__ * 0.92387953251128674)*(t2580 - s1488));
        t2614 = (t2558 + s1521);
        t2615 = (t2558 - s1521);
        s1522 = ((0.55557023301960218 + __I__ * 0.83146961230254524)*(t2568 - s1475));
        s1523 = ((-0.98078528040323043 + __I__ * 0.19509032201612825)*(t2592 - s1501));
        t2616 = (s1522 + s1523);
        T161[(5 + a1259)] = (t2614 + t2616);
        T161[(21 + a1259)] = (t2614 - t2616);
        s1524 = (__I__*(s1522 - s1523));
        T161[(13 + a1259)] = (t2615 + s1524);
        T161[(29 + a1259)] = (t2615 - s1524);
        s1525 = ((-0.70710678118654757 + __I__ * 0.70710678118654757)*(t2579 - s1489));
        t2617 = (t2560 + s1525);
        t2618 = (t2560 - s1525);
        s1526 = ((0.38268343236508978 + __I__ * 0.92387953251128674)*(t2567 - s1476));
        s1527 = ((-0.92387953251128674 - __I__ * 0.38268343236508978)*(t2591 - s1502));
        t2619 = (s1526 + s1527);
        T161[(6 + a1259)] = (t2617 + t2619);
        T161[(22 + a1259)] = (t2617 - t2619);
        s1528 = (__I__*(s1526 - s1527));
        T161[(14 + a1259)] = (t2618 + s1528);
        T161[(30 + a1259)] = (t2618 - s1528);
        s1529 = ((-0.92387953251128674 + __I__ * 0.38268343236508978)*(t2581 - s1490));
        t2620 = (t2562 + s1529);
        t2621 = (t2562 - s1529);
        s1530 = ((0.19509032201612825 + __I__ * 0.98078528040323043)*(t2569 - s1477));
        s1531 = ((-0.55557023301960218 - __I__ * 0.83146961230254524)*(t2593 - s1503));
        t2622 = (s1530 + s1531);
        T161[(7 + a1259)] = (t2620 + t2622);
        T161[(23 + a1259)] = (t2620 - t2622);
        s1532 = (__I__*(s1530 - s1531));
        T161[(15 + a1259)] = (t2621 + s1532);
        T161[(31 + a1259)] = (t2621 - s1532);
    }
    for(int i684 = 0; i684 <= 31; i684++) {
        _Complex double s1759, s1760, s1761, s1762, s1763, s1764, s1765, 
            s1766, s1767, s1768, s1769, s1770, s1771, s1772, s1773, 
            s1774, s1775, s1776, s1777, s1778, s1779, s1780, s1781, 
            s1782, s1783, s1784, s1785, s1786, s1787, s1788, s1789, 
            s1790, s1791, s1792, s1793, s1794, s1795, s1796, s1797, 
            s1798, s1799, s1800, s1801, s1802, s1803, s1804, s1805, 
            s1806, s1807, s1808, s1809, s1810, s1811, s1812, s1813, 
            s1814, s1815, s1816, s1817, s1818, s1819, s1820, s1821, 
            s1822, s1823, s1824, s1825, s1826, s1827, s1828, s1829, 
            s1830, s1831, s1832, s1833, s1834, s1835, s1836, s1837, 
            s1838, s1839, t2943, t2944, t2945, t2946, t2947, t2948, 
            t2949, t2950, t2951, t2952, t2953, t2954, t2955, t2956, 
            t2957, t2958, t2959, t2960, t2961, t2962, t2963, t2964, 
            t2965, t2966, t2967, t2968, t2969, t2970, t2971, t2972, 
            t2973, t2974, t2975, t2976, t2977, t2978, t2979, t2980, 
            t2981, t2982, t2983, t2984, t2985, t2986, t2987, t2988, 
            t2989, t2990, t2991, t2992, t2993, t2994, t2995, t2996, 
            t2997, t2998, t2999, t3000, t3001, t3002, t3003, t3004, 
            t3005, t3006, t3007, t3008, t3009, t3010, t3011, t3012, 
            t3013, t3014, t3015, t3016, t3017, t3018, t3019, t3020, 
            t3021;
        int a1512, a1513, a1514, a1515, a1516, a1517, a1518, 
            a1519, a1520, a1521, a1522, a1523, a1524, a1525, a1526, 
            a1527, a1528, a1529, a1530, a1531, a1532, a1533, a1534, 
            a1535, a1536, a1537, a1538, a1539, a1540, a1541, a1542, 
            a1543;
        a1512 = (i684 + 512);
        a1513 = (32*i684);
        s1759 = (D5[a1513]*T161[i684]);
        s1760 = (D5[(1 + a1513)]*T161[a1512]);
        t2943 = (s1759 + s1760);
        t2944 = (s1759 - s1760);
        a1514 = (i684 + 256);
        a1515 = (768 + i684);
        s1761 = (D5[(2 + a1513)]*T161[a1514]);
        s1762 = (D5[(3 + a1513)]*T161[a1515]);
        t2945 = (s1761 + s1762);
        t2946 = (t2943 + t2945);
        t2947 = (t2943 - t2945);
        s1763 = (__I__*(s1761 - s1762));
        t2948 = (t2944 + s1763);
        t2949 = (t2944 - s1763);
        a1516 = (i684 + 128);
        a1517 = (640 + i684);
        s1764 = (D5[(4 + a1513)]*T161[a1516]);
        s1765 = (D5[(5 + a1513)]*T161[a1517]);
        t2950 = (s1764 + s1765);
        t2951 = (s1764 - s1765);
        a1518 = (i684 + 384);
        a1519 = (896 + i684);
        s1766 = (D5[(6 + a1513)]*T161[a1518]);
        s1767 = (D5[(7 + a1513)]*T161[a1519]);
        t2952 = (s1766 + s1767);
        t2953 = (t2950 + t2952);
        s1768 = (__I__*(s1766 - s1767));
        t2954 = (t2946 + t2953);
        t2955 = (t2946 - t2953);
        s1769 = ((0.70710678118654757 + __I__ * 0.70710678118654757)*(t2951 + s1768));
        t2956 = (t2948 + s1769);
        t2957 = (t2948 - s1769);
        s1770 = (__I__*(t2950 - t2952));
        t2958 = (t2947 + s1770);
        t2959 = (t2947 - s1770);
        s1771 = ((-0.70710678118654757 + __I__ * 0.70710678118654757)*(t2951 - s1768));
        t2960 = (t2949 + s1771);
        t2961 = (t2949 - s1771);
        a1520 = (i684 + 32);
        a1521 = (544 + i684);
        s1772 = (D5[(8 + a1513)]*T161[a1520]);
        s1773 = (D5[(9 + a1513)]*T161[a1521]);
        t2962 = (s1772 + s1773);
        t2963 = (s1772 - s1773);
        a1522 = (i684 + 288);
        a1523 = (800 + i684);
        s1774 = (D5[(10 + a1513)]*T161[a1522]);
        s1775 = (D5[(11 + a1513)]*T161[a1523]);
        t2964 = (s1774 + s1775);
        t2965 = (t2962 + t2964);
        t2966 = (t2962 - t2964);
        s1776 = (__I__*(s1774 - s1775));
        t2967 = (t2963 + s1776);
        t2968 = (t2963 - s1776);
        a1524 = (i684 + 160);
        a1525 = (672 + i684);
        s1777 = (D5[(12 + a1513)]*T161[a1524]);
        s1778 = (D5[(13 + a1513)]*T161[a1525]);
        t2969 = (s1777 + s1778);
        t2970 = (s1777 - s1778);
        a1526 = (i684 + 416);
        a1527 = (928 + i684);
        s1779 = (D5[(14 + a1513)]*T161[a1526]);
        s1780 = (D5[(15 + a1513)]*T161[a1527]);
        t2971 = (s1779 + s1780);
        t2972 = (t2969 + t2971);
        s1781 = (__I__*(s1779 - s1780));
        t2973 = (t2965 + t2972);
        s1782 = ((0.70710678118654757 + __I__ * 0.70710678118654757)*(t2970 + s1781));
        s1783 = (__I__*(t2969 - t2971));
        s1784 = ((-0.70710678118654757 + __I__ * 0.70710678118654757)*(t2970 - s1781));
        a1528 = (i684 + 64);
        a1529 = (576 + i684);
        s1785 = (D5[(16 + a1513)]*T161[a1528]);
        s1786 = (D5[(17 + a1513)]*T161[a1529]);
        t2974 = (s1785 + s1786);
        t2975 = (s1785 - s1786);
        a1530 = (i684 + 320);
        a1531 = (832 + i684);
        s1787 = (D5[(18 + a1513)]*T161[a1530]);
        s1788 = (D5[(19 + a1513)]*T161[a1531]);
        t2976 = (s1787 + s1788);
        t2977 = (t2974 + t2976);
        t2978 = (t2974 - t2976);
        s1789 = (__I__*(s1787 - s1788));
        t2979 = (t2975 + s1789);
        t2980 = (t2975 - s1789);
        a1532 = (i684 + 192);
        a1533 = (704 + i684);
        s1790 = (D5[(20 + a1513)]*T161[a1532]);
        s1791 = (D5[(21 + a1513)]*T161[a1533]);
        t2981 = (s1790 + s1791);
        t2982 = (s1790 - s1791);
        a1534 = (i684 + 448);
        a1535 = (960 + i684);
        s1792 = (D5[(22 + a1513)]*T161[a1534]);
        s1793 = (D5[(23 + a1513)]*T161[a1535]);
        t2983 = (s1792 + s1793);
        t2984 = (t2981 + t2983);
        s1794 = (__I__*(s1792 - s1793));
        t2985 = (t2977 + t2984);
        s1795 = ((0.70710678118654757 + __I__ * 0.70710678118654757)*(t2982 + s1794));
        s1796 = (__I__*(t2981 - t2983));
        s1797 = ((-0.70710678118654757 + __I__ * 0.70710678118654757)*(t2982 - s1794));
        a1536 = (i684 + 96);
        a1537 = (608 + i684);
        s1798 = (D5[(24 + a1513)]*T161[a1536]);
        s1799 = (D5[(25 + a1513)]*T161[a1537]);
        t2986 = (s1798 + s1799);
        t2987 = (s1798 - s1799);
        a1538 = (i684 + 352);
        a1539 = (864 + i684);
        s1800 = (D5[(26 + a1513)]*T161[a1538]);
        s1801 = (D5[(27 + a1513)]*T161[a1539]);
        t2988 = (s1800 + s1801);
        t2989 = (t2986 + t2988);
        t2990 = (t2986 - t2988);
        s1802 = (__I__*(s1800 - s1801));
        t2991 = (t2987 + s1802);
        t2992 = (t2987 - s1802);
        a1540 = (i684 + 224);
        a1541 = (736 + i684);
        s1803 = (D5[(28 + a1513)]*T161[a1540]);
        s1804 = (D5[(29 + a1513)]*T161[a1541]);
        t2993 = (s1803 + s1804);
        t2994 = (s1803 - s1804);
        a1542 = (i684 + 480);
        a1543 = (992 + i684);
        s1805 = (D5[(30 + a1513)]*T161[a1542]);
        s1806 = (D5[(31 + a1513)]*T161[a1543]);
        t2995 = (s1805 + s1806);
        t2996 = (t2993 + t2995);
        s1807 = (__I__*(s1805 - s1806));
        t2997 = (t2989 + t2996);
        s1808 = ((0.70710678118654757 + __I__ * 0.70710678118654757)*(t2994 + s1807));
        s1809 = (__I__*(t2993 - t2995));
        s1810 = ((-0.70710678118654757 + __I__ * 0.70710678118654757)*(t2994 - s1807));
        t2998 = (t2954 + t2985);
        t2999 = (t2954 - t2985);
        t3000 = (t2973 + t2997);
        Y[i684] = (t2998 + t3000);
        Y[a1512] = (t2998 - t3000);
        s1811 = (__I__*(t2973 - t2997));
        Y[a1514] = (t2999 + s1811);
        Y[a1515] = (t2999 - s1811);
        s1812 = ((0.92387953251128674 + __I__ * 0.38268343236508978)*(t2979 + s1795));
        t3001 = (t2956 + s1812);
        t3002 = (t2956 - s1812);
        s1813 = ((0.98078528040323043 + __I__ * 0.19509032201612825)*(t2967 + s1782));
        s1814 = ((0.83146961230254524 + __I__ * 0.55557023301960218)*(t2991 + s1808));
        t3003 = (s1813 + s1814);
        Y[a1520] = (t3001 + t3003);
        Y[a1521] = (t3001 - t3003);
        s1815 = (__I__*(s1813 - s1814));
        Y[a1522] = (t3002 + s1815);
        Y[a1523] = (t3002 - s1815);
        s1816 = ((0.70710678118654757 + __I__ * 0.70710678118654757)*(t2978 + s1796));
        t3004 = (t2958 + s1816);
        t3005 = (t2958 - s1816);
        s1817 = ((0.92387953251128674 + __I__ * 0.38268343236508978)*(t2966 + s1783));
        s1818 = ((0.38268343236508978 + __I__ * 0.92387953251128674)*(t2990 + s1809));
        t3006 = (s1817 + s1818);
        Y[a1528] = (t3004 + t3006);
        Y[a1529] = (t3004 - t3006);
        s1819 = (__I__*(s1817 - s1818));
        Y[a1530] = (t3005 + s1819);
        Y[a1531] = (t3005 - s1819);
        s1820 = ((0.38268343236508978 + __I__ * 0.92387953251128674)*(t2980 + s1797));
        t3007 = (t2960 + s1820);
        t3008 = (t2960 - s1820);
        s1821 = ((0.83146961230254524 + __I__ * 0.55557023301960218)*(t2968 + s1784));
        s1822 = ((-0.19509032201612825 + __I__ * 0.98078528040323043)*(t2992 + s1810));
        t3009 = (s1821 + s1822);
        Y[a1536] = (t3007 + t3009);
        Y[a1537] = (t3007 - t3009);
        s1823 = (__I__*(s1821 - s1822));
        Y[a1538] = (t3008 + s1823);
        Y[a1539] = (t3008 - s1823);
        s1824 = (__I__*(t2977 - t2984));
        t3010 = (t2955 + s1824);
        t3011 = (t2955 - s1824);
        s1825 = ((0.70710678118654757 + __I__ * 0.70710678118654757)*(t2965 - t2972));
        s1826 = ((-0.70710678118654757 + __I__ * 0.70710678118654757)*(t2989 - t2996));
        t3012 = (s1825 + s1826);
        Y[a1516] = (t3010 + t3012);
        Y[a1517] = (t3010 - t3012);
        s1827 = (__I__*(s1825 - s1826));
        Y[a1518] = (t3011 + s1827);
        Y[a1519] = (t3011 - s1827);
        s1828 = ((-0.38268343236508978 + __I__ * 0.92387953251128674)*(t2979 - s1795));
        t3013 = (t2957 + s1828);
        t3014 = (t2957 - s1828);
        s1829 = ((0.55557023301960218 + __I__ * 0.83146961230254524)*(t2967 - s1782));
        s1830 = ((-0.98078528040323043 + __I__ * 0.19509032201612825)*(t2991 - s1808));
        t3015 = (s1829 + s1830);
        Y[a1524] = (t3013 + t3015);
        Y[a1525] = (t3013 - t3015);
        s1831 = (__I__*(s1829 - s1830));
        Y[a1526] = (t3014 + s1831);
        Y[a1527] = (t3014 - s1831);
        s1832 = ((-0.70710678118654757 + __I__ * 0.70710678118654757)*(t2978 - s1796));
        t3016 = (t2959 + s1832);
        t3017 = (t2959 - s1832);
        s1833 = ((0.38268343236508978 + __I__ * 0.92387953251128674)*(t2966 - s1783));
        s1834 = ((-0.92387953251128674 - __I__ * 0.38268343236508978)*(t2990 - s1809));
        t3018 = (s1833 + s1834);
        Y[a1532] = (t3016 + t3018);
        Y[a1533] = (t3016 - t3018);
        s1835 = (__I__*(s1833 - s1834));
        Y[a1534] = (t3017 + s1835);
        Y[a1535] = (t3017 - s1835);
        s1836 = ((-0.92387953251128674 + __I__ * 0.38268343236508978)*(t2980 - s1797));
        t3019 = (t2961 + s1836);
        t3020 = (t2961 - s1836);
        s1837 = ((0.19509032201612825 + __I__ * 0.98078528040323043)*(t2968 - s1784));
        s1838 = ((-0.55557023301960218 - __I__ * 0.83146961230254524)*(t2992 - s1810));
        t3021 = (s1837 + s1838);
        Y[a1540] = (t3019 + t3021);
        Y[a1541] = (t3019 - t3021);
        s1839 = (__I__*(s1837 - s1838));
        Y[a1542] = (t3020 + s1839);
        Y[a1543] = (t3020 - s1839);
    }
}
