/***************************************************************
This code was generated by  Spiral 5.0 beta, www.spiral.net --
Copyright (c) 2005, Carnegie Mellon University
All rights reserved.
The code is distributed under a BSD style license
(see http://www.opensource.org/licenses/bsd-license.php)

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are
met:

* Redistributions of source code must retain the above copyright
  notice, reference to Spiral, this list of conditions and the
  following disclaimer.
  * Redistributions in binary form must reproduce the above
  copyright notice, this list of conditions and the following
  disclaimer in the documentation and/or other materials provided
  with the distribution.
  * Neither the name of Carnegie Mellon University nor the name of its
  contributors may be used to endorse or promote products derived from
  this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
*AS IS* AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
******************************************************************/

use omega;
var  buf1: [0..63] complex;
var  dat1: [0..27] complex;
var  dat2: [0..27] complex;

proc init_fft64() {
  for i3714 in 0..6 {
    for i3724 in 0..1 {
      dat1(((i3714*4) + (i3724*2))) = omega(64, ((i3714 + 1)*i3724));
      dat1(((i3714*4) + (i3724*2) + 1)) = omega(64, ((i3714 + 1)*(i3724 + 2)));
    }
  }
  for i3715 in 0..6 {
    for i3732 in 0..1 {
      dat2(((i3715*4) + (i3732*2))) = omega(64, ((9 + i3715)*i3732));
      dat2(((i3715*4) + (i3732*2) + 1)) = omega(64, ((9 + i3715)*(i3732 + 2)));
    }
  }

}

proc fft64(Y: [] complex, X: [] complex) {
  for i3716 in 0..3 {
    var a5939, a5940, a5941, a5942, a5944, a5945, a5946, a5947, s2369, s2370, s2371, s2372, s2373, s2374, s2375, s2376, s2377, s2378, s2379, s2380, s2381, s2382, s2383, s2384, s2385, s2386, s2387, s2388, s2389, s2390, s2391, s2392, s2393, t6235, t6236, t6237, t6238, t6239, t6240, t6241, t6242, t6243, t6244, t6245, t6246, t6247, t6248, t6249, t6250, t6251, t6252, t6253, t6254, t6255, t6256, t6257, t6258, t6259, t6260, t6261, t6262, t6263, t6264, t6265:complex;
    var a5943:int;
    s2369 = X(i3716);
    s2370 = X((32 + i3716));
    t6235 = (s2369 + s2370);
    t6236 = (s2369 - s2370);
    s2371 = X((16 + i3716));
    s2372 = X((48 + i3716));
    t6237 = (s2371 + s2372);
    t6238 = (t6235 + t6237);
    t6239 = (t6235 - t6237);
    a5939 = (1.0i*(s2371 - s2372));
    t6240 = (t6236 + a5939);
    t6241 = (t6236 - a5939);
    s2373 = X((4 + i3716));
    s2374 = X((36 + i3716));
    t6242 = (s2373 + s2374);
    t6243 = (s2373 - s2374);
    s2375 = X((20 + i3716));
    s2376 = X((52 + i3716));
    t6244 = (s2375 + s2376);
    t6245 = (t6242 + t6244);
    s2377 = ((0.70710678118654757 + 1.0i * 0.70710678118654757)*(t6242 - t6244));
    a5940 = (1.0i*(s2375 - s2376));
    s2378 = ((0.92387953251128674 + 1.0i * 0.38268343236508978)*(t6243 + a5940));
    s2379 = ((0.38268343236508978 + 1.0i * 0.92387953251128674)*(t6243 - a5940));
    s2380 = X((8 + i3716));
    s2381 = X((40 + i3716));
    t6246 = (s2380 + s2381);
    t6247 = (s2380 - s2381);
    s2382 = X((24 + i3716));
    s2383 = X((56 + i3716));
    t6248 = (s2382 + s2383);
    t6249 = (t6246 + t6248);
    s2384 = (1.0i*(t6246 - t6248));
    a5941 = (1.0i*(s2382 - s2383));
    s2385 = ((0.70710678118654757 + 1.0i * 0.70710678118654757)*(t6247 + a5941));
    s2386 = ((-0.70710678118654757 + 1.0i * 0.70710678118654757)*(t6247 - a5941));
    s2387 = X((12 + i3716));
    s2388 = X((44 + i3716));
    t6250 = (s2387 + s2388);
    t6251 = (s2387 - s2388);
    s2389 = X((28 + i3716));
    s2390 = X((60 + i3716));
    t6252 = (s2389 + s2390);
    t6253 = (t6250 + t6252);
    s2391 = ((-0.70710678118654757 + 1.0i * 0.70710678118654757)*(t6250 - t6252));
    a5942 = (1.0i*(s2389 - s2390));
    s2392 = ((0.38268343236508978 + 1.0i * 0.92387953251128674)*(t6251 + a5942));
    s2393 = ((-0.92387953251128674 - 1.0i * 0.38268343236508978)*(t6251 - a5942));
    t6254 = (t6238 + t6249);
    t6255 = (t6238 - t6249);
    t6256 = (t6245 + t6253);
    a5943 = (16*i3716);
    buf1(a5943) = (t6254 + t6256);
    buf1((8 + a5943)) = (t6254 - t6256);
    a5944 = (1.0i*(t6245 - t6253));
    buf1((4 + a5943)) = (t6255 + a5944);
    buf1((12 + a5943)) = (t6255 - a5944);
    t6257 = (t6240 + s2385);
    t6258 = (t6240 - s2385);
    t6259 = (s2378 + s2392);
    buf1((1 + a5943)) = (t6257 + t6259);
    buf1((9 + a5943)) = (t6257 - t6259);
    a5945 = (1.0i*(s2378 - s2392));
    buf1((5 + a5943)) = (t6258 + a5945);
    buf1((13 + a5943)) = (t6258 - a5945);
    t6260 = (t6239 + s2384);
    t6261 = (t6239 - s2384);
    t6262 = (s2377 + s2391);
    buf1((2 + a5943)) = (t6260 + t6262);
    buf1((10 + a5943)) = (t6260 - t6262);
    a5946 = (1.0i*(s2377 - s2391));
    buf1((6 + a5943)) = (t6261 + a5946);
    buf1((14 + a5943)) = (t6261 - a5946);
    t6263 = (t6241 + s2386);
    t6264 = (t6241 - s2386);
    t6265 = (s2379 + s2393);
    buf1((3 + a5943)) = (t6263 + t6265);
    buf1((11 + a5943)) = (t6263 - t6265);
    a5947 = (1.0i*(s2379 - s2393));
    buf1((7 + a5943)) = (t6264 + a5947);
    buf1((15 + a5943)) = (t6264 - a5947);
  }
  var a5960, t6282, t6283, t6284:complex;
  t6282 = (buf1(0) + buf1(32));
  t6283 = (buf1(0) - buf1(32));
  t6284 = (buf1(16) + buf1(48));
  Y(0) = (t6282 + t6284);
  Y(32) = (t6282 - t6284);
  a5960 = (1.0i*(buf1(16) - buf1(48)));
  Y(16) = (t6283 + a5960);
  Y(48) = (t6283 - a5960);
  for i3714 in 0..6 {
    var a6001, s2410, s2411, s2412, s2413, t6301, t6302, t6303:complex;
    var a5996, a5997, a5998, a5999, a6000:int;
    a5996 = (1 + i3714);
    a5997 = (33 + i3714);
    a5998 = (4*i3714);
    s2410 = (dat1(a5998)*buf1(a5996));
    s2411 = (dat1((1 + a5998))*buf1(a5997));
    t6301 = (s2410 + s2411);
    t6302 = (s2410 - s2411);
    a5999 = (17 + i3714);
    a6000 = (49 + i3714);
    s2412 = (dat1((2 + a5998))*buf1(a5999));
    s2413 = (dat1((3 + a5998))*buf1(a6000));
    t6303 = (s2412 + s2413);
    Y(a5996) = (t6301 + t6303);
    Y(a5997) = (t6301 - t6303);
    a6001 = (1.0i*(s2412 - s2413));
    Y(a5999) = (t6302 + a6001);
    Y(a6000) = (t6302 - a6001);
  }
  var s2418, s2419, t6320, t6321:complex;
  t6320 = (buf1(8) + (1.0i*buf1(40)));
  t6321 = (buf1(8) + ((- 1.0i)*buf1(40)));
  s2418 = ((0.70710678118654757 + 1.0i * 0.70710678118654757)*(buf1(24) + (1.0i*buf1(56))));
  s2419 = ((-0.70710678118654757 + 1.0i * 0.70710678118654757)*(buf1(24) + ((- 1.0i)*buf1(56))));
  Y(8) = (t6320 + s2418);
  Y(40) = (t6320 - s2418);
  Y(24) = (t6321 + s2419);
  Y(56) = (t6321 - s2419);
  for i3715 in 0..6 {
    var a6058, s2436, s2437, s2438, s2439, t6338, t6339, t6340:complex;
    var a6053, a6054, a6055, a6056, a6057:int;
    a6053 = (9 + i3715);
    a6054 = (41 + i3715);
    a6055 = (4*i3715);
    s2436 = (dat2(a6055)*buf1(a6053));
    s2437 = (dat2((1 + a6055))*buf1(a6054));
    t6338 = (s2436 + s2437);
    t6339 = (s2436 - s2437);
    a6056 = (25 + i3715);
    a6057 = (57 + i3715);
    s2438 = (dat2((2 + a6055))*buf1(a6056));
    s2439 = (dat2((3 + a6055))*buf1(a6057));
    t6340 = (s2438 + s2439);
    Y(a6053) = (t6338 + t6340);
    Y(a6054) = (t6338 - t6340);
    a6058 = (1.0i*(s2438 - s2439));
    Y(a6056) = (t6339 + a6058);
    Y(a6057) = (t6339 - a6058);
  }

}
