/***************************************************************
This code was generated by  Spiral 5.0 beta, www.spiral.net --
Copyright (c) 2005, Carnegie Mellon University
All rights reserved.
The code is distributed under a BSD style license
(see http://www.opensource.org/licenses/bsd-license.php)

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are
met:

* Redistributions of source code must retain the above copyright
  notice, reference to Spiral, this list of conditions and the
  following disclaimer.
  * Redistributions in binary form must reproduce the above
  copyright notice, this list of conditions and the following
  disclaimer in the documentation and/or other materials provided
  with the distribution.
  * Neither the name of Carnegie Mellon University nor the name of its
  contributors may be used to endorse or promote products derived from
  this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
*AS IS* AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
******************************************************************/

use omega;
var  buf7: [0..1023] complex;
var  buf8: [0..63] complex;
var  dat15: [0..495] complex;
var  dat16: [0..495] complex;
var  dat17: [0..27] complex;
var  dat18: [0..27] complex;

proc init_fft1024() {
  for i4904 in 0..30 {
    for i4915 in 0..3 {
      for i4942 in 0..1 {
        dat15(((i4904*16) + (i4915*4) + (i4942*2))) = omega(1024, ((i4904 + 1)*(i4915 + (i4942*4))));
        dat15(((i4904*16) + (i4915*4) + (i4942*2) + 1)) = omega(1024, ((i4904 + 1)*(i4915 + (i4942*4) + 8)));
      }
    }
  }
  for i4905 in 0..30 {
    for i4923 in 0..3 {
      for i4958 in 0..1 {
        dat16(((i4905*16) + (i4923*4) + (i4958*2))) = omega(1024, ((33 + i4905)*(i4923 + (i4958*4))));
        dat16(((i4905*16) + (i4923*4) + (i4958*2) + 1)) = omega(1024, ((33 + i4905)*(i4923 + (i4958*4) + 8)));
      }
    }
  }
  for i4924 in 0..6 {
    for i4966 in 0..1 {
      dat17(((i4924*4) + (i4966*2))) = omega(64, ((i4924 + 1)*i4966));
      dat17(((i4924*4) + (i4966*2) + 1)) = omega(64, ((i4924 + 1)*(i4966 + 2)));
    }
  }
  for i4925 in 0..6 {
    for i4974 in 0..1 {
      dat18(((i4925*4) + (i4974*2))) = omega(64, ((9 + i4925)*i4974));
      dat18(((i4925*4) + (i4974*2) + 1)) = omega(64, ((9 + i4925)*(i4974 + 2)));
    }
  }

}

proc fft1024(Y: [] complex, X: [] complex) {
  for i4906 in 0..15 {
    for i4926 in 0..3 {
      var a7417, a7418, a7419, a7420, a7421, a7422, a7423, a7424, s3121, s3122, s3123, s3124, s3125, s3126, s3127, s3128, s3129, s3130, s3131, s3132, s3133, s3134, s3135, s3136, s3137, s3138, s3139, s3140, s3141, s3142, s3143, s3144, s3145, t7907, t7908, t7909, t7910, t7911, t7912, t7913, t7914, t7915, t7916, t7917, t7918, t7919, t7920, t7921, t7922, t7923, t7924, t7925, t7926, t7927, t7928, t7929, t7930, t7931, t7932, t7933, t7934, t7935, t7936, t7937:complex;
      var a7415, a7416:int;
      a7415 = (16*i4926);
      a7416 = (i4906 + a7415);
      s3121 = X(a7416);
      s3122 = X((a7416 + 512));
      t7907 = (s3121 + s3122);
      t7908 = (s3121 - s3122);
      s3123 = X((a7416 + 256));
      s3124 = X((a7416 + 768));
      t7909 = (s3123 + s3124);
      t7910 = (t7907 + t7909);
      t7911 = (t7907 - t7909);
      a7417 = (1.0i*(s3123 - s3124));
      t7912 = (t7908 + a7417);
      t7913 = (t7908 - a7417);
      s3125 = X((a7416 + 64));
      s3126 = X((a7416 + 576));
      t7914 = (s3125 + s3126);
      t7915 = (s3125 - s3126);
      s3127 = X((a7416 + 320));
      s3128 = X((a7416 + 832));
      t7916 = (s3127 + s3128);
      t7917 = (t7914 + t7916);
      s3129 = ((0.70710678118654757 + 1.0i * 0.70710678118654757)*(t7914 - t7916));
      a7418 = (1.0i*(s3127 - s3128));
      s3130 = ((0.92387953251128674 + 1.0i * 0.38268343236508978)*(t7915 + a7418));
      s3131 = ((0.38268343236508978 + 1.0i * 0.92387953251128674)*(t7915 - a7418));
      s3132 = X((a7416 + 128));
      s3133 = X((a7416 + 640));
      t7918 = (s3132 + s3133);
      t7919 = (s3132 - s3133);
      s3134 = X((a7416 + 384));
      s3135 = X((a7416 + 896));
      t7920 = (s3134 + s3135);
      t7921 = (t7918 + t7920);
      s3136 = (1.0i*(t7918 - t7920));
      a7419 = (1.0i*(s3134 - s3135));
      s3137 = ((0.70710678118654757 + 1.0i * 0.70710678118654757)*(t7919 + a7419));
      s3138 = ((-0.70710678118654757 + 1.0i * 0.70710678118654757)*(t7919 - a7419));
      s3139 = X((a7416 + 192));
      s3140 = X((a7416 + 704));
      t7922 = (s3139 + s3140);
      t7923 = (s3139 - s3140);
      s3141 = X((a7416 + 448));
      s3142 = X((a7416 + 960));
      t7924 = (s3141 + s3142);
      t7925 = (t7922 + t7924);
      s3143 = ((-0.70710678118654757 + 1.0i * 0.70710678118654757)*(t7922 - t7924));
      a7420 = (1.0i*(s3141 - s3142));
      s3144 = ((0.38268343236508978 + 1.0i * 0.92387953251128674)*(t7923 + a7420));
      s3145 = ((-0.92387953251128674 - 1.0i * 0.38268343236508978)*(t7923 - a7420));
      t7926 = (t7910 + t7921);
      t7927 = (t7910 - t7921);
      t7928 = (t7917 + t7925);
      buf8(a7415) = (t7926 + t7928);
      buf8((8 + a7415)) = (t7926 - t7928);
      a7421 = (1.0i*(t7917 - t7925));
      buf8((4 + a7415)) = (t7927 + a7421);
      buf8((12 + a7415)) = (t7927 - a7421);
      t7929 = (t7912 + s3137);
      t7930 = (t7912 - s3137);
      t7931 = (s3130 + s3144);
      buf8((1 + a7415)) = (t7929 + t7931);
      buf8((9 + a7415)) = (t7929 - t7931);
      a7422 = (1.0i*(s3130 - s3144));
      buf8((5 + a7415)) = (t7930 + a7422);
      buf8((13 + a7415)) = (t7930 - a7422);
      t7932 = (t7911 + s3136);
      t7933 = (t7911 - s3136);
      t7934 = (s3129 + s3143);
      buf8((2 + a7415)) = (t7932 + t7934);
      buf8((10 + a7415)) = (t7932 - t7934);
      a7423 = (1.0i*(s3129 - s3143));
      buf8((6 + a7415)) = (t7933 + a7423);
      buf8((14 + a7415)) = (t7933 - a7423);
      t7935 = (t7913 + s3138);
      t7936 = (t7913 - s3138);
      t7937 = (s3131 + s3145);
      buf8((3 + a7415)) = (t7935 + t7937);
      buf8((11 + a7415)) = (t7935 - t7937);
      a7424 = (1.0i*(s3131 - s3145));
      buf8((7 + a7415)) = (t7936 + a7424);
      buf8((15 + a7415)) = (t7936 - a7424);
    }
    var a7449, t7954, t7955, t7956:complex;
    var a7448:int;
    t7954 = (buf8(0) + buf8(32));
    t7955 = (buf8(0) - buf8(32));
    t7956 = (buf8(16) + buf8(48));
    a7448 = (64*i4906);
    buf7(a7448) = (t7954 + t7956);
    buf7((a7448 + 32)) = (t7954 - t7956);
    a7449 = (1.0i*(buf8(16) - buf8(48)));
    buf7((16 + a7448)) = (t7955 + a7449);
    buf7((48 + a7448)) = (t7955 - a7449);
    for i4924 in 0..6 {
      var a7495, s3162, s3163, s3164, s3165, t7973, t7974, t7975:complex;
      var a7494, b974:int;
      a7494 = (4*i4924);
      s3162 = (dat17(a7494)*buf8((1 + i4924)));
      s3163 = (dat17((1 + a7494))*buf8((33 + i4924)));
      t7973 = (s3162 + s3163);
      t7974 = (s3162 - s3163);
      s3164 = (dat17((2 + a7494))*buf8((17 + i4924)));
      s3165 = (dat17((3 + a7494))*buf8((49 + i4924)));
      t7975 = (s3164 + s3165);
      b974 = ((64*i4906) + i4924);
      buf7((b974 + 1)) = (t7973 + t7975);
      buf7((b974 + 33)) = (t7973 - t7975);
      a7495 = (1.0i*(s3164 - s3165));
      buf7((b974 + 17)) = (t7974 + a7495);
      buf7((b974 + 49)) = (t7974 - a7495);
    }
    var s3170, s3171, t7992, t7993:complex;
    var a7525:int;
    t7992 = (buf8(8) + (1.0i*buf8(40)));
    t7993 = (buf8(8) + ((- 1.0i)*buf8(40)));
    s3170 = ((0.70710678118654757 + 1.0i * 0.70710678118654757)*(buf8(24) + (1.0i*buf8(56))));
    s3171 = ((-0.70710678118654757 + 1.0i * 0.70710678118654757)*(buf8(24) + ((- 1.0i)*buf8(56))));
    a7525 = (64*i4906);
    buf7((8 + a7525)) = (t7992 + s3170);
    buf7((40 + a7525)) = (t7992 - s3170);
    buf7((24 + a7525)) = (t7993 + s3171);
    buf7((56 + a7525)) = (t7993 - s3171);
    for i4925 in 0..6 {
      var a7571, s3188, s3189, s3190, s3191, t8010, t8011, t8012:complex;
      var a7570, b980:int;
      a7570 = (4*i4925);
      s3188 = (dat18(a7570)*buf8((9 + i4925)));
      s3189 = (dat18((1 + a7570))*buf8((41 + i4925)));
      t8010 = (s3188 + s3189);
      t8011 = (s3188 - s3189);
      s3190 = (dat18((2 + a7570))*buf8((25 + i4925)));
      s3191 = (dat18((3 + a7570))*buf8((57 + i4925)));
      t8012 = (s3190 + s3191);
      b980 = ((64*i4906) + i4925);
      buf7((b980 + 9)) = (t8010 + t8012);
      buf7((b980 + 41)) = (t8010 - t8012);
      a7571 = (1.0i*(s3190 - s3191));
      buf7((b980 + 25)) = (t8011 + a7571);
      buf7((b980 + 57)) = (t8011 - a7571);
    }
  }
  var a7636, a7637, a7638, a7639, a7640, a7641, a7642, a7643, s3210, s3211, s3212, s3213, s3214, s3215, s3216, s3217, s3218, t8141, t8142, t8143, t8144, t8145, t8146, t8147, t8148, t8149, t8150, t8151, t8152, t8153, t8154, t8155, t8156, t8157, t8158, t8159, t8160, t8161, t8162, t8163, t8164, t8165, t8166, t8167, t8168, t8169, t8170, t8171:complex;
  t8141 = (buf7(0) + buf7(512));
  t8142 = (buf7(0) - buf7(512));
  t8143 = (buf7(256) + buf7(768));
  t8144 = (t8141 + t8143);
  t8145 = (t8141 - t8143);
  a7636 = (1.0i*(buf7(256) - buf7(768)));
  t8146 = (t8142 + a7636);
  t8147 = (t8142 - a7636);
  t8148 = (buf7(64) + buf7(576));
  t8149 = (buf7(64) - buf7(576));
  t8150 = (buf7(320) + buf7(832));
  t8151 = (t8148 + t8150);
  s3210 = ((0.70710678118654757 + 1.0i * 0.70710678118654757)*(t8148 - t8150));
  a7637 = (1.0i*(buf7(320) - buf7(832)));
  s3211 = ((0.92387953251128674 + 1.0i * 0.38268343236508978)*(t8149 + a7637));
  s3212 = ((0.38268343236508978 + 1.0i * 0.92387953251128674)*(t8149 - a7637));
  t8152 = (buf7(128) + buf7(640));
  t8153 = (buf7(128) - buf7(640));
  t8154 = (buf7(384) + buf7(896));
  t8155 = (t8152 + t8154);
  s3213 = (1.0i*(t8152 - t8154));
  a7638 = (1.0i*(buf7(384) - buf7(896)));
  s3214 = ((0.70710678118654757 + 1.0i * 0.70710678118654757)*(t8153 + a7638));
  s3215 = ((-0.70710678118654757 + 1.0i * 0.70710678118654757)*(t8153 - a7638));
  t8156 = (buf7(192) + buf7(704));
  t8157 = (buf7(192) - buf7(704));
  t8158 = (buf7(448) + buf7(960));
  t8159 = (t8156 + t8158);
  s3216 = ((-0.70710678118654757 + 1.0i * 0.70710678118654757)*(t8156 - t8158));
  a7639 = (1.0i*(buf7(448) - buf7(960)));
  s3217 = ((0.38268343236508978 + 1.0i * 0.92387953251128674)*(t8157 + a7639));
  s3218 = ((-0.92387953251128674 - 1.0i * 0.38268343236508978)*(t8157 - a7639));
  t8160 = (t8144 + t8155);
  t8161 = (t8144 - t8155);
  t8162 = (t8151 + t8159);
  Y(0) = (t8160 + t8162);
  Y(512) = (t8160 - t8162);
  a7640 = (1.0i*(t8151 - t8159));
  Y(256) = (t8161 + a7640);
  Y(768) = (t8161 - a7640);
  t8163 = (t8146 + s3214);
  t8164 = (t8146 - s3214);
  t8165 = (s3211 + s3217);
  Y(64) = (t8163 + t8165);
  Y(576) = (t8163 - t8165);
  a7641 = (1.0i*(s3211 - s3217));
  Y(320) = (t8164 + a7641);
  Y(832) = (t8164 - a7641);
  t8166 = (t8145 + s3213);
  t8167 = (t8145 - s3213);
  t8168 = (s3210 + s3216);
  Y(128) = (t8166 + t8168);
  Y(640) = (t8166 - t8168);
  a7642 = (1.0i*(s3210 - s3216));
  Y(384) = (t8167 + a7642);
  Y(896) = (t8167 - a7642);
  t8169 = (t8147 + s3215);
  t8170 = (t8147 - s3215);
  t8171 = (s3212 + s3218);
  Y(192) = (t8169 + t8171);
  Y(704) = (t8169 - t8171);
  a7643 = (1.0i*(s3212 - s3218));
  Y(448) = (t8170 + a7643);
  Y(960) = (t8170 - a7643);
  for i4904 in 0..30 {
    var a7808, a7813, a7818, a7823, a7824, a7825, a7826, a7827, s3301, s3302, s3303, s3304, s3305, s3306, s3307, s3308, s3309, s3310, s3311, s3312, s3313, s3314, s3315, s3316, s3317, s3318, s3319, s3320, s3321, s3322, s3323, s3324, s3325, t8300, t8301, t8302, t8303, t8304, t8305, t8306, t8307, t8308, t8309, t8310, t8311, t8312, t8313, t8314, t8315, t8316, t8317, t8318, t8319, t8320, t8321, t8322, t8323, t8324, t8325, t8326, t8327, t8328, t8329, t8330:complex;
    var a7803, a7804, a7805, a7806, a7807, a7809, a7810, a7811, a7812, a7814, a7815, a7816, a7817, a7819, a7820, a7821, a7822:int;
    a7803 = (1 + i4904);
    a7804 = (513 + i4904);
    a7805 = (16*i4904);
    s3301 = (dat15(a7805)*buf7(a7803));
    s3302 = (dat15((1 + a7805))*buf7(a7804));
    t8300 = (s3301 + s3302);
    t8301 = (s3301 - s3302);
    a7806 = (257 + i4904);
    a7807 = (769 + i4904);
    s3303 = (dat15((2 + a7805))*buf7(a7806));
    s3304 = (dat15((3 + a7805))*buf7(a7807));
    t8302 = (s3303 + s3304);
    t8303 = (t8300 + t8302);
    t8304 = (t8300 - t8302);
    a7808 = (1.0i*(s3303 - s3304));
    t8305 = (t8301 + a7808);
    t8306 = (t8301 - a7808);
    a7809 = (65 + i4904);
    a7810 = (577 + i4904);
    s3305 = (dat15((4 + a7805))*buf7(a7809));
    s3306 = (dat15((5 + a7805))*buf7(a7810));
    t8307 = (s3305 + s3306);
    t8308 = (s3305 - s3306);
    a7811 = (321 + i4904);
    a7812 = (833 + i4904);
    s3307 = (dat15((6 + a7805))*buf7(a7811));
    s3308 = (dat15((7 + a7805))*buf7(a7812));
    t8309 = (s3307 + s3308);
    t8310 = (t8307 + t8309);
    s3309 = ((0.70710678118654757 + 1.0i * 0.70710678118654757)*(t8307 - t8309));
    a7813 = (1.0i*(s3307 - s3308));
    s3310 = ((0.92387953251128674 + 1.0i * 0.38268343236508978)*(t8308 + a7813));
    s3311 = ((0.38268343236508978 + 1.0i * 0.92387953251128674)*(t8308 - a7813));
    a7814 = (129 + i4904);
    a7815 = (641 + i4904);
    s3312 = (dat15((8 + a7805))*buf7(a7814));
    s3313 = (dat15((9 + a7805))*buf7(a7815));
    t8311 = (s3312 + s3313);
    t8312 = (s3312 - s3313);
    a7816 = (385 + i4904);
    a7817 = (897 + i4904);
    s3314 = (dat15((10 + a7805))*buf7(a7816));
    s3315 = (dat15((11 + a7805))*buf7(a7817));
    t8313 = (s3314 + s3315);
    t8314 = (t8311 + t8313);
    s3316 = (1.0i*(t8311 - t8313));
    a7818 = (1.0i*(s3314 - s3315));
    s3317 = ((0.70710678118654757 + 1.0i * 0.70710678118654757)*(t8312 + a7818));
    s3318 = ((-0.70710678118654757 + 1.0i * 0.70710678118654757)*(t8312 - a7818));
    a7819 = (193 + i4904);
    a7820 = (705 + i4904);
    s3319 = (dat15((12 + a7805))*buf7(a7819));
    s3320 = (dat15((13 + a7805))*buf7(a7820));
    t8315 = (s3319 + s3320);
    t8316 = (s3319 - s3320);
    a7821 = (449 + i4904);
    a7822 = (961 + i4904);
    s3321 = (dat15((14 + a7805))*buf7(a7821));
    s3322 = (dat15((15 + a7805))*buf7(a7822));
    t8317 = (s3321 + s3322);
    t8318 = (t8315 + t8317);
    s3323 = ((-0.70710678118654757 + 1.0i * 0.70710678118654757)*(t8315 - t8317));
    a7823 = (1.0i*(s3321 - s3322));
    s3324 = ((0.38268343236508978 + 1.0i * 0.92387953251128674)*(t8316 + a7823));
    s3325 = ((-0.92387953251128674 - 1.0i * 0.38268343236508978)*(t8316 - a7823));
    t8319 = (t8303 + t8314);
    t8320 = (t8303 - t8314);
    t8321 = (t8310 + t8318);
    Y(a7803) = (t8319 + t8321);
    Y(a7804) = (t8319 - t8321);
    a7824 = (1.0i*(t8310 - t8318));
    Y(a7806) = (t8320 + a7824);
    Y(a7807) = (t8320 - a7824);
    t8322 = (t8305 + s3317);
    t8323 = (t8305 - s3317);
    t8324 = (s3310 + s3324);
    Y(a7809) = (t8322 + t8324);
    Y(a7810) = (t8322 - t8324);
    a7825 = (1.0i*(s3310 - s3324));
    Y(a7811) = (t8323 + a7825);
    Y(a7812) = (t8323 - a7825);
    t8325 = (t8304 + s3316);
    t8326 = (t8304 - s3316);
    t8327 = (s3309 + s3323);
    Y(a7814) = (t8325 + t8327);
    Y(a7815) = (t8325 - t8327);
    a7826 = (1.0i*(s3309 - s3323));
    Y(a7816) = (t8326 + a7826);
    Y(a7817) = (t8326 - a7826);
    t8328 = (t8306 + s3318);
    t8329 = (t8306 - s3318);
    t8330 = (s3311 + s3325);
    Y(a7819) = (t8328 + t8330);
    Y(a7820) = (t8328 - t8330);
    a7827 = (1.0i*(s3311 - s3325));
    Y(a7821) = (t8329 + a7827);
    Y(a7822) = (t8329 - a7827);
  }
  var a7908, a7909, a7910, a7911, s3366, s3367, s3368, s3369, s3370, s3371, s3372, s3373, s3374, s3375, s3376, s3377, s3378, s3379, s3380, s3381, s3382, s3383, s3384, s3385, t8459, t8460, t8461, t8462, t8463, t8464, t8465, t8466, t8467, t8468, t8469, t8470, t8471, t8472, t8473, t8474, t8475, t8476, t8477, t8478, t8479, t8480, t8481, t8482:complex;
  t8459 = (buf7(32) + (1.0i*buf7(544)));
  t8460 = (buf7(32) + ((- 1.0i)*buf7(544)));
  s3366 = ((0.70710678118654757 + 1.0i * 0.70710678118654757)*(buf7(288) + (1.0i*buf7(800))));
  s3367 = ((-0.70710678118654757 + 1.0i * 0.70710678118654757)*(buf7(288) + ((- 1.0i)*buf7(800))));
  t8461 = (t8459 + s3366);
  t8462 = (t8459 - s3366);
  t8463 = (t8460 + s3367);
  t8464 = (t8460 - s3367);
  t8465 = (buf7(96) + (1.0i*buf7(608)));
  t8466 = (buf7(96) + ((- 1.0i)*buf7(608)));
  s3368 = ((0.70710678118654757 + 1.0i * 0.70710678118654757)*(buf7(352) + (1.0i*buf7(864))));
  s3369 = ((-0.70710678118654757 + 1.0i * 0.70710678118654757)*(buf7(352) + ((- 1.0i)*buf7(864))));
  s3370 = ((0.98078528040323043 + 1.0i * 0.19509032201612825)*(t8465 + s3368));
  s3371 = ((0.55557023301960218 + 1.0i * 0.83146961230254524)*(t8465 - s3368));
  s3372 = ((0.83146961230254524 + 1.0i * 0.55557023301960218)*(t8466 + s3369));
  s3373 = ((0.19509032201612825 + 1.0i * 0.98078528040323043)*(t8466 - s3369));
  t8467 = (buf7(160) + (1.0i*buf7(672)));
  t8468 = (buf7(160) + ((- 1.0i)*buf7(672)));
  s3374 = ((0.70710678118654757 + 1.0i * 0.70710678118654757)*(buf7(416) + (1.0i*buf7(928))));
  s3375 = ((-0.70710678118654757 + 1.0i * 0.70710678118654757)*(buf7(416) + ((- 1.0i)*buf7(928))));
  s3376 = ((0.92387953251128674 + 1.0i * 0.38268343236508978)*(t8467 + s3374));
  s3377 = ((-0.38268343236508978 + 1.0i * 0.92387953251128674)*(t8467 - s3374));
  s3378 = ((0.38268343236508978 + 1.0i * 0.92387953251128674)*(t8468 + s3375));
  s3379 = ((-0.92387953251128674 + 1.0i * 0.38268343236508978)*(t8468 - s3375));
  t8469 = (buf7(224) + (1.0i*buf7(736)));
  t8470 = (buf7(224) + ((- 1.0i)*buf7(736)));
  s3380 = ((0.70710678118654757 + 1.0i * 0.70710678118654757)*(buf7(480) + (1.0i*buf7(992))));
  s3381 = ((-0.70710678118654757 + 1.0i * 0.70710678118654757)*(buf7(480) + ((- 1.0i)*buf7(992))));
  s3382 = ((0.83146961230254524 + 1.0i * 0.55557023301960218)*(t8469 + s3380));
  s3383 = ((-0.98078528040323043 + 1.0i * 0.19509032201612825)*(t8469 - s3380));
  s3384 = ((-0.19509032201612825 + 1.0i * 0.98078528040323043)*(t8470 + s3381));
  s3385 = ((-0.55557023301960218 - 1.0i * 0.83146961230254524)*(t8470 - s3381));
  t8471 = (t8461 + s3376);
  t8472 = (t8461 - s3376);
  t8473 = (s3370 + s3382);
  Y(32) = (t8471 + t8473);
  Y(544) = (t8471 - t8473);
  a7908 = (1.0i*(s3370 - s3382));
  Y(288) = (t8472 + a7908);
  Y(800) = (t8472 - a7908);
  t8474 = (t8463 + s3378);
  t8475 = (t8463 - s3378);
  t8476 = (s3372 + s3384);
  Y(96) = (t8474 + t8476);
  Y(608) = (t8474 - t8476);
  a7909 = (1.0i*(s3372 - s3384));
  Y(352) = (t8475 + a7909);
  Y(864) = (t8475 - a7909);
  t8477 = (t8462 + s3377);
  t8478 = (t8462 - s3377);
  t8479 = (s3371 + s3383);
  Y(160) = (t8477 + t8479);
  Y(672) = (t8477 - t8479);
  a7910 = (1.0i*(s3371 - s3383));
  Y(416) = (t8478 + a7910);
  Y(928) = (t8478 - a7910);
  t8480 = (t8464 + s3379);
  t8481 = (t8464 - s3379);
  t8482 = (s3373 + s3385);
  Y(224) = (t8480 + t8482);
  Y(736) = (t8480 - t8482);
  a7911 = (1.0i*(s3373 - s3385));
  Y(480) = (t8481 + a7911);
  Y(992) = (t8481 - a7911);
  for i4905 in 0..30 {
    var a8076, a8081, a8086, a8091, a8092, a8093, a8094, a8095, s3468, s3469, s3470, s3471, s3472, s3473, s3474, s3475, s3476, s3477, s3478, s3479, s3480, s3481, s3482, s3483, s3484, s3485, s3486, s3487, s3488, s3489, s3490, s3491, s3492, t8611, t8612, t8613, t8614, t8615, t8616, t8617, t8618, t8619, t8620, t8621, t8622, t8623, t8624, t8625, t8626, t8627, t8628, t8629, t8630, t8631, t8632, t8633, t8634, t8635, t8636, t8637, t8638, t8639, t8640, t8641:complex;
    var a8071, a8072, a8073, a8074, a8075, a8077, a8078, a8079, a8080, a8082, a8083, a8084, a8085, a8087, a8088, a8089, a8090:int;
    a8071 = (33 + i4905);
    a8072 = (545 + i4905);
    a8073 = (16*i4905);
    s3468 = (dat16(a8073)*buf7(a8071));
    s3469 = (dat16((1 + a8073))*buf7(a8072));
    t8611 = (s3468 + s3469);
    t8612 = (s3468 - s3469);
    a8074 = (289 + i4905);
    a8075 = (801 + i4905);
    s3470 = (dat16((2 + a8073))*buf7(a8074));
    s3471 = (dat16((3 + a8073))*buf7(a8075));
    t8613 = (s3470 + s3471);
    t8614 = (t8611 + t8613);
    t8615 = (t8611 - t8613);
    a8076 = (1.0i*(s3470 - s3471));
    t8616 = (t8612 + a8076);
    t8617 = (t8612 - a8076);
    a8077 = (97 + i4905);
    a8078 = (609 + i4905);
    s3472 = (dat16((4 + a8073))*buf7(a8077));
    s3473 = (dat16((5 + a8073))*buf7(a8078));
    t8618 = (s3472 + s3473);
    t8619 = (s3472 - s3473);
    a8079 = (353 + i4905);
    a8080 = (865 + i4905);
    s3474 = (dat16((6 + a8073))*buf7(a8079));
    s3475 = (dat16((7 + a8073))*buf7(a8080));
    t8620 = (s3474 + s3475);
    t8621 = (t8618 + t8620);
    s3476 = ((0.70710678118654757 + 1.0i * 0.70710678118654757)*(t8618 - t8620));
    a8081 = (1.0i*(s3474 - s3475));
    s3477 = ((0.92387953251128674 + 1.0i * 0.38268343236508978)*(t8619 + a8081));
    s3478 = ((0.38268343236508978 + 1.0i * 0.92387953251128674)*(t8619 - a8081));
    a8082 = (161 + i4905);
    a8083 = (673 + i4905);
    s3479 = (dat16((8 + a8073))*buf7(a8082));
    s3480 = (dat16((9 + a8073))*buf7(a8083));
    t8622 = (s3479 + s3480);
    t8623 = (s3479 - s3480);
    a8084 = (417 + i4905);
    a8085 = (929 + i4905);
    s3481 = (dat16((10 + a8073))*buf7(a8084));
    s3482 = (dat16((11 + a8073))*buf7(a8085));
    t8624 = (s3481 + s3482);
    t8625 = (t8622 + t8624);
    s3483 = (1.0i*(t8622 - t8624));
    a8086 = (1.0i*(s3481 - s3482));
    s3484 = ((0.70710678118654757 + 1.0i * 0.70710678118654757)*(t8623 + a8086));
    s3485 = ((-0.70710678118654757 + 1.0i * 0.70710678118654757)*(t8623 - a8086));
    a8087 = (225 + i4905);
    a8088 = (737 + i4905);
    s3486 = (dat16((12 + a8073))*buf7(a8087));
    s3487 = (dat16((13 + a8073))*buf7(a8088));
    t8626 = (s3486 + s3487);
    t8627 = (s3486 - s3487);
    a8089 = (481 + i4905);
    a8090 = (993 + i4905);
    s3488 = (dat16((14 + a8073))*buf7(a8089));
    s3489 = (dat16((15 + a8073))*buf7(a8090));
    t8628 = (s3488 + s3489);
    t8629 = (t8626 + t8628);
    s3490 = ((-0.70710678118654757 + 1.0i * 0.70710678118654757)*(t8626 - t8628));
    a8091 = (1.0i*(s3488 - s3489));
    s3491 = ((0.38268343236508978 + 1.0i * 0.92387953251128674)*(t8627 + a8091));
    s3492 = ((-0.92387953251128674 - 1.0i * 0.38268343236508978)*(t8627 - a8091));
    t8630 = (t8614 + t8625);
    t8631 = (t8614 - t8625);
    t8632 = (t8621 + t8629);
    Y(a8071) = (t8630 + t8632);
    Y(a8072) = (t8630 - t8632);
    a8092 = (1.0i*(t8621 - t8629));
    Y(a8074) = (t8631 + a8092);
    Y(a8075) = (t8631 - a8092);
    t8633 = (t8616 + s3484);
    t8634 = (t8616 - s3484);
    t8635 = (s3477 + s3491);
    Y(a8077) = (t8633 + t8635);
    Y(a8078) = (t8633 - t8635);
    a8093 = (1.0i*(s3477 - s3491));
    Y(a8079) = (t8634 + a8093);
    Y(a8080) = (t8634 - a8093);
    t8636 = (t8615 + s3483);
    t8637 = (t8615 - s3483);
    t8638 = (s3476 + s3490);
    Y(a8082) = (t8636 + t8638);
    Y(a8083) = (t8636 - t8638);
    a8094 = (1.0i*(s3476 - s3490));
    Y(a8084) = (t8637 + a8094);
    Y(a8085) = (t8637 - a8094);
    t8639 = (t8617 + s3485);
    t8640 = (t8617 - s3485);
    t8641 = (s3478 + s3492);
    Y(a8087) = (t8639 + t8641);
    Y(a8088) = (t8639 - t8641);
    a8095 = (1.0i*(s3478 - s3492));
    Y(a8089) = (t8640 + a8095);
    Y(a8090) = (t8640 - a8095);
  }

}
