/***************************************************************
This code was generated by  Spiral 5.0 beta, www.spiral.net --
Copyright (c) 2005, Carnegie Mellon University
All rights reserved.
The code is distributed under a BSD style license
(see http://www.opensource.org/licenses/bsd-license.php)

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are
met:

* Redistributions of source code must retain the above copyright
  notice, reference to Spiral, this list of conditions and the
  following disclaimer.
  * Redistributions in binary form must reproduce the above
  copyright notice, this list of conditions and the following
  disclaimer in the documentation and/or other materials provided
  with the distribution.
  * Neither the name of Carnegie Mellon University nor the name of its
  contributors may be used to endorse or promote products derived from
  this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
*AS IS* AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
******************************************************************/

/*	CPU: Intel Core2Duo at 2660 MHz, 2 cores, SSE3
  OS: Microsoft WindowsXP 32-bit
  SVN: 5262
  language: c.icl.opt
  timestamp: Oct 8, 2007; 9:20:57
  transform: DFT(2048, 1)
  performance: 111436 cycles, 2688 Mflop/s
*/

#include "omega64c.h"
static _Complex double D19[124];
static _Complex double D20[124];
static _Complex double D21[124];
static _Complex double D22[124];
static _Complex double D23[248];
static _Complex double D24[124];
static _Complex double D25[124];
static _Complex double D26[124];
static _Complex double D27[124];
static _Complex double D28[124];
static _Complex double D29[124];
static _Complex double D30[248];
static _Complex double D31[124];
static _Complex double D32[124];
static _Complex double D33[28];
static _Complex double D34[28];

void init_fft2048() {
  for(int i1941 = 0; i1941 <= 30; i1941++) {
    for(int i2085 = 0; i2085 <= 1; i2085++) {
      D19[((i1941*4) + (i2085*2))] = omega(2048, ((i1941 + 1)*(i2085*8)));
      D19[((i1941*4) + (i2085*2) + 1)] = omega(2048, ((i1941 + 1)*((i2085*8) + 16)));
    }
  }
  for(int i1941 = 0; i1941 <= 30; i1941++) {
    for(int i1999 = 0; i1999 <= 1; i1999++) {
      D20[((i1941*4) + (i1999*2))] = omega(2048, ((i1941 + 1)*(4 + (i1999*8))));
      D20[((i1941*4) + (i1999*2) + 1)] = omega(2048, ((i1941 + 1)*(20 + (i1999*8))));
    }
  }
  for(int i1941 = 0; i1941 <= 30; i1941++) {
    for(int i2089 = 0; i2089 <= 1; i2089++) {
      D21[((i1941*4) + (i2089*2))] = omega(2048, ((i1941 + 1)*(1 + (i2089*8))));
      D21[((i1941*4) + (i2089*2) + 1)] = omega(2048, ((i1941 + 1)*(17 + (i2089*8))));
    }
  }
  for(int i1941 = 0; i1941 <= 30; i1941++) {
    for(int i2005 = 0; i2005 <= 1; i2005++) {
      D22[((i1941*4) + (i2005*2))] = omega(2048, ((i1941 + 1)*(5 + (i2005*8))));
      D22[((i1941*4) + (i2005*2) + 1)] = omega(2048, ((i1941 + 1)*(21 + (i2005*8))));
    }
  }
  for(int i1941 = 0; i1941 <= 30; i1941++) {
    for(int i2010 = 0; i2010 <= 1; i2010++) {
      for(int i2093 = 0; i2093 <= 1; i2093++) {
        D23[((i1941*8) + (i2010*4) + (i2093*2))] = omega(2048, ((i1941 + 1)*(2 + (i2010*4) + (i2093*8))));
        D23[((i1941*8) + (i2010*4) + (i2093*2) + 1)] = omega(2048, ((i1941 + 1)*(18 + (i2010*4) + (i2093*8))));
      }
    }
  }
  for(int i1941 = 0; i1941 <= 30; i1941++) {
    for(int i2097 = 0; i2097 <= 1; i2097++) {
      D24[((i1941*4) + (i2097*2))] = omega(2048, ((i1941 + 1)*(3 + (i2097*8))));
      D24[((i1941*4) + (i2097*2) + 1)] = omega(2048, ((i1941 + 1)*(19 + (i2097*8))));
    }
  }
  for(int i1941 = 0; i1941 <= 30; i1941++) {
    for(int i2015 = 0; i2015 <= 1; i2015++) {
      D25[((i1941*4) + (i2015*2))] = omega(2048, ((i1941 + 1)*(7 + (i2015*8))));
      D25[((i1941*4) + (i2015*2) + 1)] = omega(2048, ((i1941 + 1)*(23 + (i2015*8))));
    }
  }
  for(int i1942 = 0; i1942 <= 30; i1942++) {
    for(int i2109 = 0; i2109 <= 1; i2109++) {
      D26[((i1942*4) + (i2109*2))] = omega(2048, ((33 + i1942)*(i2109*8)));
      D26[((i1942*4) + (i2109*2) + 1)] = omega(2048, ((33 + i1942)*((i2109*8) + 16)));
    }
  }
  for(int i1942 = 0; i1942 <= 30; i1942++) {
    for(int i2029 = 0; i2029 <= 1; i2029++) {
      D27[((i1942*4) + (i2029*2))] = omega(2048, ((33 + i1942)*(4 + (i2029*8))));
      D27[((i1942*4) + (i2029*2) + 1)] = omega(2048, ((33 + i1942)*(20 + (i2029*8))));
    }
  }
  for(int i1942 = 0; i1942 <= 30; i1942++) {
    for(int i2113 = 0; i2113 <= 1; i2113++) {
      D28[((i1942*4) + (i2113*2))] = omega(2048, ((33 + i1942)*(1 + (i2113*8))));
      D28[((i1942*4) + (i2113*2) + 1)] = omega(2048, ((33 + i1942)*(17 + (i2113*8))));
    }
  }
  for(int i1942 = 0; i1942 <= 30; i1942++) {
    for(int i2035 = 0; i2035 <= 1; i2035++) {
      D29[((i1942*4) + (i2035*2))] = omega(2048, ((33 + i1942)*(5 + (i2035*8))));
      D29[((i1942*4) + (i2035*2) + 1)] = omega(2048, ((33 + i1942)*(21 + (i2035*8))));
    }
  }
  for(int i1942 = 0; i1942 <= 30; i1942++) {
    for(int i2040 = 0; i2040 <= 1; i2040++) {
      for(int i2117 = 0; i2117 <= 1; i2117++) {
        D30[((i1942*8) + (i2040*4) + (i2117*2))] = omega(2048, ((33 + i1942)*(2 + (i2040*4) + (i2117*8))));
        D30[((i1942*8) + (i2040*4) + (i2117*2) + 1)] = omega(2048, ((33 + i1942)*(18 + (i2040*4) + (i2117*8))));
      }
    }
  }
  for(int i1942 = 0; i1942 <= 30; i1942++) {
    for(int i2121 = 0; i2121 <= 1; i2121++) {
      D31[((i1942*4) + (i2121*2))] = omega(2048, ((33 + i1942)*(3 + (i2121*8))));
      D31[((i1942*4) + (i2121*2) + 1)] = omega(2048, ((33 + i1942)*(19 + (i2121*8))));
    }
  }
  for(int i1942 = 0; i1942 <= 30; i1942++) {
    for(int i2045 = 0; i2045 <= 1; i2045++) {
      D32[((i1942*4) + (i2045*2))] = omega(2048, ((33 + i1942)*(7 + (i2045*8))));
      D32[((i1942*4) + (i2045*2) + 1)] = omega(2048, ((33 + i1942)*(23 + (i2045*8))));
    }
  }
  for(int i1961 = 0; i1961 <= 6; i1961++) {
    for(int i2053 = 0; i2053 <= 1; i2053++) {
      D33[((i1961*4) + (i2053*2))] = omega(64, ((i1961 + 1)*i2053));
      D33[((i1961*4) + (i2053*2) + 1)] = omega(64, ((i1961 + 1)*(i2053 + 2)));
    }
  }
  for(int i1962 = 0; i1962 <= 6; i1962++) {
    for(int i2061 = 0; i2061 <= 1; i2061++) {
      D34[((i1962*4) + (i2061*2))] = omega(64, ((9 + i1962)*i2061));
      D34[((i1962*4) + (i2061*2) + 1)] = omega(64, ((9 + i1962)*(i2061 + 2)));
    }
  }
}

void fft2048(_Complex double  *Y, _Complex double  *X) {
  static _Complex double T553[2048];
  for(int i1943 = 0; i1943 <= 31; i1943++) {
    static _Complex double T554[64];
    for(int i1963 = 0; i1963 <= 3; i1963++) {
      _Complex double a3813, t3653, t3652, t3651, a3812, t3650, t3649, 
        t3648, a3811, t3647, t3646, t3645, a3810, t3644, t3643, 
        t3642, s1385, s1384, a3808, s1383, t3641, t3640, s1382, 
        s1381, t3639, t3638, s1380, s1379, s1378, s1377, a3807, 
        s1376, t3637, t3636, s1375, s1374, t3635, t3634, s1373, 
        s1372, s1371, s1370, a3806, s1369, t3633, t3632, s1368, 
        s1367, t3631, t3630, s1366, s1365, t3629, t3628, a3805, 
        t3627, t3626, t3625, s1364, s1363, t3624, t3623, s1362, 
        s1361;
      _Complex double  *a3809, *a3804;
      a3804 = (X + i1943 + (32*i1963));
      s1361 = *(a3804);
      s1362 = *((a3804 + 1024));
      t3623 = (s1361 + s1362);
      t3624 = (s1361 - s1362);
      s1363 = *((a3804 + 512));
      s1364 = *((a3804 + 1536));
      t3625 = (s1363 + s1364);
      t3626 = (t3623 + t3625);
      t3627 = (t3623 - t3625);
      a3805 = (__I__*(s1363 - s1364));
      t3628 = (t3624 + a3805);
      t3629 = (t3624 - a3805);
      s1365 = *((a3804 + 128));
      s1366 = *((a3804 + 1152));
      t3630 = (s1365 + s1366);
      t3631 = (s1365 - s1366);
      s1367 = *((a3804 + 640));
      s1368 = *((a3804 + 1664));
      t3632 = (s1367 + s1368);
      t3633 = (t3630 + t3632);
      s1369 = ((0.70710678118654757 + __I__ * 0.70710678118654757)*(t3630 - t3632));
      a3806 = (__I__*(s1367 - s1368));
      s1370 = ((0.92387953251128674 + __I__ * 0.38268343236508978)*(t3631 + a3806));
      s1371 = ((0.38268343236508978 + __I__ * 0.92387953251128674)*(t3631 - a3806));
      s1372 = *((a3804 + 256));
      s1373 = *((a3804 + 1280));
      t3634 = (s1372 + s1373);
      t3635 = (s1372 - s1373);
      s1374 = *((a3804 + 768));
      s1375 = *((a3804 + 1792));
      t3636 = (s1374 + s1375);
      t3637 = (t3634 + t3636);
      s1376 = (__I__*(t3634 - t3636));
      a3807 = (__I__*(s1374 - s1375));
      s1377 = ((0.70710678118654757 + __I__ * 0.70710678118654757)*(t3635 + a3807));
      s1378 = ((-0.70710678118654757 + __I__ * 0.70710678118654757)*(t3635 - a3807));
      s1379 = *((a3804 + 384));
      s1380 = *((a3804 + 1408));
      t3638 = (s1379 + s1380);
      t3639 = (s1379 - s1380);
      s1381 = *((a3804 + 896));
      s1382 = *((a3804 + 1920));
      t3640 = (s1381 + s1382);
      t3641 = (t3638 + t3640);
      s1383 = ((-0.70710678118654757 + __I__ * 0.70710678118654757)*(t3638 - t3640));
      a3808 = (__I__*(s1381 - s1382));
      s1384 = ((0.38268343236508978 + __I__ * 0.92387953251128674)*(t3639 + a3808));
      s1385 = ((-0.92387953251128674 - __I__ * 0.38268343236508978)*(t3639 - a3808));
      t3642 = (t3626 + t3637);
      t3643 = (t3626 - t3637);
      t3644 = (t3633 + t3641);
      a3809 = (T554 + (16*i1963));
      *(a3809) = (t3642 + t3644);
      *((a3809 + 8)) = (t3642 - t3644);
      a3810 = (__I__*(t3633 - t3641));
      *((a3809 + 4)) = (t3643 + a3810);
      *((a3809 + 12)) = (t3643 - a3810);
      t3645 = (t3628 + s1377);
      t3646 = (t3628 - s1377);
      t3647 = (s1370 + s1384);
      *((a3809 + 1)) = (t3645 + t3647);
      *((a3809 + 9)) = (t3645 - t3647);
      a3811 = (__I__*(s1370 - s1384));
      *((a3809 + 5)) = (t3646 + a3811);
      *((a3809 + 13)) = (t3646 - a3811);
      t3648 = (t3627 + s1376);
      t3649 = (t3627 - s1376);
      t3650 = (s1369 + s1383);
      *((a3809 + 2)) = (t3648 + t3650);
      *((a3809 + 10)) = (t3648 - t3650);
      a3812 = (__I__*(s1369 - s1383));
      *((a3809 + 6)) = (t3649 + a3812);
      *((a3809 + 14)) = (t3649 - a3812);
      t3651 = (t3629 + s1378);
      t3652 = (t3629 - s1378);
      t3653 = (s1371 + s1385);
      *((a3809 + 3)) = (t3651 + t3653);
      *((a3809 + 11)) = (t3651 - t3653);
      a3813 = (__I__*(s1371 - s1385));
      *((a3809 + 7)) = (t3652 + a3813);
      *((a3809 + 15)) = (t3652 - a3813);
    }
    _Complex double a3859, t3672, a3857, a3856, t3671, t3670, a3855, 
      a3854;
    _Complex double  *a3858;
    a3854 = *(T554);
    a3855 = *((T554 + 32));
    t3670 = (a3854 + a3855);
    t3671 = (a3854 - a3855);
    a3856 = *((T554 + 16));
    a3857 = *((T554 + 48));
    t3672 = (a3856 + a3857);
    a3858 = (T553 + (64*i1943));
    *(a3858) = (t3670 + t3672);
    *((a3858 + 32)) = (t3670 - t3672);
    a3859 = (__I__*(a3856 - a3857));
    *((a3858 + 16)) = (t3671 + a3859);
    *((a3858 + 48)) = (t3671 - a3859);
    for(int i1961 = 0; i1961 <= 6; i1961++) {
      _Complex double a3907, t3691, s1405, s1404, t3690, t3689, s1403, 
        s1402;
      _Complex double  *b687, *a3906, *b686;
      b686 = (T554 + i1961);
      a3906 = (D33 + (4*i1961));
      s1402 = (*(a3906)**((b686 + 1)));
      s1403 = (*((a3906 + 1))**((b686 + 33)));
      t3689 = (s1402 + s1403);
      t3690 = (s1402 - s1403);
      s1404 = (*((a3906 + 2))**((b686 + 17)));
      s1405 = (*((a3906 + 3))**((b686 + 49)));
      t3691 = (s1404 + s1405);
      b687 = (T553 + (64*i1943) + i1961);
      *((b687 + 1)) = (t3689 + t3691);
      *((b687 + 33)) = (t3689 - t3691);
      a3907 = (__I__*(s1404 - s1405));
      *((b687 + 17)) = (t3690 + a3907);
      *((b687 + 49)) = (t3690 - a3907);
    }
    _Complex double s1411, s1410, a3956, a3955, t3709, t3708, a3954, 
      a3953;
    _Complex double  *b693;
    a3953 = *((T554 + 8));
    a3954 = (__I__**((T554 + 40)));
    t3708 = (a3953 + a3954);
    t3709 = (a3953 - a3954);
    a3955 = *((T554 + 24));
    a3956 = (__I__**((T554 + 56)));
    s1410 = ((0.70710678118654757 + __I__ * 0.70710678118654757)*(a3955 + a3956));
    s1411 = ((-0.70710678118654757 + __I__ * 0.70710678118654757)*(a3955 - a3956));
    b693 = (T553 + (64*i1943));
    *((b693 + 8)) = (t3708 + s1410);
    *((b693 + 40)) = (t3708 - s1410);
    *((b693 + 24)) = (t3709 + s1411);
    *((b693 + 56)) = (t3709 - s1411);
    for(int i1962 = 0; i1962 <= 6; i1962++) {
      _Complex double a4004, t3728, s1431, s1430, t3727, t3726, s1429, 
        s1428;
      _Complex double  *b713, *a4003, *b712;
      b712 = (T554 + i1962);
      a4003 = (D34 + (4*i1962));
      s1428 = (*(a4003)**((b712 + 9)));
      s1429 = (*((a4003 + 1))**((b712 + 41)));
      t3726 = (s1428 + s1429);
      t3727 = (s1428 - s1429);
      s1430 = (*((a4003 + 2))**((b712 + 25)));
      s1431 = (*((a4003 + 3))**((b712 + 57)));
      t3728 = (s1430 + s1431);
      b713 = (T553 + (64*i1943) + i1962);
      *((b713 + 9)) = (t3726 + t3728);
      *((b713 + 41)) = (t3726 - t3728);
      a4004 = (__I__*(s1430 - s1431));
      *((b713 + 25)) = (t3727 + a4004);
      *((b713 + 57)) = (t3727 - a4004);
    }
  }
  _Complex double a4371, t4131, t4130, t4129, a4370, t4128, t4127, 
    t4126, a4369, t4125, t4124, t4123, a4368, t4122, t4121, 
    t4120, a4367, t4119, t4118, t4117, a4366, t4116, t4115, 
    t4114, a4365, t4113, t4112, t4111, a4364, t4110, t4109, 
    t4108, s1527, s1526, s1525, s1524, s1523, s1522, s1521, 
    t4107, s1520, t4106, s1519, t4105, s1518, t4104, a4363, 
    a4362, s1517, t4103, a4361, a4360, t4102, t4101, a4359, 
    t4100, t4099, t4098, a4358, a4357, t4097, t4096, a4356, 
    a4355, t4095, t4094, t4093, t4092, t4091, t4090, t4089, 
    t4088, s1516, s1515, a4354, s1514, t4087, t4086, a4353, 
    a4352, t4085, t4084, a4351, a4350, s1513, s1512, a4349, 
    s1511, t4083, t4081, t4082, a4348, a4347, t4080, a4346, 
    a4345, s1510, s1509, s1508, s1507, s1506, s1505, s1504, 
    t4079, s1503, t4078, s1502, t4077, s1501, t4076, a4344, 
    a4343, s1500, t4075, a4342, a4341, t4074, t4073, a4340, 
    t4072, t4071, t4070, a4339, a4338, t4069, t4068, a4337, 
    a4336, t4067, t4066, t4065, t4064, t4063, t4062, t4061, 
    t4060, s1499, t4059, s1498, t4058, s1497, t4057, a4335, 
    a4334, s1496, t4056, a4333, a4332, t4055, t4054, a4331, 
    t4053, t4052, t4051, a4330, a4329, t4050, t4049, a4328, 
    a4327;
  a4327 = *(T553);
  a4328 = *((T553 + 1024));
  t4049 = (a4327 + a4328);
  t4050 = (a4327 - a4328);
  a4329 = *((T553 + 512));
  a4330 = *((T553 + 1536));
  t4051 = (a4329 + a4330);
  t4052 = (t4049 + t4051);
  t4053 = (t4049 - t4051);
  a4331 = (__I__*(a4329 - a4330));
  t4054 = (t4050 + a4331);
  t4055 = (t4050 - a4331);
  a4332 = *((T553 + 256));
  a4333 = *((T553 + 1280));
  t4056 = (a4332 + a4333);
  s1496 = ((0.70710678118654757 + __I__ * 0.70710678118654757)*(a4332 - a4333));
  a4334 = *((T553 + 768));
  a4335 = *((T553 + 1792));
  t4057 = (a4334 + a4335);
  s1497 = ((-0.70710678118654757 + __I__ * 0.70710678118654757)*(a4334 - a4335));
  t4058 = (t4056 + t4057);
  s1498 = (__I__*(t4056 - t4057));
  t4059 = (s1496 + s1497);
  s1499 = (__I__*(s1496 - s1497));
  t4060 = (t4052 + t4058);
  t4061 = (t4052 - t4058);
  t4062 = (t4054 + t4059);
  t4063 = (t4054 - t4059);
  t4064 = (t4053 + s1498);
  t4065 = (t4053 - s1498);
  t4066 = (t4055 + s1499);
  t4067 = (t4055 - s1499);
  a4336 = *((T553 + 64));
  a4337 = *((T553 + 1088));
  t4068 = (a4336 + a4337);
  t4069 = (a4336 - a4337);
  a4338 = *((T553 + 576));
  a4339 = *((T553 + 1600));
  t4070 = (a4338 + a4339);
  t4071 = (t4068 + t4070);
  t4072 = (t4068 - t4070);
  a4340 = (__I__*(a4338 - a4339));
  t4073 = (t4069 + a4340);
  t4074 = (t4069 - a4340);
  a4341 = *((T553 + 320));
  a4342 = *((T553 + 1344));
  t4075 = (a4341 + a4342);
  s1500 = ((0.70710678118654757 + __I__ * 0.70710678118654757)*(a4341 - a4342));
  a4343 = *((T553 + 832));
  a4344 = *((T553 + 1856));
  t4076 = (a4343 + a4344);
  s1501 = ((-0.70710678118654757 + __I__ * 0.70710678118654757)*(a4343 - a4344));
  t4077 = (t4075 + t4076);
  s1502 = (__I__*(t4075 - t4076));
  t4078 = (s1500 + s1501);
  s1503 = (__I__*(s1500 - s1501));
  t4079 = (t4071 + t4077);
  s1504 = ((0.70710678118654757 + __I__ * 0.70710678118654757)*(t4071 - t4077));
  s1505 = ((0.98078528040323043 + __I__ * 0.19509032201612825)*(t4073 + t4078));
  s1506 = ((0.55557023301960218 + __I__ * 0.83146961230254524)*(t4073 - t4078));
  s1507 = ((0.92387953251128674 + __I__ * 0.38268343236508978)*(t4072 + s1502));
  s1508 = ((0.38268343236508978 + __I__ * 0.92387953251128674)*(t4072 - s1502));
  s1509 = ((0.83146961230254524 + __I__ * 0.55557023301960218)*(t4074 + s1503));
  s1510 = ((0.19509032201612825 + __I__ * 0.98078528040323043)*(t4074 - s1503));
  a4345 = *((T553 + 128));
  a4346 = *((T553 + 1152));
  t4080 = (a4345 + a4346);
  t4081 = (a4345 - a4346);
  a4347 = *((T553 + 640));
  a4348 = *((T553 + 1664));
  t4082 = (a4347 + a4348);
  t4083 = (t4080 + t4082);
  s1511 = ((0.70710678118654757 + __I__ * 0.70710678118654757)*(t4080 - t4082));
  a4349 = (__I__*(a4347 - a4348));
  s1512 = ((0.92387953251128674 + __I__ * 0.38268343236508978)*(t4081 + a4349));
  s1513 = ((0.38268343236508978 + __I__ * 0.92387953251128674)*(t4081 - a4349));
  a4350 = *((T553 + 384));
  a4351 = *((T553 + 1408));
  t4084 = (a4350 + a4351);
  t4085 = (a4350 - a4351);
  a4352 = *((T553 + 896));
  a4353 = *((T553 + 1920));
  t4086 = (a4352 + a4353);
  t4087 = (t4084 + t4086);
  s1514 = ((-0.70710678118654757 + __I__ * 0.70710678118654757)*(t4084 - t4086));
  a4354 = (__I__*(a4352 - a4353));
  s1515 = ((0.38268343236508978 + __I__ * 0.92387953251128674)*(t4085 + a4354));
  s1516 = ((-0.92387953251128674 - __I__ * 0.38268343236508978)*(t4085 - a4354));
  t4088 = (t4083 + t4087);
  t4089 = ((__I__*t4083) + ((- __I__)*t4087));
  t4090 = (s1512 + s1515);
  t4091 = ((__I__*s1512) + ((- __I__)*s1515));
  t4092 = (s1511 + s1514);
  t4093 = ((__I__*s1511) + ((- __I__)*s1514));
  t4094 = (s1513 + s1516);
  t4095 = ((__I__*s1513) + ((- __I__)*s1516));
  a4355 = *((T553 + 192));
  a4356 = *((T553 + 1216));
  t4096 = (a4355 + a4356);
  t4097 = (a4355 - a4356);
  a4357 = *((T553 + 704));
  a4358 = *((T553 + 1728));
  t4098 = (a4357 + a4358);
  t4099 = (t4096 + t4098);
  t4100 = (t4096 - t4098);
  a4359 = (__I__*(a4357 - a4358));
  t4101 = (t4097 + a4359);
  t4102 = (t4097 - a4359);
  a4360 = *((T553 + 448));
  a4361 = *((T553 + 1472));
  t4103 = (a4360 + a4361);
  s1517 = ((0.70710678118654757 + __I__ * 0.70710678118654757)*(a4360 - a4361));
  a4362 = *((T553 + 960));
  a4363 = *((T553 + 1984));
  t4104 = (a4362 + a4363);
  s1518 = ((-0.70710678118654757 + __I__ * 0.70710678118654757)*(a4362 - a4363));
  t4105 = (t4103 + t4104);
  s1519 = (__I__*(t4103 - t4104));
  t4106 = (s1517 + s1518);
  s1520 = (__I__*(s1517 - s1518));
  t4107 = (t4099 + t4105);
  s1521 = ((-0.70710678118654757 + __I__ * 0.70710678118654757)*(t4099 - t4105));
  s1522 = ((0.83146961230254524 + __I__ * 0.55557023301960218)*(t4101 + t4106));
  s1523 = ((-0.98078528040323043 + __I__ * 0.19509032201612825)*(t4101 - t4106));
  s1524 = ((0.38268343236508978 + __I__ * 0.92387953251128674)*(t4100 + s1519));
  s1525 = ((-0.92387953251128674 - __I__ * 0.38268343236508978)*(t4100 - s1519));
  s1526 = ((-0.19509032201612825 + __I__ * 0.98078528040323043)*(t4102 + s1520));
  s1527 = ((-0.55557023301960218 - __I__ * 0.83146961230254524)*(t4102 - s1520));
  t4108 = (t4060 + t4088);
  t4109 = (t4060 - t4088);
  t4110 = (t4079 + t4107);
  *(Y) = (t4108 + t4110);
  *((Y + 1024)) = (t4108 - t4110);
  a4364 = (__I__*(t4079 - t4107));
  *((Y + 512)) = (t4109 + a4364);
  *((Y + 1536)) = (t4109 - a4364);
  t4111 = (t4062 + t4090);
  t4112 = (t4062 - t4090);
  t4113 = (s1505 + s1522);
  *((Y + 64)) = (t4111 + t4113);
  *((Y + 1088)) = (t4111 - t4113);
  a4365 = (__I__*(s1505 - s1522));
  *((Y + 576)) = (t4112 + a4365);
  *((Y + 1600)) = (t4112 - a4365);
  t4114 = (t4064 + t4092);
  t4115 = (t4064 - t4092);
  t4116 = (s1507 + s1524);
  *((Y + 128)) = (t4114 + t4116);
  *((Y + 1152)) = (t4114 - t4116);
  a4366 = (__I__*(s1507 - s1524));
  *((Y + 640)) = (t4115 + a4366);
  *((Y + 1664)) = (t4115 - a4366);
  t4117 = (t4066 + t4094);
  t4118 = (t4066 - t4094);
  t4119 = (s1509 + s1526);
  *((Y + 192)) = (t4117 + t4119);
  *((Y + 1216)) = (t4117 - t4119);
  a4367 = (__I__*(s1509 - s1526));
  *((Y + 704)) = (t4118 + a4367);
  *((Y + 1728)) = (t4118 - a4367);
  t4120 = (t4061 + t4089);
  t4121 = (t4061 - t4089);
  t4122 = (s1504 + s1521);
  *((Y + 256)) = (t4120 + t4122);
  *((Y + 1280)) = (t4120 - t4122);
  a4368 = (__I__*(s1504 - s1521));
  *((Y + 768)) = (t4121 + a4368);
  *((Y + 1792)) = (t4121 - a4368);
  t4123 = (t4063 + t4091);
  t4124 = (t4063 - t4091);
  t4125 = (s1506 + s1523);
  *((Y + 320)) = (t4123 + t4125);
  *((Y + 1344)) = (t4123 - t4125);
  a4369 = (__I__*(s1506 - s1523));
  *((Y + 832)) = (t4124 + a4369);
  *((Y + 1856)) = (t4124 - a4369);
  t4126 = (t4065 + t4093);
  t4127 = (t4065 - t4093);
  t4128 = (s1508 + s1525);
  *((Y + 384)) = (t4126 + t4128);
  *((Y + 1408)) = (t4126 - t4128);
  a4370 = (__I__*(s1508 - s1525));
  *((Y + 896)) = (t4127 + a4370);
  *((Y + 1920)) = (t4127 - a4370);
  t4129 = (t4067 + t4095);
  t4130 = (t4067 - t4095);
  t4131 = (s1510 + s1527);
  *((Y + 448)) = (t4129 + t4131);
  *((Y + 1472)) = (t4129 - t4131);
  a4371 = (__I__*(s1510 - s1527));
  *((Y + 960)) = (t4130 + a4371);
  *((Y + 1984)) = (t4130 - a4371);
  for(int i1941 = 0; i1941 <= 30; i1941++) {
    _Complex double s1720, s1721, t4452, t4453, s1722, s1723, t4454, 
      t4455, t4456, a4732, t4457, t4458, s1724, s1725, t4459, 
      s1726, s1727, s1728, t4460, s1729, t4461, s1730, t4462, 
      s1731, t4463, t4464, t4465, t4466, t4467, t4468, t4469, 
      t4470, s1732, s1733, t4471, t4472, s1734, s1735, t4473, 
      t4474, t4475, a4735, t4476, t4477, s1736, s1737, t4478, 
      s1738, s1739, s1740, t4479, s1741, t4480, s1742, t4481, 
      s1743, t4482, s1744, s1745, s1746, s1747, s1748, s1749, 
      s1750, s1751, s1752, t4483, t4484, s1753, s1754, t4485, 
      t4486, s1755, a4738, s1756, s1757, s1758, s1759, t4487, 
      t4488, s1760, s1761, t4489, t4490, s1762, a4739, s1763, 
      s1764, t4491, t4492, t4493, t4494, t4495, t4496, t4497, 
      t4498, s1765, s1766, t4499, t4500, s1767, s1768, t4501, 
      t4502, t4503, a4741, t4504, t4505, s1769, s1770, t4506, 
      s1771, s1772, s1773, t4507, s1774, t4508, s1775, t4509, 
      s1776, t4510, s1777, s1778, s1779, s1780, s1781, s1782, 
      s1783, t4511, t4512, t4513, a4743, t4514, t4515, t4516, 
      a4744, t4517, t4518, t4519, a4745, t4520, t4521, t4522, 
      a4746, t4523, t4524, t4525, a4747, t4526, t4527, t4528, 
      a4748, t4529, t4530, t4531, a4749, t4532, t4533, t4534, 
      a4750;
    int a4730;
    _Complex double  *b805, *a4731, *a4733, *a4734, *a4736, *a4737, *a4740, *a4742, *b806;
    b805 = (T553 + i1941);
    a4730 = (4*i1941);
    a4731 = (D19 + a4730);
    s1720 = (*(a4731)**((b805 + 1)));
    s1721 = (*((a4731 + 1))**((b805 + 1025)));
    t4452 = (s1720 + s1721);
    t4453 = (s1720 - s1721);
    s1722 = (*((a4731 + 2))**((b805 + 513)));
    s1723 = (*((a4731 + 3))**((b805 + 1537)));
    t4454 = (s1722 + s1723);
    t4455 = (t4452 + t4454);
    t4456 = (t4452 - t4454);
    a4732 = (__I__*(s1722 - s1723));
    t4457 = (t4453 + a4732);
    t4458 = (t4453 - a4732);
    a4733 = (D20 + a4730);
    s1724 = (*(a4733)**((b805 + 257)));
    s1725 = (*((a4733 + 1))**((b805 + 1281)));
    t4459 = (s1724 + s1725);
    s1726 = ((0.70710678118654757 + __I__ * 0.70710678118654757)*(s1724 - s1725));
    s1727 = (*((a4733 + 2))**((b805 + 769)));
    s1728 = (*((a4733 + 3))**((b805 + 1793)));
    t4460 = (s1727 + s1728);
    s1729 = ((-0.70710678118654757 + __I__ * 0.70710678118654757)*(s1727 - s1728));
    t4461 = (t4459 + t4460);
    s1730 = (__I__*(t4459 - t4460));
    t4462 = (s1726 + s1729);
    s1731 = (__I__*(s1726 - s1729));
    t4463 = (t4455 + t4461);
    t4464 = (t4455 - t4461);
    t4465 = (t4457 + t4462);
    t4466 = (t4457 - t4462);
    t4467 = (t4456 + s1730);
    t4468 = (t4456 - s1730);
    t4469 = (t4458 + s1731);
    t4470 = (t4458 - s1731);
    a4734 = (D21 + a4730);
    s1732 = (*(a4734)**((b805 + 65)));
    s1733 = (*((a4734 + 1))**((b805 + 1089)));
    t4471 = (s1732 + s1733);
    t4472 = (s1732 - s1733);
    s1734 = (*((a4734 + 2))**((b805 + 577)));
    s1735 = (*((a4734 + 3))**((b805 + 1601)));
    t4473 = (s1734 + s1735);
    t4474 = (t4471 + t4473);
    t4475 = (t4471 - t4473);
    a4735 = (__I__*(s1734 - s1735));
    t4476 = (t4472 + a4735);
    t4477 = (t4472 - a4735);
    a4736 = (D22 + a4730);
    s1736 = (*(a4736)**((b805 + 321)));
    s1737 = (*((a4736 + 1))**((b805 + 1345)));
    t4478 = (s1736 + s1737);
    s1738 = ((0.70710678118654757 + __I__ * 0.70710678118654757)*(s1736 - s1737));
    s1739 = (*((a4736 + 2))**((b805 + 833)));
    s1740 = (*((a4736 + 3))**((b805 + 1857)));
    t4479 = (s1739 + s1740);
    s1741 = ((-0.70710678118654757 + __I__ * 0.70710678118654757)*(s1739 - s1740));
    t4480 = (t4478 + t4479);
    s1742 = (__I__*(t4478 - t4479));
    t4481 = (s1738 + s1741);
    s1743 = (__I__*(s1738 - s1741));
    t4482 = (t4474 + t4480);
    s1744 = ((0.70710678118654757 + __I__ * 0.70710678118654757)*(t4474 - t4480));
    s1745 = ((0.98078528040323043 + __I__ * 0.19509032201612825)*(t4476 + t4481));
    s1746 = ((0.55557023301960218 + __I__ * 0.83146961230254524)*(t4476 - t4481));
    s1747 = ((0.92387953251128674 + __I__ * 0.38268343236508978)*(t4475 + s1742));
    s1748 = ((0.38268343236508978 + __I__ * 0.92387953251128674)*(t4475 - s1742));
    s1749 = ((0.83146961230254524 + __I__ * 0.55557023301960218)*(t4477 + s1743));
    s1750 = ((0.19509032201612825 + __I__ * 0.98078528040323043)*(t4477 - s1743));
    a4737 = (D23 + (8*i1941));
    s1751 = (*(a4737)**((b805 + 129)));
    s1752 = (*((a4737 + 1))**((b805 + 1153)));
    t4483 = (s1751 + s1752);
    t4484 = (s1751 - s1752);
    s1753 = (*((a4737 + 2))**((b805 + 641)));
    s1754 = (*((a4737 + 3))**((b805 + 1665)));
    t4485 = (s1753 + s1754);
    t4486 = (t4483 + t4485);
    s1755 = ((0.70710678118654757 + __I__ * 0.70710678118654757)*(t4483 - t4485));
    a4738 = (__I__*(s1753 - s1754));
    s1756 = ((0.92387953251128674 + __I__ * 0.38268343236508978)*(t4484 + a4738));
    s1757 = ((0.38268343236508978 + __I__ * 0.92387953251128674)*(t4484 - a4738));
    s1758 = (*((a4737 + 4))**((b805 + 385)));
    s1759 = (*((a4737 + 5))**((b805 + 1409)));
    t4487 = (s1758 + s1759);
    t4488 = (s1758 - s1759);
    s1760 = (*((a4737 + 6))**((b805 + 897)));
    s1761 = (*((a4737 + 7))**((b805 + 1921)));
    t4489 = (s1760 + s1761);
    t4490 = (t4487 + t4489);
    s1762 = ((-0.70710678118654757 + __I__ * 0.70710678118654757)*(t4487 - t4489));
    a4739 = (__I__*(s1760 - s1761));
    s1763 = ((0.38268343236508978 + __I__ * 0.92387953251128674)*(t4488 + a4739));
    s1764 = ((-0.92387953251128674 - __I__ * 0.38268343236508978)*(t4488 - a4739));
    t4491 = (t4486 + t4490);
    t4492 = ((__I__*t4486) + ((- __I__)*t4490));
    t4493 = (s1756 + s1763);
    t4494 = ((__I__*s1756) + ((- __I__)*s1763));
    t4495 = (s1755 + s1762);
    t4496 = ((__I__*s1755) + ((- __I__)*s1762));
    t4497 = (s1757 + s1764);
    t4498 = ((__I__*s1757) + ((- __I__)*s1764));
    a4740 = (D24 + a4730);
    s1765 = (*(a4740)**((b805 + 193)));
    s1766 = (*((a4740 + 1))**((b805 + 1217)));
    t4499 = (s1765 + s1766);
    t4500 = (s1765 - s1766);
    s1767 = (*((a4740 + 2))**((b805 + 705)));
    s1768 = (*((a4740 + 3))**((b805 + 1729)));
    t4501 = (s1767 + s1768);
    t4502 = (t4499 + t4501);
    t4503 = (t4499 - t4501);
    a4741 = (__I__*(s1767 - s1768));
    t4504 = (t4500 + a4741);
    t4505 = (t4500 - a4741);
    a4742 = (D25 + a4730);
    s1769 = (*(a4742)**((b805 + 449)));
    s1770 = (*((a4742 + 1))**((b805 + 1473)));
    t4506 = (s1769 + s1770);
    s1771 = ((0.70710678118654757 + __I__ * 0.70710678118654757)*(s1769 - s1770));
    s1772 = (*((a4742 + 2))**((b805 + 961)));
    s1773 = (*((a4742 + 3))**((b805 + 1985)));
    t4507 = (s1772 + s1773);
    s1774 = ((-0.70710678118654757 + __I__ * 0.70710678118654757)*(s1772 - s1773));
    t4508 = (t4506 + t4507);
    s1775 = (__I__*(t4506 - t4507));
    t4509 = (s1771 + s1774);
    s1776 = (__I__*(s1771 - s1774));
    t4510 = (t4502 + t4508);
    s1777 = ((-0.70710678118654757 + __I__ * 0.70710678118654757)*(t4502 - t4508));
    s1778 = ((0.83146961230254524 + __I__ * 0.55557023301960218)*(t4504 + t4509));
    s1779 = ((-0.98078528040323043 + __I__ * 0.19509032201612825)*(t4504 - t4509));
    s1780 = ((0.38268343236508978 + __I__ * 0.92387953251128674)*(t4503 + s1775));
    s1781 = ((-0.92387953251128674 - __I__ * 0.38268343236508978)*(t4503 - s1775));
    s1782 = ((-0.19509032201612825 + __I__ * 0.98078528040323043)*(t4505 + s1776));
    s1783 = ((-0.55557023301960218 - __I__ * 0.83146961230254524)*(t4505 - s1776));
    t4511 = (t4463 + t4491);
    t4512 = (t4463 - t4491);
    t4513 = (t4482 + t4510);
    b806 = (Y + i1941);
    *((b806 + 1)) = (t4511 + t4513);
    *((b806 + 1025)) = (t4511 - t4513);
    a4743 = (__I__*(t4482 - t4510));
    *((b806 + 513)) = (t4512 + a4743);
    *((b806 + 1537)) = (t4512 - a4743);
    t4514 = (t4465 + t4493);
    t4515 = (t4465 - t4493);
    t4516 = (s1745 + s1778);
    *((b806 + 65)) = (t4514 + t4516);
    *((b806 + 1089)) = (t4514 - t4516);
    a4744 = (__I__*(s1745 - s1778));
    *((b806 + 577)) = (t4515 + a4744);
    *((b806 + 1601)) = (t4515 - a4744);
    t4517 = (t4467 + t4495);
    t4518 = (t4467 - t4495);
    t4519 = (s1747 + s1780);
    *((b806 + 129)) = (t4517 + t4519);
    *((b806 + 1153)) = (t4517 - t4519);
    a4745 = (__I__*(s1747 - s1780));
    *((b806 + 641)) = (t4518 + a4745);
    *((b806 + 1665)) = (t4518 - a4745);
    t4520 = (t4469 + t4497);
    t4521 = (t4469 - t4497);
    t4522 = (s1749 + s1782);
    *((b806 + 193)) = (t4520 + t4522);
    *((b806 + 1217)) = (t4520 - t4522);
    a4746 = (__I__*(s1749 - s1782));
    *((b806 + 705)) = (t4521 + a4746);
    *((b806 + 1729)) = (t4521 - a4746);
    t4523 = (t4464 + t4492);
    t4524 = (t4464 - t4492);
    t4525 = (s1744 + s1777);
    *((b806 + 257)) = (t4523 + t4525);
    *((b806 + 1281)) = (t4523 - t4525);
    a4747 = (__I__*(s1744 - s1777));
    *((b806 + 769)) = (t4524 + a4747);
    *((b806 + 1793)) = (t4524 - a4747);
    t4526 = (t4466 + t4494);
    t4527 = (t4466 - t4494);
    t4528 = (s1746 + s1779);
    *((b806 + 321)) = (t4526 + t4528);
    *((b806 + 1345)) = (t4526 - t4528);
    a4748 = (__I__*(s1746 - s1779));
    *((b806 + 833)) = (t4527 + a4748);
    *((b806 + 1857)) = (t4527 - a4748);
    t4529 = (t4468 + t4496);
    t4530 = (t4468 - t4496);
    t4531 = (s1748 + s1781);
    *((b806 + 385)) = (t4529 + t4531);
    *((b806 + 1409)) = (t4529 - t4531);
    a4749 = (__I__*(s1748 - s1781));
    *((b806 + 897)) = (t4530 + a4749);
    *((b806 + 1921)) = (t4530 - a4749);
    t4532 = (t4470 + t4498);
    t4533 = (t4470 - t4498);
    t4534 = (s1750 + s1783);
    *((b806 + 449)) = (t4532 + t4534);
    *((b806 + 1473)) = (t4532 - t4534);
    a4750 = (__I__*(s1750 - s1783));
    *((b806 + 961)) = (t4533 + a4750);
    *((b806 + 1985)) = (t4533 - a4750);
  }
  _Complex double a5135, a5136, t4855, t4856, a5137, a5138, s1880, 
    s1881, a5139, a5140, s1882, s1883, a5141, a5142, s1884, 
    s1885, a5143, a5144, s1886, s1887, a5145, a5146, s1888, 
    s1889, a5147, a5148, s1890, s1891, a5149, a5150, s1892, 
    s1893, a5151, a5152, s1894, s1895, a5153, a5154, s1896, 
    s1897, a5155, a5156, s1898, s1899, a5157, a5158, s1900, 
    s1901, a5159, a5160, s1902, s1903, a5161, a5162, s1904, 
    s1905, a5163, a5164, s1906, s1907, a5165, a5166, s1908, 
    s1909, t4857, t4858, t4859, t4860, t4861, a5167, t4862, 
    t4863, t4864, t4865, t4866, t4867, s1910, a5168, s1911, 
    s1912, t4868, t4869, t4870, t4871, s1913, a5169, s1914, 
    s1915, t4872, t4873, t4874, t4875, s1916, a5170, s1917, 
    s1918, t4876, t4877, t4878, a5171, t4879, t4880, t4881, 
    a5172, t4882, t4883, t4884, a5173, t4885, t4886, t4887, 
    a5174, t4888, t4889, t4890, t4891, t4892, a5175, t4893, 
    t4894, t4895, t4896, t4897, t4898, s1919, a5176, s1920, 
    s1921, t4899, t4900, t4901, t4902, s1922, a5177, s1923, 
    s1924, t4903, t4904, t4905, t4906, s1925, a5178, s1926, 
    s1927, t4907, t4908, t4909, a5179, t4910, t4911, t4912, 
    a5180, t4913, t4914, t4915, a5181, t4916, t4917, t4918, 
    a5182;
  a5135 = *((T553 + 32));
  a5136 = (__I__**((T553 + 1056)));
  t4855 = (a5135 + a5136);
  t4856 = (a5135 - a5136);
  a5137 = *((T553 + 96));
  a5138 = (__I__**((T553 + 1120)));
  s1880 = ((0.99518472667219693 + __I__ * 0.098017140329560604)*(a5137 + a5138));
  s1881 = ((0.95694033573220882 + __I__ * 0.29028467725446233)*(a5137 - a5138));
  a5139 = *((T553 + 160));
  a5140 = (__I__**((T553 + 1184)));
  s1882 = ((0.98078528040323043 + __I__ * 0.19509032201612825)*(a5139 + a5140));
  s1883 = ((0.83146961230254524 + __I__ * 0.55557023301960218)*(a5139 - a5140));
  a5141 = *((T553 + 224));
  a5142 = (__I__**((T553 + 1248)));
  s1884 = ((0.95694033573220882 + __I__ * 0.29028467725446233)*(a5141 + a5142));
  s1885 = ((0.63439328416364549 + __I__ * 0.77301045336273699)*(a5141 - a5142));
  a5143 = *((T553 + 288));
  a5144 = (__I__**((T553 + 1312)));
  s1886 = ((0.92387953251128674 + __I__ * 0.38268343236508978)*(a5143 + a5144));
  s1887 = ((0.38268343236508978 + __I__ * 0.92387953251128674)*(a5143 - a5144));
  a5145 = *((T553 + 352));
  a5146 = (__I__**((T553 + 1376)));
  s1888 = ((0.88192126434835505 + __I__ * 0.47139673682599764)*(a5145 + a5146));
  s1889 = ((0.098017140329560604 + __I__ * 0.99518472667219693)*(a5145 - a5146));
  a5147 = *((T553 + 416));
  a5148 = (__I__**((T553 + 1440)));
  s1890 = ((0.83146961230254524 + __I__ * 0.55557023301960218)*(a5147 + a5148));
  s1891 = ((-0.19509032201612825 + __I__ * 0.98078528040323043)*(a5147 - a5148));
  a5149 = *((T553 + 480));
  a5150 = (__I__**((T553 + 1504)));
  s1892 = ((0.77301045336273699 + __I__ * 0.63439328416364549)*(a5149 + a5150));
  s1893 = ((-0.47139673682599764 + __I__ * 0.88192126434835505)*(a5149 - a5150));
  a5151 = *((T553 + 544));
  a5152 = (__I__**((T553 + 1568)));
  s1894 = ((0.70710678118654757 + __I__ * 0.70710678118654757)*(a5151 + a5152));
  s1895 = ((-0.70710678118654757 + __I__ * 0.70710678118654757)*(a5151 - a5152));
  a5153 = *((T553 + 608));
  a5154 = (__I__**((T553 + 1632)));
  s1896 = ((0.63439328416364549 + __I__ * 0.77301045336273699)*(a5153 + a5154));
  s1897 = ((-0.88192126434835505 + __I__ * 0.47139673682599764)*(a5153 - a5154));
  a5155 = *((T553 + 672));
  a5156 = (__I__**((T553 + 1696)));
  s1898 = ((0.55557023301960218 + __I__ * 0.83146961230254524)*(a5155 + a5156));
  s1899 = ((-0.98078528040323043 + __I__ * 0.19509032201612825)*(a5155 - a5156));
  a5157 = *((T553 + 736));
  a5158 = (__I__**((T553 + 1760)));
  s1900 = ((0.47139673682599764 + __I__ * 0.88192126434835505)*(a5157 + a5158));
  s1901 = ((-0.99518472667219693 - __I__ * 0.098017140329560604)*(a5157 - a5158));
  a5159 = *((T553 + 800));
  a5160 = (__I__**((T553 + 1824)));
  s1902 = ((0.38268343236508978 + __I__ * 0.92387953251128674)*(a5159 + a5160));
  s1903 = ((-0.92387953251128674 - __I__ * 0.38268343236508978)*(a5159 - a5160));
  a5161 = *((T553 + 864));
  a5162 = (__I__**((T553 + 1888)));
  s1904 = ((0.29028467725446233 + __I__ * 0.95694033573220882)*(a5161 + a5162));
  s1905 = ((-0.77301045336273699 - __I__ * 0.63439328416364549)*(a5161 - a5162));
  a5163 = *((T553 + 928));
  a5164 = (__I__**((T553 + 1952)));
  s1906 = ((0.19509032201612825 + __I__ * 0.98078528040323043)*(a5163 + a5164));
  s1907 = ((-0.55557023301960218 - __I__ * 0.83146961230254524)*(a5163 - a5164));
  a5165 = *((T553 + 992));
  a5166 = (__I__**((T553 + 2016)));
  s1908 = ((0.098017140329560604 + __I__ * 0.99518472667219693)*(a5165 + a5166));
  s1909 = ((-0.29028467725446233 - __I__ * 0.95694033573220882)*(a5165 - a5166));
  t4857 = (t4855 + s1894);
  t4858 = (t4855 - s1894);
  t4859 = (s1886 + s1902);
  t4860 = (t4857 + t4859);
  t4861 = (t4857 - t4859);
  a5167 = (__I__*(s1886 - s1902));
  t4862 = (t4858 + a5167);
  t4863 = (t4858 - a5167);
  t4864 = (s1880 + s1896);
  t4865 = (s1880 - s1896);
  t4866 = (s1888 + s1904);
  t4867 = (t4864 + t4866);
  s1910 = ((0.70710678118654757 + __I__ * 0.70710678118654757)*(t4864 - t4866));
  a5168 = (__I__*(s1888 - s1904));
  s1911 = ((0.92387953251128674 + __I__ * 0.38268343236508978)*(t4865 + a5168));
  s1912 = ((0.38268343236508978 + __I__ * 0.92387953251128674)*(t4865 - a5168));
  t4868 = (s1882 + s1898);
  t4869 = (s1882 - s1898);
  t4870 = (s1890 + s1906);
  t4871 = (t4868 + t4870);
  s1913 = (__I__*(t4868 - t4870));
  a5169 = (__I__*(s1890 - s1906));
  s1914 = ((0.70710678118654757 + __I__ * 0.70710678118654757)*(t4869 + a5169));
  s1915 = ((-0.70710678118654757 + __I__ * 0.70710678118654757)*(t4869 - a5169));
  t4872 = (s1884 + s1900);
  t4873 = (s1884 - s1900);
  t4874 = (s1892 + s1908);
  t4875 = (t4872 + t4874);
  s1916 = ((-0.70710678118654757 + __I__ * 0.70710678118654757)*(t4872 - t4874));
  a5170 = (__I__*(s1892 - s1908));
  s1917 = ((0.38268343236508978 + __I__ * 0.92387953251128674)*(t4873 + a5170));
  s1918 = ((-0.92387953251128674 - __I__ * 0.38268343236508978)*(t4873 - a5170));
  t4876 = (t4860 + t4871);
  t4877 = (t4860 - t4871);
  t4878 = (t4867 + t4875);
  *((Y + 32)) = (t4876 + t4878);
  *((Y + 1056)) = (t4876 - t4878);
  a5171 = (__I__*(t4867 - t4875));
  *((Y + 544)) = (t4877 + a5171);
  *((Y + 1568)) = (t4877 - a5171);
  t4879 = (t4862 + s1914);
  t4880 = (t4862 - s1914);
  t4881 = (s1911 + s1917);
  *((Y + 160)) = (t4879 + t4881);
  *((Y + 1184)) = (t4879 - t4881);
  a5172 = (__I__*(s1911 - s1917));
  *((Y + 672)) = (t4880 + a5172);
  *((Y + 1696)) = (t4880 - a5172);
  t4882 = (t4861 + s1913);
  t4883 = (t4861 - s1913);
  t4884 = (s1910 + s1916);
  *((Y + 288)) = (t4882 + t4884);
  *((Y + 1312)) = (t4882 - t4884);
  a5173 = (__I__*(s1910 - s1916));
  *((Y + 800)) = (t4883 + a5173);
  *((Y + 1824)) = (t4883 - a5173);
  t4885 = (t4863 + s1915);
  t4886 = (t4863 - s1915);
  t4887 = (s1912 + s1918);
  *((Y + 416)) = (t4885 + t4887);
  *((Y + 1440)) = (t4885 - t4887);
  a5174 = (__I__*(s1912 - s1918));
  *((Y + 928)) = (t4886 + a5174);
  *((Y + 1952)) = (t4886 - a5174);
  t4888 = (t4856 + s1895);
  t4889 = (t4856 - s1895);
  t4890 = (s1887 + s1903);
  t4891 = (t4888 + t4890);
  t4892 = (t4888 - t4890);
  a5175 = (__I__*(s1887 - s1903));
  t4893 = (t4889 + a5175);
  t4894 = (t4889 - a5175);
  t4895 = (s1881 + s1897);
  t4896 = (s1881 - s1897);
  t4897 = (s1889 + s1905);
  t4898 = (t4895 + t4897);
  s1919 = ((0.70710678118654757 + __I__ * 0.70710678118654757)*(t4895 - t4897));
  a5176 = (__I__*(s1889 - s1905));
  s1920 = ((0.92387953251128674 + __I__ * 0.38268343236508978)*(t4896 + a5176));
  s1921 = ((0.38268343236508978 + __I__ * 0.92387953251128674)*(t4896 - a5176));
  t4899 = (s1883 + s1899);
  t4900 = (s1883 - s1899);
  t4901 = (s1891 + s1907);
  t4902 = (t4899 + t4901);
  s1922 = (__I__*(t4899 - t4901));
  a5177 = (__I__*(s1891 - s1907));
  s1923 = ((0.70710678118654757 + __I__ * 0.70710678118654757)*(t4900 + a5177));
  s1924 = ((-0.70710678118654757 + __I__ * 0.70710678118654757)*(t4900 - a5177));
  t4903 = (s1885 + s1901);
  t4904 = (s1885 - s1901);
  t4905 = (s1893 + s1909);
  t4906 = (t4903 + t4905);
  s1925 = ((-0.70710678118654757 + __I__ * 0.70710678118654757)*(t4903 - t4905));
  a5178 = (__I__*(s1893 - s1909));
  s1926 = ((0.38268343236508978 + __I__ * 0.92387953251128674)*(t4904 + a5178));
  s1927 = ((-0.92387953251128674 - __I__ * 0.38268343236508978)*(t4904 - a5178));
  t4907 = (t4891 + t4902);
  t4908 = (t4891 - t4902);
  t4909 = (t4898 + t4906);
  *((Y + 96)) = (t4907 + t4909);
  *((Y + 1120)) = (t4907 - t4909);
  a5179 = (__I__*(t4898 - t4906));
  *((Y + 608)) = (t4908 + a5179);
  *((Y + 1632)) = (t4908 - a5179);
  t4910 = (t4893 + s1923);
  t4911 = (t4893 - s1923);
  t4912 = (s1920 + s1926);
  *((Y + 224)) = (t4910 + t4912);
  *((Y + 1248)) = (t4910 - t4912);
  a5180 = (__I__*(s1920 - s1926));
  *((Y + 736)) = (t4911 + a5180);
  *((Y + 1760)) = (t4911 - a5180);
  t4913 = (t4892 + s1922);
  t4914 = (t4892 - s1922);
  t4915 = (s1919 + s1925);
  *((Y + 352)) = (t4913 + t4915);
  *((Y + 1376)) = (t4913 - t4915);
  a5181 = (__I__*(s1919 - s1925));
  *((Y + 864)) = (t4914 + a5181);
  *((Y + 1888)) = (t4914 - a5181);
  t4916 = (t4894 + s1924);
  t4917 = (t4894 - s1924);
  t4918 = (s1921 + s1927);
  *((Y + 480)) = (t4916 + t4918);
  *((Y + 1504)) = (t4916 - t4918);
  a5182 = (__I__*(s1921 - s1927));
  *((Y + 992)) = (t4917 + a5182);
  *((Y + 2016)) = (t4917 - a5182);
  for(int i1942 = 0; i1942 <= 30; i1942++) {
    _Complex double s2120, s2121, t5239, t5240, s2122, s2123, t5241, 
      t5242, t5243, a5543, t5244, t5245, s2124, s2125, t5246, 
      s2126, s2127, s2128, t5247, s2129, t5248, s2130, t5249, 
      s2131, t5250, t5251, t5252, t5253, t5254, t5255, t5256, 
      t5257, s2132, s2133, t5258, t5259, s2134, s2135, t5260, 
      t5261, t5262, a5546, t5263, t5264, s2136, s2137, t5265, 
      s2138, s2139, s2140, t5266, s2141, t5267, s2142, t5268, 
      s2143, t5269, s2144, s2145, s2146, s2147, s2148, s2149, 
      s2150, s2151, s2152, t5270, t5271, s2153, s2154, t5272, 
      t5273, s2155, a5549, s2156, s2157, s2158, s2159, t5274, 
      t5275, s2160, s2161, t5276, t5277, s2162, a5550, s2163, 
      s2164, t5278, t5279, t5280, t5281, t5282, t5283, t5284, 
      t5285, s2165, s2166, t5286, t5287, s2167, s2168, t5288, 
      t5289, t5290, a5552, t5291, t5292, s2169, s2170, t5293, 
      s2171, s2172, s2173, t5294, s2174, t5295, s2175, t5296, 
      s2176, t5297, s2177, s2178, s2179, s2180, s2181, s2182, 
      s2183, t5298, t5299, t5300, a5554, t5301, t5302, t5303, 
      a5555, t5304, t5305, t5306, a5556, t5307, t5308, t5309, 
      a5557, t5310, t5311, t5312, a5558, t5313, t5314, t5315, 
      a5559, t5316, t5317, t5318, a5560, t5319, t5320, t5321, 
      a5561;
    int a5541;
    _Complex double  *b898, *a5542, *a5544, *a5545, *a5547, *a5548, *a5551, *a5553, *b899;
    b898 = (T553 + i1942);
    a5541 = (4*i1942);
    a5542 = (D26 + a5541);
    s2120 = (*(a5542)**((b898 + 33)));
    s2121 = (*((a5542 + 1))**((b898 + 1057)));
    t5239 = (s2120 + s2121);
    t5240 = (s2120 - s2121);
    s2122 = (*((a5542 + 2))**((b898 + 545)));
    s2123 = (*((a5542 + 3))**((b898 + 1569)));
    t5241 = (s2122 + s2123);
    t5242 = (t5239 + t5241);
    t5243 = (t5239 - t5241);
    a5543 = (__I__*(s2122 - s2123));
    t5244 = (t5240 + a5543);
    t5245 = (t5240 - a5543);
    a5544 = (D27 + a5541);
    s2124 = (*(a5544)**((b898 + 289)));
    s2125 = (*((a5544 + 1))**((b898 + 1313)));
    t5246 = (s2124 + s2125);
    s2126 = ((0.70710678118654757 + __I__ * 0.70710678118654757)*(s2124 - s2125));
    s2127 = (*((a5544 + 2))**((b898 + 801)));
    s2128 = (*((a5544 + 3))**((b898 + 1825)));
    t5247 = (s2127 + s2128);
    s2129 = ((-0.70710678118654757 + __I__ * 0.70710678118654757)*(s2127 - s2128));
    t5248 = (t5246 + t5247);
    s2130 = (__I__*(t5246 - t5247));
    t5249 = (s2126 + s2129);
    s2131 = (__I__*(s2126 - s2129));
    t5250 = (t5242 + t5248);
    t5251 = (t5242 - t5248);
    t5252 = (t5244 + t5249);
    t5253 = (t5244 - t5249);
    t5254 = (t5243 + s2130);
    t5255 = (t5243 - s2130);
    t5256 = (t5245 + s2131);
    t5257 = (t5245 - s2131);
    a5545 = (D28 + a5541);
    s2132 = (*(a5545)**((b898 + 97)));
    s2133 = (*((a5545 + 1))**((b898 + 1121)));
    t5258 = (s2132 + s2133);
    t5259 = (s2132 - s2133);
    s2134 = (*((a5545 + 2))**((b898 + 609)));
    s2135 = (*((a5545 + 3))**((b898 + 1633)));
    t5260 = (s2134 + s2135);
    t5261 = (t5258 + t5260);
    t5262 = (t5258 - t5260);
    a5546 = (__I__*(s2134 - s2135));
    t5263 = (t5259 + a5546);
    t5264 = (t5259 - a5546);
    a5547 = (D29 + a5541);
    s2136 = (*(a5547)**((b898 + 353)));
    s2137 = (*((a5547 + 1))**((b898 + 1377)));
    t5265 = (s2136 + s2137);
    s2138 = ((0.70710678118654757 + __I__ * 0.70710678118654757)*(s2136 - s2137));
    s2139 = (*((a5547 + 2))**((b898 + 865)));
    s2140 = (*((a5547 + 3))**((b898 + 1889)));
    t5266 = (s2139 + s2140);
    s2141 = ((-0.70710678118654757 + __I__ * 0.70710678118654757)*(s2139 - s2140));
    t5267 = (t5265 + t5266);
    s2142 = (__I__*(t5265 - t5266));
    t5268 = (s2138 + s2141);
    s2143 = (__I__*(s2138 - s2141));
    t5269 = (t5261 + t5267);
    s2144 = ((0.70710678118654757 + __I__ * 0.70710678118654757)*(t5261 - t5267));
    s2145 = ((0.98078528040323043 + __I__ * 0.19509032201612825)*(t5263 + t5268));
    s2146 = ((0.55557023301960218 + __I__ * 0.83146961230254524)*(t5263 - t5268));
    s2147 = ((0.92387953251128674 + __I__ * 0.38268343236508978)*(t5262 + s2142));
    s2148 = ((0.38268343236508978 + __I__ * 0.92387953251128674)*(t5262 - s2142));
    s2149 = ((0.83146961230254524 + __I__ * 0.55557023301960218)*(t5264 + s2143));
    s2150 = ((0.19509032201612825 + __I__ * 0.98078528040323043)*(t5264 - s2143));
    a5548 = (D30 + (8*i1942));
    s2151 = (*(a5548)**((b898 + 161)));
    s2152 = (*((a5548 + 1))**((b898 + 1185)));
    t5270 = (s2151 + s2152);
    t5271 = (s2151 - s2152);
    s2153 = (*((a5548 + 2))**((b898 + 673)));
    s2154 = (*((a5548 + 3))**((b898 + 1697)));
    t5272 = (s2153 + s2154);
    t5273 = (t5270 + t5272);
    s2155 = ((0.70710678118654757 + __I__ * 0.70710678118654757)*(t5270 - t5272));
    a5549 = (__I__*(s2153 - s2154));
    s2156 = ((0.92387953251128674 + __I__ * 0.38268343236508978)*(t5271 + a5549));
    s2157 = ((0.38268343236508978 + __I__ * 0.92387953251128674)*(t5271 - a5549));
    s2158 = (*((a5548 + 4))**((b898 + 417)));
    s2159 = (*((a5548 + 5))**((b898 + 1441)));
    t5274 = (s2158 + s2159);
    t5275 = (s2158 - s2159);
    s2160 = (*((a5548 + 6))**((b898 + 929)));
    s2161 = (*((a5548 + 7))**((b898 + 1953)));
    t5276 = (s2160 + s2161);
    t5277 = (t5274 + t5276);
    s2162 = ((-0.70710678118654757 + __I__ * 0.70710678118654757)*(t5274 - t5276));
    a5550 = (__I__*(s2160 - s2161));
    s2163 = ((0.38268343236508978 + __I__ * 0.92387953251128674)*(t5275 + a5550));
    s2164 = ((-0.92387953251128674 - __I__ * 0.38268343236508978)*(t5275 - a5550));
    t5278 = (t5273 + t5277);
    t5279 = ((__I__*t5273) + ((- __I__)*t5277));
    t5280 = (s2156 + s2163);
    t5281 = ((__I__*s2156) + ((- __I__)*s2163));
    t5282 = (s2155 + s2162);
    t5283 = ((__I__*s2155) + ((- __I__)*s2162));
    t5284 = (s2157 + s2164);
    t5285 = ((__I__*s2157) + ((- __I__)*s2164));
    a5551 = (D31 + a5541);
    s2165 = (*(a5551)**((b898 + 225)));
    s2166 = (*((a5551 + 1))**((b898 + 1249)));
    t5286 = (s2165 + s2166);
    t5287 = (s2165 - s2166);
    s2167 = (*((a5551 + 2))**((b898 + 737)));
    s2168 = (*((a5551 + 3))**((b898 + 1761)));
    t5288 = (s2167 + s2168);
    t5289 = (t5286 + t5288);
    t5290 = (t5286 - t5288);
    a5552 = (__I__*(s2167 - s2168));
    t5291 = (t5287 + a5552);
    t5292 = (t5287 - a5552);
    a5553 = (D32 + a5541);
    s2169 = (*(a5553)**((b898 + 481)));
    s2170 = (*((a5553 + 1))**((b898 + 1505)));
    t5293 = (s2169 + s2170);
    s2171 = ((0.70710678118654757 + __I__ * 0.70710678118654757)*(s2169 - s2170));
    s2172 = (*((a5553 + 2))**((b898 + 993)));
    s2173 = (*((a5553 + 3))**((b898 + 2017)));
    t5294 = (s2172 + s2173);
    s2174 = ((-0.70710678118654757 + __I__ * 0.70710678118654757)*(s2172 - s2173));
    t5295 = (t5293 + t5294);
    s2175 = (__I__*(t5293 - t5294));
    t5296 = (s2171 + s2174);
    s2176 = (__I__*(s2171 - s2174));
    t5297 = (t5289 + t5295);
    s2177 = ((-0.70710678118654757 + __I__ * 0.70710678118654757)*(t5289 - t5295));
    s2178 = ((0.83146961230254524 + __I__ * 0.55557023301960218)*(t5291 + t5296));
    s2179 = ((-0.98078528040323043 + __I__ * 0.19509032201612825)*(t5291 - t5296));
    s2180 = ((0.38268343236508978 + __I__ * 0.92387953251128674)*(t5290 + s2175));
    s2181 = ((-0.92387953251128674 - __I__ * 0.38268343236508978)*(t5290 - s2175));
    s2182 = ((-0.19509032201612825 + __I__ * 0.98078528040323043)*(t5292 + s2176));
    s2183 = ((-0.55557023301960218 - __I__ * 0.83146961230254524)*(t5292 - s2176));
    t5298 = (t5250 + t5278);
    t5299 = (t5250 - t5278);
    t5300 = (t5269 + t5297);
    b899 = (Y + i1942);
    *((b899 + 33)) = (t5298 + t5300);
    *((b899 + 1057)) = (t5298 - t5300);
    a5554 = (__I__*(t5269 - t5297));
    *((b899 + 545)) = (t5299 + a5554);
    *((b899 + 1569)) = (t5299 - a5554);
    t5301 = (t5252 + t5280);
    t5302 = (t5252 - t5280);
    t5303 = (s2145 + s2178);
    *((b899 + 97)) = (t5301 + t5303);
    *((b899 + 1121)) = (t5301 - t5303);
    a5555 = (__I__*(s2145 - s2178));
    *((b899 + 609)) = (t5302 + a5555);
    *((b899 + 1633)) = (t5302 - a5555);
    t5304 = (t5254 + t5282);
    t5305 = (t5254 - t5282);
    t5306 = (s2147 + s2180);
    *((b899 + 161)) = (t5304 + t5306);
    *((b899 + 1185)) = (t5304 - t5306);
    a5556 = (__I__*(s2147 - s2180));
    *((b899 + 673)) = (t5305 + a5556);
    *((b899 + 1697)) = (t5305 - a5556);
    t5307 = (t5256 + t5284);
    t5308 = (t5256 - t5284);
    t5309 = (s2149 + s2182);
    *((b899 + 225)) = (t5307 + t5309);
    *((b899 + 1249)) = (t5307 - t5309);
    a5557 = (__I__*(s2149 - s2182));
    *((b899 + 737)) = (t5308 + a5557);
    *((b899 + 1761)) = (t5308 - a5557);
    t5310 = (t5251 + t5279);
    t5311 = (t5251 - t5279);
    t5312 = (s2144 + s2177);
    *((b899 + 289)) = (t5310 + t5312);
    *((b899 + 1313)) = (t5310 - t5312);
    a5558 = (__I__*(s2144 - s2177));
    *((b899 + 801)) = (t5311 + a5558);
    *((b899 + 1825)) = (t5311 - a5558);
    t5313 = (t5253 + t5281);
    t5314 = (t5253 - t5281);
    t5315 = (s2146 + s2179);
    *((b899 + 353)) = (t5313 + t5315);
    *((b899 + 1377)) = (t5313 - t5315);
    a5559 = (__I__*(s2146 - s2179));
    *((b899 + 865)) = (t5314 + a5559);
    *((b899 + 1889)) = (t5314 - a5559);
    t5316 = (t5255 + t5283);
    t5317 = (t5255 - t5283);
    t5318 = (s2148 + s2181);
    *((b899 + 417)) = (t5316 + t5318);
    *((b899 + 1441)) = (t5316 - t5318);
    a5560 = (__I__*(s2148 - s2181));
    *((b899 + 929)) = (t5317 + a5560);
    *((b899 + 1953)) = (t5317 - a5560);
    t5319 = (t5257 + t5285);
    t5320 = (t5257 - t5285);
    t5321 = (s2150 + s2183);
    *((b899 + 481)) = (t5319 + t5321);
    *((b899 + 1505)) = (t5319 - t5321);
    a5561 = (__I__*(s2150 - s2183));
    *((b899 + 993)) = (t5320 + a5561);
    *((b899 + 2017)) = (t5320 - a5561);
  }
}
