/***************************************************************
This code was generated by  Spiral 5.0 beta, www.spiral.net --
Copyright (c) 2005, Carnegie Mellon University
All rights reserved.
The code is distributed under a BSD style license
(see http://www.opensource.org/licenses/bsd-license.php)

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are
met:

* Redistributions of source code must retain the above copyright
  notice, reference to Spiral, this list of conditions and the
  following disclaimer.
  * Redistributions in binary form must reproduce the above
  copyright notice, this list of conditions and the following
  disclaimer in the documentation and/or other materials provided
  with the distribution.
  * Neither the name of Carnegie Mellon University nor the name of its
  contributors may be used to endorse or promote products derived from
  this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
*AS IS* AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
******************************************************************/

use omega;
var  buf10: [0..63] complex;
var  buf9: [0..2047] complex;
var  dat19: [0..123] complex;
var  dat20: [0..123] complex;
var  dat21: [0..123] complex;
var  dat22: [0..123] complex;
var  dat23: [0..247] complex;
var  dat24: [0..123] complex;
var  dat25: [0..123] complex;
var  dat26: [0..123] complex;
var  dat27: [0..123] complex;
var  dat28: [0..123] complex;
var  dat29: [0..123] complex;
var  dat30: [0..247] complex;
var  dat31: [0..123] complex;
var  dat32: [0..123] complex;
var  dat33: [0..27] complex;
var  dat34: [0..27] complex;

proc init_fft2048() {
  for i5369 in 0..30 {
    for i5513 in 0..1 {
      dat19(((i5369*4) + (i5513*2))) = omega(2048, ((i5369 + 1)*(i5513*8)));
      dat19(((i5369*4) + (i5513*2) + 1)) = omega(2048, ((i5369 + 1)*((i5513*8) + 16)));
    }
  }
  for i5369 in 0..30 {
    for i5427 in 0..1 {
      dat20(((i5369*4) + (i5427*2))) = omega(2048, ((i5369 + 1)*(4 + (i5427*8))));
      dat20(((i5369*4) + (i5427*2) + 1)) = omega(2048, ((i5369 + 1)*(20 + (i5427*8))));
    }
  }
  for i5369 in 0..30 {
    for i5517 in 0..1 {
      dat21(((i5369*4) + (i5517*2))) = omega(2048, ((i5369 + 1)*(1 + (i5517*8))));
      dat21(((i5369*4) + (i5517*2) + 1)) = omega(2048, ((i5369 + 1)*(17 + (i5517*8))));
    }
  }
  for i5369 in 0..30 {
    for i5433 in 0..1 {
      dat22(((i5369*4) + (i5433*2))) = omega(2048, ((i5369 + 1)*(5 + (i5433*8))));
      dat22(((i5369*4) + (i5433*2) + 1)) = omega(2048, ((i5369 + 1)*(21 + (i5433*8))));
    }
  }
  for i5369 in 0..30 {
    for i5438 in 0..1 {
      for i5521 in 0..1 {
        dat23(((i5369*8) + (i5438*4) + (i5521*2))) = omega(2048, ((i5369 + 1)*(2 + (i5438*4) + (i5521*8))));
        dat23(((i5369*8) + (i5438*4) + (i5521*2) + 1)) = omega(2048, ((i5369 + 1)*(18 + (i5438*4) + (i5521*8))));
      }
    }
  }
  for i5369 in 0..30 {
    for i5525 in 0..1 {
      dat24(((i5369*4) + (i5525*2))) = omega(2048, ((i5369 + 1)*(3 + (i5525*8))));
      dat24(((i5369*4) + (i5525*2) + 1)) = omega(2048, ((i5369 + 1)*(19 + (i5525*8))));
    }
  }
  for i5369 in 0..30 {
    for i5443 in 0..1 {
      dat25(((i5369*4) + (i5443*2))) = omega(2048, ((i5369 + 1)*(7 + (i5443*8))));
      dat25(((i5369*4) + (i5443*2) + 1)) = omega(2048, ((i5369 + 1)*(23 + (i5443*8))));
    }
  }
  for i5370 in 0..30 {
    for i5537 in 0..1 {
      dat26(((i5370*4) + (i5537*2))) = omega(2048, ((33 + i5370)*(i5537*8)));
      dat26(((i5370*4) + (i5537*2) + 1)) = omega(2048, ((33 + i5370)*((i5537*8) + 16)));
    }
  }
  for i5370 in 0..30 {
    for i5457 in 0..1 {
      dat27(((i5370*4) + (i5457*2))) = omega(2048, ((33 + i5370)*(4 + (i5457*8))));
      dat27(((i5370*4) + (i5457*2) + 1)) = omega(2048, ((33 + i5370)*(20 + (i5457*8))));
    }
  }
  for i5370 in 0..30 {
    for i5541 in 0..1 {
      dat28(((i5370*4) + (i5541*2))) = omega(2048, ((33 + i5370)*(1 + (i5541*8))));
      dat28(((i5370*4) + (i5541*2) + 1)) = omega(2048, ((33 + i5370)*(17 + (i5541*8))));
    }
  }
  for i5370 in 0..30 {
    for i5463 in 0..1 {
      dat29(((i5370*4) + (i5463*2))) = omega(2048, ((33 + i5370)*(5 + (i5463*8))));
      dat29(((i5370*4) + (i5463*2) + 1)) = omega(2048, ((33 + i5370)*(21 + (i5463*8))));
    }
  }
  for i5370 in 0..30 {
    for i5468 in 0..1 {
      for i5545 in 0..1 {
        dat30(((i5370*8) + (i5468*4) + (i5545*2))) = omega(2048, ((33 + i5370)*(2 + (i5468*4) + (i5545*8))));
        dat30(((i5370*8) + (i5468*4) + (i5545*2) + 1)) = omega(2048, ((33 + i5370)*(18 + (i5468*4) + (i5545*8))));
      }
    }
  }
  for i5370 in 0..30 {
    for i5549 in 0..1 {
      dat31(((i5370*4) + (i5549*2))) = omega(2048, ((33 + i5370)*(3 + (i5549*8))));
      dat31(((i5370*4) + (i5549*2) + 1)) = omega(2048, ((33 + i5370)*(19 + (i5549*8))));
    }
  }
  for i5370 in 0..30 {
    for i5473 in 0..1 {
      dat32(((i5370*4) + (i5473*2))) = omega(2048, ((33 + i5370)*(7 + (i5473*8))));
      dat32(((i5370*4) + (i5473*2) + 1)) = omega(2048, ((33 + i5370)*(23 + (i5473*8))));
    }
  }
  for i5389 in 0..6 {
    for i5481 in 0..1 {
      dat33(((i5389*4) + (i5481*2))) = omega(64, ((i5389 + 1)*i5481));
      dat33(((i5389*4) + (i5481*2) + 1)) = omega(64, ((i5389 + 1)*(i5481 + 2)));
    }
  }
  for i5390 in 0..6 {
    for i5489 in 0..1 {
      dat34(((i5390*4) + (i5489*2))) = omega(64, ((9 + i5390)*i5489));
      dat34(((i5390*4) + (i5489*2) + 1)) = omega(64, ((9 + i5390)*(i5489 + 2)));
    }
  }

}

proc fft2048(Y: [] complex, X: [] complex) {
  for i5371 in 0..31 {
    for i5391 in 0..3 {
      var a8225, a8226, a8227, a8228, a8230, a8231, a8232, a8233, s3543, s3544, s3545, s3546, s3547, s3548, s3549, s3550, s3551, s3552, s3553, s3554, s3555, s3556, s3557, s3558, s3559, s3560, s3561, s3562, s3563, s3564, s3565, s3566, s3567, t8968, t8969, t8970, t8971, t8972, t8973, t8974, t8975, t8976, t8977, t8978, t8979, t8980, t8981, t8982, t8983, t8984, t8985, t8986, t8987, t8988, t8989, t8990, t8991, t8992, t8993, t8994, t8995, t8996, t8997, t8998:complex;
      var a8224, a8229:int;
      a8224 = (i5371 + (32*i5391));
      s3543 = X(a8224);
      s3544 = X((a8224 + 1024));
      t8968 = (s3543 + s3544);
      t8969 = (s3543 - s3544);
      s3545 = X((a8224 + 512));
      s3546 = X((a8224 + 1536));
      t8970 = (s3545 + s3546);
      t8971 = (t8968 + t8970);
      t8972 = (t8968 - t8970);
      a8225 = (1.0i*(s3545 - s3546));
      t8973 = (t8969 + a8225);
      t8974 = (t8969 - a8225);
      s3547 = X((a8224 + 128));
      s3548 = X((a8224 + 1152));
      t8975 = (s3547 + s3548);
      t8976 = (s3547 - s3548);
      s3549 = X((a8224 + 640));
      s3550 = X((a8224 + 1664));
      t8977 = (s3549 + s3550);
      t8978 = (t8975 + t8977);
      s3551 = ((0.70710678118654757 + 1.0i * 0.70710678118654757)*(t8975 - t8977));
      a8226 = (1.0i*(s3549 - s3550));
      s3552 = ((0.92387953251128674 + 1.0i * 0.38268343236508978)*(t8976 + a8226));
      s3553 = ((0.38268343236508978 + 1.0i * 0.92387953251128674)*(t8976 - a8226));
      s3554 = X((a8224 + 256));
      s3555 = X((a8224 + 1280));
      t8979 = (s3554 + s3555);
      t8980 = (s3554 - s3555);
      s3556 = X((a8224 + 768));
      s3557 = X((a8224 + 1792));
      t8981 = (s3556 + s3557);
      t8982 = (t8979 + t8981);
      s3558 = (1.0i*(t8979 - t8981));
      a8227 = (1.0i*(s3556 - s3557));
      s3559 = ((0.70710678118654757 + 1.0i * 0.70710678118654757)*(t8980 + a8227));
      s3560 = ((-0.70710678118654757 + 1.0i * 0.70710678118654757)*(t8980 - a8227));
      s3561 = X((a8224 + 384));
      s3562 = X((a8224 + 1408));
      t8983 = (s3561 + s3562);
      t8984 = (s3561 - s3562);
      s3563 = X((a8224 + 896));
      s3564 = X((a8224 + 1920));
      t8985 = (s3563 + s3564);
      t8986 = (t8983 + t8985);
      s3565 = ((-0.70710678118654757 + 1.0i * 0.70710678118654757)*(t8983 - t8985));
      a8228 = (1.0i*(s3563 - s3564));
      s3566 = ((0.38268343236508978 + 1.0i * 0.92387953251128674)*(t8984 + a8228));
      s3567 = ((-0.92387953251128674 - 1.0i * 0.38268343236508978)*(t8984 - a8228));
      t8987 = (t8971 + t8982);
      t8988 = (t8971 - t8982);
      t8989 = (t8978 + t8986);
      a8229 = (16*i5391);
      buf10(a8229) = (t8987 + t8989);
      buf10((8 + a8229)) = (t8987 - t8989);
      a8230 = (1.0i*(t8978 - t8986));
      buf10((4 + a8229)) = (t8988 + a8230);
      buf10((12 + a8229)) = (t8988 - a8230);
      t8990 = (t8973 + s3559);
      t8991 = (t8973 - s3559);
      t8992 = (s3552 + s3566);
      buf10((1 + a8229)) = (t8990 + t8992);
      buf10((9 + a8229)) = (t8990 - t8992);
      a8231 = (1.0i*(s3552 - s3566));
      buf10((5 + a8229)) = (t8991 + a8231);
      buf10((13 + a8229)) = (t8991 - a8231);
      t8993 = (t8972 + s3558);
      t8994 = (t8972 - s3558);
      t8995 = (s3551 + s3565);
      buf10((2 + a8229)) = (t8993 + t8995);
      buf10((10 + a8229)) = (t8993 - t8995);
      a8232 = (1.0i*(s3551 - s3565));
      buf10((6 + a8229)) = (t8994 + a8232);
      buf10((14 + a8229)) = (t8994 - a8232);
      t8996 = (t8974 + s3560);
      t8997 = (t8974 - s3560);
      t8998 = (s3553 + s3567);
      buf10((3 + a8229)) = (t8996 + t8998);
      buf10((11 + a8229)) = (t8996 - t8998);
      a8233 = (1.0i*(s3553 - s3567));
      buf10((7 + a8229)) = (t8997 + a8233);
      buf10((15 + a8229)) = (t8997 - a8233);
    }
    var a8258, t9015, t9016, t9017:complex;
    var a8257:int;
    t9015 = (buf10(0) + buf10(32));
    t9016 = (buf10(0) - buf10(32));
    t9017 = (buf10(16) + buf10(48));
    a8257 = (64*i5371);
    buf9(a8257) = (t9015 + t9017);
    buf9((a8257 + 32)) = (t9015 - t9017);
    a8258 = (1.0i*(buf10(16) - buf10(48)));
    buf9((16 + a8257)) = (t9016 + a8258);
    buf9((48 + a8257)) = (t9016 - a8258);
    for i5389 in 0..6 {
      var a8304, s3584, s3585, s3586, s3587, t9034, t9035, t9036:complex;
      var a8303, b1001:int;
      a8303 = (4*i5389);
      s3584 = (dat33(a8303)*buf10((1 + i5389)));
      s3585 = (dat33((1 + a8303))*buf10((33 + i5389)));
      t9034 = (s3584 + s3585);
      t9035 = (s3584 - s3585);
      s3586 = (dat33((2 + a8303))*buf10((17 + i5389)));
      s3587 = (dat33((3 + a8303))*buf10((49 + i5389)));
      t9036 = (s3586 + s3587);
      b1001 = ((64*i5371) + i5389);
      buf9((b1001 + 1)) = (t9034 + t9036);
      buf9((b1001 + 33)) = (t9034 - t9036);
      a8304 = (1.0i*(s3586 - s3587));
      buf9((b1001 + 17)) = (t9035 + a8304);
      buf9((b1001 + 49)) = (t9035 - a8304);
    }
    var s3592, s3593, t9053, t9054:complex;
    var a8334:int;
    t9053 = (buf10(8) + (1.0i*buf10(40)));
    t9054 = (buf10(8) + ((- 1.0i)*buf10(40)));
    s3592 = ((0.70710678118654757 + 1.0i * 0.70710678118654757)*(buf10(24) + (1.0i*buf10(56))));
    s3593 = ((-0.70710678118654757 + 1.0i * 0.70710678118654757)*(buf10(24) + ((- 1.0i)*buf10(56))));
    a8334 = (64*i5371);
    buf9((8 + a8334)) = (t9053 + s3592);
    buf9((40 + a8334)) = (t9053 - s3592);
    buf9((24 + a8334)) = (t9054 + s3593);
    buf9((56 + a8334)) = (t9054 - s3593);
    for i5390 in 0..6 {
      var a8380, s3610, s3611, s3612, s3613, t9071, t9072, t9073:complex;
      var a8379, b1007:int;
      a8379 = (4*i5390);
      s3610 = (dat34(a8379)*buf10((9 + i5390)));
      s3611 = (dat34((1 + a8379))*buf10((41 + i5390)));
      t9071 = (s3610 + s3611);
      t9072 = (s3610 - s3611);
      s3612 = (dat34((2 + a8379))*buf10((25 + i5390)));
      s3613 = (dat34((3 + a8379))*buf10((57 + i5390)));
      t9073 = (s3612 + s3613);
      b1007 = ((64*i5371) + i5390);
      buf9((b1007 + 9)) = (t9071 + t9073);
      buf9((b1007 + 41)) = (t9071 - t9073);
      a8380 = (1.0i*(s3612 - s3613));
      buf9((b1007 + 25)) = (t9072 + a8380);
      buf9((b1007 + 57)) = (t9072 - a8380);
    }
  }
  var a8513, a8514, a8515, a8516, a8517, a8518, a8519, a8520, a8521, a8522, a8523, a8524, a8525, s3678, s3679, s3680, s3681, s3682, s3683, s3684, s3685, s3686, s3687, s3688, s3689, s3690, s3691, s3692, s3693, s3694, s3695, s3696, s3697, s3698, s3699, s3700, s3701, s3702, s3703, s3704, s3705, s3706, s3707, s3708, s3709, t9394, t9395, t9396, t9397, t9398, t9399, t9400, t9401, t9402, t9403, t9404, t9405, t9406, t9407, t9408, t9409, t9410, t9411, t9412, t9413, t9414, t9415, t9416, t9417, t9418, t9419, t9420, t9421, t9422, t9423, t9424, t9425, t9426, t9427, t9428, t9429, t9430, t9431, t9432, t9433, t9434, t9435, t9436, t9437, t9438, t9439, t9440, t9441, t9442, t9443, t9444, t9445, t9446, t9447, t9448, t9449, t9450, t9451, t9452, t9453, t9454, t9455, t9456, t9457, t9458, t9459, t9460, t9461, t9462, t9463, t9464, t9465, t9466, t9467, t9468, t9469, t9470, t9471, t9472, t9473, t9474, t9475, t9476:complex;
  t9394 = (buf9(0) + buf9(1024));
  t9395 = (buf9(0) - buf9(1024));
  t9396 = (buf9(512) + buf9(1536));
  t9397 = (t9394 + t9396);
  t9398 = (t9394 - t9396);
  a8513 = (1.0i*(buf9(512) - buf9(1536)));
  t9399 = (t9395 + a8513);
  t9400 = (t9395 - a8513);
  t9401 = (buf9(256) + buf9(1280));
  s3678 = ((0.70710678118654757 + 1.0i * 0.70710678118654757)*(buf9(256) - buf9(1280)));
  t9402 = (buf9(768) + buf9(1792));
  s3679 = ((-0.70710678118654757 + 1.0i * 0.70710678118654757)*(buf9(768) - buf9(1792)));
  t9403 = (t9401 + t9402);
  s3680 = (1.0i*(t9401 - t9402));
  t9404 = (s3678 + s3679);
  s3681 = (1.0i*(s3678 - s3679));
  t9405 = (t9397 + t9403);
  t9406 = (t9397 - t9403);
  t9407 = (t9399 + t9404);
  t9408 = (t9399 - t9404);
  t9409 = (t9398 + s3680);
  t9410 = (t9398 - s3680);
  t9411 = (t9400 + s3681);
  t9412 = (t9400 - s3681);
  t9413 = (buf9(64) + buf9(1088));
  t9414 = (buf9(64) - buf9(1088));
  t9415 = (buf9(576) + buf9(1600));
  t9416 = (t9413 + t9415);
  t9417 = (t9413 - t9415);
  a8514 = (1.0i*(buf9(576) - buf9(1600)));
  t9418 = (t9414 + a8514);
  t9419 = (t9414 - a8514);
  t9420 = (buf9(320) + buf9(1344));
  s3682 = ((0.70710678118654757 + 1.0i * 0.70710678118654757)*(buf9(320) - buf9(1344)));
  t9421 = (buf9(832) + buf9(1856));
  s3683 = ((-0.70710678118654757 + 1.0i * 0.70710678118654757)*(buf9(832) - buf9(1856)));
  t9422 = (t9420 + t9421);
  s3684 = (1.0i*(t9420 - t9421));
  t9423 = (s3682 + s3683);
  s3685 = (1.0i*(s3682 - s3683));
  t9424 = (t9416 + t9422);
  s3686 = ((0.70710678118654757 + 1.0i * 0.70710678118654757)*(t9416 - t9422));
  s3687 = ((0.98078528040323043 + 1.0i * 0.19509032201612825)*(t9418 + t9423));
  s3688 = ((0.55557023301960218 + 1.0i * 0.83146961230254524)*(t9418 - t9423));
  s3689 = ((0.92387953251128674 + 1.0i * 0.38268343236508978)*(t9417 + s3684));
  s3690 = ((0.38268343236508978 + 1.0i * 0.92387953251128674)*(t9417 - s3684));
  s3691 = ((0.83146961230254524 + 1.0i * 0.55557023301960218)*(t9419 + s3685));
  s3692 = ((0.19509032201612825 + 1.0i * 0.98078528040323043)*(t9419 - s3685));
  t9425 = (buf9(128) + buf9(1152));
  t9426 = (buf9(128) - buf9(1152));
  t9427 = (buf9(640) + buf9(1664));
  t9428 = (t9425 + t9427);
  s3693 = ((0.70710678118654757 + 1.0i * 0.70710678118654757)*(t9425 - t9427));
  a8515 = (1.0i*(buf9(640) - buf9(1664)));
  s3694 = ((0.92387953251128674 + 1.0i * 0.38268343236508978)*(t9426 + a8515));
  s3695 = ((0.38268343236508978 + 1.0i * 0.92387953251128674)*(t9426 - a8515));
  t9429 = (buf9(384) + buf9(1408));
  t9430 = (buf9(384) - buf9(1408));
  t9431 = (buf9(896) + buf9(1920));
  t9432 = (t9429 + t9431);
  s3696 = ((-0.70710678118654757 + 1.0i * 0.70710678118654757)*(t9429 - t9431));
  a8516 = (1.0i*(buf9(896) - buf9(1920)));
  s3697 = ((0.38268343236508978 + 1.0i * 0.92387953251128674)*(t9430 + a8516));
  s3698 = ((-0.92387953251128674 - 1.0i * 0.38268343236508978)*(t9430 - a8516));
  t9433 = (t9428 + t9432);
  t9434 = ((1.0i*t9428) + ((- 1.0i)*t9432));
  t9435 = (s3694 + s3697);
  t9436 = ((1.0i*s3694) + ((- 1.0i)*s3697));
  t9437 = (s3693 + s3696);
  t9438 = ((1.0i*s3693) + ((- 1.0i)*s3696));
  t9439 = (s3695 + s3698);
  t9440 = ((1.0i*s3695) + ((- 1.0i)*s3698));
  t9441 = (buf9(192) + buf9(1216));
  t9442 = (buf9(192) - buf9(1216));
  t9443 = (buf9(704) + buf9(1728));
  t9444 = (t9441 + t9443);
  t9445 = (t9441 - t9443);
  a8517 = (1.0i*(buf9(704) - buf9(1728)));
  t9446 = (t9442 + a8517);
  t9447 = (t9442 - a8517);
  t9448 = (buf9(448) + buf9(1472));
  s3699 = ((0.70710678118654757 + 1.0i * 0.70710678118654757)*(buf9(448) - buf9(1472)));
  t9449 = (buf9(960) + buf9(1984));
  s3700 = ((-0.70710678118654757 + 1.0i * 0.70710678118654757)*(buf9(960) - buf9(1984)));
  t9450 = (t9448 + t9449);
  s3701 = (1.0i*(t9448 - t9449));
  t9451 = (s3699 + s3700);
  s3702 = (1.0i*(s3699 - s3700));
  t9452 = (t9444 + t9450);
  s3703 = ((-0.70710678118654757 + 1.0i * 0.70710678118654757)*(t9444 - t9450));
  s3704 = ((0.83146961230254524 + 1.0i * 0.55557023301960218)*(t9446 + t9451));
  s3705 = ((-0.98078528040323043 + 1.0i * 0.19509032201612825)*(t9446 - t9451));
  s3706 = ((0.38268343236508978 + 1.0i * 0.92387953251128674)*(t9445 + s3701));
  s3707 = ((-0.92387953251128674 - 1.0i * 0.38268343236508978)*(t9445 - s3701));
  s3708 = ((-0.19509032201612825 + 1.0i * 0.98078528040323043)*(t9447 + s3702));
  s3709 = ((-0.55557023301960218 - 1.0i * 0.83146961230254524)*(t9447 - s3702));
  t9453 = (t9405 + t9433);
  t9454 = (t9405 - t9433);
  t9455 = (t9424 + t9452);
  Y(0) = (t9453 + t9455);
  Y(1024) = (t9453 - t9455);
  a8518 = (1.0i*(t9424 - t9452));
  Y(512) = (t9454 + a8518);
  Y(1536) = (t9454 - a8518);
  t9456 = (t9407 + t9435);
  t9457 = (t9407 - t9435);
  t9458 = (s3687 + s3704);
  Y(64) = (t9456 + t9458);
  Y(1088) = (t9456 - t9458);
  a8519 = (1.0i*(s3687 - s3704));
  Y(576) = (t9457 + a8519);
  Y(1600) = (t9457 - a8519);
  t9459 = (t9409 + t9437);
  t9460 = (t9409 - t9437);
  t9461 = (s3689 + s3706);
  Y(128) = (t9459 + t9461);
  Y(1152) = (t9459 - t9461);
  a8520 = (1.0i*(s3689 - s3706));
  Y(640) = (t9460 + a8520);
  Y(1664) = (t9460 - a8520);
  t9462 = (t9411 + t9439);
  t9463 = (t9411 - t9439);
  t9464 = (s3691 + s3708);
  Y(192) = (t9462 + t9464);
  Y(1216) = (t9462 - t9464);
  a8521 = (1.0i*(s3691 - s3708));
  Y(704) = (t9463 + a8521);
  Y(1728) = (t9463 - a8521);
  t9465 = (t9406 + t9434);
  t9466 = (t9406 - t9434);
  t9467 = (s3686 + s3703);
  Y(256) = (t9465 + t9467);
  Y(1280) = (t9465 - t9467);
  a8522 = (1.0i*(s3686 - s3703));
  Y(768) = (t9466 + a8522);
  Y(1792) = (t9466 - a8522);
  t9468 = (t9408 + t9436);
  t9469 = (t9408 - t9436);
  t9470 = (s3688 + s3705);
  Y(320) = (t9468 + t9470);
  Y(1344) = (t9468 - t9470);
  a8523 = (1.0i*(s3688 - s3705));
  Y(832) = (t9469 + a8523);
  Y(1856) = (t9469 - a8523);
  t9471 = (t9410 + t9438);
  t9472 = (t9410 - t9438);
  t9473 = (s3690 + s3707);
  Y(384) = (t9471 + t9473);
  Y(1408) = (t9471 - t9473);
  a8524 = (1.0i*(s3690 - s3707));
  Y(896) = (t9472 + a8524);
  Y(1920) = (t9472 - a8524);
  t9474 = (t9412 + t9440);
  t9475 = (t9412 - t9440);
  t9476 = (s3692 + s3709);
  Y(448) = (t9474 + t9476);
  Y(1472) = (t9474 - t9476);
  a8525 = (1.0i*(s3692 - s3709));
  Y(960) = (t9475 + a8525);
  Y(1984) = (t9475 - a8525);
  for i5369 in 0..30 {
    var a8831, a8840, a8850, a8855, a8860, a8865, a8866, a8867, a8868, a8869, a8870, a8871, a8872, s3902, s3903, s3904, s3905, s3906, s3907, s3908, s3909, s3910, s3911, s3912, s3913, s3914, s3915, s3916, s3917, s3918, s3919, s3920, s3921, s3922, s3923, s3924, s3925, s3926, s3927, s3928, s3929, s3930, s3931, s3932, s3933, s3934, s3935, s3936, s3937, s3938, s3939, s3940, s3941, s3942, s3943, s3944, s3945, s3946, s3947, s3948, s3949, s3950, s3951, s3952, s3953, s3954, s3955, s3956, s3957, s3958, s3959, s3960, s3961, s3962, s3963, s3964, s3965, t9797, t9798, t9799, t9800, t9801, t9802, t9803, t9804, t9805, t9806, t9807, t9808, t9809, t9810, t9811, t9812, t9813, t9814, t9815, t9816, t9817, t9818, t9819, t9820, t9821, t9822, t9823, t9824, t9825, t9826, t9827, t9828, t9829, t9830, t9831, t9832, t9833, t9834, t9835, t9836, t9837, t9838, t9839, t9840, t9841, t9842, t9843, t9844, t9845, t9846, t9847, t9848, t9849, t9850, t9851, t9852, t9853, t9854, t9855, t9856, t9857, t9858, t9859, t9860, t9861, t9862, t9863, t9864, t9865, t9866, t9867, t9868, t9869, t9870, t9871, t9872, t9873, t9874, t9875, t9876, t9877, t9878, t9879:complex;
    var a8823, a8824, a8825, a8826, a8827, a8828, a8829, a8830, a8832, a8833, a8834, a8835, a8836, a8837, a8838, a8839, a8841, a8842, a8843, a8844, a8845, a8846, a8847, a8848, a8849, a8851, a8852, a8853, a8854, a8856, a8857, a8858, a8859, a8861, a8862, a8863, a8864:int;
    a8823 = (1 + i5369);
    a8824 = (1025 + i5369);
    a8825 = (4*i5369);
    s3902 = (dat19(a8825)*buf9(a8823));
    a8826 = (1 + a8825);
    s3903 = (dat19(a8826)*buf9(a8824));
    t9797 = (s3902 + s3903);
    t9798 = (s3902 - s3903);
    a8827 = (513 + i5369);
    a8828 = (1537 + i5369);
    a8829 = (2 + a8825);
    s3904 = (dat19(a8829)*buf9(a8827));
    a8830 = (3 + a8825);
    s3905 = (dat19(a8830)*buf9(a8828));
    t9799 = (s3904 + s3905);
    t9800 = (t9797 + t9799);
    t9801 = (t9797 - t9799);
    a8831 = (1.0i*(s3904 - s3905));
    t9802 = (t9798 + a8831);
    t9803 = (t9798 - a8831);
    a8832 = (257 + i5369);
    a8833 = (1281 + i5369);
    s3906 = (dat20(a8825)*buf9(a8832));
    s3907 = (dat20(a8826)*buf9(a8833));
    t9804 = (s3906 + s3907);
    s3908 = ((0.70710678118654757 + 1.0i * 0.70710678118654757)*(s3906 - s3907));
    a8834 = (769 + i5369);
    a8835 = (1793 + i5369);
    s3909 = (dat20(a8829)*buf9(a8834));
    s3910 = (dat20(a8830)*buf9(a8835));
    t9805 = (s3909 + s3910);
    s3911 = ((-0.70710678118654757 + 1.0i * 0.70710678118654757)*(s3909 - s3910));
    t9806 = (t9804 + t9805);
    s3912 = (1.0i*(t9804 - t9805));
    t9807 = (s3908 + s3911);
    s3913 = (1.0i*(s3908 - s3911));
    t9808 = (t9800 + t9806);
    t9809 = (t9800 - t9806);
    t9810 = (t9802 + t9807);
    t9811 = (t9802 - t9807);
    t9812 = (t9801 + s3912);
    t9813 = (t9801 - s3912);
    t9814 = (t9803 + s3913);
    t9815 = (t9803 - s3913);
    a8836 = (65 + i5369);
    a8837 = (1089 + i5369);
    s3914 = (dat21(a8825)*buf9(a8836));
    s3915 = (dat21(a8826)*buf9(a8837));
    t9816 = (s3914 + s3915);
    t9817 = (s3914 - s3915);
    a8838 = (577 + i5369);
    a8839 = (1601 + i5369);
    s3916 = (dat21(a8829)*buf9(a8838));
    s3917 = (dat21(a8830)*buf9(a8839));
    t9818 = (s3916 + s3917);
    t9819 = (t9816 + t9818);
    t9820 = (t9816 - t9818);
    a8840 = (1.0i*(s3916 - s3917));
    t9821 = (t9817 + a8840);
    t9822 = (t9817 - a8840);
    a8841 = (321 + i5369);
    a8842 = (1345 + i5369);
    s3918 = (dat22(a8825)*buf9(a8841));
    s3919 = (dat22(a8826)*buf9(a8842));
    t9823 = (s3918 + s3919);
    s3920 = ((0.70710678118654757 + 1.0i * 0.70710678118654757)*(s3918 - s3919));
    a8843 = (833 + i5369);
    a8844 = (1857 + i5369);
    s3921 = (dat22(a8829)*buf9(a8843));
    s3922 = (dat22(a8830)*buf9(a8844));
    t9824 = (s3921 + s3922);
    s3923 = ((-0.70710678118654757 + 1.0i * 0.70710678118654757)*(s3921 - s3922));
    t9825 = (t9823 + t9824);
    s3924 = (1.0i*(t9823 - t9824));
    t9826 = (s3920 + s3923);
    s3925 = (1.0i*(s3920 - s3923));
    t9827 = (t9819 + t9825);
    s3926 = ((0.70710678118654757 + 1.0i * 0.70710678118654757)*(t9819 - t9825));
    s3927 = ((0.98078528040323043 + 1.0i * 0.19509032201612825)*(t9821 + t9826));
    s3928 = ((0.55557023301960218 + 1.0i * 0.83146961230254524)*(t9821 - t9826));
    s3929 = ((0.92387953251128674 + 1.0i * 0.38268343236508978)*(t9820 + s3924));
    s3930 = ((0.38268343236508978 + 1.0i * 0.92387953251128674)*(t9820 - s3924));
    s3931 = ((0.83146961230254524 + 1.0i * 0.55557023301960218)*(t9822 + s3925));
    s3932 = ((0.19509032201612825 + 1.0i * 0.98078528040323043)*(t9822 - s3925));
    a8845 = (129 + i5369);
    a8846 = (1153 + i5369);
    a8847 = (8*i5369);
    s3933 = (dat23(a8847)*buf9(a8845));
    s3934 = (dat23((1 + a8847))*buf9(a8846));
    t9828 = (s3933 + s3934);
    t9829 = (s3933 - s3934);
    a8848 = (641 + i5369);
    a8849 = (1665 + i5369);
    s3935 = (dat23((2 + a8847))*buf9(a8848));
    s3936 = (dat23((3 + a8847))*buf9(a8849));
    t9830 = (s3935 + s3936);
    t9831 = (t9828 + t9830);
    s3937 = ((0.70710678118654757 + 1.0i * 0.70710678118654757)*(t9828 - t9830));
    a8850 = (1.0i*(s3935 - s3936));
    s3938 = ((0.92387953251128674 + 1.0i * 0.38268343236508978)*(t9829 + a8850));
    s3939 = ((0.38268343236508978 + 1.0i * 0.92387953251128674)*(t9829 - a8850));
    a8851 = (385 + i5369);
    a8852 = (1409 + i5369);
    s3940 = (dat23((4 + a8847))*buf9(a8851));
    s3941 = (dat23((5 + a8847))*buf9(a8852));
    t9832 = (s3940 + s3941);
    t9833 = (s3940 - s3941);
    a8853 = (897 + i5369);
    a8854 = (1921 + i5369);
    s3942 = (dat23((6 + a8847))*buf9(a8853));
    s3943 = (dat23((7 + a8847))*buf9(a8854));
    t9834 = (s3942 + s3943);
    t9835 = (t9832 + t9834);
    s3944 = ((-0.70710678118654757 + 1.0i * 0.70710678118654757)*(t9832 - t9834));
    a8855 = (1.0i*(s3942 - s3943));
    s3945 = ((0.38268343236508978 + 1.0i * 0.92387953251128674)*(t9833 + a8855));
    s3946 = ((-0.92387953251128674 - 1.0i * 0.38268343236508978)*(t9833 - a8855));
    t9836 = (t9831 + t9835);
    t9837 = ((1.0i*t9831) + ((- 1.0i)*t9835));
    t9838 = (s3938 + s3945);
    t9839 = ((1.0i*s3938) + ((- 1.0i)*s3945));
    t9840 = (s3937 + s3944);
    t9841 = ((1.0i*s3937) + ((- 1.0i)*s3944));
    t9842 = (s3939 + s3946);
    t9843 = ((1.0i*s3939) + ((- 1.0i)*s3946));
    a8856 = (193 + i5369);
    a8857 = (1217 + i5369);
    s3947 = (dat24(a8825)*buf9(a8856));
    s3948 = (dat24(a8826)*buf9(a8857));
    t9844 = (s3947 + s3948);
    t9845 = (s3947 - s3948);
    a8858 = (705 + i5369);
    a8859 = (1729 + i5369);
    s3949 = (dat24(a8829)*buf9(a8858));
    s3950 = (dat24(a8830)*buf9(a8859));
    t9846 = (s3949 + s3950);
    t9847 = (t9844 + t9846);
    t9848 = (t9844 - t9846);
    a8860 = (1.0i*(s3949 - s3950));
    t9849 = (t9845 + a8860);
    t9850 = (t9845 - a8860);
    a8861 = (449 + i5369);
    a8862 = (1473 + i5369);
    s3951 = (dat25(a8825)*buf9(a8861));
    s3952 = (dat25(a8826)*buf9(a8862));
    t9851 = (s3951 + s3952);
    s3953 = ((0.70710678118654757 + 1.0i * 0.70710678118654757)*(s3951 - s3952));
    a8863 = (961 + i5369);
    a8864 = (1985 + i5369);
    s3954 = (dat25(a8829)*buf9(a8863));
    s3955 = (dat25(a8830)*buf9(a8864));
    t9852 = (s3954 + s3955);
    s3956 = ((-0.70710678118654757 + 1.0i * 0.70710678118654757)*(s3954 - s3955));
    t9853 = (t9851 + t9852);
    s3957 = (1.0i*(t9851 - t9852));
    t9854 = (s3953 + s3956);
    s3958 = (1.0i*(s3953 - s3956));
    t9855 = (t9847 + t9853);
    s3959 = ((-0.70710678118654757 + 1.0i * 0.70710678118654757)*(t9847 - t9853));
    s3960 = ((0.83146961230254524 + 1.0i * 0.55557023301960218)*(t9849 + t9854));
    s3961 = ((-0.98078528040323043 + 1.0i * 0.19509032201612825)*(t9849 - t9854));
    s3962 = ((0.38268343236508978 + 1.0i * 0.92387953251128674)*(t9848 + s3957));
    s3963 = ((-0.92387953251128674 - 1.0i * 0.38268343236508978)*(t9848 - s3957));
    s3964 = ((-0.19509032201612825 + 1.0i * 0.98078528040323043)*(t9850 + s3958));
    s3965 = ((-0.55557023301960218 - 1.0i * 0.83146961230254524)*(t9850 - s3958));
    t9856 = (t9808 + t9836);
    t9857 = (t9808 - t9836);
    t9858 = (t9827 + t9855);
    Y(a8823) = (t9856 + t9858);
    Y(a8824) = (t9856 - t9858);
    a8865 = (1.0i*(t9827 - t9855));
    Y(a8827) = (t9857 + a8865);
    Y(a8828) = (t9857 - a8865);
    t9859 = (t9810 + t9838);
    t9860 = (t9810 - t9838);
    t9861 = (s3927 + s3960);
    Y(a8836) = (t9859 + t9861);
    Y(a8837) = (t9859 - t9861);
    a8866 = (1.0i*(s3927 - s3960));
    Y(a8838) = (t9860 + a8866);
    Y(a8839) = (t9860 - a8866);
    t9862 = (t9812 + t9840);
    t9863 = (t9812 - t9840);
    t9864 = (s3929 + s3962);
    Y(a8845) = (t9862 + t9864);
    Y(a8846) = (t9862 - t9864);
    a8867 = (1.0i*(s3929 - s3962));
    Y(a8848) = (t9863 + a8867);
    Y(a8849) = (t9863 - a8867);
    t9865 = (t9814 + t9842);
    t9866 = (t9814 - t9842);
    t9867 = (s3931 + s3964);
    Y(a8856) = (t9865 + t9867);
    Y(a8857) = (t9865 - t9867);
    a8868 = (1.0i*(s3931 - s3964));
    Y(a8858) = (t9866 + a8868);
    Y(a8859) = (t9866 - a8868);
    t9868 = (t9809 + t9837);
    t9869 = (t9809 - t9837);
    t9870 = (s3926 + s3959);
    Y(a8832) = (t9868 + t9870);
    Y(a8833) = (t9868 - t9870);
    a8869 = (1.0i*(s3926 - s3959));
    Y(a8834) = (t9869 + a8869);
    Y(a8835) = (t9869 - a8869);
    t9871 = (t9811 + t9839);
    t9872 = (t9811 - t9839);
    t9873 = (s3928 + s3961);
    Y(a8841) = (t9871 + t9873);
    Y(a8842) = (t9871 - t9873);
    a8870 = (1.0i*(s3928 - s3961));
    Y(a8843) = (t9872 + a8870);
    Y(a8844) = (t9872 - a8870);
    t9874 = (t9813 + t9841);
    t9875 = (t9813 - t9841);
    t9876 = (s3930 + s3963);
    Y(a8851) = (t9874 + t9876);
    Y(a8852) = (t9874 - t9876);
    a8871 = (1.0i*(s3930 - s3963));
    Y(a8853) = (t9875 + a8871);
    Y(a8854) = (t9875 - a8871);
    t9877 = (t9815 + t9843);
    t9878 = (t9815 - t9843);
    t9879 = (s3932 + s3965);
    Y(a8861) = (t9877 + t9879);
    Y(a8862) = (t9877 - t9879);
    a8872 = (1.0i*(s3932 - s3965));
    Y(a8863) = (t9878 + a8872);
    Y(a8864) = (t9878 - a8872);
  }
  var a9065, a9066, a9067, a9068, a9069, a9070, a9071, a9072, a9073, a9074, a9075, a9076, a9077, a9078, a9079, a9080, s4062, s4063, s4064, s4065, s4066, s4067, s4068, s4069, s4070, s4071, s4072, s4073, s4074, s4075, s4076, s4077, s4078, s4079, s4080, s4081, s4082, s4083, s4084, s4085, s4086, s4087, s4088, s4089, s4090, s4091, s4092, s4093, s4094, s4095, s4096, s4097, s4098, s4099, s4100, s4101, s4102, s4103, s4104, s4105, s4106, s4107, s4108, s4109, t10200, t10201, t10202, t10203, t10204, t10205, t10206, t10207, t10208, t10209, t10210, t10211, t10212, t10213, t10214, t10215, t10216, t10217, t10218, t10219, t10220, t10221, t10222, t10223, t10224, t10225, t10226, t10227, t10228, t10229, t10230, t10231, t10232, t10233, t10234, t10235, t10236, t10237, t10238, t10239, t10240, t10241, t10242, t10243, t10244, t10245, t10246, t10247, t10248, t10249, t10250, t10251, t10252, t10253, t10254, t10255, t10256, t10257, t10258, t10259, t10260, t10261, t10262, t10263:complex;
  t10200 = (buf9(32) + (1.0i*buf9(1056)));
  t10201 = (buf9(32) + ((- 1.0i)*buf9(1056)));
  s4062 = ((0.99518472667219693 + 1.0i * 0.098017140329560604)*(buf9(96) + (1.0i*buf9(1120))));
  s4063 = ((0.95694033573220882 + 1.0i * 0.29028467725446233)*(buf9(96) + ((- 1.0i)*buf9(1120))));
  s4064 = ((0.98078528040323043 + 1.0i * 0.19509032201612825)*(buf9(160) + (1.0i*buf9(1184))));
  s4065 = ((0.83146961230254524 + 1.0i * 0.55557023301960218)*(buf9(160) + ((- 1.0i)*buf9(1184))));
  s4066 = ((0.95694033573220882 + 1.0i * 0.29028467725446233)*(buf9(224) + (1.0i*buf9(1248))));
  s4067 = ((0.63439328416364549 + 1.0i * 0.77301045336273699)*(buf9(224) + ((- 1.0i)*buf9(1248))));
  s4068 = ((0.92387953251128674 + 1.0i * 0.38268343236508978)*(buf9(288) + (1.0i*buf9(1312))));
  s4069 = ((0.38268343236508978 + 1.0i * 0.92387953251128674)*(buf9(288) + ((- 1.0i)*buf9(1312))));
  s4070 = ((0.88192126434835505 + 1.0i * 0.47139673682599764)*(buf9(352) + (1.0i*buf9(1376))));
  s4071 = ((0.098017140329560604 + 1.0i * 0.99518472667219693)*(buf9(352) + ((- 1.0i)*buf9(1376))));
  s4072 = ((0.83146961230254524 + 1.0i * 0.55557023301960218)*(buf9(416) + (1.0i*buf9(1440))));
  s4073 = ((-0.19509032201612825 + 1.0i * 0.98078528040323043)*(buf9(416) + ((- 1.0i)*buf9(1440))));
  s4074 = ((0.77301045336273699 + 1.0i * 0.63439328416364549)*(buf9(480) + (1.0i*buf9(1504))));
  s4075 = ((-0.47139673682599764 + 1.0i * 0.88192126434835505)*(buf9(480) + ((- 1.0i)*buf9(1504))));
  s4076 = ((0.70710678118654757 + 1.0i * 0.70710678118654757)*(buf9(544) + (1.0i*buf9(1568))));
  s4077 = ((-0.70710678118654757 + 1.0i * 0.70710678118654757)*(buf9(544) + ((- 1.0i)*buf9(1568))));
  s4078 = ((0.63439328416364549 + 1.0i * 0.77301045336273699)*(buf9(608) + (1.0i*buf9(1632))));
  s4079 = ((-0.88192126434835505 + 1.0i * 0.47139673682599764)*(buf9(608) + ((- 1.0i)*buf9(1632))));
  s4080 = ((0.55557023301960218 + 1.0i * 0.83146961230254524)*(buf9(672) + (1.0i*buf9(1696))));
  s4081 = ((-0.98078528040323043 + 1.0i * 0.19509032201612825)*(buf9(672) + ((- 1.0i)*buf9(1696))));
  s4082 = ((0.47139673682599764 + 1.0i * 0.88192126434835505)*(buf9(736) + (1.0i*buf9(1760))));
  s4083 = ((-0.99518472667219693 - 1.0i * 0.098017140329560604)*(buf9(736) + ((- 1.0i)*buf9(1760))));
  s4084 = ((0.38268343236508978 + 1.0i * 0.92387953251128674)*(buf9(800) + (1.0i*buf9(1824))));
  s4085 = ((-0.92387953251128674 - 1.0i * 0.38268343236508978)*(buf9(800) + ((- 1.0i)*buf9(1824))));
  s4086 = ((0.29028467725446233 + 1.0i * 0.95694033573220882)*(buf9(864) + (1.0i*buf9(1888))));
  s4087 = ((-0.77301045336273699 - 1.0i * 0.63439328416364549)*(buf9(864) + ((- 1.0i)*buf9(1888))));
  s4088 = ((0.19509032201612825 + 1.0i * 0.98078528040323043)*(buf9(928) + (1.0i*buf9(1952))));
  s4089 = ((-0.55557023301960218 - 1.0i * 0.83146961230254524)*(buf9(928) + ((- 1.0i)*buf9(1952))));
  s4090 = ((0.098017140329560604 + 1.0i * 0.99518472667219693)*(buf9(992) + (1.0i*buf9(2016))));
  s4091 = ((-0.29028467725446233 - 1.0i * 0.95694033573220882)*(buf9(992) + ((- 1.0i)*buf9(2016))));
  t10202 = (t10200 + s4076);
  t10203 = (t10200 - s4076);
  t10204 = (s4068 + s4084);
  t10205 = (t10202 + t10204);
  t10206 = (t10202 - t10204);
  a9065 = (1.0i*(s4068 - s4084));
  t10207 = (t10203 + a9065);
  t10208 = (t10203 - a9065);
  t10209 = (s4062 + s4078);
  t10210 = (s4062 - s4078);
  t10211 = (s4070 + s4086);
  t10212 = (t10209 + t10211);
  s4092 = ((0.70710678118654757 + 1.0i * 0.70710678118654757)*(t10209 - t10211));
  a9066 = (1.0i*(s4070 - s4086));
  s4093 = ((0.92387953251128674 + 1.0i * 0.38268343236508978)*(t10210 + a9066));
  s4094 = ((0.38268343236508978 + 1.0i * 0.92387953251128674)*(t10210 - a9066));
  t10213 = (s4064 + s4080);
  t10214 = (s4064 - s4080);
  t10215 = (s4072 + s4088);
  t10216 = (t10213 + t10215);
  s4095 = (1.0i*(t10213 - t10215));
  a9067 = (1.0i*(s4072 - s4088));
  s4096 = ((0.70710678118654757 + 1.0i * 0.70710678118654757)*(t10214 + a9067));
  s4097 = ((-0.70710678118654757 + 1.0i * 0.70710678118654757)*(t10214 - a9067));
  t10217 = (s4066 + s4082);
  t10218 = (s4066 - s4082);
  t10219 = (s4074 + s4090);
  t10220 = (t10217 + t10219);
  s4098 = ((-0.70710678118654757 + 1.0i * 0.70710678118654757)*(t10217 - t10219));
  a9068 = (1.0i*(s4074 - s4090));
  s4099 = ((0.38268343236508978 + 1.0i * 0.92387953251128674)*(t10218 + a9068));
  s4100 = ((-0.92387953251128674 - 1.0i * 0.38268343236508978)*(t10218 - a9068));
  t10221 = (t10205 + t10216);
  t10222 = (t10205 - t10216);
  t10223 = (t10212 + t10220);
  Y(32) = (t10221 + t10223);
  Y(1056) = (t10221 - t10223);
  a9069 = (1.0i*(t10212 - t10220));
  Y(544) = (t10222 + a9069);
  Y(1568) = (t10222 - a9069);
  t10224 = (t10207 + s4096);
  t10225 = (t10207 - s4096);
  t10226 = (s4093 + s4099);
  Y(160) = (t10224 + t10226);
  Y(1184) = (t10224 - t10226);
  a9070 = (1.0i*(s4093 - s4099));
  Y(672) = (t10225 + a9070);
  Y(1696) = (t10225 - a9070);
  t10227 = (t10206 + s4095);
  t10228 = (t10206 - s4095);
  t10229 = (s4092 + s4098);
  Y(288) = (t10227 + t10229);
  Y(1312) = (t10227 - t10229);
  a9071 = (1.0i*(s4092 - s4098));
  Y(800) = (t10228 + a9071);
  Y(1824) = (t10228 - a9071);
  t10230 = (t10208 + s4097);
  t10231 = (t10208 - s4097);
  t10232 = (s4094 + s4100);
  Y(416) = (t10230 + t10232);
  Y(1440) = (t10230 - t10232);
  a9072 = (1.0i*(s4094 - s4100));
  Y(928) = (t10231 + a9072);
  Y(1952) = (t10231 - a9072);
  t10233 = (t10201 + s4077);
  t10234 = (t10201 - s4077);
  t10235 = (s4069 + s4085);
  t10236 = (t10233 + t10235);
  t10237 = (t10233 - t10235);
  a9073 = (1.0i*(s4069 - s4085));
  t10238 = (t10234 + a9073);
  t10239 = (t10234 - a9073);
  t10240 = (s4063 + s4079);
  t10241 = (s4063 - s4079);
  t10242 = (s4071 + s4087);
  t10243 = (t10240 + t10242);
  s4101 = ((0.70710678118654757 + 1.0i * 0.70710678118654757)*(t10240 - t10242));
  a9074 = (1.0i*(s4071 - s4087));
  s4102 = ((0.92387953251128674 + 1.0i * 0.38268343236508978)*(t10241 + a9074));
  s4103 = ((0.38268343236508978 + 1.0i * 0.92387953251128674)*(t10241 - a9074));
  t10244 = (s4065 + s4081);
  t10245 = (s4065 - s4081);
  t10246 = (s4073 + s4089);
  t10247 = (t10244 + t10246);
  s4104 = (1.0i*(t10244 - t10246));
  a9075 = (1.0i*(s4073 - s4089));
  s4105 = ((0.70710678118654757 + 1.0i * 0.70710678118654757)*(t10245 + a9075));
  s4106 = ((-0.70710678118654757 + 1.0i * 0.70710678118654757)*(t10245 - a9075));
  t10248 = (s4067 + s4083);
  t10249 = (s4067 - s4083);
  t10250 = (s4075 + s4091);
  t10251 = (t10248 + t10250);
  s4107 = ((-0.70710678118654757 + 1.0i * 0.70710678118654757)*(t10248 - t10250));
  a9076 = (1.0i*(s4075 - s4091));
  s4108 = ((0.38268343236508978 + 1.0i * 0.92387953251128674)*(t10249 + a9076));
  s4109 = ((-0.92387953251128674 - 1.0i * 0.38268343236508978)*(t10249 - a9076));
  t10252 = (t10236 + t10247);
  t10253 = (t10236 - t10247);
  t10254 = (t10243 + t10251);
  Y(96) = (t10252 + t10254);
  Y(1120) = (t10252 - t10254);
  a9077 = (1.0i*(t10243 - t10251));
  Y(608) = (t10253 + a9077);
  Y(1632) = (t10253 - a9077);
  t10255 = (t10238 + s4105);
  t10256 = (t10238 - s4105);
  t10257 = (s4102 + s4108);
  Y(224) = (t10255 + t10257);
  Y(1248) = (t10255 - t10257);
  a9078 = (1.0i*(s4102 - s4108));
  Y(736) = (t10256 + a9078);
  Y(1760) = (t10256 - a9078);
  t10258 = (t10237 + s4104);
  t10259 = (t10237 - s4104);
  t10260 = (s4101 + s4107);
  Y(352) = (t10258 + t10260);
  Y(1376) = (t10258 - t10260);
  a9079 = (1.0i*(s4101 - s4107));
  Y(864) = (t10259 + a9079);
  Y(1888) = (t10259 - a9079);
  t10261 = (t10239 + s4106);
  t10262 = (t10239 - s4106);
  t10263 = (s4103 + s4109);
  Y(480) = (t10261 + t10263);
  Y(1504) = (t10261 - t10263);
  a9080 = (1.0i*(s4103 - s4109));
  Y(992) = (t10262 + a9080);
  Y(2016) = (t10262 - a9080);
  for i5370 in 0..30 {
    var a9386, a9395, a9405, a9410, a9415, a9420, a9421, a9422, a9423, a9424, a9425, a9426, a9427, s4302, s4303, s4304, s4305, s4306, s4307, s4308, s4309, s4310, s4311, s4312, s4313, s4314, s4315, s4316, s4317, s4318, s4319, s4320, s4321, s4322, s4323, s4324, s4325, s4326, s4327, s4328, s4329, s4330, s4331, s4332, s4333, s4334, s4335, s4336, s4337, s4338, s4339, s4340, s4341, s4342, s4343, s4344, s4345, s4346, s4347, s4348, s4349, s4350, s4351, s4352, s4353, s4354, s4355, s4356, s4357, s4358, s4359, s4360, s4361, s4362, s4363, s4364, s4365, t10584, t10585, t10586, t10587, t10588, t10589, t10590, t10591, t10592, t10593, t10594, t10595, t10596, t10597, t10598, t10599, t10600, t10601, t10602, t10603, t10604, t10605, t10606, t10607, t10608, t10609, t10610, t10611, t10612, t10613, t10614, t10615, t10616, t10617, t10618, t10619, t10620, t10621, t10622, t10623, t10624, t10625, t10626, t10627, t10628, t10629, t10630, t10631, t10632, t10633, t10634, t10635, t10636, t10637, t10638, t10639, t10640, t10641, t10642, t10643, t10644, t10645, t10646, t10647, t10648, t10649, t10650, t10651, t10652, t10653, t10654, t10655, t10656, t10657, t10658, t10659, t10660, t10661, t10662, t10663, t10664, t10665, t10666:complex;
    var a9378, a9379, a9380, a9381, a9382, a9383, a9384, a9385, a9387, a9388, a9389, a9390, a9391, a9392, a9393, a9394, a9396, a9397, a9398, a9399, a9400, a9401, a9402, a9403, a9404, a9406, a9407, a9408, a9409, a9411, a9412, a9413, a9414, a9416, a9417, a9418, a9419:int;
    a9378 = (33 + i5370);
    a9379 = (1057 + i5370);
    a9380 = (4*i5370);
    s4302 = (dat26(a9380)*buf9(a9378));
    a9381 = (1 + a9380);
    s4303 = (dat26(a9381)*buf9(a9379));
    t10584 = (s4302 + s4303);
    t10585 = (s4302 - s4303);
    a9382 = (545 + i5370);
    a9383 = (1569 + i5370);
    a9384 = (2 + a9380);
    s4304 = (dat26(a9384)*buf9(a9382));
    a9385 = (3 + a9380);
    s4305 = (dat26(a9385)*buf9(a9383));
    t10586 = (s4304 + s4305);
    t10587 = (t10584 + t10586);
    t10588 = (t10584 - t10586);
    a9386 = (1.0i*(s4304 - s4305));
    t10589 = (t10585 + a9386);
    t10590 = (t10585 - a9386);
    a9387 = (289 + i5370);
    a9388 = (1313 + i5370);
    s4306 = (dat27(a9380)*buf9(a9387));
    s4307 = (dat27(a9381)*buf9(a9388));
    t10591 = (s4306 + s4307);
    s4308 = ((0.70710678118654757 + 1.0i * 0.70710678118654757)*(s4306 - s4307));
    a9389 = (801 + i5370);
    a9390 = (1825 + i5370);
    s4309 = (dat27(a9384)*buf9(a9389));
    s4310 = (dat27(a9385)*buf9(a9390));
    t10592 = (s4309 + s4310);
    s4311 = ((-0.70710678118654757 + 1.0i * 0.70710678118654757)*(s4309 - s4310));
    t10593 = (t10591 + t10592);
    s4312 = (1.0i*(t10591 - t10592));
    t10594 = (s4308 + s4311);
    s4313 = (1.0i*(s4308 - s4311));
    t10595 = (t10587 + t10593);
    t10596 = (t10587 - t10593);
    t10597 = (t10589 + t10594);
    t10598 = (t10589 - t10594);
    t10599 = (t10588 + s4312);
    t10600 = (t10588 - s4312);
    t10601 = (t10590 + s4313);
    t10602 = (t10590 - s4313);
    a9391 = (97 + i5370);
    a9392 = (1121 + i5370);
    s4314 = (dat28(a9380)*buf9(a9391));
    s4315 = (dat28(a9381)*buf9(a9392));
    t10603 = (s4314 + s4315);
    t10604 = (s4314 - s4315);
    a9393 = (609 + i5370);
    a9394 = (1633 + i5370);
    s4316 = (dat28(a9384)*buf9(a9393));
    s4317 = (dat28(a9385)*buf9(a9394));
    t10605 = (s4316 + s4317);
    t10606 = (t10603 + t10605);
    t10607 = (t10603 - t10605);
    a9395 = (1.0i*(s4316 - s4317));
    t10608 = (t10604 + a9395);
    t10609 = (t10604 - a9395);
    a9396 = (353 + i5370);
    a9397 = (1377 + i5370);
    s4318 = (dat29(a9380)*buf9(a9396));
    s4319 = (dat29(a9381)*buf9(a9397));
    t10610 = (s4318 + s4319);
    s4320 = ((0.70710678118654757 + 1.0i * 0.70710678118654757)*(s4318 - s4319));
    a9398 = (865 + i5370);
    a9399 = (1889 + i5370);
    s4321 = (dat29(a9384)*buf9(a9398));
    s4322 = (dat29(a9385)*buf9(a9399));
    t10611 = (s4321 + s4322);
    s4323 = ((-0.70710678118654757 + 1.0i * 0.70710678118654757)*(s4321 - s4322));
    t10612 = (t10610 + t10611);
    s4324 = (1.0i*(t10610 - t10611));
    t10613 = (s4320 + s4323);
    s4325 = (1.0i*(s4320 - s4323));
    t10614 = (t10606 + t10612);
    s4326 = ((0.70710678118654757 + 1.0i * 0.70710678118654757)*(t10606 - t10612));
    s4327 = ((0.98078528040323043 + 1.0i * 0.19509032201612825)*(t10608 + t10613));
    s4328 = ((0.55557023301960218 + 1.0i * 0.83146961230254524)*(t10608 - t10613));
    s4329 = ((0.92387953251128674 + 1.0i * 0.38268343236508978)*(t10607 + s4324));
    s4330 = ((0.38268343236508978 + 1.0i * 0.92387953251128674)*(t10607 - s4324));
    s4331 = ((0.83146961230254524 + 1.0i * 0.55557023301960218)*(t10609 + s4325));
    s4332 = ((0.19509032201612825 + 1.0i * 0.98078528040323043)*(t10609 - s4325));
    a9400 = (161 + i5370);
    a9401 = (1185 + i5370);
    a9402 = (8*i5370);
    s4333 = (dat30(a9402)*buf9(a9400));
    s4334 = (dat30((1 + a9402))*buf9(a9401));
    t10615 = (s4333 + s4334);
    t10616 = (s4333 - s4334);
    a9403 = (673 + i5370);
    a9404 = (1697 + i5370);
    s4335 = (dat30((2 + a9402))*buf9(a9403));
    s4336 = (dat30((3 + a9402))*buf9(a9404));
    t10617 = (s4335 + s4336);
    t10618 = (t10615 + t10617);
    s4337 = ((0.70710678118654757 + 1.0i * 0.70710678118654757)*(t10615 - t10617));
    a9405 = (1.0i*(s4335 - s4336));
    s4338 = ((0.92387953251128674 + 1.0i * 0.38268343236508978)*(t10616 + a9405));
    s4339 = ((0.38268343236508978 + 1.0i * 0.92387953251128674)*(t10616 - a9405));
    a9406 = (417 + i5370);
    a9407 = (1441 + i5370);
    s4340 = (dat30((4 + a9402))*buf9(a9406));
    s4341 = (dat30((5 + a9402))*buf9(a9407));
    t10619 = (s4340 + s4341);
    t10620 = (s4340 - s4341);
    a9408 = (929 + i5370);
    a9409 = (1953 + i5370);
    s4342 = (dat30((6 + a9402))*buf9(a9408));
    s4343 = (dat30((7 + a9402))*buf9(a9409));
    t10621 = (s4342 + s4343);
    t10622 = (t10619 + t10621);
    s4344 = ((-0.70710678118654757 + 1.0i * 0.70710678118654757)*(t10619 - t10621));
    a9410 = (1.0i*(s4342 - s4343));
    s4345 = ((0.38268343236508978 + 1.0i * 0.92387953251128674)*(t10620 + a9410));
    s4346 = ((-0.92387953251128674 - 1.0i * 0.38268343236508978)*(t10620 - a9410));
    t10623 = (t10618 + t10622);
    t10624 = ((1.0i*t10618) + ((- 1.0i)*t10622));
    t10625 = (s4338 + s4345);
    t10626 = ((1.0i*s4338) + ((- 1.0i)*s4345));
    t10627 = (s4337 + s4344);
    t10628 = ((1.0i*s4337) + ((- 1.0i)*s4344));
    t10629 = (s4339 + s4346);
    t10630 = ((1.0i*s4339) + ((- 1.0i)*s4346));
    a9411 = (225 + i5370);
    a9412 = (1249 + i5370);
    s4347 = (dat31(a9380)*buf9(a9411));
    s4348 = (dat31(a9381)*buf9(a9412));
    t10631 = (s4347 + s4348);
    t10632 = (s4347 - s4348);
    a9413 = (737 + i5370);
    a9414 = (1761 + i5370);
    s4349 = (dat31(a9384)*buf9(a9413));
    s4350 = (dat31(a9385)*buf9(a9414));
    t10633 = (s4349 + s4350);
    t10634 = (t10631 + t10633);
    t10635 = (t10631 - t10633);
    a9415 = (1.0i*(s4349 - s4350));
    t10636 = (t10632 + a9415);
    t10637 = (t10632 - a9415);
    a9416 = (481 + i5370);
    a9417 = (1505 + i5370);
    s4351 = (dat32(a9380)*buf9(a9416));
    s4352 = (dat32(a9381)*buf9(a9417));
    t10638 = (s4351 + s4352);
    s4353 = ((0.70710678118654757 + 1.0i * 0.70710678118654757)*(s4351 - s4352));
    a9418 = (993 + i5370);
    a9419 = (2017 + i5370);
    s4354 = (dat32(a9384)*buf9(a9418));
    s4355 = (dat32(a9385)*buf9(a9419));
    t10639 = (s4354 + s4355);
    s4356 = ((-0.70710678118654757 + 1.0i * 0.70710678118654757)*(s4354 - s4355));
    t10640 = (t10638 + t10639);
    s4357 = (1.0i*(t10638 - t10639));
    t10641 = (s4353 + s4356);
    s4358 = (1.0i*(s4353 - s4356));
    t10642 = (t10634 + t10640);
    s4359 = ((-0.70710678118654757 + 1.0i * 0.70710678118654757)*(t10634 - t10640));
    s4360 = ((0.83146961230254524 + 1.0i * 0.55557023301960218)*(t10636 + t10641));
    s4361 = ((-0.98078528040323043 + 1.0i * 0.19509032201612825)*(t10636 - t10641));
    s4362 = ((0.38268343236508978 + 1.0i * 0.92387953251128674)*(t10635 + s4357));
    s4363 = ((-0.92387953251128674 - 1.0i * 0.38268343236508978)*(t10635 - s4357));
    s4364 = ((-0.19509032201612825 + 1.0i * 0.98078528040323043)*(t10637 + s4358));
    s4365 = ((-0.55557023301960218 - 1.0i * 0.83146961230254524)*(t10637 - s4358));
    t10643 = (t10595 + t10623);
    t10644 = (t10595 - t10623);
    t10645 = (t10614 + t10642);
    Y(a9378) = (t10643 + t10645);
    Y(a9379) = (t10643 - t10645);
    a9420 = (1.0i*(t10614 - t10642));
    Y(a9382) = (t10644 + a9420);
    Y(a9383) = (t10644 - a9420);
    t10646 = (t10597 + t10625);
    t10647 = (t10597 - t10625);
    t10648 = (s4327 + s4360);
    Y(a9391) = (t10646 + t10648);
    Y(a9392) = (t10646 - t10648);
    a9421 = (1.0i*(s4327 - s4360));
    Y(a9393) = (t10647 + a9421);
    Y(a9394) = (t10647 - a9421);
    t10649 = (t10599 + t10627);
    t10650 = (t10599 - t10627);
    t10651 = (s4329 + s4362);
    Y(a9400) = (t10649 + t10651);
    Y(a9401) = (t10649 - t10651);
    a9422 = (1.0i*(s4329 - s4362));
    Y(a9403) = (t10650 + a9422);
    Y(a9404) = (t10650 - a9422);
    t10652 = (t10601 + t10629);
    t10653 = (t10601 - t10629);
    t10654 = (s4331 + s4364);
    Y(a9411) = (t10652 + t10654);
    Y(a9412) = (t10652 - t10654);
    a9423 = (1.0i*(s4331 - s4364));
    Y(a9413) = (t10653 + a9423);
    Y(a9414) = (t10653 - a9423);
    t10655 = (t10596 + t10624);
    t10656 = (t10596 - t10624);
    t10657 = (s4326 + s4359);
    Y(a9387) = (t10655 + t10657);
    Y(a9388) = (t10655 - t10657);
    a9424 = (1.0i*(s4326 - s4359));
    Y(a9389) = (t10656 + a9424);
    Y(a9390) = (t10656 - a9424);
    t10658 = (t10598 + t10626);
    t10659 = (t10598 - t10626);
    t10660 = (s4328 + s4361);
    Y(a9396) = (t10658 + t10660);
    Y(a9397) = (t10658 - t10660);
    a9425 = (1.0i*(s4328 - s4361));
    Y(a9398) = (t10659 + a9425);
    Y(a9399) = (t10659 - a9425);
    t10661 = (t10600 + t10628);
    t10662 = (t10600 - t10628);
    t10663 = (s4330 + s4363);
    Y(a9406) = (t10661 + t10663);
    Y(a9407) = (t10661 - t10663);
    a9426 = (1.0i*(s4330 - s4363));
    Y(a9408) = (t10662 + a9426);
    Y(a9409) = (t10662 - a9426);
    t10664 = (t10602 + t10630);
    t10665 = (t10602 - t10630);
    t10666 = (s4332 + s4365);
    Y(a9416) = (t10664 + t10666);
    Y(a9417) = (t10664 - t10666);
    a9427 = (1.0i*(s4332 - s4365));
    Y(a9418) = (t10665 + a9427);
    Y(a9419) = (t10665 - a9427);
  }

}
