#!/bin/bash

cat<<eom
// DO NOT EDIT THIS FILE
// generate automatically: anymanaged.bash > anymanaged.chpl 

/////////////////////////////////////////////////////////////////////////////

class C {
  proc type mp() {}
}

proc type C.mA() {}
proc type (C).mB() {}
proc type (C?).mBn() {}
proc type (owned C).mo() {}
proc type (owned C?).mon() {}
proc type (shared C).ms() {}
proc type (shared C?).msn() {}
proc type (borrowed C).mb() {}
proc type (borrowed C?).mbn() {}
proc type (unmanaged C).mu() {}
proc type (unmanaged C?).mun() {}

class D : C { }

class E { }

record R { }

proc sep()           { compilerWarning("", 1); }
proc sepp(type t)    { compilerWarning("========= ", t:string, " =========", 1); }

/////////////////////////////////////////////////////////////////////////////

eom

methods="mp mA mB mBn mo mon ms msn mb mbn mu mun"

function sep() {  echo; echo "sep();"; echo; }
function sepp() {  echo "sepp($*);";  }

function do1() {
  local class="$1" method="$2"
  echo "compilerWarning(\"$class.$method()  \","    \
       "__primitive(\"method call resolves\","      \
       "$class, \"$method\"):string);"
}

for N in C D E; do
  sepp $N; sep
  for m in $methods; do
    for c in "           $N  " \
             "          ($N?)" \
             "    (owned $N )" \
             "    (owned $N?)" \
             "   (shared $N )" \
             "   (shared $N?)" \
             " (borrowed $N )" \
             " (borrowed $N?)" \
             "(unmanaged $N )" \
             "(unmanaged $N?)" ; do
      do1 "$c" "$m"
    done
    sep
  done
done

for N in R int; do
  sepp $N; sep
  for m in $methods; do
    do1 "$N" "$m"
  done
  sep
done

cat<<eom
compilerError("done");  // no need to continue compilation
eom
