use intChoicesHelp, intChoicesTypes;

config param tryErrors = false;

var aColor: color = color.red;

param RED = 0,
      WHITE = 1,
      BLUE = 2;

var Red = 0,
    White = 1,
    Blue = 2;

var i8 = 8:int(8),
    i16 = 16:int(16),
    i32 = 32: int(32),
    i64 = 64: int(64);

param I8: int(8) = 8,
      I16: int(16) = 16,
      I32: int(32) = 32,
      I64: int(64) = 64;

var aSize: sizes = sizes.small;
var anotherSize: sizes = sizes.big;

param SMALL = 126,
      BIG = 131072;

var Small = 126,
    Big = 131072;

writeln("int8or64 variants:");
if !tryErrors then writeln(); else int8or64(color.red);
if !tryErrors then writeln(); else int8or64(aColor);
int8or64(RED);
int8or64(Red);
int8or64(i8);
int8or64(i16);
int8or64(i32);
int8or64(i64);
int8or64(I8);
int8or64(I16);
int8or64(I32);
int8or64(I64);
if !tryErrors then writeln(); else int8or64(sizes.small);
if !tryErrors then writeln(); else int8or64(sizes.big);
if !tryErrors then writeln(); else int8or64(aSize);
if !tryErrors then writeln(); else int8or64(anotherSize);
int8or64(SMALL);
int8or64(BIG);
int8or64(Small);
int8or64(Big);
int8or64(126);
int8or64(131072);
writeln();

writeln("int8or32 variants:");
if !tryErrors then writeln(); else int8or32(color.red);
if !tryErrors then writeln(); else int8or32(aColor);
int8or32(RED);
if (tryErrors) then int8or32(Red); else writeln();
int8or32(i8);
int8or32(i16);
int8or32(i32);
if (tryErrors) then int8or32(i64); else writeln();
int8or32(I8);
int8or32(I16);
int8or32(I32);
int8or32(I64);
if !tryErrors then writeln(); else int8or32(sizes.small);
if !tryErrors then writeln(); else int8or32(sizes.big);
if !tryErrors then writeln(); else int8or32(aSize);
if !tryErrors then writeln(); else int8or32(anotherSize);
int8or32(SMALL);
int8or32(BIG);
if (tryErrors) then int8or32(Small); else writeln();
if (tryErrors) then int8or32(Big); else writeln();
int8or32(126);
int8or32(131072);
writeln();

writeln("param64OrNot variants");
if !tryErrors then writeln(); else param64OrNot(color.red);
if !tryErrors then writeln(); else param64OrNot(aColor);
param64OrNot(RED);
param64OrNot(Red);
param64OrNot(i8);
param64OrNot(i16);
param64OrNot(i32);
param64OrNot(i64);
param64OrNot(I8);
param64OrNot(I16);
param64OrNot(I32);
param64OrNot(I64);
if !tryErrors then writeln(); else param64OrNot(sizes.small);
if !tryErrors then writeln(); else param64OrNot(sizes.big);
if !tryErrors then writeln(); else param64OrNot(aSize);
if !tryErrors then writeln(); else param64OrNot(anotherSize);
param64OrNot(SMALL);
param64OrNot(BIG);
param64OrNot(Small);
param64OrNot(Big);
param64OrNot(126);
param64OrNot(131072);
writeln();

writeln("param8OrNot variants");
if !tryErrors then writeln(); else param8OrNot(color.red);
if !tryErrors then writeln(); else param8OrNot(aColor);
param8OrNot(RED);
if (tryErrors) then param8OrNot(Red); else writeln();
param8OrNot(i8);
if (tryErrors) then param8OrNot(i16); else writeln();
if (tryErrors) then param8OrNot(i32); else writeln();
if (tryErrors) then param8OrNot(i64); else writeln();
param8OrNot(I8);
if (tryErrors) then param8OrNot(I16); else writeln();
if (tryErrors) then param8OrNot(I32); else writeln();
if (tryErrors) then param8OrNot(I64); else writeln();
if !tryErrors then writeln(); else param8OrNot(sizes.small);
if (tryErrors) then param8OrNot(sizes.big); else writeln();
if (tryErrors) then param8OrNot(aSize); else writeln();
if (tryErrors) then param8OrNot(anotherSize); else writeln();
param8OrNot(SMALL);
if (tryErrors) then param8OrNot(BIG); else writeln();
if (tryErrors) then param8OrNot(Small); else writeln();
if (tryErrors) then param8OrNot(Big); else writeln();
param8OrNot(126);
if (tryErrors) then param8OrNot(131072); else writeln();
writeln();

writeln("intOrEnum variants");
intOrEnum(color.red);
intOrEnum(aColor);
intOrEnum(RED);
intOrEnum(Red);
intOrEnum(i8);
intOrEnum(i16);
intOrEnum(i32);
intOrEnum(i64);
intOrEnum(I8);
intOrEnum(I16);
intOrEnum(I32);
intOrEnum(I64);
intOrEnum(sizes.small);
intOrEnum(sizes.big);
intOrEnum(aSize);
intOrEnum(anotherSize);
intOrEnum(SMALL);
intOrEnum(BIG);
intOrEnum(Small);
intOrEnum(Big);
intOrEnum(126);
intOrEnum(131072);
writeln();

writeln("twoInts(color.red, *) variants");
if !tryErrors then writeln(); else twoInts(color.red, color.red);
if !tryErrors then writeln(); else twoInts(color.red, aColor);
if !tryErrors then writeln(); else twoInts(color.red, RED);
if !tryErrors then writeln(); else twoInts(color.red, Red);
if !tryErrors then writeln(); else twoInts(color.red, i8);
if !tryErrors then writeln(); else twoInts(color.red, i16);
if !tryErrors then writeln(); else twoInts(color.red, i32);
if !tryErrors then writeln(); else twoInts(color.red, i64);
if !tryErrors then writeln(); else twoInts(color.red, I8);
if !tryErrors then writeln(); else twoInts(color.red, I16);
if !tryErrors then writeln(); else twoInts(color.red, I32);
if !tryErrors then writeln(); else twoInts(color.red, I64);
if !tryErrors then writeln(); else twoInts(color.red, sizes.small);
if !tryErrors then writeln(); else twoInts(color.red, sizes.big);
if !tryErrors then writeln(); else twoInts(color.red, aSize);
if !tryErrors then writeln(); else twoInts(color.red, anotherSize);
if !tryErrors then writeln(); else twoInts(color.red, SMALL);
if !tryErrors then writeln(); else twoInts(color.red, BIG);
if !tryErrors then writeln(); else twoInts(color.red, Small);
if !tryErrors then writeln(); else twoInts(color.red, Big);
if !tryErrors then writeln(); else twoInts(color.red, 126);
if !tryErrors then writeln(); else twoInts(color.red, 131072);
writeln();

writeln("twoInts(aColor, *) variants");
if !tryErrors then writeln(); else twoInts(aColor, color.red);
if !tryErrors then writeln(); else twoInts(aColor, aColor);
if !tryErrors then writeln(); else twoInts(aColor, RED);
if !tryErrors then writeln(); else twoInts(aColor, Red);
if !tryErrors then writeln(); else twoInts(aColor, i8);
if !tryErrors then writeln(); else twoInts(aColor, i16);
if !tryErrors then writeln(); else twoInts(aColor, i32);
if !tryErrors then writeln(); else twoInts(aColor, i64);
if !tryErrors then writeln(); else twoInts(aColor, I8);
if !tryErrors then writeln(); else twoInts(aColor, I16);
if !tryErrors then writeln(); else twoInts(aColor, I32);
if !tryErrors then writeln(); else twoInts(aColor, I64);
if !tryErrors then writeln(); else twoInts(aColor, sizes.small);
if !tryErrors then writeln(); else twoInts(aColor, sizes.big);
if !tryErrors then writeln(); else twoInts(aColor, aSize);
if !tryErrors then writeln(); else twoInts(aColor, anotherSize);
if !tryErrors then writeln(); else twoInts(aColor, SMALL);
if !tryErrors then writeln(); else twoInts(aColor, BIG);
if !tryErrors then writeln(); else twoInts(aColor, Small);
if !tryErrors then writeln(); else twoInts(aColor, Big);
if !tryErrors then writeln(); else twoInts(aColor, 126);
if !tryErrors then writeln(); else twoInts(aColor, 131072);
writeln();


writeln("twoInts(RED, *) variants");
if !tryErrors then writeln(); else twoInts(RED, color.red);
if !tryErrors then writeln(); else twoInts(RED, aColor);
twoInts(RED, RED);
twoInts(RED, Red);
twoInts(RED, i8);
twoInts(RED, i16);
twoInts(RED, i32);
twoInts(RED, i64);
twoInts(RED, I8);
twoInts(RED, I16);
twoInts(RED, I32);
twoInts(RED, I64);
if !tryErrors then writeln(); else twoInts(RED, sizes.small);
if !tryErrors then writeln(); else twoInts(RED, sizes.big);
if !tryErrors then writeln(); else twoInts(RED, aSize);
if !tryErrors then writeln(); else twoInts(RED, anotherSize);
twoInts(RED, SMALL);
twoInts(RED, BIG);
twoInts(RED, Small);
twoInts(RED, Big);
twoInts(RED, 126);
twoInts(RED, 131072);
writeln();

writeln("twoInts(Red, *) variants");
if !tryErrors then writeln(); else twoInts(Red, color.red);
if !tryErrors then writeln(); else twoInts(Red, aColor);
twoInts(Red, RED);
twoInts(Red, Red);
twoInts(Red, i8);
twoInts(Red, i16);
twoInts(Red, i32);
twoInts(Red, i64);
twoInts(Red, I8);
twoInts(Red, I16);
twoInts(Red, I32);
twoInts(Red, I64);
if !tryErrors then writeln(); else twoInts(Red, sizes.small);
if !tryErrors then writeln(); else twoInts(Red, sizes.big);
if !tryErrors then writeln(); else twoInts(Red, aSize);
if !tryErrors then writeln(); else twoInts(Red, anotherSize);
twoInts(Red, SMALL);
twoInts(Red, BIG);
twoInts(Red, Small);
twoInts(Red, Big);
twoInts(Red, 126);
twoInts(Red, 131072);
writeln();


writeln("twoInts(i8, *) variants");
if !tryErrors then writeln(); else twoInts(i8, color.red);
if !tryErrors then writeln(); else twoInts(i8, aColor);
twoInts(i8, RED);
twoInts(i8, Red);
twoInts(i8, i8);
twoInts(i8, i16);
twoInts(i8, i32);
twoInts(i8, i64);
twoInts(i8, I8);
twoInts(i8, I16);
twoInts(i8, I32);
twoInts(i8, I64);
if !tryErrors then writeln(); else twoInts(i8, sizes.small);
if !tryErrors then writeln(); else twoInts(i8, sizes.big);
if !tryErrors then writeln(); else twoInts(i8, aSize);
if !tryErrors then writeln(); else twoInts(i8, anotherSize);
twoInts(i8, SMALL);
twoInts(i8, BIG);
twoInts(i8, Small);
twoInts(i8, Big);
twoInts(i8, 126);
twoInts(i8, 131072);
writeln();


writeln("twoInts(i16, *) variants");
if !tryErrors then writeln(); else twoInts(i16, color.red);
if !tryErrors then writeln(); else twoInts(i16, aColor);
twoInts(i16, RED);
twoInts(i16, Red);
twoInts(i16, i8);
twoInts(i16, i16);
twoInts(i16, i32);
twoInts(i16, i64);
twoInts(i16, I8);
twoInts(i16, I16);
twoInts(i16, I32);
twoInts(i16, I64);
if !tryErrors then writeln(); else twoInts(i16, sizes.small);
if !tryErrors then writeln(); else twoInts(i16, sizes.big);
if !tryErrors then writeln(); else twoInts(i16, aSize);
if !tryErrors then writeln(); else twoInts(i16, anotherSize);
twoInts(i16, SMALL);
twoInts(i16, BIG);
twoInts(i16, Small);
twoInts(i16, Big);
twoInts(i16, 126);
twoInts(i16, 131072);
writeln();


writeln("twoInts(i32, *) variants");
if !tryErrors then writeln(); else twoInts(i32, color.red);
if !tryErrors then writeln(); else twoInts(i32, aColor);
twoInts(i32, RED);
twoInts(i32, Red);
twoInts(i32, i8);
twoInts(i32, i16);
twoInts(i32, i32);
twoInts(i32, i64);
twoInts(i32, I8);
twoInts(i32, I16);
twoInts(i32, I32);
twoInts(i32, I64);
if !tryErrors then writeln(); else twoInts(i32, sizes.small);
if !tryErrors then writeln(); else twoInts(i32, sizes.big);
if !tryErrors then writeln(); else twoInts(i32, aSize);
if !tryErrors then writeln(); else twoInts(i32, anotherSize);
twoInts(i32, SMALL);
twoInts(i32, BIG);
twoInts(i32, Small);
twoInts(i32, Big);
twoInts(i32, 126);
twoInts(i32, 131072);
writeln();


writeln("twoInts(i64, *) variants");
if !tryErrors then writeln(); else twoInts(i64, color.red);
if !tryErrors then writeln(); else twoInts(i64, aColor);
twoInts(i64, RED);
twoInts(i64, Red);
twoInts(i64, i8);
twoInts(i64, i16);
twoInts(i64, i32);
twoInts(i64, i64);
twoInts(i64, I8);
twoInts(i64, I16);
twoInts(i64, I32);
twoInts(i64, I64);
if !tryErrors then writeln(); else twoInts(i64, sizes.small);
if !tryErrors then writeln(); else twoInts(i64, sizes.big);
if !tryErrors then writeln(); else twoInts(i64, aSize);
if !tryErrors then writeln(); else twoInts(i64, anotherSize);
twoInts(i64, SMALL);
twoInts(i64, BIG);
twoInts(i64, Small);
twoInts(i64, Big);
twoInts(i64, 126);
twoInts(i64, 131072);
writeln();


writeln("twoInts(I8, *) variants");
if !tryErrors then writeln(); else twoInts(I8, color.red);
if !tryErrors then writeln(); else twoInts(I8, aColor);
twoInts(I8, RED);
twoInts(I8, Red);
twoInts(I8, i8);
twoInts(I8, i16);
twoInts(I8, i32);
twoInts(I8, i64);
twoInts(I8, I8);
twoInts(I8, I16);
twoInts(I8, I32);
twoInts(I8, I64);
if !tryErrors then writeln(); else twoInts(I8, sizes.small);
if !tryErrors then writeln(); else twoInts(I8, sizes.big);
if !tryErrors then writeln(); else twoInts(I8, aSize);
if !tryErrors then writeln(); else twoInts(I8, anotherSize);
twoInts(I8, SMALL);
twoInts(I8, BIG);
twoInts(I8, Small);
twoInts(I8, Big);
twoInts(I8, 126);
twoInts(I8, 131072);
writeln();


writeln("twoInts(I16, *) variants");
if !tryErrors then writeln(); else twoInts(I16, color.red);
if !tryErrors then writeln(); else twoInts(I16, aColor);
twoInts(I16, RED);
twoInts(I16, Red);
twoInts(I16, i8);
twoInts(I16, i16);
twoInts(I16, i32);
twoInts(I16, i64);
twoInts(I16, I8);
twoInts(I16, I16);
twoInts(I16, I32);
twoInts(I16, I64);
if !tryErrors then writeln(); else twoInts(I16, sizes.small);
if !tryErrors then writeln(); else twoInts(I16, sizes.big);
if !tryErrors then writeln(); else twoInts(I16, aSize);
if !tryErrors then writeln(); else twoInts(I16, anotherSize);
twoInts(I16, SMALL);
twoInts(I16, BIG);
twoInts(I16, Small);
twoInts(I16, Big);
twoInts(I16, 126);
twoInts(I16, 131072);
writeln();


writeln("twoInts(I32, *) variants");
if !tryErrors then writeln(); else twoInts(I32, color.red);
if !tryErrors then writeln(); else twoInts(I32, aColor);
twoInts(I32, RED);
twoInts(I32, Red);
twoInts(I32, i8);
twoInts(I32, i16);
twoInts(I32, i32);
twoInts(I32, i64);
twoInts(I32, I8);
twoInts(I32, I16);
twoInts(I32, I32);
twoInts(I32, I64);
if !tryErrors then writeln(); else twoInts(I32, sizes.small);
if !tryErrors then writeln(); else twoInts(I32, sizes.big);
if !tryErrors then writeln(); else twoInts(I32, aSize);
if !tryErrors then writeln(); else twoInts(I32, anotherSize);
twoInts(I32, SMALL);
twoInts(I32, BIG);
twoInts(I32, Small);
twoInts(I32, Big);
twoInts(I32, 126);
twoInts(I32, 131072);
writeln();


writeln("twoInts(I64, *) variants");
if !tryErrors then writeln(); else twoInts(I64, color.red);
if !tryErrors then writeln(); else twoInts(I64, aColor);
twoInts(I64, RED);
twoInts(I64, Red);
twoInts(I64, i8);
twoInts(I64, i16);
twoInts(I64, i32);
twoInts(I64, i64);
twoInts(I64, I8);
twoInts(I64, I16);
twoInts(I64, I32);
twoInts(I64, I64);
if !tryErrors then writeln(); else twoInts(I64, sizes.small);
if !tryErrors then writeln(); else twoInts(I64, sizes.big);
if !tryErrors then writeln(); else twoInts(I64, aSize);
if !tryErrors then writeln(); else twoInts(I64, anotherSize);
twoInts(I64, SMALL);
twoInts(I64, BIG);
twoInts(I64, Small);
twoInts(I64, Big);
twoInts(I64, 126);
twoInts(I64, 131072);
writeln();


writeln("twoInts(sizes.small, *) variants");
if !tryErrors then writeln(); else twoInts(sizes.small, color.red);
if !tryErrors then writeln(); else twoInts(sizes.small, aColor);
if !tryErrors then writeln(); else twoInts(sizes.small, RED);
if !tryErrors then writeln(); else twoInts(sizes.small, Red);
if !tryErrors then writeln(); else twoInts(sizes.small, i8);if !tryErrors then writeln(); else 
if !tryErrors then writeln(); else twoInts(sizes.small, i16);
if !tryErrors then writeln(); else twoInts(sizes.small, i32);
if !tryErrors then writeln(); else twoInts(sizes.small, i64);
if !tryErrors then writeln(); else twoInts(sizes.small, I8);
if !tryErrors then writeln(); else twoInts(sizes.small, I16);
if !tryErrors then writeln(); else twoInts(sizes.small, I32);
if !tryErrors then writeln(); else twoInts(sizes.small, I64);
if !tryErrors then writeln(); else twoInts(sizes.small, sizes.small);
if !tryErrors then writeln(); else twoInts(sizes.small, sizes.big);
if !tryErrors then writeln(); else twoInts(sizes.small, aSize);
if !tryErrors then writeln(); else twoInts(sizes.small, anotherSize);
if !tryErrors then writeln(); else twoInts(sizes.small, SMALL);
if !tryErrors then writeln(); else twoInts(sizes.small, BIG);
if !tryErrors then writeln(); else twoInts(sizes.small, Small);
if !tryErrors then writeln(); else twoInts(sizes.small, Big);
if !tryErrors then writeln(); else twoInts(sizes.small, 126);
if !tryErrors then writeln(); else twoInts(sizes.small, 131072);
writeln();


writeln("twoInts(sizes.big, *) variants");
if !tryErrors then writeln(); else twoInts(sizes.big, color.red);
if !tryErrors then writeln(); else twoInts(sizes.big, aColor);
if !tryErrors then writeln(); else twoInts(sizes.big, RED);
if !tryErrors then writeln(); else twoInts(sizes.big, Red);
if !tryErrors then writeln(); else twoInts(sizes.big, i8);
if !tryErrors then writeln(); else twoInts(sizes.big, i16);
if !tryErrors then writeln(); else twoInts(sizes.big, i32);
if !tryErrors then writeln(); else twoInts(sizes.big, i64);
if !tryErrors then writeln(); else twoInts(sizes.big, I8);
if !tryErrors then writeln(); else twoInts(sizes.big, I16);
if !tryErrors then writeln(); else twoInts(sizes.big, I32);
if !tryErrors then writeln(); else twoInts(sizes.big, I64);
if !tryErrors then writeln(); else twoInts(sizes.big, sizes.small);
if !tryErrors then writeln(); else twoInts(sizes.big, sizes.big);
if !tryErrors then writeln(); else twoInts(sizes.big, aSize);
if !tryErrors then writeln(); else twoInts(sizes.big, anotherSize);
if !tryErrors then writeln(); else twoInts(sizes.big, SMALL);
if !tryErrors then writeln(); else twoInts(sizes.big, BIG);
if !tryErrors then writeln(); else twoInts(sizes.big, Small);
if !tryErrors then writeln(); else twoInts(sizes.big, Big);
if !tryErrors then writeln(); else twoInts(sizes.big, 126);
if !tryErrors then writeln(); else twoInts(sizes.big, 131072);
writeln();


writeln("twoInts(aSize, *) variants");
if !tryErrors then writeln(); else twoInts(aSize, color.red);
if !tryErrors then writeln(); else twoInts(aSize, aColor);
if !tryErrors then writeln(); else twoInts(aSize, RED);
if !tryErrors then writeln(); else twoInts(aSize, Red);
if !tryErrors then writeln(); else twoInts(aSize, i8);
if !tryErrors then writeln(); else twoInts(aSize, i16);
if !tryErrors then writeln(); else twoInts(aSize, i32);
if !tryErrors then writeln(); else twoInts(aSize, i64);
if !tryErrors then writeln(); else twoInts(aSize, I8);
if !tryErrors then writeln(); else twoInts(aSize, I16);
if !tryErrors then writeln(); else twoInts(aSize, I32);
if !tryErrors then writeln(); else twoInts(aSize, I64);
if !tryErrors then writeln(); else twoInts(aSize, sizes.small);
if !tryErrors then writeln(); else twoInts(aSize, sizes.big);
if !tryErrors then writeln(); else twoInts(aSize, aSize);
if !tryErrors then writeln(); else twoInts(aSize, anotherSize);
if !tryErrors then writeln(); else twoInts(aSize, SMALL);
if !tryErrors then writeln(); else twoInts(aSize, BIG);
if !tryErrors then writeln(); else twoInts(aSize, Small);
if !tryErrors then writeln(); else twoInts(aSize, Big);
if !tryErrors then writeln(); else twoInts(aSize, 126);
if !tryErrors then writeln(); else twoInts(aSize, 131072);
writeln();


writeln("twoInts(anotherSize, *) variants");
if !tryErrors then writeln(); else twoInts(anotherSize, color.red);
if !tryErrors then writeln(); else twoInts(anotherSize, aColor);
if !tryErrors then writeln(); else twoInts(anotherSize, RED);
if !tryErrors then writeln(); else twoInts(anotherSize, Red);
if !tryErrors then writeln(); else twoInts(anotherSize, i8);
if !tryErrors then writeln(); else twoInts(anotherSize, i16);
if !tryErrors then writeln(); else twoInts(anotherSize, i32);
if !tryErrors then writeln(); else twoInts(anotherSize, i64);
if !tryErrors then writeln(); else twoInts(anotherSize, I8);
if !tryErrors then writeln(); else twoInts(anotherSize, I16);
if !tryErrors then writeln(); else twoInts(anotherSize, I32);
if !tryErrors then writeln(); else twoInts(anotherSize, I64);
if !tryErrors then writeln(); else twoInts(anotherSize, sizes.small);
if !tryErrors then writeln(); else twoInts(anotherSize, sizes.big);
if !tryErrors then writeln(); else twoInts(anotherSize, aSize);
if !tryErrors then writeln(); else twoInts(anotherSize, anotherSize);
if !tryErrors then writeln(); else twoInts(anotherSize, SMALL);
if !tryErrors then writeln(); else twoInts(anotherSize, BIG);
if !tryErrors then writeln(); else twoInts(anotherSize, Small);
if !tryErrors then writeln(); else twoInts(anotherSize, Big);
if !tryErrors then writeln(); else twoInts(anotherSize, 126);
if !tryErrors then writeln(); else twoInts(anotherSize, 131072);
writeln();


writeln("twoInts(SMALL, *) variants");
if !tryErrors then writeln(); else twoInts(SMALL, color.red);
if !tryErrors then writeln(); else twoInts(SMALL, aColor);
twoInts(SMALL, RED);
twoInts(SMALL, Red);
twoInts(SMALL, i8);
twoInts(SMALL, i16);
twoInts(SMALL, i32);
twoInts(SMALL, i64);
twoInts(SMALL, I8);
twoInts(SMALL, I16);
twoInts(SMALL, I32);
twoInts(SMALL, I64);
if !tryErrors then writeln(); else twoInts(SMALL, sizes.small);
if !tryErrors then writeln(); else twoInts(SMALL, sizes.big);
if !tryErrors then writeln(); else twoInts(SMALL, aSize);
if !tryErrors then writeln(); else twoInts(SMALL, anotherSize);
twoInts(SMALL, SMALL);
twoInts(SMALL, BIG);
twoInts(SMALL, Small);
twoInts(SMALL, Big);
twoInts(SMALL, 126);
twoInts(SMALL, 131072);
writeln();


writeln("twoInts(BIG, *) variants");
if !tryErrors then writeln(); else twoInts(BIG, color.red);
if !tryErrors then writeln(); else twoInts(BIG, aColor);
twoInts(BIG, RED);
twoInts(BIG, Red);
twoInts(BIG, i8);
twoInts(BIG, i16);
twoInts(BIG, i32);
twoInts(BIG, i64);
twoInts(BIG, I8);
twoInts(BIG, I16);
twoInts(BIG, I32);
twoInts(BIG, I64);
if !tryErrors then writeln(); else twoInts(BIG, sizes.small);
if !tryErrors then writeln(); else twoInts(BIG, sizes.big);
if !tryErrors then writeln(); else twoInts(BIG, aSize);
if !tryErrors then writeln(); else twoInts(BIG, anotherSize);
twoInts(BIG, SMALL);
twoInts(BIG, BIG);
twoInts(BIG, Small);
twoInts(BIG, Big);
twoInts(BIG, 126);
twoInts(BIG, 131072);
writeln();


writeln("twoInts(Small, *) variants");
if !tryErrors then writeln(); else twoInts(Small, color.red);
if !tryErrors then writeln(); else twoInts(Small, aColor);
twoInts(Small, RED);
twoInts(Small, Red);
twoInts(Small, i8);
twoInts(Small, i16);
twoInts(Small, i32);
twoInts(Small, i64);
twoInts(Small, I8);
twoInts(Small, I16);
twoInts(Small, I32);
twoInts(Small, I64);
if !tryErrors then writeln(); else twoInts(Small, sizes.small);
if !tryErrors then writeln(); else twoInts(Small, sizes.big);
if !tryErrors then writeln(); else twoInts(Small, aSize);
if !tryErrors then writeln(); else twoInts(Small, anotherSize);
twoInts(Small, SMALL);
twoInts(Small, BIG);
twoInts(Small, Small);
twoInts(Small, Big);
twoInts(Small, 126);
twoInts(Small, 131072);
writeln();


writeln("twoInts(Big, *) variants");
if !tryErrors then writeln(); else twoInts(Big, color.red);
if !tryErrors then writeln(); else twoInts(Big, aColor);
twoInts(Big, RED);
twoInts(Big, Red);
twoInts(Big, i8);
twoInts(Big, i16);
twoInts(Big, i32);
twoInts(Big, i64);
twoInts(Big, I8);
twoInts(Big, I16);
twoInts(Big, I32);
twoInts(Big, I64);
if !tryErrors then writeln(); else twoInts(Big, sizes.small);
if !tryErrors then writeln(); else twoInts(Big, sizes.big);
if !tryErrors then writeln(); else twoInts(Big, aSize);
if !tryErrors then writeln(); else twoInts(Big, anotherSize);
twoInts(Big, SMALL);
twoInts(Big, BIG);
twoInts(Big, Small);
twoInts(Big, Big);
twoInts(Big, 126);
twoInts(Big, 131072);
writeln();

writeln("twoInts(126, *) variants");
if !tryErrors then writeln(); else twoInts(126, color.red);
if !tryErrors then writeln(); else twoInts(126, aColor);
twoInts(126, RED);
twoInts(126, Red);
twoInts(126, i8);
twoInts(126, i16);
twoInts(126, i32);
twoInts(126, i64);
twoInts(126, I8);
twoInts(126, I16);
twoInts(126, I32);
twoInts(126, I64);
if !tryErrors then writeln(); else twoInts(126, sizes.small);
if !tryErrors then writeln(); else twoInts(126, sizes.big);
if !tryErrors then writeln(); else twoInts(126, aSize);
if !tryErrors then writeln(); else twoInts(126, anotherSize);
twoInts(126, SMALL);
twoInts(126, BIG);
twoInts(126, Small);
twoInts(126, Big);
twoInts(126, 126);
twoInts(126, 131072);
writeln();

writeln("twoInts(131072, *) variants");
if !tryErrors then writeln(); else twoInts(131072, color.red);
if !tryErrors then writeln(); else twoInts(131072, aColor);
twoInts(131072, RED);
twoInts(131072, Red);
twoInts(131072, i8);
twoInts(131072, i16);
twoInts(131072, i32);
twoInts(131072, i64);
twoInts(131072, I8);
twoInts(131072, I16);
twoInts(131072, I32);
twoInts(131072, I64);
if !tryErrors then writeln(); else twoInts(131072, sizes.small);
if !tryErrors then writeln(); else twoInts(131072, sizes.big);
if !tryErrors then writeln(); else twoInts(131072, aSize);
if !tryErrors then writeln(); else twoInts(131072, anotherSize);
twoInts(131072, SMALL);
twoInts(131072, BIG);
twoInts(131072, Small);
twoInts(131072, Big);
twoInts(131072, 126);
twoInts(131072, 131072);
writeln();


writeln("intEnum(color.red, *) variants");
intEnum(color.red, color.red);
intEnum(color.red, aColor);
intEnum(color.red, RED);
intEnum(color.red, Red);
intEnum(color.red, i8);
intEnum(color.red, i16);
intEnum(color.red, i32);
intEnum(color.red, i64);
intEnum(color.red, I8);
intEnum(color.red, I16);
intEnum(color.red, I32);
intEnum(color.red, I64);
if !tryErrors then writeln(); else intEnum(color.red, sizes.small);
if !tryErrors then writeln(); else intEnum(color.red, sizes.big);
if !tryErrors then writeln(); else intEnum(color.red, aSize);
if !tryErrors then writeln(); else intEnum(color.red, anotherSize);
intEnum(color.red, SMALL);
intEnum(color.red, BIG);
intEnum(color.red, Small);
intEnum(color.red, Big);
intEnum(color.red, 126);
intEnum(color.red, 131072);
writeln();

writeln("intEnum(aColor, *) variants");
intEnum(aColor, color.red);
intEnum(aColor, aColor);
intEnum(aColor, RED);
intEnum(aColor, Red);
intEnum(aColor, i8);
intEnum(aColor, i16);
intEnum(aColor, i32);
intEnum(aColor, i64);
intEnum(aColor, I8);
intEnum(aColor, I16);
intEnum(aColor, I32);
intEnum(aColor, I64);
if !tryErrors then writeln(); else intEnum(aColor, sizes.small);
if !tryErrors then writeln(); else intEnum(aColor, sizes.big);
if !tryErrors then writeln(); else intEnum(aColor, aSize);
if !tryErrors then writeln(); else intEnum(aColor, anotherSize);
intEnum(aColor, SMALL);
intEnum(aColor, BIG);
intEnum(aColor, Small);
intEnum(aColor, Big);
intEnum(aColor, 126);
intEnum(aColor, 131072);
writeln();


writeln("intEnum(RED, *) variants");
intEnum(RED, color.red);
intEnum(RED, aColor);
intEnum(RED, RED);
intEnum(RED, Red);
intEnum(RED, i8);
intEnum(RED, i16);
intEnum(RED, i32);
intEnum(RED, i64);
intEnum(RED, I8);
intEnum(RED, I16);
intEnum(RED, I32);
intEnum(RED, I64);
if !tryErrors then writeln(); else intEnum(RED, sizes.small);
if !tryErrors then writeln(); else intEnum(RED, sizes.big);
if !tryErrors then writeln(); else intEnum(RED, aSize);
if !tryErrors then writeln(); else intEnum(RED, anotherSize);
intEnum(RED, SMALL);
intEnum(RED, BIG);
intEnum(RED, Small);
intEnum(RED, Big);
intEnum(RED, 126);
intEnum(RED, 131072);
writeln();

writeln("intEnum(Red, *) variants");
intEnum(Red, color.red);
intEnum(Red, aColor);
intEnum(Red, RED);
intEnum(Red, Red);
intEnum(Red, i8);
intEnum(Red, i16);
intEnum(Red, i32);
intEnum(Red, i64);
intEnum(Red, I8);
intEnum(Red, I16);
intEnum(Red, I32);
intEnum(Red, I64);
if !tryErrors then writeln(); else intEnum(Red, sizes.small);
if !tryErrors then writeln(); else intEnum(Red, sizes.big);
if !tryErrors then writeln(); else intEnum(Red, aSize);
if !tryErrors then writeln(); else intEnum(Red, anotherSize);
intEnum(Red, SMALL);
intEnum(Red, BIG);
intEnum(Red, Small);
intEnum(Red, Big);
intEnum(Red, 126);
intEnum(Red, 131072);
writeln();


writeln("intEnum(i8, *) variants");
intEnum(i8, color.red);
intEnum(i8, aColor);
intEnum(i8, RED);
intEnum(i8, Red);
intEnum(i8, i8);
intEnum(i8, i16);
intEnum(i8, i32);
intEnum(i8, i64);
intEnum(i8, I8);
intEnum(i8, I16);
intEnum(i8, I32);
intEnum(i8, I64);
if !tryErrors then writeln(); else intEnum(i8, sizes.small);
if !tryErrors then writeln(); else intEnum(i8, sizes.big);
if !tryErrors then writeln(); else intEnum(i8, aSize);
if !tryErrors then writeln(); else intEnum(i8, anotherSize);
intEnum(i8, SMALL);
intEnum(i8, BIG);
intEnum(i8, Small);
intEnum(i8, Big);
intEnum(i8, 126);
intEnum(i8, 131072);
writeln();


writeln("intEnum(i16, *) variants");
intEnum(i16, color.red);
intEnum(i16, aColor);
intEnum(i16, RED);
intEnum(i16, Red);
intEnum(i16, i8);
intEnum(i16, i16);
intEnum(i16, i32);
intEnum(i16, i64);
intEnum(i16, I8);
intEnum(i16, I16);
intEnum(i16, I32);
intEnum(i16, I64);
if !tryErrors then writeln(); else intEnum(i16, sizes.small);
if !tryErrors then writeln(); else intEnum(i16, sizes.big);
if !tryErrors then writeln(); else intEnum(i16, aSize);
if !tryErrors then writeln(); else intEnum(i16, anotherSize);
intEnum(i16, SMALL);
intEnum(i16, BIG);
intEnum(i16, Small);
intEnum(i16, Big);
intEnum(i16, 126);
intEnum(i16, 131072);
writeln();


writeln("intEnum(i32, *) variants");
intEnum(i32, color.red);
intEnum(i32, aColor);
intEnum(i32, RED);
intEnum(i32, Red);
intEnum(i32, i8);
intEnum(i32, i16);
intEnum(i32, i32);
intEnum(i32, i64);
intEnum(i32, I8);
intEnum(i32, I16);
intEnum(i32, I32);
intEnum(i32, I64);
if !tryErrors then writeln(); else intEnum(i32, sizes.small);
if !tryErrors then writeln(); else intEnum(i32, sizes.big);
if !tryErrors then writeln(); else intEnum(i32, aSize);
if !tryErrors then writeln(); else intEnum(i32, anotherSize);
intEnum(i32, SMALL);
intEnum(i32, BIG);
intEnum(i32, Small);
intEnum(i32, Big);
intEnum(i32, 126);
intEnum(i32, 131072);
writeln();


writeln("intEnum(i64, *) variants");
intEnum(i64, color.red);
intEnum(i64, aColor);
intEnum(i64, RED);
intEnum(i64, Red);
intEnum(i64, i8);
intEnum(i64, i16);
intEnum(i64, i32);
intEnum(i64, i64);
intEnum(i64, I8);
intEnum(i64, I16);
intEnum(i64, I32);
intEnum(i64, I64);
if !tryErrors then writeln(); else intEnum(i64, sizes.small);
if !tryErrors then writeln(); else intEnum(i64, sizes.big);
if !tryErrors then writeln(); else intEnum(i64, aSize);
if !tryErrors then writeln(); else intEnum(i64, anotherSize);
intEnum(i64, SMALL);
intEnum(i64, BIG);
intEnum(i64, Small);
intEnum(i64, Big);
intEnum(i64, 126);
intEnum(i64, 131072);
writeln();


writeln("intEnum(I8, *) variants");
intEnum(I8, color.red);
intEnum(I8, aColor);
intEnum(I8, RED);
intEnum(I8, Red);
intEnum(I8, i8);
intEnum(I8, i16);
intEnum(I8, i32);
intEnum(I8, i64);
intEnum(I8, I8);
intEnum(I8, I16);
intEnum(I8, I32);
intEnum(I8, I64);
if !tryErrors then writeln(); else intEnum(I8, sizes.small);
if !tryErrors then writeln(); else intEnum(I8, sizes.big);
if !tryErrors then writeln(); else intEnum(I8, aSize);
if !tryErrors then writeln(); else intEnum(I8, anotherSize);
intEnum(I8, SMALL);
intEnum(I8, BIG);
intEnum(I8, Small);
intEnum(I8, Big);
intEnum(I8, 126);
intEnum(I8, 131072);
writeln();


writeln("intEnum(I16, *) variants");
intEnum(I16, color.red);
intEnum(I16, aColor);
intEnum(I16, RED);
intEnum(I16, Red);
intEnum(I16, i8);
intEnum(I16, i16);
intEnum(I16, i32);
intEnum(I16, i64);
intEnum(I16, I8);
intEnum(I16, I16);
intEnum(I16, I32);
intEnum(I16, I64);
if !tryErrors then writeln(); else intEnum(I16, sizes.small);
if !tryErrors then writeln(); else intEnum(I16, sizes.big);
if !tryErrors then writeln(); else intEnum(I16, aSize);
if !tryErrors then writeln(); else intEnum(I16, anotherSize);
intEnum(I16, SMALL);
intEnum(I16, BIG);
intEnum(I16, Small);
intEnum(I16, Big);
intEnum(I16, 126);
intEnum(I16, 131072);
writeln();


writeln("intEnum(I32, *) variants");
intEnum(I32, color.red);
intEnum(I32, aColor);
intEnum(I32, RED);
intEnum(I32, Red);
intEnum(I32, i8);
intEnum(I32, i16);
intEnum(I32, i32);
intEnum(I32, i64);
intEnum(I32, I8);
intEnum(I32, I16);
intEnum(I32, I32);
intEnum(I32, I64);
if !tryErrors then writeln(); else intEnum(I32, sizes.small);
if !tryErrors then writeln(); else intEnum(I32, sizes.big);
if !tryErrors then writeln(); else intEnum(I32, aSize);
if !tryErrors then writeln(); else intEnum(I32, anotherSize);
intEnum(I32, SMALL);
intEnum(I32, BIG);
intEnum(I32, Small);
intEnum(I32, Big);
intEnum(I32, 126);
intEnum(I32, 131072);
writeln();


writeln("intEnum(I64, *) variants");
intEnum(I64, color.red);
intEnum(I64, aColor);
intEnum(I64, RED);
intEnum(I64, Red);
intEnum(I64, i8);
intEnum(I64, i16);
intEnum(I64, i32);
intEnum(I64, i64);
intEnum(I64, I8);
intEnum(I64, I16);
intEnum(I64, I32);
intEnum(I64, I64);
if !tryErrors then writeln(); else intEnum(I64, sizes.small);
if !tryErrors then writeln(); else intEnum(I64, sizes.big);
if !tryErrors then writeln(); else intEnum(I64, aSize);
if !tryErrors then writeln(); else intEnum(I64, anotherSize);
intEnum(I64, SMALL);
intEnum(I64, BIG);
intEnum(I64, Small);
intEnum(I64, Big);
intEnum(I64, 126);
intEnum(I64, 131072);
writeln();


writeln("intEnum(sizes.small, *) variants");
if !tryErrors then writeln(); else intEnum(sizes.small, color.red);
if !tryErrors then writeln(); else intEnum(sizes.small, aColor);
if !tryErrors then writeln(); else intEnum(sizes.small, RED);
if !tryErrors then writeln(); else intEnum(sizes.small, Red);
if !tryErrors then writeln(); else intEnum(sizes.small, i8);
if !tryErrors then writeln(); else intEnum(sizes.small, i16);
if !tryErrors then writeln(); else intEnum(sizes.small, i32);
if !tryErrors then writeln(); else intEnum(sizes.small, i64);
if !tryErrors then writeln(); else intEnum(sizes.small, I8);
if !tryErrors then writeln(); else intEnum(sizes.small, I16);
if !tryErrors then writeln(); else intEnum(sizes.small, I32);
if !tryErrors then writeln(); else intEnum(sizes.small, I64);
if !tryErrors then writeln(); else intEnum(sizes.small, sizes.small);
if !tryErrors then writeln(); else intEnum(sizes.small, sizes.big);
if !tryErrors then writeln(); else intEnum(sizes.small, aSize);
if !tryErrors then writeln(); else intEnum(sizes.small, anotherSize);
if !tryErrors then writeln(); else intEnum(sizes.small, SMALL);
if !tryErrors then writeln(); else intEnum(sizes.small, BIG);
if !tryErrors then writeln(); else intEnum(sizes.small, Small);
if !tryErrors then writeln(); else intEnum(sizes.small, Big);
if !tryErrors then writeln(); else intEnum(sizes.small, 126);
if !tryErrors then writeln(); else intEnum(sizes.small, 131072);
writeln();


writeln("intEnum(sizes.big, *) variants");
if !tryErrors then writeln(); else intEnum(sizes.big, color.red);
if !tryErrors then writeln(); else intEnum(sizes.big, aColor);
if !tryErrors then writeln(); else intEnum(sizes.big, RED);
if !tryErrors then writeln(); else intEnum(sizes.big, Red);
if !tryErrors then writeln(); else intEnum(sizes.big, i8);
if !tryErrors then writeln(); else intEnum(sizes.big, i16);
if !tryErrors then writeln(); else intEnum(sizes.big, i32);
if !tryErrors then writeln(); else intEnum(sizes.big, i64);
if !tryErrors then writeln(); else intEnum(sizes.big, I8);
if !tryErrors then writeln(); else intEnum(sizes.big, I16);
if !tryErrors then writeln(); else intEnum(sizes.big, I32);
if !tryErrors then writeln(); else intEnum(sizes.big, I64);
if !tryErrors then writeln(); else intEnum(sizes.big, sizes.small);
if !tryErrors then writeln(); else intEnum(sizes.big, sizes.big);
if !tryErrors then writeln(); else intEnum(sizes.big, aSize);
if !tryErrors then writeln(); else intEnum(sizes.big, anotherSize);
if !tryErrors then writeln(); else intEnum(sizes.big, SMALL);
if !tryErrors then writeln(); else intEnum(sizes.big, BIG);
if !tryErrors then writeln(); else intEnum(sizes.big, Small);
if !tryErrors then writeln(); else intEnum(sizes.big, Big);
if !tryErrors then writeln(); else intEnum(sizes.big, 126);
if !tryErrors then writeln(); else intEnum(sizes.big, 131072);
writeln();


writeln("intEnum(aSize, *) variants");
if !tryErrors then writeln(); else intEnum(aSize, color.red);
if !tryErrors then writeln(); else intEnum(aSize, aColor);
if !tryErrors then writeln(); else intEnum(aSize, RED);
if !tryErrors then writeln(); else intEnum(aSize, Red);
if !tryErrors then writeln(); else intEnum(aSize, i8);
if !tryErrors then writeln(); else intEnum(aSize, i16);
if !tryErrors then writeln(); else intEnum(aSize, i32);
if !tryErrors then writeln(); else intEnum(aSize, i64);
if !tryErrors then writeln(); else intEnum(aSize, I8);
if !tryErrors then writeln(); else intEnum(aSize, I16);
if !tryErrors then writeln(); else intEnum(aSize, I32);
if !tryErrors then writeln(); else intEnum(aSize, I64);
if !tryErrors then writeln(); else intEnum(aSize, sizes.small);
if !tryErrors then writeln(); else intEnum(aSize, sizes.big);
if !tryErrors then writeln(); else intEnum(aSize, aSize);
if !tryErrors then writeln(); else intEnum(aSize, anotherSize);
if !tryErrors then writeln(); else intEnum(aSize, SMALL);
if !tryErrors then writeln(); else intEnum(aSize, BIG);
if !tryErrors then writeln(); else intEnum(aSize, Small);
if !tryErrors then writeln(); else intEnum(aSize, Big);
if !tryErrors then writeln(); else intEnum(aSize, 126);
if !tryErrors then writeln(); else intEnum(aSize, 131072);
writeln();


writeln("intEnum(anotherSize, *) variants");
if !tryErrors then writeln(); else intEnum(anotherSize, color.red);
if !tryErrors then writeln(); else intEnum(anotherSize, aColor);
if !tryErrors then writeln(); else intEnum(anotherSize, RED);
if !tryErrors then writeln(); else intEnum(anotherSize, Red);
if !tryErrors then writeln(); else intEnum(anotherSize, i8);
if !tryErrors then writeln(); else intEnum(anotherSize, i16);
if !tryErrors then writeln(); else intEnum(anotherSize, i32);
if !tryErrors then writeln(); else intEnum(anotherSize, i64);
if !tryErrors then writeln(); else intEnum(anotherSize, I8);
if !tryErrors then writeln(); else intEnum(anotherSize, I16);
if !tryErrors then writeln(); else intEnum(anotherSize, I32);
if !tryErrors then writeln(); else intEnum(anotherSize, I64);
if !tryErrors then writeln(); else intEnum(anotherSize, sizes.small);
if !tryErrors then writeln(); else intEnum(anotherSize, sizes.big);
if !tryErrors then writeln(); else intEnum(anotherSize, aSize);
if !tryErrors then writeln(); else intEnum(anotherSize, anotherSize);
if !tryErrors then writeln(); else intEnum(anotherSize, SMALL);
if !tryErrors then writeln(); else intEnum(anotherSize, BIG);
if !tryErrors then writeln(); else intEnum(anotherSize, Small);
if !tryErrors then writeln(); else intEnum(anotherSize, Big);
if !tryErrors then writeln(); else intEnum(anotherSize, 126);
if !tryErrors then writeln(); else intEnum(anotherSize, 131072);
writeln();


writeln("intEnum(SMALL, *) variants");
intEnum(SMALL, color.red);
intEnum(SMALL, aColor);
intEnum(SMALL, RED);
intEnum(SMALL, Red);
intEnum(SMALL, i8);
intEnum(SMALL, i16);
intEnum(SMALL, i32);
intEnum(SMALL, i64);
intEnum(SMALL, I8);
intEnum(SMALL, I16);
intEnum(SMALL, I32);
intEnum(SMALL, I64);
if !tryErrors then writeln(); else intEnum(SMALL, sizes.small);
if !tryErrors then writeln(); else intEnum(SMALL, sizes.big);
if !tryErrors then writeln(); else intEnum(SMALL, aSize);
if !tryErrors then writeln(); else intEnum(SMALL, anotherSize);
intEnum(SMALL, SMALL);
intEnum(SMALL, BIG);
intEnum(SMALL, Small);
intEnum(SMALL, Big);
intEnum(SMALL, 126);
intEnum(SMALL, 131072);
writeln();


writeln("intEnum(BIG, *) variants");
intEnum(BIG, color.red);
intEnum(BIG, aColor);
intEnum(BIG, RED);
intEnum(BIG, Red);
intEnum(BIG, i8);
intEnum(BIG, i16);
intEnum(BIG, i32);
intEnum(BIG, i64);
intEnum(BIG, I8);
intEnum(BIG, I16);
intEnum(BIG, I32);
intEnum(BIG, I64);
if !tryErrors then writeln(); else intEnum(BIG, sizes.small);
if !tryErrors then writeln(); else intEnum(BIG, sizes.big);
if !tryErrors then writeln(); else intEnum(BIG, aSize);
if !tryErrors then writeln(); else intEnum(BIG, anotherSize);
intEnum(BIG, SMALL);
intEnum(BIG, BIG);
intEnum(BIG, Small);
intEnum(BIG, Big);
intEnum(BIG, 126);
intEnum(BIG, 131072);
writeln();


writeln("intEnum(Small, *) variants");
intEnum(Small, color.red);
intEnum(Small, aColor);
intEnum(Small, RED);
intEnum(Small, Red);
intEnum(Small, i8);
intEnum(Small, i16);
intEnum(Small, i32);
intEnum(Small, i64);
intEnum(Small, I8);
intEnum(Small, I16);
intEnum(Small, I32);
intEnum(Small, I64);
if !tryErrors then writeln(); else intEnum(Small, sizes.small);
if !tryErrors then writeln(); else intEnum(Small, sizes.big);
if !tryErrors then writeln(); else intEnum(Small, aSize);
if !tryErrors then writeln(); else intEnum(Small, anotherSize);
intEnum(Small, SMALL);
intEnum(Small, BIG);
intEnum(Small, Small);
intEnum(Small, Big);
intEnum(Small, 126);
intEnum(Small, 131072);
writeln();


writeln("intEnum(Big, *) variants");
intEnum(Big, color.red);
intEnum(Big, aColor);
intEnum(Big, RED);
intEnum(Big, Red);
intEnum(Big, i8);
intEnum(Big, i16);
intEnum(Big, i32);
intEnum(Big, i64);
intEnum(Big, I8);
intEnum(Big, I16);
intEnum(Big, I32);
intEnum(Big, I64);
if !tryErrors then writeln(); else intEnum(Big, sizes.small);
if !tryErrors then writeln(); else intEnum(Big, sizes.big);
if !tryErrors then writeln(); else intEnum(Big, aSize);
if !tryErrors then writeln(); else intEnum(Big, anotherSize);
intEnum(Big, SMALL);
intEnum(Big, BIG);
intEnum(Big, Small);
intEnum(Big, Big);
intEnum(Big, 126);
intEnum(Big, 131072);
writeln();

writeln("intEnum(126, *) variants");
intEnum(126, color.red);
intEnum(126, aColor);
intEnum(126, RED);
intEnum(126, Red);
intEnum(126, i8);
intEnum(126, i16);
intEnum(126, i32);
intEnum(126, i64);
intEnum(126, I8);
intEnum(126, I16);
intEnum(126, I32);
intEnum(126, I64);
if !tryErrors then writeln(); else intEnum(126, sizes.small);
if !tryErrors then writeln(); else intEnum(126, sizes.big);
if !tryErrors then writeln(); else intEnum(126, aSize);
if !tryErrors then writeln(); else intEnum(126, anotherSize);
intEnum(126, SMALL);
intEnum(126, BIG);
intEnum(126, Small);
intEnum(126, Big);
intEnum(126, 126);
intEnum(126, 131072);
writeln();

writeln("intEnum(131072, *) variants");
intEnum(131072, color.red);
intEnum(131072, aColor);
intEnum(131072, RED);
intEnum(131072, Red);
intEnum(131072, i8);
intEnum(131072, i16);
intEnum(131072, i32);
intEnum(131072, i64);
intEnum(131072, I8);
intEnum(131072, I16);
intEnum(131072, I32);
intEnum(131072, I64);
if !tryErrors then writeln(); else intEnum(131072, sizes.small);
if !tryErrors then writeln(); else intEnum(131072, sizes.big);
if !tryErrors then writeln(); else intEnum(131072, aSize);
if !tryErrors then writeln(); else intEnum(131072, anotherSize);
intEnum(131072, SMALL);
intEnum(131072, BIG);
intEnum(131072, Small);
intEnum(131072, Big);
intEnum(131072, 126);
intEnum(131072, 131072);
writeln();


writeln();

writeln("allSigs(color.red, *) variants");
allSigs(color.red, color.red);
allSigs(color.red, aColor);
allSigs(color.red, RED);
allSigs(color.red, Red);
allSigs(color.red, i8);
allSigs(color.red, i16);
allSigs(color.red, i32);
allSigs(color.red, i64);
allSigs(color.red, I8);
allSigs(color.red, I16);
allSigs(color.red, I32);
allSigs(color.red, I64);
allSigs(color.red, sizes.small);
allSigs(color.red, sizes.big);
allSigs(color.red, aSize);
allSigs(color.red, anotherSize);
allSigs(color.red, SMALL);
allSigs(color.red, BIG);
allSigs(color.red, Small);
allSigs(color.red, Big);
allSigs(color.red, 126);
allSigs(color.red, 131072);
writeln();

writeln("allSigs(aColor, *) variants");
allSigs(aColor, color.red);
allSigs(aColor, aColor);
allSigs(aColor, RED);
allSigs(aColor, Red);
allSigs(aColor, i8);
allSigs(aColor, i16);
allSigs(aColor, i32);
allSigs(aColor, i64);
allSigs(aColor, I8);
allSigs(aColor, I16);
allSigs(aColor, I32);
allSigs(aColor, I64);
allSigs(aColor, sizes.small);
allSigs(aColor, sizes.big);
allSigs(aColor, aSize);
allSigs(aColor, anotherSize);
allSigs(aColor, SMALL);
allSigs(aColor, BIG);
allSigs(aColor, Small);
allSigs(aColor, Big);
allSigs(aColor, 126);
allSigs(aColor, 131072);
writeln();


writeln("allSigs(RED, *) variants");
allSigs(RED, color.red);
allSigs(RED, aColor);
allSigs(RED, RED);
allSigs(RED, Red);
allSigs(RED, i8);
allSigs(RED, i16);
allSigs(RED, i32);
allSigs(RED, i64);
allSigs(RED, I8);
allSigs(RED, I16);
allSigs(RED, I32);
allSigs(RED, I64);
allSigs(RED, sizes.small);
allSigs(RED, sizes.big);
allSigs(RED, aSize);
allSigs(RED, anotherSize);
allSigs(RED, SMALL);
allSigs(RED, BIG);
allSigs(RED, Small);
allSigs(RED, Big);
allSigs(RED, 126);
allSigs(RED, 131072);
writeln();

writeln("allSigs(Red, *) variants");
allSigs(Red, color.red);
allSigs(Red, aColor);
allSigs(Red, RED);
allSigs(Red, Red);
allSigs(Red, i8);
allSigs(Red, i16);
allSigs(Red, i32);
allSigs(Red, i64);
allSigs(Red, I8);
allSigs(Red, I16);
allSigs(Red, I32);
allSigs(Red, I64);
allSigs(Red, sizes.small);
allSigs(Red, sizes.big);
allSigs(Red, aSize);
allSigs(Red, anotherSize);
allSigs(Red, SMALL);
allSigs(Red, BIG);
allSigs(Red, Small);
allSigs(Red, Big);
allSigs(Red, 126);
allSigs(Red, 131072);
writeln();


writeln("allSigs(i8, *) variants");
allSigs(i8, color.red);
allSigs(i8, aColor);
allSigs(i8, RED);
allSigs(i8, Red);
allSigs(i8, i8);
allSigs(i8, i16);
allSigs(i8, i32);
allSigs(i8, i64);
allSigs(i8, I8);
allSigs(i8, I16);
allSigs(i8, I32);
allSigs(i8, I64);
allSigs(i8, sizes.small);
allSigs(i8, sizes.big);
allSigs(i8, aSize);
allSigs(i8, anotherSize);
allSigs(i8, SMALL);
allSigs(i8, BIG);
allSigs(i8, Small);
allSigs(i8, Big);
allSigs(i8, 126);
allSigs(i8, 131072);
writeln();


writeln("allSigs(i16, *) variants");
allSigs(i16, color.red);
allSigs(i16, aColor);
allSigs(i16, RED);
allSigs(i16, Red);
allSigs(i16, i8);
allSigs(i16, i16);
allSigs(i16, i32);
allSigs(i16, i64);
allSigs(i16, I8);
allSigs(i16, I16);
allSigs(i16, I32);
allSigs(i16, I64);
allSigs(i16, sizes.small);
allSigs(i16, sizes.big);
allSigs(i16, aSize);
allSigs(i16, anotherSize);
allSigs(i16, SMALL);
allSigs(i16, BIG);
allSigs(i16, Small);
allSigs(i16, Big);
allSigs(i16, 126);
allSigs(i16, 131072);
writeln();


writeln("allSigs(i32, *) variants");
allSigs(i32, color.red);
allSigs(i32, aColor);
allSigs(i32, RED);
allSigs(i32, Red);
allSigs(i32, i8);
allSigs(i32, i16);
allSigs(i32, i32);
allSigs(i32, i64);
allSigs(i32, I8);
allSigs(i32, I16);
allSigs(i32, I32);
allSigs(i32, I64);
allSigs(i32, sizes.small);
allSigs(i32, sizes.big);
allSigs(i32, aSize);
allSigs(i32, anotherSize);
allSigs(i32, SMALL);
allSigs(i32, BIG);
allSigs(i32, Small);
allSigs(i32, Big);
allSigs(i32, 126);
allSigs(i32, 131072);
writeln();


writeln("allSigs(i64, *) variants");
allSigs(i64, color.red);
allSigs(i64, aColor);
allSigs(i64, RED);
allSigs(i64, Red);
allSigs(i64, i8);
allSigs(i64, i16);
allSigs(i64, i32);
allSigs(i64, i64);
allSigs(i64, I8);
allSigs(i64, I16);
allSigs(i64, I32);
allSigs(i64, I64);
allSigs(i64, sizes.small);
allSigs(i64, sizes.big);
allSigs(i64, aSize);
allSigs(i64, anotherSize);
allSigs(i64, SMALL);
allSigs(i64, BIG);
allSigs(i64, Small);
allSigs(i64, Big);
allSigs(i64, 126);
allSigs(i64, 131072);
writeln();


writeln("allSigs(I8, *) variants");
allSigs(I8, color.red);
allSigs(I8, aColor);
allSigs(I8, RED);
allSigs(I8, Red);
allSigs(I8, i8);
allSigs(I8, i16);
allSigs(I8, i32);
allSigs(I8, i64);
allSigs(I8, I8);
allSigs(I8, I16);
allSigs(I8, I32);
allSigs(I8, I64);
allSigs(I8, sizes.small);
allSigs(I8, sizes.big);
allSigs(I8, aSize);
allSigs(I8, anotherSize);
allSigs(I8, SMALL);
allSigs(I8, BIG);
allSigs(I8, Small);
allSigs(I8, Big);
allSigs(I8, 126);
allSigs(I8, 131072);
writeln();


writeln("allSigs(I16, *) variants");
allSigs(I16, color.red);
allSigs(I16, aColor);
allSigs(I16, RED);
allSigs(I16, Red);
allSigs(I16, i8);
allSigs(I16, i16);
allSigs(I16, i32);
allSigs(I16, i64);
allSigs(I16, I8);
allSigs(I16, I16);
allSigs(I16, I32);
allSigs(I16, I64);
allSigs(I16, sizes.small);
allSigs(I16, sizes.big);
allSigs(I16, aSize);
allSigs(I16, anotherSize);
allSigs(I16, SMALL);
allSigs(I16, BIG);
allSigs(I16, Small);
allSigs(I16, Big);
allSigs(I16, 126);
allSigs(I16, 131072);
writeln();


writeln("allSigs(I32, *) variants");
allSigs(I32, color.red);
allSigs(I32, aColor);
allSigs(I32, RED);
allSigs(I32, Red);
allSigs(I32, i8);
allSigs(I32, i16);
allSigs(I32, i32);
allSigs(I32, i64);
allSigs(I32, I8);
allSigs(I32, I16);
allSigs(I32, I32);
allSigs(I32, I64);
allSigs(I32, sizes.small);
allSigs(I32, sizes.big);
allSigs(I32, aSize);
allSigs(I32, anotherSize);
allSigs(I32, SMALL);
allSigs(I32, BIG);
allSigs(I32, Small);
allSigs(I32, Big);
allSigs(I32, 126);
allSigs(I32, 131072);
writeln();


writeln("allSigs(I64, *) variants");
allSigs(I64, color.red);
allSigs(I64, aColor);
allSigs(I64, RED);
allSigs(I64, Red);
allSigs(I64, i8);
allSigs(I64, i16);
allSigs(I64, i32);
allSigs(I64, i64);
allSigs(I64, I8);
allSigs(I64, I16);
allSigs(I64, I32);
allSigs(I64, I64);
allSigs(I64, sizes.small);
allSigs(I64, sizes.big);
allSigs(I64, aSize);
allSigs(I64, anotherSize);
allSigs(I64, SMALL);
allSigs(I64, BIG);
allSigs(I64, Small);
allSigs(I64, Big);
allSigs(I64, 126);
allSigs(I64, 131072);
writeln();


writeln("allSigs(sizes.small, *) variants");
allSigs(sizes.small, color.red);
allSigs(sizes.small, aColor);
allSigs(sizes.small, RED);
allSigs(sizes.small, Red);
allSigs(sizes.small, i8);
allSigs(sizes.small, i16);
allSigs(sizes.small, i32);
allSigs(sizes.small, i64);
allSigs(sizes.small, I8);
allSigs(sizes.small, I16);
allSigs(sizes.small, I32);
allSigs(sizes.small, I64);
allSigs(sizes.small, sizes.small);
allSigs(sizes.small, sizes.big);
allSigs(sizes.small, aSize);
allSigs(sizes.small, anotherSize);
allSigs(sizes.small, SMALL);
allSigs(sizes.small, BIG);
allSigs(sizes.small, Small);
allSigs(sizes.small, Big);
allSigs(sizes.small, 126);
allSigs(sizes.small, 131072);
writeln();


writeln("allSigs(sizes.big, *) variants");
allSigs(sizes.big, color.red);
allSigs(sizes.big, aColor);
allSigs(sizes.big, RED);
allSigs(sizes.big, Red);
allSigs(sizes.big, i8);
allSigs(sizes.big, i16);
allSigs(sizes.big, i32);
allSigs(sizes.big, i64);
allSigs(sizes.big, I8);
allSigs(sizes.big, I16);
allSigs(sizes.big, I32);
allSigs(sizes.big, I64);
allSigs(sizes.big, sizes.small);
allSigs(sizes.big, sizes.big);
allSigs(sizes.big, aSize);
allSigs(sizes.big, anotherSize);
allSigs(sizes.big, SMALL);
allSigs(sizes.big, BIG);
allSigs(sizes.big, Small);
allSigs(sizes.big, Big);
allSigs(sizes.big, 126);
allSigs(sizes.big, 131072);
writeln();


writeln("allSigs(aSize, *) variants");
allSigs(aSize, color.red);
allSigs(aSize, aColor);
allSigs(aSize, RED);
allSigs(aSize, Red);
allSigs(aSize, i8);
allSigs(aSize, i16);
allSigs(aSize, i32);
allSigs(aSize, i64);
allSigs(aSize, I8);
allSigs(aSize, I16);
allSigs(aSize, I32);
allSigs(aSize, I64);
allSigs(aSize, sizes.small);
allSigs(aSize, sizes.big);
allSigs(aSize, aSize);
allSigs(aSize, anotherSize);
allSigs(aSize, SMALL);
allSigs(aSize, BIG);
allSigs(aSize, Small);
allSigs(aSize, Big);
allSigs(aSize, 126);
allSigs(aSize, 131072);
writeln();


writeln("allSigs(anotherSize, *) variants");
allSigs(anotherSize, color.red);
allSigs(anotherSize, aColor);
allSigs(anotherSize, RED);
allSigs(anotherSize, Red);
allSigs(anotherSize, i8);
allSigs(anotherSize, i16);
allSigs(anotherSize, i32);
allSigs(anotherSize, i64);
allSigs(anotherSize, I8);
allSigs(anotherSize, I16);
allSigs(anotherSize, I32);
allSigs(anotherSize, I64);
allSigs(anotherSize, sizes.small);
allSigs(anotherSize, sizes.big);
allSigs(anotherSize, aSize);
allSigs(anotherSize, anotherSize);
allSigs(anotherSize, SMALL);
allSigs(anotherSize, BIG);
allSigs(anotherSize, Small);
allSigs(anotherSize, Big);
allSigs(anotherSize, 126);
allSigs(anotherSize, 131072);
writeln();


writeln("allSigs(SMALL, *) variants");
allSigs(SMALL, color.red);
allSigs(SMALL, aColor);
allSigs(SMALL, RED);
allSigs(SMALL, Red);
allSigs(SMALL, i8);
allSigs(SMALL, i16);
allSigs(SMALL, i32);
allSigs(SMALL, i64);
allSigs(SMALL, I8);
allSigs(SMALL, I16);
allSigs(SMALL, I32);
allSigs(SMALL, I64);
allSigs(SMALL, sizes.small);
allSigs(SMALL, sizes.big);
allSigs(SMALL, aSize);
allSigs(SMALL, anotherSize);
allSigs(SMALL, SMALL);
allSigs(SMALL, BIG);
allSigs(SMALL, Small);
allSigs(SMALL, Big);
allSigs(SMALL, 126);
allSigs(SMALL, 131072);
writeln();


writeln("allSigs(BIG, *) variants");
allSigs(BIG, color.red);
allSigs(BIG, aColor);
allSigs(BIG, RED);
allSigs(BIG, Red);
allSigs(BIG, i8);
allSigs(BIG, i16);
allSigs(BIG, i32);
allSigs(BIG, i64);
allSigs(BIG, I8);
allSigs(BIG, I16);
allSigs(BIG, I32);
allSigs(BIG, I64);
allSigs(BIG, sizes.small);
allSigs(BIG, sizes.big);
allSigs(BIG, aSize);
allSigs(BIG, anotherSize);
allSigs(BIG, SMALL);
allSigs(BIG, BIG);
allSigs(BIG, Small);
allSigs(BIG, Big);
allSigs(BIG, 126);
allSigs(BIG, 131072);
writeln();


writeln("allSigs(Small, *) variants");
allSigs(Small, color.red);
allSigs(Small, aColor);
allSigs(Small, RED);
allSigs(Small, Red);
allSigs(Small, i8);
allSigs(Small, i16);
allSigs(Small, i32);
allSigs(Small, i64);
allSigs(Small, I8);
allSigs(Small, I16);
allSigs(Small, I32);
allSigs(Small, I64);
allSigs(Small, sizes.small);
allSigs(Small, sizes.big);
allSigs(Small, aSize);
allSigs(Small, anotherSize);
allSigs(Small, SMALL);
allSigs(Small, BIG);
allSigs(Small, Small);
allSigs(Small, Big);
allSigs(Small, 126);
allSigs(Small, 131072);
writeln();


writeln("allSigs(Big, *) variants");
allSigs(Big, color.red);
allSigs(Big, aColor);
allSigs(Big, RED);
allSigs(Big, Red);
allSigs(Big, i8);
allSigs(Big, i16);
allSigs(Big, i32);
allSigs(Big, i64);
allSigs(Big, I8);
allSigs(Big, I16);
allSigs(Big, I32);
allSigs(Big, I64);
allSigs(Big, sizes.small);
allSigs(Big, sizes.big);
allSigs(Big, aSize);
allSigs(Big, anotherSize);
allSigs(Big, SMALL);
allSigs(Big, BIG);
allSigs(Big, Small);
allSigs(Big, Big);
allSigs(Big, 126);
allSigs(Big, 131072);
writeln();

writeln("allSigs(126, *) variants");
allSigs(126, color.red);
allSigs(126, aColor);
allSigs(126, RED);
allSigs(126, Red);
allSigs(126, i8);
allSigs(126, i16);
allSigs(126, i32);
allSigs(126, i64);
allSigs(126, I8);
allSigs(126, I16);
allSigs(126, I32);
allSigs(126, I64);
allSigs(126, sizes.small);
allSigs(126, sizes.big);
allSigs(126, aSize);
allSigs(126, anotherSize);
allSigs(126, SMALL);
allSigs(126, BIG);
allSigs(126, Small);
allSigs(126, Big);
allSigs(126, 126);
allSigs(126, 131072);
writeln();

writeln("allSigs(131072, *) variants");
allSigs(131072, color.red);
allSigs(131072, aColor);
allSigs(131072, RED);
allSigs(131072, Red);
allSigs(131072, i8);
allSigs(131072, i16);
allSigs(131072, i32);
allSigs(131072, i64);
allSigs(131072, I8);
allSigs(131072, I16);
allSigs(131072, I32);
allSigs(131072, I64);
allSigs(131072, sizes.small);
allSigs(131072, sizes.big);
allSigs(131072, aSize);
allSigs(131072, anotherSize);
allSigs(131072, SMALL);
allSigs(131072, BIG);
allSigs(131072, Small);
allSigs(131072, Big);
allSigs(131072, 126);
allSigs(131072, 131072);
writeln();
