<!--
If you are filing an issue that is not a bug report, please feel free to erase
this template and describe the issue as clearly as possible.
-->


### Summary of Problem
<!--
What behavior did you observe when encountering this issue?
What behavior did you expect to observe?
Is this a blocking issue with no known work-arounds?
-->


### Steps to Reproduce

**Source Code:**

```chapel
// Please provide source code that will reproduce the problem.
// You can insert your code inline if it's not too long.
// Otherwise, you can attach it as a file or provide a URL to it.
// To the extent possible, providing simplified programs demonstrating the
// problem will be appreciated.
// You can also replace this section with "Associated Future Test(s)" below.
```

**Compile command:**
<!-- e.g. `chpl foo.chpl` -->

**Execution command:**
<!-- e.g. `./foo -nl 4`
If an input file is required, include it as well. -->

**Associated Future Test(s):**
<!-- Are there any tests in Chapel's test system that demonstrate this issue?
     e.g. [`test/path/to/foo.chpl`](
           https://github.com/chapel-lang/chapel/blob/master/test/path/to/foo.chpl
          ) #1234 -->

### Configuration Information

- Output of `chpl --version`:
- Output of `$CHPL_HOME/util/printchplenv --anonymize`:
- Back-end compiler and version, e.g. `gcc --version` or `clang --version`:
- (For Cray systems only) Output of `module list`:

