# cgmnlm - a colorful Gemini line mode client

This is a [Gemini](https://gemini.circumlunar.space/) client. Included are:

* A CLI utility (like curl): gmni
* A [line-mode browser](https://en.wikipedia.org/wiki/Line_Mode_Browser): cgmnlm

## Features:

* Page history
* Regex searches
* Bookmarks
* basic Client Certificate support (no autocreation of client certs currently)

## Non-Features:

* no inlining of any link type
* no caching of page content
* no persistent history across sessions

## Modifications compared to upstream

This project is of fork of https://git.sr.ht/~sircmpwn/gmni

It includes the following modifications:

* colored headings & links
* default 4 char indenting
* `s` command to directly search in geminispace (via geminispace.info)
* `l` command to search for backlinks to current URI (via geminispace.info)
* `K` command to remove the bookmark for the current page
* `u` command to navigate 1 path element up
* `e[N]` command to open a link or the current URI in default external program (requires `xdg-open`)
* `t[N]` command to download the content behind a link or the current URI to a temporary file
* `T` command line switch to automatically open files downloaded with `t` command (requires `xdg-open`) 
* `a` command and `A` command line switch to toggle between preformatted text and the associated alt text

### Colors

The actual colors used depend on your terminal palette:

* heading 1: light red
* heading 2: light yellow
* heading 3: light green
* gemini link on same capsule: light cyan
* gemini link to another capsule: dark cyan
* non-gemini link: light magenta
* preformatted text: light gray

Besides this rendering adjustments i'll try to keep track of upstream changes or send patches to upstream.

## Usage

See `gmni(1)`, `cgmnlm(1)`.

## Installation

* ArchLinux and derivates:
  * release: https://aur.archlinux.org/packages/cgmnlm/
  * latest: https://aur.archlinux.org/packages/cgmnlm-git/

## Compiling

```
$ mkdir build && cd build
$ ../configure
$ make
# make install
```

### Dependencies:

* A POSIX-like system and a C11 compiler
* [BearSSL](https://www.bearssl.org/index.html)
* [scdoc](https://sr.ht/~sircmpwn/scdoc/) (optional)
