//
//  Sound+legacyAccessors.m
//  cfxr
//
//  Created by Joachim Bengtsson on 2008-05-17.
//  Copyright 2008 Third Cog Software. All rights reserved.
//

/* Generated by:
 legacyMap = {
 "p_base_freq":       "startFrequency",
 "p_freq_limit":      "minFrequencyCutoff",
 "p_freq_ramp":       "slide",
 "p_freq_dramp":      "deltaSlide",
 "p_duty":            "squareDuty",
 "p_duty_ramp":       "dutySweep",
 "p_vib_strength":    "vibratoDepth",
 "p_vib_speed":       "vibratoSpeed",
 "p_env_attack":      "attackTime",
 "p_env_sustain":     "sustainTime",
 "p_env_decay":       "decayTime",
 "p_env_punch":       "sustainPunch",
 "p_lpf_resonance":   "lowpassFilterResonance",
 "p_lpf_freq":        "lowpassFilterCutoff",
 "p_lpf_ramp":        "lowpassFilterCutoffSweep",
 "p_hpf_freq":        "highpassFilterCutoff",
 "p_hpf_ramp":        "highpassFilterCutoffSweep",
 "p_pha_offset":      "phaserOffset",
 "p_pha_ramp":        "phaserSweep",
 "p_repeat_speed":    "repeatSpeed",
 "p_arp_speed":       "changeSpeed",
 "p_arp_mod":         "changeAmount",
 "sound_vol":		  "volume"
 }
 
 for legacyValue in legacyMap:
 print """-(float)%s;
 {
 return [self.%s floatValue];
 }
 -(void)set%s:(float)a
 {
 self.%s = [NSNumber numberWithFloat:a];
 }
 """%(legacyValue, legacyMap[legacyValue], legacyValue.capitalize(), legacyMap[legacyValue])
 
*/ 

#import "Sound+legacyAccessors.h"

@implementation Sound (LegacyAccessors)

@dynamic attackTime;
@dynamic bitDepth;
@dynamic changeAmount;
@dynamic changeSpeed;
@dynamic decayTime;
@dynamic deltaSlide;
@dynamic dutySweep;
@dynamic highpassFilterCutoff;
@dynamic highpassFilterCutoffSweep;
@dynamic lowpassFilterCutoff;
@dynamic lowpassFilterCutoffSweep;
@dynamic lowpassFilterResonance;
@dynamic minFrequencyCutoff;
@dynamic phaserOffset;
@dynamic phaserSweep;
@dynamic repeatSpeed;
@dynamic sampleRate;
@dynamic slide;
@dynamic squareDuty;
@dynamic startFrequency;
@dynamic sustainPunch;
@dynamic sustainTime;
@dynamic vibratoDepth;
@dynamic vibratoSpeed;
@dynamic volume;
@dynamic waveType;

@dynamic name;
@dynamic index;
@dynamic rating;

-(int)wave_type;
{
	return [self.waveType intValue];
}

-(void)setWave_type:(int)waveType;
{
	self.waveType = [NSNumber numberWithInt:waveType];
}

-(float)sound_vol;
{
	return [self.volume floatValue]/100;
}

-(void)setSound_vol:(float)newVol;
{
	self.volume = [NSNumber numberWithInt:newVol*100.0];
}

-(int)wav_bits;
{
	return [self.bitDepth intValue];
}

-(void)setWav_bits:(int)w;
{
	self.bitDepth = [NSNumber numberWithInt:w];
}

-(int)wav_freq;
{
	return [self.sampleRate intValue];
}

-(void)setWav_freq:(int)w;
{
	self.sampleRate = [NSNumber numberWithInt:w];
}

/// GENERATED:
-(float)p_duty_ramp;
{
  	return [self.dutySweep floatValue];
}
-(void)setP_duty_ramp:(float)a
{
  	self.dutySweep = [NSNumber numberWithFloat:a];
}

-(float)p_duty;
{
  	return [self.squareDuty floatValue];
}
-(void)setP_duty:(float)a
{
  	self.squareDuty = [NSNumber numberWithFloat:a];
}

-(float)p_lpf_resonance;
{
  	return [self.lowpassFilterResonance floatValue];
}
-(void)setP_lpf_resonance:(float)a
{
  	self.lowpassFilterResonance = [NSNumber numberWithFloat:a];
}

-(float)p_hpf_freq;
{
  	return [self.highpassFilterCutoff floatValue];
}
-(void)setP_hpf_freq:(float)a
{
  	self.highpassFilterCutoff = [NSNumber numberWithFloat:a];
}

-(float)p_env_decay;
{
  	return [self.decayTime floatValue];
}
-(void)setP_env_decay:(float)a
{
  	self.decayTime = [NSNumber numberWithFloat:a];
}

-(float)p_pha_ramp;
{
  	return [self.phaserSweep floatValue];
}
-(void)setP_pha_ramp:(float)a
{
  	self.phaserSweep = [NSNumber numberWithFloat:a];
}

-(float)p_arp_speed;
{
  	return [self.changeSpeed floatValue];
}
-(void)setP_arp_speed:(float)a
{
  	self.changeSpeed = [NSNumber numberWithFloat:a];
}

-(float)p_lpf_freq;
{
  	return [self.lowpassFilterCutoff floatValue];
}
-(void)setP_lpf_freq:(float)a
{
  	self.lowpassFilterCutoff = [NSNumber numberWithFloat:a];
}

-(float)p_env_attack;
{
  	return [self.attackTime floatValue];
}
-(void)setP_env_attack:(float)a
{
  	self.attackTime = [NSNumber numberWithFloat:a];
}

-(float)p_env_punch;
{
  	return [self.sustainPunch floatValue];
}
-(void)setP_env_punch:(float)a
{
  	self.sustainPunch = [NSNumber numberWithFloat:a];
}

-(float)p_env_sustain;
{
  	return [self.sustainTime floatValue];
}
-(void)setP_env_sustain:(float)a
{
  	self.sustainTime = [NSNumber numberWithFloat:a];
}

-(float)p_arp_mod;
{
  	return [self.changeAmount floatValue];
}
-(void)setP_arp_mod:(float)a
{
  	self.changeAmount = [NSNumber numberWithFloat:a];
}

-(float)p_hpf_ramp;
{
  	return [self.highpassFilterCutoffSweep floatValue];
}
-(void)setP_hpf_ramp:(float)a
{
  	self.highpassFilterCutoffSweep = [NSNumber numberWithFloat:a];
}

-(float)p_freq_ramp;
{
  	return [self.slide floatValue];
}
-(void)setP_freq_ramp:(float)a
{
  	self.slide = [NSNumber numberWithFloat:a];
}

-(float)p_lpf_ramp;
{
  	return [self.lowpassFilterCutoffSweep floatValue];
}
-(void)setP_lpf_ramp:(float)a
{
  	self.lowpassFilterCutoffSweep = [NSNumber numberWithFloat:a];
}

-(float)p_pha_offset;
{
  	return [self.phaserOffset floatValue];
}
-(void)setP_pha_offset:(float)a
{
  	self.phaserOffset = [NSNumber numberWithFloat:a];
}

-(float)p_repeat_speed;
{
  	return [self.repeatSpeed floatValue];
}
-(void)setP_repeat_speed:(float)a
{
  	self.repeatSpeed = [NSNumber numberWithFloat:a];
}

-(float)p_base_freq;
{
  	return [self.startFrequency floatValue];
}
-(void)setP_base_freq:(float)a
{
  	self.startFrequency = [NSNumber numberWithFloat:a];
}

-(float)p_vib_speed;
{
  	return [self.vibratoSpeed floatValue];
}
-(void)setP_vib_speed:(float)a
{
  	self.vibratoSpeed = [NSNumber numberWithFloat:a];
}

-(float)p_vib_strength;
{
  	return [self.vibratoDepth floatValue];
}
-(void)setP_vib_strength:(float)a
{
  	self.vibratoDepth = [NSNumber numberWithFloat:a];
}

-(float)p_freq_limit;
{
  	return [self.minFrequencyCutoff floatValue];
}
-(void)setP_freq_limit:(float)a
{
  	self.minFrequencyCutoff = [NSNumber numberWithFloat:a];
}

-(float)p_freq_dramp;
{
  	return [self.deltaSlide floatValue];
}
-(void)setP_freq_dramp:(float)a
{
  	self.deltaSlide = [NSNumber numberWithFloat:a];
}

@end
