#ifndef CDO_VARLIST_H
#define CDO_VARLIST_H

#include <string>
#include <vector>
#include <map>

#include <cdi.h>

#include "cdo_varlist.h"
#include "cdo_options.h"

enum class CmpVlist
{
  Name = 1,
  Grid = 2,
  NumLevels = 4,
  GridSize = 8,
  Dim = GridSize | NumLevels | Grid,
  All = Name | Dim
};

inline CmpVlist operator | (CmpVlist lhs, CmpVlist rhs) { return (CmpVlist) (static_cast<int>(lhs) | static_cast<int>(rhs)); }

struct CdoVar
{
  std::string name;
  std::string longname;
  std::string units;
  MemType memType = MemType::Native;
  int gridID = -1;
  int zaxisID = -1;
  int gridType = -1;
  int zaxisType = -1;
  int timetype = -1;
  int tsteptype = -1;
  size_t gridsize = 0;
  int nlevels = 0;
  int datatype = -1;
  double missval = 0;
  int code = 0;
  int param = 0;
  int nwpv = 1;  // number of words per value; real:1  complex:2
  bool isConstant = false;
};

using VarList = std::vector<CdoVar>;
void varList_init(VarList &varList, int vlistID);
void varListSetUniqueMemtype(VarList &varList);
void varListSetMemtype(VarList &varList, MemType memType);
int varList_numConstVars(const VarList &varList);
int varList_numVaryingVars(const VarList &varList);
void varList_map(const VarList &varList1, const VarList &varList2, CmpVlist cmpFlag, int mapFlag, std::map<int, int> &mapOfVarIDs);
int varList_get_psvarid(const VarList &varList, int zaxisID);

void varList_compare(const VarList &varList1, const VarList &varList2, CmpVlist cmpFlag);
void vlist_compare(int vlistID1, int vlistID2, CmpVlist cmpFlag);

struct VarIDs
{
  int sgeopotID = CDI_UNDEFID;
  int geopotID = CDI_UNDEFID;
  int tempID = CDI_UNDEFID;
  int psID = CDI_UNDEFID;
  int lnpsID = CDI_UNDEFID;
  int lnpsID2 = CDI_UNDEFID;
  int gheightID = CDI_UNDEFID;
  int humID = CDI_UNDEFID;
  int clwcID = CDI_UNDEFID;
  int ciwcID = CDI_UNDEFID;
};

VarIDs search_varIDs(const VarList &varList, int vlistID, int numFullLevels);

#endif
