/*
  This file is part of CDO. CDO is a collection of Operators to manipulate and analyse Climate model Data.

  Author: Uwe Schulzweida

*/
#ifndef REMAP_UTILS_H
#define REMAP_UTILS_H

#include "remap.h"

enum
{
  REMAPSCON,
  REMAPCON2,
  REMAPBIL,
  REMAPBIC,
  REMAPDIS,
  REMAPNN,
  REMAPLAF,
  REMAPAVG,
  REMAP,
  REMAPCON,
  REMAPYCON2,

  GENSCON,
  GENCON2,
  GENBIL,
  GENBIC,
  GENDIS,
  GENNN,
  GENLAF,
  GENCON,
  GENYCON2
};

enum
{
  HEAP_SORT,
  MERGE_SORT
};

struct RemapParams
{
  double threshhold = 2.0;
  double fracMin = 0.0;
  int sortMode = HEAP_SORT;
  int maxRemaps = -1;
  int test = 0;
  int extrapolate = -1;
  int numSearchBins = 180;
  bool numSearchBinsIsSet = false;
};

inline bool
remap_func_is_dist(int operfunc)
{
  return (operfunc == REMAPDIS || operfunc == GENDIS || operfunc == REMAPNN || operfunc == GENNN);
}

void remap_print_info(int operfunc, bool remap_genweights, const RemapGrid &srcGrid, const RemapGrid &tgtGrid, size_t nmiss, int numNeighbors);
void remap_print_warning(const std::string &remapWeightsFile, int operfunc, const RemapGrid &srcGrid, size_t nmiss);

RemapParams remap_get_params();
void remap_set_params(const RemapParams &remapParams);

RemapSwitches remap_operfunc_to_maptype(int operfunc);

NormOpt remap_get_normOpt(void);

void remap_linksPerValue(RemapVars &rv);

void remap_gen_weights(int sortMode, const RemapSwitches &remapSwitches, RemapType &remap);

int remap_gen_numbins(int ysize);

std::vector<bool> remap_set_grids(int vlistID, const VarList &varList);

#endif  // REMAP_UTILS_H
