/* Automatically created with makedoc, don't edit! */

static const char *InfoHelp[] = {
    "NAME",
    "    info, infon, map - Information and simple statistics",
    "",
    "SYNOPSIS",
    "    <operator>  ifiles",
    "",
    "DESCRIPTION",
    "    This module writes information about the structure and contents ",
    "    of all input files to standard output.  All input files need to have ",
    "    the same structure with the same variables on different timesteps.",
    "    The information displayed depends on the chosen operator.",
    "",
    "OPERATORS",
    "    info   Dataset information listed by parameter identifier",
    "           Prints information and simple statistics for each field of all",
    "           input datasets. For each field the operator prints one line with ",
    "           the following elements:",
    "           - Date and Time",
    "           - Level, Gridsize and number of Missing values",
    "           - Minimum, Mean and Maximum \\",
    "           The mean value is computed without the use of area weights!",
    "           - Parameter identifier",
    "    infon  Dataset information listed by parameter name",
    "           The same as operator info but using the name instead of the",
    "           identifier to label the parameter.",
    "    map    Dataset information and simple map",
    "           Prints information, simple statistics and a map for each field of all input",
    "           datasets. The map will be printed only for fields on a regular lon/lat grid.",
    NULL
};

static const char *SinfoHelp[] = {
    "NAME",
    "    sinfo, sinfon - Short information",
    "",
    "SYNOPSIS",
    "    <operator>  ifiles",
    "",
    "DESCRIPTION",
    "    This module writes information about the structure of ifiles to standard output.",
    "    ifiles is an arbitrary number of input files. All input files need to have ",
    "    the same structure with the same variables on different timesteps.",
    "    The information displayed depends on the chosen operator.",
    "",
    "OPERATORS",
    "    sinfo   Short information listed by parameter identifier",
    "            Prints short information of a dataset. The information is divided into",
    "            4 sections. Section 1 prints one line per parameter with the following ",
    "            information:",
    "            - institute and source",
    "            - timestep type",
    "            - number of levels and z-axis number",
    "            - horizontal grid size and number",
    "            - data type",
    "            - parameter identifier",
    "            Section 2 and 3 gives a short overview of all grid and vertical coordinates.",
    "            And the last section contains short information of the time coordinate.",
    "    sinfon  Short information listed by parameter name",
    "            The same as operator sinfo but using the name instead of the ",
    "            identifier to label the parameter.",
    NULL
};

static const char *DiffHelp[] = {
    "NAME",
    "    diff, diffn - Compare two datasets field by field",
    "",
    "SYNOPSIS",
    "    <operator>  ifile1 ifile2",
    "",
    "DESCRIPTION",
    "    Compares the contents of two datasets field by field. The input datasets need to have the",
    "    same structure and its fields need to have the same header information and dimensions.",
    "",
    "OPERATORS",
    "    diff   Compare two datasets listed by parameter id",
    "           Provides statistics on differences between two datasets.",
    "           For each pair of fields the operator prints one line with the following information:",
    "           - Date and Time",
    "           - Level, Gridsize and number of Missing values",
    "           - Number of different values",
    "           - Occurrence of coefficient pairs with different signs (S)",
    "           - Occurrence of zero values (Z)",
    "           - Maxima of absolute difference of coefficient pairs",
    "           - Maxima of relative difference of non-zero coefficient pairs with equal signs",
    "           - Parameter identifier",
    "    diffn  Compare two datasets listed by parameter name",
    "           The same as operator diff. Using the name instead of the",
    "           identifier to label the parameter.",
    NULL
};

static const char *NinfoHelp[] = {
    "NAME",
    "    npar, nlevel, nyear, nmon, ndate, ntime - ",
    "    Print the number of parameters, levels or times",
    "",
    "SYNOPSIS",
    "    <operator>  ifile",
    "",
    "DESCRIPTION",
    "    This module prints the number of variables, levels or times of the ",
    "    input dataset.",
    "",
    "OPERATORS",
    "    npar    Number of parameters",
    "            Prints the number of parameters (variables).",
    "    nlevel  Number of levels",
    "            Prints the number of levels for each variable.",
    "    nyear   Number of years",
    "            Prints the number of different years.",
    "    nmon    Number of months",
    "            Prints the number of different combinations of years and months.",
    "    ndate   Number of dates",
    "            Prints the number of different dates.",
    "    ntime   Number of timesteps",
    "            Prints the number of timesteps.",
    NULL
};

static const char *ShowinfoHelp[] = {
    "NAME",
    "    showformat, showcode, showname, showstdname, showlevel, showltype, showyear, ",
    "    showmon, showdate, showtime, showtimestamp - Show variables, levels or times",
    "",
    "SYNOPSIS",
    "    <operator>  ifile",
    "",
    "DESCRIPTION",
    "    This module prints the format, variables, levels or times of the input dataset.",
    "",
    "OPERATORS",
    "    showformat     Show file format",
    "                   Prints the file format of the input dataset.",
    "    showcode       Show code numbers",
    "                   Prints the code number of all variables.",
    "    showname       Show variable names",
    "                   Prints the name of all variables.",
    "    showstdname    Show standard names",
    "                   Prints the standard name of all variables.",
    "    showlevel      Show levels",
    "                   Prints all levels for each variable.",
    "    showltype      Show GRIB level types",
    "                   Prints the GRIB level type for all z-axes.",
    "    showyear       Show years",
    "                   Prints all years.",
    "    showmon        Show months",
    "                   Prints all months.",
    "    showdate       Show date information",
    "                   Prints date information of all timesteps (format YYYY-MM-DD).",
    "    showtime       Show time information",
    "                   Prints time information of all timesteps (format hh:mm:ss).",
    "    showtimestamp  Show timestamp",
    "                   Prints timestamp of all timesteps (format YYYY-MM-DDThh:mm:ss).",
    NULL
};

static const char *FiledesHelp[] = {
    "NAME",
    "    pardes, griddes, zaxisdes, vct - Dataset description",
    "",
    "SYNOPSIS",
    "    <operator>  ifile",
    "",
    "DESCRIPTION",
    "    This module prints the description of the parameters, the grids,",
    "    the z-axis or the vertical coordinate table.",
    "",
    "OPERATORS",
    "    pardes    Parameter description",
    "              Prints a table with a description of all variables.",
    "              For each variable the operator prints one line listing the",
    "              code, name, description and units.",
    "    griddes   Grid description",
    "              Prints the description of all grids.",
    "    zaxisdes  Z-axis description",
    "              Prints the description of all z-axes.",
    "    vct       Vertical coordinate table",
    "              Prints the vertical coordinate table.",
    NULL
};

static const char *CopyHelp[] = {
    "NAME",
    "    copy, cat - Copy datasets",
    "",
    "SYNOPSIS",
    "    <operator>  ifiles ofile",
    "",
    "DESCRIPTION",
    "    This module contains operators to copy or concatenate datasets.",
    "    ifiles is an arbitrary number of input files. All input files need to have ",
    "    the same structure with the same variables on different timesteps.",
    "",
    "OPERATORS",
    "    copy  Copy datasets",
    "          Copies all input datasets to ofile. ",
    "    cat   Concatenate datasets",
    "          Concatenates all input datasets and appends the result to the end ",
    "          of ofile. If ofile does not exist it will be created.",
    NULL
};

static const char *ReplaceHelp[] = {
    "NAME",
    "    replace - Replace variables",
    "",
    "SYNOPSIS",
    "    replace  ifile1 ifile2 ofile",
    "",
    "DESCRIPTION",
    "    The replace operator replaces variables in ifile1 by variables from ifile2 and write",
    "    the result to ofile. Both input datasets need to have the same number of timesteps.",
    NULL
};

static const char *DuplicateHelp[] = {
    "NAME",
    "    duplicate - Duplicates a dataset",
    "",
    "SYNOPSIS",
    "    duplicate[,ndup]  ifile ofile",
    "",
    "DESCRIPTION",
    "    This operator duplicates the contents of ifile and writes the result to ofile.",
    "    The optional parameter sets the number of duplicates, the default is 2.",
    "",
    "PARAMETER",
    "    ndup  INTEGER  Number of duplicates, default is 2.",
    NULL
};

static const char *MergegridHelp[] = {
    "NAME",
    "    mergegrid - Merge grid",
    "",
    "SYNOPSIS",
    "    mergegrid  ifile1 ifile2 ofile",
    "",
    "DESCRIPTION",
    "    Merges grid points of all variables from ifile2 to ifile1 and write the result to ofile.",
    "    Only the non missing values of ifile2 will be used. The horizontal grid of ifile2 should ",
    "    be smaller or equal to the grid of ifile1 and the resolution must be the same.",
    "    Only rectilinear grids are supported. Both input files need to have the same variables ",
    "    and the same number of timesteps.",
    NULL
};

static const char *MergeHelp[] = {
    "NAME",
    "    merge, mergetime - Merge datasets",
    "",
    "SYNOPSIS",
    "    <operator>  ifiles ofile",
    "",
    "DESCRIPTION",
    "    This module reads datasets from several input files, merges them and writes the resulting dataset to ofile.",
    "",
    "OPERATORS",
    "    merge      Merge datasets with different fields",
    "               Merges time series of different fields from several input datasets. The number ",
    "               of fields per timestep written to ofile is the sum of the field numbers ",
    "               per timestep in all input datasets. The time series on all input datasets are ",
    "               required to have different fields and the same number of timesteps.",
    "               The fields in each different input file either have to be different variables",
    "               or different levels of the same variable. A mixture of different variables on",
    "               different levels in different input files is not allowed.",
    "    mergetime  Merge datasets sorted by date and time",
    "               Merges all timesteps of all input files sorted by date and time.",
    "               All input files need to have the same structure with the same variables on ",
    "               different timesteps. After this operation every input timestep is in ofile ",
    "               and all timesteps are sorted by date and time.",
    "",
    "ENVIRONMENT",
    "    SKIP_SAME_TIME",
    "        If set to 1, skips all consecutive timesteps with a double entry of the same timestamp.",
    NULL
};

static const char *SplitHelp[] = {
    "NAME",
    "    splitcode, splitparam, splitname, splitlevel, splitgrid, splitzaxis, ",
    "    splittabnum - Split a dataset",
    "",
    "SYNOPSIS",
    "    <operator>[,params]  ifile obase",
    "",
    "DESCRIPTION",
    "    This module splits ifile into pieces. The output files will be named <obase><xxx><suffix>",
    "    where suffix is the filename extension derived from the file format. xxx and the contents ",
    "    of the output files depends on the chosen operator. ",
    "    params is a comma separated list of processing parameters.",
    "",
    "OPERATORS",
    "    splitcode    Split code numbers",
    "                 Splits a dataset into pieces, one for each different code number.",
    "                 xxx will have three digits with the code number.",
    "    splitparam   Split parameter identifiers",
    "                 Splits a dataset into pieces, one for each different parameter identifier.",
    "                 xxx will be a string with the parameter identifier.",
    "    splitname    Split variable names",
    "                 Splits a dataset into pieces, one for each variable name.",
    "                 xxx will be a string with the variable name.",
    "    splitlevel   Split levels",
    "                 Splits a dataset into pieces, one for each different level.",
    "                 xxx will have six digits with the level.",
    "    splitgrid    Split grids",
    "                 Splits a dataset into pieces, one for each different grid.",
    "                 xxx will have two digits with the grid number.",
    "    splitzaxis   Split z-axes",
    "                 Splits a dataset into pieces, one for each different z-axis.",
    "                 xxx will have two digits with the z-axis number.",
    "    splittabnum  Split parameter table numbers",
    "                 Splits a dataset into pieces, one for each GRIB1 parameter table number.",
    "                 xxx will have three digits with the GRIB1 parameter table number.",
    "",
    "PARAMETER",
    "    swap            STRING  Swap the position of obase and xxx in the output filename",
    "    uuid=<attname>  STRING  Add a UUID as global attribute <attname> to each output file",
    "",
    "ENVIRONMENT",
    "    CDO_FILE_SUFFIX",
    "        Set the default file suffix. This suffix will be added to the output file ",
    "        names instead of the filename extension derived from the file format. ",
    "        Set this variable to NULL to disable the adding of a file suffix.",
    NULL
};

static const char *SplittimeHelp[] = {
    "NAME",
    "    splithour, splitday, splitseas, splityear, splityearmon, splitmon - ",
    "    Split timesteps of a dataset",
    "",
    "SYNOPSIS",
    "    <operator>  ifile obase",
    "    splitmon[,format]  ifile obase",
    "",
    "DESCRIPTION",
    "    This module splits ifile into  timesteps pieces. The output files will be named",
    "    <obase><xxx><suffix> where suffix is the filename extension derived from the file format. ",
    "    xxx and the contents of the output files depends on the chosen operator. ",
    "",
    "OPERATORS",
    "    splithour     Split hours",
    "                  Splits a file into pieces, one for each different hour.",
    "                  xxx will have two digits with the hour.",
    "    splitday      Split days",
    "                  Splits a file into pieces, one for each different day.",
    "                  xxx will have two digits with the day.",
    "    splitseas     Split seasons",
    "                  Splits a file into pieces, one for each different season.",
    "                  xxx will have three characters with the season.",
    "    splityear     Split years",
    "                  Splits a file into pieces, one for each different year.",
    "                  xxx will have four digits with the year (YYYY).",
    "    splityearmon  Split in years and months",
    "                  Splits a file into pieces, one for each different year and month.",
    "                  xxx will have six digits with the year and month (YYYYMM).",
    "    splitmon      Split months",
    "                  Splits a file into pieces, one for each different month.",
    "                  xxx will have two digits with the month.",
    "",
    "PARAMETER",
    "    format  STRING  C-style format for strftime() (e.g. %B for the full month name)",
    "",
    "ENVIRONMENT",
    "    CDO_FILE_SUFFIX",
    "        Set the default file suffix. This suffix will be added to the output file ",
    "        names instead of the filename extension derived from the file format. ",
    "        Set this variable to NULL to disable the adding of a file suffix.",
    NULL
};

static const char *SplitselHelp[] = {
    "NAME",
    "    splitsel - Split selected timesteps",
    "",
    "SYNOPSIS",
    "    splitsel,nsets[,noffset[,nskip]]  ifile obase",
    "",
    "DESCRIPTION",
    "    This operator splits ifile into pieces, one for each adjacent",
    "    sequence t_1, ...., t_n of timesteps of the same selected time range.",
    "    The output files will be named <obase><nnnnnn><suffix> where nnnnnn is the ",
    "    sequence number and suffix is the filename extension derived from the file format.",
    "",
    "PARAMETER",
    "    nsets    INTEGER  Number of input timesteps for each output file",
    "    noffset  INTEGER  Number of input timesteps skipped before the first timestep range (optional)",
    "    nskip    INTEGER  Number of input timesteps skipped between timestep ranges (optional)",
    "",
    "ENVIRONMENT",
    "    CDO_FILE_SUFFIX",
    "        Set the default file suffix. This suffix will be added to the output file ",
    "        names instead of the filename extension derived from the file format. ",
    "        Set this variable to NULL to disable the adding of a file suffix.",
    NULL
};

static const char *DistgridHelp[] = {
    "NAME",
    "    distgrid - Distribute horizontal grid",
    "",
    "SYNOPSIS",
    "    distgrid,nx[,ny]  ifile obase",
    "",
    "DESCRIPTION",
    "    This operator distributes a dataset into smaller pieces. Each output file contains a different region of the horizontal ",
    "    source grid. A target grid region contains a structured longitude/latitude box of the source grid. Only rectilinear and",
    "    curvilinear source grids are supported by this operator.",
    "    The number of different regions can be specified with the parameter nx and ny. The output files will be named ",
    "    <obase><xxx><suffix> where suffix is the filename extension derived from the file format. xxx will have five digits with ",
    "    the number of the target region.",
    "",
    "PARAMETER",
    "    nx  INTEGER  Number of regions in x direction",
    "    ny  INTEGER  Number of regions in y direction [default: 1]",
    "",
    "NOTE",
    "    This operator needs to open all output files simultaneously.",
    "    The maximum number of open files depends on the operating system!",
    NULL
};

static const char *CollgridHelp[] = {
    "NAME",
    "    collgrid - Collect horizontal grid",
    "",
    "SYNOPSIS",
    "    collgrid[,nx[,names]]  ifiles ofile",
    "",
    "DESCRIPTION",
    "    This operator collects the data of the input files to one output file. ",
    "    All input files need to have the same variables and the same number of timesteps on a different",
    "    horizonal grid region. A source region must be a structured longitude/latitude grid box.",
    "    The parameter nx needs to be specified only non regular lon/lat grids.",
    "",
    "PARAMETER",
    "    nx     INTEGER  Number of regions in x direction [default: number of input files]",
    "    names  STRING   Comma separated list of variable names [default: all variables]",
    "",
    "NOTE",
    "    This operator needs to open all input files simultaneously.",
    "    The maximum number of open files depends on the operating system!",
    NULL
};

static const char *SelectHelp[] = {
    "NAME",
    "    select, delete - Select fields",
    "",
    "SYNOPSIS",
    "    <operator>,params  ifiles ofile",
    "",
    "DESCRIPTION",
    "    This module selects some fields from ifiles and writes them to ofile.",
    "    ifiles is an arbitrary number of input files. All input files need to have ",
    "    the same structure with the same variables on different timesteps.",
    "    The fields selected depends on the chosen parameters. Parameter is a comma",
    "    separated list of key-value pairs. Wildcards can be used for string parameter.",
    "",
    "OPERATORS",
    "    select  Select fields",
    "            Selects all fields with parameters in a user given list.",
    "    delete  Delete fields",
    "            Deletes all fields with parameters in a user given list.",
    "",
    "PARAMETER",
    "    name              STRING  Comma separated list of variable names.",
    "    param             STRING  Comma separated list of parameter identifiers.",
    "    code              INTEGER Comma separated list of code numbers.",
    "    level             FLOAT   Comma separated list of vertical levels.",
    "    levidx            INTEGER Comma separated list of index of levels.",
    "    zaxisname         STRING  Comma separated list of zaxis names.",
    "    zaxisnum          INTEGER Comma separated list of zaxis numbers.",
    "    ltype             INTEGER Comma separated list of GRIB level types.",
    "    gridname          STRING  Comma separated list of grid names.",
    "    gridnum           INTEGER Comma separated list of grid numbers.",
    "    steptype          STRING  Comma separated list of timestep types.",
    "    date              STRING  Comma separated list of dates (format YYYY-MM-DDThh:mm:ss).",
    "    startdate         STRING  Start date (format YYYY-MM-DDThh:mm:ss).",
    "    enddate           STRING  End date (format YYYY-MM-DDThh:mm:ss).",
    "    minute            INTEGER Comma separated list of minutes.",
    "    hour              INTEGER Comma separated list of hours.",
    "    day               INTEGER Comma separated list of days.",
    "    month             INTEGER Comma separated list of months.",
    "    season            STRING  Comma separated list of seasons (substring of DJFMAMJJASOND or ANN).",
    "    year              INTEGER Comma separated list of years.",
    "    timestep          INTEGER Comma separated list of timesteps. Negative values selects timesteps from the end (NetCDF only).",
    "    timestep_of_year  INTEGER Comma separated list of timesteps of year.",
    NULL
};

static const char *SelvarHelp[] = {
    "NAME",
    "    selparam, delparam, selcode, delcode, selname, delname, selstdname, sellevel, ",
    "    sellevidx, selgrid, selzaxis, selzaxisname, selltype, seltabnum - Select fields",
    "",
    "SYNOPSIS",
    "    <operator>,params  ifile ofile",
    "    selcode,codes  ifile ofile",
    "    delcode,codes  ifile ofile",
    "    selname,names  ifile ofile",
    "    delname,names  ifile ofile",
    "    selstdname,stdnames  ifile ofile",
    "    sellevel,levels  ifile ofile",
    "    sellevidx,levidx  ifile ofile",
    "    selgrid,grids  ifile ofile",
    "    selzaxis,zaxes  ifile ofile",
    "    selzaxisname,zaxisnames  ifile ofile",
    "    selltype,ltypes  ifile ofile",
    "    seltabnum,tabnums  ifile ofile",
    "",
    "DESCRIPTION",
    "    This module selects some fields from ifile and writes them to ofile.",
    "    The fields selected depends on the chosen operator and the parameters.",
    "",
    "OPERATORS",
    "    selparam      Select parameters by identifier",
    "                  Selects all fields with parameter identifiers in a user given list.",
    "    delparam      Delete parameters by identifier",
    "                  Deletes all fields with parameter identifiers in a user given list.",
    "    selcode       Select parameters by code number",
    "                  Selects all fields with code numbers in a user given list.",
    "    delcode       Delete parameters by code number",
    "                  Deletes all fields with code numbers in a user given list.",
    "    selname       Select parameters by name",
    "                  Selects all fields with parameter names in a user given list.",
    "    delname       Delete parameters by name",
    "                  Deletes all fields with parameter names in a user given list.",
    "    selstdname    Select parameters by standard name",
    "                  Selects all fields with standard names in a user given list.",
    "    sellevel      Select levels",
    "                  Selects all fields with levels in a user given list.",
    "    sellevidx     Select levels by index",
    "                  Selects all fields with index of levels in a user given list.",
    "    selgrid       Select grids",
    "                  Selects all fields with grids in a user given list.",
    "    selzaxis      Select z-axes",
    "                  Selects all fields with z-axes in a user given list.",
    "    selzaxisname  Select z-axes by name",
    "                  Selects all fields with z-axis names in a user given list.",
    "    selltype      Select GRIB level types",
    "                  Selects all fields with GRIB level type in a user given list.",
    "    seltabnum     Select parameter table numbers",
    "                  Selects all fields with parameter table numbers in a user given list.",
    "",
    "PARAMETER",
    "    params      INTEGER  Comma separated list of parameter identifiers",
    "    codes       INTEGER  Comma separated list of code numbers",
    "    names       STRING   Comma separated list of variable names",
    "    stdnames    STRING   Comma separated list of standard names",
    "    levels      FLOAT    Comma separated list of vertical levels",
    "    levidx      INTEGER  Comma separated list of index of levels",
    "    ltypes      INTEGER  Comma separated list of GRIB level types",
    "    grids       STRING   Comma separated list of grid names or numbers",
    "    zaxes       STRING   Comma separated list of z-axis types or numbers",
    "    zaxisnames  STRING   Comma separated list of z-axis names",
    "    tabnums     INTEGER  Comma separated list of parameter table numbers",
    NULL
};

static const char *SeltimeHelp[] = {
    "NAME",
    "    seltimestep, seltime, selhour, selday, selmonth, selyear, selseason, seldate, ",
    "    selsmon - Select timesteps",
    "",
    "SYNOPSIS",
    "    seltimestep,timesteps  ifile ofile",
    "    seltime,times  ifile ofile",
    "    selhour,hours  ifile ofile",
    "    selday,days  ifile ofile",
    "    selmonth,months  ifile ofile",
    "    selyear,years  ifile ofile",
    "    selseason,seasons  ifile ofile",
    "    seldate,date1[,date2]  ifile ofile",
    "    selsmon,month[,nts1[,nts2]]  ifile ofile",
    "",
    "DESCRIPTION",
    "    This module selects user specified timesteps from ifile and writes them to ofile.",
    "    The timesteps selected depends on the chosen operator and the parameters.",
    "",
    "OPERATORS",
    "    seltimestep  Select timesteps",
    "                 Selects all timesteps with a timestep in a user given list.",
    "    seltime      Select times",
    "                 Selects all timesteps with a time in a user given list.",
    "    selhour      Select hours",
    "                 Selects all timesteps with a hour in a user given list.",
    "    selday       Select days",
    "                 Selects all timesteps with a day in a user given list.",
    "    selmonth     Select months",
    "                 Selects all timesteps with a month in a user given list.",
    "    selyear      Select years",
    "                 Selects all timesteps with a year in a user given list.",
    "    selseason    Select seasons",
    "                 Selects all timesteps with a month of a season in a user given list.",
    "    seldate      Select dates",
    "                 Selects all timesteps with a date in a user given range.",
    "    selsmon      Select single month",
    "                 Selects a month and optional an arbitrary number of timesteps before and after this month.",
    "",
    "PARAMETER",
    "    timesteps  INTEGER  Comma separated list of timesteps. Negative values selects timesteps from the end (NetCDF only).",
    "    times      STRING   Comma separated list of times (format hh:mm:ss).",
    "    hours      INTEGER  Comma separated list of hours.",
    "    days       INTEGER  Comma separated list of days.",
    "    months     INTEGER  Comma separated list of months.",
    "    years      INTEGER  Comma separated list of years.",
    "    seasons    STRING   Comma separated list of seasons (substring of DJFMAMJJASOND or ANN).",
    "    date1      STRING   Start date (format YYYY-MM-DDThh:mm:ss).",
    "    date2      STRING   End date (format YYYY-MM-DDThh:mm:ss) [default: date1].",
    "    nts1       INTEGER  Number of timesteps before the selected month [default: 0].",
    "    nts2       INTEGER  Number of timesteps after the selected month [default: nts1].",
    NULL
};

static const char *SelboxHelp[] = {
    "NAME",
    "    sellonlatbox, selindexbox - Select a box of a field",
    "",
    "SYNOPSIS",
    "    sellonlatbox,lon1,lon2,lat1,lat2  ifile ofile",
    "    selindexbox,idx1,idx2,idy1,idy2  ifile ofile",
    "",
    "DESCRIPTION",
    "    Selects a box of the rectangularly understood field. All input fields need to have the same horizontal grid.",
    "",
    "OPERATORS",
    "    sellonlatbox  Select a longitude/latitude box",
    "                  Selects a regular longitude/latitude box. The user has to give the longitudes and latitudes of the ",
    "                  edges of the box. Considered are only those grid cells with the grid center inside the lon/lat box.",
    "                  For rotated lon/lat grids the parameter needs to be rotated coordinates.",
    "    selindexbox   Select an index box",
    "                  Selects an index box. The user has to give the indexes of the edges of the box. The index of the ",
    "                  left edge may be greater then that of the right edge.",
    "",
    "PARAMETER",
    "    lon1  FLOAT    Western longitude",
    "    lon2  FLOAT    Eastern longitude",
    "    lat1  FLOAT    Southern or northern latitude",
    "    lat2  FLOAT    Northern or southern latitude",
    "    idx1  INTEGER  Index of first longitude",
    "    idx2  INTEGER  Index of last longitude",
    "    idy1  INTEGER  Index of first latitude",
    "    idy2  INTEGER  Index of last latitude",
    NULL
};

static const char *CondHelp[] = {
    "NAME",
    "    ifthen, ifnotthen - Conditional select one field",
    "",
    "SYNOPSIS",
    "    <operator>  ifile1 ifile2 ofile",
    "",
    "DESCRIPTION",
    "    This module selects field elements from ifile2 with respect to ifile1 and writes them ",
    "    to ofile. The fields in ifile1 are handled as a mask. A value ",
    "    not equal to zero is treated as \"true\", zero is treated as \"false\".",
    "    The number of fields in ifile1 has either to be the same as in ifile2 or the",
    "    same as in one timestep of ifile2 or only one.",
    "    The fields in ofile inherit the meta data from ifile2.",
    "",
    "OPERATORS",
    "    ifthen     If then",
    "                        / i_2(t,x) if i_1([t,]x) NE 0  AND  i_1([t,]x) NE miss",
    "               o(t,x) =",
    "                        \\ miss     if i_1([t,]x) EQ 0  OR   i_1([t,]x) EQ miss",
    "    ifnotthen  If not then",
    "                        / i_2(t,x) if i_1([t,]x) EQ 0  AND  i_1([t,]x) NE miss",
    "               o(t,x) = ",
    "                        \\ miss     if i_1([t,]x) NE 0  OR   i_1([t,]x) EQ miss",
    NULL
};

static const char *Cond2Help[] = {
    "NAME",
    "    ifthenelse - Conditional select  two fields",
    "",
    "SYNOPSIS",
    "    ifthenelse  ifile1 ifile2 ifile3 ofile",
    "",
    "DESCRIPTION",
    "    This operator selects field elements from ifile2 or ifile3 with respect to",
    "    ifile1 and writes them to ofile. The fields in ifile1 are handled as a mask.",
    "    A value not equal to zero is treated as \"true\", zero is treated as \"false\".",
    "    The number of fields in ifile1 has either to be the same as in ifile2 or the ",
    "    same as in one timestep of ifile2 or only one.",
    "    ifile2 and ifile3 need to have the same number of fields.",
    "    The fields in ofile inherit the meta data from ifile2.",
    "    ",
    "              / i_2(t,x) if i_1([t,]x) NE 0  AND  i_1([t,]x) NE miss",
    "    o(t,x) = <  i_3(t,x) if i_1([t,]x) EQ 0  AND  i_1([t,]x) NE miss",
    "              \\ miss     if i_1([t,]x) EQ miss",
    NULL
};

static const char *CondcHelp[] = {
    "NAME",
    "    ifthenc, ifnotthenc - Conditional select a constant",
    "",
    "SYNOPSIS",
    "    <operator>,c  ifile ofile",
    "",
    "DESCRIPTION",
    "    This module creates fields with a constant value or missing value.",
    "    The fields in ifile are handled as a mask. A value not equal ",
    "    to zero is treated as \"true\", zero is treated as \"false\".",
    "",
    "OPERATORS",
    "    ifthenc     If then constant",
    "                         / c      if i(t,x) NE 0  AND  i(t,x) NE miss",
    "                o(t,x) =",
    "                         \\ miss   if i(t,x) EQ 0  OR   i(t,x) EQ miss",
    "    ifnotthenc  If not then constant",
    "                         / c      if i(t,x) EQ 0  AND  i(t,x) NE miss",
    "                o(t,x) =",
    "                         \\ miss   if i(t,x) NE 0  OR   i(t,x) EQ miss",
    "",
    "PARAMETER",
    "    c  FLOAT  Constant",
    NULL
};

static const char *CompHelp[] = {
    "NAME",
    "    eq, ne, le, lt, ge, gt - Comparison of two fields",
    "",
    "SYNOPSIS",
    "    <operator>  ifile1 ifile2 ofile",
    "",
    "DESCRIPTION",
    "    This module compares two datasets field by field. The resulting",
    "    field is a mask containing 1 if the comparison is true and 0 if not. ",
    "    The number of fields in ifile1 should be the same as in ifile2.",
    "    One of the input files can contain only one timestep or one field.",
    "    The fields in ofile inherit the meta data from ifile1 or ifile2.",
    "    The type of comparison depends on the chosen operator.",
    "",
    "OPERATORS",
    "    eq  Equal",
    "                  /   1   if i_1(t,x) EQ i_2(t,x)  AND  i_1(t,x),i_2(t,x) NE miss",
    "        o(t,x) = <    0   if i_1(t,x) NE i_2(t,x)  AND  i_1(t,x),i_2(t,x) NE miss",
    "                  \\  miss if i_1(t,x) EQ miss      OR   i_2(t,x) EQ miss",
    "    ne  Not equal",
    "                  /   1   if i_1(t,x) NE i_2(t,x)  AND  i_1(t,x),i_2(t,x) NE miss",
    "        o(t,x) = <    0   if i_1(t,x) EQ i_2(t,x)  AND  i_1(t,x),i_2(t,x) NE miss",
    "                  \\  miss if i_1(t,x) EQ miss      OR   i_2(t,x) EQ miss",
    "    le  Less equal",
    "                  /   1   if i_1(t,x) LE i_2(t,x)  AND  i_1(t,x),i_2(t,x) NE miss",
    "        o(t,x) = <    0   if i_1(t,x) GT i_2(t,x)  AND  i_1(t,x),i_2(t,x) NE miss",
    "                  \\  miss if i_1(t,x) EQ miss      OR   i_2(t,x) EQ miss",
    "    lt  Less than",
    "                  /   1   if i_1(t,x) LT i_2(t,x)  AND  i_1(t,x),i_2(t,x) NE miss",
    "        o(t,x) = <    0   if i_1(t,x) GE i_2(t,x)  AND  i_1(t,x),i_2(t,x) NE miss",
    "                  \\  miss if i_1(t,x) EQ miss      OR   i_2(t,x) EQ miss",
    "    ge  Greater equal",
    "                  /   1   if i_1(t,x) GE i_2(t,x)  AND  i_1(t,x),i_2(t,x) NE miss",
    "        o(t,x) = <    0   if i_1(t,x) LT i_2(t,x)  AND  i_1(t,x),i_2(t,x) NE miss",
    "                  \\  miss if i_1(t,x) EQ miss      OR   i_2(t,x) EQ miss",
    "    gt  Greater than",
    "                  /   1   if i_1(t,x) GT i_2(t,x)  AND  i_1(t,x),i_2(t,x) NE miss",
    "        o(t,x) = <    0   if i_1(t,x) LE i_2(t,x)  AND  i_1(t,x),i_2(t,x) NE miss",
    "                  \\  miss if i_1(t,x) EQ miss      OR   i_2(t,x) EQ miss",
    NULL
};

static const char *CompcHelp[] = {
    "NAME",
    "    eqc, nec, lec, ltc, gec, gtc - Comparison of a field with a constant",
    "",
    "SYNOPSIS",
    "    <operator>,c  ifile ofile",
    "",
    "DESCRIPTION",
    "    This module compares all fields of a dataset with a constant. The resulting",
    "    field is a mask containing 1 if the comparison is true and 0 if not.",
    "    The type of comparison depends on the chosen operator.",
    "",
    "OPERATORS",
    "    eqc  Equal constant",
    "                   /   1   if i(t,x) EQ c     AND  i(t,x),c NE miss",
    "         o(t,x) = <    0   if i(t,x) NE c     AND  i(t,x),c NE miss",
    "                   \\  miss if i(t,x) EQ miss  OR   c EQ miss",
    "    nec  Not equal constant",
    "                   /   1   if i(t,x) NE c     AND  i(t,x),c NE miss",
    "         o(t,x) = <    0   if i(t,x) EQ c     AND  i(t,x),c NE miss",
    "                   \\  miss if i(t,x) EQ miss  OR   c EQ miss",
    "    lec  Less equal constant",
    "                   /   1   if i(t,x) LE c     AND  i(t,x),c NE miss",
    "         o(t,x) = <    0   if i(t,x) GT c     AND  i(t,x),c NE miss",
    "                   \\  miss if i(t,x) EQ miss  OR   c EQ miss",
    "    ltc  Less than constant",
    "                   /   1   if i(t,x) LT c     AND  i(t,x),c NE miss",
    "         o(t,x) = <    0   if i(t,x) GE c     AND  i(t,x),c NE miss",
    "                   \\  miss if i(t,x) EQ miss  OR   c EQ miss",
    "    gec  Greater equal constant",
    "                   /   1   if i(t,x) GE c     AND  i(t,x),c NE miss",
    "         o(t,x) = <    0   if i(t,x) LT c     AND  i(t,x),c NE miss",
    "                   \\  miss if i(t,x) EQ miss  OR   c EQ miss",
    "    gtc  Greater than constant",
    "                   /   1   if i(t,x) GT c     AND  i(t,x),c NE miss",
    "         o(t,x) = <    0   if i(t,x) LE c     AND  i(t,x),c NE miss",
    "                   \\  miss if i(t,x) EQ miss  OR   c EQ miss",
    "",
    "PARAMETER",
    "    c  FLOAT  Constant",
    NULL
};

static const char *SetpartabHelp[] = {
    "NAME",
    "    setpartabp, setpartabn - Set parameter table",
    "",
    "SYNOPSIS",
    "    <operator>,table[,convert]  ifile ofile",
    "",
    "DESCRIPTION",
    "    This module transforms data and metadata of ifile via a parameter table and writes the result to ofile.",
    "    A parameter table is an ASCII formatted file with a set of parameter entries for each variable. Each new set have to",
    "    start with \"\\&parameter\" and to end with \"/\".",
    "    ",
    "    The following parameter table entries are supported:",
    "    ",
    "     Entry           & Type        & Description      ",
    "     name            & WORD        & Name of the variable",
    "     out_name        & WORD        & New name of the variable",
    "     param           & WORD        & Parameter identifier (GRIB1: code[.tabnum];  GRIB2: num[.cat[.dis]])",
    "     out_param       & WORD        & New parameter identifier",
    "     type            & WORD        & Data type (real or double)",
    "     standard_name   & WORD        & As defined in the CF standard name table",
    "     long_name       & STRING      & Describing the variable",
    "     units           & STRING      & Specifying the units for the variable",
    "     comment         & STRING      & Information concerning the variable",
    "     cell_methods    & STRING      & Information concerning calculation of means or climatologies",
    "     cell_measures   & STRING      & Indicates the names of the variables containing cell areas and volumes",
    "     missing_value   & FLOAT       & Specifying how missing data will be identified",
    "     valid_min       & FLOAT       & Minimum valid value",
    "     valid_max       & FLOAT       & Maximum valid value",
    "     ok_min_mean_abs & FLOAT       & Minimum absolute mean",
    "     ok_max_mean_abs & FLOAT       & Maximum absolute mean",
    "     factor          & FLOAT       & Scale factor",
    "     delete          & INTEGER     & Set to 1 to delete variable",
    "     convert         & INTEGER     & Set to 1 to convert the unit if necessary",
    "    ",
    "    The search key for the variable depends on the operator. Use setpartabn to search variables by the name.",
    "    This is typically used for NetCDF datasets. The operator setpartabp searches variables by the parameter ID.",
    "",
    "OPERATORS",
    "    setpartabp  Set parameter table",
    "                Search variables by the parameter identifier.",
    "    setpartabn  Set parameter table",
    "                Search variables by name.",
    "",
    "PARAMETER",
    "    table    STRING   Parameter table file or name",
    "    convert  STRING   Converts the units if necessary",
    NULL
};

static const char *SetHelp[] = {
    "NAME",
    "    setpartab, setcode, setparam, setname, setunit, setlevel, setltype - ",
    "    Set field info",
    "",
    "SYNOPSIS",
    "    setpartab,table  ifile ofile",
    "    setcode,code  ifile ofile",
    "    setparam,param  ifile ofile",
    "    setname,name  ifile ofile",
    "    setunit,unit  ifile ofile",
    "    setlevel,level  ifile ofile",
    "    setltype,ltype  ifile ofile",
    "",
    "DESCRIPTION",
    "    This module sets some field information. Depending on the chosen operator the ",
    "    parameter table, code number, parameter identifier, variable name or level is set.",
    "",
    "OPERATORS",
    "    setpartab  Set parameter table",
    "               Sets the parameter table for all variables.",
    "    setcode    Set code number",
    "               Sets the code number for all variables to the same given value.",
    "    setparam   Set parameter identifier",
    "               Sets the parameter identifier of the first variable.",
    "    setname    Set variable name",
    "               Sets the name of the first variable.",
    "    setunit    Set variable unit",
    "               Sets the unit of the first variable.",
    "    setlevel   Set level",
    "               Sets the first level of all variables.",
    "    setltype   Set GRIB level type",
    "               Sets the GRIB level type of all variables.",
    "",
    "PARAMETER",
    "    table  STRING   Parameter table file or name",
    "    code   INTEGER  Code number",
    "    param  STRING   Parameter identifier (GRIB1: code[.tabnum]; GRIB2: num[.cat[.dis]])",
    "    name   STRING   Variable name",
    "    level  FLOAT    New level",
    "    ltype  INTEGER  GRIB level type",
    NULL
};

static const char *SettimeHelp[] = {
    "NAME",
    "    setdate, settime, setday, setmon, setyear, settunits, settaxis, setreftime, ",
    "    setcalendar, shifttime - Set time",
    "",
    "SYNOPSIS",
    "    setdate,date  ifile ofile",
    "    settime,time  ifile ofile",
    "    setday,day  ifile ofile",
    "    setmon,month  ifile ofile",
    "    setyear,year  ifile ofile",
    "    settunits,units  ifile ofile",
    "    settaxis,date,time[,inc]  ifile ofile",
    "    setreftime,date,time[,units]  ifile ofile",
    "    setcalendar,calendar  ifile ofile",
    "    shifttime,sval  ifile ofile",
    "",
    "DESCRIPTION",
    "    This module sets the time axis or part of the time axis. Which part of the",
    "    time axis is overwritten depends on the chosen operator.",
    "",
    "OPERATORS",
    "    setdate      Set date",
    "                 Sets the date in every timestep to the same given value.",
    "    settime      Set time of the day",
    "                 Sets the time in every timestep to the same given value.",
    "    setday       Set day",
    "                 Sets the day in every timestep to the same given value.",
    "    setmon       Set month",
    "                 Sets the month in every timestep to the same given value.",
    "    setyear      Set year",
    "                 Sets the year in every timestep to the same given value.",
    "    settunits    Set time units",
    "                 Sets the base units of a relative time axis.",
    "    settaxis     Set time axis",
    "                 Sets the time axis.",
    "    setreftime   Set reference time",
    "                 Sets the reference time of a relative time axis.",
    "    setcalendar  Set calendar",
    "                 Sets the calendar of a relative time axis.",
    "    shifttime    Shift timesteps",
    "                 Shifts all timesteps by the parameter sval.",
    "",
    "PARAMETER",
    "    day       INTEGER  Value of the new day",
    "    month     INTEGER  Value of the new month",
    "    year      INTEGER  Value of the new year",
    "    units     STRING   Base units of the time axis (seconds, minutes, hours, days, months, years)",
    "    date      STRING   Date (format: YYYY-MM-DD)",
    "    time      STRING   Time (format: hh:mm:ss)",
    "    inc       STRING   Optional increment (seconds, minutes, hours, days, months, years) [default: 1hour]",
    "    calendar  STRING   Calendar (standard, proleptic_gregorian, 360_day, 365_day, 366_day)",
    "    sval      STRING   Shift value (e.g. -3hour)",
    NULL
};

static const char *ChangeHelp[] = {
    "NAME",
    "    chcode, chparam, chname, chunit, chlevel, chlevelc, chlevelv - ",
    "    Change field header",
    "",
    "SYNOPSIS",
    "    chcode,oldcode,newcode[,...]  ifile ofile",
    "    chparam,oldparam,newparam,...  ifile ofile",
    "    chname,oldname,newname,...  ifile ofile",
    "    chunit,oldunit,newunit,...  ifile ofile",
    "    chlevel,oldlev,newlev,...  ifile ofile",
    "    chlevelc,code,oldlev,newlev  ifile ofile",
    "    chlevelv,name,oldlev,newlev  ifile ofile",
    "",
    "DESCRIPTION",
    "    This module reads fields from ifile, changes some header values",
    "    and writes the results to ofile. The kind of changes depends on ",
    "    the chosen operator.",
    "",
    "OPERATORS",
    "    chcode    Change code number",
    "              Changes some user given code numbers to new user given values.",
    "    chparam   Change parameter identifier",
    "              Changes some user given parameter identifiers to new user given values.",
    "    chname    Change variable name",
    "              Changes some user given variable names to new user given names.",
    "    chunit    Change variable unit",
    "              Changes some user given variable units to new user given units.",
    "    chlevel   Change level",
    "              Changes some user given levels to new user given values.",
    "    chlevelc  Change level of one code",
    "              Changes one level of a user given code number.",
    "    chlevelv  Change level of one variable",
    "              Changes one level of a user given variable name.",
    "",
    "PARAMETER",
    "    code                   INTEGER  Code number",
    "    oldcode,newcode,...    INTEGER  Pairs of old and new code numbers",
    "    oldparam,newparam,...  STRING   Pairs of old and new parameter identifiers",
    "    name                   STRING   Variable name",
    "    oldname,newname,...    STRING   Pairs of old and new variable names",
    "    oldlev                 FLOAT    Old level",
    "    newlev                 FLOAT    New level",
    "    oldlev,newlev,...      FLOAT    Pairs of old and new levels",
    NULL
};

static const char *SetgridHelp[] = {
    "NAME",
    "    setgrid, setgridtype, setgridarea - Set grid information",
    "",
    "SYNOPSIS",
    "    setgrid,grid  ifile ofile",
    "    setgridtype,gridtype  ifile ofile",
    "    setgridarea,gridarea  ifile ofile",
    "",
    "DESCRIPTION",
    "    This module modifies the metadata of the horizontal grid. Depending on the ",
    "    chosen operator a new grid description is set, the coordinates are converted",
    "    or the grid cell area is added.",
    "",
    "OPERATORS",
    "    setgrid      Set grid",
    "                 Sets a new grid description. The input fields need to have the same grid size",
    "                 as the size of the target grid description.",
    "    setgridtype  Set grid type",
    "                 Sets the grid type of all input fields. The following grid types are available:",
    "                 curvilinear "    "    Converts a regular grid to a curvilinear grid",
    "                 unstructured"    "    Converts a regular or curvilinear grid to an unstructured grid",
    "                 dereference "    "    Dereference a reference to a grid",
    "                 regular     "    "    Converts a reduced Gaussian grid to a regular Gaussian grid",
    "                 lonlat      "    "    Converts a regular lonlat grid stored as a curvilinear grid back to a lonlat grid",
    "    setgridarea  Set grid cell area",
    "                 Sets the grid cell area. The parameter gridarea is the path to a data file,",
    "                 the first field is used as grid cell area. The input fields need to have the same",
    "                 grid size as the grid cell area. The grid cell area is used to compute",
    "                 the weights of each grid cell if needed by an operator, e.g. for fldmean.",
    "",
    "PARAMETER",
    "    grid      STRING  Grid description file or name",
    "    gridtype  STRING  Grid type (curvilinear, unstructured, regular, lonlat or dereference)",
    "    gridarea  STRING  Data file, the first field is used as grid cell area",
    NULL
};

static const char *SetzaxisHelp[] = {
    "NAME",
    "    setzaxis, genlevelbounds - Set z-axis information",
    "",
    "SYNOPSIS",
    "    setzaxis,zaxis  ifile ofile",
    "    genlevelbounds[,zbot[,ztop]]  ifile ofile",
    "",
    "DESCRIPTION",
    "    This module modifies the metadata of the vertical grid.",
    "",
    "OPERATORS",
    "    setzaxis        Set z-axis",
    "                    This operator sets the z-axis description of all variables with the same number of level as the new z-axis.",
    "    genlevelbounds  Generate level bounds",
    "                    Generates the layer bounds of the z-axis.",
    "",
    "PARAMETER",
    "    zaxis  STRING  Z-axis description file or name of the target z-axis",
    "    zbot   FLOAT   Specifying the bottom of the vertical column. Must have the same units as z-axis. ",
    "    ztop   FLOAT   Specifying the top of the vertical column. Must have the same units as z-axis. ",
    NULL
};

static const char *SetgattHelp[] = {
    "NAME",
    "    setgatt, setgatts - Set global attribute",
    "",
    "SYNOPSIS",
    "    setgatt,attname,attstring  ifile ofile",
    "    setgatts,attfile  ifile ofile",
    "",
    "DESCRIPTION",
    "    This module sets global text attributes of a dataset. Depending on the chosen ",
    "    operator the attributes are read from a file or can be specified by a parameter.",
    "",
    "OPERATORS",
    "    setgatt   Set global attribute",
    "              Sets one user defined global text attribute.",
    "    setgatts  Set global attributes",
    "              Sets user defined global text attributes. The name and text",
    "              of the global attributes are read from a file.",
    "",
    "PARAMETER",
    "    attname,attstring  STRING  Name and text of the global attribute (without spaces!)",
    "    attfile            STRING  File name which contains global text attributes",
    "",
    "NOTE",
    "    Besides NetCDF none of the supported data formats supports global attributes.",
    NULL
};

static const char *InvertHelp[] = {
    "NAME",
    "    invertlat - Invert latitudes",
    "",
    "SYNOPSIS",
    "    invertlat  ifile ofile",
    "",
    "DESCRIPTION",
    "    This operator inverts the latitudes of all fields on a rectilinear grid. ",
    NULL
};

static const char *InvertlevHelp[] = {
    "NAME",
    "    invertlev - Invert levels",
    "",
    "SYNOPSIS",
    "    invertlev  ifile ofile",
    "",
    "DESCRIPTION",
    "    This operator inverts the levels of all 3D variables.",
    NULL
};

static const char *MaskregionHelp[] = {
    "NAME",
    "    maskregion - Mask regions",
    "",
    "SYNOPSIS",
    "    maskregion,regions  ifile ofile",
    "",
    "DESCRIPTION",
    "    Masks different regions of fields with a regular lon/lat grid. The elements ",
    "    inside a region are untouched, the elements outside are set to missing value.",
    "    Considered are only those grid cells with the grid center inside the regions.",
    "    All input fields must have the same horizontal grid.",
    "    The user has to give ASCII formatted files with different regions.",
    "    A region is defined by a polygon. Each line of a polygon description file ",
    "    contains the longitude and latitude of one point.",
    "    Each polygon description file can contain one or more polygons separated",
    "    by a line with the character \\&.",
    "",
    "PARAMETER",
    "    regions  STRING Comma separated list of ASCII formatted files with different regions",
    NULL
};

static const char *MaskboxHelp[] = {
    "NAME",
    "    masklonlatbox, maskindexbox - Mask a box",
    "",
    "SYNOPSIS",
    "    masklonlatbox,lon1,lon2,lat1,lat2  ifile ofile",
    "    maskindexbox,idx1,idx2,idy1,idy2  ifile ofile",
    "",
    "DESCRIPTION",
    "    Masked a box of the rectangularly understood field. The elements inside the box are untouched, the ",
    "    elements outside are set to missing value. All input fields need to have the same horizontal grid.",
    "    Use sellonlatbox or selindexbox if only the data inside the box are needed.",
    "",
    "OPERATORS",
    "    masklonlatbox  Mask a longitude/latitude box",
    "                   Masked a regular longitude/latitude box. The user has to give the longitudes and latitudes of the ",
    "                   edges of the box. Considered are only those grid cells with the grid center inside the lon/lat box.",
    "    maskindexbox   Mask an index box",
    "                   Masked an index box. The user has to give the indexes of the edges of the box. ",
    "                   The index of the left edge can be greater then the one of the right edge.",
    "",
    "PARAMETER",
    "    lon1  FLOAT    Western longitude",
    "    lon2  FLOAT    Eastern longitude",
    "    lat1  FLOAT    Southern or northern latitude",
    "    lat2  FLOAT    Northern or southern latitude",
    "    idx1  INTEGER  Index of first longitude",
    "    idx2  INTEGER  Index of last longitude",
    "    idy1  INTEGER  Index of first latitude",
    "    idy2  INTEGER  Index of last latitude",
    NULL
};

static const char *SetboxHelp[] = {
    "NAME",
    "    setclonlatbox, setcindexbox - Set a box to constant",
    "",
    "SYNOPSIS",
    "    setclonlatbox,c,lon1,lon2,lat1,lat2  ifile ofile",
    "    setcindexbox,c,idx1,idx2,idy1,idy2  ifile ofile",
    "",
    "DESCRIPTION",
    "    Sets a box of the rectangularly understood field to a constant value. The elements outside ",
    "    the box are untouched, the elements inside are set to the given constant. All input fields ",
    "    need to have the same horizontal grid.",
    "",
    "OPERATORS",
    "    setclonlatbox  Set a longitude/latitude box to constant",
    "                   Sets the values of a longitude/latitude box to a constant value. The ",
    "                   user has to give the longitudes and latitudes of the edges of the box.",
    "    setcindexbox   Set an index box to constant",
    "                   Sets the values of an index box to a constant value. The user has to ",
    "                   give the indexes of the edges of the box. The index of the left edge ",
    "                   can be greater than the one of the right edge.",
    "",
    "PARAMETER",
    "    c     FLOAT    Constant",
    "    lon1  FLOAT    Western longitude",
    "    lon2  FLOAT    Eastern longitude",
    "    lat1  FLOAT    Southern or northern latitude",
    "    lat2  FLOAT    Northern or southern latitude",
    "    idx1  INTEGER  Index of first longitude",
    "    idx2  INTEGER  Index of last longitude",
    "    idy1  INTEGER  Index of first latitude",
    "    idy2  INTEGER  Index of last latitude",
    NULL
};

static const char *EnlargeHelp[] = {
    "NAME",
    "    enlarge - Enlarge fields",
    "",
    "SYNOPSIS",
    "    enlarge,grid  ifile ofile",
    "",
    "DESCRIPTION",
    "    Enlarge all fields of ifile to a user given grid. Normally only the last ",
    "    field element is used for the enlargement. If however the input and output",
    "    grid are regular lon/lat grids, a zonal or meridional enlargement is possible.",
    "    Zonal enlargement takes place, if the xsize of the input field is 1 and ",
    "    the ysize of both grids are the same. For meridional enlargement the ysize",
    "    have to be 1 and the xsize of both grids should have the same size.",
    "",
    "PARAMETER",
    "    grid  STRING  Target grid description file or name",
    NULL
};

static const char *SetmissHelp[] = {
    "NAME",
    "    setmissval, setctomiss, setmisstoc, setrtomiss, setvrange, setmisstonn, ",
    "    setmisstodis - Set missing value",
    "",
    "SYNOPSIS",
    "    setmissval,newmiss  ifile ofile",
    "    setctomiss,c  ifile ofile",
    "    setmisstoc,c  ifile ofile",
    "    setrtomiss,rmin,rmax  ifile ofile",
    "    setvrange,rmin,rmax  ifile ofile",
    "    setmisstonn  ifile ofile",
    "    setmisstodis[,neighbors]  ifile ofile",
    "",
    "DESCRIPTION",
    "    This module sets part of a field to missing value or missing values",
    "    to a constant value. Which part of the field is set depends on the ",
    "    chosen operator.",
    "",
    "OPERATORS",
    "    setmissval    Set a new missing value",
    "                           / newmiss   if i(t,x) EQ miss",
    "                  o(t,x) = ",
    "                           \\ i(t,x)    if i(t,x) NE miss",
    "    setctomiss    Set constant to missing value",
    "                           / miss   if i(t,x) EQ c",
    "                  o(t,x) = ",
    "                           \\ i(t,x) if i(t,x) NE c",
    "    setmisstoc    Set missing value to constant",
    "                           / c      if i(t,x) EQ miss",
    "                  o(t,x) = ",
    "                           \\ i(t,x) if i(t,x) NE miss",
    "    setrtomiss    Set range to missing value",
    "                           / miss   if i(t,x) GE rmin AND i(t,x) LE rmax",
    "                  o(t,x) = ",
    "                           \\ i(t,x) if i(t,x) LT rmin OR  i(t,x) GT rmax",
    "    setvrange     Set valid range",
    "                           / miss   if i(t,x) LT rmin OR  i(t,x) GT rmax",
    "                  o(t,x) = ",
    "                           \\ i(t,x) if i(t,x) GE rmin AND i(t,x) LE rmax",
    "    setmisstonn   Set missing value to nearest neighbor",
    "                  Set all missing values to the nearest non missing value.",
    "                           / i(t,y) if i(t,x) EQ miss AND i(t,y) NE miss",
    "                  o(t,x) = ",
    "                           \\ i(t,x) if i(t,x) NE miss",
    "    setmisstodis  Set missing value to distance-weighted average",
    "                  Set all missing values to the distance-weighted average of the nearest non missing values.",
    "                  The default number of nearest neighbors is 4.",
    "",
    "PARAMETER",
    "    neighbors  INTEGER  Number of nearest neighbors",
    "    newmiss    FLOAT    New missing value",
    "    c          FLOAT    Constant",
    "    rmin       FLOAT    Lower bound",
    "    rmax       FLOAT    Upper bound",
    NULL
};

static const char *ExprHelp[] = {
    "NAME",
    "    expr, exprf, aexpr, aexprf - Evaluate expressions",
    "",
    "SYNOPSIS",
    "    expr,instr  ifile ofile",
    "    exprf,filename  ifile ofile",
    "    aexpr,instr  ifile ofile",
    "    aexprf,filename  ifile ofile",
    "",
    "DESCRIPTION",
    "    This module arithmetically processes every timestep of the input dataset.",
    "    Each individual assignment statement have to end with a semi-colon.",
    "    Unlike regular variables, temporary variables are never written to the output stream.",
    "    To define a temporary variable simply prefix the variable name with an underscore (e.g. _varname)",
    "    when the variable is declared.",
    "    ",
    "    The following operators are supported:",
    "    ",
    "     Operator   & Meaning             & Example   & Result ",
    "         =      & assignment          & x = y     & Assigns y to x",
    "         +      & addition            & x + y     & Sum of x and y",
    "         -      & subtraction         & x - y     & Difference of x and y    ",
    "         *      & multiplication      & x * y     & Product of x and y ",
    "         /      & division            & x / y     & Quotient of x and y",
    "         ^      & exponentiation      & x ^ y     & Exponentiates x with y ",
    "         ==     & equal to            & x == y    &  1, if x equal to y; else 0",
    "         !=     & not equal to        & x != y    &  1, if x not equal to y; else 0",
    "         >      & greater than        & x > y     &  1, if x greater than y; else 0",
    "         <      & less than           & x < y     &  1, if x less than y; else 0",
    "         >=     & greater equal       & x >= y    &  1, if x greater equal y; else 0",
    "         <=     & less equal          & x <= y    &  1, if x less equal y; else 0",
    "         <=>    & less equal greater  & x <=> y   & -1, if x less y; 1, if x greater y; else 0 ",
    "         &&     & logical AND         & x && y    &  1, if x and y not equal 0; else 0",
    "         ||     & logical OR          & x || y    &  1, if x or y not equal 0; else 0",
    "         ?:     & ternary conditional & x ? y : z & y, if x not equal 0, else z ",
    "    ",
    "    The following functions are supported:",
    "    ",
    "    Math intrinsics:",
    "    ",
    "    abs(x)  "    "    Absolute value of x",
    "    floor(x)"    "    Round to largest integral value not greater than x",
    "    ceil(x) "    "    Round to smallest integral value not less than x",
    "    int(x)  "    "    Integer value of x",
    "    nint(x) "    "    Nearest integer value of x",
    "    sqr(x)  "    "    Square of x",
    "    sqrt(x) "    "    Square Root of x",
    "    exp(x)  "    "    Exponential of x",
    "    log(x)  "    "    Natural logarithm of x",
    "    log10(x)"    "    Base 10 logarithm of x",
    "    sin(x)  "    "    Sine of x, where x is specified in radians",
    "    cos(x)  "    "    Cosine of x, where x is specified in radians",
    "    tan(x)  "    "    Tangent of x, where x is specified in radians",
    "    asin(x) "    "    Arc-sine of x, where x is specified in radians",
    "    acos(x) "    "    Arc-cosine of x, where x is specified in radians",
    "    atan(x) "    "    Arc-tangent of x, where x is specified in radians",
    "    rad(x)  "    "    Convert x from degrees to radians",
    "    deg(x)  "    "    Convert x from radians to degrees",
    "    ",
    "    Coordinates:",
    "    ",
    "    clon(x)    "    "    Longitude coordinate of x (available only if x has geographical coordinates) ",
    "    clat(x)    "    "    Latitude coordinate of x (available only if x has geographical coordinates) ",
    "    gridarea(x)"    "    Grid cell area of x (available only if x has geographical coordinates) ",
    "    clev(x)    "    "    Level coordinate of x (0, if x is a 2D surface variable)",
    "    ",
    "    Constants:",
    "    ",
    "    ngp(x)    "    "    Number of horizontal grid points",
    "    nlev(x)   "    "    Number of vertical levels",
    "    size(x)   "    "    Total number of elements (ngp(x)*nlev(x))",
    "    missval(x)"    "    Returns the missing value of variable x",
    "    ",
    "    Statistical values over a field:",
    "    ",
    "    fldmin(x), fldmax(x), fldsum(x), fldmean(x), fldavg(x), fldstd(x), fldstd1(x), fldvar(x), fldvar1(x)",
    "    ",
    "    Vertical statistical values:",
    "    ",
    "    vertmin(x), vertmax(x), vertsum(x), vertmean(x), vertavg(x), vertstd(x), vertstd1(x), vertvar(x), vertvar1(x)",
    "    ",
    "    Miscellaneous:",
    "    ",
    "    sellevel(x,k) "    "    Select level k of variable x",
    "    sellevidx(x,k)"    "    Select level index k of variable x",
    "    remove(x)     "    "    Remove variable x from output stream",
    "    ",
    "",
    "OPERATORS",
    "    expr    Evaluate expressions",
    "            The processing instructions are read from the parameter.",
    "    exprf   Evaluate expressions script",
    "            Contrary to expr the processing instructions are read from a file.",
    "    aexpr   Evaluate expressions and append results",
    "            Same as expr, but keep input variables and append results",
    "    aexprf  Evaluate expression script and append results",
    "            Same as exprf, but keep input variables and append results",
    "",
    "PARAMETER",
    "    instr     STRING  Processing instructions (need to be 'quoted' in most cases)",
    "    filename  STRING  File with processing instructions",
    NULL
};

static const char *MathHelp[] = {
    "NAME",
    "    abs, int, nint, pow, sqr, sqrt, exp, ln, log10, sin, cos, tan, asin, acos, ",
    "    atan, reci - Mathematical functions",
    "",
    "SYNOPSIS",
    "    <operator>  ifile ofile",
    "",
    "DESCRIPTION",
    "    This module contains some standard mathematical functions.",
    "    All trigonometric functions calculate with radians.",
    "",
    "OPERATORS",
    "    abs    Absolute value",
    "           o(t,x) = abs(i(t,x))",
    "    int    Integer value",
    "           o(t,x) = int(i(t,x))",
    "    nint   Nearest integer value",
    "           o(t,x) = nint(i(t,x))",
    "    pow    Power",
    "           o(t,x) = i(t,x)^y",
    "    sqr    Square",
    "           o(t,x) = i(t,x)^2",
    "    sqrt   Square root",
    "           o(t,x) = sqrt(i(t,x))",
    "    exp    Exponential",
    "           o(t,x) = e^i(t,x)",
    "    ln     Natural logarithm",
    "           o(t,x) = ln(i(t,x))",
    "    log10  Base 10 logarithm",
    "           o(t,x) = log10(i(t,x))",
    "    sin    Sine",
    "           o(t,x) = sin(i(t,x))",
    "    cos    Cosine",
    "           o(t,x) = cos(i(t,x))",
    "    tan    Tangent",
    "           o(t,x) = tan(i(t,x))",
    "    asin   Arc sine",
    "           o(t,x) = asin(i(t,x))",
    "    acos   Arc cosine",
    "           o(t,x) = acos(i(t,x))",
    "    atan   Arc tangent",
    "           o(t,x) = atan(i(t,x))",
    "    reci   Reciprocal value",
    "           o(t,x) = 1 / i(t,x)",
    NULL
};

static const char *ArithcHelp[] = {
    "NAME",
    "    addc, subc, mulc, divc - Arithmetic with a constant",
    "",
    "SYNOPSIS",
    "    <operator>,c  ifile ofile",
    "",
    "DESCRIPTION",
    "    This module performs simple arithmetic with all field elements of a dataset and ",
    "    a constant. The fields in ofile inherit the meta data from ifile.",
    "",
    "OPERATORS",
    "    addc  Add a constant",
    "          o(t,x) = i(t,x) + c",
    "    subc  Subtract a constant",
    "          o(t,x) = i(t,x) - c",
    "    mulc  Multiply with a constant",
    "          o(t,x) = i(t,x) * c",
    "    divc  Divide by a constant",
    "          o(t,x) = i(t,x) / c",
    "",
    "PARAMETER",
    "    c  FLOAT  Constant",
    NULL
};

static const char *ArithHelp[] = {
    "NAME",
    "    add, sub, mul, div, min, max, atan2 - Arithmetic on two datasets",
    "",
    "SYNOPSIS",
    "    <operator>  ifile1 ifile2 ofile",
    "",
    "DESCRIPTION",
    "    This module performs simple arithmetic of two datasets.",
    "    The number of fields in ifile1 should be the same as in ifile2.",
    "    The fields in ofile inherit the meta data from ifile1.",
    "    One of the input files can contain only one timestep or one variable.",
    "",
    "OPERATORS",
    "    add    Add two fields",
    "           o(t,x) = i_1(t,x) + i_2(t,x)",
    "    sub    Subtract two fields",
    "           o(t,x) = i_1(t,x) - i_2(t,x)",
    "    mul    Multiply two fields",
    "           o(t,x) = i_1(t,x) * i_2(t,x)",
    "    div    Divide two fields",
    "           o(t,x) = i_1(t,x) / i_2(t,x)",
    "    min    Minimum of two fields",
    "           o(t,x) = min(i_1(t,x), i_2(t,x))",
    "    max    Maximum of two fields",
    "           o(t,x) = max(i_1(t,x), i_2(t,x))",
    "    atan2  Arc tangent of two fields",
    "           The atan2 operator calculates the arc tangent of two fields. The result is",
    "           in radians, which is between -PI and PI (inclusive).",
    "           ",
    "           o(t,x) = atan2(i_1(t,x), i_2(t,x))",
    NULL
};

static const char *MonarithHelp[] = {
    "NAME",
    "    monadd, monsub, monmul, mondiv - Monthly arithmetic",
    "",
    "SYNOPSIS",
    "    <operator>  ifile1 ifile2 ofile",
    "",
    "DESCRIPTION",
    "    This module performs simple arithmetic of a time series and one",
    "    timestep with the same month and year. For each field in ifile1",
    "    the corresponding field of the timestep in ifile2 with the",
    "    same month and year is used. The header information in ifile1",
    "    have to be the same as in ifile2. Usually ifile2 is generated",
    "    by an operator of the module MONSTAT.",
    "",
    "OPERATORS",
    "    monadd  Add monthly time series",
    "            Adds a time series and a monthly time series.",
    "    monsub  Subtract monthly time series",
    "            Subtracts a time series and a monthly time series.",
    "    monmul  Multiply monthly time series",
    "            Multiplies a time series and a monthly time series.",
    "    mondiv  Divide monthly time series",
    "            Divides a time series and a monthly time series.",
    NULL
};

static const char *YhourarithHelp[] = {
    "NAME",
    "    yhouradd, yhoursub, yhourmul, yhourdiv - Multi-year hourly arithmetic",
    "",
    "SYNOPSIS",
    "    <operator>  ifile1 ifile2 ofile",
    "",
    "DESCRIPTION",
    "    This module performs simple arithmetic of a time series and one",
    "    timestep with the same hour and day of year. For each field in ifile1",
    "    the corresponding field of the timestep in ifile2 with the",
    "    same hour and day of year is used. The header information in ifile1",
    "    have to be the same as in ifile2. Usually ifile2 is generated",
    "    by an operator of the module YHOURSTAT.",
    "",
    "OPERATORS",
    "    yhouradd  Add multi-year hourly time series",
    "              Adds a time series and a multi-year hourly time series.",
    "    yhoursub  Subtract multi-year hourly time series",
    "              Subtracts a time series and a multi-year hourly time series.",
    "    yhourmul  Multiply multi-year hourly time series",
    "              Multiplies a time series and a multi-year hourly time series.",
    "    yhourdiv  Divide multi-year hourly time series",
    "              Divides a time series and a multi-year hourly time series.",
    NULL
};

static const char *YdayarithHelp[] = {
    "NAME",
    "    ydayadd, ydaysub, ydaymul, ydaydiv - Multi-year daily arithmetic",
    "",
    "SYNOPSIS",
    "    <operator>  ifile1 ifile2 ofile",
    "",
    "DESCRIPTION",
    "    This module performs simple arithmetic of a time series and one",
    "    timestep with the same day of year. For each field in ifile1",
    "    the corresponding field of the timestep in ifile2 with the",
    "    same day of year is used. The header information in ifile1",
    "    have to be the same as in ifile2. Usually ifile2 is generated",
    "    by an operator of the module YDAYSTAT.",
    "",
    "OPERATORS",
    "    ydayadd  Add multi-year daily time series",
    "             Adds a time series and a multi-year daily time series.",
    "    ydaysub  Subtract multi-year daily time series",
    "             Subtracts a time series and a multi-year daily time series.",
    "    ydaymul  Multiply multi-year daily time series",
    "             Multiplies a time series and a multi-year daily time series.",
    "    ydaydiv  Divide multi-year daily time series",
    "             Divides a time series and a multi-year daily time series.",
    NULL
};

static const char *YmonarithHelp[] = {
    "NAME",
    "    ymonadd, ymonsub, ymonmul, ymondiv - Multi-year monthly arithmetic",
    "",
    "SYNOPSIS",
    "    <operator>  ifile1 ifile2 ofile",
    "",
    "DESCRIPTION",
    "    This module performs simple arithmetic of a time series and one timestep",
    "    with the same month of year. For each field in ifile1 the corresponding",
    "    field of the timestep in ifile2 with the same month of year is used.",
    "    The header information in ifile1 have to be the same as in ifile2.",
    "    Usually ifile2 is generated by an operator of the module YMONSTAT.",
    "",
    "OPERATORS",
    "    ymonadd  Add multi-year monthly time series",
    "             Adds a time series and a multi-year monthly time series.",
    "    ymonsub  Subtract multi-year monthly time series",
    "             Subtracts a time series and a multi-year monthly time series.",
    "    ymonmul  Multiply multi-year monthly time series",
    "             Multiplies a time series and a multi-year monthly time series.",
    "    ymondiv  Divide multi-year monthly time series",
    "             Divides a time series and a multi-year monthly time series.",
    NULL
};

static const char *YseasarithHelp[] = {
    "NAME",
    "    yseasadd, yseassub, yseasmul, yseasdiv - Multi-year seasonal arithmetic",
    "",
    "SYNOPSIS",
    "    <operator>  ifile1 ifile2 ofile",
    "",
    "DESCRIPTION",
    "    This module performs simple arithmetic of a time series and one timestep",
    "    with the same season. For each field in ifile1 the corresponding",
    "    field of the timestep in ifile2 with the same season is used.",
    "    The header information in ifile1 have to be the same as in ifile2.",
    "    Usually ifile2 is generated by an operator of the module YSEASSTAT.",
    "",
    "OPERATORS",
    "    yseasadd  Add multi-year seasonal time series",
    "              Adds a time series and a multi-year seasonal time series.",
    "    yseassub  Subtract multi-year seasonal time series",
    "              Subtracts a time series and a multi-year seasonal time series.",
    "    yseasmul  Multiply multi-year seasonal time series",
    "              Multiplies a time series and a multi-year seasonal time series.",
    "    yseasdiv  Divide multi-year seasonal time series",
    "              Divides a time series and a multi-year seasonal time series.",
    NULL
};

static const char *ArithdaysHelp[] = {
    "NAME",
    "    muldpm, divdpm, muldpy, divdpy - Arithmetic with days",
    "",
    "SYNOPSIS",
    "    <operator>  ifile ofile",
    "",
    "DESCRIPTION",
    "    This module multiplies or divides each timestep of a dataset with the corresponding",
    "    days per month or days per year. The result of these functions depends on the used",
    "    calendar of the input data.",
    "",
    "OPERATORS",
    "    muldpm  Multiply with days per month",
    "            o(t,x) = i(t,x) * days_per_month",
    "    divdpm  Divide by days per month",
    "            o(t,x) = i(t,x) / days_per_month",
    "    muldpy  Multiply with days per year",
    "            o(t,x) = i(t,x) * days_per_year",
    "    divdpy  Divide by days per year",
    "            o(t,x) = i(t,x) / days_per_year",
    NULL
};

static const char *ConsecstatHelp[] = {
    "NAME",
    "    consecsum, consects - Consecute timestep periods",
    "",
    "SYNOPSIS",
    "    <operator>  ifile ofile",
    "",
    "DESCRIPTION",
    "    This module computes periods over all timesteps in ifile where a",
    "    certain property is valid. The propery can be chosen by creating a mask from",
    "    the original data, which is the expected input format for operators of this",
    "    module. Depending on the operator full information about each period or",
    "    just its length and ending date are computed.",
    "",
    "OPERATORS",
    "    consecsum  Consecutive Sum",
    "               This operator computes periods of consecutive timesteps similar to a",
    "               runsum, but periods are finished, when the mask value is 0. That way",
    "               multiple periods can be found. Timesteps from the input are preserved. Missing",
    "               values are handled like 0, i.e. finish periods of consecutive timesteps.",
    "    consects   Consecutive Timesteps",
    "               In contrast to the operator above consects only computes the lenght of each",
    "               period together with its last timestep. To be able to perform statistical",
    "               analysis like min, max or mean, everything else is set to missing value.",
    NULL
};

static const char *EnsstatHelp[] = {
    "NAME",
    "    ensmin, ensmax, enssum, ensmean, ensavg, ensstd, ensstd1, ensvar, ensvar1, ",
    "    enspctl - Statistical values over an ensemble",
    "",
    "SYNOPSIS",
    "    <operator>  ifiles ofile",
    "    enspctl,p  ifiles ofile",
    "",
    "DESCRIPTION",
    "    This module computes statistical values over an ensemble of input files.",
    "    Depending on the chosen operator the minimum, maximum, sum, average, variance,",
    "    standard deviation or a certain percentile over all input files is written",
    "    to ofile.",
    "    All input files need to have the same structure with the same variables.",
    "    The date information of a timestep in ofile is the date of the first input file.",
    "",
    "OPERATORS",
    "    ensmin   Ensemble minimum",
    "             o(t,x) = min{i1(t,x), i2(t,x), ..., in(t,x)}",
    "    ensmax   Ensemble maximum",
    "             o(t,x) = max{i1(t,x), i2(t,x), ..., in(t,x)}",
    "    enssum   Ensemble sum",
    "             o(t,x) = sum{i1(t,x), i2(t,x), ..., in(t,x)}",
    "    ensmean  Ensemble mean",
    "             o(t,x) = mean{i1(t,x), i2(t,x), ..., in(t,x)}",
    "    ensavg   Ensemble average",
    "             o(t,x) = avg{i1(t,x), i2(t,x), ..., in(t,x)}",
    "    ensstd   Ensemble standard deviation",
    "             Normalize by n.",
    "             ",
    "             o(t,x) = std{i1(t,x), i2(t,x), ..., in(t,x)}",
    "    ensstd1  Ensemble standard deviation (n-1)",
    "             Normalize by (n-1).",
    "             ",
    "             o(t,x) = std1{i1(t,x), i2(t,x), ..., in(t,x)}",
    "    ensvar   Ensemble variance",
    "             Normalize by n.",
    "             ",
    "             o(t,x) = var{i1(t,x), i2(t,x), ..., in(t,x)}",
    "    ensvar1  Ensemble variance (n-1)",
    "             Normalize by (n-1).",
    "             ",
    "             o(t,x) = var1{i1(t,x), i2(t,x), ..., in(t,x)}",
    "    enspctl  Ensemble percentiles",
    "             o(t,x) = pth percentile {i1(t,x), i2(t,x), ..., in(t,x)}",
    "",
    "PARAMETER",
    "    p  FLOAT  Percentile number in {0, ..., 100}",
    NULL
};

static const char *Ensstat2Help[] = {
    "NAME",
    "    ensrkhistspace, ensrkhisttime, ensroc - Statistical values over an ensemble",
    "",
    "SYNOPSIS",
    "    <operator>  obsfile ensfiles ofile",
    "",
    "DESCRIPTION",
    "    This module computes statistical values over the ensemble of ensfiles using",
    "    obsfile as a reference. Depending on the operator a ranked Histogram or ",
    "    a roc-curve over all Ensembles ensfiles",
    "    with reference to obsfile is written to ofile. ",
    "    The date and grid information of a timestep in ofile is the date of the ",
    "    first input file. Thus all input files are required to have the same structure in ",
    "    terms of the gridsize, variable definitions and number of timesteps. ",
    "    ",
    "    All Operators in this module use obsfile as the reference (for instance ",
    "    an observation) whereas ensfiles are understood as an ensemble consisting ",
    "    of n (where n is the number of ensfiles) members. ",
    "    ",
    "    The operators ensrkhistspace and ensrkhisttime compute Ranked Histograms. ",
    "    Therefor the vertical axis is utilized as the Histogram axis, which prohibits",
    "    the use of files containing more than one level. The histogram axis has ",
    "    nensfiles+1 bins with level 0 containing for each grid point the number of ",
    "    observations being smaller as all ensembles and level nensfiles+1 indicating",
    "    the number of observations being larger than all ensembles. ",
    "    ",
    "    ensrkhistspace computes a ranked histogram at each timestep reducing each ",
    "    horizontal grid to a 1x1 grid and keeping the time axis as in obsfile. ",
    "    Contrary ensrkhistspace  computes a histogram at each grid point keeping the ",
    "    horizontal grid for each variable and reducing the time-axis. The time infor-",
    "    mation is that from the last timestep in obsfile. ",
    "",
    "OPERATORS",
    "    ensrkhistspace  Ranked Histogram averaged over time",
    "    ensrkhisttime   Ranked Histogram averaged over space",
    "    ensroc          Ensemble Receiver Operating characteristics",
    NULL
};

static const char *EnsvalHelp[] = {
    "NAME",
    "    enscrps, ensbrs - Ensemble validation tools",
    "",
    "SYNOPSIS",
    "    enscrps  rfile ifiles ofilebase",
    "    ensbrs,x  rfile ifiles ofilebase",
    "",
    "DESCRIPTION",
    "    This module computes ensemble validation scores and their decomposition such as ",
    "    the Brier and cumulative ranked probability score (CRPS). ",
    "    The first file is used as a reference it can be a climatology, observation or ",
    "    reanalysis against which the skill of the ensembles given in ifiles is measured. ",
    "    Depending on the operator a number of output files is generated each containing ",
    "    the skill score and its decomposition corresponding to the operator. ",
    "    The output is averaged  over horizontal fields using appropriate weights ",
    "    for each level and timestep in rfile. ",
    "    ",
    "    All input files need to have the same structure with the same variables.",
    "    The date information of a timestep in ofile is the date of the first input file.",
    "    The output files are named as ",
    "    <ofilebase>.<type>.<filesuffix> where <type> depends on the ",
    "    operator and <filesuffix> is determined from the output file type. ",
    "    There are three output files for operator enscrps and four output files ",
    "    for operator ensbrs.",
    "    ",
    "    The CRPS and its decomposition into Reliability and the potential ",
    "    CRPS are calculated by an appropriate averaging over the field ",
    "    members (note, that the CRPS does *not* average linearly). ",
    "    In the three output files ",
    "    <type> has the following meaning:",
    "    crps for the CRPS, reli for the reliability ",
    "    and crpspot for the potential crps. The relation ",
    "    CRPS = CRPS_{pot} + RELI",
    "    holds. 	  ",
    "    ",
    "    The Brier score of the Ensemble given by ifiles with respect to the ",
    "    reference given in rfile and the threshold x is calculated. ",
    "    In the four output files <type> has the following meaning: ",
    "    brs for the Brier score wrt threshold  x; ",
    "    brsreli for the Brier score reliability wrt threshold x;",
    "    brsreso for the Brier score resolution wrt threshold x;",
    "    brsunct for the Brier score uncertainty wrt threshold x.",
    "    In analogy to the CRPS the following relation holds:",
    "    BRS(x) = RELI(x)-RESO(x)+ UNCT(x).",
    "    ",
    "    The implementation of the decomposition of the CRPS and Brier Score follows ",
    "      Hans Hersbach (2000): Decomposition of the Continuous Ranked Probability ",
    "      Score for Ensemble Prediction Systems, in: Weather and Forecasting (15) ",
    "      pp. 559-570. ",
    "    ",
    "    The CRPS code decomposition has been verified against the CRAN - ensemble ",
    "    validation package from R. Differences occur when grid-cell area is not ",
    "    uniform as the implementation in R does not account for that. ",
    "    ",
    "",
    "OPERATORS",
    "    enscrps  Ensemble CRPS and decomposition",
    "    ensbrs   Ensemble Brier score",
    "             Ensemble Brier Score and Decomposition",
    NULL
};

static const char *FldstatHelp[] = {
    "NAME",
    "    fldmin, fldmax, fldsum, fldmean, fldavg, fldstd, fldstd1, fldvar, fldvar1, ",
    "    fldpctl - Statistical values over a field",
    "",
    "SYNOPSIS",
    "    <operator>  ifile ofile",
    "    fldpctl,p  ifile ofile",
    "",
    "DESCRIPTION",
    "    This module computes statistical values of the input fields. According to the chosen ",
    "    operator the field minimum, maximum, sum, average, variance, standard deviation or ",
    "    a certain percentile is written to ofile.",
    "",
    "OPERATORS",
    "    fldmin   Field minimum",
    "             For every gridpoint x_1, ..., x_n of the same field it is:",
    "             ",
    "             o(t,1) = min{i(t,x'), x_1<x'<=x_n}",
    "    fldmax   Field maximum",
    "             For every gridpoint x_1, ..., x_n of the same field it is:",
    "             ",
    "             o(t,1) = max{i(t,x'), x_1<x'<=x_n}",
    "    fldsum   Field sum",
    "             For every gridpoint x_1, ..., x_n of the same field it is:",
    "             ",
    "             o(t,1) = sum{i(t,x'), x_1<x'<=x_n}",
    "    fldmean  Field mean",
    "             For every gridpoint x_1, ..., x_n of the same field it is:",
    "             ",
    "             o(t,1) = mean{i(t,x'), x_1<x'<=x_n}",
    "             weighted by area weights obtained by the input field.",
    "    fldavg   Field average",
    "             For every gridpoint x_1, ..., x_n of the same field it is:",
    "             ",
    "             o(t,1) = avg{i(t,x'), x_1<x'<=x_n}",
    "             weighted by area weights obtained by the input field.",
    "    fldstd   Field standard deviation",
    "             Normalize by n. For every gridpoint x_1, ..., x_n of the same field it is:",
    "             ",
    "             o(t,1) = std{i(t,x'), x_1<x'<=x_n}",
    "             weighted by area weights obtained by the input field.",
    "    fldstd1  Field standard deviation (n-1)",
    "             Normalize by (n-1). For every gridpoint x_1, ..., x_n of the same field it is:",
    "             ",
    "             o(t,1) = std1{i(t,x'), x_1<x'<=x_n}",
    "             weighted by area weights obtained by the input field.",
    "    fldvar   Field variance",
    "             Normalize by n. For every gridpoint x_1, ..., x_n of the same field it is:",
    "             ",
    "             o(t,1) = var{i(t,x'), x_1<x'<=x_n}",
    "             weighted by area weights obtained by the input field.",
    "    fldvar1  Field variance (n-1)",
    "             Normalize by (n-1). For every gridpoint x_1, ..., x_n of the same field it is:",
    "             ",
    "             o(t,1) = var1{i(t,x'), x_1<x'<=x_n}",
    "             weighted by area weights obtained by the input field.",
    "    fldpctl  Field percentiles",
    "             For every gridpoint x_1, ..., x_n of the same field it is:",
    "             ",
    "             o(t,1) = pth percentile {i(t,x'), x_1<x'<=x_n}",
    "",
    "PARAMETER",
    "    p  FLOAT  Percentile number in {0, ..., 100}",
    NULL
};

static const char *ZonstatHelp[] = {
    "NAME",
    "    zonmin, zonmax, zonsum, zonmean, zonavg, zonstd, zonstd1, zonvar, zonvar1, ",
    "    zonpctl - Zonal statistical values",
    "",
    "SYNOPSIS",
    "    <operator>  ifile ofile",
    "    zonpctl,p  ifile ofile",
    "",
    "DESCRIPTION",
    "    This module computes zonal statistical values of the input fields.",
    "    According to the chosen operator the zonal minimum, maximum, sum, average,",
    "    variance, standard deviation or a certain percentile is written to ofile.",
    "    This operator requires all variables on the same regular lon/lat grid.",
    "",
    "OPERATORS",
    "    zonmin   Zonal minimum",
    "             For every latitude the minimum over all longitudes is computed.",
    "    zonmax   Zonal maximum",
    "             For every latitude the maximum over all longitudes is computed.",
    "    zonsum   Zonal sum",
    "             For every latitude the sum over all longitudes is computed.",
    "    zonmean  Zonal mean",
    "             For every latitude the mean over all longitudes is computed.",
    "    zonavg   Zonal average",
    "             For every latitude the average over all longitudes is computed.",
    "    zonstd   Zonal standard deviation",
    "             For every latitude the standard deviation over all longitudes is computed. Normalize by n.",
    "    zonstd1  Zonal standard deviation (n-1)",
    "             For every latitude the standard deviation over all longitudes is computed. Normalize by (n-1). ",
    "    zonvar   Zonal variance",
    "             For every latitude the variance over all longitudes is computed. Normalize by n.",
    "    zonvar1  Zonal variance (n-1)",
    "             For every latitude the variance over all longitudes is computed. Normalize by (n-1).",
    "    zonpctl  Zonal percentiles",
    "             For every latitude the pth percentile over all longitudes is computed.",
    "",
    "PARAMETER",
    "    p  FLOAT  Percentile number in {0, ..., 100}",
    NULL
};

static const char *MerstatHelp[] = {
    "NAME",
    "    mermin, mermax, mersum, mermean, meravg, merstd, merstd1, mervar, mervar1, ",
    "    merpctl - Meridional statistical values",
    "",
    "SYNOPSIS",
    "    <operator>  ifile ofile",
    "    merpctl,p  ifile ofile",
    "",
    "DESCRIPTION",
    "    This module computes meridional statistical values of the input fields.",
    "    According to the chosen operator the meridional minimum, maximum, sum, average,",
    "    variance, standard deviation or a certain percentile is written to ofile.",
    "    This operator requires all variables on the same regular lon/lat grid.",
    "",
    "OPERATORS",
    "    mermin   Meridional minimum",
    "             For every longitude the minimum over all latitudes is computed.",
    "    mermax   Meridional maximum",
    "             For every longitude the maximum over all latitudes is computed.",
    "    mersum   Meridional sum",
    "             For every longitude the sum over all latitudes is computed.",
    "    mermean  Meridional mean",
    "             For every longitude the area weighted mean over all latitudes is computed.",
    "    meravg   Meridional average",
    "             For every longitude the area weighted average over all latitudes is computed.",
    "    merstd   Meridional standard deviation",
    "             For every longitude the standard deviation over all latitudes is computed. Normalize by n.",
    "    merstd1  Meridional standard deviation (n-1)",
    "             For every longitude the standard deviation over all latitudes is computed. Normalize by (n-1).",
    "    mervar   Meridional variance",
    "             For every longitude the variance over all latitudes is computed. Normalize by n.",
    "    mervar1  Meridional variance (n-1)",
    "             For every longitude the variance over all latitudes is computed. Normalize by (n-1).",
    "    merpctl  Meridional percentiles",
    "             For every longitude the pth percentile over all latitudes is computed.",
    "",
    "PARAMETER",
    "    p  FLOAT  Percentile number in {0, ..., 100}",
    NULL
};

static const char *GridboxstatHelp[] = {
    "NAME",
    "    gridboxmin, gridboxmax, gridboxsum, gridboxmean, gridboxavg, gridboxstd, ",
    "    gridboxstd1, gridboxvar, gridboxvar1 - Statistical values over grid boxes",
    "",
    "SYNOPSIS",
    "    <operator>,nx,ny  ifile ofile",
    "",
    "DESCRIPTION",
    "    This module computes statistical values over surrounding grid boxes.",
    "    According to the chosen operator the minimum, maximum, sum, average, ",
    "    variance, or standard deviation of the neighboring grid boxes is written to ofile.",
    "    All gridbox operators only works on quadrilateral curvilinear grids.",
    "",
    "OPERATORS",
    "    gridboxmin   Gridbox minimum",
    "                 Minimum value of the selected grid boxes.",
    "    gridboxmax   Gridbox maximum",
    "                 Maximum value of the selected grid boxes.",
    "    gridboxsum   Gridbox sum",
    "                 Sum of the selected grid boxes.",
    "    gridboxmean  Gridbox mean",
    "                 Mean of the selected grid boxes.",
    "    gridboxavg   Gridbox average",
    "                 Average of the selected grid boxes.",
    "    gridboxstd   Gridbox standard deviation",
    "                 Standard deviation of the selected grid boxes. Normalize by n.",
    "    gridboxstd1  Gridbox standard deviation (n-1)",
    "                 Standard deviation of the selected grid boxes. Normalize by (n-1).",
    "    gridboxvar   Gridbox variance",
    "                 Variance of the selected grid boxes. Normalize by n.",
    "    gridboxvar1  Gridbox variance (n-1)",
    "                 Variance of the selected grid boxes. Normalize by (n-1).",
    "",
    "PARAMETER",
    "    nx  INTEGER  Number of grid boxes in x direction",
    "    ny  INTEGER  Number of grid boxes in y direction",
    NULL
};

static const char *VertstatHelp[] = {
    "NAME",
    "    vertmin, vertmax, vertsum, vertmean, vertavg, vertstd, vertstd1, vertvar, ",
    "    vertvar1 - Vertical statistical values",
    "",
    "SYNOPSIS",
    "    <operator>  ifile ofile",
    "",
    "DESCRIPTION",
    "    This module computes statistical values over all levels of the input variables.",
    "    According to chosen operator the vertical minimum, maximum, sum, average, variance",
    "    or standard deviation is written to ofile.",
    "",
    "OPERATORS",
    "    vertmin   Vertical minimum",
    "              For every gridpoint the minimum over all levels is computed.",
    "    vertmax   Vertical maximum",
    "              For every gridpoint the maximum over all levels is computed.",
    "    vertsum   Vertical sum",
    "              For every gridpoint the sum over all levels is computed.",
    "    vertmean  Vertical mean",
    "              For every gridpoint the layer weighted mean over all levels is computed.",
    "    vertavg   Vertical average",
    "              For every gridpoint the layer weighted average over all levels is computed.",
    "    vertstd   Vertical standard deviation",
    "              For every gridpoint the standard deviation over all levels is computed. Normalize by n.",
    "    vertstd1  Vertical standard deviation (n-1)",
    "              For every gridpoint the standard deviation over all levels is computed. Normalize by (n-1).",
    "    vertvar   Vertical variance",
    "              For every gridpoint the variance over all levels is computed. Normalize by n.",
    "    vertvar1  Vertical variance (n-1)",
    "              For every gridpoint the variance over all levels is computed. Normalize by (n-1).",
    NULL
};

static const char *TimselstatHelp[] = {
    "NAME",
    "    timselmin, timselmax, timselsum, timselmean, timselavg, timselstd, ",
    "    timselstd1, timselvar, timselvar1 - Time range statistical values",
    "",
    "SYNOPSIS",
    "    <operator>,nsets[,noffset[,nskip]]  ifile ofile",
    "",
    "DESCRIPTION",
    "    This module computes statistical values for a selected number of timesteps. According to ",
    "    the chosen operator the minimum, maximum, sum, average, variance or standard deviation of ",
    "    the selected timesteps is written to ofile.",
    "    The time stamp in ofile is from the middle contributing timestep of ifile.",
    "",
    "OPERATORS",
    "    timselmin   Time range minimum",
    "                For every adjacent sequence t1, ...., tn of timesteps of the same ",
    "                selected time range it is",
    "                ",
    "                o(t,x) = min{i(t',x), t1 < t' <= tn}",
    "    timselmax   Time range maximum",
    "                For every adjacent sequence t1, ...., tn of timesteps of the same ",
    "                selected time range it is",
    "                ",
    "                o(t,x) = max{i(t',x), t1 < t' <= tn}",
    "    timselsum   Time range sum",
    "                For every adjacent sequence t1, ...., tn of timesteps of the same ",
    "                selected time range it is",
    "                ",
    "                o(t,x) = sum{i(t',x), t1 < t' <= tn}",
    "    timselmean  Time range mean",
    "                For every adjacent sequence t1, ...., tn of timesteps of the same ",
    "                selected time range it is",
    "                ",
    "                o(t,x) = mean{i(t',x), t1 < t' <= tn}",
    "    timselavg   Time range average",
    "                For every adjacent sequence t1, ...., tn of timesteps of the same ",
    "                selected time range it is",
    "                ",
    "                o(t,x) = avg{i(t',x), t1 < t' <= tn}",
    "    timselstd   Time range standard deviation",
    "                Normalize by n. For every adjacent sequence t1, ...., tn of timesteps of the same ",
    "                selected time range it is",
    "                ",
    "                o(t,x) = std{i(t',x), t1 < t' <= tn}",
    "    timselstd1  Time range standard deviation (n-1)",
    "                Normalize by (n-1). For every adjacent sequence t1, ...., tn of timesteps of the same ",
    "                selected time range it is",
    "                ",
    "                o(t,x) = std1{i(t',x), t1 < t' <= tn}",
    "    timselvar   Time range variance",
    "                Normalize by n. For every adjacent sequence t1, ...., tn of timesteps of the same ",
    "                selected time range it is",
    "                ",
    "                o(t,x) = var{i(t',x), t1 < t' <= tn}",
    "    timselvar1  Time range variance (n-1)",
    "                Normalize by (n-1). For every adjacent sequence t1, ...., tn of timesteps of the same ",
    "                selected time range it is",
    "                ",
    "                o(t,x) = var1{i(t',x), t1 < t' <= tn}",
    "",
    "PARAMETER",
    "    nsets    INTEGER  Number of input timesteps for each output timestep ",
    "    noffset  INTEGER  Number of input timesteps skipped before the first timestep range (optional)",
    "    nskip    INTEGER  Number of input timesteps skipped between timestep ranges (optional)",
    NULL
};

static const char *TimselpctlHelp[] = {
    "NAME",
    "    timselpctl - Time range percentile values",
    "",
    "SYNOPSIS",
    "    timselpctl,p,nsets[,noffset[,nskip]]  ifile1 ifile2 ifile3 ofile",
    "",
    "DESCRIPTION",
    "    This operator computes percentile values over a selected number of timesteps in ifile1.",
    "    The algorithm uses histograms with minimum and maximum bounds given in ifile2 and ifile3,",
    "    respectively. The default number of histogram bins is 101. The default can be overridden by setting the",
    "    environment variable CDO_PCTL_NBINS to a different value. The files ifile2 and ifile3 ",
    "    should be the result of corresponding timselmin and timselmax operations, respectively.",
    "    The time stamp in ofile is from the middle contributing timestep of ifile1.",
    "    For every adjacent sequence t1, ...., tn of timesteps of the same ",
    "    selected time range it is",
    "    ",
    "    o(t,x) = pth percentile {i(t',x), t1 < t' <= tn}",
    "",
    "PARAMETER",
    "    p        FLOAT    Percentile number in {0, ..., 100}",
    "    nsets    INTEGER  Number of input timesteps for each output timestep ",
    "    noffset  INTEGER  Number of input timesteps skipped before the first timestep range (optional)",
    "    nskip    INTEGER  Number of input timesteps skipped between timestep ranges (optional)",
    "",
    "ENVIRONMENT",
    "    CDO_PCTL_NBINS",
    "        Sets the number of histogram bins. The default number is 101.",
    NULL
};

static const char *RunstatHelp[] = {
    "NAME",
    "    runmin, runmax, runsum, runmean, runavg, runstd, runstd1, runvar, runvar1 - ",
    "    Running statistical values",
    "",
    "SYNOPSIS",
    "    <operator>,nts  ifile ofile",
    "",
    "DESCRIPTION",
    "    This module computes running statistical values over a selected number of timesteps. Depending on ",
    "    the chosen operator the minimum, maximum, sum, average, variance or standard deviation of a selected ",
    "    number of consecutive timesteps read from ifile is written to ofile. ",
    "    The time stamp in ofile is from the middle contributing timestep of ifile.",
    "",
    "OPERATORS",
    "    runmin   Running minimum",
    "             o(t+(nts-1)/2,x) = min{i(t,x), i(t+1,x), ..., i(t+nts-1,x)}",
    "    runmax   Running maximum",
    "             o(t+(nts-1)/2,x) = max{i(t,x), i(t+1,x), ..., i(t+nts-1,x)}",
    "    runsum   Running sum",
    "             o(t+(nts-1)/2,x) = sum{i(t,x), i(t+1,x), ..., i(t+nts-1,x)}",
    "    runmean  Running mean",
    "             o(t+(nts-1)/2,x) = mean{i(t,x), i(t+1,x), ..., i(t+nts-1,x)}",
    "    runavg   Running average",
    "             o(t+(nts-1)/2,x) = avg{i(t,x), i(t+1,x), ..., i(t+nts-1,x)}",
    "    runstd   Running standard deviation",
    "             Normalize by n. ",
    "             ",
    "             o(t+(nts-1)/2,x) = std{i(t,x), i(t+1,x), ..., i(t+nts-1,x)}",
    "    runstd1  Running standard deviation (n-1)",
    "             Normalize by (n-1). ",
    "             ",
    "             o(t+(nts-1)/2,x) = std1{i(t,x), i(t+1,x), ..., i(t+nts-1,x)}",
    "    runvar   Running variance",
    "             Normalize by n. ",
    "             ",
    "             o(t+(nts-1)/2,x) = var{i(t,x), i(t+1,x), ..., i(t+nts-1,x)}",
    "    runvar1  Running variance (n-1)",
    "             Normalize by (n-1). ",
    "             ",
    "             o(t+(nts-1)/2,x) = var1{i(t,x), i(t+1,x), ..., i(t+nts-1,x)}",
    "",
    "PARAMETER",
    "    nts  INTEGER  Number of timesteps",
    "",
    "ENVIRONMENT",
    "    CDO_TIMESTAT_DATE",
    "        Sets the time stamp in ofile to the \"first\", \"middle\" or \"last\" contributing timestep of ifile.",
    NULL
};

static const char *RunpctlHelp[] = {
    "NAME",
    "    runpctl - Running percentile values",
    "",
    "SYNOPSIS",
    "    runpctl,p,nts  ifile ofile",
    "",
    "DESCRIPTION",
    "    This module computes running percentiles over a selected number of timesteps in ifile.",
    "    The time stamp in ofile is from the middle contributing timestep of ifile.",
    "    ",
    "    o(t+(nts-1)/2,x) = pth percentile {i(t,x), i(t+1,x), ..., i(t+nts-1,x)}",
    "",
    "PARAMETER",
    "    p    FLOAT    Percentile number in {0, ..., 100}",
    "    nts  INTEGER  Number of timesteps",
    NULL
};

static const char *TimstatHelp[] = {
    "NAME",
    "    timmin, timmax, timsum, timmean, timavg, timstd, timstd1, timvar, timvar1 - ",
    "    Statistical values over all timesteps",
    "",
    "SYNOPSIS",
    "    <operator>  ifile ofile",
    "",
    "DESCRIPTION",
    "    This module computes statistical  values over all timesteps in ifile. Depending on ",
    "    the chosen operator the minimum, maximum, sum, average, variance or standard deviation of ",
    "    all timesteps read from ifile is written to ofile.",
    "    The time stamp in ofile is from the middle contributing timestep of ifile.",
    "",
    "OPERATORS",
    "    timmin   Time minimum",
    "             o(1,x) = min{i(t',x), t_1<t'<=t_n}",
    "    timmax   Time maximum",
    "             o(1,x) = max{i(t',x), t_1<t'<=t_n}",
    "    timsum   Time sum",
    "             o(1,x) = sum{i(t',x), t_1<t'<=t_n}",
    "    timmean  Time mean",
    "             o(1,x) = mean{i(t',x), t_1<t'<=t_n}",
    "    timavg   Time average",
    "             o(1,x) = avg{i(t',x), t_1<t'<=t_n}",
    "    timstd   Time standard deviation",
    "             Normalize by n. ",
    "             ",
    "             o(1,x) = std{i(t',x), t_1<t'<=t_n}",
    "    timstd1  Time standard deviation (n-1)",
    "             Normalize by (n-1). ",
    "             ",
    "             o(1,x) = std1{i(t',x), t_1<t'<=t_n}",
    "    timvar   Time variance",
    "             Normalize by n. ",
    "             ",
    "             o(1,x) = var{i(t',x), t_1<t'<=t_n}",
    "    timvar1  Time variance (n-1)",
    "             Normalize by (n-1). ",
    "             ",
    "             o(1,x) = var1{i(t',x), t_1<t'<=t_n}",
    NULL
};

static const char *TimpctlHelp[] = {
    "NAME",
    "    timpctl - Percentile values over all timesteps",
    "",
    "SYNOPSIS",
    "    timpctl,p  ifile1 ifile2 ifile3 ofile",
    "",
    "DESCRIPTION",
    "    This operator computes percentiles over all timesteps in ifile1. The algorithm uses ",
    "    histograms with minimum and maximum bounds given in ifile2 and ifile3, respectively. ",
    "    The default number of histogram bins is 101. The default can be overridden by setting the",
    "    environment variable CDO_PCTL_NBINS to a different value. The files ifile2 and ifile3",
    "    should be the result of corresponding timmin and timmax operations, respectively.",
    "    The time stamp in ofile is from the middle contributing timestep of ifile1.",
    "    ",
    "    o(1,x) = pth percentile {i(t',x), t_1<t'<=t_n}",
    "",
    "PARAMETER",
    "    p  FLOAT  Percentile number in {0, ..., 100}",
    "",
    "ENVIRONMENT",
    "    CDO_PCTL_NBINS",
    "        Sets the number of histogram bins. The default number is 101.",
    NULL
};

static const char *HourstatHelp[] = {
    "NAME",
    "    hourmin, hourmax, hoursum, hourmean, houravg, hourstd, hourstd1, hourvar, ",
    "    hourvar1 - Hourly statistical values",
    "",
    "SYNOPSIS",
    "    <operator>  ifile ofile",
    "",
    "DESCRIPTION",
    "    This module computes statistical values over timesteps of the same hour.",
    "    Depending on the chosen operator the minimum, maximum, sum, average, variance",
    "    or standard deviation of timesteps of the same hour is written to ofile.",
    "    The time stamp in ofile is from the middle contributing timestep of ifile.",
    "",
    "OPERATORS",
    "    hourmin   Hourly minimum",
    "              For every adjacent sequence t_1, ...,t_n of timesteps of the same hour it is:",
    "              ",
    "              o(t,x) = min{i(t',x), t_1<t'<=t_n}",
    "    hourmax   Hourly maximum",
    "              For every adjacent sequence t_1, ...,t_n of timesteps of the same hour it is:",
    "              ",
    "              o(t,x) = max{i(t',x), t_1<t'<=t_n}",
    "    hoursum   Hourly sum",
    "              For every adjacent sequence t_1, ...,t_n of timesteps of the same hour it is:",
    "              ",
    "              o(t,x) = sum{i(t',x), t_1<t'<=t_n}",
    "    hourmean  Hourly mean",
    "              For every adjacent sequence t_1, ...,t_n of timesteps of the same hour it is:",
    "              ",
    "              o(t,x) = mean{i(t',x), t_1<t'<=t_n}",
    "    houravg   Hourly average",
    "              For every adjacent sequence t_1, ...,t_n of timesteps of the same hour it is:",
    "              ",
    "              o(t,x) = avg{i(t',x), t_1<t'<=t_n}",
    "    hourstd   Hourly standard deviation",
    "              Normalize by n. For every adjacent sequence t_1, ...,t_n of timesteps of the same hour it is:",
    "              ",
    "              o(t,x) = std{i(t',x), t_1<t'<=t_n}",
    "    hourstd1  Hourly standard deviation (n-1)",
    "              Normalize by (n-1). For every adjacent sequence t_1, ...,t_n of timesteps of the same hour it is:",
    "              ",
    "              o(t,x) = std1{i(t',x), t_1<t'<=t_n}",
    "    hourvar   Hourly variance",
    "              Normalize by n. For every adjacent sequence t_1, ...,t_n of timesteps of the same hour it is:",
    "              ",
    "              o(t,x) = var{i(t',x), t_1<t'<=t_n}",
    "    hourvar1  Hourly variance (n-1)",
    "              Normalize by (n-1). For every adjacent sequence t_1, ...,t_n of timesteps of the same hour it is:",
    "              ",
    "              o(t,x) = var1{i(t',x), t_1<t'<=t_n}",
    NULL
};

static const char *HourpctlHelp[] = {
    "NAME",
    "    hourpctl - Hourly percentile values",
    "",
    "SYNOPSIS",
    "    hourpctl,p  ifile1 ifile2 ifile3 ofile",
    "",
    "DESCRIPTION",
    "    This operator computes percentiles over all timesteps of the same hour in ifile1.",
    "    The algorithm uses histograms with minimum and maximum bounds given in",
    "    ifile2 and ifile3, respectively. The default number of",
    "    histogram bins is 101. The default can be overridden by setting the",
    "    environment variable CDO_PCTL_NBINS to a different value. The files",
    "    ifile2 and ifile3 should be the result of corresponding",
    "    hourmin and hourmax operations, respectively.",
    "    The time stamp in ofile is from the middle contributing timestep of ifile1.",
    "    For every adjacent sequence t_1, ...,t_n of timesteps of the same hour it is:",
    "    ",
    "    o(t,x) = pth percentile {i(t',x), t_1<t'<=t_n}",
    "",
    "PARAMETER",
    "    p  FLOAT  Percentile number in {0, ..., 100}",
    "",
    "ENVIRONMENT",
    "    CDO_PCTL_NBINS",
    "        Sets the number of histogram bins. The default number is 101.",
    NULL
};

static const char *DaystatHelp[] = {
    "NAME",
    "    daymin, daymax, daysum, daymean, dayavg, daystd, daystd1, dayvar, dayvar1 - ",
    "    Daily statistical values",
    "",
    "SYNOPSIS",
    "    <operator>  ifile ofile",
    "",
    "DESCRIPTION",
    "    This module computes statistical values over timesteps of the same day.",
    "    Depending on the chosen operator the minimum, maximum, sum, average, variance",
    "    or standard deviation of timesteps of the same day is written to ofile.",
    "    The time stamp in ofile is from the middle contributing timestep of ifile.",
    "",
    "OPERATORS",
    "    daymin   Daily minimum",
    "             For every adjacent sequence t_1, ...,t_n of timesteps of the same day it is",
    "             ",
    "             o(t,x) = min{i(t',x), t_1<t'<=t_n}",
    "    daymax   Daily maximum",
    "             For every adjacent sequence t_1, ...,t_n of timesteps of the same day it is",
    "             ",
    "             o(t,x) = max{i(t',x), t_1<t'<=t_n}",
    "    daysum   Daily sum",
    "             For every adjacent sequence t_1, ...,t_n of timesteps of the same day it is",
    "             ",
    "             o(t,x) = sum{i(t',x), t_1<t'<=t_n}",
    "    daymean  Daily mean",
    "             For every adjacent sequence t_1, ...,t_n of timesteps of the same day it is",
    "             ",
    "             o(t,x) = mean{i(t',x), t_1<t'<=t_n}",
    "    dayavg   Daily average",
    "             For every adjacent sequence t_1, ...,t_n of timesteps of the same day it is",
    "             ",
    "             o(t,x) = avg{i(t',x), t_1<t'<=t_n}",
    "    daystd   Daily standard deviation",
    "             Normalize by n. For every adjacent sequence t_1, ...,t_n of timesteps of the same day it is",
    "             ",
    "             o(t,x) = std{i(t',x), t_1<t'<=t_n}",
    "    daystd1  Daily standard deviation (n-1)",
    "             Normalize by (n-1). For every adjacent sequence t_1, ...,t_n of timesteps of the same day it is",
    "             ",
    "             o(t,x) = std1{i(t',x), t_1<t'<=t_n}",
    "    dayvar   Daily variance",
    "             Normalize by n. For every adjacent sequence t_1, ...,t_n of timesteps of the same day it is",
    "             ",
    "             o(t,x) = var{i(t',x), t_1<t'<=t_n}",
    "    dayvar1  Daily variance (n-1)",
    "             Normalize by (n-1). For every adjacent sequence t_1, ...,t_n of timesteps of the same day it is",
    "             ",
    "             o(t,x) = var1{i(t',x), t_1<t'<=t_n}",
    NULL
};

static const char *DaypctlHelp[] = {
    "NAME",
    "    daypctl - Daily percentile values",
    "",
    "SYNOPSIS",
    "    daypctl,p  ifile1 ifile2 ifile3 ofile",
    "",
    "DESCRIPTION",
    "    This operator computes percentiles over all timesteps of the same day in ifile1.",
    "    The algorithm uses histograms with minimum and maximum bounds given in",
    "    ifile2 and ifile3, respectively. The default number of",
    "    histogram bins is 101. The default can be overridden by defining the",
    "    environment variable CDO_PCTL_NBINS. The files ifile2 and",
    "    ifile3 should be the result of corresponding daymin and daymax",
    "    operations, respectively.",
    "    The time stamp in ofile is from the middle contributing timestep of ifile1.",
    "    For every adjacent sequence t_1, ...,t_n of timesteps of the same day it is",
    "    ",
    "    o(t,x) = pth percentile {i(t',x), t_1<t'<=t_n}",
    "",
    "PARAMETER",
    "    p  FLOAT  Percentile number in {0, ..., 100}",
    "",
    "ENVIRONMENT",
    "    CDO_PCTL_NBINS",
    "        Sets the number of histogram bins. The default number is 101.",
    NULL
};

static const char *MonstatHelp[] = {
    "NAME",
    "    monmin, monmax, monsum, monmean, monavg, monstd, monstd1, monvar, monvar1 - ",
    "    Monthly statistical values",
    "",
    "SYNOPSIS",
    "    <operator>  ifile ofile",
    "",
    "DESCRIPTION",
    "    This module computes statistical values over timesteps of the same month.",
    "    Depending on the chosen operator the minimum, maximum, sum, average, variance",
    "    or standard deviation of timesteps of the same month is written to ofile.",
    "    The time stamp in ofile is from the middle contributing timestep of ifile.",
    "",
    "OPERATORS",
    "    monmin   Monthly minimum",
    "             For every adjacent sequence t_1, ...,t_n of timesteps of the same month it is:",
    "             ",
    "             o(t,x) = min{i(t',x), t_1<t'<=t_n}",
    "    monmax   Monthly maximum",
    "             For every adjacent sequence t_1, ...,t_n of timesteps of the same month it is",
    "             ",
    "             o(t,x) = max{i(t',x), t_1<t'<=t_n}",
    "    monsum   Monthly sum",
    "             For every adjacent sequence t_1, ...,t_n of timesteps of the same month it is",
    "             ",
    "             o(t,x) = sum{i(t',x), t_1<t'<=t_n}",
    "    monmean  Monthly mean",
    "             For every adjacent sequence t_1, ...,t_n of timesteps of the same month it is",
    "             ",
    "             o(t,x) = mean{i(t',x), t_1<t'<=t_n}",
    "    monavg   Monthly average",
    "             For every adjacent sequence t_1, ...,t_n of timesteps of the same month it is",
    "             ",
    "             o(t,x) = avg{i(t',x), t_1<t'<=t_n}",
    "    monstd   Monthly standard deviation",
    "             Normalize by n. For every adjacent sequence t_1, ...,t_n of timesteps of the same month it is",
    "             ",
    "             o(t,x) = std{i(t',x), t_1 < t' <= t_n}",
    "    monstd1  Monthly standard deviation (n-1)",
    "             Normalize by (n-1). For every adjacent sequence t_1, ...,t_n of timesteps of the same month it is",
    "             ",
    "             o(t,x) = std1{i(t',x), t_1 < t' <= t_n}",
    "    monvar   Monthly variance",
    "             Normalize by n. For every adjacent sequence t_1, ...,t_n of timesteps of the same month it is",
    "             ",
    "             o(t,x) = var{i(t',x), t_1 < t' <= t_n}",
    "    monvar1  Monthly variance (n-1)",
    "             Normalize by (n-1). For every adjacent sequence t_1, ...,t_n of timesteps of the same month it is",
    "             ",
    "             o(t,x) = var1{i(t',x), t_1 < t' <= t_n}",
    NULL
};

static const char *MonpctlHelp[] = {
    "NAME",
    "    monpctl - Monthly percentile values",
    "",
    "SYNOPSIS",
    "    monpctl,p  ifile1 ifile2 ifile3 ofile",
    "",
    "DESCRIPTION",
    "    This operator computes percentiles over all timesteps of the same month in ifile1.",
    "    The algorithm uses histograms with minimum and maximum bounds given in",
    "    ifile2 and ifile3, respectively. The default number of",
    "    histogram bins is 101. The default can be overridden by setting the",
    "    environment variable CDO_PCTL_NBINS to a different value. The files",
    "    ifile2 and ifile3 should be the result of corresponding",
    "    monmin and monmax operations, respectively.",
    "    The time stamp in ofile is from the middle contributing timestep of ifile1.",
    "    For every adjacent sequence t_1, ...,t_n of timesteps of the same month it is:",
    "    ",
    "    o(t,x) = pth percentile {i(t',x), t_1<t'<=t_n}",
    "",
    "PARAMETER",
    "    p  FLOAT  Percentile number in {0, ..., 100}",
    "",
    "ENVIRONMENT",
    "    CDO_PCTL_NBINS",
    "        Sets the number of histogram bins. The default number is 101.",
    NULL
};

static const char *YearmonstatHelp[] = {
    "NAME",
    "    yearmonmean - Yearly mean from monthly data",
    "",
    "SYNOPSIS",
    "    yearmonmean  ifile ofile",
    "",
    "DESCRIPTION",
    "    This operator computes the yearly mean of a monthly time series.",
    "    Each month is weighted with the number of days per month. ",
    "    The time stamp in ofile is from the middle contributing timestep of ifile.",
    "    ",
    "    For every adjacent sequence t_1, ...,t_n of timesteps of the same year it is",
    "    ",
    "    o(t,x) = mean{i(t',x), t_1<t'<=t_n}",
    "",
    "ENVIRONMENT",
    "    CDO_TIMESTAT_DATE",
    "        Sets the date information in ofile to the \"first\", \"middle\" or \"last\" contributing timestep of ifile.",
    NULL
};

static const char *YearstatHelp[] = {
    "NAME",
    "    yearmin, yearmax, yearsum, yearmean, yearavg, yearstd, yearstd1, yearvar, ",
    "    yearvar1 - Yearly statistical values",
    "",
    "SYNOPSIS",
    "    <operator>  ifile ofile",
    "",
    "DESCRIPTION",
    "    This module computes statistical values over timesteps of the same year.",
    "    Depending on the chosen operator the minimum, maximum, sum, average, variance",
    "    or standard deviation of timesteps of the same year is written to ofile.",
    "    The time stamp in ofile is from the middle contributing timestep of ifile.",
    "",
    "OPERATORS",
    "    yearmin   Yearly minimum",
    "              For every adjacent sequence t_1, ...,t_n of timesteps of the same year it is",
    "              ",
    "              o(t,x) = min{i(t',x), t_1<t'<=t_n}",
    "    yearmax   Yearly maximum",
    "              For every adjacent sequence t_1, ...,t_n of timesteps of the same year it is",
    "              ",
    "              o(t,x) = max{i(t',x), t_1<t'<=t_n}",
    "    yearsum   Yearly sum",
    "              For every adjacent sequence t_1, ...,t_n of timesteps of the same year it is",
    "              ",
    "              o(t,x) = sum{i(t',x), t_1<t'<=t_n}",
    "    yearmean  Yearly mean",
    "              For every adjacent sequence t_1, ...,t_n of timesteps of the same year it is",
    "              ",
    "              o(t,x) = mean{i(t',x), t_1<t'<=t_n}",
    "    yearavg   Yearly average",
    "              For every adjacent sequence t_1, ...,t_n of timesteps of the same year it is",
    "              ",
    "              o(t,x) = avg{i(t',x), t_1<t'<=t_n}",
    "    yearstd   Yearly standard deviation",
    "              Normalize by n. For every adjacent sequence t_1, ...,t_n of timesteps of the same year it is",
    "              ",
    "              o(t,x) = std{i(t',x), t_1 < t' <= t_n}",
    "    yearstd1  Yearly standard deviation (n-1)",
    "              Normalize by (n-1). For every adjacent sequence t_1, ...,t_n of timesteps of the same year it is",
    "              ",
    "              o(t,x) = std1{i(t',x), t_1 < t' <= t_n}",
    "    yearvar   Yearly variance",
    "              Normalize by n. For every adjacent sequence t_1, ...,t_n of timesteps of the same year it is",
    "              ",
    "              o(t,x) = var{i(t',x), t_1 < t' <= t_n}",
    "    yearvar1  Yearly variance (n-1)",
    "              Normalize by (n-1). For every adjacent sequence t_1, ...,t_n of timesteps of the same year it is",
    "              ",
    "              o(t,x) = var1{i(t',x), t_1 < t' <= t_n}",
    "",
    "NOTE",
    "    The operators yearmean and yearavg compute only arithmetical means!",
    NULL
};

static const char *YearpctlHelp[] = {
    "NAME",
    "    yearpctl - Yearly percentile values",
    "",
    "SYNOPSIS",
    "    yearpctl,p  ifile1 ifile2 ifile3 ofile",
    "",
    "DESCRIPTION",
    "    This operator computes percentiles over all timesteps of the same year in ifile1.",
    "    The algorithm uses histograms with minimum and maximum bounds given in",
    "    ifile2 and ifile3, respectively. The default number of",
    "    histogram bins is 101. The default can be overridden by setting the",
    "    environment variable CDO_PCTL_NBINS to a different value. The files",
    "    ifile2 and ifile3 should be the result of corresponding",
    "    yearmin and yearmax operations, respectively.",
    "    The time stamp in ofile is from the middle contributing timestep of ifile1.",
    "    For every adjacent sequence t_1, ...,t_n of timesteps of the same year it is",
    "    ",
    "    o(t,x) = pth percentile {i(t',x), t_1<t'<=t_n}",
    "",
    "PARAMETER",
    "    p  FLOAT  Percentile number in {0, ..., 100}",
    "",
    "ENVIRONMENT",
    "    CDO_PCTL_NBINS",
    "        Sets the number of histogram bins. The default number is 101.",
    NULL
};

static const char *SeasstatHelp[] = {
    "NAME",
    "    seasmin, seasmax, seassum, seasmean, seasavg, seasstd, seasstd1, seasvar, ",
    "    seasvar1 - Seasonal statistical values",
    "",
    "SYNOPSIS",
    "    <operator>  ifile ofile",
    "",
    "DESCRIPTION",
    "    This module computes statistical values over timesteps of the same season.",
    "    Depending on the chosen operator the minimum, maximum, sum, average, variance",
    "    or standard deviation of timesteps of the same season is written to ofile.",
    "    The time stamp in ofile is from the middle contributing timestep of ifile.",
    "    Be careful about the first and the last output timestep, they may be incorrect values ",
    "    if the seasons have incomplete timesteps.",
    "",
    "OPERATORS",
    "    seasmin   Seasonal minimum",
    "              For every adjacent sequence t_1, ...,t_n of timesteps of the same season it is",
    "              ",
    "              o(t,x) = min{i(t',x), t1 < t' <= tn}",
    "    seasmax   Seasonal maximum",
    "              For every adjacent sequence t_1, ...,t_n of timesteps of the same season it is",
    "              ",
    "              o(t,x) = max{i(t',x), t1 < t' <= tn}",
    "    seassum   Seasonal sum",
    "              For every adjacent sequence t_1, ...,t_n of timesteps of the same season it is",
    "              ",
    "              o(t,x) = sum{i(t',x), t1 < t' <= tn}",
    "    seasmean  Seasonal mean",
    "              For every adjacent sequence t_1, ...,t_n of timesteps of the same season it is",
    "              ",
    "              o(t,x) = mean{i(t',x), t1 < t' <= tn}",
    "    seasavg   Seasonal average",
    "              For every adjacent sequence t_1, ...,t_n of timesteps of the same season it is",
    "              ",
    "              o(t,x) = avg{i(t',x), t1 < t' <= tn}",
    "    seasstd   Seasonal standard deviation",
    "              Normalize by n. For every adjacent sequence t_1, ...,t_n of timesteps of the same season it is",
    "              ",
    "              o(t,x) = std{i(t',x), t1 < t' <= tn}",
    "    seasstd1  Seasonal standard deviation (n-1)",
    "              Normalize by (n-1). For every adjacent sequence t_1, ...,t_n of timesteps of the same season it is",
    "              ",
    "              o(t,x) = std1{i(t',x), t1 < t' <= tn}",
    "    seasvar   Seasonal variance",
    "              Normalize by n. For every adjacent sequence t_1, ...,t_n of timesteps of the same season it is",
    "              ",
    "              o(t,x) = var{i(t',x), t1 < t' <= tn}",
    "    seasvar1  Seasonal variance (n-1)",
    "              Normalize by (n-1). For every adjacent sequence t_1, ...,t_n of timesteps of the same season it is",
    "              ",
    "              o(t,x) = var1{i(t',x), t1 < t' <= tn}",
    NULL
};

static const char *SeaspctlHelp[] = {
    "NAME",
    "    seaspctl - Seasonal percentile values",
    "",
    "SYNOPSIS",
    "    seaspctl,p  ifile1 ifile2 ifile3 ofile",
    "",
    "DESCRIPTION",
    "    This operator computes percentiles over all timesteps in ifile1 of the same season.",
    "    The algorithm uses histograms with minimum and maximum bounds given in ifile2 and ifile3,",
    "    respectively. The default number of histogram bins is 101. The default can be overridden by setting ",
    "    the environment variable CDO_PCTL_NBINS to a different value. The files ifile2 and ",
    "    ifile3 should be the result of corresponding seasmin and seasmax operations, respectively.",
    "    The time stamp in ofile is from the middle contributing timestep of ifile1.",
    "    Be careful about the first and the last output timestep, they may be incorrect values ",
    "    if the seasons have incomplete timesteps.",
    "    For every adjacent sequence t_1, ...,t_n of timesteps of the same season it is",
    "    ",
    "    o(t,x) = pth percentile {i(t',x), t1 < t' <= tn}",
    "",
    "PARAMETER",
    "    p  FLOAT  Percentile number in {0, ..., 100}",
    "",
    "ENVIRONMENT",
    "    CDO_PCTL_NBINS",
    "        Sets the number of histogram bins. The default number is 101.",
    NULL
};

static const char *YhourstatHelp[] = {
    "NAME",
    "    yhourmin, yhourmax, yhoursum, yhourmean, yhouravg, yhourstd, yhourstd1, ",
    "    yhourvar, yhourvar1 - Multi-year hourly statistical values",
    "",
    "SYNOPSIS",
    "    <operator>  ifile ofile",
    "",
    "DESCRIPTION",
    "    This module computes statistical values of each hour and day of year.",
    "    Depending on the chosen operator the minimum, maximum, sum, average, variance",
    "    or standard deviation of each hour and day of year in ifile is written to ofile.",
    "    The date information in an output field is the date of the last contributing input field.",
    "",
    "OPERATORS",
    "    yhourmin   Multi-year hourly minimum",
    "               o(0001,x) = min{i(t,x), day(i(t)) = 0001}",
    "                                ...",
    "               o(8784,x) = min{i(t,x), day(i(t)) = 8784}",
    "    yhourmax   Multi-year hourly maximum",
    "               o(0001,x) = max{i(t,x), day(i(t)) = 0001}",
    "                                ...",
    "               o(8784,x) = max{i(t,x), day(i(t)) = 8784}",
    "    yhoursum   Multi-year hourly sum",
    "               o(0001,x) = sum{i(t,x), day(i(t)) = 0001}",
    "                                ...",
    "               o(8784,x) = sum{i(t,x), day(i(t)) = 8784}",
    "    yhourmean  Multi-year hourly mean",
    "               o(0001,x) = mean{i(t,x), day(i(t)) = 0001}",
    "                                ...",
    "               o(8784,x) = mean{i(t,x), day(i(t)) = 8784}",
    "    yhouravg   Multi-year hourly average",
    "               o(0001,x) = avg{i(t,x), day(i(t)) = 0001}",
    "                                ...",
    "               o(8784,x) = avg{i(t,x), day(i(t)) = 8784}",
    "    yhourstd   Multi-year hourly standard deviation",
    "               Normalize by n. ",
    "               ",
    "               o(0001,x) = std{i(t,x), day(i(t)) = 0001}",
    "                                ...",
    "               o(8784,x) = std{i(t,x), day(i(t)) = 8784}",
    "    yhourstd1  Multi-year hourly standard deviation (n-1)",
    "               Normalize by (n-1). ",
    "               ",
    "               o(0001,x) = std1{i(t,x), day(i(t)) = 0001}",
    "                                ...",
    "               o(8784,x) = std1{i(t,x), day(i(t)) = 8784}",
    "    yhourvar   Multi-year hourly variance",
    "               Normalize by n. ",
    "               ",
    "               o(0001,x) = var{i(t,x), day(i(t)) = 0001}",
    "                                ...",
    "               o(8784,x) = var{i(t,x), day(i(t)) = 8784}",
    "    yhourvar1  Multi-year hourly variance (n-1)",
    "               Normalize by (n-1). ",
    "               ",
    "               o(0001,x) = var1{i(t,x), day(i(t)) = 0001}",
    "                                ...",
    "               o(8784,x) = var1{i(t,x), day(i(t)) = 8784}",
    NULL
};

static const char *YdaystatHelp[] = {
    "NAME",
    "    ydaymin, ydaymax, ydaysum, ydaymean, ydayavg, ydaystd, ydaystd1, ydayvar, ",
    "    ydayvar1 - Multi-year daily statistical values",
    "",
    "SYNOPSIS",
    "    <operator>  ifile ofile",
    "",
    "DESCRIPTION",
    "    This module computes statistical values of each day of year.",
    "    Depending on the chosen operator the minimum, maximum, sum, average, variance",
    "    or standard deviation of each day of year in ifile is written to ofile.",
    "    The date information in an output field is the date of the last contributing input field.",
    "",
    "OPERATORS",
    "    ydaymin   Multi-year daily minimum",
    "              o(001,x) = min{i(t,x), day(i(t)) = 001}",
    "                               ...",
    "              o(366,x) = min{i(t,x), day(i(t)) = 366}",
    "    ydaymax   Multi-year daily maximum",
    "              o(001,x) = max{i(t,x), day(i(t)) = 001}",
    "                               ...",
    "              o(366,x) = max{i(t,x), day(i(t)) = 366}",
    "    ydaysum   Multi-year daily sum",
    "              o(001,x) = sum{i(t,x), day(i(t)) = 001}",
    "                               ...",
    "              o(366,x) = sum{i(t,x), day(i(t)) = 366}",
    "    ydaymean  Multi-year daily mean",
    "              o(001,x) = mean{i(t,x), day(i(t)) = 001}",
    "                               ...",
    "              o(366,x) = mean{i(t,x), day(i(t)) = 366}",
    "    ydayavg   Multi-year daily average",
    "              o(001,x) = avg{i(t,x), day(i(t)) = 001}",
    "                               ...",
    "              o(366,x) = avg{i(t,x), day(i(t)) = 366}",
    "    ydaystd   Multi-year daily standard deviation",
    "              Normalize by n. ",
    "              ",
    "              o(001,x) = std{i(t,x), day(i(t)) = 001}",
    "                               ...",
    "              o(366,x) = std{i(t,x), day(i(t)) = 366}",
    "    ydaystd1  Multi-year daily standard deviation (n-1)",
    "              Normalize by (n-1). ",
    "              ",
    "              o(001,x) = std1{i(t,x), day(i(t)) = 001}",
    "                               ...",
    "              o(366,x) = std1{i(t,x), day(i(t)) = 366}",
    "    ydayvar   Multi-year daily variance",
    "              Normalize by n. ",
    "              ",
    "              o(001,x) = var{i(t,x), day(i(t)) = 001}",
    "                               ...",
    "              o(366,x) = var{i(t,x), day(i(t)) = 366}",
    "    ydayvar1  Multi-year daily variance (n-1)",
    "              Normalize by (n-1). ",
    "              ",
    "              o(001,x) = var1{i(t,x), day(i(t)) = 001}",
    "                               ...",
    "              o(366,x) = var1{i(t,x), day(i(t)) = 366}",
    NULL
};

static const char *YdaypctlHelp[] = {
    "NAME",
    "    ydaypctl - Multi-year daily percentile values",
    "",
    "SYNOPSIS",
    "    ydaypctl,p  ifile1 ifile2 ifile3 ofile",
    "",
    "DESCRIPTION",
    "    This operator writes a certain percentile of each day of year in ifile1 to ofile.",
    "    The algorithm uses histograms with minimum and maximum bounds given in ifile2 and",
    "    ifile3, respectively. The default number of histogram bins is 101. The default can be",
    "    overridden by setting the environment variable CDO_PCTL_NBINS to a different value.",
    "    The files ifile2 and ifile3 should be the result of corresponding ydaymin and",
    "    ydaymax operations, respectively.",
    "    The date information in an output field is the date of the last contributing input field.",
    "    ",
    "    o(001,x) = pth percentile {i(t,x), day(i(t)) = 001}",
    "                     ...",
    "    o(366,x) = pth percentile {i(t,x), day(i(t)) = 366}",
    "",
    "PARAMETER",
    "    p  FLOAT  Percentile number in {0, ..., 100}",
    "",
    "ENVIRONMENT",
    "    CDO_PCTL_NBINS",
    "        Sets the number of histogram bins. The default number is 101.",
    NULL
};

static const char *YmonstatHelp[] = {
    "NAME",
    "    ymonmin, ymonmax, ymonsum, ymonmean, ymonavg, ymonstd, ymonstd1, ymonvar, ",
    "    ymonvar1 - Multi-year monthly statistical values",
    "",
    "SYNOPSIS",
    "    <operator>  ifile ofile",
    "",
    "DESCRIPTION",
    "    This module computes statistical values of each month of year.",
    "    Depending on the chosen operator the minimum, maximum, sum, average, variance",
    "    or standard deviation of each month of year in ifile is written to ofile.",
    "    The date information in an output field is the date of the last contributing input field.",
    "",
    "OPERATORS",
    "    ymonmin   Multi-year monthly minimum",
    "              o(01,x) = min{i(t,x), month(i(t)) = 01}",
    "                               ...",
    "              o(12,x) = min{i(t,x), month(i(t)) = 12}",
    "    ymonmax   Multi-year monthly maximum",
    "              o(01,x) = max{i(t,x), month(i(t)) = 01}",
    "                               ...",
    "              o(12,x) = max{i(t,x), month(i(t)) = 12}",
    "    ymonsum   Multi-year monthly sum",
    "              o(01,x) = sum{i(t,x), month(i(t)) = 01}",
    "                               ...",
    "              o(12,x) = sum{i(t,x), month(i(t)) = 12}",
    "    ymonmean  Multi-year monthly mean",
    "              o(01,x) = mean{i(t,x), month(i(t)) = 01}",
    "                               ...",
    "              o(12,x) = mean{i(t,x), month(i(t)) = 12}",
    "    ymonavg   Multi-year monthly average",
    "              o(01,x) = avg{i(t,x), month(i(t)) = 01}",
    "                               ...",
    "              o(12,x) = avg{i(t,x), month(i(t)) = 12}",
    "    ymonstd   Multi-year monthly standard deviation",
    "              Normalize by n. ",
    "              ",
    "              o(01,x) = std{i(t,x), month(i(t)) = 01}",
    "                               ...",
    "              o(12,x) = std{i(t,x), month(i(t)) = 12}",
    "    ymonstd1  Multi-year monthly standard deviation (n-1)",
    "              Normalize by (n-1). ",
    "              ",
    "              o(01,x) = std1{i(t,x), month(i(t)) = 01}",
    "                               ...",
    "              o(12,x) = std1{i(t,x), month(i(t)) = 12}",
    "    ymonvar   Multi-year monthly variance",
    "              Normalize by n. ",
    "              ",
    "              o(01,x) = var{i(t,x), month(i(t)) = 01}",
    "                               ...",
    "              o(12,x) = var{i(t,x), month(i(t)) = 12}",
    "    ymonvar1  Multi-year monthly variance (n-1)",
    "              Normalize by (n-1). ",
    "              ",
    "              o(01,x) = var1{i(t,x), month(i(t)) = 01}",
    "                               ...",
    "              o(12,x) = var1{i(t,x), month(i(t)) = 12}",
    NULL
};

static const char *YmonpctlHelp[] = {
    "NAME",
    "    ymonpctl - Multi-year monthly percentile values",
    "",
    "SYNOPSIS",
    "    ymonpctl,p  ifile1 ifile2 ifile3 ofile",
    "",
    "DESCRIPTION",
    "    This operator writes a certain percentile of each month of year in ifile1 to ofile.",
    "    The algorithm uses histograms with minimum and maximum bounds given in",
    "    ifile2 and ifile3, respectively. The default number of",
    "    histogram bins is 101. The default can be overridden by setting the",
    "    environment variable CDO_PCTL_NBINS to a different value. The files",
    "    ifile2 and ifile3 should be the result of corresponding",
    "    ymonmin and ymonmax operations, respectively.",
    "    The date information in an output field is the date of the last",
    "    contributing input field.",
    "    ",
    "    o(01,x) = pth percentile {i(t,x), month(i(t)) = 01}",
    "                     ...",
    "    o(12,x) = pth percentile {i(t,x), month(i(t)) = 12}",
    "",
    "PARAMETER",
    "    p  FLOAT  Percentile number in {0, ..., 100}",
    "",
    "ENVIRONMENT",
    "    CDO_PCTL_NBINS",
    "        Sets the number of histogram bins. The default number is 101.",
    NULL
};

static const char *YseasstatHelp[] = {
    "NAME",
    "    yseasmin, yseasmax, yseassum, yseasmean, yseasavg, yseasstd, yseasstd1, ",
    "    yseasvar, yseasvar1 - Multi-year seasonal statistical values",
    "",
    "SYNOPSIS",
    "    <operator>  ifile ofile",
    "",
    "DESCRIPTION",
    "    This module computes statistical values of each season.",
    "    Depending on the chosen operator the minimum, maximum, sum, average, variance",
    "    or standard deviation of each season in ifile is written to ofile.",
    "    The date information in an output field is the date of the last contributing input field.",
    "",
    "OPERATORS",
    "    yseasmin   Multi-year seasonal minimum",
    "               o(1,x) = min{i(t,x), month(i(t)) = 12, 01, 02}",
    "               o(2,x) = min{i(t,x), month(i(t)) = 03, 04, 05}",
    "               o(3,x) = min{i(t,x), month(i(t)) = 06, 07, 08}",
    "               o(4,x) = min{i(t,x), month(i(t)) = 09, 10, 11}",
    "    yseasmax   Multi-year seasonal maximum",
    "               o(1,x) = max{i(t,x), month(i(t)) = 12, 01, 02}",
    "               o(2,x) = max{i(t,x), month(i(t)) = 03, 04, 05}",
    "               o(3,x) = max{i(t,x), month(i(t)) = 06, 07, 08}",
    "               o(4,x) = max{i(t,x), month(i(t)) = 09, 10, 11}",
    "    yseassum   Multi-year seasonal sum",
    "               o(1,x) = sum{i(t,x), month(i(t)) = 12, 01, 02}",
    "               o(2,x) = sum{i(t,x), month(i(t)) = 03, 04, 05}",
    "               o(3,x) = sum{i(t,x), month(i(t)) = 06, 07, 08}",
    "               o(4,x) = sum{i(t,x), month(i(t)) = 09, 10, 11}",
    "    yseasmean  Multi-year seasonal mean",
    "               o(1,x) = mean{i(t,x), month(i(t)) = 12, 01, 02}",
    "               o(2,x) = mean{i(t,x), month(i(t)) = 03, 04, 05}",
    "               o(3,x) = mean{i(t,x), month(i(t)) = 06, 07, 08}",
    "               o(4,x) = mean{i(t,x), month(i(t)) = 09, 10, 11}",
    "    yseasavg   Multi-year seasonal average",
    "               o(1,x) = avg{i(t,x), month(i(t)) = 12, 01, 02}",
    "               o(2,x) = avg{i(t,x), month(i(t)) = 03, 04, 05}",
    "               o(3,x) = avg{i(t,x), month(i(t)) = 06, 07, 08}",
    "               o(4,x) = avg{i(t,x), month(i(t)) = 09, 10, 11}",
    "    yseasstd   Multi-year seasonal standard deviation",
    "               o(1,x) = std{i(t,x), month(i(t)) = 12, 01, 02}",
    "               o(2,x) = std{i(t,x), month(i(t)) = 03, 04, 05}",
    "               o(3,x) = std{i(t,x), month(i(t)) = 06, 07, 08}",
    "               o(4,x) = std{i(t,x), month(i(t)) = 09, 10, 11}",
    "    yseasstd1  Multi-year seasonal standard deviation (n-1)",
    "               o(1,x) = std1{i(t,x), month(i(t)) = 12, 01, 02}",
    "               o(2,x) = std1{i(t,x), month(i(t)) = 03, 04, 05}",
    "               o(3,x) = std1{i(t,x), month(i(t)) = 06, 07, 08}",
    "               o(4,x) = std1{i(t,x), month(i(t)) = 09, 10, 11}",
    "    yseasvar   Multi-year seasonal variance",
    "               o(1,x) = var{i(t,x), month(i(t)) = 12, 01, 02}",
    "               o(2,x) = var{i(t,x), month(i(t)) = 03, 04, 05}",
    "               o(3,x) = var{i(t,x), month(i(t)) = 06, 07, 08}",
    "               o(4,x) = var{i(t,x), month(i(t)) = 09, 10, 11}",
    "    yseasvar1  Multi-year seasonal variance (n-1)",
    "               o(1,x) = var1{i(t,x), month(i(t)) = 12, 01, 02}",
    "               o(2,x) = var1{i(t,x), month(i(t)) = 03, 04, 05}",
    "               o(3,x) = var1{i(t,x), month(i(t)) = 06, 07, 08}",
    "               o(4,x) = var1{i(t,x), month(i(t)) = 09, 10, 11}",
    NULL
};

static const char *YseaspctlHelp[] = {
    "NAME",
    "    yseaspctl - Multi-year seasonal percentile values",
    "",
    "SYNOPSIS",
    "    yseaspctl,p  ifile1 ifile2 ifile3 ofile",
    "",
    "DESCRIPTION",
    "    This operator writes a certain percentile of each season in ifile1 to ofile.",
    "    The algorithm uses histograms with minimum and maximum bounds given in",
    "    ifile2 and ifile3, respectively. The default number of",
    "    histogram bins is 101. The default can be overridden by setting the",
    "    environment variable CDO_PCTL_NBINS to a different value. The files",
    "    ifile2 and ifile3 should be the result of corresponding",
    "    yseasmin and yseasmax operations, respectively.",
    "    The date information in an output field is the date of the last",
    "    contributing input field.",
    "    ",
    "    o(1,x) = pth percentile {i(t,x), month(i(t)) = 12, 01, 02}",
    "    o(2,x) = pth percentile {i(t,x), month(i(t)) = 03, 04, 05}",
    "    o(3,x) = pth percentile {i(t,x), month(i(t)) = 06, 07, 08}",
    "    o(4,x) = pth percentile {i(t,x), month(i(t)) = 09, 10, 11}",
    "",
    "PARAMETER",
    "    p  FLOAT  Percentile number in {0, ..., 100}",
    "",
    "ENVIRONMENT",
    "    CDO_PCTL_NBINS",
    "        Sets the number of histogram bins. The default number is 101.",
    NULL
};

static const char *YdrunstatHelp[] = {
    "NAME",
    "    ydrunmin, ydrunmax, ydrunsum, ydrunmean, ydrunavg, ydrunstd, ydrunstd1, ",
    "    ydrunvar, ydrunvar1 - Multi-year daily running statistical values",
    "",
    "SYNOPSIS",
    "    <operator>,nts  ifile ofile",
    "",
    "DESCRIPTION",
    "    This module writes running statistical values for each day of year in ifile to ofile.",
    "    Depending on the chosen operator, the minimum, maximum, sum, average, variance or standard deviation ",
    "    of all timesteps in running windows of which the medium timestep corresponds to a certain day of",
    "    year is computed. The date information in an output field is the date of the timestep in the middle ",
    "    of the last contributing running window.",
    "    Note that the operator have to be applied to a continuous time series of daily measurements in order ",
    "    to yield physically meaningful results. Also note that the output time series begins (nts-1)/2 timesteps",
    "    after the first timestep of the input time series and ends (nts-1)/2 timesteps before the last one.",
    "    For input data which are complete but not continuous, such as time series of daily measurements for ",
    "    the same month or season within different years, the operator yields physically meaningful results ",
    "    only if the input time series does include the (nts-1)/2 days before and after each period of interest.",
    "",
    "OPERATORS",
    "    ydrunmin   Multi-year daily running minimum",
    "               o(001,x) = min{i(t,x), i(t+1,x), ..., i(t+nts-1,x); day[(i(t+(nts-1)/2)] = 001}",
    "                                ...",
    "               o(366,x) = min{i(t,x), i(t+1,x), ..., i(t+nts-1,x); day[(i(t+(nts-1)/2)] = 366}",
    "    ydrunmax   Multi-year daily running maximum",
    "               o(001,x) = max{i(t,x), i(t+1,x), ..., i(t+nts-1,x); day[(i(t+(nts-1)/2)] = 001}",
    "                                ...",
    "               o(366,x) = max{i(t,x), i(t+1,x), ..., i(t+nts-1,x); day[(i(t+(nts-1)/2)] = 366}",
    "    ydrunsum   Multi-year daily running sum",
    "               o(001,x) = sum{i(t,x), i(t+1,x), ..., i(t+nts-1,x); day[(i(t+(nts-1)/2)] = 001}",
    "                                ...",
    "               o(366,x) = sum{i(t,x), i(t+1,x), ..., i(t+nts-1,x); day[(i(t+(nts-1)/2)] = 366}",
    "    ydrunmean  Multi-year daily running mean",
    "               o(001,x) = mean{i(t,x), i(t+1,x), ..., i(t+nts-1,x); day[(i(t+(nts-1)/2)] = 001}",
    "                                ...",
    "               o(366,x) = mean{i(t,x), i(t+1,x), ..., i(t+nts-1,x); day[(i(t+(nts-1)/2)] = 366}",
    "    ydrunavg   Multi-year daily running average",
    "               o(001,x) = avg{i(t,x), i(t+1,x), ..., i(t+nts-1,x); day[(i(t+(nts-1)/2)] = 001}",
    "                                ...",
    "               o(366,x) = avg{i(t,x), i(t+1,x), ..., i(t+nts-1,x); day[(i(t+(nts-1)/2)] = 366}",
    "    ydrunstd   Multi-year daily running standard deviation",
    "               Normalize by n. ",
    "               ",
    "               o(001,x) = std{i(t,x), i(t+1,x), ..., i(t+nts-1,x); day[i(t+(nts-1)/2)] = 001}",
    "                                ...",
    "               o(366,x) = std{i(t,x), i(t+1,x), ..., i(t+nts-1,x); day[i(t+(nts-1)/2)] = 366}",
    "    ydrunstd1  Multi-year daily running standard deviation (n-1)",
    "               Normalize by (n-1). ",
    "               ",
    "               o(001,x) = std1{i(t,x), i(t+1,x), ..., i(t+nts-1,x); day[i(t+(nts-1)/2)] = 001}",
    "                                ...",
    "               o(366,x) = std1{i(t,x), i(t+1,x), ..., i(t+nts-1,x); day[i(t+(nts-1)/2)] = 366}",
    "    ydrunvar   Multi-year daily running variance",
    "               Normalize by n. ",
    "               ",
    "               o(001,x) = var{i(t,x), i(t+1,x), ..., i(t+nts-1,x); day[(i(t+(nts-1)/2)] = 001}",
    "                                ...",
    "               o(366,x) = var{i(t,x), i(t+1,x), ..., i(t+nts-1,x); day[(i(t+(nts-1)/2)] = 366}",
    "    ydrunvar1  Multi-year daily running variance (n-1)",
    "               Normalize by (n-1). ",
    "               ",
    "               o(001,x) = var1{i(t,x), i(t+1,x), ..., i(t+nts-1,x); day[(i(t+(nts-1)/2)] = 001}",
    "                                ...",
    "               o(366,x) = var1{i(t,x), i(t+1,x), ..., i(t+nts-1,x); day[(i(t+(nts-1)/2)] = 366}",
    "",
    "PARAMETER",
    "    nts  INTEGER  Number of timesteps",
    NULL
};

static const char *YdrunpctlHelp[] = {
    "NAME",
    "    ydrunpctl - Multi-year daily running percentile values",
    "",
    "SYNOPSIS",
    "    ydrunpctl,p,nts  ifile1 ifile2 ifile3 ofile",
    "",
    "DESCRIPTION",
    "    This operator writes running percentile values for each day of year in ifile1 to ofile. ",
    "    A certain percentile is computed for all timesteps in running windows of which the medium ",
    "    timestep corresponds to a certain day of year. ",
    "    The algorithm uses histograms with minimum and maximum bounds given in ifile2 and ifile3,",
    "    respectively. The default number of histogram bins is 101. The default can be overridden",
    "    by setting the environment variable CDO_PCTL_NBINS to a different value. The files ifile2 ",
    "    and ifile3 should be the result of corresponding ydrunmin and ydrunmax operations, respectively.",
    "    The date information in an output field is the date of the timestep in the middle of the last ",
    "    contributing running window.",
    "    Note that the operator have to be applied to a continuous time series of daily measurements ",
    "    in order to yield physically meaningful results. Also note that the output time series begins",
    "    (nts-1)/2 timesteps after the first timestep of the input time series and ends (nts-1)/2 ",
    "    timesteps before the last.",
    "    For input data which are complete but not continuous, such as time series of daily measurements ",
    "    for the same month or season within different years, the operator only yields physically meaningful ",
    "    results if the input time series does include the (nts-1)/2 days before and after each period ",
    "    of interest.",
    "    ",
    "    o(001,x) = pth percentile {i(t,x), i(t+1,x), ..., i(t+nts-1,x); day[(i(t+(nts-1)/2)] = 001}",
    "                     ...",
    "    o(366,x) = pth percentile {i(t,x), i(t+1,x), ..., i(t+nts-1,x); day[(i(t+(nts-1)/2)] = 366}",
    "",
    "PARAMETER",
    "    p    FLOAT    Percentile number in {0, ..., 100}",
    "    nts  INTEGER  Number of timesteps",
    "",
    "ENVIRONMENT",
    "    CDO_PCTL_NBINS",
    "        Sets the number of histogram bins. The default number is 101.",
    NULL
};

static const char *FldcorHelp[] = {
    "NAME",
    "    fldcor - Correlation in grid space",
    "",
    "SYNOPSIS",
    "    fldcor  ifile1 ifile2 ofile",
    "",
    "DESCRIPTION",
    "    The correlation coefficient is a quantity that gives the quality of a least ",
    "    squares fitting to the original data. This operator correlates all gridpoints",
    "    of two fields for each timestep. With",
    "    ",
    "    S(t) = {x, i_1(t,x) != missval and i_2(t,x) != missval}",
    "    it is",
    "    ",
    "    o(t,1) = Cor{(i_1(t,x), i_2(t,x)), x_1 < x <= x_n}",
    "    where w(x) are the area weights obtained by the input streams.",
    "    For every timestep t only those field elements x belong to the sample,",
    "    which have i_1(t,x) != missval and i_2(t,x) != missval.",
    NULL
};

static const char *TimcorHelp[] = {
    "NAME",
    "    timcor - Correlation over time",
    "",
    "SYNOPSIS",
    "    timcor  ifile1 ifile2 ofile",
    "",
    "DESCRIPTION",
    "    The correlation coefficient is a quantity that gives the quality of a least ",
    "    squares fitting to the original data. This operator correlates each gridpoint",
    "    of two fields over all timesteps. With",
    "    ",
    "    S(x) = {t, i_1(t,x) != missval and i_2(t,x) != missval}",
    "    it is",
    "    ",
    "    o(1,x) = Cor{(i_1(t,x), i_2(t,x)), t_1 < t <= t_n}",
    "    For every gridpoint x only those timesteps t belong to the sample,",
    "    which have i_1(t,x) != missval and i_2(t,x) != missval.",
    NULL
};

static const char *FldcovarHelp[] = {
    "NAME",
    "    fldcovar - Covariance in grid space",
    "",
    "SYNOPSIS",
    "    fldcovar  ifile1 ifile2 ofile",
    "",
    "DESCRIPTION",
    "    This operator calculates the covariance of two fields over all gridpoints",
    "    for each timestep. With",
    "    ",
    "    S(t) = {x, i_1(t,x) != missval and i_2(t,x) != missval}",
    "    it is",
    "    ",
    "    o(t,1) = Covar{(i_1(t,x), i_2(t,x)), x_1 < x <= x_n}",
    "    where w(x) are the area weights obtained by the input streams.",
    "    For every timestep t only those field elements x belong to the sample,",
    "    which have i_1(t,x) != missval and i_2(t,x) != missval.",
    NULL
};

static const char *TimcovarHelp[] = {
    "NAME",
    "    timcovar - Covariance over time",
    "",
    "SYNOPSIS",
    "    timcovar  ifile1 ifile2 ofile",
    "",
    "DESCRIPTION",
    "    This operator calculates the covariance of two fields at each gridpoint",
    "    over all timesteps. With",
    "    ",
    "    S(x) = {t, i_1(t,x) != missval and i_2(t,x) != missval}",
    "    it is",
    "    ",
    "    o(1,x) = Covar{(i_1(t,x), i_2(t,x)), t_1 < t <= t_n}",
    "    For every gridpoint x only those timesteps t belong to the sample,",
    "    which have i_1(t,x) != missval and i_2(t,x) != missval.",
    NULL
};

static const char *RegresHelp[] = {
    "NAME",
    "    regres - Regression",
    "",
    "SYNOPSIS",
    "    regres  ifile ofile",
    "",
    "DESCRIPTION",
    "    The values of the input file ifile are assumed to be distributed as",
    "    N(a+b*t,S^2) with unknown a, b and S^2. This operator estimates the",
    "    parameter b. For every field element x only those timesteps ",
    "    t belong to the sample S(x), which have i(t,x) NE miss.",
    NULL
};

static const char *DetrendHelp[] = {
    "NAME",
    "    detrend - Detrend time series",
    "",
    "SYNOPSIS",
    "    detrend  ifile ofile",
    "",
    "DESCRIPTION",
    "    Every time series in ifile is linearly detrended. For every field element x ",
    "    only those timesteps t belong to the sample S(x), which have i(t,x) NE miss.",
    "",
    "NOTE",
    "    This operator has to keep the fields of all timesteps concurrently in the memory.",
    "    If not enough memory is available use the operators trend and subtrend.",
    NULL
};

static const char *TrendHelp[] = {
    "NAME",
    "    trend - Trend of time series",
    "",
    "SYNOPSIS",
    "    trend  ifile ofile1 ofile2",
    "",
    "DESCRIPTION",
    "    The values of the input file ifile are assumed to be distributed as",
    "    N(a+b*t,S^2) with unknown a, b and S^2. This operator estimates the",
    "    parameter a and b. For every field element x only those timesteps ",
    "    t belong to the sample S(x), which have i(t,x) NE miss.",
    "    Thus the estimation for a is stored in ofile1 and that for b is stored ",
    "    in ofile2. To subtract the trend from the data see operator subtrend.",
    NULL
};

static const char *SubtrendHelp[] = {
    "NAME",
    "    subtrend - Subtract a trend",
    "",
    "SYNOPSIS",
    "    subtrend  ifile1 ifile2 ifile3 ofile",
    "",
    "DESCRIPTION",
    "    This operator is for subtracting a trend computed by the operator trend.",
    "    It is",
    "    ",
    "    o(t,x) = i_1(t,x) - (i_2(1,x) + i_3(1,x)*t)",
    "    where t is the timesteps.",
    NULL
};

static const char *EOFsHelp[] = {
    "NAME",
    "    eof, eoftime, eofspatial, eof3d - Empirical Orthogonal Functions",
    "",
    "SYNOPSIS",
    "    <operator>,neof  ifile ofile1 ofile2",
    "",
    "DESCRIPTION",
    "    This module calculates empirical orthogonal functions of the data in ifile ",
    "    as the eigen values of the scatter matrix (covariance matrix) S of the data",
    "    sample z(t). A more detailed description can be found above.",
    "    ",
    "    Please note, that the input data are assumed to be anomalies.",
    "    ",
    "    If operator eof is chosen, the EOFs are computed in either time or spatial",
    "    space, whichever is the fastest. If the user already knows, which computation",
    "    is faster, the module can be forced to perform a computation in time- or gridspace",
    "    by using the operators eoftime or eofspatial, respectively. This can enhance ",
    "    performance, especially for very long time series, where the number of timesteps",
    "    is larger than the number of grid-points. Data in ifile are assumed to be anomalies.",
    "    If they are not, the behavior of this module is not well defined. ",
    "    After execution ofile1 will contain all eigen-values and ofile2 the",
    "    eigenvectors e_j. All EOFs and eigen-values are computed. However, only the first ",
    "    neof EOFs are written to ofile2. Nonetheless, ofile1 contains all eigen-values. ",
    "    ",
    "    Missing values are not fully supported. Support is only checked for non-changing",
    "    masks of missing values in time. Although there still will be results, they are",
    "    not trustworthy, and a warning will occur. In the latter case we suggest to ",
    "    replace missing values by 0 in ifile. ",
    "",
    "OPERATORS",
    "    eof         Calculate EOFs in spatial or time space",
    "    eoftime     Calculate EOFs in time space",
    "    eofspatial  Calculate EOFs in spatial space",
    "    eof3d       Calculate 3-Dimensional EOFs in time space",
    "",
    "PARAMETER",
    "    neof  INTEGER  Number of eigen functions",
    "",
    "ENVIRONMENT",
    "    CDO_SVD_MODE   ",
    "        Is used to choose the algorithm for eigenvalue calculation. Options are 'jacobi' for ",
    "        a one-sided parallel jacobi-algorithm (only executed in parallel if -P flag is set)",
    "        and  'danielson_lanczos' for a non-parallel d/l algorithm. The default setting is 'jacobi'.",
    "    CDO_WEIGHT_MODE",
    "        It is used to set the weight mode. The default is 'on'. Set it to 'off' for a non weighted version.",
    "    MAX_JACOBI_ITER",
    "        Is the maximum integer number of annihilation sweeps that is executed if the ",
    "        jacobi-algorithm is used to compute the eigen values. The default value is 12.",
    "    FNORM_PRECISION",
    "        Is the Frobenius norm of the matrix consisting of an annihilation pair",
    "        of eigenvectors that is used to determine if the eigenvectors have reached ",
    "        a sufficient level of convergence. If all annihilation-pairs of vectors have ",
    "        a norm below this value, the computation is considered to have converged ",
    "        properly. Otherwise, a warning will occur. The default value 1e-12.",
    NULL
};

static const char *EofcoeffHelp[] = {
    "NAME",
    "    eofcoeff - Principal coefficients of EOFs",
    "",
    "SYNOPSIS",
    "    eofcoeff  ifile1 ifile2 obase",
    "",
    "DESCRIPTION",
    "    This module calculates the time series of the principal coefficients for given EOF",
    "    (empirical orthogonal functions) and data. Time steps in ifile1 are assumed to be the EOFs,",
    "    time steps in ifile2 are assumed to be the time series.",
    "    Note, that this operator calculates a weighted dot product of the fields in ifile1 and ifile2.",
    "    For consistency set the environment variable CDO_WEIGHT_MODE=off when using eof or eof3d.",
    "    ",
    "    There will be a separate file containing a time series of principal coefficients",
    "    with time information from ifile2 for each EOF in ifile1. Output files will be",
    "    numbered as <obase><neof><suffix> where neof+1 is the number of the EOF (timestep)",
    "    in ifile1 and suffix is the filename extension derived from the file format. ",
    "",
    "ENVIRONMENT",
    "    CDO_FILE_SUFFIX",
    "        Set the default file suffix. This suffix will be added to the output file ",
    "        names instead of the filename extension derived from the file format. ",
    "        Set this variable to NULL to disable the adding of a file suffix.",
    NULL
};

static const char *RemapbilHelp[] = {
    "NAME",
    "    remapbil, genbil - Bilinear interpolation",
    "",
    "SYNOPSIS",
    "    <operator>,grid  ifile ofile",
    "",
    "DESCRIPTION",
    "    This module contains operators for a bilinear remapping of fields between grids in spherical coordinates.",
    "    The interpolation is based on an adapted SCRIP library version. ",
    "    For a detailed description of the interpolation method see SCRIP.",
    "    This interpolation method only works on quadrilateral curvilinear source grids.",
    "",
    "OPERATORS",
    "    remapbil  Bilinear interpolation",
    "              Performs a bilinear interpolation on all input fields.",
    "    genbil    Generate bilinear interpolation weights",
    "              Generates bilinear interpolation weights for the first input field and writes the",
    "              result to a file. The format of this file is NetCDF following the SCRIP convention.",
    "              Use the operator remap to apply this remapping weights to a data file with the same source grid.",
    "",
    "PARAMETER",
    "    grid  STRING  Target grid description file or name",
    "",
    "ENVIRONMENT",
    "    REMAP_EXTRAPOLATE",
    "        This variable is used to switch the extrapolation feature 'on' or 'off'.",
    "        By default the extrapolation is enabled for circular grids.",
    NULL
};

static const char *RemapbicHelp[] = {
    "NAME",
    "    remapbic, genbic - Bicubic interpolation",
    "",
    "SYNOPSIS",
    "    <operator>,grid  ifile ofile",
    "",
    "DESCRIPTION",
    "    This module contains operators for a bicubic remapping of fields between grids in spherical coordinates.",
    "    The interpolation is based on an adapted SCRIP library version. ",
    "    For a detailed description of the interpolation method see SCRIP.",
    "    This interpolation method only works on quadrilateral curvilinear source grids.",
    "",
    "OPERATORS",
    "    remapbic  Bicubic interpolation",
    "              Performs a bicubic interpolation on all input fields.",
    "    genbic    Generate bicubic interpolation weights",
    "              Generates bicubic interpolation weights for the first input field and writes the",
    "              result to a file. The format of this file is NetCDF following the SCRIP convention.",
    "              Use the operator remap to apply this remapping weights to a data file with the same source grid.",
    "",
    "PARAMETER",
    "    grid  STRING  Target grid description file or name",
    "",
    "ENVIRONMENT",
    "    REMAP_EXTRAPOLATE",
    "        This variable is used to switch the extrapolation feature 'on' or 'off'.",
    "        By default the extrapolation is enabled for circular grids.",
    NULL
};

static const char *RemapnnHelp[] = {
    "NAME",
    "    remapnn, gennn - Nearest neighbor remapping",
    "",
    "SYNOPSIS",
    "    <operator>,grid  ifile ofile",
    "",
    "DESCRIPTION",
    "    This module contains operators for a nearest neighbor remapping of fields between grids",
    "    in spherical coordinates.",
    "",
    "OPERATORS",
    "    remapnn  Nearest neighbor remapping",
    "             Performs a nearest neighbor remapping on all input fields.",
    "    gennn    Generate nearest neighbor remap weights",
    "             Generates nearest neighbor remapping weights for the first input field and writes the result to a file.",
    "             The format of this file is NetCDF following the SCRIP convention.",
    "             Use the operator remap to apply this remapping weights to a data file with the same source grid.",
    "",
    "PARAMETER",
    "    grid  STRING  Target grid description file or name",
    "",
    "ENVIRONMENT",
    "    REMAP_EXTRAPOLATE    ",
    "        This variable is used to switch the extrapolation feature 'on' or 'off'.",
    "        By default the extrapolation is enabled for this remapping method.",
    "    CDO_GRIDSEARCH_RADIUS",
    "        Grid search radius in degree, default 180 degree.",
    NULL
};

static const char *RemapdisHelp[] = {
    "NAME",
    "    remapdis, gendis - Distance-weighted average remapping",
    "",
    "SYNOPSIS",
    "    remapdis,grid[,neighbors]  ifile ofile",
    "    gendis,grid  ifile ofile",
    "",
    "DESCRIPTION",
    "    This module contains operators for a distance-weighted average remapping of the four",
    "    nearest neighbor values of fields between grids in spherical coordinates.",
    "    The interpolation is based on an adapted SCRIP library version. ",
    "    For a detailed description of the interpolation method see SCRIP.",
    "",
    "OPERATORS",
    "    remapdis  Distance-weighted average remapping",
    "              Performs a distance-weighted average remapping of the nearest neighbors value on all input fields.",
    "              The default number of nearest neighbors is 4.",
    "    gendis    Generate distance-weighted average remap weights",
    "              Generates distance-weighted average remapping weights of the four nearest neighbor",
    "              values for the first input field and writes the result to a file.",
    "              The format of this file is NetCDF following the SCRIP convention.",
    "              Use the operator remap to apply this remapping weights to a data file with the same source grid.",
    "",
    "PARAMETER",
    "    grid       STRING   Target grid description file or name",
    "    neighbors  INTEGER  Number of nearest neighbors",
    "",
    "ENVIRONMENT",
    "    REMAP_EXTRAPOLATE    ",
    "        This variable is used to switch the extrapolation feature 'on' or 'off'.",
    "        By default the extrapolation is enabled for this remapping method.",
    "    CDO_GRIDSEARCH_RADIUS",
    "        Grid search radius in degree, default 180 degree.",
    NULL
};

static const char *RemapyconHelp[] = {
    "NAME",
    "    remapycon, genycon - First order conservative remapping",
    "",
    "SYNOPSIS",
    "    <operator>,grid  ifile ofile",
    "",
    "DESCRIPTION",
    "    This module contains operators for a first order conservative remapping of fields between grids in spherical coordinates.",
    "    The operators in this module uses code from the YAC software package to compute the conservative remapping weights.",
    "    For a detailed description of the interpolation method see YAC.",
    "    The interpolation method is completely general and can be used for any grid on a sphere.",
    "    The search algorithm for the conservative remapping requires that no grid cell occurs more than once. ",
    "",
    "OPERATORS",
    "    remapycon  First order conservative remapping",
    "               Performs a first order conservative remapping on all input fields.",
    "    genycon    Generate 1st order conservative remap weights",
    "               Generates first order conservative remapping weights for the first input field and",
    "               writes the result to a file. The format of this file is NetCDF following the SCRIP convention.",
    "               Use the operator remap to apply this remapping weights to a data file with the same source grid.",
    "",
    "PARAMETER",
    "    grid  STRING  Target grid description file or name",
    "",
    "ENVIRONMENT",
    "    CDO_REMAP_NORM",
    "        This variable is used to choose the normalization of the conservative interpolation. ",
    "        By default CDO_REMAP_NORM is set to 'fracarea'. 'fracarea' uses the sum of the",
    "        non-masked source cell intersected areas to normalize each target cell field value.",
    "        This results in a reasonable flux value but the flux is not locally conserved.",
    "        The option 'destarea' uses the total target cell area to normalize each target cell",
    "        field value. Local flux conservation is ensured, but unreasonable flux values may result.",
    "    REMAP_AREA_MIN",
    "        This variable is used to set the minimum destination area fraction. The default",
    "        of this variable is 0.0.",
    NULL
};

static const char *RemapconHelp[] = {
    "NAME",
    "    remapcon, gencon - First order conservative remapping",
    "",
    "SYNOPSIS",
    "    <operator>,grid  ifile ofile",
    "",
    "DESCRIPTION",
    "    This module contains operators for a first order conservative remapping of fields between grids in spherical coordinates.",
    "    The interpolation is based on an adapted SCRIP library version. ",
    "    For a detailed description of the interpolation method see SCRIP.",
    "    The interpolation method is completely general and can be used for any grid on a sphere.",
    "    The search algorithm for the conservative remapping requires that no grid cell occurs more than once. ",
    "",
    "OPERATORS",
    "    remapcon  First order conservative remapping",
    "              Performs a first order conservative remapping on all input fields.",
    "    gencon    Generate 1st order conservative remap weights",
    "              Generates first order conservative remapping weights for the first input field and",
    "              writes the result to a file. The format of this file is NetCDF following the SCRIP convention.",
    "              Use the operator remap to apply this remapping weights to a data file with the same source grid.",
    "",
    "PARAMETER",
    "    grid  STRING  Target grid description file or name",
    "",
    "ENVIRONMENT",
    "    CDO_REMAP_NORM",
    "        This variable is used to choose the normalization of the conservative interpolation. ",
    "        By default CDO_REMAP_NORM is set to 'fracarea'. 'fracarea' uses the sum of the",
    "        non-masked source cell intersected areas to normalize each target cell field value.",
    "        This results in a reasonable flux value but the flux is not locally conserved.",
    "        The option 'destarea' uses the total target cell area to normalize each target cell",
    "        field value. Local flux conservation is ensured, but unreasonable flux values may result.",
    "    REMAP_AREA_MIN",
    "        This variable is used to set the minimum destination area fraction. The default",
    "        of this variable is 0.0.",
    "",
    "NOTE",
    "    The SCRIP conservative remapping method doesn't work correctly for some grid combinations.",
    "    Please use remapycon or genycon in case of problems. ",
    NULL
};

static const char *Remapcon2Help[] = {
    "NAME",
    "    remapcon2, gencon2 - Second order conservative remapping",
    "",
    "SYNOPSIS",
    "    <operator>,grid  ifile ofile",
    "",
    "DESCRIPTION",
    "    This module contains operators for a second order conservative remapping of fields between grids in spherical coordinates.",
    "    The interpolation is based on an adapted SCRIP library version. ",
    "    For a detailed description of the interpolation method see SCRIP.",
    "    The interpolation method is completely general and can be used for any grid on a sphere.",
    "    The search algorithm for the conservative remapping requires that no grid cell occurs more than once. ",
    "",
    "OPERATORS",
    "    remapcon2  Second order conservative remapping",
    "               Performs a second order conservative remapping on all input fields.",
    "    gencon2    Generate 2nd order conservative remap weights",
    "               Generates second order conservative remapping weights for the first input field and",
    "               writes the result to a file. The format of this file is NetCDF following the SCRIP convention.",
    "               Use the operator remap to apply this remapping weights to a data file with the same source grid.",
    "",
    "PARAMETER",
    "    grid  STRING  Target grid description file or name",
    "",
    "ENVIRONMENT",
    "    CDO_REMAP_NORM",
    "        This variable is used to choose the normalization of the conservative interpolation. ",
    "        By default CDO_REMAP_NORM is set to 'fracarea'. 'fracarea' uses the sum of the",
    "        non-masked source cell intersected areas to normalize each target cell field value.",
    "        This results in a reasonable flux value but the flux is not locally conserved.",
    "        The option 'destarea' uses the total target cell area to normalize each target cell",
    "        field value. Local flux conservation is ensured, but unreasonable flux values may result.",
    "    REMAP_AREA_MIN",
    "        This variable is used to set the minimum destination area fraction. The default",
    "        of this variable is 0.0.",
    "",
    "NOTE",
    "    The SCRIP conservative remapping method doesn't work correctly for some grid combinations.",
    NULL
};

static const char *RemaplafHelp[] = {
    "NAME",
    "    remaplaf, genlaf - Largest area fraction remapping",
    "",
    "SYNOPSIS",
    "    <operator>,grid  ifile ofile",
    "",
    "DESCRIPTION",
    "    This module contains operators for a largest area fraction remapping of fields between grids in spherical coordinates.",
    "    The operators in this module uses code from the YAC software package to compute the largest area fraction.",
    "    For a detailed description of the interpolation method see YAC.",
    "    The interpolation method is completely general and can be used for any grid on a sphere.",
    "    The search algorithm for this remapping method requires that no grid cell occurs more than once. ",
    "",
    "OPERATORS",
    "    remaplaf  Largest area fraction remapping",
    "              Performs a largest area fraction remapping on all input fields.",
    "    genlaf    Generate largest area fraction remap weights",
    "              Generates largest area fraction remapping weights for the first input field and",
    "              writes the result to a file. The format of this file is NetCDF following the SCRIP convention.",
    "              Use the operator remap to apply this remapping weights to a data file with the same source grid.",
    "",
    "PARAMETER",
    "    grid  STRING  Target grid description file or name",
    "",
    "ENVIRONMENT",
    "    REMAP_AREA_MIN",
    "        This variable is used to set the minimum destination area fraction. The default",
    "        of this variable is 0.0.",
    NULL
};

static const char *RemapHelp[] = {
    "NAME",
    "    remap - Grid remapping",
    "",
    "SYNOPSIS",
    "    remap,grid,weights  ifile ofile",
    "",
    "DESCRIPTION",
    "    Interpolation between different horizontal grids can be a very time-consuming ",
    "    process. Especially if the data are on an unstructured and/or a large grid. ",
    "    In this case the interpolation process can be split into two parts.",
    "    Firstly the generation of the interpolation weights, which is the most time-consuming part.",
    "    These interpolation weights can be reused for every remapping process with the operator remap.",
    "    This operator remaps all input fields to a new horizontal grid. The remap type and ",
    "    the interpolation weights of one input grid are read from a NetCDF file. More weights ",
    "    are computed if the input fields are on different grids. The NetCDF file with the ",
    "    weights should follow the SCRIP convention. Normally these weights come from a previous",
    "    call to one of the genXXX operators (e.g. genbil) or were created by the original SCRIP package.",
    "",
    "PARAMETER",
    "    grid     STRING  Target grid description file or name",
    "    weights  STRING  Interpolation weights (SCRIP NetCDF file)",
    "",
    "ENVIRONMENT",
    "    CDO_REMAP_NORM       ",
    "        This variable is used to choose the normalization of the conservative interpolation. ",
    "        By default CDO_REMAP_NORM is set to 'fracarea'. 'fracarea' uses the sum of the",
    "        non-masked source cell intersected areas to normalize each target cell field value.",
    "        This results in a reasonable flux value but the flux is not locally conserved.",
    "        The option 'destarea' uses the total target cell area to normalize each target cell",
    "        field value. Local flux conservation is ensured, but unreasonable flux values may result.",
    "    REMAP_EXTRAPOLATE    ",
    "        This variable is used to switch the extrapolation feature 'on' or 'off'.",
    "        By default the extrapolation is enabled for remapdis, remapnn and for circular grids.",
    "    REMAP_AREA_MIN       ",
    "        This variable is used to set the minimum destination area fraction. The default",
    "        of this variable is 0.0.",
    "    CDO_GRIDSEARCH_RADIUS",
    "        Grid search radius in degree, default 180 degree.",
    NULL
};

static const char *RemapetaHelp[] = {
    "NAME",
    "    remapeta - Remap vertical hybrid level",
    "",
    "SYNOPSIS",
    "    remapeta,vct[,oro]  ifile ofile",
    "",
    "DESCRIPTION",
    "    This operator interpolates between different vertical hybrid levels. This include the preparation ",
    "    of consistent data for the free atmosphere. The procedure for the vertical interpolation is based ",
    "    on the HIRLAM scheme and was adapted from INTERA.",
    "    The vertical interpolation is based on the vertical integration of the hydrostatic equation with ",
    "    few adjustments. The basic tasks are the following one:",
    "    - at first integration of hydrostatic equation",
    "    - extrapolation of surface pressure",
    "    - Planetary Boundary-Layer (PBL) profile interpolation",
    "    - interpolation in free atmosphere",
    "    - merging of both profiles",
    "    - final surface pressure correction",
    "    ",
    "    The vertical interpolation corrects the surface pressure. This is simply a cut-off or an addition ",
    "    of air mass. This mass correction should not influence the geostrophic velocity field in the middle ",
    "    troposhere. Therefore the total mass above a given reference level is conserved. As reference level",
    "    the geopotential height of the 400 hPa level is used. Near the surface the correction can affect ",
    "    the vertical structure of the PBL. Therefore the interpolation is done using the potential temperature. ",
    "    But in the free atmosphere above a certain n (n=0.8 defining the top of the PBL) the interpolation ",
    "    is done linearly. After the interpolation both profiles are merged. With the resulting ",
    "    temperature/pressure correction the hydrostatic equation is integrated again and adjusted to the ",
    "    reference level finding the final surface pressure correction. A more detailed description of",
    "    the interpolation can be found in INTERA. This operator requires all variables on the same horizontal grid.",
    "",
    "PARAMETER",
    "    vct  STRING  File name of an ASCII dataset with the vertical coordinate table",
    "    oro  STRING  File name with the orography (surf. geopotential) of the target dataset (optional)",
    "",
    "ENVIRONMENT",
    "    REMAPETA_PTOP",
    "        Sets the minimum pressure level for condensation.",
    "        Above this level the humidity is set to the constant 1.E-6.",
    "        The default value is 0 Pa.",
    "",
    "NOTE",
    "    The code numbers or the variable names of the required parameter have to follow the ECHAM convention.",
    "    Presently, the vertical coordinate definition of a NetCDF file has also to follow the ECHAM convention.",
    "    This means:",
    "    - the dimension of the full level coordinate and the corresponding variable is called mlev,",
    "    - the dimension of the half level coordinate and the corresponding variable is called ilev (ilev must have one element more than mlev)",
    "    - the hybrid vertical coefficient a is given in units of Pa and called hyai (hyam for level midpoints)",
    "    - the hybrid vertical coefficient b is given in units of 1 and called hybi (hybm for level midpoints)",
    "    - the mlev variable has a borders attribute containing the character string 'ilev'",
    "    ",
    "    Use the sinfo command to test if your vertical coordinate system is recognized as hybrid system.",
    "    ",
    "    In case remapeta complains about not finding any data on hybrid model levels you may wish",
    "    to use the setzaxis command to generate a zaxis description which conforms to the ECHAM convention.",
    "    See section \"1.4 Z-axis description\" for an example how to define a hybrid Z-axis.",
    NULL
};

static const char *VertintmlHelp[] = {
    "NAME",
    "    ml2pl, ml2hl - Vertical interpolation",
    "",
    "SYNOPSIS",
    "    ml2pl,plevels  ifile ofile",
    "    ml2hl,hlevels  ifile ofile",
    "",
    "DESCRIPTION",
    "    Interpolate 3D variables on hybrid sigma pressure level to pressure or height levels.",
    "    The input file should contain the log. surface pressure or the surface pressure.",
    "    To interpolate the temperature, the surface geopotential is also needed.",
    "    The pressure, temperature, and surface geopotential are identified by their GRIB1 code number",
    "    or NetCDF CF standard name.",
    "    Supported parameter tables are: WMO standard table number 2 and ECMWF local table number 128.",
    "    Use the alias  ml2plx/ml2hlx or the environment variable EXTRAPOLATE",
    "    to extrapolate missing values. This operator requires all variables on the same horizontal grid.",
    "    ",
    "",
    "OPERATORS",
    "    ml2pl  Model to pressure level interpolation",
    "           Interpolates 3D variables on hybrid sigma pressure level to pressure level.",
    "    ml2hl  Model to height level interpolation",
    "           Interpolates 3D variables on hybrid sigma pressure level to height level.",
    "           The procedure is the same as for the operator mh2pl except for",
    "           the pressure levels being calculated from the heights by:",
    "           plevel = 101325*exp(hlevel/-7000)",
    "",
    "PARAMETER",
    "    plevels  FLOAT  Pressure levels in pascal",
    "    hlevels  FLOAT  Height levels in meter (max level: 65535 m)",
    "",
    "ENVIRONMENT",
    "    EXTRAPOLATE",
    "        If set to 1 extrapolate missing values.",
    NULL
};

static const char *VertintapHelp[] = {
    "NAME",
    "    ap2pl - Vertical interpolation",
    "",
    "SYNOPSIS",
    "    ap2pl,plevels  ifile ofile",
    "",
    "DESCRIPTION",
    "    Interpolate 3D variables on hybrid sigma height coordinates to pressure levels.",
    "    The input file must contain the 3D air pressure. The air pressure is identified",
    "    by the NetCDF CF standard name air_pressure.",
    "    This operator requires all variables on the same horizontal grid.",
    "",
    "PARAMETER",
    "    plevels  FLOAT  Pressure levels in pascal",
    "",
    "NOTE",
    "    This is a specific implementation for NetCDF files from the ICON model, it may not work with data from other sources.",
    NULL
};

static const char *IntlevelHelp[] = {
    "NAME",
    "    intlevel - Linear level interpolation",
    "",
    "SYNOPSIS",
    "    intlevel,levels  ifile ofile",
    "",
    "DESCRIPTION",
    "    This operator performs a linear vertical interpolation of non hybrid 3D variables.",
    "",
    "PARAMETER",
    "    levels  FLOAT  Target levels",
    NULL
};

static const char *Intlevel3dHelp[] = {
    "NAME",
    "    intlevel3d, intlevelx3d - ",
    "    Linear level interpolation from/to 3d vertical coordinates",
    "",
    "SYNOPSIS",
    "    <operator>,icoordinate  ifile1 ifile2 ofile",
    "",
    "DESCRIPTION",
    "    This operator performs a linear vertical interpolation of 3D variables fields",
    "    with given 3D vertical coordinates.",
    "",
    "OPERATORS",
    "    intlevel3d   Linear level interpolation onto a 3d vertical coordinate",
    "    intlevelx3d  like intlevel3d but with extrapolation",
    "",
    "PARAMETER",
    "    icoordinate  STRING  filename for vertical source coordinates variable",
    "    ifile2       STRING  target vertical coordinate field (intlevel3d only)",
    NULL
};

static const char *InttimeHelp[] = {
    "NAME",
    "    inttime, intntime - Time interpolation",
    "",
    "SYNOPSIS",
    "    inttime,date,time[,inc]  ifile ofile",
    "    intntime,n  ifile ofile",
    "",
    "DESCRIPTION",
    "    This module performs linear interpolation between timesteps.",
    "",
    "OPERATORS",
    "    inttime   Interpolation between timesteps",
    "              This operator creates a new dataset by linear interpolation between timesteps.",
    "              The user has to define the start date/time with an optional increment.",
    "    intntime  Interpolation between timesteps",
    "              This operator performs linear interpolation between timesteps.",
    "              The user has to define the number of timesteps from one timestep to the next.",
    "",
    "PARAMETER",
    "    date  STRING  Start date (format YYYY-MM-DD)",
    "    time  STRING  Start time (format hh:mm:ss)",
    "    inc   STRING  Optional increment (seconds, minutes, hours, days, months, years) [default: 0hour]",
    "    n     INTEGER Number of timesteps from one timestep to the next",
    NULL
};

static const char *IntyearHelp[] = {
    "NAME",
    "    intyear - Year interpolation",
    "",
    "SYNOPSIS",
    "    intyear,years  ifile1 ifile2 obase",
    "",
    "DESCRIPTION",
    "    This operator performs linear interpolation between two years, timestep by timestep.",
    "    The input files need to have the same structure with the same variables.",
    "    The output files will be named <obase><yyyy><suffix> where yyyy will be the year and ",
    "    suffix is the filename extension derived from the file format.",
    "",
    "PARAMETER",
    "    years  INTEGER  Comma separated list of years",
    "",
    "ENVIRONMENT",
    "    CDO_FILE_SUFFIX",
    "        Set the default file suffix. This suffix will be added to the output file ",
    "        names instead of the filename extension derived from the file format. ",
    "        Set this variable to NULL to disable the adding of a file suffix.",
    NULL
};

static const char *SpectralHelp[] = {
    "NAME",
    "    sp2gp, sp2gpl, gp2sp, gp2spl, sp2sp - Spectral transformation",
    "",
    "SYNOPSIS",
    "    <operator>  ifile ofile",
    "    sp2sp,trunc  ifile ofile",
    "",
    "DESCRIPTION",
    "    This module transforms fields on Gaussian grids to spectral coefficients and vice versa.",
    "",
    "OPERATORS",
    "    sp2gp   Spectral to gridpoint",
    "            Convert all fields with spectral coefficients to a regular Gaussian grid. The number of ",
    "            latitudes of the resulting Gaussian grid is calculated from the triangular truncation by:",
    "            ",
    "               nlat = NINT((trunc*3 + 1.)/2.)",
    "    sp2gpl  Spectral to gridpoint (linear)",
    "            Convert all fields with spectral coefficients to a regular Gaussian grid. The number of ",
    "            latitudes of the resulting Gaussian grid is calculated from the triangular truncation by:",
    "            ",
    "               nlat = NINT((trunc*2 + 1.)/2.)",
    "            ",
    "            Use this operator to convert ERA40 data e.g. from TL159 to N80.",
    "    gp2sp   Gridpoint to spectral",
    "            Convert all Gaussian gridpoint fields to spectral coefficients. The triangular truncation ",
    "            of the resulting spherical harmonics is calculated from the number of latitudes by:",
    "            ",
    "               trunc = (nlat*2 - 1) / 3",
    "    gp2spl  Gridpoint to spectral (linear)",
    "            Convert all Gaussian gridpoint fields to spectral coefficients. The triangular truncation ",
    "            of the resulting spherical harmonics is calculated from the number of latitudes by:",
    "            ",
    "               trunc = (nlat*2 - 1) / 2",
    "            ",
    "            Use this operator to convert ERA40 data e.g. from N80 to TL159 instead of T106.",
    "    sp2sp   Spectral to spectral",
    "            Change the triangular truncation of all spectral fields. The operator performs downward ",
    "            conversion by cutting the resolution. Upward conversions are achieved by filling in zeros.",
    "",
    "PARAMETER",
    "    trunc  INTEGER  New spectral resolution",
    NULL
};

static const char *WindHelp[] = {
    "NAME",
    "    dv2uv, dv2uvl, uv2dv, uv2dvl, dv2ps - Wind transformation",
    "",
    "SYNOPSIS",
    "    <operator>  ifile ofile",
    "",
    "DESCRIPTION",
    "    This module converts relative divergence and vorticity to U and V wind and vice versa.",
    "    Divergence and vorticity are spherical harmonic coefficients in spectral space and",
    "    U and V are on a regular Gaussian grid. The Gaussian latitudes needs to be ordered from",
    "    north to south.",
    "",
    "OPERATORS",
    "    dv2uv   Divergence and vorticity to U and V wind",
    "            Calculate U and V wind on a Gaussian grid from spherical harmonic ",
    "            coefficients of relative divergence and vorticity. The divergence and vorticity ",
    "            need to have the names sd and svo or code numbers 155 and 138.",
    "            The number of latitudes of the resulting Gaussian grid is calculated ",
    "            from the triangular truncation by:",
    "            ",
    "               nlat = NINT((trunc*3 + 1.)/2.)",
    "    dv2uvl  Divergence and vorticity to U and V wind (linear)",
    "            Calculate U and V wind on a Gaussian grid from spherical harmonic ",
    "            coefficients of relative divergence and vorticity. The divergence and vorticity ",
    "            need tohave the names sd and svo or code numbers 155 and 138.",
    "            The number of latitudes of the resulting Gaussian grid is calculated ",
    "            from the triangular truncation by:",
    "            ",
    "               nlat = NINT((trunc*2 + 1.)/2.)",
    "    uv2dv   U and V wind to divergence and vorticity",
    "            Calculate spherical harmonic coefficients of relative divergence and vorticity",
    "            from U and V wind. The U and V wind need to be on a Gaussian grid and need to have the ",
    "            names u and v or the code numbers 131 and 132.",
    "            The triangular truncation of the resulting spherical harmonics",
    "            is calculated from the number of latitudes by:",
    "            ",
    "               trunc = (nlat*2 - 1) / 3",
    "    uv2dvl  U and V wind to divergence and vorticity (linear)",
    "            Calculate spherical harmonic coefficients of relative divergence and vorticity",
    "            from U and V wind. The U and V wind need to be on a Gaussian grid and need to have the ",
    "            names u and v or the code numbers 131 and 132.",
    "            The triangular truncation of the resulting spherical harmonics",
    "            is calculated from the number of latitudes by:",
    "            ",
    "               trunc = (nlat*2 - 1) / 2",
    "    dv2ps   D and V to velocity potential and stream function",
    "            Calculate spherical harmonic coefficients of velocity potential and stream function from ",
    "            spherical harmonic coefficients of relative divergence and vorticity. The divergence and ",
    "            vorticity need to have the names sd and svo or code numbers 155 and 138.",
    NULL
};

static const char *ImportbinaryHelp[] = {
    "NAME",
    "    import_binary - Import binary data sets",
    "",
    "SYNOPSIS",
    "    import_binary  ifile ofile",
    "",
    "DESCRIPTION",
    "    This operator imports gridded binary data sets via a GrADS data descriptor file.",
    "    The GrADS data descriptor file contains a complete description of the binary data as well ",
    "    as instructions on where to find the data and how to read it. The descriptor file is an ASCII ",
    "    file that can be created easily with a text editor. The general contents of a gridded data ",
    "    descriptor file are as follows:",
    "    - Filename for the binary data",
    "    - Missing or undefined data value",
    "    - Mapping between grid coordinates and world coordinates",
    "    - Description of variables in the binary data set ",
    "    ",
    "    A detailed description of the components of a GrADS data descriptor file can be found in GrADS.",
    "    Here is a list of the supported components:",
    "    BYTESWAPPED, CHSUB, DSET, ENDVARS, FILEHEADER, HEADERBYTES, OPTIONS, TDEF, TITLE, ",
    "    TRAILERBYTES, UNDEF, VARS, XDEF, XYHEADER, YDEF, ZDEF",
    "",
    "NOTE",
    "    Only 32-bit IEEE floats are supported for standard binary files!",
    NULL
};

static const char *ImportcmsafHelp[] = {
    "NAME",
    "    import_cmsaf - Import CM-SAF HDF5 files",
    "",
    "SYNOPSIS",
    "    import_cmsaf  ifile ofile",
    "",
    "DESCRIPTION",
    "    This operator imports gridded CM-SAF (Satellite Application Facility on Climate Monitoring)",
    "    HDF5 files. CM-SAF exploits data from polar-orbiting and geostationary satellites in order ",
    "    to provide climate monitoring products of the following parameters: ",
    "    ",
    "    Cloud parameters: cloud fraction (CFC), cloud type (CTY), cloud phase (CPH), ",
    "                      cloud top height, pressure and temperature (CTH,CTP,CTT), ",
    "                      cloud optical thickness (COT), cloud water path (CWP).",
    "    ",
    "    Surface radiation components: Surface albedo (SAL); surface incoming (SIS) ",
    "                      and net (SNS) shortwave radiation; surface downward (SDL) ",
    "                      and outgoing (SOL) longwave radiation, surface net longwave ",
    "                      radiation (SNL) and surface radiation budget (SRB).",
    "    ",
    "    Top-of-atmosphere radiation components: Incoming (TIS) and reflected (TRS) ",
    "                      solar radiative flux at top-of-atmosphere. Emitted thermal ",
    "                      radiative flux at top-of-atmosphere (TET).",
    "    ",
    "    Water vapour:     Vertically integrated water vapour (HTW), layered vertically ",
    "                      integrated water vapour and layer mean temperature and relative ",
    "                      humidity for 5 layers (HLW), temperature and mixing ratio at ",
    "                      6 pressure levels. ",
    "    ",
    "    Daily and monthly mean products can be ordered via the CM-SAF web page (www.cmsaf.eu). ",
    "    Products with higher spatial and temporal resolution, i.e. instantaneous swath-based products,",
    "    are available on request (contact.cmsaf@dwd.de). All products are distributed free-of-charge.",
    "    More information on the data is available on the CM-SAF homepage (www.cmsaf.eu).",
    "    ",
    "    Daily and monthly mean products are provided in equal-area projections. CDO reads the ",
    "    projection parameters from the metadata in the HDF5-headers in order to allow spatial ",
    "    operations like remapping. For spatial operations with instantaneous products on original ",
    "    satellite projection, additional files with arrays of latitudes and longitudes are needed.",
    "    These can be obtained from CM-SAF together with the data.",
    "    ",
    "",
    "NOTE",
    "    To use this operator, it is necessary to build CDO with HDF5 support (version 1.6 or higher).",
    "    The PROJ.4 library (version 4.6 or higher) is needed for full support of the remapping",
    "    functionality. ",
    NULL
};

static const char *ImportamsrHelp[] = {
    "NAME",
    "    import_amsr - Import AMSR binary files",
    "",
    "SYNOPSIS",
    "    import_amsr  ifile ofile",
    "",
    "DESCRIPTION",
    "    This operator imports gridded binary AMSR (Advanced Microwave Scanning Radiometer) data.",
    "    The binary data files are available from the AMSR ftp site (ftp://ftp.ssmi.com/amsre).",
    "    Each file consists of twelve (daily) or five (averaged) 0.25 x 0.25 degree ",
    "    grid (1440,720) byte maps. For daily files, six daytime maps in the following",
    "    order, Time (UTC), Sea Surface Temperature (SST), 10 meter Surface Wind Speed (WSPD),",
    "    Atmospheric Water Vapor (VAPOR), Cloud Liquid Water (CLOUD), and Rain Rate (RAIN), ",
    "    are followed by six nighttime maps in the same order. Time-Averaged files contain ",
    "    just the geophysical layers in the same order [SST, WSPD, VAPOR, CLOUD, RAIN].",
    "    More information to the data is available on the AMSR homepage http://www.remss.com/amsr.",
    NULL
};

static const char *InputHelp[] = {
    "NAME",
    "    input, inputsrv, inputext - Formatted input",
    "",
    "SYNOPSIS",
    "    input,grid  ofile",
    "    inputsrv  ofile",
    "    inputext  ofile",
    "",
    "DESCRIPTION",
    "    This module reads time series of one 2D variable from standard input.",
    "    All input fields need to have the same horizontal grid. The format of the ",
    "    input depends on the chosen operator.",
    "",
    "OPERATORS",
    "    input     ASCII input",
    "              Reads fields with ASCII numbers from standard input and stores them",
    "              in ofile. The numbers read are exactly that ones which are written ",
    "              out by the output operator.",
    "    inputsrv  SERVICE ASCII input",
    "              Reads fields with ASCII numbers from standard input and stores them ",
    "              in ofile. Each field should have a header of 8 integers (SERVICE likely).",
    "              The numbers that are read are exactly that ones which are written out by ",
    "              the outputsrv operator.",
    "    inputext  EXTRA ASCII input",
    "              Read fields with ASCII numbers from standard input and stores them ",
    "              in ofile. Each field should have header of 4 integers (EXTRA likely).",
    "              The numbers read are exactly that ones which are written out by ",
    "              the outputext operator.",
    "",
    "PARAMETER",
    "    grid  STRING  Grid description file or name",
    NULL
};

static const char *OutputHelp[] = {
    "NAME",
    "    output, outputf, outputint, outputsrv, outputext - Formatted output",
    "",
    "SYNOPSIS",
    "    output  ifiles",
    "    outputf,format[,nelem]  ifiles",
    "    outputint  ifiles",
    "    outputsrv  ifiles",
    "    outputext  ifiles",
    "",
    "DESCRIPTION",
    "    This module prints all values of all input datasets to standard output.",
    "    All input fields need to have the same horizontal grid. All input files ",
    "    need to have the same structure with the same variables.",
    "    The format of the output depends on the chosen operator.",
    "",
    "OPERATORS",
    "    output     ASCII output",
    "               Prints all values to standard output.",
    "               Each row has 6 elements with the C-style format \"%13.6g\".",
    "    outputf    Formatted output",
    "               Prints all values to standard output.",
    "               The format and number of elements for each row have to be specified by the parameters",
    "               format and nelem. The default for nelem is 1.",
    "    outputint  Integer output",
    "               Prints all values rounded to the nearest integer to standard output.",
    "    outputsrv  SERVICE ASCII output",
    "               Prints all values to standard output.",
    "               Each field with a header of 8 integers (SERVICE likely).",
    "    outputext  EXTRA ASCII output",
    "               Prints all values to standard output.",
    "               Each field with a header of 4 integers (EXTRA likely).",
    "",
    "PARAMETER",
    "    format  STRING  C-style format for one element (e.g. %13.6g)",
    "    nelem   INTEGER Number of elements for each row (default: nelem = 1)",
    NULL
};

static const char *OutputtabHelp[] = {
    "NAME",
    "    outputtab - Table output",
    "",
    "SYNOPSIS",
    "    outputtab,params  ifiles ofile",
    "",
    "DESCRIPTION",
    "    This operator prints a table of all input datasets to standard output.",
    "    ifiles is an arbitrary number of input files. All input files need to have ",
    "    the same structure with the same variables on different timesteps.",
    "    All input fields need to have the same horizontal grid.",
    "    ",
    "    The contents of the table depends on the chosen paramters. The format of each table",
    "    parameter is keyname[:len]. len is the optional length of a table entry.  ",
    "    Here is a list of all valid keynames:",
    "    ",
    "     Keyname    & Type    & Description      ",
    "     value      & FLOAT   & Value of the variable [len:8]",
    "     name       & STRING  & Name of the variable [len:8]",
    "     param      & STRING  & Parameter ID (GRIB1: code[.tabnum]; GRIB2: num[.cat[.dis]]) [len:11]",
    "     code       & INTEGER & Code number [len:4]",
    "     lon        & FLOAT   & Longitude coordinate [len:6]",
    "     lat        & FLOAT   & Latitude coordinate [len:6]",
    "     lev        & FLOAT   & Vertical level [len:6]",
    "     xind       & INTEGER & Grid x index [len:4]",
    "     yind       & INTEGER & Grid y index [len:4]",
    "     timestep   & INTEGER & Timestep number [len:6]",
    "     date       & STRING  & Date (format YYYY-MM-DD) [len:10]",
    "     time       & STRING  & Time (format hh:mm:ss) [len:8]",
    "     year       & INTEGER & Year [len:5]",
    "     month      & INTEGER & Month [len:2]",
    "     day        & INTEGER & Day [len:2]",
    "     nohead     & INTEGER & Disable output of header line",
    "",
    "PARAMETER",
    "    params  STRING   Comma separated list of keynames, one for each column of the table",
    NULL
};

static const char *OutputgmtHelp[] = {
    "NAME",
    "    gmtxyz, gmtcells - GMT output",
    "",
    "SYNOPSIS",
    "    <operator>  ifile",
    "",
    "DESCRIPTION",
    "    This module prints the first field of the input dataset to standard output.",
    "    The output can be used to generate 2D Lon/Lat plots with GMT.",
    "    The format of the output depends on the chosen operator.",
    "",
    "OPERATORS",
    "    gmtxyz    GMT xyz format",
    "              The operator exports the first field to the GMT xyz ASCII format.",
    "              The output can be used to create contour plots with the GMT module pscontour.",
    "    gmtcells  GMT multiple segment format",
    "              The operator exports the first field to the GMT multiple segment ASCII format.",
    "              The output can be used to create shaded gridfill plots with the GMT module psxy.",
    NULL
};

static const char *GradsdesHelp[] = {
    "NAME",
    "    gradsdes - GrADS data descriptor file",
    "",
    "SYNOPSIS",
    "    gradsdes[,mapversion]  ifile",
    "",
    "DESCRIPTION",
    "    Creates a GrADS data descriptor file. Supported file formats are GRIB1, NetCDF, SERVICE, ",
    "    EXTRA and IEG. For GRIB1 files the GrADS map file is also generated. For SERVICE and EXTRA",
    "    files the grid have to be specified with the CDO option '-g <grid>'. This module takes ifile",
    "    in order to create filenames for the descriptor (ifile.ctl) and the map (ifile.gmp) file.",
    "",
    "PARAMETER",
    "    mapversion  INTEGER  Format version of the GrADS map file for GRIB1 datasets. Use 1 for a machine",
    "                specific version 1 GrADS map file, 2 for a machine independent version 2 GrADS map file",
    "                and 4 to support GRIB files >2GB. ",
    "                A version 2 map file can be used only with GrADS version 1.8 or newer.",
    "                A version 4 map file can be used only with GrADS version 2.0 or newer.",
    "                The default is 4 for files >2GB, otherwise 2.",
    NULL
};

static const char *AfterburnerHelp[] = {
    "NAME",
    "    after - ECHAM standard post processor",
    "",
    "SYNOPSIS",
    "    after[,vct]  ifiles ofile",
    "",
    "DESCRIPTION",
    "    The \"afterburner\" is the standard post processor for ECHAM data which provides the following operations:",
    "    ",
    "    - Extract specified variables and levels",
    "    - Compute derived variables",
    "    - Transform spectral data to Gaussian grid representation",
    "    - Vertical interpolation to pressure levels",
    "    - Compute temporal means",
    "    ",
    "    This operator reads selection parameters as namelist from stdin.",
    "    Use the UNIX redirection \"<namelistfile\" to read the namelist from file.",
    "",
    "NAMELIST",
    "    Namelist parameter and there defaults:",
    "      TYPE=0, CODE=-1, LEVEL=-1, INTERVAL=0, MEAN=0, EXTRAPOLATE=0",
    "    ",
    "    TYPE controls the transformation and vertical interpolation. Transforming spectral data to Gaussian grid",
    "    representation and vertical interpolation to pressure levels are performed in a chain of steps.",
    "    The TYPE parameter may be used to stop the chain at a certain step. Valid values are:",
    "    ",
    "      TYPE  =  0 : Hybrid   level spectral coefficients",
    "      TYPE  = 10 : Hybrid   level fourier  coefficients",
    "      TYPE  = 11 : Hybrid   level zonal mean sections",
    "      TYPE  = 20 : Hybrid   level gauss grids",
    "      TYPE  = 30 : Pressure level gauss grids",
    "      TYPE  = 40 : Pressure level fourier  coefficients",
    "      TYPE  = 41 : Pressure level zonal mean sections",
    "      TYPE  = 50 : Pressure level spectral coefficients",
    "      TYPE  = 60 : Pressure level fourier  coefficients",
    "      TYPE  = 61 : Pressure level zonal mean sections",
    "      TYPE  = 70 : Pressure level gauss grids",
    "    ",
    "    Vorticity, divergence, streamfunction and velocity potential need special treatment in the vertical transformation.",
    "    They are not available as types 30, 40 and 41. If you select one of these combinations, type is automatically",
    "    switched to the equivalent types 70, 60 and 61. The type of all other variables will be switched too, because ",
    "    the type is a global parameter.",
    "    ",
    "    CODE selects the variables by the ECHAM GRIB1 code number (1-255). The default value -1 processes all detected codes.",
    "    Derived variables computed by the afterburner:",
    "    ",
    "    Code  & Name      & Longname                       & Level       & Needed Codes/Computation",
    "     34   & low_cld   & low cloud                      & single      & 223 on modellevel  ",
    "     35   & mid_cld   & mid cloud                      & single      & 223 on modellevel  ",
    "     36   & hih_cld   & high cloud                     & single      & 223 on modellevel  ",
    "     131  & u         & u-velocity                     & atm (ml+pl) & 138, 155           ",
    "     132  & v         & v-velocity                     & atm (ml+pl) & 138, 155           ",
    "     135  & omega     & vertical velocity              & atm (ml+pl) & 138, 152, 155      ",
    "     148  & stream    & streamfunction                 & atm (ml+pl) & 131, 132           ",
    "     149  & velopot   & velocity potential             & atm (ml+pl) & 131, 132           ",
    "     151  & slp       & mean sea level pressure        & surface     & 129, 130, 152       ",
    "     156  & geopoth   & geopotential height            & atm (ml+pl) & 129, 130, 133, 152 ",
    "     157  & rhumidity & relative humidity              & atm (ml+pl) & 130, 133, 152      ",
    "     189  & sclfs     & surface solar cloud forcing    & surface     & 176-185            ",
    "     190  & tclfs     & surface thermal cloud forcing  & surface     & 177-186            ",
    "     191  & sclf0     & top solar cloud forcing        & surface     & 178-187             ",
    "     192  & tclf0     & top thermal cloud forcing      & surface     & 179-188            ",
    "     259  & windspeed & windspeed                      & atm (ml+pl) & sqrt(u*u+v*v)      ",
    "     260  & precip    & total precipitation            & surface     & 142+143            ",
    "    ",
    "    LEVEL selects the hybrid or pressure levels. The allowed values depends on the parameter TYPE.",
    "    The default value -1 processes all detected levels.",
    "    ",
    "    INTERVAL selects the processing interval. The default value 0 process data on monthly intervals.",
    "    INTERVAL=1 sets the interval to daily.",
    "    ",
    "    MEAN=1 compute and write monthly or daily mean fields. The default value 0 writes out all timesteps.",
    "    ",
    "    EXTRAPOLATE=0 switch of the extrapolation of missing values during the interpolation from model to pressure",
    "    level (only available with MEAN=0 and TYPE=30). The default value 1 extrapolate missing values.",
    "    ",
    "    Possible combinations of TYPE, CODE and MEAN:",
    "    ",
    "          TYPE   & CODE                    & MEAN",
    "        0/10/11  & 130  temperature        &  0",
    "        0/10/11  & 131  u-velocity         &  0",
    "        0/10/11  & 132  v-velocity         &  0",
    "        0/10/11  & 133  specific humidity  &  0",
    "        0/10/11  & 138  vorticity          &  0",
    "        0/10/11  & 148  streamfunction     &  0",
    "        0/10/11  & 149  velocity potential &  0",
    "        0/10/11  & 152  LnPs               &  0",
    "        0/10/11  & 155  divergence         &  0",
    "         >11     & all codes               &  0/1",
    "",
    "PARAMETER",
    "    vct  STRING  File with VCT in ASCII format",
    NULL
};

static const char *FilterHelp[] = {
    "NAME",
    "    bandpass, lowpass, highpass - Time series filtering",
    "",
    "SYNOPSIS",
    "    bandpass,fmin,fmax  ifile ofile",
    "    lowpass,fmax  ifile ofile",
    "    highpass,fmin  ifile ofile",
    "",
    "DESCRIPTION",
    "    This module takes the time series for each gridpoint in ifile and (fast fourier) transforms it ",
    "    into the frequency domain. According to the particular operator and its parameters certain frequencies ",
    "    are filtered (set to zero) in the frequency domain and the spectrum is (inverse fast fourier) transformed ",
    "    back into the time domain.",
    "    To determine the frequency the time-axis of ifile is used. (Data should have a constant time increment ",
    "    since this assumption applies for transformation. However, the time increment has to be different from zero.)",
    "    All frequencies given as parameter are interpreted per year. This is done by the assumption of a 365-day calendar. ",
    "    Consequently if you want to perform multiyear-filtering accurately you have to delete the 29th of February. ",
    "    If your ifile has a 360 year calendar the frequency parameters fmin respectively fmax should be ",
    "    multiplied with a factor of 360/365 in order to obtain accurate results.  ",
    "    For the set up of a frequency filter the frequency parameters have to be adjusted to a frequency in the data. ",
    "    Here fmin is rounded down and fmax is always rounded up. Consequently it is possible to use bandpass with ",
    "    fmin=fmax without getting a zero-field for ofile. ",
    "    Hints for efficient usage: ",
    "    - to get reliable results the time-series has to be detrended (cdo detrend)",
    "    - the lowest frequency greater zero that can be contained in ifile is 1/(N*dT), ",
    "    - the greatest frequency is 1/(2dT) (Nyquist frequency),",
    "    with N the number of timesteps and dT the time increment of ifile in years. ",
    "",
    "OPERATORS",
    "    bandpass  Bandpass filtering",
    "              Bandpass filtering (pass for frequencies between fmin and fmax).",
    "              Suppresses all variability outside the frequency range specified by [fmin,fmax].",
    "    lowpass   Lowpass filtering",
    "              Lowpass filtering (pass for frequencies lower than fmax).",
    "              Suppresses all variability with frequencies greater than fmax. ",
    "    highpass  Highpass filtering",
    "              Highpass filtering (pass for frequencies greater than fmin). ",
    "              Suppresses all variabilty with frequencies lower than fmin. ",
    "",
    "PARAMETER",
    "    fmin  FLOAT	Minimum frequency per year that passes the filter.",
    "    fmax  FLOAT	Maximum frequency per year that passes the filter.  ",
    NULL
};

static const char *GridcellHelp[] = {
    "NAME",
    "    gridarea, gridweights - Grid cell quantities",
    "",
    "SYNOPSIS",
    "    <operator>  ifile ofile",
    "",
    "DESCRIPTION",
    "    This module reads the grid cell area of the first grid from the input stream.",
    "    If the grid cell area is missing it will be computed from the ",
    "    grid description. Depending on the chosen operator the grid cell area or weights",
    "    are written to the output stream.",
    "",
    "OPERATORS",
    "    gridarea     Grid cell area",
    "                 Writes the grid cell area to the output stream. If the grid cell area have to",
    "                 be computed it is scaled with the earth radius to square meters.",
    "    gridweights  Grid cell weights",
    "                 Writes the grid cell area weights to the output stream.",
    "",
    "ENVIRONMENT",
    "    PLANET_RADIUS",
    "        This variable is used to scale the computed grid cell areas to square meters. ",
    "        By default PLANET_RADIUS is set to an earth radius of 6371000 meter.",
    NULL
};

static const char *Smooth9Help[] = {
    "NAME",
    "    smooth9 - 9 point smoothing",
    "",
    "SYNOPSIS",
    "    smooth9  ifile ofile",
    "",
    "DESCRIPTION",
    "    Performs a 9 point smoothing on all fields with a quadrilateral curvilinear grid.",
    "    The result at each grid point is a weighted average of the grid point plus",
    "    the 8 surrounding points. The center point receives a weight of 1.0, the ",
    "    points at each side and above and below receive a weight of 0.5, and corner ",
    "    points receive a weight of 0.3.",
    "    All 9 points are multiplied by their weights and summed, then divided by ",
    "    the total weight to obtain the smoothed value. Any missing data points are ",
    "    not included in the sum; points beyond the grid boundary are considered to ",
    "    be missing. Thus the final result may be the result of an averaging with less ",
    "    than 9 points.",
    NULL
};

static const char *ReplacevaluesHelp[] = {
    "NAME",
    "    setvals, setrtoc, setrtoc2 - Replace variable values",
    "",
    "SYNOPSIS",
    "    setvals,oldval,newval[,...]  ifile ofile",
    "    setrtoc,rmin,rmax,c  ifile ofile",
    "    setrtoc2,rmin,rmax,c,c2  ifile ofile",
    "",
    "DESCRIPTION",
    "    This module replaces old variable values with new values, depending on the operator.",
    "",
    "OPERATORS",
    "    setvals   Set list of old values to new values",
    "              Supply a list of n pairs of old and new values.",
    "    setrtoc   Set range to constant",
    "                       / c      if i(t,x) GE rmin AND i(t,x) LE rmax",
    "              o(t,x) = ",
    "                       \\ i(t,x) if i(t,x) LT rmin AND i(t,x) GT rmax",
    "    setrtoc2  Set range to constant others to constant2",
    "                       / c      if i(t,x) GE rmin AND i(t,x) LE rmax",
    "              o(t,x) = ",
    "                       \\ c2     if i(t,x) LT rmin AND i(t,x) GT rmax",
    "",
    "PARAMETER",
    "    oldval,newval,...  FLOAT   Pairs of old and new values",
    "    rmin               FLOAT   Lower bound",
    "    rmax               FLOAT   Upper bound",
    "    c                  FLOAT   New value - inside range",
    "    c2                 FLOAT   New value - outside range",
    NULL
};

static const char *TimsortHelp[] = {
    "NAME",
    "    timsort - Timsort",
    "",
    "SYNOPSIS",
    "    timsort  ifile ofile",
    "",
    "DESCRIPTION",
    "    Sorts the elements in ascending order over all timesteps for every field position.",
    "    After sorting it is:",
    "    ",
    "    o(t_1,x) <= o(t_2,x)      forall (t_1<t_2),x",
    NULL
};

static const char *VargenHelp[] = {
    "NAME",
    "    const, random, topo, for, stdatm - Generate a field",
    "",
    "SYNOPSIS",
    "    const,const,grid  ofile",
    "    random,grid[,seed]  ofile",
    "    topo[,grid]  ofile",
    "    for,start,end[,inc]  ofile",
    "    stdatm,levels  ofile",
    "",
    "DESCRIPTION",
    "    Generates a dataset with one or more fields",
    "",
    "OPERATORS",
    "    const   Create a constant field",
    "            Creates a constant field. All field elements of the grid have the same value.",
    "    random  Create a field with random numbers",
    "            Creates a field with rectangularly distrubuted random numbers in the interval [0,1].",
    "    topo    Create a field with topography",
    "            Creates a field with topography data, per default on a global half degree grid.",
    "    for     Create a time series",
    "            Creates a time series with field size 1 and field elements beginning with a start value in time step 1",
    "            which is increased from one time step to the next.",
    "    stdatm  Create values for pressure and temperature for hydrostatic atmosphere",
    "            Creates pressure and temperature values for the given list of vertical levels.",
    "            The formulars are:",
    "            ",
    "            P(z) = P_0 * exp(-1 * g/R * H/T_0 * log( (exp(z/H)*T_0 + T_Delta)/(T_0 + T_Delta))",
    "            T(z) = T_0 + T_Delta * exp(-z/H)",
    "            ",
    "            with the following constants",
    "            ",
    "            T_0     = 213 K           Offset to get a surface temperature of 288K",
    "            T_Delta = 75 K            Temperature lapse rate for 10Km",
    "            P_0     = 1013.25 hPa     Surface pressure",
    "            H       = 10000.0 m       Scale height",
    "            g       = 9.80665 m/s**2  Earth gravity",
    "            R       = 287.05 J/kg*K   Gas constant for air",
    "            ",
    "            This is the solution for the hydrostatic equations and is only valid for the",
    "            troposphere (constant positive lapse rate). The temperature increase in the",
    "            stratosphere and other effects of the upper atmosphere are not taken into",
    "            account.",
    "",
    "PARAMETER",
    "    const   FLOAT   Constant",
    "    seed    INTEGER The seed for a new sequence of pseudo-random numbers [default: 1]",
    "    grid    STRING  Target grid description file or name",
    "    start   FLOAT   Start value of the loop",
    "    end     FLOAT   End value of the loop",
    "    inc     FLOAT   Increment of the loop [default: 1]",
    "    levels  FLOAT   Target levels in metre above surface",
    NULL
};

static const char *RotuvbHelp[] = {
    "NAME",
    "    rotuvb - Rotation",
    "",
    "SYNOPSIS",
    "    rotuvb,u,v,...  ifile ofile",
    "",
    "DESCRIPTION",
    "    This is a special operator for datsets with wind components on a rotated grid, ",
    "    e.g. data from the regional model REMO. It performs a backward transformation of ",
    "    velocity components U and V from a rotated spherical system to a geographical system.",
    "",
    "PARAMETER",
    "    u,v,...  STRING  Pairs of zonal and meridional velocity components (use variable names or code numbers)",
    NULL
};

static const char *MastrfuHelp[] = {
    "NAME",
    "    mastrfu - Mass stream function",
    "",
    "SYNOPSIS",
    "    mastrfu  ifile ofile",
    "",
    "DESCRIPTION",
    "    This is a special operator for the post processing of the atmospheric general circulation",
    "    model ECHAM. It computes the mass stream function (code=272). The input dataset have ",
    "    to be a zonal mean of v-velocity [m/s] (code=132) on pressure levels.",
    NULL
};

static const char *DeriveparHelp[] = {
    "NAME",
    "    sealevelpressure - Sea level pressure",
    "",
    "SYNOPSIS",
    "    sealevelpressure  ifile ofile",
    "",
    "DESCRIPTION",
    "    This operator computes the sea level pressure (air_pressure_at_sea_level). Required input fields",
    "    are surface_air_pressure, surface_geopotential and air_temperature on hybrid sigma pressure levels.",
    NULL
};

static const char *AdisitHelp[] = {
    "NAME",
    "    adisit, adipot - Potential temperature to in-situ temperature and vice versa",
    "",
    "SYNOPSIS",
    "    adisit[,pressure]  ifile ofile",
    "    adipot  ifile ofile",
    "",
    "DESCRIPTION",
    "",
    "OPERATORS",
    "    adisit  Potential temperature to in-situ temperature",
    "            This is a special operator for the post processing of the ocean and sea ice model output.",
    "            It converts potential temperature adiabatically to in-situ temperature to(t, s, p).",
    "            Required input fields are sea water potential temperature (name=tho; code=2) and sea water salinity (name=sao; code=5).",
    "            Pressure is calculated from the level information or can be specified by the optional parameter.",
    "            Output fields are sea water temperature (name=to; code=20) and sea water salinity (name=s; code=5).",
    "    adipot  In-situ temperature to potential temperature",
    "            This is a special operator for the post processing of the ocean and sea ice",
    "            model outpu.  It converts in-situ temperature to potential temperature tho(to,",
    "            s, p).  Required input fields are sea water in-situ temperature (name=t; code=2) ",
    "            and sea water salinity (name=sao,s; code=5).  Pressure is calculated",
    "            from the level information or can be specified by the optional parameter.",
    "            Output fields are sea water temperature (name=tho; code=2) and sea water",
    "            salinity (name=s; code=5).",
    "",
    "PARAMETER",
    "    pressure  FLOAT   Pressure in bar (constant value assigned to all levels)",
    NULL
};

static const char *RhopotHelp[] = {
    "NAME",
    "    rhopot - Calculates potential density",
    "",
    "SYNOPSIS",
    "    rhopot[,pressure]  ifile ofile",
    "",
    "DESCRIPTION",
    "    This is a special operator for the post processing of the ocean and sea ice model MPIOM.",
    "    It calculates the sea water potential density (name=rhopoto; code=18). Required input fields ",
    "    are sea water in-situ temperature (name=to; code=20) and sea water salinity (name=sao; code=5).",
    "    Pressure is calculated from the level information or can be specified by the optional parameter.",
    "",
    "PARAMETER",
    "    pressure  FLOAT   Pressure in bar (constant value assigned to all levels)",
    NULL
};

static const char *HistogramHelp[] = {
    "NAME",
    "    histcount, histsum, histmean, histfreq - Histogram",
    "",
    "SYNOPSIS",
    "    <operator>,bounds  ifile ofile",
    "",
    "DESCRIPTION",
    "    This module creates bins for a histogram of the input data.",
    "    The bins have to be adjacent and have non-overlapping intervals.",
    "    The user has to define the bounds of the bins. The first value",
    "    is the lower bound and the second value the upper bound of the",
    "    first bin. The bounds of the second bin are defined by the",
    "    second and third value, aso.",
    "    Only 2-dimensional input fields are allowed. The ouput file ",
    "    contains one vertical level for each of the bins requested.",
    "",
    "OPERATORS",
    "    histcount  Histogram count",
    "               Number of elements in the bin range.",
    "    histsum    Histogram sum",
    "               Sum of elements in the bin range.",
    "    histmean   Histogram mean",
    "               Mean of elements in the bin range.",
    "    histfreq   Histogram frequency",
    "               Relative frequency of elements in the bin range.",
    "",
    "PARAMETER",
    "    bounds  FLOAT  Comma separated list of the bin bounds (-inf and inf valid)",
    NULL
};

static const char *SethaloHelp[] = {
    "NAME",
    "    sethalo - Set the left and right bounds of a field",
    "",
    "SYNOPSIS",
    "    sethalo,lhalo,rhalo  ifile ofile",
    "",
    "DESCRIPTION",
    "    This operator sets the left and right bounds of the rectangularly understood fields.",
    "    Positive numbers of the parameter lhalo enlarges the left bound by the given ",
    "    number of columns from the right bound. The parameter rhalo does the similar ",
    "    for the right bound. Negative numbers of the parameter lhalo/rhalo can ",
    "    be used to remove the given number of columns of the left and right bounds.",
    "",
    "PARAMETER",
    "    lhalo  INTEGER  Left halo",
    "    rhalo  INTEGER  Right halo",
    NULL
};

static const char *WctHelp[] = {
    "NAME",
    "    wct - Windchill temperature",
    "",
    "SYNOPSIS",
    "    wct  ifile1 ifile2 ofile",
    "",
    "DESCRIPTION",
    "    Let ifile1 and ifile2 be time series of temperature and wind",
    "    speed records, then a corresponding time series of resulting windchill",
    "    temperatures is written to ofile. The wind chill temperature",
    "    calculation is only valid for a temperature of T <= 33 °C and a wind speed",
    "    of v >= 1.39 m/s. Whenever these conditions are not satisfied, a missing",
    "    value is written to ofile. Note that temperature and wind speed records",
    "    have to be given in units of °C and m/s, respectively.",
    NULL
};

static const char *FdnsHelp[] = {
    "NAME",
    "    fdns - Frost days where no snow index per time period",
    "",
    "SYNOPSIS",
    "    fdns  ifile1 ifile2 ofile",
    "",
    "DESCRIPTION",
    "    Let ifile1 be a time series of the daily minimum temperature TN",
    "    and ifile2 be a corresponding series of daily surface snow",
    "    amounts. Then the number of days where TN < 0 °C and the surface ",
    "    snow amount is less than 1 cm is counted. The temperature TN",
    "    have to be given in units of Kelvin.",
    "    The date information of a timestep in ofile is the date of",
    "    the last contributing timestep in ifile.",
    NULL
};

static const char *StrwinHelp[] = {
    "NAME",
    "    strwin - Strong wind days index per time period",
    "",
    "SYNOPSIS",
    "    strwin[,v]  ifile ofile",
    "",
    "DESCRIPTION",
    "    Let ifile be a time series of the daily maximum horizontal wind speed",
    "    VX, then the number of days where VX > v is counted. The horizontal wind",
    "    speed v is an optional parameter with default v = 10.5 m/s. A further",
    "    output variable is the maximum number of consecutive days with maximum wind",
    "    speed greater than or equal to v. Note that both VX and v have to be given in",
    "    units of m/s. Also note that the horizontal wind speed is defined as the",
    "    square root of the sum of squares of the zonal and meridional wind speeds.",
    "    The date information of a timestep in ofile is the date of",
    "    the last contributing timestep in ifile.",
    "",
    "PARAMETER",
    "    v  FLOAT   Horizontal wind speed threshold (m/s, default v = 10.5 m/s)",
    NULL
};

static const char *StrbreHelp[] = {
    "NAME",
    "    strbre - Strong breeze days index per time period",
    "",
    "SYNOPSIS",
    "    strbre  ifile ofile",
    "",
    "DESCRIPTION",
    "    Let ifile be a time series of the daily maximum horizontal wind speed",
    "    VX, then the number of days where VX is greater than or equal to 10.5 m/s ",
    "    is counted. A further output variable is the maximum number of consecutive",
    "    days with maximum wind speed greater than or equal to 10.5 m/s. Note that",
    "    VX is defined as the square root of the sum of squares of the zonal and",
    "    meridional wind speeds and have to be given in units of m/s.",
    "    The date information of a timestep in ofile is the date of",
    "    the last contributing timestep in ifile.",
    NULL
};

static const char *StrgalHelp[] = {
    "NAME",
    "    strgal - Strong gale days index per time period",
    "",
    "SYNOPSIS",
    "    strgal  ifile ofile",
    "",
    "DESCRIPTION",
    "    Let ifile be a time series of the daily maximum horizontal wind speed",
    "    VX, then the number of days where VX is greater than or equal to 20.5 m/s ",
    "    is counted. A further output variable is the maximum number of consecutive",
    "    days with maximum wind speed greater than or equal to 20.5 m/s. Note that",
    "    VX is defined as the square root of the sum of square of the zonal and",
    "    meridional wind speeds and have to be given in units of m/s.",
    "    The date information of a timestep in ofile is the date of",
    "    the last contributing timestep in ifile.",
    NULL
};

static const char *HurrHelp[] = {
    "NAME",
    "    hurr - Hurricane days index per time period",
    "",
    "SYNOPSIS",
    "    hurr  ifile ofile",
    "",
    "DESCRIPTION",
    "    Let ifile be a time series of the daily maximum horizontal wind speed",
    "    VX, then the number of days where VX is greater than or equal to 32.5 m/s",
    "    is counted. A further output variable is the maximum number of consecutive",
    "    days with maximum wind speed greater than or equal to 32.5 m/s. Note that",
    "    VX is defined as the square root of the sum of squares of the zonal and",
    "    meridional wind speeds and have to be given in units of m/s.",
    "    The date information of a timestep in ofile is the date of",
    "    the last contributing timestep in ifile.",
    NULL
};

static const char *MagplotHelp[] = {
    "NAME",
    "    contour, shaded, grfill - Lat/Lon plot",
    "",
    "SYNOPSIS",
    "    <operator>,params  ifile obase",
    "",
    "DESCRIPTION",
    "    The operators in this module generates 2D Lon/Lat plots.",
    "    The data for the plot is read from ifile.",
    "    Only data on rectilinear Lon/Lat grids are supported.",
    "    The output file will be named <obase>_<param>.<device> where param is the parameter name and",
    "    device is the device name. The default output file format is postscript,",
    "    this can be changed with the device parameter.",
    "    The type of the plot depends on the choosen operator.",
    "    ",
    "    Here is a list of all common plot parameters:",
    "    ",
    "     Keyname     & Type    & Description      ",
    "     device      & STRING  & Output device (ps, eps, pdf, png, gif, gif_animation, jpeg, svg, kml)",
    "     projection  & STRING  & Projection (cylindrical, polar_stereographic, robinson, mercator)",
    "     style       & STRING  & Contour line style (solid, dash, dot, chain_dash, chain_dot)",
    "     min         & FLOAT   & Minimum value",
    "     max         & FLOAT   & Maximum value",
    "     lon_max     & FLOAT   & Maximum longitude of the image",
    "     lon_min     & FLOAT   & Minimum longitude of the image",
    "     lat_max     & FLOAT   & Maximum latitude of the image",
    "     lat_min     & FLOAT   & Minimum latitude of the image",
    "     count       & INTEGER & Number of Contour levels / Colour bands  ",
    "     interval    & FLOAT   & Interval in data units between two bands lines",
    "     list        & INTEGER & List of levels to be plotted",
    "     RGB         & STRING  & TRUE or FALSE, to  indicate, if the input colour is in RGB format",
    "     step_freq   & INTEGER & Frequency of time steps to be considered for making the animation",
    "                 &         & (device=gif_animation). Default value is \"1\" (all time steps).",
    "                 &         & Will be ignored if input file has multiple variables.",
    "     file_split  & STRING  & TRUE or FALSE, to split the output file for each variable, if input has",
    "                 &         & multiple variables. Default value is \"FALSE\". Valid only for \"PS\" format.",
    "",
    "OPERATORS",
    "    contour  Contour plot",
    "             The operator contour generates the discrete contour lines of the input field values.",
    "             The following additional parameters are valid for contour operator,",
    "             module in addition to the common plot parameters:",
    "             ",
    "              Keyname      & Type    & Description      ",
    "              colour       & STRING  & Colour for drawing the contours",
    "              thickness    & FLOAT   & Thickness of the contour line",
    "              style        & STRING  & Line Style can be \"SOLID\", \"DASH\", \"DOT\", \"CHAIN_DASH\",",
    "                           &         & \"CHAIN_DOT\"",
    "    shaded   Shaded contour plot",
    "             The operator shaded generates the filled contours of the given input field values.",
    "             The following additional parameters are valid for shaded contour and gridfill operator,",
    "             in addition to the common plot parameters.",
    "             ",
    "              Keyname      & Type    & Description      ",
    "              colour_min   & STRING  & Colour for the Minimum colour band",
    "              colour_max   & STRING  & Colour for the Minimum colour band",
    "              colour_triad & STRING  & Direction of colour sequencing for shading \"CW\" or \"ACW\",",
    "                           &         & to denote \"clockwise\" and \"anticlockwise\" respectively.",
    "                           &         & To be used in conjunction with \"colour_min\", \"colour_max\"",
    "                           &         & options. Default is \"ACW\"",
    "              colour_table & STRING  & File with user specified colours with the format as",
    "             ",
    "             Example file for 6 colours in RGB format:",
    "             	6",
    "             	RGB(0.0;0.0;1.0)",
    "             	RGB(0.0;0.0;0.5)",
    "             	RGB(0.0;0.5;0.5)",
    "             	RGB(0.0;1.0;0.0)",
    "             	RGB(0.5;0.5;0.0)",
    "             	RGB(1.0;0.0;0.0)",
    "             ",
    "    grfill   Shaded gridfill plot",
    "             The operator grfill is similar to satellite imaging and shades each cell (pixel) according",
    "             to the value of the field at that cell.",
    "",
    "PARAMETER",
    "    params  STRING   Comma separated list of plot parameters",
    "",
    "NOTE",
    "    All colour parameter can be either standard name or in RGB format.",
    "    The valid standard name strings for \"colour\" are:",
    "    ",
    "    \"red\", \"green\", \"blue\", \"yellow\", \"cyan\", \"magenta\", \"black\", \"avocado\", \"beige\",",
    "    \"brick\", \"brown\", \"burgundy\", \"charcoal\", \"chestnut\", \"coral\", \"cream\", \"evergreen\",",
    "    \"gold\", \"grey\", \"khaki\", \"kellygreen\", \"lavender\", \"mustard\", \"navy\", \"ochre\",",
    "    \"olive\", \"peach\", \"pink\", \"rose\", \"rust\", \"sky\", \"tan\", \"tangerine\", \"turquoise\",",
    "    \"violet\", \"reddishpurple\", \"purplered\", \"purplishred\", \"orangishred\", \"redorange\",",
    "    \"reddishorange\", \"orange\", \"yellowishorange\", \"orangeyellow\", \"orangishyellow\",",
    "    \"greenishyellow\", \"yellowgreen\", \"yellowishgreen\", \"bluishgreen\", \"bluegreen\",",
    "    \"greenishblue\", \"purplishblue\", \"bluepurple\", \"bluishpurple\", \"purple\", \"white\"",
    NULL
};

static const char *MagvectorHelp[] = {
    "NAME",
    "    vector - Lat/Lon vector plot",
    "",
    "SYNOPSIS",
    "    vector,params  ifile obase",
    "",
    "DESCRIPTION",
    "    This operator generates 2D Lon/Lat vector plots.",
    "    The data for the plot is read from ifile. The input is expected to contain two velocity",
    "    components. Only data on rectilinear Lon/Lat grids are supported.",
    "    The output file will be named <obase>.<device> where device is the device name. ",
    "    The default output file format is postscript, this can be changed with the device parameter.",
    "    ",
    "    Here is a list of all vector plot parameters:",
    "    ",
    "     Keyname     & Type    & Description      ",
    "     device      & STRING  & Output device (ps, eps, pdf, png, gif, gif_animation, jpeg, svg, kml)",
    "     projection  & STRING  & Projection (cylindrical, polar_stereographic, robinson, mercator)",
    "     thin_fac    & FLOAT   & Controls the actual number of wind arrows or flags plotted (default 2).",
    "     unit_vec    & FLOAT   & Wind speed in m/s represented by a unit vector (1.0cm)",
    "     step_freq   & INTEGER & Frequency of time steps to be considered for making the animation",
    "                 &         & (device=gif_animation). Default value is \"1\" (all time steps).",
    "                 &         & Will be ignored if input file has multiple variables.",
    "",
    "PARAMETER",
    "    params  STRING   Comma separated list of plot parameters",
    NULL
};

static const char *MaggraphHelp[] = {
    "NAME",
    "    graph - Line graph plot",
    "",
    "SYNOPSIS",
    "    graph,params  ifiles ofile",
    "",
    "DESCRIPTION",
    "    This operator generates line graph plots.",
    "    The data for the plot is read from ifiles. The result is written to ofile.",
    "    The default output file format is postscript, this can be changed with the device parameter.",
    "    ",
    "    Here is a list of all graph plot parameters:",
    "    ",
    "     Keyname    & Type    & Description      ",
    "     device     & STRING  & Output device (ps, eps, pdf, png, gif, gif_animation, jpeg, svg, kml)",
    "     ymin       & FLOAT   & Minimum value of the y-axis data ",
    "     ymax       & FLOAT   & Maximum value of the y-axis data ",
    "     stat       & STRING  & \"TRUE\" or \"FALSE\", to switch on the mean computation. Default is \"FALSE\".",
    "                &         & Will be overridden to \"FALSE\", if input files have unequal number of time",
    "                &         & steps or different start/end times. ",
    "     sigma      & FLOAT   & Standard deviation value for generating shaded back ground around the mean value.",
    "                &         & To be used in conjunction with 'stat=\"TRUE\"' ",
    "     obsv       & STRING  & To indicate if the input files have an observation data, by setting to \"TRUE\".",
    "                &         & Default value is \"FALSE\". The observation data should be the first file in the",
    "                &         & input file list. The observation data is always plotted in black colour. ",
    "",
    "PARAMETER",
    "    params  STRING   Comma separated list of plot parameters",
    NULL
};

static const char *EcaCddHelp[] = {
    "NAME",
    "    eca_cdd - Consecutive dry days index per time period",
    "",
    "SYNOPSIS",
    "    eca_cdd[,R]  ifile ofile",
    "",
    "DESCRIPTION",
    "    Let ifile be a time series of the daily precipitation amount RR, then the largest number ",
    "    of consecutive days where RR is less than R is counted. R is an optional parameter with ",
    "    default R = 1 mm. A further output variable is the number of dry periods of more than 5 days.",
    "    The date information of a timestep in ofile is the date of the last contributing timestep in ifile.",
    "    The following variables are created: ",
    "    - consecutive_dry_days_index_per_time_period",
    "    - number_of_cdd_periods_with_more_than_5days_per_time_period",
    "",
    "PARAMETER",
    "    R  FLOAT   Precipitation threshold (unit: mm; default: R = 1 mm)",
    NULL
};

static const char *EcaCfdHelp[] = {
    "NAME",
    "    eca_cfd - Consecutive frost days index per time period",
    "",
    "SYNOPSIS",
    "    eca_cfd  ifile ofile",
    "",
    "DESCRIPTION",
    "    Let ifile be a time series of the daily minimum temperature TN, then the largest number of",
    "    consecutive days where TN < 0 °C is counted. Note that TN have to be given in units of Kelvin.",
    "    A further output variable is the number of frost periods of more than 5 days.",
    "    The date information of a timestep in ofile is the date of the last contributing timestep in ifile.",
    "    The following variables are created: ",
    "    - consecutive_frost_days_index_per_time_period",
    "    - number_of_cfd_periods_with_more_than_5days_per_time_period",
    NULL
};

static const char *EcaCsuHelp[] = {
    "NAME",
    "    eca_csu - Consecutive summer days index per time period",
    "",
    "SYNOPSIS",
    "    eca_csu[,T]  ifile ofile",
    "",
    "DESCRIPTION",
    "    Let ifile be a time series of the daily maximum temperature TX, then the largest number of consecutive",
    "    days where TX > T is counted. The number T is an optional parameter with default T = 25°C.",
    "    Note that TN have to be given in units of Kelvin, whereas T have to be given in degrees Celsius.",
    "    A further output variable is the number of summer periods of more than 5 days.",
    "    The date information of a timestep in ofile is the date of the last contributing timestep in ifile.",
    "    The following variables are created: ",
    "    - consecutive_summer_days_index_per_time_period",
    "    - number_of_csu_periods_with_more_than_5days_per_time_period",
    "",
    "PARAMETER",
    "    T  FLOAT   Temperature threshold (unit: °C; default: T = 25°C)",
    NULL
};

static const char *EcaCwdHelp[] = {
    "NAME",
    "    eca_cwd - Consecutive wet days index per time period",
    "",
    "SYNOPSIS",
    "    eca_cwd[,R]  ifile ofile",
    "",
    "DESCRIPTION",
    "    Let ifile be a time series of the daily precipitation amount RR, then the largest number ",
    "    of consecutive days where RR is at least R is counted. R is an optional parameter with ",
    "    default R = 1 mm. A further output variable is the number of wet periods of more than 5 days.",
    "    The date information of a timestep in ofile is the date of the last contributing timestep in ifile.",
    "    The following variables are created: ",
    "    - consecutive_wet_days_index_per_time_period",
    "    - number_of_cwd_periods_with_more_than_5days_per_time_period",
    "",
    "PARAMETER",
    "    R  FLOAT   Precipitation threshold (unit: mm; default: R = 1 mm)",
    NULL
};

static const char *EcaCwdiHelp[] = {
    "NAME",
    "    eca_cwdi - Cold wave duration index wrt mean of reference period",
    "",
    "SYNOPSIS",
    "    eca_cwdi[,nday[,T]]  ifile1 ifile2 ofile",
    "",
    "DESCRIPTION",
    "    Let ifile1 be a time series of the daily minimum temperature TN, and let ifile2 be the mean ",
    "    TNnorm of daily minimum temperatures for any period used as reference. Then counted is the number of days",
    "    where, in intervals of at least nday consecutive days, TN < TNnorm - T.",
    "    The numbers nday and T are optional parameters with default nday = 6 and T = 5°C. ",
    "    A further output variable is the number of cold waves longer than or equal to nday days.",
    "    TNnorm is calculated as the mean of minimum temperatures of a five day window centred on each calendar day ",
    "    of a given climate reference period. Note that both TN and TNnorm have to be given in the same units.",
    "    The date information of a timestep in ofile is the date of the last contributing timestep in ifile1.",
    "    The following variables are created: ",
    "    - cold_wave_duration_index_wrt_mean_of_reference_period",
    "    - cold_waves_per_time_period",
    "",
    "PARAMETER",
    "    nday  INTEGER  Number of consecutive days (default: nday = 6)",
    "    T     FLOAT    Temperature offset (unit: °C; default: T = 5°C)",
    NULL
};

static const char *EcaCwfiHelp[] = {
    "NAME",
    "    eca_cwfi - Cold-spell days index wrt 10th percentile of reference period",
    "",
    "SYNOPSIS",
    "    eca_cwfi[,nday]  ifile1 ifile2 ofile",
    "",
    "DESCRIPTION",
    "    Let ifile1 be a time series of the daily mean temperature TG, and ifile2 be the 10th",
    "    percentile TGn10 of daily mean temperatures for any period used as reference. ",
    "    Then counted is the number of days where, in intervals of at least nday consecutive days,",
    "    TG < TGn10. The number nday is an optional parameter with default nday = 6.",
    "    A further output variable is the number of cold-spell periods longer than or equal to nday days.",
    "    TGn10 is calculated as the 10th percentile of daily mean temperatures of a five day window ",
    "    centred on each calendar day of a given climate reference period. Note that both TG and TGn10 ",
    "    have to be given in the same units. The date information of a timestep in ofile is the date of",
    "    the last contributing timestep in ifile1.",
    "    The following variables are created: ",
    "    - cold_spell_days_index_wrt_10th_percentile_of_reference_period",
    "    - cold_spell_periods_per_time_period",
    "",
    "PARAMETER",
    "    nday  INTEGER  Number of consecutive days (default: nday = 6)",
    NULL
};

static const char *EcaEtrHelp[] = {
    "NAME",
    "    eca_etr - Intra-period extreme temperature range",
    "",
    "SYNOPSIS",
    "    eca_etr  ifile1 ifile2 ofile",
    "",
    "DESCRIPTION",
    "    Let ifile1 and ifile2 be time series of thr maximum and minimum",
    "    temperature TX and TN, respectively. Then the extreme temperature",
    "    range is the difference of the maximum of TX and the minimum of TN.",
    "    Note that TX and TN have to be given in the same units.",
    "    The date information of a timestep in ofile is the date of",
    "    the last contributing timesteps in ifile1 and ifile2.",
    "    The following variables are created: ",
    "    - intra_period_extreme_temperature_range",
    NULL
};

static const char *EcaFdHelp[] = {
    "NAME",
    "    eca_fd - Frost days index per time period",
    "",
    "SYNOPSIS",
    "    eca_fd  ifile ofile",
    "",
    "DESCRIPTION",
    "    Let ifile be a time series of the daily minimum temperature TN,",
    "    then the number of days where TN < 0 °C is counted. Note",
    "    that TN have to be given in units of Kelvin.",
    "    The date information of a timestep in ofile is the date of",
    "    the last contributing timestep in ifile.",
    "    The following variables are created: ",
    "    - frost_days_index_per_time_period",
    NULL
};

static const char *EcaGslHelp[] = {
    "NAME",
    "    eca_gsl - Thermal Growing season length index",
    "",
    "SYNOPSIS",
    "    eca_gsl[,nday[,T[,fland]]]  ifile1 ifile2 ofile",
    "",
    "DESCRIPTION",
    "    Let ifile1 be a time series of the daily mean temperature TG, and ifile2 be a land-water mask.",
    "    Within a period of 12 months, the thermal growing season length is officially defined as the number of days between:",
    "    - first occurrence of at least nday consecutive days with TG > T",
    "    - first occurrence of at least nday consecutive days with TG < T within the last 6 months",
    "    On northern hemispere, this period corresponds with the regular year, whereas on southern hemispere, it starts ",
    "    at July 1st. Please note, that this definition may lead to weird results concerning values TG = T: ",
    "    In the first half of the period, these days do not contribute to the gsl, but they do within the second half.",
    "    Moreover this definition could lead to discontinuous values in equatorial regions.",
    "    ",
    "    The numbers nday and T are optional parameter with default nday = 6 and T = 5°C. ",
    "    The number fland is an optional parameter with default value fland = 0.5 and denotes the fraction of ",
    "    a grid point that have to be covered by land in order to be included in the calculation. A further output variable ",
    "    is the start day of year of the growing season. Note that TG have to be given in units of Kelvin, whereas T ",
    "    have to be given in degrees Celsius.",
    "    ",
    "    The date information of a timestep in ofile is the date of the last contributing timestep in ifile.",
    "    The following variables are created: ",
    "    - thermal_growing_season_length",
    "    - day_of_year_of_growing_season_start",
    "",
    "PARAMETER",
    "    nday   INTEGER  Number of consecutive days (default: nday = 6)",
    "    T      FLOAT    Temperature threshold (unit: °C; default: T = 5°C)",
    "    fland  FLOAT    Land fraction threshold (default: fland = 0.5)",
    NULL
};

static const char *EcaHdHelp[] = {
    "NAME",
    "    eca_hd - Heating degree days per time period",
    "",
    "SYNOPSIS",
    "    eca_hd[,T1[,T2]]  ifile ofile",
    "",
    "DESCRIPTION",
    "    Let ifile be a time series of the daily mean temperature TG, then the heating degree days ",
    "    are defined as the sum of T1 - TG, where only values TG < T2 are considered. ",
    "    If T1 and T2 are omitted, a temperature of 17°C is used for both parameters. ",
    "    If only T1 is given, T2 is set to T1. Note that TG have to be given in units ",
    "    of kelvin, whereas T1 and T2 have to be given in degrees Celsius.",
    "    The date information of a timestep in ofile is the date of the last contributing timestep in ifile.",
    "    The following variables are created: ",
    "    - heating_degree_days_per_time_period",
    "",
    "PARAMETER",
    "    T1  FLOAT   Temperature limit (unit: °C; default: T1 = 17°C)",
    "    T2  FLOAT   Temperature limit (unit: °C; default: T2 = T1)",
    NULL
};

static const char *EcaHwdiHelp[] = {
    "NAME",
    "    eca_hwdi - Heat wave duration index wrt mean of reference period",
    "",
    "SYNOPSIS",
    "    eca_hwdi[,nday[,T]]  ifile1 ifile2 ofile",
    "",
    "DESCRIPTION",
    "    Let ifile1 be a time series of the daily maximum temperature TX, and let ifile2 be the mean ",
    "    TXnorm of daily maximum temperatures for any period used as reference. Then counted is the number of days",
    "    where, in intervals of at least nday consecutive days, TX > TXnorm + T.",
    "    The numbers nday and T are optional parameters with default nday = 6 and T = 5°C. ",
    "    A further output variable is the number of heat waves longer than or equal to nday days. ",
    "    TXnorm is calculated as the mean of maximum temperatures of a five day window centred on each calendar day",
    "    of a given climate reference period. Note that both TX and TXnorm have to be given in the same units.",
    "    The date information of a timestep in ofile is the date of the last contributing timestep in ifile1.",
    "    The following variables are created: ",
    "    - heat_wave_duration_index_wrt_mean_of_reference_period",
    "    - heat_waves_per_time_period",
    "",
    "PARAMETER",
    "    nday  INTEGER  Number of consecutive days (default: nday = 6)",
    "    T     FLOAT    Temperature offset (unit: °C; default: T = 5°C)",
    NULL
};

static const char *EcaHwfiHelp[] = {
    "NAME",
    "    eca_hwfi - Warm spell days index wrt 90th percentile of reference period",
    "",
    "SYNOPSIS",
    "    eca_hwfi[,nday]  ifile1 ifile2 ofile",
    "",
    "DESCRIPTION",
    "    Let ifile1 be a time series of the daily mean temperature TG, and ",
    "    ifile2 be the 90th percentile TGn90 of daily mean temperatures",
    "    for any period used as reference. Then counted is the number of days",
    "    where, in intervals of at least nday consecutive days, TG > TGn90. The",
    "    number nday is an optional parameter with default nday = 6. A further",
    "    output variable is the number of warm-spell periods longer than or",
    "    equal to nday days. ",
    "    TGn90 is calculated as the 90th percentile of daily mean temperatures of a five ",
    "    day window centred on each calendar day of a given climate reference period.",
    "    Note that both TG and TGn90 have to be given in the same units.",
    "    The date information of a timestep in ofile is the date of",
    "    the last contributing timestep in ifile1.",
    "    The following variables are created: ",
    "    - warm_spell_days_index_wrt_90th_percentile_of_reference_period",
    "    - warm_spell_periods_per_time_period",
    "",
    "PARAMETER",
    "    nday  INTEGER  Number of consecutive days (default: nday = 6)",
    NULL
};

static const char *EcaIdHelp[] = {
    "NAME",
    "    eca_id - Ice days index per time period",
    "",
    "SYNOPSIS",
    "    eca_id  ifile ofile",
    "",
    "DESCRIPTION",
    "    Let ifile be a time series of the daily maximum temperature TX,",
    "    then the number of days where TX < 0 °C is counted. Note",
    "    that TX have to be given in units of Kelvin.",
    "    The date information of a timestep in ofile is the date of",
    "    the last contributing timestep in ifile.",
    "    The following variables are created: ",
    "    - ice_days_index_per_time_period",
    NULL
};

static const char *EcaR75pHelp[] = {
    "NAME",
    "    eca_r75p - Moderate wet days wrt 75th percentile of reference period",
    "",
    "SYNOPSIS",
    "    eca_r75p  ifile1 ifile2 ofile",
    "",
    "DESCRIPTION",
    "    Let ifile1 be a time series RR of the daily precipitation amount at wet days (precipitation >= 1 mm)",
    "    and ifile2 be the 75th percentile RRn75 of the daily precipitation amount at wet days for any period ",
    "    used as reference. Then the percentage of wet days with RR > RRn75 is calculated. ",
    "    RRn75 is calculated as the 75th percentile of all wet days of a given climate reference period.",
    "    Usually ifile2 is generated by the operator ydaypctl,75.",
    "    The date information of a timestep in ofile is the date of the last contributing timestep in ifile1.",
    "    The following variables are created: ",
    "    - moderate_wet_days_wrt_75th_percentile_of_reference_period",
    NULL
};

static const char *EcaR75ptotHelp[] = {
    "NAME",
    "    eca_r75ptot - Precipitation percent due to R75p days",
    "",
    "SYNOPSIS",
    "    eca_r75ptot  ifile1 ifile2 ofile",
    "",
    "DESCRIPTION",
    "    Let ifile1 be a time series RR of the daily precipitation amount at wet days (precipitation >= 1 mm)",
    "    and ifile2 be the 75th percentile RRn75 of the daily precipitation amount at wet days for any period ",
    "    used as reference. Then the ratio of the precipitation sum at wet days with RR > RRn75 to the total ",
    "    precipitation sum is calculated. ",
    "    RRn75 is calculated as the 75th percentile of all wet days of a given climate reference period.",
    "    Usually ifile2 is generated by the operator ydaypctl,75.",
    "    The date information of a timestep in ofile is the date of the last contributing timestep in ifile1.",
    "    The following variables are created: ",
    "    - precipitation_percent_due_to_R75p_days",
    NULL
};

static const char *EcaR90pHelp[] = {
    "NAME",
    "    eca_r90p - Wet days wrt 90th percentile of reference period",
    "",
    "SYNOPSIS",
    "    eca_r90p  ifile1 ifile2 ofile",
    "",
    "DESCRIPTION",
    "    Let ifile1 be a time series RR of the daily precipitation amount at wet days (precipitation >= 1 mm)",
    "    and ifile2 be the 90th percentile RRn90 of the daily precipitation amount at wet days for any period ",
    "    used as reference. Then the percentage of wet days with RR > RRn90 is calculated. ",
    "    RRn90 is calculated as the 90th percentile of all wet days of a given climate reference period.",
    "    Usually ifile2 is generated by the operator ydaypctl,90.",
    "    The date information of a timestep in ofile is the date of the last contributing timestep in ifile1.",
    "    The following variables are created: ",
    "    - wet_days_wrt_90th_percentile_of_reference_period",
    NULL
};

static const char *EcaR90ptotHelp[] = {
    "NAME",
    "    eca_r90ptot - Precipitation percent due to R90p days",
    "",
    "SYNOPSIS",
    "    eca_r90ptot  ifile1 ifile2 ofile",
    "",
    "DESCRIPTION",
    "    Let ifile1 be a time series RR of the daily precipitation amount at wet days (precipitation >= 1 mm)",
    "    and ifile2 be the 90th percentile RRn90 of the daily precipitation amount at wet days for any period ",
    "    used as reference. Then the ratio of the precipitation sum at wet days with RR > RRn90 to the total ",
    "    precipitation sum is calculated. ",
    "    RRn90 is calculated as the 90th percentile of all wet days of a given climate reference period.",
    "    Usually ifile2 is generated by the operator ydaypctl,90.",
    "    The date information of a timestep in ofile is the date of the last contributing timestep in ifile1.",
    "    The following variables are created: ",
    "    - precipitation_percent_due_to_R90p_days",
    NULL
};

static const char *EcaR95pHelp[] = {
    "NAME",
    "    eca_r95p - Very wet days wrt 95th percentile of reference period",
    "",
    "SYNOPSIS",
    "    eca_r95p  ifile1 ifile2 ofile",
    "",
    "DESCRIPTION",
    "    Let ifile1 be a time series RR of the daily precipitation amount at wet days (precipitation >= 1 mm)",
    "    and ifile2 be the 95th percentile RRn95 of the daily precipitation amount at wet days for any period ",
    "    used as reference. Then the percentage of wet days with RR > RRn95 is calculated. ",
    "    RRn95 is calculated as the 95th percentile of all wet days of a given climate reference period.",
    "    Usually ifile2 is generated by the operator ydaypctl,95.",
    "    The date information of a timestep in ofile is the date of the last contributing timestep in ifile1.",
    "    The following variables are created: ",
    "    - very_wet_days_wrt_95th_percentile_of_reference_period",
    NULL
};

static const char *EcaR95ptotHelp[] = {
    "NAME",
    "    eca_r95ptot - Precipitation percent due to R95p days",
    "",
    "SYNOPSIS",
    "    eca_r95ptot  ifile1 ifile2 ofile",
    "",
    "DESCRIPTION",
    "    Let ifile1 be a time series RR of the daily precipitation amount at wet days (precipitation >= 1 mm)",
    "    and ifile2 be the 95th percentile RRn95 of the daily precipitation amount at wet days for any period ",
    "    used as reference. Then the ratio of the precipitation sum at wet days with RR > RRn95 to the total ",
    "    precipitation sum is calculated. ",
    "    RRn95 is calculated as the 95th percentile of all wet days of a given climate reference period.",
    "    Usually ifile2 is generated by the operator ydaypctl,95.",
    "    The date information of a timestep in ofile is the date of the last contributing timestep in ifile1.",
    "    The following variables are created: ",
    "    - precipitation_percent_due_to_R95p_days",
    NULL
};

static const char *EcaR99pHelp[] = {
    "NAME",
    "    eca_r99p - Extremely wet days wrt 99th percentile of reference period",
    "",
    "SYNOPSIS",
    "    eca_r99p  ifile1 ifile2 ofile",
    "",
    "DESCRIPTION",
    "    Let ifile1 be a time series RR of the daily precipitation amount at wet days (precipitation >= 1 mm)",
    "    and ifile2 be the 99th percentile RRn99 of the daily precipitation amount at wet days for any period ",
    "    used as reference. Then the percentage of wet days with RR > RRn99 is calculated. ",
    "    RRn99 is calculated as the 99th percentile of all wet days of a given climate reference period.",
    "    Usually ifile2 is generated by the operator ydaypctl,99.",
    "    The date information of a timestep in ofile is the date of the last contributing timestep in ifile1.",
    "    The following variables are created: ",
    "    - extremely_wet_days_wrt_99th_percentile_of_reference_period",
    NULL
};

static const char *EcaR99ptotHelp[] = {
    "NAME",
    "    eca_r99ptot - Precipitation percent due to R99p days",
    "",
    "SYNOPSIS",
    "    eca_r99ptot  ifile1 ifile2 ofile",
    "",
    "DESCRIPTION",
    "    Let ifile1 be a time series RR of the daily precipitation amount at wet days (precipitation >= 1 mm)",
    "    and ifile2 be the 99th percentile RRn99 of the daily precipitation amount at wet days for any period ",
    "    used as reference. Then the ratio of the precipitation sum at wet days with RR > RRn99 to the total ",
    "    precipitation sum is calculated. ",
    "    RRn99 is calculated as the 99th percentile of all wet days of a given climate reference period.",
    "    Usually ifile2 is generated by the operator ydaypctl,99.",
    "    The date information of a timestep in ofile is the date of the last contributing timestep in ifile1.",
    "    The following variables are created: ",
    "    - precipitation_percent_due_to_R99p_days",
    NULL
};

static const char *EcaPdHelp[] = {
    "NAME",
    "    eca_pd, eca_r10mm, eca_r20mm - Precipitation days index per time period",
    "",
    "SYNOPSIS",
    "    eca_pd,x  ifile ofile",
    "    eca_r10mm  ifile ofile",
    "    eca_r20mm  ifile ofile",
    "",
    "DESCRIPTION",
    "    Let ifile be a time series of the daily precipitation amount RR in [mm] (or alternatively in [kg m-2]),",
    "    then the number of days where RR is at least x mm is counted. ",
    "    eca_r10mm and eca_r20mm are specific ECA operators with a daily precipitation amount of 10 and 20 mm respectively.",
    "    The date information of a timestep in ofile is the date of the last contributing timestep in ifile.",
    "    The following variables are created: ",
    "    - precipitation_days_index_per_time_period",
    "",
    "OPERATORS",
    "    eca_pd     Precipitation days index per time period",
    "               Generic ECA operator with daily precipitation sum exceeding x mm.",
    "    eca_r10mm  Heavy precipitation days index per time period",
    "               Specific ECA operator with daily precipitation sum exceeding 10 mm.",
    "    eca_r20mm  Very heavy precipitation days index per time period",
    "               Specific ECA operator with daily precipitation sum exceeding 20 mm.",
    "",
    "PARAMETER",
    "    x  FLOAT   Daily precipitation amount threshold in [mm]",
    "",
    "NOTE",
    "    Precipitation rates in [mm/s] have to be converted to precipitation amounts (multiply with 86400 s).",
    "    Apart from metadata information the result of eca_pd,1 and eca_rr1 is the same.",
    NULL
};

static const char *EcaRr1Help[] = {
    "NAME",
    "    eca_rr1 - Wet days index per time period",
    "",
    "SYNOPSIS",
    "    eca_rr1[,R]  ifile ofile",
    "",
    "DESCRIPTION",
    "    Let ifile be a time series of the daily precipitation amount RR in [mm] (or alternatively in [kg m-2]), then",
    "    the number of days where RR is at least R is counted. R is an optional parameter with default R = 1 mm. ",
    "    The date information of a timestep in ofile is the date of the last contributing timestep in ifile.",
    "    The following variables are created: ",
    "    - wet_days_index_per_time_period",
    "",
    "PARAMETER",
    "    R  FLOAT   Precipitation threshold (unit: mm; default: R = 1 mm)",
    NULL
};

static const char *EcaRx1dayHelp[] = {
    "NAME",
    "    eca_rx1day - Highest one day precipitation amount per time period",
    "",
    "SYNOPSIS",
    "    eca_rx1day[,mode]  ifile ofile",
    "",
    "DESCRIPTION",
    "    Let ifile be a time series of the daily precipitation amount RR,",
    "    then the maximum of RR is written to ofile. If the optional",
    "    parameter mode is set to 'm' the maximum daily precipitation",
    "    amounts are determined for each month. ",
    "    The date information of a timestep in ofile is the date of",
    "    the last contributing timestep in ifile.",
    "    The following variables are created: ",
    "    - highest_one_day_precipitation_amount_per_time_period",
    "",
    "PARAMETER",
    "    mode  STRING   Operation mode (optional). If mode = 'm' then maximum daily precipitation amounts are determined for each month",
    NULL
};

static const char *EcaRx5dayHelp[] = {
    "NAME",
    "    eca_rx5day - Highest five-day precipitation amount per time period",
    "",
    "SYNOPSIS",
    "    eca_rx5day[,x]  ifile ofile",
    "",
    "DESCRIPTION",
    "    Let ifile be a time series of 5-day precipitation totals RR, then the maximum of RR is written to ofile. ",
    "    A further output variable is the number of 5 day period with precipitation totals greater than x mm, where x ",
    "    is an optional parameter with default x = 50 mm.",
    "    The date information of a timestep in ofile is the date of the last contributing timestep in ifile.",
    "    The following variables are created: ",
    "    - highest_five_day_precipitation_amount_per_time_period",
    "    - number_of_5day_heavy_precipitation_periods_per_time_period",
    "",
    "PARAMETER",
    "    x  FLOAT   Precipitation threshold (unit: mm; default: x = 50 mm)",
    NULL
};

static const char *EcaSdiiHelp[] = {
    "NAME",
    "    eca_sdii - Simple daily intensity index per time period",
    "",
    "SYNOPSIS",
    "    eca_sdii[,R]  ifile ofile",
    "",
    "DESCRIPTION",
    "    Let ifile be a time series of the daily precipitation amount RR, then the mean precipitation amount at ",
    "    wet days (RR > R) is written to ofile. R is an optional parameter with default R = 1 mm.",
    "    The date information of a timestep in ofile is the date of the last contributing timestep in ifile.",
    "    The following variables are created: ",
    "    - simple_daily_intensitiy_index_per_time_period",
    "",
    "PARAMETER",
    "    R  FLOAT   Precipitation threshold (unit: mm; default: R = 1 mm)",
    NULL
};

static const char *EcaSuHelp[] = {
    "NAME",
    "    eca_su - Summer days index per time period",
    "",
    "SYNOPSIS",
    "    eca_su[,T]  ifile ofile",
    "",
    "DESCRIPTION",
    "    Let ifile be a time series of the daily maximum temperature TX, then the number of days where ",
    "    TX > T is counted. The number T is an optional parameter with default T = 25°C. ",
    "    Note that TX have to be given in units of Kelvin, whereas T have to be given in degrees Celsius.",
    "    The date information of a timestep in ofile is the date of the last contributing timestep in ifile.",
    "    The following variables are created: ",
    "    - summer_days_index_per_time_period",
    "",
    "PARAMETER",
    "    T  FLOAT   Temperature threshold (unit: °C; default: T = 25°C)",
    NULL
};

static const char *EcaTg10pHelp[] = {
    "NAME",
    "    eca_tg10p - Cold days percent wrt 10th percentile of reference period",
    "",
    "SYNOPSIS",
    "    eca_tg10p  ifile1 ifile2 ofile",
    "",
    "DESCRIPTION",
    "    Let ifile1 be a time series of the daily mean temperature TG, and",
    "    ifile2 be the 10th percentile TGn10 of daily mean temperatures",
    "    for any period used as reference. Then the percentage of time where ",
    "    TG < TGn10 is calculated.",
    "    TGn10 is calculated as the 10th percentile of daily mean temperatures of a five ",
    "    day window centred on each calendar day of a given climate reference period.",
    "    Note that both TG and TGn10 have to be given in the same units.",
    "    The date information of a timestep in ofile is the date of",
    "    the last contributing timestep in ifile1.",
    "    The following variables are created: ",
    "    - cold_days_percent_wrt_10th_percentile_of_reference_period",
    NULL
};

static const char *EcaTg90pHelp[] = {
    "NAME",
    "    eca_tg90p - Warm days percent wrt 90th percentile of reference period",
    "",
    "SYNOPSIS",
    "    eca_tg90p  ifile1 ifile2 ofile",
    "",
    "DESCRIPTION",
    "    Let ifile1 be a time series of the daily mean temperature TG, and",
    "    ifile2 be the 90th percentile TGn90 of daily mean temperatures",
    "    for any period used as reference. Then the percentage of time where TG > TGn90 ",
    "    is calculated. ",
    "    TGn90 is calculated as the 90th percentile of daily mean temperatures of a five ",
    "    day window centred on each calendar day of a given climate reference period.",
    "    Note that both TG and TGn90 have to be given in the same units.",
    "    The date information of a timestep in ofile is the date of",
    "    the last contributing timestep in ifile1.",
    "    The following variables are created: ",
    "    - warm_days_percent_wrt_90th_percentile_of_reference_period",
    NULL
};

static const char *EcaTn10pHelp[] = {
    "NAME",
    "    eca_tn10p - Cold nights percent wrt 10th percentile of reference period",
    "",
    "SYNOPSIS",
    "    eca_tn10p  ifile1 ifile2 ofile",
    "",
    "DESCRIPTION",
    "    Let ifile1 be a time serie of the daily minimum temperature TN, and",
    "    ifile2 be the 10th percentile TNn10 of daily minimum temperatures",
    "    for any period used as reference. Then the percentage of time where TN < TNn10 ",
    "    is calculated.",
    "    TNn10 is calculated as the 10th percentile of daily minimum temperatures of a five ",
    "    day window centred on each calendar day of a given climate reference period.",
    "    Note that both TN and TNn10 have to be given in the same units.",
    "    The date information of a timestep in ofile is the date of",
    "    the last contributing timestep in ifile1.",
    "    The following variables are created: ",
    "    - cold_nights_percent_wrt_10th_percentile_of_reference_period",
    NULL
};

static const char *EcaTn90pHelp[] = {
    "NAME",
    "    eca_tn90p - Warm nights percent wrt 90th percentile of reference period",
    "",
    "SYNOPSIS",
    "    eca_tn90p  ifile1 ifile2 ofile",
    "",
    "DESCRIPTION",
    "    Let ifile1 be a time series of the daily minimum temperature TN, and ifile2 be the ",
    "    90th percentile TNn90 of daily minimum temperatures for any period used as reference. ",
    "    Then the percentage of time where TN > TNn90 is calculated. TNn90 is calculated as the 90th percentile",
    "    of daily minimum temperatures of a five day window centred on each calendar day of a given climate",
    "    reference period. Note that both TN and TNn90 have to be given in the same units.",
    "    The date information of a timestep in ofile is the date of the last contributing timestep in ifile1.",
    "    The following variables are created: ",
    "    - warm_nights_percent_wrt_90th_percentile_of_reference_period",
    NULL
};

static const char *EcaTrHelp[] = {
    "NAME",
    "    eca_tr - Tropical nights index per time period",
    "",
    "SYNOPSIS",
    "    eca_tr[,T]  ifile ofile",
    "",
    "DESCRIPTION",
    "    Let ifile be a time series of the daily minimum temperature TN, then the number of days where ",
    "    TN > T is counted. The number T is an optional parameter with default T = 20°C. ",
    "    Note that TN have to be given in units of Kelvin, whereas T have to be given in degrees Celsius.",
    "    The date information of a timestep in ofile is the date of the last contributing timestep in ifile.",
    "    The following variables are created: ",
    "    - tropical_nights_index_per_time_period",
    "",
    "PARAMETER",
    "    T  FLOAT   Temperature threshold (unit: °C; default: T = 20°C)",
    NULL
};

static const char *EcaTx10pHelp[] = {
    "NAME",
    "    eca_tx10p - Very cold days percent wrt 10th percentile of reference period",
    "",
    "SYNOPSIS",
    "    eca_tx10p  ifile1 ifile2 ofile",
    "",
    "DESCRIPTION",
    "    Let ifile1 be a time series of the daily maximum temperature TX, and",
    "    ifile2 be the 10th percentile TXn10 of daily maximum temperatures",
    "    for any period used as reference. Then the percentage of time where TX < TXn10.",
    "    is calculated.",
    "    TXn10 is calculated as the 10th percentile of daily maximum temperatures of a five ",
    "    day window centred on each calendar day of a given climate reference period.",
    "    Note that both TX and TXn10 have to be givenin the same units.",
    "    The date information of a timestep in ofile is the date of",
    "    the last contributing timestep in ifile1.",
    "    The following variables are created: ",
    "    - very_cold_days_percent_wrt_10th_percentile_of_reference_period",
    NULL
};

static const char *EcaTx90pHelp[] = {
    "NAME",
    "    eca_tx90p - Very warm days percent wrt 90th percentile of reference period",
    "",
    "SYNOPSIS",
    "    eca_tx90p  ifile1 ifile2 ofile",
    "",
    "DESCRIPTION",
    "    Let ifile1 be a time series of the daily maximum temperature TX, and",
    "    ifile2 be the 90th percentile TXn90 of daily maximum temperatures",
    "    for any period used as reference. Then the percentage of time where TX > TXn90.",
    "    is calculated.",
    "    TXn90 is calculated as the 90th percentile of daily maximum temperatures of a five ",
    "    day window centred on each calendar day of a given climate reference period.",
    "    Note that both TX and TXn90 have to be given in the same units.",
    "    The date information of a timestep in ofile is the date of",
    "    the last contributing timestep in ifile1.",
    "    The following variables are created: ",
    "    - very_warm_days_percent_wrt_90th_percentile_of_reference_period",
    NULL
};
