/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.gsfc.spdf.cdfj;

import gov.nasa.gsfc.spdf.cdfj.AArray;
import gov.nasa.gsfc.spdf.cdfj.ByteVarContainer;
import gov.nasa.gsfc.spdf.cdfj.CDFImpl;
import gov.nasa.gsfc.spdf.cdfj.DataTypes;
import gov.nasa.gsfc.spdf.cdfj.StringArray;
import gov.nasa.gsfc.spdf.cdfj.VDataContainer;
import gov.nasa.gsfc.spdf.cdfj.Variable;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;

public final class StringVarContainer
extends ByteVarContainer
implements VDataContainer.CString {
    public StringVarContainer(CDFImpl cDFImpl, Variable variable, int[] nArray) throws IllegalAccessException, InvocationTargetException, Throwable {
        super(cDFImpl, variable, nArray);
    }

    public static boolean isCompatible(int n, boolean bl) {
        if (StringVarContainer.isCompatible(n, bl, Byte.TYPE)) {
            boolean bl2 = DataTypes.isStringType(n);
            return bl2;
        }
        return false;
    }

    @Override
    public Object _asArray() throws Throwable {
        int n = this.var.getEffectiveRank();
        if (n > 1) {
            throw new Throwable("Rank > 1 not supported for strings.");
        }
        ByteBuffer byteBuffer = this.getBuffer();
        if (byteBuffer == null) {
            return null;
        }
        int n2 = byteBuffer.remaining();
        int n3 = -1;
        int n4 = this.var.getNumberOfElements();
        byte[] byArray = new byte[n4];
        switch (n) {
            case 0: {
                n3 = n2 / n4;
                String[] stringArray = new String[n3];
                for (int i = 0; i < n3; ++i) {
                    byteBuffer.get(byArray);
                    stringArray[i] = new String(byArray);
                }
                return stringArray;
            }
            case 1: {
                int n5 = (Integer)this.var.getElementCount().elementAt(0);
                n3 = n2 / (n5 * n4);
                String[][] stringArray = new String[n3][n5];
                for (int i = 0; i < n3; ++i) {
                    for (int j = 0; j < n5; ++j) {
                        byteBuffer.get(byArray);
                        stringArray[i][j] = new String(byArray);
                    }
                }
                return stringArray;
            }
        }
        throw new Throwable("Internal error");
    }

    @Override
    public byte[] as1DArray() {
        return super.as1DArray();
    }

    @Override
    public byte[] asOneDArray() {
        return super.asOneDArray();
    }

    @Override
    public byte[] asOneDArray(boolean bl) {
        return super.asOneDArray(bl);
    }

    @Override
    public AArray asArray() throws Throwable {
        return new StringArray(this._asArray());
    }
}

