/*
 * Decompiled with CFR 0.152.
 */
package gsfc.nssdc.cdf.util;

import gsfc.nssdc.cdf.CDFConstants;
import gsfc.nssdc.cdf.CDFException;
import gsfc.nssdc.cdf.util.Epoch;
import gsfc.nssdc.cdf.util.Epoch16;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Array;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.TimeZone;

public class CDFTT2000
implements CDFConstants {
    private static int JulianDateJ2000_12h = 2451545;
    private static int J2000Since0AD12h = 730485;
    private static double J2000Since0AD12hSec = 6.3113904E10;
    private static double J2000Since0AD12hMilsec = 6.3113904E13;
    private static double J2000LeapSeconds = 32.0;
    private static double dT = 32.184;
    private static long dTinNanoSecs = 32184000000L;
    private static double MJDbase = 2400000.5;
    private static long SECinNanoSecs = 1000000000L;
    private static double SECinNanoSecsD = 1.0E9;
    private static long DAYinNanoSecs = 86400000000000L;
    private static long HOURinNanoSecs = 3600000000000L;
    private static long MINUTEinNanoSecs = 60000000000L;
    private static long T12hinNanoSecs = 43200000000000L;
    private static long JDY17070922 = 2344793L;
    private static long JDY22920411 = 2558297L;
    private static int NERA1 = 14;
    private static int LASTLEAPSECONDDAY = 20170101;
    private static double[][] LTS = new double[][]{{1960.0, 1.0, 1.0, 1.417818, 37300.0, 0.001296}, {1961.0, 1.0, 1.0, 1.422818, 37300.0, 0.001296}, {1961.0, 8.0, 1.0, 1.372818, 37300.0, 0.001296}, {1962.0, 1.0, 1.0, 1.845858, 37665.0, 0.0011232}, {1963.0, 11.0, 1.0, 1.945858, 37665.0, 0.0011232}, {1964.0, 1.0, 1.0, 3.24013, 38761.0, 0.001296}, {1964.0, 4.0, 1.0, 3.34013, 38761.0, 0.001296}, {1964.0, 9.0, 1.0, 3.44013, 38761.0, 0.001296}, {1965.0, 1.0, 1.0, 3.54013, 38761.0, 0.001296}, {1965.0, 3.0, 1.0, 3.64013, 38761.0, 0.001296}, {1965.0, 7.0, 1.0, 3.74013, 38761.0, 0.001296}, {1965.0, 9.0, 1.0, 3.84013, 38761.0, 0.001296}, {1966.0, 1.0, 1.0, 4.31317, 39126.0, 0.002592}, {1968.0, 2.0, 1.0, 4.21317, 39126.0, 0.002592}, {1972.0, 1.0, 1.0, 10.0, 0.0, 0.0}, {1972.0, 7.0, 1.0, 11.0, 0.0, 0.0}, {1973.0, 1.0, 1.0, 12.0, 0.0, 0.0}, {1974.0, 1.0, 1.0, 13.0, 0.0, 0.0}, {1975.0, 1.0, 1.0, 14.0, 0.0, 0.0}, {1976.0, 1.0, 1.0, 15.0, 0.0, 0.0}, {1977.0, 1.0, 1.0, 16.0, 0.0, 0.0}, {1978.0, 1.0, 1.0, 17.0, 0.0, 0.0}, {1979.0, 1.0, 1.0, 18.0, 0.0, 0.0}, {1980.0, 1.0, 1.0, 19.0, 0.0, 0.0}, {1981.0, 7.0, 1.0, 20.0, 0.0, 0.0}, {1982.0, 7.0, 1.0, 21.0, 0.0, 0.0}, {1983.0, 7.0, 1.0, 22.0, 0.0, 0.0}, {1985.0, 7.0, 1.0, 23.0, 0.0, 0.0}, {1988.0, 1.0, 1.0, 24.0, 0.0, 0.0}, {1990.0, 1.0, 1.0, 25.0, 0.0, 0.0}, {1991.0, 1.0, 1.0, 26.0, 0.0, 0.0}, {1992.0, 7.0, 1.0, 27.0, 0.0, 0.0}, {1993.0, 7.0, 1.0, 28.0, 0.0, 0.0}, {1994.0, 7.0, 1.0, 29.0, 0.0, 0.0}, {1996.0, 1.0, 1.0, 30.0, 0.0, 0.0}, {1997.0, 7.0, 1.0, 31.0, 0.0, 0.0}, {1999.0, 1.0, 1.0, 32.0, 0.0, 0.0}, {2006.0, 1.0, 1.0, 33.0, 0.0, 0.0}, {2009.0, 1.0, 1.0, 34.0, 0.0, 0.0}, {2012.0, 7.0, 1.0, 35.0, 0.0, 0.0}, {2015.0, 7.0, 1.0, 36.0, 0.0, 0.0}, {2017.0, 1.0, 1.0, 37.0, 0.0, 0.0}};
    private static int NDAT = Array.getLength(LTS);
    private static double[][] LTD;
    private static long[] NST;
    private static long[] NST2;
    private static int entryCnt;
    private static long[] doys1;
    private static long[] doys2;
    private static long[] daym1;
    private static long[] daym2;
    private static boolean tableChecked;
    private static int openCDF64s;
    private static double toPlus;
    private static long currentDay;
    private static double currentLeapSeconds;
    private static double currentJDay;
    private static int MAX_ePART_LEN;
    private static int fromFile;

    private static String MonthToken(long l) {
        switch ((int)l) {
            case 1: {
                return "Jan";
            }
            case 2: {
                return "Feb";
            }
            case 3: {
                return "Mar";
            }
            case 4: {
                return "Apr";
            }
            case 5: {
                return "May";
            }
            case 6: {
                return "Jun";
            }
            case 7: {
                return "Jul";
            }
            case 8: {
                return "Aug";
            }
            case 9: {
                return "Sep";
            }
            case 10: {
                return "Oct";
            }
            case 11: {
                return "Nov";
            }
            case 12: {
                return "Dec";
            }
        }
        return "???";
    }

    private static int MonthNumber(String string) {
        String string2 = string.toLowerCase();
        if (string2.equals("jan")) {
            return 1;
        }
        if (string2.equals("feb")) {
            return 2;
        }
        if (string2.equals("mar")) {
            return 3;
        }
        if (string2.equals("apr")) {
            return 4;
        }
        if (string2.equals("may")) {
            return 5;
        }
        if (string2.equals("jun")) {
            return 6;
        }
        if (string2.equals("jul")) {
            return 7;
        }
        if (string2.equals("aug")) {
            return 8;
        }
        if (string2.equals("sep")) {
            return 9;
        }
        if (string2.equals("oct")) {
            return 10;
        }
        if (string2.equals("nov")) {
            return 11;
        }
        if (string2.equals("dec")) {
            return 12;
        }
        return 0;
    }

    private static double JulianDay12h(long l, long l2, long l3) {
        if (l2 == 0L) {
            l2 = 1L;
        }
        return 367L * l - 7L * (l + (l2 + 9L) / 12L) / 4L - 3L * ((l + (l2 - 9L) / 7L) / 100L + 1L) / 4L + 275L * l2 / 9L + l3 + 1721029L;
    }

    private static int ValidateYMD(long l, long l2, long l3) {
        if (l <= 0L || l2 < 0L || l3 < 0L) {
            return 0;
        }
        double d = CDFTT2000.JulianDay12h(l, l2, l3);
        if (d < (double)JDY17070922 || d > (double)JDY22920411) {
            return 0;
        }
        return 1;
    }

    private static long[] DatefromJulianDay(double d) {
        long l = (long)(d + 68569.0);
        long l2 = 4L * l / 146097L;
        long l3 = 4000L * ((l -= (146097L * l2 + 3L) / 4L) + 1L) / 1461001L;
        l = l - 1461L * l3 / 4L + 31L;
        long l4 = 80L * l / 2447L;
        long l5 = l - 2447L * l4 / 80L;
        l = l4 / 11L;
        l4 = l4 + 2L - 12L * l;
        l3 = 100L * (l2 - 49L) + l3 + l;
        long[] lArray = new long[]{l3, l4, l5};
        return lArray;
    }

    private static int scanUTCstring(String string) {
        int n = string.length();
        if ((long)n == 29L || n >= 19 && (string.charAt(10) == 'T' || string.charAt(10) == 't' || string.charAt(10) == ' ' || string.charAt(10) == '/') && string.charAt(n - 1) != 'Z') {
            return 3;
        }
        if ((long)n <= 30L && string.charAt(11) == ' ') {
            return 0;
        }
        if ((long)n == 30L || n >= 19 && (string.charAt(10) == 'T' || string.charAt(10) == 't' || string.charAt(10) == ' ' || string.charAt(10) == '/') && string.charAt(n - 1) == 'Z') {
            return 4;
        }
        if ((long)n == 19L || n > 9 && string.charAt(8) == '.') {
            return 1;
        }
        if ((long)n == 14L) {
            return 2;
        }
        if ((long)n == 31L && string.charAt(11) == ' ' && (string.endsWith("Z") || string.endsWith("z"))) {
            return 0;
        }
        return -1;
    }

    private static long[] EPOCHbreakdownTT2000(double d) {
        double d2 = d;
        double d3 = d2 / 60.0;
        double d4 = d3 / 60.0;
        double d5 = d4 / 24.0;
        long l = (long)(1721060.0 + d5);
        long l2 = l + 68569L;
        long l3 = 4L * l2 / 146097L;
        long l4 = 4000L * ((l2 -= (146097L * l3 + 3L) / 4L) + 1L) / 1461001L;
        l2 = l2 - 1461L * l4 / 4L + 31L;
        long l5 = 80L * l2 / 2447L;
        long l6 = l2 - 2447L * l5 / 80L;
        l2 = l5 / 11L;
        l5 = l5 + 2L - 12L * l2;
        l4 = 100L * (l3 - 49L) + l4 + l2;
        long[] lArray = new long[]{l4, l5, l6, (long)(d4 % 24.0), (long)(d3 % 60.0), (long)(d2 % 60.0)};
        return lArray;
    }

    private static void appendFractionPart(StringBuffer stringBuffer, double d, int n, String string) {
        int n2;
        int n3;
        StringBuffer stringBuffer2;
        StringBuffer stringBuffer3;
        block8: {
            stringBuffer3 = new StringBuffer(MAX_ePART_LEN + 1);
            NumberFormat numberFormat = NumberFormat.getNumberInstance(Locale.US);
            stringBuffer2 = new StringBuffer();
            numberFormat.setParseIntegerOnly(true);
            if (!string.equals("")) {
                try {
                    n3 = numberFormat.parse(string).intValue();
                    if (n3 < 1) {
                        stringBuffer.append("?");
                        System.out.println("append ? (3)");
                        return;
                    }
                    break block8;
                }
                catch (ParseException parseException) {
                    stringBuffer.append("?");
                    System.out.println("append ? (4)");
                    return;
                }
            }
            n3 = n;
        }
        for (n2 = 0; n2 < n3 + 2; ++n2) {
            stringBuffer2.append("0");
        }
        stringBuffer2.append(".");
        for (n2 = 0; n2 < n3; ++n2) {
            stringBuffer2.append("0");
        }
        DecimalFormat decimalFormat = new DecimalFormat(stringBuffer2.toString());
        stringBuffer3.append(decimalFormat.format(d));
        if (stringBuffer3.charAt(0) == '1') {
            for (n2 = 0; n2 < n3; ++n2) {
                stringBuffer3.setCharAt(n2 + 2, '9');
            }
        }
        String string2 = stringBuffer3.toString();
        char c = new DecimalFormat().getDecimalFormatSymbols().getDecimalSeparator();
        CDFTT2000.appendPart(stringBuffer, string2.substring(string2.indexOf(c) + 1), n3, false);
    }

    private static void appendIntegerPart(StringBuffer stringBuffer, long l, int n, boolean bl, String string) {
        boolean bl2;
        int n2;
        StringBuffer stringBuffer2 = new StringBuffer(MAX_ePART_LEN + 1);
        char[] cArray = string.toCharArray();
        NumberFormat numberFormat = NumberFormat.getNumberInstance(Locale.US);
        numberFormat.setParseIntegerOnly(true);
        if (!string.equals("")) {
            try {
                n2 = numberFormat.parse(string).intValue();
                if (n2 < 0) {
                    stringBuffer.append("?");
                    System.out.println("append ? (5)");
                    return;
                }
                bl2 = cArray[0] == '0';
            }
            catch (ParseException parseException) {
                stringBuffer.append("?");
                System.out.println("append ? (6)");
                return;
            }
        } else {
            n2 = n;
            bl2 = bl;
        }
        stringBuffer2.append("" + l);
        CDFTT2000.appendPart(stringBuffer, stringBuffer2.toString(), n2, bl2);
    }

    private static void appendPart(StringBuffer stringBuffer, String string, int n, boolean bl) {
        if (n == 0) {
            stringBuffer.append(string);
        } else {
            int n2 = string.length();
            if (n2 > n) {
                for (int i = 0; i < n; ++i) {
                    stringBuffer.append("*");
                }
            } else {
                int n3 = n - n2;
                if (n3 > 0) {
                    for (int i = 0; i < n3; ++i) {
                        stringBuffer.append(bl ? "0" : " ");
                    }
                }
                stringBuffer.append(string);
            }
        }
    }

    public static String getLeapSecondsTableEnvVar() {
        return System.getenv("CDF_LEAPSECONDSTABLE");
    }

    private static void LoadLeapSecondsTable() {
        if (!tableChecked) {
            int n;
            fromFile = 0;
            String string = null;
            int n2 = 0;
            tableChecked = true;
            try {
                int n3;
                StringTokenizer stringTokenizer;
                Object object;
                Object object2;
                Closeable closeable;
                Closeable closeable2;
                Object object3;
                string = CDFTT2000.getLeapSecondsTableEnvVar();
                if (string != null) {
                    object3 = new ArrayList[6];
                    for (n = 0; n < 6; ++n) {
                        object3[n] = new ArrayList();
                    }
                    closeable2 = new FileInputStream(string);
                    closeable = new DataInputStream((InputStream)closeable2);
                    object2 = new BufferedReader(new InputStreamReader((InputStream)closeable));
                    while ((object = ((BufferedReader)object2).readLine()) != null) {
                        if (((String)object).charAt(0) == ';' || (stringTokenizer = new StringTokenizer((String)object, " ")).countTokens() != 6) continue;
                        n3 = 0;
                        ++n2;
                        while (stringTokenizer.hasMoreElements()) {
                            ((ArrayList)object3[n3]).add(stringTokenizer.nextToken());
                            ++n3;
                        }
                    }
                    ((FilterInputStream)closeable).close();
                    LTD = new double[n2][6];
                    for (n3 = 0; n3 < n2; ++n3) {
                        for (n = 0; n < 6; ++n) {
                            CDFTT2000.LTD[n3][n] = new Double((String)((ArrayList)object3[n]).get(n3));
                        }
                    }
                    entryCnt = n2;
                    fromFile = 1;
                } else {
                    object3 = CDFTT2000.class.getResourceAsStream("CDFLeapSeconds.txt");
                    closeable2 = new InputStreamReader((InputStream)object3);
                    closeable = new BufferedReader((Reader)closeable2);
                    object = new ArrayList[6];
                    for (n = 0; n < 6; ++n) {
                        object[n] = new ArrayList();
                    }
                    while ((object2 = ((BufferedReader)closeable).readLine()) != null) {
                        if (((String)object2).charAt(0) == ';' || (stringTokenizer = new StringTokenizer((String)object2, " ")).countTokens() != 6) continue;
                        n3 = 0;
                        ++n2;
                        while (stringTokenizer.hasMoreElements()) {
                            ((ArrayList)object[n3]).add(stringTokenizer.nextToken());
                            ++n3;
                        }
                    }
                    ((InputStream)object3).close();
                    LTD = new double[n2][6];
                    for (n3 = 0; n3 < n2; ++n3) {
                        for (n = 0; n < 6; ++n) {
                            CDFTT2000.LTD[n3][n] = new Double((String)((ArrayList)object[n]).get(n3));
                        }
                    }
                    entryCnt = n2;
                    fromFile = 1;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (fromFile == 0) {
                LTD = new double[NDAT][6];
                for (n = 0; n < NDAT; ++n) {
                    CDFTT2000.LTD[n][0] = LTS[n][0];
                    CDFTT2000.LTD[n][1] = LTS[n][1];
                    CDFTT2000.LTD[n][2] = LTS[n][2];
                    CDFTT2000.LTD[n][3] = LTS[n][3];
                    CDFTT2000.LTD[n][4] = LTS[n][4];
                    CDFTT2000.LTD[n][5] = LTS[n][5];
                }
                entryCnt = NDAT;
            }
        }
    }

    private static void LoadLeapNanoSecondsTable() {
        if (LTD == null) {
            CDFTT2000.LoadLeapSecondsTable();
        }
        NST = new long[entryCnt];
        if (fromFile == 0) {
            System.arraycopy(NST2, 0, NST, 0, NST2.length);
        } else if (entryCnt <= NST2.length && LTD[entryCnt - 1][0] == LTS[entryCnt - 1][0]) {
            System.arraycopy(NST2, 0, NST, 0, entryCnt);
        } else {
            try {
                for (int i = NERA1; i < entryCnt; ++i) {
                    CDFTT2000.NST[i] = CDFTT2000.fromUTCparts(LTD[i][0], LTD[i][1], LTD[i][2], 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static double LeapSecondsfromYMD(long l, long l2, long l3) {
        if (LTD == null) {
            CDFTT2000.LoadLeapSecondsTable();
        }
        int n = -1;
        long l4 = 12L * l + l2;
        for (int i = entryCnt - 1; i >= 0; --i) {
            long l5 = (long)(12.0 * LTD[i][0] + LTD[i][1]);
            if (l4 < l5) continue;
            n = i;
            break;
        }
        if (n == -1) {
            return 0.0;
        }
        double d = LTD[n][3];
        if (n < NERA1) {
            double d2 = CDFTT2000.JulianDay12h(l, l2, l3);
            d += (d2 - MJDbase - LTD[n][4]) * LTD[n][5];
        }
        return d;
    }

    static double[] LeapSecondsfromJ2000(long l) {
        double[] dArray = new double[]{0.0, 0.0};
        if (NST == null) {
            CDFTT2000.LoadLeapNanoSecondsTable();
        }
        int n = -1;
        for (int i = entryCnt - 1; i >= NERA1; --i) {
            if (l < NST[i]) continue;
            n = i;
            if (i >= entryCnt - 1 || l + 1000000000L < NST[i + 1]) break;
            dArray[1] = 1.0;
            break;
        }
        if (n == -1) {
            return dArray;
        }
        dArray[0] = LTD[n][3];
        return dArray;
    }

    public static long[] breakdownTT2000(long l) {
        return CDFTT2000.toUTCparts(l);
    }

    public static long[] toUTCparts(long l) {
        long l2;
        long l3;
        long l4;
        long l5;
        long l6;
        long l7;
        long l8;
        long l9;
        if (l == Long.MIN_VALUE) {
            return new long[]{9999L, 12L, 31L, 23L, 59L, 59L, 999L, 999L, 999L};
        }
        if (l == -9223372036854775807L) {
            return new long[]{0L, 1L, 1L, 0L, 0L, 0L, 0L, 0L, 0L};
        }
        toPlus = 0.0;
        long l10 = l;
        double[] dArray = CDFTT2000.LeapSecondsfromJ2000(l);
        if (l > 0L) {
            l9 = (long)((double)l / SECinNanoSecsD);
            l8 = l - l9 * SECinNanoSecs;
            l9 -= 32L;
            l9 += 43200L;
            l8 -= 184000000L;
        } else {
            l += T12hinNanoSecs;
            l9 = (long)((double)(l -= dTinNanoSecs) / SECinNanoSecsD);
            l8 = l - l9 * SECinNanoSecs;
        }
        if (l8 < 0L) {
            l8 = SECinNanoSecs + l8;
            --l9;
        }
        long l11 = l9 * SECinNanoSecs + l8;
        if (dArray[0] > 0.0) {
            long[] lArray;
            double d = J2000Since0AD12hSec + (double)(l9 -= (long)dArray[0]);
            if (dArray[1] == 0.0) {
                lArray = CDFTT2000.EPOCHbreakdownTT2000(d);
            } else {
                lArray = CDFTT2000.EPOCHbreakdownTT2000(d -= 1.0);
                lArray[5] = lArray[5] + 1L;
            }
            l7 = lArray[0];
            l6 = lArray[1];
            l5 = lArray[2];
            l4 = lArray[3];
            l3 = lArray[4];
            l2 = lArray[5];
        } else {
            long l12;
            double d = (double)l9 + J2000Since0AD12hSec;
            long[] lArray = CDFTT2000.EPOCHbreakdownTT2000(d);
            try {
                l12 = CDFTT2000.fromUTCparts(lArray[0], lArray[1], lArray[2], lArray[3], lArray[4], lArray[5], 0.0, 0.0, l8);
            }
            catch (CDFException cDFException) {
                l12 = 0L;
            }
            if (l12 != l10) {
                long l13;
                double d2 = CDFTT2000.LeapSecondsfromYMD(lArray[0], lArray[1], lArray[2]);
                long l14 = l11 - (long)(d2 * (double)SECinNanoSecs);
                l8 = l14 - (l13 = (long)((double)l14 / SECinNanoSecsD)) * SECinNanoSecs;
                if (l8 < 0L) {
                    l8 = SECinNanoSecs + l8;
                    --l13;
                }
                d = (double)l13 + J2000Since0AD12hSec;
                lArray = CDFTT2000.EPOCHbreakdownTT2000(d);
                try {
                    l12 = CDFTT2000.fromUTCparts(lArray[0], lArray[1], lArray[2], lArray[3], lArray[4], lArray[5], 0.0, 0.0, l8);
                }
                catch (CDFException cDFException) {
                    l12 = 0L;
                }
                if (l12 != l10) {
                    d2 = CDFTT2000.LeapSecondsfromYMD(lArray[0], lArray[1], lArray[2]);
                    l14 = l11 - (long)(d2 * (double)SECinNanoSecs);
                    l8 = l14 - (l13 = (long)((double)l14 / SECinNanoSecsD)) * SECinNanoSecs;
                    if (l8 < 0L) {
                        l8 = SECinNanoSecs + l8;
                        --l13;
                    }
                    d = (double)l13 + J2000Since0AD12hSec;
                    lArray = CDFTT2000.EPOCHbreakdownTT2000(d);
                    try {
                        l12 = CDFTT2000.fromUTCparts(lArray[0], lArray[1], lArray[2], lArray[3], lArray[4], lArray[5], 0.0, 0.0, l8);
                    }
                    catch (CDFException cDFException) {
                        // empty catch block
                    }
                }
            }
            l7 = lArray[0];
            l6 = lArray[1];
            l5 = lArray[2];
            l4 = lArray[3];
            l3 = lArray[4];
            l2 = lArray[5];
        }
        long l15 = l8 / 1000000L;
        double d = l8 - 1000000L * l15;
        if (l15 > 1000L) {
            l15 -= 1000L;
        }
        long l16 = (long)(d / 1000.0);
        long l17 = (long)(d - (double)(1000L * l16));
        long[] lArray = new long[]{l7, l6, l5, l4, l3, ++l2, l15, l16, l17};
        return lArray;
    }

    public static long[] breakdown(long l) {
        return CDFTT2000.toUTCparts(l);
    }

    public static long[][] breakdown(long[] lArray) {
        if (lArray == null) {
            return null;
        }
        int n = lArray.length;
        if (n <= 0) {
            return null;
        }
        long[][] lArray2 = new long[n][9];
        for (int i = 0; i < n; ++i) {
            lArray2[i] = CDFTT2000.breakdown(lArray[i]);
        }
        return lArray2;
    }

    public static long computeTT2000(double d, double d2, double d3) throws CDFException {
        return CDFTT2000.fromUTCparts(d, d2, d3);
    }

    public static long fromUTCparts(double d, double d2, double d3) throws CDFException {
        if (d - Math.floor(d) != 0.0 || d2 - Math.floor(d2) != 0.0) {
            throw new CDFException(-2229L);
        }
        double d4 = d3;
        d3 = Math.floor(d4);
        d4 = (d4 - d3) * 24.0;
        double d5 = Math.floor(d4);
        d4 = (d4 - d5) * 60.0;
        double d6 = Math.floor(d4);
        d4 = (d4 - d6) * 60.0;
        double d7 = Math.floor(d4);
        d4 = (d4 - d7) * 1000.0;
        double d8 = Math.floor(d4);
        d4 = (d4 - d8) * 1000.0;
        double d9 = Math.floor(d4);
        double d10 = (d4 - d9) * 1000.0;
        return CDFTT2000.fromUTCparts(d, d2, d3, d5, d6, d7, d8, d9, d10);
    }

    public static long computeTT2000(double d, double d2, double d3, double d4) throws CDFException {
        return CDFTT2000.fromUTCparts(d, d2, d3, d4);
    }

    public static long fromUTCparts(double d, double d2, double d3, double d4) throws CDFException {
        if (d - Math.floor(d) != 0.0 || d2 - Math.floor(d2) != 0.0 || d3 - Math.floor(d3) != 0.0) {
            throw new CDFException(-2229L);
        }
        double d5 = d4;
        d4 = Math.floor(d5);
        d5 = (d5 - d4) * 60.0;
        double d6 = Math.floor(d5);
        d5 = (d5 - d6) * 60.0;
        double d7 = Math.floor(d5);
        d5 = (d5 - d7) * 1000.0;
        double d8 = Math.floor(d5);
        d5 = (d5 - d8) * 1000.0;
        double d9 = Math.floor(d5);
        double d10 = (d5 - d9) * 1000.0;
        return CDFTT2000.fromUTCparts(d, d2, d3, d4, d6, d7, d8, d9, d10);
    }

    public static long computeTT2000(double d, double d2, double d3, double d4, double d5) throws CDFException {
        return CDFTT2000.fromUTCparts(d, d2, d3, d4, d5);
    }

    public static long fromUTCparts(double d, double d2, double d3, double d4, double d5) throws CDFException {
        if (d - Math.floor(d) != 0.0 || d2 - Math.floor(d2) != 0.0 || d3 - Math.floor(d3) != 0.0 || d4 - Math.floor(d4) != 0.0) {
            throw new CDFException(-2229L);
        }
        double d6 = d5;
        d5 = Math.floor(d6);
        d6 = (d6 - d5) * 60.0;
        double d7 = Math.floor(d6);
        d6 = (d6 - d7) * 1000.0;
        double d8 = Math.floor(d6);
        d6 = (d6 - d8) * 1000.0;
        double d9 = Math.floor(d6);
        double d10 = (d6 - d9) * 1000.0;
        return CDFTT2000.fromUTCparts(d, d2, d3, d4, d5, d7, d8, d9, d10);
    }

    public static long computeTT2000(double d, double d2, double d3, double d4, double d5, double d6) throws CDFException {
        return CDFTT2000.fromUTCparts(d, d2, d3, d4, d5, d6);
    }

    public static long fromUTCparts(double d, double d2, double d3, double d4, double d5, double d6) throws CDFException {
        if (d - Math.floor(d) != 0.0 || d2 - Math.floor(d2) != 0.0 || d3 - Math.floor(d3) != 0.0 || d4 - Math.floor(d4) != 0.0 || d5 - Math.floor(d5) != 0.0) {
            throw new CDFException(-2229L);
        }
        double d7 = d6;
        d6 = Math.floor(d7);
        d7 = (d7 - d6) * 1000.0;
        double d8 = Math.floor(d7);
        d7 = (d7 - d8) * 1000.0;
        double d9 = Math.floor(d7);
        double d10 = (d7 - d9) * 1000.0;
        return CDFTT2000.fromUTCparts(d, d2, d3, d4, d5, d6, d8, d9, d10);
    }

    public static long computeTT2000(double d, double d2, double d3, double d4, double d5, double d6, double d7) throws CDFException {
        return CDFTT2000.fromUTCparts(d, d2, d3, d4, d5, d6, d7);
    }

    public static long fromUTCparts(double d, double d2, double d3, double d4, double d5, double d6, double d7) throws CDFException {
        if (d - Math.floor(d) != 0.0 || d2 - Math.floor(d2) != 0.0 || d3 - Math.floor(d3) != 0.0 || d4 - Math.floor(d4) != 0.0 || d5 - Math.floor(d5) != 0.0 || d6 - Math.floor(d6) != 0.0) {
            throw new CDFException(-2229L);
        }
        double d8 = d7;
        d7 = Math.floor(d8);
        d8 = (d8 - d7) * 1000.0;
        double d9 = Math.floor(d8);
        double d10 = (d8 - d9) * 1000.0;
        return CDFTT2000.fromUTCparts(d, d2, d3, d4, d5, d6, d7, d9, d10);
    }

    public static long computeTT2000(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) throws CDFException {
        return CDFTT2000.fromUTCparts(d, d2, d3, d4, d5, d6, d7, d8);
    }

    public static long fromUTCparts(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) throws CDFException {
        if (d - Math.floor(d) != 0.0 || d2 - Math.floor(d2) != 0.0 || d3 - Math.floor(d3) != 0.0 || d4 - Math.floor(d4) != 0.0 || d5 - Math.floor(d5) != 0.0 || d6 - Math.floor(d6) != 0.0 || d7 - Math.floor(d7) != 0.0) {
            throw new CDFException(-2229L);
        }
        double d9 = d8;
        d8 = Math.floor(d9);
        double d10 = (d9 - d8) * 1000.0;
        return CDFTT2000.fromUTCparts(d, d2, d3, d4, d5, d6, d7, d8, d10);
    }

    public static long computeTT2000(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) throws CDFException {
        return CDFTT2000.fromUTCparts(d, d2, d3, d4, d5, d6, d7, d8, d9);
    }

    public static long fromUTCparts(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) throws CDFException {
        long l;
        boolean bl;
        long[] lArray;
        double d10;
        double d11;
        double d12;
        double d13;
        double d14;
        double d15;
        if (d < 0.0 || d2 < 0.0 || d3 < 0.0 || d4 < 0.0 || d5 < 0.0 || d6 < 0.0 || d7 < 0.0 || d8 < 0.0 || d9 < 0.0) {
            throw new CDFException(-2229L);
        }
        long l2 = (long)Math.floor(d);
        if (d2 == 0.0) {
            d2 = 1.0;
        }
        long l3 = (long)Math.floor(d2);
        long l4 = (long)Math.floor(d3);
        long l5 = (long)Math.floor(d4);
        long l6 = (long)Math.floor(d5);
        long l7 = (long)Math.floor(d6);
        long l8 = (long)Math.floor(d7);
        long l9 = (long)Math.floor(d8);
        if (d - (double)l2 != 0.0 || d2 - (double)l3 != 0.0 || d3 - (double)l4 != 0.0 || d4 - (double)l5 != 0.0 || d5 - (double)l6 != 0.0 || d6 - (double)l7 != 0.0 || d7 - (double)l8 != 0.0 || d8 - (double)l9 != 0.0) {
            throw new CDFException(-2229L);
        }
        l3 = -999L;
        l2 = -999L;
        if (d9 >= 1000.0) {
            d15 = Math.floor(d9 / 8.64E13);
            d14 = Math.floor((d9 %= 8.64E13) / 3.6E12);
            d13 = Math.floor((d9 %= 3.6E12) / 6.0E10);
            d12 = Math.floor((d9 %= 6.0E10) / 1.0E9);
            d11 = Math.floor((d9 %= 1.0E9) / 1000000.0);
            double d16 = Math.floor((d9 %= 1000000.0) / 1000.0);
            d9 %= 1000.0;
            d3 += d15;
            d4 += d14;
            d5 += d13;
            d6 += d12;
            d7 += d11;
            d8 += d16;
            d10 = CDFTT2000.JulianDay12h((long)d, (long)d2, (long)d3);
            lArray = CDFTT2000.DatefromJulianDay(d10);
            l2 = lArray[0];
            l3 = lArray[1];
            l4 = lArray[2];
        }
        if (d8 >= 1000.0) {
            d15 = Math.floor(d8 / 8.64E10);
            d14 = Math.floor((d8 %= 8.64E10) / 3.6E9);
            d13 = Math.floor((d8 %= 3.6E9) / 6.0E7);
            d12 = Math.floor((d8 %= 6.0E7) / 1000000.0);
            d11 = Math.floor((d8 %= 1000000.0) / 1000.0);
            d8 %= 1000.0;
            d4 += d14;
            d5 += d13;
            d6 += d12;
            d7 += d11;
            d10 = CDFTT2000.JulianDay12h((long)d, (long)d2, (long)(d3 += d15));
            lArray = CDFTT2000.DatefromJulianDay(d10);
            l2 = lArray[0];
            l3 = lArray[1];
            l4 = lArray[2];
        }
        if (d7 >= 1000.0) {
            d15 = Math.floor(d7 / 8.64E7);
            d14 = Math.floor((d7 %= 8.64E7) / 3600000.0);
            d13 = Math.floor((d7 %= 3600000.0) / 60000.0);
            d12 = Math.floor((d7 %= 60000.0) / 1000.0);
            d7 %= 1000.0;
            d4 += d14;
            d5 += d13;
            d6 += d12;
            d10 = CDFTT2000.JulianDay12h((long)d, (long)d2, (long)(d3 += d15));
            lArray = CDFTT2000.DatefromJulianDay(d10);
            l2 = lArray[0];
            l3 = lArray[1];
            l4 = lArray[2];
        }
        d10 = CDFTT2000.JulianDay12h((long)d, (long)d2, (long)d3);
        lArray = CDFTT2000.DatefromJulianDay(d10 + 1.0);
        toPlus = CDFTT2000.LeapSecondsfromYMD(lArray[0], lArray[1], lArray[2]) - CDFTT2000.LeapSecondsfromYMD((long)d, (long)d2, (long)d3);
        if (d6 >= 60.0 + (toPlus = Math.floor(toPlus))) {
            d15 = Math.floor(d6 / (86400.0 + toPlus));
            d14 = Math.floor((d6 %= 86400.0 + toPlus) / (3600.0 + toPlus));
            d13 = Math.floor((d6 %= 3600.0 + toPlus) / (60.0 + toPlus));
            d6 %= 60.0 + toPlus;
            d4 += d14;
            d5 += d13;
            d10 = CDFTT2000.JulianDay12h((long)d, (long)d2, (long)(d3 += d15));
            lArray = CDFTT2000.DatefromJulianDay(d10);
            l2 = lArray[0];
            l3 = lArray[1];
            l4 = lArray[2];
        }
        if (d5 >= 60.0) {
            d15 = Math.floor(d5 / 1440.0);
            d14 = Math.floor((d5 %= 1440.0) / 60.0);
            d5 %= 60.0;
            d4 += d14;
            d10 = CDFTT2000.JulianDay12h((long)d, (long)d2, (long)(d3 += d15));
            lArray = CDFTT2000.DatefromJulianDay(d10);
            l2 = lArray[0];
            l3 = lArray[1];
            l4 = lArray[2];
        }
        if (d4 >= 24.0) {
            d15 = Math.floor(d4 / 24.0);
            d4 %= 24.0;
            d10 = CDFTT2000.JulianDay12h((long)d, (long)d2, (long)(d3 += d15));
            lArray = CDFTT2000.DatefromJulianDay(d10);
            l2 = lArray[0];
            l3 = lArray[1];
            l4 = lArray[2];
        }
        if (l2 == -999L && l3 == -999L) {
            l2 = (long)d;
            l3 = (long)d2;
            l4 = (long)d3;
        }
        l5 = (long)d4;
        l6 = (long)d5;
        l7 = (long)d6;
        l8 = (long)d7;
        l9 = (long)d8;
        long l10 = (long)d9;
        if (l2 == 9999L && l3 == 12L && l4 == 31L && l5 == 23L && l6 == 59L && l7 == 59L && l8 == 999L && l9 == 999L && l10 == 999L) {
            return Long.MIN_VALUE;
        }
        if (l2 == 0L && l3 == 1L && l4 == 1L && l5 == 0L && l6 == 0L && l7 == 0L && l8 == 0L && l9 == 0L && l10 == 0L) {
            return -9223372036854775807L;
        }
        if ((l2 < 1708L || l2 > 2291L) && CDFTT2000.ValidateYMD(l2, l3, l4) == 0) {
            throw new CDFException(-2229L);
        }
        boolean bl2 = bl = (l2 & 3L) == 0L && (l2 % 25L != 0L || (l2 & 0xFL) == 0L);
        if (!bl && l4 > 365L || bl && l4 > 366L) {
            throw new CDFException(-2229L);
        }
        if (!bl && l3 > 1L && l4 > daym1[(int)l3 - 1] || bl && l3 > 1L && l4 > daym2[(int)l3 - 1]) {
            throw new CDFException(-2229L);
        }
        if (l3 <= 1L && l4 > 31L) {
            if (l3 == 0L) {
                l3 = 1L;
            }
            for (int i = 0; i < 12; ++i) {
                if ((bl || l4 > doys1[i]) && (!bl || l4 > doys2[i])) continue;
                if (i == 0) break;
                l3 = i + 1;
                if (!bl) {
                    l4 -= doys1[i - 1];
                    break;
                }
                l4 -= doys2[i - 1];
                break;
            }
        }
        if ((l = 10000000L * l3 + 10000L * l4 + l2) != currentDay) {
            currentDay = l;
            currentLeapSeconds = CDFTT2000.LeapSecondsfromYMD(l2, l3, l4);
            currentJDay = CDFTT2000.JulianDay12h(l2, l3, l4);
        }
        double d17 = currentJDay;
        long l11 = l5 * HOURinNanoSecs + l6 * MINUTEinNanoSecs + l7 * SECinNanoSecs + l8 * 1000000L + l9 * 1000L + l10;
        long l12 = (long)(d17 -= (double)JulianDateJ2000_12h) * DAYinNanoSecs + l11;
        long l13 = (long)(currentLeapSeconds * (double)SECinNanoSecs);
        if (l12 < 0L) {
            l12 += l13;
            l12 += dTinNanoSecs;
            l12 -= T12hinNanoSecs;
        } else {
            l12 -= T12hinNanoSecs;
            l12 += l13;
            l12 += dTinNanoSecs;
        }
        return l12;
    }

    public static long compute(long l, long l2, long l3, long l4, long l5, long l6, long l7, long l8, long l9) throws CDFException {
        return CDFTT2000.fromUTCparts(l, l2, l3, l4, l5, l6, l7, l8, l9);
    }

    public static long[] compute(long[] lArray, long[] lArray2, long[] lArray3) throws CDFException {
        if (lArray == null || lArray2 == null || lArray3 == null) {
            return null;
        }
        int n = lArray.length;
        if (n != lArray2.length || n != lArray3.length) {
            return null;
        }
        long[] lArray4 = new long[n];
        for (int i = 0; i < n; ++i) {
            lArray4[i] = CDFTT2000.compute(lArray[i], lArray2[i], lArray3[i], 0L, 0L, 0L, 0L, 0L, 0L);
        }
        return lArray4;
    }

    public static long[] compute(long[] lArray, long[] lArray2, long[] lArray3, long[] lArray4) throws CDFException {
        if (lArray == null || lArray2 == null || lArray3 == null || lArray4 == null) {
            return null;
        }
        int n = lArray.length;
        if (n != lArray2.length || n != lArray3.length || n != lArray4.length) {
            return null;
        }
        long[] lArray5 = new long[n];
        for (int i = 0; i < n; ++i) {
            lArray5[i] = CDFTT2000.compute(lArray[i], lArray2[i], lArray3[i], lArray4[i], 0L, 0L, 0L, 0L, 0L);
        }
        return lArray5;
    }

    public static long[] compute(long[] lArray, long[] lArray2, long[] lArray3, long[] lArray4, long[] lArray5) throws CDFException {
        if (lArray == null || lArray2 == null || lArray3 == null || lArray4 == null || lArray5 == null) {
            return null;
        }
        int n = lArray.length;
        if (n != lArray2.length || n != lArray3.length || n != lArray4.length || n != lArray5.length) {
            return null;
        }
        long[] lArray6 = new long[n];
        for (int i = 0; i < n; ++i) {
            lArray6[i] = CDFTT2000.compute(lArray[i], lArray2[i], lArray3[i], lArray4[i], lArray5[i], 0L, 0L, 0L, 0L);
        }
        return lArray6;
    }

    public static long[] compute(long[] lArray, long[] lArray2, long[] lArray3, long[] lArray4, long[] lArray5, long[] lArray6) throws CDFException {
        if (lArray == null || lArray2 == null || lArray3 == null || lArray4 == null || lArray5 == null || lArray6 == null) {
            return null;
        }
        int n = lArray.length;
        if (n != lArray2.length || n != lArray3.length || n != lArray4.length || n != lArray5.length || n != lArray6.length) {
            return null;
        }
        long[] lArray7 = new long[n];
        for (int i = 0; i < n; ++i) {
            lArray7[i] = CDFTT2000.compute(lArray[i], lArray2[i], lArray3[i], lArray4[i], lArray5[i], lArray6[i], 0L, 0L, 0L);
        }
        return lArray7;
    }

    public static long[] compute(long[] lArray, long[] lArray2, long[] lArray3, long[] lArray4, long[] lArray5, long[] lArray6, long[] lArray7) throws CDFException {
        if (lArray == null || lArray2 == null || lArray3 == null || lArray4 == null || lArray5 == null || lArray6 == null || lArray7 == null) {
            return null;
        }
        int n = lArray.length;
        if (n != lArray2.length || n != lArray3.length || n != lArray4.length || n != lArray5.length || n != lArray6.length || n != lArray7.length) {
            return null;
        }
        long[] lArray8 = new long[n];
        for (int i = 0; i < n; ++i) {
            lArray8[i] = CDFTT2000.compute(lArray[i], lArray2[i], lArray3[i], lArray4[i], lArray5[i], lArray6[i], lArray7[i], 0L, 0L);
        }
        return lArray8;
    }

    public static long[] compute(long[] lArray, long[] lArray2, long[] lArray3, long[] lArray4, long[] lArray5, long[] lArray6, long[] lArray7, long[] lArray8) throws CDFException {
        if (lArray == null || lArray2 == null || lArray3 == null || lArray4 == null || lArray5 == null || lArray6 == null || lArray7 == null || lArray8 == null) {
            return null;
        }
        int n = lArray.length;
        if (n != lArray2.length || n != lArray3.length || n != lArray4.length || n != lArray5.length || n != lArray6.length || n != lArray7.length || n != lArray8.length) {
            return null;
        }
        long[] lArray9 = new long[n];
        for (int i = 0; i < n; ++i) {
            lArray9[i] = CDFTT2000.compute(lArray[i], lArray2[i], lArray3[i], lArray4[i], lArray5[i], lArray6[i], lArray7[i], lArray8[i], 0L);
        }
        return lArray9;
    }

    public static long[] compute(long[] lArray, long[] lArray2, long[] lArray3, long[] lArray4, long[] lArray5, long[] lArray6, long[] lArray7, long[] lArray8, long[] lArray9) throws CDFException {
        if (lArray == null || lArray2 == null || lArray3 == null || lArray4 == null || lArray5 == null || lArray6 == null || lArray7 == null || lArray8 == null || lArray9 == null) {
            return null;
        }
        int n = lArray.length;
        if (n != lArray2.length || n != lArray3.length || n != lArray4.length || n != lArray5.length || n != lArray6.length || n != lArray7.length || n != lArray8.length || n != lArray9.length) {
            return null;
        }
        long[] lArray10 = new long[n];
        for (int i = 0; i < n; ++i) {
            lArray10[i] = CDFTT2000.compute(lArray[i], lArray2[i], lArray3[i], lArray4[i], lArray5[i], lArray6[i], lArray7[i], lArray8[i], lArray9[i]);
        }
        return lArray10;
    }

    public static double toUTCEPOCH(long l) throws CDFException {
        double d;
        if (l == Long.MIN_VALUE) {
            return -1.0E31;
        }
        if (l == -9223372036854775807L) {
            return 0.0;
        }
        if (l == -9223372036854775805L) {
            return 0.0;
        }
        long[] lArray = CDFTT2000.toUTCparts(l);
        try {
            d = Epoch.compute(lArray[0], lArray[1], lArray[2], lArray[3], lArray[4], lArray[5], lArray[6]);
        }
        catch (Exception exception) {
            double d2 = -1.0;
            throw new CDFException(-2224L);
        }
        return d;
    }

    public static long fromUTCEPOCH(double d) throws CDFException {
        if (d == -1.0E31 || d == -1.0E-31) {
            return Long.MIN_VALUE;
        }
        if (d == 0.0 || d == -0.0) {
            return -9223372036854775807L;
        }
        long[] lArray = Epoch.breakdown(d);
        if ((lArray[0] < 1708L || lArray[0] > 2291L) && CDFTT2000.ValidateYMD(lArray[0], lArray[1], lArray[2]) == 0) {
            return -9223372036854775805L;
        }
        return CDFTT2000.fromUTCparts(lArray[0], lArray[1], lArray[2], lArray[3], lArray[4], lArray[5], lArray[6], 0.0, 0.0);
    }

    public static double toUTCEPOCH16(long l, double[] dArray) throws CDFException {
        double d;
        if (l == Long.MIN_VALUE) {
            dArray[0] = -1.0E31;
            dArray[1] = -1.0E31;
            return 0.0;
        }
        if (l == -9223372036854775807L || l == -9223372036854775805L) {
            dArray[0] = 0.0;
            dArray[1] = 0.0;
            return 0.0;
        }
        long[] lArray = CDFTT2000.toUTCparts(l);
        try {
            d = Epoch16.compute(lArray[0], lArray[1], lArray[2], lArray[3], lArray[4], lArray[5], lArray[6], lArray[7], lArray[8], 0L, dArray);
        }
        catch (Exception exception) {
            double d2 = -1.0;
            throw new CDFException(-2224L);
        }
        return d;
    }

    public static long fromUTCEPOCH16(double[] dArray) throws CDFException {
        if (dArray[0] == -1.0E31 && dArray[1] == -1.0E31 || dArray[0] == -1.0E-31 && dArray[1] == -1.0E-31) {
            return Long.MIN_VALUE;
        }
        if (dArray[0] == 0.0 && dArray[1] == 0.0 || dArray[0] == -0.0 && dArray[1] == -0.0) {
            return -9223372036854775807L;
        }
        long[] lArray = Epoch16.breakdown(dArray);
        if ((lArray[0] < 1708L || lArray[0] > 2291L) && CDFTT2000.ValidateYMD(lArray[0], lArray[1], lArray[2]) == 0) {
            throw new CDFException(-2229L);
        }
        return CDFTT2000.fromUTCparts(lArray[0], lArray[1], lArray[2], lArray[3], lArray[4], lArray[5], lArray[6], lArray[7], lArray[8]);
    }

    public static String toUTCstring(Long l) {
        return CDFTT2000.toUTCstring((long)l, 3);
    }

    public static String toUTCstring(long l) {
        return CDFTT2000.toUTCstring(l, 3);
    }

    public static String[] toUTCstring(long[] lArray) {
        return CDFTT2000.toUTCstring(lArray, 3);
    }

    public static String toUTCstring(Long l, int n) {
        return CDFTT2000.toUTCstring((long)l, n);
    }

    public static String toEncode(Long l, int n) {
        return CDFTT2000.toEncode((long)l, n);
    }

    public static String toEncode(long l, int n) {
        return CDFTT2000.toUTCstring(l, n);
    }

    public static String toEncode(long l) {
        return CDFTT2000.toUTCstring(l, 3);
    }

    public static String[] toEncode(long[] lArray) {
        return CDFTT2000.toUTCstring(lArray, 3);
    }

    public static String[] toEncode(long[] lArray, int n) {
        return CDFTT2000.toUTCstring(lArray, n);
    }

    public static String toUTCstring(long l, int n) {
        if (n < 0 || n > 4) {
            n = 3;
        }
        if (l == Long.MIN_VALUE) {
            if (n == 0) {
                return new String("31-Dec-9999 23:59:59.999999999");
            }
            if (n == 1) {
                return new String("99991231.9999999999");
            }
            if (n == 2) {
                return new String("99991231235959");
            }
            if (n == 3) {
                return new String("9999-12-31T23:59:59.999999999");
            }
            if (n == 4) {
                return new String("9999-12-31T23:59:59.999999999Z");
            }
        }
        if (l == -9223372036854775807L) {
            if (n == 0) {
                return new String("01-Jan-0000 00:00:00.000000000");
            }
            if (n == 1) {
                return new String("00000101.0000000000");
            }
            if (n == 2) {
                return new String("00000101000000");
            }
            if (n == 3) {
                return new String("0000-01-01T00:00:00.000000000");
            }
            if (n == 4) {
                return new String("0000-01-01T00:00:00.000000000Z");
            }
        }
        if (n < 0 || n > 4) {
            n = 3;
        }
        long[] lArray = CDFTT2000.toUTCparts(l);
        long l2 = lArray[0];
        long l3 = lArray[1];
        long l4 = lArray[2];
        long l5 = lArray[3];
        long l6 = lArray[4];
        long l7 = lArray[5];
        long l8 = lArray[6];
        long l9 = lArray[7];
        long l10 = lArray[8];
        StringBuffer stringBuffer = new StringBuffer();
        if (n == 0) {
            CDFTT2000.appendIntegerPart(stringBuffer, l4, 2, true, "02");
            stringBuffer.append("-").append(CDFTT2000.MonthToken(l3)).append("-");
            CDFTT2000.appendIntegerPart(stringBuffer, l2, 4, true, "04");
            stringBuffer.append(" ");
            CDFTT2000.appendIntegerPart(stringBuffer, l5, 2, true, "02");
            stringBuffer.append(":");
            CDFTT2000.appendIntegerPart(stringBuffer, l6, 2, true, "02");
            stringBuffer.append(":");
            CDFTT2000.appendIntegerPart(stringBuffer, l7, 2, true, "02");
            stringBuffer.append(".");
            CDFTT2000.appendIntegerPart(stringBuffer, l8, 3, true, "03");
            CDFTT2000.appendIntegerPart(stringBuffer, l9, 3, true, "03");
            CDFTT2000.appendIntegerPart(stringBuffer, l10, 3, true, "03");
            return stringBuffer.toString();
        }
        if (n == 1) {
            long l11 = 3600000L * l5 + 60000L * l6 + 1000L * l7 + l8;
            long l12 = 1000L * l9 + l10;
            double d = (1000000.0 * (double)l11 + (double)l12) / (86400.0 * SECinNanoSecsD);
            CDFTT2000.appendIntegerPart(stringBuffer, l2, 4, true, "04");
            CDFTT2000.appendIntegerPart(stringBuffer, l3, 2, true, "02");
            CDFTT2000.appendIntegerPart(stringBuffer, l4, 2, true, "02");
            stringBuffer.append(".");
            CDFTT2000.appendFractionPart(stringBuffer, d, 10, "");
            return stringBuffer.toString();
        }
        if (n == 2) {
            CDFTT2000.appendIntegerPart(stringBuffer, l2, 4, true, "04");
            CDFTT2000.appendIntegerPart(stringBuffer, l3, 2, true, "02");
            CDFTT2000.appendIntegerPart(stringBuffer, l4, 2, true, "02");
            CDFTT2000.appendIntegerPart(stringBuffer, l5, 2, true, "02");
            CDFTT2000.appendIntegerPart(stringBuffer, l6, 2, true, "02");
            CDFTT2000.appendIntegerPart(stringBuffer, l7, 2, true, "02");
            return stringBuffer.toString();
        }
        if (n == 3 || n == 4) {
            CDFTT2000.appendIntegerPart(stringBuffer, l2, 4, true, "04");
            stringBuffer.append("-");
            CDFTT2000.appendIntegerPart(stringBuffer, l3, 2, true, "02");
            stringBuffer.append("-");
            CDFTT2000.appendIntegerPart(stringBuffer, l4, 2, true, "02");
            stringBuffer.append("T");
            CDFTT2000.appendIntegerPart(stringBuffer, l5, 2, true, "02");
            stringBuffer.append(":");
            CDFTT2000.appendIntegerPart(stringBuffer, l6, 2, true, "02");
            stringBuffer.append(":");
            CDFTT2000.appendIntegerPart(stringBuffer, l7, 2, true, "02");
            stringBuffer.append(".");
            CDFTT2000.appendIntegerPart(stringBuffer, l8, 3, true, "03");
            CDFTT2000.appendIntegerPart(stringBuffer, l9, 3, true, "03");
            CDFTT2000.appendIntegerPart(stringBuffer, l10, 3, true, "03");
            if (n == 4) {
                stringBuffer.append("Z");
            }
            return stringBuffer.toString();
        }
        return "";
    }

    public static String[] toUTCstring(long[] lArray, int n) {
        if (lArray == null) {
            return null;
        }
        int n2 = lArray.length;
        String[] stringArray = new String[n2];
        for (int i = 0; i < n2; ++i) {
            stringArray[i] = CDFTT2000.toUTCstring(lArray[i], n);
        }
        return stringArray;
    }

    public static String[] encode(long[] lArray, int n) {
        if (lArray == null) {
            return null;
        }
        int n2 = lArray.length;
        String[] stringArray = new String[n2];
        for (int i = 0; i < n2; ++i) {
            stringArray[i] = CDFTT2000.toUTCstring(lArray[i], n);
        }
        return stringArray;
    }

    public static String encode(long l) {
        return CDFTT2000.toUTCstring(l, 3);
    }

    public static String[] encode(long[] lArray) {
        if (lArray == null) {
            return null;
        }
        int n = lArray.length;
        if (n <= 0) {
            return null;
        }
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = CDFTT2000.encode(lArray[i]);
        }
        return stringArray;
    }

    public static String encode(long l, int n) {
        return CDFTT2000.toUTCstring(l, n);
    }

    public static long parseTT2000(String string) throws CDFException {
        return CDFTT2000.fromUTCstring(string);
    }

    public static long toParse(String string) throws CDFException {
        return CDFTT2000.fromUTCstring(string);
    }

    public static long[] parseTT2000(String[] stringArray) throws CDFException {
        if (stringArray == null) {
            return null;
        }
        int n = stringArray.length;
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            lArray[i] = CDFTT2000.fromUTCstring(stringArray[i]);
        }
        return lArray;
    }

    public static long[] toParse(String[] stringArray) throws CDFException {
        return CDFTT2000.parseTT2000(stringArray);
    }

    public static long fromUTCstring(String string) throws CDFException {
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        int n = CDFTT2000.scanUTCstring(string = string.trim());
        if (n == 0) {
            if (string.endsWith("Z") || string.endsWith("z")) {
                string = string.substring(0, string.length() - 1);
            }
            try {
                long l4 = new Long(string.substring(0, 2));
                String string2 = string.substring(3, 6);
                long l5 = CDFTT2000.MonthNumber(string2);
                long l6 = new Long(string.substring(7, 11));
                long l7 = new Long(string.substring(12, 14));
                long l8 = new Long(string.substring(15, 17));
                long l9 = new Long(string.substring(18, 20));
                String string3 = string.substring(21);
                long l10 = new Long(string3);
                if (l6 == 9999L && l5 == 12L && l4 == 31L && l7 == 23L && l8 == 59L && l9 == 59L && l10 == 999999999L) {
                    return Long.MIN_VALUE;
                }
                if (l6 == 0L && l5 == 1L && l4 == 1L && l7 == 0L && l8 == 0L && l9 == 0L && l10 == 0L) {
                    return -9223372036854775807L;
                }
                if (l10 == 0L) {
                    l = 0L;
                    l2 = 0L;
                    l3 = 0L;
                } else {
                    int n2 = string3.length();
                    if (n2 < 9) {
                        l10 *= (long)Math.pow(10.0, 9 - n2);
                    }
                    l3 = l10 / 1000000L;
                    l2 = (l10 -= l3 * 1000000L) / 1000L;
                    l = l10 - l2 * 1000L;
                }
                return CDFTT2000.fromUTCparts(l6, l5, l4, l7, l8, l9, l3, l2, l);
            }
            catch (Exception exception) {
                return -9223372036854775805L;
            }
        }
        if (n == 1) {
            try {
                double d;
                long l11 = new Long(string.substring(0, 4));
                long l12 = new Long(string.substring(4, 6));
                long l13 = new Long(string.substring(6, 8));
                long l14 = new Long(string.substring(9));
                if (l11 == 9999L && l12 == 12L && l13 == 31L && l14 == 9999999999L) {
                    return Long.MIN_VALUE;
                }
                if (l11 == 0L && l12 == 1L && l13 == 1L && l14 == 0L) {
                    return -9223372036854775807L;
                }
                if (l14 != 0L) {
                    int n3 = new Long(l14).toString().length();
                    d = (double)l13 + (double)l14 / Math.pow(10.0, n3);
                } else {
                    d = l13;
                }
                return CDFTT2000.fromUTCparts(l11, l12, d);
            }
            catch (Exception exception) {
                return -9223372036854775805L;
            }
        }
        if (n == 2) {
            try {
                long l15 = new Long(string.substring(0, 4));
                long l16 = new Long(string.substring(4, 6));
                long l17 = new Long(string.substring(6, 8));
                long l18 = new Long(string.substring(8, 10));
                long l19 = new Long(string.substring(10, 12));
                long l20 = new Long(string.substring(12));
                if (l15 == 9999L && l16 == 12L && l17 == 31L && l18 == 23L && l19 == 59L && l20 == 59L) {
                    return Long.MIN_VALUE;
                }
                if (l15 == 0L && l16 == 1L && l17 == 1L && l18 == 0L && l19 == 0L && l20 == 0L) {
                    return -9223372036854775807L;
                }
                return CDFTT2000.fromUTCparts(l15, l16, l17, l18, l19, l20, 0.0, 0.0, 0.0);
            }
            catch (Exception exception) {
                return -9223372036854775805L;
            }
        }
        if (n == 3 || n == 4) {
            try {
                long l21;
                long l22 = new Long(string.substring(0, 4));
                long l23 = new Long(string.substring(5, 7));
                long l24 = new Long(string.substring(8, 10));
                long l25 = new Long(string.substring(11, 13));
                long l26 = new Long(string.substring(14, 16));
                long l27 = new Long(string.substring(17, 19));
                int n4 = string.length();
                int n5 = 0;
                if (n4 > 20) {
                    String string4 = string.substring(20);
                    int n6 = string4.indexOf("Z");
                    n5 = string4.length();
                    if (n6 == -1) {
                        l21 = new Long(string4);
                    } else {
                        l21 = n5 > 1 ? new Long(string4.substring(0, n6)) : 0L;
                        --n5;
                    }
                } else {
                    l21 = 0L;
                }
                if (l22 == 9999L && l23 == 12L && l24 == 31L && l25 == 23L && l26 == 59L && l27 == 59L && l21 == 999999999L) {
                    return Long.MIN_VALUE;
                }
                if (l22 == 0L && l23 == 1L && l24 == 1L && l25 == 0L && l26 == 0L && l27 == 0L && l21 == 0L) {
                    return -9223372036854775807L;
                }
                if (l21 == 0L) {
                    l = 0L;
                    l2 = 0L;
                    l3 = 0L;
                } else {
                    if (n5 < 9) {
                        l21 *= (long)Math.pow(10.0, 9 - n5);
                    }
                    l3 = l21 / 1000000L;
                    l2 = (l21 -= l3 * 1000000L) / 1000L;
                    l = l21 - l2 * 1000L;
                }
                return CDFTT2000.fromUTCparts(l22, l23, l24, l25, l26, l27, l3, l2, l);
            }
            catch (Exception exception) {
                return -9223372036854775805L;
            }
        }
        throw new CDFException(-2229L);
    }

    public static long[] fromUTCISO8601string(String string) throws CDFException {
        long[] lArray = new long[9];
        int n = CDFTT2000.scanUTCstring(string);
        if (n == 3 || n == 4) {
            try {
                long l;
                lArray[0] = new Long(string.substring(0, 4));
                lArray[1] = new Long(string.substring(5, 7));
                lArray[2] = new Long(string.substring(8, 10));
                lArray[3] = new Long(string.substring(11, 13));
                lArray[4] = new Long(string.substring(14, 16));
                lArray[5] = new Long(string.substring(17, 19));
                String string2 = string.substring(20);
                int n2 = string.length();
                int n3 = 0;
                if (n2 > 20) {
                    string2 = string.substring(20);
                    int n4 = string2.indexOf("Z");
                    n3 = string2.length();
                    if (n4 == -1) {
                        l = new Long(string2);
                    } else {
                        l = n3 > 1 ? new Long(string2.substring(0, n4)) : 0L;
                        --n3;
                    }
                } else {
                    l = 0L;
                }
                if (l == 0L) {
                    lArray[8] = 0L;
                    lArray[7] = 0L;
                    lArray[6] = 0L;
                } else {
                    if (n3 < 9) {
                        l *= (long)Math.pow(10.0, 9 - n3);
                    }
                    lArray[6] = l / 1000000L;
                    lArray[7] = (l -= lArray[6] * 1000000L) / 1000L;
                    lArray[8] = l - lArray[7] * 1000L;
                }
                return lArray;
            }
            catch (Exception exception) {
                return new long[]{0L, 1L, 1L, 0L, 0L, 0L, 0L, 0L, 0L};
            }
        }
        throw new CDFException(-2229L);
    }

    public static long parse(String string) throws CDFException {
        return CDFTT2000.fromUTCstring(string);
    }

    public static long[] parse(String[] stringArray) throws CDFException {
        if (stringArray == null) {
            return null;
        }
        int n = stringArray.length;
        if (n <= 0) {
            return null;
        }
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            lArray[i] = CDFTT2000.parse(stringArray[i]);
        }
        return lArray;
    }

    public static long[] CDFgetLastDateinLeapSecondsTable() {
        if (LTD == null) {
            CDFTT2000.LoadLeapSecondsTable();
        }
        long[] lArray = new long[]{(long)LTD[entryCnt - 1][0], (long)LTD[entryCnt - 1][1], (long)LTD[entryCnt - 1][2]};
        return lArray;
    }

    public static long fromGregorianTime(GregorianCalendar gregorianCalendar) {
        long l = gregorianCalendar.get(1);
        long l2 = (long)gregorianCalendar.get(2) + 1L;
        long l3 = gregorianCalendar.get(5);
        long l4 = gregorianCalendar.get(11);
        long l5 = gregorianCalendar.get(12);
        long l6 = gregorianCalendar.get(13);
        long l7 = gregorianCalendar.get(14);
        long l8 = 10000L * l + 100L * l2 + l3;
        if ((l < 1708L || l > 2291L) && CDFTT2000.ValidateYMD(l, l2, l3) == 0) {
            return -9223372036854775805L;
        }
        try {
            return CDFTT2000.fromUTCparts(l, l2, l3, l4, l5, l6, l7, 0.0, 0.0);
        }
        catch (Exception exception) {
            return -9223372036854775805L;
        }
    }

    public static GregorianCalendar toGregorianTime(long l) {
        return CDFTT2000.toGregorianTime(l, new GregorianCalendar().getTimeZone());
    }

    public static GregorianCalendar toGregorianTime(long l, TimeZone timeZone) {
        long[] lArray = CDFTT2000.toUTCparts(l);
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTimeZone(timeZone);
        gregorianCalendar.set((int)lArray[0], (int)lArray[1] - 1, (int)lArray[2], (int)lArray[3], (int)lArray[4], (int)lArray[5]);
        gregorianCalendar.set(14, (int)lArray[6]);
        return gregorianCalendar;
    }

    public static int CDFgetLeapSecondsTableStatus() {
        if (LTD == null) {
            CDFTT2000.LoadLeapSecondsTable();
        }
        return fromFile;
    }

    public static double[][] CDFgetLeapSecondsTable() {
        if (LTD == null) {
            CDFTT2000.LoadLeapSecondsTable();
        }
        return LTD;
    }

    public static int CDFgetRowsinLeapSecondsTable() {
        if (LTD == null) {
            CDFTT2000.LoadLeapSecondsTable();
        }
        return entryCnt;
    }

    public static long computeTT2000withBasedLeapDay(long l, long l2, long l3, long l4, long l5, long l6, long l7, long l8, long l9, int n) {
        return CDFTT2000.computeTT2000withBasedLeapDay((double)l, (double)l2, (double)l3, (double)l4, (double)l5, (double)l6, (double)l7, (double)l8, (double)l9, n);
    }

    public static long computeTT2000withBasedLeapDay(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, int n) {
        long l;
        if (d < 0.0 || d2 < 0.0 || d3 < 0.0 || d4 < 0.0 || d5 < 0.0 || d6 < 0.0 || d7 < 0.0 || d8 < 0.0 || d9 < 0.0) {
            return -9223372036854775805L;
        }
        if (d3 - Math.floor(d3) != 0.0 || d2 - Math.floor(d2) != 0.0 || d3 - Math.floor(d3) != 0.0 || d4 - Math.floor(d4) != 0.0 || d5 - Math.floor(d5) != 0.0 || d6 - Math.floor(d6) != 0.0 || d7 - Math.floor(d7) != 0.0 || d8 - Math.floor(d8) != 0.0 || d9 - Math.floor(d9) != 0.0) {
            return -9223372036854775805L;
        }
        try {
            l = CDFTT2000.fromUTCparts(d, d2, d3, d4, d5, d6, d7, d8, d9);
        }
        catch (CDFException cDFException) {
            return -9223372036854775805L;
        }
        if (n <= 0 || (long)d * 10000L + (long)d2 * 100L + (long)d3 < (long)n || (long)d * 10000L + (long)d2 * 100L + (long)d3 == (long)n && (long)d4 * 10000L + (long)d5 * 100L + (long)d6 < 235960L) {
            return l;
        }
        int n2 = CDFTT2000.leapSecondLastUpdatedinTable(n);
        int n3 = (int)((long)d * 10000L + (long)d2 * 100L + (long)d3);
        int n4 = CDFTT2000.leapSecondLastUpdatedinTable(n3);
        return l - (long)(n4 - n2) * 1000000000L;
    }

    public static long[] breakdownTT2000withBasedLeapDay(long l, int n) {
        int n2;
        if (n <= 0) {
            return CDFTT2000.toUTCparts(l);
        }
        int n3 = CDFTT2000.leapSecondLastUpdatedinTable(n);
        int n4 = entryCnt - n3 - 1;
        if (n4 == 0) {
            return CDFTT2000.toUTCparts(l);
        }
        long[] lArray = new long[n4];
        for (n2 = 0; n2 < n4; ++n2) {
            lArray[n2] = CDFTT2000.computeTT2000withBasedLeapDay((long)LTD[n3 + 1 + n2][0], (long)LTD[n3 + 1 + n2][1], (long)LTD[n3 + 1 + n2][2], 0L, 0L, 0L, 0L, 0L, 0L, n);
        }
        for (n2 = n4; n2 > 0; --n2) {
            if (l < lArray[n2 - 1]) continue;
            return CDFTT2000.toUTCparts(l + (long)n2 * 1000000000L);
        }
        return CDFTT2000.toUTCparts(l);
    }

    public static String encodeTT2000withBasedLeapDay(long l, int n) {
        int n2;
        if (n <= 0) {
            return CDFTT2000.toUTCstring(l);
        }
        int n3 = CDFTT2000.leapSecondLastUpdatedinTable(n);
        int n4 = entryCnt - n3 - 1;
        if (n4 == 0) {
            return CDFTT2000.toUTCstring(l);
        }
        long[] lArray = new long[n4];
        for (n2 = 0; n2 < n4; ++n2) {
            lArray[n2] = CDFTT2000.computeTT2000withBasedLeapDay(LTD[n3 + 1 + n2][0], LTD[n3 + 1 + n2][1], LTD[n3 + 1 + n2][2], 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, n);
        }
        for (n2 = n4; n2 > 0; --n2) {
            if (l < lArray[n2 - 1]) continue;
            return CDFTT2000.toUTCstring(l + (long)n2 * 1000000000L);
        }
        return CDFTT2000.toUTCstring(l);
    }

    public static long parseTT2000withBasedLeapDay(String string, int n) {
        try {
            long[] lArray = CDFTT2000.fromUTCISO8601string(string);
            return CDFTT2000.computeTT2000withBasedLeapDay(lArray[0], lArray[1], lArray[2], lArray[3], lArray[4], lArray[5], lArray[6], lArray[7], lArray[8], n);
        }
        catch (CDFException cDFException) {
            return -9223372036854775805L;
        }
    }

    private static int leapSecondLastUpdatedinTable(int n) {
        int n2;
        if (LTD == null) {
            CDFTT2000.LoadLeapSecondsTable();
        }
        for (int i = n2 = entryCnt - 1; i >= 0; --i) {
            if (n < (int)(10000.0 * LTD[i][0] + 100.0 * LTD[i][1] + LTD[i][2])) continue;
            return i;
        }
        return 0;
    }

    public static double TT2000toUnixTime(long l) {
        try {
            long[] lArray = CDFTT2000.breakdownTT2000(l);
            double d = Epoch.compute(lArray[0], lArray[1], lArray[2], lArray[3], lArray[4], lArray[5], lArray[6]);
            long l2 = lArray[7];
            if (lArray[8] > 500L) {
                ++l2;
            }
            return (d - 6.21672192E13) / 1000.0 + (double)l2 / Math.pow(10.0, 6.0);
        }
        catch (Exception exception) {
            return 0.0;
        }
    }

    public static double[] TT2000toUnixTime(long[] lArray) {
        double[] dArray = new double[lArray.length];
        for (int i = 0; i < lArray.length; ++i) {
            dArray[i] = CDFTT2000.TT2000toUnixTime(lArray[i]);
        }
        return dArray;
    }

    public static long UnixTimetoTT2000(double d) {
        try {
            double d2 = d * 1000.0;
            double d3 = d2 - (double)((long)d2);
            double d4 = d3 * 1000.0;
            long l = (long)d4;
            if (d4 - (double)l > 0.5) {
                ++l;
            }
            long[] lArray = Epoch.breakdown((double)((long)d2) + 6.21672192E13);
            return CDFTT2000.compute(lArray[0], lArray[1], lArray[2], lArray[3], lArray[4], lArray[5], lArray[6], l, 0L);
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    public static long[] UnixTimetoTT2000(double[] dArray) {
        long[] lArray = new long[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            lArray[i] = CDFTT2000.UnixTimetoTT2000(dArray[i]);
        }
        return lArray;
    }

    static {
        NST2 = new long[]{0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, -883655957816000000L, -867931156816000000L, -852033555816000000L, -820497554816000000L, -788961553816000000L, -757425552816000000L, -725803151816000000L, -694267150816000000L, -662731149816000000L, -631195148816000000L, -583934347816000000L, -552398346816000000L, -520862345816000000L, -457703944816000000L, -378734343816000000L, -315575942816000000L, -284039941816000000L, -236779140816000000L, -205243139816000000L, -173707138816000000L, -126273537816000000L, -79012736816000000L, -31579135816000000L, 189345665184000000L, 284040066184000000L, 394372867184000000L, 488980868184000000L, 536500869184000000L};
        doys1 = new long[]{31L, 59L, 90L, 120L, 151L, 181L, 212L, 243L, 273L, 304L, 334L, 365L};
        doys2 = new long[]{31L, 60L, 91L, 121L, 152L, 182L, 213L, 244L, 274L, 305L, 335L, 366L};
        daym1 = new long[]{31L, 28L, 31L, 30L, 31L, 30L, 31L, 31L, 30L, 31L, 30L, 31L};
        daym2 = new long[]{31L, 29L, 31L, 30L, 31L, 30L, 31L, 31L, 30L, 31L, 30L, 31L};
        tableChecked = false;
        openCDF64s = 0;
        toPlus = 0.0;
        currentDay = -1L;
        MAX_ePART_LEN = 25;
    }
}

