/*
 * Decompiled with CFR 0.152.
 */
package gsfc.nssdc.cdf;

import gsfc.nssdc.cdf.CDFConstants;
import java.util.Hashtable;

public class CDFException
extends Exception
implements CDFConstants {
    private static final Hashtable msgs = new Hashtable();
    private long myStatus;

    public long getCurrentStatus() {
        if (this.myStatus == 0L) {
            return -1;
        }
        return this.myStatus;
    }

    public static String getStatusMsg(long l) {
        return (String)msgs.get(new Long(l));
    }

    public CDFException(String string) {
        super(string);
    }

    public CDFException(long l) {
        this(l, null);
    }

    public CDFException(long l, String string) {
        super(CDFException.getStatusMsg(l) + (string == null ? "" : "\n  " + string));
        this.myStatus = l;
    }

    static {
        msgs.put(new Long(-2001L), "Named attribute already exists.");
        msgs.put(new Long(-1001L), "Attribute name truncated.");
        msgs.put(new Long(-2015L), "Illegal number of records to allocate specified.");
        msgs.put(new Long(-2022L), "Illegal/undefined argument specified.");
        msgs.put(new Long(-2044L), "Illegal attribute name specified.");
        msgs.put(new Long(-2042L), "Illegal attribute number specified.");
        msgs.put(new Long(-2063L), "Illegal number of cache buffers specified.");
        msgs.put(new Long(-2016L), "Illegal/missing extension for multi-file CDF.");
        msgs.put(new Long(-2002L), "CDF identifier is unknown or invalid.");
        msgs.put(new Long(-2049L), "Illegal CDF name specified.");
        msgs.put(new Long(-2034L), "Unknown CDF status code specified.");
        msgs.put(new Long(-2097L), "An illegal compression parameter was specified.");
        msgs.put(new Long(-2003L), "Unknown data type specified or encountered.");
        msgs.put(new Long(-2079L), "Unknown or unsupported data decoding specified.");
        msgs.put(new Long(-2039L), "Illegal dimension count specified.");
        msgs.put(new Long(-2005L), "Dimension index out of range.");
        msgs.put(new Long(-2040L), "Illegal dimension interval specified.");
        msgs.put(new Long(-2004L), "Dimension size specified as zero or less.");
        msgs.put(new Long(-2006L), "Unknown or unsupported data encoding.");
        msgs.put(new Long(-2043L), "Illegal attribute entry number specified.");
        msgs.put(new Long(-2031L), "Illegal blocking factor specified (less than zero).");
        msgs.put(new Long(-2058L), "The specified function or item is illegal.");
        msgs.put(new Long(-2014L), "Unknown CDF format specified.");
        msgs.put(new Long(-2030L), "Illegal number of initial records.");
        msgs.put(new Long(-2007L), "Unknown variable majority specified.");
        msgs.put(new Long(-2026L), "Unable to allocate dynamic memory.");
        msgs.put(new Long(-2081L), "Illegal negative to positive floating point zero mode.");
        msgs.put(new Long(-2008L), "Illegal number of dimensions.");
        msgs.put(new Long(-2011L), "Illegal number of elements (for data type).");
        msgs.put(new Long(-2036L), "Illegal number of variables specified.");
        msgs.put(new Long(-2073L), "Illegal read-only mode specified.");
        msgs.put(new Long(-2037L), "Illegal record count specified.");
        msgs.put(new Long(-2038L), "Illegal record interval specified.");
        msgs.put(new Long(-2009L), "Record number is out of range.");
        msgs.put(new Long(-2010L), "Unrecognized attribute scope.");
        msgs.put(new Long(-2110L), "An illegal sparse arrays parameter was specified.");
        msgs.put(new Long(-2111L), "An illegal scratch directory was specified.");
        msgs.put(new Long(-2045L), "Illegal variable name specified.");
        msgs.put(new Long(-2041L), "Illegal variable number specified.");
        msgs.put(new Long(-2072L), "Illegal zMode specified.");
        msgs.put(new Long(-2103L), "Records can't be allocated at this time.");
        msgs.put(new Long(-2051L), "The parameter/value can't be set/changed.");
        msgs.put(new Long(-2091L), "The compression for the CDF/variable can't be set/modified.");
        msgs.put(new Long(-2104L), "The source/destination variables have a different dataType/numElements/numDims/dimSizes/dimVariances.");
        msgs.put(new Long(-2233L), "Cannot insert records to a variable with sparserecords..");
        msgs.put(new Long(-2100L), "Sparse arrays can't be set/modified for the variable.");
        msgs.put(new Long(-2099L), "Sparse records can't be set/modified for the variable.");
        msgs.put(new Long(-2055L), "Close failed - error from file system.");
        msgs.put(new Long(-2066L), "Creation failed - error from file system.");
        msgs.put(new Long(-2088L), "Deletion failed - error from file system.");
        msgs.put(new Long(-2013L), "The CDF named already exists.");
        msgs.put(new Long(-2035L), "An internal error has occurred in the CDF library.");
        msgs.put(new Long(-1002L), "CDF pathname truncated.");
        msgs.put(new Long(0L), "Function completed successfully.");
        msgs.put(new Long(-2012L), "Open failed - error from file system.");
        msgs.put(new Long(-2074L), "Read failed - error from file system.");
        msgs.put(new Long(-2075L), "Write failed - error from file system.");
        msgs.put(new Long(-2028L), "Version 2 CDF is corrupted.");
        msgs.put(new Long(-2112L), "Variable data type mismatch: defined vs actual");
        msgs.put(new Long(-2092L), "An error was detected in the compressed data.");
        msgs.put(new Long(1002L), "The CDF or variable values did not compress.");
        msgs.put(new Long(-2096L), "No internal records in a compressed CDF.");
        msgs.put(new Long(-2032L), "Current position is at the end of the variable.");
        msgs.put(new Long(-1006L), "A specified parameter was changed to a different value.");
        msgs.put(new Long(-2023L), "Greater than 64Kb of memory required.");
        msgs.put(new Long(-2076L), "The operation is illegal for the attribute's scope.");
        msgs.put(new Long(-2071L), "Operation is illegal while in zMode.");
        msgs.put(new Long(-2060L), "Operation not allowed on Version 1 CDFs.");
        msgs.put(new Long(1007L), "Operation n/a when multi-file format.");
        msgs.put(new Long(-1007L), "Operation n/a for the type of variable.");
        msgs.put(new Long(-1004L), "A negative floating point zero (-0.0) was detected.");
        msgs.put(new Long(-2046L), "An attribute has not been selected.");
        msgs.put(new Long(-2053L), "A CDF has not been selected.");
        msgs.put(new Long(-2087L), "Deleting is not allowed (read only).");
        msgs.put(new Long(-2047L), "An attribute entry has not been selected.");
        msgs.put(new Long(-2077L), "No more access to the CDF due to a severe error.");
        msgs.put(new Long(1005L), "A pad value has not been specified.");
        msgs.put(new Long(-2052L), "A CDF status code has not been selected.");
        msgs.put(new Long(-2017L), "Named attribute not found in this CDF.");
        msgs.put(new Long(-2067L), "The specified CDF does not exist.");
        msgs.put(new Long(-2018L), "No such entry for specified attribute.");
        msgs.put(new Long(-2102L), "The specified record does not exist.");
        msgs.put(new Long(-2019L), "Named variable not found in this CDF.");
        msgs.put(new Long(-2048L), "A variable has not been selected.");
        msgs.put(new Long(1006L), "CDF contains no rVariables.");
        msgs.put(new Long(-2086L), "Write access is not allowed on the CDF file(s).");
        msgs.put(new Long(-2027L), "Named CDF is corrupted or not actually a CDF.");
        msgs.put(new Long(1009L), "The preceeding records were also allocated.");
        msgs.put(new Long(-2054L), "Writing/deleting is illegal.");
        msgs.put(new Long(-2070L), "CDF is in read-only mode.");
        msgs.put(new Long(-2107L), "Scratch file creation failed - error from file system.");
        msgs.put(new Long(-2106L), "Scratch file deletion failed - error from file system.");
        msgs.put(new Long(-2108L), "Scratch file read failed - error from file system.");
        msgs.put(new Long(-2109L), "Scratch file write failed - error from file system.");
        msgs.put(new Long(1004L), "Operation n/a when single-file format.");
        msgs.put(new Long(1008L), "One or more of the records were already allocated.");
        msgs.put(new Long(-2101L), "Too many parameters were encountered.");
        msgs.put(new Long(-2024L), "Only a limited number of variables may exist in this CDF.");
        msgs.put(new Long(1010L), "A TT2000 data value was not made with the latest CDF version (even its value may be valid).");
        msgs.put(new Long(-2234L), "A TT2000 data is either invalid (made with an oudated leap second table) or trying to use an outdated table.");
        msgs.put(new Long(-2090L), "An unknown type of compression was encountered.");
        msgs.put(new Long(-2098L), "An unknown sparseness was encountered.");
        msgs.put(new Long(-2082L), "The attempted operation isn't supported at this time.");
        msgs.put(new Long(1003L), "Variable is already closed.");
        msgs.put(new Long(-2056L), "Close failed - error from file system.");
        msgs.put(new Long(-2068L), "Creation failed - error from file system.");
        msgs.put(new Long(-2089L), "Deletion failed - error from file system.");
        msgs.put(new Long(-2025L), "Named variable already exists.");
        msgs.put(new Long(-1003L), "Variable name truncated.");
        msgs.put(new Long(-2029L), "Open failed - error from file system.");
        msgs.put(new Long(-2020L), "Read failed - error from file system.");
        msgs.put(new Long(-2021L), "Write failed - error from file system.");
        msgs.put(new Long(1001L), "One or more of the records are virtual.");
        msgs.put(new Long(-2113L), "Named CDF is corrupted or not supported by the current library version.");
        msgs.put(new Long(-2223L), "Version 3 CDF is corrupted.");
        msgs.put(new Long(-2224L), "One or more of the date/time fields is out of valid range.");
        msgs.put(new Long(-2083L), "CDF save failed - error from file system.");
        msgs.put(new Long(-2084L), "Var save failed - error from file system.");
        msgs.put(new Long(-2225L), "The specified checksum method is not currently supported.");
        msgs.put(new Long(-2226L), "The data integrity verification through the checksum failed.");
        msgs.put(new Long(-2227L), "The checksum is not allowed for old versioned files.");
        msgs.put(new Long(-2228L), "Named CDF is actually a netCDF file.");
        msgs.put(new Long(-2229L), "Error handling the date/time for TT2000 or a TT2000 epoch.");
        msgs.put(new Long(-2230L), "One of data fields is invalid... Upgrade the library might fix the problem.");
        msgs.put(new Long(-2231L), "ZLIB_ERROR: Error during ZLIB compression.");
        msgs.put(new Long(-2232L), "ZLIB_ERROR: Error during ZLIB compression.");
    }
}

