/*
 * Decompiled with CFR 0.152.
 */
package gsfc.nssdc.cdf;

import gsfc.nssdc.cdf.Attribute;
import gsfc.nssdc.cdf.CDFConstants;
import gsfc.nssdc.cdf.CDFDelegate;
import gsfc.nssdc.cdf.CDFException;
import gsfc.nssdc.cdf.CDFNativeLibrary;
import gsfc.nssdc.cdf.CDFObject;
import gsfc.nssdc.cdf.Entry;
import gsfc.nssdc.cdf.Variable;
import gsfc.nssdc.cdf.util.CDFUtils;
import java.io.File;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class CDF
implements CDFObject,
CDFConstants {
    private static Object Monitor = new Object();
    private static long backward = 0L;
    private static boolean backwardFlagSet = false;
    private static long validate = 0L;
    private static boolean validateFlagSet = false;
    private static long backwardEnvVar = -1;
    private static long validateEnvVar = -1;
    private static long checksumEnvVar = -1;
    private CDFDelegate delegate;
    private String path;
    private long id;
    private File theFile;
    private long cdfStatus;
    private long cType;
    private long cTypeX;
    private long cPct;
    private long[] cParms;
    private long[] cParmsX;
    private long cSize;
    private long uSize;
    private String copyright;
    private String version;
    private long vers;
    private long libVersion;
    private long rel;
    private long libRelease;
    private long inc;
    private long libIncrement;
    private String libsubIncrement;
    private String libCopyright;
    private long encoding;
    private long encodingX;
    private long decoding;
    private long cacheSize;
    private long compressCacheSize;
    private long stageCacheSize;
    private long negtoPosfp0;
    private long format;
    private long formatX;
    private long majority;
    private long majorityX;
    private long numAttrs;
    private long numGattrs;
    private long numVattrs;
    private long numRvars;
    private long numZvars;
    private long readOnly;
    private long zmode;
    private long numDims;
    private long[] dimSizes;
    private boolean closed;
    private long infoWarning;
    private long fromEnvVar;
    private long checksum;
    private long checksumX;
    private long lastUpdated;
    private long lastUpdatedX;
    private String leapTableEnvVar;
    private long toGetAttrVar;
    private long leapSecondLastUpdated;
    private Vector attributes;
    private Vector variables;

    public static CDF create(String string) throws CDFException {
        CDF cDF = new CDF(string, new CDFNativeLibrary());
        cDF.numDims = 0L;
        cDF.dimSizes = new long[]{2};
        Vector<Serializable> vector = new Vector<Serializable>();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        Vector<String> vector4 = new Vector<String>();
        Vector<String> vector5 = new Vector<String>();
        vector.addElement(new Long(1001L));
        vector.addElement(new Long(1L));
        vector2.addElement("path");
        vector2.addElement("Ljava/lang/String;");
        vector.addElement(vector2);
        vector3.addElement("numDims");
        vector3.addElement("J");
        vector.addElement(vector3);
        vector4.addElement("dimSizes");
        vector4.addElement("[J");
        vector.addElement(vector4);
        vector5.addElement("id");
        vector5.addElement("J");
        vector.addElement(vector5);
        vector.addElement(new Long(1000L));
        cDF.executeCommand(cDF, vector);
        String string2 = cDF.FindCDFName(string);
        if (string2 != null) {
            cDF.theFile = new File(string2);
        }
        cDF.selectzMode(2);
        cDF.selectReadOnlyMode(0L);
        cDF.getCDFInfo();
        cDF.toGetAttrVar = 0L;
        return cDF;
    }

    public static CDF create(String string, int n) throws CDFException {
        CDF cDF = new CDF(string, new CDFNativeLibrary());
        CDF.setFileBackward(n);
        cDF.numDims = 0L;
        cDF.dimSizes = new long[]{2};
        Vector<Serializable> vector = new Vector<Serializable>();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        Vector<String> vector4 = new Vector<String>();
        Vector<String> vector5 = new Vector<String>();
        vector.addElement(new Long(1001L));
        vector.addElement(new Long(1L));
        vector2.addElement("path");
        vector2.addElement("Ljava/lang/String;");
        vector.addElement(vector2);
        vector3.addElement("numDims");
        vector3.addElement("J");
        vector.addElement(vector3);
        vector4.addElement("dimSizes");
        vector4.addElement("[J");
        vector.addElement(vector4);
        vector5.addElement("id");
        vector5.addElement("J");
        vector.addElement(vector5);
        vector.addElement(new Long(1000L));
        cDF.executeCommand(cDF, vector);
        String string2 = cDF.FindCDFName(string);
        if (string2 != null) {
            cDF.theFile = new File(string2);
        }
        cDF.selectzMode(2);
        cDF.selectReadOnlyMode(0L);
        cDF.getCDFInfo();
        cDF.toGetAttrVar = 0L;
        return cDF;
    }

    public static CDF open(String string) throws CDFException {
        return CDF.open(string, 0L);
    }

    public static CDF open(String string, long l) throws CDFException {
        CDF cDF = new CDF(string, new CDFNativeLibrary());
        cDF.infoWarning = 0L;
        Vector<Serializable> vector = new Vector<Serializable>();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        vector.addElement(new Long(1002L));
        vector.addElement(new Long(1L));
        vector2.addElement("path");
        vector2.addElement("Ljava/lang/String;");
        vector.addElement(vector2);
        vector3.addElement("id");
        vector3.addElement("J");
        vector.addElement(vector3);
        vector.addElement(new Long(1000L));
        cDF.executeCommand(cDF, vector);
        long l2 = cDF.getStatus();
        String string2 = cDF.FindCDFName(string);
        if (string2 != null) {
            cDF.theFile = new File(string2);
        }
        cDF.selectReadOnlyMode(l);
        cDF.selectzMode(2);
        cDF.getCDFInfo();
        if (l2 < cDF.getStatus()) {
            cDF.setStatus(l2);
        }
        cDF.toGetAttrVar = 1L;
        return cDF;
    }

    private final void getAttributesandVariables() throws CDFException {
        if (this.toGetAttrVar == 0L) {
            return;
        }
        long l = this.numAttrs;
        long l2 = 0L;
        while (l2 < l) {
            Attribute attribute = Attribute.retrieve(this, l2);
            ++l2;
        }
        l = this.numZvars;
        Variable variable = null;
        long l3 = 0L;
        while (l3 < l) {
            variable = Variable.retrieve(this, l3);
            ++l3;
        }
        this.toGetAttrVar = 0L;
    }

    public static String getLibraryVersion() throws CDFException {
        CDF cDF = new CDF(new CDFNativeLibrary());
        Vector<Serializable> vector = new Vector<Serializable>();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        Vector<String> vector4 = new Vector<String>();
        Vector<String> vector5 = new Vector<String>();
        vector.addElement(new Long(1007L));
        vector.addElement(new Long(21L));
        vector2.addElement("libVersion");
        vector2.addElement("J");
        vector.addElement(vector2);
        vector.addElement(new Long(22L));
        vector3.addElement("libRelease");
        vector3.addElement("J");
        vector.addElement(vector3);
        vector.addElement(new Long(23L));
        vector4.addElement("libIncrement");
        vector4.addElement("J");
        vector.addElement(vector4);
        vector.addElement(new Long(24L));
        vector5.addElement("libsubIncrement");
        vector5.addElement("Ljava/lang/String;");
        vector.addElement(vector5);
        vector.addElement(new Long(1000L));
        cDF.executeCommand(cDF, vector);
        String string = cDF.libsubIncrement;
        String string2 = string.equals("") || string.equals(" ") || string.trim().length() == 0 ? "" : "_";
        return cDF.libVersion + "." + cDF.libRelease + "." + cDF.libIncrement + string2 + cDF.libsubIncrement;
    }

    public static String getLibraryCopyright() throws CDFException {
        CDF cDF = new CDF(new CDFNativeLibrary());
        Vector<Serializable> vector = new Vector<Serializable>();
        Vector<String> vector2 = new Vector<String>();
        vector.addElement(new Long(1007L));
        vector.addElement(new Long(20L));
        vector2.addElement("libCopyright");
        vector2.addElement("Ljava/lang/String;");
        vector.addElement(vector2);
        vector.addElement(new Long(1000L));
        cDF.executeCommand(cDF, vector);
        return cDF.libCopyright;
    }

    private final synchronized void getCDFInfo() throws CDFException {
        Vector<Serializable> vector = new Vector<Serializable>();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        Vector<String> vector4 = new Vector<String>();
        Vector<String> vector5 = new Vector<String>();
        Vector<String> vector6 = new Vector<String>();
        Vector<String> vector7 = new Vector<String>();
        Vector<String> vector8 = new Vector<String>();
        Vector<String> vector9 = new Vector<String>();
        Vector<String> vector10 = new Vector<String>();
        Vector<String> vector11 = new Vector<String>();
        Vector<String> vector12 = new Vector<String>();
        Vector<String> vector13 = new Vector<String>();
        Vector<String> vector14 = new Vector<String>();
        Vector<String> vector15 = new Vector<String>();
        Vector<String> vector16 = new Vector<String>();
        Vector<String> vector17 = new Vector<String>();
        Vector<String> vector18 = new Vector<String>();
        Vector<String> vector19 = new Vector<String>();
        vector.addElement(new Long(1005L));
        vector.addElement(new Long(1L));
        vector19.addElement("id");
        vector19.addElement("J");
        vector.addElement(vector19);
        vector.addElement(new Long(1007L));
        vector.addElement(new Long(3));
        vector2.addElement("encoding");
        vector2.addElement("J");
        vector.addElement(vector2);
        vector.addElement(new Long(6L));
        vector3.addElement("format");
        vector3.addElement("J");
        vector.addElement(vector3);
        vector.addElement(new Long(13L));
        vector4.addElement("vers");
        vector4.addElement("J");
        vector.addElement(vector4);
        vector.addElement(new Long(14L));
        vector5.addElement("rel");
        vector5.addElement("J");
        vector.addElement(vector5);
        vector.addElement(new Long(15L));
        vector6.addElement("inc");
        vector6.addElement("J");
        vector.addElement(vector6);
        vector.addElement(new Long(5));
        vector7.addElement("majority");
        vector7.addElement("J");
        vector.addElement(vector7);
        vector.addElement(new Long(10L));
        vector8.addElement("numAttrs");
        vector8.addElement("J");
        vector.addElement(vector8);
        vector.addElement(new Long(11L));
        vector9.addElement("numGattrs");
        vector9.addElement("J");
        vector.addElement(vector9);
        vector.addElement(new Long(12L));
        vector10.addElement("numVattrs");
        vector10.addElement("J");
        vector.addElement(vector10);
        vector.addElement(new Long(8L));
        vector11.addElement("numRvars");
        vector11.addElement("J");
        vector.addElement(vector11);
        vector.addElement(new Long(9L));
        vector12.addElement("numZvars");
        vector12.addElement("J");
        vector.addElement(vector12);
        vector.addElement(new Long(156L));
        vector17.addElement("checksum");
        vector17.addElement("J");
        vector.addElement(vector17);
        vector.addElement(new Long(159L));
        vector18.addElement("leapSecondLastUpdated");
        vector18.addElement("J");
        vector.addElement(vector18);
        vector.addElement(new Long(1007L));
        vector.addElement(new Long(7L));
        vector13.addElement("copyright");
        vector13.addElement("Ljava/lang/String;");
        vector.addElement(vector13);
        vector.addElement(new Long(130L));
        vector14.addElement("cType");
        vector14.addElement("J");
        vector.addElement(vector14);
        vector15.addElement("cParms");
        vector15.addElement("[J");
        vector.addElement(vector15);
        vector16.addElement("cPct");
        vector16.addElement("J");
        vector.addElement(vector16);
        vector.addElement(new Long(1000L));
        this.id = this.getID();
        this.executeCommand(this, vector);
        this.version = this.vers + "." + this.rel + "." + this.inc;
        this.closed = false;
    }

    public synchronized void close() throws CDFException {
        if (!this.closed) {
            Vector<Serializable> vector = new Vector<Serializable>();
            Vector<String> vector2 = new Vector<String>();
            vector.addElement(new Long(1005L));
            vector.addElement(new Long(1L));
            vector2.addElement("id");
            vector2.addElement("J");
            vector.addElement(vector2);
            vector.addElement(new Long(1004L));
            vector.addElement(new Long(1L));
            vector.addElement(new Long(1000L));
            this.id = this.getID();
            this.executeCommand(this, vector);
            this.closed = true;
        }
    }

    public synchronized long getID() {
        return this.id;
    }

    public synchronized long getEncoding() {
        return this.encoding;
    }

    public synchronized void setEncoding(long l) throws CDFException {
        Vector<Serializable> vector = new Vector<Serializable>();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        vector.addElement(new Long(1005L));
        vector.addElement(new Long(1L));
        vector3.addElement("id");
        vector3.addElement("J");
        vector.addElement(vector3);
        vector.addElement(new Long(1008L));
        vector.addElement(new Long(3));
        vector2.addElement("encodingX");
        vector2.addElement("J");
        vector.addElement(vector2);
        vector.addElement(new Long(1000L));
        this.encodingX = l;
        this.id = this.getID();
        this.executeCommand(this, vector);
        this.encoding = l;
    }

    public synchronized void selectDecoding(long l) throws CDFException {
        Vector<Serializable> vector = new Vector<Serializable>();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        this.id = this.getID();
        vector.addElement(new Long(1005L));
        vector.addElement(new Long(1L));
        vector3.addElement("id");
        vector3.addElement("J");
        vector.addElement(vector3);
        vector.addElement(new Long(4));
        vector2.addElement("decoding");
        vector2.addElement("J");
        vector.addElement(vector2);
        vector.addElement(new Long(1000L));
        this.decoding = l;
        this.id = this.getID();
        this.executeCommand(this, vector);
    }

    public synchronized long confirmDecoding() throws CDFException {
        Vector<Serializable> vector = new Vector<Serializable>();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        vector.addElement(new Long(1005L));
        vector.addElement(new Long(1L));
        vector3.addElement("id");
        vector3.addElement("J");
        vector.addElement(vector3);
        vector.addElement(new Long(1006L));
        vector.addElement(new Long(4));
        vector2.addElement("decoding");
        vector2.addElement("J");
        vector.addElement(vector2);
        vector.addElement(new Long(1000L));
        this.id = this.getID();
        this.executeCommand(this, vector);
        return this.decoding;
    }

    public synchronized void selectCDFCacheSize(long l) throws CDFException {
        Vector<Serializable> vector = new Vector<Serializable>();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        vector.addElement(new Long(1005L));
        vector.addElement(new Long(1L));
        vector3.addElement("id");
        vector3.addElement("J");
        vector.addElement(vector3);
        vector.addElement(new Long(117L));
        vector2.addElement("cacheSize");
        vector2.addElement("J");
        vector.addElement(vector2);
        vector.addElement(new Long(1000L));
        this.cacheSize = l;
        this.id = this.getID();
        this.executeCommand(this, vector);
    }

    public synchronized long confirmCDFCacheSize() throws CDFException {
        Vector<Serializable> vector = new Vector<Serializable>();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        vector.addElement(new Long(1005L));
        vector.addElement(new Long(1L));
        vector3.addElement("id");
        vector3.addElement("J");
        vector.addElement(vector3);
        vector.addElement(new Long(1006L));
        vector.addElement(new Long(117L));
        vector2.addElement("cacheSize");
        vector2.addElement("J");
        vector.addElement(vector2);
        vector.addElement(new Long(1000L));
        this.id = this.getID();
        this.executeCommand(this, vector);
        return this.cacheSize;
    }

    public synchronized void selectNegtoPosfp0(long l) throws CDFException {
        Vector<Serializable> vector = new Vector<Serializable>();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        vector.addElement(new Long(1005L));
        vector.addElement(new Long(1L));
        vector3.addElement("id");
        vector3.addElement("J");
        vector.addElement(vector3);
        vector.addElement(new Long(19L));
        vector2.addElement("negtoPosfp0");
        vector2.addElement("J");
        vector.addElement(vector2);
        vector.addElement(new Long(1000L));
        this.negtoPosfp0 = l;
        this.id = this.getID();
        this.executeCommand(this, vector);
    }

    public synchronized long confirmNegtoPosfp0() throws CDFException {
        Vector<Serializable> vector = new Vector<Serializable>();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        vector.addElement(new Long(1005L));
        vector.addElement(new Long(1L));
        vector3.addElement("id");
        vector3.addElement("J");
        vector.addElement(vector3);
        vector.addElement(new Long(1006L));
        vector.addElement(new Long(19L));
        vector2.addElement("negtoPosfp0");
        vector2.addElement("J");
        vector.addElement(vector2);
        vector.addElement(new Long(1000L));
        this.id = this.getID();
        this.executeCommand(this, vector);
        return this.negtoPosfp0;
    }

    public synchronized long getFormat() {
        return this.format;
    }

    public synchronized void setFormat(long l) throws CDFException {
        Vector<Serializable> vector = new Vector<Serializable>();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        vector.addElement(new Long(1005L));
        vector.addElement(new Long(1L));
        vector3.addElement("id");
        vector3.addElement("J");
        vector.addElement(vector3);
        vector.addElement(new Long(1008L));
        vector.addElement(new Long(6L));
        vector2.addElement("formatX");
        vector2.addElement("J");
        vector.addElement(vector2);
        vector.addElement(new Long(1000L));
        this.formatX = l;
        this.id = this.getID();
        this.executeCommand(this, vector);
        this.format = l;
    }

    public synchronized String getVersion() {
        return this.version;
    }

    public synchronized long getMajority() {
        return this.majority;
    }

    public synchronized void setMajority(long l) throws CDFException {
        Vector<Serializable> vector = new Vector<Serializable>();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        vector.addElement(new Long(1005L));
        vector.addElement(new Long(1L));
        vector3.addElement("id");
        vector3.addElement("J");
        vector.addElement(vector3);
        vector.addElement(new Long(1008L));
        vector.addElement(new Long(5));
        vector2.addElement("majorityX");
        vector2.addElement("J");
        vector.addElement(vector2);
        vector.addElement(new Long(1000L));
        this.majorityX = l;
        this.id = this.getID();
        this.executeCommand(this, vector);
        this.majority = l;
    }

    public synchronized long getNumAttrs() {
        try {
            this.getAttributesandVariables();
            return this.attributes.size();
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    public synchronized long getNumGattrs() {
        long l = 0L;
        try {
            this.getAttributesandVariables();
            Enumeration enumeration = this.attributes.elements();
            while (enumeration.hasMoreElements()) {
                Attribute attribute = (Attribute)enumeration.nextElement();
                if (attribute.getScope() != 1L) continue;
                ++l;
            }
            return l;
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    public synchronized long getNumVattrs() {
        long l = 0L;
        try {
            this.getAttributesandVariables();
            Enumeration enumeration = this.attributes.elements();
            while (enumeration.hasMoreElements()) {
                Attribute attribute = (Attribute)enumeration.nextElement();
                if (attribute.getScope() != (long)2) continue;
                ++l;
            }
            return l;
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    public synchronized long getNumRvars() {
        return this.numRvars;
    }

    public synchronized long getNumZvars() {
        try {
            this.getAttributesandVariables();
            return this.variables.size();
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    public synchronized String getCopyright() {
        return this.copyright;
    }

    public synchronized void selectReadOnlyMode(long l) throws CDFException {
        Vector<Serializable> vector = new Vector<Serializable>();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        vector.addElement(new Long(1005L));
        vector.addElement(new Long(1L));
        vector3.addElement("id");
        vector3.addElement("J");
        vector.addElement(vector3);
        vector.addElement(new Long(17L));
        vector2.addElement("readOnly");
        vector2.addElement("J");
        vector.addElement(vector2);
        vector.addElement(new Long(1000L));
        this.readOnly = l;
        this.id = this.getID();
        this.executeCommand(this, vector);
    }

    public synchronized long confirmReadOnlyMode() throws CDFException {
        Vector<Serializable> vector = new Vector<Serializable>();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        vector.addElement(new Long(1005L));
        vector.addElement(new Long(1L));
        vector3.addElement("id");
        vector3.addElement("J");
        vector.addElement(vector3);
        vector.addElement(new Long(1006L));
        vector.addElement(new Long(17L));
        vector2.addElement("readOnly");
        vector2.addElement("J");
        vector.addElement(vector2);
        vector.addElement(new Long(1000L));
        this.id = this.getID();
        this.executeCommand(this, vector);
        return this.readOnly;
    }

    public synchronized long getCompressionType() {
        return this.cType;
    }

    public synchronized long getCompressionPct() {
        return this.cPct;
    }

    public synchronized long[] getCompressionParms() {
        return this.cParms;
    }

    public synchronized void setCompression(long l, long[] lArray) throws CDFException {
        Vector<Serializable> vector = new Vector<Serializable>();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        Vector<String> vector4 = new Vector<String>();
        vector.addElement(new Long(1005L));
        vector.addElement(new Long(1L));
        vector4.addElement("id");
        vector4.addElement("J");
        vector.addElement(vector4);
        vector.addElement(new Long(1008L));
        vector.addElement(new Long(130L));
        vector2.addElement("cTypeX");
        vector2.addElement("J");
        vector.addElement(vector2);
        vector3.addElement("cParmsX");
        vector3.addElement("[J");
        vector.addElement(vector3);
        vector.addElement(new Long(1000L));
        this.cTypeX = l;
        this.cParmsX = lArray;
        this.id = this.getID();
        this.executeCommand(this, vector);
        this.cType = l;
        this.cParms = lArray;
    }

    public synchronized String getCompression() throws CDFException {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.cType == 0L) {
            stringBuffer.append("No compression");
        } else {
            stringBuffer.append(CDFUtils.getStringCompressionType(this.cType)).append(".").append(this.cParms[0]);
        }
        return stringBuffer.toString();
    }

    private final void selectzMode(long l) throws CDFException {
        Vector<Serializable> vector = new Vector<Serializable>();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        vector.addElement(new Long(1005L));
        vector.addElement(new Long(1L));
        vector3.addElement("id");
        vector3.addElement("J");
        vector.addElement(vector3);
        vector.addElement(new Long(18L));
        vector2.addElement("zmode");
        vector2.addElement("J");
        vector.addElement(vector2);
        vector.addElement(new Long(1000L));
        this.zmode = l;
        this.id = this.getID();
        this.executeCommand(this, vector);
    }

    public synchronized long confirmzMode() throws CDFException {
        Vector<Serializable> vector = new Vector<Serializable>();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        vector.addElement(new Long(1005L));
        vector.addElement(new Long(1L));
        vector3.addElement("id");
        vector3.addElement("J");
        vector.addElement(vector3);
        vector.addElement(new Long(1006L));
        vector.addElement(new Long(18L));
        vector2.addElement("zmode");
        vector2.addElement("J");
        vector.addElement(vector2);
        vector.addElement(new Long(1000L));
        this.id = this.getID();
        this.executeCommand(this, vector);
        return this.zmode;
    }

    public synchronized void selectCompressCacheSize(long l) throws CDFException {
        Vector<Serializable> vector = new Vector<Serializable>();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        vector.addElement(new Long(1005L));
        vector.addElement(new Long(1L));
        vector3.addElement("id");
        vector3.addElement("J");
        vector.addElement(vector3);
        vector.addElement(new Long(155L));
        vector2.addElement("compressCacheSize");
        vector2.addElement("J");
        vector.addElement(vector2);
        vector.addElement(new Long(1000L));
        this.compressCacheSize = l;
        this.id = this.getID();
        this.executeCommand(this, vector);
    }

    public synchronized long confirmCompressCacheSize() throws CDFException {
        Vector<Serializable> vector = new Vector<Serializable>();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        vector.addElement(new Long(1005L));
        vector.addElement(new Long(1L));
        vector3.addElement("id");
        vector3.addElement("J");
        vector.addElement(vector3);
        vector.addElement(new Long(1006L));
        vector.addElement(new Long(155L));
        vector2.addElement("compressCacheSize");
        vector2.addElement("J");
        vector.addElement(vector2);
        vector.addElement(new Long(1000L));
        this.id = this.getID();
        this.executeCommand(this, vector);
        return this.compressCacheSize;
    }

    public synchronized void selectStageCacheSize(long l) throws CDFException {
        Vector<Serializable> vector = new Vector<Serializable>();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        vector.addElement(new Long(1005L));
        vector.addElement(new Long(1L));
        vector3.addElement("id");
        vector3.addElement("J");
        vector.addElement(vector3);
        vector.addElement(new Long(154L));
        vector2.addElement("stageCacheSize");
        vector2.addElement("J");
        vector.addElement(vector2);
        vector.addElement(new Long(1000L));
        this.stageCacheSize = l;
        this.id = this.getID();
        this.executeCommand(this, vector);
    }

    public synchronized long confirmStageCacheSize() throws CDFException {
        Vector<Serializable> vector = new Vector<Serializable>();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        vector.addElement(new Long(1005L));
        vector.addElement(new Long(1L));
        vector3.addElement("id");
        vector3.addElement("J");
        vector.addElement(vector3);
        vector.addElement(new Long(1006L));
        vector.addElement(new Long(154L));
        vector2.addElement("stageCacheSize");
        vector2.addElement("J");
        vector.addElement(vector2);
        vector.addElement(new Long(1000L));
        this.id = this.getID();
        this.executeCommand(this, vector);
        return this.stageCacheSize;
    }

    public synchronized String getName() {
        return this.path;
    }

    public synchronized void rename(String string) {
        this.path = string;
        this.theFile.renameTo(new File(string));
    }

    public synchronized void delete() throws CDFException {
        Vector<Serializable> vector = new Vector<Serializable>();
        Vector<String> vector2 = new Vector<String>();
        vector.addElement(new Long(1005L));
        vector.addElement(new Long(1L));
        vector2.addElement("id");
        vector2.addElement("J");
        vector.addElement(vector2);
        vector.addElement(new Long(1003L));
        vector.addElement(new Long(1L));
        vector.addElement(new Long(1000L));
        this.id = this.getID();
        this.executeCommand(this, vector);
    }

    public synchronized void save() throws CDFException {
        Vector<Long> vector = new Vector<Long>();
        Vector vector2 = new Vector();
        vector.addElement(new Long(1009L));
        this.id = this.getID();
        this.executeCommand(this, vector);
    }

    public static void setFileBackward(long l) throws CDFException {
        String string = CDF.getLibraryVersion();
        if (string.charAt(0) == '3') {
            CDF cDF = new CDF(new CDFNativeLibrary());
            Vector<Long> vector = new Vector<Long>();
            vector.addElement(new Long(1010L));
            vector.addElement(new Long(l));
            cDF.executeCommand(cDF, vector);
            backwardFlagSet = true;
            backward = l == 1L || l != 0L ? 1L : 0L;
        }
    }

    public static boolean getFileBackward() {
        if (backwardFlagSet) {
            return backward == 1L;
        }
        try {
            int n = CDF.getFileBackwardEnvVar();
            return n == 1;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static int getFileBackwardEnvVar() throws CDFException {
        if (backwardEnvVar == (long)-1) {
            CDF cDF = new CDF(new CDFNativeLibrary());
            Vector<Serializable> vector = new Vector<Serializable>();
            Vector<String> vector2 = new Vector<String>();
            vector.addElement(new Long(1011L));
            vector2.addElement("fromEnvVar");
            vector2.addElement("J");
            vector.addElement(vector2);
            cDF.executeCommand(cDF, vector);
            backwardEnvVar = cDF.fromEnvVar;
        }
        return (int)backwardEnvVar;
    }

    private static final int getValidateEnvVar() throws CDFException {
        if (backwardEnvVar == (long)-1) {
            CDF cDF = new CDF(new CDFNativeLibrary());
            Vector<Serializable> vector = new Vector<Serializable>();
            Vector<String> vector2 = new Vector<String>();
            vector.addElement(new Long(1015L));
            vector2.addElement("fromEnvVar");
            vector2.addElement("J");
            vector.addElement(vector2);
            cDF.executeCommand(cDF, vector);
            validateEnvVar = cDF.fromEnvVar;
        }
        return (int)validateEnvVar;
    }

    public static String getLeapSecondsTableEnvVar() throws CDFException {
        CDF cDF = new CDF(new CDFNativeLibrary());
        Vector<Serializable> vector = new Vector<Serializable>();
        Vector<String> vector2 = new Vector<String>();
        vector.addElement(new Long(1016L));
        vector2.addElement("leapTableEnvVar");
        vector2.addElement("Ljava/lang/String;");
        vector.addElement(vector2);
        cDF.executeCommand(cDF, vector);
        return cDF.leapTableEnvVar;
    }

    public static long getChecksumEnvVar() throws CDFException {
        if (checksumEnvVar == (long)-1) {
            CDF cDF = new CDF(new CDFNativeLibrary());
            Vector<Serializable> vector = new Vector<Serializable>();
            Vector<String> vector2 = new Vector<String>();
            vector.addElement(new Long(1013L));
            vector2.addElement("fromEnvVar");
            vector2.addElement("J");
            vector.addElement(vector2);
            cDF.executeCommand(cDF, vector);
            checksumEnvVar = cDF.fromEnvVar;
        }
        return checksumEnvVar;
    }

    public static void setValidate(long l) throws CDFException {
        CDF cDF = new CDF(new CDFNativeLibrary());
        Vector<Long> vector = new Vector<Long>();
        vector.addElement(new Long(1014L));
        vector.addElement(new Long(l));
        cDF.executeCommand(cDF, vector);
        validateFlagSet = true;
        validate = l == (long)-1 || l != 0L ? (long)-1 : 0L;
    }

    public static boolean getValidate() {
        if (validateFlagSet) {
            return validate == (long)-1;
        }
        try {
            int n = CDF.getValidateEnvVar();
            return n == 1;
        }
        catch (Exception exception) {
            return true;
        }
    }

    public synchronized long getStatus() {
        return this.cdfStatus;
    }

    private final synchronized void setStatus(long l) {
        this.cdfStatus = l;
    }

    public static String getStatusText(long l) {
        StringBuffer stringBuffer = new StringBuffer();
        if (l > 0L) {
            stringBuffer.append("INFO: ");
        } else if (l < 0L && l > -2000L) {
            stringBuffer.append("WARNING: ");
        }
        return stringBuffer.append(CDFException.getStatusMsg(l)).toString();
    }

    public synchronized void setInfoWarningOff() {
        this.infoWarning = 0L;
    }

    public synchronized void setInfoWarningOn() {
        this.infoWarning = 1L;
    }

    private final synchronized void select() throws CDFException {
        Vector<Long> vector = new Vector<Long>();
        vector.addElement(new Long(1000L));
        this.id = this.getID();
        this.executeCommand(this, vector);
    }

    public String toString() {
        return this.path;
    }

    public void finalize() throws Throwable {
        super.finalize();
    }

    public synchronized CDFDelegate getDelegate() {
        return this.delegate;
    }

    public synchronized void setDelegate(CDFDelegate cDFDelegate) {
        this.delegate = cDFDelegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected synchronized void executeCommand(CDFObject cDFObject, Vector vector) throws CDFException {
        Object object = Monitor;
        synchronized (object) {
            this.delegate.cdflib(this, cDFObject, vector);
            return;
        }
    }

    public synchronized long getAttributeID(String string) {
        int n = 0;
        this.getAttributesandVariables();
        if (this.attributes.size() == 0) {
            return -1;
        }
        try {
            while (!this.attributes.elementAt(n).toString().equals(string)) {
                if (++n >= this.attributes.size()) break;
            }
            if (n == this.attributes.size()) {
                return -1;
            }
            return n;
        }
        catch (Exception exception) {
            return -1;
        }
    }

    protected final synchronized void addAttribute(Attribute attribute) throws CDFException {
        this.attributes.addElement(attribute);
    }

    protected final synchronized void removeAttribute(Attribute attribute) {
        try {
            this.getAttributesandVariables();
            this.attributes.removeElement(attribute);
        }
        catch (Exception exception) {}
    }

    public synchronized Attribute getAttribute(long l) throws CDFException {
        this.getAttributesandVariables();
        if (l > (long)this.attributes.size()) {
            throw new CDFException(-2017L);
        }
        return (Attribute)this.attributes.elementAt((int)l);
    }

    public synchronized Attribute getAttribute(String string) throws CDFException {
        this.getAttributesandVariables();
        long l = this.getAttributeID(string);
        if (l == (long)-1) {
            throw new CDFException(-2017L);
        }
        return (Attribute)this.attributes.elementAt((int)l);
    }

    public synchronized Vector getAttributes() {
        try {
            this.getAttributesandVariables();
            return this.attributes;
        }
        catch (Exception exception) {
            return new Vector();
        }
    }

    public synchronized Vector getGlobalAttributes() {
        try {
            this.getAttributesandVariables();
            Vector<Attribute> vector = new Vector<Attribute>();
            Enumeration enumeration = this.attributes.elements();
            while (enumeration.hasMoreElements()) {
                Attribute attribute = (Attribute)enumeration.nextElement();
                if (attribute.getScope() != 1L) continue;
                vector.addElement(attribute);
            }
            return vector;
        }
        catch (Exception exception) {
            return new Vector();
        }
    }

    public synchronized Vector getVariableAttributes() {
        try {
            this.getAttributesandVariables();
            Vector<Attribute> vector = new Vector<Attribute>();
            Enumeration enumeration = this.attributes.elements();
            while (enumeration.hasMoreElements()) {
                Attribute attribute = (Attribute)enumeration.nextElement();
                if (attribute.getScope() != (long)2) continue;
                vector.addElement(attribute);
            }
            return vector;
        }
        catch (Exception exception) {
            return new Vector();
        }
    }

    public synchronized Vector getOrphanAttributes() {
        try {
            this.getAttributesandVariables();
            boolean bl = true;
            Vector<Attribute> vector = new Vector<Attribute>();
            if (this.getNumVars() <= 0L) {
                return vector;
            }
            Vector vector2 = this.getVariableAttributes();
            Vector vector3 = this.getVariables();
            Enumeration enumeration = vector2.elements();
            while (enumeration.hasMoreElements()) {
                Attribute attribute = (Attribute)enumeration.nextElement();
                bl = true;
                Enumeration enumeration2 = vector3.elements();
                while (enumeration2.hasMoreElements()) {
                    Variable variable = (Variable)enumeration2.nextElement();
                    try {
                        Entry entry = attribute.getEntry(variable);
                        if (entry == null) continue;
                        bl = false;
                        break;
                    }
                    catch (CDFException cDFException) {
                        if (cDFException.getCurrentStatus() == -2018L) continue;
                        System.out.println("** Error occurred in getOrphanAttributes");
                        System.out.println(cDFException);
                        System.exit(0);
                    }
                }
                if (!bl) continue;
                vector.addElement(attribute);
            }
            return vector;
        }
        catch (Exception exception) {
            return new Vector();
        }
    }

    public synchronized long getVariableID(String string) {
        this.getAttributesandVariables();
        long l = 0L;
        if (this.variables.size() == 0) {
            return -1;
        }
        try {
            while (!this.variables.elementAt((int)l).toString().equals(string)) {
                if (++l >= (long)this.variables.size()) break;
            }
            if (l == (long)this.variables.size()) {
                return -1;
            }
            return l;
        }
        catch (CDFException cDFException) {
            return -1;
        }
    }

    protected final synchronized void addVariable(Variable variable) {
        Enumeration enumeration = this.attributes.elements();
        while (enumeration.hasMoreElements()) {
            Attribute attribute = (Attribute)enumeration.nextElement();
            if (attribute.getScope() != (long)2) continue;
            attribute.addNullEntry();
        }
        this.variables.addElement(variable);
    }

    protected final synchronized void removeVariable(Variable variable) {
        try {
            this.getAttributesandVariables();
            int n = this.variables.indexOf(variable);
            Enumeration enumeration = this.attributes.elements();
            while (enumeration.hasMoreElements()) {
                Attribute attribute = (Attribute)enumeration.nextElement();
                if (attribute.getScope() != (long)2) continue;
                attribute.removeEntry(n);
            }
            this.variables.removeElement(variable);
        }
        catch (CDFException cDFException) {}
    }

    public synchronized Variable getVariable(long l) throws CDFException {
        this.getAttributesandVariables();
        if (l > (long)this.variables.size()) {
            throw new CDFException(-2019L);
        }
        return (Variable)this.variables.elementAt((int)l);
    }

    public synchronized Variable getVariable(String string) throws CDFException {
        this.getAttributesandVariables();
        long l = this.getVariableID(string);
        if (l == (long)-1) {
            throw new CDFException(-2019L);
        }
        return (Variable)this.variables.elementAt((int)l);
    }

    public synchronized Vector getVariables() {
        try {
            this.getAttributesandVariables();
            return this.variables;
        }
        catch (CDFException cDFException) {
            return new Vector();
        }
    }

    public synchronized long getNumVars() {
        try {
            this.getAttributesandVariables();
            return this.variables.size();
        }
        catch (CDFException cDFException) {
            return 0L;
        }
    }

    public synchronized Vector getRecord(long l, String[] stringArray) throws CDFException {
        return this.getRecord(l, stringArray, null);
    }

    public synchronized Vector getRecord(long l, String[] stringArray, long[] lArray) throws CDFException {
        if (l < 0L || stringArray == null || stringArray.length == 0) {
            return null;
        }
        int n = stringArray.length;
        long[] lArray2 = new long[n];
        int n2 = 0;
        while (n2 < n) {
            lArray2[n2] = this.getVariableID(stringArray[n2]);
            if (lArray2[n2] == (long)-1) {
                System.err.println("Error: Variable: " + stringArray[n2] + " not exists!!!");
                throw new CDFException(-2019L);
            }
            ++n2;
        }
        return this.getRecord(l, lArray2, lArray);
    }

    public synchronized Vector getRecord(long l, long[] lArray) throws CDFException {
        return this.getRecord(l, lArray, null);
    }

    public synchronized Vector getRecord(long l, long[] lArray, long[] lArray2) throws CDFException {
        if (l < 0L || lArray == null || lArray.length == 0) {
            return null;
        }
        int n = lArray.length;
        Vector<Object> vector = new Vector<Object>();
        int n2 = 0;
        while (n2 < n) {
            Variable variable;
            try {
                variable = this.getVariable(lArray[n2]);
            }
            catch (CDFException cDFException) {
                System.err.println("Error: Variable: " + lArray[n2] + " not exists!!!");
                throw new CDFException(-2019L);
            }
            vector.add(variable.getRecord(l));
            if (lArray2 != null) {
                lArray2[n2] = this.getStatus();
            }
            ++n2;
        }
        return vector;
    }

    public synchronized void putRecord(long l, String[] stringArray, Vector vector) throws CDFException {
        this.putRecord(l, stringArray, vector, null);
    }

    public synchronized void putRecord(long l, String[] stringArray, Vector vector, long[] lArray) throws CDFException {
        if (l < 0L || stringArray == null || stringArray.length == 0 || vector == null || vector.isEmpty()) {
            return;
        }
        int n = stringArray.length;
        long[] lArray2 = new long[n];
        int n2 = 0;
        while (n2 < n) {
            lArray2[n2] = this.getVariableID(stringArray[n2]);
            if (lArray2[n2] == (long)-1) {
                System.err.println("Error: Variable: " + stringArray[n2] + " not exists!!!");
                throw new CDFException(-2019L);
            }
            ++n2;
        }
        this.putRecord(l, lArray2, vector, lArray);
    }

    public synchronized void putRecord(long l, long[] lArray, Vector vector) throws CDFException {
        this.putRecord(l, lArray, vector, null);
    }

    public synchronized void putRecord(long l, long[] lArray, Vector vector, long[] lArray2) throws CDFException {
        if (l < 0L || lArray == null || lArray.length == 0 || vector == null || vector.isEmpty()) {
            return;
        }
        if (lArray.length != vector.size()) {
            System.err.println("Error: the variables' count: " + lArray.length + " does not match the record objects' count: " + vector.size());
            return;
        }
        if (lArray2 != null && lArray2.length < lArray.length) {
            System.err.println("Error: the variables' count: " + lArray.length + " does not match the status' count: " + lArray2.length);
            return;
        }
        int n = lArray.length;
        int n2 = 0;
        while (n2 < n) {
            Variable variable;
            try {
                variable = this.getVariable(lArray[n2]);
            }
            catch (CDFException cDFException) {
                System.err.println("Error: Variable: " + lArray[n2] + " not exists!!!");
                throw new CDFException(-2019L);
            }
            variable.putRecord(l, vector.elementAt(n2));
            if (lArray2 != null) {
                lArray2[n2] = this.getStatus();
            }
            ++n2;
        }
    }

    public synchronized void setChecksum(long l) throws CDFException {
        Vector<Serializable> vector = new Vector<Serializable>();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        if (l != 0L && l != 1L) {
            throw new CDFException(-2225L);
        }
        this.checksumX = l;
        vector.addElement(new Long(1005L));
        vector.addElement(new Long(1L));
        vector2.addElement("id");
        vector2.addElement("J");
        vector.addElement(vector2);
        vector.addElement(new Long(1008L));
        vector.addElement(new Long(156L));
        vector3.addElement("checksumX");
        vector3.addElement("J");
        vector.addElement(vector3);
        vector.addElement(new Long(1000L));
        this.id = this.getID();
        this.executeCommand(this, vector);
        this.checksum = l;
    }

    public synchronized long getChecksum() {
        return this.checksum;
    }

    public synchronized void setLeapSecondLastUpdated(long l) throws CDFException {
        Vector<Serializable> vector = new Vector<Serializable>();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        this.lastUpdatedX = l;
        vector.addElement(new Long(1005L));
        vector.addElement(new Long(1L));
        vector3.addElement("id");
        vector3.addElement("J");
        vector.addElement(vector3);
        vector.addElement(new Long(1008L));
        vector.addElement(new Long(159L));
        vector2.addElement("lastUpdatedX");
        vector2.addElement("J");
        vector.addElement(vector2);
        vector.addElement(new Long(1000L));
        this.id = this.getID();
        this.executeCommand(this, vector);
        this.lastUpdated = l;
    }

    public synchronized long getLeapSecondLastUpdated() throws CDFException {
        return this.leapSecondLastUpdated;
    }

    public synchronized long verifyChecksum() throws CDFException {
        Vector<Serializable> vector = new Vector<Serializable>();
        Vector<String> vector2 = new Vector<String>();
        vector.addElement(new Long(1005L));
        vector.addElement(new Long(1L));
        vector2.addElement("id");
        vector2.addElement("J");
        vector.addElement(vector2);
        vector.addElement(new Long(1006L));
        vector.addElement(new Long(156L));
        vector.addElement(new Long(1000L));
        this.id = this.getID();
        this.executeCommand(this, vector);
        return this.getStatus();
    }

    private final String FindCDFName(String string) {
        if (new File(string).isFile()) {
            return string;
        }
        String string2 = string + ".cdf";
        if (new File(string2).isFile()) {
            return string2;
        }
        string2 = string + ".CDF";
        if (new File(string2).isFile()) {
            return string2;
        }
        string2 = string + ".cdf;1";
        if (new File(string2).isFile()) {
            return string2;
        }
        string2 = string + ".CDF;1";
        if (new File(string2).isFile()) {
            return string2;
        }
        return null;
    }

    private final /* synthetic */ void this() {
        this.theFile = null;
        this.cParms = new long[1];
        this.cParmsX = new long[1];
        this.copyright = null;
        this.version = null;
        this.checksumX = -1;
        this.lastUpdatedX = -1;
        this.leapTableEnvVar = null;
    }

    /*
     * Unable to fully structure code
     */
    private CDF(String var1_1, CDFDelegate var2_2) throws CDFException {
        super();
        this.this();
        if (var1_1 == null || var1_1.length() == 0) {
            throw new CDFException(-2049L);
        }
        var3_3 = null;
        var3_3 = var1_1.trim();
        if (var3_3 != null && var3_3.length() != 0) ** GOTO lbl10
        throw new CDFException(-2049L);
lbl-1000:
        // 1 sources

        {
            var3_3 = var3_3.substring(1);
lbl10:
            // 2 sources

            ** while (var3_3.startsWith((String)" "))
        }
lbl11:
        // 1 sources

        this.path = var3_3;
        this.delegate = var2_2;
        this.zmode = 2;
        this.attributes = new Vector<E>();
        this.variables = new Vector<E>();
        this.closed = false;
        CDF.checksumEnvVar = CDF.getChecksumEnvVar();
    }

    private CDF(CDFDelegate cDFDelegate) throws CDFException {
        this.this();
        this.delegate = cDFDelegate;
    }
}

