/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.gsfc.spdf.cdfj;

import gov.nasa.gsfc.spdf.cdfj.CDFException;
import gov.nasa.gsfc.spdf.cdfj.GenericReader;
import gov.nasa.gsfc.spdf.cdfj.MetaData;
import gov.nasa.gsfc.spdf.cdfj.TSExtractor;
import gov.nasa.gsfc.spdf.cdfj.TimeInstantModel;
import gov.nasa.gsfc.spdf.cdfj.TimePrecision;
import gov.nasa.gsfc.spdf.cdfj.TimeSeries;
import gov.nasa.gsfc.spdf.cdfj.TimeSeriesOneD;
import gov.nasa.gsfc.spdf.cdfj.TimeSeriesX;
import gov.nasa.gsfc.spdf.cdfj.TimeUtil;
import gov.nasa.gsfc.spdf.cdfj.TimeVariableFactory;
import gov.nasa.gsfc.spdf.cdfj.Variable;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.Vector;

public class CDFReader
extends GenericReader {
    Scalar scalar;
    CDFVector vector;

    public CDFReader() {
    }

    public CDFReader(String string) throws CDFException.ReaderError {
        super(string);
        this.scalar = new Scalar();
        this.scalar.rdr = this;
        this.vector = new CDFVector();
        this.vector.rdr = this;
    }

    public CDFReader(URL uRL) throws CDFException.ReaderError {
        super(uRL);
        this.scalar = new Scalar();
        this.scalar.rdr = this;
        this.vector = new CDFVector();
        this.vector.rdr = this;
    }

    public TimeSeries getTimeSeries(String string) throws CDFException.ReaderError {
        return this.getTimeSeries(string, null, CDFReader.timeModelInstance());
    }

    public TimeSeries getTimeSeries(String string, TimeInstantModel timeInstantModel) throws CDFException.ReaderError {
        TimeInstantModel timeInstantModel2 = timeInstantModel == null ? CDFReader.timeModelInstance() : timeInstantModel;
        return this.getTimeSeries(string, null, timeInstantModel2);
    }

    public TimeSeries getTimeSeries(String string, int[] nArray, int[] nArray2) throws CDFException.ReaderError {
        return this.getTimeSeries(string, nArray, nArray2, null);
    }

    private TimeSeries getTimeSeries(String string, double[] dArray, TimeInstantModel timeInstantModel) throws CDFException.ReaderError {
        Variable variable = this.thisCDF.getVariable(string);
        TSExtractor.GeneralTimeSeriesX generalTimeSeriesX = null;
        try {
            generalTimeSeriesX = new TSExtractor.GeneralTimeSeriesX(this, variable, false, dArray, timeInstantModel, false, true);
            return new TimeSeriesImpl(generalTimeSeriesX);
        }
        catch (Throwable throwable) {
            throw new CDFException.ReaderError(throwable.getMessage());
        }
    }

    public TimeSeries getTimeSeries(String string, int[] nArray, int[] nArray2, TimeInstantModel timeInstantModel) throws CDFException.ReaderError {
        TimeVariableFactory.CDFTimeVariable cDFTimeVariable = null;
        try {
            cDFTimeVariable = TimeVariableFactory.getTimeVariable(this, string);
            TimeInstantModel timeInstantModel2 = timeInstantModel;
            if (timeInstantModel2 == null) {
                timeInstantModel2 = CDFReader.timeModelInstance();
            }
            if (!cDFTimeVariable.canSupportPrecision(timeInstantModel2.getOffsetUnits())) {
                throw new CDFException.ReaderError(string + " has lower time precision than " + "requested.");
            }
            double[] dArray = this.getAvailableTimeRange(string);
            double[] dArray2 = TSExtractor.getOverlap(this, dArray, string, nArray, nArray2);
            return this.getTimeSeries(string, dArray2, timeInstantModel);
        }
        catch (Throwable throwable) {
            throw new CDFException.ReaderError(throwable.getMessage());
        }
    }

    private TimeSeriesOneD getTimeSeries(String string, double[] dArray, TimeInstantModel timeInstantModel, boolean bl) throws CDFException.ReaderError {
        Variable variable = this.thisCDF.getVariable(string);
        TSExtractor.GeneralTimeSeriesX generalTimeSeriesX = null;
        try {
            generalTimeSeriesX = new TSExtractor.GeneralTimeSeriesX(this, variable, false, dArray, timeInstantModel, true, bl);
            return new TimeSeriesOneDImpl(generalTimeSeriesX);
        }
        catch (Throwable throwable) {
            throw new CDFException.ReaderError(throwable.getMessage());
        }
    }

    public TimeSeriesOneD getTimeSeriesOneD(String string, int[] nArray, int[] nArray2, TimeInstantModel timeInstantModel, boolean bl) throws CDFException.ReaderError {
        try {
            TimeVariableFactory.CDFTimeVariable cDFTimeVariable = TimeVariableFactory.getTimeVariable(this, string);
            TimeInstantModel timeInstantModel2 = timeInstantModel;
            if (timeInstantModel2 == null) {
                timeInstantModel2 = CDFReader.timeModelInstance();
            }
            if (!cDFTimeVariable.canSupportPrecision(timeInstantModel2.getOffsetUnits())) {
                System.out.println("cannot support");
                throw new Throwable(string + " has lower time precision than " + "requested.");
            }
            double[] dArray = this.getAvailableTimeRange(string);
            double[] dArray2 = TSExtractor.getOverlap(this, dArray, string, nArray, nArray2);
            return this.getTimeSeries(string, dArray2, timeInstantModel2, bl);
        }
        catch (Throwable throwable) {
            System.out.println(throwable.getMessage());
            throwable.printStackTrace();
            throw new CDFException.ReaderError(throwable.getMessage());
        }
    }

    public double[] getAvailableTimeRange(String string) throws CDFException.ReaderError {
        try {
            TimeVariableFactory.CDFTimeVariable cDFTimeVariable = TimeVariableFactory.getTimeVariable(this, string);
            double[] dArray = cDFTimeVariable.getTimes();
            return new double[]{dArray[0], dArray[dArray.length - 1]};
        }
        catch (Throwable throwable) {
            throw new CDFException.ReaderError(throwable.getMessage());
        }
    }

    boolean overlaps(double[] dArray) {
        if (dArray[0] == Double.MIN_VALUE) {
            return false;
        }
        return dArray[0] != Double.MAX_VALUE;
    }

    public int[] firstAvailableTime(String string) throws CDFException.ReaderError {
        return this.firstAvailableTime(string, null);
    }

    public int[] firstAvailableTime(String string, int[] nArray) throws CDFException.ReaderError {
        try {
            double[] dArray;
            TimeVariableFactory.CDFTimeVariable cDFTimeVariable = TimeVariableFactory.getTimeVariable(this, string);
            double[] dArray2 = cDFTimeVariable.getTimes();
            double[] dArray3 = new double[]{dArray2[0], dArray2[dArray2.length - 1]};
            try {
                dArray = TSExtractor.getOverlap(this, dArray3, string, nArray, null);
            }
            catch (Exception exception) {
                return null;
            }
            if (dArray[0] != Double.MIN_VALUE) {
                GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
                gregorianCalendar.setTimeInMillis((long)dArray[0]);
                if (cDFTimeVariable.isTT2000()) {
                    long l = gregorianCalendar.getTime().getTime();
                    long l2 = (long)TimeUtil.getOffset(l);
                    gregorianCalendar.setTimeInMillis((long)dArray[0] - l2 + l);
                }
                return this.GMT(gregorianCalendar);
            }
            return null;
        }
        catch (Throwable throwable) {
            throw new CDFException.ReaderError(throwable.getMessage());
        }
    }

    public int[] lastAvailableTime(String string) throws CDFException.ReaderError {
        return this.lastAvailableTime(string, null);
    }

    public int[] lastAvailableTime(String string, int[] nArray) throws CDFException.ReaderError {
        try {
            double[] dArray;
            TimeVariableFactory.CDFTimeVariable cDFTimeVariable = TimeVariableFactory.getTimeVariable(this, string);
            double[] dArray2 = cDFTimeVariable.getTimes();
            double[] dArray3 = new double[]{dArray2[0], dArray2[dArray2.length - 1]};
            try {
                dArray = TSExtractor.getOverlap(this, dArray3, string, null, nArray);
            }
            catch (Exception exception) {
                return null;
            }
            if (dArray[1] != Double.MAX_VALUE) {
                GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
                gregorianCalendar.setTimeInMillis((long)dArray[1]);
                if (cDFTimeVariable.isTT2000()) {
                    long l = gregorianCalendar.getTime().getTime();
                    long l2 = (long)TimeUtil.getOffset(l);
                    gregorianCalendar.setTimeInMillis((long)dArray[1] - l2 + l);
                }
                return this.GMT(gregorianCalendar);
            }
            return null;
        }
        catch (Throwable throwable) {
            throw new CDFException.ReaderError(throwable.getMessage());
        }
    }

    int[] GMT(Calendar calendar) {
        return new int[]{calendar.get(1), calendar.get(2) + 1, calendar.get(5), calendar.get(11), calendar.get(12), calendar.get(13), calendar.get(14)};
    }

    public TimeInstantModel timeModelInstance(String string, int[] nArray) throws CDFException.ReaderError {
        if (nArray.length < 3) {
            throw new CDFException.ReaderError("incomplete base time definition.");
        }
        try {
            boolean bl = TimeVariableFactory.getTimeVariable(this, string).isTT2000();
            long l = TSExtractor.getTime(nArray);
            double d = !bl ? (double)l : TimeUtil.milliSecondSince1970(l);
            return this.getTimeInstantModel(d += (double)TimeVariableFactory.JANUARY_1_1970_LONG);
        }
        catch (Throwable throwable) {
            throw new CDFException.ReaderError(throwable.getMessage());
        }
    }

    public TimeInstantModel timeModelInstance(String string, int[] nArray, TimePrecision timePrecision) throws CDFException.ReaderError {
        TimeInstantModel timeInstantModel = this.timeModelInstance(string, nArray);
        timeInstantModel.setOffsetUnits(timePrecision);
        return timeInstantModel;
    }

    private TimeInstantModel getTimeInstantModel(double d) {
        TimeInstantModel timeInstantModel = TimeVariableFactory.getDefaultTimeInstantModel(d);
        return timeInstantModel;
    }

    private double getTime(String string, int[] nArray) throws CDFException.ReaderError {
        try {
            return TSExtractor.getTime(this, string, nArray);
        }
        catch (Throwable throwable) {
            throw new CDFException.ReaderError(throwable.getMessage());
        }
    }

    public static TimeInstantModel timeModelInstance() {
        return TimeVariableFactory.getDefaultTimeInstantModel();
    }

    public static TimeInstantModel timeModelInstance(String string) {
        TimeInstantModel timeInstantModel = TimeVariableFactory.getDefaultTimeInstantModel();
        timeInstantModel.setOffsetUnits(TimePrecision.getPrecision(string));
        return timeInstantModel;
    }

    public String[] getDependent(String string) {
        String[] stringArray = this.thisCDF.variableAttributeNames(string);
        if (stringArray == null) {
            return new String[0];
        }
        Vector vector = new Vector();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].startsWith("DEPEND_")) continue;
            vector.add(((Vector)this.thisCDF.getAttribute(string, stringArray[i])).get(0));
        }
        String[] stringArray2 = new String[vector.size()];
        vector.toArray(stringArray2);
        return stringArray2;
    }

    public String getIndexName(String string, int n) throws CDFException.ReaderError {
        try {
            int[] nArray = this.getDimensions(string);
            if (nArray.length == 0) {
                return null;
            }
            if (n >= nArray.length) {
                return null;
            }
            Vector vector = (Vector)this.getAttribute(string, "DEPEND_" + (1 + n));
            return (String)vector.get(0);
        }
        catch (Throwable throwable) {
            throw new CDFException.ReaderError(throwable.getMessage());
        }
    }

    public double[][] getScalarTimeSeries(String string) throws CDFException.ReaderError {
        try {
            return this.scalar.getTimeSeries(string);
        }
        catch (Throwable throwable) {
            throw new CDFException.ReaderError(throwable.getMessage());
        }
    }

    public double[][] getScalarTimeSeries(String string, int[] nArray, int[] nArray2) throws CDFException.ReaderError {
        try {
            return this.scalar.getTimeSeries(string, nArray, nArray2);
        }
        catch (Throwable throwable) {
            throw new CDFException.ReaderError(throwable.getMessage());
        }
    }

    public TimeSeries getScalarTimeSeries(String string, int[] nArray, int[] nArray2, TimeInstantModel timeInstantModel) throws CDFException.ReaderError {
        try {
            return this.scalar.getTimeSeries(string, nArray, nArray2, timeInstantModel);
        }
        catch (Throwable throwable) {
            throw new CDFException.ReaderError(throwable.getMessage());
        }
    }

    public double[][] getScalarTimeSeries(String string, boolean bl) throws CDFException.ReaderError {
        try {
            return this.scalar.getTimeSeries(string, bl);
        }
        catch (Throwable throwable) {
            throw new CDFException.ReaderError(throwable.getMessage());
        }
    }

    public double[][] getScalarTimeSeries(String string, boolean bl, int[] nArray, int[] nArray2) throws CDFException.ReaderError {
        try {
            return this.scalar.getTimeSeries(string, bl, nArray, nArray2);
        }
        catch (Throwable throwable) {
            throw new CDFException.ReaderError(throwable.getMessage());
        }
    }

    public TimeSeries getScalarTimeSeries(String string, boolean bl, int[] nArray, int[] nArray2, TimeInstantModel timeInstantModel) throws CDFException.ReaderError {
        try {
            return this.scalar.getTimeSeries(string, bl, nArray, nArray2, timeInstantModel);
        }
        catch (Throwable throwable) {
            throw new CDFException.ReaderError(throwable.getMessage());
        }
    }

    public double[][] getVectorTimeSeries(String string, int n) throws CDFException.ReaderError {
        try {
            return this.vector.getTimeSeries(string, n);
        }
        catch (Throwable throwable) {
            throw new CDFException.ReaderError(throwable.getMessage());
        }
    }

    public double[][] getVectorTimeSeries(String string, int n, int[] nArray, int[] nArray2) throws CDFException.ReaderError {
        try {
            return this.vector.getTimeSeries(string, n, nArray, nArray2);
        }
        catch (Throwable throwable) {
            throw new CDFException.ReaderError(throwable.getMessage());
        }
    }

    public TimeSeries getVectorTimeSeries(String string, int n, int[] nArray, int[] nArray2, TimeInstantModel timeInstantModel) throws CDFException.ReaderError {
        try {
            return this.vector.getTimeSeries(string, n, nArray, nArray2, timeInstantModel);
        }
        catch (Throwable throwable) {
            throw new CDFException.ReaderError(throwable.getMessage());
        }
    }

    public double[][] getVectorTimeSeries(String string, int n, boolean bl) throws CDFException.ReaderError {
        try {
            return this.vector.getTimeSeries(string, n, bl);
        }
        catch (Throwable throwable) {
            throw new CDFException.ReaderError(throwable.getMessage());
        }
    }

    public double[][] getVectorTimeSeries(String string, int n, boolean bl, int[] nArray, int[] nArray2) throws CDFException.ReaderError {
        try {
            return this.vector.getTimeSeries(string, n, bl, nArray, nArray2);
        }
        catch (Throwable throwable) {
            throw new CDFException.ReaderError(throwable.getMessage());
        }
    }

    public TimeSeries getVectorTimeSeries(String string, int n, boolean bl, int[] nArray, int[] nArray2, TimeInstantModel timeInstantModel) throws CDFException.ReaderError {
        try {
            return this.vector.getTimeSeries(string, n, bl, nArray, nArray2, timeInstantModel);
        }
        catch (Throwable throwable) {
            throw new CDFException.ReaderError(throwable.getMessage());
        }
    }

    class CDFVector {
        MetaData rdr;

        CDFVector() {
        }

        private double[][] _getTimeSeries(String string, int n, boolean bl, double[] dArray) throws Throwable {
            CDFReader.this.checkType(string);
            Variable variable = CDFReader.this.thisCDF.getVariable(string);
            Method method = TSExtractor.getMethod(variable, "TimeSeries", 1);
            return (double[][])method.invoke(null, this.rdr, variable, new Integer(n), new Boolean(bl), dArray);
        }

        private TimeSeries _getTimeSeries(String string, int n, boolean bl, double[] dArray, TimeInstantModel timeInstantModel) throws Throwable {
            CDFReader.this.checkType(string);
            Variable variable = CDFReader.this.thisCDF.getVariable(string);
            Method method = TSExtractor.getMethod(variable, "TimeSeriesObject", 1);
            TimeSeries timeSeries = (TimeSeries)method.invoke(null, this.rdr, variable, new Integer(n), new Boolean(bl), dArray, timeInstantModel);
            return new TimeSeriesImpl(timeSeries);
        }

        public double[][] getTimeSeries(String string, int n) throws Throwable {
            Variable variable = CDFReader.this.thisCDF.getVariable(string);
            if (variable.getEffectiveRank() != 1) {
                throw new Throwable(string + " is not a vector.");
            }
            int n2 = variable.getEffectiveDimensions()[0];
            if (n < 0 || n > n2) {
                throw new Throwable("component exceeds dimension of " + string + " (" + n2 + ")");
            }
            return this._getTimeSeries(string, n, true, null);
        }

        public double[][] getTimeSeries(String string, int n, int[] nArray, int[] nArray2) throws Throwable {
            if (CDFReader.this.thisCDF.getVariable(string).getEffectiveRank() != 1) {
                throw new Throwable(string + " is not a vector.");
            }
            Integer n2 = (Integer)CDFReader.this.thisCDF.getVariable(string).getElementCount().get(0);
            if (n < 0 || n > n2) {
                throw new Throwable("Invalid component " + n + " for " + string);
            }
            double[] dArray = CDFReader.this.getAvailableTimeRange(string);
            double[] dArray2 = TSExtractor.getOverlap(this.rdr, dArray, string, nArray, nArray2);
            return this._getTimeSeries(string, n, true, dArray2);
        }

        public TimeSeries getTimeSeries(String string, int n, int[] nArray, int[] nArray2, TimeInstantModel timeInstantModel) throws Throwable {
            if (CDFReader.this.thisCDF.getVariable(string).getEffectiveRank() != 1) {
                throw new Throwable(string + " is not a vector.");
            }
            Integer n2 = (Integer)CDFReader.this.thisCDF.getVariable(string).getElementCount().get(0);
            if (n < 0 || n > n2) {
                throw new Throwable("Invalid component " + n + " for " + string);
            }
            double[] dArray = CDFReader.this.getAvailableTimeRange(string);
            double[] dArray2 = TSExtractor.getOverlap(this.rdr, dArray, string, nArray, nArray2);
            return this._getTimeSeries(string, n, true, dArray2, timeInstantModel);
        }

        public double[][] getTimeSeries(String string, int n, boolean bl) throws Throwable {
            if (CDFReader.this.thisCDF.getVariable(string).getEffectiveRank() != 1) {
                throw new Throwable(string + " is not a vector.");
            }
            Integer n2 = (Integer)CDFReader.this.thisCDF.getVariable(string).getElementCount().get(0);
            if (n < 0 || n > n2) {
                throw new Throwable("Invalid component " + n + " for " + string);
            }
            return this._getTimeSeries(string, n, bl, null);
        }

        public double[][] getTimeSeries(String string, int n, boolean bl, int[] nArray, int[] nArray2) throws Throwable {
            if (CDFReader.this.thisCDF.getVariable(string).getEffectiveRank() != 1) {
                throw new Throwable(string + " is not a vector.");
            }
            Integer n2 = (Integer)CDFReader.this.thisCDF.getVariable(string).getElementCount().get(0);
            if (n < 0 || n > n2) {
                throw new Throwable("Invalid component " + n + " for " + string);
            }
            double[] dArray = CDFReader.this.getAvailableTimeRange(string);
            double[] dArray2 = TSExtractor.getOverlap(this.rdr, dArray, string, nArray, nArray2);
            return this._getTimeSeries(string, n, bl, dArray2);
        }

        public TimeSeries getTimeSeries(String string, int n, boolean bl, int[] nArray, int[] nArray2, TimeInstantModel timeInstantModel) throws Throwable {
            if (CDFReader.this.thisCDF.getVariable(string).getEffectiveRank() != 1) {
                throw new Throwable(string + " is not a vector.");
            }
            Integer n2 = (Integer)CDFReader.this.thisCDF.getVariable(string).getElementCount().get(0);
            if (n < 0 || n > n2) {
                throw new Throwable("Invalid component " + n + " for " + string);
            }
            double[] dArray = CDFReader.this.getAvailableTimeRange(string);
            double[] dArray2 = TSExtractor.getOverlap(this.rdr, dArray, string, nArray, nArray2);
            return this._getTimeSeries(string, n, bl, dArray2, timeInstantModel);
        }
    }

    class Scalar {
        MetaData rdr;

        Scalar() {
        }

        double[][] _getTimeSeries(String string, boolean bl, double[] dArray) throws Throwable {
            CDFReader.this.checkType(string);
            Variable variable = CDFReader.this.thisCDF.getVariable(string);
            Method method = TSExtractor.getMethod(variable, "TimeSeries", 0);
            return (double[][])method.invoke(null, this.rdr, variable, new Boolean(bl), dArray);
        }

        TimeSeries _getTimeSeries(String string, boolean bl, double[] dArray, TimeInstantModel timeInstantModel) throws Throwable {
            CDFReader.this.checkType(string);
            Variable variable = CDFReader.this.thisCDF.getVariable(string);
            Method method = TSExtractor.getMethod(variable, "TimeSeriesObject", 0);
            TimeSeries timeSeries = (TimeSeries)method.invoke(null, this.rdr, variable, new Boolean(bl), dArray, timeInstantModel);
            return new TimeSeriesImpl(timeSeries);
        }

        public double[][] getTimeSeries(String string) throws Throwable {
            Variable variable = CDFReader.this.thisCDF.getVariable(string);
            if (variable.getEffectiveRank() != 0) {
                throw new Throwable(string + " is not a scalar.");
            }
            return this._getTimeSeries(string, true, null);
        }

        public double[][] getTimeSeries(String string, int[] nArray, int[] nArray2) throws Throwable {
            if (CDFReader.this.thisCDF.getVariable(string).getEffectiveRank() != 0) {
                throw new Throwable(string + " is not a scalar.");
            }
            double[] dArray = CDFReader.this.getAvailableTimeRange(string);
            double[] dArray2 = TSExtractor.getOverlap(this.rdr, dArray, string, nArray, nArray2);
            return this._getTimeSeries(string, true, dArray2);
        }

        public TimeSeries getTimeSeries(String string, int[] nArray, int[] nArray2, TimeInstantModel timeInstantModel) throws Throwable {
            if (CDFReader.this.thisCDF.getVariable(string).getEffectiveRank() != 0) {
                throw new Throwable(string + " is not a scalar.");
            }
            double[] dArray = CDFReader.this.getAvailableTimeRange(string);
            double[] dArray2 = TSExtractor.getOverlap(this.rdr, dArray, string, nArray, nArray2);
            return this._getTimeSeries(string, true, dArray2, timeInstantModel);
        }

        public double[][] getTimeSeries(String string, boolean bl) throws Throwable {
            if (CDFReader.this.thisCDF.getVariable(string).getEffectiveRank() != 0) {
                throw new Throwable(string + " is not a scalar.");
            }
            return this._getTimeSeries(string, bl, null);
        }

        public double[][] getTimeSeries(String string, boolean bl, int[] nArray, int[] nArray2) throws Throwable {
            if (CDFReader.this.thisCDF.getVariable(string).getEffectiveRank() != 0) {
                throw new Throwable(string + " is not a scalar.");
            }
            double[] dArray = CDFReader.this.getAvailableTimeRange(string);
            double[] dArray2 = TSExtractor.getOverlap(this.rdr, dArray, string, nArray, nArray2);
            return this._getTimeSeries(string, bl, dArray2);
        }

        public TimeSeries getTimeSeries(String string, boolean bl, int[] nArray, int[] nArray2, TimeInstantModel timeInstantModel) throws Throwable {
            if (CDFReader.this.thisCDF.getVariable(string).getEffectiveRank() != 0) {
                throw new Throwable(string + " is not a scalar.");
            }
            double[] dArray = CDFReader.this.getAvailableTimeRange(string);
            double[] dArray2 = TSExtractor.getOverlap(this.rdr, dArray, string, nArray, nArray2);
            return this._getTimeSeries(string, bl, dArray2, timeInstantModel);
        }
    }

    class TimeSeriesImpl
    implements TimeSeries {
        double[] times;
        Object values;
        TimeInstantModel tspec;

        public TimeSeriesImpl(TimeSeries timeSeries) throws CDFException.ReaderError {
            this.times = timeSeries.getTimes();
            this.values = timeSeries.getValues();
            this.tspec = timeSeries.getTimeInstantModel();
        }

        @Override
        public TimeInstantModel getTimeInstantModel() {
            return this.tspec;
        }

        @Override
        public double[] getTimes() throws CDFException.ReaderError {
            return this.times;
        }

        @Override
        public Object getValues() throws CDFException.ReaderError {
            return this.values;
        }
    }

    class TimeSeriesOneDImpl
    extends TimeSeriesImpl
    implements TimeSeriesOneD {
        boolean columnMajor;

        TimeSeriesOneDImpl(TimeSeriesX timeSeriesX) throws CDFException.ReaderError {
            super(timeSeriesX);
            if (!timeSeriesX.isOneD()) {
                throw new CDFException.ReaderError("Not 1D timeseries.");
            }
            this.columnMajor = timeSeriesX.isColumnMajor();
        }

        @Override
        public double[] getValues() throws CDFException.ReaderError {
            return (double[])this.values;
        }

        public double[] getValuesOneD() throws CDFException.ReaderError {
            return (double[])this.values;
        }

        @Override
        public boolean isColumnMajor() {
            return this.columnMajor;
        }
    }
}

