/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.gsfc.spdf.cdfj;

import gov.nasa.gsfc.spdf.cdfj.CDF3;
import gov.nasa.gsfc.spdf.cdfj.CDFImpl;
import gov.nasa.gsfc.spdf.cdfj.DataTypes;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.channels.FileChannel;

final class CDF3Impl
extends CDFImpl
implements CDF3,
Serializable {
    public long GDROffset;
    FileChannel fc;

    protected CDF3Impl(ByteBuffer byteBuffer, FileChannel fileChannel) throws Throwable {
        super(byteBuffer);
        this.fc = fileChannel;
        this.setOffsets();
        this.thisCDF = this;
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        ByteBuffer byteBuffer2 = super.getRecord(0L);
        intBuffer.position(2);
        intBuffer.get();
        intBuffer.get();
        intBuffer.get();
        this.GDROffset = intBuffer.get();
        this.GDROffset = (this.GDROffset << 32) + (long)intBuffer.get();
        this.version = intBuffer.get();
        if (this.version != 3) {
            throw new Throwable("Version " + this.version + "is not accepted by this reader.");
        }
        this.release = intBuffer.get();
        this.encoding = intBuffer.get();
        this.byteOrder = DataTypes.getByteOrder(this.encoding);
        this.setByteOrder(this.byteOrder);
        this.flags = intBuffer.get();
        intBuffer.get();
        intBuffer.get();
        this.increment = intBuffer.get();
        int n = (int)this.GDROffset + 8;
        byteBuffer.position(n);
        int n2 = byteBuffer.getInt();
        if (n2 != 2) {
            throw new Throwable("Bad GDR type " + n2);
        }
        this.rVDRHead = byteBuffer.getLong();
        this.zVDRHead = byteBuffer.getLong();
        this.ADRHead = byteBuffer.getLong();
        long l = byteBuffer.getLong();
        this.numberOfRVariables = byteBuffer.getInt();
        this.numberOfAttributes = byteBuffer.getInt();
        byteBuffer.getInt();
        int n3 = byteBuffer.getInt();
        this.numberOfZVariables = byteBuffer.getInt();
        byteBuffer.getInt();
        byteBuffer.getInt();
        byteBuffer.getInt();
        this.lastLeapSecondId = byteBuffer.getInt();
        this.rDimSizes = new int[n3];
        if (n3 > 0) {
            byteBuffer.getInt();
            for (int i = 0; i < this.rDimSizes.length; ++i) {
                this.rDimSizes[i] = byteBuffer.getInt();
            }
        }
        byteBuffer.position(0);
        this.variableTable = this.variables();
        this.attributeTable = this.attributes();
    }

    protected CDF3Impl(ByteBuffer byteBuffer) throws Throwable {
        this(byteBuffer, null);
    }

    void setOffsets() {
        this.offset_NEXT_VDR = 12;
        this.offset_NEXT_ADR = 12;
        this.offset_ATTR_NAME = 68;
        this.offset_SCOPE = 28;
        this.offset_AgrEDRHead = 20;
        this.offset_AzEDRHead = 48;
        this.offset_NEXT_AEDR = 12;
        this.offset_ENTRYNUM = 28;
        this.offset_ATTR_DATATYPE = 24;
        this.offset_ATTR_NUM_ELEMENTS = 32;
        this.offset_VALUE = 56;
        this.offset_VAR_NAME = 84;
        this.offset_VAR_NUM_ELEMENTS = 64;
        this.offset_NUM = 68;
        this.offset_FLAGS = 44;
        this.offset_sRecords = 48;
        this.offset_BLOCKING_FACTOR = 80;
        this.offset_VAR_DATATYPE = 20;
        this.offset_zNumDims = 340;
        this.offset_FIRST_VXR = 28;
        this.offset_NEXT_VXR = 12;
        this.offset_NENTRIES = 20;
        this.offset_NUSED = 24;
        this.offset_FIRST = 28;
        this.offset_RECORD_TYPE = 8;
        this.offset_RECORDS = 12;
        this.offset_CSIZE = 16;
        this.offset_CDATA = 24;
    }

    @Override
    public String getString(long l) {
        ByteBuffer byteBuffer;
        if (this.fc == null) {
            return this.getString(l, 256);
        }
        try {
            byteBuffer = this.getRecord(l, 256);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
        return this.getString(byteBuffer, 256);
    }

    @Override
    public int lowOrderInt(ByteBuffer byteBuffer) {
        return (int)byteBuffer.getLong();
    }

    @Override
    public int lowOrderInt(ByteBuffer byteBuffer, int n) {
        return (int)byteBuffer.getLong(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ByteBuffer getRecord(long l) {
        if (this.fc == null) {
            return super.getRecord(l);
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        FileChannel fileChannel = this.fc;
        synchronized (fileChannel) {
            try {
                this.fc.position(l + 4L);
                this.fc.read(byteBuffer);
                int n = byteBuffer.getInt(0);
                return this.getRecord(l, n);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                return null;
            }
        }
    }

    protected ByteBuffer getRecord(long l, int n) throws Throwable {
        ByteBuffer byteBuffer = ByteBuffer.allocate(n);
        this.fc.position(l);
        int n2 = this.fc.read(byteBuffer);
        if (n2 != n) {
            System.out.println("Needed " + n + " bytes. Got " + n2);
            return null;
        }
        byteBuffer.position(0);
        return byteBuffer;
    }

    @Override
    public long longInt(ByteBuffer byteBuffer) {
        return byteBuffer.getLong();
    }
}

