#if !defined(CDFFITS_INCLUDEd__)
#define CDFFITS_INCLUDEd__

#include "cdf.h" 
#include "fitsio.h"

#define Nl      '\n'            /* Newline. */
#define NUL     '\0'            /* Null character. */

#define DU_MAX_PATH_LEN         255
#define DU_MAX_DIR_LEN          255
#define DU_MAX_NAME_LEN         127

#define BOO(b,t,f) (b ? t : f)
#define EofS(string) &string[strlen(string)]

/*****************************************************************************
* Minimum/Maximum macros.
*****************************************************************************/

#if !defined(MINIMUM)
#  define MINIMUM(a,b) ((a) < (b) ? (a) : (b))
#endif

#if !defined(MAXIMUM)
#  define MAXIMUM(a,b) ((a) > (b) ? (a) : (b))
#endif

#define MINIMUMof3(a,b,c) (MINIMUM(a,MINIMUM(b,c)))
#define MAXIMUMof3(a,b,c) (MAXIMUM(a,MAXIMUM(b,c)))

/******************************************************************************
* Typedefs.
******************************************************************************/

typedef int Logical;

typedef unsigned short uShort;
typedef unsigned int uInt;
typedef unsigned long uLong;

#if defined(alphaosf) || defined(IRIX64bit)
   /***************************************************************************
   * `long' is 64 bits on a DEC Alpha/OSF1 and an SGi/IRIX 6.x using the `-64'
   * option (64-bit objects).  `int' is 32 bits in these cases.
   ***************************************************************************/
   typedef int Int32;
   typedef uInt uInt32;
#else
   typedef long Int32;
   typedef uLong uInt32;
#endif

typedef short Int16;
typedef uShort uInt16;

#if defined(AIX) || defined(dos) || defined(sgi) || defined(__QNX__)
   /***************************************************************************
   * `char' is unsigned by default under AIX, MS-DOS, IRIX, and QNX...
   ***************************************************************************/
   typedef signed char sChar;
#else
   /***************************************************************************
   * ...and signed by default everywhere else.
   ***************************************************************************/
   typedef char sChar;
#endif

typedef unsigned char uChar;

#if !defined(mac)
  /****************************************************************************
  * `Byte' is already defined in `types.h' on a Macintosh (MPW C & Think C).
  ****************************************************************************/
  typedef uChar Byte;
#endif

typedef uChar uByte;
typedef sChar sByte;

/*****************************************************************************
* TRUE/FALSE (for where they don't exist).
*****************************************************************************/

#if !defined(TRUE)
#  define TRUE 1
#endif

#if !defined(FALSE)
#  define FALSE 0
#endif

#define LogicalTRUE     ((Logical) TRUE)
#define LogicalFALSE    ((Logical) FALSE)

/*****************************************************************************
* Exit macros.
*****************************************************************************/

#if defined(vms)
#  define EXIT_SUCCESS_ SS$_NORMAL
#  define EXIT_FAILURE_ SS$_ABORT
#else
#  define EXIT_SUCCESS_ 0
#  define EXIT_FAILURE_ 1
#endif

#define Exit exit(EXIT_SUCCESS_)
#define ExitBAD exit(EXIT_FAILURE_)

/*****************************************************************************
* Matching constants.
*****************************************************************************/

#define NOMATCH                 (-1)
#define MATCHES                 (-2)

#define MAX_MESSAGE_TEXT_LEN            80
/*****************************************************************************
* QOP constants.
*****************************************************************************/

#define QOP_MAX_ARGVs   40
#define QOP_MAX_PARMs   40
#define QOP_MAX_QUALs   30

/*****************************************************************************
* QOP structure.
*****************************************************************************/

typedef struct QOPstruct {
int Nparms;
char *parms[QOP_MAX_PARMs];
int qualEntered[QOP_MAX_QUALs];
char *qualOpt[QOP_MAX_QUALs];
} QOP;

/******************************************************************************
* QOP constants.
******************************************************************************/

#define CDFPATHparm             0

#define HELPqual                0
#define DELETEqual              1
#define DEFAULTdelete           FALSE
#define NOHEADERqual            2
#define DEFAULTnoheader         FALSE
#define SHOWqual                3
#define MAPqual                 4
#define DEBUGqual               5
#define DRYRUNqual              6
#define DEFAULTdryrun           FALSE
#define MULTIqual               7
#define DEFAULTmulti		FALSE

/******************************************************************************
* Global variables.
******************************************************************************/

#if defined(mac)
#  define MAX_LINES_WHEN_PAGING         24
#else
#  define MAX_LINES_WHEN_PAGING         22
#endif

#define MAX_PROGRAM_NAME_LEN            25

/******************************************************************************
* Format specifiers.
******************************************************************************/

#if defined(alphaosf) || defined(IRIX64bit) || defined(_LP64) || \
    defined(__amd64) || defined(__x86_64__) || defined(__ia64__) || \
    defined(__PPC64__) || defined(__ppc64__)
#  define Int32FORMAT   "%d"
#  define Int64FORMAT   "%lld"
#  define Int32uFORMAT  "%u"
#  define Int32FORMATmod        ""
#  define Int64FORMATmod        "ll"
#  define Int32hexFORMAT        "0x%08X"
#else
#  define Int32FORMAT   "%ld"
#  if defined(win32) || defined(__MINGW32__)
#    define Int64FORMAT   "%I64d"
#  else
#    define Int64FORMAT   "%lld"
#  endif
#  define Int32uFORMAT  "%lu"
#  define Int32FORMATmod        "l"
#  define Int64FORMATmod        "ll"
#  define Int32hexFORMAT        "0x%08lX"
#  define Int64hexFORMAT        "0x%016llX"
#endif

#define IMAGE 1
#define BINTABLE 2
#define TABLE  3
#define PRIMARY  1
#define XTENSION  2


#if defined(CDFFITS)

QOP *Qop(int, char *[], char *[], int *);
void QuitCDF(char *, CDFstatus);
void QuitX(char *, char *);
void QuitFITS(char *, char *);
CDFid OpenCDF(char *);
void CloseCDF(CDFid);
void GetCDFInfo (CDFid, long *, long *, long *, long *, long *, long *);
void GetGlobalAttributeNumbers (CDFid, long, long *);
void GetGlobalAttributeInfo (CDFid, long, char *, long *, long *);
CDFstatus GetGlobalAttributeEntryInfo (CDFid, long, long, long *, long *);
void GetGlobalAttributeEntryData (CDFid, long, long, void *);
void GetGlobalAttributeEntries (CDFid, long, long, long *, long *, 
                                long *, void **);
void GetVarInfo (CDFid, long, char *, long *, long *, long *, long *,
                 long *, long *);
int GetVarsRecordNumbers (CDFid, char **, long *, long *, int *);
void GetVarAttributes (CDFid, long, long *, char **);
void GetVarAttributeInfo (CDFid, long, long, long *, long *);
CDFstatus GetVarPadValaue (CDFid, long, void *);
CDFstatus GetVarAttributeEntryInfo (CDFid, long, long, long *, long *);
void GetVarAttributeEntryData (CDFid, long, long, void *);
void GetVarRecordData(CDFid, long, long, long, long, long *, 
                      void *);
char *DataTypeToken (long);
void FatalError PROTOARGs((char *message));
Logical TFqualifier PROTOARGs((
  QOP *qop, Logical *variable, int Tx, int Fx, Logical defaultTF,
  char *conflictText
));
void DisplayError PROTOARGs((char *message));
int FindUniqueMatch PROTOARGs((char *target, char *strings[]));
int WriteOut PROTOARGs((FILE *, char *));
void WriteStringStdOut (char *, size_t);
int strncmpIgCase (char *, char *, size_t);
void ReadCharStdIn PROTOARGs((char *key));

void ParseKeyword(char *, long, char *, char *, char *, int *, int *, int *,
                  char *, void *);
void DumpAttributeEntry(long, long, void *);
void DumpFITSCard(char *, char *, char *, int, int, void *, char *);
void PrintFITSerror(int, char *);
int  ConvertCDFDataType(long);
void FirstPass(CDFid, long, long, int *, int *, int *, int *, int *, long *,
               long *, long *, int *, char **, char **, char **, char *);
int  GetFITSdataType(char *);

#endif

#endif
