"""
#######################################################################

CCPN Data Model version 2.1.2

Autogenerated by PyXmlMapWrite revision 1.29 on Mon Mar  2 17:24:13 2015
  from data model element utrecht.Haddock revision ?

#######################################################################
======================COPYRIGHT/LICENSE START==========================

Haddock.py: python XML-I/O-mapping for CCPN data model, MetaPackage utrecht.Haddock

Copyright (C) 2007  (CCPN Project)

=======================================================================

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
A copy of this license can be found in ../../../license/LGPL.license
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
Lesser General Public License for more details.
 
You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA


======================COPYRIGHT/LICENSE END============================

for further information, please contact :

- CCPN website (http://www.ccpn.ac.uk/)

- email: ccpn@bioc.cam.ac.uk

=======================================================================

If you are using this software for academic purposes, we suggest
quoting the following references:

===========================REFERENCE START=============================
Rasmus H. Fogh, Wayne Boucher, Wim F. Vranken, Anne
Pajon, Tim J. Stevens, T.N. Bhat, John Westbrook, John M.C. Ionides and
Ernest D. Laue (2005). A framework for scientific data modeling and automated
software development. Bioinformatics 21, 1678-1684.


This file was generated with the Memops software generation framework,
and contains original contributions embedded in the framework

===========================REFERENCE END===============================
"""
from memops.general.Constants import baseDataTypeModule as basicDataTypes
# 
#  Current package api
import utrecht.api.Haddock

def makeMapping(globalMap):
  """
  generates XML I/O mapping for package HADD, adding it to globalMap
  """
  
  from memops.xml.Implementation import bool2str, str2bool

  # Set up top level dictionaries
  loadMaps = globalMap.get('loadMaps')
  mapsByGuid = globalMap.get('mapsByGuid')

  abstractTypes = globalMap.get('HADD').get('abstractTypes')
  exolinks = globalMap.get('HADD').get('exolinks')

  # DataType DielectricType
  currentMap = {}
  abstractTypes['DielectricType'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-02-19-14:00:58_00001'] = currentMap
  loadMaps['HADD.DielectricType'] = currentMap
  currentMap['tag'] = 'HADD.DielectricType'
  currentMap['type'] = 'simple'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-02-19-14:00:58_00001'
  currentMap['toStr'] = 'text'
  currentMap['cnvrt'] = 'text'

  # DataType ForceFieldCode
  currentMap = {}
  abstractTypes['ForceFieldCode'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-02-18-17:38:39_00004'] = currentMap
  loadMaps['HADD.ForceFieldCode'] = currentMap
  currentMap['tag'] = 'HADD.ForceFieldCode'
  currentMap['type'] = 'simple'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-02-18-17:38:39_00004'
  currentMap['toStr'] = 'text'
  currentMap['cnvrt'] = 'text'

  # DataType HaddockInteraction
  currentMap = {}
  abstractTypes['HaddockInteraction'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-02-27-16:13:11_00003'] = currentMap
  loadMaps['HADD.HaddockInteraction'] = currentMap
  currentMap['tag'] = 'HADD.HaddockInteraction'
  currentMap['type'] = 'simple'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-02-27-16:13:11_00003'
  currentMap['toStr'] = 'text'
  currentMap['cnvrt'] = 'text'

  # DataType NonBondedType
  currentMap = {}
  abstractTypes['NonBondedType'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2007-11-21-18:19:25_00001'] = currentMap
  loadMaps['HADD.NonBondedType'] = currentMap
  currentMap['tag'] = 'HADD.NonBondedType'
  currentMap['type'] = 'simple'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2007-11-21-18:19:25_00001'
  currentMap['toStr'] = 'text'
  currentMap['cnvrt'] = 'text'

  # DataType ResidueFlexibility
  currentMap = {}
  abstractTypes['ResidueFlexibility'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-02-18-17:38:39_00003'] = currentMap
  loadMaps['HADD.ResidueFlexibility'] = currentMap
  currentMap['tag'] = 'HADD.ResidueFlexibility'
  currentMap['type'] = 'simple'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-02-18-17:38:39_00003'
  currentMap['toStr'] = 'text'
  currentMap['cnvrt'] = 'text'

  # DataType ScoringTerm
  currentMap = {}
  abstractTypes['ScoringTerm'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-02-19-14:00:58_00003'] = currentMap
  loadMaps['HADD.ScoringTerm'] = currentMap
  currentMap['tag'] = 'HADD.ScoringTerm'
  currentMap['type'] = 'simple'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-02-19-14:00:58_00003'
  currentMap['toStr'] = 'text'
  currentMap['cnvrt'] = 'text'

  # DataType SemiFlexMode
  currentMap = {}
  abstractTypes['SemiFlexMode'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2009-02-20-13:11:56_00001'] = currentMap
  loadMaps['HADD.SemiFlexMode'] = currentMap
  currentMap['tag'] = 'HADD.SemiFlexMode'
  currentMap['type'] = 'simple'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2009-02-20-13:11:56_00001'
  currentMap['toStr'] = 'text'
  currentMap['cnvrt'] = 'text'

  # DataType Solvent
  currentMap = {}
  abstractTypes['Solvent'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2007-11-21-18:19:25_00003'] = currentMap
  loadMaps['HADD.Solvent'] = currentMap
  currentMap['tag'] = 'HADD.Solvent'
  currentMap['type'] = 'simple'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2007-11-21-18:19:25_00003'
  currentMap['toStr'] = 'text'
  currentMap['cnvrt'] = 'text'

  # Class Chain
  currentMap = {}
  abstractTypes['Chain'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-02-27-16:13:11_00001'] = currentMap
  loadMaps['HADD.Chain'] = currentMap
  currentMap['tag'] = 'HADD.Chain'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-02-27-16:13:11_00001'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'chains'
  currentMap['objkey'] = 'chain'
  currentMap['class'] = utrecht.api.Haddock.Chain
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute Chain.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Role Chain.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role Chain.chain
  currentMap = {}
  contentMap['chain'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-02-27-16:15:25_00001'] = currentMap
  loadMaps['HADD.Chain.chain'] = currentMap
  currentMap['tag'] = 'HADD.Chain.chain'
  currentMap['type'] = 'exolink'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-02-27-16:15:25_00001'
  currentMap['name'] = 'chain'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['eType'] = 'cplx'
  currentMap['copyOverride'] = True
  currentMap['content'] = globalMap.get('MOLS').get('exolinks')

  # Role Chain.residues
  currentMap = {}
  contentMap['residues'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-02-27-16:15:25_00003'] = currentMap
  loadMaps['HADD.Chain.residues'] = currentMap
  currentMap['tag'] = 'HADD.Chain.residues'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-02-27-16:15:25_00003'
  currentMap['name'] = 'residues'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('HADD').get('abstractTypes')
  # End of Chain

  currentMap = abstractTypes.get('Chain')
  aList = ['residues', 'chain', 'access', 'applicationData']
  currentMap['cplxAttrs'] = aList
  aList = ['residues']
  currentMap['children'] = aList

  # Class EnergyTermParameter
  currentMap = {}
  abstractTypes['EnergyTermParameter'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-02-20-14:31:17_00001'] = currentMap
  loadMaps['HADD.EnergyTermParameter'] = currentMap
  currentMap['tag'] = 'HADD.EnergyTermParameter'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-02-20-14:31:17_00001'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'energyTermParameters'
  currentMap['objkey'] = 'code'
  currentMap['class'] = utrecht.api.Haddock.EnergyTermParameter
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute EnergyTermParameter.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute EnergyTermParameter.code
  currentMap = {}
  contentMap['code'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-02-20-14:31:19_00007'] = currentMap
  loadMaps['HADD.EnergyTermParameter.code'] = currentMap
  currentMap['tag'] = 'HADD.EnergyTermParameter.code'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-02-20-14:31:19_00007'
  currentMap['name'] = 'code'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00033')

  # Attribute EnergyTermParameter.value
  currentMap = {}
  contentMap['value'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-02-20-14:31:19_00008'] = currentMap
  loadMaps['HADD.EnergyTermParameter.value'] = currentMap
  currentMap['tag'] = 'HADD.EnergyTermParameter.value'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-02-20-14:31:19_00008'
  currentMap['name'] = 'value'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00031')

  # Role EnergyTermParameter.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')
  # End of EnergyTermParameter

  currentMap = abstractTypes.get('EnergyTermParameter')
  aList = ['value']
  currentMap['headerAttrs'] = aList
  aList = ['code']
  currentMap['simpleAttrs'] = aList
  aList = ['access', 'applicationData']
  currentMap['cplxAttrs'] = aList

  # Class HaddockEnergyTerm
  currentMap = {}
  abstractTypes['HaddockEnergyTerm'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-10-11-22:58:43_00006'] = currentMap
  loadMaps['HADD.HaddockEnergyTerm'] = currentMap
  currentMap['tag'] = 'HADD.HaddockEnergyTerm'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-10-11-22:58:43_00006'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'haddockEnergyTerms'
  currentMap['class'] = utrecht.api.Haddock.HaddockEnergyTerm
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute HaddockEnergyTerm.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute HaddockEnergyTerm.code
  currentMap = {}
  contentMap['code'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-02-20-14:31:19_00005'] = currentMap
  loadMaps['HADD.HaddockEnergyTerm.code'] = currentMap
  currentMap['tag'] = 'HADD.HaddockEnergyTerm.code'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-02-20-14:31:19_00005'
  currentMap['name'] = 'code'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00033')

  # Attribute HaddockEnergyTerm.details
  currentMap = {}
  contentMap['details'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-02-20-15:13:04_00001'] = currentMap
  loadMaps['HADD.HaddockEnergyTerm.details'] = currentMap
  currentMap['tag'] = 'HADD.HaddockEnergyTerm.details'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-02-20-15:13:04_00001'
  currentMap['name'] = 'details'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00036')

  # Attribute HaddockEnergyTerm.fileName
  currentMap = {}
  contentMap['fileName'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-10-24-11:31:02_00003'] = currentMap
  loadMaps['HADD.HaddockEnergyTerm.fileName'] = currentMap
  currentMap['tag'] = 'HADD.HaddockEnergyTerm.fileName'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-10-24-11:31:02_00003'
  currentMap['name'] = 'fileName'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:54_00003')

  # Attribute HaddockEnergyTerm.name
  currentMap = {}
  contentMap['name'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-10-11-23:09:09_00009'] = currentMap
  loadMaps['HADD.HaddockEnergyTerm.name'] = currentMap
  currentMap['tag'] = 'HADD.HaddockEnergyTerm.name'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-10-11-23:09:09_00009'
  currentMap['name'] = 'name'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00033')

  # Attribute HaddockEnergyTerm.termId
  currentMap = {}
  contentMap['termId'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-02-20-14:31:19_00006'] = currentMap
  loadMaps['HADD.HaddockEnergyTerm.termId'] = currentMap
  currentMap['tag'] = 'HADD.HaddockEnergyTerm.termId'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-02-20-14:31:19_00006'
  currentMap['name'] = 'termId'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:54_00001')

  # Role HaddockEnergyTerm.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role HaddockEnergyTerm.constraintList
  currentMap = {}
  contentMap['constraintList'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-10-11-23:09:09_00005'] = currentMap
  loadMaps['HADD.HaddockEnergyTerm.constraintList'] = currentMap
  currentMap['tag'] = 'HADD.HaddockEnergyTerm.constraintList'
  currentMap['type'] = 'exolink'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-10-11-23:09:09_00005'
  currentMap['name'] = 'constraintList'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['copyOverride'] = True
  currentMap['content'] = globalMap.get('NMRC').get('exolinks')

  # Role HaddockEnergyTerm.energyTerm
  currentMap = {}
  contentMap['energyTerm'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-02-20-14:31:19_00002'] = currentMap
  loadMaps['HADD.HaddockEnergyTerm.energyTerm'] = currentMap
  currentMap['tag'] = 'HADD.HaddockEnergyTerm.energyTerm'
  currentMap['type'] = 'exolink'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-02-20-14:31:19_00002'
  currentMap['name'] = 'energyTerm'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['copyOverride'] = True
  currentMap['content'] = globalMap.get('ANPR').get('exolinks')

  # Role HaddockEnergyTerm.energyTermParameters
  currentMap = {}
  contentMap['energyTermParameters'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-02-20-14:31:19_00004'] = currentMap
  loadMaps['HADD.HaddockEnergyTerm.energyTermParameters'] = currentMap
  currentMap['tag'] = 'HADD.HaddockEnergyTerm.energyTermParameters'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-02-20-14:31:19_00004'
  currentMap['name'] = 'energyTermParameters'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('HADD').get('abstractTypes')
  # End of HaddockEnergyTerm

  currentMap = abstractTypes.get('HaddockEnergyTerm')
  aList = ['termId']
  currentMap['headerAttrs'] = aList
  aList = ['code', 'details', 'fileName', 'name']
  currentMap['simpleAttrs'] = aList
  aList = ['energyTermParameters', 'energyTerm', 'constraintList', 'access', 'applicationData']
  currentMap['cplxAttrs'] = aList
  aList = ['energyTermParameters']
  currentMap['children'] = aList

  # Class HaddockPartner
  currentMap = {}
  abstractTypes['HaddockPartner'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-10-11-22:58:43_00004'] = currentMap
  loadMaps['HADD.HaddockPartner'] = currentMap
  currentMap['tag'] = 'HADD.HaddockPartner'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-10-11-22:58:43_00004'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'haddockPartners'
  currentMap['objkey'] = 'code'
  currentMap['class'] = utrecht.api.Haddock.HaddockPartner
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute HaddockPartner.airUpperDistanceLimit
  currentMap = {}
  contentMap['airUpperDistanceLimit'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2009-02-20-13:12:00_00001'] = currentMap
  loadMaps['HADD.HaddockPartner.airUpperDistanceLimit'] = currentMap
  currentMap['tag'] = 'HADD.HaddockPartner.airUpperDistanceLimit'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2009-02-20-13:12:00_00001'
  currentMap['name'] = 'airUpperDistanceLimit'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = 2.0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:54_00009')

  # Attribute HaddockPartner.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute HaddockPartner.autoHistidinePstate
  currentMap = {}
  contentMap['autoHistidinePstate'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-02-18-17:40:19_00008'] = currentMap
  loadMaps['HADD.HaddockPartner.autoHistidinePstate'] = currentMap
  currentMap['tag'] = 'HADD.HaddockPartner.autoHistidinePstate'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-02-18-17:40:19_00008'
  currentMap['name'] = 'autoHistidinePstate'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = True
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00028')

  # Attribute HaddockPartner.code
  currentMap = {}
  contentMap['code'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-10-11-22:59:43_00014'] = currentMap
  loadMaps['HADD.HaddockPartner.code'] = currentMap
  currentMap['tag'] = 'HADD.HaddockPartner.code'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-10-11-22:59:43_00014'
  currentMap['name'] = 'code'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00037')

  # Attribute HaddockPartner.fileNames
  currentMap = {}
  contentMap['fileNames'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-02-19-14:01:01_00002'] = currentMap
  loadMaps['HADD.HaddockPartner.fileNames'] = currentMap
  currentMap['tag'] = 'HADD.HaddockPartner.fileNames'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-02-19-14:01:01_00002'
  currentMap['name'] = 'fileNames'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:54_00003')

  # Attribute HaddockPartner.forceFieldCode
  currentMap = {}
  contentMap['forceFieldCode'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-02-18-17:40:19_00009'] = currentMap
  loadMaps['HADD.HaddockPartner.forceFieldCode'] = currentMap
  currentMap['tag'] = 'HADD.HaddockPartner.forceFieldCode'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-02-18-17:40:19_00009'
  currentMap['name'] = 'forceFieldCode'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = 'TOPALLHDG'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-02-18-17:38:39_00004')

  # Attribute HaddockPartner.isDna
  currentMap = {}
  contentMap['isDna'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2007-11-21-18:19:27_00002'] = currentMap
  loadMaps['HADD.HaddockPartner.isDna'] = currentMap
  currentMap['tag'] = 'HADD.HaddockPartner.isDna'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2007-11-21-18:19:27_00002'
  currentMap['name'] = 'isDna'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = False
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00028')

  # Attribute HaddockPartner.semiFlexMode
  currentMap = {}
  contentMap['semiFlexMode'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2009-02-20-13:12:00_00002'] = currentMap
  loadMaps['HADD.HaddockPartner.semiFlexMode'] = currentMap
  currentMap['tag'] = 'HADD.HaddockPartner.semiFlexMode'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2009-02-20-13:12:00_00002'
  currentMap['name'] = 'semiFlexMode'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = 'automatic'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2009-02-20-13:11:56_00001')

  # Role HaddockPartner.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role HaddockPartner.chains
  currentMap = {}
  contentMap['chains'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-02-27-16:15:25_00005'] = currentMap
  loadMaps['HADD.HaddockPartner.chains'] = currentMap
  currentMap['tag'] = 'HADD.HaddockPartner.chains'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-02-27-16:15:25_00005'
  currentMap['name'] = 'chains'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('HADD').get('abstractTypes')

  # Role HaddockPartner.molSystem
  currentMap = {}
  contentMap['molSystem'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-10-11-22:59:43_00010'] = currentMap
  loadMaps['HADD.HaddockPartner.molSystem'] = currentMap
  currentMap['tag'] = 'HADD.HaddockPartner.molSystem'
  currentMap['type'] = 'exotop'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-10-11-22:59:43_00010'
  currentMap['name'] = 'molSystem'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['eType'] = 'cplx'
  currentMap['copyOverride'] = True
  currentMap['content'] = globalMap.get('MOLS').get('exolinks')

  # Role HaddockPartner.structureEnsemble
  currentMap = {}
  contentMap['structureEnsemble'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-02-19-14:01:01_00001'] = currentMap
  loadMaps['HADD.HaddockPartner.structureEnsemble'] = currentMap
  currentMap['tag'] = 'HADD.HaddockPartner.structureEnsemble'
  currentMap['type'] = 'exotop'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-02-19-14:01:01_00001'
  currentMap['name'] = 'structureEnsemble'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['copyOverride'] = True
  currentMap['content'] = globalMap.get('COOR').get('exolinks')
  # End of HaddockPartner

  currentMap = abstractTypes.get('HaddockPartner')
  aList = ['airUpperDistanceLimit', 'autoHistidinePstate', 'code', 'forceFieldCode', 'isDna', 'semiFlexMode']
  currentMap['headerAttrs'] = aList
  aList = ['fileNames']
  currentMap['simpleAttrs'] = aList
  aList = ['chains', 'structureEnsemble', 'molSystem', 'access', 'applicationData']
  currentMap['cplxAttrs'] = aList
  aList = ['chains']
  currentMap['children'] = aList

  # Class HaddockProject
  currentMap = {}
  abstractTypes['HaddockProject'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-10-11-22:58:43_00003'] = currentMap
  loadMaps['HADD.HaddockProject'] = currentMap
  currentMap['tag'] = 'HADD.HaddockProject'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-10-11-22:58:43_00003'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'haddockProjects'
  currentMap['isTop'] = True
  currentMap['objkey'] = 'name'
  currentMap['class'] = utrecht.api.Haddock.HaddockProject
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute HaddockProject.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute HaddockProject.createdBy
  contentMap['createdBy'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:00:59_00002__www.ccpn.ac.uk_Fogh_2007-10-03-14:53:27_00001__www.ccpn.ac.uk_Fogh_2006-09-14-16:28:57_00002')

  # Attribute HaddockProject.guid
  contentMap['guid'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:26_00002')

  # Attribute HaddockProject.isModifiable
  contentMap['isModifiable'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-17-14:16:26_00010__www.ccpn.ac.uk_Fogh_2007-10-03-14:53:27_00001__www.ccpn.ac.uk_Fogh_2006-09-14-16:28:57_00002')

  # Attribute HaddockProject.lastUnlockedBy
  contentMap['lastUnlockedBy'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:00:59_00003__www.ccpn.ac.uk_Fogh_2007-10-03-14:53:27_00001__www.ccpn.ac.uk_Fogh_2006-09-14-16:28:57_00002')

  # Attribute HaddockProject.name
  currentMap = {}
  contentMap['name'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-10-11-22:59:43_00008'] = currentMap
  loadMaps['HADD.HaddockProject.name'] = currentMap
  currentMap['tag'] = 'HADD.HaddockProject.name'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-10-11-22:59:43_00008'
  currentMap['name'] = 'name'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00033')

  # Attribute HaddockProject.workingDir
  currentMap = {}
  contentMap['workingDir'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-10-11-22:59:43_00009'] = currentMap
  loadMaps['HADD.HaddockProject.workingDir'] = currentMap
  currentMap['tag'] = 'HADD.HaddockProject.workingDir'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-10-11-22:59:43_00009'
  currentMap['name'] = 'workingDir'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['eType'] = 'cplx'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:54_00003')

  # Role HaddockProject.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role HaddockProject.haddockPartners
  currentMap = {}
  contentMap['haddockPartners'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-10-11-22:59:43_00002'] = currentMap
  loadMaps['HADD.HaddockProject.haddockPartners'] = currentMap
  currentMap['tag'] = 'HADD.HaddockProject.haddockPartners'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-10-11-22:59:43_00002'
  currentMap['name'] = 'haddockPartners'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['implSkip'] = True
  currentMap['content'] = globalMap.get('HADD').get('abstractTypes')

  # Role HaddockProject.runs
  currentMap = {}
  contentMap['runs'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-10-11-22:59:43_00007'] = currentMap
  loadMaps['HADD.HaddockProject.runs'] = currentMap
  currentMap['tag'] = 'HADD.HaddockProject.runs'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-10-11-22:59:43_00007'
  currentMap['name'] = 'runs'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['implSkip'] = True
  currentMap['content'] = globalMap.get('HADD').get('abstractTypes')
  # End of HaddockProject

  currentMap = abstractTypes.get('HaddockProject')
  aList = ['createdBy', 'guid', 'isModifiable', 'lastUnlockedBy']
  currentMap['headerAttrs'] = aList
  aList = ['name', 'workingDir']
  currentMap['simpleAttrs'] = aList
  aList = ['runs', 'haddockPartners', 'access', 'applicationData']
  currentMap['cplxAttrs'] = aList
  aList = ['haddockPartners', 'runs']
  currentMap['children'] = aList

  # Class Residue
  currentMap = {}
  abstractTypes['Residue'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-02-27-16:13:11_00002'] = currentMap
  loadMaps['HADD.Residue'] = currentMap
  currentMap['tag'] = 'HADD.Residue'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-02-27-16:13:11_00002'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'residues'
  currentMap['objkey'] = 'residue'
  currentMap['class'] = utrecht.api.Haddock.Residue
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute Residue.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute Residue.flexibility
  currentMap = {}
  contentMap['flexibility'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-02-27-16:15:25_00007'] = currentMap
  loadMaps['HADD.Residue.flexibility'] = currentMap
  currentMap['tag'] = 'HADD.Residue.flexibility'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-02-27-16:15:25_00007'
  currentMap['name'] = 'flexibility'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = 'none'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-02-18-17:38:39_00003')

  # Attribute Residue.haddockSeqId
  currentMap = {}
  contentMap['haddockSeqId'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-02-27-16:20:33_00001'] = currentMap
  loadMaps['HADD.Residue.haddockSeqId'] = currentMap
  currentMap['tag'] = 'HADD.Residue.haddockSeqId'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-02-27-16:20:33_00001'
  currentMap['name'] = 'haddockSeqId'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['proc'] = 'direct'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032')

  # Attribute Residue.interaction
  currentMap = {}
  contentMap['interaction'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-02-27-16:15:25_00008'] = currentMap
  loadMaps['HADD.Residue.interaction'] = currentMap
  currentMap['tag'] = 'HADD.Residue.interaction'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-02-27-16:15:25_00008'
  currentMap['name'] = 'interaction'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = 'none'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-02-27-16:13:11_00003')

  # Role Residue.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role Residue.residue
  currentMap = {}
  contentMap['residue'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-02-27-16:15:25_00006'] = currentMap
  loadMaps['HADD.Residue.residue'] = currentMap
  currentMap['tag'] = 'HADD.Residue.residue'
  currentMap['type'] = 'exolink'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-02-27-16:15:25_00006'
  currentMap['name'] = 'residue'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['eType'] = 'cplx'
  currentMap['copyOverride'] = True
  currentMap['content'] = globalMap.get('MOLS').get('exolinks')
  # End of Residue

  currentMap = abstractTypes.get('Residue')
  aList = ['flexibility', 'haddockSeqId', 'interaction']
  currentMap['headerAttrs'] = aList
  aList = ['residue', 'access', 'applicationData']
  currentMap['cplxAttrs'] = aList

  # Class Run
  currentMap = {}
  abstractTypes['Run'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-10-11-22:58:43_00007'] = currentMap
  loadMaps['HADD.Run'] = currentMap
  currentMap['tag'] = 'HADD.Run'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-10-11-22:58:43_00007'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'runs'
  currentMap['objkey'] = 'serial'
  currentMap['class'] = utrecht.api.Haddock.Run
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute Run.analysisClustRmsd
  currentMap = {}
  contentMap['analysisClustRmsd'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2007-11-21-18:23:17_00004'] = currentMap
  loadMaps['HADD.Run.analysisClustRmsd'] = currentMap
  currentMap['tag'] = 'HADD.Run.analysisClustRmsd'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2007-11-21-18:23:17_00004'
  currentMap['name'] = 'analysisClustRmsd'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = 7.5
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:54_00007')

  # Attribute Run.analysisClustSize
  currentMap = {}
  contentMap['analysisClustSize'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2007-11-21-18:23:17_00005'] = currentMap
  loadMaps['HADD.Run.analysisClustSize'] = currentMap
  currentMap['tag'] = 'HADD.Run.analysisClustSize'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2007-11-21-18:23:17_00005'
  currentMap['name'] = 'analysisClustSize'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = 4
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:54_00011')

  # Attribute Run.analysisDistHBond
  currentMap = {}
  contentMap['analysisDistHBond'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2007-11-21-18:23:17_00002'] = currentMap
  loadMaps['HADD.Run.analysisDistHBond'] = currentMap
  currentMap['tag'] = 'HADD.Run.analysisDistHBond'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2007-11-21-18:23:17_00002'
  currentMap['name'] = 'analysisDistHBond'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = 2.5
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:54_00007')

  # Attribute Run.analysisDistNonbond
  currentMap = {}
  contentMap['analysisDistNonbond'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2007-11-21-18:23:17_00003'] = currentMap
  loadMaps['HADD.Run.analysisDistNonbond'] = currentMap
  currentMap['tag'] = 'HADD.Run.analysisDistNonbond'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2007-11-21-18:23:17_00003'
  currentMap['name'] = 'analysisDistNonbond'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = 3.9
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:54_00007')

  # Attribute Run.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute Run.calcDesolvation
  currentMap = {}
  contentMap['calcDesolvation'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2007-11-21-18:23:17_00019'] = currentMap
  loadMaps['HADD.Run.calcDesolvation'] = currentMap
  currentMap['tag'] = 'HADD.Run.calcDesolvation'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2007-11-21-18:23:17_00019'
  currentMap['name'] = 'calcDesolvation'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = False
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00028')

  # Attribute Run.centerOfMassConstant
  currentMap = {}
  contentMap['centerOfMassConstant'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2007-11-21-18:23:17_00007'] = currentMap
  loadMaps['HADD.Run.centerOfMassConstant'] = currentMap
  currentMap['tag'] = 'HADD.Run.centerOfMassConstant'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2007-11-21-18:23:17_00007'
  currentMap['name'] = 'centerOfMassConstant'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = 1.0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:54_00009')

  # Attribute Run.centerOfMassRestraints
  currentMap = {}
  contentMap['centerOfMassRestraints'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-02-18-17:40:19_00019'] = currentMap
  loadMaps['HADD.Run.centerOfMassRestraints'] = currentMap
  currentMap['tag'] = 'HADD.Run.centerOfMassRestraints'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-02-18-17:40:19_00019'
  currentMap['name'] = 'centerOfMassRestraints'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = False
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00028')

  # Attribute Run.cnsExecutable
  currentMap = {}
  contentMap['cnsExecutable'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2009-02-20-13:12:00_00004'] = currentMap
  loadMaps['HADD.Run.cnsExecutable'] = currentMap
  currentMap['tag'] = 'HADD.Run.cnsExecutable'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2009-02-20-13:12:00_00004'
  currentMap['name'] = 'cnsExecutable'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['eType'] = 'cplx'
  currentMap['default'] = '/cns/cns_solve_1.2/binaries/cns'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:54_00003')

  # Attribute Run.cpuNumber
  currentMap = {}
  contentMap['cpuNumber'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2009-02-20-13:12:00_00006'] = currentMap
  loadMaps['HADD.Run.cpuNumber'] = currentMap
  currentMap['tag'] = 'HADD.Run.cpuNumber'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2009-02-20-13:12:00_00006'
  currentMap['name'] = 'cpuNumber'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = 10
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:54_00011')

  # Attribute Run.dielectricType
  currentMap = {}
  contentMap['dielectricType'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-02-19-14:01:01_00012'] = currentMap
  loadMaps['HADD.Run.dielectricType'] = currentMap
  currentMap['tag'] = 'HADD.Run.dielectricType'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-02-19-14:01:01_00012'
  currentMap['name'] = 'dielectricType'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = 'cdie'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-02-19-14:00:58_00001')

  # Attribute Run.doAirScaling
  currentMap = {}
  contentMap['doAirScaling'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-07-08-15:07:51_00001'] = currentMap
  loadMaps['HADD.Run.doAirScaling'] = currentMap
  currentMap['tag'] = 'HADD.Run.doAirScaling'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-07-08-15:07:51_00001'
  currentMap['name'] = 'doAirScaling'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = False
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00028')

  # Attribute Run.doIncludeDihEnergy
  currentMap = {}
  contentMap['doIncludeDihEnergy'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-02-19-14:01:01_00008'] = currentMap
  loadMaps['HADD.Run.doIncludeDihEnergy'] = currentMap
  currentMap['tag'] = 'HADD.Run.doIncludeDihEnergy'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-02-19-14:01:01_00008'
  currentMap['name'] = 'doIncludeDihEnergy'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = True
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00028')

  # Attribute Run.doRigidBodyElectrostatics
  currentMap = {}
  contentMap['doRigidBodyElectrostatics'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-02-19-14:01:01_00009'] = currentMap
  loadMaps['HADD.Run.doRigidBodyElectrostatics'] = currentMap
  currentMap['tag'] = 'HADD.Run.doRigidBodyElectrostatics'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-02-19-14:01:01_00009'
  currentMap['name'] = 'doRigidBodyElectrostatics'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = True
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00028')

  # Attribute Run.doRigidBodyWaterTrans
  currentMap = {}
  contentMap['doRigidBodyWaterTrans'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-07-08-15:07:51_00011'] = currentMap
  loadMaps['HADD.Run.doRigidBodyWaterTrans'] = currentMap
  currentMap['tag'] = 'HADD.Run.doRigidBodyWaterTrans'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-07-08-15:07:51_00011'
  currentMap['name'] = 'doRigidBodyWaterTrans'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = True
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00028')

  # Attribute Run.doRigidTranslations
  currentMap = {}
  contentMap['doRigidTranslations'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2007-11-21-18:20:26_00014'] = currentMap
  loadMaps['HADD.Run.doRigidTranslations'] = currentMap
  currentMap['tag'] = 'HADD.Run.doRigidTranslations'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2007-11-21-18:20:26_00014'
  currentMap['name'] = 'doRigidTranslations'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = True
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00028')

  # Attribute Run.doSAElectrostatics
  currentMap = {}
  contentMap['doSAElectrostatics'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-02-19-14:01:01_00010'] = currentMap
  loadMaps['HADD.Run.doSAElectrostatics'] = currentMap
  currentMap['tag'] = 'HADD.Run.doSAElectrostatics'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-02-19-14:01:01_00010'
  currentMap['name'] = 'doSAElectrostatics'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = True
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00028')

  # Attribute Run.doWaterAnalysis
  currentMap = {}
  contentMap['doWaterAnalysis'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-07-08-15:07:51_00010'] = currentMap
  loadMaps['HADD.Run.doWaterAnalysis'] = currentMap
  currentMap['tag'] = 'HADD.Run.doWaterAnalysis'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-07-08-15:07:51_00010'
  currentMap['name'] = 'doWaterAnalysis'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = False
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00028')

  # Attribute Run.doWaterDock
  currentMap = {}
  contentMap['doWaterDock'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-02-18-17:40:19_00015'] = currentMap
  loadMaps['HADD.Run.doWaterDock'] = currentMap
  currentMap['tag'] = 'HADD.Run.doWaterDock'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-02-18-17:40:19_00015'
  currentMap['name'] = 'doWaterDock'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = False
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00028')

  # Attribute Run.epsilon
  currentMap = {}
  contentMap['epsilon'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-02-19-14:01:01_00011'] = currentMap
  loadMaps['HADD.Run.epsilon'] = currentMap
  currentMap['tag'] = 'HADD.Run.epsilon'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-02-19-14:01:01_00011'
  currentMap['name'] = 'epsilon'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = 10.0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00031')

  # Attribute Run.haddockDir
  currentMap = {}
  contentMap['haddockDir'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2009-02-20-13:12:00_00003'] = currentMap
  loadMaps['HADD.Run.haddockDir'] = currentMap
  currentMap['tag'] = 'HADD.Run.haddockDir'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2009-02-20-13:12:00_00003'
  currentMap['name'] = 'haddockDir'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['eType'] = 'cplx'
  currentMap['default'] = '/home/software/haddock2.0'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:54_00003')

  # Attribute Run.initialRigidBodyMinim
  currentMap = {}
  contentMap['initialRigidBodyMinim'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-02-19-14:12:04_00002'] = currentMap
  loadMaps['HADD.Run.initialRigidBodyMinim'] = currentMap
  currentMap['tag'] = 'HADD.Run.initialRigidBodyMinim'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-02-19-14:12:04_00002'
  currentMap['name'] = 'initialRigidBodyMinim'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = True
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00028')

  # Attribute Run.nTrails
  currentMap = {}
  contentMap['nTrails'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-02-19-14:12:04_00003'] = currentMap
  loadMaps['HADD.Run.nTrails'] = currentMap
  currentMap['tag'] = 'HADD.Run.nTrails'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-02-19-14:12:04_00003'
  currentMap['name'] = 'nTrails'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = 5
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:54_00011')

  # Attribute Run.ncsRestraintConstant
  currentMap = {}
  contentMap['ncsRestraintConstant'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-02-20-18:43:39_00003'] = currentMap
  loadMaps['HADD.Run.ncsRestraintConstant'] = currentMap
  currentMap['tag'] = 'HADD.Run.ncsRestraintConstant'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-02-20-18:43:39_00003'
  currentMap['name'] = 'ncsRestraintConstant'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = 10.0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00031')

  # Attribute Run.nonBondedType
  currentMap = {}
  contentMap['nonBondedType'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-02-18-17:40:19_00010'] = currentMap
  loadMaps['HADD.Run.nonBondedType'] = currentMap
  currentMap['tag'] = 'HADD.Run.nonBondedType'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-02-18-17:40:19_00010'
  currentMap['name'] = 'nonBondedType'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = 'OPLSX'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2007-11-21-18:19:25_00001')

  # Attribute Run.numAmbRestautoAir
  currentMap = {}
  contentMap['numAmbRestautoAir'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-07-08-15:15:42_00001'] = currentMap
  loadMaps['HADD.Run.numAmbRestautoAir'] = currentMap
  currentMap['tag'] = 'HADD.Run.numAmbRestautoAir'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-07-08-15:15:42_00001'
  currentMap['name'] = 'numAmbRestautoAir'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:54_00011')

  # Attribute Run.numAnalysisStructures
  currentMap = {}
  contentMap['numAnalysisStructures'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2007-11-21-18:23:17_00001'] = currentMap
  loadMaps['HADD.Run.numAnalysisStructures'] = currentMap
  currentMap['tag'] = 'HADD.Run.numAnalysisStructures'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2007-11-21-18:23:17_00001'
  currentMap['name'] = 'numAnalysisStructures'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = 200
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:54_00011')

  # Attribute Run.numInitWaterShells
  currentMap = {}
  contentMap['numInitWaterShells'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-07-08-15:07:51_00012'] = currentMap
  loadMaps['HADD.Run.numInitWaterShells'] = currentMap
  currentMap['tag'] = 'HADD.Run.numInitWaterShells'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-07-08-15:07:51_00012'
  currentMap['name'] = 'numInitWaterShells'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:54_00011')

  # Attribute Run.numIt0Structures
  currentMap = {}
  contentMap['numIt0Structures'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-02-18-17:40:19_00011'] = currentMap
  loadMaps['HADD.Run.numIt0Structures'] = currentMap
  currentMap['tag'] = 'HADD.Run.numIt0Structures'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-02-18-17:40:19_00011'
  currentMap['name'] = 'numIt0Structures'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = 1000
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:54_00011')

  # Attribute Run.numIt1Structures
  currentMap = {}
  contentMap['numIt1Structures'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-02-18-17:40:19_00012'] = currentMap
  loadMaps['HADD.Run.numIt1Structures'] = currentMap
  currentMap['tag'] = 'HADD.Run.numIt1Structures'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-02-18-17:40:19_00012'
  currentMap['name'] = 'numIt1Structures'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = 200
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:54_00011')

  # Attribute Run.numUnambRestautoAir
  currentMap = {}
  contentMap['numUnambRestautoAir'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-07-08-15:07:51_00002'] = currentMap
  loadMaps['HADD.Run.numUnambRestautoAir'] = currentMap
  currentMap['tag'] = 'HADD.Run.numUnambRestautoAir'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-07-08-15:07:51_00002'
  currentMap['name'] = 'numUnambRestautoAir'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = 25
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:54_00011')

  # Attribute Run.numWrefStructures
  currentMap = {}
  contentMap['numWrefStructures'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-02-18-17:40:19_00013'] = currentMap
  loadMaps['HADD.Run.numWrefStructures'] = currentMap
  currentMap['tag'] = 'HADD.Run.numWrefStructures'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-02-18-17:40:19_00013'
  currentMap['name'] = 'numWrefStructures'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = 200
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:54_00011')

  # Attribute Run.queueCommand
  currentMap = {}
  contentMap['queueCommand'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2009-02-20-13:12:00_00005'] = currentMap
  loadMaps['HADD.Run.queueCommand'] = currentMap
  currentMap['tag'] = 'HADD.Run.queueCommand'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2009-02-20-13:12:00_00005'
  currentMap['name'] = 'queueCommand'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['eType'] = 'cplx'
  currentMap['default'] = 'csh'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00033')

  # Attribute Run.radomizeStartOriention
  currentMap = {}
  contentMap['radomizeStartOriention'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-02-19-14:12:04_00001'] = currentMap
  loadMaps['HADD.Run.radomizeStartOriention'] = currentMap
  currentMap['tag'] = 'HADD.Run.radomizeStartOriention'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-02-19-14:12:04_00001'
  currentMap['name'] = 'radomizeStartOriention'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = True
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00028')

  # Attribute Run.randomAmbigRestraints
  currentMap = {}
  contentMap['randomAmbigRestraints'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-02-18-17:40:19_00018'] = currentMap
  loadMaps['HADD.Run.randomAmbigRestraints'] = currentMap
  currentMap['tag'] = 'HADD.Run.randomAmbigRestraints'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-02-18-17:40:19_00018'
  currentMap['name'] = 'randomAmbigRestraints'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = False
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00028')

  # Attribute Run.randomExclParts
  currentMap = {}
  contentMap['randomExclParts'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-02-18-17:40:19_00017'] = currentMap
  loadMaps['HADD.Run.randomExclParts'] = currentMap
  currentMap['tag'] = 'HADD.Run.randomExclParts'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-02-18-17:40:19_00017'
  currentMap['name'] = 'randomExclParts'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['proc'] = 'direct'
  currentMap['default'] = 2
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032')

  # Attribute Run.randomExcludeAir
  currentMap = {}
  contentMap['randomExcludeAir'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-02-18-17:40:19_00016'] = currentMap
  loadMaps['HADD.Run.randomExcludeAir'] = currentMap
  currentMap['tag'] = 'HADD.Run.randomExcludeAir'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-02-18-17:40:19_00016'
  currentMap['name'] = 'randomExcludeAir'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = True
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00028')

  # Attribute Run.randomSeed
  currentMap = {}
  contentMap['randomSeed'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2007-11-21-18:23:16_00001'] = currentMap
  loadMaps['HADD.Run.randomSeed'] = currentMap
  currentMap['tag'] = 'HADD.Run.randomSeed'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2007-11-21-18:23:16_00001'
  currentMap['name'] = 'randomSeed'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['proc'] = 'direct'
  currentMap['default'] = 917
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032')

  # Attribute Run.removeNonPolarH
  currentMap = {}
  contentMap['removeNonPolarH'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-02-18-17:40:19_00014'] = currentMap
  loadMaps['HADD.Run.removeNonPolarH'] = currentMap
  currentMap['tag'] = 'HADD.Run.removeNonPolarH'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-02-18-17:40:19_00014'
  currentMap['name'] = 'removeNonPolarH'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = False
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00028')

  # Attribute Run.rigidbodyIMinteractScaling
  currentMap = {}
  contentMap['rigidbodyIMinteractScaling'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-02-19-14:01:01_00013'] = currentMap
  loadMaps['HADD.Run.rigidbodyIMinteractScaling'] = currentMap
  currentMap['tag'] = 'HADD.Run.rigidbodyIMinteractScaling'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-02-19-14:01:01_00013'
  currentMap['name'] = 'rigidbodyIMinteractScaling'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = 1.0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00031')

  # Attribute Run.rotate180It0
  currentMap = {}
  contentMap['rotate180It0'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2007-11-21-18:20:26_00012'] = currentMap
  loadMaps['HADD.Run.rotate180It0'] = currentMap
  currentMap['tag'] = 'HADD.Run.rotate180It0'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2007-11-21-18:20:26_00012'
  currentMap['name'] = 'rotate180It0'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = True
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00028')

  # Attribute Run.rotate180It1
  currentMap = {}
  contentMap['rotate180It1'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-02-19-14:01:01_00007'] = currentMap
  loadMaps['HADD.Run.rotate180It1'] = currentMap
  currentMap['tag'] = 'HADD.Run.rotate180It1'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-02-19-14:01:01_00007'
  currentMap['name'] = 'rotate180It1'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = False
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00028')

  # Attribute Run.serial
  currentMap = {}
  contentMap['serial'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2006-10-11-23:09:09_00016'] = currentMap
  loadMaps['HADD.Run.serial'] = currentMap
  currentMap['tag'] = 'HADD.Run.serial'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-10-11-23:09:09_00016'
  currentMap['name'] = 'serial'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032')

  # Attribute Run.skipStructures
  currentMap = {}
  contentMap['skipStructures'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2007-11-21-18:23:17_00009'] = currentMap
  loadMaps['HADD.Run.skipStructures'] = currentMap
  currentMap['tag'] = 'HADD.Run.skipStructures'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2007-11-21-18:23:17_00009'
  currentMap['name'] = 'skipStructures'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:54_00011')

  # Attribute Run.solvent
  currentMap = {}
  contentMap['solvent'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2007-11-21-18:23:17_00012'] = currentMap
  loadMaps['HADD.Run.solvent'] = currentMap
  currentMap['tag'] = 'HADD.Run.solvent'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2007-11-21-18:23:17_00012'
  currentMap['name'] = 'solvent'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = 'water'
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2007-11-21-18:19:25_00003')

  # Attribute Run.surfaceContactConstant
  currentMap = {}
  contentMap['surfaceContactConstant'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2007-11-21-18:23:17_00008'] = currentMap
  loadMaps['HADD.Run.surfaceContactConstant'] = currentMap
  currentMap['tag'] = 'HADD.Run.surfaceContactConstant'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2007-11-21-18:23:17_00008'
  currentMap['name'] = 'surfaceContactConstant'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = 1.0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:54_00009')

  # Attribute Run.surfaceContactRestraints
  currentMap = {}
  contentMap['surfaceContactRestraints'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-02-18-17:40:19_00020'] = currentMap
  loadMaps['HADD.Run.surfaceContactRestraints'] = currentMap
  currentMap['tag'] = 'HADD.Run.surfaceContactRestraints'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-02-18-17:40:19_00020'
  currentMap['name'] = 'surfaceContactRestraints'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = False
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00028')

  # Attribute Run.symmetryRestraintConstant
  currentMap = {}
  contentMap['symmetryRestraintConstant'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-02-20-18:43:39_00004'] = currentMap
  loadMaps['HADD.Run.symmetryRestraintConstant'] = currentMap
  currentMap['tag'] = 'HADD.Run.symmetryRestraintConstant'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-02-20-18:43:39_00004'
  currentMap['name'] = 'symmetryRestraintConstant'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = 10.0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00031')

  # Attribute Run.useDbSolvateMethod
  currentMap = {}
  contentMap['useDbSolvateMethod'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-07-08-15:07:51_00003'] = currentMap
  loadMaps['HADD.Run.useDbSolvateMethod'] = currentMap
  currentMap['tag'] = 'HADD.Run.useDbSolvateMethod'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-07-08-15:07:51_00003'
  currentMap['name'] = 'useDbSolvateMethod'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = True
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00028')

  # Attribute Run.useDnaRestraints
  currentMap = {}
  contentMap['useDnaRestraints'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2007-11-21-18:20:26_00013'] = currentMap
  loadMaps['HADD.Run.useDnaRestraints'] = currentMap
  currentMap['tag'] = 'HADD.Run.useDnaRestraints'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2007-11-21-18:20:26_00013'
  currentMap['name'] = 'useDnaRestraints'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = False
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00028')

  # Attribute Run.useHBondRestraints
  currentMap = {}
  contentMap['useHBondRestraints'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-02-18-17:40:19_00021'] = currentMap
  loadMaps['HADD.Run.useHBondRestraints'] = currentMap
  currentMap['tag'] = 'HADD.Run.useHBondRestraints'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-02-18-17:40:19_00021'
  currentMap['name'] = 'useHBondRestraints'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = False
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00028')

  # Attribute Run.waterInitRestCutoff
  currentMap = {}
  contentMap['waterInitRestCutoff'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-07-08-15:07:51_00004'] = currentMap
  loadMaps['HADD.Run.waterInitRestCutoff'] = currentMap
  currentMap['tag'] = 'HADD.Run.waterInitRestCutoff'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-07-08-15:07:51_00004'
  currentMap['name'] = 'waterInitRestCutoff'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = 5.0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:54_00009')

  # Attribute Run.waterRestCutoff
  currentMap = {}
  contentMap['waterRestCutoff'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-07-08-15:07:51_00005'] = currentMap
  loadMaps['HADD.Run.waterRestCutoff'] = currentMap
  currentMap['tag'] = 'HADD.Run.waterRestCutoff'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-07-08-15:07:51_00005'
  currentMap['name'] = 'waterRestCutoff'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = 5.0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:54_00009')

  # Attribute Run.waterRestScale
  currentMap = {}
  contentMap['waterRestScale'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-07-08-15:07:51_00006'] = currentMap
  loadMaps['HADD.Run.waterRestScale'] = currentMap
  currentMap['tag'] = 'HADD.Run.waterRestScale'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-07-08-15:07:51_00006'
  currentMap['name'] = 'waterRestScale'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = 25.0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:54_00009')

  # Attribute Run.waterSurfaceCutoff
  currentMap = {}
  contentMap['waterSurfaceCutoff'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-07-08-15:07:51_00009'] = currentMap
  loadMaps['HADD.Run.waterSurfaceCutoff'] = currentMap
  currentMap['tag'] = 'HADD.Run.waterSurfaceCutoff'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-07-08-15:07:51_00009'
  currentMap['name'] = 'waterSurfaceCutoff'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = 8.0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:54_00009')

  # Attribute Run.waterToAddRandom
  currentMap = {}
  contentMap['waterToAddRandom'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-07-08-15:07:51_00008'] = currentMap
  loadMaps['HADD.Run.waterToAddRandom'] = currentMap
  currentMap['tag'] = 'HADD.Run.waterToAddRandom'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-07-08-15:07:51_00008'
  currentMap['name'] = 'waterToAddRandom'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = 0.0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00058')

  # Attribute Run.waterToKeep
  currentMap = {}
  contentMap['waterToKeep'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-07-08-15:07:51_00007'] = currentMap
  loadMaps['HADD.Run.waterToKeep'] = currentMap
  currentMap['tag'] = 'HADD.Run.waterToKeep'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-07-08-15:07:51_00007'
  currentMap['name'] = 'waterToKeep'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['default'] = 0.25
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00058')

  # Role Run.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')

  # Role Run.annealProtocol
  currentMap = {}
  contentMap['annealProtocol'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-02-20-15:13:04_00003'] = currentMap
  loadMaps['HADD.Run.annealProtocol'] = currentMap
  currentMap['tag'] = 'HADD.Run.annealProtocol'
  currentMap['type'] = 'exolink'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-02-20-15:13:04_00003'
  currentMap['name'] = 'annealProtocol'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['copyOverride'] = True
  currentMap['content'] = globalMap.get('ANPR').get('exolinks')

  # Role Run.haddockEnergyTerms
  currentMap = {}
  contentMap['haddockEnergyTerms'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-02-20-14:31:19_00010'] = currentMap
  loadMaps['HADD.Run.haddockEnergyTerms'] = currentMap
  currentMap['tag'] = 'HADD.Run.haddockEnergyTerms'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-02-20-14:31:19_00010'
  currentMap['name'] = 'haddockEnergyTerms'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('HADD').get('abstractTypes')

  # Role Run.nmrConstraintStore
  currentMap = {}
  contentMap['nmrConstraintStore'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-02-27-16:20:33_00002'] = currentMap
  loadMaps['HADD.Run.nmrConstraintStore'] = currentMap
  currentMap['tag'] = 'HADD.Run.nmrConstraintStore'
  currentMap['type'] = 'exotop'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-02-27-16:20:33_00002'
  currentMap['name'] = 'nmrConstraintStore'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['copyOverride'] = True
  currentMap['content'] = globalMap.get('NMRC').get('exolinks')

  # Role Run.scoringWeights
  currentMap = {}
  contentMap['scoringWeights'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-02-19-14:01:01_00006'] = currentMap
  loadMaps['HADD.Run.scoringWeights'] = currentMap
  currentMap['tag'] = 'HADD.Run.scoringWeights'
  currentMap['type'] = 'child'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-02-19-14:01:01_00006'
  currentMap['name'] = 'scoringWeights'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['content'] = globalMap.get('HADD').get('abstractTypes')

  # Role Run.symmetryRestraints
  currentMap = {}
  contentMap['symmetryRestraints'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-02-20-18:43:39_00002'] = currentMap
  loadMaps['HADD.Run.symmetryRestraints'] = currentMap
  currentMap['tag'] = 'HADD.Run.symmetryRestraints'
  currentMap['type'] = 'exolink'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-02-20-18:43:39_00002'
  currentMap['name'] = 'symmetryRestraints'
  currentMap['hicard'] = -1
  currentMap['locard'] = 0
  currentMap['eType'] = 'cplx'
  currentMap['copyOverride'] = True
  currentMap['content'] = globalMap.get('SYMM').get('exolinks')
  # End of Run

  currentMap = abstractTypes.get('Run')
  aList = ['analysisClustRmsd', 'analysisClustSize', 'analysisDistHBond', 'analysisDistNonbond', 'calcDesolvation', 'centerOfMassConstant', 'centerOfMassRestraints', 'cpuNumber', 'dielectricType', 'doAirScaling', 'doIncludeDihEnergy', 'doRigidBodyElectrostatics', 'doRigidBodyWaterTrans', 'doRigidTranslations', 'doSAElectrostatics', 'doWaterAnalysis', 'doWaterDock', 'epsilon', 'initialRigidBodyMinim', 'nTrails', 'ncsRestraintConstant', 'nonBondedType', 'numAmbRestautoAir', 'numAnalysisStructures', 'numInitWaterShells', 'numIt0Structures', 'numIt1Structures', 'numUnambRestautoAir', 'numWrefStructures', 'radomizeStartOriention', 'randomAmbigRestraints', 'randomExclParts', 'randomExcludeAir', 'randomSeed', 'removeNonPolarH', 'rigidbodyIMinteractScaling', 'rotate180It0', 'rotate180It1', 'serial', 'skipStructures', 'solvent', 'surfaceContactConstant', 'surfaceContactRestraints', 'symmetryRestraintConstant', 'useDbSolvateMethod', 'useDnaRestraints', 'useHBondRestraints', 'waterInitRestCutoff', 'waterRestCutoff', 'waterRestScale', 'waterSurfaceCutoff', 'waterToAddRandom', 'waterToKeep']
  currentMap['headerAttrs'] = aList
  aList = ['cnsExecutable', 'haddockDir', 'queueCommand']
  currentMap['simpleAttrs'] = aList
  aList = ['scoringWeights', 'haddockEnergyTerms', 'symmetryRestraints', 'nmrConstraintStore', 'annealProtocol', 'access', 'applicationData']
  currentMap['cplxAttrs'] = aList
  aList = ['haddockEnergyTerms', 'scoringWeights']
  currentMap['children'] = aList

  # Class ScoringWeight
  currentMap = {}
  abstractTypes['ScoringWeight'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-02-19-14:00:58_00002'] = currentMap
  loadMaps['HADD.ScoringWeight'] = currentMap
  currentMap['tag'] = 'HADD.ScoringWeight'
  currentMap['type'] = 'class'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-02-19-14:00:58_00002'
  currentMap['eType'] = 'cplx'
  currentMap['fromParent'] = 'scoringWeights'
  currentMap['class'] = utrecht.api.Haddock.ScoringWeight
  contentMap = {}
  currentMap['content'] = contentMap

  # Attribute ScoringWeight.applicationData
  contentMap['applicationData'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-09-14-18:48:27_00007')

  # Attribute ScoringWeight.stage
  currentMap = {}
  contentMap['stage'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-02-19-14:01:01_00015'] = currentMap
  loadMaps['HADD.ScoringWeight.stage'] = currentMap
  currentMap['tag'] = 'HADD.ScoringWeight.stage'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-02-19-14:01:01_00015'
  currentMap['name'] = 'stage'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:54_00011')

  # Attribute ScoringWeight.term
  currentMap = {}
  contentMap['term'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-02-19-14:01:01_00014'] = currentMap
  loadMaps['HADD.ScoringWeight.term'] = currentMap
  currentMap['tag'] = 'HADD.ScoringWeight.term'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-02-19-14:01:01_00014'
  currentMap['name'] = 'term'
  currentMap['hicard'] = 1
  currentMap['locard'] = 1
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-02-19-14:00:58_00003')

  # Attribute ScoringWeight.value
  currentMap = {}
  contentMap['value'] = currentMap
  mapsByGuid['www.ccpn.ac.uk_Fogh_2008-02-19-14:01:01_00016'] = currentMap
  loadMaps['HADD.ScoringWeight.value'] = currentMap
  currentMap['tag'] = 'HADD.ScoringWeight.value'
  currentMap['type'] = 'attr'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-02-19-14:01:01_00016'
  currentMap['name'] = 'value'
  currentMap['hicard'] = 1
  currentMap['locard'] = 0
  currentMap['data'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00031')

  # Role ScoringWeight.access
  contentMap['access'] = mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-12-31-09:03:01_00014')
  # End of ScoringWeight

  currentMap = abstractTypes.get('ScoringWeight')
  aList = ['stage', 'term', 'value']
  currentMap['headerAttrs'] = aList
  aList = ['access', 'applicationData']
  currentMap['cplxAttrs'] = aList

  # Out-of-package link to Chain
  currentMap = {}
  exolinks['Chain'] = currentMap
  loadMaps['HADD.exo-Chain'] = currentMap
  currentMap['tag'] = 'HADD.exo-Chain'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-02-27-16:13:11_00001'
  currentMap['name'] = 'Chain'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = utrecht.api.Haddock.Chain
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00037'))
  aList.append(globalMap.get('MOLS').get('exolinks'))

  # Out-of-package link to EnergyTermParameter
  currentMap = {}
  exolinks['EnergyTermParameter'] = currentMap
  loadMaps['HADD.exo-EnergyTermParameter'] = currentMap
  currentMap['tag'] = 'HADD.exo-EnergyTermParameter'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-02-20-14:31:17_00001'
  currentMap['name'] = 'EnergyTermParameter'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = utrecht.api.Haddock.EnergyTermParameter
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00033'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:54_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00033'))

  # Out-of-package link to HaddockEnergyTerm
  currentMap = {}
  exolinks['HaddockEnergyTerm'] = currentMap
  loadMaps['HADD.exo-HaddockEnergyTerm'] = currentMap
  currentMap['tag'] = 'HADD.exo-HaddockEnergyTerm'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-10-11-22:58:43_00006'
  currentMap['name'] = 'HaddockEnergyTerm'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = utrecht.api.Haddock.HaddockEnergyTerm
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00033'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:54_00001'))

  # Out-of-package link to HaddockPartner
  currentMap = {}
  exolinks['HaddockPartner'] = currentMap
  loadMaps['HADD.exo-HaddockPartner'] = currentMap
  currentMap['tag'] = 'HADD.exo-HaddockPartner'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-10-11-22:58:43_00004'
  currentMap['name'] = 'HaddockPartner'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = utrecht.api.Haddock.HaddockPartner
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00037'))

  # Out-of-package link to HaddockProject
  currentMap = {}
  exolinks['HaddockProject'] = currentMap
  loadMaps['HADD.exo-HaddockProject'] = currentMap
  currentMap['tag'] = 'HADD.exo-HaddockProject'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-10-11-22:58:43_00003'
  currentMap['name'] = 'HaddockProject'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = utrecht.api.Haddock.HaddockProject
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))

  # Out-of-package link to Residue
  currentMap = {}
  exolinks['Residue'] = currentMap
  loadMaps['HADD.exo-Residue'] = currentMap
  currentMap['tag'] = 'HADD.exo-Residue'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-02-27-16:13:11_00002'
  currentMap['name'] = 'Residue'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = utrecht.api.Haddock.Residue
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00037'))
  aList.append(globalMap.get('MOLS').get('exolinks'))
  aList.append(globalMap.get('MOLS').get('exolinks'))

  # Out-of-package link to Run
  currentMap = {}
  exolinks['Run'] = currentMap
  loadMaps['HADD.exo-Run'] = currentMap
  currentMap['tag'] = 'HADD.exo-Run'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2006-10-11-22:58:43_00007'
  currentMap['name'] = 'Run'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = utrecht.api.Haddock.Run
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))

  # Out-of-package link to ScoringWeight
  currentMap = {}
  exolinks['ScoringWeight'] = currentMap
  loadMaps['HADD.exo-ScoringWeight'] = currentMap
  currentMap['tag'] = 'HADD.exo-ScoringWeight'
  currentMap['type'] = 'exo'
  currentMap['guid'] = 'www.ccpn.ac.uk_Fogh_2008-02-19-14:00:58_00002'
  currentMap['name'] = 'ScoringWeight'
  currentMap['eType'] = 'cplx'
  currentMap['class'] = utrecht.api.Haddock.ScoringWeight
  aList = list()
  currentMap['keyMaps'] = aList
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-06-30-16:30:50_00001'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2008-02-19-14:00:58_00003'))
  aList.append(mapsByGuid.get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:54_00011'))
