## from nomenclature import *
##from object2code import object2code
#from classes import *
#from NTutils import *
#from AwkLike import *
#from sys import *
#
#""" Temporary script to generate an atom table based on the cyanalib file and protein conversion table
#    Intermediate step in generating the residue database.
#"""
#
#resNameDefs = [
## map 'exceptions' before regular ones, e.g.
##   first ASP- so that ASP- maps to [D ASP- Asp- ...]
##   Then ASP do that ASP maps to [D ASP Asp ..]
##   But D maps to [D ASP Asp ..]
#
#  ('ALA','A'),
## map ARG+ before ARG
#  ('ARG+','R'),
#  ('ARG','R'),
#  ('ASN','N'),
## map ASP- before ASP
#  ('ASP-','D'),
#  ('ASP','D'),
#  ('CYS','C'),
#  ('GLN','Q'),
## map GLU- before GLU
#  ('GLU-','E'),
#  ('GLU','E'),
#  ('GLY','G'),
#  ('HIS','H'),
#  ('ILE','I'),
#  ('LEU','L'),
## map LYS+ before LYS
#  ('LYS+','K'),
#  ('LYS','K'),
#  ('MET','M'),
#  ('PHE','F'),
#  ('PRO','P'),
#  ('SER','S'),
#  ('THR','T'),
#  ('TRP','W'),
#  ('TYR','Y'),
#  ('VAL','V'),
#  ('CTER','Z'),
#  ('NTER','X'),
#]
#
##==============================================================================
## Create a dictionary of residue name translations
##
## e.g. 'F', 'PHE', 'Phe', 'phe',  are each mapped to the list
##
##      ['F', 'PHE', 'Phe', 'phe']
## so that
##      resNameTranslations['F'][0] equals 'F' 
##      resNameTranslations['F'][1] equals 'PHE' 
##      resNameTranslations['F'][2] equals 'Phe' etc ..
##
##      resNameTranslations['PHE'][0] equals 'F' 
##      resNameTranslations['PHE'][1] equals 'PHE' 
##      resNameTranslations['PHE'][2] equals 'Phe' etc ..
## etc.
##
##==============================================================================
##
#resNameShort = 0
#resNamePreferred = 1
#
#resNameTranslations = {}
#for (aaa,a) in resNameDefs:
##  print '>>',aaa,a
#  resNames = [a, aaa.upper(), aaa.capitalize(), aaa.lower()]
##  print resNames
#  for name in resNames:
#  	resNameTranslations[name] = resNames
#
#cyanaLib = """
## RESIDUE resName Number_of_dihedral_defs number_of_atom_defs start_atom_of_residue stop_atom_of_residue
## gv: connected pseudo's of Protein residues to carbon, but not carbon to pseudo as this is done indirectly 
## inserted one-letter code into residue field
#RESIDUE   ALA  A    4   14    3   13
#   1 OMEGA   -1    2   10.0000    2    1    3    4    0
#   2 PHI      0    0    0.0000    1    3    5   12    0
#   3 CHI1     1    3    1.3500    3    5    8    9   11
#   4 PSI      0    0    0.0000    3    5   12   14    0
#   1 C    C_BYL    2    8.2024   -0.6824   -1.1357    0.0000    2    3    0    0    0
#   2 O    O_BYL    2   -7.0004   -0.1723   -2.2550    0.0000    1    0    0    0    0
#   3 N    N_AMI    2   -6.4912    0.0000    0.0000    0.0000    1    4    5    0    0
#   4 HN   H_AMI    0    3.2103   -0.4226    0.9063    0.0000    3    0    0    0    0
#   5 CA   C_ALI    3    1.1597    1.4530    0.0000    0.0000    3    6    8   12    0
#   6 HA   H_ALI    0    0.3677    1.7849   -0.4925    0.9140    5    0    0    0    0
#   7 QB   PSEUD    0    0.0000    2.0850   -0.9858   -1.4878    8    0    0    0    0
#   8 CB   C_ALI    3   -1.6546    1.9637   -0.7966   -1.2023    5    9   10   11    0
#   9 HB1  H_ALI    0    0.7354    3.0537   -0.7963   -1.2019    8    0    0    0    7
#  10 HB2  H_ALI    0    0.7354    1.6006   -1.8224   -1.1392    8    0    0    0    7
#  11 HB3  H_ALI    0    0.7354    1.6006   -0.3386   -2.1223    8    0    0    0    7
#  12 C    C_BYL    2    8.2024    1.9587    1.4440    0.0000    5   13   14    0    0
#  13 O    O_BYL    2   -7.0004    1.1648    2.3835    0.0000   12    0    0    0    0
#  14 N    N_AMI    2   -6.4912    3.2772    1.5756    0.0000   12    0    0    0    0
#RESIDUE   ARG+ R    7   32    3   31
#   1 OMEGA   -1    2   10.0000    2    1    3    4    0
#   2 PHI      0    0    0.0000    1    3    5   30    0
#   3 CHI1     1    3    1.3500    3    5    7   11   29
#   4 CHI2     1    3    1.3500    5    7   11   15   29
#   5 CHI3     1    3    1.3500    7   11   15   19   29
#   6 CHI4     0    0    0.0000   11   15   19   21   29
#   7 PSI      0    0    0.0000    3    5   30   32    0
#   1 C    C_BYL    2    8.2024   -0.6824   -1.1357    0.0000    2    3    0    0    0
#   2 O    O_BYL    2   -7.0004   -0.1723   -2.2550    0.0000    1    0    0    0    0
#   3 N    N_AMI    2   -6.4912    0.0000    0.0000    0.0000    1    4    5    0    0
#   4 HN   H_AMI    0    3.2103   -0.4226    0.9063    0.0000    3    0    0    0    0
#   5 CA   C_ALI    3    1.1597    1.4530    0.0000    0.0000    3    6    7   30    0
#   6 HA   H_ALI    0    0.3677    1.7317   -0.5213    0.9158    5    0    0    0    0
#   7 CB   C_ALI    3   -0.5515    2.0038   -0.7402   -1.2205    5    8    9   11    0
#   8 HB2  H_ALI    0    0.2687    1.6375   -1.7668   -1.2235    7    0    0    0   10
#   9 HB3  H_ALI    0    0.2687    1.6375   -0.2685   -2.1323    7    0    0    0   10
#  10 QB   PSEUD    0    0.0000    1.6375   -1.0177   -1.6779    7    0    0    0    0
#  11 CG   C_ALI    3   -0.5515    3.5338   -0.7388   -1.2182    7   12   13   15    0
#  12 HG2  H_ALI    0    0.5515    3.9001    0.2878   -1.2152   11    0    0    0   14
#  13 HG3  H_ALI    0    0.5515    3.9001   -1.2106   -0.3064   11    0    0    0   14
#  14 QG   PSEUD    0    0.0000    3.9001   -0.4614   -0.7608   11    0    0    0    0
#  15 CD   C_ALI    3    2.2062    4.0846   -1.4791   -2.4387   11   16   17   19    0
#  16 HD2  H_ALI    0    0.1980    3.7230   -2.5073   -2.4444   15    0    0    0   18
#  17 HD3  H_ALI    0    0.1980    3.7230   -1.0090   -3.3532   15    0    0    0   18
#  18 QD   PSEUD    0    0.0000    3.7230   -1.7581   -2.8988   15    0    0    0    0
#  19 NE   N_AMI    2   -5.4589    5.5643   -1.4643   -2.4144   15   20   21    0    0
#  20 HE   H_AMI    0    4.1861    6.0160   -1.0017   -1.6515   19    0    0    0    0
#  21 CZ   C_VIN    2   10.5783    6.3367   -2.0321   -3.3506   19   22   26    0    0
#  22 NH1  N_AMO    2   -7.0852    7.6712   -1.9691   -3.2468   21   23   24    0    0
#  23 HH11 H_AMI    0    5.1195    8.2477   -2.3929   -3.9454   22    0    0    0   25
#  24 HH12 H_AMI    0    5.1195    8.0907   -1.4983   -2.4706   22    0    0    0   25
#  25 QH1  PSEUD    0    0.0000    8.1692   -1.9456   -3.2080   22    0    0    0    0
#  26 NH2  N_AMO    2   -7.0852    5.7747   -2.6630   -4.3906   21   27   28    0    0
#  27 HH21 H_AMI    0    5.1195    6.3512   -3.0868   -5.0893   26    0    0    0   29
#  28 HH22 H_AMI    0    5.1195    4.7788   -2.7101   -4.4681   26    0    0    0   29
#  29 QH2  PSEUD    0    0.0000    5.5650   -2.8985   -4.7787   26    0    0    0    0
#  30 C    C_BYL    2    8.2024    1.9838    1.4350    0.0000    5   31   32    0    0
#  31 O    O_BYL    2   -7.0004    1.2064    2.3881    0.0000   30    0    0    0    0
#  32 N    N_AMI    2   -6.4912    3.3043    1.5436    0.0000   30    0    0    0    0
#RESIDUE   ARG  R    7   30    3   29
#   1 OMEGA   -1    2   10.0000    2    1    3    4    0
#   2 PHI      0    0    0.0000    1    3    5   28    0
#   3 CHI1     1    3    1.3500    3    5    7   11   27
#   4 CHI2     1    3    1.3500    5    7   11   15   27
#   5 CHI3     1    3    1.3500    7   11   15   19   27
#   6 CHI4     0    0    0.0000   11   15   19   21   27
#   7 PSI      0    0    0.0000    3    5   28   30    0
#   1 C    C_BYL    2    8.2024   -0.6824   -1.1357    0.0000    2    3    0    0    0
#   2 O    O_BYL    2   -7.0004   -0.1723   -2.2550    0.0000    1    0    0    0    0
#   3 N    N_AMI    2   -6.4912    0.0000    0.0000    0.0000    1    4    5    0    0
#   4 HN   H_AMI    0    3.2103   -0.4226    0.9063    0.0000    3    0    0    0    0
#   5 CA   C_ALI    3    1.1597    1.4530    0.0000    0.0000    3    6    7   28    0
#   6 HA   H_ALI    0    0.3677    1.7317   -0.5213    0.9158    5    0    0    0    0
#   7 CB   C_ALI    3   -0.5515    2.0038   -0.7402   -1.2205    5    8    9   11    0
#   8 HB2  H_ALI    0    0.2687    1.6375   -1.7668   -1.2235    7    0    0    0   10
#   9 HB3  H_ALI    0    0.2687    1.6375   -0.2685   -2.1323    7    0    0    0   10
#  10 QB   PSEUD    0    0.0000    1.6375   -1.0177   -1.6779    7    0    0    0    0
#  11 CG   C_ALI    3   -0.5515    3.5338   -0.7388   -1.2182    7   12   13   15    0
#  12 HG2  H_ALI    0    0.5515    3.9001    0.2878   -1.2152   11    0    0    0   14
#  13 HG3  H_ALI    0    0.5515    3.9001   -1.2106   -0.3064   11    0    0    0   14
#  14 QG   PSEUD    0    0.0000    3.9001   -0.4614   -0.7608   11    0    0    0    0
#  15 CD   C_ALI    3    1.8243    4.0846   -1.4791   -2.4387   11   16   17   19    0
#  16 HD2  H_ALI    0    0.1838    3.7230   -2.5073   -2.4444   15    0    0    0   18
#  17 HD3  H_ALI    0    0.1838    3.7230   -1.0090   -3.3532   15    0    0    0   18
#  18 QD   PSEUD    0    0.0000    3.7230   -1.7581   -2.8988   15    0    0    0    0
#  19 NE   N_AMI    2   -6.3781    5.5643   -1.4643   -2.4144   15   20   21    0    0
#  20 HE   H_AMI    0    3.0971    6.0160   -1.0017   -1.6515   19    0    0    0    0
#  21 CZ   C_VIN    2    8.7540    6.3425   -2.0364   -3.3576   19   22   24    0    0
#  22 NH1  N_AMI    2   -7.6509    7.6548   -1.9625   -3.2357   21   23    0    0    0
#  23 HH1  H_AMI    0    1.6405    8.3002   -2.3586   -3.8888   22    0    0    0    0
#  24 NH2  N_AMI    2   -7.4670    5.7870   -2.6745   -4.4096   21   25   26    0    0
#  25 HH21 H_AMI    0    2.9133    6.3705   -3.0956   -5.1040   24    0    0    0   27
#  26 HH22 H_AMI    0    2.9133    4.7919   -2.7260   -4.4945   24    0    0    0   27
#  27 QH2  PSEUD    0    0.0000    5.5812   -2.9108   -4.7993   24    0    0    0    0
#  28 C    C_BYL    2    8.2024    1.9838    1.4350    0.0000    5   29   30    0    0
#  29 O    O_BYL    2   -7.0004    1.2064    2.3881    0.0000   28    0    0    0    0
#  30 N    N_AMI    2   -6.4912    3.3043    1.5436    0.0000   28    0    0    0    0
#RESIDUE   ASN  N    5   19    3   18
#   1 OMEGA   -1    2   10.0000    2    1    3    4    0
#   2 PHI      0    0    0.0000    1    3    5   17    0
#   3 CHI1     1    3    1.3500    3    5    7   11   16
#   4 CHI2     0    0    0.0000    5    7   11   12   16
#   5 PSI      0    0    0.0000    3    5   17   19    0
#   1 C    C_BYL    2    8.2024   -0.6824   -1.1357    0.0000    2    3    0    0    0
#   2 O    O_BYL    2   -7.0004   -0.1723   -2.2550    0.0000    1    0    0    0    0
#   3 N    N_AMI    2   -6.4912    0.0000    0.0000    0.0000    1    4    5    0    0
#   4 HN   H_AMI    0    3.2103   -0.4226    0.9063    0.0000    3    0    0    0    0
#   5 CA   C_ALI    3    1.1597    1.4530    0.0000    0.0000    3    6    7   17    0
#   6 HA   H_ALI    0    0.3677    1.7394   -0.5422    0.9011    5    0    0    0    0
#   7 CB   C_ALI    3   -2.1920    2.0038   -0.6938   -1.2474    5    8    9   11    0
#   8 HB2  H_ALI    0    1.0041    1.6375   -1.7196   -1.2891    7    0    0    0   10
#   9 HB3  H_ALI    0    1.0041    1.6375   -0.1881   -2.1409    7    0    0    0   10
#  10 QB   PSEUD    0    0.0000    1.6375   -0.9538   -1.7150    7    0    0    0    0
#  11 CG   C_BYL    2    8.3721    3.5338   -0.6925   -1.2451    7   12   13    0    0
#  12 OD1  O_BYL    2   -6.8307    4.1821   -1.1949   -2.1483   11    0    0    0    0
#  13 ND2  N_AMI    2   -8.1034    4.0726   -0.1015   -0.1825   11   14   15    0    0
#  14 HD21 H_AMI    0    3.6487    3.4834    0.2913    0.5236   13    0    0    0   16
#  15 HD22 H_AMI    0    3.6487    5.0670   -0.0498   -0.0896   13    0    0    0   16
#  16 QD2  PSEUD    0    0.0000    4.2752    0.1208    0.2170   13    0    0    0    0
#  17 C    C_BYL    2    8.2024    1.9587    1.4440    0.0000    5   18   19    0    0
#  18 O    O_BYL    2   -7.0004    1.1648    2.3835    0.0000   17    0    0    0    0
#  19 N    N_AMI    2   -6.4912    3.2772    1.5756    0.0000   17    0    0    0    0
#RESIDUE   ASP- D    5   16    3   15
#   1 OMEGA   -1    2   10.0000    2    1    3    4    0
#   2 PHI      0    0    0.0000    1    3    5   14    0
#   3 CHI1     1    3    1.3500    3    5    7   11   13
#   4 CHI2     0    0    0.0000    5    7   11   12   13
#   5 PSI      0    0    0.0000    3    5   14   16    0
#   1 C    C_BYL    2    8.2024   -0.6824   -1.1357    0.0000    2    3    0    0    0
#   2 O    O_BYL    2   -7.0004   -0.1723   -2.2550    0.0000    1    0    0    0    0
#   3 N    N_AMI    2   -6.4912    0.0000    0.0000    0.0000    1    4    5    0    0
#   4 HN   H_AMI    0    3.2103   -0.4226    0.9063    0.0000    3    0    0    0    0
#   5 CA   C_ALI    3   -1.0904    1.4530    0.0000    0.0000    3    6    7   14    0
#   6 HA   H_ALI    0    0.4384    1.7394   -0.5422    0.9011    5    0    0    0    0
#   7 CB   C_ALI    3   -3.0971    2.0038   -0.6938   -1.2474    5    8    9   11    0
#   8 HB2  H_ALI    0   -0.3677    1.6190   -1.7132   -1.2776    7    0    0    0   10
#   9 HB3  H_ALI    0   -0.3677    1.6190   -0.1818   -2.1294    7    0    0    0   10
#  10 QB   PSEUD    0    0.0000    1.6190   -0.9475   -1.7035    7    0    0    0    0
#  11 CG   C_BYL    2    9.1075    3.5302   -0.7444   -1.3384    7   12   13    0    0
#  12 OD1  O_BYL    2  -10.3803    4.0206   -1.3033   -2.3432   11    0    0    0    0
#  13 OD2  O_BYL    2  -10.3803    4.1722   -0.2231   -0.4011   11    0    0    0    0
#  14 C    C_BYL    2    8.2024    1.9587    1.4440    0.0000    5   15   16    0    0
#  15 O    O_BYL    2   -7.0004    1.1648    2.3835    0.0000   14    0    0    0    0
#  16 N    N_AMI    2   -6.4912    3.2772    1.5756    0.0000   14    0    0    0    0
#RESIDUE   ASP  D    6   17    3   16
#   1 OMEGA   -1    2   10.0000    2    1    3    4    0
#   2 PHI      0    0    0.0000    1    3    5   15    0
#   3 CHI1     1    3    1.3500    3    5    7   11   14
#   4 CHI2     0    0    0.0000    5    7   11   12   14
#   5 CHI32   -1    2    4.0000    7   11   13   14   14
#   6 PSI      0    0    0.0000    3    5   15   17    0
#   1 C    C_BYL    2    8.2024   -0.6824   -1.1357    0.0000    2    3    0    0    0
#   2 O    O_BYL    2   -7.0004   -0.1723   -2.2550    0.0000    1    0    0    0    0
#   3 N    N_AMI    2   -6.4912    0.0000    0.0000    0.0000    1    4    5    0    0
#   4 HN   H_AMI    0    3.2103   -0.4226    0.9063    0.0000    3    0    0    0    0
#   5 CA   C_ALI    3    1.1597    1.4530    0.0000    0.0000    3    6    7   15    0
#   6 HA   H_ALI    0    0.3677    1.7394   -0.5422    0.9011    5    0    0    0    0
#   7 CB   C_ALI    3   -1.8243    2.0038   -0.6938   -1.2474    5    8    9   11    0
#   8 HB2  H_ALI    0    1.1031    1.6190   -1.7132   -1.2776    7    0    0    0   10
#   9 HB3  H_ALI    0    1.1031    1.6190   -0.1818   -2.1294    7    0    0    0   10
#  10 QB   PSEUD    0    0.0000    1.6190   -0.9475   -1.7035    7    0    0    0    0
#  11 CG   C_BYL    2    9.1075    3.5302   -0.7444   -1.3384    7   12   13    0    0
#  12 OD1  O_BYL    2   -6.5620    4.0951   -1.2810   -2.3031   11    0    0    0    0
#  13 OD2  O_HYD    2   -6.3781    4.1537   -0.1955   -0.3514   11   14    0    0    0
#  14 HD2  H_OXY    0    4.0022    5.1416   -0.2707   -0.4866   13    0    0    0    0
#  15 C    C_BYL    2    8.2024    1.9587    1.4440    0.0000    5   16   17    0    0
#  16 O    O_BYL    2   -7.0004    1.1648    2.3835    0.0000   15    0    0    0    0
#  17 N    N_AMI    2   -6.4912    3.2772    1.5756    0.0000   15    0    0    0    0
#RESIDUE   CYSS CS    4   14    3   13
#   1 OMEGA   -1    2   10.0000    2    1    3    4    0
#   2 PHI      0    0    0.0000    1    3    5   12    0
#   3 CHI1     1    3    1.3500    3    5    7   11   11
#   4 PSI      0    0    0.0000    3    5   12   14    0
#   1 C    C_BYL    2    8.2024   -0.6824   -1.1357    0.0000    2    3    0    0    0
#   2 O    O_BYL    2   -7.0004   -0.1723   -2.2550    0.0000    1    0    0    0    0
#   3 N    N_AMI    2   -6.4912    0.0000    0.0000    0.0000    1    4    5    0    0
#   4 HN   H_AMI    0    3.2103   -0.4226    0.9063    0.0000    3    0    0    0    0
#   5 CA   C_ALI    3    1.1597    1.4530    0.0000    0.0000    3    6    7   12    0
#   6 HA   H_ALI    0    0.3677    1.7661   -0.5112    0.9103    5    0    0    0    0
#   7 CB   C_ALI    3   -1.6405    2.0187   -0.7882   -1.1831    5    8    9   11    0
#   8 HB2  H_ALI    0    1.0041    1.6404   -1.8093   -1.1355    7    0    0    0   10
#   9 HB3  H_ALI    0    1.0041    1.6404   -0.3509   -2.1071    7    0    0    0   10
#  10 QB   PSEUD    0    0.0000    1.6404   -1.0801   -1.6213    7    0    0    0    0
#  11 SG   S_OXY    3    0.1838    3.8460   -0.8430   -1.2654    7    0    0    0    0
#  12 C    C_BYL    2    8.2024    1.9334    1.4526    0.0000    5   13   14    0    0
#  13 O    O_BYL    2   -7.0004    1.1232    2.3781    0.0000   12    0    0    0    0
#  14 N    N_AMI    2   -6.4912    3.2494    1.6072    0.0000   12    0    0    0    0
#RESIDUE   CYS  C    5   15    3   14
#   1 OMEGA   -1    2   10.0000    2    1    3    4    0
#   2 PHI      0    0    0.0000    1    3    5   13    0
#   3 CHI1     1    3    1.3500    3    5    7   11   12
#   4 CHI2     1    3    0.7500    5    7   11   12   12
#   5 PSI      0    0    0.0000    3    5   13   15    0
#   1 C    C_BYL    2    8.2024   -0.6824   -1.1357    0.0000    2    3    0    0    0
#   2 O    O_BYL    2   -7.0004   -0.1723   -2.2550    0.0000    1    0    0    0    0
#   3 N    N_AMI    2   -6.4912    0.0000    0.0000    0.0000    1    4    5    0    0
#   4 HN   H_AMI    0    3.2103   -0.4226    0.9063    0.0000    3    0    0    0    0
#   5 CA   C_ALI    3    1.1597    1.4530    0.0000    0.0000    3    6    7   13    0
#   6 HA   H_ALI    0    0.3677    1.7661   -0.5112    0.9103    5    0    0    0    0
#   7 CB   C_ALI    3   -1.9092    2.0187   -0.7882   -1.1831    5    8    9   11    0
#   8 HB2  H_ALI    0    1.0041    1.6627   -1.8178   -1.1483    7    0    0    0   10
#   9 HB3  H_ALI    0    1.0041    1.6627   -0.3594   -2.1199    7    0    0    0   10
#  10 QB   PSEUD    0    0.0000    1.6627   -1.0886   -1.6341    7    0    0    0    0
#  11 SG   S_RED    3    0.2687    3.8479   -0.7581   -1.1379    7   12    0    0    0
#  12 HG   H_SUL    0    0.1838    4.0261   -1.4888   -2.2348   11    0    0    0    0
#  13 C    C_BYL    2    8.2024    1.9334    1.4526    0.0000    5   14   15    0    0
#  14 O    O_BYL    2   -7.0004    1.1232    2.3781    0.0000   13    0    0    0    0
#  15 N    N_AMI    2   -6.4912    3.2494    1.6072    0.0000   13    0    0    0    0
#RESIDUE   GLN  Q    6   23    3   22
#   1 OMEGA   -1    2   10.0000    2    1    3    4    0
#   2 PHI      0    0    0.0000    1    3    5   21    0
#   3 CHI1     1    3    1.3500    3    5    7   11   20
#   4 CHI2     1    3    1.3500    5    7   11   15   20
#   5 CHI3     0    0    0.0000    7   11   15   16   20
#   6 PSI      0    0    0.0000    3    5   21   23    0
#   1 C    C_BYL    2    8.2024   -0.6824   -1.1357    0.0000    2    3    0    0    0
#   2 O    O_BYL    2   -7.0004   -0.1723   -2.2550    0.0000    1    0    0    0    0
#   3 N    N_AMI    2   -6.4912    0.0000    0.0000    0.0000    1    4    5    0    0
#   4 HN   H_AMI    0    3.2103   -0.4226    0.9063    0.0000    3    0    0    0    0
#   5 CA   C_ALI    3    1.1597    1.4530    0.0000    0.0000    3    6    7   21    0
#   6 HA   H_ALI    0    0.3677    1.7427   -0.5017    0.9233    5    0    0    0    0
#   7 CB   C_ALI    3   -0.5374    2.0013   -0.7874   -1.1917    5    8    9   11    0
#   8 HB2  H_ALI    0    0.3677    1.6341   -1.8130   -1.1545    7    0    0    0   10
#   9 HB3  H_ALI    0    0.3677    1.6341   -0.3510   -2.1206    7    0    0    0   10
#  10 QB   PSEUD    0    0.0000    1.6341   -1.0820   -1.6375    7    0    0    0    0
#  11 CG   C_ALI    3   -2.0082    3.5313   -0.7874   -1.1917    7   12   13   15    0
#  12 HG2  H_ALI    0    0.9051    3.8985    0.2382   -1.2290   11    0    0    0   14
#  13 HG3  H_ALI    0    0.9051    3.8985   -1.2239   -0.2629   11    0    0    0   14
#  14 QG   PSEUD    0    0.0000    3.8985   -0.4928   -0.7459   11    0    0    0    0
#  15 CD   C_BYL    2    8.5701    4.0796   -1.5749   -2.3835   11   16   17    0    0
#  16 OE1  O_BYL    2   -6.9155    5.2772   -1.7032   -2.5777   15    0    0    0    0
#  17 NE2  N_AMI    2   -7.8347    3.1391   -2.0933   -3.1681   15   18   19    0    0
#  18 HE21 H_AMI    0    3.3658    2.1732   -1.9506   -2.9521   17    0    0    0   20
#  19 HE22 H_AMI    0    3.3658    3.3980   -2.6258   -3.9740   17    0    0    0   20
#  20 QE2  PSEUD    0    0.0000    2.7856   -2.2882   -3.4631   17    0    0    0    0
#  21 C    C_BYL    2    8.2024    1.9838    1.4350    0.0000    5   22   23    0    0
#  22 O    O_BYL    2   -7.0004    1.2064    2.3882    0.0000   21    0    0    0    0
#  23 N    N_AMI    2   -6.4912    3.3043    1.5436    0.0000   21    0    0    0    0
#RESIDUE   GLU- E    6   20    3   19
#   1 OMEGA   -1    2   10.0000    2    1    3    4    0
#   2 PHI      0    0    0.0000    1    3    5   18    0
#   3 CHI1     1    3    1.3500    3    5    7   11   17
#   4 CHI2     1    3    1.3500    5    7   11   15   17
#   5 CHI3     0    0    0.0000    7   11   15   16   17
#   6 PSI      0    0    0.0000    3    5   18   20    0
#   1 C    C_BYL    2    8.2024   -0.6824   -1.1357    0.0000    2    3    0    0    0
#   2 O    O_BYL    2   -7.0004   -0.1723   -2.2550    0.0000    1    0    0    0    0
#   3 N    N_AMI    2   -6.4912    0.0000    0.0000    0.0000    1    4    5    0    0
#   4 HN   H_AMI    0    3.2103   -0.4226    0.9063    0.0000    3    0    0    0    0
#   5 CA   C_ALI    3    1.1597    1.4530    0.0000    0.0000    3    6    7   18    0
#   6 HA   H_ALI    0    0.3677    1.7427   -0.5017    0.9233    5    0    0    0    0
#   7 CB   C_ALI    3   -2.1779    2.0013   -0.7874   -1.1917    5    8    9   11    0
#   8 HB2  H_ALI    0    0.3677    1.6341   -1.8130   -1.1545    7    0    0    0   10
#   9 HB3  H_ALI    0    0.3677    1.6341   -0.3510   -2.1206    7    0    0    0   10
#  10 QB   PSEUD    0    0.0000    1.6341   -1.0820   -1.6375    7    0    0    0    0
#  11 CG   C_ALI    3   -3.0971    3.5313   -0.7874   -1.1917    7   12   13   15    0
#  12 HG2  H_ALI    0   -0.7354    3.8985    0.2382   -1.2290   11    0    0    0   14
#  13 HG3  H_ALI    0   -0.7354    3.8985   -1.2239   -0.2629   11    0    0    0   14
#  14 QG   PSEUD    0    0.0000    3.8985   -0.4928   -0.7459   11    0    0    0    0
#  15 CD   C_BYL    2    9.1075    4.0796   -1.5749   -2.3835   11   16   17    0    0
#  16 OE1  O_BYL    2  -10.3803    5.3227   -1.6469   -2.4925   15    0    0    0    0
#  17 OE2  O_BYL    2  -10.3803    3.2432   -2.0870   -3.1585   15    0    0    0    0
#  18 C    C_BYL    2    8.2024    1.9838    1.4350    0.0000    5   19   20    0    0
#  19 O    O_BYL    2   -7.0004    1.2064    2.3882    0.0000   18    0    0    0    0
#  20 N    N_AMI    2   -6.4912    3.3043    1.5436    0.0000   18    0    0    0    0
#RESIDUE   GLU  E    7   21    3   20
#   1 OMEGA   -1    2   10.0000    2    1    3    4    0
#   2 PHI      0    0    0.0000    1    3    5   19    0
#   3 CHI1     1    3    1.3500    3    5    7   11   18
#   4 CHI2     1    3    1.3500    5    7   11   15   18
#   5 CHI3     0    0    0.0000    7   11   15   16   18
#   6 CHI42   -1    2    4.0000   11   15   17   18   18
#   7 PSI      0    0    0.0000    3    5   19   21    0
#   1 C    C_BYL    2    8.2024   -0.6824   -1.1357    0.0000    2    3    0    0    0
#   2 O    O_BYL    2   -7.0004   -0.1723   -2.2550    0.0000    1    0    0    0    0
#   3 N    N_AMI    2   -6.4912    0.0000    0.0000    0.0000    1    4    5    0    0
#   4 HN   H_AMI    0    3.2103   -0.4226    0.9063    0.0000    3    0    0    0    0
#   5 CA   C_ALI    3    1.1597    1.4530    0.0000    0.0000    3    6    7   19    0
#   6 HA   H_ALI    0    0.3677    1.7427   -0.5017    0.9233    5    0    0    0    0
#   7 CB   C_ALI    3   -0.5515    2.0013   -0.7874   -1.1917    5    8    9   11    0
#   8 HB2  H_ALI    0    0.5515    1.6341   -1.8130   -1.1545    7    0    0    0   10
#   9 HB3  H_ALI    0    0.5515    1.6341   -0.3510   -2.1206    7    0    0    0   10
#  10 QB   PSEUD    0    0.0000    1.6341   -1.0820   -1.6375    7    0    0    0    0
#  11 CG   C_ALI    3   -2.0082    3.5313   -0.7874   -1.1917    7   12   13   15    0
#  12 HG2  H_ALI    0    1.0041    3.8985    0.2382   -1.2290   11    0    0    0   14
#  13 HG3  H_ALI    0    1.0041    3.8985   -1.2239   -0.2629   11    0    0    0   14
#  14 QG   PSEUD    0    0.0000    3.8985   -0.4928   -0.7459   11    0    0    0    0
#  15 CD   C_BYL    2    9.1075    4.0796   -1.5749   -2.3835   11   16   17    0    0
#  16 OE1  O_BYL    2   -6.5620    5.3043   -1.6818   -2.5453   15    0    0    0    0
#  17 OE2  O_HYD    2   -6.3781    3.1835   -2.0873   -3.1571   15   18    0    0    0
#  18 HE2  H_OXY    0    3.8325    3.6219   -2.5827   -3.9070   17    0    0    0    0
#  19 C    C_BYL    2    8.2024    1.9838    1.4350    0.0000    5   20   21    0    0
#  20 O    O_BYL    2   -7.0004    1.2064    2.3882    0.0000   19    0    0    0    0
#  21 N    N_AMI    2   -6.4912    3.3043    1.5436    0.0000   19    0    0    0    0
#RESIDUE   GLY  G    3   11    3   10
#   1 OMEGA   -1    2   10.0000    2    1    3    4    0
#   2 PHI      0    0    0.0000    1    3    5    9    0
#   3 PSI      0    0    0.0000    3    5    9   11    0
#   1 C    C_BYL    2    8.2024   -0.6824   -1.1357    0.0000    2    3    0    0    0
#   2 O    O_BYL    2   -7.0004   -0.1723   -2.2550    0.0000    1    0    0    0    0
#   3 N    N_AMI    2   -6.2650    0.0000    0.0000    0.0000    1    4    5    0    0
#   4 HN   H_AMI    0    3.2103   -0.4226    0.9063    0.0000    3    0    0    0    0
#   5 CA   C_ALI    3   -0.1556    1.4530    0.0000    0.0000    3    6    7    9    0
#   6 HA1  H_ALI    0    1.0041    1.8202   -0.5343    0.8762    5    0    0    0    8
#   7 HA2  H_ALI    0    1.0041    1.8202   -0.5343   -0.8762    5    0    0    0    8
#   8 QA   PSEUD    0    0.0000    1.8202   -0.5343    0.0000    5    0    0    0    0
#   9 C    C_BYL    2    8.2024    2.0013    1.4284    0.0000    5   10   11    0    0
#  10 O    O_BYL    2   -7.0004    1.2356    2.3910    0.0000    9    0    0    0    0
#  11 N    N_AMI    2   -6.4912    3.3231    1.5208    0.0000    9    0    0    0    0
#RESIDUE   HIST H    5   21    3   20
#   1 OMEGA   -1    2   10.0000    2    1    3    4    0
#   2 PHI      0    0    0.0000    1    3    5   19    0
#   3 CHI1     1    3    1.3500    3    5    7   11   18
#   4 CHI2     0    0    0.0000    5    7   11   12   18
#   5 PSI      0    0    0.0000    3    5   19   21    0
#   1 C    C_BYL    2    8.2024   -0.6824   -1.1357    0.0000    2    3    0    0    0
#   2 O    O_BYL    2   -7.0004   -0.1723   -2.2550    0.0000    1    0    0    0    0
#   3 N    N_AMI    2   -6.4912    0.0000    0.0000    0.0000    1    4    5    0    0
#   4 HN   H_AMI    0    3.2103   -0.4226    0.9063    0.0000    3    0    0    0    0
#   5 CA   C_ALI    3    1.1597    1.4530    0.0000    0.0000    3    6    7   19    0
#   6 HA   H_ALI    0    0.3677    1.7658   -0.4880    0.9231    5    0    0    0    0
#   7 CB   C_ALI    3   -1.3718    1.9963   -0.8228   -1.1699    5    8    9   11    0
#   8 HB2  H_ALI    0    0.7495    1.6134   -1.8405   -1.0938    7    0    0    0   10
#   9 HB3  H_ALI    0    0.7495    1.6134   -0.4071   -2.1019    7    0    0    0   10
#  10 QB   PSEUD    0    0.0000    1.6134   -1.1238   -1.5979    7    0    0    0    0
#  11 CG   C_VIN    2    1.8243    3.5040   -0.8713   -1.2388    7   12   13    0    0
#  12 ND1  N_AMI    2   -4.2002    4.1876   -1.5636   -2.2231   11   16    0    0    0
#  13 CD2  C_ARO    2    0.9758    4.4515   -0.3061   -0.4368   11   14   15    0    0
#  14 HD2  H_ARO    0    0.3253    4.2578    0.3120    0.4399   13    0    0    0    0
#  15 NE2  N_AMI    2   -4.6386    5.6488   -0.6364   -0.9048   13   16   18    0    0
#  16 CE1  C_ARO    2    3.3234    5.4873   -1.4156   -2.0126   12   15   17    0    0
#  17 HE1  H_ARO    0    0.1980    6.2871   -1.8416   -2.6184   16    0    0    0    0
#  18 HE2  H_AMI    0    2.6163    6.5236   -0.3132   -0.5438   15    0    0    0    0
#  19 C    C_BYL    2    8.2024    1.9662    1.4413    0.0000    5   20   21    0    0
#  20 O    O_BYL    2   -7.0004    1.1773    2.3850    0.0000   19    0    0    0    0
#  21 N    N_AMI    2   -6.4912    3.2853    1.5659    0.0000   19    0    0    0    0
#RESIDUE   HIS+ H    5   22    3   21
#   1 OMEGA   -1    2   10.0000    2    1    3    4    0
#   2 PHI      0    0    0.0000    1    3    5   20    0
#   3 CHI1     1    3    1.3500    3    5    7   11   19
#   4 CHI2     0    0    0.0000    5    7   11   12   19
#   5 PSI      0    0    0.0000    3    5   20   22    0
#   1 C    C_BYL    2    8.2024   -0.6824   -1.1357    0.0000    2    3    0    0    0
#   2 O    O_BYL    2   -7.0004   -0.1723   -2.2550    0.0000    1    0    0    0    0
#   3 N    N_AMI    2   -6.4912    0.0000    0.0000    0.0000    1    4    5    0    0
#   4 HN   H_AMI    0    3.2103   -0.4226    0.9063    0.0000    3    0    0    0    0
#   5 CA   C_ALI    3    1.1597    1.4530    0.0000    0.0000    3    6    7   20    0
#   6 HA   H_ALI    0    0.3677    1.7658   -0.4880    0.9231    5    0    0    0    0
#   7 CB   C_ALI    3   -0.9051    1.9963   -0.8228   -1.1699    5    8    9   11    0
#   8 HB2  H_ALI    0    1.1879    1.6134   -1.8405   -1.0938    7    0    0    0   10
#   9 HB3  H_ALI    0    1.1879    1.6134   -0.4071   -2.1019    7    0    0    0   10
#  10 QB   PSEUD    0    0.0000    1.6134   -1.1238   -1.5979    7    0    0    0    0
#  11 CG   C_VIN    2    2.7294    3.5040   -0.8713   -1.2388    7   12   13    0    0
#  12 ND1  N_AMO    2   -3.6487    4.1876   -1.5636   -2.2231   11   14   15    0    0
#  13 CD2  C_ARO    2    1.8243    4.4515   -0.3061   -0.4368   11   16   17    0    0
#  14 HD1  H_AMI    0    5.0063    3.7713   -2.0867   -2.9668   12    0    0    0    0
#  15 CE1  C_ARO    2    5.0063    5.4873   -1.4156   -2.0126   12   16   18    0    0
#  16 NE2  N_AMO    2   -3.6487    5.6488   -0.6364   -0.9048   13   15   19    0    0
#  17 HD2  H_ARO    0    2.4607    4.2578    0.3120    0.4399   13    0    0    0    0
#  18 HE1  H_ARO    0    2.7294    6.2871   -1.8416   -2.6184   15    0    0    0    0
#  19 HE2  H_AMI    0    4.8366    6.5236   -0.3132   -0.5438   16    0    0    0    0
#  20 C    C_BYL    2    8.2024    1.9662    1.4413    0.0000    5   21   22    0    0
#  21 O    O_BYL    2   -7.0004    1.1773    2.3850    0.0000   20    0    0    0    0
#  22 N    N_AMI    2   -6.4912    3.2853    1.5659    0.0000   20    0    0    0    0
#RESIDUE   HIS  H    5   21    3   20
#   1 OMEGA   -1    2   10.0000    2    1    3    4    0
#   2 PHI      0    0    0.0000    1    3    5   19    0
#   3 CHI1     1    3    1.3500    3    5    7   11   18
#   4 CHI2     0    0    0.0000    5    7   11   12   18
#   5 PSI      0    0    0.0000    3    5   19   21    0
#   1 C    C_BYL    2    8.2024   -0.6824   -1.1357    0.0000    2    3    0    0    0
#   2 O    O_BYL    2   -7.0004   -0.1723   -2.2550    0.0000    1    0    0    0    0
#   3 N    N_AMI    2   -6.4912    0.0000    0.0000    0.0000    1    4    5    0    0
#   4 HN   H_AMI    0    3.2103   -0.4226    0.9063    0.0000    3    0    0    0    0
#   5 CA   C_ALI    3    1.1597    1.4530    0.0000    0.0000    3    6    7   19    0
#   6 HA   H_ALI    0    0.3677    1.7658   -0.4880    0.9231    5    0    0    0    0
#   7 CB   C_ALI    3   -0.7212    1.9963   -0.8228   -1.1699    5    8    9   11    0
#   8 HB2  H_ALI    0    0.2687    1.6134   -1.8405   -1.0938    7    0    0    0   10
#   9 HB3  H_ALI    0    0.2687    1.6134   -0.4071   -2.1019    7    0    0    0   10
#  10 QB   PSEUD    0    0.0000    1.6134   -1.1238   -1.5979    7    0    0    0    0
#  11 CG   C_VIN    2    1.0041    3.5040   -0.8713   -1.2388    7   12   13    0    0
#  12 ND1  N_AMI    2   -4.5538    4.1876   -1.5636   -2.2231   11   14   15    0    0
#  13 CD2  C_ARO    2    1.4566    4.4515   -0.3061   -0.4368   11   16   17    0    0
#  14 HD1  H_AMI    0    2.7294    3.7713   -2.0867   -2.9668   12    0    0    0    0
#  15 CE1  C_ARO    2    3.4648    5.4873   -1.4156   -2.0126   12   16   18    0    0
#  16 NE2  N_AMI    2   -4.3699    5.6488   -0.6364   -0.9048   13   15    0    0    0
#  17 HD2  H_ARO    0    0.6364    4.2578    0.3120    0.4399   13    0    0    0    0
#  18 HE1  H_ARO    0    0.3677    6.2871   -1.8416   -2.6184   15    0    0    0    0
#  19 C    C_BYL    2    8.2024    1.9662    1.4413    0.0000    5   20   21    0    0
#  20 O    O_BYL    2   -7.0004    1.1773    2.3850    0.0000   19    0    0    0    0
#  21 N    N_AMI    2   -6.4912    3.2853    1.5659    0.0000   19    0    0    0    0
#RESIDUE   ILE  I    7   25    3   24
#   1 OMEGA   -1    2   10.0000    2    1    3    4    0
#   2 PHI      0    0    0.0000    1    3    5   23    0
#   3 CHI1     1    3    1.3500    3    5    7   14   22
#   4 CHI22    1    3    1.3500    5    7   10   11   13
#   5 CHI21    1    3    1.3500    5    7   14   19   22
#   6 CHI31    1    3    1.3500    7   14   19   20   22
#   7 PSI      0    0    0.0000    3    5   23   25    0
#   1 C    C_BYL    2    8.2024   -0.6824   -1.1357    0.0000    2    3    0    0    0
#   2 O    O_BYL    2   -7.0004   -0.1723   -2.2550    0.0000    1    0    0    0    0
#   3 N    N_AMI    2   -6.4912    0.0000    0.0000    0.0000    1    4    5    0    0
#   4 HN   H_AMI    0    3.2103   -0.4226    0.9063    0.0000    3    0    0    0    0
#   5 CA   C_ALI    3    1.1597    1.4530    0.0000    0.0000    3    6    7   23    0
#   6 HA   H_ALI    0    0.3677    1.7797   -0.4805    0.9222    5    0    0    0    0
#   7 CB   C_ALI    3   -0.0849    1.9888   -0.8392   -1.1617    5    8   10   14    0
#   8 HB   H_ALI    0    0.4525    1.6625   -1.8692   -1.0179    7    0    0    0    0
#   9 QG2  PSEUD    0    0.0000    1.2708   -0.2506   -2.8117   10    0    0    0    0
#  10 CG2  C_ALI    3   -1.3576    1.4086   -0.3635   -2.4951    7   11   12   13    0
#  11 HG21 H_ALI    0    0.4525    1.8059   -0.9770   -3.3037   10    0    0    0    9
#  12 HG22 H_ALI    0    0.4525    0.3225   -0.4528   -2.4713   10    0    0    0    9
#  13 HG23 H_ALI    0    0.4525    1.6840    0.6781   -2.6602   10    0    0    0    9
#  14 CG1  C_ALI    3   -0.3536    3.5188   -0.8471   -1.1725    7   15   16   19    0
#  15 HG12 H_ALI    0    0.2687    3.8906    0.1742   -1.2551   14    0    0    0   17
#  16 HG13 H_ALI    0    0.2687    3.8906   -1.2463   -0.2289   14    0    0    0   17
#  17 QG1  PSEUD    0    0.0000    3.8906   -0.5361   -0.7420   14    0    0    0    0
#  18 QD1  PSEUD    0    0.0000    4.1818   -1.8856   -2.6101   19    0    0    0    0
#  19 CD1  C_ALI    3   -1.3576    4.0546   -1.6863   -2.3342   14   20   21   22    0
#  20 HD11 H_ALI    0    0.4525    5.1444   -1.6749   -2.3183   19    0    0    0   18
#  21 HD12 H_ALI    0    0.4525    3.7005   -2.7124   -2.2348   19    0    0    0   18
#  22 HD13 H_ALI    0    0.4525    3.7005   -1.2695   -3.2771   19    0    0    0   18
#  23 C    C_BYL    2    8.2024    1.9587    1.4440    0.0000    5   24   25    0    0
#  24 O    O_BYL    2   -7.0004    1.1648    2.3835    0.0000   23    0    0    0    0
#  25 N    N_AMI    2   -6.4912    3.2772    1.5756    0.0000   23    0    0    0    0
#RESIDUE   LEU  L    7   26    3   25
#   1 OMEGA   -1    2   10.0000    2    1    3    4    0
#   2 PHI      0    0    0.0000    1    3    5   24    0
#   3 CHI1     1    3    1.3500    3    5    7   11   23
#   4 CHI2     1    3    1.3500    5    7   11   15   23
#   5 CHI31    1    3    1.3500    7   11   15   16   18
#   6 CHI32    1    3    1.3500    7   11   19   20   22
#   7 PSI      0    0    0.0000    3    5   24   26    0
#   1 C    C_BYL    2    8.2024   -0.6824   -1.1357    0.0000    2    3    0    0    0
#   2 O    O_BYL    2   -7.0004   -0.1723   -2.2550    0.0000    1    0    0    0    0
#   3 N    N_AMI    2   -6.4912    0.0000    0.0000    0.0000    1    4    5    0    0
#   4 HN   H_AMI    0    3.2103   -0.4226    0.9063    0.0000    3    0    0    0    0
#   5 CA   C_ALI    3    1.1597    1.4530    0.0000    0.0000    3    6    7   24    0
#   6 HA   H_ALI    0    0.3677    1.7797   -0.4805    0.9222    5    0    0    0    0
#   7 CB   C_ALI    3   -0.5374    1.9888   -0.8392   -1.1617    5    8    9   11    0
#   8 HB2  H_ALI    0    0.3960    1.5941   -1.8507   -1.0656    7    0    0    0   10
#   9 HB3  H_ALI    0    0.3960    1.5941   -0.4301   -2.0917    7    0    0    0   10
#  10 QB   PSEUD    0    0.0000    1.5941   -1.1404   -1.5787    7    0    0    0    0
#  11 CG   C_ALI    3   -0.1838    3.5118   -0.9251   -1.2806    7   12   15   19    0
#  12 HG   H_ALI    0    0.4525    3.8975   -1.4120   -0.3849   11    0    0    0    0
#  13 QD1  PSEUD    0    0.0000    4.0177   -1.9934   -2.7595   15    0    0    0   23
#  14 QD2  PSEUD    0    0.0000    4.2850    0.8015   -1.3553   19    0    0    0   23
#  15 CD1  C_ALI    3   -1.3435    3.9206   -1.7884   -2.4757   11   16   17   18    0
#  16 HD11 H_ALI    0    0.4525    5.0080   -1.8326   -2.5369   15    0    0    0   13
#  17 HD12 H_ALI    0    0.4525    3.5225   -2.7953   -2.3497   15    0    0    0   13
#  18 HD13 H_ALI    0    0.4525    3.5225   -1.3524   -3.3920   15    0    0    0   13
#  19 CD2  C_ALI    3   -1.3435    4.1366    0.4702   -1.3410   11   20   21   22    0
#  20 HD21 H_ALI    0    0.4525    5.2196    0.3800   -1.4253   19    0    0    0   14
#  21 HD22 H_ALI    0    0.4525    3.7480    1.0051   -2.2076   19    0    0    0   14
#  22 HD23 H_ALI    0    0.4525    3.8873    1.0195   -0.4331   19    0    0    0   14
#  23 QQD  PSEUD    0    0.0000    4.1513   -0.5960   -2.0574   15   19    0    0    0
#  24 C    C_BYL    2    8.2024    1.9587    1.4440    0.0000    5   25   26    0    0
#  25 O    O_BYL    2   -7.0004    1.1648    2.3835    0.0000   24    0    0    0    0
#  26 N    N_AMI    2   -6.4912    3.2772    1.5756    0.0000   24    0    0    0    0
#RESIDUE   LYS+ K    8   30    3   29
#   1 OMEGA   -1    2   10.0000    2    1    3    4    0
#   2 PHI      0    0    0.0000    1    3    5   28    0
#   3 CHI1     1    3    1.3500    3    5    7   11   27
#   4 CHI2     1    3    1.3500    5    7   11   15   27
#   5 CHI3     1    3    1.3500    7   11   15   19   27
#   6 CHI4     1    3    1.3500   11   15   19   23   27
#   7 CHI5     1    3    0.9000   15   19   23   24   27
#   8 PSI      0    0    0.0000    3    5   28   30    0
#   1 C    C_BYL    2    8.2024   -0.6824   -1.1357    0.0000    2    3    0    0    0
#   2 O    O_BYL    2   -7.0004   -0.1723   -2.2550    0.0000    1    0    0    0    0
#   3 N    N_AMI    2   -6.4912    0.0000    0.0000    0.0000    1    4    5    0    0
#   4 HN   H_AMI    0    3.2103   -0.4226    0.9063    0.0000    3    0    0    0    0
#   5 CA   C_ALI    3    1.1597    1.4530    0.0000    0.0000    3    6    7   28    0
#   6 HA   H_ALI    0    0.3677    1.7797   -0.4805    0.9222    5    0    0    0    0
#   7 CB   C_ALI    3   -0.5515    1.9888   -0.8392   -1.1617    5    8    9   11    0
#   8 HB2  H_ALI    0    0.2687    1.6169   -1.8605   -1.0798    7    0    0    0   10
#   9 HB3  H_ALI    0    0.2687    1.6169   -0.4400   -2.1053    7    0    0    0   10
#  10 QB   PSEUD    0    0.0000    1.6169   -1.1502   -1.5926    7    0    0    0    0
#  11 CG   C_ALI    3   -0.4525    3.5188   -0.8471   -1.1725    7   12   13   15    0
#  12 HG2  H_ALI    0    0.3677    3.8906    0.1742   -1.2551   11    0    0    0   14
#  13 HG3  H_ALI    0    0.3677    3.8906   -1.2463   -0.2289   11    0    0    0   14
#  14 QG   PSEUD    0    0.0000    3.8906   -0.5361   -0.7420   11    0    0    0    0
#  15 CD   C_ALI    3   -2.0930    4.0546   -1.6863   -2.3342   11   16   17   19    0
#  16 HD2  H_ALI    0    1.8243    3.6827   -2.7076   -2.2516   15    0    0    0   18
#  17 HD3  H_ALI    0    1.8243    3.6827   -1.2871   -3.2778   15    0    0    0   18
#  18 QD   PSEUD    0    0.0000    3.6827   -1.9974   -2.7647   15    0    0    0    0
#  19 CE   C_ALI    3    0.9051    5.5845   -1.6941   -2.3450   15   20   21   23    0
#  20 HE2  H_ALI    0    2.1920    5.9587   -0.6738   -2.4289   19    0    0    0   22
#  21 HE3  H_ALI    0    2.1920    5.9587   -2.0943   -1.4027   19    0    0    0   22
#  22 QE   PSEUD    0    0.0000    5.9587   -1.3841   -1.9158   19    0    0    0    0
#  23 NZ   N_AMO    3   -5.8266    6.0907   -2.5086   -3.4723   19   24   25   26    0
#  24 HZ1  H_AMI    0    5.8266    7.0907   -2.5032   -3.4648   23    0    0    0   27
#  25 HZ2  H_AMI    0    5.8266    5.7617   -3.4483   -3.3787   23    0    0    0   27
#  26 HZ3  H_AMI    0    5.8266    5.7617   -2.1246   -4.3351   23    0    0    0   27
#  27 QZ   PSEUD    0    0.0000    6.2047   -2.6920   -3.7262   23    0    0    0    0
#  28 C    C_BYL    2    8.2024    1.9587    1.4440    0.0000    5   29   30    0    0
#  29 O    O_BYL    2   -7.0004    1.1648    2.3835    0.0000   28    0    0    0    0
#  30 N    N_AMI    2   -6.4912    3.2772    1.5756    0.0000   28    0    0    0    0
#RESIDUE   LYS  K    8   29    3   28
#   1 OMEGA   -1    2   10.0000    2    1    3    4    0
#   2 PHI      0    0    0.0000    1    3    5   27    0
#   3 CHI1     1    3    1.3500    3    5    7   11   26
#   4 CHI2     1    3    1.3500    5    7   11   15   26
#   5 CHI3     1    3    1.3500    7   11   15   19   26
#   6 CHI4     1    3    1.3500   11   15   19   23   26
#   7 CHI5     1    3    0.9000   15   19   23   24   26
#   8 PSI      0    0    0.0000    3    5   27   29    0
#   1 C    C_BYL    2    8.2024   -0.6824   -1.1357    0.0000    2    3    0    0    0
#   2 O    O_BYL    2   -7.0004   -0.1723   -2.2550    0.0000    1    0    0    0    0
#   3 N    N_AMI    2   -6.4912    0.0000    0.0000    0.0000    1    4    5    0    0
#   4 HN   H_AMI    0    3.2103   -0.4226    0.9063    0.0000    3    0    0    0    0
#   5 CA   C_ALI    3    1.1597    1.4530    0.0000    0.0000    3    6    7   27    0
#   6 HA   H_ALI    0    0.3677    1.7797   -0.4805    0.9222    5    0    0    0    0
#   7 CB   C_ALI    3   -0.5515    1.9888   -0.8392   -1.1617    5    8    9   11    0
#   8 HB2  H_ALI    0    0.2687    1.6169   -1.8605   -1.0798    7    0    0    0   10
#   9 HB3  H_ALI    0    0.2687    1.6169   -0.4400   -2.1053    7    0    0    0   10
#  10 QB   PSEUD    0    0.0000    1.6169   -1.1502   -1.5926    7    0    0    0    0
#  11 CG   C_ALI    3   -0.4525    3.5188   -0.8471   -1.1725    7   12   13   15    0
#  12 HG2  H_ALI    0    0.3677    3.8906    0.1742   -1.2551   11    0    0    0   14
#  13 HG3  H_ALI    0    0.3677    3.8906   -1.2463   -0.2289   11    0    0    0   14
#  14 QG   PSEUD    0    0.0000    3.8906   -0.5361   -0.7420   11    0    0    0    0
#  15 CD   C_ALI    3   -0.5515    4.0546   -1.6863   -2.3342   11   16   17   19    0
#  16 HD2  H_ALI    0    0.3677    3.6827   -2.7076   -2.2516   15    0    0    0   18
#  17 HD3  H_ALI    0    0.3677    3.6827   -1.2871   -3.2778   15    0    0    0   18
#  18 QD   PSEUD    0    0.0000    3.6827   -1.9974   -2.7647   15    0    0    0    0
#  19 CE   C_ALI    3    2.0082    5.5845   -1.6941   -2.3450   15   20   21   23    0
#  20 HE2  H_ALI    0   -0.0849    5.9587   -0.6738   -2.4289   19    0    0    0   22
#  21 HE3  H_ALI    0   -0.0849    5.9587   -2.0943   -1.4027   19    0    0    0   22
#  22 QE   PSEUD    0    0.0000    5.9587   -1.3841   -1.9158   19    0    0    0    0
#  23 NZ   N_AMI    3   -7.1983    6.0907   -2.5086   -3.4723   19   24   25    0    0
#  24 HZ1  H_AMI    0    2.7294    7.1041   -2.5293   -3.5010   23    0    0    0   26
#  25 HZ2  H_AMI    0    2.7294    5.7789   -3.4718   -3.4151   23    0    0    0   26
#  26 QZ   PSEUD    0    0.0000    6.4415   -3.0006   -3.4581   23    0    0    0    0
#  27 C    C_BYL    2    8.2024    1.9587    1.4440    0.0000    5   28   29    0    0
#  28 O    O_BYL    2   -7.0004    1.1648    2.3835    0.0000   27    0    0    0    0
#  29 N    N_AMI    2   -6.4912    3.2772    1.5756    0.0000   27    0    0    0    0
#RESIDUE   MET  M    7   23    3   22
#   1 OMEGA   -1    2   10.0000    2    1    3    4    0
#   2 PHI      0    0    0.0000    1    3    5   21    0
#   3 CHI1     1    3    1.3500    3    5    7   11   20
#   4 CHI2     1    3    1.3500    5    7   11   15   20
#   5 CHI3     1    3    1.0000    7   11   15   17   20
#   6 CHI4     1    3    1.0000   11   15   17   18   20
#   7 PSI      0    0    0.0000    3    5   21   23    0
#   1 C    C_BYL    2    8.2024   -0.6824   -1.1357    0.0000    2    3    0    0    0
#   2 O    O_BYL    2   -7.0004   -0.1723   -2.2550    0.0000    1    0    0    0    0
#   3 N    N_AMI    2   -6.4912    0.0000    0.0000    0.0000    1    4    5    0    0
#   4 HN   H_AMI    0    3.2103   -0.4226    0.9063    0.0000    3    0    0    0    0
#   5 CA   C_ALI    3    1.1597    1.4530    0.0000    0.0000    3    6    7   21    0
#   6 HA   H_ALI    0    0.3677    1.7457   -0.5091    0.9183    5    0    0    0    0
#   7 CB   C_ALI    3   -0.1838    1.9637   -0.7431   -1.2361    5    8    9   11    0
#   8 HB2  H_ALI    0    0.5515    1.5826   -1.7643   -1.2341    7    0    0    0   10
#   9 HB3  H_ALI    0    0.5515    1.5826   -0.2624   -2.1371    7    0    0    0   10
#  10 QB   PSEUD    0    0.0000    1.5826   -1.0134   -1.6856    7    0    0    0    0
#  11 CG   C_ALI    3   -2.1920    3.4932   -0.7637   -1.2704    7   12   13   15    0
#  12 HG2  H_ALI    0    0.8202    3.8789    0.2557   -1.2752   11    0    0    0   14
#  13 HG3  H_ALI    0    0.8202    3.8789   -1.2461   -0.3722   11    0    0    0   14
#  14 QG   PSEUD    0    0.0000    3.8789   -0.4952   -0.8237   11    0    0    0    0
#  15 SD   S_RED    3    0.6364    4.0596   -1.6359   -2.7211   11   17    0    0    0
#  16 QE   PSEUD    0    0.0000    6.1844   -1.4722   -2.4490   15    0    0    0    0
#  17 CE   C_ALI    3   -3.4648    5.8250   -1.4999   -2.4950   15   18   19   20    0
#  18 HE1  H_ALI    0    1.0041    6.3363   -1.9959   -3.3200   17    0    0    0   16
#  19 HE2  H_ALI    0    1.0041    6.1084   -0.4476   -2.4720   17    0    0    0   16
#  20 HE3  H_ALI    0    1.0041    6.1084   -1.9731   -1.5549   17    0    0    0   16
#  21 C    C_BYL    2    8.2024    2.0013    1.4284    0.0000    5   22   23    0    0
#  22 O    O_BYL    2   -7.0004    1.2356    2.3910    0.0000   21    0    0    0    0
#  23 N    N_AMI    2   -6.4912    3.3231    1.5208    0.0000   21    0    0    0    0
#RESIDUE   PHE  F    5   27    3   26
#   1 OMEGA   -1    2   10.0000    2    1    3    4    0
#   2 PHI      0    0    0.0000    1    3    5   25    0
#   3 CHI1     1    3    1.3500    3    5    7   14   24
#   4 CHI2     0    0    0.0000    5    7   14   15   24
#   5 PSI      0    0    0.0000    3    5   25   27    0
#   1 C    C_BYL    2    8.2024   -0.6824   -1.1357    0.0000    2    3    0    0    0
#   2 O    O_BYL    2   -7.0004   -0.1723   -2.2550    0.0000    1    0    0    0    0
#   3 N    N_AMI    2   -6.4912    0.0000    0.0000    0.0000    1    4    5    0    0
#   4 HN   H_AMI    0    3.2103   -0.4226    0.9063    0.0000    3    0    0    0    0
#   5 CA   C_ALI    3    1.1597    1.4530    0.0000    0.0000    3    6    7   25    0
#   6 HA   H_ALI    0    0.3677    1.7765   -0.5114    0.9066    5    0    0    0    0
#   7 CB   C_ALI    3   -0.7354    1.9003   -0.7053   -1.2819    5    8    9   14    0
#   8 HB2  H_ALI    0    0.4525    1.4836   -1.7124   -1.2948    7    0    0    0   10
#   9 HB3  H_ALI    0    0.4525    1.4836   -0.1770   -2.1395    7    0    0    0   10
#  10 QB   PSEUD    0    0.0000    1.4836   -0.9447   -1.7171    7    0    0    0    0
#  11 QD   PSEUD    0    0.0000    3.5529   -0.8031   -1.4598   15   23    0    0   13
#  12 QE   PSEUD    0    0.0000    6.0442   -0.9505   -1.7278   17   21    0    0   13
#  13 QR   PSEUD    0    0.0000    4.7986   -0.8768   -1.5938   15   17   21   23    0
#  14 CG   C_VIN    2    0.3677    3.4189   -0.7951   -1.4453    7   15   23    0    0
#  15 CD1  C_ARO    2   -0.2687    3.9503   -1.3986   -2.5422   14   16   17    0    0
#  16 HD1  H_ARO    0    0.1838    3.2943   -1.8182   -3.3049   15    0    0    0   11
#  17 CE1  C_ARO    2   -0.2687    5.3597   -1.4820   -2.6938   15   18   19    0    0
#  18 HE1  H_ARO    0    0.1838    5.7856   -1.9656   -3.5729   17    0    0    0   12
#  19 CZ   C_ARO    2    0.2687    6.1782   -0.9585   -1.7422   17   20   21    0    0
#  20 HZ   H_ARO    0    0.0849    7.2601   -1.0225   -1.8585   19    0    0    0   13
#  21 CE2  C_ARO    2   -0.2687    5.6468   -0.3550   -0.6453   19   22   23    0    0
#  22 HE2  H_ARO    0    0.1838    6.3028    0.0646    0.1174   21    0    0    0   12
#  23 CD2  C_ARO    2   -0.2687    4.2374   -0.2716   -0.4937   14   21   24    0    0
#  24 HD2  H_ARO    0    0.1838    3.8115    0.2120    0.3854   23    0    0    0   11
#  25 C    C_BYL    2    8.2024    2.0013    1.4284    0.0000    5   26   27    0    0
#  26 O    O_BYL    2   -7.0004    1.2356    2.3910    0.0000   25    0    0    0    0
#  27 N    N_AMI    2   -6.4912    3.3231    1.5208    0.0000   25    0    0    0    0
#RESIDUE   PRO  P    2   20    3   19
#   1 OMEGA   -1    2   10.0000    2    1    3    4    0
#   2 PSI      0    0    0.0000    3    5   18   20    0
#   1 C    C_BYL    2    8.2024   -0.7005    0.3017    1.1260    2    3    0    0    0
#   2 O    O_BYL    2   -7.0004   -0.1904    0.5914    2.2071    1    0    0    0    0
#   3 N    N_AMI    2   -5.1902    0.0000    0.0000    0.0000    1    4    5    0    0
#   4 CD   C_ALI    3    1.8243   -0.5705   -0.3478   -1.2981    3   11   15   16    0
#   5 CA   C_ALI    3    0.9051    1.4530    0.0000    0.0000    3    6    7   18    0
#   6 HA   H_ALI    0    0.7212    1.8001   -0.4260    0.8355    5    0    0    0    0
#   7 CB   C_ALI    3   -0.4525    1.8464   -0.7872   -1.2393    5    8    9   11    0
#   8 HB2  H_ALI    0    0.2687    2.6920   -0.3217   -1.7456    7    0    0    0   10
#   9 HB3  H_ALI    0    0.2687    2.1502   -1.8009   -0.9780    7    0    0    0   10
#  10 QB   PSEUD    0    0.0000    2.4211   -1.0613   -1.3618    7    0    0    0    0
#  11 CG   C_ALI    3   -0.9051    0.6166   -0.8003   -2.1326    4    7   12   13    0
#  12 HG2  H_ALI    0    0.4525    0.7579   -0.1376   -2.9864   11    0    0    0   14
#  13 HG3  H_ALI    0    0.4525    0.4445   -1.8004   -2.5305   11    0    0    0   14
#  14 QG   PSEUD    0    0.0000    0.6012   -0.9690   -2.7585   11    0    0    0    0
#  15 HD2  H_ALI    0    0.1838   -1.0711    0.5072   -1.7525    4    0    0    0   17
#  16 HD3  H_ALI    0    0.1838   -1.3137   -1.1396   -1.2047    4    0    0    0   17
#  17 QD   PSEUD    0    0.0000   -1.1924   -0.3162   -1.4786    4    0    0    0    0
#  18 C    C_BYL    2    8.2873    2.0013    1.4284    0.0000    5   19   20    0    0
#  19 O    O_BYL    2   -7.0004    1.2356    2.3910    0.0000   18    0    0    0    0
#  20 N    N_AMI    2   -6.4912    3.3231    1.5208    0.0000   18    0    0    0    0
#RESIDUE   SER  S    5   15    3   14
#   1 OMEGA   -1    2   10.0000    2    1    3    4    0
#   2 PHI      0    0    0.0000    1    3    5   13    0
#   3 CHI1     1    3    1.3500    3    5    7   11   12
#   4 CHI2     1    3    0.3000    5    7   11   12   12
#   5 PSI      0    0    0.0000    3    5   13   15    0
#   1 C    C_BYL    2    8.2024   -0.6824   -1.1357    0.0000    2    3    0    0    0
#   2 O    O_BYL    2   -7.0004   -0.1723   -2.2550    0.0000    1    0    0    0    0
#   3 N    N_AMI    2   -6.4912    0.0000    0.0000    0.0000    1    4    5    0    0
#   4 HN   H_AMI    0    3.2103   -0.4226    0.9063    0.0000    3    0    0    0    0
#   5 CA   C_ALI    3    1.1597    1.4530    0.0000    0.0000    3    6    7   13    0
#   6 HA   H_ALI    0    0.3677    1.7416   -0.5122    0.9178    5    0    0    0    0
#   7 CB   C_ALI    3    2.3617    2.0038   -0.7653   -1.2049    5    8    9   11    0
#   8 HB2  H_ALI    0    0.3677    1.6328   -1.7901   -1.1839    7    0    0    0   10
#   9 HB3  H_ALI    0    0.3677    1.6328   -0.3109   -2.1235    7    0    0    0   10
#  10 QB   PSEUD    0    0.0000    1.6328   -1.0505   -1.6537    7    0    0    0    0
#  11 OG   O_HYD    3   -5.6427    3.4286   -0.7774   -1.2238    7   12    0    0    0
#  12 HG   H_OXY    0    3.0971    3.7558   -1.2840   -2.0214   11    0    0    0    0
#  13 C    C_BYL    2    8.2024    1.9763    1.4377    0.0000    5   14   15    0    0
#  14 O    O_BYL    2   -7.0004    1.1939    2.3868    0.0000   13    0    0    0    0
#  15 N    N_AMI    2   -6.4912    3.2963    1.5532    0.0000   13    0    0    0    0
#RESIDUE   THR  T    6   18    3   17
#   1 OMEGA   -1    2   10.0000    2    1    3    4    0
#   2 PHI      0    0    0.0000    1    3    5   16    0
#   3 CHI1     1    3    1.3500    3    5    7   10   15
#   4 CHI21    1    3    0.3000    5    7   10   11   11
#   5 CHI22    1    3    1.3500    5    7   12   13   15
#   6 PSI      0    0    0.0000    3    5   16   18    0
#   1 C    C_BYL    2    8.2024   -0.6824   -1.1357    0.0000    2    3    0    0    0
#   2 O    O_BYL    2   -7.0004   -0.1723   -2.2550    0.0000    1    0    0    0    0
#   3 N    N_AMI    2   -6.4912    0.0000    0.0000    0.0000    1    4    5    0    0
#   4 HN   H_AMI    0    3.2103   -0.4226    0.9063    0.0000    3    0    0    0    0
#   5 CA   C_ALI    3    1.1597    1.4530    0.0000    0.0000    3    6    7   16    0
#   6 HA   H_ALI    0    0.3677    1.7966   -0.4689    0.9220    5    0    0    0    0
#   7 CB   C_ALI    3    2.9133    1.9258   -0.8241   -1.1992    5    8   10   12    0
#   8 HB   H_ALI    0    0.2687    1.5187   -1.8345   -1.1619    7    0    0    0    0
#   9 QG2  PSEUD    0    0.0000    1.5244    0.0064   -2.8527   12    0    0    0    0
#  10 OG1  O_HYD    3   -5.6569    3.3475   -0.7692   -1.1194    7   11    0    0    0
#  11 HG1  H_OXY    0    3.0971    3.7526   -1.2870   -1.8728   10    0    0    0    0
#  12 CG2  C_ALI    3   -1.7253    1.6014   -0.1530   -2.5354    7   13   14   15    0
#  13 HG21 H_ALI    0    0.5515    1.9584   -0.7795   -3.3528   12    0    0    0    9
#  14 HG22 H_ALI    0    0.5515    0.5230   -0.0208   -2.6232   12    0    0    0    9
#  15 HG23 H_ALI    0    0.5515    2.0917    0.8194   -2.5821   12    0    0    0    9
#  16 C    C_BYL    2    8.2024    1.9863    1.4340    0.0000    5   17   18    0    0
#  17 O    O_BYL    2   -7.0004    1.2106    2.3886    0.0000   16    0    0    0    0
#  18 N    N_AMI    2   -6.4912    3.3070    1.5402    0.0000   16    0    0    0    0
#RESIDUE   TRP  W    5   28    3   27
#   1 OMEGA   -1    2   10.0000    2    1    3    4    0
#   2 PHI      0    0    0.0000    1    3    5   26    0
#   3 CHI1     1    3    1.3500    3    5    7   11   25
#   4 CHI2     0    0    0.0000    5    7   11   12   25
#   5 PSI      0    0    0.0000    3    5   26   28    0
#   1 C    C_BYL    2    8.2024   -0.6824   -1.1357    0.0000    2    3    0    0    0
#   2 O    O_BYL    2   -7.0004   -0.1723   -2.2550    0.0000    1    0    0    0    0
#   3 N    N_AMI    2   -6.4912    0.0000    0.0000    0.0000    1    4    5    0    0
#   4 HN   H_AMI    0    3.2103   -0.4226    0.9063    0.0000    3    0    0    0    0
#   5 CA   C_ALI    3    1.1597    1.4530    0.0000    0.0000    3    6    7   26    0
#   6 HA   H_ALI    0    0.3677    1.7862   -0.5002    0.9093    5    0    0    0    0
#   7 CB   C_ALI    3   -0.5515    2.0013   -0.8067   -1.1787    5    8    9   11    0
#   8 HB2  H_ALI    0    0.2687    1.6202   -1.8261   -1.1167    7    0    0    0   10
#   9 HB3  H_ALI    0    0.2687    1.6202   -0.3799   -2.1065    7    0    0    0   10
#  10 QB   PSEUD    0    0.0000    1.6202   -1.1030   -1.6116    7    0    0    0    0
#  11 CG   C_VIN    2   -0.4525    3.5292   -0.8520   -1.2448    7   12   13    0    0
#  12 CD1  C_ARO    2    1.5556    4.2978   -1.4719   -2.1507   11   16   17    0    0
#  13 CD2  C_VIN    2    0.0849    4.4485   -0.2236   -0.3267   11   14   15    0    0
#  14 CE3  C_ARO    2   -1.4566    4.2018    0.5582    0.8155   13   18   19    0    0
#  15 CE2  C_VIN    2    2.7294    5.7342   -0.5067   -0.7404   13   16   20    0    0
#  16 NE1  N_AMI    2   -5.1053    5.6397   -1.2900   -1.8848   12   15   21    0    0
#  17 HD1  H_ARO    0    0.0000    3.9116   -2.0476   -2.9918   12    0    0    0    0
#  18 HE3  H_ARO    0    1.4566    3.1962    0.7957    1.1626   14    0    0    0    0
#  19 CZ3  C_ARO    2   -0.3677    5.3514    1.0094    1.4749   14   22   23    0    0
#  20 CZ2  C_ARO    2   -1.0889    6.8740   -0.0475   -0.0695   15   23   24    0    0
#  21 HE1  H_AMI    0    2.3759    6.4722   -1.6873   -2.4654   16    0    0    0    0
#  22 HZ3  H_ARO    0    0.1838    5.2167    1.6203    2.3675   19    0    0    0    0
#  23 CH2  C_ARO    2   -0.0849    6.6525    0.7332    1.0713   19   20   25    0    0
#  24 HZ2  H_ARO    0    0.5515    7.8795   -0.2851   -0.4166   20    0    0    0    0
#  25 HH2  H_ARO    0    0.1838    7.4966    1.1227    1.6404   23    0    0    0    0
#  26 C    C_BYL    2    8.2024    1.9258    1.4551    0.0000    5   27   28    0    0
#  27 O    O_BYL    2   -7.0004    1.1108    2.3763    0.0000   26    0    0    0    0
#  28 N    N_AMI    2   -6.4912    3.2409    1.6166    0.0000   26    0    0    0    0
#RESIDUE   TYR  Y    6   28    3   27
#   1 OMEGA   -1    2   10.0000    2    1    3    4    0
#   2 PHI      0    0    0.0000    1    3    5   26    0
#   3 CHI1     1    3    1.3500    3    5    7   14   25
#   4 CHI2     0    0    0.0000    5    7   14   15   25
#   5 CHI6    -1    2    1.7500   17   19   24   25   25
#   6 PSI      0    0    0.0000    3    5   26   28    0
#   1 C    C_BYL    2    8.2024   -0.6824   -1.1357    0.0000    2    3    0    0    0
#   2 O    O_BYL    2   -7.0004   -0.1723   -2.2550    0.0000    1    0    0    0    0
#   3 N    N_AMI    2   -6.4912    0.0000    0.0000    0.0000    1    4    5    0    0
#   4 HN   H_AMI    0    3.2103   -0.4226    0.9063    0.0000    3    0    0    0    0
#   5 CA   C_ALI    3    1.1597    1.4530    0.0000    0.0000    3    6    7   26    0
#   6 HA   H_ALI    0    0.3677    1.7894   -0.5104    0.9024    5    0    0    0    0
#   7 CB   C_ALI    3   -0.7354    1.8747   -0.6954   -1.2959    5    8    9   14    0
#   8 HB2  H_ALI    0    0.4525    1.4494   -1.6989   -1.3128    7    0    0    0   10
#   9 HB3  H_ALI    0    0.4525    1.4494   -0.1548   -2.1414    7    0    0    0   10
#  10 QB   PSEUD    0    0.0000    1.4494   -0.9269   -1.7271    7    0    0    0    0
#  11 QD   PSEUD    0    0.0000    3.5334   -0.8057   -1.5014   15   22    0    0   13
#  12 QE   PSEUD    0    0.0000    6.0510   -0.9730   -1.8132   17   20    0    0   13
#  13 QR   PSEUD    0    0.0000    4.7922   -0.8893   -1.6572   15   17   20   22    0
#  14 CG   C_VIN    2    0.3677    3.3898   -0.7961   -1.4835    7   15   22    0    0
#  15 CD1  C_ARO    2   -0.1838    3.9068   -1.4012   -2.6111   14   16   17    0    0
#  16 HD1  H_ARO    0    0.1838    3.2356   -1.8074   -3.3679   15    0    0    0   11
#  17 CE1  C_ARO    2   -1.0889    5.3328   -1.4960   -2.7877   15   18   19    0    0
#  18 HE1  H_ARO    0    0.5515    5.7543   -1.9713   -3.6734   17    0    0    0   12
#  19 CZ   C_VIN    2    4.1012    6.1417   -0.9790   -1.8244   17   20   24    0    0
#  20 CE2  C_ARO    2   -1.0889    5.6654   -0.3767   -0.7019   19   21   22    0    0
#  21 HE2  H_ARO    0    0.5515    6.3477    0.0253    0.0471   20    0    0    0   12
#  22 CD2  C_ARO    2   -0.1838    4.2394   -0.2819   -0.5253   14   20   23    0    0
#  23 HD2  H_ARO    0    0.1838    3.8311    0.1960    0.3652   22    0    0    0   11
#  24 OH   O_HYD    3   -6.0100    7.4885   -1.0685   -1.9912   19   25    0    0    0
#  25 HH   H_OXY    0    2.9981    7.9579   -0.6510   -1.2132   24    0    0    0    0
#  26 C    C_BYL    2    8.2024    2.0013    1.4284    0.0000    5   27   28    0    0
#  27 O    O_BYL    2   -7.0004    1.2356    2.3910    0.0000   26    0    0    0    0
#  28 N    N_AMI    2   -6.4912    3.3231    1.5208    0.0000   26    0    0    0    0
#RESIDUE   VAL  V    6   22    3   21
#   1 OMEGA   -1    2   10.0000    2    1    3    4    0
#   2 PHI      0    0    0.0000    1    3    5   20    0
#   3 CHI1     1    3    1.3500    3    5    7   11   19
#   4 CHI21    1    3    1.3500    5    7   11   12   14
#   5 CHI22    1    3    1.3500    5    7   15   16   18
#   6 PSI      0    0    0.0000    3    5   20   22    0
#   1 C    C_BYL    2    8.2024   -0.6824   -1.1357    0.0000    2    3    0    0    0
#   2 O    O_BYL    2   -7.0004   -0.1723   -2.2550    0.0000    1    0    0    0    0
#   3 N    N_AMI    2   -6.4912    0.0000    0.0000    0.0000    1    4    5    0    0
#   4 HN   H_AMI    0    3.2103   -0.4226    0.9063    0.0000    3    0    0    0    0
#   5 CA   C_ALI    3    1.1597    1.4530    0.0000    0.0000    3    6    7   20    0
#   6 HA   H_ALI    0    0.3677    1.7819   -0.4870    0.9180    5    0    0    0    0
#   7 CB   C_ALI    3    0.1414    1.9763   -0.8167   -1.1833    5    8   11   15    0
#   8 HB   H_ALI    0    0.2970    1.6329   -0.3367   -2.0997    7    0    0    0    0
#   9 QG1  PSEUD    0    0.0000    3.8693   -0.8354   -1.2105   11    0    0    0   19
#  10 QG2  PSEUD    0    0.0000    1.2807   -2.5773   -1.1531   15    0    0    0   19
#  11 CG1  C_ALI    3   -1.3011    3.5061   -0.8318   -1.2052    7   12   13   14    0
#  12 HG11 H_ALI    0    0.4525    3.8514   -1.4191   -2.0561   11    0    0    0    9
#  13 HG12 H_ALI    0    0.4525    3.8783    0.1889   -1.2932   11    0    0    0    9
#  14 HG13 H_ALI    0    0.4525    3.8783   -1.2761   -0.2821   11    0    0    0    9
#  15 CG2  C_ALI    3   -1.3011    1.4141   -2.2394   -1.1589    7   16   17   18    0
#  16 HG21 H_ALI    0    0.4525    1.8021   -2.7980   -2.0107   15    0    0    0   10
#  17 HG22 H_ALI    0    0.4525    1.7137   -2.7326   -0.2341   15    0    0    0   10
#  18 HG23 H_ALI    0    0.4525    0.3262   -2.2013   -1.2144   15    0    0    0   10
#  19 QQG  PSEUD    0    0.0000    2.5750   -1.7064   -1.1818   11   15    0    0    0
#  20 C    C_BYL    2    8.2024    1.9587    1.4440    0.0000    5   21   22    0    0
#  21 O    O_BYL    2   -7.0004    1.1648    2.3835    0.0000   20    0    0    0    0
#  22 N    N_AMI    2   -6.4912    3.2772    1.5756    0.0000   20    0    0    0    0
#RESIDUE   ADE  a    9   38    3   37
#   1 ZETA     0    0    0.0000    1    2    3    6    0
#   2 ALPHA    0    0    0.0000    2    3    6    7    0
#   3 BETA     0    0    0.0000    3    6    7   11    0
#   4 GAMMA    0    0    0.0000    6    7   11   13    0
#   5 DELTA    0    0    0.0000    7   11   13   37    0
#   6 NU2      0    0    0.0000   11   13   15   19   36
#   7 NU1      0    0    0.0000   13   15   19   21   36
#   8 CHI      0    0    0.0000   21   19   22   23   36
#   9 EPSI     0    0    0.0000   11   13   37   38    0
#   1 C3'  C_ALI    0    0.2330   -0.9681   -5.8551    2.5577    2    0    0    0    0
#   2 O3'  O_EST    0   -0.5090   -0.6348   -4.7127    1.7719    1    3    0    0    0
#   3 P    P_ALI    0    1.3850    0.4817   -3.6875    2.2842    2    4    5    6    0
#   4 OP1  O_BYL    0   -0.8470    1.7976   -4.3635    2.3259    3    0    0    0    0
#   5 OP2  O_BYL    0   -0.8470    0.0167   -3.0215    3.5214    3    0    0    0    0
#   6 O5'  O_EST    0   -0.5090    0.5255   -2.5916    1.1193    3    7    0    0    0
#   7 C5'  C_ALI    0    0.1180    1.4216   -1.4863    1.2135    6    8    9   11    0
#   8 H5'  H_ALI    0    0.0210    2.4568   -1.8260    1.2707    7    0    0    0   10
#   9 H5"  H_ALI    0    0.0210    1.2157   -0.8907    2.1041    7    0    0    0   10
#  10 Q5'  PSEUD    0    0.0000    1.8362   -1.3584    1.6874    0    0    0    0    0
#  11 C4'  C_ALI    0    0.0360    1.2779   -0.5959    0.0000    7   12   21   13    0
#  12 H4'  H_ALI    0    0.0560    1.5099   -1.1747   -0.8952   11    0    0    0    0
#  13 C3'  C_ALI    0    0.2330    2.1963    0.6228    0.0000   11   15   14   37    0
#  14 H3'  H_ALI    0    0.0250    3.1027    0.4293    0.5756   13    0    0    0    0
#  15 C2'  C_ALI    0   -0.3070    1.3731    1.7403    0.5780   19   16   17   13    0
#  16 H2'  H_ALI    0    0.0810    1.4019    1.6718    1.6635   15    0    0    0   18
#  17 H2"  H_ALI    0    0.0810    1.7912    2.6897    0.2499   15    0    0    0   18
#  18 Q2'  PSEUD    0    0.0000    1.5965    2.1808    0.9567    0    0    0    0    0
#  19 C1'  C_ALI    0    0.3760    0.0000    1.4100    0.0000   21   20   22   15    0
#  20 H1'  H_ALI    0    0.0090   -0.0659    1.7932   -1.0183   19    0    0    0    0
#  21 O4'  O_EST    0   -0.3680    0.0000    0.0000    0.0000   11   19    0    0    0
#  22 N9   N_AMI    0   -0.0730   -1.1209    1.9441    0.8017   19   23   35    0    0
#  23 C4   C_ARO    0    0.5460   -2.3784    2.2371    0.3436   22   24   33    0    0
#  24 N3   N_AMI    0   -0.7280   -2.8170    2.0867   -0.9370   23   25    0    0    0
#  25 C2   C_ARO    0    0.6610   -4.1036    2.4736   -1.0196   24   26   27    0    0
#  26 H2   H_ARO    0   -0.0320   -4.6227    2.4240   -1.9654   25    0    0    0    0
#  27 N1   N_AMI    0   -0.7740   -4.9152    2.9484   -0.0482   25   28    0    0    0
#  28 C6   C_ARO    0    0.7690   -4.4155    3.0749    1.2114   27   29   33    0    0
#  29 N6   N_AMI    0   -0.7680   -5.2378    3.5526    2.1808   28   30   31    0    0
#  30 H61  H_AMI    0    0.3350   -6.1905    3.8024    1.9570   29    0    0    0   32
#  31 H62  H_AMI    0    0.3240   -4.8967    3.6581    3.1256   29    0    0    0   32
#  32 Q6   PSEUD    0    0.0000   -5.5436    3.7303    2.5413    0    0    0    0    0
#  33 C5   C_ARO    0   -0.0970   -3.0716    2.6978    1.4177   23   28   34    0    0
#  34 N7   N_AMI    0   -0.5430   -2.2897    2.7047    2.5414   33   35    0    0    0
#  35 C8   C_ARO    0    0.2630   -1.1186    2.2402    2.1184   22   34   36    0    0
#  36 H8   H_ARO    0    0.0620   -0.2357    2.0985    2.7240   35    0    0    0    0
#  37 O3'  O_EST    0   -0.5090    2.6047    0.9094   -1.3466   13   38    0    0    0
#  38 P    P_ALI    0    1.3850    3.5778    2.1447   -1.6417   37    0    0    0    0
#RESIDUE   RADE ra   10   38    3   37
#   1 ZETA     0    0    0.00      1    2    3    6    0
#   2 ALPHA    0    0    0.00      2    3    6    7    0
#   3 BETA     0    0    0.00      3    6    7   11    0
#   4 GAMMA    0    0    0.00      6    7   11   13    0
#   5 DELTA    0    0    0.00      7   11   13   37    0
#   6 NU2      0    0    0.00     11   13   15   19   36
#   7 HOXI     0    0    0.00     13   15   17   18   18
#   8 NU1      0    0    0.00     13   15   19   21   36
#   9 CHI      0    0    0.00     21   19   22   23   36
#  10 EPSI     0    0    0.00     11   13   37   38    0
#   1 C3'  C_ALI    0    0.3030   -0.9681   -5.8551    2.5577    2    0    0    0    0
#   2 O3'  O_EST    0   -0.5090   -0.6348   -4.7127    1.7719    1    3    0    0    0
#   3 P    P_ALI    0    1.3850    0.4817   -3.6875    2.2842    2    4    5    6    0
#   4 OP1  O_BYL    0   -0.8470    1.7976   -4.3635    2.3259    3    0    0    0    0
#   5 OP2  O_BYL    0   -0.8470    0.0167   -3.0215    3.5214    3    0    0    0    0
#   6 O5'  O_EST    0   -0.5090    0.5255   -2.5916    1.1193    3    7    0    0    0
#   7 C5'  C_ALI    0    0.1800    1.4216   -1.4863    1.2135    6    8    9   11    0
#   8 H5'  H_ALI    0    0.0080    2.4568   -1.8260    1.2707    7    0    0    0   10
#   9 H5"  H_ALI    0    0.0080    1.2157   -0.8907    2.1041    7    0    0    0   10
#  10 Q5'  PSEUD    0    0.0000    1.8362   -1.3584    1.6874    0    0    0    0    0
#  11 C4'  C_ALI    0    0.1000    1.2779   -0.5959    0.0000    7   12   13   21    0
#  12 H4'  H_ALI    0    0.0610    1.5099   -1.1747   -0.8952   11    0    0    0    0
#  13 C3'  C_ALI    0    0.3030    2.1963    0.6228    0.0000   11   14   15   37    0
#  14 H3'  H_ALI    0    0.0070    3.1027    0.4293    0.5756   13    0    0    0    0
#  15 C2'  C_ALI    0    0.1010    1.3731    1.7403    0.5780   13   16   17   19    0
#  16 H2'  H_ALI    0    0.0080    1.4019    1.6718    1.6635   15    0    0    0    0
#  17 O2'  O_HYD    0   -0.5460    1.9936    2.8894    0.0464   15   18    0    0    0
#  18 HO2' H_OXY    0    0.3240    2.1370    3.5157    0.7597   17    0    0    0    0
#  19 C1'  C_ALI    0    0.1170    0.0000    1.4100    0.0000   15   20   21   22    0
#  20 H1'  H_ALI    0    0.0540   -0.0659    1.7932   -1.0183   19    0    0    0    0
#  21 O4'  O_EST    0   -0.3430    0.0000    0.0000    0.0000   11   19    0    0    0
#  22 N9   N_AMI    0   -0.0730   -1.1209    1.9441    0.8017   19   23   35    0    0
#  23 C4   C_ARO    0    0.5460   -2.3784    2.2371    0.3436   22   24   33    0    0
#  24 N3   N_AMI    0   -0.7280   -2.8170    2.0867   -0.9370   23   25    0    0    0
#  25 C2   C_ARO    0    0.6610   -4.1036    2.4736   -1.0196   24   26   27    0    0
#  26 H2   H_ARO    0   -0.0320   -4.6227    2.4240   -1.9654   25    0    0    0    0
#  27 N1   N_AMI    0   -0.7740   -4.9152    2.9484   -0.0482   25   28    0    0    0
#  28 C6   C_ARO    0    0.7690   -4.4155    3.0749    1.2114   27   29   33    0    0
#  29 N6   N_AMI    0   -0.7680   -5.2378    3.5526    2.1808   28   30   31    0    0
#  30 H61  H_AMI    0    0.3350   -6.1905    3.8024    1.9570   29    0    0    0   32
#  31 H62  H_AMI    0    0.3240   -4.8967    3.6581    3.1256   29    0    0    0   32
#  32 Q6   PSEUD    0    0.0000   -5.5436    3.7303    2.5413    0    0    0    0    0
#  33 C5   C_ARO    0   -0.0970   -3.0716    2.6978    1.4177   23   28   34    0    0
#  34 N7   N_AMI    0   -0.5430   -2.2897    2.7047    2.5414   33   35    0    0    0
#  35 C8   C_ARO    0    0.2630   -1.1186    2.2402    2.1184   22   34   36    0    0
#  36 H8   H_ARO    0    0.0620   -0.2357    2.0985    2.7240   35    0    0    0    0
#  37 O3'  O_EST    0   -0.5090    2.6047    0.9094   -1.3466   13   38    0    0    0
#  38 P    P_ALI    0    1.3850    3.5778    2.1447   -1.6417   37    0    0    0    0
#RESIDUE   CYT  c    9   36    3   35
#   1 ZETA     0    0    0.00      1    2    3    6    0
#   2 ALPHA    0    0    0.00      2    3    6    7    0
#   3 BETA     0    0    0.00      3    6    7   11    0
#   4 GAMMA    0    0    0.00      6    7   11   13    0
#   5 DELTA    0    0    0.0000    7   11   13   35    0
#   6 NU2      0    0    0.0000   11   13   15   19   34
#   7 NU1      0    0    0.0000   13   15   19   21   34
#   8 CHI      0    0    0.0000   21   19   22   23   34
#   9 EPSI     0    0    0.0000   11   13   35   36    0
#   1 C3'  C_ALI    0    0.2330   -0.9681   -5.8551    2.5577    2    0    0    0    0
#   2 O3'  O_EST    0   -0.5090   -0.6348   -4.7127    1.7719    1    3    0    0    0
#   3 P    P_ALI    0    1.3850    0.4817   -3.6875    2.2842    2    4    5    6    0
#   4 OP1  O_BYL    0   -0.8470    1.7976   -4.3635    2.3259    3    0    0    0    0
#   5 OP2  O_BYL    0   -0.8470    0.0167   -3.0215    3.5214    3    0    0    0    0
#   6 O5'  O_EST    0   -0.5090    0.5255   -2.5916    1.1193    3    7    0    0    0
#   7 C5'  C_ALI    0    0.1180    1.4216   -1.4863    1.2135    6    8    9   11    0
#   8 H5'  H_ALI    0    0.0210    2.4568   -1.8260    1.2707    7    0    0    0   10
#   9 H5"  H_ALI    0    0.0210    1.2157   -0.8907    2.1041    7    0    0    0   10
#  10 Q5'  PSEUD    0    0.0000    1.8362   -1.3584    1.6874    0    0    0    0    0
#  11 C4'  C_ALI    0    0.0360    1.2779   -0.5959    0.0000    7   12   21   13    0
#  12 H4'  H_ALI    0    0.0560    1.5099   -1.1747   -0.8952   11    0    0    0    0
#  13 C3'  C_ALI    0    0.2330    2.1963    0.6228    0.0000   11   15   14   35    0
#  14 H3'  H_ALI    0    0.0250    3.1027    0.4293    0.5756   13    0    0    0    0
#  15 C2'  C_ALI    0   -0.3070    1.3731    1.7403    0.5780   19   16   17   13    0
#  16 H2'  H_ALI    0    0.0810    1.4019    1.6718    1.6635   15    0    0    0   18
#  17 H2"  H_ALI    0    0.0810    1.7912    2.6897    0.2499   15    0    0    0   18
#  18 Q2'  PSEUD    0    0.0000    1.5965    2.1808    0.9567    0    0    0    0    0
#  19 C1'  C_ALI    0    0.3760    0.0000    1.4100    0.0000   21   20   22   15    0
#  20 H1'  H_ALI    0    0.0090   -0.0659    1.7932   -1.0183   19    0    0    0    0
#  21 O4'  O_EST    0   -0.3680    0.0000    0.0000    0.0000   11   19    0    0    0
#  22 N1   N_AMI    0   -0.1870   -1.1209    1.9441    0.8017   19   23   33    0    0
#  23 C2   C_ARO    0    0.8590   -2.3304    2.1782    0.1493   22   24   25    0    0
#  24 O2   O_BYL    0   -0.5080   -2.4085    1.9304   -1.0590   23    0    0    0    0
#  25 N3   N_AMI    0   -0.8600   -3.3653    2.6642    0.8578   23   26    0    0    0
#  26 C4   C_ARO    0    0.9350   -3.2644    2.9228    2.1462   25   27   31    0    0
#  27 N4   N_AMI    0   -0.8340   -4.2972    3.4021    2.8279   26   28   29    0    0
#  28 H41  H_AMI    0    0.3510   -5.1756    3.5735    2.3597   27    0    0    0   30
#  29 H42  H_AMI    0    0.3290   -4.2049    3.5955    3.8149   27    0    0    0   30
#  30 Q4   PSEUD    0    0.0000   -4.6903    3.5845    3.0873    0    0    0    0    0
#  31 C5   C_ARO    0   -0.5760   -2.0221    2.6890    2.8462   26   32   33    0    0
#  32 H5   H_ARO    0    0.1530   -1.9484    2.9039    3.9020   31    0    0    0    0
#  33 C6   C_ARO    0    0.1850   -0.9996    2.2045    2.1264   22   31   34    0    0
#  34 H6   H_ARO    0    0.0980   -0.0488    2.0117    2.6008   33    0    0    0    0
#  35 O3'  O_EST    0   -0.5090    2.6047    0.9094   -1.3466   13   36    0    0    0
#  36 P    P_ALI    0    1.3850    3.5778    2.1447   -1.6417   35    0    0    0    0
#RESIDUE   RCYT rc   10   36    3   35
#   1 ZETA     0    0    0.00      1    2    3    6    0
#   2 ALPHA    0    0    0.00      2    3    6    7    0
#   3 BETA     0    0    0.00      3    6    7   11    0
#   4 GAMMA    0    0    0.00      6    7   11   13    0
#   5 DELTA    0    0    0.00      7   11   13   35    0
#   6 NU2      0    0    0.00     11   13   15   19   34
#   7 HOXI     0    0    0.00     13   15   17   18   18
#   8 NU1      0    0    0.00     13   15   19   21   34
#   9 CHI      0    0    0.00     21   19   22   23   34
#  10 EPSI     0    0    0.00     11   13   35   36    0
#   1 C3'  C_ALI    0    0.3030   -0.9681   -5.8551    2.5577    2    0    0    0    0
#   2 O3'  O_EST    0   -0.5090   -0.6348   -4.7127    1.7719    1    3    0    0    0
#   3 P    P_ALI    0    1.3850    0.4817   -3.6875    2.2842    2    4    5    6    0
#   4 OP1  O_BYL    0   -0.8470    1.7976   -4.3635    2.3259    3    0    0    0    0
#   5 OP2  O_BYL    0   -0.8470    0.0167   -3.0215    3.5214    3    0    0    0    0
#   6 O5'  O_EST    0   -0.5090    0.5255   -2.5916    1.1193    3    7    0    0    0
#   7 C5'  C_ALI    0    0.1800    1.4216   -1.4863    1.2135    6    8    9   11    0
#   8 H5'  H_ALI    0    0.0080    2.4568   -1.8260    1.2707    7    0    0    0   10
#   9 H5"  H_ALI    0    0.0080    1.2157   -0.8907    2.1041    7    0    0    0   10
#  10 Q5'  PSEUD    0    0.0000    1.8362   -1.3584    1.6874    0    0    0    0    0
#  11 C4'  C_ALI    0    0.1000    1.2779   -0.5959    0.0000    7   12   13   21    0
#  12 H4'  H_ALI    0    0.0610    1.5099   -1.1747   -0.8952   11    0    0    0    0
#  13 C3'  C_ALI    0    0.3030    2.1963    0.6228    0.0000   11   14   15   35    0
#  14 H3'  H_ALI    0    0.0070    3.1027    0.4293    0.5756   13    0    0    0    0
#  15 C2'  C_ALI    0    0.1010    1.3731    1.7403    0.5780   13   16   17   19    0
#  16 H2'  H_ALI    0    0.0080    1.4019    1.6718    1.6635   15    0    0    0    0
#  17 O2'  O_HYD    0   -0.5460    1.9936    2.8894    0.0464   15   18    0    0    0
#  18 HO2' H_OXY    0    0.3240    2.1370    3.5157    0.7597   17    0    0    0    0
#  19 C1'  C_ALI    0    0.1170    0.0000    1.4100    0.0000   15   20   21   22    0
#  20 H1'  H_ALI    0    0.0540   -0.0659    1.7932   -1.0183   19    0    0    0    0
#  21 O4'  O_EST    0   -0.3430    0.0000    0.0000    0.0000   11   19    0    0    0
#  22 N1   N_AMI    0   -0.1870   -1.1209    1.9441    0.8017   19   23   33    0    0
#  23 C2   C_ARO    0    0.8590   -2.3304    2.1782    0.1493   22   24   25    0    0
#  24 O2   O_BYL    0   -0.5080   -2.4085    1.9304   -1.0590   23    0    0    0    0
#  25 N3   N_AMI    0   -0.8600   -3.3653    2.6642    0.8578   23   26    0    0    0
#  26 C4   C_ARO    0    0.9350   -3.2644    2.9228    2.1462   25   27   31    0    0
#  27 N4   N_AMI    0   -0.8340   -4.2972    3.4021    2.8279   26   28   29    0    0
#  28 H41  H_AMI    0    0.3510   -5.1756    3.5735    2.3597   27    0    0    0   30
#  29 H42  H_AMI    0    0.3290   -4.2049    3.5955    3.8149   27    0    0    0   30
#  30 Q4   PSEUD    0    0.0000   -4.6903    3.5845    3.0873    0    0    0    0    0
#  31 C5   C_ARO    0   -0.5760   -2.0221    2.6890    2.8462   26   32   33    0    0
#  32 H5   H_ARO    0    0.1530   -1.9484    2.9039    3.9020   31    0    0    0    0
#  33 C6   C_ARO    0    0.1850   -0.9996    2.2045    2.1264   22   31   34    0    0
#  34 H6   H_ARO    0    0.0980   -0.0488    2.0117    2.6008   33    0    0    0    0
#  35 O3'  O_EST    0   -0.5090    2.6047    0.9094   -1.3466   13   36    0    0    0
#  36 P    P_ALI    0    1.3850    3.5778    2.1447   -1.6417   35    0    0    0    0
#RESIDUE   GUA  g    9   39    3   38
#   1 ZETA     0    0    0.0000    1    2    3    6    0
#   2 ALPHA    0    0    0.0000    2    3    6    7    0
#   3 BETA     0    0    0.0000    3    6    7   11    0
#   4 GAMMA    0    0    0.0000    6    7   11   13    0
#   5 DELTA    0    0    0.0000    7   11   13   38    0
#   6 NU2      0    0    0.0000   11   13   15   19   37
#   7 NU1      0    0    0.0000   13   15   19   21   37
#   8 CHI      0    0    0.0000   21   19   22   23   37
#   9 EPSI     0    0    0.0000   11   13   38   39    0
#   1 C3'  C_ALI    0    0.2330   -0.9681   -5.8551    2.5577    2    0    0    0    0
#   2 O3'  O_EST    0   -0.5090   -0.6348   -4.7127    1.7719    1    3    0    0    0
#   3 P    P_ALI    0    1.3850    0.4817   -3.6875    2.2842    2    4    5    6    0
#   4 OP1  O_BYL    0   -0.8470    1.7976   -4.3635    2.3259    3    0    0    0    0
#   5 OP2  O_BYL    0   -0.8470    0.0167   -3.0215    3.5214    3    0    0    0    0
#   6 O5'  O_EST    0   -0.5090    0.5255   -2.5916    1.1193    3    7    0    0    0
#   7 C5'  C_ALI    0    0.1180    1.4216   -1.4863    1.2135    6    8    9   11    0
#   8 H5'  H_ALI    0    0.0210    2.4568   -1.8260    1.2707    7    0    0    0   10
#   9 H5"  H_ALI    0    0.0210    1.2157   -0.8907    2.1041    7    0    0    0   10
#  10 Q5'  PSEUD    0    0.0000    1.8362   -1.3584    1.6874    0    0    0    0    0
#  11 C4'  C_ALI    0    0.0360    1.2779   -0.5959    0.0000    7   12   21   13    0
#  12 H4'  H_ALI    0    0.0560    1.5099   -1.1747   -0.8952   11    0    0    0    0
#  13 C3'  C_ALI    0    0.2330    2.1963    0.6228    0.0000   11   15   14   38    0
#  14 H3'  H_ALI    0    0.0250    3.1027    0.4293    0.5756   13    0    0    0    0
#  15 C2'  C_ALI    0   -0.3070    1.3731    1.7403    0.5780   19   16   17   13    0
#  16 H2'  H_ALI    0    0.0810    1.4019    1.6718    1.6635   15    0    0    0   18
#  17 H2"  H_ALI    0    0.0810    1.7912    2.6897    0.2499   15    0    0    0   18
#  18 Q2'  PSEUD    0    0.0000    1.5965    2.1808    0.9567    0    0    0    0    0
#  19 C1'  C_ALI    0    0.3760    0.0000    1.4100    0.0000   21   20   22   15    0
#  20 H1'  H_ALI    0    0.0090   -0.0659    1.7932   -1.0183   19    0    0    0    0
#  21 O4'  O_EST    0   -0.3680    0.0000    0.0000    0.0000   11   19    0    0    0
#  22 N9   N_AMI    0   -0.0420   -1.1209    1.9441    0.8017   19   23   36    0    0
#  23 C4   C_ARO    0    0.3910   -2.3784    2.2371    0.3436   22   24   34    0    0
#  24 N3   N_AMI    0   -0.7090   -2.8170    2.0867   -0.9370   23   25    0    0    0
#  25 C2   C_ARO    0    0.8710   -4.1036    2.4736   -1.0196   24   26   30    0    0
#  26 N2   N_AMI    0   -0.7780   -4.7356    2.4092   -2.1892   25   27   28    0    0
#  27 H21  H_AMI    0    0.3250   -5.7010    2.6979   -2.2581   26    0    0    0   29
#  28 H22  H_AMI    0    0.3390   -4.2498    2.0716   -3.0078   26    0    0    0   29
#  29 Q2   PSEUD    0    0.0000   -4.9754    2.3848   -2.6330    0    0    0    0    0
#  30 N1   N_AMI    0   -0.7290   -4.9152    2.9484   -0.0482   25   31   32    0    0
#  31 H1   H_AMI    0    0.3360   -5.8690    3.2001   -0.2652   30    0    0    0    0
#  32 C6   C_ARO    0    0.6900   -4.4155    3.0749    1.2114   30   33   34    0    0
#  33 O6   O_BYL    0   -0.4580   -5.1745    3.5092    2.0764   32    0    0    0    0
#  34 C5   C_ARO    0   -0.0600   -3.0716    2.6978    1.4177   23   32   35    0    0
#  35 N7   N_AMI    0   -0.5430   -2.2897    2.7047    2.5414   34   36    0    0    0
#  36 C8   C_ARO    0    0.2660   -1.1186    2.2402    2.1184   22   35   37    0    0
#  37 H8   H_ARO    0    0.0460   -0.2357    2.0985    2.7240   36    0    0    0    0
#  38 O3'  O_EST    0   -0.5090    2.6047    0.9094   -1.3466   13   39    0    0    0
#  39 P    P_ALI    0    1.3850    3.5778    2.1447   -1.6417   38    0    0    0    0
#RESIDUE   RGUA rg   10   39    3   38
#   1 ZETA     0    0    0.00      1    2    3    6    0
#   2 ALPHA    0    0    0.00      2    3    6    7    0
#   3 BETA     0    0    0.00      3    6    7   11    0
#   4 GAMMA    0    0    0.00      6    7   11   13    0
#   5 DELTA    0    0    0.00      7   11   13   38    0
#   6 NU2      0    0    0.00     11   13   15   19   37
#   7 HOXI     0    0    0.00     13   15   17   18   18
#   8 NU1      0    0    0.00     13   15   19   21   37
#   9 CHI      0    0    0.00     21   19   22   23   37
#  10 EPSI     0    0    0.00     11   13   38   39    0
#   1 C3'  C_ALI    0    0.3030   -0.9681   -5.8551    2.5577    2    0    0    0    0
#   2 O3'  O_EST    0   -0.5090   -0.6348   -4.7127    1.7719    1    3    0    0    0
#   3 P    P_ALI    0    1.3850    0.4817   -3.6875    2.2842    2    4    5    6    0
#   4 OP1  O_BYL    0   -0.8470    1.7976   -4.3635    2.3259    3    0    0    0    0
#   5 OP2  O_BYL    0   -0.8470    0.0167   -3.0215    3.5214    3    0    0    0    0
#   6 O5'  O_EST    0   -0.5090    0.5255   -2.5916    1.1193    3    7    0    0    0
#   7 C5'  C_ALI    0    0.1800    1.4216   -1.4863    1.2135    6    8    9   11    0
#   8 H5'  H_ALI    0    0.0080    2.4568   -1.8260    1.2707    7    0    0    0   10
#   9 H5"  H_ALI    0    0.0080    1.2157   -0.8907    2.1041    7    0    0    0   10
#  10 Q5'  PSEUD    0    0.0000    1.8362   -1.3584    1.6874    0    0    0    0    0
#  11 C4'  C_ALI    0    0.1000    1.2779   -0.5959    0.0000    7   12   13   21    0
#  12 H4'  H_ALI    0    0.0610    1.5099   -1.1747   -0.8952   11    0    0    0    0
#  13 C3'  C_ALI    0    0.3030    2.1963    0.6228    0.0000   11   14   15   38    0
#  14 H3'  H_ALI    0    0.0070    3.1027    0.4293    0.5756   13    0    0    0    0
#  15 C2'  C_ALI    0    0.1010    1.3731    1.7403    0.5780   13   16   17   19    0
#  16 H2'  H_ALI    0    0.0080    1.4019    1.6718    1.6635   15    0    0    0    0
#  17 O2'  O_HYD    0   -0.5460    1.9936    2.8894    0.0464   15   18    0    0    0
#  18 HO2' H_OXY    0    0.3240    2.1370    3.5157    0.7597   17    0    0    0    0
#  19 C1'  C_ALI    0    0.1170    0.0000    1.4100    0.0000   15   20   21   22    0
#  20 H1'  H_ALI    0    0.0540   -0.0659    1.7932   -1.0183   19    0    0    0    0
#  21 O4'  O_EST    0   -0.3430    0.0000    0.0000    0.0000   11   19    0    0    0
#  22 N9   N_AMI    0   -0.0420   -1.1209    1.9441    0.8017   19   23   36    0    0
#  23 C4   C_ARO    0    0.3910   -2.3784    2.2371    0.3436   22   24   34    0    0
#  24 N3   N_AMI    0   -0.7090   -2.8170    2.0867   -0.9370   23   25    0    0    0
#  25 C2   C_ARO    0    0.8710   -4.1036    2.4736   -1.0196   24   26   30    0    0
#  26 N2   N_AMI    0   -0.7780   -4.7356    2.4092   -2.1892   25   27   28    0    0
#  27 H21  H_AMI    0    0.3250   -5.7010    2.6979   -2.2581   26    0    0    0   29
#  28 H22  H_AMI    0    0.3390   -4.2498    2.0716   -3.0078   26    0    0    0   29
#  29 Q2   PSEUD    0    0.0000   -4.9754    2.3848   -2.6330    0    0    0    0    0
#  30 N1   N_AMI    0   -0.7290   -4.9152    2.9484   -0.0482   25   31   32    0    0
#  31 H1   H_AMI    0    0.3360   -5.8690    3.2001   -0.2652   30    0    0    0    0
#  32 C6   C_ARO    0    0.6900   -4.4155    3.0749    1.2114   30   33   34    0    0
#  33 O6   O_BYL    0   -0.4580   -5.1745    3.5092    2.0764   32    0    0    0    0
#  34 C5   C_ARO    0   -0.0600   -3.0716    2.6978    1.4177   23   32   35    0    0
#  35 N7   N_AMI    0   -0.5430   -2.2897    2.7047    2.5414   34   36    0    0    0
#  36 C8   C_ARO    0    0.2660   -1.1186    2.2402    2.1184   22   35   37    0    0
#  37 H8   H_ARO    0    0.0460   -0.2357    2.0985    2.7240   36    0    0    0    0
#  38 O3'  O_EST    0   -0.5090    2.6047    0.9094   -1.3466   36   39    0    0    0
#  39 P    P_ALI    0    1.3850    3.5778    2.1447   -1.6417   38    0    0    0    0
#RESIDUE   THY  t   10   38    3   37
#   1 ZETA     0    0    0.00      1    2    3    6    0
#   2 ALPHA    0    0    0.00      2    3    6    7    0
#   3 BETA     0    0    0.00      3    6    7   11    0
#   4 GAMMA    0    0    0.00      6    7   11   13    0
#   5 DELTA    0    0    0.0000    7   11   13   37    0
#   6 NU2      0    0    0.0000   11   13   15   19   36
#   7 NU1      0    0    0.0000   13   15   19   21   36
#   8 CHI      0    0    0.0000   21   19   22   23   36
#   9 CHI2     0    0    0.00     27   29   30   31   33
#  10 EPSI     0    0    0.00     11   13   37   38    0
#   1 C3'  C_ALI    0    0.2330   -0.9681   -5.8551    2.5577    2    0    0    0    0
#   2 O3'  O_EST    0   -0.5090   -0.6348   -4.7127    1.7719    1    3    0    0    0
#   3 P    P_ALI    0    1.3850    0.4817   -3.6875    2.2842    2    4    5    6    0
#   4 OP1  O_BYL    0   -0.8470    1.7976   -4.3635    2.3259    3    0    0    0    0
#   5 OP2  O_BYL    0   -0.8470    0.0167   -3.0215    3.5214    3    0    0    0    0
#   6 O5'  O_EST    0   -0.5090    0.5255   -2.5916    1.1193    3    7    0    0    0
#   7 C5'  C_ALI    0    0.1180    1.4216   -1.4863    1.2135    6    8    9   11    0
#   8 H5'  H_ALI    0    0.0210    2.4568   -1.8260    1.2707    7    0    0    0   10
#   9 H5"  H_ALI    0    0.0210    1.2157   -0.8907    2.1041    7    0    0    0   10
#  10 Q5'  PSEUD    0    0.0000    1.8362   -1.3584    1.6874    0    0    0    0    0
#  11 C4'  C_ALI    0    0.0360    1.2779   -0.5959    0.0000    7   12   21   13    0
#  12 H4'  H_ALI    0    0.0560    1.5099   -1.1747   -0.8952   11    0    0    0    0
#  13 C3'  C_ALI    0    0.2330    2.1963    0.6228    0.0000   11   15   14   37    0
#  14 H3'  H_ALI    0    0.0250    3.1027    0.4293    0.5756   13    0    0    0    0
#  15 C2'  C_ALI    0   -0.3070    1.3731    1.7403    0.5780   19   16   17   13    0
#  16 H2'  H_ALI    0    0.0810    1.4019    1.6718    1.6635   15    0    0    0   18
#  17 H2"  H_ALI    0    0.0810    1.7912    2.6897    0.2499   15    0    0    0   18
#  18 Q2'  PSEUD    0    0.0000    1.5965    2.1808    0.9567    0    0    0    0    0
#  19 C1'  C_ALI    0    0.3760    0.0000    1.4100    0.0000   21   20   22   15    0
#  20 H1'  H_ALI    0    0.0090   -0.0659    1.7932   -1.0183   19    0    0    0    0
#  21 O4'  O_EST    0   -0.3680    0.0000    0.0000    0.0000   11   19    0    0    0
#  22 N1   N_AMI    0   -0.2170   -1.1209    1.9441    0.8017   19   23   35    0    0
#  23 C2   C_ARO    0    0.8490   -2.2881    2.1620    0.1364   22   24   25    0    0
#  24 O2   O_BYL    0   -0.4880   -2.4402    1.9414   -1.0548   23    0    0    0    0
#  25 N3   N_AMI    0   -0.8510   -3.3338    2.6596    0.8814   23   26   27    0    0
#  26 H3   H_AMI    0    0.3550   -4.2250    2.8415    0.4424   25    0    0    0    0
#  27 C4   C_ARO    0    0.8090   -3.2471    2.9346    2.2228   25   28   29    0    0
#  28 O4   O_BYL    0   -0.4640   -4.2464    3.3768    2.7874   27    0    0    0    0
#  29 C5   C_ARO    0   -0.1760   -2.0063    2.6890    2.8681   27   30   35    0    0
#  30 C7   C_ALI    0   -0.3820   -1.8531    2.9733    4.3432   29   31   32   33    0
#  31 H71  H_ALI    0    0.1140   -0.8409    2.7265    4.6636   30    0    0    0   34
#  32 H72  H_ALI    0    0.1140   -2.5641    2.3728    4.9107   30    0    0    0   34
#  33 H73  H_ALI    0    0.1140   -2.0420    4.0291    4.5373   30    0    0    0   34
#  34 Q7   PSEUD    0    0.0000   -1.8157    3.0428    4.7039    0    0    0    0    0
#  35 C6   C_ARO    0    0.0340   -1.0061    2.2067    2.1270   22   29   36    0    0
#  36 H6   H_ARO    0    0.1340   -0.0464    2.0062    2.5799   35    0    0    0    0
#  37 O3'  O_EST    0   -0.5090    2.6047    0.9094   -1.3466   13   38    0    0    0
#  38 P    P_ALI    0    1.3850    3.5778    2.1447   -1.6417   37    0    0    0    0
#RESIDUE   URA  u   10   34    3   33
#   1 ZETA     0    0    0.00      1    2    3    6    0
#   2 ALPHA    0    0    0.00      2    3    6    7    0
#   3 BETA     0    0    0.00      3    6    7   11    0
#   4 GAMMA    0    0    0.00      6    7   11   13    0
#   5 DELTA    0    0    0.00      7   11   13   33    0
#   6 NU2      0    0    0.00     11   13   15   19   32
#   7 HOXI     0    0    0.00     13   15   17   18   18
#   8 NU1      0    0    0.00     13   15   19   21   32
#   9 CHI      0    0    0.00     21   19   22   23   32
#  10 EPSI     0    0    0.00     11   13   33   34    0
#   1 C3'  C_ALI    0    0.3030   -0.9681   -5.8551    2.5577    2    0    0    0    0
#   2 O3'  O_EST    0   -0.5090   -0.6348   -4.7127    1.7719    1    3    0    0    0
#   3 P    P_ALI    0    1.3850    0.4817   -3.6875    2.2842    2    4    5    6    0
#   4 OP1  O_BYL    0   -0.8470    1.7976   -4.3635    2.3259    3    0    0    0    0
#   5 OP2  O_BYL    0   -0.8470    0.0167   -3.0215    3.5214    3    0    0    0    0
#   6 O5'  O_EST    0   -0.5090    0.5255   -2.5916    1.1193    3    7    0    0    0
#   7 C5'  C_ALI    0    0.1800    1.4216   -1.4863    1.2135    6    8    9   11    0
#   8 H5'  H_ALI    0    0.0080    2.4568   -1.8260    1.2707    7    0    0    0   10
#   9 H5"  H_ALI    0    0.0080    1.2157   -0.8907    2.1041    7    0    0    0   10
#  10 Q5'  PSEUD    0    0.0000    1.8362   -1.3584    1.6874    0    0    0    0    0
#  11 C4'  C_ALI    0    0.1000    1.2779   -0.5959    0.0000    7   12   13   21    0
#  12 H4'  H_ALI    0    0.0610    1.5099   -1.1747   -0.8952   11    0    0    0    0
#  13 C3'  C_ALI    0    0.3030    2.1963    0.6228    0.0000   11   14   15   33    0
#  14 H3'  H_ALI    0    0.0070    3.1027    0.4293    0.5756   13    0    0    0    0
#  15 C2'  C_ALI    0    0.1010    1.3731    1.7403    0.5780   13   16   17   19    0
#  16 H2'  H_ALI    0    0.0080    1.4019    1.6718    1.6635   15    0    0    0    0
#  17 O2'  O_HYD    0   -0.5460    1.9936    2.8894    0.0464   15   18    0    0    0
#  18 HO2' H_OXY    0    0.3240    2.1370    3.5157    0.7597   17    0    0    0    0
#  19 C1'  C_ALI    0    0.1170    0.0000    1.4100    0.0000   15   20   21   22    0
#  20 H1'  H_ALI    0    0.0540   -0.0659    1.7932   -1.0183   19    0    0    0    0
#  21 O4'  O_EST    0   -0.3430    0.0000    0.0000    0.0000   11   19    0    0    0
#  22 N1   N_AMI    0   -0.1590   -1.1209    1.9441    0.8017   19   23   31    0    0
#  23 C2   C_ARO    0    0.7750   -2.2881    2.1620    0.1364   22   24   25    0    0
#  24 O2   O_BYL    0   -0.4720   -2.4402    1.9414   -1.0548   23    0    0    0    0
#  25 N3   N_AMI    0   -0.7680   -3.3338    2.6596    0.8814   23   26   27    0    0
#  26 H3   H_AMI    0    0.3340   -4.2250    2.8415    0.4424   25    0    0    0    0
#  27 C4   C_ARO    0    0.8340   -3.2471    2.9346    2.2228   25   28   29    0    0
#  28 O4   O_BYL    0   -0.4740   -4.2464    3.3768    2.7874   27    0    0    0    0
#  29 C5   C_ARO    0   -0.5290   -2.0063    2.6890    2.8681   27   30   31    0    0
#  30 H5   C_ALI    0    0.1460   -1.8967    2.8923    3.9231   29    0    0    0    0
#  31 C6   C_ARO    0    0.1600   -1.0061    2.2067    2.1270   22   29   32    0    0
#  32 H6   H_ARO    0    0.0980   -0.0464    2.0062    2.5799   31    0    0    0    0
#  33 O3'  O_EST    0   -0.5090    2.6047    0.9094   -1.3466   13   34    0    0    0
#  34 P    P_ALI    0    1.3850    3.5778    2.1447   -1.6417   33    0    0    0    0
#
#RESIDUE   PL   PL    1    6    3    5
#   1 LB       0    0    0.00      2    3    4    5    0
#   1 C    PSEUD    0    0.0000   -0.6824   -1.1357    0.0000    0    0    0    0    0
#   2 O    PSEUD    0    0.0000   -0.1723   -2.2550    0.0000    0    0    0    0    0
#   3 N    PSEUD    0    0.0000    0.0000    0.0000    0.0000    0    0    0    0    0
#   4 Q1   PSEUD    0    0.0000    0.9971   -0.0762    0.0000    0    0    0    0    0
#   5 Q2   PSEUD    0    0.0000    1.0733    0.9209    0.0000    0    0    0    0    0
#   6 Q3   PSEUD    0    0.0000    2.0704    0.8447    0.0000    0    0    0    0    0
#RESIDUE   NL   NL    1    6    3    5
#   1 LB       0    0    0.00      2    3    4    5    0
#   1 C3'  PSEUD    0    0.0000   -0.9681   -5.8551    2.5577    0    0    0    0    0
#   2 O3'  PSEUD    0    0.0000   -0.6348   -4.7127    1.7719    0    0    0    0    0
#   3 P    PSEUD    0    0.0000    0.4817   -3.6875    2.2842    0    0    0    0    0
#   4 Q1   PSEUD    0    0.0000    0.3487   -3.1324    1.4631    0    0    0    0    0
#   5 Q2   PSEUD    0    0.0000    1.0465   -2.4917    1.7833    0    0    0    0    0
#   6 Q3   PSEUD    0    0.0000    0.9136   -1.9366    0.9622    0    0    0    0    0
#RESIDUE   LL   LL    1    6    3    5
#   1 LB       0    0    0.00      2    3    4    5    0
#   1 Q1   PSEUD    0    0.0000    0.0000    0.0000    0.0000    0    0    0    0    0
#   2 Q2   PSEUD    0    0.0000    1.0000    0.0000    0.0000    0    0    0    0    0
#   3 Q3   PSEUD    0    0.0000    1.0000    1.0000    0.0000    0    0    0    0    0
#   4 Q1   PSEUD    0    0.0000    2.0000    1.0000    0.0000    0    0    0    0    0
#   5 Q2   PSEUD    0    0.0000    2.0000    0.0000    0.0000    0    0    0    0    0
#   6 Q3   PSEUD    0    0.0000    3.0000    0.0000    0.0000    0    0    0    0    0
#RESIDUE   LL2  LL2    1    6    3    5
#   1 LB       0    0    0.00      2    3    4    5    0
#   1 Q1   PSEUD    0    0.0000    0.0000    0.0000    0.0000    0    0    0    0    0
#   2 Q2   PSEUD    0    0.0000    2.0000    0.0000    0.0000    0    0    0    0    0
#   3 Q3   PSEUD    0    0.0000    2.0000    2.0000    0.0000    0    0    0    0    0
#   4 Q1   PSEUD    0    0.0000    4.0000    2.0000    0.0000    0    0    0    0    0
#   5 Q2   PSEUD    0    0.0000    4.0000    0.0000    0.0000    0    0    0    0    0
#   6 Q3   PSEUD    0    0.0000    6.0000    0.0000    0.0000    0    0    0    0    0
#RESIDUE   LL5  LL5    1    6    3    5
#   1 LB       0    0    0.00      2    3    4    5    0
#   1 Q1   PSEUD    0    0.0000    0.0000    0.0000    0.0000    0    0    0    0    0
#   2 Q2   PSEUD    0    0.0000    5.0000    0.0000    0.0000    0    0    0    0    0
#   3 Q3   PSEUD    0    0.0000    5.0000    5.0000    0.0000    0    0    0    0    0
#   4 Q1   PSEUD    0    0.0000   10.0000    5.0000    0.0000    0    0    0    0    0
#   5 Q2   PSEUD    0    0.0000   10.0000    0.0000    0.0000    0    0    0    0    0
#   6 Q3   PSEUD    0    0.0000   15.0000    0.0000    0.0000    0    0    0    0    0
#RESIDUE   LP   LP    1    6    3    5
#   1 LB       0    0    0.00      2    3    4    5    0
#   1 Q1   PSEUD    0    0.0000    0.0000    0.0000    0.0000    0    0    0    0    0
#   2 Q2   PSEUD    0    0.0000    1.0000    0.0000    0.0000    0    0    0    0    0
#   3 Q3   PSEUD    0    0.0000    1.0000    1.0000    0.0000    0    0    0    0    0
#   4 C    PSEUD    0    0.0000    2.0000    1.0000    0.0000    0    0    0    0    0
#   5 O    PSEUD    0    0.0000    2.0000   -0.2300    0.0000    0    0    0    0    0
#   6 N    PSEUD    0    0.0000    3.0920    1.7505    0.0000    0    0    0    0    0
#RESIDUE   LN   LN    1    6    3    5
#   1 LB       0    0    0.00      2    3    4    5    0
#   1 Q1   PSEUD    0    0.0000    0.0000    0.0000    0.0000    0    0    0    0    0
#   2 Q2   PSEUD    0    0.0000    1.0000    0.0000    0.0000    0    0    0    0    0
#   3 Q3   PSEUD    0    0.0000    1.0000    1.0000    0.0000    0    0    0    0    0
#   4 C3'  PSEUD    0    0.0000    2.0000    1.0000    0.0000    0    0    0    0    0
#   5 O3'  PSEUD    0    0.0000    2.0000   -0.4260    0.0000    0    0    0    0    0
#   6 P    PSEUD    0    0.0000    3.3856   -1.2260    0.0000    0    0    0    0    0
#
#RESIDUE   PLM  PLM    1    8    3    7
#   1 LB       0    0    0.00      2    3    4    6    0
#   1 C    PSEUD    0    0.0000   -0.6824   -1.1357    0.0000    0    0    0    0    0
#   2 O    PSEUD    0    0.0000   -0.1723   -2.2550    0.0000    0    0    0    0    0
#   3 N    PSEUD    0    0.0000    0.0000    0.0000    0.0000    0    0    0    0    0
#   4 Q1   PSEUD    0    0.0000    0.9971   -0.0762    0.0000    0    0    0    0    0
#   5 Q1'  PSEUD    0    0.0000    0.9971   -0.0762   10.0000    0    0    0    0    0
#   6 Q2   PSEUD    0    0.0000    1.0733    0.9209    0.0000    0    0    0    0    0
#   7 Q2'  PSEUD    0    0.0000    1.0733    0.9209   10.0000    0    0    0    0    0
#   8 Q3   PSEUD    0    0.0000    2.0704    0.8447    0.0000    0    0    0    0    0
#RESIDUE   NLM  NLM    1    8    3    7
#   1 LB       0    0    0.00      2    3    4    6    0
#   1 C3'  PSEUD    0    0.0000   -0.9681   -5.8551    2.5577    0    0    0    0    0
#   2 O3'  PSEUD    0    0.0000   -0.6348   -4.7127    1.7719    0    0    0    0    0
#   3 P    PSEUD    0    0.0000    0.4817   -3.6875    2.2842    0    0    0    0    0
#   4 Q1   PSEUD    0    0.0000    0.3487   -3.1324    1.4631    0    0    0    0    0
#   5 Q1'  PSEUD    0    0.0000    0.3487   -3.1324   10.0000    0    0    0    0    0
#   6 Q2   PSEUD    0    0.0000    1.0465   -2.4917    1.7833    0    0    0    0    0
#   7 Q2'  PSEUD    0    0.0000    1.0465   -2.4917   10.0000    0    0    0    0    0
#   8 Q3   PSEUD    0    0.0000    0.9136   -1.9366    0.9622    0    0    0    0    0
#RESIDUE   LLM  LLM    1    9    3    8
#   1 LB       0    0    0.00      2    3    5    7    0
#   1 Q1   PSEUD    0    0.0000    0.0000    0.0000    0.0000    0    0    0    0    0
#   2 Q2   PSEUD    0    0.0000    1.0000    0.0000    0.0000    0    0    0    0    0
#   3 Q3   PSEUD    0    0.0000    1.0000    1.0000    0.0000    0    0    0    0    0
#   4 Q3'  PSEUD    0    0.0000    1.0000    1.0000   10.0000    0    0    0    0    0
#   5 Q1   PSEUD    0    0.0000    2.0000    1.0000    0.0000    0    0    0    0    0
#   6 Q1'  PSEUD    0    0.0000    2.0000    1.0000   10.0000    0    0    0    0    0
#   7 Q2   PSEUD    0    0.0000    2.0000    0.0000    0.0000    0    0    0    0    0
#   8 Q2'  PSEUD    0    0.0000    2.0000    0.0000   10.0000    0    0    0    0    0
#   9 Q3   PSEUD    0    0.0000    3.0000    0.0000    0.0000    0    0    0    0    0
#RESIDUE   LLM2 LLM2    1    9    3    8
#   1 LB       0    0    0.00      2    3    5    7    0
#   1 Q1   PSEUD    0    0.0000    0.0000    0.0000    0.0000    0    0    0    0    0
#   2 Q2   PSEUD    0    0.0000    2.0000    0.0000    0.0000    0    0    0    0    0
#   3 Q3   PSEUD    0    0.0000    2.0000    2.0000    0.0000    0    0    0    0    0
#   4 Q3'  PSEUD    0    0.0000    2.0000    2.0000   10.0000    0    0    0    0    0
#   5 Q1   PSEUD    0    0.0000    4.0000    2.0000    0.0000    0    0    0    0    0
#   6 Q1'  PSEUD    0    0.0000    4.0000    2.0000   10.0000    0    0    0    0    0
#   7 Q2   PSEUD    0    0.0000    4.0000    0.0000    0.0000    0    0    0    0    0
#   8 Q2'  PSEUD    0    0.0000    4.0000    0.0000   10.0000    0    0    0    0    0
#   9 Q3   PSEUD    0    0.0000    6.0000    0.0000    0.0000    0    0    0    0    0
#RESIDUE   LLM5 LLM5    1    9    3    8
#   1 LB       0    0    0.00      2    3    5    7    0
#   1 Q1   PSEUD    0    0.0000    0.0000    0.0000    0.0000    0    0    0    0    0
#   2 Q2   PSEUD    0    0.0000    5.0000    0.0000    0.0000    0    0    0    0    0
#   3 Q3   PSEUD    0    0.0000    5.0000    5.0000    0.0000    0    0    0    0    0
#   4 Q3'  PSEUD    0    0.0000    5.0000    5.0000   10.0000    0    0    0    0    0
#   5 Q1   PSEUD    0    0.0000   10.0000    5.0000    0.0000    0    0    0    0    0
#   6 Q1'  PSEUD    0    0.0000   10.0000    5.0000   10.0000    0    0    0    0    0
#   7 Q2   PSEUD    0    0.0000   10.0000    0.0000    0.0000    0    0    0    0    0
#   8 Q2'  PSEUD    0    0.0000   10.0000    0.0000   10.0000    0    0    0    0    0
#   9 Q3   PSEUD    0    0.0000   15.0000    0.0000    0.0000    0    0    0    0    0
#RESIDUE   LPM  LPM    1    7    3    6
#   1 LB       0    0    0.00      2    3    5    6    0
#   1 Q1   PSEUD    0    0.0000    0.0000    0.0000    0.0000    0    0    0    0    0
#   2 Q2   PSEUD    0    0.0000    1.0000    0.0000    0.0000    0    0    0    0    0
#   3 Q3   PSEUD    0    0.0000    1.0000    1.0000    0.0000    0    0    0    0    0
#   4 Q3'  PSEUD    0    0.0000    1.0000    1.0000   10.0000    0    0    0    0    0
#   5 C    PSEUD    0    0.0000    2.0000    1.0000    0.0000    0    0    0    0    0
#   6 O    PSEUD    0    0.0000    2.0000   -0.2300    0.0000    0    0    0    0    0
#   7 N    PSEUD    0    0.0000    3.0920    1.7505    0.0000    0    0    0    0    0
#RESIDUE   LNM  LNM    1    7    3    6
#   1 LB       0    0    0.00      2    3    5    6    0
#   1 Q1   PSEUD    0    0.0000    0.0000    0.0000    0.0000    0    0    0    0    0
#   2 Q2   PSEUD    0    0.0000    1.0000    0.0000    0.0000    0    0    0    0    0
#   3 Q3   PSEUD    0    0.0000    1.0000    1.0000    0.0000    0    0    0    0    0
#   4 Q3'  PSEUD    0    0.0000    1.0000    1.0000   10.0000    0    0    0    0    0
#   5 C3'  PSEUD    0    0.0000    2.0000    1.0000    0.0000    0    0    0    0    0
#   6 O3'  PSEUD    0    0.0000    2.0000   -0.4260    0.0000    0    0    0    0    0
#   7 P    PSEUD    0    0.0000    3.3856   -1.2260    0.0000    0    0    0    0    0
#
#RESIDUE   LGLY LGLY    3   11    3   10
#   1 OMEGA   -1    2   10.0000    2    1    3    4    0
#   2 PHI      0    0    0.0000    1    3    5    9    0
#   3 PSI      0    0    0.0000    3    5    9   11    0
#   1 C    PSEUD    2    8.2024   -0.6824   -1.1357    0.0000    0    0    0    0    0
#   2 O    PSEUD    2   -7.0004   -0.1723   -2.2550    0.0000    0    0    0    0    0
#   3 N    PSEUD    2   -6.2650    0.0000    0.0000    0.0000    0    0    0    0    0
#   4 Q1   PSEUD    0    3.2103   -0.4226    0.9063    0.0000    0    0    0    0    0
#   5 Q2   PSEUD    3   -0.1556    1.4530    0.0000    0.0000    0    0    0    0    0
#   6 Q21  PSEUD    0    1.0041    1.8202   -0.5343    0.8762    0    0    0    0    0
#   7 Q22  PSEUD    0    1.0041    1.8202   -0.5343   -0.8762    0    0    0    0    0
#   8 Q3   PSEUD    0    0.0000    1.8202   -0.5343    0.0000    0    0    0    0    0
#   9 C    PSEUD    2    8.2024    2.0013    1.4284    0.0000    0    0    0    0    0
#  10 O    PSEUD    2   -7.0004    1.2356    2.3910    0.0000    0    0    0    0    0
#  11 N    PSEUD    2   -6.4912    3.3231    1.5208    0.0000    0    0    0    0    0
#"""
#proteinTable = """
## Correlation of hydrogen atom naming systems, including diastereotopic
## protons. The original version of this table was created by Charles 
## Hoogstraten.
##
## BMRB  = System in use at BioMagResBank (IUPAC/IUB Biochemistry 9, 3471-3479
##	  [1970]).
##
## SC    = Stereochemical designations 
##
## UCSF  = Mardigras-type software (peptide protonated with newhyd utility).
##
## XPLOR = Peptide protonated with XPLOR 3.1.  Atom nomenclature is derived
##	  from the X-PLOR topology file topallhdg.pro.  
##
## MSI   = Artificial peptide created with InsightII.  For the side chain
##	  protons attached to nitrogen in ASN, GLN, and ARG, the atom
##	  nomenclature does not reflect the potential stereoisomerism of the
##	  planar amide and guanidinium groups.  The correlation with Z and E
##	  nomenclature listed here simply reflects the state of the artificial
##	  peptide generated as an example.  The CG1 and CG2 atoms for VAL in a
##	  peptide generated by InsightII are not labeled according to IUPAC
##	  rules, while the CD1 and CD2 atoms for LEU are.
##
## PDB   = PDB nomenclature (Taken from PDB entry 6I1B REVDAT 15-OCT-92.)
##
## SYBYL = The atom nomenclature was taken from the xxx.res files supplied with
##	  the software package Sybyl version 6.2 from Tripos, Inc.  
##
## MIDAS = MidasPlus from the Computer Graphics Laboratory at UCSF.  The atom 
##	  nomenclature has been taken from the XXX.ins files supplied with the
##	  software.  The prochiral atoms have not been correlated with the
##	  BMRB assignments at this time.  Hydrogens are not included in the
##	  XXX.ins template files.
##
## Note-1: The prochiral methyl group names may reflect convention of code
##	  generating heavy atom names if protons are added later.
##
## Note-2: '*' The stereochemical assignments for the named atoms have not been
##	  determined for these software systems.
##
## Note-3: The Z and E nomenclature is defined in the paper by Blackwood, J.E.,
##	  Gladys, C.L., Loening, K.L., Petrarca, A.E., and Rush, J.E., 
##	  "Unambiguous Specification of Stereoisomerism about a Double Bond,"
##	  J. Amer. Chem. Soc. 90, 509-510 (1968).
##
## Note-3: For the terminal amine and carboxyl atoms, 'X' and 'Z' have been used as a
##	  dummy value for the amino acid type.
##
## Note-4: The terminal secondary amine protons for PRO have been included
##	  with the other PRO atoms.
##
## Note-5: Fields in the table are separated by tabs.
##
## Note-6: Please report errors, updates, or extensions to Eldon Ulrich
##	  (elu@nmrfam.wisc.edu)
##
## Note-7: from BMRB atom_nom.tbl and pseudoatom_nom.txt
##	  Augmented with '-' to make a fixed collumn number table.
##         Augmented IUPAC collumn to match BMRB shifts format
##
## Note-8: Original pseudoatom_nom.txt
## Amino Acid Pseudoatom Nomenclature
## Correlation of hydrogen pseudoatom naming systems.
##(The original table was prepared by Jane Caldwell)
##
## BMRB = BioMagResBank, derived from IUPAC recommendations
## IUPAC= BioMagResBank, from depositions
## UCSF = Mardigras and Corma, based on 1993 manual (still current, summer 1995)
## XPLOR= X-PLOR 3.1f
#
##++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
#
## A.A.		BMRB	IUPAC	SC	PDB	UCSF	MSI	XPLOR	SYBYL* MIDAS* CYANA
## ----		----	----	----	----	----	----	-----	-----	-----	-----
#
## Terminal amine protons protons
#
#X		H1	H1	-	1H	HN1	HN1	HT1	HNCAP	-	-
#X		H2	H2	-	2H	HN2	HN2	HT2	-	-	-
#X		H3	H3	-	3H	HN3	HN3	HT3	-	-	-
#
## Terminal carboxyl atomxyl atoms
#
#Z		H	H	-	-	-	-	-	HOCAP	-	-
#Z		O1	O1	-	O	-	O	OT1	O	O	-
#Z		O2	O2	-	OXT	-	OXT	OT2	OXT	OXT	-
#
## Residue atoms
#
#A		H	H	-	H	HN	HN	HN	H	-	HN
#A		HA	HA	-	HA	HA	HA	HA	HA	-	HA
#A		HB1	-	-	1HB	HB1	HB1	HB1	HB1	-	HB1
#A		HB2	-	-	2HB	HB2	HB2	HB2	HB2	-	HB2
#A		HB3	-	-	3HB	HB3	HB3	HB3	HB3	-	HB3
#A		C	C	-	C	-	C	C	C	C	C
#A		CA	CA	-	CA	-	CA	CA	CA	CA	CA
#A		CB	CB	-	CB	-	CB	CB	CB	CB	CB
#A		N	N	-	N	-	N	N	N	N	N
#A		O	O	-	O	-	O	O	O	O	O
#A 		MB 	HB 	- 	- 	MB 	- 	HB*,HB#,HB%,HB+ - -  	QB
#
## ARG removed the HH12 protons, HH1 in BMRB and CYANA, guessed other names 
#ARG		H	H	-	H	HN	HN	HN	H	-	HN
#ARG		HA	HA	-	HA	HA	HA	HA	HA	-	HA
#ARG		HB2	HB2	pro-R	1HB	HB1	HB1	HB2	HB2	-	HB2
#ARG		HB3	HB3	pro-S	2HB	HB2	HB2	HB1	HB1	-	HB3
#ARG		HG2	HG2	pro-S	1HG	HG1	HG1	HG2	HG2	-	HG2
#ARG		HG3	HG3	pro-R	2HG	HG2	HG2	HG1	HG1	-	HG3
#ARG		HD2	HD2	pro-S	1HD	HD1	HD1	HD2	HD2	-	HD2
#ARG		HD3	HD3	pro-R	2HD	HD2	HD2	HD1	HD1	-	HD3
#ARG		HE	HE	-	HE	HNE	HE	HE	HE	-	HE
#ARG		HH1	HH1	Z	HH1	HN1	HH1	HH1	HH1	-	HH1
#ARG		HH21	HH21	Z	1HH2	HN21	HH22	HH21	HH21	-	HH21
#ARG		HH22	HH22	E	2HH2	HN22	HH21	HH22	HH22	-	HH22
#ARG		C	C	-	C	-	C	C	C	C	C
#ARG		CA	CA	-	CA	-	CA	CA	CA	CA	CA
#ARG		CB	CB	-	CB	-	CB	CB	CB	CB	CB
#ARG		CG	CG	-	CG	-	CG	CG	CG	CG	CG
#ARG		CD	CD	-	CD	-	CD	CD	CD	CD	CD
#ARG		CZ	CZ	-	CZ	-	CZ	CZ	CZ	CZ	CZ
#ARG		N	N	-	N	-	N	N	N	N	N
#ARG		NE	NE	-	NE	-	NE	NE	NE	NE	NE
#ARG		NH1	NH1	Z	NH1	-	NH1	NH1	NH1	NH1	NH1
#ARG		NH2	NH2	E	NH2	-	NH2	NH2	NH2	NH2	NH2
#ARG		O	O	-	O	-	O	O	O	O	O
#ARG 		QB 	- 	- 	- 	QB 	- 	HB*,HB#,HB%,HB+     - - QB
#ARG 		QG 	- 	- 	- 	QG 	- 	HG*,HG#,HG%,HG+     - - QG
#ARG 		QD 	- 	- 	- 	QD 	- 	HD*,HD#,HD%,HD+     - - QD
#ARG 		QH1 	- 	- 	- 	QH1 	- 	HH1*,HH1#,HH1%,HH1+ - - QH1
#ARG 		QH2 	- 	- 	- 	QH2 	- 	HH2*,HH2#,HH2%,HH2+ - - QH2
#
#ARG+		H	H	-	H	HN	HN	HN	H	-	HN
#ARG+		HA	HA	-	HA	HA	HA	HA	HA	-	HA
#ARG+		HB2	HB2	pro-R	1HB	HB1	HB1	HB2	HB2	-	HB2
#ARG+		HB3	HB3	pro-S	2HB	HB2	HB2	HB1	HB1	-	HB3
#ARG+		HG2	HG2	pro-S	1HG	HG1	HG1	HG2	HG2	-	HG2
#ARG+		HG3	HG3	pro-R	2HG	HG2	HG2	HG1	HG1	-	HG3
#ARG+		HD2	HD2	pro-S	1HD	HD1	HD1	HD2	HD2	-	HD2
#ARG+		HD3	HD3	pro-R	2HD	HD2	HD2	HD1	HD1	-	HD3
#ARG+		HE	HE	-	HE	HNE	HE	HE	HE	-	HE
#ARG+		HH11	HH11	Z	1HH1	HN11	HH11	HH11	HH11	-	HH11
#ARG+		HH12	HH12	E	2HH1	HN12	HH12	HH12	HH12	-	HH12
#ARG+		HH21	HH21	Z	1HH2	HN21	HH22	HH21	HH21	-	HH21
#ARG+		HH22	HH22	E	2HH2	HN22	HH21	HH22	HH22	-	HH22
#ARG+		C	C	-	C	-	C	C	C	C	C
#ARG+		CA	CA	-	CA	-	CA	CA	CA	CA	CA
#ARG+		CB	CB	-	CB	-	CB	CB	CB	CB	CB
#ARG+		CG	CG	-	CG	-	CG	CG	CG	CG	CG
#ARG+		CD	CD	-	CD	-	CD	CD	CD	CD	CD
#ARG+		CZ	CZ	-	CZ	-	CZ	CZ	CZ	CZ	CZ
#ARG+		N	N	-	N	-	N	N	N	N	N
#ARG+		NE	NE	-	NE	-	NE	NE	NE	NE	NE
#ARG+		NH1	NH1	Z	NH1	-	NH1	NH1	NH1	NH1	NH1
#ARG+		NH2	NH2	E	NH2	-	NH2	NH2	NH2	NH2	NH2
#ARG+		O	O	-	O	-	O	O	O	O	O
#ARG+ 		QB 	- 	- 	- 	QB 	- 	HB*,HB#,HB%,HB+     - - QB
#ARG+ 		QG 	- 	- 	- 	QG 	- 	HG*,HG#,HG%,HG+     - - QG
#ARG+ 		QD 	- 	- 	- 	QD 	- 	HD*,HD#,HD%,HD+     - - QD
#ARG+ 		QH1 	- 	- 	- 	QH1 	- 	HH1*,HH1#,HH1%,HH1+ - - QH1
#ARG+ 		QH2 	- 	- 	- 	QH2 	- 	HH2*,HH2#,HH2%,HH2+ - - QH2
#
#ASP		H	H	-	H	HN	HN	HN	H	-	HN
#ASP		HA	HA	-	HA	HA	HA	HA	HA	-	HA
#ASP		HB2	HB2	pro-S	1HB	HB1	HB1	HB2	HB2	-	HB2
#ASP		HB3	HB3	pro-R	2HB	HB2	HB2	HB1	HB1	-	HB3
#ASP		HD2	HD2	-	-	-	HD2	-	-	-	HD2
#ASP		C	C	-	C	-	C	C	C	C	C
#ASP		CA	CA	-	CA	-	CA	CA	CA	CA	CA
#ASP		CB	CB	-	CB	-	CB	CB	CB	CB	CB
#ASP		CG	CG	-	CG	-	CG	CG	CG	CG	CG
#ASP		N	N	-	N	-	N	N	N	N	N
#ASP		O	O	-	O	-	O	O	O	O	O
#ASP		OD1	OD1	-	OD1	-	OD1	OD1	OD1	OD1	OD1
#ASP		OD2	OD2	-	OD2	-	OD2	OD2	OD2	OD2	OD2
#ASP 		QB 	- 	- 	- 	QB 	- 	HB*,HB#,HB%,HB+ - -  	QB
#
## ASP- lacks HD2
#ASP-		H	H	-	H	HN	HN	HN	H	-	HN
#ASP-		HA	HA	-	HA	HA	HA	HA	HA	-	HA
#ASP-		HB2	HB2	pro-S	1HB	HB1	HB1	HB2	HB2	-	HB2
#ASP-		HB3	HB3	pro-R	2HB	HB2	HB2	HB1	HB1	-	HB3
#ASP-		C	C	-	C	-	C	C	C	C	C
#ASP-		CA	CA	-	CA	-	CA	CA	CA	CA	CA
#ASP-		CB	CB	-	CB	-	CB	CB	CB	CB	CB
#ASP-		CG	CG	-	CG	-	CG	CG	CG	CG	CG
#ASP-		N	N	-	N	-	N	N	N	N	N
#ASP-		O	O	-	O	-	O	O	O	O	O
#ASP-		OD1	OD1	-	OD1	-	OD1	OD1	OD1	OD1	OD1
#ASP-		OD2	OD2	-	OD2	-	OD2	OD2	OD2	OD2	OD2
#ASP- 		QB 	- 	- 	- 	QB 	- 	HB*,HB#,HB%,HB+ - -  	QB
#
#N		H	H	-	H	HN	HN	HN	H	-	HN
#N		HA	HA	-	HA	HA	HA	HA	HA	-	HA
#N		HB2	HB2	pro-S	1HB	HB1	HB1	HB2	HB2	-	HB2
#N		HB3	HB3	pro-R	2HB	HB2	HB2	HB1	HB1	-	HB3
#N		HD21	HD21	E	2HD2	HN21	HD21	HD21	HD21	-	HD21
#N		HD22	HD22	Z	1HD2	HN22	HD22	HD22	HD22	-	HD22
#N		C	C	-	C	-	C	C	C	C	C
#N		CA	CA	-	CA	-	CA	CA	CA	CA	CA
#N		CB	CB	-	CB	-	CB	CB	CB	CB	CB
#N		CG	CG	-	CG	-	CG	CG	CG	CG	CG
#N		N	N	-	N	-	N	N	N	N	N
#N		ND2	ND2	-	ND2	-	ND2	ND2	ND2	ND2	ND2
#N		O	O	-	O	-	O	O	O	O	O
#N		OD1	OD1	-	OD1	-	OD1	OD1	OD1	OD1	OD1
#N 		QB 	- 	- 	- 	QB 	- 	HB*,HB#,HB%,HB+ - -  	QB
#N 		QD 	- 	- 	- 	QD 	- 	HD2*,HD2#,HD2%,HD2+,HD*,HD# - - QD2
#
#C		H	H	-	H	HN	HN	HN	H	-	HN
#C		HA	HA	-	HA	HA	HA	HA	HA	-	HA
#C		HB2	HB2	pro-S	1HB	HB1	HB1	HB2	HB2	-	HB2
#C		HB3	HB3	pro-R	2HB	HB2	HB2	HB1	HB1	-	HB3
#C		HG	HG	-	HG	HSG	HG	HG	HG	-	HG
#C		C	C	-	C	-	C	C	C	C	C
#C		CA	CA	-	CA	-	CA	CA	CA	CA	CA
#C		CB	CB	-	CB	-	CB	CB	CB	CB	CB
#C		N	N	-	N	-	N	N	N	N	N
#C		O	O	-	O	-	O	O	O	O	O
#C		SG	SG	-	SG	-	SG	SG	SG	SG	SG
#C 		QB 	- 	- 	- 	QB 	- 	HB*,HB#,HB%,HB+ - -  	QB
#
#GLU		H	H	-	H	HN	HN	HN	H	-	HN
#GLU		HA	HA	-	HA	HA	HA	HA	HA	-	HA
#GLU		HB2	HB2	pro-R	1HB	HB1	HB1	HB2	HB2	-	HB2
#GLU		HB3	HB3	pro-S	2HB	HB2	HB2	HB1	HB1	-	HB3
#GLU		HG2	HG2	pro-S	1HG	HG1	HG1	HG2	HG2	-	HG2
#GLU		HG3	HG3	pro-R	2HG	HG2	HG2	HG1	HG1	-	HG3
#GLU		HE2	HE2	-	-	-	HE2	-	-	-	HE2
#GLU		C	C	-	C	-	C	C	C	C	C
#GLU		CA	CA	-	CA	-	CA	CA	CA	CA	CA
#GLU		CB	CB	-	CB	-	CB	CB	CB	CB	CB
#GLU		CG	CG	-	CG	-	CG	CG	CG	CG	CG
#GLU		CD	CD	-	CD	-	CD	CD	CD	CD	CD
#GLU		N	N	-	N	-	N	N	N	N	N
#GLU		O	O	-	O	-	O	O	O	O	O
#GLU		OE1	OE1	-	OE1	-	OE1	OE1	OE1	OE1	OE1
#GLU		OE2	OE2	-	OE2	-	OE2	OE2	OE2	OE2	OE2
#GLU		QB	-	-	-	QB	-	HB*,HB#,HB%,HB+ - -	QB
#GLU 		QG 	- 	- 	- 	QG 	- 	HG*,HG#,HG%,HG+ - -  	QG
#
## GLU- lacks HE2
#GLU-		H	H	-	H	HN	HN	HN	H	-	HN
#GLU-		HA	HA	-	HA	HA	HA	HA	HA	-	HA
#GLU-		HB2	HB2	pro-R	1HB	HB1	HB1	HB2	HB2	-	HB2
#GLU-		HB3	HB3	pro-S	2HB	HB2	HB2	HB1	HB1	-	HB3
#GLU-		HG2	HG2	pro-S	1HG	HG1	HG1	HG2	HG2	-	HG2
#GLU-		HG3	HG3	pro-R	2HG	HG2	HG2	HG1	HG1	-	HG3
#GLU-		C	C	-	C	-	C	C	C	C	C
#GLU-		CA	CA	-	CA	-	CA	CA	CA	CA	CA
#GLU-		CB	CB	-	CB	-	CB	CB	CB	CB	CB
#GLU-		CG	CG	-	CG	-	CG	CG	CG	CG	CG
#GLU-		CD	CD	-	CD	-	CD	CD	CD	CD	CD
#GLU-		N	N	-	N	-	N	N	N	N	N
#GLU-		O	O	-	O	-	O	O	O	O	O
#GLU-		OE1	OE1	-	OE1	-	OE1	OE1	OE1	OE1	OE1
#GLU-		OE2	OE2	-	OE2	-	OE2	OE2	OE2	OE2	OE2
#GLU- 		QB 	- 	- 	- 	QB 	- 	HB*,HB#,HB%,HB+ - -  	QB
#GLU- 		QG 	- 	- 	- 	QG 	- 	HG*,HG#,HG%,HG+ - -  	QG
#
#Q		H	H	-	H	HN	HN	HN	H	-	HN
#Q		HA	HA	-	HA	HA	HA	HA	HA	-	HA
#Q		HB2	HB2	pro-R	1HB	HB1	HB1	HB2	HB2	-	HB2
#Q		HB3	HB3	pro-S	2HB	HB2	HB2	HB1	HB1	-	HB3
#Q		HG2	HG2	pro-S	1HG	HG1	HG1	HG2	HG2	-	HG2
#Q		HG3	HG3	pro-R	2HG	HG2	HG2	HG1	HG1	-	HG3
#Q		HE21	HE21	E	2HE2	HN21	HE21	HE21	HE21	-	HE21
#Q		HE22	HE22	Z	1HE2	HN22	HE22	HE22	HE22	-	HE22
#Q		C	C	-	C	-	C	C	C	C	C
#Q		CA	CA	-	CA	-	CA	CA	CA	CA	CA
#Q		CB	CB	-	CB	-	CB	CB	CB	CB	CB
#Q		CG	CG	-	CG	-	CG	CG	CG	CG	CG
#Q		CD	CD	-	CD	-	CD	CD	CD	CD	CD
#Q		N	N	-	N	-	N	N	N	N	N
#Q		NE2	NE2	-	NE2	-	NE2	NE2	NE2	NE2	NE2
#Q		O	O	-	O	-	O	O	O	O	O
#Q		OE1	OE1	-	OE1	-	OE1	OE1	OE1	OE1	OE1
#Q 		QB 	- 	- 	- 	QB 	- 	HB*,HB#,HB%,HB+ - -  	QB
#Q 		QG 	- 	- 	- 	QG 	- 	HG*,HG#,HG%,HG+ - -  	QG
#Q 		QE 	- 	- 	- 	QE 	- 	HE2*,HE2#,HE2%,HE2+,HE*,HE# - - QE2
#
#G		H	H	-	H	HN	HN	HN	H	-	HN
#G		HA2	HA2	pro-R	1HA	HA1	HA1	HA2	HA2	-	HA1
#G		HA3	HA3	pro-S	2HA	HA2	HA2	HA1	HA1	-	HA2
#G		C	C	-	C	-	C	C	C	C	C
#G		CA	CA	-	CA	-	CA	CA	CA	CA	CA
#G		N	N	-	N	-	N	N	N	N	N
#G		O	O	-	O	-	O	O	O	O	O
#G 		QA 	- 	- 	- 	QA 	- 	HA*,HA#,HA%,HA+ - -  	QA
#
#H		H	H	-	H	HN	HN	HN	H	-	HN
#H		HA	HA	-	HA	HA	HA	HA	HA	-	HA
#H		HB2	HB2	pro-S	1HB	HB1	HB1	HB2	HB2	-	HB2
#H		HB3	HB3	pro-R	2HB	HB2	HB2	HB1	HB1	-	HB3
#H		HD1	HD1	-	HD1	HND1	HD1	HD1	HD1	-	HD1
#H		HD2	HD2	-	HD2	HD2	HD2	HD2	HD2	-	HD2
#H		HE1	HE1	-	HE1	HE1	HE1	HE1	HE1	-	HE1
#H		HE2	HE2	-	-	HNE2	HE2	-	-	-	HE2
#H		C	C	-	C	-	C	C	C	C	C
#H		CA	CA	-	CA	-	CA	CA	CA	CA	CA
#H		CB	CB	-	CB	-	CB	CB	CB	CB	CB
#H		CG	CG	-	CG	-	CG	CG	CG	CG	CG
#H		CD2	CD2	-	CD2	-	CD2	CD2	CD2	CD2	CD2
#H		CE1	CE1	-	CE1	-	CE1	CE1	CE1	CE1	CE1
#H		N	N	-	N	-	N	N	N	N	N
#H		ND1	ND1	-	ND1	-	ND1	ND1	ND1	ND1	ND1
#H		NE2	NE2	-	NE2	-	NE2	NE2	NE2	NE2	NE2
#H		O	O	-	O	-	O	O	O	O	O
#H 		QB 	- 	- 	- 	QB 	- 	HB*,HB#,HB%,HB+ - -  	QB
#
#I		H	H	-	H	HN	HN	HN	H	-	HN
#I		HA	HA	-	HA	HA	HA	HA	HA	-	HA
#I		HB	HB	-	HB	HB	HB	HB	HB	-	HB
#I		HG12	HG12	pro-R	1HG1	HG11	HG11	HG12	HG12	-	HG12
#I		HG13	HG13	pro-S	2HG1	HG12	HG12	HG11	HG11	-	HG13
#I		HG21	-	-	1HG2	HG21	HG21	HG21	HG21	-	HG21
#I		HG22	-	-	2HG2	HG22	HG22	HG22	HG22	-	HG22
#I		HG23	-	-	3HG2	HG23	HG23	HG23	HG23	-	HG23
#I		HD11	-	-	1HD1	HD11	HD11	HD11	HD11	-	HD11
#I		HD12	-	-	2HD1	HD12	HD12	HD12	HD12	-	HD12
#I		HD13	-	-	3HD1	HD13	HD13	HD13	HD13	-	HD13
#I		C	C	-	C	-	C	C	C	C	C
#I		CA	CA	-	CA	-	CA	CA	CA	CA	CA
#I		CB	CB	-	CB	-	CB	CB	CB	CB	CB
#I		CG1	CG1	-	CG1	-	CG1	CG1	CG1	CG1	CG1
#I		CG2	CG2	-	CG2	-	CG2	CG2	CG2	CG2	CG2
#I		CD1	CD1	-	CD1	-	CD1	CD1	CD1	CD1	CD1
#I		N	N	-	N	-	N	N	N	N	N
#I		O	O	-	O	-	O	O	O	O	O
#I 		MG 	HG2 	- 	- 	MG2 	- 	HG2*,HG2#,HG2%,HG2+ - - QG2
#I 		MD 	HD1 	- 	- 	MD1 	- 	HD1*,HD1#,HD1%,HD1+,HD*,HD# - - QD1
#I 		QG 	- 	- 	- 	QG 	- 	HG1*,HG1#,HG1%,HG1+ - - QG1
#
#L		H	H	-	H	HN	HN	HN	H	-	HN
#L		HA	HA	-	HA	HA	HA	HA	HA	-	HA
#L		HB2	HB2	pro-R	1HB	HB1	HB1	HB2	HB2	-	HB2
#L		HB3	HB3	pro-S	2HB	HB2	HB2	HB1	HB1	-	HB3
#L		HG	HG	-	HG	HG	HG	HG	HG	-	HG
#L		HD11	-	-	1HD1	HD11	HD11	HD11	HD11	-	HD11
#L		HD12	-	-	2HD1	HD12	HD12	HD12	HD12	-	HD12
#L		HD13	-	-	3HD1	HD13	HD13	HD13	HD13	-	HD13
#L		HD21	-	-	1HD2	HD21	HD21	HD21	HD21	-	HD21
#L		HD22	-	-	2HD2	HD22	HD22	HD22	HD22	-	HD22
#L		HD23	-	-	3HD2	HD23	HD23	HD23	HD23	-	HD23
#L		C	C	-	C	-	C	C	C	C	C
#L		CA	CA	-	CA	-	CA	CA	CA	CA	CA
#L		CB	CB	-	CB	-	CB	CB	CB	CB	CB
#L		CG	CG	-	CG	-	CG	CG	CG	CG	CG
#L		CD1	CD1	pro-R	CD1	-	CD1	CD1	CD1	CD1	CD1
#L		CD2	CD2	pro-S	CD2	-	CD2	CD2	CD2	CD2	CD2
#L		N	N	-	N	-	N	N	N	N	N
#L		O	O	-	O	-	O	O	O	O	O
#L 		MD1 	HD1 	- 	- 	MD1 	- 	HD1*,HD1#,HD1%,HD1+ - - QD1
#L 		MD2 	HD2 	- 	- 	MD2 	- 	HD2*,HD2#,HD2%,HD2+ - - QD2
#L 		QB 	- 	- 	- 	QB 	- 	HB*,HB#,HB%,HB+ - -  	QB
#L 		QD 	- 	- 	- 	- 	- 	HD*,HD# 	- -  	QQD
#
## LYS should lack one of the protons, but I do not know which one
#LYS		H	H	-	H	HN	HN	HN	H	-	HN
#LYS		HA	HA	-	HA	HA	HA	HA	HA	-	HA
#LYS		HB2	HB2	pro-R	1HB	HB1	HB1	HB2	HB2	-	HB2
#LYS		HB3	HB3	pro-S	2HB	HB2	HB2	HB1	HB1	-	HB3
#LYS		HG2	HG2	pro-R	1HG	HG1	HG1	HG2	HG2	-	HG2
#LYS		HG3	HG3	pro-S	2HG	HG2	HG2	HG1	HG1	-	HG3
#LYS		HD2	HD2	pro-S	1HD	HD1	HD1	HD2	HD2	-	HD2
#LYS		HD3	HD3	pro-R	2HD	HD2	HD2	HD1	HD1	-	HD3
#LYS		HE2	HE2	pro-S	1HE	HE1	HE1	HE2	HE2	-	HE2
#LYS		HE3	HE3	pro-R	2HE	HE2	HE2	HE1	HE1	-	HE3
#LYS		HZ1	HZ1	-	1HZ	HNZ1	HZ1	HZ1	HZ1	-	HZ1
#LYS		HZ2	HZ2	-	2HZ	HNZ2	HZ2	HZ2	HZ2	-	HZ2
#LYS		HZ3	HZ3	-	3HZ	HNZ3	HZ3	HZ3	HZ3	-	HZ3
#LYS		C	C	-	C	-	C	C	C	C	C
#LYS		CA	CA	-	CA	-	CA	CA	CA	CA	CA
#LYS		CB	CB	-	CB	-	CB	CB	CB	CB	CB
#LYS		CG	CG	-	CG	-	CG	CG	CG	CG	CG
#LYS		CD	CD	-	CD	-	CD	CD	CD	CD	CD
#LYS		CE	CE	-	CE	-	CE	CE	CE	CE	CE
#LYS		N	N	-	N	-	N	N	N	N	N
#LYS		NZ	NZ	-	NZ	-	NZ	NZ	NZ	NZ	NZ
#LYS		O	O	-	O	-	O	O	O	O	O
#LYS 	QB 	- 	- 	- 	QB 	- 	HB*,HB#,HB%,HB+ - -  	QB
#LYS 	QG 	- 	- 	- 	QG 	- 	HG*,HG#,HG%,HG+ - -  	QG
#LYS 	QD 	- 	- 	- 	QD 	- 	HD*,HD#,HD%,HD+ - -  	QD
#LYS 	QE 	- 	- 	- 	QE 	- 	HE*,HE#,HE%,HE+ - -  	QE
#LYS 	QZ 	- 	- 	- 	QZ 	- 	HZ*,HZ#,HZ%,HZ+ - -  	QZ
#
#LYS+	H	H	-	H	HN	HN	HN	H	-	HN
#LYS+	HA	HA	-	HA	HA	HA	HA	HA	-	HA
#LYS+	HB2	HB2	pro-R	1HB	HB1	HB1	HB2	HB2	-	HB2
#LYS+	HB3	HB3	pro-S	2HB	HB2	HB2	HB1	HB1	-	HB3
#LYS+	HG2	HG2	pro-R	1HG	HG1	HG1	HG2	HG2	-	HG2
#LYS+	HG3	HG3	pro-S	2HG	HG2	HG2	HG1	HG1	-	HG3
#LYS+	HD2	HD2	pro-S	1HD	HD1	HD1	HD2	HD2	-	HD2
#LYS+	HD3	HD3	pro-R	2HD	HD2	HD2	HD1	HD1	-	HD3
#LYS+	HE2	HE2	pro-S	1HE	HE1	HE1	HE2	HE2	-	HE2
#LYS+	HE3	HE3	pro-R	2HE	HE2	HE2	HE1	HE1	-	HE3
#LYS+	HZ1	HZ1	-	1HZ	HNZ1	HZ1	HZ1	HZ1	-	HZ1
#LYS+	HZ2	HZ2	-	2HZ	HNZ2	HZ2	HZ2	HZ2	-	HZ2
#LYS+	HZ3	HZ3	-	3HZ	HNZ3	HZ3	HZ3	HZ3	-	HZ3
#LYS+	C	C	-	C	-	C	C	C	C	C
#LYS+	CA	CA	-	CA	-	CA	CA	CA	CA	CA
#LYS+	CB	CB	-	CB	-	CB	CB	CB	CB	CB
#LYS+	CG	CG	-	CG	-	CG	CG	CG	CG	CG
#LYS+	CD	CD	-	CD	-	CD	CD	CD	CD	CD
#LYS+	CE	CE	-	CE	-	CE	CE	CE	CE	CE
#LYS+	N	N	-	N	-	N	N	N	N	N
#LYS+	NZ	NZ	-	NZ	-	NZ	NZ	NZ	NZ	NZ
#LYS+	O	O	-	O	-	O	O	O	O	O
#LYS+ 	QB 	- 	- 	- 	QB 	- 	HB*,HB#,HB%,HB+ - -  	QB
#LYS+ 	QG 	- 	- 	- 	QG 	- 	HG*,HG#,HG%,HG+ - -  	QG
#LYS+ 	QD 	- 	- 	- 	QD 	- 	HD*,HD#,HD%,HD+ - -  	QD
#LYS+ 	QE 	- 	- 	- 	QE 	- 	HE*,HE#,HE%,HE+ - -  	QE
#LYS+ 	QZ 	- 	- 	- 	QZ 	- 	HZ*,HZ#,HZ%,HZ+ - -  	QZ
#
#M		H	H	-	H	HN	HN	HN	H	-	HN
#M		HA	HA	-	HA	HA	HA	HA	HA	-	HA
#M		HB2	HB2	pro-S	1HB	HB1	HB1	HB2	HB2	-	HB2
#M		HB3	HB3	pro-R	2HB	HB2	HB2	HB1	HB1	-	HB3
#M		HG2	HG2	pro-S	1HG	HG1	HG1	HG2	HG2	-	HG2
#M		HG3	HG3	pro-R	2HG	HG2	HG2	HG1	HG1	-	HG3
#M		HE1	-	-	1HE	HE1	HE1	HE1	HE1	-	HE1
#M		HE2	-	-	2HE	HE2	HE2	HE2	HE2	-	HE2
#M		HE3	-	-	3HE	HE3	HE3	HE3	HE3	-	HE3
#M		C	C	-	C	-	C	C	C	C	C
#M		CA	CA	-	CA	-	CA	CA	CA	CA	CA
#M		CB	CB	-	CB	-	CB	CB	CB	CB	CB
#M		CG	CG	-	CG	-	CG	CG	CG	CG	CG
#M		CE	CE	-	CE	-	CE	CE	CE	CE	CE
#M		N	N	-	N	-	N	N	N	N	N
#M		O	O	-	O	-	O	O	O	O	O
#M		SD	SD	-	SD	-	SD	SD	SD	SD	SD
#M 		QB 	- 	- 	- 	QB 	- 	HB*,HB#,HB%,HB+ - -  	QB
#M 		QG 	- 	- 	- 	QG 	- 	HG*,HG#,HG%,HG+ - -  	QG
#M 		ME 	HE 	- 	- 	ME 	- 	HE*,HE#,HE%,HE+ - -  	QE
#
#F		H	H	-	H	HN	HN	HN	H	-	HN
#F		HA	HA	-	HA	HA	HA	HA	HA	-	HA
#F		HB2	HB2	pro-R	1HB	HB1	HB1	HB2	HB2	-	HB2
#F		HB3	HB3	pro-S	2HB	HB2	HB2	HB1	HB1	-	HB3
#F		HD1	HD1	-	HD1	HD1	HD1	HD1	HD1	-	HD1
#F		HD2	HD2	-	HD2	HD2	HD2	HD2	HD2	-	HD2
#F		HE1	HE1	-	HE1	HE1	HE1	HE1	HE1	-	HE1
#F		HE2	HE2	-	HE2	HE2	HE2	HE2	HE2	-	HE2
#F		HZ	HZ	-	HZ	HZ	HZ	HZ	HZ	-	HZ
#F		C	C	-	C	-	C	C	C	C	C
#F		CA	CA	-	CA	-	CA	CA	CA	CA	CA
#F		CB	CB	-	CB	-	CB	CB	CB	CB	CB
#F		CG	CG	-	CG	-	CG	CG	CG	CG	CG
#F		CD1	CD1	-	CD1	-	CD1	CD1	CD1	CD1	CD1
#F		CD2	CD2	-	CD2	-	CD2	CD2	CD2	CD2	CD2
#F		CE1	CE1	-	CE1	-	CE1	CE1	CE1	CE1	CE1
#F		CE2	CE2	-	CE2	-	CE2	CE2	CE2	CE2	CE2
#F		CZ	CZ	-	CZ	-	CZ	CZ	CZ	CZ	CZ
#F		N	N	-	N	-	N	N	N	N	N
#F		O	O	-	O	-	O	O	O	O	O
#F 		QB 	- 	- 	- 	QB 	- 	HB*,HB#,HB%,HB+ - -  	QB
#F 		QD 	- 	- 	- 	RD 	- 	HD*,HD#,HD%,HD+ - -  	QD
#F 		QE 	- 	- 	- 	RE 	- 	HE*,HE#,HE%,HE+ - -  	QE
#F 		QR 	- 	- 	- 	- 	- 	- 	- 	-  	QR
#
#P		H2	H2	pro-R	H2	-	HN2	HT2	-	-	-
#P		H3	H3	pro-S	H1	-	HN1	HT1	-	-	-
#P		HA	HA	-	HA	HA	HA	HA	HA	-	HA
#P		HB2	HB2	pro-R	1HB	HB1	HB1	HB2	HB2	-	HB2
#P		HB3	HB3	pro-S	2HB	HB2	HB2	HB1	HB1	-	HB3
#P		HG2	HG2	pro-S	1HG	HG1	HG1	HG2	HG2	-	HG2
#P		HG3	HG3	pro-R	2HG	HG2	HG2	HG1	HG1	-	HG3
#P		HD2	HD2	pro-S	1HD	HD2	HD1	HD2	HD2	-	HD2
#P		HD3	HD3	pro-R	2HD	HD1	HD2	HD1	HD1	-	HD3
#P		C	C	-	C	-	C	C	C	C	C
#P		CA	CA	-	CA	-	CA	CA	CA	CA	CA
#P		CB	CB	-	CB	-	CB	CB	CB	CB	CB
#P		CG	CG	-	CG	-	CG	CG	CG	CG	CG
#P		CD	CD	-	CD	-	CD	CD	CD	CD	CD
#P		N	N	-	N	-	N	N	N	N	N
#P		O	O	-	O	-	O	O	O	O	O
#P 		QB 	- 	- 	- 	QB 	- 	HB*,HB#,HB%,HB+ - -  	QB
#P 		QG 	- 	- 	- 	QG 	- 	HG*,HG#,HG%,HG+ - -  	QG
#P 		QD 	- 	- 	- 	QD 	- 	HD*,HD#,HD%,HD+ - -  	QD
#
#S		H	H	-	H	HN	HN	HN	H	-	HN
#S		HA	HA	-	HA	HA	HA	HA	HA	-	HA
#S		HB2	HB2	pro-S	1HB	HB1	HB1	HB2	HB2	-	HB2
#S		HB3	HB3	pro-R	2HB	HB2	HB2	HB1	HB1	-	HB3
#S		HG	HG	-	HG	HOG	HG	HG	HG	-	HG
#S		C	C	-	C	-	C	C	C	C	C
#S		CA	CA	-	CA	-	CA	CA	CA	CA	CA
#S		CB	CB	-	CB	-	CB	CB	CB	CB	CB
#S		N	N	-	N	-	N	N	N	N	N
#S		O	O	-	O	-	O	O	O	O	O
#S		OG	-	-	OG	-	OG	OG	OG	OG	OG
#S 		QB 	- 	- 	- 	QB 	- 	HB*,HB#,HB%,HB+ - -  	QB
#
#T		H	H	-	H	HN	HN	HN	H	-	HN
#T		HA	HA	-	HA	HA	HA	HA	HA	-	HA
#T		HB	HB	-	HB	HB	HB	HB	HB	-	HB
#T		HG1	HG1	-	HG1	HOG1	HG1	HG1	HG1	-	HG1
#T		HG21	-	-	1HG2	HG21	HG21	HG21	HG21	-	HG21
#T		HG22	-	-	2HG2	HG22	HG22	HG22	HG22	-	HG22
#T		HG23	-	-	3HG2	HG23	HG23	HG23	HG23	-	HG23
#T		C	C	-	C	-	C	C	C	C	C
#T		CA	CA	-	CA	-	CA	CA	CA	CA	CA
#T		CB	CB	-	CB	-	CB	CB	CB	CB	CB
#T		CG2	CG2	-	CG2	-	CG2	CG2	CG2	CG2	CG2
#T		N	N	-	N	-	N	N	N	N	N
#T		O	O	-	O	-	O	O	O	O	O
#T		OG1	OG1	-	OG1	-	OG1	OG1	OG1	OG1	OG1
#T 		MG 	HG2 	- 	- 	MG2 	- 	HG2*,HG2#,HG2%,HG2+,HG*,HG# - - QG2
#
#W		H	H	-	H	HN	HN	HN	H	-	HN
#W		HA	HA	-	HA	HA	HA	HA	HA	-	HA
#W		HB2	HB2	pro-R	1HB	HB1	HB1	HB2	HB2	-	HB2
#W		HB3	HB3	pro-S	2HB	HB2	HB2	HB1	HB1	-	HB3
#W		HD1	HD1	-	HD1	HD1	HD1	HD1	HD1	-	HD1
#W		HE1	HE1	-	HE1	HNE1	HE1	HE1	HE1	-	HE1
#W		HE3	HE3	-	HE3	HE3	HE3	HE3	HE3	-	HE3
#W		HZ2	HZ2	-	HZ2	HZ2	HZ2	HZ2	HZ2	-	HZ2
#W		HZ3	HZ3	-	HZ3	HZ3	HZ3	HZ3	HZ3	-	HZ3
#W		HH2	HH2	-	HH2	HH2	HH2	HH2	HH2	-	HH2
#W		C	C	-	C	-	C	C	C	C	C
#W		CA	CA	-	CA	-	CA	CA	CA	CA	CA
#W		CB	CB	-	CB	-	CB	CB	CB	CB	CB
#W		CG	CG	-	CG	-	CG	CG	CG	CG	CG
#W		CD1	CD1	-	CD1	-	CD1	CD1	CD1	CD1	CD1
#W		CD2	CD2	-	CD2	-	CD2	CD2	CD2	CD2	CD2
#W		CE2	CE2	-	CE2	-	CE2	CE2	CE2	CE2	CE2
#W		CE3	CE3	-	CE3	-	CE3	CE3	CE3	CE3	CE3
#W		CZ2	CZ2	-	CZ2	-	CZ2	CZ2	CZ2	CZ2	CZ2
#W		CZ3	CZ3	-	CZ3	-	CZ3	CZ3	CZ3	CZ3	CZ3
#W		CH2	CH2	-	CH2	-	CH2	CH2	CH2	CH2	CH2
#W		N	N	-	N	-	N	N	N	N	N
#W		NE1	NE1	-	NE1	-	NE1	NE1	NE1	NE1	NE1
#W		O	O	-	O	-	O	O	O	O	O
#W 		QB 	- 	- 	- 	QB 	- 	HB*,HB#,HB%,HB+ - -  	QB
#
#Y		H	H	-	H	HN	HN	HN	H	-	HN
#Y		HA	HA	-	HA	HA	HA	HA	HA	-	HA
#Y		HB2	HB2	pro-R	1HB	HB1	HB1	HB2	HB2	-	HB2
#Y		HB3	HB3	pro-S	2HB	HB2	HB2	HB1	HB1	-	HB3
#Y		HD1	HD1	-	HD1	HD1	HD1	HD1	HD1	-	HD1
#Y		HD2	HD2	-	HD2	HD2	HD2	HD2	HD2	-	HD2
#Y		HE1	HE1	-	HE1	HE1	HE1	HE1	HE1	-	HE1
#Y		HE2	HE2	-	HE2	HE2	HE2	HE2	HE2	-	HE2
#Y		HH	HH	-	HH	HOH	HH	HH	HH	-	HH
#Y		C	C	-	C	-	C	C	C	C	C
#Y		CA	CA	-	CA	-	CA	CA	CA	CA	CA
#Y		CB	CB	-	CB	-	CB	CB	CB	CB	CB
#Y		CG	CG	-	CG	-	CG	CG	CG	CG	CG
#Y		CD1	CD1	-	CD1	-	CD1	CD1	CD1	CD1	CD1
#Y		CD2	CD2	-	CD2	-	CD2	CD2	CD2	CD2	CD2
#Y		CE1	CE1	-	CE1	-	CE1	CE1	CE1	CE1	CE1
#Y		CE2	CE2	-	CE2	-	CE2	CE2	CE2	CE2	CE2
#Y		CZ	CZ	-	CZ	-	CZ	CZ	CZ	CZ	CZ
#Y		N	N	-	N	-	N	N	N	N	N
#Y		O	O	-	O	-	O	O	O	O	O
#Y		OH	OH	-	OH	-	OH	OH	OH	OH	OH
#Y 		QB 	- 	- 	- 	QB 	- 	HB*,HB#,HB%,HB+ - -  	QB
#Y 		QD 	- 	- 	- 	RD 	- 	HD*,HD#,HD%,HD+ - -  	QD
#Y 		QE 	- 	- 	- 	RE 	- 	HE*,HE#,HE%,HE+ - -  	QE
#Y 		QR 	- 	- 	- 	- 	- 	- 	- 	-  	QR
#
#V		H	H	-	H	HN	HN	HN	H	-	HN
#V		HA	HA	-	HA	HA	HA	HA	HA	-	HA
#V		HB	HB	-	HB	HB	HB	HB	HB	-	HB
#V		HG11	-	-	1HG1	HG11	HG21	HG11	HG11	-	HG11
#V		HG12	-	-	2HG1	HG12	HG22	HG12	HG12	-	HG12
#V		HG13	-	-	3HG1	HG13	HG23	HG13	HG13	-	HG13
#V		HG21	-	-	1HG2	HG21	HG11	HG21	HG21	-	HG21
#V		HG22	-	-	2HG2	HG22	HG12	HG22	HG22	-	HG22
#V		HG23	-	-	3HG2	HG23	HG13	HG23	HG23	-	HG23
#V		C	C	-	C	-	C	C	C	C	C
#V		CA	CA	-	CA	-	CA	CA	CA	CA	CA
#V		CB	CB	-	CB	-	CB	CB	CB	CB	CB
#V		CG1	CG1	pro-R	CG1	-	CG2	CG1	CG1	CG1	CG1
#V		CG2	CG2	pro-S	CG2	-	CG1	CG2	CG2	CG2	CG2
#V		N	N	-	N	-	N	N	N	N	N
#V		O	O	-	O	-	O	O	O	O	O
#V 		MG1 	HG1 	- 	- 	MG1 	- 	HG1*,HG1#,HG1%,HG1+ - - QG1
#V 		MG2 	HG2 	- 	- 	MG2 	- 	HG2*,HG2#,HG2%,HG2+ - - QG2
#V 		QG 	- 	- 	- 	- 	- 	HG*,HG# 	- -  	QQG
#"""
#rnaTable = """
## BMRB RNA table with IUPAC names
#ATOM      1  C3'   A     1     -15.457   4.380  18.452  1.00  0.00
#ATOM      2  O3'   A     1     -15.030   3.822  17.200  1.00  0.00
#ATOM      3  O5'   A     1     -16.897   7.860  18.894  1.00  0.00
#ATOM      4  C5'   A     1     -16.792   6.455  19.113  1.00  0.00
#ATOM      5  C4'   A     1     -15.658   5.884  18.291  1.00  0.00
#ATOM      6  O4'   A     1     -14.431   6.397  18.760  1.00  0.00
#ATOM      7  C1'   A     1     -13.503   5.424  19.187  1.00  0.00
#ATOM      8  C2'   A     1     -14.399   4.233  19.511  1.00  0.00
#ATOM      9  N9    A     1     -12.719   5.904  20.344  1.00  0.00
#ATOM     10  C8    A     1     -13.019   5.763  21.653  1.00  0.00
#ATOM     11  N7    A     1     -12.107   6.308  22.450  1.00  0.00
#ATOM     12  C5    A     1     -11.179   6.823  21.583  1.00  0.00
#ATOM     13  C6    A     1      -9.976   7.522  21.810  1.00  0.00
#ATOM     14  N6    A     1      -9.487   7.835  23.039  1.00  0.00
#ATOM     15  N1    A     1      -9.260   7.909  20.719  1.00  0.00
#ATOM     16  C2    A     1      -9.739   7.603  19.492  1.00  0.00
#ATOM     17  N3    A     1     -10.866   6.944  19.162  1.00  0.00
#ATOM     18  C4    A     1     -11.533   6.588  20.293  1.00  0.00
#ATOM     19  O2'   A     1     -13.850   2.966  19.226  1.00  0.00
#ATOM     20  H5'   A     1     -17.712   5.944  18.829  1.00  0.00
#ATOM     21 H5''   A     1     -16.599   6.236  20.164  1.00  0.00
#ATOM     22  H4'   A     1     -15.854   6.074  17.235  1.00  0.00
#ATOM     23  H3'   A     1     -16.391   3.888  18.721  1.00  0.00
#ATOM     24  H2'   A     1     -14.870   4.312  20.489  1.00  0.00
#ATOM     25 HO2'   A     1     -13.801   2.464  20.043  1.00  0.00
#ATOM     26  H1'   A     1     -12.827   5.158  18.375  1.00  0.00
#ATOM     27  H8    A     1     -13.917   5.252  21.971  1.00  0.00
#ATOM     28  H61   A     1      -8.615   8.340  23.123  1.00  0.00
#ATOM     29  H62   A     1      -9.994   7.561  23.869  1.00  0.00
#ATOM     30  H2    A     1      -9.079   7.967  18.719  1.00  0.00
#ATOM     31 HO5'   A     1     -16.658   8.077  17.948  1.00  0.00
#ATOM     32  P     G     2     -14.909   4.757  15.906  1.00  0.00
#ATOM     33  C3'   G     2     -13.457   3.463  11.115  1.00  0.00
#ATOM     34  O3'   G     2     -12.358   2.688  10.611  1.00  0.00
#ATOM     35  OP1   G     2     -13.842   5.760  16.116  1.00  0.00
#ATOM     36  OP2   G     2     -16.249   5.254  15.522  1.00  0.00
#ATOM     37  O5'   G     2     -14.415   3.740  14.773  1.00  0.00
#ATOM     38  C5'   G     2     -14.187   4.210  13.446  1.00  0.00
#ATOM     39  C4'   G     2     -13.731   3.069  12.564  1.00  0.00
#ATOM     40  O4'   G     2     -14.776   2.135  12.420  1.00  0.00
#ATOM     41  C1'   G     2     -15.186   1.897  11.092  1.00  0.00
#ATOM     42  C2'   G     2     -14.730   3.165  10.375  1.00  0.00
#ATOM     43  N9    G     2     -16.642   1.667  11.015  1.00  0.00
#ATOM     44  C8    G     2     -17.610   2.590  10.833  1.00  0.00
#ATOM     45  N7    G     2     -18.829   2.059  10.810  1.00  0.00
#ATOM     46  C5    G     2     -18.607   0.720  10.989  1.00  0.00
#ATOM     47  C6    G     2     -19.496  -0.373  11.058  1.00  0.00
#ATOM     48  O6    G     2     -20.721  -0.304  10.961  1.00  0.00
#ATOM     49  N1    G     2     -18.956  -1.609  11.246  1.00  0.00
#ATOM     50  C2    G     2     -17.612  -1.715  11.356  1.00  0.00
#ATOM     51  N2    G     2     -17.240  -2.980  11.537  1.00  0.00
#ATOM     52  N3    G     2     -16.677  -0.749  11.307  1.00  0.00
#ATOM     53  C4    G     2     -17.278   0.458  11.117  1.00  0.00
#ATOM     54  O2'   G     2     -14.283   2.984   9.050  1.00  0.00
#ATOM     55  H5'   G     2     -13.420   4.985  13.432  1.00  0.00
#ATOM     56 H5''   G     2     -15.098   4.632  13.018  1.00  0.00
#ATOM     57  H4'   G     2     -12.803   2.658  12.966  1.00  0.00
#ATOM     58  H3'   G     2     -13.167   4.514  11.044  1.00  0.00
#ATOM     59  H2'   G     2     -15.418   3.996  10.510  1.00  0.00
#ATOM     60 HO2'   G     2     -14.846   3.499   8.465  1.00  0.00
#ATOM     61  H1'   G     2     -14.659   1.037  10.676  1.00  0.00
#ATOM     62  H8    G     2     -17.372   3.638  10.723  1.00  0.00
#ATOM     63  H1    G     2     -19.534  -2.434  11.306  1.00  0.00
#ATOM     64  H21   G     2     -17.937  -3.711  11.575  1.00  0.00
#ATOM     65  H22   G     2     -16.262  -3.211  11.635  1.00  0.00
#ATOM     66  P     C     3     -11.854   2.898   9.107  1.00  0.00
#ATOM     67  C3'   C     3      -8.004   0.496   6.630  1.00  0.00
#ATOM     68  O3'   C     3      -6.648   0.197   7.002  1.00  0.00
#ATOM     69  OP1   C     3     -11.299   4.262   8.953  1.00  0.00
#ATOM     70  OP2   C     3     -12.915   2.483   8.163  1.00  0.00
#ATOM     71  O5'   C     3     -10.647   1.855   8.983  1.00  0.00
#ATOM     72  C5'   C     3      -9.925   1.743   7.760  1.00  0.00
#ATOM     73  C4'   C     3      -8.840   0.697   7.890  1.00  0.00
#ATOM     74  O4'   C     3      -9.427  -0.574   8.059  1.00  0.00
#ATOM     75  C1'   C     3      -9.072  -1.529   7.083  1.00  0.00
#ATOM     76  C2'   C     3      -8.645  -0.655   5.906  1.00  0.00
#ATOM     77  N1    C     3     -10.206  -2.423   6.774  1.00  0.00
#ATOM     78  C6    C     3     -11.100  -2.141   5.795  1.00  0.00
#ATOM     79  C5    C     3     -12.127  -2.959   5.520  1.00  0.00
#ATOM     80  C4    C     3     -12.240  -4.160   6.316  1.00  0.00
#ATOM     81  N4    C     3     -13.245  -4.992   6.071  1.00  0.00
#ATOM     82  N3    C     3     -11.362  -4.419   7.264  1.00  0.00
#ATOM     83  C2    C     3     -10.337  -3.588   7.527  1.00  0.00
#ATOM     84  O2    C     3      -9.506  -3.816   8.413  1.00  0.00
#ATOM     85  O2'   C     3      -7.585  -1.163   5.128  1.00  0.00
#ATOM     86  H5'   C     3      -9.458   2.691   7.492  1.00  0.00
#ATOM     87 H5''   C     3     -10.586   1.452   6.941  1.00  0.00
#ATOM     88  H4'   C     3      -8.157   0.993   8.688  1.00  0.00
#ATOM     89  H3'   C     3      -7.977   1.406   6.028  1.00  0.00
#ATOM     90  H2'   C     3      -9.489  -0.281   5.331  1.00  0.00
#ATOM     91 HO2'   C     3      -7.899  -1.287   4.230  1.00  0.00
#ATOM     92  H1'   C     3      -8.221  -2.123   7.420  1.00  0.00
#ATOM     93  H41   C     3     -13.344  -5.838   6.615  1.00  0.00
#ATOM     94  H42   C     3     -13.910  -4.778   5.342  1.00  0.00
#ATOM     95  H5    C     3     -12.850  -2.754   4.746  1.00  0.00
#ATOM     96  H6    C     3     -10.969  -1.230   5.229  1.00  0.00
#ATOM     97  P     U     4      -5.547  -0.063   5.871  1.00  0.00
#ATOM     98  C3'   U     4      -0.532  -1.179   6.448  1.00  0.00
#ATOM     99  O3'   U     4       0.500  -0.612   7.269  1.00  0.00
#ATOM    100  OP1   U     4      -5.331   1.177   5.091  1.00  0.00
#ATOM    101  OP2   U     4      -5.885  -1.291   5.119  1.00  0.00
#ATOM    102  O5'   U     4      -4.221  -0.350   6.719  1.00  0.00
#ATOM    103  C5'   U     4      -2.994  -0.632   6.051  1.00  0.00
#ATOM    104  C4'   U     4      -1.895  -0.867   7.061  1.00  0.00
#ATOM    105  O4'   U     4      -2.165  -2.044   7.789  1.00  0.00
#ATOM    106  C1'   U     4      -1.164  -3.037   7.712  1.00  0.00
#ATOM    107  C2'   U     4      -0.445  -2.680   6.413  1.00  0.00
#ATOM    108  N1    U     4      -1.755  -4.391   7.706  1.00  0.00
#ATOM    109  C6    U     4      -2.104  -5.027   6.561  1.00  0.00
#ATOM    110  C5    U     4      -2.637  -6.250   6.536  1.00  0.00
#ATOM    111  C4    U     4      -2.846  -6.906   7.777  1.00  0.00
#ATOM    112  O4    U     4      -3.329  -8.032   7.895  1.00  0.00
#ATOM    113  N3    U     4      -2.484  -6.238   8.920  1.00  0.00
#ATOM    114  C2    U     4      -1.934  -4.976   8.923  1.00  0.00
#ATOM    115  O2    U     4      -1.636  -4.442   9.980  1.00  0.00
#ATOM    116  O2'   U     4       0.945  -2.911   6.408  1.00  0.00
#ATOM    117  H5'   U     4      -2.699   0.198   5.408  1.00  0.00
#ATOM    118 H5''   U     4      -3.085  -1.522   5.426  1.00  0.00
#ATOM    119  H4'   U     4      -1.776   0.028   7.672  1.00  0.00
#ATOM    120  H3'   U     4      -0.436  -0.731   5.458  1.00  0.00
#ATOM    121  H2'   U     4      -0.969  -3.041   5.530  1.00  0.00
#ATOM    122 HO2'   U     4       1.146  -3.547   5.717  1.00  0.00
#ATOM    123  H1'   U     4      -0.471  -2.945   8.547  1.00  0.00
#ATOM    124  H3    U     4      -2.641  -6.722   9.791  1.00  0.00
#ATOM    125  H5    U     4      -2.910  -6.742   5.613  1.00  0.00
#ATOM    126  H6    U     4      -1.930  -4.494   5.638  1.00  0.00
#ATOM    127 HO3'   U     4       1.075  -0.002   6.724  1.00  0.00
#""" 
#
#dnaTable = """
#ATOM      1  C3'   A     1     -20.010  -4.370   5.629  1.00  0.00
#ATOM      2  O3'   A     1     -18.728  -4.710   5.077  1.00  0.00
#ATOM      3  O5'   A     1     -21.021  -4.893   9.245  1.00  0.00
#ATOM      4  C5'   A     1     -20.938  -4.201   8.001  1.00  0.00
#ATOM      5  C4'   A     1     -20.158  -5.023   7.000  1.00  0.00
#ATOM      6  O4'   A     1     -20.877  -6.196   6.690  1.00  0.00
#ATOM      7  C1'   A     1     -21.191  -6.360   5.325  1.00  0.00
#ATOM      8  C2'   A     1     -21.134  -4.928   4.799  1.00  0.00
#ATOM      9  N9    A     1     -22.513  -6.997   5.154  1.00  0.00
#ATOM     10  C8    A     1     -23.711  -6.385   5.051  1.00  0.00
#ATOM     11  N7    A     1     -24.715  -7.244   4.906  1.00  0.00
#ATOM     12  C5    A     1     -24.104  -8.469   4.919  1.00  0.00
#ATOM     13  C6    A     1     -24.626  -9.775   4.806  1.00  0.00
#ATOM     14  N6    A     1     -25.943 -10.066   4.651  1.00  0.00
#ATOM     15  N1    A     1     -23.742 -10.809   4.857  1.00  0.00
#ATOM     16  C2    A     1     -22.429 -10.528   5.011  1.00  0.00
#ATOM     17  N3    A     1     -21.825  -9.331   5.128  1.00  0.00
#ATOM     18  C4    A     1     -22.760  -8.342   5.070  1.00  0.00
#ATOM     19  H5'   A     1     -20.438  -3.238   8.122  1.00  0.00
#ATOM     20 H5''   A     1     -21.932  -4.012   7.592  1.00  0.00
#ATOM     21  H4'   A     1     -19.153  -5.194   7.386  1.00  0.00
#ATOM     22  H3'   A     1     -20.047  -3.282   5.706  1.00  0.00
#ATOM     23  H2'   A     1     -22.040  -4.364   5.011  1.00  0.00
#ATOM     24 H2''   A     1     -20.872  -4.837   3.748  1.00  0.00
#ATOM     25  H1'   A     1     -20.430  -6.959   4.826  1.00  0.00
#ATOM     26  H8    A     1     -23.797  -5.309   5.089  1.00  0.00
#ATOM     27  H61   A     1     -26.242 -11.029   4.577  1.00  0.00
#ATOM     28  H62   A     1     -26.624  -9.321   4.609  1.00  0.00
#ATOM     29  H2    A     1     -21.841 -11.434   5.035  1.00  0.00
#ATOM     30 HO5'   A     1     -20.182  -5.415   9.402  1.00  0.00
#ATOM     31  P     G     2     -18.305  -4.156   3.637  1.00  0.00
#ATOM     32  C3'   G     2     -13.903  -4.950   1.043  1.00  0.00
#ATOM     33  O3'   G     2     -12.523  -4.884   1.432  1.00  0.00
#ATOM     34  OP1   G     2     -18.181  -2.682   3.686  1.00  0.00
#ATOM     35  OP2   G     2     -19.190  -4.733   2.601  1.00  0.00
#ATOM     36  O5'   G     2     -16.840  -4.769   3.433  1.00  0.00
#ATOM     37  C5'   G     2     -16.113  -4.495   2.237  1.00  0.00
#ATOM     38  C4'   G     2     -14.766  -5.180   2.280  1.00  0.00
#ATOM     39  O4'   G     2     -14.947  -6.578   2.256  1.00  0.00
#ATOM     40  C1'   G     2     -14.319  -7.242   1.182  1.00  0.00
#ATOM     41  C2'   G     2     -14.169  -6.129   0.148  1.00  0.00
#ATOM     42  N9    G     2     -15.133  -8.380   0.708  1.00  0.00
#ATOM     43  C8    G     2     -16.086  -8.365  -0.247  1.00  0.00
#ATOM     44  N7    G     2     -16.637  -9.560  -0.441  1.00  0.00
#ATOM     45  C5    G     2     -15.985 -10.370   0.450  1.00  0.00
#ATOM     46  C6    G     2     -16.117 -11.747   0.729  1.00  0.00
#ATOM     47  O6    G     2     -16.901 -12.515   0.175  1.00  0.00
#ATOM     48  N1    G     2     -15.309 -12.270   1.691  1.00  0.00
#ATOM     49  C2    G     2     -14.436 -11.449   2.317  1.00  0.00
#ATOM     50  N2    G     2     -13.721 -12.107   3.227  1.00  0.00
#ATOM     51  N3    G     2     -14.228 -10.132   2.133  1.00  0.00
#ATOM     52  C4    G     2     -15.064  -9.672   1.162  1.00  0.00
#ATOM     53  H5'   G     2     -15.951  -3.422   2.116  1.00  0.00
#ATOM     54 H5''   G     2     -16.654  -4.852   1.360  1.00  0.00
#ATOM     55  H4'   G     2     -14.205  -4.808   3.138  1.00  0.00
#ATOM     56  H3'   G     2     -14.148  -4.000   0.566  1.00  0.00
#ATOM     57  H2'   G     2     -15.085  -5.946  -0.411  1.00  0.00
#ATOM     58 H2''   G     2     -13.329  -6.249  -0.534  1.00  0.00
#ATOM     59  H1'   G     2     -13.331  -7.597   1.476  1.00  0.00
#ATOM     60  H8    G     2     -16.340  -7.456  -0.772  1.00  0.00
#ATOM     61  H1    G     2     -15.350 -13.249   1.941  1.00  0.00
#ATOM     62  H21   G     2     -13.872 -13.096   3.370  1.00  0.00
#ATOM     63  H22   G     2     -13.027 -11.619   3.773  1.00  0.00
#ATOM     64  P     C     3     -11.389  -4.648   0.327  1.00  0.00
#ATOM     65  C3'   C     3      -6.272  -4.302   0.977  1.00  0.00
#ATOM     66  O3'   C     3      -5.460  -3.571   1.910  1.00  0.00
#ATOM     67  OP1   C     3     -11.551  -3.306  -0.275  1.00  0.00
#ATOM     68  OP2   C     3     -11.341  -5.807  -0.592  1.00  0.00
#ATOM     69  O5'   C     3     -10.041  -4.645   1.190  1.00  0.00
#ATOM     70  C5'   C     3      -8.783  -4.458   0.544  1.00  0.00
#ATOM     71  C4'   C     3      -7.667  -4.493   1.564  1.00  0.00
#ATOM     72  O4'   C     3      -7.576  -5.786   2.119  1.00  0.00
#ATOM     73  C1'   C     3      -6.326  -6.416   1.959  1.00  0.00
#ATOM     74  C2'   C     3      -5.742  -5.690   0.751  1.00  0.00
#ATOM     75  N1    C     3      -6.484  -7.872   1.751  1.00  0.00
#ATOM     76  C6    C     3      -6.622  -8.413   0.517  1.00  0.00
#ATOM     77  C5    C     3      -6.766  -9.734   0.339  1.00  0.00
#ATOM     78  C4    C     3      -6.767 -10.560   1.523  1.00  0.00
#ATOM     79  N4    C     3      -6.907 -11.872   1.383  1.00  0.00
#ATOM     80  N3    C     3      -6.631 -10.017   2.717  1.00  0.00
#ATOM     81  C2    C     3      -6.488  -8.690   2.880  1.00  0.00
#ATOM     82  O2    C     3      -6.361  -8.166   3.992  1.00  0.00
#ATOM     83  H5'   C     3      -8.748  -3.497   0.028  1.00  0.00
#ATOM     84 H5''   C     3      -8.602  -5.240  -0.193  1.00  0.00
#ATOM     85  H4'   C     3      -7.824  -3.695   2.290  1.00  0.00
#ATOM     86  H3'   C     3      -6.311  -3.714   0.058  1.00  0.00
#ATOM     87  H2'   C     3      -6.129  -6.064  -0.194  1.00  0.00
#ATOM     88 H2''   C     3      -4.654  -5.650   0.724  1.00  0.00
#ATOM     89  H1'   C     3      -5.692  -6.240   2.829  1.00  0.00
#ATOM     90  H41   C     3      -6.910 -12.469   2.198  1.00  0.00
#ATOM     91  H42   C     3      -7.009 -12.274   0.462  1.00  0.00
#ATOM     92  H5    C     3      -6.876 -10.187  -0.636  1.00  0.00
#ATOM     93  H6    C     3      -6.614  -7.750  -0.336  1.00  0.00
#ATOM     94  P     T     4      -3.940  -3.227   1.549  1.00  0.00
#ATOM     95  C3'   T     4      -0.455  -0.662   4.380  1.00  0.00
#ATOM     96  O3'   T     4      -0.520   0.570   5.115  1.00  0.00
#ATOM     97  OP1   T     4      -3.898  -2.302   0.395  1.00  0.00
#ATOM     98  OP2   T     4      -3.155  -4.478   1.451  1.00  0.00
#ATOM     99  O5'   T     4      -3.436  -2.428   2.841  1.00  0.00
#ATOM    100  C5'   T     4      -2.097  -1.941   2.901  1.00  0.00
#ATOM    101  C4'   T     4      -1.863  -1.225   4.211  1.00  0.00
#ATOM    102  O4'   T     4      -1.938  -2.149   5.275  1.00  0.00
#ATOM    103  C1'   T     4      -0.779  -2.234   6.073  1.00  0.00
#ATOM    104  C2'   T     4       0.307  -1.716   5.134  1.00  0.00
#ATOM    105  N1    T     4      -0.549  -3.620   6.533  1.00  0.00
#ATOM    106  C6    T     4       0.193  -4.507   5.823  1.00  0.00
#ATOM    107  C5    T     4       0.411  -5.763   6.222  1.00  0.00
#ATOM    108  C4    T     4      -0.167  -6.176   7.451  1.00  0.00
#ATOM    109  O4    T     4      -0.043  -7.301   7.931  1.00  0.00
#ATOM    110  N3    T     4      -0.911  -5.257   8.146  1.00  0.00
#ATOM    111  C2    T     4      -1.124  -3.966   7.716  1.00  0.00
#ATOM    112  O2    T     4      -1.800  -3.204   8.389  1.00  0.00
#ATOM    113  C7    T     4       1.241  -6.732   5.414  1.00  0.00
#ATOM    114  H5'   T     4      -1.897  -1.244   2.087  1.00  0.00
#ATOM    115 H5''   T     4      -1.379  -2.760   2.823  1.00  0.00
#ATOM    116  H4'   T     4      -2.556  -0.386   4.287  1.00  0.00
#ATOM    117  H3'   T     4      -0.006  -0.434   3.411  1.00  0.00
#ATOM    118  H2'   T     4       0.652  -2.471   4.430  1.00  0.00
#ATOM    119 H2''   T     4       1.155  -1.249   5.630  1.00  0.00
#ATOM    120  H1'   T     4      -0.857  -1.573   6.935  1.00  0.00
#ATOM    121  H3    T     4      -1.313  -5.571   9.018  1.00  0.00
#ATOM    122  H71   T     4       0.636  -7.596   5.139  1.00  0.00
#ATOM    123  H72   T     4       1.600  -6.244   4.508  1.00  0.00
#ATOM    124  H73   T     4       2.094  -7.067   6.003  1.00  0.00
#ATOM    125  H6    T     4       0.614  -4.155   4.894  1.00  0.00
#ATOM    126 HO3'   T     4      -0.092   1.305   4.589  1.00  0.00
#"""
#
#names = {}
#for r in AwkLikeS( proteinTable ):
#    if ((not r.isComment()) and r.NF == 11 ):
#        resname = resNameTranslations[ r.dollar[1] ][1]
#        #print '>>', resname, r.dollar[1], r.dollar[11]
#        fullName = resname + '.' + r.dollar[11]
#        names[fullName] = dict( BMRB = r.dollar[2],
#                                IUPAC = r.dollar[3],
#                                PDB = r.dollar[5],
#                                XPLOR = r.dollar[8],
#                                CYANA = r.dollar[11],
#                                INTERNAL = r.dollar[11]
#                               )
#
#rnaRes = dict( U = 'URA', A ='RADE', C = 'RCYT', G = 'RGUA' )
#for r in AwkLikeS( rnaTable ):
#    if ((not r.isComment()) and r.NF == 10 ):
#        resname = rnaRes[ r.dollar[4]]
#        #print '>>', resname, r.dollar[1], r.dollar[11]
#        fullName = resname + '.' + r.dollar[3]
#        names[fullName] = dict( BMRB = r.dollar[3],
#                                IUPAC = '-',
#                                PDB = '-',
#                                XPLOR = '-',
#                                CYANA = '-',
#                                INTERNAL = '-'
#                               )
#
#dnaRes = dict( T = 'THY', A ='ADE', C = 'CYT', G = 'GUA' )
#for r in AwkLikeS( dnaTable ):
#    if ((not r.isComment()) and r.NF == 10 ):
#        resname = dnaRes[ r.dollar[4]]
#        #print '>>', resname, r.dollar[1], r.dollar[11]
#        fullName = resname + '.' + r.dollar[3]
#        names[fullName] = dict( BMRB = r.dollar[3],
#                                IUPAC = '-',
#                                PDB = '-',
#                                XPLOR = '-',
#                                CYANA = '-',
#                                INTERNAL = '-'
#                               )
#   
##-----------------------------------------------------------------------
## parse the cyanaLib file for atom info and generate output table
##-----------------------------------------------------------------------
#for r in AwkLikeS( cyanaLib ):
#    if ((not r.isComment()) and r.NF == 7 and r.dollar[1] == 'RESIDUE'):
#            resname = r.dollar[2]
#            shortName = r.dollar[3]
#            ndihed = r.int(4)
#            natom = r.int(5)
#            astart = r.int(6)
#            astop = r.int(7)
#            # skip data from the dihedrals lines
#            for i in range(0, ndihed):
#                r.next()
#
#            nTmessage('\n#-----------------------------------------------------------------------')
#            nTmessage('#\t%-8s %-8s %-8s %-8s %-8s %-8s %-8s',
#                   'internal', 'short', BMRB, IUPAC, PDB, CYANA, XPLOR
#                  )
#            nTmessage('RESIDUE\t%-8s %-8s %-8s %-8s %-8s %-8s %-8s',
#                    resname, shortName, resname, resname, resname, resname, resname
#                  )
#            nTmessage('\n#-----------------------------------------------------------------------')
#            nTmessage('#\t%-8s          %-8s %-8s %-8s %-8s %-8s',
#                   'internal', BMRB, IUPAC, PDB, CYANA, XPLOR
#                  )
#           # parse data from the atom lines
#            for i in range(0, natom):
#                r.next()
#                idx = r.int(1)
#                if (idx >= astart and idx <= astop):
#                    fullName = resname + '.' + r.dollar[2]
#                    nameDefs = names.setdefault( fullName, 
#                                                 dict( BMRB  = '-',
#                                                       IUPAC = '-',
#                                                       PDB   = '-',
#                                                       XPLOR = '-',
#                                                       CYANA = r.dollar[2],
#                                                       INTERNAL = r.dollar[2]
#                                                     ) 
#                                                )
#                    nameDefs[CYANA] = r.dollar[2]
#                    nameDefs[INTERNAL] = r.dollar[2]
#                                       
#                    nTmessage( '\t%-8s          ', nameDefs['INTERNAL'] )
#                    for n in [BMRB, IUPAC, PDB, CYANA, XPLOR]:
#                        nTmessage( '%-8s ', nameDefs[n] )
#                    nTmessage('')
#            nTmessage( 'END_RESIDUE')
#
##-----------------------------------------------------------------------
## main
##-----------------------------------------------------------------------
#
#if __name__ == '__main__':
#
#
#
#    pass
