"""
#######################################################################

CCPN Data Model version 2.1.2

Autogenerated by PyFileApiGen revision 1.57.2.1 on Mon Mar  2 17:26:54 2015
  from data model element ccp.nmr.NmrCalc revision ?

#######################################################################
======================COPYRIGHT/LICENSE START==========================

NmrCalc.py: python API for CCPN data model, MetaPackage ccp.nmr.NmrCalc

Copyright (C) 2007 Rasmus Fogh (CCPN Project)

=======================================================================

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
A copy of this license can be found in ../../../../license/LGPL.license
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
Lesser General Public License for more details.
 
You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA


======================COPYRIGHT/LICENSE END============================

for further information, please contact :

- CCPN website (http://www.ccpn.ac.uk/)

- email: ccpn@bioc.cam.ac.uk

=======================================================================

If you are using this software for academic purposes, we suggest
quoting the following references:

===========================REFERENCE START=============================
Wim F. Vranken, Wayne Boucher, Tim J. Stevens, Rasmus
H. Fogh, Anne Pajon, Miguel Llinas, Eldon L. Ulrich, John L. Markley, John
Ionides and Ernest D. Laue (2005). The CCPN Data Model for NMR Spectroscopy:
Development of a Software Pipeline. Proteins 59, 687 - 696.

Rasmus H. Fogh, Wayne Boucher, Wim F. Vranken, Anne
Pajon, Tim J. Stevens, T.N. Bhat, John Westbrook, John M.C. Ionides and
Ernest D. Laue (2005). A framework for scientific data modeling and automated
software development. Bioinformatics 21, 1678-1684.


This file was generated with the Memops software generation framework,
and contains original contributions embedded in the framework

===========================REFERENCE END===============================
"""

import cStringIO
#import sets
import traceback
import types
import operator

# special function for fast whitespace checking.
# used in DataType Word and Token handcode
import re
containsWhitespace = re.compile('\s').search
containsNonAlphanumeric = re.compile('[^a-zA-Z0-9_]').search
 
from memops.general import Implementation as implementation
ApiError = implementation.ApiError

# imported packages:
import ccp.api.general.Affiliation
import ccp.api.general.DataLocation
import ccp.api.general.Method
import ccp.api.general.Template
import ccp.api.molecule.MolStructure
import ccp.api.molecule.MolSystem
import ccp.api.molecule.Validation
import ccp.api.nmr.Nmr
import ccp.api.nmr.NmrConstraint
import memops.api.AccessControl
import memops.api.Implementation
import molsim.api.AnnealProtocol
import molsim.api.Symmetry

metaPackage = memops.api.Implementation.topPackage.metaObjFromQualName('ccp.nmr.NmrCalc')

###############################################################################
class Data(memops.api.Implementation.DataObject):
  r"""Data used or produced by NMR calculation run.
Lists of Int and Float 
values are entered as MatrixData. Lists of other parameters are entered 
as separate Data (or RunParameter) objects with the same name, code, and 
parameterGroup (data) link (but different serials).
  """
  #   from data model element ccp.nmr.NmrCalc.Data revision ?
  _metaclass = metaPackage.getElement('Data')
  _packageName = 'ccp.nmr.NmrCalc'
  _packageShortName = 'CALC'
  _fieldNames = ('applicationData', 'className', 'code', 'details', 'fieldNames', 'inConstructor', 'ioRole', 'isDeleted', 'metaclass', 'name', 'packageName', 'packageShortName', 'qualifiedName', 'serial', 'access', 'activeAccess', 'parameterGroup', 'parent', 'root', 'run', 'runParameters', 'topObject',)

  __init__ = memops.api.Implementation.ComplexDataType.__init__

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData
  
  def addRunParameter(self, value):
    """
    Add for ccp.nmr.NmrCalc.Data.runParameters
    """
    dataDict = self.__dict__
    if (not isinstance(value, RunParameter)):
      raise ApiError("""%s.addRunParameter:
       value is not of class ccp.nmr.NmrCalc.RunParameter""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('runParameters')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.addRunParameter:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.addRunParameter:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.addRunParameter:
       called with deleted value""" % self.qualifiedName
      )

    if (value in currentValues):
      raise ApiError("""%s.addRunParameter:
       value is in list already""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.addRunParameter:
           Link runParameters between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    oldSelf = value.__dict__.get('data')
    if (oldSelf is not None):
      siblingValues = oldSelf.__dict__.get('runParameters')
      siblingValues.remove(value)

    value.__dict__['data'] = self
    currentValues.add(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('addRunParameter')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  checkAllValid = memops.api.Implementation.ComplexDataType.checkAllValid

  checkValid = memops.api.Implementation.ComplexDataType.checkValid

  delete = memops.api.Implementation.DataObject.delete

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData
  
  def findAllRunParameters(self, **conditions):
    """
    FindAll for ccp.nmr.NmrCalc.Data.runParameters
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('runParameters')
      result = set(currentValues)

    else:
      currentValues = dataDict.get('runParameters')
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('booleanValue', 'code', 'floatValue', 'intValue', 'ioRole', 'name', 'serial', 'textValue', 'access', 'data', 'run',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData
  
  def findFirstRunParameter(self, **conditions):
    """
    FindFirst for ccp.nmr.NmrCalc.Data.runParameters
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('runParameters')
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      currentValues = dataDict.get('runParameters')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('booleanValue', 'code', 'floatValue', 'intValue', 'ioRole', 'name', 'serial', 'textValue', 'access', 'data', 'run',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccp.nmr.NmrCalc.Data
    """

    result = None
    if (startObj.__class__.__name__ == 'MemopsRoot'):
      if (4 != len(fullKey)):
        raise ApiError("""'ccp.nmr.NmrCalc.Data'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj0 = startObj
      ll = list()
      objKey = fullKey[0]
      ll.append(objKey)
      if (objKey is not None):
        objKey = fullKey[1]
        ll.append(objKey)
        if (objKey is not None):
          objKey = tuple(ll)

      obj1 = obj0.__dict__.get('nmrCalcStores').get(objKey)
      if (obj1 is None):
        obj0.refreshTopObjects('ccp.nmr.NmrCalc')
        obj1 = obj0.__dict__.get('nmrCalcStores').get(objKey)

    else:
      if (2 != len(fullKey)):
        raise ApiError("""'ccp.nmr.NmrCalc.Data'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj1 = startObj

    if (obj1 is not None):
      if (not (obj1.__dict__.get('isLoaded'))):
        obj1.load()

      objKey = fullKey[-2]
      obj2 = obj1.__dict__.get('runs').get(objKey)

      if (obj2 is not None):
        objKey = fullKey[-1]
        obj3 = obj2.__dict__.get('data').get(objKey)
        result = obj3

    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation

  getClassName = memops.api.Implementation.ComplexDataType.getClassName
  
  def getCode(self):
    """
    Get for ccp.nmr.NmrCalc.Data.code
    """
    dataDict = self.__dict__
    result = dataDict.get('code')
    return result
  
  def getDetails(self):
    """
    Get for ccp.nmr.NmrCalc.Data.details
    """
    dataDict = self.__dict__
    result = dataDict.get('details')
    return result

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames
  
  def getFullKey(self, useGuid=False):
    """
    GetFullKey for ccp.nmr.NmrCalc.Data
    """
    dataDict = self.__dict__
    result = list()

    obj2 = dataDict.get('run')
    obj1 = obj2.__dict__.get('nmrCalcStore')

    if (useGuid):
      result.append(obj1.__dict__.get('guid'))
    else:
      result.append(obj1.__dict__.get('nmrProjectName'))
      result.append(obj1.__dict__.get('name'))

    result.append(obj2.__dict__.get('serial'))
    result.append(dataDict.get('serial'))

    return result

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor
  
  def getIoRole(self):
    """
    Get for ccp.nmr.NmrCalc.Data.ioRole
    """
    dataDict = self.__dict__
    result = dataDict.get('ioRole')
    return result

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted
  
  def getLocalKey(self):
    """
    GetLocalKey for ccp.nmr.NmrCalc.Data
    """
    dataDict = self.__dict__
    result = dataDict.get('serial')
    return result

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass
  
  def getName(self):
    """
    Get for ccp.nmr.NmrCalc.Data.name
    """
    dataDict = self.__dict__
    result = dataDict.get('name')
    return result

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName
  
  def getParameterGroup(self):
    """
    Get for ccp.nmr.NmrCalc.Data.parameterGroup
    """
    dataDict = self.__dict__
    result = dataDict.get('parameterGroup')
    return result
  
  def getParent(self):
    """
    Get for ccp.nmr.NmrCalc.Data.parent
    """
    dataDict = self.__dict__
    result = dataDict.get('run')
    return result

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName

  getRoot = memops.api.Implementation.MemopsObject.getRoot
  
  def getRun(self):
    """
    Get for ccp.nmr.NmrCalc.Data.run
    """
    dataDict = self.__dict__
    result = dataDict.get('run')
    return result
  
  def getRunParameters(self):
    """
    Get for ccp.nmr.NmrCalc.Data.runParameters
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('runParameters')
    result = frozenset(tempVar)
    return result
  
  def getSerial(self):
    """
    Get for ccp.nmr.NmrCalc.Data.serial
    """
    dataDict = self.__dict__
    result = dataDict.get('serial')
    return result

  getTopObject = memops.api.Implementation.DataObject.getTopObject

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData
  
  def removeRunParameter(self, value):
    """
    Remove for ccp.nmr.NmrCalc.Data.runParameters
    """
    dataDict = self.__dict__
    if (not isinstance(value, RunParameter)):
      raise ApiError("""%s.removeRunParameter:
       value is not of class ccp.nmr.NmrCalc.RunParameter""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('runParameters')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.removeRunParameter:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.removeRunParameter:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.removeRunParameter:
       called with deleted value""" % self.qualifiedName
      )

    if (not (value in currentValues)):
      raise ApiError("""%s.removeRunParameter:
       value not in list""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      pass

    value.__dict__['data'] = None
    currentValues.remove(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('removeRunParameter')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  setAccess = memops.api.Implementation.DataObject.setAccess

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData
  
  def setCode(self, value):
    """
    Set for ccp.nmr.NmrCalc.Data.code
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setCode:
         memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 32):
        raise ApiError("""%s.setCode:
         memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setCode:
         memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.setCode:
         Word constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('code')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setCode:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setCode:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['code'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setCode')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setDetails(self, value):
    """
    Set for ccp.nmr.NmrCalc.Data.details
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setDetails:
         memops.Implementation.Text input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 254):
        raise ApiError("""%s.setDetails:
         memops.Implementation.Text maximum length is 254 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setDetails:
         memops.Implementation.Text: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('details')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setDetails:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setDetails:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['details'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setDetails')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setIoRole(self, value):
    """
    Set for ccp.nmr.NmrCalc.Data.ioRole
    """
    dataDict = self.__dict__
    if (not (value in ['input', 'output'])):
      raise ApiError("""%s.setIoRole:
       ccp.nmr.NmrCalc.IoRole input is not in enumeration ['input', 'output']""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.split()) == 1)):
      raise ApiError("""%s.setIoRole:
       IoRole constraint contains_no_white_space violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('ioRole')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setIoRole:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setIoRole:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setIoRole:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['ioRole'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setIoRole')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setName(self, value):
    """
    Set for ccp.nmr.NmrCalc.Data.name
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.setName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.setName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('name')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setName:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setName:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['name'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setName')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setParameterGroup(self, value):
    """
    Set for ccp.nmr.NmrCalc.Data.parameterGroup
    """
    dataDict = self.__dict__
    if (value is not None):
      if (not isinstance(value, ParameterGroup)):
        raise ApiError("""%s.setParameterGroup:
         value is not of class ccp.nmr.NmrCalc.ParameterGroup""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('parameterGroup')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setParameterGroup:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setParameterGroup:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setParameterGroup:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setParameterGroup:
           Link parameterGroup between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      if (notInConstructor):
        if (value is not None):
          isValid = True
          obj = self
          while obj is not None:
            obj = obj.parameterGroup
            if obj is self:
              isValid = False
              break
          if (not (isValid)):
            raise ApiError("""%s.setParameterGroup:
             parameterGroup constraint No_cyclical_parameter_grouping violated by value""" % self.qualifiedName
             + ": %s" % (value,)
            )

    if (currentValue is not None):
      if (notIsReading):
        oldSelves = currentValue.__dict__.get('data')
        oldSelves.remove(self)
      else:
        raise ApiError("""%s.setParameterGroup:
         Read link 'parameterGroup' incompatible with pre-existing link""" % self.qualifiedName
         + ": %s" % (self,)
        )

    if (value is not None):
      newSelves = value.__dict__.get('data')
      newSelves.add(self)

    dataDict['parameterGroup'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setParameterGroup')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setRunParameters(self, values):
    """
    Set for ccp.nmr.NmrCalc.Data.runParameters
    """
    dataDict = self.__dict__
    xx = values
    values = set(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setRunParameters:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      if (not isinstance(value, RunParameter)):
        raise ApiError("""%s.setRunParameters:
         value is not of class ccp.nmr.NmrCalc.RunParameter""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('runParameters')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setRunParameters:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setRunParameters:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setRunParameters:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      xx1 = dataDict.get('topObject')
      for value in values:
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setRunParameters:
           Link runParameters between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    for cv in currentValues:
      if (not (cv in values)):
        cv.__dict__['data'] = None

    for cv in values:
      if (not (cv in currentValues)):
        oldSelf = cv.__dict__.get('data')
        if (oldSelf is not None):
          vv = oldSelf.__dict__.get('runParameters')
          vv.remove(cv)

      cv.__dict__['data'] = self

    dataDict['runParameters'] = values
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setRunParameters')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setSerial(self, value):
    """
    Set for ccp.nmr.NmrCalc.Data.serial
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Int.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Int.create(value)
    else:
      raise ApiError("""%s.setSerial:
       memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('serial')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setSerial:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setSerial:
         cannot set serial, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setSerial:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    parent = dataDict.get('run')
    oldSerial = parent.__dict__.get('_serialDict').get('data')
    if (value < 0):
      value = (oldSerial + 1)
      parent.__dict__.get('_serialDict')['data'] = value
    elif (value > oldSerial):
      parent.__dict__.get('_serialDict')['data'] = value

    dataDict['serial'] = value

    # doNotifies
  
  def sortedRunParameters(self):
    """
    Sorted for ccp.nmr.NmrCalc.Data.runParameters
    """
    dataDict = self.__dict__
    ll = dataDict.get('runParameters')
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  applicationData = memops.api.Implementation.DataObject.applicationData

  className = memops.api.Implementation.ComplexDataType.className
  
  code = property(getCode, setCode, None,
  r"""Unique identifier for the parameter within the context of the 
  application being run 
  """)
  
  details = property(getDetails, setDetails, None,
  r"""Free text, for notes, explanatory comments, etc.
  """)

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor
  
  ioRole = property(getIoRole, setIoRole, None,
  r"""Role of data in calculation (input / output).
  """)

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted

  metaclass = memops.api.Implementation.ComplexDataType.metaclass
  
  name = property(getName, setName, None,
  r"""Human readable name of parameter
  """)

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName
  
  serial = property(getSerial, setSerial, None,
  r"""Serial number of object. Serves as object main key. Serial numbers of 
  deleted objects are not re-used. Serial numbers can only be set by the 
  implementation. Values are in practice always positive, since negative 
  values are interpreted as a signal to set the next free serial
  """)

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess
  
  parameterGroup = property(getParameterGroup, setParameterGroup, None,
  r"""Parameter group that Data belong to
  """)
  
  parent = property(getParent, None, None,
  r"""link to parent object - synonym for run
  """)

  root = memops.api.Implementation.MemopsObject.root
  
  run = property(getRun,  None, None,
  r"""parent link
  """)
  
  runParameters = property(getRunParameters, setRunParameters, None,
  r"""parameters that refer to unit of data.
  """)

  topObject = memops.api.Implementation.DataObject.topObject

###############################################################################
class EnergyTermParameter(memops.api.Implementation.DataObject):
  r"""Parameter to further characterise energy term. E.g. correlation time for 
a restraint derived from relaxation measurements.
  """
  #   from data model element ccp.nmr.NmrCalc.EnergyTermParameter revision ?
  _metaclass = metaPackage.getElement('EnergyTermParameter')
  _packageName = 'ccp.nmr.NmrCalc'
  _packageShortName = 'CALC'
  _fieldNames = ('applicationData', 'className', 'code', 'fieldNames', 'inConstructor', 'isDeleted', 'metaclass', 'packageName', 'packageShortName', 'qualifiedName', 'value', 'access', 'activeAccess', 'energyTerm', 'parent', 'root', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for ccp.nmr.NmrCalc.EnergyTermParameter
    """
    dataDict = self.__dict__
    dataDict['energyTerm'] = parent
    if (not isinstance(parent, EnergyTerm)):
      raise ApiError("""%s.__init__:
       value is not of class ccp.nmr.NmrCalc.EnergyTerm""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = parent.__dict__.get('topObject')
    dataDict['topObject'] = topObject

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    if (notIsReading):
      if (not (topObject.__dict__.get('isModifiable'))):
        raise ApiError("""%s.__init__:
         Storage not modifiable""" % self.qualifiedName
         + ": %s" % (topObject,)
        )

    try:

      dataDict['applicationData'] = list()
      dataDict['code'] = None
      dataDict['value'] = None
      dataDict['access'] = None

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in ccp.nmr.NmrCalc.EnergyTermParameter.__init__"
        del dataDict['inConstructor']
        raise

      if (notIsReading):
        childrenDict = parent.__dict__.get('energyTermParameters')
        objKey = dataDict.get('code')
        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['code'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notOverride):
        self.checkValid()

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for ccp.nmr.NmrCalc.EnergyTermParameter:
       determines 
    cascading deletes to follow from delete of object.
       *Implementation 
    function* - should be called only by API delete function.
    """
    dataDict = self.__dict__
    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for ccp.nmr.NmrCalc.EnergyTermParameter:   deletes
    objects
    *Implementation function* - will CORRUPT DATA if called outside 
    the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    energyTerm = dataDict.get('energyTerm')
    if (not (energyTerm in objsToBeDeleted)):
      objKey = dataDict.get('code')
      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = energyTerm.__dict__.get('energyTermParameters')
        if (self is dd.get(objKey)):
          del dd[objKey]

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData
  
  def checkAllValid(self, complete=False):
    """
    CheckAllValid for ccp.nmr.NmrCalc.EnergyTermParameter
    """
    dataDict = self.__dict__
    self.checkValid(complete)
  
  def checkValid(self, complete=False):
    """
    CheckValid for ccp.nmr.NmrCalc.EnergyTermParameter
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      objKey = dataDict.get('code')
      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('energyTerm')
        dd = value.__dict__.get('energyTermParameters')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'energyTerm' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      # check attributes
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('code')
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: code:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: code:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: code:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: code:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('value')
      if (isinstance(value, memops.api.Implementation.Float.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Float.create(value)
      else:
        raise ApiError("""%s.checkValid: value:
         memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value - value == 0.0)):
        raise ApiError("""%s.checkValid: value:
         Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('energyTerm')
      if (not isinstance(value, EnergyTerm)):
        raise ApiError("""%s.checkValid: energyTerm:
         value is not of class ccp.nmr.NmrCalc.EnergyTerm""" % self.qualifiedName
         + ": %s" % (value,)
        )

    # check explicit class constraints
    # check attributes
    values = dataDict.get('applicationData')
    for value in values:
      value.checkAllValid(complete)

    value = dataDict.get('code')
    if (value is None):
      raise ApiError("""%s.checkValid: code:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('value')
    if (value is None):
      raise ApiError("""%s.checkValid: value:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    # check roles
    value = dataDict.get('access')
    value = dataDict.get('energyTerm')
    if (value is None):
      raise ApiError("""%s.checkValid: energyTerm:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

  delete = memops.api.Implementation.DataObject.delete

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData
  
  def get(self, name):
    """
    GetAttr for ccp.nmr.NmrCalc.EnergyTermParameter
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccp.nmr.NmrCalc.EnergyTermParameter
    """

    result = None
    if (startObj.__class__.__name__ == 'MemopsRoot'):
      if (5 != len(fullKey)):
        raise ApiError("""'ccp.nmr.NmrCalc.EnergyTermParameter'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj0 = startObj
      ll = list()
      objKey = fullKey[0]
      ll.append(objKey)
      if (objKey is not None):
        objKey = fullKey[1]
        ll.append(objKey)
        if (objKey is not None):
          objKey = tuple(ll)

      obj1 = obj0.__dict__.get('nmrCalcStores').get(objKey)
      if (obj1 is None):
        obj0.refreshTopObjects('ccp.nmr.NmrCalc')
        obj1 = obj0.__dict__.get('nmrCalcStores').get(objKey)

    else:
      if (3 != len(fullKey)):
        raise ApiError("""'ccp.nmr.NmrCalc.EnergyTermParameter'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj1 = startObj

    if (obj1 is not None):
      if (not (obj1.__dict__.get('isLoaded'))):
        obj1.load()

      objKey = fullKey[-3]
      obj2 = obj1.__dict__.get('runs').get(objKey)

      if (obj2 is not None):
        objKey = fullKey[-2]
        obj3 = obj2.__dict__.get('data').get(objKey)

        if (obj3 is not None):
          objKey = fullKey[-1]
          obj4 = obj3.__dict__.get('energyTermParameters').get(objKey)
          result = obj4

    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation

  getClassName = memops.api.Implementation.ComplexDataType.getClassName
  
  def getCode(self):
    """
    Get for ccp.nmr.NmrCalc.EnergyTermParameter.code
    """
    dataDict = self.__dict__
    result = dataDict.get('code')
    return result
  
  def getEnergyTerm(self):
    """
    Get for ccp.nmr.NmrCalc.EnergyTermParameter.energyTerm
    """
    dataDict = self.__dict__
    result = dataDict.get('energyTerm')
    return result

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames
  
  def getFullKey(self, useGuid=False):
    """
    GetFullKey for ccp.nmr.NmrCalc.EnergyTermParameter
    """
    dataDict = self.__dict__
    result = list()

    obj3 = dataDict.get('energyTerm')
    obj2 = obj3.__dict__.get('run')
    obj1 = obj2.__dict__.get('nmrCalcStore')

    if (useGuid):
      result.append(obj1.__dict__.get('guid'))
    else:
      result.append(obj1.__dict__.get('nmrProjectName'))
      result.append(obj1.__dict__.get('name'))

    result.append(obj2.__dict__.get('serial'))
    result.append(obj3.__dict__.get('serial'))
    result.append(dataDict.get('code'))

    return result

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted
  
  def getLocalKey(self):
    """
    GetLocalKey for ccp.nmr.NmrCalc.EnergyTermParameter
    """
    dataDict = self.__dict__
    result = dataDict.get('code')
    return result

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName
  
  def getParent(self):
    """
    Get for ccp.nmr.NmrCalc.EnergyTermParameter.parent
    """
    dataDict = self.__dict__
    result = dataDict.get('energyTerm')
    return result

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName

  getRoot = memops.api.Implementation.MemopsObject.getRoot

  getTopObject = memops.api.Implementation.DataObject.getTopObject
  
  def getValue(self):
    """
    Get for ccp.nmr.NmrCalc.EnergyTermParameter.value
    """
    dataDict = self.__dict__
    result = dataDict.get('value')
    return result

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData
  
  def set(self, name, value):
    """
    SetAttr for ccp.nmr.NmrCalc.EnergyTermParameter
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData
  
  def setCode(self, value):
    """
    Set for ccp.nmr.NmrCalc.EnergyTermParameter.code
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.setCode:
       memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 80):
      raise ApiError("""%s.setCode:
       memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.setCode:
       memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.splitlines()) <= 1)):
      raise ApiError("""%s.setCode:
       Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('code')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setCode:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setCode:
         cannot set code, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setCode:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['code'] = value

    # doNotifies
  
  def setValue(self, value):
    """
    Set for ccp.nmr.NmrCalc.EnergyTermParameter.value
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Float.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Float.create(value)
    else:
      raise ApiError("""%s.setValue:
       memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value - value == 0.0)):
      raise ApiError("""%s.setValue:
       Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('value')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setValue:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setValue:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setValue:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['value'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setValue')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  applicationData = memops.api.Implementation.DataObject.applicationData

  className = memops.api.Implementation.ComplexDataType.className
  
  code = property(getCode, setCode, None,
  r"""Code for energy term parameter, as used in its definition.
  """)

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted

  metaclass = memops.api.Implementation.ComplexDataType.metaclass

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName
  
  value = property(getValue, setValue, None,
  r"""Value of energy term parameter
  """)

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess
  
  energyTerm = property(getEnergyTerm,  None, None,
  r"""parent link
  """)
  
  parent = property(getParent, None, None,
  r"""link to parent object - synonym for energyTerm
  """)

  root = memops.api.Implementation.MemopsObject.root

  topObject = memops.api.Implementation.DataObject.topObject

###############################################################################
class NmrCalcStore(memops.api.Implementation.TopObject):
  r"""TopObject for NmrCalc package
  """
  #   from data model element ccp.nmr.NmrCalc.NmrCalcStore revision ?
  _metaclass = metaPackage.getElement('NmrCalcStore')
  _packageName = 'ccp.nmr.NmrCalc'
  _packageShortName = 'CALC'
  _fieldNames = ('applicationData', 'className', 'createdBy', 'fieldNames', 'guid', 'inConstructor', 'isDeleted', 'isLoaded', 'isModifiable', 'isModified', 'isReading', 'lastUnlockedBy', 'metaclass', 'name', 'nmrProjectName', 'packageName', 'packageShortName', 'qualifiedName', 'validationStoreName', 'access', 'activeAccess', 'activeRepositories', 'memopsRoot', 'nmrProject', 'packageLocator', 'parent', 'root', 'runs', 'topObject', 'validationStore',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for ccp.nmr.NmrCalc.NmrCalcStore
    """
    dataDict = self.__dict__
    dataDict['memopsRoot'] = parent
    from memops.api.Implementation import MemopsRoot as importedType
    if (not isinstance(parent, importedType)):
      raise ApiError("""%s.__init__:
       value is not of class memops.Implementation.MemopsRoot""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = self
    dataDict['topObject'] = topObject
    if (attrlinks.get('isReading', False)):
      del attrlinks['isReading']
      dataDict['isLoaded'] = False
      dataDict['isModified'] = False
      dataDict['isReading'] = True
    elif (parent.__dict__.get('isReading')):
      dataDict['isLoaded'] = False
      dataDict['isModified'] = False
      dataDict['isReading'] = True
    else:
      dataDict['isLoaded'] = True
      dataDict['isModified'] = True
      dataDict['isReading'] = False

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    try:
      if (not (dataDict.get('isReading'))):
        parent.refreshTopObjects('ccp.nmr.NmrCalc')

      dataDict['applicationData'] = list()
      dataDict['createdBy'] = None
      dataDict['guid'] = None
      dataDict['isModifiable'] = True
      dataDict['lastUnlockedBy'] = None
      dataDict['name'] = None
      dataDict['nmrProjectName'] = None
      dataDict['validationStoreName'] = None
      dataDict['access'] = None
      dataDict['runs'] = {}
      dataDict['activeRepositories'] = list()

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in ccp.nmr.NmrCalc.NmrCalcStore.__init__"
        del dataDict['inConstructor']
        raise

      serialDict = {}
      serialDict['runs'] = 0
      dataDict['_serialDict'] = serialDict

      if (notIsReading):
        childrenDict = parent.__dict__.get('nmrCalcStores')
        ll = list()
        objKey = dataDict.get('nmrProjectName')
        ll.append(objKey)
        if (objKey is not None):
          objKey = dataDict.get('name')
          ll.append(objKey)
          if (objKey is not None):
            objKey = tuple(ll)

        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['nmrProjectName', 'name'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notIsReading):
        guid = dataDict.get('guid')
        if (guid is None):
          guid = root.newGuid()
          dataDict['guid'] = guid

        dd = root.__dict__.get('topObjects')
        if (dd.get(guid) is None):
          dd[guid] = self
        else:
          raise ApiError("""%s.__init__:
           Creating TopObject with preexisting guid""" % self.qualifiedName
           + ": %s" % (self,)
          )

        dataDict['createdBy'] = root.__dict__.get('currentUserId')

      if (notOverride):
        self.checkValid()

      if ((notIsReading or root.__dict__.get('currentNmrCalcStore') is None)):
        root.__dict__['currentNmrCalcStore'] = self

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for ccp.nmr.NmrCalc.NmrCalcStore:
       determines cascading 
    deletes to follow from delete of object.
       *Implementation function* - 
    should be called only by API delete function.
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    memopsRoot = dataDict.get('memopsRoot')
    if (memopsRoot is not None):
      topObject = memopsRoot.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    runs = dataDict.get('runs').values()
    for run in runs:
      if (not (run in objsToBeDeleted)):
        objsToBeDeleted.add(run)
        objsToBeChecked.append(run)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for ccp.nmr.NmrCalc.NmrCalcStore:   deletes
    objects
    *Implementation function* - will CORRUPT DATA if called outside 
    the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    memopsRoot = dataDict.get('memopsRoot')
    if (self is memopsRoot.__dict__.get('currentNmrCalcStore')):
      memopsRoot.__dict__['currentNmrCalcStore'] = None

    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    memopsRoot = dataDict.get('memopsRoot')
    if (not (memopsRoot in objsToBeDeleted)):
      ll = list()
      objKey = dataDict.get('nmrProjectName')
      ll.append(objKey)
      if (objKey is not None):
        objKey = dataDict.get('name')
        ll.append(objKey)
        if (objKey is not None):
          objKey = tuple(ll)

      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = memopsRoot.__dict__.get('nmrCalcStores')
        if (self is dd.get(objKey)):
          del dd[objKey]

    dataDict['runs'] = {}

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData

  backup = memops.api.Implementation.TopObject.backup
  
  def checkAllValid(self, complete=False):
    """
    CheckAllValid for ccp.nmr.NmrCalc.NmrCalcStore
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    self.checkValid(complete)
    values = dataDict.get('runs').values()
    for value in values:
      value.checkAllValid(complete)

  def checkValid(self, complete=False):
    """
    CheckValid for ccp.nmr.NmrCalc.NmrCalcStore
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      ll = list()
      objKey = dataDict.get('nmrProjectName')
      ll.append(objKey)
      if (objKey is not None):
        objKey = dataDict.get('name')
        ll.append(objKey)
        if (objKey is not None):
          objKey = tuple(ll)

      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('memopsRoot')
        dd = value.__dict__.get('nmrCalcStores')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'memopsRoot' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      # check attributes
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('createdBy')
      if (value is None):
        raise ApiError("""%s.checkValid: createdBy:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: createdBy:
         memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 32):
        raise ApiError("""%s.checkValid: createdBy:
         memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: createdBy:
         memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.checkValid: createdBy:
         Word constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('guid')
      if (value is None):
        raise ApiError("""%s.checkValid: guid:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: guid:
         memops.Implementation.GuidString input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: guid:
         memops.Implementation.GuidString maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: guid:
         memops.Implementation.GuidString: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: guid:
         GuidString constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      isValid = frozenset('abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_0123456789-').issuperset(value)
      if (not (isValid)):
        raise ApiError("""%s.checkValid: guid:
         GuidString constraint value_is_url_safe violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('isModifiable')
      if (not (value in [True, False])):
        raise ApiError("""%s.checkValid: isModifiable:
         memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('lastUnlockedBy')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: lastUnlockedBy:
           memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 32):
          raise ApiError("""%s.checkValid: lastUnlockedBy:
           memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: lastUnlockedBy:
           memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.split()) == 1)):
          raise ApiError("""%s.checkValid: lastUnlockedBy:
           Word constraint contains_no_white_space violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('name')
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: name:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: name:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: name:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: name:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('nmrProjectName')
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: nmrProjectName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: nmrProjectName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: nmrProjectName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: nmrProjectName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('validationStoreName')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: validationStoreName:
           memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: validationStoreName:
           memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: validationStoreName:
           memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: validationStoreName:
           Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('memopsRoot')
      from memops.api.Implementation import MemopsRoot as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.checkValid: memopsRoot:
         value is not of class memops.Implementation.MemopsRoot""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = self.getNmrProject()
      if (value is None):
        raise ApiError("""%s.checkValid: nmrProject:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      from ccp.api.nmr.Nmr import NmrProject as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.checkValid: nmrProject:
         value is not of class ccp.nmr.Nmr.NmrProject""" % self.qualifiedName
         + ": %s" % (value,)
        )

      oldSelves = value.getNmrCalcStores()
      if (not (self in oldSelves)):
        raise ApiError("""%s.checkValid: nmrProject:
         non-reciprocal link nmrProject from object""" % self.qualifiedName
         + ": %s" % (self,)
        )

      value = self.getPackageLocator()
      if (value is None):
        raise ApiError("""%s.checkValid: packageLocator:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      from memops.api.Implementation import PackageLocator as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.checkValid: packageLocator:
         value is not of class memops.Implementation.PackageLocator""" % self.qualifiedName
         + ": %s" % (value,)
        )

      xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
      yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
      if (not (xx1 is yy1)):
        raise ApiError("""%s.checkValid: packageLocator:
         Link packageLocator between objects from separate partitions
         - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
         + ": %s:%s" % (self, value)
        )

      values = dataDict.get('runs').values()
      for value in values:
        if (not isinstance(value, Run)):
          raise ApiError("""%s.checkValid: runs:
           value is not of class ccp.nmr.NmrCalc.Run""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('nmrCalcStore')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: runs:
           non-reciprocal link runs from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      value = self.getValidationStore()
      if (value is not None):
        from ccp.api.molecule.Validation import ValidationStore as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: validationStore:
           value is not of class ccp.molecule.Validation.ValidationStore""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.getNmrCalcStores()
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: validationStore:
           non-reciprocal link validationStore from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

    if (dataDict.get('isLoaded')):
      # check explicit class constraints
      # check attributes
      values = dataDict.get('applicationData')
      for value in values:
        value.checkAllValid(complete)

      value = dataDict.get('isModifiable')
      if (value is None):
        raise ApiError("""%s.checkValid: isModifiable:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      value = dataDict.get('name')
      if (value is None):
        raise ApiError("""%s.checkValid: name:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      value = dataDict.get('nmrProjectName')
      if (value is None):
        raise ApiError("""%s.checkValid: nmrProjectName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      value = dataDict.get('validationStoreName')
      # check roles
      value = dataDict.get('access')
      value = dataDict.get('memopsRoot')
      if (value is None):
        raise ApiError("""%s.checkValid: memopsRoot:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      values = dataDict.get('runs').values()
    else:
      # check unloaded TopObject
      value = dataDict.get('guid')
      if (value is None):
        raise ApiError("""%s.checkValid: guid:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      value = dataDict.get('nmrProjectName')
      if (value is None):
        raise ApiError("""%s.checkValid: nmrProjectName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      value = dataDict.get('name')
      if (value is None):
        raise ApiError("""%s.checkValid: name:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

  delete = memops.api.Implementation.DataObject.delete

  findAllActiveRepositories = memops.api.Implementation.TopObject.findAllActiveRepositories

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData
  
  def findAllRuns(self, **conditions):
    """
    FindAll for ccp.nmr.NmrCalc.NmrCalcStore.runs
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('runs').values()
      result = set(currentValues)

    else:
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('runs').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('affiliationStoreName', 'annealProtocolApp', 'annealProtocolCode', 'annealProtocolStoreName', 'details', 'methodStoreName', 'operatorSerial', 'serial', 'softwareName', 'softwareVersion', 'status', 'structureGenerationSerial', 'wmsProtocolName', 'access', 'masterRun', 'nmrCalcStore', 'operator',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result

  findFirstActiveRepository = memops.api.Implementation.TopObject.findFirstActiveRepository

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData
  
  def findFirstRun(self, **conditions):
    """
    FindFirst for ccp.nmr.NmrCalc.NmrCalcStore.runs
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('runs').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      objKey = conditions.get('serial')
      if (objKey is not None):
        if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
          self.load()

        result = dataDict.get('runs').get(objKey)

        if (nConditions <= 1):
          return result

        elif (result is None):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
          self.load()

        currentValues = dataDict.get('runs').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('affiliationStoreName', 'annealProtocolApp', 'annealProtocolCode', 'annealProtocolStoreName', 'details', 'methodStoreName', 'operatorSerial', 'serial', 'softwareName', 'softwareVersion', 'status', 'structureGenerationSerial', 'wmsProtocolName', 'access', 'masterRun', 'nmrCalcStore', 'operator',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def get(self, name):
    """
    GetAttr for ccp.nmr.NmrCalc.NmrCalcStore
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess

  getActiveRepositories = memops.api.Implementation.TopObject.getActiveRepositories

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccp.nmr.NmrCalc.NmrCalcStore
    """

    result = None
    if (2 != len(fullKey)):
      raise ApiError("""'ccp.nmr.NmrCalc.NmrCalcStore'.getByKey:
       getByKey called with fullKey of wrong length. Parameters:"""
       + ": %s:%s" % (startObj, fullKey)
      )

    ll = list()
    objKey = fullKey[0]
    ll.append(objKey)
    if (objKey is not None):
      objKey = fullKey[1]
      ll.append(objKey)
      if (objKey is not None):
        objKey = tuple(ll)

    obj1 = startObj.__dict__.get('nmrCalcStores').get(objKey)
    if (obj1 is None):
      startObj.refreshTopObjects('ccp.nmr.NmrCalc')
      obj1 = startObj.__dict__.get('nmrCalcStores').get(objKey)

    result = obj1
    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation

  getClassName = memops.api.Implementation.ComplexDataType.getClassName

  getCreatedBy = memops.api.Implementation.TopObject.getCreatedBy

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames
  
  def getFullKey(self, useGuid=False):
    """
    GetFullKey for ccp.nmr.NmrCalc.NmrCalcStore
    """
    dataDict = self.__dict__
    result = list()

    if (useGuid):
      result.append(dataDict.get('guid'))
    else:
      result.append(dataDict.get('nmrProjectName'))
      result.append(dataDict.get('name'))

    return result

  getGuid = memops.api.Implementation.TopObject.getGuid

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted

  getIsLoaded = memops.api.Implementation.TopObject.getIsLoaded

  getIsModifiable = memops.api.Implementation.TopObject.getIsModifiable

  getIsModified = memops.api.Implementation.TopObject.getIsModified

  getIsReading = memops.api.Implementation.TopObject.getIsReading

  getLastUnlockedBy = memops.api.Implementation.TopObject.getLastUnlockedBy
  
  def getLocalKey(self):
    """
    GetLocalKey for ccp.nmr.NmrCalc.NmrCalcStore
    """
    dataDict = self.__dict__
    ll = list()
    result = dataDict.get('nmrProjectName')
    ll.append(result)
    if (result is not None):
      result = dataDict.get('name')
      ll.append(result)
      if (result is not None):
        result = tuple(ll)

    return result
  
  def getMemopsRoot(self):
    """
    Get for ccp.nmr.NmrCalc.NmrCalcStore.memopsRoot
    """
    dataDict = self.__dict__
    result = dataDict.get('memopsRoot')
    return result

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass
  
  def getName(self):
    """
    Get for ccp.nmr.NmrCalc.NmrCalcStore.name
    """
    dataDict = self.__dict__
    result = dataDict.get('name')
    return result
  
  def getNmrProject(self):
    """
    getter for derived link nmrProject
    """
    dataDict = self.__dict__
    result = self.memopsRoot.findFirstNmrProject(name=self.nmrProjectName)
    return result
  
  def getNmrProjectName(self):
    """
    Get for ccp.nmr.NmrCalc.NmrCalcStore.nmrProjectName
    """
    dataDict = self.__dict__
    result = dataDict.get('nmrProjectName')
    return result

  getPackageLocator = memops.api.Implementation.TopObject.getPackageLocator

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName
  
  def getParent(self):
    """
    Get for ccp.nmr.NmrCalc.NmrCalcStore.parent
    """
    dataDict = self.__dict__
    result = dataDict.get('memopsRoot')
    return result

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName

  getRoot = memops.api.Implementation.MemopsObject.getRoot
  
  def getRuns(self):
    """
    Get for ccp.nmr.NmrCalc.NmrCalcStore.runs
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    tempVar = dataDict.get('runs').values()
    result = frozenset(tempVar)
    return result

  getTopObject = memops.api.Implementation.DataObject.getTopObject
  
  def getValidationStore(self):
    """
    getter for derived link validationStore
    """
    dataDict = self.__dict__
    result = self.memopsRoot.findFirstValidationStore(name=self.validationStoreName)
    return result
  
  def getValidationStoreName(self):
    """
    Get for ccp.nmr.NmrCalc.NmrCalcStore.validationStoreName
    """
    dataDict = self.__dict__
    result = dataDict.get('validationStoreName')
    return result

  load = memops.api.Implementation.TopObject.load

  loadFrom = memops.api.Implementation.TopObject.loadFrom
  
  def newRun(self, **attrlinks):
    """
    Factory function to create ccp.nmr.NmrCalc.Run
    """
    return Run(self, **attrlinks)

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData

  removeFrom = memops.api.Implementation.TopObject.removeFrom

  restore = memops.api.Implementation.TopObject.restore

  save = memops.api.Implementation.TopObject.save

  saveTo = memops.api.Implementation.TopObject.saveTo
  
  def set(self, name, value):
    """
    SetAttr for ccp.nmr.NmrCalc.NmrCalcStore
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData

  setCreatedBy = memops.api.Implementation.TopObject.setCreatedBy

  setGuid = memops.api.Implementation.TopObject.setGuid

  setIsModifiable = memops.api.Implementation.TopObject.setIsModifiable

  setLastUnlockedBy = memops.api.Implementation.TopObject.setLastUnlockedBy
  
  def setName(self, value):
    """
    Set for ccp.nmr.NmrCalc.NmrCalcStore.name
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.setName:
       memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 80):
      raise ApiError("""%s.setName:
       memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.setName:
       memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.splitlines()) <= 1)):
      raise ApiError("""%s.setName:
       Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValue = dataDict.get('name')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setName:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setName:
         cannot set name, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['name'] = value

    # doNotifies
  
  def setNmrProject(self, value):
    """
    setter for derived link nmrProject
    """
    dataDict = self.__dict__
    from ccp.api.nmr.Nmr import NmrProject as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.setNmrProject:
       value is not of class ccp.nmr.Nmr.NmrProject""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValue = self.getNmrProject()
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      if (value is not None):
        topObject = value.__dict__.get('topObject')
        topObjectsToCheck.add(topObject)

      if (currentValue is not None):
        topObject = currentValue.__dict__.get('topObject')
        topObjectsToCheck.add(topObject)

      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setNmrProject:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setNmrProject:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setNmrProject:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    self.nmrProjectName = value.name
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        if (not (topObjectModify.__dict__.get('isLoaded'))):
          topObjectModify.load()

        topObjectModify.__dict__['isModified'] = True

  def setNmrProjectName(self, value):
    """
    Set for ccp.nmr.NmrCalc.NmrCalcStore.nmrProjectName
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.setNmrProjectName:
       memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 80):
      raise ApiError("""%s.setNmrProjectName:
       memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.setNmrProjectName:
       memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.splitlines()) <= 1)):
      raise ApiError("""%s.setNmrProjectName:
       Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValue = dataDict.get('nmrProjectName')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setNmrProjectName:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setNmrProjectName:
         cannot set nmrProjectName, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setNmrProjectName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['nmrProjectName'] = value

    # doNotifies
  
  def setValidationStore(self, value):
    """
    setter for derived link validationStore
    """
    dataDict = self.__dict__
    if (value is not None):
      from ccp.api.molecule.Validation import ValidationStore as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setValidationStore:
         value is not of class ccp.molecule.Validation.ValidationStore""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValue = self.getValidationStore()
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      if (value is not None):
        topObject = value.__dict__.get('topObject')
        topObjectsToCheck.add(topObject)

      if (currentValue is not None):
        topObject = currentValue.__dict__.get('topObject')
        topObjectsToCheck.add(topObject)

      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setValidationStore:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setValidationStore:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setValidationStore:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    self.validationStoreName = value.name
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        if (not (topObjectModify.__dict__.get('isLoaded'))):
          topObjectModify.load()

        topObjectModify.__dict__['isModified'] = True

  def setValidationStoreName(self, value):
    """
    Set for ccp.nmr.NmrCalc.NmrCalcStore.validationStoreName
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setValidationStoreName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.setValidationStoreName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setValidationStoreName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.setValidationStoreName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValue = dataDict.get('validationStoreName')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setValidationStoreName:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setValidationStoreName:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['validationStoreName'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setValidationStoreName')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def sortedRuns(self):
    """
    Sorted for ccp.nmr.NmrCalc.NmrCalcStore.runs
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    sortdd = dataDict.get('runs')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  touch = memops.api.Implementation.TopObject.touch

  applicationData = memops.api.Implementation.DataObject.applicationData

  className = memops.api.Implementation.ComplexDataType.className

  createdBy = memops.api.Implementation.TopObject.createdBy

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames

  guid = memops.api.Implementation.TopObject.guid

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted

  isLoaded = memops.api.Implementation.TopObject.isLoaded

  isModifiable = memops.api.Implementation.TopObject.isModifiable

  isModified = memops.api.Implementation.TopObject.isModified

  isReading = memops.api.Implementation.TopObject.isReading

  lastUnlockedBy = memops.api.Implementation.TopObject.lastUnlockedBy

  metaclass = memops.api.Implementation.ComplexDataType.metaclass
  
  name = property(getName, setName, None,
  r"""name (part of key) for NmrCalcStore
  """)
  
  nmrProjectName = property(getNmrProjectName, setNmrProjectName, None,
  r"""Name of associated NMR project. Part of object key, and key for derived 
  link to NmrProject
  """)

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName
  
  validationStoreName = property(getValidationStoreName, setValidationStoreName, None,
  r"""Name of associated ValidationStore. Key for derived link validationStore
  """)

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess

  activeRepositories = memops.api.Implementation.TopObject.activeRepositories
  
  memopsRoot = property(getMemopsRoot,  None, None,
  r"""parent link
  """)
  
  nmrProject = property(getNmrProject, setNmrProject, None,
  r"""NMR project that calculation refers to. Part of key
  """)

  packageLocator = memops.api.Implementation.TopObject.packageLocator
  
  parent = property(getParent, None, None,
  r"""link to parent object - synonym for memopsRoot
  """)

  root = memops.api.Implementation.MemopsObject.root
  
  runs = property(getRuns,  None, None,
  r"""child link to class Run
  """)

  topObject = memops.api.Implementation.DataObject.topObject
  
  validationStore = property(getValidationStore, setValidationStore, None,
  r"""Validation store that stores calculation result
  """)

###############################################################################
class Run(memops.api.Implementation.DataObject):
  r"""Calculation run, collecting input and output.
  """
  #   from data model element ccp.nmr.NmrCalc.Run revision ?
  _metaclass = metaPackage.getElement('Run')
  _packageName = 'ccp.nmr.NmrCalc'
  _packageShortName = 'CALC'
  _fieldNames = ('affiliationStoreName', 'annealProtocolApp', 'annealProtocolCode', 'annealProtocolStoreName', 'applicationData', 'className', 'details', 'fieldNames', 'inConstructor', 'isDeleted', 'metaclass', 'methodStoreName', 'operatorSerial', 'packageName', 'packageShortName', 'qualifiedName', 'serial', 'softwareName', 'softwareVersion', 'status', 'structureGenerationSerial', 'wmsProtocolName', 'access', 'activeAccess', 'annealProtocol', 'data', 'derivedRuns', 'inputs', 'masterRun', 'nmrCalcStore', 'operator', 'outputs', 'parent', 'root', 'runParameters', 'software', 'structureGeneration', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for ccp.nmr.NmrCalc.Run
    """
    dataDict = self.__dict__
    dataDict['nmrCalcStore'] = parent
    if (not isinstance(parent, NmrCalcStore)):
      raise ApiError("""%s.__init__:
       value is not of class ccp.nmr.NmrCalc.NmrCalcStore""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = parent.__dict__.get('topObject')
    dataDict['topObject'] = topObject

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    if (notIsReading):
      if (not (topObject.__dict__.get('isModifiable'))):
        raise ApiError("""%s.__init__:
         Storage not modifiable""" % self.qualifiedName
         + ": %s" % (topObject,)
        )

    try:
      if (not ((parent.__dict__.get('isLoaded') or parent.__dict__.get('isReading')))):
        parent.load()

      dataDict['affiliationStoreName'] = None
      dataDict['annealProtocolApp'] = None
      dataDict['annealProtocolCode'] = None
      dataDict['annealProtocolStoreName'] = None
      dataDict['applicationData'] = list()
      dataDict['details'] = None
      dataDict['methodStoreName'] = None
      dataDict['operatorSerial'] = None
      dataDict['serial'] = None
      dataDict['softwareName'] = None
      dataDict['softwareVersion'] = None
      dataDict['status'] = 'provisional'
      dataDict['structureGenerationSerial'] = None
      dataDict['wmsProtocolName'] = None
      dataDict['access'] = None
      dataDict['data'] = {}
      dataDict['derivedRuns'] = set()
      dataDict['masterRun'] = None
      dataDict['operator'] = None
      dataDict['runParameters'] = {}

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in ccp.nmr.NmrCalc.Run.__init__"
        del dataDict['inConstructor']
        raise

      if (notOverride):
        if (dataDict.get('serial') is None):
          dataDict['inConstructor'] = True
          self.setSerial(-1)
          del dataDict['inConstructor']
        else:
          raise ApiError("""%s.__init__:
           Cannot pass in explicit serial if not reading""" % self.qualifiedName
           + ": %s:%s" % (parent, 'ccp.nmr.NmrCalc.Run')
          )

      serialDict = {}
      serialDict['data'] = 0
      serialDict['runParameters'] = 0
      dataDict['_serialDict'] = serialDict

      if (notIsReading):
        childrenDict = parent.__dict__.get('runs')
        objKey = dataDict.get('serial')
        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['serial'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notOverride):
        self.checkValid()

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for ccp.nmr.NmrCalc.Run:
       determines cascading deletes to 
    follow from delete of object.
       *Implementation function* - should be 
    called only by API delete function.
    """
    dataDict = self.__dict__
    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    data_s = dataDict.get('data').values()
    for data in data_s:
      if (not (data in objsToBeDeleted)):
        objsToBeDeleted.add(data)
        objsToBeChecked.append(data)

    runParameters = dataDict.get('runParameters').values()
    for runParameter in runParameters:
      if (not (runParameter in objsToBeDeleted)):
        objsToBeDeleted.add(runParameter)
        objsToBeChecked.append(runParameter)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for ccp.nmr.NmrCalc.Run:   deletes objects
    *Implementation 
    function* - will CORRUPT DATA if called outside the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    for derivedRun in dataDict.get('derivedRuns'):
      if (not (derivedRun in objsToBeDeleted)):
        derivedRun.__dict__['masterRun'] = None

    masterRun = dataDict.get('masterRun')
    if ((masterRun is not None and not (masterRun in objsToBeDeleted))):
      derivedRuns = masterRun.__dict__.get('derivedRuns')
      derivedRuns.remove(self)

    nmrCalcStore = dataDict.get('nmrCalcStore')
    if (not (nmrCalcStore in objsToBeDeleted)):
      objKey = dataDict.get('serial')
      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = nmrCalcStore.__dict__.get('runs')
        if (self is dd.get(objKey)):
          del dd[objKey]

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData
  
  def addDerivedRun(self, value):
    """
    Add for ccp.nmr.NmrCalc.Run.derivedRuns
    """
    dataDict = self.__dict__
    if (not isinstance(value, Run)):
      raise ApiError("""%s.addDerivedRun:
       value is not of class ccp.nmr.NmrCalc.Run""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('derivedRuns')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.addDerivedRun:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.addDerivedRun:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.addDerivedRun:
       called with deleted value""" % self.qualifiedName
      )

    if (value in currentValues):
      raise ApiError("""%s.addDerivedRun:
       value is in list already""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.addDerivedRun:
           Link derivedRuns between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      if (notInConstructor):
        if (value is not None):
          (self, value) = (value, self)
          if (not (value is None or value.masterRun is None)):
            raise ApiError("""%s.addDerivedRun:
             masterRun constraint derived_runs_cannot_be_nested violated by value""" % self.qualifiedName
             + ": %s" % (value,)
            )

          (value, self) = (self, value)

    oldSelf = value.__dict__.get('masterRun')
    if (oldSelf is not None):
      siblingValues = oldSelf.__dict__.get('derivedRuns')
      siblingValues.remove(value)

    value.__dict__['masterRun'] = self
    currentValues.add(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('addDerivedRun')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def checkAllValid(self, complete=False):
    """
    CheckAllValid for ccp.nmr.NmrCalc.Run
    """
    dataDict = self.__dict__
    self.checkValid(complete)
    values = dataDict.get('data').values()
    for value in values:
      value.checkAllValid(complete)

    values = dataDict.get('runParameters').values()
    for value in values:
      value.checkAllValid(complete)

  def checkValid(self, complete=False):
    """
    CheckValid for ccp.nmr.NmrCalc.Run
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      objKey = dataDict.get('serial')
      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('nmrCalcStore')
        dd = value.__dict__.get('runs')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'nmrCalcStore' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      # check attributes
      value = dataDict.get('affiliationStoreName')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: affiliationStoreName:
           memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: affiliationStoreName:
           memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: affiliationStoreName:
           memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: affiliationStoreName:
           Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('annealProtocolApp')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: annealProtocolApp:
           memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: annealProtocolApp:
           memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: annealProtocolApp:
           memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: annealProtocolApp:
           Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('annealProtocolCode')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: annealProtocolCode:
           memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: annealProtocolCode:
           memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: annealProtocolCode:
           memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: annealProtocolCode:
           Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('annealProtocolStoreName')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: annealProtocolStoreName:
           memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: annealProtocolStoreName:
           memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: annealProtocolStoreName:
           memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: annealProtocolStoreName:
           Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('details')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: details:
           memops.Implementation.Text input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 254):
          raise ApiError("""%s.checkValid: details:
           memops.Implementation.Text maximum length is 254 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: details:
           memops.Implementation.Text: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('methodStoreName')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: methodStoreName:
           memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 32):
          raise ApiError("""%s.checkValid: methodStoreName:
           memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: methodStoreName:
           memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.split()) == 1)):
          raise ApiError("""%s.checkValid: methodStoreName:
           Word constraint contains_no_white_space violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('operatorSerial')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.Int.PythonType)):
          pass
        elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
          value = memops.api.Implementation.Int.create(value)
        else:
          raise ApiError("""%s.checkValid: operatorSerial:
           memops.Implementation.PositiveInt input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (value > 0)):
          raise ApiError("""%s.checkValid: operatorSerial:
           PositiveInt constraint int_value_gt_0 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('serial')
      if (value is None):
        raise ApiError("""%s.checkValid: serial:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.checkValid: serial:
         memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('softwareName')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: softwareName:
           memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: softwareName:
           memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: softwareName:
           memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: softwareName:
           Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('softwareVersion')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: softwareVersion:
           memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: softwareVersion:
           memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: softwareVersion:
           memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: softwareVersion:
           Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('status')
      if (not (value in ['provisional', 'pending', 'active', 'completed', 'failed'])):
        raise ApiError("""%s.checkValid: status:
         ccp.nmr.NmrCalc.Status input is not in enumeration ['provisional', 'pending', 'active', 'completed', 'failed']""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.checkValid: status:
         Status constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('structureGenerationSerial')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.Int.PythonType)):
          pass
        elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
          value = memops.api.Implementation.Int.create(value)
        else:
          raise ApiError("""%s.checkValid: structureGenerationSerial:
           memops.Implementation.PositiveInt input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (value > 0)):
          raise ApiError("""%s.checkValid: structureGenerationSerial:
           PositiveInt constraint int_value_gt_0 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('wmsProtocolName')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: wmsProtocolName:
           memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 32):
          raise ApiError("""%s.checkValid: wmsProtocolName:
           memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: wmsProtocolName:
           memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.split()) == 1)):
          raise ApiError("""%s.checkValid: wmsProtocolName:
           Word constraint contains_no_white_space violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getAnnealProtocol()
      if (value is not None):
        from molsim.api.AnnealProtocol import AnnealProtocol as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: annealProtocol:
           value is not of class molsim.AnnealProtocol.AnnealProtocol""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.getNmrCalcRuns()
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: annealProtocol:
           non-reciprocal link annealProtocol from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      values = dataDict.get('data').values()
      for value in values:
        if (not isinstance(value, Data)):
          raise ApiError("""%s.checkValid: data:
           value is not of class ccp.nmr.NmrCalc.Data""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('run')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: data:
           non-reciprocal link data from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      values = dataDict.get('derivedRuns')
      for value in values:
        if (not isinstance(value, Run)):
          raise ApiError("""%s.checkValid: derivedRuns:
           value is not of class ccp.nmr.NmrCalc.Run""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('masterRun')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: derivedRuns:
           non-reciprocal link derivedRuns from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: derivedRuns:
           Link derivedRuns between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      values = self.getInputs()
      for value in values:
        if (not isinstance(value, Data)):
          raise ApiError("""%s.checkValid: inputs:
           value is not of class ccp.nmr.NmrCalc.Data""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: inputs:
           Link inputs between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('masterRun')
      if (value is not None):
        if (not isinstance(value, Run)):
          raise ApiError("""%s.checkValid: masterRun:
           value is not of class ccp.nmr.NmrCalc.Run""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('derivedRuns')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: masterRun:
           non-reciprocal link masterRun from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      value = dataDict.get('nmrCalcStore')
      if (not isinstance(value, NmrCalcStore)):
        raise ApiError("""%s.checkValid: nmrCalcStore:
         value is not of class ccp.nmr.NmrCalc.NmrCalcStore""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('operator')
      if (value is not None):
        from ccp.api.general.Affiliation import Person as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: operator:
           value is not of class ccp.general.Affiliation.Person""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: operator:
           Link operator between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      values = self.getOutputs()
      for value in values:
        if (not isinstance(value, Data)):
          raise ApiError("""%s.checkValid: outputs:
           value is not of class ccp.nmr.NmrCalc.Data""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: outputs:
           Link outputs between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      values = dataDict.get('runParameters').values()
      for value in values:
        if (not isinstance(value, RunParameter)):
          raise ApiError("""%s.checkValid: runParameters:
           value is not of class ccp.nmr.NmrCalc.RunParameter""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('run')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: runParameters:
           non-reciprocal link runParameters from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      value = self.getSoftware()
      if (value is not None):
        from ccp.api.general.Method import Software as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: software:
           value is not of class ccp.general.Method.Software""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: software:
           Link software between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getStructureGeneration()
      if (value is not None):
        from ccp.api.nmr.Nmr import StructureGeneration as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: structureGeneration:
           value is not of class ccp.nmr.Nmr.StructureGeneration""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.getRuns()
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: structureGeneration:
           non-reciprocal link structureGeneration from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

    # check explicit class constraints
    # check attributes
    value = dataDict.get('affiliationStoreName')
    value = dataDict.get('annealProtocolApp')
    value = dataDict.get('annealProtocolCode')
    value = dataDict.get('annealProtocolStoreName')
    values = dataDict.get('applicationData')
    for value in values:
      value.checkAllValid(complete)

    value = dataDict.get('details')
    value = dataDict.get('methodStoreName')
    value = dataDict.get('operatorSerial')
    value = dataDict.get('softwareName')
    value = dataDict.get('softwareVersion')
    value = dataDict.get('status')
    if (value is None):
      raise ApiError("""%s.checkValid: status:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('structureGenerationSerial')
    value = dataDict.get('wmsProtocolName')
    # check roles
    value = dataDict.get('access')
    values = dataDict.get('data').values()
    values = dataDict.get('derivedRuns')
    for value in values:
      (self, value) = (value, self)
      if (not (value is None or value.masterRun is None)):
        raise ApiError("""%s.checkValid: derivedRuns:
         masterRun constraint derived_runs_cannot_be_nested violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      (value, self) = (self, value)

    value = dataDict.get('masterRun')
    if (value is not None):
      if (not (value is None or value.masterRun is None)):
        raise ApiError("""%s.checkValid: masterRun:
         masterRun constraint derived_runs_cannot_be_nested violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    value = dataDict.get('nmrCalcStore')
    if (value is None):
      raise ApiError("""%s.checkValid: nmrCalcStore:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('operator')
    values = dataDict.get('runParameters').values()

  delete = memops.api.Implementation.DataObject.delete

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData
  
  def findAllData(self, **conditions):
    """
    FindAll for ccp.nmr.NmrCalc.Run.data
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('data').values()
      result = set(currentValues)

    else:
      currentValues = dataDict.get('data').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('code', 'details', 'ioRole', 'name', 'serial', 'access', 'parameterGroup', 'run',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllDerivedRuns(self, **conditions):
    """
    FindAll for ccp.nmr.NmrCalc.Run.derivedRuns
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('derivedRuns')
      result = set(currentValues)

    else:
      currentValues = dataDict.get('derivedRuns')
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('affiliationStoreName', 'annealProtocolApp', 'annealProtocolCode', 'annealProtocolStoreName', 'details', 'methodStoreName', 'operatorSerial', 'serial', 'softwareName', 'softwareVersion', 'status', 'structureGenerationSerial', 'wmsProtocolName', 'access', 'masterRun', 'nmrCalcStore', 'operator',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllInputs(self, **conditions):
    """
    FindAll for ccp.nmr.NmrCalc.Run.inputs
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = self.getInputs()
      result = set(currentValues)

    else:
      currentValues = self.getInputs()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('code', 'details', 'ioRole', 'name', 'serial', 'access', 'parameterGroup', 'run',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllOutputs(self, **conditions):
    """
    FindAll for ccp.nmr.NmrCalc.Run.outputs
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = self.getOutputs()
      result = set(currentValues)

    else:
      currentValues = self.getOutputs()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('code', 'details', 'ioRole', 'name', 'serial', 'access', 'parameterGroup', 'run',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllRunParameters(self, **conditions):
    """
    FindAll for ccp.nmr.NmrCalc.Run.runParameters
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('runParameters').values()
      result = set(currentValues)

    else:
      currentValues = dataDict.get('runParameters').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('booleanValue', 'code', 'floatValue', 'intValue', 'ioRole', 'name', 'serial', 'textValue', 'access', 'data', 'run',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData
  
  def findFirstData(self, **conditions):
    """
    FindFirst for ccp.nmr.NmrCalc.Run.data
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('data').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      objKey = conditions.get('serial')
      if (objKey is not None):
        result = dataDict.get('data').get(objKey)

        if (nConditions <= 1):
          return result

        elif (result is None):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        currentValues = dataDict.get('data').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('code', 'details', 'ioRole', 'name', 'serial', 'access', 'parameterGroup', 'run',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstDerivedRun(self, **conditions):
    """
    FindFirst for ccp.nmr.NmrCalc.Run.derivedRuns
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('derivedRuns')
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      currentValues = dataDict.get('derivedRuns')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('affiliationStoreName', 'annealProtocolApp', 'annealProtocolCode', 'annealProtocolStoreName', 'details', 'methodStoreName', 'operatorSerial', 'serial', 'softwareName', 'softwareVersion', 'status', 'structureGenerationSerial', 'wmsProtocolName', 'access', 'masterRun', 'nmrCalcStore', 'operator',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstInput(self, **conditions):
    """
    FindFirst for ccp.nmr.NmrCalc.Run.inputs
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = self.getInputs()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      currentValues = self.getInputs()
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('code', 'details', 'ioRole', 'name', 'serial', 'access', 'parameterGroup', 'run',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstOutput(self, **conditions):
    """
    FindFirst for ccp.nmr.NmrCalc.Run.outputs
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = self.getOutputs()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      currentValues = self.getOutputs()
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('code', 'details', 'ioRole', 'name', 'serial', 'access', 'parameterGroup', 'run',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstRunParameter(self, **conditions):
    """
    FindFirst for ccp.nmr.NmrCalc.Run.runParameters
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('runParameters').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      objKey = conditions.get('serial')
      if (objKey is not None):
        result = dataDict.get('runParameters').get(objKey)

        if (nConditions <= 1):
          return result

        elif (result is None):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        currentValues = dataDict.get('runParameters').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('booleanValue', 'code', 'floatValue', 'intValue', 'ioRole', 'name', 'serial', 'textValue', 'access', 'data', 'run',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def get(self, name):
    """
    GetAttr for ccp.nmr.NmrCalc.Run
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess
  
  def getAffiliationStoreName(self):
    """
    Get for ccp.nmr.NmrCalc.Run.affiliationStoreName
    """
    dataDict = self.__dict__
    result = dataDict.get('affiliationStoreName')
    return result
  
  def getAnnealProtocol(self):
    """
    getter for derived link anealProtocol
    """
    dataDict = self.__dict__
    result = molsim.api.AnnealProtocol.AnnealProtocol.getByKey(self.root, (self.annealProtocolStoreName, self.annealProtocolApp, self.annealProtocolCode))
    return result
  
  def getAnnealProtocolApp(self):
    """
    Get for ccp.nmr.NmrCalc.Run.annealProtocolApp
    """
    dataDict = self.__dict__
    result = dataDict.get('annealProtocolApp')
    return result
  
  def getAnnealProtocolCode(self):
    """
    Get for ccp.nmr.NmrCalc.Run.annealProtocolCode
    """
    dataDict = self.__dict__
    result = dataDict.get('annealProtocolCode')
    return result
  
  def getAnnealProtocolStoreName(self):
    """
    Get for ccp.nmr.NmrCalc.Run.annealProtocolStoreName
    """
    dataDict = self.__dict__
    result = dataDict.get('annealProtocolStoreName')
    return result

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccp.nmr.NmrCalc.Run
    """

    result = None
    if (startObj.__class__.__name__ == 'MemopsRoot'):
      if (3 != len(fullKey)):
        raise ApiError("""'ccp.nmr.NmrCalc.Run'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj0 = startObj
      ll = list()
      objKey = fullKey[0]
      ll.append(objKey)
      if (objKey is not None):
        objKey = fullKey[1]
        ll.append(objKey)
        if (objKey is not None):
          objKey = tuple(ll)

      obj1 = obj0.__dict__.get('nmrCalcStores').get(objKey)
      if (obj1 is None):
        obj0.refreshTopObjects('ccp.nmr.NmrCalc')
        obj1 = obj0.__dict__.get('nmrCalcStores').get(objKey)

    else:
      if (1 != len(fullKey)):
        raise ApiError("""'ccp.nmr.NmrCalc.Run'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj1 = startObj

    if (obj1 is not None):
      if (not (obj1.__dict__.get('isLoaded'))):
        obj1.load()

      objKey = fullKey[-1]
      obj2 = obj1.__dict__.get('runs').get(objKey)
      result = obj2

    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation

  getClassName = memops.api.Implementation.ComplexDataType.getClassName
  
  def getData(self):
    """
    Get for ccp.nmr.NmrCalc.Run.data
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('data').values()
    result = frozenset(tempVar)
    return result
  
  def getDerivedRuns(self):
    """
    Get for ccp.nmr.NmrCalc.Run.derivedRuns
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('derivedRuns')
    result = frozenset(tempVar)
    return result
  
  def getDetails(self):
    """
    Get for ccp.nmr.NmrCalc.Run.details
    """
    dataDict = self.__dict__
    result = dataDict.get('details')
    return result

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames
  
  def getFullKey(self, useGuid=False):
    """
    GetFullKey for ccp.nmr.NmrCalc.Run
    """
    dataDict = self.__dict__
    result = list()

    obj1 = dataDict.get('nmrCalcStore')

    if (useGuid):
      result.append(obj1.__dict__.get('guid'))
    else:
      result.append(obj1.__dict__.get('nmrProjectName'))
      result.append(obj1.__dict__.get('name'))

    result.append(dataDict.get('serial'))

    return result

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor
  
  def getInputs(self):
    """
    getter for derived link inputs
    """
    dataDict = self.__dict__
    result =  frozenset(self.findAllData(ioRole='input'))
    return result

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted
  
  def getLocalKey(self):
    """
    GetLocalKey for ccp.nmr.NmrCalc.Run
    """
    dataDict = self.__dict__
    result = dataDict.get('serial')
    return result
  
  def getMasterRun(self):
    """
    Get for ccp.nmr.NmrCalc.Run.masterRun
    """
    dataDict = self.__dict__
    result = dataDict.get('masterRun')
    return result

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass
  
  def getMethodStoreName(self):
    """
    Get for ccp.nmr.NmrCalc.Run.methodStoreName
    """
    dataDict = self.__dict__
    result = dataDict.get('methodStoreName')
    return result
  
  def getNmrCalcStore(self):
    """
    Get for ccp.nmr.NmrCalc.Run.nmrCalcStore
    """
    dataDict = self.__dict__
    result = dataDict.get('nmrCalcStore')
    return result
  
  def getOperator(self):
    """
    getter for derived link "operator"
    """
    dataDict = self.__dict__
    result = ccp.api.general.Affiliation.Person.getByKey(self.root, (self.affiliationStoreName, self.operatorSerial))
    return result
  
  def getOperatorSerial(self):
    """
    Get for ccp.nmr.NmrCalc.Run.operatorSerial
    """
    dataDict = self.__dict__
    result = dataDict.get('operatorSerial')
    return result
  
  def getOutputs(self):
    """
    getter for derived link outputs
    """
    dataDict = self.__dict__
    result =  frozenset(self.findAllData(ioRole='output'))
    return result

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName
  
  def getParent(self):
    """
    Get for ccp.nmr.NmrCalc.Run.parent
    """
    dataDict = self.__dict__
    result = dataDict.get('nmrCalcStore')
    return result

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName

  getRoot = memops.api.Implementation.MemopsObject.getRoot
  
  def getRunParameters(self):
    """
    Get for ccp.nmr.NmrCalc.Run.runParameters
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('runParameters').values()
    result = frozenset(tempVar)
    return result
  
  def getSerial(self):
    """
    Get for ccp.nmr.NmrCalc.Run.serial
    """
    dataDict = self.__dict__
    result = dataDict.get('serial')
    return result
  
  def getSoftware(self):
    """
    getter for derived link software
    """
    dataDict = self.__dict__
    result = ccp.api.general.Method.Software.getByKey(self.root, (self.methodStoreName, self.softwareName, self.softwareVersion))
    return result
  
  def getSoftwareName(self):
    """
    Get for ccp.nmr.NmrCalc.Run.softwareName
    """
    dataDict = self.__dict__
    result = dataDict.get('softwareName')
    return result
  
  def getSoftwareVersion(self):
    """
    Get for ccp.nmr.NmrCalc.Run.softwareVersion
    """
    dataDict = self.__dict__
    result = dataDict.get('softwareVersion')
    return result
  
  def getStatus(self):
    """
    Get for ccp.nmr.NmrCalc.Run.status
    """
    dataDict = self.__dict__
    result = dataDict.get('status')
    return result
  
  def getStructureGeneration(self):
    """
    getter for derived lnik structureGeneration
    """
    dataDict = self.__dict__
    result = ccp.api.nmr.Nmr.StructureGeneration.getByKey(self.root, (self.nmrCalcStore.nmrProjectName, self.structureGenerationSerial))
    return result
  
  def getStructureGenerationSerial(self):
    """
    Get for ccp.nmr.NmrCalc.Run.structureGenerationSerial
    """
    dataDict = self.__dict__
    result = dataDict.get('structureGenerationSerial')
    return result

  getTopObject = memops.api.Implementation.DataObject.getTopObject
  
  def getWmsProtocolName(self):
    """
    Get for ccp.nmr.NmrCalc.Run.wmsProtocolName
    """
    dataDict = self.__dict__
    result = dataDict.get('wmsProtocolName')
    return result
  
  def newConstraintStoreData(self, **attrlinks):
    """
    Factory function to create ccp.nmr.NmrCalc.ConstraintStoreData
    """
    return ConstraintStoreData(self, **attrlinks)
  
  def newDerivedListData(self, **attrlinks):
    """
    Factory function to create ccp.nmr.NmrCalc.DerivedListData
    """
    return DerivedListData(self, **attrlinks)
  
  def newEnergyTerm(self, **attrlinks):
    """
    Factory function to create ccp.nmr.NmrCalc.EnergyTerm
    """
    return EnergyTerm(self, **attrlinks)
  
  def newExternalData(self, **attrlinks):
    """
    Factory function to create ccp.nmr.NmrCalc.ExternalData
    """
    return ExternalData(self, **attrlinks)
  
  def newFloatMatrixData(self, **attrlinks):
    """
    Factory function to create ccp.nmr.NmrCalc.FloatMatrixData
    """
    return FloatMatrixData(self, **attrlinks)
  
  def newMeasurementListData(self, **attrlinks):
    """
    Factory function to create ccp.nmr.NmrCalc.MeasurementListData
    """
    return MeasurementListData(self, **attrlinks)
  
  def newMolResidueData(self, **attrlinks):
    """
    Factory function to create ccp.nmr.NmrCalc.MolResidueData
    """
    return MolResidueData(self, **attrlinks)
  
  def newMolSystemData(self, **attrlinks):
    """
    Factory function to create ccp.nmr.NmrCalc.MolSystemData
    """
    return MolSystemData(self, **attrlinks)
  
  def newParameterGroup(self, **attrlinks):
    """
    Factory function to create ccp.nmr.NmrCalc.ParameterGroup
    """
    return ParameterGroup(self, **attrlinks)
  
  def newPeakListData(self, **attrlinks):
    """
    Factory function to create ccp.nmr.NmrCalc.PeakListData
    """
    return PeakListData(self, **attrlinks)
  
  def newRunParameter(self, **attrlinks):
    """
    Factory function to create ccp.nmr.NmrCalc.RunParameter
    """
    return RunParameter(self, **attrlinks)
  
  def newSpectrumData(self, **attrlinks):
    """
    Factory function to create ccp.nmr.NmrCalc.SpectrumData
    """
    return SpectrumData(self, **attrlinks)
  
  def newSpinSystemData(self, **attrlinks):
    """
    Factory function to create ccp.nmr.NmrCalc.SpinSystemData
    """
    return SpinSystemData(self, **attrlinks)
  
  def newStructureEnsembleData(self, **attrlinks):
    """
    Factory function to create ccp.nmr.NmrCalc.StructureEnsembleData
    """
    return StructureEnsembleData(self, **attrlinks)
  
  def newTensorData(self, **attrlinks):
    """
    Factory function to create ccp.nmr.NmrCalc.TensorData
    """
    return TensorData(self, **attrlinks)
  
  def newViolationListData(self, **attrlinks):
    """
    Factory function to create ccp.nmr.NmrCalc.ViolationListData
    """
    return ViolationListData(self, **attrlinks)

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData
  
  def removeDerivedRun(self, value):
    """
    Remove for ccp.nmr.NmrCalc.Run.derivedRuns
    """
    dataDict = self.__dict__
    if (not isinstance(value, Run)):
      raise ApiError("""%s.removeDerivedRun:
       value is not of class ccp.nmr.NmrCalc.Run""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('derivedRuns')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.removeDerivedRun:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.removeDerivedRun:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.removeDerivedRun:
       called with deleted value""" % self.qualifiedName
      )

    if (not (value in currentValues)):
      raise ApiError("""%s.removeDerivedRun:
       value not in list""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      pass

    value.__dict__['masterRun'] = None
    currentValues.remove(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('removeDerivedRun')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def set(self, name, value):
    """
    SetAttr for ccp.nmr.NmrCalc.Run
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess
  
  def setAffiliationStoreName(self, value):
    """
    Set for ccp.nmr.NmrCalc.Run.affiliationStoreName
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setAffiliationStoreName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.setAffiliationStoreName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setAffiliationStoreName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.setAffiliationStoreName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('affiliationStoreName')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setAffiliationStoreName:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setAffiliationStoreName:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['affiliationStoreName'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setAffiliationStoreName')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setAnnealProtocol(self, value):
    """
    setter for derived link annealProtocol
    """
    dataDict = self.__dict__
    if (value is not None):
      from molsim.api.AnnealProtocol import AnnealProtocol as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setAnnealProtocol:
         value is not of class molsim.AnnealProtocol.AnnealProtocol""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = self.getAnnealProtocol()
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      if (value is not None):
        topObject = value.__dict__.get('topObject')
        topObjectsToCheck.add(topObject)

      if (currentValue is not None):
        topObject = currentValue.__dict__.get('topObject')
        topObjectsToCheck.add(topObject)

      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setAnnealProtocol:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setAnnealProtocol:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setAnnealProtocol:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if value is None:
      self.annealProtocolStoreName = None
      self.annealProtocolApp = None
      self.annealProtocolCode = None
    else:
      self.annealProtocolStoreName = value.annealProtocolStore.name
      self.annealProtocolApp = value.application
      self.annealProtocolCode = value.code
    
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

  def setAnnealProtocolApp(self, value):
    """
    Set for ccp.nmr.NmrCalc.Run.annealProtocolApp
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setAnnealProtocolApp:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.setAnnealProtocolApp:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setAnnealProtocolApp:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.setAnnealProtocolApp:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('annealProtocolApp')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setAnnealProtocolApp:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setAnnealProtocolApp:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['annealProtocolApp'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setAnnealProtocolApp')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setAnnealProtocolCode(self, value):
    """
    Set for ccp.nmr.NmrCalc.Run.annealProtocolCode
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setAnnealProtocolCode:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.setAnnealProtocolCode:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setAnnealProtocolCode:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.setAnnealProtocolCode:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('annealProtocolCode')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setAnnealProtocolCode:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setAnnealProtocolCode:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['annealProtocolCode'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setAnnealProtocolCode')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setAnnealProtocolStoreName(self, value):
    """
    Set for ccp.nmr.NmrCalc.Run.annealProtocolStoreName
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setAnnealProtocolStoreName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.setAnnealProtocolStoreName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setAnnealProtocolStoreName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.setAnnealProtocolStoreName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('annealProtocolStoreName')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setAnnealProtocolStoreName:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setAnnealProtocolStoreName:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['annealProtocolStoreName'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setAnnealProtocolStoreName')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData
  
  def setDerivedRuns(self, values):
    """
    Set for ccp.nmr.NmrCalc.Run.derivedRuns
    """
    dataDict = self.__dict__
    xx = values
    values = set(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setDerivedRuns:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      if (not isinstance(value, Run)):
        raise ApiError("""%s.setDerivedRuns:
         value is not of class ccp.nmr.NmrCalc.Run""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('derivedRuns')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setDerivedRuns:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setDerivedRuns:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setDerivedRuns:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      xx1 = dataDict.get('topObject')
      for value in values:
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setDerivedRuns:
           Link derivedRuns between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      if (notInConstructor):
        for value in values:
          (self, value) = (value, self)
          if (not (value is None or value.masterRun is None)):
            raise ApiError("""%s.setDerivedRuns:
             masterRun constraint derived_runs_cannot_be_nested violated by value""" % self.qualifiedName
             + ": %s" % (value,)
            )

          (value, self) = (self, value)

    for cv in currentValues:
      if (not (cv in values)):
        cv.__dict__['masterRun'] = None

    for cv in values:
      if (not (cv in currentValues)):
        oldSelf = cv.__dict__.get('masterRun')
        if (oldSelf is not None):
          vv = oldSelf.__dict__.get('derivedRuns')
          vv.remove(cv)

      cv.__dict__['masterRun'] = self

    dataDict['derivedRuns'] = values
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setDerivedRuns')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setDetails(self, value):
    """
    Set for ccp.nmr.NmrCalc.Run.details
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setDetails:
         memops.Implementation.Text input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 254):
        raise ApiError("""%s.setDetails:
         memops.Implementation.Text maximum length is 254 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setDetails:
         memops.Implementation.Text: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('details')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setDetails:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setDetails:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['details'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setDetails')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setMasterRun(self, value):
    """
    Set for ccp.nmr.NmrCalc.Run.masterRun
    """
    dataDict = self.__dict__
    if (value is not None):
      if (not isinstance(value, Run)):
        raise ApiError("""%s.setMasterRun:
         value is not of class ccp.nmr.NmrCalc.Run""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('masterRun')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setMasterRun:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setMasterRun:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setMasterRun:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setMasterRun:
           Link masterRun between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      if (notInConstructor):
        if (value is not None):
          if (not (value is None or value.masterRun is None)):
            raise ApiError("""%s.setMasterRun:
             masterRun constraint derived_runs_cannot_be_nested violated by value""" % self.qualifiedName
             + ": %s" % (value,)
            )

    if (currentValue is not None):
      if (notIsReading):
        oldSelves = currentValue.__dict__.get('derivedRuns')
        oldSelves.remove(self)
      else:
        raise ApiError("""%s.setMasterRun:
         Read link 'masterRun' incompatible with pre-existing link""" % self.qualifiedName
         + ": %s" % (self,)
        )

    if (value is not None):
      newSelves = value.__dict__.get('derivedRuns')
      newSelves.add(self)

    dataDict['masterRun'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setMasterRun')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setMethodStoreName(self, value):
    """
    Set for ccp.nmr.NmrCalc.Run.methodStoreName
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setMethodStoreName:
         memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 32):
        raise ApiError("""%s.setMethodStoreName:
         memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setMethodStoreName:
         memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.setMethodStoreName:
         Word constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('methodStoreName')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setMethodStoreName:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setMethodStoreName:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['methodStoreName'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setMethodStoreName')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setOperator(self, value):
    """
    setter for derived link "operator"
    """
    dataDict = self.__dict__
    if (value is not None):
      from ccp.api.general.Affiliation import Person as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setOperator:
         value is not of class ccp.general.Affiliation.Person""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('operator')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setOperator:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setOperator:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setOperator:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setOperator:
           Link operator between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    if value is None:
      self.affiliationStoreName = None
      self.operatorSerial = None
    else:
      self.affiliationStoreName = value.affiliationStore.name
      self.operatorSerial = value.serial
    
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setOperator')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setOperatorSerial(self, value):
    """
    Set for ccp.nmr.NmrCalc.Run.operatorSerial
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.setOperatorSerial:
         memops.Implementation.PositiveInt input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value > 0)):
        raise ApiError("""%s.setOperatorSerial:
         PositiveInt constraint int_value_gt_0 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('operatorSerial')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setOperatorSerial:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setOperatorSerial:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['operatorSerial'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setOperatorSerial')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setSerial(self, value):
    """
    Set for ccp.nmr.NmrCalc.Run.serial
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Int.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Int.create(value)
    else:
      raise ApiError("""%s.setSerial:
       memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('serial')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setSerial:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setSerial:
         cannot set serial, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setSerial:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    parent = dataDict.get('nmrCalcStore')
    oldSerial = parent.__dict__.get('_serialDict').get('runs')
    if (value < 0):
      value = (oldSerial + 1)
      parent.__dict__.get('_serialDict')['runs'] = value
    elif (value > oldSerial):
      parent.__dict__.get('_serialDict')['runs'] = value

    dataDict['serial'] = value

    # doNotifies
  
  def setSoftware(self, value):
    """
    setter for derived link software
    """
    dataDict = self.__dict__
    if (value is not None):
      from ccp.api.general.Method import Software as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setSoftware:
         value is not of class ccp.general.Method.Software""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = self.getSoftware()
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setSoftware:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setSoftware:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setSoftware:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if value is None:
      self.methodStoreName = None
      self.softwareName = None
      self.softwareVersion = None
    else:
      self.methodStoreName = value.methodStore.name
      self.softwareName = value.name
      self.softwareVersion = value.version
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

  def setSoftwareName(self, value):
    """
    Set for ccp.nmr.NmrCalc.Run.softwareName
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setSoftwareName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.setSoftwareName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setSoftwareName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.setSoftwareName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('softwareName')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setSoftwareName:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setSoftwareName:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['softwareName'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setSoftwareName')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setSoftwareVersion(self, value):
    """
    Set for ccp.nmr.NmrCalc.Run.softwareVersion
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setSoftwareVersion:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.setSoftwareVersion:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setSoftwareVersion:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.setSoftwareVersion:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('softwareVersion')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setSoftwareVersion:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setSoftwareVersion:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['softwareVersion'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setSoftwareVersion')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setStatus(self, value):
    """
    Set for ccp.nmr.NmrCalc.Run.status
    """
    dataDict = self.__dict__
    if (not (value in ['provisional', 'pending', 'active', 'completed', 'failed'])):
      raise ApiError("""%s.setStatus:
       ccp.nmr.NmrCalc.Status input is not in enumeration ['provisional', 'pending', 'active', 'completed', 'failed']""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.split()) == 1)):
      raise ApiError("""%s.setStatus:
       Status constraint contains_no_white_space violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('status')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setStatus:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setStatus:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setStatus:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['status'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setStatus')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setStructureGeneration(self, value):
    """
    setter for derived link structureGeneration
    """
    dataDict = self.__dict__
    if (value is not None):
      from ccp.api.nmr.Nmr import StructureGeneration as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setStructureGeneration:
         value is not of class ccp.nmr.Nmr.StructureGeneration""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = self.getStructureGeneration()
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      if (value is not None):
        topObject = value.__dict__.get('topObject')
        topObjectsToCheck.add(topObject)

      if (currentValue is not None):
        topObject = currentValue.__dict__.get('topObject')
        topObjectsToCheck.add(topObject)

      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setStructureGeneration:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setStructureGeneration:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setStructureGeneration:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if value is None:
      self.structureGenerationSerial = None
    elif value.nmrProject is self.nmrCalcStore.nmrProject:
      self.structureGenerationSerial = value.serial
    else:
      raise ApiError("%s does not belong to NmrCalcStore.nmrProject %s" % (value,self.topObject.nmrProject ))
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

  def setStructureGenerationSerial(self, value):
    """
    Set for ccp.nmr.NmrCalc.Run.structureGenerationSerial
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.setStructureGenerationSerial:
         memops.Implementation.PositiveInt input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value > 0)):
        raise ApiError("""%s.setStructureGenerationSerial:
         PositiveInt constraint int_value_gt_0 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('structureGenerationSerial')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setStructureGenerationSerial:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setStructureGenerationSerial:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['structureGenerationSerial'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setStructureGenerationSerial')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setWmsProtocolName(self, value):
    """
    Set for ccp.nmr.NmrCalc.Run.wmsProtocolName
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setWmsProtocolName:
         memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 32):
        raise ApiError("""%s.setWmsProtocolName:
         memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setWmsProtocolName:
         memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.setWmsProtocolName:
         Word constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('wmsProtocolName')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setWmsProtocolName:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setWmsProtocolName:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['wmsProtocolName'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setWmsProtocolName')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def sortedData(self):
    """
    Sorted for ccp.nmr.NmrCalc.Run.data
    """
    dataDict = self.__dict__
    sortdd = dataDict.get('data')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result
  
  def sortedDerivedRuns(self):
    """
    Sorted for ccp.nmr.NmrCalc.Run.derivedRuns
    """
    dataDict = self.__dict__
    ll = dataDict.get('derivedRuns')
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result
  
  def sortedInputs(self):
    """
    Sorted for ccp.nmr.NmrCalc.Run.inputs
    """
    dataDict = self.__dict__
    ll = self.getInputs()
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result
  
  def sortedOutputs(self):
    """
    Sorted for ccp.nmr.NmrCalc.Run.outputs
    """
    dataDict = self.__dict__
    ll = self.getOutputs()
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result
  
  def sortedRunParameters(self):
    """
    Sorted for ccp.nmr.NmrCalc.Run.runParameters
    """
    dataDict = self.__dict__
    sortdd = dataDict.get('runParameters')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString
  
  affiliationStoreName = property(getAffiliationStoreName, setAffiliationStoreName, None,
  r"""Name of AffiliationStore storing Operator person record. Part of key for 
  derived link "operator".
  """)
  
  annealProtocolApp = property(getAnnealProtocolApp, setAnnealProtocolApp, None,
  r"""Application used in AnnealProtocol. Part of the key for the 
  annealProtocol derived link
  """)
  
  annealProtocolCode = property(getAnnealProtocolCode, setAnnealProtocolCode, None,
  r"""Annealing protocol code. Part of the key for the derived annealProtocol 
  link. 
  """)
  
  annealProtocolStoreName = property(getAnnealProtocolStoreName, setAnnealProtocolStoreName, None,
  r"""Name of AnnealProtocolStore containing AnnealProtocol. Part of the key 
  for the annealProtocol derived link
  """)

  applicationData = memops.api.Implementation.DataObject.applicationData

  className = memops.api.Implementation.ComplexDataType.className
  
  details = property(getDetails, setDetails, None,
  r"""Free text, for notes, explanatory comments, etc.
  """)

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted

  metaclass = memops.api.Implementation.ComplexDataType.metaclass
  
  methodStoreName = property(getMethodStoreName, setMethodStoreName, None,
  r"""name of associated MethodStore. Part of key for derived link 'software'. 
  
  """)
  
  operatorSerial = property(getOperatorSerial, setOperatorSerial, None,
  r"""Serial of operator. Part of key for derived link "operator"
  """)

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName
  
  serial = property(getSerial, setSerial, None,
  r"""Serial number of object. Serves as object main key. Serial numbers of 
  deleted objects are not re-used. Serial numbers can only be set by the 
  implementation. Values are in practice always positive, since negative 
  values are interpreted as a signal to set the next free serial
  """)
  
  softwareName = property(getSoftwareName, setSoftwareName, None,
  r"""Name of software used for calculation. Part of key for derived link 
  'software'.
  """)
  
  softwareVersion = property(getSoftwareVersion, setSoftwareVersion, None,
  r"""Version string of software used for calculation. Part of key for derived 
  link 'software'.
  """)
  
  status = property(getStatus, setStatus, None,
  r"""Calculation status
  """)
  
  structureGenerationSerial = property(getStructureGenerationSerial, setStructureGenerationSerial, None,
  r"""serial for Nmr.StructureGeneration associated with this run. Key for 
  derived  link structureGeneration 
  """)
  
  wmsProtocolName = property(getWmsProtocolName, setWmsProtocolName, None,
  r"""name of associated WmsProtol - key for derived link wmsProtocol
  """)

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess
  
  annealProtocol = property(getAnnealProtocol, setAnnealProtocol, None,
  r"""AnnealProtocol used for run
  """)
  
  data = property(getData,  None, None,
  r"""child link to class Data
  """)
  
  derivedRuns = property(getDerivedRuns, setDerivedRuns, None,
  r"""Runs launched from this run - E.g. when a single data set is used to 
  launch several different calculations.
  """)
  
  inputs = property(getInputs, None, None,
  r"""Input data units
  """)
  
  masterRun = property(getMasterRun, setMasterRun, None,
  r"""Run used to launch this run - E.g. when a single data set is used to 
  launch several different calculations.
  """)
  
  nmrCalcStore = property(getNmrCalcStore,  None, None,
  r"""parent link
  """)
  
  operator = property(getOperator, setOperator, None,
  r"""Person submitting the calculation
  """)
  
  outputs = property(getOutputs, None, None,
  r"""output data units
  """)
  
  parent = property(getParent, None, None,
  r"""link to parent object - synonym for nmrCalcStore
  """)

  root = memops.api.Implementation.MemopsObject.root
  
  runParameters = property(getRunParameters,  None, None,
  r"""child link to class RunParameter
  """)
  
  software = property(getSoftware, setSoftware, None,
  r"""
  """)
  
  structureGeneration = property(getStructureGeneration, setStructureGeneration, None,
  r"""NMR Structure generation that run contributes to
  """)

  topObject = memops.api.Implementation.DataObject.topObject

###############################################################################
class RunParameter(ccp.api.general.Template.MultiTypeValue):
  r"""Run parameter - mainly used for input parameters
  """
  #   from data model element ccp.nmr.NmrCalc.RunParameter revision ?
  _metaclass = metaPackage.getElement('RunParameter')
  _packageName = 'ccp.nmr.NmrCalc'
  _packageShortName = 'CALC'
  _fieldNames = ('applicationData', 'booleanValue', 'className', 'code', 'fieldNames', 'floatValue', 'inConstructor', 'intValue', 'ioRole', 'isDeleted', 'metaclass', 'name', 'packageName', 'packageShortName', 'qualifiedName', 'serial', 'textValue', 'access', 'activeAccess', 'data', 'parent', 'root', 'run', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for ccp.nmr.NmrCalc.RunParameter
    """
    dataDict = self.__dict__
    dataDict['run'] = parent
    if (not isinstance(parent, Run)):
      raise ApiError("""%s.__init__:
       value is not of class ccp.nmr.NmrCalc.Run""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = parent.__dict__.get('topObject')
    dataDict['topObject'] = topObject

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    if (notIsReading):
      if (not (topObject.__dict__.get('isModifiable'))):
        raise ApiError("""%s.__init__:
         Storage not modifiable""" % self.qualifiedName
         + ": %s" % (topObject,)
        )

    try:

      dataDict['applicationData'] = list()
      dataDict['booleanValue'] = None
      dataDict['code'] = None
      dataDict['floatValue'] = None
      dataDict['intValue'] = None
      dataDict['ioRole'] = 'input'
      dataDict['name'] = None
      dataDict['serial'] = None
      dataDict['textValue'] = None
      dataDict['access'] = None
      dataDict['data'] = None

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in ccp.nmr.NmrCalc.RunParameter.__init__"
        del dataDict['inConstructor']
        raise

      if (notOverride):
        if (dataDict.get('serial') is None):
          dataDict['inConstructor'] = True
          self.setSerial(-1)
          del dataDict['inConstructor']
        else:
          raise ApiError("""%s.__init__:
           Cannot pass in explicit serial if not reading""" % self.qualifiedName
           + ": %s:%s" % (parent, 'ccp.nmr.NmrCalc.RunParameter')
          )

      if (notIsReading):
        childrenDict = parent.__dict__.get('runParameters')
        objKey = dataDict.get('serial')
        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['serial'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notOverride):
        self.checkValid()

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for ccp.nmr.NmrCalc.RunParameter:
       determines cascading 
    deletes to follow from delete of object.
       *Implementation function* - 
    should be called only by API delete function.
    """
    dataDict = self.__dict__
    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for ccp.nmr.NmrCalc.RunParameter:   deletes
    objects
    *Implementation function* - will CORRUPT DATA if called outside 
    the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    data = dataDict.get('data')
    if ((data is not None and not (data in objsToBeDeleted))):
      runParameters = data.__dict__.get('runParameters')
      runParameters.remove(self)

    run = dataDict.get('run')
    if (not (run in objsToBeDeleted)):
      objKey = dataDict.get('serial')
      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = run.__dict__.get('runParameters')
        if (self is dd.get(objKey)):
          del dd[objKey]

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData
  
  def checkAllValid(self, complete=False):
    """
    CheckAllValid for ccp.nmr.NmrCalc.RunParameter
    """
    dataDict = self.__dict__
    self.checkValid(complete)
  
  def checkValid(self, complete=False):
    """
    CheckValid for ccp.nmr.NmrCalc.RunParameter
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      objKey = dataDict.get('serial')
      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('run')
        dd = value.__dict__.get('runParameters')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'run' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      # check attributes
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('booleanValue')
      if (value is not None):
        if (not (value in [True, False])):
          raise ApiError("""%s.checkValid: booleanValue:
           memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('code')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: code:
           memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 32):
          raise ApiError("""%s.checkValid: code:
           memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: code:
           memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.split()) == 1)):
          raise ApiError("""%s.checkValid: code:
           Word constraint contains_no_white_space violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('floatValue')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.Float.PythonType)):
          pass
        elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
          value = memops.api.Implementation.Float.create(value)
        else:
          raise ApiError("""%s.checkValid: floatValue:
           memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (value - value == 0.0)):
          raise ApiError("""%s.checkValid: floatValue:
           Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('intValue')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.Int.PythonType)):
          pass
        elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
          value = memops.api.Implementation.Int.create(value)
        else:
          raise ApiError("""%s.checkValid: intValue:
           memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('ioRole')
      if (not (value in ['input', 'output'])):
        raise ApiError("""%s.checkValid: ioRole:
         ccp.nmr.NmrCalc.IoRole input is not in enumeration ['input', 'output']""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.checkValid: ioRole:
         IoRole constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('name')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: name:
           memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: name:
           memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: name:
           memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: name:
           Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('serial')
      if (value is None):
        raise ApiError("""%s.checkValid: serial:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.checkValid: serial:
         memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('textValue')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: textValue:
           memops.Implementation.String input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('data')
      if (value is not None):
        if (not isinstance(value, Data)):
          raise ApiError("""%s.checkValid: data:
           value is not of class ccp.nmr.NmrCalc.Data""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('runParameters')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: data:
           non-reciprocal link data from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      value = dataDict.get('run')
      if (not isinstance(value, Run)):
        raise ApiError("""%s.checkValid: run:
         value is not of class ccp.nmr.NmrCalc.Run""" % self.qualifiedName
         + ": %s" % (value,)
        )

    # check explicit class constraints
    # check attributes
    values = dataDict.get('applicationData')
    for value in values:
      value.checkAllValid(complete)

    value = dataDict.get('booleanValue')
    value = dataDict.get('code')
    value = dataDict.get('floatValue')
    value = dataDict.get('intValue')
    value = dataDict.get('ioRole')
    if (value is None):
      raise ApiError("""%s.checkValid: ioRole:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('name')
    value = dataDict.get('textValue')
    # check roles
    value = dataDict.get('access')
    value = dataDict.get('data')
    value = dataDict.get('run')
    if (value is None):
      raise ApiError("""%s.checkValid: run:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

  delete = memops.api.Implementation.DataObject.delete

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData
  
  def get(self, name):
    """
    GetAttr for ccp.nmr.NmrCalc.RunParameter
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData

  getBooleanValue = ccp.api.general.Template.MultiTypeValue.getBooleanValue
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccp.nmr.NmrCalc.RunParameter
    """

    result = None
    if (startObj.__class__.__name__ == 'MemopsRoot'):
      if (4 != len(fullKey)):
        raise ApiError("""'ccp.nmr.NmrCalc.RunParameter'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj0 = startObj
      ll = list()
      objKey = fullKey[0]
      ll.append(objKey)
      if (objKey is not None):
        objKey = fullKey[1]
        ll.append(objKey)
        if (objKey is not None):
          objKey = tuple(ll)

      obj1 = obj0.__dict__.get('nmrCalcStores').get(objKey)
      if (obj1 is None):
        obj0.refreshTopObjects('ccp.nmr.NmrCalc')
        obj1 = obj0.__dict__.get('nmrCalcStores').get(objKey)

    else:
      if (2 != len(fullKey)):
        raise ApiError("""'ccp.nmr.NmrCalc.RunParameter'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj1 = startObj

    if (obj1 is not None):
      if (not (obj1.__dict__.get('isLoaded'))):
        obj1.load()

      objKey = fullKey[-2]
      obj2 = obj1.__dict__.get('runs').get(objKey)

      if (obj2 is not None):
        objKey = fullKey[-1]
        obj3 = obj2.__dict__.get('runParameters').get(objKey)
        result = obj3

    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation

  getClassName = memops.api.Implementation.ComplexDataType.getClassName
  
  def getCode(self):
    """
    Get for ccp.nmr.NmrCalc.RunParameter.code
    """
    dataDict = self.__dict__
    result = dataDict.get('code')
    return result
  
  def getData(self):
    """
    Get for ccp.nmr.NmrCalc.RunParameter.data
    """
    dataDict = self.__dict__
    result = dataDict.get('data')
    return result

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames

  getFloatValue = ccp.api.general.Template.MultiTypeValue.getFloatValue
  
  def getFullKey(self, useGuid=False):
    """
    GetFullKey for ccp.nmr.NmrCalc.RunParameter
    """
    dataDict = self.__dict__
    result = list()

    obj2 = dataDict.get('run')
    obj1 = obj2.__dict__.get('nmrCalcStore')

    if (useGuid):
      result.append(obj1.__dict__.get('guid'))
    else:
      result.append(obj1.__dict__.get('nmrProjectName'))
      result.append(obj1.__dict__.get('name'))

    result.append(obj2.__dict__.get('serial'))
    result.append(dataDict.get('serial'))

    return result

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor

  getIntValue = ccp.api.general.Template.MultiTypeValue.getIntValue
  
  def getIoRole(self):
    """
    Get for ccp.nmr.NmrCalc.RunParameter.ioRole
    """
    dataDict = self.__dict__
    result = dataDict.get('ioRole')
    return result

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted
  
  def getLocalKey(self):
    """
    GetLocalKey for ccp.nmr.NmrCalc.RunParameter
    """
    dataDict = self.__dict__
    result = dataDict.get('serial')
    return result

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass
  
  def getName(self):
    """
    Get for ccp.nmr.NmrCalc.RunParameter.name
    """
    dataDict = self.__dict__
    result = dataDict.get('name')
    return result

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName
  
  def getParent(self):
    """
    Get for ccp.nmr.NmrCalc.RunParameter.parent
    """
    dataDict = self.__dict__
    result = dataDict.get('run')
    return result

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName

  getRoot = memops.api.Implementation.MemopsObject.getRoot
  
  def getRun(self):
    """
    Get for ccp.nmr.NmrCalc.RunParameter.run
    """
    dataDict = self.__dict__
    result = dataDict.get('run')
    return result
  
  def getSerial(self):
    """
    Get for ccp.nmr.NmrCalc.RunParameter.serial
    """
    dataDict = self.__dict__
    result = dataDict.get('serial')
    return result

  getTextValue = ccp.api.general.Template.MultiTypeValue.getTextValue

  getTopObject = memops.api.Implementation.DataObject.getTopObject

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData
  
  def set(self, name, value):
    """
    SetAttr for ccp.nmr.NmrCalc.RunParameter
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData

  setBooleanValue = ccp.api.general.Template.MultiTypeValue.setBooleanValue
  
  def setCode(self, value):
    """
    Set for ccp.nmr.NmrCalc.RunParameter.code
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setCode:
         memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 32):
        raise ApiError("""%s.setCode:
         memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setCode:
         memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.setCode:
         Word constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('code')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setCode:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setCode:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['code'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setCode')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setData(self, value):
    """
    Set for ccp.nmr.NmrCalc.RunParameter.data
    """
    dataDict = self.__dict__
    if (value is not None):
      if (not isinstance(value, Data)):
        raise ApiError("""%s.setData:
         value is not of class ccp.nmr.NmrCalc.Data""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('data')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setData:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setData:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setData:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setData:
           Link data between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    if (currentValue is not None):
      if (notIsReading):
        oldSelves = currentValue.__dict__.get('runParameters')
        oldSelves.remove(self)
      else:
        raise ApiError("""%s.setData:
         Read link 'data' incompatible with pre-existing link""" % self.qualifiedName
         + ": %s" % (self,)
        )

    if (value is not None):
      newSelves = value.__dict__.get('runParameters')
      newSelves.add(self)

    dataDict['data'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setData')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  setFloatValue = ccp.api.general.Template.MultiTypeValue.setFloatValue

  setIntValue = ccp.api.general.Template.MultiTypeValue.setIntValue
  
  def setIoRole(self, value):
    """
    Set for ccp.nmr.NmrCalc.RunParameter.ioRole
    """
    dataDict = self.__dict__
    if (not (value in ['input', 'output'])):
      raise ApiError("""%s.setIoRole:
       ccp.nmr.NmrCalc.IoRole input is not in enumeration ['input', 'output']""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.split()) == 1)):
      raise ApiError("""%s.setIoRole:
       IoRole constraint contains_no_white_space violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('ioRole')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setIoRole:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setIoRole:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setIoRole:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['ioRole'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setIoRole')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setName(self, value):
    """
    Set for ccp.nmr.NmrCalc.RunParameter.name
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.setName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.setName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('name')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setName:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setName:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['name'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setName')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setSerial(self, value):
    """
    Set for ccp.nmr.NmrCalc.RunParameter.serial
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Int.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Int.create(value)
    else:
      raise ApiError("""%s.setSerial:
       memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('serial')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setSerial:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setSerial:
         cannot set serial, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setSerial:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    parent = dataDict.get('run')
    oldSerial = parent.__dict__.get('_serialDict').get('runParameters')
    if (value < 0):
      value = (oldSerial + 1)
      parent.__dict__.get('_serialDict')['runParameters'] = value
    elif (value > oldSerial):
      parent.__dict__.get('_serialDict')['runParameters'] = value

    dataDict['serial'] = value

    # doNotifies

  setTextValue = ccp.api.general.Template.MultiTypeValue.setTextValue

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  applicationData = memops.api.Implementation.DataObject.applicationData

  booleanValue = ccp.api.general.Template.MultiTypeValue.booleanValue

  className = memops.api.Implementation.ComplexDataType.className
  
  code = property(getCode, setCode, None,
  r"""Unique identifier for the parameter within the context of the 
  application being run 
  """)

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames

  floatValue = ccp.api.general.Template.MultiTypeValue.floatValue

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor

  intValue = ccp.api.general.Template.MultiTypeValue.intValue
  
  ioRole = property(getIoRole, setIoRole, None,
  r"""Role of data in calculation (input / output).
  """)

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted

  metaclass = memops.api.Implementation.ComplexDataType.metaclass
  
  name = property(getName, setName, None,
  r"""Human readable name of parameter
  """)

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName
  
  serial = property(getSerial, setSerial, None,
  r"""Serial number of object. Serves as object main key. Serial numbers of 
  deleted objects are not re-used. Serial numbers can only be set by the 
  implementation. Values are in practice always positive, since negative 
  values are interpreted as a signal to set the next free serial
  """)

  textValue = ccp.api.general.Template.MultiTypeValue.textValue

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess
  
  data = property(getData, setData, None,
  r"""Unit of data that paremeter refers to.
  """)
  
  parent = property(getParent, None, None,
  r"""link to parent object - synonym for run
  """)

  root = memops.api.Implementation.MemopsObject.root
  
  run = property(getRun,  None, None,
  r"""parent link
  """)

  topObject = memops.api.Implementation.DataObject.topObject

###############################################################################
class TensorData(Data):
  r"""Data for orientation matrices, order tensors, etc.
  """
  #   from data model element ccp.nmr.NmrCalc.TensorData revision ?
  _metaclass = metaPackage.getElement('TensorData')
  _packageName = 'ccp.nmr.NmrCalc'
  _packageShortName = 'CALC'
  _fieldNames = ('applicationData', 'className', 'code', 'details', 'fieldNames', 'inConstructor', 'ioRole', 'isDeleted', 'metaclass', 'name', 'orientationMatrix', 'packageName', 'packageShortName', 'qualifiedName', 'serial', 'access', 'activeAccess', 'parameterGroup', 'parent', 'root', 'run', 'runParameters', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for ccp.nmr.NmrCalc.TensorData
    """
    dataDict = self.__dict__
    dataDict['run'] = parent
    if (not isinstance(parent, Run)):
      raise ApiError("""%s.__init__:
       value is not of class ccp.nmr.NmrCalc.Run""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = parent.__dict__.get('topObject')
    dataDict['topObject'] = topObject

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    if (notIsReading):
      if (not (topObject.__dict__.get('isModifiable'))):
        raise ApiError("""%s.__init__:
         Storage not modifiable""" % self.qualifiedName
         + ": %s" % (topObject,)
        )

    try:

      dataDict['applicationData'] = list()
      dataDict['code'] = None
      dataDict['details'] = None
      dataDict['ioRole'] = 'input'
      dataDict['name'] = None
      dataDict['orientationMatrix'] = None
      dataDict['serial'] = None
      dataDict['access'] = None
      dataDict['parameterGroup'] = None
      dataDict['runParameters'] = set()

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in ccp.nmr.NmrCalc.TensorData.__init__"
        del dataDict['inConstructor']
        raise

      if (notOverride):
        if (dataDict.get('serial') is None):
          dataDict['inConstructor'] = True
          self.setSerial(-1)
          del dataDict['inConstructor']
        else:
          raise ApiError("""%s.__init__:
           Cannot pass in explicit serial if not reading""" % self.qualifiedName
           + ": %s:%s" % (parent, 'ccp.nmr.NmrCalc.TensorData')
          )

      if (notIsReading):
        childrenDict = parent.__dict__.get('data')
        objKey = dataDict.get('serial')
        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['serial'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notOverride):
        self.checkValid()

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for ccp.nmr.NmrCalc.TensorData:
       determines cascading 
    deletes to follow from delete of object.
       *Implementation function* - 
    should be called only by API delete function.
    """
    dataDict = self.__dict__
    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for ccp.nmr.NmrCalc.TensorData:   deletes
    objects
    *Implementation function* - will CORRUPT DATA if called outside 
    the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    parameterGroup = dataDict.get('parameterGroup')
    if ((parameterGroup is not None and not (parameterGroup in objsToBeDeleted))):
      data = parameterGroup.__dict__.get('data')
      data.remove(self)

    for runParameter in dataDict.get('runParameters'):
      if (not (runParameter in objsToBeDeleted)):
        runParameter.__dict__['data'] = None

    run = dataDict.get('run')
    if (not (run in objsToBeDeleted)):
      objKey = dataDict.get('serial')
      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = run.__dict__.get('data')
        if (self is dd.get(objKey)):
          del dd[objKey]

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData

  addRunParameter = Data.addRunParameter
  
  def checkAllValid(self, complete=False):
    """
    CheckAllValid for ccp.nmr.NmrCalc.TensorData
    """
    dataDict = self.__dict__
    self.checkValid(complete)
  
  def checkValid(self, complete=False):
    """
    CheckValid for ccp.nmr.NmrCalc.TensorData
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      objKey = dataDict.get('serial')
      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('run')
        dd = value.__dict__.get('data')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'run' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      # check attributes
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('code')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: code:
           memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 32):
          raise ApiError("""%s.checkValid: code:
           memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: code:
           memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.split()) == 1)):
          raise ApiError("""%s.checkValid: code:
           Word constraint contains_no_white_space violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('details')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: details:
           memops.Implementation.Text input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 254):
          raise ApiError("""%s.checkValid: details:
           memops.Implementation.Text maximum length is 254 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: details:
           memops.Implementation.Text: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('ioRole')
      if (not (value in ['input', 'output'])):
        raise ApiError("""%s.checkValid: ioRole:
         ccp.nmr.NmrCalc.IoRole input is not in enumeration ['input', 'output']""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.checkValid: ioRole:
         IoRole constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('name')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: name:
           memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: name:
           memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: name:
           memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: name:
           Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('orientationMatrix')
      from memops.api.Implementation import SymmTracelessMatrix as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.checkValid: orientationMatrix:
         value is not of class memops.Implementation.SymmTracelessMatrix""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('serial')
      if (value is None):
        raise ApiError("""%s.checkValid: serial:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.checkValid: serial:
         memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('parameterGroup')
      if (value is not None):
        if (not isinstance(value, ParameterGroup)):
          raise ApiError("""%s.checkValid: parameterGroup:
           value is not of class ccp.nmr.NmrCalc.ParameterGroup""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('data')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: parameterGroup:
           non-reciprocal link parameterGroup from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      value = dataDict.get('run')
      if (not isinstance(value, Run)):
        raise ApiError("""%s.checkValid: run:
         value is not of class ccp.nmr.NmrCalc.Run""" % self.qualifiedName
         + ": %s" % (value,)
        )

      values = dataDict.get('runParameters')
      for value in values:
        if (not isinstance(value, RunParameter)):
          raise ApiError("""%s.checkValid: runParameters:
           value is not of class ccp.nmr.NmrCalc.RunParameter""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('data')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: runParameters:
           non-reciprocal link runParameters from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: runParameters:
           Link runParameters between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    # check explicit class constraints
    # check attributes
    values = dataDict.get('applicationData')
    for value in values:
      value.checkAllValid(complete)

    value = dataDict.get('code')
    value = dataDict.get('details')
    value = dataDict.get('ioRole')
    if (value is None):
      raise ApiError("""%s.checkValid: ioRole:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('name')
    value = dataDict.get('orientationMatrix')
    if (value is None):
      raise ApiError("""%s.checkValid: orientationMatrix:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value.checkAllValid(complete)
    # check roles
    value = dataDict.get('access')
    value = dataDict.get('parameterGroup')
    if (value is not None):
      isValid = True
      obj = self
      while obj is not None:
        obj = obj.parameterGroup
        if obj is self:
          isValid = False
          break
      if (not (isValid)):
        raise ApiError("""%s.checkValid: parameterGroup:
         parameterGroup constraint No_cyclical_parameter_grouping violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    value = dataDict.get('run')
    if (value is None):
      raise ApiError("""%s.checkValid: run:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    values = dataDict.get('runParameters')

  delete = memops.api.Implementation.DataObject.delete

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData

  findAllRunParameters = Data.findAllRunParameters

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData

  findFirstRunParameter = Data.findFirstRunParameter
  
  def get(self, name):
    """
    GetAttr for ccp.nmr.NmrCalc.TensorData
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccp.nmr.NmrCalc.TensorData
    """

    result = None
    if (startObj.__class__.__name__ == 'MemopsRoot'):
      if (4 != len(fullKey)):
        raise ApiError("""'ccp.nmr.NmrCalc.TensorData'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj0 = startObj
      ll = list()
      objKey = fullKey[0]
      ll.append(objKey)
      if (objKey is not None):
        objKey = fullKey[1]
        ll.append(objKey)
        if (objKey is not None):
          objKey = tuple(ll)

      obj1 = obj0.__dict__.get('nmrCalcStores').get(objKey)
      if (obj1 is None):
        obj0.refreshTopObjects('ccp.nmr.NmrCalc')
        obj1 = obj0.__dict__.get('nmrCalcStores').get(objKey)

    else:
      if (2 != len(fullKey)):
        raise ApiError("""'ccp.nmr.NmrCalc.TensorData'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj1 = startObj

    if (obj1 is not None):
      if (not (obj1.__dict__.get('isLoaded'))):
        obj1.load()

      objKey = fullKey[-2]
      obj2 = obj1.__dict__.get('runs').get(objKey)

      if (obj2 is not None):
        objKey = fullKey[-1]
        obj3 = obj2.__dict__.get('data').get(objKey)
        if (isinstance(obj3, TensorData)):
          result = obj3

    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation

  getClassName = memops.api.Implementation.ComplexDataType.getClassName

  getCode = Data.getCode

  getDetails = Data.getDetails

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames

  getFullKey = Data.getFullKey

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor

  getIoRole = Data.getIoRole

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted

  getLocalKey = Data.getLocalKey

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass

  getName = Data.getName
  
  def getOrientationMatrix(self):
    """
    Get for ccp.nmr.NmrCalc.TensorData.orientationMatrix
    """
    dataDict = self.__dict__
    result = dataDict.get('orientationMatrix')
    return result

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName

  getParameterGroup = Data.getParameterGroup

  getParent = Data.getParent

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName

  getRoot = memops.api.Implementation.MemopsObject.getRoot

  getRun = Data.getRun

  getRunParameters = Data.getRunParameters

  getSerial = Data.getSerial

  getTopObject = memops.api.Implementation.DataObject.getTopObject

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData

  removeRunParameter = Data.removeRunParameter
  
  def set(self, name, value):
    """
    SetAttr for ccp.nmr.NmrCalc.TensorData
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData

  setCode = Data.setCode

  setDetails = Data.setDetails

  setIoRole = Data.setIoRole

  setName = Data.setName
  
  def setOrientationMatrix(self, value):
    """
    Set for ccp.nmr.NmrCalc.TensorData.orientationMatrix
    """
    dataDict = self.__dict__
    from memops.api.Implementation import SymmTracelessMatrix as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.setOrientationMatrix:
       value is not of class memops.Implementation.SymmTracelessMatrix""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('orientationMatrix')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setOrientationMatrix:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setOrientationMatrix:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setOrientationMatrix:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['orientationMatrix'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setOrientationMatrix')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  setParameterGroup = Data.setParameterGroup

  setRunParameters = Data.setRunParameters

  setSerial = Data.setSerial

  sortedRunParameters = Data.sortedRunParameters

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  applicationData = memops.api.Implementation.DataObject.applicationData

  className = memops.api.Implementation.ComplexDataType.className

  code = Data.code

  details = Data.details

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor

  ioRole = Data.ioRole

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted

  metaclass = memops.api.Implementation.ComplexDataType.metaclass

  name = Data.name
  
  orientationMatrix = property(getOrientationMatrix, setOrientationMatrix, None,
  r"""Symmetrical traceless matrix
  """)

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName

  serial = Data.serial

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess

  parameterGroup = Data.parameterGroup

  parent = Data.parent

  root = memops.api.Implementation.MemopsObject.root

  run = Data.run

  runParameters = Data.runParameters

  topObject = memops.api.Implementation.DataObject.topObject

###############################################################################
class FloatMatrixData(Data):
  r"""Floating point matrix data
  """
  #   from data model element ccp.nmr.NmrCalc.FloatMatrixData revision ?
  _metaclass = metaPackage.getElement('FloatMatrixData')
  _packageName = 'ccp.nmr.NmrCalc'
  _packageShortName = 'CALC'
  _fieldNames = ('applicationData', 'className', 'code', 'data', 'defaultValue', 'details', 'fieldNames', 'inConstructor', 'ioRole', 'isDeleted', 'metaclass', 'name', 'ndim', 'packageName', 'packageShortName', 'qualifiedName', 'serial', 'shape', 'size', 'access', 'activeAccess', 'parameterGroup', 'parent', 'root', 'run', 'runParameters', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for ccp.nmr.NmrCalc.FloatMatrixData
    """
    dataDict = self.__dict__
    dataDict['run'] = parent
    if (not isinstance(parent, Run)):
      raise ApiError("""%s.__init__:
       value is not of class ccp.nmr.NmrCalc.Run""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = parent.__dict__.get('topObject')
    dataDict['topObject'] = topObject

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    if (notIsReading):
      if (not (topObject.__dict__.get('isModifiable'))):
        raise ApiError("""%s.__init__:
         Storage not modifiable""" % self.qualifiedName
         + ": %s" % (topObject,)
        )

    try:

      dataDict['applicationData'] = list()
      dataDict['code'] = None
      dataDict['data'] = list()
      dataDict['defaultValue'] = 0.0
      dataDict['details'] = None
      dataDict['ioRole'] = 'input'
      dataDict['name'] = None
      dataDict['serial'] = None
      dataDict['shape'] = list()
      dataDict['access'] = None
      dataDict['parameterGroup'] = None
      dataDict['runParameters'] = set()

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in ccp.nmr.NmrCalc.FloatMatrixData.__init__"
        del dataDict['inConstructor']
        raise

      if (notOverride):
        if (dataDict.get('serial') is None):
          dataDict['inConstructor'] = True
          self.setSerial(-1)
          del dataDict['inConstructor']
        else:
          raise ApiError("""%s.__init__:
           Cannot pass in explicit serial if not reading""" % self.qualifiedName
           + ": %s:%s" % (parent, 'ccp.nmr.NmrCalc.FloatMatrixData')
          )

      if (notIsReading):
        childrenDict = parent.__dict__.get('data')
        objKey = dataDict.get('serial')
        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['serial'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notOverride):
        self.checkValid()

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for ccp.nmr.NmrCalc.FloatMatrixData:
       determines cascading 
    deletes to follow from delete of object.
       *Implementation function* - 
    should be called only by API delete function.
    """
    dataDict = self.__dict__
    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for ccp.nmr.NmrCalc.FloatMatrixData:   deletes
    objects
    *Implementation function* - will CORRUPT DATA if called outside 
    the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    parameterGroup = dataDict.get('parameterGroup')
    if ((parameterGroup is not None and not (parameterGroup in objsToBeDeleted))):
      data = parameterGroup.__dict__.get('data')
      data.remove(self)

    for runParameter in dataDict.get('runParameters'):
      if (not (runParameter in objsToBeDeleted)):
        runParameter.__dict__['data'] = None

    run = dataDict.get('run')
    if (not (run in objsToBeDeleted)):
      objKey = dataDict.get('serial')
      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = run.__dict__.get('data')
        if (self is dd.get(objKey)):
          del dd[objKey]

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData

  addRunParameter = Data.addRunParameter
  
  def checkAllValid(self, complete=False):
    """
    CheckAllValid for ccp.nmr.NmrCalc.FloatMatrixData
    """
    dataDict = self.__dict__
    self.checkValid(complete)
  
  def checkValid(self, complete=False):
    """
    CheckValid for ccp.nmr.NmrCalc.FloatMatrixData
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      objKey = dataDict.get('serial')
      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('run')
        dd = value.__dict__.get('data')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'run' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      # check attributes
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('code')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: code:
           memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 32):
          raise ApiError("""%s.checkValid: code:
           memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: code:
           memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.split()) == 1)):
          raise ApiError("""%s.checkValid: code:
           Word constraint contains_no_white_space violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      values = dataDict.get('data')
      for value in values:
        if (isinstance(value, memops.api.Implementation.Float.PythonType)):
          pass
        elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
          castValue = memops.api.Implementation.Float.create(value)
          replaceIndex = values.index(value)
          values[replaceIndex] = castValue
          value = castValue
        else:
          raise ApiError("""%s.checkValid: data:
           memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (value - value == 0.0)):
          raise ApiError("""%s.checkValid: data:
           Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('defaultValue')
      if (isinstance(value, memops.api.Implementation.Float.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Float.create(value)
      else:
        raise ApiError("""%s.checkValid: defaultValue:
         memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value - value == 0.0)):
        raise ApiError("""%s.checkValid: defaultValue:
         Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('details')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: details:
           memops.Implementation.Text input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 254):
          raise ApiError("""%s.checkValid: details:
           memops.Implementation.Text maximum length is 254 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: details:
           memops.Implementation.Text: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('ioRole')
      if (not (value in ['input', 'output'])):
        raise ApiError("""%s.checkValid: ioRole:
         ccp.nmr.NmrCalc.IoRole input is not in enumeration ['input', 'output']""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.checkValid: ioRole:
         IoRole constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('name')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: name:
           memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: name:
           memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: name:
           memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: name:
           Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = self.getNdim()
      if (value is None):
        raise ApiError("""%s.checkValid: ndim:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.checkValid: ndim:
         memops.Implementation.PositiveInt input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value > 0)):
        raise ApiError("""%s.checkValid: ndim:
         PositiveInt constraint int_value_gt_0 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('serial')
      if (value is None):
        raise ApiError("""%s.checkValid: serial:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.checkValid: serial:
         memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      values = dataDict.get('shape')
      for value in values:
        if (isinstance(value, memops.api.Implementation.Int.PythonType)):
          pass
        elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
          castValue = memops.api.Implementation.Int.create(value)
          replaceIndex = values.index(value)
          values[replaceIndex] = castValue
          value = castValue
        else:
          raise ApiError("""%s.checkValid: shape:
           memops.Implementation.NonNegativeInt input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (value >= 0)):
          raise ApiError("""%s.checkValid: shape:
           NonNegativeInt constraint int_value_ge_0 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = self.getSize()
      if (value is None):
        raise ApiError("""%s.checkValid: size:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.checkValid: size:
         memops.Implementation.NonNegativeInt input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value >= 0)):
        raise ApiError("""%s.checkValid: size:
         NonNegativeInt constraint int_value_ge_0 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('parameterGroup')
      if (value is not None):
        if (not isinstance(value, ParameterGroup)):
          raise ApiError("""%s.checkValid: parameterGroup:
           value is not of class ccp.nmr.NmrCalc.ParameterGroup""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('data')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: parameterGroup:
           non-reciprocal link parameterGroup from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      value = dataDict.get('run')
      if (not isinstance(value, Run)):
        raise ApiError("""%s.checkValid: run:
         value is not of class ccp.nmr.NmrCalc.Run""" % self.qualifiedName
         + ": %s" % (value,)
        )

      values = dataDict.get('runParameters')
      for value in values:
        if (not isinstance(value, RunParameter)):
          raise ApiError("""%s.checkValid: runParameters:
           value is not of class ccp.nmr.NmrCalc.RunParameter""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('data')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: runParameters:
           non-reciprocal link runParameters from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: runParameters:
           Link runParameters between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    # check explicit class constraints
    # check attributes
    values = dataDict.get('applicationData')
    for value in values:
      value.checkAllValid(complete)

    value = dataDict.get('code')
    values = dataDict.get('data')
    value = dataDict.get('defaultValue')
    if (value is None):
      raise ApiError("""%s.checkValid: defaultValue:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('details')
    value = dataDict.get('ioRole')
    if (value is None):
      raise ApiError("""%s.checkValid: ioRole:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('name')
    values = dataDict.get('shape')
    if (len(values) < 1):
      raise ApiError("""%s.checkValid: shape:
       locard: values must be of length >= 1""" % self.qualifiedName
       + ": %s" % (self,)
      )

    # check roles
    value = dataDict.get('access')
    value = dataDict.get('parameterGroup')
    if (value is not None):
      isValid = True
      obj = self
      while obj is not None:
        obj = obj.parameterGroup
        if obj is self:
          isValid = False
          break
      if (not (isValid)):
        raise ApiError("""%s.checkValid: parameterGroup:
         parameterGroup constraint No_cyclical_parameter_grouping violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    value = dataDict.get('run')
    if (value is None):
      raise ApiError("""%s.checkValid: run:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    values = dataDict.get('runParameters')

  delete = memops.api.Implementation.DataObject.delete

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData

  findAllRunParameters = Data.findAllRunParameters

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData

  findFirstRunParameter = Data.findFirstRunParameter
  
  def get(self, name):
    """
    GetAttr for ccp.nmr.NmrCalc.FloatMatrixData
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccp.nmr.NmrCalc.FloatMatrixData
    """

    result = None
    if (startObj.__class__.__name__ == 'MemopsRoot'):
      if (4 != len(fullKey)):
        raise ApiError("""'ccp.nmr.NmrCalc.FloatMatrixData'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj0 = startObj
      ll = list()
      objKey = fullKey[0]
      ll.append(objKey)
      if (objKey is not None):
        objKey = fullKey[1]
        ll.append(objKey)
        if (objKey is not None):
          objKey = tuple(ll)

      obj1 = obj0.__dict__.get('nmrCalcStores').get(objKey)
      if (obj1 is None):
        obj0.refreshTopObjects('ccp.nmr.NmrCalc')
        obj1 = obj0.__dict__.get('nmrCalcStores').get(objKey)

    else:
      if (2 != len(fullKey)):
        raise ApiError("""'ccp.nmr.NmrCalc.FloatMatrixData'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj1 = startObj

    if (obj1 is not None):
      if (not (obj1.__dict__.get('isLoaded'))):
        obj1.load()

      objKey = fullKey[-2]
      obj2 = obj1.__dict__.get('runs').get(objKey)

      if (obj2 is not None):
        objKey = fullKey[-1]
        obj3 = obj2.__dict__.get('data').get(objKey)
        if (isinstance(obj3, FloatMatrixData)):
          result = obj3

    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation

  getClassName = memops.api.Implementation.ComplexDataType.getClassName

  getCode = Data.getCode
  
  def getData(self):
    """
    Get for ccp.nmr.NmrCalc.FloatMatrixData.data
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('data')
    result = tuple(tempVar)
    return result
  
  def getDefaultValue(self):
    """
    Get for ccp.nmr.NmrCalc.FloatMatrixData.defaultValue
    """
    dataDict = self.__dict__
    result = dataDict.get('defaultValue')
    return result

  getDetails = Data.getDetails

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames

  getFullKey = Data.getFullKey

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor

  getIoRole = Data.getIoRole

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted

  getLocalKey = Data.getLocalKey

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass

  getName = Data.getName
  
  def getNdim(self):
    """
    getter for derived attribute ndim
    """
    dataDict = self.__dict__
    result = len(self.shape)
    return result

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName

  getParameterGroup = Data.getParameterGroup

  getParent = Data.getParent
  
  def getPointValue(self, point):
    """
    get value of matrix at position 'point'. Point is converted as for
    self.pointToIndex.
    """
    dataDict = self.__dict__
    data = self.__dict__['data']
    if data:
      result = data[self.pointToIndex(point)]
    else:
      result = self.defaultValue
    return result

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName

  getRoot = memops.api.Implementation.MemopsObject.getRoot

  getRun = Data.getRun

  getRunParameters = Data.getRunParameters

  getSerial = Data.getSerial
  
  def getShape(self):
    """
    Get for ccp.nmr.NmrCalc.FloatMatrixData.shape
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('shape')
    result = tuple(tempVar)
    return result
  
  def getSize(self):
    """
    getter for derived attribute size
    """
    dataDict = self.__dict__
    import operator
    result = reduce(operator.mul, self.shape)
    return result
  
  def getSubmatrixData(self, point, shape):
    """
    get data (packed linear array)  for submatrix of shape 'shape' with
    'point' as the corner with the smallest index values. point is convered 
    as for self.pointToIndex. 'shape values that are omitted or set to zero 
    are reset to the (rest of the) dimension size.
    """
    dataDict = self.__dict__
    # get starting offset and normalise point -
    # padding with zero and converting to positive indices
    offset = self.pointToIndex(point)
    point = self.indexToPoint(offset)
    
    # set up internal params
    ndim = self.ndim
    sizes = self.shape
    
    # set widths and check
    shape = list(shape)
    if len(shape) > ndim:
      raise ApiError("Number of dimensions %s exceeds ndim %s" % (shape,ndim))
    for ii,width in enumerate(shape):
      if not width:
        shape[ii] = sizes[ii] - point[ii]
      elif width < 0 or width > sizes[ii] - point[ii]:
        raise ApiError("Width %s in dim %s out of permitted range" % (width,ii))
    # Extend shape, padding to dimension sizes.
    shape.extend(sizes[ii] - point[ii] for ii in range(len(shape),ndim))
    
    # set up strides list and lowest dim with continuous data.
    strides = ndim*[0]
    factor = 1
    dodim = 0
    for ii in range(ndim-1,-1,-1):
      strides[ii] = factor
      factor *= shape[ii]
      if not dodim and shape[ii] != sizes[ii]:
        dodim = ii
    size = factor
    
    # length of contiguous stretch
    stretch = strides[dodim] * shape[dodim]
    
    # get hold of data (must bypass API for speed)
    data = self.__dict__['data'] 
    
    if not data:
      # default-only matrix
      result = size*(self.defaultValue,)
    
    else:
    
      if dodim <= 0:
        # take single stretch from 1D array
        result = data[offset:offset+stretch]
      
      else:
        # do work for ndim array
      
        # set up result list (optimisation - could be done with extend instead)
        import operator
        subsize = reduce(operator.mul, shape)
        result = subsize*[None]
      
        # set up multidimensional loop
        vector = (dodim)*[0]
        dim = dim0 = dodim - 1
        target = 0
        while dim >= 0:
        
          # do actual work
          next = target+stretch
          result[target:next] = data[offset:offset+stretch]
          target = next
        
          # update reading offset
          vector[dim] += 1
          if vector[dim] < shape[dim]:
            offset += strides[dim]
            if dim < dim0:
              dim += 1
          else:
            vector[dim] = 0
            dim -=1
      #
      result = tuple(result)
    return result

  getTopObject = memops.api.Implementation.DataObject.getTopObject
  
  def indexToPoint(self, index):
    """
    Converts array index to equivalent point
    """
    dataDict = self.__dict__
    import operator
    shape = self.shape
    if index >= reduce(operator.mul, shape):
      raise ApiError("value %s of index to large for matrix of size %s" % (index, shape))
    if index < 0:
      raise ApiError("Negative value %s of index not allowed" % index)
    result = len(shape) * [None]
    for ii in range(len(shape)-1,-1,-1):
      index,result[ii] = divmod(index,shape[ii])
    result = tuple(result)
    return result
  
  def pointToIndex(self, point):
    """
    converts point to equivalent array index. Point is padded to matrix
    dimension with zeros. negative index values -i in point are treated as 
    eqal to (size-i).
    """
    dataDict = self.__dict__
    shape = self.shape
    lendiff = len(shape) -  len(point)
    if lendiff < 0:
      raise ApiError("Point %s incompatible with %s-dimensional matrix" 
                     % (point,len(shape)))
    elif lendiff:
      point = list(point) + lendiff*[0]
    
    result = 0
    factor = 1
    for ii in range(len(shape)-1,0,-1):   # loop over dimensions in reverse order
      # skipping the first one
      size = shape[ii]
      num,indx = divmod(point[ii],size) # convert -n to width-n
      if num not in (0,-1):
        raise ApiError("Point %s out of range for dimension %s" % (point,ii))
      result += factor * indx
      factor *= size
        
    # treat first dimension differently, because locations beyond the end of
    # the data may be relevant and are certainly defined
    indx = point[0]
    if indx < 0:
      indx += shape[0]
    if indx < 0:
      raise ApiError("Point %s out of range for dimension %s" % (point,0))
    result += factor * indx
    return result

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData

  removeRunParameter = Data.removeRunParameter
  
  def removeSlice(self, index):
    """
    Remove slice of matrix in slowest verying dimension at offset index.
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.removeSlice:
       called on deleted object""" % self.qualifiedName
      )

    data = self.__dict__['data']
    if data:
      start = self.pointToIndex((index,))
      end = self.pointToIndex((index+1,))
      del data[start:end]
    self.__dict__['shape'][0] -= 1
  
  def resetData(self):
    """
    Reset data to default values and free memory used.
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.resetData:
       called on deleted object""" % self.qualifiedName
      )

    del self.__dict__['data'][:]
  
  def set(self, name, value):
    """
    SetAttr for ccp.nmr.NmrCalc.FloatMatrixData
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData

  setCode = Data.setCode
  
  def setData(self, values):
    """
    Set for ccp.nmr.NmrCalc.FloatMatrixData.data
    """
    dataDict = self.__dict__
    values = list(values)
    for value in values:
      if (isinstance(value, memops.api.Implementation.Float.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
        castValue = memops.api.Implementation.Float.create(value)
        replaceIndex = values.index(value)
        values[replaceIndex] = castValue
        value = castValue
      else:
        raise ApiError("""%s.setData:
         memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value - value == 0.0)):
        raise ApiError("""%s.setData:
         Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('data')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setData:
       called on deleted object""" % self.qualifiedName
      )

    if (values == currentValues):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setData:
         cannot set data, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['data'] = values

    # doNotifies
  
  def setDefaultValue(self, value):
    """
    Set for ccp.nmr.NmrCalc.FloatMatrixData.defaultValue
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Float.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Float.create(value)
    else:
      raise ApiError("""%s.setDefaultValue:
       memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value - value == 0.0)):
      raise ApiError("""%s.setDefaultValue:
       Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('defaultValue')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setDefaultValue:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setDefaultValue:
         cannot set defaultValue, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setDefaultValue:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['defaultValue'] = value

    # doNotifies

  setDetails = Data.setDetails

  setIoRole = Data.setIoRole

  setName = Data.setName

  setParameterGroup = Data.setParameterGroup
  
  def setPointValue(self, point, value):
    """
    set value of matrix at position 'point'. Point is converted as for
    self.pointToIndex.
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setPointValue:
       called on deleted object""" % self.qualifiedName
      )

    if not isinstance(value, (float, int)):
      raise ApiError("parameter value %s is not a float" % value)
    data = self.__dict__['data']
    if data:
      data[self.pointToIndex(point)] = value
    elif value != self.defaultValue:
        data.extend(self.size*[self.defaultValue])
        data[self.pointToIndex(point)] = value

  setRunParameters = Data.setRunParameters

  setSerial = Data.setSerial
  
  def setShape(self, values):
    """
    Set for ccp.nmr.NmrCalc.FloatMatrixData.shape
    """
    dataDict = self.__dict__
    values = list(values)
    for value in values:
      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        castValue = memops.api.Implementation.Int.create(value)
        replaceIndex = values.index(value)
        values[replaceIndex] = castValue
        value = castValue
      else:
        raise ApiError("""%s.setShape:
         memops.Implementation.NonNegativeInt input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value >= 0)):
        raise ApiError("""%s.setShape:
         NonNegativeInt constraint int_value_ge_0 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('shape')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setShape:
       called on deleted object""" % self.qualifiedName
      )

    if (values == currentValues):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setShape:
         cannot set shape, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (len(values) < 1):
        raise ApiError("""%s.setShape:
         locard: values must be of length >= 1""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['shape'] = values

    # doNotifies
  
  def setSubmatrixData(self, point, shape, values):
    """
    set data for submatrix of shape 'shape' with 'point' as the corner with
    the smallest index values to 'values' (packed linear array). Point is 
    converted as for self.pointToIndex.  shape values that are omitted or 
    set to zero are reset to the (rest of the) dimension size.
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setSubmatrixData:
       called on deleted object""" % self.qualifiedName
      )

    # get starting offset and normalise point -
    # padding with zero and converting to positive indices
    offset = self.pointToIndex(point)
    point = self.indexToPoint(offset)
    
    # set up internal params
    ndim = self.ndim
    sizes = self.shape
    
    # set widths and check
    shape = list(shape)
    if len(shape) > ndim:
      raise ApiError("Number of submatrix dimensions %s exceeds ndim %s" % (shape,ndim))
    for ii,width in enumerate(shape):
      if not width:
        shape[ii] = sizes[ii] - point[ii]
      elif width < 0 or width > sizes[ii] - point[ii]:
        raise ApiError("Size %s in dim %s out of permitted range" % (width,ii))
    # Extend shape, padding to dimension sizes.
    shape.extend(sizes[ii] - point[ii] for ii in range(len(shape),ndim))
    
    # set up strides list and lowest dim with continuous data.
    strides = ndim*[0]
    factor = 1
    dodim = 0
    for ii in range(ndim-1,-1,-1):
      strides[ii] = factor
      factor *= sizes[ii]
      if not dodim and shape[ii] != sizes[ii]:
        dodim = ii
    
    # length of contiguous stretch
    stretch = strides[dodim] * shape[dodim]
    
    # get hold of data (must bypass API for speed)
    data = self.__dict__['data'] 
    if not data:
      data.extend(self.size*[self.defaultValue])
    
    # check value types
    if [x for x in values if not isinstance(x,(float,int))]:
      raise ApiError("Non-numeric values passed to setSubmatrixData: %s" %  list(set(x for x in values if not isinstance(x,(float,int)))))
    
    if dodim <= 0:
      # set single stretch from 1D array
      data[offset:offset+stretch] =values
      
    else:
      # do work for ndim array
      
      # check length and type of values
      import operator
      subsize = reduce(operator.mul, shape)
      if len(values) != subsize:
        raise ApiError("Number of values %s do not fit submatrix shape %s" % (subsize, shape))
      
      # set up multidimensional loop
      vector = (dodim)*[0]
      dim = dim0 = dodim - 1
      target = 0
      while dim >= 0:
        
        # do actual work
        next = target+stretch
        data[offset:offset+stretch] = values[target:next] 
        target = next
        
        # update reading offset
        vector[dim] += 1
        if vector[dim] < shape[dim]:
          offset += strides[dim]
          if dim < dim0:
            dim += 1
        else:
          vector[dim] = 0
          dim -=1
  
  def sizeFirstDim(self, value):
    """
    Change size in first (slowest) dimension, truncating or padding with
    self.defaultValue as necessary.
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.sizeFirstDim:
       called on deleted object""" % self.qualifiedName
      )

    if value < 0:
      raise ApiError("Dimension size must be non-negative: %s" % value)
    
    shapeList = self.__dict__['shape'] # must bypass API
    lendiff = value - shapeList[0]
    if lendiff:
      data = self.__dict__['data'] # must bypass API
      if data:
        # if data array is empty we have an all-default matrix
        if lendiff > 0:
          data.extend([self.defaultValue]*self.pointToIndex((lendiff,)))
        else:
          # lendiff < 0
          del data[self.pointToIndex((lendiff,)):]
      shapeList[0] = value

  sortedRunParameters = Data.sortedRunParameters

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  applicationData = memops.api.Implementation.DataObject.applicationData

  className = memops.api.Implementation.ComplexDataType.className

  code = Data.code
  
  data = property(getData, setData, None,
  r"""Matrix data as packed list.
  """)
  
  defaultValue = property(getDefaultValue, setDefaultValue, None,
  r"""default value of data in matrix. Used instead of values that are not 
  explicitly set.
  """)

  details = Data.details

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor

  ioRole = Data.ioRole

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted

  metaclass = memops.api.Implementation.ComplexDataType.metaclass

  name = Data.name
  
  ndim = property(getNdim, None, None,
  r"""Number of matrix dimensions
  """)

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName

  serial = Data.serial
  
  shape = property(getShape, setShape, None,
  r"""Matrix shape, slowest moving index first. SIze in first dimension (only) 
  may be zero.
  """)
  
  size = property(getSize, None, None,
  r"""Matrix size - product of dimensions sizes
  """)

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess

  parameterGroup = Data.parameterGroup

  parent = Data.parent

  root = memops.api.Implementation.MemopsObject.root

  run = Data.run

  runParameters = Data.runParameters

  topObject = memops.api.Implementation.DataObject.topObject

###############################################################################
class ParameterGroup(Data):
  r"""Group of parameters that belong together. Could serve e.g. to group 
parameters for successive phases of an annealing protocol.
  """
  #   from data model element ccp.nmr.NmrCalc.ParameterGroup revision ?
  _metaclass = metaPackage.getElement('ParameterGroup')
  _packageName = 'ccp.nmr.NmrCalc'
  _packageShortName = 'CALC'
  _fieldNames = ('applicationData', 'className', 'code', 'details', 'fieldNames', 'inConstructor', 'ioRole', 'isDeleted', 'metaclass', 'name', 'packageName', 'packageShortName', 'qualifiedName', 'serial', 'access', 'activeAccess', 'data', 'parameterGroup', 'parent', 'root', 'run', 'runParameters', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for ccp.nmr.NmrCalc.ParameterGroup
    """
    dataDict = self.__dict__
    dataDict['run'] = parent
    if (not isinstance(parent, Run)):
      raise ApiError("""%s.__init__:
       value is not of class ccp.nmr.NmrCalc.Run""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = parent.__dict__.get('topObject')
    dataDict['topObject'] = topObject

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    if (notIsReading):
      if (not (topObject.__dict__.get('isModifiable'))):
        raise ApiError("""%s.__init__:
         Storage not modifiable""" % self.qualifiedName
         + ": %s" % (topObject,)
        )

    try:

      dataDict['applicationData'] = list()
      dataDict['code'] = None
      dataDict['details'] = None
      dataDict['ioRole'] = 'input'
      dataDict['name'] = None
      dataDict['serial'] = None
      dataDict['access'] = None
      dataDict['data'] = set()
      dataDict['parameterGroup'] = None
      dataDict['runParameters'] = set()

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in ccp.nmr.NmrCalc.ParameterGroup.__init__"
        del dataDict['inConstructor']
        raise

      if (notOverride):
        if (dataDict.get('serial') is None):
          dataDict['inConstructor'] = True
          self.setSerial(-1)
          del dataDict['inConstructor']
        else:
          raise ApiError("""%s.__init__:
           Cannot pass in explicit serial if not reading""" % self.qualifiedName
           + ": %s:%s" % (parent, 'ccp.nmr.NmrCalc.ParameterGroup')
          )

      if (notIsReading):
        childrenDict = parent.__dict__.get('data')
        objKey = dataDict.get('serial')
        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['serial'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notOverride):
        self.checkValid()

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for ccp.nmr.NmrCalc.ParameterGroup:
       determines cascading 
    deletes to follow from delete of object.
       *Implementation function* - 
    should be called only by API delete function.
    """
    dataDict = self.__dict__
    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for ccp.nmr.NmrCalc.ParameterGroup:   deletes
    objects
    *Implementation function* - will CORRUPT DATA if called outside 
    the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    for data in dataDict.get('data'):
      if (not (data in objsToBeDeleted)):
        data.__dict__['parameterGroup'] = None

    parameterGroup = dataDict.get('parameterGroup')
    if ((parameterGroup is not None and not (parameterGroup in objsToBeDeleted))):
      data = parameterGroup.__dict__.get('data')
      data.remove(self)

    for runParameter in dataDict.get('runParameters'):
      if (not (runParameter in objsToBeDeleted)):
        runParameter.__dict__['data'] = None

    run = dataDict.get('run')
    if (not (run in objsToBeDeleted)):
      objKey = dataDict.get('serial')
      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = run.__dict__.get('data')
        if (self is dd.get(objKey)):
          del dd[objKey]

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData
  
  def addData(self, value):
    """
    Add for ccp.nmr.NmrCalc.ParameterGroup.data
    """
    dataDict = self.__dict__
    if (not isinstance(value, Data)):
      raise ApiError("""%s.addData:
       value is not of class ccp.nmr.NmrCalc.Data""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('data')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.addData:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.addData:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.addData:
       called with deleted value""" % self.qualifiedName
      )

    if (value in currentValues):
      raise ApiError("""%s.addData:
       value is in list already""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.addData:
           Link data between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      if (notInConstructor):
        if (value is not None):
          (self, value) = (value, self)
          isValid = True
          obj = self
          while obj is not None:
            obj = obj.parameterGroup
            if obj is self:
              isValid = False
              break
          if (not (isValid)):
            raise ApiError("""%s.addData:
             parameterGroup constraint No_cyclical_parameter_grouping violated by value""" % self.qualifiedName
             + ": %s" % (value,)
            )

          (value, self) = (self, value)

    oldSelf = value.__dict__.get('parameterGroup')
    if (oldSelf is not None):
      siblingValues = oldSelf.__dict__.get('data')
      siblingValues.remove(value)

    value.__dict__['parameterGroup'] = self
    currentValues.add(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('addData')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  addRunParameter = Data.addRunParameter
  
  def checkAllValid(self, complete=False):
    """
    CheckAllValid for ccp.nmr.NmrCalc.ParameterGroup
    """
    dataDict = self.__dict__
    self.checkValid(complete)
  
  def checkValid(self, complete=False):
    """
    CheckValid for ccp.nmr.NmrCalc.ParameterGroup
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      objKey = dataDict.get('serial')
      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('run')
        dd = value.__dict__.get('data')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'run' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      # check attributes
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('code')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: code:
           memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 32):
          raise ApiError("""%s.checkValid: code:
           memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: code:
           memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.split()) == 1)):
          raise ApiError("""%s.checkValid: code:
           Word constraint contains_no_white_space violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('details')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: details:
           memops.Implementation.Text input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 254):
          raise ApiError("""%s.checkValid: details:
           memops.Implementation.Text maximum length is 254 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: details:
           memops.Implementation.Text: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('ioRole')
      if (not (value in ['input', 'output'])):
        raise ApiError("""%s.checkValid: ioRole:
         ccp.nmr.NmrCalc.IoRole input is not in enumeration ['input', 'output']""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.checkValid: ioRole:
         IoRole constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('name')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: name:
           memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: name:
           memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: name:
           memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: name:
           Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('serial')
      if (value is None):
        raise ApiError("""%s.checkValid: serial:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.checkValid: serial:
         memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      values = dataDict.get('data')
      for value in values:
        if (not isinstance(value, Data)):
          raise ApiError("""%s.checkValid: data:
           value is not of class ccp.nmr.NmrCalc.Data""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('parameterGroup')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: data:
           non-reciprocal link data from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: data:
           Link data between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('parameterGroup')
      if (value is not None):
        if (not isinstance(value, ParameterGroup)):
          raise ApiError("""%s.checkValid: parameterGroup:
           value is not of class ccp.nmr.NmrCalc.ParameterGroup""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('data')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: parameterGroup:
           non-reciprocal link parameterGroup from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      value = dataDict.get('run')
      if (not isinstance(value, Run)):
        raise ApiError("""%s.checkValid: run:
         value is not of class ccp.nmr.NmrCalc.Run""" % self.qualifiedName
         + ": %s" % (value,)
        )

      values = dataDict.get('runParameters')
      for value in values:
        if (not isinstance(value, RunParameter)):
          raise ApiError("""%s.checkValid: runParameters:
           value is not of class ccp.nmr.NmrCalc.RunParameter""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('data')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: runParameters:
           non-reciprocal link runParameters from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: runParameters:
           Link runParameters between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    # check explicit class constraints
    # check attributes
    values = dataDict.get('applicationData')
    for value in values:
      value.checkAllValid(complete)

    value = dataDict.get('code')
    value = dataDict.get('details')
    value = dataDict.get('ioRole')
    if (value is None):
      raise ApiError("""%s.checkValid: ioRole:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('name')
    # check roles
    value = dataDict.get('access')
    values = dataDict.get('data')
    for value in values:
      (self, value) = (value, self)
      isValid = True
      obj = self
      while obj is not None:
        obj = obj.parameterGroup
        if obj is self:
          isValid = False
          break
      if (not (isValid)):
        raise ApiError("""%s.checkValid: data:
         parameterGroup constraint No_cyclical_parameter_grouping violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      (value, self) = (self, value)

    value = dataDict.get('parameterGroup')
    if (value is not None):
      isValid = True
      obj = self
      while obj is not None:
        obj = obj.parameterGroup
        if obj is self:
          isValid = False
          break
      if (not (isValid)):
        raise ApiError("""%s.checkValid: parameterGroup:
         parameterGroup constraint No_cyclical_parameter_grouping violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    value = dataDict.get('run')
    if (value is None):
      raise ApiError("""%s.checkValid: run:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    values = dataDict.get('runParameters')

  delete = memops.api.Implementation.DataObject.delete

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData
  
  def findAllData(self, **conditions):
    """
    FindAll for ccp.nmr.NmrCalc.ParameterGroup.data
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('data')
      result = set(currentValues)

    else:
      currentValues = dataDict.get('data')
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('code', 'details', 'ioRole', 'name', 'serial', 'access', 'parameterGroup', 'run',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result

  findAllRunParameters = Data.findAllRunParameters

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData
  
  def findFirstData(self, **conditions):
    """
    FindFirst for ccp.nmr.NmrCalc.ParameterGroup.data
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('data')
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      currentValues = dataDict.get('data')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('code', 'details', 'ioRole', 'name', 'serial', 'access', 'parameterGroup', 'run',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result

  findFirstRunParameter = Data.findFirstRunParameter
  
  def get(self, name):
    """
    GetAttr for ccp.nmr.NmrCalc.ParameterGroup
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccp.nmr.NmrCalc.ParameterGroup
    """

    result = None
    if (startObj.__class__.__name__ == 'MemopsRoot'):
      if (4 != len(fullKey)):
        raise ApiError("""'ccp.nmr.NmrCalc.ParameterGroup'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj0 = startObj
      ll = list()
      objKey = fullKey[0]
      ll.append(objKey)
      if (objKey is not None):
        objKey = fullKey[1]
        ll.append(objKey)
        if (objKey is not None):
          objKey = tuple(ll)

      obj1 = obj0.__dict__.get('nmrCalcStores').get(objKey)
      if (obj1 is None):
        obj0.refreshTopObjects('ccp.nmr.NmrCalc')
        obj1 = obj0.__dict__.get('nmrCalcStores').get(objKey)

    else:
      if (2 != len(fullKey)):
        raise ApiError("""'ccp.nmr.NmrCalc.ParameterGroup'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj1 = startObj

    if (obj1 is not None):
      if (not (obj1.__dict__.get('isLoaded'))):
        obj1.load()

      objKey = fullKey[-2]
      obj2 = obj1.__dict__.get('runs').get(objKey)

      if (obj2 is not None):
        objKey = fullKey[-1]
        obj3 = obj2.__dict__.get('data').get(objKey)
        if (isinstance(obj3, ParameterGroup)):
          result = obj3

    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation

  getClassName = memops.api.Implementation.ComplexDataType.getClassName

  getCode = Data.getCode
  
  def getData(self):
    """
    Get for ccp.nmr.NmrCalc.ParameterGroup.data
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('data')
    result = frozenset(tempVar)
    return result

  getDetails = Data.getDetails

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames

  getFullKey = Data.getFullKey

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor

  getIoRole = Data.getIoRole

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted

  getLocalKey = Data.getLocalKey

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass

  getName = Data.getName

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName

  getParameterGroup = Data.getParameterGroup

  getParent = Data.getParent

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName

  getRoot = memops.api.Implementation.MemopsObject.getRoot

  getRun = Data.getRun

  getRunParameters = Data.getRunParameters

  getSerial = Data.getSerial

  getTopObject = memops.api.Implementation.DataObject.getTopObject

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData
  
  def removeData(self, value):
    """
    Remove for ccp.nmr.NmrCalc.ParameterGroup.data
    """
    dataDict = self.__dict__
    if (not isinstance(value, Data)):
      raise ApiError("""%s.removeData:
       value is not of class ccp.nmr.NmrCalc.Data""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('data')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.removeData:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.removeData:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.removeData:
       called with deleted value""" % self.qualifiedName
      )

    if (not (value in currentValues)):
      raise ApiError("""%s.removeData:
       value not in list""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      pass

    value.__dict__['parameterGroup'] = None
    currentValues.remove(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('removeData')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  removeRunParameter = Data.removeRunParameter
  
  def set(self, name, value):
    """
    SetAttr for ccp.nmr.NmrCalc.ParameterGroup
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData

  setCode = Data.setCode
  
  def setData(self, values):
    """
    Set for ccp.nmr.NmrCalc.ParameterGroup.data
    """
    dataDict = self.__dict__
    xx = values
    values = set(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setData:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      if (not isinstance(value, Data)):
        raise ApiError("""%s.setData:
         value is not of class ccp.nmr.NmrCalc.Data""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('data')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setData:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setData:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setData:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      xx1 = dataDict.get('topObject')
      for value in values:
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setData:
           Link data between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      if (notInConstructor):
        for value in values:
          (self, value) = (value, self)
          isValid = True
          obj = self
          while obj is not None:
            obj = obj.parameterGroup
            if obj is self:
              isValid = False
              break
          if (not (isValid)):
            raise ApiError("""%s.setData:
             parameterGroup constraint No_cyclical_parameter_grouping violated by value""" % self.qualifiedName
             + ": %s" % (value,)
            )

          (value, self) = (self, value)

    for cv in currentValues:
      if (not (cv in values)):
        cv.__dict__['parameterGroup'] = None

    for cv in values:
      if (not (cv in currentValues)):
        oldSelf = cv.__dict__.get('parameterGroup')
        if (oldSelf is not None):
          vv = oldSelf.__dict__.get('data')
          vv.remove(cv)

      cv.__dict__['parameterGroup'] = self

    dataDict['data'] = values
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setData')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  setDetails = Data.setDetails

  setIoRole = Data.setIoRole

  setName = Data.setName

  setParameterGroup = Data.setParameterGroup

  setRunParameters = Data.setRunParameters

  setSerial = Data.setSerial
  
  def sortedData(self):
    """
    Sorted for ccp.nmr.NmrCalc.ParameterGroup.data
    """
    dataDict = self.__dict__
    ll = dataDict.get('data')
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result

  sortedRunParameters = Data.sortedRunParameters

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  applicationData = memops.api.Implementation.DataObject.applicationData

  className = memops.api.Implementation.ComplexDataType.className

  code = Data.code

  details = Data.details

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor

  ioRole = Data.ioRole

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted

  metaclass = memops.api.Implementation.ComplexDataType.metaclass

  name = Data.name

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName

  serial = Data.serial

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess
  
  data = property(getData, setData, None,
  r"""Data that are grouped in ParameterGroup
  """)

  parameterGroup = Data.parameterGroup

  parent = Data.parent

  root = memops.api.Implementation.MemopsObject.root

  run = Data.run

  runParameters = Data.runParameters

  topObject = memops.api.Implementation.DataObject.topObject

###############################################################################
class MolSystemData(Data):
  r"""Molsystem and Chain data for calculations
  """
  #   from data model element ccp.nmr.NmrCalc.MolSystemData revision ?
  _metaclass = metaPackage.getElement('MolSystemData')
  _packageName = 'ccp.nmr.NmrCalc'
  _packageShortName = 'CALC'
  _fieldNames = ('applicationData', 'chainCodes', 'className', 'code', 'details', 'fieldNames', 'inConstructor', 'ioRole', 'isDeleted', 'metaclass', 'molSystemCode', 'name', 'packageName', 'packageShortName', 'qualifiedName', 'serial', 'symmetrySetId', 'access', 'activeAccess', 'chains', 'molSystem', 'parameterGroup', 'parent', 'root', 'run', 'runParameters', 'symmetrySet', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for ccp.nmr.NmrCalc.MolSystemData
    """
    dataDict = self.__dict__
    dataDict['run'] = parent
    if (not isinstance(parent, Run)):
      raise ApiError("""%s.__init__:
       value is not of class ccp.nmr.NmrCalc.Run""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = parent.__dict__.get('topObject')
    dataDict['topObject'] = topObject

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    if (notIsReading):
      if (not (topObject.__dict__.get('isModifiable'))):
        raise ApiError("""%s.__init__:
         Storage not modifiable""" % self.qualifiedName
         + ": %s" % (topObject,)
        )

    try:

      dataDict['applicationData'] = list()
      dataDict['chainCodes'] = list()
      dataDict['code'] = None
      dataDict['details'] = None
      dataDict['ioRole'] = 'input'
      dataDict['molSystemCode'] = None
      dataDict['name'] = None
      dataDict['serial'] = None
      dataDict['symmetrySetId'] = None
      dataDict['access'] = None
      dataDict['parameterGroup'] = None
      dataDict['runParameters'] = set()

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in ccp.nmr.NmrCalc.MolSystemData.__init__"
        del dataDict['inConstructor']
        raise

      if (notOverride):
        if (dataDict.get('serial') is None):
          dataDict['inConstructor'] = True
          self.setSerial(-1)
          del dataDict['inConstructor']
        else:
          raise ApiError("""%s.__init__:
           Cannot pass in explicit serial if not reading""" % self.qualifiedName
           + ": %s:%s" % (parent, 'ccp.nmr.NmrCalc.MolSystemData')
          )

      if (notIsReading):
        childrenDict = parent.__dict__.get('data')
        objKey = dataDict.get('serial')
        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['serial'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notOverride):
        self.checkValid()

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for ccp.nmr.NmrCalc.MolSystemData:
       determines cascading 
    deletes to follow from delete of object.
       *Implementation function* - 
    should be called only by API delete function.
    """
    dataDict = self.__dict__
    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for ccp.nmr.NmrCalc.MolSystemData:   deletes
    objects
    *Implementation function* - will CORRUPT DATA if called outside 
    the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    parameterGroup = dataDict.get('parameterGroup')
    if ((parameterGroup is not None and not (parameterGroup in objsToBeDeleted))):
      data = parameterGroup.__dict__.get('data')
      data.remove(self)

    for runParameter in dataDict.get('runParameters'):
      if (not (runParameter in objsToBeDeleted)):
        runParameter.__dict__['data'] = None

    run = dataDict.get('run')
    if (not (run in objsToBeDeleted)):
      objKey = dataDict.get('serial')
      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = run.__dict__.get('data')
        if (self is dd.get(objKey)):
          del dd[objKey]

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData
  
  def addChain(self, value):
    """
    Add for ccp.nmr.NmrCalc.MolSystemData.chains
    """
    dataDict = self.__dict__
    from ccp.api.molecule.MolSystem import Chain as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.addChain:
       value is not of class ccp.molecule.MolSystem.Chain""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = self.getChains()
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.addChain:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.addChain:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.addChain:
       called with deleted value""" % self.qualifiedName
      )

    if (value in currentValues):
      raise ApiError("""%s.addChain:
       value is in list already""" % self.qualifiedName
       + ": %s" % (self,)
      )

    newValues = list(currentValues)
    newValues.append(value)
    self.setChains(newValues)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

  def addChainCode(self, value):
    """
    Add for ccp.nmr.NmrCalc.MolSystemData.chainCodes
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.addChainCode:
       memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 80):
      raise ApiError("""%s.addChainCode:
       memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.addChainCode:
       memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.splitlines()) <= 1)):
      raise ApiError("""%s.addChainCode:
       Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('chainCodes')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.addChainCode:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.addChainCode:
       called on deleted object""" % self.qualifiedName
      )

    if (value in currentValues):
      raise ApiError("""%s.addChainCode:
       value is in list already""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      pass

    currentValues.append(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('addChainCode')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  addRunParameter = Data.addRunParameter
  
  def checkAllValid(self, complete=False):
    """
    CheckAllValid for ccp.nmr.NmrCalc.MolSystemData
    """
    dataDict = self.__dict__
    self.checkValid(complete)
  
  def checkValid(self, complete=False):
    """
    CheckValid for ccp.nmr.NmrCalc.MolSystemData
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      objKey = dataDict.get('serial')
      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('run')
        dd = value.__dict__.get('data')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'run' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      # check attributes
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      values = dataDict.get('chainCodes')
      for value in values:
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: chainCodes:
           memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: chainCodes:
           memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: chainCodes:
           memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: chainCodes:
           Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('code')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: code:
           memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 32):
          raise ApiError("""%s.checkValid: code:
           memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: code:
           memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.split()) == 1)):
          raise ApiError("""%s.checkValid: code:
           Word constraint contains_no_white_space violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('details')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: details:
           memops.Implementation.Text input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 254):
          raise ApiError("""%s.checkValid: details:
           memops.Implementation.Text maximum length is 254 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: details:
           memops.Implementation.Text: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('ioRole')
      if (not (value in ['input', 'output'])):
        raise ApiError("""%s.checkValid: ioRole:
         ccp.nmr.NmrCalc.IoRole input is not in enumeration ['input', 'output']""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.checkValid: ioRole:
         IoRole constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('molSystemCode')
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: molSystemCode:
         memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 32):
        raise ApiError("""%s.checkValid: molSystemCode:
         memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: molSystemCode:
         memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.checkValid: molSystemCode:
         Word constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('name')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: name:
           memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: name:
           memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: name:
           memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: name:
           Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('serial')
      if (value is None):
        raise ApiError("""%s.checkValid: serial:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.checkValid: serial:
         memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('symmetrySetId')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.Int.PythonType)):
          pass
        elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
          value = memops.api.Implementation.Int.create(value)
        else:
          raise ApiError("""%s.checkValid: symmetrySetId:
           memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      values = self.getChains()
      for value in values:
        from ccp.api.molecule.MolSystem import Chain as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: chains:
           value is not of class ccp.molecule.MolSystem.Chain""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: chains:
           Link chains between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getMolSystem()
      if (value is not None):
        from ccp.api.molecule.MolSystem import MolSystem as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: molSystem:
           value is not of class ccp.molecule.MolSystem.MolSystem""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: molSystem:
           Link molSystem between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('parameterGroup')
      if (value is not None):
        if (not isinstance(value, ParameterGroup)):
          raise ApiError("""%s.checkValid: parameterGroup:
           value is not of class ccp.nmr.NmrCalc.ParameterGroup""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('data')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: parameterGroup:
           non-reciprocal link parameterGroup from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      value = dataDict.get('run')
      if (not isinstance(value, Run)):
        raise ApiError("""%s.checkValid: run:
         value is not of class ccp.nmr.NmrCalc.Run""" % self.qualifiedName
         + ": %s" % (value,)
        )

      values = dataDict.get('runParameters')
      for value in values:
        if (not isinstance(value, RunParameter)):
          raise ApiError("""%s.checkValid: runParameters:
           value is not of class ccp.nmr.NmrCalc.RunParameter""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('data')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: runParameters:
           non-reciprocal link runParameters from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: runParameters:
           Link runParameters between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getSymmetrySet()
      if (value is not None):
        from molsim.api.Symmetry import MolSystemSymmetrySet as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: symmetrySet:
           value is not of class molsim.Symmetry.MolSystemSymmetrySet""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: symmetrySet:
           Link symmetrySet between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    # check explicit class constraints
    # check attributes
    values = dataDict.get('applicationData')
    for value in values:
      value.checkAllValid(complete)

    values = dataDict.get('chainCodes')
    value = dataDict.get('code')
    value = dataDict.get('details')
    value = dataDict.get('ioRole')
    if (value is None):
      raise ApiError("""%s.checkValid: ioRole:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('molSystemCode')
    if (value is None):
      raise ApiError("""%s.checkValid: molSystemCode:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('name')
    value = dataDict.get('symmetrySetId')
    # check roles
    value = dataDict.get('access')
    value = dataDict.get('parameterGroup')
    if (value is not None):
      isValid = True
      obj = self
      while obj is not None:
        obj = obj.parameterGroup
        if obj is self:
          isValid = False
          break
      if (not (isValid)):
        raise ApiError("""%s.checkValid: parameterGroup:
         parameterGroup constraint No_cyclical_parameter_grouping violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    value = dataDict.get('run')
    if (value is None):
      raise ApiError("""%s.checkValid: run:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    values = dataDict.get('runParameters')

  delete = memops.api.Implementation.DataObject.delete

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData
  
  def findAllChains(self, **conditions):
    """
    FindAll for ccp.nmr.NmrCalc.MolSystemData.chains
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = self.getChains()
      result = list(currentValues)

    else:
      currentValues = self.getChains()
      result = list()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('chemExchangeState', 'code', 'conformationalIsomer', 'details', 'magnEquivalenceCode', 'pdbOneLetterCode', 'physicalState', 'role', 'access', 'analysisPanel', 'molSystem', 'molecule',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.append(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.append(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.append(v)

    return result

  findAllRunParameters = Data.findAllRunParameters

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData
  
  def findFirstChain(self, **conditions):
    """
    FindFirst for ccp.nmr.NmrCalc.MolSystemData.chains
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = self.getChains()
      if (currentValues):
        result = currentValues[0]
      else:
        result = None

    else:
      currentValues = self.getChains()
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('chemExchangeState', 'code', 'conformationalIsomer', 'details', 'magnEquivalenceCode', 'pdbOneLetterCode', 'physicalState', 'role', 'access', 'analysisPanel', 'molSystem', 'molecule',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result

  findFirstRunParameter = Data.findFirstRunParameter
  
  def get(self, name):
    """
    GetAttr for ccp.nmr.NmrCalc.MolSystemData
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccp.nmr.NmrCalc.MolSystemData
    """

    result = None
    if (startObj.__class__.__name__ == 'MemopsRoot'):
      if (4 != len(fullKey)):
        raise ApiError("""'ccp.nmr.NmrCalc.MolSystemData'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj0 = startObj
      ll = list()
      objKey = fullKey[0]
      ll.append(objKey)
      if (objKey is not None):
        objKey = fullKey[1]
        ll.append(objKey)
        if (objKey is not None):
          objKey = tuple(ll)

      obj1 = obj0.__dict__.get('nmrCalcStores').get(objKey)
      if (obj1 is None):
        obj0.refreshTopObjects('ccp.nmr.NmrCalc')
        obj1 = obj0.__dict__.get('nmrCalcStores').get(objKey)

    else:
      if (2 != len(fullKey)):
        raise ApiError("""'ccp.nmr.NmrCalc.MolSystemData'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj1 = startObj

    if (obj1 is not None):
      if (not (obj1.__dict__.get('isLoaded'))):
        obj1.load()

      objKey = fullKey[-2]
      obj2 = obj1.__dict__.get('runs').get(objKey)

      if (obj2 is not None):
        objKey = fullKey[-1]
        obj3 = obj2.__dict__.get('data').get(objKey)
        if (isinstance(obj3, MolSystemData)):
          result = obj3

    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation
  
  def getChainCodes(self):
    """
    Get for ccp.nmr.NmrCalc.MolSystemData.chainCodes
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('chainCodes')
    result = tuple(tempVar)
    return result
  
  def getChains(self):
    """
    getter for derived link chains
    """
    dataDict = self.__dict__
    molSystem = self.root.findFirstMolSystem(code=self.molSystemCode)
    if molSystem:
      chainCodes = self.chainCodes
      if chainCodes:
        result = tuple(molSystem.findFirstChain(code=x) for x in chainCodes)
        if None in result:
          result = tuple()
      else:
        result = tuple(molSystem.sortedChains())
    else:
      result = tuple()
    return result

  getClassName = memops.api.Implementation.ComplexDataType.getClassName

  getCode = Data.getCode

  getDetails = Data.getDetails

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames

  getFullKey = Data.getFullKey

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor

  getIoRole = Data.getIoRole

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted

  getLocalKey = Data.getLocalKey

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass
  
  def getMolSystem(self):
    """
    getter for derived link molSystem
    """
    dataDict = self.__dict__
    result = self.root.findFirstMolSystem(code=self.molSystemCode)
    return result
  
  def getMolSystemCode(self):
    """
    Get for ccp.nmr.NmrCalc.MolSystemData.molSystemCode
    """
    dataDict = self.__dict__
    result = dataDict.get('molSystemCode')
    return result

  getName = Data.getName

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName

  getParameterGroup = Data.getParameterGroup

  getParent = Data.getParent

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName

  getRoot = memops.api.Implementation.MemopsObject.getRoot

  getRun = Data.getRun

  getRunParameters = Data.getRunParameters

  getSerial = Data.getSerial
  
  def getSymmetrySet(self):
    """
    getter for derived link symmetrySet
    """
    dataDict = self.__dict__
    result = self.root.findFirstMolSystemSymmetrySet(symmetrySetId=self.symmetrySetId, molSystem=self.molSystem)
    return result
  
  def getSymmetrySetId(self):
    """
    Get for ccp.nmr.NmrCalc.MolSystemData.symmetrySetId
    """
    dataDict = self.__dict__
    result = dataDict.get('symmetrySetId')
    return result

  getTopObject = memops.api.Implementation.DataObject.getTopObject

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData
  
  def removeChain(self, value):
    """
    Remove for ccp.nmr.NmrCalc.MolSystemData.chains
    """
    dataDict = self.__dict__
    from ccp.api.molecule.MolSystem import Chain as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.removeChain:
       value is not of class ccp.molecule.MolSystem.Chain""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = self.getChains()
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.removeChain:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.removeChain:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.removeChain:
       called with deleted value""" % self.qualifiedName
      )

    if (not (value in currentValues)):
      raise ApiError("""%s.removeChain:
       value not in list""" % self.qualifiedName
       + ": %s" % (self,)
      )

    newValues = list(currentValues)
    newValues.remove(value)
    self.setChains(newValues)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

  def removeChainCode(self, value):
    """
    Remove for ccp.nmr.NmrCalc.MolSystemData.chainCodes
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.removeChainCode:
       memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 80):
      raise ApiError("""%s.removeChainCode:
       memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.removeChainCode:
       memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.splitlines()) <= 1)):
      raise ApiError("""%s.removeChainCode:
       Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('chainCodes')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.removeChainCode:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.removeChainCode:
       called on deleted object""" % self.qualifiedName
      )

    if (not (value in currentValues)):
      raise ApiError("""%s.removeChainCode:
       value not in list""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      pass

    currentValues.remove(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('removeChainCode')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  removeRunParameter = Data.removeRunParameter
  
  def set(self, name, value):
    """
    SetAttr for ccp.nmr.NmrCalc.MolSystemData
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData
  
  def setChainCodes(self, values):
    """
    Set for ccp.nmr.NmrCalc.MolSystemData.chainCodes
    """
    dataDict = self.__dict__
    xx = set(values)
    values = list(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setChainCodes:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setChainCodes:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.setChainCodes:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setChainCodes:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.setChainCodes:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('chainCodes')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setChainCodes:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setChainCodes:
       called on deleted object""" % self.qualifiedName
      )

    if (values == currentValues):
      return

    if (notOverride):
      pass

    dataDict['chainCodes'] = values
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setChainCodes')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setChains(self, values):
    """
    setter for derived link chains
    """
    dataDict = self.__dict__
    xx = set(values)
    values = list(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setChains:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      from ccp.api.molecule.MolSystem import Chain as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setChains:
         value is not of class ccp.molecule.MolSystem.Chain""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValues = self.getChains()
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setChains:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setChains:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setChains:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if values:
      molSystems = set(x.molSystem for x in values)
      if len(molSystems) == 1:
        molSystemCode = molSystems.pop().code
        if self.molSystemCode != molSystemCode:
          self.molSystemCode = molSystemCode
          self.symmetrySetId = None
        self.chainCodes = [x.code for x in values]
      else:
        raise ApiError("Chains are from different MolSystems: %s" % values)
    else:
      self.chainCodes = ()
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

  setCode = Data.setCode

  setDetails = Data.setDetails

  setIoRole = Data.setIoRole
  
  def setMolSystem(self, value):
    """
    setter for derived link molSystem
    """
    dataDict = self.__dict__
    if (value is not None):
      from ccp.api.molecule.MolSystem import MolSystem as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setMolSystem:
         value is not of class ccp.molecule.MolSystem.MolSystem""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = self.getMolSystem()
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setMolSystem:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setMolSystem:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setMolSystem:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if self.molSystemCode != value.code:
      self.molSystemCode = value.code
      self.chainCodes = ()
      self.symmetrySetId = None
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

  def setMolSystemCode(self, value):
    """
    Set for ccp.nmr.NmrCalc.MolSystemData.molSystemCode
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.setMolSystemCode:
       memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 32):
      raise ApiError("""%s.setMolSystemCode:
       memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.setMolSystemCode:
       memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.split()) == 1)):
      raise ApiError("""%s.setMolSystemCode:
       Word constraint contains_no_white_space violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('molSystemCode')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setMolSystemCode:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setMolSystemCode:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setMolSystemCode:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['molSystemCode'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setMolSystemCode')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  setName = Data.setName

  setParameterGroup = Data.setParameterGroup

  setRunParameters = Data.setRunParameters

  setSerial = Data.setSerial
  
  def setSymmetrySet(self, value):
    """
    setter for derived link symmetrySet
    """
    dataDict = self.__dict__
    if (value is not None):
      from molsim.api.Symmetry import MolSystemSymmetrySet as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setSymmetrySet:
         value is not of class molsim.Symmetry.MolSystemSymmetrySet""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = self.getSymmetrySet()
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setSymmetrySet:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setSymmetrySet:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setSymmetrySet:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if value is None:
      self.symmetrySetId = None
    elif value.molSystem is self.molSystem:
      self.symmetrySetId = value.symmetrySetId
    else:
      raise ApiError("%s does not belong to MolSystem %s" % (value, self.molSystem ))
    
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

  def setSymmetrySetId(self, value):
    """
    Set for ccp.nmr.NmrCalc.MolSystemData.symmetrySetId
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.setSymmetrySetId:
         memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('symmetrySetId')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setSymmetrySetId:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setSymmetrySetId:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['symmetrySetId'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setSymmetrySetId')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  sortedRunParameters = Data.sortedRunParameters

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  applicationData = memops.api.Implementation.DataObject.applicationData
  
  chainCodes = property(getChainCodes, setChainCodes, None,
  r"""Chain Codes - if empty all chains in MolSystem are used. Used for 
  deriving link
  """)

  className = memops.api.Implementation.ComplexDataType.className

  code = Data.code

  details = Data.details

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor

  ioRole = Data.ioRole

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted

  metaclass = memops.api.Implementation.ComplexDataType.metaclass
  
  molSystemCode = property(getMolSystemCode, setMolSystemCode, None,
  r"""code for MolSystem - used for derivation of link
  """)

  name = Data.name

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName

  serial = Data.serial
  
  symmetrySetId = property(getSymmetrySetId, setSymmetrySetId, None,
  r"""Key for molsim.Symmetry.MosSystemSymmetrySet.- used to derive the actual 
  object
  """)

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess
  
  chains = property(getChains, setChains, None,
  r"""MolSystem.Chains used as data
  """)
  
  molSystem = property(getMolSystem, setMolSystem, None,
  r"""MolSystem used in data
  """)

  parameterGroup = Data.parameterGroup

  parent = Data.parent

  root = memops.api.Implementation.MemopsObject.root

  run = Data.run

  runParameters = Data.runParameters
  
  symmetrySet = property(getSymmetrySet, setSymmetrySet, None,
  r"""SymmetrySet that defines symmetry of MolSystem
  """)

  topObject = memops.api.Implementation.DataObject.topObject

###############################################################################
class MolResidueData(Data):
  r"""MolSystem.Residue data for calculations
  """
  #   from data model element ccp.nmr.NmrCalc.MolResidueData revision ?
  _metaclass = metaPackage.getElement('MolResidueData')
  _packageName = 'ccp.nmr.NmrCalc'
  _packageShortName = 'CALC'
  _fieldNames = ('applicationData', 'chainCode', 'chainCodes', 'className', 'code', 'details', 'fieldNames', 'inConstructor', 'ioRole', 'isDeleted', 'metaclass', 'molSystemCode', 'name', 'packageName', 'packageShortName', 'qualifiedName', 'residueSeqIds', 'serial', 'access', 'activeAccess', 'chain', 'chains', 'molSystem', 'parameterGroup', 'parent', 'residues', 'root', 'run', 'runParameters', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for ccp.nmr.NmrCalc.MolResidueData
    """
    dataDict = self.__dict__
    dataDict['run'] = parent
    if (not isinstance(parent, Run)):
      raise ApiError("""%s.__init__:
       value is not of class ccp.nmr.NmrCalc.Run""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = parent.__dict__.get('topObject')
    dataDict['topObject'] = topObject

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    if (notIsReading):
      if (not (topObject.__dict__.get('isModifiable'))):
        raise ApiError("""%s.__init__:
         Storage not modifiable""" % self.qualifiedName
         + ": %s" % (topObject,)
        )

    try:

      dataDict['applicationData'] = list()
      dataDict['chainCodes'] = list()
      dataDict['code'] = None
      dataDict['details'] = None
      dataDict['ioRole'] = 'input'
      dataDict['molSystemCode'] = None
      dataDict['name'] = None
      dataDict['residueSeqIds'] = list()
      dataDict['serial'] = None
      dataDict['access'] = None
      dataDict['parameterGroup'] = None
      dataDict['runParameters'] = set()

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in ccp.nmr.NmrCalc.MolResidueData.__init__"
        del dataDict['inConstructor']
        raise

      if (notOverride):
        if (dataDict.get('serial') is None):
          dataDict['inConstructor'] = True
          self.setSerial(-1)
          del dataDict['inConstructor']
        else:
          raise ApiError("""%s.__init__:
           Cannot pass in explicit serial if not reading""" % self.qualifiedName
           + ": %s:%s" % (parent, 'ccp.nmr.NmrCalc.MolResidueData')
          )

      if (notIsReading):
        childrenDict = parent.__dict__.get('data')
        objKey = dataDict.get('serial')
        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['serial'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notOverride):
        self.checkValid()

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for ccp.nmr.NmrCalc.MolResidueData:
       determines cascading 
    deletes to follow from delete of object.
       *Implementation function* - 
    should be called only by API delete function.
    """
    dataDict = self.__dict__
    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for ccp.nmr.NmrCalc.MolResidueData:   deletes
    objects
    *Implementation function* - will CORRUPT DATA if called outside 
    the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    parameterGroup = dataDict.get('parameterGroup')
    if ((parameterGroup is not None and not (parameterGroup in objsToBeDeleted))):
      data = parameterGroup.__dict__.get('data')
      data.remove(self)

    for runParameter in dataDict.get('runParameters'):
      if (not (runParameter in objsToBeDeleted)):
        runParameter.__dict__['data'] = None

    run = dataDict.get('run')
    if (not (run in objsToBeDeleted)):
      objKey = dataDict.get('serial')
      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = run.__dict__.get('data')
        if (self is dd.get(objKey)):
          del dd[objKey]

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData
  
  def addChain(self, value):
    """
    Add for ccp.nmr.NmrCalc.MolResidueData.chains
    """
    dataDict = self.__dict__
    from ccp.api.molecule.MolSystem import Chain as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.addChain:
       value is not of class ccp.molecule.MolSystem.Chain""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = self.getChains()
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.addChain:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.addChain:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.addChain:
       called with deleted value""" % self.qualifiedName
      )

    if (value in currentValues):
      raise ApiError("""%s.addChain:
       value is in list already""" % self.qualifiedName
       + ": %s" % (self,)
      )

    newValues = list(currentValues)
    newValues.append(value)
    self.setChains(newValues)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

  def addResidue(self, value):
    """
    Add for ccp.nmr.NmrCalc.MolResidueData.residues
    """
    dataDict = self.__dict__
    from ccp.api.molecule.MolSystem import Residue as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.addResidue:
       value is not of class ccp.molecule.MolSystem.Residue""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = self.getResidues()
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.addResidue:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.addResidue:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.addResidue:
       called with deleted value""" % self.qualifiedName
      )

    if (value in currentValues):
      raise ApiError("""%s.addResidue:
       value is in list already""" % self.qualifiedName
       + ": %s" % (self,)
      )

    newValues = set(currentValues)
    newValues.add(value)
    self.setResidues(newValues)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

  def addResidueSeqId(self, value):
    """
    Add for ccp.nmr.NmrCalc.MolResidueData.residueSeqIds
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Int.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Int.create(value)
    else:
      raise ApiError("""%s.addResidueSeqId:
       memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('residueSeqIds')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.addResidueSeqId:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.addResidueSeqId:
       called on deleted object""" % self.qualifiedName
      )

    if (notOverride):
      if (notInConstructor):
        if (value is not None):
          if (not (len(self.chainCodes) in (1,len(values)))):
            raise ApiError("""%s.addResidueSeqId:
             residueSeqIds constraint Either_single_chain_code_or_residueSeqIds_match_chainCodes_one_to_one violated by value""" % self.qualifiedName
             + ": %s" % (value,)
            )

    currentValues.append(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('addResidueSeqId')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  addRunParameter = Data.addRunParameter
  
  def checkAllValid(self, complete=False):
    """
    CheckAllValid for ccp.nmr.NmrCalc.MolResidueData
    """
    dataDict = self.__dict__
    self.checkValid(complete)
  
  def checkValid(self, complete=False):
    """
    CheckValid for ccp.nmr.NmrCalc.MolResidueData
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      objKey = dataDict.get('serial')
      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('run')
        dd = value.__dict__.get('data')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'run' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      # check attributes
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = self.getChainCode()
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: chainCode:
           memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: chainCode:
           memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: chainCode:
           memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: chainCode:
           Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      values = dataDict.get('chainCodes')
      for value in values:
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: chainCodes:
           memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: chainCodes:
           memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: chainCodes:
           memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: chainCodes:
           Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('code')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: code:
           memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 32):
          raise ApiError("""%s.checkValid: code:
           memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: code:
           memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.split()) == 1)):
          raise ApiError("""%s.checkValid: code:
           Word constraint contains_no_white_space violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('details')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: details:
           memops.Implementation.Text input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 254):
          raise ApiError("""%s.checkValid: details:
           memops.Implementation.Text maximum length is 254 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: details:
           memops.Implementation.Text: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('ioRole')
      if (not (value in ['input', 'output'])):
        raise ApiError("""%s.checkValid: ioRole:
         ccp.nmr.NmrCalc.IoRole input is not in enumeration ['input', 'output']""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.checkValid: ioRole:
         IoRole constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('molSystemCode')
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: molSystemCode:
         memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 32):
        raise ApiError("""%s.checkValid: molSystemCode:
         memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: molSystemCode:
         memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.checkValid: molSystemCode:
         Word constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('name')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: name:
           memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: name:
           memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: name:
           memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: name:
           Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      values = dataDict.get('residueSeqIds')
      for value in values:
        if (isinstance(value, memops.api.Implementation.Int.PythonType)):
          pass
        elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
          castValue = memops.api.Implementation.Int.create(value)
          replaceIndex = values.index(value)
          values[replaceIndex] = castValue
          value = castValue
        else:
          raise ApiError("""%s.checkValid: residueSeqIds:
           memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('serial')
      if (value is None):
        raise ApiError("""%s.checkValid: serial:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.checkValid: serial:
         memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getChain()
      if (value is not None):
        from ccp.api.molecule.MolSystem import Chain as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: chain:
           value is not of class ccp.molecule.MolSystem.Chain""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: chain:
           Link chain between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      values = self.getChains()
      for value in values:
        from ccp.api.molecule.MolSystem import Chain as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: chains:
           value is not of class ccp.molecule.MolSystem.Chain""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: chains:
           Link chains between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getMolSystem()
      if (value is not None):
        from ccp.api.molecule.MolSystem import MolSystem as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: molSystem:
           value is not of class ccp.molecule.MolSystem.MolSystem""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: molSystem:
           Link molSystem between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('parameterGroup')
      if (value is not None):
        if (not isinstance(value, ParameterGroup)):
          raise ApiError("""%s.checkValid: parameterGroup:
           value is not of class ccp.nmr.NmrCalc.ParameterGroup""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('data')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: parameterGroup:
           non-reciprocal link parameterGroup from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      values = self.getResidues()
      for value in values:
        from ccp.api.molecule.MolSystem import Residue as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: residues:
           value is not of class ccp.molecule.MolSystem.Residue""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: residues:
           Link residues between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('run')
      if (not isinstance(value, Run)):
        raise ApiError("""%s.checkValid: run:
         value is not of class ccp.nmr.NmrCalc.Run""" % self.qualifiedName
         + ": %s" % (value,)
        )

      values = dataDict.get('runParameters')
      for value in values:
        if (not isinstance(value, RunParameter)):
          raise ApiError("""%s.checkValid: runParameters:
           value is not of class ccp.nmr.NmrCalc.RunParameter""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('data')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: runParameters:
           non-reciprocal link runParameters from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: runParameters:
           Link runParameters between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    # check explicit class constraints
    # check attributes
    values = dataDict.get('applicationData')
    for value in values:
      value.checkAllValid(complete)

    values = dataDict.get('chainCodes')
    if (len(values) < 1):
      raise ApiError("""%s.checkValid: chainCodes:
       locard: values must be of length >= 1""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('code')
    value = dataDict.get('details')
    value = dataDict.get('ioRole')
    if (value is None):
      raise ApiError("""%s.checkValid: ioRole:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('molSystemCode')
    if (value is None):
      raise ApiError("""%s.checkValid: molSystemCode:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('name')
    values = dataDict.get('residueSeqIds')
    for value in values:
      if (not (len(self.chainCodes) in (1,len(values)))):
        raise ApiError("""%s.checkValid: residueSeqIds:
         residueSeqIds constraint Either_single_chain_code_or_residueSeqIds_match_chainCodes_one_to_one violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    # check roles
    value = dataDict.get('access')
    value = dataDict.get('parameterGroup')
    if (value is not None):
      isValid = True
      obj = self
      while obj is not None:
        obj = obj.parameterGroup
        if obj is self:
          isValid = False
          break
      if (not (isValid)):
        raise ApiError("""%s.checkValid: parameterGroup:
         parameterGroup constraint No_cyclical_parameter_grouping violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    value = dataDict.get('run')
    if (value is None):
      raise ApiError("""%s.checkValid: run:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    values = dataDict.get('runParameters')

  delete = memops.api.Implementation.DataObject.delete

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData
  
  def findAllChains(self, **conditions):
    """
    FindAll for ccp.nmr.NmrCalc.MolResidueData.chains
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = self.getChains()
      result = list(currentValues)

    else:
      currentValues = self.getChains()
      result = list()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('chemExchangeState', 'code', 'conformationalIsomer', 'details', 'magnEquivalenceCode', 'pdbOneLetterCode', 'physicalState', 'role', 'access', 'analysisPanel', 'molSystem', 'molecule',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.append(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.append(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.append(v)

    return result
  
  def findAllResidues(self, **conditions):
    """
    FindAll for ccp.nmr.NmrCalc.MolResidueData.residues
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = self.getResidues()
      result = set(currentValues)

    else:
      currentValues = self.getResidues()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('descriptor', 'details', 'linking', 'seqCode', 'seqId', 'seqInsertCode', 'access', 'chain', 'chainFragment',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result

  findAllRunParameters = Data.findAllRunParameters

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData
  
  def findFirstChain(self, **conditions):
    """
    FindFirst for ccp.nmr.NmrCalc.MolResidueData.chains
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = self.getChains()
      if (currentValues):
        result = currentValues[0]
      else:
        result = None

    else:
      currentValues = self.getChains()
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('chemExchangeState', 'code', 'conformationalIsomer', 'details', 'magnEquivalenceCode', 'pdbOneLetterCode', 'physicalState', 'role', 'access', 'analysisPanel', 'molSystem', 'molecule',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstResidue(self, **conditions):
    """
    FindFirst for ccp.nmr.NmrCalc.MolResidueData.residues
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = self.getResidues()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      currentValues = self.getResidues()
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('descriptor', 'details', 'linking', 'seqCode', 'seqId', 'seqInsertCode', 'access', 'chain', 'chainFragment',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result

  findFirstRunParameter = Data.findFirstRunParameter
  
  def get(self, name):
    """
    GetAttr for ccp.nmr.NmrCalc.MolResidueData
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccp.nmr.NmrCalc.MolResidueData
    """

    result = None
    if (startObj.__class__.__name__ == 'MemopsRoot'):
      if (4 != len(fullKey)):
        raise ApiError("""'ccp.nmr.NmrCalc.MolResidueData'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj0 = startObj
      ll = list()
      objKey = fullKey[0]
      ll.append(objKey)
      if (objKey is not None):
        objKey = fullKey[1]
        ll.append(objKey)
        if (objKey is not None):
          objKey = tuple(ll)

      obj1 = obj0.__dict__.get('nmrCalcStores').get(objKey)
      if (obj1 is None):
        obj0.refreshTopObjects('ccp.nmr.NmrCalc')
        obj1 = obj0.__dict__.get('nmrCalcStores').get(objKey)

    else:
      if (2 != len(fullKey)):
        raise ApiError("""'ccp.nmr.NmrCalc.MolResidueData'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj1 = startObj

    if (obj1 is not None):
      if (not (obj1.__dict__.get('isLoaded'))):
        obj1.load()

      objKey = fullKey[-2]
      obj2 = obj1.__dict__.get('runs').get(objKey)

      if (obj2 is not None):
        objKey = fullKey[-1]
        obj3 = obj2.__dict__.get('data').get(objKey)
        if (isinstance(obj3, MolResidueData)):
          result = obj3

    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation
  
  def getChain(self):
    """
    getter for derived link chain
    """
    dataDict = self.__dict__
    result = self.getByNavigation('root', ('molSystems', self.molSystemCode), ('chains', self.chainCode))
    return result
  
  def getChainCode(self):
    """
    getter for derived attribute chainCode
    """
    dataDict = self.__dict__
    chainCodes = self.chainCodes
    if len(chainCodes) == 1:
      result = chainCodes[0]
    else:
      result = None
    return result
  
  def getChainCodes(self):
    """
    Get for ccp.nmr.NmrCalc.MolResidueData.chainCodes
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('chainCodes')
    result = tuple(tempVar)
    return result
  
  def getChains(self):
    """
    getter for derived link chains
    """
    dataDict = self.__dict__
    molSystem = self.molSystem
    if molSystem is None:
      result =  tuple()
    else:
      result = tuple(molSystem.findFirstChain(code=x) for x in set(self.chainCodes))
      if None in result:
        result = tuple()
    
    return result

  getClassName = memops.api.Implementation.ComplexDataType.getClassName

  getCode = Data.getCode

  getDetails = Data.getDetails

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames

  getFullKey = Data.getFullKey

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor

  getIoRole = Data.getIoRole

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted

  getLocalKey = Data.getLocalKey

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass
  
  def getMolSystem(self):
    """
    getter for derived link MolSystem
    """
    dataDict = self.__dict__
    result = self.root.findFirstMolSystem(code=self.molSystemCode)
    return result
  
  def getMolSystemCode(self):
    """
    Get for ccp.nmr.NmrCalc.MolResidueData.molSystemCode
    """
    dataDict = self.__dict__
    result = dataDict.get('molSystemCode')
    return result

  getName = Data.getName

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName

  getParameterGroup = Data.getParameterGroup

  getParent = Data.getParent

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName
  
  def getResidueSeqIds(self):
    """
    Get for ccp.nmr.NmrCalc.MolResidueData.residueSeqIds
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('residueSeqIds')
    result = tuple(tempVar)
    return result
  
  def getResidues(self):
    """
    getter for derived link residues
    """
    dataDict = self.__dict__
    chain = self.chain
    if chain is None:
      molSystem = self.molSystem
      if molSystem is None:
        result = tuple()
      else:
        residueSeqIds = self.residueSeqIds
        result = tuple(molSystem.getByNavigation(('chains',x), ('residues', residueSeqIds[ii])) for ii,x in enumerate(self.chainCodes))
    elif self.residueSeqIds:
      result = tuple(chain.findFirstResidue(seqId=x) for x in self.residueSeqIds)
    else:
      result = chain.sortedResidues()
    if None in result:
      result = tuple()
    return result

  getRoot = memops.api.Implementation.MemopsObject.getRoot

  getRun = Data.getRun

  getRunParameters = Data.getRunParameters

  getSerial = Data.getSerial

  getTopObject = memops.api.Implementation.DataObject.getTopObject

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData
  
  def removeChain(self, value):
    """
    Remove for ccp.nmr.NmrCalc.MolResidueData.chains
    """
    dataDict = self.__dict__
    from ccp.api.molecule.MolSystem import Chain as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.removeChain:
       value is not of class ccp.molecule.MolSystem.Chain""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = self.getChains()
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.removeChain:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.removeChain:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.removeChain:
       called with deleted value""" % self.qualifiedName
      )

    if (not (value in currentValues)):
      raise ApiError("""%s.removeChain:
       value not in list""" % self.qualifiedName
       + ": %s" % (self,)
      )

    newValues = list(currentValues)
    newValues.remove(value)
    self.setChains(newValues)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

  def removeResidue(self, value):
    """
    Remove for ccp.nmr.NmrCalc.MolResidueData.residues
    """
    dataDict = self.__dict__
    from ccp.api.molecule.MolSystem import Residue as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.removeResidue:
       value is not of class ccp.molecule.MolSystem.Residue""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = self.getResidues()
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.removeResidue:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.removeResidue:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.removeResidue:
       called with deleted value""" % self.qualifiedName
      )

    if (not (value in currentValues)):
      raise ApiError("""%s.removeResidue:
       value not in list""" % self.qualifiedName
       + ": %s" % (self,)
      )

    newValues = set(currentValues)
    newValues.remove(value)
    self.setResidues(newValues)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

  def removeResidueSeqId(self, value):
    """
    Remove for ccp.nmr.NmrCalc.MolResidueData.residueSeqIds
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Int.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Int.create(value)
    else:
      raise ApiError("""%s.removeResidueSeqId:
       memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('residueSeqIds')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.removeResidueSeqId:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.removeResidueSeqId:
       called on deleted object""" % self.qualifiedName
      )

    if (not (value in currentValues)):
      raise ApiError("""%s.removeResidueSeqId:
       value not in list""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      pass

    currentValues.remove(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('removeResidueSeqId')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  removeRunParameter = Data.removeRunParameter
  
  def set(self, name, value):
    """
    SetAttr for ccp.nmr.NmrCalc.MolResidueData
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData
  
  def setChain(self, value):
    """
    setter for derived link chain
    """
    dataDict = self.__dict__
    if (value is not None):
      from ccp.api.molecule.MolSystem import Chain as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setChain:
         value is not of class ccp.molecule.MolSystem.Chain""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = self.getChain()
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setChain:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setChain:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setChain:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if value is None:
      raise ApiError("MolResidueData.chain can not be set to None")
    else:
      molSystemCode = value.molSystem.code
      chainCode = value.code
      if self.molSystemCode != molSystemCode or self.chainCode != value.code:
          self.chainCode = chainCode
          self.molSystemCode = molSystemCode
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

  def setChainCode(self, value):
    """
    setter for derived attribute chainCode
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setChainCode:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.setChainCode:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setChainCode:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.setChainCode:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = self.getChainCode()
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setChainCode:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setChainCode:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if value is None:
      raise ApiError("MolResidueData.chain can not be set to None")
    elif value != self.chainCode :
      wasOverride = self.root.override
      self.root.override = True
      try:
        self.chainCodes = [value]
        if not self.inConstructor:
          self.residueSeqIds = []
      finally:
        self.root.override = wasOverride
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

  def setChainCodes(self, values):
    """
    Set for ccp.nmr.NmrCalc.MolResidueData.chainCodes
    """
    dataDict = self.__dict__
    values = list(values)
    for value in values:
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setChainCodes:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.setChainCodes:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setChainCodes:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.setChainCodes:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('chainCodes')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setChainCodes:
       called on deleted object""" % self.qualifiedName
      )

    if (values == currentValues):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setChainCodes:
         cannot set chainCodes, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (len(values) < 1):
        raise ApiError("""%s.setChainCodes:
         locard: values must be of length >= 1""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['chainCodes'] = values

    # doNotifies
  
  def setChains(self, values):
    """
    setter for derived link chains
    """
    dataDict = self.__dict__
    xx = set(values)
    values = list(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setChains:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      from ccp.api.molecule.MolSystem import Chain as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setChains:
         value is not of class ccp.molecule.MolSystem.Chain""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValues = self.getChains()
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setChains:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setChains:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setChains:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if len(values) == 1:
      self.setChain(list(values).pop())
    elif values:
      molSystems = set(x.molSystem for x in values)
      if len(molSystems) == 1:
        molSystemCode = molSystems.pop().code
        self.molSystemCode = molSystemCode
        chainCodes = []
        residueSeqIds = []
        for chain in values:
          residues = chain.sortedResidues()
          chainCodes.extend(len(residues)*[chain.code])
          residues.extend(x.seqId for x in residues)
        wasOverride = self.root.override
        self.root.override = True
        try:
          self.chainCodes = chainCodes
          self.molSystemCode = molSystemCode
          self.residueSeqIds = residueSeqIds
        finally:
          self.root.override = wasOverride
      else:
        raise ApiError("Chains are from different MolSystems: %s" % values)
    else:
      raise ApiError("MolResidueData.chains can not be set to empty")
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

  setCode = Data.setCode

  setDetails = Data.setDetails

  setIoRole = Data.setIoRole
  
  def setMolSystemCode(self, value):
    """
    Set for ccp.nmr.NmrCalc.MolResidueData.molSystemCode
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.setMolSystemCode:
       memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 32):
      raise ApiError("""%s.setMolSystemCode:
       memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.setMolSystemCode:
       memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.split()) == 1)):
      raise ApiError("""%s.setMolSystemCode:
       Word constraint contains_no_white_space violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('molSystemCode')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setMolSystemCode:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setMolSystemCode:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setMolSystemCode:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['molSystemCode'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setMolSystemCode')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  setName = Data.setName

  setParameterGroup = Data.setParameterGroup
  
  def setResidueSeqIds(self, values):
    """
    Set for ccp.nmr.NmrCalc.MolResidueData.residueSeqIds
    """
    dataDict = self.__dict__
    values = list(values)
    for value in values:
      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        castValue = memops.api.Implementation.Int.create(value)
        replaceIndex = values.index(value)
        values[replaceIndex] = castValue
        value = castValue
      else:
        raise ApiError("""%s.setResidueSeqIds:
         memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('residueSeqIds')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setResidueSeqIds:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setResidueSeqIds:
       called on deleted object""" % self.qualifiedName
      )

    if (values == currentValues):
      return

    if (notOverride):
      if (notInConstructor):
        for value in values:
          if (not (len(self.chainCodes) in (1,len(values)))):
            raise ApiError("""%s.setResidueSeqIds:
             residueSeqIds constraint Either_single_chain_code_or_residueSeqIds_match_chainCodes_one_to_one violated by value""" % self.qualifiedName
             + ": %s" % (value,)
            )

    dataDict['residueSeqIds'] = values
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setResidueSeqIds')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setResidues(self, values):
    """
    setter for derived link residues
    """
    dataDict = self.__dict__
    xx = values
    values = set(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setResidues:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      from ccp.api.molecule.MolSystem import Residue as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setResidues:
         value is not of class ccp.molecule.MolSystem.Residue""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValues = self.getResidues()
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setResidues:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setResidues:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setResidues:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if values:
      chainCodes = []
      residueSeqIds = []
      molSystemCodes = set(())
      for residue in values:
        chain = residue.chain
        chainCodes.append(chain.code)
        residueSeqIds.append(residue.seqId)
        molSystemCodes.add(chain.molSystem.code)
    
      if len(set(chainCodes)) == 1:
        del chainCodes[1:]
    
      if len(molSystemCodes) == 1:
        wasOverride = self.root.override
        self.root.override = True
        try:
          self.chainCodes = chainCodes
          self.molSystemCode = molSystemCodes.pop()
          self.residueSeqIds = residueSeqIds
        finally:
          self.root.override = wasOverride
      else:
        raise ApiError("Residues are from different MolSystems: %s" % values)
    else:
      raise ApiError("Residues can not be set to empty")
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

  setRunParameters = Data.setRunParameters

  setSerial = Data.setSerial
  
  def sortedResidues(self):
    """
    Sorted for ccp.nmr.NmrCalc.MolResidueData.residues
    """
    dataDict = self.__dict__
    ll = self.getResidues()
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result

  sortedRunParameters = Data.sortedRunParameters

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  applicationData = memops.api.Implementation.DataObject.applicationData
  
  chainCode = property(getChainCode, setChainCode, None,
  r"""Chain code of Chain containing residues - if there is only one. 
  Otherwise None.  Derived from chainCodes
  """)
  
  chainCodes = property(getChainCodes, setChainCodes, None,
  r"""chainCodes corresponding to residueSeqIds. Used in two different ways. 
  If all Residues are within a single chain, chainCodes has length one and 
  residueSeqIds may may be empty (signifying all residues in the chain) 
  Otherwise the length of chainCodes and residueSeqIds must be  identical, 
  so that each residueSeqId matches the chainCode at teh same position in 
  the list.
  """)

  className = memops.api.Implementation.ComplexDataType.className

  code = Data.code

  details = Data.details

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor

  ioRole = Data.ioRole

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted

  metaclass = memops.api.Implementation.ComplexDataType.metaclass
  
  molSystemCode = property(getMolSystemCode, setMolSystemCode, None,
  r"""Molsystem code of relevant MolSystem - used in deriving link to Residues
  """)

  name = Data.name

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName
  
  residueSeqIds = property(getResidueSeqIds, setResidueSeqIds, None,
  r"""Residue seqIds of residues linked to. If empty (and if there is only a 
  single chain code) all residues in the chain are used.
  """)

  serial = Data.serial

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess
  
  chain = property(getChain, setChain, None,
  r"""MolSystem.Chain containing residue data, if there is only one chain. 
  Otherwise None.
  """)
  
  chains = property(getChains, setChains, None,
  r"""MolSystem.Chains containing residue data. Ordered as the chainCodes 
  attriubute
  """)
  
  molSystem = property(getMolSystem, None, None,
  r"""MolSystem for residue data
  """)

  parameterGroup = Data.parameterGroup

  parent = Data.parent
  
  residues = property(getResidues, setResidues, None,
  r"""MolSystem.Residues used for data
  """)

  root = memops.api.Implementation.MemopsObject.root

  run = Data.run

  runParameters = Data.runParameters

  topObject = memops.api.Implementation.DataObject.topObject

###############################################################################
class SpinSystemData(Data):
  r"""Nmr.SpinSystem data for calculations
  """
  #   from data model element ccp.nmr.NmrCalc.SpinSystemData revision ?
  _metaclass = metaPackage.getElement('SpinSystemData')
  _packageName = 'ccp.nmr.NmrCalc'
  _packageShortName = 'CALC'
  _fieldNames = ('applicationData', 'className', 'code', 'details', 'fieldNames', 'inConstructor', 'ioRole', 'isDeleted', 'metaclass', 'name', 'packageName', 'packageShortName', 'qualifiedName', 'resonanceGroupSerials', 'serial', 'access', 'activeAccess', 'parameterGroup', 'parent', 'resonanceGroups', 'root', 'run', 'runParameters', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for ccp.nmr.NmrCalc.SpinSystemData
    """
    dataDict = self.__dict__
    dataDict['run'] = parent
    if (not isinstance(parent, Run)):
      raise ApiError("""%s.__init__:
       value is not of class ccp.nmr.NmrCalc.Run""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = parent.__dict__.get('topObject')
    dataDict['topObject'] = topObject

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    if (notIsReading):
      if (not (topObject.__dict__.get('isModifiable'))):
        raise ApiError("""%s.__init__:
         Storage not modifiable""" % self.qualifiedName
         + ": %s" % (topObject,)
        )

    try:

      dataDict['applicationData'] = list()
      dataDict['code'] = None
      dataDict['details'] = None
      dataDict['ioRole'] = 'input'
      dataDict['name'] = None
      dataDict['resonanceGroupSerials'] = list()
      dataDict['serial'] = None
      dataDict['access'] = None
      dataDict['parameterGroup'] = None
      dataDict['runParameters'] = set()

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in ccp.nmr.NmrCalc.SpinSystemData.__init__"
        del dataDict['inConstructor']
        raise

      if (notOverride):
        if (dataDict.get('serial') is None):
          dataDict['inConstructor'] = True
          self.setSerial(-1)
          del dataDict['inConstructor']
        else:
          raise ApiError("""%s.__init__:
           Cannot pass in explicit serial if not reading""" % self.qualifiedName
           + ": %s:%s" % (parent, 'ccp.nmr.NmrCalc.SpinSystemData')
          )

      if (notIsReading):
        childrenDict = parent.__dict__.get('data')
        objKey = dataDict.get('serial')
        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['serial'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notOverride):
        self.checkValid()

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for ccp.nmr.NmrCalc.SpinSystemData:
       determines cascading 
    deletes to follow from delete of object.
       *Implementation function* - 
    should be called only by API delete function.
    """
    dataDict = self.__dict__
    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for ccp.nmr.NmrCalc.SpinSystemData:   deletes
    objects
    *Implementation function* - will CORRUPT DATA if called outside 
    the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    parameterGroup = dataDict.get('parameterGroup')
    if ((parameterGroup is not None and not (parameterGroup in objsToBeDeleted))):
      data = parameterGroup.__dict__.get('data')
      data.remove(self)

    for runParameter in dataDict.get('runParameters'):
      if (not (runParameter in objsToBeDeleted)):
        runParameter.__dict__['data'] = None

    run = dataDict.get('run')
    if (not (run in objsToBeDeleted)):
      objKey = dataDict.get('serial')
      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = run.__dict__.get('data')
        if (self is dd.get(objKey)):
          del dd[objKey]

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData
  
  def addResonanceGroup(self, value):
    """
    Add for ccp.nmr.NmrCalc.SpinSystemData.resonanceGroups
    """
    dataDict = self.__dict__
    from ccp.api.nmr.Nmr import ResonanceGroup as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.addResonanceGroup:
       value is not of class ccp.nmr.Nmr.ResonanceGroup""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = self.getResonanceGroups()
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.addResonanceGroup:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.addResonanceGroup:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.addResonanceGroup:
       called with deleted value""" % self.qualifiedName
      )

    if (value in currentValues):
      raise ApiError("""%s.addResonanceGroup:
       value is in list already""" % self.qualifiedName
       + ": %s" % (self,)
      )

    newValues = set(currentValues)
    newValues.add(value)
    self.setResonanceGroups(newValues)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

  def addResonanceGroupSerial(self, value):
    """
    Add for ccp.nmr.NmrCalc.SpinSystemData.resonanceGroupSerials
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Int.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Int.create(value)
    else:
      raise ApiError("""%s.addResonanceGroupSerial:
       memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('resonanceGroupSerials')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.addResonanceGroupSerial:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.addResonanceGroupSerial:
       called on deleted object""" % self.qualifiedName
      )

    if (notOverride):
      pass

    currentValues.append(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('addResonanceGroupSerial')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  addRunParameter = Data.addRunParameter
  
  def checkAllValid(self, complete=False):
    """
    CheckAllValid for ccp.nmr.NmrCalc.SpinSystemData
    """
    dataDict = self.__dict__
    self.checkValid(complete)
  
  def checkValid(self, complete=False):
    """
    CheckValid for ccp.nmr.NmrCalc.SpinSystemData
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      objKey = dataDict.get('serial')
      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('run')
        dd = value.__dict__.get('data')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'run' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      # check attributes
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('code')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: code:
           memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 32):
          raise ApiError("""%s.checkValid: code:
           memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: code:
           memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.split()) == 1)):
          raise ApiError("""%s.checkValid: code:
           Word constraint contains_no_white_space violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('details')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: details:
           memops.Implementation.Text input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 254):
          raise ApiError("""%s.checkValid: details:
           memops.Implementation.Text maximum length is 254 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: details:
           memops.Implementation.Text: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('ioRole')
      if (not (value in ['input', 'output'])):
        raise ApiError("""%s.checkValid: ioRole:
         ccp.nmr.NmrCalc.IoRole input is not in enumeration ['input', 'output']""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.checkValid: ioRole:
         IoRole constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('name')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: name:
           memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: name:
           memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: name:
           memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: name:
           Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      values = dataDict.get('resonanceGroupSerials')
      for value in values:
        if (isinstance(value, memops.api.Implementation.Int.PythonType)):
          pass
        elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
          castValue = memops.api.Implementation.Int.create(value)
          replaceIndex = values.index(value)
          values[replaceIndex] = castValue
          value = castValue
        else:
          raise ApiError("""%s.checkValid: resonanceGroupSerials:
           memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('serial')
      if (value is None):
        raise ApiError("""%s.checkValid: serial:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.checkValid: serial:
         memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('parameterGroup')
      if (value is not None):
        if (not isinstance(value, ParameterGroup)):
          raise ApiError("""%s.checkValid: parameterGroup:
           value is not of class ccp.nmr.NmrCalc.ParameterGroup""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('data')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: parameterGroup:
           non-reciprocal link parameterGroup from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      values = self.getResonanceGroups()
      for value in values:
        from ccp.api.nmr.Nmr import ResonanceGroup as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: resonanceGroups:
           value is not of class ccp.nmr.Nmr.ResonanceGroup""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: resonanceGroups:
           Link resonanceGroups between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('run')
      if (not isinstance(value, Run)):
        raise ApiError("""%s.checkValid: run:
         value is not of class ccp.nmr.NmrCalc.Run""" % self.qualifiedName
         + ": %s" % (value,)
        )

      values = dataDict.get('runParameters')
      for value in values:
        if (not isinstance(value, RunParameter)):
          raise ApiError("""%s.checkValid: runParameters:
           value is not of class ccp.nmr.NmrCalc.RunParameter""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('data')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: runParameters:
           non-reciprocal link runParameters from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: runParameters:
           Link runParameters between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    # check explicit class constraints
    # check attributes
    values = dataDict.get('applicationData')
    for value in values:
      value.checkAllValid(complete)

    value = dataDict.get('code')
    value = dataDict.get('details')
    value = dataDict.get('ioRole')
    if (value is None):
      raise ApiError("""%s.checkValid: ioRole:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('name')
    values = dataDict.get('resonanceGroupSerials')
    # check roles
    value = dataDict.get('access')
    value = dataDict.get('parameterGroup')
    if (value is not None):
      isValid = True
      obj = self
      while obj is not None:
        obj = obj.parameterGroup
        if obj is self:
          isValid = False
          break
      if (not (isValid)):
        raise ApiError("""%s.checkValid: parameterGroup:
         parameterGroup constraint No_cyclical_parameter_grouping violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    value = dataDict.get('run')
    if (value is None):
      raise ApiError("""%s.checkValid: run:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    values = dataDict.get('runParameters')

  delete = memops.api.Implementation.DataObject.delete

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData
  
  def findAllResonanceGroups(self, **conditions):
    """
    FindAll for ccp.nmr.NmrCalc.SpinSystemData.resonanceGroups
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = self.getResonanceGroups()
      result = set(currentValues)

    else:
      currentValues = self.getResonanceGroups()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('ccpCode', 'clusterCode', 'descriptor', 'details', 'isActive', 'linking', 'molType', 'name', 'secStrucCode', 'serial', 'access', 'nmrProject', 'residue',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result

  findAllRunParameters = Data.findAllRunParameters

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData
  
  def findFirstResonanceGroup(self, **conditions):
    """
    FindFirst for ccp.nmr.NmrCalc.SpinSystemData.resonanceGroups
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = self.getResonanceGroups()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      currentValues = self.getResonanceGroups()
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('ccpCode', 'clusterCode', 'descriptor', 'details', 'isActive', 'linking', 'molType', 'name', 'secStrucCode', 'serial', 'access', 'nmrProject', 'residue',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result

  findFirstRunParameter = Data.findFirstRunParameter
  
  def get(self, name):
    """
    GetAttr for ccp.nmr.NmrCalc.SpinSystemData
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccp.nmr.NmrCalc.SpinSystemData
    """

    result = None
    if (startObj.__class__.__name__ == 'MemopsRoot'):
      if (4 != len(fullKey)):
        raise ApiError("""'ccp.nmr.NmrCalc.SpinSystemData'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj0 = startObj
      ll = list()
      objKey = fullKey[0]
      ll.append(objKey)
      if (objKey is not None):
        objKey = fullKey[1]
        ll.append(objKey)
        if (objKey is not None):
          objKey = tuple(ll)

      obj1 = obj0.__dict__.get('nmrCalcStores').get(objKey)
      if (obj1 is None):
        obj0.refreshTopObjects('ccp.nmr.NmrCalc')
        obj1 = obj0.__dict__.get('nmrCalcStores').get(objKey)

    else:
      if (2 != len(fullKey)):
        raise ApiError("""'ccp.nmr.NmrCalc.SpinSystemData'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj1 = startObj

    if (obj1 is not None):
      if (not (obj1.__dict__.get('isLoaded'))):
        obj1.load()

      objKey = fullKey[-2]
      obj2 = obj1.__dict__.get('runs').get(objKey)

      if (obj2 is not None):
        objKey = fullKey[-1]
        obj3 = obj2.__dict__.get('data').get(objKey)
        if (isinstance(obj3, SpinSystemData)):
          result = obj3

    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation

  getClassName = memops.api.Implementation.ComplexDataType.getClassName

  getCode = Data.getCode

  getDetails = Data.getDetails

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames

  getFullKey = Data.getFullKey

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor

  getIoRole = Data.getIoRole

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted

  getLocalKey = Data.getLocalKey

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass

  getName = Data.getName

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName

  getParameterGroup = Data.getParameterGroup

  getParent = Data.getParent

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName
  
  def getResonanceGroupSerials(self):
    """
    Get for ccp.nmr.NmrCalc.SpinSystemData.resonanceGroupSerials
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('resonanceGroupSerials')
    result = tuple(tempVar)
    return result
  
  def getResonanceGroups(self):
    """
    getter for derived link resonanceGroups
    """
    dataDict = self.__dict__
    nmrProject = self.topObject.nmrProject
    ff = nmrProject.findFirstResonanceGroup
    ll = [ff(x) for x in self.resonanceGroupSerials]
    result = frozenset(x for x in ll if x is not None)
    return result

  getRoot = memops.api.Implementation.MemopsObject.getRoot

  getRun = Data.getRun

  getRunParameters = Data.getRunParameters

  getSerial = Data.getSerial

  getTopObject = memops.api.Implementation.DataObject.getTopObject

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData
  
  def removeResonanceGroup(self, value):
    """
    Remove for ccp.nmr.NmrCalc.SpinSystemData.resonanceGroups
    """
    dataDict = self.__dict__
    from ccp.api.nmr.Nmr import ResonanceGroup as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.removeResonanceGroup:
       value is not of class ccp.nmr.Nmr.ResonanceGroup""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = self.getResonanceGroups()
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.removeResonanceGroup:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.removeResonanceGroup:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.removeResonanceGroup:
       called with deleted value""" % self.qualifiedName
      )

    if (not (value in currentValues)):
      raise ApiError("""%s.removeResonanceGroup:
       value not in list""" % self.qualifiedName
       + ": %s" % (self,)
      )

    newValues = set(currentValues)
    newValues.remove(value)
    self.setResonanceGroups(newValues)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

  def removeResonanceGroupSerial(self, value):
    """
    Remove for ccp.nmr.NmrCalc.SpinSystemData.resonanceGroupSerials
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Int.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Int.create(value)
    else:
      raise ApiError("""%s.removeResonanceGroupSerial:
       memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('resonanceGroupSerials')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.removeResonanceGroupSerial:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.removeResonanceGroupSerial:
       called on deleted object""" % self.qualifiedName
      )

    if (not (value in currentValues)):
      raise ApiError("""%s.removeResonanceGroupSerial:
       value not in list""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      pass

    currentValues.remove(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('removeResonanceGroupSerial')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  removeRunParameter = Data.removeRunParameter
  
  def set(self, name, value):
    """
    SetAttr for ccp.nmr.NmrCalc.SpinSystemData
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData

  setCode = Data.setCode

  setDetails = Data.setDetails

  setIoRole = Data.setIoRole

  setName = Data.setName

  setParameterGroup = Data.setParameterGroup
  
  def setResonanceGroupSerials(self, values):
    """
    Set for ccp.nmr.NmrCalc.SpinSystemData.resonanceGroupSerials
    """
    dataDict = self.__dict__
    values = list(values)
    for value in values:
      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        castValue = memops.api.Implementation.Int.create(value)
        replaceIndex = values.index(value)
        values[replaceIndex] = castValue
        value = castValue
      else:
        raise ApiError("""%s.setResonanceGroupSerials:
         memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('resonanceGroupSerials')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setResonanceGroupSerials:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setResonanceGroupSerials:
       called on deleted object""" % self.qualifiedName
      )

    if (values == currentValues):
      return

    if (notOverride):
      pass

    dataDict['resonanceGroupSerials'] = values
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setResonanceGroupSerials')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setResonanceGroups(self, values):
    """
    setter for derived link resonanceGroups
    """
    dataDict = self.__dict__
    xx = values
    values = set(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setResonanceGroups:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      from ccp.api.nmr.Nmr import ResonanceGroup as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setResonanceGroups:
         value is not of class ccp.nmr.Nmr.ResonanceGroup""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValues = self.getResonanceGroups()
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setResonanceGroups:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setResonanceGroups:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setResonanceGroups:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if not values:
      self.resonanceGroupSerials = ()
    
    else:
      nmrProject = self.topObject.nmrProject
      ll = []
      for value in values:
        if value.nmrProject is nmrProject:
          ll.append(value.serial)
        else:
          raise ApiError("%s does not belong to NmrCalcStore.nmrProject %s" % (value,nmrProject ))
      self.self.resonanceGroupSerials = ll
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

  setRunParameters = Data.setRunParameters

  setSerial = Data.setSerial
  
  def sortedResonanceGroups(self):
    """
    Sorted for ccp.nmr.NmrCalc.SpinSystemData.resonanceGroups
    """
    dataDict = self.__dict__
    ll = self.getResonanceGroups()
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result

  sortedRunParameters = Data.sortedRunParameters

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  applicationData = memops.api.Implementation.DataObject.applicationData

  className = memops.api.Implementation.ComplexDataType.className

  code = Data.code

  details = Data.details

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor

  ioRole = Data.ioRole

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted

  metaclass = memops.api.Implementation.ComplexDataType.metaclass

  name = Data.name

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName
  
  resonanceGroupSerials = property(getResonanceGroupSerials, setResonanceGroupSerials, None,
  r"""Serial numbers of Resonance groups - used to derive actual objects.
  """)

  serial = Data.serial

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess

  parameterGroup = Data.parameterGroup

  parent = Data.parent
  
  resonanceGroups = property(getResonanceGroups, setResonanceGroups, None,
  r"""Nmr.ResonanceGroups (spinSystems) used for data
  """)

  root = memops.api.Implementation.MemopsObject.root

  run = Data.run

  runParameters = Data.runParameters

  topObject = memops.api.Implementation.DataObject.topObject

###############################################################################
class StructureEnsembleData(Data):
  r"""StructureEnsemble data for calculations
  """
  #   from data model element ccp.nmr.NmrCalc.StructureEnsembleData revision ?
  _metaclass = metaPackage.getElement('StructureEnsembleData')
  _packageName = 'ccp.nmr.NmrCalc'
  _packageShortName = 'CALC'
  _fieldNames = ('applicationData', 'className', 'code', 'details', 'ensembleId', 'fieldNames', 'inConstructor', 'ioRole', 'isDeleted', 'metaclass', 'modelSerials', 'molSystemCode', 'name', 'packageName', 'packageShortName', 'qualifiedName', 'serial', 'access', 'activeAccess', 'models', 'parameterGroup', 'parent', 'root', 'run', 'runParameters', 'structureEnsemble', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for ccp.nmr.NmrCalc.StructureEnsembleData
    """
    dataDict = self.__dict__
    dataDict['run'] = parent
    if (not isinstance(parent, Run)):
      raise ApiError("""%s.__init__:
       value is not of class ccp.nmr.NmrCalc.Run""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = parent.__dict__.get('topObject')
    dataDict['topObject'] = topObject

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    if (notIsReading):
      if (not (topObject.__dict__.get('isModifiable'))):
        raise ApiError("""%s.__init__:
         Storage not modifiable""" % self.qualifiedName
         + ": %s" % (topObject,)
        )

    try:

      dataDict['applicationData'] = list()
      dataDict['code'] = None
      dataDict['details'] = None
      dataDict['ensembleId'] = None
      dataDict['ioRole'] = 'input'
      dataDict['modelSerials'] = list()
      dataDict['molSystemCode'] = None
      dataDict['name'] = None
      dataDict['serial'] = None
      dataDict['access'] = None
      dataDict['parameterGroup'] = None
      dataDict['runParameters'] = set()

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in ccp.nmr.NmrCalc.StructureEnsembleData.__init__"
        del dataDict['inConstructor']
        raise

      if (notOverride):
        if (dataDict.get('serial') is None):
          dataDict['inConstructor'] = True
          self.setSerial(-1)
          del dataDict['inConstructor']
        else:
          raise ApiError("""%s.__init__:
           Cannot pass in explicit serial if not reading""" % self.qualifiedName
           + ": %s:%s" % (parent, 'ccp.nmr.NmrCalc.StructureEnsembleData')
          )

      if (notIsReading):
        childrenDict = parent.__dict__.get('data')
        objKey = dataDict.get('serial')
        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['serial'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notOverride):
        self.checkValid()

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for ccp.nmr.NmrCalc.StructureEnsembleData:
       determines 
    cascading deletes to follow from delete of object.
       *Implementation 
    function* - should be called only by API delete function.
    """
    dataDict = self.__dict__
    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for ccp.nmr.NmrCalc.StructureEnsembleData:   deletes
    objects
    *Implementation function* - will CORRUPT DATA if called outside 
    the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    parameterGroup = dataDict.get('parameterGroup')
    if ((parameterGroup is not None and not (parameterGroup in objsToBeDeleted))):
      data = parameterGroup.__dict__.get('data')
      data.remove(self)

    for runParameter in dataDict.get('runParameters'):
      if (not (runParameter in objsToBeDeleted)):
        runParameter.__dict__['data'] = None

    run = dataDict.get('run')
    if (not (run in objsToBeDeleted)):
      objKey = dataDict.get('serial')
      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = run.__dict__.get('data')
        if (self is dd.get(objKey)):
          del dd[objKey]

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData
  
  def addModel(self, value):
    """
    Add for ccp.nmr.NmrCalc.StructureEnsembleData.models
    """
    dataDict = self.__dict__
    from ccp.api.molecule.MolStructure import Model as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.addModel:
       value is not of class ccp.molecule.MolStructure.Model""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = self.getModels()
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.addModel:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.addModel:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.addModel:
       called with deleted value""" % self.qualifiedName
      )

    if (value in currentValues):
      raise ApiError("""%s.addModel:
       value is in list already""" % self.qualifiedName
       + ": %s" % (self,)
      )

    newValues = list(currentValues)
    newValues.append(value)
    self.setModels(newValues)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

  def addModelSerial(self, value):
    """
    Add for ccp.nmr.NmrCalc.StructureEnsembleData.modelSerials
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Int.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Int.create(value)
    else:
      raise ApiError("""%s.addModelSerial:
       memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('modelSerials')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.addModelSerial:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.addModelSerial:
       called on deleted object""" % self.qualifiedName
      )

    if (value in currentValues):
      raise ApiError("""%s.addModelSerial:
       value is in list already""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      pass

    currentValues.append(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('addModelSerial')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  addRunParameter = Data.addRunParameter
  
  def checkAllValid(self, complete=False):
    """
    CheckAllValid for ccp.nmr.NmrCalc.StructureEnsembleData
    """
    dataDict = self.__dict__
    self.checkValid(complete)
  
  def checkValid(self, complete=False):
    """
    CheckValid for ccp.nmr.NmrCalc.StructureEnsembleData
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      objKey = dataDict.get('serial')
      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('run')
        dd = value.__dict__.get('data')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'run' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      # check attributes
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('code')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: code:
           memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 32):
          raise ApiError("""%s.checkValid: code:
           memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: code:
           memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.split()) == 1)):
          raise ApiError("""%s.checkValid: code:
           Word constraint contains_no_white_space violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('details')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: details:
           memops.Implementation.Text input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 254):
          raise ApiError("""%s.checkValid: details:
           memops.Implementation.Text maximum length is 254 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: details:
           memops.Implementation.Text: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('ensembleId')
      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.checkValid: ensembleId:
         memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('ioRole')
      if (not (value in ['input', 'output'])):
        raise ApiError("""%s.checkValid: ioRole:
         ccp.nmr.NmrCalc.IoRole input is not in enumeration ['input', 'output']""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.checkValid: ioRole:
         IoRole constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      values = dataDict.get('modelSerials')
      for value in values:
        if (isinstance(value, memops.api.Implementation.Int.PythonType)):
          pass
        elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
          castValue = memops.api.Implementation.Int.create(value)
          replaceIndex = values.index(value)
          values[replaceIndex] = None
          if (castValue in values):
            values[replaceIndex] = value
            raise ApiError("""%s.checkValid: modelSerials:
             replacement value already in unique collection """ % self.qualifiedName
             + ": %s" % (castValue,)
            )
          else:
            values[replaceIndex] = castValue

          value = castValue
        else:
          raise ApiError("""%s.checkValid: modelSerials:
           memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('molSystemCode')
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: molSystemCode:
         memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 32):
        raise ApiError("""%s.checkValid: molSystemCode:
         memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: molSystemCode:
         memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.checkValid: molSystemCode:
         Word constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('name')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: name:
           memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: name:
           memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: name:
           memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: name:
           Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('serial')
      if (value is None):
        raise ApiError("""%s.checkValid: serial:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.checkValid: serial:
         memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      values = self.getModels()
      for value in values:
        from ccp.api.molecule.MolStructure import Model as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: models:
           value is not of class ccp.molecule.MolStructure.Model""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: models:
           Link models between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('parameterGroup')
      if (value is not None):
        if (not isinstance(value, ParameterGroup)):
          raise ApiError("""%s.checkValid: parameterGroup:
           value is not of class ccp.nmr.NmrCalc.ParameterGroup""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('data')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: parameterGroup:
           non-reciprocal link parameterGroup from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      value = dataDict.get('run')
      if (not isinstance(value, Run)):
        raise ApiError("""%s.checkValid: run:
         value is not of class ccp.nmr.NmrCalc.Run""" % self.qualifiedName
         + ": %s" % (value,)
        )

      values = dataDict.get('runParameters')
      for value in values:
        if (not isinstance(value, RunParameter)):
          raise ApiError("""%s.checkValid: runParameters:
           value is not of class ccp.nmr.NmrCalc.RunParameter""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('data')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: runParameters:
           non-reciprocal link runParameters from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: runParameters:
           Link runParameters between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getStructureEnsemble()
      if (value is not None):
        from ccp.api.molecule.MolStructure import StructureEnsemble as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: structureEnsemble:
           value is not of class ccp.molecule.MolStructure.StructureEnsemble""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: structureEnsemble:
           Link structureEnsemble between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    # check explicit class constraints
    # check attributes
    values = dataDict.get('applicationData')
    for value in values:
      value.checkAllValid(complete)

    value = dataDict.get('code')
    value = dataDict.get('details')
    value = dataDict.get('ensembleId')
    if (value is None):
      raise ApiError("""%s.checkValid: ensembleId:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('ioRole')
    if (value is None):
      raise ApiError("""%s.checkValid: ioRole:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    values = dataDict.get('modelSerials')
    value = dataDict.get('molSystemCode')
    if (value is None):
      raise ApiError("""%s.checkValid: molSystemCode:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('name')
    # check roles
    value = dataDict.get('access')
    value = dataDict.get('parameterGroup')
    if (value is not None):
      isValid = True
      obj = self
      while obj is not None:
        obj = obj.parameterGroup
        if obj is self:
          isValid = False
          break
      if (not (isValid)):
        raise ApiError("""%s.checkValid: parameterGroup:
         parameterGroup constraint No_cyclical_parameter_grouping violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    value = dataDict.get('run')
    if (value is None):
      raise ApiError("""%s.checkValid: run:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    values = dataDict.get('runParameters')

  delete = memops.api.Implementation.DataObject.delete

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData
  
  def findAllModels(self, **conditions):
    """
    FindAll for ccp.nmr.NmrCalc.StructureEnsembleData.models
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = self.getModels()
      result = list(currentValues)

    else:
      currentValues = self.getModels()
      result = list()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('details', 'index', 'name', 'serial', 'access', 'structureEnsemble',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.append(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.append(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.append(v)

    return result

  findAllRunParameters = Data.findAllRunParameters

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData
  
  def findFirstModel(self, **conditions):
    """
    FindFirst for ccp.nmr.NmrCalc.StructureEnsembleData.models
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = self.getModels()
      if (currentValues):
        result = currentValues[0]
      else:
        result = None

    else:
      currentValues = self.getModels()
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('details', 'index', 'name', 'serial', 'access', 'structureEnsemble',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result

  findFirstRunParameter = Data.findFirstRunParameter
  
  def get(self, name):
    """
    GetAttr for ccp.nmr.NmrCalc.StructureEnsembleData
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccp.nmr.NmrCalc.StructureEnsembleData
    """

    result = None
    if (startObj.__class__.__name__ == 'MemopsRoot'):
      if (4 != len(fullKey)):
        raise ApiError("""'ccp.nmr.NmrCalc.StructureEnsembleData'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj0 = startObj
      ll = list()
      objKey = fullKey[0]
      ll.append(objKey)
      if (objKey is not None):
        objKey = fullKey[1]
        ll.append(objKey)
        if (objKey is not None):
          objKey = tuple(ll)

      obj1 = obj0.__dict__.get('nmrCalcStores').get(objKey)
      if (obj1 is None):
        obj0.refreshTopObjects('ccp.nmr.NmrCalc')
        obj1 = obj0.__dict__.get('nmrCalcStores').get(objKey)

    else:
      if (2 != len(fullKey)):
        raise ApiError("""'ccp.nmr.NmrCalc.StructureEnsembleData'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj1 = startObj

    if (obj1 is not None):
      if (not (obj1.__dict__.get('isLoaded'))):
        obj1.load()

      objKey = fullKey[-2]
      obj2 = obj1.__dict__.get('runs').get(objKey)

      if (obj2 is not None):
        objKey = fullKey[-1]
        obj3 = obj2.__dict__.get('data').get(objKey)
        if (isinstance(obj3, StructureEnsembleData)):
          result = obj3

    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation

  getClassName = memops.api.Implementation.ComplexDataType.getClassName

  getCode = Data.getCode

  getDetails = Data.getDetails
  
  def getEnsembleId(self):
    """
    Get for ccp.nmr.NmrCalc.StructureEnsembleData.ensembleId
    """
    dataDict = self.__dict__
    result = dataDict.get('ensembleId')
    return result

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames

  getFullKey = Data.getFullKey

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor

  getIoRole = Data.getIoRole

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted

  getLocalKey = Data.getLocalKey

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass
  
  def getModelSerials(self):
    """
    Get for ccp.nmr.NmrCalc.StructureEnsembleData.modelSerials
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('modelSerials')
    result = tuple(tempVar)
    return result
  
  def getModels(self):
    """
    getter for derived link models
    """
    dataDict = self.__dict__
    memopsRoot = self.root
    molSystem = memopsRoot.findFirstMolSystem(code=self.molSystemCode)
    ensemble = memopsRoot.findFirstStructureEnsemble(molSystem=molSystem, ensembleId=self.ensembleId)
    if ensemble:
      modelSerials = self.modelSerials
      if modelSerials:
        ll = list(ensemble.findFirstModel(serial=x) for x in modelSerials)
        result = tuple(x for x in ll if x is not None)
      else:
        result = tuple(ensemble.sortedModels())
    else:
      result = tuple()
    return result
  
  def getMolSystemCode(self):
    """
    Get for ccp.nmr.NmrCalc.StructureEnsembleData.molSystemCode
    """
    dataDict = self.__dict__
    result = dataDict.get('molSystemCode')
    return result

  getName = Data.getName

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName

  getParameterGroup = Data.getParameterGroup

  getParent = Data.getParent

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName

  getRoot = memops.api.Implementation.MemopsObject.getRoot

  getRun = Data.getRun

  getRunParameters = Data.getRunParameters

  getSerial = Data.getSerial
  
  def getStructureEnsemble(self):
    """
    getter for derived link structureEnsemble
    """
    dataDict = self.__dict__
    memopsRoot = self.root
    molSystem = memopsRoot.findFirstMolSystem(code=self.molSystemCode)
    result = memopsRoot.findFirstStructureEnsemble(molSystem=molSystem, ensembleId=self.ensembleId)
    return result

  getTopObject = memops.api.Implementation.DataObject.getTopObject

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData
  
  def removeModel(self, value):
    """
    Remove for ccp.nmr.NmrCalc.StructureEnsembleData.models
    """
    dataDict = self.__dict__
    from ccp.api.molecule.MolStructure import Model as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.removeModel:
       value is not of class ccp.molecule.MolStructure.Model""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = self.getModels()
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.removeModel:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.removeModel:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.removeModel:
       called with deleted value""" % self.qualifiedName
      )

    if (not (value in currentValues)):
      raise ApiError("""%s.removeModel:
       value not in list""" % self.qualifiedName
       + ": %s" % (self,)
      )

    newValues = list(currentValues)
    newValues.remove(value)
    self.setModels(newValues)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

  def removeModelSerial(self, value):
    """
    Remove for ccp.nmr.NmrCalc.StructureEnsembleData.modelSerials
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Int.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Int.create(value)
    else:
      raise ApiError("""%s.removeModelSerial:
       memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('modelSerials')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.removeModelSerial:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.removeModelSerial:
       called on deleted object""" % self.qualifiedName
      )

    if (not (value in currentValues)):
      raise ApiError("""%s.removeModelSerial:
       value not in list""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      pass

    currentValues.remove(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('removeModelSerial')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  removeRunParameter = Data.removeRunParameter
  
  def set(self, name, value):
    """
    SetAttr for ccp.nmr.NmrCalc.StructureEnsembleData
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData

  setCode = Data.setCode

  setDetails = Data.setDetails
  
  def setEnsembleId(self, value):
    """
    Set for ccp.nmr.NmrCalc.StructureEnsembleData.ensembleId
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Int.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Int.create(value)
    else:
      raise ApiError("""%s.setEnsembleId:
       memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('ensembleId')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setEnsembleId:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setEnsembleId:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setEnsembleId:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['ensembleId'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setEnsembleId')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  setIoRole = Data.setIoRole
  
  def setModelSerials(self, values):
    """
    Set for ccp.nmr.NmrCalc.StructureEnsembleData.modelSerials
    """
    dataDict = self.__dict__
    xx = set(values)
    values = list(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setModelSerials:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        castValue = memops.api.Implementation.Int.create(value)
        replaceIndex = values.index(value)
        values[replaceIndex] = None
        if (castValue in values):
          values[replaceIndex] = value
          raise ApiError("""%s.setModelSerials:
           replacement value already in unique collection """ % self.qualifiedName
           + ": %s" % (castValue,)
          )
        else:
          values[replaceIndex] = castValue

        value = castValue
      else:
        raise ApiError("""%s.setModelSerials:
         memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('modelSerials')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setModelSerials:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setModelSerials:
       called on deleted object""" % self.qualifiedName
      )

    if (values == currentValues):
      return

    if (notOverride):
      pass

    dataDict['modelSerials'] = values
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setModelSerials')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setModels(self, values):
    """
    getter for derived link models
    """
    dataDict = self.__dict__
    xx = set(values)
    values = list(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setModels:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      from ccp.api.molecule.MolStructure import Model as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setModels:
         value is not of class ccp.molecule.MolStructure.Model""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValues = self.getModels()
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setModels:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setModels:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setModels:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if values:
      ensembles = set(x.structureEnsemble for x in values)
      if len(ensembles) == 1:
        ensemble =  ensembles.pop()
        self.molSystemCode = ensemble.molSystem.code
        self.ensembleId = ensemble.ensembleId
        self.modelSerials = [x.serial for x in values]
      else:
        raise ApiError("Models are from different StructureEnsembles: %s" % values)
    else:
      self.modelSerials = ()
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

  def setMolSystemCode(self, value):
    """
    Set for ccp.nmr.NmrCalc.StructureEnsembleData.molSystemCode
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.setMolSystemCode:
       memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 32):
      raise ApiError("""%s.setMolSystemCode:
       memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.setMolSystemCode:
       memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.split()) == 1)):
      raise ApiError("""%s.setMolSystemCode:
       Word constraint contains_no_white_space violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('molSystemCode')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setMolSystemCode:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setMolSystemCode:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setMolSystemCode:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['molSystemCode'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setMolSystemCode')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  setName = Data.setName

  setParameterGroup = Data.setParameterGroup

  setRunParameters = Data.setRunParameters

  setSerial = Data.setSerial
  
  def setStructureEnsemble(self, value):
    """
    setter for derived link structureEnsemble
    """
    dataDict = self.__dict__
    if (value is not None):
      from ccp.api.molecule.MolStructure import StructureEnsemble as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setStructureEnsemble:
         value is not of class ccp.molecule.MolStructure.StructureEnsemble""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = self.getStructureEnsemble()
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setStructureEnsemble:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setStructureEnsemble:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setStructureEnsemble:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if value:
      self.molSystemCode = value.molSystem.code
      self.ensembleId = value.ensembleId
    else:
      raise ApiError("StructureEnsembleData.structureEnsemble can not be set to None")
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

  sortedRunParameters = Data.sortedRunParameters

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  applicationData = memops.api.Implementation.DataObject.applicationData

  className = memops.api.Implementation.ComplexDataType.className

  code = Data.code

  details = Data.details
  
  ensembleId = property(getEnsembleId, setEnsembleId, None,
  r"""ensembleId of relevant StructureEnsemble - used in deriving link to 
  Structures
  """)

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor

  ioRole = Data.ioRole

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted

  metaclass = memops.api.Implementation.ComplexDataType.metaclass
  
  modelSerials = property(getModelSerials, setModelSerials, None,
  r"""serial of MolStructure.Models linked to. If empty all Models in ensemble 
  are used.
  """)
  
  molSystemCode = property(getMolSystemCode, setMolSystemCode, None,
  r"""MolSystem code of relevant MolSystem - used in deriving link to 
  Structures
  """)

  name = Data.name

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName

  serial = Data.serial

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess
  
  models = property(getModels, setModels, None,
  r"""StructureEnsemble.Models used as data
  """)

  parameterGroup = Data.parameterGroup

  parent = Data.parent

  root = memops.api.Implementation.MemopsObject.root

  run = Data.run

  runParameters = Data.runParameters
  
  structureEnsemble = property(getStructureEnsemble, setStructureEnsemble, None,
  r"""StructureEnsemble used as data
  """)

  topObject = memops.api.Implementation.DataObject.topObject

###############################################################################
class SpectrumData(Data):
  r"""Nmr PeakList data
  """
  #   from data model element ccp.nmr.NmrCalc.SpectrumData revision ?
  _metaclass = metaPackage.getElement('SpectrumData')
  _packageName = 'ccp.nmr.NmrCalc'
  _packageShortName = 'CALC'
  _fieldNames = ('applicationData', 'className', 'code', 'dataSourceSerial', 'details', 'experimentSerial', 'fieldNames', 'inConstructor', 'ioRole', 'isDeleted', 'metaclass', 'name', 'packageName', 'packageShortName', 'qualifiedName', 'serial', 'access', 'activeAccess', 'dataSource', 'parameterGroup', 'parent', 'root', 'run', 'runParameters', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for ccp.nmr.NmrCalc.SpectrumData
    """
    dataDict = self.__dict__
    dataDict['run'] = parent
    if (not isinstance(parent, Run)):
      raise ApiError("""%s.__init__:
       value is not of class ccp.nmr.NmrCalc.Run""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = parent.__dict__.get('topObject')
    dataDict['topObject'] = topObject

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    if (notIsReading):
      if (not (topObject.__dict__.get('isModifiable'))):
        raise ApiError("""%s.__init__:
         Storage not modifiable""" % self.qualifiedName
         + ": %s" % (topObject,)
        )

    try:

      dataDict['applicationData'] = list()
      dataDict['code'] = None
      dataDict['dataSourceSerial'] = None
      dataDict['details'] = None
      dataDict['experimentSerial'] = None
      dataDict['ioRole'] = 'input'
      dataDict['name'] = None
      dataDict['serial'] = None
      dataDict['access'] = None
      dataDict['parameterGroup'] = None
      dataDict['runParameters'] = set()

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in ccp.nmr.NmrCalc.SpectrumData.__init__"
        del dataDict['inConstructor']
        raise

      if (notOverride):
        if (dataDict.get('serial') is None):
          dataDict['inConstructor'] = True
          self.setSerial(-1)
          del dataDict['inConstructor']
        else:
          raise ApiError("""%s.__init__:
           Cannot pass in explicit serial if not reading""" % self.qualifiedName
           + ": %s:%s" % (parent, 'ccp.nmr.NmrCalc.SpectrumData')
          )

      if (notIsReading):
        childrenDict = parent.__dict__.get('data')
        objKey = dataDict.get('serial')
        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['serial'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notOverride):
        self.checkValid()

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for ccp.nmr.NmrCalc.SpectrumData:
       determines cascading 
    deletes to follow from delete of object.
       *Implementation function* - 
    should be called only by API delete function.
    """
    dataDict = self.__dict__
    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for ccp.nmr.NmrCalc.SpectrumData:   deletes
    objects
    *Implementation function* - will CORRUPT DATA if called outside 
    the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    parameterGroup = dataDict.get('parameterGroup')
    if ((parameterGroup is not None and not (parameterGroup in objsToBeDeleted))):
      data = parameterGroup.__dict__.get('data')
      data.remove(self)

    for runParameter in dataDict.get('runParameters'):
      if (not (runParameter in objsToBeDeleted)):
        runParameter.__dict__['data'] = None

    run = dataDict.get('run')
    if (not (run in objsToBeDeleted)):
      objKey = dataDict.get('serial')
      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = run.__dict__.get('data')
        if (self is dd.get(objKey)):
          del dd[objKey]

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData

  addRunParameter = Data.addRunParameter
  
  def checkAllValid(self, complete=False):
    """
    CheckAllValid for ccp.nmr.NmrCalc.SpectrumData
    """
    dataDict = self.__dict__
    self.checkValid(complete)
  
  def checkValid(self, complete=False):
    """
    CheckValid for ccp.nmr.NmrCalc.SpectrumData
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      objKey = dataDict.get('serial')
      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('run')
        dd = value.__dict__.get('data')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'run' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      # check attributes
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('code')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: code:
           memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 32):
          raise ApiError("""%s.checkValid: code:
           memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: code:
           memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.split()) == 1)):
          raise ApiError("""%s.checkValid: code:
           Word constraint contains_no_white_space violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('dataSourceSerial')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.Int.PythonType)):
          pass
        elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
          value = memops.api.Implementation.Int.create(value)
        else:
          raise ApiError("""%s.checkValid: dataSourceSerial:
           memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('details')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: details:
           memops.Implementation.Text input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 254):
          raise ApiError("""%s.checkValid: details:
           memops.Implementation.Text maximum length is 254 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: details:
           memops.Implementation.Text: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('experimentSerial')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.Int.PythonType)):
          pass
        elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
          value = memops.api.Implementation.Int.create(value)
        else:
          raise ApiError("""%s.checkValid: experimentSerial:
           memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('ioRole')
      if (not (value in ['input', 'output'])):
        raise ApiError("""%s.checkValid: ioRole:
         ccp.nmr.NmrCalc.IoRole input is not in enumeration ['input', 'output']""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.checkValid: ioRole:
         IoRole constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('name')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: name:
           memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: name:
           memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: name:
           memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: name:
           Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('serial')
      if (value is None):
        raise ApiError("""%s.checkValid: serial:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.checkValid: serial:
         memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getDataSource()
      if (value is not None):
        from ccp.api.nmr.Nmr import DataSource as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: dataSource:
           value is not of class ccp.nmr.Nmr.DataSource""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: dataSource:
           Link dataSource between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('parameterGroup')
      if (value is not None):
        if (not isinstance(value, ParameterGroup)):
          raise ApiError("""%s.checkValid: parameterGroup:
           value is not of class ccp.nmr.NmrCalc.ParameterGroup""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('data')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: parameterGroup:
           non-reciprocal link parameterGroup from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      value = dataDict.get('run')
      if (not isinstance(value, Run)):
        raise ApiError("""%s.checkValid: run:
         value is not of class ccp.nmr.NmrCalc.Run""" % self.qualifiedName
         + ": %s" % (value,)
        )

      values = dataDict.get('runParameters')
      for value in values:
        if (not isinstance(value, RunParameter)):
          raise ApiError("""%s.checkValid: runParameters:
           value is not of class ccp.nmr.NmrCalc.RunParameter""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('data')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: runParameters:
           non-reciprocal link runParameters from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: runParameters:
           Link runParameters between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    # check explicit class constraints
    # check attributes
    values = dataDict.get('applicationData')
    for value in values:
      value.checkAllValid(complete)

    value = dataDict.get('code')
    value = dataDict.get('dataSourceSerial')
    value = dataDict.get('details')
    value = dataDict.get('experimentSerial')
    value = dataDict.get('ioRole')
    if (value is None):
      raise ApiError("""%s.checkValid: ioRole:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('name')
    # check roles
    value = dataDict.get('access')
    value = dataDict.get('parameterGroup')
    if (value is not None):
      isValid = True
      obj = self
      while obj is not None:
        obj = obj.parameterGroup
        if obj is self:
          isValid = False
          break
      if (not (isValid)):
        raise ApiError("""%s.checkValid: parameterGroup:
         parameterGroup constraint No_cyclical_parameter_grouping violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    value = dataDict.get('run')
    if (value is None):
      raise ApiError("""%s.checkValid: run:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    values = dataDict.get('runParameters')

  delete = memops.api.Implementation.DataObject.delete

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData

  findAllRunParameters = Data.findAllRunParameters

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData

  findFirstRunParameter = Data.findFirstRunParameter
  
  def get(self, name):
    """
    GetAttr for ccp.nmr.NmrCalc.SpectrumData
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccp.nmr.NmrCalc.SpectrumData
    """

    result = None
    if (startObj.__class__.__name__ == 'MemopsRoot'):
      if (4 != len(fullKey)):
        raise ApiError("""'ccp.nmr.NmrCalc.SpectrumData'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj0 = startObj
      ll = list()
      objKey = fullKey[0]
      ll.append(objKey)
      if (objKey is not None):
        objKey = fullKey[1]
        ll.append(objKey)
        if (objKey is not None):
          objKey = tuple(ll)

      obj1 = obj0.__dict__.get('nmrCalcStores').get(objKey)
      if (obj1 is None):
        obj0.refreshTopObjects('ccp.nmr.NmrCalc')
        obj1 = obj0.__dict__.get('nmrCalcStores').get(objKey)

    else:
      if (2 != len(fullKey)):
        raise ApiError("""'ccp.nmr.NmrCalc.SpectrumData'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj1 = startObj

    if (obj1 is not None):
      if (not (obj1.__dict__.get('isLoaded'))):
        obj1.load()

      objKey = fullKey[-2]
      obj2 = obj1.__dict__.get('runs').get(objKey)

      if (obj2 is not None):
        objKey = fullKey[-1]
        obj3 = obj2.__dict__.get('data').get(objKey)
        if (isinstance(obj3, SpectrumData)):
          result = obj3

    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation

  getClassName = memops.api.Implementation.ComplexDataType.getClassName

  getCode = Data.getCode
  
  def getDataSource(self):
    """
    getter for derived link dataSource
    """
    dataDict = self.__dict__
    result = self.getByNavigation('topObject', 'nmrProject', ('experiments', self.experimentSerial), ('dataSources', self.dataSourceSerial))
    return result
  
  def getDataSourceSerial(self):
    """
    Get for ccp.nmr.NmrCalc.SpectrumData.dataSourceSerial
    """
    dataDict = self.__dict__
    result = dataDict.get('dataSourceSerial')
    return result

  getDetails = Data.getDetails

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey
  
  def getExperimentSerial(self):
    """
    Get for ccp.nmr.NmrCalc.SpectrumData.experimentSerial
    """
    dataDict = self.__dict__
    result = dataDict.get('experimentSerial')
    return result

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames

  getFullKey = Data.getFullKey

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor

  getIoRole = Data.getIoRole

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted

  getLocalKey = Data.getLocalKey

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass

  getName = Data.getName

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName

  getParameterGroup = Data.getParameterGroup

  getParent = Data.getParent

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName

  getRoot = memops.api.Implementation.MemopsObject.getRoot

  getRun = Data.getRun

  getRunParameters = Data.getRunParameters

  getSerial = Data.getSerial

  getTopObject = memops.api.Implementation.DataObject.getTopObject

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData

  removeRunParameter = Data.removeRunParameter
  
  def set(self, name, value):
    """
    SetAttr for ccp.nmr.NmrCalc.SpectrumData
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData

  setCode = Data.setCode
  
  def setDataSource(self, value):
    """
    setter for derived link dataSource
    """
    dataDict = self.__dict__
    if (value is not None):
      from ccp.api.nmr.Nmr import DataSource as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setDataSource:
         value is not of class ccp.nmr.Nmr.DataSource""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = self.getDataSource()
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setDataSource:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setDataSource:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setDataSource:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if value is None:
      self.experimentSerial = None
      self.dataSourceSerial = None
    elif self.topObject.nmrProject is value.topObject:
      self.experimentSerial = value.experiment.serial
      self.dataSourceSerial = value.serial
    else:
      raise ApiError("%s does not belong to NmrCalcStore.nmrProject %s" % (value,self.topObject.nmrProject ))
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

  def setDataSourceSerial(self, value):
    """
    Set for ccp.nmr.NmrCalc.SpectrumData.dataSourceSerial
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.setDataSourceSerial:
         memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('dataSourceSerial')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setDataSourceSerial:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setDataSourceSerial:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['dataSourceSerial'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setDataSourceSerial')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  setDetails = Data.setDetails
  
  def setExperimentSerial(self, value):
    """
    Set for ccp.nmr.NmrCalc.SpectrumData.experimentSerial
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.setExperimentSerial:
         memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('experimentSerial')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setExperimentSerial:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setExperimentSerial:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['experimentSerial'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setExperimentSerial')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  setIoRole = Data.setIoRole

  setName = Data.setName

  setParameterGroup = Data.setParameterGroup

  setRunParameters = Data.setRunParameters

  setSerial = Data.setSerial

  sortedRunParameters = Data.sortedRunParameters

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  applicationData = memops.api.Implementation.DataObject.applicationData

  className = memops.api.Implementation.ComplexDataType.className

  code = Data.code
  
  dataSourceSerial = property(getDataSourceSerial, setDataSourceSerial, None,
  r"""serial for Nmr.DataSource holding data - used to derive actual object.
  """)

  details = Data.details
  
  experimentSerial = property(getExperimentSerial, setExperimentSerial, None,
  r"""serial for Nmr.Experiment holding data - used to derive actual object.
  """)

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor

  ioRole = Data.ioRole

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted

  metaclass = memops.api.Implementation.ComplexDataType.metaclass

  name = Data.name

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName

  serial = Data.serial

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess
  
  dataSource = property(getDataSource, setDataSource, None,
  r"""Nmr.DataSource used for data
  """)

  parameterGroup = Data.parameterGroup

  parent = Data.parent

  root = memops.api.Implementation.MemopsObject.root

  run = Data.run

  runParameters = Data.runParameters

  topObject = memops.api.Implementation.DataObject.topObject

###############################################################################
class MeasurementListData(Data):
  r"""Nmr.MeasurementList data.
  """
  #   from data model element ccp.nmr.NmrCalc.MeasurementListData revision ?
  _metaclass = metaPackage.getElement('MeasurementListData')
  _packageName = 'ccp.nmr.NmrCalc'
  _packageShortName = 'CALC'
  _fieldNames = ('applicationData', 'className', 'code', 'details', 'fieldNames', 'inConstructor', 'ioRole', 'isDeleted', 'measurementListSerial', 'metaclass', 'name', 'packageName', 'packageShortName', 'qualifiedName', 'serial', 'access', 'activeAccess', 'measurementList', 'parameterGroup', 'parent', 'root', 'run', 'runParameters', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for ccp.nmr.NmrCalc.MeasurementListData
    """
    dataDict = self.__dict__
    dataDict['run'] = parent
    if (not isinstance(parent, Run)):
      raise ApiError("""%s.__init__:
       value is not of class ccp.nmr.NmrCalc.Run""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = parent.__dict__.get('topObject')
    dataDict['topObject'] = topObject

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    if (notIsReading):
      if (not (topObject.__dict__.get('isModifiable'))):
        raise ApiError("""%s.__init__:
         Storage not modifiable""" % self.qualifiedName
         + ": %s" % (topObject,)
        )

    try:

      dataDict['applicationData'] = list()
      dataDict['code'] = None
      dataDict['details'] = None
      dataDict['ioRole'] = 'input'
      dataDict['measurementListSerial'] = None
      dataDict['name'] = None
      dataDict['serial'] = None
      dataDict['access'] = None
      dataDict['parameterGroup'] = None
      dataDict['runParameters'] = set()

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in ccp.nmr.NmrCalc.MeasurementListData.__init__"
        del dataDict['inConstructor']
        raise

      if (notOverride):
        if (dataDict.get('serial') is None):
          dataDict['inConstructor'] = True
          self.setSerial(-1)
          del dataDict['inConstructor']
        else:
          raise ApiError("""%s.__init__:
           Cannot pass in explicit serial if not reading""" % self.qualifiedName
           + ": %s:%s" % (parent, 'ccp.nmr.NmrCalc.MeasurementListData')
          )

      if (notIsReading):
        childrenDict = parent.__dict__.get('data')
        objKey = dataDict.get('serial')
        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['serial'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notOverride):
        self.checkValid()

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for ccp.nmr.NmrCalc.MeasurementListData:
       determines 
    cascading deletes to follow from delete of object.
       *Implementation 
    function* - should be called only by API delete function.
    """
    dataDict = self.__dict__
    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for ccp.nmr.NmrCalc.MeasurementListData:   deletes
    objects
    *Implementation function* - will CORRUPT DATA if called outside 
    the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    parameterGroup = dataDict.get('parameterGroup')
    if ((parameterGroup is not None and not (parameterGroup in objsToBeDeleted))):
      data = parameterGroup.__dict__.get('data')
      data.remove(self)

    for runParameter in dataDict.get('runParameters'):
      if (not (runParameter in objsToBeDeleted)):
        runParameter.__dict__['data'] = None

    run = dataDict.get('run')
    if (not (run in objsToBeDeleted)):
      objKey = dataDict.get('serial')
      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = run.__dict__.get('data')
        if (self is dd.get(objKey)):
          del dd[objKey]

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData

  addRunParameter = Data.addRunParameter
  
  def checkAllValid(self, complete=False):
    """
    CheckAllValid for ccp.nmr.NmrCalc.MeasurementListData
    """
    dataDict = self.__dict__
    self.checkValid(complete)
  
  def checkValid(self, complete=False):
    """
    CheckValid for ccp.nmr.NmrCalc.MeasurementListData
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      objKey = dataDict.get('serial')
      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('run')
        dd = value.__dict__.get('data')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'run' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      # check attributes
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('code')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: code:
           memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 32):
          raise ApiError("""%s.checkValid: code:
           memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: code:
           memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.split()) == 1)):
          raise ApiError("""%s.checkValid: code:
           Word constraint contains_no_white_space violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('details')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: details:
           memops.Implementation.Text input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 254):
          raise ApiError("""%s.checkValid: details:
           memops.Implementation.Text maximum length is 254 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: details:
           memops.Implementation.Text: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('ioRole')
      if (not (value in ['input', 'output'])):
        raise ApiError("""%s.checkValid: ioRole:
         ccp.nmr.NmrCalc.IoRole input is not in enumeration ['input', 'output']""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.checkValid: ioRole:
         IoRole constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('measurementListSerial')
      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.checkValid: measurementListSerial:
         memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('name')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: name:
           memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: name:
           memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: name:
           memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: name:
           Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('serial')
      if (value is None):
        raise ApiError("""%s.checkValid: serial:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.checkValid: serial:
         memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getMeasurementList()
      if (value is not None):
        from ccp.api.nmr.Nmr import AbstractMeasurementList as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: measurementList:
           value is not of class ccp.nmr.Nmr.AbstractMeasurementList""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: measurementList:
           Link measurementList between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('parameterGroup')
      if (value is not None):
        if (not isinstance(value, ParameterGroup)):
          raise ApiError("""%s.checkValid: parameterGroup:
           value is not of class ccp.nmr.NmrCalc.ParameterGroup""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('data')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: parameterGroup:
           non-reciprocal link parameterGroup from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      value = dataDict.get('run')
      if (not isinstance(value, Run)):
        raise ApiError("""%s.checkValid: run:
         value is not of class ccp.nmr.NmrCalc.Run""" % self.qualifiedName
         + ": %s" % (value,)
        )

      values = dataDict.get('runParameters')
      for value in values:
        if (not isinstance(value, RunParameter)):
          raise ApiError("""%s.checkValid: runParameters:
           value is not of class ccp.nmr.NmrCalc.RunParameter""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('data')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: runParameters:
           non-reciprocal link runParameters from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: runParameters:
           Link runParameters between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    # check explicit class constraints
    # check attributes
    values = dataDict.get('applicationData')
    for value in values:
      value.checkAllValid(complete)

    value = dataDict.get('code')
    value = dataDict.get('details')
    value = dataDict.get('ioRole')
    if (value is None):
      raise ApiError("""%s.checkValid: ioRole:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('measurementListSerial')
    if (value is None):
      raise ApiError("""%s.checkValid: measurementListSerial:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('name')
    # check roles
    value = dataDict.get('access')
    value = dataDict.get('parameterGroup')
    if (value is not None):
      isValid = True
      obj = self
      while obj is not None:
        obj = obj.parameterGroup
        if obj is self:
          isValid = False
          break
      if (not (isValid)):
        raise ApiError("""%s.checkValid: parameterGroup:
         parameterGroup constraint No_cyclical_parameter_grouping violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    value = dataDict.get('run')
    if (value is None):
      raise ApiError("""%s.checkValid: run:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    values = dataDict.get('runParameters')

  delete = memops.api.Implementation.DataObject.delete

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData

  findAllRunParameters = Data.findAllRunParameters

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData

  findFirstRunParameter = Data.findFirstRunParameter
  
  def get(self, name):
    """
    GetAttr for ccp.nmr.NmrCalc.MeasurementListData
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccp.nmr.NmrCalc.MeasurementListData
    """

    result = None
    if (startObj.__class__.__name__ == 'MemopsRoot'):
      if (4 != len(fullKey)):
        raise ApiError("""'ccp.nmr.NmrCalc.MeasurementListData'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj0 = startObj
      ll = list()
      objKey = fullKey[0]
      ll.append(objKey)
      if (objKey is not None):
        objKey = fullKey[1]
        ll.append(objKey)
        if (objKey is not None):
          objKey = tuple(ll)

      obj1 = obj0.__dict__.get('nmrCalcStores').get(objKey)
      if (obj1 is None):
        obj0.refreshTopObjects('ccp.nmr.NmrCalc')
        obj1 = obj0.__dict__.get('nmrCalcStores').get(objKey)

    else:
      if (2 != len(fullKey)):
        raise ApiError("""'ccp.nmr.NmrCalc.MeasurementListData'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj1 = startObj

    if (obj1 is not None):
      if (not (obj1.__dict__.get('isLoaded'))):
        obj1.load()

      objKey = fullKey[-2]
      obj2 = obj1.__dict__.get('runs').get(objKey)

      if (obj2 is not None):
        objKey = fullKey[-1]
        obj3 = obj2.__dict__.get('data').get(objKey)
        if (isinstance(obj3, MeasurementListData)):
          result = obj3

    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation

  getClassName = memops.api.Implementation.ComplexDataType.getClassName

  getCode = Data.getCode

  getDetails = Data.getDetails

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames

  getFullKey = Data.getFullKey

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor

  getIoRole = Data.getIoRole

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted

  getLocalKey = Data.getLocalKey
  
  def getMeasurementList(self):
    """
    getter for derived link measurementList
    """
    dataDict = self.__dict__
    result = self.topObject.nmrProject.findFirstMeasurementList(serial=self.measurementListSerial)
    return result
  
  def getMeasurementListSerial(self):
    """
    Get for ccp.nmr.NmrCalc.MeasurementListData.measurementListSerial
    """
    dataDict = self.__dict__
    result = dataDict.get('measurementListSerial')
    return result

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass

  getName = Data.getName

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName

  getParameterGroup = Data.getParameterGroup

  getParent = Data.getParent

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName

  getRoot = memops.api.Implementation.MemopsObject.getRoot

  getRun = Data.getRun

  getRunParameters = Data.getRunParameters

  getSerial = Data.getSerial

  getTopObject = memops.api.Implementation.DataObject.getTopObject

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData

  removeRunParameter = Data.removeRunParameter
  
  def set(self, name, value):
    """
    SetAttr for ccp.nmr.NmrCalc.MeasurementListData
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData

  setCode = Data.setCode

  setDetails = Data.setDetails

  setIoRole = Data.setIoRole
  
  def setMeasurementList(self, value):
    """
    setter for derived link measurementList
    """
    dataDict = self.__dict__
    if (value is not None):
      from ccp.api.nmr.Nmr import AbstractMeasurementList as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setMeasurementList:
         value is not of class ccp.nmr.Nmr.AbstractMeasurementList""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = self.getMeasurementList()
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setMeasurementList:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setMeasurementList:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setMeasurementList:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if value is None:
      self.measurementListSerial =None
    elif self.topObject.nmrProject is value.nmrProject:
      self.measurementListSerial = value.serial
    else:
      raise ApiError("%s does not belong to NmrCalcStore.nmrProject %s" % (value,self.topObject.nmrProject ))
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

  def setMeasurementListSerial(self, value):
    """
    Set for ccp.nmr.NmrCalc.MeasurementListData.measurementListSerial
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Int.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Int.create(value)
    else:
      raise ApiError("""%s.setMeasurementListSerial:
       memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('measurementListSerial')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setMeasurementListSerial:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setMeasurementListSerial:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setMeasurementListSerial:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['measurementListSerial'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setMeasurementListSerial')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  setName = Data.setName

  setParameterGroup = Data.setParameterGroup

  setRunParameters = Data.setRunParameters

  setSerial = Data.setSerial

  sortedRunParameters = Data.sortedRunParameters

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  applicationData = memops.api.Implementation.DataObject.applicationData

  className = memops.api.Implementation.ComplexDataType.className

  code = Data.code

  details = Data.details

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor

  ioRole = Data.ioRole

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted
  
  measurementListSerial = property(getMeasurementListSerial, setMeasurementListSerial, None,
  r"""Serial number of Nmr.AbstractMeasurementList - used to derive actual 
  object.
  """)

  metaclass = memops.api.Implementation.ComplexDataType.metaclass

  name = Data.name

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName

  serial = Data.serial

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess
  
  measurementList = property(getMeasurementList, setMeasurementList, None,
  r"""MeasurementList used for data
  """)

  parameterGroup = Data.parameterGroup

  parent = Data.parent

  root = memops.api.Implementation.MemopsObject.root

  run = Data.run

  runParameters = Data.runParameters

  topObject = memops.api.Implementation.DataObject.topObject

###############################################################################
class ExternalData(Data):
  r"""Unit of data from external file
  """
  #   from data model element ccp.nmr.NmrCalc.ExternalData revision ?
  _metaclass = metaPackage.getElement('ExternalData')
  _packageName = 'ccp.nmr.NmrCalc'
  _packageShortName = 'CALC'
  _fieldNames = ('applicationData', 'className', 'code', 'dataLocationStoreName', 'dataStoreSerial', 'details', 'fieldNames', 'inConstructor', 'ioRole', 'isDeleted', 'metaclass', 'name', 'packageName', 'packageShortName', 'qualifiedName', 'serial', 'access', 'activeAccess', 'dataStore', 'parameterGroup', 'parent', 'root', 'run', 'runParameters', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for ccp.nmr.NmrCalc.ExternalData
    """
    dataDict = self.__dict__
    dataDict['run'] = parent
    if (not isinstance(parent, Run)):
      raise ApiError("""%s.__init__:
       value is not of class ccp.nmr.NmrCalc.Run""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = parent.__dict__.get('topObject')
    dataDict['topObject'] = topObject

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    if (notIsReading):
      if (not (topObject.__dict__.get('isModifiable'))):
        raise ApiError("""%s.__init__:
         Storage not modifiable""" % self.qualifiedName
         + ": %s" % (topObject,)
        )

    try:

      dataDict['applicationData'] = list()
      dataDict['code'] = None
      dataDict['dataLocationStoreName'] = None
      dataDict['dataStoreSerial'] = None
      dataDict['details'] = None
      dataDict['ioRole'] = 'input'
      dataDict['name'] = None
      dataDict['serial'] = None
      dataDict['access'] = None
      dataDict['parameterGroup'] = None
      dataDict['runParameters'] = set()

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in ccp.nmr.NmrCalc.ExternalData.__init__"
        del dataDict['inConstructor']
        raise

      if (notOverride):
        if (dataDict.get('serial') is None):
          dataDict['inConstructor'] = True
          self.setSerial(-1)
          del dataDict['inConstructor']
        else:
          raise ApiError("""%s.__init__:
           Cannot pass in explicit serial if not reading""" % self.qualifiedName
           + ": %s:%s" % (parent, 'ccp.nmr.NmrCalc.ExternalData')
          )

      if (notIsReading):
        childrenDict = parent.__dict__.get('data')
        objKey = dataDict.get('serial')
        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['serial'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notOverride):
        self.checkValid()

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for ccp.nmr.NmrCalc.ExternalData:
       determines cascading 
    deletes to follow from delete of object.
       *Implementation function* - 
    should be called only by API delete function.
    """
    dataDict = self.__dict__
    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for ccp.nmr.NmrCalc.ExternalData:   deletes
    objects
    *Implementation function* - will CORRUPT DATA if called outside 
    the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    parameterGroup = dataDict.get('parameterGroup')
    if ((parameterGroup is not None and not (parameterGroup in objsToBeDeleted))):
      data = parameterGroup.__dict__.get('data')
      data.remove(self)

    for runParameter in dataDict.get('runParameters'):
      if (not (runParameter in objsToBeDeleted)):
        runParameter.__dict__['data'] = None

    run = dataDict.get('run')
    if (not (run in objsToBeDeleted)):
      objKey = dataDict.get('serial')
      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = run.__dict__.get('data')
        if (self is dd.get(objKey)):
          del dd[objKey]

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData

  addRunParameter = Data.addRunParameter
  
  def checkAllValid(self, complete=False):
    """
    CheckAllValid for ccp.nmr.NmrCalc.ExternalData
    """
    dataDict = self.__dict__
    self.checkValid(complete)
  
  def checkValid(self, complete=False):
    """
    CheckValid for ccp.nmr.NmrCalc.ExternalData
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      objKey = dataDict.get('serial')
      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('run')
        dd = value.__dict__.get('data')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'run' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      # check attributes
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('code')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: code:
           memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 32):
          raise ApiError("""%s.checkValid: code:
           memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: code:
           memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.split()) == 1)):
          raise ApiError("""%s.checkValid: code:
           Word constraint contains_no_white_space violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('dataLocationStoreName')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: dataLocationStoreName:
           memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: dataLocationStoreName:
           memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: dataLocationStoreName:
           memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: dataLocationStoreName:
           Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('dataStoreSerial')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.Int.PythonType)):
          pass
        elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
          value = memops.api.Implementation.Int.create(value)
        else:
          raise ApiError("""%s.checkValid: dataStoreSerial:
           memops.Implementation.PositiveInt input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (value > 0)):
          raise ApiError("""%s.checkValid: dataStoreSerial:
           PositiveInt constraint int_value_gt_0 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('details')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: details:
           memops.Implementation.Text input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 254):
          raise ApiError("""%s.checkValid: details:
           memops.Implementation.Text maximum length is 254 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: details:
           memops.Implementation.Text: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('ioRole')
      if (not (value in ['input', 'output'])):
        raise ApiError("""%s.checkValid: ioRole:
         ccp.nmr.NmrCalc.IoRole input is not in enumeration ['input', 'output']""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.checkValid: ioRole:
         IoRole constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('name')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: name:
           memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: name:
           memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: name:
           memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: name:
           Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('serial')
      if (value is None):
        raise ApiError("""%s.checkValid: serial:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.checkValid: serial:
         memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getDataStore()
      if (value is not None):
        from ccp.api.general.DataLocation import AbstractDataStore as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: dataStore:
           value is not of class ccp.general.DataLocation.AbstractDataStore""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: dataStore:
           Link dataStore between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('parameterGroup')
      if (value is not None):
        if (not isinstance(value, ParameterGroup)):
          raise ApiError("""%s.checkValid: parameterGroup:
           value is not of class ccp.nmr.NmrCalc.ParameterGroup""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('data')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: parameterGroup:
           non-reciprocal link parameterGroup from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      value = dataDict.get('run')
      if (not isinstance(value, Run)):
        raise ApiError("""%s.checkValid: run:
         value is not of class ccp.nmr.NmrCalc.Run""" % self.qualifiedName
         + ": %s" % (value,)
        )

      values = dataDict.get('runParameters')
      for value in values:
        if (not isinstance(value, RunParameter)):
          raise ApiError("""%s.checkValid: runParameters:
           value is not of class ccp.nmr.NmrCalc.RunParameter""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('data')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: runParameters:
           non-reciprocal link runParameters from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: runParameters:
           Link runParameters between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    # check explicit class constraints
    # check attributes
    values = dataDict.get('applicationData')
    for value in values:
      value.checkAllValid(complete)

    value = dataDict.get('code')
    value = dataDict.get('dataLocationStoreName')
    value = dataDict.get('dataStoreSerial')
    value = dataDict.get('details')
    value = dataDict.get('ioRole')
    if (value is None):
      raise ApiError("""%s.checkValid: ioRole:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('name')
    # check roles
    value = dataDict.get('access')
    value = dataDict.get('parameterGroup')
    if (value is not None):
      isValid = True
      obj = self
      while obj is not None:
        obj = obj.parameterGroup
        if obj is self:
          isValid = False
          break
      if (not (isValid)):
        raise ApiError("""%s.checkValid: parameterGroup:
         parameterGroup constraint No_cyclical_parameter_grouping violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    value = dataDict.get('run')
    if (value is None):
      raise ApiError("""%s.checkValid: run:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    values = dataDict.get('runParameters')

  delete = memops.api.Implementation.DataObject.delete

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData

  findAllRunParameters = Data.findAllRunParameters

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData

  findFirstRunParameter = Data.findFirstRunParameter
  
  def get(self, name):
    """
    GetAttr for ccp.nmr.NmrCalc.ExternalData
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccp.nmr.NmrCalc.ExternalData
    """

    result = None
    if (startObj.__class__.__name__ == 'MemopsRoot'):
      if (4 != len(fullKey)):
        raise ApiError("""'ccp.nmr.NmrCalc.ExternalData'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj0 = startObj
      ll = list()
      objKey = fullKey[0]
      ll.append(objKey)
      if (objKey is not None):
        objKey = fullKey[1]
        ll.append(objKey)
        if (objKey is not None):
          objKey = tuple(ll)

      obj1 = obj0.__dict__.get('nmrCalcStores').get(objKey)
      if (obj1 is None):
        obj0.refreshTopObjects('ccp.nmr.NmrCalc')
        obj1 = obj0.__dict__.get('nmrCalcStores').get(objKey)

    else:
      if (2 != len(fullKey)):
        raise ApiError("""'ccp.nmr.NmrCalc.ExternalData'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj1 = startObj

    if (obj1 is not None):
      if (not (obj1.__dict__.get('isLoaded'))):
        obj1.load()

      objKey = fullKey[-2]
      obj2 = obj1.__dict__.get('runs').get(objKey)

      if (obj2 is not None):
        objKey = fullKey[-1]
        obj3 = obj2.__dict__.get('data').get(objKey)
        if (isinstance(obj3, ExternalData)):
          result = obj3

    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation

  getClassName = memops.api.Implementation.ComplexDataType.getClassName

  getCode = Data.getCode
  
  def getDataLocationStoreName(self):
    """
    Get for ccp.nmr.NmrCalc.ExternalData.dataLocationStoreName
    """
    dataDict = self.__dict__
    result = dataDict.get('dataLocationStoreName')
    return result
  
  def getDataStore(self):
    """
    getter for derived link dataStore
    """
    dataDict = self.__dict__
    result = ccp.api.general.DataLocation.AbstractDataStore.getByKey(self.root, (self.dataLocationStoreName, self.dataStoreSerial))
    return result
  
  def getDataStoreSerial(self):
    """
    Get for ccp.nmr.NmrCalc.ExternalData.dataStoreSerial
    """
    dataDict = self.__dict__
    result = dataDict.get('dataStoreSerial')
    return result

  getDetails = Data.getDetails

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames

  getFullKey = Data.getFullKey

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor

  getIoRole = Data.getIoRole

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted

  getLocalKey = Data.getLocalKey

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass

  getName = Data.getName

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName

  getParameterGroup = Data.getParameterGroup

  getParent = Data.getParent

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName

  getRoot = memops.api.Implementation.MemopsObject.getRoot

  getRun = Data.getRun

  getRunParameters = Data.getRunParameters

  getSerial = Data.getSerial

  getTopObject = memops.api.Implementation.DataObject.getTopObject

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData

  removeRunParameter = Data.removeRunParameter
  
  def set(self, name, value):
    """
    SetAttr for ccp.nmr.NmrCalc.ExternalData
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData

  setCode = Data.setCode
  
  def setDataLocationStoreName(self, value):
    """
    Set for ccp.nmr.NmrCalc.ExternalData.dataLocationStoreName
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setDataLocationStoreName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.setDataLocationStoreName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setDataLocationStoreName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.setDataLocationStoreName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('dataLocationStoreName')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setDataLocationStoreName:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setDataLocationStoreName:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['dataLocationStoreName'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setDataLocationStoreName')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setDataStore(self, value):
    """
    setter for derived link dataStore
    """
    dataDict = self.__dict__
    if (value is not None):
      from ccp.api.general.DataLocation import AbstractDataStore as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setDataStore:
         value is not of class ccp.general.DataLocation.AbstractDataStore""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = self.getDataStore()
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setDataStore:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setDataStore:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setDataStore:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if value is None:
      self.dataLocationStoreName = None
      self.dataStoreSerial = None
    else:
      self.dataLocationStoreName = value.dataLocationStore.name
      self.dataStoreSerial = value.serial
    
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

  def setDataStoreSerial(self, value):
    """
    Set for ccp.nmr.NmrCalc.ExternalData.dataStoreSerial
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.setDataStoreSerial:
         memops.Implementation.PositiveInt input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value > 0)):
        raise ApiError("""%s.setDataStoreSerial:
         PositiveInt constraint int_value_gt_0 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('dataStoreSerial')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setDataStoreSerial:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setDataStoreSerial:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['dataStoreSerial'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setDataStoreSerial')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  setDetails = Data.setDetails

  setIoRole = Data.setIoRole

  setName = Data.setName

  setParameterGroup = Data.setParameterGroup

  setRunParameters = Data.setRunParameters

  setSerial = Data.setSerial

  sortedRunParameters = Data.sortedRunParameters

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  applicationData = memops.api.Implementation.DataObject.applicationData

  className = memops.api.Implementation.ComplexDataType.className

  code = Data.code
  
  dataLocationStoreName = property(getDataLocationStoreName, setDataLocationStoreName, None,
  r"""Name oif DataLocationStore pointed to by Object. Part of key for derived 
  link dataStore
  """)
  
  dataStoreSerial = property(getDataStoreSerial, setDataStoreSerial, None,
  r"""Serial for DataStore pointed to by Object. Part of key for derived link 
  dataStore
  """)

  details = Data.details

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor

  ioRole = Data.ioRole

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted

  metaclass = memops.api.Implementation.ComplexDataType.metaclass

  name = Data.name

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName

  serial = Data.serial

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess
  
  dataStore = property(getDataStore, setDataStore, None,
  r"""Storage location for data file
  """)

  parameterGroup = Data.parameterGroup

  parent = Data.parent

  root = memops.api.Implementation.MemopsObject.root

  run = Data.run

  runParameters = Data.runParameters

  topObject = memops.api.Implementation.DataObject.topObject

###############################################################################
class ConstraintStoreData(Data):
  r"""nmr Calculation data - ConstrantStore and sets of ConstraintLists
  """
  #   from data model element ccp.nmr.NmrCalc.ConstraintStoreData revision ?
  _metaclass = metaPackage.getElement('ConstraintStoreData')
  _packageName = 'ccp.nmr.NmrCalc'
  _packageShortName = 'CALC'
  _fieldNames = ('applicationData', 'className', 'code', 'constraintListSerials', 'constraintStoreSerial', 'details', 'fieldNames', 'inConstructor', 'ioRole', 'isDeleted', 'metaclass', 'name', 'packageName', 'packageShortName', 'qualifiedName', 'serial', 'access', 'activeAccess', 'constraintLists', 'nmrConstraintStore', 'parameterGroup', 'parent', 'root', 'run', 'runParameters', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for ccp.nmr.NmrCalc.ConstraintStoreData
    """
    dataDict = self.__dict__
    dataDict['run'] = parent
    if (not isinstance(parent, Run)):
      raise ApiError("""%s.__init__:
       value is not of class ccp.nmr.NmrCalc.Run""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = parent.__dict__.get('topObject')
    dataDict['topObject'] = topObject

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    if (notIsReading):
      if (not (topObject.__dict__.get('isModifiable'))):
        raise ApiError("""%s.__init__:
         Storage not modifiable""" % self.qualifiedName
         + ": %s" % (topObject,)
        )

    try:

      dataDict['applicationData'] = list()
      dataDict['code'] = None
      dataDict['constraintListSerials'] = list()
      dataDict['constraintStoreSerial'] = None
      dataDict['details'] = None
      dataDict['ioRole'] = 'input'
      dataDict['name'] = None
      dataDict['serial'] = None
      dataDict['access'] = None
      dataDict['parameterGroup'] = None
      dataDict['runParameters'] = set()

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in ccp.nmr.NmrCalc.ConstraintStoreData.__init__"
        del dataDict['inConstructor']
        raise

      if (notOverride):
        if (dataDict.get('serial') is None):
          dataDict['inConstructor'] = True
          self.setSerial(-1)
          del dataDict['inConstructor']
        else:
          raise ApiError("""%s.__init__:
           Cannot pass in explicit serial if not reading""" % self.qualifiedName
           + ": %s:%s" % (parent, 'ccp.nmr.NmrCalc.ConstraintStoreData')
          )

      if (notIsReading):
        childrenDict = parent.__dict__.get('data')
        objKey = dataDict.get('serial')
        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['serial'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notOverride):
        self.checkValid()

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for ccp.nmr.NmrCalc.ConstraintStoreData:
       determines 
    cascading deletes to follow from delete of object.
       *Implementation 
    function* - should be called only by API delete function.
    """
    dataDict = self.__dict__
    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for ccp.nmr.NmrCalc.ConstraintStoreData:   deletes
    objects
    *Implementation function* - will CORRUPT DATA if called outside 
    the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    parameterGroup = dataDict.get('parameterGroup')
    if ((parameterGroup is not None and not (parameterGroup in objsToBeDeleted))):
      data = parameterGroup.__dict__.get('data')
      data.remove(self)

    for runParameter in dataDict.get('runParameters'):
      if (not (runParameter in objsToBeDeleted)):
        runParameter.__dict__['data'] = None

    run = dataDict.get('run')
    if (not (run in objsToBeDeleted)):
      objKey = dataDict.get('serial')
      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = run.__dict__.get('data')
        if (self is dd.get(objKey)):
          del dd[objKey]

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData
  
  def addConstraintList(self, value):
    """
    Add for ccp.nmr.NmrCalc.ConstraintStoreData.constraintLists
    """
    dataDict = self.__dict__
    from ccp.api.nmr.NmrConstraint import AbstractConstraintList as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.addConstraintList:
       value is not of class ccp.nmr.NmrConstraint.AbstractConstraintList""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = self.getConstraintLists()
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.addConstraintList:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.addConstraintList:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.addConstraintList:
       called with deleted value""" % self.qualifiedName
      )

    if (value in currentValues):
      raise ApiError("""%s.addConstraintList:
       value is in list already""" % self.qualifiedName
       + ": %s" % (self,)
      )

    newValues = list(currentValues)
    newValues.append(value)
    self.setConstraintLists(newValues)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

  def addConstraintListSerial(self, value):
    """
    Add for ccp.nmr.NmrCalc.ConstraintStoreData.constraintListSerials
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Int.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Int.create(value)
    else:
      raise ApiError("""%s.addConstraintListSerial:
       memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('constraintListSerials')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.addConstraintListSerial:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.addConstraintListSerial:
       called on deleted object""" % self.qualifiedName
      )

    if (value in currentValues):
      raise ApiError("""%s.addConstraintListSerial:
       value is in list already""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      pass

    currentValues.append(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('addConstraintListSerial')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  addRunParameter = Data.addRunParameter
  
  def checkAllValid(self, complete=False):
    """
    CheckAllValid for ccp.nmr.NmrCalc.ConstraintStoreData
    """
    dataDict = self.__dict__
    self.checkValid(complete)
  
  def checkValid(self, complete=False):
    """
    CheckValid for ccp.nmr.NmrCalc.ConstraintStoreData
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      objKey = dataDict.get('serial')
      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('run')
        dd = value.__dict__.get('data')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'run' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      # check attributes
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('code')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: code:
           memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 32):
          raise ApiError("""%s.checkValid: code:
           memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: code:
           memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.split()) == 1)):
          raise ApiError("""%s.checkValid: code:
           Word constraint contains_no_white_space violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      values = dataDict.get('constraintListSerials')
      for value in values:
        if (isinstance(value, memops.api.Implementation.Int.PythonType)):
          pass
        elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
          castValue = memops.api.Implementation.Int.create(value)
          replaceIndex = values.index(value)
          values[replaceIndex] = None
          if (castValue in values):
            values[replaceIndex] = value
            raise ApiError("""%s.checkValid: constraintListSerials:
             replacement value already in unique collection """ % self.qualifiedName
             + ": %s" % (castValue,)
            )
          else:
            values[replaceIndex] = castValue

          value = castValue
        else:
          raise ApiError("""%s.checkValid: constraintListSerials:
           memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('constraintStoreSerial')
      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.checkValid: constraintStoreSerial:
         memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('details')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: details:
           memops.Implementation.Text input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 254):
          raise ApiError("""%s.checkValid: details:
           memops.Implementation.Text maximum length is 254 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: details:
           memops.Implementation.Text: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('ioRole')
      if (not (value in ['input', 'output'])):
        raise ApiError("""%s.checkValid: ioRole:
         ccp.nmr.NmrCalc.IoRole input is not in enumeration ['input', 'output']""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.checkValid: ioRole:
         IoRole constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('name')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: name:
           memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: name:
           memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: name:
           memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: name:
           Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('serial')
      if (value is None):
        raise ApiError("""%s.checkValid: serial:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.checkValid: serial:
         memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      values = self.getConstraintLists()
      for value in values:
        from ccp.api.nmr.NmrConstraint import AbstractConstraintList as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: constraintLists:
           value is not of class ccp.nmr.NmrConstraint.AbstractConstraintList""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: constraintLists:
           Link constraintLists between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getNmrConstraintStore()
      if (value is not None):
        from ccp.api.nmr.NmrConstraint import NmrConstraintStore as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: nmrConstraintStore:
           value is not of class ccp.nmr.NmrConstraint.NmrConstraintStore""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: nmrConstraintStore:
           Link nmrConstraintStore between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('parameterGroup')
      if (value is not None):
        if (not isinstance(value, ParameterGroup)):
          raise ApiError("""%s.checkValid: parameterGroup:
           value is not of class ccp.nmr.NmrCalc.ParameterGroup""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('data')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: parameterGroup:
           non-reciprocal link parameterGroup from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      value = dataDict.get('run')
      if (not isinstance(value, Run)):
        raise ApiError("""%s.checkValid: run:
         value is not of class ccp.nmr.NmrCalc.Run""" % self.qualifiedName
         + ": %s" % (value,)
        )

      values = dataDict.get('runParameters')
      for value in values:
        if (not isinstance(value, RunParameter)):
          raise ApiError("""%s.checkValid: runParameters:
           value is not of class ccp.nmr.NmrCalc.RunParameter""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('data')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: runParameters:
           non-reciprocal link runParameters from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: runParameters:
           Link runParameters between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    # check explicit class constraints
    # check attributes
    values = dataDict.get('applicationData')
    for value in values:
      value.checkAllValid(complete)

    value = dataDict.get('code')
    values = dataDict.get('constraintListSerials')
    value = dataDict.get('constraintStoreSerial')
    if (value is None):
      raise ApiError("""%s.checkValid: constraintStoreSerial:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('details')
    value = dataDict.get('ioRole')
    if (value is None):
      raise ApiError("""%s.checkValid: ioRole:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('name')
    # check roles
    value = dataDict.get('access')
    value = dataDict.get('parameterGroup')
    if (value is not None):
      isValid = True
      obj = self
      while obj is not None:
        obj = obj.parameterGroup
        if obj is self:
          isValid = False
          break
      if (not (isValid)):
        raise ApiError("""%s.checkValid: parameterGroup:
         parameterGroup constraint No_cyclical_parameter_grouping violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    value = dataDict.get('run')
    if (value is None):
      raise ApiError("""%s.checkValid: run:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    values = dataDict.get('runParameters')

  delete = memops.api.Implementation.DataObject.delete

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData
  
  def findAllConstraintLists(self, **conditions):
    """
    FindAll for ccp.nmr.NmrCalc.ConstraintStoreData.constraintLists
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = self.getConstraintLists()
      result = list(currentValues)

    else:
      currentValues = self.getConstraintLists()
      result = list()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('details', 'name', 'serial', 'unit', 'usedForCalculation', 'access', 'conditionState', 'method', 'nmrConstraintStore',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.append(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.append(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.append(v)

    return result

  findAllRunParameters = Data.findAllRunParameters

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData
  
  def findFirstConstraintList(self, **conditions):
    """
    FindFirst for ccp.nmr.NmrCalc.ConstraintStoreData.constraintLists
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = self.getConstraintLists()
      if (currentValues):
        result = currentValues[0]
      else:
        result = None

    else:
      currentValues = self.getConstraintLists()
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('details', 'name', 'serial', 'unit', 'usedForCalculation', 'access', 'conditionState', 'method', 'nmrConstraintStore',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result

  findFirstRunParameter = Data.findFirstRunParameter
  
  def get(self, name):
    """
    GetAttr for ccp.nmr.NmrCalc.ConstraintStoreData
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccp.nmr.NmrCalc.ConstraintStoreData
    """

    result = None
    if (startObj.__class__.__name__ == 'MemopsRoot'):
      if (4 != len(fullKey)):
        raise ApiError("""'ccp.nmr.NmrCalc.ConstraintStoreData'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj0 = startObj
      ll = list()
      objKey = fullKey[0]
      ll.append(objKey)
      if (objKey is not None):
        objKey = fullKey[1]
        ll.append(objKey)
        if (objKey is not None):
          objKey = tuple(ll)

      obj1 = obj0.__dict__.get('nmrCalcStores').get(objKey)
      if (obj1 is None):
        obj0.refreshTopObjects('ccp.nmr.NmrCalc')
        obj1 = obj0.__dict__.get('nmrCalcStores').get(objKey)

    else:
      if (2 != len(fullKey)):
        raise ApiError("""'ccp.nmr.NmrCalc.ConstraintStoreData'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj1 = startObj

    if (obj1 is not None):
      if (not (obj1.__dict__.get('isLoaded'))):
        obj1.load()

      objKey = fullKey[-2]
      obj2 = obj1.__dict__.get('runs').get(objKey)

      if (obj2 is not None):
        objKey = fullKey[-1]
        obj3 = obj2.__dict__.get('data').get(objKey)
        if (isinstance(obj3, ConstraintStoreData)):
          result = obj3

    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation

  getClassName = memops.api.Implementation.ComplexDataType.getClassName

  getCode = Data.getCode
  
  def getConstraintListSerials(self):
    """
    Get for ccp.nmr.NmrCalc.ConstraintStoreData.constraintListSerials
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('constraintListSerials')
    result = tuple(tempVar)
    return result
  
  def getConstraintLists(self):
    """
    getter for derived link constraintLists
    """
    dataDict = self.__dict__
    ncstore = self.root.findFirstNmrConstraintStore(serial=self.constraintStoreSerial)
    if ncstore:
      serials = self.constraintListSerials
      if serials:
        result = tuple(ncstore.findFirstConstraintList(serial=x) for x in serials if x is not None)
      else:
        result = tuple(ncstore.sortedConstraintLists())
    else:
      result = tuple()
    return result
  
  def getConstraintStoreSerial(self):
    """
    Get for ccp.nmr.NmrCalc.ConstraintStoreData.constraintStoreSerial
    """
    dataDict = self.__dict__
    result = dataDict.get('constraintStoreSerial')
    return result

  getDetails = Data.getDetails

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames

  getFullKey = Data.getFullKey

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor

  getIoRole = Data.getIoRole

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted

  getLocalKey = Data.getLocalKey

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass

  getName = Data.getName
  
  def getNmrConstraintStore(self):
    """
    getter for derived link nmrConstraintStore
    """
    dataDict = self.__dict__
    result = self.root.findFirstNmrConstraintStore(serial=self.constraintStoreSerial)
    return result

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName

  getParameterGroup = Data.getParameterGroup

  getParent = Data.getParent

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName

  getRoot = memops.api.Implementation.MemopsObject.getRoot

  getRun = Data.getRun

  getRunParameters = Data.getRunParameters

  getSerial = Data.getSerial

  getTopObject = memops.api.Implementation.DataObject.getTopObject

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData
  
  def removeConstraintList(self, value):
    """
    Remove for ccp.nmr.NmrCalc.ConstraintStoreData.constraintLists
    """
    dataDict = self.__dict__
    from ccp.api.nmr.NmrConstraint import AbstractConstraintList as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.removeConstraintList:
       value is not of class ccp.nmr.NmrConstraint.AbstractConstraintList""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = self.getConstraintLists()
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.removeConstraintList:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.removeConstraintList:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.removeConstraintList:
       called with deleted value""" % self.qualifiedName
      )

    if (not (value in currentValues)):
      raise ApiError("""%s.removeConstraintList:
       value not in list""" % self.qualifiedName
       + ": %s" % (self,)
      )

    newValues = list(currentValues)
    newValues.remove(value)
    self.setConstraintLists(newValues)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

  def removeConstraintListSerial(self, value):
    """
    Remove for ccp.nmr.NmrCalc.ConstraintStoreData.constraintListSerials
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Int.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Int.create(value)
    else:
      raise ApiError("""%s.removeConstraintListSerial:
       memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('constraintListSerials')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.removeConstraintListSerial:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.removeConstraintListSerial:
       called on deleted object""" % self.qualifiedName
      )

    if (not (value in currentValues)):
      raise ApiError("""%s.removeConstraintListSerial:
       value not in list""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      pass

    currentValues.remove(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('removeConstraintListSerial')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  removeRunParameter = Data.removeRunParameter
  
  def set(self, name, value):
    """
    SetAttr for ccp.nmr.NmrCalc.ConstraintStoreData
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData

  setCode = Data.setCode
  
  def setConstraintListSerials(self, values):
    """
    Set for ccp.nmr.NmrCalc.ConstraintStoreData.constraintListSerials
    """
    dataDict = self.__dict__
    xx = set(values)
    values = list(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setConstraintListSerials:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        castValue = memops.api.Implementation.Int.create(value)
        replaceIndex = values.index(value)
        values[replaceIndex] = None
        if (castValue in values):
          values[replaceIndex] = value
          raise ApiError("""%s.setConstraintListSerials:
           replacement value already in unique collection """ % self.qualifiedName
           + ": %s" % (castValue,)
          )
        else:
          values[replaceIndex] = castValue

        value = castValue
      else:
        raise ApiError("""%s.setConstraintListSerials:
         memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('constraintListSerials')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setConstraintListSerials:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setConstraintListSerials:
       called on deleted object""" % self.qualifiedName
      )

    if (values == currentValues):
      return

    if (notOverride):
      pass

    dataDict['constraintListSerials'] = values
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setConstraintListSerials')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setConstraintLists(self, values):
    """
    setter for derived link constraintLists
    """
    dataDict = self.__dict__
    xx = set(values)
    values = list(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setConstraintLists:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      from ccp.api.nmr.NmrConstraint import AbstractConstraintList as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setConstraintLists:
         value is not of class ccp.nmr.NmrConstraint.AbstractConstraintList""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValues = self.getConstraintLists()
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setConstraintLists:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setConstraintLists:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setConstraintLists:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if values:
      stores = set(x.nmrConstraintStore for x in values)
      if len(stores) == 1:
        self.constraintStoreSerial = stores.pop().serial
        self.constraintListSerials = [x.serial for x in values]
      else:
        raise ApiError("ConstraintLists are from different NmrConstraintStores: %s" % values)
    else:
      self.constraintListSerials = ()
      self.constraintStoreSerial = None
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

  def setConstraintStoreSerial(self, value):
    """
    Set for ccp.nmr.NmrCalc.ConstraintStoreData.constraintStoreSerial
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Int.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Int.create(value)
    else:
      raise ApiError("""%s.setConstraintStoreSerial:
       memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('constraintStoreSerial')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setConstraintStoreSerial:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setConstraintStoreSerial:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setConstraintStoreSerial:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['constraintStoreSerial'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setConstraintStoreSerial')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  setDetails = Data.setDetails

  setIoRole = Data.setIoRole

  setName = Data.setName
  
  def setNmrConstraintStore(self, value):
    """
    setter for derived link nmrConstraintStore. Sets constraintLists to
    'all'
    """
    dataDict = self.__dict__
    if (value is not None):
      from ccp.api.nmr.NmrConstraint import NmrConstraintStore as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setNmrConstraintStore:
         value is not of class ccp.nmr.NmrConstraint.NmrConstraintStore""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = self.getNmrConstraintStore()
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setNmrConstraintStore:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setNmrConstraintStore:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setNmrConstraintStore:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if value is None:
        self.constraintStoreSerial = None
        self.constraintListSerials = ()
    
    elif self.topObject.nmrProject is value.nmrProject:
      if self.constraintStoreSerial != value.serial:
        self.constraintStoreSerial = value.serial
        self.constraintListSerials = ()
    else:
      raise ApiError("%s does not belong to NmrCalcStore.nmrProject %s" % (value,self.topObject.nmrProject ))
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

  setParameterGroup = Data.setParameterGroup

  setRunParameters = Data.setRunParameters

  setSerial = Data.setSerial

  sortedRunParameters = Data.sortedRunParameters

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  applicationData = memops.api.Implementation.DataObject.applicationData

  className = memops.api.Implementation.ComplexDataType.className

  code = Data.code
  
  constraintListSerials = property(getConstraintListSerials, setConstraintListSerials, None,
  r"""serials for ConstraintLists containing data - if empty use all available 
  ConstraintLists
  """)
  
  constraintStoreSerial = property(getConstraintStoreSerial, setConstraintStoreSerial, None,
  r"""serial of NmrConstraintStore containing data - used to derive actual 
  object.
  """)

  details = Data.details

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor

  ioRole = Data.ioRole

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted

  metaclass = memops.api.Implementation.ComplexDataType.metaclass

  name = Data.name

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName

  serial = Data.serial

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess
  
  constraintLists = property(getConstraintLists, setConstraintLists, None,
  r"""NmrConstraint.ConstraintLists containing data
  """)
  
  nmrConstraintStore = property(getNmrConstraintStore, setNmrConstraintStore, None,
  r"""NmrConstraintStore with constraint data
  """)

  parameterGroup = Data.parameterGroup

  parent = Data.parent

  root = memops.api.Implementation.MemopsObject.root

  run = Data.run

  runParameters = Data.runParameters

  topObject = memops.api.Implementation.DataObject.topObject

###############################################################################
class DerivedListData(Data):
  r"""Nmr.DerivedDataList data
  """
  #   from data model element ccp.nmr.NmrCalc.DerivedListData revision ?
  _metaclass = metaPackage.getElement('DerivedListData')
  _packageName = 'ccp.nmr.NmrCalc'
  _packageShortName = 'CALC'
  _fieldNames = ('applicationData', 'className', 'code', 'derivedDataListSerial', 'details', 'fieldNames', 'inConstructor', 'ioRole', 'isDeleted', 'metaclass', 'name', 'packageName', 'packageShortName', 'qualifiedName', 'serial', 'access', 'activeAccess', 'derivedDataList', 'parameterGroup', 'parent', 'root', 'run', 'runParameters', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for ccp.nmr.NmrCalc.DerivedListData
    """
    dataDict = self.__dict__
    dataDict['run'] = parent
    if (not isinstance(parent, Run)):
      raise ApiError("""%s.__init__:
       value is not of class ccp.nmr.NmrCalc.Run""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = parent.__dict__.get('topObject')
    dataDict['topObject'] = topObject

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    if (notIsReading):
      if (not (topObject.__dict__.get('isModifiable'))):
        raise ApiError("""%s.__init__:
         Storage not modifiable""" % self.qualifiedName
         + ": %s" % (topObject,)
        )

    try:

      dataDict['applicationData'] = list()
      dataDict['code'] = None
      dataDict['derivedDataListSerial'] = None
      dataDict['details'] = None
      dataDict['ioRole'] = 'input'
      dataDict['name'] = None
      dataDict['serial'] = None
      dataDict['access'] = None
      dataDict['parameterGroup'] = None
      dataDict['runParameters'] = set()

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in ccp.nmr.NmrCalc.DerivedListData.__init__"
        del dataDict['inConstructor']
        raise

      if (notOverride):
        if (dataDict.get('serial') is None):
          dataDict['inConstructor'] = True
          self.setSerial(-1)
          del dataDict['inConstructor']
        else:
          raise ApiError("""%s.__init__:
           Cannot pass in explicit serial if not reading""" % self.qualifiedName
           + ": %s:%s" % (parent, 'ccp.nmr.NmrCalc.DerivedListData')
          )

      if (notIsReading):
        childrenDict = parent.__dict__.get('data')
        objKey = dataDict.get('serial')
        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['serial'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notOverride):
        self.checkValid()

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for ccp.nmr.NmrCalc.DerivedListData:
       determines cascading 
    deletes to follow from delete of object.
       *Implementation function* - 
    should be called only by API delete function.
    """
    dataDict = self.__dict__
    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for ccp.nmr.NmrCalc.DerivedListData:   deletes
    objects
    *Implementation function* - will CORRUPT DATA if called outside 
    the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    parameterGroup = dataDict.get('parameterGroup')
    if ((parameterGroup is not None and not (parameterGroup in objsToBeDeleted))):
      data = parameterGroup.__dict__.get('data')
      data.remove(self)

    for runParameter in dataDict.get('runParameters'):
      if (not (runParameter in objsToBeDeleted)):
        runParameter.__dict__['data'] = None

    run = dataDict.get('run')
    if (not (run in objsToBeDeleted)):
      objKey = dataDict.get('serial')
      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = run.__dict__.get('data')
        if (self is dd.get(objKey)):
          del dd[objKey]

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData

  addRunParameter = Data.addRunParameter
  
  def checkAllValid(self, complete=False):
    """
    CheckAllValid for ccp.nmr.NmrCalc.DerivedListData
    """
    dataDict = self.__dict__
    self.checkValid(complete)
  
  def checkValid(self, complete=False):
    """
    CheckValid for ccp.nmr.NmrCalc.DerivedListData
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      objKey = dataDict.get('serial')
      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('run')
        dd = value.__dict__.get('data')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'run' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      # check attributes
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('code')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: code:
           memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 32):
          raise ApiError("""%s.checkValid: code:
           memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: code:
           memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.split()) == 1)):
          raise ApiError("""%s.checkValid: code:
           Word constraint contains_no_white_space violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('derivedDataListSerial')
      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.checkValid: derivedDataListSerial:
         memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('details')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: details:
           memops.Implementation.Text input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 254):
          raise ApiError("""%s.checkValid: details:
           memops.Implementation.Text maximum length is 254 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: details:
           memops.Implementation.Text: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('ioRole')
      if (not (value in ['input', 'output'])):
        raise ApiError("""%s.checkValid: ioRole:
         ccp.nmr.NmrCalc.IoRole input is not in enumeration ['input', 'output']""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.checkValid: ioRole:
         IoRole constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('name')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: name:
           memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: name:
           memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: name:
           memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: name:
           Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('serial')
      if (value is None):
        raise ApiError("""%s.checkValid: serial:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.checkValid: serial:
         memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getDerivedDataList()
      if (value is not None):
        from ccp.api.nmr.Nmr import DerivedDataList as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: derivedDataList:
           value is not of class ccp.nmr.Nmr.DerivedDataList""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: derivedDataList:
           Link derivedDataList between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('parameterGroup')
      if (value is not None):
        if (not isinstance(value, ParameterGroup)):
          raise ApiError("""%s.checkValid: parameterGroup:
           value is not of class ccp.nmr.NmrCalc.ParameterGroup""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('data')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: parameterGroup:
           non-reciprocal link parameterGroup from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      value = dataDict.get('run')
      if (not isinstance(value, Run)):
        raise ApiError("""%s.checkValid: run:
         value is not of class ccp.nmr.NmrCalc.Run""" % self.qualifiedName
         + ": %s" % (value,)
        )

      values = dataDict.get('runParameters')
      for value in values:
        if (not isinstance(value, RunParameter)):
          raise ApiError("""%s.checkValid: runParameters:
           value is not of class ccp.nmr.NmrCalc.RunParameter""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('data')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: runParameters:
           non-reciprocal link runParameters from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: runParameters:
           Link runParameters between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    # check explicit class constraints
    # check attributes
    values = dataDict.get('applicationData')
    for value in values:
      value.checkAllValid(complete)

    value = dataDict.get('code')
    value = dataDict.get('derivedDataListSerial')
    if (value is None):
      raise ApiError("""%s.checkValid: derivedDataListSerial:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('details')
    value = dataDict.get('ioRole')
    if (value is None):
      raise ApiError("""%s.checkValid: ioRole:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('name')
    # check roles
    value = dataDict.get('access')
    value = dataDict.get('parameterGroup')
    if (value is not None):
      isValid = True
      obj = self
      while obj is not None:
        obj = obj.parameterGroup
        if obj is self:
          isValid = False
          break
      if (not (isValid)):
        raise ApiError("""%s.checkValid: parameterGroup:
         parameterGroup constraint No_cyclical_parameter_grouping violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    value = dataDict.get('run')
    if (value is None):
      raise ApiError("""%s.checkValid: run:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    values = dataDict.get('runParameters')

  delete = memops.api.Implementation.DataObject.delete

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData

  findAllRunParameters = Data.findAllRunParameters

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData

  findFirstRunParameter = Data.findFirstRunParameter
  
  def get(self, name):
    """
    GetAttr for ccp.nmr.NmrCalc.DerivedListData
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccp.nmr.NmrCalc.DerivedListData
    """

    result = None
    if (startObj.__class__.__name__ == 'MemopsRoot'):
      if (4 != len(fullKey)):
        raise ApiError("""'ccp.nmr.NmrCalc.DerivedListData'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj0 = startObj
      ll = list()
      objKey = fullKey[0]
      ll.append(objKey)
      if (objKey is not None):
        objKey = fullKey[1]
        ll.append(objKey)
        if (objKey is not None):
          objKey = tuple(ll)

      obj1 = obj0.__dict__.get('nmrCalcStores').get(objKey)
      if (obj1 is None):
        obj0.refreshTopObjects('ccp.nmr.NmrCalc')
        obj1 = obj0.__dict__.get('nmrCalcStores').get(objKey)

    else:
      if (2 != len(fullKey)):
        raise ApiError("""'ccp.nmr.NmrCalc.DerivedListData'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj1 = startObj

    if (obj1 is not None):
      if (not (obj1.__dict__.get('isLoaded'))):
        obj1.load()

      objKey = fullKey[-2]
      obj2 = obj1.__dict__.get('runs').get(objKey)

      if (obj2 is not None):
        objKey = fullKey[-1]
        obj3 = obj2.__dict__.get('data').get(objKey)
        if (isinstance(obj3, DerivedListData)):
          result = obj3

    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation

  getClassName = memops.api.Implementation.ComplexDataType.getClassName

  getCode = Data.getCode
  
  def getDerivedDataList(self):
    """
    getter for derived link derivedDataList
    """
    dataDict = self.__dict__
    result = self.topObject.nmrProject.findFirstDerivedDataList(serial=self.derivedDataListSerial)
    return result
  
  def getDerivedDataListSerial(self):
    """
    Get for ccp.nmr.NmrCalc.DerivedListData.derivedDataListSerial
    """
    dataDict = self.__dict__
    result = dataDict.get('derivedDataListSerial')
    return result

  getDetails = Data.getDetails

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames

  getFullKey = Data.getFullKey

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor

  getIoRole = Data.getIoRole

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted

  getLocalKey = Data.getLocalKey

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass

  getName = Data.getName

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName

  getParameterGroup = Data.getParameterGroup

  getParent = Data.getParent

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName

  getRoot = memops.api.Implementation.MemopsObject.getRoot

  getRun = Data.getRun

  getRunParameters = Data.getRunParameters

  getSerial = Data.getSerial

  getTopObject = memops.api.Implementation.DataObject.getTopObject

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData

  removeRunParameter = Data.removeRunParameter
  
  def set(self, name, value):
    """
    SetAttr for ccp.nmr.NmrCalc.DerivedListData
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData

  setCode = Data.setCode
  
  def setDerivedDataList(self, value):
    """
    setter for derived link derivedDataList
    """
    dataDict = self.__dict__
    if (value is not None):
      from ccp.api.nmr.Nmr import DerivedDataList as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setDerivedDataList:
         value is not of class ccp.nmr.Nmr.DerivedDataList""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = self.getDerivedDataList()
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setDerivedDataList:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setDerivedDataList:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setDerivedDataList:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if value is None:
      self.derivedDataListSerial =None
    elif self.topObject.nmrProject is value.nmrProject:
      self.derivedDataListSerial = value.serial
    else:
      raise ApiError("%s does not belong to NmrCalcStore.nmrProject %s" % (value,self.topObject.nmrProject ))
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

  def setDerivedDataListSerial(self, value):
    """
    Set for ccp.nmr.NmrCalc.DerivedListData.derivedDataListSerial
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Int.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Int.create(value)
    else:
      raise ApiError("""%s.setDerivedDataListSerial:
       memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('derivedDataListSerial')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setDerivedDataListSerial:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setDerivedDataListSerial:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setDerivedDataListSerial:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['derivedDataListSerial'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setDerivedDataListSerial')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  setDetails = Data.setDetails

  setIoRole = Data.setIoRole

  setName = Data.setName

  setParameterGroup = Data.setParameterGroup

  setRunParameters = Data.setRunParameters

  setSerial = Data.setSerial

  sortedRunParameters = Data.sortedRunParameters

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  applicationData = memops.api.Implementation.DataObject.applicationData

  className = memops.api.Implementation.ComplexDataType.className

  code = Data.code
  
  derivedDataListSerial = property(getDerivedDataListSerial, setDerivedDataListSerial, None,
  r"""serial of Nmr.DerivedDataList - used to derive actual object.
  """)

  details = Data.details

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor

  ioRole = Data.ioRole

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted

  metaclass = memops.api.Implementation.ComplexDataType.metaclass

  name = Data.name

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName

  serial = Data.serial

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess
  
  derivedDataList = property(getDerivedDataList, setDerivedDataList, None,
  r"""DerivedDataList used for data
  """)

  parameterGroup = Data.parameterGroup

  parent = Data.parent

  root = memops.api.Implementation.MemopsObject.root

  run = Data.run

  runParameters = Data.runParameters

  topObject = memops.api.Implementation.DataObject.topObject

###############################################################################
class PeakListData(Data):
  r"""Nmr PeakList data
  """
  #   from data model element ccp.nmr.NmrCalc.PeakListData revision ?
  _metaclass = metaPackage.getElement('PeakListData')
  _packageName = 'ccp.nmr.NmrCalc'
  _packageShortName = 'CALC'
  _fieldNames = ('applicationData', 'className', 'code', 'dataSourceSerial', 'details', 'experimentSerial', 'fieldNames', 'inConstructor', 'ioRole', 'isDeleted', 'metaclass', 'name', 'packageName', 'packageShortName', 'peakListSerial', 'qualifiedName', 'serial', 'access', 'activeAccess', 'dataSource', 'parameterGroup', 'parent', 'peakList', 'root', 'run', 'runParameters', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for ccp.nmr.NmrCalc.PeakListData
    """
    dataDict = self.__dict__
    dataDict['run'] = parent
    if (not isinstance(parent, Run)):
      raise ApiError("""%s.__init__:
       value is not of class ccp.nmr.NmrCalc.Run""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = parent.__dict__.get('topObject')
    dataDict['topObject'] = topObject

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    if (notIsReading):
      if (not (topObject.__dict__.get('isModifiable'))):
        raise ApiError("""%s.__init__:
         Storage not modifiable""" % self.qualifiedName
         + ": %s" % (topObject,)
        )

    try:

      dataDict['applicationData'] = list()
      dataDict['code'] = None
      dataDict['dataSourceSerial'] = None
      dataDict['details'] = None
      dataDict['experimentSerial'] = None
      dataDict['ioRole'] = 'input'
      dataDict['name'] = None
      dataDict['peakListSerial'] = None
      dataDict['serial'] = None
      dataDict['access'] = None
      dataDict['parameterGroup'] = None
      dataDict['runParameters'] = set()

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in ccp.nmr.NmrCalc.PeakListData.__init__"
        del dataDict['inConstructor']
        raise

      if (notOverride):
        if (dataDict.get('serial') is None):
          dataDict['inConstructor'] = True
          self.setSerial(-1)
          del dataDict['inConstructor']
        else:
          raise ApiError("""%s.__init__:
           Cannot pass in explicit serial if not reading""" % self.qualifiedName
           + ": %s:%s" % (parent, 'ccp.nmr.NmrCalc.PeakListData')
          )

      if (notIsReading):
        childrenDict = parent.__dict__.get('data')
        objKey = dataDict.get('serial')
        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['serial'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notOverride):
        self.checkValid()

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for ccp.nmr.NmrCalc.PeakListData:
       determines cascading 
    deletes to follow from delete of object.
       *Implementation function* - 
    should be called only by API delete function.
    """
    dataDict = self.__dict__
    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for ccp.nmr.NmrCalc.PeakListData:   deletes
    objects
    *Implementation function* - will CORRUPT DATA if called outside 
    the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    parameterGroup = dataDict.get('parameterGroup')
    if ((parameterGroup is not None and not (parameterGroup in objsToBeDeleted))):
      data = parameterGroup.__dict__.get('data')
      data.remove(self)

    for runParameter in dataDict.get('runParameters'):
      if (not (runParameter in objsToBeDeleted)):
        runParameter.__dict__['data'] = None

    run = dataDict.get('run')
    if (not (run in objsToBeDeleted)):
      objKey = dataDict.get('serial')
      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = run.__dict__.get('data')
        if (self is dd.get(objKey)):
          del dd[objKey]

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData

  addRunParameter = Data.addRunParameter
  
  def checkAllValid(self, complete=False):
    """
    CheckAllValid for ccp.nmr.NmrCalc.PeakListData
    """
    dataDict = self.__dict__
    self.checkValid(complete)
  
  def checkValid(self, complete=False):
    """
    CheckValid for ccp.nmr.NmrCalc.PeakListData
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      objKey = dataDict.get('serial')
      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('run')
        dd = value.__dict__.get('data')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'run' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      # check attributes
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('code')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: code:
           memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 32):
          raise ApiError("""%s.checkValid: code:
           memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: code:
           memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.split()) == 1)):
          raise ApiError("""%s.checkValid: code:
           Word constraint contains_no_white_space violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('dataSourceSerial')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.Int.PythonType)):
          pass
        elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
          value = memops.api.Implementation.Int.create(value)
        else:
          raise ApiError("""%s.checkValid: dataSourceSerial:
           memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('details')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: details:
           memops.Implementation.Text input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 254):
          raise ApiError("""%s.checkValid: details:
           memops.Implementation.Text maximum length is 254 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: details:
           memops.Implementation.Text: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('experimentSerial')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.Int.PythonType)):
          pass
        elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
          value = memops.api.Implementation.Int.create(value)
        else:
          raise ApiError("""%s.checkValid: experimentSerial:
           memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('ioRole')
      if (not (value in ['input', 'output'])):
        raise ApiError("""%s.checkValid: ioRole:
         ccp.nmr.NmrCalc.IoRole input is not in enumeration ['input', 'output']""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.checkValid: ioRole:
         IoRole constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('name')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: name:
           memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: name:
           memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: name:
           memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: name:
           Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('peakListSerial')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.Int.PythonType)):
          pass
        elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
          value = memops.api.Implementation.Int.create(value)
        else:
          raise ApiError("""%s.checkValid: peakListSerial:
           memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('serial')
      if (value is None):
        raise ApiError("""%s.checkValid: serial:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.checkValid: serial:
         memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getDataSource()
      if (value is not None):
        from ccp.api.nmr.Nmr import DataSource as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: dataSource:
           value is not of class ccp.nmr.Nmr.DataSource""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: dataSource:
           Link dataSource between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('parameterGroup')
      if (value is not None):
        if (not isinstance(value, ParameterGroup)):
          raise ApiError("""%s.checkValid: parameterGroup:
           value is not of class ccp.nmr.NmrCalc.ParameterGroup""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('data')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: parameterGroup:
           non-reciprocal link parameterGroup from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      value = self.getPeakList()
      if (value is not None):
        from ccp.api.nmr.Nmr import PeakList as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: peakList:
           value is not of class ccp.nmr.Nmr.PeakList""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: peakList:
           Link peakList between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('run')
      if (not isinstance(value, Run)):
        raise ApiError("""%s.checkValid: run:
         value is not of class ccp.nmr.NmrCalc.Run""" % self.qualifiedName
         + ": %s" % (value,)
        )

      values = dataDict.get('runParameters')
      for value in values:
        if (not isinstance(value, RunParameter)):
          raise ApiError("""%s.checkValid: runParameters:
           value is not of class ccp.nmr.NmrCalc.RunParameter""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('data')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: runParameters:
           non-reciprocal link runParameters from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: runParameters:
           Link runParameters between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    # check explicit class constraints
    # check attributes
    values = dataDict.get('applicationData')
    for value in values:
      value.checkAllValid(complete)

    value = dataDict.get('code')
    value = dataDict.get('dataSourceSerial')
    value = dataDict.get('details')
    value = dataDict.get('experimentSerial')
    value = dataDict.get('ioRole')
    if (value is None):
      raise ApiError("""%s.checkValid: ioRole:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('name')
    value = dataDict.get('peakListSerial')
    # check roles
    value = dataDict.get('access')
    value = dataDict.get('parameterGroup')
    if (value is not None):
      isValid = True
      obj = self
      while obj is not None:
        obj = obj.parameterGroup
        if obj is self:
          isValid = False
          break
      if (not (isValid)):
        raise ApiError("""%s.checkValid: parameterGroup:
         parameterGroup constraint No_cyclical_parameter_grouping violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    value = dataDict.get('run')
    if (value is None):
      raise ApiError("""%s.checkValid: run:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    values = dataDict.get('runParameters')

  delete = memops.api.Implementation.DataObject.delete

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData

  findAllRunParameters = Data.findAllRunParameters

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData

  findFirstRunParameter = Data.findFirstRunParameter
  
  def get(self, name):
    """
    GetAttr for ccp.nmr.NmrCalc.PeakListData
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccp.nmr.NmrCalc.PeakListData
    """

    result = None
    if (startObj.__class__.__name__ == 'MemopsRoot'):
      if (4 != len(fullKey)):
        raise ApiError("""'ccp.nmr.NmrCalc.PeakListData'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj0 = startObj
      ll = list()
      objKey = fullKey[0]
      ll.append(objKey)
      if (objKey is not None):
        objKey = fullKey[1]
        ll.append(objKey)
        if (objKey is not None):
          objKey = tuple(ll)

      obj1 = obj0.__dict__.get('nmrCalcStores').get(objKey)
      if (obj1 is None):
        obj0.refreshTopObjects('ccp.nmr.NmrCalc')
        obj1 = obj0.__dict__.get('nmrCalcStores').get(objKey)

    else:
      if (2 != len(fullKey)):
        raise ApiError("""'ccp.nmr.NmrCalc.PeakListData'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj1 = startObj

    if (obj1 is not None):
      if (not (obj1.__dict__.get('isLoaded'))):
        obj1.load()

      objKey = fullKey[-2]
      obj2 = obj1.__dict__.get('runs').get(objKey)

      if (obj2 is not None):
        objKey = fullKey[-1]
        obj3 = obj2.__dict__.get('data').get(objKey)
        if (isinstance(obj3, PeakListData)):
          result = obj3

    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation

  getClassName = memops.api.Implementation.ComplexDataType.getClassName

  getCode = Data.getCode
  
  def getDataSource(self):
    """
    getter for derived link dataSource
    """
    dataDict = self.__dict__
    result = self.getByNavigation('topObject', 'nmrProject', ('experiments', self.experimentSerial), ('dataSources', self.dataSourceSerial))
    return result
  
  def getDataSourceSerial(self):
    """
    Get for ccp.nmr.NmrCalc.PeakListData.dataSourceSerial
    """
    dataDict = self.__dict__
    result = dataDict.get('dataSourceSerial')
    return result

  getDetails = Data.getDetails

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey
  
  def getExperimentSerial(self):
    """
    Get for ccp.nmr.NmrCalc.PeakListData.experimentSerial
    """
    dataDict = self.__dict__
    result = dataDict.get('experimentSerial')
    return result

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames

  getFullKey = Data.getFullKey

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor

  getIoRole = Data.getIoRole

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted

  getLocalKey = Data.getLocalKey

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass

  getName = Data.getName

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName

  getParameterGroup = Data.getParameterGroup

  getParent = Data.getParent
  
  def getPeakList(self):
    """
    getter for derived link peakList
    """
    dataDict = self.__dict__
    result = self.getByNavigation('topObject', 'nmrProject', ('experiments', self.experimentSerial), ('dataSources', self.dataSourceSerial), ('peakLists', self.peakListSerial))
    return result
  
  def getPeakListSerial(self):
    """
    Get for ccp.nmr.NmrCalc.PeakListData.peakListSerial
    """
    dataDict = self.__dict__
    result = dataDict.get('peakListSerial')
    return result

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName

  getRoot = memops.api.Implementation.MemopsObject.getRoot

  getRun = Data.getRun

  getRunParameters = Data.getRunParameters

  getSerial = Data.getSerial

  getTopObject = memops.api.Implementation.DataObject.getTopObject

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData

  removeRunParameter = Data.removeRunParameter
  
  def set(self, name, value):
    """
    SetAttr for ccp.nmr.NmrCalc.PeakListData
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData

  setCode = Data.setCode
  
  def setDataSourceSerial(self, value):
    """
    Set for ccp.nmr.NmrCalc.PeakListData.dataSourceSerial
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.setDataSourceSerial:
         memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('dataSourceSerial')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setDataSourceSerial:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setDataSourceSerial:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['dataSourceSerial'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setDataSourceSerial')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  setDetails = Data.setDetails
  
  def setExperimentSerial(self, value):
    """
    Set for ccp.nmr.NmrCalc.PeakListData.experimentSerial
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.setExperimentSerial:
         memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('experimentSerial')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setExperimentSerial:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setExperimentSerial:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['experimentSerial'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setExperimentSerial')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  setIoRole = Data.setIoRole

  setName = Data.setName

  setParameterGroup = Data.setParameterGroup
  
  def setPeakList(self, value):
    """
    getter for derived link peakList
    """
    dataDict = self.__dict__
    if (value is not None):
      from ccp.api.nmr.Nmr import PeakList as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setPeakList:
         value is not of class ccp.nmr.Nmr.PeakList""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = self.getPeakList()
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setPeakList:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setPeakList:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setPeakList:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if value is None:
      self.experimentSerial = None
      self.dataSourceSerial = None
      self.peakListSerial = None
    elif self.topObject.nmrProject is value.topObject:
      dataSource = value.dataSource
      self.experimentSerial = dataSource.experiment.serial
      self.dataSourceSerial = dataSource.serial
      self.peakListSerial = value.serial
    else:
      raise ApiError("%s does not belong to NmrCalcStore.nmrProject %s" % (value,self.topObject.nmrProject ))
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

  def setPeakListSerial(self, value):
    """
    Set for ccp.nmr.NmrCalc.PeakListData.peakListSerial
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.setPeakListSerial:
         memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('peakListSerial')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setPeakListSerial:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setPeakListSerial:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['peakListSerial'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setPeakListSerial')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  setRunParameters = Data.setRunParameters

  setSerial = Data.setSerial

  sortedRunParameters = Data.sortedRunParameters

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  applicationData = memops.api.Implementation.DataObject.applicationData

  className = memops.api.Implementation.ComplexDataType.className

  code = Data.code
  
  dataSourceSerial = property(getDataSourceSerial, setDataSourceSerial, None,
  r"""serial for Nmr.DataSource holding data - used to derive actual object.
  """)

  details = Data.details
  
  experimentSerial = property(getExperimentSerial, setExperimentSerial, None,
  r"""serial for Nmr.Experiment holding data - used to derive actual object.
  """)

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor

  ioRole = Data.ioRole

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted

  metaclass = memops.api.Implementation.ComplexDataType.metaclass

  name = Data.name

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName
  
  peakListSerial = property(getPeakListSerial, setPeakListSerial, None,
  r"""serial for Nmr.PeakList (if any)  - used to derive actual object.
  """)

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName

  serial = Data.serial

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess
  
  dataSource = property(getDataSource, None, None,
  r"""Nmr.DataSource used for data
  """)

  parameterGroup = Data.parameterGroup

  parent = Data.parent
  
  peakList = property(getPeakList, setPeakList, None,
  r"""Nmr.PeakList used for data
  """)

  root = memops.api.Implementation.MemopsObject.root

  run = Data.run

  runParameters = Data.runParameters

  topObject = memops.api.Implementation.DataObject.topObject

###############################################################################
class ViolationListData(Data):
  r"""ViolationList used for data
  """
  #   from data model element ccp.nmr.NmrCalc.ViolationListData revision ?
  _metaclass = metaPackage.getElement('ViolationListData')
  _packageName = 'ccp.nmr.NmrCalc'
  _packageShortName = 'CALC'
  _fieldNames = ('applicationData', 'className', 'code', 'constraintStoreSerial', 'details', 'fieldNames', 'inConstructor', 'ioRole', 'isDeleted', 'metaclass', 'name', 'packageName', 'packageShortName', 'qualifiedName', 'serial', 'violationListSerial', 'access', 'activeAccess', 'parameterGroup', 'parent', 'root', 'run', 'runParameters', 'topObject', 'violationList',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for ccp.nmr.NmrCalc.ViolationListData
    """
    dataDict = self.__dict__
    dataDict['run'] = parent
    if (not isinstance(parent, Run)):
      raise ApiError("""%s.__init__:
       value is not of class ccp.nmr.NmrCalc.Run""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = parent.__dict__.get('topObject')
    dataDict['topObject'] = topObject

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    if (notIsReading):
      if (not (topObject.__dict__.get('isModifiable'))):
        raise ApiError("""%s.__init__:
         Storage not modifiable""" % self.qualifiedName
         + ": %s" % (topObject,)
        )

    try:

      dataDict['applicationData'] = list()
      dataDict['code'] = None
      dataDict['constraintStoreSerial'] = None
      dataDict['details'] = None
      dataDict['ioRole'] = 'input'
      dataDict['name'] = None
      dataDict['serial'] = None
      dataDict['violationListSerial'] = None
      dataDict['access'] = None
      dataDict['parameterGroup'] = None
      dataDict['runParameters'] = set()

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in ccp.nmr.NmrCalc.ViolationListData.__init__"
        del dataDict['inConstructor']
        raise

      if (notOverride):
        if (dataDict.get('serial') is None):
          dataDict['inConstructor'] = True
          self.setSerial(-1)
          del dataDict['inConstructor']
        else:
          raise ApiError("""%s.__init__:
           Cannot pass in explicit serial if not reading""" % self.qualifiedName
           + ": %s:%s" % (parent, 'ccp.nmr.NmrCalc.ViolationListData')
          )

      if (notIsReading):
        childrenDict = parent.__dict__.get('data')
        objKey = dataDict.get('serial')
        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['serial'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notOverride):
        self.checkValid()

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for ccp.nmr.NmrCalc.ViolationListData:
       determines 
    cascading deletes to follow from delete of object.
       *Implementation 
    function* - should be called only by API delete function.
    """
    dataDict = self.__dict__
    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for ccp.nmr.NmrCalc.ViolationListData:   deletes
    objects
    *Implementation function* - will CORRUPT DATA if called outside 
    the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    parameterGroup = dataDict.get('parameterGroup')
    if ((parameterGroup is not None and not (parameterGroup in objsToBeDeleted))):
      data = parameterGroup.__dict__.get('data')
      data.remove(self)

    for runParameter in dataDict.get('runParameters'):
      if (not (runParameter in objsToBeDeleted)):
        runParameter.__dict__['data'] = None

    run = dataDict.get('run')
    if (not (run in objsToBeDeleted)):
      objKey = dataDict.get('serial')
      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = run.__dict__.get('data')
        if (self is dd.get(objKey)):
          del dd[objKey]

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData

  addRunParameter = Data.addRunParameter
  
  def checkAllValid(self, complete=False):
    """
    CheckAllValid for ccp.nmr.NmrCalc.ViolationListData
    """
    dataDict = self.__dict__
    self.checkValid(complete)
  
  def checkValid(self, complete=False):
    """
    CheckValid for ccp.nmr.NmrCalc.ViolationListData
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      objKey = dataDict.get('serial')
      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('run')
        dd = value.__dict__.get('data')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'run' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      # check attributes
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('code')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: code:
           memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 32):
          raise ApiError("""%s.checkValid: code:
           memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: code:
           memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.split()) == 1)):
          raise ApiError("""%s.checkValid: code:
           Word constraint contains_no_white_space violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('constraintStoreSerial')
      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.checkValid: constraintStoreSerial:
         memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('details')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: details:
           memops.Implementation.Text input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 254):
          raise ApiError("""%s.checkValid: details:
           memops.Implementation.Text maximum length is 254 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: details:
           memops.Implementation.Text: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('ioRole')
      if (not (value in ['input', 'output'])):
        raise ApiError("""%s.checkValid: ioRole:
         ccp.nmr.NmrCalc.IoRole input is not in enumeration ['input', 'output']""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.checkValid: ioRole:
         IoRole constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('name')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: name:
           memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: name:
           memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: name:
           memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: name:
           Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('serial')
      if (value is None):
        raise ApiError("""%s.checkValid: serial:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.checkValid: serial:
         memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('violationListSerial')
      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.checkValid: violationListSerial:
         memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('parameterGroup')
      if (value is not None):
        if (not isinstance(value, ParameterGroup)):
          raise ApiError("""%s.checkValid: parameterGroup:
           value is not of class ccp.nmr.NmrCalc.ParameterGroup""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('data')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: parameterGroup:
           non-reciprocal link parameterGroup from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      value = dataDict.get('run')
      if (not isinstance(value, Run)):
        raise ApiError("""%s.checkValid: run:
         value is not of class ccp.nmr.NmrCalc.Run""" % self.qualifiedName
         + ": %s" % (value,)
        )

      values = dataDict.get('runParameters')
      for value in values:
        if (not isinstance(value, RunParameter)):
          raise ApiError("""%s.checkValid: runParameters:
           value is not of class ccp.nmr.NmrCalc.RunParameter""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('data')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: runParameters:
           non-reciprocal link runParameters from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: runParameters:
           Link runParameters between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getViolationList()
      if (value is not None):
        from ccp.api.nmr.NmrConstraint import ViolationList as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: violationList:
           value is not of class ccp.nmr.NmrConstraint.ViolationList""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: violationList:
           Link violationList between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    # check explicit class constraints
    # check attributes
    values = dataDict.get('applicationData')
    for value in values:
      value.checkAllValid(complete)

    value = dataDict.get('code')
    value = dataDict.get('constraintStoreSerial')
    if (value is None):
      raise ApiError("""%s.checkValid: constraintStoreSerial:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('details')
    value = dataDict.get('ioRole')
    if (value is None):
      raise ApiError("""%s.checkValid: ioRole:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('name')
    value = dataDict.get('violationListSerial')
    if (value is None):
      raise ApiError("""%s.checkValid: violationListSerial:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    # check roles
    value = dataDict.get('access')
    value = dataDict.get('parameterGroup')
    if (value is not None):
      isValid = True
      obj = self
      while obj is not None:
        obj = obj.parameterGroup
        if obj is self:
          isValid = False
          break
      if (not (isValid)):
        raise ApiError("""%s.checkValid: parameterGroup:
         parameterGroup constraint No_cyclical_parameter_grouping violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    value = dataDict.get('run')
    if (value is None):
      raise ApiError("""%s.checkValid: run:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    values = dataDict.get('runParameters')

  delete = memops.api.Implementation.DataObject.delete

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData

  findAllRunParameters = Data.findAllRunParameters

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData

  findFirstRunParameter = Data.findFirstRunParameter
  
  def get(self, name):
    """
    GetAttr for ccp.nmr.NmrCalc.ViolationListData
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccp.nmr.NmrCalc.ViolationListData
    """

    result = None
    if (startObj.__class__.__name__ == 'MemopsRoot'):
      if (4 != len(fullKey)):
        raise ApiError("""'ccp.nmr.NmrCalc.ViolationListData'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj0 = startObj
      ll = list()
      objKey = fullKey[0]
      ll.append(objKey)
      if (objKey is not None):
        objKey = fullKey[1]
        ll.append(objKey)
        if (objKey is not None):
          objKey = tuple(ll)

      obj1 = obj0.__dict__.get('nmrCalcStores').get(objKey)
      if (obj1 is None):
        obj0.refreshTopObjects('ccp.nmr.NmrCalc')
        obj1 = obj0.__dict__.get('nmrCalcStores').get(objKey)

    else:
      if (2 != len(fullKey)):
        raise ApiError("""'ccp.nmr.NmrCalc.ViolationListData'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj1 = startObj

    if (obj1 is not None):
      if (not (obj1.__dict__.get('isLoaded'))):
        obj1.load()

      objKey = fullKey[-2]
      obj2 = obj1.__dict__.get('runs').get(objKey)

      if (obj2 is not None):
        objKey = fullKey[-1]
        obj3 = obj2.__dict__.get('data').get(objKey)
        if (isinstance(obj3, ViolationListData)):
          result = obj3

    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation

  getClassName = memops.api.Implementation.ComplexDataType.getClassName

  getCode = Data.getCode
  
  def getConstraintStoreSerial(self):
    """
    Get for ccp.nmr.NmrCalc.ViolationListData.constraintStoreSerial
    """
    dataDict = self.__dict__
    result = dataDict.get('constraintStoreSerial')
    return result

  getDetails = Data.getDetails

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames

  getFullKey = Data.getFullKey

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor

  getIoRole = Data.getIoRole

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted

  getLocalKey = Data.getLocalKey

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass

  getName = Data.getName

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName

  getParameterGroup = Data.getParameterGroup

  getParent = Data.getParent

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName

  getRoot = memops.api.Implementation.MemopsObject.getRoot

  getRun = Data.getRun

  getRunParameters = Data.getRunParameters

  getSerial = Data.getSerial

  getTopObject = memops.api.Implementation.DataObject.getTopObject
  
  def getViolationList(self):
    """
    getter for derived link violationList
    """
    dataDict = self.__dict__
    result = ccp.api.nmr.NmrConstraint.ViolationList.getByKey(self.root, (self.constraintStoreSerial, self.violationListSerial))
    return result
  
  def getViolationListSerial(self):
    """
    Get for ccp.nmr.NmrCalc.ViolationListData.violationListSerial
    """
    dataDict = self.__dict__
    result = dataDict.get('violationListSerial')
    return result

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData

  removeRunParameter = Data.removeRunParameter
  
  def set(self, name, value):
    """
    SetAttr for ccp.nmr.NmrCalc.ViolationListData
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData

  setCode = Data.setCode
  
  def setConstraintStoreSerial(self, value):
    """
    Set for ccp.nmr.NmrCalc.ViolationListData.constraintStoreSerial
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Int.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Int.create(value)
    else:
      raise ApiError("""%s.setConstraintStoreSerial:
       memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('constraintStoreSerial')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setConstraintStoreSerial:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setConstraintStoreSerial:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setConstraintStoreSerial:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['constraintStoreSerial'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setConstraintStoreSerial')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  setDetails = Data.setDetails

  setIoRole = Data.setIoRole

  setName = Data.setName

  setParameterGroup = Data.setParameterGroup

  setRunParameters = Data.setRunParameters

  setSerial = Data.setSerial
  
  def setViolationList(self, value):
    """
    setter for derived link violationList
    """
    dataDict = self.__dict__
    if (value is not None):
      from ccp.api.nmr.NmrConstraint import ViolationList as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setViolationList:
         value is not of class ccp.nmr.NmrConstraint.ViolationList""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = self.getViolationList()
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setViolationList:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setViolationList:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setViolationList:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if value is None:
      self.constraintStoreSerial = None
      self.violationListSerial = None
    elif self.topObject.nmrProject is value.topObject.nmrProject:
      self.constraintStoreSerial = value.nmrConstraintStore.serial
      self.violationListSerial = value.serial
    else:
      raise ApiError("%s does not belong to NmrCalcStore.nmrProject %s" % (value,self.topObject.nmrProject ))
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

  def setViolationListSerial(self, value):
    """
    Set for ccp.nmr.NmrCalc.ViolationListData.violationListSerial
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Int.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Int.create(value)
    else:
      raise ApiError("""%s.setViolationListSerial:
       memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('violationListSerial')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setViolationListSerial:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setViolationListSerial:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setViolationListSerial:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['violationListSerial'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setViolationListSerial')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  sortedRunParameters = Data.sortedRunParameters

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  applicationData = memops.api.Implementation.DataObject.applicationData

  className = memops.api.Implementation.ComplexDataType.className

  code = Data.code
  
  constraintStoreSerial = property(getConstraintStoreSerial, setConstraintStoreSerial, None,
  r"""NmrConstraintStore serial - used to derive actual object.
  """)

  details = Data.details

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor

  ioRole = Data.ioRole

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted

  metaclass = memops.api.Implementation.ComplexDataType.metaclass

  name = Data.name

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName

  serial = Data.serial
  
  violationListSerial = property(getViolationListSerial, setViolationListSerial, None,
  r"""NmrConstraint.ViolationList serial - used to derive actual object.
  """)

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess

  parameterGroup = Data.parameterGroup

  parent = Data.parent

  root = memops.api.Implementation.MemopsObject.root

  run = Data.run

  runParameters = Data.runParameters

  topObject = memops.api.Implementation.DataObject.topObject
  
  violationList = property(getViolationList, setViolationList, None,
  r"""NmrConstraint.ViolationList containing Data
  """)

###############################################################################
class EnergyTerm(ConstraintStoreData):
  r"""Energy potential term used in Nmr simulation run
  """
  #   from data model element ccp.nmr.NmrCalc.EnergyTerm revision ?
  _metaclass = metaPackage.getElement('EnergyTerm')
  _packageName = 'ccp.nmr.NmrCalc'
  _packageShortName = 'CALC'
  _fieldNames = ('annealEnergyTermSerial', 'applicationData', 'className', 'code', 'constraintListSerials', 'constraintStoreSerial', 'details', 'fieldNames', 'inConstructor', 'ioRole', 'isDeleted', 'metaclass', 'name', 'packageName', 'packageShortName', 'qualifiedName', 'serial', 'access', 'activeAccess', 'annealEnergyTerm', 'constraintLists', 'energyTermParameters', 'nmrConstraintStore', 'parameterGroup', 'parent', 'root', 'run', 'runParameters', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for ccp.nmr.NmrCalc.EnergyTerm
    """
    dataDict = self.__dict__
    dataDict['run'] = parent
    if (not isinstance(parent, Run)):
      raise ApiError("""%s.__init__:
       value is not of class ccp.nmr.NmrCalc.Run""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = parent.__dict__.get('topObject')
    dataDict['topObject'] = topObject

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    if (notIsReading):
      if (not (topObject.__dict__.get('isModifiable'))):
        raise ApiError("""%s.__init__:
         Storage not modifiable""" % self.qualifiedName
         + ": %s" % (topObject,)
        )

    try:

      dataDict['annealEnergyTermSerial'] = None
      dataDict['applicationData'] = list()
      dataDict['code'] = None
      dataDict['constraintListSerials'] = list()
      dataDict['constraintStoreSerial'] = None
      dataDict['details'] = None
      dataDict['ioRole'] = 'input'
      dataDict['name'] = None
      dataDict['serial'] = None
      dataDict['access'] = None
      dataDict['energyTermParameters'] = {}
      dataDict['parameterGroup'] = None
      dataDict['runParameters'] = set()

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in ccp.nmr.NmrCalc.EnergyTerm.__init__"
        del dataDict['inConstructor']
        raise

      if (notOverride):
        if (dataDict.get('serial') is None):
          dataDict['inConstructor'] = True
          self.setSerial(-1)
          del dataDict['inConstructor']
        else:
          raise ApiError("""%s.__init__:
           Cannot pass in explicit serial if not reading""" % self.qualifiedName
           + ": %s:%s" % (parent, 'ccp.nmr.NmrCalc.EnergyTerm')
          )

      if (notIsReading):
        childrenDict = parent.__dict__.get('data')
        objKey = dataDict.get('serial')
        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['serial'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notOverride):
        self.checkValid()

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for ccp.nmr.NmrCalc.EnergyTerm:
       determines cascading 
    deletes to follow from delete of object.
       *Implementation function* - 
    should be called only by API delete function.
    """
    dataDict = self.__dict__
    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    energyTermParameters = dataDict.get('energyTermParameters').values()
    for energyTermParameter in energyTermParameters:
      if (not (energyTermParameter in objsToBeDeleted)):
        objsToBeDeleted.add(energyTermParameter)
        objsToBeChecked.append(energyTermParameter)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for ccp.nmr.NmrCalc.EnergyTerm:   deletes
    objects
    *Implementation function* - will CORRUPT DATA if called outside 
    the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    parameterGroup = dataDict.get('parameterGroup')
    if ((parameterGroup is not None and not (parameterGroup in objsToBeDeleted))):
      data = parameterGroup.__dict__.get('data')
      data.remove(self)

    for runParameter in dataDict.get('runParameters'):
      if (not (runParameter in objsToBeDeleted)):
        runParameter.__dict__['data'] = None

    run = dataDict.get('run')
    if (not (run in objsToBeDeleted)):
      objKey = dataDict.get('serial')
      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = run.__dict__.get('data')
        if (self is dd.get(objKey)):
          del dd[objKey]

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData

  addConstraintList = ConstraintStoreData.addConstraintList

  addConstraintListSerial = ConstraintStoreData.addConstraintListSerial

  addRunParameter = Data.addRunParameter
  
  def checkAllValid(self, complete=False):
    """
    CheckAllValid for ccp.nmr.NmrCalc.EnergyTerm
    """
    dataDict = self.__dict__
    self.checkValid(complete)
    values = dataDict.get('energyTermParameters').values()
    for value in values:
      value.checkAllValid(complete)

  def checkValid(self, complete=False):
    """
    CheckValid for ccp.nmr.NmrCalc.EnergyTerm
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      objKey = dataDict.get('serial')
      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('run')
        dd = value.__dict__.get('data')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'run' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      # check attributes
      value = dataDict.get('annealEnergyTermSerial')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.Int.PythonType)):
          pass
        elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
          value = memops.api.Implementation.Int.create(value)
        else:
          raise ApiError("""%s.checkValid: annealEnergyTermSerial:
           memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('code')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: code:
           memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 32):
          raise ApiError("""%s.checkValid: code:
           memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: code:
           memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.split()) == 1)):
          raise ApiError("""%s.checkValid: code:
           Word constraint contains_no_white_space violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      values = dataDict.get('constraintListSerials')
      for value in values:
        if (isinstance(value, memops.api.Implementation.Int.PythonType)):
          pass
        elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
          castValue = memops.api.Implementation.Int.create(value)
          replaceIndex = values.index(value)
          values[replaceIndex] = None
          if (castValue in values):
            values[replaceIndex] = value
            raise ApiError("""%s.checkValid: constraintListSerials:
             replacement value already in unique collection """ % self.qualifiedName
             + ": %s" % (castValue,)
            )
          else:
            values[replaceIndex] = castValue

          value = castValue
        else:
          raise ApiError("""%s.checkValid: constraintListSerials:
           memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('constraintStoreSerial')
      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.checkValid: constraintStoreSerial:
         memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('details')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: details:
           memops.Implementation.Text input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 254):
          raise ApiError("""%s.checkValid: details:
           memops.Implementation.Text maximum length is 254 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: details:
           memops.Implementation.Text: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('ioRole')
      if (not (value in ['input', 'output'])):
        raise ApiError("""%s.checkValid: ioRole:
         ccp.nmr.NmrCalc.IoRole input is not in enumeration ['input', 'output']""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.checkValid: ioRole:
         IoRole constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('name')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: name:
           memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: name:
           memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: name:
           memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: name:
           Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('serial')
      if (value is None):
        raise ApiError("""%s.checkValid: serial:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.checkValid: serial:
         memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getAnnealEnergyTerm()
      if (value is not None):
        from molsim.api.AnnealProtocol import EnergyTerm as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: annealEnergyTerm:
           value is not of class molsim.AnnealProtocol.EnergyTerm""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.getNmrCalcEnergyTerms()
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: annealEnergyTerm:
           non-reciprocal link annealEnergyTerm from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      values = self.getConstraintLists()
      for value in values:
        from ccp.api.nmr.NmrConstraint import AbstractConstraintList as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: constraintLists:
           value is not of class ccp.nmr.NmrConstraint.AbstractConstraintList""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: constraintLists:
           Link constraintLists between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      values = dataDict.get('energyTermParameters').values()
      for value in values:
        if (not isinstance(value, EnergyTermParameter)):
          raise ApiError("""%s.checkValid: energyTermParameters:
           value is not of class ccp.nmr.NmrCalc.EnergyTermParameter""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('energyTerm')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: energyTermParameters:
           non-reciprocal link energyTermParameters from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      value = self.getNmrConstraintStore()
      if (value is not None):
        from ccp.api.nmr.NmrConstraint import NmrConstraintStore as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: nmrConstraintStore:
           value is not of class ccp.nmr.NmrConstraint.NmrConstraintStore""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: nmrConstraintStore:
           Link nmrConstraintStore between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('parameterGroup')
      if (value is not None):
        if (not isinstance(value, ParameterGroup)):
          raise ApiError("""%s.checkValid: parameterGroup:
           value is not of class ccp.nmr.NmrCalc.ParameterGroup""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('data')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: parameterGroup:
           non-reciprocal link parameterGroup from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      value = dataDict.get('run')
      if (not isinstance(value, Run)):
        raise ApiError("""%s.checkValid: run:
         value is not of class ccp.nmr.NmrCalc.Run""" % self.qualifiedName
         + ": %s" % (value,)
        )

      values = dataDict.get('runParameters')
      for value in values:
        if (not isinstance(value, RunParameter)):
          raise ApiError("""%s.checkValid: runParameters:
           value is not of class ccp.nmr.NmrCalc.RunParameter""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('data')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: runParameters:
           non-reciprocal link runParameters from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: runParameters:
           Link runParameters between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    # check explicit class constraints
    # check attributes
    value = dataDict.get('annealEnergyTermSerial')
    values = dataDict.get('applicationData')
    for value in values:
      value.checkAllValid(complete)

    value = dataDict.get('code')
    values = dataDict.get('constraintListSerials')
    value = dataDict.get('constraintStoreSerial')
    if (value is None):
      raise ApiError("""%s.checkValid: constraintStoreSerial:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('details')
    value = dataDict.get('ioRole')
    if (value is None):
      raise ApiError("""%s.checkValid: ioRole:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('name')
    # check roles
    value = dataDict.get('access')
    values = dataDict.get('energyTermParameters').values()
    value = dataDict.get('parameterGroup')
    if (value is not None):
      isValid = True
      obj = self
      while obj is not None:
        obj = obj.parameterGroup
        if obj is self:
          isValid = False
          break
      if (not (isValid)):
        raise ApiError("""%s.checkValid: parameterGroup:
         parameterGroup constraint No_cyclical_parameter_grouping violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    value = dataDict.get('run')
    if (value is None):
      raise ApiError("""%s.checkValid: run:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    values = dataDict.get('runParameters')

  delete = memops.api.Implementation.DataObject.delete

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData

  findAllConstraintLists = ConstraintStoreData.findAllConstraintLists
  
  def findAllEnergyTermParameters(self, **conditions):
    """
    FindAll for ccp.nmr.NmrCalc.EnergyTerm.energyTermParameters
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('energyTermParameters').values()
      result = set(currentValues)

    else:
      currentValues = dataDict.get('energyTermParameters').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('code', 'value', 'access', 'energyTerm',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result

  findAllRunParameters = Data.findAllRunParameters

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData

  findFirstConstraintList = ConstraintStoreData.findFirstConstraintList
  
  def findFirstEnergyTermParameter(self, **conditions):
    """
    FindFirst for ccp.nmr.NmrCalc.EnergyTerm.energyTermParameters
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('energyTermParameters').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      objKey = conditions.get('code')
      if (objKey is not None):
        result = dataDict.get('energyTermParameters').get(objKey)

        if (nConditions <= 1):
          return result

        elif (result is None):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        currentValues = dataDict.get('energyTermParameters').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('code', 'value', 'access', 'energyTerm',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result

  findFirstRunParameter = Data.findFirstRunParameter
  
  def get(self, name):
    """
    GetAttr for ccp.nmr.NmrCalc.EnergyTerm
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess
  
  def getAnnealEnergyTerm(self):
    """
    getter for derived link annealEnergyTerm
    """
    dataDict = self.__dict__
    result = self.run.annealProtocol
    if result is not None:
      result = result.findFirstEnergyTerm(serial=self.annealEnergyTermSerial)
    return result
  
  def getAnnealEnergyTermSerial(self):
    """
    Get for ccp.nmr.NmrCalc.EnergyTerm.annealEnergyTermSerial
    """
    dataDict = self.__dict__
    result = dataDict.get('annealEnergyTermSerial')
    return result

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccp.nmr.NmrCalc.EnergyTerm
    """

    result = None
    if (startObj.__class__.__name__ == 'MemopsRoot'):
      if (4 != len(fullKey)):
        raise ApiError("""'ccp.nmr.NmrCalc.EnergyTerm'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj0 = startObj
      ll = list()
      objKey = fullKey[0]
      ll.append(objKey)
      if (objKey is not None):
        objKey = fullKey[1]
        ll.append(objKey)
        if (objKey is not None):
          objKey = tuple(ll)

      obj1 = obj0.__dict__.get('nmrCalcStores').get(objKey)
      if (obj1 is None):
        obj0.refreshTopObjects('ccp.nmr.NmrCalc')
        obj1 = obj0.__dict__.get('nmrCalcStores').get(objKey)

    else:
      if (2 != len(fullKey)):
        raise ApiError("""'ccp.nmr.NmrCalc.EnergyTerm'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj1 = startObj

    if (obj1 is not None):
      if (not (obj1.__dict__.get('isLoaded'))):
        obj1.load()

      objKey = fullKey[-2]
      obj2 = obj1.__dict__.get('runs').get(objKey)

      if (obj2 is not None):
        objKey = fullKey[-1]
        obj3 = obj2.__dict__.get('data').get(objKey)
        if (isinstance(obj3, EnergyTerm)):
          result = obj3

    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation

  getClassName = memops.api.Implementation.ComplexDataType.getClassName

  getCode = Data.getCode

  getConstraintListSerials = ConstraintStoreData.getConstraintListSerials

  getConstraintLists = ConstraintStoreData.getConstraintLists

  getConstraintStoreSerial = ConstraintStoreData.getConstraintStoreSerial

  getDetails = Data.getDetails
  
  def getEnergyTermParameters(self):
    """
    Get for ccp.nmr.NmrCalc.EnergyTerm.energyTermParameters
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('energyTermParameters').values()
    result = frozenset(tempVar)
    return result

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames

  getFullKey = Data.getFullKey

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor

  getIoRole = Data.getIoRole

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted

  getLocalKey = Data.getLocalKey

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass

  getName = Data.getName

  getNmrConstraintStore = ConstraintStoreData.getNmrConstraintStore

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName

  getParameterGroup = Data.getParameterGroup

  getParent = Data.getParent

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName

  getRoot = memops.api.Implementation.MemopsObject.getRoot

  getRun = Data.getRun

  getRunParameters = Data.getRunParameters

  getSerial = Data.getSerial

  getTopObject = memops.api.Implementation.DataObject.getTopObject
  
  def newEnergyTermParameter(self, **attrlinks):
    """
    Factory function to create ccp.nmr.NmrCalc.EnergyTermParameter
    """
    return EnergyTermParameter(self, **attrlinks)

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData

  removeConstraintList = ConstraintStoreData.removeConstraintList

  removeConstraintListSerial = ConstraintStoreData.removeConstraintListSerial

  removeRunParameter = Data.removeRunParameter
  
  def set(self, name, value):
    """
    SetAttr for ccp.nmr.NmrCalc.EnergyTerm
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess
  
  def setAnnealEnergyTerm(self, value):
    """
    setter for derived link annealEnergyTerm
    """
    dataDict = self.__dict__
    if (value is not None):
      from molsim.api.AnnealProtocol import EnergyTerm as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setAnnealEnergyTerm:
         value is not of class molsim.AnnealProtocol.EnergyTerm""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = self.getAnnealEnergyTerm()
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      if (value is not None):
        topObject = value.__dict__.get('topObject')
        topObjectsToCheck.add(topObject)

      if (currentValue is not None):
        topObject = currentValue.__dict__.get('topObject')
        topObjectsToCheck.add(topObject)

      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setAnnealEnergyTerm:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setAnnealEnergyTerm:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setAnnealEnergyTerm:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if value is None:
      self.annealEnergyTermSerial = None
    elif value.annealProtocol is self.run.annealProtocol:
      self.annealEnergyTermSerial = value.serial
    elif self.run.annealProtocol is None:
      self.annealEnergyTermSerial = value.serial
      self.run.annealProtocol = value.annealProtocol
    else:
      raise ApiError("%s does not belong to AnnealProtocol %s" % (value, self.run.annealProtocol ))
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

  def setAnnealEnergyTermSerial(self, value):
    """
    Set for ccp.nmr.NmrCalc.EnergyTerm.annealEnergyTermSerial
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.setAnnealEnergyTermSerial:
         memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('annealEnergyTermSerial')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setAnnealEnergyTermSerial:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setAnnealEnergyTermSerial:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['annealEnergyTermSerial'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setAnnealEnergyTermSerial')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData

  setCode = Data.setCode

  setConstraintListSerials = ConstraintStoreData.setConstraintListSerials

  setConstraintLists = ConstraintStoreData.setConstraintLists

  setConstraintStoreSerial = ConstraintStoreData.setConstraintStoreSerial

  setDetails = Data.setDetails

  setIoRole = Data.setIoRole

  setName = Data.setName

  setNmrConstraintStore = ConstraintStoreData.setNmrConstraintStore

  setParameterGroup = Data.setParameterGroup

  setRunParameters = Data.setRunParameters

  setSerial = Data.setSerial
  
  def sortedEnergyTermParameters(self):
    """
    Sorted for ccp.nmr.NmrCalc.EnergyTerm.energyTermParameters
    """
    dataDict = self.__dict__
    sortdd = dataDict.get('energyTermParameters')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result

  sortedRunParameters = Data.sortedRunParameters

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString
  
  annealEnergyTermSerial = property(getAnnealEnergyTermSerial, setAnnealEnergyTermSerial, None,
  r"""Serial of AnnealProtocol.EnergyTerm.serial associated with this 
  EnergyTerm. Part of key for derived link annealEnergyTerm
  """)

  applicationData = memops.api.Implementation.DataObject.applicationData

  className = memops.api.Implementation.ComplexDataType.className

  code = Data.code

  constraintListSerials = ConstraintStoreData.constraintListSerials

  constraintStoreSerial = ConstraintStoreData.constraintStoreSerial

  details = Data.details

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor

  ioRole = Data.ioRole

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted

  metaclass = memops.api.Implementation.ComplexDataType.metaclass

  name = Data.name

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName

  serial = Data.serial

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess
  
  annealEnergyTerm = property(getAnnealEnergyTerm, setAnnealEnergyTerm, None,
  r"""AnnealProtocol.EnergyTerm that corresponds to EnergyTerm
  """)

  constraintLists = ConstraintStoreData.constraintLists
  
  energyTermParameters = property(getEnergyTermParameters,  None, None,
  r"""child link to class EnergyTermParameter
  """)

  nmrConstraintStore = ConstraintStoreData.nmrConstraintStore

  parameterGroup = Data.parameterGroup

  parent = Data.parent

  root = memops.api.Implementation.MemopsObject.root

  run = Data.run

  runParameters = Data.runParameters

  topObject = memops.api.Implementation.DataObject.topObject
