"""
#######################################################################

CCPN Data Model version 2.1.2

Autogenerated by PyFileApiGen revision 1.57.2.1 on Mon Mar  2 17:26:03 2015
  from data model element ccp.lims.RefSampleComponent revision ?

#######################################################################
======================COPYRIGHT/LICENSE START==========================

RefSampleComponent.py: python API for CCPN data model, MetaPackage ccp.lims.RefSampleComponent

Copyright (C) 2007 Anne Pajon (MSD group, EBI)

=======================================================================

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
A copy of this license can be found in ../../../../license/LGPL.license
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
Lesser General Public License for more details.
 
You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA


======================COPYRIGHT/LICENSE END============================

for further information, please contact :

- PIMS website (http://www.pims-lims.org)

- email: Anne Pajon, pajon@ebi.ac.uk

=======================================================================

If you are using this software for academic purposes, we suggest
quoting the following references:

===========================REFERENCE START=============================
A. Pajon, J. Ionides, J. Diprose, J. Fillon, R. Fogh, A.W. Ashton,
H. Berman, W. Boucher, M. Cygler, E. Deleury, R. Esnouf, J. Janin, R. Kim,
I. Krimm, C.L. Lawson, E. Oeuillet, A. Poupon, S. Raymond, T. Stevens,
H. van Tilbeurgh, J. Westbrook, P. Wood, E. Ulrich, W. Vranken, L. Xueli,
E. Laue, D.I. Stuart, and K. Henrick (2005). Design of a Data Model for
Developing Laboratory Information Management and Analysis Systems for
Protein Production. Proteins: Structure, Function and Bioinformatics 58,
278-284.


This file was generated with the Memops software generation framework,
and contains original contributions embedded in the framework

===========================REFERENCE END===============================
"""

import cStringIO
#import sets
import traceback
import types
import operator

# special function for fast whitespace checking.
# used in DataType Word and Token handcode
import re
containsWhitespace = re.compile('\s').search
containsNonAlphanumeric = re.compile('[^a-zA-Z0-9_]').search
 
from memops.general import Implementation as implementation
ApiError = implementation.ApiError

# imported packages:
import ccp.api.general.Affiliation
import ccp.api.general.DbRef
import ccp.api.general.Taxonomy
import ccp.api.lims.Classification
import ccp.api.molecule.LabeledMolecule
import ccp.api.molecule.Molecule
import memops.api.AccessControl
import memops.api.Implementation

metaPackage = memops.api.Implementation.topPackage.metaObjFromQualName('ccp.lims.RefSampleComponent')

###############################################################################
class AbstractComponent(memops.api.Implementation.DataObject):
  r"""The abstract component is used to define the details which characterise 
all components, these are name, any synonyms and a CAS number. There are 
4 subclasses of abstract component: Molecular component (MolComponent), 
Cell, Substance and Composite.
  """
  #   from data model element ccp.lims.RefSampleComponent.AbstractComponent revision ?
  _metaclass = metaPackage.getElement('AbstractComponent')
  _packageName = 'ccp.lims.RefSampleComponent'
  _packageShortName = 'REFS'
  _fieldNames = ('applicationData', 'className', 'details', 'fieldNames', 'inConstructor', 'isDeleted', 'metaclass', 'name', 'packageName', 'packageShortName', 'qualifiedName', 'synonyms', 'access', 'activeAccess', 'categories', 'componentDbRefs', 'compositeElements', 'labels', 'naturalSource', 'parent', 'refSampleComponentStore', 'root', 'topObject',)

  __init__ = memops.api.Implementation.ComplexDataType.__init__

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData
  
  def addCategory(self, value):
    """
    Add for ccp.lims.RefSampleComponent.AbstractComponent.categories
    """
    dataDict = self.__dict__
    from ccp.api.lims.Classification import SampleComponentCategory as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.addCategory:
       value is not of class ccp.lims.Classification.SampleComponentCategory""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('categories')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      topObject = value.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)
      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.addCategory:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.addCategory:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.addCategory:
       called with deleted value""" % self.qualifiedName
      )

    if (value in currentValues):
      raise ApiError("""%s.addCategory:
       value is in list already""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.addCategory:
           Link categories between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    oldSelves = value.__dict__.get('components')
    oldSelves.add(self)
    currentValues.add(value)
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('addCategory')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def addSynonym(self, value):
    """
    Add for ccp.lims.RefSampleComponent.AbstractComponent.synonyms
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.addSynonym:
       memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 80):
      raise ApiError("""%s.addSynonym:
       memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.addSynonym:
       memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.splitlines()) <= 1)):
      raise ApiError("""%s.addSynonym:
       Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('synonyms')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.addSynonym:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.addSynonym:
       called on deleted object""" % self.qualifiedName
      )

    if (notOverride):
      pass

    currentValues.append(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('addSynonym')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  checkAllValid = memops.api.Implementation.ComplexDataType.checkAllValid

  checkValid = memops.api.Implementation.ComplexDataType.checkValid

  delete = memops.api.Implementation.DataObject.delete

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData
  
  def findAllCategories(self, **conditions):
    """
    FindAll for ccp.lims.RefSampleComponent.AbstractComponent.categories
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('categories')
      result = set(currentValues)

    else:
      currentValues = dataDict.get('categories')
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('details', 'name', 'access', 'classification',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllComponentDbRefs(self, **conditions):
    """
    FindAll for
    ccp.lims.RefSampleComponent.AbstractComponent.componentDbRefs
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('componentDbRefs').values()
      result = set(currentValues)

    else:
      currentValues = dataDict.get('componentDbRefs').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('alignBegin', 'alignEnd', 'dbRefAlignBegin', 'dbRefAlignEnd', 'details', 'serial', 'threadingProg', 'threadingScore', 'access', 'component', 'dbRef',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllCompositeElements(self, **conditions):
    """
    FindAll for
    ccp.lims.RefSampleComponent.AbstractComponent.compositeElements
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('compositeElements')
      result = set(currentValues)

    else:
      currentValues = dataDict.get('compositeElements')
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('details', 'serial', 'stoichiometry', 'access', 'component', 'composite',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllLabels(self, **conditions):
    """
    FindAll for ccp.lims.RefSampleComponent.AbstractComponent.labels
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('labels').values()
      result = set(currentValues)

    else:
      currentValues = dataDict.get('labels').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('elementName', 'incorporation', 'isUniform', 'labelName', 'labelType', 'massNumber', 'numInstances', 'serial', 'access', 'component',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData
  
  def findFirstCategory(self, **conditions):
    """
    FindFirst for ccp.lims.RefSampleComponent.AbstractComponent.categories
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('categories')
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      currentValues = dataDict.get('categories')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('details', 'name', 'access', 'classification',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstComponentDbRef(self, **conditions):
    """
    FindFirst for
    ccp.lims.RefSampleComponent.AbstractComponent.componentDbRefs
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('componentDbRefs').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      objKey = conditions.get('serial')
      if (objKey is not None):
        result = dataDict.get('componentDbRefs').get(objKey)

        if (nConditions <= 1):
          return result

        elif (result is None):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        currentValues = dataDict.get('componentDbRefs').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('alignBegin', 'alignEnd', 'dbRefAlignBegin', 'dbRefAlignEnd', 'details', 'serial', 'threadingProg', 'threadingScore', 'access', 'component', 'dbRef',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstCompositeElement(self, **conditions):
    """
    FindFirst for
    ccp.lims.RefSampleComponent.AbstractComponent.compositeElements
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('compositeElements')
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      currentValues = dataDict.get('compositeElements')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('details', 'serial', 'stoichiometry', 'access', 'component', 'composite',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstLabel(self, **conditions):
    """
    FindFirst for ccp.lims.RefSampleComponent.AbstractComponent.labels
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('labels').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      objKey = conditions.get('serial')
      if (objKey is not None):
        result = dataDict.get('labels').get(objKey)

        if (nConditions <= 1):
          return result

        elif (result is None):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        currentValues = dataDict.get('labels').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('elementName', 'incorporation', 'isUniform', 'labelName', 'labelType', 'massNumber', 'numInstances', 'serial', 'access', 'component',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccp.lims.RefSampleComponent.AbstractComponent
    """

    result = None
    if (startObj.__class__.__name__ == 'MemopsRoot'):
      if (2 != len(fullKey)):
        raise ApiError("""'ccp.lims.RefSampleComponent.AbstractComponent'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj0 = startObj
      objKey = fullKey[0]
      obj1 = obj0.__dict__.get('refSampleComponentStores').get(objKey)
      if (obj1 is None):
        obj0.refreshTopObjects('ccp.lims.RefSampleComponent')
        obj1 = obj0.__dict__.get('refSampleComponentStores').get(objKey)

    else:
      if (1 != len(fullKey)):
        raise ApiError("""'ccp.lims.RefSampleComponent.AbstractComponent'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj1 = startObj

    if (obj1 is not None):
      if (not (obj1.__dict__.get('isLoaded'))):
        obj1.load()

      objKey = fullKey[-1]
      obj2 = obj1.__dict__.get('components').get(objKey)
      result = obj2

    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation
  
  def getCategories(self):
    """
    Get for ccp.lims.RefSampleComponent.AbstractComponent.categories
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('categories')
    result = frozenset(tempVar)
    return result

  getClassName = memops.api.Implementation.ComplexDataType.getClassName
  
  def getComponentDbRefs(self):
    """
    Get for ccp.lims.RefSampleComponent.AbstractComponent.componentDbRefs
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('componentDbRefs').values()
    result = frozenset(tempVar)
    return result
  
  def getCompositeElements(self):
    """
    Get for ccp.lims.RefSampleComponent.AbstractComponent.compositeElements
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('compositeElements')
    result = frozenset(tempVar)
    return result
  
  def getDetails(self):
    """
    Get for ccp.lims.RefSampleComponent.AbstractComponent.details
    """
    dataDict = self.__dict__
    result = dataDict.get('details')
    return result

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames
  
  def getFullKey(self, useGuid=False):
    """
    GetFullKey for ccp.lims.RefSampleComponent.AbstractComponent
    """
    dataDict = self.__dict__
    result = list()

    obj1 = dataDict.get('refSampleComponentStore')

    if (useGuid):
      result.append(obj1.__dict__.get('guid'))
    else:
      result.append(obj1.__dict__.get('name'))

    result.append(dataDict.get('name'))

    return result

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted
  
  def getLabels(self):
    """
    Get for ccp.lims.RefSampleComponent.AbstractComponent.labels
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('labels').values()
    result = frozenset(tempVar)
    return result
  
  def getLocalKey(self):
    """
    GetLocalKey for ccp.lims.RefSampleComponent.AbstractComponent
    """
    dataDict = self.__dict__
    result = dataDict.get('name')
    return result

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass
  
  def getName(self):
    """
    Get for ccp.lims.RefSampleComponent.AbstractComponent.name
    """
    dataDict = self.__dict__
    result = dataDict.get('name')
    return result
  
  def getNaturalSource(self):
    """
    Get for ccp.lims.RefSampleComponent.AbstractComponent.naturalSource
    """
    dataDict = self.__dict__
    result = dataDict.get('naturalSource')
    return result

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName
  
  def getParent(self):
    """
    Get for ccp.lims.RefSampleComponent.AbstractComponent.parent
    """
    dataDict = self.__dict__
    result = dataDict.get('refSampleComponentStore')
    return result

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName
  
  def getRefSampleComponentStore(self):
    """
    Get for
    ccp.lims.RefSampleComponent.AbstractComponent.refSampleComponentStore
    """
    dataDict = self.__dict__
    result = dataDict.get('refSampleComponentStore')
    return result

  getRoot = memops.api.Implementation.MemopsObject.getRoot
  
  def getSynonyms(self):
    """
    Get for ccp.lims.RefSampleComponent.AbstractComponent.synonyms
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('synonyms')
    result = tuple(tempVar)
    return result

  getTopObject = memops.api.Implementation.DataObject.getTopObject
  
  def newComponentDbRef(self, **attrlinks):
    """
    Factory function to create ccp.lims.RefSampleComponent.ComponentDbRef
    """
    return ComponentDbRef(self, **attrlinks)
  
  def newLabel(self, **attrlinks):
    """
    Factory function to create ccp.lims.RefSampleComponent.Label
    """
    return Label(self, **attrlinks)

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData
  
  def removeCategory(self, value):
    """
    Remove for ccp.lims.RefSampleComponent.AbstractComponent.categories
    """
    dataDict = self.__dict__
    from ccp.api.lims.Classification import SampleComponentCategory as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.removeCategory:
       value is not of class ccp.lims.Classification.SampleComponentCategory""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('categories')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      topObject = value.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)
      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.removeCategory:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.removeCategory:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.removeCategory:
       called with deleted value""" % self.qualifiedName
      )

    if (not (value in currentValues)):
      raise ApiError("""%s.removeCategory:
       value not in list""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      pass

    oldSelves = value.__dict__.get('components')
    oldSelves.remove(self)
    currentValues.remove(value)
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('removeCategory')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def removeSynonym(self, value):
    """
    Remove for ccp.lims.RefSampleComponent.AbstractComponent.synonyms
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.removeSynonym:
       memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 80):
      raise ApiError("""%s.removeSynonym:
       memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.removeSynonym:
       memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.splitlines()) <= 1)):
      raise ApiError("""%s.removeSynonym:
       Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('synonyms')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.removeSynonym:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.removeSynonym:
       called on deleted object""" % self.qualifiedName
      )

    if (not (value in currentValues)):
      raise ApiError("""%s.removeSynonym:
       value not in list""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      pass

    currentValues.remove(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('removeSynonym')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  setAccess = memops.api.Implementation.DataObject.setAccess

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData
  
  def setCategories(self, values):
    """
    Set for ccp.lims.RefSampleComponent.AbstractComponent.categories
    """
    dataDict = self.__dict__
    xx = values
    values = set(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setCategories:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      from ccp.api.lims.Classification import SampleComponentCategory as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setCategories:
         value is not of class ccp.lims.Classification.SampleComponentCategory""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('categories')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      for pv in currentValues:
        if (not (pv in values)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)

      for pv in values:
        if (not (pv in currentValues)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)

      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setCategories:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setCategories:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setCategories:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
      for value in values:
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setCategories:
           Link categories between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    for cv in currentValues:
      if (not (cv in values)):
        oldSelves = cv.__dict__.get('components')
        oldSelves.remove(self)

    for cv in values:
      if (not (cv in currentValues)):
        oldSelves = cv.__dict__.get('components')
        oldSelves.add(self)

    dataDict['categories'] = values
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setCategories')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setCompositeElements(self, values):
    """
    Set for ccp.lims.RefSampleComponent.AbstractComponent.compositeElements
    """
    dataDict = self.__dict__
    xx = values
    values = set(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setCompositeElements:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      if (not isinstance(value, CompositeElement)):
        raise ApiError("""%s.setCompositeElements:
         value is not of class ccp.lims.RefSampleComponent.CompositeElement""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('compositeElements')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setCompositeElements:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setCompositeElements:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setCompositeElements:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      for cv in currentValues:
        if (not (cv in values)):
          raise ApiError("""%s.setCompositeElements:
           locard component: cannot set because some of current values not in values""" % self.qualifiedName
           + ": %s" % (self,)
          )

      xx1 = dataDict.get('topObject')
      for value in values:
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setCompositeElements:
           Link compositeElements between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    for cv in currentValues:
      if (not (cv in values)):
        cv.__dict__['component'] = None

    for cv in values:
      if (not (cv in currentValues)):
        oldSelf = cv.__dict__.get('component')
        if (oldSelf is not None):
          vv = oldSelf.__dict__.get('compositeElements')
          vv.remove(cv)

      cv.__dict__['component'] = self

    dataDict['compositeElements'] = values
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setCompositeElements')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setDetails(self, value):
    """
    Set for ccp.lims.RefSampleComponent.AbstractComponent.details
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setDetails:
         memops.Implementation.String input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('details')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setDetails:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setDetails:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['details'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setDetails')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setName(self, value):
    """
    Set for ccp.lims.RefSampleComponent.AbstractComponent.name
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.setName:
       memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 80):
      raise ApiError("""%s.setName:
       memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.setName:
       memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.splitlines()) <= 1)):
      raise ApiError("""%s.setName:
       Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('name')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setName:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setName:
         cannot set name, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['name'] = value

    # doNotifies
  
  def setNaturalSource(self, value):
    """
    Set for ccp.lims.RefSampleComponent.AbstractComponent.naturalSource
    """
    dataDict = self.__dict__
    if (value is not None):
      from ccp.api.general.Taxonomy import NaturalSource as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setNaturalSource:
         value is not of class ccp.general.Taxonomy.NaturalSource""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('naturalSource')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setNaturalSource:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setNaturalSource:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setNaturalSource:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setNaturalSource:
           Link naturalSource between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    dataDict['naturalSource'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setNaturalSource')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setSynonyms(self, values):
    """
    Set for ccp.lims.RefSampleComponent.AbstractComponent.synonyms
    """
    dataDict = self.__dict__
    values = list(values)
    for value in values:
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setSynonyms:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.setSynonyms:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setSynonyms:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.setSynonyms:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('synonyms')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setSynonyms:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setSynonyms:
       called on deleted object""" % self.qualifiedName
      )

    if (values == currentValues):
      return

    if (notOverride):
      pass

    dataDict['synonyms'] = values
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setSynonyms')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def sortedCategories(self):
    """
    Sorted for ccp.lims.RefSampleComponent.AbstractComponent.categories
    """
    dataDict = self.__dict__
    ll = dataDict.get('categories')
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result
  
  def sortedComponentDbRefs(self):
    """
    Sorted for ccp.lims.RefSampleComponent.AbstractComponent.componentDbRefs
    """
    dataDict = self.__dict__
    sortdd = dataDict.get('componentDbRefs')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result
  
  def sortedCompositeElements(self):
    """
    Sorted for
    ccp.lims.RefSampleComponent.AbstractComponent.compositeElements
    """
    dataDict = self.__dict__
    ll = dataDict.get('compositeElements')
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result
  
  def sortedLabels(self):
    """
    Sorted for ccp.lims.RefSampleComponent.AbstractComponent.labels
    """
    dataDict = self.__dict__
    sortdd = dataDict.get('labels')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  applicationData = memops.api.Implementation.DataObject.applicationData

  className = memops.api.Implementation.ComplexDataType.className
  
  details = property(getDetails, setDetails, None,
  r"""Detail field for comments.
  """)

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted

  metaclass = memops.api.Implementation.ComplexDataType.metaclass
  
  name = property(getName, setName, None,
  r"""The name of the component. Unique identifier.
  """)

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName
  
  synonyms = property(getSynonyms, setSynonyms, None,
  r"""The synonyms of the component.
  """)

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess
  
  categories = property(getCategories, setCategories, None,
  r"""List of category associated to a component.
  """)
  
  componentDbRefs = property(getComponentDbRefs,  None, None,
  r"""child link to class ComponentDbRef
  """)
  
  compositeElements = property(getCompositeElements, setCompositeElements, None,
  r"""List of element where the component is part of a composite.
  """)
  
  labels = property(getLabels,  None, None,
  r"""child link to class Label
  """)
  
  naturalSource = property(getNaturalSource, setNaturalSource, None,
  r"""The natural source of the component.
  """)
  
  parent = property(getParent, None, None,
  r"""link to parent object - synonym for refSampleComponentStore
  """)
  
  refSampleComponentStore = property(getRefSampleComponentStore,  None, None,
  r"""parent link
  """)

  root = memops.api.Implementation.MemopsObject.root

  topObject = memops.api.Implementation.DataObject.topObject

###############################################################################
class ComponentDbRef(memops.api.Implementation.DataObject):
  r"""The link between a database reference (DbRef) and a component.
  """
  #   from data model element ccp.lims.RefSampleComponent.ComponentDbRef revision ?
  _metaclass = metaPackage.getElement('ComponentDbRef')
  _packageName = 'ccp.lims.RefSampleComponent'
  _packageShortName = 'REFS'
  _fieldNames = ('alignBegin', 'alignEnd', 'applicationData', 'className', 'dbRefAlignBegin', 'dbRefAlignEnd', 'details', 'fieldNames', 'inConstructor', 'isDeleted', 'metaclass', 'packageName', 'packageShortName', 'qualifiedName', 'serial', 'threadingProg', 'threadingScore', 'access', 'activeAccess', 'component', 'dbRef', 'parent', 'root', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for ccp.lims.RefSampleComponent.ComponentDbRef
    """
    dataDict = self.__dict__
    dataDict['component'] = parent
    if (not isinstance(parent, AbstractComponent)):
      raise ApiError("""%s.__init__:
       value is not of class ccp.lims.RefSampleComponent.AbstractComponent""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = parent.__dict__.get('topObject')
    dataDict['topObject'] = topObject

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    if (notIsReading):
      if (not (topObject.__dict__.get('isModifiable'))):
        raise ApiError("""%s.__init__:
         Storage not modifiable""" % self.qualifiedName
         + ": %s" % (topObject,)
        )

    try:

      dataDict['alignBegin'] = None
      dataDict['alignEnd'] = None
      dataDict['applicationData'] = list()
      dataDict['dbRefAlignBegin'] = None
      dataDict['dbRefAlignEnd'] = None
      dataDict['details'] = None
      dataDict['serial'] = None
      dataDict['threadingProg'] = None
      dataDict['threadingScore'] = None
      dataDict['access'] = None
      dataDict['dbRef'] = None

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in ccp.lims.RefSampleComponent.ComponentDbRef.__init__"
        del dataDict['inConstructor']
        raise

      if (notOverride):
        if (dataDict.get('serial') is None):
          dataDict['inConstructor'] = True
          self.setSerial(-1)
          del dataDict['inConstructor']
        else:
          raise ApiError("""%s.__init__:
           Cannot pass in explicit serial if not reading""" % self.qualifiedName
           + ": %s:%s" % (parent, 'ccp.lims.RefSampleComponent.ComponentDbRef')
          )

      if (notIsReading):
        childrenDict = parent.__dict__.get('componentDbRefs')
        objKey = dataDict.get('serial')
        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['serial'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notOverride):
        self.checkValid()

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for ccp.lims.RefSampleComponent.ComponentDbRef:
       
    determines cascading deletes to follow from delete of object.
       
    *Implementation function* - should be called only by API delete 
    function.
    """
    dataDict = self.__dict__
    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    dbRef = dataDict.get('dbRef')
    if (dbRef is not None):
      topObject = dbRef.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for ccp.lims.RefSampleComponent.ComponentDbRef:   deletes
    objects
    *Implementation function* - will CORRUPT DATA if called outside 
    the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    dbRef = dataDict.get('dbRef')
    if ((dbRef is not None and not (dbRef in objsToBeDeleted))):
      componentDbRefs = dbRef.__dict__.get('componentDbRefs')
      componentDbRefs.remove(self)

    component = dataDict.get('component')
    if (not (component in objsToBeDeleted)):
      objKey = dataDict.get('serial')
      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = component.__dict__.get('componentDbRefs')
        if (self is dd.get(objKey)):
          del dd[objKey]

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData
  
  def checkAllValid(self, complete=False):
    """
    CheckAllValid for ccp.lims.RefSampleComponent.ComponentDbRef
    """
    dataDict = self.__dict__
    self.checkValid(complete)
  
  def checkValid(self, complete=False):
    """
    CheckValid for ccp.lims.RefSampleComponent.ComponentDbRef
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      objKey = dataDict.get('serial')
      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('component')
        dd = value.__dict__.get('componentDbRefs')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'component' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      # check attributes
      value = dataDict.get('alignBegin')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.Int.PythonType)):
          pass
        elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
          value = memops.api.Implementation.Int.create(value)
        else:
          raise ApiError("""%s.checkValid: alignBegin:
           memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('alignEnd')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.Int.PythonType)):
          pass
        elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
          value = memops.api.Implementation.Int.create(value)
        else:
          raise ApiError("""%s.checkValid: alignEnd:
           memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('dbRefAlignBegin')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.Int.PythonType)):
          pass
        elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
          value = memops.api.Implementation.Int.create(value)
        else:
          raise ApiError("""%s.checkValid: dbRefAlignBegin:
           memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('dbRefAlignEnd')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.Int.PythonType)):
          pass
        elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
          value = memops.api.Implementation.Int.create(value)
        else:
          raise ApiError("""%s.checkValid: dbRefAlignEnd:
           memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('details')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: details:
           memops.Implementation.String input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('serial')
      if (value is None):
        raise ApiError("""%s.checkValid: serial:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.checkValid: serial:
         memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('threadingProg')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: threadingProg:
           memops.Implementation.Text input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 254):
          raise ApiError("""%s.checkValid: threadingProg:
           memops.Implementation.Text maximum length is 254 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: threadingProg:
           memops.Implementation.Text: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('threadingScore')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.Float.PythonType)):
          pass
        elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
          value = memops.api.Implementation.Float.create(value)
        else:
          raise ApiError("""%s.checkValid: threadingScore:
           memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (value - value == 0.0)):
          raise ApiError("""%s.checkValid: threadingScore:
           Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('component')
      if (not isinstance(value, AbstractComponent)):
        raise ApiError("""%s.checkValid: component:
         value is not of class ccp.lims.RefSampleComponent.AbstractComponent""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('dbRef')
      from ccp.api.general.DbRef import Entry as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.checkValid: dbRef:
         value is not of class ccp.general.DbRef.Entry""" % self.qualifiedName
         + ": %s" % (value,)
        )

      oldSelves = value.__dict__.get('componentDbRefs')
      if (not (self in oldSelves)):
        raise ApiError("""%s.checkValid: dbRef:
         non-reciprocal link dbRef from object""" % self.qualifiedName
         + ": %s" % (self,)
        )

    # check explicit class constraints
    # check attributes
    value = dataDict.get('alignBegin')
    value = dataDict.get('alignEnd')
    values = dataDict.get('applicationData')
    for value in values:
      value.checkAllValid(complete)

    value = dataDict.get('dbRefAlignBegin')
    value = dataDict.get('dbRefAlignEnd')
    value = dataDict.get('details')
    value = dataDict.get('threadingProg')
    value = dataDict.get('threadingScore')
    # check roles
    value = dataDict.get('access')
    value = dataDict.get('component')
    if (value is None):
      raise ApiError("""%s.checkValid: component:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('dbRef')
    if (value is None):
      raise ApiError("""%s.checkValid: dbRef:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

  delete = memops.api.Implementation.DataObject.delete

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData
  
  def get(self, name):
    """
    GetAttr for ccp.lims.RefSampleComponent.ComponentDbRef
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess
  
  def getAlignBegin(self):
    """
    Get for ccp.lims.RefSampleComponent.ComponentDbRef.alignBegin
    """
    dataDict = self.__dict__
    result = dataDict.get('alignBegin')
    return result
  
  def getAlignEnd(self):
    """
    Get for ccp.lims.RefSampleComponent.ComponentDbRef.alignEnd
    """
    dataDict = self.__dict__
    result = dataDict.get('alignEnd')
    return result

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccp.lims.RefSampleComponent.ComponentDbRef
    """

    result = None
    if (startObj.__class__.__name__ == 'MemopsRoot'):
      if (3 != len(fullKey)):
        raise ApiError("""'ccp.lims.RefSampleComponent.ComponentDbRef'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj0 = startObj
      objKey = fullKey[0]
      obj1 = obj0.__dict__.get('refSampleComponentStores').get(objKey)
      if (obj1 is None):
        obj0.refreshTopObjects('ccp.lims.RefSampleComponent')
        obj1 = obj0.__dict__.get('refSampleComponentStores').get(objKey)

    else:
      if (2 != len(fullKey)):
        raise ApiError("""'ccp.lims.RefSampleComponent.ComponentDbRef'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj1 = startObj

    if (obj1 is not None):
      if (not (obj1.__dict__.get('isLoaded'))):
        obj1.load()

      objKey = fullKey[-2]
      obj2 = obj1.__dict__.get('components').get(objKey)

      if (obj2 is not None):
        objKey = fullKey[-1]
        obj3 = obj2.__dict__.get('componentDbRefs').get(objKey)
        result = obj3

    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation

  getClassName = memops.api.Implementation.ComplexDataType.getClassName
  
  def getComponent(self):
    """
    Get for ccp.lims.RefSampleComponent.ComponentDbRef.component
    """
    dataDict = self.__dict__
    result = dataDict.get('component')
    return result
  
  def getDbRef(self):
    """
    Get for ccp.lims.RefSampleComponent.ComponentDbRef.dbRef
    """
    dataDict = self.__dict__
    result = dataDict.get('dbRef')
    return result
  
  def getDbRefAlignBegin(self):
    """
    Get for ccp.lims.RefSampleComponent.ComponentDbRef.dbRefAlignBegin
    """
    dataDict = self.__dict__
    result = dataDict.get('dbRefAlignBegin')
    return result
  
  def getDbRefAlignEnd(self):
    """
    Get for ccp.lims.RefSampleComponent.ComponentDbRef.dbRefAlignEnd
    """
    dataDict = self.__dict__
    result = dataDict.get('dbRefAlignEnd')
    return result
  
  def getDetails(self):
    """
    Get for ccp.lims.RefSampleComponent.ComponentDbRef.details
    """
    dataDict = self.__dict__
    result = dataDict.get('details')
    return result

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames
  
  def getFullKey(self, useGuid=False):
    """
    GetFullKey for ccp.lims.RefSampleComponent.ComponentDbRef
    """
    dataDict = self.__dict__
    result = list()

    obj2 = dataDict.get('component')
    obj1 = obj2.__dict__.get('refSampleComponentStore')

    if (useGuid):
      result.append(obj1.__dict__.get('guid'))
    else:
      result.append(obj1.__dict__.get('name'))

    result.append(obj2.__dict__.get('name'))
    result.append(dataDict.get('serial'))

    return result

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted
  
  def getLocalKey(self):
    """
    GetLocalKey for ccp.lims.RefSampleComponent.ComponentDbRef
    """
    dataDict = self.__dict__
    result = dataDict.get('serial')
    return result

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName
  
  def getParent(self):
    """
    Get for ccp.lims.RefSampleComponent.ComponentDbRef.parent
    """
    dataDict = self.__dict__
    result = dataDict.get('component')
    return result

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName

  getRoot = memops.api.Implementation.MemopsObject.getRoot
  
  def getSerial(self):
    """
    Get for ccp.lims.RefSampleComponent.ComponentDbRef.serial
    """
    dataDict = self.__dict__
    result = dataDict.get('serial')
    return result
  
  def getThreadingProg(self):
    """
    Get for ccp.lims.RefSampleComponent.ComponentDbRef.threadingProg
    """
    dataDict = self.__dict__
    result = dataDict.get('threadingProg')
    return result
  
  def getThreadingScore(self):
    """
    Get for ccp.lims.RefSampleComponent.ComponentDbRef.threadingScore
    """
    dataDict = self.__dict__
    result = dataDict.get('threadingScore')
    return result

  getTopObject = memops.api.Implementation.DataObject.getTopObject

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData
  
  def set(self, name, value):
    """
    SetAttr for ccp.lims.RefSampleComponent.ComponentDbRef
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess
  
  def setAlignBegin(self, value):
    """
    Set for ccp.lims.RefSampleComponent.ComponentDbRef.alignBegin
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.setAlignBegin:
         memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('alignBegin')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setAlignBegin:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setAlignBegin:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['alignBegin'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setAlignBegin')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setAlignEnd(self, value):
    """
    Set for ccp.lims.RefSampleComponent.ComponentDbRef.alignEnd
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.setAlignEnd:
         memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('alignEnd')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setAlignEnd:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setAlignEnd:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['alignEnd'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setAlignEnd')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData
  
  def setDbRef(self, value):
    """
    Set for ccp.lims.RefSampleComponent.ComponentDbRef.dbRef
    """
    dataDict = self.__dict__
    from ccp.api.general.DbRef import Entry as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.setDbRef:
       value is not of class ccp.general.DbRef.Entry""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('dbRef')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      if (value is not None):
        topObject = value.__dict__.get('topObject')
        topObjectsToCheck.add(topObject)

      if (currentValue is not None):
        topObject = currentValue.__dict__.get('topObject')
        topObjectsToCheck.add(topObject)

      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setDbRef:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setDbRef:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setDbRef:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setDbRef:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
      yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
      if (not (xx1 is yy1)):
        raise ApiError("""%s.setDbRef:
         Link dbRef between objects from separate partitions
         - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
         + ": %s:%s" % (self, value)
        )

    if (currentValue is not None):
      if (notIsReading):
        oldSelves = currentValue.__dict__.get('componentDbRefs')
        oldSelves.remove(self)
      else:
        raise ApiError("""%s.setDbRef:
         Read link 'dbRef' incompatible with pre-existing link""" % self.qualifiedName
         + ": %s" % (self,)
        )

    if (value is not None):
      newSelves = value.__dict__.get('componentDbRefs')
      newSelves.add(self)

    dataDict['dbRef'] = value
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setDbRef')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setDbRefAlignBegin(self, value):
    """
    Set for ccp.lims.RefSampleComponent.ComponentDbRef.dbRefAlignBegin
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.setDbRefAlignBegin:
         memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('dbRefAlignBegin')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setDbRefAlignBegin:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setDbRefAlignBegin:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['dbRefAlignBegin'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setDbRefAlignBegin')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setDbRefAlignEnd(self, value):
    """
    Set for ccp.lims.RefSampleComponent.ComponentDbRef.dbRefAlignEnd
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.setDbRefAlignEnd:
         memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('dbRefAlignEnd')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setDbRefAlignEnd:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setDbRefAlignEnd:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['dbRefAlignEnd'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setDbRefAlignEnd')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setDetails(self, value):
    """
    Set for ccp.lims.RefSampleComponent.ComponentDbRef.details
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setDetails:
         memops.Implementation.String input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('details')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setDetails:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setDetails:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['details'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setDetails')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setSerial(self, value):
    """
    Set for ccp.lims.RefSampleComponent.ComponentDbRef.serial
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Int.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Int.create(value)
    else:
      raise ApiError("""%s.setSerial:
       memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('serial')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setSerial:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setSerial:
         cannot set serial, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setSerial:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    parent = dataDict.get('component')
    oldSerial = parent.__dict__.get('_serialDict').get('componentDbRefs')
    if (value < 0):
      value = (oldSerial + 1)
      parent.__dict__.get('_serialDict')['componentDbRefs'] = value
    elif (value > oldSerial):
      parent.__dict__.get('_serialDict')['componentDbRefs'] = value

    dataDict['serial'] = value

    # doNotifies
  
  def setThreadingProg(self, value):
    """
    Set for ccp.lims.RefSampleComponent.ComponentDbRef.threadingProg
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setThreadingProg:
         memops.Implementation.Text input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 254):
        raise ApiError("""%s.setThreadingProg:
         memops.Implementation.Text maximum length is 254 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setThreadingProg:
         memops.Implementation.Text: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('threadingProg')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setThreadingProg:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setThreadingProg:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['threadingProg'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setThreadingProg')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setThreadingScore(self, value):
    """
    Set for ccp.lims.RefSampleComponent.ComponentDbRef.threadingScore
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.Float.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Float.create(value)
      else:
        raise ApiError("""%s.setThreadingScore:
         memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value - value == 0.0)):
        raise ApiError("""%s.setThreadingScore:
         Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('threadingScore')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setThreadingScore:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setThreadingScore:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['threadingScore'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setThreadingScore')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString
  
  alignBegin = property(getAlignBegin, setAlignBegin, None,
  r"""Optional. Residue number  (MolRedidue.serial)in the molecule sequence 
  where the alignment begins.
  """)
  
  alignEnd = property(getAlignEnd, setAlignEnd, None,
  r"""Optional. Residue number (MolRedidue.serial) in the molecule sequence 
  where the alignment ends.
  """)

  applicationData = memops.api.Implementation.DataObject.applicationData

  className = memops.api.Implementation.ComplexDataType.className
  
  dbRefAlignBegin = property(getDbRefAlignBegin, setDbRefAlignBegin, None,
  r"""Optional. Residue number in the database reference sequence where the 
  alignment begins.
  """)
  
  dbRefAlignEnd = property(getDbRefAlignEnd, setDbRefAlignEnd, None,
  r"""Optional. Residue number in the database reference sequence where the 
  alignment ends.
  """)
  
  details = property(getDetails, setDetails, None,
  r"""Detail field for comments.
  """)

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted

  metaclass = memops.api.Implementation.ComplexDataType.metaclass

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName
  
  serial = property(getSerial, setSerial, None,
  r"""Unique identifier.
  """)
  
  threadingProg = property(getThreadingProg, setThreadingProg, None,
  r"""Program used to obtain the threading score.
  """)
  
  threadingScore = property(getThreadingScore, setThreadingScore, None,
  r"""The scoring value.
  """)

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess
  
  component = property(getComponent,  None, None,
  r"""Link to the abstract component to which this entry belongs.
  """)
  
  dbRef = property(getDbRef, setDbRef, None,
  r"""The database reference to which this entry belongs.
  """)
  
  parent = property(getParent, None, None,
  r"""link to parent object - synonym for component
  """)

  root = memops.api.Implementation.MemopsObject.root

  topObject = memops.api.Implementation.DataObject.topObject

###############################################################################
class CompositeElement(memops.api.Implementation.DataObject):
  r"""One element of the composite.
  """
  #   from data model element ccp.lims.RefSampleComponent.CompositeElement revision ?
  _metaclass = metaPackage.getElement('CompositeElement')
  _packageName = 'ccp.lims.RefSampleComponent'
  _packageShortName = 'REFS'
  _fieldNames = ('applicationData', 'className', 'details', 'fieldNames', 'inConstructor', 'isDeleted', 'metaclass', 'packageName', 'packageShortName', 'qualifiedName', 'serial', 'stoichiometry', 'access', 'activeAccess', 'component', 'composite', 'interactions', 'parent', 'root', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for ccp.lims.RefSampleComponent.CompositeElement
    """
    dataDict = self.__dict__
    dataDict['composite'] = parent
    if (not isinstance(parent, Composite)):
      raise ApiError("""%s.__init__:
       value is not of class ccp.lims.RefSampleComponent.Composite""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = parent.__dict__.get('topObject')
    dataDict['topObject'] = topObject

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    if (notIsReading):
      if (not (topObject.__dict__.get('isModifiable'))):
        raise ApiError("""%s.__init__:
         Storage not modifiable""" % self.qualifiedName
         + ": %s" % (topObject,)
        )

    try:

      dataDict['applicationData'] = list()
      dataDict['details'] = None
      dataDict['serial'] = None
      dataDict['stoichiometry'] = None
      dataDict['access'] = None
      dataDict['component'] = None
      dataDict['interactions'] = set()

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in ccp.lims.RefSampleComponent.CompositeElement.__init__"
        del dataDict['inConstructor']
        raise

      if (notOverride):
        if (dataDict.get('serial') is None):
          dataDict['inConstructor'] = True
          self.setSerial(-1)
          del dataDict['inConstructor']
        else:
          raise ApiError("""%s.__init__:
           Cannot pass in explicit serial if not reading""" % self.qualifiedName
           + ": %s:%s" % (parent, 'ccp.lims.RefSampleComponent.CompositeElement')
          )

      if (notIsReading):
        childrenDict = parent.__dict__.get('elements')
        objKey = dataDict.get('serial')
        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['serial'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notOverride):
        self.checkValid()

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for ccp.lims.RefSampleComponent.CompositeElement:
       
    determines cascading deletes to follow from delete of object.
       
    *Implementation function* - should be called only by API delete 
    function.
    """
    dataDict = self.__dict__
    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    interactions = dataDict.get('interactions')
    for interaction in interactions:
      if (not (interaction in objsToBeDeleted)):
        objsToBeDeleted.add(interaction)
        objsToBeChecked.append(interaction)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for ccp.lims.RefSampleComponent.CompositeElement:   deletes
    objects
    *Implementation function* - will CORRUPT DATA if called outside 
    the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    component = dataDict.get('component')
    if ((component is not None and not (component in objsToBeDeleted))):
      compositeElements = component.__dict__.get('compositeElements')
      compositeElements.remove(self)

    composite = dataDict.get('composite')
    if (not (composite in objsToBeDeleted)):
      objKey = dataDict.get('serial')
      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = composite.__dict__.get('elements')
        if (self is dd.get(objKey)):
          del dd[objKey]

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData
  
  def checkAllValid(self, complete=False):
    """
    CheckAllValid for ccp.lims.RefSampleComponent.CompositeElement
    """
    dataDict = self.__dict__
    self.checkValid(complete)
  
  def checkValid(self, complete=False):
    """
    CheckValid for ccp.lims.RefSampleComponent.CompositeElement
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      objKey = dataDict.get('serial')
      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('composite')
        dd = value.__dict__.get('elements')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'composite' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      # check attributes
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('details')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: details:
           memops.Implementation.String input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('serial')
      if (value is None):
        raise ApiError("""%s.checkValid: serial:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.checkValid: serial:
         memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('stoichiometry')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.Int.PythonType)):
          pass
        elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
          value = memops.api.Implementation.Int.create(value)
        else:
          raise ApiError("""%s.checkValid: stoichiometry:
           memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('component')
      if (not isinstance(value, AbstractComponent)):
        raise ApiError("""%s.checkValid: component:
         value is not of class ccp.lims.RefSampleComponent.AbstractComponent""" % self.qualifiedName
         + ": %s" % (value,)
        )

      oldSelves = value.__dict__.get('compositeElements')
      if (not (self in oldSelves)):
        raise ApiError("""%s.checkValid: component:
         non-reciprocal link component from object""" % self.qualifiedName
         + ": %s" % (self,)
        )

      value = dataDict.get('composite')
      if (not isinstance(value, Composite)):
        raise ApiError("""%s.checkValid: composite:
         value is not of class ccp.lims.RefSampleComponent.Composite""" % self.qualifiedName
         + ": %s" % (value,)
        )

      values = dataDict.get('interactions')
      for value in values:
        if (not isinstance(value, CompositeInteraction)):
          raise ApiError("""%s.checkValid: interactions:
           value is not of class ccp.lims.RefSampleComponent.CompositeInteraction""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('elements')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: interactions:
           non-reciprocal link interactions from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: interactions:
           Link interactions between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    # check explicit class constraints
    # check attributes
    values = dataDict.get('applicationData')
    for value in values:
      value.checkAllValid(complete)

    value = dataDict.get('details')
    value = dataDict.get('stoichiometry')
    # check roles
    value = dataDict.get('access')
    value = dataDict.get('component')
    if (value is None):
      raise ApiError("""%s.checkValid: component:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('composite')
    if (value is None):
      raise ApiError("""%s.checkValid: composite:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    values = dataDict.get('interactions')

  delete = memops.api.Implementation.DataObject.delete

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData
  
  def findAllInteractions(self, **conditions):
    """
    FindAll for ccp.lims.RefSampleComponent.CompositeElement.interactions
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('interactions')
      result = set(currentValues)

    else:
      currentValues = dataDict.get('interactions')
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('affinity', 'assessmentMethod', 'details', 'interactionType', 'serial', 'access', 'composite',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData
  
  def findFirstInteraction(self, **conditions):
    """
    FindFirst for ccp.lims.RefSampleComponent.CompositeElement.interactions
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('interactions')
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      currentValues = dataDict.get('interactions')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('affinity', 'assessmentMethod', 'details', 'interactionType', 'serial', 'access', 'composite',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def get(self, name):
    """
    GetAttr for ccp.lims.RefSampleComponent.CompositeElement
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccp.lims.RefSampleComponent.CompositeElement
    """

    result = None
    if (startObj.__class__.__name__ == 'MemopsRoot'):
      if (3 != len(fullKey)):
        raise ApiError("""'ccp.lims.RefSampleComponent.CompositeElement'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj0 = startObj
      objKey = fullKey[0]
      obj1 = obj0.__dict__.get('refSampleComponentStores').get(objKey)
      if (obj1 is None):
        obj0.refreshTopObjects('ccp.lims.RefSampleComponent')
        obj1 = obj0.__dict__.get('refSampleComponentStores').get(objKey)

    else:
      if (2 != len(fullKey)):
        raise ApiError("""'ccp.lims.RefSampleComponent.CompositeElement'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj1 = startObj

    if (obj1 is not None):
      if (not (obj1.__dict__.get('isLoaded'))):
        obj1.load()

      objKey = fullKey[-2]
      obj2 = obj1.__dict__.get('components').get(objKey)

      if (obj2 is not None):
        objKey = fullKey[-1]
        obj3 = obj2.__dict__.get('elements').get(objKey)
        result = obj3

    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation

  getClassName = memops.api.Implementation.ComplexDataType.getClassName
  
  def getComponent(self):
    """
    Get for ccp.lims.RefSampleComponent.CompositeElement.component
    """
    dataDict = self.__dict__
    result = dataDict.get('component')
    return result
  
  def getComposite(self):
    """
    Get for ccp.lims.RefSampleComponent.CompositeElement.composite
    """
    dataDict = self.__dict__
    result = dataDict.get('composite')
    return result
  
  def getDetails(self):
    """
    Get for ccp.lims.RefSampleComponent.CompositeElement.details
    """
    dataDict = self.__dict__
    result = dataDict.get('details')
    return result

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames
  
  def getFullKey(self, useGuid=False):
    """
    GetFullKey for ccp.lims.RefSampleComponent.CompositeElement
    """
    dataDict = self.__dict__
    result = list()

    obj2 = dataDict.get('composite')
    obj1 = obj2.__dict__.get('refSampleComponentStore')

    if (useGuid):
      result.append(obj1.__dict__.get('guid'))
    else:
      result.append(obj1.__dict__.get('name'))

    result.append(obj2.__dict__.get('name'))
    result.append(dataDict.get('serial'))

    return result

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor
  
  def getInteractions(self):
    """
    Get for ccp.lims.RefSampleComponent.CompositeElement.interactions
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('interactions')
    result = frozenset(tempVar)
    return result

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted
  
  def getLocalKey(self):
    """
    GetLocalKey for ccp.lims.RefSampleComponent.CompositeElement
    """
    dataDict = self.__dict__
    result = dataDict.get('serial')
    return result

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName
  
  def getParent(self):
    """
    Get for ccp.lims.RefSampleComponent.CompositeElement.parent
    """
    dataDict = self.__dict__
    result = dataDict.get('composite')
    return result

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName

  getRoot = memops.api.Implementation.MemopsObject.getRoot
  
  def getSerial(self):
    """
    Get for ccp.lims.RefSampleComponent.CompositeElement.serial
    """
    dataDict = self.__dict__
    result = dataDict.get('serial')
    return result
  
  def getStoichiometry(self):
    """
    Get for ccp.lims.RefSampleComponent.CompositeElement.stoichiometry
    """
    dataDict = self.__dict__
    result = dataDict.get('stoichiometry')
    return result

  getTopObject = memops.api.Implementation.DataObject.getTopObject

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData
  
  def set(self, name, value):
    """
    SetAttr for ccp.lims.RefSampleComponent.CompositeElement
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData
  
  def setComponent(self, value):
    """
    Set for ccp.lims.RefSampleComponent.CompositeElement.component
    """
    dataDict = self.__dict__
    if (not isinstance(value, AbstractComponent)):
      raise ApiError("""%s.setComponent:
       value is not of class ccp.lims.RefSampleComponent.AbstractComponent""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('component')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setComponent:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setComponent:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setComponent:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setComponent:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      xx1 = dataDict.get('topObject')
      yy1 = value.__dict__.get('topObject')
      if (not (xx1 is yy1)):
        raise ApiError("""%s.setComponent:
         Link component between objects from separate partitions
         - memops.Implementation.TopObject does not match""" % self.qualifiedName
         + ": %s:%s" % (self, value)
        )

    if (currentValue is not None):
      if (notIsReading):
        oldSelves = currentValue.__dict__.get('compositeElements')
        oldSelves.remove(self)
      else:
        raise ApiError("""%s.setComponent:
         Read link 'component' incompatible with pre-existing link""" % self.qualifiedName
         + ": %s" % (self,)
        )

    if (value is not None):
      newSelves = value.__dict__.get('compositeElements')
      newSelves.add(self)

    dataDict['component'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setComponent')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setDetails(self, value):
    """
    Set for ccp.lims.RefSampleComponent.CompositeElement.details
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setDetails:
         memops.Implementation.String input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('details')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setDetails:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setDetails:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['details'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setDetails')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setInteractions(self, values):
    """
    Set for ccp.lims.RefSampleComponent.CompositeElement.interactions
    """
    dataDict = self.__dict__
    xx = values
    values = set(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setInteractions:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      if (not isinstance(value, CompositeInteraction)):
        raise ApiError("""%s.setInteractions:
         value is not of class ccp.lims.RefSampleComponent.CompositeInteraction""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('interactions')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setInteractions:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setInteractions:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setInteractions:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      for cv in currentValues:
        if (not (cv in values)):
          oldSelves = cv.__dict__.get('elements')
          if (len(oldSelves) < (2 + 1)):
            raise ApiError("""%s.setInteractions:
             locard: oldSelves: cannot remove value""" % self.qualifiedName
             + ": %s" % (self,)
            )

      for cv in values:
        if (not (cv in currentValues)):
          oldSelves = cv.__dict__.get('elements')
          if (len(oldSelves) >= 2):
            raise ApiError("""%s.setInteractions:
             hicard: oldSelves: cannot add value""" % self.qualifiedName
             + ": %s" % (self,)
            )

      xx1 = dataDict.get('topObject')
      for value in values:
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setInteractions:
           Link interactions between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    for cv in currentValues:
      if (not (cv in values)):
        oldSelves = cv.__dict__.get('elements')
        oldSelves.remove(self)

    for cv in values:
      if (not (cv in currentValues)):
        oldSelves = cv.__dict__.get('elements')
        oldSelves.add(self)

    dataDict['interactions'] = values
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setInteractions')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setSerial(self, value):
    """
    Set for ccp.lims.RefSampleComponent.CompositeElement.serial
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Int.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Int.create(value)
    else:
      raise ApiError("""%s.setSerial:
       memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('serial')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setSerial:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setSerial:
         cannot set serial, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setSerial:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    parent = dataDict.get('composite')
    oldSerial = parent.__dict__.get('_serialDict').get('elements')
    if (value < 0):
      value = (oldSerial + 1)
      parent.__dict__.get('_serialDict')['elements'] = value
    elif (value > oldSerial):
      parent.__dict__.get('_serialDict')['elements'] = value

    dataDict['serial'] = value

    # doNotifies
  
  def setStoichiometry(self, value):
    """
    Set for ccp.lims.RefSampleComponent.CompositeElement.stoichiometry
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.setStoichiometry:
         memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('stoichiometry')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setStoichiometry:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setStoichiometry:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['stoichiometry'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setStoichiometry')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def sortedInteractions(self):
    """
    Sorted for ccp.lims.RefSampleComponent.CompositeElement.interactions
    """
    dataDict = self.__dict__
    ll = dataDict.get('interactions')
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  applicationData = memops.api.Implementation.DataObject.applicationData

  className = memops.api.Implementation.ComplexDataType.className
  
  details = property(getDetails, setDetails, None,
  r"""Detail field for comments.
  """)

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted

  metaclass = memops.api.Implementation.ComplexDataType.metaclass

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName
  
  serial = property(getSerial, setSerial, None,
  r"""Unique identifier.
  """)
  
  stoichiometry = property(getStoichiometry, setStoichiometry, None,
  r"""The stoichiometry is the number of this element involved in the 
  composit.
  """)

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess
  
  component = property(getComponent, setComponent, None,
  r"""Component involved as an element in a composite.
  """)
  
  composite = property(getComposite,  None, None,
  r"""parent link
  """)
  
  interactions = property(getInteractions, setInteractions, None,
  r"""Interactions where a composite element is involved.
  """)
  
  parent = property(getParent, None, None,
  r"""link to parent object - synonym for composite
  """)

  root = memops.api.Implementation.MemopsObject.root

  topObject = memops.api.Implementation.DataObject.topObject

###############################################################################
class CompositeInteraction(memops.api.Implementation.DataObject):
  r"""The interaction between two composite elements.
  """
  #   from data model element ccp.lims.RefSampleComponent.CompositeInteraction revision ?
  _metaclass = metaPackage.getElement('CompositeInteraction')
  _packageName = 'ccp.lims.RefSampleComponent'
  _packageShortName = 'REFS'
  _fieldNames = ('affinity', 'applicationData', 'assessmentMethod', 'className', 'details', 'fieldNames', 'inConstructor', 'interactionType', 'isDeleted', 'metaclass', 'packageName', 'packageShortName', 'qualifiedName', 'serial', 'access', 'activeAccess', 'composite', 'elements', 'parent', 'root', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for ccp.lims.RefSampleComponent.CompositeInteraction
    """
    dataDict = self.__dict__
    dataDict['composite'] = parent
    if (not isinstance(parent, Composite)):
      raise ApiError("""%s.__init__:
       value is not of class ccp.lims.RefSampleComponent.Composite""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = parent.__dict__.get('topObject')
    dataDict['topObject'] = topObject

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    if (notIsReading):
      if (not (topObject.__dict__.get('isModifiable'))):
        raise ApiError("""%s.__init__:
         Storage not modifiable""" % self.qualifiedName
         + ": %s" % (topObject,)
        )

    try:

      dataDict['affinity'] = None
      dataDict['applicationData'] = list()
      dataDict['assessmentMethod'] = None
      dataDict['details'] = None
      dataDict['interactionType'] = None
      dataDict['serial'] = None
      dataDict['access'] = None
      dataDict['elements'] = set()

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in ccp.lims.RefSampleComponent.CompositeInteraction.__init__"
        del dataDict['inConstructor']
        raise

      if (notOverride):
        if (dataDict.get('serial') is None):
          dataDict['inConstructor'] = True
          self.setSerial(-1)
          del dataDict['inConstructor']
        else:
          raise ApiError("""%s.__init__:
           Cannot pass in explicit serial if not reading""" % self.qualifiedName
           + ": %s:%s" % (parent, 'ccp.lims.RefSampleComponent.CompositeInteraction')
          )

      if (notIsReading):
        childrenDict = parent.__dict__.get('interactions')
        objKey = dataDict.get('serial')
        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['serial'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notOverride):
        self.checkValid()

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for ccp.lims.RefSampleComponent.CompositeInteraction:
       
    determines cascading deletes to follow from delete of object.
       
    *Implementation function* - should be called only by API delete 
    function.
    """
    dataDict = self.__dict__
    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for ccp.lims.RefSampleComponent.CompositeInteraction:
    deletes objects
    *Implementation function* - will CORRUPT DATA if called 
    outside the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    for element in dataDict.get('elements'):
      if (not (element in objsToBeDeleted)):
        interactions = element.__dict__.get('interactions')
        interactions.remove(self)

    composite = dataDict.get('composite')
    if (not (composite in objsToBeDeleted)):
      objKey = dataDict.get('serial')
      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = composite.__dict__.get('interactions')
        if (self is dd.get(objKey)):
          del dd[objKey]

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData
  
  def checkAllValid(self, complete=False):
    """
    CheckAllValid for ccp.lims.RefSampleComponent.CompositeInteraction
    """
    dataDict = self.__dict__
    self.checkValid(complete)
  
  def checkValid(self, complete=False):
    """
    CheckValid for ccp.lims.RefSampleComponent.CompositeInteraction
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      objKey = dataDict.get('serial')
      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('composite')
        dd = value.__dict__.get('interactions')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'composite' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      # check attributes
      value = dataDict.get('affinity')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.Float.PythonType)):
          pass
        elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
          value = memops.api.Implementation.Float.create(value)
        else:
          raise ApiError("""%s.checkValid: affinity:
           memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (value - value == 0.0)):
          raise ApiError("""%s.checkValid: affinity:
           Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('assessmentMethod')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: assessmentMethod:
           memops.Implementation.Text input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 254):
          raise ApiError("""%s.checkValid: assessmentMethod:
           memops.Implementation.Text maximum length is 254 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: assessmentMethod:
           memops.Implementation.Text: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('details')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: details:
           memops.Implementation.String input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('interactionType')
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: interactionType:
         memops.Implementation.Text input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 254):
        raise ApiError("""%s.checkValid: interactionType:
         memops.Implementation.Text maximum length is 254 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: interactionType:
         memops.Implementation.Text: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('serial')
      if (value is None):
        raise ApiError("""%s.checkValid: serial:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.checkValid: serial:
         memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('composite')
      if (not isinstance(value, Composite)):
        raise ApiError("""%s.checkValid: composite:
         value is not of class ccp.lims.RefSampleComponent.Composite""" % self.qualifiedName
         + ": %s" % (value,)
        )

      values = dataDict.get('elements')
      for value in values:
        if (not isinstance(value, CompositeElement)):
          raise ApiError("""%s.checkValid: elements:
           value is not of class ccp.lims.RefSampleComponent.CompositeElement""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('interactions')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: elements:
           non-reciprocal link elements from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

    # check explicit class constraints
    # check attributes
    value = dataDict.get('affinity')
    values = dataDict.get('applicationData')
    for value in values:
      value.checkAllValid(complete)

    value = dataDict.get('assessmentMethod')
    value = dataDict.get('details')
    value = dataDict.get('interactionType')
    if (value is None):
      raise ApiError("""%s.checkValid: interactionType:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    # check roles
    value = dataDict.get('access')
    value = dataDict.get('composite')
    if (value is None):
      raise ApiError("""%s.checkValid: composite:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    values = dataDict.get('elements')
    if (not (len(values) == 2)):
      raise ApiError("""%s.checkValid: elements:
       locard, hicard: values must be of length == 2""" % self.qualifiedName
       + ": %s" % (self,)
      )

  delete = memops.api.Implementation.DataObject.delete

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData
  
  def findAllElements(self, **conditions):
    """
    FindAll for ccp.lims.RefSampleComponent.CompositeInteraction.elements
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('elements')
      result = set(currentValues)

    else:
      currentValues = dataDict.get('elements')
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('details', 'serial', 'stoichiometry', 'access', 'component', 'composite',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData
  
  def findFirstElement(self, **conditions):
    """
    FindFirst for ccp.lims.RefSampleComponent.CompositeInteraction.elements
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('elements')
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      currentValues = dataDict.get('elements')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('details', 'serial', 'stoichiometry', 'access', 'component', 'composite',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def get(self, name):
    """
    GetAttr for ccp.lims.RefSampleComponent.CompositeInteraction
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess
  
  def getAffinity(self):
    """
    Get for ccp.lims.RefSampleComponent.CompositeInteraction.affinity
    """
    dataDict = self.__dict__
    result = dataDict.get('affinity')
    return result

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getAssessmentMethod(self):
    """
    Get for
    ccp.lims.RefSampleComponent.CompositeInteraction.assessmentMethod
    """
    dataDict = self.__dict__
    result = dataDict.get('assessmentMethod')
    return result
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccp.lims.RefSampleComponent.CompositeInteraction
    """

    result = None
    if (startObj.__class__.__name__ == 'MemopsRoot'):
      if (3 != len(fullKey)):
        raise ApiError("""'ccp.lims.RefSampleComponent.CompositeInteraction'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj0 = startObj
      objKey = fullKey[0]
      obj1 = obj0.__dict__.get('refSampleComponentStores').get(objKey)
      if (obj1 is None):
        obj0.refreshTopObjects('ccp.lims.RefSampleComponent')
        obj1 = obj0.__dict__.get('refSampleComponentStores').get(objKey)

    else:
      if (2 != len(fullKey)):
        raise ApiError("""'ccp.lims.RefSampleComponent.CompositeInteraction'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj1 = startObj

    if (obj1 is not None):
      if (not (obj1.__dict__.get('isLoaded'))):
        obj1.load()

      objKey = fullKey[-2]
      obj2 = obj1.__dict__.get('components').get(objKey)

      if (obj2 is not None):
        objKey = fullKey[-1]
        obj3 = obj2.__dict__.get('interactions').get(objKey)
        result = obj3

    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation

  getClassName = memops.api.Implementation.ComplexDataType.getClassName
  
  def getComposite(self):
    """
    Get for ccp.lims.RefSampleComponent.CompositeInteraction.composite
    """
    dataDict = self.__dict__
    result = dataDict.get('composite')
    return result
  
  def getDetails(self):
    """
    Get for ccp.lims.RefSampleComponent.CompositeInteraction.details
    """
    dataDict = self.__dict__
    result = dataDict.get('details')
    return result
  
  def getElements(self):
    """
    Get for ccp.lims.RefSampleComponent.CompositeInteraction.elements
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('elements')
    result = frozenset(tempVar)
    return result

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames
  
  def getFullKey(self, useGuid=False):
    """
    GetFullKey for ccp.lims.RefSampleComponent.CompositeInteraction
    """
    dataDict = self.__dict__
    result = list()

    obj2 = dataDict.get('composite')
    obj1 = obj2.__dict__.get('refSampleComponentStore')

    if (useGuid):
      result.append(obj1.__dict__.get('guid'))
    else:
      result.append(obj1.__dict__.get('name'))

    result.append(obj2.__dict__.get('name'))
    result.append(dataDict.get('serial'))

    return result

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor
  
  def getInteractionType(self):
    """
    Get for ccp.lims.RefSampleComponent.CompositeInteraction.interactionType
    """
    dataDict = self.__dict__
    result = dataDict.get('interactionType')
    return result

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted
  
  def getLocalKey(self):
    """
    GetLocalKey for ccp.lims.RefSampleComponent.CompositeInteraction
    """
    dataDict = self.__dict__
    result = dataDict.get('serial')
    return result

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName
  
  def getParent(self):
    """
    Get for ccp.lims.RefSampleComponent.CompositeInteraction.parent
    """
    dataDict = self.__dict__
    result = dataDict.get('composite')
    return result

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName

  getRoot = memops.api.Implementation.MemopsObject.getRoot
  
  def getSerial(self):
    """
    Get for ccp.lims.RefSampleComponent.CompositeInteraction.serial
    """
    dataDict = self.__dict__
    result = dataDict.get('serial')
    return result

  getTopObject = memops.api.Implementation.DataObject.getTopObject

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData
  
  def set(self, name, value):
    """
    SetAttr for ccp.lims.RefSampleComponent.CompositeInteraction
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess
  
  def setAffinity(self, value):
    """
    Set for ccp.lims.RefSampleComponent.CompositeInteraction.affinity
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.Float.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Float.create(value)
      else:
        raise ApiError("""%s.setAffinity:
         memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value - value == 0.0)):
        raise ApiError("""%s.setAffinity:
         Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('affinity')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setAffinity:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setAffinity:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['affinity'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setAffinity')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData
  
  def setAssessmentMethod(self, value):
    """
    Set for
    ccp.lims.RefSampleComponent.CompositeInteraction.assessmentMethod
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setAssessmentMethod:
         memops.Implementation.Text input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 254):
        raise ApiError("""%s.setAssessmentMethod:
         memops.Implementation.Text maximum length is 254 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setAssessmentMethod:
         memops.Implementation.Text: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('assessmentMethod')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setAssessmentMethod:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setAssessmentMethod:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['assessmentMethod'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setAssessmentMethod')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setDetails(self, value):
    """
    Set for ccp.lims.RefSampleComponent.CompositeInteraction.details
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setDetails:
         memops.Implementation.String input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('details')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setDetails:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setDetails:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['details'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setDetails')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setElements(self, values):
    """
    Set for ccp.lims.RefSampleComponent.CompositeInteraction.elements
    """
    dataDict = self.__dict__
    xx = values
    values = set(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setElements:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      if (not isinstance(value, CompositeElement)):
        raise ApiError("""%s.setElements:
         value is not of class ccp.lims.RefSampleComponent.CompositeElement""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('elements')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setElements:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setElements:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setElements:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      if (not (len(values) == 2)):
        raise ApiError("""%s.setElements:
         locard, hicard: values must be of length == 2""" % self.qualifiedName
         + ": %s" % (self,)
        )

      xx1 = dataDict.get('topObject')
      for value in values:
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setElements:
           Link elements between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    for cv in currentValues:
      if (not (cv in values)):
        oldSelves = cv.__dict__.get('interactions')
        oldSelves.remove(self)

    for cv in values:
      if (not (cv in currentValues)):
        oldSelves = cv.__dict__.get('interactions')
        oldSelves.add(self)

    dataDict['elements'] = values
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setElements')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setInteractionType(self, value):
    """
    Set for ccp.lims.RefSampleComponent.CompositeInteraction.interactionType
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.setInteractionType:
       memops.Implementation.Text input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 254):
      raise ApiError("""%s.setInteractionType:
       memops.Implementation.Text maximum length is 254 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.setInteractionType:
       memops.Implementation.Text: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('interactionType')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setInteractionType:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setInteractionType:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setInteractionType:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['interactionType'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setInteractionType')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setSerial(self, value):
    """
    Set for ccp.lims.RefSampleComponent.CompositeInteraction.serial
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Int.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Int.create(value)
    else:
      raise ApiError("""%s.setSerial:
       memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('serial')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setSerial:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setSerial:
         cannot set serial, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setSerial:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    parent = dataDict.get('composite')
    oldSerial = parent.__dict__.get('_serialDict').get('interactions')
    if (value < 0):
      value = (oldSerial + 1)
      parent.__dict__.get('_serialDict')['interactions'] = value
    elif (value > oldSerial):
      parent.__dict__.get('_serialDict')['interactions'] = value

    dataDict['serial'] = value

    # doNotifies
  
  def sortedElements(self):
    """
    Sorted for ccp.lims.RefSampleComponent.CompositeInteraction.elements
    """
    dataDict = self.__dict__
    ll = dataDict.get('elements')
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString
  
  affinity = property(getAffinity, setAffinity, None,
  r"""The dissociation constant K of the complex, in units of M (moles/liter) 
  to the appropriate power, according to the formula 
  K=[A][B][C]/[ABC] 
  
  Here in units of M-squared (for a ternary complex).
  """)

  applicationData = memops.api.Implementation.DataObject.applicationData
  
  assessmentMethod = property(getAssessmentMethod, setAssessmentMethod, None,
  r"""The assessment method used to define this interaction.
  """)

  className = memops.api.Implementation.ComplexDataType.className
  
  details = property(getDetails, setDetails, None,
  r"""Detail field for comments.
  """)

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor
  
  interactionType = property(getInteractionType, setInteractionType, None,
  r"""The type of the interaction.
  """)

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted

  metaclass = memops.api.Implementation.ComplexDataType.metaclass

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName
  
  serial = property(getSerial, setSerial, None,
  r"""Unique identifier.
  """)

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess
  
  composite = property(getComposite,  None, None,
  r"""parent link
  """)
  
  elements = property(getElements, setElements, None,
  r"""The 2 composite elements involved in an interaction.
  """)
  
  parent = property(getParent, None, None,
  r"""link to parent object - synonym for composite
  """)

  root = memops.api.Implementation.MemopsObject.root

  topObject = memops.api.Implementation.DataObject.topObject

###############################################################################
class IsotopeLabel(memops.api.Implementation.DataObject):
  r"""Isotope label or labeling pattern. Refers to elements of a type given by 
elementSymbol. If self.molResidues is set the substitution is limited to 
these residues. If self.atomNames is set the substitution is limited to 
atoms with these names.
  """
  #   from data model element ccp.lims.RefSampleComponent.IsotopeLabel revision ?
  _metaclass = metaPackage.getElement('IsotopeLabel')
  _packageName = 'ccp.lims.RefSampleComponent'
  _packageShortName = 'REFS'
  _fieldNames = ('applicationData', 'atomNames', 'className', 'elementSymbol', 'fieldNames', 'inConstructor', 'incorporation', 'isDeleted', 'massNumber', 'metaclass', 'packageName', 'packageShortName', 'qualifiedName', 'serial', 'access', 'activeAccess', 'molResidues', 'parent', 'root', 'specificLabelGroup', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for ccp.lims.RefSampleComponent.IsotopeLabel
    """
    dataDict = self.__dict__
    dataDict['specificLabelGroup'] = parent
    if (not isinstance(parent, SpecificLabelGroup)):
      raise ApiError("""%s.__init__:
       value is not of class ccp.lims.RefSampleComponent.SpecificLabelGroup""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = parent.__dict__.get('topObject')
    dataDict['topObject'] = topObject

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    if (notIsReading):
      if (not (topObject.__dict__.get('isModifiable'))):
        raise ApiError("""%s.__init__:
         Storage not modifiable""" % self.qualifiedName
         + ": %s" % (topObject,)
        )

    try:

      dataDict['applicationData'] = list()
      dataDict['atomNames'] = list()
      dataDict['elementSymbol'] = None
      dataDict['incorporation'] = None
      dataDict['massNumber'] = None
      dataDict['serial'] = None
      dataDict['access'] = None
      dataDict['molResidues'] = set()

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in ccp.lims.RefSampleComponent.IsotopeLabel.__init__"
        del dataDict['inConstructor']
        raise

      if (notOverride):
        if (dataDict.get('serial') is None):
          dataDict['inConstructor'] = True
          self.setSerial(-1)
          del dataDict['inConstructor']
        else:
          raise ApiError("""%s.__init__:
           Cannot pass in explicit serial if not reading""" % self.qualifiedName
           + ": %s:%s" % (parent, 'ccp.lims.RefSampleComponent.IsotopeLabel')
          )

      if (notIsReading):
        childrenDict = parent.__dict__.get('isotopeLabels')
        objKey = dataDict.get('serial')
        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['serial'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notOverride):
        self.checkValid()

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for ccp.lims.RefSampleComponent.IsotopeLabel:
       determines 
    cascading deletes to follow from delete of object.
       *Implementation 
    function* - should be called only by API delete function.
    """
    dataDict = self.__dict__
    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    molResidues = dataDict.get('molResidues')
    pass
    for molResidue in molResidues:
      topObject = molResidue.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for ccp.lims.RefSampleComponent.IsotopeLabel:   deletes
    objects
    *Implementation function* - will CORRUPT DATA if called outside 
    the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    for molResidue in dataDict.get('molResidues'):
      if (not (molResidue in objsToBeDeleted)):
        isotopeLabels = molResidue.__dict__.get('isotopeLabels')
        isotopeLabels.remove(self)

    specificLabelGroup = dataDict.get('specificLabelGroup')
    if (not (specificLabelGroup in objsToBeDeleted)):
      objKey = dataDict.get('serial')
      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = specificLabelGroup.__dict__.get('isotopeLabels')
        if (self is dd.get(objKey)):
          del dd[objKey]

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData
  
  def addAtomName(self, value):
    """
    Add for ccp.lims.RefSampleComponent.IsotopeLabel.atomNames
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.addAtomName:
       memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 32):
      raise ApiError("""%s.addAtomName:
       memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.addAtomName:
       memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.split()) == 1)):
      raise ApiError("""%s.addAtomName:
       Word constraint contains_no_white_space violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('atomNames')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.addAtomName:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.addAtomName:
       called on deleted object""" % self.qualifiedName
      )

    if (notOverride):
      pass

    currentValues.append(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('addAtomName')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def addMolResidue(self, value):
    """
    Add for ccp.lims.RefSampleComponent.IsotopeLabel.molResidues
    """
    dataDict = self.__dict__
    from ccp.api.molecule.Molecule import MolResidue as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.addMolResidue:
       value is not of class ccp.molecule.Molecule.MolResidue""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('molResidues')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      topObject = value.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)
      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.addMolResidue:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.addMolResidue:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.addMolResidue:
       called with deleted value""" % self.qualifiedName
      )

    if (value in currentValues):
      raise ApiError("""%s.addMolResidue:
       value is in list already""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.addMolResidue:
           Link molResidues between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      if (notInConstructor):
        if (value is not None):
          if (not (value is None or self.specificLabelGroup.molComponent.molecule is value.molecule)):
            raise ApiError("""%s.addMolResidue:
             molResidues constraint self_specificLabelGroup_molComponent_molecule_is_value_molecule violated by value""" % self.qualifiedName
             + ": %s" % (value,)
            )

    oldSelves = value.__dict__.get('isotopeLabels')
    oldSelves.add(self)
    currentValues.add(value)
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('addMolResidue')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def checkAllValid(self, complete=False):
    """
    CheckAllValid for ccp.lims.RefSampleComponent.IsotopeLabel
    """
    dataDict = self.__dict__
    self.checkValid(complete)
  
  def checkValid(self, complete=False):
    """
    CheckValid for ccp.lims.RefSampleComponent.IsotopeLabel
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      objKey = dataDict.get('serial')
      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('specificLabelGroup')
        dd = value.__dict__.get('isotopeLabels')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'specificLabelGroup' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      # check attributes
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      values = dataDict.get('atomNames')
      for value in values:
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: atomNames:
           memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 32):
          raise ApiError("""%s.checkValid: atomNames:
           memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: atomNames:
           memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.split()) == 1)):
          raise ApiError("""%s.checkValid: atomNames:
           Word constraint contains_no_white_space violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('elementSymbol')
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: elementSymbol:
         memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 32):
        raise ApiError("""%s.checkValid: elementSymbol:
         memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: elementSymbol:
         memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.checkValid: elementSymbol:
         Word constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('incorporation')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.Float.PythonType)):
          pass
        elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
          value = memops.api.Implementation.Float.create(value)
        else:
          raise ApiError("""%s.checkValid: incorporation:
           memops.Implementation.FloatRatio input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (0.0 <= value)):
          raise ApiError("""%s.checkValid: incorporation:
           FloatRatio constraint value_ge_0 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (value - value == 0.0)):
          raise ApiError("""%s.checkValid: incorporation:
           FloatRatio constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (value <= 1.0)):
          raise ApiError("""%s.checkValid: incorporation:
           FloatRatio constraint value_le_1 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('massNumber')
      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.checkValid: massNumber:
         memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('serial')
      if (value is None):
        raise ApiError("""%s.checkValid: serial:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.checkValid: serial:
         memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      values = dataDict.get('molResidues')
      for value in values:
        from ccp.api.molecule.Molecule import MolResidue as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: molResidues:
           value is not of class ccp.molecule.Molecule.MolResidue""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('isotopeLabels')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: molResidues:
           non-reciprocal link molResidues from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      value = dataDict.get('specificLabelGroup')
      if (not isinstance(value, SpecificLabelGroup)):
        raise ApiError("""%s.checkValid: specificLabelGroup:
         value is not of class ccp.lims.RefSampleComponent.SpecificLabelGroup""" % self.qualifiedName
         + ": %s" % (value,)
        )

    # check explicit class constraints
    # check attributes
    values = dataDict.get('applicationData')
    for value in values:
      value.checkAllValid(complete)

    values = dataDict.get('atomNames')
    value = dataDict.get('elementSymbol')
    if (value is None):
      raise ApiError("""%s.checkValid: elementSymbol:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('incorporation')
    value = dataDict.get('massNumber')
    if (value is None):
      raise ApiError("""%s.checkValid: massNumber:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    # check roles
    value = dataDict.get('access')
    values = dataDict.get('molResidues')
    for value in values:
      if (not (value is None or self.specificLabelGroup.molComponent.molecule is value.molecule)):
        raise ApiError("""%s.checkValid: molResidues:
         molResidues constraint self_specificLabelGroup_molComponent_molecule_is_value_molecule violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    value = dataDict.get('specificLabelGroup')
    if (value is None):
      raise ApiError("""%s.checkValid: specificLabelGroup:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

  delete = memops.api.Implementation.DataObject.delete

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData
  
  def findAllMolResidues(self, **conditions):
    """
    FindAll for ccp.lims.RefSampleComponent.IsotopeLabel.molResidues
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('molResidues')
      result = set(currentValues)

    else:
      currentValues = dataDict.get('molResidues')
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('descriptor', 'linking', 'seqCode', 'seqInsertCode', 'serial', 'access', 'chemComp', 'molSeqFragment', 'molecule',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData
  
  def findFirstMolResidue(self, **conditions):
    """
    FindFirst for ccp.lims.RefSampleComponent.IsotopeLabel.molResidues
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('molResidues')
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      currentValues = dataDict.get('molResidues')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('descriptor', 'linking', 'seqCode', 'seqInsertCode', 'serial', 'access', 'chemComp', 'molSeqFragment', 'molecule',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def get(self, name):
    """
    GetAttr for ccp.lims.RefSampleComponent.IsotopeLabel
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getAtomNames(self):
    """
    Get for ccp.lims.RefSampleComponent.IsotopeLabel.atomNames
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('atomNames')
    result = tuple(tempVar)
    return result
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccp.lims.RefSampleComponent.IsotopeLabel
    """

    result = None
    if (startObj.__class__.__name__ == 'MemopsRoot'):
      if (4 != len(fullKey)):
        raise ApiError("""'ccp.lims.RefSampleComponent.IsotopeLabel'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj0 = startObj
      objKey = fullKey[0]
      obj1 = obj0.__dict__.get('refSampleComponentStores').get(objKey)
      if (obj1 is None):
        obj0.refreshTopObjects('ccp.lims.RefSampleComponent')
        obj1 = obj0.__dict__.get('refSampleComponentStores').get(objKey)

    else:
      if (3 != len(fullKey)):
        raise ApiError("""'ccp.lims.RefSampleComponent.IsotopeLabel'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj1 = startObj

    if (obj1 is not None):
      if (not (obj1.__dict__.get('isLoaded'))):
        obj1.load()

      objKey = fullKey[-3]
      obj2 = obj1.__dict__.get('components').get(objKey)

      if (obj2 is not None):
        objKey = fullKey[-2]
        obj3 = obj2.__dict__.get('specificLabelGroups').get(objKey)

        if (obj3 is not None):
          objKey = fullKey[-1]
          obj4 = obj3.__dict__.get('isotopeLabels').get(objKey)
          result = obj4

    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation

  getClassName = memops.api.Implementation.ComplexDataType.getClassName
  
  def getElementSymbol(self):
    """
    Get for ccp.lims.RefSampleComponent.IsotopeLabel.elementSymbol
    """
    dataDict = self.__dict__
    result = dataDict.get('elementSymbol')
    return result

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames
  
  def getFullKey(self, useGuid=False):
    """
    GetFullKey for ccp.lims.RefSampleComponent.IsotopeLabel
    """
    dataDict = self.__dict__
    result = list()

    obj3 = dataDict.get('specificLabelGroup')
    obj2 = obj3.__dict__.get('molComponent')
    obj1 = obj2.__dict__.get('refSampleComponentStore')

    if (useGuid):
      result.append(obj1.__dict__.get('guid'))
    else:
      result.append(obj1.__dict__.get('name'))

    result.append(obj2.__dict__.get('name'))
    result.append(obj3.__dict__.get('serial'))
    result.append(dataDict.get('serial'))

    return result

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor
  
  def getIncorporation(self):
    """
    Get for ccp.lims.RefSampleComponent.IsotopeLabel.incorporation
    """
    dataDict = self.__dict__
    result = dataDict.get('incorporation')
    return result

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted
  
  def getLocalKey(self):
    """
    GetLocalKey for ccp.lims.RefSampleComponent.IsotopeLabel
    """
    dataDict = self.__dict__
    result = dataDict.get('serial')
    return result
  
  def getMassNumber(self):
    """
    Get for ccp.lims.RefSampleComponent.IsotopeLabel.massNumber
    """
    dataDict = self.__dict__
    result = dataDict.get('massNumber')
    return result

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass
  
  def getMolResidues(self):
    """
    Get for ccp.lims.RefSampleComponent.IsotopeLabel.molResidues
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('molResidues')
    result = frozenset(tempVar)
    return result

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName
  
  def getParent(self):
    """
    Get for ccp.lims.RefSampleComponent.IsotopeLabel.parent
    """
    dataDict = self.__dict__
    result = dataDict.get('specificLabelGroup')
    return result

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName

  getRoot = memops.api.Implementation.MemopsObject.getRoot
  
  def getSerial(self):
    """
    Get for ccp.lims.RefSampleComponent.IsotopeLabel.serial
    """
    dataDict = self.__dict__
    result = dataDict.get('serial')
    return result
  
  def getSpecificLabelGroup(self):
    """
    Get for ccp.lims.RefSampleComponent.IsotopeLabel.specificLabelGroup
    """
    dataDict = self.__dict__
    result = dataDict.get('specificLabelGroup')
    return result

  getTopObject = memops.api.Implementation.DataObject.getTopObject

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData
  
  def removeAtomName(self, value):
    """
    Remove for ccp.lims.RefSampleComponent.IsotopeLabel.atomNames
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.removeAtomName:
       memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 32):
      raise ApiError("""%s.removeAtomName:
       memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.removeAtomName:
       memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.split()) == 1)):
      raise ApiError("""%s.removeAtomName:
       Word constraint contains_no_white_space violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('atomNames')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.removeAtomName:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.removeAtomName:
       called on deleted object""" % self.qualifiedName
      )

    if (not (value in currentValues)):
      raise ApiError("""%s.removeAtomName:
       value not in list""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      pass

    currentValues.remove(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('removeAtomName')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def removeMolResidue(self, value):
    """
    Remove for ccp.lims.RefSampleComponent.IsotopeLabel.molResidues
    """
    dataDict = self.__dict__
    from ccp.api.molecule.Molecule import MolResidue as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.removeMolResidue:
       value is not of class ccp.molecule.Molecule.MolResidue""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('molResidues')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      topObject = value.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)
      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.removeMolResidue:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.removeMolResidue:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.removeMolResidue:
       called with deleted value""" % self.qualifiedName
      )

    if (not (value in currentValues)):
      raise ApiError("""%s.removeMolResidue:
       value not in list""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      pass

    oldSelves = value.__dict__.get('isotopeLabels')
    oldSelves.remove(self)
    currentValues.remove(value)
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('removeMolResidue')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def set(self, name, value):
    """
    SetAttr for ccp.lims.RefSampleComponent.IsotopeLabel
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData
  
  def setAtomNames(self, values):
    """
    Set for ccp.lims.RefSampleComponent.IsotopeLabel.atomNames
    """
    dataDict = self.__dict__
    values = list(values)
    for value in values:
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setAtomNames:
         memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 32):
        raise ApiError("""%s.setAtomNames:
         memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setAtomNames:
         memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.setAtomNames:
         Word constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('atomNames')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setAtomNames:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setAtomNames:
       called on deleted object""" % self.qualifiedName
      )

    if (values == currentValues):
      return

    if (notOverride):
      pass

    dataDict['atomNames'] = values
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setAtomNames')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setElementSymbol(self, value):
    """
    Set for ccp.lims.RefSampleComponent.IsotopeLabel.elementSymbol
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.setElementSymbol:
       memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 32):
      raise ApiError("""%s.setElementSymbol:
       memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.setElementSymbol:
       memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.split()) == 1)):
      raise ApiError("""%s.setElementSymbol:
       Word constraint contains_no_white_space violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('elementSymbol')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setElementSymbol:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setElementSymbol:
         cannot set elementSymbol, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setElementSymbol:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['elementSymbol'] = value

    # doNotifies
  
  def setIncorporation(self, value):
    """
    Set for ccp.lims.RefSampleComponent.IsotopeLabel.incorporation
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.Float.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Float.create(value)
      else:
        raise ApiError("""%s.setIncorporation:
         memops.Implementation.FloatRatio input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (0.0 <= value)):
        raise ApiError("""%s.setIncorporation:
         FloatRatio constraint value_ge_0 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value - value == 0.0)):
        raise ApiError("""%s.setIncorporation:
         FloatRatio constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value <= 1.0)):
        raise ApiError("""%s.setIncorporation:
         FloatRatio constraint value_le_1 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('incorporation')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setIncorporation:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setIncorporation:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['incorporation'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setIncorporation')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setMassNumber(self, value):
    """
    Set for ccp.lims.RefSampleComponent.IsotopeLabel.massNumber
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Int.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Int.create(value)
    else:
      raise ApiError("""%s.setMassNumber:
       memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('massNumber')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setMassNumber:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setMassNumber:
         cannot set massNumber, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setMassNumber:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['massNumber'] = value

    # doNotifies
  
  def setMolResidues(self, values):
    """
    Set for ccp.lims.RefSampleComponent.IsotopeLabel.molResidues
    """
    dataDict = self.__dict__
    xx = values
    values = set(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setMolResidues:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      from ccp.api.molecule.Molecule import MolResidue as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setMolResidues:
         value is not of class ccp.molecule.Molecule.MolResidue""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('molResidues')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      for pv in currentValues:
        if (not (pv in values)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)

      for pv in values:
        if (not (pv in currentValues)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)

      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setMolResidues:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setMolResidues:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setMolResidues:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
      for value in values:
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setMolResidues:
           Link molResidues between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      if (notInConstructor):
        for value in values:
          if (not (value is None or self.specificLabelGroup.molComponent.molecule is value.molecule)):
            raise ApiError("""%s.setMolResidues:
             molResidues constraint self_specificLabelGroup_molComponent_molecule_is_value_molecule violated by value""" % self.qualifiedName
             + ": %s" % (value,)
            )

    for cv in currentValues:
      if (not (cv in values)):
        oldSelves = cv.__dict__.get('isotopeLabels')
        oldSelves.remove(self)

    for cv in values:
      if (not (cv in currentValues)):
        oldSelves = cv.__dict__.get('isotopeLabels')
        oldSelves.add(self)

    dataDict['molResidues'] = values
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setMolResidues')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setSerial(self, value):
    """
    Set for ccp.lims.RefSampleComponent.IsotopeLabel.serial
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Int.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Int.create(value)
    else:
      raise ApiError("""%s.setSerial:
       memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('serial')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setSerial:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setSerial:
         cannot set serial, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setSerial:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    parent = dataDict.get('specificLabelGroup')
    oldSerial = parent.__dict__.get('_serialDict').get('isotopeLabels')
    if (value < 0):
      value = (oldSerial + 1)
      parent.__dict__.get('_serialDict')['isotopeLabels'] = value
    elif (value > oldSerial):
      parent.__dict__.get('_serialDict')['isotopeLabels'] = value

    dataDict['serial'] = value

    # doNotifies
  
  def sortedMolResidues(self):
    """
    Sorted for ccp.lims.RefSampleComponent.IsotopeLabel.molResidues
    """
    dataDict = self.__dict__
    ll = dataDict.get('molResidues')
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  applicationData = memops.api.Implementation.DataObject.applicationData
  
  atomNames = property(getAtomNames, setAtomNames, None,
  r"""Names of atoms that have been isotope substituted. Applies to the 
  residues given by self.molResidues, or, if self.molResidues is empty, to 
  the entire molecule.
  """)

  className = memops.api.Implementation.ComplexDataType.className
  
  elementSymbol = property(getElementSymbol, setElementSymbol, None,
  r"""Element symbol for chemical element that is isotope substituted. 
  """)

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor
  
  incorporation = property(getIncorporation, setIncorporation, None,
  r"""Fraction of element that is consists of isotope. Unless given 
  specifically in another IsotopeLabel, the rest of the element is assumed 
  to consist of the isotopes in their natural abundance.
  """)

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted
  
  massNumber = property(getMassNumber, setMassNumber, None,
  r"""Mass number of incorporated isotope .
  """)

  metaclass = memops.api.Implementation.ComplexDataType.metaclass

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName
  
  serial = property(getSerial, setSerial, None,
  r"""Serial number of object. Serves as object main key. Serial numbers of 
  deleted objects are not re-used. Serial numbers can only be set by the 
  implementation. Values are in practice always positive, since negative 
  values are interpreted as a signal to set the next free serial
  """)

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess
  
  molResidues = property(getMolResidues, setMolResidues, None,
  r"""MolResidues to which isotope labeling applies. If not set, the isotope 
  labeling applies to all residues in Molecule.
  """)
  
  parent = property(getParent, None, None,
  r"""link to parent object - synonym for specificLabelGroup
  """)

  root = memops.api.Implementation.MemopsObject.root
  
  specificLabelGroup = property(getSpecificLabelGroup,  None, None,
  r"""parent link
  """)

  topObject = memops.api.Implementation.DataObject.topObject

###############################################################################
class Label(memops.api.Implementation.DataObject):
  r"""Label (isotopic, fluorophore, X-ray anomalous scatterer, or other) 
attached to AbstractComponent. Isotope labeling given in 
SpecificLabelGroup and IsotopeLabel must be consistent with labeling 
given in the Label class, as both are valid together.
  """
  #   from data model element ccp.lims.RefSampleComponent.Label revision ?
  _metaclass = metaPackage.getElement('Label')
  _packageName = 'ccp.lims.RefSampleComponent'
  _packageShortName = 'REFS'
  _fieldNames = ('applicationData', 'className', 'elementName', 'fieldNames', 'inConstructor', 'incorporation', 'isDeleted', 'isUniform', 'labelName', 'labelType', 'massNumber', 'metaclass', 'numInstances', 'packageName', 'packageShortName', 'qualifiedName', 'serial', 'access', 'activeAccess', 'component', 'parent', 'root', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for ccp.lims.RefSampleComponent.Label
    """
    dataDict = self.__dict__
    dataDict['component'] = parent
    if (not isinstance(parent, AbstractComponent)):
      raise ApiError("""%s.__init__:
       value is not of class ccp.lims.RefSampleComponent.AbstractComponent""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = parent.__dict__.get('topObject')
    dataDict['topObject'] = topObject

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    if (notIsReading):
      if (not (topObject.__dict__.get('isModifiable'))):
        raise ApiError("""%s.__init__:
         Storage not modifiable""" % self.qualifiedName
         + ": %s" % (topObject,)
        )

    try:

      dataDict['applicationData'] = list()
      dataDict['elementName'] = None
      dataDict['incorporation'] = None
      dataDict['isUniform'] = None
      dataDict['labelName'] = None
      dataDict['labelType'] = None
      dataDict['massNumber'] = None
      dataDict['numInstances'] = None
      dataDict['serial'] = None
      dataDict['access'] = None

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in ccp.lims.RefSampleComponent.Label.__init__"
        del dataDict['inConstructor']
        raise

      if (notOverride):
        if (dataDict.get('serial') is None):
          dataDict['inConstructor'] = True
          self.setSerial(-1)
          del dataDict['inConstructor']
        else:
          raise ApiError("""%s.__init__:
           Cannot pass in explicit serial if not reading""" % self.qualifiedName
           + ": %s:%s" % (parent, 'ccp.lims.RefSampleComponent.Label')
          )

      if (notIsReading):
        childrenDict = parent.__dict__.get('labels')
        objKey = dataDict.get('serial')
        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['serial'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notOverride):
        self.checkValid()

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for ccp.lims.RefSampleComponent.Label:
       determines 
    cascading deletes to follow from delete of object.
       *Implementation 
    function* - should be called only by API delete function.
    """
    dataDict = self.__dict__
    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for ccp.lims.RefSampleComponent.Label:   deletes
    objects
    *Implementation function* - will CORRUPT DATA if called outside 
    the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    component = dataDict.get('component')
    if (not (component in objsToBeDeleted)):
      objKey = dataDict.get('serial')
      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = component.__dict__.get('labels')
        if (self is dd.get(objKey)):
          del dd[objKey]

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData
  
  def checkAllValid(self, complete=False):
    """
    CheckAllValid for ccp.lims.RefSampleComponent.Label
    """
    dataDict = self.__dict__
    self.checkValid(complete)
  
  def checkValid(self, complete=False):
    """
    CheckValid for ccp.lims.RefSampleComponent.Label
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      objKey = dataDict.get('serial')
      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('component')
        dd = value.__dict__.get('labels')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'component' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      # check attributes
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('elementName')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: elementName:
           memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 32):
          raise ApiError("""%s.checkValid: elementName:
           memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: elementName:
           memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.split()) == 1)):
          raise ApiError("""%s.checkValid: elementName:
           Word constraint contains_no_white_space violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('incorporation')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.Float.PythonType)):
          pass
        elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
          value = memops.api.Implementation.Float.create(value)
        else:
          raise ApiError("""%s.checkValid: incorporation:
           memops.Implementation.FloatRatio input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (0.0 <= value)):
          raise ApiError("""%s.checkValid: incorporation:
           FloatRatio constraint value_ge_0 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (value - value == 0.0)):
          raise ApiError("""%s.checkValid: incorporation:
           FloatRatio constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (value <= 1.0)):
          raise ApiError("""%s.checkValid: incorporation:
           FloatRatio constraint value_le_1 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('isUniform')
      if (value is not None):
        if (not (value in [True, False])):
          raise ApiError("""%s.checkValid: isUniform:
           memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('labelName')
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: labelName:
         ccp.lims.RefSampleComponent.LabelName input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: labelName:
         ccp.lims.RefSampleComponent.LabelName maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: labelName:
         ccp.lims.RefSampleComponent.LabelName: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: labelName:
         LabelName constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('labelType')
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: labelType:
         ccp.lims.RefSampleComponent.LabelType input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: labelType:
         ccp.lims.RefSampleComponent.LabelType maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: labelType:
         ccp.lims.RefSampleComponent.LabelType: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: labelType:
         LabelType constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('massNumber')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.Int.PythonType)):
          pass
        elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
          value = memops.api.Implementation.Int.create(value)
        else:
          raise ApiError("""%s.checkValid: massNumber:
           memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('numInstances')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.Int.PythonType)):
          pass
        elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
          value = memops.api.Implementation.Int.create(value)
        else:
          raise ApiError("""%s.checkValid: numInstances:
           memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('serial')
      if (value is None):
        raise ApiError("""%s.checkValid: serial:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.checkValid: serial:
         memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('component')
      if (not isinstance(value, AbstractComponent)):
        raise ApiError("""%s.checkValid: component:
         value is not of class ccp.lims.RefSampleComponent.AbstractComponent""" % self.qualifiedName
         + ": %s" % (value,)
        )

    # check explicit class constraints
    # check attributes
    values = dataDict.get('applicationData')
    for value in values:
      value.checkAllValid(complete)

    value = dataDict.get('elementName')
    value = dataDict.get('incorporation')
    value = dataDict.get('isUniform')
    value = dataDict.get('labelName')
    if (value is None):
      raise ApiError("""%s.checkValid: labelName:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('labelType')
    if (value is None):
      raise ApiError("""%s.checkValid: labelType:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('massNumber')
    value = dataDict.get('numInstances')
    # check roles
    value = dataDict.get('access')
    value = dataDict.get('component')
    if (value is None):
      raise ApiError("""%s.checkValid: component:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

  delete = memops.api.Implementation.DataObject.delete

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData
  
  def get(self, name):
    """
    GetAttr for ccp.lims.RefSampleComponent.Label
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccp.lims.RefSampleComponent.Label
    """

    result = None
    if (startObj.__class__.__name__ == 'MemopsRoot'):
      if (3 != len(fullKey)):
        raise ApiError("""'ccp.lims.RefSampleComponent.Label'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj0 = startObj
      objKey = fullKey[0]
      obj1 = obj0.__dict__.get('refSampleComponentStores').get(objKey)
      if (obj1 is None):
        obj0.refreshTopObjects('ccp.lims.RefSampleComponent')
        obj1 = obj0.__dict__.get('refSampleComponentStores').get(objKey)

    else:
      if (2 != len(fullKey)):
        raise ApiError("""'ccp.lims.RefSampleComponent.Label'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj1 = startObj

    if (obj1 is not None):
      if (not (obj1.__dict__.get('isLoaded'))):
        obj1.load()

      objKey = fullKey[-2]
      obj2 = obj1.__dict__.get('components').get(objKey)

      if (obj2 is not None):
        objKey = fullKey[-1]
        obj3 = obj2.__dict__.get('labels').get(objKey)
        result = obj3

    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation

  getClassName = memops.api.Implementation.ComplexDataType.getClassName
  
  def getComponent(self):
    """
    Get for ccp.lims.RefSampleComponent.Label.component
    """
    dataDict = self.__dict__
    result = dataDict.get('component')
    return result
  
  def getElementName(self):
    """
    Get for ccp.lims.RefSampleComponent.Label.elementName
    """
    dataDict = self.__dict__
    result = dataDict.get('elementName')
    return result

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames
  
  def getFullKey(self, useGuid=False):
    """
    GetFullKey for ccp.lims.RefSampleComponent.Label
    """
    dataDict = self.__dict__
    result = list()

    obj2 = dataDict.get('component')
    obj1 = obj2.__dict__.get('refSampleComponentStore')

    if (useGuid):
      result.append(obj1.__dict__.get('guid'))
    else:
      result.append(obj1.__dict__.get('name'))

    result.append(obj2.__dict__.get('name'))
    result.append(dataDict.get('serial'))

    return result

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor
  
  def getIncorporation(self):
    """
    Get for ccp.lims.RefSampleComponent.Label.incorporation
    """
    dataDict = self.__dict__
    result = dataDict.get('incorporation')
    return result

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted
  
  def getIsUniform(self):
    """
    Get for ccp.lims.RefSampleComponent.Label.isUniform
    """
    dataDict = self.__dict__
    result = dataDict.get('isUniform')
    return result
  
  def getLabelName(self):
    """
    Get for ccp.lims.RefSampleComponent.Label.labelName
    """
    dataDict = self.__dict__
    result = dataDict.get('labelName')
    return result
  
  def getLabelType(self):
    """
    Get for ccp.lims.RefSampleComponent.Label.labelType
    """
    dataDict = self.__dict__
    result = dataDict.get('labelType')
    return result
  
  def getLocalKey(self):
    """
    GetLocalKey for ccp.lims.RefSampleComponent.Label
    """
    dataDict = self.__dict__
    result = dataDict.get('serial')
    return result
  
  def getMassNumber(self):
    """
    Get for ccp.lims.RefSampleComponent.Label.massNumber
    """
    dataDict = self.__dict__
    result = dataDict.get('massNumber')
    return result

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass
  
  def getNumInstances(self):
    """
    Get for ccp.lims.RefSampleComponent.Label.numInstances
    """
    dataDict = self.__dict__
    result = dataDict.get('numInstances')
    return result

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName
  
  def getParent(self):
    """
    Get for ccp.lims.RefSampleComponent.Label.parent
    """
    dataDict = self.__dict__
    result = dataDict.get('component')
    return result

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName

  getRoot = memops.api.Implementation.MemopsObject.getRoot
  
  def getSerial(self):
    """
    Get for ccp.lims.RefSampleComponent.Label.serial
    """
    dataDict = self.__dict__
    result = dataDict.get('serial')
    return result

  getTopObject = memops.api.Implementation.DataObject.getTopObject

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData
  
  def set(self, name, value):
    """
    SetAttr for ccp.lims.RefSampleComponent.Label
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData
  
  def setElementName(self, value):
    """
    Set for ccp.lims.RefSampleComponent.Label.elementName
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setElementName:
         memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 32):
        raise ApiError("""%s.setElementName:
         memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setElementName:
         memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.setElementName:
         Word constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('elementName')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setElementName:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setElementName:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['elementName'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setElementName')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setIncorporation(self, value):
    """
    Set for ccp.lims.RefSampleComponent.Label.incorporation
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.Float.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Float.create(value)
      else:
        raise ApiError("""%s.setIncorporation:
         memops.Implementation.FloatRatio input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (0.0 <= value)):
        raise ApiError("""%s.setIncorporation:
         FloatRatio constraint value_ge_0 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value - value == 0.0)):
        raise ApiError("""%s.setIncorporation:
         FloatRatio constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value <= 1.0)):
        raise ApiError("""%s.setIncorporation:
         FloatRatio constraint value_le_1 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('incorporation')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setIncorporation:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setIncorporation:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['incorporation'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setIncorporation')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setIsUniform(self, value):
    """
    Set for ccp.lims.RefSampleComponent.Label.isUniform
    """
    dataDict = self.__dict__
    if (value is not None):
      if (not (value in [True, False])):
        raise ApiError("""%s.setIsUniform:
         memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('isUniform')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setIsUniform:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setIsUniform:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['isUniform'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setIsUniform')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setLabelName(self, value):
    """
    Set for ccp.lims.RefSampleComponent.Label.labelName
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.setLabelName:
       ccp.lims.RefSampleComponent.LabelName input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 80):
      raise ApiError("""%s.setLabelName:
       ccp.lims.RefSampleComponent.LabelName maximum length is 80 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.setLabelName:
       ccp.lims.RefSampleComponent.LabelName: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.splitlines()) <= 1)):
      raise ApiError("""%s.setLabelName:
       LabelName constraint contains_no_linebreak violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('labelName')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setLabelName:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setLabelName:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setLabelName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['labelName'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setLabelName')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setLabelType(self, value):
    """
    Set for ccp.lims.RefSampleComponent.Label.labelType
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.setLabelType:
       ccp.lims.RefSampleComponent.LabelType input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 80):
      raise ApiError("""%s.setLabelType:
       ccp.lims.RefSampleComponent.LabelType maximum length is 80 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.setLabelType:
       ccp.lims.RefSampleComponent.LabelType: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.splitlines()) <= 1)):
      raise ApiError("""%s.setLabelType:
       LabelType constraint contains_no_linebreak violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('labelType')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setLabelType:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setLabelType:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setLabelType:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['labelType'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setLabelType')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setMassNumber(self, value):
    """
    Set for ccp.lims.RefSampleComponent.Label.massNumber
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.setMassNumber:
         memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('massNumber')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setMassNumber:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setMassNumber:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['massNumber'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setMassNumber')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setNumInstances(self, value):
    """
    Set for ccp.lims.RefSampleComponent.Label.numInstances
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.setNumInstances:
         memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('numInstances')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setNumInstances:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setNumInstances:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['numInstances'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setNumInstances')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setSerial(self, value):
    """
    Set for ccp.lims.RefSampleComponent.Label.serial
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Int.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Int.create(value)
    else:
      raise ApiError("""%s.setSerial:
       memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('serial')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setSerial:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setSerial:
         cannot set serial, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setSerial:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    parent = dataDict.get('component')
    oldSerial = parent.__dict__.get('_serialDict').get('labels')
    if (value < 0):
      value = (oldSerial + 1)
      parent.__dict__.get('_serialDict')['labels'] = value
    elif (value > oldSerial):
      parent.__dict__.get('_serialDict')['labels'] = value

    dataDict['serial'] = value

    # doNotifies

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  applicationData = memops.api.Implementation.DataObject.applicationData

  className = memops.api.Implementation.ComplexDataType.className
  
  elementName = property(getElementName, setElementName, None,
  r"""Name of element used for labeling. e.g. 'C' for C13 or C14, 'S', for 
  radioactive sulphur, 'Se' for SelenoMethionine. Not set is not 
  applicable.
  """)

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor
  
  incorporation = property(getIncorporation, setIncorporation, None,
  r"""Fractional incorporation of label.  Not set is not applicable.
  """)

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted
  
  isUniform = property(getIsUniform, setIsUniform, None,
  r"""Is label uniform, i.e. is the label present in all sites where it might 
  be expected? Uniform labeling is for instance where all Methionines were 
  SelenoMethionine, or where all carbons were 13C labeled.
  """)
  
  labelName = property(getLabelName, setLabelName, None,
  r"""name of label, describing the exact label used. See datatype for details
  """)
  
  labelType = property(getLabelType, setLabelType, None,
  r"""Type of label. See datatype for details
  """)
  
  massNumber = property(getMassNumber, setMassNumber, None,
  r"""Mass number of isotope of element used for labeling. e.g. 13 for 13C. 
  Not set is not applicable.
  """)

  metaclass = memops.api.Implementation.ComplexDataType.metaclass
  
  numInstances = property(getNumInstances, setNumInstances, None,
  r"""number of instances of label present in component. Not set is not 
  applicable.
  """)

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName
  
  serial = property(getSerial, setSerial, None,
  r"""Serial number of object. Serves as object main key. Serial numbers of 
  deleted objects are not re-used. Serial numbers can only be set by the 
  implementation. Values are in practice always positive, since negative 
  values are interpreted as a signal to set the next free serial
  """)

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess
  
  component = property(getComponent,  None, None,
  r"""parent link
  """)
  
  parent = property(getParent, None, None,
  r"""link to parent object - synonym for component
  """)

  root = memops.api.Implementation.MemopsObject.root

  topObject = memops.api.Implementation.DataObject.topObject

###############################################################################
class MolCompFeature(memops.api.Implementation.DataObject):
  r"""The MolCompFeature is used to assign information to each part of the 
MolComponent sequence, as defined by a series of MolResidues with 
consecutive serials.
  """
  #   from data model element ccp.lims.RefSampleComponent.MolCompFeature revision ?
  _metaclass = metaPackage.getElement('MolCompFeature')
  _packageName = 'ccp.lims.RefSampleComponent'
  _packageShortName = 'REFS'
  _fieldNames = ('applicationData', 'className', 'details', 'endSeqId', 'featureType', 'fieldNames', 'inConstructor', 'isDeleted', 'length', 'metaclass', 'name', 'ordering', 'packageName', 'packageShortName', 'qualifiedName', 'serial', 'startSeqId', 'status', 'access', 'activeAccess', 'molComponent', 'parent', 'refMolComponent', 'root', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for ccp.lims.RefSampleComponent.MolCompFeature
    """
    dataDict = self.__dict__
    dataDict['molComponent'] = parent
    if (not isinstance(parent, MolComponent)):
      raise ApiError("""%s.__init__:
       value is not of class ccp.lims.RefSampleComponent.MolComponent""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = parent.__dict__.get('topObject')
    dataDict['topObject'] = topObject

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    if (notIsReading):
      if (not (topObject.__dict__.get('isModifiable'))):
        raise ApiError("""%s.__init__:
         Storage not modifiable""" % self.qualifiedName
         + ": %s" % (topObject,)
        )

    try:

      dataDict['applicationData'] = list()
      dataDict['details'] = None
      dataDict['endSeqId'] = None
      dataDict['featureType'] = None
      dataDict['name'] = None
      dataDict['ordering'] = None
      dataDict['serial'] = None
      dataDict['startSeqId'] = None
      dataDict['status'] = None
      dataDict['access'] = None
      dataDict['refMolComponent'] = None

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in ccp.lims.RefSampleComponent.MolCompFeature.__init__"
        del dataDict['inConstructor']
        raise

      if (notOverride):
        if (dataDict.get('serial') is None):
          dataDict['inConstructor'] = True
          self.setSerial(-1)
          del dataDict['inConstructor']
        else:
          raise ApiError("""%s.__init__:
           Cannot pass in explicit serial if not reading""" % self.qualifiedName
           + ": %s:%s" % (parent, 'ccp.lims.RefSampleComponent.MolCompFeature')
          )

      if (notIsReading):
        childrenDict = parent.__dict__.get('molCompFeatures')
        objKey = dataDict.get('serial')
        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['serial'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notOverride):
        self.checkValid()

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for ccp.lims.RefSampleComponent.MolCompFeature:
       
    determines cascading deletes to follow from delete of object.
       
    *Implementation function* - should be called only by API delete 
    function.
    """
    dataDict = self.__dict__
    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for ccp.lims.RefSampleComponent.MolCompFeature:   deletes
    objects
    *Implementation function* - will CORRUPT DATA if called outside 
    the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    refMolComponent = dataDict.get('refMolComponent')
    if ((refMolComponent is not None and not (refMolComponent in objsToBeDeleted))):
      refMolCompFeatures = refMolComponent.__dict__.get('refMolCompFeatures')
      refMolCompFeatures.remove(self)

    molComponent = dataDict.get('molComponent')
    if (not (molComponent in objsToBeDeleted)):
      objKey = dataDict.get('serial')
      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = molComponent.__dict__.get('molCompFeatures')
        if (self is dd.get(objKey)):
          del dd[objKey]

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData
  
  def checkAllValid(self, complete=False):
    """
    CheckAllValid for ccp.lims.RefSampleComponent.MolCompFeature
    """
    dataDict = self.__dict__
    self.checkValid(complete)
  
  def checkValid(self, complete=False):
    """
    CheckValid for ccp.lims.RefSampleComponent.MolCompFeature
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      objKey = dataDict.get('serial')
      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('molComponent')
        dd = value.__dict__.get('molCompFeatures')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'molComponent' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      # check attributes
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('details')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: details:
           memops.Implementation.String input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('endSeqId')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.Int.PythonType)):
          pass
        elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
          value = memops.api.Implementation.Int.create(value)
        else:
          raise ApiError("""%s.checkValid: endSeqId:
           memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('featureType')
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: featureType:
         ccp.lims.RefSampleComponent.FeatureType input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: featureType:
         ccp.lims.RefSampleComponent.FeatureType maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: featureType:
         ccp.lims.RefSampleComponent.FeatureType: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: featureType:
         FeatureType constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = self.getLength()
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.Int.PythonType)):
          pass
        elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
          value = memops.api.Implementation.Int.create(value)
        else:
          raise ApiError("""%s.checkValid: length:
           memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('name')
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: name:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: name:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: name:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: name:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('ordering')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.Int.PythonType)):
          pass
        elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
          value = memops.api.Implementation.Int.create(value)
        else:
          raise ApiError("""%s.checkValid: ordering:
           memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('serial')
      if (value is None):
        raise ApiError("""%s.checkValid: serial:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.checkValid: serial:
         memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('startSeqId')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.Int.PythonType)):
          pass
        elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
          value = memops.api.Implementation.Int.create(value)
        else:
          raise ApiError("""%s.checkValid: startSeqId:
           memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('status')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: status:
           ccp.lims.RefSampleComponent.StatusType input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: status:
           ccp.lims.RefSampleComponent.StatusType maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: status:
           ccp.lims.RefSampleComponent.StatusType: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: status:
           StatusType constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('molComponent')
      if (not isinstance(value, MolComponent)):
        raise ApiError("""%s.checkValid: molComponent:
         value is not of class ccp.lims.RefSampleComponent.MolComponent""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('refMolComponent')
      if (value is not None):
        if (not isinstance(value, MolComponent)):
          raise ApiError("""%s.checkValid: refMolComponent:
           value is not of class ccp.lims.RefSampleComponent.MolComponent""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('refMolCompFeatures')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: refMolComponent:
           non-reciprocal link refMolComponent from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

    # check explicit class constraints
    # check attributes
    values = dataDict.get('applicationData')
    for value in values:
      value.checkAllValid(complete)

    value = dataDict.get('details')
    value = dataDict.get('endSeqId')
    value = dataDict.get('featureType')
    if (value is None):
      raise ApiError("""%s.checkValid: featureType:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('name')
    if (value is None):
      raise ApiError("""%s.checkValid: name:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('ordering')
    value = dataDict.get('startSeqId')
    value = dataDict.get('status')
    # check roles
    value = dataDict.get('access')
    value = dataDict.get('molComponent')
    if (value is None):
      raise ApiError("""%s.checkValid: molComponent:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('refMolComponent')

  delete = memops.api.Implementation.DataObject.delete

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData
  
  def get(self, name):
    """
    GetAttr for ccp.lims.RefSampleComponent.MolCompFeature
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccp.lims.RefSampleComponent.MolCompFeature
    """

    result = None
    if (startObj.__class__.__name__ == 'MemopsRoot'):
      if (3 != len(fullKey)):
        raise ApiError("""'ccp.lims.RefSampleComponent.MolCompFeature'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj0 = startObj
      objKey = fullKey[0]
      obj1 = obj0.__dict__.get('refSampleComponentStores').get(objKey)
      if (obj1 is None):
        obj0.refreshTopObjects('ccp.lims.RefSampleComponent')
        obj1 = obj0.__dict__.get('refSampleComponentStores').get(objKey)

    else:
      if (2 != len(fullKey)):
        raise ApiError("""'ccp.lims.RefSampleComponent.MolCompFeature'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj1 = startObj

    if (obj1 is not None):
      if (not (obj1.__dict__.get('isLoaded'))):
        obj1.load()

      objKey = fullKey[-2]
      obj2 = obj1.__dict__.get('components').get(objKey)

      if (obj2 is not None):
        objKey = fullKey[-1]
        obj3 = obj2.__dict__.get('molCompFeatures').get(objKey)
        result = obj3

    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation

  getClassName = memops.api.Implementation.ComplexDataType.getClassName
  
  def getDetails(self):
    """
    Get for ccp.lims.RefSampleComponent.MolCompFeature.details
    """
    dataDict = self.__dict__
    result = dataDict.get('details')
    return result
  
  def getEndSeqId(self):
    """
    Get for ccp.lims.RefSampleComponent.MolCompFeature.endSeqId
    """
    dataDict = self.__dict__
    result = dataDict.get('endSeqId')
    return result

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey
  
  def getFeatureType(self):
    """
    Get for ccp.lims.RefSampleComponent.MolCompFeature.featureType
    """
    dataDict = self.__dict__
    result = dataDict.get('featureType')
    return result

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames
  
  def getFullKey(self, useGuid=False):
    """
    GetFullKey for ccp.lims.RefSampleComponent.MolCompFeature
    """
    dataDict = self.__dict__
    result = list()

    obj2 = dataDict.get('molComponent')
    obj1 = obj2.__dict__.get('refSampleComponentStore')

    if (useGuid):
      result.append(obj1.__dict__.get('guid'))
    else:
      result.append(obj1.__dict__.get('name'))

    result.append(obj2.__dict__.get('name'))
    result.append(dataDict.get('serial'))

    return result

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted
  
  def getLength(self):
    """
    Getter for derived attribute length.
    """
    dataDict = self.__dict__
    if self.startSeqId == None or self.endSeqId == None:
      result = None
    else:
      result = self.endSeqId - self.startSeqId + 1
    return result
  
  def getLocalKey(self):
    """
    GetLocalKey for ccp.lims.RefSampleComponent.MolCompFeature
    """
    dataDict = self.__dict__
    result = dataDict.get('serial')
    return result

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass
  
  def getMolComponent(self):
    """
    Get for ccp.lims.RefSampleComponent.MolCompFeature.molComponent
    """
    dataDict = self.__dict__
    result = dataDict.get('molComponent')
    return result
  
  def getName(self):
    """
    Get for ccp.lims.RefSampleComponent.MolCompFeature.name
    """
    dataDict = self.__dict__
    result = dataDict.get('name')
    return result
  
  def getOrdering(self):
    """
    Get for ccp.lims.RefSampleComponent.MolCompFeature.ordering
    """
    dataDict = self.__dict__
    result = dataDict.get('ordering')
    return result

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName
  
  def getParent(self):
    """
    Get for ccp.lims.RefSampleComponent.MolCompFeature.parent
    """
    dataDict = self.__dict__
    result = dataDict.get('molComponent')
    return result

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName
  
  def getRefMolComponent(self):
    """
    Get for ccp.lims.RefSampleComponent.MolCompFeature.refMolComponent
    """
    dataDict = self.__dict__
    result = dataDict.get('refMolComponent')
    return result

  getRoot = memops.api.Implementation.MemopsObject.getRoot
  
  def getSerial(self):
    """
    Get for ccp.lims.RefSampleComponent.MolCompFeature.serial
    """
    dataDict = self.__dict__
    result = dataDict.get('serial')
    return result
  
  def getStartSeqId(self):
    """
    Get for ccp.lims.RefSampleComponent.MolCompFeature.startSeqId
    """
    dataDict = self.__dict__
    result = dataDict.get('startSeqId')
    return result
  
  def getStatus(self):
    """
    Get for ccp.lims.RefSampleComponent.MolCompFeature.status
    """
    dataDict = self.__dict__
    result = dataDict.get('status')
    return result

  getTopObject = memops.api.Implementation.DataObject.getTopObject

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData
  
  def set(self, name, value):
    """
    SetAttr for ccp.lims.RefSampleComponent.MolCompFeature
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData
  
  def setDetails(self, value):
    """
    Set for ccp.lims.RefSampleComponent.MolCompFeature.details
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setDetails:
         memops.Implementation.String input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('details')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setDetails:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setDetails:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['details'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setDetails')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setEndSeqId(self, value):
    """
    Set for ccp.lims.RefSampleComponent.MolCompFeature.endSeqId
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.setEndSeqId:
         memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('endSeqId')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setEndSeqId:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setEndSeqId:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['endSeqId'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setEndSeqId')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setFeatureType(self, value):
    """
    Set for ccp.lims.RefSampleComponent.MolCompFeature.featureType
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.setFeatureType:
       ccp.lims.RefSampleComponent.FeatureType input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 80):
      raise ApiError("""%s.setFeatureType:
       ccp.lims.RefSampleComponent.FeatureType maximum length is 80 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.setFeatureType:
       ccp.lims.RefSampleComponent.FeatureType: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.splitlines()) <= 1)):
      raise ApiError("""%s.setFeatureType:
       FeatureType constraint contains_no_linebreak violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('featureType')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setFeatureType:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setFeatureType:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setFeatureType:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['featureType'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setFeatureType')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setName(self, value):
    """
    Set for ccp.lims.RefSampleComponent.MolCompFeature.name
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.setName:
       memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 80):
      raise ApiError("""%s.setName:
       memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.setName:
       memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.splitlines()) <= 1)):
      raise ApiError("""%s.setName:
       Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('name')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setName:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setName:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['name'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setName')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setOrdering(self, value):
    """
    Set for ccp.lims.RefSampleComponent.MolCompFeature.ordering
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.setOrdering:
         memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('ordering')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setOrdering:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setOrdering:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['ordering'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setOrdering')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setRefMolComponent(self, value):
    """
    Set for ccp.lims.RefSampleComponent.MolCompFeature.refMolComponent
    """
    dataDict = self.__dict__
    if (value is not None):
      if (not isinstance(value, MolComponent)):
        raise ApiError("""%s.setRefMolComponent:
         value is not of class ccp.lims.RefSampleComponent.MolComponent""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('refMolComponent')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setRefMolComponent:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setRefMolComponent:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setRefMolComponent:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setRefMolComponent:
           Link refMolComponent between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    if (currentValue is not None):
      if (notIsReading):
        oldSelves = currentValue.__dict__.get('refMolCompFeatures')
        oldSelves.remove(self)
      else:
        raise ApiError("""%s.setRefMolComponent:
         Read link 'refMolComponent' incompatible with pre-existing link""" % self.qualifiedName
         + ": %s" % (self,)
        )

    if (value is not None):
      newSelves = value.__dict__.get('refMolCompFeatures')
      newSelves.add(self)

    dataDict['refMolComponent'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setRefMolComponent')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setSerial(self, value):
    """
    Set for ccp.lims.RefSampleComponent.MolCompFeature.serial
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Int.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Int.create(value)
    else:
      raise ApiError("""%s.setSerial:
       memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('serial')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setSerial:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setSerial:
         cannot set serial, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setSerial:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    parent = dataDict.get('molComponent')
    oldSerial = parent.__dict__.get('_serialDict').get('molCompFeatures')
    if (value < 0):
      value = (oldSerial + 1)
      parent.__dict__.get('_serialDict')['molCompFeatures'] = value
    elif (value > oldSerial):
      parent.__dict__.get('_serialDict')['molCompFeatures'] = value

    dataDict['serial'] = value

    # doNotifies
  
  def setStartSeqId(self, value):
    """
    Set for ccp.lims.RefSampleComponent.MolCompFeature.startSeqId
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.setStartSeqId:
         memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('startSeqId')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setStartSeqId:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setStartSeqId:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['startSeqId'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setStartSeqId')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setStatus(self, value):
    """
    Set for ccp.lims.RefSampleComponent.MolCompFeature.status
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setStatus:
         ccp.lims.RefSampleComponent.StatusType input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.setStatus:
         ccp.lims.RefSampleComponent.StatusType maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setStatus:
         ccp.lims.RefSampleComponent.StatusType: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.setStatus:
         StatusType constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('status')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setStatus:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setStatus:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['status'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setStatus')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  applicationData = memops.api.Implementation.DataObject.applicationData

  className = memops.api.Implementation.ComplexDataType.className
  
  details = property(getDetails, setDetails, None,
  r"""Detail field for comments.
  """)
  
  endSeqId = property(getEndSeqId, setEndSeqId, None,
  r"""Residue number (MolResidue.serial) of the end sequence in the 
  MolComponent.
  """)
  
  featureType = property(getFeatureType, setFeatureType, None,
  r"""The type of the feature e.g. 'tag', 'cleavage site', 'promoter', 
  'resistance', 'marker', 'product',...
  """)

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted
  
  length = property(getLength, None, None,
  r"""The sequence length of the feature.
  """)

  metaclass = memops.api.Implementation.ComplexDataType.metaclass
  
  name = property(getName, setName, None,
  r"""The name of the feature.
  """)
  
  ordering = property(getOrdering, setOrdering, None,
  r"""Integer defining the ordering of MolCompFeatures. For when startSeqId 
  and endSeqId are not known.
  """)

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName
  
  serial = property(getSerial, setSerial, None,
  r"""Serial number of object. Serves as object main key. Serial numbers of 
  deleted objects are not re-used. Serial numbers can only be set by the 
  implementation. Values are in practice always positive, since negative 
  values are interpreted as a signal to set the next free serial
  """)
  
  startSeqId = property(getStartSeqId, setStartSeqId, None,
  r"""Residue number (MolResidue.serial) of the start sequence in the 
  MolComponent.
  """)
  
  status = property(getStatus, setStatus, None,
  r"""The status of the feature e.g. cut, uncut,...
  """)

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess
  
  molComponent = property(getMolComponent,  None, None,
  r"""parent link
  """)
  
  parent = property(getParent, None, None,
  r"""link to parent object - synonym for molComponent
  """)
  
  refMolComponent = property(getRefMolComponent, setRefMolComponent, None,
  r"""
  """)

  root = memops.api.Implementation.MemopsObject.root

  topObject = memops.api.Implementation.DataObject.topObject

###############################################################################
class RefSampleComponentStore(memops.api.Implementation.TopObject):
  r"""TopObject for RefSampleComponent package
  """
  #   from data model element ccp.lims.RefSampleComponent.RefSampleComponentStore revision ?
  _metaclass = metaPackage.getElement('RefSampleComponentStore')
  _packageName = 'ccp.lims.RefSampleComponent'
  _packageShortName = 'REFS'
  _fieldNames = ('applicationData', 'className', 'createdBy', 'fieldNames', 'guid', 'inConstructor', 'isDeleted', 'isLoaded', 'isModifiable', 'isModified', 'isReading', 'lastUnlockedBy', 'metaclass', 'name', 'packageName', 'packageShortName', 'qualifiedName', 'access', 'activeAccess', 'activeRepositories', 'components', 'memopsRoot', 'packageLocator', 'parent', 'refDataStores', 'root', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for ccp.lims.RefSampleComponent.RefSampleComponentStore
    """
    dataDict = self.__dict__
    dataDict['memopsRoot'] = parent
    from memops.api.Implementation import MemopsRoot as importedType
    if (not isinstance(parent, importedType)):
      raise ApiError("""%s.__init__:
       value is not of class memops.Implementation.MemopsRoot""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = self
    dataDict['topObject'] = topObject
    if (attrlinks.get('isReading', False)):
      del attrlinks['isReading']
      dataDict['isLoaded'] = False
      dataDict['isModified'] = False
      dataDict['isReading'] = True
    elif (parent.__dict__.get('isReading')):
      dataDict['isLoaded'] = False
      dataDict['isModified'] = False
      dataDict['isReading'] = True
    else:
      dataDict['isLoaded'] = True
      dataDict['isModified'] = True
      dataDict['isReading'] = False

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    try:
      if (not (dataDict.get('isReading'))):
        parent.refreshTopObjects('ccp.lims.RefSampleComponent')

      dataDict['applicationData'] = list()
      dataDict['createdBy'] = None
      dataDict['guid'] = None
      dataDict['isModifiable'] = True
      dataDict['lastUnlockedBy'] = None
      dataDict['name'] = None
      dataDict['access'] = None
      dataDict['components'] = {}
      dataDict['refDataStores'] = set()
      dataDict['activeRepositories'] = list()

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in ccp.lims.RefSampleComponent.RefSampleComponentStore.__init__"
        del dataDict['inConstructor']
        raise

      if (notIsReading):
        childrenDict = parent.__dict__.get('refSampleComponentStores')
        objKey = dataDict.get('name')
        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['name'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notIsReading):
        guid = dataDict.get('guid')
        if (guid is None):
          guid = root.newGuid()
          dataDict['guid'] = guid

        dd = root.__dict__.get('topObjects')
        if (dd.get(guid) is None):
          dd[guid] = self
        else:
          raise ApiError("""%s.__init__:
           Creating TopObject with preexisting guid""" % self.qualifiedName
           + ": %s" % (self,)
          )

        dataDict['createdBy'] = root.__dict__.get('currentUserId')

      if (notOverride):
        self.checkValid()

      if ((notIsReading or root.__dict__.get('currentRefSampleComponentStore') is None)):
        root.__dict__['currentRefSampleComponentStore'] = self

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for ccp.lims.RefSampleComponent.RefSampleComponentStore:
       
    determines cascading deletes to follow from delete of object.
       
    *Implementation function* - should be called only by API delete 
    function.
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    components = dataDict.get('components').values()
    for component in components:
      if (not (component in objsToBeDeleted)):
        objsToBeDeleted.add(component)
        objsToBeChecked.append(component)

    memopsRoot = dataDict.get('memopsRoot')
    if (memopsRoot is not None):
      topObject = memopsRoot.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    root = dataDict.get('memopsRoot')
    root.refreshTopObjects('ccp.lims.RefData')
    refDataStores = dataDict.get('refDataStores')
    for refDataStore in refDataStores:
      if (not (refDataStore in objsToBeDeleted)):
        objsToBeDeleted.add(refDataStore)
        objsToBeChecked.append(refDataStore)

    for refDataStore in refDataStores:
      topObject = refDataStore.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for ccp.lims.RefSampleComponent.RefSampleComponentStore:
    deletes objects
    *Implementation function* - will CORRUPT DATA if called 
    outside the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    memopsRoot = dataDict.get('memopsRoot')
    if (self is memopsRoot.__dict__.get('currentRefSampleComponentStore')):
      memopsRoot.__dict__['currentRefSampleComponentStore'] = None

    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    memopsRoot = dataDict.get('memopsRoot')
    if (not (memopsRoot in objsToBeDeleted)):
      objKey = dataDict.get('name')
      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = memopsRoot.__dict__.get('refSampleComponentStores')
        if (self is dd.get(objKey)):
          del dd[objKey]

    dataDict['components'] = {}

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData

  backup = memops.api.Implementation.TopObject.backup
  
  def checkAllValid(self, complete=False):
    """
    CheckAllValid for ccp.lims.RefSampleComponent.RefSampleComponentStore
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    self.checkValid(complete)
    values = dataDict.get('components').values()
    for value in values:
      value.checkAllValid(complete)

  def checkValid(self, complete=False):
    """
    CheckValid for ccp.lims.RefSampleComponent.RefSampleComponentStore
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      objKey = dataDict.get('name')
      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('memopsRoot')
        dd = value.__dict__.get('refSampleComponentStores')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'memopsRoot' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      # check attributes
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('createdBy')
      if (value is None):
        raise ApiError("""%s.checkValid: createdBy:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: createdBy:
         memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 32):
        raise ApiError("""%s.checkValid: createdBy:
         memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: createdBy:
         memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.checkValid: createdBy:
         Word constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('guid')
      if (value is None):
        raise ApiError("""%s.checkValid: guid:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: guid:
         memops.Implementation.GuidString input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: guid:
         memops.Implementation.GuidString maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: guid:
         memops.Implementation.GuidString: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: guid:
         GuidString constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      isValid = frozenset('abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_0123456789-').issuperset(value)
      if (not (isValid)):
        raise ApiError("""%s.checkValid: guid:
         GuidString constraint value_is_url_safe violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('isModifiable')
      if (not (value in [True, False])):
        raise ApiError("""%s.checkValid: isModifiable:
         memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('lastUnlockedBy')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: lastUnlockedBy:
           memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 32):
          raise ApiError("""%s.checkValid: lastUnlockedBy:
           memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: lastUnlockedBy:
           memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.split()) == 1)):
          raise ApiError("""%s.checkValid: lastUnlockedBy:
           Word constraint contains_no_white_space violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('name')
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: name:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: name:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: name:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: name:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      values = dataDict.get('components').values()
      for value in values:
        if (not isinstance(value, AbstractComponent)):
          raise ApiError("""%s.checkValid: components:
           value is not of class ccp.lims.RefSampleComponent.AbstractComponent""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('refSampleComponentStore')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: components:
           non-reciprocal link components from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      value = dataDict.get('memopsRoot')
      from memops.api.Implementation import MemopsRoot as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.checkValid: memopsRoot:
         value is not of class memops.Implementation.MemopsRoot""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = self.getPackageLocator()
      if (value is None):
        raise ApiError("""%s.checkValid: packageLocator:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      from memops.api.Implementation import PackageLocator as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.checkValid: packageLocator:
         value is not of class memops.Implementation.PackageLocator""" % self.qualifiedName
         + ": %s" % (value,)
        )

      xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
      yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
      if (not (xx1 is yy1)):
        raise ApiError("""%s.checkValid: packageLocator:
         Link packageLocator between objects from separate partitions
         - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
         + ": %s:%s" % (self, value)
        )

      root = dataDict.get('memopsRoot')
      root.refreshTopObjects('ccp.lims.RefData')
      values = dataDict.get('refDataStores')
      for value in values:
        from ccp.api.lims.RefData import RefDataStore as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: refDataStores:
           value is not of class ccp.lims.RefData.RefDataStore""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('refSampleComponentStore')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: refDataStores:
           non-reciprocal link refDataStores from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: refDataStores:
           Link refDataStores between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    if (dataDict.get('isLoaded')):
      # check explicit class constraints
      # check attributes
      values = dataDict.get('applicationData')
      for value in values:
        value.checkAllValid(complete)

      value = dataDict.get('isModifiable')
      if (value is None):
        raise ApiError("""%s.checkValid: isModifiable:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      value = dataDict.get('name')
      if (value is None):
        raise ApiError("""%s.checkValid: name:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      # check roles
      value = dataDict.get('access')
      values = dataDict.get('components').values()
      value = dataDict.get('memopsRoot')
      if (value is None):
        raise ApiError("""%s.checkValid: memopsRoot:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      values = dataDict.get('refDataStores')
    else:
      # check unloaded TopObject
      value = dataDict.get('guid')
      if (value is None):
        raise ApiError("""%s.checkValid: guid:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      value = dataDict.get('name')
      if (value is None):
        raise ApiError("""%s.checkValid: name:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

  delete = memops.api.Implementation.DataObject.delete

  findAllActiveRepositories = memops.api.Implementation.TopObject.findAllActiveRepositories

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData
  
  def findAllComponents(self, **conditions):
    """
    FindAll for
    ccp.lims.RefSampleComponent.RefSampleComponentStore.components
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('components').values()
      result = set(currentValues)

    else:
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('components').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('details', 'name', 'access', 'naturalSource', 'refSampleComponentStore',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllRefDataStores(self, **conditions):
    """
    FindAll for
    ccp.lims.RefSampleComponent.RefSampleComponentStore.refDataStores
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = dataDict.get('memopsRoot')
      root.refreshTopObjects('ccp.lims.RefData')
      currentValues = dataDict.get('refDataStores')
      result = set(currentValues)

    else:
      root = dataDict.get('memopsRoot')
      root.refreshTopObjects('ccp.lims.RefData')
      currentValues = dataDict.get('refDataStores')
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('createdBy', 'guid', 'isModifiable', 'lastUnlockedBy', 'name', 'access', 'memopsRoot', 'refSampleComponentStore',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result

  findFirstActiveRepository = memops.api.Implementation.TopObject.findFirstActiveRepository

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData
  
  def findFirstComponent(self, **conditions):
    """
    FindFirst for
    ccp.lims.RefSampleComponent.RefSampleComponentStore.components
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('components').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      objKey = conditions.get('name')
      if (objKey is not None):
        if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
          self.load()

        result = dataDict.get('components').get(objKey)

        if (nConditions <= 1):
          return result

        elif (result is None):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
          self.load()

        currentValues = dataDict.get('components').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('details', 'name', 'access', 'naturalSource', 'refSampleComponentStore',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstRefDataStore(self, **conditions):
    """
    FindFirst for
    ccp.lims.RefSampleComponent.RefSampleComponentStore.refDataStores
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = dataDict.get('memopsRoot')
      root.refreshTopObjects('ccp.lims.RefData')
      currentValues = dataDict.get('refDataStores')
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      root = dataDict.get('memopsRoot')
      root.refreshTopObjects('ccp.lims.RefData')
      currentValues = dataDict.get('refDataStores')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('createdBy', 'guid', 'isModifiable', 'lastUnlockedBy', 'name', 'access', 'memopsRoot', 'refSampleComponentStore',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def get(self, name):
    """
    GetAttr for ccp.lims.RefSampleComponent.RefSampleComponentStore
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess

  getActiveRepositories = memops.api.Implementation.TopObject.getActiveRepositories

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccp.lims.RefSampleComponent.RefSampleComponentStore
    """

    result = None
    if (1 != len(fullKey)):
      raise ApiError("""'ccp.lims.RefSampleComponent.RefSampleComponentStore'.getByKey:
       getByKey called with fullKey of wrong length. Parameters:"""
       + ": %s:%s" % (startObj, fullKey)
      )

    objKey = fullKey[0]
    obj1 = startObj.__dict__.get('refSampleComponentStores').get(objKey)
    if (obj1 is None):
      startObj.refreshTopObjects('ccp.lims.RefSampleComponent')
      obj1 = startObj.__dict__.get('refSampleComponentStores').get(objKey)

    result = obj1
    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation

  getClassName = memops.api.Implementation.ComplexDataType.getClassName
  
  def getComponents(self):
    """
    Get for ccp.lims.RefSampleComponent.RefSampleComponentStore.components
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    tempVar = dataDict.get('components').values()
    result = frozenset(tempVar)
    return result

  getCreatedBy = memops.api.Implementation.TopObject.getCreatedBy

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames
  
  def getFullKey(self, useGuid=False):
    """
    GetFullKey for ccp.lims.RefSampleComponent.RefSampleComponentStore
    """
    dataDict = self.__dict__
    result = list()

    if (useGuid):
      result.append(dataDict.get('guid'))
    else:
      result.append(dataDict.get('name'))

    return result

  getGuid = memops.api.Implementation.TopObject.getGuid

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted

  getIsLoaded = memops.api.Implementation.TopObject.getIsLoaded

  getIsModifiable = memops.api.Implementation.TopObject.getIsModifiable

  getIsModified = memops.api.Implementation.TopObject.getIsModified

  getIsReading = memops.api.Implementation.TopObject.getIsReading

  getLastUnlockedBy = memops.api.Implementation.TopObject.getLastUnlockedBy
  
  def getLocalKey(self):
    """
    GetLocalKey for ccp.lims.RefSampleComponent.RefSampleComponentStore
    """
    dataDict = self.__dict__
    result = dataDict.get('name')
    return result
  
  def getMemopsRoot(self):
    """
    Get for ccp.lims.RefSampleComponent.RefSampleComponentStore.memopsRoot
    """
    dataDict = self.__dict__
    result = dataDict.get('memopsRoot')
    return result

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass
  
  def getName(self):
    """
    Get for ccp.lims.RefSampleComponent.RefSampleComponentStore.name
    """
    dataDict = self.__dict__
    result = dataDict.get('name')
    return result

  getPackageLocator = memops.api.Implementation.TopObject.getPackageLocator

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName
  
  def getParent(self):
    """
    Get for ccp.lims.RefSampleComponent.RefSampleComponentStore.parent
    """
    dataDict = self.__dict__
    result = dataDict.get('memopsRoot')
    return result

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName
  
  def getRefDataStores(self):
    """
    Get for
    ccp.lims.RefSampleComponent.RefSampleComponentStore.refDataStores
    """
    dataDict = self.__dict__
    root = dataDict.get('memopsRoot')
    root.refreshTopObjects('ccp.lims.RefData')
    tempVar = dataDict.get('refDataStores')
    result = frozenset(tempVar)
    return result

  getRoot = memops.api.Implementation.MemopsObject.getRoot

  getTopObject = memops.api.Implementation.DataObject.getTopObject

  load = memops.api.Implementation.TopObject.load

  loadFrom = memops.api.Implementation.TopObject.loadFrom
  
  def newCell(self, **attrlinks):
    """
    Factory function to create ccp.lims.RefSampleComponent.Cell
    """
    return Cell(self, **attrlinks)
  
  def newComposite(self, **attrlinks):
    """
    Factory function to create ccp.lims.RefSampleComponent.Composite
    """
    return Composite(self, **attrlinks)
  
  def newConstruct(self, **attrlinks):
    """
    Factory function to create ccp.lims.RefSampleComponent.Construct
    """
    return Construct(self, **attrlinks)
  
  def newMolComponent(self, **attrlinks):
    """
    Factory function to create ccp.lims.RefSampleComponent.MolComponent
    """
    return MolComponent(self, **attrlinks)
  
  def newPrimer(self, **attrlinks):
    """
    Factory function to create ccp.lims.RefSampleComponent.Primer
    """
    return Primer(self, **attrlinks)
  
  def newRestrictionEnzyme(self, **attrlinks):
    """
    Factory function to create ccp.lims.RefSampleComponent.RestrictionEnzyme
    """
    return RestrictionEnzyme(self, **attrlinks)
  
  def newSubstance(self, **attrlinks):
    """
    Factory function to create ccp.lims.RefSampleComponent.Substance
    """
    return Substance(self, **attrlinks)

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData

  removeFrom = memops.api.Implementation.TopObject.removeFrom

  restore = memops.api.Implementation.TopObject.restore

  save = memops.api.Implementation.TopObject.save

  saveTo = memops.api.Implementation.TopObject.saveTo
  
  def set(self, name, value):
    """
    SetAttr for ccp.lims.RefSampleComponent.RefSampleComponentStore
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData

  setCreatedBy = memops.api.Implementation.TopObject.setCreatedBy

  setGuid = memops.api.Implementation.TopObject.setGuid

  setIsModifiable = memops.api.Implementation.TopObject.setIsModifiable

  setLastUnlockedBy = memops.api.Implementation.TopObject.setLastUnlockedBy
  
  def setName(self, value):
    """
    Set for ccp.lims.RefSampleComponent.RefSampleComponentStore.name
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.setName:
       memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 80):
      raise ApiError("""%s.setName:
       memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.setName:
       memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.splitlines()) <= 1)):
      raise ApiError("""%s.setName:
       Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValue = dataDict.get('name')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setName:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setName:
         cannot set name, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['name'] = value

    # doNotifies
  
  def setRefDataStores(self, values):
    """
    Set for
    ccp.lims.RefSampleComponent.RefSampleComponentStore.refDataStores
    """
    dataDict = self.__dict__
    xx = values
    values = set(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setRefDataStores:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      from ccp.api.lims.RefData import RefDataStore as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setRefDataStores:
         value is not of class ccp.lims.RefData.RefDataStore""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValues = dataDict.get('refDataStores')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      for pv in currentValues:
        if (not (pv in values)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)

      for pv in values:
        if (not (pv in currentValues)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)
          oldSelf = pv.__dict__.get('refSampleComponentStore')
          if (oldSelf is not None):
            if (notIsReading):
              topObject = oldSelf.__dict__.get('topObject')
              topObjectsToCheck.add(topObject)
            else:
              raise ApiError("""%s.setRefDataStores:
               Read link incompatible with pre-existing link""" % self.qualifiedName
               + ": %s" % (self,)
              )

      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setRefDataStores:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setRefDataStores:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setRefDataStores:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      for cv in currentValues:
        if (not (cv in values)):
          raise ApiError("""%s.setRefDataStores:
           locard refSampleComponentStore: cannot set because some of current values not in values""" % self.qualifiedName
           + ": %s" % (self,)
          )

      xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
      for value in values:
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setRefDataStores:
           Link refDataStores between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    for cv in currentValues:
      if (not (cv in values)):
        cv.__dict__['refSampleComponentStore'] = None

    for cv in values:
      if (not (cv in currentValues)):
        oldSelf = cv.__dict__.get('refSampleComponentStore')
        if (oldSelf is not None):
          vv = oldSelf.__dict__.get('refDataStores')
          vv.remove(cv)

      cv.__dict__['refSampleComponentStore'] = self

    dataDict['refDataStores'] = values
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        if (not (topObjectModify.__dict__.get('isLoaded'))):
          topObjectModify.load()

        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setRefDataStores')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def sortedComponents(self):
    """
    Sorted for
    ccp.lims.RefSampleComponent.RefSampleComponentStore.components
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    sortdd = dataDict.get('components')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result
  
  def sortedRefDataStores(self):
    """
    Sorted for
    ccp.lims.RefSampleComponent.RefSampleComponentStore.refDataStores
    """
    dataDict = self.__dict__
    root = dataDict.get('memopsRoot')
    root.refreshTopObjects('ccp.lims.RefData')
    ll = dataDict.get('refDataStores')
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  touch = memops.api.Implementation.TopObject.touch

  applicationData = memops.api.Implementation.DataObject.applicationData

  className = memops.api.Implementation.ComplexDataType.className

  createdBy = memops.api.Implementation.TopObject.createdBy

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames

  guid = memops.api.Implementation.TopObject.guid

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted

  isLoaded = memops.api.Implementation.TopObject.isLoaded

  isModifiable = memops.api.Implementation.TopObject.isModifiable

  isModified = memops.api.Implementation.TopObject.isModified

  isReading = memops.api.Implementation.TopObject.isReading

  lastUnlockedBy = memops.api.Implementation.TopObject.lastUnlockedBy

  metaclass = memops.api.Implementation.ComplexDataType.metaclass
  
  name = property(getName, setName, None,
  r"""name of RefSampleCompoenntStore
  """)

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess

  activeRepositories = memops.api.Implementation.TopObject.activeRepositories
  
  components = property(getComponents,  None, None,
  r"""child link to class AbstractComponent
  """)
  
  memopsRoot = property(getMemopsRoot,  None, None,
  r"""parent link
  """)

  packageLocator = memops.api.Implementation.TopObject.packageLocator
  
  parent = property(getParent, None, None,
  r"""link to parent object - synonym for memopsRoot
  """)
  
  refDataStores = property(getRefDataStores, setRefDataStores, None,
  r"""RefDataStore looking to this RefSampleComponentStore
  """)

  root = memops.api.Implementation.MemopsObject.root

  topObject = memops.api.Implementation.DataObject.topObject

###############################################################################
class SpecificLabelGroup(memops.api.Implementation.DataObject):
  r"""Group of specific isotope labels that apply together to an individual 
molecule. Molecules that are mixtures of isotopomers may have several 
SpecificLabelGroups. Isotope labeling given in SpecificLabelGroup and 
IsotopeLabel must be consistent with labeling given in the Label class, 
as both are valid together.
  """
  #   from data model element ccp.lims.RefSampleComponent.SpecificLabelGroup revision ?
  _metaclass = metaPackage.getElement('SpecificLabelGroup')
  _packageName = 'ccp.lims.RefSampleComponent'
  _packageShortName = 'REFS'
  _fieldNames = ('applicationData', 'className', 'fieldNames', 'fraction', 'inConstructor', 'isDeleted', 'metaclass', 'packageName', 'packageShortName', 'qualifiedName', 'serial', 'access', 'activeAccess', 'isotopeLabels', 'molComponent', 'parent', 'root', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for ccp.lims.RefSampleComponent.SpecificLabelGroup
    """
    dataDict = self.__dict__
    dataDict['molComponent'] = parent
    if (not isinstance(parent, MolComponent)):
      raise ApiError("""%s.__init__:
       value is not of class ccp.lims.RefSampleComponent.MolComponent""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = parent.__dict__.get('topObject')
    dataDict['topObject'] = topObject

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    if (notIsReading):
      if (not (topObject.__dict__.get('isModifiable'))):
        raise ApiError("""%s.__init__:
         Storage not modifiable""" % self.qualifiedName
         + ": %s" % (topObject,)
        )

    try:

      dataDict['applicationData'] = list()
      dataDict['fraction'] = 1.0
      dataDict['serial'] = None
      dataDict['access'] = None
      dataDict['isotopeLabels'] = {}

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in ccp.lims.RefSampleComponent.SpecificLabelGroup.__init__"
        del dataDict['inConstructor']
        raise

      if (notOverride):
        if (dataDict.get('serial') is None):
          dataDict['inConstructor'] = True
          self.setSerial(-1)
          del dataDict['inConstructor']
        else:
          raise ApiError("""%s.__init__:
           Cannot pass in explicit serial if not reading""" % self.qualifiedName
           + ": %s:%s" % (parent, 'ccp.lims.RefSampleComponent.SpecificLabelGroup')
          )

      serialDict = {}
      serialDict['isotopeLabels'] = 0
      dataDict['_serialDict'] = serialDict

      if (notIsReading):
        childrenDict = parent.__dict__.get('specificLabelGroups')
        objKey = dataDict.get('serial')
        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['serial'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notOverride):
        self.checkValid()

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for ccp.lims.RefSampleComponent.SpecificLabelGroup:
       
    determines cascading deletes to follow from delete of object.
       
    *Implementation function* - should be called only by API delete 
    function.
    """
    dataDict = self.__dict__
    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    isotopeLabels = dataDict.get('isotopeLabels').values()
    for isotopeLabel in isotopeLabels:
      if (not (isotopeLabel in objsToBeDeleted)):
        objsToBeDeleted.add(isotopeLabel)
        objsToBeChecked.append(isotopeLabel)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for ccp.lims.RefSampleComponent.SpecificLabelGroup:
    deletes objects
    *Implementation function* - will CORRUPT DATA if called 
    outside the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    molComponent = dataDict.get('molComponent')
    if (not (molComponent in objsToBeDeleted)):
      objKey = dataDict.get('serial')
      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = molComponent.__dict__.get('specificLabelGroups')
        if (self is dd.get(objKey)):
          del dd[objKey]

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData
  
  def checkAllValid(self, complete=False):
    """
    CheckAllValid for ccp.lims.RefSampleComponent.SpecificLabelGroup
    """
    dataDict = self.__dict__
    self.checkValid(complete)
    values = dataDict.get('isotopeLabels').values()
    for value in values:
      value.checkAllValid(complete)

  def checkValid(self, complete=False):
    """
    CheckValid for ccp.lims.RefSampleComponent.SpecificLabelGroup
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      objKey = dataDict.get('serial')
      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('molComponent')
        dd = value.__dict__.get('specificLabelGroups')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'molComponent' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      # check attributes
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('fraction')
      if (isinstance(value, memops.api.Implementation.Float.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Float.create(value)
      else:
        raise ApiError("""%s.checkValid: fraction:
         memops.Implementation.FloatRatio input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (0.0 <= value)):
        raise ApiError("""%s.checkValid: fraction:
         FloatRatio constraint value_ge_0 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value - value == 0.0)):
        raise ApiError("""%s.checkValid: fraction:
         FloatRatio constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value <= 1.0)):
        raise ApiError("""%s.checkValid: fraction:
         FloatRatio constraint value_le_1 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('serial')
      if (value is None):
        raise ApiError("""%s.checkValid: serial:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.checkValid: serial:
         memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      values = dataDict.get('isotopeLabels').values()
      for value in values:
        if (not isinstance(value, IsotopeLabel)):
          raise ApiError("""%s.checkValid: isotopeLabels:
           value is not of class ccp.lims.RefSampleComponent.IsotopeLabel""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('specificLabelGroup')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: isotopeLabels:
           non-reciprocal link isotopeLabels from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      value = dataDict.get('molComponent')
      if (not isinstance(value, MolComponent)):
        raise ApiError("""%s.checkValid: molComponent:
         value is not of class ccp.lims.RefSampleComponent.MolComponent""" % self.qualifiedName
         + ": %s" % (value,)
        )

    # check explicit class constraints
    # check attributes
    values = dataDict.get('applicationData')
    for value in values:
      value.checkAllValid(complete)

    value = dataDict.get('fraction')
    if (value is None):
      raise ApiError("""%s.checkValid: fraction:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    # check roles
    value = dataDict.get('access')
    values = dataDict.get('isotopeLabels').values()
    value = dataDict.get('molComponent')
    if (value is None):
      raise ApiError("""%s.checkValid: molComponent:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

  delete = memops.api.Implementation.DataObject.delete

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData
  
  def findAllIsotopeLabels(self, **conditions):
    """
    FindAll for ccp.lims.RefSampleComponent.SpecificLabelGroup.isotopeLabels
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('isotopeLabels').values()
      result = set(currentValues)

    else:
      currentValues = dataDict.get('isotopeLabels').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('elementSymbol', 'incorporation', 'massNumber', 'serial', 'access', 'specificLabelGroup',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData
  
  def findFirstIsotopeLabel(self, **conditions):
    """
    FindFirst for
    ccp.lims.RefSampleComponent.SpecificLabelGroup.isotopeLabels
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('isotopeLabels').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      objKey = conditions.get('serial')
      if (objKey is not None):
        result = dataDict.get('isotopeLabels').get(objKey)

        if (nConditions <= 1):
          return result

        elif (result is None):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        currentValues = dataDict.get('isotopeLabels').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('elementSymbol', 'incorporation', 'massNumber', 'serial', 'access', 'specificLabelGroup',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def get(self, name):
    """
    GetAttr for ccp.lims.RefSampleComponent.SpecificLabelGroup
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccp.lims.RefSampleComponent.SpecificLabelGroup
    """

    result = None
    if (startObj.__class__.__name__ == 'MemopsRoot'):
      if (3 != len(fullKey)):
        raise ApiError("""'ccp.lims.RefSampleComponent.SpecificLabelGroup'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj0 = startObj
      objKey = fullKey[0]
      obj1 = obj0.__dict__.get('refSampleComponentStores').get(objKey)
      if (obj1 is None):
        obj0.refreshTopObjects('ccp.lims.RefSampleComponent')
        obj1 = obj0.__dict__.get('refSampleComponentStores').get(objKey)

    else:
      if (2 != len(fullKey)):
        raise ApiError("""'ccp.lims.RefSampleComponent.SpecificLabelGroup'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj1 = startObj

    if (obj1 is not None):
      if (not (obj1.__dict__.get('isLoaded'))):
        obj1.load()

      objKey = fullKey[-2]
      obj2 = obj1.__dict__.get('components').get(objKey)

      if (obj2 is not None):
        objKey = fullKey[-1]
        obj3 = obj2.__dict__.get('specificLabelGroups').get(objKey)
        result = obj3

    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation

  getClassName = memops.api.Implementation.ComplexDataType.getClassName

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames
  
  def getFraction(self):
    """
    Get for ccp.lims.RefSampleComponent.SpecificLabelGroup.fraction
    """
    dataDict = self.__dict__
    result = dataDict.get('fraction')
    return result
  
  def getFullKey(self, useGuid=False):
    """
    GetFullKey for ccp.lims.RefSampleComponent.SpecificLabelGroup
    """
    dataDict = self.__dict__
    result = list()

    obj2 = dataDict.get('molComponent')
    obj1 = obj2.__dict__.get('refSampleComponentStore')

    if (useGuid):
      result.append(obj1.__dict__.get('guid'))
    else:
      result.append(obj1.__dict__.get('name'))

    result.append(obj2.__dict__.get('name'))
    result.append(dataDict.get('serial'))

    return result

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted
  
  def getIsotopeLabels(self):
    """
    Get for ccp.lims.RefSampleComponent.SpecificLabelGroup.isotopeLabels
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('isotopeLabels').values()
    result = frozenset(tempVar)
    return result
  
  def getLocalKey(self):
    """
    GetLocalKey for ccp.lims.RefSampleComponent.SpecificLabelGroup
    """
    dataDict = self.__dict__
    result = dataDict.get('serial')
    return result

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass
  
  def getMolComponent(self):
    """
    Get for ccp.lims.RefSampleComponent.SpecificLabelGroup.molComponent
    """
    dataDict = self.__dict__
    result = dataDict.get('molComponent')
    return result

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName
  
  def getParent(self):
    """
    Get for ccp.lims.RefSampleComponent.SpecificLabelGroup.parent
    """
    dataDict = self.__dict__
    result = dataDict.get('molComponent')
    return result

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName

  getRoot = memops.api.Implementation.MemopsObject.getRoot
  
  def getSerial(self):
    """
    Get for ccp.lims.RefSampleComponent.SpecificLabelGroup.serial
    """
    dataDict = self.__dict__
    result = dataDict.get('serial')
    return result

  getTopObject = memops.api.Implementation.DataObject.getTopObject
  
  def newIsotopeLabel(self, **attrlinks):
    """
    Factory function to create ccp.lims.RefSampleComponent.IsotopeLabel
    """
    return IsotopeLabel(self, **attrlinks)

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData
  
  def set(self, name, value):
    """
    SetAttr for ccp.lims.RefSampleComponent.SpecificLabelGroup
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData
  
  def setFraction(self, value):
    """
    Set for ccp.lims.RefSampleComponent.SpecificLabelGroup.fraction
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Float.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Float.create(value)
    else:
      raise ApiError("""%s.setFraction:
       memops.Implementation.FloatRatio input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (0.0 <= value)):
      raise ApiError("""%s.setFraction:
       FloatRatio constraint value_ge_0 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value - value == 0.0)):
      raise ApiError("""%s.setFraction:
       FloatRatio constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value <= 1.0)):
      raise ApiError("""%s.setFraction:
       FloatRatio constraint value_le_1 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('fraction')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setFraction:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setFraction:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setFraction:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['fraction'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setFraction')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setSerial(self, value):
    """
    Set for ccp.lims.RefSampleComponent.SpecificLabelGroup.serial
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Int.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Int.create(value)
    else:
      raise ApiError("""%s.setSerial:
       memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('serial')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setSerial:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setSerial:
         cannot set serial, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setSerial:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    parent = dataDict.get('molComponent')
    oldSerial = parent.__dict__.get('_serialDict').get('specificLabelGroups')
    if (value < 0):
      value = (oldSerial + 1)
      parent.__dict__.get('_serialDict')['specificLabelGroups'] = value
    elif (value > oldSerial):
      parent.__dict__.get('_serialDict')['specificLabelGroups'] = value

    dataDict['serial'] = value

    # doNotifies
  
  def sortedIsotopeLabels(self):
    """
    Sorted for ccp.lims.RefSampleComponent.SpecificLabelGroup.isotopeLabels
    """
    dataDict = self.__dict__
    sortdd = dataDict.get('isotopeLabels')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  applicationData = memops.api.Implementation.DataObject.applicationData

  className = memops.api.Implementation.ComplexDataType.className

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames
  
  fraction = property(getFraction, setFraction, None,
  r"""Fraction of the molecules that are labeled with the labeing pattern 
  defined by the SpecificLabelGroup. If the fraction attributes of the 
  various specificLabelGroups do not add up to 100%, the remainder of the 
  molecules in the group are assumed to be at natural abundance.
  """)

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted

  metaclass = memops.api.Implementation.ComplexDataType.metaclass

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName
  
  serial = property(getSerial, setSerial, None,
  r"""Serial number of object. Serves as object main key. Serial numbers of 
  deleted objects are not re-used. Serial numbers can only be set by the 
  implementation. Values are in practice always positive, since negative 
  values are interpreted as a signal to set the next free serial
  """)

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess
  
  isotopeLabels = property(getIsotopeLabels,  None, None,
  r"""child link to class IsotopeLabel
  """)
  
  molComponent = property(getMolComponent,  None, None,
  r"""parent link
  """)
  
  parent = property(getParent, None, None,
  r"""link to parent object - synonym for molComponent
  """)

  root = memops.api.Implementation.MemopsObject.root

  topObject = memops.api.Implementation.DataObject.topObject

###############################################################################
class MolComponent(AbstractComponent):
  r"""One type of component. A Molecular component (MolComponent) represents a 
pure component of known melecular structure. This includes most 
chemicals, proteins, DNA, RNA, DNA/RNA and also enzymes, constructs and 
primers. Restriction enzymes, primers and constructs are subtypes of 
MolCOmponent with additional features recorded. NaCl is a MolComponent, 
so is lysozyme.
  """
  #   from data model element ccp.lims.RefSampleComponent.MolComponent revision ?
  _metaclass = metaPackage.getElement('MolComponent')
  _packageName = 'ccp.lims.RefSampleComponent'
  _packageShortName = 'REFS'
  _fieldNames = ('applicationData', 'casNum', 'className', 'details', 'empiricalFormula', 'fieldNames', 'inConstructor', 'isDeleted', 'metaclass', 'molType', 'molecularMass', 'name', 'packageName', 'packageShortName', 'qualifiedName', 'seqDetails', 'seqString', 'synonyms', 'access', 'activeAccess', 'blueprintComponents', 'categories', 'componentDbRefs', 'compositeElements', 'labeledMixture', 'labels', 'molCompFeatures', 'molecule', 'naturalSource', 'nucTargets', 'parent', 'protTargets', 'refMolCompFeatures', 'refSampleComponentStore', 'relatedExpBlueprints', 'root', 'specificLabelGroups', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for ccp.lims.RefSampleComponent.MolComponent
    """
    dataDict = self.__dict__
    dataDict['refSampleComponentStore'] = parent
    if (not isinstance(parent, RefSampleComponentStore)):
      raise ApiError("""%s.__init__:
       value is not of class ccp.lims.RefSampleComponent.RefSampleComponentStore""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = parent.__dict__.get('topObject')
    dataDict['topObject'] = topObject

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    if (notIsReading):
      if (not (topObject.__dict__.get('isModifiable'))):
        raise ApiError("""%s.__init__:
         Storage not modifiable""" % self.qualifiedName
         + ": %s" % (topObject,)
        )

    try:
      if (not ((parent.__dict__.get('isLoaded') or parent.__dict__.get('isReading')))):
        parent.load()

      dataDict['applicationData'] = list()
      dataDict['casNum'] = None
      dataDict['details'] = None
      dataDict['empiricalFormula'] = None
      dataDict['molType'] = None
      dataDict['molecularMass'] = None
      dataDict['name'] = None
      dataDict['seqDetails'] = None
      dataDict['seqString'] = None
      dataDict['synonyms'] = list()
      dataDict['access'] = None
      dataDict['blueprintComponents'] = set()
      dataDict['categories'] = set()
      dataDict['componentDbRefs'] = {}
      dataDict['compositeElements'] = set()
      dataDict['labeledMixture'] = None
      dataDict['labels'] = {}
      dataDict['molCompFeatures'] = {}
      dataDict['molecule'] = None
      dataDict['naturalSource'] = None
      dataDict['nucTargets'] = set()
      dataDict['protTargets'] = set()
      dataDict['refMolCompFeatures'] = set()
      dataDict['relatedExpBlueprints'] = set()
      dataDict['specificLabelGroups'] = {}

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in ccp.lims.RefSampleComponent.MolComponent.__init__"
        del dataDict['inConstructor']
        raise

      serialDict = {}
      serialDict['componentDbRefs'] = 0
      serialDict['labels'] = 0
      serialDict['molCompFeatures'] = 0
      serialDict['specificLabelGroups'] = 0
      dataDict['_serialDict'] = serialDict

      if (notIsReading):
        childrenDict = parent.__dict__.get('components')
        objKey = dataDict.get('name')
        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['name'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notOverride):
        self.checkValid()

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for ccp.lims.RefSampleComponent.MolComponent:
       determines 
    cascading deletes to follow from delete of object.
       *Implementation 
    function* - should be called only by API delete function.
    """
    dataDict = self.__dict__
    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.lims.ExpBlueprint')
    tobjList = root.__dict__.get('expBlueprintStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    blueprintComponents = dataDict.get('blueprintComponents')
    pass
    for blueprintComponent in blueprintComponents:
      topObject = blueprintComponent.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    categories = dataDict.get('categories')
    pass
    for category in categories:
      topObject = category.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    componentDbRefs = dataDict.get('componentDbRefs').values()
    for componentDbRef in componentDbRefs:
      if (not (componentDbRef in objsToBeDeleted)):
        objsToBeDeleted.add(componentDbRef)
        objsToBeChecked.append(componentDbRef)

    compositeElements = dataDict.get('compositeElements')
    for compositeElement in compositeElements:
      if (not (compositeElement in objsToBeDeleted)):
        objsToBeDeleted.add(compositeElement)
        objsToBeChecked.append(compositeElement)

    labeledMixture = dataDict.get('labeledMixture')
    if (labeledMixture is not None):
      topObject = labeledMixture.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    labels = dataDict.get('labels').values()
    for label in labels:
      if (not (label in objsToBeDeleted)):
        objsToBeDeleted.add(label)
        objsToBeChecked.append(label)

    molCompFeatures = dataDict.get('molCompFeatures').values()
    for molCompFeature in molCompFeatures:
      if (not (molCompFeature in objsToBeDeleted)):
        objsToBeDeleted.add(molCompFeature)
        objsToBeChecked.append(molCompFeature)

    molecule = dataDict.get('molecule')
    if (molecule is not None):
      topObject = molecule.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.lims.Target')
    tobjList = root.__dict__.get('targetStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    nucTargets = dataDict.get('nucTargets')
    pass
    for nucTarget in nucTargets:
      topObject = nucTarget.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.lims.Target')
    tobjList = root.__dict__.get('targetStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    protTargets = dataDict.get('protTargets')
    for protTarget in protTargets:
      if (not (protTarget in objsToBeDeleted)):
        objsToBeDeleted.add(protTarget)
        objsToBeChecked.append(protTarget)

    for protTarget in protTargets:
      topObject = protTarget.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.lims.ExpBlueprint')
    tobjList = root.__dict__.get('expBlueprintStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    relatedExpBlueprints = dataDict.get('relatedExpBlueprints')
    pass
    for relatedExpBlueprint in relatedExpBlueprints:
      topObject = relatedExpBlueprint.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    specificLabelGroups = dataDict.get('specificLabelGroups').values()
    for specificLabelGroup in specificLabelGroups:
      if (not (specificLabelGroup in objsToBeDeleted)):
        objsToBeDeleted.add(specificLabelGroup)
        objsToBeChecked.append(specificLabelGroup)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for ccp.lims.RefSampleComponent.MolComponent:   deletes
    objects
    *Implementation function* - will CORRUPT DATA if called outside 
    the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    for blueprintComponent in dataDict.get('blueprintComponents'):
      if (not (blueprintComponent in objsToBeDeleted)):
        blueprintComponent.__dict__['molComponent'] = None

    for category in dataDict.get('categories'):
      if (not (category in objsToBeDeleted)):
        components = category.__dict__.get('components')
        components.remove(self)

    labeledMixture = dataDict.get('labeledMixture')
    if ((labeledMixture is not None and not (labeledMixture in objsToBeDeleted))):
      molComponents = labeledMixture.__dict__.get('molComponents')
      molComponents.remove(self)

    molecule = dataDict.get('molecule')
    if ((molecule is not None and not (molecule in objsToBeDeleted))):
      molComponents = molecule.__dict__.get('molComponents')
      molComponents.remove(self)

    for nucTarget in dataDict.get('nucTargets'):
      if (not (nucTarget in objsToBeDeleted)):
        nucleicAcids = nucTarget.__dict__.get('nucleicAcids')
        nucleicAcids.remove(self)

    for refMolCompFeature in dataDict.get('refMolCompFeatures'):
      if (not (refMolCompFeature in objsToBeDeleted)):
        refMolCompFeature.__dict__['refMolComponent'] = None

    for relatedExpBlueprint in dataDict.get('relatedExpBlueprints'):
      if (not (relatedExpBlueprint in objsToBeDeleted)):
        trialMolComponents = relatedExpBlueprint.__dict__.get('trialMolComponents')
        trialMolComponents.remove(self)

    refSampleComponentStore = dataDict.get('refSampleComponentStore')
    if (not (refSampleComponentStore in objsToBeDeleted)):
      objKey = dataDict.get('name')
      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = refSampleComponentStore.__dict__.get('components')
        if (self is dd.get(objKey)):
          del dd[objKey]

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData
  
  def addBlueprintComponent(self, value):
    """
    Add for ccp.lims.RefSampleComponent.MolComponent.blueprintComponents
    """
    dataDict = self.__dict__
    from ccp.api.lims.ExpBlueprint import BlueprintComponent as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.addBlueprintComponent:
       value is not of class ccp.lims.ExpBlueprint.BlueprintComponent""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.lims.ExpBlueprint')
    tobjList = root.__dict__.get('expBlueprintStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    currentValues = dataDict.get('blueprintComponents')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      topObject = value.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)
      oldSelf = value.__dict__.get('molComponent')
      if (oldSelf is not None):
        topObject = oldSelf.__dict__.get('topObject')
        topObjectsToCheck.add(topObject)

      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.addBlueprintComponent:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.addBlueprintComponent:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.addBlueprintComponent:
       called with deleted value""" % self.qualifiedName
      )

    if (value in currentValues):
      raise ApiError("""%s.addBlueprintComponent:
       value is in list already""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.addBlueprintComponent:
           Link blueprintComponents between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    oldSelf = value.__dict__.get('molComponent')
    if (oldSelf is not None):
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.lims.ExpBlueprint')
      tobjList = root.__dict__.get('expBlueprintStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      siblingValues = oldSelf.__dict__.get('blueprintComponents')
      siblingValues.remove(value)

    value.__dict__['molComponent'] = self
    currentValues.add(value)
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('addBlueprintComponent')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  addCategory = AbstractComponent.addCategory
  
  def addNucTarget(self, value):
    """
    Add for ccp.lims.RefSampleComponent.MolComponent.nucTargets
    """
    dataDict = self.__dict__
    from ccp.api.lims.Target import Target as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.addNucTarget:
       value is not of class ccp.lims.Target.Target""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.lims.Target')
    tobjList = root.__dict__.get('targetStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    currentValues = dataDict.get('nucTargets')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      topObject = value.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)
      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.addNucTarget:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.addNucTarget:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.addNucTarget:
       called with deleted value""" % self.qualifiedName
      )

    if (value in currentValues):
      raise ApiError("""%s.addNucTarget:
       value is in list already""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.addNucTarget:
           Link nucTargets between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    oldSelves = value.__dict__.get('nucleicAcids')
    oldSelves.add(self)
    currentValues.add(value)
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('addNucTarget')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def addRefMolCompFeature(self, value):
    """
    Add for ccp.lims.RefSampleComponent.MolComponent.refMolCompFeatures
    """
    dataDict = self.__dict__
    if (not isinstance(value, MolCompFeature)):
      raise ApiError("""%s.addRefMolCompFeature:
       value is not of class ccp.lims.RefSampleComponent.MolCompFeature""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('refMolCompFeatures')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.addRefMolCompFeature:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.addRefMolCompFeature:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.addRefMolCompFeature:
       called with deleted value""" % self.qualifiedName
      )

    if (value in currentValues):
      raise ApiError("""%s.addRefMolCompFeature:
       value is in list already""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.addRefMolCompFeature:
           Link refMolCompFeatures between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    oldSelf = value.__dict__.get('refMolComponent')
    if (oldSelf is not None):
      siblingValues = oldSelf.__dict__.get('refMolCompFeatures')
      siblingValues.remove(value)

    value.__dict__['refMolComponent'] = self
    currentValues.add(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('addRefMolCompFeature')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def addRelatedExpBlueprint(self, value):
    """
    Add for ccp.lims.RefSampleComponent.MolComponent.relatedExpBlueprints
    """
    dataDict = self.__dict__
    from ccp.api.lims.ExpBlueprint import BlueprintComponent as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.addRelatedExpBlueprint:
       value is not of class ccp.lims.ExpBlueprint.BlueprintComponent""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.lims.ExpBlueprint')
    tobjList = root.__dict__.get('expBlueprintStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    currentValues = dataDict.get('relatedExpBlueprints')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      topObject = value.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)
      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.addRelatedExpBlueprint:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.addRelatedExpBlueprint:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.addRelatedExpBlueprint:
       called with deleted value""" % self.qualifiedName
      )

    if (value in currentValues):
      raise ApiError("""%s.addRelatedExpBlueprint:
       value is in list already""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.addRelatedExpBlueprint:
           Link relatedExpBlueprints between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    oldSelves = value.__dict__.get('trialMolComponents')
    oldSelves.add(self)
    currentValues.add(value)
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('addRelatedExpBlueprint')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  addSynonym = AbstractComponent.addSynonym
  
  def checkAllValid(self, complete=False):
    """
    CheckAllValid for ccp.lims.RefSampleComponent.MolComponent
    """
    dataDict = self.__dict__
    self.checkValid(complete)
    values = dataDict.get('componentDbRefs').values()
    for value in values:
      value.checkAllValid(complete)

    values = dataDict.get('labels').values()
    for value in values:
      value.checkAllValid(complete)

    values = dataDict.get('molCompFeatures').values()
    for value in values:
      value.checkAllValid(complete)

    values = dataDict.get('specificLabelGroups').values()
    for value in values:
      value.checkAllValid(complete)

  def checkValid(self, complete=False):
    """
    CheckValid for ccp.lims.RefSampleComponent.MolComponent
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      objKey = dataDict.get('name')
      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('refSampleComponentStore')
        dd = value.__dict__.get('components')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'refSampleComponentStore' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      # check attributes
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('casNum')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: casNum:
           memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 32):
          raise ApiError("""%s.checkValid: casNum:
           memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: casNum:
           memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.split()) == 1)):
          raise ApiError("""%s.checkValid: casNum:
           Word constraint contains_no_white_space violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('details')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: details:
           memops.Implementation.String input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('empiricalFormula')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: empiricalFormula:
           memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: empiricalFormula:
           memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: empiricalFormula:
           memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: empiricalFormula:
           Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('molType')
      if (value is not None):
        if (not (value in ['protein', 'DNA', 'RNA', 'DNA/RNA', 'carbohydrate', 'other'])):
          raise ApiError("""%s.checkValid: molType:
           ccp.molecule.Molecule.MolType input is not in enumeration ['protein', 'DNA', 'RNA', 'DNA/RNA', 'carbohydrate', 'other']""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: molType:
           MolType constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('molecularMass')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.Float.PythonType)):
          pass
        elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
          value = memops.api.Implementation.Float.create(value)
        else:
          raise ApiError("""%s.checkValid: molecularMass:
           memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (value - value == 0.0)):
          raise ApiError("""%s.checkValid: molecularMass:
           Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('name')
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: name:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: name:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: name:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: name:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('seqDetails')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: seqDetails:
           memops.Implementation.String input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('seqString')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: seqString:
           memops.Implementation.String input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

      values = dataDict.get('synonyms')
      for value in values:
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: synonyms:
           memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: synonyms:
           memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: synonyms:
           memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: synonyms:
           Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.lims.ExpBlueprint')
      tobjList = root.__dict__.get('expBlueprintStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      values = dataDict.get('blueprintComponents')
      for value in values:
        from ccp.api.lims.ExpBlueprint import BlueprintComponent as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: blueprintComponents:
           value is not of class ccp.lims.ExpBlueprint.BlueprintComponent""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('molComponent')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: blueprintComponents:
           non-reciprocal link blueprintComponents from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: blueprintComponents:
           Link blueprintComponents between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      values = dataDict.get('categories')
      for value in values:
        from ccp.api.lims.Classification import SampleComponentCategory as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: categories:
           value is not of class ccp.lims.Classification.SampleComponentCategory""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('components')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: categories:
           non-reciprocal link categories from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: categories:
           Link categories between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      values = dataDict.get('componentDbRefs').values()
      for value in values:
        if (not isinstance(value, ComponentDbRef)):
          raise ApiError("""%s.checkValid: componentDbRefs:
           value is not of class ccp.lims.RefSampleComponent.ComponentDbRef""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('component')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: componentDbRefs:
           non-reciprocal link componentDbRefs from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      values = dataDict.get('compositeElements')
      for value in values:
        if (not isinstance(value, CompositeElement)):
          raise ApiError("""%s.checkValid: compositeElements:
           value is not of class ccp.lims.RefSampleComponent.CompositeElement""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('component')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: compositeElements:
           non-reciprocal link compositeElements from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: compositeElements:
           Link compositeElements between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('labeledMixture')
      if (value is not None):
        from ccp.api.molecule.LabeledMolecule import LabeledMixture as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: labeledMixture:
           value is not of class ccp.molecule.LabeledMolecule.LabeledMixture""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('molComponents')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: labeledMixture:
           non-reciprocal link labeledMixture from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      values = dataDict.get('labels').values()
      for value in values:
        if (not isinstance(value, Label)):
          raise ApiError("""%s.checkValid: labels:
           value is not of class ccp.lims.RefSampleComponent.Label""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('component')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: labels:
           non-reciprocal link labels from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      values = dataDict.get('molCompFeatures').values()
      for value in values:
        if (not isinstance(value, MolCompFeature)):
          raise ApiError("""%s.checkValid: molCompFeatures:
           value is not of class ccp.lims.RefSampleComponent.MolCompFeature""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('molComponent')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: molCompFeatures:
           non-reciprocal link molCompFeatures from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      value = dataDict.get('molecule')
      if (value is not None):
        from ccp.api.molecule.Molecule import Molecule as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: molecule:
           value is not of class ccp.molecule.Molecule.Molecule""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('molComponents')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: molecule:
           non-reciprocal link molecule from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      value = dataDict.get('naturalSource')
      if (value is not None):
        from ccp.api.general.Taxonomy import NaturalSource as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: naturalSource:
           value is not of class ccp.general.Taxonomy.NaturalSource""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: naturalSource:
           Link naturalSource between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.lims.Target')
      tobjList = root.__dict__.get('targetStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      values = dataDict.get('nucTargets')
      for value in values:
        from ccp.api.lims.Target import Target as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: nucTargets:
           value is not of class ccp.lims.Target.Target""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('nucleicAcids')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: nucTargets:
           non-reciprocal link nucTargets from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: nucTargets:
           Link nucTargets between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.lims.Target')
      tobjList = root.__dict__.get('targetStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      values = dataDict.get('protTargets')
      for value in values:
        from ccp.api.lims.Target import Target as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: protTargets:
           value is not of class ccp.lims.Target.Target""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('protein')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: protTargets:
           non-reciprocal link protTargets from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: protTargets:
           Link protTargets between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      values = dataDict.get('refMolCompFeatures')
      for value in values:
        if (not isinstance(value, MolCompFeature)):
          raise ApiError("""%s.checkValid: refMolCompFeatures:
           value is not of class ccp.lims.RefSampleComponent.MolCompFeature""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('refMolComponent')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: refMolCompFeatures:
           non-reciprocal link refMolCompFeatures from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: refMolCompFeatures:
           Link refMolCompFeatures between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('refSampleComponentStore')
      if (not isinstance(value, RefSampleComponentStore)):
        raise ApiError("""%s.checkValid: refSampleComponentStore:
         value is not of class ccp.lims.RefSampleComponent.RefSampleComponentStore""" % self.qualifiedName
         + ": %s" % (value,)
        )

      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.lims.ExpBlueprint')
      tobjList = root.__dict__.get('expBlueprintStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      values = dataDict.get('relatedExpBlueprints')
      for value in values:
        from ccp.api.lims.ExpBlueprint import BlueprintComponent as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: relatedExpBlueprints:
           value is not of class ccp.lims.ExpBlueprint.BlueprintComponent""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('trialMolComponents')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: relatedExpBlueprints:
           non-reciprocal link relatedExpBlueprints from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: relatedExpBlueprints:
           Link relatedExpBlueprints between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      values = dataDict.get('specificLabelGroups').values()
      for value in values:
        if (not isinstance(value, SpecificLabelGroup)):
          raise ApiError("""%s.checkValid: specificLabelGroups:
           value is not of class ccp.lims.RefSampleComponent.SpecificLabelGroup""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('molComponent')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: specificLabelGroups:
           non-reciprocal link specificLabelGroups from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

    # check explicit class constraints
    if (not (reduce(operator.add, [x.fraction for x in self.specificLabelGroups], 0) <= 1.0)):
      raise ApiError("""%s.checkValid:
       constraint SpecificLabelGroups_add_up_to_less_than_1 violated""" % self.qualifiedName
       + ": %s" % (self,)
      )

    # check attributes
    values = dataDict.get('applicationData')
    for value in values:
      value.checkAllValid(complete)

    value = dataDict.get('casNum')
    value = dataDict.get('details')
    value = dataDict.get('empiricalFormula')
    value = dataDict.get('molType')
    value = dataDict.get('molecularMass')
    value = dataDict.get('name')
    if (value is None):
      raise ApiError("""%s.checkValid: name:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('seqDetails')
    value = dataDict.get('seqString')
    values = dataDict.get('synonyms')
    # check roles
    value = dataDict.get('access')
    values = dataDict.get('blueprintComponents')
    values = dataDict.get('categories')
    values = dataDict.get('componentDbRefs').values()
    values = dataDict.get('compositeElements')
    value = dataDict.get('labeledMixture')
    values = dataDict.get('labels').values()
    values = dataDict.get('molCompFeatures').values()
    value = dataDict.get('molecule')
    if (value is not None):
      if (not (value.isFinalised)):
        raise ApiError("""%s.checkValid: molecule:
         molecule constraint Molecule_must_be_finalised violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    value = dataDict.get('naturalSource')
    values = dataDict.get('nucTargets')
    values = dataDict.get('protTargets')
    values = dataDict.get('refMolCompFeatures')
    value = dataDict.get('refSampleComponentStore')
    if (value is None):
      raise ApiError("""%s.checkValid: refSampleComponentStore:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    values = dataDict.get('relatedExpBlueprints')
    values = dataDict.get('specificLabelGroups').values()

  delete = memops.api.Implementation.DataObject.delete

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData
  
  def findAllBlueprintComponents(self, **conditions):
    """
    FindAll for ccp.lims.RefSampleComponent.MolComponent.blueprintComponents
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.lims.ExpBlueprint')
      tobjList = root.__dict__.get('expBlueprintStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('blueprintComponents')
      result = set(currentValues)

    else:
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.lims.ExpBlueprint')
      tobjList = root.__dict__.get('expBlueprintStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('blueprintComponents')
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('alwaysIncluded', 'approxBeginSeqId', 'approxEndSeqId', 'componentType', 'details', 'domain', 'serial', 'status', 'whyChosen', 'access', 'expBlueprint', 'molComponent', 'target',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result

  findAllCategories = AbstractComponent.findAllCategories

  findAllComponentDbRefs = AbstractComponent.findAllComponentDbRefs

  findAllCompositeElements = AbstractComponent.findAllCompositeElements

  findAllLabels = AbstractComponent.findAllLabels
  
  def findAllMolCompFeatures(self, **conditions):
    """
    FindAll for ccp.lims.RefSampleComponent.MolComponent.molCompFeatures
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('molCompFeatures').values()
      result = set(currentValues)

    else:
      currentValues = dataDict.get('molCompFeatures').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('details', 'endSeqId', 'featureType', 'name', 'ordering', 'serial', 'startSeqId', 'status', 'access', 'molComponent', 'refMolComponent',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllNucTargets(self, **conditions):
    """
    FindAll for ccp.lims.RefSampleComponent.MolComponent.nucTargets
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.lims.Target')
      tobjList = root.__dict__.get('targetStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('nucTargets')
      result = set(currentValues)

    else:
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.lims.Target')
      tobjList = root.__dict__.get('targetStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('nucTargets')
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('biochemicalFunction', 'biologicalProcess', 'catalyticActivity', 'cellLocation', 'commonName', 'details', 'functionDescription', 'geneName', 'localName', 'orf', 'pathway', 'proteinName', 'serial', 'similarityDetails', 'systematicName', 'topology', 'whyChosen', 'access', 'creator', 'protein', 'species', 'targetStore',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllProtTargets(self, **conditions):
    """
    FindAll for ccp.lims.RefSampleComponent.MolComponent.protTargets
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.lims.Target')
      tobjList = root.__dict__.get('targetStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('protTargets')
      result = set(currentValues)

    else:
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.lims.Target')
      tobjList = root.__dict__.get('targetStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('protTargets')
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('biochemicalFunction', 'biologicalProcess', 'catalyticActivity', 'cellLocation', 'commonName', 'details', 'functionDescription', 'geneName', 'localName', 'orf', 'pathway', 'proteinName', 'serial', 'similarityDetails', 'systematicName', 'topology', 'whyChosen', 'access', 'creator', 'protein', 'species', 'targetStore',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllRefMolCompFeatures(self, **conditions):
    """
    FindAll for ccp.lims.RefSampleComponent.MolComponent.refMolCompFeatures
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('refMolCompFeatures')
      result = set(currentValues)

    else:
      currentValues = dataDict.get('refMolCompFeatures')
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('details', 'endSeqId', 'featureType', 'name', 'ordering', 'serial', 'startSeqId', 'status', 'access', 'molComponent', 'refMolComponent',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllRelatedExpBlueprints(self, **conditions):
    """
    FindAll for
    ccp.lims.RefSampleComponent.MolComponent.relatedExpBlueprints
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.lims.ExpBlueprint')
      tobjList = root.__dict__.get('expBlueprintStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('relatedExpBlueprints')
      result = set(currentValues)

    else:
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.lims.ExpBlueprint')
      tobjList = root.__dict__.get('expBlueprintStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('relatedExpBlueprints')
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('alwaysIncluded', 'approxBeginSeqId', 'approxEndSeqId', 'componentType', 'details', 'domain', 'serial', 'status', 'whyChosen', 'access', 'expBlueprint', 'molComponent', 'target',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllSpecificLabelGroups(self, **conditions):
    """
    FindAll for ccp.lims.RefSampleComponent.MolComponent.specificLabelGroups
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('specificLabelGroups').values()
      result = set(currentValues)

    else:
      currentValues = dataDict.get('specificLabelGroups').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('fraction', 'serial', 'access', 'molComponent',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData
  
  def findFirstBlueprintComponent(self, **conditions):
    """
    FindFirst for
    ccp.lims.RefSampleComponent.MolComponent.blueprintComponents
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.lims.ExpBlueprint')
      tobjList = root.__dict__.get('expBlueprintStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('blueprintComponents')
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.lims.ExpBlueprint')
      tobjList = root.__dict__.get('expBlueprintStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('blueprintComponents')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('alwaysIncluded', 'approxBeginSeqId', 'approxEndSeqId', 'componentType', 'details', 'domain', 'serial', 'status', 'whyChosen', 'access', 'expBlueprint', 'molComponent', 'target',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result

  findFirstCategory = AbstractComponent.findFirstCategory

  findFirstComponentDbRef = AbstractComponent.findFirstComponentDbRef

  findFirstCompositeElement = AbstractComponent.findFirstCompositeElement

  findFirstLabel = AbstractComponent.findFirstLabel
  
  def findFirstMolCompFeature(self, **conditions):
    """
    FindFirst for ccp.lims.RefSampleComponent.MolComponent.molCompFeatures
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('molCompFeatures').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      objKey = conditions.get('serial')
      if (objKey is not None):
        result = dataDict.get('molCompFeatures').get(objKey)

        if (nConditions <= 1):
          return result

        elif (result is None):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        currentValues = dataDict.get('molCompFeatures').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('details', 'endSeqId', 'featureType', 'name', 'ordering', 'serial', 'startSeqId', 'status', 'access', 'molComponent', 'refMolComponent',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstNucTarget(self, **conditions):
    """
    FindFirst for ccp.lims.RefSampleComponent.MolComponent.nucTargets
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.lims.Target')
      tobjList = root.__dict__.get('targetStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('nucTargets')
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.lims.Target')
      tobjList = root.__dict__.get('targetStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('nucTargets')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('biochemicalFunction', 'biologicalProcess', 'catalyticActivity', 'cellLocation', 'commonName', 'details', 'functionDescription', 'geneName', 'localName', 'orf', 'pathway', 'proteinName', 'serial', 'similarityDetails', 'systematicName', 'topology', 'whyChosen', 'access', 'creator', 'protein', 'species', 'targetStore',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstProtTarget(self, **conditions):
    """
    FindFirst for ccp.lims.RefSampleComponent.MolComponent.protTargets
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.lims.Target')
      tobjList = root.__dict__.get('targetStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('protTargets')
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.lims.Target')
      tobjList = root.__dict__.get('targetStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('protTargets')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('biochemicalFunction', 'biologicalProcess', 'catalyticActivity', 'cellLocation', 'commonName', 'details', 'functionDescription', 'geneName', 'localName', 'orf', 'pathway', 'proteinName', 'serial', 'similarityDetails', 'systematicName', 'topology', 'whyChosen', 'access', 'creator', 'protein', 'species', 'targetStore',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstRefMolCompFeature(self, **conditions):
    """
    FindFirst for
    ccp.lims.RefSampleComponent.MolComponent.refMolCompFeatures
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('refMolCompFeatures')
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      currentValues = dataDict.get('refMolCompFeatures')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('details', 'endSeqId', 'featureType', 'name', 'ordering', 'serial', 'startSeqId', 'status', 'access', 'molComponent', 'refMolComponent',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstRelatedExpBlueprint(self, **conditions):
    """
    FindFirst for
    ccp.lims.RefSampleComponent.MolComponent.relatedExpBlueprints
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.lims.ExpBlueprint')
      tobjList = root.__dict__.get('expBlueprintStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('relatedExpBlueprints')
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.lims.ExpBlueprint')
      tobjList = root.__dict__.get('expBlueprintStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('relatedExpBlueprints')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('alwaysIncluded', 'approxBeginSeqId', 'approxEndSeqId', 'componentType', 'details', 'domain', 'serial', 'status', 'whyChosen', 'access', 'expBlueprint', 'molComponent', 'target',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstSpecificLabelGroup(self, **conditions):
    """
    FindFirst for
    ccp.lims.RefSampleComponent.MolComponent.specificLabelGroups
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('specificLabelGroups').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      objKey = conditions.get('serial')
      if (objKey is not None):
        result = dataDict.get('specificLabelGroups').get(objKey)

        if (nConditions <= 1):
          return result

        elif (result is None):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        currentValues = dataDict.get('specificLabelGroups').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('fraction', 'serial', 'access', 'molComponent',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def get(self, name):
    """
    GetAttr for ccp.lims.RefSampleComponent.MolComponent
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getBlueprintComponents(self):
    """
    Get for ccp.lims.RefSampleComponent.MolComponent.blueprintComponents
    """
    dataDict = self.__dict__
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.lims.ExpBlueprint')
    tobjList = root.__dict__.get('expBlueprintStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    tempVar = dataDict.get('blueprintComponents')
    result = frozenset(tempVar)
    return result
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccp.lims.RefSampleComponent.MolComponent
    """

    result = None
    if (startObj.__class__.__name__ == 'MemopsRoot'):
      if (2 != len(fullKey)):
        raise ApiError("""'ccp.lims.RefSampleComponent.MolComponent'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj0 = startObj
      objKey = fullKey[0]
      obj1 = obj0.__dict__.get('refSampleComponentStores').get(objKey)
      if (obj1 is None):
        obj0.refreshTopObjects('ccp.lims.RefSampleComponent')
        obj1 = obj0.__dict__.get('refSampleComponentStores').get(objKey)

    else:
      if (1 != len(fullKey)):
        raise ApiError("""'ccp.lims.RefSampleComponent.MolComponent'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj1 = startObj

    if (obj1 is not None):
      if (not (obj1.__dict__.get('isLoaded'))):
        obj1.load()

      objKey = fullKey[-1]
      obj2 = obj1.__dict__.get('components').get(objKey)
      if (isinstance(obj2, MolComponent)):
        result = obj2

    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation
  
  def getCasNum(self):
    """
    Get for ccp.lims.RefSampleComponent.MolComponent.casNum
    """
    dataDict = self.__dict__
    result = dataDict.get('casNum')
    return result

  getCategories = AbstractComponent.getCategories

  getClassName = memops.api.Implementation.ComplexDataType.getClassName

  getComponentDbRefs = AbstractComponent.getComponentDbRefs

  getCompositeElements = AbstractComponent.getCompositeElements

  getDetails = AbstractComponent.getDetails
  
  def getEmpiricalFormula(self):
    """
    Get for ccp.lims.RefSampleComponent.MolComponent.empiricalFormula
    """
    dataDict = self.__dict__
    result = dataDict.get('empiricalFormula')
    return result

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames

  getFullKey = AbstractComponent.getFullKey

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted
  
  def getLabeledMixture(self):
    """
    Get for ccp.lims.RefSampleComponent.MolComponent.labeledMixture
    """
    dataDict = self.__dict__
    result = dataDict.get('labeledMixture')
    return result

  getLabels = AbstractComponent.getLabels

  getLocalKey = AbstractComponent.getLocalKey

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass
  
  def getMolCompFeatures(self):
    """
    Get for ccp.lims.RefSampleComponent.MolComponent.molCompFeatures
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('molCompFeatures').values()
    result = frozenset(tempVar)
    return result
  
  def getMolType(self):
    """
    Get for ccp.lims.RefSampleComponent.MolComponent.molType
    """
    dataDict = self.__dict__
    result = dataDict.get('molType')
    return result
  
  def getMolecularMass(self):
    """
    Get for ccp.lims.RefSampleComponent.MolComponent.molecularMass
    """
    dataDict = self.__dict__
    result = dataDict.get('molecularMass')
    return result
  
  def getMolecule(self):
    """
    Get for ccp.lims.RefSampleComponent.MolComponent.molecule
    """
    dataDict = self.__dict__
    result = dataDict.get('molecule')
    return result

  getName = AbstractComponent.getName

  getNaturalSource = AbstractComponent.getNaturalSource
  
  def getNucTargets(self):
    """
    Get for ccp.lims.RefSampleComponent.MolComponent.nucTargets
    """
    dataDict = self.__dict__
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.lims.Target')
    tobjList = root.__dict__.get('targetStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    tempVar = dataDict.get('nucTargets')
    result = frozenset(tempVar)
    return result

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName

  getParent = AbstractComponent.getParent
  
  def getProtTargets(self):
    """
    Get for ccp.lims.RefSampleComponent.MolComponent.protTargets
    """
    dataDict = self.__dict__
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.lims.Target')
    tobjList = root.__dict__.get('targetStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    tempVar = dataDict.get('protTargets')
    result = frozenset(tempVar)
    return result

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName
  
  def getRefMolCompFeatures(self):
    """
    Get for ccp.lims.RefSampleComponent.MolComponent.refMolCompFeatures
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('refMolCompFeatures')
    result = frozenset(tempVar)
    return result

  getRefSampleComponentStore = AbstractComponent.getRefSampleComponentStore
  
  def getRelatedExpBlueprints(self):
    """
    Get for ccp.lims.RefSampleComponent.MolComponent.relatedExpBlueprints
    """
    dataDict = self.__dict__
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.lims.ExpBlueprint')
    tobjList = root.__dict__.get('expBlueprintStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    tempVar = dataDict.get('relatedExpBlueprints')
    result = frozenset(tempVar)
    return result

  getRoot = memops.api.Implementation.MemopsObject.getRoot
  
  def getSeqDetails(self):
    """
    Get for ccp.lims.RefSampleComponent.MolComponent.seqDetails
    """
    dataDict = self.__dict__
    result = dataDict.get('seqDetails')
    return result
  
  def getSeqString(self):
    """
    Get for ccp.lims.RefSampleComponent.MolComponent.seqString
    """
    dataDict = self.__dict__
    result = dataDict.get('seqString')
    return result
  
  def getSpecificLabelGroups(self):
    """
    Get for ccp.lims.RefSampleComponent.MolComponent.specificLabelGroups
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('specificLabelGroups').values()
    result = frozenset(tempVar)
    return result

  getSynonyms = AbstractComponent.getSynonyms

  getTopObject = memops.api.Implementation.DataObject.getTopObject

  newComponentDbRef = AbstractComponent.newComponentDbRef

  newLabel = AbstractComponent.newLabel
  
  def newMolCompFeature(self, **attrlinks):
    """
    Factory function to create ccp.lims.RefSampleComponent.MolCompFeature
    """
    return MolCompFeature(self, **attrlinks)
  
  def newSpecificLabelGroup(self, **attrlinks):
    """
    Factory function to create
    ccp.lims.RefSampleComponent.SpecificLabelGroup
    """
    return SpecificLabelGroup(self, **attrlinks)

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData
  
  def removeBlueprintComponent(self, value):
    """
    Remove for ccp.lims.RefSampleComponent.MolComponent.blueprintComponents
    """
    dataDict = self.__dict__
    from ccp.api.lims.ExpBlueprint import BlueprintComponent as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.removeBlueprintComponent:
       value is not of class ccp.lims.ExpBlueprint.BlueprintComponent""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.lims.ExpBlueprint')
    tobjList = root.__dict__.get('expBlueprintStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    currentValues = dataDict.get('blueprintComponents')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      topObject = value.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)
      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.removeBlueprintComponent:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.removeBlueprintComponent:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.removeBlueprintComponent:
       called with deleted value""" % self.qualifiedName
      )

    if (not (value in currentValues)):
      raise ApiError("""%s.removeBlueprintComponent:
       value not in list""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      pass

    value.__dict__['molComponent'] = None
    currentValues.remove(value)
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('removeBlueprintComponent')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  removeCategory = AbstractComponent.removeCategory
  
  def removeNucTarget(self, value):
    """
    Remove for ccp.lims.RefSampleComponent.MolComponent.nucTargets
    """
    dataDict = self.__dict__
    from ccp.api.lims.Target import Target as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.removeNucTarget:
       value is not of class ccp.lims.Target.Target""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.lims.Target')
    tobjList = root.__dict__.get('targetStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    currentValues = dataDict.get('nucTargets')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      topObject = value.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)
      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.removeNucTarget:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.removeNucTarget:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.removeNucTarget:
       called with deleted value""" % self.qualifiedName
      )

    if (not (value in currentValues)):
      raise ApiError("""%s.removeNucTarget:
       value not in list""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      pass

    oldSelves = value.__dict__.get('nucleicAcids')
    oldSelves.remove(self)
    currentValues.remove(value)
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('removeNucTarget')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def removeRefMolCompFeature(self, value):
    """
    Remove for ccp.lims.RefSampleComponent.MolComponent.refMolCompFeatures
    """
    dataDict = self.__dict__
    if (not isinstance(value, MolCompFeature)):
      raise ApiError("""%s.removeRefMolCompFeature:
       value is not of class ccp.lims.RefSampleComponent.MolCompFeature""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('refMolCompFeatures')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.removeRefMolCompFeature:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.removeRefMolCompFeature:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.removeRefMolCompFeature:
       called with deleted value""" % self.qualifiedName
      )

    if (not (value in currentValues)):
      raise ApiError("""%s.removeRefMolCompFeature:
       value not in list""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      pass

    value.__dict__['refMolComponent'] = None
    currentValues.remove(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('removeRefMolCompFeature')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def removeRelatedExpBlueprint(self, value):
    """
    Remove for ccp.lims.RefSampleComponent.MolComponent.relatedExpBlueprints
    """
    dataDict = self.__dict__
    from ccp.api.lims.ExpBlueprint import BlueprintComponent as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.removeRelatedExpBlueprint:
       value is not of class ccp.lims.ExpBlueprint.BlueprintComponent""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.lims.ExpBlueprint')
    tobjList = root.__dict__.get('expBlueprintStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    currentValues = dataDict.get('relatedExpBlueprints')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      topObject = value.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)
      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.removeRelatedExpBlueprint:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.removeRelatedExpBlueprint:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.removeRelatedExpBlueprint:
       called with deleted value""" % self.qualifiedName
      )

    if (not (value in currentValues)):
      raise ApiError("""%s.removeRelatedExpBlueprint:
       value not in list""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      pass

    oldSelves = value.__dict__.get('trialMolComponents')
    oldSelves.remove(self)
    currentValues.remove(value)
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('removeRelatedExpBlueprint')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  removeSynonym = AbstractComponent.removeSynonym
  
  def set(self, name, value):
    """
    SetAttr for ccp.lims.RefSampleComponent.MolComponent
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData
  
  def setBlueprintComponents(self, values):
    """
    Set for ccp.lims.RefSampleComponent.MolComponent.blueprintComponents
    """
    dataDict = self.__dict__
    xx = values
    values = set(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setBlueprintComponents:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      from ccp.api.lims.ExpBlueprint import BlueprintComponent as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setBlueprintComponents:
         value is not of class ccp.lims.ExpBlueprint.BlueprintComponent""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.lims.ExpBlueprint')
    tobjList = root.__dict__.get('expBlueprintStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    currentValues = dataDict.get('blueprintComponents')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      for pv in currentValues:
        if (not (pv in values)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)

      for pv in values:
        if (not (pv in currentValues)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)
          oldSelf = pv.__dict__.get('molComponent')
          if (oldSelf is not None):
            if (notIsReading):
              topObject = oldSelf.__dict__.get('topObject')
              topObjectsToCheck.add(topObject)
            else:
              raise ApiError("""%s.setBlueprintComponents:
               Read link incompatible with pre-existing link""" % self.qualifiedName
               + ": %s" % (self,)
              )

      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setBlueprintComponents:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setBlueprintComponents:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setBlueprintComponents:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
      for value in values:
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setBlueprintComponents:
           Link blueprintComponents between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    for cv in currentValues:
      if (not (cv in values)):
        cv.__dict__['molComponent'] = None

    for cv in values:
      if (not (cv in currentValues)):
        oldSelf = cv.__dict__.get('molComponent')
        if (oldSelf is not None):
          vv = oldSelf.__dict__.get('blueprintComponents')
          vv.remove(cv)

      cv.__dict__['molComponent'] = self

    dataDict['blueprintComponents'] = values
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setBlueprintComponents')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setCasNum(self, value):
    """
    Set for ccp.lims.RefSampleComponent.MolComponent.casNum
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setCasNum:
         memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 32):
        raise ApiError("""%s.setCasNum:
         memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setCasNum:
         memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.setCasNum:
         Word constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('casNum')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setCasNum:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setCasNum:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['casNum'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setCasNum')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  setCategories = AbstractComponent.setCategories

  setCompositeElements = AbstractComponent.setCompositeElements

  setDetails = AbstractComponent.setDetails
  
  def setEmpiricalFormula(self, value):
    """
    Set for ccp.lims.RefSampleComponent.MolComponent.empiricalFormula
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setEmpiricalFormula:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.setEmpiricalFormula:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setEmpiricalFormula:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.setEmpiricalFormula:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('empiricalFormula')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setEmpiricalFormula:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setEmpiricalFormula:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['empiricalFormula'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setEmpiricalFormula')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setLabeledMixture(self, value):
    """
    Set for ccp.lims.RefSampleComponent.MolComponent.labeledMixture
    """
    dataDict = self.__dict__
    if (value is not None):
      from ccp.api.molecule.LabeledMolecule import LabeledMixture as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setLabeledMixture:
         value is not of class ccp.molecule.LabeledMolecule.LabeledMixture""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('labeledMixture')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      if (value is not None):
        topObject = value.__dict__.get('topObject')
        topObjectsToCheck.add(topObject)

      if (currentValue is not None):
        topObject = currentValue.__dict__.get('topObject')
        topObjectsToCheck.add(topObject)

      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setLabeledMixture:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setLabeledMixture:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setLabeledMixture:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setLabeledMixture:
           Link labeledMixture between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    if (currentValue is not None):
      if (notIsReading):
        oldSelves = currentValue.__dict__.get('molComponents')
        oldSelves.remove(self)
      else:
        raise ApiError("""%s.setLabeledMixture:
         Read link 'labeledMixture' incompatible with pre-existing link""" % self.qualifiedName
         + ": %s" % (self,)
        )

    if (value is not None):
      newSelves = value.__dict__.get('molComponents')
      newSelves.add(self)

    dataDict['labeledMixture'] = value
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setLabeledMixture')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setMolType(self, value):
    """
    Set for ccp.lims.RefSampleComponent.MolComponent.molType
    """
    dataDict = self.__dict__
    if (value is not None):
      if (not (value in ['protein', 'DNA', 'RNA', 'DNA/RNA', 'carbohydrate', 'other'])):
        raise ApiError("""%s.setMolType:
         ccp.molecule.Molecule.MolType input is not in enumeration ['protein', 'DNA', 'RNA', 'DNA/RNA', 'carbohydrate', 'other']""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.setMolType:
         MolType constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('molType')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setMolType:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setMolType:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['molType'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setMolType')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setMolecularMass(self, value):
    """
    Set for ccp.lims.RefSampleComponent.MolComponent.molecularMass
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.Float.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Float.create(value)
      else:
        raise ApiError("""%s.setMolecularMass:
         memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value - value == 0.0)):
        raise ApiError("""%s.setMolecularMass:
         Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('molecularMass')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setMolecularMass:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setMolecularMass:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['molecularMass'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setMolecularMass')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setMolecule(self, value):
    """
    Set for ccp.lims.RefSampleComponent.MolComponent.molecule
    """
    dataDict = self.__dict__
    if (value is not None):
      from ccp.api.molecule.Molecule import Molecule as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setMolecule:
         value is not of class ccp.molecule.Molecule.Molecule""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('molecule')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      if (value is not None):
        topObject = value.__dict__.get('topObject')
        topObjectsToCheck.add(topObject)

      if (currentValue is not None):
        topObject = currentValue.__dict__.get('topObject')
        topObjectsToCheck.add(topObject)

      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setMolecule:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setMolecule:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setMolecule:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setMolecule:
           Link molecule between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      if (notInConstructor):
        if (value is not None):
          if (not (value.isFinalised)):
            raise ApiError("""%s.setMolecule:
             molecule constraint Molecule_must_be_finalised violated by value""" % self.qualifiedName
             + ": %s" % (value,)
            )

    if (currentValue is not None):
      if (notIsReading):
        oldSelves = currentValue.__dict__.get('molComponents')
        oldSelves.remove(self)
      else:
        raise ApiError("""%s.setMolecule:
         Read link 'molecule' incompatible with pre-existing link""" % self.qualifiedName
         + ": %s" % (self,)
        )

    if (value is not None):
      newSelves = value.__dict__.get('molComponents')
      newSelves.add(self)

    dataDict['molecule'] = value
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        if (not (topObjectModify.__dict__.get('isLoaded'))):
          topObjectModify.load()

        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setMolecule')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  setName = AbstractComponent.setName

  setNaturalSource = AbstractComponent.setNaturalSource
  
  def setNucTargets(self, values):
    """
    Set for ccp.lims.RefSampleComponent.MolComponent.nucTargets
    """
    dataDict = self.__dict__
    xx = values
    values = set(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setNucTargets:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      from ccp.api.lims.Target import Target as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setNucTargets:
         value is not of class ccp.lims.Target.Target""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.lims.Target')
    tobjList = root.__dict__.get('targetStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    currentValues = dataDict.get('nucTargets')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      for pv in currentValues:
        if (not (pv in values)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)

      for pv in values:
        if (not (pv in currentValues)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)

      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setNucTargets:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setNucTargets:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setNucTargets:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
      for value in values:
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setNucTargets:
           Link nucTargets between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    for cv in currentValues:
      if (not (cv in values)):
        oldSelves = cv.__dict__.get('nucleicAcids')
        oldSelves.remove(self)

    for cv in values:
      if (not (cv in currentValues)):
        oldSelves = cv.__dict__.get('nucleicAcids')
        oldSelves.add(self)

    dataDict['nucTargets'] = values
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setNucTargets')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setProtTargets(self, values):
    """
    Set for ccp.lims.RefSampleComponent.MolComponent.protTargets
    """
    dataDict = self.__dict__
    xx = values
    values = set(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setProtTargets:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      from ccp.api.lims.Target import Target as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setProtTargets:
         value is not of class ccp.lims.Target.Target""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.lims.Target')
    tobjList = root.__dict__.get('targetStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    currentValues = dataDict.get('protTargets')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      for pv in currentValues:
        if (not (pv in values)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)

      for pv in values:
        if (not (pv in currentValues)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)
          oldSelf = pv.__dict__.get('protein')
          if (oldSelf is not None):
            if (notIsReading):
              topObject = oldSelf.__dict__.get('topObject')
              topObjectsToCheck.add(topObject)
            else:
              raise ApiError("""%s.setProtTargets:
               Read link incompatible with pre-existing link""" % self.qualifiedName
               + ": %s" % (self,)
              )

      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setProtTargets:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setProtTargets:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setProtTargets:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      for cv in currentValues:
        if (not (cv in values)):
          raise ApiError("""%s.setProtTargets:
           locard protein: cannot set because some of current values not in values""" % self.qualifiedName
           + ": %s" % (self,)
          )

      xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
      for value in values:
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setProtTargets:
           Link protTargets between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    for cv in currentValues:
      if (not (cv in values)):
        cv.__dict__['protein'] = None

    for cv in values:
      if (not (cv in currentValues)):
        oldSelf = cv.__dict__.get('protein')
        if (oldSelf is not None):
          vv = oldSelf.__dict__.get('protTargets')
          vv.remove(cv)

      cv.__dict__['protein'] = self

    dataDict['protTargets'] = values
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setProtTargets')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setRefMolCompFeatures(self, values):
    """
    Set for ccp.lims.RefSampleComponent.MolComponent.refMolCompFeatures
    """
    dataDict = self.__dict__
    xx = values
    values = set(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setRefMolCompFeatures:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      if (not isinstance(value, MolCompFeature)):
        raise ApiError("""%s.setRefMolCompFeatures:
         value is not of class ccp.lims.RefSampleComponent.MolCompFeature""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('refMolCompFeatures')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setRefMolCompFeatures:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setRefMolCompFeatures:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setRefMolCompFeatures:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      xx1 = dataDict.get('topObject')
      for value in values:
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setRefMolCompFeatures:
           Link refMolCompFeatures between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    for cv in currentValues:
      if (not (cv in values)):
        cv.__dict__['refMolComponent'] = None

    for cv in values:
      if (not (cv in currentValues)):
        oldSelf = cv.__dict__.get('refMolComponent')
        if (oldSelf is not None):
          vv = oldSelf.__dict__.get('refMolCompFeatures')
          vv.remove(cv)

      cv.__dict__['refMolComponent'] = self

    dataDict['refMolCompFeatures'] = values
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setRefMolCompFeatures')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setRelatedExpBlueprints(self, values):
    """
    Set for ccp.lims.RefSampleComponent.MolComponent.relatedExpBlueprints
    """
    dataDict = self.__dict__
    xx = values
    values = set(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setRelatedExpBlueprints:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      from ccp.api.lims.ExpBlueprint import BlueprintComponent as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setRelatedExpBlueprints:
         value is not of class ccp.lims.ExpBlueprint.BlueprintComponent""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.lims.ExpBlueprint')
    tobjList = root.__dict__.get('expBlueprintStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    currentValues = dataDict.get('relatedExpBlueprints')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      for pv in currentValues:
        if (not (pv in values)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)

      for pv in values:
        if (not (pv in currentValues)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)

      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setRelatedExpBlueprints:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setRelatedExpBlueprints:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setRelatedExpBlueprints:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
      for value in values:
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setRelatedExpBlueprints:
           Link relatedExpBlueprints between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    for cv in currentValues:
      if (not (cv in values)):
        oldSelves = cv.__dict__.get('trialMolComponents')
        oldSelves.remove(self)

    for cv in values:
      if (not (cv in currentValues)):
        oldSelves = cv.__dict__.get('trialMolComponents')
        oldSelves.add(self)

    dataDict['relatedExpBlueprints'] = values
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setRelatedExpBlueprints')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setSeqDetails(self, value):
    """
    Set for ccp.lims.RefSampleComponent.MolComponent.seqDetails
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setSeqDetails:
         memops.Implementation.String input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('seqDetails')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setSeqDetails:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setSeqDetails:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['seqDetails'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setSeqDetails')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setSeqString(self, value):
    """
    Set for ccp.lims.RefSampleComponent.MolComponent.seqString
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setSeqString:
         memops.Implementation.String input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('seqString')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setSeqString:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setSeqString:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['seqString'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setSeqString')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  setSynonyms = AbstractComponent.setSynonyms
  
  def sortedBlueprintComponents(self):
    """
    Sorted for ccp.lims.RefSampleComponent.MolComponent.blueprintComponents
    """
    dataDict = self.__dict__
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.lims.ExpBlueprint')
    tobjList = root.__dict__.get('expBlueprintStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    ll = dataDict.get('blueprintComponents')
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result

  sortedCategories = AbstractComponent.sortedCategories

  sortedComponentDbRefs = AbstractComponent.sortedComponentDbRefs

  sortedCompositeElements = AbstractComponent.sortedCompositeElements

  sortedLabels = AbstractComponent.sortedLabels
  
  def sortedMolCompFeatures(self):
    """
    Sorted for ccp.lims.RefSampleComponent.MolComponent.molCompFeatures
    """
    dataDict = self.__dict__
    sortdd = dataDict.get('molCompFeatures')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result
  
  def sortedNucTargets(self):
    """
    Sorted for ccp.lims.RefSampleComponent.MolComponent.nucTargets
    """
    dataDict = self.__dict__
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.lims.Target')
    tobjList = root.__dict__.get('targetStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    ll = dataDict.get('nucTargets')
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result
  
  def sortedProtTargets(self):
    """
    Sorted for ccp.lims.RefSampleComponent.MolComponent.protTargets
    """
    dataDict = self.__dict__
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.lims.Target')
    tobjList = root.__dict__.get('targetStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    ll = dataDict.get('protTargets')
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result
  
  def sortedRefMolCompFeatures(self):
    """
    Sorted for ccp.lims.RefSampleComponent.MolComponent.refMolCompFeatures
    """
    dataDict = self.__dict__
    ll = dataDict.get('refMolCompFeatures')
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result
  
  def sortedRelatedExpBlueprints(self):
    """
    Sorted for ccp.lims.RefSampleComponent.MolComponent.relatedExpBlueprints
    """
    dataDict = self.__dict__
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.lims.ExpBlueprint')
    tobjList = root.__dict__.get('expBlueprintStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    ll = dataDict.get('relatedExpBlueprints')
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result
  
  def sortedSpecificLabelGroups(self):
    """
    Sorted for ccp.lims.RefSampleComponent.MolComponent.specificLabelGroups
    """
    dataDict = self.__dict__
    sortdd = dataDict.get('specificLabelGroups')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  applicationData = memops.api.Implementation.DataObject.applicationData
  
  casNum = property(getCasNum, setCasNum, None,
  r"""CAS registry number (http://www.cas.org/EO/regsys.html).
  """)

  className = memops.api.Implementation.ComplexDataType.className

  details = AbstractComponent.details
  
  empiricalFormula = property(getEmpiricalFormula, setEmpiricalFormula, None,
  r"""The molecular formula of the molComponent.
  """)

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted

  metaclass = memops.api.Implementation.ComplexDataType.metaclass
  
  molType = property(getMolType, setMolType, None,
  r"""Type of component, on the general lines of 
  biopolymer/polymer/nonpolymer. See MolComponentType DataType for details
  """)
  
  molecularMass = property(getMolecularMass, setMolecularMass, None,
  r"""The experimental molecular mass in dalton (Da).
  """)

  name = AbstractComponent.name

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName
  
  seqDetails = property(getSeqDetails, setSeqDetails, None,
  r"""
  """)
  
  seqString = property(getSeqString, setSeqString, None,
  r"""
  """)

  synonyms = AbstractComponent.synonyms

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess
  
  blueprintComponents = property(getBlueprintComponents, setBlueprintComponents, None,
  r"""
  """)

  categories = AbstractComponent.categories

  componentDbRefs = AbstractComponent.componentDbRefs

  compositeElements = AbstractComponent.compositeElements
  
  labeledMixture = property(getLabeledMixture, setLabeledMixture, None,
  r"""LabeledMixture that describes MolComponent isotope labeling
  """)

  labels = AbstractComponent.labels
  
  molCompFeatures = property(getMolCompFeatures,  None, None,
  r"""child link to class MolCompFeature
  """)
  
  molecule = property(getMolecule, setMolecule, None,
  r"""The molecule used to describe the precise topology of the MolComponent.
  """)

  naturalSource = AbstractComponent.naturalSource
  
  nucTargets = property(getNucTargets, setNucTargets, None,
  r"""The Target associated other MolComponent that define it
  """)

  parent = AbstractComponent.parent
  
  protTargets = property(getProtTargets, setProtTargets, None,
  r"""The Target associated to the MolComponent that defines it
  """)
  
  refMolCompFeatures = property(getRefMolCompFeatures, setRefMolCompFeatures, None,
  r"""
  """)

  refSampleComponentStore = AbstractComponent.refSampleComponentStore
  
  relatedExpBlueprints = property(getRelatedExpBlueprints, setRelatedExpBlueprints, None,
  r"""
  """)

  root = memops.api.Implementation.MemopsObject.root
  
  specificLabelGroups = property(getSpecificLabelGroups,  None, None,
  r"""child link to class SpecificLabelGroup
  """)

  topObject = memops.api.Implementation.DataObject.topObject

###############################################################################
class Substance(AbstractComponent):
  r"""A Substance should be limited to cases that cannot be put under any of 
the others. Typically: bovine calf serum, light petroleum, wheat germ 
extract, algal hydrolysate.
  """
  #   from data model element ccp.lims.RefSampleComponent.Substance revision ?
  _metaclass = metaPackage.getElement('Substance')
  _packageName = 'ccp.lims.RefSampleComponent'
  _packageShortName = 'REFS'
  _fieldNames = ('applicationData', 'className', 'details', 'fieldNames', 'inConstructor', 'isDeleted', 'metaclass', 'name', 'packageName', 'packageShortName', 'qualifiedName', 'synonyms', 'access', 'activeAccess', 'categories', 'componentDbRefs', 'compositeElements', 'labels', 'naturalSource', 'parent', 'refSampleComponentStore', 'root', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for ccp.lims.RefSampleComponent.Substance
    """
    dataDict = self.__dict__
    dataDict['refSampleComponentStore'] = parent
    if (not isinstance(parent, RefSampleComponentStore)):
      raise ApiError("""%s.__init__:
       value is not of class ccp.lims.RefSampleComponent.RefSampleComponentStore""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = parent.__dict__.get('topObject')
    dataDict['topObject'] = topObject

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    if (notIsReading):
      if (not (topObject.__dict__.get('isModifiable'))):
        raise ApiError("""%s.__init__:
         Storage not modifiable""" % self.qualifiedName
         + ": %s" % (topObject,)
        )

    try:
      if (not ((parent.__dict__.get('isLoaded') or parent.__dict__.get('isReading')))):
        parent.load()

      dataDict['applicationData'] = list()
      dataDict['details'] = None
      dataDict['name'] = None
      dataDict['synonyms'] = list()
      dataDict['access'] = None
      dataDict['categories'] = set()
      dataDict['componentDbRefs'] = {}
      dataDict['compositeElements'] = set()
      dataDict['labels'] = {}
      dataDict['naturalSource'] = None

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in ccp.lims.RefSampleComponent.Substance.__init__"
        del dataDict['inConstructor']
        raise

      serialDict = {}
      serialDict['componentDbRefs'] = 0
      serialDict['labels'] = 0
      dataDict['_serialDict'] = serialDict

      if (notIsReading):
        childrenDict = parent.__dict__.get('components')
        objKey = dataDict.get('name')
        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['name'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notOverride):
        self.checkValid()

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for ccp.lims.RefSampleComponent.Substance:
       determines 
    cascading deletes to follow from delete of object.
       *Implementation 
    function* - should be called only by API delete function.
    """
    dataDict = self.__dict__
    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    categories = dataDict.get('categories')
    pass
    for category in categories:
      topObject = category.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    componentDbRefs = dataDict.get('componentDbRefs').values()
    for componentDbRef in componentDbRefs:
      if (not (componentDbRef in objsToBeDeleted)):
        objsToBeDeleted.add(componentDbRef)
        objsToBeChecked.append(componentDbRef)

    compositeElements = dataDict.get('compositeElements')
    for compositeElement in compositeElements:
      if (not (compositeElement in objsToBeDeleted)):
        objsToBeDeleted.add(compositeElement)
        objsToBeChecked.append(compositeElement)

    labels = dataDict.get('labels').values()
    for label in labels:
      if (not (label in objsToBeDeleted)):
        objsToBeDeleted.add(label)
        objsToBeChecked.append(label)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for ccp.lims.RefSampleComponent.Substance:   deletes
    objects
    *Implementation function* - will CORRUPT DATA if called outside 
    the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    for category in dataDict.get('categories'):
      if (not (category in objsToBeDeleted)):
        components = category.__dict__.get('components')
        components.remove(self)

    refSampleComponentStore = dataDict.get('refSampleComponentStore')
    if (not (refSampleComponentStore in objsToBeDeleted)):
      objKey = dataDict.get('name')
      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = refSampleComponentStore.__dict__.get('components')
        if (self is dd.get(objKey)):
          del dd[objKey]

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData

  addCategory = AbstractComponent.addCategory

  addSynonym = AbstractComponent.addSynonym
  
  def checkAllValid(self, complete=False):
    """
    CheckAllValid for ccp.lims.RefSampleComponent.Substance
    """
    dataDict = self.__dict__
    self.checkValid(complete)
    values = dataDict.get('componentDbRefs').values()
    for value in values:
      value.checkAllValid(complete)

    values = dataDict.get('labels').values()
    for value in values:
      value.checkAllValid(complete)

  def checkValid(self, complete=False):
    """
    CheckValid for ccp.lims.RefSampleComponent.Substance
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      objKey = dataDict.get('name')
      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('refSampleComponentStore')
        dd = value.__dict__.get('components')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'refSampleComponentStore' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      # check attributes
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('details')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: details:
           memops.Implementation.String input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('name')
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: name:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: name:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: name:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: name:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      values = dataDict.get('synonyms')
      for value in values:
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: synonyms:
           memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: synonyms:
           memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: synonyms:
           memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: synonyms:
           Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      values = dataDict.get('categories')
      for value in values:
        from ccp.api.lims.Classification import SampleComponentCategory as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: categories:
           value is not of class ccp.lims.Classification.SampleComponentCategory""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('components')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: categories:
           non-reciprocal link categories from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: categories:
           Link categories between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      values = dataDict.get('componentDbRefs').values()
      for value in values:
        if (not isinstance(value, ComponentDbRef)):
          raise ApiError("""%s.checkValid: componentDbRefs:
           value is not of class ccp.lims.RefSampleComponent.ComponentDbRef""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('component')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: componentDbRefs:
           non-reciprocal link componentDbRefs from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      values = dataDict.get('compositeElements')
      for value in values:
        if (not isinstance(value, CompositeElement)):
          raise ApiError("""%s.checkValid: compositeElements:
           value is not of class ccp.lims.RefSampleComponent.CompositeElement""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('component')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: compositeElements:
           non-reciprocal link compositeElements from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: compositeElements:
           Link compositeElements between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      values = dataDict.get('labels').values()
      for value in values:
        if (not isinstance(value, Label)):
          raise ApiError("""%s.checkValid: labels:
           value is not of class ccp.lims.RefSampleComponent.Label""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('component')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: labels:
           non-reciprocal link labels from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      value = dataDict.get('naturalSource')
      if (value is not None):
        from ccp.api.general.Taxonomy import NaturalSource as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: naturalSource:
           value is not of class ccp.general.Taxonomy.NaturalSource""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: naturalSource:
           Link naturalSource between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('refSampleComponentStore')
      if (not isinstance(value, RefSampleComponentStore)):
        raise ApiError("""%s.checkValid: refSampleComponentStore:
         value is not of class ccp.lims.RefSampleComponent.RefSampleComponentStore""" % self.qualifiedName
         + ": %s" % (value,)
        )

    # check explicit class constraints
    # check attributes
    values = dataDict.get('applicationData')
    for value in values:
      value.checkAllValid(complete)

    value = dataDict.get('details')
    value = dataDict.get('name')
    if (value is None):
      raise ApiError("""%s.checkValid: name:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    values = dataDict.get('synonyms')
    # check roles
    value = dataDict.get('access')
    values = dataDict.get('categories')
    values = dataDict.get('componentDbRefs').values()
    values = dataDict.get('compositeElements')
    values = dataDict.get('labels').values()
    value = dataDict.get('naturalSource')
    value = dataDict.get('refSampleComponentStore')
    if (value is None):
      raise ApiError("""%s.checkValid: refSampleComponentStore:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

  delete = memops.api.Implementation.DataObject.delete

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData

  findAllCategories = AbstractComponent.findAllCategories

  findAllComponentDbRefs = AbstractComponent.findAllComponentDbRefs

  findAllCompositeElements = AbstractComponent.findAllCompositeElements

  findAllLabels = AbstractComponent.findAllLabels

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData

  findFirstCategory = AbstractComponent.findFirstCategory

  findFirstComponentDbRef = AbstractComponent.findFirstComponentDbRef

  findFirstCompositeElement = AbstractComponent.findFirstCompositeElement

  findFirstLabel = AbstractComponent.findFirstLabel
  
  def get(self, name):
    """
    GetAttr for ccp.lims.RefSampleComponent.Substance
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccp.lims.RefSampleComponent.Substance
    """

    result = None
    if (startObj.__class__.__name__ == 'MemopsRoot'):
      if (2 != len(fullKey)):
        raise ApiError("""'ccp.lims.RefSampleComponent.Substance'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj0 = startObj
      objKey = fullKey[0]
      obj1 = obj0.__dict__.get('refSampleComponentStores').get(objKey)
      if (obj1 is None):
        obj0.refreshTopObjects('ccp.lims.RefSampleComponent')
        obj1 = obj0.__dict__.get('refSampleComponentStores').get(objKey)

    else:
      if (1 != len(fullKey)):
        raise ApiError("""'ccp.lims.RefSampleComponent.Substance'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj1 = startObj

    if (obj1 is not None):
      if (not (obj1.__dict__.get('isLoaded'))):
        obj1.load()

      objKey = fullKey[-1]
      obj2 = obj1.__dict__.get('components').get(objKey)
      if (isinstance(obj2, Substance)):
        result = obj2

    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation

  getCategories = AbstractComponent.getCategories

  getClassName = memops.api.Implementation.ComplexDataType.getClassName

  getComponentDbRefs = AbstractComponent.getComponentDbRefs

  getCompositeElements = AbstractComponent.getCompositeElements

  getDetails = AbstractComponent.getDetails

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames

  getFullKey = AbstractComponent.getFullKey

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted

  getLabels = AbstractComponent.getLabels

  getLocalKey = AbstractComponent.getLocalKey

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass

  getName = AbstractComponent.getName

  getNaturalSource = AbstractComponent.getNaturalSource

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName

  getParent = AbstractComponent.getParent

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName

  getRefSampleComponentStore = AbstractComponent.getRefSampleComponentStore

  getRoot = memops.api.Implementation.MemopsObject.getRoot

  getSynonyms = AbstractComponent.getSynonyms

  getTopObject = memops.api.Implementation.DataObject.getTopObject

  newComponentDbRef = AbstractComponent.newComponentDbRef

  newLabel = AbstractComponent.newLabel

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData

  removeCategory = AbstractComponent.removeCategory

  removeSynonym = AbstractComponent.removeSynonym
  
  def set(self, name, value):
    """
    SetAttr for ccp.lims.RefSampleComponent.Substance
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData

  setCategories = AbstractComponent.setCategories

  setCompositeElements = AbstractComponent.setCompositeElements

  setDetails = AbstractComponent.setDetails

  setName = AbstractComponent.setName

  setNaturalSource = AbstractComponent.setNaturalSource

  setSynonyms = AbstractComponent.setSynonyms

  sortedCategories = AbstractComponent.sortedCategories

  sortedComponentDbRefs = AbstractComponent.sortedComponentDbRefs

  sortedCompositeElements = AbstractComponent.sortedCompositeElements

  sortedLabels = AbstractComponent.sortedLabels

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  applicationData = memops.api.Implementation.DataObject.applicationData

  className = memops.api.Implementation.ComplexDataType.className

  details = AbstractComponent.details

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted

  metaclass = memops.api.Implementation.ComplexDataType.metaclass

  name = AbstractComponent.name

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName

  synonyms = AbstractComponent.synonyms

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess

  categories = AbstractComponent.categories

  componentDbRefs = AbstractComponent.componentDbRefs

  compositeElements = AbstractComponent.compositeElements

  labels = AbstractComponent.labels

  naturalSource = AbstractComponent.naturalSource

  parent = AbstractComponent.parent

  refSampleComponentStore = AbstractComponent.refSampleComponentStore

  root = memops.api.Implementation.MemopsObject.root

  topObject = memops.api.Implementation.DataObject.topObject

###############################################################################
class Cell(AbstractComponent):
  r"""Cell is a subclass of AbstractComponent. The information on the cell 
component.
  """
  #   from data model element ccp.lims.RefSampleComponent.Cell revision ?
  _metaclass = metaPackage.getElement('Cell')
  _packageName = 'ccp.lims.RefSampleComponent'
  _packageShortName = 'REFS'
  _fieldNames = ('applicationData', 'className', 'competentMethod', 'cultureCollection', 'details', 'divided', 'features', 'fieldNames', 'inConstructor', 'isDeleted', 'metaclass', 'name', 'packageName', 'packageShortName', 'phase', 'qualifiedName', 'synonyms', 'access', 'activeAccess', 'categories', 'componentDbRefs', 'compositeElements', 'labels', 'naturalSource', 'parent', 'refSampleComponentStore', 'root', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for ccp.lims.RefSampleComponent.Cell
    """
    dataDict = self.__dict__
    dataDict['refSampleComponentStore'] = parent
    if (not isinstance(parent, RefSampleComponentStore)):
      raise ApiError("""%s.__init__:
       value is not of class ccp.lims.RefSampleComponent.RefSampleComponentStore""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = parent.__dict__.get('topObject')
    dataDict['topObject'] = topObject

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    if (notIsReading):
      if (not (topObject.__dict__.get('isModifiable'))):
        raise ApiError("""%s.__init__:
         Storage not modifiable""" % self.qualifiedName
         + ": %s" % (topObject,)
        )

    try:
      if (not ((parent.__dict__.get('isLoaded') or parent.__dict__.get('isReading')))):
        parent.load()

      dataDict['applicationData'] = list()
      dataDict['competentMethod'] = None
      dataDict['cultureCollection'] = None
      dataDict['details'] = None
      dataDict['divided'] = None
      dataDict['features'] = None
      dataDict['name'] = None
      dataDict['phase'] = None
      dataDict['synonyms'] = list()
      dataDict['access'] = None
      dataDict['categories'] = set()
      dataDict['componentDbRefs'] = {}
      dataDict['compositeElements'] = set()
      dataDict['labels'] = {}
      dataDict['naturalSource'] = None

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in ccp.lims.RefSampleComponent.Cell.__init__"
        del dataDict['inConstructor']
        raise

      serialDict = {}
      serialDict['componentDbRefs'] = 0
      serialDict['labels'] = 0
      dataDict['_serialDict'] = serialDict

      if (notIsReading):
        childrenDict = parent.__dict__.get('components')
        objKey = dataDict.get('name')
        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['name'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notOverride):
        self.checkValid()

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for ccp.lims.RefSampleComponent.Cell:
       determines 
    cascading deletes to follow from delete of object.
       *Implementation 
    function* - should be called only by API delete function.
    """
    dataDict = self.__dict__
    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    categories = dataDict.get('categories')
    pass
    for category in categories:
      topObject = category.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    componentDbRefs = dataDict.get('componentDbRefs').values()
    for componentDbRef in componentDbRefs:
      if (not (componentDbRef in objsToBeDeleted)):
        objsToBeDeleted.add(componentDbRef)
        objsToBeChecked.append(componentDbRef)

    compositeElements = dataDict.get('compositeElements')
    for compositeElement in compositeElements:
      if (not (compositeElement in objsToBeDeleted)):
        objsToBeDeleted.add(compositeElement)
        objsToBeChecked.append(compositeElement)

    labels = dataDict.get('labels').values()
    for label in labels:
      if (not (label in objsToBeDeleted)):
        objsToBeDeleted.add(label)
        objsToBeChecked.append(label)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for ccp.lims.RefSampleComponent.Cell:   deletes
    objects
    *Implementation function* - will CORRUPT DATA if called outside 
    the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    for category in dataDict.get('categories'):
      if (not (category in objsToBeDeleted)):
        components = category.__dict__.get('components')
        components.remove(self)

    refSampleComponentStore = dataDict.get('refSampleComponentStore')
    if (not (refSampleComponentStore in objsToBeDeleted)):
      objKey = dataDict.get('name')
      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = refSampleComponentStore.__dict__.get('components')
        if (self is dd.get(objKey)):
          del dd[objKey]

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData

  addCategory = AbstractComponent.addCategory

  addSynonym = AbstractComponent.addSynonym
  
  def checkAllValid(self, complete=False):
    """
    CheckAllValid for ccp.lims.RefSampleComponent.Cell
    """
    dataDict = self.__dict__
    self.checkValid(complete)
    values = dataDict.get('componentDbRefs').values()
    for value in values:
      value.checkAllValid(complete)

    values = dataDict.get('labels').values()
    for value in values:
      value.checkAllValid(complete)

  def checkValid(self, complete=False):
    """
    CheckValid for ccp.lims.RefSampleComponent.Cell
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      objKey = dataDict.get('name')
      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('refSampleComponentStore')
        dd = value.__dict__.get('components')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'refSampleComponentStore' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      # check attributes
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('competentMethod')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: competentMethod:
           memops.Implementation.Text input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 254):
          raise ApiError("""%s.checkValid: competentMethod:
           memops.Implementation.Text maximum length is 254 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: competentMethod:
           memops.Implementation.Text: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('cultureCollection')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: cultureCollection:
           memops.Implementation.Text input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 254):
          raise ApiError("""%s.checkValid: cultureCollection:
           memops.Implementation.Text maximum length is 254 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: cultureCollection:
           memops.Implementation.Text: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('details')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: details:
           memops.Implementation.String input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('divided')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: divided:
           memops.Implementation.Text input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 254):
          raise ApiError("""%s.checkValid: divided:
           memops.Implementation.Text maximum length is 254 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: divided:
           memops.Implementation.Text: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('features')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: features:
           memops.Implementation.Text input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 254):
          raise ApiError("""%s.checkValid: features:
           memops.Implementation.Text maximum length is 254 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: features:
           memops.Implementation.Text: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('name')
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: name:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: name:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: name:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: name:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('phase')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: phase:
           memops.Implementation.Text input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 254):
          raise ApiError("""%s.checkValid: phase:
           memops.Implementation.Text maximum length is 254 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: phase:
           memops.Implementation.Text: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      values = dataDict.get('synonyms')
      for value in values:
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: synonyms:
           memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: synonyms:
           memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: synonyms:
           memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: synonyms:
           Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      values = dataDict.get('categories')
      for value in values:
        from ccp.api.lims.Classification import SampleComponentCategory as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: categories:
           value is not of class ccp.lims.Classification.SampleComponentCategory""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('components')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: categories:
           non-reciprocal link categories from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: categories:
           Link categories between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      values = dataDict.get('componentDbRefs').values()
      for value in values:
        if (not isinstance(value, ComponentDbRef)):
          raise ApiError("""%s.checkValid: componentDbRefs:
           value is not of class ccp.lims.RefSampleComponent.ComponentDbRef""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('component')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: componentDbRefs:
           non-reciprocal link componentDbRefs from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      values = dataDict.get('compositeElements')
      for value in values:
        if (not isinstance(value, CompositeElement)):
          raise ApiError("""%s.checkValid: compositeElements:
           value is not of class ccp.lims.RefSampleComponent.CompositeElement""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('component')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: compositeElements:
           non-reciprocal link compositeElements from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: compositeElements:
           Link compositeElements between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      values = dataDict.get('labels').values()
      for value in values:
        if (not isinstance(value, Label)):
          raise ApiError("""%s.checkValid: labels:
           value is not of class ccp.lims.RefSampleComponent.Label""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('component')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: labels:
           non-reciprocal link labels from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      value = dataDict.get('naturalSource')
      if (value is not None):
        from ccp.api.general.Taxonomy import NaturalSource as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: naturalSource:
           value is not of class ccp.general.Taxonomy.NaturalSource""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: naturalSource:
           Link naturalSource between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('refSampleComponentStore')
      if (not isinstance(value, RefSampleComponentStore)):
        raise ApiError("""%s.checkValid: refSampleComponentStore:
         value is not of class ccp.lims.RefSampleComponent.RefSampleComponentStore""" % self.qualifiedName
         + ": %s" % (value,)
        )

    # check explicit class constraints
    # check attributes
    values = dataDict.get('applicationData')
    for value in values:
      value.checkAllValid(complete)

    value = dataDict.get('competentMethod')
    value = dataDict.get('cultureCollection')
    value = dataDict.get('details')
    value = dataDict.get('divided')
    value = dataDict.get('features')
    value = dataDict.get('name')
    if (value is None):
      raise ApiError("""%s.checkValid: name:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('phase')
    values = dataDict.get('synonyms')
    # check roles
    value = dataDict.get('access')
    values = dataDict.get('categories')
    values = dataDict.get('componentDbRefs').values()
    values = dataDict.get('compositeElements')
    values = dataDict.get('labels').values()
    value = dataDict.get('naturalSource')
    value = dataDict.get('refSampleComponentStore')
    if (value is None):
      raise ApiError("""%s.checkValid: refSampleComponentStore:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

  delete = memops.api.Implementation.DataObject.delete

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData

  findAllCategories = AbstractComponent.findAllCategories

  findAllComponentDbRefs = AbstractComponent.findAllComponentDbRefs

  findAllCompositeElements = AbstractComponent.findAllCompositeElements

  findAllLabels = AbstractComponent.findAllLabels

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData

  findFirstCategory = AbstractComponent.findFirstCategory

  findFirstComponentDbRef = AbstractComponent.findFirstComponentDbRef

  findFirstCompositeElement = AbstractComponent.findFirstCompositeElement

  findFirstLabel = AbstractComponent.findFirstLabel
  
  def get(self, name):
    """
    GetAttr for ccp.lims.RefSampleComponent.Cell
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccp.lims.RefSampleComponent.Cell
    """

    result = None
    if (startObj.__class__.__name__ == 'MemopsRoot'):
      if (2 != len(fullKey)):
        raise ApiError("""'ccp.lims.RefSampleComponent.Cell'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj0 = startObj
      objKey = fullKey[0]
      obj1 = obj0.__dict__.get('refSampleComponentStores').get(objKey)
      if (obj1 is None):
        obj0.refreshTopObjects('ccp.lims.RefSampleComponent')
        obj1 = obj0.__dict__.get('refSampleComponentStores').get(objKey)

    else:
      if (1 != len(fullKey)):
        raise ApiError("""'ccp.lims.RefSampleComponent.Cell'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj1 = startObj

    if (obj1 is not None):
      if (not (obj1.__dict__.get('isLoaded'))):
        obj1.load()

      objKey = fullKey[-1]
      obj2 = obj1.__dict__.get('components').get(objKey)
      if (isinstance(obj2, Cell)):
        result = obj2

    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation

  getCategories = AbstractComponent.getCategories

  getClassName = memops.api.Implementation.ComplexDataType.getClassName
  
  def getCompetentMethod(self):
    """
    Get for ccp.lims.RefSampleComponent.Cell.competentMethod
    """
    dataDict = self.__dict__
    result = dataDict.get('competentMethod')
    return result

  getComponentDbRefs = AbstractComponent.getComponentDbRefs

  getCompositeElements = AbstractComponent.getCompositeElements
  
  def getCultureCollection(self):
    """
    Get for ccp.lims.RefSampleComponent.Cell.cultureCollection
    """
    dataDict = self.__dict__
    result = dataDict.get('cultureCollection')
    return result

  getDetails = AbstractComponent.getDetails
  
  def getDivided(self):
    """
    Get for ccp.lims.RefSampleComponent.Cell.divided
    """
    dataDict = self.__dict__
    result = dataDict.get('divided')
    return result

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey
  
  def getFeatures(self):
    """
    Get for ccp.lims.RefSampleComponent.Cell.features
    """
    dataDict = self.__dict__
    result = dataDict.get('features')
    return result

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames

  getFullKey = AbstractComponent.getFullKey

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted

  getLabels = AbstractComponent.getLabels

  getLocalKey = AbstractComponent.getLocalKey

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass

  getName = AbstractComponent.getName

  getNaturalSource = AbstractComponent.getNaturalSource

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName

  getParent = AbstractComponent.getParent
  
  def getPhase(self):
    """
    Get for ccp.lims.RefSampleComponent.Cell.phase
    """
    dataDict = self.__dict__
    result = dataDict.get('phase')
    return result

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName

  getRefSampleComponentStore = AbstractComponent.getRefSampleComponentStore

  getRoot = memops.api.Implementation.MemopsObject.getRoot

  getSynonyms = AbstractComponent.getSynonyms

  getTopObject = memops.api.Implementation.DataObject.getTopObject

  newComponentDbRef = AbstractComponent.newComponentDbRef

  newLabel = AbstractComponent.newLabel

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData

  removeCategory = AbstractComponent.removeCategory

  removeSynonym = AbstractComponent.removeSynonym
  
  def set(self, name, value):
    """
    SetAttr for ccp.lims.RefSampleComponent.Cell
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData

  setCategories = AbstractComponent.setCategories
  
  def setCompetentMethod(self, value):
    """
    Set for ccp.lims.RefSampleComponent.Cell.competentMethod
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setCompetentMethod:
         memops.Implementation.Text input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 254):
        raise ApiError("""%s.setCompetentMethod:
         memops.Implementation.Text maximum length is 254 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setCompetentMethod:
         memops.Implementation.Text: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('competentMethod')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setCompetentMethod:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setCompetentMethod:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['competentMethod'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setCompetentMethod')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  setCompositeElements = AbstractComponent.setCompositeElements
  
  def setCultureCollection(self, value):
    """
    Set for ccp.lims.RefSampleComponent.Cell.cultureCollection
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setCultureCollection:
         memops.Implementation.Text input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 254):
        raise ApiError("""%s.setCultureCollection:
         memops.Implementation.Text maximum length is 254 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setCultureCollection:
         memops.Implementation.Text: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('cultureCollection')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setCultureCollection:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setCultureCollection:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['cultureCollection'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setCultureCollection')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  setDetails = AbstractComponent.setDetails
  
  def setDivided(self, value):
    """
    Set for ccp.lims.RefSampleComponent.Cell.divided
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setDivided:
         memops.Implementation.Text input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 254):
        raise ApiError("""%s.setDivided:
         memops.Implementation.Text maximum length is 254 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setDivided:
         memops.Implementation.Text: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('divided')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setDivided:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setDivided:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['divided'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setDivided')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setFeatures(self, value):
    """
    Set for ccp.lims.RefSampleComponent.Cell.features
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setFeatures:
         memops.Implementation.Text input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 254):
        raise ApiError("""%s.setFeatures:
         memops.Implementation.Text maximum length is 254 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setFeatures:
         memops.Implementation.Text: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('features')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setFeatures:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setFeatures:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['features'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setFeatures')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  setName = AbstractComponent.setName

  setNaturalSource = AbstractComponent.setNaturalSource
  
  def setPhase(self, value):
    """
    Set for ccp.lims.RefSampleComponent.Cell.phase
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setPhase:
         memops.Implementation.Text input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 254):
        raise ApiError("""%s.setPhase:
         memops.Implementation.Text maximum length is 254 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setPhase:
         memops.Implementation.Text: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('phase')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setPhase:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setPhase:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['phase'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setPhase')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  setSynonyms = AbstractComponent.setSynonyms

  sortedCategories = AbstractComponent.sortedCategories

  sortedComponentDbRefs = AbstractComponent.sortedComponentDbRefs

  sortedCompositeElements = AbstractComponent.sortedCompositeElements

  sortedLabels = AbstractComponent.sortedLabels

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  applicationData = memops.api.Implementation.DataObject.applicationData

  className = memops.api.Implementation.ComplexDataType.className
  
  competentMethod = property(getCompetentMethod, setCompetentMethod, None,
  r"""The method used to obtain competent cells.
  """)
  
  cultureCollection = property(getCultureCollection, setCultureCollection, None,
  r"""N/A
  """)

  details = AbstractComponent.details
  
  divided = property(getDivided, setDivided, None,
  r"""N/A
  """)
  
  features = property(getFeatures, setFeatures, None,
  r"""The specific properties of the cell. e.g. 'cannot used galactose'.
  """)

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted

  metaclass = memops.api.Implementation.ComplexDataType.metaclass

  name = AbstractComponent.name

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName
  
  phase = property(getPhase, setPhase, None,
  r"""N/A
  """)

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName

  synonyms = AbstractComponent.synonyms

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess

  categories = AbstractComponent.categories

  componentDbRefs = AbstractComponent.componentDbRefs

  compositeElements = AbstractComponent.compositeElements

  labels = AbstractComponent.labels

  naturalSource = AbstractComponent.naturalSource

  parent = AbstractComponent.parent

  refSampleComponentStore = AbstractComponent.refSampleComponentStore

  root = memops.api.Implementation.MemopsObject.root

  topObject = memops.api.Implementation.DataObject.topObject

###############################################################################
class Composite(AbstractComponent):
  r"""Composite is a subclass of AbstractComponent. It is a non-covalent 
complex of any kind. E.g. A DNA duplex, a micelle, possibly containing 
other molecules. A protein with an inhibitor bound. A cell containing 
plasmids.
  """
  #   from data model element ccp.lims.RefSampleComponent.Composite revision ?
  _metaclass = metaPackage.getElement('Composite')
  _packageName = 'ccp.lims.RefSampleComponent'
  _packageShortName = 'REFS'
  _fieldNames = ('applicationData', 'assessmentMethod', 'className', 'details', 'fieldNames', 'inConstructor', 'isDeleted', 'metaclass', 'molecularMass', 'molecularMassMethod', 'name', 'packageName', 'packageShortName', 'qualifiedName', 'synonyms', 'access', 'activeAccess', 'categories', 'componentDbRefs', 'compositeElements', 'elements', 'interactions', 'labels', 'naturalSource', 'parent', 'refSampleComponentStore', 'root', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for ccp.lims.RefSampleComponent.Composite
    """
    dataDict = self.__dict__
    dataDict['refSampleComponentStore'] = parent
    if (not isinstance(parent, RefSampleComponentStore)):
      raise ApiError("""%s.__init__:
       value is not of class ccp.lims.RefSampleComponent.RefSampleComponentStore""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = parent.__dict__.get('topObject')
    dataDict['topObject'] = topObject

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    if (notIsReading):
      if (not (topObject.__dict__.get('isModifiable'))):
        raise ApiError("""%s.__init__:
         Storage not modifiable""" % self.qualifiedName
         + ": %s" % (topObject,)
        )

    try:
      if (not ((parent.__dict__.get('isLoaded') or parent.__dict__.get('isReading')))):
        parent.load()

      dataDict['applicationData'] = list()
      dataDict['assessmentMethod'] = None
      dataDict['details'] = None
      dataDict['molecularMass'] = None
      dataDict['molecularMassMethod'] = None
      dataDict['name'] = None
      dataDict['synonyms'] = list()
      dataDict['access'] = None
      dataDict['categories'] = set()
      dataDict['componentDbRefs'] = {}
      dataDict['compositeElements'] = set()
      dataDict['elements'] = {}
      dataDict['interactions'] = {}
      dataDict['labels'] = {}
      dataDict['naturalSource'] = None

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in ccp.lims.RefSampleComponent.Composite.__init__"
        del dataDict['inConstructor']
        raise

      serialDict = {}
      serialDict['componentDbRefs'] = 0
      serialDict['elements'] = 0
      serialDict['interactions'] = 0
      serialDict['labels'] = 0
      dataDict['_serialDict'] = serialDict

      if (notIsReading):
        childrenDict = parent.__dict__.get('components')
        objKey = dataDict.get('name')
        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['name'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notOverride):
        self.checkValid()

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for ccp.lims.RefSampleComponent.Composite:
       determines 
    cascading deletes to follow from delete of object.
       *Implementation 
    function* - should be called only by API delete function.
    """
    dataDict = self.__dict__
    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    categories = dataDict.get('categories')
    pass
    for category in categories:
      topObject = category.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    componentDbRefs = dataDict.get('componentDbRefs').values()
    for componentDbRef in componentDbRefs:
      if (not (componentDbRef in objsToBeDeleted)):
        objsToBeDeleted.add(componentDbRef)
        objsToBeChecked.append(componentDbRef)

    compositeElements = dataDict.get('compositeElements')
    for compositeElement in compositeElements:
      if (not (compositeElement in objsToBeDeleted)):
        objsToBeDeleted.add(compositeElement)
        objsToBeChecked.append(compositeElement)

    elements = dataDict.get('elements').values()
    for element in elements:
      if (not (element in objsToBeDeleted)):
        objsToBeDeleted.add(element)
        objsToBeChecked.append(element)

    interactions = dataDict.get('interactions').values()
    for interaction in interactions:
      if (not (interaction in objsToBeDeleted)):
        objsToBeDeleted.add(interaction)
        objsToBeChecked.append(interaction)

    labels = dataDict.get('labels').values()
    for label in labels:
      if (not (label in objsToBeDeleted)):
        objsToBeDeleted.add(label)
        objsToBeChecked.append(label)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for ccp.lims.RefSampleComponent.Composite:   deletes
    objects
    *Implementation function* - will CORRUPT DATA if called outside 
    the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    for category in dataDict.get('categories'):
      if (not (category in objsToBeDeleted)):
        components = category.__dict__.get('components')
        components.remove(self)

    refSampleComponentStore = dataDict.get('refSampleComponentStore')
    if (not (refSampleComponentStore in objsToBeDeleted)):
      objKey = dataDict.get('name')
      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = refSampleComponentStore.__dict__.get('components')
        if (self is dd.get(objKey)):
          del dd[objKey]

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData

  addCategory = AbstractComponent.addCategory

  addSynonym = AbstractComponent.addSynonym
  
  def checkAllValid(self, complete=False):
    """
    CheckAllValid for ccp.lims.RefSampleComponent.Composite
    """
    dataDict = self.__dict__
    self.checkValid(complete)
    values = dataDict.get('componentDbRefs').values()
    for value in values:
      value.checkAllValid(complete)

    values = dataDict.get('elements').values()
    for value in values:
      value.checkAllValid(complete)

    values = dataDict.get('interactions').values()
    for value in values:
      value.checkAllValid(complete)

    values = dataDict.get('labels').values()
    for value in values:
      value.checkAllValid(complete)

  def checkValid(self, complete=False):
    """
    CheckValid for ccp.lims.RefSampleComponent.Composite
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      objKey = dataDict.get('name')
      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('refSampleComponentStore')
        dd = value.__dict__.get('components')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'refSampleComponentStore' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      # check attributes
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('assessmentMethod')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: assessmentMethod:
           memops.Implementation.Text input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 254):
          raise ApiError("""%s.checkValid: assessmentMethod:
           memops.Implementation.Text maximum length is 254 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: assessmentMethod:
           memops.Implementation.Text: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('details')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: details:
           memops.Implementation.String input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('molecularMass')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.Float.PythonType)):
          pass
        elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
          value = memops.api.Implementation.Float.create(value)
        else:
          raise ApiError("""%s.checkValid: molecularMass:
           memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (value - value == 0.0)):
          raise ApiError("""%s.checkValid: molecularMass:
           Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('molecularMassMethod')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: molecularMassMethod:
           memops.Implementation.Text input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 254):
          raise ApiError("""%s.checkValid: molecularMassMethod:
           memops.Implementation.Text maximum length is 254 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: molecularMassMethod:
           memops.Implementation.Text: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('name')
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: name:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: name:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: name:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: name:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      values = dataDict.get('synonyms')
      for value in values:
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: synonyms:
           memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: synonyms:
           memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: synonyms:
           memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: synonyms:
           Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      values = dataDict.get('categories')
      for value in values:
        from ccp.api.lims.Classification import SampleComponentCategory as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: categories:
           value is not of class ccp.lims.Classification.SampleComponentCategory""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('components')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: categories:
           non-reciprocal link categories from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: categories:
           Link categories between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      values = dataDict.get('componentDbRefs').values()
      for value in values:
        if (not isinstance(value, ComponentDbRef)):
          raise ApiError("""%s.checkValid: componentDbRefs:
           value is not of class ccp.lims.RefSampleComponent.ComponentDbRef""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('component')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: componentDbRefs:
           non-reciprocal link componentDbRefs from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      values = dataDict.get('compositeElements')
      for value in values:
        if (not isinstance(value, CompositeElement)):
          raise ApiError("""%s.checkValid: compositeElements:
           value is not of class ccp.lims.RefSampleComponent.CompositeElement""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('component')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: compositeElements:
           non-reciprocal link compositeElements from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: compositeElements:
           Link compositeElements between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      values = dataDict.get('elements').values()
      for value in values:
        if (not isinstance(value, CompositeElement)):
          raise ApiError("""%s.checkValid: elements:
           value is not of class ccp.lims.RefSampleComponent.CompositeElement""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('composite')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: elements:
           non-reciprocal link elements from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      values = dataDict.get('interactions').values()
      for value in values:
        if (not isinstance(value, CompositeInteraction)):
          raise ApiError("""%s.checkValid: interactions:
           value is not of class ccp.lims.RefSampleComponent.CompositeInteraction""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('composite')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: interactions:
           non-reciprocal link interactions from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      values = dataDict.get('labels').values()
      for value in values:
        if (not isinstance(value, Label)):
          raise ApiError("""%s.checkValid: labels:
           value is not of class ccp.lims.RefSampleComponent.Label""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('component')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: labels:
           non-reciprocal link labels from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      value = dataDict.get('naturalSource')
      if (value is not None):
        from ccp.api.general.Taxonomy import NaturalSource as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: naturalSource:
           value is not of class ccp.general.Taxonomy.NaturalSource""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: naturalSource:
           Link naturalSource between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('refSampleComponentStore')
      if (not isinstance(value, RefSampleComponentStore)):
        raise ApiError("""%s.checkValid: refSampleComponentStore:
         value is not of class ccp.lims.RefSampleComponent.RefSampleComponentStore""" % self.qualifiedName
         + ": %s" % (value,)
        )

    # check explicit class constraints
    # check attributes
    values = dataDict.get('applicationData')
    for value in values:
      value.checkAllValid(complete)

    value = dataDict.get('assessmentMethod')
    value = dataDict.get('details')
    value = dataDict.get('molecularMass')
    value = dataDict.get('molecularMassMethod')
    value = dataDict.get('name')
    if (value is None):
      raise ApiError("""%s.checkValid: name:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    values = dataDict.get('synonyms')
    # check roles
    value = dataDict.get('access')
    values = dataDict.get('categories')
    values = dataDict.get('componentDbRefs').values()
    values = dataDict.get('compositeElements')
    values = dataDict.get('elements').values()
    values = dataDict.get('interactions').values()
    values = dataDict.get('labels').values()
    value = dataDict.get('naturalSource')
    value = dataDict.get('refSampleComponentStore')
    if (value is None):
      raise ApiError("""%s.checkValid: refSampleComponentStore:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

  delete = memops.api.Implementation.DataObject.delete

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData

  findAllCategories = AbstractComponent.findAllCategories

  findAllComponentDbRefs = AbstractComponent.findAllComponentDbRefs

  findAllCompositeElements = AbstractComponent.findAllCompositeElements
  
  def findAllElements(self, **conditions):
    """
    FindAll for ccp.lims.RefSampleComponent.Composite.elements
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('elements').values()
      result = set(currentValues)

    else:
      currentValues = dataDict.get('elements').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('details', 'serial', 'stoichiometry', 'access', 'component', 'composite',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllInteractions(self, **conditions):
    """
    FindAll for ccp.lims.RefSampleComponent.Composite.interactions
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('interactions').values()
      result = set(currentValues)

    else:
      currentValues = dataDict.get('interactions').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('affinity', 'assessmentMethod', 'details', 'interactionType', 'serial', 'access', 'composite',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result

  findAllLabels = AbstractComponent.findAllLabels

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData

  findFirstCategory = AbstractComponent.findFirstCategory

  findFirstComponentDbRef = AbstractComponent.findFirstComponentDbRef

  findFirstCompositeElement = AbstractComponent.findFirstCompositeElement
  
  def findFirstElement(self, **conditions):
    """
    FindFirst for ccp.lims.RefSampleComponent.Composite.elements
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('elements').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      objKey = conditions.get('serial')
      if (objKey is not None):
        result = dataDict.get('elements').get(objKey)

        if (nConditions <= 1):
          return result

        elif (result is None):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        currentValues = dataDict.get('elements').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('details', 'serial', 'stoichiometry', 'access', 'component', 'composite',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstInteraction(self, **conditions):
    """
    FindFirst for ccp.lims.RefSampleComponent.Composite.interactions
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('interactions').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      objKey = conditions.get('serial')
      if (objKey is not None):
        result = dataDict.get('interactions').get(objKey)

        if (nConditions <= 1):
          return result

        elif (result is None):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        currentValues = dataDict.get('interactions').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('affinity', 'assessmentMethod', 'details', 'interactionType', 'serial', 'access', 'composite',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result

  findFirstLabel = AbstractComponent.findFirstLabel
  
  def get(self, name):
    """
    GetAttr for ccp.lims.RefSampleComponent.Composite
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getAssessmentMethod(self):
    """
    Get for ccp.lims.RefSampleComponent.Composite.assessmentMethod
    """
    dataDict = self.__dict__
    result = dataDict.get('assessmentMethod')
    return result
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccp.lims.RefSampleComponent.Composite
    """

    result = None
    if (startObj.__class__.__name__ == 'MemopsRoot'):
      if (2 != len(fullKey)):
        raise ApiError("""'ccp.lims.RefSampleComponent.Composite'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj0 = startObj
      objKey = fullKey[0]
      obj1 = obj0.__dict__.get('refSampleComponentStores').get(objKey)
      if (obj1 is None):
        obj0.refreshTopObjects('ccp.lims.RefSampleComponent')
        obj1 = obj0.__dict__.get('refSampleComponentStores').get(objKey)

    else:
      if (1 != len(fullKey)):
        raise ApiError("""'ccp.lims.RefSampleComponent.Composite'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj1 = startObj

    if (obj1 is not None):
      if (not (obj1.__dict__.get('isLoaded'))):
        obj1.load()

      objKey = fullKey[-1]
      obj2 = obj1.__dict__.get('components').get(objKey)
      if (isinstance(obj2, Composite)):
        result = obj2

    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation

  getCategories = AbstractComponent.getCategories

  getClassName = memops.api.Implementation.ComplexDataType.getClassName

  getComponentDbRefs = AbstractComponent.getComponentDbRefs

  getCompositeElements = AbstractComponent.getCompositeElements

  getDetails = AbstractComponent.getDetails
  
  def getElements(self):
    """
    Get for ccp.lims.RefSampleComponent.Composite.elements
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('elements').values()
    result = frozenset(tempVar)
    return result

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames

  getFullKey = AbstractComponent.getFullKey

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor
  
  def getInteractions(self):
    """
    Get for ccp.lims.RefSampleComponent.Composite.interactions
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('interactions').values()
    result = frozenset(tempVar)
    return result

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted

  getLabels = AbstractComponent.getLabels

  getLocalKey = AbstractComponent.getLocalKey

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass
  
  def getMolecularMass(self):
    """
    Get for ccp.lims.RefSampleComponent.Composite.molecularMass
    """
    dataDict = self.__dict__
    result = dataDict.get('molecularMass')
    return result
  
  def getMolecularMassMethod(self):
    """
    Get for ccp.lims.RefSampleComponent.Composite.molecularMassMethod
    """
    dataDict = self.__dict__
    result = dataDict.get('molecularMassMethod')
    return result

  getName = AbstractComponent.getName

  getNaturalSource = AbstractComponent.getNaturalSource

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName

  getParent = AbstractComponent.getParent

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName

  getRefSampleComponentStore = AbstractComponent.getRefSampleComponentStore

  getRoot = memops.api.Implementation.MemopsObject.getRoot

  getSynonyms = AbstractComponent.getSynonyms

  getTopObject = memops.api.Implementation.DataObject.getTopObject

  newComponentDbRef = AbstractComponent.newComponentDbRef
  
  def newCompositeElement(self, **attrlinks):
    """
    Factory function to create ccp.lims.RefSampleComponent.CompositeElement
    """
    return CompositeElement(self, **attrlinks)
  
  def newCompositeInteraction(self, **attrlinks):
    """
    Factory function to create
    ccp.lims.RefSampleComponent.CompositeInteraction
    """
    return CompositeInteraction(self, **attrlinks)

  newLabel = AbstractComponent.newLabel

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData

  removeCategory = AbstractComponent.removeCategory

  removeSynonym = AbstractComponent.removeSynonym
  
  def set(self, name, value):
    """
    SetAttr for ccp.lims.RefSampleComponent.Composite
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData
  
  def setAssessmentMethod(self, value):
    """
    Set for ccp.lims.RefSampleComponent.Composite.assessmentMethod
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setAssessmentMethod:
         memops.Implementation.Text input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 254):
        raise ApiError("""%s.setAssessmentMethod:
         memops.Implementation.Text maximum length is 254 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setAssessmentMethod:
         memops.Implementation.Text: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('assessmentMethod')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setAssessmentMethod:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setAssessmentMethod:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['assessmentMethod'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setAssessmentMethod')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  setCategories = AbstractComponent.setCategories

  setCompositeElements = AbstractComponent.setCompositeElements

  setDetails = AbstractComponent.setDetails
  
  def setMolecularMass(self, value):
    """
    Set for ccp.lims.RefSampleComponent.Composite.molecularMass
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.Float.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Float.create(value)
      else:
        raise ApiError("""%s.setMolecularMass:
         memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value - value == 0.0)):
        raise ApiError("""%s.setMolecularMass:
         Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('molecularMass')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setMolecularMass:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setMolecularMass:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['molecularMass'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setMolecularMass')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setMolecularMassMethod(self, value):
    """
    Set for ccp.lims.RefSampleComponent.Composite.molecularMassMethod
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setMolecularMassMethod:
         memops.Implementation.Text input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 254):
        raise ApiError("""%s.setMolecularMassMethod:
         memops.Implementation.Text maximum length is 254 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setMolecularMassMethod:
         memops.Implementation.Text: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('molecularMassMethod')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setMolecularMassMethod:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setMolecularMassMethod:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['molecularMassMethod'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setMolecularMassMethod')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  setName = AbstractComponent.setName

  setNaturalSource = AbstractComponent.setNaturalSource

  setSynonyms = AbstractComponent.setSynonyms

  sortedCategories = AbstractComponent.sortedCategories

  sortedComponentDbRefs = AbstractComponent.sortedComponentDbRefs

  sortedCompositeElements = AbstractComponent.sortedCompositeElements
  
  def sortedElements(self):
    """
    Sorted for ccp.lims.RefSampleComponent.Composite.elements
    """
    dataDict = self.__dict__
    sortdd = dataDict.get('elements')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result
  
  def sortedInteractions(self):
    """
    Sorted for ccp.lims.RefSampleComponent.Composite.interactions
    """
    dataDict = self.__dict__
    sortdd = dataDict.get('interactions')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result

  sortedLabels = AbstractComponent.sortedLabels

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  applicationData = memops.api.Implementation.DataObject.applicationData
  
  assessmentMethod = property(getAssessmentMethod, setAssessmentMethod, None,
  r"""The assessment Method used to determine the composite.
  """)

  className = memops.api.Implementation.ComplexDataType.className

  details = AbstractComponent.details

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted

  metaclass = memops.api.Implementation.ComplexDataType.metaclass
  
  molecularMass = property(getMolecularMass, setMolecularMass, None,
  r"""The experimental molecular mass in dalton (Da).
  """)
  
  molecularMassMethod = property(getMolecularMassMethod, setMolecularMassMethod, None,
  r"""The method used to determine the experimental molecular mass.
  """)

  name = AbstractComponent.name

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName

  synonyms = AbstractComponent.synonyms

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess

  categories = AbstractComponent.categories

  componentDbRefs = AbstractComponent.componentDbRefs

  compositeElements = AbstractComponent.compositeElements
  
  elements = property(getElements,  None, None,
  r"""child link to class CompositeElement
  """)
  
  interactions = property(getInteractions,  None, None,
  r"""child link to class CompositeInteraction
  """)

  labels = AbstractComponent.labels

  naturalSource = AbstractComponent.naturalSource

  parent = AbstractComponent.parent

  refSampleComponentStore = AbstractComponent.refSampleComponentStore

  root = memops.api.Implementation.MemopsObject.root

  topObject = memops.api.Implementation.DataObject.topObject

###############################################################################
class RestrictionEnzyme(MolComponent):
  r"""This is a subtype of MolComponent. Restriction enzymes are known to 
cleave nucleic acide sequences at certain positions.
  """
  #   from data model element ccp.lims.RefSampleComponent.RestrictionEnzyme revision ?
  _metaclass = metaPackage.getElement('RestrictionEnzyme')
  _packageName = 'ccp.lims.RefSampleComponent'
  _packageShortName = 'REFS'
  _fieldNames = ('applicationData', 'casNum', 'className', 'cutOffsetCoding', 'cutOffsetNonCoding', 'details', 'empiricalFormula', 'fieldNames', 'inConstructor', 'isDeleted', 'metaclass', 'molType', 'molecularMass', 'name', 'packageName', 'packageShortName', 'qualifiedName', 'recogSeqCoding', 'recogSeqNonCoding', 'seqDetails', 'seqString', 'synonyms', 'access', 'activeAccess', 'blueprintComponents', 'categories', 'componentDbRefs', 'compositeElements', 'labeledMixture', 'labels', 'molCompFeatures', 'molecule', 'naturalSource', 'nucTargets', 'parent', 'protTargets', 'refMolCompFeatures', 'refSampleComponentStore', 'relatedExpBlueprints', 'root', 'specificLabelGroups', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for ccp.lims.RefSampleComponent.RestrictionEnzyme
    """
    dataDict = self.__dict__
    dataDict['refSampleComponentStore'] = parent
    if (not isinstance(parent, RefSampleComponentStore)):
      raise ApiError("""%s.__init__:
       value is not of class ccp.lims.RefSampleComponent.RefSampleComponentStore""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = parent.__dict__.get('topObject')
    dataDict['topObject'] = topObject

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    if (notIsReading):
      if (not (topObject.__dict__.get('isModifiable'))):
        raise ApiError("""%s.__init__:
         Storage not modifiable""" % self.qualifiedName
         + ": %s" % (topObject,)
        )

    try:
      if (not ((parent.__dict__.get('isLoaded') or parent.__dict__.get('isReading')))):
        parent.load()

      dataDict['applicationData'] = list()
      dataDict['casNum'] = None
      dataDict['cutOffsetCoding'] = None
      dataDict['cutOffsetNonCoding'] = None
      dataDict['details'] = None
      dataDict['empiricalFormula'] = None
      dataDict['molType'] = None
      dataDict['molecularMass'] = None
      dataDict['name'] = None
      dataDict['recogSeqCoding'] = None
      dataDict['recogSeqNonCoding'] = None
      dataDict['seqDetails'] = None
      dataDict['seqString'] = None
      dataDict['synonyms'] = list()
      dataDict['access'] = None
      dataDict['blueprintComponents'] = set()
      dataDict['categories'] = set()
      dataDict['componentDbRefs'] = {}
      dataDict['compositeElements'] = set()
      dataDict['labeledMixture'] = None
      dataDict['labels'] = {}
      dataDict['molCompFeatures'] = {}
      dataDict['molecule'] = None
      dataDict['naturalSource'] = None
      dataDict['nucTargets'] = set()
      dataDict['protTargets'] = set()
      dataDict['refMolCompFeatures'] = set()
      dataDict['relatedExpBlueprints'] = set()
      dataDict['specificLabelGroups'] = {}

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in ccp.lims.RefSampleComponent.RestrictionEnzyme.__init__"
        del dataDict['inConstructor']
        raise

      serialDict = {}
      serialDict['componentDbRefs'] = 0
      serialDict['labels'] = 0
      serialDict['molCompFeatures'] = 0
      serialDict['specificLabelGroups'] = 0
      dataDict['_serialDict'] = serialDict

      if (notIsReading):
        childrenDict = parent.__dict__.get('components')
        objKey = dataDict.get('name')
        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['name'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notOverride):
        self.checkValid()

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for ccp.lims.RefSampleComponent.RestrictionEnzyme:
       
    determines cascading deletes to follow from delete of object.
       
    *Implementation function* - should be called only by API delete 
    function.
    """
    dataDict = self.__dict__
    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.lims.ExpBlueprint')
    tobjList = root.__dict__.get('expBlueprintStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    blueprintComponents = dataDict.get('blueprintComponents')
    pass
    for blueprintComponent in blueprintComponents:
      topObject = blueprintComponent.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    categories = dataDict.get('categories')
    pass
    for category in categories:
      topObject = category.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    componentDbRefs = dataDict.get('componentDbRefs').values()
    for componentDbRef in componentDbRefs:
      if (not (componentDbRef in objsToBeDeleted)):
        objsToBeDeleted.add(componentDbRef)
        objsToBeChecked.append(componentDbRef)

    compositeElements = dataDict.get('compositeElements')
    for compositeElement in compositeElements:
      if (not (compositeElement in objsToBeDeleted)):
        objsToBeDeleted.add(compositeElement)
        objsToBeChecked.append(compositeElement)

    labeledMixture = dataDict.get('labeledMixture')
    if (labeledMixture is not None):
      topObject = labeledMixture.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    labels = dataDict.get('labels').values()
    for label in labels:
      if (not (label in objsToBeDeleted)):
        objsToBeDeleted.add(label)
        objsToBeChecked.append(label)

    molCompFeatures = dataDict.get('molCompFeatures').values()
    for molCompFeature in molCompFeatures:
      if (not (molCompFeature in objsToBeDeleted)):
        objsToBeDeleted.add(molCompFeature)
        objsToBeChecked.append(molCompFeature)

    molecule = dataDict.get('molecule')
    if (molecule is not None):
      topObject = molecule.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.lims.Target')
    tobjList = root.__dict__.get('targetStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    nucTargets = dataDict.get('nucTargets')
    pass
    for nucTarget in nucTargets:
      topObject = nucTarget.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.lims.Target')
    tobjList = root.__dict__.get('targetStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    protTargets = dataDict.get('protTargets')
    for protTarget in protTargets:
      if (not (protTarget in objsToBeDeleted)):
        objsToBeDeleted.add(protTarget)
        objsToBeChecked.append(protTarget)

    for protTarget in protTargets:
      topObject = protTarget.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.lims.ExpBlueprint')
    tobjList = root.__dict__.get('expBlueprintStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    relatedExpBlueprints = dataDict.get('relatedExpBlueprints')
    pass
    for relatedExpBlueprint in relatedExpBlueprints:
      topObject = relatedExpBlueprint.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    specificLabelGroups = dataDict.get('specificLabelGroups').values()
    for specificLabelGroup in specificLabelGroups:
      if (not (specificLabelGroup in objsToBeDeleted)):
        objsToBeDeleted.add(specificLabelGroup)
        objsToBeChecked.append(specificLabelGroup)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for ccp.lims.RefSampleComponent.RestrictionEnzyme:
    deletes objects
    *Implementation function* - will CORRUPT DATA if called 
    outside the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    for blueprintComponent in dataDict.get('blueprintComponents'):
      if (not (blueprintComponent in objsToBeDeleted)):
        blueprintComponent.__dict__['molComponent'] = None

    for category in dataDict.get('categories'):
      if (not (category in objsToBeDeleted)):
        components = category.__dict__.get('components')
        components.remove(self)

    labeledMixture = dataDict.get('labeledMixture')
    if ((labeledMixture is not None and not (labeledMixture in objsToBeDeleted))):
      molComponents = labeledMixture.__dict__.get('molComponents')
      molComponents.remove(self)

    molecule = dataDict.get('molecule')
    if ((molecule is not None and not (molecule in objsToBeDeleted))):
      molComponents = molecule.__dict__.get('molComponents')
      molComponents.remove(self)

    for nucTarget in dataDict.get('nucTargets'):
      if (not (nucTarget in objsToBeDeleted)):
        nucleicAcids = nucTarget.__dict__.get('nucleicAcids')
        nucleicAcids.remove(self)

    for refMolCompFeature in dataDict.get('refMolCompFeatures'):
      if (not (refMolCompFeature in objsToBeDeleted)):
        refMolCompFeature.__dict__['refMolComponent'] = None

    for relatedExpBlueprint in dataDict.get('relatedExpBlueprints'):
      if (not (relatedExpBlueprint in objsToBeDeleted)):
        trialMolComponents = relatedExpBlueprint.__dict__.get('trialMolComponents')
        trialMolComponents.remove(self)

    refSampleComponentStore = dataDict.get('refSampleComponentStore')
    if (not (refSampleComponentStore in objsToBeDeleted)):
      objKey = dataDict.get('name')
      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = refSampleComponentStore.__dict__.get('components')
        if (self is dd.get(objKey)):
          del dd[objKey]

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData

  addBlueprintComponent = MolComponent.addBlueprintComponent

  addCategory = AbstractComponent.addCategory

  addNucTarget = MolComponent.addNucTarget

  addRefMolCompFeature = MolComponent.addRefMolCompFeature

  addRelatedExpBlueprint = MolComponent.addRelatedExpBlueprint

  addSynonym = AbstractComponent.addSynonym
  
  def checkAllValid(self, complete=False):
    """
    CheckAllValid for ccp.lims.RefSampleComponent.RestrictionEnzyme
    """
    dataDict = self.__dict__
    self.checkValid(complete)
    values = dataDict.get('componentDbRefs').values()
    for value in values:
      value.checkAllValid(complete)

    values = dataDict.get('labels').values()
    for value in values:
      value.checkAllValid(complete)

    values = dataDict.get('molCompFeatures').values()
    for value in values:
      value.checkAllValid(complete)

    values = dataDict.get('specificLabelGroups').values()
    for value in values:
      value.checkAllValid(complete)

  def checkValid(self, complete=False):
    """
    CheckValid for ccp.lims.RefSampleComponent.RestrictionEnzyme
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      objKey = dataDict.get('name')
      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('refSampleComponentStore')
        dd = value.__dict__.get('components')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'refSampleComponentStore' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      # check attributes
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('casNum')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: casNum:
           memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 32):
          raise ApiError("""%s.checkValid: casNum:
           memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: casNum:
           memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.split()) == 1)):
          raise ApiError("""%s.checkValid: casNum:
           Word constraint contains_no_white_space violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('cutOffsetCoding')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.Int.PythonType)):
          pass
        elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
          value = memops.api.Implementation.Int.create(value)
        else:
          raise ApiError("""%s.checkValid: cutOffsetCoding:
           memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('cutOffsetNonCoding')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.Int.PythonType)):
          pass
        elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
          value = memops.api.Implementation.Int.create(value)
        else:
          raise ApiError("""%s.checkValid: cutOffsetNonCoding:
           memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('details')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: details:
           memops.Implementation.String input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('empiricalFormula')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: empiricalFormula:
           memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: empiricalFormula:
           memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: empiricalFormula:
           memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: empiricalFormula:
           Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('molType')
      if (value is not None):
        if (not (value in ['protein', 'DNA', 'RNA', 'DNA/RNA', 'carbohydrate', 'other'])):
          raise ApiError("""%s.checkValid: molType:
           ccp.molecule.Molecule.MolType input is not in enumeration ['protein', 'DNA', 'RNA', 'DNA/RNA', 'carbohydrate', 'other']""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: molType:
           MolType constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('molecularMass')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.Float.PythonType)):
          pass
        elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
          value = memops.api.Implementation.Float.create(value)
        else:
          raise ApiError("""%s.checkValid: molecularMass:
           memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (value - value == 0.0)):
          raise ApiError("""%s.checkValid: molecularMass:
           Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('name')
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: name:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: name:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: name:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: name:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('recogSeqCoding')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: recogSeqCoding:
           memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: recogSeqCoding:
           memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: recogSeqCoding:
           memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: recogSeqCoding:
           Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('recogSeqNonCoding')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: recogSeqNonCoding:
           memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: recogSeqNonCoding:
           memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: recogSeqNonCoding:
           memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: recogSeqNonCoding:
           Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('seqDetails')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: seqDetails:
           memops.Implementation.String input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('seqString')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: seqString:
           memops.Implementation.String input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

      values = dataDict.get('synonyms')
      for value in values:
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: synonyms:
           memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: synonyms:
           memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: synonyms:
           memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: synonyms:
           Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.lims.ExpBlueprint')
      tobjList = root.__dict__.get('expBlueprintStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      values = dataDict.get('blueprintComponents')
      for value in values:
        from ccp.api.lims.ExpBlueprint import BlueprintComponent as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: blueprintComponents:
           value is not of class ccp.lims.ExpBlueprint.BlueprintComponent""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('molComponent')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: blueprintComponents:
           non-reciprocal link blueprintComponents from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: blueprintComponents:
           Link blueprintComponents between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      values = dataDict.get('categories')
      for value in values:
        from ccp.api.lims.Classification import SampleComponentCategory as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: categories:
           value is not of class ccp.lims.Classification.SampleComponentCategory""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('components')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: categories:
           non-reciprocal link categories from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: categories:
           Link categories between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      values = dataDict.get('componentDbRefs').values()
      for value in values:
        if (not isinstance(value, ComponentDbRef)):
          raise ApiError("""%s.checkValid: componentDbRefs:
           value is not of class ccp.lims.RefSampleComponent.ComponentDbRef""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('component')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: componentDbRefs:
           non-reciprocal link componentDbRefs from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      values = dataDict.get('compositeElements')
      for value in values:
        if (not isinstance(value, CompositeElement)):
          raise ApiError("""%s.checkValid: compositeElements:
           value is not of class ccp.lims.RefSampleComponent.CompositeElement""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('component')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: compositeElements:
           non-reciprocal link compositeElements from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: compositeElements:
           Link compositeElements between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('labeledMixture')
      if (value is not None):
        from ccp.api.molecule.LabeledMolecule import LabeledMixture as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: labeledMixture:
           value is not of class ccp.molecule.LabeledMolecule.LabeledMixture""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('molComponents')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: labeledMixture:
           non-reciprocal link labeledMixture from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      values = dataDict.get('labels').values()
      for value in values:
        if (not isinstance(value, Label)):
          raise ApiError("""%s.checkValid: labels:
           value is not of class ccp.lims.RefSampleComponent.Label""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('component')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: labels:
           non-reciprocal link labels from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      values = dataDict.get('molCompFeatures').values()
      for value in values:
        if (not isinstance(value, MolCompFeature)):
          raise ApiError("""%s.checkValid: molCompFeatures:
           value is not of class ccp.lims.RefSampleComponent.MolCompFeature""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('molComponent')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: molCompFeatures:
           non-reciprocal link molCompFeatures from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      value = dataDict.get('molecule')
      if (value is not None):
        from ccp.api.molecule.Molecule import Molecule as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: molecule:
           value is not of class ccp.molecule.Molecule.Molecule""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('molComponents')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: molecule:
           non-reciprocal link molecule from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      value = dataDict.get('naturalSource')
      if (value is not None):
        from ccp.api.general.Taxonomy import NaturalSource as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: naturalSource:
           value is not of class ccp.general.Taxonomy.NaturalSource""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: naturalSource:
           Link naturalSource between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.lims.Target')
      tobjList = root.__dict__.get('targetStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      values = dataDict.get('nucTargets')
      for value in values:
        from ccp.api.lims.Target import Target as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: nucTargets:
           value is not of class ccp.lims.Target.Target""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('nucleicAcids')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: nucTargets:
           non-reciprocal link nucTargets from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: nucTargets:
           Link nucTargets between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.lims.Target')
      tobjList = root.__dict__.get('targetStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      values = dataDict.get('protTargets')
      for value in values:
        from ccp.api.lims.Target import Target as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: protTargets:
           value is not of class ccp.lims.Target.Target""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('protein')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: protTargets:
           non-reciprocal link protTargets from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: protTargets:
           Link protTargets between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      values = dataDict.get('refMolCompFeatures')
      for value in values:
        if (not isinstance(value, MolCompFeature)):
          raise ApiError("""%s.checkValid: refMolCompFeatures:
           value is not of class ccp.lims.RefSampleComponent.MolCompFeature""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('refMolComponent')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: refMolCompFeatures:
           non-reciprocal link refMolCompFeatures from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: refMolCompFeatures:
           Link refMolCompFeatures between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('refSampleComponentStore')
      if (not isinstance(value, RefSampleComponentStore)):
        raise ApiError("""%s.checkValid: refSampleComponentStore:
         value is not of class ccp.lims.RefSampleComponent.RefSampleComponentStore""" % self.qualifiedName
         + ": %s" % (value,)
        )

      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.lims.ExpBlueprint')
      tobjList = root.__dict__.get('expBlueprintStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      values = dataDict.get('relatedExpBlueprints')
      for value in values:
        from ccp.api.lims.ExpBlueprint import BlueprintComponent as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: relatedExpBlueprints:
           value is not of class ccp.lims.ExpBlueprint.BlueprintComponent""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('trialMolComponents')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: relatedExpBlueprints:
           non-reciprocal link relatedExpBlueprints from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: relatedExpBlueprints:
           Link relatedExpBlueprints between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      values = dataDict.get('specificLabelGroups').values()
      for value in values:
        if (not isinstance(value, SpecificLabelGroup)):
          raise ApiError("""%s.checkValid: specificLabelGroups:
           value is not of class ccp.lims.RefSampleComponent.SpecificLabelGroup""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('molComponent')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: specificLabelGroups:
           non-reciprocal link specificLabelGroups from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

    # check explicit class constraints
    if (not (reduce(operator.add, [x.fraction for x in self.specificLabelGroups], 0) <= 1.0)):
      raise ApiError("""%s.checkValid:
       constraint SpecificLabelGroups_add_up_to_less_than_1 violated""" % self.qualifiedName
       + ": %s" % (self,)
      )

    # check attributes
    values = dataDict.get('applicationData')
    for value in values:
      value.checkAllValid(complete)

    value = dataDict.get('casNum')
    value = dataDict.get('cutOffsetCoding')
    value = dataDict.get('cutOffsetNonCoding')
    value = dataDict.get('details')
    value = dataDict.get('empiricalFormula')
    value = dataDict.get('molType')
    value = dataDict.get('molecularMass')
    value = dataDict.get('name')
    if (value is None):
      raise ApiError("""%s.checkValid: name:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('recogSeqCoding')
    value = dataDict.get('recogSeqNonCoding')
    value = dataDict.get('seqDetails')
    value = dataDict.get('seqString')
    values = dataDict.get('synonyms')
    # check roles
    value = dataDict.get('access')
    values = dataDict.get('blueprintComponents')
    values = dataDict.get('categories')
    values = dataDict.get('componentDbRefs').values()
    values = dataDict.get('compositeElements')
    value = dataDict.get('labeledMixture')
    values = dataDict.get('labels').values()
    values = dataDict.get('molCompFeatures').values()
    value = dataDict.get('molecule')
    if (value is not None):
      if (not (value.isFinalised)):
        raise ApiError("""%s.checkValid: molecule:
         molecule constraint Molecule_must_be_finalised violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    value = dataDict.get('naturalSource')
    values = dataDict.get('nucTargets')
    values = dataDict.get('protTargets')
    values = dataDict.get('refMolCompFeatures')
    value = dataDict.get('refSampleComponentStore')
    if (value is None):
      raise ApiError("""%s.checkValid: refSampleComponentStore:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    values = dataDict.get('relatedExpBlueprints')
    values = dataDict.get('specificLabelGroups').values()

  delete = memops.api.Implementation.DataObject.delete

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData

  findAllBlueprintComponents = MolComponent.findAllBlueprintComponents

  findAllCategories = AbstractComponent.findAllCategories

  findAllComponentDbRefs = AbstractComponent.findAllComponentDbRefs

  findAllCompositeElements = AbstractComponent.findAllCompositeElements

  findAllLabels = AbstractComponent.findAllLabels

  findAllMolCompFeatures = MolComponent.findAllMolCompFeatures

  findAllNucTargets = MolComponent.findAllNucTargets

  findAllProtTargets = MolComponent.findAllProtTargets

  findAllRefMolCompFeatures = MolComponent.findAllRefMolCompFeatures

  findAllRelatedExpBlueprints = MolComponent.findAllRelatedExpBlueprints

  findAllSpecificLabelGroups = MolComponent.findAllSpecificLabelGroups

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData

  findFirstBlueprintComponent = MolComponent.findFirstBlueprintComponent

  findFirstCategory = AbstractComponent.findFirstCategory

  findFirstComponentDbRef = AbstractComponent.findFirstComponentDbRef

  findFirstCompositeElement = AbstractComponent.findFirstCompositeElement

  findFirstLabel = AbstractComponent.findFirstLabel

  findFirstMolCompFeature = MolComponent.findFirstMolCompFeature

  findFirstNucTarget = MolComponent.findFirstNucTarget

  findFirstProtTarget = MolComponent.findFirstProtTarget

  findFirstRefMolCompFeature = MolComponent.findFirstRefMolCompFeature

  findFirstRelatedExpBlueprint = MolComponent.findFirstRelatedExpBlueprint

  findFirstSpecificLabelGroup = MolComponent.findFirstSpecificLabelGroup
  
  def get(self, name):
    """
    GetAttr for ccp.lims.RefSampleComponent.RestrictionEnzyme
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData

  getBlueprintComponents = MolComponent.getBlueprintComponents
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccp.lims.RefSampleComponent.RestrictionEnzyme
    """

    result = None
    if (startObj.__class__.__name__ == 'MemopsRoot'):
      if (2 != len(fullKey)):
        raise ApiError("""'ccp.lims.RefSampleComponent.RestrictionEnzyme'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj0 = startObj
      objKey = fullKey[0]
      obj1 = obj0.__dict__.get('refSampleComponentStores').get(objKey)
      if (obj1 is None):
        obj0.refreshTopObjects('ccp.lims.RefSampleComponent')
        obj1 = obj0.__dict__.get('refSampleComponentStores').get(objKey)

    else:
      if (1 != len(fullKey)):
        raise ApiError("""'ccp.lims.RefSampleComponent.RestrictionEnzyme'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj1 = startObj

    if (obj1 is not None):
      if (not (obj1.__dict__.get('isLoaded'))):
        obj1.load()

      objKey = fullKey[-1]
      obj2 = obj1.__dict__.get('components').get(objKey)
      if (isinstance(obj2, RestrictionEnzyme)):
        result = obj2

    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation

  getCasNum = MolComponent.getCasNum

  getCategories = AbstractComponent.getCategories

  getClassName = memops.api.Implementation.ComplexDataType.getClassName

  getComponentDbRefs = AbstractComponent.getComponentDbRefs

  getCompositeElements = AbstractComponent.getCompositeElements
  
  def getCutOffsetCoding(self):
    """
    Get for ccp.lims.RefSampleComponent.RestrictionEnzyme.cutOffsetCoding
    """
    dataDict = self.__dict__
    result = dataDict.get('cutOffsetCoding')
    return result
  
  def getCutOffsetNonCoding(self):
    """
    Get for ccp.lims.RefSampleComponent.RestrictionEnzyme.cutOffsetNonCoding
    """
    dataDict = self.__dict__
    result = dataDict.get('cutOffsetNonCoding')
    return result

  getDetails = AbstractComponent.getDetails

  getEmpiricalFormula = MolComponent.getEmpiricalFormula

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames

  getFullKey = AbstractComponent.getFullKey

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted

  getLabeledMixture = MolComponent.getLabeledMixture

  getLabels = AbstractComponent.getLabels

  getLocalKey = AbstractComponent.getLocalKey

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass

  getMolCompFeatures = MolComponent.getMolCompFeatures

  getMolType = MolComponent.getMolType

  getMolecularMass = MolComponent.getMolecularMass

  getMolecule = MolComponent.getMolecule

  getName = AbstractComponent.getName

  getNaturalSource = AbstractComponent.getNaturalSource

  getNucTargets = MolComponent.getNucTargets

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName

  getParent = AbstractComponent.getParent

  getProtTargets = MolComponent.getProtTargets

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName
  
  def getRecogSeqCoding(self):
    """
    Get for ccp.lims.RefSampleComponent.RestrictionEnzyme.recogSeqCoding
    """
    dataDict = self.__dict__
    result = dataDict.get('recogSeqCoding')
    return result
  
  def getRecogSeqNonCoding(self):
    """
    Get for ccp.lims.RefSampleComponent.RestrictionEnzyme.recogSeqNonCoding
    """
    dataDict = self.__dict__
    result = dataDict.get('recogSeqNonCoding')
    return result

  getRefMolCompFeatures = MolComponent.getRefMolCompFeatures

  getRefSampleComponentStore = AbstractComponent.getRefSampleComponentStore

  getRelatedExpBlueprints = MolComponent.getRelatedExpBlueprints

  getRoot = memops.api.Implementation.MemopsObject.getRoot

  getSeqDetails = MolComponent.getSeqDetails

  getSeqString = MolComponent.getSeqString

  getSpecificLabelGroups = MolComponent.getSpecificLabelGroups

  getSynonyms = AbstractComponent.getSynonyms

  getTopObject = memops.api.Implementation.DataObject.getTopObject

  newComponentDbRef = AbstractComponent.newComponentDbRef

  newLabel = AbstractComponent.newLabel

  newMolCompFeature = MolComponent.newMolCompFeature

  newSpecificLabelGroup = MolComponent.newSpecificLabelGroup

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData

  removeBlueprintComponent = MolComponent.removeBlueprintComponent

  removeCategory = AbstractComponent.removeCategory

  removeNucTarget = MolComponent.removeNucTarget

  removeRefMolCompFeature = MolComponent.removeRefMolCompFeature

  removeRelatedExpBlueprint = MolComponent.removeRelatedExpBlueprint

  removeSynonym = AbstractComponent.removeSynonym
  
  def set(self, name, value):
    """
    SetAttr for ccp.lims.RefSampleComponent.RestrictionEnzyme
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData

  setBlueprintComponents = MolComponent.setBlueprintComponents

  setCasNum = MolComponent.setCasNum

  setCategories = AbstractComponent.setCategories

  setCompositeElements = AbstractComponent.setCompositeElements
  
  def setCutOffsetCoding(self, value):
    """
    Set for ccp.lims.RefSampleComponent.RestrictionEnzyme.cutOffsetCoding
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.setCutOffsetCoding:
         memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('cutOffsetCoding')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setCutOffsetCoding:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setCutOffsetCoding:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['cutOffsetCoding'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setCutOffsetCoding')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setCutOffsetNonCoding(self, value):
    """
    Set for ccp.lims.RefSampleComponent.RestrictionEnzyme.cutOffsetNonCoding
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.setCutOffsetNonCoding:
         memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('cutOffsetNonCoding')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setCutOffsetNonCoding:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setCutOffsetNonCoding:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['cutOffsetNonCoding'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setCutOffsetNonCoding')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  setDetails = AbstractComponent.setDetails

  setEmpiricalFormula = MolComponent.setEmpiricalFormula

  setLabeledMixture = MolComponent.setLabeledMixture

  setMolType = MolComponent.setMolType

  setMolecularMass = MolComponent.setMolecularMass

  setMolecule = MolComponent.setMolecule

  setName = AbstractComponent.setName

  setNaturalSource = AbstractComponent.setNaturalSource

  setNucTargets = MolComponent.setNucTargets

  setProtTargets = MolComponent.setProtTargets
  
  def setRecogSeqCoding(self, value):
    """
    Set for ccp.lims.RefSampleComponent.RestrictionEnzyme.recogSeqCoding
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setRecogSeqCoding:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.setRecogSeqCoding:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setRecogSeqCoding:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.setRecogSeqCoding:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('recogSeqCoding')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setRecogSeqCoding:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setRecogSeqCoding:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['recogSeqCoding'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setRecogSeqCoding')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setRecogSeqNonCoding(self, value):
    """
    Set for ccp.lims.RefSampleComponent.RestrictionEnzyme.recogSeqNonCoding
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setRecogSeqNonCoding:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.setRecogSeqNonCoding:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setRecogSeqNonCoding:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.setRecogSeqNonCoding:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('recogSeqNonCoding')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setRecogSeqNonCoding:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setRecogSeqNonCoding:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['recogSeqNonCoding'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setRecogSeqNonCoding')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  setRefMolCompFeatures = MolComponent.setRefMolCompFeatures

  setRelatedExpBlueprints = MolComponent.setRelatedExpBlueprints

  setSeqDetails = MolComponent.setSeqDetails

  setSeqString = MolComponent.setSeqString

  setSynonyms = AbstractComponent.setSynonyms

  sortedBlueprintComponents = MolComponent.sortedBlueprintComponents

  sortedCategories = AbstractComponent.sortedCategories

  sortedComponentDbRefs = AbstractComponent.sortedComponentDbRefs

  sortedCompositeElements = AbstractComponent.sortedCompositeElements

  sortedLabels = AbstractComponent.sortedLabels

  sortedMolCompFeatures = MolComponent.sortedMolCompFeatures

  sortedNucTargets = MolComponent.sortedNucTargets

  sortedProtTargets = MolComponent.sortedProtTargets

  sortedRefMolCompFeatures = MolComponent.sortedRefMolCompFeatures

  sortedRelatedExpBlueprints = MolComponent.sortedRelatedExpBlueprints

  sortedSpecificLabelGroups = MolComponent.sortedSpecificLabelGroups

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  applicationData = memops.api.Implementation.DataObject.applicationData

  casNum = MolComponent.casNum

  className = memops.api.Implementation.ComplexDataType.className
  
  cutOffsetCoding = property(getCutOffsetCoding, setCutOffsetCoding, None,
  r"""Enzyme cut offset on coding strand.
  """)
  
  cutOffsetNonCoding = property(getCutOffsetNonCoding, setCutOffsetNonCoding, None,
  r"""Enzyme cut offset on non-coding strand.
  """)

  details = AbstractComponent.details

  empiricalFormula = MolComponent.empiricalFormula

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted

  metaclass = memops.api.Implementation.ComplexDataType.metaclass

  molType = MolComponent.molType

  molecularMass = MolComponent.molecularMass

  name = AbstractComponent.name

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName
  
  recogSeqCoding = property(getRecogSeqCoding, setRecogSeqCoding, None,
  r"""Recognition sequence on coding strand.
  """)
  
  recogSeqNonCoding = property(getRecogSeqNonCoding, setRecogSeqNonCoding, None,
  r"""Recognition sequence on non-coding strand.
  """)

  seqDetails = MolComponent.seqDetails

  seqString = MolComponent.seqString

  synonyms = AbstractComponent.synonyms

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess

  blueprintComponents = MolComponent.blueprintComponents

  categories = AbstractComponent.categories

  componentDbRefs = AbstractComponent.componentDbRefs

  compositeElements = AbstractComponent.compositeElements

  labeledMixture = MolComponent.labeledMixture

  labels = AbstractComponent.labels

  molCompFeatures = MolComponent.molCompFeatures

  molecule = MolComponent.molecule

  naturalSource = AbstractComponent.naturalSource

  nucTargets = MolComponent.nucTargets

  parent = AbstractComponent.parent

  protTargets = MolComponent.protTargets

  refMolCompFeatures = MolComponent.refMolCompFeatures

  refSampleComponentStore = AbstractComponent.refSampleComponentStore

  relatedExpBlueprints = MolComponent.relatedExpBlueprints

  root = memops.api.Implementation.MemopsObject.root

  specificLabelGroups = MolComponent.specificLabelGroups

  topObject = memops.api.Implementation.DataObject.topObject

###############################################################################
class Primer(MolComponent):
  r"""This is a subtype of MolComponent. A specific oligonucleotide or primer 
such as a PCR-primer used to amplify nucleic acid fragments.
  """
  #   from data model element ccp.lims.RefSampleComponent.Primer revision ?
  _metaclass = metaPackage.getElement('Primer')
  _packageName = 'ccp.lims.RefSampleComponent'
  _packageShortName = 'REFS'
  _fieldNames = ('applicationData', 'casNum', 'className', 'details', 'direction', 'empiricalFormula', 'fieldNames', 'inConstructor', 'isDeleted', 'isUniversal', 'meltingTemperature', 'metaclass', 'molType', 'molecularMass', 'name', 'packageName', 'packageShortName', 'qualifiedName', 'seqDetails', 'seqString', 'synonyms', 'access', 'activeAccess', 'blueprintComponents', 'categories', 'componentDbRefs', 'compositeElements', 'labeledMixture', 'labels', 'molCompFeatures', 'molecule', 'naturalSource', 'nucTargets', 'parent', 'protTargets', 'refMolCompFeatures', 'refSampleComponentStore', 'relatedExpBlueprints', 'root', 'specificLabelGroups', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for ccp.lims.RefSampleComponent.Primer
    """
    dataDict = self.__dict__
    dataDict['refSampleComponentStore'] = parent
    if (not isinstance(parent, RefSampleComponentStore)):
      raise ApiError("""%s.__init__:
       value is not of class ccp.lims.RefSampleComponent.RefSampleComponentStore""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = parent.__dict__.get('topObject')
    dataDict['topObject'] = topObject

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    if (notIsReading):
      if (not (topObject.__dict__.get('isModifiable'))):
        raise ApiError("""%s.__init__:
         Storage not modifiable""" % self.qualifiedName
         + ": %s" % (topObject,)
        )

    try:
      if (not ((parent.__dict__.get('isLoaded') or parent.__dict__.get('isReading')))):
        parent.load()

      dataDict['applicationData'] = list()
      dataDict['casNum'] = None
      dataDict['details'] = None
      dataDict['direction'] = None
      dataDict['empiricalFormula'] = None
      dataDict['isUniversal'] = None
      dataDict['meltingTemperature'] = None
      dataDict['molType'] = None
      dataDict['molecularMass'] = None
      dataDict['name'] = None
      dataDict['seqDetails'] = None
      dataDict['seqString'] = None
      dataDict['synonyms'] = list()
      dataDict['access'] = None
      dataDict['blueprintComponents'] = set()
      dataDict['categories'] = set()
      dataDict['componentDbRefs'] = {}
      dataDict['compositeElements'] = set()
      dataDict['labeledMixture'] = None
      dataDict['labels'] = {}
      dataDict['molCompFeatures'] = {}
      dataDict['molecule'] = None
      dataDict['naturalSource'] = None
      dataDict['nucTargets'] = set()
      dataDict['protTargets'] = set()
      dataDict['refMolCompFeatures'] = set()
      dataDict['relatedExpBlueprints'] = set()
      dataDict['specificLabelGroups'] = {}

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in ccp.lims.RefSampleComponent.Primer.__init__"
        del dataDict['inConstructor']
        raise

      serialDict = {}
      serialDict['componentDbRefs'] = 0
      serialDict['labels'] = 0
      serialDict['molCompFeatures'] = 0
      serialDict['specificLabelGroups'] = 0
      dataDict['_serialDict'] = serialDict

      if (notIsReading):
        childrenDict = parent.__dict__.get('components')
        objKey = dataDict.get('name')
        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['name'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notOverride):
        self.checkValid()

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for ccp.lims.RefSampleComponent.Primer:
       determines 
    cascading deletes to follow from delete of object.
       *Implementation 
    function* - should be called only by API delete function.
    """
    dataDict = self.__dict__
    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.lims.ExpBlueprint')
    tobjList = root.__dict__.get('expBlueprintStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    blueprintComponents = dataDict.get('blueprintComponents')
    pass
    for blueprintComponent in blueprintComponents:
      topObject = blueprintComponent.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    categories = dataDict.get('categories')
    pass
    for category in categories:
      topObject = category.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    componentDbRefs = dataDict.get('componentDbRefs').values()
    for componentDbRef in componentDbRefs:
      if (not (componentDbRef in objsToBeDeleted)):
        objsToBeDeleted.add(componentDbRef)
        objsToBeChecked.append(componentDbRef)

    compositeElements = dataDict.get('compositeElements')
    for compositeElement in compositeElements:
      if (not (compositeElement in objsToBeDeleted)):
        objsToBeDeleted.add(compositeElement)
        objsToBeChecked.append(compositeElement)

    labeledMixture = dataDict.get('labeledMixture')
    if (labeledMixture is not None):
      topObject = labeledMixture.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    labels = dataDict.get('labels').values()
    for label in labels:
      if (not (label in objsToBeDeleted)):
        objsToBeDeleted.add(label)
        objsToBeChecked.append(label)

    molCompFeatures = dataDict.get('molCompFeatures').values()
    for molCompFeature in molCompFeatures:
      if (not (molCompFeature in objsToBeDeleted)):
        objsToBeDeleted.add(molCompFeature)
        objsToBeChecked.append(molCompFeature)

    molecule = dataDict.get('molecule')
    if (molecule is not None):
      topObject = molecule.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.lims.Target')
    tobjList = root.__dict__.get('targetStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    nucTargets = dataDict.get('nucTargets')
    pass
    for nucTarget in nucTargets:
      topObject = nucTarget.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.lims.Target')
    tobjList = root.__dict__.get('targetStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    protTargets = dataDict.get('protTargets')
    for protTarget in protTargets:
      if (not (protTarget in objsToBeDeleted)):
        objsToBeDeleted.add(protTarget)
        objsToBeChecked.append(protTarget)

    for protTarget in protTargets:
      topObject = protTarget.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.lims.ExpBlueprint')
    tobjList = root.__dict__.get('expBlueprintStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    relatedExpBlueprints = dataDict.get('relatedExpBlueprints')
    pass
    for relatedExpBlueprint in relatedExpBlueprints:
      topObject = relatedExpBlueprint.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    specificLabelGroups = dataDict.get('specificLabelGroups').values()
    for specificLabelGroup in specificLabelGroups:
      if (not (specificLabelGroup in objsToBeDeleted)):
        objsToBeDeleted.add(specificLabelGroup)
        objsToBeChecked.append(specificLabelGroup)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for ccp.lims.RefSampleComponent.Primer:   deletes
    objects
    *Implementation function* - will CORRUPT DATA if called outside 
    the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    for blueprintComponent in dataDict.get('blueprintComponents'):
      if (not (blueprintComponent in objsToBeDeleted)):
        blueprintComponent.__dict__['molComponent'] = None

    for category in dataDict.get('categories'):
      if (not (category in objsToBeDeleted)):
        components = category.__dict__.get('components')
        components.remove(self)

    labeledMixture = dataDict.get('labeledMixture')
    if ((labeledMixture is not None and not (labeledMixture in objsToBeDeleted))):
      molComponents = labeledMixture.__dict__.get('molComponents')
      molComponents.remove(self)

    molecule = dataDict.get('molecule')
    if ((molecule is not None and not (molecule in objsToBeDeleted))):
      molComponents = molecule.__dict__.get('molComponents')
      molComponents.remove(self)

    for nucTarget in dataDict.get('nucTargets'):
      if (not (nucTarget in objsToBeDeleted)):
        nucleicAcids = nucTarget.__dict__.get('nucleicAcids')
        nucleicAcids.remove(self)

    for refMolCompFeature in dataDict.get('refMolCompFeatures'):
      if (not (refMolCompFeature in objsToBeDeleted)):
        refMolCompFeature.__dict__['refMolComponent'] = None

    for relatedExpBlueprint in dataDict.get('relatedExpBlueprints'):
      if (not (relatedExpBlueprint in objsToBeDeleted)):
        trialMolComponents = relatedExpBlueprint.__dict__.get('trialMolComponents')
        trialMolComponents.remove(self)

    refSampleComponentStore = dataDict.get('refSampleComponentStore')
    if (not (refSampleComponentStore in objsToBeDeleted)):
      objKey = dataDict.get('name')
      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = refSampleComponentStore.__dict__.get('components')
        if (self is dd.get(objKey)):
          del dd[objKey]

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData

  addBlueprintComponent = MolComponent.addBlueprintComponent

  addCategory = AbstractComponent.addCategory

  addNucTarget = MolComponent.addNucTarget

  addRefMolCompFeature = MolComponent.addRefMolCompFeature

  addRelatedExpBlueprint = MolComponent.addRelatedExpBlueprint

  addSynonym = AbstractComponent.addSynonym
  
  def checkAllValid(self, complete=False):
    """
    CheckAllValid for ccp.lims.RefSampleComponent.Primer
    """
    dataDict = self.__dict__
    self.checkValid(complete)
    values = dataDict.get('componentDbRefs').values()
    for value in values:
      value.checkAllValid(complete)

    values = dataDict.get('labels').values()
    for value in values:
      value.checkAllValid(complete)

    values = dataDict.get('molCompFeatures').values()
    for value in values:
      value.checkAllValid(complete)

    values = dataDict.get('specificLabelGroups').values()
    for value in values:
      value.checkAllValid(complete)

  def checkValid(self, complete=False):
    """
    CheckValid for ccp.lims.RefSampleComponent.Primer
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      objKey = dataDict.get('name')
      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('refSampleComponentStore')
        dd = value.__dict__.get('components')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'refSampleComponentStore' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      # check attributes
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('casNum')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: casNum:
           memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 32):
          raise ApiError("""%s.checkValid: casNum:
           memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: casNum:
           memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.split()) == 1)):
          raise ApiError("""%s.checkValid: casNum:
           Word constraint contains_no_white_space violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('details')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: details:
           memops.Implementation.String input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('direction')
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: direction:
         memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 32):
        raise ApiError("""%s.checkValid: direction:
         memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: direction:
         memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.checkValid: direction:
         Word constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('empiricalFormula')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: empiricalFormula:
           memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: empiricalFormula:
           memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: empiricalFormula:
           memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: empiricalFormula:
           Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('isUniversal')
      if (not (value in [True, False])):
        raise ApiError("""%s.checkValid: isUniversal:
         memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('meltingTemperature')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.Float.PythonType)):
          pass
        elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
          value = memops.api.Implementation.Float.create(value)
        else:
          raise ApiError("""%s.checkValid: meltingTemperature:
           memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (value - value == 0.0)):
          raise ApiError("""%s.checkValid: meltingTemperature:
           Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('molType')
      if (value is not None):
        if (not (value in ['protein', 'DNA', 'RNA', 'DNA/RNA', 'carbohydrate', 'other'])):
          raise ApiError("""%s.checkValid: molType:
           ccp.molecule.Molecule.MolType input is not in enumeration ['protein', 'DNA', 'RNA', 'DNA/RNA', 'carbohydrate', 'other']""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: molType:
           MolType constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('molecularMass')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.Float.PythonType)):
          pass
        elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
          value = memops.api.Implementation.Float.create(value)
        else:
          raise ApiError("""%s.checkValid: molecularMass:
           memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (value - value == 0.0)):
          raise ApiError("""%s.checkValid: molecularMass:
           Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('name')
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: name:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: name:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: name:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: name:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('seqDetails')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: seqDetails:
           memops.Implementation.String input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('seqString')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: seqString:
           memops.Implementation.String input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

      values = dataDict.get('synonyms')
      for value in values:
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: synonyms:
           memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: synonyms:
           memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: synonyms:
           memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: synonyms:
           Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.lims.ExpBlueprint')
      tobjList = root.__dict__.get('expBlueprintStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      values = dataDict.get('blueprintComponents')
      for value in values:
        from ccp.api.lims.ExpBlueprint import BlueprintComponent as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: blueprintComponents:
           value is not of class ccp.lims.ExpBlueprint.BlueprintComponent""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('molComponent')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: blueprintComponents:
           non-reciprocal link blueprintComponents from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: blueprintComponents:
           Link blueprintComponents between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      values = dataDict.get('categories')
      for value in values:
        from ccp.api.lims.Classification import SampleComponentCategory as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: categories:
           value is not of class ccp.lims.Classification.SampleComponentCategory""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('components')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: categories:
           non-reciprocal link categories from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: categories:
           Link categories between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      values = dataDict.get('componentDbRefs').values()
      for value in values:
        if (not isinstance(value, ComponentDbRef)):
          raise ApiError("""%s.checkValid: componentDbRefs:
           value is not of class ccp.lims.RefSampleComponent.ComponentDbRef""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('component')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: componentDbRefs:
           non-reciprocal link componentDbRefs from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      values = dataDict.get('compositeElements')
      for value in values:
        if (not isinstance(value, CompositeElement)):
          raise ApiError("""%s.checkValid: compositeElements:
           value is not of class ccp.lims.RefSampleComponent.CompositeElement""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('component')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: compositeElements:
           non-reciprocal link compositeElements from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: compositeElements:
           Link compositeElements between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('labeledMixture')
      if (value is not None):
        from ccp.api.molecule.LabeledMolecule import LabeledMixture as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: labeledMixture:
           value is not of class ccp.molecule.LabeledMolecule.LabeledMixture""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('molComponents')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: labeledMixture:
           non-reciprocal link labeledMixture from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      values = dataDict.get('labels').values()
      for value in values:
        if (not isinstance(value, Label)):
          raise ApiError("""%s.checkValid: labels:
           value is not of class ccp.lims.RefSampleComponent.Label""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('component')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: labels:
           non-reciprocal link labels from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      values = dataDict.get('molCompFeatures').values()
      for value in values:
        if (not isinstance(value, MolCompFeature)):
          raise ApiError("""%s.checkValid: molCompFeatures:
           value is not of class ccp.lims.RefSampleComponent.MolCompFeature""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('molComponent')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: molCompFeatures:
           non-reciprocal link molCompFeatures from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      value = dataDict.get('molecule')
      if (value is not None):
        from ccp.api.molecule.Molecule import Molecule as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: molecule:
           value is not of class ccp.molecule.Molecule.Molecule""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('molComponents')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: molecule:
           non-reciprocal link molecule from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      value = dataDict.get('naturalSource')
      if (value is not None):
        from ccp.api.general.Taxonomy import NaturalSource as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: naturalSource:
           value is not of class ccp.general.Taxonomy.NaturalSource""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: naturalSource:
           Link naturalSource between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.lims.Target')
      tobjList = root.__dict__.get('targetStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      values = dataDict.get('nucTargets')
      for value in values:
        from ccp.api.lims.Target import Target as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: nucTargets:
           value is not of class ccp.lims.Target.Target""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('nucleicAcids')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: nucTargets:
           non-reciprocal link nucTargets from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: nucTargets:
           Link nucTargets between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.lims.Target')
      tobjList = root.__dict__.get('targetStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      values = dataDict.get('protTargets')
      for value in values:
        from ccp.api.lims.Target import Target as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: protTargets:
           value is not of class ccp.lims.Target.Target""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('protein')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: protTargets:
           non-reciprocal link protTargets from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: protTargets:
           Link protTargets between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      values = dataDict.get('refMolCompFeatures')
      for value in values:
        if (not isinstance(value, MolCompFeature)):
          raise ApiError("""%s.checkValid: refMolCompFeatures:
           value is not of class ccp.lims.RefSampleComponent.MolCompFeature""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('refMolComponent')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: refMolCompFeatures:
           non-reciprocal link refMolCompFeatures from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: refMolCompFeatures:
           Link refMolCompFeatures between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('refSampleComponentStore')
      if (not isinstance(value, RefSampleComponentStore)):
        raise ApiError("""%s.checkValid: refSampleComponentStore:
         value is not of class ccp.lims.RefSampleComponent.RefSampleComponentStore""" % self.qualifiedName
         + ": %s" % (value,)
        )

      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.lims.ExpBlueprint')
      tobjList = root.__dict__.get('expBlueprintStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      values = dataDict.get('relatedExpBlueprints')
      for value in values:
        from ccp.api.lims.ExpBlueprint import BlueprintComponent as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: relatedExpBlueprints:
           value is not of class ccp.lims.ExpBlueprint.BlueprintComponent""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('trialMolComponents')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: relatedExpBlueprints:
           non-reciprocal link relatedExpBlueprints from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: relatedExpBlueprints:
           Link relatedExpBlueprints between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      values = dataDict.get('specificLabelGroups').values()
      for value in values:
        if (not isinstance(value, SpecificLabelGroup)):
          raise ApiError("""%s.checkValid: specificLabelGroups:
           value is not of class ccp.lims.RefSampleComponent.SpecificLabelGroup""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('molComponent')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: specificLabelGroups:
           non-reciprocal link specificLabelGroups from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

    # check explicit class constraints
    if (not (reduce(operator.add, [x.fraction for x in self.specificLabelGroups], 0) <= 1.0)):
      raise ApiError("""%s.checkValid:
       constraint SpecificLabelGroups_add_up_to_less_than_1 violated""" % self.qualifiedName
       + ": %s" % (self,)
      )

    # check attributes
    values = dataDict.get('applicationData')
    for value in values:
      value.checkAllValid(complete)

    value = dataDict.get('casNum')
    value = dataDict.get('details')
    value = dataDict.get('direction')
    if (value is None):
      raise ApiError("""%s.checkValid: direction:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('empiricalFormula')
    value = dataDict.get('isUniversal')
    if (value is None):
      raise ApiError("""%s.checkValid: isUniversal:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('meltingTemperature')
    value = dataDict.get('molType')
    value = dataDict.get('molecularMass')
    value = dataDict.get('name')
    if (value is None):
      raise ApiError("""%s.checkValid: name:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('seqDetails')
    value = dataDict.get('seqString')
    values = dataDict.get('synonyms')
    # check roles
    value = dataDict.get('access')
    values = dataDict.get('blueprintComponents')
    values = dataDict.get('categories')
    values = dataDict.get('componentDbRefs').values()
    values = dataDict.get('compositeElements')
    value = dataDict.get('labeledMixture')
    values = dataDict.get('labels').values()
    values = dataDict.get('molCompFeatures').values()
    value = dataDict.get('molecule')
    if (value is not None):
      if (not (value.isFinalised)):
        raise ApiError("""%s.checkValid: molecule:
         molecule constraint Molecule_must_be_finalised violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    value = dataDict.get('naturalSource')
    values = dataDict.get('nucTargets')
    values = dataDict.get('protTargets')
    values = dataDict.get('refMolCompFeatures')
    value = dataDict.get('refSampleComponentStore')
    if (value is None):
      raise ApiError("""%s.checkValid: refSampleComponentStore:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    values = dataDict.get('relatedExpBlueprints')
    values = dataDict.get('specificLabelGroups').values()

  delete = memops.api.Implementation.DataObject.delete

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData

  findAllBlueprintComponents = MolComponent.findAllBlueprintComponents

  findAllCategories = AbstractComponent.findAllCategories

  findAllComponentDbRefs = AbstractComponent.findAllComponentDbRefs

  findAllCompositeElements = AbstractComponent.findAllCompositeElements

  findAllLabels = AbstractComponent.findAllLabels

  findAllMolCompFeatures = MolComponent.findAllMolCompFeatures

  findAllNucTargets = MolComponent.findAllNucTargets

  findAllProtTargets = MolComponent.findAllProtTargets

  findAllRefMolCompFeatures = MolComponent.findAllRefMolCompFeatures

  findAllRelatedExpBlueprints = MolComponent.findAllRelatedExpBlueprints

  findAllSpecificLabelGroups = MolComponent.findAllSpecificLabelGroups

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData

  findFirstBlueprintComponent = MolComponent.findFirstBlueprintComponent

  findFirstCategory = AbstractComponent.findFirstCategory

  findFirstComponentDbRef = AbstractComponent.findFirstComponentDbRef

  findFirstCompositeElement = AbstractComponent.findFirstCompositeElement

  findFirstLabel = AbstractComponent.findFirstLabel

  findFirstMolCompFeature = MolComponent.findFirstMolCompFeature

  findFirstNucTarget = MolComponent.findFirstNucTarget

  findFirstProtTarget = MolComponent.findFirstProtTarget

  findFirstRefMolCompFeature = MolComponent.findFirstRefMolCompFeature

  findFirstRelatedExpBlueprint = MolComponent.findFirstRelatedExpBlueprint

  findFirstSpecificLabelGroup = MolComponent.findFirstSpecificLabelGroup
  
  def get(self, name):
    """
    GetAttr for ccp.lims.RefSampleComponent.Primer
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData

  getBlueprintComponents = MolComponent.getBlueprintComponents
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccp.lims.RefSampleComponent.Primer
    """

    result = None
    if (startObj.__class__.__name__ == 'MemopsRoot'):
      if (2 != len(fullKey)):
        raise ApiError("""'ccp.lims.RefSampleComponent.Primer'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj0 = startObj
      objKey = fullKey[0]
      obj1 = obj0.__dict__.get('refSampleComponentStores').get(objKey)
      if (obj1 is None):
        obj0.refreshTopObjects('ccp.lims.RefSampleComponent')
        obj1 = obj0.__dict__.get('refSampleComponentStores').get(objKey)

    else:
      if (1 != len(fullKey)):
        raise ApiError("""'ccp.lims.RefSampleComponent.Primer'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj1 = startObj

    if (obj1 is not None):
      if (not (obj1.__dict__.get('isLoaded'))):
        obj1.load()

      objKey = fullKey[-1]
      obj2 = obj1.__dict__.get('components').get(objKey)
      if (isinstance(obj2, Primer)):
        result = obj2

    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation

  getCasNum = MolComponent.getCasNum

  getCategories = AbstractComponent.getCategories

  getClassName = memops.api.Implementation.ComplexDataType.getClassName

  getComponentDbRefs = AbstractComponent.getComponentDbRefs

  getCompositeElements = AbstractComponent.getCompositeElements

  getDetails = AbstractComponent.getDetails
  
  def getDirection(self):
    """
    Get for ccp.lims.RefSampleComponent.Primer.direction
    """
    dataDict = self.__dict__
    result = dataDict.get('direction')
    return result

  getEmpiricalFormula = MolComponent.getEmpiricalFormula

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames

  getFullKey = AbstractComponent.getFullKey

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted
  
  def getIsUniversal(self):
    """
    Get for ccp.lims.RefSampleComponent.Primer.isUniversal
    """
    dataDict = self.__dict__
    result = dataDict.get('isUniversal')
    return result

  getLabeledMixture = MolComponent.getLabeledMixture

  getLabels = AbstractComponent.getLabels

  getLocalKey = AbstractComponent.getLocalKey
  
  def getMeltingTemperature(self):
    """
    Get for ccp.lims.RefSampleComponent.Primer.meltingTemperature
    """
    dataDict = self.__dict__
    result = dataDict.get('meltingTemperature')
    return result

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass

  getMolCompFeatures = MolComponent.getMolCompFeatures

  getMolType = MolComponent.getMolType

  getMolecularMass = MolComponent.getMolecularMass

  getMolecule = MolComponent.getMolecule

  getName = AbstractComponent.getName

  getNaturalSource = AbstractComponent.getNaturalSource

  getNucTargets = MolComponent.getNucTargets

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName

  getParent = AbstractComponent.getParent

  getProtTargets = MolComponent.getProtTargets

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName

  getRefMolCompFeatures = MolComponent.getRefMolCompFeatures

  getRefSampleComponentStore = AbstractComponent.getRefSampleComponentStore

  getRelatedExpBlueprints = MolComponent.getRelatedExpBlueprints

  getRoot = memops.api.Implementation.MemopsObject.getRoot

  getSeqDetails = MolComponent.getSeqDetails

  getSeqString = MolComponent.getSeqString

  getSpecificLabelGroups = MolComponent.getSpecificLabelGroups

  getSynonyms = AbstractComponent.getSynonyms

  getTopObject = memops.api.Implementation.DataObject.getTopObject

  newComponentDbRef = AbstractComponent.newComponentDbRef

  newLabel = AbstractComponent.newLabel

  newMolCompFeature = MolComponent.newMolCompFeature

  newSpecificLabelGroup = MolComponent.newSpecificLabelGroup

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData

  removeBlueprintComponent = MolComponent.removeBlueprintComponent

  removeCategory = AbstractComponent.removeCategory

  removeNucTarget = MolComponent.removeNucTarget

  removeRefMolCompFeature = MolComponent.removeRefMolCompFeature

  removeRelatedExpBlueprint = MolComponent.removeRelatedExpBlueprint

  removeSynonym = AbstractComponent.removeSynonym
  
  def set(self, name, value):
    """
    SetAttr for ccp.lims.RefSampleComponent.Primer
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData

  setBlueprintComponents = MolComponent.setBlueprintComponents

  setCasNum = MolComponent.setCasNum

  setCategories = AbstractComponent.setCategories

  setCompositeElements = AbstractComponent.setCompositeElements

  setDetails = AbstractComponent.setDetails
  
  def setDirection(self, value):
    """
    Set for ccp.lims.RefSampleComponent.Primer.direction
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.setDirection:
       memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 32):
      raise ApiError("""%s.setDirection:
       memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.setDirection:
       memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.split()) == 1)):
      raise ApiError("""%s.setDirection:
       Word constraint contains_no_white_space violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('direction')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setDirection:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setDirection:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setDirection:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['direction'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setDirection')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  setEmpiricalFormula = MolComponent.setEmpiricalFormula
  
  def setIsUniversal(self, value):
    """
    Set for ccp.lims.RefSampleComponent.Primer.isUniversal
    """
    dataDict = self.__dict__
    if (not (value in [True, False])):
      raise ApiError("""%s.setIsUniversal:
       memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('isUniversal')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setIsUniversal:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setIsUniversal:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setIsUniversal:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['isUniversal'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setIsUniversal')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  setLabeledMixture = MolComponent.setLabeledMixture
  
  def setMeltingTemperature(self, value):
    """
    Set for ccp.lims.RefSampleComponent.Primer.meltingTemperature
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.Float.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Float.create(value)
      else:
        raise ApiError("""%s.setMeltingTemperature:
         memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value - value == 0.0)):
        raise ApiError("""%s.setMeltingTemperature:
         Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('meltingTemperature')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setMeltingTemperature:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setMeltingTemperature:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['meltingTemperature'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setMeltingTemperature')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  setMolType = MolComponent.setMolType

  setMolecularMass = MolComponent.setMolecularMass

  setMolecule = MolComponent.setMolecule

  setName = AbstractComponent.setName

  setNaturalSource = AbstractComponent.setNaturalSource

  setNucTargets = MolComponent.setNucTargets

  setProtTargets = MolComponent.setProtTargets

  setRefMolCompFeatures = MolComponent.setRefMolCompFeatures

  setRelatedExpBlueprints = MolComponent.setRelatedExpBlueprints

  setSeqDetails = MolComponent.setSeqDetails

  setSeqString = MolComponent.setSeqString

  setSynonyms = AbstractComponent.setSynonyms

  sortedBlueprintComponents = MolComponent.sortedBlueprintComponents

  sortedCategories = AbstractComponent.sortedCategories

  sortedComponentDbRefs = AbstractComponent.sortedComponentDbRefs

  sortedCompositeElements = AbstractComponent.sortedCompositeElements

  sortedLabels = AbstractComponent.sortedLabels

  sortedMolCompFeatures = MolComponent.sortedMolCompFeatures

  sortedNucTargets = MolComponent.sortedNucTargets

  sortedProtTargets = MolComponent.sortedProtTargets

  sortedRefMolCompFeatures = MolComponent.sortedRefMolCompFeatures

  sortedRelatedExpBlueprints = MolComponent.sortedRelatedExpBlueprints

  sortedSpecificLabelGroups = MolComponent.sortedSpecificLabelGroups

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  applicationData = memops.api.Implementation.DataObject.applicationData

  casNum = MolComponent.casNum

  className = memops.api.Implementation.ComplexDataType.className

  details = AbstractComponent.details
  
  direction = property(getDirection, setDirection, None,
  r"""Which direction? 5' or 3'.
  """)

  empiricalFormula = MolComponent.empiricalFormula

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted
  
  isUniversal = property(getIsUniversal, setIsUniversal, None,
  r"""Is universal for all polymer molecules?
  """)
  
  meltingTemperature = property(getMeltingTemperature, setMeltingTemperature, None,
  r"""The melting temperature at which this primer is used.
  """)

  metaclass = memops.api.Implementation.ComplexDataType.metaclass

  molType = MolComponent.molType

  molecularMass = MolComponent.molecularMass

  name = AbstractComponent.name

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName

  seqDetails = MolComponent.seqDetails

  seqString = MolComponent.seqString

  synonyms = AbstractComponent.synonyms

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess

  blueprintComponents = MolComponent.blueprintComponents

  categories = AbstractComponent.categories

  componentDbRefs = AbstractComponent.componentDbRefs

  compositeElements = AbstractComponent.compositeElements

  labeledMixture = MolComponent.labeledMixture

  labels = AbstractComponent.labels

  molCompFeatures = MolComponent.molCompFeatures

  molecule = MolComponent.molecule

  naturalSource = AbstractComponent.naturalSource

  nucTargets = MolComponent.nucTargets

  parent = AbstractComponent.parent

  protTargets = MolComponent.protTargets

  refMolCompFeatures = MolComponent.refMolCompFeatures

  refSampleComponentStore = AbstractComponent.refSampleComponentStore

  relatedExpBlueprints = MolComponent.relatedExpBlueprints

  root = memops.api.Implementation.MemopsObject.root

  specificLabelGroups = MolComponent.specificLabelGroups

  topObject = memops.api.Implementation.DataObject.topObject

###############################################################################
class Construct(MolComponent):
  r"""This is a subtype of MolComponent. It is used to summarise information 
about a construct such as an expression vector plasmid.
  """
  #   from data model element ccp.lims.RefSampleComponent.Construct revision ?
  _metaclass = metaPackage.getElement('Construct')
  _packageName = 'ccp.lims.RefSampleComponent'
  _packageShortName = 'REFS'
  _fieldNames = ('applicationData', 'casNum', 'className', 'constructStatus', 'details', 'empiricalFormula', 'fieldNames', 'function', 'inConstructor', 'isDeleted', 'markerDetails', 'metaclass', 'molType', 'molecularMass', 'name', 'packageName', 'packageShortName', 'promoterDetails', 'qualifiedName', 'resistanceDetails', 'seqDetails', 'seqString', 'sequenceType', 'synonyms', 'access', 'activeAccess', 'blueprintComponents', 'categories', 'componentDbRefs', 'compositeElements', 'labeledMixture', 'labels', 'molCompFeatures', 'molecule', 'naturalSource', 'nucTargets', 'parent', 'protTargets', 'refMolCompFeatures', 'refSampleComponentStore', 'relatedExpBlueprints', 'root', 'specificLabelGroups', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for ccp.lims.RefSampleComponent.Construct
    """
    dataDict = self.__dict__
    dataDict['refSampleComponentStore'] = parent
    if (not isinstance(parent, RefSampleComponentStore)):
      raise ApiError("""%s.__init__:
       value is not of class ccp.lims.RefSampleComponent.RefSampleComponentStore""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = parent.__dict__.get('topObject')
    dataDict['topObject'] = topObject

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    if (notIsReading):
      if (not (topObject.__dict__.get('isModifiable'))):
        raise ApiError("""%s.__init__:
         Storage not modifiable""" % self.qualifiedName
         + ": %s" % (topObject,)
        )

    try:
      if (not ((parent.__dict__.get('isLoaded') or parent.__dict__.get('isReading')))):
        parent.load()

      dataDict['applicationData'] = list()
      dataDict['casNum'] = None
      dataDict['constructStatus'] = None
      dataDict['details'] = None
      dataDict['empiricalFormula'] = None
      dataDict['function'] = None
      dataDict['markerDetails'] = None
      dataDict['molType'] = None
      dataDict['molecularMass'] = None
      dataDict['name'] = None
      dataDict['promoterDetails'] = None
      dataDict['resistanceDetails'] = None
      dataDict['seqDetails'] = None
      dataDict['seqString'] = None
      dataDict['sequenceType'] = None
      dataDict['synonyms'] = list()
      dataDict['access'] = None
      dataDict['blueprintComponents'] = set()
      dataDict['categories'] = set()
      dataDict['componentDbRefs'] = {}
      dataDict['compositeElements'] = set()
      dataDict['labeledMixture'] = None
      dataDict['labels'] = {}
      dataDict['molCompFeatures'] = {}
      dataDict['molecule'] = None
      dataDict['naturalSource'] = None
      dataDict['nucTargets'] = set()
      dataDict['protTargets'] = set()
      dataDict['refMolCompFeatures'] = set()
      dataDict['relatedExpBlueprints'] = set()
      dataDict['specificLabelGroups'] = {}

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in ccp.lims.RefSampleComponent.Construct.__init__"
        del dataDict['inConstructor']
        raise

      serialDict = {}
      serialDict['componentDbRefs'] = 0
      serialDict['labels'] = 0
      serialDict['molCompFeatures'] = 0
      serialDict['specificLabelGroups'] = 0
      dataDict['_serialDict'] = serialDict

      if (notIsReading):
        childrenDict = parent.__dict__.get('components')
        objKey = dataDict.get('name')
        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['name'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notOverride):
        self.checkValid()

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for ccp.lims.RefSampleComponent.Construct:
       determines 
    cascading deletes to follow from delete of object.
       *Implementation 
    function* - should be called only by API delete function.
    """
    dataDict = self.__dict__
    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.lims.ExpBlueprint')
    tobjList = root.__dict__.get('expBlueprintStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    blueprintComponents = dataDict.get('blueprintComponents')
    pass
    for blueprintComponent in blueprintComponents:
      topObject = blueprintComponent.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    categories = dataDict.get('categories')
    pass
    for category in categories:
      topObject = category.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    componentDbRefs = dataDict.get('componentDbRefs').values()
    for componentDbRef in componentDbRefs:
      if (not (componentDbRef in objsToBeDeleted)):
        objsToBeDeleted.add(componentDbRef)
        objsToBeChecked.append(componentDbRef)

    compositeElements = dataDict.get('compositeElements')
    for compositeElement in compositeElements:
      if (not (compositeElement in objsToBeDeleted)):
        objsToBeDeleted.add(compositeElement)
        objsToBeChecked.append(compositeElement)

    labeledMixture = dataDict.get('labeledMixture')
    if (labeledMixture is not None):
      topObject = labeledMixture.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    labels = dataDict.get('labels').values()
    for label in labels:
      if (not (label in objsToBeDeleted)):
        objsToBeDeleted.add(label)
        objsToBeChecked.append(label)

    molCompFeatures = dataDict.get('molCompFeatures').values()
    for molCompFeature in molCompFeatures:
      if (not (molCompFeature in objsToBeDeleted)):
        objsToBeDeleted.add(molCompFeature)
        objsToBeChecked.append(molCompFeature)

    molecule = dataDict.get('molecule')
    if (molecule is not None):
      topObject = molecule.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.lims.Target')
    tobjList = root.__dict__.get('targetStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    nucTargets = dataDict.get('nucTargets')
    pass
    for nucTarget in nucTargets:
      topObject = nucTarget.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.lims.Target')
    tobjList = root.__dict__.get('targetStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    protTargets = dataDict.get('protTargets')
    for protTarget in protTargets:
      if (not (protTarget in objsToBeDeleted)):
        objsToBeDeleted.add(protTarget)
        objsToBeChecked.append(protTarget)

    for protTarget in protTargets:
      topObject = protTarget.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.lims.ExpBlueprint')
    tobjList = root.__dict__.get('expBlueprintStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    relatedExpBlueprints = dataDict.get('relatedExpBlueprints')
    pass
    for relatedExpBlueprint in relatedExpBlueprints:
      topObject = relatedExpBlueprint.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    specificLabelGroups = dataDict.get('specificLabelGroups').values()
    for specificLabelGroup in specificLabelGroups:
      if (not (specificLabelGroup in objsToBeDeleted)):
        objsToBeDeleted.add(specificLabelGroup)
        objsToBeChecked.append(specificLabelGroup)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for ccp.lims.RefSampleComponent.Construct:   deletes
    objects
    *Implementation function* - will CORRUPT DATA if called outside 
    the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    for blueprintComponent in dataDict.get('blueprintComponents'):
      if (not (blueprintComponent in objsToBeDeleted)):
        blueprintComponent.__dict__['molComponent'] = None

    for category in dataDict.get('categories'):
      if (not (category in objsToBeDeleted)):
        components = category.__dict__.get('components')
        components.remove(self)

    labeledMixture = dataDict.get('labeledMixture')
    if ((labeledMixture is not None and not (labeledMixture in objsToBeDeleted))):
      molComponents = labeledMixture.__dict__.get('molComponents')
      molComponents.remove(self)

    molecule = dataDict.get('molecule')
    if ((molecule is not None and not (molecule in objsToBeDeleted))):
      molComponents = molecule.__dict__.get('molComponents')
      molComponents.remove(self)

    for nucTarget in dataDict.get('nucTargets'):
      if (not (nucTarget in objsToBeDeleted)):
        nucleicAcids = nucTarget.__dict__.get('nucleicAcids')
        nucleicAcids.remove(self)

    for refMolCompFeature in dataDict.get('refMolCompFeatures'):
      if (not (refMolCompFeature in objsToBeDeleted)):
        refMolCompFeature.__dict__['refMolComponent'] = None

    for relatedExpBlueprint in dataDict.get('relatedExpBlueprints'):
      if (not (relatedExpBlueprint in objsToBeDeleted)):
        trialMolComponents = relatedExpBlueprint.__dict__.get('trialMolComponents')
        trialMolComponents.remove(self)

    refSampleComponentStore = dataDict.get('refSampleComponentStore')
    if (not (refSampleComponentStore in objsToBeDeleted)):
      objKey = dataDict.get('name')
      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = refSampleComponentStore.__dict__.get('components')
        if (self is dd.get(objKey)):
          del dd[objKey]

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData

  addBlueprintComponent = MolComponent.addBlueprintComponent

  addCategory = AbstractComponent.addCategory

  addNucTarget = MolComponent.addNucTarget

  addRefMolCompFeature = MolComponent.addRefMolCompFeature

  addRelatedExpBlueprint = MolComponent.addRelatedExpBlueprint

  addSynonym = AbstractComponent.addSynonym
  
  def checkAllValid(self, complete=False):
    """
    CheckAllValid for ccp.lims.RefSampleComponent.Construct
    """
    dataDict = self.__dict__
    self.checkValid(complete)
    values = dataDict.get('componentDbRefs').values()
    for value in values:
      value.checkAllValid(complete)

    values = dataDict.get('labels').values()
    for value in values:
      value.checkAllValid(complete)

    values = dataDict.get('molCompFeatures').values()
    for value in values:
      value.checkAllValid(complete)

    values = dataDict.get('specificLabelGroups').values()
    for value in values:
      value.checkAllValid(complete)

  def checkValid(self, complete=False):
    """
    CheckValid for ccp.lims.RefSampleComponent.Construct
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      objKey = dataDict.get('name')
      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('refSampleComponentStore')
        dd = value.__dict__.get('components')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'refSampleComponentStore' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      # check attributes
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('casNum')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: casNum:
           memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 32):
          raise ApiError("""%s.checkValid: casNum:
           memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: casNum:
           memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.split()) == 1)):
          raise ApiError("""%s.checkValid: casNum:
           Word constraint contains_no_white_space violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('constructStatus')
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: constructStatus:
         ccp.lims.RefSampleComponent.ConstructStatus input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: constructStatus:
         ccp.lims.RefSampleComponent.ConstructStatus maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: constructStatus:
         ccp.lims.RefSampleComponent.ConstructStatus: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: constructStatus:
         ConstructStatus constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('details')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: details:
           memops.Implementation.String input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('empiricalFormula')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: empiricalFormula:
           memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: empiricalFormula:
           memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: empiricalFormula:
           memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: empiricalFormula:
           Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('function')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: function:
           memops.Implementation.String input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('markerDetails')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: markerDetails:
           memops.Implementation.String input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('molType')
      if (value is not None):
        if (not (value in ['protein', 'DNA', 'RNA', 'DNA/RNA', 'carbohydrate', 'other'])):
          raise ApiError("""%s.checkValid: molType:
           ccp.molecule.Molecule.MolType input is not in enumeration ['protein', 'DNA', 'RNA', 'DNA/RNA', 'carbohydrate', 'other']""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: molType:
           MolType constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('molecularMass')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.Float.PythonType)):
          pass
        elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
          value = memops.api.Implementation.Float.create(value)
        else:
          raise ApiError("""%s.checkValid: molecularMass:
           memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (value - value == 0.0)):
          raise ApiError("""%s.checkValid: molecularMass:
           Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('name')
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: name:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: name:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: name:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: name:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('promoterDetails')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: promoterDetails:
           memops.Implementation.String input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('resistanceDetails')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: resistanceDetails:
           memops.Implementation.String input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('seqDetails')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: seqDetails:
           memops.Implementation.String input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('seqString')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: seqString:
           memops.Implementation.String input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('sequenceType')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: sequenceType:
           memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: sequenceType:
           memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: sequenceType:
           memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: sequenceType:
           Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      values = dataDict.get('synonyms')
      for value in values:
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: synonyms:
           memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: synonyms:
           memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: synonyms:
           memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: synonyms:
           Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.lims.ExpBlueprint')
      tobjList = root.__dict__.get('expBlueprintStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      values = dataDict.get('blueprintComponents')
      for value in values:
        from ccp.api.lims.ExpBlueprint import BlueprintComponent as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: blueprintComponents:
           value is not of class ccp.lims.ExpBlueprint.BlueprintComponent""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('molComponent')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: blueprintComponents:
           non-reciprocal link blueprintComponents from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: blueprintComponents:
           Link blueprintComponents between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      values = dataDict.get('categories')
      for value in values:
        from ccp.api.lims.Classification import SampleComponentCategory as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: categories:
           value is not of class ccp.lims.Classification.SampleComponentCategory""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('components')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: categories:
           non-reciprocal link categories from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: categories:
           Link categories between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      values = dataDict.get('componentDbRefs').values()
      for value in values:
        if (not isinstance(value, ComponentDbRef)):
          raise ApiError("""%s.checkValid: componentDbRefs:
           value is not of class ccp.lims.RefSampleComponent.ComponentDbRef""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('component')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: componentDbRefs:
           non-reciprocal link componentDbRefs from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      values = dataDict.get('compositeElements')
      for value in values:
        if (not isinstance(value, CompositeElement)):
          raise ApiError("""%s.checkValid: compositeElements:
           value is not of class ccp.lims.RefSampleComponent.CompositeElement""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('component')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: compositeElements:
           non-reciprocal link compositeElements from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: compositeElements:
           Link compositeElements between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('labeledMixture')
      if (value is not None):
        from ccp.api.molecule.LabeledMolecule import LabeledMixture as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: labeledMixture:
           value is not of class ccp.molecule.LabeledMolecule.LabeledMixture""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('molComponents')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: labeledMixture:
           non-reciprocal link labeledMixture from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      values = dataDict.get('labels').values()
      for value in values:
        if (not isinstance(value, Label)):
          raise ApiError("""%s.checkValid: labels:
           value is not of class ccp.lims.RefSampleComponent.Label""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('component')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: labels:
           non-reciprocal link labels from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      values = dataDict.get('molCompFeatures').values()
      for value in values:
        if (not isinstance(value, MolCompFeature)):
          raise ApiError("""%s.checkValid: molCompFeatures:
           value is not of class ccp.lims.RefSampleComponent.MolCompFeature""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('molComponent')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: molCompFeatures:
           non-reciprocal link molCompFeatures from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      value = dataDict.get('molecule')
      if (value is not None):
        from ccp.api.molecule.Molecule import Molecule as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: molecule:
           value is not of class ccp.molecule.Molecule.Molecule""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('molComponents')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: molecule:
           non-reciprocal link molecule from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      value = dataDict.get('naturalSource')
      if (value is not None):
        from ccp.api.general.Taxonomy import NaturalSource as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: naturalSource:
           value is not of class ccp.general.Taxonomy.NaturalSource""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: naturalSource:
           Link naturalSource between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.lims.Target')
      tobjList = root.__dict__.get('targetStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      values = dataDict.get('nucTargets')
      for value in values:
        from ccp.api.lims.Target import Target as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: nucTargets:
           value is not of class ccp.lims.Target.Target""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('nucleicAcids')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: nucTargets:
           non-reciprocal link nucTargets from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: nucTargets:
           Link nucTargets between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.lims.Target')
      tobjList = root.__dict__.get('targetStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      values = dataDict.get('protTargets')
      for value in values:
        from ccp.api.lims.Target import Target as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: protTargets:
           value is not of class ccp.lims.Target.Target""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('protein')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: protTargets:
           non-reciprocal link protTargets from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: protTargets:
           Link protTargets between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      values = dataDict.get('refMolCompFeatures')
      for value in values:
        if (not isinstance(value, MolCompFeature)):
          raise ApiError("""%s.checkValid: refMolCompFeatures:
           value is not of class ccp.lims.RefSampleComponent.MolCompFeature""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('refMolComponent')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: refMolCompFeatures:
           non-reciprocal link refMolCompFeatures from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: refMolCompFeatures:
           Link refMolCompFeatures between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('refSampleComponentStore')
      if (not isinstance(value, RefSampleComponentStore)):
        raise ApiError("""%s.checkValid: refSampleComponentStore:
         value is not of class ccp.lims.RefSampleComponent.RefSampleComponentStore""" % self.qualifiedName
         + ": %s" % (value,)
        )

      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.lims.ExpBlueprint')
      tobjList = root.__dict__.get('expBlueprintStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      values = dataDict.get('relatedExpBlueprints')
      for value in values:
        from ccp.api.lims.ExpBlueprint import BlueprintComponent as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: relatedExpBlueprints:
           value is not of class ccp.lims.ExpBlueprint.BlueprintComponent""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('trialMolComponents')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: relatedExpBlueprints:
           non-reciprocal link relatedExpBlueprints from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: relatedExpBlueprints:
           Link relatedExpBlueprints between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      values = dataDict.get('specificLabelGroups').values()
      for value in values:
        if (not isinstance(value, SpecificLabelGroup)):
          raise ApiError("""%s.checkValid: specificLabelGroups:
           value is not of class ccp.lims.RefSampleComponent.SpecificLabelGroup""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('molComponent')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: specificLabelGroups:
           non-reciprocal link specificLabelGroups from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

    # check explicit class constraints
    if (not (reduce(operator.add, [x.fraction for x in self.specificLabelGroups], 0) <= 1.0)):
      raise ApiError("""%s.checkValid:
       constraint SpecificLabelGroups_add_up_to_less_than_1 violated""" % self.qualifiedName
       + ": %s" % (self,)
      )

    # check attributes
    values = dataDict.get('applicationData')
    for value in values:
      value.checkAllValid(complete)

    value = dataDict.get('casNum')
    value = dataDict.get('constructStatus')
    if (value is None):
      raise ApiError("""%s.checkValid: constructStatus:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('details')
    value = dataDict.get('empiricalFormula')
    value = dataDict.get('function')
    value = dataDict.get('markerDetails')
    value = dataDict.get('molType')
    value = dataDict.get('molecularMass')
    value = dataDict.get('name')
    if (value is None):
      raise ApiError("""%s.checkValid: name:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('promoterDetails')
    value = dataDict.get('resistanceDetails')
    value = dataDict.get('seqDetails')
    value = dataDict.get('seqString')
    value = dataDict.get('sequenceType')
    values = dataDict.get('synonyms')
    # check roles
    value = dataDict.get('access')
    values = dataDict.get('blueprintComponents')
    values = dataDict.get('categories')
    values = dataDict.get('componentDbRefs').values()
    values = dataDict.get('compositeElements')
    value = dataDict.get('labeledMixture')
    values = dataDict.get('labels').values()
    values = dataDict.get('molCompFeatures').values()
    value = dataDict.get('molecule')
    if (value is not None):
      if (not (value.isFinalised)):
        raise ApiError("""%s.checkValid: molecule:
         molecule constraint Molecule_must_be_finalised violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    value = dataDict.get('naturalSource')
    values = dataDict.get('nucTargets')
    values = dataDict.get('protTargets')
    values = dataDict.get('refMolCompFeatures')
    value = dataDict.get('refSampleComponentStore')
    if (value is None):
      raise ApiError("""%s.checkValid: refSampleComponentStore:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    values = dataDict.get('relatedExpBlueprints')
    values = dataDict.get('specificLabelGroups').values()

  delete = memops.api.Implementation.DataObject.delete

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData

  findAllBlueprintComponents = MolComponent.findAllBlueprintComponents

  findAllCategories = AbstractComponent.findAllCategories

  findAllComponentDbRefs = AbstractComponent.findAllComponentDbRefs

  findAllCompositeElements = AbstractComponent.findAllCompositeElements

  findAllLabels = AbstractComponent.findAllLabels

  findAllMolCompFeatures = MolComponent.findAllMolCompFeatures

  findAllNucTargets = MolComponent.findAllNucTargets

  findAllProtTargets = MolComponent.findAllProtTargets

  findAllRefMolCompFeatures = MolComponent.findAllRefMolCompFeatures

  findAllRelatedExpBlueprints = MolComponent.findAllRelatedExpBlueprints

  findAllSpecificLabelGroups = MolComponent.findAllSpecificLabelGroups

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData

  findFirstBlueprintComponent = MolComponent.findFirstBlueprintComponent

  findFirstCategory = AbstractComponent.findFirstCategory

  findFirstComponentDbRef = AbstractComponent.findFirstComponentDbRef

  findFirstCompositeElement = AbstractComponent.findFirstCompositeElement

  findFirstLabel = AbstractComponent.findFirstLabel

  findFirstMolCompFeature = MolComponent.findFirstMolCompFeature

  findFirstNucTarget = MolComponent.findFirstNucTarget

  findFirstProtTarget = MolComponent.findFirstProtTarget

  findFirstRefMolCompFeature = MolComponent.findFirstRefMolCompFeature

  findFirstRelatedExpBlueprint = MolComponent.findFirstRelatedExpBlueprint

  findFirstSpecificLabelGroup = MolComponent.findFirstSpecificLabelGroup
  
  def get(self, name):
    """
    GetAttr for ccp.lims.RefSampleComponent.Construct
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData

  getBlueprintComponents = MolComponent.getBlueprintComponents
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccp.lims.RefSampleComponent.Construct
    """

    result = None
    if (startObj.__class__.__name__ == 'MemopsRoot'):
      if (2 != len(fullKey)):
        raise ApiError("""'ccp.lims.RefSampleComponent.Construct'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj0 = startObj
      objKey = fullKey[0]
      obj1 = obj0.__dict__.get('refSampleComponentStores').get(objKey)
      if (obj1 is None):
        obj0.refreshTopObjects('ccp.lims.RefSampleComponent')
        obj1 = obj0.__dict__.get('refSampleComponentStores').get(objKey)

    else:
      if (1 != len(fullKey)):
        raise ApiError("""'ccp.lims.RefSampleComponent.Construct'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj1 = startObj

    if (obj1 is not None):
      if (not (obj1.__dict__.get('isLoaded'))):
        obj1.load()

      objKey = fullKey[-1]
      obj2 = obj1.__dict__.get('components').get(objKey)
      if (isinstance(obj2, Construct)):
        result = obj2

    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation

  getCasNum = MolComponent.getCasNum

  getCategories = AbstractComponent.getCategories

  getClassName = memops.api.Implementation.ComplexDataType.getClassName

  getComponentDbRefs = AbstractComponent.getComponentDbRefs

  getCompositeElements = AbstractComponent.getCompositeElements
  
  def getConstructStatus(self):
    """
    Get for ccp.lims.RefSampleComponent.Construct.constructStatus
    """
    dataDict = self.__dict__
    result = dataDict.get('constructStatus')
    return result

  getDetails = AbstractComponent.getDetails

  getEmpiricalFormula = MolComponent.getEmpiricalFormula

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames

  getFullKey = AbstractComponent.getFullKey
  
  def getFunction(self):
    """
    Get for ccp.lims.RefSampleComponent.Construct.function
    """
    dataDict = self.__dict__
    result = dataDict.get('function')
    return result

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted

  getLabeledMixture = MolComponent.getLabeledMixture

  getLabels = AbstractComponent.getLabels

  getLocalKey = AbstractComponent.getLocalKey
  
  def getMarkerDetails(self):
    """
    Get for ccp.lims.RefSampleComponent.Construct.markerDetails
    """
    dataDict = self.__dict__
    result = dataDict.get('markerDetails')
    return result

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass

  getMolCompFeatures = MolComponent.getMolCompFeatures

  getMolType = MolComponent.getMolType

  getMolecularMass = MolComponent.getMolecularMass

  getMolecule = MolComponent.getMolecule

  getName = AbstractComponent.getName

  getNaturalSource = AbstractComponent.getNaturalSource

  getNucTargets = MolComponent.getNucTargets

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName

  getParent = AbstractComponent.getParent
  
  def getPromoterDetails(self):
    """
    Get for ccp.lims.RefSampleComponent.Construct.promoterDetails
    """
    dataDict = self.__dict__
    result = dataDict.get('promoterDetails')
    return result

  getProtTargets = MolComponent.getProtTargets

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName

  getRefMolCompFeatures = MolComponent.getRefMolCompFeatures

  getRefSampleComponentStore = AbstractComponent.getRefSampleComponentStore

  getRelatedExpBlueprints = MolComponent.getRelatedExpBlueprints
  
  def getResistanceDetails(self):
    """
    Get for ccp.lims.RefSampleComponent.Construct.resistanceDetails
    """
    dataDict = self.__dict__
    result = dataDict.get('resistanceDetails')
    return result

  getRoot = memops.api.Implementation.MemopsObject.getRoot

  getSeqDetails = MolComponent.getSeqDetails

  getSeqString = MolComponent.getSeqString
  
  def getSequenceType(self):
    """
    Get for ccp.lims.RefSampleComponent.Construct.sequenceType
    """
    dataDict = self.__dict__
    result = dataDict.get('sequenceType')
    return result

  getSpecificLabelGroups = MolComponent.getSpecificLabelGroups

  getSynonyms = AbstractComponent.getSynonyms

  getTopObject = memops.api.Implementation.DataObject.getTopObject

  newComponentDbRef = AbstractComponent.newComponentDbRef

  newLabel = AbstractComponent.newLabel

  newMolCompFeature = MolComponent.newMolCompFeature

  newSpecificLabelGroup = MolComponent.newSpecificLabelGroup

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData

  removeBlueprintComponent = MolComponent.removeBlueprintComponent

  removeCategory = AbstractComponent.removeCategory

  removeNucTarget = MolComponent.removeNucTarget

  removeRefMolCompFeature = MolComponent.removeRefMolCompFeature

  removeRelatedExpBlueprint = MolComponent.removeRelatedExpBlueprint

  removeSynonym = AbstractComponent.removeSynonym
  
  def set(self, name, value):
    """
    SetAttr for ccp.lims.RefSampleComponent.Construct
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData

  setBlueprintComponents = MolComponent.setBlueprintComponents

  setCasNum = MolComponent.setCasNum

  setCategories = AbstractComponent.setCategories

  setCompositeElements = AbstractComponent.setCompositeElements
  
  def setConstructStatus(self, value):
    """
    Set for ccp.lims.RefSampleComponent.Construct.constructStatus
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.setConstructStatus:
       ccp.lims.RefSampleComponent.ConstructStatus input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 80):
      raise ApiError("""%s.setConstructStatus:
       ccp.lims.RefSampleComponent.ConstructStatus maximum length is 80 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.setConstructStatus:
       ccp.lims.RefSampleComponent.ConstructStatus: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.splitlines()) <= 1)):
      raise ApiError("""%s.setConstructStatus:
       ConstructStatus constraint contains_no_linebreak violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('constructStatus')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setConstructStatus:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setConstructStatus:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setConstructStatus:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['constructStatus'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setConstructStatus')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  setDetails = AbstractComponent.setDetails

  setEmpiricalFormula = MolComponent.setEmpiricalFormula
  
  def setFunction(self, value):
    """
    Set for ccp.lims.RefSampleComponent.Construct.function
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setFunction:
         memops.Implementation.String input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('function')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setFunction:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setFunction:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['function'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setFunction')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  setLabeledMixture = MolComponent.setLabeledMixture
  
  def setMarkerDetails(self, value):
    """
    Set for ccp.lims.RefSampleComponent.Construct.markerDetails
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setMarkerDetails:
         memops.Implementation.String input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('markerDetails')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setMarkerDetails:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setMarkerDetails:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['markerDetails'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setMarkerDetails')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  setMolType = MolComponent.setMolType

  setMolecularMass = MolComponent.setMolecularMass

  setMolecule = MolComponent.setMolecule

  setName = AbstractComponent.setName

  setNaturalSource = AbstractComponent.setNaturalSource

  setNucTargets = MolComponent.setNucTargets
  
  def setPromoterDetails(self, value):
    """
    Set for ccp.lims.RefSampleComponent.Construct.promoterDetails
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setPromoterDetails:
         memops.Implementation.String input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('promoterDetails')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setPromoterDetails:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setPromoterDetails:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['promoterDetails'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setPromoterDetails')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  setProtTargets = MolComponent.setProtTargets

  setRefMolCompFeatures = MolComponent.setRefMolCompFeatures

  setRelatedExpBlueprints = MolComponent.setRelatedExpBlueprints
  
  def setResistanceDetails(self, value):
    """
    Set for ccp.lims.RefSampleComponent.Construct.resistanceDetails
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setResistanceDetails:
         memops.Implementation.String input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('resistanceDetails')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setResistanceDetails:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setResistanceDetails:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['resistanceDetails'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setResistanceDetails')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  setSeqDetails = MolComponent.setSeqDetails

  setSeqString = MolComponent.setSeqString
  
  def setSequenceType(self, value):
    """
    Set for ccp.lims.RefSampleComponent.Construct.sequenceType
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setSequenceType:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.setSequenceType:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setSequenceType:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.setSequenceType:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('sequenceType')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setSequenceType:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setSequenceType:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['sequenceType'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setSequenceType')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  setSynonyms = AbstractComponent.setSynonyms

  sortedBlueprintComponents = MolComponent.sortedBlueprintComponents

  sortedCategories = AbstractComponent.sortedCategories

  sortedComponentDbRefs = AbstractComponent.sortedComponentDbRefs

  sortedCompositeElements = AbstractComponent.sortedCompositeElements

  sortedLabels = AbstractComponent.sortedLabels

  sortedMolCompFeatures = MolComponent.sortedMolCompFeatures

  sortedNucTargets = MolComponent.sortedNucTargets

  sortedProtTargets = MolComponent.sortedProtTargets

  sortedRefMolCompFeatures = MolComponent.sortedRefMolCompFeatures

  sortedRelatedExpBlueprints = MolComponent.sortedRelatedExpBlueprints

  sortedSpecificLabelGroups = MolComponent.sortedSpecificLabelGroups

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  applicationData = memops.api.Implementation.DataObject.applicationData

  casNum = MolComponent.casNum

  className = memops.api.Implementation.ComplexDataType.className
  
  constructStatus = property(getConstructStatus, setConstructStatus, None,
  r"""The status of the construct e.g. empty, with target, ...
  """)

  details = AbstractComponent.details

  empiricalFormula = MolComponent.empiricalFormula

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames
  
  function = property(getFunction, setFunction, None,
  r"""The Construct class is also used to describe vectors and so the function 
  attribute can be used to indicate the function of the vector e.g. 
  expression.
  """)

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted
  
  markerDetails = property(getMarkerDetails, setMarkerDetails, None,
  r"""Detail field for marker information. Precise information should go to a 
  MolCompFeature.
  """)

  metaclass = memops.api.Implementation.ComplexDataType.metaclass

  molType = MolComponent.molType

  molecularMass = MolComponent.molecularMass

  name = AbstractComponent.name

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName
  
  promoterDetails = property(getPromoterDetails, setPromoterDetails, None,
  r"""Detail field for promoter information. Precise information should go to 
  a MolCompFeature.
  """)

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName
  
  resistanceDetails = property(getResistanceDetails, setResistanceDetails, None,
  r"""Detail field for resistance information. Precise information should go 
  to a MolCompFeature.
  """)

  seqDetails = MolComponent.seqDetails

  seqString = MolComponent.seqString
  
  sequenceType = property(getSequenceType, setSequenceType, None,
  r"""The type of nucleic acid sequence in the construct. Note that to find 
  all the DNA molecules it is necessary to search for DNA + cDNA and for 
  RNA, RNA + mRNA + tRNA.
  """)

  synonyms = AbstractComponent.synonyms

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess

  blueprintComponents = MolComponent.blueprintComponents

  categories = AbstractComponent.categories

  componentDbRefs = AbstractComponent.componentDbRefs

  compositeElements = AbstractComponent.compositeElements

  labeledMixture = MolComponent.labeledMixture

  labels = AbstractComponent.labels

  molCompFeatures = MolComponent.molCompFeatures

  molecule = MolComponent.molecule

  naturalSource = AbstractComponent.naturalSource

  nucTargets = MolComponent.nucTargets

  parent = AbstractComponent.parent

  protTargets = MolComponent.protTargets

  refMolCompFeatures = MolComponent.refMolCompFeatures

  refSampleComponentStore = AbstractComponent.refSampleComponentStore

  relatedExpBlueprints = MolComponent.relatedExpBlueprints

  root = memops.api.Implementation.MemopsObject.root

  specificLabelGroups = MolComponent.specificLabelGroups

  topObject = memops.api.Implementation.DataObject.topObject
