""" Information for generating license headers for autogenerated files.

The information is used by python.memops.scripts.license.headers.py
It is ordered by packageGroup.

NB 'useLicense', 'stdContact' and 'references' refer to information in
python/memops/scripts/license, 
in files licenses.py, contacts.py and references.py respectively. 
Only 'useLicense' is mandatory, the others are optional and may be set to None.
Neither can be chosebn freely. 
'extraContact' and 'credits' are strings that are entered 'as is'. They
are entered in addition to the (optional) 'stdContact' and 'references'.
"""

licenseInfo = {

 'pp' : {
  'author':'Anne Pajon',
  'organization':'MSD group, EBI',
  'useLicense':'LGPL',
  'stdContact':'msd',
  'extraContact': None,
  'references':('MSD2004',),
  'credits':None
 },
 
 'nmr' : {
  'author':'Rasmus Fogh',
  'organization':'CCPN Project',
  'useLicense':'LGPL',
  'stdContact':'ccpn',
  'extraContact':None,
  'references':('CCPNMR2004','MEMOPS2004'),
  'credits':None
 },
 
 'core' : {
  'author':'',
  'organization':'CCPN Project',
  'useLicense':'LGPL',
  'stdContact':'ccpn',
  'extraContact':None,
  'references':('MEMOPS2004',),
  'credits':None
 }


}
