
"""
======================COPYRIGHT/LICENSE START==========================

Util.py: code for CCPN data model and code generation framework

Copyright (C) 2012  (CCPN Project)

=======================================================================

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
A copy of this license can be found in ../../../license/LGPL.license
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
Lesser General Public License for more details.
 
You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA


======================COPYRIGHT/LICENSE END============================

for further information, please contact :

- CCPN website (http://www.ccpn.ac.uk/)

- email: ccpn@bioc.cam.ac.uk

=======================================================================

If you are using this software for academic purposes, we suggest
quoting the following references:

===========================REFERENCE START=============================
R. Fogh, J. Ionides, E. Ulrich, W. Boucher, W. Vranken, J.P. Linge, M.
Habeck, W. Rieping, T.N. Bhat, J. Westbrook, K. Henrick, G. Gilliland,
H. Berman, J. Thornton, M. Nilges, J. Markley and E. Laue (2002). The
CCPN project: An interim report on a data model for the NMR community
(Progress report). Nature Struct. Biol. 9, 416-418.

Rasmus H. Fogh, Wayne Boucher, Wim F. Vranken, Anne
Pajon, Tim J. Stevens, T.N. Bhat, John Westbrook, John M.C. Ionides and
Ernest D. Laue (2005). A framework for scientific data modeling and automated
software development. Bioinformatics 21, 1678-1684.

===========================REFERENCE END===============================

"""
from ccpnmr.integrator.core import Io as intIo
from ccpnmr.integrator.core import Util as intUtil




defaultConfiguration = {
  "protocol": {
    "protocolParameters": [ 
      {"name":"shiftFormat","paramType":"String","value":"TALOS"}
    ]
  }
}



def adaptNmrCalcRun(nmrCalcRun, protocolName):
  """ Modify nmrCalcRun from generic MultiStructure form to protocol-specific
    Input:
      nmrCalcRun: NmrCalc.Run 
      String protocolName
  """
  
  pass




def adaptNmrCalcRun(nmrCalcRun, protocolName):
  """ Modify nmrCalcRun from generic MultiStructure form to protocol-specific
    Input:
      nmrCalcRun: NmrCalc.Run 
      String protocolName
  """
  
  if protocolName.startswith('CS-ROSETTA') or protocolName.startswith('ROSETTA'):
    csRosettaNmrCalcRun(nmrCalcRun)
  
  else:
    raise Exception("Protocol %s not recognized" % protocolName)

def csRosettaNmrCalcRun(nmrCalcRun):
  """ Modify nmrCalcRun from generic MultiStructure form to ASDP-specific
    Input:
      nmrCalcRun: NmrCalc.Run 
  """
  
  ## name : code dictionary for resetting code values
  #codeRemapping = {
  #}
  
  ## set proper codes for existing data parameters
  #for runParameter in nmrCalcRun.sortedRunParameters():
  #  name = runParameter.name
  #  if name in codeRemapping:
  #    runParameter.code = codeRemapping[name]
  
  # get data sets
  
  shiftListObjs = {}
  for datum in nmrCalcRun.findAllData(className='MeasurementListData'):
    measurementList = datum.measurementList
    if measurementList.className == 'ShiftList':
      shiftListObjs[measurementList] = datum
    
  # main shift list
  if shiftListObjs:
    if len(shiftListObjs) == 1:
      shiftData = list(shiftListObjs.items())[0][1]
      fileName = shiftData.findFirstRunParameter(name='fileName').textValue
      fileFormat = shiftData.findFirstRunParameter(name='fileFormat').textValue
      nmrCalcRun.newRunParameter(name='fileNameShift', code='INPUT_FILE',
                                 textValue=fileName, data=shiftData)
    else:
      raise Exception("CS-ROSETTA requires exactly one shiftLst")
 
 
  
