"""
#######################################################################

CCPN Data Model version 2.1.2

Autogenerated by PyFileApiGen revision 1.57.2.1 on Fri Mar 28 11:20:24 2014
  from data model element utrecht.Haddock revision ?

#######################################################################
======================COPYRIGHT/LICENSE START==========================

Haddock.py: python API for CCPN data model, MetaPackage utrecht.Haddock

Copyright (C) 2007  (CCPN Project)

=======================================================================

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
A copy of this license can be found in ../../../license/LGPL.license
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
Lesser General Public License for more details.
 
You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA


======================COPYRIGHT/LICENSE END============================

for further information, please contact :

- CCPN website (http://www.ccpn.ac.uk/)

- email: ccpn@bioc.cam.ac.uk

=======================================================================

If you are using this software for academic purposes, we suggest
quoting the following references:

===========================REFERENCE START=============================
Rasmus H. Fogh, Wayne Boucher, Wim F. Vranken, Anne
Pajon, Tim J. Stevens, T.N. Bhat, John Westbrook, John M.C. Ionides and
Ernest D. Laue (2005). A framework for scientific data modeling and automated
software development. Bioinformatics 21, 1678-1684.


This file was generated with the Memops software generation framework,
and contains original contributions embedded in the framework

===========================REFERENCE END===============================
"""

import cStringIO
#import sets
import traceback
import types
import operator

# special function for fast whitespace checking.
# used in DataType Word and Token handcode
import re
containsWhitespace = re.compile('\s').search
containsNonAlphanumeric = re.compile('[^a-zA-Z0-9_]').search
 
from memops.general import Implementation as implementation
ApiError = implementation.ApiError

# imported packages:
import ccp.api.molecule.MolStructure
import ccp.api.molecule.MolSystem
import ccp.api.nmr.NmrConstraint
import memops.api.AccessControl
import memops.api.Implementation
import molsim.api.AnnealProtocol
import molsim.api.Symmetry

metaPackage = memops.api.Implementation.topPackage.metaObjFromQualName('utrecht.Haddock')

###############################################################################
class Chain(memops.api.Implementation.DataObject):
  r"""CCPN Chain object.
  """
  #   from data model element utrecht.Haddock.Chain revision ?
  _metaclass = metaPackage.getElement('Chain')
  _packageName = 'utrecht.Haddock'
  _packageShortName = 'HADD'
  _fieldNames = ('applicationData', 'className', 'fieldNames', 'inConstructor', 'isDeleted', 'metaclass', 'packageName', 'packageShortName', 'qualifiedName', 'access', 'activeAccess', 'chain', 'haddockPartner', 'parent', 'residues', 'root', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for utrecht.Haddock.Chain
    """
    dataDict = self.__dict__
    dataDict['haddockPartner'] = parent
    if (not isinstance(parent, HaddockPartner)):
      raise ApiError("""%s.__init__:
       value is not of class utrecht.Haddock.HaddockPartner""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = parent.__dict__.get('topObject')
    dataDict['topObject'] = topObject

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    if (notIsReading):
      if (not (topObject.__dict__.get('isModifiable'))):
        raise ApiError("""%s.__init__:
         Storage not modifiable""" % self.qualifiedName
         + ": %s" % (topObject,)
        )

    try:

      dataDict['applicationData'] = list()
      dataDict['access'] = None
      dataDict['chain'] = None
      dataDict['residues'] = {}

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in utrecht.Haddock.Chain.__init__"
        del dataDict['inConstructor']
        raise

      if (notIsReading):
        childrenDict = parent.__dict__.get('chains')
        objKey = dataDict.get('chain')
        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['chain'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notOverride):
        self.checkValid()

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for utrecht.Haddock.Chain:
       determines cascading deletes 
    to follow from delete of object.
       *Implementation function* - should 
    be called only by API delete function.
    """
    dataDict = self.__dict__
    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    residues = dataDict.get('residues').values()
    for residue in residues:
      if (not (residue in objsToBeDeleted)):
        objsToBeDeleted.add(residue)
        objsToBeChecked.append(residue)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for utrecht.Haddock.Chain:   deletes
    objects
    *Implementation function* - will CORRUPT DATA if called outside 
    the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    haddockPartner = dataDict.get('haddockPartner')
    if (not (haddockPartner in objsToBeDeleted)):
      objKey = dataDict.get('chain')
      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = haddockPartner.__dict__.get('chains')
        if (self is dd.get(objKey)):
          del dd[objKey]

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData
  
  def checkAllValid(self, complete=False):
    """
    CheckAllValid for utrecht.Haddock.Chain
    """
    dataDict = self.__dict__
    self.checkValid(complete)
    values = dataDict.get('residues').values()
    for value in values:
      value.checkAllValid(complete)

  def checkValid(self, complete=False):
    """
    CheckValid for utrecht.Haddock.Chain
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      objKey = dataDict.get('chain')
      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('haddockPartner')
        dd = value.__dict__.get('chains')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'haddockPartner' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      # check attributes
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('chain')
      from ccp.api.molecule.MolSystem import Chain as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.checkValid: chain:
         value is not of class ccp.molecule.MolSystem.Chain""" % self.qualifiedName
         + ": %s" % (value,)
        )

      xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
      yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
      if (not (xx1 is yy1)):
        raise ApiError("""%s.checkValid: chain:
         Link chain between objects from separate partitions
         - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
         + ": %s:%s" % (self, value)
        )

      value = dataDict.get('haddockPartner')
      if (not isinstance(value, HaddockPartner)):
        raise ApiError("""%s.checkValid: haddockPartner:
         value is not of class utrecht.Haddock.HaddockPartner""" % self.qualifiedName
         + ": %s" % (value,)
        )

      values = dataDict.get('residues').values()
      for value in values:
        if (not isinstance(value, Residue)):
          raise ApiError("""%s.checkValid: residues:
           value is not of class utrecht.Haddock.Residue""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('chain')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: residues:
           non-reciprocal link residues from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

    # check explicit class constraints
    # check attributes
    values = dataDict.get('applicationData')
    for value in values:
      value.checkAllValid(complete)

    # check roles
    value = dataDict.get('access')
    value = dataDict.get('chain')
    if (value is None):
      raise ApiError("""%s.checkValid: chain:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('haddockPartner')
    if (value is None):
      raise ApiError("""%s.checkValid: haddockPartner:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    values = dataDict.get('residues').values()

  delete = memops.api.Implementation.DataObject.delete

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData
  
  def findAllResidues(self, **conditions):
    """
    FindAll for utrecht.Haddock.Chain.residues
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('residues').values()
      result = set(currentValues)

    else:
      currentValues = dataDict.get('residues').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('flexibility', 'haddockSeqId', 'interaction', 'access', 'chain', 'residue',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData
  
  def findFirstResidue(self, **conditions):
    """
    FindFirst for utrecht.Haddock.Chain.residues
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('residues').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      objKey = conditions.get('residue')
      if (objKey is not None):
        result = dataDict.get('residues').get(objKey)

        if (nConditions <= 1):
          return result

        elif (result is None):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        currentValues = dataDict.get('residues').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('flexibility', 'haddockSeqId', 'interaction', 'access', 'chain', 'residue',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def get(self, name):
    """
    GetAttr for utrecht.Haddock.Chain
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for utrecht.Haddock.Chain
    """

    result = None
    if (startObj.__class__.__name__ == 'MemopsRoot'):
      if (3 != len(fullKey)):
        raise ApiError("""'utrecht.Haddock.Chain'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj0 = startObj
      objKey = fullKey[0]
      obj1 = obj0.__dict__.get('haddockProjects').get(objKey)
      if (obj1 is None):
        obj0.refreshTopObjects('utrecht.Haddock')
        obj1 = obj0.__dict__.get('haddockProjects').get(objKey)

    else:
      if (2 != len(fullKey)):
        raise ApiError("""'utrecht.Haddock.Chain'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj1 = startObj

    if (obj1 is not None):
      if (not (obj1.__dict__.get('isLoaded'))):
        obj1.load()

      objKey = fullKey[-2]
      obj2 = obj1.__dict__.get('haddockPartners').get(objKey)

      if (obj2 is not None):
        objKey = fullKey[-1]
        obj3 = obj2.__dict__.get('chains').get(objKey)
        result = obj3

    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation
  
  def getChain(self):
    """
    Get for utrecht.Haddock.Chain.chain
    """
    dataDict = self.__dict__
    result = dataDict.get('chain')
    return result

  getClassName = memops.api.Implementation.ComplexDataType.getClassName

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames
  
  def getFullKey(self, useGuid=False):
    """
    GetFullKey for utrecht.Haddock.Chain
    """
    dataDict = self.__dict__
    result = list()

    obj2 = dataDict.get('haddockPartner')
    obj1 = obj2.__dict__.get('haddockProject')

    if (useGuid):
      result.append(obj1.__dict__.get('guid'))
    else:
      result.append(obj1.__dict__.get('name'))

    result.append(obj2.__dict__.get('code'))
    result.append(dataDict.get('chain'))

    return result
  
  def getHaddockPartner(self):
    """
    Get for utrecht.Haddock.Chain.haddockPartner
    """
    dataDict = self.__dict__
    result = dataDict.get('haddockPartner')
    return result

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted
  
  def getLocalKey(self):
    """
    GetLocalKey for utrecht.Haddock.Chain
    """
    dataDict = self.__dict__
    result = dataDict.get('chain')
    return result

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName
  
  def getParent(self):
    """
    Get for utrecht.Haddock.Chain.parent
    """
    dataDict = self.__dict__
    result = dataDict.get('haddockPartner')
    return result

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName
  
  def getResidues(self):
    """
    Get for utrecht.Haddock.Chain.residues
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('residues').values()
    result = frozenset(tempVar)
    return result

  getRoot = memops.api.Implementation.MemopsObject.getRoot

  getTopObject = memops.api.Implementation.DataObject.getTopObject
  
  def newResidue(self, **attrlinks):
    """
    Factory function to create utrecht.Haddock.Residue
    """
    return Residue(self, **attrlinks)

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData
  
  def set(self, name, value):
    """
    SetAttr for utrecht.Haddock.Chain
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData
  
  def setChain(self, value):
    """
    Set for utrecht.Haddock.Chain.chain
    """
    dataDict = self.__dict__
    from ccp.api.molecule.MolSystem import Chain as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.setChain:
       value is not of class ccp.molecule.MolSystem.Chain""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('chain')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setChain:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setChain:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setChain:
         cannot set chain, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setChain:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
      yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
      if (not (xx1 is yy1)):
        raise ApiError("""%s.setChain:
         Link chain between objects from separate partitions
         - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
         + ": %s:%s" % (self, value)
        )

    dataDict['chain'] = value

    # doNotifies
  
  def sortedResidues(self):
    """
    Sorted for utrecht.Haddock.Chain.residues
    """
    dataDict = self.__dict__
    sortdd = dataDict.get('residues')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  applicationData = memops.api.Implementation.DataObject.applicationData

  className = memops.api.Implementation.ComplexDataType.className

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted

  metaclass = memops.api.Implementation.ComplexDataType.metaclass

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess
  
  chain = property(getChain, setChain, None,
  r"""MolSystem.chain that corresponds to Haddock.Chain. Key for the object
  """)
  
  haddockPartner = property(getHaddockPartner,  None, None,
  r"""parent link
  """)
  
  parent = property(getParent, None, None,
  r"""link to parent object - synonym for haddockPartner
  """)
  
  residues = property(getResidues,  None, None,
  r"""child link to class Residue
  """)

  root = memops.api.Implementation.MemopsObject.root

  topObject = memops.api.Implementation.DataObject.topObject

###############################################################################
class EnergyTermParameter(memops.api.Implementation.DataObject):
  r"""NAmed parameter used for ENergy Term
  """
  #   from data model element utrecht.Haddock.EnergyTermParameter revision ?
  _metaclass = metaPackage.getElement('EnergyTermParameter')
  _packageName = 'utrecht.Haddock'
  _packageShortName = 'HADD'
  _fieldNames = ('applicationData', 'className', 'code', 'fieldNames', 'inConstructor', 'isDeleted', 'metaclass', 'packageName', 'packageShortName', 'qualifiedName', 'value', 'access', 'activeAccess', 'haddockEnergyTerm', 'parent', 'root', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for utrecht.Haddock.EnergyTermParameter
    """
    dataDict = self.__dict__
    dataDict['haddockEnergyTerm'] = parent
    if (not isinstance(parent, HaddockEnergyTerm)):
      raise ApiError("""%s.__init__:
       value is not of class utrecht.Haddock.HaddockEnergyTerm""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = parent.__dict__.get('topObject')
    dataDict['topObject'] = topObject

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    if (notIsReading):
      if (not (topObject.__dict__.get('isModifiable'))):
        raise ApiError("""%s.__init__:
         Storage not modifiable""" % self.qualifiedName
         + ": %s" % (topObject,)
        )

    try:

      dataDict['applicationData'] = list()
      dataDict['code'] = None
      dataDict['value'] = None
      dataDict['access'] = None

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in utrecht.Haddock.EnergyTermParameter.__init__"
        del dataDict['inConstructor']
        raise

      if (notIsReading):
        childrenDict = parent.__dict__.get('energyTermParameters')
        objKey = dataDict.get('code')
        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['code'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notOverride):
        self.checkValid()

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for utrecht.Haddock.EnergyTermParameter:
       determines 
    cascading deletes to follow from delete of object.
       *Implementation 
    function* - should be called only by API delete function.
    """
    dataDict = self.__dict__
    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for utrecht.Haddock.EnergyTermParameter:   deletes
    objects
    *Implementation function* - will CORRUPT DATA if called outside 
    the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    haddockEnergyTerm = dataDict.get('haddockEnergyTerm')
    if (not (haddockEnergyTerm in objsToBeDeleted)):
      objKey = dataDict.get('code')
      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = haddockEnergyTerm.__dict__.get('energyTermParameters')
        if (self is dd.get(objKey)):
          del dd[objKey]

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData
  
  def checkAllValid(self, complete=False):
    """
    CheckAllValid for utrecht.Haddock.EnergyTermParameter
    """
    dataDict = self.__dict__
    self.checkValid(complete)
  
  def checkValid(self, complete=False):
    """
    CheckValid for utrecht.Haddock.EnergyTermParameter
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      objKey = dataDict.get('code')
      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('haddockEnergyTerm')
        dd = value.__dict__.get('energyTermParameters')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'haddockEnergyTerm' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      # check attributes
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('code')
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: code:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: code:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: code:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: code:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('value')
      if (isinstance(value, memops.api.Implementation.Float.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Float.create(value)
      else:
        raise ApiError("""%s.checkValid: value:
         memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value - value == 0.0)):
        raise ApiError("""%s.checkValid: value:
         Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('haddockEnergyTerm')
      if (not isinstance(value, HaddockEnergyTerm)):
        raise ApiError("""%s.checkValid: haddockEnergyTerm:
         value is not of class utrecht.Haddock.HaddockEnergyTerm""" % self.qualifiedName
         + ": %s" % (value,)
        )

    # check explicit class constraints
    # check attributes
    values = dataDict.get('applicationData')
    for value in values:
      value.checkAllValid(complete)

    value = dataDict.get('code')
    if (value is None):
      raise ApiError("""%s.checkValid: code:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('value')
    if (value is None):
      raise ApiError("""%s.checkValid: value:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    # check roles
    value = dataDict.get('access')
    value = dataDict.get('haddockEnergyTerm')
    if (value is None):
      raise ApiError("""%s.checkValid: haddockEnergyTerm:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

  delete = memops.api.Implementation.DataObject.delete

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData
  
  def get(self, name):
    """
    GetAttr for utrecht.Haddock.EnergyTermParameter
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for utrecht.Haddock.EnergyTermParameter
    """

    result = None
    if (startObj.__class__.__name__ == 'MemopsRoot'):
      if (5 != len(fullKey)):
        raise ApiError("""'utrecht.Haddock.EnergyTermParameter'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj0 = startObj
      objKey = fullKey[0]
      obj1 = obj0.__dict__.get('haddockProjects').get(objKey)
      if (obj1 is None):
        obj0.refreshTopObjects('utrecht.Haddock')
        obj1 = obj0.__dict__.get('haddockProjects').get(objKey)

    else:
      if (4 != len(fullKey)):
        raise ApiError("""'utrecht.Haddock.EnergyTermParameter'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj1 = startObj

    if (obj1 is not None):
      if (not (obj1.__dict__.get('isLoaded'))):
        obj1.load()

      objKey = fullKey[-4]
      obj2 = obj1.__dict__.get('runs').get(objKey)

      if (obj2 is not None):
        ll = list()
        objKey = fullKey[-3]
        ll.append(objKey)
        if (objKey is not None):
          objKey = fullKey[-2]
          ll.append(objKey)
          if (objKey is not None):
            objKey = tuple(ll)

        obj3 = obj2.__dict__.get('haddockEnergyTerms').get(objKey)

        if (obj3 is not None):
          objKey = fullKey[-1]
          obj4 = obj3.__dict__.get('energyTermParameters').get(objKey)
          result = obj4

    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation

  getClassName = memops.api.Implementation.ComplexDataType.getClassName
  
  def getCode(self):
    """
    Get for utrecht.Haddock.EnergyTermParameter.code
    """
    dataDict = self.__dict__
    result = dataDict.get('code')
    return result

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames
  
  def getFullKey(self, useGuid=False):
    """
    GetFullKey for utrecht.Haddock.EnergyTermParameter
    """
    dataDict = self.__dict__
    result = list()

    obj3 = dataDict.get('haddockEnergyTerm')
    obj2 = obj3.__dict__.get('run')
    obj1 = obj2.__dict__.get('haddockProject')

    if (useGuid):
      result.append(obj1.__dict__.get('guid'))
    else:
      result.append(obj1.__dict__.get('name'))

    result.append(obj2.__dict__.get('serial'))
    result.append(obj3.__dict__.get('code'))
    result.append(obj3.__dict__.get('termId'))
    result.append(dataDict.get('code'))

    return result
  
  def getHaddockEnergyTerm(self):
    """
    Get for utrecht.Haddock.EnergyTermParameter.haddockEnergyTerm
    """
    dataDict = self.__dict__
    result = dataDict.get('haddockEnergyTerm')
    return result

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted
  
  def getLocalKey(self):
    """
    GetLocalKey for utrecht.Haddock.EnergyTermParameter
    """
    dataDict = self.__dict__
    result = dataDict.get('code')
    return result

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName
  
  def getParent(self):
    """
    Get for utrecht.Haddock.EnergyTermParameter.parent
    """
    dataDict = self.__dict__
    result = dataDict.get('haddockEnergyTerm')
    return result

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName

  getRoot = memops.api.Implementation.MemopsObject.getRoot

  getTopObject = memops.api.Implementation.DataObject.getTopObject
  
  def getValue(self):
    """
    Get for utrecht.Haddock.EnergyTermParameter.value
    """
    dataDict = self.__dict__
    result = dataDict.get('value')
    return result

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData
  
  def set(self, name, value):
    """
    SetAttr for utrecht.Haddock.EnergyTermParameter
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData
  
  def setCode(self, value):
    """
    Set for utrecht.Haddock.EnergyTermParameter.code
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.setCode:
       memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 80):
      raise ApiError("""%s.setCode:
       memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.setCode:
       memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.splitlines()) <= 1)):
      raise ApiError("""%s.setCode:
       Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('code')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setCode:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setCode:
         cannot set code, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setCode:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['code'] = value

    # doNotifies
  
  def setValue(self, value):
    """
    Set for utrecht.Haddock.EnergyTermParameter.value
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Float.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Float.create(value)
    else:
      raise ApiError("""%s.setValue:
       memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value - value == 0.0)):
      raise ApiError("""%s.setValue:
       Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('value')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setValue:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setValue:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setValue:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['value'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setValue')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  applicationData = memops.api.Implementation.DataObject.applicationData

  className = memops.api.Implementation.ComplexDataType.className
  
  code = property(getCode, setCode, None,
  r"""Parameter name as defined in the program. Key for class
  """)

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted

  metaclass = memops.api.Implementation.ComplexDataType.metaclass

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName
  
  value = property(getValue, setValue, None,
  r"""Value of parameter
  """)

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess
  
  haddockEnergyTerm = property(getHaddockEnergyTerm,  None, None,
  r"""parent link
  """)
  
  parent = property(getParent, None, None,
  r"""link to parent object - synonym for haddockEnergyTerm
  """)

  root = memops.api.Implementation.MemopsObject.root

  topObject = memops.api.Implementation.DataObject.topObject

###############################################################################
class HaddockEnergyTerm(memops.api.Implementation.DataObject):
  r"""Energy potential term used in Haddock run
  """
  #   from data model element utrecht.Haddock.HaddockEnergyTerm revision ?
  _metaclass = metaPackage.getElement('HaddockEnergyTerm')
  _packageName = 'utrecht.Haddock'
  _packageShortName = 'HADD'
  _fieldNames = ('applicationData', 'className', 'code', 'details', 'fieldNames', 'fileName', 'inConstructor', 'isDeleted', 'metaclass', 'name', 'packageName', 'packageShortName', 'qualifiedName', 'termId', 'access', 'activeAccess', 'constraintList', 'energyTerm', 'energyTermParameters', 'parent', 'root', 'run', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for utrecht.Haddock.HaddockEnergyTerm
    """
    dataDict = self.__dict__
    dataDict['run'] = parent
    if (not isinstance(parent, Run)):
      raise ApiError("""%s.__init__:
       value is not of class utrecht.Haddock.Run""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = parent.__dict__.get('topObject')
    dataDict['topObject'] = topObject

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    if (notIsReading):
      if (not (topObject.__dict__.get('isModifiable'))):
        raise ApiError("""%s.__init__:
         Storage not modifiable""" % self.qualifiedName
         + ": %s" % (topObject,)
        )

    try:

      dataDict['applicationData'] = list()
      dataDict['code'] = None
      dataDict['details'] = None
      dataDict['fileName'] = None
      dataDict['name'] = None
      dataDict['termId'] = None
      dataDict['access'] = None
      dataDict['constraintList'] = None
      dataDict['energyTerm'] = None
      dataDict['energyTermParameters'] = {}

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in utrecht.Haddock.HaddockEnergyTerm.__init__"
        del dataDict['inConstructor']
        raise

      if (notIsReading):
        childrenDict = parent.__dict__.get('haddockEnergyTerms')
        ll = list()
        objKey = dataDict.get('code')
        ll.append(objKey)
        if (objKey is not None):
          objKey = dataDict.get('termId')
          ll.append(objKey)
          if (objKey is not None):
            objKey = tuple(ll)

        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['code', 'termId'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notOverride):
        self.checkValid()

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for utrecht.Haddock.HaddockEnergyTerm:
       determines 
    cascading deletes to follow from delete of object.
       *Implementation 
    function* - should be called only by API delete function.
    """
    dataDict = self.__dict__
    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    energyTerm = dataDict.get('energyTerm')
    if (energyTerm is not None):
      topObject = energyTerm.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    energyTermParameters = dataDict.get('energyTermParameters').values()
    for energyTermParameter in energyTermParameters:
      if (not (energyTermParameter in objsToBeDeleted)):
        objsToBeDeleted.add(energyTermParameter)
        objsToBeChecked.append(energyTermParameter)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for utrecht.Haddock.HaddockEnergyTerm:   deletes
    objects
    *Implementation function* - will CORRUPT DATA if called outside 
    the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    energyTerm = dataDict.get('energyTerm')
    if ((energyTerm is not None and not (energyTerm in objsToBeDeleted))):
      haddockEnergyTerms = energyTerm.__dict__.get('haddockEnergyTerms')
      haddockEnergyTerms.remove(self)

    run = dataDict.get('run')
    if (not (run in objsToBeDeleted)):
      ll = list()
      objKey = dataDict.get('code')
      ll.append(objKey)
      if (objKey is not None):
        objKey = dataDict.get('termId')
        ll.append(objKey)
        if (objKey is not None):
          objKey = tuple(ll)

      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = run.__dict__.get('haddockEnergyTerms')
        if (self is dd.get(objKey)):
          del dd[objKey]

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData
  
  def checkAllValid(self, complete=False):
    """
    CheckAllValid for utrecht.Haddock.HaddockEnergyTerm
    """
    dataDict = self.__dict__
    self.checkValid(complete)
    values = dataDict.get('energyTermParameters').values()
    for value in values:
      value.checkAllValid(complete)

  def checkValid(self, complete=False):
    """
    CheckValid for utrecht.Haddock.HaddockEnergyTerm
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      ll = list()
      objKey = dataDict.get('code')
      ll.append(objKey)
      if (objKey is not None):
        objKey = dataDict.get('termId')
        ll.append(objKey)
        if (objKey is not None):
          objKey = tuple(ll)

      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('run')
        dd = value.__dict__.get('haddockEnergyTerms')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'run' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      # check attributes
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('code')
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: code:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: code:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: code:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: code:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('details')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: details:
           memops.Implementation.Text input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 254):
          raise ApiError("""%s.checkValid: details:
           memops.Implementation.Text maximum length is 254 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: details:
           memops.Implementation.Text: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('fileName')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: fileName:
           memops.Implementation.PathString input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (value.find(chr(92)) == -1)):
          raise ApiError("""%s.checkValid: fileName:
           PathString constraint contains_no_backslash violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: fileName:
           PathString constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('name')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: name:
           memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: name:
           memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: name:
           memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: name:
           Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('termId')
      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.checkValid: termId:
         memops.Implementation.PositiveInt input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value > 0)):
        raise ApiError("""%s.checkValid: termId:
         PositiveInt constraint int_value_gt_0 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('constraintList')
      if (value is not None):
        from ccp.api.nmr.NmrConstraint import AbstractConstraintList as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: constraintList:
           value is not of class ccp.nmr.NmrConstraint.AbstractConstraintList""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('run')
        xx2 = xx1.__dict__.get('nmrConstraintStore')
        yy1 = value.__dict__.get('topObject')
        if (not (xx2 is yy1)):
          raise ApiError("""%s.checkValid: constraintList:
           Link constraintList between objects from separate partitions
           - utrecht.Haddock.Run.nmrConstraintStore not set correctly""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('energyTerm')
      if (value is not None):
        from molsim.api.AnnealProtocol import EnergyTerm as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: energyTerm:
           value is not of class molsim.AnnealProtocol.EnergyTerm""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('haddockEnergyTerms')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: energyTerm:
           non-reciprocal link energyTerm from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      values = dataDict.get('energyTermParameters').values()
      for value in values:
        if (not isinstance(value, EnergyTermParameter)):
          raise ApiError("""%s.checkValid: energyTermParameters:
           value is not of class utrecht.Haddock.EnergyTermParameter""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('haddockEnergyTerm')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: energyTermParameters:
           non-reciprocal link energyTermParameters from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      value = dataDict.get('run')
      if (not isinstance(value, Run)):
        raise ApiError("""%s.checkValid: run:
         value is not of class utrecht.Haddock.Run""" % self.qualifiedName
         + ": %s" % (value,)
        )

    # check explicit class constraints
    # check attributes
    values = dataDict.get('applicationData')
    for value in values:
      value.checkAllValid(complete)

    value = dataDict.get('code')
    if (value is None):
      raise ApiError("""%s.checkValid: code:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('details')
    value = dataDict.get('fileName')
    value = dataDict.get('name')
    value = dataDict.get('termId')
    if (value is None):
      raise ApiError("""%s.checkValid: termId:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    # check roles
    value = dataDict.get('access')
    value = dataDict.get('constraintList')
    value = dataDict.get('energyTerm')
    values = dataDict.get('energyTermParameters').values()
    value = dataDict.get('run')
    if (value is None):
      raise ApiError("""%s.checkValid: run:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

  delete = memops.api.Implementation.DataObject.delete

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData
  
  def findAllEnergyTermParameters(self, **conditions):
    """
    FindAll for utrecht.Haddock.HaddockEnergyTerm.energyTermParameters
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('energyTermParameters').values()
      result = set(currentValues)

    else:
      currentValues = dataDict.get('energyTermParameters').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('code', 'value', 'access', 'haddockEnergyTerm',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData
  
  def findFirstEnergyTermParameter(self, **conditions):
    """
    FindFirst for utrecht.Haddock.HaddockEnergyTerm.energyTermParameters
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('energyTermParameters').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      objKey = conditions.get('code')
      if (objKey is not None):
        result = dataDict.get('energyTermParameters').get(objKey)

        if (nConditions <= 1):
          return result

        elif (result is None):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        currentValues = dataDict.get('energyTermParameters').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('code', 'value', 'access', 'haddockEnergyTerm',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def get(self, name):
    """
    GetAttr for utrecht.Haddock.HaddockEnergyTerm
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for utrecht.Haddock.HaddockEnergyTerm
    """

    result = None
    if (startObj.__class__.__name__ == 'MemopsRoot'):
      if (4 != len(fullKey)):
        raise ApiError("""'utrecht.Haddock.HaddockEnergyTerm'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj0 = startObj
      objKey = fullKey[0]
      obj1 = obj0.__dict__.get('haddockProjects').get(objKey)
      if (obj1 is None):
        obj0.refreshTopObjects('utrecht.Haddock')
        obj1 = obj0.__dict__.get('haddockProjects').get(objKey)

    else:
      if (3 != len(fullKey)):
        raise ApiError("""'utrecht.Haddock.HaddockEnergyTerm'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj1 = startObj

    if (obj1 is not None):
      if (not (obj1.__dict__.get('isLoaded'))):
        obj1.load()

      objKey = fullKey[-3]
      obj2 = obj1.__dict__.get('runs').get(objKey)

      if (obj2 is not None):
        ll = list()
        objKey = fullKey[-2]
        ll.append(objKey)
        if (objKey is not None):
          objKey = fullKey[-1]
          ll.append(objKey)
          if (objKey is not None):
            objKey = tuple(ll)

        obj3 = obj2.__dict__.get('haddockEnergyTerms').get(objKey)
        result = obj3

    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation

  getClassName = memops.api.Implementation.ComplexDataType.getClassName
  
  def getCode(self):
    """
    Get for utrecht.Haddock.HaddockEnergyTerm.code
    """
    dataDict = self.__dict__
    result = dataDict.get('code')
    return result
  
  def getConstraintList(self):
    """
    Get for utrecht.Haddock.HaddockEnergyTerm.constraintList
    """
    dataDict = self.__dict__
    result = dataDict.get('constraintList')
    return result
  
  def getDetails(self):
    """
    Get for utrecht.Haddock.HaddockEnergyTerm.details
    """
    dataDict = self.__dict__
    result = dataDict.get('details')
    return result
  
  def getEnergyTerm(self):
    """
    Get for utrecht.Haddock.HaddockEnergyTerm.energyTerm
    """
    dataDict = self.__dict__
    result = dataDict.get('energyTerm')
    return result
  
  def getEnergyTermParameters(self):
    """
    Get for utrecht.Haddock.HaddockEnergyTerm.energyTermParameters
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('energyTermParameters').values()
    result = frozenset(tempVar)
    return result

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames
  
  def getFileName(self):
    """
    Get for utrecht.Haddock.HaddockEnergyTerm.fileName
    """
    dataDict = self.__dict__
    result = dataDict.get('fileName')
    return result
  
  def getFullKey(self, useGuid=False):
    """
    GetFullKey for utrecht.Haddock.HaddockEnergyTerm
    """
    dataDict = self.__dict__
    result = list()

    obj2 = dataDict.get('run')
    obj1 = obj2.__dict__.get('haddockProject')

    if (useGuid):
      result.append(obj1.__dict__.get('guid'))
    else:
      result.append(obj1.__dict__.get('name'))

    result.append(obj2.__dict__.get('serial'))
    result.append(dataDict.get('code'))
    result.append(dataDict.get('termId'))

    return result

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted
  
  def getLocalKey(self):
    """
    GetLocalKey for utrecht.Haddock.HaddockEnergyTerm
    """
    dataDict = self.__dict__
    ll = list()
    result = dataDict.get('code')
    ll.append(result)
    if (result is not None):
      result = dataDict.get('termId')
      ll.append(result)
      if (result is not None):
        result = tuple(ll)

    return result

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass
  
  def getName(self):
    """
    Get for utrecht.Haddock.HaddockEnergyTerm.name
    """
    dataDict = self.__dict__
    result = dataDict.get('name')
    return result

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName
  
  def getParent(self):
    """
    Get for utrecht.Haddock.HaddockEnergyTerm.parent
    """
    dataDict = self.__dict__
    result = dataDict.get('run')
    return result

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName

  getRoot = memops.api.Implementation.MemopsObject.getRoot
  
  def getRun(self):
    """
    Get for utrecht.Haddock.HaddockEnergyTerm.run
    """
    dataDict = self.__dict__
    result = dataDict.get('run')
    return result
  
  def getTermId(self):
    """
    Get for utrecht.Haddock.HaddockEnergyTerm.termId
    """
    dataDict = self.__dict__
    result = dataDict.get('termId')
    return result

  getTopObject = memops.api.Implementation.DataObject.getTopObject
  
  def newEnergyTermParameter(self, **attrlinks):
    """
    Factory function to create utrecht.Haddock.EnergyTermParameter
    """
    return EnergyTermParameter(self, **attrlinks)

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData
  
  def set(self, name, value):
    """
    SetAttr for utrecht.Haddock.HaddockEnergyTerm
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData
  
  def setCode(self, value):
    """
    Set for utrecht.Haddock.HaddockEnergyTerm.code
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.setCode:
       memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 80):
      raise ApiError("""%s.setCode:
       memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.setCode:
       memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.splitlines()) <= 1)):
      raise ApiError("""%s.setCode:
       Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('code')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setCode:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setCode:
         cannot set code, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setCode:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['code'] = value

    # doNotifies
  
  def setConstraintList(self, value):
    """
    Set for utrecht.Haddock.HaddockEnergyTerm.constraintList
    """
    dataDict = self.__dict__
    if (value is not None):
      from ccp.api.nmr.NmrConstraint import AbstractConstraintList as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setConstraintList:
         value is not of class ccp.nmr.NmrConstraint.AbstractConstraintList""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('constraintList')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setConstraintList:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setConstraintList:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setConstraintList:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('run')
        xx2 = xx1.__dict__.get('nmrConstraintStore')
        yy1 = value.__dict__.get('topObject')
        if (not (xx2 is yy1)):
          raise ApiError("""%s.setConstraintList:
           Link constraintList between objects from separate partitions
           - utrecht.Haddock.Run.nmrConstraintStore not set correctly""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    dataDict['constraintList'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setConstraintList')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setDetails(self, value):
    """
    Set for utrecht.Haddock.HaddockEnergyTerm.details
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setDetails:
         memops.Implementation.Text input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 254):
        raise ApiError("""%s.setDetails:
         memops.Implementation.Text maximum length is 254 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setDetails:
         memops.Implementation.Text: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('details')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setDetails:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setDetails:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['details'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setDetails')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setEnergyTerm(self, value):
    """
    Set for utrecht.Haddock.HaddockEnergyTerm.energyTerm
    """
    dataDict = self.__dict__
    if (value is not None):
      from molsim.api.AnnealProtocol import EnergyTerm as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setEnergyTerm:
         value is not of class molsim.AnnealProtocol.EnergyTerm""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('energyTerm')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      if (value is not None):
        topObject = value.__dict__.get('topObject')
        topObjectsToCheck.add(topObject)

      if (currentValue is not None):
        topObject = currentValue.__dict__.get('topObject')
        topObjectsToCheck.add(topObject)

      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setEnergyTerm:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setEnergyTerm:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setEnergyTerm:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('run')
        xx2 = xx1.__dict__.get('annealProtocol')
        yy1 = value.__dict__.get('annealProtocol')
        if (not (xx2 is yy1)):
          raise ApiError("""%s.setEnergyTerm:
           Link energyTerm between objects from separate partitions
           - utrecht.Haddock.Run.annealProtocol not set correctly""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    if (currentValue is not None):
      if (notIsReading):
        oldSelves = currentValue.__dict__.get('haddockEnergyTerms')
        oldSelves.remove(self)
      else:
        raise ApiError("""%s.setEnergyTerm:
         Read link 'energyTerm' incompatible with pre-existing link""" % self.qualifiedName
         + ": %s" % (self,)
        )

    if (value is not None):
      newSelves = value.__dict__.get('haddockEnergyTerms')
      newSelves.add(self)

    dataDict['energyTerm'] = value
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setEnergyTerm')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setFileName(self, value):
    """
    Set for utrecht.Haddock.HaddockEnergyTerm.fileName
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setFileName:
         memops.Implementation.PathString input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value.find(chr(92)) == -1)):
        raise ApiError("""%s.setFileName:
         PathString constraint contains_no_backslash violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.setFileName:
         PathString constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('fileName')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setFileName:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setFileName:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['fileName'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setFileName')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setName(self, value):
    """
    Set for utrecht.Haddock.HaddockEnergyTerm.name
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.setName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.setName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('name')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setName:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setName:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['name'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setName')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setTermId(self, value):
    """
    Set for utrecht.Haddock.HaddockEnergyTerm.termId
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Int.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Int.create(value)
    else:
      raise ApiError("""%s.setTermId:
       memops.Implementation.PositiveInt input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value > 0)):
      raise ApiError("""%s.setTermId:
       PositiveInt constraint int_value_gt_0 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('termId')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setTermId:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setTermId:
         cannot set termId, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setTermId:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['termId'] = value

    # doNotifies
  
  def sortedEnergyTermParameters(self):
    """
    Sorted for utrecht.Haddock.HaddockEnergyTerm.energyTermParameters
    """
    dataDict = self.__dict__
    sortdd = dataDict.get('energyTermParameters')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  applicationData = memops.api.Implementation.DataObject.applicationData

  className = memops.api.Implementation.ComplexDataType.className
  
  code = property(getCode, setCode, None,
  r"""Code for potential term. Part of class key. Should probably be made into 
  an enumerated data type.
  """)
  
  details = property(getDetails, setDetails, None,
  r"""Free text, for notes, explanatory comments, etc.
  """)

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames
  
  fileName = property(getFileName, setFileName, None,
  r"""name of input file (non-CCPN)
  """)

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted

  metaclass = memops.api.Implementation.ComplexDataType.metaclass
  
  name = property(getName, setName, None,
  r"""User-intelligible name for Energy Term
  """)

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName
  
  termId = property(getTermId, setTermId, None,
  r"""Index of Energy term - distinguishes betweem different terms with the 
  same code. Part of the class key
  """)

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess
  
  constraintList = property(getConstraintList, setConstraintList, None,
  r"""ccp NmrConstraint.ConstraintList associated with HaddockConstraintList
  """)
  
  energyTerm = property(getEnergyTerm, setEnergyTerm, None,
  r"""AnnealProtocol EnergyTerm used.
  """)
  
  energyTermParameters = property(getEnergyTermParameters,  None, None,
  r"""child link to class EnergyTermParameter
  """)
  
  parent = property(getParent, None, None,
  r"""link to parent object - synonym for run
  """)

  root = memops.api.Implementation.MemopsObject.root
  
  run = property(getRun,  None, None,
  r"""parent link
  """)

  topObject = memops.api.Implementation.DataObject.topObject

###############################################################################
class HaddockPartner(memops.api.Implementation.DataObject):
  r"""Haddock interacting unit (may be one or more CCPN chains)
  """
  #   from data model element utrecht.Haddock.HaddockPartner revision ?
  _metaclass = metaPackage.getElement('HaddockPartner')
  _packageName = 'utrecht.Haddock'
  _packageShortName = 'HADD'
  _fieldNames = ('airUpperDistanceLimit', 'applicationData', 'autoHistidinePstate', 'className', 'code', 'fieldNames', 'fileNames', 'forceFieldCode', 'inConstructor', 'isDeleted', 'isDna', 'metaclass', 'packageName', 'packageShortName', 'qualifiedName', 'semiFlexMode', 'access', 'activeAccess', 'chains', 'haddockProject', 'molSystem', 'parent', 'root', 'structureEnsemble', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for utrecht.Haddock.HaddockPartner
    """
    dataDict = self.__dict__
    dataDict['haddockProject'] = parent
    if (not isinstance(parent, HaddockProject)):
      raise ApiError("""%s.__init__:
       value is not of class utrecht.Haddock.HaddockProject""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = parent.__dict__.get('topObject')
    dataDict['topObject'] = topObject

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    if (notIsReading):
      if (not (topObject.__dict__.get('isModifiable'))):
        raise ApiError("""%s.__init__:
         Storage not modifiable""" % self.qualifiedName
         + ": %s" % (topObject,)
        )

    try:
      if (not ((parent.__dict__.get('isLoaded') or parent.__dict__.get('isReading')))):
        parent.load()

      dataDict['airUpperDistanceLimit'] = 2.0
      dataDict['applicationData'] = list()
      dataDict['autoHistidinePstate'] = True
      dataDict['code'] = None
      dataDict['fileNames'] = list()
      dataDict['forceFieldCode'] = 'TOPALLHDG'
      dataDict['isDna'] = False
      dataDict['semiFlexMode'] = 'automatic'
      dataDict['access'] = None
      dataDict['chains'] = {}
      dataDict['molSystem'] = None
      dataDict['structureEnsemble'] = None

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in utrecht.Haddock.HaddockPartner.__init__"
        del dataDict['inConstructor']
        raise

      if (notIsReading):
        childrenDict = parent.__dict__.get('haddockPartners')
        objKey = dataDict.get('code')
        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['code'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notOverride):
        self.checkValid()

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for utrecht.Haddock.HaddockPartner:
       determines cascading 
    deletes to follow from delete of object.
       *Implementation function* - 
    should be called only by API delete function.
    """
    dataDict = self.__dict__
    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    chains = dataDict.get('chains').values()
    for chain in chains:
      if (not (chain in objsToBeDeleted)):
        objsToBeDeleted.add(chain)
        objsToBeChecked.append(chain)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for utrecht.Haddock.HaddockPartner:   deletes
    objects
    *Implementation function* - will CORRUPT DATA if called outside 
    the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    haddockProject = dataDict.get('haddockProject')
    if (not (haddockProject in objsToBeDeleted)):
      objKey = dataDict.get('code')
      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = haddockProject.__dict__.get('haddockPartners')
        if (self is dd.get(objKey)):
          del dd[objKey]

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData
  
  def addFileName(self, value):
    """
    Add for utrecht.Haddock.HaddockPartner.fileNames
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.addFileName:
       memops.Implementation.PathString input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value.find(chr(92)) == -1)):
      raise ApiError("""%s.addFileName:
       PathString constraint contains_no_backslash violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.splitlines()) <= 1)):
      raise ApiError("""%s.addFileName:
       PathString constraint contains_no_linebreak violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('fileNames')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.addFileName:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.addFileName:
       called on deleted object""" % self.qualifiedName
      )

    if (notOverride):
      pass

    currentValues.append(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('addFileName')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def checkAllValid(self, complete=False):
    """
    CheckAllValid for utrecht.Haddock.HaddockPartner
    """
    dataDict = self.__dict__
    self.checkValid(complete)
    values = dataDict.get('chains').values()
    for value in values:
      value.checkAllValid(complete)

  def checkValid(self, complete=False):
    """
    CheckValid for utrecht.Haddock.HaddockPartner
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      objKey = dataDict.get('code')
      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('haddockProject')
        dd = value.__dict__.get('haddockPartners')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'haddockProject' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      # check attributes
      value = dataDict.get('airUpperDistanceLimit')
      if (isinstance(value, memops.api.Implementation.Float.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Float.create(value)
      else:
        raise ApiError("""%s.checkValid: airUpperDistanceLimit:
         memops.Implementation.NonNegativeFloat input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (0.0 <= value)):
        raise ApiError("""%s.checkValid: airUpperDistanceLimit:
         NonNegativeFloat constraint float_value_ge_0 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value - value == 0.0)):
        raise ApiError("""%s.checkValid: airUpperDistanceLimit:
         NonNegativeFloat constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('autoHistidinePstate')
      if (not (value in [True, False])):
        raise ApiError("""%s.checkValid: autoHistidinePstate:
         memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('code')
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: code:
         memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 32):
        raise ApiError("""%s.checkValid: code:
         memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: code:
         memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.checkValid: code:
         Word constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      values = dataDict.get('fileNames')
      for value in values:
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: fileNames:
           memops.Implementation.PathString input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (value.find(chr(92)) == -1)):
          raise ApiError("""%s.checkValid: fileNames:
           PathString constraint contains_no_backslash violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: fileNames:
           PathString constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('forceFieldCode')
      if (not (value in ['TOPALLHDG', 'DNA', 'RNA'])):
        raise ApiError("""%s.checkValid: forceFieldCode:
         utrecht.Haddock.ForceFieldCode input is not in enumeration ['TOPALLHDG', 'DNA', 'RNA']""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.checkValid: forceFieldCode:
         ForceFieldCode constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('isDna')
      if (not (value in [True, False])):
        raise ApiError("""%s.checkValid: isDna:
         memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('semiFlexMode')
      if (not (value in ['manual', 'automatic'])):
        raise ApiError("""%s.checkValid: semiFlexMode:
         utrecht.Haddock.SemiFlexMode input is not in enumeration ['manual', 'automatic']""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.checkValid: semiFlexMode:
         SemiFlexMode constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      values = dataDict.get('chains').values()
      for value in values:
        if (not isinstance(value, Chain)):
          raise ApiError("""%s.checkValid: chains:
           value is not of class utrecht.Haddock.Chain""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('haddockPartner')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: chains:
           non-reciprocal link chains from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      value = dataDict.get('haddockProject')
      if (not isinstance(value, HaddockProject)):
        raise ApiError("""%s.checkValid: haddockProject:
         value is not of class utrecht.Haddock.HaddockProject""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('molSystem')
      from ccp.api.molecule.MolSystem import MolSystem as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.checkValid: molSystem:
         value is not of class ccp.molecule.MolSystem.MolSystem""" % self.qualifiedName
         + ": %s" % (value,)
        )

      xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
      yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
      if (not (xx1 is yy1)):
        raise ApiError("""%s.checkValid: molSystem:
         Link molSystem between objects from separate partitions
         - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
         + ": %s:%s" % (self, value)
        )

      value = dataDict.get('structureEnsemble')
      if (value is not None):
        from ccp.api.molecule.MolStructure import StructureEnsemble as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: structureEnsemble:
           value is not of class ccp.molecule.MolStructure.StructureEnsemble""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: structureEnsemble:
           Link structureEnsemble between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    # check explicit class constraints
    # check attributes
    value = dataDict.get('airUpperDistanceLimit')
    if (value is None):
      raise ApiError("""%s.checkValid: airUpperDistanceLimit:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    values = dataDict.get('applicationData')
    for value in values:
      value.checkAllValid(complete)

    value = dataDict.get('autoHistidinePstate')
    if (value is None):
      raise ApiError("""%s.checkValid: autoHistidinePstate:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('code')
    if (value is None):
      raise ApiError("""%s.checkValid: code:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    values = dataDict.get('fileNames')
    value = dataDict.get('forceFieldCode')
    if (value is None):
      raise ApiError("""%s.checkValid: forceFieldCode:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('isDna')
    if (value is None):
      raise ApiError("""%s.checkValid: isDna:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('semiFlexMode')
    if (value is None):
      raise ApiError("""%s.checkValid: semiFlexMode:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    # check roles
    value = dataDict.get('access')
    values = dataDict.get('chains').values()
    value = dataDict.get('haddockProject')
    if (value is None):
      raise ApiError("""%s.checkValid: haddockProject:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('molSystem')
    if (value is None):
      raise ApiError("""%s.checkValid: molSystem:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('structureEnsemble')
    if (value is not None):
      if (not (value.molSystem is self.molSystem)):
        raise ApiError("""%s.checkValid: structureEnsemble:
         structureEnsemble constraint value_MolSystem_is_selfMolSystem violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

  delete = memops.api.Implementation.DataObject.delete

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData
  
  def findAllChains(self, **conditions):
    """
    FindAll for utrecht.Haddock.HaddockPartner.chains
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('chains').values()
      result = set(currentValues)

    else:
      currentValues = dataDict.get('chains').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('access', 'chain', 'haddockPartner',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData
  
  def findFirstChain(self, **conditions):
    """
    FindFirst for utrecht.Haddock.HaddockPartner.chains
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('chains').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      objKey = conditions.get('chain')
      if (objKey is not None):
        result = dataDict.get('chains').get(objKey)

        if (nConditions <= 1):
          return result

        elif (result is None):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        currentValues = dataDict.get('chains').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('access', 'chain', 'haddockPartner',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def get(self, name):
    """
    GetAttr for utrecht.Haddock.HaddockPartner
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess
  
  def getAirUpperDistanceLimit(self):
    """
    Get for utrecht.Haddock.HaddockPartner.airUpperDistanceLimit
    """
    dataDict = self.__dict__
    result = dataDict.get('airUpperDistanceLimit')
    return result

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getAutoHistidinePstate(self):
    """
    Get for utrecht.Haddock.HaddockPartner.autoHistidinePstate
    """
    dataDict = self.__dict__
    result = dataDict.get('autoHistidinePstate')
    return result
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for utrecht.Haddock.HaddockPartner
    """

    result = None
    if (startObj.__class__.__name__ == 'MemopsRoot'):
      if (2 != len(fullKey)):
        raise ApiError("""'utrecht.Haddock.HaddockPartner'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj0 = startObj
      objKey = fullKey[0]
      obj1 = obj0.__dict__.get('haddockProjects').get(objKey)
      if (obj1 is None):
        obj0.refreshTopObjects('utrecht.Haddock')
        obj1 = obj0.__dict__.get('haddockProjects').get(objKey)

    else:
      if (1 != len(fullKey)):
        raise ApiError("""'utrecht.Haddock.HaddockPartner'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj1 = startObj

    if (obj1 is not None):
      if (not (obj1.__dict__.get('isLoaded'))):
        obj1.load()

      objKey = fullKey[-1]
      obj2 = obj1.__dict__.get('haddockPartners').get(objKey)
      result = obj2

    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation
  
  def getChains(self):
    """
    Get for utrecht.Haddock.HaddockPartner.chains
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('chains').values()
    result = frozenset(tempVar)
    return result

  getClassName = memops.api.Implementation.ComplexDataType.getClassName
  
  def getCode(self):
    """
    Get for utrecht.Haddock.HaddockPartner.code
    """
    dataDict = self.__dict__
    result = dataDict.get('code')
    return result

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames
  
  def getFileNames(self):
    """
    Get for utrecht.Haddock.HaddockPartner.fileNames
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('fileNames')
    result = tuple(tempVar)
    return result
  
  def getForceFieldCode(self):
    """
    Get for utrecht.Haddock.HaddockPartner.forceFieldCode
    """
    dataDict = self.__dict__
    result = dataDict.get('forceFieldCode')
    return result
  
  def getFullKey(self, useGuid=False):
    """
    GetFullKey for utrecht.Haddock.HaddockPartner
    """
    dataDict = self.__dict__
    result = list()

    obj1 = dataDict.get('haddockProject')

    if (useGuid):
      result.append(obj1.__dict__.get('guid'))
    else:
      result.append(obj1.__dict__.get('name'))

    result.append(dataDict.get('code'))

    return result
  
  def getHaddockProject(self):
    """
    Get for utrecht.Haddock.HaddockPartner.haddockProject
    """
    dataDict = self.__dict__
    result = dataDict.get('haddockProject')
    return result

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted
  
  def getIsDna(self):
    """
    Get for utrecht.Haddock.HaddockPartner.isDna
    """
    dataDict = self.__dict__
    result = dataDict.get('isDna')
    return result
  
  def getLocalKey(self):
    """
    GetLocalKey for utrecht.Haddock.HaddockPartner
    """
    dataDict = self.__dict__
    result = dataDict.get('code')
    return result

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass
  
  def getMolSystem(self):
    """
    Get for utrecht.Haddock.HaddockPartner.molSystem
    """
    dataDict = self.__dict__
    result = dataDict.get('molSystem')
    return result

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName
  
  def getParent(self):
    """
    Get for utrecht.Haddock.HaddockPartner.parent
    """
    dataDict = self.__dict__
    result = dataDict.get('haddockProject')
    return result

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName

  getRoot = memops.api.Implementation.MemopsObject.getRoot
  
  def getSemiFlexMode(self):
    """
    Get for utrecht.Haddock.HaddockPartner.semiFlexMode
    """
    dataDict = self.__dict__
    result = dataDict.get('semiFlexMode')
    return result
  
  def getStructureEnsemble(self):
    """
    Get for utrecht.Haddock.HaddockPartner.structureEnsemble
    """
    dataDict = self.__dict__
    result = dataDict.get('structureEnsemble')
    return result

  getTopObject = memops.api.Implementation.DataObject.getTopObject
  
  def newChain(self, **attrlinks):
    """
    Factory function to create utrecht.Haddock.Chain
    """
    return Chain(self, **attrlinks)

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData
  
  def removeFileName(self, value):
    """
    Remove for utrecht.Haddock.HaddockPartner.fileNames
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.removeFileName:
       memops.Implementation.PathString input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value.find(chr(92)) == -1)):
      raise ApiError("""%s.removeFileName:
       PathString constraint contains_no_backslash violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.splitlines()) <= 1)):
      raise ApiError("""%s.removeFileName:
       PathString constraint contains_no_linebreak violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('fileNames')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.removeFileName:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.removeFileName:
       called on deleted object""" % self.qualifiedName
      )

    if (not (value in currentValues)):
      raise ApiError("""%s.removeFileName:
       value not in list""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      pass

    currentValues.remove(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('removeFileName')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def set(self, name, value):
    """
    SetAttr for utrecht.Haddock.HaddockPartner
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess
  
  def setAirUpperDistanceLimit(self, value):
    """
    Set for utrecht.Haddock.HaddockPartner.airUpperDistanceLimit
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Float.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Float.create(value)
    else:
      raise ApiError("""%s.setAirUpperDistanceLimit:
       memops.Implementation.NonNegativeFloat input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (0.0 <= value)):
      raise ApiError("""%s.setAirUpperDistanceLimit:
       NonNegativeFloat constraint float_value_ge_0 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value - value == 0.0)):
      raise ApiError("""%s.setAirUpperDistanceLimit:
       NonNegativeFloat constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('airUpperDistanceLimit')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setAirUpperDistanceLimit:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setAirUpperDistanceLimit:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setAirUpperDistanceLimit:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['airUpperDistanceLimit'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setAirUpperDistanceLimit')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData
  
  def setAutoHistidinePstate(self, value):
    """
    Set for utrecht.Haddock.HaddockPartner.autoHistidinePstate
    """
    dataDict = self.__dict__
    if (not (value in [True, False])):
      raise ApiError("""%s.setAutoHistidinePstate:
       memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('autoHistidinePstate')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setAutoHistidinePstate:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setAutoHistidinePstate:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setAutoHistidinePstate:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['autoHistidinePstate'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setAutoHistidinePstate')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setCode(self, value):
    """
    Set for utrecht.Haddock.HaddockPartner.code
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.setCode:
       memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 32):
      raise ApiError("""%s.setCode:
       memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.setCode:
       memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.split()) == 1)):
      raise ApiError("""%s.setCode:
       Word constraint contains_no_white_space violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('code')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setCode:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setCode:
         cannot set code, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setCode:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['code'] = value

    # doNotifies
  
  def setFileNames(self, values):
    """
    Set for utrecht.Haddock.HaddockPartner.fileNames
    """
    dataDict = self.__dict__
    values = list(values)
    for value in values:
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setFileNames:
         memops.Implementation.PathString input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value.find(chr(92)) == -1)):
        raise ApiError("""%s.setFileNames:
         PathString constraint contains_no_backslash violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.setFileNames:
         PathString constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('fileNames')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setFileNames:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setFileNames:
       called on deleted object""" % self.qualifiedName
      )

    if (values == currentValues):
      return

    if (notOverride):
      pass

    dataDict['fileNames'] = values
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setFileNames')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setForceFieldCode(self, value):
    """
    Set for utrecht.Haddock.HaddockPartner.forceFieldCode
    """
    dataDict = self.__dict__
    if (not (value in ['TOPALLHDG', 'DNA', 'RNA'])):
      raise ApiError("""%s.setForceFieldCode:
       utrecht.Haddock.ForceFieldCode input is not in enumeration ['TOPALLHDG', 'DNA', 'RNA']""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.split()) == 1)):
      raise ApiError("""%s.setForceFieldCode:
       ForceFieldCode constraint contains_no_white_space violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('forceFieldCode')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setForceFieldCode:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setForceFieldCode:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setForceFieldCode:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['forceFieldCode'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setForceFieldCode')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setIsDna(self, value):
    """
    Set for utrecht.Haddock.HaddockPartner.isDna
    """
    dataDict = self.__dict__
    if (not (value in [True, False])):
      raise ApiError("""%s.setIsDna:
       memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('isDna')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setIsDna:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setIsDna:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setIsDna:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['isDna'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setIsDna')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setMolSystem(self, value):
    """
    Set for utrecht.Haddock.HaddockPartner.molSystem
    """
    dataDict = self.__dict__
    from ccp.api.molecule.MolSystem import MolSystem as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.setMolSystem:
       value is not of class ccp.molecule.MolSystem.MolSystem""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('molSystem')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setMolSystem:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setMolSystem:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setMolSystem:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setMolSystem:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
      yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
      if (not (xx1 is yy1)):
        raise ApiError("""%s.setMolSystem:
         Link molSystem between objects from separate partitions
         - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
         + ": %s:%s" % (self, value)
        )

    dataDict['molSystem'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setMolSystem')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setSemiFlexMode(self, value):
    """
    Set for utrecht.Haddock.HaddockPartner.semiFlexMode
    """
    dataDict = self.__dict__
    if (not (value in ['manual', 'automatic'])):
      raise ApiError("""%s.setSemiFlexMode:
       utrecht.Haddock.SemiFlexMode input is not in enumeration ['manual', 'automatic']""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.split()) == 1)):
      raise ApiError("""%s.setSemiFlexMode:
       SemiFlexMode constraint contains_no_white_space violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('semiFlexMode')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setSemiFlexMode:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setSemiFlexMode:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setSemiFlexMode:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['semiFlexMode'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setSemiFlexMode')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setStructureEnsemble(self, value):
    """
    Set for utrecht.Haddock.HaddockPartner.structureEnsemble
    """
    dataDict = self.__dict__
    if (value is not None):
      from ccp.api.molecule.MolStructure import StructureEnsemble as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setStructureEnsemble:
         value is not of class ccp.molecule.MolStructure.StructureEnsemble""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('structureEnsemble')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setStructureEnsemble:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setStructureEnsemble:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setStructureEnsemble:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setStructureEnsemble:
           Link structureEnsemble between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      if (notInConstructor):
        if (value is not None):
          if (not (value.molSystem is self.molSystem)):
            raise ApiError("""%s.setStructureEnsemble:
             structureEnsemble constraint value_MolSystem_is_selfMolSystem violated by value""" % self.qualifiedName
             + ": %s" % (value,)
            )

    dataDict['structureEnsemble'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setStructureEnsemble')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def sortedChains(self):
    """
    Sorted for utrecht.Haddock.HaddockPartner.chains
    """
    dataDict = self.__dict__
    sortdd = dataDict.get('chains')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString
  
  airUpperDistanceLimit = property(getAirUpperDistanceLimit, setAirUpperDistanceLimit, None,
  r"""Sets the upper distance cutoff for Ambiguous Interaction
  """)

  applicationData = memops.api.Implementation.DataObject.applicationData
  
  autoHistidinePstate = property(getAutoHistidinePstate, setAutoHistidinePstate, None,
  r"""auto_his - automatically determine histidine protonation state.
  """)

  className = memops.api.Implementation.ComplexDataType.className
  
  code = property(getCode, setCode, None,
  r"""Haddock ChainCode
  """)

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames
  
  fileNames = property(getFileNames, setFileNames, None,
  r"""Names of files containing ensemble structures.
  NB Classic case only. 
  Obsolescent.
  """)
  
  forceFieldCode = property(getForceFieldCode, setForceFieldCode, None,
  r"""Code for force field usedfor HaddockPartner
  """)

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted
  
  isDna = property(getIsDna, setIsDna, None,
  r"""
  """)

  metaclass = memops.api.Implementation.ComplexDataType.metaclass

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName
  
  semiFlexMode = property(getSemiFlexMode, setSemiFlexMode, None,
  r"""Either set the semi-flexible residues manually or have  
  them defined 
  automatically by Haddock (all residues within 5.0 A of  
  the partner 
  molecule).
  """)

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess
  
  chains = property(getChains,  None, None,
  r"""child link to class Chain
  """)
  
  haddockProject = property(getHaddockProject,  None, None,
  r"""parent link
  """)
  
  molSystem = property(getMolSystem, setMolSystem, None,
  r"""MolSystem that HaddockPartner belongs to
  """)
  
  parent = property(getParent, None, None,
  r"""link to parent object - synonym for haddockProject
  """)

  root = memops.api.Implementation.MemopsObject.root
  
  structureEnsemble = property(getStructureEnsemble, setStructureEnsemble, None,
  r"""StructureEnsemble used for Haddock simulations for partner
  """)

  topObject = memops.api.Implementation.DataObject.topObject

###############################################################################
class HaddockProject(memops.api.Implementation.TopObject):
  r"""Haddock docking program project
  """
  #   from data model element utrecht.Haddock.HaddockProject revision ?
  _metaclass = metaPackage.getElement('HaddockProject')
  _packageName = 'utrecht.Haddock'
  _packageShortName = 'HADD'
  _fieldNames = ('applicationData', 'className', 'createdBy', 'fieldNames', 'guid', 'inConstructor', 'isDeleted', 'isLoaded', 'isModifiable', 'isModified', 'isReading', 'lastUnlockedBy', 'metaclass', 'name', 'packageName', 'packageShortName', 'qualifiedName', 'workingDir', 'access', 'activeAccess', 'activeRepositories', 'haddockPartners', 'memopsRoot', 'packageLocator', 'parent', 'root', 'runs', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for utrecht.Haddock.HaddockProject
    """
    dataDict = self.__dict__
    dataDict['memopsRoot'] = parent
    from memops.api.Implementation import MemopsRoot as importedType
    if (not isinstance(parent, importedType)):
      raise ApiError("""%s.__init__:
       value is not of class memops.Implementation.MemopsRoot""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = self
    dataDict['topObject'] = topObject
    if (attrlinks.get('isReading', False)):
      del attrlinks['isReading']
      dataDict['isLoaded'] = False
      dataDict['isModified'] = False
      dataDict['isReading'] = True
    elif (parent.__dict__.get('isReading')):
      dataDict['isLoaded'] = False
      dataDict['isModified'] = False
      dataDict['isReading'] = True
    else:
      dataDict['isLoaded'] = True
      dataDict['isModified'] = True
      dataDict['isReading'] = False

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    try:
      if (not (dataDict.get('isReading'))):
        parent.refreshTopObjects('utrecht.Haddock')

      dataDict['applicationData'] = list()
      dataDict['createdBy'] = None
      dataDict['guid'] = None
      dataDict['isModifiable'] = True
      dataDict['lastUnlockedBy'] = None
      dataDict['name'] = None
      dataDict['workingDir'] = None
      dataDict['access'] = None
      dataDict['haddockPartners'] = {}
      dataDict['runs'] = {}
      dataDict['activeRepositories'] = list()

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in utrecht.Haddock.HaddockProject.__init__"
        del dataDict['inConstructor']
        raise

      serialDict = {}
      serialDict['runs'] = 0
      dataDict['_serialDict'] = serialDict

      if (notIsReading):
        childrenDict = parent.__dict__.get('haddockProjects')
        objKey = dataDict.get('name')
        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['name'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notIsReading):
        guid = dataDict.get('guid')
        if (guid is None):
          guid = root.newGuid()
          dataDict['guid'] = guid

        dd = root.__dict__.get('topObjects')
        if (dd.get(guid) is None):
          dd[guid] = self
        else:
          raise ApiError("""%s.__init__:
           Creating TopObject with preexisting guid""" % self.qualifiedName
           + ": %s" % (self,)
          )

        dataDict['createdBy'] = root.__dict__.get('currentUserId')

      if (notOverride):
        self.checkValid()

      if ((notIsReading or root.__dict__.get('currentHaddockProject') is None)):
        root.__dict__['currentHaddockProject'] = self

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for utrecht.Haddock.HaddockProject:
       determines cascading 
    deletes to follow from delete of object.
       *Implementation function* - 
    should be called only by API delete function.
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    haddockPartners = dataDict.get('haddockPartners').values()
    for haddockPartner in haddockPartners:
      if (not (haddockPartner in objsToBeDeleted)):
        objsToBeDeleted.add(haddockPartner)
        objsToBeChecked.append(haddockPartner)

    memopsRoot = dataDict.get('memopsRoot')
    if (memopsRoot is not None):
      topObject = memopsRoot.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    runs = dataDict.get('runs').values()
    for run in runs:
      if (not (run in objsToBeDeleted)):
        objsToBeDeleted.add(run)
        objsToBeChecked.append(run)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for utrecht.Haddock.HaddockProject:   deletes
    objects
    *Implementation function* - will CORRUPT DATA if called outside 
    the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    memopsRoot = dataDict.get('memopsRoot')
    if (self is memopsRoot.__dict__.get('currentHaddockProject')):
      memopsRoot.__dict__['currentHaddockProject'] = None

    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    memopsRoot = dataDict.get('memopsRoot')
    if (not (memopsRoot in objsToBeDeleted)):
      objKey = dataDict.get('name')
      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = memopsRoot.__dict__.get('haddockProjects')
        if (self is dd.get(objKey)):
          del dd[objKey]

    dataDict['haddockPartners'] = {}
    dataDict['runs'] = {}

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData

  backup = memops.api.Implementation.TopObject.backup
  
  def checkAllValid(self, complete=False):
    """
    CheckAllValid for utrecht.Haddock.HaddockProject
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    self.checkValid(complete)
    values = dataDict.get('haddockPartners').values()
    for value in values:
      value.checkAllValid(complete)

    values = dataDict.get('runs').values()
    for value in values:
      value.checkAllValid(complete)

  def checkValid(self, complete=False):
    """
    CheckValid for utrecht.Haddock.HaddockProject
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      objKey = dataDict.get('name')
      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('memopsRoot')
        dd = value.__dict__.get('haddockProjects')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'memopsRoot' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      # check attributes
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('createdBy')
      if (value is None):
        raise ApiError("""%s.checkValid: createdBy:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: createdBy:
         memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 32):
        raise ApiError("""%s.checkValid: createdBy:
         memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: createdBy:
         memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.checkValid: createdBy:
         Word constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('guid')
      if (value is None):
        raise ApiError("""%s.checkValid: guid:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: guid:
         memops.Implementation.GuidString input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: guid:
         memops.Implementation.GuidString maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: guid:
         memops.Implementation.GuidString: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: guid:
         GuidString constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      isValid = frozenset('abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_0123456789-').issuperset(value)
      if (not (isValid)):
        raise ApiError("""%s.checkValid: guid:
         GuidString constraint value_is_url_safe violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('isModifiable')
      if (not (value in [True, False])):
        raise ApiError("""%s.checkValid: isModifiable:
         memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('lastUnlockedBy')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: lastUnlockedBy:
           memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 32):
          raise ApiError("""%s.checkValid: lastUnlockedBy:
           memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: lastUnlockedBy:
           memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.split()) == 1)):
          raise ApiError("""%s.checkValid: lastUnlockedBy:
           Word constraint contains_no_white_space violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('name')
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: name:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: name:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: name:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: name:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('workingDir')
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: workingDir:
         memops.Implementation.PathString input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value.find(chr(92)) == -1)):
        raise ApiError("""%s.checkValid: workingDir:
         PathString constraint contains_no_backslash violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: workingDir:
         PathString constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      values = dataDict.get('haddockPartners').values()
      for value in values:
        if (not isinstance(value, HaddockPartner)):
          raise ApiError("""%s.checkValid: haddockPartners:
           value is not of class utrecht.Haddock.HaddockPartner""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('haddockProject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: haddockPartners:
           non-reciprocal link haddockPartners from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      value = dataDict.get('memopsRoot')
      from memops.api.Implementation import MemopsRoot as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.checkValid: memopsRoot:
         value is not of class memops.Implementation.MemopsRoot""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = self.getPackageLocator()
      if (value is None):
        raise ApiError("""%s.checkValid: packageLocator:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      from memops.api.Implementation import PackageLocator as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.checkValid: packageLocator:
         value is not of class memops.Implementation.PackageLocator""" % self.qualifiedName
         + ": %s" % (value,)
        )

      xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
      yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
      if (not (xx1 is yy1)):
        raise ApiError("""%s.checkValid: packageLocator:
         Link packageLocator between objects from separate partitions
         - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
         + ": %s:%s" % (self, value)
        )

      values = dataDict.get('runs').values()
      for value in values:
        if (not isinstance(value, Run)):
          raise ApiError("""%s.checkValid: runs:
           value is not of class utrecht.Haddock.Run""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('haddockProject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: runs:
           non-reciprocal link runs from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

    if (dataDict.get('isLoaded')):
      # check explicit class constraints
      # check attributes
      values = dataDict.get('applicationData')
      for value in values:
        value.checkAllValid(complete)

      value = dataDict.get('isModifiable')
      if (value is None):
        raise ApiError("""%s.checkValid: isModifiable:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      value = dataDict.get('name')
      if (value is None):
        raise ApiError("""%s.checkValid: name:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      value = dataDict.get('workingDir')
      if (value is None):
        raise ApiError("""%s.checkValid: workingDir:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      # check roles
      value = dataDict.get('access')
      values = dataDict.get('haddockPartners').values()
      value = dataDict.get('memopsRoot')
      if (value is None):
        raise ApiError("""%s.checkValid: memopsRoot:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      values = dataDict.get('runs').values()
    else:
      # check unloaded TopObject
      value = dataDict.get('guid')
      if (value is None):
        raise ApiError("""%s.checkValid: guid:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      value = dataDict.get('name')
      if (value is None):
        raise ApiError("""%s.checkValid: name:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

  delete = memops.api.Implementation.DataObject.delete

  findAllActiveRepositories = memops.api.Implementation.TopObject.findAllActiveRepositories

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData
  
  def findAllHaddockPartners(self, **conditions):
    """
    FindAll for utrecht.Haddock.HaddockProject.haddockPartners
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('haddockPartners').values()
      result = set(currentValues)

    else:
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('haddockPartners').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('airUpperDistanceLimit', 'autoHistidinePstate', 'code', 'forceFieldCode', 'isDna', 'semiFlexMode', 'access', 'haddockProject', 'molSystem', 'structureEnsemble',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllRuns(self, **conditions):
    """
    FindAll for utrecht.Haddock.HaddockProject.runs
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('runs').values()
      result = set(currentValues)

    else:
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('runs').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('analysisClustRmsd', 'analysisClustSize', 'analysisDistHBond', 'analysisDistNonbond', 'calcDesolvation', 'centerOfMassConstant', 'centerOfMassRestraints', 'cnsExecutable', 'cpuNumber', 'dielectricType', 'doAirScaling', 'doIncludeDihEnergy', 'doRigidBodyElectrostatics', 'doRigidBodyWaterTrans', 'doRigidTranslations', 'doSAElectrostatics', 'doWaterAnalysis', 'doWaterDock', 'epsilon', 'haddockDir', 'initialRigidBodyMinim', 'nTrails', 'ncsRestraintConstant', 'nonBondedType', 'numAmbRestautoAir', 'numAnalysisStructures', 'numInitWaterShells', 'numIt0Structures', 'numIt1Structures', 'numUnambRestautoAir', 'numWrefStructures', 'queueCommand', 'radomizeStartOriention', 'randomAmbigRestraints', 'randomExclParts', 'randomExcludeAir', 'randomSeed', 'removeNonPolarH', 'rigidbodyIMinteractScaling', 'rotate180It0', 'rotate180It1', 'serial', 'skipStructures', 'solvent', 'surfaceContactConstant', 'surfaceContactRestraints', 'symmetryRestraintConstant', 'useDbSolvateMethod', 'useDnaRestraints', 'useHBondRestraints', 'waterInitRestCutoff', 'waterRestCutoff', 'waterRestScale', 'waterSurfaceCutoff', 'waterToAddRandom', 'waterToKeep', 'access', 'annealProtocol', 'haddockProject', 'nmrConstraintStore',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result

  findFirstActiveRepository = memops.api.Implementation.TopObject.findFirstActiveRepository

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData
  
  def findFirstHaddockPartner(self, **conditions):
    """
    FindFirst for utrecht.Haddock.HaddockProject.haddockPartners
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('haddockPartners').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      objKey = conditions.get('code')
      if (objKey is not None):
        if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
          self.load()

        result = dataDict.get('haddockPartners').get(objKey)

        if (nConditions <= 1):
          return result

        elif (result is None):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
          self.load()

        currentValues = dataDict.get('haddockPartners').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('airUpperDistanceLimit', 'autoHistidinePstate', 'code', 'forceFieldCode', 'isDna', 'semiFlexMode', 'access', 'haddockProject', 'molSystem', 'structureEnsemble',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstRun(self, **conditions):
    """
    FindFirst for utrecht.Haddock.HaddockProject.runs
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('runs').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      objKey = conditions.get('serial')
      if (objKey is not None):
        if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
          self.load()

        result = dataDict.get('runs').get(objKey)

        if (nConditions <= 1):
          return result

        elif (result is None):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
          self.load()

        currentValues = dataDict.get('runs').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('analysisClustRmsd', 'analysisClustSize', 'analysisDistHBond', 'analysisDistNonbond', 'calcDesolvation', 'centerOfMassConstant', 'centerOfMassRestraints', 'cnsExecutable', 'cpuNumber', 'dielectricType', 'doAirScaling', 'doIncludeDihEnergy', 'doRigidBodyElectrostatics', 'doRigidBodyWaterTrans', 'doRigidTranslations', 'doSAElectrostatics', 'doWaterAnalysis', 'doWaterDock', 'epsilon', 'haddockDir', 'initialRigidBodyMinim', 'nTrails', 'ncsRestraintConstant', 'nonBondedType', 'numAmbRestautoAir', 'numAnalysisStructures', 'numInitWaterShells', 'numIt0Structures', 'numIt1Structures', 'numUnambRestautoAir', 'numWrefStructures', 'queueCommand', 'radomizeStartOriention', 'randomAmbigRestraints', 'randomExclParts', 'randomExcludeAir', 'randomSeed', 'removeNonPolarH', 'rigidbodyIMinteractScaling', 'rotate180It0', 'rotate180It1', 'serial', 'skipStructures', 'solvent', 'surfaceContactConstant', 'surfaceContactRestraints', 'symmetryRestraintConstant', 'useDbSolvateMethod', 'useDnaRestraints', 'useHBondRestraints', 'waterInitRestCutoff', 'waterRestCutoff', 'waterRestScale', 'waterSurfaceCutoff', 'waterToAddRandom', 'waterToKeep', 'access', 'annealProtocol', 'haddockProject', 'nmrConstraintStore',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def get(self, name):
    """
    GetAttr for utrecht.Haddock.HaddockProject
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess

  getActiveRepositories = memops.api.Implementation.TopObject.getActiveRepositories

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for utrecht.Haddock.HaddockProject
    """

    result = None
    if (1 != len(fullKey)):
      raise ApiError("""'utrecht.Haddock.HaddockProject'.getByKey:
       getByKey called with fullKey of wrong length. Parameters:"""
       + ": %s:%s" % (startObj, fullKey)
      )

    objKey = fullKey[0]
    obj1 = startObj.__dict__.get('haddockProjects').get(objKey)
    if (obj1 is None):
      startObj.refreshTopObjects('utrecht.Haddock')
      obj1 = startObj.__dict__.get('haddockProjects').get(objKey)

    result = obj1
    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation

  getClassName = memops.api.Implementation.ComplexDataType.getClassName

  getCreatedBy = memops.api.Implementation.TopObject.getCreatedBy

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames
  
  def getFullKey(self, useGuid=False):
    """
    GetFullKey for utrecht.Haddock.HaddockProject
    """
    dataDict = self.__dict__
    result = list()

    if (useGuid):
      result.append(dataDict.get('guid'))
    else:
      result.append(dataDict.get('name'))

    return result

  getGuid = memops.api.Implementation.TopObject.getGuid
  
  def getHaddockPartners(self):
    """
    Get for utrecht.Haddock.HaddockProject.haddockPartners
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    tempVar = dataDict.get('haddockPartners').values()
    result = frozenset(tempVar)
    return result

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted

  getIsLoaded = memops.api.Implementation.TopObject.getIsLoaded

  getIsModifiable = memops.api.Implementation.TopObject.getIsModifiable

  getIsModified = memops.api.Implementation.TopObject.getIsModified

  getIsReading = memops.api.Implementation.TopObject.getIsReading

  getLastUnlockedBy = memops.api.Implementation.TopObject.getLastUnlockedBy
  
  def getLocalKey(self):
    """
    GetLocalKey for utrecht.Haddock.HaddockProject
    """
    dataDict = self.__dict__
    result = dataDict.get('name')
    return result
  
  def getMemopsRoot(self):
    """
    Get for utrecht.Haddock.HaddockProject.memopsRoot
    """
    dataDict = self.__dict__
    result = dataDict.get('memopsRoot')
    return result

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass
  
  def getName(self):
    """
    Get for utrecht.Haddock.HaddockProject.name
    """
    dataDict = self.__dict__
    result = dataDict.get('name')
    return result

  getPackageLocator = memops.api.Implementation.TopObject.getPackageLocator

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName
  
  def getParent(self):
    """
    Get for utrecht.Haddock.HaddockProject.parent
    """
    dataDict = self.__dict__
    result = dataDict.get('memopsRoot')
    return result

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName

  getRoot = memops.api.Implementation.MemopsObject.getRoot
  
  def getRuns(self):
    """
    Get for utrecht.Haddock.HaddockProject.runs
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    tempVar = dataDict.get('runs').values()
    result = frozenset(tempVar)
    return result

  getTopObject = memops.api.Implementation.DataObject.getTopObject
  
  def getWorkingDir(self):
    """
    Get for utrecht.Haddock.HaddockProject.workingDir
    """
    dataDict = self.__dict__
    result = dataDict.get('workingDir')
    return result

  load = memops.api.Implementation.TopObject.load

  loadFrom = memops.api.Implementation.TopObject.loadFrom
  
  def newHaddockPartner(self, **attrlinks):
    """
    Factory function to create utrecht.Haddock.HaddockPartner
    """
    return HaddockPartner(self, **attrlinks)
  
  def newRun(self, **attrlinks):
    """
    Factory function to create utrecht.Haddock.Run
    """
    return Run(self, **attrlinks)

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData

  removeFrom = memops.api.Implementation.TopObject.removeFrom

  restore = memops.api.Implementation.TopObject.restore

  save = memops.api.Implementation.TopObject.save

  saveTo = memops.api.Implementation.TopObject.saveTo
  
  def set(self, name, value):
    """
    SetAttr for utrecht.Haddock.HaddockProject
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData

  setCreatedBy = memops.api.Implementation.TopObject.setCreatedBy

  setGuid = memops.api.Implementation.TopObject.setGuid

  setIsModifiable = memops.api.Implementation.TopObject.setIsModifiable

  setLastUnlockedBy = memops.api.Implementation.TopObject.setLastUnlockedBy
  
  def setName(self, value):
    """
    Set for utrecht.Haddock.HaddockProject.name
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.setName:
       memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 80):
      raise ApiError("""%s.setName:
       memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.setName:
       memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.splitlines()) <= 1)):
      raise ApiError("""%s.setName:
       Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValue = dataDict.get('name')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setName:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setName:
         cannot set name, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['name'] = value

    # doNotifies
  
  def setWorkingDir(self, value):
    """
    Set for utrecht.Haddock.HaddockProject.workingDir
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.setWorkingDir:
       memops.Implementation.PathString input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value.find(chr(92)) == -1)):
      raise ApiError("""%s.setWorkingDir:
       PathString constraint contains_no_backslash violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.splitlines()) <= 1)):
      raise ApiError("""%s.setWorkingDir:
       PathString constraint contains_no_linebreak violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValue = dataDict.get('workingDir')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setWorkingDir:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setWorkingDir:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setWorkingDir:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['workingDir'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setWorkingDir')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def sortedHaddockPartners(self):
    """
    Sorted for utrecht.Haddock.HaddockProject.haddockPartners
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    sortdd = dataDict.get('haddockPartners')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result
  
  def sortedRuns(self):
    """
    Sorted for utrecht.Haddock.HaddockProject.runs
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    sortdd = dataDict.get('runs')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  touch = memops.api.Implementation.TopObject.touch

  applicationData = memops.api.Implementation.DataObject.applicationData

  className = memops.api.Implementation.ComplexDataType.className

  createdBy = memops.api.Implementation.TopObject.createdBy

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames

  guid = memops.api.Implementation.TopObject.guid

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted

  isLoaded = memops.api.Implementation.TopObject.isLoaded

  isModifiable = memops.api.Implementation.TopObject.isModifiable

  isModified = memops.api.Implementation.TopObject.isModified

  isReading = memops.api.Implementation.TopObject.isReading

  lastUnlockedBy = memops.api.Implementation.TopObject.lastUnlockedBy

  metaclass = memops.api.Implementation.ComplexDataType.metaclass
  
  name = property(getName, setName, None,
  r"""name of project serves as identifier
  """)

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName
  
  workingDir = property(getWorkingDir, setWorkingDir, None,
  r"""Working directory where all project files are found.
  NB Classic only.
  """)

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess

  activeRepositories = memops.api.Implementation.TopObject.activeRepositories
  
  haddockPartners = property(getHaddockPartners,  None, None,
  r"""child link to class HaddockPartner
  """)
  
  memopsRoot = property(getMemopsRoot,  None, None,
  r"""parent link
  """)

  packageLocator = memops.api.Implementation.TopObject.packageLocator
  
  parent = property(getParent, None, None,
  r"""link to parent object - synonym for memopsRoot
  """)

  root = memops.api.Implementation.MemopsObject.root
  
  runs = property(getRuns,  None, None,
  r"""child link to class Run
  """)

  topObject = memops.api.Implementation.DataObject.topObject

###############################################################################
class Residue(memops.api.Implementation.DataObject):
  r"""CCPN Residue.
  """
  #   from data model element utrecht.Haddock.Residue revision ?
  _metaclass = metaPackage.getElement('Residue')
  _packageName = 'utrecht.Haddock'
  _packageShortName = 'HADD'
  _fieldNames = ('applicationData', 'className', 'fieldNames', 'flexibility', 'haddockSeqId', 'inConstructor', 'interaction', 'isDeleted', 'metaclass', 'packageName', 'packageShortName', 'qualifiedName', 'access', 'activeAccess', 'chain', 'parent', 'residue', 'root', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for utrecht.Haddock.Residue
    """
    dataDict = self.__dict__
    dataDict['chain'] = parent
    if (not isinstance(parent, Chain)):
      raise ApiError("""%s.__init__:
       value is not of class utrecht.Haddock.Chain""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = parent.__dict__.get('topObject')
    dataDict['topObject'] = topObject

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    if (notIsReading):
      if (not (topObject.__dict__.get('isModifiable'))):
        raise ApiError("""%s.__init__:
         Storage not modifiable""" % self.qualifiedName
         + ": %s" % (topObject,)
        )

    try:

      dataDict['applicationData'] = list()
      dataDict['flexibility'] = 'none'
      dataDict['haddockSeqId'] = None
      dataDict['interaction'] = 'none'
      dataDict['access'] = None
      dataDict['residue'] = None

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in utrecht.Haddock.Residue.__init__"
        del dataDict['inConstructor']
        raise

      if (notIsReading):
        childrenDict = parent.__dict__.get('residues')
        objKey = dataDict.get('residue')
        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['residue'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notOverride):
        self.checkValid()

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for utrecht.Haddock.Residue:
       determines cascading deletes 
    to follow from delete of object.
       *Implementation function* - should 
    be called only by API delete function.
    """
    dataDict = self.__dict__
    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for utrecht.Haddock.Residue:   deletes
    objects
    *Implementation function* - will CORRUPT DATA if called outside 
    the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    chain = dataDict.get('chain')
    if (not (chain in objsToBeDeleted)):
      objKey = dataDict.get('residue')
      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = chain.__dict__.get('residues')
        if (self is dd.get(objKey)):
          del dd[objKey]

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData
  
  def checkAllValid(self, complete=False):
    """
    CheckAllValid for utrecht.Haddock.Residue
    """
    dataDict = self.__dict__
    self.checkValid(complete)
  
  def checkValid(self, complete=False):
    """
    CheckValid for utrecht.Haddock.Residue
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      objKey = dataDict.get('residue')
      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('chain')
        dd = value.__dict__.get('residues')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'chain' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      # check attributes
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('flexibility')
      if (not (value in ['semi', 'full', 'none'])):
        raise ApiError("""%s.checkValid: flexibility:
         utrecht.Haddock.ResidueFlexibility input is not in enumeration ['semi', 'full', 'none']""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.checkValid: flexibility:
         ResidueFlexibility constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('haddockSeqId')
      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.checkValid: haddockSeqId:
         memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('interaction')
      if (not (value in ['active', 'passive', 'none'])):
        raise ApiError("""%s.checkValid: interaction:
         utrecht.Haddock.HaddockInteraction input is not in enumeration ['active', 'passive', 'none']""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.checkValid: interaction:
         HaddockInteraction constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('chain')
      if (not isinstance(value, Chain)):
        raise ApiError("""%s.checkValid: chain:
         value is not of class utrecht.Haddock.Chain""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('residue')
      from ccp.api.molecule.MolSystem import Residue as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.checkValid: residue:
         value is not of class ccp.molecule.MolSystem.Residue""" % self.qualifiedName
         + ": %s" % (value,)
        )

      xx1 = dataDict.get('chain')
      xx2 = xx1.__dict__.get('chain')
      yy1 = value.__dict__.get('chain')
      if (not (xx2 is yy1)):
        raise ApiError("""%s.checkValid: residue:
         Link residue between objects from separate partitions
         - utrecht.Haddock.Chain.chain not set correctly""" % self.qualifiedName
         + ": %s:%s" % (self, value)
        )

    # check explicit class constraints
    # check attributes
    values = dataDict.get('applicationData')
    for value in values:
      value.checkAllValid(complete)

    value = dataDict.get('flexibility')
    if (value is None):
      raise ApiError("""%s.checkValid: flexibility:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('haddockSeqId')
    if (value is None):
      raise ApiError("""%s.checkValid: haddockSeqId:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('interaction')
    if (value is None):
      raise ApiError("""%s.checkValid: interaction:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    # check roles
    value = dataDict.get('access')
    value = dataDict.get('chain')
    if (value is None):
      raise ApiError("""%s.checkValid: chain:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('residue')
    if (value is None):
      raise ApiError("""%s.checkValid: residue:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

  delete = memops.api.Implementation.DataObject.delete

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData
  
  def get(self, name):
    """
    GetAttr for utrecht.Haddock.Residue
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for utrecht.Haddock.Residue
    """

    result = None
    if (startObj.__class__.__name__ == 'MemopsRoot'):
      if (4 != len(fullKey)):
        raise ApiError("""'utrecht.Haddock.Residue'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj0 = startObj
      objKey = fullKey[0]
      obj1 = obj0.__dict__.get('haddockProjects').get(objKey)
      if (obj1 is None):
        obj0.refreshTopObjects('utrecht.Haddock')
        obj1 = obj0.__dict__.get('haddockProjects').get(objKey)

    else:
      if (3 != len(fullKey)):
        raise ApiError("""'utrecht.Haddock.Residue'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj1 = startObj

    if (obj1 is not None):
      if (not (obj1.__dict__.get('isLoaded'))):
        obj1.load()

      objKey = fullKey[-3]
      obj2 = obj1.__dict__.get('haddockPartners').get(objKey)

      if (obj2 is not None):
        objKey = fullKey[-2]
        obj3 = obj2.__dict__.get('chains').get(objKey)

        if (obj3 is not None):
          objKey = fullKey[-1]
          obj4 = obj3.__dict__.get('residues').get(objKey)
          result = obj4

    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation
  
  def getChain(self):
    """
    Get for utrecht.Haddock.Residue.chain
    """
    dataDict = self.__dict__
    result = dataDict.get('chain')
    return result

  getClassName = memops.api.Implementation.ComplexDataType.getClassName

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames
  
  def getFlexibility(self):
    """
    Get for utrecht.Haddock.Residue.flexibility
    """
    dataDict = self.__dict__
    result = dataDict.get('flexibility')
    return result
  
  def getFullKey(self, useGuid=False):
    """
    GetFullKey for utrecht.Haddock.Residue
    """
    dataDict = self.__dict__
    result = list()

    obj3 = dataDict.get('chain')
    obj2 = obj3.__dict__.get('haddockPartner')
    obj1 = obj2.__dict__.get('haddockProject')

    if (useGuid):
      result.append(obj1.__dict__.get('guid'))
    else:
      result.append(obj1.__dict__.get('name'))

    result.append(obj2.__dict__.get('code'))
    result.append(obj3.__dict__.get('chain'))
    result.append(dataDict.get('residue'))

    return result
  
  def getHaddockSeqId(self):
    """
    Get for utrecht.Haddock.Residue.haddockSeqId
    """
    dataDict = self.__dict__
    result = dataDict.get('haddockSeqId')
    return result

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor
  
  def getInteraction(self):
    """
    Get for utrecht.Haddock.Residue.interaction
    """
    dataDict = self.__dict__
    result = dataDict.get('interaction')
    return result

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted
  
  def getLocalKey(self):
    """
    GetLocalKey for utrecht.Haddock.Residue
    """
    dataDict = self.__dict__
    result = dataDict.get('residue')
    return result

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName
  
  def getParent(self):
    """
    Get for utrecht.Haddock.Residue.parent
    """
    dataDict = self.__dict__
    result = dataDict.get('chain')
    return result

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName
  
  def getResidue(self):
    """
    Get for utrecht.Haddock.Residue.residue
    """
    dataDict = self.__dict__
    result = dataDict.get('residue')
    return result

  getRoot = memops.api.Implementation.MemopsObject.getRoot

  getTopObject = memops.api.Implementation.DataObject.getTopObject

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData
  
  def set(self, name, value):
    """
    SetAttr for utrecht.Haddock.Residue
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData
  
  def setFlexibility(self, value):
    """
    Set for utrecht.Haddock.Residue.flexibility
    """
    dataDict = self.__dict__
    if (not (value in ['semi', 'full', 'none'])):
      raise ApiError("""%s.setFlexibility:
       utrecht.Haddock.ResidueFlexibility input is not in enumeration ['semi', 'full', 'none']""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.split()) == 1)):
      raise ApiError("""%s.setFlexibility:
       ResidueFlexibility constraint contains_no_white_space violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('flexibility')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setFlexibility:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setFlexibility:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setFlexibility:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['flexibility'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setFlexibility')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setHaddockSeqId(self, value):
    """
    Set for utrecht.Haddock.Residue.haddockSeqId
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Int.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Int.create(value)
    else:
      raise ApiError("""%s.setHaddockSeqId:
       memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('haddockSeqId')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setHaddockSeqId:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setHaddockSeqId:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setHaddockSeqId:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['haddockSeqId'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setHaddockSeqId')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setInteraction(self, value):
    """
    Set for utrecht.Haddock.Residue.interaction
    """
    dataDict = self.__dict__
    if (not (value in ['active', 'passive', 'none'])):
      raise ApiError("""%s.setInteraction:
       utrecht.Haddock.HaddockInteraction input is not in enumeration ['active', 'passive', 'none']""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.split()) == 1)):
      raise ApiError("""%s.setInteraction:
       HaddockInteraction constraint contains_no_white_space violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('interaction')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setInteraction:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setInteraction:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setInteraction:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['interaction'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setInteraction')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setResidue(self, value):
    """
    Set for utrecht.Haddock.Residue.residue
    """
    dataDict = self.__dict__
    from ccp.api.molecule.MolSystem import Residue as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.setResidue:
       value is not of class ccp.molecule.MolSystem.Residue""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('residue')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setResidue:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setResidue:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setResidue:
         cannot set residue, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setResidue:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      xx1 = dataDict.get('chain')
      xx2 = xx1.__dict__.get('chain')
      yy1 = value.__dict__.get('chain')
      if (not (xx2 is yy1)):
        raise ApiError("""%s.setResidue:
         Link residue between objects from separate partitions
         - utrecht.Haddock.Chain.chain not set correctly""" % self.qualifiedName
         + ": %s:%s" % (self, value)
        )

    dataDict['residue'] = value

    # doNotifies

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  applicationData = memops.api.Implementation.DataObject.applicationData

  className = memops.api.Implementation.ComplexDataType.className

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames
  
  flexibility = property(getFlexibility, setFlexibility, None,
  r"""Residue flexibility during Haddock run
  """)
  
  haddockSeqId = property(getHaddockSeqId, setHaddockSeqId, None,
  r"""HAddock seq Id - giving residue number in the Haddock system consisting 
  of a single (virtual) chain.
  """)

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor
  
  interaction = property(getInteraction, setInteraction, None,
  r"""Residue behaviour as a Haddock restraint. Either active, passive, or 
  none.
  """)

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted

  metaclass = memops.api.Implementation.ComplexDataType.metaclass

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess
  
  chain = property(getChain,  None, None,
  r"""parent link
  """)
  
  parent = property(getParent, None, None,
  r"""link to parent object - synonym for chain
  """)
  
  residue = property(getResidue, setResidue, None,
  r"""MolSystem.Residue corresponding to Haddock.Residue
  """)

  root = memops.api.Implementation.MemopsObject.root

  topObject = memops.api.Implementation.DataObject.topObject

###############################################################################
class Run(memops.api.Implementation.DataObject):
  r"""Haddock Run
  """
  #   from data model element utrecht.Haddock.Run revision ?
  _metaclass = metaPackage.getElement('Run')
  _packageName = 'utrecht.Haddock'
  _packageShortName = 'HADD'
  _fieldNames = ('analysisClustRmsd', 'analysisClustSize', 'analysisDistHBond', 'analysisDistNonbond', 'applicationData', 'calcDesolvation', 'centerOfMassConstant', 'centerOfMassRestraints', 'className', 'cnsExecutable', 'cpuNumber', 'dielectricType', 'doAirScaling', 'doIncludeDihEnergy', 'doRigidBodyElectrostatics', 'doRigidBodyWaterTrans', 'doRigidTranslations', 'doSAElectrostatics', 'doWaterAnalysis', 'doWaterDock', 'epsilon', 'fieldNames', 'haddockDir', 'inConstructor', 'initialRigidBodyMinim', 'isDeleted', 'metaclass', 'nTrails', 'ncsRestraintConstant', 'nonBondedType', 'numAmbRestautoAir', 'numAnalysisStructures', 'numInitWaterShells', 'numIt0Structures', 'numIt1Structures', 'numUnambRestautoAir', 'numWrefStructures', 'packageName', 'packageShortName', 'qualifiedName', 'queueCommand', 'radomizeStartOriention', 'randomAmbigRestraints', 'randomExclParts', 'randomExcludeAir', 'randomSeed', 'removeNonPolarH', 'rigidbodyIMinteractScaling', 'rotate180It0', 'rotate180It1', 'serial', 'skipStructures', 'solvent', 'surfaceContactConstant', 'surfaceContactRestraints', 'symmetryRestraintConstant', 'useDbSolvateMethod', 'useDnaRestraints', 'useHBondRestraints', 'waterInitRestCutoff', 'waterRestCutoff', 'waterRestScale', 'waterSurfaceCutoff', 'waterToAddRandom', 'waterToKeep', 'access', 'activeAccess', 'annealProtocol', 'haddockEnergyTerms', 'haddockProject', 'nmrConstraintStore', 'parent', 'root', 'scoringWeights', 'symmetryRestraints', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for utrecht.Haddock.Run
    """
    dataDict = self.__dict__
    dataDict['haddockProject'] = parent
    if (not isinstance(parent, HaddockProject)):
      raise ApiError("""%s.__init__:
       value is not of class utrecht.Haddock.HaddockProject""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = parent.__dict__.get('topObject')
    dataDict['topObject'] = topObject

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    if (notIsReading):
      if (not (topObject.__dict__.get('isModifiable'))):
        raise ApiError("""%s.__init__:
         Storage not modifiable""" % self.qualifiedName
         + ": %s" % (topObject,)
        )

    try:
      if (not ((parent.__dict__.get('isLoaded') or parent.__dict__.get('isReading')))):
        parent.load()

      dataDict['analysisClustRmsd'] = 7.5
      dataDict['analysisClustSize'] = 4
      dataDict['analysisDistHBond'] = 2.5
      dataDict['analysisDistNonbond'] = 3.9
      dataDict['applicationData'] = list()
      dataDict['calcDesolvation'] = False
      dataDict['centerOfMassConstant'] = 1.0
      dataDict['centerOfMassRestraints'] = False
      dataDict['cnsExecutable'] = '/cns/cns_solve_1.2/binaries/cns'
      dataDict['cpuNumber'] = 10
      dataDict['dielectricType'] = 'cdie'
      dataDict['doAirScaling'] = False
      dataDict['doIncludeDihEnergy'] = True
      dataDict['doRigidBodyElectrostatics'] = True
      dataDict['doRigidBodyWaterTrans'] = True
      dataDict['doRigidTranslations'] = True
      dataDict['doSAElectrostatics'] = True
      dataDict['doWaterAnalysis'] = False
      dataDict['doWaterDock'] = False
      dataDict['epsilon'] = 10.0
      dataDict['haddockDir'] = '/home/software/haddock2.0'
      dataDict['initialRigidBodyMinim'] = True
      dataDict['nTrails'] = 5
      dataDict['ncsRestraintConstant'] = 10.0
      dataDict['nonBondedType'] = 'OPLSX'
      dataDict['numAmbRestautoAir'] = 0
      dataDict['numAnalysisStructures'] = 200
      dataDict['numInitWaterShells'] = 1
      dataDict['numIt0Structures'] = 1000
      dataDict['numIt1Structures'] = 200
      dataDict['numUnambRestautoAir'] = 25
      dataDict['numWrefStructures'] = 200
      dataDict['queueCommand'] = 'csh'
      dataDict['radomizeStartOriention'] = True
      dataDict['randomAmbigRestraints'] = False
      dataDict['randomExclParts'] = 2
      dataDict['randomExcludeAir'] = True
      dataDict['randomSeed'] = 917
      dataDict['removeNonPolarH'] = False
      dataDict['rigidbodyIMinteractScaling'] = 1.0
      dataDict['rotate180It0'] = True
      dataDict['rotate180It1'] = False
      dataDict['serial'] = None
      dataDict['skipStructures'] = 0
      dataDict['solvent'] = 'water'
      dataDict['surfaceContactConstant'] = 1.0
      dataDict['surfaceContactRestraints'] = False
      dataDict['symmetryRestraintConstant'] = 10.0
      dataDict['useDbSolvateMethod'] = True
      dataDict['useDnaRestraints'] = False
      dataDict['useHBondRestraints'] = False
      dataDict['waterInitRestCutoff'] = 5.0
      dataDict['waterRestCutoff'] = 5.0
      dataDict['waterRestScale'] = 25.0
      dataDict['waterSurfaceCutoff'] = 8.0
      dataDict['waterToAddRandom'] = 0.0
      dataDict['waterToKeep'] = 0.25
      dataDict['access'] = None
      dataDict['annealProtocol'] = None
      dataDict['haddockEnergyTerms'] = {}
      dataDict['nmrConstraintStore'] = None
      dataDict['scoringWeights'] = {}
      dataDict['symmetryRestraints'] = set()

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in utrecht.Haddock.Run.__init__"
        del dataDict['inConstructor']
        raise

      if (notOverride):
        if (dataDict.get('serial') is None):
          dataDict['inConstructor'] = True
          self.setSerial(-1)
          del dataDict['inConstructor']
        else:
          raise ApiError("""%s.__init__:
           Cannot pass in explicit serial if not reading""" % self.qualifiedName
           + ": %s:%s" % (parent, 'utrecht.Haddock.Run')
          )

      if (notIsReading):
        childrenDict = parent.__dict__.get('runs')
        objKey = dataDict.get('serial')
        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['serial'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notOverride):
        self.checkValid()

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for utrecht.Haddock.Run:
       determines cascading deletes to 
    follow from delete of object.
       *Implementation function* - should be 
    called only by API delete function.
    """
    dataDict = self.__dict__
    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    annealProtocol = dataDict.get('annealProtocol')
    if (annealProtocol is not None):
      topObject = annealProtocol.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    haddockEnergyTerms = dataDict.get('haddockEnergyTerms').values()
    for haddockEnergyTerm in haddockEnergyTerms:
      if (not (haddockEnergyTerm in objsToBeDeleted)):
        objsToBeDeleted.add(haddockEnergyTerm)
        objsToBeChecked.append(haddockEnergyTerm)

    scoringWeights = dataDict.get('scoringWeights').values()
    for scoringWeight in scoringWeights:
      if (not (scoringWeight in objsToBeDeleted)):
        objsToBeDeleted.add(scoringWeight)
        objsToBeChecked.append(scoringWeight)

    symmetryRestraints = dataDict.get('symmetryRestraints')
    pass
    for symmetryRestraint in symmetryRestraints:
      topObject = symmetryRestraint.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for utrecht.Haddock.Run:   deletes objects
    *Implementation 
    function* - will CORRUPT DATA if called outside the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    annealProtocol = dataDict.get('annealProtocol')
    if ((annealProtocol is not None and not (annealProtocol in objsToBeDeleted))):
      haddockRuns = annealProtocol.__dict__.get('haddockRuns')
      haddockRuns.remove(self)

    for symmetryRestraint in dataDict.get('symmetryRestraints'):
      if (not (symmetryRestraint in objsToBeDeleted)):
        haddockRuns = symmetryRestraint.__dict__.get('haddockRuns')
        haddockRuns.remove(self)

    haddockProject = dataDict.get('haddockProject')
    if (not (haddockProject in objsToBeDeleted)):
      objKey = dataDict.get('serial')
      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = haddockProject.__dict__.get('runs')
        if (self is dd.get(objKey)):
          del dd[objKey]

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData
  
  def addSymmetryRestraint(self, value):
    """
    Add for utrecht.Haddock.Run.symmetryRestraints
    """
    dataDict = self.__dict__
    from molsim.api.Symmetry import Symmetry as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.addSymmetryRestraint:
       value is not of class molsim.Symmetry.Symmetry""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('symmetryRestraints')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      topObject = value.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)
      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.addSymmetryRestraint:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.addSymmetryRestraint:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.addSymmetryRestraint:
       called with deleted value""" % self.qualifiedName
      )

    if (value in currentValues):
      raise ApiError("""%s.addSymmetryRestraint:
       value is in list already""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.addSymmetryRestraint:
           Link symmetryRestraints between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    oldSelves = value.__dict__.get('haddockRuns')
    oldSelves.add(self)
    currentValues.add(value)
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('addSymmetryRestraint')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def checkAllValid(self, complete=False):
    """
    CheckAllValid for utrecht.Haddock.Run
    """
    dataDict = self.__dict__
    self.checkValid(complete)
    values = dataDict.get('haddockEnergyTerms').values()
    for value in values:
      value.checkAllValid(complete)

    values = dataDict.get('scoringWeights').values()
    for value in values:
      value.checkAllValid(complete)

  def checkValid(self, complete=False):
    """
    CheckValid for utrecht.Haddock.Run
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      objKey = dataDict.get('serial')
      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('haddockProject')
        dd = value.__dict__.get('runs')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'haddockProject' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      # check attributes
      value = dataDict.get('analysisClustRmsd')
      if (isinstance(value, memops.api.Implementation.Float.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Float.create(value)
      else:
        raise ApiError("""%s.checkValid: analysisClustRmsd:
         memops.Implementation.PositiveFloat input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value > 0)):
        raise ApiError("""%s.checkValid: analysisClustRmsd:
         PositiveFloat constraint float_value_gt_0 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value - value == 0.0)):
        raise ApiError("""%s.checkValid: analysisClustRmsd:
         PositiveFloat constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('analysisClustSize')
      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.checkValid: analysisClustSize:
         memops.Implementation.NonNegativeInt input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value >= 0)):
        raise ApiError("""%s.checkValid: analysisClustSize:
         NonNegativeInt constraint int_value_ge_0 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('analysisDistHBond')
      if (isinstance(value, memops.api.Implementation.Float.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Float.create(value)
      else:
        raise ApiError("""%s.checkValid: analysisDistHBond:
         memops.Implementation.PositiveFloat input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value > 0)):
        raise ApiError("""%s.checkValid: analysisDistHBond:
         PositiveFloat constraint float_value_gt_0 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value - value == 0.0)):
        raise ApiError("""%s.checkValid: analysisDistHBond:
         PositiveFloat constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('analysisDistNonbond')
      if (isinstance(value, memops.api.Implementation.Float.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Float.create(value)
      else:
        raise ApiError("""%s.checkValid: analysisDistNonbond:
         memops.Implementation.PositiveFloat input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value > 0)):
        raise ApiError("""%s.checkValid: analysisDistNonbond:
         PositiveFloat constraint float_value_gt_0 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value - value == 0.0)):
        raise ApiError("""%s.checkValid: analysisDistNonbond:
         PositiveFloat constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('calcDesolvation')
      if (not (value in [True, False])):
        raise ApiError("""%s.checkValid: calcDesolvation:
         memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('centerOfMassConstant')
      if (isinstance(value, memops.api.Implementation.Float.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Float.create(value)
      else:
        raise ApiError("""%s.checkValid: centerOfMassConstant:
         memops.Implementation.NonNegativeFloat input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (0.0 <= value)):
        raise ApiError("""%s.checkValid: centerOfMassConstant:
         NonNegativeFloat constraint float_value_ge_0 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value - value == 0.0)):
        raise ApiError("""%s.checkValid: centerOfMassConstant:
         NonNegativeFloat constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('centerOfMassRestraints')
      if (not (value in [True, False])):
        raise ApiError("""%s.checkValid: centerOfMassRestraints:
         memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('cnsExecutable')
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: cnsExecutable:
         memops.Implementation.PathString input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value.find(chr(92)) == -1)):
        raise ApiError("""%s.checkValid: cnsExecutable:
         PathString constraint contains_no_backslash violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: cnsExecutable:
         PathString constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('cpuNumber')
      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.checkValid: cpuNumber:
         memops.Implementation.NonNegativeInt input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value >= 0)):
        raise ApiError("""%s.checkValid: cpuNumber:
         NonNegativeInt constraint int_value_ge_0 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('dielectricType')
      if (not (value in ['cdie', 'rdie'])):
        raise ApiError("""%s.checkValid: dielectricType:
         utrecht.Haddock.DielectricType input is not in enumeration ['cdie', 'rdie']""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.checkValid: dielectricType:
         DielectricType constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('doAirScaling')
      if (not (value in [True, False])):
        raise ApiError("""%s.checkValid: doAirScaling:
         memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('doIncludeDihEnergy')
      if (not (value in [True, False])):
        raise ApiError("""%s.checkValid: doIncludeDihEnergy:
         memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('doRigidBodyElectrostatics')
      if (not (value in [True, False])):
        raise ApiError("""%s.checkValid: doRigidBodyElectrostatics:
         memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('doRigidBodyWaterTrans')
      if (not (value in [True, False])):
        raise ApiError("""%s.checkValid: doRigidBodyWaterTrans:
         memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('doRigidTranslations')
      if (not (value in [True, False])):
        raise ApiError("""%s.checkValid: doRigidTranslations:
         memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('doSAElectrostatics')
      if (not (value in [True, False])):
        raise ApiError("""%s.checkValid: doSAElectrostatics:
         memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('doWaterAnalysis')
      if (not (value in [True, False])):
        raise ApiError("""%s.checkValid: doWaterAnalysis:
         memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('doWaterDock')
      if (not (value in [True, False])):
        raise ApiError("""%s.checkValid: doWaterDock:
         memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('epsilon')
      if (isinstance(value, memops.api.Implementation.Float.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Float.create(value)
      else:
        raise ApiError("""%s.checkValid: epsilon:
         memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value - value == 0.0)):
        raise ApiError("""%s.checkValid: epsilon:
         Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('haddockDir')
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: haddockDir:
         memops.Implementation.PathString input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value.find(chr(92)) == -1)):
        raise ApiError("""%s.checkValid: haddockDir:
         PathString constraint contains_no_backslash violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: haddockDir:
         PathString constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('initialRigidBodyMinim')
      if (not (value in [True, False])):
        raise ApiError("""%s.checkValid: initialRigidBodyMinim:
         memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('nTrails')
      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.checkValid: nTrails:
         memops.Implementation.NonNegativeInt input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value >= 0)):
        raise ApiError("""%s.checkValid: nTrails:
         NonNegativeInt constraint int_value_ge_0 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('ncsRestraintConstant')
      if (isinstance(value, memops.api.Implementation.Float.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Float.create(value)
      else:
        raise ApiError("""%s.checkValid: ncsRestraintConstant:
         memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value - value == 0.0)):
        raise ApiError("""%s.checkValid: ncsRestraintConstant:
         Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('nonBondedType')
      if (not (value in ['OPLSX', 'PROLSQ', 'PARMALLH6', 'PARALLHDG'])):
        raise ApiError("""%s.checkValid: nonBondedType:
         utrecht.Haddock.NonBondedType input is not in enumeration ['OPLSX', 'PROLSQ', 'PARMALLH6', 'PARALLHDG']""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.checkValid: nonBondedType:
         NonBondedType constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('numAmbRestautoAir')
      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.checkValid: numAmbRestautoAir:
         memops.Implementation.NonNegativeInt input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value >= 0)):
        raise ApiError("""%s.checkValid: numAmbRestautoAir:
         NonNegativeInt constraint int_value_ge_0 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('numAnalysisStructures')
      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.checkValid: numAnalysisStructures:
         memops.Implementation.NonNegativeInt input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value >= 0)):
        raise ApiError("""%s.checkValid: numAnalysisStructures:
         NonNegativeInt constraint int_value_ge_0 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('numInitWaterShells')
      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.checkValid: numInitWaterShells:
         memops.Implementation.NonNegativeInt input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value >= 0)):
        raise ApiError("""%s.checkValid: numInitWaterShells:
         NonNegativeInt constraint int_value_ge_0 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('numIt0Structures')
      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.checkValid: numIt0Structures:
         memops.Implementation.NonNegativeInt input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value >= 0)):
        raise ApiError("""%s.checkValid: numIt0Structures:
         NonNegativeInt constraint int_value_ge_0 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('numIt1Structures')
      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.checkValid: numIt1Structures:
         memops.Implementation.NonNegativeInt input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value >= 0)):
        raise ApiError("""%s.checkValid: numIt1Structures:
         NonNegativeInt constraint int_value_ge_0 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('numUnambRestautoAir')
      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.checkValid: numUnambRestautoAir:
         memops.Implementation.NonNegativeInt input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value >= 0)):
        raise ApiError("""%s.checkValid: numUnambRestautoAir:
         NonNegativeInt constraint int_value_ge_0 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('numWrefStructures')
      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.checkValid: numWrefStructures:
         memops.Implementation.NonNegativeInt input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value >= 0)):
        raise ApiError("""%s.checkValid: numWrefStructures:
         NonNegativeInt constraint int_value_ge_0 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('queueCommand')
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: queueCommand:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: queueCommand:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: queueCommand:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: queueCommand:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('radomizeStartOriention')
      if (not (value in [True, False])):
        raise ApiError("""%s.checkValid: radomizeStartOriention:
         memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('randomAmbigRestraints')
      if (not (value in [True, False])):
        raise ApiError("""%s.checkValid: randomAmbigRestraints:
         memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('randomExclParts')
      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.checkValid: randomExclParts:
         memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('randomExcludeAir')
      if (not (value in [True, False])):
        raise ApiError("""%s.checkValid: randomExcludeAir:
         memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('randomSeed')
      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.checkValid: randomSeed:
         memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('removeNonPolarH')
      if (not (value in [True, False])):
        raise ApiError("""%s.checkValid: removeNonPolarH:
         memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('rigidbodyIMinteractScaling')
      if (isinstance(value, memops.api.Implementation.Float.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Float.create(value)
      else:
        raise ApiError("""%s.checkValid: rigidbodyIMinteractScaling:
         memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value - value == 0.0)):
        raise ApiError("""%s.checkValid: rigidbodyIMinteractScaling:
         Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('rotate180It0')
      if (not (value in [True, False])):
        raise ApiError("""%s.checkValid: rotate180It0:
         memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('rotate180It1')
      if (not (value in [True, False])):
        raise ApiError("""%s.checkValid: rotate180It1:
         memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('serial')
      if (value is None):
        raise ApiError("""%s.checkValid: serial:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.checkValid: serial:
         memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('skipStructures')
      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.checkValid: skipStructures:
         memops.Implementation.NonNegativeInt input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value >= 0)):
        raise ApiError("""%s.checkValid: skipStructures:
         NonNegativeInt constraint int_value_ge_0 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('solvent')
      if (not (value in ['water', 'dmso'])):
        raise ApiError("""%s.checkValid: solvent:
         utrecht.Haddock.Solvent input is not in enumeration ['water', 'dmso']""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.checkValid: solvent:
         Solvent constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('surfaceContactConstant')
      if (isinstance(value, memops.api.Implementation.Float.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Float.create(value)
      else:
        raise ApiError("""%s.checkValid: surfaceContactConstant:
         memops.Implementation.NonNegativeFloat input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (0.0 <= value)):
        raise ApiError("""%s.checkValid: surfaceContactConstant:
         NonNegativeFloat constraint float_value_ge_0 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value - value == 0.0)):
        raise ApiError("""%s.checkValid: surfaceContactConstant:
         NonNegativeFloat constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('surfaceContactRestraints')
      if (not (value in [True, False])):
        raise ApiError("""%s.checkValid: surfaceContactRestraints:
         memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('symmetryRestraintConstant')
      if (isinstance(value, memops.api.Implementation.Float.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Float.create(value)
      else:
        raise ApiError("""%s.checkValid: symmetryRestraintConstant:
         memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value - value == 0.0)):
        raise ApiError("""%s.checkValid: symmetryRestraintConstant:
         Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('useDbSolvateMethod')
      if (not (value in [True, False])):
        raise ApiError("""%s.checkValid: useDbSolvateMethod:
         memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('useDnaRestraints')
      if (not (value in [True, False])):
        raise ApiError("""%s.checkValid: useDnaRestraints:
         memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('useHBondRestraints')
      if (not (value in [True, False])):
        raise ApiError("""%s.checkValid: useHBondRestraints:
         memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('waterInitRestCutoff')
      if (isinstance(value, memops.api.Implementation.Float.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Float.create(value)
      else:
        raise ApiError("""%s.checkValid: waterInitRestCutoff:
         memops.Implementation.NonNegativeFloat input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (0.0 <= value)):
        raise ApiError("""%s.checkValid: waterInitRestCutoff:
         NonNegativeFloat constraint float_value_ge_0 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value - value == 0.0)):
        raise ApiError("""%s.checkValid: waterInitRestCutoff:
         NonNegativeFloat constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('waterRestCutoff')
      if (isinstance(value, memops.api.Implementation.Float.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Float.create(value)
      else:
        raise ApiError("""%s.checkValid: waterRestCutoff:
         memops.Implementation.NonNegativeFloat input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (0.0 <= value)):
        raise ApiError("""%s.checkValid: waterRestCutoff:
         NonNegativeFloat constraint float_value_ge_0 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value - value == 0.0)):
        raise ApiError("""%s.checkValid: waterRestCutoff:
         NonNegativeFloat constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('waterRestScale')
      if (isinstance(value, memops.api.Implementation.Float.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Float.create(value)
      else:
        raise ApiError("""%s.checkValid: waterRestScale:
         memops.Implementation.NonNegativeFloat input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (0.0 <= value)):
        raise ApiError("""%s.checkValid: waterRestScale:
         NonNegativeFloat constraint float_value_ge_0 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value - value == 0.0)):
        raise ApiError("""%s.checkValid: waterRestScale:
         NonNegativeFloat constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('waterSurfaceCutoff')
      if (isinstance(value, memops.api.Implementation.Float.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Float.create(value)
      else:
        raise ApiError("""%s.checkValid: waterSurfaceCutoff:
         memops.Implementation.NonNegativeFloat input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (0.0 <= value)):
        raise ApiError("""%s.checkValid: waterSurfaceCutoff:
         NonNegativeFloat constraint float_value_ge_0 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value - value == 0.0)):
        raise ApiError("""%s.checkValid: waterSurfaceCutoff:
         NonNegativeFloat constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('waterToAddRandom')
      if (isinstance(value, memops.api.Implementation.Float.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Float.create(value)
      else:
        raise ApiError("""%s.checkValid: waterToAddRandom:
         memops.Implementation.FloatRatio input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (0.0 <= value)):
        raise ApiError("""%s.checkValid: waterToAddRandom:
         FloatRatio constraint value_ge_0 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value - value == 0.0)):
        raise ApiError("""%s.checkValid: waterToAddRandom:
         FloatRatio constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value <= 1.0)):
        raise ApiError("""%s.checkValid: waterToAddRandom:
         FloatRatio constraint value_le_1 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('waterToKeep')
      if (isinstance(value, memops.api.Implementation.Float.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Float.create(value)
      else:
        raise ApiError("""%s.checkValid: waterToKeep:
         memops.Implementation.FloatRatio input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (0.0 <= value)):
        raise ApiError("""%s.checkValid: waterToKeep:
         FloatRatio constraint value_ge_0 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value - value == 0.0)):
        raise ApiError("""%s.checkValid: waterToKeep:
         FloatRatio constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value <= 1.0)):
        raise ApiError("""%s.checkValid: waterToKeep:
         FloatRatio constraint value_le_1 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('annealProtocol')
      if (value is not None):
        from molsim.api.AnnealProtocol import AnnealProtocol as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: annealProtocol:
           value is not of class molsim.AnnealProtocol.AnnealProtocol""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('haddockRuns')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: annealProtocol:
           non-reciprocal link annealProtocol from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      values = dataDict.get('haddockEnergyTerms').values()
      for value in values:
        if (not isinstance(value, HaddockEnergyTerm)):
          raise ApiError("""%s.checkValid: haddockEnergyTerms:
           value is not of class utrecht.Haddock.HaddockEnergyTerm""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('run')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: haddockEnergyTerms:
           non-reciprocal link haddockEnergyTerms from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      value = dataDict.get('haddockProject')
      if (not isinstance(value, HaddockProject)):
        raise ApiError("""%s.checkValid: haddockProject:
         value is not of class utrecht.Haddock.HaddockProject""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('nmrConstraintStore')
      if (value is not None):
        from ccp.api.nmr.NmrConstraint import NmrConstraintStore as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: nmrConstraintStore:
           value is not of class ccp.nmr.NmrConstraint.NmrConstraintStore""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: nmrConstraintStore:
           Link nmrConstraintStore between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      values = dataDict.get('scoringWeights').values()
      for value in values:
        if (not isinstance(value, ScoringWeight)):
          raise ApiError("""%s.checkValid: scoringWeights:
           value is not of class utrecht.Haddock.ScoringWeight""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('run')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: scoringWeights:
           non-reciprocal link scoringWeights from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      values = dataDict.get('symmetryRestraints')
      for value in values:
        from molsim.api.Symmetry import Symmetry as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: symmetryRestraints:
           value is not of class molsim.Symmetry.Symmetry""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('haddockRuns')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: symmetryRestraints:
           non-reciprocal link symmetryRestraints from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

    # check explicit class constraints
    # check attributes
    value = dataDict.get('analysisClustRmsd')
    if (value is None):
      raise ApiError("""%s.checkValid: analysisClustRmsd:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('analysisClustSize')
    if (value is None):
      raise ApiError("""%s.checkValid: analysisClustSize:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('analysisDistHBond')
    if (value is None):
      raise ApiError("""%s.checkValid: analysisDistHBond:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('analysisDistNonbond')
    if (value is None):
      raise ApiError("""%s.checkValid: analysisDistNonbond:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    values = dataDict.get('applicationData')
    for value in values:
      value.checkAllValid(complete)

    value = dataDict.get('calcDesolvation')
    if (value is None):
      raise ApiError("""%s.checkValid: calcDesolvation:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('centerOfMassConstant')
    if (value is None):
      raise ApiError("""%s.checkValid: centerOfMassConstant:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('centerOfMassRestraints')
    if (value is None):
      raise ApiError("""%s.checkValid: centerOfMassRestraints:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('cnsExecutable')
    if (value is None):
      raise ApiError("""%s.checkValid: cnsExecutable:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('cpuNumber')
    if (value is None):
      raise ApiError("""%s.checkValid: cpuNumber:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('dielectricType')
    if (value is None):
      raise ApiError("""%s.checkValid: dielectricType:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('doAirScaling')
    if (value is None):
      raise ApiError("""%s.checkValid: doAirScaling:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('doIncludeDihEnergy')
    if (value is None):
      raise ApiError("""%s.checkValid: doIncludeDihEnergy:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('doRigidBodyElectrostatics')
    if (value is None):
      raise ApiError("""%s.checkValid: doRigidBodyElectrostatics:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('doRigidBodyWaterTrans')
    if (value is None):
      raise ApiError("""%s.checkValid: doRigidBodyWaterTrans:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('doRigidTranslations')
    if (value is None):
      raise ApiError("""%s.checkValid: doRigidTranslations:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('doSAElectrostatics')
    if (value is None):
      raise ApiError("""%s.checkValid: doSAElectrostatics:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('doWaterAnalysis')
    if (value is None):
      raise ApiError("""%s.checkValid: doWaterAnalysis:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('doWaterDock')
    if (value is None):
      raise ApiError("""%s.checkValid: doWaterDock:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('epsilon')
    if (value is None):
      raise ApiError("""%s.checkValid: epsilon:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('haddockDir')
    if (value is None):
      raise ApiError("""%s.checkValid: haddockDir:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('initialRigidBodyMinim')
    if (value is None):
      raise ApiError("""%s.checkValid: initialRigidBodyMinim:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('nTrails')
    if (value is None):
      raise ApiError("""%s.checkValid: nTrails:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('ncsRestraintConstant')
    if (value is None):
      raise ApiError("""%s.checkValid: ncsRestraintConstant:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('nonBondedType')
    if (value is None):
      raise ApiError("""%s.checkValid: nonBondedType:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('numAmbRestautoAir')
    if (value is None):
      raise ApiError("""%s.checkValid: numAmbRestautoAir:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('numAnalysisStructures')
    if (value is None):
      raise ApiError("""%s.checkValid: numAnalysisStructures:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('numInitWaterShells')
    if (value is None):
      raise ApiError("""%s.checkValid: numInitWaterShells:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('numIt0Structures')
    if (value is None):
      raise ApiError("""%s.checkValid: numIt0Structures:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('numIt1Structures')
    if (value is None):
      raise ApiError("""%s.checkValid: numIt1Structures:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('numUnambRestautoAir')
    if (value is None):
      raise ApiError("""%s.checkValid: numUnambRestautoAir:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('numWrefStructures')
    if (value is None):
      raise ApiError("""%s.checkValid: numWrefStructures:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('queueCommand')
    if (value is None):
      raise ApiError("""%s.checkValid: queueCommand:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('radomizeStartOriention')
    if (value is None):
      raise ApiError("""%s.checkValid: radomizeStartOriention:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('randomAmbigRestraints')
    if (value is None):
      raise ApiError("""%s.checkValid: randomAmbigRestraints:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('randomExclParts')
    if (value is None):
      raise ApiError("""%s.checkValid: randomExclParts:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('randomExcludeAir')
    if (value is None):
      raise ApiError("""%s.checkValid: randomExcludeAir:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('randomSeed')
    if (value is None):
      raise ApiError("""%s.checkValid: randomSeed:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('removeNonPolarH')
    if (value is None):
      raise ApiError("""%s.checkValid: removeNonPolarH:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('rigidbodyIMinteractScaling')
    if (value is None):
      raise ApiError("""%s.checkValid: rigidbodyIMinteractScaling:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('rotate180It0')
    if (value is None):
      raise ApiError("""%s.checkValid: rotate180It0:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('rotate180It1')
    if (value is None):
      raise ApiError("""%s.checkValid: rotate180It1:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('skipStructures')
    if (value is None):
      raise ApiError("""%s.checkValid: skipStructures:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('solvent')
    if (value is None):
      raise ApiError("""%s.checkValid: solvent:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('surfaceContactConstant')
    if (value is None):
      raise ApiError("""%s.checkValid: surfaceContactConstant:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('surfaceContactRestraints')
    if (value is None):
      raise ApiError("""%s.checkValid: surfaceContactRestraints:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('symmetryRestraintConstant')
    if (value is None):
      raise ApiError("""%s.checkValid: symmetryRestraintConstant:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('useDbSolvateMethod')
    if (value is None):
      raise ApiError("""%s.checkValid: useDbSolvateMethod:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('useDnaRestraints')
    if (value is None):
      raise ApiError("""%s.checkValid: useDnaRestraints:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('useHBondRestraints')
    if (value is None):
      raise ApiError("""%s.checkValid: useHBondRestraints:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('waterInitRestCutoff')
    if (value is None):
      raise ApiError("""%s.checkValid: waterInitRestCutoff:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('waterRestCutoff')
    if (value is None):
      raise ApiError("""%s.checkValid: waterRestCutoff:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('waterRestScale')
    if (value is None):
      raise ApiError("""%s.checkValid: waterRestScale:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('waterSurfaceCutoff')
    if (value is None):
      raise ApiError("""%s.checkValid: waterSurfaceCutoff:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('waterToAddRandom')
    if (value is None):
      raise ApiError("""%s.checkValid: waterToAddRandom:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('waterToKeep')
    if (value is None):
      raise ApiError("""%s.checkValid: waterToKeep:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    # check roles
    value = dataDict.get('access')
    value = dataDict.get('annealProtocol')
    values = dataDict.get('haddockEnergyTerms').values()
    value = dataDict.get('haddockProject')
    if (value is None):
      raise ApiError("""%s.checkValid: haddockProject:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('nmrConstraintStore')
    values = dataDict.get('scoringWeights').values()
    values = dataDict.get('symmetryRestraints')

  delete = memops.api.Implementation.DataObject.delete

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData
  
  def findAllHaddockEnergyTerms(self, **conditions):
    """
    FindAll for utrecht.Haddock.Run.haddockEnergyTerms
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('haddockEnergyTerms').values()
      result = set(currentValues)

    else:
      currentValues = dataDict.get('haddockEnergyTerms').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('code', 'details', 'fileName', 'name', 'termId', 'access', 'constraintList', 'energyTerm', 'run',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllScoringWeights(self, **conditions):
    """
    FindAll for utrecht.Haddock.Run.scoringWeights
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('scoringWeights').values()
      result = set(currentValues)

    else:
      currentValues = dataDict.get('scoringWeights').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('stage', 'term', 'value', 'access', 'run',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllSymmetryRestraints(self, **conditions):
    """
    FindAll for utrecht.Haddock.Run.symmetryRestraints
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('symmetryRestraints')
      result = set(currentValues)

    else:
      currentValues = dataDict.get('symmetryRestraints')
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('segmentLength', 'serial', 'symmetryCode', 'access', 'molSystemSymmetrySet',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData
  
  def findFirstHaddockEnergyTerm(self, **conditions):
    """
    FindFirst for utrecht.Haddock.Run.haddockEnergyTerms
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('haddockEnergyTerms').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      ll = list()
      objKey = conditions.get('code')
      ll.append(objKey)
      if (objKey is not None):
        objKey = conditions.get('termId')
        ll.append(objKey)
        if (objKey is not None):
          objKey = tuple(ll)

      if (objKey is not None):
        result = dataDict.get('haddockEnergyTerms').get(objKey)

        if (nConditions <= 2):
          return result

        elif (result is None):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        currentValues = dataDict.get('haddockEnergyTerms').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('code', 'details', 'fileName', 'name', 'termId', 'access', 'constraintList', 'energyTerm', 'run',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstScoringWeight(self, **conditions):
    """
    FindFirst for utrecht.Haddock.Run.scoringWeights
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('scoringWeights').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      ll = list()
      objKey = conditions.get('term')
      ll.append(objKey)
      if (objKey is not None):
        objKey = conditions.get('stage')
        ll.append(objKey)
        if (objKey is not None):
          objKey = tuple(ll)

      if (objKey is not None):
        result = dataDict.get('scoringWeights').get(objKey)

        if (nConditions <= 2):
          return result

        elif (result is None):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        currentValues = dataDict.get('scoringWeights').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('stage', 'term', 'value', 'access', 'run',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstSymmetryRestraint(self, **conditions):
    """
    FindFirst for utrecht.Haddock.Run.symmetryRestraints
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('symmetryRestraints')
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      currentValues = dataDict.get('symmetryRestraints')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('segmentLength', 'serial', 'symmetryCode', 'access', 'molSystemSymmetrySet',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def get(self, name):
    """
    GetAttr for utrecht.Haddock.Run
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess
  
  def getAnalysisClustRmsd(self):
    """
    Get for utrecht.Haddock.Run.analysisClustRmsd
    """
    dataDict = self.__dict__
    result = dataDict.get('analysisClustRmsd')
    return result
  
  def getAnalysisClustSize(self):
    """
    Get for utrecht.Haddock.Run.analysisClustSize
    """
    dataDict = self.__dict__
    result = dataDict.get('analysisClustSize')
    return result
  
  def getAnalysisDistHBond(self):
    """
    Get for utrecht.Haddock.Run.analysisDistHBond
    """
    dataDict = self.__dict__
    result = dataDict.get('analysisDistHBond')
    return result
  
  def getAnalysisDistNonbond(self):
    """
    Get for utrecht.Haddock.Run.analysisDistNonbond
    """
    dataDict = self.__dict__
    result = dataDict.get('analysisDistNonbond')
    return result
  
  def getAnnealProtocol(self):
    """
    Get for utrecht.Haddock.Run.annealProtocol
    """
    dataDict = self.__dict__
    result = dataDict.get('annealProtocol')
    return result

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for utrecht.Haddock.Run
    """

    result = None
    if (startObj.__class__.__name__ == 'MemopsRoot'):
      if (2 != len(fullKey)):
        raise ApiError("""'utrecht.Haddock.Run'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj0 = startObj
      objKey = fullKey[0]
      obj1 = obj0.__dict__.get('haddockProjects').get(objKey)
      if (obj1 is None):
        obj0.refreshTopObjects('utrecht.Haddock')
        obj1 = obj0.__dict__.get('haddockProjects').get(objKey)

    else:
      if (1 != len(fullKey)):
        raise ApiError("""'utrecht.Haddock.Run'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj1 = startObj

    if (obj1 is not None):
      if (not (obj1.__dict__.get('isLoaded'))):
        obj1.load()

      objKey = fullKey[-1]
      obj2 = obj1.__dict__.get('runs').get(objKey)
      result = obj2

    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation
  
  def getCalcDesolvation(self):
    """
    Get for utrecht.Haddock.Run.calcDesolvation
    """
    dataDict = self.__dict__
    result = dataDict.get('calcDesolvation')
    return result
  
  def getCenterOfMassConstant(self):
    """
    Get for utrecht.Haddock.Run.centerOfMassConstant
    """
    dataDict = self.__dict__
    result = dataDict.get('centerOfMassConstant')
    return result
  
  def getCenterOfMassRestraints(self):
    """
    Get for utrecht.Haddock.Run.centerOfMassRestraints
    """
    dataDict = self.__dict__
    result = dataDict.get('centerOfMassRestraints')
    return result

  getClassName = memops.api.Implementation.ComplexDataType.getClassName
  
  def getCnsExecutable(self):
    """
    Get for utrecht.Haddock.Run.cnsExecutable
    """
    dataDict = self.__dict__
    result = dataDict.get('cnsExecutable')
    return result
  
  def getCpuNumber(self):
    """
    Get for utrecht.Haddock.Run.cpuNumber
    """
    dataDict = self.__dict__
    result = dataDict.get('cpuNumber')
    return result
  
  def getDielectricType(self):
    """
    Get for utrecht.Haddock.Run.dielectricType
    """
    dataDict = self.__dict__
    result = dataDict.get('dielectricType')
    return result
  
  def getDoAirScaling(self):
    """
    Get for utrecht.Haddock.Run.doAirScaling
    """
    dataDict = self.__dict__
    result = dataDict.get('doAirScaling')
    return result
  
  def getDoIncludeDihEnergy(self):
    """
    Get for utrecht.Haddock.Run.doIncludeDihEnergy
    """
    dataDict = self.__dict__
    result = dataDict.get('doIncludeDihEnergy')
    return result
  
  def getDoRigidBodyElectrostatics(self):
    """
    Get for utrecht.Haddock.Run.doRigidBodyElectrostatics
    """
    dataDict = self.__dict__
    result = dataDict.get('doRigidBodyElectrostatics')
    return result
  
  def getDoRigidBodyWaterTrans(self):
    """
    Get for utrecht.Haddock.Run.doRigidBodyWaterTrans
    """
    dataDict = self.__dict__
    result = dataDict.get('doRigidBodyWaterTrans')
    return result
  
  def getDoRigidTranslations(self):
    """
    Get for utrecht.Haddock.Run.doRigidTranslations
    """
    dataDict = self.__dict__
    result = dataDict.get('doRigidTranslations')
    return result
  
  def getDoSAElectrostatics(self):
    """
    Get for utrecht.Haddock.Run.doSAElectrostatics
    """
    dataDict = self.__dict__
    result = dataDict.get('doSAElectrostatics')
    return result
  
  def getDoWaterAnalysis(self):
    """
    Get for utrecht.Haddock.Run.doWaterAnalysis
    """
    dataDict = self.__dict__
    result = dataDict.get('doWaterAnalysis')
    return result
  
  def getDoWaterDock(self):
    """
    Get for utrecht.Haddock.Run.doWaterDock
    """
    dataDict = self.__dict__
    result = dataDict.get('doWaterDock')
    return result
  
  def getEpsilon(self):
    """
    Get for utrecht.Haddock.Run.epsilon
    """
    dataDict = self.__dict__
    result = dataDict.get('epsilon')
    return result

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames
  
  def getFullKey(self, useGuid=False):
    """
    GetFullKey for utrecht.Haddock.Run
    """
    dataDict = self.__dict__
    result = list()

    obj1 = dataDict.get('haddockProject')

    if (useGuid):
      result.append(obj1.__dict__.get('guid'))
    else:
      result.append(obj1.__dict__.get('name'))

    result.append(dataDict.get('serial'))

    return result
  
  def getHaddockDir(self):
    """
    Get for utrecht.Haddock.Run.haddockDir
    """
    dataDict = self.__dict__
    result = dataDict.get('haddockDir')
    return result
  
  def getHaddockEnergyTerms(self):
    """
    Get for utrecht.Haddock.Run.haddockEnergyTerms
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('haddockEnergyTerms').values()
    result = frozenset(tempVar)
    return result
  
  def getHaddockProject(self):
    """
    Get for utrecht.Haddock.Run.haddockProject
    """
    dataDict = self.__dict__
    result = dataDict.get('haddockProject')
    return result

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor
  
  def getInitialRigidBodyMinim(self):
    """
    Get for utrecht.Haddock.Run.initialRigidBodyMinim
    """
    dataDict = self.__dict__
    result = dataDict.get('initialRigidBodyMinim')
    return result

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted
  
  def getLocalKey(self):
    """
    GetLocalKey for utrecht.Haddock.Run
    """
    dataDict = self.__dict__
    result = dataDict.get('serial')
    return result

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass
  
  def getNTrails(self):
    """
    Get for utrecht.Haddock.Run.nTrails
    """
    dataDict = self.__dict__
    result = dataDict.get('nTrails')
    return result
  
  def getNcsRestraintConstant(self):
    """
    Get for utrecht.Haddock.Run.ncsRestraintConstant
    """
    dataDict = self.__dict__
    result = dataDict.get('ncsRestraintConstant')
    return result
  
  def getNmrConstraintStore(self):
    """
    Get for utrecht.Haddock.Run.nmrConstraintStore
    """
    dataDict = self.__dict__
    result = dataDict.get('nmrConstraintStore')
    return result
  
  def getNonBondedType(self):
    """
    Get for utrecht.Haddock.Run.nonBondedType
    """
    dataDict = self.__dict__
    result = dataDict.get('nonBondedType')
    return result
  
  def getNumAmbRestautoAir(self):
    """
    Get for utrecht.Haddock.Run.numAmbRestautoAir
    """
    dataDict = self.__dict__
    result = dataDict.get('numAmbRestautoAir')
    return result
  
  def getNumAnalysisStructures(self):
    """
    Get for utrecht.Haddock.Run.numAnalysisStructures
    """
    dataDict = self.__dict__
    result = dataDict.get('numAnalysisStructures')
    return result
  
  def getNumInitWaterShells(self):
    """
    Get for utrecht.Haddock.Run.numInitWaterShells
    """
    dataDict = self.__dict__
    result = dataDict.get('numInitWaterShells')
    return result
  
  def getNumIt0Structures(self):
    """
    Get for utrecht.Haddock.Run.numIt0Structures
    """
    dataDict = self.__dict__
    result = dataDict.get('numIt0Structures')
    return result
  
  def getNumIt1Structures(self):
    """
    Get for utrecht.Haddock.Run.numIt1Structures
    """
    dataDict = self.__dict__
    result = dataDict.get('numIt1Structures')
    return result
  
  def getNumUnambRestautoAir(self):
    """
    Get for utrecht.Haddock.Run.numUnambRestautoAir
    """
    dataDict = self.__dict__
    result = dataDict.get('numUnambRestautoAir')
    return result
  
  def getNumWrefStructures(self):
    """
    Get for utrecht.Haddock.Run.numWrefStructures
    """
    dataDict = self.__dict__
    result = dataDict.get('numWrefStructures')
    return result

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName
  
  def getParent(self):
    """
    Get for utrecht.Haddock.Run.parent
    """
    dataDict = self.__dict__
    result = dataDict.get('haddockProject')
    return result

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName
  
  def getQueueCommand(self):
    """
    Get for utrecht.Haddock.Run.queueCommand
    """
    dataDict = self.__dict__
    result = dataDict.get('queueCommand')
    return result
  
  def getRadomizeStartOriention(self):
    """
    Get for utrecht.Haddock.Run.radomizeStartOriention
    """
    dataDict = self.__dict__
    result = dataDict.get('radomizeStartOriention')
    return result
  
  def getRandomAmbigRestraints(self):
    """
    Get for utrecht.Haddock.Run.randomAmbigRestraints
    """
    dataDict = self.__dict__
    result = dataDict.get('randomAmbigRestraints')
    return result
  
  def getRandomExclParts(self):
    """
    Get for utrecht.Haddock.Run.randomExclParts
    """
    dataDict = self.__dict__
    result = dataDict.get('randomExclParts')
    return result
  
  def getRandomExcludeAir(self):
    """
    Get for utrecht.Haddock.Run.randomExcludeAir
    """
    dataDict = self.__dict__
    result = dataDict.get('randomExcludeAir')
    return result
  
  def getRandomSeed(self):
    """
    Get for utrecht.Haddock.Run.randomSeed
    """
    dataDict = self.__dict__
    result = dataDict.get('randomSeed')
    return result
  
  def getRemoveNonPolarH(self):
    """
    Get for utrecht.Haddock.Run.removeNonPolarH
    """
    dataDict = self.__dict__
    result = dataDict.get('removeNonPolarH')
    return result
  
  def getRigidbodyIMinteractScaling(self):
    """
    Get for utrecht.Haddock.Run.rigidbodyIMinteractScaling
    """
    dataDict = self.__dict__
    result = dataDict.get('rigidbodyIMinteractScaling')
    return result

  getRoot = memops.api.Implementation.MemopsObject.getRoot
  
  def getRotate180It0(self):
    """
    Get for utrecht.Haddock.Run.rotate180It0
    """
    dataDict = self.__dict__
    result = dataDict.get('rotate180It0')
    return result
  
  def getRotate180It1(self):
    """
    Get for utrecht.Haddock.Run.rotate180It1
    """
    dataDict = self.__dict__
    result = dataDict.get('rotate180It1')
    return result
  
  def getScoringWeights(self):
    """
    Get for utrecht.Haddock.Run.scoringWeights
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('scoringWeights').values()
    result = frozenset(tempVar)
    return result
  
  def getSerial(self):
    """
    Get for utrecht.Haddock.Run.serial
    """
    dataDict = self.__dict__
    result = dataDict.get('serial')
    return result
  
  def getSkipStructures(self):
    """
    Get for utrecht.Haddock.Run.skipStructures
    """
    dataDict = self.__dict__
    result = dataDict.get('skipStructures')
    return result
  
  def getSolvent(self):
    """
    Get for utrecht.Haddock.Run.solvent
    """
    dataDict = self.__dict__
    result = dataDict.get('solvent')
    return result
  
  def getSurfaceContactConstant(self):
    """
    Get for utrecht.Haddock.Run.surfaceContactConstant
    """
    dataDict = self.__dict__
    result = dataDict.get('surfaceContactConstant')
    return result
  
  def getSurfaceContactRestraints(self):
    """
    Get for utrecht.Haddock.Run.surfaceContactRestraints
    """
    dataDict = self.__dict__
    result = dataDict.get('surfaceContactRestraints')
    return result
  
  def getSymmetryRestraintConstant(self):
    """
    Get for utrecht.Haddock.Run.symmetryRestraintConstant
    """
    dataDict = self.__dict__
    result = dataDict.get('symmetryRestraintConstant')
    return result
  
  def getSymmetryRestraints(self):
    """
    Get for utrecht.Haddock.Run.symmetryRestraints
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('symmetryRestraints')
    result = frozenset(tempVar)
    return result

  getTopObject = memops.api.Implementation.DataObject.getTopObject
  
  def getUseDbSolvateMethod(self):
    """
    Get for utrecht.Haddock.Run.useDbSolvateMethod
    """
    dataDict = self.__dict__
    result = dataDict.get('useDbSolvateMethod')
    return result
  
  def getUseDnaRestraints(self):
    """
    Get for utrecht.Haddock.Run.useDnaRestraints
    """
    dataDict = self.__dict__
    result = dataDict.get('useDnaRestraints')
    return result
  
  def getUseHBondRestraints(self):
    """
    Get for utrecht.Haddock.Run.useHBondRestraints
    """
    dataDict = self.__dict__
    result = dataDict.get('useHBondRestraints')
    return result
  
  def getWaterInitRestCutoff(self):
    """
    Get for utrecht.Haddock.Run.waterInitRestCutoff
    """
    dataDict = self.__dict__
    result = dataDict.get('waterInitRestCutoff')
    return result
  
  def getWaterRestCutoff(self):
    """
    Get for utrecht.Haddock.Run.waterRestCutoff
    """
    dataDict = self.__dict__
    result = dataDict.get('waterRestCutoff')
    return result
  
  def getWaterRestScale(self):
    """
    Get for utrecht.Haddock.Run.waterRestScale
    """
    dataDict = self.__dict__
    result = dataDict.get('waterRestScale')
    return result
  
  def getWaterSurfaceCutoff(self):
    """
    Get for utrecht.Haddock.Run.waterSurfaceCutoff
    """
    dataDict = self.__dict__
    result = dataDict.get('waterSurfaceCutoff')
    return result
  
  def getWaterToAddRandom(self):
    """
    Get for utrecht.Haddock.Run.waterToAddRandom
    """
    dataDict = self.__dict__
    result = dataDict.get('waterToAddRandom')
    return result
  
  def getWaterToKeep(self):
    """
    Get for utrecht.Haddock.Run.waterToKeep
    """
    dataDict = self.__dict__
    result = dataDict.get('waterToKeep')
    return result
  
  def newHaddockEnergyTerm(self, **attrlinks):
    """
    Factory function to create utrecht.Haddock.HaddockEnergyTerm
    """
    return HaddockEnergyTerm(self, **attrlinks)
  
  def newScoringWeight(self, **attrlinks):
    """
    Factory function to create utrecht.Haddock.ScoringWeight
    """
    return ScoringWeight(self, **attrlinks)

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData
  
  def removeSymmetryRestraint(self, value):
    """
    Remove for utrecht.Haddock.Run.symmetryRestraints
    """
    dataDict = self.__dict__
    from molsim.api.Symmetry import Symmetry as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.removeSymmetryRestraint:
       value is not of class molsim.Symmetry.Symmetry""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('symmetryRestraints')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      topObject = value.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)
      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.removeSymmetryRestraint:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.removeSymmetryRestraint:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.removeSymmetryRestraint:
       called with deleted value""" % self.qualifiedName
      )

    if (not (value in currentValues)):
      raise ApiError("""%s.removeSymmetryRestraint:
       value not in list""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      pass

    oldSelves = value.__dict__.get('haddockRuns')
    oldSelves.remove(self)
    currentValues.remove(value)
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('removeSymmetryRestraint')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def resetNmrConstraintStore(self, value):
    """
    reset nmrConstraintStore. Note this link is frozen and cannot be
    modified normally. NB Will delete the link from any HaddockEnergyTerm to 
    its constraintList.
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.resetNmrConstraintStore:
       called on deleted object""" % self.qualifiedName
      )

    if self.nmrConstraintStore is value:
      return
    
    for x in self.haddockEnergyTerms:
      x.constraintList = None
    
    root = self.root
    wasOverride = root.override
    try:
      root.override = True
      self.nmrConstraintStore = value
    finally:
      root.override = wasOverride
  
  def set(self, name, value):
    """
    SetAttr for utrecht.Haddock.Run
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess
  
  def setAnalysisClustRmsd(self, value):
    """
    Set for utrecht.Haddock.Run.analysisClustRmsd
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Float.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Float.create(value)
    else:
      raise ApiError("""%s.setAnalysisClustRmsd:
       memops.Implementation.PositiveFloat input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value > 0)):
      raise ApiError("""%s.setAnalysisClustRmsd:
       PositiveFloat constraint float_value_gt_0 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value - value == 0.0)):
      raise ApiError("""%s.setAnalysisClustRmsd:
       PositiveFloat constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('analysisClustRmsd')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setAnalysisClustRmsd:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setAnalysisClustRmsd:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setAnalysisClustRmsd:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['analysisClustRmsd'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setAnalysisClustRmsd')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setAnalysisClustSize(self, value):
    """
    Set for utrecht.Haddock.Run.analysisClustSize
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Int.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Int.create(value)
    else:
      raise ApiError("""%s.setAnalysisClustSize:
       memops.Implementation.NonNegativeInt input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value >= 0)):
      raise ApiError("""%s.setAnalysisClustSize:
       NonNegativeInt constraint int_value_ge_0 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('analysisClustSize')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setAnalysisClustSize:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setAnalysisClustSize:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setAnalysisClustSize:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['analysisClustSize'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setAnalysisClustSize')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setAnalysisDistHBond(self, value):
    """
    Set for utrecht.Haddock.Run.analysisDistHBond
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Float.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Float.create(value)
    else:
      raise ApiError("""%s.setAnalysisDistHBond:
       memops.Implementation.PositiveFloat input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value > 0)):
      raise ApiError("""%s.setAnalysisDistHBond:
       PositiveFloat constraint float_value_gt_0 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value - value == 0.0)):
      raise ApiError("""%s.setAnalysisDistHBond:
       PositiveFloat constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('analysisDistHBond')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setAnalysisDistHBond:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setAnalysisDistHBond:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setAnalysisDistHBond:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['analysisDistHBond'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setAnalysisDistHBond')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setAnalysisDistNonbond(self, value):
    """
    Set for utrecht.Haddock.Run.analysisDistNonbond
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Float.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Float.create(value)
    else:
      raise ApiError("""%s.setAnalysisDistNonbond:
       memops.Implementation.PositiveFloat input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value > 0)):
      raise ApiError("""%s.setAnalysisDistNonbond:
       PositiveFloat constraint float_value_gt_0 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value - value == 0.0)):
      raise ApiError("""%s.setAnalysisDistNonbond:
       PositiveFloat constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('analysisDistNonbond')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setAnalysisDistNonbond:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setAnalysisDistNonbond:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setAnalysisDistNonbond:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['analysisDistNonbond'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setAnalysisDistNonbond')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setAnnealProtocol(self, value):
    """
    Set for utrecht.Haddock.Run.annealProtocol
    """
    dataDict = self.__dict__
    if (value is not None):
      from molsim.api.AnnealProtocol import AnnealProtocol as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setAnnealProtocol:
         value is not of class molsim.AnnealProtocol.AnnealProtocol""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('annealProtocol')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      if (value is not None):
        topObject = value.__dict__.get('topObject')
        topObjectsToCheck.add(topObject)

      if (currentValue is not None):
        topObject = currentValue.__dict__.get('topObject')
        topObjectsToCheck.add(topObject)

      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setAnnealProtocol:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setAnnealProtocol:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setAnnealProtocol:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setAnnealProtocol:
           Link annealProtocol between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    if (currentValue is not None):
      if (notIsReading):
        oldSelves = currentValue.__dict__.get('haddockRuns')
        oldSelves.remove(self)
      else:
        raise ApiError("""%s.setAnnealProtocol:
         Read link 'annealProtocol' incompatible with pre-existing link""" % self.qualifiedName
         + ": %s" % (self,)
        )

    if (value is not None):
      newSelves = value.__dict__.get('haddockRuns')
      newSelves.add(self)

    dataDict['annealProtocol'] = value
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setAnnealProtocol')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData
  
  def setCalcDesolvation(self, value):
    """
    Set for utrecht.Haddock.Run.calcDesolvation
    """
    dataDict = self.__dict__
    if (not (value in [True, False])):
      raise ApiError("""%s.setCalcDesolvation:
       memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('calcDesolvation')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setCalcDesolvation:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setCalcDesolvation:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setCalcDesolvation:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['calcDesolvation'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setCalcDesolvation')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setCenterOfMassConstant(self, value):
    """
    Set for utrecht.Haddock.Run.centerOfMassConstant
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Float.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Float.create(value)
    else:
      raise ApiError("""%s.setCenterOfMassConstant:
       memops.Implementation.NonNegativeFloat input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (0.0 <= value)):
      raise ApiError("""%s.setCenterOfMassConstant:
       NonNegativeFloat constraint float_value_ge_0 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value - value == 0.0)):
      raise ApiError("""%s.setCenterOfMassConstant:
       NonNegativeFloat constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('centerOfMassConstant')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setCenterOfMassConstant:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setCenterOfMassConstant:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setCenterOfMassConstant:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['centerOfMassConstant'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setCenterOfMassConstant')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setCenterOfMassRestraints(self, value):
    """
    Set for utrecht.Haddock.Run.centerOfMassRestraints
    """
    dataDict = self.__dict__
    if (not (value in [True, False])):
      raise ApiError("""%s.setCenterOfMassRestraints:
       memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('centerOfMassRestraints')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setCenterOfMassRestraints:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setCenterOfMassRestraints:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setCenterOfMassRestraints:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['centerOfMassRestraints'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setCenterOfMassRestraints')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setCnsExecutable(self, value):
    """
    Set for utrecht.Haddock.Run.cnsExecutable
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.setCnsExecutable:
       memops.Implementation.PathString input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value.find(chr(92)) == -1)):
      raise ApiError("""%s.setCnsExecutable:
       PathString constraint contains_no_backslash violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.splitlines()) <= 1)):
      raise ApiError("""%s.setCnsExecutable:
       PathString constraint contains_no_linebreak violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('cnsExecutable')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setCnsExecutable:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setCnsExecutable:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setCnsExecutable:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['cnsExecutable'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setCnsExecutable')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setCpuNumber(self, value):
    """
    Set for utrecht.Haddock.Run.cpuNumber
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Int.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Int.create(value)
    else:
      raise ApiError("""%s.setCpuNumber:
       memops.Implementation.NonNegativeInt input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value >= 0)):
      raise ApiError("""%s.setCpuNumber:
       NonNegativeInt constraint int_value_ge_0 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('cpuNumber')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setCpuNumber:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setCpuNumber:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setCpuNumber:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['cpuNumber'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setCpuNumber')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setDielectricType(self, value):
    """
    Set for utrecht.Haddock.Run.dielectricType
    """
    dataDict = self.__dict__
    if (not (value in ['cdie', 'rdie'])):
      raise ApiError("""%s.setDielectricType:
       utrecht.Haddock.DielectricType input is not in enumeration ['cdie', 'rdie']""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.split()) == 1)):
      raise ApiError("""%s.setDielectricType:
       DielectricType constraint contains_no_white_space violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('dielectricType')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setDielectricType:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setDielectricType:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setDielectricType:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['dielectricType'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setDielectricType')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setDoAirScaling(self, value):
    """
    Set for utrecht.Haddock.Run.doAirScaling
    """
    dataDict = self.__dict__
    if (not (value in [True, False])):
      raise ApiError("""%s.setDoAirScaling:
       memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('doAirScaling')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setDoAirScaling:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setDoAirScaling:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setDoAirScaling:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['doAirScaling'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setDoAirScaling')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setDoIncludeDihEnergy(self, value):
    """
    Set for utrecht.Haddock.Run.doIncludeDihEnergy
    """
    dataDict = self.__dict__
    if (not (value in [True, False])):
      raise ApiError("""%s.setDoIncludeDihEnergy:
       memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('doIncludeDihEnergy')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setDoIncludeDihEnergy:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setDoIncludeDihEnergy:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setDoIncludeDihEnergy:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['doIncludeDihEnergy'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setDoIncludeDihEnergy')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setDoRigidBodyElectrostatics(self, value):
    """
    Set for utrecht.Haddock.Run.doRigidBodyElectrostatics
    """
    dataDict = self.__dict__
    if (not (value in [True, False])):
      raise ApiError("""%s.setDoRigidBodyElectrostatics:
       memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('doRigidBodyElectrostatics')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setDoRigidBodyElectrostatics:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setDoRigidBodyElectrostatics:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setDoRigidBodyElectrostatics:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['doRigidBodyElectrostatics'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setDoRigidBodyElectrostatics')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setDoRigidBodyWaterTrans(self, value):
    """
    Set for utrecht.Haddock.Run.doRigidBodyWaterTrans
    """
    dataDict = self.__dict__
    if (not (value in [True, False])):
      raise ApiError("""%s.setDoRigidBodyWaterTrans:
       memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('doRigidBodyWaterTrans')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setDoRigidBodyWaterTrans:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setDoRigidBodyWaterTrans:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setDoRigidBodyWaterTrans:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['doRigidBodyWaterTrans'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setDoRigidBodyWaterTrans')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setDoRigidTranslations(self, value):
    """
    Set for utrecht.Haddock.Run.doRigidTranslations
    """
    dataDict = self.__dict__
    if (not (value in [True, False])):
      raise ApiError("""%s.setDoRigidTranslations:
       memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('doRigidTranslations')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setDoRigidTranslations:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setDoRigidTranslations:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setDoRigidTranslations:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['doRigidTranslations'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setDoRigidTranslations')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setDoSAElectrostatics(self, value):
    """
    Set for utrecht.Haddock.Run.doSAElectrostatics
    """
    dataDict = self.__dict__
    if (not (value in [True, False])):
      raise ApiError("""%s.setDoSAElectrostatics:
       memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('doSAElectrostatics')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setDoSAElectrostatics:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setDoSAElectrostatics:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setDoSAElectrostatics:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['doSAElectrostatics'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setDoSAElectrostatics')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setDoWaterAnalysis(self, value):
    """
    Set for utrecht.Haddock.Run.doWaterAnalysis
    """
    dataDict = self.__dict__
    if (not (value in [True, False])):
      raise ApiError("""%s.setDoWaterAnalysis:
       memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('doWaterAnalysis')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setDoWaterAnalysis:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setDoWaterAnalysis:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setDoWaterAnalysis:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['doWaterAnalysis'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setDoWaterAnalysis')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setDoWaterDock(self, value):
    """
    Set for utrecht.Haddock.Run.doWaterDock
    """
    dataDict = self.__dict__
    if (not (value in [True, False])):
      raise ApiError("""%s.setDoWaterDock:
       memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('doWaterDock')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setDoWaterDock:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setDoWaterDock:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setDoWaterDock:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['doWaterDock'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setDoWaterDock')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setEpsilon(self, value):
    """
    Set for utrecht.Haddock.Run.epsilon
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Float.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Float.create(value)
    else:
      raise ApiError("""%s.setEpsilon:
       memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value - value == 0.0)):
      raise ApiError("""%s.setEpsilon:
       Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('epsilon')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setEpsilon:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setEpsilon:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setEpsilon:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['epsilon'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setEpsilon')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setHaddockDir(self, value):
    """
    Set for utrecht.Haddock.Run.haddockDir
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.setHaddockDir:
       memops.Implementation.PathString input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value.find(chr(92)) == -1)):
      raise ApiError("""%s.setHaddockDir:
       PathString constraint contains_no_backslash violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.splitlines()) <= 1)):
      raise ApiError("""%s.setHaddockDir:
       PathString constraint contains_no_linebreak violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('haddockDir')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setHaddockDir:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setHaddockDir:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setHaddockDir:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['haddockDir'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setHaddockDir')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setInitialRigidBodyMinim(self, value):
    """
    Set for utrecht.Haddock.Run.initialRigidBodyMinim
    """
    dataDict = self.__dict__
    if (not (value in [True, False])):
      raise ApiError("""%s.setInitialRigidBodyMinim:
       memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('initialRigidBodyMinim')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setInitialRigidBodyMinim:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setInitialRigidBodyMinim:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setInitialRigidBodyMinim:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['initialRigidBodyMinim'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setInitialRigidBodyMinim')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setNTrails(self, value):
    """
    Set for utrecht.Haddock.Run.nTrails
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Int.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Int.create(value)
    else:
      raise ApiError("""%s.setNTrails:
       memops.Implementation.NonNegativeInt input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value >= 0)):
      raise ApiError("""%s.setNTrails:
       NonNegativeInt constraint int_value_ge_0 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('nTrails')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setNTrails:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setNTrails:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setNTrails:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['nTrails'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setNTrails')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setNcsRestraintConstant(self, value):
    """
    Set for utrecht.Haddock.Run.ncsRestraintConstant
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Float.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Float.create(value)
    else:
      raise ApiError("""%s.setNcsRestraintConstant:
       memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value - value == 0.0)):
      raise ApiError("""%s.setNcsRestraintConstant:
       Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('ncsRestraintConstant')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setNcsRestraintConstant:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setNcsRestraintConstant:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setNcsRestraintConstant:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['ncsRestraintConstant'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setNcsRestraintConstant')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setNmrConstraintStore(self, value):
    """
    Set for utrecht.Haddock.Run.nmrConstraintStore
    """
    dataDict = self.__dict__
    if (value is not None):
      from ccp.api.nmr.NmrConstraint import NmrConstraintStore as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setNmrConstraintStore:
         value is not of class ccp.nmr.NmrConstraint.NmrConstraintStore""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('nmrConstraintStore')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setNmrConstraintStore:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setNmrConstraintStore:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setNmrConstraintStore:
         cannot set nmrConstraintStore, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is not None):
        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setNmrConstraintStore:
           Link nmrConstraintStore between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    dataDict['nmrConstraintStore'] = value

    # doNotifies
  
  def setNonBondedType(self, value):
    """
    Set for utrecht.Haddock.Run.nonBondedType
    """
    dataDict = self.__dict__
    if (not (value in ['OPLSX', 'PROLSQ', 'PARMALLH6', 'PARALLHDG'])):
      raise ApiError("""%s.setNonBondedType:
       utrecht.Haddock.NonBondedType input is not in enumeration ['OPLSX', 'PROLSQ', 'PARMALLH6', 'PARALLHDG']""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.split()) == 1)):
      raise ApiError("""%s.setNonBondedType:
       NonBondedType constraint contains_no_white_space violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('nonBondedType')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setNonBondedType:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setNonBondedType:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setNonBondedType:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['nonBondedType'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setNonBondedType')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setNumAmbRestautoAir(self, value):
    """
    Set for utrecht.Haddock.Run.numAmbRestautoAir
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Int.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Int.create(value)
    else:
      raise ApiError("""%s.setNumAmbRestautoAir:
       memops.Implementation.NonNegativeInt input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value >= 0)):
      raise ApiError("""%s.setNumAmbRestautoAir:
       NonNegativeInt constraint int_value_ge_0 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('numAmbRestautoAir')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setNumAmbRestautoAir:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setNumAmbRestautoAir:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setNumAmbRestautoAir:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['numAmbRestautoAir'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setNumAmbRestautoAir')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setNumAnalysisStructures(self, value):
    """
    Set for utrecht.Haddock.Run.numAnalysisStructures
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Int.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Int.create(value)
    else:
      raise ApiError("""%s.setNumAnalysisStructures:
       memops.Implementation.NonNegativeInt input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value >= 0)):
      raise ApiError("""%s.setNumAnalysisStructures:
       NonNegativeInt constraint int_value_ge_0 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('numAnalysisStructures')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setNumAnalysisStructures:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setNumAnalysisStructures:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setNumAnalysisStructures:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['numAnalysisStructures'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setNumAnalysisStructures')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setNumInitWaterShells(self, value):
    """
    Set for utrecht.Haddock.Run.numInitWaterShells
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Int.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Int.create(value)
    else:
      raise ApiError("""%s.setNumInitWaterShells:
       memops.Implementation.NonNegativeInt input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value >= 0)):
      raise ApiError("""%s.setNumInitWaterShells:
       NonNegativeInt constraint int_value_ge_0 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('numInitWaterShells')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setNumInitWaterShells:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setNumInitWaterShells:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setNumInitWaterShells:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['numInitWaterShells'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setNumInitWaterShells')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setNumIt0Structures(self, value):
    """
    Set for utrecht.Haddock.Run.numIt0Structures
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Int.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Int.create(value)
    else:
      raise ApiError("""%s.setNumIt0Structures:
       memops.Implementation.NonNegativeInt input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value >= 0)):
      raise ApiError("""%s.setNumIt0Structures:
       NonNegativeInt constraint int_value_ge_0 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('numIt0Structures')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setNumIt0Structures:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setNumIt0Structures:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setNumIt0Structures:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['numIt0Structures'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setNumIt0Structures')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setNumIt1Structures(self, value):
    """
    Set for utrecht.Haddock.Run.numIt1Structures
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Int.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Int.create(value)
    else:
      raise ApiError("""%s.setNumIt1Structures:
       memops.Implementation.NonNegativeInt input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value >= 0)):
      raise ApiError("""%s.setNumIt1Structures:
       NonNegativeInt constraint int_value_ge_0 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('numIt1Structures')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setNumIt1Structures:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setNumIt1Structures:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setNumIt1Structures:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['numIt1Structures'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setNumIt1Structures')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setNumUnambRestautoAir(self, value):
    """
    Set for utrecht.Haddock.Run.numUnambRestautoAir
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Int.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Int.create(value)
    else:
      raise ApiError("""%s.setNumUnambRestautoAir:
       memops.Implementation.NonNegativeInt input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value >= 0)):
      raise ApiError("""%s.setNumUnambRestautoAir:
       NonNegativeInt constraint int_value_ge_0 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('numUnambRestautoAir')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setNumUnambRestautoAir:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setNumUnambRestautoAir:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setNumUnambRestautoAir:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['numUnambRestautoAir'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setNumUnambRestautoAir')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setNumWrefStructures(self, value):
    """
    Set for utrecht.Haddock.Run.numWrefStructures
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Int.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Int.create(value)
    else:
      raise ApiError("""%s.setNumWrefStructures:
       memops.Implementation.NonNegativeInt input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value >= 0)):
      raise ApiError("""%s.setNumWrefStructures:
       NonNegativeInt constraint int_value_ge_0 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('numWrefStructures')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setNumWrefStructures:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setNumWrefStructures:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setNumWrefStructures:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['numWrefStructures'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setNumWrefStructures')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setQueueCommand(self, value):
    """
    Set for utrecht.Haddock.Run.queueCommand
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.setQueueCommand:
       memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 80):
      raise ApiError("""%s.setQueueCommand:
       memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.setQueueCommand:
       memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.splitlines()) <= 1)):
      raise ApiError("""%s.setQueueCommand:
       Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('queueCommand')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setQueueCommand:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setQueueCommand:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setQueueCommand:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['queueCommand'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setQueueCommand')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setRadomizeStartOriention(self, value):
    """
    Set for utrecht.Haddock.Run.radomizeStartOriention
    """
    dataDict = self.__dict__
    if (not (value in [True, False])):
      raise ApiError("""%s.setRadomizeStartOriention:
       memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('radomizeStartOriention')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setRadomizeStartOriention:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setRadomizeStartOriention:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setRadomizeStartOriention:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['radomizeStartOriention'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setRadomizeStartOriention')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setRandomAmbigRestraints(self, value):
    """
    Set for utrecht.Haddock.Run.randomAmbigRestraints
    """
    dataDict = self.__dict__
    if (not (value in [True, False])):
      raise ApiError("""%s.setRandomAmbigRestraints:
       memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('randomAmbigRestraints')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setRandomAmbigRestraints:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setRandomAmbigRestraints:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setRandomAmbigRestraints:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['randomAmbigRestraints'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setRandomAmbigRestraints')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setRandomExclParts(self, value):
    """
    Set for utrecht.Haddock.Run.randomExclParts
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Int.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Int.create(value)
    else:
      raise ApiError("""%s.setRandomExclParts:
       memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('randomExclParts')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setRandomExclParts:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setRandomExclParts:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setRandomExclParts:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['randomExclParts'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setRandomExclParts')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setRandomExcludeAir(self, value):
    """
    Set for utrecht.Haddock.Run.randomExcludeAir
    """
    dataDict = self.__dict__
    if (not (value in [True, False])):
      raise ApiError("""%s.setRandomExcludeAir:
       memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('randomExcludeAir')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setRandomExcludeAir:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setRandomExcludeAir:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setRandomExcludeAir:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['randomExcludeAir'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setRandomExcludeAir')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setRandomSeed(self, value):
    """
    Set for utrecht.Haddock.Run.randomSeed
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Int.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Int.create(value)
    else:
      raise ApiError("""%s.setRandomSeed:
       memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('randomSeed')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setRandomSeed:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setRandomSeed:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setRandomSeed:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['randomSeed'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setRandomSeed')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setRemoveNonPolarH(self, value):
    """
    Set for utrecht.Haddock.Run.removeNonPolarH
    """
    dataDict = self.__dict__
    if (not (value in [True, False])):
      raise ApiError("""%s.setRemoveNonPolarH:
       memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('removeNonPolarH')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setRemoveNonPolarH:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setRemoveNonPolarH:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setRemoveNonPolarH:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['removeNonPolarH'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setRemoveNonPolarH')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setRigidbodyIMinteractScaling(self, value):
    """
    Set for utrecht.Haddock.Run.rigidbodyIMinteractScaling
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Float.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Float.create(value)
    else:
      raise ApiError("""%s.setRigidbodyIMinteractScaling:
       memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value - value == 0.0)):
      raise ApiError("""%s.setRigidbodyIMinteractScaling:
       Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('rigidbodyIMinteractScaling')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setRigidbodyIMinteractScaling:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setRigidbodyIMinteractScaling:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setRigidbodyIMinteractScaling:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['rigidbodyIMinteractScaling'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setRigidbodyIMinteractScaling')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setRotate180It0(self, value):
    """
    Set for utrecht.Haddock.Run.rotate180It0
    """
    dataDict = self.__dict__
    if (not (value in [True, False])):
      raise ApiError("""%s.setRotate180It0:
       memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('rotate180It0')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setRotate180It0:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setRotate180It0:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setRotate180It0:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['rotate180It0'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setRotate180It0')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setRotate180It1(self, value):
    """
    Set for utrecht.Haddock.Run.rotate180It1
    """
    dataDict = self.__dict__
    if (not (value in [True, False])):
      raise ApiError("""%s.setRotate180It1:
       memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('rotate180It1')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setRotate180It1:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setRotate180It1:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setRotate180It1:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['rotate180It1'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setRotate180It1')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setSerial(self, value):
    """
    Set for utrecht.Haddock.Run.serial
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Int.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Int.create(value)
    else:
      raise ApiError("""%s.setSerial:
       memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('serial')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setSerial:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setSerial:
         cannot set serial, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setSerial:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    parent = dataDict.get('haddockProject')
    oldSerial = parent.__dict__.get('_serialDict').get('runs')
    if (value < 0):
      value = (oldSerial + 1)
      parent.__dict__.get('_serialDict')['runs'] = value
    elif (value > oldSerial):
      parent.__dict__.get('_serialDict')['runs'] = value

    dataDict['serial'] = value

    # doNotifies
  
  def setSkipStructures(self, value):
    """
    Set for utrecht.Haddock.Run.skipStructures
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Int.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Int.create(value)
    else:
      raise ApiError("""%s.setSkipStructures:
       memops.Implementation.NonNegativeInt input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value >= 0)):
      raise ApiError("""%s.setSkipStructures:
       NonNegativeInt constraint int_value_ge_0 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('skipStructures')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setSkipStructures:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setSkipStructures:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setSkipStructures:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['skipStructures'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setSkipStructures')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setSolvent(self, value):
    """
    Set for utrecht.Haddock.Run.solvent
    """
    dataDict = self.__dict__
    if (not (value in ['water', 'dmso'])):
      raise ApiError("""%s.setSolvent:
       utrecht.Haddock.Solvent input is not in enumeration ['water', 'dmso']""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.split()) == 1)):
      raise ApiError("""%s.setSolvent:
       Solvent constraint contains_no_white_space violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('solvent')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setSolvent:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setSolvent:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setSolvent:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['solvent'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setSolvent')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setSurfaceContactConstant(self, value):
    """
    Set for utrecht.Haddock.Run.surfaceContactConstant
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Float.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Float.create(value)
    else:
      raise ApiError("""%s.setSurfaceContactConstant:
       memops.Implementation.NonNegativeFloat input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (0.0 <= value)):
      raise ApiError("""%s.setSurfaceContactConstant:
       NonNegativeFloat constraint float_value_ge_0 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value - value == 0.0)):
      raise ApiError("""%s.setSurfaceContactConstant:
       NonNegativeFloat constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('surfaceContactConstant')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setSurfaceContactConstant:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setSurfaceContactConstant:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setSurfaceContactConstant:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['surfaceContactConstant'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setSurfaceContactConstant')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setSurfaceContactRestraints(self, value):
    """
    Set for utrecht.Haddock.Run.surfaceContactRestraints
    """
    dataDict = self.__dict__
    if (not (value in [True, False])):
      raise ApiError("""%s.setSurfaceContactRestraints:
       memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('surfaceContactRestraints')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setSurfaceContactRestraints:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setSurfaceContactRestraints:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setSurfaceContactRestraints:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['surfaceContactRestraints'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setSurfaceContactRestraints')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setSymmetryRestraintConstant(self, value):
    """
    Set for utrecht.Haddock.Run.symmetryRestraintConstant
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Float.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Float.create(value)
    else:
      raise ApiError("""%s.setSymmetryRestraintConstant:
       memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value - value == 0.0)):
      raise ApiError("""%s.setSymmetryRestraintConstant:
       Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('symmetryRestraintConstant')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setSymmetryRestraintConstant:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setSymmetryRestraintConstant:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setSymmetryRestraintConstant:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['symmetryRestraintConstant'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setSymmetryRestraintConstant')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setSymmetryRestraints(self, values):
    """
    Set for utrecht.Haddock.Run.symmetryRestraints
    """
    dataDict = self.__dict__
    xx = values
    values = set(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setSymmetryRestraints:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      from molsim.api.Symmetry import Symmetry as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setSymmetryRestraints:
         value is not of class molsim.Symmetry.Symmetry""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('symmetryRestraints')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      for pv in currentValues:
        if (not (pv in values)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)

      for pv in values:
        if (not (pv in currentValues)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)

      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setSymmetryRestraints:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setSymmetryRestraints:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setSymmetryRestraints:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
      for value in values:
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setSymmetryRestraints:
           Link symmetryRestraints between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    for cv in currentValues:
      if (not (cv in values)):
        oldSelves = cv.__dict__.get('haddockRuns')
        oldSelves.remove(self)

    for cv in values:
      if (not (cv in currentValues)):
        oldSelves = cv.__dict__.get('haddockRuns')
        oldSelves.add(self)

    dataDict['symmetryRestraints'] = values
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setSymmetryRestraints')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setUseDbSolvateMethod(self, value):
    """
    Set for utrecht.Haddock.Run.useDbSolvateMethod
    """
    dataDict = self.__dict__
    if (not (value in [True, False])):
      raise ApiError("""%s.setUseDbSolvateMethod:
       memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('useDbSolvateMethod')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setUseDbSolvateMethod:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setUseDbSolvateMethod:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setUseDbSolvateMethod:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['useDbSolvateMethod'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setUseDbSolvateMethod')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setUseDnaRestraints(self, value):
    """
    Set for utrecht.Haddock.Run.useDnaRestraints
    """
    dataDict = self.__dict__
    if (not (value in [True, False])):
      raise ApiError("""%s.setUseDnaRestraints:
       memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('useDnaRestraints')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setUseDnaRestraints:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setUseDnaRestraints:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setUseDnaRestraints:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['useDnaRestraints'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setUseDnaRestraints')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setUseHBondRestraints(self, value):
    """
    Set for utrecht.Haddock.Run.useHBondRestraints
    """
    dataDict = self.__dict__
    if (not (value in [True, False])):
      raise ApiError("""%s.setUseHBondRestraints:
       memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('useHBondRestraints')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setUseHBondRestraints:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setUseHBondRestraints:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setUseHBondRestraints:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['useHBondRestraints'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setUseHBondRestraints')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setWaterInitRestCutoff(self, value):
    """
    Set for utrecht.Haddock.Run.waterInitRestCutoff
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Float.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Float.create(value)
    else:
      raise ApiError("""%s.setWaterInitRestCutoff:
       memops.Implementation.NonNegativeFloat input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (0.0 <= value)):
      raise ApiError("""%s.setWaterInitRestCutoff:
       NonNegativeFloat constraint float_value_ge_0 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value - value == 0.0)):
      raise ApiError("""%s.setWaterInitRestCutoff:
       NonNegativeFloat constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('waterInitRestCutoff')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setWaterInitRestCutoff:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setWaterInitRestCutoff:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setWaterInitRestCutoff:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['waterInitRestCutoff'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setWaterInitRestCutoff')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setWaterRestCutoff(self, value):
    """
    Set for utrecht.Haddock.Run.waterRestCutoff
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Float.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Float.create(value)
    else:
      raise ApiError("""%s.setWaterRestCutoff:
       memops.Implementation.NonNegativeFloat input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (0.0 <= value)):
      raise ApiError("""%s.setWaterRestCutoff:
       NonNegativeFloat constraint float_value_ge_0 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value - value == 0.0)):
      raise ApiError("""%s.setWaterRestCutoff:
       NonNegativeFloat constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('waterRestCutoff')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setWaterRestCutoff:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setWaterRestCutoff:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setWaterRestCutoff:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['waterRestCutoff'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setWaterRestCutoff')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setWaterRestScale(self, value):
    """
    Set for utrecht.Haddock.Run.waterRestScale
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Float.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Float.create(value)
    else:
      raise ApiError("""%s.setWaterRestScale:
       memops.Implementation.NonNegativeFloat input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (0.0 <= value)):
      raise ApiError("""%s.setWaterRestScale:
       NonNegativeFloat constraint float_value_ge_0 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value - value == 0.0)):
      raise ApiError("""%s.setWaterRestScale:
       NonNegativeFloat constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('waterRestScale')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setWaterRestScale:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setWaterRestScale:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setWaterRestScale:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['waterRestScale'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setWaterRestScale')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setWaterSurfaceCutoff(self, value):
    """
    Set for utrecht.Haddock.Run.waterSurfaceCutoff
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Float.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Float.create(value)
    else:
      raise ApiError("""%s.setWaterSurfaceCutoff:
       memops.Implementation.NonNegativeFloat input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (0.0 <= value)):
      raise ApiError("""%s.setWaterSurfaceCutoff:
       NonNegativeFloat constraint float_value_ge_0 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value - value == 0.0)):
      raise ApiError("""%s.setWaterSurfaceCutoff:
       NonNegativeFloat constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('waterSurfaceCutoff')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setWaterSurfaceCutoff:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setWaterSurfaceCutoff:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setWaterSurfaceCutoff:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['waterSurfaceCutoff'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setWaterSurfaceCutoff')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setWaterToAddRandom(self, value):
    """
    Set for utrecht.Haddock.Run.waterToAddRandom
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Float.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Float.create(value)
    else:
      raise ApiError("""%s.setWaterToAddRandom:
       memops.Implementation.FloatRatio input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (0.0 <= value)):
      raise ApiError("""%s.setWaterToAddRandom:
       FloatRatio constraint value_ge_0 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value - value == 0.0)):
      raise ApiError("""%s.setWaterToAddRandom:
       FloatRatio constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value <= 1.0)):
      raise ApiError("""%s.setWaterToAddRandom:
       FloatRatio constraint value_le_1 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('waterToAddRandom')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setWaterToAddRandom:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setWaterToAddRandom:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setWaterToAddRandom:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['waterToAddRandom'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setWaterToAddRandom')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setWaterToKeep(self, value):
    """
    Set for utrecht.Haddock.Run.waterToKeep
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Float.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Float.create(value)
    else:
      raise ApiError("""%s.setWaterToKeep:
       memops.Implementation.FloatRatio input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (0.0 <= value)):
      raise ApiError("""%s.setWaterToKeep:
       FloatRatio constraint value_ge_0 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value - value == 0.0)):
      raise ApiError("""%s.setWaterToKeep:
       FloatRatio constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value <= 1.0)):
      raise ApiError("""%s.setWaterToKeep:
       FloatRatio constraint value_le_1 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('waterToKeep')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setWaterToKeep:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setWaterToKeep:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setWaterToKeep:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['waterToKeep'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setWaterToKeep')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def sortedHaddockEnergyTerms(self):
    """
    Sorted for utrecht.Haddock.Run.haddockEnergyTerms
    """
    dataDict = self.__dict__
    sortdd = dataDict.get('haddockEnergyTerms')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result
  
  def sortedScoringWeights(self):
    """
    Sorted for utrecht.Haddock.Run.scoringWeights
    """
    dataDict = self.__dict__
    sortdd = dataDict.get('scoringWeights')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result
  
  def sortedSymmetryRestraints(self):
    """
    Sorted for utrecht.Haddock.Run.symmetryRestraints
    """
    dataDict = self.__dict__
    ll = dataDict.get('symmetryRestraints')
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString
  
  analysisClustRmsd = property(getAnalysisClustRmsd, setAnalysisClustRmsd, None,
  r"""
  """)
  
  analysisClustSize = property(getAnalysisClustSize, setAnalysisClustSize, None,
  r"""
  """)
  
  analysisDistHBond = property(getAnalysisDistHBond, setAnalysisDistHBond, None,
  r"""
  """)
  
  analysisDistNonbond = property(getAnalysisDistNonbond, setAnalysisDistNonbond, None,
  r"""
  """)

  applicationData = memops.api.Implementation.DataObject.applicationData
  
  calcDesolvation = property(getCalcDesolvation, setCalcDesolvation, None,
  r"""
  """)
  
  centerOfMassConstant = property(getCenterOfMassConstant, setCenterOfMassConstant, None,
  r"""
  """)
  
  centerOfMassRestraints = property(getCenterOfMassRestraints, setCenterOfMassRestraints, None,
  r"""(cmrest)
  """)

  className = memops.api.Implementation.ComplexDataType.className
  
  cnsExecutable = property(getCnsExecutable, setCnsExecutable, None,
  r"""Defines the path to the CNS exacutable
  """)
  
  cpuNumber = property(getCpuNumber, setCpuNumber, None,
  r""" Defines the number of cpu's used in a cluster for  
  submission of 
  Haddock jobs.
  """)
  
  dielectricType = property(getDielectricType, setDielectricType, None,
  r"""(dielec)
  """)
  
  doAirScaling = property(getDoAirScaling, setDoAirScaling, None,
  r"""Use automated distance restraints weighting. cns name: air_scaling
  """)
  
  doIncludeDihEnergy = property(getDoIncludeDihEnergy, setDoIncludeDihEnergy, None,
  r"""(dihedflag)
  """)
  
  doRigidBodyElectrostatics = property(getDoRigidBodyElectrostatics, setDoRigidBodyElectrostatics, None,
  r"""(elecflag_0)
  """)
  
  doRigidBodyWaterTrans = property(getDoRigidBodyWaterTrans, setDoRigidBodyWaterTrans, None,
  r"""Allows translation of water molecules during rigid-body docking. cns 
  name: transwater
  """)
  
  doRigidTranslations = property(getDoRigidTranslations, setDoRigidTranslations, None,
  r"""
  """)
  
  doSAElectrostatics = property(getDoSAElectrostatics, setDoSAElectrostatics, None,
  r"""(elecflag_1)
  """)
  
  doWaterAnalysis = property(getDoWaterAnalysis, setDoWaterAnalysis, None,
  r"""Do some water analysis. cns name: water_analysis
  """)
  
  doWaterDock = property(getDoWaterDock, setDoWaterDock, None,
  r"""Do water docking (waterdock)	
  """)
  
  epsilon = property(getEpsilon, setEpsilon, None,
  r"""(epsilon)
  """)

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames
  
  haddockDir = property(getHaddockDir, setHaddockDir, None,
  r"""Defines the path to the Haddock software directory.
  """)

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor
  
  initialRigidBodyMinim = property(getInitialRigidBodyMinim, setInitialRigidBodyMinim, None,
  r"""
  """)

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted

  metaclass = memops.api.Implementation.ComplexDataType.metaclass
  
  nTrails = property(getNTrails, setNTrails, None,
  r"""
  """)
  
  ncsRestraintConstant = property(getNcsRestraintConstant, setNcsRestraintConstant, None,
  r"""Force constant for ncs restraints (kncs)
  """)
  
  nonBondedType = property(getNonBondedType, setNonBondedType, None,
  r"""Run non-bonded interaction type
  """)
  
  numAmbRestautoAir = property(getNumAmbRestautoAir, setNumAmbRestautoAir, None,
  r"""Define the number of AIR restraints for automated weighting. cns name: 
  numAmbRestautoAir
  """)
  
  numAnalysisStructures = property(getNumAnalysisStructures, setNumAnalysisStructures, None,
  r"""Number of structures to nalyse (anastruc_1)
  """)
  
  numInitWaterShells = property(getNumInitWaterShells, setNumInitWaterShells, None,
  r"""Number of different initial solvation shells to generate. cns name: 
  waterensemble
  """)
  
  numIt0Structures = property(getNumIt0Structures, setNumIt0Structures, None,
  r"""Number of iteration 0 (rigid dynamics) structures. (structures_0)
  """)
  
  numIt1Structures = property(getNumIt1Structures, setNumIt1Structures, None,
  r"""Number of iteration 1 (flexible dynamics) structures.
  """)
  
  numUnambRestautoAir = property(getNumUnambRestautoAir, setNumUnambRestautoAir, None,
  r"""Number of distance restraints for automated weighting. cns name: 
  tot_unamb
  """)
  
  numWrefStructures = property(getNumWrefStructures, setNumWrefStructures, None,
  r"""Number of water refinemetn structures (waterrefine)
  """)

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName
  
  queueCommand = property(getQueueCommand, setQueueCommand, None,
  r""" Defines the queue type for Haddock job submission. 'csh'  
  is default 
  for running on a single machine in C-shell.
  """)
  
  radomizeStartOriention = property(getRadomizeStartOriention, setRadomizeStartOriention, None,
  r"""
  """)
  
  randomAmbigRestraints = property(getRandomAmbigRestraints, setRandomAmbigRestraints, None,
  r"""Use random ambiguos interaction restraints (ranair)
  """)
  
  randomExclParts = property(getRandomExclParts, setRandomExclParts, None,
  r"""Number of partitons for random exclusion (ncvpart)
  """)
  
  randomExcludeAir = property(getRandomExcludeAir, setRandomExcludeAir, None,
  r"""Randomly exclude ambiguous interaction restraints (noecv)
  """)
  
  randomSeed = property(getRandomSeed, setRandomSeed, None,
  r"""
  """)
  
  removeNonPolarH = property(getRemoveNonPolarH, setRemoveNonPolarH, None,
  r"""Remove non-polar hydrogens (delenph)
  """)
  
  rigidbodyIMinteractScaling = property(getRigidbodyIMinteractScaling, setRigidbodyIMinteractScaling, None,
  r"""(inter_rigid) 
  """)
  
  rotate180It0 = property(getRotate180It0, setRotate180It0, None,
  r"""
  """)
  
  rotate180It1 = property(getRotate180It1, setRotate180It1, None,
  r"""
  """)
  
  serial = property(getSerial, setSerial, None,
  r"""Serial number of object. Serves as object main key. Serial numbers of 
  deleted objects are not re-used. Serial numbers can only be set by the 
  implementation. Values are in practice always positive, since negative 
  values are interpreted as a signal to set the next free serial
  """)
  
  skipStructures = property(getSkipStructures, setSkipStructures, None,
  r"""
  """)
  
  solvent = property(getSolvent, setSolvent, None,
  r"""
  """)
  
  surfaceContactConstant = property(getSurfaceContactConstant, setSurfaceContactConstant, None,
  r"""(ksurf)
  """)
  
  surfaceContactRestraints = property(getSurfaceContactRestraints, setSurfaceContactRestraints, None,
  r"""
  """)
  
  symmetryRestraintConstant = property(getSymmetryRestraintConstant, setSymmetryRestraintConstant, None,
  r"""Force constant for symmetry restraints ((ksym)
  """)
  
  useDbSolvateMethod = property(getUseDbSolvateMethod, setUseDbSolvateMethod, None,
  r"""Use database driven solvation method? cns name: solvate_method
  """)
  
  useDnaRestraints = property(getUseDnaRestraints, setUseDnaRestraints, None,
  r"""(dnarest_on)
  """)
  
  useHBondRestraints = property(getUseHBondRestraints, setUseHBondRestraints, None,
  r"""
  """)
  
  waterInitRestCutoff = property(getWaterInitRestCutoff, setWaterInitRestCutoff, None,
  r"""Initial cutoff for restraints solvating method. cns name 
  water_restraint_initial
  """)
  
  waterRestCutoff = property(getWaterRestCutoff, setWaterRestCutoff, None,
  r"""Cutoff for restraints solvating method. cns name: waterRestCutoff
  """)
  
  waterRestScale = property(getWaterRestScale, setWaterRestScale, None,
  r"""Force constant for restraints solvating method. cns name: 
  water_restraint_scale
  """)
  
  waterSurfaceCutoff = property(getWaterSurfaceCutoff, setWaterSurfaceCutoff, None,
  r"""Water-protein surface-cutoff. cns name water_surfcutoff
  """)
  
  waterToAddRandom = property(getWaterToAddRandom, setWaterToAddRandom, None,
  r"""Random fraction to be added to the fraction of water to keep. cns name: 
  water_randfrac
  """)
  
  waterToKeep = property(getWaterToKeep, setWaterToKeep, None,
  r"""Fraction of water to keep. cns name: water_tokeep
  """)

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess
  
  annealProtocol = property(getAnnealProtocol, setAnnealProtocol, None,
  r"""
  """)
  
  haddockEnergyTerms = property(getHaddockEnergyTerms,  None, None,
  r"""child link to class HaddockEnergyTerm
  """)
  
  haddockProject = property(getHaddockProject,  None, None,
  r"""parent link
  """)
  
  nmrConstraintStore = property(getNmrConstraintStore, setNmrConstraintStore, None,
  r"""CCP NmrConstraintStore where data come from
  """)
  
  parent = property(getParent, None, None,
  r"""link to parent object - synonym for haddockProject
  """)

  root = memops.api.Implementation.MemopsObject.root
  
  scoringWeights = property(getScoringWeights,  None, None,
  r"""child link to class ScoringWeight
  """)
  
  symmetryRestraints = property(getSymmetryRestraints, setSymmetryRestraints, None,
  r"""MolSystem symmetry operations used as restraints. The type depends on 
  the symmetryCode of the Symmetry linked to.
  """)

  topObject = memops.api.Implementation.DataObject.topObject

###############################################################################
class ScoringWeight(memops.api.Implementation.DataObject):
  r"""Haddock scoring weight.
  """
  #   from data model element utrecht.Haddock.ScoringWeight revision ?
  _metaclass = metaPackage.getElement('ScoringWeight')
  _packageName = 'utrecht.Haddock'
  _packageShortName = 'HADD'
  _fieldNames = ('applicationData', 'className', 'fieldNames', 'inConstructor', 'isDeleted', 'metaclass', 'packageName', 'packageShortName', 'qualifiedName', 'stage', 'term', 'value', 'access', 'activeAccess', 'parent', 'root', 'run', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for utrecht.Haddock.ScoringWeight
    """
    dataDict = self.__dict__
    dataDict['run'] = parent
    if (not isinstance(parent, Run)):
      raise ApiError("""%s.__init__:
       value is not of class utrecht.Haddock.Run""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = parent.__dict__.get('topObject')
    dataDict['topObject'] = topObject

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    if (notIsReading):
      if (not (topObject.__dict__.get('isModifiable'))):
        raise ApiError("""%s.__init__:
         Storage not modifiable""" % self.qualifiedName
         + ": %s" % (topObject,)
        )

    try:

      dataDict['applicationData'] = list()
      dataDict['stage'] = None
      dataDict['term'] = None
      dataDict['value'] = None
      dataDict['access'] = None

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in utrecht.Haddock.ScoringWeight.__init__"
        del dataDict['inConstructor']
        raise

      if (notIsReading):
        childrenDict = parent.__dict__.get('scoringWeights')
        ll = list()
        objKey = dataDict.get('term')
        ll.append(objKey)
        if (objKey is not None):
          objKey = dataDict.get('stage')
          ll.append(objKey)
          if (objKey is not None):
            objKey = tuple(ll)

        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['term', 'stage'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notOverride):
        self.checkValid()

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for utrecht.Haddock.ScoringWeight:
       determines cascading 
    deletes to follow from delete of object.
       *Implementation function* - 
    should be called only by API delete function.
    """
    dataDict = self.__dict__
    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for utrecht.Haddock.ScoringWeight:   deletes
    objects
    *Implementation function* - will CORRUPT DATA if called outside 
    the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    run = dataDict.get('run')
    if (not (run in objsToBeDeleted)):
      ll = list()
      objKey = dataDict.get('term')
      ll.append(objKey)
      if (objKey is not None):
        objKey = dataDict.get('stage')
        ll.append(objKey)
        if (objKey is not None):
          objKey = tuple(ll)

      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = run.__dict__.get('scoringWeights')
        if (self is dd.get(objKey)):
          del dd[objKey]

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData
  
  def checkAllValid(self, complete=False):
    """
    CheckAllValid for utrecht.Haddock.ScoringWeight
    """
    dataDict = self.__dict__
    self.checkValid(complete)
  
  def checkValid(self, complete=False):
    """
    CheckValid for utrecht.Haddock.ScoringWeight
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      ll = list()
      objKey = dataDict.get('term')
      ll.append(objKey)
      if (objKey is not None):
        objKey = dataDict.get('stage')
        ll.append(objKey)
        if (objKey is not None):
          objKey = tuple(ll)

      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('run')
        dd = value.__dict__.get('scoringWeights')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'run' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      # check attributes
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('stage')
      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.checkValid: stage:
         memops.Implementation.NonNegativeInt input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value >= 0)):
        raise ApiError("""%s.checkValid: stage:
         NonNegativeInt constraint int_value_ge_0 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('term')
      if (not (value in ['vdw', 'elec', 'dist', 'sani', 'dani', 'vean', 'cdih', 'sym', 'bsa', 'deint', 'desolv'])):
        raise ApiError("""%s.checkValid: term:
         utrecht.Haddock.ScoringTerm input is not in enumeration ['vdw', 'elec', 'dist', 'sani', 'dani', 'vean', 'cdih', 'sym', 'bsa', 'deint', 'desolv']""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.checkValid: term:
         ScoringTerm constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('value')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.Float.PythonType)):
          pass
        elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
          value = memops.api.Implementation.Float.create(value)
        else:
          raise ApiError("""%s.checkValid: value:
           memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (value - value == 0.0)):
          raise ApiError("""%s.checkValid: value:
           Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('run')
      if (not isinstance(value, Run)):
        raise ApiError("""%s.checkValid: run:
         value is not of class utrecht.Haddock.Run""" % self.qualifiedName
         + ": %s" % (value,)
        )

    # check explicit class constraints
    # check attributes
    values = dataDict.get('applicationData')
    for value in values:
      value.checkAllValid(complete)

    value = dataDict.get('stage')
    if (value is None):
      raise ApiError("""%s.checkValid: stage:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('term')
    if (value is None):
      raise ApiError("""%s.checkValid: term:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('value')
    # check roles
    value = dataDict.get('access')
    value = dataDict.get('run')
    if (value is None):
      raise ApiError("""%s.checkValid: run:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

  delete = memops.api.Implementation.DataObject.delete

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData
  
  def get(self, name):
    """
    GetAttr for utrecht.Haddock.ScoringWeight
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for utrecht.Haddock.ScoringWeight
    """

    result = None
    if (startObj.__class__.__name__ == 'MemopsRoot'):
      if (4 != len(fullKey)):
        raise ApiError("""'utrecht.Haddock.ScoringWeight'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj0 = startObj
      objKey = fullKey[0]
      obj1 = obj0.__dict__.get('haddockProjects').get(objKey)
      if (obj1 is None):
        obj0.refreshTopObjects('utrecht.Haddock')
        obj1 = obj0.__dict__.get('haddockProjects').get(objKey)

    else:
      if (3 != len(fullKey)):
        raise ApiError("""'utrecht.Haddock.ScoringWeight'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj1 = startObj

    if (obj1 is not None):
      if (not (obj1.__dict__.get('isLoaded'))):
        obj1.load()

      objKey = fullKey[-3]
      obj2 = obj1.__dict__.get('runs').get(objKey)

      if (obj2 is not None):
        ll = list()
        objKey = fullKey[-2]
        ll.append(objKey)
        if (objKey is not None):
          objKey = fullKey[-1]
          ll.append(objKey)
          if (objKey is not None):
            objKey = tuple(ll)

        obj3 = obj2.__dict__.get('scoringWeights').get(objKey)
        result = obj3

    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation

  getClassName = memops.api.Implementation.ComplexDataType.getClassName

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames
  
  def getFullKey(self, useGuid=False):
    """
    GetFullKey for utrecht.Haddock.ScoringWeight
    """
    dataDict = self.__dict__
    result = list()

    obj2 = dataDict.get('run')
    obj1 = obj2.__dict__.get('haddockProject')

    if (useGuid):
      result.append(obj1.__dict__.get('guid'))
    else:
      result.append(obj1.__dict__.get('name'))

    result.append(obj2.__dict__.get('serial'))
    result.append(dataDict.get('term'))
    result.append(dataDict.get('stage'))

    return result

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted
  
  def getLocalKey(self):
    """
    GetLocalKey for utrecht.Haddock.ScoringWeight
    """
    dataDict = self.__dict__
    ll = list()
    result = dataDict.get('term')
    ll.append(result)
    if (result is not None):
      result = dataDict.get('stage')
      ll.append(result)
      if (result is not None):
        result = tuple(ll)

    return result

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName
  
  def getParent(self):
    """
    Get for utrecht.Haddock.ScoringWeight.parent
    """
    dataDict = self.__dict__
    result = dataDict.get('run')
    return result

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName

  getRoot = memops.api.Implementation.MemopsObject.getRoot
  
  def getRun(self):
    """
    Get for utrecht.Haddock.ScoringWeight.run
    """
    dataDict = self.__dict__
    result = dataDict.get('run')
    return result
  
  def getStage(self):
    """
    Get for utrecht.Haddock.ScoringWeight.stage
    """
    dataDict = self.__dict__
    result = dataDict.get('stage')
    return result
  
  def getTerm(self):
    """
    Get for utrecht.Haddock.ScoringWeight.term
    """
    dataDict = self.__dict__
    result = dataDict.get('term')
    return result

  getTopObject = memops.api.Implementation.DataObject.getTopObject
  
  def getValue(self):
    """
    Get for utrecht.Haddock.ScoringWeight.value
    """
    dataDict = self.__dict__
    result = dataDict.get('value')
    return result

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData
  
  def set(self, name, value):
    """
    SetAttr for utrecht.Haddock.ScoringWeight
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData
  
  def setStage(self, value):
    """
    Set for utrecht.Haddock.ScoringWeight.stage
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Int.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Int.create(value)
    else:
      raise ApiError("""%s.setStage:
       memops.Implementation.NonNegativeInt input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value >= 0)):
      raise ApiError("""%s.setStage:
       NonNegativeInt constraint int_value_ge_0 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('stage')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setStage:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setStage:
         cannot set stage, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setStage:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['stage'] = value

    # doNotifies
  
  def setTerm(self, value):
    """
    Set for utrecht.Haddock.ScoringWeight.term
    """
    dataDict = self.__dict__
    if (not (value in ['vdw', 'elec', 'dist', 'sani', 'dani', 'vean', 'cdih', 'sym', 'bsa', 'deint', 'desolv'])):
      raise ApiError("""%s.setTerm:
       utrecht.Haddock.ScoringTerm input is not in enumeration ['vdw', 'elec', 'dist', 'sani', 'dani', 'vean', 'cdih', 'sym', 'bsa', 'deint', 'desolv']""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.split()) == 1)):
      raise ApiError("""%s.setTerm:
       ScoringTerm constraint contains_no_white_space violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('term')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setTerm:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setTerm:
         cannot set term, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setTerm:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['term'] = value

    # doNotifies
  
  def setValue(self, value):
    """
    Set for utrecht.Haddock.ScoringWeight.value
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.Float.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Float.create(value)
      else:
        raise ApiError("""%s.setValue:
         memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value - value == 0.0)):
        raise ApiError("""%s.setValue:
         Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('value')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setValue:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setValue:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['value'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setValue')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  applicationData = memops.api.Implementation.DataObject.applicationData

  className = memops.api.Implementation.ComplexDataType.className

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted

  metaclass = memops.api.Implementation.ComplexDataType.metaclass

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName
  
  stage = property(getStage, setStage, None,
  r"""Number of stage being scored
  """)
  
  term = property(getTerm, setTerm, None,
  r"""Term being scored
  """)
  
  value = property(getValue, setValue, None,
  r"""Value of scoring weight
  """)

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess
  
  parent = property(getParent, None, None,
  r"""link to parent object - synonym for run
  """)

  root = memops.api.Implementation.MemopsObject.root
  
  run = property(getRun,  None, None,
  r"""parent link
  """)

  topObject = memops.api.Implementation.DataObject.topObject
