"""
#######################################################################

CCPN Data Model version 2.1.2

Autogenerated by PyFileApiGen revision 1.57.2.1 on Fri Mar 28 11:19:28 2014
  from data model element ccp.molecule.LabeledMolecule revision ?

#######################################################################
======================COPYRIGHT/LICENSE START==========================

LabeledMolecule.py: python API for CCPN data model, MetaPackage ccp.molecule.LabeledMolecule

Copyright (C) 2007  (CCPN Project)

=======================================================================

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
A copy of this license can be found in ../../../../license/LGPL.license
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
Lesser General Public License for more details.
 
You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA


======================COPYRIGHT/LICENSE END============================

for further information, please contact :

- CCPN website (http://www.ccpn.ac.uk/)

- email: ccpn@bioc.cam.ac.uk

=======================================================================

If you are using this software for academic purposes, we suggest
quoting the following references:

===========================REFERENCE START=============================
Rasmus H. Fogh, Wayne Boucher, Wim F. Vranken, Anne
Pajon, Tim J. Stevens, T.N. Bhat, John Westbrook, John M.C. Ionides and
Ernest D. Laue (2005). A framework for scientific data modeling and automated
software development. Bioinformatics 21, 1678-1684.


This file was generated with the Memops software generation framework,
and contains original contributions embedded in the framework

===========================REFERENCE END===============================
"""

import cStringIO
#import sets
import traceback
import types
import operator

# special function for fast whitespace checking.
# used in DataType Word and Token handcode
import re
containsWhitespace = re.compile('\s').search
containsNonAlphanumeric = re.compile('[^a-zA-Z0-9_]').search
 
from memops.general import Implementation as implementation
ApiError = implementation.ApiError

# imported packages:
import ccp.api.molecule.ChemComp
import ccp.api.molecule.ChemCompLabel
import ccp.api.molecule.Molecule
import memops.api.AccessControl
import memops.api.Implementation

metaPackage = memops.api.Implementation.topPackage.metaObjFromQualName('ccp.molecule.LabeledMolecule')

###############################################################################
class AtomLabel(memops.api.Implementation.DataObject):
  r"""Atom label indicators. 
  """
  #   from data model element ccp.molecule.LabeledMolecule.AtomLabel revision ?
  _metaclass = metaPackage.getElement('AtomLabel')
  _packageName = 'ccp.molecule.LabeledMolecule'
  _packageShortName = 'LMOL'
  _fieldNames = ('applicationData', 'className', 'fieldNames', 'inConstructor', 'isDeleted', 'massNumber', 'metaclass', 'packageName', 'packageShortName', 'qualifiedName', 'serial', 'weight', 'access', 'activeAccess', 'parent', 'resLabel', 'root', 'topObject',)

  __init__ = memops.api.Implementation.ComplexDataType.__init__

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData

  checkAllValid = memops.api.Implementation.ComplexDataType.checkAllValid

  checkValid = memops.api.Implementation.ComplexDataType.checkValid

  delete = memops.api.Implementation.DataObject.delete

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccp.molecule.LabeledMolecule.AtomLabel
    """

    result = None
    if (startObj.__class__.__name__ == 'MemopsRoot'):
      if (4 != len(fullKey)):
        raise ApiError("""'ccp.molecule.LabeledMolecule.AtomLabel'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj0 = startObj
      objKey = fullKey[0]
      obj1 = obj0.__dict__.get('labeledMolecules').get(objKey)
      if (obj1 is None):
        obj0.refreshTopObjects('ccp.molecule.LabeledMolecule')
        obj1 = obj0.__dict__.get('labeledMolecules').get(objKey)

    else:
      if (3 != len(fullKey)):
        raise ApiError("""'ccp.molecule.LabeledMolecule.AtomLabel'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj1 = startObj

    if (obj1 is not None):
      if (not (obj1.__dict__.get('isLoaded'))):
        obj1.load()

      objKey = fullKey[-3]
      obj2 = obj1.__dict__.get('molLabels').get(objKey)

      if (obj2 is not None):
        objKey = fullKey[-2]
        obj3 = obj2.__dict__.get('resLabels').get(objKey)

        if (obj3 is not None):
          objKey = fullKey[-1]
          obj4 = obj3.__dict__.get('atomLabels').get(objKey)
          result = obj4

    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation

  getClassName = memops.api.Implementation.ComplexDataType.getClassName

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames
  
  def getFullKey(self, useGuid=False):
    """
    GetFullKey for ccp.molecule.LabeledMolecule.AtomLabel
    """
    dataDict = self.__dict__
    result = list()

    obj3 = dataDict.get('resLabel')
    obj2 = obj3.__dict__.get('molLabel')
    obj1 = obj2.__dict__.get('labeledMolecule')

    if (useGuid):
      result.append(obj1.__dict__.get('guid'))
    else:
      result.append(obj1.__dict__.get('name'))

    result.append(obj2.__dict__.get('serial'))
    result.append(obj3.__dict__.get('resId'))
    result.append(dataDict.get('serial'))

    return result

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted
  
  def getLocalKey(self):
    """
    GetLocalKey for ccp.molecule.LabeledMolecule.AtomLabel
    """
    dataDict = self.__dict__
    result = dataDict.get('serial')
    return result
  
  def getMassNumber(self):
    """
    Get for ccp.molecule.LabeledMolecule.AtomLabel.massNumber
    """
    dataDict = self.__dict__
    result = dataDict.get('massNumber')
    return result

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName
  
  def getParent(self):
    """
    Get for ccp.molecule.LabeledMolecule.AtomLabel.parent
    """
    dataDict = self.__dict__
    result = dataDict.get('resLabel')
    return result

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName
  
  def getResLabel(self):
    """
    Get for ccp.molecule.LabeledMolecule.AtomLabel.resLabel
    """
    dataDict = self.__dict__
    result = dataDict.get('resLabel')
    return result

  getRoot = memops.api.Implementation.MemopsObject.getRoot
  
  def getSerial(self):
    """
    Get for ccp.molecule.LabeledMolecule.AtomLabel.serial
    """
    dataDict = self.__dict__
    result = dataDict.get('serial')
    return result

  getTopObject = memops.api.Implementation.DataObject.getTopObject
  
  def getWeight(self):
    """
    Get for ccp.molecule.LabeledMolecule.AtomLabel.weight
    """
    dataDict = self.__dict__
    result = dataDict.get('weight')
    return result

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData

  setAccess = memops.api.Implementation.DataObject.setAccess

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData
  
  def setMassNumber(self, value):
    """
    Set for ccp.molecule.LabeledMolecule.AtomLabel.massNumber
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Int.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Int.create(value)
    else:
      raise ApiError("""%s.setMassNumber:
       memops.Implementation.PositiveInt input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value > 0)):
      raise ApiError("""%s.setMassNumber:
       PositiveInt constraint int_value_gt_0 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('massNumber')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setMassNumber:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setMassNumber:
         cannot set massNumber, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setMassNumber:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['massNumber'] = value

    # doNotifies
  
  def setSerial(self, value):
    """
    Set for ccp.molecule.LabeledMolecule.AtomLabel.serial
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Int.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Int.create(value)
    else:
      raise ApiError("""%s.setSerial:
       memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('serial')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setSerial:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setSerial:
         cannot set serial, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setSerial:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    parent = dataDict.get('resLabel')
    oldSerial = parent.__dict__.get('_serialDict').get('atomLabels')
    if (value < 0):
      value = (oldSerial + 1)
      parent.__dict__.get('_serialDict')['atomLabels'] = value
    elif (value > oldSerial):
      parent.__dict__.get('_serialDict')['atomLabels'] = value

    dataDict['serial'] = value

    # doNotifies
  
  def setWeight(self, value):
    """
    Set for ccp.molecule.LabeledMolecule.AtomLabel.weight
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Float.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Float.create(value)
    else:
      raise ApiError("""%s.setWeight:
       memops.Implementation.NonNegativeFloat input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (0.0 <= value)):
      raise ApiError("""%s.setWeight:
       NonNegativeFloat constraint float_value_ge_0 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value - value == 0.0)):
      raise ApiError("""%s.setWeight:
       NonNegativeFloat constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('weight')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setWeight:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setWeight:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setWeight:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['weight'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setWeight')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  applicationData = memops.api.Implementation.DataObject.applicationData

  className = memops.api.Implementation.ComplexDataType.className

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted
  
  massNumber = property(getMassNumber, setMassNumber, None,
  r"""Mass number of relevant Isotope
  """)

  metaclass = memops.api.Implementation.ComplexDataType.metaclass

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName
  
  serial = property(getSerial, setSerial, None,
  r"""Serial number of object. Serves as object main key. Serial numbers of 
  deleted objects are not re-used. Serial numbers can only be set by the 
  implementation. Values are in practice always positive, since negative 
  values are interpreted as a signal to set the next free serial
  """)
  
  weight = property(getWeight, setWeight, None,
  r"""Relative Abundance of atom labeling defined by this object
  """)

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess
  
  parent = property(getParent, None, None,
  r"""link to parent object - synonym for resLabel
  """)
  
  resLabel = property(getResLabel,  None, None,
  r"""parent link
  """)

  root = memops.api.Implementation.MemopsObject.root

  topObject = memops.api.Implementation.DataObject.topObject

###############################################################################
class LabeledMixture(memops.api.Implementation.DataObject):
  r"""Mixture of labeled species.
  """
  #   from data model element ccp.molecule.LabeledMolecule.LabeledMixture revision ?
  _metaclass = metaPackage.getElement('LabeledMixture')
  _packageName = 'ccp.molecule.LabeledMolecule'
  _packageShortName = 'LMOL'
  _fieldNames = ('applicationData', 'className', 'fieldNames', 'inConstructor', 'isDeleted', 'metaclass', 'name', 'packageName', 'packageShortName', 'qualifiedName', 'serial', 'access', 'activeAccess', 'averageComposition', 'experiments', 'labeledMolecule', 'molComponents', 'molLabelFractions', 'parent', 'root', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for ccp.molecule.LabeledMolecule.LabeledMixture
    """
    dataDict = self.__dict__
    dataDict['labeledMolecule'] = parent
    if (not isinstance(parent, LabeledMolecule)):
      raise ApiError("""%s.__init__:
       value is not of class ccp.molecule.LabeledMolecule.LabeledMolecule""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = parent.__dict__.get('topObject')
    dataDict['topObject'] = topObject

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    if (notIsReading):
      if (not (topObject.__dict__.get('isModifiable'))):
        raise ApiError("""%s.__init__:
         Storage not modifiable""" % self.qualifiedName
         + ": %s" % (topObject,)
        )

    try:
      if (not ((parent.__dict__.get('isLoaded') or parent.__dict__.get('isReading')))):
        parent.load()

      dataDict['applicationData'] = list()
      dataDict['name'] = None
      dataDict['serial'] = None
      dataDict['access'] = None
      dataDict['averageComposition'] = None
      dataDict['experiments'] = set()
      dataDict['molComponents'] = set()
      dataDict['molLabelFractions'] = {}

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in ccp.molecule.LabeledMolecule.LabeledMixture.__init__"
        del dataDict['inConstructor']
        raise

      if (notOverride):
        if (dataDict.get('serial') is None):
          dataDict['inConstructor'] = True
          self.setSerial(-1)
          del dataDict['inConstructor']
        else:
          raise ApiError("""%s.__init__:
           Cannot pass in explicit serial if not reading""" % self.qualifiedName
           + ": %s:%s" % (parent, 'ccp.molecule.LabeledMolecule.LabeledMixture')
          )

      if (notIsReading):
        childrenDict = parent.__dict__.get('labeledMixtures')
        objKey = dataDict.get('serial')
        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['serial'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notOverride):
        self.checkValid()

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for ccp.molecule.LabeledMolecule.LabeledMixture:
       
    determines cascading deletes to follow from delete of object.
       
    *Implementation function* - should be called only by API delete 
    function.
    """
    dataDict = self.__dict__
    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.Nmr')
    tobjList = root.__dict__.get('nmrProjects').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    experiments = dataDict.get('experiments')
    pass
    for experiment in experiments:
      topObject = experiment.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.lims.RefSampleComponent')
    tobjList = root.__dict__.get('refSampleComponentStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    molComponents = dataDict.get('molComponents')
    pass
    for molComponent in molComponents:
      topObject = molComponent.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    molLabelFractions = dataDict.get('molLabelFractions').values()
    for molLabelFraction in molLabelFractions:
      if (not (molLabelFraction in objsToBeDeleted)):
        objsToBeDeleted.add(molLabelFraction)
        objsToBeChecked.append(molLabelFraction)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for ccp.molecule.LabeledMolecule.LabeledMixture:   deletes
    objects
    *Implementation function* - will CORRUPT DATA if called outside 
    the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    averageComposition = dataDict.get('averageComposition')
    if ((averageComposition is not None and not (averageComposition in objsToBeDeleted))):
      averageLabeledMixtures = averageComposition.__dict__.get('averageLabeledMixtures')
      averageLabeledMixtures.remove(self)

    for experiment in dataDict.get('experiments'):
      if (not (experiment in objsToBeDeleted)):
        labeledMixtures = experiment.__dict__.get('labeledMixtures')
        labeledMixtures.remove(self)

    for molComponent in dataDict.get('molComponents'):
      if (not (molComponent in objsToBeDeleted)):
        molComponent.__dict__['labeledMixture'] = None

    labeledMolecule = dataDict.get('labeledMolecule')
    if (not (labeledMolecule in objsToBeDeleted)):
      objKey = dataDict.get('serial')
      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = labeledMolecule.__dict__.get('labeledMixtures')
        if (self is dd.get(objKey)):
          del dd[objKey]

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData
  
  def addExperiment(self, value):
    """
    Add for ccp.molecule.LabeledMolecule.LabeledMixture.experiments
    """
    dataDict = self.__dict__
    from ccp.api.nmr.Nmr import Experiment as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.addExperiment:
       value is not of class ccp.nmr.Nmr.Experiment""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.Nmr')
    tobjList = root.__dict__.get('nmrProjects').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    currentValues = dataDict.get('experiments')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      topObject = value.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)
      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.addExperiment:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.addExperiment:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.addExperiment:
       called with deleted value""" % self.qualifiedName
      )

    if (value in currentValues):
      raise ApiError("""%s.addExperiment:
       value is in list already""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.addExperiment:
           Link experiments between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    oldSelves = value.__dict__.get('labeledMixtures')
    oldSelves.add(self)
    currentValues.add(value)
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('addExperiment')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def addMolComponent(self, value):
    """
    Add for ccp.molecule.LabeledMolecule.LabeledMixture.molComponents
    """
    dataDict = self.__dict__
    from ccp.api.lims.RefSampleComponent import MolComponent as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.addMolComponent:
       value is not of class ccp.lims.RefSampleComponent.MolComponent""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.lims.RefSampleComponent')
    tobjList = root.__dict__.get('refSampleComponentStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    currentValues = dataDict.get('molComponents')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      topObject = value.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)
      oldSelf = value.__dict__.get('labeledMixture')
      if (oldSelf is not None):
        topObject = oldSelf.__dict__.get('topObject')
        topObjectsToCheck.add(topObject)

      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.addMolComponent:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.addMolComponent:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.addMolComponent:
       called with deleted value""" % self.qualifiedName
      )

    if (value in currentValues):
      raise ApiError("""%s.addMolComponent:
       value is in list already""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.addMolComponent:
           Link molComponents between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    oldSelf = value.__dict__.get('labeledMixture')
    if (oldSelf is not None):
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.lims.RefSampleComponent')
      tobjList = root.__dict__.get('refSampleComponentStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      siblingValues = oldSelf.__dict__.get('molComponents')
      siblingValues.remove(value)

    value.__dict__['labeledMixture'] = self
    currentValues.add(value)
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('addMolComponent')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def checkAllValid(self, complete=False):
    """
    CheckAllValid for ccp.molecule.LabeledMolecule.LabeledMixture
    """
    dataDict = self.__dict__
    self.checkValid(complete)
    values = dataDict.get('molLabelFractions').values()
    for value in values:
      value.checkAllValid(complete)

  def checkValid(self, complete=False):
    """
    CheckValid for ccp.molecule.LabeledMolecule.LabeledMixture
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      objKey = dataDict.get('serial')
      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('labeledMolecule')
        dd = value.__dict__.get('labeledMixtures')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'labeledMolecule' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      # check attributes
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('name')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: name:
           memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: name:
           memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: name:
           memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: name:
           Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('serial')
      if (value is None):
        raise ApiError("""%s.checkValid: serial:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.checkValid: serial:
         memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('averageComposition')
      if (value is not None):
        if (not isinstance(value, MolLabel)):
          raise ApiError("""%s.checkValid: averageComposition:
           value is not of class ccp.molecule.LabeledMolecule.MolLabel""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('averageLabeledMixtures')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: averageComposition:
           non-reciprocal link averageComposition from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.Nmr')
      tobjList = root.__dict__.get('nmrProjects').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      values = dataDict.get('experiments')
      for value in values:
        from ccp.api.nmr.Nmr import Experiment as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: experiments:
           value is not of class ccp.nmr.Nmr.Experiment""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('labeledMixtures')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: experiments:
           non-reciprocal link experiments from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: experiments:
           Link experiments between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('labeledMolecule')
      if (not isinstance(value, LabeledMolecule)):
        raise ApiError("""%s.checkValid: labeledMolecule:
         value is not of class ccp.molecule.LabeledMolecule.LabeledMolecule""" % self.qualifiedName
         + ": %s" % (value,)
        )

      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.lims.RefSampleComponent')
      tobjList = root.__dict__.get('refSampleComponentStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      values = dataDict.get('molComponents')
      for value in values:
        from ccp.api.lims.RefSampleComponent import MolComponent as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: molComponents:
           value is not of class ccp.lims.RefSampleComponent.MolComponent""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('labeledMixture')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: molComponents:
           non-reciprocal link molComponents from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: molComponents:
           Link molComponents between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      values = dataDict.get('molLabelFractions').values()
      for value in values:
        if (not isinstance(value, MolLabelFraction)):
          raise ApiError("""%s.checkValid: molLabelFractions:
           value is not of class ccp.molecule.LabeledMolecule.MolLabelFraction""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('labeledMixture')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: molLabelFractions:
           non-reciprocal link molLabelFractions from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

    # check explicit class constraints
    # check attributes
    values = dataDict.get('applicationData')
    for value in values:
      value.checkAllValid(complete)

    value = dataDict.get('name')
    # check roles
    value = dataDict.get('access')
    value = dataDict.get('averageComposition')
    values = dataDict.get('experiments')
    value = dataDict.get('labeledMolecule')
    if (value is None):
      raise ApiError("""%s.checkValid: labeledMolecule:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    values = dataDict.get('molComponents')
    values = dataDict.get('molLabelFractions').values()

  delete = memops.api.Implementation.DataObject.delete

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData
  
  def findAllExperiments(self, **conditions):
    """
    FindAll for ccp.molecule.LabeledMolecule.LabeledMixture.experiments
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.Nmr')
      tobjList = root.__dict__.get('nmrProjects').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('experiments')
      result = set(currentValues)

    else:
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.Nmr')
      tobjList = root.__dict__.get('nmrProjects').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('experiments')
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('date', 'details', 'name', 'nmrTubeType', 'numDim', 'numScans', 'sampleState', 'sampleVolume', 'serial', 'spinningAngle', 'spinningRate', 'userExpCode', 'volumeUnit', 'access', 'derivationMethod', 'dipolarRelaxList', 'hExchProtectionList', 'hExchRateList', 'isotropicS2List', 'jCouplingList', 'nmrProject', 'noeList', 'pkaList', 'probe', 'rawData', 'rdcList', 'refExperiment', 'sample', 'sampleConditionSet', 'shiftAnisotropyList', 'shiftDifferenceList', 'shiftList', 'spectralDensityList', 'spectrometer', 't1List', 't1RhoList', 't2List',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllMolComponents(self, **conditions):
    """
    FindAll for ccp.molecule.LabeledMolecule.LabeledMixture.molComponents
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.lims.RefSampleComponent')
      tobjList = root.__dict__.get('refSampleComponentStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('molComponents')
      result = set(currentValues)

    else:
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.lims.RefSampleComponent')
      tobjList = root.__dict__.get('refSampleComponentStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('molComponents')
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('casNum', 'details', 'empiricalFormula', 'molType', 'molecularMass', 'name', 'seqDetails', 'seqString', 'access', 'labeledMixture', 'molecule', 'naturalSource', 'refSampleComponentStore',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllMolLabelFractions(self, **conditions):
    """
    FindAll for
    ccp.molecule.LabeledMolecule.LabeledMixture.molLabelFractions
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('molLabelFractions').values()
      result = set(currentValues)

    else:
      currentValues = dataDict.get('molLabelFractions').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('weight', 'access', 'labeledMixture', 'molLabel',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData
  
  def findFirstExperiment(self, **conditions):
    """
    FindFirst for ccp.molecule.LabeledMolecule.LabeledMixture.experiments
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.Nmr')
      tobjList = root.__dict__.get('nmrProjects').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('experiments')
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.nmr.Nmr')
      tobjList = root.__dict__.get('nmrProjects').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('experiments')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('date', 'details', 'name', 'nmrTubeType', 'numDim', 'numScans', 'sampleState', 'sampleVolume', 'serial', 'spinningAngle', 'spinningRate', 'userExpCode', 'volumeUnit', 'access', 'derivationMethod', 'dipolarRelaxList', 'hExchProtectionList', 'hExchRateList', 'isotropicS2List', 'jCouplingList', 'nmrProject', 'noeList', 'pkaList', 'probe', 'rawData', 'rdcList', 'refExperiment', 'sample', 'sampleConditionSet', 'shiftAnisotropyList', 'shiftDifferenceList', 'shiftList', 'spectralDensityList', 'spectrometer', 't1List', 't1RhoList', 't2List',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstMolComponent(self, **conditions):
    """
    FindFirst for ccp.molecule.LabeledMolecule.LabeledMixture.molComponents
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.lims.RefSampleComponent')
      tobjList = root.__dict__.get('refSampleComponentStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('molComponents')
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      root = dataDict.get('topObject').__dict__.get('memopsRoot')
      root.refreshTopObjects('ccp.lims.RefSampleComponent')
      tobjList = root.__dict__.get('refSampleComponentStores').values()
      for tobj in tobjList:
        if (not (tobj.__dict__.get('isLoaded'))):
          tobj.load()

      currentValues = dataDict.get('molComponents')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('casNum', 'details', 'empiricalFormula', 'molType', 'molecularMass', 'name', 'seqDetails', 'seqString', 'access', 'labeledMixture', 'molecule', 'naturalSource', 'refSampleComponentStore',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstMolLabelFraction(self, **conditions):
    """
    FindFirst for
    ccp.molecule.LabeledMolecule.LabeledMixture.molLabelFractions
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('molLabelFractions').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      objKey = conditions.get('molLabel')
      if (objKey is not None):
        result = dataDict.get('molLabelFractions').get(objKey)

        if (nConditions <= 1):
          return result

        elif (result is None):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        currentValues = dataDict.get('molLabelFractions').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('weight', 'access', 'labeledMixture', 'molLabel',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def get(self, name):
    """
    GetAttr for ccp.molecule.LabeledMolecule.LabeledMixture
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getAverageComposition(self):
    """
    Get for ccp.molecule.LabeledMolecule.LabeledMixture.averageComposition
    """
    dataDict = self.__dict__
    result = dataDict.get('averageComposition')
    return result
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccp.molecule.LabeledMolecule.LabeledMixture
    """

    result = None
    if (startObj.__class__.__name__ == 'MemopsRoot'):
      if (2 != len(fullKey)):
        raise ApiError("""'ccp.molecule.LabeledMolecule.LabeledMixture'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj0 = startObj
      objKey = fullKey[0]
      obj1 = obj0.__dict__.get('labeledMolecules').get(objKey)
      if (obj1 is None):
        obj0.refreshTopObjects('ccp.molecule.LabeledMolecule')
        obj1 = obj0.__dict__.get('labeledMolecules').get(objKey)

    else:
      if (1 != len(fullKey)):
        raise ApiError("""'ccp.molecule.LabeledMolecule.LabeledMixture'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj1 = startObj

    if (obj1 is not None):
      if (not (obj1.__dict__.get('isLoaded'))):
        obj1.load()

      objKey = fullKey[-1]
      obj2 = obj1.__dict__.get('labeledMixtures').get(objKey)
      result = obj2

    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation

  getClassName = memops.api.Implementation.ComplexDataType.getClassName

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey
  
  def getExperiments(self):
    """
    Get for ccp.molecule.LabeledMolecule.LabeledMixture.experiments
    """
    dataDict = self.__dict__
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.Nmr')
    tobjList = root.__dict__.get('nmrProjects').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    tempVar = dataDict.get('experiments')
    result = frozenset(tempVar)
    return result

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames
  
  def getFullKey(self, useGuid=False):
    """
    GetFullKey for ccp.molecule.LabeledMolecule.LabeledMixture
    """
    dataDict = self.__dict__
    result = list()

    obj1 = dataDict.get('labeledMolecule')

    if (useGuid):
      result.append(obj1.__dict__.get('guid'))
    else:
      result.append(obj1.__dict__.get('name'))

    result.append(dataDict.get('serial'))

    return result

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted
  
  def getLabeledMolecule(self):
    """
    Get for ccp.molecule.LabeledMolecule.LabeledMixture.labeledMolecule
    """
    dataDict = self.__dict__
    result = dataDict.get('labeledMolecule')
    return result
  
  def getLocalKey(self):
    """
    GetLocalKey for ccp.molecule.LabeledMolecule.LabeledMixture
    """
    dataDict = self.__dict__
    result = dataDict.get('serial')
    return result

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass
  
  def getMolComponents(self):
    """
    Get for ccp.molecule.LabeledMolecule.LabeledMixture.molComponents
    """
    dataDict = self.__dict__
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.lims.RefSampleComponent')
    tobjList = root.__dict__.get('refSampleComponentStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    tempVar = dataDict.get('molComponents')
    result = frozenset(tempVar)
    return result
  
  def getMolLabelFractions(self):
    """
    Get for ccp.molecule.LabeledMolecule.LabeledMixture.molLabelFractions
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('molLabelFractions').values()
    result = frozenset(tempVar)
    return result
  
  def getName(self):
    """
    Get for ccp.molecule.LabeledMolecule.LabeledMixture.name
    """
    dataDict = self.__dict__
    result = dataDict.get('name')
    return result

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName
  
  def getParent(self):
    """
    Get for ccp.molecule.LabeledMolecule.LabeledMixture.parent
    """
    dataDict = self.__dict__
    result = dataDict.get('labeledMolecule')
    return result

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName

  getRoot = memops.api.Implementation.MemopsObject.getRoot
  
  def getSerial(self):
    """
    Get for ccp.molecule.LabeledMolecule.LabeledMixture.serial
    """
    dataDict = self.__dict__
    result = dataDict.get('serial')
    return result

  getTopObject = memops.api.Implementation.DataObject.getTopObject
  
  def newMolLabelFraction(self, **attrlinks):
    """
    Factory function to create ccp.molecule.LabeledMolecule.MolLabelFraction
    """
    return MolLabelFraction(self, **attrlinks)

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData
  
  def removeExperiment(self, value):
    """
    Remove for ccp.molecule.LabeledMolecule.LabeledMixture.experiments
    """
    dataDict = self.__dict__
    from ccp.api.nmr.Nmr import Experiment as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.removeExperiment:
       value is not of class ccp.nmr.Nmr.Experiment""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.Nmr')
    tobjList = root.__dict__.get('nmrProjects').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    currentValues = dataDict.get('experiments')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      topObject = value.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)
      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.removeExperiment:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.removeExperiment:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.removeExperiment:
       called with deleted value""" % self.qualifiedName
      )

    if (not (value in currentValues)):
      raise ApiError("""%s.removeExperiment:
       value not in list""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      pass

    oldSelves = value.__dict__.get('labeledMixtures')
    oldSelves.remove(self)
    currentValues.remove(value)
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('removeExperiment')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def removeMolComponent(self, value):
    """
    Remove for ccp.molecule.LabeledMolecule.LabeledMixture.molComponents
    """
    dataDict = self.__dict__
    from ccp.api.lims.RefSampleComponent import MolComponent as importedType
    if (not isinstance(value, importedType)):
      raise ApiError("""%s.removeMolComponent:
       value is not of class ccp.lims.RefSampleComponent.MolComponent""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.lims.RefSampleComponent')
    tobjList = root.__dict__.get('refSampleComponentStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    currentValues = dataDict.get('molComponents')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      topObject = value.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)
      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.removeMolComponent:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.removeMolComponent:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.removeMolComponent:
       called with deleted value""" % self.qualifiedName
      )

    if (not (value in currentValues)):
      raise ApiError("""%s.removeMolComponent:
       value not in list""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      pass

    value.__dict__['labeledMixture'] = None
    currentValues.remove(value)
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('removeMolComponent')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def set(self, name, value):
    """
    SetAttr for ccp.molecule.LabeledMolecule.LabeledMixture
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData
  
  def setAverageComposition(self, value):
    """
    Set for ccp.molecule.LabeledMolecule.LabeledMixture.averageComposition
    """
    dataDict = self.__dict__
    if (value is not None):
      if (not isinstance(value, MolLabel)):
        raise ApiError("""%s.setAverageComposition:
         value is not of class ccp.molecule.LabeledMolecule.MolLabel""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('averageComposition')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setAverageComposition:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setAverageComposition:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setAverageComposition:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setAverageComposition:
           Link averageComposition between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    if (currentValue is not None):
      if (notIsReading):
        oldSelves = currentValue.__dict__.get('averageLabeledMixtures')
        oldSelves.remove(self)
      else:
        raise ApiError("""%s.setAverageComposition:
         Read link 'averageComposition' incompatible with pre-existing link""" % self.qualifiedName
         + ": %s" % (self,)
        )

    if (value is not None):
      newSelves = value.__dict__.get('averageLabeledMixtures')
      newSelves.add(self)

    dataDict['averageComposition'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setAverageComposition')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setExperiments(self, values):
    """
    Set for ccp.molecule.LabeledMolecule.LabeledMixture.experiments
    """
    dataDict = self.__dict__
    xx = values
    values = set(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setExperiments:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      from ccp.api.nmr.Nmr import Experiment as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setExperiments:
         value is not of class ccp.nmr.Nmr.Experiment""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.Nmr')
    tobjList = root.__dict__.get('nmrProjects').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    currentValues = dataDict.get('experiments')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      for pv in currentValues:
        if (not (pv in values)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)

      for pv in values:
        if (not (pv in currentValues)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)

      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setExperiments:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setExperiments:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setExperiments:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
      for value in values:
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setExperiments:
           Link experiments between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    for cv in currentValues:
      if (not (cv in values)):
        oldSelves = cv.__dict__.get('labeledMixtures')
        oldSelves.remove(self)

    for cv in values:
      if (not (cv in currentValues)):
        oldSelves = cv.__dict__.get('labeledMixtures')
        oldSelves.add(self)

    dataDict['experiments'] = values
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setExperiments')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setMolComponents(self, values):
    """
    Set for ccp.molecule.LabeledMolecule.LabeledMixture.molComponents
    """
    dataDict = self.__dict__
    xx = values
    values = set(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setMolComponents:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      from ccp.api.lims.RefSampleComponent import MolComponent as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setMolComponents:
         value is not of class ccp.lims.RefSampleComponent.MolComponent""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.lims.RefSampleComponent')
    tobjList = root.__dict__.get('refSampleComponentStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    currentValues = dataDict.get('molComponents')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      for pv in currentValues:
        if (not (pv in values)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)

      for pv in values:
        if (not (pv in currentValues)):
          topObject = pv.__dict__.get('topObject')
          topObjectsToCheck.add(topObject)
          oldSelf = pv.__dict__.get('labeledMixture')
          if (oldSelf is not None):
            if (notIsReading):
              topObject = oldSelf.__dict__.get('topObject')
              topObjectsToCheck.add(topObject)
            else:
              raise ApiError("""%s.setMolComponents:
               Read link incompatible with pre-existing link""" % self.qualifiedName
               + ": %s" % (self,)
              )

      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setMolComponents:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setMolComponents:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setMolComponents:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
      for value in values:
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setMolComponents:
           Link molComponents between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    for cv in currentValues:
      if (not (cv in values)):
        cv.__dict__['labeledMixture'] = None

    for cv in values:
      if (not (cv in currentValues)):
        oldSelf = cv.__dict__.get('labeledMixture')
        if (oldSelf is not None):
          vv = oldSelf.__dict__.get('molComponents')
          vv.remove(cv)

      cv.__dict__['labeledMixture'] = self

    dataDict['molComponents'] = values
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setMolComponents')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setName(self, value):
    """
    Set for ccp.molecule.LabeledMolecule.LabeledMixture.name
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.setName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.setName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('name')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setName:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setName:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['name'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setName')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setSerial(self, value):
    """
    Set for ccp.molecule.LabeledMolecule.LabeledMixture.serial
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Int.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Int.create(value)
    else:
      raise ApiError("""%s.setSerial:
       memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('serial')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setSerial:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setSerial:
         cannot set serial, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setSerial:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    parent = dataDict.get('labeledMolecule')
    oldSerial = parent.__dict__.get('_serialDict').get('labeledMixtures')
    if (value < 0):
      value = (oldSerial + 1)
      parent.__dict__.get('_serialDict')['labeledMixtures'] = value
    elif (value > oldSerial):
      parent.__dict__.get('_serialDict')['labeledMixtures'] = value

    dataDict['serial'] = value

    # doNotifies
  
  def sortedExperiments(self):
    """
    Sorted for ccp.molecule.LabeledMolecule.LabeledMixture.experiments
    """
    dataDict = self.__dict__
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.nmr.Nmr')
    tobjList = root.__dict__.get('nmrProjects').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    ll = dataDict.get('experiments')
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result
  
  def sortedMolComponents(self):
    """
    Sorted for ccp.molecule.LabeledMolecule.LabeledMixture.molComponents
    """
    dataDict = self.__dict__
    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    root.refreshTopObjects('ccp.lims.RefSampleComponent')
    tobjList = root.__dict__.get('refSampleComponentStores').values()
    for tobj in tobjList:
      if (not (tobj.__dict__.get('isLoaded'))):
        tobj.load()

    ll = dataDict.get('molComponents')
    ll = [(repr(x),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result
  
  def sortedMolLabelFractions(self):
    """
    Sorted for ccp.molecule.LabeledMolecule.LabeledMixture.molLabelFractions
    """
    dataDict = self.__dict__
    sortdd = dataDict.get('molLabelFractions')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  applicationData = memops.api.Implementation.DataObject.applicationData

  className = memops.api.Implementation.ComplexDataType.className

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted

  metaclass = memops.api.Implementation.ComplexDataType.metaclass
  
  name = property(getName, setName, None,
  r"""User intelligible name of LabeledMixture
  """)

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName
  
  serial = property(getSerial, setSerial, None,
  r"""Serial number of object. Serves as object main key. Serial numbers of 
  deleted objects are not re-used. Serial numbers can only be set by the 
  implementation. Values are in practice always positive, since negative 
  values are interpreted as a signal to set the next free serial
  """)

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess
  
  averageComposition = property(getAverageComposition, setAverageComposition, None,
  r"""Average composition of LabeledMixture. The average composition can also 
  be derived from the MolLabelFractions, but the averageComposition takes 
  precedence in case of conflict.
  """)
  
  experiments = property(getExperiments, setExperiments, None,
  r"""Nmr.Experiments labeled according to LabeledMixture
  """)
  
  labeledMolecule = property(getLabeledMolecule,  None, None,
  r"""parent link
  """)
  
  molComponents = property(getMolComponents, setMolComponents, None,
  r"""MolComponents labeled according to LabeledMixture
  """)
  
  molLabelFractions = property(getMolLabelFractions,  None, None,
  r"""child link to class MolLabelFraction
  """)
  
  parent = property(getParent, None, None,
  r"""link to parent object - synonym for labeledMolecule
  """)

  root = memops.api.Implementation.MemopsObject.root

  topObject = memops.api.Implementation.DataObject.topObject

###############################################################################
class LabeledMolecule(memops.api.Implementation.TopObject):
  r"""Molecule whose labeling is presented. 
  """
  #   from data model element ccp.molecule.LabeledMolecule.LabeledMolecule revision ?
  _metaclass = metaPackage.getElement('LabeledMolecule')
  _packageName = 'ccp.molecule.LabeledMolecule'
  _packageShortName = 'LMOL'
  _fieldNames = ('applicationData', 'className', 'createdBy', 'fieldNames', 'guid', 'inConstructor', 'isDeleted', 'isLoaded', 'isModifiable', 'isModified', 'isReading', 'lastUnlockedBy', 'metaclass', 'name', 'packageName', 'packageShortName', 'qualifiedName', 'access', 'activeAccess', 'activeRepositories', 'labeledMixtures', 'memopsRoot', 'molLabels', 'molecule', 'packageLocator', 'parent', 'root', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for ccp.molecule.LabeledMolecule.LabeledMolecule
    """
    dataDict = self.__dict__
    dataDict['memopsRoot'] = parent
    from memops.api.Implementation import MemopsRoot as importedType
    if (not isinstance(parent, importedType)):
      raise ApiError("""%s.__init__:
       value is not of class memops.Implementation.MemopsRoot""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = self
    dataDict['topObject'] = topObject
    if (attrlinks.get('isReading', False)):
      del attrlinks['isReading']
      dataDict['isLoaded'] = False
      dataDict['isModified'] = False
      dataDict['isReading'] = True
    elif (parent.__dict__.get('isReading')):
      dataDict['isLoaded'] = False
      dataDict['isModified'] = False
      dataDict['isReading'] = True
    else:
      dataDict['isLoaded'] = True
      dataDict['isModified'] = True
      dataDict['isReading'] = False

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    try:
      if (not (dataDict.get('isReading'))):
        parent.refreshTopObjects('ccp.molecule.LabeledMolecule')

      dataDict['applicationData'] = list()
      dataDict['createdBy'] = None
      dataDict['guid'] = None
      dataDict['isModifiable'] = True
      dataDict['lastUnlockedBy'] = None
      dataDict['name'] = None
      dataDict['access'] = None
      dataDict['labeledMixtures'] = {}
      dataDict['molLabels'] = {}
      dataDict['activeRepositories'] = list()

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in ccp.molecule.LabeledMolecule.LabeledMolecule.__init__"
        del dataDict['inConstructor']
        raise

      serialDict = {}
      serialDict['labeledMixtures'] = 0
      serialDict['molLabels'] = 0
      dataDict['_serialDict'] = serialDict

      if (notIsReading):
        childrenDict = parent.__dict__.get('labeledMolecules')
        objKey = dataDict.get('name')
        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['name'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notIsReading):
        guid = dataDict.get('guid')
        if (guid is None):
          guid = root.newGuid()
          dataDict['guid'] = guid

        dd = root.__dict__.get('topObjects')
        if (dd.get(guid) is None):
          dd[guid] = self
        else:
          raise ApiError("""%s.__init__:
           Creating TopObject with preexisting guid""" % self.qualifiedName
           + ": %s" % (self,)
          )

        dataDict['createdBy'] = root.__dict__.get('currentUserId')
        
        
        if self.molecule is None:
          raise ApiError("LabeledMolecule.name %s does not match an existing molecule" % self.name)

      if (notOverride):
        self.checkValid()

      if ((notIsReading or root.__dict__.get('currentLabeledMolecule') is None)):
        root.__dict__['currentLabeledMolecule'] = self

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for ccp.molecule.LabeledMolecule.LabeledMolecule:
       
    determines cascading deletes to follow from delete of object.
       
    *Implementation function* - should be called only by API delete 
    function.
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    labeledMixtures = dataDict.get('labeledMixtures').values()
    for labeledMixture in labeledMixtures:
      if (not (labeledMixture in objsToBeDeleted)):
        objsToBeDeleted.add(labeledMixture)
        objsToBeChecked.append(labeledMixture)

    memopsRoot = dataDict.get('memopsRoot')
    if (memopsRoot is not None):
      topObject = memopsRoot.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    molLabels = dataDict.get('molLabels').values()
    for molLabel in molLabels:
      if (not (molLabel in objsToBeDeleted)):
        objsToBeDeleted.add(molLabel)
        objsToBeChecked.append(molLabel)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for ccp.molecule.LabeledMolecule.LabeledMolecule:   deletes
    objects
    *Implementation function* - will CORRUPT DATA if called outside 
    the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    memopsRoot = dataDict.get('memopsRoot')
    if (self is memopsRoot.__dict__.get('currentLabeledMolecule')):
      memopsRoot.__dict__['currentLabeledMolecule'] = None

    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    memopsRoot = dataDict.get('memopsRoot')
    if (not (memopsRoot in objsToBeDeleted)):
      objKey = dataDict.get('name')
      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = memopsRoot.__dict__.get('labeledMolecules')
        if (self is dd.get(objKey)):
          del dd[objKey]

    dataDict['labeledMixtures'] = {}
    dataDict['molLabels'] = {}

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData

  backup = memops.api.Implementation.TopObject.backup
  
  def checkAllValid(self, complete=False):
    """
    CheckAllValid for ccp.molecule.LabeledMolecule.LabeledMolecule
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    self.checkValid(complete)
    values = dataDict.get('labeledMixtures').values()
    for value in values:
      value.checkAllValid(complete)

    values = dataDict.get('molLabels').values()
    for value in values:
      value.checkAllValid(complete)

  def checkValid(self, complete=False):
    """
    CheckValid for ccp.molecule.LabeledMolecule.LabeledMolecule
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      objKey = dataDict.get('name')
      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('memopsRoot')
        dd = value.__dict__.get('labeledMolecules')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'memopsRoot' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      # check attributes
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('createdBy')
      if (value is None):
        raise ApiError("""%s.checkValid: createdBy:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: createdBy:
         memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 32):
        raise ApiError("""%s.checkValid: createdBy:
         memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: createdBy:
         memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.checkValid: createdBy:
         Word constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('guid')
      if (value is None):
        raise ApiError("""%s.checkValid: guid:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: guid:
         memops.Implementation.GuidString input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: guid:
         memops.Implementation.GuidString maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: guid:
         memops.Implementation.GuidString: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: guid:
         GuidString constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      isValid = frozenset('abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_0123456789-').issuperset(value)
      if (not (isValid)):
        raise ApiError("""%s.checkValid: guid:
         GuidString constraint value_is_url_safe violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('isModifiable')
      if (not (value in [True, False])):
        raise ApiError("""%s.checkValid: isModifiable:
         memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('lastUnlockedBy')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: lastUnlockedBy:
           memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 32):
          raise ApiError("""%s.checkValid: lastUnlockedBy:
           memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: lastUnlockedBy:
           memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.split()) == 1)):
          raise ApiError("""%s.checkValid: lastUnlockedBy:
           Word constraint contains_no_white_space violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('name')
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: name:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: name:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: name:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: name:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      values = dataDict.get('labeledMixtures').values()
      for value in values:
        if (not isinstance(value, LabeledMixture)):
          raise ApiError("""%s.checkValid: labeledMixtures:
           value is not of class ccp.molecule.LabeledMolecule.LabeledMixture""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('labeledMolecule')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: labeledMixtures:
           non-reciprocal link labeledMixtures from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      value = dataDict.get('memopsRoot')
      from memops.api.Implementation import MemopsRoot as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.checkValid: memopsRoot:
         value is not of class memops.Implementation.MemopsRoot""" % self.qualifiedName
         + ": %s" % (value,)
        )

      values = dataDict.get('molLabels').values()
      for value in values:
        if (not isinstance(value, MolLabel)):
          raise ApiError("""%s.checkValid: molLabels:
           value is not of class ccp.molecule.LabeledMolecule.MolLabel""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('labeledMolecule')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: molLabels:
           non-reciprocal link molLabels from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      value = self.getMolecule()
      if (value is None):
        raise ApiError("""%s.checkValid: molecule:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      from ccp.api.molecule.Molecule import Molecule as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.checkValid: molecule:
         value is not of class ccp.molecule.Molecule.Molecule""" % self.qualifiedName
         + ": %s" % (value,)
        )

      xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
      yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
      if (not (xx1 is yy1)):
        raise ApiError("""%s.checkValid: molecule:
         Link molecule between objects from separate partitions
         - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
         + ": %s:%s" % (self, value)
        )

      value = self.getPackageLocator()
      if (value is None):
        raise ApiError("""%s.checkValid: packageLocator:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      from memops.api.Implementation import PackageLocator as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.checkValid: packageLocator:
         value is not of class memops.Implementation.PackageLocator""" % self.qualifiedName
         + ": %s" % (value,)
        )

      xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
      yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
      if (not (xx1 is yy1)):
        raise ApiError("""%s.checkValid: packageLocator:
         Link packageLocator between objects from separate partitions
         - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
         + ": %s:%s" % (self, value)
        )

    if (dataDict.get('isLoaded')):
      # check explicit class constraints
      # check attributes
      values = dataDict.get('applicationData')
      for value in values:
        value.checkAllValid(complete)

      value = dataDict.get('isModifiable')
      if (value is None):
        raise ApiError("""%s.checkValid: isModifiable:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      value = dataDict.get('name')
      if (value is None):
        raise ApiError("""%s.checkValid: name:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      # check roles
      value = dataDict.get('access')
      values = dataDict.get('labeledMixtures').values()
      value = dataDict.get('memopsRoot')
      if (value is None):
        raise ApiError("""%s.checkValid: memopsRoot:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      values = dataDict.get('molLabels').values()
    else:
      # check unloaded TopObject
      value = dataDict.get('guid')
      if (value is None):
        raise ApiError("""%s.checkValid: guid:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      value = dataDict.get('name')
      if (value is None):
        raise ApiError("""%s.checkValid: name:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

  delete = memops.api.Implementation.DataObject.delete

  findAllActiveRepositories = memops.api.Implementation.TopObject.findAllActiveRepositories

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData
  
  def findAllLabeledMixtures(self, **conditions):
    """
    FindAll for ccp.molecule.LabeledMolecule.LabeledMolecule.labeledMixtures
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('labeledMixtures').values()
      result = set(currentValues)

    else:
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('labeledMixtures').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('name', 'serial', 'access', 'averageComposition', 'labeledMolecule',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllMolLabels(self, **conditions):
    """
    FindAll for ccp.molecule.LabeledMolecule.LabeledMolecule.molLabels
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('molLabels').values()
      result = set(currentValues)

    else:
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('molLabels').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('serial', 'access', 'labeledMolecule',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result

  findFirstActiveRepository = memops.api.Implementation.TopObject.findFirstActiveRepository

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData
  
  def findFirstLabeledMixture(self, **conditions):
    """
    FindFirst for
    ccp.molecule.LabeledMolecule.LabeledMolecule.labeledMixtures
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('labeledMixtures').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      objKey = conditions.get('serial')
      if (objKey is not None):
        if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
          self.load()

        result = dataDict.get('labeledMixtures').get(objKey)

        if (nConditions <= 1):
          return result

        elif (result is None):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
          self.load()

        currentValues = dataDict.get('labeledMixtures').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('name', 'serial', 'access', 'averageComposition', 'labeledMolecule',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstMolLabel(self, **conditions):
    """
    FindFirst for ccp.molecule.LabeledMolecule.LabeledMolecule.molLabels
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('molLabels').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      objKey = conditions.get('serial')
      if (objKey is not None):
        if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
          self.load()

        result = dataDict.get('molLabels').get(objKey)

        if (nConditions <= 1):
          return result

        elif (result is None):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
          self.load()

        currentValues = dataDict.get('molLabels').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('serial', 'access', 'labeledMolecule',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def get(self, name):
    """
    GetAttr for ccp.molecule.LabeledMolecule.LabeledMolecule
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess

  getActiveRepositories = memops.api.Implementation.TopObject.getActiveRepositories

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccp.molecule.LabeledMolecule.LabeledMolecule
    """

    result = None
    if (1 != len(fullKey)):
      raise ApiError("""'ccp.molecule.LabeledMolecule.LabeledMolecule'.getByKey:
       getByKey called with fullKey of wrong length. Parameters:"""
       + ": %s:%s" % (startObj, fullKey)
      )

    objKey = fullKey[0]
    obj1 = startObj.__dict__.get('labeledMolecules').get(objKey)
    if (obj1 is None):
      startObj.refreshTopObjects('ccp.molecule.LabeledMolecule')
      obj1 = startObj.__dict__.get('labeledMolecules').get(objKey)

    result = obj1
    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation

  getClassName = memops.api.Implementation.ComplexDataType.getClassName

  getCreatedBy = memops.api.Implementation.TopObject.getCreatedBy

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames
  
  def getFullKey(self, useGuid=False):
    """
    GetFullKey for ccp.molecule.LabeledMolecule.LabeledMolecule
    """
    dataDict = self.__dict__
    result = list()

    if (useGuid):
      result.append(dataDict.get('guid'))
    else:
      result.append(dataDict.get('name'))

    return result

  getGuid = memops.api.Implementation.TopObject.getGuid

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted

  getIsLoaded = memops.api.Implementation.TopObject.getIsLoaded

  getIsModifiable = memops.api.Implementation.TopObject.getIsModifiable

  getIsModified = memops.api.Implementation.TopObject.getIsModified

  getIsReading = memops.api.Implementation.TopObject.getIsReading
  
  def getLabeledMixtures(self):
    """
    Get for ccp.molecule.LabeledMolecule.LabeledMolecule.labeledMixtures
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    tempVar = dataDict.get('labeledMixtures').values()
    result = frozenset(tempVar)
    return result

  getLastUnlockedBy = memops.api.Implementation.TopObject.getLastUnlockedBy
  
  def getLocalKey(self):
    """
    GetLocalKey for ccp.molecule.LabeledMolecule.LabeledMolecule
    """
    dataDict = self.__dict__
    result = dataDict.get('name')
    return result
  
  def getMemopsRoot(self):
    """
    Get for ccp.molecule.LabeledMolecule.LabeledMolecule.memopsRoot
    """
    dataDict = self.__dict__
    result = dataDict.get('memopsRoot')
    return result

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass
  
  def getMolLabels(self):
    """
    Get for ccp.molecule.LabeledMolecule.LabeledMolecule.molLabels
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    tempVar = dataDict.get('molLabels').values()
    result = frozenset(tempVar)
    return result
  
  def getMolecule(self):
    """
    getter for derived link molecule
    """
    dataDict = self.__dict__
    result = self.parent.findFirstMolecule(name=self.name)
    return result
  
  def getName(self):
    """
    Get for ccp.molecule.LabeledMolecule.LabeledMolecule.name
    """
    dataDict = self.__dict__
    result = dataDict.get('name')
    return result

  getPackageLocator = memops.api.Implementation.TopObject.getPackageLocator

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName
  
  def getParent(self):
    """
    Get for ccp.molecule.LabeledMolecule.LabeledMolecule.parent
    """
    dataDict = self.__dict__
    result = dataDict.get('memopsRoot')
    return result

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName

  getRoot = memops.api.Implementation.MemopsObject.getRoot

  getTopObject = memops.api.Implementation.DataObject.getTopObject

  load = memops.api.Implementation.TopObject.load

  loadFrom = memops.api.Implementation.TopObject.loadFrom
  
  def newLabeledMixture(self, **attrlinks):
    """
    Factory function to create ccp.molecule.LabeledMolecule.LabeledMixture
    """
    return LabeledMixture(self, **attrlinks)
  
  def newMolLabel(self, **attrlinks):
    """
    Factory function to create ccp.molecule.LabeledMolecule.MolLabel
    """
    return MolLabel(self, **attrlinks)

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData

  removeFrom = memops.api.Implementation.TopObject.removeFrom

  restore = memops.api.Implementation.TopObject.restore

  save = memops.api.Implementation.TopObject.save

  saveTo = memops.api.Implementation.TopObject.saveTo
  
  def set(self, name, value):
    """
    SetAttr for ccp.molecule.LabeledMolecule.LabeledMolecule
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData

  setCreatedBy = memops.api.Implementation.TopObject.setCreatedBy

  setGuid = memops.api.Implementation.TopObject.setGuid

  setIsModifiable = memops.api.Implementation.TopObject.setIsModifiable

  setLastUnlockedBy = memops.api.Implementation.TopObject.setLastUnlockedBy
  
  def setName(self, value):
    """
    Set for ccp.molecule.LabeledMolecule.LabeledMolecule.name
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.setName:
       memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 80):
      raise ApiError("""%s.setName:
       memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.setName:
       memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.splitlines()) <= 1)):
      raise ApiError("""%s.setName:
       Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValue = dataDict.get('name')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setName:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setName:
         cannot set name, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['name'] = value

    # doNotifies
  
  def sortedLabeledMixtures(self):
    """
    Sorted for ccp.molecule.LabeledMolecule.LabeledMolecule.labeledMixtures
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    sortdd = dataDict.get('labeledMixtures')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result
  
  def sortedMolLabels(self):
    """
    Sorted for ccp.molecule.LabeledMolecule.LabeledMolecule.molLabels
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    sortdd = dataDict.get('molLabels')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  touch = memops.api.Implementation.TopObject.touch

  applicationData = memops.api.Implementation.DataObject.applicationData

  className = memops.api.Implementation.ComplexDataType.className

  createdBy = memops.api.Implementation.TopObject.createdBy

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames

  guid = memops.api.Implementation.TopObject.guid

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted

  isLoaded = memops.api.Implementation.TopObject.isLoaded

  isModifiable = memops.api.Implementation.TopObject.isModifiable

  isModified = memops.api.Implementation.TopObject.isModified

  isReading = memops.api.Implementation.TopObject.isReading

  lastUnlockedBy = memops.api.Implementation.TopObject.lastUnlockedBy

  metaclass = memops.api.Implementation.ComplexDataType.metaclass
  
  name = property(getName, setName, None,
  r"""Molecule name - correspopnds to Molecule.Molecule.name
  """)

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess

  activeRepositories = memops.api.Implementation.TopObject.activeRepositories
  
  labeledMixtures = property(getLabeledMixtures,  None, None,
  r"""child link to class LabeledMixture
  """)
  
  memopsRoot = property(getMemopsRoot,  None, None,
  r"""parent link
  """)
  
  molLabels = property(getMolLabels,  None, None,
  r"""child link to class MolLabel
  """)
  
  molecule = property(getMolecule, None, None,
  r"""Molecule being labeled
  """)

  packageLocator = memops.api.Implementation.TopObject.packageLocator
  
  parent = property(getParent, None, None,
  r"""link to parent object - synonym for memopsRoot
  """)

  root = memops.api.Implementation.MemopsObject.root

  topObject = memops.api.Implementation.DataObject.topObject

###############################################################################
class MolLabel(memops.api.Implementation.DataObject):
  r"""Molecule labeling pattern
  """
  #   from data model element ccp.molecule.LabeledMolecule.MolLabel revision ?
  _metaclass = metaPackage.getElement('MolLabel')
  _packageName = 'ccp.molecule.LabeledMolecule'
  _packageShortName = 'LMOL'
  _fieldNames = ('applicationData', 'className', 'fieldNames', 'inConstructor', 'isDeleted', 'metaclass', 'packageName', 'packageShortName', 'qualifiedName', 'serial', 'access', 'activeAccess', 'averageLabeledMixtures', 'labeledMolecule', 'molLabelFractions', 'parent', 'resLabels', 'root', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for ccp.molecule.LabeledMolecule.MolLabel
    """
    dataDict = self.__dict__
    dataDict['labeledMolecule'] = parent
    if (not isinstance(parent, LabeledMolecule)):
      raise ApiError("""%s.__init__:
       value is not of class ccp.molecule.LabeledMolecule.LabeledMolecule""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = parent.__dict__.get('topObject')
    dataDict['topObject'] = topObject

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    if (notIsReading):
      if (not (topObject.__dict__.get('isModifiable'))):
        raise ApiError("""%s.__init__:
         Storage not modifiable""" % self.qualifiedName
         + ": %s" % (topObject,)
        )

    try:
      if (not ((parent.__dict__.get('isLoaded') or parent.__dict__.get('isReading')))):
        parent.load()

      dataDict['applicationData'] = list()
      dataDict['serial'] = None
      dataDict['access'] = None
      dataDict['averageLabeledMixtures'] = set()
      dataDict['molLabelFractions'] = set()
      dataDict['resLabels'] = {}

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in ccp.molecule.LabeledMolecule.MolLabel.__init__"
        del dataDict['inConstructor']
        raise

      if (notOverride):
        if (dataDict.get('serial') is None):
          dataDict['inConstructor'] = True
          self.setSerial(-1)
          del dataDict['inConstructor']
        else:
          raise ApiError("""%s.__init__:
           Cannot pass in explicit serial if not reading""" % self.qualifiedName
           + ": %s:%s" % (parent, 'ccp.molecule.LabeledMolecule.MolLabel')
          )

      if (notIsReading):
        childrenDict = parent.__dict__.get('molLabels')
        objKey = dataDict.get('serial')
        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['serial'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notOverride):
        self.checkValid()

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for ccp.molecule.LabeledMolecule.MolLabel:
       determines 
    cascading deletes to follow from delete of object.
       *Implementation 
    function* - should be called only by API delete function.
    """
    dataDict = self.__dict__
    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    molLabelFractions = dataDict.get('molLabelFractions')
    for molLabelFraction in molLabelFractions:
      if (not (molLabelFraction in objsToBeDeleted)):
        objsToBeDeleted.add(molLabelFraction)
        objsToBeChecked.append(molLabelFraction)

    resLabels = dataDict.get('resLabels').values()
    for resLabel in resLabels:
      if (not (resLabel in objsToBeDeleted)):
        objsToBeDeleted.add(resLabel)
        objsToBeChecked.append(resLabel)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for ccp.molecule.LabeledMolecule.MolLabel:   deletes
    objects
    *Implementation function* - will CORRUPT DATA if called outside 
    the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    for averageLabeledMixture in dataDict.get('averageLabeledMixtures'):
      if (not (averageLabeledMixture in objsToBeDeleted)):
        averageLabeledMixture.__dict__['averageComposition'] = None

    labeledMolecule = dataDict.get('labeledMolecule')
    if (not (labeledMolecule in objsToBeDeleted)):
      objKey = dataDict.get('serial')
      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = labeledMolecule.__dict__.get('molLabels')
        if (self is dd.get(objKey)):
          del dd[objKey]

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData
  
  def addAverageLabeledMixture(self, value):
    """
    Add for ccp.molecule.LabeledMolecule.MolLabel.averageLabeledMixtures
    """
    dataDict = self.__dict__
    if (not isinstance(value, LabeledMixture)):
      raise ApiError("""%s.addAverageLabeledMixture:
       value is not of class ccp.molecule.LabeledMolecule.LabeledMixture""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('averageLabeledMixtures')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.addAverageLabeledMixture:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.addAverageLabeledMixture:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.addAverageLabeledMixture:
       called with deleted value""" % self.qualifiedName
      )

    if (value in currentValues):
      raise ApiError("""%s.addAverageLabeledMixture:
       value is in list already""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.addAverageLabeledMixture:
           Link averageLabeledMixtures between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    oldSelf = value.__dict__.get('averageComposition')
    if (oldSelf is not None):
      siblingValues = oldSelf.__dict__.get('averageLabeledMixtures')
      siblingValues.remove(value)

    value.__dict__['averageComposition'] = self
    currentValues.add(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('addAverageLabeledMixture')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def checkAllValid(self, complete=False):
    """
    CheckAllValid for ccp.molecule.LabeledMolecule.MolLabel
    """
    dataDict = self.__dict__
    self.checkValid(complete)
    values = dataDict.get('resLabels').values()
    for value in values:
      value.checkAllValid(complete)

  def checkValid(self, complete=False):
    """
    CheckValid for ccp.molecule.LabeledMolecule.MolLabel
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      objKey = dataDict.get('serial')
      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('labeledMolecule')
        dd = value.__dict__.get('molLabels')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'labeledMolecule' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      # check attributes
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('serial')
      if (value is None):
        raise ApiError("""%s.checkValid: serial:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.checkValid: serial:
         memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      values = dataDict.get('averageLabeledMixtures')
      for value in values:
        if (not isinstance(value, LabeledMixture)):
          raise ApiError("""%s.checkValid: averageLabeledMixtures:
           value is not of class ccp.molecule.LabeledMolecule.LabeledMixture""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('averageComposition')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: averageLabeledMixtures:
           non-reciprocal link averageLabeledMixtures from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: averageLabeledMixtures:
           Link averageLabeledMixtures between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('labeledMolecule')
      if (not isinstance(value, LabeledMolecule)):
        raise ApiError("""%s.checkValid: labeledMolecule:
         value is not of class ccp.molecule.LabeledMolecule.LabeledMolecule""" % self.qualifiedName
         + ": %s" % (value,)
        )

      values = dataDict.get('molLabelFractions')
      for value in values:
        if (not isinstance(value, MolLabelFraction)):
          raise ApiError("""%s.checkValid: molLabelFractions:
           value is not of class ccp.molecule.LabeledMolecule.MolLabelFraction""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('molLabel')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: molLabelFractions:
           non-reciprocal link molLabelFractions from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject')
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: molLabelFractions:
           Link molLabelFractions between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      values = dataDict.get('resLabels').values()
      for value in values:
        if (not isinstance(value, ResLabel)):
          raise ApiError("""%s.checkValid: resLabels:
           value is not of class ccp.molecule.LabeledMolecule.ResLabel""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('molLabel')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: resLabels:
           non-reciprocal link resLabels from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

    # check explicit class constraints
    # check attributes
    values = dataDict.get('applicationData')
    for value in values:
      value.checkAllValid(complete)

    # check roles
    value = dataDict.get('access')
    values = dataDict.get('averageLabeledMixtures')
    value = dataDict.get('labeledMolecule')
    if (value is None):
      raise ApiError("""%s.checkValid: labeledMolecule:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    values = dataDict.get('molLabelFractions')
    values = dataDict.get('resLabels').values()

  delete = memops.api.Implementation.DataObject.delete

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData
  
  def findAllAverageLabeledMixtures(self, **conditions):
    """
    FindAll for ccp.molecule.LabeledMolecule.MolLabel.averageLabeledMixtures
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('averageLabeledMixtures')
      result = set(currentValues)

    else:
      currentValues = dataDict.get('averageLabeledMixtures')
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('name', 'serial', 'access', 'averageComposition', 'labeledMolecule',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllMolLabelFractions(self, **conditions):
    """
    FindAll for ccp.molecule.LabeledMolecule.MolLabel.molLabelFractions
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('molLabelFractions')
      result = set(currentValues)

    else:
      currentValues = dataDict.get('molLabelFractions')
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('weight', 'access', 'labeledMixture', 'molLabel',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllResLabels(self, **conditions):
    """
    FindAll for ccp.molecule.LabeledMolecule.MolLabel.resLabels
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('resLabels').values()
      result = set(currentValues)

    else:
      currentValues = dataDict.get('resLabels').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('resId', 'access', 'molLabel',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData
  
  def findFirstAverageLabeledMixture(self, **conditions):
    """
    FindFirst for
    ccp.molecule.LabeledMolecule.MolLabel.averageLabeledMixtures
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('averageLabeledMixtures')
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      currentValues = dataDict.get('averageLabeledMixtures')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('name', 'serial', 'access', 'averageComposition', 'labeledMolecule',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstMolLabelFraction(self, **conditions):
    """
    FindFirst for ccp.molecule.LabeledMolecule.MolLabel.molLabelFractions
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('molLabelFractions')
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      currentValues = dataDict.get('molLabelFractions')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('weight', 'access', 'labeledMixture', 'molLabel',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstResLabel(self, **conditions):
    """
    FindFirst for ccp.molecule.LabeledMolecule.MolLabel.resLabels
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('resLabels').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      objKey = conditions.get('resId')
      if (objKey is not None):
        result = dataDict.get('resLabels').get(objKey)

        if (nConditions <= 1):
          return result

        elif (result is None):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        currentValues = dataDict.get('resLabels').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('resId', 'access', 'molLabel',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def get(self, name):
    """
    GetAttr for ccp.molecule.LabeledMolecule.MolLabel
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getAverageLabeledMixtures(self):
    """
    Get for ccp.molecule.LabeledMolecule.MolLabel.averageLabeledMixtures
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('averageLabeledMixtures')
    result = frozenset(tempVar)
    return result
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccp.molecule.LabeledMolecule.MolLabel
    """

    result = None
    if (startObj.__class__.__name__ == 'MemopsRoot'):
      if (2 != len(fullKey)):
        raise ApiError("""'ccp.molecule.LabeledMolecule.MolLabel'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj0 = startObj
      objKey = fullKey[0]
      obj1 = obj0.__dict__.get('labeledMolecules').get(objKey)
      if (obj1 is None):
        obj0.refreshTopObjects('ccp.molecule.LabeledMolecule')
        obj1 = obj0.__dict__.get('labeledMolecules').get(objKey)

    else:
      if (1 != len(fullKey)):
        raise ApiError("""'ccp.molecule.LabeledMolecule.MolLabel'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj1 = startObj

    if (obj1 is not None):
      if (not (obj1.__dict__.get('isLoaded'))):
        obj1.load()

      objKey = fullKey[-1]
      obj2 = obj1.__dict__.get('molLabels').get(objKey)
      result = obj2

    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation

  getClassName = memops.api.Implementation.ComplexDataType.getClassName

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames
  
  def getFullKey(self, useGuid=False):
    """
    GetFullKey for ccp.molecule.LabeledMolecule.MolLabel
    """
    dataDict = self.__dict__
    result = list()

    obj1 = dataDict.get('labeledMolecule')

    if (useGuid):
      result.append(obj1.__dict__.get('guid'))
    else:
      result.append(obj1.__dict__.get('name'))

    result.append(dataDict.get('serial'))

    return result

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted
  
  def getLabeledMolecule(self):
    """
    Get for ccp.molecule.LabeledMolecule.MolLabel.labeledMolecule
    """
    dataDict = self.__dict__
    result = dataDict.get('labeledMolecule')
    return result
  
  def getLocalKey(self):
    """
    GetLocalKey for ccp.molecule.LabeledMolecule.MolLabel
    """
    dataDict = self.__dict__
    result = dataDict.get('serial')
    return result

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass
  
  def getMolLabelFractions(self):
    """
    Get for ccp.molecule.LabeledMolecule.MolLabel.molLabelFractions
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('molLabelFractions')
    result = frozenset(tempVar)
    return result

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName
  
  def getParent(self):
    """
    Get for ccp.molecule.LabeledMolecule.MolLabel.parent
    """
    dataDict = self.__dict__
    result = dataDict.get('labeledMolecule')
    return result

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName
  
  def getResLabels(self):
    """
    Get for ccp.molecule.LabeledMolecule.MolLabel.resLabels
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('resLabels').values()
    result = frozenset(tempVar)
    return result

  getRoot = memops.api.Implementation.MemopsObject.getRoot
  
  def getSerial(self):
    """
    Get for ccp.molecule.LabeledMolecule.MolLabel.serial
    """
    dataDict = self.__dict__
    result = dataDict.get('serial')
    return result

  getTopObject = memops.api.Implementation.DataObject.getTopObject
  
  def newResLabel(self, **attrlinks):
    """
    Factory function to create ccp.molecule.LabeledMolecule.ResLabel
    """
    return ResLabel(self, **attrlinks)

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData
  
  def removeAverageLabeledMixture(self, value):
    """
    Remove for ccp.molecule.LabeledMolecule.MolLabel.averageLabeledMixtures
    """
    dataDict = self.__dict__
    if (not isinstance(value, LabeledMixture)):
      raise ApiError("""%s.removeAverageLabeledMixture:
       value is not of class ccp.molecule.LabeledMolecule.LabeledMixture""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('averageLabeledMixtures')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.removeAverageLabeledMixture:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.removeAverageLabeledMixture:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.removeAverageLabeledMixture:
       called with deleted value""" % self.qualifiedName
      )

    if (not (value in currentValues)):
      raise ApiError("""%s.removeAverageLabeledMixture:
       value not in list""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      pass

    value.__dict__['averageComposition'] = None
    currentValues.remove(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('removeAverageLabeledMixture')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def set(self, name, value):
    """
    SetAttr for ccp.molecule.LabeledMolecule.MolLabel
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData
  
  def setAverageLabeledMixtures(self, values):
    """
    Set for ccp.molecule.LabeledMolecule.MolLabel.averageLabeledMixtures
    """
    dataDict = self.__dict__
    xx = values
    values = set(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setAverageLabeledMixtures:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      if (not isinstance(value, LabeledMixture)):
        raise ApiError("""%s.setAverageLabeledMixtures:
         value is not of class ccp.molecule.LabeledMolecule.LabeledMixture""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('averageLabeledMixtures')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setAverageLabeledMixtures:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setAverageLabeledMixtures:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setAverageLabeledMixtures:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      xx1 = dataDict.get('topObject')
      for value in values:
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setAverageLabeledMixtures:
           Link averageLabeledMixtures between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    for cv in currentValues:
      if (not (cv in values)):
        cv.__dict__['averageComposition'] = None

    for cv in values:
      if (not (cv in currentValues)):
        oldSelf = cv.__dict__.get('averageComposition')
        if (oldSelf is not None):
          vv = oldSelf.__dict__.get('averageLabeledMixtures')
          vv.remove(cv)

      cv.__dict__['averageComposition'] = self

    dataDict['averageLabeledMixtures'] = values
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setAverageLabeledMixtures')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setMolLabelFractions(self, values):
    """
    Set for ccp.molecule.LabeledMolecule.MolLabel.molLabelFractions
    """
    dataDict = self.__dict__
    xx = values
    values = set(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setMolLabelFractions:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      if (not isinstance(value, MolLabelFraction)):
        raise ApiError("""%s.setMolLabelFractions:
         value is not of class ccp.molecule.LabeledMolecule.MolLabelFraction""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('molLabelFractions')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setMolLabelFractions:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setMolLabelFractions:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setMolLabelFractions:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      for cv in currentValues:
        if (not (cv in values)):
          raise ApiError("""%s.setMolLabelFractions:
           locard molLabel: cannot set because some of current values not in values""" % self.qualifiedName
           + ": %s" % (self,)
          )

      xx1 = dataDict.get('topObject')
      for value in values:
        yy1 = value.__dict__.get('topObject')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setMolLabelFractions:
           Link molLabelFractions between objects from separate partitions
           - memops.Implementation.TopObject does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    for cv in values:
      cv.__dict__['molLabel'] = self

    dataDict['molLabelFractions'] = values
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setMolLabelFractions')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setSerial(self, value):
    """
    Set for ccp.molecule.LabeledMolecule.MolLabel.serial
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Int.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Int.create(value)
    else:
      raise ApiError("""%s.setSerial:
       memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('serial')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setSerial:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setSerial:
         cannot set serial, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setSerial:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    parent = dataDict.get('labeledMolecule')
    oldSerial = parent.__dict__.get('_serialDict').get('molLabels')
    if (value < 0):
      value = (oldSerial + 1)
      parent.__dict__.get('_serialDict')['molLabels'] = value
    elif (value > oldSerial):
      parent.__dict__.get('_serialDict')['molLabels'] = value

    dataDict['serial'] = value

    # doNotifies
  
  def sortedAverageLabeledMixtures(self):
    """
    Sorted for ccp.molecule.LabeledMolecule.MolLabel.averageLabeledMixtures
    """
    dataDict = self.__dict__
    ll = dataDict.get('averageLabeledMixtures')
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result
  
  def sortedMolLabelFractions(self):
    """
    Sorted for ccp.molecule.LabeledMolecule.MolLabel.molLabelFractions
    """
    dataDict = self.__dict__
    ll = dataDict.get('molLabelFractions')
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result
  
  def sortedResLabels(self):
    """
    Sorted for ccp.molecule.LabeledMolecule.MolLabel.resLabels
    """
    dataDict = self.__dict__
    sortdd = dataDict.get('resLabels')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  applicationData = memops.api.Implementation.DataObject.applicationData

  className = memops.api.Implementation.ComplexDataType.className

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted

  metaclass = memops.api.Implementation.ComplexDataType.metaclass

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName
  
  serial = property(getSerial, setSerial, None,
  r"""A MolLabel describes a single distribution of isotope fractions. Complex 
  correlated labeling patterns may be described as mixtures of MolLabels.
  """)

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess
  
  averageLabeledMixtures = property(getAverageLabeledMixtures, setAverageLabeledMixtures, None,
  r"""LabeledMixtures that have MolLabel as their averaged composition
  """)
  
  labeledMolecule = property(getLabeledMolecule,  None, None,
  r"""parent link
  """)
  
  molLabelFractions = property(getMolLabelFractions, setMolLabelFractions, None,
  r"""MolLabelFractions that involve MolLabel
  """)
  
  parent = property(getParent, None, None,
  r"""link to parent object - synonym for labeledMolecule
  """)
  
  resLabels = property(getResLabels,  None, None,
  r"""child link to class ResLabel
  """)

  root = memops.api.Implementation.MemopsObject.root

  topObject = memops.api.Implementation.DataObject.topObject

###############################################################################
class MolLabelFraction(memops.api.Implementation.DataObject):
  r"""Describes the relative abundance of a given MolLabel in a given 
LabeledMixture (association class).
  """
  #   from data model element ccp.molecule.LabeledMolecule.MolLabelFraction revision ?
  _metaclass = metaPackage.getElement('MolLabelFraction')
  _packageName = 'ccp.molecule.LabeledMolecule'
  _packageShortName = 'LMOL'
  _fieldNames = ('applicationData', 'className', 'fieldNames', 'inConstructor', 'isDeleted', 'metaclass', 'packageName', 'packageShortName', 'qualifiedName', 'weight', 'access', 'activeAccess', 'labeledMixture', 'molLabel', 'parent', 'root', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for ccp.molecule.LabeledMolecule.MolLabelFraction
    """
    dataDict = self.__dict__
    dataDict['labeledMixture'] = parent
    if (not isinstance(parent, LabeledMixture)):
      raise ApiError("""%s.__init__:
       value is not of class ccp.molecule.LabeledMolecule.LabeledMixture""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = parent.__dict__.get('topObject')
    dataDict['topObject'] = topObject

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    if (notIsReading):
      if (not (topObject.__dict__.get('isModifiable'))):
        raise ApiError("""%s.__init__:
         Storage not modifiable""" % self.qualifiedName
         + ": %s" % (topObject,)
        )

    try:

      dataDict['applicationData'] = list()
      dataDict['weight'] = 1.0
      dataDict['access'] = None
      dataDict['molLabel'] = None

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in ccp.molecule.LabeledMolecule.MolLabelFraction.__init__"
        del dataDict['inConstructor']
        raise

      if (notIsReading):
        childrenDict = parent.__dict__.get('molLabelFractions')
        objKey = dataDict.get('molLabel')
        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['molLabel'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notOverride):
        self.checkValid()

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for ccp.molecule.LabeledMolecule.MolLabelFraction:
       
    determines cascading deletes to follow from delete of object.
       
    *Implementation function* - should be called only by API delete 
    function.
    """
    dataDict = self.__dict__
    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for ccp.molecule.LabeledMolecule.MolLabelFraction:
    deletes objects
    *Implementation function* - will CORRUPT DATA if called 
    outside the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    molLabel = dataDict.get('molLabel')
    if ((molLabel is not None and not (molLabel in objsToBeDeleted))):
      molLabelFractions = molLabel.__dict__.get('molLabelFractions')
      molLabelFractions.remove(self)

    labeledMixture = dataDict.get('labeledMixture')
    if (not (labeledMixture in objsToBeDeleted)):
      objKey = dataDict.get('molLabel')
      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = labeledMixture.__dict__.get('molLabelFractions')
        if (self is dd.get(objKey)):
          del dd[objKey]

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData
  
  def checkAllValid(self, complete=False):
    """
    CheckAllValid for ccp.molecule.LabeledMolecule.MolLabelFraction
    """
    dataDict = self.__dict__
    self.checkValid(complete)
  
  def checkValid(self, complete=False):
    """
    CheckValid for ccp.molecule.LabeledMolecule.MolLabelFraction
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      objKey = dataDict.get('molLabel')
      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('labeledMixture')
        dd = value.__dict__.get('molLabelFractions')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'labeledMixture' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      # check attributes
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('weight')
      if (isinstance(value, memops.api.Implementation.Float.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Float.create(value)
      else:
        raise ApiError("""%s.checkValid: weight:
         memops.Implementation.NonNegativeFloat input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (0.0 <= value)):
        raise ApiError("""%s.checkValid: weight:
         NonNegativeFloat constraint float_value_ge_0 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value - value == 0.0)):
        raise ApiError("""%s.checkValid: weight:
         NonNegativeFloat constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('labeledMixture')
      if (not isinstance(value, LabeledMixture)):
        raise ApiError("""%s.checkValid: labeledMixture:
         value is not of class ccp.molecule.LabeledMolecule.LabeledMixture""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('molLabel')
      if (not isinstance(value, MolLabel)):
        raise ApiError("""%s.checkValid: molLabel:
         value is not of class ccp.molecule.LabeledMolecule.MolLabel""" % self.qualifiedName
         + ": %s" % (value,)
        )

      oldSelves = value.__dict__.get('molLabelFractions')
      if (not (self in oldSelves)):
        raise ApiError("""%s.checkValid: molLabel:
         non-reciprocal link molLabel from object""" % self.qualifiedName
         + ": %s" % (self,)
        )

    # check explicit class constraints
    # check attributes
    values = dataDict.get('applicationData')
    for value in values:
      value.checkAllValid(complete)

    value = dataDict.get('weight')
    if (value is None):
      raise ApiError("""%s.checkValid: weight:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    # check roles
    value = dataDict.get('access')
    value = dataDict.get('labeledMixture')
    if (value is None):
      raise ApiError("""%s.checkValid: labeledMixture:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('molLabel')
    if (value is None):
      raise ApiError("""%s.checkValid: molLabel:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

  delete = memops.api.Implementation.DataObject.delete

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData
  
  def get(self, name):
    """
    GetAttr for ccp.molecule.LabeledMolecule.MolLabelFraction
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccp.molecule.LabeledMolecule.MolLabelFraction
    """

    result = None
    if (startObj.__class__.__name__ == 'MemopsRoot'):
      if (3 != len(fullKey)):
        raise ApiError("""'ccp.molecule.LabeledMolecule.MolLabelFraction'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj0 = startObj
      objKey = fullKey[0]
      obj1 = obj0.__dict__.get('labeledMolecules').get(objKey)
      if (obj1 is None):
        obj0.refreshTopObjects('ccp.molecule.LabeledMolecule')
        obj1 = obj0.__dict__.get('labeledMolecules').get(objKey)

    else:
      if (2 != len(fullKey)):
        raise ApiError("""'ccp.molecule.LabeledMolecule.MolLabelFraction'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj1 = startObj

    if (obj1 is not None):
      if (not (obj1.__dict__.get('isLoaded'))):
        obj1.load()

      objKey = fullKey[-2]
      obj2 = obj1.__dict__.get('labeledMixtures').get(objKey)

      if (obj2 is not None):
        objKey = fullKey[-1]
        obj3 = obj2.__dict__.get('molLabelFractions').get(objKey)
        result = obj3

    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation

  getClassName = memops.api.Implementation.ComplexDataType.getClassName

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames
  
  def getFullKey(self, useGuid=False):
    """
    GetFullKey for ccp.molecule.LabeledMolecule.MolLabelFraction
    """
    dataDict = self.__dict__
    result = list()

    obj2 = dataDict.get('labeledMixture')
    obj1 = obj2.__dict__.get('labeledMolecule')

    if (useGuid):
      result.append(obj1.__dict__.get('guid'))
    else:
      result.append(obj1.__dict__.get('name'))

    result.append(obj2.__dict__.get('serial'))
    result.append(dataDict.get('molLabel'))

    return result

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted
  
  def getLabeledMixture(self):
    """
    Get for ccp.molecule.LabeledMolecule.MolLabelFraction.labeledMixture
    """
    dataDict = self.__dict__
    result = dataDict.get('labeledMixture')
    return result
  
  def getLocalKey(self):
    """
    GetLocalKey for ccp.molecule.LabeledMolecule.MolLabelFraction
    """
    dataDict = self.__dict__
    result = dataDict.get('molLabel')
    return result

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass
  
  def getMolLabel(self):
    """
    Get for ccp.molecule.LabeledMolecule.MolLabelFraction.molLabel
    """
    dataDict = self.__dict__
    result = dataDict.get('molLabel')
    return result

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName
  
  def getParent(self):
    """
    Get for ccp.molecule.LabeledMolecule.MolLabelFraction.parent
    """
    dataDict = self.__dict__
    result = dataDict.get('labeledMixture')
    return result

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName

  getRoot = memops.api.Implementation.MemopsObject.getRoot

  getTopObject = memops.api.Implementation.DataObject.getTopObject
  
  def getWeight(self):
    """
    Get for ccp.molecule.LabeledMolecule.MolLabelFraction.weight
    """
    dataDict = self.__dict__
    result = dataDict.get('weight')
    return result

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData
  
  def set(self, name, value):
    """
    SetAttr for ccp.molecule.LabeledMolecule.MolLabelFraction
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData
  
  def setMolLabel(self, value):
    """
    Set for ccp.molecule.LabeledMolecule.MolLabelFraction.molLabel
    """
    dataDict = self.__dict__
    if (not isinstance(value, MolLabel)):
      raise ApiError("""%s.setMolLabel:
       value is not of class ccp.molecule.LabeledMolecule.MolLabel""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('molLabel')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setMolLabel:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setMolLabel:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setMolLabel:
         cannot set molLabel, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setMolLabel:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      xx1 = dataDict.get('topObject')
      yy1 = value.__dict__.get('topObject')
      if (not (xx1 is yy1)):
        raise ApiError("""%s.setMolLabel:
         Link molLabel between objects from separate partitions
         - memops.Implementation.TopObject does not match""" % self.qualifiedName
         + ": %s:%s" % (self, value)
        )

    if (currentValue is not None):
      if (notIsReading):
        oldSelves = currentValue.__dict__.get('molLabelFractions')
        oldSelves.remove(self)
      else:
        raise ApiError("""%s.setMolLabel:
         Read link 'molLabel' incompatible with pre-existing link""" % self.qualifiedName
         + ": %s" % (self,)
        )

    if (value is not None):
      newSelves = value.__dict__.get('molLabelFractions')
      newSelves.add(self)

    dataDict['molLabel'] = value

    # doNotifies
  
  def setWeight(self, value):
    """
    Set for ccp.molecule.LabeledMolecule.MolLabelFraction.weight
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Float.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Float.create(value)
    else:
      raise ApiError("""%s.setWeight:
       memops.Implementation.NonNegativeFloat input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (0.0 <= value)):
      raise ApiError("""%s.setWeight:
       NonNegativeFloat constraint float_value_ge_0 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value - value == 0.0)):
      raise ApiError("""%s.setWeight:
       NonNegativeFloat constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('weight')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setWeight:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setWeight:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setWeight:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['weight'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setWeight')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  applicationData = memops.api.Implementation.DataObject.applicationData

  className = memops.api.Implementation.ComplexDataType.className

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted

  metaclass = memops.api.Implementation.ComplexDataType.metaclass

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName
  
  weight = property(getWeight, setWeight, None,
  r"""Relative abundance of MolLabel present in the Mixture
  """)

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess
  
  labeledMixture = property(getLabeledMixture,  None, None,
  r"""parent link
  """)
  
  molLabel = property(getMolLabel, setMolLabel, None,
  r"""MolLabel described by Fraction
  """)
  
  parent = property(getParent, None, None,
  r"""link to parent object - synonym for labeledMixture
  """)

  root = memops.api.Implementation.MemopsObject.root

  topObject = memops.api.Implementation.DataObject.topObject

###############################################################################
class ResLabel(memops.api.Implementation.DataObject):
  r"""Residue labeling pattern. If there are any SingleAtomLabels for a given 
atom, these uniquely determine the isotope composition. Failing that, if 
there are any UniformLabels for a given atom, these uniquely determine 
the isotope composition. Failing that the composition is determined  by 
the ResLabelFractions. 
Note that AtomLabels effectively specify the 
isotope composition one position at a time. Any correlations between the 
labeling patterns of two (or more) Atoms can only be specified with the 
ResLabelFractions.
  """
  #   from data model element ccp.molecule.LabeledMolecule.ResLabel revision ?
  _metaclass = metaPackage.getElement('ResLabel')
  _packageName = 'ccp.molecule.LabeledMolecule'
  _packageShortName = 'LMOL'
  _fieldNames = ('applicationData', 'className', 'fieldNames', 'inConstructor', 'isDeleted', 'metaclass', 'packageName', 'packageShortName', 'qualifiedName', 'resId', 'access', 'activeAccess', 'atomLabels', 'molLabel', 'molResidue', 'parent', 'resLabelFractions', 'root', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for ccp.molecule.LabeledMolecule.ResLabel
    """
    dataDict = self.__dict__
    dataDict['molLabel'] = parent
    if (not isinstance(parent, MolLabel)):
      raise ApiError("""%s.__init__:
       value is not of class ccp.molecule.LabeledMolecule.MolLabel""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = parent.__dict__.get('topObject')
    dataDict['topObject'] = topObject

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    if (notIsReading):
      if (not (topObject.__dict__.get('isModifiable'))):
        raise ApiError("""%s.__init__:
         Storage not modifiable""" % self.qualifiedName
         + ": %s" % (topObject,)
        )

    try:

      dataDict['applicationData'] = list()
      dataDict['resId'] = None
      dataDict['access'] = None
      dataDict['atomLabels'] = {}
      dataDict['resLabelFractions'] = {}

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in ccp.molecule.LabeledMolecule.ResLabel.__init__"
        del dataDict['inConstructor']
        raise

      serialDict = {}
      serialDict['atomLabels'] = 0
      dataDict['_serialDict'] = serialDict

      if (notIsReading):
        childrenDict = parent.__dict__.get('resLabels')
        objKey = dataDict.get('resId')
        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['resId'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notOverride):
        self.checkValid()

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for ccp.molecule.LabeledMolecule.ResLabel:
       determines 
    cascading deletes to follow from delete of object.
       *Implementation 
    function* - should be called only by API delete function.
    """
    dataDict = self.__dict__
    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    atomLabels = dataDict.get('atomLabels').values()
    for atomLabel in atomLabels:
      if (not (atomLabel in objsToBeDeleted)):
        objsToBeDeleted.add(atomLabel)
        objsToBeChecked.append(atomLabel)

    resLabelFractions = dataDict.get('resLabelFractions').values()
    for resLabelFraction in resLabelFractions:
      if (not (resLabelFraction in objsToBeDeleted)):
        objsToBeDeleted.add(resLabelFraction)
        objsToBeChecked.append(resLabelFraction)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for ccp.molecule.LabeledMolecule.ResLabel:   deletes
    objects
    *Implementation function* - will CORRUPT DATA if called outside 
    the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    molLabel = dataDict.get('molLabel')
    if (not (molLabel in objsToBeDeleted)):
      objKey = dataDict.get('resId')
      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = molLabel.__dict__.get('resLabels')
        if (self is dd.get(objKey)):
          del dd[objKey]

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData
  
  def checkAllValid(self, complete=False):
    """
    CheckAllValid for ccp.molecule.LabeledMolecule.ResLabel
    """
    dataDict = self.__dict__
    self.checkValid(complete)
    values = dataDict.get('atomLabels').values()
    for value in values:
      value.checkAllValid(complete)

    values = dataDict.get('resLabelFractions').values()
    for value in values:
      value.checkAllValid(complete)

  def checkValid(self, complete=False):
    """
    CheckValid for ccp.molecule.LabeledMolecule.ResLabel
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      objKey = dataDict.get('resId')
      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('molLabel')
        dd = value.__dict__.get('resLabels')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'molLabel' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      # check attributes
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('resId')
      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.checkValid: resId:
         memops.Implementation.PositiveInt input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value > 0)):
        raise ApiError("""%s.checkValid: resId:
         PositiveInt constraint int_value_gt_0 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      values = dataDict.get('atomLabels').values()
      for value in values:
        if (not isinstance(value, AtomLabel)):
          raise ApiError("""%s.checkValid: atomLabels:
           value is not of class ccp.molecule.LabeledMolecule.AtomLabel""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('resLabel')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: atomLabels:
           non-reciprocal link atomLabels from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      value = dataDict.get('molLabel')
      if (not isinstance(value, MolLabel)):
        raise ApiError("""%s.checkValid: molLabel:
         value is not of class ccp.molecule.LabeledMolecule.MolLabel""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = self.getMolResidue()
      if (value is not None):
        from ccp.api.molecule.Molecule import MolResidue as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: molResidue:
           value is not of class ccp.molecule.Molecule.MolResidue""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: molResidue:
           Link molResidue between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      values = dataDict.get('resLabelFractions').values()
      for value in values:
        if (not isinstance(value, ResLabelFraction)):
          raise ApiError("""%s.checkValid: resLabelFractions:
           value is not of class ccp.molecule.LabeledMolecule.ResLabelFraction""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('resLabel')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: resLabelFractions:
           non-reciprocal link resLabelFractions from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

    # check explicit class constraints
    # check attributes
    values = dataDict.get('applicationData')
    for value in values:
      value.checkAllValid(complete)

    value = dataDict.get('resId')
    if (value is None):
      raise ApiError("""%s.checkValid: resId:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    # check roles
    value = dataDict.get('access')
    values = dataDict.get('atomLabels').values()
    value = dataDict.get('molLabel')
    if (value is None):
      raise ApiError("""%s.checkValid: molLabel:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    values = dataDict.get('resLabelFractions').values()

  delete = memops.api.Implementation.DataObject.delete

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData
  
  def findAllAtomLabels(self, **conditions):
    """
    FindAll for ccp.molecule.LabeledMolecule.ResLabel.atomLabels
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('atomLabels').values()
      result = set(currentValues)

    else:
      currentValues = dataDict.get('atomLabels').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('massNumber', 'serial', 'weight', 'access', 'resLabel',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result
  
  def findAllResLabelFractions(self, **conditions):
    """
    FindAll for ccp.molecule.LabeledMolecule.ResLabel.resLabelFractions
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('resLabelFractions').values()
      result = set(currentValues)

    else:
      currentValues = dataDict.get('resLabelFractions').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('isotopomerSerial', 'schemeName', 'weight', 'access', 'resLabel',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData
  
  def findFirstAtomLabel(self, **conditions):
    """
    FindFirst for ccp.molecule.LabeledMolecule.ResLabel.atomLabels
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('atomLabels').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      objKey = conditions.get('serial')
      if (objKey is not None):
        result = dataDict.get('atomLabels').get(objKey)

        if (nConditions <= 1):
          return result

        elif (result is None):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        currentValues = dataDict.get('atomLabels').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('massNumber', 'serial', 'weight', 'access', 'resLabel',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def findFirstResLabelFraction(self, **conditions):
    """
    FindFirst for ccp.molecule.LabeledMolecule.ResLabel.resLabelFractions
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('resLabelFractions').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      ll = list()
      objKey = conditions.get('schemeName')
      ll.append(objKey)
      if (objKey is not None):
        objKey = conditions.get('isotopomerSerial')
        ll.append(objKey)
        if (objKey is not None):
          objKey = tuple(ll)

      if (objKey is not None):
        result = dataDict.get('resLabelFractions').get(objKey)

        if (nConditions <= 2):
          return result

        elif (result is None):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        currentValues = dataDict.get('resLabelFractions').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('isotopomerSerial', 'schemeName', 'weight', 'access', 'resLabel',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def get(self, name):
    """
    GetAttr for ccp.molecule.LabeledMolecule.ResLabel
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getAtomLabels(self):
    """
    Get for ccp.molecule.LabeledMolecule.ResLabel.atomLabels
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('atomLabels').values()
    result = frozenset(tempVar)
    return result
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccp.molecule.LabeledMolecule.ResLabel
    """

    result = None
    if (startObj.__class__.__name__ == 'MemopsRoot'):
      if (3 != len(fullKey)):
        raise ApiError("""'ccp.molecule.LabeledMolecule.ResLabel'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj0 = startObj
      objKey = fullKey[0]
      obj1 = obj0.__dict__.get('labeledMolecules').get(objKey)
      if (obj1 is None):
        obj0.refreshTopObjects('ccp.molecule.LabeledMolecule')
        obj1 = obj0.__dict__.get('labeledMolecules').get(objKey)

    else:
      if (2 != len(fullKey)):
        raise ApiError("""'ccp.molecule.LabeledMolecule.ResLabel'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj1 = startObj

    if (obj1 is not None):
      if (not (obj1.__dict__.get('isLoaded'))):
        obj1.load()

      objKey = fullKey[-2]
      obj2 = obj1.__dict__.get('molLabels').get(objKey)

      if (obj2 is not None):
        objKey = fullKey[-1]
        obj3 = obj2.__dict__.get('resLabels').get(objKey)
        result = obj3

    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation

  getClassName = memops.api.Implementation.ComplexDataType.getClassName

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames
  
  def getFullKey(self, useGuid=False):
    """
    GetFullKey for ccp.molecule.LabeledMolecule.ResLabel
    """
    dataDict = self.__dict__
    result = list()

    obj2 = dataDict.get('molLabel')
    obj1 = obj2.__dict__.get('labeledMolecule')

    if (useGuid):
      result.append(obj1.__dict__.get('guid'))
    else:
      result.append(obj1.__dict__.get('name'))

    result.append(obj2.__dict__.get('serial'))
    result.append(dataDict.get('resId'))

    return result

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted
  
  def getLocalKey(self):
    """
    GetLocalKey for ccp.molecule.LabeledMolecule.ResLabel
    """
    dataDict = self.__dict__
    result = dataDict.get('resId')
    return result

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass
  
  def getMolLabel(self):
    """
    Get for ccp.molecule.LabeledMolecule.ResLabel.molLabel
    """
    dataDict = self.__dict__
    result = dataDict.get('molLabel')
    return result
  
  def getMolResidue(self):
    """
    getter for derived link molResidue
    """
    dataDict = self.__dict__
    cc = ccp.api.molecule.Molecule.MolResidue
    result = cc.getByKey(self.root, (self.topObject.name, self.resId))
    return result

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName
  
  def getParent(self):
    """
    Get for ccp.molecule.LabeledMolecule.ResLabel.parent
    """
    dataDict = self.__dict__
    result = dataDict.get('molLabel')
    return result

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName
  
  def getResId(self):
    """
    Get for ccp.molecule.LabeledMolecule.ResLabel.resId
    """
    dataDict = self.__dict__
    result = dataDict.get('resId')
    return result
  
  def getResLabelFractions(self):
    """
    Get for ccp.molecule.LabeledMolecule.ResLabel.resLabelFractions
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('resLabelFractions').values()
    result = frozenset(tempVar)
    return result

  getRoot = memops.api.Implementation.MemopsObject.getRoot

  getTopObject = memops.api.Implementation.DataObject.getTopObject
  
  def newResLabelFraction(self, **attrlinks):
    """
    Factory function to create ccp.molecule.LabeledMolecule.ResLabelFraction
    """
    return ResLabelFraction(self, **attrlinks)
  
  def newSingleAtomLabel(self, **attrlinks):
    """
    Factory function to create ccp.molecule.LabeledMolecule.SingleAtomLabel
    """
    return SingleAtomLabel(self, **attrlinks)
  
  def newUniformAtomLabel(self, **attrlinks):
    """
    Factory function to create ccp.molecule.LabeledMolecule.UniformAtomLabel
    """
    return UniformAtomLabel(self, **attrlinks)

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData
  
  def set(self, name, value):
    """
    SetAttr for ccp.molecule.LabeledMolecule.ResLabel
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData
  
  def setResId(self, value):
    """
    Set for ccp.molecule.LabeledMolecule.ResLabel.resId
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Int.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Int.create(value)
    else:
      raise ApiError("""%s.setResId:
       memops.Implementation.PositiveInt input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value > 0)):
      raise ApiError("""%s.setResId:
       PositiveInt constraint int_value_gt_0 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('resId')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setResId:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setResId:
         cannot set resId, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setResId:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['resId'] = value

    # doNotifies
  
  def sortedAtomLabels(self):
    """
    Sorted for ccp.molecule.LabeledMolecule.ResLabel.atomLabels
    """
    dataDict = self.__dict__
    sortdd = dataDict.get('atomLabels')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result
  
  def sortedResLabelFractions(self):
    """
    Sorted for ccp.molecule.LabeledMolecule.ResLabel.resLabelFractions
    """
    dataDict = self.__dict__
    sortdd = dataDict.get('resLabelFractions')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  applicationData = memops.api.Implementation.DataObject.applicationData

  className = memops.api.Implementation.ComplexDataType.className

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted

  metaclass = memops.api.Implementation.ComplexDataType.metaclass

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName
  
  resId = property(getResId, setResId, None,
  r"""resId for corresponding MolResidue
  """)

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess
  
  atomLabels = property(getAtomLabels,  None, None,
  r"""child link to class AtomLabel
  """)
  
  molLabel = property(getMolLabel,  None, None,
  r"""parent link
  """)
  
  molResidue = property(getMolResidue, None, None,
  r"""molResidues whose labeling is described
  """)
  
  parent = property(getParent, None, None,
  r"""link to parent object - synonym for molLabel
  """)
  
  resLabelFractions = property(getResLabelFractions,  None, None,
  r"""child link
  """)

  root = memops.api.Implementation.MemopsObject.root

  topObject = memops.api.Implementation.DataObject.topObject

###############################################################################
class ResLabelFraction(memops.api.Implementation.DataObject):
  r"""Fraction of Residue labeling that follows a given labeling scheme
  """
  #   from data model element ccp.molecule.LabeledMolecule.ResLabelFraction revision ?
  _metaclass = metaPackage.getElement('ResLabelFraction')
  _packageName = 'ccp.molecule.LabeledMolecule'
  _packageShortName = 'LMOL'
  _fieldNames = ('applicationData', 'className', 'fieldNames', 'inConstructor', 'isDeleted', 'isotopomerSerial', 'metaclass', 'packageName', 'packageShortName', 'qualifiedName', 'schemeName', 'weight', 'access', 'activeAccess', 'isotopomers', 'labelingScheme', 'parent', 'resLabel', 'root', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for ccp.molecule.LabeledMolecule.ResLabelFraction
    """
    dataDict = self.__dict__
    dataDict['resLabel'] = parent
    if (not isinstance(parent, ResLabel)):
      raise ApiError("""%s.__init__:
       value is not of class ccp.molecule.LabeledMolecule.ResLabel""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = parent.__dict__.get('topObject')
    dataDict['topObject'] = topObject

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    if (notIsReading):
      if (not (topObject.__dict__.get('isModifiable'))):
        raise ApiError("""%s.__init__:
         Storage not modifiable""" % self.qualifiedName
         + ": %s" % (topObject,)
        )

    try:

      dataDict['applicationData'] = list()
      dataDict['isotopomerSerial'] = 0
      dataDict['schemeName'] = 'NaturalAbundance'
      dataDict['weight'] = 1.0
      dataDict['access'] = None

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in ccp.molecule.LabeledMolecule.ResLabelFraction.__init__"
        del dataDict['inConstructor']
        raise

      if (notIsReading):
        childrenDict = parent.__dict__.get('resLabelFractions')
        ll = list()
        objKey = dataDict.get('schemeName')
        ll.append(objKey)
        if (objKey is not None):
          objKey = dataDict.get('isotopomerSerial')
          ll.append(objKey)
          if (objKey is not None):
            objKey = tuple(ll)

        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['schemeName', 'isotopomerSerial'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notOverride):
        self.checkValid()

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for ccp.molecule.LabeledMolecule.ResLabelFraction:
       
    determines cascading deletes to follow from delete of object.
       
    *Implementation function* - should be called only by API delete 
    function.
    """
    dataDict = self.__dict__
    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for ccp.molecule.LabeledMolecule.ResLabelFraction:
    deletes objects
    *Implementation function* - will CORRUPT DATA if called 
    outside the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    resLabel = dataDict.get('resLabel')
    if (not (resLabel in objsToBeDeleted)):
      ll = list()
      objKey = dataDict.get('schemeName')
      ll.append(objKey)
      if (objKey is not None):
        objKey = dataDict.get('isotopomerSerial')
        ll.append(objKey)
        if (objKey is not None):
          objKey = tuple(ll)

      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = resLabel.__dict__.get('resLabelFractions')
        if (self is dd.get(objKey)):
          del dd[objKey]

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData
  
  def checkAllValid(self, complete=False):
    """
    CheckAllValid for ccp.molecule.LabeledMolecule.ResLabelFraction
    """
    dataDict = self.__dict__
    self.checkValid(complete)
  
  def checkValid(self, complete=False):
    """
    CheckValid for ccp.molecule.LabeledMolecule.ResLabelFraction
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      ll = list()
      objKey = dataDict.get('schemeName')
      ll.append(objKey)
      if (objKey is not None):
        objKey = dataDict.get('isotopomerSerial')
        ll.append(objKey)
        if (objKey is not None):
          objKey = tuple(ll)

      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('resLabel')
        dd = value.__dict__.get('resLabelFractions')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'resLabel' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      # check attributes
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('isotopomerSerial')
      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.checkValid: isotopomerSerial:
         memops.Implementation.NonNegativeInt input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value >= 0)):
        raise ApiError("""%s.checkValid: isotopomerSerial:
         NonNegativeInt constraint int_value_ge_0 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('schemeName')
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: schemeName:
         memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 32):
        raise ApiError("""%s.checkValid: schemeName:
         memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: schemeName:
         memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.checkValid: schemeName:
         Word constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('weight')
      if (isinstance(value, memops.api.Implementation.Float.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Float.create(value)
      else:
        raise ApiError("""%s.checkValid: weight:
         memops.Implementation.NonNegativeFloat input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (0.0 <= value)):
        raise ApiError("""%s.checkValid: weight:
         NonNegativeFloat constraint float_value_ge_0 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value - value == 0.0)):
        raise ApiError("""%s.checkValid: weight:
         NonNegativeFloat constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      values = self.getIsotopomers()
      for value in values:
        from ccp.api.molecule.ChemCompLabel import Isotopomer as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: isotopomers:
           value is not of class ccp.molecule.ChemCompLabel.Isotopomer""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: isotopomers:
           Link isotopomers between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getLabelingScheme()
      if (value is not None):
        from ccp.api.molecule.ChemCompLabel import LabelingScheme as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: labelingScheme:
           value is not of class ccp.molecule.ChemCompLabel.LabelingScheme""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: labelingScheme:
           Link labelingScheme between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('resLabel')
      if (not isinstance(value, ResLabel)):
        raise ApiError("""%s.checkValid: resLabel:
         value is not of class ccp.molecule.LabeledMolecule.ResLabel""" % self.qualifiedName
         + ": %s" % (value,)
        )

    # check explicit class constraints
    # check attributes
    values = dataDict.get('applicationData')
    for value in values:
      value.checkAllValid(complete)

    value = dataDict.get('isotopomerSerial')
    if (value is None):
      raise ApiError("""%s.checkValid: isotopomerSerial:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('schemeName')
    if (value is None):
      raise ApiError("""%s.checkValid: schemeName:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('weight')
    if (value is None):
      raise ApiError("""%s.checkValid: weight:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    # check roles
    value = dataDict.get('access')
    value = dataDict.get('resLabel')
    if (value is None):
      raise ApiError("""%s.checkValid: resLabel:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

  delete = memops.api.Implementation.DataObject.delete

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData
  
  def findAllIsotopomers(self, **conditions):
    """
    FindAll for ccp.molecule.LabeledMolecule.ResLabelFraction.isotopomers
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = self.getIsotopomers()
      result = set(currentValues)

    else:
      currentValues = self.getIsotopomers()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('serial', 'weight', 'access', 'chemCompLabel',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData
  
  def findFirstIsotopomer(self, **conditions):
    """
    FindFirst for ccp.molecule.LabeledMolecule.ResLabelFraction.isotopomers
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = self.getIsotopomers()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      currentValues = self.getIsotopomers()
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('serial', 'weight', 'access', 'chemCompLabel',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def get(self, name):
    """
    GetAttr for ccp.molecule.LabeledMolecule.ResLabelFraction
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccp.molecule.LabeledMolecule.ResLabelFraction
    """

    result = None
    if (startObj.__class__.__name__ == 'MemopsRoot'):
      if (5 != len(fullKey)):
        raise ApiError("""'ccp.molecule.LabeledMolecule.ResLabelFraction'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj0 = startObj
      objKey = fullKey[0]
      obj1 = obj0.__dict__.get('labeledMolecules').get(objKey)
      if (obj1 is None):
        obj0.refreshTopObjects('ccp.molecule.LabeledMolecule')
        obj1 = obj0.__dict__.get('labeledMolecules').get(objKey)

    else:
      if (4 != len(fullKey)):
        raise ApiError("""'ccp.molecule.LabeledMolecule.ResLabelFraction'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj1 = startObj

    if (obj1 is not None):
      if (not (obj1.__dict__.get('isLoaded'))):
        obj1.load()

      objKey = fullKey[-4]
      obj2 = obj1.__dict__.get('molLabels').get(objKey)

      if (obj2 is not None):
        objKey = fullKey[-3]
        obj3 = obj2.__dict__.get('resLabels').get(objKey)

        if (obj3 is not None):
          ll = list()
          objKey = fullKey[-2]
          ll.append(objKey)
          if (objKey is not None):
            objKey = fullKey[-1]
            ll.append(objKey)
            if (objKey is not None):
              objKey = tuple(ll)

          obj4 = obj3.__dict__.get('resLabelFractions').get(objKey)
          result = obj4

    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation

  getClassName = memops.api.Implementation.ComplexDataType.getClassName

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames
  
  def getFullKey(self, useGuid=False):
    """
    GetFullKey for ccp.molecule.LabeledMolecule.ResLabelFraction
    """
    dataDict = self.__dict__
    result = list()

    obj3 = dataDict.get('resLabel')
    obj2 = obj3.__dict__.get('molLabel')
    obj1 = obj2.__dict__.get('labeledMolecule')

    if (useGuid):
      result.append(obj1.__dict__.get('guid'))
    else:
      result.append(obj1.__dict__.get('name'))

    result.append(obj2.__dict__.get('serial'))
    result.append(obj3.__dict__.get('resId'))
    result.append(dataDict.get('schemeName'))
    result.append(dataDict.get('isotopomerSerial'))

    return result

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted
  
  def getIsotopomerSerial(self):
    """
    Get for ccp.molecule.LabeledMolecule.ResLabelFraction.isotopomerSerial
    """
    dataDict = self.__dict__
    result = dataDict.get('isotopomerSerial')
    return result
  
  def getIsotopomers(self):
    """
    getter for derived link isotopomers
    """
    dataDict = self.__dict__
    result = ()
    molResidue = self.parent.molResidue
    if molResidue is not None:
      labelingScheme = self.root.findFirstLabelingScheme(name=self.schemeName)
      if labelingScheme is not None:
        chemComp = molResidue.chemComp
        chemCompLabel = labelingScheme.findFirstChemCompLabel(molType=chemComp.molType, ccpCode=chemComp.ccpCode)
        serial = self.isotopomerSerial
        if serial:
          result = frozenset(chemCompLabel.findAllIsotopomers(serial=serial))
        else:
          result = chemCompLabel.isotopomers
    
    return result
  
  def getLabelingScheme(self):
    """
    getter for derived link labelingScheme
    """
    dataDict = self.__dict__
    result = self.root.findFirstLabelingScheme(name=self.schemeName)
    return result
  
  def getLocalKey(self):
    """
    GetLocalKey for ccp.molecule.LabeledMolecule.ResLabelFraction
    """
    dataDict = self.__dict__
    ll = list()
    result = dataDict.get('schemeName')
    ll.append(result)
    if (result is not None):
      result = dataDict.get('isotopomerSerial')
      ll.append(result)
      if (result is not None):
        result = tuple(ll)

    return result

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName
  
  def getParent(self):
    """
    Get for ccp.molecule.LabeledMolecule.ResLabelFraction.parent
    """
    dataDict = self.__dict__
    result = dataDict.get('resLabel')
    return result

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName
  
  def getResLabel(self):
    """
    Get for ccp.molecule.LabeledMolecule.ResLabelFraction.resLabel
    """
    dataDict = self.__dict__
    result = dataDict.get('resLabel')
    return result

  getRoot = memops.api.Implementation.MemopsObject.getRoot
  
  def getSchemeName(self):
    """
    Get for ccp.molecule.LabeledMolecule.ResLabelFraction.schemeName
    """
    dataDict = self.__dict__
    result = dataDict.get('schemeName')
    return result

  getTopObject = memops.api.Implementation.DataObject.getTopObject
  
  def getWeight(self):
    """
    Get for ccp.molecule.LabeledMolecule.ResLabelFraction.weight
    """
    dataDict = self.__dict__
    result = dataDict.get('weight')
    return result

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData
  
  def set(self, name, value):
    """
    SetAttr for ccp.molecule.LabeledMolecule.ResLabelFraction
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData
  
  def setIsotopomerSerial(self, value):
    """
    Set for ccp.molecule.LabeledMolecule.ResLabelFraction.isotopomerSerial
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Int.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Int.create(value)
    else:
      raise ApiError("""%s.setIsotopomerSerial:
       memops.Implementation.NonNegativeInt input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value >= 0)):
      raise ApiError("""%s.setIsotopomerSerial:
       NonNegativeInt constraint int_value_ge_0 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('isotopomerSerial')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setIsotopomerSerial:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setIsotopomerSerial:
         cannot set isotopomerSerial, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setIsotopomerSerial:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['isotopomerSerial'] = value

    # doNotifies
  
  def setSchemeName(self, value):
    """
    Set for ccp.molecule.LabeledMolecule.ResLabelFraction.schemeName
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.setSchemeName:
       memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 32):
      raise ApiError("""%s.setSchemeName:
       memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.setSchemeName:
       memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.split()) == 1)):
      raise ApiError("""%s.setSchemeName:
       Word constraint contains_no_white_space violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('schemeName')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setSchemeName:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setSchemeName:
         cannot set schemeName, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setSchemeName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['schemeName'] = value

    # doNotifies
  
  def setWeight(self, value):
    """
    Set for ccp.molecule.LabeledMolecule.ResLabelFraction.weight
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.Float.PythonType)):
      pass
    elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
      value = memops.api.Implementation.Float.create(value)
    else:
      raise ApiError("""%s.setWeight:
       memops.Implementation.NonNegativeFloat input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (0.0 <= value)):
      raise ApiError("""%s.setWeight:
       NonNegativeFloat constraint float_value_ge_0 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value - value == 0.0)):
      raise ApiError("""%s.setWeight:
       NonNegativeFloat constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('weight')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setWeight:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setWeight:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setWeight:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['weight'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setWeight')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def sortedIsotopomers(self):
    """
    Sorted for ccp.molecule.LabeledMolecule.ResLabelFraction.isotopomers
    """
    dataDict = self.__dict__
    ll = self.getIsotopomers()
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  applicationData = memops.api.Implementation.DataObject.applicationData

  className = memops.api.Implementation.ComplexDataType.className

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted
  
  isotopomerSerial = property(getIsotopomerSerial, setIsotopomerSerial, None,
  r"""Serial number of Isotopomer within the relevant LabelingScheme. If value 
  is 0 this means that all Isotopomers are used in the relative abundance 
  given in the LabelingScheme. 
  """)

  metaclass = memops.api.Implementation.ComplexDataType.metaclass

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName
  
  schemeName = property(getSchemeName, setSchemeName, None,
  r"""Name of labeling scheme referred to
  """)
  
  weight = property(getWeight, setWeight, None,
  r"""Weight (relative abundance) relative to sister ResLabelFractions. 
  """)

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess
  
  isotopomers = property(getIsotopomers, None, None,
  r"""Isotopomers described by ResLabelFraction
  """)
  
  labelingScheme = property(getLabelingScheme, None, None,
  r"""Labeling Scheme described by ResLabelFraction
  """)
  
  parent = property(getParent, None, None,
  r"""link to parent object - synonym for resLabel
  """)
  
  resLabel = property(getResLabel,  None, None,
  r"""parent link
  """)

  root = memops.api.Implementation.MemopsObject.root

  topObject = memops.api.Implementation.DataObject.topObject

###############################################################################
class UniformAtomLabel(AtomLabel):
  r"""Atom label description valid for all atoms of a given element in a given 
residue, except those attached to any SingleAtomLabel object.
  """
  #   from data model element ccp.molecule.LabeledMolecule.UniformAtomLabel revision ?
  _metaclass = metaPackage.getElement('UniformAtomLabel')
  _packageName = 'ccp.molecule.LabeledMolecule'
  _packageShortName = 'LMOL'
  _fieldNames = ('applicationData', 'className', 'elementName', 'fieldNames', 'inConstructor', 'isDeleted', 'massNumber', 'metaclass', 'packageName', 'packageShortName', 'qualifiedName', 'serial', 'weight', 'access', 'activeAccess', 'parent', 'resLabel', 'root', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for ccp.molecule.LabeledMolecule.UniformAtomLabel
    """
    dataDict = self.__dict__
    dataDict['resLabel'] = parent
    if (not isinstance(parent, ResLabel)):
      raise ApiError("""%s.__init__:
       value is not of class ccp.molecule.LabeledMolecule.ResLabel""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = parent.__dict__.get('topObject')
    dataDict['topObject'] = topObject

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    if (notIsReading):
      if (not (topObject.__dict__.get('isModifiable'))):
        raise ApiError("""%s.__init__:
         Storage not modifiable""" % self.qualifiedName
         + ": %s" % (topObject,)
        )

    try:

      dataDict['applicationData'] = list()
      dataDict['elementName'] = None
      dataDict['massNumber'] = None
      dataDict['serial'] = None
      dataDict['weight'] = 1.0
      dataDict['access'] = None

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in ccp.molecule.LabeledMolecule.UniformAtomLabel.__init__"
        del dataDict['inConstructor']
        raise

      if (notOverride):
        if (dataDict.get('serial') is None):
          dataDict['inConstructor'] = True
          self.setSerial(-1)
          del dataDict['inConstructor']
        else:
          raise ApiError("""%s.__init__:
           Cannot pass in explicit serial if not reading""" % self.qualifiedName
           + ": %s:%s" % (parent, 'ccp.molecule.LabeledMolecule.UniformAtomLabel')
          )

      if (notIsReading):
        childrenDict = parent.__dict__.get('atomLabels')
        objKey = dataDict.get('serial')
        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['serial'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notOverride):
        self.checkValid()

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for ccp.molecule.LabeledMolecule.UniformAtomLabel:
       
    determines cascading deletes to follow from delete of object.
       
    *Implementation function* - should be called only by API delete 
    function.
    """
    dataDict = self.__dict__
    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for ccp.molecule.LabeledMolecule.UniformAtomLabel:
    deletes objects
    *Implementation function* - will CORRUPT DATA if called 
    outside the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    resLabel = dataDict.get('resLabel')
    if (not (resLabel in objsToBeDeleted)):
      objKey = dataDict.get('serial')
      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = resLabel.__dict__.get('atomLabels')
        if (self is dd.get(objKey)):
          del dd[objKey]

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData
  
  def checkAllValid(self, complete=False):
    """
    CheckAllValid for ccp.molecule.LabeledMolecule.UniformAtomLabel
    """
    dataDict = self.__dict__
    self.checkValid(complete)
  
  def checkValid(self, complete=False):
    """
    CheckValid for ccp.molecule.LabeledMolecule.UniformAtomLabel
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      objKey = dataDict.get('serial')
      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('resLabel')
        dd = value.__dict__.get('atomLabels')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'resLabel' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      # check attributes
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('elementName')
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: elementName:
         memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 32):
        raise ApiError("""%s.checkValid: elementName:
         memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: elementName:
         memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.checkValid: elementName:
         Word constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('massNumber')
      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.checkValid: massNumber:
         memops.Implementation.PositiveInt input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value > 0)):
        raise ApiError("""%s.checkValid: massNumber:
         PositiveInt constraint int_value_gt_0 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('serial')
      if (value is None):
        raise ApiError("""%s.checkValid: serial:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.checkValid: serial:
         memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('weight')
      if (isinstance(value, memops.api.Implementation.Float.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Float.create(value)
      else:
        raise ApiError("""%s.checkValid: weight:
         memops.Implementation.NonNegativeFloat input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (0.0 <= value)):
        raise ApiError("""%s.checkValid: weight:
         NonNegativeFloat constraint float_value_ge_0 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value - value == 0.0)):
        raise ApiError("""%s.checkValid: weight:
         NonNegativeFloat constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('resLabel')
      if (not isinstance(value, ResLabel)):
        raise ApiError("""%s.checkValid: resLabel:
         value is not of class ccp.molecule.LabeledMolecule.ResLabel""" % self.qualifiedName
         + ": %s" % (value,)
        )

    # check explicit class constraints
    # check attributes
    values = dataDict.get('applicationData')
    for value in values:
      value.checkAllValid(complete)

    value = dataDict.get('elementName')
    if (value is None):
      raise ApiError("""%s.checkValid: elementName:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('massNumber')
    if (value is None):
      raise ApiError("""%s.checkValid: massNumber:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('weight')
    if (value is None):
      raise ApiError("""%s.checkValid: weight:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    # check roles
    value = dataDict.get('access')
    value = dataDict.get('resLabel')
    if (value is None):
      raise ApiError("""%s.checkValid: resLabel:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

  delete = memops.api.Implementation.DataObject.delete

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData
  
  def get(self, name):
    """
    GetAttr for ccp.molecule.LabeledMolecule.UniformAtomLabel
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccp.molecule.LabeledMolecule.UniformAtomLabel
    """

    result = None
    if (startObj.__class__.__name__ == 'MemopsRoot'):
      if (4 != len(fullKey)):
        raise ApiError("""'ccp.molecule.LabeledMolecule.UniformAtomLabel'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj0 = startObj
      objKey = fullKey[0]
      obj1 = obj0.__dict__.get('labeledMolecules').get(objKey)
      if (obj1 is None):
        obj0.refreshTopObjects('ccp.molecule.LabeledMolecule')
        obj1 = obj0.__dict__.get('labeledMolecules').get(objKey)

    else:
      if (3 != len(fullKey)):
        raise ApiError("""'ccp.molecule.LabeledMolecule.UniformAtomLabel'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj1 = startObj

    if (obj1 is not None):
      if (not (obj1.__dict__.get('isLoaded'))):
        obj1.load()

      objKey = fullKey[-3]
      obj2 = obj1.__dict__.get('molLabels').get(objKey)

      if (obj2 is not None):
        objKey = fullKey[-2]
        obj3 = obj2.__dict__.get('resLabels').get(objKey)

        if (obj3 is not None):
          objKey = fullKey[-1]
          obj4 = obj3.__dict__.get('atomLabels').get(objKey)
          if (isinstance(obj4, UniformAtomLabel)):
            result = obj4

    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation

  getClassName = memops.api.Implementation.ComplexDataType.getClassName
  
  def getElementName(self):
    """
    Get for ccp.molecule.LabeledMolecule.UniformAtomLabel.elementName
    """
    dataDict = self.__dict__
    result = dataDict.get('elementName')
    return result

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames

  getFullKey = AtomLabel.getFullKey

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted

  getLocalKey = AtomLabel.getLocalKey

  getMassNumber = AtomLabel.getMassNumber

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName

  getParent = AtomLabel.getParent

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName

  getResLabel = AtomLabel.getResLabel

  getRoot = memops.api.Implementation.MemopsObject.getRoot

  getSerial = AtomLabel.getSerial

  getTopObject = memops.api.Implementation.DataObject.getTopObject

  getWeight = AtomLabel.getWeight

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData
  
  def set(self, name, value):
    """
    SetAttr for ccp.molecule.LabeledMolecule.UniformAtomLabel
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData
  
  def setElementName(self, value):
    """
    Set for ccp.molecule.LabeledMolecule.UniformAtomLabel.elementName
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.setElementName:
       memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 32):
      raise ApiError("""%s.setElementName:
       memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.setElementName:
       memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.split()) == 1)):
      raise ApiError("""%s.setElementName:
       Word constraint contains_no_white_space violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('elementName')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setElementName:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setElementName:
         cannot set elementName, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setElementName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['elementName'] = value

    # doNotifies

  setMassNumber = AtomLabel.setMassNumber

  setSerial = AtomLabel.setSerial

  setWeight = AtomLabel.setWeight

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  applicationData = memops.api.Implementation.DataObject.applicationData

  className = memops.api.Implementation.ComplexDataType.className
  
  elementName = property(getElementName, setElementName, None,
  r"""Name of element. E.g. 'C', 'Cu'.
  """)

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted

  massNumber = AtomLabel.massNumber

  metaclass = memops.api.Implementation.ComplexDataType.metaclass

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName

  serial = AtomLabel.serial

  weight = AtomLabel.weight

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess

  parent = AtomLabel.parent

  resLabel = AtomLabel.resLabel

  root = memops.api.Implementation.MemopsObject.root

  topObject = memops.api.Implementation.DataObject.topObject

###############################################################################
class SingleAtomLabel(AtomLabel):
  r"""Atom label referring to a single atom. Overrides any UniformAtomLabel 
and ResLabelFraction records present for the same residue ID(s)
  """
  #   from data model element ccp.molecule.LabeledMolecule.SingleAtomLabel revision ?
  _metaclass = metaPackage.getElement('SingleAtomLabel')
  _packageName = 'ccp.molecule.LabeledMolecule'
  _packageShortName = 'LMOL'
  _fieldNames = ('applicationData', 'atomName', 'className', 'fieldNames', 'inConstructor', 'isDeleted', 'massNumber', 'metaclass', 'packageName', 'packageShortName', 'qualifiedName', 'serial', 'weight', 'access', 'activeAccess', 'chemAtom', 'parent', 'resLabel', 'root', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for ccp.molecule.LabeledMolecule.SingleAtomLabel
    """
    dataDict = self.__dict__
    dataDict['resLabel'] = parent
    if (not isinstance(parent, ResLabel)):
      raise ApiError("""%s.__init__:
       value is not of class ccp.molecule.LabeledMolecule.ResLabel""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = parent.__dict__.get('topObject')
    dataDict['topObject'] = topObject

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    if (notIsReading):
      if (not (topObject.__dict__.get('isModifiable'))):
        raise ApiError("""%s.__init__:
         Storage not modifiable""" % self.qualifiedName
         + ": %s" % (topObject,)
        )

    try:

      dataDict['applicationData'] = list()
      dataDict['atomName'] = None
      dataDict['massNumber'] = None
      dataDict['serial'] = None
      dataDict['weight'] = 1.0
      dataDict['access'] = None

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in ccp.molecule.LabeledMolecule.SingleAtomLabel.__init__"
        del dataDict['inConstructor']
        raise

      if (notOverride):
        if (dataDict.get('serial') is None):
          dataDict['inConstructor'] = True
          self.setSerial(-1)
          del dataDict['inConstructor']
        else:
          raise ApiError("""%s.__init__:
           Cannot pass in explicit serial if not reading""" % self.qualifiedName
           + ": %s:%s" % (parent, 'ccp.molecule.LabeledMolecule.SingleAtomLabel')
          )

      if (notIsReading):
        childrenDict = parent.__dict__.get('atomLabels')
        objKey = dataDict.get('serial')
        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['serial'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notOverride):
        self.checkValid()

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for ccp.molecule.LabeledMolecule.SingleAtomLabel:
       
    determines cascading deletes to follow from delete of object.
       
    *Implementation function* - should be called only by API delete 
    function.
    """
    dataDict = self.__dict__
    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for ccp.molecule.LabeledMolecule.SingleAtomLabel:   deletes
    objects
    *Implementation function* - will CORRUPT DATA if called outside 
    the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    resLabel = dataDict.get('resLabel')
    if (not (resLabel in objsToBeDeleted)):
      objKey = dataDict.get('serial')
      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = resLabel.__dict__.get('atomLabels')
        if (self is dd.get(objKey)):
          del dd[objKey]

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData
  
  def checkAllValid(self, complete=False):
    """
    CheckAllValid for ccp.molecule.LabeledMolecule.SingleAtomLabel
    """
    dataDict = self.__dict__
    self.checkValid(complete)
  
  def checkValid(self, complete=False):
    """
    CheckValid for ccp.molecule.LabeledMolecule.SingleAtomLabel
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      objKey = dataDict.get('serial')
      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('resLabel')
        dd = value.__dict__.get('atomLabels')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'resLabel' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      # check attributes
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('atomName')
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: atomName:
         memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 32):
        raise ApiError("""%s.checkValid: atomName:
         memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: atomName:
         memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.checkValid: atomName:
         Word constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('massNumber')
      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.checkValid: massNumber:
         memops.Implementation.PositiveInt input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value > 0)):
        raise ApiError("""%s.checkValid: massNumber:
         PositiveInt constraint int_value_gt_0 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('serial')
      if (value is None):
        raise ApiError("""%s.checkValid: serial:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.Int.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Int.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Int.create(value)
      else:
        raise ApiError("""%s.checkValid: serial:
         memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('weight')
      if (isinstance(value, memops.api.Implementation.Float.PythonType)):
        pass
      elif ([x for x in memops.api.Implementation.Float.compatibleTypes if isinstance(value, x)]):
        value = memops.api.Implementation.Float.create(value)
      else:
        raise ApiError("""%s.checkValid: weight:
         memops.Implementation.NonNegativeFloat input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (0.0 <= value)):
        raise ApiError("""%s.checkValid: weight:
         NonNegativeFloat constraint float_value_ge_0 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value - value == 0.0)):
        raise ApiError("""%s.checkValid: weight:
         NonNegativeFloat constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getChemAtom()
      if (value is None):
        raise ApiError("""%s.checkValid: chemAtom:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      from ccp.api.molecule.ChemComp import ChemAtom as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.checkValid: chemAtom:
         value is not of class ccp.molecule.ChemComp.ChemAtom""" % self.qualifiedName
         + ": %s" % (value,)
        )

      xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
      yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
      if (not (xx1 is yy1)):
        raise ApiError("""%s.checkValid: chemAtom:
         Link chemAtom between objects from separate partitions
         - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
         + ": %s:%s" % (self, value)
        )

      value = dataDict.get('resLabel')
      if (not isinstance(value, ResLabel)):
        raise ApiError("""%s.checkValid: resLabel:
         value is not of class ccp.molecule.LabeledMolecule.ResLabel""" % self.qualifiedName
         + ": %s" % (value,)
        )

    # check explicit class constraints
    # check attributes
    values = dataDict.get('applicationData')
    for value in values:
      value.checkAllValid(complete)

    value = dataDict.get('atomName')
    if (value is None):
      raise ApiError("""%s.checkValid: atomName:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('massNumber')
    if (value is None):
      raise ApiError("""%s.checkValid: massNumber:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('weight')
    if (value is None):
      raise ApiError("""%s.checkValid: weight:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    # check roles
    value = dataDict.get('access')
    value = dataDict.get('resLabel')
    if (value is None):
      raise ApiError("""%s.checkValid: resLabel:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

  delete = memops.api.Implementation.DataObject.delete

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData
  
  def get(self, name):
    """
    GetAttr for ccp.molecule.LabeledMolecule.SingleAtomLabel
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getAtomName(self):
    """
    Get for ccp.molecule.LabeledMolecule.SingleAtomLabel.atomName
    """
    dataDict = self.__dict__
    result = dataDict.get('atomName')
    return result
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccp.molecule.LabeledMolecule.SingleAtomLabel
    """

    result = None
    if (startObj.__class__.__name__ == 'MemopsRoot'):
      if (4 != len(fullKey)):
        raise ApiError("""'ccp.molecule.LabeledMolecule.SingleAtomLabel'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj0 = startObj
      objKey = fullKey[0]
      obj1 = obj0.__dict__.get('labeledMolecules').get(objKey)
      if (obj1 is None):
        obj0.refreshTopObjects('ccp.molecule.LabeledMolecule')
        obj1 = obj0.__dict__.get('labeledMolecules').get(objKey)

    else:
      if (3 != len(fullKey)):
        raise ApiError("""'ccp.molecule.LabeledMolecule.SingleAtomLabel'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj1 = startObj

    if (obj1 is not None):
      if (not (obj1.__dict__.get('isLoaded'))):
        obj1.load()

      objKey = fullKey[-3]
      obj2 = obj1.__dict__.get('molLabels').get(objKey)

      if (obj2 is not None):
        objKey = fullKey[-2]
        obj3 = obj2.__dict__.get('resLabels').get(objKey)

        if (obj3 is not None):
          objKey = fullKey[-1]
          obj4 = obj3.__dict__.get('atomLabels').get(objKey)
          if (isinstance(obj4, SingleAtomLabel)):
            result = obj4

    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation
  
  def getChemAtom(self):
    """
    getter for derived link chemAtom
    """
    dataDict = self.__dict__
    result =self.resLabel.molResidue.chemCompVar.findFirstChemAtom(name=self.atomName)
    return result

  getClassName = memops.api.Implementation.ComplexDataType.getClassName

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames

  getFullKey = AtomLabel.getFullKey

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted

  getLocalKey = AtomLabel.getLocalKey

  getMassNumber = AtomLabel.getMassNumber

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName

  getParent = AtomLabel.getParent

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName

  getResLabel = AtomLabel.getResLabel

  getRoot = memops.api.Implementation.MemopsObject.getRoot

  getSerial = AtomLabel.getSerial

  getTopObject = memops.api.Implementation.DataObject.getTopObject

  getWeight = AtomLabel.getWeight

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData
  
  def set(self, name, value):
    """
    SetAttr for ccp.molecule.LabeledMolecule.SingleAtomLabel
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData
  
  def setAtomName(self, value):
    """
    Set for ccp.molecule.LabeledMolecule.SingleAtomLabel.atomName
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.setAtomName:
       memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 32):
      raise ApiError("""%s.setAtomName:
       memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.setAtomName:
       memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.split()) == 1)):
      raise ApiError("""%s.setAtomName:
       Word constraint contains_no_white_space violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('atomName')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setAtomName:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setAtomName:
         cannot set atomName, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setAtomName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['atomName'] = value

    # doNotifies

  setMassNumber = AtomLabel.setMassNumber

  setSerial = AtomLabel.setSerial

  setWeight = AtomLabel.setWeight

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  applicationData = memops.api.Implementation.DataObject.applicationData
  
  atomName = property(getAtomName, setAtomName, None,
  r"""atom name of labeled atom
  """)

  className = memops.api.Implementation.ComplexDataType.className

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted

  massNumber = AtomLabel.massNumber

  metaclass = memops.api.Implementation.ComplexDataType.metaclass

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName

  serial = AtomLabel.serial

  weight = AtomLabel.weight

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess
  
  chemAtom = property(getChemAtom, None, None,
  r"""ChemAtom being labeled
  """)

  parent = AtomLabel.parent

  resLabel = AtomLabel.resLabel

  root = memops.api.Implementation.MemopsObject.root

  topObject = memops.api.Implementation.DataObject.topObject
