"""
#######################################################################

CCPN Data Model version 2.1.2

Autogenerated by PyFileApiGen revision 1.57.2.1 on Fri Mar 28 11:18:58 2014
  from data model element ccp.general.KeywordDefinition revision ?

#######################################################################
======================COPYRIGHT/LICENSE START==========================

KeywordDefinition.py: python API for CCPN data model, MetaPackage ccp.general.KeywordDefinition

Copyright (C) 2007  (CCPN Project)

=======================================================================

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
A copy of this license can be found in ../../../../license/LGPL.license
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
Lesser General Public License for more details.
 
You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA


======================COPYRIGHT/LICENSE END============================

for further information, please contact :

- CCPN website (http://www.ccpn.ac.uk/)

- email: ccpn@bioc.cam.ac.uk

=======================================================================

If you are using this software for academic purposes, we suggest
quoting the following references:

===========================REFERENCE START=============================
Rasmus H. Fogh, Wayne Boucher, Wim F. Vranken, Anne
Pajon, Tim J. Stevens, T.N. Bhat, John Westbrook, John M.C. Ionides and
Ernest D. Laue (2005). A framework for scientific data modeling and automated
software development. Bioinformatics 21, 1678-1684.


This file was generated with the Memops software generation framework,
and contains original contributions embedded in the framework

===========================REFERENCE END===============================
"""

import cStringIO
#import sets
import traceback
import types
import operator

# special function for fast whitespace checking.
# used in DataType Word and Token handcode
import re
containsWhitespace = re.compile('\s').search
containsNonAlphanumeric = re.compile('[^a-zA-Z0-9_]').search
 
from memops.general import Implementation as implementation
ApiError = implementation.ApiError

# imported packages:
import memops.api.AccessControl
import memops.api.Implementation

metaPackage = memops.api.Implementation.topPackage.metaObjFromQualName('ccp.general.KeywordDefinition')

###############################################################################
class KeywordDefinition(memops.api.Implementation.DataObject):
  r"""
  """
  #   from data model element ccp.general.KeywordDefinition.KeywordDefinition revision ?
  _metaclass = metaPackage.getElement('KeywordDefinition')
  _packageName = 'ccp.general.KeywordDefinition'
  _packageShortName = 'KWDF'
  _fieldNames = ('applicationData', 'className', 'explanation', 'fieldNames', 'inConstructor', 'isDeleted', 'keyword', 'metaclass', 'name', 'packageName', 'packageShortName', 'qualifiedName', 'targetNames', 'access', 'activeAccess', 'keywordDefinitionStore', 'parent', 'root', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for ccp.general.KeywordDefinition.KeywordDefinition
    """
    dataDict = self.__dict__
    dataDict['keywordDefinitionStore'] = parent
    if (not isinstance(parent, KeywordDefinitionStore)):
      raise ApiError("""%s.__init__:
       value is not of class ccp.general.KeywordDefinition.KeywordDefinitionStore""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = parent.__dict__.get('topObject')
    dataDict['topObject'] = topObject

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    if (notIsReading):
      if (not (topObject.__dict__.get('isModifiable'))):
        raise ApiError("""%s.__init__:
         Storage not modifiable""" % self.qualifiedName
         + ": %s" % (topObject,)
        )

    try:
      if (not ((parent.__dict__.get('isLoaded') or parent.__dict__.get('isReading')))):
        parent.load()

      dataDict['applicationData'] = list()
      dataDict['explanation'] = None
      dataDict['keyword'] = None
      dataDict['name'] = None
      dataDict['targetNames'] = set()
      dataDict['access'] = None

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in ccp.general.KeywordDefinition.KeywordDefinition.__init__"
        del dataDict['inConstructor']
        raise

      if (notIsReading):
        childrenDict = parent.__dict__.get('keywordDefinitions')
        objKey = dataDict.get('keyword')
        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['keyword'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notOverride):
        self.checkValid()

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for ccp.general.KeywordDefinition.KeywordDefinition:
       
    determines cascading deletes to follow from delete of object.
       
    *Implementation function* - should be called only by API delete 
    function.
    """
    dataDict = self.__dict__
    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for ccp.general.KeywordDefinition.KeywordDefinition:
    deletes objects
    *Implementation function* - will CORRUPT DATA if called 
    outside the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    keywordDefinitionStore = dataDict.get('keywordDefinitionStore')
    if (not (keywordDefinitionStore in objsToBeDeleted)):
      objKey = dataDict.get('keyword')
      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = keywordDefinitionStore.__dict__.get('keywordDefinitions')
        if (self is dd.get(objKey)):
          del dd[objKey]

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData
  
  def addTargetName(self, value):
    """
    Add for ccp.general.KeywordDefinition.KeywordDefinition.targetNames
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.addTargetName:
       memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 32):
      raise ApiError("""%s.addTargetName:
       memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.addTargetName:
       memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.split()) == 1)):
      raise ApiError("""%s.addTargetName:
       Word constraint contains_no_white_space violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('targetNames')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.addTargetName:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.addTargetName:
       called on deleted object""" % self.qualifiedName
      )

    if (value in currentValues):
      raise ApiError("""%s.addTargetName:
       value is in list already""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      pass

    currentValues.add(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('addTargetName')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def checkAllValid(self, complete=False):
    """
    CheckAllValid for ccp.general.KeywordDefinition.KeywordDefinition
    """
    dataDict = self.__dict__
    self.checkValid(complete)
  
  def checkValid(self, complete=False):
    """
    CheckValid for ccp.general.KeywordDefinition.KeywordDefinition
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      objKey = dataDict.get('keyword')
      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('keywordDefinitionStore')
        dd = value.__dict__.get('keywordDefinitions')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'keywordDefinitionStore' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      # check attributes
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('explanation')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: explanation:
           memops.Implementation.String input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('keyword')
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: keyword:
         memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 32):
        raise ApiError("""%s.checkValid: keyword:
         memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: keyword:
         memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.checkValid: keyword:
         Word constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('name')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: name:
           memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: name:
           memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: name:
           memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: name:
           Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      values = dataDict.get('targetNames')
      for value in values:
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: targetNames:
           memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 32):
          raise ApiError("""%s.checkValid: targetNames:
           memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: targetNames:
           memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.split()) == 1)):
          raise ApiError("""%s.checkValid: targetNames:
           Word constraint contains_no_white_space violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('keywordDefinitionStore')
      if (not isinstance(value, KeywordDefinitionStore)):
        raise ApiError("""%s.checkValid: keywordDefinitionStore:
         value is not of class ccp.general.KeywordDefinition.KeywordDefinitionStore""" % self.qualifiedName
         + ": %s" % (value,)
        )

    # check explicit class constraints
    # check attributes
    values = dataDict.get('applicationData')
    for value in values:
      value.checkAllValid(complete)

    value = dataDict.get('explanation')
    value = dataDict.get('keyword')
    if (value is None):
      raise ApiError("""%s.checkValid: keyword:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('name')
    values = dataDict.get('targetNames')
    # check roles
    value = dataDict.get('access')
    value = dataDict.get('keywordDefinitionStore')
    if (value is None):
      raise ApiError("""%s.checkValid: keywordDefinitionStore:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

  delete = memops.api.Implementation.DataObject.delete

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData
  
  def get(self, name):
    """
    GetAttr for ccp.general.KeywordDefinition.KeywordDefinition
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccp.general.KeywordDefinition.KeywordDefinition
    """

    result = None
    if (startObj.__class__.__name__ == 'MemopsRoot'):
      if (2 != len(fullKey)):
        raise ApiError("""'ccp.general.KeywordDefinition.KeywordDefinition'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj0 = startObj
      objKey = fullKey[0]
      obj1 = obj0.__dict__.get('keywordDefinitionStores').get(objKey)
      if (obj1 is None):
        obj0.refreshTopObjects('ccp.general.KeywordDefinition')
        obj1 = obj0.__dict__.get('keywordDefinitionStores').get(objKey)

    else:
      if (1 != len(fullKey)):
        raise ApiError("""'ccp.general.KeywordDefinition.KeywordDefinition'.getByKey:
         getByKey called with fullKey of wrong length. Parameters:"""
         + ": %s:%s" % (startObj, fullKey)
        )

      obj1 = startObj

    if (obj1 is not None):
      if (not (obj1.__dict__.get('isLoaded'))):
        obj1.load()

      objKey = fullKey[-1]
      obj2 = obj1.__dict__.get('keywordDefinitions').get(objKey)
      result = obj2

    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation

  getClassName = memops.api.Implementation.ComplexDataType.getClassName

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey
  
  def getExplanation(self):
    """
    Get for ccp.general.KeywordDefinition.KeywordDefinition.explanation
    """
    dataDict = self.__dict__
    result = dataDict.get('explanation')
    return result

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames
  
  def getFullKey(self, useGuid=False):
    """
    GetFullKey for ccp.general.KeywordDefinition.KeywordDefinition
    """
    dataDict = self.__dict__
    result = list()

    obj1 = dataDict.get('keywordDefinitionStore')

    if (useGuid):
      result.append(obj1.__dict__.get('guid'))
    else:
      result.append(obj1.__dict__.get('context'))

    result.append(dataDict.get('keyword'))

    return result

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted
  
  def getKeyword(self):
    """
    Get for ccp.general.KeywordDefinition.KeywordDefinition.keyword
    """
    dataDict = self.__dict__
    result = dataDict.get('keyword')
    return result
  
  def getKeywordDefinitionStore(self):
    """
    Get for
    ccp.general.KeywordDefinition.KeywordDefinition.keywordDefinitionStore
    """
    dataDict = self.__dict__
    result = dataDict.get('keywordDefinitionStore')
    return result
  
  def getLocalKey(self):
    """
    GetLocalKey for ccp.general.KeywordDefinition.KeywordDefinition
    """
    dataDict = self.__dict__
    result = dataDict.get('keyword')
    return result

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass
  
  def getName(self):
    """
    Get for ccp.general.KeywordDefinition.KeywordDefinition.name
    """
    dataDict = self.__dict__
    result = dataDict.get('name')
    return result

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName
  
  def getParent(self):
    """
    Get for ccp.general.KeywordDefinition.KeywordDefinition.parent
    """
    dataDict = self.__dict__
    result = dataDict.get('keywordDefinitionStore')
    return result

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName

  getRoot = memops.api.Implementation.MemopsObject.getRoot
  
  def getTargetNames(self):
    """
    Get for ccp.general.KeywordDefinition.KeywordDefinition.targetNames
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('targetNames')
    result = frozenset(tempVar)
    return result

  getTopObject = memops.api.Implementation.DataObject.getTopObject

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData
  
  def removeTargetName(self, value):
    """
    Remove for ccp.general.KeywordDefinition.KeywordDefinition.targetNames
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.removeTargetName:
       memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 32):
      raise ApiError("""%s.removeTargetName:
       memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.removeTargetName:
       memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.split()) == 1)):
      raise ApiError("""%s.removeTargetName:
       Word constraint contains_no_white_space violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('targetNames')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.removeTargetName:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.removeTargetName:
       called on deleted object""" % self.qualifiedName
      )

    if (not (value in currentValues)):
      raise ApiError("""%s.removeTargetName:
       value not in list""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      pass

    currentValues.remove(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('removeTargetName')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def set(self, name, value):
    """
    SetAttr for ccp.general.KeywordDefinition.KeywordDefinition
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData
  
  def setExplanation(self, value):
    """
    Set for ccp.general.KeywordDefinition.KeywordDefinition.explanation
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setExplanation:
         memops.Implementation.String input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('explanation')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setExplanation:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setExplanation:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['explanation'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setExplanation')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setKeyword(self, value):
    """
    Set for ccp.general.KeywordDefinition.KeywordDefinition.keyword
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.setKeyword:
       memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 32):
      raise ApiError("""%s.setKeyword:
       memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.setKeyword:
       memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.split()) == 1)):
      raise ApiError("""%s.setKeyword:
       Word constraint contains_no_white_space violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('keyword')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setKeyword:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setKeyword:
         cannot set keyword, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setKeyword:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['keyword'] = value

    # doNotifies
  
  def setName(self, value):
    """
    Set for ccp.general.KeywordDefinition.KeywordDefinition.name
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.setName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.setName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('name')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setName:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setName:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      pass

    dataDict['name'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setName')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setTargetNames(self, values):
    """
    Set for ccp.general.KeywordDefinition.KeywordDefinition.targetNames
    """
    dataDict = self.__dict__
    xx = values
    values = set(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setTargetNames:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setTargetNames:
         memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 32):
        raise ApiError("""%s.setTargetNames:
         memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setTargetNames:
         memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.setTargetNames:
         Word constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('targetNames')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = topObject.__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setTargetNames:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setTargetNames:
       called on deleted object""" % self.qualifiedName
      )

    if (values == currentValues):
      return

    if (notOverride):
      pass

    dataDict['targetNames'] = values
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setTargetNames')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  applicationData = memops.api.Implementation.DataObject.applicationData

  className = memops.api.Implementation.ComplexDataType.className
  
  explanation = property(getExplanation, setExplanation, None,
  r"""Definition, examples, etc. to explain the parameter defined by the 
  keyword.
  """)

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted
  
  keyword = property(getKeyword, setKeyword, None,
  r"""
  """)

  metaclass = memops.api.Implementation.ComplexDataType.metaclass
  
  name = property(getName, setName, None,
  r"""A user-friendly synonym for the keyword
  """)

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName
  
  targetNames = property(getTargetNames, setTargetNames, None,
  r"""qualified names for the CCPN classes that the keyword may be used to 
  describe. If empty there are no limitations. Typically keywords are used 
  as part of a keyword-value-object combination. targetNames refer to the 
  allowed type for the object being described (*not* the object that 
  contains the desctription)
  """)

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess
  
  keywordDefinitionStore = property(getKeywordDefinitionStore,  None, None,
  r"""parent link
  """)
  
  parent = property(getParent, None, None,
  r"""link to parent object - synonym for keywordDefinitionStore
  """)

  root = memops.api.Implementation.MemopsObject.root

  topObject = memops.api.Implementation.DataObject.topObject

###############################################################################
class KeywordDefinitionStore(memops.api.Implementation.TopObject):
  r"""Store for keyword definitions for a given context (e.g. a particular 
program or standard). 
  """
  #   from data model element ccp.general.KeywordDefinition.KeywordDefinitionStore revision ?
  _metaclass = metaPackage.getElement('KeywordDefinitionStore')
  _packageName = 'ccp.general.KeywordDefinition'
  _packageShortName = 'KWDF'
  _fieldNames = ('applicationData', 'className', 'context', 'createdBy', 'fieldNames', 'guid', 'inConstructor', 'isDeleted', 'isLoaded', 'isModifiable', 'isModified', 'isReading', 'lastUnlockedBy', 'metaclass', 'packageName', 'packageShortName', 'qualifiedName', 'access', 'activeAccess', 'activeRepositories', 'keywordDefinitions', 'memopsRoot', 'packageLocator', 'parent', 'root', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for ccp.general.KeywordDefinition.KeywordDefinitionStore
    """
    dataDict = self.__dict__
    dataDict['memopsRoot'] = parent
    from memops.api.Implementation import MemopsRoot as importedType
    if (not isinstance(parent, importedType)):
      raise ApiError("""%s.__init__:
       value is not of class memops.Implementation.MemopsRoot""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = self
    dataDict['topObject'] = topObject
    if (attrlinks.get('isReading', False)):
      del attrlinks['isReading']
      dataDict['isLoaded'] = False
      dataDict['isModified'] = False
      dataDict['isReading'] = True
    elif (parent.__dict__.get('isReading')):
      dataDict['isLoaded'] = False
      dataDict['isModified'] = False
      dataDict['isReading'] = True
    else:
      dataDict['isLoaded'] = True
      dataDict['isModified'] = True
      dataDict['isReading'] = False

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    try:
      if (not (dataDict.get('isReading'))):
        parent.refreshTopObjects('ccp.general.KeywordDefinition')

      dataDict['applicationData'] = list()
      dataDict['context'] = None
      dataDict['createdBy'] = None
      dataDict['guid'] = None
      dataDict['isModifiable'] = True
      dataDict['lastUnlockedBy'] = None
      dataDict['access'] = None
      dataDict['keywordDefinitions'] = {}
      dataDict['activeRepositories'] = list()

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in ccp.general.KeywordDefinition.KeywordDefinitionStore.__init__"
        del dataDict['inConstructor']
        raise

      if (notIsReading):
        childrenDict = parent.__dict__.get('keywordDefinitionStores')
        objKey = dataDict.get('context')
        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['context'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notIsReading):
        guid = dataDict.get('guid')
        if (guid is None):
          guid = root.newGuid()
          dataDict['guid'] = guid

        dd = root.__dict__.get('topObjects')
        if (dd.get(guid) is None):
          dd[guid] = self
        else:
          raise ApiError("""%s.__init__:
           Creating TopObject with preexisting guid""" % self.qualifiedName
           + ": %s" % (self,)
          )

        dataDict['createdBy'] = root.__dict__.get('currentUserId')

      if (notOverride):
        self.checkValid()

      if ((notIsReading or root.__dict__.get('currentKeywordDefinitionStore') is None)):
        root.__dict__['currentKeywordDefinitionStore'] = self

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for ccp.general.KeywordDefinition.KeywordDefinitionStore:
       
    determines cascading deletes to follow from delete of object.
       
    *Implementation function* - should be called only by API delete 
    function.
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    objsToBeDeleted.add(self)
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    access = dataDict.get('access')
    if (access is not None):
      topObject = access.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    keywordDefinitions = dataDict.get('keywordDefinitions').values()
    for keywordDefinition in keywordDefinitions:
      if (not (keywordDefinition in objsToBeDeleted)):
        objsToBeDeleted.add(keywordDefinition)
        objsToBeChecked.append(keywordDefinition)

    memopsRoot = dataDict.get('memopsRoot')
    if (memopsRoot is not None):
      topObject = memopsRoot.__dict__.get('topObject')
      topObjectsToCheck.add(topObject)

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for ccp.general.KeywordDefinition.KeywordDefinitionStore:
    deletes objects
    *Implementation function* - will CORRUPT DATA if called 
    outside the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    memopsRoot = dataDict.get('memopsRoot')
    if (self is memopsRoot.__dict__.get('currentKeywordDefinitionStore')):
      memopsRoot.__dict__['currentKeywordDefinitionStore'] = None

    access = dataDict.get('access')
    if ((access is not None and not (access in objsToBeDeleted))):
      access.__dict__['dataObject'] = None

    memopsRoot = dataDict.get('memopsRoot')
    if (not (memopsRoot in objsToBeDeleted)):
      objKey = dataDict.get('context')
      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = memopsRoot.__dict__.get('keywordDefinitionStores')
        if (self is dd.get(objKey)):
          del dd[objKey]

    dataDict['keywordDefinitions'] = {}

  addApplicationData = memops.api.Implementation.DataObject.addApplicationData

  backup = memops.api.Implementation.TopObject.backup
  
  def checkAllValid(self, complete=False):
    """
    CheckAllValid for ccp.general.KeywordDefinition.KeywordDefinitionStore
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    self.checkValid(complete)
    values = dataDict.get('keywordDefinitions').values()
    for value in values:
      value.checkAllValid(complete)

  def checkValid(self, complete=False):
    """
    CheckValid for ccp.general.KeywordDefinition.KeywordDefinitionStore
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      objKey = dataDict.get('context')
      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('memopsRoot')
        dd = value.__dict__.get('keywordDefinitionStores')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'memopsRoot' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      # check attributes
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      values = dataDict.get('applicationData')
      for value in values:
        from memops.api.Implementation import ApplicationData as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: applicationData:
           value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('context')
      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: context:
         memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 32):
        raise ApiError("""%s.checkValid: context:
         memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: context:
         memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.checkValid: context:
         Word constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('createdBy')
      if (value is None):
        raise ApiError("""%s.checkValid: createdBy:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: createdBy:
         memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 32):
        raise ApiError("""%s.checkValid: createdBy:
         memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: createdBy:
         memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.checkValid: createdBy:
         Word constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('guid')
      if (value is None):
        raise ApiError("""%s.checkValid: guid:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: guid:
         memops.Implementation.GuidString input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: guid:
         memops.Implementation.GuidString maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: guid:
         memops.Implementation.GuidString: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: guid:
         GuidString constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      isValid = frozenset('abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_0123456789-').issuperset(value)
      if (not (isValid)):
        raise ApiError("""%s.checkValid: guid:
         GuidString constraint value_is_url_safe violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('isModifiable')
      if (not (value in [True, False])):
        raise ApiError("""%s.checkValid: isModifiable:
         memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('lastUnlockedBy')
      if (value is not None):
        if (isinstance(value, memops.api.Implementation.String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: lastUnlockedBy:
           memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 32):
          raise ApiError("""%s.checkValid: lastUnlockedBy:
           memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: lastUnlockedBy:
           memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.split()) == 1)):
          raise ApiError("""%s.checkValid: lastUnlockedBy:
           Word constraint contains_no_white_space violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, memops.api.Implementation.String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      # check roles
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      value = dataDict.get('access')
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: access:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('dataObject')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: access:
           non-reciprocal link access from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: access:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = self.getActiveAccess()
      if (value is not None):
        from memops.api.AccessControl import AccessObject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: activeAccess:
           value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: activeAccess:
           Link activeAccess between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      values = dataDict.get('keywordDefinitions').values()
      for value in values:
        if (not isinstance(value, KeywordDefinition)):
          raise ApiError("""%s.checkValid: keywordDefinitions:
           value is not of class ccp.general.KeywordDefinition.KeywordDefinition""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('keywordDefinitionStore')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: keywordDefinitions:
           non-reciprocal link keywordDefinitions from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      value = dataDict.get('memopsRoot')
      from memops.api.Implementation import MemopsRoot as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.checkValid: memopsRoot:
         value is not of class memops.Implementation.MemopsRoot""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = self.getPackageLocator()
      if (value is None):
        raise ApiError("""%s.checkValid: packageLocator:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      from memops.api.Implementation import PackageLocator as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.checkValid: packageLocator:
         value is not of class memops.Implementation.PackageLocator""" % self.qualifiedName
         + ": %s" % (value,)
        )

      xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
      yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
      if (not (xx1 is yy1)):
        raise ApiError("""%s.checkValid: packageLocator:
         Link packageLocator between objects from separate partitions
         - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
         + ": %s:%s" % (self, value)
        )

    if (dataDict.get('isLoaded')):
      # check explicit class constraints
      # check attributes
      values = dataDict.get('applicationData')
      for value in values:
        value.checkAllValid(complete)

      value = dataDict.get('context')
      if (value is None):
        raise ApiError("""%s.checkValid: context:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      value = dataDict.get('isModifiable')
      if (value is None):
        raise ApiError("""%s.checkValid: isModifiable:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      # check roles
      value = dataDict.get('access')
      values = dataDict.get('keywordDefinitions').values()
      value = dataDict.get('memopsRoot')
      if (value is None):
        raise ApiError("""%s.checkValid: memopsRoot:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

    else:
      # check unloaded TopObject
      value = dataDict.get('guid')
      if (value is None):
        raise ApiError("""%s.checkValid: guid:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      value = dataDict.get('context')
      if (value is None):
        raise ApiError("""%s.checkValid: context:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

  delete = memops.api.Implementation.DataObject.delete

  findAllActiveRepositories = memops.api.Implementation.TopObject.findAllActiveRepositories

  findAllApplicationData = memops.api.Implementation.DataObject.findAllApplicationData
  
  def findAllKeywordDefinitions(self, **conditions):
    """
    FindAll for
    ccp.general.KeywordDefinition.KeywordDefinitionStore.keywordDefinitions
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('keywordDefinitions').values()
      result = set(currentValues)

    else:
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('keywordDefinitions').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('explanation', 'keyword', 'name', 'access', 'keywordDefinitionStore',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result.add(v)

    return result

  findFirstActiveRepository = memops.api.Implementation.TopObject.findFirstActiveRepository

  findFirstApplicationData = memops.api.Implementation.DataObject.findFirstApplicationData
  
  def findFirstKeywordDefinition(self, **conditions):
    """
    FindFirst for
    ccp.general.KeywordDefinition.KeywordDefinitionStore.keywordDefinitions
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
        self.load()

      currentValues = dataDict.get('keywordDefinitions').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      objKey = conditions.get('keyword')
      if (objKey is not None):
        if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
          self.load()

        result = dataDict.get('keywordDefinitions').get(objKey)

        if (nConditions <= 1):
          return result

        elif (result is None):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
          self.load()

        currentValues = dataDict.get('keywordDefinitions').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('explanation', 'keyword', 'name', 'access', 'keywordDefinitionStore',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if getattr(v, key, ApiError) == condition:
              # NB ApiError is a dummy object, never equal to condition
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if getattr(v, key, ApiError) != condition:
              # NB ApiError is a dummy object, never equal to condition
              break
          else:
            result = v; break

    return result
  
  def get(self, name):
    """
    GetAttr for ccp.general.KeywordDefinition.KeywordDefinitionStore
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getAccess = memops.api.Implementation.DataObject.getAccess

  getActiveAccess = memops.api.Implementation.DataObject.getActiveAccess

  getActiveRepositories = memops.api.Implementation.TopObject.getActiveRepositories

  getApplicationData = memops.api.Implementation.DataObject.getApplicationData
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for ccp.general.KeywordDefinition.KeywordDefinitionStore
    """

    result = None
    if (1 != len(fullKey)):
      raise ApiError("""'ccp.general.KeywordDefinition.KeywordDefinitionStore'.getByKey:
       getByKey called with fullKey of wrong length. Parameters:"""
       + ": %s:%s" % (startObj, fullKey)
      )

    objKey = fullKey[0]
    obj1 = startObj.__dict__.get('keywordDefinitionStores').get(objKey)
    if (obj1 is None):
      startObj.refreshTopObjects('ccp.general.KeywordDefinition')
      obj1 = startObj.__dict__.get('keywordDefinitionStores').get(objKey)

    result = obj1
    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = memops.api.Implementation.MemopsObject.getByNavigation

  getClassName = memops.api.Implementation.ComplexDataType.getClassName
  
  def getContext(self):
    """
    Get for ccp.general.KeywordDefinition.KeywordDefinitionStore.context
    """
    dataDict = self.__dict__
    result = dataDict.get('context')
    return result

  getCreatedBy = memops.api.Implementation.TopObject.getCreatedBy

  getExpandedKey = memops.api.Implementation.MemopsObject.getExpandedKey

  getFieldNames = memops.api.Implementation.ComplexDataType.getFieldNames
  
  def getFullKey(self, useGuid=False):
    """
    GetFullKey for ccp.general.KeywordDefinition.KeywordDefinitionStore
    """
    dataDict = self.__dict__
    result = list()

    if (useGuid):
      result.append(dataDict.get('guid'))
    else:
      result.append(dataDict.get('context'))

    return result

  getGuid = memops.api.Implementation.TopObject.getGuid

  getInConstructor = memops.api.Implementation.ComplexDataType.getInConstructor

  getIsDeleted = memops.api.Implementation.MemopsObject.getIsDeleted

  getIsLoaded = memops.api.Implementation.TopObject.getIsLoaded

  getIsModifiable = memops.api.Implementation.TopObject.getIsModifiable

  getIsModified = memops.api.Implementation.TopObject.getIsModified

  getIsReading = memops.api.Implementation.TopObject.getIsReading
  
  def getKeywordDefinitions(self):
    """
    Get for
    ccp.general.KeywordDefinition.KeywordDefinitionStore.keywordDefinitions
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    tempVar = dataDict.get('keywordDefinitions').values()
    result = frozenset(tempVar)
    return result

  getLastUnlockedBy = memops.api.Implementation.TopObject.getLastUnlockedBy
  
  def getLocalKey(self):
    """
    GetLocalKey for ccp.general.KeywordDefinition.KeywordDefinitionStore
    """
    dataDict = self.__dict__
    result = dataDict.get('context')
    return result
  
  def getMemopsRoot(self):
    """
    Get for ccp.general.KeywordDefinition.KeywordDefinitionStore.memopsRoot
    """
    dataDict = self.__dict__
    result = dataDict.get('memopsRoot')
    return result

  getMetaclass = memops.api.Implementation.ComplexDataType.getMetaclass

  getPackageLocator = memops.api.Implementation.TopObject.getPackageLocator

  getPackageName = memops.api.Implementation.ComplexDataType.getPackageName

  getPackageShortName = memops.api.Implementation.ComplexDataType.getPackageShortName
  
  def getParent(self):
    """
    Get for ccp.general.KeywordDefinition.KeywordDefinitionStore.parent
    """
    dataDict = self.__dict__
    result = dataDict.get('memopsRoot')
    return result

  getQualifiedName = memops.api.Implementation.ComplexDataType.getQualifiedName

  getRoot = memops.api.Implementation.MemopsObject.getRoot

  getTopObject = memops.api.Implementation.DataObject.getTopObject

  load = memops.api.Implementation.TopObject.load

  loadFrom = memops.api.Implementation.TopObject.loadFrom
  
  def newKeywordDefinition(self, **attrlinks):
    """
    Factory function to create
    ccp.general.KeywordDefinition.KeywordDefinition
    """
    return KeywordDefinition(self, **attrlinks)

  removeApplicationData = memops.api.Implementation.DataObject.removeApplicationData

  removeFrom = memops.api.Implementation.TopObject.removeFrom

  restore = memops.api.Implementation.TopObject.restore

  save = memops.api.Implementation.TopObject.save

  saveTo = memops.api.Implementation.TopObject.saveTo
  
  def set(self, name, value):
    """
    SetAttr for ccp.general.KeywordDefinition.KeywordDefinitionStore
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setAccess = memops.api.Implementation.DataObject.setAccess

  setApplicationData = memops.api.Implementation.DataObject.setApplicationData
  
  def setContext(self, value):
    """
    Set for ccp.general.KeywordDefinition.KeywordDefinitionStore.context
    """
    dataDict = self.__dict__
    if (isinstance(value, memops.api.Implementation.String.PythonType)):
      pass
    else:
      raise ApiError("""%s.setContext:
       memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 32):
      raise ApiError("""%s.setContext:
       memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.setContext:
       memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.split()) == 1)):
      raise ApiError("""%s.setContext:
       Word constraint contains_no_white_space violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValue = dataDict.get('context')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setContext:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setContext:
         cannot set context, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setContext:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['context'] = value

    # doNotifies

  setCreatedBy = memops.api.Implementation.TopObject.setCreatedBy

  setGuid = memops.api.Implementation.TopObject.setGuid

  setIsModifiable = memops.api.Implementation.TopObject.setIsModifiable

  setLastUnlockedBy = memops.api.Implementation.TopObject.setLastUnlockedBy
  
  def sortedKeywordDefinitions(self):
    """
    Sorted for
    ccp.general.KeywordDefinition.KeywordDefinitionStore.keywordDefinitions
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    sortdd = dataDict.get('keywordDefinitions')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result

  toDetailedString = memops.api.Implementation.ComplexDataType.toDetailedString

  touch = memops.api.Implementation.TopObject.touch

  applicationData = memops.api.Implementation.DataObject.applicationData

  className = memops.api.Implementation.ComplexDataType.className
  
  context = property(getContext, setContext, None,
  r"""context within which keywords are defined. Typically the name of teh 
  program or standard that defines them.
  """)

  createdBy = memops.api.Implementation.TopObject.createdBy

  fieldNames = memops.api.Implementation.ComplexDataType.fieldNames

  guid = memops.api.Implementation.TopObject.guid

  inConstructor = memops.api.Implementation.ComplexDataType.inConstructor

  isDeleted = memops.api.Implementation.MemopsObject.isDeleted

  isLoaded = memops.api.Implementation.TopObject.isLoaded

  isModifiable = memops.api.Implementation.TopObject.isModifiable

  isModified = memops.api.Implementation.TopObject.isModified

  isReading = memops.api.Implementation.TopObject.isReading

  lastUnlockedBy = memops.api.Implementation.TopObject.lastUnlockedBy

  metaclass = memops.api.Implementation.ComplexDataType.metaclass

  packageName = memops.api.Implementation.ComplexDataType.packageName

  packageShortName = memops.api.Implementation.ComplexDataType.packageShortName

  qualifiedName = memops.api.Implementation.ComplexDataType.qualifiedName

  access = memops.api.Implementation.DataObject.access

  activeAccess = memops.api.Implementation.DataObject.activeAccess

  activeRepositories = memops.api.Implementation.TopObject.activeRepositories
  
  keywordDefinitions = property(getKeywordDefinitions,  None, None,
  r"""child link to class KeywordDefinition
  """)
  
  memopsRoot = property(getMemopsRoot,  None, None,
  r"""parent link
  """)

  packageLocator = memops.api.Implementation.TopObject.packageLocator
  
  parent = property(getParent, None, None,
  r"""link to parent object - synonym for memopsRoot
  """)

  root = memops.api.Implementation.MemopsObject.root

  topObject = memops.api.Implementation.DataObject.topObject
