#
# Python dictionary with nmrStar information
# Generated on Thu Jun 24 15:18:24 2010
#
# Values per field are [name of tag,function to get data,foreign key name,obligatory value]
#

from ccp.format.nmrStar.util import returnStarInt, returnStarFloat
from ccp.format.nmrStar.util import returnStarString, returnStarDateTime, returnStarAtCode
from ccp.format.nmrStar.util import returnStarCode, returnStarLine, returnStarName, returnStarIdName
from ccp.format.nmrStar.util import returnStarYesNo, returnStarFaxPhoneEmail, returnStarLabel

value = None

sfDict = {

  'entry_interview': {

    'name': 'Entry_interview',
    'saveFrameCode': 'entry_interview',

    'tags': {

      'Sf_category': ['entry_interview',lambda x = value: returnStarCode(x,length = 127),None,True],          # Category definition for the information content of the saveframe
      'Sf_framecode': [None,lambda x = value: returnStarCode(x,length = 127),None,False],                     # A code that uniquely identifies the saveframe within the entry.  The code can be a human readable identifier that defines the contents of the saveframe (see the examples).
      'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                     # Pointer to '_Entry.ID'
      'ID': [None,returnStarInt,None,True],                                                                   # Unique value identifying this saveframe of category entry_interview within an entry.
      'PDB_deposition': [None,lambda x = value: returnStarYesNo(x,length = 3),None,False],                    # Flag indicating that atomic coordinates are being deposited.
      'BMRB_deposition': [None,lambda x = value: returnStarYesNo(x,length = 3),None,False],                   # Check this box$ if you are depositing NMR experimental data to be archived at the BioMagResBank.  With this box checked$ after clicking on the 'Save Changes' button$ you will be asked to enter additional information regarding the data submitted. Files containing the data sets should be uploaded by filling out the form found by clicking on the 'Deposit data files' link in the frame on the left of the screen.
      'View_mode': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                         # The 'view mode' buttons are used to select between a view of the PDB or the BMRB deposition requirements. The majority of the information you enter will apply to both a PDB and a BMRB deposition. When in the PDB view mode$ a deposition can be submitted to PDB and when in the BMRB view mode$ a deposition can be submitted to BMRB.
      'Structural_genomics': [None,lambda x = value: returnStarYesNo(x,length = 3),None,False],               # Flag indicating if the deposition originates from a structural genomics project.
      'Ligands': [None,lambda x = value: returnStarYesNo(x,length = 3),None,False],                           # Flag indicating the presence of ligands$ metal ions$ or other small molecules in the molecular system studied.
      'Non_standard_residues': [None,lambda x = value: returnStarYesNo(x,length = 3),None,False],             # Flag indicating the presence of non-standard residues in one or more biopolymers in the molecular system studied.
      'Constraints': [None,lambda x = value: returnStarYesNo(x,length = 3),None,False],                       # Flag indicating that structural constraints are being deposited.
      'Assigned_chem_shifts': [None,lambda x = value: returnStarYesNo(x,length = 3),None,False],              # Flag indicating that assigned chemical shifts are being deposited.
      'Coupling_constants': [None,lambda x = value: returnStarYesNo(x,length = 3),None,False],                # Flag indicating that scalar coupling constants are being deposited.
      'Chem_shift_anisotropy': [None,lambda x = value: returnStarYesNo(x,length = 3),None,False],             # Flag indicating that chemical shift anisotropy values are being deposited.
      'Heteronucl_NOEs': [None,lambda x = value: returnStarYesNo(x,length = 3),None,False],                   # Flag indicating that heteronuclear NOEs are being deposited.
      'Heteronucl_T1_relaxation': [None,lambda x = value: returnStarYesNo(x,length = 3),None,False],          # Flag indicating that heteronuclear T1 relaxation values are being deposited.
      'Heteronucl_T2_relaxation': [None,lambda x = value: returnStarYesNo(x,length = 3),None,False],          # Flag indicating that heteronuclear T2 relaxation values are being deposited.
      'Heteronucl_T1rho_relaxation': [None,lambda x = value: returnStarYesNo(x,length = 3),None,False],       # Flag indicating that heteronuclear T1rho relaxation values are being deposited.
      'Order_parameters': [None,lambda x = value: returnStarYesNo(x,length = 3),None,False],                  # Flag indicating that order parameter values are being deposited.
      'Residual_dipolar_couplings': [None,lambda x = value: returnStarYesNo(x,length = 3),None,False],        # Flag indicating that residual dipolar coupling values are being deposited.
      'H_exchange_rate': [None,lambda x = value: returnStarYesNo(x,length = 3),None,False],                   # Flag indicating that hydrogen exchange values are being deposited.
      'H_exchange_protection_factors': [None,lambda x = value: returnStarYesNo(x,length = 3),None,False],     # Flag indicating that hydrogen exchange protection factor values are being deposited.
      'Spectral_peak_lists': [None,lambda x = value: returnStarYesNo(x,length = 3),None,False],               # Flag indicating that spectral peak lists are being deposited.
      'Dipole_dipole_couplings': [None,lambda x = value: returnStarYesNo(x,length = 3),None,False],           # Flag indicating that dipole-dipole coupling values are being deposited.
      'Quadrupolar_couplings': [None,lambda x = value: returnStarYesNo(x,length = 3),None,False],             # Flag indicating that quadrupolar coupling values are being deposited.
      'Homonucl_NOEs': [None,lambda x = value: returnStarYesNo(x,length = 3),None,False],                     # Flag indicating that homonuclear NOE values are being deposited.
      'Dipole_dipole_relaxation': [None,lambda x = value: returnStarYesNo(x,length = 3),None,False],          # Flag indicating that dipole-dipole relaxation values are being deposited.
      'DD_cross_correlation': [None,lambda x = value: returnStarYesNo(x,length = 3),None,False],              # Flag indicating that cross correlation relaxation values are being deposited.
      'Dipole_CSA_cross_correlation': [None,lambda x = value: returnStarYesNo(x,length = 3),None,False],      # Flag indicating that dipole-Chemical shift anisotropy cross correlation relaxation data are being deposited.
      'Binding_constants': [None,lambda x = value: returnStarYesNo(x,length = 3),None,False],                 # Flag indicating that binding constant values are being deposited.
      'PKa_value_data_set': [None,lambda x = value: returnStarYesNo(x,length = 3),None,False],                # Flag indicating that pKa values are being deposited.
      'D_H_fractionation_factors': [None,lambda x = value: returnStarYesNo(x,length = 3),None,False],         # Flag indicating that deuterium-hydrogen fractionation factor values are being deposited.
      'Theoretical_chem_shifts': [None,lambda x = value: returnStarYesNo(x,length = 3),None,False],           # Flag indicating that theoretical chamical shift values are being deposited.
      'Spectral_density_values': [None,lambda x = value: returnStarYesNo(x,length = 3),None,False],           # Flag indicating that spectral density values are being deposited.
      'Timedomain_data': [None,lambda x = value: returnStarYesNo(x,length = 3),None,False],                   # Flag indicating that time domain spectral data are being deposited.
      'Molecular_interactions': [None,lambda x = value: returnStarYesNo(x,length = 3),None,False],            # Flag indicating that molecular interaction data are being deposited.
      'Secondary_structure_orientations': [None,lambda x = value: returnStarYesNo(x,length = 3),None,False],  # Flag indicating that secondary structure orientation data are being deposited.
      'Metabolite_coordinates': [None,lambda x = value: returnStarYesNo(x,length = 3),None,False],            # Flag indicating that atomic coordinates for a metabolic compound are being deposited.
      'Mass_spec_data': [None,lambda x = value: returnStarYesNo(x,length = 3),None,False],                    # Flag indicating that mass spectral data are being deposited.
      'Other_kind_of_data': [None,lambda x = value: returnStarYesNo(x,length = 3),None,False],                # Flag indicating that data of a kind not listed in the selections shown in the deposition interface are being deposited.

            },

    'tagNames': ['Sf_category', 'Sf_framecode', 'Entry_ID', 'ID', 'PDB_deposition', 'BMRB_deposition', 'View_mode', 'Structural_genomics', 'Ligands', 'Non_standard_residues', 'Constraints', 'Assigned_chem_shifts', 'Coupling_constants', 'Chem_shift_anisotropy', 'Heteronucl_NOEs', 'Heteronucl_T1_relaxation', 'Heteronucl_T2_relaxation', 'Heteronucl_T1rho_relaxation', 'Order_parameters', 'Residual_dipolar_couplings', 'H_exchange_rate', 'H_exchange_protection_factors', 'Spectral_peak_lists', 'Dipole_dipole_couplings', 'Quadrupolar_couplings', 'Homonucl_NOEs', 'Dipole_dipole_relaxation', 'DD_cross_correlation', 'Dipole_CSA_cross_correlation', 'Binding_constants', 'PKa_value_data_set', 'D_H_fractionation_factors', 'Theoretical_chem_shifts', 'Spectral_density_values', 'Timedomain_data', 'Molecular_interactions', 'Secondary_structure_orientations', 'Metabolite_coordinates', 'Mass_spec_data', 'Other_kind_of_data'],
    'sourcePrimaryKeys': ['Entry_ID', 'ID'],

    },

  'deposited_data_files': {

    'name': 'Deposited_data_files',
    'saveFrameCode': 'deposited_data_files',

    'tags': {

      'Sf_category': ['deposited_data_files',lambda x = value: returnStarCode(x,length = 127),None,True],     # Category assigned to the information in the saveframe.
      'Sf_framecode': [None,lambda x = value: returnStarCode(x,length = 127),None,False],                     # STAR term for the name assigned to the saveframe.
      'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                     # Pointer to '_Entry.ID'
      'ID': [None,returnStarInt,None,True],                                                                   # Unique value identifying this saveframe of category deposited_data_files within an entry.
      'Atomic_coordinate_file_name': [None,lambda x = value: returnStarLine(x,length = 127),None,False],      # Name for the file containing atomic coordinates uploaded to the databank.
      'Atomic_coordinate_file_syntax': [None,lambda x = value: returnStarLine(x,length = 127),None,False],    # Syntax or format for the uploaded file containing atomic coordinates.
      'Constraint_file_name': [None,lambda x = value: returnStarLine(x,length = 127),None,False],             # Name for the file containing structural constraints uploaded to the databank.
      'Constraint_file_syntax': [None,lambda x = value: returnStarLine(x,length = 127),None,False],           # Syntax or format for the uploaded file containing structural constraints.
      'Precheck_flag': [None,lambda x = value: returnStarYesNo(x,length = 3),None,False],                     # Flag indicating the choice of executing a precheck on the atomic coordinate file by the depositor.
      'Validate_flag': [None,lambda x = value: returnStarYesNo(x,length = 3),None,False],                     # Flag indicating the choice of executing a validation procedure on the atomic coordinate file indicated by the depositor.

            },

    'tagNames': ['Sf_category', 'Sf_framecode', 'Entry_ID', 'ID', 'Atomic_coordinate_file_name', 'Atomic_coordinate_file_syntax', 'Constraint_file_name', 'Constraint_file_syntax', 'Precheck_flag', 'Validate_flag'],
    'sourcePrimaryKeys': ['Entry_ID', 'ID'],

    'tables': {

      'Upload_data': {

        'tags': {

          'Data_file_ID': [None,returnStarInt,None,True],                                                     # Unique code assigned to the file being uploaded by the depositor and that contains data that will be incorporated into this entry.
          'Data_file_name': [None,lambda x = value: returnStarLine(x,length = 127),None,True],                # The directory path and file name for the data file that is to be uploaded.
          'Data_file_Sf_category': [None,lambda x = value: returnStarCode(x,length = 127),None,False],        # The type of data contained in the file that is to be uploaded.
          'Data_file_syntax': [None,lambda x = value: returnStarLine(x,length = 127),None,False],             # The syntax or format of the file that is uploaded.
          'Data_file_immutable_flag': [None,lambda x = value: returnStarCode(x,length = 3),None,False],       # A flag used during the deposition process to indicate that an uploaded file cannot be changed without reapplying the validation procedures.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Deposited_data_files_ID': [None,returnStarInt,'Deposited_data_files.ID',True],                     # Pointer to '_Deposited_data_files.ID'

                },

        'tagNames': ['Data_file_ID', 'Data_file_name', 'Data_file_Sf_category', 'Data_file_syntax', 'Data_file_immutable_flag', 'Entry_ID', 'Deposited_data_files_ID'],
        'sourcePrimaryKeys': ['Data_file_ID', 'Entry_ID', 'Deposited_data_files_ID'],

            }

        },

    'tableNames': ['Upload_data']

    },

  'study_list': {

    'name': 'Study_list',

    'tags': {

      'Sf_category': ['study_list',lambda x = value: returnStarCode(x,length = 127),None,True],               # Category assigned to the information in the saveframe.
      'Sf_framecode': [None,lambda x = value: returnStarCode(x,length = 127),None,False],                     # Character string that is unique to the saveframe within the data block defined by a specific entry.  The character string names the saveframe and may be used to reference or to point to the saveframe later in the data block.
      'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                     # Pointer to '_Entry.ID'
      'ID': [None,returnStarInt,None,True],                                                                   # Unique value identifying this saveframe of category study_list within an entry.

            },

    'tagNames': ['Sf_category', 'Sf_framecode', 'Entry_ID', 'ID'],
    'sourcePrimaryKeys': ['Entry_ID', 'ID'],

    'tables': {

      'Study': {

        'tags': {

          'ID': [None,returnStarInt,None,True],                                                               # Unique code that identifies a specific study.
          'Name': [None,returnStarString,None,True],                                                          # Descriptive name given to a 'study' where a study is a collection of entries containing data for a set of related molecular systems or for a single molecular system but published in more than one citation (i.e. chemical shifts in one publication and atomic coordinates in another and relaxation studies in a third).
          'Type': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                         # A brief phrase that describes the study that was conducted.  An enumerated list of types will be provided but an author will be able to provide their own description if none of the enumerated values are appropriate.
          'Details': [None,returnStarString,None,False],                                                      # Text information relevant to the study are entered as a value for this tag.  This tag is often used to include information that cannot be associated with a specific tag in the saveframe but is important for the entry. The information entered must supplement information already present.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Study_list_ID': [None,returnStarInt,'Study_list.ID',True],                                         # Pointer to '_Study_list.ID'

                },

        'tagNames': ['ID', 'Name', 'Type', 'Details', 'Entry_ID', 'Study_list_ID'],
        'sourcePrimaryKeys': ['ID', 'Entry_ID', 'Study_list_ID'],

            },

      'Study_keyword': {

        'tags': {

          'Study_ID': [None,returnStarInt,'Study.ID',True],                                                   # Pointer to '_Study.ID'
          'Keyword': [None,lambda x = value: returnStarLine(x,length = 127),None,True],                       # A word or brief phrase that can be used to describe or classify the study.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Study_list_ID': [None,returnStarInt,'Study_list.ID',True],                                         # Pointer to '_Study_list.ID'

                },

        'tagNames': ['Study_ID', 'Keyword', 'Entry_ID', 'Study_list_ID'],
        'sourcePrimaryKeys': ['Study_ID', 'Keyword', 'Entry_ID', 'Study_list_ID'],

            },

      'Study_entry_list': {

        'tags': {

          'Study_ID': [None,returnStarInt,'Study.ID',True],                                                   # Pointer to '_Study.ID' not within the entry but across the database.
          'BMRB_accession_code': [None,lambda x = value: returnStarCode(x,length = 12),None,True],            # BMRB accession number for an entry that is a member of the study.
          'BMRB_entry_description': [None,lambda x = value: returnStarLine(x,length = 127),None,False],       # A keyword defining the relationship between the entry and the study.
          'Details': [None,returnStarString,None,False],                                                      # Text providing additional information describing the relationship between the entry and the study.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Study_list_ID': [None,returnStarInt,'Study_list.ID',True],                                         # Pointer to '_Study_list.ID'

                },

        'tagNames': ['Study_ID', 'BMRB_accession_code', 'BMRB_entry_description', 'Details', 'Entry_ID', 'Study_list_ID'],
        'sourcePrimaryKeys': ['Study_ID', 'BMRB_accession_code', 'Entry_ID', 'Study_list_ID'],

            }

        },

    'tableNames': ['Study', 'Study_keyword', 'Study_entry_list']

    },

  'entry_information': {

    'name': 'Entry',
    'saveFrameCode': 'entry_information',

    'tags': {

      'Sf_category': ['entry_information',lambda x = value: returnStarCode(x,length = 127),None,True],        # Category assigned to the information in the saveframe.
      'Sf_framecode': [None,lambda x = value: returnStarCode(x,length = 127),None,False],                     # STAR framecode for this saveframe.  The value is defined as 'entry_information' for the entry information saveframe in each entry.
      'ID': [None,lambda x = value: returnStarCode(x,length = 12),None,True],                                 # BMRB accession number for this entry
      'Title': [None,returnStarString,None,True],                                                             # A descriptive title for the entry.  Something similar to the title of a scientific paper.
      'Version_type': [None,lambda x = value: returnStarLine(x,length = 31),None,True],                       # Defines whether the current version of the entry is the original version or an updated version.
      'Submission_date': [None,returnStarDateTime,None,True],                                                 # Date the entry was submitted to BMRB.
      'Accession_date': [None,returnStarDateTime,None,True],                                                  # Date BMRB accession number was assigned to the entry.
      'Last_release_date': [None,returnStarDateTime,None,False],                                              # Date the current version of th entry was released.
      'Original_release_date': [None,returnStarDateTime,None,False],                                          # Date the entry was originally released.
      'Origination': [None,lambda x = value: returnStarLine(x,length = 31),None,True],                        # The value to this tag defines who entered the original data into the database.  Entries taken from the literature and entered by BMRB staff are marked 'BMRB.'  Entries supplied by authors are marked 'author' and entries taken from the PDB will be marked 'PDB.'
      'NMR_STAR_version': [None,lambda x = value: returnStarLine(x,length = 31),None,True],                   # Version of NMR-STAR in which the current entry is formatted.
      'Original_NMR_STAR_version': [None,lambda x = value: returnStarLine(x,length = 31),None,False],         # Version of NMR-STAR in which the original entry was generated.
      'Experimental_method': [None,lambda x = value: returnStarLine(x,length = 127),None,True],               # The experimental method used to gather the data in the entry is given as the value to this tag.
      'Experimental_method_subtype': [None,lambda x = value: returnStarLine(x,length = 31),None,False],       # Enter the type of NMR method used (e.g.$ solution$ solid-state (powder)$ theoretical$ etc.).
      'Dep_release_code_coordinates': [None,lambda x = value: returnStarLine(x,length = 31),None,False],      # Select the status or terms to be applied for the release of the atomic coordinate data to the public. Depositors are encourage to make their data available to the public as quickly as possible.  However$ requests may be made to hold the data for a limited period of time up to one year or until the manuscript reporting the data is published.
      'Dep_release_code_nmr_constraints': [None,lambda x = value: returnStarLine(x,length = 31),None,False],  # Select the status or terms to be applied for the release of the NMR constraint data to the public. Depositors are encourage to make their data available to the public as quickly as possible.  However$ requests may be made to hold the data for a limited period of time up to one year or until the manuscript reporting the data is published.
      'Dep_release_code_nmr_exptl': [None,lambda x = value: returnStarLine(x,length = 31),None,False],        # Select the status or terms to be applied for the release of the NMR experimental data to the public. Depositors are encourage to make their data available to the public as quickly as possible.  However$ requests may be made to hold the data for a limited period of time up to one year or until the manuscript reporting the data is published.
      'Dep_release_code_sequence': [None,lambda x = value: returnStarLine(x,length = 31),None,False],         # Select the status or terms to be applied for the prerelease of the sequence information for the biopolymers to the public. Although the atomic coordinate and other data may be placed 'on hold'$ immediate release of the polymer sequence data will allow others$ including the structural genomics centers$ to identify polymers that have been studied and to select other targets reducing duplicate effort.
      'CASP_target': [None,lambda x = value: returnStarYesNo(x,length = 3),None,False],                       # Flag indicating if the deposited structure is part of a CASP$ CASD$ or other project.
      'Details': [None,returnStarString,None,False],                                                          # An optional text description of the entry used to provide additional information above that given as values to other items in the entry.
      'Special_processing_instructions': [None,returnStarString,None,False],                                  # Author supplied instructions for the annotators to use in processing the entry.
      'Update_BMRB_accession_code': [None,lambda x = value: returnStarCode(x,length = 12),None,False],        # Accession number for a BMRB entry that the current deposition is intended to update.
      'Replace_BMRB_accession_code': [None,lambda x = value: returnStarCode(x,length = 12),None,False],       # Accession number for a BMRB entry that the current deposition is intended to replace.
      'Update_PDB_accession_code': [None,lambda x = value: returnStarCode(x,length = 15),None,False],         # Accession number for a PDB entry that the current deposition is intended to update.
      'Replace_PDB_accession_code': [None,lambda x = value: returnStarCode(x,length = 15),None,False],        # Accession number for a PDB entry that the current deposition is intended to replace.
      'PDB_coordinate_file_version': [None,lambda x = value: returnStarCode(x,length = 31),None,False],       # Format version code for the PDB coordinate file that is the source of the PDB information included in the entry.
      'BMRB_update_details': [None,returnStarString,None,False],                                              # Text describing the reason for the update and the update itself.
      'PDB_update_details': [None,returnStarString,None,False],                                               # Text describing the data being deposited as an update for an existing entry.
      'Release_request': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                  # The condition choosen by the author for the release of the entry.
      'Release_date_request': [None,returnStarDateTime,None,False],                                           # Date requested by the author for the release of the entry to the public.
      'Release_date_justification': [None,returnStarString,None,False],                                       # Text justification for the release date request.
      'Status_code': [None,lambda x = value: returnStarLine(x,length = 31),None,False],                       # Code for status of file.
      'Recvd_deposit_form': [None,lambda x = value: returnStarYesNo(x,length = 3),None,False],                # This code indicates whether the deposition form for an entry has been received.
      'Date_deposition_form': [None,returnStarDateTime,None,False],                                           # The date the deposition form is received.
      'Recvd_coordinates': [None,lambda x = value: returnStarYesNo(x,length = 3),None,False],                 # This code indicates whether the coordinates for an entry have been received.
      'Date_coordinates': [None,returnStarDateTime,None,False],                                               # The date the coordinates are received.
      'Recvd_nmr_constraints': [None,lambda x = value: returnStarYesNo(x,length = 3),None,False],             # This code indicates whether the NMR constraint data for an entry have been received.
      'Date_nmr_constraints': [None,returnStarDateTime,None,False],                                           # The date the NMR constraints are received.
      'Recvd_manuscript': [None,lambda x = value: returnStarYesNo(x,length = 3),None,False],                  # This code indicates whether the manuscript for an entry has been received.
      'Date_manuscript': [None,returnStarDateTime,None,False],                                                # The date the manuscript is received.
      'Recvd_author_approval': [None,lambda x = value: returnStarYesNo(x,length = 3),None,False],             # This code indicates whether the author's approval for an entry has been received.
      'Date_author_approval': [None,returnStarDateTime,None,False],                                           # The date the author's approval is received.
      'Recvd_initial_deposition_date': [None,returnStarDateTime,None,False],                                  # The date of initial deposition. (The first message for deposition has been received.)
      'PDB_date_submitted': [None,returnStarDateTime,None,False],                                             # The date of complete deposition.  This corresponds to the date at which the PDB identifier is assigned.
      'Author_release_status_code': [None,lambda x = value: returnStarLine(x,length = 31),None,False],        # The release status authorized by the depositor.
      'Date_of_PDB_release': [None,returnStarDateTime,None,False],                                            # PDB release date. This is the date that appears in the PDB REVDAT record.
      'Date_hold_coordinates': [None,returnStarDateTime,None,False],                                          # At an author's request$ a coordinate entry may be held after processing for some period of time.
      'Date_hold_nmr_constraints': [None,returnStarDateTime,None,False],                                      # At an author's request$ the NMR constraint data may be held after processing for some period of time.
      'PDB_deposit_site': [None,lambda x = value: returnStarLine(x,length = 31),None,False],                  # The site where the file was deposited.
      'PDB_process_site': [None,lambda x = value: returnStarLine(x,length = 31),None,False],                  # The site where the file was processed.
      'BMRB_deposit_site': [None,lambda x = value: returnStarLine(x,length = 31),None,False],                 # The location where the BMRB deposition was deposited.
      'BMRB_process_site': [None,lambda x = value: returnStarLine(x,length = 31),None,False],                 # The location where the BMRB deposition was processed.
      'BMRB_annotator': [None,lambda x = value: returnStarLine(x,length = 31),None,False],                    # The name of the BMRB annotator assigned to process the deposition.
      'BMRB_internal_directory_name': [None,lambda x = value: returnStarString(x,length = 255),None,False],   # The name of the disk directory where data is stored at BMRB.
      'RCSB_annotator': [None,lambda x = value: returnStarLine(x,length = 31),None,False],                    # The name of the RCSB annotator assigned to process the deposition.
      'Author_approval_type': [None,lambda x = value: returnStarLine(x,length = 31),None,False],              # This code indicates whether the author's approval for an entry was received explicitly or implicitly. The latter is automatically implied by failure to respond to the validation summary within the prescribed period.
      'Assigned_BMRB_ID': [None,lambda x = value: returnStarCode(x,length = 12),None,False],                  # The BMRB ID assigned to the deposition.
      'Assigned_BMRB_deposition_code': [None,lambda x = value: returnStarCode(x,length = 15),None,False],     # The BMRB deposition code assigned to the deposition.
      'Assigned_PDB_ID': [None,lambda x = value: returnStarCode(x,length = 12),None,False],                   # The PDB ID assigned to the deposition.
      'Assigned_PDB_deposition_code': [None,lambda x = value: returnStarCode(x,length = 15),None,False],      # The PDB deposition code assigned to the deposition.
      'Assigned_restart_ID': [None,lambda x = value: returnStarString(x,length = 255),None,False],            # The restart ID assigned to the deposition.

            },

    'tagNames': ['Sf_category', 'Sf_framecode', 'ID', 'Title', 'Version_type', 'Submission_date', 'Accession_date', 'Last_release_date', 'Original_release_date', 'Origination', 'NMR_STAR_version', 'Original_NMR_STAR_version', 'Experimental_method', 'Experimental_method_subtype', 'Dep_release_code_coordinates', 'Dep_release_code_nmr_constraints', 'Dep_release_code_nmr_exptl', 'Dep_release_code_sequence', 'CASP_target', 'Details', 'Special_processing_instructions', 'Update_BMRB_accession_code', 'Replace_BMRB_accession_code', 'Update_PDB_accession_code', 'Replace_PDB_accession_code', 'PDB_coordinate_file_version', 'BMRB_update_details', 'PDB_update_details', 'Release_request', 'Release_date_request', 'Release_date_justification', 'Status_code', 'Recvd_deposit_form', 'Date_deposition_form', 'Recvd_coordinates', 'Date_coordinates', 'Recvd_nmr_constraints', 'Date_nmr_constraints', 'Recvd_manuscript', 'Date_manuscript', 'Recvd_author_approval', 'Date_author_approval', 'Recvd_initial_deposition_date', 'PDB_date_submitted', 'Author_release_status_code', 'Date_of_PDB_release', 'Date_hold_coordinates', 'Date_hold_nmr_constraints', 'PDB_deposit_site', 'PDB_process_site', 'BMRB_deposit_site', 'BMRB_process_site', 'BMRB_annotator', 'BMRB_internal_directory_name', 'RCSB_annotator', 'Author_approval_type', 'Assigned_BMRB_ID', 'Assigned_BMRB_deposition_code', 'Assigned_PDB_ID', 'Assigned_PDB_deposition_code', 'Assigned_restart_ID'],
    'sourcePrimaryKeys': ['ID'],

    'tables': {

      'Entry_proc_cycle': {

        'tags': {

          'Cycle_ID': [None,returnStarInt,None,True],                                                         # This is a number of the processing cycle.
          'Date_begin_cycle': [None,returnStarDateTime,None,False],                                           # This is the date of the start of the processing cycle.
          'Date_end_cycle': [None,returnStarDateTime,None,False],                                             # This is the date of the end of the processing cycle.
          'Details': [None,returnStarString,None,False],                                                      # Special details about the current processing cycle.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'

                },

        'tagNames': ['Cycle_ID', 'Date_begin_cycle', 'Date_end_cycle', 'Details', 'Entry_ID'],
        'sourcePrimaryKeys': ['Cycle_ID', 'Entry_ID'],

            },

      'Entry_prerelease_seq': {

        'tags': {

          'Entity_ID': [None,returnStarInt,'Entity.ID',True],                                                 # Pointer to '_Entity.ID'
          'Entity_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Entity.Sf_framecode',False],# STAR framecode for the entity whose residue sequence is being provided as the value to the tag '_Entry_prerelease_seq.Seq_one_letter_code'.
          'Seq_one_letter_code': [None,returnStarString,None,False],                                          # Chemical sequence expressed as a string of one-letter amino acid or nucleic acid codes.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'

                },

        'tagNames': ['Entity_ID', 'Entity_label', 'Seq_one_letter_code', 'Entry_ID'],
        'sourcePrimaryKeys': ['Entity_ID', 'Entry_ID'],

            },

      'Contact_person': {

        'tags': {

          'ID': [None,returnStarInt,None,True],                                                               # Unique identifier within the entry for the named contact person.
          'Email_address': [None,lambda x = value: returnStarFaxPhoneEmail(x,length = 127),None,True],        # Business e-mail address for the contact person.
          'Name_salutation': [None,lambda x = value: returnStarLine(x,length = 31),None,False],               # The salutation of the author of the deposition to whom correspondence should be addressed
          'Given_name': [None,lambda x = value: returnStarLine(x,length = 31),None,True],                     # The name given the contact person at birth or currently used by the author for publication purposes.  Can be an initial if the author uses a second name as a full name when publishing.
          'Family_name': [None,lambda x = value: returnStarLine(x,length = 31),None,True],                    # The family name for the contact person.
          'Middle_initials': [None,lambda x = value: returnStarCode(x,length = 15),None,False],               # The initials for the contact person's middle names.  A name can be used here if the contact person uses a middle name for publications.
          'Family_title': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                  # A common family title (not a professional title).
          'Department_and_institution': [None,lambda x = value: returnStarString(x,length = 255),None,False], # Department and institution where the contact person works.
          'Mailing_address': [None,lambda x = value: returnStarString(x,length = 255),None,False],            # A business mailing address for the contact person.
          'Address_1': [None,lambda x = value: returnStarLine(x,length = 127),None,True],                     # The mailing address of the author of the entry to whom correspondence should be addressed$ line 1 of 3.
          'Address_2': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                    # The mailing address of the author of the entry to whom correspondence should be addressed$ line 2 of 3.
          'Address_3': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                    # The mailing address of the author of the entry to whom correspondence should be addressed$ line 3 of 3.
          'City': [None,lambda x = value: returnStarLine(x,length = 31),None,True],                           # The city in the mailing address of the author of the entry to whom correspondence should be addresed.
          'State_province': [None,lambda x = value: returnStarLine(x,length = 31),None,True],                 # State or province where the contact person is located.
          'Country': [None,lambda x = value: returnStarLine(x,length = 31),None,True],                        # The country in the mailing address of the author of the entry to whom correspondence should be addresed.
          'Postal_code': [None,lambda x = value: returnStarLine(x,length = 31),None,False],                   # The postal code or zip code for the address of the contact person to whom correspondence should be addressed.
          'Phone_number': [None,lambda x = value: returnStarFaxPhoneEmail(x,length = 31),None,True],          # A business telephone number for the contact person.
          'FAX_number': [None,lambda x = value: returnStarFaxPhoneEmail(x,length = 31),None,False],           # Business FAX number for the contact person.
          'Role': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                         # The role of this author in the project depositing this data.
          'Organization_type': [None,lambda x = value: returnStarLine(x,length = 31),None,False],             # The organization type to which this author is affiliated.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'

                },

        'tagNames': ['ID', 'Email_address', 'Name_salutation', 'Given_name', 'Family_name', 'Middle_initials', 'Family_title', 'Department_and_institution', 'Mailing_address', 'Address_1', 'Address_2', 'Address_3', 'City', 'State_province', 'Country', 'Postal_code', 'Phone_number', 'FAX_number', 'Role', 'Organization_type', 'Entry_ID'],
        'sourcePrimaryKeys': ['ID', 'Entry_ID'],

            },

      'Entry_author': {

        'tags': {

          'Ordinal': [None,returnStarInt,None,True],                                                          # Integer value defining the position of the author's name in the list of authors.
          'Given_name': [None,lambda x = value: returnStarLine(x,length = 31),None,True],                     # The name given the author at birth or currently used by the author for publication purposes.  Can be an initial if the author uses a second name as a full name when publishing.
          'Family_name': [None,lambda x = value: returnStarLine(x,length = 127),None,True],                   # The family name of the author.
          'First_initial': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                 # Initial of the author's first name.
          'Middle_initials': [None,lambda x = value: returnStarCode(x,length = 15),None,False],               # The initials for the author's middle names.  A name can be used here if the author uses a middle name for publications.
          'Family_title': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                  # A common family title (not a professional title).
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'

                },

        'tagNames': ['Ordinal', 'Given_name', 'Family_name', 'First_initial', 'Middle_initials', 'Family_title', 'Entry_ID'],
        'sourcePrimaryKeys': ['Ordinal', 'Entry_ID'],

            },

      'SG_project': {

        'tags': {

          'SG_project_ID': [None,returnStarInt,None,True],                                                    # A unique integer identifier for this center
          'Project_name': [None,lambda x = value: returnStarLine(x,length = 127),None,True],                  # The value identifies the Structural Genomics project of the granting agency.
          'Full_name_of_center': [None,lambda x = value: returnStarLine(x,length = 127),None,False],          # The value identifies the full name of center.
          'Initial_of_center': [None,lambda x = value: returnStarLine(x,length = 31),None,True],              # The value identifies the center using initials or other abbreviation.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'

                },

        'tagNames': ['SG_project_ID', 'Project_name', 'Full_name_of_center', 'Initial_of_center', 'Entry_ID'],
        'sourcePrimaryKeys': ['SG_project_ID', 'Entry_ID'],

            },

      'Entry_src': {

        'tags': {

          'Project_name': [None,lambda x = value: returnStarLine(x,length = 127),None,True],                  # Name of the project under which the data reported in an entry was sponsored or funded. This might be the title for a grant funding the research or the name of the overall project defined by a granting agency.
          'Organization_full_name': [None,lambda x = value: returnStarLine(x,length = 127),None,False],       # Name of the organization (company$ research laboratory$ etc.) that carried out the research reported in the entry.
          'Organization_initials': [None,lambda x = value: returnStarLine(x,length = 127),None,True],         # Laboratory title or name or acronym for the organization where the research was conducted.  More than one organization can be provided.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'

                },

        'tagNames': ['Project_name', 'Organization_full_name', 'Organization_initials', 'Entry_ID'],
        'sourcePrimaryKeys': ['Project_name', 'Organization_initials', 'Entry_ID'],

            },

      'Struct_keywords': {

        'tags': {

          'Keywords': [None,lambda x = value: returnStarLine(x,length = 127),None,True],                      # Keywords describing the structure
          'Text': [None,returnStarString,None,False],                                                         # Keywords describing this structure.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'

                },

        'tagNames': ['Keywords', 'Text', 'Entry_ID'],
        'sourcePrimaryKeys': ['Keywords', 'Entry_ID'],

            },

      'Data_set': {

        'tags': {

          'Type': [None,lambda x = value: returnStarLine(x,length = 127),None,True],                          # The saveframe category type that contain quantitative data of the kind that is summarized in this table.  The enumerated list for this tag is a subset of the full list of saveframe categories available in constructing an NMR-STAR file.
          'Count': [None,returnStarInt,None,True],                                                            # The integer number of saveframes in the entry that are of the type given by the value to the tag '_Saveframe_category_type' in this loop.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'

                },

        'tagNames': ['Type', 'Count', 'Entry_ID'],
        'sourcePrimaryKeys': ['Type', 'Entry_ID'],

            },

      'Datum': {

        'tags': {

          'Type': [None,lambda x = value: returnStarLine(x,length = 127),None,True],                          # A type of quantitative data found in the entry.
          'Count': [None,returnStarInt,None,True],                                                            # An integer representing the total number of values of the type defined by the value to the tag '_Data_type' found in all saveframes in the current entry.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'

                },

        'tagNames': ['Type', 'Count', 'Entry_ID'],
        'sourcePrimaryKeys': ['Type', 'Entry_ID'],

            },

      'Release': {

        'tags': {

          'Release_number': [None,returnStarInt,None,True],                                                   # Unique code assigned to each release of an entry
          'Date': [None,returnStarDateTime,None,True],                                                        # Date entry was released.
          'Submission_date': [None,returnStarDateTime,None,False],                                            # Date the entry or an update to the entry was submitted to BMRB.
          'Type': [None,lambda x = value: returnStarLine(x,length = 31),None,True],                           # Value describing with a key word the type of entry that was released.
          'Author': [None,lambda x = value: returnStarLine(x,length = 31),None,True],                         # A keyword indicating the type of author of the release.
          'Detail': [None,returnStarString,None,False],                                                       # Text describing the changes made to the entry.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'

                },

        'tagNames': ['Release_number', 'Date', 'Submission_date', 'Type', 'Author', 'Detail', 'Entry_ID'],
        'sourcePrimaryKeys': ['Release_number', 'Entry_ID'],

            },

      'Related_entries': {

        'tags': {

          'Database_name': [None,lambda x = value: returnStarLine(x,length = 31),None,True],                  # List of accession numbers for BMRB entries that are in someway related to the current entry.
          'Database_accession_code': [None,lambda x = value: returnStarCode(x,length = 31),None,True],        # Enter the entry code for an already existing BMRB or PDB entry.
          'Relationship': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                 # Text describing the relationship between the current BMRB entry and the entry with the corresponding BMRB accession number given as a value to the tag '_Related_BMRB_accession_number.'
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'

                },

        'tagNames': ['Database_name', 'Database_accession_code', 'Relationship', 'Entry_ID'],
        'sourcePrimaryKeys': ['Database_name', 'Database_accession_code', 'Entry_ID'],

            }

        },

    'tableNames': ['Entry_proc_cycle', 'Entry_prerelease_seq', 'Contact_person', 'Entry_author', 'SG_project', 'Entry_src', 'Struct_keywords', 'Data_set', 'Datum', 'Release', 'Related_entries']

    },

  'citations': {

    'name': 'Citation',

    'tags': {

      'Sf_category': ['citations',lambda x = value: returnStarCode(x,length = 127),None,True],                # Category assigned to the information in the saveframe.
      'Sf_framecode': [None,lambda x = value: returnStarCode(x,length = 127),None,False],                     # A label that uniquely identifies the citation from other citations in the entry.
      'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                     # Pointer to '_Entry.ID'
      'ID': [None,returnStarInt,None,True],                                                                   # A value that uniquely identifies the citation from all other citations provided in the entry.
      'Class': [None,lambda x = value: returnStarLine(x,length = 31),None,True],                              # Keyword defining the citation as the key citation for the entry or a citation used as a referenece in the entry.
      'CAS_abstract_code': [None,lambda x = value: returnStarCode(x,length = 31),None,False],                 # Code from the Chemical Abstract Services assigned to this citation.
      'MEDLINE_UI_code': [None,lambda x = value: returnStarCode(x,length = 31),None,False],                   # MEDLINE uniform identification code assigned to the publication described in the saveframe.
      'DOI': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                              # The digital object identifier assigned to the citation.
      'PubMed_ID': [None,lambda x = value: returnStarCode(x,length = 12),None,False],                         # The identification code assigned to the publication by PubMed.  If this code is available no other information regarding the publication needs to be entered in the deposition.
      'Full_citation': [None,returnStarString,None,False],                                                    # Full publication citation including authors title journal page numbers year or equivalent information for the type of publication given.
      'Title': [None,returnStarString,None,False],                                                            # Title for the publication.
      'Status': [None,lambda x = value: returnStarLine(x,length = 31),None,False],                            # Status for the current publication (in preparation submitted in press published)
      'Type': [None,lambda x = value: returnStarLine(x,length = 31),None,False],                              # Descriptive word that defines the kind of publication reported (journal; book; thesis; etc.)
      'Journal_abbrev': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                   # Standard abbreviation for journals used by the Chemical Abstract Services.  Depositors are required to provide a value for this field.  If the data in the deposition are related to a JBNMR paper$ the value must be 'J. Biol. NMR' to alert the BMRB annotators so that the deposition is properly processed.  If the depositor truly does not know the journal a value of 'not known' is acceptable.
      'Journal_name_full': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                # Full name used by the journal.
      'Journal_volume': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                    # Volume designation used by the journal.
      'Journal_issue': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                     # Issue designation used by the journal.
      'Journal_ASTM': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                     # ASTM identification code for the journal.
      'Journal_ISSN': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                     # An International Standard Serial Number (ISSN) is a unique eight-digit number used to identify a print or electronic periodical publication.
      'Journal_CSD': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                      # CSD identification code for the journal.
      'Book_title': [None,lambda x = value: returnStarString(x,length = 255),None,False],                     # The name of the book where the citation is located.
      'Book_chapter_title': [None,lambda x = value: returnStarString(x,length = 255),None,False],             # Title of the chapter from the book
      'Book_volume': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                       # Volume designation for the book.
      'Book_series': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                       # Series designation for the book
      'Book_publisher': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                   # Publisher of the book
      'Book_publisher_city': [None,lambda x = value: returnStarLine(x,length = 127),None,False],              # City where the book publisher is located
      'Book_ISBN': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                        # ISBN code assigned to the book.
      'Conference_title': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                 # Title of the conference
      'Conference_site': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                  # Site of the conference$ city$ resort$ etc.
      'Conference_state_province': [None,lambda x = value: returnStarLine(x,length = 127),None,False],        # State$ province$ etc. where conference took place
      'Conference_country': [None,lambda x = value: returnStarLine(x,length = 127),None,False],               # Country where conference was located
      'Conference_start_date': [None,returnStarDateTime,None,False],                                          # Date conference began
      'Conference_end_date': [None,returnStarDateTime,None,False],                                            # Date conference ended
      'Conference_abstract_number': [None,lambda x = value: returnStarLine(x,length = 127),None,False],       # Code assigned to the conference abstract
      'Thesis_institution': [None,lambda x = value: returnStarLine(x,length = 127),None,False],               # Academic or research institution that granted the degree awarded for the thesis cited in the saveframe.
      'Thesis_institution_city': [None,lambda x = value: returnStarLine(x,length = 127),None,False],          # City where the institution awarding the degree is located.
      'Thesis_institution_country': [None,lambda x = value: returnStarLine(x,length = 127),None,False],       # Country where the institution awarding the degree is located.
      'WWW_URL': [None,returnStarString,None,False],                                                          # A World Wide Web universal locator that identifies the location of the cited material on the WWW.
      'Page_first': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                        # First page of the published article
      'Page_last': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                         # Last page of the published article
      'Year': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                              # Calendar year when the article was published.
      'Details': [None,returnStarString,None,False],                                                          # Additional information relevant to the data in the current saveframe or to a specific data item is entered as a value to this tag.  The information entered must supplement information already present.  Whenever possible data should associated with specific data tags and not included in the value to a '_Details' tag.

            },

    'tagNames': ['Sf_category', 'Sf_framecode', 'Entry_ID', 'ID', 'Class', 'CAS_abstract_code', 'MEDLINE_UI_code', 'DOI', 'PubMed_ID', 'Full_citation', 'Title', 'Status', 'Type', 'Journal_abbrev', 'Journal_name_full', 'Journal_volume', 'Journal_issue', 'Journal_ASTM', 'Journal_ISSN', 'Journal_CSD', 'Book_title', 'Book_chapter_title', 'Book_volume', 'Book_series', 'Book_publisher', 'Book_publisher_city', 'Book_ISBN', 'Conference_title', 'Conference_site', 'Conference_state_province', 'Conference_country', 'Conference_start_date', 'Conference_end_date', 'Conference_abstract_number', 'Thesis_institution', 'Thesis_institution_city', 'Thesis_institution_country', 'WWW_URL', 'Page_first', 'Page_last', 'Year', 'Details'],
    'sourcePrimaryKeys': ['Entry_ID', 'ID'],

    'tables': {

      'Citation_author': {

        'tags': {

          'Ordinal': [None,returnStarInt,None,True],                                                          # Integer value defining the position of the author's name in the list of authors.
          'Given_name': [None,lambda x = value: returnStarLine(x,length = 31),None,False],                    # The name given the author at birth or currently used by the author for publication purposes.  Can be an initial if the author uses a second name as a full name when publishing.
          'Family_name': [None,lambda x = value: returnStarLine(x,length = 31),None,True],                    # The family name of the author.
          'First_initial': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                 # Initial of the author's first name.
          'Middle_initials': [None,lambda x = value: returnStarCode(x,length = 15),None,False],               # The initials for the author's middle names.  A name can be used here$ if the author uses a middle name for publications.
          'Family_title': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                  # A common family title (not a professional title).
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Citation_ID': [None,returnStarInt,'Citation.ID',True],                                             # Pointer to '_Citation.ID'

                },

        'tagNames': ['Ordinal', 'Given_name', 'Family_name', 'First_initial', 'Middle_initials', 'Family_title', 'Entry_ID', 'Citation_ID'],
        'sourcePrimaryKeys': ['Ordinal', 'Entry_ID', 'Citation_ID'],

            },

      'Citation_keyword': {

        'tags': {

          'Keyword': [None,lambda x = value: returnStarLine(x,length = 127),None,True],                       # A single word or very brief phrase that characterizes the citation.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Citation_ID': [None,returnStarInt,'Citation.ID',True],                                             # Pointer to '_Citation.ID'

                },

        'tagNames': ['Keyword', 'Entry_ID', 'Citation_ID'],
        'sourcePrimaryKeys': ['Keyword', 'Entry_ID', 'Citation_ID'],

            },

      'Citation_editor': {

        'tags': {

          'Ordinal': [None,returnStarInt,None,True],                                                          # Integer value defining the position of the editor's name in the list of editors.
          'Given_name': [None,lambda x = value: returnStarLine(x,length = 31),None,True],                     # The name given the editor at birth or currently used by the editor for publication purposes.  Can be an initial if the editor uses a second name as a full name when publishing.
          'Family_name': [None,lambda x = value: returnStarLine(x,length = 31),None,True],                    # The family name of the editor.
          'First_initial': [None,lambda x = value: returnStarLine(x,length = 15),None,False],                 # The editor's initial for their first name.
          'Middle_initials': [None,lambda x = value: returnStarLine(x,length = 15),None,False],               # The initials for the editor's middle names.  A name can be used here$ if the editor uses a middle name for publications.
          'Family_title': [None,lambda x = value: returnStarLine(x,length = 15),None,False],                  # A common family title (not a professional title).
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Citation_ID': [None,returnStarInt,'Citation.ID',True],                                             # Pointer to '_Citation.ID'

                },

        'tagNames': ['Ordinal', 'Given_name', 'Family_name', 'First_initial', 'Middle_initials', 'Family_title', 'Entry_ID', 'Citation_ID'],
        'sourcePrimaryKeys': ['Ordinal', 'Entry_ID', 'Citation_ID'],

            }

        },

    'tableNames': ['Citation_author', 'Citation_keyword', 'Citation_editor']

    },

  'assembly': {

    'name': 'Assembly',

    'tags': {

      'Sf_category': ['assembly',lambda x = value: returnStarCode(x,length = 127),None,True],                 # Category assigned to the information in the saveframe.
      'Sf_framecode': [None,lambda x = value: returnStarCode(x,length = 127),None,False],                     # A descriptive label for the molecular assembly studied.
      'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                     # Pointer to '_Entry.ID'
      'ID': [None,returnStarInt,None,True],                                                                   # A code that uniquely identifies the molecular assembly described in the saveframe.
      'Name': [None,lambda x = value: returnStarLine(x,length = 127),None,True],                              # Brief descriptive name for the molecular assembly studied.
      'BMRB_code': [None,lambda x = value: returnStarCode(x,length = 12),None,False],                         # Unique identifier for the molecular system in the BMRB library of molecular system definitions.
      'Number_of_components': [None,returnStarInt,None,False],                                                # An integer that represents the total number of molecular components that comprise the molecular system.
      'Organic_ligands': [None,returnStarInt,None,False],                                                     # Total number of organic ligands known to exist in the full molecular system.
      'Metal_ions': [None,returnStarInt,None,False],                                                          # Total number of metal ions known to exist in the molecular system
      'Non_standard_bonds': [None,lambda x = value: returnStarYesNo(x,length = 3),None,False],                # The molecular assembly contains covalent bonds such as cross-linking disulfide bonds; non-standard residue-residue bonds; ligand-residue bonds; or metal coordination bonds.
      'Ambiguous_conformational_states': [None,lambda x = value: returnStarYesNo(x,length = 3),None,False],   # A yes/no flag automatically filled in by BMRB software on the basis of the information (tag _Molecule_ambiguous conformational_states) provided in the saveframes used to described the molecules in the system.
      'Ambiguous_chem_comp_sites': [None,lambda x = value: returnStarYesNo(x,length = 3),None,False],         # A yes/no flag automatically filled in by BMRB software on the basis of information (tag _Mol_ambiguous_moiety_sites) provided in the saveframes used to described the molecules in the system.
      'Molecules_in_chemical_exchange': [None,lambda x = value: returnStarYesNo(x,length = 3),None,False],    # A yes/no flag that indicates when two molecular components in the system are in chemical exchange (I.e. a ligand that exists in both the free and bound state).
      'Paramagnetic': [None,lambda x = value: returnStarYesNo(x,length = 3),None,True],                       # A Yes or No flag used to describe whether the system is paramagnetic.
      'Thiol_state': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                      # Description of the state of the thiol groups in the molecular system.
      'Molecular_mass': [None,returnStarFloat,None,False],                                                    # Mass of the molecular system in Daltons.  This value may be approximate.
      'Enzyme_commission_number': [None,lambda x = value: returnStarLine(x,length = 127),None,False],         # The Enzyme Commission decimal code (number) assigned to the protein or molecular assembly$ if available.
      'Details': [None,returnStarString,None,False],                                                          # Text description for the molecular system studied.
      'DB_query_date': [None,returnStarDateTime,None,False],                                                  # Date the database was queried to derive links to the molecular assembly studied.  GenBank is the database queried for these links.
      'DB_query_revised_last_date': [None,returnStarDateTime,None,False],                                     # The last date when new links to the molecular assembly were found through the database query.

            },

    'tagNames': ['Sf_category', 'Sf_framecode', 'Entry_ID', 'ID', 'Name', 'BMRB_code', 'Number_of_components', 'Organic_ligands', 'Metal_ions', 'Non_standard_bonds', 'Ambiguous_conformational_states', 'Ambiguous_chem_comp_sites', 'Molecules_in_chemical_exchange', 'Paramagnetic', 'Thiol_state', 'Molecular_mass', 'Enzyme_commission_number', 'Details', 'DB_query_date', 'DB_query_revised_last_date'],
    'sourcePrimaryKeys': ['Entry_ID', 'ID'],

    'tables': {

      'Assembly_type': {

        'tags': {

          'Type': [None,lambda x = value: returnStarLine(x,length = 127),None,True],                          # Enumerated list of brief descriptive phrases that provide a loose way of classifying the system.  A system may fit more than one item in the list and all appropriate values may be used for any specific system.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Assembly_ID': [None,returnStarInt,'Assembly.ID',True],                                             # Pointer to '_Assembly.ID'

                },

        'tagNames': ['Type', 'Entry_ID', 'Assembly_ID'],
        'sourcePrimaryKeys': ['Type', 'Entry_ID', 'Assembly_ID'],

            },

      'Entity_assembly': {

        'tags': {

          'ID': [None,returnStarInt,None,True],                                                               # Unique identifier for each component in the entity assembly.
          'Entity_assembly_name': [None,lambda x = value: returnStarLine(x,length = 127),None,False],         # Name for this molecular component of the molecular assembly
          'Entity_ID': [None,returnStarInt,'Entity.ID',True],                                                 # Pointer to '_Entity.ID'
          'Entity_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Entity.Sf_framecode',False],# This value points to the section of the entry where the chemical description is given for all assembly components of this type.  For a homodimer a chemical description of the monomer is given only once and is pointed to by this value although the assembly contains two monomers.
          'Asym_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Struct_asym.ID',False],           # Pointer to '_Struct_asym.ID'
          'PDB_chain_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                  # PDB chain ID.
          'Experimental_data_reported': [None,lambda x = value: returnStarYesNo(x,length = 3),None,False],    # A flag indicating whether experimental data for a specific component of the assembly is reported.
          'Physical_state': [None,lambda x = value: returnStarLine(x,length = 127),None,False],               # An enumerated list of descriptive terms used to define the conformational state of the component of the assembly.
          'Conformational_isomer': [None,lambda x = value: returnStarYesNo(x,length = 3),None,True],          # A flag indicating whether the component of the system is a conformational isomer of another component of the system.
          'Chemical_exchange_state': [None,lambda x = value: returnStarYesNo(x,length = 3),None,True],        # A flag indicating whether the component of the system is in chemical exchange with another component of the system.
          'Magnetic_equivalence_group_code': [None,lambda x = value: returnStarCode(x,length = 15),None,False],# Unique identifier for the group of assembly components within the assembly that are magnetically equivalent in that only one set of NMR peaks are observed for the group.
          'Role': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                         # The function of the asembly component within the assembly.
          'Details': [None,returnStarString,None,False],                                                      # Text information describing the component of the assembly that is pertinent to the component as found in the assembly.  Specific details about the entity are given in the entity category.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Assembly_ID': [None,returnStarInt,'Assembly.ID',True],                                             # Pointer to '_Assembly.ID'

                },

        'tagNames': ['ID', 'Entity_assembly_name', 'Entity_ID', 'Entity_label', 'Asym_ID', 'PDB_chain_ID', 'Experimental_data_reported', 'Physical_state', 'Conformational_isomer', 'Chemical_exchange_state', 'Magnetic_equivalence_group_code', 'Role', 'Details', 'Entry_ID', 'Assembly_ID'],
        'sourcePrimaryKeys': ['ID', 'Entry_ID', 'Assembly_ID'],

            },

      'Bond': {

        'tags': {

          'ID': [None,returnStarInt,None,True],                                                               # Unique identifier for the bond being defined.
          'Type': [None,lambda x = value: returnStarLine(x,length = 127),None,True],                          # A descriptive phrase or word that characterized the bond.
          'Order': [None,lambda x = value: returnStarLine(x,length = 127),None,True],                         # The order of the bond between two atoms (i.e.$ single$ double$ etc.)
          'Assembly_atom_ID_1': [None,returnStarInt,'Atom.Assembly_atom_ID',False],                           # Pointer to '_Atom.Assembly_atom_ID'
          'Entity_assembly_ID_1': [None,returnStarInt,'Entity_assembly.ID',True],                             # Pointer to '_Entity_assembly.ID'
          'Entity_assembly_name_1': [None,lambda x = value: returnStarLine(x,length = 127),'Entity_assembly.Entity_assembly_name',False],# Pointer to '_Entity_assembly.Entity_assembly_name'
          'Entity_ID_1': [None,returnStarInt,'Entity.ID',True],                                               # Pointer to '_Entity.ID'
          'Comp_ID_1': [None,lambda x = value: returnStarCode(x,length = 12),'Chem_comp.ID',True],            # Pointer to '_Chem_comp.ID'
          'Comp_index_ID_1': [None,returnStarInt,'Entity_comp_index.ID',True],                                # Pointer to '_Entity_comp_index.ID'
          'Seq_ID_1': [None,returnStarInt,'Entity_poly_seq.Num',True],                                        # Pointer to '_Entity_poly_seq.Num'
          'Atom_ID_1': [None,lambda x = value: returnStarAtCode(x,length = 12),'Chem_comp_atom.Atom_ID',True],# Pointer to '_Chem_comp_atom.Atom_ID'
          'Assembly_atom_ID_2': [None,returnStarInt,'Atom.Assembly_atom_ID',False],                           # Pointer to '_Atom.Assembly_atom_ID'
          'Entity_assembly_ID_2': [None,returnStarInt,'Entity_assembly.ID',True],                             # Pointer to '_Entity_assembly.ID'
          'Entity_assembly_name_2': [None,lambda x = value: returnStarLine(x,length = 127),'Entity_assembly.Entity_assembly_name',False],# Pointer to '_Entity_assembly.Entity_assembly_name'
          'Entity_ID_2': [None,returnStarInt,'Entity.ID',True],                                               # Pointer to '_Entity.ID'
          'Comp_ID_2': [None,lambda x = value: returnStarCode(x,length = 12),'Chem_comp.ID',True],            # Pointer to '_Chem_comp.ID'
          'Comp_index_ID_2': [None,returnStarInt,'Entity_comp_index.ID',True],                                # Pointer to '_Entity_comp_index.ID'
          'Seq_ID_2': [None,returnStarInt,'Entity_poly_seq.Num',True],                                        # Pointer to '_Entity_poly_seq.Num'
          'Atom_ID_2': [None,lambda x = value: returnStarAtCode(x,length = 12),'Chem_comp_atom.Atom_ID',True],# Pointer to '_Chem_comp_atom.Atom_ID'
          'Auth_entity_assembly_ID_1': [None,lambda x = value: returnStarLine(x,length = 127),None,False],    # Enter the name given to the biopolymer or ligand as a component of the molecular system where the first atom in the bond is located. For complex systems that have many components$ this might be something like 'alpha chain 1' or 'heme 3'. A pull down list of the names assigned to the molecular system components in the section above is provided.
          'Auth_entity_assembly_name_1': [None,lambda x = value: returnStarLine(x,length = 127),None,False],  # Enter the name given to the biopolymer or ligand as a component of the molecular system where the first atom in the bond is located. For complex systems that have many components$ this might be something like 'alpha chain 1' or 'heme 3'. A pull down list of the names assigned to the molecular system components in the section above is provided.
          'Auth_seq_ID_1': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                 # An alternative identifier for Seq_id that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Seq_ID or Comp_index_ID.
          'Auth_comp_ID_1': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                # An alternative identifier for Comp_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Auth_atom_ID_1': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                # An alternative identifier for Atom_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Auth_entity_assembly_ID_2': [None,lambda x = value: returnStarLine(x,length = 127),None,False],    # Enter the name given to the biopolymer or ligand as a component of the molecular system where the second atom in the bond is located. For complex systems that have many components$ this might be something like 'alpha chain 1' or 'heme 3'. A pull down list of the names assigned to the molecular system components in the section above is provided.
          'Auth_entity_assembly_name_2': [None,lambda x = value: returnStarLine(x,length = 127),None,False],  # Enter the name given to the biopolymer or ligand as a component of the molecular system where the second atom in the bond is located. For complex systems that have many components$ this might be something like 'alpha chain 1' or 'heme 3'. A pull down list of the names assigned to the molecular system components in the section above is provided.
          'Auth_seq_ID_2': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                 # An alternative identifier for Seq_id that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Seq_ID or Comp_index_ID.
          'Auth_comp_ID_2': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                # An alternative identifier for Comp_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Auth_atom_ID_2': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                # An alternative identifier for Atom_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Assembly_ID': [None,returnStarInt,'Assembly.ID',True],                                             # Pointer to '_Assembly.ID'

                },

        'tagNames': ['ID', 'Type', 'Order', 'Assembly_atom_ID_1', 'Entity_assembly_ID_1', 'Entity_assembly_name_1', 'Entity_ID_1', 'Comp_ID_1', 'Comp_index_ID_1', 'Seq_ID_1', 'Atom_ID_1', 'Assembly_atom_ID_2', 'Entity_assembly_ID_2', 'Entity_assembly_name_2', 'Entity_ID_2', 'Comp_ID_2', 'Comp_index_ID_2', 'Seq_ID_2', 'Atom_ID_2', 'Auth_entity_assembly_ID_1', 'Auth_entity_assembly_name_1', 'Auth_seq_ID_1', 'Auth_comp_ID_1', 'Auth_atom_ID_1', 'Auth_entity_assembly_ID_2', 'Auth_entity_assembly_name_2', 'Auth_seq_ID_2', 'Auth_comp_ID_2', 'Auth_atom_ID_2', 'Entry_ID', 'Assembly_ID'],
        'sourcePrimaryKeys': ['ID', 'Entry_ID', 'Assembly_ID'],

            },

      'Entity_deleted_atom': {

        'tags': {

          'Entity_atom_list_ID': [None,returnStarInt,'Entity_atom_list.ID',True],                             # Pointer to '_Entity_atom_list.ID'
          'Entity_assembly_ID': [None,returnStarInt,'Entity_assembly.ID',True],                               # Pointer to '_Entity_assembly.ID'
          'Entity_ID': [None,returnStarInt,'Entity.ID',False],                                                # Pointer to '_Entity.ID'
          'Comp_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Chem_comp.ID',False],             # Pointer to '_Chem_comp.ID'
          'Comp_index_ID': [None,returnStarInt,'Entity_comp_index.ID',False],                                 # Pointer to '_Entity_comp_index.ID'
          'Seq_ID': [None,returnStarInt,'Entity_poly_seq.Num',False],                                         # Pointer to '_Entity_poly_seq.Num'.
          'Atom_ID': [None,lambda x = value: returnStarAtCode(x,length = 12),'Chem_comp_atom.Atom_ID',False], # Pointer to '_Chem_comp_atom.Atom_ID'
          'Auth_entity_assembly_ID': [None,lambda x = value: returnStarCode(x,length = 12),None,False],       # An alternative identifier for Entity_assembly_ID that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Entity_assembly_ID.
          'Auth_seq_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                   # An alternative identifier for Seq_id that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Seq_ID or Comp_index_ID.
          'Auth_comp_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                  # An alternative identifier for Comp_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Auth_atom_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                  # An alternative identifier for Atom_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Assembly_ID': [None,returnStarInt,'Assembly.ID',True],                                             # Pointer to '_Assembly.ID'

                },

        'tagNames': ['Entity_atom_list_ID', 'Entity_assembly_ID', 'Entity_ID', 'Comp_ID', 'Comp_index_ID', 'Seq_ID', 'Atom_ID', 'Auth_entity_assembly_ID', 'Auth_seq_ID', 'Auth_comp_ID', 'Auth_atom_ID', 'Entry_ID', 'Assembly_ID'],
        'sourcePrimaryKeys': ['Entity_atom_list_ID', 'Entity_assembly_ID', 'Entry_ID', 'Assembly_ID'],

            },

      'Deleted_atom': {

        'tags': {

          'ID': [None,returnStarInt,None,True],                                                               # Unique identifier used to index the rows of deleted atoms.
          'Assembly_atom_ID': [None,returnStarInt,'Atom.Assembly_atom_ID',False],                             # Pointer to '_Atom.Assembly_atom_ID'
          'Entity_assembly_ID': [None,returnStarInt,'Entity_assembly.ID',True],                               # Pointer to '_Entity_assembly.ID'
          'Entity_assembly_name': [None,lambda x = value: returnStarLine(x,length = 127),None,True],          # Provide the name given to the molecule in the molecular assembly where the deleted atom is located.  There may be several identical biopolymers in the system$ but the one where the specific atom has been deleted needs to be specified.  If the same atom is missing from multiple polymers in the system$ a row in this table needs to be created for each deleted atom.  In this way a complete and accurate chemical structure for the molecular system can be constructed.
          'Entity_ID': [None,returnStarInt,'Entity.ID',True],                                                 # Pointer to '_Entity.ID'
          'Entity_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Entity.Sf_framecode',True],# Pointer to a saveframe of the category 'entity'
          'Comp_index_ID': [None,returnStarInt,'Entity_comp_index.ID',True],                                  # Pointer to '_Entity_comp_index.ID'
          'Seq_ID': [None,returnStarInt,'Entity_poly_seq.Num',True],                                          # Pointer to '_Entity_poly_seq.Num'
          'Comp_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Chem_comp.ID',True],              # Pointer to '_Chem_comp.ID'
          'Comp_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Chem_comp.Sf_framecode',True],# Pointer to a saveframe of the category 'chem_comp'
          'Atom_ID': [None,lambda x = value: returnStarAtCode(x,length = 12),'Chem_comp_atom.Atom_ID',True],  # Pointer to '_Chem_comp_atom.Atom_ID'
          'Auth_entity_assembly_ID': [None,lambda x = value: returnStarCode(x,length = 12),None,False],       # An alternative identifier for Entity_assembly_ID that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Entity_assembly_ID.
          'Auth_seq_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                   # An alternative identifier for Seq_id that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Seq_ID or Comp_index_ID.
          'Auth_comp_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                  # An alternative identifier for Comp_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Auth_atom_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                  # An alternative identifier for Atom_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Atom_type': [None,lambda x = value: returnStarCode(x,length = 15),None,True],                      # Standard symbol used to define the atom element type.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Assembly_ID': [None,returnStarInt,'Assembly.ID',True],                                             # Pointer to '_Assembly.ID'

                },

        'tagNames': ['ID', 'Assembly_atom_ID', 'Entity_assembly_ID', 'Entity_assembly_name', 'Entity_ID', 'Entity_label', 'Comp_index_ID', 'Seq_ID', 'Comp_ID', 'Comp_label', 'Atom_ID', 'Auth_entity_assembly_ID', 'Auth_seq_ID', 'Auth_comp_ID', 'Auth_atom_ID', 'Atom_type', 'Entry_ID', 'Assembly_ID'],
        'sourcePrimaryKeys': ['ID', 'Entry_ID', 'Assembly_ID'],

            },

      'Struct_asym': {

        'tags': {

          'ID': [None,lambda x = value: returnStarCode(x,length = 12),None,True],                             # The value of '_Struct_asym.ID' must uniquely identify a record in the STRUCT_ASYM list. Note that this item need not be a number; it can be any unique identifier.
          'Entity_ID': [None,returnStarInt,'Entity.ID',True],                                                 # Pointer to '_Entity.ID'
          'PDBX_blank_PDB_chainid_flag': [None,lambda x = value: returnStarYesNo(x,length = 3),None,False],   # A flag indicating that this entity was originally labeled with a blank PDB chain id.
          'PDBX_modified': [None,lambda x = value: returnStarYesNo(x,length = 3),None,False],                 # This data item indicates whether the structural elements are modified.
          'Details': [None,returnStarString,None,False],                                                      # A description of special aspects of this portion of the contents of the asymmetric unit.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Assembly_ID': [None,returnStarInt,'Assembly.ID',True],                                             # Pointer to '_Assembly.ID'

                },

        'tagNames': ['ID', 'Entity_ID', 'PDBX_blank_PDB_chainid_flag', 'PDBX_modified', 'Details', 'Entry_ID', 'Assembly_ID'],
        'sourcePrimaryKeys': ['ID', 'Entry_ID', 'Assembly_ID'],

            },

      'Assembly_db_link': {

        'tags': {

          'Author_supplied': [None,lambda x = value: returnStarYesNo(x,length = 3),None,True],                # Flag indicating if the database accession number was supplied by the author .
          'Database_code': [None,lambda x = value: returnStarLine(x,length = 127),None,True],                 # Abbreviation for the database
          'Accession_code': [None,lambda x = value: returnStarCode(x,length = 31),None,True],                 # Accession code for the entry in the database.
          'Entry_mol_code': [None,lambda x = value: returnStarLine(x,length = 127),None,False],               # Code given to the molecule by the database where the entry is located.
          'Entry_mol_name': [None,lambda x = value: returnStarLine(x,length = 127),None,False],               # Name of the molecular assembly in the database entry.
          'Entry_experimental_method': [None,lambda x = value: returnStarLine(x,length = 127),None,False],    # Experimental method used to generate the data in the database entry.
          'Entry_structure_resolution': [None,returnStarFloat,None,False],                                    # The resolution of the data in a structure entry.
          'Entry_relation_type': [None,lambda x = value: returnStarLine(x,length = 127),None,False],          # Relationship between the database entry and this BMRB entry.
          'Entry_details': [None,returnStarString,None,False],                                                # Any text information relevant to the database entry.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Assembly_ID': [None,returnStarInt,'Assembly.ID',True],                                             # Pointer to '_Assembly.ID'

                },

        'tagNames': ['Author_supplied', 'Database_code', 'Accession_code', 'Entry_mol_code', 'Entry_mol_name', 'Entry_experimental_method', 'Entry_structure_resolution', 'Entry_relation_type', 'Entry_details', 'Entry_ID', 'Assembly_ID'],
        'sourcePrimaryKeys': ['Database_code', 'Accession_code', 'Entry_ID', 'Assembly_ID'],

            },

      'Assembly_common_name': {

        'tags': {

          'Name': [None,lambda x = value: returnStarLine(x,length = 127),None,True],                          # Synonyms commonly used to name the molecular assembly.
          'Type': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                         # Common names may have different types (full names$ abbreviations$ etc.)
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Assembly_ID': [None,returnStarInt,'Assembly.ID',True],                                             # Pointer to '_Assembly.ID'

                },

        'tagNames': ['Name', 'Type', 'Entry_ID', 'Assembly_ID'],
        'sourcePrimaryKeys': ['Name', 'Entry_ID', 'Assembly_ID'],

            },

      'Assembly_systematic_name': {

        'tags': {

          'Name': [None,lambda x = value: returnStarLine(x,length = 127),None,True],                          # Name for the molecular assembly that has been assigned by an organization or derived using rules defined by an organization recognized by the scientific community.
          'Naming_system': [None,lambda x = value: returnStarLine(x,length = 127),None,True],                 # A recognized or common systematic method used to name molecules and molecular systems.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Assembly_ID': [None,returnStarInt,'Assembly.ID',True],                                             # Pointer to '_Assembly.ID'

                },

        'tagNames': ['Name', 'Naming_system', 'Entry_ID', 'Assembly_ID'],
        'sourcePrimaryKeys': ['Naming_system', 'Entry_ID', 'Assembly_ID'],

            },

      'Assembly_interaction': {

        'tags': {

          'ID': [None,returnStarInt,None,True],                                                               # Unique identifier for the interaction between two components of the assembly.
          'Entity_assembly_ID_1': [None,returnStarInt,'Entity_assembly.ID',True],                             # Identifier for the first component of the assembly that is involved interaction.  Pointer to '_Entity_assembly.ID'
          'Entity_assembly_ID_2': [None,returnStarInt,'Entity_assembly.ID',True],                             # Identifier for the second component of the assembly involved in the interaction.  Pointer to '_Entity_assembly.ID'
          'Mol_interaction_type': [None,lambda x = value: returnStarLine(x,length = 127),None,True],          # covalent- noncovalent/coordination- confromational/configurational exchange- chemical exchange
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Assembly_ID': [None,returnStarInt,'Assembly.ID',True],                                             # Pointer to '_Assembly.ID'

                },

        'tagNames': ['ID', 'Entity_assembly_ID_1', 'Entity_assembly_ID_2', 'Mol_interaction_type', 'Entry_ID', 'Assembly_ID'],
        'sourcePrimaryKeys': ['ID', 'Entry_ID', 'Assembly_ID'],

            },

      'Chem_comp_assembly': {

        'tags': {

          'Assembly_chem_comp_ID': [None,lambda x = value: returnStarCode(x,length = 12),None,False],         # A sequence number from a sequence numbering scheme employed because of a requirement of a software applications.
          'Entity_assembly_ID': [None,returnStarInt,'Entity_assembly.ID',True],                               # Pointer to '_Entity_assembly.ID'
          'Entity_ID': [None,returnStarInt,'Entity.ID',False],                                                # Pointer to '_Entity.ID'
          'Comp_index_ID': [None,returnStarInt,'Entity_comp_index.ID',True],                                  # Pointer to '_Entity_comp_index.ID'
          'Comp_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Chem_comp.ID',False],             # Pointer to '_Chem_comp.ID'
          'Seq_ID': [None,returnStarInt,'Entity_poly_seq.Num',True],                                          # Pointer to '_Entity_poly_seq.Num'
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Assembly_ID': [None,returnStarInt,'Assembly.ID',True],                                             # Pointer to '_Assembly.ID'

                },

        'tagNames': ['Assembly_chem_comp_ID', 'Entity_assembly_ID', 'Entity_ID', 'Comp_index_ID', 'Comp_ID', 'Seq_ID', 'Entry_ID', 'Assembly_ID'],
        'sourcePrimaryKeys': ['Entity_assembly_ID', 'Comp_index_ID', 'Entry_ID', 'Assembly_ID'],

            },

      'PDBX_poly_seq_scheme': {

        'tags': {

          'Entity_assembly_ID': [None,returnStarInt,'Entity_assembly.ID',True],                               # Pointer to '_Entity_assembly.ID'
          'Entity_ID': [None,returnStarInt,'Entity.ID',False],                                                # Pointer to '_Entity.ID'
          'Comp_index_ID': [None,returnStarInt,'Entity_comp_index.ID',True],                                  # Pointer to '_Entity_comp_index.ID'
          'Comp_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Chem_comp.ID',True],              # Pointer to '_Chem_comp.ID'
          'Comp_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Chem_comp.Sf_framecode',True],# Pointer to a saveframe of the category chem_comp.
          'Asym_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Struct_asym.ID',False],           # Pointer to '_Struct_asym.ID'
          'Seq_ID': [None,returnStarInt,'Entity_poly_seq.Num',True],                                          # Pointer to '_Entity_poly_seq.Num'
          'Mon_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entity_poly_seq.Mon_ID',False],    # Pointer to '_Entity_poly_seq.Mon_ID'
          'Hetero': [None,lambda x = value: returnStarCode(x,length = 3),None,False],                         # Flag indicating if the sequence is heterogeneous at the position.
          'PDB_seq_num': [None,lambda x = value: returnStarCode(x,length = 12),None,False],                   # PDB residue number.
          'PDB_mon_ID': [None,lambda x = value: returnStarCode(x,length = 12),None,False],                    # PDB residue name.
          'PDB_chain_ID': [None,lambda x = value: returnStarCode(x,length = 12),None,False],                  # PDB strand/chain id.
          'PDB_ins_code': [None,lambda x = value: returnStarCode(x,length = 12),None,False],                  # PDB insertion code.
          'Auth_seq_num': [None,lambda x = value: returnStarCode(x,length = 12),'Atom_site.Auth_seq_ID',False],# Pointer to '_Atom_site.Auth_seq_ID'
          'Auth_mon_ID': [None,lambda x = value: returnStarCode(x,length = 15),'Atom_site.Auth_comp_ID',False],# Pointer to '_Atom_site.Auth_comp_ID'
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Assembly_ID': [None,returnStarInt,'Assembly.ID',True],                                             # Pointer to '_Assembly.ID'

                },

        'tagNames': ['Entity_assembly_ID', 'Entity_ID', 'Comp_index_ID', 'Comp_ID', 'Comp_label', 'Asym_ID', 'Seq_ID', 'Mon_ID', 'Hetero', 'PDB_seq_num', 'PDB_mon_ID', 'PDB_chain_ID', 'PDB_ins_code', 'Auth_seq_num', 'Auth_mon_ID', 'Entry_ID', 'Assembly_ID'],
        'sourcePrimaryKeys': ['Entity_assembly_ID', 'Comp_index_ID', 'Entry_ID', 'Assembly_ID'],

            },

      'PDBX_nonpoly_scheme': {

        'tags': {

          'Entity_assembly_ID': [None,returnStarInt,'Entity_assembly.ID',True],                               # Pointer to '_Entity_assembly.ID'
          'Asym_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Struct_asym.ID',True],            # Pointer to '_Struct_asym.ID'
          'Entity_ID': [None,returnStarInt,'Entity.ID',True],                                                 # Pointer to '_Entity.ID'
          'Mon_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Atom_site.Label_comp_ID',True],    # Pointer to _Atom_site.Label_comp_ID'
          'Comp_index_ID': [None,returnStarInt,'Entity_comp_index.ID',False],                                 # Pointer to '_Entity_comp_index.ID'
          'Comp_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Chem_comp.ID',False],             # Pointer to '_Chem_comp.ID'
          'PDB_seq_num': [None,lambda x = value: returnStarCode(x,length = 12),None,False],                   # PDB residue number.
          'Auth_seq_num': [None,lambda x = value: returnStarCode(x,length = 12),'Atom_site.Auth_seq_ID',False],# Pointer to '_Atom_site.Auth_seq_ID'
          'PDB_mon_ID': [None,lambda x = value: returnStarCode(x,length = 12),None,False],                    # PDB residue name.
          'Auth_mon_ID': [None,lambda x = value: returnStarCode(x,length = 15),'Atom_site.Auth_comp_ID',False],# Pointer to '_Atom_site.Auth_comp_ID'
          'PDB_strand_ID': [None,lambda x = value: returnStarCode(x,length = 12),None,False],                 # PDB strand/chain id.
          'PDB_ins_code': [None,lambda x = value: returnStarCode(x,length = 12),None,False],                  # PDB insertion code.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Assembly_ID': [None,returnStarInt,'Assembly.ID',True],                                             # Pointer to '_Assembly.ID'

                },

        'tagNames': ['Entity_assembly_ID', 'Asym_ID', 'Entity_ID', 'Mon_ID', 'Comp_index_ID', 'Comp_ID', 'PDB_seq_num', 'Auth_seq_num', 'PDB_mon_ID', 'Auth_mon_ID', 'PDB_strand_ID', 'PDB_ins_code', 'Entry_ID', 'Assembly_ID'],
        'sourcePrimaryKeys': ['Entity_assembly_ID', 'Entry_ID', 'Assembly_ID'],

            },

      'Atom_type': {

        'tags': {

          'ID': [None,returnStarInt,None,True],                                                               # Integer value that uniquely defines the atom type. The primary key for this table.
          'Symbol': [None,lambda x = value: returnStarCode(x,length = 3),None,False],                         # Standard IUPAC atom symbol
          'Atomic_number': [None,returnStarInt,None,False],                                                   # Atom atomic number
          'Isotope_number': [None,returnStarInt,None,False],                                                  # Atom mass number
          'Oxidation_number': [None,lambda x = value: returnStarCode(x,length = 12),None,False],              # Atom oxidation number
          'Paramagnetic': [None,lambda x = value: returnStarYesNo(x,length = 3),None,False],                  # Flag indicating if the atom is paramagnetic.
          'Electron_configuration': [None,lambda x = value: returnStarLine(x,length = 31),None,False],        # Electron configuration for the atom
          'Unpaired_electron_number': [None,returnStarInt,None,False],                                        # Number of unpaired electrons on the atom
          'Atomic_mass': [None,returnStarFloat,None,False],                                                   # Atom atomic mass
          'Van_der_Vaals_radii': [None,returnStarFloat,None,False],                                           # van der Valls radii for the atom
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Assembly_ID': [None,returnStarInt,'Assembly.ID',True],                                             # Pointer to '_Assembly.ID'

                },

        'tagNames': ['ID', 'Symbol', 'Atomic_number', 'Isotope_number', 'Oxidation_number', 'Paramagnetic', 'Electron_configuration', 'Unpaired_electron_number', 'Atomic_mass', 'Van_der_Vaals_radii', 'Entry_ID', 'Assembly_ID'],
        'sourcePrimaryKeys': ['ID', 'Entry_ID', 'Assembly_ID'],

            },

      'Atom': {

        'tags': {

          'Assembly_atom_ID': [None,returnStarInt,None,True],                                                 # A value that uniquely identifies the atom from all other atoms in the molecular assembly.
          'Entity_assembly_ID': [None,returnStarInt,'Entity_assembly.ID',True],                               # Pointer to '_Entity_assembly.ID'
          'Entity_ID': [None,returnStarInt,'Entity.ID',True],                                                 # Pointer to '_Entity.ID'
          'Comp_index_ID': [None,returnStarInt,'Entity_comp_index.ID',True],                                  # Pointer to '_Entity_comp_index.ID'
          'Seq_ID': [None,returnStarInt,'Entity_poly_seq.Num',True],                                          # Pointer to '_Entity_poly_seq.Num'
          'Comp_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Chem_comp.ID',True],              # Pointer to '_Chem_comp.ID'
          'Atom_type_ID': [None,returnStarInt,'Atom_type.ID',False],                                          # Pointer to '_Atom_type.ID'
          'Atom_ID': [None,lambda x = value: returnStarAtCode(x,length = 12),None,True],                      # The value of _Atom.Atom_id must uniquely identify a record in the atom list.
          'Type_symbol': [None,lambda x = value: returnStarCode(x,length = 15),None,True],                    # The code used to identify the atom specie(s) representing this atom type. Normally this code is the element symbol. The code may be composed of any character except an underline with the additional proviso that digits designate an oxidation state and must be followed by a + or - character.
          'PDB_one_letter_code': [None,lambda x = value: returnStarCode(x,length = 15),None,False],           # One-letter code used by the PDB for amino acids and nucleic acids.
          'PDB_strand_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                 # PDB strand/chain id.
          'PDB_ins_code': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                  # PDB insertion code.
          'PDB_asym_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Atom_site.PDBX_label_asym_ID',False],# Pointer to _Atom_site.PDBX_label_asym_id'.
          'PDB_seq_ID': [None,returnStarInt,'Entity_poly_seq.Num',False],                                     # Pointer to '_Entity_poly_seq.Num'
          'PDB_comp_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Chem_comp.ID',False],         # Pointer to '_Chem_comp.ID'
          'PDB_group': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                     # The group of atoms to which the atom site belongs. This data item is provided for compatibility with the original Protein Data Bank format$ and only for that purpose.
          'PDB_atom_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                   # This data item is a pointer to '_Chem_comp_atom.Atom_id in the chem_comp_atom category.
          'PDB_atom_type': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                 # Standard symbol used to define the atom element type.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Assembly_ID': [None,returnStarInt,'Assembly.ID',True],                                             # Pointer to '_Assembly.ID'

                },

        'tagNames': ['Assembly_atom_ID', 'Entity_assembly_ID', 'Entity_ID', 'Comp_index_ID', 'Seq_ID', 'Comp_ID', 'Atom_type_ID', 'Atom_ID', 'Type_symbol', 'PDB_one_letter_code', 'PDB_strand_ID', 'PDB_ins_code', 'PDB_asym_ID', 'PDB_seq_ID', 'PDB_comp_ID', 'PDB_group', 'PDB_atom_ID', 'PDB_atom_type', 'Entry_ID', 'Assembly_ID'],
        'sourcePrimaryKeys': ['Assembly_atom_ID', 'Entry_ID', 'Assembly_ID'],

            },

      'Assembly_bio_function': {

        'tags': {

          'Biological_function': [None,lambda x = value: returnStarLine(x,length = 127),None,True],           # Very brief description of the biological function of the entity assembly.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Assembly_ID': [None,returnStarInt,'Assembly.ID',True],                                             # Pointer to '_Assembly.ID'

                },

        'tagNames': ['Biological_function', 'Entry_ID', 'Assembly_ID'],
        'sourcePrimaryKeys': ['Biological_function', 'Entry_ID', 'Assembly_ID'],

            },

      'Angle': {

        'tags': {

          'ID': [None,returnStarInt,None,True],                                                               # Unique identifier for the angle that is valid across the full molecular assembly.
          'Angle_name': [None,lambda x = value: returnStarLine(x,length = 127),None,True],                    # Name for the angle defined as a community recognized standard.
          'Assembly_atom_ID_1': [None,returnStarInt,'Atom.Assembly_atom_ID',False],                           # Pointer to '_Atom.Assembly_atom_ID'
          'Entity_assembly_ID_1': [None,returnStarInt,'Entity_assembly.ID',True],                             # Pointer to '_Entity_assembly.ID'
          'Entity_ID_1': [None,returnStarInt,'Entity.ID',True],                                               # Pointer to '_Entity.ID'
          'Entity_label_1': [None,lambda x = value: returnStarLabel(x,length = 127),'Entity.Sf_framecode',True],# Pointer to a saveframe of the category 'entity'
          'Comp_ID_1': [None,lambda x = value: returnStarCode(x,length = 12),'Chem_comp.ID',True],            # Pointer to '_Chem_comp.ID'
          'Comp_label_1': [None,lambda x = value: returnStarLabel(x,length = 127),'Chem_comp.Sf_framecode',True],# Pointer to a saveframe of the category 'chem_comp'
          'Comp_index_ID_1': [None,returnStarInt,'Entity_comp_index.ID',True],                                # Pointer to '_Entity_comp_index.ID'
          'Seq_ID_1': [None,returnStarInt,'Entity_poly_seq.Num',True],                                        # Pointer to '_Entity_poly_seq.Num'
          'Atom_ID_1': [None,lambda x = value: returnStarAtCode(x,length = 12),'Chem_comp_atom.Atom_ID',True],# Pointer to '_Chem_comp_atom.Atom_ID'
          'Atom_type_1': [None,lambda x = value: returnStarCode(x,length = 15),None,True],                    # Standard symbol used to define the atom element type.
          'Assembly_atom_ID_2': [None,returnStarInt,'Atom.Assembly_atom_ID',False],                           # Pointer to '_Atom.Assembly_atom_ID'
          'Entity_assembly_ID_2': [None,returnStarInt,'Entity_assembly.ID',True],                             # Pointer to '_Entity_assembly.ID'
          'Entity_ID_2': [None,returnStarInt,'Entity.ID',True],                                               # Pointer to '_Entity.ID'
          'Entity_label_2': [None,lambda x = value: returnStarLabel(x,length = 127),'Entity.Sf_framecode',True],# Pointer to a saveframe of the category 'entity'
          'Comp_ID_2': [None,lambda x = value: returnStarCode(x,length = 12),'Chem_comp.ID',True],            # Pointer to '_Chem_comp.ID'
          'Comp_label_2': [None,lambda x = value: returnStarLabel(x,length = 127),'Chem_comp.Sf_framecode',True],# Pointer to a saveframe of the category 'chem_comp'
          'Comp_index_ID_2': [None,returnStarInt,'Entity_comp_index.ID',True],                                # Pointer to '_Entity_comp_index.ID'
          'Seq_ID_2': [None,returnStarInt,'Entity_poly_seq.Num',True],                                        # Pointer to '_Entity_poly_seq.Num'
          'Atom_ID_2': [None,lambda x = value: returnStarAtCode(x,length = 12),'Chem_comp_atom.Atom_ID',True],# Pointer to '_Chem_comp_atom.Atom_ID'
          'Atom_type_2': [None,lambda x = value: returnStarCode(x,length = 15),None,True],                    # Standard symbol used to define the atom element type.
          'Assembly_atom_ID_3': [None,returnStarInt,'Atom.Assembly_atom_ID',False],                           # Pointer to '_Atom.Assembly_atom_ID'
          'Entity_assembly_ID_3': [None,returnStarInt,'Entity_assembly.ID',True],                             # Pointer to '_Entity_assembly.ID'
          'Entity_ID_3': [None,returnStarInt,'Entity.ID',True],                                               # Pointer to '_Entity.ID'
          'Entity_label_3': [None,lambda x = value: returnStarLabel(x,length = 127),'Entity.Sf_framecode',True],# Pointer to a saveframe of the category 'entity'
          'Comp_ID_3': [None,lambda x = value: returnStarCode(x,length = 12),'Chem_comp.ID',True],            # Pointer to '_Chem_comp.ID'
          'Comp_label_3': [None,lambda x = value: returnStarLabel(x,length = 127),'Chem_comp.Sf_framecode',True],# Pointer to a saveframe of the category 'chem_comp'
          'Comp_index_ID_3': [None,returnStarInt,'Entity_comp_index.ID',True],                                # Pointer to '_Entity_comp_index.ID'
          'Seq_ID_3': [None,returnStarInt,'Entity_poly_seq.Num',True],                                        # Pointer to '_Entity_poly_seq.Num'
          'Atom_ID_3': [None,lambda x = value: returnStarAtCode(x,length = 12),'Chem_comp_atom.Atom_ID',True],# Pointer to '_Chem_comp_atom.Atom_ID'
          'Atom_type_3': [None,lambda x = value: returnStarCode(x,length = 15),None,True],                    # Standard symbol used to define the atom element type.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Assembly_ID': [None,returnStarInt,'Assembly.ID',True],                                             # Pointer to '_Assembly.ID'

                },

        'tagNames': ['ID', 'Angle_name', 'Assembly_atom_ID_1', 'Entity_assembly_ID_1', 'Entity_ID_1', 'Entity_label_1', 'Comp_ID_1', 'Comp_label_1', 'Comp_index_ID_1', 'Seq_ID_1', 'Atom_ID_1', 'Atom_type_1', 'Assembly_atom_ID_2', 'Entity_assembly_ID_2', 'Entity_ID_2', 'Entity_label_2', 'Comp_ID_2', 'Comp_label_2', 'Comp_index_ID_2', 'Seq_ID_2', 'Atom_ID_2', 'Atom_type_2', 'Assembly_atom_ID_3', 'Entity_assembly_ID_3', 'Entity_ID_3', 'Entity_label_3', 'Comp_ID_3', 'Comp_label_3', 'Comp_index_ID_3', 'Seq_ID_3', 'Atom_ID_3', 'Atom_type_3', 'Entry_ID', 'Assembly_ID'],
        'sourcePrimaryKeys': ['ID', 'Entry_ID', 'Assembly_ID'],

            },

      'Torsion_angle': {

        'tags': {

          'ID': [None,returnStarInt,None,True],                                                               # Unique identifier for the torsion angle that is valid across the full molecular assembly.
          'Torsion_angle_name': [None,lambda x = value: returnStarLine(x,length = 127),None,True],            # Name for the torsion angle commonly used in the scientific literature or defined by a recognized organization for standard scientific nomenclature.
          'Assembly_atom_ID_1': [None,returnStarInt,'Atom.Assembly_atom_ID',False],                           # Pointer to '_Atom.Assembly_atom_ID'
          'Entity_assembly_ID_1': [None,returnStarInt,'Entity_assembly.ID',True],                             # Pointer to '_Entity_assembly.ID'
          'Entity_ID_1': [None,returnStarInt,'Entity.ID',True],                                               # Pointer to '_Entity.ID'
          'Entity_label_1': [None,lambda x = value: returnStarLabel(x,length = 127),'Entity.Sf_framecode',True],# Pointer to a saveframe of the category 'entity'
          'Comp_ID_1': [None,lambda x = value: returnStarCode(x,length = 12),'Chem_comp.ID',True],            # Pointer to '_Chem_comp.ID'
          'Comp_label_1': [None,lambda x = value: returnStarLabel(x,length = 127),'Chem_comp.Sf_framecode',True],# Pointer to a saveframe of the category 'chem_comp'
          'Comp_index_ID_1': [None,returnStarInt,'Entity_comp_index.ID',True],                                # Pointer to '_Entity_comp_index.ID'
          'Seq_ID_1': [None,returnStarInt,'Entity_poly_seq.Num',True],                                        # Pointer to '_Entity_poly_seq.Num'
          'Atom_ID_1': [None,lambda x = value: returnStarAtCode(x,length = 12),'Chem_comp_atom.Atom_ID',True],# Pointer to '_Chem_comp_atom.Atom_ID'
          'Atom_type_1': [None,lambda x = value: returnStarCode(x,length = 15),None,True],                    # Standard symbol used to define the atom element type.
          'Assembly_atom_ID_2': [None,returnStarInt,'Atom.Assembly_atom_ID',False],                           # Pointer to '_Atom.Assembly_atom_ID'
          'Entity_assembly_ID_2': [None,returnStarInt,'Entity_assembly.ID',True],                             # Pointer to '_Entity_assembly.ID'
          'Entity_ID_2': [None,returnStarInt,'Entity.ID',True],                                               # Pointer to '_Entity.ID'
          'Entity_label_2': [None,lambda x = value: returnStarLabel(x,length = 127),'Entity.Sf_framecode',True],# Pointer to a saveframe of the category 'entity'
          'Comp_ID_2': [None,lambda x = value: returnStarCode(x,length = 12),'Chem_comp.ID',True],            # Pointer to '_Chem_comp.ID'
          'Comp_label_2': [None,lambda x = value: returnStarLabel(x,length = 127),'Chem_comp.Sf_framecode',True],# Pointer to a saveframe of the category 'chem_comp'
          'Comp_index_ID_2': [None,returnStarInt,'Entity_comp_index.ID',True],                                # Pointer to '_Entity_comp_index.ID'
          'Seq_ID_2': [None,returnStarInt,'Entity_poly_seq.Num',True],                                        # Pointer to '_Entity_poly_seq.Num'
          'Atom_ID_2': [None,lambda x = value: returnStarAtCode(x,length = 12),'Chem_comp_atom.Atom_ID',True],# Pointer to '_Chem_comp_atom.Atom_ID'
          'Atom_type_2': [None,lambda x = value: returnStarCode(x,length = 15),None,True],                    # Standard symbol used to define the atom element type.
          'Assembly_atom_ID_3': [None,returnStarInt,'Atom.Assembly_atom_ID',False],                           # Pointer to '_Atom.Assembly_atom_ID'
          'Entity_assembly_ID_3': [None,returnStarInt,'Entity_assembly.ID',True],                             # Pointer to '_Entity_assembly.ID'
          'Entity_ID_3': [None,returnStarInt,'Entity.ID',True],                                               # Pointer to '_Entity.ID'
          'Entity_label_3': [None,lambda x = value: returnStarLabel(x,length = 127),'Entity.Sf_framecode',True],# Pointer to a saveframe of the category 'entity'
          'Comp_ID_3': [None,lambda x = value: returnStarCode(x,length = 12),'Chem_comp.ID',True],            # Pointer to '_Chem_comp.ID'
          'Comp_label_3': [None,lambda x = value: returnStarLabel(x,length = 127),'Chem_comp.Sf_framecode',True],# Pointer to a saveframe of the category 'chem_comp'
          'Comp_index_ID_3': [None,returnStarInt,'Entity_comp_index.ID',True],                                # Pointer to '_Entity_comp_index.ID'
          'Seq_ID_3': [None,returnStarInt,'Entity_poly_seq.Num',True],                                        # Pointer to '_Entity_poly_seq.Num'
          'Atom_ID_3': [None,lambda x = value: returnStarAtCode(x,length = 12),'Chem_comp_atom.Atom_ID',True],# Pointer to '_Chem_comp_atom.Atom_ID'
          'Atom_type_3': [None,lambda x = value: returnStarCode(x,length = 15),None,True],                    # Standard symbol used to define the atom element type.
          'Assembly_atom_ID_4': [None,returnStarInt,'Atom.Assembly_atom_ID',False],                           # Pointer to '_Atom.Assembly_atom_ID'
          'Entity_assembly_ID_4': [None,returnStarInt,'Entity_assembly.ID',True],                             # Pointer to '_Entity_assembly.ID'
          'Entity_ID_4': [None,returnStarInt,'Entity.ID',True],                                               # Pointer to '_Entity.ID'
          'Entity_label_4': [None,lambda x = value: returnStarLabel(x,length = 127),'Entity.Sf_framecode',True],# Pointer to a saveframe of the category 'entity'
          'Comp_ID_4': [None,lambda x = value: returnStarCode(x,length = 12),'Chem_comp.ID',True],            # Pointer to '_Chem_comp.ID'
          'Comp_label_4': [None,lambda x = value: returnStarLabel(x,length = 127),'Chem_comp.Sf_framecode',True],# Pointer to a saveframe of the category 'chem_comp'
          'Comp_index_ID_4': [None,returnStarInt,'Entity_comp_index.ID',True],                                # Pointer to '_Entity_comp_index.ID'
          'Seq_ID_4': [None,returnStarInt,'Entity_poly_seq.Num',True],                                        # Pointer to '_Entity_poly_seq.Num'
          'Atom_ID_4': [None,lambda x = value: returnStarAtCode(x,length = 12),'Chem_comp_atom.Atom_ID',True],# Pointer to '_Chem_comp_atom.Atom_ID'
          'Atom_type_4': [None,lambda x = value: returnStarCode(x,length = 15),None,True],                    # Standard symbol used to define the atom element type.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Assembly_ID': [None,returnStarInt,'Assembly.ID',True],                                             # Pointer to '_Assembly.ID'

                },

        'tagNames': ['ID', 'Torsion_angle_name', 'Assembly_atom_ID_1', 'Entity_assembly_ID_1', 'Entity_ID_1', 'Entity_label_1', 'Comp_ID_1', 'Comp_label_1', 'Comp_index_ID_1', 'Seq_ID_1', 'Atom_ID_1', 'Atom_type_1', 'Assembly_atom_ID_2', 'Entity_assembly_ID_2', 'Entity_ID_2', 'Entity_label_2', 'Comp_ID_2', 'Comp_label_2', 'Comp_index_ID_2', 'Seq_ID_2', 'Atom_ID_2', 'Atom_type_2', 'Assembly_atom_ID_3', 'Entity_assembly_ID_3', 'Entity_ID_3', 'Entity_label_3', 'Comp_ID_3', 'Comp_label_3', 'Comp_index_ID_3', 'Seq_ID_3', 'Atom_ID_3', 'Atom_type_3', 'Assembly_atom_ID_4', 'Entity_assembly_ID_4', 'Entity_ID_4', 'Entity_label_4', 'Comp_ID_4', 'Comp_label_4', 'Comp_index_ID_4', 'Seq_ID_4', 'Atom_ID_4', 'Atom_type_4', 'Entry_ID', 'Assembly_ID'],
        'sourcePrimaryKeys': ['ID', 'Entry_ID', 'Assembly_ID'],

            },

      'Assembly_segment': {

        'tags': {

          'ID': [None,returnStarInt,None,True],                                                               # Integer value that uniquely defines the segment of the molecular assembly described. This tag is not the primary key for this table.
          'Entity_assembly_ID': [None,returnStarInt,'Entity_assembly.ID',True],                               # Pointer to '_Entity_assembly.ID'
          'Entity_ID': [None,returnStarInt,'Entity.ID',True],                                                 # Pointer to '_Entity.ID'
          'Entity_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Entity.Sf_framecode',False],# Pointer to a saveframe of the category 'entity'
          'Comp_index_ID': [None,returnStarInt,'Entity_comp_index.ID',True],                                  # Pointer to '_Entity_comp_index.ID'
          'Comp_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Chem_comp.ID',True],              # Pointer to '_Chem_comp.ID'
          'Comp_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Chem_comp.Sf_framecode',False],# Pointer to a saveframe of the category 'chem_comp'
          'Seq_ID': [None,returnStarInt,'Entity_poly_seq.Num',True],                                          # Pointer to '_Entity_poly_seq.Num'
          'Atom_ID': [None,lambda x = value: returnStarAtCode(x,length = 12),'Chem_comp_atom.Atom_ID',True],  # Pointer to '_Chem_comp_atom.Atom_ID'
          'Assembly_atom_ID': [None,returnStarInt,'Atom.Assembly_atom_ID',True],                              # Pointer to '_Atom.Assembly_atom_ID'
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Assembly_ID': [None,returnStarInt,'Assembly.ID',True],                                             # Pointer to '_Assembly.ID'

                },

        'tagNames': ['ID', 'Entity_assembly_ID', 'Entity_ID', 'Entity_label', 'Comp_index_ID', 'Comp_ID', 'Comp_label', 'Seq_ID', 'Atom_ID', 'Assembly_atom_ID', 'Entry_ID', 'Assembly_ID'],
        'sourcePrimaryKeys': ['ID'],

            },

      'Assembly_segment_description': {

        'tags': {

          'Assembly_segment_ID': [None,returnStarInt,'Assembly_segment.ID',True],                             # Pointer to '_Assembly_segment.ID'
          'Code': [None,lambda x = value: returnStarCode(x,length = 15),None,True],                           # Code that defines the type of assembly segment.
          'Details': [None,returnStarString,None,False],                                                      # Text providing additional information about the assembly segment.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Assembly_ID': [None,returnStarInt,'Assembly.ID',True],                                             # Pointer to '_Assembly.ID'

                },

        'tagNames': ['Assembly_segment_ID', 'Code', 'Details', 'Entry_ID', 'Assembly_ID'],
        'sourcePrimaryKeys': ['Entry_ID', 'Assembly_ID'],

            },

      'Assembly_keyword': {

        'tags': {

          'Keyword': [None,lambda x = value: returnStarLine(x,length = 127),None,True],                       # A word or very brief phrase that provide a concise description of the entity assembly.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Assembly_ID': [None,returnStarInt,'Assembly.ID',True],                                             # Pointer to '_Assembly.ID'

                },

        'tagNames': ['Keyword', 'Entry_ID', 'Assembly_ID'],
        'sourcePrimaryKeys': ['Keyword', 'Entry_ID', 'Assembly_ID'],

            },

      'Assembly_citation': {

        'tags': {

          'Citation_ID': [None,returnStarInt,'Citation.ID',True],                                             # Pointer to '_Citation.ID'
          'Citation_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Citation.Sf_framecode',True],# Pointer to a saveframe of the category citation.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Assembly_ID': [None,returnStarInt,'Assembly.ID',True],                                             # Pointer to '_Assembly.ID'

                },

        'tagNames': ['Citation_ID', 'Citation_label', 'Entry_ID', 'Assembly_ID'],
        'sourcePrimaryKeys': ['Citation_ID', 'Entry_ID', 'Assembly_ID'],

            }

        },

    'tableNames': ['Assembly_type', 'Entity_assembly', 'Bond', 'Entity_deleted_atom', 'Deleted_atom', 'Struct_asym', 'Assembly_db_link', 'Assembly_common_name', 'Assembly_systematic_name', 'Assembly_interaction', 'Chem_comp_assembly', 'PDBX_poly_seq_scheme', 'PDBX_nonpoly_scheme', 'Atom_type', 'Atom', 'Assembly_bio_function', 'Angle', 'Torsion_angle', 'Assembly_segment', 'Assembly_segment_description', 'Assembly_keyword', 'Assembly_citation']

    },

  'assembly_annotation': {

    'name': 'Assembly_annotation_list',

    'tags': {

      'Sf_category': ['assembly_annotation',lambda x = value: returnStarCode(x,length = 127),None,True],      # Category assigned to the information in the saveframe.
      'Sf_framecode': [None,lambda x = value: returnStarCode(x,length = 127),None,False],                     # The framecode for the save frame where author defined annotations for the molecular assembly studied are provided.
      'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                     # Pointer to '_Entry.ID'
      'ID': [None,returnStarInt,None,True],                                                                   # An integer value that uniquely defines the assembly annotation saveframe from other assembly annotation saveframes in the entry.
      'Source': [None,lambda x = value: returnStarLine(x,length = 127),None,True],                            # Code defining the source of the annotation provided.
      'Details': [None,returnStarString,None,False],                                                          # Text providing additional information regarding the annotation provided for the assembly and/or its subsystems.

            },

    'tagNames': ['Sf_category', 'Sf_framecode', 'Entry_ID', 'ID', 'Source', 'Details'],
    'sourcePrimaryKeys': ['Entry_ID', 'ID'],

    'tables': {

      'Author_annotation': {

        'tags': {

          'ID': [None,returnStarInt,None,True],                                                               # An integer value that uniquely identifies the author provided annotation.
          'Assembly_ID': [None,returnStarInt,'Assembly.ID',True],                                             # Pointer to '_Assembly.ID'
          'Assembly_subsystem_ID': [None,returnStarInt,'Assembly_subsystem.ID',False],                        # Pointer to '_Assembly_subsystem.ID'
          'Entity_assembly_ID': [None,returnStarInt,'Entity_assembly.ID',True],                               # Pointer to '_Entity_assembly.ID'
          'Entity_ID': [None,returnStarInt,'Entity.ID',True],                                                 # Pointer to '_Entity.ID'
          'Comp_index_ID': [None,returnStarInt,'Entity_comp_index.ID',True],                                  # Pointer to '_Entity_comp_index.ID'
          'Comp_index_ID_start': [None,returnStarInt,'Entity_comp_index.ID',True],                            # Pointer to '_Entity_comp_index.ID'
          'Comp_index_ID_end': [None,returnStarInt,'Entity_comp_index.ID',True],                              # Pointer to '_Entity_comp_index.ID'
          'Seq_ID': [None,returnStarInt,'Entity_poly_seq.Num',True],                                          # Pointer to '_Entity_poly_seq.Num'
          'Seq_ID_start': [None,returnStarInt,'Entity_poly_seq.Num',False],                                   # Pointer to '_Entity_poly_seq.Num'
          'Seq_ID_end': [None,returnStarInt,'Entity_poly_seq.Num',False],                                     # Pointer to '_Entity_poly_seq.Num'
          'Comp_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Chem_comp.ID',False],             # Pointer to '_Chem_comp.ID'
          'Atom_ID': [None,lambda x = value: returnStarAtCode(x,length = 12),'Chem_comp_atom.Atom_ID',False], # Pointer to '_Chem_comp_atom.Atom_ID'
          'Assembly_atom_ID': [None,returnStarInt,'Atom.Assembly_atom_ID',False],                             # Pointer to '_Atom.Assembly_atom_ID'
          'Annotation_code': [None,lambda x = value: returnStarLine(x,length = 127),None,True],               # A code that describes the kind of annotation provided.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Assembly_annotation_list_ID': [None,returnStarInt,'Assembly_annotation_list.ID',True],             # Pointer to '_Assembly_annotation_list.ID'

                },

        'tagNames': ['ID', 'Assembly_ID', 'Assembly_subsystem_ID', 'Entity_assembly_ID', 'Entity_ID', 'Comp_index_ID', 'Comp_index_ID_start', 'Comp_index_ID_end', 'Seq_ID', 'Seq_ID_start', 'Seq_ID_end', 'Comp_ID', 'Atom_ID', 'Assembly_atom_ID', 'Annotation_code', 'Entry_ID', 'Assembly_annotation_list_ID'],
        'sourcePrimaryKeys': ['ID', 'Entry_ID', 'Assembly_annotation_list_ID'],

            }

        },

    'tableNames': ['Author_annotation']

    },

  'assembly_subsystems': {

    'name': 'Assembly_subsystem',

    'tags': {

      'Sf_category': ['assembly_subsystems',lambda x = value: returnStarCode(x,length = 127),None,True],      # Category assigned to the information in the saveframe.
      'Sf_framecode': [None,lambda x = value: returnStarCode(x,length = 127),None,False],                     # A descriptive label that uniquely identifies this molecular subsystem from all other subsystems of the molecular assembly studied.
      'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                     # Pointer to '_Entry.ID'
      'ID': [None,returnStarInt,None,True],                                                                   # An integer value that uniquely defines the subsystem of the molecular assembly described. An assembly subsystem contains a subset of the components of the full molecular assembly$ but does not consist of fragments of the molecular assembly components.
      'Name': [None,lambda x = value: returnStarLine(x,length = 127),None,True],                              # Author supplied name for the assembly subsystem.
      'CAS_name': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                         # Chemical Abstract Services name that applies to the assembly subsystem.
      'CAS_registry_number': [None,lambda x = value: returnStarLine(x,length = 127),None,False],              # Chemical Abstract Services registry number that applies to the assembly subsystem.
      'Enzyme_commission_number': [None,lambda x = value: returnStarLine(x,length = 127),None,False],         # Identification number defined by the Enzyme Commission for the protein molecular system$ or biological molecular system described in the saveframe.
      'Molecular_mass': [None,returnStarFloat,None,False],                                                    # The approximate mass of the system as defined by the authors and is intended to approximate the sum of the masses of all of the atoms in the system.  No attempt  is made to define the mass at a specific pH value$ in terms of the protonation  state of any pH titratable groups$ or according to the incorporation of isotopes.
      'Details': [None,returnStarString,None,False],                                                          # Additional information relevant to the data in the current saveframe or to a specific data item is entered as a value to this tag.  The information entered must supplement information already present.  Whenever possible data should associated with specific data tags and not included in the value to a '_Details' tag.
      'DB_query_date': [None,returnStarDateTime,None,False],                                                  # Date that the last query has been conducted to locate entries in external databases that are related to the assembly subsystem.
      'DB_last_query_revised_last_date': [None,returnStarDateTime,None,False],                                # Date that this table was updated with links to external databases.

            },

    'tagNames': ['Sf_category', 'Sf_framecode', 'Entry_ID', 'ID', 'Name', 'CAS_name', 'CAS_registry_number', 'Enzyme_commission_number', 'Molecular_mass', 'Details', 'DB_query_date', 'DB_last_query_revised_last_date'],
    'sourcePrimaryKeys': ['Entry_ID', 'ID'],

    'tables': {

      'Subsystem_common_name': {

        'tags': {

          'Name': [None,lambda x = value: returnStarLine(x,length = 127),None,True],                          # A name commonly used in the literature to refer to this assembly subsystem.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Assembly_subsystem_ID': [None,returnStarInt,'Assembly_subsystem.ID',True],                         # Pointer to '_Assembly_subsystem.ID'

                },

        'tagNames': ['Name', 'Entry_ID', 'Assembly_subsystem_ID'],
        'sourcePrimaryKeys': ['Name', 'Entry_ID', 'Assembly_subsystem_ID'],

            },

      'Subsystem_type': {

        'tags': {

          'Type': [None,lambda x = value: returnStarLine(x,length = 127),None,True],                          # A code that defines the general type or kind of assembly subsystem.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Assembly_subsystem_ID': [None,returnStarInt,'Assembly_subsystem.ID',True],                         # Pointer to '_Assembly_subsystem.ID'

                },

        'tagNames': ['Type', 'Entry_ID', 'Assembly_subsystem_ID'],
        'sourcePrimaryKeys': ['Type', 'Entry_ID', 'Assembly_subsystem_ID'],

            },

      'Subsystem_component': {

        'tags': {

          'Entity_assembly_ID': [None,returnStarInt,'Entity_assembly.ID',True],                               # Pointer to '_Entity_assembly.ID'
          'Entity_ID': [None,returnStarInt,'Entity.ID',True],                                                 # Pointer to '_Entity.ID'
          'Entity_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Entity.Sf_framecode',True],# Pointer to a saveframe of the category entity.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Assembly_subsystem_ID': [None,returnStarInt,'Assembly_subsystem.ID',True],                         # Pointer to '_Assembly_subsystem.ID'

                },

        'tagNames': ['Entity_assembly_ID', 'Entity_ID', 'Entity_label', 'Entry_ID', 'Assembly_subsystem_ID'],
        'sourcePrimaryKeys': ['Entity_assembly_ID', 'Entry_ID', 'Assembly_subsystem_ID'],

            },

      'Subsystem_keyword': {

        'tags': {

          'Keyword': [None,lambda x = value: returnStarLine(x,length = 127),None,True],                       # A keyword that describes the assembly subsystem.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Assembly_subsystem_ID': [None,returnStarInt,'Assembly_subsystem.ID',True],                         # Pointer to '_Assembly_subsystem.ID'

                },

        'tagNames': ['Keyword', 'Entry_ID', 'Assembly_subsystem_ID'],
        'sourcePrimaryKeys': ['Keyword', 'Entry_ID', 'Assembly_subsystem_ID'],

            },

      'Subsystem_biological_function': {

        'tags': {

          'Biological_function': [None,lambda x = value: returnStarString(x,length = 255),None,True],         # A word or very brief phrase that defines a biological function that the assembly subsystem carries out.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Assembly_subsystem_ID': [None,returnStarInt,'Assembly_subsystem.ID',True],                         # Pointer to '_Assembly_subsystem.ID'

                },

        'tagNames': ['Biological_function', 'Entry_ID', 'Assembly_subsystem_ID'],
        'sourcePrimaryKeys': ['Biological_function', 'Entry_ID', 'Assembly_subsystem_ID'],

            },

      'Subsystem_db_link': {

        'tags': {

          'Author_supplied': [None,lambda x = value: returnStarYesNo(x,length = 3),None,False],               # Boolean code that defines if the link to a database was provided by the author (yes) or from another source (no).
          'Database_code': [None,lambda x = value: returnStarLine(x,length = 127),None,True],                 # Abbreviation for the database
          'Accession_code': [None,lambda x = value: returnStarLine(x,length = 31),None,True],                 # Accession code for the entry in the database.
          'Entry_mol_code': [None,lambda x = value: returnStarLine(x,length = 127),None,False],               # Code assigned by the database to the molecule in the database entry.
          'Entry_mol_name': [None,lambda x = value: returnStarLine(x,length = 127),None,False],               # Name of the molecular assembly in the database entry.
          'Entry_experimental_method': [None,lambda x = value: returnStarLine(x,length = 127),None,False],    # Experimental method used to generate the data in the database entry.
          'Entry_relation_type': [None,lambda x = value: returnStarLine(x,length = 127),None,False],          # Relationship between the database entry and this BMRB entry.
          'Entry_details': [None,returnStarString,None,False],                                                # Any text information relevant to the database entry.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Assembly_subsystem_ID': [None,returnStarInt,'Assembly_subsystem.ID',False],                        # Pointer to '_Assembly_subsystem.ID'

                },

        'tagNames': ['Author_supplied', 'Database_code', 'Accession_code', 'Entry_mol_code', 'Entry_mol_name', 'Entry_experimental_method', 'Entry_relation_type', 'Entry_details', 'Entry_ID', 'Assembly_subsystem_ID'],
        'sourcePrimaryKeys': ['Database_code', 'Accession_code'],

            },

      'Subsystem_citation': {

        'tags': {

          'Citation_ID': [None,returnStarInt,'Citation.ID',True],                                             # Pointer to '_Citation.ID'
          'Citation_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Citation.Sf_framecode',True],# Pointer to a saveframe of the category citation.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Assembly_subsystem_ID': [None,returnStarInt,'Assembly_subsystem.ID',True],                         # Pointer to '_Assembly_subsystem.ID'

                },

        'tagNames': ['Citation_ID', 'Citation_label', 'Entry_ID', 'Assembly_subsystem_ID'],
        'sourcePrimaryKeys': ['Citation_ID', 'Entry_ID', 'Assembly_subsystem_ID'],

            }

        },

    'tableNames': ['Subsystem_common_name', 'Subsystem_type', 'Subsystem_component', 'Subsystem_keyword', 'Subsystem_biological_function', 'Subsystem_db_link', 'Subsystem_citation']

    },

  'entity': {

    'name': 'Entity',

    'tags': {

      'Sf_category': ['entity',lambda x = value: returnStarCode(x,length = 127),None,True],                   # Category assigned to the information in the saveframe.
      'Sf_framecode': [None,lambda x = value: returnStarCode(x,length = 127),None,False],                     # A descriptive label that uniquely identifies this entity from all other chemically unique entities in the molecular assembly studied.
      'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                     # Pointer to '_Entry.ID'
      'ID': [None,returnStarInt,None,True],                                                                   # An integer value that is the unique identifier for the entity within the entry.
      'BMRB_code': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                         # A code for the entity that uniquely identifies the entity within a library of entities maintained at BMRB.
      'Name': [None,lambda x = value: returnStarLine(x,length = 127),None,True],                              # A brief name commonly used for the entity.
      'Type': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                             # Entities are of two types polymer or non-polymer.
      'Polymer_common_type': [None,lambda x = value: returnStarLine(x,length = 31),None,False],               # A code that indicates the common type of polymer to which the entity belongs.
      'Polymer_type': [None,lambda x = value: returnStarLine(x,length = 31),None,False],                      # Entity polymer types include protein$ DNA$ RNA$ DNA/RNA hybrids$ and carbohydrates.
      'Polymer_type_details': [None,returnStarString,None,False],                                             # Additional information about the polymer type.
      'Polymer_strand_ID': [None,lambda x = value: returnStarCode(x,length = 12),None,False],                 # The PDB strand/chain id(s) corresponding to this polymer entity.
      'Polymer_seq_one_letter_code_can': [None,returnStarString,None,False],                                  # The sequence of a polymer entity expressed using only the standard one-letter code for chemical components.
      'Polymer_seq_one_letter_code': [None,returnStarString,None,False],                                      # The sequence of a polymer entity expressed using the one-letter code for standard residues and an X for non-standard residues.
      'Target_identifier': [None,lambda x = value: returnStarLine(x,length = 31),None,False],                 # The TargetDB ID for the protein in the molecular system studied.
      'Polymer_author_defined_seq': [None,returnStarString,None,False],                                       # The author may provide a numbering scheme for a biopolymer that is different from that defined by the public databases.  This scheme may contain non-sequential numbering and the use of alphabetic characters.
      'Polymer_author_seq_details': [None,returnStarString,None,False],                                       # A text description of the sequence for this entity.
      'Ambiguous_conformational_states': [None,lambda x = value: returnStarYesNo(x,length = 3),None,False],   # A boolean flag to indicate the presence of multiple conformational states for the entity that have not been clearly defined.
      'Ambiguous_chem_comp_sites': [None,lambda x = value: returnStarYesNo(x,length = 3),None,False],         # A boolean flag that indicates the presence or absence of multiple conformational states for specific chemical components of the entity.
      'Nstd_monomer': [None,lambda x = value: returnStarYesNo(x,length = 3),None,False],                      # A boolean flag that indicates the presence (N) or absence (Y) of non-standard chemical components in the entity.
      'Nstd_chirality': [None,lambda x = value: returnStarYesNo(x,length = 3),None,False],                    # A boolean flag that indicates the presence or absence of non-standard chiral atoms in the entity.
      'Nstd_linkage': [None,lambda x = value: returnStarYesNo(x,length = 3),None,False],                      # A flag indicating the presence or absence of non-standard linkages between monomers in the biopolymer.
      'Nonpolymer_comp_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Chem_comp.ID',False],      # Pointer to '_Chem_comp.ID'
      'Nonpolymer_comp_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Chem_comp.Sf_framecode',False],# Pointer to a saveframe of the category chem_comp.
      'Number_of_monomers': [None,returnStarInt,None,False],                                                  # The number of chemical components that make up a polymer entity.
      'Number_of_nonpolymer_components': [None,returnStarInt,None,False],                                     # Non-polymer compounds like ATP or NAD may be comprised of more than one chemical component. If you want to describe each of the components in the non-polymer enter the number of components that exist in the non-polymer entity.
      'Paramagnetic': [None,lambda x = value: returnStarYesNo(x,length = 3),None,False],                      # A boolean flag that indicates the paramagnetic state of the entity.
      'Thiol_state': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                      # A keyword that describes the state of the thiol groups in the entity.
      'Src_method': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                       # The method by which the sample for the entity was produced. Entities isolated directly from natural sources (tissues$ soil samples$ etc.) are expected to have further information in the entity natural source category. Entities isolated from genetically manipulated sources are expected to have further information in the entity experimental source category.
      'Parent_entity_ID': [None,returnStarInt,'Entity.ID',False],                                             # Pointer to '_Entity.ID'
      'Fragment': [None,returnStarString,None,False],                                                         # Entity fragment description(s).
      'Mutation': [None,returnStarString,None,False],                                                         # Details about any entity mutation(s).
      'EC_number': [None,lambda x = value: returnStarLine(x,length = 31),None,False],                         # Enzyme Commission number
      'Calc_isoelectric_point': [None,returnStarFloat,None,False],                                            # The theoretical isoelectric point for the entity.
      'Formula_weight': [None,returnStarFloat,None,False],                                                    # Formula mass in daltons of the entity.
      'Formula_weight_exptl': [None,returnStarFloat,None,False],                                              # Experimentally determined formula weight for the molecular entity.
      'Formula_weight_exptl_meth': [None,lambda x = value: returnStarLine(x,length = 127),None,False],        # Method used to experimentally determine the formula weight for the molecular entity.
      'Details': [None,returnStarString,None,False],                                                          # Text providing additional details regarding this entity.
      'DB_query_date': [None,returnStarDateTime,None,False],                                                  # Last date that a query was conducted to locate entries in databases that are related to this molecular entity.
      'DB_query_revised_last_date': [None,returnStarDateTime,None,False],                                     # Last date that the table of related database entries was last updated.

            },

    'tagNames': ['Sf_category', 'Sf_framecode', 'Entry_ID', 'ID', 'BMRB_code', 'Name', 'Type', 'Polymer_common_type', 'Polymer_type', 'Polymer_type_details', 'Polymer_strand_ID', 'Polymer_seq_one_letter_code_can', 'Polymer_seq_one_letter_code', 'Target_identifier', 'Polymer_author_defined_seq', 'Polymer_author_seq_details', 'Ambiguous_conformational_states', 'Ambiguous_chem_comp_sites', 'Nstd_monomer', 'Nstd_chirality', 'Nstd_linkage', 'Nonpolymer_comp_ID', 'Nonpolymer_comp_label', 'Number_of_monomers', 'Number_of_nonpolymer_components', 'Paramagnetic', 'Thiol_state', 'Src_method', 'Parent_entity_ID', 'Fragment', 'Mutation', 'EC_number', 'Calc_isoelectric_point', 'Formula_weight', 'Formula_weight_exptl', 'Formula_weight_exptl_meth', 'Details', 'DB_query_date', 'DB_query_revised_last_date'],
    'sourcePrimaryKeys': ['Entry_ID', 'ID'],

    'tables': {

      'Entity_db_link': {

        'tags': {

          'Author_supplied': [None,lambda x = value: returnStarYesNo(x,length = 3),None,False],               # A code indicating that the link to a related database was provided by an author (yes) or obtained through another method (no).
          'Database_code': [None,lambda x = value: returnStarLine(x,length = 127),None,True],                 # Code assigned to a database.
          'Accession_code': [None,lambda x = value: returnStarLine(x,length = 31),None,True],                 # Accession code for the entry in the database.
          'Entry_mol_code': [None,lambda x = value: returnStarLine(x,length = 127),None,False],               # Code assigned by the database to the molecule in the database entry.
          'Entry_mol_name': [None,lambda x = value: returnStarLine(x,length = 127),None,False],               # Name of the molecular entity in the database entry.
          'Entry_experimental_method': [None,lambda x = value: returnStarLine(x,length = 127),None,False],    # For structural databases$ the method used to determine the structure.
          'Entry_structure_resolution': [None,returnStarFloat,None,False],                                    # A value taken from the database that is a measure of the quality of the structure.
          'Entry_relation_type': [None,lambda x = value: returnStarLine(x,length = 127),None,False],          # A brief description of how the database entry is related to the molecular entity.
          'Entry_details': [None,returnStarString,None,False],                                                # Text providing additional information about the matching entry.
          'Chimera_segment': [None,returnStarInt,None,False],                                                 # Code indicating if the listed database link is specific to the fragment of the entity described by the tag '_Entity.Fragment'.
          'Seq_query_to_submitted_percent': [None,returnStarFloat,None,False],                                # In percent$ the ratio of the length of retrieve sequence to the length of the sequence of the molecular entity. This value can be used to determine if the retrieved sequence is a subset or superset of the molecular entity.
          'Seq_subject_length': [None,returnStarInt,None,False],                                              # Length of the polymer sequence retrieve from the database.
          'Seq_identity': [None,returnStarFloat,None,False],                                                  # Number of residues in the retrieved sequence that have identical positions in the molecular entity determined by a homology alignment method.
          'Seq_positive': [None,returnStarFloat,None,False],                                                  # Number of residues in the retrieved sequence where the corresponding residue in the molecular entity sequence has similar physical characteristics (hydrophobicity$ charge$ etc.)
          'Seq_homology_expectation_val': [None,returnStarFloat,None,False],                                  # The BLAST expectation value for the homology between the retrieved polymer and the molecular entity.
          'Seq_align_begin': [None,lambda x = value: returnStarCode(x,length = 15),None,False],               # The sequence position in the database sequence at which the alignment with the sequence of the biopolymer studied begins.
          'Seq_align_end': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                 # The sequence position in the database sequence at which the alignment with the sequence of the biopolymer studied.
          'Seq_difference_details': [None,returnStarString,None,False],                                       # Text describing the differences in the sequences for the matched polymers.
          'Seq_alignment_details': [None,returnStarString,None,False],                                        # Text describing the alignment between the matched polymer sequences.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Entity_ID': [None,returnStarInt,'Entity.ID',True],                                                 # Pointer to '_Entity.ID'

                },

        'tagNames': ['Author_supplied', 'Database_code', 'Accession_code', 'Entry_mol_code', 'Entry_mol_name', 'Entry_experimental_method', 'Entry_structure_resolution', 'Entry_relation_type', 'Entry_details', 'Chimera_segment', 'Seq_query_to_submitted_percent', 'Seq_subject_length', 'Seq_identity', 'Seq_positive', 'Seq_homology_expectation_val', 'Seq_align_begin', 'Seq_align_end', 'Seq_difference_details', 'Seq_alignment_details', 'Entry_ID', 'Entity_ID'],
        'sourcePrimaryKeys': ['Database_code', 'Accession_code', 'Entry_ID', 'Entity_ID'],

            },

      'Entity_biological_function': {

        'tags': {

          'Biological_function': [None,returnStarString,None,True],                                           # A specific function carried out by the molecular entity in its native biological system.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Entity_ID': [None,returnStarInt,'Entity.ID',True],                                                 # Pointer to '_Entity.ID'

                },

        'tagNames': ['Biological_function', 'Entry_ID', 'Entity_ID'],
        'sourcePrimaryKeys': ['Biological_function', 'Entry_ID', 'Entity_ID'],

            },

      'Entity_common_name': {

        'tags': {

          'Name': [None,lambda x = value: returnStarLine(x,length = 127),None,True],                          # A name commonly used in the literature to refer to this biopolymer.  This may be a full name or an abbreviation.
          'Type': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                         # A code defining the type of the common name provided.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Entity_ID': [None,returnStarInt,'Entity.ID',True],                                                 # Pointer to '_Entity.ID'

                },

        'tagNames': ['Name', 'Type', 'Entry_ID', 'Entity_ID'],
        'sourcePrimaryKeys': ['Name', 'Entry_ID', 'Entity_ID'],

            },

      'Entity_systematic_name': {

        'tags': {

          'Name': [None,lambda x = value: returnStarLine(x,length = 127),None,True],                          # A name for the biopolymer that has been defined by an official body or is derived from rules defined by an official organization recognized by the scientific community.
          'Naming_system': [None,lambda x = value: returnStarLine(x,length = 127),None,True],                 # An official method of nomenclature or defined set of nomenclature for biopolymers recognized by the scientific community.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Entity_ID': [None,returnStarInt,'Entity.ID',True],                                                 # Pointer to '_Entity.ID'

                },

        'tagNames': ['Name', 'Naming_system', 'Entry_ID', 'Entity_ID'],
        'sourcePrimaryKeys': ['Naming_system', 'Entry_ID', 'Entity_ID'],

            },

      'Entity_keyword': {

        'tags': {

          'Keyword': [None,lambda x = value: returnStarLine(x,length = 127),None,True],                       # A single word or very brief phrase that characterizes the molecular entity.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Entity_ID': [None,returnStarInt,'Entity.ID',True],                                                 # Pointer to '_Entity.ID'

                },

        'tagNames': ['Keyword', 'Entry_ID', 'Entity_ID'],
        'sourcePrimaryKeys': ['Keyword', 'Entry_ID', 'Entity_ID'],

            },

      'Entity_comp_index': {

        'tags': {

          'ID': [None,returnStarInt,None,True],                                                               # Unique ID for the compound in the entity
          'Auth_seq_ID': [None,lambda x = value: returnStarCode(x,length = 12),None,False],                   # Author supplied sequence number identifying the position in the sequence of the polymer where the alternate residue or chemical compound is located.
          'Comp_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Chem_comp.ID',True],              # Pointer to '_Chem_comp.ID'
          'Comp_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Chem_comp.Sf_framecode',False],# Pointer to a saveframe of the category chem_comp.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Entity_ID': [None,returnStarInt,'Entity.ID',True],                                                 # Pointer to '_Entity.ID'

                },

        'tagNames': ['ID', 'Auth_seq_ID', 'Comp_ID', 'Comp_label', 'Entry_ID', 'Entity_ID'],
        'sourcePrimaryKeys': ['ID', 'Entry_ID', 'Entity_ID'],

            },

      'Entity_poly_seq': {

        'tags': {

          'Hetero': [None,lambda x = value: returnStarCode(x,length = 3),None,False],                         # A flag to indicate whether this monomer in the polymer is heterogeneous in sequence. This would be rare.
          'Mon_ID': [None,lambda x = value: returnStarCode(x,length = 12),None,False],                        # This data item is a pointer to '_Chem_comp.ID' in the chem_comp category.
          'Num': [None,returnStarInt,None,True],                                                              # The value of '_Entity_poly_seq.Num must uniquely and sequentially identify a record in the Entiy_poly_seq list. Note that this item must be a number and that the sequence numbers must progress in increasing numerical order.
          'Comp_index_ID': [None,returnStarInt,'Entity_comp_index.ID',True],                                  # Pointer to '_Entity_comp_index.ID'
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Entity_ID': [None,returnStarInt,'Entity.ID',True],                                                 # Pointer to '_Entity.ID'

                },

        'tagNames': ['Hetero', 'Mon_ID', 'Num', 'Comp_index_ID', 'Entry_ID', 'Entity_ID'],
        'sourcePrimaryKeys': ['Num', 'Entry_ID', 'Entity_ID'],

            },

      'Entity_chimera_segment': {

        'tags': {

          'ID': [None,returnStarInt,None,True],                                                               # The value of '_Entity_fragment.id' must uniquely identify a record in the Entity_fragment list.
          'Comp_index_ID_begin': [None,returnStarInt,'Entity_comp_index.ID',True],                            # Pointer to '_Entity_comp_index.ID'
          'Comp_index_ID_end': [None,returnStarInt,'Entity_comp_index.ID',True],                              # Pointer to '_Entity_comp_index.ID'
          'Seq_ID_begin': [None,returnStarInt,'Entity_poly_seq.Num',True],                                    # Pointer to '_Entity_poly_seq.Num'
          'Seq_ID_end': [None,returnStarInt,'Entity_poly_seq.Num',True],                                      # Pointer to '_Entity_poly_seq.Num'
          'Details': [None,returnStarString,None,False],                                                      # Text providing additional information about the fragment from the molecular entity.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Entity_ID': [None,returnStarInt,'Entity.ID',True],                                                 # Pointer to '_Entity.ID'

                },

        'tagNames': ['ID', 'Comp_index_ID_begin', 'Comp_index_ID_end', 'Seq_ID_begin', 'Seq_ID_end', 'Details', 'Entry_ID', 'Entity_ID'],
        'sourcePrimaryKeys': ['ID', 'Entry_ID', 'Entity_ID'],

            },

      'Entity_comp_index_alt': {

        'tags': {

          'Entity_comp_index_ID': [None,returnStarInt,'Entity_comp_index.ID',True],                           # Pointer to '_Entity_comp_index.ID'
          'Auth_seq_ID': [None,lambda x = value: returnStarCode(x,length = 12),None,False],                   # Author supplied sequence number identifying the position in the sequence of the polymer where the alternate residue or chemical compound is located.
          'Comp_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Chem_comp.ID',True],              # Pointer to '_Chem_comp.ID'
          'Comp_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Chem_comp.Sf_framecode',True],# Pointer to a saveframe of the category chem_comp.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Entity_ID': [None,returnStarInt,'Entity.ID',True],                                                 # Pointer to '_Entity.ID'

                },

        'tagNames': ['Entity_comp_index_ID', 'Auth_seq_ID', 'Comp_ID', 'Comp_label', 'Entry_ID', 'Entity_ID'],
        'sourcePrimaryKeys': ['Entity_comp_index_ID', 'Comp_ID', 'Entry_ID', 'Entity_ID'],

            },

      'Entity_atom_list': {

        'tags': {

          'ID': [None,returnStarInt,None,True],                                                               # The value of '_Entity_atom_list.ID' must uniquely identify an atom in the entity.
          'Comp_index_ID': [None,returnStarInt,'Entity_comp_index.ID',False],                                 # Pointer to '_Entity_comp_index.ID'
          'Comp_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Chem_comp.ID',False],             # Pointer to '_Chem_comp.ID'
          'Atom_ID': [None,lambda x = value: returnStarAtCode(x,length = 12),'Chem_comp_atom.Atom_ID',False], # Pointer to '_Chem_comp_atom.Atom_ID'
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Entity_ID': [None,returnStarInt,'Entity.ID',True],                                                 # Pointer to '_Entity.ID'

                },

        'tagNames': ['ID', 'Comp_index_ID', 'Comp_ID', 'Atom_ID', 'Entry_ID', 'Entity_ID'],
        'sourcePrimaryKeys': ['ID', 'Entry_ID', 'Entity_ID'],

            },

      'Entity_chem_comp_deleted_atom': {

        'tags': {

          'Comp_index_ID': [None,returnStarInt,'Entity_comp_index.ID',True],                                  # Pointer to '_Entity_comp_index.ID'
          'Comp_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Chem_comp.ID',False],             # Pointer to '_Chem_comp.ID'
          'Atom_ID': [None,lambda x = value: returnStarAtCode(x,length = 12),'Chem_comp_atom.Atom_ID',True],  # Pointer to '_Chem_comp_atom.Atom_ID'
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Entity_ID': [None,returnStarInt,'Entity.ID',True],                                                 # Pointer to '_Entity.ID'

                },

        'tagNames': ['Comp_index_ID', 'Comp_ID', 'Atom_ID', 'Entry_ID', 'Entity_ID'],
        'sourcePrimaryKeys': ['Comp_index_ID', 'Atom_ID', 'Entry_ID', 'Entity_ID'],

            },

      'Entity_bond': {

        'tags': {

          'ID': [None,returnStarInt,None,True],                                                               # The value of _Entity_bond.id must uniquely identify a record in the Entity_bond list.
          'Type': [None,lambda x = value: returnStarLine(x,length = 31),None,True],                           # A common chemical bond descriptive name.
          'Value_order': [None,lambda x = value: returnStarLine(x,length = 31),None,True],                    # The value that should be taken as the target for the chemical bond associated with the specified atoms expressed as a bond order.
          'Comp_index_ID_1': [None,returnStarInt,'Entity_comp_index.ID',True],                                # Pointer to '_Entity_comp_index.ID'
          'Comp_ID_1': [None,lambda x = value: returnStarCode(x,length = 12),'Chem_comp.ID',True],            # Pointer to '_Chem_comp.ID'
          'Atom_ID_1': [None,lambda x = value: returnStarAtCode(x,length = 12),'Chem_comp_atom.Atom_ID',True],# Pointer to '_Chem_comp_atom.Atom_ID'
          'Comp_index_ID_2': [None,returnStarInt,'Entity_comp_index.ID',True],                                # Pointer to '_Entity_comp_index.ID'
          'Comp_ID_2': [None,lambda x = value: returnStarCode(x,length = 12),'Chem_comp.ID',True],            # Pointer to '_Chem_comp.ID'
          'Atom_ID_2': [None,lambda x = value: returnStarAtCode(x,length = 12),'Chem_comp_atom.Atom_ID',True],# Pointer to '_Chem_comp_atom.Atom_ID'
          'Details': [None,returnStarString,None,False],                                                      # A text description of the bond.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Entity_ID': [None,returnStarInt,'Entity.ID',True],                                                 # Pointer to '_Entity.ID'

                },

        'tagNames': ['ID', 'Type', 'Value_order', 'Comp_index_ID_1', 'Comp_ID_1', 'Atom_ID_1', 'Comp_index_ID_2', 'Comp_ID_2', 'Atom_ID_2', 'Details', 'Entry_ID', 'Entity_ID'],
        'sourcePrimaryKeys': ['ID', 'Entry_ID', 'Entity_ID'],

            },

      'Entity_citation': {

        'tags': {

          'Citation_ID': [None,returnStarInt,'Citation.ID',True],                                             # Pointer to '_Citation.ID'
          'Citation_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Citation.Sf_framecode',True],# Pointer to a saveframe of the category citation.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Entity_ID': [None,returnStarInt,'Entity.ID',True],                                                 # Pointer to '_Entity.ID'

                },

        'tagNames': ['Citation_ID', 'Citation_label', 'Entry_ID', 'Entity_ID'],
        'sourcePrimaryKeys': ['Citation_ID', 'Entry_ID', 'Entity_ID'],

            }

        },

    'tableNames': ['Entity_db_link', 'Entity_biological_function', 'Entity_common_name', 'Entity_systematic_name', 'Entity_keyword', 'Entity_comp_index', 'Entity_poly_seq', 'Entity_chimera_segment', 'Entity_comp_index_alt', 'Entity_atom_list', 'Entity_chem_comp_deleted_atom', 'Entity_bond', 'Entity_citation']

    },

  'natural_source': {

    'name': 'Entity_natural_src_list',
    'saveFrameCode': 'natural_source',

    'tags': {

      'Sf_category': ['natural_source',lambda x = value: returnStarCode(x,length = 127),None,True],           # Category assigned to the information in the saveframe.
      'Sf_framecode': [None,lambda x = value: returnStarCode(x,length = 127),None,False],                     # Framecode for the save frame where the natural sources for each entity are listed.
      'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                     # Pointer to '_Entry.ID'.
      'ID': [None,returnStarInt,None,True],                                                                   # An integer value that is the unique identifier for saveframes of the type 'natural_source'.

            },

    'tagNames': ['Sf_category', 'Sf_framecode', 'Entry_ID', 'ID'],
    'sourcePrimaryKeys': ['Entry_ID', 'ID'],

    'tables': {

      'Entity_natural_src': {

        'tags': {

          'ID': [None,returnStarInt,None,True],                                                               # An integer value that uniquely identifies the natural source provided.
          'Entity_ID': [None,returnStarInt,'Entity.ID',True],                                                 # Pointer to '_Entity.ID'
          'Entity_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Entity.Sf_framecode',True],# Pointer to a saveframe of the category 'entity.'  This is the label assigned to the molecular entity by the author when completing the molecular entity portion of the deposition.
          'Entity_chimera_segment_ID': [None,returnStarInt,'Entity_chimera_segment.ID',False],                # Pointer to '_Entity_chimera_segment.ID'
          'NCBI_taxonomy_ID': [None,lambda x = value: returnStarCode(x,length = 12),None,True],               # NCBI taxonomy ID
          'Type': [None,lambda x = value: returnStarLine(x,length = 31),None,False],                          # The molecular entity or biopolymer has no natural source.
          'Common': [None,lambda x = value: returnStarYesNo(x,length = 3),None,False],                        # The molecular entity of biopolymer is common to more than one natural source.
          'Organism_name_scientific': [None,lambda x = value: returnStarLine(x,length = 127),None,False],     # Scientific name for the organism. Usually a combination of the genus and species for the organism.
          'Organism_name_common': [None,lambda x = value: returnStarLine(x,length = 127),None,True],          # Common name used for the biological organism.
          'Organism_acronym': [None,lambda x = value: returnStarLine(x,length = 127),None,False],             # A common acronym used to identify the organism.
          'ICTVdb_decimal_code': [None,lambda x = value: returnStarLine(x,length = 127),None,False],          # ICTV database decimal code for a virus
          'Superkingdom': [None,lambda x = value: returnStarLine(x,length = 127),None,True],                  # Scientific superkingdom classification for an organism as defined by NCBI taxonomists.
          'Kingdom': [None,lambda x = value: returnStarLine(x,length = 127),None,True],                       # Kingdom classifications for an organism as defined by NCBI taxonomists.
          'Genus': [None,lambda x = value: returnStarLine(x,length = 127),None,True],                         # Genus for the natural organism
          'Species': [None,lambda x = value: returnStarLine(x,length = 127),None,True],                       # Scientific name for the species of the organism as defined by NCBI taxonomists whenever possible.
          'Strain': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                       # The scientific name for the strain of an organism.
          'Variant': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                      # Name used to classify the variant of an organism.
          'Subvariant': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                   # Name used to define a subvariant of an organism.
          'Organ': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                        # The organ of a higher organism where the biopolymer is found in nature.
          'Tissue': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                       # The tissue from an organism that is the natural or experimental source of the molecule.
          'Tissue_fraction': [None,lambda x = value: returnStarLine(x,length = 127),None,False],              # The fraction of the tissue that was used as the source of the molecular entity.
          'Cell_line': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                    # Name the specific line of cells used in the experiment.
          'Cell_type': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                    # Identify the particular kind of cell.
          'ATCC_number': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                  # Organism culture number defined in the American Type Culture Collection.
          'Organelle': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                    # Organized structure within a cell.
          'Cellular_location': [None,lambda x = value: returnStarLine(x,length = 127),None,False],            # The cellular location where the molecular entity is found with in the natural source for the molecular entity.
          'Fragment': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                     # A domain or fragment of the molecule.
          'Fraction': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                     # Indicate cellular location here such as cytoplasm periplasm extracellular etc.
          'Secretion': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                    # If the molecule was isolated from a particular secretion such as saliva urine or venom this is stated here.
          'Plasmid': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                      # The name for a plasmid that naturally contains the gene for the biopolymer.
          'Plasmid_details': [None,returnStarString,None,False],                                              # Text details describing the plasmid that is the natural source for the molecular entity.
          'Gene_mnemonic': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                # Name of the gene that is the source of the biopolymer
          'Dev_stage': [None,returnStarString,None,False],                                                    # For molecular entities that are present in an organism only at a define stage in the development of the organism$ the stage they are present.
          'Details': [None,returnStarString,None,False],                                                      # Give any other remarks or comments on the biological source which may be relevant.
          'Citation_ID': [None,returnStarInt,'Citation.ID',False],                                            # Pointer to '_Citation.ID'
          'Citation_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Citation.Sf_framecode',False],# Pointer to a saveframe of the category citation.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Entity_natural_src_list_ID': [None,returnStarInt,'Entity_natural_src_list.ID',True],               # Pointer to '_Entity_natural_src_list.ID'

                },

        'tagNames': ['ID', 'Entity_ID', 'Entity_label', 'Entity_chimera_segment_ID', 'NCBI_taxonomy_ID', 'Type', 'Common', 'Organism_name_scientific', 'Organism_name_common', 'Organism_acronym', 'ICTVdb_decimal_code', 'Superkingdom', 'Kingdom', 'Genus', 'Species', 'Strain', 'Variant', 'Subvariant', 'Organ', 'Tissue', 'Tissue_fraction', 'Cell_line', 'Cell_type', 'ATCC_number', 'Organelle', 'Cellular_location', 'Fragment', 'Fraction', 'Secretion', 'Plasmid', 'Plasmid_details', 'Gene_mnemonic', 'Dev_stage', 'Details', 'Citation_ID', 'Citation_label', 'Entry_ID', 'Entity_natural_src_list_ID'],
        'sourcePrimaryKeys': ['ID', 'Entry_ID', 'Entity_natural_src_list_ID'],

            },

      'Natural_source_db': {

        'tags': {

          'Entity_natural_src_ID': [None,returnStarInt,'Entity_natural_src.ID',True],                         # Pointer to '_Entity_natural_src.ID'
          'Entity_ID': [None,returnStarInt,'Entity.ID',True],                                                 # Pointer to '_Entity.ID'
          'Entity_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Entity.Sf_framecode',True],# Pointer to a saveframe of the category 'entity'
          'Entity_chimera_segment_ID': [None,returnStarInt,'Entity_chimera_segment.ID',False],                # Pointer to '_Entity_chimera_segment.ID'
          'Database_code': [None,lambda x = value: returnStarLine(x,length = 31),None,True],                  # Code or abbreviation used by a database organization.
          'Database_type': [None,lambda x = value: returnStarLine(x,length = 31),None,True],                  # The kind of database where the data are located.
          'Entry_code': [None,lambda x = value: returnStarLine(x,length = 31),None,True],                     # The accession code assigned to the entry by the database.
          'Entry_type': [None,lambda x = value: returnStarLine(x,length = 31),None,True],                     # Defines whether the current version of the entry is the original version or an updated version.
          'ORF_code': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                     # Code assigned to the open reading frame coding for a protein or nucleic acid.
          'Gene_locus_code': [None,lambda x = value: returnStarLine(x,length = 127),None,False],              # Unique code assigned to the locus for the gene in the genome.
          'Gene_cDNA_code': [None,lambda x = value: returnStarLine(x,length = 127),None,False],               # The unique code assigned to a cDNA sequence for the gene.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Entity_natural_src_list_ID': [None,returnStarInt,'Entity_natural_src_list.ID',True],               # Pointer to '_Entity_natural_src_list.ID'

                },

        'tagNames': ['Entity_natural_src_ID', 'Entity_ID', 'Entity_label', 'Entity_chimera_segment_ID', 'Database_code', 'Database_type', 'Entry_code', 'Entry_type', 'ORF_code', 'Gene_locus_code', 'Gene_cDNA_code', 'Entry_ID', 'Entity_natural_src_list_ID'],
        'sourcePrimaryKeys': ['Entity_natural_src_ID', 'Database_code', 'Entry_code', 'Entry_ID', 'Entity_natural_src_list_ID'],

            }

        },

    'tableNames': ['Entity_natural_src', 'Natural_source_db']

    },

  'experimental_source': {

    'name': 'Entity_experimental_src_list',
    'saveFrameCode': 'experimental_source',

    'tags': {

      'Sf_category': ['experimental_source',lambda x = value: returnStarCode(x,length = 127),None,True],      # Category assigned to the information in the saveframe.
      'Sf_framecode': [None,lambda x = value: returnStarCode(x,length = 127),None,False],                     # The framecode for the save frame where the experimental sources for each entity are listed.
      'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                     # Pointer to '_Entry.ID'.
      'ID': [None,returnStarInt,None,True],                                                                   # An integer value that uniquely identifies one Entity_experimental_src saveframe from all other saveframes of this category.

            },

    'tagNames': ['Sf_category', 'Sf_framecode', 'Entry_ID', 'ID'],
    'sourcePrimaryKeys': ['Entry_ID', 'ID'],

    'tables': {

      'Entity_experimental_src': {

        'tags': {

          'ID': [None,returnStarInt,None,True],                                                               # An integer value that uniquely identifies each experimental source in the list of experimental sources.
          'Entity_ID': [None,returnStarInt,'Entity.ID',True],                                                 # Pointer to '_Entity.ID'
          'Entity_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Entity.Sf_framecode',True],# Pointer to a saveframe of the category 'entity.'  This is the label assigned to the molecular entity by the author when completing the molecular entity portion of the deposition.
          'Entity_chimera_segment_ID': [None,returnStarInt,'Entity_chimera_segment.ID',False],                # Pointer to '_Entity_chimera_segment.ID'
          'Production_method': [None,lambda x = value: returnStarLine(x,length = 127),None,True],             # The laboratory method used to obtain the biopolymers studied.
          'Host_org_scientific_name': [None,lambda x = value: returnStarLine(x,length = 127),None,False],     # The scientific name of the organism that served as host for the production of the entity.
          'Host_org_name_common': [None,lambda x = value: returnStarLine(x,length = 127),None,False],         # Common name for the organism used as a host in producing a biopolymer.
          'Host_org_details': [None,returnStarString,None,False],                                             # Additional information or comments regarding the host organism.
          'Host_org_NCBI_taxonomy_ID': [None,lambda x = value: returnStarCode(x,length = 12),None,False],     # Unique ID assigned by the NCBI to organisms.
          'Host_org_genus': [None,lambda x = value: returnStarLine(x,length = 127),None,False],               # Genus of the host organism
          'Host_org_species': [None,lambda x = value: returnStarLine(x,length = 127),None,False],             # Scientific name for the species of the organism as defined by NCBI taxonomists whenever possible.
          'Host_org_strain': [None,lambda x = value: returnStarLine(x,length = 127),None,False],              # The scientific name for the strain of an organism.
          'Host_org_variant': [None,lambda x = value: returnStarLine(x,length = 127),None,False],             # Name used to classify the variant of an organism.
          'Host_org_subvariant': [None,lambda x = value: returnStarLine(x,length = 127),None,False],          # In the hierarchy of organism nomenclature$ the name or code designating a subvariant of the organism used to express the entity. These may specific hosts designed with mutations to knock out proteases or other enzymes deleterious to the production of the entity.
          'Host_org_organ': [None,lambda x = value: returnStarLine(x,length = 127),None,False],               # Cell lines used as hosts in producing macromolecules often originate from a particular organ (e.g. chinese hamster ovary cells).  If this is true for the system used in this study please enter the name of the organ that was the source for the cell line used.
          'Host_org_tissue': [None,lambda x = value: returnStarLine(x,length = 127),None,False],              # The tissue from an organism that is the natural or experimental source of the molecule.
          'Host_org_tissue_fraction': [None,lambda x = value: returnStarLine(x,length = 127),None,False],     # The fraction of the tissue which expressed the molecule.
          'Host_org_cell_line': [None,lambda x = value: returnStarLine(x,length = 127),None,False],           # The name for the cell line used in producing the biopolymer.
          'Host_org_cell_type': [None,lambda x = value: returnStarLine(x,length = 127),None,False],           # Specific type of cell if used to produce the biopolymer.
          'Host_org_cellular_location': [None,lambda x = value: returnStarLine(x,length = 127),None,False],   # Identifies the location inside (or outside) the cell which expressed the molecule. Proteins may be excreted from a production host or produced in the periplasmic space as opposed to the cytoplasm.
          'Host_org_organelle': [None,lambda x = value: returnStarLine(x,length = 127),None,False],           # Specific organelle which expressed the molecule.
          'Host_org_gene': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                # Specific gene which expressed the molecule.
          'Host_org_culture_collection': [None,lambda x = value: returnStarLine(x,length = 127),None,False],  # Culture collection of the expression system.
          'Host_org_ATCC_number': [None,lambda x = value: returnStarLine(x,length = 127),None,False],         # Organism culture number defined in the American Type Culture Collection.
          'Vector_type': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                  # The kind of biological object used to insert a gene into a host organism for the production of a biological molecule studied in the entry.
          'PDBview_host_org_vector_name': [None,lambda x = value: returnStarLine(x,length = 127),None,False], # The name of a vector used to insert a gene into a eukaryotic host to express the biopolymer used in the experiments.
          'PDBview_plasmid_name': [None,lambda x = value: returnStarLine(x,length = 127),None,False],         # The name of a plasmid used in a bacterial system to generate the protein or nucleic acid used in the experiments.
          'Vector_name': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                  # Name given to the vector used to insert a gene into a host organism.
          'Vector_details': [None,returnStarString,None,False],                                               # Text comments regarding the vector used to produce the biopolymer.
          'Vendor_name': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                  # Commercial or academic vendor that supplied the defined item.
          'Host_org_dev_stage': [None,returnStarString,None,False],                                           # A string to indicate the life-cycle or cell development cycle in which the gene is expressed and the mature protein is active.
          'Details': [None,returnStarString,None,False],                                                      # Additional information relevant to the data in the current saveframe or to a specific data item is entered as a value to this tag.  The information entered must supplement information already present.  Whenever possible data should associated with specific data tags and not included in the value to a '_Details' tag.
          'Citation_ID': [None,returnStarInt,'Citation.ID',False],                                            # Pointer to '_Citation.ID'
          'Citation_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Citation.Sf_framecode',False],# Pointer to a saveframe of the category 'citation.' The citation would describe how$ for example$ the vector was constructed and the host organism picked.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Entity_experimental_src_list_ID': [None,returnStarInt,'Entity_experimental_src_list.ID',True],     # Pointer to '_Entity_experimental_src_list.ID'

                },

        'tagNames': ['ID', 'Entity_ID', 'Entity_label', 'Entity_chimera_segment_ID', 'Production_method', 'Host_org_scientific_name', 'Host_org_name_common', 'Host_org_details', 'Host_org_NCBI_taxonomy_ID', 'Host_org_genus', 'Host_org_species', 'Host_org_strain', 'Host_org_variant', 'Host_org_subvariant', 'Host_org_organ', 'Host_org_tissue', 'Host_org_tissue_fraction', 'Host_org_cell_line', 'Host_org_cell_type', 'Host_org_cellular_location', 'Host_org_organelle', 'Host_org_gene', 'Host_org_culture_collection', 'Host_org_ATCC_number', 'Vector_type', 'PDBview_host_org_vector_name', 'PDBview_plasmid_name', 'Vector_name', 'Vector_details', 'Vendor_name', 'Host_org_dev_stage', 'Details', 'Citation_ID', 'Citation_label', 'Entry_ID', 'Entity_experimental_src_list_ID'],
        'sourcePrimaryKeys': ['ID', 'Entry_ID', 'Entity_experimental_src_list_ID'],

            }

        },

    'tableNames': ['Entity_experimental_src']

    },

  'chem_comp': {

    'name': 'Chem_comp',

    'tags': {

      'Sf_category': ['chem_comp',lambda x = value: returnStarCode(x,length = 127),None,True],                # Category assigned to the information in the saveframe.
      'Sf_framecode': [None,lambda x = value: returnStarCode(x,length = 127),None,False],                     # A descriptive label that uniquely identifies this chemical component.
      'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                     # Pointer to '_Entry.ID'
      'ID': [None,lambda x = value: returnStarCode(x,length = 12),None,True],                                 # A code that uniquely identifies the chemical component from all other chemical components in the entry.
      'Provenance': [None,lambda x = value: returnStarLine(x,length = 127),None,True],                        # The tag value defines the source of the data used to construct the chem_comp record.
      'Name': [None,lambda x = value: returnStarLine(x,length = 4096),None,True],                             # A common name for the chemical component or monomer.
      'Type': [None,lambda x = value: returnStarLine(x,length = 127),None,True],                              # Chemical components can be of two molecular types either a complete chemical compound or a fragment of a complete chemical compound.
      'BMRB_code': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                         # Twelve character code assigned to the chemical component by BMRB.
      'PDB_code': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                          # Three character code assigned to the chemical component by the PDB.
      'Ambiguous_flag': [None,lambda x = value: returnStarCode(x,length = 3),None,False],                     # A preliminary classification used by PDB to indicate that the chemistry of this component while described as clearly as possible is still ambiguous.  Software tools may not be able to process this component definition.
      'Initial_date': [None,returnStarDateTime,None,False],                                                   # Date the chemical component was added to the database.
      'Modified_date': [None,returnStarDateTime,None,False],                                                  # Date that the component was last modified.
      'Release_status': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                   # This data item holds the current release status for the component.
      'Replaced_by': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                       # Identifies the _chem_comp.id of the new component that has replaced this component.
      'Replaces': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                         # Identifies the _chem_comp.id of the component this entry replaces. Converse of _replaced_by.
      'One_letter_code': [None,lambda x = value: returnStarString(x,length = 1),None,False],                  # For standard polymer components$ the one-letter code for the component. If there is not a standard one-letter code for this component$ or if this is a non-polymer component$ the one-letter code should be given as 'X'. This code may be preceded by a '+' character to indicate that the component is a modification of a standard component.
      'Three_letter_code': [None,lambda x = value: returnStarString(x,length = 15),None,False],               # For standard polymer components$ the three-letter code for the component. If there is not a standard three-letter code for this component$ or if this is a non-polymer component$ the three-letter code should be given as 'UNK'. This code may be preceded by a '+' character to indicate that the component is a modification of a standard component.
      'Number_atoms_all': [None,returnStarInt,None,False],                                                    # The total number of atoms in the component.
      'Number_atoms_nh': [None,returnStarInt,None,False],                                                     # The number of non-hydrogen atoms in the component.
      'PubChem_code': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                      # The substance ID code assigned to the compound by the PubChem database.
      'Subcomponent_list': [None,returnStarString,None,False],                                                # The list of subcomponents contained in this component.
      'InCHi_code': [None,lambda x = value: returnStarString(x,length = 1024),None,False],                    # Enter the InCHi code that uniquely describes the chemical structure of the compound.
      'Mon_nstd_flag': [None,lambda x = value: returnStarYesNo(x,length = 3),None,False],                     # A flag defining the non-standard status of the chemical component.  A value of Y indicates that the compound is a standard molecule.
      'Mon_nstd_class': [None,returnStarString,None,False],                                                   # A description of the class of a nonstandard monomer if the nonstandard monomer represents a modification of a standard monomer.
      'Mon_nstd_details': [None,returnStarString,None,False],                                                 # A description of special details of a nonstandard monomer.
      'Mon_nstd_parent': [None,returnStarString,None,False],                                                  # The name of the parent monomer of the nonstandard monomer$ if the nonstandard monomer represents a modification of a standard monomer.
      'Mon_nstd_parent_comp_ID': [None,lambda x = value: returnStarLine(x,length = 1024),None,False],         # The identifier for the parent component of the nonstandard component. May be a comma-separated list if this component is derived from multiple components.
      'Std_deriv_one_letter_code': [None,lambda x = value: returnStarCode(x,length = 15),None,False],         # The one letter code for the standard monomer from which the chemical component is derived.
      'Std_deriv_three_letter_code': [None,lambda x = value: returnStarCode(x,length = 15),None,False],       # The three letter code for the standard monomer from which the chemical component is derived.
      'Std_deriv_BMRB_code': [None,lambda x = value: returnStarCode(x,length = 15),None,False],               # The BMRB code for the standard monomer from which the chemical component is derived.
      'Std_deriv_PDB_code': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                # The PDB code for the standard monomer from which the chemical component is derived.
      'Std_deriv_chem_comp_name': [None,lambda x = value: returnStarLine(x,length = 127),None,False],         # The name of the standard chemical component from which the chemical component was derived.
      'Synonyms': [None,lambda x = value: returnStarLine(x,length = 1024),None,False],                        # Synonym list for the component.
      'Formal_charge': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                     # The formal electrical charge on the chemical compound.
      'Paramagnetic': [None,lambda x = value: returnStarYesNo(x,length = 3),None,False],                      # A boolean flag that defines the paramagnetic status of the chemical component.
      'Aromatic': [None,lambda x = value: returnStarYesNo(x,length = 3),None,False],                          # A boolean flag that defines the aromatic status of the chemical component.
      'Formula': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                          # The empirical chemical formula for the chemical component.
      'Formula_weight': [None,returnStarFloat,None,False],                                                    # Formula mass in daltons of the chemical component.
      'Formula_mono_iso_wt_nat': [None,returnStarFloat,None,False],                                           # Mono-isotopic formula mass calculated using the most abundant naturally occuring isotope for each atom.
      'Formula_mono_iso_wt_13C': [None,returnStarFloat,None,False],                                           # Mono-isotopic formula mass calculated using the most abundant naturally occuring isotope for each atom except carbon$ where the mass of the 13C isotope is used.
      'Formula_mono_iso_wt_15N': [None,returnStarFloat,None,False],                                           # Mono-isotopic formula mass calculated using the most abundant naturally occuring isotope for each atom except nitrogen$ where the mass of the 15N isotope is used.
      'Formula_mono_iso_wt_13C_15N': [None,returnStarFloat,None,False],                                       # Mono-isotopic formula mass calculated using the most abundant naturally occuring isotope for each atom except carbon and nitrogen$ where the mass of the 13C and 15N isotopes are used.
      'Image_file_name': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                  # Name of the file that contains an image of the chemical compound.
      'Image_file_format': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                # Type of image file format
      'Topo_file_name': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                   # Name of the file containing the information about the topology of the chemical compound.
      'Topo_file_format': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                 # The type of format for the file containing the topology information for the chemical compound.
      'Struct_file_name': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                 # Name of a structure file attached to the entry for a chemical component.
      'Struct_file_format': [None,lambda x = value: returnStarLine(x,length = 127),None,False],               # File format for the attached structure file.
      'Stereochem_param_file_name': [None,lambda x = value: returnStarLine(x,length = 127),None,False],       # Name of a file that contains the stereochemical parameters for the chemical component.
      'Stereochem_param_file_format': [None,lambda x = value: returnStarLine(x,length = 127),None,False],     # File format for the attached stereochemical parameter file.
      'Model_details': [None,returnStarString,None,False],                                                    # A description of special aspects of the generation of the coordinates for the model of the component.
      'Model_erf': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                        # A pointer to an external reference file from which the atomic
      'Model_source': [None,returnStarString,None,False],                                                     # The source of the coordinates for the model of the component.
      'Model_coordinates_details': [None,returnStarString,None,False],                                        # Provides additional details about the model coordinates in the component definition.
      'Model_coordinates_missing_flag': [None,lambda x = value: returnStarCode(x,length = 3),None,False],     # This data item identifies if model coordinates are missing in this definition.
      'Ideal_coordinates_details': [None,returnStarString,None,False],                                        # Identifies the source of the ideal coordinates in the component definition.
      'Ideal_coordinates_missing_flag': [None,lambda x = value: returnStarCode(x,length = 3),None,False],     # Identifies if ideal coordinates are missing in this definition.
      'Model_coordinates_db_code': [None,lambda x = value: returnStarLine(x,length = 127),None,False],        # This item identifies the PDB database code from which the atom model coordinates were obtained.
      'Processing_site': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                   # This data item identifies the deposition site that processed this chemical component defintion.
      'Vendor': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                           # Name of the company where the compound was purchased.
      'Vendor_product_code': [None,lambda x = value: returnStarLine(x,length = 127),None,False],              # The product code assigned to the compound by the vender where the compound was purchased.
      'Details': [None,returnStarString,None,False],                                                          # Additional text information that is relevant to the data in the current saveframe or to a specific data item in the saveframe.  This tag is often used to include information that cannot be associated with a specific tag in the saveframe$ but is important.
      'DB_query_date': [None,returnStarDateTime,None,False],                                                  # Date when the last query was carried out to search for information on the chemical compound.
      'DB_last_query_revised_last_date': [None,returnStarDateTime,None,False],                                # Date the last time new information for the compound was found when a query was executed.

            },

    'tagNames': ['Sf_category', 'Sf_framecode', 'Entry_ID', 'ID', 'Provenance', 'Name', 'Type', 'BMRB_code', 'PDB_code', 'Ambiguous_flag', 'Initial_date', 'Modified_date', 'Release_status', 'Replaced_by', 'Replaces', 'One_letter_code', 'Three_letter_code', 'Number_atoms_all', 'Number_atoms_nh', 'PubChem_code', 'Subcomponent_list', 'InCHi_code', 'Mon_nstd_flag', 'Mon_nstd_class', 'Mon_nstd_details', 'Mon_nstd_parent', 'Mon_nstd_parent_comp_ID', 'Std_deriv_one_letter_code', 'Std_deriv_three_letter_code', 'Std_deriv_BMRB_code', 'Std_deriv_PDB_code', 'Std_deriv_chem_comp_name', 'Synonyms', 'Formal_charge', 'Paramagnetic', 'Aromatic', 'Formula', 'Formula_weight', 'Formula_mono_iso_wt_nat', 'Formula_mono_iso_wt_13C', 'Formula_mono_iso_wt_15N', 'Formula_mono_iso_wt_13C_15N', 'Image_file_name', 'Image_file_format', 'Topo_file_name', 'Topo_file_format', 'Struct_file_name', 'Struct_file_format', 'Stereochem_param_file_name', 'Stereochem_param_file_format', 'Model_details', 'Model_erf', 'Model_source', 'Model_coordinates_details', 'Model_coordinates_missing_flag', 'Ideal_coordinates_details', 'Ideal_coordinates_missing_flag', 'Model_coordinates_db_code', 'Processing_site', 'Vendor', 'Vendor_product_code', 'Details', 'DB_query_date', 'DB_last_query_revised_last_date'],
    'sourcePrimaryKeys': ['Entry_ID', 'ID'],

    'tables': {

      'Chem_comp_common_name': {

        'tags': {

          'Name': [None,lambda x = value: returnStarLine(x,length = 1024),None,True],                         # A synonym for the chemical component or monomer.
          'Type': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                         # The type of name given to the compound (abbreviation$ etc.).
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Comp_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Chem_comp.ID',True],              # Pointer to '_Chem_comp.ID'

                },

        'tagNames': ['Name', 'Type', 'Entry_ID', 'Comp_ID'],
        'sourcePrimaryKeys': ['Name', 'Entry_ID', 'Comp_ID'],

            },

      'Chem_comp_bio_function': {

        'tags': {

          'Biological_function': [None,returnStarString,None,True],                                           # A specific function carried out by the molecular entity in its native biological system.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Comp_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Chem_comp.ID',True],              # Pointer to '_Chem_comp.ID'

                },

        'tagNames': ['Biological_function', 'Entry_ID', 'Comp_ID'],
        'sourcePrimaryKeys': ['Biological_function', 'Entry_ID', 'Comp_ID'],

            },

      'Chem_comp_descriptor': {

        'tags': {

          'Descriptor': [None,lambda x = value: returnStarString(x,length = 1024),None,True],                 # This data item contains the descriptor value for this component.
          'Type': [None,lambda x = value: returnStarLine(x,length = 127),None,True],                          # This data item contains the descriptor type.
          'Program': [None,lambda x = value: returnStarLine(x,length = 127),None,True],                       # This data item contains the name of the program or library used to compute the descriptor.
          'Program_version': [None,lambda x = value: returnStarLine(x,length = 127),None,False],              # This data item contains the version of the program
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Comp_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Chem_comp.ID',True],              # Pointer to '_Chem_comp.ID'

                },

        'tagNames': ['Descriptor', 'Type', 'Program', 'Program_version', 'Entry_ID', 'Comp_ID'],
        'sourcePrimaryKeys': ['Entry_ID', 'Comp_ID'],

            },

      'Chem_comp_identifier': {

        'tags': {

          'Identifier': [None,lambda x = value: returnStarString(x,length = 1024),None,True],                 # This data item contains the identifier value for this component.
          'Type': [None,lambda x = value: returnStarLine(x,length = 127),None,True],                          # This data item contains the identifier type.
          'Program': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                      # This data item contains the name of the program or library used to compute the identifier.
          'Program_version': [None,lambda x = value: returnStarLine(x,length = 127),None,False],              # This data item contains the version of the program or library used to compute the identifier.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Comp_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Chem_comp.ID',True],              # Pointer to '_Chem_comp.ID'

                },

        'tagNames': ['Identifier', 'Type', 'Program', 'Program_version', 'Entry_ID', 'Comp_ID'],
        'sourcePrimaryKeys': ['Entry_ID', 'Comp_ID'],

            },

      'Chem_comp_systematic_name': {

        'tags': {

          'Name': [None,lambda x = value: returnStarLine(x,length = 1024),None,True],                         # A name for the chemical compound that has been defined by an official body or is derived from rules defined by an official organization recognized by the scientific community.
          'Naming_system': [None,lambda x = value: returnStarLine(x,length = 127),None,True],                 # An official method of nomenclature or defined set of nomenclature for chemical compounds recognized by the scientific community.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Comp_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Chem_comp.ID',True],              # Pointer to '_Chem_comp.ID'

                },

        'tagNames': ['Name', 'Naming_system', 'Entry_ID', 'Comp_ID'],
        'sourcePrimaryKeys': ['Naming_system', 'Entry_ID', 'Comp_ID'],

            },

      'Chem_comp_SMILES': {

        'tags': {

          'Type': [None,lambda x = value: returnStarLine(x,length = 31),None,True],                           # The type of SMILES string provided is defined by this tag value.
          'String': [None,lambda x = value: returnStarString(x,length = 1024),None,True],                     # SMILES string for the chemical component.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Comp_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Chem_comp.ID',True],              # Pointer to '_Chem_comp.ID'

                },

        'tagNames': ['Type', 'String', 'Entry_ID', 'Comp_ID'],
        'sourcePrimaryKeys': ['Type', 'String', 'Entry_ID', 'Comp_ID'],

            },

      'Chem_comp_keyword': {

        'tags': {

          'Keyword': [None,lambda x = value: returnStarLine(x,length = 127),None,True],                       # A keyword or brief phrase describing the chemical compound.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Comp_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Chem_comp.ID',True],              # Pointer to '_Chem_comp.ID'

                },

        'tagNames': ['Keyword', 'Entry_ID', 'Comp_ID'],
        'sourcePrimaryKeys': ['Keyword', 'Entry_ID', 'Comp_ID'],

            },

      'PDBX_chem_comp_feature': {

        'tags': {

          'Type': [None,lambda x = value: returnStarLine(x,length = 255),None,True],                          # The component feature type.
          'Value': [None,returnStarString,None,True],                                                         # The component feature value.
          'Source': [None,lambda x = value: returnStarLine(x,length = 255),None,True],                        # The information source for the component feature.
          'Support': [None,returnStarString,None,False],                                                      # The supporting evidence for this feature.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Comp_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Chem_comp.ID',True],              # Pointer to '_Chem_comp.ID'

                },

        'tagNames': ['Type', 'Value', 'Source', 'Support', 'Entry_ID', 'Comp_ID'],
        'sourcePrimaryKeys': ['Type', 'Value', 'Source', 'Entry_ID', 'Comp_ID'],

            },

      'Characteristic': {

        'tags': {

          'ID': [None,returnStarInt,None,True],                                                               # A value that uniquely identifies each characteristic provided in the list.
          'Name': [None,lambda x = value: returnStarLine(x,length = 127),None,True],                          # Name for the reported characteristic of the chemical component.
          'Atom_ID': [None,lambda x = value: returnStarAtCode(x,length = 12),'Chem_comp_atom.Atom_ID',True],  # Pointer to '_Chem_comp_atom.Atom_ID'
          'Chemical_group': [None,lambda x = value: returnStarLine(x,length = 127),None,False],               # Chemical group that is responsible for the observed characteristic of the chemical component.
          'Val': [None,returnStarFloat,None,True],                                                            # Value for the defined characteristic of the chemical component.
          'Val_err': [None,returnStarFloat,None,True],                                                        # Estimated error in the reported characteristic of the chemical component.
          'Source': [None,lambda x = value: returnStarLine(x,length = 127),None,True],                        # Experimental source for the value reported for the chemical component.
          'Citation_ID': [None,returnStarInt,'Citation.ID',True],                                             # Pointer to '_Citation.ID'
          'Citation_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Citation.Sf_framecode',True],# Pointer to a saveframe of the category citation.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Comp_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Chem_comp.ID',True],              # Pointer to '_Chem_comp.ID'

                },

        'tagNames': ['ID', 'Name', 'Atom_ID', 'Chemical_group', 'Val', 'Val_err', 'Source', 'Citation_ID', 'Citation_label', 'Entry_ID', 'Comp_ID'],
        'sourcePrimaryKeys': ['ID', 'Entry_ID', 'Comp_ID'],

            },

      'Chem_comp_atom': {

        'tags': {

          'Atom_ID': [None,lambda x = value: returnStarAtCode(x,length = 12),None,True],                      # The value of _chem_comp_atom.atom_id must uniquely identify each atom in each monomer in the CHEM_COMP_ATOM list.
          'BMRB_code': [None,lambda x = value: returnStarAtCode(x,length = 12),None,True],                    # A code assigned to the atom by BMRB that is unique within the chemical compound.
          'PDB_atom_ID': [None,lambda x = value: returnStarAtCode(x,length = 12),None,False],                 # Name given to the atom by the PDB.
          'Alt_atom_ID': [None,lambda x = value: returnStarAtCode(x,length = 12),None,False],                 # An alternative identifier for the atom. This data item would be used in cases where alternative nomenclatures exist for labelling atoms in a group.
          'Auth_atom_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                  # An alternative identifier for Atom_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Type_symbol': [None,lambda x = value: returnStarCode(x,length = 15),None,True],                    # The IUPAC symbol used for the atom (H; C; P; O; S).
          'Isotope_number': [None,returnStarInt,None,False],                                                  # Mass number assigned to the atom.
          'Chirality': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                     # The chiral or prochiral characteristic of the atom.
          'Stereo_config': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                 # The chiral configuration of the atom that is a chiral center.
          'Charge': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                        # The net integer charge assigned to this atom. This is the formal charge assignment normally found in chemical diagrams.
          'Partial_charge': [None,returnStarFloat,None,False],                                                # The partial charge assigned to this atom.
          'Oxidation_number': [None,lambda x = value: returnStarCode(x,length = 15),None,False],              # The oxidation number for the atom.
          'Unpaired_electron_number': [None,returnStarInt,None,False],                                        # The number of unpaired electrons on the atom.
          'Align': [None,returnStarInt,None,False],                                                           # Determines which column the atom name appears within the PDB coordinate files. The possible values are 0 or 1.
          'Aromatic_flag': [None,lambda x = value: returnStarYesNo(x,length = 3),None,False],                 # A flag indicating an aromatic atom.
          'Leaving_atom_flag': [None,lambda x = value: returnStarYesNo(x,length = 3),None,False],             # A flag indicating a leaving atom.
          'Substruct_code': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                # This data item assigns the atom to a substructure of the component$ if appropriate.
          'Ionizable': [None,lambda x = value: returnStarYesNo(x,length = 3),None,False],                     # A code indicating the potential for the atom to be in an ionized state.
          'Drawing_2D_coord_x': [None,returnStarFloat,None,False],                                            # X coordinate of a data point in a two-dimensional drawing of the chemical compound.
          'Drawing_2D_coord_y': [None,returnStarFloat,None,False],                                            # Y coordinate of a data point in a two-dimensional drawing of the chemical compound.
          'Model_Cartn_x': [None,returnStarFloat,None,False],                                                 # X coordinate in a Cartesian system for an atom in the chemical compound.
          'Model_Cartn_x_esd': [None,returnStarFloat,None,False],                                             # The standard uncertainty (estimated standard deviation) of _chem_comp_atom.model_Cartn_x.
          'Model_Cartn_y': [None,returnStarFloat,None,False],                                                 # Y coordinate in a Cartesian system for an atom in the chemical compound.
          'Model_Cartn_y_esd': [None,returnStarFloat,None,False],                                             # The standard uncertainty (estimated standard deviation) of _chem_comp_atom.model_Cartn_y.
          'Model_Cartn_z': [None,returnStarFloat,None,False],                                                 # Z coordinate in a Cartesian system for an atom in the chemical compound.
          'Model_Cartn_z_esd': [None,returnStarFloat,None,False],                                             # The standard uncertainty (estimated standard deviation) of _chem_comp_atom.model_Cartn_z.
          'Model_Cartn_x_ideal': [None,returnStarFloat,None,False],                                           # Computed idealized coordinates$ x component of the vector (in Angstroms)
          'Model_Cartn_y_ideal': [None,returnStarFloat,None,False],                                           # Computed idealized coordinates$ y component of the vector (in Angstroms)
          'Model_Cartn_z_ideal': [None,returnStarFloat,None,False],                                           # Computed idealized coordinates$ z component of the vector (in Angstroms)
          'PDBX_ordinal': [None,returnStarInt,None,False],                                                    # Ordinal index for the chemical component atom list.
          'Details': [None,returnStarString,None,False],                                                      # Text providing additional information about the atom.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Comp_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Chem_comp.ID',True],              # Pointer to '_Chem_comp.ID'

                },

        'tagNames': ['Atom_ID', 'BMRB_code', 'PDB_atom_ID', 'Alt_atom_ID', 'Auth_atom_ID', 'Type_symbol', 'Isotope_number', 'Chirality', 'Stereo_config', 'Charge', 'Partial_charge', 'Oxidation_number', 'Unpaired_electron_number', 'Align', 'Aromatic_flag', 'Leaving_atom_flag', 'Substruct_code', 'Ionizable', 'Drawing_2D_coord_x', 'Drawing_2D_coord_y', 'Model_Cartn_x', 'Model_Cartn_x_esd', 'Model_Cartn_y', 'Model_Cartn_y_esd', 'Model_Cartn_z', 'Model_Cartn_z_esd', 'Model_Cartn_x_ideal', 'Model_Cartn_y_ideal', 'Model_Cartn_z_ideal', 'PDBX_ordinal', 'Details', 'Entry_ID', 'Comp_ID'],
        'sourcePrimaryKeys': ['Atom_ID', 'Entry_ID', 'Comp_ID'],

            },

      'Atom_nomenclature': {

        'tags': {

          'Atom_ID': [None,lambda x = value: returnStarAtCode(x,length = 12),'Chem_comp_atom.Atom_ID',True],  # Pointer to '_Chem_comp_atom.Atom_ID'
          'Atom_name': [None,lambda x = value: returnStarLine(x,length = 15),None,True],                      # Alternate atom name defined by an organization or official body.
          'Naming_system': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                # The name of the systematic atom nomenclature.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Comp_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Chem_comp.ID',True],              # Pointer to '_Chem_comp.ID'

                },

        'tagNames': ['Atom_ID', 'Atom_name', 'Naming_system', 'Entry_ID', 'Comp_ID'],
        'sourcePrimaryKeys': ['Atom_ID', 'Entry_ID', 'Comp_ID'],

            },

      'Chem_comp_bond': {

        'tags': {

          'ID': [None,returnStarInt,None,True],                                                               # The value of _chem_comp_bond.id must uniquely identify a record in the Chem_comp_bond list.
          'Type': [None,lambda x = value: returnStarLine(x,length = 31),None,True],                           # A common chemical bond descriptive name.
          'Value_order': [None,lambda x = value: returnStarLine(x,length = 31),None,True],                    # The value that should be taken as the target for the chemical bond associated with the specified atoms$ expressed as a bond order.
          'Atom_ID_1': [None,lambda x = value: returnStarAtCode(x,length = 12),'Chem_comp_atom.Atom_ID',True],# Pointer to '_Chem_comp_atom.Atom_ID'
          'Atom_ID_2': [None,lambda x = value: returnStarAtCode(x,length = 12),'Chem_comp_atom.Atom_ID',True],# Pointer to '_Chem_comp_atom.Atom_ID'
          'Aromatic_flag': [None,lambda x = value: returnStarCode(x,length = 3),None,False],                  # A flag indicating an aromatic bond.
          'Stereo_config': [None,lambda x = value: returnStarCode(x,length = 3),None,False],                  # Stereochemical configuration across a double bond.
          'Ordinal': [None,returnStarInt,None,False],                                                         # Ordinal index for the component bond list.
          'Details': [None,returnStarString,None,False],                                                      # A text description of the bond.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Comp_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Chem_comp.ID',True],              # Pointer to '_Chem_comp.ID'

                },

        'tagNames': ['ID', 'Type', 'Value_order', 'Atom_ID_1', 'Atom_ID_2', 'Aromatic_flag', 'Stereo_config', 'Ordinal', 'Details', 'Entry_ID', 'Comp_ID'],
        'sourcePrimaryKeys': ['ID', 'Entry_ID', 'Comp_ID'],

            },

      'Chem_comp_tor': {

        'tags': {

          'ID': [None,returnStarInt,None,True],                                                               # The value of _chem_comp_tor.id must uniquely identify a record in the Chem_comp_tor list.
          'Atom_ID_1': [None,lambda x = value: returnStarAtCode(x,length = 12),'Chem_comp_atom.Atom_ID',True],# Pointer to '_Chem_comp_atom.Atom_ID'
          'Atom_ID_2': [None,lambda x = value: returnStarAtCode(x,length = 12),'Chem_comp_atom.Atom_ID',True],# Pointer to '_Chem_comp_atom.Atom_ID'
          'Atom_ID_3': [None,lambda x = value: returnStarAtCode(x,length = 12),'Chem_comp_atom.Atom_ID',True],# Pointer to '_Chem_comp_atom.Atom_ID'
          'Atom_ID_4': [None,lambda x = value: returnStarAtCode(x,length = 12),'Chem_comp_atom.Atom_ID',True],# Pointer to '_Chem_comp_atom.Atom_ID'
          'Details': [None,returnStarString,None,False],                                                      # A text description of the torsion angle.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Comp_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Chem_comp.ID',True],              # Pointer to '_Chem_comp.ID'

                },

        'tagNames': ['ID', 'Atom_ID_1', 'Atom_ID_2', 'Atom_ID_3', 'Atom_ID_4', 'Details', 'Entry_ID', 'Comp_ID'],
        'sourcePrimaryKeys': ['ID', 'Entry_ID', 'Comp_ID'],

            },

      'Chem_comp_angle': {

        'tags': {

          'ID': [None,returnStarInt,None,True],                                                               # The value of _chem_comp_angle.id must uniquely identify a record in the Chem_comp_tor list.
          'Atom_ID_1': [None,lambda x = value: returnStarAtCode(x,length = 12),'Chem_comp_atom.Atom_ID',True],# Pointer to '_Chem_comp_atom.Atom_ID'
          'Atom_ID_2': [None,lambda x = value: returnStarAtCode(x,length = 12),'Chem_comp_atom.Atom_ID',True],# Pointer to '_Chem_comp_atom.Atom_ID'
          'Atom_ID_3': [None,lambda x = value: returnStarAtCode(x,length = 12),'Chem_comp_atom.Atom_ID',True],# Pointer to '_Chem_comp_atom.Atom_ID'
          'Details': [None,returnStarString,None,False],                                                      # Text providing additional information regarding the angle formed by the three atoms.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Comp_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Chem_comp.ID',True],              # Pointer to '_Chem_comp.ID'

                },

        'tagNames': ['ID', 'Atom_ID_1', 'Atom_ID_2', 'Atom_ID_3', 'Details', 'Entry_ID', 'Comp_ID'],
        'sourcePrimaryKeys': ['ID', 'Entry_ID', 'Comp_ID'],

            },

      'Chem_comp_db_link': {

        'tags': {

          'Author_supplied': [None,lambda x = value: returnStarYesNo(x,length = 3),None,False],               # A code indicating if the database link was provided by the author of the deposition (yes) or by another source (no).
          'Database_code': [None,lambda x = value: returnStarLine(x,length = 127),None,True],                 # Enter the abbreviation or acronym for the database site for the entry for the chemical compound.
          'Accession_code': [None,lambda x = value: returnStarLine(x,length = 31),None,True],                 # Enter the accession code for the chemical compound from the database listed.
          'Accession_code_type': [None,lambda x = value: returnStarLine(x,length = 127),None,False],          # The type of accession code reported.
          'Entry_mol_code': [None,lambda x = value: returnStarLine(x,length = 127),None,False],               # Code used by the database for the molecule.
          'Entry_mol_name': [None,lambda x = value: returnStarLine(x,length = 127),None,False],               # Name given by the database to the molecule.
          'Entry_experimental_method': [None,lambda x = value: returnStarLine(x,length = 127),None,False],    # If appropriate$ list the experimental technique (NMR$ mass spectrometry$ X-ray crystallography) that was used to collect the data in the entry at the database listed.
          'Entry_relation_type': [None,lambda x = value: returnStarLine(x,length = 127),None,False],          # Describe the relationship between the entry in the listed database and this BMRB entry.  This might include the physical properties of the compound or the position of the compound in a metabolic pathway$ for example.
          'Entry_details': [None,returnStarString,None,False],                                                # If appropriate$ additional text information regarding the entry in the listed database can be entered in this field.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Comp_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Chem_comp.ID',True],              # Pointer to '_Chem_comp.ID'

                },

        'tagNames': ['Author_supplied', 'Database_code', 'Accession_code', 'Accession_code_type', 'Entry_mol_code', 'Entry_mol_name', 'Entry_experimental_method', 'Entry_relation_type', 'Entry_details', 'Entry_ID', 'Comp_ID'],
        'sourcePrimaryKeys': ['Database_code', 'Accession_code', 'Entry_ID', 'Comp_ID'],

            },

      'Chem_comp_citation': {

        'tags': {

          'Citation_ID': [None,returnStarInt,'Citation.ID',True],                                             # Pointer to '_Citation.ID'
          'Citation_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Citation.Sf_framecode',True],# Pointer to a saveframe of the category citation.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Comp_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Chem_comp.ID',True],              # Pointer to '_Chem_comp.ID'

                },

        'tagNames': ['Citation_ID', 'Citation_label', 'Entry_ID', 'Comp_ID'],
        'sourcePrimaryKeys': ['Citation_ID', 'Entry_ID', 'Comp_ID'],

            }

        },

    'tableNames': ['Chem_comp_common_name', 'Chem_comp_bio_function', 'Chem_comp_descriptor', 'Chem_comp_identifier', 'Chem_comp_systematic_name', 'Chem_comp_SMILES', 'Chem_comp_keyword', 'PDBX_chem_comp_feature', 'Characteristic', 'Chem_comp_atom', 'Atom_nomenclature', 'Chem_comp_bond', 'Chem_comp_tor', 'Chem_comp_angle', 'Chem_comp_db_link', 'Chem_comp_citation']

    },

  'sample': {

    'name': 'Sample',

    'tags': {

      'Sf_category': ['sample',lambda x = value: returnStarCode(x,length = 127),None,True],                   # Category assigned to the information in the saveframe.
      'Sf_framecode': [None,lambda x = value: returnStarCode(x,length = 127),None,False],                     # A value that uniquely identifies this sample from the other samples listed in the entry.
      'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                     # Pointer to '_Entry.ID'
      'ID': [None,returnStarInt,None,True],                                                                   # A value that uniquely identifies the sample described from the other samples listed in the entry.
      'Type': [None,lambda x = value: returnStarLine(x,length = 127),None,True],                              # A descriptive term for the sample that defines the general physical properties of the sample.
      'Sub_type': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                         # Solid and solution NMR samples of different types are often used. Please select the specific type of sample used.
      'Details': [None,returnStarString,None,False],                                                          # Describe the sample.  Note any atypical components or conditions and discuss their importance.
      'Aggregate_sample_number': [None,returnStarInt,None,False],                                             # Total number of samples represented by the concentration range reported in category _Sample_component.
      'Solvent_system': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                   # The solvent components of the sample.
      'Preparation_date': [None,returnStarDateTime,None,False],                                               # Date the sample was prepared.
      'Preparation_expiration_date': [None,returnStarDateTime,None,False],                                    # Date after which the sample should not be used.
      'Polycrystallization_protocol': [None,returnStarString,None,False],                                     # Protocol used for preparing polycrystalline samples.
      'Single_crystal_protocol': [None,returnStarString,None,False],                                          # Text protocol used to prepare single crystals.
      'Crystal_grow_apparatus': [None,lambda x = value: returnStarLine(x,length = 127),None,False],           # Apparatus used to grow the crystals
      'Crystal_grow_atmosphere': [None,lambda x = value: returnStarLine(x,length = 127),None,False],          # Atmosphere used to grow the crystals.
      'Crystal_grow_details': [None,returnStarString,None,False],                                             # Text providing additional information regarding the methods used to grow crystals.
      'Crystal_grow_method': [None,returnStarString,None,False],                                              # Name for the method used to grow the crystals.
      'Crystal_grow_method_cit_ID': [None,returnStarInt,'Citation.ID',False],                                 # Pointer to '_Citation.ID'  The citation referenced provides a description of the method used to grow the crystals.
      'Crystal_grow_pH': [None,returnStarFloat,None,False],                                                   # The pH used to grow the crystals$ if a specific value was used.
      'Crystal_grow_pH_range': [None,lambda x = value: returnStarLine(x,length = 127),None,False],            # The pH range over which the crystals were grown$ where a single pH value was not used or known.
      'Crystal_grow_pressure': [None,returnStarFloat,None,False],                                             # Pressure under which the crystals were grown.
      'Crystal_grow_pressure_esd': [None,returnStarFloat,None,False],                                         # Estemated error in the pressure value used to grow the crystals.
      'Crystal_grow_seeding': [None,lambda x = value: returnStarLine(x,length = 127),None,False],             # Code defining the type of seeding used to initiate the growth of the crystals.
      'Crystal_grow_seeding_cit_ID': [None,returnStarInt,'Citation.ID',False],                                # Pointer to '_Citation.ID'  The citation referenced provides a description of the method used to seed the crystallization.
      'Crystal_grow_temp': [None,returnStarFloat,None,False],                                                 # Temperature used to grw the crystals.
      'Crystal_grow_temp_details': [None,returnStarString,None,False],                                        # Text providing additional information regarding the temperature used to grow the crystals.
      'Crystal_grow_temp_esd': [None,returnStarFloat,None,False],                                             # Estimated error in the reported temperature value used to grow the crystals.
      'Crystal_grow_time': [None,returnStarFloat,None,False],                                                 # The time required to grow the crystals.
      'Oriented_sample_prep_protocol': [None,returnStarString,None,False],                                    # Protocol used to prepare oriented crystal samples.
      'Lyophilization_cryo_protectant': [None,lambda x = value: returnStarLine(x,length = 127),None,False],   # Chemical used to protect the sample during lyophilization.
      'Storage_protocol': [None,returnStarString,None,False],                                                 # Protocol used for storing sample.

            },

    'tagNames': ['Sf_category', 'Sf_framecode', 'Entry_ID', 'ID', 'Type', 'Sub_type', 'Details', 'Aggregate_sample_number', 'Solvent_system', 'Preparation_date', 'Preparation_expiration_date', 'Polycrystallization_protocol', 'Single_crystal_protocol', 'Crystal_grow_apparatus', 'Crystal_grow_atmosphere', 'Crystal_grow_details', 'Crystal_grow_method', 'Crystal_grow_method_cit_ID', 'Crystal_grow_pH', 'Crystal_grow_pH_range', 'Crystal_grow_pressure', 'Crystal_grow_pressure_esd', 'Crystal_grow_seeding', 'Crystal_grow_seeding_cit_ID', 'Crystal_grow_temp', 'Crystal_grow_temp_details', 'Crystal_grow_temp_esd', 'Crystal_grow_time', 'Oriented_sample_prep_protocol', 'Lyophilization_cryo_protectant', 'Storage_protocol'],
    'sourcePrimaryKeys': ['Entry_ID', 'ID'],

    'tables': {

      'Sample_component': {

        'tags': {

          'ID': [None,returnStarInt,None,True],                                                               # A value that uniquely identifies each component of the sample in the component list.
          'Mol_common_name': [None,lambda x = value: returnStarLine(x,length = 127),None,True],               # Enter the common name for a component of the sample.  Include molecules under study as well as buffers and salts.
          'Isotopic_labeling': [None,lambda x = value: returnStarLine(x,length = 127),None,False],            # If this molecule in the sample was isotopically labeled provide a description of the labeling using the methods recommended by the current IUPAC/IUBMB/IUPAB Interunion Task Group
          'Assembly_ID': [None,returnStarInt,'Assembly.ID',False],                                            # Pointer to '_Assembly.ID'
          'Assembly_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Assembly.Sf_framecode',False],# Pointer to a saveframe of the category assembly.
          'Entity_ID': [None,returnStarInt,'Entity.ID',False],                                                # Pointer to '_Entity.ID'
          'Entity_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Entity.Sf_framecode',False],# Pointer to a saveframe of the category entity.
          'Product_ID': [None,returnStarInt,None,False],                                                      # Not currently modeled. This ID would be a pointer to the categories describing the production and purification of the sample component.
          'Type': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                         # Enter the class of molecule ( proteins DNA buffer salt) to which the sample component belongs.
          'Concentration_val': [None,lambda x = value: returnStarLine(x,length = 31),None,False],             # Value for the concentration of the sample component (units will be entered below).
          'Concentration_val_min': [None,returnStarFloat,None,False],                                         # If entering a range for the concentration of the component provide the minimal value.
          'Concentration_val_max': [None,returnStarFloat,None,False],                                         # If entering a range for the concentration of the sample component provide the maximal value.
          'Concentration_val_units': [None,lambda x = value: returnStarLine(x,length = 31),None,False],       # Units used to express the concentration of the sample component.
          'Concentration_val_err': [None,returnStarFloat,None,False],                                         # Estimate for the standard error associated with the concentration value of the sample component.
          'Vendor': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                       # The name of the vendor for a sample component.
          'Vendor_product_name': [None,lambda x = value: returnStarLine(x,length = 127),None,False],          # The product name assigned by the vendor.
          'Vendor_product_code': [None,lambda x = value: returnStarLine(x,length = 127),None,False],          # The product code assigned by the vendor.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Sample_ID': [None,returnStarInt,'Sample.ID',True],                                                 # Pointer to '_Sample.ID'

                },

        'tagNames': ['ID', 'Mol_common_name', 'Isotopic_labeling', 'Assembly_ID', 'Assembly_label', 'Entity_ID', 'Entity_label', 'Product_ID', 'Type', 'Concentration_val', 'Concentration_val_min', 'Concentration_val_max', 'Concentration_val_units', 'Concentration_val_err', 'Vendor', 'Vendor_product_name', 'Vendor_product_code', 'Entry_ID', 'Sample_ID'],
        'sourcePrimaryKeys': ['ID', 'Entry_ID', 'Sample_ID'],

            },

      'Sample_component_atom_isotope': {

        'tags': {

          'Sample_component_ID': [None,returnStarInt,'Sample_component.ID',True],                             # Pointer to '_Sample_component.ID'
          'Mol_common_name': [None,lambda x = value: returnStarLine(x,length = 127),None,False],              # A common name used for the labaled chemical compound.
          'Assembly_atom_ID': [None,returnStarInt,'Atom.Assembly_atom_ID',False],                             # Pointer to '_Atom.Assembly_atom_ID'
          'Entity_ID': [None,returnStarInt,'Entity.ID',True],                                                 # Pointer to '_Entity.ID'
          'Entity_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Entity.Sf_framecode',False],# Pointer to a saveframe of the category 'entity'
          'Comp_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Chem_comp.ID',True],              # Pointer to '_Chem_comp.ID'
          'Comp_isotope_label_code': [None,lambda x = value: returnStarCode(x,length = 12),None,True],        # A code that uniquely defines the atoms that are isotopically labeled in a chemical component.
          'Comp_index_ID': [None,returnStarInt,'Entity_comp_index.ID',True],                                  # Pointer to '_Entity_comp_index.ID'
          'Seq_ID': [None,returnStarInt,'Entity_poly_seq.Num',True],                                          # Pointer to '_Entity_poly_seq.Num'
          'Atom_ID': [None,lambda x = value: returnStarAtCode(x,length = 12),'Chem_comp_atom.Atom_ID',True],  # Pointer to '_Chem_comp_atom.Atom_ID'
          'Atom_type': [None,lambda x = value: returnStarCode(x,length = 12),None,True],                      # Standard symbol used to define the atom element type.
          'Atom_isotope_number': [None,returnStarInt,None,True],                                              # The mass number for the chemical element (number of protons plus number of neutrons in the nucleus).
          'Label_pct': [None,returnStarFloat,None,True],                                                      # The percentage of the atoms at this site that are labeled with the designated isotope.
          'Auth_entity_assembly_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],       # An alternative identifier for Entity_assembly_ID that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Entity_assembly_ID.
          'Auth_entity_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                # An alternative identifier for Entity_id that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Entity_ID.
          'Auth_seq_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                   # An alternative identifier for Seq_id that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Seq_ID or Comp_index_ID.
          'Auth_comp_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                  # An alternative identifier for Comp_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Auth_atom_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                  # An alternative identifier for Atom_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Sample_ID': [None,returnStarInt,'Sample.ID',True],                                                 # Pointer to '_Sample.ID'

                },

        'tagNames': ['Sample_component_ID', 'Mol_common_name', 'Assembly_atom_ID', 'Entity_ID', 'Entity_label', 'Comp_ID', 'Comp_isotope_label_code', 'Comp_index_ID', 'Seq_ID', 'Atom_ID', 'Atom_type', 'Atom_isotope_number', 'Label_pct', 'Auth_entity_assembly_ID', 'Auth_entity_ID', 'Auth_seq_ID', 'Auth_comp_ID', 'Auth_atom_ID', 'Entry_ID', 'Sample_ID'],
        'sourcePrimaryKeys': ['Sample_component_ID', 'Entity_ID', 'Comp_index_ID', 'Atom_ID', 'Atom_isotope_number', 'Entry_ID', 'Sample_ID'],

            },

      'Sample_citation': {

        'tags': {

          'Citation_ID': [None,returnStarInt,'Citation.ID',True],                                             # Pointer to '_Citation.ID'
          'Citation_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Citation.Sf_framecode',True],# Pointer to a saveframe of the category citation.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Sample_ID': [None,returnStarInt,'Sample.ID',True],                                                 # Pointer to '_Sample.ID'

                },

        'tagNames': ['Citation_ID', 'Citation_label', 'Entry_ID', 'Sample_ID'],
        'sourcePrimaryKeys': ['Citation_ID', 'Entry_ID', 'Sample_ID'],

            }

        },

    'tableNames': ['Sample_component', 'Sample_component_atom_isotope', 'Sample_citation']

    },

  'sample_conditions': {

    'name': 'Sample_condition_list',

    'tags': {

      'Sf_category': ['sample_conditions',lambda x = value: returnStarCode(x,length = 127),None,True],        # Category assigned to the information in the saveframe.
      'Sf_framecode': [None,lambda x = value: returnStarCode(x,length = 127),None,False],                     # A descriptive label that uniquely identifies this set of sample conditions.
      'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                     # Pointer to '_Entry.ID'
      'ID': [None,returnStarInt,None,True],                                                                   # A value that uniquely identifies the set of sample conditions from other sample
      'Details': [None,returnStarString,None,False],                                                          # General details describing conditions of both the sample and the environment during measurements.

            },

    'tagNames': ['Sf_category', 'Sf_framecode', 'Entry_ID', 'ID', 'Details'],
    'sourcePrimaryKeys': ['Entry_ID', 'ID'],

    'tables': {

      'Sample_condition_variable': {

        'tags': {

          'Type': [None,lambda x = value: returnStarLine(x,length = 31),None,True],                           # The variable used to define a specific sample condition (i.e.$ temperature)used when conducting experiments used to derive the experimental data included in the file.
          'Val': [None,lambda x = value: returnStarLine(x,length = 31),None,False],                           # Value for the variable (temperature pressure pH).  Units will be listed below.
          'Val_err': [None,lambda x = value: returnStarLine(x,length = 31),None,False],                       # Estimate the standard error on the value for the sample condition.
          'Val_units': [None,lambda x = value: returnStarLine(x,length = 31),None,False],                     # Units for the value of the sample condition (temperature pressure pH).
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Sample_condition_list_ID': [None,returnStarInt,'Sample_condition_list.ID',True],                   # Pointer to '_Sample_condition_list.ID'

                },

        'tagNames': ['Type', 'Val', 'Val_err', 'Val_units', 'Entry_ID', 'Sample_condition_list_ID'],
        'sourcePrimaryKeys': ['Type'],

            },

      'Sample_condition_citation': {

        'tags': {

          'Citation_ID': [None,returnStarInt,'Citation.ID',True],                                             # Pointer to '_Citation.ID'
          'Citation_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Citation.Sf_framecode',True],# Pointer to a saveframe of the category citation.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Sample_condition_list_ID': [None,returnStarInt,'Sample_condition_list.ID',True],                   # Pointer to '_Sample_condition_list.ID'

                },

        'tagNames': ['Citation_ID', 'Citation_label', 'Entry_ID', 'Sample_condition_list_ID'],
        'sourcePrimaryKeys': ['Entry_ID', 'Sample_condition_list_ID'],

            }

        },

    'tableNames': ['Sample_condition_variable', 'Sample_condition_citation']

    },

  'molecule_purity': {

    'name': 'Entity_purity_list',
    'saveFrameCode': 'sample_mol_purity',

    'tags': {

      'Sf_category': ['molecule_purity',lambda x = value: returnStarCode(x,length = 127),None,True],          # Category assigned to the information in the saveframe.
      'Sf_framecode': [None,lambda x = value: returnStarCode(x,length = 127),None,False],                     # A descriptive label for this set of molecule purity values.
      'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                     # Pointer to '_Entry.ID'
      'ID': [None,returnStarInt,None,True],                                                                   # An integer value that uniquely identifies this saveframe from other saveframes in the entry of the same category.
      'Details': [None,returnStarString,None,False],                                                          # Text providing additional information describing the purity of the molecules reported.

            },

    'tagNames': ['Sf_category', 'Sf_framecode', 'Entry_ID', 'ID', 'Details'],
    'sourcePrimaryKeys': ['Entry_ID', 'ID'],

    'tables': {

      'Entity_purity': {

        'tags': {

          'ID': [None,returnStarInt,None,True],                                                               # An integer value that uniquely identifies the purity value in the table of reported purity values in the entry.
          'Sample_ID': [None,returnStarInt,'Sample.ID',False],                                                # Pointer to '_Sample.ID'
          'Sample_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Sample.Sf_framecode',False],# Pointer to a saveframe of the category sample.
          'Entity_ID': [None,returnStarInt,'Entity.ID',True],                                                 # Pointer to '_Entity.ID'
          'Entity_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Entity.Sf_framecode',True],# Pointer to a saveframe of the category entity.
          'Val': [None,returnStarFloat,None,True],                                                            # Purity value
          'Val_units': [None,lambda x = value: returnStarLine(x,length = 31),None,True],                      # Units for the reported purity value.
          'Measurement_method': [None,lambda x = value: returnStarLine(x,length = 127),None,True],            # Technique used to determine the purity of the molecule.
          'Details': [None,returnStarString,None,False],                                                      # Text describing the reported purity values and measurements.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Entity_purity_list_ID': [None,returnStarInt,'Entity_purity_list.ID',True],                         # Pointer to '_Entity_purity_list.ID'

                },

        'tagNames': ['ID', 'Sample_ID', 'Sample_label', 'Entity_ID', 'Entity_label', 'Val', 'Val_units', 'Measurement_method', 'Details', 'Entry_ID', 'Entity_purity_list_ID'],
        'sourcePrimaryKeys': ['ID', 'Entry_ID', 'Entity_purity_list_ID'],

            },

      'Entity_purity_citation': {

        'tags': {

          'Citation_ID': [None,returnStarInt,'Citation.ID',True],                                             # Pointer to '_Citation.ID'
          'Citation_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Citation.Sf_framecode',True],# Pointer to a saveframe of the category citation.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Entity_purity_list_ID': [None,returnStarInt,'Entity_purity_list.ID',True],                         # Pointer to '_Entity_purity_list.ID'

                },

        'tagNames': ['Citation_ID', 'Citation_label', 'Entry_ID', 'Entity_purity_list_ID'],
        'sourcePrimaryKeys': ['Citation_ID', 'Entry_ID', 'Entity_purity_list_ID'],

            }

        },

    'tableNames': ['Entity_purity', 'Entity_purity_citation']

    },

  'software': {

    'name': 'Software',

    'tags': {

      'Sf_category': ['software',lambda x = value: returnStarCode(x,length = 127),None,True],                 # Category assigned to the information in the saveframe.
      'Sf_framecode': [None,lambda x = value: returnStarCode(x,length = 127),None,False],                     # A label that uniquely identifies the software from other software listed in the entry.
      'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                     # Pointer to '_Entry.ID'
      'ID': [None,returnStarInt,None,True],                                                                   # A value that uniquely identifies the software from other software listed in the entry.
      'Name': [None,lambda x = value: returnStarLine(x,length = 127),None,True],                              # The name of the software defined by the author or provider of the software.
      'Version': [None,lambda x = value: returnStarLine(x,length = 31),None,False],                           # The code assigned to the version of the software.
      'Details': [None,returnStarString,None,False],                                                          # Text description of the software.

            },

    'tagNames': ['Sf_category', 'Sf_framecode', 'Entry_ID', 'ID', 'Name', 'Version', 'Details'],
    'sourcePrimaryKeys': ['Entry_ID', 'ID'],

    'tables': {

      'Vendor': {

        'tags': {

          'Name': [None,lambda x = value: returnStarLine(x,length = 127),None,True],                          # Commercial or academic supplier of the software product.
          'Address': [None,returnStarString,None,False],                                                      # Location for the person or company who supplies the software.
          'Electronic_address': [None,returnStarString,None,False],                                           # An internet address for the vendor of the software.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Software_ID': [None,returnStarInt,'Software.ID',True],                                             # Pointer to '_Software.ID'

                },

        'tagNames': ['Name', 'Address', 'Electronic_address', 'Entry_ID', 'Software_ID'],
        'sourcePrimaryKeys': ['Name', 'Entry_ID', 'Software_ID'],

            },

      'Task': {

        'tags': {

          'Task': [None,lambda x = value: returnStarLine(x,length = 127),None,True],                          # A word or brief phrase that describes the job that a software application was used to carry out.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Software_ID': [None,returnStarInt,'Software.ID',True],                                             # Pointer to '_Software.ID'

                },

        'tagNames': ['Task', 'Entry_ID', 'Software_ID'],
        'sourcePrimaryKeys': ['Task', 'Entry_ID', 'Software_ID'],

            },

      'Software_citation': {

        'tags': {

          'Citation_ID': [None,returnStarInt,'Citation.ID',True],                                             # Pointer to '_Citation.ID'
          'Citation_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Citation.Sf_framecode',True],# Pointer to a saveframe of the category citation.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Software_ID': [None,returnStarInt,'Software.ID',True],                                             # Pointer to '_Software.ID'

                },

        'tagNames': ['Citation_ID', 'Citation_label', 'Entry_ID', 'Software_ID'],
        'sourcePrimaryKeys': ['Citation_ID', 'Entry_ID', 'Software_ID'],

            }

        },

    'tableNames': ['Vendor', 'Task', 'Software_citation']

    },

  'method': {

    'name': 'Method',

    'tags': {

      'Sf_category': ['method',lambda x = value: returnStarCode(x,length = 127),None,True],                   # Category assigned to the information in the saveframe.
      'Sf_framecode': [None,lambda x = value: returnStarCode(x,length = 127),None,False],                     # Descriptive label used to uniquely identify this method.
      'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                     # Pointer to '_Entry.ID'
      'ID': [None,returnStarInt,None,True],                                                                   # A value that uniquely identifies the method describe from other methods given in the entry.
      'Derivation_type': [None,lambda x = value: returnStarLine(x,length = 127),None,True],                   # The type of derivation used in the reported method.
      'Details': [None,returnStarString,None,False],                                                          # Text description providing additional information about the reported method.
      'Computer_ID': [None,returnStarInt,'Computer.ID',False],                                                # Pointer to '_Computer.ID'
      'Computer_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Computer.Sf_framecode',False],# Pointer to a saveframe of the category computer.

            },

    'tagNames': ['Sf_category', 'Sf_framecode', 'Entry_ID', 'ID', 'Derivation_type', 'Details', 'Computer_ID', 'Computer_label'],
    'sourcePrimaryKeys': ['Entry_ID', 'ID'],

    'tables': {

      'Method_file': {

        'tags': {

          'Name': [None,lambda x = value: returnStarLine(x,length = 127),None,True],                          # Name for the file containing the source code or protocol for the reported method.
          'Text_format': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                  # The format used in the ASCII texted document that is the method and is the value to the tag _Method.Text.
          'Text': [None,returnStarString,None,False],                                                         # The method provided as an ASCII text document that is included in the NMR-STAR file as a value to this tag.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Method_ID': [None,returnStarInt,'Method.ID',True],                                                 # Pointer to '_Method.ID'

                },

        'tagNames': ['Name', 'Text_format', 'Text', 'Entry_ID', 'Method_ID'],
        'sourcePrimaryKeys': ['Name', 'Entry_ID', 'Method_ID'],

            },

      'Method_param': {

        'tags': {

          'File_name': [None,lambda x = value: returnStarLine(x,length = 127),None,True],                     # Name of the file that contains parameters required to execute the method.
          'Text_format': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                  # Format in which the method information is encoded.
          'Text': [None,returnStarString,None,False],                                                         # Text for the reported method.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Method_ID': [None,returnStarInt,'Method.ID',True],                                                 # Pointer to '_Method.ID'

                },

        'tagNames': ['File_name', 'Text_format', 'Text', 'Entry_ID', 'Method_ID'],
        'sourcePrimaryKeys': ['File_name', 'Entry_ID', 'Method_ID'],

            },

      'Method_citation': {

        'tags': {

          'Citation_ID': [None,returnStarInt,'Citation.ID',True],                                             # Pointer to '_Citation.ID'
          'Citation_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Citation.Sf_framecode',True],# Pointer to a saveframe of the category citation.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Method_ID': [None,returnStarInt,'Method.ID',True],                                                 # Pointer to '_Method.ID'

                },

        'tagNames': ['Citation_ID', 'Citation_label', 'Entry_ID', 'Method_ID'],
        'sourcePrimaryKeys': ['Citation_ID', 'Entry_ID', 'Method_ID'],

            }

        },

    'tableNames': ['Method_file', 'Method_param', 'Method_citation']

    },

  'Mass_spectrometer': {

    'name': 'Mass_spectrometer',

    'tags': {

      'Sf_category': ['Mass_spectrometer',lambda x = value: returnStarCode(x,length = 127),None,True],        # Category assigned to the information in the saveframe.
      'Sf_framecode': [None,lambda x = value: returnStarCode(x,length = 127),None,False],                     # A label that uniquely identifies the Mass spectrometer from other spectrometers listed in the entry.
      'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                     # Pointer to '_Entry.ID'
      'ID': [None,returnStarInt,None,True],                                                                   # A value that uniquely identifies the Mass spectrometer from other spectrometers listed in the entry.
      'Manufacturer': [None,lambda x = value: returnStarLine(x,length = 127),None,True],                      # Name of the company or other entity that built the Mass spectrometer.
      'Model': [None,lambda x = value: returnStarLine(x,length = 127),None,True],                             # The name or acronym used to describe the model of the spectrometer.
      'Type': [None,lambda x = value: returnStarLine(x,length = 127),None,True],                              # The type of mass spectrometer used.
      'Fragmentation_method': [None,lambda x = value: returnStarLine(x,length = 127),None,True],              # The kind of fragmentation method used by the defined mass spectrometer.
      'Serial_number': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                    # Unique code assigned to a specific spectrometer by the manufacturer.
      'Mass_ref_introduction_method': [None,lambda x = value: returnStarLine(x,length = 127),None,False],     # Method used to introduce a mass reference compound into the mass spectrometer.
      'Details': [None,returnStarString,None,False],                                                          # A text description of the Mass spectrometer.

            },

    'tagNames': ['Sf_category', 'Sf_framecode', 'Entry_ID', 'ID', 'Manufacturer', 'Model', 'Type', 'Fragmentation_method', 'Serial_number', 'Mass_ref_introduction_method', 'Details'],
    'sourcePrimaryKeys': [],

    'tables': {

      'Mass_spectrometer_citation': {

        'tags': {

          'Citation_ID': [None,returnStarInt,'Citation.ID',True],                                             # Pointer to '_Citation.ID'
          'Citation_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Citation.Sf_framecode',True],# Pointer to a saveframe of the category citation.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Mass_spectrometer_ID': [None,returnStarInt,'Mass_spectrometer.ID',True],                           # Pointer to '_Mass_spectrometer.ID'

                },

        'tagNames': ['Citation_ID', 'Citation_label', 'Entry_ID', 'Mass_spectrometer_ID'],
        'sourcePrimaryKeys': ['Citation_ID'],

            }

        },

    'tableNames': ['Mass_spectrometer_citation']

    },

  'Mass_spectrometer_list': {

    'name': 'Mass_spectrometer_list',
    'saveFrameCode': 'Mass_spectrometer_list',

    'tags': {

      'Sf_category': ['Mass_spectrometer_list',lambda x = value: returnStarCode(x,length = 127),None,True],   # Category assigned to the information in the saveframe.
      'Sf_framecode': [None,lambda x = value: returnStarCode(x,length = 127),None,False],                     # A label that uniquely identifies the Mass spectrometer from other spectrometers listed in the entry.
      'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                     # Pointer to '_Entry.ID'
      'ID': [None,returnStarInt,None,True],                                                                   # A value that uniquely identifies the Mass spectrometer from other spectrometers listed in the entry.

            },

    'tagNames': ['Sf_category', 'Sf_framecode', 'Entry_ID', 'ID'],
    'sourcePrimaryKeys': [],

    'tables': {

      'Mass_spectrometer_view': {

        'tags': {

          'ID': [None,returnStarInt,None,True],                                                               # Unique local identifier assigned to an NMR spectrometer.
          'Name': [None,lambda x = value: returnStarLine(x,length = 31),None,False],                          # Common name used for an NMR spectrometer.
          'Manufacturer': [None,lambda x = value: returnStarLine(x,length = 127),None,True],                  # Name of the company or other entity that built the Mass spectrometer.
          'Model': [None,lambda x = value: returnStarLine(x,length = 127),None,True],                         # The name or acronym used to describe the model of the spectrometer.
          'Type': [None,lambda x = value: returnStarLine(x,length = 127),None,True],                          # Approximate strength of the magnetic field for the spectrometer as defined by the proton frequency of the instrument expressed in MHz.
          'Fragmentation_method': [None,lambda x = value: returnStarLine(x,length = 127),None,True],          # The kind of fragmentation method used by the defined mass spectrometer.
          'Serial_number': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                # Unique code assigned to a specific spectrometer by the manufacturer.
          'Mass_ref_introduction_method': [None,lambda x = value: returnStarLine(x,length = 127),None,False], # Method used to introduce a mass reference compound into the mass spectrometer.
          'Details': [None,returnStarString,None,False],                                                      # A text description of the Mass spectrometer.
          'Citation_ID': [None,returnStarInt,'Citation.ID',False],                                            # Pointer to '_Citation.ID'
          'Citation_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Citation.Sf_framecode',False],# Pointer to a saveframe of the category citation.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',False],                # Pointer to '_Entry.ID'
          'Mass_spectrometer_list_ID': [None,returnStarInt,'Mass_spectrometer_list.ID',False],                # Pointer to '_Mass_spectrometer_list.ID'

                },

        'tagNames': ['ID', 'Name', 'Manufacturer', 'Model', 'Type', 'Fragmentation_method', 'Serial_number', 'Mass_ref_introduction_method', 'Details', 'Citation_ID', 'Citation_label', 'Entry_ID', 'Mass_spectrometer_list_ID'],
        'sourcePrimaryKeys': ['ID'],

            }

        },

    'tableNames': ['Mass_spectrometer_view']

    },

  'Mass_spec_ref_compd': {

    'name': 'Mass_spec_ref_compd_set',

    'tags': {

      'Sf_category': ['Mass_spec_ref_compd',lambda x = value: returnStarCode(x,length = 127),None,False],     # Category assigned to the information in the saveframe.
      'Sf_framecode': [None,lambda x = value: returnStarCode(x,length = 127),None,False],                     # A label that uniquely identifies the mass reference compound.
      'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                     # Pointer to '_Entry.ID'
      'ID': [None,returnStarInt,None,True],                                                                   # A value that uniquely identifies the mass reference compound from other mass reference compounds listed in the entry.
      'Details': [None,returnStarString,None,False],                                                          # A text description of the mass reference compound.

            },

    'tagNames': ['Sf_category', 'Sf_framecode', 'Entry_ID', 'ID', 'Details'],
    'sourcePrimaryKeys': ['Entry_ID', 'ID'],

    'tables': {

      'Mass_spec_ref_compd': {

        'tags': {

          'ID': [None,returnStarInt,None,True],                                                               # Unique local identifier assigned to the mass reference compound.
          'Name': [None,lambda x = value: returnStarLine(x,length = 127),None,True],                          # Name for the mass reference compound.
          'Mono_isotopic_mass': [None,returnStarFloat,None,False],                                            # Mass of the compound calculated using the mass of the most abundant isotope for each atom in the compound.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',False],                # Pointer to '_Entry.ID'
          'Mass_spec_ref_compd_set_ID': [None,returnStarInt,'Mass_spec_ref_compd_set.ID',False],              # Pointer to '_Mass_spec_ref_compd_set.ID'

                },

        'tagNames': ['ID', 'Name', 'Mono_isotopic_mass', 'Entry_ID', 'Mass_spec_ref_compd_set_ID'],
        'sourcePrimaryKeys': ['ID', 'Entry_ID', 'Mass_spec_ref_compd_set_ID'],

            }

        },

    'tableNames': ['Mass_spec_ref_compd']

    },

  'chromatographic_system': {

    'name': 'Chromatographic_system',

    'tags': {

      'Sf_category': ['chromatographic_system',lambda x = value: returnStarCode(x,length = 127),None,True],   # Category assigned to the information in the saveframe.
      'Sf_framecode': [None,lambda x = value: returnStarCode(x,length = 127),None,False],                     # A label that uniquely identifies the Mass spectrometer from other spectrometers listed in the entry.
      'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                     # Pointer to '_Entry.ID'
      'ID': [None,returnStarInt,None,True],                                                                   # A value that uniquely identifies the Mass spectrometer from other spectrometers listed in the entry.
      'Type': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                             # The type of chromatographic system attached to the mass spectrometer used to separate a chemical mixture.
      'Pump_manufacturer': [None,lambda x = value: returnStarLine(x,length = 127),None,True],                 # Name of the company or other entity that built the Mass spectrometer.
      'Pump_model': [None,lambda x = value: returnStarLine(x,length = 127),None,True],                        # The name or acronym used to describe the model of the spectrometer.
      'Pump_serial_number': [None,lambda x = value: returnStarLine(x,length = 127),None,False],               # Unique code assigned to a specific spectrometer by the manufacturer.
      'Autosampler_manufacturer': [None,lambda x = value: returnStarLine(x,length = 127),None,False],         # Name of the manufacturer of the autosampler.
      'Autosampler_model': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                # Model of the listed autosampler.
      'Autosampler_serial_number': [None,lambda x = value: returnStarLine(x,length = 127),None,False],        # Serial number of the listed autosampler.
      'Col_compartment_manufacturer': [None,lambda x = value: returnStarLine(x,length = 127),None,False],     # Name of the manufacturer of the column compartment.
      'Col_compartment_model': [None,lambda x = value: returnStarLine(x,length = 127),None,False],            # Model of the listed column compartment.
      'Col_compartment_serial_number': [None,lambda x = value: returnStarLine(x,length = 127),None,False],    # Serial number of the listed column compartment.
      'Details': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                          # Text describing the chromatographic system.

            },

    'tagNames': ['Sf_category', 'Sf_framecode', 'Entry_ID', 'ID', 'Type', 'Pump_manufacturer', 'Pump_model', 'Pump_serial_number', 'Autosampler_manufacturer', 'Autosampler_model', 'Autosampler_serial_number', 'Col_compartment_manufacturer', 'Col_compartment_model', 'Col_compartment_serial_number', 'Details'],
    'sourcePrimaryKeys': ['Entry_ID', 'ID'],

    },

  'chromatographic_column': {

    'name': 'Chromatographic_column',

    'tags': {

      'Sf_category': ['chromatographic_column',lambda x = value: returnStarCode(x,length = 127),None,True],   # Category assigned to the information in the saveframe.
      'Sf_framecode': [None,lambda x = value: returnStarCode(x,length = 127),None,False],                     # A label that uniquely identifies the Mass spectrometer from other spectrometers listed in the entry.
      'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                     # Pointer to '_Entry.ID'
      'ID': [None,returnStarInt,None,True],                                                                   # A value that uniquely identifies the Mass spectrometer from other spectrometers listed in the entry.
      'Vendor': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                           # Vendor from whom the chromatographic column was purchased.
      'Type': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                             # The type of chromatographic column listed.
      'Packing_material': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                 # The kind of packing material used in the chromatographic column.
      'Packing_material_pore_size': [None,returnStarFloat,None,False],                                        # The pore size of the packing material used in the chromatographic column.
      'Width': [None,returnStarFloat,None,False],                                                             # The width of the chromatographic column listed.
      'Length': [None,returnStarFloat,None,False],                                                            # The length of the chromatographic column listed.

            },

    'tagNames': ['Sf_category', 'Sf_framecode', 'Entry_ID', 'ID', 'Vendor', 'Type', 'Packing_material', 'Packing_material_pore_size', 'Width', 'Length'],
    'sourcePrimaryKeys': ['Entry_ID', 'ID'],

    },

  'NMR_spectrometer': {

    'name': 'NMR_spectrometer',

    'tags': {

      'Sf_category': ['NMR_spectrometer',lambda x = value: returnStarCode(x,length = 127),None,True],         # Category assigned to the information in the saveframe.
      'Sf_framecode': [None,lambda x = value: returnStarCode(x,length = 127),None,False],                     # A label that uniquely identifies the NMR spectrometer from other spectrometers listed in the entry.
      'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                     # Pointer to '_Entry.ID'
      'ID': [None,returnStarInt,None,True],                                                                   # A value that uniquely identifies the NMR spectrometer from other spectrometers listed in the entry.
      'Details': [None,returnStarString,None,False],                                                          # A text description of the NMR spectrometer.
      'Manufacturer': [None,lambda x = value: returnStarLine(x,length = 127),None,True],                      # Name of the company or other entity that built the NMR spectrometer.
      'Model': [None,lambda x = value: returnStarLine(x,length = 127),None,True],                             # The name or acronym used to describe the model of the spectrometer.
      'Serial_number': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                    # Unique code assigned to a specific spectrometer by the manufacturer.
      'Field_strength': [None,lambda x = value: returnStarLine(x,length = 127),None,True],                    # Approximate strength of the magnetic field for the spectrometer as defined by the proton frequency of the instrument expressed in MHz.

            },

    'tagNames': ['Sf_category', 'Sf_framecode', 'Entry_ID', 'ID', 'Details', 'Manufacturer', 'Model', 'Serial_number', 'Field_strength'],
    'sourcePrimaryKeys': ['Entry_ID', 'ID'],

    'tables': {

      'NMR_spectrometer_citation': {

        'tags': {

          'Citation_ID': [None,returnStarInt,'Citation.ID',True],                                             # Pointer to '_Citation.ID'
          'Citation_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Citation.Sf_framecode',True],# Pointer to a saveframe of the category citation.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'NMR_spectrometer_ID': [None,returnStarInt,'NMR_spectrometer.ID',True],                             # Pointer to '_NMR_spectrometer.ID'

                },

        'tagNames': ['Citation_ID', 'Citation_label', 'Entry_ID', 'NMR_spectrometer_ID'],
        'sourcePrimaryKeys': ['Citation_ID', 'Entry_ID', 'NMR_spectrometer_ID'],

            }

        },

    'tableNames': ['NMR_spectrometer_citation']

    },

  'NMR_spectrometer_list': {

    'name': 'NMR_spectrometer_list',
    'saveFrameCode': 'NMR_spectrometer_list',

    'tags': {

      'Sf_category': ['NMR_spectrometer_list',lambda x = value: returnStarCode(x,length = 127),None,True],    # Category assigned to the information in the saveframe.
      'Sf_framecode': [None,lambda x = value: returnStarCode(x,length = 127),None,False],                     # A label that uniquely identifies the NMR spectrometer from other spectrometers listed in the entry.
      'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                     # Pointer to '_Entry.ID'
      'ID': [None,returnStarInt,None,True],                                                                   # A value that uniquely identifies the NMR spectrometer from other spectrometers listed in the entry.

            },

    'tagNames': ['Sf_category', 'Sf_framecode', 'Entry_ID', 'ID'],
    'sourcePrimaryKeys': ['Entry_ID', 'ID'],

    'tables': {

      'NMR_spectrometer_view': {

        'tags': {

          'ID': [None,returnStarInt,None,True],                                                               # An integer value that uniquely identifies one NMR spectrometer from the others in the table within an entry.
          'Name': [None,lambda x = value: returnStarLine(x,length = 127),None,True],                          # A unique name for the NMR spectrometer needs to be entered to make it possible to reference the spectromer in later sections of the deposition.
          'Manufacturer': [None,lambda x = value: returnStarLine(x,length = 127),None,True],                  # Name of the company or other entity that built the NMR spectrometer.
          'Model': [None,lambda x = value: returnStarLine(x,length = 127),None,True],                         # The name or acronym used to describe the model of the spectrometer.
          'Serial_number': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                # Unique code assigned to a specific spectrometer by the manufacturer.
          'Field_strength': [None,lambda x = value: returnStarLine(x,length = 127),None,True],                # Approximate strength of the magnetic field for the spectrometer as defined by the proton frequency of the instrument expressed in MHz.
          'Details': [None,returnStarString,None,False],                                                      # A text description of the NMR spectrometer.
          'Citation_ID': [None,returnStarInt,'Citation.ID',False],                                            # Pointer to '_Citation.ID'
          'Citation_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Citation.Sf_framecode',False],# Pointer to a saveframe of the category citation.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'NMR_spectrometer_list_ID': [None,returnStarInt,'NMR_spectrometer_list.ID',True],                   # Pointer to '_NMR_spectrometer_list.ID'

                },

        'tagNames': ['ID', 'Name', 'Manufacturer', 'Model', 'Serial_number', 'Field_strength', 'Details', 'Citation_ID', 'Citation_label', 'Entry_ID', 'NMR_spectrometer_list_ID'],
        'sourcePrimaryKeys': ['ID', 'Name', 'Entry_ID', 'NMR_spectrometer_list_ID'],

            }

        },

    'tableNames': ['NMR_spectrometer_view']

    },

  'NMR_spectrometer_probe': {

    'name': 'NMR_spectrometer_probe',

    'tags': {

      'Sf_category': ['NMR_spectrometer_probe',lambda x = value: returnStarCode(x,length = 127),None,True],   # Category assigned to the information in the saveframe.
      'Sf_framecode': [None,lambda x = value: returnStarCode(x,length = 127),None,False],                     # A label that uniquely identifies the probe from other probes listed in the entry.
      'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                     # Pointer to '_Entry.ID'
      'ID': [None,returnStarInt,None,True],                                                                   # A value that uniquely identifies the NMR probe from other probes listed in the entry.
      'Details': [None,returnStarString,None,False],                                                          # Text information describing the NMR spectrometer probe.
      'Manufacturer': [None,lambda x = value: returnStarLine(x,length = 127),None,True],                      # Name of the company or other entity that built the NMR probe.
      'Model': [None,lambda x = value: returnStarLine(x,length = 127),None,True],                             # The name or acronym used to describe the model of the probe.
      'Serial_number': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                    # Unique code assigned to a specific probe by the manufacturer.
      'Diameter': [None,returnStarFloat,None,False],                                                          # The diameter of the probe bore.
      'Rotor_length': [None,returnStarFloat,None,False],                                                      # Length of the rotor used in the probe.
      'Rotor_composition': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                # Chemical composition of the rotor used in the probe.
      'Internal_volume': [None,returnStarFloat,None,False],                                                   # The internal volume of the probe.
      'Spacer_present': [None,lambda x = value: returnStarYesNo(x,length = 3),None,False],                    # A code indicating the presence of a spacer in the probe.

            },

    'tagNames': ['Sf_category', 'Sf_framecode', 'Entry_ID', 'ID', 'Details', 'Manufacturer', 'Model', 'Serial_number', 'Diameter', 'Rotor_length', 'Rotor_composition', 'Internal_volume', 'Spacer_present'],
    'sourcePrimaryKeys': ['Entry_ID', 'ID'],

    'tables': {

      'NMR_probe': {

        'tags': {

          'Type': [None,lambda x = value: returnStarLine(x,length = 127),None,True],                          # The type of probe.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'NMR_spectrometer_probe_ID': [None,returnStarInt,'NMR_spectrometer_probe.ID',True],                 # Pointer to '_NMR_spectrometer_probe.ID'

                },

        'tagNames': ['Type', 'Entry_ID', 'NMR_spectrometer_probe_ID'],
        'sourcePrimaryKeys': ['Type', 'Entry_ID', 'NMR_spectrometer_probe_ID'],

            },

      'NMR_spectrometer_probe_citation': {

        'tags': {

          'Citation_ID': [None,returnStarInt,'Citation.ID',True],                                             # Pointer to '_Citation.ID'
          'Citation_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Citation.Sf_framecode',True],# Pointer to a saveframe of the category citation.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'NMR_spectrometer_probe_ID': [None,returnStarInt,'NMR_spectrometer_probe.ID',True],                 # Pointer to '_NMR_spectrometer_probe.ID'

                },

        'tagNames': ['Citation_ID', 'Citation_label', 'Entry_ID', 'NMR_spectrometer_probe_ID'],
        'sourcePrimaryKeys': ['Citation_ID', 'Entry_ID', 'NMR_spectrometer_probe_ID'],

            }

        },

    'tableNames': ['NMR_probe', 'NMR_spectrometer_probe_citation']

    },

  'experiment_list': {

    'name': 'Experiment_list',
    'saveFrameCode': 'experiment_list',

    'tags': {

      'Sf_category': ['experiment_list',lambda x = value: returnStarCode(x,length = 127),None,True],          # Category assigned to the information in the saveframe.
      'Sf_framecode': [None,lambda x = value: returnStarCode(x,length = 127),None,False],                     # Descriptive label used to uniquely identify the NMR experiment list within the entry.
      'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                     # Pointer to '_Entry.ID'
      'ID': [None,returnStarInt,None,True],                                                                   # Unique identifier for the list of NMR experiments.
      'Details': [None,returnStarString,None,False],                                                          # Text providing further information describing the NMR experiment(s) listed.

            },

    'tagNames': ['Sf_category', 'Sf_framecode', 'Entry_ID', 'ID', 'Details'],
    'sourcePrimaryKeys': ['Entry_ID', 'ID'],

    'tables': {

      'Experiment': {

        'tags': {

          'ID': [None,returnStarInt,None,True],                                                               # Unique identifier for each experiment listed.
          'Name': [None,lambda x = value: returnStarLine(x,length = 127),None,True],                          # Names for NMR experiments commonly found in the literature.
          'Raw_data_flag': [None,lambda x = value: returnStarYesNo(x,length = 3),None,False],                 # The value for this tag is a flag to indicate if time-domain (raw) NMR data have been deposited for this experiment.
          'NMR_spec_expt_ID': [None,returnStarInt,'NMR_spec_expt.ID',False],                                  # Pointer to '_NMR_spec_expt.ID'
          'NMR_spec_expt_label': [None,lambda x = value: returnStarLabel(x,length = 127),'NMR_spec_expt.Sf_framecode',False],# Pointer to a saveframe of category 'NMR_spectrometer_expt'.
          'Sample_ID': [None,returnStarInt,'Sample.ID',False],                                                # Pointer to '_Sample.ID'
          'Sample_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Sample.Sf_framecode',False],# Pointer to a saveframe of category 'sample''.
          'Sample_state': [None,lambda x = value: returnStarLine(x,length = 31),None,False],                  # Physical state of the sample (anisotropic or isotropic for solution studies and solid for solid-state studies).
          'Sample_volume': [None,returnStarFloat,None,False],                                                 # The volume of the sample used.
          'Sample_volume_units': [None,lambda x = value: returnStarLine(x,length = 31),None,False],           # The units of the measure for the volume of the sample.
          'Sample_condition_list_ID': [None,returnStarInt,'Sample_condition_list.ID',False],                  # Pointer to '_Sample_condition_list.ID'
          'Sample_condition_list_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Sample_condition_list.Sf_framecode',False],# Pointer to a saveframe of category 'sample_conditions'.
          'Sample_spinning_rate': [None,returnStarFloat,None,False],                                          # The rate at which the sample was spun while in the NMR spectrometer during the NMR experiment.
          'Sample_angle': [None,returnStarFloat,None,False],                                                  # The angle at which the sample was positioned in the NMR spectrometer during the NMR experiment.
          'NMR_tube_type': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                # The kind of NMR sample tube used to hold the sample during the NMR experiment.
          'NMR_spectrometer_ID': [None,returnStarInt,'NMR_spectrometer.ID',False],                            # Pointer to '_NMR_spectrometer.ID'
          'NMR_spectrometer_label': [None,lambda x = value: returnStarLabel(x,length = 127),'NMR_spectrometer.Sf_framecode',False],# Pointer to a saveframe of category 'NMR_spectrometer'.
          'NMR_spectrometer_probe_ID': [None,returnStarInt,'NMR_spectrometer_probe.ID',False],                # Pointer to '_NMR_spectrometer_probe.ID'
          'NMR_spectrometer_probe_label': [None,lambda x = value: returnStarLabel(x,length = 127),'NMR_spectrometer_probe.Sf_framecode',False],# Pointer to saveframe of category 'NMR_spectrometer_probe'
          'NMR_spectral_processing_ID': [None,returnStarInt,'NMR_spectral_processing.ID',False],              # Pointer to '_NMR_spectral_processing.ID'
          'NMR_spectral_processing_label': [None,lambda x = value: returnStarLabel(x,length = 127),'NMR_spectral_processing.Sf_framecode',False],# Pointer to a saveframe of category 'NMR_spectral_processing'.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Experiment_list_ID': [None,returnStarInt,'Experiment_list.ID',True],                               # Pointer to '_Experiment_list.ID'

                },

        'tagNames': ['ID', 'Name', 'Raw_data_flag', 'NMR_spec_expt_ID', 'NMR_spec_expt_label', 'Sample_ID', 'Sample_label', 'Sample_state', 'Sample_volume', 'Sample_volume_units', 'Sample_condition_list_ID', 'Sample_condition_list_label', 'Sample_spinning_rate', 'Sample_angle', 'NMR_tube_type', 'NMR_spectrometer_ID', 'NMR_spectrometer_label', 'NMR_spectrometer_probe_ID', 'NMR_spectrometer_probe_label', 'NMR_spectral_processing_ID', 'NMR_spectral_processing_label', 'Entry_ID', 'Experiment_list_ID'],
        'sourcePrimaryKeys': ['ID'],

            },

      'Experiment_file': {

        'tags': {

          'Experiment_ID': [None,returnStarInt,'Experiment.ID',True],                                         # Pointer to '_Experiment.ID'
          'Name': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                         # The name of a computer file containing information related to the experiment.
          'Type': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                         # The type of computer file that has information related to the experiment.
          'Directory_path': [None,returnStarString,None,False],                                               # The directory path where the computer file is located.
          'Details': [None,returnStarString,None,False],                                                      # Text providing additional information regarding the computer file.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Experiment_list_ID': [None,returnStarInt,'Experiment_list.ID',True],                               # Pointer to '_Experiment_list.ID'

                },

        'tagNames': ['Experiment_ID', 'Name', 'Type', 'Directory_path', 'Details', 'Entry_ID', 'Experiment_list_ID'],
        'sourcePrimaryKeys': ['Experiment_ID'],

            }

        },

    'tableNames': ['Experiment', 'Experiment_file']

    },

  'NMR_spectrometer_expt': {

    'name': 'NMR_spec_expt',

    'tags': {

      'Sf_category': ['NMR_spectrometer_expt',lambda x = value: returnStarCode(x,length = 127),None,True],    # Category assigned to the information in the saveframe.
      'Sf_framecode': [None,lambda x = value: returnStarCode(x,length = 127),None,False],                     # Descriptive label used to uniquely identify the NMR experiment and its parameters.
      'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                     # Pointer to '_Entry.ID'
      'ID': [None,returnStarInt,None,True],                                                                   # A value that uniquely identifies the NMR experiment from other NMR experiments listed in the entry.
      'Name': [None,lambda x = value: returnStarLine(x,length = 127),None,True],                              # A commonly used name for the NMR experiment found in the literature.
      'Type': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                             # The type of NMR experiment.
      'Sample_volume': [None,returnStarFloat,None,False],                                                     # Volume of the sample during data collection
      'Sample_volume_units': [None,lambda x = value: returnStarCode(x,length = 15),None,False],               # Provide the units appropriate for the sample volume.
      'NMR_tube_type': [None,lambda x = value: returnStarLine(x,length = 31),None,False],                     # Type of NMR tube used to contain the sample during data acquisition.
      'Sample_spinning_rate': [None,returnStarFloat,None,False],                                              # The spinning rate of the sample during data collection (in Hz).
      'Sample_angle': [None,returnStarFloat,None,False],                                                      # The angle of the sample relative to the external magnetic field.
      'NMR_spectrometer_ID': [None,returnStarInt,'NMR_spectrometer.ID',True],                                 # Pointer to '_NMR_spectrometer.ID'
      'NMR_spectrometer_label': [None,lambda x = value: returnStarLabel(x,length = 127),'NMR_spectrometer.Sf_framecode',True],# Pointer to a saveframe of the category NMR_spectrometer.
      'NMR_spectrometer_probe_ID': [None,returnStarInt,'NMR_spectrometer_probe.ID',True],                     # Pointer to '_NMR_spectrometer_probe.ID'
      'NMR_spectrometer_probe_label': [None,lambda x = value: returnStarLabel(x,length = 127),'NMR_spectrometer_probe.Sf_framecode',True],# Pointer to a saveframe of the category NMR_spectrometer_probe.
      'Carrier_freq_switch_time': [None,returnStarFloat,None,False],                                          # The time required to switch between carrier frequencies.
      'Software_ID': [None,returnStarInt,'Software.ID',True],                                                 # Pointer to '_Software.ID'
      'Software_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Software.Sf_framecode',True],# Pointer to a saveframe of the category software.
      'Method_ID': [None,returnStarInt,'Method.ID',False],                                                    # Pointer to '_Method.ID'
      'Method_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Method.Sf_framecode',False],   # Pointer to a saveframe of the category 'method'
      'Pulse_seq_accession_BMRB_code': [None,lambda x = value: returnStarCode(x,length = 12),None,False],     # An accession code assigned by BMRB that uniquely identifies the NMR experiment pulse sequence within the BMRB pulse sequence library.
      'Details': [None,returnStarString,None,False],                                                          # Summarize and provide details on what type of spectrometer was used$ magnetic field$ how the data were recorded$ and the information obtained from the data.

            },

    'tagNames': ['Sf_category', 'Sf_framecode', 'Entry_ID', 'ID', 'Name', 'Type', 'Sample_volume', 'Sample_volume_units', 'NMR_tube_type', 'Sample_spinning_rate', 'Sample_angle', 'NMR_spectrometer_ID', 'NMR_spectrometer_label', 'NMR_spectrometer_probe_ID', 'NMR_spectrometer_probe_label', 'Carrier_freq_switch_time', 'Software_ID', 'Software_label', 'Method_ID', 'Method_label', 'Pulse_seq_accession_BMRB_code', 'Details'],
    'sourcePrimaryKeys': ['Entry_ID', 'ID'],

    'tables': {

      'NMR_expt_systematic_name': {

        'tags': {

          'Name': [None,lambda x = value: returnStarLine(x,length = 255),None,False],                         # Name for the NMR experiment as defined by a systematic naming system.
          'Naming_system': [None,lambda x = value: returnStarLine(x,length = 255),None,False],                # The name of the systematic NMR experiment naming system used to name the NMR experiment.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'NMR_spec_expt_ID': [None,returnStarInt,'NMR_spec_expt.ID',True],                                   # Pointer to '_NMR_spec_expt.ID'

                },

        'tagNames': ['Name', 'Naming_system', 'Entry_ID', 'NMR_spec_expt_ID'],
        'sourcePrimaryKeys': ['Entry_ID', 'NMR_spec_expt_ID'],

            },

      'NMR_experiment_file': {

        'tags': {

          'Name': [None,lambda x = value: returnStarLine(x,length = 127),None,True],                          # The name of the file containing information relevant to the NMR experiment.  Multiple files can be listed.  These files might include the time-domain (raw) data for the NMR experiment$ the pulse sequence for the experiment$ and parameters for acquiring and processing the data.
          'Type': [None,lambda x = value: returnStarLine(x,length = 127),None,True],                          # The type of time-domain file being deposited.
          'Directory_path': [None,lambda x = value: returnStarLine(x,length = 127),None,False],               # The directory path within the BMRB archive that must be followed to locate listed NMR experiment file.
          'Byte_order': [None,lambda x = value: returnStarLine(x,length = 31),None,False],                    # How the bytes (usually 4$ but sometimes 3$ for example on AM spectrometers) are arranged.  Depends on the computer platform employed.
          'Bytes_per_data_point': [None,returnStarInt,None,False],                                            # Number of bytes per data point.  Most Sun$ SGI$ and Linux systems use 4 bytes ( of 8 bits each yielding a total of 32 bits) per point.
          'File_header_size': [None,returnStarInt,None,False],                                                # Size in bytes of the file header associated with the raw unprocessed data.
          'Record_header_size': [None,returnStarInt,None,False],                                              # Size in bytes of the record header within the NMR experiment file.
          'Record_trailer_size': [None,returnStarInt,None,False],                                             # Size in bytes of the record trailer within the NMR experiment file.
          'Compression_algorithm': [None,lambda x = value: returnStarLine(x,length = 127),None,False],        # Algorithm used to compress the NMR experiment file.
          'Details': [None,returnStarString,None,False],                                                      # Additional information regarding the time-domain (raw) data file for this NMR experiment.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'NMR_spec_expt_ID': [None,returnStarInt,'NMR_spec_expt.ID',True],                                   # Pointer to '_NMR_spec_expt.ID'

                },

        'tagNames': ['Name', 'Type', 'Directory_path', 'Byte_order', 'Bytes_per_data_point', 'File_header_size', 'Record_header_size', 'Record_trailer_size', 'Compression_algorithm', 'Details', 'Entry_ID', 'NMR_spec_expt_ID'],
        'sourcePrimaryKeys': ['Name', 'Entry_ID', 'NMR_spec_expt_ID'],

            },

      'Spectral_acq_param': {

        'tags': {

          'ID': [None,returnStarInt,None,True],                                                               # A value that uniquely identifies the NMR spectral acquisition parameter in the list.
          'Acquisition_dimension_ID': [None,returnStarInt,None,True],                                         # A value that uniquely identifies the NMR spectral acquisition dimension in the list.
          'Name': [None,lambda x = value: returnStarLine(x,length = 127),None,True],                          # For a specified acquisition dimension the type of nucleus and its isotope detected in the experiment.
          'Val': [None,lambda x = value: returnStarCode(x,length = 15),None,True],                            # Value for the NMR spectral acquisition parameter.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'NMR_spec_expt_ID': [None,returnStarInt,'NMR_spec_expt.ID',True],                                   # Pointer to '_NMR_spec_expt.ID'

                },

        'tagNames': ['ID', 'Acquisition_dimension_ID', 'Name', 'Val', 'Entry_ID', 'NMR_spec_expt_ID'],
        'sourcePrimaryKeys': ['ID', 'Entry_ID', 'NMR_spec_expt_ID'],

            },

      'Recoupling_pulse_sequence': {

        'tags': {

          'Name': [None,lambda x = value: returnStarLine(x,length = 31),None,True],                           # Name for a solid-state recoupling pulse sequence.
          'Type': [None,lambda x = value: returnStarLine(x,length = 31),None,True],                           # Type of recoupling pulse sequence (homonuclear or heteronuclear).
          'Nucleus': [None,lambda x = value: returnStarCode(x,length = 15),None,True],                        # Atomic nucleus targeted by the recoupling pulse sequence.
          'Time_period': [None,lambda x = value: returnStarCode(x,length = 15),None,True],                    # Specific time period during the full pulse sequence where the recoupling pulse sequence is applied.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'NMR_spec_expt_ID': [None,returnStarInt,'NMR_spec_expt.ID',True],                                   # Pointer to '_NMR_spec_expt.ID'

                },

        'tagNames': ['Name', 'Type', 'Nucleus', 'Time_period', 'Entry_ID', 'NMR_spec_expt_ID'],
        'sourcePrimaryKeys': ['Name', 'Time_period', 'Entry_ID', 'NMR_spec_expt_ID'],

            },

      'Decoupling_pulse_sequence': {

        'tags': {

          'Name': [None,lambda x = value: returnStarLine(x,length = 31),None,True],                           # Name for a decoupling pulse sequence.
          'Time_period': [None,lambda x = value: returnStarCode(x,length = 15),None,True],                    # Specific time period during the full pulse sequence where the decoupling pulse sequence is applied.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'NMR_spec_expt_ID': [None,returnStarInt,'NMR_spec_expt.ID',True],                                   # Pointer to '_NMR_spec_expt.ID'

                },

        'tagNames': ['Name', 'Time_period', 'Entry_ID', 'NMR_spec_expt_ID'],
        'sourcePrimaryKeys': ['Name', 'Time_period', 'Entry_ID', 'NMR_spec_expt_ID'],

            },

      'NMR_experiment_citation': {

        'tags': {

          'Citation_ID': [None,returnStarInt,'Citation.ID',True],                                             # Pointer to '_Citation.ID'
          'Citation_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Citation.Sf_framecode',True],# Pointer to a saveframe of the category citation.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'NMR_spec_expt_ID': [None,returnStarInt,'NMR_spec_expt.ID',True],                                   # Pointer to '_NMR_spec_expt.ID'

                },

        'tagNames': ['Citation_ID', 'Citation_label', 'Entry_ID', 'NMR_spec_expt_ID'],
        'sourcePrimaryKeys': ['Citation_ID', 'Entry_ID', 'NMR_spec_expt_ID'],

            }

        },

    'tableNames': ['NMR_expt_systematic_name', 'NMR_experiment_file', 'Spectral_acq_param', 'Recoupling_pulse_sequence', 'Decoupling_pulse_sequence', 'NMR_experiment_citation']

    },

  'NMR_spectral_processing': {

    'name': 'NMR_spectral_processing',

    'tags': {

      'Sf_category': ['NMR_spectral_processing',lambda x = value: returnStarCode(x,length = 127),None,True],  # Category assigned to the information in the saveframe.
      'Sf_framecode': [None,lambda x = value: returnStarCode(x,length = 127),None,False],                     # Descriptive label used to uniquely identify this set of NMR spectral processing parameters.
      'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                     # Pointer to '_Entry.ID'
      'ID': [None,returnStarInt,None,True],                                                                   # A value that uniquely identifies the set of spectral processing from other sets of spectral processing parameters in the entry.

            },

    'tagNames': ['Sf_category', 'Sf_framecode', 'Entry_ID', 'ID'],
    'sourcePrimaryKeys': ['Entry_ID', 'ID'],

    'tables': {

      'NMR_spectral_proc_software': {

        'tags': {

          'Software_ID': [None,returnStarInt,'Software.ID',True],                                             # Pointer to '_Software.ID'
          'Software_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Software.Sf_framecode',True],# Pointer to a saveframe of the category software.
          'Method_ID': [None,returnStarInt,'Method.ID',False],                                                # Pointer to '_Method.ID'
          'Method_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Method.Sf_framecode',False],# Pointer to a saveframe of the category method.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'NMR_spectral_processing_ID': [None,returnStarInt,'NMR_spectral_processing.ID',True],               # Pointer to '_NMR_spectral_processing.ID'

                },

        'tagNames': ['Software_ID', 'Software_label', 'Method_ID', 'Method_label', 'Entry_ID', 'NMR_spectral_processing_ID'],
        'sourcePrimaryKeys': ['Software_ID', 'Entry_ID', 'NMR_spectral_processing_ID'],

            },

      'Spectral_processing_param': {

        'tags': {

          'ID': [None,returnStarInt,None,True],                                                               # A value that uniquely identifies the NMR spectral processing parameter in the list.
          'Processing_dimension_ID': [None,returnStarInt,None,False],                                         # The spectral dimension in which the processing parameter was applied.
          'Name': [None,lambda x = value: returnStarLine(x,length = 127),None,True],                          # Name for a NMR spectral processing parameter.
          'Val': [None,lambda x = value: returnStarCode(x,length = 15),None,True],                            # Value for the NMR spectral processing parameter.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'NMR_spectral_processing_ID': [None,returnStarInt,'NMR_spectral_processing.ID',True],               # Pointer to '_NMR_spectral_processing.ID'

                },

        'tagNames': ['ID', 'Processing_dimension_ID', 'Name', 'Val', 'Entry_ID', 'NMR_spectral_processing_ID'],
        'sourcePrimaryKeys': ['ID', 'Entry_ID', 'NMR_spectral_processing_ID'],

            }

        },

    'tableNames': ['NMR_spectral_proc_software', 'Spectral_processing_param']

    },

  'computer': {

    'name': 'Computer',

    'tags': {

      'Sf_category': ['computer',lambda x = value: returnStarCode(x,length = 127),None,True],                 # Category assigned to the information in the saveframe.
      'Sf_framecode': [None,lambda x = value: returnStarCode(x,length = 127),None,False],                     # A label that uniquely identifies the computer from other computers listed in the entry.
      'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                     # Pointer to '_Entry.ID'
      'ID': [None,returnStarInt,None,True],                                                                   # A value that uniquely identifies the computer from other computers listed in the entry.
      'Details': [None,returnStarString,None,False],                                                          # Text information describing the computer.
      'Manufacturer': [None,lambda x = value: returnStarLine(x,length = 127),None,True],                      # Name of the company or other entity that built the Computer.
      'Model': [None,lambda x = value: returnStarLine(x,length = 127),None,True],                             # The name or acronym used to describe the model of the computer.
      'Operating_system': [None,lambda x = value: returnStarLine(x,length = 127),None,True],                  # The operating system used on the computer.
      'Operating_system_version': [None,lambda x = value: returnStarLine(x,length = 127),None,True],          # Version number or code for the computer operating system used.
      'Hardware_code': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                    # Code assigned to the computer by the manufacturer that uniquely identifies that computer from all others.

            },

    'tagNames': ['Sf_category', 'Sf_framecode', 'Entry_ID', 'ID', 'Details', 'Manufacturer', 'Model', 'Operating_system', 'Operating_system_version', 'Hardware_code'],
    'sourcePrimaryKeys': ['Entry_ID', 'ID'],

    'tables': {

      'Computer_citation': {

        'tags': {

          'Citation_ID': [None,returnStarInt,'Citation.ID',True],                                             # Pointer to '_Citation.ID'
          'Citation_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Citation.Sf_framecode',True],# Pointer to a saveframe of the category citation.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Computer_ID': [None,returnStarInt,'Computer.ID',True],                                             # Pointer to '_Computer.ID'

                },

        'tagNames': ['Citation_ID', 'Citation_label', 'Entry_ID', 'Computer_ID'],
        'sourcePrimaryKeys': ['Citation_ID', 'Entry_ID', 'Computer_ID'],

            }

        },

    'tableNames': ['Computer_citation']

    },

  'chem_shift_reference': {

    'name': 'Chem_shift_reference',

    'tags': {

      'Sf_category': ['chem_shift_reference',lambda x = value: returnStarCode(x,length = 127),None,True],     # Category assigned to the information in the saveframe.
      'Sf_framecode': [None,lambda x = value: returnStarCode(x,length = 127),None,False],                     # A descriptive label that uniquely identifies this list of chemical shift referencing parameters used in reporting assigned chemical shifts and other chemical shift data.
      'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                     # Pointer to '_Entry.ID'
      'ID': [None,returnStarInt,None,True],                                                                   # An integer value that uniquely identifies this saveframe of chemical shift reference values from other saveframes of this category in an entry.
      'Proton_shifts_flag': [None,lambda x = value: returnStarLine(x,length = 31),None,False],                # Please indicate yes or no$ if you are depositing 1H chemical shifts.
      'Carbon_shifts_flag': [None,lambda x = value: returnStarLine(x,length = 31),None,False],                # Please indicate yes or no$ if you are depositing 13C chemical shifts.
      'Nitrogen_shifts_flag': [None,lambda x = value: returnStarLine(x,length = 31),None,False],              # Please indicate yes or no$ if you are depositing 15N chemical shifts.
      'Phosphorus_shifts_flag': [None,lambda x = value: returnStarLine(x,length = 31),None,False],            # Please indicate yes or no$ if you are depositing 31P chemical shifts.
      'Other_shifts_flag': [None,lambda x = value: returnStarLine(x,length = 31),None,False],                 # If you are depositing chemical shifts for a nuclei other than 1H$ 13C$ 15N$ or 31P$ select the 'yes' option otherwise select the 'no' option.
      'Details': [None,returnStarString,None,False],                                                          # Text providing additional information regarding the reported chemical shift referencing values or methods.

            },

    'tagNames': ['Sf_category', 'Sf_framecode', 'Entry_ID', 'ID', 'Proton_shifts_flag', 'Carbon_shifts_flag', 'Nitrogen_shifts_flag', 'Phosphorus_shifts_flag', 'Other_shifts_flag', 'Details'],
    'sourcePrimaryKeys': ['Entry_ID', 'ID'],

    'tables': {

      'Chem_shift_ref': {

        'tags': {

          'Atom_type': [None,lambda x = value: returnStarCode(x,length = 15),None,True],                      # The value for this tag is a standard IUPAC abbreviation for an element (i.e.$ H$ C$ P$ etc).
          'Atom_isotope_number': [None,returnStarInt,None,True],                                              # The mass number for the chemical element defined by the tag '_Atom_type' or any of its related tags.
          'Mol_common_name': [None,lambda x = value: returnStarLine(x,length = 127),None,True],               # Common name or abbreviation used in the literature for the molecule used as a chemical shift reference.
          'Atom_group': [None,lambda x = value: returnStarLine(x,length = 127),None,True],                    # Group of atoms within a molecule whose chemical shift was used as the standard chemical shift reference for the defined observed nuclei.
          'Concentration_val': [None,returnStarFloat,None,False],                                             # Concentration of the chemical shift reference compound in the external reference sample.
          'Concentration_units': [None,lambda x = value: returnStarCode(x,length = 15),None,False],           # Units for the concentration value for the chemical shift reference compound.
          'Solvent': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                      # Solvent used for the external reference sample.
          'Rank': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                          # The rank of the chemical shift reference. A primary reference is the one used in reporting the data. A secondary reference would be the compound in the sample or used as an external reference.
          'Chem_shift_units': [None,lambda x = value: returnStarLine(x,length = 127),None,True],              # Units for the chemical shift value assigned to the atoms of the chemical shift reference.
          'Chem_shift_val': [None,returnStarFloat,None,True],                                                 # Value assigned to the chemical shift of the reference compound.
          'Ref_method': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                   # The reference method may be either direct (against a value measured with a chemical compound) or indirect (calculated from chemical shift ratios).
          'Ref_type': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                     # The chemical shift reference may be either internal (the compound is located in the sample) or external (the compound is in a container external to the sample).
          'Indirect_shift_ratio': [None,returnStarFloat,None,False],                                          # The Chi value used in calculating the chemical shift referencing values for nuclei that are referenced indirectly.  The values used should be those recommended by the IUPAC Taskforce on the deposition of data to the public databases (Markley$ et al.  Pure and Appl. Chem. 70$ 117-142 (1998).
          'External_ref_loc': [None,lambda x = value: returnStarLine(x,length = 127),None,False],             # External chemical shift references are defined as either located within the sample (e.g.$ as a capillary) or external to the sample and are inserted into the spectrometer before$ after$ or both before and after the sample containing the molecular system studied in the entry.
          'External_ref_sample_geometry': [None,lambda x = value: returnStarLine(x,length = 127),None,False], # The geometrical shape of the external reference sample.
          'External_ref_axis': [None,lambda x = value: returnStarLine(x,length = 127),None,False],            # The axis of the external chemical shift reference sample relative to the static field (Bo) of the spectrometer.
          'Indirect_shift_ratio_cit_ID': [None,returnStarInt,'Citation.ID',False],                            # Pointer to '_Citation.ID'
          'Indirect_shift_ratio_cit_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Citation.Sf_framecode',False],# Pointer to a saveframe of the category citation.
          'Ref_correction_type': [None,lambda x = value: returnStarLine(x,length = 127),None,False],          # If a correction value is applied to calculate the reported chemical shifts the source of the correction (pH; temperature; etc.).
          'Correction_val': [None,returnStarFloat,None,False],                                                # An uniform correction value that was applied because of an extenuating circumstance such as data collection at an unusual temperature.
          'Correction_val_cit_ID': [None,returnStarInt,'Citation.ID',False],                                  # Pointer to '_Citation.ID'
          'Correction_val_cit_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Citation.Sf_framecode',False],# Pointer to a saveframe of the category citation.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Chem_shift_reference_ID': [None,returnStarInt,'Chem_shift_reference.ID',True],                     # Pointer to '_Chem_shift_reference.ID'

                },

        'tagNames': ['Atom_type', 'Atom_isotope_number', 'Mol_common_name', 'Atom_group', 'Concentration_val', 'Concentration_units', 'Solvent', 'Rank', 'Chem_shift_units', 'Chem_shift_val', 'Ref_method', 'Ref_type', 'Indirect_shift_ratio', 'External_ref_loc', 'External_ref_sample_geometry', 'External_ref_axis', 'Indirect_shift_ratio_cit_ID', 'Indirect_shift_ratio_cit_label', 'Ref_correction_type', 'Correction_val', 'Correction_val_cit_ID', 'Correction_val_cit_label', 'Entry_ID', 'Chem_shift_reference_ID'],
        'sourcePrimaryKeys': ['Atom_type', 'Atom_isotope_number', 'Mol_common_name', 'Entry_ID', 'Chem_shift_reference_ID'],

            }

        },

    'tableNames': ['Chem_shift_ref']

    },

  'assigned_chemical_shifts': {

    'name': 'Assigned_chem_shift_list',

    'tags': {

      'Sf_category': ['assigned_chemical_shifts',lambda x = value: returnStarCode(x,length = 127),None,True], # Category assigned to the information in the saveframe.
      'Sf_framecode': [None,lambda x = value: returnStarCode(x,length = 127),None,False],                     # A descriptive label that uniquely identifies this list of reported assigned chemical shifts.
      'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                     # Pointer to '_Entry.ID'
      'ID': [None,returnStarInt,None,True],                                                                   # An integer value that uniquely identifies this saveframe of assigned chemical shifts from other saveframes of this category in an entry.
      'Data_file_name': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                   # The name of the file submitted with this depostion that contains the quantitative data for this saveframe.
      'Sample_condition_list_ID': [None,returnStarInt,'Sample_condition_list.ID',True],                       # Pointer to '_Sample_condition_list.ID'
      'Sample_condition_list_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Sample_condition_list.Sf_framecode',False],# Pointer to a saveframe of category sample_conditions.
      'Chem_shift_reference_ID': [None,returnStarInt,'Chem_shift_reference.ID',True],                         # Pointer to '_Chem_shift_reference.ID'
      'Chem_shift_reference_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Chem_shift_reference.Sf_framecode',False],# Pointer to a saveframe of category chem_shift_reference.
      'Chem_shift_1H_err': [None,returnStarFloat,None,False],                                                 # The value assigned as the error for all 1H chemical shifts reported in the saveframe.  The value reported for this tag will be inserted during annotation into the assigned chemical shift error column in the table of assigned chemical shifts.
      'Chem_shift_13C_err': [None,returnStarFloat,None,False],                                                # The value assigned as the error for all 13C chemical shifts reported in the saveframe.  The value reported for this tag will be inserted during annotation into the assigned chemical shift error column in the table of assigned chemical shifts.
      'Chem_shift_15N_err': [None,returnStarFloat,None,False],                                                # The value assigned as the error for all 15N chemical shifts reported in the saveframe.  The value reported for this tag will be inserted during annotation into the assigned chemical shift error column in the table of assigned chemical shifts.
      'Chem_shift_31P_err': [None,returnStarFloat,None,False],                                                # The value assigned as the error for all 31P chemical shifts reported in the saveframe.  The value reported for this tag will be inserted during annotation into the assigned chemical shift error column in the table of assigned chemical shifts.
      'Chem_shift_2H_err': [None,returnStarFloat,None,False],                                                 # The value assigned as the error for all 2H chemical shifts reported in the saveframe.  The value reported for this tag will be inserted during annotation into the assigned chemical shift error column in the table of assigned chemical shifts.
      'Chem_shift_19F_err': [None,returnStarFloat,None,False],                                                # The value assigned as the error for all 19F chemical shifts reported in the saveframe.  The value reported for this tag will be inserted during annotation into the assigned chemical shift error column in the table of assigned chemical shifts.
      'Error_derivation_method': [None,returnStarString,None,False],                                          # Method used to derive the estimated error in the reported chemical shifts.
      'Details': [None,returnStarString,None,False],                                                          # Text describing the reported assigned chemical shifts.
      'Text_data_format': [None,lambda x = value: returnStarLine(x,length = 31),None,False],                  # The name of the data format used to represent the assigned chemical shifts as ASCII text in the '.Text_data' tag.
      'Text_data': [None,returnStarString,None,False],                                                        # A set of assigned chemical shift data in a format as ASCII text.

            },

    'tagNames': ['Sf_category', 'Sf_framecode', 'Entry_ID', 'ID', 'Data_file_name', 'Sample_condition_list_ID', 'Sample_condition_list_label', 'Chem_shift_reference_ID', 'Chem_shift_reference_label', 'Chem_shift_1H_err', 'Chem_shift_13C_err', 'Chem_shift_15N_err', 'Chem_shift_31P_err', 'Chem_shift_2H_err', 'Chem_shift_19F_err', 'Error_derivation_method', 'Details', 'Text_data_format', 'Text_data'],
    'sourcePrimaryKeys': ['Entry_ID', 'ID'],

    'tables': {

      'Chem_shift_experiment': {

        'tags': {

          'Experiment_ID': [None,returnStarInt,'Experiment.ID',True],                                         # Pointer to '_Experiment.ID'
          'Experiment_name': [None,lambda x = value: returnStarLine(x,length = 127),'Experiment.Name',False], # The name of an experiment used to determine the data reported.
          'Sample_ID': [None,returnStarInt,'Sample.ID',False],                                                # Pointer to '_Sample.ID'
          'Sample_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Sample.Sf_framecode',False],# Pointer to a saveframe of category sample.
          'Sample_state': [None,lambda x = value: returnStarLine(x,length = 31),None,False],                  # Physical state of the sample either anisotropic or isotropic.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Assigned_chem_shift_list_ID': [None,returnStarInt,'Assigned_chem_shift_list.ID',True],             # Pointer to '_Assigned_chem_shift_list.ID'

                },

        'tagNames': ['Experiment_ID', 'Experiment_name', 'Sample_ID', 'Sample_label', 'Sample_state', 'Entry_ID', 'Assigned_chem_shift_list_ID'],
        'sourcePrimaryKeys': ['Experiment_ID'],

            },

      'Systematic_chem_shift_offset': {

        'tags': {

          'Type': [None,lambda x = value: returnStarLine(x,length = 127),None,True],                          # The kind of chemical shift offset that should be applied to all chemical shifts observed for a specific type of atom.
          'Atom_type': [None,lambda x = value: returnStarCode(x,length = 15),None,True],                      # Standard symbol used to define the atom element type.
          'Atom_isotope_number': [None,returnStarInt,None,False],                                             # Mass number for the atom defined by the '.Atom_type' tag with a systematic chemical shift offset.
          'Val': [None,lambda x = value: returnStarCode(x,length = 15),None,True],                            # Chemical shift value that has been applied to all of the reported chemical shifts to bring their values in line with values expected to be observed for the chemical shift referencing that was used.
          'Val_err': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                       # Error in the reported chemical shift offset value used.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Assigned_chem_shift_list_ID': [None,returnStarInt,'Assigned_chem_shift_list.ID',True],             # Pointer to '_Assigned_chem_shift_list.ID'

                },

        'tagNames': ['Type', 'Atom_type', 'Atom_isotope_number', 'Val', 'Val_err', 'Entry_ID', 'Assigned_chem_shift_list_ID'],
        'sourcePrimaryKeys': ['Type', 'Entry_ID', 'Assigned_chem_shift_list_ID'],

            },

      'Chem_shift_software': {

        'tags': {

          'Software_ID': [None,returnStarInt,'Software.ID',True],                                             # Pointer to '_Software.ID'
          'Software_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Software.Sf_framecode',False],# Pointer to a saveframe of category software.
          'Method_ID': [None,returnStarInt,'Method.ID',False],                                                # Pointer to '_Method.ID'
          'Method_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Method.Sf_framecode',False],# Pointer to a saveframe of category method.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Assigned_chem_shift_list_ID': [None,returnStarInt,'Assigned_chem_shift_list.ID',True],             # Pointer to '_Assigned_chem_shift_list.ID'

                },

        'tagNames': ['Software_ID', 'Software_label', 'Method_ID', 'Method_label', 'Entry_ID', 'Assigned_chem_shift_list_ID'],
        'sourcePrimaryKeys': ['Software_ID', 'Entry_ID', 'Assigned_chem_shift_list_ID'],

            },

      'Atom_chem_shift': {

        'tags': {

          'ID': [None,returnStarInt,None,True],                                                               # An integer value that is a unique identifier for the assigned chemical shift value value.
          'Assembly_atom_ID': [None,returnStarInt,'Atom.Assembly_atom_ID',False],                             # Pointer to '_Atom.Assembly_atom_ID'
          'Entity_assembly_ID': [None,returnStarInt,'Entity_assembly.ID',False],                              # Pointer to '_Entity_assembly.ID'
          'Entity_ID': [None,returnStarInt,'Entity.ID',True],                                                 # Pointer to '_Entity.ID'
          'Comp_index_ID': [None,returnStarInt,'Entity_comp_index.ID',True],                                  # Pointer to '_Entity_comp_index.ID'
          'Seq_ID': [None,returnStarInt,'Entity_poly_seq.Num',False],                                         # Pointer to '_Entity_poly_seq.Num'
          'Comp_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Chem_comp.ID',True],              # Pointer to '_Chem_comp.ID'
          'Atom_ID': [None,lambda x = value: returnStarAtCode(x,length = 12),'Chem_comp_atom.Atom_ID',True],  # Pointer to '_Chem_comp_atom.Atom_ID'
          'Atom_type': [None,lambda x = value: returnStarCode(x,length = 15),None,True],                      # The value for this tag is a standard IUPAC abbreviation for an element (i.e.$ H$ C$ P$ etc).
          'Atom_isotope_number': [None,returnStarInt,None,True],                                              # The mass number for the chemical element defined by the tag '_Atom_type' or any of its related tags.
          'Val': [None,returnStarFloat,None,True],                                                            # Assigned chemical shift value
          'Val_err': [None,returnStarFloat,None,False],                                                       # Estimated or measured error in the assigned chemical shift value.
          'Assign_fig_of_merit': [None,returnStarFloat,None,False],                                           # Figure of merit for the assignment of the atom to the reported chemical shift value.
          'Ambiguity_code': [None,lambda x = value: returnStarString(x,length = 3),None,False],               # Ambiguity codes are used to define chemical shifts that have not been assigned to specific atoms in the molecule studied.  Ambiguity in chemical shifts may exist at several different levels$ stereospecific ambiguity$ intra and inter residue ambiguities$ etc.
          'Occupancy': [None,lambda x = value: returnStarCode(x,length = 12),None,False],                     # Where multiple chemical shift values are assigned to the same atom$ the estimated percent of the molecules with the assigned chemical shift.
          'Resonance_ID': [None,returnStarInt,'Resonance.ID',False],                                          # Pointer to '_Resonance.ID'
          'PDB_record_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                 # The value is an integer that identifies a record in the atom_site list. This is a place holder for the atom record number extracted from a PDB formatted file.
          'PDB_model_num': [None,returnStarInt,None,False],                                                   # PDB model number.
          'PDB_strand_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                 # PDB strand id.
          'PDB_ins_code': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                  # PDB insertion code.
          'PDB_residue_no': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                # PDB residue number.
          'PDB_residue_name': [None,lambda x = value: returnStarCode(x,length = 15),None,False],              # PDB residue name.
          'PDB_atom_name': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                 # PDB atom name.
          'Auth_entity_assembly_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],       # An alternative identifier for Entity_assembly_ID that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Entity_assembly_ID.
          'Auth_seq_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                   # An alternative identifier for Seq_id that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Seq_ID or Comp_index_ID.
          'Auth_comp_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                  # An alternative identifier for Comp_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Auth_atom_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                  # An alternative identifier for Atom_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Details': [None,returnStarString,None,False],                                                      # Text information regarding the chemical shift assignment.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Assigned_chem_shift_list_ID': [None,returnStarInt,'Assigned_chem_shift_list.ID',True],             # Pointer to '_Assigned_chem_shift_list.ID'

                },

        'tagNames': ['ID', 'Assembly_atom_ID', 'Entity_assembly_ID', 'Entity_ID', 'Comp_index_ID', 'Seq_ID', 'Comp_ID', 'Atom_ID', 'Atom_type', 'Atom_isotope_number', 'Val', 'Val_err', 'Assign_fig_of_merit', 'Ambiguity_code', 'Occupancy', 'Resonance_ID', 'PDB_record_ID', 'PDB_model_num', 'PDB_strand_ID', 'PDB_ins_code', 'PDB_residue_no', 'PDB_residue_name', 'PDB_atom_name', 'Auth_entity_assembly_ID', 'Auth_seq_ID', 'Auth_comp_ID', 'Auth_atom_ID', 'Details', 'Entry_ID', 'Assigned_chem_shift_list_ID'],
        'sourcePrimaryKeys': ['ID', 'Entry_ID', 'Assigned_chem_shift_list_ID'],

            },

      'Ambiguous_atom_chem_shift': {

        'tags': {

          'Ambiguous_shift_set_ID': [None,returnStarInt,None,True],                                           # An integer value that defines a set of chemical shifts that form a mutually ambiguous group. For ambiguity codes of 4 or 5$ various combinations of assigned chemical shifts may form sets where the chemical shift assignments are not specifically known$ but it is known that the chemical shifts belong to one atom in the set.
          'Atom_chem_shift_ID': [None,returnStarInt,'Atom_chem_shift.ID',True],                               # Pointer to '_Atom_chem_shift.ID'
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Assigned_chem_shift_list_ID': [None,returnStarInt,'Assigned_chem_shift_list.ID',True],             # Pointer to '_Assigned_chem_shift_list.ID'

                },

        'tagNames': ['Ambiguous_shift_set_ID', 'Atom_chem_shift_ID', 'Entry_ID', 'Assigned_chem_shift_list_ID'],
        'sourcePrimaryKeys': ['Ambiguous_shift_set_ID', 'Entry_ID', 'Assigned_chem_shift_list_ID'],

            }

        },

    'tableNames': ['Chem_shift_experiment', 'Systematic_chem_shift_offset', 'Chem_shift_software', 'Atom_chem_shift', 'Ambiguous_atom_chem_shift']

    },

  'coupling_constants': {

    'name': 'Coupling_constant_list',

    'tags': {

      'Sf_category': ['coupling_constants',lambda x = value: returnStarCode(x,length = 127),None,True],       # Category assigned to the information in the saveframe.
      'Sf_framecode': [None,lambda x = value: returnStarCode(x,length = 127),None,False],                     # A descriptive label that uniquely identifies this list of reported coupling constants..
      'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                     # Pointer to '_Entry.ID'
      'ID': [None,returnStarInt,None,True],                                                                   # An integer value that uniquely identifies this saveframe of scalar coupling constant values from other saveframes of this category in an entry.
      'Data_file_name': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                   # The name of the file submitted with this depostion that contains the quantitative data for this saveframe.
      'Sample_condition_list_ID': [None,returnStarInt,'Sample_condition_list.ID',True],                       # Pointer to '_Sample_condition_list.ID'
      'Sample_condition_list_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Sample_condition_list.Sf_framecode',False],# Pointer to a saveframe of the category sample_conditions.
      'Spectrometer_frequency_1H': [None,returnStarFloat,None,False],                                         # The operating proton frequency in MHz of the NMR spectrometer used to collect the data.
      'Details': [None,returnStarString,None,False],                                                          # Text describing the reported coupling constants.
      'Text_data_format': [None,lambda x = value: returnStarLine(x,length = 31),None,False],                  # The data format used to represent the coupling constant data as ASCII text in the text block that is the value to the '_Coupling_constant_list.Text_data' tag.
      'Text_data': [None,returnStarString,None,False],                                                        # A set of scalar coupling constant data formatted as ASCII text.

            },

    'tagNames': ['Sf_category', 'Sf_framecode', 'Entry_ID', 'ID', 'Data_file_name', 'Sample_condition_list_ID', 'Sample_condition_list_label', 'Spectrometer_frequency_1H', 'Details', 'Text_data_format', 'Text_data'],
    'sourcePrimaryKeys': ['Entry_ID', 'ID'],

    'tables': {

      'Coupling_constant_experiment': {

        'tags': {

          'Experiment_ID': [None,returnStarInt,'Experiment.ID',False],                                        # Pointer to '_Experiment.ID'
          'Experiment_name': [None,lambda x = value: returnStarLine(x,length = 127),'Experiment.Name',False], # Pointer to a saveframe of the category NMR spectrometer experiment.
          'Sample_ID': [None,returnStarInt,'Sample.ID',True],                                                 # Pointer to '_Sample.ID'
          'Sample_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Sample.Sf_framecode',False],# Pointer to a saveframe of the category sample.
          'Sample_state': [None,lambda x = value: returnStarLine(x,length = 31),None,False],                  # Physical state of the sample either anisotropic or isotropic.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Coupling_constant_list_ID': [None,returnStarInt,'Coupling_constant_list.ID',True],                 # Pointer to '_Coupling_constant_list.ID'

                },

        'tagNames': ['Experiment_ID', 'Experiment_name', 'Sample_ID', 'Sample_label', 'Sample_state', 'Entry_ID', 'Coupling_constant_list_ID'],
        'sourcePrimaryKeys': ['Entry_ID', 'Coupling_constant_list_ID'],

            },

      'Coupling_constant_software': {

        'tags': {

          'Software_ID': [None,returnStarInt,'Software.ID',True],                                             # Pointer to '_Software.ID'
          'Software_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Software.Sf_framecode',False],# Pointer to a saveframe of the category software.
          'Method_ID': [None,returnStarInt,'Method.ID',False],                                                # Pointer to '_Method.ID'
          'Method_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Method.Sf_framecode',False],# Pointer to a saveframe of the category method.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Coupling_constant_list_ID': [None,returnStarInt,'Coupling_constant_list.ID',True],                 # Pointer to '_Coupling_constant_list.ID'

                },

        'tagNames': ['Software_ID', 'Software_label', 'Method_ID', 'Method_label', 'Entry_ID', 'Coupling_constant_list_ID'],
        'sourcePrimaryKeys': ['Software_ID', 'Entry_ID', 'Coupling_constant_list_ID'],

            },

      'Coupling_constant': {

        'tags': {

          'ID': [None,returnStarInt,None,True],                                                               # An integer value that is a unique identifier for the coupling constant value.
          'Code': [None,lambda x = value: returnStarLine(x,length = 31),None,True],                           # A code that defines the atoms involved in the coupling constant and the number of bonds between the named atoms.  The code is generated on the basis of the standard nomenclature for coupling constants used in the NMR community.
          'Assembly_atom_ID_1': [None,returnStarInt,'Atom.Assembly_atom_ID',False],                           # Pointer to '_Atom.Assembly_atom_ID'
          'Entity_assembly_ID_1': [None,returnStarInt,'Entity_assembly.ID',False],                            # Pointer to '_Entity_assembly.ID'
          'Entity_ID_1': [None,returnStarInt,'Entity.ID',True],                                               # Pointer to '_Entity.ID'
          'Comp_index_ID_1': [None,returnStarInt,'Entity_comp_index.ID',True],                                # Pointer to '_Entity_comp_index.ID'
          'Seq_ID_1': [None,returnStarInt,'Entity_poly_seq.Num',False],                                       # Pointer to '_Entity_poly_seq.Num'
          'Comp_ID_1': [None,lambda x = value: returnStarCode(x,length = 12),'Chem_comp.ID',True],            # Pointer to '_Chem_comp.ID'
          'Atom_ID_1': [None,lambda x = value: returnStarAtCode(x,length = 12),'Chem_comp_atom.Atom_ID',True],# Pointer to '_Chem_comp_atom.Atom_ID'
          'Atom_type_1': [None,lambda x = value: returnStarCode(x,length = 15),None,True],                    # Standard symbol used to define the atom element type.
          'Atom_isotope_number_1': [None,returnStarInt,None,False],                                           # The mass number for the chemical element defined by the tag '_Atom_type' or any of its related tags.
          'Ambiguity_code_1': [None,lambda x = value: returnStarCode(x,length = 3),None,False],               # A code indicating the presence of ambiguity in the assignment of the atom to the coupling constant value. This type of ambiguity can arise for geminal groups like the glycine alpha protons and other methylene groups.
          'Assembly_atom_ID_2': [None,returnStarInt,'Atom.Assembly_atom_ID',False],                           # Pointer to '_Atom.Assembly_atom_ID'
          'Entity_assembly_ID_2': [None,returnStarInt,'Entity_assembly.ID',False],                            # Pointer to '_Entity_assembly.ID'
          'Entity_ID_2': [None,returnStarInt,'Entity.ID',True],                                               # Pointer to '_Entity.ID'
          'Comp_index_ID_2': [None,returnStarInt,'Entity_comp_index.ID',True],                                # Pointer to '_Entity_comp_index.ID'
          'Seq_ID_2': [None,returnStarInt,'Entity_poly_seq.Num',True],                                        # Pointer to '_Entity_poly_seq.Num'
          'Comp_ID_2': [None,lambda x = value: returnStarCode(x,length = 12),'Chem_comp.ID',True],            # Pointer to '_Chem_comp.ID'
          'Atom_ID_2': [None,lambda x = value: returnStarAtCode(x,length = 12),'Chem_comp_atom.Atom_ID',True],# Pointer to '_Chem_comp_atom.Atom_ID'
          'Atom_type_2': [None,lambda x = value: returnStarCode(x,length = 15),None,True],                    # Standard symbol used to define the atom element type.
          'Atom_isotope_number_2': [None,returnStarInt,None,False],                                           # The mass number for the chemical element defined by the tag '_Atom_type' or any of its related tags.
          'Ambiguity_code_2': [None,lambda x = value: returnStarCode(x,length = 3),None,False],               # A code indicating the presence of ambiguity in the assignment of the atom to the coupling constant value. This type of ambiguity can arise for geminal groups like the glycine alpha protons and other methylene groups.
          'Val': [None,returnStarFloat,None,False],                                                           # Scalar coupling constant value
          'Val_min': [None,returnStarFloat,None,False],                                                       # Minimum estimated value for a scalar coupling constant when a specific defined value cannot be obtained.
          'Val_max': [None,returnStarFloat,None,False],                                                       # Maximum estimated value for a scalar coupling constant when a specific value cannot be obtained.
          'Val_err': [None,returnStarFloat,None,False],                                                       # Estimated or measured error in the scalar coupling constant value.
          'Resonance_ID_1': [None,returnStarInt,'Resonance.ID',False],                                        # Pointer to '_Resonance.ID'
          'Resonance_ID_2': [None,returnStarInt,'Resonance.ID',False],                                        # Pointer to '_Resonance.ID'
          'Auth_entity_assembly_ID_1': [None,lambda x = value: returnStarCode(x,length = 15),None,False],     # An alternative identifier for Entity_assembly_ID that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Entity_assembly_ID.
          'Auth_seq_ID_1': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                 # An alternative identifier for Seq_id that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Seq_ID or Comp_index_ID.
          'Auth_comp_ID_1': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                # An alternative identifier for Comp_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Auth_atom_ID_1': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                # An alternative identifier for Atom_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Auth_entity_assembly_ID_2': [None,lambda x = value: returnStarCode(x,length = 15),None,False],     # An alternative identifier for Entity_assembly_ID that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Entity_assembly_ID.
          'Auth_seq_ID_2': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                 # An alternative identifier for Seq_id that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Seq_ID or Comp_index_ID.
          'Auth_comp_ID_2': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                # An alternative identifier for Comp_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Auth_atom_ID_2': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                # An alternative identifier for Atom_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Details': [None,returnStarString,None,False],                                                      # Text providing additional information about the reported coupling constants.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Coupling_constant_list_ID': [None,returnStarInt,'Coupling_constant_list.ID',True],                 # Pointer to '_Coupling_constant_list.ID'

                },

        'tagNames': ['ID', 'Code', 'Assembly_atom_ID_1', 'Entity_assembly_ID_1', 'Entity_ID_1', 'Comp_index_ID_1', 'Seq_ID_1', 'Comp_ID_1', 'Atom_ID_1', 'Atom_type_1', 'Atom_isotope_number_1', 'Ambiguity_code_1', 'Assembly_atom_ID_2', 'Entity_assembly_ID_2', 'Entity_ID_2', 'Comp_index_ID_2', 'Seq_ID_2', 'Comp_ID_2', 'Atom_ID_2', 'Atom_type_2', 'Atom_isotope_number_2', 'Ambiguity_code_2', 'Val', 'Val_min', 'Val_max', 'Val_err', 'Resonance_ID_1', 'Resonance_ID_2', 'Auth_entity_assembly_ID_1', 'Auth_seq_ID_1', 'Auth_comp_ID_1', 'Auth_atom_ID_1', 'Auth_entity_assembly_ID_2', 'Auth_seq_ID_2', 'Auth_comp_ID_2', 'Auth_atom_ID_2', 'Details', 'Entry_ID', 'Coupling_constant_list_ID'],
        'sourcePrimaryKeys': ['ID', 'Entry_ID', 'Coupling_constant_list_ID'],

            }

        },

    'tableNames': ['Coupling_constant_experiment', 'Coupling_constant_software', 'Coupling_constant']

    },

  'spectral_peak_list': {

    'name': 'Spectral_peak_list',

    'tags': {

      'Sf_category': ['spectral_peak_list',lambda x = value: returnStarCode(x,length = 127),None,False],      # Category definition for the information content of the saveframe
      'Sf_framecode': [None,lambda x = value: returnStarCode(x,length = 127),None,False],                     # A descriptive label that uniquely identifies this list of spectral peaks.
      'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                     # Pointer to '_Entry.ID'
      'ID': [None,returnStarInt,None,True],                                                                   # Spectral peak list ID
      'Data_file_name': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                   # The name of the file submitted with this depostion that contains the quantitative data for this saveframe.
      'Sample_ID': [None,returnStarInt,'Sample.ID',True],                                                     # Pointer to '_Sample.ID'
      'Sample_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Sample.Sf_framecode',False],   # Pointer to a saveframe of the category 'sample'
      'Sample_condition_list_ID': [None,returnStarInt,'Sample_condition_list.ID',True],                       # Pointer to '_Sample_condition_list.ID'
      'Sample_condition_list_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Sample_condition_list.Sf_framecode',False],# The label for the set of experimental sample conditions used to collect the NMR spectrum from which the peak list originated.
      'Experiment_ID': [None,returnStarInt,'Experiment.ID',True],                                             # Pointer to '_Experiment.ID'
      'Experiment_name': [None,lambda x = value: returnStarLine(x,length = 127),'Experiment.Name',True],      # Pointer to a saveframe of the category 'NMR_spectrometer_expt'
      'Number_of_spectral_dimensions': [None,returnStarInt,None,True],                                        # Number of dimension in the spectrum from which the peak list was extracted.
      'Details': [None,returnStarString,None,False],                                                          # Text describing the reported list of spectral peaks.
      'Text_data_format': [None,lambda x = value: returnStarLine(x,length = 31),None,False],                  # The data format used to represent the spectral peak data as ASCII text in the text block that is the value to the '_Spectral_peak_list.Text_data' tag.
      'Text_data': [None,returnStarString,None,False],                                                        # A set of spectral peak data formatted as ASCII text.

            },

    'tagNames': ['Sf_category', 'Sf_framecode', 'Entry_ID', 'ID', 'Data_file_name', 'Sample_ID', 'Sample_label', 'Sample_condition_list_ID', 'Sample_condition_list_label', 'Experiment_ID', 'Experiment_name', 'Number_of_spectral_dimensions', 'Details', 'Text_data_format', 'Text_data'],
    'sourcePrimaryKeys': ['Entry_ID', 'ID'],

    'tables': {

      'Spectral_dim': {

        'tags': {

          'ID': [None,returnStarInt,None,True],                                                               # An integer value that specifies the dimension of a multidimensional NMR spectrum.
          'Atom_type': [None,lambda x = value: returnStarCode(x,length = 15),None,True],                      # The value for this tag is a standard IUPAC abbreviation for an element (i.e.$ H$ C$ P$ etc).
          'Atom_isotope_number': [None,returnStarInt,None,True],                                              # The mass number for the specified atom.
          'Spectral_region': [None,lambda x = value: returnStarCode(x,length = 31),None,True],                # A code defining the type of nuclei that would be expected to be observed in the spectral region observed in the dimension of the spectrum.
          'Magnetization_linkage_ID': [None,returnStarInt,None,False],                                        # The magnetization linkage ID is used to designate dimensions of a multidimensional NMR experiment where the nuclei observed in the dimensions are directly linked by a one bond scalar coupling. For example$ the amide proton and amide nitrogen in an 1H-15N HSQC experiment.
          'Sweep_width': [None,returnStarFloat,None,False],                                                   # The width of the spectral window observed in Hz.
          'Encoding_code': [None,lambda x = value: returnStarLine(x,length = 31),None,False],                 # Code describing how information from one spectral dimension has been encoded in another dimension in for example a reduced dimensionality experiment.
          'Encoded_source_dimension_ID': [None,returnStarInt,None,False],                                     # The spectral dimension in a reduced dimensionality experiment that is the source of the magnetization that has been encoded.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Spectral_peak_list_ID': [None,returnStarInt,'Spectral_peak_list.ID',True],                         # Pointer to '_Spectral_peak_list.ID'

                },

        'tagNames': ['ID', 'Atom_type', 'Atom_isotope_number', 'Spectral_region', 'Magnetization_linkage_ID', 'Sweep_width', 'Encoding_code', 'Encoded_source_dimension_ID', 'Entry_ID', 'Spectral_peak_list_ID'],
        'sourcePrimaryKeys': ['ID', 'Atom_type', 'Spectral_region', 'Entry_ID', 'Spectral_peak_list_ID'],

            },

      'Spectral_peak_software': {

        'tags': {

          'Software_ID': [None,returnStarInt,'Software.ID',True],                                             # Pointer to '_Software.ID'
          'Software_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Software.Sf_framecode',False],# Pointer to a saveframe of the category 'software'
          'Method_ID': [None,returnStarInt,'Method.ID',False],                                                # Pointer to '_Method.ID'
          'Method_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Method.Sf_framecode',False],# Pointer to a saveframe of the category 'method'
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Spectral_peak_list_ID': [None,returnStarInt,'Spectral_peak_list.ID',True],                         # Pointer to '_Spectral_peak_list.ID'

                },

        'tagNames': ['Software_ID', 'Software_label', 'Method_ID', 'Method_label', 'Entry_ID', 'Spectral_peak_list_ID'],
        'sourcePrimaryKeys': ['Software_ID', 'Entry_ID', 'Spectral_peak_list_ID'],

            },

      'Peak': {

        'tags': {

          'ID': [None,returnStarInt,None,True],                                                               # Unique identifier for the spectral peak.
          'Figure_of_merit': [None,returnStarFloat,None,False],                                               # A quantitative or qualitative value that provides a measure of certainty that the peak listed represents a real piece of data.
          'Details': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                      # Text providing additional information regarding the spectral peak.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Spectral_peak_list_ID': [None,returnStarInt,'Spectral_peak_list.ID',True],                         # Pointer to '_Spectral_peak_list.ID'

                },

        'tagNames': ['ID', 'Figure_of_merit', 'Details', 'Entry_ID', 'Spectral_peak_list_ID'],
        'sourcePrimaryKeys': ['ID', 'Entry_ID', 'Spectral_peak_list_ID'],

            },

      'Peak_general_char': {

        'tags': {

          'Peak_ID': [None,returnStarInt,'Peak.ID',True],                                                     # Pointer to '_Peak.ID'
          'Intensity_val': [None,returnStarFloat,None,True],                                                  # Value for the intensity of the peak.
          'Intensity_val_err': [None,returnStarFloat,None,False],                                             # Error in the value for the intensity of the peak.
          'Measurement_method': [None,lambda x = value: returnStarLine(x,length = 127),None,False],           # Method used to determine the intensity value for the peak.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Spectral_peak_list_ID': [None,returnStarInt,'Spectral_peak_list.ID',True],                         # Pointer to '_Spectral_peak_list.ID'

                },

        'tagNames': ['Peak_ID', 'Intensity_val', 'Intensity_val_err', 'Measurement_method', 'Entry_ID', 'Spectral_peak_list_ID'],
        'sourcePrimaryKeys': ['Peak_ID', 'Intensity_val', 'Entry_ID', 'Spectral_peak_list_ID'],

            },

      'Peak_char': {

        'tags': {

          'Peak_ID': [None,returnStarInt,'Peak.ID',True],                                                     # Pointer to '_Peak.ID'
          'Spectral_dim_ID': [None,returnStarInt,'Spectral_dim.ID',True],                                     # Pointer to '_Spectral_dim.ID'
          'Chem_shift_val': [None,returnStarFloat,None,True],                                                 # Chem shift val
          'Chem_shift_val_err': [None,returnStarFloat,None,False],                                            # Chem shift val err
          'Line_width_val': [None,returnStarFloat,None,False],                                                # Line width val
          'Line_width_val_err': [None,returnStarFloat,None,False],                                            # Line width val err
          'Phase_val': [None,returnStarFloat,None,False],                                                     # Phase val
          'Phase_val_err': [None,returnStarFloat,None,False],                                                 # Phase val err
          'Decay_rate_val': [None,returnStarFloat,None,False],                                                # Decay rate val
          'Decay_rate_val_err': [None,returnStarFloat,None,False],                                            # Decay rate val err
          'Coupling_pattern': [None,lambda x = value: returnStarLine(x,length = 15),None,False],              # A code that describes the type of coupling pattern observed for the NMR spectral peak.
          'Bounding_box_upper_val': [None,returnStarFloat,None,False],                                        # The upper chemical shift value in the defined spectral dimension for a bounding box used to define the region of the NMR spectrum that contains the observed peak.
          'Bounding_box_lower_val': [None,returnStarFloat,None,False],                                        # The upper chemical shift value in the defined spectral dimension for a bounding box used to define the region of the NMR spectrum that contains the observed peak.
          'Bounding_box_range_val': [None,returnStarFloat,None,False],                                        # Range value for a bounding box used to define the region of a NMR spectrum where an observed peak is located$ when the bounding box is defined by a range in chemical shift centered on the peak chemical shift.
          'Details': [None,returnStarString,None,False],                                                      # Text describing the characteristics for an observed peak.
          'Derivation_method_ID': [None,returnStarInt,'Method.ID',False],                                     # Pointer to '_Method.ID'
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Spectral_peak_list_ID': [None,returnStarInt,'Spectral_peak_list.ID',True],                         # Pointer to '_Spectral_peak_list.ID'

                },

        'tagNames': ['Peak_ID', 'Spectral_dim_ID', 'Chem_shift_val', 'Chem_shift_val_err', 'Line_width_val', 'Line_width_val_err', 'Phase_val', 'Phase_val_err', 'Decay_rate_val', 'Decay_rate_val_err', 'Coupling_pattern', 'Bounding_box_upper_val', 'Bounding_box_lower_val', 'Bounding_box_range_val', 'Details', 'Derivation_method_ID', 'Entry_ID', 'Spectral_peak_list_ID'],
        'sourcePrimaryKeys': ['Peak_ID', 'Spectral_dim_ID', 'Entry_ID', 'Spectral_peak_list_ID'],

            },

      'Peak_contribution': {

        'tags': {

          'ID': [None,returnStarInt,None,True],                                                               # Integer value that identifies one or more factional peak values linked to a peak ID.
          'Contribution_fractional_val': [None,returnStarFloat,None,False],                                   # The fraction of a peak assigned to this peak ID.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',False],                # Pointer to '_Entry.ID'
          'Spectral_peak_list_ID': [None,returnStarInt,'Spectral_peak_list.ID',False],                        # Pointer to '_Spectral_peak_list.ID'

                },

        'tagNames': ['ID', 'Contribution_fractional_val', 'Entry_ID', 'Spectral_peak_list_ID'],
        'sourcePrimaryKeys': ['ID'],

            },

      'Assigned_peak_chem_shift': {

        'tags': {

          'Peak_ID': [None,returnStarInt,'Peak.ID',True],                                                     # Pointer to '_Peak.ID'
          'Spectral_dim_ID': [None,returnStarInt,'Spectral_dim.ID',True],                                     # Pointer to '_Spectral_dim.ID'
          'Peak_contribution_ID': [None,returnStarInt,'Peak_contribution.ID',False],                          # Pointer to '_Peak_contribution.ID'
          'Set_ID': [None,returnStarInt,None,False],                                                          # Set ID
          'Magnetization_linkage_ID': [None,returnStarInt,None,False],                                        # Magnetization linkage ID
          'Assembly_atom_ID': [None,returnStarInt,'Atom.Assembly_atom_ID',False],                             # Pointer to '_Atom.Assembly_atom_ID'
          'Val': [None,returnStarFloat,None,False],                                                           # The quantitative chemical shift value assigned to the peak.
          'Figure_of_merit': [None,returnStarFloat,None,False],                                               # Figure of merit for the assignment of the atom to the reported chemical shift value.
          'Assigned_chem_shift_list_ID': [None,returnStarInt,'Assigned_chem_shift_list.ID',False],            # Pointer to '_Assigned_chem_shift_list.ID'
          'Atom_chem_shift_ID': [None,returnStarInt,'Atom_chem_shift.ID',False],                              # Pointer to '_Atom_chem_shift.ID'
          'Entity_assembly_ID': [None,returnStarInt,'Entity_assembly.ID',False],                              # Pointer to '_Entity_assembly.ID'
          'Entity_ID': [None,returnStarInt,'Entity.ID',False],                                                # Pointer to '_Entity.ID'
          'Comp_index_ID': [None,returnStarInt,'Entity_comp_index.ID',False],                                 # Pointer to '_Entity_comp_index.ID'
          'Comp_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Chem_comp.ID',False],             # Pointer to '_Chem_comp.ID'
          'Atom_ID': [None,lambda x = value: returnStarAtCode(x,length = 12),'Chem_comp_atom.Atom_ID',True],  # Pointer to '_Chem_comp_atom.Atom_ID'
          'Resonance_ID': [None,returnStarInt,'Resonance.ID',False],                                          # Pointer to '_Resonance.ID'
          'Details': [None,returnStarString,None,False],                                                      # Text describing the reported spectral peak assignment.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Spectral_peak_list_ID': [None,returnStarInt,'Spectral_peak_list.ID',True],                         # Pointer to '_Spectral_peak_list.ID'

                },

        'tagNames': ['Peak_ID', 'Spectral_dim_ID', 'Peak_contribution_ID', 'Set_ID', 'Magnetization_linkage_ID', 'Assembly_atom_ID', 'Val', 'Figure_of_merit', 'Assigned_chem_shift_list_ID', 'Atom_chem_shift_ID', 'Entity_assembly_ID', 'Entity_ID', 'Comp_index_ID', 'Comp_ID', 'Atom_ID', 'Resonance_ID', 'Details', 'Entry_ID', 'Spectral_peak_list_ID'],
        'sourcePrimaryKeys': ['Peak_ID', 'Spectral_dim_ID', 'Atom_ID', 'Entry_ID', 'Spectral_peak_list_ID'],

            },

      'Spectral_transition': {

        'tags': {

          'ID': [None,returnStarInt,None,True],                                                               # Unique identifier for the spectral peak.
          'Figure_of_merit': [None,returnStarFloat,None,False],                                               # A quantitative or qualitative value that provides a measure of certainty that the peak listed represents a real piece of data.
          'Details': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                      # Text providing additional information regarding the spectral peak.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Spectral_peak_list_ID': [None,returnStarInt,'Spectral_peak_list.ID',True],                         # Pointer to '_Spectral_peak_list.ID'

                },

        'tagNames': ['ID', 'Figure_of_merit', 'Details', 'Entry_ID', 'Spectral_peak_list_ID'],
        'sourcePrimaryKeys': ['ID', 'Entry_ID', 'Spectral_peak_list_ID'],

            },

      'Spectral_transition_general_char': {

        'tags': {

          'Spectral_transition_ID': [None,returnStarInt,'Peak.ID',True],                                      # Pointer to '_Peak.ID'
          'Intensity_val': [None,returnStarFloat,None,True],                                                  # Value for the intensity of the peak.
          'Intensity_val_err': [None,returnStarFloat,None,False],                                             # Error in the value for the intensity of the peak.
          'Measurement_method': [None,lambda x = value: returnStarLine(x,length = 127),None,False],           # Method used to determine the intensity value for the peak.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Spectral_peak_list_ID': [None,returnStarInt,'Spectral_peak_list.ID',True],                         # Pointer to '_Spectral_peak_list.ID'

                },

        'tagNames': ['Spectral_transition_ID', 'Intensity_val', 'Intensity_val_err', 'Measurement_method', 'Entry_ID', 'Spectral_peak_list_ID'],
        'sourcePrimaryKeys': ['Spectral_transition_ID', 'Intensity_val', 'Entry_ID', 'Spectral_peak_list_ID'],

            },

      'Spectral_transition_char': {

        'tags': {

          'Spectral_transition_ID': [None,returnStarInt,'Spectral_transition.ID',True],                       # Pointer to '_Spectral_transition.ID'
          'Spectral_dim_ID': [None,returnStarInt,'Spectral_dim.ID',True],                                     # Pointer to '_Spectral_dim.ID'
          'Chem_shift_val': [None,returnStarFloat,None,True],                                                 # Chem shift val
          'Chem_shift_val_err': [None,returnStarFloat,None,False],                                            # Chem shift val err
          'Line_width_val': [None,returnStarFloat,None,False],                                                # Line width val
          'Line_width_val_err': [None,returnStarFloat,None,False],                                            # Line width val err
          'Phase_val': [None,returnStarFloat,None,False],                                                     # Phase val
          'Phase_val_err': [None,returnStarFloat,None,False],                                                 # Phase val err
          'Decay_rate_val': [None,returnStarFloat,None,False],                                                # Decay rate val
          'Decay_rate_val_err': [None,returnStarFloat,None,False],                                            # Decay rate val err
          'Bounding_box_upper_val': [None,returnStarFloat,None,False],                                        # The upper chemical shift value in the defined spectral dimension for a bounding box used to define the region of the NMR spectrum that contains the observed spectral transition.
          'Bounding_box_lower_val': [None,returnStarFloat,None,False],                                        # The upper chemical shift value in the defined spectral dimension for a bounding box used to define the region of the NMR spectrum that contains the observed spectral transition.
          'Bounding_box_width_val': [None,returnStarFloat,None,False],                                        # Range value for a bounding box used to define the region of a NMR spectrum where an observed spectral transition is located$ when the bounding box is defined by a range in chemical shift centered on the  chemical shift for a spectral transition.
          'Derivation_method_ID': [None,returnStarInt,None,False],                                            # Derivation methods ID
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Spectral_peak_list_ID': [None,returnStarInt,'Spectral_peak_list.ID',True],                         # Pointer to '_Spectral_peak_list.ID'

                },

        'tagNames': ['Spectral_transition_ID', 'Spectral_dim_ID', 'Chem_shift_val', 'Chem_shift_val_err', 'Line_width_val', 'Line_width_val_err', 'Phase_val', 'Phase_val_err', 'Decay_rate_val', 'Decay_rate_val_err', 'Bounding_box_upper_val', 'Bounding_box_lower_val', 'Bounding_box_width_val', 'Derivation_method_ID', 'Entry_ID', 'Spectral_peak_list_ID'],
        'sourcePrimaryKeys': ['Spectral_transition_ID', 'Spectral_dim_ID', 'Entry_ID', 'Spectral_peak_list_ID'],

            },

      'Spectral_transition_contrib': {

        'tags': {

          'ID': [None,returnStarInt,None,True],                                                               # Integer value that identifies one or more factional peak values linked to a peak ID.
          'Contribution_fractional_val': [None,returnStarFloat,None,False],                                   # The fraction of a peak assigned to this peak ID.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',False],                # Pointer to '_Entry.ID'
          'Spectral_peak_list_ID': [None,returnStarInt,'Spectral_peak_list.ID',False],                        # Pointer to '_Spectral_peak_list.ID'

                },

        'tagNames': ['ID', 'Contribution_fractional_val', 'Entry_ID', 'Spectral_peak_list_ID'],
        'sourcePrimaryKeys': ['ID'],

            },

      'Assigned_spectral_transition': {

        'tags': {

          'Spectral_transition_ID': [None,returnStarInt,'Spectral_transition.ID',True],                       # Pointer to '_Spectral_transition.ID'
          'Spectral_dim_ID': [None,returnStarInt,'Spectral_dim.ID',True],                                     # Pointer to '_Spectral_dim.ID'
          'Spectral_transition_contrib_ID': [None,returnStarInt,'Spectral_transition_contrib.ID',False],      # Pointer to '_Spectral_transition_contrib.ID'
          'Peak_ID': [None,returnStarInt,'Peak.ID',False],                                                    # Pointer to '_Peak.ID'
          'Set_ID': [None,returnStarInt,None,False],                                                          # Set ID
          'Magnetization_linkage_ID': [None,returnStarInt,None,False],                                        # Magnetization linkage ID
          'Assembly_atom_ID': [None,returnStarInt,'Atom.Assembly_atom_ID',False],                             # Pointer to '_Atom.Assembly_atom_ID'
          'Val': [None,returnStarFloat,None,False],                                                           # The quantitative chemical shift value assigned to the transition.
          'Assigned_chem_shift_list_ID': [None,returnStarInt,'Assigned_chem_shift_list.ID',False],            # Pointer to '_Assigned_chem_shift_list.ID'
          'Atom_chem_shift_ID': [None,returnStarInt,'Atom_chem_shift.ID',False],                              # Pointer to '_Atom_chem_shift.ID'
          'Entity_assembly_ID': [None,returnStarInt,'Entity_assembly.ID',False],                              # Pointer to '_Entity_assembly.ID'
          'Entity_ID': [None,returnStarInt,'Entity.ID',False],                                                # Pointer to '_Entity.ID'
          'Comp_index_ID': [None,returnStarInt,'Entity_comp_index.ID',False],                                 # Pointer to '_Entity_comp_index.ID'
          'Comp_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Chem_comp.ID',False],             # Pointer to '_Chem_comp.ID'
          'Atom_ID': [None,lambda x = value: returnStarAtCode(x,length = 12),'Chem_comp_atom.Atom_ID',False], # Pointer to '_Chem_comp_atom.Atom_ID'
          'Figure_of_merit': [None,returnStarFloat,None,False],                                               # Figure of merit
          'Resonance_ID': [None,returnStarInt,'Resonance.ID',False],                                          # Pointer to '_Resonance.ID'
          'Details': [None,returnStarString,None,False],                                                      # Text describing the reported spectral peak assignment.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Spectral_peak_list_ID': [None,returnStarInt,'Spectral_peak_list.ID',True],                         # Pointer to '_Spectral_peak_list.ID'

                },

        'tagNames': ['Spectral_transition_ID', 'Spectral_dim_ID', 'Spectral_transition_contrib_ID', 'Peak_ID', 'Set_ID', 'Magnetization_linkage_ID', 'Assembly_atom_ID', 'Val', 'Assigned_chem_shift_list_ID', 'Atom_chem_shift_ID', 'Entity_assembly_ID', 'Entity_ID', 'Comp_index_ID', 'Comp_ID', 'Atom_ID', 'Figure_of_merit', 'Resonance_ID', 'Details', 'Entry_ID', 'Spectral_peak_list_ID'],
        'sourcePrimaryKeys': ['Spectral_transition_ID', 'Spectral_dim_ID', 'Entry_ID', 'Spectral_peak_list_ID'],

            }

        },

    'tableNames': ['Spectral_dim', 'Spectral_peak_software', 'Peak', 'Peak_general_char', 'Peak_char', 'Peak_contribution', 'Assigned_peak_chem_shift', 'Spectral_transition', 'Spectral_transition_general_char', 'Spectral_transition_char', 'Spectral_transition_contrib', 'Assigned_spectral_transition']

    },

  'resonance_linker': {

    'name': 'Resonance_linker_list',

    'tags': {

      'Sf_category': ['resonance_linker',lambda x = value: returnStarCode(x,length = 127),None,False],        # Category definition for the information content of the saveframe
      'Sf_framecode': [None,lambda x = value: returnStarCode(x,length = 127),None,False],                     # A label for the saveframe that describes in very brief terms the information contained in the saveframe.
      'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                     # Pointer to '_Entry.ID'
      'ID': [None,returnStarInt,None,True],                                                                   # An integer value that uniquely identifies this saveframe of resonance linker information from other saveframes of this category in an entry.
      'Details': [None,returnStarString,None,False],                                                          # Text providing additional information regarding the data in the resonance linker list saveframe.

            },

    'tagNames': ['Sf_category', 'Sf_framecode', 'Entry_ID', 'ID', 'Details'],
    'sourcePrimaryKeys': ['Entry_ID', 'ID'],

    'tables': {

      'Resonance': {

        'tags': {

          'ID': [None,returnStarInt,None,True],                                                               # Unique identifier for the specified resonance.
          'Name': [None,lambda x = value: returnStarCode(x,length = 12),None,False],                          # Name for the specified resonance
          'Resonance_set_ID': [None,returnStarInt,'Resonance_assignment.Resonance_set_ID',False],             # Pointer to '_Resonance_assignment.Resonance_set_ID'
          'Spin_system_ID': [None,returnStarInt,'Spin_system.ID',False],                                      # Pointer to '_Spin_system.ID'
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Resonance_linker_list_ID': [None,returnStarInt,'Resonance_linker_list.ID',True],                   # Pointer to '_Resonance_linker_list.ID'

                },

        'tagNames': ['ID', 'Name', 'Resonance_set_ID', 'Spin_system_ID', 'Entry_ID', 'Resonance_linker_list_ID'],
        'sourcePrimaryKeys': ['ID', 'Entry_ID', 'Resonance_linker_list_ID'],

            },

      'Resonance_covalent_link': {

        'tags': {

          'Resonance_ID_1': [None,returnStarInt,'Resonance.ID',False],                                        # Pointer to '_Resonance.ID'
          'Resonance_ID_2': [None,returnStarInt,'Resonance.ID',False],                                        # Pointer to '_Resonance.ID'
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',False],                # Pointer to '_Entry.ID'
          'Resonance_linker_list_ID': [None,returnStarInt,'Resonance_linker_list.ID',False],                  # Pointer to '_Resonance_linker_list.ID'

                },

        'tagNames': ['Resonance_ID_1', 'Resonance_ID_2', 'Entry_ID', 'Resonance_linker_list_ID'],
        'sourcePrimaryKeys': ['Resonance_ID_1', 'Resonance_ID_2', 'Entry_ID', 'Resonance_linker_list_ID'],

            },

      'Resonance_assignment': {

        'tags': {

          'Resonance_set_ID': [None,returnStarInt,None,True],                                                 # ?
          'Assembly_atom_ID': [None,returnStarInt,'Atom.Assembly_atom_ID',False],                             # Pointer to '_Atom.Assembly_atom_ID'
          'Entity_assembly_ID': [None,returnStarInt,'Entity_assembly.ID',True],                               # Pointer to '_Entity_assembly.ID'
          'Entity_ID': [None,returnStarInt,'Entity.ID',False],                                                # Pointer to '_Entity.ID'
          'Comp_index_ID': [None,returnStarInt,'Entity_comp_index.ID',True],                                  # Pointer to '_Entity_comp_index.ID'
          'Comp_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Chem_comp.ID',False],             # Pointer to '_Chem_comp.ID'
          'Atom_ID': [None,lambda x = value: returnStarAtCode(x,length = 12),'Chem_comp_atom.Atom_ID',True],  # Pointer to '_Chem_comp_atom.Atom_ID'
          'Atom_type': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                     # ?
          'Atom_isotope_number': [None,returnStarInt,None,False],                                             # Isotope number for the specified atom.
          'Atom_set_ID': [None,returnStarInt,None,False],                                                     # ?
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Resonance_linker_list_ID': [None,returnStarInt,'Resonance_linker_list.ID',True],                   # Pointer to '_Resonance_linker_list.ID'

                },

        'tagNames': ['Resonance_set_ID', 'Assembly_atom_ID', 'Entity_assembly_ID', 'Entity_ID', 'Comp_index_ID', 'Comp_ID', 'Atom_ID', 'Atom_type', 'Atom_isotope_number', 'Atom_set_ID', 'Entry_ID', 'Resonance_linker_list_ID'],
        'sourcePrimaryKeys': ['Resonance_set_ID', 'Entity_assembly_ID', 'Comp_index_ID', 'Atom_ID', 'Entry_ID', 'Resonance_linker_list_ID'],

            },

      'Spin_system': {

        'tags': {

          'ID': [None,returnStarInt,None,True],                                                               # An integer value that uniquely identifies the spin system in the list.
          'Entity_assembly_ID': [None,returnStarInt,'Entity_assembly.ID',False],                              # Pointer to '_Entity_assembly.ID'
          'Entity_ID': [None,returnStarInt,'Entity.ID',False],                                                # Pointer to '_Entity.ID'
          'Comp_index_ID': [None,returnStarInt,'Entity_comp_index.ID',False],                                 # Pointer to '_Entity_comp_index.ID'
          'Comp_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Chem_comp.ID',False],             # Pointer to '_Chem_comp.ID'
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Resonance_linker_list_ID': [None,returnStarInt,'Resonance_linker_list.ID',True],                   # Pointer to '_Resonance_linker_list.ID'

                },

        'tagNames': ['ID', 'Entity_assembly_ID', 'Entity_ID', 'Comp_index_ID', 'Comp_ID', 'Entry_ID', 'Resonance_linker_list_ID'],
        'sourcePrimaryKeys': ['ID', 'Entry_ID', 'Resonance_linker_list_ID'],

            },

      'Spin_system_link': {

        'tags': {

          'From_spin_system_ID': [None,returnStarInt,'Spin_system.ID',False],                                 # Pointer to '_Spin_system.ID'
          'To_spin_system_ID': [None,returnStarInt,'Spin_system.ID',False],                                   # Pointer to '_Spin_system.ID'
          'Offset': [None,returnStarInt,None,False],                                                          # The difference in sequence number between the from and to spin system. For example$ if the 'from' spin system is ALA39 and the 'to' spin system is THR38 then the offset is -1.
          'Type': [None,lambda x = value: returnStarLine(x,length = 31),None,False],                          # The type of link between the from and to spin system.
          'Selected': [None,lambda x = value: returnStarCode(x,length = 3),None,False],                       # Boolean flag that defines if the described link is selected as the correct link in an assignment process.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',False],                # Pointer to '_Entry.ID'
          'Resonance_linker_list_ID': [None,returnStarInt,'Resonance_linker_list.ID',False],                  # Pointer to '_Resonance_linker_list.ID'

                },

        'tagNames': ['From_spin_system_ID', 'To_spin_system_ID', 'Offset', 'Type', 'Selected', 'Entry_ID', 'Resonance_linker_list_ID'],
        'sourcePrimaryKeys': ['From_spin_system_ID', 'To_spin_system_ID', 'Entry_ID', 'Resonance_linker_list_ID'],

            }

        },

    'tableNames': ['Resonance', 'Resonance_covalent_link', 'Resonance_assignment', 'Spin_system', 'Spin_system_link']

    },

  'chem_shift_isotope_effect': {

    'name': 'Chem_shift_isotope_effect_list',

    'tags': {

      'Sf_category': ['chem_shift_isotope_effect',lambda x = value: returnStarCode(x,length = 127),None,True],# Category definition for the information content of the saveframe
      'Sf_framecode': [None,lambda x = value: returnStarCode(x,length = 127),None,False],                     # A label for the saveframe that describes in very brief terms the information contained in the saveframe.
      'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                     # Pointer to '_Entry.ID'
      'ID': [None,returnStarInt,None,True],                                                                   # An integer value that uniquely identifies this saveframe of chemical shift isotope effect values from other saveframes of this category in an entry.
      'Data_file_name': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                   # The name of the file submitted with this depostion that contains the quantitative data for this saveframe.
      'Sample_condition_list_ID': [None,returnStarInt,'Sample_condition_list.ID',True],                       # Pointer to '_Sample_condition_list.ID'
      'Sample_condition_list_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Sample_condition_list.Sf_framecode',False],# Pointer to a saveframe of the category 'sample_conditions'
      'Isotope_effect_type': [None,lambda x = value: returnStarLine(x,length = 127),None,False],              # The type of isotope chemical shift effect.
      'Isotope_effect_val_units': [None,lambda x = value: returnStarCode(x,length = 15),None,False],          # The units for the isotope chemical shift effect.
      'Details': [None,returnStarString,None,False],                                                          # Text providing additional information regarding the chemical shift isotope effect data and its derivation.
      'Text_data_format': [None,lambda x = value: returnStarLine(x,length = 31),None,False],                  # The data format used to represent the chemical shift isotope effect data as ASCII text in the text block that is the value to the '_Chem_shift_isotope_effect.Text_data' tag.
      'Text_data': [None,returnStarString,None,False],                                                        # A set of chemical shift isotope effect data formatted as ASCII text.

            },

    'tagNames': ['Sf_category', 'Sf_framecode', 'Entry_ID', 'ID', 'Data_file_name', 'Sample_condition_list_ID', 'Sample_condition_list_label', 'Isotope_effect_type', 'Isotope_effect_val_units', 'Details', 'Text_data_format', 'Text_data'],
    'sourcePrimaryKeys': ['Entry_ID', 'ID'],

    'tables': {

      'Isotope_effect_experiment': {

        'tags': {

          'Experiment_ID': [None,returnStarInt,'Experiment.ID',True],                                         # Pointer to '_Experiment.ID'
          'Experiment_name': [None,lambda x = value: returnStarLine(x,length = 127),'Experiment.Name',False], # Pointer to a saveframe of the category 'NMR_spectrometer_expt'
          'Sample_ID': [None,returnStarInt,'Sample.ID',True],                                                 # Pointer to '_Sample.ID'
          'Sample_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Sample.Sf_framecode',False],# Pointer to a saveframe of the category 'sample'
          'Sample_state': [None,lambda x = value: returnStarLine(x,length = 127),None,True],                  # Physical state of the sample either anisotropic or isotropic.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Chem_shift_isotope_effect_list_ID': [None,returnStarInt,'Chem_shift_isotope_effect_list.ID',True], # Pointer to '_Chem_shift_isotope_effect_list.ID'

                },

        'tagNames': ['Experiment_ID', 'Experiment_name', 'Sample_ID', 'Sample_label', 'Sample_state', 'Entry_ID', 'Chem_shift_isotope_effect_list_ID'],
        'sourcePrimaryKeys': ['Experiment_ID', 'Sample_ID', 'Sample_state', 'Entry_ID', 'Chem_shift_isotope_effect_list_ID'],

            },

      'Isotope_effect_software': {

        'tags': {

          'Software_ID': [None,returnStarInt,'Software.ID',True],                                             # Pointer to '_Software.ID'
          'Software_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Software.Sf_framecode',False],# Pointer to a saveframe of the category 'software'
          'Method_ID': [None,returnStarInt,'Method.ID',True],                                                 # Pointer to '_Method.ID'
          'Method_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Method.Sf_framecode',False],# Pointer to a saveframe of the category 'method'
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Chem_shift_isotope_effect_list_ID': [None,returnStarInt,'Chem_shift_isotope_effect_list.ID',True], # Pointer to '_Chem_shift_isotope_effect_list.ID'

                },

        'tagNames': ['Software_ID', 'Software_label', 'Method_ID', 'Method_label', 'Entry_ID', 'Chem_shift_isotope_effect_list_ID'],
        'sourcePrimaryKeys': ['Software_ID', 'Entry_ID', 'Chem_shift_isotope_effect_list_ID'],

            },

      'Isotope_effect': {

        'tags': {

          'ID': [None,returnStarInt,None,True],                                                               # Unique identifier for the observed isotope effect.
          'Assembly_atom_ID': [None,returnStarInt,'Atom.Assembly_atom_ID',False],                             # Pointer to '_Atom.Assembly_atom_ID'
          'Entity_assembly_ID': [None,returnStarInt,'Entity_assembly.ID',True],                               # Pointer to '_Entity_assembly.ID'
          'Entity_ID': [None,returnStarInt,'Entity.ID',True],                                                 # Pointer to '_Entity.ID'
          'Comp_index_ID': [None,returnStarInt,'Entity_comp_index.ID',True],                                  # Pointer to '_Entity_comp_index.ID'
          'Seq_ID': [None,returnStarInt,'Entity_poly_seq.Num',False],                                         # Pointer to '_Entity_poly_seq.Num'
          'Comp_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Chem_comp.ID',True],              # Pointer to '_Chem_comp.ID'
          'Atom_ID': [None,lambda x = value: returnStarAtCode(x,length = 12),'Chem_comp_atom.Atom_ID',True],  # Pointer to '_Chem_comp_atom.Atom_ID'
          'Atom_type': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                     # The value for this tag is a standard IUPAC abbreviation for an element (i.e.$ H$ C$ P$ etc).
          'Atom_isotope_number': [None,returnStarInt,None,False],                                             # The mass number for the chemical element defined by the tag '_Atom_type' or any of its related tags.
          'Label_sample_ID_1': [None,returnStarInt,'Sample.ID',True],                                         # Pointer to '_Sample.ID'
          'Label_pattern_ID_1': [None,returnStarInt,'Isotope_label_pattern.ID',False],                        # Pointer to '_Isotope_label_pattern.ID'
          'Label_1_ID_chem_shift_val': [None,returnStarFloat,None,False],                                     # Chemical shift value for the specified atom in the molecular assembly in a control isotopically labeled sample.
          'Label_1_ID_chem_shift_val_err': [None,returnStarFloat,None,False],                                 # Estimated error in the chemical shift value for the specified atom in the molecular assembly in a control isotopically labeled sample.
          'Label_sample_ID_2': [None,returnStarInt,'Sample.ID',True],                                         # Pointer to '_Sample.ID'
          'Label_pattern_ID_2': [None,returnStarInt,'Isotope_label_pattern.ID',False],                        # Pointer to '_Isotope_label_pattern.ID'
          'Label_2_ID_chem_shift_val': [None,returnStarFloat,None,False],                                     # Chemical shift value for the specified atom in the molecular assembly in the experimental isotopically labeled sample.
          'Label_2_ID_chem_shift_val_err': [None,returnStarFloat,None,False],                                 # Estimated error in the chemical shift value for the specified atom in the molecular assembly in a experimental isotopically labeled sample.
          'Chem_shift_val': [None,returnStarFloat,None,False],                                                # Observed chemical shift value for the defined atom in the molecular assembly.
          'Chem_shift_val_err': [None,returnStarFloat,None,False],                                            # Estimated error in the observed chemical shift value for the defined atom in the molecular assembly.
          'Resonance_ID_1': [None,returnStarInt,'Resonance.ID',False],                                        # Pointer to '_Resonance.ID'
          'Resonance_ID_2': [None,returnStarInt,'Resonance.ID',False],                                        # Pointer to '_Resonance.ID'
          'Auth_entity_assembly_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],       # An alternative identifier for Entity_assembly_ID that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Entity_assembly_ID.
          'Auth_seq_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                   # An alternative identifier for Seq_id that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Seq_ID or Comp_index_ID.
          'Auth_comp_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                  # An alternative identifier for Comp_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Auth_atom_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                  # An alternative identifier for Atom_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Chem_shift_isotope_effect_list_ID': [None,returnStarInt,'Chem_shift_isotope_effect_list.ID',True], # Pointer to '_Chem_shift_isotope_effect_list.ID'

                },

        'tagNames': ['ID', 'Assembly_atom_ID', 'Entity_assembly_ID', 'Entity_ID', 'Comp_index_ID', 'Seq_ID', 'Comp_ID', 'Atom_ID', 'Atom_type', 'Atom_isotope_number', 'Label_sample_ID_1', 'Label_pattern_ID_1', 'Label_1_ID_chem_shift_val', 'Label_1_ID_chem_shift_val_err', 'Label_sample_ID_2', 'Label_pattern_ID_2', 'Label_2_ID_chem_shift_val', 'Label_2_ID_chem_shift_val_err', 'Chem_shift_val', 'Chem_shift_val_err', 'Resonance_ID_1', 'Resonance_ID_2', 'Auth_entity_assembly_ID', 'Auth_seq_ID', 'Auth_comp_ID', 'Auth_atom_ID', 'Entry_ID', 'Chem_shift_isotope_effect_list_ID'],
        'sourcePrimaryKeys': ['ID', 'Entry_ID', 'Chem_shift_isotope_effect_list_ID'],

            },

      'Isotope_label_pattern': {

        'tags': {

          'ID': [None,returnStarInt,None,True],                                                               # Unique identifier for the defined isotope labeling pattern.
          'Assembly_atom_ID': [None,returnStarInt,'Atom.Assembly_atom_ID',False],                             # Pointer to '_Atom.Assembly_atom_ID'
          'Entity_assembly_ID': [None,returnStarInt,'Entity_assembly.ID',True],                               # Pointer to '_Entity_assembly.ID'
          'Entity_ID': [None,returnStarInt,'Entity.ID',True],                                                 # Pointer to '_Entity.ID'
          'Comp_index_ID': [None,returnStarInt,'Entity_comp_index.ID',True],                                  # Pointer to '_Entity_comp_index.ID'
          'Seq_ID': [None,returnStarInt,'Entity_poly_seq.Num',False],                                         # Pointer to '_Entity_poly_seq.Num'
          'Comp_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Chem_comp.ID',True],              # Pointer to '_Chem_comp.ID'
          'Atom_ID': [None,lambda x = value: returnStarAtCode(x,length = 12),'Chem_comp_atom.Atom_ID',True],  # Pointer to '_Chem_comp_atom.Atom_ID'
          'Atom_type': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                     # The value for this tag is a standard IUPAC abbreviation for an element (i.e.$ H$ C$ P$ etc).
          'Atom_isotope_number': [None,returnStarInt,None,False],                                             # The mass number for the chemical element defined by the tag '_Atom_type' or any of its related tags.
          'Auth_entity_assembly_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],       # An alternative identifier for Entity_assembly_ID that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Entity_assembly_ID.
          'Auth_seq_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                   # An alternative identifier for Seq_id that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Seq_ID or Comp_index_ID.
          'Auth_comp_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                  # An alternative identifier for Comp_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Auth_atom_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                  # An alternative identifier for Atom_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Chem_shift_isotope_effect_list_ID': [None,returnStarInt,'Chem_shift_isotope_effect_list.ID',True], # Pointer to '_Chem_shift_isotope_effect_list.ID'

                },

        'tagNames': ['ID', 'Assembly_atom_ID', 'Entity_assembly_ID', 'Entity_ID', 'Comp_index_ID', 'Seq_ID', 'Comp_ID', 'Atom_ID', 'Atom_type', 'Atom_isotope_number', 'Auth_entity_assembly_ID', 'Auth_seq_ID', 'Auth_comp_ID', 'Auth_atom_ID', 'Entry_ID', 'Chem_shift_isotope_effect_list_ID'],
        'sourcePrimaryKeys': ['ID', 'Entry_ID', 'Chem_shift_isotope_effect_list_ID'],

            }

        },

    'tableNames': ['Isotope_effect_experiment', 'Isotope_effect_software', 'Isotope_effect', 'Isotope_label_pattern']

    },

  'chem_shift_interaction_diff': {

    'name': 'Mol_interaction_chem_shift_diff',

    'tags': {

      'Sf_category': ['chem_shift_interaction_diff',lambda x = value: returnStarCode(x,length = 127),None,True],# Category definition for the information content of the saveframe
      'Sf_framecode': [None,lambda x = value: returnStarCode(x,length = 127),None,False],                     # A label for the saveframe that describes in very brief terms the information contained in the saveframe.
      'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                     # Pointer to '_Entry.ID'
      'ID': [None,returnStarInt,None,True],                                                                   # An integer value that uniquely identifies this saveframe of molecular interaction information from other saveframes of this category in an entry.
      'Data_file_name': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                   # The name of the file submitted with this depostion that contains the quantitative data for this saveframe.
      'Sample_condition_list_ID': [None,returnStarInt,'Sample_condition_list.ID',True],                       # Pointer to '_Sample_condition_list.ID'
      'Sample_condition_list_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Sample_condition_list.Sf_framecode',False],# Pointer to a saveframe of the category 'sample_conditions'
      'Chem_shift_ref_set_ID': [None,returnStarInt,'Chem_shift_reference.ID',True],                           # Pointer to '_Chem_shift_reference.ID'
      'Chem_shift_ref_set_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Chem_shift_reference.Sf_framecode',False],# Pointer to a saveframe of the category 'chemical_shift_reference.'  This is the saveframe where the chemical shift referencing standards are described.
      'Details': [None,returnStarString,None,False],                                                          # Text providing additional information regarding the set of molecular interaction data and their derivation.
      'Text_data_format': [None,lambda x = value: returnStarLine(x,length = 31),None,False],                  # The data format used to represent the chemical shift data for molecular interaction observations as ASCII text in the text block that is the value to the '_Mol_interaction_chem_shift_diff.Text_data' tag.
      'Text_data': [None,returnStarString,None,False],                                                        # A set of chemical shift data defining molecular interactions formatted as ASCII text.

            },

    'tagNames': ['Sf_category', 'Sf_framecode', 'Entry_ID', 'ID', 'Data_file_name', 'Sample_condition_list_ID', 'Sample_condition_list_label', 'Chem_shift_ref_set_ID', 'Chem_shift_ref_set_label', 'Details', 'Text_data_format', 'Text_data'],
    'sourcePrimaryKeys': ['Entry_ID', 'ID'],

    'tables': {

      'Mol_interaction_diff_experiment': {

        'tags': {

          'Experiment_ID': [None,returnStarInt,'Experiment.ID',True],                                         # Pointer to '_Experiment.ID'
          'Experiment_name': [None,lambda x = value: returnStarLine(x,length = 127),'Experiment.Name',False], # Pointer to a saveframe of the category 'NMR_spectrometer_expt'
          'Sample_ID': [None,returnStarInt,'Sample.ID',True],                                                 # Pointer to '_Sample.ID'
          'Sample_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Sample.Sf_framecode',False],# Pointer to a saveframe of the category 'sample'
          'Sample_state': [None,lambda x = value: returnStarLine(x,length = 31),None,True],                   # Physical state of the sample either anisotropic or isotropic.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Mol_interaction_chem_shift_diff_ID': [None,returnStarInt,'Mol_interaction_chem_shift_diff.ID',True],# Pointer to '_Mol_interaction_chem_shift_diff.ID'

                },

        'tagNames': ['Experiment_ID', 'Experiment_name', 'Sample_ID', 'Sample_label', 'Sample_state', 'Entry_ID', 'Mol_interaction_chem_shift_diff_ID'],
        'sourcePrimaryKeys': ['Experiment_ID', 'Sample_ID', 'Sample_state', 'Entry_ID', 'Mol_interaction_chem_shift_diff_ID'],

            },

      'Mol_interaction_diff_software': {

        'tags': {

          'Software_ID': [None,returnStarInt,'Software.ID',True],                                             # Pointer to '_Software.ID'
          'Software_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Software.Sf_framecode',False],# Pointer to a saveframe of the category 'software'
          'Method_ID': [None,returnStarInt,'Method.ID',True],                                                 # Pointer to '_Method.ID'
          'Method_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Method.Sf_framecode',False],# Pointer to a saveframe of the category 'method'
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Mol_interaction_chem_shift_diff_ID': [None,returnStarInt,'Mol_interaction_chem_shift_diff.ID',True],# Pointer to '_Mol_interaction_chem_shift_diff.ID'

                },

        'tagNames': ['Software_ID', 'Software_label', 'Method_ID', 'Method_label', 'Entry_ID', 'Mol_interaction_chem_shift_diff_ID'],
        'sourcePrimaryKeys': ['Software_ID', 'Entry_ID', 'Mol_interaction_chem_shift_diff_ID'],

            },

      'Mol_interaction_chem_shift': {

        'tags': {

          'ID': [None,returnStarInt,None,True],                                                               # Unique identifier for the observed chemical shift difference for a nuclei caused by the interaction between two members of the molecular assembly.
          'Assembly_atom_ID': [None,returnStarInt,'Atom.Assembly_atom_ID',False],                             # Pointer to '_Atom.Assembly_atom_ID'
          'Entity_assembly_ID': [None,returnStarInt,'Entity_assembly.ID',True],                               # Pointer to '_Entity_assembly.ID'
          'Entity_ID': [None,returnStarInt,'Entity.ID',True],                                                 # Pointer to '_Entity.ID'
          'Comp_index_ID': [None,returnStarInt,'Entity_comp_index.ID',True],                                  # Pointer to '_Entity_comp_index.ID'
          'Seq_ID': [None,returnStarInt,'Entity_poly_seq.Num',False],                                         # Pointer to '_Entity_poly_seq.Num'
          'Comp_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Chem_comp.ID',True],              # Pointer to '_Chem_comp.ID'
          'Atom_ID': [None,lambda x = value: returnStarAtCode(x,length = 12),'Chem_comp_atom.Atom_ID',True],  # Pointer to '_Chem_comp_atom.Atom_ID'
          'Atom_type': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                     # The value for this tag is a standard IUPAC abbreviation for an element (i.e.$ H$ C$ P$ etc).
          'Atom_isotope_number': [None,returnStarInt,None,False],                                             # The mass number for the chemical element defined by the tag '_Atom_type' or any of its related tags.
          'Chem_shift_val': [None,returnStarFloat,None,False],                                                # Chemical shift value for the atom when in the presence of the molecules that are interacting with it.
          'Chem_shift_val_err': [None,returnStarFloat,None,False],                                            # Estimated error in the chemical shift value.
          'Chem_shift_diff_val': [None,returnStarFloat,None,False],                                           # The difference between the chemical shift value for the atom in the free state of the molecule and in the state where it is interacting with one or more other molecules.
          'Chem_shift_diff_val_err': [None,returnStarFloat,None,False],                                       # Estimated error for the delta chemical shift value reported.
          'Resonance_ID': [None,returnStarInt,'Resonance.ID',False],                                          # Pointer to '_Resonance.ID'
          'Auth_entity_assembly_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],       # An alternative identifier for Entity_assembly_ID that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Entity_assembly_ID.
          'Auth_seq_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                   # An alternative identifier for Seq_id that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Seq_ID or Comp_index_ID.
          'Auth_comp_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                  # An alternative identifier for Comp_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Auth_atom_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                  # An alternative identifier for Atom_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Mol_interaction_chem_shift_diff_ID': [None,returnStarInt,'Mol_interaction_chem_shift_diff.ID',True],# Pointer to '_Mol_interaction_chem_shift_diff.ID'

                },

        'tagNames': ['ID', 'Assembly_atom_ID', 'Entity_assembly_ID', 'Entity_ID', 'Comp_index_ID', 'Seq_ID', 'Comp_ID', 'Atom_ID', 'Atom_type', 'Atom_isotope_number', 'Chem_shift_val', 'Chem_shift_val_err', 'Chem_shift_diff_val', 'Chem_shift_diff_val_err', 'Resonance_ID', 'Auth_entity_assembly_ID', 'Auth_seq_ID', 'Auth_comp_ID', 'Auth_atom_ID', 'Entry_ID', 'Mol_interaction_chem_shift_diff_ID'],
        'sourcePrimaryKeys': ['ID', 'Entry_ID', 'Mol_interaction_chem_shift_diff_ID'],

            }

        },

    'tableNames': ['Mol_interaction_diff_experiment', 'Mol_interaction_diff_software', 'Mol_interaction_chem_shift']

    },

  'chem_shift_anisotropy': {

    'name': 'Chem_shift_anisotropy',

    'tags': {

      'Sf_category': ['chem_shift_anisotropy',lambda x = value: returnStarCode(x,length = 127),None,True],    # Category definition for the information content of the saveframe
      'Sf_framecode': [None,lambda x = value: returnStarCode(x,length = 127),None,False],                     # A label for the saveframe that describes in very brief terms the information contained in the saveframe.
      'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                     # Pointer to '_Entry.ID'
      'ID': [None,returnStarInt,None,True],                                                                   # An integer value that uniquely identifies this saveframe of chemical shift anisotropy data from other saveframes of this category in an entry.
      'Data_file_name': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                   # The name of the file submitted with this depostion that contains the quantitative data for this saveframe.
      'Sample_condition_list_ID': [None,returnStarInt,'Sample_condition_list.ID',True],                       # Pointer to '_Sample_condition_list.ID'
      'Sample_condition_list_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Sample_condition_list.Sf_framecode',False],# Pointer to a saveframe of the category 'sample_conditions'
      'Spectrometer_frequency_1H': [None,returnStarFloat,None,False],                                         # NMR spectrometer operating frequency for protons.
      'Val_units': [None,lambda x = value: returnStarCode(x,length = 15),None,True],                          # Provide the units used for the chemical shift anisotropy values reported.
      'Details': [None,returnStarString,None,False],                                                          # Text describing the reported chemical shift anisotropy data.
      'Text_data_format': [None,lambda x = value: returnStarLine(x,length = 31),None,False],                  # The data format used to represent the chemical shift anisotropy data as ASCII text in the text block that is the value to the '_Chem_shift_anisotropy.Text_data' tag.
      'Text_data': [None,returnStarString,None,False],                                                        # A set of chemical shift anisotropy data formatted as ASCII text.

            },

    'tagNames': ['Sf_category', 'Sf_framecode', 'Entry_ID', 'ID', 'Data_file_name', 'Sample_condition_list_ID', 'Sample_condition_list_label', 'Spectrometer_frequency_1H', 'Val_units', 'Details', 'Text_data_format', 'Text_data'],
    'sourcePrimaryKeys': ['Entry_ID', 'ID'],

    'tables': {

      'CS_anisotropy_experiment': {

        'tags': {

          'Experiment_ID': [None,returnStarInt,'Experiment.ID',True],                                         # Pointer to '_Experiment.ID'
          'Experiment_name': [None,lambda x = value: returnStarLine(x,length = 127),'Experiment.Name',False], # Pointer to a saveframe of the category 'NMR_spectrometer_expt'
          'Sample_ID': [None,returnStarInt,'Sample.ID',True],                                                 # Pointer to '_Sample.ID'
          'Sample_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Sample.Sf_framecode',False],# Pointer to a saveframe of the category 'sample'
          'Sample_state': [None,lambda x = value: returnStarLine(x,length = 31),None,True],                   # Physical state of the sample either anisotropic or isotropic.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Chem_shift_anisotropy_ID': [None,returnStarInt,'Chem_shift_anisotropy.ID',True],                   # Pointer to '_Chem_shift_anisotropy.ID'

                },

        'tagNames': ['Experiment_ID', 'Experiment_name', 'Sample_ID', 'Sample_label', 'Sample_state', 'Entry_ID', 'Chem_shift_anisotropy_ID'],
        'sourcePrimaryKeys': ['Experiment_ID', 'Sample_ID', 'Sample_state', 'Entry_ID', 'Chem_shift_anisotropy_ID'],

            },

      'CS_anisotropy_software': {

        'tags': {

          'Software_ID': [None,returnStarInt,'Software.ID',True],                                             # Pointer to '_Software.ID'
          'Software_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Software.Sf_framecode',False],# Pointer to a saveframe of the category 'software'
          'Method_ID': [None,returnStarInt,'Method.ID',True],                                                 # Pointer to '_Method.ID'
          'Method_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Method.Sf_framecode',False],# Pointer to a saveframe of the category 'method'
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Chem_shift_anisotropy_ID': [None,returnStarInt,'Chem_shift_anisotropy.ID',True],                   # Pointer to '_Chem_shift_anisotropy.ID'

                },

        'tagNames': ['Software_ID', 'Software_label', 'Method_ID', 'Method_label', 'Entry_ID', 'Chem_shift_anisotropy_ID'],
        'sourcePrimaryKeys': ['Software_ID', 'Entry_ID', 'Chem_shift_anisotropy_ID'],

            },

      'CS_anisotropy': {

        'tags': {

          'ID': [None,returnStarInt,None,True],                                                               # Unique identifier for the observed chemical shift anisotropy.
          'Assembly_atom_ID': [None,returnStarInt,'Atom.Assembly_atom_ID',False],                             # Pointer to '_Atom.Assembly_atom_ID'
          'Entity_assembly_ID': [None,returnStarInt,'Entity_assembly.ID',True],                               # Pointer to '_Entity_assembly.ID'
          'Entity_ID': [None,returnStarInt,'Entity.ID',True],                                                 # Pointer to '_Entity.ID'
          'Comp_index_ID': [None,returnStarInt,'Entity_comp_index.ID',True],                                  # Pointer to '_Entity_comp_index.ID'
          'Seq_ID': [None,returnStarInt,'Entity_poly_seq.Num',True],                                          # Pointer to '_Entity_poly_seq.Num'
          'Comp_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Chem_comp.ID',True],              # Pointer to '_Chem_comp.ID'
          'Atom_ID': [None,lambda x = value: returnStarAtCode(x,length = 12),'Chem_comp_atom.Atom_ID',True],  # Pointer to '_Chem_comp_atom.Atom_ID'
          'Atom_type': [None,lambda x = value: returnStarCode(x,length = 15),None,True],                      # The value for this tag is a standard IUPAC abbreviation for an element (i.e.$ H$ C$ P$ etc).
          'Atom_isotope_number': [None,returnStarInt,None,False],                                             # The mass number for the chemical element defined by the tag '_Atom_type' or any of its related tags.
          'Val': [None,returnStarFloat,None,True],                                                            # Chemical shift anisotropy value
          'Val_err': [None,returnStarFloat,None,False],                                                       # Estimated error in the chemical shift anisotropy value
          'Principal_value_sigma_11_val': [None,returnStarFloat,None,False],                                  # Value for the first diagonal element for the principal matrix.
          'Principal_value_sigma_22_val': [None,returnStarFloat,None,False],                                  # Value for the second diagonal element for the principal matrix.
          'Principal_value_sigma_33_val': [None,returnStarFloat,None,False],                                  # Value for the third diagonal element for the principal matrix.
          'Principal_Euler_angle_alpha_val': [None,returnStarFloat,None,False],                               # Value for alpha Euler angle.
          'Principal_Euler_angle_beta_val': [None,returnStarFloat,None,False],                                # Value for the beta Euler angle.
          'Principal_Euler_angle_gamma_val': [None,returnStarFloat,None,False],                               # Value for the gamma Euler angle.
          'Bond_length': [None,returnStarFloat,None,False],                                                   # Value for the bond length
          'Resonance_ID': [None,returnStarInt,'Resonance.ID',False],                                          # Pointer to '_Resonance.ID'
          'Auth_entity_assembly_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],       # An alternative identifier for Entity_assembly_ID that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Entity_assembly_ID.
          'Auth_seq_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                   # An alternative identifier for Seq_id that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Seq_ID or Comp_index_ID.
          'Auth_comp_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                  # An alternative identifier for Comp_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Auth_atom_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                  # An alternative identifier for Atom_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Chem_shift_anisotropy_ID': [None,returnStarInt,'Chem_shift_anisotropy.ID',True],                   # Pointer to '_Chem_shift_anisotropy.ID'

                },

        'tagNames': ['ID', 'Assembly_atom_ID', 'Entity_assembly_ID', 'Entity_ID', 'Comp_index_ID', 'Seq_ID', 'Comp_ID', 'Atom_ID', 'Atom_type', 'Atom_isotope_number', 'Val', 'Val_err', 'Principal_value_sigma_11_val', 'Principal_value_sigma_22_val', 'Principal_value_sigma_33_val', 'Principal_Euler_angle_alpha_val', 'Principal_Euler_angle_beta_val', 'Principal_Euler_angle_gamma_val', 'Bond_length', 'Resonance_ID', 'Auth_entity_assembly_ID', 'Auth_seq_ID', 'Auth_comp_ID', 'Auth_atom_ID', 'Entry_ID', 'Chem_shift_anisotropy_ID'],
        'sourcePrimaryKeys': ['ID', 'Entry_ID', 'Chem_shift_anisotropy_ID'],

            }

        },

    'tableNames': ['CS_anisotropy_experiment', 'CS_anisotropy_software', 'CS_anisotropy']

    },

  'chem_shifts_calc_type': {

    'name': 'Chem_shifts_calc_type',

    'tags': {

      'Sf_category': ['chem_shifts_calc_type',lambda x = value: returnStarCode(x,length = 127),None,True],    # Category definition for the information content of the saveframe
      'Sf_framecode': [None,lambda x = value: returnStarCode(x,length = 127),None,False],                     # A label for the saveframe that describes in very brief terms the information contained in the saveframe.
      'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                     # Pointer to '_Entry.ID'
      'ID': [None,returnStarInt,None,True],                                                                   # Unique identifier for the type of theoretical chemical shift calculation that was carried out.
      'Calculation_level': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                # The level of theory applied in calculating theoretical chemical shifts or chemical shift tensors (not shielding tensors).
      'Quantum_mechanical_method': [None,lambda x = value: returnStarLine(x,length = 127),None,False],        # The method used to calculate the chemical shifts or chemical shift tensors (not shielding tensors).
      'Quantum_mechanical_theory_level': [None,lambda x = value: returnStarLine(x,length = 127),None,False],  # The quantum mechanical level of theory used to calculate the chemical shifts or chemical shift tensors (not shielding tensors).
      'Quantum_mechanical_basis_set': [None,lambda x = value: returnStarLine(x,length = 31),None,False],      # The quantum mechanical basis set used to calculate the theoretical chemical shifts or chemical shift tensors (not shielding tensors).
      'Chem_shift_nucleus': [None,lambda x = value: returnStarLine(x,length = 127),None,False],               # The nucleus for which the chemical shifts were calaculated.
      'Modeled_sample_cond_list_ID': [None,returnStarInt,'Sample_condition_list.ID',True],                    # Pointer to '_Sample_condition_list.ID'
      'Modeled_sample_cond_list_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Sample_condition_list.Sf_framecode',False],# Enter the name (label) given to a set of sample conditions enter above in the 'sample conditions' section of the deposition.
      'Chem_shift_reference_ID': [None,returnStarInt,'Chem_shift_reference.ID',True],                         # Pointer to '_Chem_shift_reference.ID'
      'Chem_shift_reference_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Chem_shift_reference.Sf_framecode',False],# Pointer to a saveframe of the category 'chemical_shift_reference.'  This is the saveframe where the chemical shift referencing standards are described.
      'Details': [None,returnStarString,None,False],                                                          # A text description of the type of calculation used to generate the theoretical chemical shifts.

            },

    'tagNames': ['Sf_category', 'Sf_framecode', 'Entry_ID', 'ID', 'Calculation_level', 'Quantum_mechanical_method', 'Quantum_mechanical_theory_level', 'Quantum_mechanical_basis_set', 'Chem_shift_nucleus', 'Modeled_sample_cond_list_ID', 'Modeled_sample_cond_list_label', 'Chem_shift_reference_ID', 'Chem_shift_reference_label', 'Details'],
    'sourcePrimaryKeys': ['Entry_ID', 'ID'],

    'tables': {

      'Chem_shifts_calc_software': {

        'tags': {

          'Software_ID': [None,returnStarInt,'Software.ID',True],                                             # Pointer to '_Software.ID'
          'Software_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Software.Sf_framecode',True],# Pointer to a saveframe of the category 'software'
          'Method_ID': [None,returnStarInt,'Method.ID',False],                                                # Pointer to '_Method.ID'
          'Method_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Method.Sf_framecode',False],# Pointer to a saveframe of the category 'method'
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Chem_shifts_calc_type_ID': [None,returnStarInt,'Chem_shifts_calc_type.ID',True],                   # Pointer to '_Chem_shifts_calc_type.ID'

                },

        'tagNames': ['Software_ID', 'Software_label', 'Method_ID', 'Method_label', 'Entry_ID', 'Chem_shifts_calc_type_ID'],
        'sourcePrimaryKeys': ['Software_ID', 'Entry_ID', 'Chem_shifts_calc_type_ID'],

            }

        },

    'tableNames': ['Chem_shifts_calc_software']

    },

  'theoretical_chem_shifts': {

    'name': 'Theoretical_chem_shift_list',

    'tags': {

      'Sf_category': ['theoretical_chem_shifts',lambda x = value: returnStarCode(x,length = 127),None,True],  # Category definition for the information content of the saveframe
      'Sf_framecode': [None,lambda x = value: returnStarCode(x,length = 127),None,False],                     # A label for the saveframe that describes in very brief terms the information contained in the saveframe.
      'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                     # Pointer to '_Entry.ID'
      'ID': [None,returnStarInt,None,True],                                                                   # An integer value that uniquely identifies this saveframe of theoretical chemical shift data from other saveframes of this category in an entry.
      'Data_file_name': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                   # Name of the file containing theoretical chemical shift data.
      'Chem_shifts_calc_type_ID': [None,returnStarInt,'Chem_shifts_calc_type.ID',True],                       # Pointer to '_Chem_shifts_calc_type.ID'
      'Chem_shifts_calc_type_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Chem_shifts_calc_type.Sf_framecode',False],# Pointer to the saveframe where the type of calculation carried out is described.
      'Model_atomic_coordinates_ID': [None,returnStarInt,'Representative_conformer.ID',True],                 # Pointer to '_Representative_conformer.ID'
      'Model_atomic_coordinates_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Representative_conformer.Sf_framecode',False],# Pointer to the saveframe where the atomic coordinates for the model used to calculate the theoretical chemical shifts are located.
      'Tensor_list_ID': [None,returnStarInt,'Tensor_list.ID',True],                                           # Pointer to '_Tensor_list.ID'
      'Tensor_list_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Tensor_list.Sf_framecode',False],# Pointer to a saveframe of category 'tensors.'  This is the label assigned by the depositor to the set of tensors.
      'Fermi_contact_spin_density_units': [None,lambda x = value: returnStarCode(x,length = 31),None,False],  # The units used for the Fermi contact spin density terms.
      'Chem_shift_1H_err': [None,returnStarFloat,None,False],                                                 # Calculated error in the theoretical chemical shifts reported for 1H.
      'Chem_shift_2H_err': [None,returnStarFloat,None,False],                                                 # Calculated error in the theoretical chemical shifts reported for 2H.
      'Chem_shift_13C_err': [None,returnStarFloat,None,False],                                                # Calculated error in the theoretical chemical shifts reported for 13C.
      'Chem_shift_15N_err': [None,returnStarFloat,None,False],                                                # Calculated error in the theoretical chemical shifts reported for 15N.
      'Chem_shift_19F_err': [None,returnStarFloat,None,False],                                                # Calculated error in the theoretical chemical shifts reported for 31P.
      'Chem_shift_31P_err': [None,returnStarFloat,None,False],                                                # Calculated error in the theoretical chemical shifts reported for 19F.
      'Details': [None,returnStarString,None,False],                                                          # Text describing the reported theoretical chemical shifts.
      'Text_data_format': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                 # The data format used to represent the theoretical chemical shift data as ASCII text in the text block that is the value to the '_Theoretical_chem_shift_list.Text_data' tag.
      'Text_data': [None,returnStarString,None,False],                                                        # A set of theoretical chemical shift data formatted as ASCII text.

            },

    'tagNames': ['Sf_category', 'Sf_framecode', 'Entry_ID', 'ID', 'Data_file_name', 'Chem_shifts_calc_type_ID', 'Chem_shifts_calc_type_label', 'Model_atomic_coordinates_ID', 'Model_atomic_coordinates_label', 'Tensor_list_ID', 'Tensor_list_label', 'Fermi_contact_spin_density_units', 'Chem_shift_1H_err', 'Chem_shift_2H_err', 'Chem_shift_13C_err', 'Chem_shift_15N_err', 'Chem_shift_19F_err', 'Chem_shift_31P_err', 'Details', 'Text_data_format', 'Text_data'],
    'sourcePrimaryKeys': ['Entry_ID', 'ID'],

    'tables': {

      'Theoretical_chem_shift': {

        'tags': {

          'ID': [None,returnStarInt,None,True],                                                               # Unique identifier for the calculated chemical shift value.
          'Assembly_atom_ID': [None,returnStarInt,'Atom.Assembly_atom_ID',False],                             # Pointer to '_Atom.Assembly_atom_ID'
          'Entity_assembly_ID': [None,returnStarInt,'Entity_assembly.ID',True],                               # Pointer to '_Entity_assembly.ID'
          'Entity_ID': [None,returnStarInt,'Entity.ID',True],                                                 # Pointer to '_Entity.ID'
          'Comp_index_ID': [None,returnStarInt,'Entity_comp_index.ID',True],                                  # Pointer to '_Entity_comp_index.ID'
          'Seq_ID': [None,returnStarInt,'Entity_poly_seq.Num',False],                                         # Pointer to '_Entity_poly_seq.Num'
          'Comp_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Chem_comp.ID',True],              # Pointer to '_Chem_comp.ID'
          'Atom_ID': [None,lambda x = value: returnStarAtCode(x,length = 12),'Chem_comp_atom.Atom_ID',True],  # Pointer to '_Chem_comp_atom.Atom_ID'
          'Atom_type': [None,lambda x = value: returnStarCode(x,length = 15),None,True],                      # The value for this tag is a standard IUPAC abbreviation for an element (i.e.$ H$ C$ P$ etc).
          'Atom_isotope_number': [None,returnStarInt,None,False],                                             # The mass number for the chemical element defined by the tag '_Atom_type' or any of its related tags.
          'Fermi_contact_spin_density': [None,returnStarFloat,None,False],                                    # Fermi contact spin density
          'Val': [None,returnStarFloat,None,True],                                                            # Chem shift val
          'Val_err': [None,returnStarFloat,None,False],                                                       # Chem shift val err
          'Auth_entity_assembly_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],       # An alternative identifier for Entity_assembly_ID that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Entity_assembly_ID.
          'Auth_seq_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                   # An alternative identifier for Seq_id that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Seq_ID or Comp_index_ID.
          'Auth_comp_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                  # An alternative identifier for Comp_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Auth_atom_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                  # An alternative identifier for Atom_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Theoretical_chem_shift_list_ID': [None,returnStarInt,'Theoretical_chem_shift_list.ID',True],       # Pointer to '_Theoretical_chem_shift_list.ID'

                },

        'tagNames': ['ID', 'Assembly_atom_ID', 'Entity_assembly_ID', 'Entity_ID', 'Comp_index_ID', 'Seq_ID', 'Comp_ID', 'Atom_ID', 'Atom_type', 'Atom_isotope_number', 'Fermi_contact_spin_density', 'Val', 'Val_err', 'Auth_entity_assembly_ID', 'Auth_seq_ID', 'Auth_comp_ID', 'Auth_atom_ID', 'Entry_ID', 'Theoretical_chem_shift_list_ID'],
        'sourcePrimaryKeys': ['ID', 'Entry_ID', 'Theoretical_chem_shift_list_ID'],

            }

        },

    'tableNames': ['Theoretical_chem_shift']

    },

  'RDCs': {

    'name': 'RDC_list',

    'tags': {

      'Sf_category': ['RDCs',lambda x = value: returnStarCode(x,length = 127),None,True],                     # Category definition for the information content of the saveframe
      'Sf_framecode': [None,lambda x = value: returnStarCode(x,length = 127),None,False],                     # A label for the saveframe that describes in very brief terms the information contained in the saveframe.
      'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                     # Pointer to '_Entry.ID'
      'ID': [None,returnStarInt,None,True],                                                                   # Unique identifier for the list of observed residual dipolar couplings.
      'Data_file_name': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                   # The name of the file submitted with this depostion that contains the quantitative data for this saveframe.
      'Sample_condition_list_ID': [None,returnStarInt,'Sample_condition_list.ID',True],                       # Pointer to '_Sample_condition_list.ID'
      'Sample_condition_list_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Sample_condition_list.Sf_framecode',True],# The label for the set of experimental sample conditions used to collect the data for determination of the residual dipolar coupling values.
      'Spectrometer_frequency_1H': [None,returnStarFloat,None,True],                                          # The operating proton frequency in MHz of the NMR spectrometer used to collect the data.
      'Bond_length_usage_flag': [None,lambda x = value: returnStarCode(x,length = 3),None,False],             # A flag indicating whether unique residue bond length values were used in calculating the RDC constraints.
      'Dipolar_constraint_calib_method': [None,lambda x = value: returnStarLine(x,length = 127),None,False],  # Method used to calibrate the values for the residual dipolar coupling constraints.
      'Mol_align_tensor_axial_sym_mol': [None,returnStarFloat,None,False],                                    # The residual dipolar coupling provides geometric information relative to a common alignment frame. The value for the item Mol_align_tensor_axial_sym_mol is the axial symmetric component of the alignment tensor (1/3(Azz-(Axx+Ayy)/2).
      'Mol_align_tensor_rhombic_mol': [None,returnStarFloat,None,False],                                      # The residual dipolar coupling provides geometric information relative to a common alignment frame. The value for the item Mol_align_tensor_rhombic_mol is the rhombic component of the alignment tensor (1/3(Axx-Ayy)).
      'General_order_param_int_motions': [None,returnStarFloat,None,False],                                   # The residual dipolar coupling provides geometric information relative to a common alignment frame. The value for the item General_order_param_int_motions is S$ the local order parameter for internal motions.
      'Assumed_H_N_bond_length': [None,returnStarFloat,None,False],                                           # Length assumed for the H-N bond length.
      'Assumed_H_C_bond_length': [None,returnStarFloat,None,False],                                           # Length assumed for the H-C bond length.
      'Assumed_C_N_bond_length': [None,returnStarFloat,None,False],                                           # Length assumed for the C-N bond length.
      'Details': [None,returnStarString,None,False],                                                          # Additional information regarding the RDC data set can be entered in this field.
      'Text_data_format': [None,lambda x = value: returnStarLine(x,length = 31),None,False],                  # The data format used to represent the residual dipolar coupling data as ASCII text in the text block that is the value to the '_RDC_list.Text_data' tag.
      'Text_data': [None,returnStarString,None,False],                                                        # A set of theoretical chemical shift data formatted as ASCII text.

            },

    'tagNames': ['Sf_category', 'Sf_framecode', 'Entry_ID', 'ID', 'Data_file_name', 'Sample_condition_list_ID', 'Sample_condition_list_label', 'Spectrometer_frequency_1H', 'Bond_length_usage_flag', 'Dipolar_constraint_calib_method', 'Mol_align_tensor_axial_sym_mol', 'Mol_align_tensor_rhombic_mol', 'General_order_param_int_motions', 'Assumed_H_N_bond_length', 'Assumed_H_C_bond_length', 'Assumed_C_N_bond_length', 'Details', 'Text_data_format', 'Text_data'],
    'sourcePrimaryKeys': ['Entry_ID', 'ID'],

    'tables': {

      'RDC_experiment': {

        'tags': {

          'Experiment_ID': [None,returnStarInt,'Experiment.ID',True],                                         # Pointer to '_Experiment.ID'
          'Experiment_name': [None,lambda x = value: returnStarLine(x,length = 127),'Experiment.Name',False], # Pointer to a saveframe of the category 'NMR_spectrometer_expt'
          'Sample_ID': [None,returnStarInt,'Sample.ID',True],                                                 # Pointer to '_Sample.ID'
          'Sample_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Sample.Sf_framecode',True],# Pointer to a saveframe of the category 'sample'
          'Sample_state': [None,lambda x = value: returnStarLine(x,length = 31),None,True],                   # Physical state of the sample either anisotropic or isotropic.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'RDC_list_ID': [None,returnStarInt,'RDC_list.ID',True],                                             # Pointer to '_RDC_list.ID'

                },

        'tagNames': ['Experiment_ID', 'Experiment_name', 'Sample_ID', 'Sample_label', 'Sample_state', 'Entry_ID', 'RDC_list_ID'],
        'sourcePrimaryKeys': ['Experiment_ID', 'Sample_ID', 'Sample_state', 'Entry_ID', 'RDC_list_ID'],

            },

      'RDC_software': {

        'tags': {

          'Software_ID': [None,returnStarInt,'Software.ID',True],                                             # Pointer to '_Software.ID'
          'Software_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Software.Sf_framecode',True],# Pointer to a saveframe of the category 'software'
          'Method_ID': [None,returnStarInt,'Method.ID',False],                                                # Pointer to '_Method.ID'
          'Method_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Method.Sf_framecode',False],# Pointer to a saveframe of the category 'method'
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'RDC_list_ID': [None,returnStarInt,'RDC_list.ID',True],                                             # Pointer to '_RDC_list.ID'

                },

        'tagNames': ['Software_ID', 'Software_label', 'Method_ID', 'Method_label', 'Entry_ID', 'RDC_list_ID'],
        'sourcePrimaryKeys': ['Software_ID', 'Entry_ID', 'RDC_list_ID'],

            },

      'RDC': {

        'tags': {

          'ID': [None,returnStarInt,None,True],                                                               # Unique identifier for the observed residual dipolar coupling.
          'RDC_code': [None,lambda x = value: returnStarCode(x,length = 15),None,True],                       # A community standard code used to describe the type of observed residual dipolar coupling.
          'Assembly_atom_ID_1': [None,returnStarInt,'Atom.Assembly_atom_ID',False],                           # Pointer to '_Atom.Assembly_atom_ID'
          'Entity_assembly_ID_1': [None,returnStarInt,'Entity_assembly.ID',True],                             # Pointer to '_Entity_assembly.ID'
          'Entity_ID_1': [None,returnStarInt,'Entity.ID',True],                                               # Pointer to '_Entity.ID'
          'Comp_index_ID_1': [None,returnStarInt,'Entity_comp_index.ID',True],                                # Pointer to '_Entity_comp_index.ID'
          'Seq_ID_1': [None,returnStarInt,'Entity_poly_seq.Num',True],                                        # Pointer to '_Entity_poly_seq.Num'
          'Comp_ID_1': [None,lambda x = value: returnStarCode(x,length = 12),'Chem_comp.ID',True],            # Pointer to '_Chem_comp.ID'
          'Atom_ID_1': [None,lambda x = value: returnStarAtCode(x,length = 12),'Chem_comp_atom.Atom_ID',True],# Pointer to '_Chem_comp_atom.Atom_ID'
          'Atom_type_1': [None,lambda x = value: returnStarCode(x,length = 15),None,True],                    # Standard symbol used to define the atom element type.
          'Atom_isotope_number_1': [None,returnStarInt,None,False],                                           # The mass number for the chemical element defined by the tag '_Atom_type' or any of its related tags.
          'Ambiguity_code_1': [None,lambda x = value: returnStarCode(x,length = 3),None,False],               # A code indicating ambiguity that may exist in the assignment of the atom to the residual dipolar coupling constant.
          'Assembly_atom_ID_2': [None,returnStarInt,'Atom.Assembly_atom_ID',False],                           # Pointer to '_Atom.Assembly_atom_ID'
          'Entity_assembly_ID_2': [None,returnStarInt,'Entity_assembly.ID',True],                             # Pointer to '_Entity_assembly.ID'
          'Entity_ID_2': [None,returnStarInt,'Entity.ID',True],                                               # Pointer to '_Entity.ID'
          'Comp_index_ID_2': [None,returnStarInt,'Entity_comp_index.ID',True],                                # Pointer to '_Entity_comp_index.ID'
          'Seq_ID_2': [None,returnStarInt,'Entity_poly_seq.Num',True],                                        # Pointer to '_Entity_poly_seq.Num'
          'Comp_ID_2': [None,lambda x = value: returnStarCode(x,length = 12),'Chem_comp.ID',True],            # Pointer to '_Chem_comp.ID'
          'Atom_ID_2': [None,lambda x = value: returnStarAtCode(x,length = 12),'Chem_comp_atom.Atom_ID',True],# Pointer to '_Chem_comp_atom.Atom_ID'
          'Atom_type_2': [None,lambda x = value: returnStarCode(x,length = 15),None,True],                    # Standard symbol used to define the atom element type.
          'Atom_isotope_number_2': [None,returnStarInt,None,False],                                           # The mass number for the chemical element defined by the tag '_Atom_type' or any of its related tags.
          'Ambiguity_code_2': [None,lambda x = value: returnStarCode(x,length = 3),None,False],               # A code indicating ambiguity that may exist in the assignment of the atom to the residual dipolar coupling constant.
          'Val': [None,returnStarFloat,None,False],                                                           # A residual dipolar coupling value.
          'Val_min': [None,returnStarFloat,None,False],                                                       # For a residual dipolar coupling that cannot be assigned a specific value$ the minimum estimated value.
          'Val_max': [None,returnStarFloat,None,False],                                                       # For a residual dipolar coupling that cannot be assigned a specific value$ the maximum estimated value.
          'Val_err': [None,returnStarFloat,None,False],                                                       # The estimated or measured error in the residual dipolar coupling value.
          'Val_bond_length': [None,returnStarFloat,None,False],                                               # Bond length value used in calculating the RDC constraint value.
          'Resonance_ID_1': [None,returnStarInt,'Resonance.ID',False],                                        # Pointer to '_Resonance.ID'
          'Resonance_ID_2': [None,returnStarInt,'Resonance.ID',False],                                        # Pointer to '_Resonance.ID'
          'Auth_entity_assembly_ID_1': [None,lambda x = value: returnStarCode(x,length = 15),None,False],     # An alternative identifier for Entity_assembly_ID that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Entity_assembly_ID.
          'Auth_seq_ID_1': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                 # An alternative identifier for Seq_id that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Seq_ID or Comp_index_ID.
          'Auth_comp_ID_1': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                # An alternative identifier for Comp_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Auth_atom_ID_1': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                # An alternative identifier for Atom_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Auth_entity_assembly_ID_2': [None,lambda x = value: returnStarCode(x,length = 15),None,False],     # An alternative identifier for Entity_assembly_ID that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Entity_assembly_ID.
          'Auth_seq_ID_2': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                 # An alternative identifier for Seq_id that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Seq_ID or Comp_index_ID.
          'Auth_comp_ID_2': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                # An alternative identifier for Comp_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Auth_atom_ID_2': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                # An alternative identifier for Atom_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'RDC_list_ID': [None,returnStarInt,'RDC_list.ID',True],                                             # Pointer to '_RDC_list.ID'

                },

        'tagNames': ['ID', 'RDC_code', 'Assembly_atom_ID_1', 'Entity_assembly_ID_1', 'Entity_ID_1', 'Comp_index_ID_1', 'Seq_ID_1', 'Comp_ID_1', 'Atom_ID_1', 'Atom_type_1', 'Atom_isotope_number_1', 'Ambiguity_code_1', 'Assembly_atom_ID_2', 'Entity_assembly_ID_2', 'Entity_ID_2', 'Comp_index_ID_2', 'Seq_ID_2', 'Comp_ID_2', 'Atom_ID_2', 'Atom_type_2', 'Atom_isotope_number_2', 'Ambiguity_code_2', 'Val', 'Val_min', 'Val_max', 'Val_err', 'Val_bond_length', 'Resonance_ID_1', 'Resonance_ID_2', 'Auth_entity_assembly_ID_1', 'Auth_seq_ID_1', 'Auth_comp_ID_1', 'Auth_atom_ID_1', 'Auth_entity_assembly_ID_2', 'Auth_seq_ID_2', 'Auth_comp_ID_2', 'Auth_atom_ID_2', 'Entry_ID', 'RDC_list_ID'],
        'sourcePrimaryKeys': ['ID', 'Entry_ID', 'RDC_list_ID'],

            }

        },

    'tableNames': ['RDC_experiment', 'RDC_software', 'RDC']

    },

  'dipolar_couplings': {

    'name': 'Dipolar_coupling_list',

    'tags': {

      'Sf_category': ['dipolar_couplings',lambda x = value: returnStarCode(x,length = 127),None,True],        # Category definition for the information content of the saveframe
      'Sf_framecode': [None,lambda x = value: returnStarCode(x,length = 127),None,False],                     # A label for the saveframe that describes in very brief terms the information contained in the saveframe.
      'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                     # Pointer to '_Entry.ID'
      'ID': [None,returnStarInt,None,True],                                                                   # Unique identifier for the list of observed residual dipolar couplings.
      'Data_file_name': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                   # The name of the file submitted with this depostion that contains the quantitative data for this saveframe.
      'Sample_condition_list_ID': [None,returnStarInt,'Sample_condition_list.ID',True],                       # Pointer to '_Sample_condition_list.ID'
      'Sample_condition_list_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Sample_condition_list.Sf_framecode',True],# The label for the set of experimental sample conditions used to collect the data for determination of the residual dipolar coupling values.
      'Spectrometer_frequency_1H': [None,returnStarFloat,None,True],                                          # The operating proton frequency in MHz of the NMR spectrometer used to collect the data.
      'Scaling_factor': [None,returnStarFloat,None,False],                                                    # Scaling factor used in deriving the dipolar coupling values.
      'Fitting_procedure': [None,returnStarString,None,False],                                                # Procedure used to fit the data in deriving the dipolar coupling values.
      'Details': [None,returnStarString,None,False],                                                          # Additional information regarding the Dipolar coupling data set can be entered in this field.
      'Text_data_format': [None,lambda x = value: returnStarLine(x,length = 31),None,False],                  # The data format used to represent the dipolar coupling data as ASCII text in the text block that is the value to the '_Dipolar_coupling.Text_data' tag.
      'Text_data': [None,returnStarString,None,False],                                                        # A set of dipolar coupling data formatted as ASCII text.

            },

    'tagNames': ['Sf_category', 'Sf_framecode', 'Entry_ID', 'ID', 'Data_file_name', 'Sample_condition_list_ID', 'Sample_condition_list_label', 'Spectrometer_frequency_1H', 'Scaling_factor', 'Fitting_procedure', 'Details', 'Text_data_format', 'Text_data'],
    'sourcePrimaryKeys': ['Entry_ID', 'ID'],

    'tables': {

      'Dipolar_coupling_experiment': {

        'tags': {

          'Experiment_ID': [None,returnStarInt,'Experiment.ID',True],                                         # Pointer to '_Experiment.ID'
          'Experiment_name': [None,lambda x = value: returnStarLine(x,length = 127),'Experiment.Name',False], # Pointer to a saveframe of the category 'NMR_spectrometer_expt'
          'Sample_ID': [None,returnStarInt,'Sample.ID',True],                                                 # Pointer to '_Sample.ID'
          'Sample_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Sample.Sf_framecode',True],# Pointer to a saveframe of the category 'sample'
          'Sample_state': [None,lambda x = value: returnStarLine(x,length = 31),None,True],                   # Physical state of the sample either anisotropic or isotropic.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Dipolar_coupling_list_ID': [None,returnStarInt,'Dipolar_coupling_list.ID',True],                   # Pointer to '_Dipolar_coupling_list.ID'

                },

        'tagNames': ['Experiment_ID', 'Experiment_name', 'Sample_ID', 'Sample_label', 'Sample_state', 'Entry_ID', 'Dipolar_coupling_list_ID'],
        'sourcePrimaryKeys': ['Experiment_ID', 'Sample_ID', 'Sample_state', 'Entry_ID', 'Dipolar_coupling_list_ID'],

            },

      'Dipolar_coupling_software': {

        'tags': {

          'Software_ID': [None,returnStarInt,'Software.ID',True],                                             # Pointer to '_Software.ID'
          'Software_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Software.Sf_framecode',True],# Pointer to a saveframe of the category 'software'
          'Method_ID': [None,returnStarInt,'Method.ID',False],                                                # Pointer to '_Method.ID'
          'Method_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Method.Sf_framecode',False],# Pointer to a saveframe of the category 'method'
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Dipolar_coupling_list_ID': [None,returnStarInt,'Dipolar_coupling_list.ID',True],                   # Pointer to '_Dipolar_coupling_list.ID'

                },

        'tagNames': ['Software_ID', 'Software_label', 'Method_ID', 'Method_label', 'Entry_ID', 'Dipolar_coupling_list_ID'],
        'sourcePrimaryKeys': ['Software_ID', 'Entry_ID', 'Dipolar_coupling_list_ID'],

            },

      'Dipolar_coupling': {

        'tags': {

          'ID': [None,returnStarInt,None,True],                                                               # Unique identifier for the observed residual dipolar coupling.
          'Dipolar_coupling_code': [None,lambda x = value: returnStarCode(x,length = 15),None,True],          # A community standard code used to describe the type of observed residual dipolar coupling.
          'Assembly_atom_ID_1': [None,returnStarInt,'Atom.Assembly_atom_ID',False],                           # Pointer to '_Atom.Assembly_atom_ID'
          'Entity_assembly_ID_1': [None,returnStarInt,'Entity_assembly.ID',True],                             # Pointer to '_Entity_assembly.ID'
          'Entity_ID_1': [None,returnStarInt,'Entity.ID',True],                                               # Pointer to '_Entity.ID'
          'Comp_index_ID_1': [None,returnStarInt,'Entity_comp_index.ID',True],                                # Pointer to '_Entity_comp_index.ID'
          'Seq_ID_1': [None,returnStarInt,'Entity_poly_seq.Num',True],                                        # Pointer to '_Entity_poly_seq.Num'
          'Comp_ID_1': [None,lambda x = value: returnStarCode(x,length = 12),'Chem_comp.ID',True],            # Pointer to '_Chem_comp.ID'
          'Atom_ID_1': [None,lambda x = value: returnStarAtCode(x,length = 12),'Chem_comp_atom.Atom_ID',True],# Pointer to '_Chem_comp_atom.Atom_ID'
          'Atom_type_1': [None,lambda x = value: returnStarCode(x,length = 15),None,True],                    # Standard symbol used to define the atom element type.
          'Atom_isotope_number_1': [None,returnStarInt,None,False],                                           # The mass number for the chemical element defined by the tag '_Atom_type' or any of its related tags.
          'Ambiguity_code_1': [None,lambda x = value: returnStarCode(x,length = 3),None,False],               # A code indicating ambiguity that may exist in the assignment of the atom to the dipolar coupling constant.
          'Assembly_atom_ID_2': [None,returnStarInt,'Atom.Assembly_atom_ID',False],                           # Pointer to '_Atom.Assembly_atom_ID'
          'Entity_assembly_ID_2': [None,returnStarInt,'Entity_assembly.ID',True],                             # Pointer to '_Entity_assembly.ID'
          'Entity_ID_2': [None,returnStarInt,'Entity.ID',True],                                               # Pointer to '_Entity.ID'
          'Comp_index_ID_2': [None,returnStarInt,'Entity_comp_index.ID',True],                                # Pointer to '_Entity_comp_index.ID'
          'Seq_ID_2': [None,returnStarInt,'Entity_poly_seq.Num',True],                                        # Pointer to '_Entity_poly_seq.Num'
          'Comp_ID_2': [None,lambda x = value: returnStarCode(x,length = 12),'Chem_comp.ID',True],            # Pointer to '_Chem_comp.ID'
          'Atom_ID_2': [None,lambda x = value: returnStarAtCode(x,length = 12),'Chem_comp_atom.Atom_ID',True],# Pointer to '_Chem_comp_atom.Atom_ID'
          'Atom_type_2': [None,lambda x = value: returnStarCode(x,length = 15),None,True],                    # Standard symbol used to define the atom element type.
          'Atom_isotope_number_2': [None,returnStarInt,None,False],                                           # The mass number for the chemical element defined by the tag '_Atom_type' or any of its related tags.
          'Ambiguity_code_2': [None,lambda x = value: returnStarCode(x,length = 3),None,False],               # A code indicating ambiguity that may exist in the assignment of the atom to the dipolar coupling constant.
          'Val': [None,returnStarFloat,None,False],                                                           # Dipolar coupling value
          'Val_min': [None,returnStarFloat,None,False],                                                       # Estimated minimum value for the dipolar coupling when a specific value cannot be obtained.
          'Val_max': [None,returnStarFloat,None,False],                                                       # Estimated maximum value for the dipolar coupling constant when a specific value cannot be obtained.
          'Val_err': [None,returnStarFloat,None,False],                                                       # Estimated error in the dipolar coupling value
          'Principal_Euler_angle_alpha_val': [None,returnStarFloat,None,False],                               # Value for the principal Euler angle alpha.
          'Principal_Euler_angle_beta_val': [None,returnStarFloat,None,False],                                # Value for the principal Euler angle beta.
          'Principal_Euler_angle_gamma_val': [None,returnStarFloat,None,False],                               # Value for the principal Euler angle gamma.
          'Resonance_ID_1': [None,returnStarInt,'Resonance.ID',False],                                        # Pointer to '_Resonance.ID'
          'Resonance_ID_2': [None,returnStarInt,'Resonance.ID',False],                                        # Pointer to '_Resonance.ID'
          'Auth_entity_assembly_ID_1': [None,lambda x = value: returnStarCode(x,length = 15),None,False],     # An alternative identifier for Entity_assembly_ID that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Entity_assembly_ID.
          'Auth_seq_ID_1': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                 # An alternative identifier for Seq_id that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Seq_ID or Comp_index_ID.
          'Auth_comp_ID_1': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                # An alternative identifier for Comp_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Auth_atom_ID_1': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                # An alternative identifier for Atom_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Auth_entity_assembly_ID_2': [None,lambda x = value: returnStarCode(x,length = 15),None,False],     # An alternative identifier for Entity_assembly_ID that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Entity_assembly_ID.
          'Auth_seq_ID_2': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                 # An alternative identifier for Seq_id that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Seq_ID or Comp_index_ID.
          'Auth_comp_ID_2': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                # An alternative identifier for Comp_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Auth_atom_ID_2': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                # An alternative identifier for Atom_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Dipolar_coupling_list_ID': [None,returnStarInt,'Dipolar_coupling_list.ID',True],                   # Pointer to '_Dipolar_coupling_list.ID'

                },

        'tagNames': ['ID', 'Dipolar_coupling_code', 'Assembly_atom_ID_1', 'Entity_assembly_ID_1', 'Entity_ID_1', 'Comp_index_ID_1', 'Seq_ID_1', 'Comp_ID_1', 'Atom_ID_1', 'Atom_type_1', 'Atom_isotope_number_1', 'Ambiguity_code_1', 'Assembly_atom_ID_2', 'Entity_assembly_ID_2', 'Entity_ID_2', 'Comp_index_ID_2', 'Seq_ID_2', 'Comp_ID_2', 'Atom_ID_2', 'Atom_type_2', 'Atom_isotope_number_2', 'Ambiguity_code_2', 'Val', 'Val_min', 'Val_max', 'Val_err', 'Principal_Euler_angle_alpha_val', 'Principal_Euler_angle_beta_val', 'Principal_Euler_angle_gamma_val', 'Resonance_ID_1', 'Resonance_ID_2', 'Auth_entity_assembly_ID_1', 'Auth_seq_ID_1', 'Auth_comp_ID_1', 'Auth_atom_ID_1', 'Auth_entity_assembly_ID_2', 'Auth_seq_ID_2', 'Auth_comp_ID_2', 'Auth_atom_ID_2', 'Entry_ID', 'Dipolar_coupling_list_ID'],
        'sourcePrimaryKeys': ['ID', 'Entry_ID', 'Dipolar_coupling_list_ID'],

            }

        },

    'tableNames': ['Dipolar_coupling_experiment', 'Dipolar_coupling_software', 'Dipolar_coupling']

    },

  'spectral_density_values': {

    'name': 'Spectral_density_list',

    'tags': {

      'Sf_category': ['spectral_density_values',lambda x = value: returnStarCode(x,length = 127),None,True],  # Category definition for the information content of the saveframe
      'Sf_framecode': [None,lambda x = value: returnStarCode(x,length = 127),None,False],                     # A label for the saveframe that describes in very brief terms the information contained in the saveframe.
      'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                     # Pointer to '_Entry.ID'
      'ID': [None,returnStarInt,None,True],                                                                   # An integer value that uniquely identifies this saveframe of spectral density data from other saveframes of this category in an entry.
      'Data_file_name': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                   # The name of the file submitted with this depostion that contains the quantitative data for this saveframe.
      'Sample_condition_list_ID': [None,returnStarInt,'Sample_condition_list.ID',True],                       # Pointer to '_Sample_condition_list.ID'
      'Sample_condition_list_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Sample_condition_list.Sf_framecode',True],# The label for the set of experimental sample conditions used to collect the data for determination of the spectral density values.
      'Details': [None,returnStarString,None,False],                                                          # Text describing the reported spectral density values.
      'Text_data_format': [None,lambda x = value: returnStarLine(x,length = 31),None,False],                  # The data format used to represent the spectral density data as ASCII text in the text block that is the value to the '_Spectral_density_list.Text_data' tag.
      'Text_data': [None,returnStarString,None,False],                                                        # A set of spectral density data formatted as ASCII text.

            },

    'tagNames': ['Sf_category', 'Sf_framecode', 'Entry_ID', 'ID', 'Data_file_name', 'Sample_condition_list_ID', 'Sample_condition_list_label', 'Details', 'Text_data_format', 'Text_data'],
    'sourcePrimaryKeys': ['Entry_ID', 'ID'],

    'tables': {

      'Spectral_density_experiment': {

        'tags': {

          'Experiment_ID': [None,returnStarInt,'Experiment.ID',True],                                         # Pointer to '_Experiment.ID'
          'Experiment_name': [None,lambda x = value: returnStarLine(x,length = 127),'Experiment.Name',False], # Pointer to a saveframe of the category 'NMR_spectrometer_expt'
          'Sample_ID': [None,returnStarInt,'Sample.ID',True],                                                 # Pointer to '_Sample.ID'
          'Sample_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Sample.Sf_framecode',True],# Pointer to a saveframe of the category 'sample'
          'Sample_state': [None,lambda x = value: returnStarLine(x,length = 31),None,True],                   # Physical state of the sample either anisotropic or isotropic.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Spectral_density_list_ID': [None,returnStarInt,'Spectral_density_list.ID',True],                   # Pointer to '_Spectral_density_list.ID'

                },

        'tagNames': ['Experiment_ID', 'Experiment_name', 'Sample_ID', 'Sample_label', 'Sample_state', 'Entry_ID', 'Spectral_density_list_ID'],
        'sourcePrimaryKeys': ['Experiment_ID', 'Sample_ID', 'Sample_state', 'Entry_ID', 'Spectral_density_list_ID'],

            },

      'Spectral_density_software': {

        'tags': {

          'Software_ID': [None,returnStarInt,'Software.ID',True],                                             # Pointer to '_Software.ID'
          'Software_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Software.Sf_framecode',False],# Pointer to a saveframe of the category 'software'
          'Method_ID': [None,returnStarInt,'Method.ID',True],                                                 # Pointer to '_Method.ID'
          'Method_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Method.Sf_framecode',False],# Pointer to a saveframe of the category 'method'
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Spectral_density_list_ID': [None,returnStarInt,'Spectral_density_list.ID',True],                   # Pointer to '_Spectral_density_list.ID'

                },

        'tagNames': ['Software_ID', 'Software_label', 'Method_ID', 'Method_label', 'Entry_ID', 'Spectral_density_list_ID'],
        'sourcePrimaryKeys': ['Software_ID', 'Entry_ID', 'Spectral_density_list_ID'],

            },

      'Spectral_density': {

        'tags': {

          'ID': [None,returnStarInt,None,True],                                                               # Spectral density ID
          'Assembly_atom_ID': [None,returnStarInt,'Atom.Assembly_atom_ID',False],                             # Pointer to '_Atom.Assembly_atom_ID'
          'Entity_assembly_ID': [None,returnStarInt,'Entity_assembly.ID',True],                               # Pointer to '_Entity_assembly.ID'
          'Entity_ID': [None,returnStarInt,'Entity.ID',True],                                                 # Pointer to '_Entity.ID'
          'Comp_index_ID': [None,returnStarInt,'Entity_comp_index.ID',True],                                  # Pointer to '_Entity_comp_index.ID'
          'Seq_ID': [None,returnStarInt,'Entity_poly_seq.Num',True],                                          # Pointer to '_Entity_poly_seq.Num'
          'Comp_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Chem_comp.ID',True],              # Pointer to '_Chem_comp.ID'
          'Atom_ID': [None,lambda x = value: returnStarAtCode(x,length = 12),'Chem_comp_atom.Atom_ID',True],  # Pointer to '_Chem_comp_atom.Atom_ID'
          'Atom_type': [None,lambda x = value: returnStarCode(x,length = 15),None,True],                      # The value for this tag is a standard IUPAC abbreviation for an element (i.e.$ H$ C$ P$ etc).
          'Atom_isotope_number': [None,returnStarInt,None,False],                                             # The mass number for the chemical element defined by the tag '_Atom_type' or any of its related tags.
          'W_zero_val': [None,returnStarFloat,None,False],                                                    # W zero val
          'W_zero_val_err': [None,returnStarFloat,None,False],                                                # W zero val err
          'W_1H_val': [None,returnStarFloat,None,False],                                                      # W 1H val
          'W_1H_val_err': [None,returnStarFloat,None,False],                                                  # W 1H val err
          'W_13C_val': [None,returnStarFloat,None,False],                                                     # W 13C val
          'W_13C_val_err': [None,returnStarFloat,None,False],                                                 # W 13C val err
          'W_15N_val': [None,returnStarFloat,None,False],                                                     # W 15N val
          'W_15N_val_err': [None,returnStarFloat,None,False],                                                 # W 15N val err
          'Resonance_ID': [None,returnStarInt,'Resonance.ID',False],                                          # Pointer to '_Resonance.ID'
          'Auth_entity_assembly_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],       # An alternative identifier for Entity_assembly_ID that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Entity_assembly_ID.
          'Auth_seq_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                   # An alternative identifier for Seq_id that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Seq_ID or Comp_index_ID.
          'Auth_comp_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                  # An alternative identifier for Comp_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Auth_atom_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                  # An alternative identifier for Atom_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Spectral_density_list_ID': [None,returnStarInt,'Spectral_density_list.ID',True],                   # Pointer to '_Spectral_density_list.ID'

                },

        'tagNames': ['ID', 'Assembly_atom_ID', 'Entity_assembly_ID', 'Entity_ID', 'Comp_index_ID', 'Seq_ID', 'Comp_ID', 'Atom_ID', 'Atom_type', 'Atom_isotope_number', 'W_zero_val', 'W_zero_val_err', 'W_1H_val', 'W_1H_val_err', 'W_13C_val', 'W_13C_val_err', 'W_15N_val', 'W_15N_val_err', 'Resonance_ID', 'Auth_entity_assembly_ID', 'Auth_seq_ID', 'Auth_comp_ID', 'Auth_atom_ID', 'Entry_ID', 'Spectral_density_list_ID'],
        'sourcePrimaryKeys': ['ID', 'Entry_ID', 'Spectral_density_list_ID'],

            }

        },

    'tableNames': ['Spectral_density_experiment', 'Spectral_density_software', 'Spectral_density']

    },

  'other_data_types': {

    'name': 'Other_data_type_list',

    'tags': {

      'Sf_category': ['other_data_types',lambda x = value: returnStarCode(x,length = 127),None,True],         # Category definition for the information content of the saveframe
      'Sf_framecode': [None,lambda x = value: returnStarCode(x,length = 127),None,False],                     # A label for the saveframe that describes in very brief terms the information contained in the saveframe.
      'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                     # Pointer to '_Entry.ID'
      'ID': [None,returnStarInt,None,True],                                                                   # A unique identifier for the list on new data values.
      'Name': [None,lambda x = value: returnStarLine(x,length = 127),None,True],                              # Name for the kind of data values that are being reported.
      'Definition': [None,returnStarString,None,True],                                                        # A definition for the new kind of data that are being reported.
      'Data_file_name': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                   # The name of the file submitted with this depostion that contains the quantitative data for this saveframe.
      'Sample_condition_list_ID': [None,returnStarInt,'Sample_condition_list.ID',True],                       # Pointer to '_Sample_condition_list.ID'
      'Sample_condition_list_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Sample_condition_list.Sf_framecode',True],# Pointer to a saveframe of the category 'sample_conditions'
      'Details': [None,returnStarString,None,False],                                                          # Provide a brief description of the kind of data that is being deposited.
      'Text_data_format': [None,lambda x = value: returnStarLine(x,length = 31),None,False],                  # The data format used to represent the data reported in this saveframe as ASCII text in the text block that is the value to the '_Other_data_type.Text_data' tag.
      'Text_data': [None,returnStarString,None,False],                                                        # A set of data formatted as ASCII text.

            },

    'tagNames': ['Sf_category', 'Sf_framecode', 'Entry_ID', 'ID', 'Name', 'Definition', 'Data_file_name', 'Sample_condition_list_ID', 'Sample_condition_list_label', 'Details', 'Text_data_format', 'Text_data'],
    'sourcePrimaryKeys': ['Entry_ID', 'ID'],

    'tables': {

      'Other_data_experiment': {

        'tags': {

          'Experiment_ID': [None,returnStarInt,'Experiment.ID',True],                                         # Pointer to '_Experiment.ID'
          'Experiment_name': [None,lambda x = value: returnStarLine(x,length = 127),'Experiment.Name',False], # Pointer to a saveframe of the category 'NMR_spectrometer_expt'
          'Sample_ID': [None,returnStarInt,'Sample.ID',True],                                                 # Pointer to '_Sample.ID'
          'Sample_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Sample.Sf_framecode',True],# Pointer to a saveframe of the category 'sample'
          'Sample_state': [None,lambda x = value: returnStarLine(x,length = 31),None,True],                   # Physical state of the sample either anisotropic or isotropic.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Other_data_type_list_ID': [None,returnStarInt,'Other_data_type_list.ID',True],                     # Pointer to '_Other_data_type_list.ID'

                },

        'tagNames': ['Experiment_ID', 'Experiment_name', 'Sample_ID', 'Sample_label', 'Sample_state', 'Entry_ID', 'Other_data_type_list_ID'],
        'sourcePrimaryKeys': ['Experiment_ID', 'Sample_ID', 'Sample_state', 'Entry_ID', 'Other_data_type_list_ID'],

            },

      'Other_data_software': {

        'tags': {

          'Software_ID': [None,returnStarInt,'Software.ID',True],                                             # Pointer to '_Software.ID'
          'Software_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Software.Sf_framecode',True],# Pointer to a saveframe of the category 'software'
          'Method_ID': [None,returnStarInt,'Method.ID',False],                                                # Pointer to '_Method.ID'
          'Method_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Method.Sf_framecode',False],# Pointer to a saveframe of the category 'method'
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Other_data_type_list_ID': [None,returnStarInt,'Other_data_type_list.ID',True],                     # Pointer to '_Other_data_type_list.ID'

                },

        'tagNames': ['Software_ID', 'Software_label', 'Method_ID', 'Method_label', 'Entry_ID', 'Other_data_type_list_ID'],
        'sourcePrimaryKeys': ['Software_ID', 'Entry_ID', 'Other_data_type_list_ID'],

            },

      'Other_data': {

        'tags': {

          'ID': [None,returnStarInt,None,True],                                                               # A unique identifier for a reported new data value.
          'Assembly_atom_ID': [None,returnStarInt,'Atom.Assembly_atom_ID',False],                             # Pointer to '_Atom.Assembly_atom_ID'
          'Entity_assembly_ID': [None,returnStarInt,'Entity_assembly.ID',True],                               # Pointer to '_Entity_assembly.ID'
          'Entity_ID': [None,returnStarInt,'Entity.ID',True],                                                 # Pointer to '_Entity.ID'
          'Comp_index_ID': [None,returnStarInt,'Entity_comp_index.ID',True],                                  # Pointer to '_Entity_comp_index.ID'
          'Seq_ID': [None,returnStarInt,'Entity_poly_seq.Num',True],                                          # Pointer to '_Entity_poly_seq.Num'
          'Comp_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Chem_comp.ID',True],              # Pointer to '_Chem_comp.ID'
          'Atom_ID': [None,lambda x = value: returnStarAtCode(x,length = 12),'Chem_comp_atom.Atom_ID',True],  # Pointer to '_Chem_comp_atom.Atom_ID'
          'Atom_type': [None,lambda x = value: returnStarCode(x,length = 15),None,True],                      # The value for this tag is a standard IUPAC abbreviation for an element (i.e.$ H$ C$ P$ etc).
          'Atom_isotope_number': [None,returnStarInt,None,False],                                             # The mass number for the chemical element defined by the tag '_Atom_type' or any of its related tags.
          'Val': [None,returnStarFloat,None,True],                                                            # Value obtained for the kind of data observed.
          'Val_err': [None,returnStarFloat,None,False],                                                       # Estimated error in the value obtained for the kind of data observed.
          'Resonance_ID': [None,returnStarInt,'Resonance.ID',False],                                          # Pointer to '_Resonance.ID'
          'Auth_entity_assembly_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],       # An alternative identifier for Entity_assembly_ID that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Entity_assembly_ID.
          'Auth_seq_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                   # An alternative identifier for Seq_id that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Seq_ID or Comp_index_ID.
          'Auth_comp_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                  # An alternative identifier for Comp_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Auth_atom_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                  # An alternative identifier for Atom_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Other_data_type_list_ID': [None,returnStarInt,'Other_data_type_list.ID',True],                     # Pointer to '_Other_data_type_list.ID'

                },

        'tagNames': ['ID', 'Assembly_atom_ID', 'Entity_assembly_ID', 'Entity_ID', 'Comp_index_ID', 'Seq_ID', 'Comp_ID', 'Atom_ID', 'Atom_type', 'Atom_isotope_number', 'Val', 'Val_err', 'Resonance_ID', 'Auth_entity_assembly_ID', 'Auth_seq_ID', 'Auth_comp_ID', 'Auth_atom_ID', 'Entry_ID', 'Other_data_type_list_ID'],
        'sourcePrimaryKeys': ['ID', 'Entry_ID', 'Other_data_type_list_ID'],

            }

        },

    'tableNames': ['Other_data_experiment', 'Other_data_software', 'Other_data']

    },

  'chemical_rates': {

    'name': 'Chemical_rate_list',

    'tags': {

      'Sf_category': ['chemical_rates',lambda x = value: returnStarCode(x,length = 127),None,True],           # Category definition for the information content of the saveframe
      'Sf_framecode': [None,lambda x = value: returnStarCode(x,length = 127),None,False],                     # A label for the saveframe that describes in very brief terms the information contained in the saveframe.
      'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                     # Pointer to '_Entry.ID'
      'ID': [None,returnStarInt,None,True],                                                                   # A unique identifier for the list of Kinetic rate data.
      'Data_file_name': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                   # The name of the file submitted with this depostion that contains the quantitative data for this saveframe.
      'Sample_condition_list_ID': [None,returnStarInt,'Sample_condition_list.ID',True],                       # Pointer to '_Sample_condition_list.ID'
      'Sample_condition_list_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Sample_condition_list.Sf_framecode',True],# The label for the set of experimental sample conditions used to collect the data for determination of the kinetic rates.
      'Details': [None,returnStarString,None,False],                                                          # Text describing the reported kinetic rates.
      'Text_data_format': [None,lambda x = value: returnStarLine(x,length = 31),None,False],                  # The data format used to represent the kinetic data as ASCII text in the text block that is the value to the '_Chemical_rate_list.Text_data' tag.
      'Text_data': [None,returnStarString,None,False],                                                        # A set of kinetic rate data formatted as ASCII text.

            },

    'tagNames': ['Sf_category', 'Sf_framecode', 'Entry_ID', 'ID', 'Data_file_name', 'Sample_condition_list_ID', 'Sample_condition_list_label', 'Details', 'Text_data_format', 'Text_data'],
    'sourcePrimaryKeys': ['Entry_ID', 'ID'],

    'tables': {

      'Chemical_rate_experiment': {

        'tags': {

          'Experiment_ID': [None,returnStarInt,'Experiment.ID',True],                                         # Pointer to '_Experiment.ID'
          'Experiment_name': [None,lambda x = value: returnStarLine(x,length = 127),'Experiment.Name',False], # Pointer to a saveframe of the category 'NMR_spectrometer_expt'
          'Sample_ID': [None,returnStarInt,'Sample.ID',True],                                                 # Pointer to '_Sample.ID'
          'Sample_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Sample.Sf_framecode',True],# Pointer to a saveframe of the category 'sample'
          'Sample_state': [None,lambda x = value: returnStarLine(x,length = 31),None,True],                   # Physical state of the sample either anisotropic or isotropic.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Chemical_rate_list_ID': [None,returnStarInt,'Chemical_rate_list.ID',True],                         # Pointer to '_Chemical_rate_list.ID'

                },

        'tagNames': ['Experiment_ID', 'Experiment_name', 'Sample_ID', 'Sample_label', 'Sample_state', 'Entry_ID', 'Chemical_rate_list_ID'],
        'sourcePrimaryKeys': ['Experiment_ID', 'Sample_ID', 'Sample_state', 'Entry_ID', 'Chemical_rate_list_ID'],

            },

      'Chemical_rate_software': {

        'tags': {

          'Software_ID': [None,returnStarInt,'Software.ID',True],                                             # Pointer to '_Software.ID'
          'Software_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Software.Sf_framecode',True],# Pointer to a saveframe of the category 'software'
          'Method_ID': [None,returnStarInt,'Method.ID',False],                                                # Pointer to '_Method.ID'
          'Method_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Method.Sf_framecode',False],# Pointer to a saveframe of the category 'method'
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Chemical_rate_list_ID': [None,returnStarInt,'Chemical_rate_list.ID',True],                         # Pointer to '_Chemical_rate_list.ID'

                },

        'tagNames': ['Software_ID', 'Software_label', 'Method_ID', 'Method_label', 'Entry_ID', 'Chemical_rate_list_ID'],
        'sourcePrimaryKeys': ['Software_ID', 'Entry_ID', 'Chemical_rate_list_ID'],

            },

      'Chemical_rate': {

        'tags': {

          'ID': [None,returnStarInt,None,True],                                                               # Unique identifier for the observed rate value.
          'Assembly_ID': [None,returnStarInt,'Assembly.ID',False],                                            # Pointer to '_Assembly.ID'
          'Assembly_atom_ID': [None,returnStarInt,'Atom.Assembly_atom_ID',False],                             # Pointer to '_Atom.Assembly_atom_ID'
          'Entity_assembly_ID': [None,returnStarInt,'Entity_assembly.ID',True],                               # Pointer to '_Entity_assembly.ID'
          'Entity_ID': [None,returnStarInt,'Entity.ID',True],                                                 # Pointer to '_Entity.ID'
          'Comp_index_ID': [None,returnStarInt,'Entity_comp_index.ID',True],                                  # Pointer to '_Entity_comp_index.ID'
          'Seq_ID': [None,returnStarInt,'Entity_poly_seq.Num',True],                                          # Pointer to '_Entity_poly_seq.Num'
          'Comp_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Chem_comp.ID',True],              # Pointer to '_Chem_comp.ID'
          'Atom_ID': [None,lambda x = value: returnStarAtCode(x,length = 12),'Chem_comp_atom.Atom_ID',True],  # Pointer to '_Chem_comp_atom.Atom_ID'
          'Atom_type': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                     # The value for this tag is a standard IUPAC abbreviation for an element (i.e.$ H$ C$ P$ etc).
          'Atom_isotope_number': [None,returnStarInt,None,False],                                             # The mass number for the chemical element defined by the tag '_Atom_type' or any of its related tags.
          'Val_type': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                     # The type of rate value reported
          'Val': [None,returnStarFloat,None,False],                                                           # Kinetic rate value
          'Val_min': [None,returnStarFloat,None,False],                                                       # Estimated minimum value for the observed rate when a specific value cannot be obtained.
          'Val_max': [None,returnStarFloat,None,False],                                                       # Estimated maximum value for the observed rate when a specific value cannot be obtained.
          'Val_err': [None,returnStarFloat,None,False],                                                       # Estimated error in the observed rate value.
          'Val_units': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                     # Units for the reported rate value.
          'Resonance_ID': [None,returnStarInt,'Resonance.ID',False],                                          # Pointer to '_Resonance.ID'
          'Auth_entity_assembly_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],       # An alternative identifier for Entity_assembly_ID that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Entity_assembly_ID.
          'Auth_seq_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                   # An alternative identifier for Seq_id that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Seq_ID or Comp_index_ID.
          'Auth_comp_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                  # An alternative identifier for Comp_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Auth_atom_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                  # An alternative identifier for Atom_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Chemical_rate_list_ID': [None,returnStarInt,'Chemical_rate_list.ID',True],                         # Pointer to '_Chemical_rate_list.ID'

                },

        'tagNames': ['ID', 'Assembly_ID', 'Assembly_atom_ID', 'Entity_assembly_ID', 'Entity_ID', 'Comp_index_ID', 'Seq_ID', 'Comp_ID', 'Atom_ID', 'Atom_type', 'Atom_isotope_number', 'Val_type', 'Val', 'Val_min', 'Val_max', 'Val_err', 'Val_units', 'Resonance_ID', 'Auth_entity_assembly_ID', 'Auth_seq_ID', 'Auth_comp_ID', 'Auth_atom_ID', 'Entry_ID', 'Chemical_rate_list_ID'],
        'sourcePrimaryKeys': ['ID', 'Entry_ID', 'Chemical_rate_list_ID'],

            }

        },

    'tableNames': ['Chemical_rate_experiment', 'Chemical_rate_software', 'Chemical_rate']

    },

  'H_exch_rates': {

    'name': 'H_exch_rate_list',

    'tags': {

      'Sf_category': ['H_exch_rates',lambda x = value: returnStarCode(x,length = 127),None,True],             # Category definition for the information content of the saveframe
      'Sf_framecode': [None,lambda x = value: returnStarCode(x,length = 127),None,False],                     # A label for the saveframe that describes in very brief terms the information contained in the saveframe.
      'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                     # Pointer to '_Entry.ID'
      'ID': [None,returnStarInt,None,True],                                                                   # A unique identifier for the list of hydrogen exchange rate data.
      'Data_file_name': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                   # The name of the file submitted with this depostion that contains the quantitative data for this saveframe.
      'Sample_condition_list_ID': [None,returnStarInt,'Sample_condition_list.ID',True],                       # Pointer to '_Sample_condition_list.ID'
      'Sample_condition_list_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Sample_condition_list.Sf_framecode',True],# The label for the set of experimental sample conditions used to collect the data for determination of the H-exchange rates.
      'Val_units': [None,lambda x = value: returnStarCode(x,length = 15),None,True],                          # The units used for the reported hydrogen exchange rates.
      'Details': [None,returnStarString,None,False],                                                          # Text describing the reported hydrogen exchange rates.
      'Text_data_format': [None,lambda x = value: returnStarLine(x,length = 31),None,False],                  # The data format used to represent the hydrogen exchange data as ASCII text in the text block that is the value to the '_H_exch_rate_list.Text_data' tag.
      'Text_data': [None,returnStarString,None,False],                                                        # A set of hydrogen exchange rate data formatted as ASCII text.

            },

    'tagNames': ['Sf_category', 'Sf_framecode', 'Entry_ID', 'ID', 'Data_file_name', 'Sample_condition_list_ID', 'Sample_condition_list_label', 'Val_units', 'Details', 'Text_data_format', 'Text_data'],
    'sourcePrimaryKeys': ['Entry_ID', 'ID'],

    'tables': {

      'H_exch_rate_experiment': {

        'tags': {

          'Experiment_ID': [None,returnStarInt,'Experiment.ID',True],                                         # Pointer to '_Experiment.ID'
          'Experiment_name': [None,lambda x = value: returnStarLine(x,length = 127),'Experiment.Name',False], # Pointer to a saveframe of the category 'NMR_spectrometer_expt'
          'Sample_ID': [None,returnStarInt,'Sample.ID',True],                                                 # Pointer to '_Sample.ID'
          'Sample_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Sample.Sf_framecode',True],# Pointer to a saveframe of the category 'sample'
          'Sample_state': [None,lambda x = value: returnStarLine(x,length = 31),None,True],                   # Physical state of the sample either anisotropic or isotropic.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'H_exch_rate_list_ID': [None,returnStarInt,'H_exch_rate_list.ID',True],                             # Pointer to '_H_exch_rate_list.ID'

                },

        'tagNames': ['Experiment_ID', 'Experiment_name', 'Sample_ID', 'Sample_label', 'Sample_state', 'Entry_ID', 'H_exch_rate_list_ID'],
        'sourcePrimaryKeys': ['Experiment_ID', 'Sample_ID', 'Sample_state', 'Entry_ID', 'H_exch_rate_list_ID'],

            },

      'H_exch_rate_software': {

        'tags': {

          'Software_ID': [None,returnStarInt,'Software.ID',True],                                             # Pointer to '_Software.ID'
          'Software_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Software.Sf_framecode',True],# Pointer to a saveframe of the category 'software'
          'Method_ID': [None,returnStarInt,'Method.ID',False],                                                # Pointer to '_Method.ID'
          'Method_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Method.Sf_framecode',False],# Pointer to a saveframe of the category 'method'
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'H_exch_rate_list_ID': [None,returnStarInt,'H_exch_rate_list.ID',True],                             # Pointer to '_H_exch_rate_list.ID'

                },

        'tagNames': ['Software_ID', 'Software_label', 'Method_ID', 'Method_label', 'Entry_ID', 'H_exch_rate_list_ID'],
        'sourcePrimaryKeys': ['Software_ID', 'Entry_ID', 'H_exch_rate_list_ID'],

            },

      'H_exch_rate': {

        'tags': {

          'ID': [None,returnStarInt,None,True],                                                               # Unique identifier for the observed hydrogen exchange rate.
          'Assembly_atom_ID': [None,returnStarInt,'Atom.Assembly_atom_ID',False],                             # Pointer to '_Atom.Assembly_atom_ID'
          'Entity_assembly_ID': [None,returnStarInt,'Entity_assembly.ID',True],                               # Pointer to '_Entity_assembly.ID'
          'Entity_ID': [None,returnStarInt,'Entity.ID',True],                                                 # Pointer to '_Entity.ID'
          'Comp_index_ID': [None,returnStarInt,'Entity_comp_index.ID',True],                                  # Pointer to '_Entity_comp_index.ID'
          'Seq_ID': [None,returnStarInt,'Entity_poly_seq.Num',True],                                          # Pointer to '_Entity_poly_seq.Num'
          'Comp_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Chem_comp.ID',True],              # Pointer to '_Chem_comp.ID'
          'Atom_ID': [None,lambda x = value: returnStarAtCode(x,length = 12),'Chem_comp_atom.Atom_ID',True],  # Pointer to '_Chem_comp_atom.Atom_ID'
          'Atom_type': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                     # The value for this tag is a standard IUPAC abbreviation for an element (i.e.$ H$ C$ P$ etc).
          'Atom_isotope_number': [None,returnStarInt,None,False],                                             # The mass number for the chemical element defined by the tag '_Atom_type' or any of its related tags.
          'Val': [None,returnStarFloat,None,False],                                                           # Hydrogen exchange rate value
          'Val_min': [None,returnStarFloat,None,False],                                                       # Estimated minimum value for the hydrogen exchange rate when a specific value cannot be obtained.
          'Val_max': [None,returnStarFloat,None,False],                                                       # Estimated maximum value for the hydrogen exchange rate when a specific value cannot be obtained.
          'Val_err': [None,returnStarFloat,None,False],                                                       # Estimated error in the hydrogen exchange rate value.
          'Resonance_ID': [None,returnStarInt,'Resonance.ID',False],                                          # Pointer to '_Resonance.ID'
          'Auth_entity_assembly_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],       # An alternative identifier for Entity_assembly_ID that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Entity_assembly_ID.
          'Auth_seq_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                   # An alternative identifier for Seq_id that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Seq_ID or Comp_index_ID.
          'Auth_comp_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                  # An alternative identifier for Comp_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Auth_atom_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                  # An alternative identifier for Atom_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'H_exch_rate_list_ID': [None,returnStarInt,'H_exch_rate_list.ID',True],                             # Pointer to '_H_exch_rate_list.ID'

                },

        'tagNames': ['ID', 'Assembly_atom_ID', 'Entity_assembly_ID', 'Entity_ID', 'Comp_index_ID', 'Seq_ID', 'Comp_ID', 'Atom_ID', 'Atom_type', 'Atom_isotope_number', 'Val', 'Val_min', 'Val_max', 'Val_err', 'Resonance_ID', 'Auth_entity_assembly_ID', 'Auth_seq_ID', 'Auth_comp_ID', 'Auth_atom_ID', 'Entry_ID', 'H_exch_rate_list_ID'],
        'sourcePrimaryKeys': ['ID', 'Entry_ID', 'H_exch_rate_list_ID'],

            }

        },

    'tableNames': ['H_exch_rate_experiment', 'H_exch_rate_software', 'H_exch_rate']

    },

  'H_exch_protection_factors': {

    'name': 'H_exch_protection_factor_list',

    'tags': {

      'Sf_category': ['H_exch_protection_factors',lambda x = value: returnStarCode(x,length = 127),None,True],# Category definition for the information content of the saveframe
      'Sf_framecode': [None,lambda x = value: returnStarCode(x,length = 127),None,False],                     # A label for the saveframe that describes in very brief terms the information contained in the saveframe.
      'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                     # Pointer to '_Entry.ID'
      'ID': [None,returnStarInt,None,True],                                                                   # An integer value that uniquely identifies this saveframe of hydrogen exchange protection factor data from other saveframes of this category in an entry.
      'Data_file_name': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                   # The name of the file submitted with this depostion that contains the quantitative data for this saveframe.
      'Sample_condition_list_ID': [None,returnStarInt,'Sample_condition_list.ID',True],                       # Pointer to '_Sample_condition_list.ID'
      'Sample_condition_list_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Sample_condition_list.Sf_framecode',True],# The label for the set of experimental sample conditions used to collect the data for determination of the H-exchange protection factors.
      'Std_values_source_cit_ID': [None,returnStarInt,'Citation.ID',False],                                   # Pointer to '_Citation.ID'
      'Std_values_source_cit_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Citation.Sf_framecode',False],# Pointer to a saveframe of the category 'Citation.'  this would be the citation for the method used to calculate standard hydrogen exchange rates used to determine the reported protection factors.
      'Details': [None,returnStarString,None,False],                                                          # Text describing the reported hydrogen exchange protection factors.
      'Text_data_format': [None,lambda x = value: returnStarLine(x,length = 31),None,False],                  # The data format used to represent the hydrogen exchange protection factor data as ASCII text in the text block that is the value to the '_H_exch_protection_factor.Text_data' tag.
      'Text_data': [None,returnStarString,None,False],                                                        # A set of hydrogen protection factor data formatted as ASCII text.

            },

    'tagNames': ['Sf_category', 'Sf_framecode', 'Entry_ID', 'ID', 'Data_file_name', 'Sample_condition_list_ID', 'Sample_condition_list_label', 'Std_values_source_cit_ID', 'Std_values_source_cit_label', 'Details', 'Text_data_format', 'Text_data'],
    'sourcePrimaryKeys': ['Entry_ID', 'ID'],

    'tables': {

      'H_exch_protection_fact_experiment': {

        'tags': {

          'Experiment_ID': [None,returnStarInt,'Experiment.ID',True],                                         # Pointer to '_Experiment.ID'
          'Experiment_name': [None,lambda x = value: returnStarLine(x,length = 127),'Experiment.Name',False], # Pointer to a saveframe of the category 'NMR_spectrometer_expt'
          'Sample_ID': [None,returnStarInt,'Sample.ID',True],                                                 # Pointer to '_Sample.ID'
          'Sample_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Sample.Sf_framecode',True],# Pointer to a saveframe of the category 'sample'
          'Sample_state': [None,lambda x = value: returnStarLine(x,length = 31),None,True],                   # Physical state of the sample either anisotropic or isotropic.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'H_exch_protection_factor_list_ID': [None,returnStarInt,'H_exch_protection_factor_list.ID',True],   # Pointer to '_H_exch_protection_factor_list.ID'

                },

        'tagNames': ['Experiment_ID', 'Experiment_name', 'Sample_ID', 'Sample_label', 'Sample_state', 'Entry_ID', 'H_exch_protection_factor_list_ID'],
        'sourcePrimaryKeys': ['Experiment_ID', 'Sample_ID', 'Sample_state', 'Entry_ID', 'H_exch_protection_factor_list_ID'],

            },

      'H_exch_protect_fact_software': {

        'tags': {

          'Software_ID': [None,returnStarInt,'Software.ID',True],                                             # Pointer to '_Software.ID'
          'Software_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Software.Sf_framecode',True],# Pointer to a saveframe of the category 'software'
          'Method_ID': [None,returnStarInt,'Method.ID',False],                                                # Pointer to '_Method.ID'
          'Method_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Method.Sf_framecode',False],# Pointer to a saveframe of the category 'method'
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'H_exch_protection_factor_list_ID': [None,returnStarInt,'H_exch_protection_factor_list.ID',True],   # Pointer to '_H_exch_protection_factor_list.ID'

                },

        'tagNames': ['Software_ID', 'Software_label', 'Method_ID', 'Method_label', 'Entry_ID', 'H_exch_protection_factor_list_ID'],
        'sourcePrimaryKeys': ['Software_ID', 'Entry_ID', 'H_exch_protection_factor_list_ID'],

            },

      'H_exch_protection_factor': {

        'tags': {

          'ID': [None,returnStarInt,None,True],                                                               # Unique identifier for the observed hydrogen exchange protection factor.
          'Assembly_atom_ID': [None,returnStarInt,'Atom.Assembly_atom_ID',False],                             # Pointer to '_Atom.Assembly_atom_ID'
          'Entity_assembly_ID': [None,returnStarInt,'Entity_assembly.ID',True],                               # Pointer to '_Entity_assembly.ID'
          'Entity_ID': [None,returnStarInt,'Entity.ID',True],                                                 # Pointer to '_Entity.ID'
          'Comp_index_ID': [None,returnStarInt,'Entity_comp_index.ID',True],                                  # Pointer to '_Entity_comp_index.ID'
          'Seq_ID': [None,returnStarInt,'Entity_poly_seq.Num',True],                                          # Pointer to '_Entity_poly_seq.Num'
          'Comp_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Chem_comp.ID',True],              # Pointer to '_Chem_comp.ID'
          'Atom_ID': [None,lambda x = value: returnStarAtCode(x,length = 12),'Chem_comp_atom.Atom_ID',True],  # Pointer to '_Chem_comp_atom.Atom_ID'
          'Atom_type': [None,lambda x = value: returnStarCode(x,length = 15),None,True],                      # The value for this tag is a standard IUPAC abbreviation for an element (i.e.$ H$ C$ P$ etc).
          'Atom_isotope_number': [None,returnStarInt,None,False],                                             # The mass number for the chemical element defined by the tag '_Atom_type' or any of its related tags.
          'Calculated_intrinsic_rate': [None,returnStarFloat,None,False],                                     # Intrinsic hydrogen exchange rate calculated from empirical data.
          'Val': [None,returnStarFloat,None,True],                                                            # Hydrogen exchange protection factor value
          'Val_err': [None,returnStarFloat,None,False],                                                       # Estimated error in the hydrogen exchange protection factor value
          'Resonance_ID': [None,returnStarInt,'Resonance.ID',False],                                          # Pointer to '_Resonance.ID'
          'Auth_entity_assembly_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],       # An alternative identifier for Entity_assembly_ID that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Entity_assembly_ID.
          'Auth_seq_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                   # An alternative identifier for Seq_id that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Seq_ID or Comp_index_ID.
          'Auth_comp_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                  # An alternative identifier for Comp_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Auth_atom_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                  # An alternative identifier for Atom_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'H_exch_protection_factor_list_ID': [None,returnStarInt,'H_exch_protection_factor_list.ID',True],   # Pointer to '_H_exch_protection_factor_list.ID'

                },

        'tagNames': ['ID', 'Assembly_atom_ID', 'Entity_assembly_ID', 'Entity_ID', 'Comp_index_ID', 'Seq_ID', 'Comp_ID', 'Atom_ID', 'Atom_type', 'Atom_isotope_number', 'Calculated_intrinsic_rate', 'Val', 'Val_err', 'Resonance_ID', 'Auth_entity_assembly_ID', 'Auth_seq_ID', 'Auth_comp_ID', 'Auth_atom_ID', 'Entry_ID', 'H_exch_protection_factor_list_ID'],
        'sourcePrimaryKeys': ['ID', 'Entry_ID', 'H_exch_protection_factor_list_ID'],

            }

        },

    'tableNames': ['H_exch_protection_fact_experiment', 'H_exch_protect_fact_software', 'H_exch_protection_factor']

    },

  'homonucl_NOEs': {

    'name': 'Homonucl_NOE_list',

    'tags': {

      'Sf_category': ['homonucl_NOEs',lambda x = value: returnStarCode(x,length = 127),None,True],            # Category definition for the information content of the saveframe
      'Sf_framecode': [None,lambda x = value: returnStarCode(x,length = 127),None,False],                     # A label for the saveframe that describes in very brief terms the information contained in the saveframe.
      'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                     # Pointer to '_Entry.ID'
      'ID': [None,returnStarInt,None,True],                                                                   # An integer value that uniquely identifies this saveframe of homonuclear NOE data from other saveframes of this category in an entry.
      'Data_file_name': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                   # The name of the file submitted with this depostion that contains the quantitative data for this saveframe.
      'Sample_condition_list_ID': [None,returnStarInt,'Sample_condition_list.ID',True],                       # Pointer to '_Sample_condition_list.ID'
      'Sample_condition_list_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Sample_condition_list.Sf_framecode',True],# Enter the label given to the set of sample conditions used to collect the NOE data reported.
      'Homonuclear_NOE_val_type': [None,lambda x = value: returnStarCode(x,length = 31),None,True],           # Enter the method used to measure the intensities of the NOE peaks.
      'NOE_ref_val': [None,returnStarFloat,None,False],                                                       # Supply the value used to normalize the NOE intensities.
      'NOE_ref_description': [None,returnStarString,None,False],                                              # Provide a brief description for the source of the NOE reference value and how the actual value was determined.
      'Details': [None,returnStarString,None,False],                                                          # Text providing additional information about the set of homonuclear NOE values and their derivation.
      'Text_data_format': [None,lambda x = value: returnStarLine(x,length = 31),None,False],                  # The data format used to represent the homonuclear NOE data as ASCII text in the text block that is the value to the '_Homonucl_NOE_list.Text_data' tag.
      'Text_data': [None,returnStarString,None,False],                                                        # A set of homonuclear NOE data formatted as ASCII text.

            },

    'tagNames': ['Sf_category', 'Sf_framecode', 'Entry_ID', 'ID', 'Data_file_name', 'Sample_condition_list_ID', 'Sample_condition_list_label', 'Homonuclear_NOE_val_type', 'NOE_ref_val', 'NOE_ref_description', 'Details', 'Text_data_format', 'Text_data'],
    'sourcePrimaryKeys': ['Entry_ID', 'ID'],

    'tables': {

      'Homonucl_NOE_experiment': {

        'tags': {

          'Experiment_ID': [None,returnStarInt,'Experiment.ID',True],                                         # Pointer to '_Experiment.ID'
          'Experiment_name': [None,lambda x = value: returnStarLine(x,length = 127),'Experiment.Name',False], # Pointer to a saveframe of the category 'NMR_spectrometer_expt'
          'Sample_ID': [None,returnStarInt,'Sample.ID',True],                                                 # Pointer to '_Sample.ID'
          'Sample_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Sample.Sf_framecode',True],# Pointer to a saveframe of the category 'sample'
          'Sample_state': [None,lambda x = value: returnStarLine(x,length = 31),None,True],                   # Physical state of the sample either anisotropic or isotropic.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Homonucl_NOE_list_ID': [None,returnStarInt,'Homonucl_NOE_list.ID',True],                           # Pointer to '_Homonucl_NOE_list.ID'

                },

        'tagNames': ['Experiment_ID', 'Experiment_name', 'Sample_ID', 'Sample_label', 'Sample_state', 'Entry_ID', 'Homonucl_NOE_list_ID'],
        'sourcePrimaryKeys': ['Experiment_ID', 'Sample_ID', 'Sample_state', 'Entry_ID', 'Homonucl_NOE_list_ID'],

            },

      'Homonucl_NOE_software': {

        'tags': {

          'Software_ID': [None,returnStarInt,'Software.ID',True],                                             # Pointer to '_Software.ID'
          'Software_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Software.Sf_framecode',True],# Pointer to a saveframe of the category 'software'
          'Method_ID': [None,returnStarInt,'Method.ID',False],                                                # Pointer to '_Method.ID'
          'Method_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Method.Sf_framecode',False],# Pointer to a saveframe of the category 'method'
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Homonucl_NOE_list_ID': [None,returnStarInt,'Homonucl_NOE_list.ID',True],                           # Pointer to '_Homonucl_NOE_list.ID'

                },

        'tagNames': ['Software_ID', 'Software_label', 'Method_ID', 'Method_label', 'Entry_ID', 'Homonucl_NOE_list_ID'],
        'sourcePrimaryKeys': ['Software_ID', 'Entry_ID', 'Homonucl_NOE_list_ID'],

            },

      'Homonucl_NOE': {

        'tags': {

          'ID': [None,returnStarInt,None,True],                                                               # Unique identifier for the observed homonuclear NOE.
          'Assembly_atom_ID_1': [None,returnStarInt,'Atom.Assembly_atom_ID',False],                           # Pointer to '_Atom.Assembly_atom_ID'
          'Entity_assembly_ID_1': [None,returnStarInt,'Entity_assembly.ID',True],                             # Pointer to '_Entity_assembly.ID'
          'Entity_ID_1': [None,returnStarInt,'Entity.ID',True],                                               # Pointer to '_Entity.ID'
          'Comp_index_ID_1': [None,returnStarInt,'Entity_comp_index.ID',True],                                # Pointer to '_Entity_comp_index.ID'
          'Seq_ID_1': [None,returnStarInt,'Entity_poly_seq.Num',True],                                        # Pointer to '_Entity_poly_seq.Num'
          'Comp_ID_1': [None,lambda x = value: returnStarCode(x,length = 12),'Chem_comp.ID',True],            # Pointer to '_Chem_comp.ID'
          'Atom_ID_1': [None,lambda x = value: returnStarAtCode(x,length = 12),'Chem_comp_atom.Atom_ID',True],# Pointer to '_Chem_comp_atom.Atom_ID'
          'Atom_type_1': [None,lambda x = value: returnStarCode(x,length = 15),None,True],                    # Standard symbol used to define the atom element type.
          'Atom_isotope_number_1': [None,returnStarInt,None,False],                                           # The mass number for the chemical element defined by the tag '_Atom_type' or any of its related tags.
          'Assembly_atom_ID_2': [None,returnStarInt,'Atom.Assembly_atom_ID',False],                           # Pointer to '_Atom.Assembly_atom_ID'
          'Entity_assembly_ID_2': [None,returnStarInt,'Entity_assembly.ID',True],                             # Pointer to '_Entity_assembly.ID'
          'Entity_ID_2': [None,returnStarInt,'Entity.ID',True],                                               # Pointer to '_Entity.ID'
          'Comp_index_ID_2': [None,returnStarInt,'Entity_comp_index.ID',True],                                # Pointer to '_Entity_comp_index.ID'
          'Seq_ID_2': [None,returnStarInt,'Entity_poly_seq.Num',True],                                        # Pointer to '_Entity_poly_seq.Num'
          'Comp_ID_2': [None,lambda x = value: returnStarCode(x,length = 12),'Chem_comp.ID',True],            # Pointer to '_Chem_comp.ID'
          'Atom_ID_2': [None,lambda x = value: returnStarAtCode(x,length = 12),'Chem_comp_atom.Atom_ID',True],# Pointer to '_Chem_comp_atom.Atom_ID'
          'Atom_type_2': [None,lambda x = value: returnStarCode(x,length = 15),None,True],                    # Standard symbol used to define the atom element type.
          'Atom_isotope_number_2': [None,returnStarInt,None,False],                                           # The mass number for the chemical element defined by the tag '_Atom_type' or any of its related tags.
          'Val': [None,returnStarFloat,None,True],                                                            # Homonuclear NOE value
          'Val_err': [None,returnStarFloat,None,False],                                                       # Estimated error in the homonuclear NOE value.
          'Resonance_ID_1': [None,returnStarInt,'Resonance.ID',False],                                        # Pointer to '_Resonance.ID'
          'Resonance_ID_2': [None,returnStarInt,'Resonance.ID',False],                                        # Pointer to '_Resonance.ID'
          'Auth_entity_assembly_ID_1': [None,lambda x = value: returnStarCode(x,length = 15),None,False],     # An alternative identifier for Entity_assembly_ID that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Entity_assembly_ID.
          'Auth_seq_ID_1': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                 # An alternative identifier for Seq_id that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Seq_ID or Comp_index_ID.
          'Auth_comp_ID_1': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                # An alternative identifier for Comp_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Auth_atom_ID_1': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                # An alternative identifier for Atom_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Auth_entity_assembly_ID_2': [None,lambda x = value: returnStarCode(x,length = 15),None,False],     # An alternative identifier for Entity_assembly_ID that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Entity_assembly_ID.
          'Auth_seq_ID_2': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                 # An alternative identifier for Seq_id that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Seq_ID or Comp_index_ID.
          'Auth_comp_ID_2': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                # An alternative identifier for Comp_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Auth_atom_ID_2': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                # An alternative identifier for Atom_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Homonucl_NOE_list_ID': [None,returnStarInt,'Homonucl_NOE_list.ID',True],                           # Pointer to '_Homonucl_NOE_list.ID'

                },

        'tagNames': ['ID', 'Assembly_atom_ID_1', 'Entity_assembly_ID_1', 'Entity_ID_1', 'Comp_index_ID_1', 'Seq_ID_1', 'Comp_ID_1', 'Atom_ID_1', 'Atom_type_1', 'Atom_isotope_number_1', 'Assembly_atom_ID_2', 'Entity_assembly_ID_2', 'Entity_ID_2', 'Comp_index_ID_2', 'Seq_ID_2', 'Comp_ID_2', 'Atom_ID_2', 'Atom_type_2', 'Atom_isotope_number_2', 'Val', 'Val_err', 'Resonance_ID_1', 'Resonance_ID_2', 'Auth_entity_assembly_ID_1', 'Auth_seq_ID_1', 'Auth_comp_ID_1', 'Auth_atom_ID_1', 'Auth_entity_assembly_ID_2', 'Auth_seq_ID_2', 'Auth_comp_ID_2', 'Auth_atom_ID_2', 'Entry_ID', 'Homonucl_NOE_list_ID'],
        'sourcePrimaryKeys': ['ID', 'Entry_ID', 'Homonucl_NOE_list_ID'],

            }

        },

    'tableNames': ['Homonucl_NOE_experiment', 'Homonucl_NOE_software', 'Homonucl_NOE']

    },

  'heteronucl_NOEs': {

    'name': 'Heteronucl_NOE_list',

    'tags': {

      'Sf_category': ['heteronucl_NOEs',lambda x = value: returnStarCode(x,length = 127),None,True],          # Category definition for the information content of the saveframe
      'Sf_framecode': [None,lambda x = value: returnStarCode(x,length = 127),None,False],                     # A label for the saveframe that describes in very brief terms the information contained in the saveframe.
      'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                     # Pointer to '_Entry.ID'
      'ID': [None,returnStarInt,None,True],                                                                   # An integer value that uniquely identifies this saveframe of heteronuclear NOE data from other saveframes of this category in an entry.
      'Data_file_name': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                   # The name of the file submitted with this depostion that contains the quantitative data for this saveframe.
      'Sample_condition_list_ID': [None,returnStarInt,'Sample_condition_list.ID',True],                       # Pointer to '_Sample_condition_list.ID'
      'Sample_condition_list_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Sample_condition_list.Sf_framecode',True],# Pointer to a saveframe of the category 'sample conditions'
      'Spectrometer_frequency_1H': [None,returnStarFloat,None,True],                                          # Operating frequency of the spectrometer used to collect the heteronuclear NOE data reported as the 1H frequency in MHz.
      'Heteronuclear_NOE_val_type': [None,lambda x = value: returnStarCode(x,length = 31),None,True],         # A keyword that defines the type of value reported as the heteronuclear NOE.
      'NOE_ref_val': [None,returnStarFloat,None,False],                                                       # Value used to calibrate other NOE measurements
      'NOE_ref_description': [None,returnStarString,None,False],                                              # Brief text describing the NOE ref value used and how it was derived.
      'Details': [None,returnStarString,None,False],                                                          # Text providing additional information about the data reported.
      'Text_data_format': [None,lambda x = value: returnStarLine(x,length = 31),None,False],                  # The data format used to represent the heteronuclear NOE data as ASCII text in the text block that is the value to the '_Heteronucl_NOE_list.Text_data' tag.
      'Text_data': [None,returnStarString,None,False],                                                        # A set of heteronuclear NOE data formatted as ASCII text.

            },

    'tagNames': ['Sf_category', 'Sf_framecode', 'Entry_ID', 'ID', 'Data_file_name', 'Sample_condition_list_ID', 'Sample_condition_list_label', 'Spectrometer_frequency_1H', 'Heteronuclear_NOE_val_type', 'NOE_ref_val', 'NOE_ref_description', 'Details', 'Text_data_format', 'Text_data'],
    'sourcePrimaryKeys': ['Entry_ID', 'ID'],

    'tables': {

      'Heteronucl_NOE_experiment': {

        'tags': {

          'Experiment_ID': [None,returnStarInt,'Experiment.ID',True],                                         # Pointer to '_Experiment.ID'
          'Experiment_name': [None,lambda x = value: returnStarLine(x,length = 127),'Experiment.Name',False], # Pointer to a saveframe of the category 'NMR_spectrometer_expt'
          'Sample_ID': [None,returnStarInt,'Sample.ID',True],                                                 # Pointer to '_Sample.ID'
          'Sample_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Sample.Sf_framecode',True],# Pointer to a saveframe of the category 'sample'
          'Sample_state': [None,lambda x = value: returnStarLine(x,length = 31),None,True],                   # Physical state of the sample either anisotropic or isotropic.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Heteronucl_NOE_list_ID': [None,returnStarInt,'Heteronucl_NOE_list.ID',True],                       # Pointer to '_Heteronucl_NOE_list.ID'

                },

        'tagNames': ['Experiment_ID', 'Experiment_name', 'Sample_ID', 'Sample_label', 'Sample_state', 'Entry_ID', 'Heteronucl_NOE_list_ID'],
        'sourcePrimaryKeys': ['Experiment_ID', 'Sample_ID', 'Sample_state', 'Entry_ID', 'Heteronucl_NOE_list_ID'],

            },

      'Heteronucl_NOE_software': {

        'tags': {

          'Software_ID': [None,returnStarInt,'Software.ID',True],                                             # Pointer to '_Software.ID'
          'Software_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Software.Sf_framecode',True],# Pointer to a saveframe of the category 'software'
          'Method_ID': [None,returnStarInt,'Method.ID',False],                                                # Pointer to '_Method.ID'
          'Method_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Method.Sf_framecode',False],# Pointer to a saveframe of the category 'method'
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Heteronucl_NOE_list_ID': [None,returnStarInt,'Heteronucl_NOE_list.ID',True],                       # Pointer to '_Heteronucl_NOE_list.ID'

                },

        'tagNames': ['Software_ID', 'Software_label', 'Method_ID', 'Method_label', 'Entry_ID', 'Heteronucl_NOE_list_ID'],
        'sourcePrimaryKeys': ['Software_ID', 'Entry_ID', 'Heteronucl_NOE_list_ID'],

            },

      'Heteronucl_NOE': {

        'tags': {

          'ID': [None,returnStarInt,None,True],                                                               # Unique identifier for the reported heteronuclear NOE value in this set of heteronuclear NOE values.
          'Assembly_atom_ID_1': [None,returnStarInt,'Atom.Assembly_atom_ID',False],                           # Pointer to '_Atom.Assembly_atom_ID'
          'Entity_assembly_ID_1': [None,returnStarInt,'Entity_assembly.ID',True],                             # Pointer to '_Entity_assembly.ID'
          'Entity_ID_1': [None,returnStarInt,'Entity.ID',True],                                               # Pointer to '_Entity.ID'
          'Comp_index_ID_1': [None,returnStarInt,'Entity_comp_index.ID',True],                                # Pointer to '_Entity_comp_index.ID'
          'Seq_ID_1': [None,returnStarInt,'Entity_poly_seq.Num',True],                                        # Pointer to '_Entity_poly_seq.Num'
          'Comp_ID_1': [None,lambda x = value: returnStarCode(x,length = 12),'Chem_comp.ID',True],            # Pointer to '_Chem_comp.ID'
          'Atom_ID_1': [None,lambda x = value: returnStarAtCode(x,length = 12),'Chem_comp_atom.Atom_ID',True],# Pointer to '_Chem_comp_atom.Atom_ID'
          'Atom_type_1': [None,lambda x = value: returnStarCode(x,length = 15),None,True],                    # Standard symbol used to define the atom element type.
          'Atom_isotope_number_1': [None,returnStarInt,None,False],                                           # The mass number for the chemical element defined by the tag '_Atom_type' or any of its related tags.
          'Assembly_atom_ID_2': [None,returnStarInt,'Atom.Assembly_atom_ID',False],                           # Pointer to '_Atom.Assembly_atom_ID'
          'Entity_assembly_ID_2': [None,returnStarInt,'Entity_assembly.ID',True],                             # Pointer to '_Entity_assembly.ID'
          'Entity_ID_2': [None,returnStarInt,'Entity.ID',True],                                               # Pointer to '_Entity.ID'
          'Comp_index_ID_2': [None,returnStarInt,'Entity_comp_index.ID',True],                                # Pointer to '_Entity_comp_index.ID'
          'Seq_ID_2': [None,returnStarInt,'Entity_poly_seq.Num',True],                                        # Pointer to '_Entity_poly_seq.Num'
          'Comp_ID_2': [None,lambda x = value: returnStarCode(x,length = 12),'Chem_comp.ID',True],            # Pointer to '_Chem_comp.ID'
          'Atom_ID_2': [None,lambda x = value: returnStarAtCode(x,length = 12),'Chem_comp_atom.Atom_ID',True],# Pointer to '_Chem_comp_atom.Atom_ID'
          'Atom_type_2': [None,lambda x = value: returnStarCode(x,length = 15),None,True],                    # Standard symbol used to define the atom element type.
          'Atom_isotope_number_2': [None,returnStarInt,None,False],                                           # The mass number for the chemical element defined by the tag '_Atom_type' or any of its related tags.
          'Val': [None,returnStarFloat,None,True],                                                            # Heteronuclear NOE value
          'Val_err': [None,returnStarFloat,None,False],                                                       # Estimated error in the heteronuclear NOE value
          'Resonance_ID_1': [None,returnStarInt,'Resonance.ID',False],                                        # Pointer to '_Resonance.ID'
          'Resonance_ID_2': [None,returnStarInt,'Resonance.ID',False],                                        # Pointer to '_Resonance.ID'
          'Auth_entity_assembly_ID_1': [None,lambda x = value: returnStarCode(x,length = 15),None,False],     # An alternative identifier for Entity_assembly_ID that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Entity_assembly_ID.
          'Auth_seq_ID_1': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                 # An alternative identifier for Seq_id that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Seq_ID or Comp_index_ID.
          'Auth_comp_ID_1': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                # An alternative identifier for Comp_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Auth_atom_ID_1': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                # An alternative identifier for Atom_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Auth_entity_assembly_ID_2': [None,lambda x = value: returnStarCode(x,length = 15),None,False],     # An alternative identifier for Entity_assembly_ID that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Entity_assembly_ID.
          'Auth_seq_ID_2': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                 # An alternative identifier for Seq_id that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Seq_ID or Comp_index_ID.
          'Auth_comp_ID_2': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                # An alternative identifier for Comp_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Auth_atom_ID_2': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                # An alternative identifier for Atom_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Heteronucl_NOE_list_ID': [None,returnStarInt,'Heteronucl_NOE_list.ID',True],                       # Pointer to '_Heteronucl_NOE_list.ID'

                },

        'tagNames': ['ID', 'Assembly_atom_ID_1', 'Entity_assembly_ID_1', 'Entity_ID_1', 'Comp_index_ID_1', 'Seq_ID_1', 'Comp_ID_1', 'Atom_ID_1', 'Atom_type_1', 'Atom_isotope_number_1', 'Assembly_atom_ID_2', 'Entity_assembly_ID_2', 'Entity_ID_2', 'Comp_index_ID_2', 'Seq_ID_2', 'Comp_ID_2', 'Atom_ID_2', 'Atom_type_2', 'Atom_isotope_number_2', 'Val', 'Val_err', 'Resonance_ID_1', 'Resonance_ID_2', 'Auth_entity_assembly_ID_1', 'Auth_seq_ID_1', 'Auth_comp_ID_1', 'Auth_atom_ID_1', 'Auth_entity_assembly_ID_2', 'Auth_seq_ID_2', 'Auth_comp_ID_2', 'Auth_atom_ID_2', 'Entry_ID', 'Heteronucl_NOE_list_ID'],
        'sourcePrimaryKeys': ['ID', 'Entry_ID', 'Heteronucl_NOE_list_ID'],

            }

        },

    'tableNames': ['Heteronucl_NOE_experiment', 'Heteronucl_NOE_software', 'Heteronucl_NOE']

    },

  'heteronucl_T1_relaxation': {

    'name': 'Heteronucl_T1_list',

    'tags': {

      'Sf_category': ['heteronucl_T1_relaxation',lambda x = value: returnStarCode(x,length = 127),None,True], # Category definition for the information content of the saveframe
      'Sf_framecode': [None,lambda x = value: returnStarCode(x,length = 127),None,False],                     # A label for the saveframe that describes in very brief terms the information contained in the saveframe.
      'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                     # Pointer to '_Entry.ID'
      'ID': [None,returnStarInt,None,True],                                                                   # An integer value that uniquely identifies this saveframe of heteronuclear T1 data from other saveframes of this category in an entry.
      'Data_file_name': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                   # The name of the file submitted with this depostion that contains the quantitative data for this saveframe.
      'Sample_condition_list_ID': [None,returnStarInt,'Sample_condition_list.ID',True],                       # Pointer to '_Sample_condition_list.ID'
      'Sample_condition_list_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Sample_condition_list.Sf_framecode',True],# The label for the set of experimental sample conditions used to collect the data for determination of the heteronuclear T1 relaxation values.
      'Spectrometer_frequency_1H': [None,returnStarFloat,None,True],                                          # The operating proton frequency in MHz of the NMR spectrometer used to collect the data.
      'T1_coherence_type': [None,lambda x = value: returnStarLine(x,length = 31),None,True],                  # A code describing the nuclei involved in the measured T1 coherence.
      'T1_val_units': [None,lambda x = value: returnStarCode(x,length = 15),None,True],                       # The units used for the reported T1 relaxation values.  This will define the form of the reported data as either time or rate.
      'Details': [None,returnStarString,None,False],                                                          # Text describing the reported heteronuclear T1 relaxation data.
      'Text_data_format': [None,lambda x = value: returnStarLine(x,length = 31),None,False],                  # The data format used to represent the heteronuclear T1 relaxation data as ASCII text in the text block that is the value to the '_Heteronucl_T1_list.Text_data' tag.
      'Text_data': [None,returnStarString,None,False],                                                        # A set of heteronuclear T1 relaxation data formatted as ASCII text.

            },

    'tagNames': ['Sf_category', 'Sf_framecode', 'Entry_ID', 'ID', 'Data_file_name', 'Sample_condition_list_ID', 'Sample_condition_list_label', 'Spectrometer_frequency_1H', 'T1_coherence_type', 'T1_val_units', 'Details', 'Text_data_format', 'Text_data'],
    'sourcePrimaryKeys': ['Entry_ID', 'ID'],

    'tables': {

      'Heteronucl_T1_experiment': {

        'tags': {

          'Experiment_ID': [None,returnStarInt,'Experiment.ID',True],                                         # Pointer to '_Experiment.ID'
          'Experiment_name': [None,lambda x = value: returnStarLine(x,length = 127),'Experiment.Name',False], # Pointer to a saveframe of the category 'NMR_spectrometer_expt'
          'Sample_ID': [None,returnStarInt,'Sample.ID',True],                                                 # Pointer to '_Sample.ID'
          'Sample_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Sample.Sf_framecode',True],# Pointer to a saveframe of the category 'sample'
          'Sample_state': [None,lambda x = value: returnStarLine(x,length = 31),None,True],                   # Physical state of the sample either anisotropic or isotropic.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Heteronucl_T1_list_ID': [None,returnStarInt,'Heteronucl_T1_list.ID',True],                         # Pointer to '_Heteronucl_T1_list.ID'

                },

        'tagNames': ['Experiment_ID', 'Experiment_name', 'Sample_ID', 'Sample_label', 'Sample_state', 'Entry_ID', 'Heteronucl_T1_list_ID'],
        'sourcePrimaryKeys': ['Experiment_ID', 'Sample_ID', 'Sample_state', 'Entry_ID', 'Heteronucl_T1_list_ID'],

            },

      'Heteronucl_T1_software': {

        'tags': {

          'Software_ID': [None,returnStarInt,'Software.ID',True],                                             # Pointer to '_Software.ID'
          'Software_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Software.Sf_framecode',True],# Pointer to a saveframe of the category 'software'
          'Method_ID': [None,returnStarInt,'Method.ID',False],                                                # Pointer to '_Method.ID'
          'Method_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Method.Sf_framecode',False],# Pointer to a saveframe of the category 'method'
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Heteronucl_T1_list_ID': [None,returnStarInt,'Heteronucl_T1_list.ID',True],                         # Pointer to '_Heteronucl_T1_list.ID'

                },

        'tagNames': ['Software_ID', 'Software_label', 'Method_ID', 'Method_label', 'Entry_ID', 'Heteronucl_T1_list_ID'],
        'sourcePrimaryKeys': ['Software_ID', 'Entry_ID', 'Heteronucl_T1_list_ID'],

            },

      'T1': {

        'tags': {

          'ID': [None,returnStarInt,None,True],                                                               # Unique identifier for the observed T1 relaxation value.
          'Assembly_atom_ID': [None,returnStarInt,'Atom.Assembly_atom_ID',False],                             # Pointer to '_Atom.Assembly_atom_ID'
          'Entity_assembly_ID': [None,returnStarInt,'Entity_assembly.ID',True],                               # Pointer to '_Entity_assembly.ID'
          'Entity_ID': [None,returnStarInt,'Entity.ID',True],                                                 # Pointer to '_Entity.ID'
          'Comp_index_ID': [None,returnStarInt,'Entity_comp_index.ID',True],                                  # Pointer to '_Entity_comp_index.ID'
          'Seq_ID': [None,returnStarInt,'Entity_poly_seq.Num',True],                                          # Pointer to '_Entity_poly_seq.Num'
          'Comp_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Chem_comp.ID',True],              # Pointer to '_Chem_comp.ID'
          'Atom_ID': [None,lambda x = value: returnStarAtCode(x,length = 12),'Chem_comp_atom.Atom_ID',True],  # Pointer to '_Chem_comp_atom.Atom_ID'
          'Atom_type': [None,lambda x = value: returnStarCode(x,length = 15),None,True],                      # The value for this tag is a standard IUPAC abbreviation for an element (i.e.$ H$ C$ P$ etc).
          'Atom_isotope_number': [None,returnStarInt,None,False],                                             # The mass number for the chemical element defined by the tag '_Atom_type' or any of its related tags.
          'Val': [None,returnStarFloat,None,True],                                                            # The T1 relaxation value.
          'Val_err': [None,returnStarFloat,None,False],                                                       # The estimated error in the reported T1 relaxation value.
          'Resonance_ID': [None,returnStarInt,'Resonance.ID',False],                                          # Pointer to '_Resonance.ID'
          'Auth_entity_assembly_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],       # An alternative identifier for Entity_assembly_ID that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Entity_assembly_ID.
          'Auth_seq_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                   # An alternative identifier for Seq_id that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Seq_ID or Comp_index_ID.
          'Auth_comp_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                  # An alternative identifier for Comp_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Auth_atom_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                  # An alternative identifier for Atom_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Heteronucl_T1_list_ID': [None,returnStarInt,'Heteronucl_T1_list.ID',True],                         # Pointer to '_Heteronucl_T1_list.ID'

                },

        'tagNames': ['ID', 'Assembly_atom_ID', 'Entity_assembly_ID', 'Entity_ID', 'Comp_index_ID', 'Seq_ID', 'Comp_ID', 'Atom_ID', 'Atom_type', 'Atom_isotope_number', 'Val', 'Val_err', 'Resonance_ID', 'Auth_entity_assembly_ID', 'Auth_seq_ID', 'Auth_comp_ID', 'Auth_atom_ID', 'Entry_ID', 'Heteronucl_T1_list_ID'],
        'sourcePrimaryKeys': ['ID', 'Entry_ID', 'Heteronucl_T1_list_ID'],

            }

        },

    'tableNames': ['Heteronucl_T1_experiment', 'Heteronucl_T1_software', 'T1']

    },

  'heteronucl_T1rho_relaxation': {

    'name': 'Heteronucl_T1rho_list',

    'tags': {

      'Sf_category': ['heteronucl_T1rho_relaxation',lambda x = value: returnStarCode(x,length = 127),None,True],# Category definition for the information content of the saveframe
      'Sf_framecode': [None,lambda x = value: returnStarCode(x,length = 127),None,False],                     # A label for the saveframe that describes in very brief terms the information contained in the saveframe.
      'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                     # Pointer to '_Entry.ID'
      'ID': [None,returnStarInt,None,True],                                                                   # An integer value that uniquely identifies this saveframe of heteronuclear T1rho data from other saveframes of this category in an entry.
      'Data_file_name': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                   # The name of the file submitted with this depostion that contains the quantitative data for this saveframe.
      'Sample_condition_list_ID': [None,returnStarInt,'Sample_condition_list.ID',True],                       # Pointer to '_Sample_condition_list.ID'
      'Sample_condition_list_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Sample_condition_list.Sf_framecode',True],# The label for the set of experimental sample conditions used to collect the data for determination of the heteronuclear T1rho relaxation values.
      'Spectrometer_frequency_1H': [None,returnStarFloat,None,True],                                          # The operating proton frequency in MHz of the NMR spectrometer used to collect the data.
      'Temp_calibration_method': [None,lambda x = value: returnStarString(x,length = 255),None,False],        # Method used to calibrate the temperature unit on the NMR spectrometer used to collect the experimental data.
      'Temp_control_method': [None,lambda x = value: returnStarString(x,length = 255),None,False],            # Method used to control the temperature of the sample to eliminate heating caused by the long spin-lock pulse.
      'T1rho_coherence_type': [None,lambda x = value: returnStarLine(x,length = 31),None,True],               # A code describing the nuclei involved in the measured T1rho coherence.
      'T1rho_val_units': [None,lambda x = value: returnStarCode(x,length = 15),None,True],                    # The units used for the reported T1rho relaxation values.
      'Rex_units': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                         # The units used for the reported R exchange values.
      'Details': [None,returnStarString,None,False],                                                          # Text describing the reported heteronuclear Trho relaxation data.
      'Text_data_format': [None,lambda x = value: returnStarLine(x,length = 31),None,False],                  # The data format used to represent the heteronuclear T1rho relaxation data as ASCII text in the text block that is the value to the '_Heteronucl_T1rho.Text_data' tag.
      'Text_data': [None,returnStarString,None,False],                                                        # A set of heteronuclear T1rho relaxation data formatted as ASCII text.

            },

    'tagNames': ['Sf_category', 'Sf_framecode', 'Entry_ID', 'ID', 'Data_file_name', 'Sample_condition_list_ID', 'Sample_condition_list_label', 'Spectrometer_frequency_1H', 'Temp_calibration_method', 'Temp_control_method', 'T1rho_coherence_type', 'T1rho_val_units', 'Rex_units', 'Details', 'Text_data_format', 'Text_data'],
    'sourcePrimaryKeys': ['Entry_ID', 'ID'],

    'tables': {

      'Heteronucl_T1rho_experiment': {

        'tags': {

          'Experiment_ID': [None,returnStarInt,'Experiment.ID',True],                                         # Pointer to '_Experiment.ID'
          'Experiment_name': [None,lambda x = value: returnStarLine(x,length = 127),'Experiment.Name',False], # Pointer to a saveframe of the category 'NMR_spectrometer_expt'
          'Sample_ID': [None,returnStarInt,'Sample.ID',True],                                                 # Pointer to '_Sample.ID'
          'Sample_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Sample.Sf_framecode',True],# Pointer to a saveframe of the category 'sample'
          'Sample_state': [None,lambda x = value: returnStarLine(x,length = 31),None,True],                   # Physical state of the sample either anisotropic or isotropic.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Heteronucl_T1rho_list_ID': [None,returnStarInt,'Heteronucl_T1rho_list.ID',True],                   # Pointer to '_Heteronucl_T1rho_list.ID'

                },

        'tagNames': ['Experiment_ID', 'Experiment_name', 'Sample_ID', 'Sample_label', 'Sample_state', 'Entry_ID', 'Heteronucl_T1rho_list_ID'],
        'sourcePrimaryKeys': ['Experiment_ID', 'Sample_ID', 'Sample_state', 'Entry_ID', 'Heteronucl_T1rho_list_ID'],

            },

      'Heteronucl_T1rho_software': {

        'tags': {

          'Software_ID': [None,returnStarInt,'Software.ID',True],                                             # Pointer to '_Software.ID'
          'Software_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Software.Sf_framecode',True],# Pointer to a saveframe of the category 'software'
          'Method_ID': [None,returnStarInt,'Method.ID',False],                                                # Pointer to '_Method.ID'
          'Method_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Method.Sf_framecode',False],# Pointer to a saveframe of the category 'method'
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Heteronucl_T1rho_list_ID': [None,returnStarInt,'Heteronucl_T1rho_list.ID',True],                   # Pointer to '_Heteronucl_T1rho_list.ID'

                },

        'tagNames': ['Software_ID', 'Software_label', 'Method_ID', 'Method_label', 'Entry_ID', 'Heteronucl_T1rho_list_ID'],
        'sourcePrimaryKeys': ['Software_ID', 'Entry_ID', 'Heteronucl_T1rho_list_ID'],

            },

      'T1rho': {

        'tags': {

          'ID': [None,returnStarInt,None,True],                                                               # Unique identifier for the observed T1rho relaxation value.
          'Assembly_atom_ID': [None,returnStarInt,'Atom.Assembly_atom_ID',False],                             # Pointer to '_Atom.Assembly_atom_ID'
          'Entity_assembly_ID': [None,returnStarInt,'Entity_assembly.ID',True],                               # Pointer to '_Entity_assembly.ID'
          'Entity_ID': [None,returnStarInt,'Entity.ID',True],                                                 # Pointer to '_Entity.ID'
          'Comp_index_ID': [None,returnStarInt,'Entity_comp_index.ID',True],                                  # Pointer to '_Entity_comp_index.ID'
          'Seq_ID': [None,returnStarInt,'Entity_poly_seq.Num',True],                                          # Pointer to '_Entity_poly_seq.Num'
          'Comp_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Chem_comp.ID',True],              # Pointer to '_Chem_comp.ID'
          'Atom_ID': [None,lambda x = value: returnStarAtCode(x,length = 12),'Chem_comp_atom.Atom_ID',True],  # Pointer to '_Chem_comp_atom.Atom_ID'
          'Atom_type': [None,lambda x = value: returnStarCode(x,length = 15),None,True],                      # The value for this tag is a standard IUPAC abbreviation for an element (i.e.$ H$ C$ P$ etc).
          'Atom_isotope_number': [None,returnStarInt,None,False],                                             # The mass number for the chemical element defined by the tag '_Atom_type' or any of its related tags.
          'T1rho_val': [None,returnStarFloat,None,True],                                                      # The T1rho relaxation value.
          'T1rho_val_err': [None,returnStarFloat,None,False],                                                 # The estimated error in the reported T1rho relaxation value.
          'Rex_val': [None,returnStarFloat,None,False],                                                       # The exchange broadening contribution value.
          'Rex_val_err': [None,returnStarFloat,None,False],                                                   # The estimated error in the fitted exchange broadening contribution value.
          'Resonance_ID': [None,returnStarInt,'Resonance.ID',False],                                          # Pointer to '_Resonance.ID'
          'Auth_entity_assembly_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],       # An alternative identifier for Entity_assembly_ID that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Entity_assembly_ID.
          'Auth_seq_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                   # An alternative identifier for Seq_id that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Seq_ID or Comp_index_ID.
          'Auth_comp_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                  # An alternative identifier for Comp_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Auth_atom_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                  # An alternative identifier for Atom_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Heteronucl_T1rho_list_ID': [None,returnStarInt,'Heteronucl_T1rho_list.ID',True],                   # Pointer to '_Heteronucl_T1rho_list.ID'

                },

        'tagNames': ['ID', 'Assembly_atom_ID', 'Entity_assembly_ID', 'Entity_ID', 'Comp_index_ID', 'Seq_ID', 'Comp_ID', 'Atom_ID', 'Atom_type', 'Atom_isotope_number', 'T1rho_val', 'T1rho_val_err', 'Rex_val', 'Rex_val_err', 'Resonance_ID', 'Auth_entity_assembly_ID', 'Auth_seq_ID', 'Auth_comp_ID', 'Auth_atom_ID', 'Entry_ID', 'Heteronucl_T1rho_list_ID'],
        'sourcePrimaryKeys': ['ID', 'Entry_ID', 'Heteronucl_T1rho_list_ID'],

            }

        },

    'tableNames': ['Heteronucl_T1rho_experiment', 'Heteronucl_T1rho_software', 'T1rho']

    },

  'heteronucl_T2_relaxation': {

    'name': 'Heteronucl_T2_list',

    'tags': {

      'Sf_category': ['heteronucl_T2_relaxation',lambda x = value: returnStarCode(x,length = 127),None,True], # Category definition for the information content of the saveframe
      'Sf_framecode': [None,lambda x = value: returnStarCode(x,length = 127),None,False],                     # A label for the saveframe that describes in very brief terms the information contained in the saveframe.
      'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                     # Pointer to '_Entry.ID'
      'ID': [None,returnStarInt,None,True],                                                                   # An integer value that uniquely identifies this saveframe of heteronuclear T2 data from other saveframes of this category in an entry.
      'Data_file_name': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                   # The name of the file submitted with this depostion that contains the quantitative data for this saveframe.
      'Sample_condition_list_ID': [None,returnStarInt,'Sample_condition_list.ID',True],                       # Pointer to '_Sample_condition_list.ID'
      'Sample_condition_list_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Sample_condition_list.Sf_framecode',True],# The label for the set of experimental sample conditions used to collect the data for determination of the heteronuclear T2 relaxation values.
      'Temp_calibration_method': [None,lambda x = value: returnStarString(x,length = 255),None,False],        # Method used to calibrate the temperature unit on the NMR spectrometer used to collect the experimental data.
      'Temp_control_method': [None,lambda x = value: returnStarString(x,length = 255),None,False],            # Method used to control the temperature of the sample to eliminate heating caused by the long spin-lock pulse.
      'Spectrometer_frequency_1H': [None,returnStarFloat,None,True],                                          # The operating proton frequency in MHz of the NMR spectrometer used to collect the data.
      'T2_coherence_type': [None,lambda x = value: returnStarLine(x,length = 31),None,True],                  # A code describing the nuclei involved in the measured T2 coherence.
      'T2_val_units': [None,lambda x = value: returnStarCode(x,length = 15),None,True],                       # The units used for the reported T2 relaxation values.
      'Rex_units': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                         # The units used for the reported R exchange values.
      'Details': [None,returnStarString,None,False],                                                          # Text describing the reported heteronuclear T2 relaxation data.
      'Text_data_format': [None,lambda x = value: returnStarLine(x,length = 31),None,False],                  # The data format used to represent the heteronuclear T2 relaxation data as ASCII text in the text block that is the value to the '_Heteronucl_T2_list.Text_data' tag.
      'Text_data': [None,returnStarString,None,False],                                                        # A set of heteronuclear T2 relaxation data formatted as ASCII text.

            },

    'tagNames': ['Sf_category', 'Sf_framecode', 'Entry_ID', 'ID', 'Data_file_name', 'Sample_condition_list_ID', 'Sample_condition_list_label', 'Temp_calibration_method', 'Temp_control_method', 'Spectrometer_frequency_1H', 'T2_coherence_type', 'T2_val_units', 'Rex_units', 'Details', 'Text_data_format', 'Text_data'],
    'sourcePrimaryKeys': ['Entry_ID', 'ID'],

    'tables': {

      'Heteronucl_T2_experiment': {

        'tags': {

          'Experiment_ID': [None,returnStarInt,'Experiment.ID',True],                                         # Pointer to '_Experiment.ID'
          'Experiment_name': [None,lambda x = value: returnStarLine(x,length = 127),'Experiment.Name',False], # Pointer to a saveframe of the category 'NMR_spectrometer_expt'
          'Sample_ID': [None,returnStarInt,'Sample.ID',True],                                                 # Pointer to '_Sample.ID'
          'Sample_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Sample.Sf_framecode',True],# Pointer to a saveframe of the category 'sample'
          'Sample_state': [None,lambda x = value: returnStarLine(x,length = 31),None,True],                   # Physical state of the sample either anisotropic or isotropic.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Heteronucl_T2_list_ID': [None,returnStarInt,'Heteronucl_T2_list.ID',True],                         # Pointer to '_Heteronucl_T2_list.ID'

                },

        'tagNames': ['Experiment_ID', 'Experiment_name', 'Sample_ID', 'Sample_label', 'Sample_state', 'Entry_ID', 'Heteronucl_T2_list_ID'],
        'sourcePrimaryKeys': ['Experiment_ID', 'Sample_ID', 'Sample_state', 'Entry_ID', 'Heteronucl_T2_list_ID'],

            },

      'Heteronucl_T2_software': {

        'tags': {

          'Software_ID': [None,returnStarInt,'Software.ID',True],                                             # Pointer to '_Software.ID'
          'Software_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Software.Sf_framecode',True],# Pointer to a saveframe of the category 'software'
          'Method_ID': [None,returnStarInt,'Method.ID',False],                                                # Pointer to '_Method.ID'
          'Method_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Method.Sf_framecode',False],# Pointer to a saveframe of the category 'method'
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Heteronucl_T2_list_ID': [None,returnStarInt,'Heteronucl_T2_list.ID',True],                         # Pointer to '_Heteronucl_T2_list.ID'

                },

        'tagNames': ['Software_ID', 'Software_label', 'Method_ID', 'Method_label', 'Entry_ID', 'Heteronucl_T2_list_ID'],
        'sourcePrimaryKeys': ['Software_ID', 'Entry_ID', 'Heteronucl_T2_list_ID'],

            },

      'T2': {

        'tags': {

          'ID': [None,returnStarInt,None,True],                                                               # Unique identifier for the observed T2 relaxation value.
          'Assembly_atom_ID': [None,returnStarInt,'Atom.Assembly_atom_ID',False],                             # Pointer to '_Atom.Assembly_atom_ID'
          'Entity_assembly_ID': [None,returnStarInt,'Entity_assembly.ID',True],                               # Pointer to '_Entity_assembly.ID'
          'Entity_ID': [None,returnStarInt,'Entity.ID',True],                                                 # Pointer to '_Entity.ID'
          'Comp_index_ID': [None,returnStarInt,'Entity_comp_index.ID',True],                                  # Pointer to '_Entity_comp_index.ID'
          'Seq_ID': [None,returnStarInt,'Entity_poly_seq.Num',True],                                          # Pointer to '_Entity_poly_seq.Num'
          'Comp_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Chem_comp.ID',True],              # Pointer to '_Chem_comp.ID'
          'Atom_ID': [None,lambda x = value: returnStarAtCode(x,length = 12),'Chem_comp_atom.Atom_ID',True],  # Pointer to '_Chem_comp_atom.Atom_ID'
          'Atom_type': [None,lambda x = value: returnStarCode(x,length = 15),None,True],                      # The value for this tag is a standard IUPAC abbreviation for an element (i.e.$ H$ C$ P$ etc).
          'Atom_isotope_number': [None,returnStarInt,None,False],                                             # The mass number for the chemical element defined by the tag '_Atom_type' or any of its related tags.
          'T2_val': [None,returnStarFloat,None,True],                                                         # The T2 relaxation value.
          'T2_val_err': [None,returnStarFloat,None,False],                                                    # The estimated error in the reported T2 relaxation value.
          'Rex_val': [None,returnStarFloat,None,False],                                                       # The exchange broadening contribution value.
          'Rex_err': [None,returnStarFloat,None,False],                                                       # The estimated error in the fitted exchange broadening contribution value.
          'Resonance_ID': [None,returnStarInt,'Resonance.ID',False],                                          # Pointer to '_Resonance.ID'
          'Auth_entity_assembly_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],       # An alternative identifier for Entity_assembly_ID that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Entity_assembly_ID.
          'Auth_seq_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                   # An alternative identifier for Seq_id that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Seq_ID or Comp_index_ID.
          'Auth_comp_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                  # An alternative identifier for Comp_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Auth_atom_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                  # An alternative identifier for Atom_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Heteronucl_T2_list_ID': [None,returnStarInt,'Heteronucl_T2_list.ID',True],                         # Pointer to '_Heteronucl_T2_list.ID'

                },

        'tagNames': ['ID', 'Assembly_atom_ID', 'Entity_assembly_ID', 'Entity_ID', 'Comp_index_ID', 'Seq_ID', 'Comp_ID', 'Atom_ID', 'Atom_type', 'Atom_isotope_number', 'T2_val', 'T2_val_err', 'Rex_val', 'Rex_err', 'Resonance_ID', 'Auth_entity_assembly_ID', 'Auth_seq_ID', 'Auth_comp_ID', 'Auth_atom_ID', 'Entry_ID', 'Heteronucl_T2_list_ID'],
        'sourcePrimaryKeys': ['ID', 'Entry_ID', 'Heteronucl_T2_list_ID'],

            }

        },

    'tableNames': ['Heteronucl_T2_experiment', 'Heteronucl_T2_software', 'T2']

    },

  'auto_relaxation': {

    'name': 'Auto_relaxation_list',

    'tags': {

      'Sf_category': ['auto_relaxation',lambda x = value: returnStarCode(x,length = 127),None,True],          # Category definition for the information content of the saveframe
      'Sf_framecode': [None,lambda x = value: returnStarCode(x,length = 127),None,False],                     # A label for the saveframe that describes in very brief terms the information contained in the saveframe.
      'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                     # Pointer to '_Entry.ID'
      'ID': [None,returnStarInt,None,True],                                                                   # An integer value that uniquely identifies this saveframe of general relaxation data from other saveframes of this category in an entry.
      'Data_file_name': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                   # The name of the file submitted with this depostion that contains the quantitative data for this saveframe.
      'Sample_condition_list_ID': [None,returnStarInt,'Sample_condition_list.ID',True],                       # Pointer to '_Sample_condition_list.ID'
      'Sample_condition_list_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Sample_condition_list.Sf_framecode',True],# The label for the set of experimental sample conditions used to collect the data for determination of the general relaxation values.
      'Temp_calibration_method': [None,lambda x = value: returnStarString(x,length = 255),None,False],        # Method used to calibrate the temperature unit on the NMR spectrometer used to collect the experimental data.
      'Temp_control_method': [None,lambda x = value: returnStarString(x,length = 255),None,False],            # Method used to control the temperature of the sample to eliminate heating caused by the long spin-lock pulse.
      'Spectrometer_frequency_1H': [None,returnStarFloat,None,True],                                          # The operating proton frequency in MHz of the NMR spectrometer used to collect the data.
      'Common_relaxation_type_name': [None,lambda x = value: returnStarCode(x,length = 15),None,False],       # Common term used for the type of relaxation phenomena reported.
      'Relaxation_coherence_type': [None,lambda x = value: returnStarLine(x,length = 31),None,True],          # A code describing the spin(s) involved in the measured relaxation coherence.
      'Relaxation_val_units': [None,lambda x = value: returnStarCode(x,length = 15),None,True],               # The units used for the reported relaxation values.
      'Rex_units': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                         # The units used for the reported R exchange values.
      'Details': [None,returnStarString,None,False],                                                          # Text describing the reported relaxation data.
      'Text_data_format': [None,lambda x = value: returnStarLine(x,length = 31),None,False],                  # The data format used to represent the relaxation data as ASCII text in the text block that is the value to the '_Auto_relaxation_list.Text_data' tag.
      'Text_data': [None,returnStarString,None,False],                                                        # A set of relaxation data formatted as ASCII text.

            },

    'tagNames': ['Sf_category', 'Sf_framecode', 'Entry_ID', 'ID', 'Data_file_name', 'Sample_condition_list_ID', 'Sample_condition_list_label', 'Temp_calibration_method', 'Temp_control_method', 'Spectrometer_frequency_1H', 'Common_relaxation_type_name', 'Relaxation_coherence_type', 'Relaxation_val_units', 'Rex_units', 'Details', 'Text_data_format', 'Text_data'],
    'sourcePrimaryKeys': ['Entry_ID', 'ID'],

    'tables': {

      'Auto_relaxation_experiment': {

        'tags': {

          'Experiment_ID': [None,returnStarInt,'Experiment.ID',True],                                         # Pointer to '_Experiment.ID'
          'Experiment_name': [None,lambda x = value: returnStarLine(x,length = 127),'Experiment.Name',False], # Pointer to a saveframe of the category 'NMR_spectrometer_expt'
          'Sample_ID': [None,returnStarInt,'Sample.ID',True],                                                 # Pointer to '_Sample.ID'
          'Sample_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Sample.Sf_framecode',True],# Pointer to a saveframe of the category 'sample'
          'Sample_state': [None,lambda x = value: returnStarLine(x,length = 31),None,True],                   # Physical state of the sample.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Auto_relaxation_list_ID': [None,returnStarInt,'Auto_relaxation_list.ID',True],                     # Pointer to '_Auto_relaxation_list.ID'

                },

        'tagNames': ['Experiment_ID', 'Experiment_name', 'Sample_ID', 'Sample_label', 'Sample_state', 'Entry_ID', 'Auto_relaxation_list_ID'],
        'sourcePrimaryKeys': ['Experiment_ID', 'Sample_ID', 'Sample_state', 'Entry_ID', 'Auto_relaxation_list_ID'],

            },

      'Auto_relaxation_software': {

        'tags': {

          'Software_ID': [None,returnStarInt,'Software.ID',True],                                             # Pointer to '_Software.ID'
          'Software_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Software.Sf_framecode',True],# Pointer to a saveframe of the category 'software'
          'Method_ID': [None,returnStarInt,'Method.ID',False],                                                # Pointer to '_Method.ID'
          'Method_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Method.Sf_framecode',False],# Pointer to a saveframe of the category 'method'
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Auto_relaxation_list_ID': [None,returnStarInt,'Auto_relaxation_list.ID',True],                     # Pointer to '_Auto_relaxation_list.ID'

                },

        'tagNames': ['Software_ID', 'Software_label', 'Method_ID', 'Method_label', 'Entry_ID', 'Auto_relaxation_list_ID'],
        'sourcePrimaryKeys': ['Software_ID', 'Entry_ID', 'Auto_relaxation_list_ID'],

            },

      'Auto_relaxation': {

        'tags': {

          'ID': [None,returnStarInt,None,True],                                                               # Unique identifier for the observed relaxation value.
          'Assembly_ID': [None,returnStarInt,'Assembly.ID',False],                                            # Pointer to '_Assembly.ID'
          'Assembly_atom_ID': [None,returnStarInt,'Atom.Assembly_atom_ID',False],                             # Pointer to '_Atom.Assembly_atom_ID'
          'Entity_assembly_ID': [None,returnStarInt,'Entity_assembly.ID',True],                               # Pointer to '_Entity_assembly.ID'
          'Entity_ID': [None,returnStarInt,'Entity.ID',True],                                                 # Pointer to '_Entity.ID'
          'Comp_index_ID': [None,returnStarInt,'Entity_comp_index.ID',True],                                  # Pointer to '_Entity_comp_index.ID'
          'Seq_ID': [None,returnStarInt,'Entity_poly_seq.Num',True],                                          # Pointer to '_Entity_poly_seq.Num'
          'Comp_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Chem_comp.ID',True],              # Pointer to '_Chem_comp.ID'
          'Atom_ID': [None,lambda x = value: returnStarAtCode(x,length = 12),'Chem_comp_atom.Atom_ID',True],  # Pointer to '_Chem_comp_atom.Atom_ID'
          'Atom_type': [None,lambda x = value: returnStarCode(x,length = 15),None,True],                      # The value for this tag is a standard IUPAC abbreviation for an element (i.e.$ H$ C$ P$ etc).
          'Atom_isotope_number': [None,returnStarInt,None,False],                                             # The mass number for the chemical element defined by the tag '_Atom_type' or any of its related tags.
          'Auto_relaxation_val': [None,returnStarFloat,None,True],                                            # The relaxation value.
          'Auto_relaxation_val_err': [None,returnStarFloat,None,False],                                       # The estimated error in the reported relaxation value.
          'Rex_val': [None,returnStarFloat,None,False],                                                       # The exchange broadening contribution value.
          'Rex_val_err': [None,returnStarFloat,None,False],                                                   # The estimated error in the fitted exchange broadening contribution value.
          'Resonance_ID': [None,returnStarInt,'Resonance.ID',False],                                          # Pointer to '_Resonance.ID'
          'Auth_entity_assembly_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],       # An alternative identifier for Entity_assembly_ID that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Entity_assembly_ID.
          'Auth_seq_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                   # An alternative identifier for Seq_id that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Seq_ID or Comp_index_ID.
          'Auth_comp_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                  # An alternative identifier for Comp_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Auth_atom_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                  # An alternative identifier for Atom_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Auto_relaxation_list_ID': [None,returnStarInt,'Auto_relaxation_list.ID',True],                     # Pointer to '_Auto_relaxation_list.ID'

                },

        'tagNames': ['ID', 'Assembly_ID', 'Assembly_atom_ID', 'Entity_assembly_ID', 'Entity_ID', 'Comp_index_ID', 'Seq_ID', 'Comp_ID', 'Atom_ID', 'Atom_type', 'Atom_isotope_number', 'Auto_relaxation_val', 'Auto_relaxation_val_err', 'Rex_val', 'Rex_val_err', 'Resonance_ID', 'Auth_entity_assembly_ID', 'Auth_seq_ID', 'Auth_comp_ID', 'Auth_atom_ID', 'Entry_ID', 'Auto_relaxation_list_ID'],
        'sourcePrimaryKeys': ['ID', 'Entry_ID', 'Auto_relaxation_list_ID'],

            }

        },

    'tableNames': ['Auto_relaxation_experiment', 'Auto_relaxation_software', 'Auto_relaxation']

    },

  'dipole_dipole_relaxation': {

    'name': 'Dipole_dipole_relax_list',

    'tags': {

      'Sf_category': ['dipole_dipole_relaxation',lambda x = value: returnStarCode(x,length = 127),None,True], # Category definition for the information content of the saveframe
      'Sf_framecode': [None,lambda x = value: returnStarCode(x,length = 127),None,False],                     # A label for the saveframe that describes in very brief terms the information contained in the saveframe.
      'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                     # Pointer to '_Entry.ID'
      'ID': [None,returnStarInt,None,True],                                                                   # Unique identifier for the list of Dipole-dipole relaxation values.
      'Data_file_name': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                   # The name of the file submitted with this depostion that contains the quantitative data for this saveframe.
      'Sample_condition_list_ID': [None,returnStarInt,'Sample_condition_list.ID',True],                       # Pointer to '_Sample_condition_list.ID'
      'Sample_condition_list_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Sample_condition_list.Sf_framecode',True],# The label for the set of experimental sample conditions used to collect the data for determination of the dipole-dipole relaxation values.
      'Spectrometer_frequency_1H': [None,returnStarFloat,None,True],                                          # The operating proton frequency in MHz of the NMR spectrometer used to collect the data.
      'Val_units': [None,lambda x = value: returnStarCode(x,length = 15),None,True],                          # The units used for the reported dipole-dipole relaxation values.
      'Details': [None,returnStarString,None,False],                                                          # Text describing the reported dipole-dipole relaxation data.
      'Text_data_format': [None,lambda x = value: returnStarLine(x,length = 31),None,False],                  # The data format used to represent the dipole-dipole relaxation data as ASCII text in the text block that is the value to the '_Dipole_dipole_relax_list.Text_data' tag.
      'Text_data': [None,returnStarString,None,False],                                                        # A set of dipole-dipole relaxation data formatted as ASCII text.

            },

    'tagNames': ['Sf_category', 'Sf_framecode', 'Entry_ID', 'ID', 'Data_file_name', 'Sample_condition_list_ID', 'Sample_condition_list_label', 'Spectrometer_frequency_1H', 'Val_units', 'Details', 'Text_data_format', 'Text_data'],
    'sourcePrimaryKeys': ['Entry_ID', 'ID'],

    'tables': {

      'Dipole_dipole_relax_experiment': {

        'tags': {

          'Experiment_ID': [None,returnStarInt,'Experiment.ID',True],                                         # Pointer to '_Experiment.ID'
          'Experiment_name': [None,lambda x = value: returnStarLine(x,length = 127),'Experiment.Name',False], # Pointer to a saveframe of the category 'NMR_spectrometer_expt'
          'Sample_ID': [None,returnStarInt,'Sample.ID',True],                                                 # Pointer to '_Sample.ID'
          'Sample_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Sample.Sf_framecode',True],# Pointer to a saveframe of the category 'sample'
          'Sample_state': [None,lambda x = value: returnStarLine(x,length = 31),None,True],                   # Physical state of the sample either anisotropic or isotropic.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Dipole_dipole_relax_list_ID': [None,returnStarInt,'Dipole_dipole_relax_list.ID',True],             # Pointer to '_Dipole_dipole_relax_list.ID'

                },

        'tagNames': ['Experiment_ID', 'Experiment_name', 'Sample_ID', 'Sample_label', 'Sample_state', 'Entry_ID', 'Dipole_dipole_relax_list_ID'],
        'sourcePrimaryKeys': ['Experiment_ID', 'Sample_ID', 'Sample_state', 'Entry_ID', 'Dipole_dipole_relax_list_ID'],

            },

      'Dipole_dipole_relax_software': {

        'tags': {

          'Software_ID': [None,returnStarInt,'Software.ID',True],                                             # Pointer to '_Software.ID'
          'Software_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Software.Sf_framecode',True],# Pointer to a saveframe of the category 'software'
          'Method_ID': [None,returnStarInt,'Method.ID',False],                                                # Pointer to '_Method.ID'
          'Method_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Method.Sf_framecode',False],# Pointer to a saveframe of the category 'method'
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Dipole_dipole_relax_list_ID': [None,returnStarInt,'Dipole_dipole_relax_list.ID',True],             # Pointer to '_Dipole_dipole_relax_list.ID'

                },

        'tagNames': ['Software_ID', 'Software_label', 'Method_ID', 'Method_label', 'Entry_ID', 'Dipole_dipole_relax_list_ID'],
        'sourcePrimaryKeys': ['Software_ID', 'Entry_ID', 'Dipole_dipole_relax_list_ID'],

            },

      'Dipole_dipole_relax': {

        'tags': {

          'ID': [None,returnStarInt,None,True],                                                               # Unique identifier for the observed dipole-dipole relaxation value.
          'Assembly_atom_ID_1': [None,returnStarInt,'Atom.Assembly_atom_ID',False],                           # Pointer to '_Atom.Assembly_atom_ID'
          'Entity_assembly_ID_1': [None,returnStarInt,'Entity_assembly.ID',True],                             # Pointer to '_Entity_assembly.ID'
          'Entity_ID_1': [None,returnStarInt,'Entity.ID',True],                                               # Pointer to '_Entity.ID'
          'Comp_index_ID_1': [None,returnStarInt,'Entity_comp_index.ID',True],                                # Pointer to '_Entity_comp_index.ID'
          'Seq_ID_1': [None,returnStarInt,'Entity_poly_seq.Num',True],                                        # Pointer to '_Entity_poly_seq.Num'
          'Comp_ID_1': [None,lambda x = value: returnStarCode(x,length = 12),'Chem_comp.ID',True],            # Pointer to '_Chem_comp.ID'
          'Atom_ID_1': [None,lambda x = value: returnStarAtCode(x,length = 12),'Chem_comp_atom.Atom_ID',True],# Pointer to '_Chem_comp_atom.Atom_ID'
          'Atom_type_1': [None,lambda x = value: returnStarCode(x,length = 15),None,True],                    # Standard symbol used to define the atom element type.
          'Atom_isotope_number_1': [None,returnStarInt,None,False],                                           # The mass number for the chemical element defined by the tag '_Atom_type' or any of its related tags.
          'Assembly_atom_ID_2': [None,returnStarInt,'Atom.Assembly_atom_ID',False],                           # Pointer to '_Atom.Assembly_atom_ID'
          'Entity_assembly_ID_2': [None,returnStarInt,'Entity_assembly.ID',True],                             # Pointer to '_Entity_assembly.ID'
          'Entity_ID_2': [None,returnStarInt,'Entity.ID',True],                                               # Pointer to '_Entity.ID'
          'Comp_index_ID_2': [None,returnStarInt,'Entity_comp_index.ID',True],                                # Pointer to '_Entity_comp_index.ID'
          'Seq_ID_2': [None,returnStarInt,'Entity_poly_seq.Num',True],                                        # Pointer to '_Entity_poly_seq.Num'
          'Comp_ID_2': [None,lambda x = value: returnStarCode(x,length = 12),'Chem_comp.ID',True],            # Pointer to '_Chem_comp.ID'
          'Atom_ID_2': [None,lambda x = value: returnStarAtCode(x,length = 12),'Chem_comp_atom.Atom_ID',True],# Pointer to '_Chem_comp_atom.Atom_ID'
          'Atom_type_2': [None,lambda x = value: returnStarCode(x,length = 15),None,True],                    # Standard symbol used to define the atom element type.
          'Atom_isotope_number_2': [None,returnStarInt,None,False],                                           # The mass number for the chemical element defined by the tag '_Atom_type' or any of its related tags.
          'Val': [None,returnStarFloat,None,True],                                                            # The dipole-dipole relaxation value.
          'Val_err': [None,returnStarFloat,None,False],                                                       # The estimated error in the reported dipole-dipole relaxation value.
          'Resonance_ID_1': [None,returnStarInt,'Resonance.ID',False],                                        # Pointer to '_Resonance.ID'
          'Resonance_ID_2': [None,returnStarInt,'Resonance.ID',False],                                        # Pointer to '_Resonance.ID'
          'Auth_entity_assembly_ID_1': [None,lambda x = value: returnStarCode(x,length = 15),None,False],     # An alternative identifier for Entity_assembly_ID that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Entity_assembly_ID.
          'Auth_seq_ID_1': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                 # An alternative identifier for Seq_id that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Seq_ID or Comp_index_ID.
          'Auth_comp_ID_1': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                # An alternative identifier for Comp_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Auth_atom_ID_1': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                # An alternative identifier for Atom_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Auth_entity_assembly_ID_2': [None,lambda x = value: returnStarCode(x,length = 15),None,False],     # An alternative identifier for Entity_assembly_ID that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Entity_assembly_ID.
          'Auth_seq_ID_2': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                 # An alternative identifier for Seq_id that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Seq_ID or Comp_index_ID.
          'Auth_comp_ID_2': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                # An alternative identifier for Comp_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Auth_atom_ID_2': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                # An alternative identifier for Atom_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Dipole_dipole_relax_list_ID': [None,returnStarInt,'Dipole_dipole_relax_list.ID',True],             # Pointer to '_Dipole_dipole_relax_list.ID'

                },

        'tagNames': ['ID', 'Assembly_atom_ID_1', 'Entity_assembly_ID_1', 'Entity_ID_1', 'Comp_index_ID_1', 'Seq_ID_1', 'Comp_ID_1', 'Atom_ID_1', 'Atom_type_1', 'Atom_isotope_number_1', 'Assembly_atom_ID_2', 'Entity_assembly_ID_2', 'Entity_ID_2', 'Comp_index_ID_2', 'Seq_ID_2', 'Comp_ID_2', 'Atom_ID_2', 'Atom_type_2', 'Atom_isotope_number_2', 'Val', 'Val_err', 'Resonance_ID_1', 'Resonance_ID_2', 'Auth_entity_assembly_ID_1', 'Auth_seq_ID_1', 'Auth_comp_ID_1', 'Auth_atom_ID_1', 'Auth_entity_assembly_ID_2', 'Auth_seq_ID_2', 'Auth_comp_ID_2', 'Auth_atom_ID_2', 'Entry_ID', 'Dipole_dipole_relax_list_ID'],
        'sourcePrimaryKeys': ['ID', 'Entry_ID', 'Dipole_dipole_relax_list_ID'],

            }

        },

    'tableNames': ['Dipole_dipole_relax_experiment', 'Dipole_dipole_relax_software', 'Dipole_dipole_relax']

    },

  'dipole_dipole_cross_correlations': {

    'name': 'Cross_correlation_DD_list',

    'tags': {

      'Sf_category': ['dipole_dipole_cross_correlations',lambda x = value: returnStarCode(x,length = 127),None,True],# Category definition for the information content of the saveframe
      'Sf_framecode': [None,lambda x = value: returnStarCode(x,length = 127),None,False],                     # A label for the saveframe that describes in very brief terms the information contained in the saveframe.
      'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                     # Pointer to '_Entry.ID'
      'ID': [None,returnStarInt,None,True],                                                                   # Unique identifier for the list of cross-correlation values.
      'Data_file_name': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                   # The name of the file submitted with this depostion that contains the quantitative data for this saveframe.
      'Sample_condition_list_ID': [None,returnStarInt,'Sample_condition_list.ID',True],                       # Pointer to '_Sample_condition_list.ID'
      'Sample_condition_list_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Sample_condition_list.Sf_framecode',True],# The label for the set of experimental sample conditions used to collect the data for determination of the cross-correlation values.
      'Spectrometer_frequency_1H': [None,returnStarFloat,None,True],                                          # The operating proton frequency in MHz of the NMR spectrometer used to collect the data.
      'Val_units': [None,lambda x = value: returnStarCode(x,length = 15),None,True],                          # Units for the cross correlation values reported.
      'Details': [None,returnStarString,None,False],                                                          # Text describing the reported cross correlation data.
      'Text_data_format': [None,lambda x = value: returnStarLine(x,length = 31),None,False],                  # The data format used to represent the cross-correlation dipole-dipole relaxation data as ASCII text in the text block that is the value to the '_Cross_correlation_DD_list.Text_data' tag.
      'Text_data': [None,returnStarString,None,False],                                                        # A set of cross-correlation dipole-dipole relaxation data formatted as ASCII text.

            },

    'tagNames': ['Sf_category', 'Sf_framecode', 'Entry_ID', 'ID', 'Data_file_name', 'Sample_condition_list_ID', 'Sample_condition_list_label', 'Spectrometer_frequency_1H', 'Val_units', 'Details', 'Text_data_format', 'Text_data'],
    'sourcePrimaryKeys': ['Entry_ID', 'ID'],

    'tables': {

      'Cross_correlation_DD_experiment': {

        'tags': {

          'Experiment_ID': [None,returnStarInt,'Experiment.ID',True],                                         # Pointer to '_Experiment.ID'
          'Experiment_name': [None,lambda x = value: returnStarLine(x,length = 127),'Experiment.Name',False], # Pointer to a saveframe of the category 'NMR_spectrometer_expt'
          'Sample_ID': [None,returnStarInt,'Sample.ID',True],                                                 # Pointer to '_Sample.ID'
          'Sample_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Sample.Sf_framecode',True],# Pointer to a saveframe of the category 'sample'
          'Sample_state': [None,lambda x = value: returnStarLine(x,length = 31),None,True],                   # Physical state of the sample either anisotropic or isotropic.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Cross_correlation_list_ID': [None,returnStarInt,'Cross_correlation_DD_list.ID',True],              # Pointer to '_Cross_correlation_DD_list.ID'

                },

        'tagNames': ['Experiment_ID', 'Experiment_name', 'Sample_ID', 'Sample_label', 'Sample_state', 'Entry_ID', 'Cross_correlation_list_ID'],
        'sourcePrimaryKeys': ['Experiment_ID', 'Sample_ID', 'Sample_state', 'Entry_ID', 'Cross_correlation_list_ID'],

            },

      'Cross_correlation_DD_software': {

        'tags': {

          'Software_ID': [None,returnStarInt,'Software.ID',True],                                             # Pointer to '_Software.ID'
          'Software_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Software.Sf_framecode',True],# Pointer to a saveframe of the category 'software'
          'Method_ID': [None,returnStarInt,'Method.ID',False],                                                # Pointer to '_Method.ID'
          'Method_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Method.Sf_framecode',False],# Pointer to a saveframe of the category 'method'
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Cross_correlation_list_ID': [None,returnStarInt,'Cross_correlation_DD_list.ID',True],              # Pointer to '_Cross_correlation_DD_list.ID'

                },

        'tagNames': ['Software_ID', 'Software_label', 'Method_ID', 'Method_label', 'Entry_ID', 'Cross_correlation_list_ID'],
        'sourcePrimaryKeys': ['Software_ID', 'Entry_ID', 'Cross_correlation_list_ID'],

            },

      'Cross_correlation_DD': {

        'tags': {

          'ID': [None,returnStarInt,None,True],                                                               # Unique identifier for the observed cross-correlation value.
          'Dipole_1_assembly_atom_ID_1': [None,returnStarInt,'Atom.Assembly_atom_ID',False],                  # Pointer to '_Atom.Assembly_atom_ID'
          'Dipole_1_entity_assembly_ID_1': [None,returnStarInt,'Entity_assembly.ID',False],                   # Pointer to '_Entity_assembly.ID'
          'Dipole_1_entity_ID_1': [None,returnStarInt,'Entity.ID',False],                                     # Pointer to '_Entity.ID'
          'Dipole_1_comp_index_ID_1': [None,returnStarInt,'Entity_comp_index.ID',False],                      # Pointer to '_Entity_comp_index.ID'
          'Dipole_1_seq_ID_1': [None,returnStarInt,'Entity_poly_seq.Num',False],                              # Pointer to '_Entity_poly_seq.Num'
          'Dipole_1_comp_ID_1': [None,lambda x = value: returnStarCode(x,length = 12),'Chem_comp.ID',False],  # Pointer to '_Chem_comp.ID'
          'Dipole_1_atom_ID_1': [None,lambda x = value: returnStarAtCode(x,length = 12),'Chem_comp_atom.Atom_ID',False],# Pointer to '_Chem_comp_atom.Atom_ID'
          'Dipole_1_atom_type_1': [None,lambda x = value: returnStarCode(x,length = 15),None,False],          # Standard symbol used to define the atom element type.
          'Dipole_1_atom_isotope_number_1': [None,returnStarInt,None,False],                                  # The mass number for the chemical element defined by the tag '_Atom_type' or any of its related tags.
          'Dipole_1_assembly_atom_ID_2': [None,returnStarInt,'Atom.Assembly_atom_ID',False],                  # Pointer to '_Atom.Assembly_atom_ID'
          'Dipole_1_entity_assembly_ID_2': [None,returnStarInt,'Entity_assembly.ID',False],                   # Pointer to '_Entity_assembly.ID'
          'Dipole_1_entity_ID_2': [None,returnStarInt,'Entity.ID',False],                                     # Pointer to '_Entity.ID'
          'Dipole_1_comp_index_ID_2': [None,returnStarInt,'Entity_comp_index.ID',False],                      # Pointer to '_Entity_comp_index.ID'
          'Dipole_1_seq_ID_2': [None,returnStarInt,'Entity_poly_seq.Num',False],                              # Pointer to '_Entity_poly_seq.Num'
          'Dipole_1_comp_ID_2': [None,lambda x = value: returnStarCode(x,length = 12),'Chem_comp.ID',False],  # Pointer to '_Chem_comp.ID'
          'Dipole_1_atom_ID_2': [None,lambda x = value: returnStarAtCode(x,length = 12),'Chem_comp_atom.Atom_ID',False],# Pointer to '_Chem_comp_atom.Atom_ID'
          'Dipole_1_atom_type_2': [None,lambda x = value: returnStarCode(x,length = 15),None,False],          # Standard symbol used to define the atom element type.
          'Dipole_1_atom_isotope_number_2': [None,returnStarInt,None,False],                                  # The mass number for the chemical element defined by the tag '_Atom_type' or any of its related tags.
          'Dipole_2_assembly_atom_ID_1': [None,returnStarInt,'Atom.Assembly_atom_ID',False],                  # Pointer to '_Atom.Assembly_atom_ID'
          'Dipole_2_entity_assembly_ID_1': [None,returnStarInt,'Entity_assembly.ID',False],                   # Pointer to '_Entity_assembly.ID'
          'Dipole_2_entity_ID_1': [None,returnStarInt,'Entity.ID',False],                                     # Pointer to '_Entity.ID'
          'Dipole_2_comp_index_ID_1': [None,returnStarInt,'Entity_comp_index.ID',False],                      # Pointer to '_Entity_comp_index.ID'
          'Dipole_2_seq_ID_1': [None,returnStarInt,'Entity_poly_seq.Num',False],                              # Pointer to '_Entity_poly_seq.Num'
          'Dipole_2_comp_ID_1': [None,lambda x = value: returnStarCode(x,length = 12),'Chem_comp.ID',False],  # Pointer to '_Chem_comp.ID'
          'Dipole_2_atom_ID_1': [None,lambda x = value: returnStarAtCode(x,length = 12),'Chem_comp_atom.Atom_ID',False],# Pointer to '_Chem_comp_atom.Atom_ID'
          'Dipole_2_atom_type_1': [None,lambda x = value: returnStarCode(x,length = 15),None,False],          # Standard symbol used to define the atom element type.
          'Dipole_2_atom_isotope_number_1': [None,returnStarInt,None,False],                                  # The mass number for the chemical element defined by the tag '_Atom_type' or any of its related tags.
          'Dipole_2_assembly_atom_ID_2': [None,returnStarInt,'Atom.Assembly_atom_ID',False],                  # Pointer to '_Atom.Assembly_atom_ID'
          'Dipole_2_entity_assembly_ID_2': [None,returnStarInt,'Entity_assembly.ID',False],                   # Pointer to '_Entity_assembly.ID'
          'Dipole_2_entity_ID_2': [None,returnStarInt,'Entity.ID',False],                                     # Pointer to '_Entity.ID'
          'Dipole_2_chem_comp_index_ID_2': [None,returnStarInt,'Entity_comp_index.ID',False],                 # Pointer to '_Entity_comp_index.ID'
          'Dipole_2_seq_ID_2': [None,returnStarInt,'Entity_poly_seq.Num',False],                              # Pointer to '_Entity_poly_seq.Num'
          'Dipole_2_comp_ID_2': [None,lambda x = value: returnStarCode(x,length = 12),'Chem_comp.ID',False],  # Pointer to '_Chem_comp.ID'
          'Dipole_2_atom_ID_2': [None,lambda x = value: returnStarAtCode(x,length = 12),'Chem_comp_atom.Atom_ID',False],# Pointer to '_Chem_comp_atom.Atom_ID'
          'Dipole_2_atom_type_2': [None,lambda x = value: returnStarCode(x,length = 15),None,False],          # Standard symbol used to define the atom element type.
          'Dipole_2_atom_isotope_number_2': [None,returnStarInt,None,False],                                  # The mass number for the chemical element defined by the tag '_Atom_type' or any of its related tags.
          'Val': [None,returnStarFloat,None,True],                                                            # The cross-correlation dipole-dipole relaxation value.
          'Val_err': [None,returnStarFloat,None,False],                                                       # The estimated error in the reported cross-correlation dipole-dipole relaxation value.
          'Dipole_1_Resonance_ID_1': [None,returnStarInt,'Resonance.ID',False],                               # Pointer to '_Resonance.ID'
          'Dipole_1_Resonance_ID_2': [None,returnStarInt,'Resonance.ID',False],                               # Pointer to '_Resonance.ID'
          'Dipole_2_Resonance_ID_1': [None,returnStarInt,'Resonance.ID',False],                               # Pointer to '_Resonance.ID'
          'Dipole_2_Resonance_ID_2': [None,returnStarInt,'Resonance.ID',False],                               # Pointer to '_Resonance.ID'
          'Dipole_1_auth_entity_assembly_ID_1': [None,lambda x = value: returnStarCode(x,length = 15),None,False],# An alternative identifier for Entity_assembly_ID that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Entity_assembly_ID.
          'Dipole_1_auth_seq_ID_1': [None,lambda x = value: returnStarCode(x,length = 15),None,False],        # An alternative identifier for Seq_id that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Seq_ID or Comp_index_ID.
          'Dipole_1_auth_comp_ID_1': [None,lambda x = value: returnStarCode(x,length = 15),None,False],       # An alternative identifier for Comp_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Dipole_1_auth_atom_ID_1': [None,lambda x = value: returnStarCode(x,length = 15),None,False],       # An alternative identifier for Atom_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Dipole_1_auth_entity_assembly_ID_2': [None,lambda x = value: returnStarCode(x,length = 15),None,False],# An alternative identifier for Entity_assembly_ID that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Entity_assembly_ID.
          'Dipole_1_auth_seq_ID_2': [None,lambda x = value: returnStarCode(x,length = 15),None,False],        # An alternative identifier for Seq_id that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Seq_ID or Comp_index_ID.
          'Dipole_1_auth_comp_ID_2': [None,lambda x = value: returnStarCode(x,length = 15),None,False],       # An alternative identifier for Comp_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Dipole_1_auth_atom_ID_2': [None,lambda x = value: returnStarCode(x,length = 15),None,False],       # An alternative identifier for Atom_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Dipole_2_auth_entity_assembly_ID_1': [None,lambda x = value: returnStarCode(x,length = 15),None,False],# An alternative identifier for Entity_assembly_ID that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Entity_assembly_ID.
          'Dipole_2_auth_seq_ID_1': [None,lambda x = value: returnStarCode(x,length = 15),None,False],        # An alternative identifier for Seq_id that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Seq_ID or Comp_index_ID.
          'Dipole_2_auth_comp_ID_1': [None,lambda x = value: returnStarCode(x,length = 15),None,False],       # An alternative identifier for Comp_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Dipole_2_auth_atom_ID_1': [None,lambda x = value: returnStarCode(x,length = 15),None,False],       # An alternative identifier for Atom_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Dipole_2_auth_entity_assembly_ID_2': [None,lambda x = value: returnStarCode(x,length = 15),None,False],# An alternative identifier for Entity_assembly_ID that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Entity_assembly_ID.
          'Dipole_2_auth_seq_ID_2': [None,lambda x = value: returnStarCode(x,length = 15),None,False],        # An alternative identifier for Seq_id that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Seq_ID or Comp_index_ID.
          'Dipole_2_auth_comp_ID_2': [None,lambda x = value: returnStarCode(x,length = 15),None,False],       # An alternative identifier for Comp_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Dipole_2_auth_atom_ID_2': [None,lambda x = value: returnStarCode(x,length = 15),None,False],       # An alternative identifier for Atom_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Cross_correlation_list_ID': [None,returnStarInt,'Cross_correlation_DD_list.ID',True],              # Pointer to '_Cross_correlation_DD_list.ID'

                },

        'tagNames': ['ID', 'Dipole_1_assembly_atom_ID_1', 'Dipole_1_entity_assembly_ID_1', 'Dipole_1_entity_ID_1', 'Dipole_1_comp_index_ID_1', 'Dipole_1_seq_ID_1', 'Dipole_1_comp_ID_1', 'Dipole_1_atom_ID_1', 'Dipole_1_atom_type_1', 'Dipole_1_atom_isotope_number_1', 'Dipole_1_assembly_atom_ID_2', 'Dipole_1_entity_assembly_ID_2', 'Dipole_1_entity_ID_2', 'Dipole_1_comp_index_ID_2', 'Dipole_1_seq_ID_2', 'Dipole_1_comp_ID_2', 'Dipole_1_atom_ID_2', 'Dipole_1_atom_type_2', 'Dipole_1_atom_isotope_number_2', 'Dipole_2_assembly_atom_ID_1', 'Dipole_2_entity_assembly_ID_1', 'Dipole_2_entity_ID_1', 'Dipole_2_comp_index_ID_1', 'Dipole_2_seq_ID_1', 'Dipole_2_comp_ID_1', 'Dipole_2_atom_ID_1', 'Dipole_2_atom_type_1', 'Dipole_2_atom_isotope_number_1', 'Dipole_2_assembly_atom_ID_2', 'Dipole_2_entity_assembly_ID_2', 'Dipole_2_entity_ID_2', 'Dipole_2_chem_comp_index_ID_2', 'Dipole_2_seq_ID_2', 'Dipole_2_comp_ID_2', 'Dipole_2_atom_ID_2', 'Dipole_2_atom_type_2', 'Dipole_2_atom_isotope_number_2', 'Val', 'Val_err', 'Dipole_1_Resonance_ID_1', 'Dipole_1_Resonance_ID_2', 'Dipole_2_Resonance_ID_1', 'Dipole_2_Resonance_ID_2', 'Dipole_1_auth_entity_assembly_ID_1', 'Dipole_1_auth_seq_ID_1', 'Dipole_1_auth_comp_ID_1', 'Dipole_1_auth_atom_ID_1', 'Dipole_1_auth_entity_assembly_ID_2', 'Dipole_1_auth_seq_ID_2', 'Dipole_1_auth_comp_ID_2', 'Dipole_1_auth_atom_ID_2', 'Dipole_2_auth_entity_assembly_ID_1', 'Dipole_2_auth_seq_ID_1', 'Dipole_2_auth_comp_ID_1', 'Dipole_2_auth_atom_ID_1', 'Dipole_2_auth_entity_assembly_ID_2', 'Dipole_2_auth_seq_ID_2', 'Dipole_2_auth_comp_ID_2', 'Dipole_2_auth_atom_ID_2', 'Entry_ID', 'Cross_correlation_list_ID'],
        'sourcePrimaryKeys': ['ID', 'Entry_ID', 'Cross_correlation_list_ID'],

            }

        },

    'tableNames': ['Cross_correlation_DD_experiment', 'Cross_correlation_DD_software', 'Cross_correlation_DD']

    },

  'dipole_CSA_cross_correlations': {

    'name': 'Cross_correlation_D_CSA_list',

    'tags': {

      'Sf_category': ['dipole_CSA_cross_correlations',lambda x = value: returnStarCode(x,length = 127),None,True],# Category definition for the information content of the saveframe
      'Sf_framecode': [None,lambda x = value: returnStarCode(x,length = 127),None,False],                     # A label for the saveframe that describes in very brief terms the information contained in the saveframe.
      'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                     # Pointer to '_Entry.ID'
      'ID': [None,returnStarInt,None,True],                                                                   # Unique identifier for the list of cross-correlation values.
      'Data_file_name': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                   # The name of the file submitted with this depostion that contains the quantitative data for this saveframe.
      'Sample_condition_list_ID': [None,returnStarInt,'Sample_condition_list.ID',True],                       # Pointer to '_Sample_condition_list.ID'
      'Sample_condition_list_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Sample_condition_list.Sf_framecode',True],# The label for the set of experimental sample conditions used to collect the data for determination of the cross-correlation values.
      'Spectrometer_frequency_1H': [None,returnStarFloat,None,True],                                          # The operating proton frequency in MHz of the NMR spectrometer used to collect the data.
      'Val_units': [None,lambda x = value: returnStarCode(x,length = 15),None,True],                          # Units for the cross correlation values reported.
      'Details': [None,returnStarString,None,False],                                                          # Text describing the reported cross correlation data.
      'Text_data_format': [None,lambda x = value: returnStarLine(x,length = 31),None,False],                  # The data format used to represent the cross-correlation dipole-CSA relaxation data as ASCII text in the text block that is the value to the '_Assigned_chem_shift.Text_data' tag.
      'Text_data': [None,returnStarString,None,False],                                                        # A set of cross-correlation dipole-CSA relaxation data formatted as ASCII text.

            },

    'tagNames': ['Sf_category', 'Sf_framecode', 'Entry_ID', 'ID', 'Data_file_name', 'Sample_condition_list_ID', 'Sample_condition_list_label', 'Spectrometer_frequency_1H', 'Val_units', 'Details', 'Text_data_format', 'Text_data'],
    'sourcePrimaryKeys': ['Entry_ID', 'ID'],

    'tables': {

      'Cross_correlation_D_CSA_experiment': {

        'tags': {

          'Experiment_ID': [None,returnStarInt,'Experiment.ID',True],                                         # Pointer to '_Experiment.ID'
          'Experiment_name': [None,lambda x = value: returnStarLine(x,length = 127),'Experiment.Name',False], # Pointer to a saveframe of the category 'NMR_spectrometer_expt'
          'Sample_ID': [None,returnStarInt,'Sample.ID',True],                                                 # Pointer to '_Sample.ID'
          'Sample_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Sample.Sf_framecode',True],# Pointer to a saveframe of the category 'sample'
          'Sample_state': [None,lambda x = value: returnStarLine(x,length = 31),None,True],                   # Physical state of the sample either anisotropic or isotropic.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Cross_correlation_list_ID': [None,returnStarInt,'Cross_correlation_D_CSA_list.ID',True],           # Pointer to '_Cross_correlation_D_CSA_list.ID'

                },

        'tagNames': ['Experiment_ID', 'Experiment_name', 'Sample_ID', 'Sample_label', 'Sample_state', 'Entry_ID', 'Cross_correlation_list_ID'],
        'sourcePrimaryKeys': ['Experiment_ID', 'Sample_ID', 'Sample_state', 'Entry_ID', 'Cross_correlation_list_ID'],

            },

      'Cross_correlation_D_CSA_software': {

        'tags': {

          'Software_ID': [None,returnStarInt,'Software.ID',True],                                             # Pointer to '_Software.ID'
          'Software_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Software.Sf_framecode',True],# Pointer to a saveframe of the category 'software'
          'Method_ID': [None,returnStarInt,'Method.ID',False],                                                # Pointer to '_Method.ID'
          'Method_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Method.Sf_framecode',False],# Pointer to a saveframe of the category 'method'
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Cross_correlation_list_ID': [None,returnStarInt,'Cross_correlation_D_CSA_list.ID',True],           # Pointer to '_Cross_correlation_D_CSA_list.ID'

                },

        'tagNames': ['Software_ID', 'Software_label', 'Method_ID', 'Method_label', 'Entry_ID', 'Cross_correlation_list_ID'],
        'sourcePrimaryKeys': ['Software_ID', 'Entry_ID', 'Cross_correlation_list_ID'],

            },

      'Cross_correlation_D_CSA': {

        'tags': {

          'ID': [None,returnStarInt,None,True],                                                               # Unique identifier for the observed cross-correlation value.
          'Dipole_assembly_atom_ID_1': [None,returnStarInt,'Atom.Assembly_atom_ID',False],                    # Pointer to '_Atom.Assembly_atom_ID'
          'Dipole_entity_assembly_ID_1': [None,returnStarInt,'Entity_assembly.ID',False],                     # Pointer to '_Entity_assembly.ID'
          'Dipole_entity_ID_1': [None,returnStarInt,'Entity.ID',False],                                       # Pointer to '_Entity.ID'
          'Dipole_comp_index_ID_1': [None,returnStarInt,'Entity_comp_index.ID',False],                        # Pointer to '_Entity_comp_index.ID'
          'Dipole_seq_ID_1': [None,returnStarInt,'Entity_poly_seq.Num',False],                                # Pointer to '_Entity_poly_seq.Num'
          'Dipole_comp_ID_1': [None,lambda x = value: returnStarCode(x,length = 12),'Chem_comp.ID',False],    # Pointer to '_Chem_comp.ID'
          'Dipole_atom_ID_1': [None,lambda x = value: returnStarAtCode(x,length = 12),'Chem_comp_atom.Atom_ID',False],# Pointer to '_Chem_comp_atom.Atom_ID'
          'Dipole_atom_type_1': [None,lambda x = value: returnStarCode(x,length = 15),None,False],            # Standard symbol used to define the atom element type.
          'Dipole_atom_isotope_number_1': [None,returnStarInt,None,False],                                    # The mass number for the chemical element defined by the tag '_Atom_type' or any of its related tags.
          'Dipole_assembly_atom_ID_2': [None,returnStarInt,'Atom.Assembly_atom_ID',False],                    # Pointer to '_Atom.Assembly_atom_ID'
          'Dipole_entity_assembly_ID_2': [None,returnStarInt,'Entity_assembly.ID',False],                     # Pointer to '_Entity_assembly.ID'
          'Dipole_entity_ID_2': [None,returnStarInt,'Entity.ID',False],                                       # Pointer to '_Entity.ID'
          'Dipole_comp_index_ID_2': [None,returnStarInt,'Entity_comp_index.ID',False],                        # Pointer to '_Entity_comp_index.ID'
          'Dipole_seq_ID_2': [None,returnStarInt,'Entity_poly_seq.Num',False],                                # Pointer to '_Entity_poly_seq.Num'
          'Dipole_comp_ID_2': [None,lambda x = value: returnStarCode(x,length = 12),'Chem_comp.ID',False],    # Pointer to '_Chem_comp.ID'
          'Dipole_atom_ID_2': [None,lambda x = value: returnStarAtCode(x,length = 12),'Chem_comp_atom.Atom_ID',False],# Pointer to '_Chem_comp_atom.Atom_ID'
          'Dipole_atom_type_2': [None,lambda x = value: returnStarCode(x,length = 15),None,False],            # Standard symbol used to define the atom element type.
          'Dipole_atom_isotope_number_2': [None,returnStarInt,None,False],                                    # The mass number for the chemical element defined by the tag '_Atom_type' or any of its related tags.
          'CSA_assembly_atom_ID_1': [None,returnStarInt,'Atom.Assembly_atom_ID',False],                       # Pointer to '_Atom.Assembly_atom_ID'
          'CSA_entity_assembly_ID_1': [None,returnStarInt,'Entity_assembly.ID',False],                        # Pointer to '_Entity_assembly.ID'
          'CSA_entity_ID_1': [None,returnStarInt,'Entity.ID',False],                                          # Pointer to '_Entity.ID'
          'CSA_comp_index_ID_1': [None,returnStarInt,'Entity_comp_index.ID',False],                           # Pointer to '_Entity_comp_index.ID'
          'CSA_seq_ID_1': [None,returnStarInt,'Entity_poly_seq.Num',False],                                   # Pointer to '_Entity_poly_seq.Num'
          'CSA_comp_ID_1': [None,lambda x = value: returnStarCode(x,length = 12),'Chem_comp.ID',False],       # Pointer to '_Chem_comp.ID'
          'CSA_atom_ID_1': [None,lambda x = value: returnStarAtCode(x,length = 12),'Chem_comp_atom.Atom_ID',False],# Pointer to '_Chem_comp_atom.Atom_ID'
          'CSA_atom_type_1': [None,lambda x = value: returnStarCode(x,length = 15),None,False],               # Standard symbol used to define the atom element type.
          'CSA_atom_isotope_number_1': [None,returnStarInt,None,False],                                       # The mass number for the chemical element defined by the tag '_Atom_type' or any of its related tags.
          'CSA_assembly_atom_ID_2': [None,returnStarInt,'Atom.Assembly_atom_ID',False],                       # Pointer to '_Atom.Assembly_atom_ID'
          'CSA_entity_assembly_ID_2': [None,returnStarInt,'Entity_assembly.ID',False],                        # Pointer to '_Entity_assembly.ID'
          'CSA_entity_ID_2': [None,returnStarInt,'Entity.ID',False],                                          # Pointer to '_Entity.ID'
          'CSA_comp_index_ID_2': [None,returnStarInt,'Entity_comp_index.ID',False],                           # Pointer to '_Entity_comp_index.ID'
          'CSA_seq_ID_2': [None,returnStarInt,'Entity_poly_seq.Num',False],                                   # Pointer to '_Entity_poly_seq.Num'
          'CSA_comp_ID_2': [None,lambda x = value: returnStarCode(x,length = 12),'Chem_comp.ID',False],       # Pointer to '_Chem_comp.ID'
          'CSA_atom_ID_2': [None,lambda x = value: returnStarAtCode(x,length = 12),'Chem_comp_atom.Atom_ID',False],# Pointer to '_Chem_comp_atom.Atom_ID'
          'CSA_atom_type_2': [None,lambda x = value: returnStarCode(x,length = 15),None,False],               # Standard symbol used to define the atom element type.
          'CSA_atom_isotope_number_2': [None,returnStarInt,None,False],                                       # The mass number for the chemical element defined by the tag '_Atom_type' or any of its related tags.
          'Val': [None,returnStarFloat,None,True],                                                            # The cross-correlation dipole-CSA relaxation value.
          'Val_err': [None,returnStarFloat,None,False],                                                       # The estimated error in the reported cross-correlation dipole-CSA relaxation value.
          'Dipole_resonance_ID_1': [None,returnStarInt,'Resonance.ID',False],                                 # Pointer to '_Resonance.ID'
          'Dipole_resonance_ID_2': [None,returnStarInt,'Resonance.ID',False],                                 # Pointer to '_Resonance.ID'
          'CSA_resonance_ID_1': [None,returnStarInt,'Resonance.ID',False],                                    # Pointer to '_Resonance.ID'
          'CSA_resonance_ID_2': [None,returnStarInt,'Resonance.ID',False],                                    # Pointer to '_Resonance.ID'
          'Dipole_auth_entity_assembly_ID_1': [None,lambda x = value: returnStarCode(x,length = 15),None,False],# An alternative identifier for Entity_assembly_ID that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Entity_assembly_ID.
          'Dipole_auth_seq_ID_1': [None,lambda x = value: returnStarCode(x,length = 15),None,False],          # An alternative identifier for Seq_id that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Seq_ID or Comp_index_ID.
          'Dipole_auth_comp_ID_1': [None,lambda x = value: returnStarCode(x,length = 15),None,False],         # An alternative identifier for Comp_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Dipole_auth_atom_ID_1': [None,lambda x = value: returnStarCode(x,length = 15),None,False],         # An alternative identifier for Atom_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Dipole_auth_entity_assembly_ID_2': [None,lambda x = value: returnStarCode(x,length = 15),None,False],# An alternative identifier for Entity_assembly_ID that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Entity_assembly_ID.
          'Dipole_auth_seq_ID_2': [None,lambda x = value: returnStarCode(x,length = 15),None,False],          # An alternative identifier for Seq_id that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Seq_ID or Comp_index_ID.
          'Dipole_auth_comp_ID_2': [None,lambda x = value: returnStarCode(x,length = 15),None,False],         # An alternative identifier for Comp_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Dipole_auth_atom_ID_2': [None,lambda x = value: returnStarCode(x,length = 15),None,False],         # An alternative identifier for Atom_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'CSA_auth_entity_assembly_ID_1': [None,lambda x = value: returnStarCode(x,length = 15),None,False], # An alternative identifier for Entity_assembly_ID that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Entity_assembly_ID.
          'CSA_auth_seq_ID_1': [None,lambda x = value: returnStarCode(x,length = 15),None,False],             # An alternative identifier for Seq_id that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Seq_ID or Comp_index_ID.
          'CSA_auth_comp_ID_1': [None,lambda x = value: returnStarCode(x,length = 15),None,False],            # An alternative identifier for Comp_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'CSA_auth_atom_ID_1': [None,lambda x = value: returnStarCode(x,length = 15),None,False],            # An alternative identifier for Atom_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'CSA_auth_entity_assembly_ID_2': [None,lambda x = value: returnStarCode(x,length = 15),None,False], # An alternative identifier for Entity_assembly_ID that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Entity_assembly_ID.
          'CSA_auth_seq_ID_2': [None,lambda x = value: returnStarCode(x,length = 15),None,False],             # An alternative identifier for Seq_id that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Seq_ID or Comp_index_ID.
          'CSA_auth_comp_ID_2': [None,lambda x = value: returnStarCode(x,length = 15),None,False],            # An alternative identifier for Comp_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'CSA_auth_atom_ID_2': [None,lambda x = value: returnStarCode(x,length = 15),None,False],            # An alternative identifier for Atom_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Cross_correlation_list_ID': [None,returnStarInt,'Cross_correlation_D_CSA_list.ID',True],           # Pointer to '_Cross_correlation_D_CSA_list.ID'

                },

        'tagNames': ['ID', 'Dipole_assembly_atom_ID_1', 'Dipole_entity_assembly_ID_1', 'Dipole_entity_ID_1', 'Dipole_comp_index_ID_1', 'Dipole_seq_ID_1', 'Dipole_comp_ID_1', 'Dipole_atom_ID_1', 'Dipole_atom_type_1', 'Dipole_atom_isotope_number_1', 'Dipole_assembly_atom_ID_2', 'Dipole_entity_assembly_ID_2', 'Dipole_entity_ID_2', 'Dipole_comp_index_ID_2', 'Dipole_seq_ID_2', 'Dipole_comp_ID_2', 'Dipole_atom_ID_2', 'Dipole_atom_type_2', 'Dipole_atom_isotope_number_2', 'CSA_assembly_atom_ID_1', 'CSA_entity_assembly_ID_1', 'CSA_entity_ID_1', 'CSA_comp_index_ID_1', 'CSA_seq_ID_1', 'CSA_comp_ID_1', 'CSA_atom_ID_1', 'CSA_atom_type_1', 'CSA_atom_isotope_number_1', 'CSA_assembly_atom_ID_2', 'CSA_entity_assembly_ID_2', 'CSA_entity_ID_2', 'CSA_comp_index_ID_2', 'CSA_seq_ID_2', 'CSA_comp_ID_2', 'CSA_atom_ID_2', 'CSA_atom_type_2', 'CSA_atom_isotope_number_2', 'Val', 'Val_err', 'Dipole_resonance_ID_1', 'Dipole_resonance_ID_2', 'CSA_resonance_ID_1', 'CSA_resonance_ID_2', 'Dipole_auth_entity_assembly_ID_1', 'Dipole_auth_seq_ID_1', 'Dipole_auth_comp_ID_1', 'Dipole_auth_atom_ID_1', 'Dipole_auth_entity_assembly_ID_2', 'Dipole_auth_seq_ID_2', 'Dipole_auth_comp_ID_2', 'Dipole_auth_atom_ID_2', 'CSA_auth_entity_assembly_ID_1', 'CSA_auth_seq_ID_1', 'CSA_auth_comp_ID_1', 'CSA_auth_atom_ID_1', 'CSA_auth_entity_assembly_ID_2', 'CSA_auth_seq_ID_2', 'CSA_auth_comp_ID_2', 'CSA_auth_atom_ID_2', 'Entry_ID', 'Cross_correlation_list_ID'],
        'sourcePrimaryKeys': ['ID', 'Entry_ID', 'Cross_correlation_list_ID'],

            }

        },

    'tableNames': ['Cross_correlation_D_CSA_experiment', 'Cross_correlation_D_CSA_software', 'Cross_correlation_D_CSA']

    },

  'order_parameters': {

    'name': 'Order_parameter_list',

    'tags': {

      'Sf_category': ['order_parameters',lambda x = value: returnStarCode(x,length = 127),None,True],         # Category definition for the information content of the saveframe
      'Sf_framecode': [None,lambda x = value: returnStarCode(x,length = 127),None,False],                     # A label for the saveframe that describes in very brief terms the information contained in the saveframe.
      'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                     # Pointer to '_Entry.ID'
      'ID': [None,returnStarInt,None,True],                                                                   # Unique identifier for the list of reported order parameter values.
      'Data_file_name': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                   # The name of the file submitted with this depostion that contains the quantitative data for this saveframe.
      'Sample_condition_list_ID': [None,returnStarInt,'Sample_condition_list.ID',True],                       # Pointer to '_Sample_condition_list.ID'
      'Sample_condition_list_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Sample_condition_list.Sf_framecode',True],# The label for the set of experimental sample conditions used to collect the data for determination of the order parameters.
      'Tau_e_val_units': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                   # The units for the effective correlation time of the molecule.
      'Tau_s_val_units': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                   # The units for the correlation time representing internal motions of the molecule.
      'Details': [None,returnStarString,None,False],                                                          # Text describing the reported order parameter values.
      'Text_data_format': [None,lambda x = value: returnStarLine(x,length = 31),None,False],                  # The data format used to represent the order parameter data as ASCII text in the text block that is the value to the '_Order_parameter_list.Text_data' tag.
      'Text_data': [None,returnStarString,None,False],                                                        # A set of order parameter data formatted as ASCII text.

            },

    'tagNames': ['Sf_category', 'Sf_framecode', 'Entry_ID', 'ID', 'Data_file_name', 'Sample_condition_list_ID', 'Sample_condition_list_label', 'Tau_e_val_units', 'Tau_s_val_units', 'Details', 'Text_data_format', 'Text_data'],
    'sourcePrimaryKeys': ['Entry_ID', 'ID'],

    'tables': {

      'Order_parameter_experiment': {

        'tags': {

          'Experiment_ID': [None,returnStarInt,'Experiment.ID',True],                                         # Pointer to '_Experiment.ID'
          'Experiment_name': [None,lambda x = value: returnStarLine(x,length = 127),'Experiment.Name',False], # Pointer to a saveframe of the category 'NMR_spectrometer_expt'
          'Sample_ID': [None,returnStarInt,'Sample.ID',True],                                                 # Pointer to '_Sample.ID'
          'Sample_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Sample.Sf_framecode',True],# Pointer to a saveframe of the category 'sample'
          'Sample_state': [None,lambda x = value: returnStarLine(x,length = 31),None,True],                   # Physical state of the sample either anisotropic or isotropic.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Order_parameter_list_ID': [None,returnStarInt,'Order_parameter_list.ID',True],                     # Pointer to '_Order_parameter_list.ID'

                },

        'tagNames': ['Experiment_ID', 'Experiment_name', 'Sample_ID', 'Sample_label', 'Sample_state', 'Entry_ID', 'Order_parameter_list_ID'],
        'sourcePrimaryKeys': ['Experiment_ID', 'Sample_ID', 'Sample_state', 'Entry_ID', 'Order_parameter_list_ID'],

            },

      'Order_parameter_software': {

        'tags': {

          'Software_ID': [None,returnStarInt,'Software.ID',True],                                             # Pointer to '_Software.ID'
          'Software_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Software.Sf_framecode',True],# Pointer to a saveframe of the category 'software'
          'Method_ID': [None,returnStarInt,'Method.ID',False],                                                # Pointer to '_Method.ID'
          'Method_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Method.Sf_framecode',False],# Pointer to a saveframe of the category 'method'
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Order_parameter_list_ID': [None,returnStarInt,'Order_parameter_list.ID',True],                     # Pointer to '_Order_parameter_list.ID'

                },

        'tagNames': ['Software_ID', 'Software_label', 'Method_ID', 'Method_label', 'Entry_ID', 'Order_parameter_list_ID'],
        'sourcePrimaryKeys': ['Software_ID', 'Entry_ID', 'Order_parameter_list_ID'],

            },

      'Order_param': {

        'tags': {

          'ID': [None,returnStarInt,None,True],                                                               # Unique identifier for the observed order parameter value.
          'Assembly_atom_ID': [None,returnStarInt,'Atom.Assembly_atom_ID',False],                             # Pointer to '_Atom.Assembly_atom_ID'
          'Entity_assembly_ID': [None,returnStarInt,'Entity_assembly.ID',True],                               # Pointer to '_Entity_assembly.ID'
          'Entity_ID': [None,returnStarInt,'Entity.ID',True],                                                 # Pointer to '_Entity.ID'
          'Comp_index_ID': [None,returnStarInt,'Entity_comp_index.ID',True],                                  # Pointer to '_Entity_comp_index.ID'
          'Seq_ID': [None,returnStarInt,'Entity_poly_seq.Num',True],                                          # Pointer to '_Entity_poly_seq.Num'
          'Comp_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Chem_comp.ID',True],              # Pointer to '_Chem_comp.ID'
          'Atom_ID': [None,lambda x = value: returnStarAtCode(x,length = 12),'Chem_comp_atom.Atom_ID',True],  # Pointer to '_Chem_comp_atom.Atom_ID'
          'Atom_type': [None,lambda x = value: returnStarCode(x,length = 15),None,True],                      # The value for this tag is a standard IUPAC abbreviation for an element (i.e.$ H$ C$ P$ etc).
          'Atom_isotope_number': [None,returnStarInt,None,False],                                             # The mass number for the chemical element defined by the tag '_Atom_type' or any of its related tags.
          'Order_param_val': [None,returnStarFloat,None,True],                                                # The value for the fitted order parameter.
          'Order_param_val_fit_err': [None,returnStarFloat,None,False],                                       # The estimated error in the fitted order parameter value.
          'Tau_e_val': [None,returnStarFloat,None,False],                                                     # The value of the effective correlation time for the atom.
          'Tau_e_val_fit_err': [None,returnStarFloat,None,False],                                             # The estimated error in the fitted effective correlation time value.
          'Tau_f_val': [None,returnStarFloat,None,False],                                                     # ?
          'Tau_f_val_fit_err': [None,returnStarFloat,None,False],                                             # ?
          'Tau_s_val': [None,returnStarFloat,None,False],                                                     # The value for the fitted effective correlation time value for the 'slow' motion in the molecule.
          'Tau_s_val_fit_err': [None,returnStarFloat,None,False],                                             # The estimated error in the fitted effective correlation time value for the the 'slow' motion in the molecule.
          'Rex_val': [None,returnStarFloat,None,False],                                                       # The exchange broadening contribution value.
          'Rex_val_fit_err': [None,returnStarFloat,None,False],                                               # The estimated error in the fitted exchange broadening contribution value.
          'Model_free_sum_squared_errs': [None,returnStarFloat,None,False],                                   # The sum of the squared errors from a fit of the data using the 'Model-Free' software package.
          'Model_fit': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                     # The model used to fit the experimental data.
          'Sf2_val': [None,returnStarFloat,None,False],                                                       # The value for the fitted order parameter for the 'fast' motion in the molecule.
          'Sf2_val_fit_err': [None,returnStarFloat,None,False],                                               # The estimated error in the fitted order parameter for the 'fast' motion in the molecule.
          'Ss2_val': [None,returnStarFloat,None,False],                                                       # The value for the fitted order parameter for the 'slow' motion in the molecule.
          'Ss2_val_fit_err': [None,returnStarFloat,None,False],                                               # The estimated error in the fitted order parameter for the 'slow' motion in the molecule.
          'SH2_val': [None,returnStarFloat,None,False],                                                       # The value for the fitted order parameter value for a hydrogen atom.
          'SH2_val_fit_err': [None,returnStarFloat,None,False],                                               # The estimated error in the fitted order parameter value for a hydrogen atom.
          'SN2_val': [None,returnStarFloat,None,False],                                                       # The value for the fitted order parameter value for a nitrogen atom.
          'SN2_val_fit_err': [None,returnStarFloat,None,False],                                               # The estimated error in the fitted order parameter value for a nitrogen atom.
          'Resonance_ID': [None,returnStarInt,'Resonance.ID',False],                                          # Pointer to '_Resonance.ID'
          'Auth_entity_assembly_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],       # An alternative identifier for Entity_assembly_ID that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Entity_assembly_ID.
          'Auth_seq_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                   # An alternative identifier for Seq_id that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Seq_ID or Comp_index_ID.
          'Auth_comp_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                  # An alternative identifier for Comp_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Auth_atom_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                  # An alternative identifier for Atom_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Order_parameter_list_ID': [None,returnStarInt,'Order_parameter_list.ID',True],                     # Pointer to '_Order_parameter_list.ID'

                },

        'tagNames': ['ID', 'Assembly_atom_ID', 'Entity_assembly_ID', 'Entity_ID', 'Comp_index_ID', 'Seq_ID', 'Comp_ID', 'Atom_ID', 'Atom_type', 'Atom_isotope_number', 'Order_param_val', 'Order_param_val_fit_err', 'Tau_e_val', 'Tau_e_val_fit_err', 'Tau_f_val', 'Tau_f_val_fit_err', 'Tau_s_val', 'Tau_s_val_fit_err', 'Rex_val', 'Rex_val_fit_err', 'Model_free_sum_squared_errs', 'Model_fit', 'Sf2_val', 'Sf2_val_fit_err', 'Ss2_val', 'Ss2_val_fit_err', 'SH2_val', 'SH2_val_fit_err', 'SN2_val', 'SN2_val_fit_err', 'Resonance_ID', 'Auth_entity_assembly_ID', 'Auth_seq_ID', 'Auth_comp_ID', 'Auth_atom_ID', 'Entry_ID', 'Order_parameter_list_ID'],
        'sourcePrimaryKeys': ['ID', 'Entry_ID', 'Order_parameter_list_ID'],

            }

        },

    'tableNames': ['Order_parameter_experiment', 'Order_parameter_software', 'Order_param']

    },

  'pH_titration': {

    'name': 'PH_titration_list',

    'tags': {

      'Sf_category': ['pH_titration',lambda x = value: returnStarCode(x,length = 127),None,True],             # Category definition for the information content of the saveframe
      'Sf_framecode': [None,lambda x = value: returnStarCode(x,length = 127),None,False],                     # A label for the saveframe that describes in very brief terms the information contained in the saveframe.
      'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                     # Pointer to '_Entry.ID'
      'ID': [None,returnStarInt,None,True],                                                                   # Unique identifier for the list of pKa values.
      'Data_file_name': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                   # The name of the file submitted with this depostion that contains the quantitative data for this saveframe.
      'Sample_condition_list_ID': [None,returnStarInt,'Sample_condition_list.ID',True],                       # Pointer to '_Sample_condition_list.ID'
      'Sample_condition_list_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Sample_condition_list.Sf_framecode',True],# The label for the set of experimental sample conditions used to collect the pH titration data.
      'Expt_observed_param': [None,lambda x = value: returnStarLine(x,length = 31),None,True],                # The spectral parameter or derived parameter measured and used to determine the effect of pH on the macromolecule.
      'Details': [None,returnStarString,None,False],                                                          # Text describing the reported pH titration values.
      'Text_data_format': [None,lambda x = value: returnStarLine(x,length = 31),None,False],                  # The data format used to represent the pK$ pHmid$ and other data as ASCII text in the text block that is the value to the '_PH_titration_list.Text_data' tag.
      'Text_data': [None,returnStarString,None,False],                                                        # A set of pK or pHmid data formatted as ASCII text.

            },

    'tagNames': ['Sf_category', 'Sf_framecode', 'Entry_ID', 'ID', 'Data_file_name', 'Sample_condition_list_ID', 'Sample_condition_list_label', 'Expt_observed_param', 'Details', 'Text_data_format', 'Text_data'],
    'sourcePrimaryKeys': ['Entry_ID', 'ID'],

    'tables': {

      'PH_titration_experiment': {

        'tags': {

          'Experiment_ID': [None,returnStarInt,'Experiment.ID',True],                                         # Pointer to '_Experiment.ID'
          'Experiment_name': [None,lambda x = value: returnStarLine(x,length = 127),'Experiment.Name',False], # Pointer to a saveframe of the category 'NMR_spectrometer_expt'
          'Sample_ID': [None,returnStarInt,'Sample.ID',True],                                                 # Pointer to '_Sample.ID'
          'Sample_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Sample.Sf_framecode',True],# Pointer to a saveframe of the category 'sample'
          'Sample_state': [None,lambda x = value: returnStarLine(x,length = 31),None,True],                   # Physical state of the sample either anisotropic or isotropic.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'PH_titration_list_ID': [None,returnStarInt,'PH_titration_list.ID',True],                           # Pointer to '_PH_titration_list.ID'

                },

        'tagNames': ['Experiment_ID', 'Experiment_name', 'Sample_ID', 'Sample_label', 'Sample_state', 'Entry_ID', 'PH_titration_list_ID'],
        'sourcePrimaryKeys': ['Experiment_ID', 'Sample_ID', 'Sample_state', 'Entry_ID', 'PH_titration_list_ID'],

            },

      'PH_titration_software': {

        'tags': {

          'Software_ID': [None,returnStarInt,'Software.ID',True],                                             # Pointer to '_Software.ID'
          'Software_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Software.Sf_framecode',True],# Pointer to a saveframe of the category 'software'
          'Method_ID': [None,returnStarInt,'Method.ID',False],                                                # Pointer to '_Method.ID'
          'Method_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Method.Sf_framecode',False],# Pointer to a saveframe of the category 'method'
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'PH_titration_list_ID': [None,returnStarInt,'PH_titration_list.ID',True],                           # Pointer to '_PH_titration_list.ID'

                },

        'tagNames': ['Software_ID', 'Software_label', 'Method_ID', 'Method_label', 'Entry_ID', 'PH_titration_list_ID'],
        'sourcePrimaryKeys': ['Software_ID', 'Entry_ID', 'PH_titration_list_ID'],

            },

      'PH_titr_result': {

        'tags': {

          'ID': [None,returnStarInt,None,True],                                                               # Unique identifier for the observed pKa value.
          'Atm_obs_assembly_atom_ID': [None,returnStarInt,'Atom.Assembly_atom_ID',False],                     # Pointer to '_Atom.Assembly_atom_ID'
          'Atm_obs_entity_assembly_ID': [None,returnStarInt,'Entity_assembly.ID',True],                       # Pointer to '_Entity_assembly.ID'
          'Atm_obs_entity_ID': [None,returnStarInt,'Entity.ID',True],                                         # Pointer to '_Entity.ID'
          'Atm_obs_comp_index_ID': [None,returnStarInt,'Entity_comp_index.ID',True],                          # Pointer to '_Entity_comp_index.ID'
          'Atm_obs_seq_ID': [None,returnStarInt,'Entity_poly_seq.Num',True],                                  # Pointer to '_Entity_poly_seq.Num'
          'Atm_obs_comp_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Chem_comp.ID',True],      # Pointer to '_Chem_comp.ID'
          'Atm_obs_atom_ID': [None,lambda x = value: returnStarAtCode(x,length = 12),'Chem_comp_atom.Atom_ID',True],# Pointer to '_Chem_comp_atom.Atom_ID'
          'Atm_obs_atom_type': [None,lambda x = value: returnStarCode(x,length = 15),None,True],              # Standard symbol used to define the atom element type.
          'Atm_obs_atom_isotope_number': [None,returnStarInt,None,False],                                     # The mass number for the chemical element defined by the tag '_Atom_type' or any of its related tags.
          'Atm_obs_auth_entity_assembly_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],# An alternative identifier for Entity_assembly_ID that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Entity_assembly_ID.
          'Atm_obs_auth_seq_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],           # An alternative identifier for Seq_id that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Seq_ID or Comp_index_ID.
          'Atm_obs_auth_comp_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],          # An alternative identifier for Comp_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Atm_obs_auth_atom_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],          # An alternative identifier for Atom_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Atm_titr_assembly_atom_ID': [None,returnStarInt,'Atom.Assembly_atom_ID',False],                    # Pointer to '_Atom.Assembly_atom_ID'
          'Atm_titr_entity_assembly_ID': [None,returnStarInt,'Entity_assembly.ID',True],                      # Pointer to '_Entity_assembly.ID'
          'Atm_titr_entity_ID': [None,returnStarInt,'Entity.ID',True],                                        # Pointer to '_Entity.ID'
          'Atm_titr_comp_index_ID': [None,returnStarInt,'Entity_comp_index.ID',True],                         # Pointer to '_Entity_comp_index.ID'
          'Atm_titr_seq_ID': [None,returnStarInt,'Entity_poly_seq.Num',True],                                 # Pointer to '_Entity_poly_seq.Num'
          'Atm_titr_comp_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Chem_comp.ID',True],     # Pointer to '_Chem_comp.ID'
          'Atm_titr_atom_ID': [None,lambda x = value: returnStarAtCode(x,length = 12),'Chem_comp_atom.Atom_ID',True],# Pointer to '_Chem_comp_atom.Atom_ID'
          'Atm_titr_atom_type': [None,lambda x = value: returnStarCode(x,length = 15),None,True],             # Standard symbol used to define the atom element type.
          'Atm_titr_atom_isotope_number': [None,returnStarInt,None,False],                                    # The mass number for the chemical element defined by the tag '_Atom_type' or any of its related tags.
          'Atm_titr_auth_entity_assembly_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],# An alternative identifier for Entity_assembly_ID that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Entity_assembly_ID.
          'Atm_titr_auth_seq_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],          # An alternative identifier for Seq_id that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Seq_ID or Comp_index_ID.
          'Atm_titr_auth_comp_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],         # An alternative identifier for Comp_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Atm_titr_auth_atom_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],         # An alternative identifier for Atom_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Hill_coeff_val': [None,returnStarFloat,None,False],                                                # Value for the Hill coefficient derived from fitting the pH titration data.
          'Hill_coeff_val_fit_err': [None,returnStarFloat,None,False],                                        # Estimated error in the fitted Hill coefficient.
          'High_PH_param_fit_val': [None,returnStarFloat,None,False],                                         # In a fit of the pH titration data to a single pK value$ the estimated high pH value.
          'High_PH_param_fit_val_err': [None,returnStarFloat,None,False],                                     # Estimated error in the fitted high pH value.
          'Low_PH_param_fit_val': [None,returnStarFloat,None,False],                                          # In a fit of the pH titration data to a single pK value$ the estimated low pH value.
          'Low_PH_param_fit_val_err': [None,returnStarFloat,None,False],                                      # Estimated error in the fitted low pH value.
          'PKa_val': [None,returnStarFloat,None,False],                                                       # pKa value estimated from a fit of a pH titration data set.
          'PKa_val_fit_err': [None,returnStarFloat,None,False],                                               # Estimated error in the pKa value.
          'PHmid_val': [None,returnStarFloat,None,False],                                                     # pHmid value estimated from a fit of a pH titration data set.
          'PHmid_val_fit_err': [None,returnStarFloat,None,False],                                             # Estimated error in the fitted pHmid value.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'PH_titration_list_ID': [None,returnStarInt,'PH_titration_list.ID',True],                           # Pointer to '_PH_titration_list.ID'

                },

        'tagNames': ['ID', 'Atm_obs_assembly_atom_ID', 'Atm_obs_entity_assembly_ID', 'Atm_obs_entity_ID', 'Atm_obs_comp_index_ID', 'Atm_obs_seq_ID', 'Atm_obs_comp_ID', 'Atm_obs_atom_ID', 'Atm_obs_atom_type', 'Atm_obs_atom_isotope_number', 'Atm_obs_auth_entity_assembly_ID', 'Atm_obs_auth_seq_ID', 'Atm_obs_auth_comp_ID', 'Atm_obs_auth_atom_ID', 'Atm_titr_assembly_atom_ID', 'Atm_titr_entity_assembly_ID', 'Atm_titr_entity_ID', 'Atm_titr_comp_index_ID', 'Atm_titr_seq_ID', 'Atm_titr_comp_ID', 'Atm_titr_atom_ID', 'Atm_titr_atom_type', 'Atm_titr_atom_isotope_number', 'Atm_titr_auth_entity_assembly_ID', 'Atm_titr_auth_seq_ID', 'Atm_titr_auth_comp_ID', 'Atm_titr_auth_atom_ID', 'Hill_coeff_val', 'Hill_coeff_val_fit_err', 'High_PH_param_fit_val', 'High_PH_param_fit_val_err', 'Low_PH_param_fit_val', 'Low_PH_param_fit_val_err', 'PKa_val', 'PKa_val_fit_err', 'PHmid_val', 'PHmid_val_fit_err', 'Entry_ID', 'PH_titration_list_ID'],
        'sourcePrimaryKeys': ['ID', 'Entry_ID', 'PH_titration_list_ID'],

            }

        },

    'tableNames': ['PH_titration_experiment', 'PH_titration_software', 'PH_titr_result']

    },

  'pH_param_list': {

    'name': 'PH_param_list',

    'tags': {

      'Sf_category': ['pH_param_list',lambda x = value: returnStarCode(x,length = 127),None,True],            # Category definition for the information content of the saveframe
      'Sf_framecode': [None,lambda x = value: returnStarCode(x,length = 127),None,False],                     # A label for the saveframe that describes in very brief terms the information contained in the saveframe.
      'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                     # Pointer to '_Entry.ID'
      'ID': [None,returnStarInt,None,True],                                                                   # Unique identifier for the list of data values used to calculate a pKa value.
      'PH_titration_list_ID': [None,returnStarInt,'PH_titration_list.ID',True],                               # Pointer to 'PH_titration_list.ID'
      'PH_titration_list_label': [None,lambda x = value: returnStarLabel(x,length = 127),'PH_titration_list.Sf_framecode',True],# Pointer to the saveframe where the measured values used to calculate the reported pKa values are provided.
      'Observed_NMR_param': [None,lambda x = value: returnStarLine(x,length = 31),None,True],                 # The spectral parameter or derived parameter measured and used to determine the effect of pH on the macromolecule.
      'Data_file_name': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                   # The name of the file submitted with this depostion that contains the quantitative data for this saveframe.
      'Details': [None,returnStarString,None,False],                                                          # Text describing the reported pH parameter values.
      'Text_data_format': [None,lambda x = value: returnStarLine(x,length = 31),None,False],                  # The data format used to represent the pH titration data as ASCII text in the text block that is the value to the '_PH_param_list.Text_data' tag.
      'Text_data': [None,returnStarString,None,False],                                                        # A set of pH titration data formatted as ASCII text.

            },

    'tagNames': ['Sf_category', 'Sf_framecode', 'Entry_ID', 'ID', 'PH_titration_list_ID', 'PH_titration_list_label', 'Observed_NMR_param', 'Data_file_name', 'Details', 'Text_data_format', 'Text_data'],
    'sourcePrimaryKeys': ['Entry_ID', 'ID'],

    'tables': {

      'PH_param': {

        'tags': {

          'ID': [None,returnStarInt,None,True],                                                               # Unique identifier for the observed NMR parameter value.
          'PH_titr_result_ID': [None,returnStarInt,'PH_titr_result.ID',True],                                 # Pointer to '_PH_titr_result.ID'
          'PH_val': [None,returnStarFloat,None,True],                                                         # pH value at which the observed NMR parameter value was observed.
          'PH_val_err': [None,returnStarFloat,None,False],                                                    # Error in the measured pH value.
          'Observed_NMR_param_val': [None,returnStarFloat,None,True],                                         # Value for the observed NMR parameter.
          'Observed_NMR_param_val_err': [None,returnStarFloat,None,False],                                    # Error in the reported NMR parameter value.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'PH_param_list_ID': [None,returnStarInt,'PH_param_list.ID',True],                                   # Pointer to '_PH_param_list.ID'

                },

        'tagNames': ['ID', 'PH_titr_result_ID', 'PH_val', 'PH_val_err', 'Observed_NMR_param_val', 'Observed_NMR_param_val_err', 'Entry_ID', 'PH_param_list_ID'],
        'sourcePrimaryKeys': ['ID', 'Entry_ID', 'PH_param_list_ID'],

            }

        },

    'tableNames': ['PH_param']

    },

  'D_H_fractionation_factors': {

    'name': 'D_H_fractionation_factor_list',

    'tags': {

      'Sf_category': ['D_H_fractionation_factors',lambda x = value: returnStarCode(x,length = 127),None,True],# Category definition for the information content of the saveframe
      'Sf_framecode': [None,lambda x = value: returnStarCode(x,length = 127),None,False],                     # A label for the saveframe that describes in very brief terms the information contained in the saveframe.
      'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                     # Pointer to '_Entry.ID'
      'ID': [None,returnStarInt,None,True],                                                                   # Unique identifier for the list of reported deuterium/hydrogen fractionation factors.
      'Data_file_name': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                   # The name of the file submitted with this depostion that contains the quantitative data for this saveframe.
      'Sample_condition_list_ID': [None,returnStarInt,'Sample_condition_list.ID',True],                       # Pointer to '_Sample_condition_list.ID'
      'Sample_condition_list_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Sample_condition_list.Sf_framecode',True],# The label for the set of experimental sample conditions used to collect the data for determination of the D/H fractionation factors.
      'Details': [None,returnStarString,None,False],                                                          # Text describing the reported deuterium/hydrogen fractionation factors.
      'Text_data_format': [None,lambda x = value: returnStarLine(x,length = 31),None,False],                  # The data format used to represent the deuterium-proton fractionation factor data as ASCII text in the text block that is the value to the '_D_H_fractionation_factor_list.Text_data' tag.
      'Text_data': [None,returnStarString,None,False],                                                        # A set of deuterium-hydrogen fractionation factor data formatted as ASCII text.

            },

    'tagNames': ['Sf_category', 'Sf_framecode', 'Entry_ID', 'ID', 'Data_file_name', 'Sample_condition_list_ID', 'Sample_condition_list_label', 'Details', 'Text_data_format', 'Text_data'],
    'sourcePrimaryKeys': ['Entry_ID', 'ID'],

    'tables': {

      'D_H_fract_factor_experiment': {

        'tags': {

          'Experiment_ID': [None,returnStarInt,'Experiment.ID',True],                                         # Pointer to '_Experiment.ID'
          'Experiment_name': [None,lambda x = value: returnStarLine(x,length = 127),'Experiment.Name',False], # Pointer to a saveframe of the category 'NMR_spectrometer_expt'
          'Sample_ID': [None,returnStarInt,'Sample.ID',True],                                                 # Pointer to '_Sample.ID'
          'Sample_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Sample.Sf_framecode',True],# Pointer to a saveframe of the category 'sample'
          'Sample_state': [None,lambda x = value: returnStarLine(x,length = 31),None,True],                   # Physical state of the sample either anisotropic or isotropic.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'D_H_fractionation_factor_list_ID': [None,returnStarInt,'D_H_fractionation_factor_list.ID',True],   # Pointer to '_D_H_fractionation_factor_list.ID'

                },

        'tagNames': ['Experiment_ID', 'Experiment_name', 'Sample_ID', 'Sample_label', 'Sample_state', 'Entry_ID', 'D_H_fractionation_factor_list_ID'],
        'sourcePrimaryKeys': ['Experiment_ID', 'Sample_ID', 'Sample_state', 'Entry_ID', 'D_H_fractionation_factor_list_ID'],

            },

      'D_H_fract_factor_software': {

        'tags': {

          'Software_ID': [None,returnStarInt,'Software.ID',True],                                             # Pointer to '_Software.ID'
          'Software_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Software.Sf_framecode',True],# Pointer to a saveframe of the category 'software'
          'Method_ID': [None,returnStarInt,'Method.ID',False],                                                # Pointer to '_Method.ID'
          'Method_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Method.Sf_framecode',False],# Pointer to a saveframe of the category 'method'
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'D_H_fractionation_factor_list_ID': [None,returnStarInt,'D_H_fractionation_factor_list.ID',True],   # Pointer to '_D_H_fractionation_factor_list.ID'

                },

        'tagNames': ['Software_ID', 'Software_label', 'Method_ID', 'Method_label', 'Entry_ID', 'D_H_fractionation_factor_list_ID'],
        'sourcePrimaryKeys': ['Software_ID', 'Entry_ID', 'D_H_fractionation_factor_list_ID'],

            },

      'D_H_fractionation_factor': {

        'tags': {

          'ID': [None,returnStarInt,None,True],                                                               # Unique identifier for the observed deuterium/hydrogen fractionation factor.
          'Assembly_atom_ID': [None,returnStarInt,'Atom.Assembly_atom_ID',False],                             # Pointer to '_Atom.Assembly_atom_ID'
          'Entity_assembly_ID': [None,returnStarInt,'Entity_assembly.ID',True],                               # Pointer to '_Entity_assembly.ID'
          'Entity_ID': [None,returnStarInt,'Entity.ID',True],                                                 # Pointer to '_Entity.ID'
          'Comp_index_ID': [None,returnStarInt,'Entity_comp_index.ID',True],                                  # Pointer to '_Entity_comp_index.ID'
          'Seq_ID': [None,returnStarInt,'Entity_poly_seq.Num',True],                                          # Pointer to '_Entity_poly_seq.Num'
          'Comp_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Chem_comp.ID',True],              # Pointer to '_Chem_comp.ID'
          'Atom_ID': [None,lambda x = value: returnStarAtCode(x,length = 12),'Chem_comp_atom.Atom_ID',True],  # Pointer to '_Chem_comp_atom.Atom_ID'
          'Atom_type': [None,lambda x = value: returnStarCode(x,length = 15),None,True],                      # The value for this tag is a standard IUPAC abbreviation for an element (i.e.$ H$ C$ P$ etc).
          'Val': [None,returnStarFloat,None,True],                                                            # Deuterium-hydrogen fractionation factor value.
          'Val_err': [None,returnStarFloat,None,False],                                                       # Estimated error in the reported deuterium-hydrogen fractionation factor value.
          'Resonance_ID': [None,returnStarInt,'Resonance.ID',False],                                          # Pointer to '_Resonance.ID'
          'Auth_entity_assembly_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],       # An alternative identifier for Entity_assembly_ID that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Entity_assembly_ID.
          'Auth_seq_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                   # An alternative identifier for Seq_id that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Seq_ID or Comp_index_ID.
          'Auth_comp_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                  # An alternative identifier for Comp_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Auth_atom_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                  # An alternative identifier for Atom_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'D_H_fractionation_factor_list_ID': [None,returnStarInt,'D_H_fractionation_factor_list.ID',True],   # Pointer to '_D_H_fractionation_factor_list.ID'

                },

        'tagNames': ['ID', 'Assembly_atom_ID', 'Entity_assembly_ID', 'Entity_ID', 'Comp_index_ID', 'Seq_ID', 'Comp_ID', 'Atom_ID', 'Atom_type', 'Val', 'Val_err', 'Resonance_ID', 'Auth_entity_assembly_ID', 'Auth_seq_ID', 'Auth_comp_ID', 'Auth_atom_ID', 'Entry_ID', 'D_H_fractionation_factor_list_ID'],
        'sourcePrimaryKeys': ['ID', 'Entry_ID', 'D_H_fractionation_factor_list_ID'],

            }

        },

    'tableNames': ['D_H_fract_factor_experiment', 'D_H_fract_factor_software', 'D_H_fractionation_factor']

    },

  'binding_data': {

    'name': 'Binding_value_list',

    'tags': {

      'Sf_category': ['binding_data',lambda x = value: returnStarCode(x,length = 127),None,True],             # Category definition for the information content of the saveframe
      'Sf_framecode': [None,lambda x = value: returnStarCode(x,length = 127),None,False],                     # A label for the saveframe that describes in very brief terms the information contained in the saveframe.
      'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                     # Pointer to '_Entry.ID'
      'ID': [None,returnStarInt,None,True],                                                                   # ?
      'Data_file_name': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                   # The name of the file submitted with this depostion that contains the quantitative data for this saveframe.
      'Sample_condition_list_ID': [None,returnStarInt,'Sample_condition_list.ID',True],                       # Pointer to '_Sample_condition_list.ID'
      'Sample_condition_list_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Sample_condition_list.Sf_framecode',True],# The label for the set of experimental sample conditions used to collect the binding data.
      'Details': [None,returnStarString,None,False],                                                          # Text describing the reported binding values.
      'Text_data_format': [None,lambda x = value: returnStarLine(x,length = 31),None,False],                  # The data format used to represent the binding data as ASCII text in the text block that is the value to the '_Binding_value_list.Text_data' tag.
      'Text_data': [None,returnStarString,None,False],                                                        # A set of binding data formatted as ASCII text.

            },

    'tagNames': ['Sf_category', 'Sf_framecode', 'Entry_ID', 'ID', 'Data_file_name', 'Sample_condition_list_ID', 'Sample_condition_list_label', 'Details', 'Text_data_format', 'Text_data'],
    'sourcePrimaryKeys': ['Entry_ID', 'ID'],

    'tables': {

      'Binding_experiment': {

        'tags': {

          'Experiment_ID': [None,returnStarInt,'Experiment.ID',True],                                         # Pointer to '_Experiment.ID'
          'Experiment_name': [None,lambda x = value: returnStarLine(x,length = 127),'Experiment.Name',False], # ?
          'Sample_ID': [None,returnStarInt,'Sample.ID',True],                                                 # Pointer to '_Sample.ID'
          'Sample_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Sample.Sf_framecode',True],# Pointer to a saveframe of the category 'sample'
          'Sample_state': [None,lambda x = value: returnStarLine(x,length = 31),None,True],                   # Physical state of the sample either anisotropic or isotropic.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Binding_value_list_ID': [None,returnStarInt,'Binding_value_list.ID',True],                         # Pointer to '_Binding_value_list.ID'

                },

        'tagNames': ['Experiment_ID', 'Experiment_name', 'Sample_ID', 'Sample_label', 'Sample_state', 'Entry_ID', 'Binding_value_list_ID'],
        'sourcePrimaryKeys': ['Experiment_ID', 'Sample_ID', 'Sample_state', 'Entry_ID', 'Binding_value_list_ID'],

            },

      'Binding_software': {

        'tags': {

          'Software_ID': [None,returnStarInt,'Software.ID',True],                                             # Pointer to '_Software.ID'
          'Software_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Software.Sf_framecode',True],# Pointer to a saveframe of the category 'software'
          'Method_ID': [None,returnStarInt,'Method.ID',False],                                                # Pointer to '_Method.ID'
          'Method_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Method.Sf_framecode',False],# Pointer to a saveframe of the category 'method'
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Binding_value_list_ID': [None,returnStarInt,'Binding_value_list.ID',True],                         # Pointer to '_Binding_value_list.ID'

                },

        'tagNames': ['Software_ID', 'Software_label', 'Method_ID', 'Method_label', 'Entry_ID', 'Binding_value_list_ID'],
        'sourcePrimaryKeys': ['Software_ID', 'Entry_ID', 'Binding_value_list_ID'],

            },

      'Binding_result': {

        'tags': {

          'ID': [None,returnStarInt,None,True],                                                               # Unique identifier for the observed binding constant.
          'Experiment_ID': [None,returnStarInt,'Experiment.ID',False],                                        # Pointer to '_Experiment.ID'
          'Assembly_ID': [None,returnStarInt,'Assembly.ID',True],                                             # Pointer to '_Assembly.ID'
          'Atm_obs_assembly_atom_ID': [None,returnStarInt,'Atom.Assembly_atom_ID',False],                     # Pointer to '_Atom.Assembly_atom_ID'
          'Atm_obs_entity_assembly_ID': [None,returnStarInt,'Entity_assembly.ID',True],                       # Pointer to '_Entity_assembly.ID'
          'Atm_obs_entity_ID': [None,returnStarInt,'Entity.ID',True],                                         # Pointer to '_Entity.ID'
          'Atm_obs_comp_index_ID': [None,returnStarInt,'Entity_comp_index.ID',True],                          # Pointer to '_Entity_comp_index.ID'
          'Atm_obs_seq_ID': [None,returnStarInt,'Entity_poly_seq.Num',True],                                  # Pointer to '_Entity_poly_seq.Num'
          'Atm_obs_comp_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Chem_comp.ID',True],      # Pointer to '_Chem_comp.ID'
          'Atm_obs_atom_ID': [None,lambda x = value: returnStarAtCode(x,length = 12),'Chem_comp_atom.Atom_ID',True],# Pointer to '_Chem_comp_atom.Atom_ID'
          'Atm_obs_atom_type': [None,lambda x = value: returnStarCode(x,length = 15),None,True],              # Standard symbol used to define the atom element type.
          'Atm_obs_atom_isotope_number': [None,returnStarInt,None,False],                                     # ?
          'Resonance_ID': [None,returnStarInt,'Resonance.ID',False],                                          # ?
          'Atm_obs_auth_entity_assembly_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],# ?
          'Atm_obs_auth_seq_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],           # An alternative identifier for Seq_id that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Seq_ID or Comp_index_ID.
          'Atm_obs_auth_comp_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],          # An alternative identifier for Comp_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Atm_obs_auth_atom_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],          # An alternative identifier for Atom_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Expt_observed_param': [None,lambda x = value: returnStarLine(x,length = 31),None,False],           # ?
          'Val_type': [None,lambda x = value: returnStarLine(x,length = 31),None,False],                      # ?
          'Val': [None,returnStarFloat,None,False],                                                           # Binding value estimated from a fit of a binding titration data set.
          'Val_err': [None,returnStarFloat,None,False],                                                       # Estimated error in the binding constant.
          'Val_units': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                     # ?
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Binding_value_list_ID': [None,returnStarInt,'Binding_value_list.ID',True],                         # Pointer to '_Binding_value_list.ID'

                },

        'tagNames': ['ID', 'Experiment_ID', 'Assembly_ID', 'Atm_obs_assembly_atom_ID', 'Atm_obs_entity_assembly_ID', 'Atm_obs_entity_ID', 'Atm_obs_comp_index_ID', 'Atm_obs_seq_ID', 'Atm_obs_comp_ID', 'Atm_obs_atom_ID', 'Atm_obs_atom_type', 'Atm_obs_atom_isotope_number', 'Resonance_ID', 'Atm_obs_auth_entity_assembly_ID', 'Atm_obs_auth_seq_ID', 'Atm_obs_auth_comp_ID', 'Atm_obs_auth_atom_ID', 'Expt_observed_param', 'Val_type', 'Val', 'Val_err', 'Val_units', 'Entry_ID', 'Binding_value_list_ID'],
        'sourcePrimaryKeys': ['ID', 'Entry_ID', 'Binding_value_list_ID'],

            },

      'Binding_partners': {

        'tags': {

          'Binding_result_ID': [None,returnStarInt,'Binding_result.ID',True],                                 # Pointer to '_Binding_result.ID'
          'Assembly_ID': [None,returnStarInt,'Assembly.ID',True],                                             # Pointer to '_Assembly.ID'
          'Entity_assembly_ID': [None,returnStarInt,'Entity_assembly.ID',True],                               # Pointer to '_Entity_assembly.ID'
          'Entity_assembly_name': [None,lambda x = value: returnStarLine(x,length = 127),None,False],         # ?
          'Entity_ID': [None,returnStarInt,'Entity.ID',True],                                                 # Pointer to '_Entity.ID'
          'Entity_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Entity.Sf_framecode',False],# ?
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Binding_value_list_ID': [None,returnStarInt,'Binding_value_list.ID',True],                         # Pointer to '_Binding_value_list.ID'

                },

        'tagNames': ['Binding_result_ID', 'Assembly_ID', 'Entity_assembly_ID', 'Entity_assembly_name', 'Entity_ID', 'Entity_label', 'Entry_ID', 'Binding_value_list_ID'],
        'sourcePrimaryKeys': ['Assembly_ID', 'Entity_ID', 'Entry_ID', 'Binding_value_list_ID'],

            }

        },

    'tableNames': ['Binding_experiment', 'Binding_software', 'Binding_result', 'Binding_partners']

    },

  'binding_param_list': {

    'name': 'Binding_param_list',

    'tags': {

      'Sf_category': ['binding_param_list',lambda x = value: returnStarCode(x,length = 127),None,True],       # Category definition for the information content of the saveframe
      'Sf_framecode': [None,lambda x = value: returnStarCode(x,length = 127),None,False],                     # A label for the saveframe that describes in very brief terms the information contained in the saveframe.
      'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                     # Pointer to '_Entry.ID'
      'ID': [None,returnStarInt,None,True],                                                                   # Unique identifier for the list of data values used to calculate a pKa value.
      'Binding_value_list_ID': [None,returnStarInt,'Binding_value_list.ID',True],                             # Pointer to '_Binding_value_list.ID'
      'Binding_value_list_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Binding_value_list.Sf_framecode',True],# Pointer to the saveframe where the binding constant values are reported that were calculated from the measured data values provided in this save frame.
      'Concentration_val_units': [None,lambda x = value: returnStarCode(x,length = 15),None,True],            # Units for the concentration values reported in the save frame.
      'Observed_param': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                   # The experimental parameter measured when collecting the data used to calculate binding constants.
      'Data_file_name': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                   # The name of the file submitted with this depostion that contains the quantitative data for this saveframe.
      'Details': [None,returnStarString,None,False],                                                          # Text describing the reported binding parameter values.
      'Text_data_format': [None,lambda x = value: returnStarLine(x,length = 31),None,False],                  # The data format used to represent the binding titration data as ASCII text in the text block that is the value to the '_Binding_param_list.Text_data' tag.
      'Text_data': [None,returnStarString,None,False],                                                        # A set of binding titration data formatted as ASCII text.

            },

    'tagNames': ['Sf_category', 'Sf_framecode', 'Entry_ID', 'ID', 'Binding_value_list_ID', 'Binding_value_list_label', 'Concentration_val_units', 'Observed_param', 'Data_file_name', 'Details', 'Text_data_format', 'Text_data'],
    'sourcePrimaryKeys': ['Entry_ID', 'ID'],

    'tables': {

      'Binding_param': {

        'tags': {

          'ID': [None,returnStarInt,None,True],                                                               # Unique identifier for the observed parameter value.
          'Binding_result_ID': [None,returnStarInt,'Binding_result.ID',True],                                 # Pointer to '_Binding_result.ID'
          'Concentration_val': [None,returnStarFloat,None,True],                                              # Concentration value at which the observed parameter value was measured.
          'Concentration_val_err': [None,returnStarFloat,None,False],                                         # Error in the measured value.
          'Concentration_val_units': [None,lambda x = value: returnStarCode(x,length = 15),None,False],       # ?
          'Observed_param_val': [None,returnStarFloat,None,True],                                             # Value for the observed parameter.
          'Observed_param_val_err': [None,returnStarFloat,None,False],                                        # Error in the reported parameter value.
          'Observed_param': [None,lambda x = value: returnStarCode(x,length = 31),None,False],                # ?
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Binding_param_list_ID': [None,returnStarInt,'Binding_param_list.ID',True],                         # Pointer to '_Binding_param_list.ID'

                },

        'tagNames': ['ID', 'Binding_result_ID', 'Concentration_val', 'Concentration_val_err', 'Concentration_val_units', 'Observed_param_val', 'Observed_param_val_err', 'Observed_param', 'Entry_ID', 'Binding_param_list_ID'],
        'sourcePrimaryKeys': ['ID', 'Entry_ID', 'Binding_param_list_ID'],

            }

        },

    'tableNames': ['Binding_param']

    },

  'deduced_secd_struct_features': {

    'name': 'Deduced_secd_struct_list',

    'tags': {

      'Sf_category': ['deduced_secd_struct_features',lambda x = value: returnStarCode(x,length = 127),None,True],# Category definition for the information content of the saveframe
      'Sf_framecode': [None,lambda x = value: returnStarCode(x,length = 127),None,False],                     # A label for the saveframe that describes in very brief terms the information contained in the saveframe.
      'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                     # Pointer to '_Entry.ID'
      'ID': [None,returnStarInt,None,True],                                                                   # Unique identifier for the list of reported secondary structure features.
      'Data_file_name': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                   # The name of the file submitted with this depostion that contains the quantitative data for this saveframe.
      'Details': [None,returnStarString,None,False],                                                          # Text providing additional information about the set of secondary structural elements and their derivation.
      'Sample_condition_list_ID': [None,returnStarInt,'Sample_condition_list.ID',True],                       # Pointer to '_Sample_condition_list.ID'
      'Sample_condition_list_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Sample_condition_list.Sf_framecode',True],# Pointer to a saveframe of the category 'sample_conditions'
      'Residue_struct_value_details': [None,returnStarString,None,False],                                     # Text providing additional information about the values assigned to specific residues in the secondary structures.
      'Text_data_format': [None,lambda x = value: returnStarLine(x,length = 31),None,False],                  # The data format used to represent the secondary structure data as ASCII text in the text block that is the value to the '_Deduced_secd_struct_list.Text_data' tag.
      'Text_data': [None,returnStarString,None,False],                                                        # A set of secondary structure data formatted as ASCII text.

            },

    'tagNames': ['Sf_category', 'Sf_framecode', 'Entry_ID', 'ID', 'Data_file_name', 'Details', 'Sample_condition_list_ID', 'Sample_condition_list_label', 'Residue_struct_value_details', 'Text_data_format', 'Text_data'],
    'sourcePrimaryKeys': ['Entry_ID', 'ID'],

    'tables': {

      'Deduced_secd_struct_experiment': {

        'tags': {

          'Experiment_ID': [None,returnStarInt,'Experiment.ID',True],                                         # Pointer to '_Experiment.ID'
          'Experiment_name': [None,lambda x = value: returnStarLine(x,length = 127),'Experiment.Name',False], # Pointer to a saveframe of the category 'NMR_spectrometer_expt'
          'Sample_ID': [None,returnStarInt,'Sample.ID',True],                                                 # Pointer to '_Sample.ID'
          'Sample_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Sample.Sf_framecode',True],# Pointer to a saveframe of the category 'sample'
          'Sample_state': [None,lambda x = value: returnStarLine(x,length = 31),None,True],                   # Physical state of the sample either anisotropic or isotropic.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Deduced_secd_struct_list_ID': [None,returnStarInt,'Deduced_secd_struct_list.ID',True],             # Pointer to '_Deduced_secd_struct_list.ID'

                },

        'tagNames': ['Experiment_ID', 'Experiment_name', 'Sample_ID', 'Sample_label', 'Sample_state', 'Entry_ID', 'Deduced_secd_struct_list_ID'],
        'sourcePrimaryKeys': ['Experiment_ID', 'Sample_ID', 'Sample_state', 'Entry_ID', 'Deduced_secd_struct_list_ID'],

            },

      'Deduced_secd_struct_software': {

        'tags': {

          'Software_ID': [None,returnStarInt,'Software.ID',True],                                             # Pointer to '_Software.ID'
          'Software_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Software.Sf_framecode',True],# Pointer to a saveframe of the category 'software'
          'Method_ID': [None,returnStarInt,'Method.ID',False],                                                # Pointer to '_Method.ID'
          'Method_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Method.Sf_framecode',False],# Pointer to a saveframe of the category 'method'
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Deduced_secd_struct_list_ID': [None,returnStarInt,'Deduced_secd_struct_list.ID',True],             # Pointer to '_Deduced_secd_struct_list.ID'

                },

        'tagNames': ['Software_ID', 'Software_label', 'Method_ID', 'Method_label', 'Entry_ID', 'Deduced_secd_struct_list_ID'],
        'sourcePrimaryKeys': ['Software_ID', 'Entry_ID', 'Deduced_secd_struct_list_ID'],

            },

      'Deduced_secd_struct_exptl': {

        'tags': {

          'ID': [None,returnStarInt,None,True],                                                               # An integer value that uniquely defines the secondary structure in the list.
          'Entity_assembly_ID': [None,returnStarInt,'Entity_assembly.ID',True],                               # Pointer to '_Entity_assembly.ID'
          'Entity_ID': [None,returnStarInt,'Entity.ID',True],                                                 # Pointer to '_Entity.ID'
          'Comp_index_ID_start': [None,returnStarInt,'Entity_comp_index.ID',True],                            # Pointer to '_Entity_comp_index.ID'
          'Comp_index_ID_end': [None,returnStarInt,'Entity_comp_index.ID',True],                              # Pointer to '_Entity_comp_index.ID'
          'Seq_ID_start': [None,returnStarInt,'Entity_poly_seq.Num',False],                                   # Pointer to '_Entity_poly_seq.Num'
          'Seq_ID_end': [None,returnStarInt,'Entity_poly_seq.Num',False],                                     # Pointer to '_Entity_poly_seq.Num'
          'Auth_seq_ID_start': [None,lambda x = value: returnStarCode(x,length = 12),None,False],             # An alternative identifier for Seq_id that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Seq_ID or Comp_index_ID.
          'Auth_seq_ID_end': [None,lambda x = value: returnStarCode(x,length = 12),None,False],               # An alternative identifier for Seq_id that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Seq_ID or Comp_index_ID.
          'Name': [None,lambda x = value: returnStarLine(x,length = 31),None,True],                           # Name assigned to the secondary structural element.
          'Code': [None,lambda x = value: returnStarCode(x,length = 31),None,True],                           # Code that defines the type of secondary structural element.
          'Static_field_orientation_angle': [None,returnStarFloat,None,False],                                # The angle between the axis of+BA1528 a helical structural element and the static field (Bo) for a solid state sample.
          'Selection_method_ID': [None,returnStarInt,'Method.ID',False],                                      # Pointer to '_Method.ID'
          'Selection_method_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Method.Sf_framecode',False],# Pointer to a saveframe of the category 'method'
          'Details': [None,returnStarString,None,False],                                                      # Text providing additional information regarding the secondary structure element.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Deduced_secd_struct_list_ID': [None,returnStarInt,'Deduced_secd_struct_list.ID',True],             # Pointer to '_Deduced_secd_struct_list.ID'

                },

        'tagNames': ['ID', 'Entity_assembly_ID', 'Entity_ID', 'Comp_index_ID_start', 'Comp_index_ID_end', 'Seq_ID_start', 'Seq_ID_end', 'Auth_seq_ID_start', 'Auth_seq_ID_end', 'Name', 'Code', 'Static_field_orientation_angle', 'Selection_method_ID', 'Selection_method_label', 'Details', 'Entry_ID', 'Deduced_secd_struct_list_ID'],
        'sourcePrimaryKeys': ['ID', 'Entry_ID', 'Deduced_secd_struct_list_ID'],

            },

      'Deduced_secd_struct_feature': {

        'tags': {

          'ID': [None,returnStarInt,None,True],                                                               # Unique identifier for the reported secondary structure feature.
          'Assembly_atom_ID': [None,returnStarInt,'Atom.Assembly_atom_ID',False],                             # Pointer to '_Atom.Assembly_atom_ID'
          'Entity_assembly_ID': [None,returnStarInt,'Entity_assembly.ID',True],                               # Pointer to '_Entity_assembly.ID'
          'Entity_ID': [None,returnStarInt,'Entity.ID',True],                                                 # Pointer to '_Entity.ID'
          'Comp_index_ID': [None,returnStarInt,'Entity_comp_index.ID',True],                                  # Pointer to '_Entity_comp_index.ID'
          'Seq_ID': [None,returnStarInt,'Entity_poly_seq.Num',True],                                          # Pointer to '_Entity_poly_seq.Num'
          'Comp_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Chem_comp.ID',True],              # Pointer to '_Chem_comp.ID'
          'Atom_ID': [None,lambda x = value: returnStarAtCode(x,length = 12),'Chem_comp_atom.Atom_ID',True],  # Pointer to '_Chem_comp_atom.Atom_ID'
          'Atom_type': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                     # Standard symbol used to define the atom element type.
          'Chem_comp_struct_val': [None,returnStarFloat,None,True],                                           # A value defining the assignment of the chemical component to a secondary structure feature.
          'Chem_comp_struct_element_type': [None,lambda x = value: returnStarCode(x,length = 15),None,True],  # Enter a name for this secondary structure element
          'Figure_of_merit': [None,returnStarFloat,None,False],                                               # A value that indicates the certainty with which this secondary structure feature has been determined.
          'Spin_system_ID': [None,returnStarInt,'Spin_system.ID',False],                                      # Pointer to '_Spin_system.ID'
          'Auth_entity_assembly_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],       # An alternative identifier for Entity_assembly_ID that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Entity_assembly_ID.
          'Auth_seq_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                   # An alternative identifier for Seq_id that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Seq_ID or Comp_index_ID.
          'Auth_comp_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                  # An alternative identifier for Comp_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Auth_atom_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                  # An alternative identifier for Atom_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Deduced_secd_struct_list_ID': [None,returnStarInt,'Deduced_secd_struct_list.ID',True],             # Pointer to '_Deduced_secd_struct_list.ID'

                },

        'tagNames': ['ID', 'Assembly_atom_ID', 'Entity_assembly_ID', 'Entity_ID', 'Comp_index_ID', 'Seq_ID', 'Comp_ID', 'Atom_ID', 'Atom_type', 'Chem_comp_struct_val', 'Chem_comp_struct_element_type', 'Figure_of_merit', 'Spin_system_ID', 'Auth_entity_assembly_ID', 'Auth_seq_ID', 'Auth_comp_ID', 'Auth_atom_ID', 'Entry_ID', 'Deduced_secd_struct_list_ID'],
        'sourcePrimaryKeys': ['ID', 'Entity_assembly_ID', 'Comp_index_ID', 'Atom_ID', 'Entry_ID', 'Deduced_secd_struct_list_ID'],

            }

        },

    'tableNames': ['Deduced_secd_struct_experiment', 'Deduced_secd_struct_software', 'Deduced_secd_struct_exptl', 'Deduced_secd_struct_feature']

    },

  'deduced_hydrogen_bonds': {

    'name': 'Deduced_H_bond_list',

    'tags': {

      'Sf_category': ['deduced_hydrogen_bonds',lambda x = value: returnStarCode(x,length = 127),None,True],   # Category definition for the information content of the saveframe
      'Sf_framecode': [None,lambda x = value: returnStarCode(x,length = 127),None,False],                     # A label for the saveframe that describes in very brief terms the information contained in the saveframe.
      'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                     # Pointer to '_Entry.ID'
      'ID': [None,returnStarInt,None,True],                                                                   # Unique identifier for the list of reported hydrogen bonds deduced from experimental data.
      'Data_file_name': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                   # The name of the file submitted with this depostion that contains the quantitative data for this saveframe.
      'Details': [None,returnStarString,None,False],                                                          # Text providing additional information regarding the hydrogen bonds.
      'Sample_condition_list_ID': [None,returnStarInt,'Sample_condition_list.ID',True],                       # Pointer to '_Sample_condition_list.ID'
      'Sample_condition_list_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Sample_condition_list.Sf_framecode',True],# Pointer to a saveframe of the category 'sample_conditions'
      'Text_data_format': [None,lambda x = value: returnStarLine(x,length = 31),None,False],                  # The data format used to represent the deduced hydrogen bond data as ASCII text in the text block that is the value to the '_Deduced_H_bond_list.Text_data' tag.
      'Text_data': [None,returnStarString,None,False],                                                        # A set of hydrogen bond data formatted as ASCII text.

            },

    'tagNames': ['Sf_category', 'Sf_framecode', 'Entry_ID', 'ID', 'Data_file_name', 'Details', 'Sample_condition_list_ID', 'Sample_condition_list_label', 'Text_data_format', 'Text_data'],
    'sourcePrimaryKeys': ['Entry_ID', 'ID'],

    'tables': {

      'Deduced_H_bond_experiment': {

        'tags': {

          'Experiment_ID': [None,returnStarInt,'Experiment.ID',True],                                         # Pointer to '_Experiment.ID'
          'Experiment_name': [None,lambda x = value: returnStarLine(x,length = 127),'Experiment.Name',False], # Pointer to a saveframe of the category 'NMR_spectrometer_expt'
          'Sample_ID': [None,returnStarInt,'Sample.ID',True],                                                 # Pointer to '_Sample.ID'
          'Sample_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Sample.Sf_framecode',True],# Pointer to a saveframe of the category 'sample'
          'Sample_state': [None,lambda x = value: returnStarLine(x,length = 31),None,True],                   # Physical state of the sample either anisotropic or isotropic.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Deduced_H_bond_list_ID': [None,returnStarInt,'Deduced_H_bond_list.ID',True],                       # Pointer to '_Deduced_H_bond_list.ID'

                },

        'tagNames': ['Experiment_ID', 'Experiment_name', 'Sample_ID', 'Sample_label', 'Sample_state', 'Entry_ID', 'Deduced_H_bond_list_ID'],
        'sourcePrimaryKeys': ['Experiment_ID', 'Sample_ID', 'Sample_state', 'Entry_ID', 'Deduced_H_bond_list_ID'],

            },

      'Deduced_H_bond_software': {

        'tags': {

          'Software_ID': [None,returnStarInt,'Software.ID',True],                                             # Pointer to '_Software.ID'
          'Software_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Software.Sf_framecode',True],# Pointer to a saveframe of the category 'software'
          'Method_ID': [None,returnStarInt,'Method.ID',False],                                                # Pointer to '_Method.ID'
          'Method_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Method.Sf_framecode',False],# Pointer to a saveframe of the category 'method'
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Deduced_H_bond_list_ID': [None,returnStarInt,'Deduced_H_bond_list.ID',True],                       # Pointer to '_Deduced_H_bond_list.ID'

                },

        'tagNames': ['Software_ID', 'Software_label', 'Method_ID', 'Method_label', 'Entry_ID', 'Deduced_H_bond_list_ID'],
        'sourcePrimaryKeys': ['Software_ID', 'Entry_ID', 'Deduced_H_bond_list_ID'],

            },

      'Deduced_H_bond': {

        'tags': {

          'ID': [None,returnStarInt,None,True],                                                               # Unique identifier for the hydrogen bond deduced from experimental data.
          'Donor_atom_ID': [None,lambda x = value: returnStarAtCode(x,length = 12),'Chem_comp_atom.Atom_ID',True],# Pointer to '_Chem_comp_atom.Atom_ID'. The atom designated is the one that is donating the proton in the hydrogen bond.
          'Heavy_atom_assembly_atom_ID_1': [None,returnStarInt,'Atom.Assembly_atom_ID',False],                # Pointer to '_Atom.Assembly_atom_ID'
          'Heavy_atom_entity_assembly_ID_1': [None,returnStarInt,'Entity_assembly.ID',True],                  # Pointer to '_Entity_assembly.ID'
          'Heavy_atom_entity_ID_1': [None,returnStarInt,'Entity.ID',True],                                    # Pointer to '_Entity.ID'
          'Heavy_atom_comp_index_ID_1': [None,returnStarInt,'Entity_comp_index.ID',True],                     # Pointer to '_Entity_comp_index.ID'
          'Heavy_atom_seq_ID_1': [None,returnStarInt,'Entity_poly_seq.Num',True],                             # Pointer to '_Entity_poly_seq.Num'
          'Heavy_atom_comp_ID_1': [None,lambda x = value: returnStarCode(x,length = 12),'Chem_comp.ID',True], # Pointer to '_Chem_comp.ID'
          'Heavy_atom_atom_ID_1': [None,lambda x = value: returnStarAtCode(x,length = 12),'Chem_comp_atom.Atom_ID',True],# Pointer to '_Chem_comp_atom.Atom_ID'
          'Heavy_atom_atom_type_1': [None,lambda x = value: returnStarCode(x,length = 15),None,True],         # Standard symbol used to define the atom element type.
          'Heavy_atom_assembly_atom_ID_2': [None,returnStarInt,'Atom.Assembly_atom_ID',False],                # Pointer to '_Atom.Assembly_atom_ID'
          'Heavy_atom_entity_assembly_ID_2': [None,returnStarInt,'Entity_assembly.ID',True],                  # Pointer to '_Entity_assembly.ID'
          'Heavy_atom_entity_ID_2': [None,returnStarInt,'Entity.ID',True],                                    # Pointer to '_Entity.ID'
          'Heavy_atom_comp_index_ID_2': [None,returnStarInt,'Entity_comp_index.ID',True],                     # Pointer to '_Entity_comp_index.ID'
          'Heavy_atom_seq_ID_2': [None,returnStarInt,'Entity_poly_seq.Num',True],                             # Pointer to '_Entity_poly_seq.Num'
          'Heavy_atom_comp_ID_2': [None,lambda x = value: returnStarCode(x,length = 12),'Chem_comp.ID',True], # Pointer to '_Chem_comp.ID'
          'Heavy_atom_atom_ID_2': [None,lambda x = value: returnStarAtCode(x,length = 12),'Chem_comp_atom.Atom_ID',True],# Pointer to '_Chem_comp_atom.Atom_ID'
          'Heavy_atom_atom_type_2': [None,lambda x = value: returnStarCode(x,length = 15),None,True],         # Standard symbol used to define the atom element type.
          'Heavy_atom_auth_entity_assembly_ID_1': [None,lambda x = value: returnStarCode(x,length = 15),None,False],# An alternative identifier for Entity_assembly_ID that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Entity_assembly_ID.
          'Heavy_atom_auth_seq_ID_1': [None,lambda x = value: returnStarCode(x,length = 15),None,False],      # An alternative identifier for Seq_id that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Seq_ID or Comp_index_ID.
          'Heavy_atom_auth_comp_ID_1': [None,lambda x = value: returnStarCode(x,length = 15),None,False],     # An alternative identifier for Comp_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Heavy_atom_auth_atom_ID_1': [None,lambda x = value: returnStarCode(x,length = 15),None,False],     # An alternative identifier for Atom_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Heavy_atom_auth_entity_assembly_ID_2': [None,lambda x = value: returnStarCode(x,length = 15),None,False],# An alternative identifier for Entity_assembly_ID that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Entity_assembly_ID.
          'Heavy_atom_auth_seq_ID_2': [None,lambda x = value: returnStarCode(x,length = 15),None,False],      # An alternative identifier for Seq_id that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Seq_ID or Comp_index_ID.
          'Heavy_atom_auth_comp_ID_2': [None,lambda x = value: returnStarCode(x,length = 15),None,False],     # An alternative identifier for Comp_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Heavy_atom_auth_atom_ID_2': [None,lambda x = value: returnStarCode(x,length = 15),None,False],     # An alternative identifier for Atom_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'H_atom_assembly_atom_ID': [None,returnStarInt,'Atom.Assembly_atom_ID',False],                      # Pointer to '_Atom.Assembly_atom_ID'
          'H_atom_entity_assembly_ID': [None,returnStarInt,'Entity_assembly.ID',True],                        # Pointer to '_Entity_assembly.ID'
          'H_atom_entity_ID': [None,returnStarInt,'Entity.ID',True],                                          # Pointer to '_Entity.ID'
          'H_atom_comp_index_ID': [None,returnStarInt,'Entity_comp_index.ID',True],                           # Pointer to '_Entity_comp_index.ID'
          'H_atom_seq_ID': [None,returnStarInt,'Entity_poly_seq.Num',True],                                   # Pointer to '_Entity_poly_seq.Num'
          'H_atom_comp_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Chem_comp.ID',True],       # Pointer to '_Chem_comp.ID'
          'H_atom_ID': [None,lambda x = value: returnStarAtCode(x,length = 12),'Chem_comp_atom.Atom_ID',True],# Pointer to '_Chem_comp_atom.Atom_ID'
          'H_atom_auth_entity_assembly_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],# An alternative identifier for Entity_assembly_ID that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Entity_assembly_ID.
          'H_atom_auth_seq_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],            # An alternative identifier for Seq_id that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Seq_ID or Comp_index_ID.
          'H_atom_auth_comp_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],           # An alternative identifier for Comp_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'H_atom_auth_atom_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],           # An alternative identifier for Atom_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Figure_of_merit': [None,returnStarFloat,None,False],                                               # A value that indicates the certainty with which this hydrogen bond is believed to exist.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Deduced_hydrogen_bond_list_ID': [None,returnStarInt,'Deduced_H_bond_list.ID',True],                # Pointer to '_Deduced_H_bond_list.ID'

                },

        'tagNames': ['ID', 'Donor_atom_ID', 'Heavy_atom_assembly_atom_ID_1', 'Heavy_atom_entity_assembly_ID_1', 'Heavy_atom_entity_ID_1', 'Heavy_atom_comp_index_ID_1', 'Heavy_atom_seq_ID_1', 'Heavy_atom_comp_ID_1', 'Heavy_atom_atom_ID_1', 'Heavy_atom_atom_type_1', 'Heavy_atom_assembly_atom_ID_2', 'Heavy_atom_entity_assembly_ID_2', 'Heavy_atom_entity_ID_2', 'Heavy_atom_comp_index_ID_2', 'Heavy_atom_seq_ID_2', 'Heavy_atom_comp_ID_2', 'Heavy_atom_atom_ID_2', 'Heavy_atom_atom_type_2', 'Heavy_atom_auth_entity_assembly_ID_1', 'Heavy_atom_auth_seq_ID_1', 'Heavy_atom_auth_comp_ID_1', 'Heavy_atom_auth_atom_ID_1', 'Heavy_atom_auth_entity_assembly_ID_2', 'Heavy_atom_auth_seq_ID_2', 'Heavy_atom_auth_comp_ID_2', 'Heavy_atom_auth_atom_ID_2', 'H_atom_assembly_atom_ID', 'H_atom_entity_assembly_ID', 'H_atom_entity_ID', 'H_atom_comp_index_ID', 'H_atom_seq_ID', 'H_atom_comp_ID', 'H_atom_ID', 'H_atom_auth_entity_assembly_ID', 'H_atom_auth_seq_ID', 'H_atom_auth_comp_ID', 'H_atom_auth_atom_ID', 'Figure_of_merit', 'Entry_ID', 'Deduced_hydrogen_bond_list_ID'],
        'sourcePrimaryKeys': ['ID', 'Entry_ID', 'Deduced_hydrogen_bond_list_ID'],

            }

        },

    'tableNames': ['Deduced_H_bond_experiment', 'Deduced_H_bond_software', 'Deduced_H_bond']

    },

  'conformer_statistics': {

    'name': 'Conformer_stat_list',
    'saveFrameCode': 'conformer_statistics',

    'tags': {

      'Sf_category': ['conformer_statistics',lambda x = value: returnStarCode(x,length = 127),None,True],     # Category definition for the information content of the saveframe
      'Sf_framecode': [None,lambda x = value: returnStarCode(x,length = 127),None,False],                     # A label for the saveframe that describes in very brief terms the information contained in the saveframe.
      'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                     # Pointer to '_Entry.ID'
      'ID': [None,returnStarInt,None,True],                                                                   # An integer value that uniquely identifies this saveframe of conformer statistics from other saveframes of this category in an entry.
      'Conformer_ensemble_only': [None,lambda x = value: returnStarYesNo(x,length = 3),None,True],            # Check this box if your atomic coordinate file contains data for an ensemble of structures$ where one structure from the ensemble will be designated as a representative structure. All of the members of the ensemble have been calculated using the same method.
      'Both_ensemble_and_rep_conformer': [None,lambda x = value: returnStarYesNo(x,length = 3),None,True],    # Select this box if your atomic coordinate file contains data for an ensemble of conformers and a representative conformer derived using a method different from that used for the other conformers in the file.  An example would be a file that contains an ensemble of conformers calculated from the NMR constraints and one conformer that was derived as an averaged minimized structure from the other conformers in the file.
      'Representative_conformer_only': [None,lambda x = value: returnStarYesNo(x,length = 3),None,True],      # Check this box if your atomic coordinate file contains the data for a single structure.
      'Data_file_name': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                   # The name of the file submitted with this depostion that contains the quantitative data for this saveframe.
      'Text_data_format': [None,lambda x = value: returnStarLine(x,length = 31),None,False],                  # The data format used to represent the conformer statistical data as ASCII text in the text block that is the value to the '_Assigned_chem_shift.Text_data' tag.
      'Text_data': [None,returnStarString,None,False],                                                        # A set of conformer statistics data formatted as ASCII text.
      'Original_conformer_stats_file_ID': [None,returnStarInt,None,False],                                    # Local unique identifier assigned to the conformer statistics file submitted by a depositor.
      'Conf_family_coord_set_ID': [None,returnStarInt,'Conformer_family_coord_set.ID',True],                  # Pointer to '_Conformer_family_coord_set.ID'
      'Conf_family_coord_set_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Conformer_family_coord_set.Sf_framecode',True],# Pointer to a saveframe of the category conformer_family_coord_set.
      'Representative_conformer_ID': [None,returnStarInt,'Representative_conformer.ID',False],                # Pointer to '_Representative_conformer.ID'
      'Representative_conformer_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Representative_conformer.Sf_framecode',False],# Pointer to saveframe of category 'representative_conformer'
      'Conformer_calculated_total_num': [None,returnStarInt,None,True],                                       # Enter the total number of conformers that were calculated.
      'Conformer_submitted_total_num': [None,returnStarInt,None,True],                                        # Provide the number of conformers deposited.
      'Conformer_selection_criteria': [None,lambda x = value: returnStarLine(x,length = 127),None,True],      # Give the criteria used to select the conformers that have been deposited from the total number of calculated conformers.
      'Representative_conformer': [None,returnStarInt,None,True],                                             # From the deposited family of conformers$ enter the number or position of the conformer in the family that is representative for the family.
      'Rep_conformer_selection_criteria': [None,returnStarString,None,False],                                 # Enter the criteria used to select the conformer defined as representative of the conformer family.
      'Statistical_struct_param_details': [None,returnStarString,None,False],                                 # Text providing additional information regarding the reported statistical parameters for the conformer family and representative conformer.
      'Details': [None,returnStarString,None,False],                                                          # Text providing additional information regarding the conformer statistics.

            },

    'tagNames': ['Sf_category', 'Sf_framecode', 'Entry_ID', 'ID', 'Conformer_ensemble_only', 'Both_ensemble_and_rep_conformer', 'Representative_conformer_only', 'Data_file_name', 'Text_data_format', 'Text_data', 'Original_conformer_stats_file_ID', 'Conf_family_coord_set_ID', 'Conf_family_coord_set_label', 'Representative_conformer_ID', 'Representative_conformer_label', 'Conformer_calculated_total_num', 'Conformer_submitted_total_num', 'Conformer_selection_criteria', 'Representative_conformer', 'Rep_conformer_selection_criteria', 'Statistical_struct_param_details', 'Details'],
    'sourcePrimaryKeys': ['Entry_ID', 'ID'],

    'tables': {

      'Conformer_stat_list_ens': {

        'tags': {

          'Stats_not_available': [None,lambda x = value: returnStarYesNo(x,length = 3),None,False],           # Depositors are strongly encouraged to enter a few statistical parameters that described the deposited ensemble of conformers. If this information cannot be entered at the time of deposition$ check the box provided. After checking the box and clicking on the 'save' button$ the statistical fields will no longer be marked mandatory and you will be able to complete and submit your deposition without providing this information.
          'Ramachan_most_favored_pct': [None,returnStarFloat,None,False],                                     # Percent of residues in the most favored region of the Ramachandran plot as defined for proteins.
          'Ramachan_allowed_pct': [None,returnStarFloat,None,False],                                          # Percent of residues in the allowed region of the Ramachandran plot as defined for proteins.
          'Ramachan_gen_allowed_pct': [None,returnStarFloat,None,False],                                      # Percent of residues in the generously allowed region of the Ramachandran plot as defined for proteins.
          'Ramachan_disallowed_pct': [None,returnStarFloat,None,False],                                       # Percent of residues in the disallowed region of the Ramachandran plot as defined for proteins.
          'Total_E_value_': [None,returnStarFloat,None,False],                                                # Total energy value calculated for the ensemble of conformers.
          'Total_E_value_err': [None,returnStarFloat,None,False],                                             # Estimated error in the total energy value calculated for the ensemble of conformers.
          'Bond_E_value': [None,returnStarFloat,None,False],                                                  # Bond energy value calculated for the ensemble of conformers.
          'Bond_E_value_err': [None,returnStarFloat,None,False],                                              # Estimated error in the bond energy value calculated for the ensemble of conformers.
          'Angle_E_value': [None,returnStarFloat,None,False],                                                 # Angle energy value calculated for the ensemble of conformers.
          'Angle_E_value_err': [None,returnStarFloat,None,False],                                             # Estimated error in the angle energy value calculated for the ensemble of conformers.
          'Improper_E_value': [None,returnStarFloat,None,False],                                              # Impropers energy value calculated for the ensemble of conformers.
          'Improper_E_value_err': [None,returnStarFloat,None,False],                                          # Estimated error in the impropers energy value calculated for the ensemble of conformers.
          'Van_der_Waals_E_value': [None,returnStarFloat,None,False],                                         # Van der Waals energy value calculated for the ensemble of conformers.
          'Van_der_Waals_E_value_err': [None,returnStarFloat,None,False],                                     # Estimated error in the Van der Waals energy value calculated for the ensemble of conformers.
          'Torsional_angle_E_value': [None,returnStarFloat,None,False],                                       # Torsion angle energy value calculated for the ensemble of conformers.
          'Torsional_angle_E_value_err': [None,returnStarFloat,None,False],                                   # Estimated error in the torsion angle energy value calculated for the ensemble of conformers.
          'NCS_E_value': [None,returnStarFloat,None,False],                                                   # Non-crystallographic symmetry energy value calculated for the ensemble of conformers.
          'NCS_E_value_err': [None,returnStarFloat,None,False],                                               # Estimated error in the non-crystallographic symmetry energy value calculated for the ensemble of conformers.
          'Lennard_Jones_E_value': [None,returnStarFloat,None,False],                                         # Leonard-Jones energy value calculated for the ensemble of conformers.
          'Lennard_Jones_E_value_err': [None,returnStarFloat,None,False],                                     # Estimated error in the Leonard-Jones energy value calculated for the ensemble of conformers.
          'Covalent_bond_rmsd': [None,returnStarFloat,None,False],                                            # Root mean squared deviation of bond lengths from idealized values.
          'Covalent_bond_rmsd_err': [None,returnStarFloat,None,False],                                        # Estimated error in the rmsd value for bond lengths from idealized values.
          'Bond_angle_rmsd': [None,returnStarFloat,None,False],                                               # Root mean squared deviation of bond angles from idealized values.
          'Bond_angle_rmsd_err': [None,returnStarFloat,None,False],                                           # Estimated error in the rmsd value for bond angles from idealized values.
          'Dihedral_angle_rmsd': [None,returnStarFloat,None,False],                                           # Root mean squared deviation of bond angles from idealized values.
          'Dihedral_angle_rmsd_err': [None,returnStarFloat,None,False],                                       # Estimated error in the rmsd value for bond angles from idealized values.
          'Improper_torsion_angle_rmsd': [None,returnStarFloat,None,False],                                   # Root mean squared deviation of improper angles from idealized values.
          'Improper_torsion_angle_rmsd_err': [None,returnStarFloat,None,False],                               # Estimated error in the rmsd value for improper angles from idealized values.
          'Peptide_planarity_rmsd': [None,returnStarFloat,None,False],                                        # Root mean squared deviation of peptide planarity from idealized values.
          'Peptide_planarity_rmsd_err': [None,returnStarFloat,None,False],                                    # Estimated error in the rmsd value for peptide planarity from idealized values.
          'Atm_coord_avg_rmsd_calc_method': [None,returnStarFloat,None,False],                                # Method used to calculate the average root mean squared deviation for the atomic coordinates for the ensemble of conformers.
          'BB_hvy_atm_coord_avg_rmsd': [None,returnStarFloat,None,False],                                     # Average root mean squared deviation for the backbone heavy atom coordinates for the ensemble of conformers.
          'BB_hvy_atm_coord_avg_rmsd_err': [None,returnStarFloat,None,False],                                 # Estimated error in the average rmsd for the backbone heavy atom coordinates for the ensemble of conformers.
          'BB_hvy_atm_coord_std_dev': [None,returnStarFloat,None,False],                                      # Standard deviation for the backbone heavy atom coordinates for the ensemble of conformers.
          'BB_hvy_atm_coord_std_dev_err': [None,returnStarFloat,None,False],                                  # Estimated error in the standard deviation for the backbone heavy atom coordinates for the ensemble of conformers.
          'BB_hvy_atm_residues_included': [None,lambda x = value: returnStarLine(x,length = 31),None,False],  # Residues included in the calculation of the backbone heavy atom statistics.
          'BB_hvy_atm_exclusions': [None,lambda x = value: returnStarLine(x,length = 31),None,False],         # List the heavy atoms excluded in calculating the backbone heavy atom coordinate statistics.
          'SC_hvy_atm_coord_avg_rmsd': [None,returnStarFloat,None,False],                                     # Average root mean squared deviation for the sidechain heavy atom coordinates for the ensemble of conformers.
          'SC_hvy_atm_coord_avg_rmsd_err': [None,returnStarFloat,None,False],                                 # Estimated error in the average rmsd for the sidechain heavy atom coordinates for the ensemble of conformers.
          'SC_hvy_atm_coord_std_dev': [None,returnStarFloat,None,False],                                      # Standard deviation for the sidechain heavy atom coordinates for the ensemble of conformers.
          'SC_hvy_atm_coord_std_dev_err': [None,returnStarFloat,None,False],                                  # Estimated error in the standard deviation for the sidechain heavy atom coordinates for the ensemble of conformers.
          'SC_hvy_atm_residues_included': [None,lambda x = value: returnStarLine(x,length = 31),None,False],  # Residues included in the calculation of the sidechain heavy atom statistics.
          'SC_hvy_atm_exclusions': [None,lambda x = value: returnStarLine(x,length = 31),None,False],         # List the heavy atoms excluded in calculating the sidechain heavy atom coordinate statistics.
          'All_hvy_atm_coord_avg_rmsd': [None,returnStarFloat,None,False],                                    # Average root mean squared deviation for all heavy atom coordinates for the ensemble of conformers.
          'All_hvy_atm_coord_avg_rmsd_err': [None,returnStarFloat,None,False],                                # Estimated error in the average rmsd for all heavy atom coordinates for the ensemble of conformers.
          'All_hvy_atm_coord_std_dev': [None,returnStarFloat,None,False],                                     # Standard deviation for all heavy atom coordinates for the ensemble of conformers.
          'All_hvy_atm_coord_std_dev_err': [None,returnStarFloat,None,False],                                 # Estimated error in the standard deviation for all heavy atom coordinates for the ensemble of conformers.
          'All_hvy_atm_residues_included': [None,lambda x = value: returnStarLine(x,length = 31),None,False], # Residues included in the calculation of all heavy atom statistics.
          'All_hvy_atm_exclusions': [None,lambda x = value: returnStarLine(x,length = 31),None,False],        # List the heavy atoms excluded in calculating the heavy atom coordinate statistics over 'all' heavy atoms.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Conformer_stat_list_ID': [None,returnStarInt,'Conformer_stat_list.ID',True],                       # Pointer to '_Conformer_stat_list.ID'

                },

        'tagNames': ['Stats_not_available', 'Ramachan_most_favored_pct', 'Ramachan_allowed_pct', 'Ramachan_gen_allowed_pct', 'Ramachan_disallowed_pct', 'Total_E_value_', 'Total_E_value_err', 'Bond_E_value', 'Bond_E_value_err', 'Angle_E_value', 'Angle_E_value_err', 'Improper_E_value', 'Improper_E_value_err', 'Van_der_Waals_E_value', 'Van_der_Waals_E_value_err', 'Torsional_angle_E_value', 'Torsional_angle_E_value_err', 'NCS_E_value', 'NCS_E_value_err', 'Lennard_Jones_E_value', 'Lennard_Jones_E_value_err', 'Covalent_bond_rmsd', 'Covalent_bond_rmsd_err', 'Bond_angle_rmsd', 'Bond_angle_rmsd_err', 'Dihedral_angle_rmsd', 'Dihedral_angle_rmsd_err', 'Improper_torsion_angle_rmsd', 'Improper_torsion_angle_rmsd_err', 'Peptide_planarity_rmsd', 'Peptide_planarity_rmsd_err', 'Atm_coord_avg_rmsd_calc_method', 'BB_hvy_atm_coord_avg_rmsd', 'BB_hvy_atm_coord_avg_rmsd_err', 'BB_hvy_atm_coord_std_dev', 'BB_hvy_atm_coord_std_dev_err', 'BB_hvy_atm_residues_included', 'BB_hvy_atm_exclusions', 'SC_hvy_atm_coord_avg_rmsd', 'SC_hvy_atm_coord_avg_rmsd_err', 'SC_hvy_atm_coord_std_dev', 'SC_hvy_atm_coord_std_dev_err', 'SC_hvy_atm_residues_included', 'SC_hvy_atm_exclusions', 'All_hvy_atm_coord_avg_rmsd', 'All_hvy_atm_coord_avg_rmsd_err', 'All_hvy_atm_coord_std_dev', 'All_hvy_atm_coord_std_dev_err', 'All_hvy_atm_residues_included', 'All_hvy_atm_exclusions', 'Entry_ID', 'Conformer_stat_list_ID'],
        'sourcePrimaryKeys': ['Entry_ID', 'Conformer_stat_list_ID'],

            },

      'Conformer_stat_list_rep': {

        'tags': {

          'Stats_not_available': [None,lambda x = value: returnStarYesNo(x,length = 3),None,False],           # Depositors are strongly encouraged to enter a few statistical parameters regarding the deposited representative conformer. If these data are not available$ please check the box provided. After checking the box and clicking on the 'save' button$ the statistical fields will no longer be marked as mandatovy and you will be able to complete and submit your deposition.
          'Ramachan_most_favored_pct': [None,returnStarFloat,None,False],                                     # Percent of residues in the most favored region of the Ramachandran plot as defined for proteins.
          'Ramachan_allowed_pct': [None,returnStarFloat,None,False],                                          # Percent of residues in the allowed region of the Ramachandran plot as defined for proteins.
          'Ramachan_gen_allowed_pct': [None,returnStarFloat,None,False],                                      # Percent of residues in the generously allowed region of the Ramachandran plot as defined for proteins.
          'Ramachan_disallowed_pct': [None,returnStarFloat,None,False],                                       # Percent of residues in the disallowed region of the Ramachandran plot as defined for proteins.
          'Total_E_value': [None,returnStarFloat,None,False],                                                 # Total energy value calculated for the representative conformer.
          'Total_E_value_err': [None,returnStarFloat,None,False],                                             # Estimated error in the total energy value calculated for the representative conformer.
          'Bond_E_value': [None,returnStarFloat,None,False],                                                  # Bond energy value calculated for the representative conformer.
          'Bond_E_value_err': [None,returnStarFloat,None,False],                                              # Estimated error in the bond energy value calculated for the representative conformer.
          'Angle_E_value': [None,returnStarFloat,None,False],                                                 # Angle energy value calculated for the representative conformer.
          'Angle_E_value_err': [None,returnStarFloat,None,False],                                             # Estimated error in the angle energy value calculated for the representative conformer.
          'Impropers_E_value': [None,returnStarFloat,None,False],                                             # Impropers energy value calculated for the representative conformer.
          'Impropers_E_value_err': [None,returnStarFloat,None,False],                                         # Estimated error in the impropers energy value calculated for the representative conformer.
          'Van_der_Waals_E_val': [None,returnStarFloat,None,False],                                           # Van der Waals energy value calculated for the representative conformer.
          'Van_der_Waals_E_val_err': [None,returnStarFloat,None,False],                                       # Estimated error in the Van der Waals energy value calculated for the representative conformer.
          'NOE_E_value': [None,returnStarFloat,None,False],                                                   # NOE energy value calculated for the representative conformer.
          'NOE_E_value_err': [None,returnStarFloat,None,False],                                               # Estimated error in the NOE energy value calculated for the representative conformer.
          'Torsional_E_value': [None,returnStarFloat,None,False],                                             # Torsion angle energy value calculated for the representative conformer.
          'Torsional_E_value_err': [None,returnStarFloat,None,False],                                         # Estimated error in the torsion angle energy value calculated for the representative conformer.
          'NCS_E_value': [None,returnStarFloat,None,False],                                                   # Non-crystallographic symmetry energy value calculated for the representative conformer.
          'NCS_E_value_err': [None,returnStarFloat,None,False],                                               # Estimated error in the non-crystallographic symmetry energy value calculated for the representative conformer.
          'Lennard_Jones_E_value': [None,returnStarFloat,None,False],                                         # Leonard-Jones energy value calculated for the representative conformer.
          'Lennard_Jones_E_value_err': [None,returnStarFloat,None,False],                                     # Estimated error in the Leonard-Jones energy value calculated for the representative conformer.
          'Bond_rmsd': [None,returnStarFloat,None,False],                                                     # Root mean squared deviation of bond lengths from idealized values.
          'Bond_rmsd_err': [None,returnStarFloat,None,False],                                                 # Estimated error in the rmsd value for bond lengths from idealized values.
          'Angle_rmsd': [None,returnStarFloat,None,False],                                                    # Root mean squared deviation of bond angles from idealized values.
          'Angle_rmsd_err': [None,returnStarFloat,None,False],                                                # Estimated error in the rmsd value for bond angles from idealized values.
          'Improper_torsion_angle_rmsd': [None,returnStarFloat,None,False],                                   # Root mean squared deviation of improper angles from idealized values.
          'Improper_torsion_angle_rmsd_err': [None,returnStarFloat,None,False],                               # Estimated error in the rmsd value for improper angles from idealized values.
          'Peptide_planarity_rmsd': [None,returnStarFloat,None,False],                                        # Root mean squared deviation of peptide planarity from idealized values.
          'Peptide_planarity_rmsd_err': [None,returnStarFloat,None,False],                                    # Estimated error in the rmsd value for peptide planarity from idealized values.
          'Struct_figure_of_merit': [None,returnStarFloat,None,False],                                        # A value that provides an estimate of the quality of the reported representative structure.
          'Struct_figure_of_merit_func_form': [None,lambda x = value: returnStarLine(x,length = 127),None,False],# The functional form of the structure figure of merit value.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Conformer_stat_list_ID': [None,returnStarInt,'Conformer_stat_list.ID',True],                       # Pointer to '_Conformer_stat_list.ID'

                },

        'tagNames': ['Stats_not_available', 'Ramachan_most_favored_pct', 'Ramachan_allowed_pct', 'Ramachan_gen_allowed_pct', 'Ramachan_disallowed_pct', 'Total_E_value', 'Total_E_value_err', 'Bond_E_value', 'Bond_E_value_err', 'Angle_E_value', 'Angle_E_value_err', 'Impropers_E_value', 'Impropers_E_value_err', 'Van_der_Waals_E_val', 'Van_der_Waals_E_val_err', 'NOE_E_value', 'NOE_E_value_err', 'Torsional_E_value', 'Torsional_E_value_err', 'NCS_E_value', 'NCS_E_value_err', 'Lennard_Jones_E_value', 'Lennard_Jones_E_value_err', 'Bond_rmsd', 'Bond_rmsd_err', 'Angle_rmsd', 'Angle_rmsd_err', 'Improper_torsion_angle_rmsd', 'Improper_torsion_angle_rmsd_err', 'Peptide_planarity_rmsd', 'Peptide_planarity_rmsd_err', 'Struct_figure_of_merit', 'Struct_figure_of_merit_func_form', 'Entry_ID', 'Conformer_stat_list_ID'],
        'sourcePrimaryKeys': ['Entry_ID', 'Conformer_stat_list_ID'],

            },

      'Conf_stats_software': {

        'tags': {

          'Software_ID': [None,returnStarInt,'Software.ID',True],                                             # Pointer to '_Software.ID'
          'Software_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Software.Sf_framecode',True],# Pointer to a saveframe of the category 'software'
          'Method_ID': [None,returnStarInt,'Method.ID',False],                                                # Pointer to '_Method.ID'
          'Method_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Method.Sf_framecode',False],# Pointer to a saveframe of the category 'method'
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Conformer_stat_list_ID': [None,returnStarInt,'Conformer_stat_list.ID',True],                       # Pointer to '_Conformer_stat_list.ID'

                },

        'tagNames': ['Software_ID', 'Software_label', 'Method_ID', 'Method_label', 'Entry_ID', 'Conformer_stat_list_ID'],
        'sourcePrimaryKeys': ['Software_ID', 'Entry_ID', 'Conformer_stat_list_ID'],

            }

        },

    'tableNames': ['Conformer_stat_list_ens', 'Conformer_stat_list_rep', 'Conf_stats_software']

    },

  'conformer_family_coord_set': {

    'name': 'Conformer_family_coord_set',
    'saveFrameCode': 'ensemble_of_conformers',

    'tags': {

      'Sf_category': ['conformer_family_coord_set',lambda x = value: returnStarCode(x,length = 127),None,True],# Category definition for the information content of the saveframe
      'Sf_framecode': [None,lambda x = value: returnStarCode(x,length = 127),None,False],                     # A label for the saveframe that describes in very brief terms the information contained in the saveframe.
      'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                     # Pointer to '_Entry.ID'
      'ID': [None,returnStarInt,None,True],                                                                   # An integer value that uniquely identifies this saveframe of conformer family atomic coordinate set from other saveframes of this category in an entry.
      'File_name': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                        # Name of the file containing the atomic coordinates.
      'Constraints_PDB_file_ID': [None,lambda x = value: returnStarCode(x,length = 12),None,False],           # Name of the file containing the constraints used to calculate the conformers. Obsolete tag.
      'PDB_accession_code': [None,lambda x = value: returnStarCode(x,length = 15),None,True],                 # Accession code for the PDB entry from which the conformer family atomic coordinate set was extracted.
      'Sample_condition_list_ID': [None,returnStarInt,'Sample_condition_list.ID',True],                       # Pointer to '_Sample_condition_list.ID'
      'Sample_condition_list_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Sample_condition_list.Sf_framecode',True],# Enter the label assigned to a set of sample conditions in the section above. A pull down list of possible sample conditions labels should be available for selection.
      'Atom_site_uncertainty_desc': [None,returnStarString,None,False],                                       # A brief description of the method used to derive the reported uncertainties in the atomic coordinates.
      'Atom_site_ordered_flag_desc': [None,returnStarString,None,False],                                      # A brief description of the method used to derive the reported ordered flag for the atomic coordinates.
      'Details': [None,returnStarString,None,False],                                                          # Additional information describing interesting features of the conformer ensemble and its derivation can be entered in this field.

            },

    'tagNames': ['Sf_category', 'Sf_framecode', 'Entry_ID', 'ID', 'File_name', 'Constraints_PDB_file_ID', 'PDB_accession_code', 'Sample_condition_list_ID', 'Sample_condition_list_label', 'Atom_site_uncertainty_desc', 'Atom_site_ordered_flag_desc', 'Details'],
    'sourcePrimaryKeys': ['Entry_ID', 'ID'],

    'tables': {

      'Conformer_family_refinement': {

        'tags': {

          'Refine_method': [None,returnStarString,None,True],                                                 # The method used to determine the structure.
          'Refine_details': [None,returnStarString,None,False],                                               # Additional comments about the NMR refinement methods can be placed here.
          'Software_ID': [None,returnStarInt,'Software.ID',False],                                            # Pointer to '_Software.ID'
          'Software_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Software.Sf_framecode',False],# Pointer to a saveframe of the category 'software'
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Conformer_family_coord_set_ID': [None,returnStarInt,'Conformer_family_coord_set.ID',True],         # Pointer to '_Conformer_family_coord_set.ID'

                },

        'tagNames': ['Refine_method', 'Refine_details', 'Software_ID', 'Software_label', 'Entry_ID', 'Conformer_family_coord_set_ID'],
        'sourcePrimaryKeys': ['Refine_method', 'Entry_ID', 'Conformer_family_coord_set_ID'],

            },

      'Conformer_family_software': {

        'tags': {

          'Software_ID': [None,returnStarInt,'Software.ID',True],                                             # Pointer to '_Software.ID'
          'Software_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Software.Sf_framecode',True],# Pointer to a saveframe of the category 'software'
          'Method_ID': [None,returnStarInt,'Method.ID',False],                                                # Pointer to '_Method.ID'
          'Method_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Method.Sf_framecode',False],# Pointer to a saveframe of the category 'method'
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Conformer_family_coord_set_ID': [None,returnStarInt,'Conformer_family_coord_set.ID',True],         # Pointer to '_Conformer_family_coord_set.ID'

                },

        'tagNames': ['Software_ID', 'Software_label', 'Method_ID', 'Method_label', 'Entry_ID', 'Conformer_family_coord_set_ID'],
        'sourcePrimaryKeys': ['Software_ID', 'Entry_ID', 'Conformer_family_coord_set_ID'],

            },

      'Energetic_penalty_function': {

        'tags': {

          'Function': [None,lambda x = value: returnStarLine(x,length = 127),None,True],                      # Energy penalty function applied in calculating a family of conformers.
          'Description': [None,lambda x = value: returnStarString(x,length = 255),None,False],                # Text providing additional infromation about the energy penalty function.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Conformer_family_coord_set_ID': [None,returnStarInt,'Conformer_family_coord_set.ID',True],         # Pointer to '_Conformer_family_coord_set.ID'

                },

        'tagNames': ['Function', 'Description', 'Entry_ID', 'Conformer_family_coord_set_ID'],
        'sourcePrimaryKeys': ['Function', 'Entry_ID', 'Conformer_family_coord_set_ID'],

            },

      'Conformer_family_coord_set_expt': {

        'tags': {

          'Experiment_ID': [None,returnStarInt,'Experiment.ID',True],                                         # Pointer to '_Experiment.ID'
          'Experiment_name': [None,lambda x = value: returnStarLine(x,length = 127),'Experiment.Name',False], # Pointer to a saveframe of the category 'NMR_spectrometer_expt'
          'Sample_ID': [None,returnStarInt,'Sample.ID',True],                                                 # Pointer to '_Sample.ID'
          'Sample_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Sample.Sf_framecode',True],# Pointer to a saveframe of the category 'sample'
          'Sample_state': [None,lambda x = value: returnStarLine(x,length = 31),None,True],                   # Physical state of the sample either anisotropic or isotropic.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Conformer_family_coord_set_ID': [None,returnStarInt,'Conformer_family_coord_set.ID',True],         # Pointer to '_Conformer_family_coord_set.ID'

                },

        'tagNames': ['Experiment_ID', 'Experiment_name', 'Sample_ID', 'Sample_label', 'Sample_state', 'Entry_ID', 'Conformer_family_coord_set_ID'],
        'sourcePrimaryKeys': ['Experiment_ID', 'Sample_ID', 'Sample_state', 'Entry_ID', 'Conformer_family_coord_set_ID'],

            },

      'Conf_family_coord_set_constr_list': {

        'tags': {

          'Constraint_list_category': [None,lambda x = value: returnStarLine(x,length = 127),None,True],      # Saveframe category for the type of constraints used to calculate the structure.
          'Constraint_list_ID': [None,returnStarInt,None,True],                                               # Pointer to the ID for the saveframe of the category defined by the tag '_Conf_family_coord_set_constr_list.Constraint_list_category'.
          'Constraint_list_label': [None,lambda x = value: returnStarLabel(x,length = 127),None,True],        # Pointer to a saveframe that contains structural constraint values.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Conformer_family_coord_set_ID': [None,returnStarInt,'Conformer_family_coord_set.ID',True],         # Pointer to '_Conformer_family_coord_set.ID'

                },

        'tagNames': ['Constraint_list_category', 'Constraint_list_ID', 'Constraint_list_label', 'Entry_ID', 'Conformer_family_coord_set_ID'],
        'sourcePrimaryKeys': ['Constraint_list_category', 'Constraint_list_ID', 'Entry_ID', 'Conformer_family_coord_set_ID'],

            },

      'Struct_image': {

        'tags': {

          'File_name': [None,lambda x = value: returnStarLine(x,length = 127),None,True],                     # Name of the file containing the image of the structure.
          'File_format': [None,lambda x = value: returnStarLine(x,length = 31),None,True],                    # File format for the file containing the image of the structure.
          'Details': [None,returnStarString,None,False],                                                      # Text providing additional information about the image of the structure.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Conformer_family_coord_set_ID': [None,returnStarInt,'Conformer_family_coord_set.ID',True],         # Pointer to '_Conformer_family_coord_set.ID'

                },

        'tagNames': ['File_name', 'File_format', 'Details', 'Entry_ID', 'Conformer_family_coord_set_ID'],
        'sourcePrimaryKeys': ['File_name', 'Entry_ID', 'Conformer_family_coord_set_ID'],

            },

      'Local_structure_quality': {

        'tags': {

          'ID': [None,returnStarInt,None,True],                                                               # A numeric identifier for the segment of a molecule for which a quality value is reported.
          'Type': [None,lambda x = value: returnStarLine(x,length = 255),None,True],                          # A descriptive phrase that indicates the quality of the structural conformations reported for the defined segment of the biopolymer.
          'Entity_assembly_ID': [None,returnStarInt,'Entity_assembly.ID',True],                               # Pointer to '_Entity_assembly.ID'
          'Asym_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Struct_asym.ID',False],           # Pointer to '_Struct_asym.ID'
          'Entity_ID': [None,returnStarInt,'Entity.ID',False],                                                # Pointer to '_Entity.ID'
          'Entity_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Entity.Sf_framecode',False],# The name assigned to the molecular entity where the defined segment is located.
          'Comp_index_ID_begin': [None,returnStarInt,'Entity_comp_index.ID',True],                            # Pointer to '_Entity_comp_index.ID' The starting sequence position in the molecular entity for the segment being described.
          'Comp_index_ID_end': [None,returnStarInt,'Entity_comp_index.ID',True],                              # Pointer to '_Entity_comp_index.ID' The ending sequence position in the molecular entity for the segment being described.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Conformer_family_coord_set_ID': [None,returnStarInt,'Conformer_family_coord_set.ID',True],         # Pointer to '_Conformer_family_coord_set.ID'

                },

        'tagNames': ['ID', 'Type', 'Entity_assembly_ID', 'Asym_ID', 'Entity_ID', 'Entity_label', 'Comp_index_ID_begin', 'Comp_index_ID_end', 'Entry_ID', 'Conformer_family_coord_set_ID'],
        'sourcePrimaryKeys': ['ID', 'Entry_ID', 'Conformer_family_coord_set_ID'],

            },

      'Model_type': {

        'tags': {

          'Atom_site_model_ID': [None,returnStarInt,'Atom_site.Model_ID',True],                               # Pointer to '_Atom_site.Model_ID'  The identifier for the model in the set of reported structural models. This data item is a pointer to the '_Atom.site_Model_ID' in the Atom_site category.
          'Type': [None,lambda x = value: returnStarLine(x,length = 255),None,True],                          # A brief phrase that describes an atomic coordinate model that is a member of the set of models reported in the Atom_site category.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Conformer_family_coord_set_ID': [None,returnStarInt,'Conformer_family_coord_set.ID',True],         # Pointer to '_Conformer_family_coord_set.ID'

                },

        'tagNames': ['Atom_site_model_ID', 'Type', 'Entry_ID', 'Conformer_family_coord_set_ID'],
        'sourcePrimaryKeys': ['Atom_site_model_ID', 'Type'],

            },

      'Atom_site': {

        'tags': {

          'Assembly_ID': [None,returnStarInt,None,False],                                                     # ?
          'Model_ID': [None,returnStarInt,None,True],                                                         # An integer value that uniquely defines the set of coordinates that represent one model for the molecular assembly.
          'Model_site_ID': [None,returnStarInt,None,False],                                                   # The Model_site_ID item is an integer value that for each model in the table has an initial value of 1 and increments in consecutive integer values for each set of atomic coordinates reported in the model.
          'ID': [None,returnStarInt,None,True],                                                               # The value of '_Atom_site.ID' must uniquely identify a record in the atom_site list.
          'Assembly_atom_ID': [None,returnStarInt,'Atom.Assembly_atom_ID',False],                             # Pointer to '_Atom.Assembly_atom_ID'
          'Label_entity_assembly_ID': [None,returnStarInt,'Entity_assembly.ID',True],                         # Pointer to '_Entity_assembly.ID'
          'Label_entity_ID': [None,returnStarInt,'Entity.ID',True],                                           # Pointer to '_Entity.ID'
          'Label_comp_index_ID': [None,returnStarInt,'Entity_comp_index.ID',True],                            # Pointer to '_Entity_comp_index.ID'
          'Label_comp_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Chem_comp.ID',True],        # Pointer to '_Chem_comp.ID'
          'Label_atom_ID': [None,lambda x = value: returnStarAtCode(x,length = 12),'Chem_comp_atom.Atom_ID',True],# Pointer to '_Chem_comp_atom.Atom_ID'
          'Type_symbol': [None,lambda x = value: returnStarCode(x,length = 15),None,True],                    # The value for this tag is a standard IUPAC abbreviation for an element (i.e.$ H$ C$ P$ etc).
          'Cartn_x': [None,returnStarFloat,None,True],                                                        # The x atom-site coordinate in angstroms specified according to a set of orthogonal Cartesian axes.
          'Cartn_y': [None,returnStarFloat,None,True],                                                        # The y atom-site coordinate in angstroms specified according to a set of orthogonal Cartesian axes.
          'Cartn_z': [None,returnStarFloat,None,True],                                                        # The z atom-site coordinate in angstroms specified according to a set of orthogonal Cartesian axes.
          'Cartn_x_esd': [None,returnStarFloat,None,False],                                                   # The standard uncertainty (estimated standard deviation) of '_Atom_site.Cartn_x'.
          'Cartn_y_esd': [None,returnStarFloat,None,False],                                                   # The standard uncertainty (estimated standard deviation) of '_Atom_site.Cartn_y'.
          'Cartn_z_esd': [None,returnStarFloat,None,False],                                                   # The standard uncertainty (estimated standard deviation) of '_Atom_site.Cartn_z'.
          'Occupancy': [None,returnStarFloat,None,False],                                                     # The percent occupancy of the atom at the atom site defined by the listed coordinates.
          'Occupancy_esd': [None,returnStarFloat,None,False],                                                 # The standard uncertainty (estimated standard deviation) of '_Atom_site.Occupancy'.
          'Uncertainty': [None,returnStarFloat,None,False],                                                   # A value indicating the confidence in the assigned coordinate values for this atom.
          'Ordered_flag': [None,returnStarInt,None,False],                                                    # A value indicating whether the atom at this site is considered in an ordered conformation (1) or is in a disordered conformation (0) in the structure.
          'Footnote_ID': [None,returnStarInt,None,False],                                                     # The value of '_Atom_site.Footnote_ID must match an ID specified by '_Atom_sites_footnote.ID'.
          'PDBX_label_asym_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Struct_asym.ID',False],# Pointer to '_Struct_asym.ID'
          'PDBX_label_seq_ID': [None,returnStarInt,None,False],                                               # Residue sequence number assigned by the PDB and extracted from the PDB entry.
          'PDBX_label_comp_ID': [None,lambda x = value: returnStarCode(x,length = 15),'Chem_comp.ID',True],   # Chemical component identifier assigned by the PDB and extracted from the PDB entry.
          'PDBX_label_atom_ID': [None,lambda x = value: returnStarAtCode(x,length = 12),None,False],          # Atom identifier assigned by the PDB and extracted from the PDB entry.
          'PDBX_formal_charge': [None,returnStarInt,None,False],                                              # The net integer charge assigned to this atom. This is the formal charge assignment normally found in chemical diagrams.
          'PDBX_label_entity_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],          # This data item is provided as a place holder for the label_entity_id value extracted from a pdbx file.
          'PDB_record_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                 # The value is an integer that identifies a record in the atom_site list. This is a place holder for the atom record number extracted from a PDB formatted file.
          'PDB_model_num': [None,returnStarInt,None,False],                                                   # PDB model number.
          'PDB_strand_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                 # PDB strand id.
          'PDB_ins_code': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                  # PDB insertion code.
          'PDB_residue_no': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                # PDB residue number.
          'PDB_residue_name': [None,lambda x = value: returnStarCode(x,length = 15),None,False],              # PDB residue name.
          'PDB_atom_name': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                 # PDB atom name.
          'Auth_entity_assembly_ID': [None,returnStarInt,None,False],                                         # Author assigned entity assembly ID.
          'Auth_asym_ID': [None,lambda x = value: returnStarCode(x,length = 12),None,False],                  # Author assigned asymmetric ID.
          'Auth_chain_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                 # Author assigned chain ID
          'Auth_seq_ID': [None,lambda x = value: returnStarCode(x,length = 12),None,False],                   # An alternative identifier for Seq_id that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Seq_ID or Comp_index_ID.
          'Auth_comp_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                  # An alternative identifier for Comp_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Auth_atom_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                  # An alternative identifier for Atom_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Auth_alt_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                   # Author's alternate location identifier.
          'Auth_atom_name': [None,lambda x = value: returnStarAtCode(x,length = 12),None,False],              # Author's atom name.
          'Details': [None,returnStarString,None,False],                                                      # Text providing additional information about the atom site.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Conformer_family_coord_set_ID': [None,returnStarInt,'Conformer_family_coord_set.ID',True],         # Pointer to '_Conformer_family_coord_set.ID'

                },

        'tagNames': ['Assembly_ID', 'Model_ID', 'Model_site_ID', 'ID', 'Assembly_atom_ID', 'Label_entity_assembly_ID', 'Label_entity_ID', 'Label_comp_index_ID', 'Label_comp_ID', 'Label_atom_ID', 'Type_symbol', 'Cartn_x', 'Cartn_y', 'Cartn_z', 'Cartn_x_esd', 'Cartn_y_esd', 'Cartn_z_esd', 'Occupancy', 'Occupancy_esd', 'Uncertainty', 'Ordered_flag', 'Footnote_ID', 'PDBX_label_asym_ID', 'PDBX_label_seq_ID', 'PDBX_label_comp_ID', 'PDBX_label_atom_ID', 'PDBX_formal_charge', 'PDBX_label_entity_ID', 'PDB_record_ID', 'PDB_model_num', 'PDB_strand_ID', 'PDB_ins_code', 'PDB_residue_no', 'PDB_residue_name', 'PDB_atom_name', 'Auth_entity_assembly_ID', 'Auth_asym_ID', 'Auth_chain_ID', 'Auth_seq_ID', 'Auth_comp_ID', 'Auth_atom_ID', 'Auth_alt_ID', 'Auth_atom_name', 'Details', 'Entry_ID', 'Conformer_family_coord_set_ID'],
        'sourcePrimaryKeys': ['ID', 'Entry_ID', 'Conformer_family_coord_set_ID'],

            },

      'Atom_sites_footnote': {

        'tags': {

          'Footnote_ID': [None,returnStarInt,None,True],                                                      # Unique identifier for the reported footnote.
          'Text': [None,returnStarString,None,True],                                                          # The text of the footnote. Footnotes are used to describe an atom site or a group of atom sites in the atom_site list.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Conformer_family_coord_set_ID': [None,returnStarInt,'Conformer_family_coord_set.ID',True],         # Pointer to '_Conformer_family_coord_set.ID'

                },

        'tagNames': ['Footnote_ID', 'Text', 'Entry_ID', 'Conformer_family_coord_set_ID'],
        'sourcePrimaryKeys': ['Footnote_ID', 'Entry_ID', 'Conformer_family_coord_set_ID'],

            }

        },

    'tableNames': ['Conformer_family_refinement', 'Conformer_family_software', 'Energetic_penalty_function', 'Conformer_family_coord_set_expt', 'Conf_family_coord_set_constr_list', 'Struct_image', 'Local_structure_quality', 'Model_type', 'Atom_site', 'Atom_sites_footnote']

    },

  'representative_conformer': {

    'name': 'Representative_conformer',
    'saveFrameCode': 'representative_conformer',

    'tags': {

      'Sf_category': ['representative_conformer',lambda x = value: returnStarCode(x,length = 127),None,True], # Category definition for the information content of the saveframe
      'Sf_framecode': [None,lambda x = value: returnStarCode(x,length = 127),None,False],                     # A label for the saveframe that describes in very brief terms the information contained in the saveframe.
      'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                     # Pointer to '_Entry.ID'
      'ID': [None,returnStarInt,None,True],                                                                   # Unique identifier for the reported representative conformer.
      'Details': [None,returnStarString,None,False],                                                          # Text providing additional information regarding the reported representative conformer.
      'Type': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                             # The type of representative conformer defined by the listed coordinates.
      'Rep_conformer_derivation': [None,lambda x = value: returnStarLine(x,length = 127),None,False],         # Method used to derive the representative conformer from a family of conformers.
      'Atom_pos_uncertainty_derivation': [None,returnStarString,None,False],                                  # Provide a brief but complete description of the method used to calculate the reported uncertainty in the individual atom coordinates.
      'Rep_conformer_file_name': [None,lambda x = value: returnStarLine(x,length = 127),None,False],          # Name of the file containing the atomic coordinates for the representative conformer.
      'Rep_conformer_original_file': [None,lambda x = value: returnStarLine(x,length = 127),None,False],      # Name of the original file that contained the atomic coordinates for the representative conformer.
      'PDB_accession_code': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                # Accession code for the PDB entry from which the representative conformer coordinates were extracted.
      'Conformer_family_coord_set_ID': [None,returnStarInt,'Conformer_family_coord_set.ID',True],             # Pointer to '_Conformer_family_coord_set.ID'
      'Conformer_family_coord_set_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Conformer_family_coord_set.Sf_framecode',True],# Pointer to a saveframe of the type conformer_family_coord_set.

            },

    'tagNames': ['Sf_category', 'Sf_framecode', 'Entry_ID', 'ID', 'Details', 'Type', 'Rep_conformer_derivation', 'Atom_pos_uncertainty_derivation', 'Rep_conformer_file_name', 'Rep_conformer_original_file', 'PDB_accession_code', 'Conformer_family_coord_set_ID', 'Conformer_family_coord_set_label'],
    'sourcePrimaryKeys': ['Entry_ID', 'ID'],

    'tables': {

      'Rep_conf_refinement': {

        'tags': {

          'Refine_method': [None,returnStarString,None,True],                                                 # The method used to determine the structure.
          'Refine_details': [None,returnStarString,None,False],                                               # Additional comments about the NMR refinement methods can be placed here.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Representative_conformer_ID': [None,returnStarInt,'Representative_conformer.ID',True],             # Pointer to '_Representative_conformer.ID'

                },

        'tagNames': ['Refine_method', 'Refine_details', 'Entry_ID', 'Representative_conformer_ID'],
        'sourcePrimaryKeys': ['Refine_method', 'Entry_ID', 'Representative_conformer_ID'],

            },

      'Rep_conf_software': {

        'tags': {

          'Software_ID': [None,returnStarInt,'Software.ID',True],                                             # Pointer to '_Software.ID'
          'Software_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Software.Sf_framecode',True],# Pointer to a saveframe of the category 'software'
          'Method_ID': [None,returnStarInt,'Method.ID',False],                                                # Pointer to '_Method.ID'
          'Method_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Method.Sf_framecode',False],# Pointer to a saveframe of the category 'method'
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Representative_conformer_ID': [None,returnStarInt,'Conformer_family_coord_set.ID',True],           # Pointer to '_Conformer_family_coord_set.ID'

                },

        'tagNames': ['Software_ID', 'Software_label', 'Method_ID', 'Method_label', 'Entry_ID', 'Representative_conformer_ID'],
        'sourcePrimaryKeys': ['Software_ID', 'Entry_ID', 'Representative_conformer_ID'],

            },

      'Terminal_residue': {

        'tags': {

          'Entity_ID': [None,returnStarInt,'Entity.ID',True],                                                 # Pointer to '_Entity.ID'
          'Comp_index_ID': [None,returnStarInt,'Entity_comp_index.ID',True],                                  # Pointer to '_Entity_comp_index.ID'
          'Seq_ID': [None,returnStarInt,'Entity_poly_seq.Num',True],                                          # Pointer to '_Entity_poly_seq.Num'
          'Comp_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Chem_comp.ID',True],              # Pointer to '_Chem_comp.ID'
          'Auth_seq_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                   # An alternative identifier for Seq_id that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Seq_ID or Comp_index_ID.
          'Auth_comp_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                  # An alternative identifier for Comp_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Representative_conformer_ID': [None,returnStarInt,'Representative_conformer.ID',True],             # Pointer to '_Representative_conformer.ID'

                },

        'tagNames': ['Entity_ID', 'Comp_index_ID', 'Seq_ID', 'Comp_ID', 'Auth_seq_ID', 'Auth_comp_ID', 'Entry_ID', 'Representative_conformer_ID'],
        'sourcePrimaryKeys': ['Entity_ID', 'Comp_index_ID', 'Entry_ID', 'Representative_conformer_ID'],

            },

      'Rep_conf': {

        'tags': {

          'Atom_coordinate_ID': [None,returnStarInt,None,True],                                               # An intervalue that uniquely identifies the listed set of x$ y$ z atomic coordinates.
          'Assembly_atom_ID': [None,returnStarInt,'Atom.Assembly_atom_ID',False],                             # Pointer to '_Atom.Assembly_atom_ID'
          'Atom_site_ID': [None,returnStarInt,'Atom_site.ID',True],                                           # Pointer to '_Atom_site.ID'
          'Entity_assembly_ID': [None,returnStarInt,'Entity_assembly.ID',True],                               # Pointer to '_Entity_assembly.ID'
          'Entity_ID': [None,returnStarInt,'Entity.ID',True],                                                 # Pointer to '_Entity.ID'
          'Comp_index_ID': [None,returnStarInt,'Entity_comp_index.ID',True],                                  # Pointer to '_Entity_comp_index.ID'
          'Comp_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Chem_comp.ID',True],              # Pointer to '_Chem_comp.ID'
          'Chem_comp_PDB_ID_code': [None,lambda x = value: returnStarCode(x,length = 15),None,True],          # Code assigned by the PDB to the chemical component.
          'Seq_ID': [None,returnStarInt,'Entity_poly_seq.Num',True],                                          # Pointer to '_Entity_poly_seq.Num'
          'Atom_ID': [None,lambda x = value: returnStarAtCode(x,length = 12),'Chem_comp_atom.Atom_ID',True],  # Pointer to '_Chem_comp_atom.Atom_ID'
          'Atom_type': [None,lambda x = value: returnStarCode(x,length = 15),None,True],                      # The value for this tag is a standard IUPAC abbreviation for an element (i.e.$ H$ C$ P$ etc).
          'Atom_cartn_x': [None,returnStarFloat,None,True],                                                   # The x atom-site coordinate in angstroms specified according to a set of orthogonal Cartesian axes.
          'Atom_cartn_y': [None,returnStarFloat,None,True],                                                   # The y atom-site coordinate in angstroms specified according to a set of orthogonal Cartesian axes.
          'Atom_cartn_z': [None,returnStarFloat,None,True],                                                   # The z atom-site coordinate in angstroms specified according to a set of orthogonal Cartesian axes.
          'Atom_cartn_x_esd': [None,returnStarFloat,None,False],                                              # The standard uncertainty (estimated standard deviation) of '_Rep_conf.Atom_cartn_x'.
          'Atom_cartn_y_esd': [None,returnStarFloat,None,False],                                              # The standard uncertainty (estimated standard deviation) of '_Rep_conf.Atom_cartn_y'.
          'Atom_cartn_z_esd': [None,returnStarFloat,None,False],                                              # The standard uncertainty (estimated standard deviation) of '_Rep_conf.Atom_cartn_z'.
          'Atom_position_uncertainty': [None,returnStarFloat,None,False],                                     # A value for the overall uncertainty in the reported atom coordinates.
          'Atom_coord_footnote_ID': [None,returnStarInt,'Rep_coordinate_details.Footnote_ID',False],          # Pointer to '_Rep_coordinate_details.Footnote_ID'
          'Auth_entity_assembly_ID': [None,returnStarInt,None,False],                                         # An alternative identifier for entity_assembly_id that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for entity_assembly_ID.
          'Auth_seq_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                   # An alternative identifier for Seq_id that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Seq_ID or Comp_index_ID.
          'Auth_comp_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                  # An alternative identifier for Comp_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Auth_atom_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                  # An alternative identifier for Atom_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Representative_conformer_ID': [None,returnStarInt,'Representative_conformer.ID',True],             # Pointer to '_Representative_conformer.ID'

                },

        'tagNames': ['Atom_coordinate_ID', 'Assembly_atom_ID', 'Atom_site_ID', 'Entity_assembly_ID', 'Entity_ID', 'Comp_index_ID', 'Comp_ID', 'Chem_comp_PDB_ID_code', 'Seq_ID', 'Atom_ID', 'Atom_type', 'Atom_cartn_x', 'Atom_cartn_y', 'Atom_cartn_z', 'Atom_cartn_x_esd', 'Atom_cartn_y_esd', 'Atom_cartn_z_esd', 'Atom_position_uncertainty', 'Atom_coord_footnote_ID', 'Auth_entity_assembly_ID', 'Auth_seq_ID', 'Auth_comp_ID', 'Auth_atom_ID', 'Entry_ID', 'Representative_conformer_ID'],
        'sourcePrimaryKeys': ['Atom_coordinate_ID', 'Entry_ID', 'Representative_conformer_ID'],

            },

      'Rep_coordinate_details': {

        'tags': {

          'Footnote_ID': [None,returnStarInt,None,True],                                                      # An integer value that uniquely identifies the listed footnote.
          'Footnote': [None,lambda x = value: returnStarString(x,length = 255),None,True],                    # Text providing additional information regarding the coordinates for an atom in the representative structure.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Representative_conformer_ID': [None,returnStarInt,'Representative_conformer.ID',True],             # Pointer to '_Representative_conformer.ID'

                },

        'tagNames': ['Footnote_ID', 'Footnote', 'Entry_ID', 'Representative_conformer_ID'],
        'sourcePrimaryKeys': ['Footnote_ID', 'Entry_ID', 'Representative_conformer_ID'],

            }

        },

    'tableNames': ['Rep_conf_refinement', 'Rep_conf_software', 'Terminal_residue', 'Rep_conf', 'Rep_coordinate_details']

    },

  'constraint_statistics': {

    'name': 'Constraint_stat_list',
    'saveFrameCode': 'constraint_statistics',

    'tags': {

      'Sf_category': ['constraint_statistics',lambda x = value: returnStarCode(x,length = 127),None,True],    # Category definition for the information content of the saveframe
      'Sf_framecode': [None,lambda x = value: returnStarCode(x,length = 127),None,False],                     # A label for the saveframe that describes in very brief terms the information contained in the saveframe.
      'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                     # Pointer to '_Entry.ID'
      'ID': [None,returnStarInt,None,True],                                                                   # Unique identifier for the reported list of contraint statistics.
      'Data_file_name': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                   # The name of the file submitted with this depostion that contains the quantitative data for this saveframe.
      'Details': [None,returnStarString,None,False],                                                          # Text providing additional information regarding the reported constraint statistics.
      'Text_data_format': [None,lambda x = value: returnStarLine(x,length = 31),None,False],                  # The data format used to represent the constraint statistical data as ASCII text in the text block that is the value to the '_Assigned_chem_shift.Text_data' tag.
      'Text_data': [None,returnStarString,None,False],                                                        # A set of constraint statistics data formatted as ASCII text.
      'Stats_not_available': [None,lambda x = value: returnStarYesNo(x,length = 3),None,False],               # Depositors are strongly encouraged to enter a few statistical parameters describing the constraints used to calculate the deposited conformers. If these data are not available$ please check the box provided. After checking the box and clicking on the 'save' button$ the fields for entering constraint statistics will not be marked as mandatory and you will be able to complete your depositions without providing this information.
      'NOE_interproton_dist_evaluation': [None,lambda x = value: returnStarLine(x,length = 127),None,False],  # Method used to evaluate interproton distances from NOE data.
      'NOE_pseudoatom_corrections': [None,lambda x = value: returnStarLine(x,length = 127),None,False],       # A yes/no flag that defines whether pseudoatom corrections have been applied in calculating the NOE restraint statistics.
      'NOE_dist_averaging_method': [None,lambda x = value: returnStarLine(x,length = 127),None,False],        # Mothod used to correct for motional averaging in evaluating interproton distances from NOE data.
      'ROE_interproton_dist_evaluation': [None,lambda x = value: returnStarLine(x,length = 127),None,False],  # Method used to evaluate interproton distances from ROE data.
      'ROE_pseudoatom_corrections': [None,lambda x = value: returnStarLine(x,length = 127),None,False],       # A yes/no flag that defines whether pseudoatom corrections have been applied in calculating the ROE restraint statistics.
      'ROE_dist_averaging_method': [None,returnStarFloat,None,False],                                         # Mothod used to correct for motional averaging in evaluating interproton distances from ROE data.
      'NOE_tot_num': [None,returnStarInt,None,False],                                                         # Provide the total count of all NOE values used to calculate the conformers.
      'RDC_tot_num': [None,returnStarInt,None,False],                                                         # Total number of all RDC constraints
      'Dihedral_angle_tot_num': [None,returnStarInt,None,False],                                              # Please enter the total number of dihedral and torsion angle constraints used to calculate the reported conformers. This would include constraints for all components in the molecular system (proteins$ nucleic acids$ and ligands).
      'Protein_dihedral_angle_tot_num': [None,returnStarInt,None,False],                                      # Enter the total number of dihedral and torsion angle constraints related to the protein components of the molecular system studied.
      'NA_dihedral_angle_tot_num': [None,returnStarInt,None,False],                                           # Enter the total number of dihedral and torsion angle constraints related to the nucleic acid components of the molecular system studied.
      'NOE_intraresidue_tot_num': [None,returnStarInt,None,False],                                            # Enter the total count of NOE values that represent interactions between atoms within a single residue (amino acid$ nucleic acid$ or other residue).
      'NOE_sequential_tot_num': [None,returnStarInt,None,False],                                              # Enter the total count of NOE values that represent interactions between sequential residues in the biopolymer chain (|i-j| = 1).
      'NOE_medium_range_tot_num': [None,returnStarInt,None,False],                                            # Provide the total count of the NOE values that represent interactions between residues defined as 'medium-range' or relatively close in the sequence of the biopolymer chain (|i-j| < 5). For proteins$ these NOEs are often used to define secondary structure.
      'NOE_long_range_tot_num': [None,returnStarInt,None,False],                                              # Enter the total count of 'long-range' NOE values representing interactions between residues distance in the biopolymer sequence (|i-j| > 4) and other NOEs not included in the other counts.
      'NOE_unique_tot_num': [None,returnStarInt,None,False],                                                  # Total number of unique NOE constraints.
      'NOE_intraresidue_unique_tot_num': [None,returnStarInt,None,False],                                     # Total number of unique intraresidue (i-j=0) NOE constraints.
      'NOE_sequential_unique_tot_num': [None,returnStarInt,None,False],                                       # Total number of unique sequential (|i-j|=1) NOE constraints.
      'NOE_medium_range_unique_tot_num': [None,returnStarInt,None,False],                                     # Total number of unique medium range (2<|i-j|<5) NOE constraints.
      'NOE_long_range_unique_tot_num': [None,returnStarInt,None,False],                                       # Total number of unique long range (|i-j|>4) NOE constraints.
      'NOE_unamb_intramol_tot_num': [None,returnStarInt,None,False],                                          # Total number of unambiguous intramolecular NOE constraints.
      'NOE_unamb_intermol_tot_num': [None,returnStarInt,None,False],                                          # Total number of unambiguous intermolecular NOE constraints.
      'NOE_ambig_intramol_tot_num': [None,returnStarInt,None,False],                                          # Total number of ambiguous intramolecular NOE constraints.
      'NOE_ambig_intermol_tot_num': [None,returnStarInt,None,False],                                          # Total number of ambiguous intermolecular NOE constraints.
      'NOE_interentity_tot_num': [None,returnStarInt,None,False],                                             # Enter the total number of NOE constraints that represent interactions between nuclei on different molecular components in the molecular assembly studied.
      'NOE_other_tot_num': [None,returnStarInt,None,False],                                                   # Provide a total count of NOE values that do not fit in any of the catagories for specific types of NOE constraints (not the total NOE count) listed above. These might be NOE values from interactions between nuclei within a ligand.
      'ROE_tot_num': [None,returnStarInt,None,False],                                                         # Provide the total count of all NOE values used to calculate the conformers.
      'ROE_intraresidue_tot_num': [None,returnStarInt,None,False],                                            # Enter the total count of NOE values that represent interactions between atoms within a single residue (amino acid$ nucleic acid$ or other residue).
      'ROE_sequential_tot_num': [None,returnStarInt,None,False],                                              # Enter the total count of NOE values that represent interactions between sequential residues in the biopolymer chain (|i-j| = 1).
      'ROE_medium_range_tot_num': [None,returnStarInt,None,False],                                            # Provide the total count of the NOE values that represent interactions between residues defined as 'medium-range' or relatively close in the sequence of the biopolymer chain (|i-j| < 5). For proteins$ these NOEs are often used to define secondary structure.
      'ROE_long_range_tot_num': [None,returnStarInt,None,False],                                              # Enter the total count of 'long-range' NOE values representing interactions between residues distance in the biopolymer sequence (|i-j| > 4) and other NOEs not included in the other counts.
      'ROE_unambig_intramol_tot_num': [None,returnStarInt,None,False],                                        # Total number of unambiguous intramolecular ROE constraints.
      'ROE_unambig_intermol_tot_num': [None,returnStarInt,None,False],                                        # Total number of unambiguous intermolecular ROE constraints.
      'ROE_ambig_intramol_tot_num': [None,returnStarInt,None,False],                                          # Total number of ambiguous intramolecular ROE constraints.
      'ROE_ambig_intermol_tot_num': [None,returnStarInt,None,False],                                          # Total number of ambiguous intermolecular ROE constraints.
      'ROE_other_tot_num': [None,returnStarInt,None,False],                                                   # Total number of other kinds of ROE constraints.
      'RDC_HH_tot_num': [None,returnStarInt,None,False],                                                      # Total number of H to H RDC constraints
      'RDC_HNC_tot_num': [None,returnStarInt,None,False],                                                     # Two bond interresidue coupling between amide proton and carbonyl carbon of previous residue
      'RDC_NH_tot_num': [None,returnStarInt,None,False],                                                      # One bond coupling between amide nitrogen and amide proton
      'RDC_CC_tot_num': [None,returnStarInt,None,False],                                                      # Total number of C to C RDC constraints
      'RDC_CN_i_1_tot_num': [None,returnStarInt,None,False],                                                  # One bond interesidue coupling between amide nitrogen and carbonyl carbon of previous residue
      'RDC_CAHA_tot_num': [None,returnStarInt,None,False],                                                    # One bond coupling between alpha carbon and alpha proton
      'RDC_HNHA_tot_num': [None,returnStarInt,None,False],                                                    # Three bond intraresidue coupling between amide proton and alpha proton
      'RDC_HNHA_i_1_tot_num': [None,returnStarInt,None,False],                                                # Four bond interresidue coupling between amide proton and alpha proton of previous residue
      'RDC_CAC_tot_num': [None,returnStarInt,None,False],                                                     # One bond coupling between alpha carbon and carbonyl carbon
      'RDC_CAN_tot_num': [None,returnStarInt,None,False],                                                     # One bond coupling between alpha carbon and amide nitrogen
      'RDC_intraresidue_tot_num': [None,returnStarInt,None,False],                                            # Total number of intraresidue (i-j=0) residual dipolar coupling constraints.
      'RDC_sequential_tot_num': [None,returnStarInt,None,False],                                              # Total number of sequential (|i-j|=1) residual dipolar coupling constraints.
      'RDC_medium_range_tot_num': [None,returnStarInt,None,False],                                            # Total number of medium range (|i-j|<5) residual dipolar coupling constraints.
      'RDC_long_range_tot_num': [None,returnStarInt,None,False],                                              # Total number of long range (|i-j|>4) and other residual dipolar coupling constraints.
      'RDC_other_tot_num': [None,returnStarInt,None,False],                                                   # Total number of other residual dipolar coupling constraints.
      'RDC_unambig_intramol_tot_num': [None,returnStarInt,None,False],                                        # Total number of unambiguous intramolecular residual dipolar coupling constraints.
      'RDC_unambig_intermol_tot_num': [None,returnStarInt,None,False],                                        # Total number of unambiguous intermolecular residual dipolar coupling constraints.
      'RDC_ambig_intramol_tot_num': [None,returnStarInt,None,False],                                          # Total number of ambiguous intramolecular residual dipolar coupling constraints.
      'RDC_ambig_intermol_tot_num': [None,returnStarInt,None,False],                                          # Total number of ambiguous intermolecular residual dipolar coupling constraints.
      'RDC_intermol_tot_num': [None,returnStarInt,None,False],                                                # Total number of intermolecular RDC constraints
      'Protein_phi_angle_tot_num': [None,returnStarInt,None,False],                                           # Total number of protein phi angle constraints
      'Protein_psi_angle_tot_num': [None,returnStarInt,None,False],                                           # Total number of protein psi angle constraints
      'Protein_chi_one_angle_tot_num': [None,returnStarInt,None,False],                                       # Total number of protein chi1 angle constraints
      'Protein_other_angle_tot_num': [None,returnStarInt,None,False],                                         # Total number of protein constraints for other torsion or dihedral angles
      'Protein_ambig_dihedral_tot_num': [None,returnStarInt,None,False],                                      # Total number of ambiguous dihedral angle constraints
      'Protein_other_tot_num': [None,returnStarInt,None,False],                                               # Total number of other protein constraints
      'NA_alpha_angle_tot_num': [None,returnStarInt,None,False],                                              # Total number of nucleic acid alpha angle contstraints
      'NA_beta_angle_tot_num': [None,returnStarInt,None,False],                                               # Total number of nucleic acid beta angle constraints
      'NA_gamma_angle_tot_num': [None,returnStarInt,None,False],                                              # Total number of nucleic acid gamma angle constraints
      'NA_delta_angle_tot_num': [None,returnStarInt,None,False],                                              # Total number of nucleic acid delta angle constraints
      'NA_epsilon_angle_tot_num': [None,returnStarInt,None,False],                                            # Total number of nucleic acid epsilon angle constraints
      'NA_chi_angle_tot_num': [None,returnStarInt,None,False],                                                # Total number of nucleic acid chi angle constraints
      'NA_sugar_pucker_tot_num': [None,returnStarInt,None,False],                                             # Total number of nucleic acid sugar pucker constraints
      'NA_other_angle_tot_num': [None,returnStarInt,None,False],                                              # Total number of constraints for other nucleic acid angles
      'NA_amb_dihedral_angle_tot_num': [None,returnStarInt,None,False],                                       # Total number of ambiguous nucleic acid dihedral angle constraints
      'NA_other_tot_num': [None,returnStarInt,None,False],                                                    # Total number of other kinds of nucleic acid constraints
      'H_bonds_constrained_tot_num': [None,returnStarInt,None,False],                                         # Number of H-bonds constrained by experimental data
      'Constr_def_H_bonds_tot_num': [None,returnStarInt,None,False],                                          # Total number constraint values defining H-bonds
      'SS_bonds_constrained_tot_num': [None,returnStarInt,None,False],                                        # Number of disulfide bonds constrained by experimental values
      'Constr_def_SS_bonds_tot_num': [None,returnStarInt,None,False],                                         # Total number of constraint values defining disulfide bonds
      'Derived_coupling_const_tot_num': [None,returnStarInt,None,False],                                      # Total number of constraints derived from coupling constant data.
      'Derived_CACB_chem_shift_tot_num': [None,returnStarInt,None,False],                                     # Total number of constraints derived from CA and CB chemical shift data.
      'Derived_1H_chem_shifts_tot_num': [None,returnStarInt,None,False],                                      # Total number of constraints derived from 1H chemical shift data.
      'Derived_photo_cidnps_tot_num': [None,returnStarInt,None,False],                                        # Total number of constraints derived from photo cidnp data.
      'Derived_paramag_relax_tot_num': [None,returnStarInt,None,False],                                       # Total number of constraints derived from paramagnetic relaxation data.
      'Assumed_distances_tot_num': [None,returnStarInt,None,False],                                           # Total number of distance constraints assumed to be present. These may have been taken from an X-ray structure.
      'Assumed_angles_tot_num': [None,returnStarInt,None,False],                                              # Total number of angle constraints assumed to be present.
      'Constraints_per_residue_avg': [None,returnStarFloat,None,False],                                       # Average number of constraints per residue in the biopolymer.
      'Constr_violations_per_residue_avg': [None,returnStarFloat,None,False],                                 # Average number of constraint violations per residue in the biopolymer.
      'Dist_constr_violat_stat_calc_method': [None,lambda x = value: returnStarLine(x,length = 127),None,False],# Method used to calculate the distance constraint violations.

            },

    'tagNames': ['Sf_category', 'Sf_framecode', 'Entry_ID', 'ID', 'Data_file_name', 'Details', 'Text_data_format', 'Text_data', 'Stats_not_available', 'NOE_interproton_dist_evaluation', 'NOE_pseudoatom_corrections', 'NOE_dist_averaging_method', 'ROE_interproton_dist_evaluation', 'ROE_pseudoatom_corrections', 'ROE_dist_averaging_method', 'NOE_tot_num', 'RDC_tot_num', 'Dihedral_angle_tot_num', 'Protein_dihedral_angle_tot_num', 'NA_dihedral_angle_tot_num', 'NOE_intraresidue_tot_num', 'NOE_sequential_tot_num', 'NOE_medium_range_tot_num', 'NOE_long_range_tot_num', 'NOE_unique_tot_num', 'NOE_intraresidue_unique_tot_num', 'NOE_sequential_unique_tot_num', 'NOE_medium_range_unique_tot_num', 'NOE_long_range_unique_tot_num', 'NOE_unamb_intramol_tot_num', 'NOE_unamb_intermol_tot_num', 'NOE_ambig_intramol_tot_num', 'NOE_ambig_intermol_tot_num', 'NOE_interentity_tot_num', 'NOE_other_tot_num', 'ROE_tot_num', 'ROE_intraresidue_tot_num', 'ROE_sequential_tot_num', 'ROE_medium_range_tot_num', 'ROE_long_range_tot_num', 'ROE_unambig_intramol_tot_num', 'ROE_unambig_intermol_tot_num', 'ROE_ambig_intramol_tot_num', 'ROE_ambig_intermol_tot_num', 'ROE_other_tot_num', 'RDC_HH_tot_num', 'RDC_HNC_tot_num', 'RDC_NH_tot_num', 'RDC_CC_tot_num', 'RDC_CN_i_1_tot_num', 'RDC_CAHA_tot_num', 'RDC_HNHA_tot_num', 'RDC_HNHA_i_1_tot_num', 'RDC_CAC_tot_num', 'RDC_CAN_tot_num', 'RDC_intraresidue_tot_num', 'RDC_sequential_tot_num', 'RDC_medium_range_tot_num', 'RDC_long_range_tot_num', 'RDC_other_tot_num', 'RDC_unambig_intramol_tot_num', 'RDC_unambig_intermol_tot_num', 'RDC_ambig_intramol_tot_num', 'RDC_ambig_intermol_tot_num', 'RDC_intermol_tot_num', 'Protein_phi_angle_tot_num', 'Protein_psi_angle_tot_num', 'Protein_chi_one_angle_tot_num', 'Protein_other_angle_tot_num', 'Protein_ambig_dihedral_tot_num', 'Protein_other_tot_num', 'NA_alpha_angle_tot_num', 'NA_beta_angle_tot_num', 'NA_gamma_angle_tot_num', 'NA_delta_angle_tot_num', 'NA_epsilon_angle_tot_num', 'NA_chi_angle_tot_num', 'NA_sugar_pucker_tot_num', 'NA_other_angle_tot_num', 'NA_amb_dihedral_angle_tot_num', 'NA_other_tot_num', 'H_bonds_constrained_tot_num', 'Constr_def_H_bonds_tot_num', 'SS_bonds_constrained_tot_num', 'Constr_def_SS_bonds_tot_num', 'Derived_coupling_const_tot_num', 'Derived_CACB_chem_shift_tot_num', 'Derived_1H_chem_shifts_tot_num', 'Derived_photo_cidnps_tot_num', 'Derived_paramag_relax_tot_num', 'Assumed_distances_tot_num', 'Assumed_angles_tot_num', 'Constraints_per_residue_avg', 'Constr_violations_per_residue_avg', 'Dist_constr_violat_stat_calc_method'],
    'sourcePrimaryKeys': ['Entry_ID', 'ID'],

    'tables': {

      'Constraint_stat_list_ens': {

        'tags': {

          'Constraint_stats_not_available': [None,lambda x = value: returnStarYesNo(x,length = 3),None,False],# Depositors are strongly encouraged to provide a few statistics related to the constraints used to calculate the ensemble of conformers and the conformer ensemble. If the statistics are not available$ the box provided can be checked and the constraint statistics page saved. This will remove the mandatory requirement to enter the statistical data.
          'Dist_Constraint_violation_max': [None,returnStarFloat,None,False],                                 # Value for the maximum distance constraint violation in angstroms.
          'Upper_dist_constr_violat_max': [None,returnStarFloat,None,False],                                  # Value for the maximum upper distance constraint violation in angstroms.
          'Lower_dist_constr_violat_max': [None,returnStarFloat,None,False],                                  # Value for the maximum lower distance constraint violation in angstroms.
          'Dist_Constraint_violation_avg': [None,returnStarFloat,None,False],                                 # Value for the average distance constraint violation.
          'All_dist_rmsd': [None,returnStarFloat,None,False],                                                 # Root mean squared deviation calculated over all distance constraint violations.
          'All_dist_rmsd_err': [None,returnStarFloat,None,False],                                             # Estimated error in the rmsd calculated over all distance contstraint violations.
          'Intraresidue_dist_rmsd': [None,returnStarFloat,None,False],                                        # Root mean squared deviation calculated over the intraresidue distance constrant violations for the ensemble of conformers.
          'Intraresidue_dist_rmsd_err': [None,returnStarFloat,None,False],                                    # Estimated error in the rmsd calculated over the intraresidue distance constraint violations for the ensemble of conformers.
          'Sequential_dist_rmsd': [None,returnStarFloat,None,False],                                          # Root mean squared deviation calculated over the 'sequencial distance constraint violations for the ensemble of conformers.
          'Sequential_dist_rmsd_err': [None,returnStarFloat,None,False],                                      # Estimated error in the rmsd calculated over the 'sequencial' distance constraint violations for the ensemble of conformers.
          'Short_range_dist_rmsd': [None,returnStarFloat,None,False],                                         # Root mean squared deviation calculated over the 'short range' distance constraint violations for the ensemble of conformers.
          'Short_range_dist_rmsd_err': [None,returnStarFloat,None,False],                                     # Estimated error in the rmsd calculated over the 'short range' distance constraint violations  for the ensemble of conformers.
          'Long_range_dist_rmsd': [None,returnStarFloat,None,False],                                          # Root mean squared deviation calculated over the 'long range' distance constraint violations for the ensemble of conformers.
          'Long_range_dist_rmsd_err': [None,returnStarFloat,None,False],                                      # Estimated error in the rmsd calculated over the 'long range' distnace constraint violations for the ensemble of conformers.
          'Unamb_intermol_dist_rmsd': [None,returnStarFloat,None,False],                                      # Root mean squared deviation calculated over the unambiguous intermolecular distance constraint violations for the ensemble of conformers.
          'Unamb_intermol_dist_rmsd_err': [None,returnStarFloat,None,False],                                  # Estimated error in the rmsd calculated over the unambiguous intermolecular distance constraint violations for the ensemble of conformers.
          'Amb_intermol_dist_rmsd': [None,returnStarFloat,None,False],                                        # Root mean squared deviation calculated over the ambiguous intermolecular distance constraint violations for the ensemble of conformers.
          'Amb_intermol_dist_rmsd_err': [None,returnStarFloat,None,False],                                    # Estimated error in the rmsd calculated over the ambiguous intermolecular distance constraint violations for the ensemble of conformers.
          'Amb_intramol_dist_rmsd': [None,returnStarFloat,None,False],                                        # Root mean squared deviation calculated over the ambiguous intramolecular distance constraint violations for the ensemble of conformers.
          'Amb_intramol_dist_rmsd_err': [None,returnStarFloat,None,False],                                    # Estimated error in the rmsd calculated over the ambiguous intramolecular distance constraint violations for the ensemble of conformers.
          'Hydrogen_bond_rmsd': [None,returnStarFloat,None,False],                                            # Root mean squared deviation calculated over the hydrogen bond constraint violations for the ensemble of conformers.
          'Hydrogen_bond_rmsd_err': [None,returnStarFloat,None,False],                                        # Estimated error in the rmsd calculated over the hydrogen bond constraint violations for the ensemble of conformers.
          'Dihedral_const_stat_calc_meth': [None,lambda x = value: returnStarLine(x,length = 127),None,False],# Method used to calculate the dihedral angle constraint violation statistics.
          'Dihedral_const_violat_max': [None,returnStarFloat,None,False],                                     # Value for the maximum dihedral angle constratint violation for the ensemble of conformers.
          'Dihedral_const_violat_avg': [None,returnStarFloat,None,False],                                     # Average dihedral angle constraint violation calculated over the ensemble of conformers.
          'Dihedral_angle_rmsd': [None,returnStarFloat,None,False],                                           # Root mean squared deviation value for the dihedral angle constraint violations calculated over the ensemble of conformers.
          'Dihedral_angle_rmsd_err': [None,returnStarFloat,None,False],                                       # Estimated error in the dihedral angle constraint violations calculated over the ensemble of conformers.
          'Dipolar_1H_1H_rmsd': [None,returnStarFloat,None,False],                                            # Root mean square deviation for the 1H-1H residual dipolar coupling restraints.
          'Dipolar_1H_1H_rmsd_err': [None,returnStarFloat,None,False],                                        # Root mean square deviation error for the 1H-1H residual dipolar coupling restraints.
          'Dipolar_1H_15N_rmsd': [None,returnStarFloat,None,False],                                           # Root mean square deviation for the 1H-15N residual dipolar coupling restraints.
          'Dipolar_1H_15N_rmsd_err': [None,returnStarFloat,None,False],                                       # Root mean square deviation error for the 1H-15N residual dipolar coupling restraints.
          'Dipolar_1H_13C_rmsd': [None,returnStarFloat,None,False],                                           # Root mean square deviation for the 1H-13C residual dipolar coupling restraints.
          'Dipolar_1H_13C_rmsd_err': [None,returnStarFloat,None,False],                                       # Root mean square deviation error for the 1H-13C residual dipolar coupling restraints.
          'Dipolar_13C_13C_rmsd': [None,returnStarFloat,None,False],                                          # Root mean square deviation for the 13C-13C residual dipolar coupling restraints.
          'Dipolar_13C_13C_rmsd_err': [None,returnStarFloat,None,False],                                      # Root mean square deviation error for the 13C-13C residual dipolar coupling restraints.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Constraint_stat_list_ID': [None,returnStarInt,'Constraint_stat_list.ID',True],                     # Pointer to '_Constraint_stat_list.ID'

                },

        'tagNames': ['Constraint_stats_not_available', 'Dist_Constraint_violation_max', 'Upper_dist_constr_violat_max', 'Lower_dist_constr_violat_max', 'Dist_Constraint_violation_avg', 'All_dist_rmsd', 'All_dist_rmsd_err', 'Intraresidue_dist_rmsd', 'Intraresidue_dist_rmsd_err', 'Sequential_dist_rmsd', 'Sequential_dist_rmsd_err', 'Short_range_dist_rmsd', 'Short_range_dist_rmsd_err', 'Long_range_dist_rmsd', 'Long_range_dist_rmsd_err', 'Unamb_intermol_dist_rmsd', 'Unamb_intermol_dist_rmsd_err', 'Amb_intermol_dist_rmsd', 'Amb_intermol_dist_rmsd_err', 'Amb_intramol_dist_rmsd', 'Amb_intramol_dist_rmsd_err', 'Hydrogen_bond_rmsd', 'Hydrogen_bond_rmsd_err', 'Dihedral_const_stat_calc_meth', 'Dihedral_const_violat_max', 'Dihedral_const_violat_avg', 'Dihedral_angle_rmsd', 'Dihedral_angle_rmsd_err', 'Dipolar_1H_1H_rmsd', 'Dipolar_1H_1H_rmsd_err', 'Dipolar_1H_15N_rmsd', 'Dipolar_1H_15N_rmsd_err', 'Dipolar_1H_13C_rmsd', 'Dipolar_1H_13C_rmsd_err', 'Dipolar_13C_13C_rmsd', 'Dipolar_13C_13C_rmsd_err', 'Entry_ID', 'Constraint_stat_list_ID'],
        'sourcePrimaryKeys': ['Entry_ID', 'Constraint_stat_list_ID'],

            },

      'Constraint_stat_list_rep': {

        'tags': {

          'Constraint_stats_not_available': [None,lambda x = value: returnStarYesNo(x,length = 3),None,False],# Depositors are strongly encouraged to enter statistics regarding the submitted constraints and the coordinates for the deposited representative conformer.
          'Dist_constraint_viol_max': [None,returnStarFloat,None,False],                                      # Value for the maximum distance constraint violation in angstroms.
          'Upper_dist_constr_violat_max': [None,returnStarFloat,None,False],                                  # Value for the maximum upper distance constraint violation in angstroms.
          'Lower_dist_constr_violat_max': [None,returnStarFloat,None,False],                                  # Value for the maximum lower distance constraint violation in angstroms.
          'Dist_Constraint_violation_avg': [None,returnStarFloat,None,False],                                 # Value for the average distance constraint violation.
          'Intraresidue_dist_rmsd': [None,returnStarFloat,None,False],                                        # Root mean squared deviation calculated over the intraresidue distance constrant violations for the representative conformer.
          'Intraresidue_dist_rmsd_err': [None,returnStarFloat,None,False],                                    # Estimated error in the rmsd calculated over the intraresidue distance constraint violations for the representative conformer.
          'Sequential_dist_rmsd': [None,returnStarFloat,None,False],                                          # Root mean squared deviation calculated over the 'sequencial distance constraint violations for the representative conformer.
          'Sequential_dist_rmsd_err': [None,returnStarFloat,None,False],                                      # Estimated error in the rmsd calculated over the 'sequencial' distance constraint violations for the representative conformer.
          'Short_range_dist_rmsd': [None,returnStarFloat,None,False],                                         # Root mean squared deviation calculated over the 'short range' distance constraint violations for the representative conformer.
          'Short_range_dist_rmsd_err': [None,returnStarFloat,None,False],                                     # Estimated error in the rmsd calculated over the 'short range' distance constraint violations  for the representative conformer.
          'Long_range_dist_rmsd': [None,returnStarFloat,None,False],                                          # Root mean squared deviation calculated over the 'long range' distance constraint violations for the representative conformer.
          'Long_range_dist_rmsd_err': [None,returnStarFloat,None,False],                                      # Estimated error in the rmsd calculated over the 'long range' distnace constraint violations for the representative conformer.
          'Unamb_intermol_dist_rmsd': [None,returnStarFloat,None,False],                                      # Root mean squared deviation calculated over the unambiguous intermolecular distance constraint violations for the representative conformer.
          'Unamb_intermol_dist_rmsd_err': [None,returnStarFloat,None,False],                                  # Estimated error in the rmsd calculated over the unambiguous intermolecular distance constraint violations for the representative conformer.
          'Amb_intermol_dist_rmsd': [None,returnStarFloat,None,False],                                        # Root mean squared deviation calculated over the ambiguous intermolecular distance constraint violations for the representative conformer.
          'Amb_intermol_dist_rmsd_err': [None,returnStarFloat,None,False],                                    # Estimated error in the rmsd calculated over the ambiguous intermolecular distance constraint violations for the representative conformer.
          'Amb_intramol_dist_rmsd': [None,returnStarFloat,None,False],                                        # Root mean squared deviation calculated over the ambiguous intramolecular distance constraint violations for the representative conformer.
          'Amb_intramol_dist_rmsd_err': [None,returnStarFloat,None,False],                                    # Estimated error in the rmsd calculated over the ambiguous intramolecular distance constraint violations for the representative conformer.
          'Hydrogen_bond_rmsd': [None,returnStarFloat,None,False],                                            # Root mean squared deviation calculated over the hydrogen bond constraint violations for the representative conformer.
          'Hydrogen_bond_rmsd_err': [None,returnStarFloat,None,False],                                        # Estimated error in the rmsd calculated over the hydrogen bond constraint violations for the representative conformer.
          'Dihedral_angle_rmsd': [None,returnStarFloat,None,False],                                           # Root mean squared deviation value for the dihedral angle constraint violations calculated over the representative conformer.
          'Dihedral_angle_rmsd_err': [None,returnStarFloat,None,False],                                       # Estimated error in the dihedral angle constraint violations calculated over the representative conformer.
          'Dipolar_1H_1H_rmsd': [None,returnStarFloat,None,False],                                            # Root mean square deviation for the 1H-1H residual dipolar coupling restraints.
          'Dipolar_1H_1H_rmsd_err': [None,returnStarFloat,None,False],                                        # Root mean square deviation error for the 1H-1H residual dipolar coupling restraints.
          'Dipolar_1H_13C_rmsd': [None,returnStarFloat,None,False],                                           # Root mean square deviation for the 1H-15N residual dipolar coupling restraints.
          'Dipolar_1H_13C_rmsd_err': [None,returnStarFloat,None,False],                                       # Root mean square deviation error for the 1H-15N residual dipolar coupling restraints.
          'Dipolar_1H_15N_rmsd': [None,returnStarFloat,None,False],                                           # Root mean square deviation for the 1H-13C residual dipolar coupling restraints.
          'Dipolar_1H_15N_rmsd_err': [None,returnStarFloat,None,False],                                       # Root mean square deviation error for the 1H-13C residual dipolar coupling restraints.
          'Dipolar_13C_13C_rmsd': [None,returnStarFloat,None,False],                                          # Root mean square deviation for the 13C-13C residual dipolar coupling restraints.
          'Dipolar_13C_13C_rmsd_err': [None,returnStarFloat,None,False],                                      # Root mean square deviation error for the 13C-13C residual dipolar coupling restraints.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Constraint_stat_list_ID': [None,returnStarInt,'Constraint_stat_list.ID',True],                     # Pointer to '_Constraint_stat_list.ID'

                },

        'tagNames': ['Constraint_stats_not_available', 'Dist_constraint_viol_max', 'Upper_dist_constr_violat_max', 'Lower_dist_constr_violat_max', 'Dist_Constraint_violation_avg', 'Intraresidue_dist_rmsd', 'Intraresidue_dist_rmsd_err', 'Sequential_dist_rmsd', 'Sequential_dist_rmsd_err', 'Short_range_dist_rmsd', 'Short_range_dist_rmsd_err', 'Long_range_dist_rmsd', 'Long_range_dist_rmsd_err', 'Unamb_intermol_dist_rmsd', 'Unamb_intermol_dist_rmsd_err', 'Amb_intermol_dist_rmsd', 'Amb_intermol_dist_rmsd_err', 'Amb_intramol_dist_rmsd', 'Amb_intramol_dist_rmsd_err', 'Hydrogen_bond_rmsd', 'Hydrogen_bond_rmsd_err', 'Dihedral_angle_rmsd', 'Dihedral_angle_rmsd_err', 'Dipolar_1H_1H_rmsd', 'Dipolar_1H_1H_rmsd_err', 'Dipolar_1H_13C_rmsd', 'Dipolar_1H_13C_rmsd_err', 'Dipolar_1H_15N_rmsd', 'Dipolar_1H_15N_rmsd_err', 'Dipolar_13C_13C_rmsd', 'Dipolar_13C_13C_rmsd_err', 'Entry_ID', 'Constraint_stat_list_ID'],
        'sourcePrimaryKeys': ['Entry_ID', 'Constraint_stat_list_ID'],

            },

      'Constraint_stats_constr_list': {

        'tags': {

          'Constraint_list_category': [None,lambda x = value: returnStarLine(x,length = 127),None,True],      # Saveframe category for the type of constraints used to calculate the constraint statistics.
          'Constraint_list_ID': [None,returnStarInt,None,True],                                               # Pointer to the ID for the saveframe of the category defined by the tag '_Conf_family_coord_set_constr_list.Constraint_list_category'.
          'Constraint_list_label': [None,lambda x = value: returnStarLabel(x,length = 127),None,True],        # Pointer to a saveframe that contains structural constraint values.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Constraint_stat_list_ID': [None,returnStarInt,'Constraint_stat_list.ID',True],                     # Pointer to '_Constraint_stat_list.ID'

                },

        'tagNames': ['Constraint_list_category', 'Constraint_list_ID', 'Constraint_list_label', 'Entry_ID', 'Constraint_stat_list_ID'],
        'sourcePrimaryKeys': ['Constraint_list_category', 'Constraint_list_ID', 'Entry_ID', 'Constraint_stat_list_ID'],

            },

      'Constraint_file': {

        'tags': {

          'ID': [None,returnStarInt,None,False],                                                              # Local unique identifier for the listed constraint file.
          'Constraint_filename': [None,lambda x = value: returnStarLine(x,length = 127),None,True],           # Name of the uploaded file that contains the constraint data.
          'Software_ID': [None,returnStarInt,'Software.ID',False],                                            # Pointer to '_Software.ID'
          'Software_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Software.Sf_framecode',False],# A pointer to a saveframe of category software.
          'Software_name': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                # Name of the software application that the listed constraint file is used as input.
          'Block_ID': [None,returnStarInt,None,False],                                                        # Local unique identifier for a block of constraints within the constraint file.
          'Constraint_type': [None,lambda x = value: returnStarLine(x,length = 127),None,True],               # The general type of constraint (distance$ torsion angle$ RDC$ etc.)
          'Constraint_subtype': [None,lambda x = value: returnStarLine(x,length = 31),None,True],             # Specific type of constraint.
          'Constraint_subsubtype': [None,lambda x = value: returnStarLine(x,length = 31),None,False],         # Another level of description of the type of constraints in the file (simple$ ambiguous$ etc.)
          'Constraint_number': [None,returnStarInt,None,False],                                               # Number of constraints of this type and subtype in the file.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Constraint_stat_list_ID': [None,returnStarInt,'Constraint_stat_list.ID',True],                     # Pointer to '_Constraint_stat_list.ID'

                },

        'tagNames': ['ID', 'Constraint_filename', 'Software_ID', 'Software_label', 'Software_name', 'Block_ID', 'Constraint_type', 'Constraint_subtype', 'Constraint_subsubtype', 'Constraint_number', 'Entry_ID', 'Constraint_stat_list_ID'],
        'sourcePrimaryKeys': ['Constraint_filename', 'Constraint_type', 'Constraint_subtype', 'Entry_ID', 'Constraint_stat_list_ID'],

            }

        },

    'tableNames': ['Constraint_stat_list_ens', 'Constraint_stat_list_rep', 'Constraint_stats_constr_list', 'Constraint_file']

    },

  'force_constants': {

    'name': 'Force_constant_list',

    'tags': {

      'Sf_category': ['force_constants',lambda x = value: returnStarCode(x,length = 127),None,True],          # Category definition for the information content of the saveframe
      'Sf_framecode': [None,lambda x = value: returnStarCode(x,length = 127),None,False],                     # A label for the saveframe that describes in very brief terms the information contained in the saveframe.
      'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                     # Pointer to '_Entry.ID'
      'ID': [None,returnStarInt,None,True],                                                                   # Unique identifier for the list of reported force constants used in calculating structures.
      'Data_file_name': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                   # Name of the uploaded data file that contains the list of force constant values used in calculating the structure.
      'Default_software_values_used': [None,lambda x = value: returnStarYesNo(x,length = 3),None,False],      # Code defining if the default force constant values provided with the software package were used.
      'Details': [None,returnStarString,None,False],                                                          # Text providing additional information regarding the force constants used in calculating a structure.

            },

    'tagNames': ['Sf_category', 'Sf_framecode', 'Entry_ID', 'ID', 'Data_file_name', 'Default_software_values_used', 'Details'],
    'sourcePrimaryKeys': ['Entry_ID', 'ID'],

    'tables': {

      'Force_constant_software': {

        'tags': {

          'Software_ID': [None,returnStarInt,'Software.ID',True],                                             # Pointer to '_Software.ID'
          'Software_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Software.Sf_framecode',False],# Pointer to a saveframe of the category 'software'
          'Method_ID': [None,returnStarInt,'Method.ID',False],                                                # Pointer to '_Method.ID'
          'Method_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Method.Sf_framecode',False],# Pointer to a saveframe of the category 'method'
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Force_constant_list_ID': [None,returnStarInt,'Force_constant_list.ID',True],                       # Pointer to '_Force_constant_list.ID'

                },

        'tagNames': ['Software_ID', 'Software_label', 'Method_ID', 'Method_label', 'Entry_ID', 'Force_constant_list_ID'],
        'sourcePrimaryKeys': ['Software_ID', 'Entry_ID', 'Force_constant_list_ID'],

            },

      'Force_constant': {

        'tags': {

          'ID': [None,returnStarInt,None,True],                                                               # Unique identifier for the reported force constant.
          'Term': [None,lambda x = value: returnStarLine(x,length = 31),None,True],                           # Select a force constant parameter from the list provided or enter your own name for the parameter that you are entering a value.
          'Units': [None,lambda x = value: returnStarCode(x,length = 15),None,True],                          # Provide the units for the value entered.
          'Val': [None,returnStarFloat,None,True],                                                            # Enter the value for the selected or manually entered force constant parameter.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Force_constant_list_ID': [None,returnStarInt,'Force_constant_list.ID',True],                       # Pointer to '_Force_constant_list.ID'

                },

        'tagNames': ['ID', 'Term', 'Units', 'Val', 'Entry_ID', 'Force_constant_list_ID'],
        'sourcePrimaryKeys': ['ID', 'Entry_ID', 'Force_constant_list_ID'],

            }

        },

    'tableNames': ['Force_constant_software', 'Force_constant']

    },

  'angular_order_parameters': {

    'name': 'Angular_order_parameter_list',

    'tags': {

      'Sf_category': ['angular_order_parameters',lambda x = value: returnStarCode(x,length = 31),None,True],  # Category definition for the information content of the saveframe
      'Sf_framecode': [None,lambda x = value: returnStarCode(x,length = 127),None,False],                     # A label for the saveframe that describes in very brief terms the information contained in the saveframe.
      'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                     # Pointer to '_Entry.ID'
      'ID': [None,returnStarInt,None,True],                                                                   # Unique identifier for the list of reported angular order parameters.
      'Data_file_name': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                   # The name of the file submitted with this depostion that contains the quantitative data for this saveframe.
      'Text_data_format': [None,lambda x = value: returnStarLine(x,length = 31),None,False],                  # The data format used to represent the angular order parameter data as ASCII text in the text block that is the value to the '_Angular_order_parameter_list.Text_data' tag.
      'Text_data': [None,returnStarString,None,False],                                                        # A set of angular order parameter data formatted as ASCII text.

            },

    'tagNames': ['Sf_category', 'Sf_framecode', 'Entry_ID', 'ID', 'Data_file_name', 'Text_data_format', 'Text_data'],
    'sourcePrimaryKeys': ['Entry_ID', 'ID'],

    'tables': {

      'Angular_order_param': {

        'tags': {

          'ID': [None,returnStarInt,None,True],                                                               # Unique identifier for the reported angular order parameter value.
          'Assembly_atom_ID': [None,returnStarInt,'Atom.Assembly_atom_ID',False],                             # Pointer to '_Atom.Assembly_atom_ID'
          'Entity_assembly_ID': [None,returnStarInt,'Entity_assembly.ID',True],                               # Pointer to '_Entity_assembly.ID'
          'Entity_ID': [None,returnStarInt,'Entity.ID',True],                                                 # Pointer to '_Entity.ID'
          'Comp_index_ID': [None,returnStarInt,'Entity_comp_index.ID',True],                                  # Pointer to '_Entity_comp_index.ID'
          'Seq_ID': [None,returnStarInt,'Entity_poly_seq.Num',True],                                          # Pointer to '_Entity_poly_seq.Num'
          'Comp_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Chem_comp.ID',True],              # Pointer to '_Chem_comp.ID'
          'Phi_S_angle_val': [None,returnStarFloat,None,False],                                               # Order parameter value for the phi torsion angle in a protein.
          'Psi_S_angle_val': [None,returnStarFloat,None,False],                                               # Order parameter value for the psi torsion angle in a protein.
          'Chi_1_S_angle_val': [None,returnStarFloat,None,False],                                             # Order parameter value for the chi1 torsion angle in a protein.
          'Chi_2_S_angle_val': [None,returnStarFloat,None,False],                                             # Order parameter value for the chi2 torsion angle in a protein.
          'Auth_entity_assembly_ID': [None,returnStarInt,None,False],                                         # An alternative identifier for Entity_assembly_id that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number.
          'Auth_seq_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                   # An alternative identifier for Seq_id that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Seq_ID or Comp_index_ID.
          'Auth_comp_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                  # An alternative identifier for Comp_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Auth_atom_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                  # An alternative identifier for Atom_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Angular_order_parameter_list_ID': [None,returnStarInt,'Angular_order_parameter_list.ID',True],     # Pointer to '_Angular_order_parameter_list.ID'

                },

        'tagNames': ['ID', 'Assembly_atom_ID', 'Entity_assembly_ID', 'Entity_ID', 'Comp_index_ID', 'Seq_ID', 'Comp_ID', 'Phi_S_angle_val', 'Psi_S_angle_val', 'Chi_1_S_angle_val', 'Chi_2_S_angle_val', 'Auth_entity_assembly_ID', 'Auth_seq_ID', 'Auth_comp_ID', 'Auth_atom_ID', 'Entry_ID', 'Angular_order_parameter_list_ID'],
        'sourcePrimaryKeys': ['ID', 'Entry_ID', 'Angular_order_parameter_list_ID'],

            }

        },

    'tableNames': ['Angular_order_param']

    },

  'tertiary_struct_elements': {

    'name': 'Tertiary_struct_element_list',

    'tags': {

      'Sf_category': ['tertiary_struct_elements',lambda x = value: returnStarCode(x,length = 31),None,True],  # Category definition for the information content of the saveframe
      'Sf_framecode': [None,lambda x = value: returnStarCode(x,length = 127),None,False],                     # A label for the saveframe that describes in very brief terms the information contained in the saveframe.
      'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                     # Pointer to '_Entry.ID'
      'ID': [None,returnStarInt,None,True],                                                                   # Unique identifier for the list of reported tertiary structure elements.

            },

    'tagNames': ['Sf_category', 'Sf_framecode', 'Entry_ID', 'ID'],
    'sourcePrimaryKeys': ['Entry_ID', 'ID'],

    'tables': {

      'Tertiary_struct_element_sel': {

        'tags': {

          'Method_ID': [None,returnStarInt,'Method.ID',True],                                                 # Pointer to '_Method.ID'
          'Method_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Method.Sf_framecode',False],# Name of the method used to select the chemical components of the system that make up the tertiary structural element.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Tertiary_struct_element_list_ID': [None,returnStarInt,'Tertiary_struct_element_list.ID',True],     # Pointer to '_Tertiary_struct_element_list.ID'

                },

        'tagNames': ['Method_ID', 'Method_label', 'Entry_ID', 'Tertiary_struct_element_list_ID'],
        'sourcePrimaryKeys': ['Method_ID', 'Entry_ID', 'Tertiary_struct_element_list_ID'],

            },

      'Tertiary_struct': {

        'tags': {

          'ID': [None,returnStarInt,None,True],                                                               # Unique identifier for the reported tertiary structure element.
          'Tertiary_struct_code': [None,lambda x = value: returnStarCode(x,length = 15),None,False],          # A word or very brief phrase that defines a specific type of local region of a biopolymer's tertiary structure.
          'Tertiary_struct_name': [None,lambda x = value: returnStarLine(x,length = 127),None,True],          # An author defined name for the tertiary structure element.
          'Assembly_atom_ID': [None,returnStarInt,'Atom.Assembly_atom_ID',False],                             # Pointer to '_Atom.Assembly_atom_ID'
          'Entity_assembly_ID': [None,returnStarInt,'Entity_assembly.ID',True],                               # Pointer to '_Entity_assembly.ID'
          'Entity_ID': [None,returnStarInt,'Entity.ID',True],                                                 # Pointer to '_Entity.ID'
          'Entity_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Entity.Sf_framecode',False],# Pointer to a saveframe of the category 'entity'
          'Comp_index_ID': [None,returnStarInt,'Entity_comp_index.ID',True],                                  # Pointer to '_Entity_comp_index.ID'
          'Seq_ID': [None,returnStarInt,'Entity_poly_seq.Num',True],                                          # Pointer to '_Entity_poly_seq.Num'
          'Comp_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Chem_comp.ID',True],              # Pointer to '_Chem_comp.ID'
          'Atom_ID': [None,lambda x = value: returnStarAtCode(x,length = 12),'Chem_comp_atom.Atom_ID',True],  # Pointer to '_Chem_comp_atom.Atom_ID'
          'Atom_type': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                     # The value for this tag is a standard IUPAC abbreviation for a chemical element (i.e.$ H$ C$ P$ etc).
          'Tertiary_struct_element_code': [None,lambda x = value: returnStarCode(x,length = 15),None,True],   # Code defining the type of tertiary structure element that is being defined.
          'Details': [None,returnStarString,None,False],                                                      # Text providing additional information concerning the reported tertiary structure element.
          'Auth_entity_assembly_ID': [None,returnStarInt,None,False],                                         # An alternative identifier for Entity_assembly_id that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number.
          'Auth_seq_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                   # An alternative identifier for Seq_id that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Seq_ID or Comp_index_ID.
          'Auth_comp_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                  # An alternative identifier for Comp_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Auth_atom_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                  # An alternative identifier for Atom_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Tertiary_struct_element_list_ID': [None,returnStarInt,'Tertiary_struct_element_list.ID',True],     # Pointer to '_Tertiary_struct_element_list.ID'

                },

        'tagNames': ['ID', 'Tertiary_struct_code', 'Tertiary_struct_name', 'Assembly_atom_ID', 'Entity_assembly_ID', 'Entity_ID', 'Entity_label', 'Comp_index_ID', 'Seq_ID', 'Comp_ID', 'Atom_ID', 'Atom_type', 'Tertiary_struct_element_code', 'Details', 'Auth_entity_assembly_ID', 'Auth_seq_ID', 'Auth_comp_ID', 'Auth_atom_ID', 'Entry_ID', 'Tertiary_struct_element_list_ID'],
        'sourcePrimaryKeys': ['ID', 'Entity_assembly_ID', 'Comp_index_ID', 'Atom_ID', 'Entry_ID', 'Tertiary_struct_element_list_ID'],

            }

        },

    'tableNames': ['Tertiary_struct_element_sel', 'Tertiary_struct']

    },

  'secondary_structs': {

    'name': 'Secondary_struct_list',

    'tags': {

      'Sf_category': ['secondary_structs',lambda x = value: returnStarCode(x,length = 31),None,True],         # Category definition for the information content of the saveframe
      'Sf_framecode': [None,lambda x = value: returnStarCode(x,length = 127),None,False],                     # A label for the saveframe that describes in very brief terms the information contained in the saveframe.
      'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                     # Pointer to '_Entry.ID'
      'ID': [None,returnStarInt,None,True],                                                                   # An integer value that uniquely identifies this saveframe of secondary structure element data from other saveframes of this category in an entry.
      'Representative_conformer_ID': [None,returnStarInt,'Representative_conformer.ID',False],                # Pointer to '_Representative_conformer.ID'
      'Representative_conformer_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Representative_conformer.Sf_framecode',False],# Pointer to a saveframe of the category 'representative_conformer'

            },

    'tagNames': ['Sf_category', 'Sf_framecode', 'Entry_ID', 'ID', 'Representative_conformer_ID', 'Representative_conformer_label'],
    'sourcePrimaryKeys': ['Entry_ID', 'ID'],

    'tables': {

      'Secondary_struct_sel': {

        'tags': {

          'Method_ID': [None,returnStarInt,'Method.ID',True],                                                 # Pointer to '_Method.ID'
          'Method_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Method.Sf_framecode',True],# Pointer to a saveframe of the category 'method'
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Secondary_struct_list_ID': [None,returnStarInt,'Secondary_struct_list.ID',True],                   # Pointer to '_Secondary_struct_list.ID'

                },

        'tagNames': ['Method_ID', 'Method_label', 'Entry_ID', 'Secondary_struct_list_ID'],
        'sourcePrimaryKeys': ['Method_ID', 'Entry_ID', 'Secondary_struct_list_ID'],

            },

      'Secondary_struct': {

        'tags': {

          'ID': [None,returnStarInt,None,True],                                                               # An integer value that uniquely identifies the reported secondary structure element.
          'Conf_family_coord_set_ID': [None,returnStarInt,'Conformer_family_coord_set.ID',False],             # Pointer to '_Conformer_family_coord_set.ID'
          'Conf_family_coord_set_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Conformer_family_coord_set.Sf_framecode',False],# Pointer to a saveframe of the category 'conformer_family'
          'Entity_assembly_ID': [None,returnStarInt,'Entity_assembly.ID',True],                               # Pointer to '_Entity_assembly.ID'
          'Entity_ID': [None,returnStarInt,'Entity.ID',True],                                                 # Pointer to '_Entity.ID'
          'Comp_index_ID_start': [None,returnStarInt,'Entity_comp_index.ID',True],                            # Pointer to '_Entity_comp_index.ID'
          'Comp_index_ID_end': [None,returnStarInt,'Entity_comp_index.ID',True],                              # Pointer to '_Entity_comp_index.ID'
          'Seq_ID_start': [None,returnStarInt,'Entity_poly_seq.Num',True],                                    # Sequence number for the first chemical component in the structure element. Pointer to '_Entity_poly_seq.Num'
          'Seq_ID_end': [None,returnStarInt,'Entity_poly_seq.Num',True],                                      # Sequence number for the Last chemical component in the structure element.  Pointer to '_Entity_poly_seq.Num'
          'Auth_seq_ID_start': [None,lambda x = value: returnStarCode(x,length = 15),None,False],             # An alternative identifier for Seq_id that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Seq_ID or Comp_index_ID.
          'Auth_seq_ID_end': [None,lambda x = value: returnStarCode(x,length = 15),None,False],               # An alternative identifier for Seq_id that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Seq_ID or Comp_index_ID.
          'Name': [None,lambda x = value: returnStarLine(x,length = 127),None,True],                          # An author defined name for the tertiary structure element.
          'Code': [None,lambda x = value: returnStarCode(x,length = 15),None,True],                           # Code defining the type of secondary structure element that is being defined.
          'Details': [None,returnStarString,None,False],                                                      # Text providing additional information concerning the reported secondary structure element.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Secondary_struct_list_ID': [None,returnStarInt,'Secondary_struct_list.ID',True],                   # Pointer to '_Secondary_struct_list.ID'

                },

        'tagNames': ['ID', 'Conf_family_coord_set_ID', 'Conf_family_coord_set_label', 'Entity_assembly_ID', 'Entity_ID', 'Comp_index_ID_start', 'Comp_index_ID_end', 'Seq_ID_start', 'Seq_ID_end', 'Auth_seq_ID_start', 'Auth_seq_ID_end', 'Name', 'Code', 'Details', 'Entry_ID', 'Secondary_struct_list_ID'],
        'sourcePrimaryKeys': ['ID', 'Entry_ID', 'Secondary_struct_list_ID'],

            }

        },

    'tableNames': ['Secondary_struct_sel', 'Secondary_struct']

    },

  'bond_annotation': {

    'name': 'Bond_annotation_list',

    'tags': {

      'Sf_category': ['bond_annotation',lambda x = value: returnStarCode(x,length = 31),None,True],           # Category definition for the information content of the saveframe
      'Sf_framecode': [None,lambda x = value: returnStarCode(x,length = 127),None,False],                     # A label for the saveframe that describes in very brief terms the information contained in the saveframe.
      'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                     # Pointer to '_Entry.ID'
      'ID': [None,returnStarInt,None,True],                                                                   # Unique identifier for the list of bond annotations.
      'Details': [None,returnStarString,None,False],                                                          # Text information that provides additional information about a bond.

            },

    'tagNames': ['Sf_category', 'Sf_framecode', 'Entry_ID', 'ID', 'Details'],
    'sourcePrimaryKeys': ['Entry_ID', 'ID'],

    'tables': {

      'Bond_annotation': {

        'tags': {

          'ID': [None,returnStarInt,None,True],                                                               # Unique identifier for the reported bond annotation.
          'Bond_type': [None,lambda x = value: returnStarCode(x,length = 31),None,True],                      # A commonly used term that describes the chemical nature of the bond.
          'Bond_order': [None,lambda x = value: returnStarCode(x,length = 31),None,True],                     # The order of the defined bond.
          'Selection_method_ID': [None,returnStarInt,'Method.ID',False],                                      # Pointer to '_Method.ID'
          'Assembly_atom_ID_1': [None,returnStarInt,'Atom.Assembly_atom_ID',False],                           # Pointer to '_Atom.Assembly_atom_ID'
          'Entity_assembly_ID_1': [None,returnStarInt,'Entity_assembly.ID',True],                             # Pointer to '_Entity_assembly.ID'
          'Entity_ID_1': [None,returnStarInt,'Entity.ID',True],                                               # Pointer to '_Entity.ID'
          'Comp_index_ID_1': [None,returnStarInt,'Entity_comp_index.ID',True],                                # Pointer to '_Entity_comp_index.ID'
          'Seq_ID_1': [None,returnStarInt,'Entity_poly_seq.Num',True],                                        # Pointer to '_Entity_poly_seq.Num'
          'Comp_ID_1': [None,lambda x = value: returnStarCode(x,length = 12),'Chem_comp.ID',True],            # Pointer to '_Chem_comp.ID'
          'Atom_ID_1': [None,lambda x = value: returnStarAtCode(x,length = 12),'Chem_comp_atom.Atom_ID',True],# Pointer to '_Chem_comp_atom.Atom_ID'
          'Atom_type_1': [None,lambda x = value: returnStarCode(x,length = 15),None,True],                    # Standard symbol used to define the atom element type.
          'Atom_isotope_number_1': [None,returnStarInt,None,False],                                           # The mass number for the chemical element defined by the tag '_Atom_type' or any of its related tags.
          'Assembly_atom_ID_2': [None,returnStarInt,'Atom.Assembly_atom_ID',False],                           # Pointer to '_Atom.Assembly_atom_ID'
          'Entity_assembly_ID_2': [None,returnStarInt,'Entity_assembly.ID',True],                             # Pointer to '_Entity_assembly.ID'
          'Entity_ID_2': [None,returnStarInt,'Entity.ID',True],                                               # Pointer to '_Entity.ID'
          'Comp_index_ID_2': [None,returnStarInt,'Entity_comp_index.ID',True],                                # Pointer to '_Entity_comp_index.ID'
          'Seq_ID_2': [None,returnStarInt,'Entity_poly_seq.Num',True],                                        # Pointer to '_Entity_poly_seq.Num'
          'Comp_ID_2': [None,lambda x = value: returnStarCode(x,length = 12),'Chem_comp.ID',True],            # Pointer to '_Chem_comp.ID'
          'Atom_ID_2': [None,lambda x = value: returnStarAtCode(x,length = 12),'Chem_comp_atom.Atom_ID',True],# Pointer to '_Chem_comp_atom.Atom_ID'
          'Atom_type_2': [None,lambda x = value: returnStarCode(x,length = 15),None,True],                    # Standard symbol used to define the atom element type.
          'Atom_isotope_number_2': [None,returnStarInt,None,False],                                           # The mass number for the chemical element defined by the tag '_Atom_type' or any of its related tags.
          'Details': [None,returnStarString,None,False],                                                      # Text description providing additional information about the reported bond.
          'Auth_entity_assembly_ID_1': [None,returnStarInt,None,False],                                       # An alternative identifier for Entity_assembly_id that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number.
          'Auth_seq_ID_1': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                 # An alternative identifier for Seq_id that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Seq_ID or Comp_index_ID.
          'Auth_comp_ID_1': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                # An alternative identifier for Comp_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Auth_atom_ID_1': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                # An alternative identifier for Atom_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Auth_entity_assembly_ID_2': [None,returnStarInt,None,False],                                       # An alternative identifier for Entity_assembly_id that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number.
          'Auth_seq_ID_2': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                 # An alternative identifier for Seq_id that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Seq_ID or Comp_index_ID.
          'Auth_comp_ID_2': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                # An alternative identifier for Comp_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Auth_atom_ID_2': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                # An alternative identifier for Atom_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Bond_annotation_list_ID': [None,returnStarInt,'Bond_annotation_list.ID',True],                     # Pointer to '_Bond_annotation_list.ID'

                },

        'tagNames': ['ID', 'Bond_type', 'Bond_order', 'Selection_method_ID', 'Assembly_atom_ID_1', 'Entity_assembly_ID_1', 'Entity_ID_1', 'Comp_index_ID_1', 'Seq_ID_1', 'Comp_ID_1', 'Atom_ID_1', 'Atom_type_1', 'Atom_isotope_number_1', 'Assembly_atom_ID_2', 'Entity_assembly_ID_2', 'Entity_ID_2', 'Comp_index_ID_2', 'Seq_ID_2', 'Comp_ID_2', 'Atom_ID_2', 'Atom_type_2', 'Atom_isotope_number_2', 'Details', 'Auth_entity_assembly_ID_1', 'Auth_seq_ID_1', 'Auth_comp_ID_1', 'Auth_atom_ID_1', 'Auth_entity_assembly_ID_2', 'Auth_seq_ID_2', 'Auth_comp_ID_2', 'Auth_atom_ID_2', 'Entry_ID', 'Bond_annotation_list_ID'],
        'sourcePrimaryKeys': ['ID', 'Entry_ID', 'Bond_annotation_list_ID'],

            },

      'Bond_observed_conformer': {

        'tags': {

          'Bond_annotation_ID': [None,returnStarInt,'Bond_annotation.ID',True],                               # Pointer to '_Bond_annotation.ID'
          'Conformer_family_coord_set_ID': [None,returnStarInt,'Conformer_family_coord_set.ID',True],         # Pointer to '_Conformer_family_coord_set.ID'
          'Atom_site_model_ID': [None,returnStarInt,'Atom_site.Model_ID',True],                               # Pointer to '_Atom_site.Model_ID'
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Bond_annotation_list_ID': [None,returnStarInt,'Bond_annotation_list.ID',True],                     # Pointer to '_Bond_annotation_list.ID'

                },

        'tagNames': ['Bond_annotation_ID', 'Conformer_family_coord_set_ID', 'Atom_site_model_ID', 'Entry_ID', 'Bond_annotation_list_ID'],
        'sourcePrimaryKeys': ['Bond_annotation_ID', 'Conformer_family_coord_set_ID', 'Atom_site_model_ID', 'Entry_ID', 'Bond_annotation_list_ID'],

            }

        },

    'tableNames': ['Bond_annotation', 'Bond_observed_conformer']

    },

  'structure_interactions': {

    'name': 'Structure_interaction_list',

    'tags': {

      'Sf_category': ['structure_interactions',lambda x = value: returnStarCode(x,length = 31),None,True],    # Category definition for the information content of the saveframe
      'Sf_framecode': [None,lambda x = value: returnStarCode(x,length = 127),None,False],                     # A label for the saveframe that describes in very brief terms the information contained in the saveframe.
      'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                     # Pointer to '_Entry.ID'
      'ID': [None,returnStarInt,None,True],                                                                   # Unique identifier for the list of reported structure interactions.
      'Details': [None,returnStarString,None,False],                                                          # Text description providing additional information about the reported list of structure interactions.

            },

    'tagNames': ['Sf_category', 'Sf_framecode', 'Entry_ID', 'ID', 'Details'],
    'sourcePrimaryKeys': ['Entry_ID', 'ID'],

    'tables': {

      'Structure_interaction': {

        'tags': {

          'ID': [None,returnStarInt,None,True],                                                               # Unique identifier for the reported structural interaction.
          'Type': [None,lambda x = value: returnStarLine(x,length = 127),None,True],                          # A code defining the type of interaction observed.
          'Selection_method_ID': [None,returnStarInt,'Method.ID',False],                                      # Pointer to '_Method.ID'
          'Assembly_atom_ID_1': [None,returnStarInt,'Atom.Assembly_atom_ID',False],                           # Pointer to '_Atom.Assembly_atom_ID'
          'Entity_assembly_ID_1': [None,returnStarInt,'Entity_assembly.ID',True],                             # Pointer to '_Entity_assembly.ID'
          'Entity_ID_1': [None,returnStarInt,'Entity.ID',True],                                               # Pointer to '_Entity.ID'
          'Comp_index_ID_1': [None,returnStarInt,'Entity_comp_index.ID',True],                                # Pointer to '_Entity_comp_index.ID'
          'Seq_ID_1': [None,returnStarInt,'Entity_poly_seq.Num',True],                                        # Pointer to '_Entity_poly_seq.Num'
          'Comp_ID_1': [None,lambda x = value: returnStarCode(x,length = 12),'Chem_comp.ID',True],            # Pointer to '_Chem_comp.ID'
          'Atom_ID_1': [None,lambda x = value: returnStarAtCode(x,length = 12),'Chem_comp_atom.Atom_ID',False],# Pointer to '_Chem_comp_atom.Atom_ID'
          'Atom_type_1': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                   # Standard symbol used to define the atom element type.
          'Assembly_atom_ID_2': [None,returnStarInt,'Atom.Assembly_atom_ID',False],                           # Pointer to '_Atom.Assembly_atom_ID'
          'Entity_assembly_ID_2': [None,returnStarInt,'Entity_assembly.ID',True],                             # Pointer to '_Entity_assembly.ID'
          'Entity_ID_2': [None,returnStarInt,'Entity.ID',True],                                               # Pointer to '_Entity.ID'
          'Comp_index_ID_2': [None,returnStarInt,'Entity_comp_index.ID',True],                                # Pointer to '_Entity_comp_index.ID'
          'Seq_ID_2': [None,returnStarInt,'Entity_poly_seq.Num',True],                                        # Pointer to '_Entity_poly_seq.Num'
          'Comp_ID_2': [None,lambda x = value: returnStarCode(x,length = 12),'Chem_comp.ID',True],            # Pointer to '_Chem_comp.ID'
          'Atom_ID_2': [None,lambda x = value: returnStarAtCode(x,length = 12),'Chem_comp_atom.Atom_ID',False],# Pointer to '_Chem_comp_atom.Atom_ID'
          'Atom_type_2': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                   # Standard symbol used to define the atom element type.
          'Details': [None,returnStarString,None,False],                                                      # Text description providing additional information about the reported structure interaction.
          'Auth_entity_assembly_ID_1': [None,returnStarInt,None,False],                                       # An alternative identifier for Entity_assembly_id that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number.
          'Auth_seq_ID_1': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                 # An alternative identifier for Seq_id that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Seq_ID or Comp_index_ID.
          'Auth_comp_ID_1': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                # An alternative identifier for Comp_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Auth_atom_ID_1': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                # An alternative identifier for Atom_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Auth_entity_assembly_ID_2': [None,returnStarInt,None,False],                                       # An alternative identifier for Entity_assembly_id that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number.
          'Auth_seq_ID_2': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                 # An alternative identifier for Seq_id that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Seq_ID or Comp_index_ID.
          'Auth_comp_ID_2': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                # An alternative identifier for Comp_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Auth_atom_ID_2': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                # An alternative identifier for Atom_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Structure_interaction_list_ID': [None,returnStarInt,'Structure_interaction_list.ID',True],         # Pointer to '_Structure_interaction_list.ID'

                },

        'tagNames': ['ID', 'Type', 'Selection_method_ID', 'Assembly_atom_ID_1', 'Entity_assembly_ID_1', 'Entity_ID_1', 'Comp_index_ID_1', 'Seq_ID_1', 'Comp_ID_1', 'Atom_ID_1', 'Atom_type_1', 'Assembly_atom_ID_2', 'Entity_assembly_ID_2', 'Entity_ID_2', 'Comp_index_ID_2', 'Seq_ID_2', 'Comp_ID_2', 'Atom_ID_2', 'Atom_type_2', 'Details', 'Auth_entity_assembly_ID_1', 'Auth_seq_ID_1', 'Auth_comp_ID_1', 'Auth_atom_ID_1', 'Auth_entity_assembly_ID_2', 'Auth_seq_ID_2', 'Auth_comp_ID_2', 'Auth_atom_ID_2', 'Entry_ID', 'Structure_interaction_list_ID'],
        'sourcePrimaryKeys': ['ID', 'Entry_ID', 'Structure_interaction_list_ID'],

            },

      'Observed_conformer': {

        'tags': {

          'Structure_interaction_ID': [None,returnStarInt,'Structure_interaction.ID',True],                   # Pointer to '_Structure_interaction.ID'
          'Conformer_family_coord_set_ID': [None,returnStarInt,'Conformer_family_coord_set.ID',True],         # Pointer to '_Conformer_family_coord_set.ID'
          'Atom_site_model_ID': [None,returnStarInt,'Atom_site.Model_ID',True],                               # Pointer to '_Atom_site.Model_ID'
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Structure_interaction_list_ID': [None,returnStarInt,'Structure_interaction_list.ID',True],         # Pointer to '_Structure_interaction_list.ID'

                },

        'tagNames': ['Structure_interaction_ID', 'Conformer_family_coord_set_ID', 'Atom_site_model_ID', 'Entry_ID', 'Structure_interaction_list_ID'],
        'sourcePrimaryKeys': ['Structure_interaction_ID', 'Conformer_family_coord_set_ID', 'Atom_site_model_ID', 'Entry_ID', 'Structure_interaction_list_ID'],

            }

        },

    'tableNames': ['Structure_interaction', 'Observed_conformer']

    },

  'other_struct_features': {

    'name': 'Other_struct_feature_list',

    'tags': {

      'Sf_category': ['other_struct_features',lambda x = value: returnStarCode(x,length = 31),None,True],     # Category definition for the information content of the saveframe
      'Sf_framecode': [None,lambda x = value: returnStarCode(x,length = 127),None,False],                     # A label for the saveframe that describes in very brief terms the information contained in the saveframe.
      'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                     # Pointer to '_Entry.ID'
      'ID': [None,returnStarInt,None,True],                                                                   # Unique identifier for the reported list of structure features.
      'Struct_feature_name': [None,lambda x = value: returnStarLine(x,length = 127),None,True],               # Author defined name for the reported structural feature.
      'Struct_feature_definition': [None,lambda x = value: returnStarLine(x,length = 127),None,False],        # Author provided definition for the reported structural feature.
      'Details': [None,returnStarString,None,False],                                                          # Text description providing additional information about the reported structure feature.
      'Selection_method': [None,returnStarString,None,False],                                                 # Method used to identify and define this structure element

            },

    'tagNames': ['Sf_category', 'Sf_framecode', 'Entry_ID', 'ID', 'Struct_feature_name', 'Struct_feature_definition', 'Details', 'Selection_method'],
    'sourcePrimaryKeys': ['Entry_ID', 'ID'],

    'tables': {

      'Other_struct_feature': {

        'tags': {

          'ID': [None,returnStarInt,None,True],                                                               # Unique identifier for the reported structure feature.
          'Entity_assembly_ID': [None,returnStarInt,'Entity_assembly.ID',True],                               # Pointer to '_Entity_assembly.ID'
          'Entity_ID': [None,returnStarInt,'Entity.ID',True],                                                 # Pointer to '_Entity.ID'
          'Seq_ID': [None,returnStarInt,'Entity_poly_seq.Num',True],                                          # Pointer to '_Entity_poly_seq.Num'
          'Auth_seq_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                   # An alternative identifier for Seq_id that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Seq_ID or Comp_index_ID.
          'Code': [None,lambda x = value: returnStarCode(x,length = 31),None,True],                           # Code used to define the type of structure feature.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Other_struct_feature_list_ID': [None,returnStarInt,'Other_struct_feature_list.ID',True],           # Pointer to '_Other_struct_feature_list.ID'

                },

        'tagNames': ['ID', 'Entity_assembly_ID', 'Entity_ID', 'Seq_ID', 'Auth_seq_ID', 'Code', 'Entry_ID', 'Other_struct_feature_list_ID'],
        'sourcePrimaryKeys': ['ID', 'Entry_ID', 'Other_struct_feature_list_ID'],

            }

        },

    'tableNames': ['Other_struct_feature']

    },

  'tensor': {

    'name': 'Tensor_list',

    'tags': {

      'Sf_category': ['tensor',lambda x = value: returnStarCode(x,length = 127),None,True],                   # Category definition for the information content of the saveframe
      'Sf_framecode': [None,lambda x = value: returnStarCode(x,length = 127),None,False],                     # A label for the saveframe that describes in very brief terms the information contained in the saveframe.
      'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                     # Pointer to '_Entry.ID'
      'ID': [None,returnStarInt,None,True],                                                                   # Unique identifier for the list of chemical shift tensors.
      'Tensor_type': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                      # ?
      'Tensor_shape': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                     # ?
      'Matrix_val_units': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                  # ?
      'Isotropic_val_type': [None,lambda x = value: returnStarLine(x,length = 127),None,False],               # ?
      'Angle_units': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                       # ?
      'Isotropic_val_formula': [None,lambda x = value: returnStarLine(x,length = 127),None,False],            # ?
      'Anisotropic_val_formula': [None,lambda x = value: returnStarLine(x,length = 127),None,False],          # ?
      'Rhombic_val_formula': [None,lambda x = value: returnStarLine(x,length = 127),None,False],              # ?
      'Euler_angle_type': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                 # ?
      'Data_file_name': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                   # Name of the file containing theoretical chemical shift data.
      'Details': [None,returnStarString,None,False],                                                          # Text providing additional information regarding the chemical shift tensor list and its derivation.

            },

    'tagNames': ['Sf_category', 'Sf_framecode', 'Entry_ID', 'ID', 'Tensor_type', 'Tensor_shape', 'Matrix_val_units', 'Isotropic_val_type', 'Angle_units', 'Isotropic_val_formula', 'Anisotropic_val_formula', 'Rhombic_val_formula', 'Euler_angle_type', 'Data_file_name', 'Details'],
    'sourcePrimaryKeys': ['Entry_ID', 'ID'],

    'tables': {

      'Tensor': {

        'tags': {

          'ID': [None,returnStarInt,None,True],                                                               # Unique identifier for the chemical shift tensor.
          'Interatomic_distance_list_ID': [None,returnStarInt,'Interatomic_dist.Interatomic_distance_list_ID',False],# Pointer to '_Interatomic_dist.Interatomic_distance_list_ID'
          'Interatomic_dist_set_ID': [None,returnStarInt,'Interatomic_dist.Set_ID',False],                    # Pointer to '_Interatomic_dist.Set_ID'
          'Calc_type_ID': [None,returnStarInt,'Chem_shifts_calc_type.ID',True],                               # Pointer to '_Chem_shifts_calc_type.ID'
          'Assembly_atom_ID': [None,returnStarInt,'Atom.Assembly_atom_ID',False],                             # Pointer to '_Atom.Assembly_atom_ID'
          'Entity_assembly_ID': [None,returnStarInt,'Entity_assembly.ID',True],                               # Pointer to '_Entity_assembly.ID'
          'Entity_ID': [None,returnStarInt,'Entity.ID',True],                                                 # Pointer to '_Entity.ID'
          'Comp_index_ID': [None,returnStarInt,'Entity_comp_index.ID',True],                                  # Pointer to '_Entity_comp_index.ID'
          'Seq_ID': [None,returnStarInt,'Entity_poly_seq.Num',False],                                         # Pointer to '_Entity_poly_seq.Num'
          'Comp_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Chem_comp.ID',True],              # Pointer to '_Chem_comp.ID'
          'Atom_ID': [None,lambda x = value: returnStarAtCode(x,length = 12),'Chem_comp_atom.Atom_ID',True],  # Pointer to '_Chem_comp_atom.Atom_ID'
          'Atom_type': [None,lambda x = value: returnStarCode(x,length = 15),None,True],                      # The value for this tag is a standard IUPAC abbreviation for an element (i.e.$ H$ C$ P$ etc).
          'Atom_isotope_number': [None,returnStarInt,None,False],                                             # The mass number for the chemical element defined by the tag '_Atom_type' or any of its related tags.
          'Axial_sym_axis_polar_angle': [None,returnStarInt,None,False],                                      # ?
          'Axial_sym_axis_aximuthal_angle': [None,returnStarFloat,None,False],                                # ?
          'Isotropic_val': [None,returnStarFloat,None,False],                                                 # ?
          'Anisotropic_val': [None,returnStarFloat,None,False],                                               # ?
          'Rhombic_val': [None,returnStarFloat,None,False],                                                   # ?
          'Euler_angle_alpha': [None,returnStarFloat,None,False],                                             # ?
          'Euler_angle_beta': [None,returnStarFloat,None,False],                                              # ?
          'Euler_angle_gamma': [None,returnStarFloat,None,False],                                             # ?
          'Isotropic_comp_1_1_val': [None,returnStarFloat,None,False],                                        # By the standard convention$ the value of the 1_1 element of the isotropic component of the chemical shielding tensor.
          'Isotropic_comp_2_2_val': [None,returnStarFloat,None,False],                                        # By the standard convention$ the value of the 2_2 element of the isotropic component of the chemical shielding tensor.
          'Isotropic_comp_3_3_val': [None,returnStarFloat,None,False],                                        # By the standard convention$ the value of the 3_3 element of the isotropic component of the chemical shielding tensor.
          'Anti_sym_comp_1_2_val': [None,returnStarFloat,None,False],                                         # The value for the 1_2 element of the anti-symmetric component of the chemical shielding tensor.
          'Anti_sym_comp_1_3_val': [None,returnStarFloat,None,False],                                         # The value for the 1_3 element of the anti-symmetric component of the chemical shielding tensor.
          'Anti_sym_comp_2_3_val': [None,returnStarFloat,None,False],                                         # The value for the 2_3 element of the anti-symmetric component of the chemical shielding tensor.
          'Sym_traceless_comp_1_1_val': [None,returnStarFloat,None,False],                                    # The value for the 1_1 element of the symmetric traceless component of the chemical shielding tensor.
          'Sym_traceless_comp_1_2_val': [None,returnStarFloat,None,False],                                    # The value for the 1_2 element of the symmetric traceless component of the chemical shielding tensor.
          'Sym_traceless_comp_1_3_val': [None,returnStarFloat,None,False],                                    # The value for the 1_3 element of the symmetric traceless component of the chemical shielding tensor.
          'Sym_traceless_comp_2_2_val': [None,returnStarFloat,None,False],                                    # The value for the 2_2 element of the symmetric traceless component of the chemical shielding tensor.
          'Sym_traceless_comp_2_3_val': [None,returnStarFloat,None,False],                                    # The value for the 2_3 element of the symmetric traceless component of the chemical shielding tensor.
          'Reduceable_matrix_1_1_val': [None,returnStarFloat,None,False],                                     # The value for the 1_1 element of the reduceable chemical shielding tensor.
          'Reduceable_matrix_1_2_val': [None,returnStarFloat,None,False],                                     # The value for the 1_2 element of the reduceable chemical shielding tensor.
          'Reduceable_matrix_1_3_val': [None,returnStarFloat,None,False],                                     # The value for the 1_3 element of the reduceable chemical shielding tensor.
          'Reduceable_matrix_2_1_val': [None,returnStarFloat,None,False],                                     # The value for the 2_1 element of the reduceable chemical shielding tensor.
          'Reduceable_matrix_2_2_val': [None,returnStarFloat,None,False],                                     # The value for the 2_2 element of the reduceable chemical shielding tensor.
          'Reduceable_matrix_2_3_val': [None,returnStarFloat,None,False],                                     # The value for the 2_3 element of the reduceable chemical shielding tensor.
          'Reduceable_matrix_3_1_val': [None,returnStarFloat,None,False],                                     # The value for the 3_1 element of the reduceable chemical shielding tensor.
          'Reduceable_matrix_3_2_val': [None,returnStarFloat,None,False],                                     # The value for the 3_2 element of the reduceable chemical shielding tensor.
          'Reduceable_matrix_3_3_val': [None,returnStarFloat,None,False],                                     # The value for the 3_3 element of the reduceable chemical shielding tensor.
          'Auth_entity_assembly_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],       # An alternative identifier for Entity_assembly_ID that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Entity_assembly_ID.
          'Auth_seq_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                   # An alternative identifier for Seq_id that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Seq_ID or Comp_index_ID.
          'Auth_comp_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                  # An alternative identifier for Comp_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Auth_atom_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                  # An alternative identifier for Atom_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Tensor_list_ID': [None,returnStarInt,'Tensor_list.ID',True],                                       # Pointer to '_Tensor_list.ID'

                },

        'tagNames': ['ID', 'Interatomic_distance_list_ID', 'Interatomic_dist_set_ID', 'Calc_type_ID', 'Assembly_atom_ID', 'Entity_assembly_ID', 'Entity_ID', 'Comp_index_ID', 'Seq_ID', 'Comp_ID', 'Atom_ID', 'Atom_type', 'Atom_isotope_number', 'Axial_sym_axis_polar_angle', 'Axial_sym_axis_aximuthal_angle', 'Isotropic_val', 'Anisotropic_val', 'Rhombic_val', 'Euler_angle_alpha', 'Euler_angle_beta', 'Euler_angle_gamma', 'Isotropic_comp_1_1_val', 'Isotropic_comp_2_2_val', 'Isotropic_comp_3_3_val', 'Anti_sym_comp_1_2_val', 'Anti_sym_comp_1_3_val', 'Anti_sym_comp_2_3_val', 'Sym_traceless_comp_1_1_val', 'Sym_traceless_comp_1_2_val', 'Sym_traceless_comp_1_3_val', 'Sym_traceless_comp_2_2_val', 'Sym_traceless_comp_2_3_val', 'Reduceable_matrix_1_1_val', 'Reduceable_matrix_1_2_val', 'Reduceable_matrix_1_3_val', 'Reduceable_matrix_2_1_val', 'Reduceable_matrix_2_2_val', 'Reduceable_matrix_2_3_val', 'Reduceable_matrix_3_1_val', 'Reduceable_matrix_3_2_val', 'Reduceable_matrix_3_3_val', 'Auth_entity_assembly_ID', 'Auth_seq_ID', 'Auth_comp_ID', 'Auth_atom_ID', 'Entry_ID', 'Tensor_list_ID'],
        'sourcePrimaryKeys': ['ID', 'Entry_ID', 'Tensor_list_ID'],

            }

        },

    'tableNames': ['Tensor']

    },

  'interatomic_distance': {

    'name': 'Interatomic_distance_list',

    'tags': {

      'Sf_category': ['interatomic_distance',lambda x = value: returnStarCode(x,length = 127),None,True],     # ?
      'Sf_framecode': [None,lambda x = value: returnStarCode(x,length = 127),None,False],                     # ?
      'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                     # Pointer to '_Entry.ID'
      'ID': [None,returnStarInt,None,True],                                                                   # ?
      'Details': [None,returnStarString,None,False],                                                          # ?
      'Text_data_format': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                 # ?
      'Text_data': [None,returnStarString,None,False],                                                        # ?

            },

    'tagNames': ['Sf_category', 'Sf_framecode', 'Entry_ID', 'ID', 'Details', 'Text_data_format', 'Text_data'],
    'sourcePrimaryKeys': ['Entry_ID', 'ID'],

    'tables': {

      'Interatomic_dist': {

        'tags': {

          'ID': [None,returnStarInt,None,True],                                                               # ?
          'Set_ID': [None,returnStarInt,None,True],                                                           # ?
          'Assembly_atom_ID_1': [None,returnStarInt,'Atom.Assembly_atom_ID',False],                           # Pointer to '_Atom.Assembly_atom_ID'
          'Entity_assembly_ID_1': [None,returnStarInt,'Entity_assembly.ID',True],                             # Pointer to '_Entity_assembly.ID'
          'Entity_ID_1': [None,returnStarInt,'Entity.ID',True],                                               # Pointer to '_Entity.ID'
          'Comp_index_ID_1': [None,returnStarInt,'Entity_comp_index.ID',True],                                # Pointer to '_Entity_comp_index.ID'
          'Seq_ID_1': [None,returnStarInt,'Entity_poly_seq.Num',False],                                       # Pointer to '_Entity_poly_seq.Num'
          'Comp_ID_1': [None,lambda x = value: returnStarCode(x,length = 12),'Chem_comp.ID',True],            # Pointer to '_Chem_comp.ID'
          'Atom_ID_1': [None,lambda x = value: returnStarAtCode(x,length = 12),'Chem_comp_atom.Atom_ID',True],# Pointer to '_Chem_comp_atom.Atom_ID'
          'Atom_type_1': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                   # The value for this tag is a standard IUPAC abbreviation for an element (i.e.$ H$ C$ P$ etc).
          'Assembly_atom_ID_2': [None,returnStarInt,'Atom.Assembly_atom_ID',False],                           # Pointer to '_Atom.Assembly_atom_ID'
          'Entity_assembly_ID_2': [None,returnStarInt,'Entity_assembly.ID',True],                             # Pointer to '_Entity_assembly.ID'
          'Entity_ID_2': [None,returnStarInt,'Entity.ID',True],                                               # Pointer to '_Entity.ID'
          'Comp_index_ID_2': [None,returnStarInt,'Entity_comp_index.ID',True],                                # Pointer to '_Entity_comp_index.ID'
          'Seq_ID_2': [None,returnStarInt,'Entity_poly_seq.Num',False],                                       # Pointer to '_Entity_poly_seq.Num'
          'Comp_ID_2': [None,lambda x = value: returnStarCode(x,length = 12),'Chem_comp.ID',True],            # Pointer to '_Chem_comp.ID'
          'Atom_ID_2': [None,lambda x = value: returnStarAtCode(x,length = 12),'Chem_comp_atom.Atom_ID',True],# Pointer to '_Chem_comp_atom.Atom_ID'
          'Atom_type_2': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                   # The value for this tag is a standard IUPAC abbreviation for an element (i.e.$ H$ C$ P$ etc).
          'Val': [None,returnStarFloat,None,True],                                                            # ?
          'Auth_asym_ID_1': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                # ?
          'Auth_entity_assembly_ID_1': [None,lambda x = value: returnStarCode(x,length = 15),None,False],     # ?
          'Auth_seq_ID_1': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                 # An alternative identifier for Seq_id that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Seq_ID or Comp_index_ID.
          'Auth_comp_ID_1': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                # An alternative identifier for Comp_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Auth_atom_ID_1': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                # An alternative identifier for Atom_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Auth_asym_ID_2': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                # ?
          'Auth_entity_assembly_ID_2': [None,lambda x = value: returnStarCode(x,length = 15),None,False],     # ?
          'Auth_seq_ID_2': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                 # An alternative identifier for Seq_id that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Seq_ID or Comp_index_ID.
          'Auth_comp_ID_2': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                # An alternative identifier for Comp_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Auth_atom_ID_2': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                # An alternative identifier for Atom_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Interatomic_distance_list_ID': [None,returnStarInt,'Interatomic_distance_list.ID',True],           # Pointer to '_Interatomic_distance_list.ID'

                },

        'tagNames': ['ID', 'Set_ID', 'Assembly_atom_ID_1', 'Entity_assembly_ID_1', 'Entity_ID_1', 'Comp_index_ID_1', 'Seq_ID_1', 'Comp_ID_1', 'Atom_ID_1', 'Atom_type_1', 'Assembly_atom_ID_2', 'Entity_assembly_ID_2', 'Entity_ID_2', 'Comp_index_ID_2', 'Seq_ID_2', 'Comp_ID_2', 'Atom_ID_2', 'Atom_type_2', 'Val', 'Auth_asym_ID_1', 'Auth_entity_assembly_ID_1', 'Auth_seq_ID_1', 'Auth_comp_ID_1', 'Auth_atom_ID_1', 'Auth_asym_ID_2', 'Auth_entity_assembly_ID_2', 'Auth_seq_ID_2', 'Auth_comp_ID_2', 'Auth_atom_ID_2', 'Entry_ID', 'Interatomic_distance_list_ID'],
        'sourcePrimaryKeys': ['ID', 'Entry_ID', 'Interatomic_distance_list_ID'],

            }

        },

    'tableNames': ['Interatomic_dist']

    },

  'general_distance_constraints': {

    'name': 'Gen_dist_constraint_list',

    'tags': {

      'Sf_category': ['general_distance_constraints',lambda x = value: returnStarCode(x,length = 31),None,True],# Category definition for the information content of the saveframe
      'Sf_framecode': [None,lambda x = value: returnStarCode(x,length = 127),None,False],                     # A label for the saveframe that describes in very brief terms the information contained in the saveframe.
      'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                     # Pointer to '_Entry.ID'
      'ID': [None,returnStarInt,None,True],                                                                   # Unique identifier for the list of reported distance constraints.
      'Data_file_name': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                   # Name of the uploaded file that contains the distance constraint data.
      'Constraint_type': [None,lambda x = value: returnStarLine(x,length = 127),None,True],                   # The type of reported distance constraint.
      'Constraint_file_ID': [None,returnStarInt,'Constraint_file.ID',False],                                  # Pointer to '_Constraint_file.ID'
      'Block_ID': [None,returnStarInt,'Constraint_file.Block_ID',False],                                      # Pointer to '_Constraint_file.Block_ID'
      'Details': [None,returnStarString,None,False],                                                          # Text description providing additional information about the reported distance constraints.
      'Text_data_format': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                 # The data format used to represent the order parameter data as ASCII text in the text block that is the value to the '_Gen_dist_constraint_list.Text_data' tag.
      'Text_data': [None,returnStarString,None,False],                                                        # A set of distance constraint data formatted as ASCII text.

            },

    'tagNames': ['Sf_category', 'Sf_framecode', 'Entry_ID', 'ID', 'Data_file_name', 'Constraint_type', 'Constraint_file_ID', 'Block_ID', 'Details', 'Text_data_format', 'Text_data'],
    'sourcePrimaryKeys': ['Entry_ID', 'ID'],

    'tables': {

      'Gen_dist_constraint_expt': {

        'tags': {

          'Experiment_ID': [None,returnStarInt,'Experiment.ID',True],                                         # Pointer to '_Experiment.ID'
          'Experiment_name': [None,lambda x = value: returnStarLine(x,length = 127),'Experiment.Name',False], # Pointer to a saveframe of the category 'NMR_spectrometer_expt'
          'Method_ID': [None,returnStarInt,'Method.ID',False],                                                # Pointer to '_Method.ID'
          'Method_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Method.Sf_framecode',False],# Pointer to a saveframe of the category 'method'
          'Sample_ID': [None,returnStarInt,'Sample.ID',True],                                                 # Pointer to '_Sample.ID'
          'Sample_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Sample.Sf_framecode',True],# Pointer to a saveframe of the category 'sample'.
          'Sample_state': [None,lambda x = value: returnStarLine(x,length = 31),None,True],                   # Physical state of the sample either anisotropic or isotropic.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Gen_dist_constraint_list_ID': [None,returnStarInt,'Gen_dist_constraint_list.ID',True],             # Pointer to '_Gen_dist_constraint_list.ID'

                },

        'tagNames': ['Experiment_ID', 'Experiment_name', 'Method_ID', 'Method_label', 'Sample_ID', 'Sample_label', 'Sample_state', 'Entry_ID', 'Gen_dist_constraint_list_ID'],
        'sourcePrimaryKeys': ['Experiment_ID', 'Sample_ID', 'Sample_state', 'Entry_ID', 'Gen_dist_constraint_list_ID'],

            },

      'Gen_dist_constraint_software': {

        'tags': {

          'Software_ID': [None,returnStarInt,'Software.ID',True],                                             # Pointer to '_Software.ID'
          'Software_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Software.Sf_framecode',True],# Pointer to a saveframe of the category 'software'
          'Method_ID': [None,returnStarInt,'Method.ID',False],                                                # Pointer to '_Method.ID'
          'Method_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Method.Sf_framecode',False],# Pointer to a saveframe of the category 'method'
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Gen_dist_constraint_list_ID': [None,returnStarInt,'Gen_dist_constraint_list.ID',True],             # Pointer to '_Gen_dist_constraint_list.ID'

                },

        'tagNames': ['Software_ID', 'Software_label', 'Method_ID', 'Method_label', 'Entry_ID', 'Gen_dist_constraint_list_ID'],
        'sourcePrimaryKeys': ['Software_ID', 'Entry_ID', 'Gen_dist_constraint_list_ID'],

            },

      'Gen_dist_constraint_software_param': {

        'tags': {

          'Software_ID': [None,returnStarInt,'Software.ID',True],                                             # Pointer to '_Software.ID'
          'Type': [None,lambda x = value: returnStarLine(x,length = 127),None,True],                          # A code or name for the parameter in the software package.
          'Value': [None,lambda x = value: returnStarCode(x,length = 31),None,False],                         # The value assigned to the software parameter$ if a single value is appropriate.
          'Range': [None,lambda x = value: returnStarCode(x,length = 31),None,False],                         # The value range assigned to the software parameter$ if range is appropriate.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Gen_dist_constraint_list_ID': [None,returnStarInt,'Gen_dist_constraint_list.ID',True],             # Pointer to '_Gen_dist_constraint_list.ID'

                },

        'tagNames': ['Software_ID', 'Type', 'Value', 'Range', 'Entry_ID', 'Gen_dist_constraint_list_ID'],
        'sourcePrimaryKeys': ['Software_ID', 'Type', 'Entry_ID', 'Gen_dist_constraint_list_ID'],

            },

      'Gen_dist_constraint': {

        'tags': {

          'ID': [None,returnStarInt,None,True],                                                               # Unique identifier for the reported distance constraint.
          'Member_ID': [None,returnStarInt,None,True],                                                        # Unique identifier for a member of a constraint defined by the value to the tag '_Gen_dist_constraint.ID'. For distance constraints with ambiguity that is related by a logical operator (or$ and$ etc.)$ the constraint will have two or more members.
          'Member_logic_code': [None,lambda x = value: returnStarCode(x,length = 3),None,False],              # Code that defines the logical relationship (or$ and$ etc.) between the set of distance constraint members. Every member of the constraint must be assigned a value.
          'Assembly_atom_ID_1': [None,returnStarInt,'Atom.Assembly_atom_ID',False],                           # Pointer to '_Atom.Assembly_atom_ID'
          'Entity_assembly_ID_1': [None,returnStarInt,'Entity_assembly.ID',True],                             # Pointer to '_Entity_assembly.ID'
          'Entity_ID_1': [None,returnStarInt,'Entity.ID',True],                                               # Pointer to '_Entity.ID'
          'Comp_index_ID_1': [None,returnStarInt,'Entity_comp_index.ID',True],                                # Pointer to '_Entity_comp_index.ID'
          'Seq_ID_1': [None,returnStarInt,'Entity_poly_seq.Num',True],                                        # Pointer to '_Entity_poly_seq.Num'
          'Comp_ID_1': [None,lambda x = value: returnStarCode(x,length = 12),'Chem_comp.ID',True],            # Pointer to '_Chem_comp.ID'
          'Atom_ID_1': [None,lambda x = value: returnStarAtCode(x,length = 12),'Chem_comp_atom.Atom_ID',True],# Pointer to '_Chem_comp_atom.Atom_ID'
          'Atom_type_1': [None,lambda x = value: returnStarCode(x,length = 15),None,True],                    # The value for this tag is a standard IUPAC abbreviation for an element (i.e.$ H$ C$ P$ etc).
          'Atom_isotope_number_1': [None,returnStarInt,None,False],                                           # The number of combined protons and neutrons for the chemical element defined by the tag '_Atom_type' or any of its related tags.
          'Resonance_ID_1': [None,returnStarInt,'Resonance.ID',False],                                        # Pointer to '_Resonance.ID'
          'Assembly_atom_ID_2': [None,returnStarInt,'Atom.Assembly_atom_ID',False],                           # Pointer to '_Atom.Assembly_atom_ID'
          'Entity_assembly_ID_2': [None,returnStarInt,'Entity_assembly.ID',True],                             # Pointer to '_Entity_assembly.ID'
          'Entity_ID_2': [None,returnStarInt,'Entity.ID',True],                                               # Pointer to '_Entity.ID'
          'Comp_index_ID_2': [None,returnStarInt,'Entity_comp_index.ID',True],                                # Pointer to '_Entity_comp_index.ID'
          'Seq_ID_2': [None,returnStarInt,'Entity_poly_seq.Num',True],                                        # Pointer to '_Entity_poly_seq.Num'
          'Comp_ID_2': [None,lambda x = value: returnStarCode(x,length = 12),'Chem_comp.ID',True],            # Pointer to '_Chem_comp.ID'
          'Atom_ID_2': [None,lambda x = value: returnStarAtCode(x,length = 12),'Chem_comp_atom.Atom_ID',True],# Pointer to '_Chem_comp_atom.Atom_ID'
          'Atom_type_2': [None,lambda x = value: returnStarCode(x,length = 15),None,True],                    # The value for this tag is a standard IUPAC abbreviation for an element (i.e.$ H$ C$ P$ etc).
          'Atom_isotope_number_2': [None,returnStarInt,None,False],                                           # The number of combined protons and neutrons for the chemical element defined by the tag '_Atom_type' or any of its related tags.
          'Resonance_ID_2': [None,returnStarInt,'Resonance.ID',False],                                        # Pointer to '_Resonance.ID'
          'Intensity_val': [None,returnStarFloat,None,False],                                                 # Intensity val
          'Intensity_lower_val_err': [None,returnStarFloat,None,False],                                       # Intensity lower val err
          'Intensity_upper_val_err': [None,returnStarFloat,None,False],                                       # Intensity upper val err
          'Distance_val': [None,returnStarFloat,None,False],                                                  # A single value assigned to the distance constraint.
          'Distance_lower_bound_val': [None,returnStarFloat,None,False],                                      # The value of the lower bound for the distance constraint.
          'Distance_upper_bound_val': [None,returnStarFloat,None,False],                                      # The value of the upper bound for the distance constraint.
          'Contribution_fractional_val': [None,returnStarFloat,None,False],                                   # Fractional contribution of the constraint
          'Spectral_peak_ID': [None,returnStarInt,'Peak.ID',False],                                           # Pointer to '_Peak.ID'
          'Spectral_peak_list_ID': [None,returnStarInt,'Spectral_peak_list.ID',False],                        # Pointer to '_Spectral_peak_list.ID'
          'PDB_record_ID_1': [None,lambda x = value: returnStarCode(x,length = 15),None,False],               # The value is an integer that identifies a record in the atom_site list. This is a place holder for the atom record number extracted from a PDB formatted file.
          'PDB_model_num_1': [None,returnStarInt,None,False],                                                 # PDB model number.
          'PDB_strand_ID_1': [None,lambda x = value: returnStarCode(x,length = 15),None,False],               # PDB strand id.
          'PDB_ins_code_1': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                # PDB insertion code.
          'PDB_residue_no_1': [None,lambda x = value: returnStarCode(x,length = 15),None,False],              # PDB residue number.
          'PDB_residue_name_1': [None,lambda x = value: returnStarCode(x,length = 15),None,False],            # PDB residue name.
          'PDB_atom_name_1': [None,lambda x = value: returnStarCode(x,length = 15),None,False],               # PDB atom name.
          'PDB_record_ID_2': [None,lambda x = value: returnStarCode(x,length = 15),None,False],               # The value is an integer that identifies a record in the atom_site list. This is a place holder for the atom record number extracted from a PDB formatted file.
          'PDB_model_num_2': [None,returnStarInt,None,False],                                                 # PDB model number.
          'PDB_strand_ID_2': [None,lambda x = value: returnStarCode(x,length = 15),None,False],               # PDB strand id.
          'PDB_ins_code_2': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                # PDB insertion code.
          'PDB_residue_no_2': [None,lambda x = value: returnStarCode(x,length = 15),None,False],              # PDB residue number.
          'PDB_residue_name_2': [None,lambda x = value: returnStarCode(x,length = 15),None,False],            # PDB residue name.
          'PDB_atom_name_2': [None,lambda x = value: returnStarCode(x,length = 15),None,False],               # PDB atom name.
          'Auth_entity_assembly_ID_1': [None,returnStarInt,None,False],                                       # An alternative identifier for Entity_assembly_id that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number.
          'Auth_asym_ID_1': [None,lambda x = value: returnStarCode(x,length = 12),None,False],                # An alternative identifier for Asym_id that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Asym_ID. This item is provided as a place holder for information extracted from distance constraint files generated by various software applications.
          'Auth_chain_ID_1': [None,lambda x = value: returnStarCode(x,length = 15),None,False],               # Author assigned chain ID
          'Auth_seq_ID_1': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                 # An alternative identifier for Seq_id that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Seq_ID or Comp_index_ID.
          'Auth_comp_ID_1': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                # An alternative identifier for Comp_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Auth_atom_ID_1': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                # An alternative identifier for Atom_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Auth_alt_ID_1': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                 # Author's alternate location identifier.
          'Auth_atom_name_1': [None,lambda x = value: returnStarAtCode(x,length = 12),None,False],            # Author's atom name.
          'Auth_entity_assembly_ID_2': [None,returnStarInt,None,False],                                       # An alternative identifier for Entity_assembly_id that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number.
          'Auth_asym_ID_2': [None,lambda x = value: returnStarCode(x,length = 12),None,False],                # An alternative identifier for Asym_id that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Asym_ID. This item is provided as a place holder for information extracted from distance constraint files generated by various software applications.
          'Auth_chain_ID_2': [None,lambda x = value: returnStarCode(x,length = 15),None,False],               # Author assigned chain ID
          'Auth_seq_ID_2': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                 # An alternative identifier for Seq_id that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Seq_ID or Comp_index_ID.
          'Auth_comp_ID_2': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                # An alternative identifier for Comp_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Auth_atom_ID_2': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                # An alternative identifier for Atom_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Auth_alt_ID_2': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                 # Author's alternate location identifier.
          'Auth_atom_name_2': [None,lambda x = value: returnStarAtCode(x,length = 12),None,False],            # Author's atom name.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Gen_dist_constraint_list_ID': [None,returnStarInt,'Gen_dist_constraint_list.ID',True],             # Pointer to '_Gen_dist_constraint_list.ID'

                },

        'tagNames': ['ID', 'Member_ID', 'Member_logic_code', 'Assembly_atom_ID_1', 'Entity_assembly_ID_1', 'Entity_ID_1', 'Comp_index_ID_1', 'Seq_ID_1', 'Comp_ID_1', 'Atom_ID_1', 'Atom_type_1', 'Atom_isotope_number_1', 'Resonance_ID_1', 'Assembly_atom_ID_2', 'Entity_assembly_ID_2', 'Entity_ID_2', 'Comp_index_ID_2', 'Seq_ID_2', 'Comp_ID_2', 'Atom_ID_2', 'Atom_type_2', 'Atom_isotope_number_2', 'Resonance_ID_2', 'Intensity_val', 'Intensity_lower_val_err', 'Intensity_upper_val_err', 'Distance_val', 'Distance_lower_bound_val', 'Distance_upper_bound_val', 'Contribution_fractional_val', 'Spectral_peak_ID', 'Spectral_peak_list_ID', 'PDB_record_ID_1', 'PDB_model_num_1', 'PDB_strand_ID_1', 'PDB_ins_code_1', 'PDB_residue_no_1', 'PDB_residue_name_1', 'PDB_atom_name_1', 'PDB_record_ID_2', 'PDB_model_num_2', 'PDB_strand_ID_2', 'PDB_ins_code_2', 'PDB_residue_no_2', 'PDB_residue_name_2', 'PDB_atom_name_2', 'Auth_entity_assembly_ID_1', 'Auth_asym_ID_1', 'Auth_chain_ID_1', 'Auth_seq_ID_1', 'Auth_comp_ID_1', 'Auth_atom_ID_1', 'Auth_alt_ID_1', 'Auth_atom_name_1', 'Auth_entity_assembly_ID_2', 'Auth_asym_ID_2', 'Auth_chain_ID_2', 'Auth_seq_ID_2', 'Auth_comp_ID_2', 'Auth_atom_ID_2', 'Auth_alt_ID_2', 'Auth_atom_name_2', 'Entry_ID', 'Gen_dist_constraint_list_ID'],
        'sourcePrimaryKeys': ['ID', 'Member_ID', 'Entry_ID', 'Gen_dist_constraint_list_ID'],

            },

      'Gen_dist_constraint_comment_org': {

        'tags': {

          'ID': [None,returnStarInt,None,True],                                                               # An integer value that uniquely identifies the comment extracted from the distance constraint file.
          'Comment_text': [None,returnStarString,None,True],                                                  # The text of the comment parsed from the distance constraint file.
          'Comment_begin_line': [None,returnStarInt,None,False],                                              # The line in the distance constraint file where the comment begins.
          'Comment_begin_column': [None,returnStarInt,None,False],                                            # The column in the distance constraint file where the comment begins.
          'Comment_end_line': [None,returnStarInt,None,False],                                                # The line in the distance constraint file where the comment ends.
          'Comment_end_column': [None,returnStarInt,None,False],                                              # The column in the distance constraint file where the comment ends.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Gen_dist_constraint_list_ID': [None,returnStarInt,'Gen_dist_constraint_list.ID',True],             # Pointer to '_Gen_dist_constraint_list.ID'

                },

        'tagNames': ['ID', 'Comment_text', 'Comment_begin_line', 'Comment_begin_column', 'Comment_end_line', 'Comment_end_column', 'Entry_ID', 'Gen_dist_constraint_list_ID'],
        'sourcePrimaryKeys': ['ID', 'Entry_ID', 'Gen_dist_constraint_list_ID'],

            },

      'Gen_dist_constraint_parse_err': {

        'tags': {

          'ID': [None,returnStarInt,None,True],                                                               # An integer value that uniquely identifies the error that occurred in parsing the distance constaint file.
          'Content': [None,returnStarString,None,True],                                                       # The text content of the parse error.
          'Begin_line': [None,returnStarInt,None,False],                                                      # The line in the distance constraint file where the parse error began.
          'Begin_column': [None,returnStarInt,None,False],                                                    # The column in the distance constraint file where the parse error began.
          'End_line': [None,returnStarInt,None,False],                                                        # The line in the distance constraint file where the parse error ended.
          'End_column': [None,returnStarInt,None,False],                                                      # The column in the distance constraint file where the parse error ended.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Gen_dist_constraint_list_ID': [None,returnStarInt,'Gen_dist_constraint_list.ID',True],             # Pointer to '_Gen_dist_constraint_list.ID'

                },

        'tagNames': ['ID', 'Content', 'Begin_line', 'Begin_column', 'End_line', 'End_column', 'Entry_ID', 'Gen_dist_constraint_list_ID'],
        'sourcePrimaryKeys': ['ID', 'Entry_ID', 'Gen_dist_constraint_list_ID'],

            },

      'Gen_dist_constraint_parse_file': {

        'tags': {

          'ID': [None,returnStarInt,None,True],                                                               # An integer that uniquely defines the file from other files in the list.
          'Name': [None,lambda x = value: returnStarLine(x,length = 31),None,True],                           # Name of the file from which the distance constraints were parsed.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Gen_dist_constraint_list_ID': [None,returnStarInt,'Gen_dist_constraint_list.ID',True],             # Pointer to '_Gen_dist_constraint_list.ID'

                },

        'tagNames': ['ID', 'Name', 'Entry_ID', 'Gen_dist_constraint_list_ID'],
        'sourcePrimaryKeys': ['ID', 'Entry_ID', 'Gen_dist_constraint_list_ID'],

            },

      'Gen_dist_constraint_conv_err': {

        'tags': {

          'ID': [None,returnStarInt,None,True],                                                               # An integer value that uniquely identifies the conversion error.
          'Gen_dist_constraint_parse_file_ID': [None,returnStarInt,'Gen_dist_constraint_parse_file.ID',True], # Pointer to '_Gen_dist_constraint_parse_file.ID'
          'Parse_file_constraint_ID': [None,returnStarInt,None,True],                                         # Identifier for the constraint in the parse file that produced a conversion error.
          'Conv_error_type': [None,lambda x = value: returnStarLine(x,length = 31),None,True],                # Type of constraint conversion error.
          'Conv_error_note': [None,returnStarString,None,False],                                              # Text providing additional information regarding a converion error.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Gen_dist_constraint_list_ID': [None,returnStarInt,'Gen_dist_constraint_list.ID',True],             # Pointer to '_Gen_dist_constraint_list.ID'

                },

        'tagNames': ['ID', 'Gen_dist_constraint_parse_file_ID', 'Parse_file_constraint_ID', 'Conv_error_type', 'Conv_error_note', 'Entry_ID', 'Gen_dist_constraint_list_ID'],
        'sourcePrimaryKeys': ['ID', 'Entry_ID', 'Gen_dist_constraint_list_ID'],

            }

        },

    'tableNames': ['Gen_dist_constraint_expt', 'Gen_dist_constraint_software', 'Gen_dist_constraint_software_param', 'Gen_dist_constraint', 'Gen_dist_constraint_comment_org', 'Gen_dist_constraint_parse_err', 'Gen_dist_constraint_parse_file', 'Gen_dist_constraint_conv_err']

    },

  'distance_constraints': {

    'name': 'Distance_constraint_list',

    'tags': {

      'Sf_category': ['distance_constraints',lambda x = value: returnStarCode(x,length = 31),None,True],      # Category definition for the information content of the saveframe
      'Sf_framecode': [None,lambda x = value: returnStarCode(x,length = 127),None,False],                     # A label for the saveframe that describes in very brief terms the information contained in the saveframe.
      'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                     # Pointer to '_Entry.ID'
      'ID': [None,returnStarInt,None,True],                                                                   # Unique identifier for the list of reported distance constraints.
      'Data_file_name': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                   # Name of the uploaded file that contains the distance constraint data.
      'Constraint_type': [None,lambda x = value: returnStarLine(x,length = 127),None,True],                   # The type of reported distance constraint.
      'Constraint_file_ID': [None,returnStarInt,'Constraint_file.ID',False],                                  # Pointer to '_Constraint_file.ID'
      'Block_ID': [None,returnStarInt,'Constraint_file.Block_ID',False],                                      # Pointer to '_Constraint_file.Block_ID'
      'Details': [None,returnStarString,None,False],                                                          # Text description providing additional information about the reported distance constraints.
      'Text_data_format': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                 # The data format used to represent the order parameter data as ASCII text in the text block that is the value to the '_Distance_constraint_list.Text_data' tag.
      'Text_data': [None,returnStarString,None,False],                                                        # A set of order parameter data formatted as ASCII text.

            },

    'tagNames': ['Sf_category', 'Sf_framecode', 'Entry_ID', 'ID', 'Data_file_name', 'Constraint_type', 'Constraint_file_ID', 'Block_ID', 'Details', 'Text_data_format', 'Text_data'],
    'sourcePrimaryKeys': ['Entry_ID', 'ID'],

    'tables': {

      'Distance_constraint_expt': {

        'tags': {

          'Experiment_ID': [None,returnStarInt,'Experiment.ID',True],                                         # Pointer to '_Experiment.ID'
          'Experiment_name': [None,lambda x = value: returnStarLine(x,length = 127),'Experiment.Name',False], # Pointer to a saveframe of the category 'NMR_spectrometer_expt'
          'Method_ID': [None,returnStarInt,'Method.ID',False],                                                # Pointer to '_Method.ID'
          'Method_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Method.Sf_framecode',False],# Pointer to a saveframe of the category 'method'
          'Sample_ID': [None,returnStarInt,'Sample.ID',True],                                                 # Pointer to '_Sample.ID'
          'Sample_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Sample.Sf_framecode',True],# Sample(s) used in deriving the data
          'Sample_state': [None,lambda x = value: returnStarLine(x,length = 31),None,True],                   # Physical state of the sample either anisotropic or isotropic.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Distance_constraint_list_ID': [None,returnStarInt,'Distance_constraint_list.ID',True],             # Pointer to '_Distance_constraint_list.ID'

                },

        'tagNames': ['Experiment_ID', 'Experiment_name', 'Method_ID', 'Method_label', 'Sample_ID', 'Sample_label', 'Sample_state', 'Entry_ID', 'Distance_constraint_list_ID'],
        'sourcePrimaryKeys': ['Experiment_ID', 'Sample_ID', 'Sample_state', 'Entry_ID', 'Distance_constraint_list_ID'],

            },

      'Distance_constraint_software': {

        'tags': {

          'Software_ID': [None,returnStarInt,'Software.ID',True],                                             # Pointer to '_Software.ID'
          'Software_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Software.Sf_framecode',True],# Pointer to a saveframe of the category 'software'
          'Method_ID': [None,returnStarInt,'Method.ID',False],                                                # Pointer to '_Method.ID'
          'Method_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Method.Sf_framecode',False],# Pointer to a saveframe of the category 'method'
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Distance_constraint_list_ID': [None,returnStarInt,'Distance_constraint_list.ID',True],             # Pointer to '_Distance_constraint_list.ID'

                },

        'tagNames': ['Software_ID', 'Software_label', 'Method_ID', 'Method_label', 'Entry_ID', 'Distance_constraint_list_ID'],
        'sourcePrimaryKeys': ['Software_ID', 'Entry_ID', 'Distance_constraint_list_ID'],

            },

      'Dist_constr_software_setting': {

        'tags': {

          'Software_ID': [None,returnStarInt,'Software.ID',True],                                             # Pointer to '_Software.ID'
          'Type': [None,lambda x = value: returnStarLine(x,length = 127),None,True],                          # A code or name for the parameter in the software package.
          'Value': [None,lambda x = value: returnStarCode(x,length = 31),None,False],                         # The value assigned to the software parameter$ if a single value is appropriate.
          'Range': [None,lambda x = value: returnStarCode(x,length = 31),None,False],                         # The value range assigned to the software parameter$ if range is appropriate.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Distance_constraint_list_ID': [None,returnStarInt,'Distance_constraint_list.ID',True],             # Pointer to '_Distance_constraint_list.ID'

                },

        'tagNames': ['Software_ID', 'Type', 'Value', 'Range', 'Entry_ID', 'Distance_constraint_list_ID'],
        'sourcePrimaryKeys': ['Software_ID', 'Type', 'Entry_ID', 'Distance_constraint_list_ID'],

            },

      'Dist_constraint_tree': {

        'tags': {

          'Constraint_ID': [None,returnStarInt,None,True],                                                    # Unique identifier for the constraint in the list of constraints contained in one save frame.
          'Node_ID': [None,returnStarInt,None,True],                                                          # Nodes with logic only do not need to be listed here. Combined atoms into pseudo atoms (e.g. LEU QG for all 6 protons) is preferred to keep this loop limited.
          'Down_node_ID': [None,returnStarInt,None,False],                                                    # ID of first sibling down. 0 means no node below.
          'Right_node_ID': [None,returnStarInt,None,False],                                                   # ID of another sibling to the right. 0 means no node to the right.
          'Logic_operation': [None,lambda x = value: returnStarCode(x,length = 15),None,False],               # Name can be given here$ and the function in _Function_detail means  the node does not have logic information.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Distance_constraint_list_ID': [None,returnStarInt,'Distance_constraint_list.ID',True],             # Pointer to '_Distance_constraint_list.ID'

                },

        'tagNames': ['Constraint_ID', 'Node_ID', 'Down_node_ID', 'Right_node_ID', 'Logic_operation', 'Entry_ID', 'Distance_constraint_list_ID'],
        'sourcePrimaryKeys': ['Constraint_ID', 'Node_ID', 'Entry_ID', 'Distance_constraint_list_ID'],

            },

      'Dist_constraint': {

        'tags': {

          'Tree_node_member_constraint_ID': [None,returnStarInt,'Dist_constraint_tree.Constraint_ID',True],   # Pointer to '_Dist_constraint_tree.Constraint_ID'
          'Tree_node_member_node_ID': [None,returnStarInt,'Dist_constraint_tree.Node_ID',True],               # Pointer to '_Dist_constraint_tree.Node_ID'
          'Contribution_fractional_val': [None,returnStarFloat,None,False],                                   # Fractional contribution of the constraint
          'Constraint_tree_node_member_ID': [None,returnStarInt,None,True],                                   # Unique identifier for a member of the constraint node
          'Assembly_atom_ID': [None,returnStarInt,'Atom.Assembly_atom_ID',False],                             # Pointer to '_Atom.Assembly_atom_ID'
          'Entity_assembly_ID': [None,returnStarInt,'Entity_assembly.ID',True],                               # Pointer to '_Entity_assembly.ID'
          'Entity_ID': [None,returnStarInt,'Entity.ID',True],                                                 # Pointer to '_Entity.ID'
          'Comp_index_ID': [None,returnStarInt,'Entity_comp_index.ID',True],                                  # Pointer to '_Entity_comp_index.ID'
          'Seq_ID': [None,returnStarInt,'Entity_poly_seq.Num',True],                                          # Pointer to '_Entity_poly_seq.Num'
          'Comp_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Chem_comp.ID',True],              # Pointer to '_Chem_comp.ID'
          'Atom_ID': [None,lambda x = value: returnStarAtCode(x,length = 12),'Chem_comp_atom.Atom_ID',True],  # Pointer to '_Chem_comp_atom.Atom_ID'
          'Atom_type': [None,lambda x = value: returnStarCode(x,length = 15),None,True],                      # The value for this tag is a standard IUPAC abbreviation for an element (i.e.$ H$ C$ P$ etc).
          'Atom_isotope_number': [None,returnStarInt,None,False],                                             # The mass number for the chemical element defined by the tag '_Atom_type' or any of its related tags.
          'Resonance_ID': [None,returnStarInt,'Resonance.ID',False],                                          # Pointer to '_Resonance.ID'
          'Auth_asym_ID': [None,lambda x = value: returnStarCode(x,length = 12),None,False],                  # An alternative identifier for Asym_id that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Asym_ID. This item is provided as a place holder for information extracted from distance constraint files generated by various software applications.
          'Auth_entity_assembly_ID': [None,returnStarInt,None,False],                                         # An alternative identifier for Entity_assembly_id that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number.
          'Auth_seq_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                   # An alternative identifier for Seq_id that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Seq_ID or Comp_index_ID.
          'Auth_comp_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                  # An alternative identifier for Comp_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Auth_atom_ID': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                  # An alternative identifier for Atom_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Distance_constraint_list_ID': [None,returnStarInt,'Distance_constraint_list.ID',True],             # Pointer to '_Distance_constraint_list.ID'

                },

        'tagNames': ['Tree_node_member_constraint_ID', 'Tree_node_member_node_ID', 'Contribution_fractional_val', 'Constraint_tree_node_member_ID', 'Assembly_atom_ID', 'Entity_assembly_ID', 'Entity_ID', 'Comp_index_ID', 'Seq_ID', 'Comp_ID', 'Atom_ID', 'Atom_type', 'Atom_isotope_number', 'Resonance_ID', 'Auth_asym_ID', 'Auth_entity_assembly_ID', 'Auth_seq_ID', 'Auth_comp_ID', 'Auth_atom_ID', 'Entry_ID', 'Distance_constraint_list_ID'],
        'sourcePrimaryKeys': ['Tree_node_member_constraint_ID', 'Tree_node_member_node_ID', 'Entry_ID', 'Distance_constraint_list_ID'],

            },

      'Dist_constraint_value': {

        'tags': {

          'Constraint_ID': [None,returnStarInt,'Dist_constraint_tree.Constraint_ID',True],                    # Pointer to '_Dist_constraint_tree.Constraint_ID'
          'Tree_node_ID': [None,returnStarInt,'Dist_constraint_tree.Node_ID',True],                           # Pointer to '_Dist_constraint_tree.Node_ID'
          'Source_experiment_ID': [None,returnStarInt,'Experiment.ID',False],                                 # Pointer to '_Experiment.ID'.  This value links the reported constraint to the experiment used to derive the data used to define the constraint.
          'Spectral_peak_ID': [None,returnStarInt,'Peak.ID',False],                                           # Pointer to '_Peak.ID'
          'Spectral_peak_list_ID': [None,returnStarInt,'Spectral_peak_list.ID',False],                        # Pointer to '_Spectral_peak_list.ID'
          'Intensity_val': [None,returnStarFloat,None,False],                                                 # Intensity val
          'Intensity_lower_val_err': [None,returnStarFloat,None,False],                                       # Intensity lower val err
          'Intensity_upper_val_err': [None,returnStarFloat,None,False],                                       # Intensity upper val err
          'Distance_val': [None,returnStarFloat,None,False],                                                  # A single value assigned to the distance constraint.
          'Distance_lower_bound_val': [None,returnStarFloat,None,False],                                      # The value of the lower bound for the distance constraint.
          'Distance_upper_bound_val': [None,returnStarFloat,None,False],                                      # The value of the upper bound for the distance constraint.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Distance_constraint_list_ID': [None,returnStarInt,'Distance_constraint_list.ID',True],             # Pointer to '_Distance_constraint_list.ID'

                },

        'tagNames': ['Constraint_ID', 'Tree_node_ID', 'Source_experiment_ID', 'Spectral_peak_ID', 'Spectral_peak_list_ID', 'Intensity_val', 'Intensity_lower_val_err', 'Intensity_upper_val_err', 'Distance_val', 'Distance_lower_bound_val', 'Distance_upper_bound_val', 'Entry_ID', 'Distance_constraint_list_ID'],
        'sourcePrimaryKeys': ['Constraint_ID', 'Tree_node_ID', 'Entry_ID', 'Distance_constraint_list_ID'],

            },

      'Dist_constraint_comment_org': {

        'tags': {

          'ID': [None,returnStarInt,None,True],                                                               # An integer value that uniquely identifies the comment extracted from the distance constraint file.
          'Comment_text': [None,returnStarString,None,True],                                                  # The text of the comment parsed from the distance constraint file.
          'Comment_begin_line': [None,returnStarInt,None,False],                                              # The line in the distance constraint file where the comment begins.
          'Comment_begin_column': [None,returnStarInt,None,False],                                            # The column in the distance constraint file where the comment begins.
          'Comment_end_line': [None,returnStarInt,None,False],                                                # The line in the distance constraint file where the comment ends.
          'Comment_end_column': [None,returnStarInt,None,False],                                              # The column in the distance constraint file where the comment ends.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Distance_constraint_list_ID': [None,returnStarInt,'Distance_constraint_list.ID',True],             # Pointer to '_Distance_constraint_list.ID'

                },

        'tagNames': ['ID', 'Comment_text', 'Comment_begin_line', 'Comment_begin_column', 'Comment_end_line', 'Comment_end_column', 'Entry_ID', 'Distance_constraint_list_ID'],
        'sourcePrimaryKeys': ['ID', 'Entry_ID', 'Distance_constraint_list_ID'],

            },

      'Dist_constraint_parse_err': {

        'tags': {

          'ID': [None,returnStarInt,None,True],                                                               # An integer value that uniquely identifies the error that occurred in parsing the distance constaint file.
          'Content': [None,returnStarString,None,True],                                                       # The text content of the parse error.
          'Begin_line': [None,returnStarInt,None,False],                                                      # The line in the distance constraint file where the parse error began.
          'Begin_column': [None,returnStarInt,None,False],                                                    # The column in the distance constraint file where the parse error began.
          'End_line': [None,returnStarInt,None,False],                                                        # The line in the distance constraint file where the parse error ended.
          'End_column': [None,returnStarInt,None,False],                                                      # The column in the distance constraint file where the parse error ended.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Distance_constraint_list_ID': [None,returnStarInt,'Distance_constraint_list.ID',True],             # Pointer to '_Distance_constraint_list.ID'

                },

        'tagNames': ['ID', 'Content', 'Begin_line', 'Begin_column', 'End_line', 'End_column', 'Entry_ID', 'Distance_constraint_list_ID'],
        'sourcePrimaryKeys': ['ID', 'Entry_ID', 'Distance_constraint_list_ID'],

            },

      'Dist_constraint_parse_file': {

        'tags': {

          'ID': [None,returnStarInt,None,True],                                                               # An integer that uniquely defines the file from other files in the list.
          'Name': [None,lambda x = value: returnStarLine(x,length = 31),None,True],                           # Name of the file from which the distance constraints were parsed.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Distance_constraint_list_ID': [None,returnStarInt,'Distance_constraint_list.ID',True],             # Pointer to '_Distance_constraint_list.ID'

                },

        'tagNames': ['ID', 'Name', 'Entry_ID', 'Distance_constraint_list_ID'],
        'sourcePrimaryKeys': ['ID', 'Entry_ID', 'Distance_constraint_list_ID'],

            },

      'Dist_constraint_conv_err': {

        'tags': {

          'ID': [None,returnStarInt,None,True],                                                               # An integer value that uniquely identifies the conversion error.
          'Dist_constraint_parse_file_ID': [None,returnStarInt,'Dist_constraint_parse_file.ID',True],         # Pointer to '_Dist_constraint_parse_file.ID'
          'Parse_file_constraint_ID': [None,returnStarInt,None,True],                                         # Identifier for the constraint in the parse file that produced a conversion error.
          'Conv_error_type': [None,lambda x = value: returnStarLine(x,length = 31),None,True],                # Type of constraint conversion error.
          'Conv_error_note': [None,returnStarString,None,False],                                              # Text providing additional information regarding a converion error.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Distance_constraint_list_ID': [None,returnStarInt,'Distance_constraint_list.ID',True],             # Pointer to '_Distance_constraint_list.ID'

                },

        'tagNames': ['ID', 'Dist_constraint_parse_file_ID', 'Parse_file_constraint_ID', 'Conv_error_type', 'Conv_error_note', 'Entry_ID', 'Distance_constraint_list_ID'],
        'sourcePrimaryKeys': ['ID', 'Entry_ID', 'Distance_constraint_list_ID'],

            }

        },

    'tableNames': ['Distance_constraint_expt', 'Distance_constraint_software', 'Dist_constr_software_setting', 'Dist_constraint_tree', 'Dist_constraint', 'Dist_constraint_value', 'Dist_constraint_comment_org', 'Dist_constraint_parse_err', 'Dist_constraint_parse_file', 'Dist_constraint_conv_err']

    },

  'floating_chiral_stereo_assign': {

    'name': 'Floating_chirality_assign',

    'tags': {

      'Sf_category': ['floating_chiral_stereo_assign',lambda x = value: returnStarCode(x,length = 31),None,True],# Category definition for the information content of the saveframe
      'Sf_framecode': [None,lambda x = value: returnStarCode(x,length = 127),None,False],                     # A label for the saveframe that describes in very brief terms the information contained in the saveframe.
      'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                     # Pointer to '_Entry.ID'
      'ID': [None,returnStarInt,None,True],                                                                   # Unique identifier for the reported list of floating chirality stereoassignments.
      'Data_file_name': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                   # Name of the file that contains the definitions for the floating chirality assignments.
      'Details': [None,returnStarString,None,False],                                                          # Text description providing additional information about the reported floating chirality data.
      'Stereo_count': [None,returnStarInt,None,True],                                                         # Total number of stereo groups in the molecular assembly..
      'Stereo_assigned_count': [None,returnStarInt,None,True],                                                # Total number of assigned stereo groups in the molecular assembly.

            },

    'tagNames': ['Sf_category', 'Sf_framecode', 'Entry_ID', 'ID', 'Data_file_name', 'Details', 'Stereo_count', 'Stereo_assigned_count'],
    'sourcePrimaryKeys': ['Entry_ID', 'ID'],

    'tables': {

      'Floating_chirality_software': {

        'tags': {

          'Software_ID': [None,returnStarInt,'Software.ID',True],                                             # Pointer to '_Software.ID'
          'Software_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Software.Sf_framecode',True],# Pointer to a saveframe of the category 'software'
          'Method_ID': [None,returnStarInt,'Method.ID',False],                                                # Pointer to '_Method.ID'
          'Method_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Method.Sf_framecode',False],# Pointer to a saveframe of the category 'method'
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Floating_chirality_assign_ID': [None,returnStarInt,'Floating_chirality_assign.ID',True],           # Pointer to '_Floating_chirality_assign.ID'

                },

        'tagNames': ['Software_ID', 'Software_label', 'Method_ID', 'Method_label', 'Entry_ID', 'Floating_chirality_assign_ID'],
        'sourcePrimaryKeys': ['Software_ID', 'Entry_ID', 'Floating_chirality_assign_ID'],

            },

      'Floating_chirality': {

        'tags': {

          'ID': [None,returnStarInt,None,True],                                                               # Unique identifier for the reported floating chirality stereoassignment.
          'Assembly_atom_ID_1': [None,returnStarInt,'Atom.Assembly_atom_ID',False],                           # Pointer to '_Atom.Assembly_atom_ID'
          'Entity_assembly_ID_1': [None,returnStarInt,'Entity_assembly.ID',True],                             # Pointer to '_Entity_assembly.ID'
          'Entity_ID_1': [None,returnStarInt,'Entity.ID',True],                                               # Pointer to '_Entity.ID'
          'Comp_index_ID_1': [None,returnStarInt,'Entity_comp_index.ID',True],                                # Pointer to '_Entity_comp_index.ID'
          'Seq_ID_1': [None,returnStarInt,'Entity_poly_seq.Num',True],                                        # Pointer to '_Entity_poly_seq.Num'
          'Comp_ID_1': [None,lambda x = value: returnStarCode(x,length = 12),'Chem_comp.ID',True],            # Pointer to '_Chem_comp.ID'
          'Atom_ID_1': [None,lambda x = value: returnStarAtCode(x,length = 12),'Chem_comp_atom.Atom_ID',True],# Pointer to '_Chem_comp_atom.Atom_ID'
          'Atom_type_1': [None,lambda x = value: returnStarCode(x,length = 15),None,True],                    # Standard symbol used to define the atom element type.
          'Resonance_ID_1': [None,returnStarInt,'Resonance.ID',False],                                        # Pointer to '_Resonance.ID'
          'Assembly_atom_ID_2': [None,returnStarInt,'Atom.Assembly_atom_ID',False],                           # Pointer to '_Atom.Assembly_atom_ID'
          'Entity_assembly_ID_2': [None,returnStarInt,'Entity_assembly.ID',True],                             # Pointer to '_Entity_assembly.ID'
          'Entity_ID_2': [None,returnStarInt,'Entity.ID',True],                                               # Pointer to '_Entity.ID'
          'Comp_index_ID_2': [None,returnStarInt,'Entity_comp_index.ID',True],                                # Pointer to '_Entity_comp_index.ID'
          'Seq_ID_2': [None,returnStarInt,'Entity_poly_seq.Num',True],                                        # Pointer to '_Entity_poly_seq.Num'
          'Comp_ID_2': [None,lambda x = value: returnStarCode(x,length = 12),'Chem_comp.ID',True],            # Pointer to '_Chem_comp.ID'
          'Atom_ID_2': [None,lambda x = value: returnStarAtCode(x,length = 12),'Chem_comp_atom.Atom_ID',True],# Pointer to '_Chem_comp_atom.Atom_ID'
          'Atom_type_2': [None,lambda x = value: returnStarCode(x,length = 15),None,True],                    # Standard symbol used to define the atom element type.
          'Resonance_ID_2': [None,returnStarInt,'Resonance.ID',False],                                        # Pointer to '_Resonance.ID'
          'Stereospecific_assignment_code': [None,lambda x = value: returnStarLine(x,length = 127),None,True],# Code used to define the type of stereospecific assignment.
          'Auth_asym_ID_1': [None,lambda x = value: returnStarCode(x,length = 12),None,False],                # An alternative identifier for Asym_id that may be provided by an author.
          'Auth_entity_assembly_ID_1': [None,returnStarInt,None,False],                                       # An alternative identifier for Entity_assembly_id that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number.
          'Auth_seq_ID_1': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                 # An alternative identifier for Seq_id that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Seq_ID or Comp_index_ID.
          'Auth_comp_ID_1': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                # An alternative identifier for Comp_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Auth_atom_ID_1': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                # An alternative identifier for Atom_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Auth_asym_ID_2': [None,lambda x = value: returnStarCode(x,length = 12),None,False],                # An alternative identifier for Asym_id that may be provided by an author.
          'Auth_entity_assembly_ID_2': [None,returnStarInt,None,False],                                       # An alternative identifier for Entity_assembly_id that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number.
          'Auth_seq_ID_2': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                 # An alternative identifier for Seq_id that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Seq_ID or Comp_index_ID.
          'Auth_comp_ID_2': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                # An alternative identifier for Comp_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Auth_atom_ID_2': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                # An alternative identifier for Atom_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Floating_chirality_assign_ID': [None,returnStarInt,'Floating_chirality_assign.ID',True],           # Pointer to '_Floating_chirality_assign.ID'

                },

        'tagNames': ['ID', 'Assembly_atom_ID_1', 'Entity_assembly_ID_1', 'Entity_ID_1', 'Comp_index_ID_1', 'Seq_ID_1', 'Comp_ID_1', 'Atom_ID_1', 'Atom_type_1', 'Resonance_ID_1', 'Assembly_atom_ID_2', 'Entity_assembly_ID_2', 'Entity_ID_2', 'Comp_index_ID_2', 'Seq_ID_2', 'Comp_ID_2', 'Atom_ID_2', 'Atom_type_2', 'Resonance_ID_2', 'Stereospecific_assignment_code', 'Auth_asym_ID_1', 'Auth_entity_assembly_ID_1', 'Auth_seq_ID_1', 'Auth_comp_ID_1', 'Auth_atom_ID_1', 'Auth_asym_ID_2', 'Auth_entity_assembly_ID_2', 'Auth_seq_ID_2', 'Auth_comp_ID_2', 'Auth_atom_ID_2', 'Entry_ID', 'Floating_chirality_assign_ID'],
        'sourcePrimaryKeys': ['ID', 'Entry_ID', 'Floating_chirality_assign_ID'],

            }

        },

    'tableNames': ['Floating_chirality_software', 'Floating_chirality']

    },

  'torsion_angle_constraints': {

    'name': 'Torsion_angle_constraint_list',

    'tags': {

      'Sf_category': ['torsion_angle_constraints',lambda x = value: returnStarCode(x,length = 31),None,True], # Category definition for the information content of the saveframe
      'Sf_framecode': [None,lambda x = value: returnStarCode(x,length = 127),None,False],                     # A label for the saveframe that describes in very brief terms the information contained in the saveframe.
      'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                     # Pointer to '_Entry.ID'
      'ID': [None,returnStarInt,None,True],                                                                   # Unique identifier for the list of torsion angle constraints.
      'Data_file_name': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                   # Name of the file that contains the Torsion angle constraint data.
      'Constraint_file_ID': [None,returnStarInt,'Constraint_file.ID',False],                                  # Pointer to '_Constraint_file.ID'
      'Block_ID': [None,returnStarInt,'Constraint_file.Block_ID',False],                                      # Pointer to '_Constraint_file.Block_ID'
      'Details': [None,returnStarString,None,False],                                                          # Text description providing additional information about the reported torsion angle constraints.
      'Text_data_format': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                 # The data format used to represent the order parameter data as ASCII text in the text block that is the value to the '_Torsion_angle_constraint_list.Text_data' tag.
      'Text_data': [None,returnStarString,None,False],                                                        # A set of order parameter data formatted as ASCII text.

            },

    'tagNames': ['Sf_category', 'Sf_framecode', 'Entry_ID', 'ID', 'Data_file_name', 'Constraint_file_ID', 'Block_ID', 'Details', 'Text_data_format', 'Text_data'],
    'sourcePrimaryKeys': ['Entry_ID', 'ID'],

    'tables': {

      'Torsion_angle_constraints_expt': {

        'tags': {

          'Experiment_ID': [None,returnStarInt,'Experiment.ID',True],                                         # Pointer to '_Experiment.ID'
          'Experiment_name': [None,lambda x = value: returnStarLine(x,length = 127),'Experiment.Name',False], # Pointer to a saveframe of the category 'NMR_spectrometer_expt'
          'Method_ID': [None,returnStarInt,'Method.ID',False],                                                # Pointer to '_Method.ID'
          'Method_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Method.Sf_framecode',False],# Pointer to a saveframe of the category 'method'
          'Sample_ID': [None,returnStarInt,'Sample.ID',True],                                                 # Pointer to '_Sample.ID'
          'Sample_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Sample.Sf_framecode',True],# Sample(s) used in deriving the data
          'Sample_state': [None,lambda x = value: returnStarLine(x,length = 31),None,True],                   # Physical state of the sample either anisotropic or isotropic.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Torsion_angle_constraint_list_ID': [None,returnStarInt,'Torsion_angle_constraint_list.ID',True],   # Pointer to '_Torsion_angle_constraint_list.ID'

                },

        'tagNames': ['Experiment_ID', 'Experiment_name', 'Method_ID', 'Method_label', 'Sample_ID', 'Sample_label', 'Sample_state', 'Entry_ID', 'Torsion_angle_constraint_list_ID'],
        'sourcePrimaryKeys': ['Experiment_ID', 'Sample_ID', 'Sample_state', 'Entry_ID', 'Torsion_angle_constraint_list_ID'],

            },

      'Torsion_angle_constraint_software': {

        'tags': {

          'Software_ID': [None,returnStarInt,'Software.ID',True],                                             # Pointer to '_Software.ID'
          'Software_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Software.Sf_framecode',True],# Pointer to a saveframe of the category 'software'
          'Method_ID': [None,returnStarInt,'Method.ID',False],                                                # Pointer to '_Method.ID'
          'Method_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Method.Sf_framecode',False],# Pointer to a saveframe of the category 'method'
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Torsion_angle_constraint_list_ID': [None,returnStarInt,'Torsion_angle_constraint_list.ID',True],   # Pointer to '_Torsion_angle_constraint_list.ID'

                },

        'tagNames': ['Software_ID', 'Software_label', 'Method_ID', 'Method_label', 'Entry_ID', 'Torsion_angle_constraint_list_ID'],
        'sourcePrimaryKeys': ['Software_ID', 'Entry_ID', 'Torsion_angle_constraint_list_ID'],

            },

      'Karplus_equation': {

        'tags': {

          'Torsion_angle_code': [None,lambda x = value: returnStarCode(x,length = 31),None,True],             # A code used to define the type of torsion angle.
          'Citation_ID': [None,returnStarInt,'Citation.ID',False],                                            # Pointer to '_Citation.ID'
          'Citation_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Citation.Sf_framecode',False],# Pointer to a saveframe of the category 'citation'
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Torsion_angle_constraint_list_ID': [None,returnStarInt,'Torsion_angle_constraint_list.ID',True],   # Pointer to '_Torsion_angle_constraint_list.ID'

                },

        'tagNames': ['Torsion_angle_code', 'Citation_ID', 'Citation_label', 'Entry_ID', 'Torsion_angle_constraint_list_ID'],
        'sourcePrimaryKeys': ['Torsion_angle_code', 'Entry_ID', 'Torsion_angle_constraint_list_ID'],

            },

      'Torsion_angle_constraint': {

        'tags': {

          'ID': [None,returnStarInt,None,True],                                                               # Unique identifier for the reported torsion angle constraint.
          'Torsion_angle_name': [None,lambda x = value: returnStarCode(x,length = 12),None,False],            # The name of the torsion angle constrained.
          'Assembly_atom_ID_1': [None,returnStarInt,'Atom.Assembly_atom_ID',False],                           # Pointer to '_Atom.Assembly_atom_ID'
          'Entity_assembly_ID_1': [None,returnStarInt,'Entity_assembly.ID',True],                             # Pointer to '_Entity_assembly.ID'
          'Entity_ID_1': [None,returnStarInt,'Entity.ID',True],                                               # Pointer to '_Entity.ID'
          'Comp_index_ID_1': [None,returnStarInt,'Entity_comp_index.ID',True],                                # Pointer to '_Entity_comp_index.ID'
          'Seq_ID_1': [None,returnStarInt,'Entity_poly_seq.Num',True],                                        # Pointer to '_Entity_poly_seq.Num'
          'Comp_ID_1': [None,lambda x = value: returnStarCode(x,length = 12),'Chem_comp.ID',True],            # Pointer to '_Chem_comp.ID'
          'Atom_ID_1': [None,lambda x = value: returnStarAtCode(x,length = 12),'Chem_comp_atom.Atom_ID',True],# Pointer to '_Chem_comp_atom.Atom_ID'
          'Atom_type_1': [None,lambda x = value: returnStarCode(x,length = 15),None,True],                    # Standard symbol used to define the atom element type.
          'Resonance_ID_1': [None,returnStarInt,'Resonance.ID',False],                                        # Pointer to '_Resonance.ID'
          'Assembly_atom_ID_2': [None,returnStarInt,'Atom.Assembly_atom_ID',False],                           # Pointer to '_Atom.Assembly_atom_ID'
          'Entity_assembly_ID_2': [None,returnStarInt,'Entity_assembly.ID',True],                             # Pointer to '_Entity_assembly.ID'
          'Entity_ID_2': [None,returnStarInt,'Entity.ID',True],                                               # Pointer to '_Entity.ID'
          'Comp_index_ID_2': [None,returnStarInt,'Entity_comp_index.ID',True],                                # Pointer to '_Entity_comp_index.ID'
          'Seq_ID_2': [None,returnStarInt,'Entity_poly_seq.Num',True],                                        # Pointer to '_Entity_poly_seq.Num'
          'Comp_ID_2': [None,lambda x = value: returnStarCode(x,length = 12),'Chem_comp.ID',True],            # Pointer to '_Chem_comp.ID'
          'Atom_ID_2': [None,lambda x = value: returnStarAtCode(x,length = 12),'Chem_comp_atom.Atom_ID',True],# Pointer to '_Chem_comp_atom.Atom_ID'
          'Atom_type_2': [None,lambda x = value: returnStarCode(x,length = 15),None,True],                    # Standard symbol used to define the atom element type.
          'Resonance_ID_2': [None,returnStarInt,'Resonance.ID',False],                                        # Pointer to '_Resonance.ID'
          'Assembly_atom_ID_3': [None,returnStarInt,'Atom.Assembly_atom_ID',False],                           # Pointer to '_Atom.Assembly_atom_ID'
          'Entity_assembly_ID_3': [None,returnStarInt,'Entity_assembly.ID',True],                             # Pointer to '_Entity_assembly.ID'
          'Entity_ID_3': [None,returnStarInt,'Entity.ID',True],                                               # Pointer to '_Entity.ID'
          'Comp_index_ID_3': [None,returnStarInt,'Entity_comp_index.ID',True],                                # Pointer to '_Entity_comp_index.ID'
          'Seq_ID_3': [None,returnStarInt,'Entity_poly_seq.Num',True],                                        # Pointer to '_Entity_poly_seq.Num'
          'Comp_ID_3': [None,lambda x = value: returnStarCode(x,length = 12),'Chem_comp.ID',True],            # Pointer to '_Chem_comp.ID'
          'Atom_ID_3': [None,lambda x = value: returnStarAtCode(x,length = 12),'Chem_comp_atom.Atom_ID',True],# Pointer to '_Chem_comp_atom.Atom_ID'
          'Atom_type_3': [None,lambda x = value: returnStarCode(x,length = 15),None,True],                    # Standard symbol used to define the atom element type.
          'Resonance_ID_3': [None,returnStarInt,'Resonance.ID',False],                                        # Pointer to '_Resonance.ID'
          'Assembly_atom_ID_4': [None,returnStarInt,'Atom.Assembly_atom_ID',False],                           # Pointer to '_Atom.Assembly_atom_ID'
          'Entity_assembly_ID_4': [None,returnStarInt,'Entity_assembly.ID',True],                             # Pointer to '_Entity_assembly.ID'
          'Entity_ID_4': [None,returnStarInt,'Entity.ID',True],                                               # Pointer to '_Entity.ID'
          'Comp_index_ID_4': [None,returnStarInt,'Entity_comp_index.ID',True],                                # Pointer to '_Entity_comp_index.ID'
          'Seq_ID_4': [None,returnStarInt,'Entity_poly_seq.Num',True],                                        # Pointer to '_Entity_poly_seq.Num'
          'Comp_ID_4': [None,lambda x = value: returnStarCode(x,length = 12),'Chem_comp.ID',True],            # Pointer to '_Chem_comp.ID'
          'Atom_ID_4': [None,lambda x = value: returnStarAtCode(x,length = 12),'Chem_comp_atom.Atom_ID',True],# Pointer to '_Chem_comp_atom.Atom_ID'
          'Atom_type_4': [None,lambda x = value: returnStarCode(x,length = 15),None,True],                    # Standard symbol used to define the atom element type.
          'Resonance_ID_4': [None,returnStarInt,'Resonance.ID',False],                                        # Pointer to '_Resonance.ID'
          'Angle_lower_bound_val': [None,returnStarFloat,None,True],                                          # Value for the lower bound on the torsion angle constraint.
          'Angle_upper_bound_val': [None,returnStarFloat,None,True],                                          # Value for the upper bound on the torsion angle constraint.
          'Source_experiment_ID': [None,returnStarInt,'Experiment.ID',False],                                 # Pointer to '_Experiment.ID'
          'PDB_record_ID_1': [None,lambda x = value: returnStarCode(x,length = 15),None,False],               # The value is an integer that identifies a record in the atom_site list. This is a place holder for the atom record number extracted from a PDB formatted file.
          'PDB_model_num_1': [None,returnStarInt,None,False],                                                 # PDB model number.
          'PDB_strand_ID_1': [None,lambda x = value: returnStarCode(x,length = 15),None,False],               # PDB strand id.
          'PDB_ins_code_1': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                # PDB insertion code.
          'PDB_residue_no_1': [None,lambda x = value: returnStarCode(x,length = 15),None,False],              # PDB residue number.
          'PDB_residue_name_1': [None,lambda x = value: returnStarCode(x,length = 15),None,False],            # PDB residue name.
          'PDB_atom_name_1': [None,lambda x = value: returnStarCode(x,length = 15),None,False],               # PDB atom name.
          'PDB_record_ID_2': [None,lambda x = value: returnStarCode(x,length = 15),None,False],               # The value is an integer that identifies a record in the atom_site list. This is a place holder for the atom record number extracted from a PDB formatted file.
          'PDB_model_num_2': [None,returnStarInt,None,False],                                                 # PDB model number.
          'PDB_strand_ID_2': [None,lambda x = value: returnStarCode(x,length = 15),None,False],               # PDB strand id.
          'PDB_ins_code_2': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                # PDB insertion code.
          'PDB_residue_no_2': [None,lambda x = value: returnStarCode(x,length = 15),None,False],              # PDB residue number.
          'PDB_residue_name_2': [None,lambda x = value: returnStarCode(x,length = 15),None,False],            # PDB residue name.
          'PDB_atom_name_2': [None,lambda x = value: returnStarCode(x,length = 15),None,False],               # PDB atom name.
          'PDB_record_ID_3': [None,lambda x = value: returnStarCode(x,length = 15),None,False],               # The value is an integer that identifies a record in the atom_site list. This is a place holder for the atom record number extracted from a PDB formatted file.
          'PDB_model_num_3': [None,returnStarInt,None,False],                                                 # PDB model number.
          'PDB_strand_ID_3': [None,lambda x = value: returnStarCode(x,length = 15),None,False],               # PDB strand id.
          'PDB_ins_code_3': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                # PDB insertion code.
          'PDB_residue_no_3': [None,lambda x = value: returnStarCode(x,length = 15),None,False],              # PDB residue number.
          'PDB_residue_name_3': [None,lambda x = value: returnStarCode(x,length = 15),None,False],            # PDB residue name.
          'PDB_atom_name_3': [None,lambda x = value: returnStarCode(x,length = 15),None,False],               # PDB atom name.
          'PDB_record_ID_4': [None,lambda x = value: returnStarCode(x,length = 15),None,False],               # The value is an integer that identifies a record in the atom_site list. This is a place holder for the atom record number extracted from a PDB formatted file.
          'PDB_model_num_4': [None,returnStarInt,None,False],                                                 # PDB model number.
          'PDB_strand_ID_4': [None,lambda x = value: returnStarCode(x,length = 15),None,False],               # PDB strand id.
          'PDB_ins_code_4': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                # PDB insertion code.
          'PDB_residue_no_4': [None,lambda x = value: returnStarCode(x,length = 15),None,False],              # PDB residue number.
          'PDB_residue_name_4': [None,lambda x = value: returnStarCode(x,length = 15),None,False],            # PDB residue name.
          'PDB_atom_name_4': [None,lambda x = value: returnStarCode(x,length = 15),None,False],               # PDB atom name.
          'Auth_entity_assembly_ID_1': [None,returnStarInt,None,False],                                       # An alternative identifier for Entity_assembly_id that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number.
          'Auth_asym_ID_1': [None,lambda x = value: returnStarCode(x,length = 12),None,False],                # An alternative identifier for Asym_id that may be provided by an author.
          'Auth_chain_ID_1': [None,lambda x = value: returnStarCode(x,length = 15),None,False],               # Author assigned chain ID
          'Auth_seq_ID_1': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                 # An alternative identifier for Seq_id that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Seq_ID or Comp_index_ID.
          'Auth_comp_ID_1': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                # An alternative identifier for Comp_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Auth_atom_ID_1': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                # An alternative identifier for Atom_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Auth_alt_ID_1': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                 # Author's alternate location identifier.
          'Auth_atom_name_1': [None,lambda x = value: returnStarAtCode(x,length = 12),None,False],            # Author's atom name.
          'Auth_entity_assembly_ID_2': [None,returnStarInt,None,False],                                       # An alternative identifier for Entity_assembly_id that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number.
          'Auth_asym_ID_2': [None,lambda x = value: returnStarCode(x,length = 12),None,False],                # An alternative identifier for Asym_id that may be provided by an author.
          'Auth_chain_ID_2': [None,lambda x = value: returnStarCode(x,length = 15),None,False],               # Author assigned chain ID
          'Auth_seq_ID_2': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                 # An alternative identifier for Seq_id that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Seq_ID or Comp_index_ID.
          'Auth_comp_ID_2': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                # An alternative identifier for Comp_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Auth_atom_ID_2': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                # An alternative identifier for Atom_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Auth_alt_ID_2': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                 # Author's alternate location identifier.
          'Auth_atom_name_2': [None,lambda x = value: returnStarAtCode(x,length = 12),None,False],            # Author's atom name.
          'Auth_entity_assembly_ID_3': [None,returnStarInt,None,False],                                       # An alternative identifier for Entity_assembly_id that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number.
          'Auth_asym_ID_3': [None,lambda x = value: returnStarCode(x,length = 12),None,False],                # An alternative identifier for Asym_id that may be provided by an author.
          'Auth_chain_ID_3': [None,lambda x = value: returnStarCode(x,length = 15),None,False],               # Author assigned chain ID
          'Auth_seq_ID_3': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                 # An alternative identifier for Seq_id that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Seq_ID or Comp_index_ID.
          'Auth_comp_ID_3': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                # An alternative identifier for Comp_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Auth_atom_ID_3': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                # An alternative identifier for Atom_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Auth_alt_ID_3': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                 # Author's alternate location identifier.
          'Auth_atom_name_3': [None,lambda x = value: returnStarAtCode(x,length = 12),None,False],            # Author's atom name.
          'Auth_entity_assembly_ID_4': [None,returnStarInt,None,False],                                       # An alternative identifier for Entity_assembly_id that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number.
          'Auth_asym_ID_4': [None,lambda x = value: returnStarCode(x,length = 12),None,False],                # An alternative identifier for Asym_id that may be provided by an author.
          'Auth_chain_ID_4': [None,lambda x = value: returnStarCode(x,length = 15),None,False],               # Author assigned chain ID
          'Auth_seq_ID_4': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                 # An alternative identifier for Seq_id that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Seq_ID or Comp_index_ID.
          'Auth_comp_ID_4': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                # An alternative identifier for Comp_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Auth_atom_ID_4': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                # An alternative identifier for Atom_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Auth_alt_ID_4': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                 # Author's alternate location identifier.
          'Auth_atom_name_4': [None,lambda x = value: returnStarAtCode(x,length = 12),None,False],            # Author's atom name.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Torsion_angle_constraint_list_ID': [None,returnStarInt,'Torsion_angle_constraint_list.ID',True],   # Pointer to '_Torsion_angle_constraint_list.ID'

                },

        'tagNames': ['ID', 'Torsion_angle_name', 'Assembly_atom_ID_1', 'Entity_assembly_ID_1', 'Entity_ID_1', 'Comp_index_ID_1', 'Seq_ID_1', 'Comp_ID_1', 'Atom_ID_1', 'Atom_type_1', 'Resonance_ID_1', 'Assembly_atom_ID_2', 'Entity_assembly_ID_2', 'Entity_ID_2', 'Comp_index_ID_2', 'Seq_ID_2', 'Comp_ID_2', 'Atom_ID_2', 'Atom_type_2', 'Resonance_ID_2', 'Assembly_atom_ID_3', 'Entity_assembly_ID_3', 'Entity_ID_3', 'Comp_index_ID_3', 'Seq_ID_3', 'Comp_ID_3', 'Atom_ID_3', 'Atom_type_3', 'Resonance_ID_3', 'Assembly_atom_ID_4', 'Entity_assembly_ID_4', 'Entity_ID_4', 'Comp_index_ID_4', 'Seq_ID_4', 'Comp_ID_4', 'Atom_ID_4', 'Atom_type_4', 'Resonance_ID_4', 'Angle_lower_bound_val', 'Angle_upper_bound_val', 'Source_experiment_ID', 'PDB_record_ID_1', 'PDB_model_num_1', 'PDB_strand_ID_1', 'PDB_ins_code_1', 'PDB_residue_no_1', 'PDB_residue_name_1', 'PDB_atom_name_1', 'PDB_record_ID_2', 'PDB_model_num_2', 'PDB_strand_ID_2', 'PDB_ins_code_2', 'PDB_residue_no_2', 'PDB_residue_name_2', 'PDB_atom_name_2', 'PDB_record_ID_3', 'PDB_model_num_3', 'PDB_strand_ID_3', 'PDB_ins_code_3', 'PDB_residue_no_3', 'PDB_residue_name_3', 'PDB_atom_name_3', 'PDB_record_ID_4', 'PDB_model_num_4', 'PDB_strand_ID_4', 'PDB_ins_code_4', 'PDB_residue_no_4', 'PDB_residue_name_4', 'PDB_atom_name_4', 'Auth_entity_assembly_ID_1', 'Auth_asym_ID_1', 'Auth_chain_ID_1', 'Auth_seq_ID_1', 'Auth_comp_ID_1', 'Auth_atom_ID_1', 'Auth_alt_ID_1', 'Auth_atom_name_1', 'Auth_entity_assembly_ID_2', 'Auth_asym_ID_2', 'Auth_chain_ID_2', 'Auth_seq_ID_2', 'Auth_comp_ID_2', 'Auth_atom_ID_2', 'Auth_alt_ID_2', 'Auth_atom_name_2', 'Auth_entity_assembly_ID_3', 'Auth_asym_ID_3', 'Auth_chain_ID_3', 'Auth_seq_ID_3', 'Auth_comp_ID_3', 'Auth_atom_ID_3', 'Auth_alt_ID_3', 'Auth_atom_name_3', 'Auth_entity_assembly_ID_4', 'Auth_asym_ID_4', 'Auth_chain_ID_4', 'Auth_seq_ID_4', 'Auth_comp_ID_4', 'Auth_atom_ID_4', 'Auth_alt_ID_4', 'Auth_atom_name_4', 'Entry_ID', 'Torsion_angle_constraint_list_ID'],
        'sourcePrimaryKeys': ['ID', 'Entry_ID', 'Torsion_angle_constraint_list_ID'],

            },

      'TA_constraint_comment_org': {

        'tags': {

          'ID': [None,returnStarInt,None,True],                                                               # An integer value that uniquely identifies the comment extracted from the torsion angle constraint file.
          'Comment_text': [None,returnStarString,None,True],                                                  # The text of the comment parsed from the torsion angle constraint file.
          'Comment_begin_line': [None,returnStarInt,None,False],                                              # The line in the torsion angle constraint file where the comment begins.
          'Comment_begin_column': [None,returnStarInt,None,False],                                            # The column in the torsion angle constraint file where the comment begins.
          'Comment_end_line': [None,returnStarInt,None,False],                                                # The line in the torsion angle constraint file where the comment ends.
          'Comment_end_column': [None,returnStarInt,None,False],                                              # The column in the torsion angle constraint file where the comment ends.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Torsion_angle_constraint_list_ID': [None,returnStarInt,'Torsion_angle_constraint_list.ID',True],   # Pointer to '_Torsion_angle_constraint_list.ID'

                },

        'tagNames': ['ID', 'Comment_text', 'Comment_begin_line', 'Comment_begin_column', 'Comment_end_line', 'Comment_end_column', 'Entry_ID', 'Torsion_angle_constraint_list_ID'],
        'sourcePrimaryKeys': ['ID', 'Entry_ID', 'Torsion_angle_constraint_list_ID'],

            },

      'TA_constraint_parse_err': {

        'tags': {

          'ID': [None,returnStarInt,None,True],                                                               # An integer value that uniquely identifies the error that occurred in parsing the torsion angle constaint file.
          'Content': [None,returnStarString,None,True],                                                       # The text content of the parse error.
          'Begin_line': [None,returnStarInt,None,False],                                                      # The line in the torsion angle constraint file where the parse error began.
          'Begin_column': [None,returnStarInt,None,False],                                                    # The column in the torsion angle constraint file where the parse error began.
          'End_line': [None,returnStarInt,None,False],                                                        # The line in the torsion angle constraint file where the parse error ended.
          'End_column': [None,returnStarInt,None,False],                                                      # The column in the torsion angle constraint file where the parse error ended.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Torsion_angle_constraint_list_ID': [None,returnStarInt,'Torsion_angle_constraint_list.ID',True],   # Pointer to '_Torsion_angle_constraint_list.ID'

                },

        'tagNames': ['ID', 'Content', 'Begin_line', 'Begin_column', 'End_line', 'End_column', 'Entry_ID', 'Torsion_angle_constraint_list_ID'],
        'sourcePrimaryKeys': ['ID', 'Entry_ID', 'Torsion_angle_constraint_list_ID'],

            },

      'TA_constraint_parse_file': {

        'tags': {

          'ID': [None,returnStarInt,None,True],                                                               # An integer that uniquely defines the file from other files in the list.
          'Name': [None,lambda x = value: returnStarLine(x,length = 31),None,True],                           # Name of the file from which the distance constraints were parsed.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Torsion_angle_constraint_list_ID': [None,returnStarInt,'Torsion_angle_constraint_list.ID',True],   # Pointer to '_Torsion_angle_constraint_list.ID'

                },

        'tagNames': ['ID', 'Name', 'Entry_ID', 'Torsion_angle_constraint_list_ID'],
        'sourcePrimaryKeys': ['ID', 'Entry_ID', 'Torsion_angle_constraint_list_ID'],

            },

      'TA_constraint_conv_err': {

        'tags': {

          'ID': [None,returnStarInt,None,True],                                                               # An integer value that uniquely identifies the conversion error.
          'Parse_file_ID': [None,returnStarInt,'TA_constraint_parse_file.ID',True],                           # Pointer to '_TA_constraint_parse_file.ID'
          'Parse_file_constraint_ID': [None,returnStarInt,None,True],                                         # Identifier for the constraint in the parse file that produced a conversion error.
          'Conv_error_type': [None,lambda x = value: returnStarLine(x,length = 31),None,True],                # Type of constraint conversion error.
          'Conv_error_note': [None,returnStarString,None,False],                                              # Text providing additional information regarding a converion error.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'Torsion_angle_constraint_list_ID': [None,returnStarInt,'Torsion_angle_constraint_list.ID',True],   # Pointer to '_Torsion_angle_constraint_list.ID'

                },

        'tagNames': ['ID', 'Parse_file_ID', 'Parse_file_constraint_ID', 'Conv_error_type', 'Conv_error_note', 'Entry_ID', 'Torsion_angle_constraint_list_ID'],
        'sourcePrimaryKeys': ['ID', 'Entry_ID', 'Torsion_angle_constraint_list_ID'],

            }

        },

    'tableNames': ['Torsion_angle_constraints_expt', 'Torsion_angle_constraint_software', 'Karplus_equation', 'Torsion_angle_constraint', 'TA_constraint_comment_org', 'TA_constraint_parse_err', 'TA_constraint_parse_file', 'TA_constraint_conv_err']

    },

  'RDC_constraints': {

    'name': 'RDC_constraint_list',

    'tags': {

      'Sf_category': ['RDC_constraints',lambda x = value: returnStarCode(x,length = 31),None,True],           # Category definition for the information content of the saveframe
      'Sf_framecode': [None,lambda x = value: returnStarCode(x,length = 127),None,False],                     # A label for the saveframe that describes in very brief terms the information contained in the saveframe.
      'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                     # Pointer to '_Entry.ID'
      'ID': [None,returnStarInt,None,True],                                                                   # Unique identifier for the list of reported residual dipolar coupling constraints.
      'Data_file_name': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                   # Name of the file that contains the RDC constraint data.
      'Constraint_file_ID': [None,returnStarInt,'Constraint_file.ID',False],                                  # Pointer to '_Constraint_file.ID'
      'Block_ID': [None,returnStarInt,'Constraint_file.Block_ID',False],                                      # Pointer to '_Constraint_file.Block_ID'
      'Dipolar_constraint_calib_method': [None,lambda x = value: returnStarLine(x,length = 127),None,False],  # Method used to calibrate the values for the residual dipolar coupling constraints.
      'Mol_align_tensor_axial_sym_mol': [None,returnStarFloat,None,False],                                    # The residual dipolar coupling provides geometric information relative to a common alignment frame. The value for the item Mol_align_tensor_axial_sym_mol is the axial symmetric component of the alignment tensor (1/3(Azz-(Axx+Ayy)/2).
      'Mol_align_tensor_rhombic_mol': [None,returnStarFloat,None,False],                                      # The residual dipolar coupling provides geometric information relative to a common alignment frame. The value for the item Mol_align_tensor_rhombic_mol is the rhombic component of the alignment tensor (1/3(Axx-Ayy)).
      'General_order_param_int_motions': [None,returnStarFloat,None,False],                                   # The residual dipolar coupling provides geometric information relative to a common alignment frame. The value for the item General_order_param_int_motions is S$ the local order parameter for internal motions.
      'Bond_length_usage_flag': [None,lambda x = value: returnStarCode(x,length = 3),None,False],             # A flag indicating whether unique residue bond length values were used in calculating the RDC constraints.
      'Assumed_H_N_bond_length': [None,returnStarFloat,None,False],                                           # Length assumed for the H-N bond length.
      'Assumed_H_C_bond_length': [None,returnStarFloat,None,False],                                           # Length assumed for the H-C bond length.
      'Assumed_C_N_bond_length': [None,returnStarFloat,None,False],                                           # Length assumed for the C-N bond length.
      'Data_file_format': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                 # File format for the deposited residual dipolar coupling restraints.
      'Details': [None,returnStarString,None,False],                                                          # Text description providing additional information about the reported residual dipolar coupling constraints.
      'Text_data_format': [None,lambda x = value: returnStarLine(x,length = 127),None,False],                 # The data format used to represent the order parameter data as ASCII text in the text block that is the value to the '_RDC_constraint_list.Text_data' tag.
      'Text_data': [None,returnStarString,None,False],                                                        # A set of order parameter data formatted as ASCII text.

            },

    'tagNames': ['Sf_category', 'Sf_framecode', 'Entry_ID', 'ID', 'Data_file_name', 'Constraint_file_ID', 'Block_ID', 'Dipolar_constraint_calib_method', 'Mol_align_tensor_axial_sym_mol', 'Mol_align_tensor_rhombic_mol', 'General_order_param_int_motions', 'Bond_length_usage_flag', 'Assumed_H_N_bond_length', 'Assumed_H_C_bond_length', 'Assumed_C_N_bond_length', 'Data_file_format', 'Details', 'Text_data_format', 'Text_data'],
    'sourcePrimaryKeys': ['Entry_ID', 'ID'],

    'tables': {

      'RDC_constraint_expt': {

        'tags': {

          'Experiment_ID': [None,returnStarInt,'Experiment.ID',True],                                         # Pointer to '_Experiment.ID'
          'Experiment_name': [None,lambda x = value: returnStarLine(x,length = 127),'Experiment.Name',False], # Pointer to a saveframe of the category 'NMR_spectrometer_expt'
          'Method_ID': [None,returnStarInt,'Method.ID',False],                                                # Pointer to '_Method.ID'
          'Method_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Method.Sf_framecode',False],# Pointer to a saveframe of the category 'method'
          'Sample_ID': [None,returnStarInt,'Sample.ID',True],                                                 # Pointer to '_Sample.ID'
          'Sample_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Sample.Sf_framecode',True],# Sample(s) used in deriving the data
          'Sample_state': [None,lambda x = value: returnStarLine(x,length = 31),None,True],                   # Physical state of the sample either anisotropic or isotropic.
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'RDC_constraint_list_ID': [None,returnStarInt,'RDC_constraint_list.ID',True],                       # Pointer to '_RDC_constraint_list.ID'

                },

        'tagNames': ['Experiment_ID', 'Experiment_name', 'Method_ID', 'Method_label', 'Sample_ID', 'Sample_label', 'Sample_state', 'Entry_ID', 'RDC_constraint_list_ID'],
        'sourcePrimaryKeys': ['Experiment_ID', 'Sample_ID', 'Sample_state', 'Entry_ID', 'RDC_constraint_list_ID'],

            },

      'RDC_constraint_software': {

        'tags': {

          'Software_ID': [None,returnStarInt,'Software.ID',True],                                             # Pointer to '_Software.ID'
          'Software_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Software.Sf_framecode',True],# Pointer to a saveframe of the category 'software'
          'Method_ID': [None,returnStarInt,'Method.ID',False],                                                # Pointer to '_Method.ID'
          'Method_label': [None,lambda x = value: returnStarLabel(x,length = 127),'Method.Sf_framecode',False],# Pointer to a saveframe of the category 'method'
          'Entry_ID': [None,lambda x = value: returnStarCode(x,length = 12),'Entry.ID',True],                 # Pointer to '_Entry.ID'
          'RDC_constraint_list_ID': [None,returnStarInt,'RDC_constraint_list.ID',True],                       # Pointer to '_RDC_constraint_list.ID'

                },

        'tagNames': ['Software_ID', 'Software_label', 'Method_ID', 'Method_label', 'Entry_ID', 'RDC_constraint_list_ID'],
        'sourcePrimaryKeys': ['Software_ID', 'Entry_ID', 'RDC_constraint_list_ID'],

            },

      'RDC_constraint': {

        'tags': {

          'ID': [None,returnStarInt,None,True],                                                               # Unique identifier for the reported residual dipolar coupling constraint.
          'Assembly_atom_ID_1': [None,returnStarInt,'Atom.Assembly_atom_ID',False],                           # Pointer to '_Atom.Assembly_atom_ID'
          'Entity_assembly_ID_1': [None,returnStarInt,'Entity_assembly.ID',True],                             # Pointer to '_Entity_assembly.ID'
          'Entity_ID_1': [None,returnStarInt,'Entity.ID',True],                                               # Pointer to '_Entity.ID'
          'Comp_index_ID_1': [None,returnStarInt,'Entity_comp_index.ID',True],                                # Pointer to '_Entity_comp_index.ID'
          'Seq_ID_1': [None,returnStarInt,'Entity_poly_seq.Num',True],                                        # Pointer to '_Entity_poly_seq.Num'
          'Comp_ID_1': [None,lambda x = value: returnStarCode(x,length = 12),'Chem_comp.ID',True],            # Pointer to '_Chem_comp.ID'
          'Atom_ID_1': [None,lambda x = value: returnStarAtCode(x,length = 12),'Chem_comp_atom.Atom_ID',True],# Pointer to '_Chem_comp_atom.Atom_ID'
          'Atom_type_1': [None,lambda x = value: returnStarCode(x,length = 15),None,True],                    # Standard symbol used to define the atom element type.
          'Atom_isotope_number_1': [None,returnStarInt,None,False],                                           # The mass number for the chemical element defined by the tag '_Atom_type' or any of its related tags.
          'Resonance_ID_1': [None,returnStarInt,'Resonance.ID',False],                                        # Pointer to '_Resonance.ID'
          'Assembly_atom_ID_2': [None,returnStarInt,'Atom.Assembly_atom_ID',False],                           # Pointer to '_Atom.Assembly_atom_ID'
          'Entity_assembly_ID_2': [None,returnStarInt,'Entity_assembly.ID',True],                             # Pointer to '_Entity_assembly.ID'
          'Entity_ID_2': [None,returnStarInt,'Entity.ID',True],                                               # Pointer to '_Entity.ID'
          'Comp_index_ID_2': [None,returnStarInt,'Entity_comp_index.ID',True],                                # Pointer to '_Entity_comp_index.ID'
          'Seq_ID_2': [None,returnStarInt,'Entity_poly_seq.Num',True],                                        # Pointer to '_Entity_poly_seq.Num'
          'Comp_ID_2': [None,lambda x = value: returnStarCode(x,length = 12),'Chem_comp.ID',True],            # Pointer to '_Chem_comp.ID'
          'Atom_ID_2': [None,lambda x = value: returnStarAtCode(x,length = 12),'Chem_comp_atom.Atom_ID',True],# Pointer to '_Chem_comp_atom.Atom_ID'
          'Atom_type_2': [None,lambda x = value: returnStarCode(x,length = 15),None,True],                    # Standard symbol used to define the atom element type.
          'Atom_isotope_number_2': [None,returnStarInt,None,False],                                           # The mass number for the chemical element defined by the tag '_Atom_type' or any of its related tags.
          'Resonance_ID_2': [None,returnStarInt,'Resonance.ID',False],                                        # Pointer to '_Resonance.ID'
          'RDC_val': [None,returnStarFloat,None,True],                                                        # Value for the residual dipolar coupling constraint.
          'RDC_lower_bound': [None,returnStarFloat,None,False],                                               # Value for the lower bound on the residual dipolar coupling constraint.
          'RDC_upper_bound': [None,returnStarFloat,None,False],                                               # Value for the upper bound on the residual dipolar coupling constraint.
          'RDC_val_err': [None,returnStarFloat,None,False],                                                   # Estimated error in the value for a residual dipolar coupling constraint.
          'RDC_val_scale_factor': [None,returnStarFloat,None,False],                                          # Scaling factor used to normalize the residual dipolar coupling constraint.
          'RDC_bond_length': [None,returnStarFloat,None,False],                                               # Bond length value used in calculating the RDC constraint value.
          'Source_experiment_ID': [None,returnStarInt,'Experiment.ID',False],                                 # Pointer to '_Experiment.ID'
          'PDB_record_ID_1': [None,lambda x = value: returnStarCode(x,length = 15),None,False],               # The value is an integer that identifies a record in the atom_site list. This is a place holder for the atom record number extracted from a PDB formatted file.
          'PDB_model_num_1': [None,returnStarInt,None,False],                                                 # PDB model number.
          'PDB_strand_ID_1': [None,lambda x = value: returnStarCode(x,length = 15),None,False],               # PDB strand id.
          'PDB_ins_code_1': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                # PDB insertion code.
          'PDB_residue_no_1': [None,lambda x = value: returnStarCode(x,length = 15),None,False],              # PDB residue number.
          'PDB_residue_name_1': [None,lambda x = value: returnStarCode(x,length = 15),None,False],            # PDB residue name.
          'PDB_atom_name_1': [None,lambda x = value: returnStarCode(x,length = 15),None,False],               # PDB atom name.
          'PDB_record_ID_2': [None,lambda x = value: returnStarCode(x,length = 15),None,False],               # The value is an integer that identifies a record in the atom_site list. This is a place holder for the atom record number extracted from a PDB formatted file.
          'PDB_model_num_2': [None,returnStarInt,None,False],                                                 # PDB model number.
          'PDB_strand_ID_2': [None,lambda x = value: returnStarCode(x,length = 15),None,False],               # PDB strand id.
          'PDB_ins_code_2': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                # PDB insertion code.
          'PDB_residue_no_2': [None,lambda x = value: returnStarCode(x,length = 15),None,False],              # PDB residue number.
          'PDB_residue_name_2': [None,lambda x = value: returnStarCode(x,length = 15),None,False],            # PDB residue name.
          'PDB_atom_name_2': [None,lambda x = value: returnStarCode(x,length = 15),None,False],               # PDB atom name.
          'Auth_entity_assembly_ID_1': [None,returnStarInt,None,False],                                       # An alternative identifier for Entity_assembly_id that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number.
          'Auth_asym_ID_1': [None,lambda x = value: returnStarCode(x,length = 12),None,False],                # An alternative identifier for Asym_id that may be provided by an author.
          'Auth_chain_ID_1': [None,lambda x = value: returnStarCode(x,length = 15),None,False],               # Author assigned chain ID
          'Auth_seq_ID_1': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                 # An alternative identifier for Seq_id that may be provided by an author in order to match that used in the publication that describes the experimental data.  Note that the value is not required to be a number and does not need to correspond to the value for Seq_ID or Comp_index_ID.
          'Auth_comp_ID_1': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                # An alternative identifier for Comp_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Auth_atom_ID_1': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                # An alternative identifier for Atom_id that may be provided by an author in order to match that used in the publication that describes the experimental data.
          'Auth_alt_ID_1': [None,lambda x = value: returnStarCode(x,length = 15),None,False],                 # Author's alternate location identifier.
          'Auth_atom_name_1': [None,lambda x = value: returnStarAtCode(x,length = 12)