
# Packages, classElements and AbstractDataTypes skipped in new model
# (prefix, typeName, elemName, newGuid, elemType)
skipElements = [
 ('AFFI', 'Person', 'nmrCalcRuns', 'www.ccpn.ac.uk_Fogh_2009-04-16-16:24:04_00042', 'MetaRole'), 
 ('ANPR', 'AnnealProtocol', 'runs', 'www.ccpn.ac.uk_Fogh_2007-06-05-13:42:09_00001', 'MetaRole'), 
 ('ANPR', 'EnergyTerm', 'nmrSimEnergyTerms', 'www.ccpn.ac.uk_Fogh_2007-06-05-13:43:08_00004', 'MetaRole'), 
 ('COOR', 'Model', 'inputToNmrRuns', 'www.ccpn.ac.uk_Fogh_2007-11-23-12:00:13_00001', 'MetaRole'), 
 ('COOR', 'StructureEnsemble', 'outputFromNmrRun', 'www.ccpn.ac.uk_Fogh_2007-06-05-13:45:53_00002', 'MetaRole'), 
 ('DLOC', 'AbstractDataStore', 'externalDatas', 'www.ccpn.ac.uk_Fogh_2009-05-20-16:32:16_00004', 'MetaRole'), 
 ('IMPL', 'MemopsRoot', 'currentNmrSimStore', 'ccpn_automatic_memops.Implementation.MemopsRoot.currentNmrSimStore', 'MetaRole'), 
 ('IMPL', 'MemopsRoot', 'nmrSimStores', 'ccpn_automatic_memops.Implementation.MemopsRoot.nmrSimStore', 'MetaRole'), 
 ('METH', 'Software', 'nmrCalcStores', 'www.ccpn.ac.uk_Fogh_2009-04-16-16:24:04_00044', 'MetaRole'), 
 ('MOLS', 'MolSystem', 'nmrSimRuns', 'www.ccpn.ac.uk_Fogh_2007-06-05-13:46:22_00002', 'MetaRole'), 
 ('NMR', 'AbstractMeasurementList', 'inputToNmrRuns', 'www.ccpn.ac.uk_Fogh_2008-03-14-15:14:21_00001', 'MetaRole'), 
 ('NMR', 'AbstractMeasurementList', 'outputFromNmrRun', 'www.ccpn.ac.uk_Fogh_2008-03-14-15:14:54_00001', 'MetaRole'), 
 ('NMR', 'PeakList', 'inputToNmrRuns', 'www.ccpn.ac.uk_Fogh_2008-03-14-15:14:56_00002', 'MetaRole'), 
 ('NMR', 'PeakList', 'outputFromNmrRun', 'www.ccpn.ac.uk_Fogh_2008-03-14-15:14:56_00004', 'MetaRole'), 
 ('NMRC', 'AbstractConstraintList', 'nmrSimEnergyTerms', 'www.ccpn.ac.uk_Fogh_2007-06-05-13:43:08_00010', 'MetaRole'), 
 ('NMRC', 'NmrConstraintStore', 'inputToNmrRuns', 'www.ccpn.ac.uk_Fogh_2007-06-05-13:45:51_00001', 'MetaRole'), 
 ('NMRC', 'NmrConstraintStore', 'outputFromNmrRun', 'www.ccpn.ac.uk_Fogh_2007-06-05-13:45:51_00003', 'MetaRole'), 
 ('NSIM', None, None, 'www.ccpn.ac.uk_Fogh_2007-06-05-13:42:05_00010', 'MetaPackage'), 
 ('TEMP', 'MultiTypesValue', None, 'www.ccpn.ac.uk_Fogh_2008-05-05-15:12:49_00001', 'MetaClass'), 
 ('WMS', 'Basket', None, 'www.ccpn.ac.uk_Fogh_2009-03-09-12:00:15_00001', 'MetaClass'), 
 ('WMS', 'ProjectVersion', 'baskets', 'www.ccpn.ac.uk_Fogh_2009-03-09-12:00:17_00001', 'MetaRole'), 
 ('WMS', 'RawFile', 'wmsSegment', 'www.ccpn.ac.uk_Fogh_2009-01-29-15:16:56_00028', 'MetaRole'), 
 ('WMS', 'Task', 'user', 'www.ccpn.ac.uk_Fogh_2009-03-09-12:00:17_00010', 'MetaRole'), 
 ('WMS', 'User', None, 'www.ccpn.ac.uk_Fogh_2009-01-29-15:16:52_00003', 'MetaClass'), 
 ('WMS', 'WmsSegment', 'baskets', 'www.ccpn.ac.uk_Fogh_2009-03-09-12:00:17_00013', 'MetaRole'), 
 ('WMS', 'WmsSegment', 'rawFiles', 'www.ccpn.ac.uk_Fogh_2009-01-29-15:16:56_00029', 'MetaRole'), 
 ('WMS', 'WmsSegment', 'users', 'www.ccpn.ac.uk_Fogh_2009-01-29-15:16:56_00027', 'MetaRole'), 
]

# classElements skipped in new model, but available for simple data transfer
# (prefix, typeName, elemName, newGuid, elemMap, valueTypeGuid)
delayElements = [
 ('WMS', 'Task', 'taskType', 'www.ccpn.ac.uk_Fogh_2009-03-12-18:29:05_00001', {'tag': 'WMS.Task.taskType', 'type': 'attr', 'name': 'taskType'}, 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00037'), 
]

# MetaConstraints added in new model
# (qualifiedName, guid)
newConstraints = [
 ('cambridge.WmsProtocol.ProtocolParam.relatesTo.No_cyclical_ProtocolParam_dependency', 'www.ccpn.ac.uk_Fogh_2010-05-20-14:35:13_00003'), 
 ('ccp.nmr.NmrConstraint.CsaConstraint.resonance.value_isotopeCode_eq_self_parentList_isotopeCode', 'www.ccpn.ac.uk_Fogh_2013-05-03-11:50:04_00001'), 
 ('ccp.nmr.NmrReference.ChemAtomNmrDistrib.consistent_matrix_size', 'www.ccpn.ac.uk_Fogh_2010-05-14-15:28:22_00003'), 
 ('ccp.nmr.NmrReference.ChemAtomNmrDistrib.consistent_number_of_reference_atoms', 'www.ccpn.ac.uk_Fogh_2010-05-14-15:28:22_00004'), 
 ('ccp.nmr.NmrReference.ChemAtomNmrDistrib.consistent_referencing_dimension', 'www.ccpn.ac.uk_Fogh_2010-05-14-15:28:22_00002'), 
 ('memops.Implementation.AbstractMatrix.matrix_size_eq_data_size', 'www.ccpn.ac.uk_Fogh_2010-05-12-17:30:22_00002'), 
]

# Mandatory classElements added in new model
# New ClassElements with locard !=0, no default, not derived or Implementation
# (prefix, typeName, elemName, newGuid)
newMandatories = [
 ('CALC', 'EnergyTermParameter', 'code', 'www.ccpn.ac.uk_Fogh_2010-05-18-17:35:48_00005'), 
 ('CALC', 'EnergyTermParameter', 'energyTerm', 'www.ccpn.ac.uk_Fogh_2010-05-18-17:35:48_00003'), 
 ('CALC', 'EnergyTermParameter', 'value', 'www.ccpn.ac.uk_Fogh_2010-05-18-17:35:48_00006'), 
 ('CALC', 'NmrCalcStore', 'nmrProjectName', 'www.ccpn.ac.uk_Fogh_2010-05-10-13:46:58_00001'), 
 ('CALC', 'TensorData', 'orientationMatrix', 'www.ccpn.ac.uk_Fogh_2010-05-17-12:06:21_00001'), 
 ('IMPL', 'AbstractMatrix', 'data', 'www.ccpn.ac.uk_Fogh_2010-05-13-14:38:45_00001'), 
 ('IMPL', 'AbstractMatrix', 'shape', 'www.ccpn.ac.uk_Fogh_2010-05-12-17:30:25_00001'), 
 ('IMPL', 'BooleanMatrix', 'data', 'www.ccpn.ac.uk_Fogh_2010-05-12-17:39:28_00003'), 
 ('IMPL', 'FloatMatrix', 'data', 'www.ccpn.ac.uk_Fogh_2010-05-12-17:41:35_00001'), 
 ('IMPL', 'IntMatrix', 'data', 'www.ccpn.ac.uk_Fogh_2010-05-12-17:41:35_00002'), 
 ('IMPL', 'StringMatrix', 'data', 'www.ccpn.ac.uk_Fogh_2010-05-12-17:41:35_00003'), 
 ('NMRR', 'ChemAtomNmrDistrib', 'chemCompNmrRef', 'www.ccpn.ac.uk_Fogh_2010-05-14-17:17:46_00003'), 
 ('NMRR', 'ChemAtomNmrDistrib', 'refAtoms', 'www.ccpn.ac.uk_Fogh_2010-05-14-17:17:46_00001'), 
 ('NMRR', 'ChemAtomNmrDistrib', 'refPoints', 'www.ccpn.ac.uk_Fogh_2010-05-14-15:28:27_00003'), 
 ('NMRR', 'ChemAtomNmrDistrib', 'refValues', 'www.ccpn.ac.uk_Fogh_2010-05-14-15:28:27_00004'), 
 ('NMRR', 'ChemAtomNmrDistrib', 'serial', 'www.ccpn.ac.uk_Fogh_2010-05-14-15:28:27_00001'), 
 ('NMRR', 'ChemAtomNmrDistrib', 'shiftDistribution', 'www.ccpn.ac.uk_Fogh_2010-05-14-15:28:27_00002'), 
 ('NMRS', 'Compound', 'code', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00005'), 
 ('NMRS', 'Compound', 'nmrScreenStore', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00041'), 
 ('NMRS', 'ExperimentHit', 'trialExperiment', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00009'), 
 ('NMRS', 'ExperimentHit', 'trialHit', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:51:56_00020'), 
 ('NMRS', 'Mixture', 'nmrScreen', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00026'), 
 ('NMRS', 'Mixture', 'serial', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00016'), 
 ('NMRS', 'MixtureComponent', 'compound', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00003'), 
 ('NMRS', 'MixtureComponent', 'mixture', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00012'), 
 ('NMRS', 'MixtureComponent', 'serial', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00024'), 
 ('NMRS', 'NmrScreen', 'code', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00034'), 
 ('NMRS', 'NmrScreen', 'nmrScreenStore', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00043'), 
 ('NMRS', 'NmrScreen', 'startDate', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00038'), 
 ('NMRS', 'NmrScreenStore', 'code', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00045'), 
 ('NMRS', 'NmrScreenStore', 'memopsRoot', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:34_00001'), 
 ('NMRS', 'NmrScreenStore', 'name', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00046'), 
 ('NMRS', 'RefSpectrum', 'compound', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00001'), 
 ('NMRS', 'RefSpectrum', 'serial', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00051'), 
 ('NMRS', 'RefSpectrum', 'solvent', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00055'), 
 ('NMRS', 'Trial', 'mixture', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00014'), 
 ('NMRS', 'Trial', 'nmrScreen', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00028'), 
 ('NMRS', 'Trial', 'serial', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:51:56_00007'), 
 ('NMRS', 'TrialExperiment', 'serial', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:51:56_00013'), 
 ('NMRS', 'TrialExperiment', 'trial', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:51:56_00005'), 
 ('NMRS', 'TrialGroup', 'nmrScreen', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00030'), 
 ('NMRS', 'TrialGroup', 'serial', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:51:56_00016'), 
 ('NMRS', 'TrialHit', 'mixtureComponent', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00022'), 
 ('NMRS', 'TrialHit', 'serial', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:51:56_00022'), 
 ('NMRS', 'TrialHit', 'trial', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:51:56_00001'), 
 ('WMS', 'RawFile', 'project', 'www.ccpn.ac.uk_Fogh_2010-05-06-12:26:56_00001'), 
 ('WMSP', 'ProtocolAccess', 'localUserName', 'www.ccpn.ac.uk_Fogh_2010-05-10-13:46:55_00003'), 
 ('WMSP', 'ProtocolAccess', 'protocolService', 'www.ccpn.ac.uk_Fogh_2010-05-06-13:30:17_00010'), 
 ('WMSP', 'ProtocolAccess', 'serial', 'www.ccpn.ac.uk_Fogh_2010-05-06-12:26:57_00016'), 
 ('WMSP', 'ProtocolAccess', 'userName', 'www.ccpn.ac.uk_Fogh_2010-05-06-12:26:57_00017'), 
 ('WMSP', 'ProtocolParam', 'serial', 'www.ccpn.ac.uk_Fogh_2010-05-06-12:26:57_00019'), 
 ('WMSP', 'ProtocolParam', 'wmsProtocol', 'www.ccpn.ac.uk_Fogh_2010-05-06-12:26:57_00010'), 
 ('WMSP', 'ProtocolService', 'serial', 'www.ccpn.ac.uk_Fogh_2010-05-06-13:30:17_00012'), 
 ('WMSP', 'ProtocolService', 'wmsProtocol', 'www.ccpn.ac.uk_Fogh_2010-05-06-12:26:57_00012'), 
 ('WMSP', 'WmsProtocol', 'memopsRoot', 'www.ccpn.ac.uk_Fogh_2010-05-06-13:30:17_00061'), 
 ('WMSP', 'WmsProtocol', 'name', 'www.ccpn.ac.uk_Fogh_2010-05-06-12:26:57_00014'), 
 ('WMSQ', 'AbstractQuery', 'criteria', 'www.ccpn.ac.uk_Fogh_2010-05-06-13:30:17_00019'), 
 ('WMSQ', 'AbstractQuery', 'date', 'www.ccpn.ac.uk_Fogh_2010-05-06-13:30:17_00020'), 
 ('WMSQ', 'ProjectQuery', 'serial', 'www.ccpn.ac.uk_Fogh_2010-05-06-13:30:17_00025'), 
 ('WMSQ', 'ProjectQuery', 'wmsQueryStore', 'www.ccpn.ac.uk_Fogh_2010-05-06-13:30:17_00051'), 
 ('WMSQ', 'ProjectResult', 'projectName', 'www.ccpn.ac.uk_Fogh_2010-05-06-13:30:17_00029'), 
 ('WMSQ', 'ProjectResult', 'projectQuery', 'www.ccpn.ac.uk_Fogh_2010-05-06-13:30:17_00023'), 
 ('WMSQ', 'ProjectResult', 'serial', 'www.ccpn.ac.uk_Fogh_2010-05-06-13:30:17_00027'), 
 ('WMSQ', 'ProjectResult', 'wmsSegmentName', 'www.ccpn.ac.uk_Fogh_2010-05-06-13:30:17_00028'), 
 ('WMSQ', 'ProjectVersionQuery', 'serial', 'www.ccpn.ac.uk_Fogh_2010-05-06-13:30:17_00034'), 
 ('WMSQ', 'ProjectVersionQuery', 'wmsQueryStore', 'www.ccpn.ac.uk_Fogh_2010-05-06-13:30:17_00053'), 
 ('WMSQ', 'ProjectVersionResult', 'projectName', 'www.ccpn.ac.uk_Fogh_2010-05-06-13:30:17_00038'), 
 ('WMSQ', 'ProjectVersionResult', 'projectVersionQuery', 'www.ccpn.ac.uk_Fogh_2010-05-06-13:30:17_00032'), 
 ('WMSQ', 'ProjectVersionResult', 'serial', 'www.ccpn.ac.uk_Fogh_2010-05-06-13:30:17_00036'), 
 ('WMSQ', 'ProjectVersionResult', 'versionTag', 'www.ccpn.ac.uk_Fogh_2010-05-06-13:30:17_00039'), 
 ('WMSQ', 'ProjectVersionResult', 'wmsSegmentName', 'www.ccpn.ac.uk_Fogh_2010-05-06-13:30:17_00037'), 
 ('WMSQ', 'TaskQuery', 'serial', 'www.ccpn.ac.uk_Fogh_2010-05-06-13:30:17_00044'), 
 ('WMSQ', 'TaskQuery', 'wmsQueryStore', 'www.ccpn.ac.uk_Fogh_2010-05-06-13:30:17_00055'), 
 ('WMSQ', 'TaskResult', 'serial', 'www.ccpn.ac.uk_Fogh_2010-05-06-13:30:17_00046'), 
 ('WMSQ', 'TaskResult', 'taskQuery', 'www.ccpn.ac.uk_Fogh_2010-05-06-13:30:17_00042'), 
 ('WMSQ', 'TaskResult', 'taskSerial', 'www.ccpn.ac.uk_Fogh_2010-05-06-13:30:17_00048'), 
 ('WMSQ', 'TaskResult', 'wmsSegmentName', 'www.ccpn.ac.uk_Fogh_2010-05-06-13:30:17_00047'), 
 ('WMSQ', 'WmsQueryStore', 'memopsRoot', 'www.ccpn.ac.uk_Fogh_2010-05-06-13:30:17_00063'), 
 ('WMSQ', 'WmsQueryStore', 'serial', 'www.ccpn.ac.uk_Fogh_2010-05-06-13:30:17_00057'), 
]

# Packages, classElements and AbstractDataTypes added in new model
# Optional, i.e. excluding mandatory classElements given above
# (prefix, typeName, elemName, newGuid)
newElements = [
 ('ACCO', 'User', 'isSuperuser', 'www.ccpn.ac.uk_Fogh_2010-05-06-13:30:17_00060'), 
 ('AFFI', 'PersonInGroup', 'photo', 'www.ccpn.ac.uk_Fogh_2010-05-06-13:30:20_00001'), 
 ('ANAL', 'SpectrumWindow', 'isZeroLineShown', 'www.ccpn.ac.uk_Fogh_2013-05-03-11:50:01_00001'), 
 ('ANAL', 'SpectrumWindowView', 'isContourLineVisible', 'www.ccpn.ac.uk_Fogh_2013-05-07-17:07:06_00001'), 
 ('ANAP', 'AnalysisProfile', 'sendBugReports', 'www.ccpn.ac.uk_Fogh_2010-11-17-16:21:37_00004'), 
 ('ANAP', 'AnalysisProfile', 'userEmail', 'www.ccpn.ac.uk_Fogh_2010-11-17-16:21:37_00003'), 
 ('ANAP', 'AnalysisProfile', 'userName', 'www.ccpn.ac.uk_Fogh_2010-11-17-16:21:37_00001'), 
 ('ANAP', 'AnalysisProfile', 'userOrganisation', 'www.ccpn.ac.uk_Fogh_2010-11-17-16:21:37_00002'), 
 ('ANPR', 'AnnealProtocol', 'applicationVersion', 'www.ccpn.ac.uk_Fogh_2010-05-18-10:52:09_00002'), 
 ('ANPR', 'AnnealProtocol', 'methodStoreName', 'www.ccpn.ac.uk_Fogh_2010-05-18-10:52:09_00001'), 
 ('CALC', 'EnergyTerm', None, 'www.ccpn.ac.uk_Fogh_2010-05-18-17:35:44_00001'), 
 ('CALC', 'EnergyTerm', 'annealEnergyTermSerial', 'www.ccpn.ac.uk_Fogh_2010-05-11-15:26:01_00003'), 
 ('CALC', 'EnergyTerm', 'constraintLists', 'www.ccpn.ac.uk_Fogh_2010-05-18-17:35:48_00002'), 
 ('CALC', 'EnergyTerm', 'energyTermParameters', 'www.ccpn.ac.uk_Fogh_2010-05-18-17:35:48_00004'), 
 ('CALC', 'EnergyTermParameter', None, 'www.ccpn.ac.uk_Fogh_2010-05-18-17:35:44_00002'), 
 ('CALC', 'ExternalData', 'dataLocationStoreName', 'www.ccpn.ac.uk_Fogh_2010-05-11-18:03:21_00001'), 
 ('CALC', 'ExternalData', 'dataStoreSerial', 'www.ccpn.ac.uk_Fogh_2010-05-11-18:28:30_00001'), 
 ('CALC', 'MatrixData', None, 'www.ccpn.ac.uk_Fogh_2010-05-13-18:08:24_00001'), 
 ('CALC', 'MatrixData', 'floatMatrix', 'www.ccpn.ac.uk_Fogh_2010-05-13-18:08:28_00001'), 
 ('CALC', 'MatrixData', 'intMatrix', 'www.ccpn.ac.uk_Fogh_2010-05-13-18:08:28_00002'), 
 ('CALC', 'NmrCalcStore', 'methodStoreName', 'www.ccpn.ac.uk_Fogh_2010-05-10-13:46:58_00003'), 
 ('CALC', 'NmrCalcStore', 'softwareName', 'www.ccpn.ac.uk_Fogh_2010-05-10-13:46:58_00004'), 
 ('CALC', 'NmrCalcStore', 'softwareVersion', 'www.ccpn.ac.uk_Fogh_2010-05-10-13:46:58_00005'), 
 ('CALC', 'NmrCalcStore', 'validationStoreName', 'www.ccpn.ac.uk_Fogh_2010-05-10-13:46:58_00002'), 
 ('CALC', 'Run', 'affiliationStoreName', 'www.ccpn.ac.uk_Fogh_2010-05-11-15:26:01_00008'), 
 ('CALC', 'Run', 'annealProtocolApp', 'www.ccpn.ac.uk_Fogh_2010-05-11-15:26:01_00010'), 
 ('CALC', 'Run', 'annealProtocolCode', 'www.ccpn.ac.uk_Fogh_2010-05-11-15:26:01_00011'), 
 ('CALC', 'Run', 'annealProtocolStoreName', 'www.ccpn.ac.uk_Fogh_2010-05-21-15:54:39_00001'), 
 ('CALC', 'Run', 'operatorSerial', 'www.ccpn.ac.uk_Fogh_2010-05-11-15:26:01_00009'), 
 ('CALC', 'Run', 'structureGenerationSerial', 'www.ccpn.ac.uk_Fogh_2010-05-11-15:26:01_00007'), 
 ('CALC', 'RunIo', None, 'www.ccpn.ac.uk_Fogh_2010-05-05-14:19:57_00001'), 
 ('CALC', 'TensorData', None, 'www.ccpn.ac.uk_Fogh_2010-05-17-12:06:16_00001'), 
 ('DLOC', 'MimeTypeDataStore', 'photoPersons', 'www.ccpn.ac.uk_Fogh_2010-05-06-13:30:19_00001'), 
 ('IMPL', 'AbstractMatrix', None, 'www.ccpn.ac.uk_Fogh_2010-05-12-17:30:22_00001'), 
 ('IMPL', 'BooleanMatrix', None, 'www.ccpn.ac.uk_Fogh_2010-05-12-17:30:22_00005'), 
 ('IMPL', 'FloatMatrix', None, 'www.ccpn.ac.uk_Fogh_2010-05-12-17:30:22_00003'), 
 ('IMPL', 'IntMatrix', None, 'www.ccpn.ac.uk_Fogh_2010-05-12-17:30:22_00004'), 
 ('IMPL', 'MemopsRoot', 'currentNmrScreenStore', 'ccpn_automatic_memops.Implementation.MemopsRoot.currentNmrScreenStore'), 
 ('IMPL', 'MemopsRoot', 'currentWmsProtocol', 'ccpn_automatic_memops.Implementation.MemopsRoot.currentWmsProtocol'), 
 ('IMPL', 'MemopsRoot', 'currentWmsQueryStore', 'ccpn_automatic_memops.Implementation.MemopsRoot.currentWmsQueryStore'), 
 ('IMPL', 'MemopsRoot', 'nmrScreenStores', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:34_00002'), 
 ('IMPL', 'MemopsRoot', 'wmsProtocols', 'www.ccpn.ac.uk_Fogh_2010-05-06-13:30:17_00062'), 
 ('IMPL', 'MemopsRoot', 'wmsQueryStores', 'www.ccpn.ac.uk_Fogh_2010-05-06-13:30:17_00064'), 
 ('IMPL', 'StringMatrix', None, 'www.ccpn.ac.uk_Fogh_2010-05-12-17:30:22_00006'), 
 ('IMPL', 'ThreeValueAnswer', None, 'www.ccpn.ac.uk_Fogh_2010-11-17-16:21:33_00001'), 
 ('LMOL', 'LabeledMixture', 'name', 'www.ccpn.ac.uk_Fogh_2010-04-30-17:48:49_00001'), 
 ('MOLE', 'Molecule', 'compounds', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:51:56_00027'), 
 ('MOLS', 'MolSystem', 'nmrScreens', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00032'), 
 ('NMR', 'DataSource', 'refSpectra', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00049'), 
 ('NMR', 'DataSource', 'trialExperiments', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:51:56_00011'), 
 ('NMR', 'ExpTransfer', 'isDirect', 'www.ccpn.ac.uk_Fogh_2010-04-30-17:48:48_00001'), 
 ('NMR', 'PeakDim', 'realValueImpl', 'www.ccpn.ac.uk_Fogh_2010-04-30-17:48:48_00002'), 
 ('NMRC', 'AbstractConstraintList', 'energyTerms', 'www.ccpn.ac.uk_Fogh_2010-05-18-17:35:48_00001'), 
 ('NMRR', 'ChemAtomNmrDistrib', None, 'www.ccpn.ac.uk_Fogh_2010-05-14-15:28:22_00001'), 
 ('NMRR', 'ChemAtomNmrRef', 'shiftDistributions', 'www.ccpn.ac.uk_Fogh_2010-05-14-17:17:46_00002'), 
 ('NMRR', 'ChemCompNmrRef', 'chemAtomNmrDistribs', 'www.ccpn.ac.uk_Fogh_2010-05-14-17:17:46_00004'), 
 ('NMRS', None, None, 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:32_00001'), 
 ('NMRS', 'Compound', None, 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:32_00003'), 
 ('NMRS', 'Compound', 'details', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00007'), 
 ('NMRS', 'Compound', 'mixtureComponents', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00004'), 
 ('NMRS', 'Compound', 'molecule', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:51:56_00026'), 
 ('NMRS', 'Compound', 'name', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00006'), 
 ('NMRS', 'Compound', 'refSpectrums', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00002'), 
 ('NMRS', 'ExperimentHit', None, 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:32_00013'), 
 ('NMRS', 'ExperimentHit', 'figOfMerit', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00010'), 
 ('NMRS', 'ExperimentHit', 'meritCode', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00011'), 
 ('NMRS', 'Mixture', None, 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:32_00007'), 
 ('NMRS', 'Mixture', 'details', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00021'), 
 ('NMRS', 'Mixture', 'mixtureComponents', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00013'), 
 ('NMRS', 'Mixture', 'name', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00017'), 
 ('NMRS', 'Mixture', 'pH', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00019'), 
 ('NMRS', 'Mixture', 'sample', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:51:57_00001'), 
 ('NMRS', 'Mixture', 'solvent', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00020'), 
 ('NMRS', 'Mixture', 'trials', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00015'), 
 ('NMRS', 'Mixture', 'volume', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00018'), 
 ('NMRS', 'MixtureComponent', None, 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:32_00008'), 
 ('NMRS', 'MixtureComponent', 'concentration', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00025'), 
 ('NMRS', 'MixtureComponent', 'trialHits', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00023'), 
 ('NMRS', 'NmrScreen', None, 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:32_00006'), 
 ('NMRS', 'NmrScreen', 'details', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00040'), 
 ('NMRS', 'NmrScreen', 'endDate', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00039'), 
 ('NMRS', 'NmrScreen', 'mixtures', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00027'), 
 ('NMRS', 'NmrScreen', 'name', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00035'), 
 ('NMRS', 'NmrScreen', 'objective', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00037'), 
 ('NMRS', 'NmrScreen', 'sampleType', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00036'), 
 ('NMRS', 'NmrScreen', 'target', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00033'), 
 ('NMRS', 'NmrScreen', 'trialGroups', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00031'), 
 ('NMRS', 'NmrScreen', 'trials', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00029'), 
 ('NMRS', 'NmrScreenStore', None, 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:32_00002'), 
 ('NMRS', 'NmrScreenStore', 'compounds', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00042'), 
 ('NMRS', 'NmrScreenStore', 'nmrScreens', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00044'), 
 ('NMRS', 'RefSpectrum', None, 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:32_00004'), 
 ('NMRS', 'RefSpectrum', 'concentration', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00053'), 
 ('NMRS', 'RefSpectrum', 'dataSource', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00050'), 
 ('NMRS', 'RefSpectrum', 'details', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00056'), 
 ('NMRS', 'RefSpectrum', 'name', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00052'), 
 ('NMRS', 'RefSpectrum', 'pH', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00054'), 
 ('NMRS', 'RefSpectrum', 'trialHits', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00048'), 
 ('NMRS', 'Solvent', None, 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:32_00005'), 
 ('NMRS', 'Trial', None, 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:32_00009'), 
 ('NMRS', 'Trial', 'date', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:51:56_00009'), 
 ('NMRS', 'Trial', 'details', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:51:56_00010'), 
 ('NMRS', 'Trial', 'name', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:51:56_00008'), 
 ('NMRS', 'Trial', 'trialExperiments', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:51:56_00006'), 
 ('NMRS', 'Trial', 'trialGroups', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:51:56_00004'), 
 ('NMRS', 'Trial', 'trialHits', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:51:56_00002'), 
 ('NMRS', 'TrialExperiment', None, 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:32_00012'), 
 ('NMRS', 'TrialExperiment', 'dataSources', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:51:56_00012'), 
 ('NMRS', 'TrialExperiment', 'details', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:51:56_00015'), 
 ('NMRS', 'TrialExperiment', 'experimentHits', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00008'), 
 ('NMRS', 'TrialExperiment', 'name', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:51:56_00014'), 
 ('NMRS', 'TrialGroup', None, 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:32_00011'), 
 ('NMRS', 'TrialGroup', 'details', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:51:56_00018'), 
 ('NMRS', 'TrialGroup', 'name', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:51:56_00017'), 
 ('NMRS', 'TrialGroup', 'phaseType', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:51:56_00019'), 
 ('NMRS', 'TrialGroup', 'trials', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:51:56_00003'), 
 ('NMRS', 'TrialHit', None, 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:32_00010'), 
 ('NMRS', 'TrialHit', 'details', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:51:56_00025'), 
 ('NMRS', 'TrialHit', 'experimentHits', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:51:56_00021'), 
 ('NMRS', 'TrialHit', 'figOfMerit', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:51:56_00023'), 
 ('NMRS', 'TrialHit', 'meritCode', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:51:56_00024'), 
 ('NMRS', 'TrialHit', 'refSpectrums', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00047'), 
 ('NMRX', 'NmrExpPrototype', 'priority', 'www.ccpn.ac.uk_Fogh_2010-05-12-17:41:37_00001'), 
 ('SAM', 'Sample', 'mixtures', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:51:57_00002'), 
 ('WMS', 'Project', 'nmrCalcRunSerial', 'www.ccpn.ac.uk_Fogh_2010-05-06-12:26:56_00005'), 
 ('WMS', 'Project', 'nmrCalcStoreName', 'www.ccpn.ac.uk_Fogh_2010-05-06-12:26:56_00004'), 
 ('WMS', 'Project', 'rawFiles', 'www.ccpn.ac.uk_Fogh_2010-05-06-12:26:56_00002'), 
 ('WMS', 'ProjectVersion', 'summary', 'www.ccpn.ac.uk_Fogh_2010-05-06-12:26:56_00008'), 
 ('WMS', 'Task', 'nmrCalcRunSerial', 'www.ccpn.ac.uk_Fogh_2010-05-06-12:26:57_00005'), 
 ('WMS', 'Task', 'nmrCalcStoreName', 'www.ccpn.ac.uk_Fogh_2010-05-06-12:26:57_00004'), 
 ('WMS', 'Task', 'operatorId', 'www.ccpn.ac.uk_Fogh_2010-05-06-12:26:57_00002'), 
 ('WMS', 'Task', 'protocolName', 'www.ccpn.ac.uk_Fogh_2010-05-10-13:46:55_00001'), 
 ('WMS', 'Task', 'summary', 'www.ccpn.ac.uk_Fogh_2010-05-06-12:26:57_00003'), 
 ('WMS', 'WmsSegment', 'details', 'www.ccpn.ac.uk_Fogh_2010-05-06-12:26:57_00009'), 
 ('WMSP', None, None, 'www.ccpn.ac.uk_Fogh_2010-05-06-12:26:54_00001'), 
 ('WMSP', 'ProtocolAccess', None, 'www.ccpn.ac.uk_Fogh_2010-05-06-12:26:54_00005'), 
 ('WMSP', 'ProtocolAccess', 'password', 'www.ccpn.ac.uk_Fogh_2010-05-06-12:26:57_00018'), 
 ('WMSP', 'ProtocolParam', None, 'www.ccpn.ac.uk_Fogh_2010-05-06-12:26:54_00003'), 
 ('WMSP', 'ProtocolParam', 'code', 'www.ccpn.ac.uk_Fogh_2010-05-20-10:42:03_00001'), 
 ('WMSP', 'ProtocolParam', 'col', 'www.ccpn.ac.uk_Fogh_2010-05-06-13:30:17_00006'), 
 ('WMSP', 'ProtocolParam', 'colspan', 'www.ccpn.ac.uk_Fogh_2010-05-06-13:30:17_00008'), 
 ('WMSP', 'ProtocolParam', 'dependentParams', 'www.ccpn.ac.uk_Fogh_2010-05-20-14:35:13_00002'), 
 ('WMSP', 'ProtocolParam', 'groupId', 'www.ccpn.ac.uk_Fogh_2010-05-20-14:35:13_00004'), 
 ('WMSP', 'ProtocolParam', 'hicard', 'www.ccpn.ac.uk_Fogh_2010-05-06-13:30:17_00002'), 
 ('WMSP', 'ProtocolParam', 'ioRole', 'www.ccpn.ac.uk_Fogh_2010-05-20-14:35:13_00005'), 
 ('WMSP', 'ProtocolParam', 'isOrdered', 'www.ccpn.ac.uk_Fogh_2010-05-06-13:30:17_00004'), 
 ('WMSP', 'ProtocolParam', 'locard', 'www.ccpn.ac.uk_Fogh_2010-05-06-13:30:17_00003'), 
 ('WMSP', 'ProtocolParam', 'name', 'www.ccpn.ac.uk_Fogh_2010-05-06-13:30:17_00009'), 
 ('WMSP', 'ProtocolParam', 'paramType', 'www.ccpn.ac.uk_Fogh_2010-05-06-13:30:17_00001'), 
 ('WMSP', 'ProtocolParam', 'relatesTo', 'www.ccpn.ac.uk_Fogh_2010-05-20-14:35:13_00001'), 
 ('WMSP', 'ProtocolParam', 'row', 'www.ccpn.ac.uk_Fogh_2010-05-06-13:30:17_00005'), 
 ('WMSP', 'ProtocolParam', 'rowspan', 'www.ccpn.ac.uk_Fogh_2010-05-06-13:30:17_00007'), 
 ('WMSP', 'ProtocolParam', 'weight', 'www.ccpn.ac.uk_Fogh_2010-05-20-14:35:13_00006'), 
 ('WMSP', 'ProtocolService', None, 'www.ccpn.ac.uk_Fogh_2010-05-06-12:26:54_00004'), 
 ('WMSP', 'ProtocolService', 'login', 'www.ccpn.ac.uk_Fogh_2010-05-06-13:30:17_00014'), 
 ('WMSP', 'ProtocolService', 'protocolAccesss', 'www.ccpn.ac.uk_Fogh_2010-05-06-13:30:17_00011'), 
 ('WMSP', 'ProtocolService', 'result', 'www.ccpn.ac.uk_Fogh_2010-05-06-13:30:17_00017'), 
 ('WMSP', 'ProtocolService', 'run', 'www.ccpn.ac.uk_Fogh_2010-05-06-13:30:17_00015'), 
 ('WMSP', 'ProtocolService', 'status', 'www.ccpn.ac.uk_Fogh_2010-05-06-13:30:17_00016'), 
 ('WMSP', 'ProtocolService', 'url', 'www.ccpn.ac.uk_Fogh_2010-05-06-13:30:17_00013'), 
 ('WMSP', 'WmsProtocol', None, 'www.ccpn.ac.uk_Fogh_2010-05-06-12:26:54_00002'), 
 ('WMSP', 'WmsProtocol', 'details', 'www.ccpn.ac.uk_Fogh_2010-05-06-12:26:57_00015'), 
 ('WMSP', 'WmsProtocol', 'protocolParams', 'www.ccpn.ac.uk_Fogh_2010-05-06-12:26:57_00011'), 
 ('WMSP', 'WmsProtocol', 'protocolServices', 'www.ccpn.ac.uk_Fogh_2010-05-06-12:26:57_00013'), 
 ('WMSQ', None, None, 'www.ccpn.ac.uk_Fogh_2010-05-06-12:26:54_00006'), 
 ('WMSQ', 'AbstractQuery', None, 'www.ccpn.ac.uk_Fogh_2010-05-06-12:26:54_00008'), 
 ('WMSQ', 'AbstractQuery', 'userName', 'www.ccpn.ac.uk_Fogh_2010-05-06-13:30:17_00021'), 
 ('WMSQ', 'ProjectQuery', None, 'www.ccpn.ac.uk_Fogh_2010-05-06-12:26:54_00009'), 
 ('WMSQ', 'ProjectQuery', 'projectResults', 'www.ccpn.ac.uk_Fogh_2010-05-06-13:30:17_00024'), 
 ('WMSQ', 'ProjectResult', None, 'www.ccpn.ac.uk_Fogh_2010-05-06-12:26:54_00012'), 
 ('WMSQ', 'ProjectVersionQuery', None, 'www.ccpn.ac.uk_Fogh_2010-05-06-12:26:54_00010'), 
 ('WMSQ', 'ProjectVersionQuery', 'projectVersionResults', 'www.ccpn.ac.uk_Fogh_2010-05-06-13:30:17_00033'), 
 ('WMSQ', 'ProjectVersionResult', None, 'www.ccpn.ac.uk_Fogh_2010-05-06-12:26:54_00013'), 
 ('WMSQ', 'TaskQuery', None, 'www.ccpn.ac.uk_Fogh_2010-05-06-12:26:54_00011'), 
 ('WMSQ', 'TaskQuery', 'taskResults', 'www.ccpn.ac.uk_Fogh_2010-05-06-13:30:17_00043'), 
 ('WMSQ', 'TaskResult', None, 'www.ccpn.ac.uk_Fogh_2010-05-06-12:26:54_00014'), 
 ('WMSQ', 'WmsQueryStore', None, 'www.ccpn.ac.uk_Fogh_2010-05-06-12:26:54_00007'), 
 ('WMSQ', 'WmsQueryStore', 'projectQueries', 'www.ccpn.ac.uk_Fogh_2010-05-06-13:30:17_00052'), 
 ('WMSQ', 'WmsQueryStore', 'projectVersionQueries', 'www.ccpn.ac.uk_Fogh_2010-05-06-13:30:17_00054'), 
 ('WMSQ', 'WmsQueryStore', 'taskQueries', 'www.ccpn.ac.uk_Fogh_2010-05-06-13:30:17_00056'), 
]

# Class elements that exist in both models but that require handcode for
# transfer. E.g. elements that go from derived to non-derived.
# Note that old derivation functions can not be relied on to work during
# data transfer
# (prefix, typeName, elemName, newGuid, elemType)
neutraliseElements = [
]

# Differences between equivalent classElements and AbstractDataTypes :

# name changes
# (prefix, typeName, elemName, newName, newGuid
renames = [
]

# ValueType changes
# change types are : 'ignore': do nothing, 'delay': available for calculation
# (prefix, typeName, elemName, action, newGuid, elemMap, valueTypeGuid)
typeChanges = [
 ('ANAL', 'AnalysisProject', 'printWinFileName', 'delay', 'www.ccpn.ac.uk_Fogh_2008-05-05-15:12:51_00015', {'eType': 'cplx', 'tag': 'ANAL.AnalysisProject.printWinFileName', 'type': 'attr', 'name': 'printWinFileName'}, 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00035'), 
 ('ANAP', 'Macro', 'path', 'delay', 'www.ccpn.ac.uk_Fogh_2006-08-17-15:11:12_00001', {'eType': 'cplx', 'tag': 'ANAP.Macro.path', 'type': 'attr', 'name': 'path'}, 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00035'), 
 ('NMR', 'PeakDimComponent', 'scalingFactor', 'delay', 'www.ccpn.ac.uk_Fogh_2006-10-25-11:33:28_00005', {'proc': 'direct', 'tag': 'NMR.PeakDimComponent.scalingFactor', 'type': 'attr', 'name': 'scalingFactor'}, 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'), 
 ('NMRC', 'FixedResonance', 'name', 'delay', 'www.ccpn.ac.uk_Fogh_2006-08-16-18:23:11_00011', {'eType': 'cplx', 'tag': 'NMRC.FixedResonance.name', 'type': 'attr', 'name': 'name'}, 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00035'), 
]

# Different elements with matching qualifiedNames
# (element.qName, differentTags, oldGuid, newGuid
nameMatches = [
]

# Differences for matching elements, 
# excluding those where only names and/or valueTypes differ
# (oldElem.qName, newElem.name, oldGuid, newGuid, differentTags
allDiffs = [
 ('cambridge.Wms.RawFile', 'RawFile', 'www.ccpn.ac.uk_Fogh_2009-01-29-15:16:52_00004', 'www.ccpn.ac.uk_Fogh_2009-01-29-15:16:52_00004', set(['parentRole'])), 
 ('ccp.nmr.Nmr.PeakDim.realValue', 'realValue', 'www.ccpn.ac.uk_Fogh_2006-10-25-11:32:25_00001', 'www.ccpn.ac.uk_Fogh_2006-10-25-11:32:25_00001', set(['isDerived', 'documentation'])), 
 ('ccp.nmr.NmrCalc.Data', 'Data', 'www.ccpn.ac.uk_Fogh_2009-04-16-16:23:57_00006', 'www.ccpn.ac.uk_Fogh_2009-04-16-16:23:57_00006', set(['subtypes', 'supertypes', 'documentation'])), 
 ('ccp.nmr.NmrCalc.Data.ioRole', 'ioRole', 'www.ccpn.ac.uk_Fogh_2009-04-16-16:24:03_00011', 'www.ccpn.ac.uk_Fogh_2009-04-16-16:24:03_00011', set(['container'])), 
 ('ccp.nmr.NmrCalc.Data.name', 'name', 'www.ccpn.ac.uk_Fogh_2009-04-16-16:24:03_00010', 'www.ccpn.ac.uk_Fogh_2010-05-18-13:57:23_00001', set(['guid', 'container', 'documentation'])), 
 ('ccp.nmr.NmrCalc.Data.weight', 'weight', 'www.ccpn.ac.uk_Fogh_2009-04-16-16:24:03_00012', 'www.ccpn.ac.uk_Fogh_2009-04-16-16:24:03_00012', set(['container'])), 
 ('ccp.nmr.NmrCalc.ExternalData.dataStore', 'dataStore', 'www.ccpn.ac.uk_Fogh_2009-05-20-16:32:16_00005', 'www.ccpn.ac.uk_Fogh_2009-05-20-16:32:16_00005', set(['isDerived', 'otherRole'])), 
 ('ccp.nmr.NmrCalc.NmrCalcStore', 'NmrCalcStore', 'www.ccpn.ac.uk_Fogh_2009-04-16-16:23:57_00002', 'www.ccpn.ac.uk_Fogh_2009-04-16-16:23:57_00002', set(['keyNames'])), 
 ('ccp.nmr.NmrCalc.NmrCalcStore.nmrProject', 'nmrProject', 'www.ccpn.ac.uk_Fogh_2009-04-16-16:24:04_00002', 'www.ccpn.ac.uk_Fogh_2009-04-16-16:24:04_00002', set(['partitionsChildren', 'isDerived', 'changeability'])), 
 ('ccp.nmr.NmrCalc.NmrCalcStore.software', 'software', 'www.ccpn.ac.uk_Fogh_2009-04-16-16:24:04_00043', 'www.ccpn.ac.uk_Fogh_2009-04-16-16:24:04_00043', set(['isDerived', 'otherRole'])), 
 ('ccp.nmr.NmrCalc.NmrCalcStore.validationStore', 'validationStore', 'www.ccpn.ac.uk_Fogh_2009-04-16-16:24:03_00027', 'www.ccpn.ac.uk_Fogh_2009-04-16-16:24:03_00027', set(['isDerived'])), 
 ('ccp.nmr.NmrCalc.Run.operator', 'operator', 'www.ccpn.ac.uk_Fogh_2009-04-16-16:24:04_00041', 'www.ccpn.ac.uk_Fogh_2009-04-16-16:24:04_00041', set(['otherRole'])), 
 ('ccp.nmr.NmrCalc.Run.structureGeneration', 'structureGeneration', 'www.ccpn.ac.uk_Fogh_2009-04-16-16:24:04_00015', 'www.ccpn.ac.uk_Fogh_2009-04-16-16:24:04_00015', set(['isDerived'])), 
 ('ccp.nmr.NmrCalc.RunParameter', 'RunParameter', 'www.ccpn.ac.uk_Fogh_2009-04-16-16:23:58_00001', 'www.ccpn.ac.uk_Fogh_2009-04-16-16:23:58_00001', set(['supertypes'])), 
 ('ccp.nmr.NmrCalc.RunParameter.code', 'code', 'www.ccpn.ac.uk_Fogh_2009-04-16-16:24:04_00029', 'www.ccpn.ac.uk_Fogh_2010-05-05-14:35:56_00001', set(['guid', 'container', 'changeability', 'locard'])), 
 ('ccp.nmr.NmrCalc.RunParameter.groupId', 'groupId', 'www.ccpn.ac.uk_Fogh_2009-04-16-16:24:04_00031', 'www.ccpn.ac.uk_Fogh_2009-04-16-16:24:04_00031', set(['container'])), 
 ('ccp.nmr.NmrCalc.RunParameter.name', 'name', 'www.ccpn.ac.uk_Fogh_2009-04-16-16:24:04_00030', 'www.ccpn.ac.uk_Fogh_2010-05-18-13:57:23_00001', set(['guid', 'container'])), 
 ('ccp.nmr.NmrExpPrototype.ExpTransferType', 'ExpTransferType', 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:45_00029', 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:45_00029', set(['enumeration'])), 
 ('ccpnmr.Analysis.AnalysisProject.printWinTickPlacement', 'printWinTickPlacement', 'www.ccpn.ac.uk_Fogh_2008-05-05-15:12:52_00010', 'www.ccpn.ac.uk_Fogh_2008-05-05-15:12:52_00010', set(['locard'])), 
 ('ccpnmr.Analysis.PeakDrawMethod', 'PeakDrawMethod', 'www.ccpn.ac.uk_Fogh_2006-10-03-11:26:03_00002', 'www.ccpn.ac.uk_Fogh_2006-10-03-11:26:03_00002', set(['enumeration'])), 
 ('ccpnmr.Analysis.PeakFindVolumeMethod', 'PeakFindVolumeMethod', 'www.ccpn.ac.uk_Fogh_2006-10-03-11:26:03_00003', 'www.ccpn.ac.uk_Fogh_2006-10-03-11:26:03_00003', set(['enumeration'])), 
 ('ccpnmr.Analysis.PopupOption', 'PopupOption', 'www.ccpn.ac.uk_Fogh_2008-05-05-15:12:50_00002', 'www.ccpn.ac.uk_Fogh_2008-05-05-15:12:50_00002', set(['supertype', 'supertypes'])), 
 ('memops.Implementation.StorageFormat', 'StorageFormat', 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00054', 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00054', set(['enumeration'])), 
]
