"""
======================COPYRIGHT/LICENSE START==========================

General.py: Data compatibility handling

Copyright (C) 2007 Rasmus Fogh (CCPN project)
 
=======================================================================

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
A copy of this license can be found in ../../../../license/LGPL.license.
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
Lesser General Public License for more details.
 
You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

======================COPYRIGHT/LICENSE END============================

To obtain more information about this code:

- CCPN website (http://www.ccpn.ac.uk)

- contact Rasmus Fogh (ccpn@bioc.cam.ac.uk)

=======================================================================

If you are using this software for academic purposes, we suggest
quoting the following reference:

===========================REFERENCE START=============================
Rasmus H. Fogh, Wayne Boucher, Wim F. Vranken, Anne
Pajon, Tim J. Stevens, T.N. Bhat, John Westbrook, John M.C. Ionides and
Ernest D. Laue (2005). A framework for scientific data modeling and 
automated software development. Bioinformatics 21, 1678-1684.
===========================REFERENCE END===============================
 
"""
from memops.format.compatibility.downgrade.v_2_1_1 import General as General211



# functions to convert fullKeys before application
fullKeyConverters = {}
fullKeyConverters.update(General211.fullKeyConverters)

# guids of elements that should be treated as old
elemsTreatedAsOld = set((
)).union(General211.elemsTreatedAsOld)

# pairs of element guids that should be treated as matching, e.g. whe n
# a single element must match with several elements in subclasses

# these are links from MemopsRoot to individual TopObjects that all have 
# changed their guids in a model change.
elementPairings = []

class DataMatrix():
  """ Used as constructor for DataMatrix, or any object that must be 
  kept alive but out of the object tree.
  """

def extraMapChanges(globalMapping):
  """ Extra map changes specific for a given step
  """
  
  #print '@@@ in 2.1.2 extraMapChanges'
  
  # set MolStructure package to keep CML parse tree
  globalMapping['COOR']['keepXmlElements'] = True
  
  # Set StereoChemistry.stereoClass to delayed, for later processing 
  guid = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:23:25_00007'
  dd = {}
  dd['tag'] = 'CHEM.Stereochemistry.stereoClass'
  dd['type'] = 'attr'
  dd['guid'] = guid
  dd['name'] = 'stereoClass'
  dd['hicard'] = 1
  dd['locard'] = 1
  dd['data'] = globalMapping['mapsByGuid'].get('www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00037')
  dd['proc'] = 'delay'
  
  globalMapping['mapsByGuid'][guid] = dd
  globalMapping['loadMaps']['CHEM.Stereochemistry.stereoClass'] = dd
    
  # ignore type change for RefStereoChemistry.details 
  # (String->Text - should be automatically truncated)
  guid = 'www.ccpn.ac.uk_Fogh_2006-08-16-18:23:28_00023'
  globalMapping['mapsByGuid'][guid]['proc'] = 'ignore'
  #return
  
