
# Packages, classElements and AbstractDataTypes skipped in new model
# (prefix, typeName, elemName, newGuid, elemType)
skipElements = [
 ('ANA3', None, None, 'www.ccpn.ac.uk_Fogh_2011-11-16-17:07:14_00001', 'MetaPackage'), 
 ('ANAW', None, None, 'www.ccpn.ac.uk_Fogh_2011-11-30-10:49:23_00001', 'MetaPackage'), 
 ('ANAY', None, None, 'www.ccpn.ac.uk_Fogh_2011-11-30-10:49:23_00003', 'MetaPackage'), 
 ('CALC', 'Data', 'parameterGroup', 'www.ccpn.ac.uk_Fogh_2011-10-11-16:36:23_00001', 'MetaRole'), 
 ('CALC', 'FloatMatrixData', None, 'www.ccpn.ac.uk_Fogh_2011-04-05-18:08:58_00001', 'MetaClass'), 
 ('CALC', 'ParameterGroup', None, 'www.ccpn.ac.uk_Fogh_2011-10-11-16:36:17_00001', 'MetaClass'), 
 ('COOR', 'DataMatrix', None, 'www.ccpn.ac.uk_Fogh_2011-03-30-17:55:16_00001', 'MetaClass'), 
 ('COOR', 'EnsembleDataNames', None, 'www.ccpn.ac.uk_Fogh_2011-04-05-18:06:52_00001', 'MetaDataType'), 
 ('COOR', 'StructureEnsemble', 'analysisLayouts', 'www.ccpn.ac.uk_Fogh_2011-12-02-15:08:31_00003', 'MetaRole'), 
 ('COOR', 'StructureEnsemble', 'analysisPanels', 'www.ccpn.ac.uk_Fogh_2011-12-02-15:08:31_00039', 'MetaRole'), 
 ('COOR', 'StructureEnsemble', 'dataMatrices', 'www.ccpn.ac.uk_Fogh_2011-03-30-17:56:39_00031', 'MetaRole'), 
 ('IMPL', 'HexString', None, 'www.ccpn.ac.uk_Fogh_2011-12-02-09:49:50_00001', 'MetaDataType'), 
 ('IMPL', 'MemopsRoot', 'analysisProjectV3s', 'www.ccpn.ac.uk_Fogh_2011-11-30-11:04:35_00010', 'MetaRole'), 
 ('IMPL', 'MemopsRoot', 'analysisWindowStores', 'www.ccpn.ac.uk_Fogh_2011-11-30-11:04:35_00008', 'MetaRole'), 
 ('IMPL', 'MemopsRoot', 'currentAnalysisProjectV3', 'ccpn_automatic_memops.Implementation.MemopsRoot.currentAnalysisProjectV3', 'MetaRole'), 
 ('IMPL', 'MemopsRoot', 'currentAnalysisWindowStore', 'ccpn_automatic_memops.Implementation.MemopsRoot.currentAnalysisWindowStore', 'MetaRole'), 
 ('IMPL', 'MemopsRoot', 'currentLayout', 'ccpn_automatic_memops.Implementation.MemopsRoot.currentLayout', 'MetaRole'), 
 ('IMPL', 'MemopsRoot', 'currentNmrScreen', 'ccpn_automatic_memops.Implementation.MemopsRoot.currentNmrScreen', 'MetaRole'), 
 ('IMPL', 'MemopsRoot', 'currentRefDataStore', 'ccpn_automatic_memops.Implementation.MemopsRoot.currentRefDataStore', 'MetaRole'), 
 ('IMPL', 'MemopsRoot', 'layouts', 'www.ccpn.ac.uk_Fogh_2011-11-30-11:04:35_00012', 'MetaRole'), 
 ('IMPL', 'MemopsRoot', 'nmrScreens', 'ccpn_automatic_memops.Implementation.MemopsRoot.nmrScreen', 'MetaRole'), 
 ('IMPL', 'MemopsRoot', 'refDataStores', 'ccpn_automatic_memops.Implementation.MemopsRoot.refDataStore', 'MetaRole'), 
 ('IMPL', 'RgbaColor', None, 'www.ccpn.ac.uk_Fogh_2011-12-02-09:49:50_00003', 'MetaDataType'), 
 ('MOLS', 'Chain', 'analysisLayouts', 'www.ccpn.ac.uk_Fogh_2011-12-02-15:08:31_00007', 'MetaRole'), 
 ('MOLS', 'Chain', 'analysisPanel', 'www.ccpn.ac.uk_Fogh_2011-12-02-15:08:31_00035', 'MetaRole'), 
 ('MOLS', 'MolSystem', 'analysisLayouts', 'www.ccpn.ac.uk_Fogh_2011-12-02-15:08:31_00005', 'MetaRole'), 
 ('MOLS', 'MolSystem', 'analysisPanels', 'www.ccpn.ac.uk_Fogh_2011-12-02-15:08:31_00037', 'MetaRole'), 
 ('NMR', 'AbstractDataDim', 'analysisDataDims', 'www.ccpn.ac.uk_Fogh_2011-11-30-10:53:58_00001', 'MetaRole'), 
 ('NMR', 'DataSource', 'analysisLayouts', 'www.ccpn.ac.uk_Fogh_2011-12-02-15:08:31_00019', 'MetaRole'), 
 ('NMR', 'DataSource', 'analysisPanels', 'www.ccpn.ac.uk_Fogh_2011-12-02-15:08:31_00023', 'MetaRole'), 
 ('NMR', 'DataSource', 'analysisSpectra', 'www.ccpn.ac.uk_Fogh_2011-11-30-11:04:36_00002', 'MetaRole'), 
 ('NMR', 'NmrProject', 'analysisProjectV3', 'www.ccpn.ac.uk_Fogh_2011-12-01-15:00:59_00003', 'MetaRole'), 
 ('NMR', 'Peak', 'analysisLayouts', 'www.ccpn.ac.uk_Fogh_2011-12-02-15:08:31_00015', 'MetaRole'), 
 ('NMR', 'Peak', 'analysisPanels', 'www.ccpn.ac.uk_Fogh_2011-12-02-15:08:31_00027', 'MetaRole'), 
 ('NMR', 'PeakList', 'analysisLayouts', 'www.ccpn.ac.uk_Fogh_2011-12-02-15:08:31_00017', 'MetaRole'), 
 ('NMR', 'PeakList', 'analysisPanels', 'www.ccpn.ac.uk_Fogh_2011-12-02-15:08:31_00025', 'MetaRole'), 
 ('NMR', 'PeakList', 'analysisPeakLists', 'www.ccpn.ac.uk_Fogh_2011-11-30-11:04:36_00004', 'MetaRole'), 
 ('NMR', 'Resonance', 'analysisLayouts', 'www.ccpn.ac.uk_Fogh_2011-12-02-15:08:31_00011', 'MetaRole'), 
 ('NMR', 'Resonance', 'analysisPanels', 'www.ccpn.ac.uk_Fogh_2011-12-02-15:08:31_00031', 'MetaRole'), 
 ('NMR', 'ResonanceGroup', 'analysisLayouts', 'www.ccpn.ac.uk_Fogh_2011-12-02-15:08:31_00009', 'MetaRole'), 
 ('NMR', 'ResonanceGroup', 'analysisPanels', 'www.ccpn.ac.uk_Fogh_2011-12-02-15:08:31_00033', 'MetaRole'), 
 ('NMRC', 'NmrConstraintStore', 'analysisLayouts', 'www.ccpn.ac.uk_Fogh_2011-12-02-15:08:31_00013', 'MetaRole'), 
 ('NMRC', 'NmrConstraintStore', 'analysisPanels', 'www.ccpn.ac.uk_Fogh_2011-12-02-15:08:31_00029', 'MetaRole'), 
 ('NMRS', 'ComponentType', None, 'www.ccpn.ac.uk_Fogh_2012-03-28-17:18:50_00001', 'MetaDataType'), 
 ('NMRS', 'ExpCode', None, 'www.ccpn.ac.uk_Fogh_2012-05-21-18:09:06_00001', 'MetaDataType'), 
 ('NMRS', 'Mixture', 'trialExperiments', 'www.ccpn.ac.uk_Fogh_2012-03-28-17:22:44_00002', 'MetaRole'), 
 ('NMRS', 'NmrScreen', 'memopsRoot', 'ccpn_automatic_ccp.nmr.NmrScreen.NmrScreen.memopsRoot', 'MetaRole'), 
 ('NMRS', 'NmrScreen', 'trialSets', 'www.ccpn.ac.uk_Fogh_2012-05-21-18:09:12_00002', 'MetaRole'), 
 ('NMRS', 'RegionWeight', None, 'www.ccpn.ac.uk_Fogh_2012-05-21-18:09:06_00003', 'MetaClass'), 
 ('NMRS', 'Trial', 'trialSet', 'www.ccpn.ac.uk_Fogh_2012-05-21-18:09:12_00008', 'MetaRole'), 
 ('NMRS', 'TrialExperiment', 'mixture', 'www.ccpn.ac.uk_Fogh_2012-03-28-17:22:44_00001', 'MetaRole'), 
 ('NMRS', 'TrialHit', 'refNmrSpectra', 'www.ccpn.ac.uk_Fogh_2012-03-29-15:58:32_00001', 'MetaRole'), 
 ('NMRS', 'TrialSet', None, 'www.ccpn.ac.uk_Fogh_2012-05-21-18:09:06_00002', 'MetaClass'), 
 ('REFD', None, None, 'www.ccpn.ac.uk_Fogh_2012-03-28-17:19:49_00001', 'MetaPackage'), 
 ('REFS', 'RefSampleComponentStore', 'refDataStores', 'www.ccpn.ac.uk_Fogh_2012-03-28-17:22:44_00018', 'MetaRole'), 
 ('TEMP', 'FloatMatrixObject', None, 'www.ccpn.ac.uk_Fogh_2011-03-30-17:55:17_00001', 'MetaClass'), 
 ('WMSP', 'EnumValue', None, 'www.ccpn.ac.uk_Fogh_2011-03-22-17:23:22_00003', 'MetaClass'), 
 ('WMSP', 'InterfaceLabel', None, 'www.ccpn.ac.uk_Fogh_2011-10-11-16:36:18_00002', 'MetaClass'), 
 ('WMSP', 'InterfaceObject', None, 'www.ccpn.ac.uk_Fogh_2011-10-11-16:36:18_00003', 'MetaClass'), 
 ('WMSP', 'InterfaceParameter', None, 'www.ccpn.ac.uk_Fogh_2011-03-22-17:23:22_00002', 'MetaClass'), 
 ('WMSP', 'ParamType', None, 'www.ccpn.ac.uk_Fogh_2011-03-22-17:23:22_00006', 'MetaDataType'), 
 ('WMSP', 'ProtocolInterface', None, 'www.ccpn.ac.uk_Fogh_2011-03-22-17:23:22_00001', 'MetaClass'), 
 ('WMSP', 'ProtocolParameter', 'interfaceParameters', 'www.ccpn.ac.uk_Fogh_2011-03-22-17:23:24_00031', 'MetaRole'), 
 ('WMSP', 'WmsProtocol', 'protocolInterfaces', 'www.ccpn.ac.uk_Fogh_2011-03-22-17:23:24_00036', 'MetaRole'), 
]

# classElements skipped in new model, but available for simple data transfer
# (prefix, typeName, elemName, newGuid, elemMap, valueTypeGuid)
delayElements = [
 ('CALC', 'MolResidueData', 'chainCodes', 'www.ccpn.ac.uk_Fogh_2011-03-30-18:00:04_00003', {'eType': 'cplx', 'tag': 'CALC.MolResidueData.chainCodes', 'type': 'attr', 'name': 'chainCodes'}, 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00033'), 
 ('CHEM', 'AbstractChemAtom', 'coreStereochemistries', 'www.ccpn.ac.uk_Fogh_2011-03-22-17:23:27_00001', {'tag': 'CHEM.AbstractChemAtom.coreStereochemistries', 'type': 'link', 'name': 'coreStereochemistries'}, None), 
 ('CHEM', 'Stereochemistry', 'coreAtoms', 'www.ccpn.ac.uk_Fogh_2011-03-22-17:23:27_00002', {'tag': 'CHEM.Stereochemistry.coreAtoms', 'type': 'link', 'name': 'coreAtoms'}, None), 
 ('COOR', 'Atom', 'altLocationCode', 'www.ccpn.ac.uk_Fogh_2011-03-22-17:23:27_00005', {'eType': 'cplx', 'tag': 'COOR.Atom.altLocationCode', 'type': 'attr', 'name': 'altLocationCode'}, 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00033'), 
 ('COOR', 'Atom', 'index', 'www.ccpn.ac.uk_Fogh_2011-03-22-17:23:27_00006', {'proc': 'direct', 'tag': 'COOR.Atom.index', 'type': 'attr', 'name': 'index'}, 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'), 
 ('COOR', 'Model', 'index', 'www.ccpn.ac.uk_Fogh_2011-03-30-17:56:39_00013', {'proc': 'direct', 'tag': 'COOR.Model.index', 'type': 'attr', 'name': 'index'}, 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'), 
 ('COOR', 'StructureEnsemble', 'orderedAtoms', 'www.ccpn.ac.uk_Fogh_2011-04-06-17:18:19_00001', {'tag': 'COOR.StructureEnsemble.orderedAtoms', 'type': 'link', 'name': 'orderedAtoms'}, None), 
 ('COOR', 'StructureEnsemble', 'softwareName', 'www.ccpn.ac.uk_Fogh_2011-04-06-10:33:05_00003', {'tag': 'COOR.StructureEnsemble.softwareName', 'type': 'attr', 'name': 'softwareName'}, 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00037'), 
 ('NMR', 'Peak', 'height', 'www.ccpn.ac.uk_Fogh_2012-04-12-17:58:12_00001', {'tag': 'NMR.Peak.height', 'type': 'attr', 'name': 'height'}, 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00031'), 
 ('NMR', 'Peak', 'volume', 'www.ccpn.ac.uk_Fogh_2012-04-12-17:58:12_00002', {'tag': 'NMR.Peak.volume', 'type': 'attr', 'name': 'volume'}, 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00031'), 
 ('NMR', 'ResonanceGroup', 'clusterCode', 'www.ccpn.ac.uk_Fogh_2011-08-05-11:56:26_00003', {'eType': 'cplx', 'tag': 'NMR.ResonanceGroup.clusterCode', 'type': 'attr', 'name': 'clusterCode'}, 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00033'), 
 ('NMR', 'ResonanceGroup', 'isActive', 'www.ccpn.ac.uk_Fogh_2011-08-05-11:56:26_00004', {'tag': 'NMR.ResonanceGroup.isActive', 'type': 'attr', 'name': 'isActive'}, 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00028'), 
 ('NMRR', 'ChemAtomNmrDistrib', 'valuesPerPoint', 'www.ccpn.ac.uk_Fogh_2012-04-13-13:40:44_00003', {'tag': 'NMRR.ChemAtomNmrDistrib.valuesPerPoint', 'type': 'attr', 'name': 'valuesPerPoint'}, 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00031'), 
 ('NMRS', 'ExperimentHit', 'normalisedChange', 'www.ccpn.ac.uk_Fogh_2012-04-18-15:31:23_00001', {'tag': 'NMRS.ExperimentHit.normalisedChange', 'type': 'attr', 'name': 'normalisedChange'}, 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00031'), 
 ('NMRS', 'MixtureComponent', 'componentName', 'www.ccpn.ac.uk_Fogh_2012-03-28-17:22:44_00004', {'eType': 'cplx', 'tag': 'NMRS.MixtureComponent.componentName', 'type': 'attr', 'name': 'componentName'}, 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00033'), 
 ('NMRS', 'MixtureComponent', 'componentType', 'www.ccpn.ac.uk_Fogh_2012-03-28-17:22:44_00005', {'tag': 'NMRS.MixtureComponent.componentType', 'type': 'attr', 'name': 'componentType'}, 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00037'), 
 ('NMRS', 'NmrScreen', 'refDataStoreNames', 'www.ccpn.ac.uk_Fogh_2012-04-12-17:58:11_00001', {'eType': 'cplx', 'tag': 'NMRS.NmrScreen.refDataStoreNames', 'type': 'attr', 'name': 'refDataStoreNames'}, 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00033'), 
 ('NMRS', 'TrialExperiment', 'expCode', 'www.ccpn.ac.uk_Fogh_2012-05-21-18:09:12_00007', {'eType': 'cplx', 'tag': 'NMRS.TrialExperiment.expCode', 'type': 'attr', 'name': 'expCode'}, 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00033'), 
 ('NMRS', 'TrialHit', 'componentName', 'www.ccpn.ac.uk_Fogh_2012-03-28-17:22:44_00011', {'eType': 'cplx', 'tag': 'NMRS.TrialHit.componentName', 'type': 'attr', 'name': 'componentName'}, 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00033'), 
 ('NMRS', 'TrialHit', 'isConfirmed', 'www.ccpn.ac.uk_Fogh_2012-05-18-12:04:57_00001', {'tag': 'NMRS.TrialHit.isConfirmed', 'type': 'attr', 'name': 'isConfirmed'}, 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00028'), 
 ('SAM', 'AbstractSample', 'solvent', 'www.ccpn.ac.uk_Fogh_2012-03-28-17:22:44_00014', {'eType': 'cplx', 'tag': 'SAM.AbstractSample.solvent', 'type': 'attr', 'name': 'solvent'}, 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:32_00005'), 
 ('STER', 'RefStereochemistry', 'numCoreAtoms', 'www.ccpn.ac.uk_Fogh_2011-03-22-17:23:26_00001', {'proc': 'direct', 'tag': 'STER.RefStereochemistry.numCoreAtoms', 'type': 'attr', 'name': 'numCoreAtoms'}, 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'), 
 ('SYMM', 'MolSystemSymmetrySet', 'details', 'www.ccpn.ac.uk_Fogh_2011-08-05-11:53:29_00002', {'eType': 'cplx', 'tag': 'SYMM.MolSystemSymmetrySet.details', 'type': 'attr', 'name': 'details'}, 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00036'), 
 ('SYMM', 'MolSystemSymmetrySet', 'name', 'www.ccpn.ac.uk_Fogh_2011-08-05-11:53:29_00001', {'eType': 'cplx', 'tag': 'SYMM.MolSystemSymmetrySet.name', 'type': 'attr', 'name': 'name'}, 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00033'), 
 ('WMSP', 'ProtocolParameter', 'defaultStrings', 'www.ccpn.ac.uk_Fogh_2011-03-22-17:23:24_00008', {'eType': 'cplx', 'tag': 'WMSP.ProtocolParameter.defaultStrings', 'type': 'attr', 'name': 'defaultStrings'}, 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00035'), 
 ('WMSP', 'ProtocolParameter', 'hicard', 'www.ccpn.ac.uk_Fogh_2011-06-09-13:36:54_00002', {'proc': 'direct', 'tag': 'WMSP.ProtocolParameter.hicard', 'type': 'attr', 'name': 'hicard'}, 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00032'), 
 ('WMSP', 'ProtocolParameter', 'locard', 'www.ccpn.ac.uk_Fogh_2011-06-09-13:36:54_00001', {'tag': 'WMSP.ProtocolParameter.locard', 'type': 'attr', 'name': 'locard'}, 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:54_00011'), 
 ('WMSP', 'WmsProtocol', 'annealProtocolCode', 'www.ccpn.ac.uk_Fogh_2011-08-05-11:53:29_00005', {'eType': 'cplx', 'tag': 'WMSP.WmsProtocol.annealProtocolCode', 'type': 'attr', 'name': 'annealProtocolCode'}, 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00033'), 
 ('WMSP', 'WmsProtocol', 'annealProtocolStoreName', 'www.ccpn.ac.uk_Fogh_2011-08-05-11:53:29_00004', {'eType': 'cplx', 'tag': 'WMSP.WmsProtocol.annealProtocolStoreName', 'type': 'attr', 'name': 'annealProtocolStoreName'}, 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00033'), 
 ('WMSP', 'WmsProtocol', 'softwareName', 'www.ccpn.ac.uk_Fogh_2011-03-22-17:23:24_00038', {'eType': 'cplx', 'tag': 'WMSP.WmsProtocol.softwareName', 'type': 'attr', 'name': 'softwareName'}, 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00033'), 
 ('WMSP', 'WmsProtocol', 'softwareVersion', 'www.ccpn.ac.uk_Fogh_2011-03-22-17:23:24_00039', {'eType': 'cplx', 'tag': 'WMSP.WmsProtocol.softwareVersion', 'type': 'attr', 'name': 'softwareVersion'}, 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00033'), 
]

# MetaConstraints added in new model
# (qualifiedName, guid)
newConstraints = [
 ('ccp.molecule.ChemComp.Stereochemistry.value.value_must_be_in_refStereochemistry_values', 'www.ccpn.ac.uk_Fogh_2006-08-16-18:23:25_00006'), 
 ('ccp.nmr.Nmr.Experiment.only_one_Labeling_per_molecule', 'www.ccpn.ac.uk_Fogh_2006-10-24-18:34:48_00001'), 
 ('ccp.nmr.NmrConstraint.CsaConstraint.resonance.value_isotopeCode_eq_self_parentList_isotopeCode', 'www.ccpn.ac.uk_Fogh_2013-05-03-11:50:04_00001'), 
 ('memops.Implementation.AbstractMatrix.matrix_size_eq_data_size', 'www.ccpn.ac.uk_Fogh_2010-05-12-17:30:22_00002'), 
 ('memops.Implementation.RgbColor.RGB_color_format', 'www.ccpn.ac.uk_Fogh_2008-05-05-15:12:50_00009'), 
]

# Mandatory classElements added in new model
# New ClassElements with locard !=0, no default, not derived or Implementation
# (prefix, typeName, elemName, newGuid)
newMandatories = [
 ('CALC', 'DefaultParameter', 'code', 'www.ccpn.ac.uk_Fogh_2009-04-16-16:24:03_00014'), 
 ('CALC', 'DefaultParameter', 'nmrCalcStore', 'www.ccpn.ac.uk_Fogh_2009-04-16-16:24:04_00003'), 
 ('IMPL', 'AbstractMatrix', 'data', 'www.ccpn.ac.uk_Fogh_2010-05-13-14:38:45_00001'), 
 ('IMPL', 'AbstractMatrix', 'shape', 'www.ccpn.ac.uk_Fogh_2010-05-12-17:30:25_00001'), 
 ('IMPL', 'BooleanMatrix', 'data', 'www.ccpn.ac.uk_Fogh_2010-05-12-17:39:28_00003'), 
 ('IMPL', 'FloatMatrix', 'data', 'www.ccpn.ac.uk_Fogh_2010-05-12-17:41:35_00001'), 
 ('IMPL', 'IntMatrix', 'data', 'www.ccpn.ac.uk_Fogh_2010-05-12-17:41:35_00002'), 
 ('IMPL', 'StringMatrix', 'data', 'www.ccpn.ac.uk_Fogh_2010-05-12-17:41:35_00003'), 
 ('NMRR', 'ChemAtomNmrDistrib', 'shiftDistribution', 'www.ccpn.ac.uk_Fogh_2010-05-14-15:28:27_00002'), 
 ('NMRS', 'Compound', 'code', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00005'), 
 ('NMRS', 'Compound', 'nmrScreenStore', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00041'), 
 ('NMRS', 'MixtureComponent', 'compound', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00003'), 
 ('NMRS', 'NmrScreen', 'nmrScreenStore', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00043'), 
 ('NMRS', 'NmrScreenStore', 'code', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00045'), 
 ('NMRS', 'NmrScreenStore', 'memopsRoot', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:34_00001'), 
 ('NMRS', 'NmrScreenStore', 'name', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00046'), 
 ('NMRS', 'RefSpectrum', 'compound', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00001'), 
 ('NMRS', 'Trial', 'nmrScreen', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00028'), 
 ('NMRS', 'TrialExperiment', 'trial', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:51:56_00005'), 
]

# Packages, classElements and AbstractDataTypes added in new model
# Optional, i.e. excluding mandatory classElements given above
# (prefix, typeName, elemName, newGuid)
newElements = [
 ('ANAL', 'SpectrumWindow', 'isZeroLineShown', 'www.ccpn.ac.uk_Fogh_2013-05-03-11:50:01_00001'), 
 ('ANAL', 'SpectrumWindowView', 'isContourLineVisible', 'www.ccpn.ac.uk_Fogh_2013-05-07-17:07:06_00001'), 
 ('CALC', 'DefaultParameter', None, 'www.ccpn.ac.uk_Fogh_2009-04-16-16:23:57_00003'), 
 ('CALC', 'DefaultParameter', 'groupId', 'www.ccpn.ac.uk_Fogh_2009-04-16-16:24:03_00016'), 
 ('CALC', 'DefaultParameter', 'name', 'www.ccpn.ac.uk_Fogh_2009-04-16-16:24:03_00015'), 
 ('CALC', 'EnergyTerm', 'constraintLists', 'www.ccpn.ac.uk_Fogh_2010-05-18-17:35:48_00002'), 
 ('CALC', 'MatrixData', None, 'www.ccpn.ac.uk_Fogh_2010-05-13-18:08:24_00001'), 
 ('CALC', 'MatrixData', 'floatMatrix', 'www.ccpn.ac.uk_Fogh_2010-05-13-18:08:28_00001'), 
 ('CALC', 'MatrixData', 'intMatrix', 'www.ccpn.ac.uk_Fogh_2010-05-13-18:08:28_00002'), 
 ('CALC', 'NmrCalcStore', 'defaultParameters', 'www.ccpn.ac.uk_Fogh_2009-04-16-16:24:04_00004'), 
 ('CALC', 'RunIo', 'groupId', 'www.ccpn.ac.uk_Fogh_2009-04-16-16:24:04_00031'), 
 ('CALC', 'RunIo', 'weight', 'www.ccpn.ac.uk_Fogh_2009-04-16-16:24:03_00012'), 
 ('IMPL', 'AbstractMatrix', None, 'www.ccpn.ac.uk_Fogh_2010-05-12-17:30:22_00001'), 
 ('IMPL', 'BooleanMatrix', None, 'www.ccpn.ac.uk_Fogh_2010-05-12-17:30:22_00005'), 
 ('IMPL', 'FloatMatrix', None, 'www.ccpn.ac.uk_Fogh_2010-05-12-17:30:22_00003'), 
 ('IMPL', 'IntMatrix', None, 'www.ccpn.ac.uk_Fogh_2010-05-12-17:30:22_00004'), 
 ('IMPL', 'MemopsRoot', 'currentNmrScreenStore', 'ccpn_automatic_memops.Implementation.MemopsRoot.currentNmrScreenStore'), 
 ('IMPL', 'MemopsRoot', 'nmrScreenStores', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:34_00002'), 
 ('IMPL', 'StringMatrix', None, 'www.ccpn.ac.uk_Fogh_2010-05-12-17:30:22_00006'), 
 ('MOLE', 'Molecule', 'compounds', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:51:56_00027'), 
 ('NMRC', 'AbstractConstraintList', 'energyTerms', 'www.ccpn.ac.uk_Fogh_2010-05-18-17:35:48_00001'), 
 ('NMRS', 'Compound', None, 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:32_00003'), 
 ('NMRS', 'Compound', 'details', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00007'), 
 ('NMRS', 'Compound', 'mixtureComponents', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00004'), 
 ('NMRS', 'Compound', 'molecule', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:51:56_00026'), 
 ('NMRS', 'Compound', 'name', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00006'), 
 ('NMRS', 'Compound', 'refSpectrums', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00002'), 
 ('NMRS', 'Mixture', 'pH', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00019'), 
 ('NMRS', 'Mixture', 'solvent', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00020'), 
 ('NMRS', 'Mixture', 'volume', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00018'), 
 ('NMRS', 'MixtureComponent', 'concentration', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00025'), 
 ('NMRS', 'NmrScreen', 'trials', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00029'), 
 ('NMRS', 'NmrScreenStore', None, 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:32_00002'), 
 ('NMRS', 'NmrScreenStore', 'compounds', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00042'), 
 ('NMRS', 'NmrScreenStore', 'nmrScreens', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00044'), 
 ('NMRS', 'RefSpectrum', None, 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:32_00004'), 
 ('NMRS', 'RefSpectrum', 'trialHits', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00048'), 
 ('NMRS', 'Trial', 'trialExperiments', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:51:56_00006'), 
 ('NMRS', 'TrialHit', 'refSpectrums', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00047'), 
 ('WMSP', 'ProtocolParam', 'col', 'www.ccpn.ac.uk_Fogh_2010-05-06-13:30:17_00006'), 
 ('WMSP', 'ProtocolParam', 'colspan', 'www.ccpn.ac.uk_Fogh_2010-05-06-13:30:17_00008'), 
 ('WMSP', 'ProtocolParam', 'groupId', 'www.ccpn.ac.uk_Fogh_2010-05-20-14:35:13_00004'), 
 ('WMSP', 'ProtocolParam', 'hicard', 'www.ccpn.ac.uk_Fogh_2010-05-06-13:30:17_00002'), 
 ('WMSP', 'ProtocolParam', 'isOrdered', 'www.ccpn.ac.uk_Fogh_2010-05-06-13:30:17_00004'), 
 ('WMSP', 'ProtocolParam', 'locard', 'www.ccpn.ac.uk_Fogh_2010-05-06-13:30:17_00003'), 
 ('WMSP', 'ProtocolParam', 'row', 'www.ccpn.ac.uk_Fogh_2010-05-06-13:30:17_00005'), 
 ('WMSP', 'ProtocolParam', 'rowspan', 'www.ccpn.ac.uk_Fogh_2010-05-06-13:30:17_00007'), 
 ('WMSP', 'ProtocolParam', 'weight', 'www.ccpn.ac.uk_Fogh_2010-05-20-14:35:13_00006'), 
]

# Class elements that exist in both models but that require handcode for
# transfer. E.g. elements that go from derived to non-derived.
# Note that old derivation functions can not be relied on to work during
# data transfer
# (prefix, typeName, elemName, newGuid, elemType)
neutraliseElements = [
 ('CALC', 'MolResidueData', 'chainCode', 'www.ccpn.ac.uk_Fogh_2009-05-20-16:32:16_00010'), 
 ('CHEM', 'Stereochemistry', 'refStereochemistry', 'www.ccpn.ac.uk_Fogh_2006-08-16-18:23:25_00003'), 
 ('COOR', 'Coord', 'altLocationCode', 'www.ccpn.ac.uk_Fogh_2006-08-16-18:23:36_00042'), 
 ('COOR', 'Coord', 'bFactor', 'www.ccpn.ac.uk_Fogh_2006-08-16-18:23:36_00046'), 
 ('COOR', 'Coord', 'occupancy', 'www.ccpn.ac.uk_Fogh_2006-08-16-18:23:36_00047'), 
 ('COOR', 'Coord', 'x', 'www.ccpn.ac.uk_Fogh_2006-08-16-18:23:36_00043'), 
 ('COOR', 'Coord', 'y', 'www.ccpn.ac.uk_Fogh_2006-08-16-18:23:36_00044'), 
 ('COOR', 'Coord', 'z', 'www.ccpn.ac.uk_Fogh_2006-08-16-18:23:36_00045'), 
 ('NMRS', 'MixtureComponent', 'trialHits', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00023'), 
 ('NMRS', 'TrialHit', 'mixtureComponent', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00022'), 
]

# Differences between equivalent classElements and AbstractDataTypes :

# name changes
# (prefix, typeName, elemName, newName, newGuid
renames = [
 ('CALC', 'SpinSystemData', 'resonanceGroupSerials', 'resonanceGroupSerial', 'www.ccpn.ac.uk_Fogh_2009-05-20-16:32:16_00038'), 
 ('NMR', 'Experiment', 't1RhoList', 't1rhoList', 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:13_00019'), 
 ('NMR', 'T1RhoList', None, 'T1rhoList', 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:48_00020'), 
 ('NMR', 'T1RhoList', 'coherenceType', 'T1RhoList', 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:13_00023'), 
 ('NMR', 'T1RhoList', 'experiments', 'T1RhoList', 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:13_00020'), 
 ('NMR', 'T1RhoList', 'measurements', 'T1RhoList', 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:13_00018'), 
 ('NMR', 'T1RhoList', 'sf', 'T1RhoList', 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:13_00022'), 
 ('NMR', 'T1RhoList', 'tempCalibMethod', 'T1RhoList', 'www.ccpn.ac.uk_Fogh_2009-02-05-11:33:18_00001'), 
 ('NMR', 'T1RhoList', 'tempControlMethod', 'T1RhoList', 'www.ccpn.ac.uk_Fogh_2009-02-05-11:33:18_00002'), 
 ('NMR', 'T1RhoList', 'unit', 'T1RhoList', 'www.ccpn.ac.uk_Fogh_2006-08-16-18:20:13_00021'), 
 ('NMRS', 'Mixture', 'trial', 'trials', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00015'), 
 ('NMRS', 'Trial', 'mixtures', 'mixture', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00014'), 
 ('WMSP', 'ProtocolParameter', None, 'ProtocolParam', 'www.ccpn.ac.uk_Fogh_2010-05-06-12:26:54_00003'), 
 ('WMSP', 'ProtocolParameter', 'code', 'ProtocolParameter', 'www.ccpn.ac.uk_Fogh_2010-05-20-10:42:03_00001'), 
 ('WMSP', 'ProtocolParameter', 'container', 'relatesTo', 'www.ccpn.ac.uk_Fogh_2010-05-20-14:35:13_00001'), 
 ('WMSP', 'ProtocolParameter', 'content', 'dependentParams', 'www.ccpn.ac.uk_Fogh_2010-05-20-14:35:13_00002'), 
 ('WMSP', 'ProtocolParameter', 'ioRole', 'ProtocolParameter', 'www.ccpn.ac.uk_Fogh_2010-05-20-14:35:13_00005'), 
 ('WMSP', 'ProtocolParameter', 'name', 'ProtocolParameter', 'www.ccpn.ac.uk_Fogh_2010-05-06-13:30:17_00009'), 
 ('WMSP', 'ProtocolParameter', 'paramType', 'ProtocolParameter', 'www.ccpn.ac.uk_Fogh_2010-05-06-13:30:17_00001'), 
 ('WMSP', 'ProtocolParameter', 'serial', 'ProtocolParameter', 'www.ccpn.ac.uk_Fogh_2010-05-06-12:26:57_00019'), 
 ('WMSP', 'ProtocolParameter', 'wmsProtocol', 'ProtocolParameter', 'www.ccpn.ac.uk_Fogh_2010-05-06-12:26:57_00010'), 
 ('WMSP', 'WmsProtocol', 'protocolParameters', 'protocolParams', 'www.ccpn.ac.uk_Fogh_2010-05-06-12:26:57_00011'), 
]

# ValueType changes
# change types are : 'ignore': do nothing, 'delay': available for calculation
# (prefix, typeName, elemName, action, newGuid, elemMap, valueTypeGuid)
typeChanges = [
 ('STER', 'RefStereochemistry', 'details', 'delay', 'www.ccpn.ac.uk_Fogh_2006-08-16-18:23:28_00023', {'eType': 'cplx', 'proc': 'direct', 'tag': 'STER.RefStereochemistry.details', 'type': 'attr', 'name': 'details'}, 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:53_00035'), 
]

# Different elements with matching qualifiedNames
# (element.qName, differentTags, oldGuid, newGuid
nameMatches = [
]

# Differences for matching elements, 
# excluding those where only names and/or valueTypes differ
# (oldElem.qName, newElem.name, oldGuid, newGuid, differentTags
allDiffs = [
 ('cambridge.WmsProtocol.ProtocolParameter.ioRole', 'ioRole', 'www.ccpn.ac.uk_Fogh_2010-05-20-14:35:13_00005', 'www.ccpn.ac.uk_Fogh_2010-05-20-14:35:13_00005', set(['defaultValue', 'locard'])), 
 ('cambridge.WmsProtocol.ProtocolParameter.paramType', 'paramType', 'www.ccpn.ac.uk_Fogh_2010-05-06-13:30:17_00001', 'www.ccpn.ac.uk_Fogh_2010-05-06-13:30:17_00001', set(['documentation', 'locard'])), 
 ('ccp.lims.Holder.Holder.holderCategories', 'holderCategories', 'www.ccpn.ac.uk_Fogh_2006-08-16-18:23:27_00006', 'www.ccpn.ac.uk_Fogh_2006-08-16-18:23:27_00006', set(['locard'])), 
 ('ccp.lims.RefData.RefNmrSpectrum.concentration', 'concentration', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00053', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00053', set(['container'])), 
 ('ccp.lims.RefData.RefNmrSpectrum.dataSource', 'dataSource', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00050', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00050', set(['container'])), 
 ('ccp.lims.RefData.RefNmrSpectrum.details', 'details', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00056', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00056', set(['container'])), 
 ('ccp.lims.RefData.RefNmrSpectrum.name', 'name', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00052', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00052', set(['container'])), 
 ('ccp.lims.RefData.RefNmrSpectrum.pH', 'pH', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00054', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00054', set(['container'])), 
 ('ccp.lims.RefData.RefNmrSpectrum.serial', 'serial', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00051', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00051', set(['container'])), 
 ('ccp.lims.RefData.RefNmrSpectrum.solvent', 'solvent', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00055', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00055', set(['container'])), 
 ('ccp.lims.Sample.AbstractSample.sampleCategories', 'sampleCategories', 'www.ccpn.ac.uk_Fogh_2006-08-16-18:22:46_00003', 'www.ccpn.ac.uk_Fogh_2006-08-16-18:22:46_00003', set(['locard'])), 
 ('ccp.lims.Sample.Solvent', 'Solvent', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:32_00005', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:32_00005', set(['container', 'enumeration'])), 
 ('ccp.molecule.MolStructure.Atom', 'Atom', 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:55_00004', 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:55_00004', set(['destructorCodeStubs', 'constructorCodeStubs', 'keyNames'])), 
 ('ccp.molecule.MolStructure.Coord', 'Coord', 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:55_00001', 'www.ccpn.ac.uk_Fogh_2006-08-16-14:22:55_00001', set(['isDerived', 'keyNames'])), 
 ('ccp.molecule.MolStructure.Model', 'Model', 'www.ccpn.ac.uk_Fogh_2007-11-23-12:00:10_00001', 'www.ccpn.ac.uk_Fogh_2007-11-23-12:00:10_00001', set(['postDestructorCodeStubs', 'constructorCodeStubs'])), 
 ('ccp.molecule.Stereochemistry.RefStereochemistry.values', 'values', 'www.ccpn.ac.uk_Fogh_2006-08-16-18:23:28_00022', 'www.ccpn.ac.uk_Fogh_2006-08-16-18:23:28_00022', set(['locard'])), 
 ('ccp.nmr.NmrCalc.EnergyTerm', 'EnergyTerm', 'www.ccpn.ac.uk_Fogh_2010-05-18-17:35:44_00001', 'www.ccpn.ac.uk_Fogh_2010-05-18-17:35:44_00001', set(['supertype', 'supertypes'])), 
 ('ccp.nmr.NmrCalc.SpinSystemData.resonanceGroupSerials', 'resonanceGroupSerial', 'www.ccpn.ac.uk_Fogh_2009-05-20-16:32:16_00038', 'www.ccpn.ac.uk_Fogh_2009-05-20-16:32:16_00038', set(['hicard', 'isOrdered', 'name', 'documentation', 'isUnique', 'locard'])), 
 ('ccp.nmr.NmrReference.ChemAtomNmrDistrib', 'ChemAtomNmrDistrib', 'www.ccpn.ac.uk_Fogh_2010-05-14-15:28:22_00001', 'www.ccpn.ac.uk_Fogh_2010-05-14-15:28:22_00001', set(['supertypes', 'documentation'])), 
 ('ccp.nmr.NmrReference.ChemAtomNmrDistrib.refAtoms', 'refAtoms', 'www.ccpn.ac.uk_Fogh_2010-05-14-17:17:46_00001', 'www.ccpn.ac.uk_Fogh_2010-05-14-17:17:46_00001', set(['changeability'])), 
 ('ccp.nmr.NmrScreen.NmrScreen', 'NmrScreen', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:32_00006', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:32_00006', set(['supertype', 'parentRole', 'partitionsChildren', 'supertypes'])), 
 ('ccp.nmr.NmrScreen.NmrScreen.startDate', 'startDate', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00038', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00038', set(['locard'])), 
 ('ccp.nmr.NmrScreen.Trial', 'Trial', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:32_00009', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:32_00009', set(['parentRole'])), 
 ('ccp.nmr.NmrScreen.Trial.mixtures', 'mixture', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00014', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:38_00014', set(['hicard', 'name', 'locard'])), 
 ('ccp.nmr.NmrScreen.TrialExperiment', 'TrialExperiment', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:32_00012', 'www.ccpn.ac.uk_Fogh_2009-11-19-14:50:32_00012', set(['parentRole'])), 
 ('ccpnmr.Analysis.PeakDrawMethod', 'PeakDrawMethod', 'www.ccpn.ac.uk_Fogh_2006-10-03-11:26:03_00002', 'www.ccpn.ac.uk_Fogh_2006-10-03-11:26:03_00002', set(['enumeration'])), 
 ('ccpnmr.Analysis.PeakFindVolumeMethod', 'PeakFindVolumeMethod', 'www.ccpn.ac.uk_Fogh_2006-10-03-11:26:03_00003', 'www.ccpn.ac.uk_Fogh_2006-10-03-11:26:03_00003', set(['enumeration'])), 
 ('memops.Implementation.RgbColor', 'RgbColor', 'www.ccpn.ac.uk_Fogh_2008-05-05-15:12:50_00007', 'www.ccpn.ac.uk_Fogh_2008-05-05-15:12:50_00007', set(['supertype', 'supertypes', 'documentation'])), 
]
