"""
#######################################################################

CCPN Data Model version 2.0.6

Autogenerated by PyFileApiGen revision 1.57 on Wed Aug  7 15:07:02 2013
  from data model element memops.Implementation revision 1.64

#######################################################################
======================COPYRIGHT/LICENSE START==========================

Implementation.py: python API for CCPN data model, MetaPackage memops.Implementation

Copyright (C) 2007  (CCPN Project)

=======================================================================

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
A copy of this license can be found in ../../../license/LGPL.license
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
Lesser General Public License for more details.
 
You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA


======================COPYRIGHT/LICENSE END============================

for further information, please contact :

- CCPN website (http://www.ccpn.ac.uk/)

- email: ccpn@bioc.cam.ac.uk

=======================================================================

If you are using this software for academic purposes, we suggest
quoting the following references:

===========================REFERENCE START=============================
Rasmus H. Fogh, Wayne Boucher, Wim F. Vranken, Anne
Pajon, Tim J. Stevens, T.N. Bhat, John Westbrook, John M.C. Ionides and
Ernest D. Laue (2005). A framework for scientific data modeling and automated
software development. Bioinformatics 21, 1678-1684.


This file was generated with the Memops software generation framework,
and contains original contributions embedded in the framework

===========================REFERENCE END===============================
"""

import cStringIO
#import sets
import traceback
import types
import operator

# special function for fast whitespace checking.
# used in DataType Word and Token handcode
import re
containsWhitespace = re.compile('\s').search
containsNonAlphanumeric = re.compile('[^a-zA-Z0-9_]').search
 
from memops.general import Implementation as implementation
ApiError = implementation.ApiError

# imported packages:

from memops.metamodel import XmlModelIo
topPackage = XmlModelIo.readModel(checkValidity=False)
metaPackage = topPackage.metaObjFromQualName('memops.Implementation')
from memops.general.baseDataTypes import Any
from memops.general.baseDataTypes import Boolean
from memops.general.baseDataTypes import Dict
from memops.general.baseDataTypes import Double
from memops.general.baseDataTypes import Float
from memops.general.baseDataTypes import Int
from memops.general.baseDataTypes import Long
from memops.general.baseDataTypes import String

###############################################################################
class ComplexDataType(object):
  r"""Topmost Superclass of both classes and complex datatype objects. 
Contains some implementation attributes
  """
  #   from data model element memops.Implementation.ComplexDataType revision 1.25
  _metaclass = metaPackage.getElement('ComplexDataType')
  _packageName = 'memops.Implementation'
  _packageShortName = 'IMPL'
  _fieldNames = ('className', 'fieldNames', 'inConstructor', 'metaclass', 'packageName', 'packageShortName', 'qualifiedName',)
  
  def __init__(self, **attrlinks):
    """
    Constructor for memops.Implementation.ComplexDataType
    """
    dataDict = self.__dict__
    raise ApiError("""%s.__init__:
     __init__ should never be called - must be overridden in subclass""" % self.qualifiedName
     + ": %s" % (self,)
    )
  
  def checkAllValid(self, complete=False):
    """
    CheckAllValid for memops.Implementation.ComplexDataType
    """
    dataDict = self.__dict__
    raise ApiError("""%s.checkAllValid:
     checkAllValid should never be called - must be overridden in subclass""" % self.qualifiedName
     + ": %s" % (self,)
    )
  
  def checkValid(self, complete=False):
    """
    CheckValid for memops.Implementation.ComplexDataType
    """
    dataDict = self.__dict__
    raise ApiError("""%s.checkValid:
     checkValid should never be called - must be overridden in subclass""" % self.qualifiedName
     + ": %s" % (self,)
    )
  
  def getClassName(self):
    """
    Get for memops.Implementation.ComplexDataType.className
    """
    dataDict = self.__dict__
    result = self.__class__.__name__
    return result
  
  def getFieldNames(self):
    """
    Get for memops.Implementation.ComplexDataType.fieldNames
    """
    dataDict = self.__dict__
    result = self.__class__._fieldNames
    result = tuple(result)
    return result
  
  def getInConstructor(self):
    """
    Get for memops.Implementation.ComplexDataType.inConstructor
    """
    dataDict = self.__dict__
    result = bool(dataDict.get('inConstructor'))
    return result
  
  def getMetaclass(self):
    """
    Get for memops.Implementation.ComplexDataType.metaclass
    """
    dataDict = self.__dict__
    result = self.__class__._metaclass
    return result
  
  def getPackageName(self):
    """
    Get for memops.Implementation.ComplexDataType.packageName
    """
    dataDict = self.__dict__
    result = self.__class__._packageName
    return result
  
  def getPackageShortName(self):
    """
    Get for memops.Implementation.ComplexDataType.packageShortName
    """
    dataDict = self.__dict__
    result = self.__class__._packageShortName
    return result
  
  def getQualifiedName(self):
    """
    getter for derived attribute qualifiedName
    """
    dataDict = self.__dict__
    result = '.'.join((self.__class__._packageName, self.__class__.__name__))
    return result
  
  def toDetailedString(self):
    """
    Return object with all its contents as a detailed, multiline string
    """
    dataDict = self.__dict__
    ll = ['{']
    for ss in self.fieldNames:
      val = getattr(self,ss)
      if isinstance(val, frozenset) or isinstance(val, tuple):
        ll.append("'%s': <collection of length %s>,\n" % (ss, len(val)))
      else: 
        ll.append("'%s':%s,\n" % (ss, val))
    ll.append('}')
    #
    result = ''.join(ll)
    return result
  
  className = property(getClassName, None, None,
  r"""Name of class of object. If class names differ for different 
  implementations, name of the coresponding Python class. This is really a 
  class attribute and may be implemented as such by languages that support 
  the concept.
  """)
  
  fieldNames = property(getFieldNames, None, None,
  r"""Names of all object fields in alphabetical order. Attribute names and 
  role  names (where relevant) are given in alphabetical order (for each 
  type). 
  
  If you need more information about the classes, the place to 
  look is in the obejct .metaclass MetaModel object.
  """)
  
  inConstructor = property(getInConstructor, None, None,
  r"""Implementation switch that determines if an object is being constructed, 
  and turns off some validity checking.
  """)
  
  metaclass = property(getMetaclass, None, None,
  r"""metaclass: MetaModel object containing class description
  """)
  
  packageName = property(getPackageName, None, None,
  r"""Name of package containing class, as a dot-separated string. E.g. 
  'ccp.nmr.Nmr'. This is really a class attribute and may be implemented 
  as such by languages that support the concept.
  """)
  
  packageShortName = property(getPackageShortName, None, None,
  r"""Short name of package containing class, generally as four or fewer upper 
  case characters. E.g. 'NMRC'. Package shortnames are unique across 
  packages. They are not set (value None) for packages that contain other 
  packages. This is really a class attribute and may be implemented as 
  such by languages that support the concept.1
  """)
  
  qualifiedName = property(getQualifiedName, None, None,
  r"""Fully qualified name of class, equal to (packageName + '.' + className). 
  If class names differ between implementations, name of corresponding 
  Python class. This is really a class attribute and may be implemented as 
  such by languages that support the concept.
  """)

###############################################################################
class MemopsDataTypeObject(ComplexDataType):
  r"""Superclass for DataObjTypes
  """
  #   from data model element memops.Implementation.MemopsDataTypeObject revision 1.47
  _metaclass = metaPackage.getElement('MemopsDataTypeObject')
  _packageName = 'memops.Implementation'
  _packageShortName = 'IMPL'
  _fieldNames = ('className', 'fieldNames', 'inConstructor', 'metaclass', 'override', 'packageName', 'packageShortName', 'qualifiedName',)
  
  def __hash__(self):
    """
     basic hash function. NB inConstructor is automatically excluded
    """
    dataDict = self.__dict__
    tt = (self.getQualifiedName(),tuple((x, dataDict[x]) for x in sorted(dataDict)))
    return hash(tt)
  
  def __cmp__(self, value):
    """
     basic compare function. NB inConstructor is automatically excluded
    """
    if (isinstance(value, MemopsDataTypeObject)):
      dataDict = self.__dict__
      selfKey = (self.getQualifiedName(),tuple((x, dataDict[x]) for x in sorted(dataDict)))
      valueKey = (value.getQualifiedName(),tuple((x, value.__dict__[x]) for x in sorted(value.__dict__)))
      return cmp(selfKey, valueKey)
    else:
      return cmp(id(self), id(value))

  def __repr__(self):
    """
     string representation of object.
        identifies object uniquely, but can not be executed to regenerate it.
    """
    dataDict = self.__dict__
    tt = (self.getQualifiedName(),tuple((x, dataDict[x]) for x in sorted(dataDict)))
    ss = ', '.join('%s=%s' % (x[0], repr(x[1])) for x in tt[1])
    return '<%s {%s}>' % (tt[0], ss)

  __init__ = ComplexDataType.__init__

  checkAllValid = ComplexDataType.checkAllValid

  checkValid = ComplexDataType.checkValid
  
  def endOverride(self):
    """
    removes DataObj from override status
    """
    dataDict = self.__dict__
    # NB must be done by direct data access
    if 'override' in self.__dict__:
      del self.__dict__['override']

  getClassName = ComplexDataType.getClassName

  getFieldNames = ComplexDataType.getFieldNames

  getInConstructor = ComplexDataType.getInConstructor

  getMetaclass = ComplexDataType.getMetaclass
  
  def getOverride(self):
    """
    Get for memops.Implementation.MemopsDataTypeObject.override
    """
    dataDict = self.__dict__
    result = bool(dataDict.get('override'))
    return result

  getPackageName = ComplexDataType.getPackageName

  getPackageShortName = ComplexDataType.getPackageShortName

  getQualifiedName = ComplexDataType.getQualifiedName

  toDetailedString = ComplexDataType.toDetailedString

  className = ComplexDataType.className

  fieldNames = ComplexDataType.fieldNames

  inConstructor = ComplexDataType.inConstructor

  metaclass = ComplexDataType.metaclass
  
  override = property(getOverride, None, None,
  r"""Overrride switch for DataObjType. Works like MemopsRoot.override, but 
  only for the object itself. If set to True on creation must be reset to 
  False explicitly later. Once set to False can only be reset to True by 
  bypassing the API. 
  """)

  packageName = ComplexDataType.packageName

  packageShortName = ComplexDataType.packageShortName

  qualifiedName = ComplexDataType.qualifiedName

###############################################################################
class Url(MemopsDataTypeObject):
  r"""URl for data location. Example: directory, database. 
  """
  #   from data model element memops.Implementation.Url revision 1.50
  _metaclass = metaPackage.getElement('Url')
  _packageName = 'memops.Implementation'
  _packageShortName = 'IMPL'
  _fieldNames = ('className', 'dataLocation', 'fieldNames', 'host', 'inConstructor', 'metaclass', 'override', 'packageName', 'packageShortName', 'password', 'path', 'port', 'protocol', 'qualifiedName', 'user',)
  
  def __init__(self, **attrlinks):
    """
    Constructor for memops.Implementation.Url
    """
    dataDict = self.__dict__

    override = attrlinks.get('override')
    if (override is None):
      override = False
    else:
      del attrlinks['override']

    if (override):
      dataDict['override'] = override

    notOverride = not (dataDict.get('override'))

    dataDict['host'] = None
    dataDict['password'] = None
    dataDict['path'] = None
    dataDict['port'] = None
    dataDict['protocol'] = 'file'
    dataDict['user'] = None

    dataDict['inConstructor'] = True
    try:
      
      for key, value in attrlinks.iteritems():
        try:
          func = getattr(self.__class__, key).fset
        except:
          raise ApiError("%s: error setting %s - not a modeled attribute"
                         % (self, key))
        if func is None:
          raise ApiError("%s: error setting %s - not a settable attribute"
                         % (self, key))
        else:
          func(self, value)
      del dataDict['inConstructor']
    except:
      print "ERROR in memops.Implementation.Url.__init__"
      del dataDict['inConstructor']
      raise

    if (notOverride):
      self.checkValid()

    # doNotifies
  
  def checkAllValid(self, complete=False):
    """
    CheckAllValid for memops.Implementation.Url
    """
    dataDict = self.__dict__
    self.checkValid(complete)
  
  def checkValid(self, complete=False):
    """
    CheckValid for memops.Implementation.Url
    """
    dataDict = self.__dict__
    if (complete):
      # check attributes
      value = self.getDataLocation()
      if (value is None):
        raise ApiError("""%s.checkValid: dataLocation:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: dataLocation:
         memops.Implementation.PathString input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value.find(chr(92)) == -1)):
        raise ApiError("""%s.checkValid: dataLocation:
         PathString constraint contains_no_backslash violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: dataLocation:
         PathString constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('host')
      if (value is not None):
        if (isinstance(value, String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: host:
           memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: host:
           memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: host:
           memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: host:
           Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('password')
      if (value is not None):
        if (isinstance(value, String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: password:
           memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: password:
           memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: password:
           memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: password:
           Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('path')
      if (isinstance(value, String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: path:
         memops.Implementation.PathString input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value.find(chr(92)) == -1)):
        raise ApiError("""%s.checkValid: path:
         PathString constraint contains_no_backslash violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: path:
         PathString constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('port')
      if (value is not None):
        if (isinstance(value, Int.PythonType)):
          pass
        elif ([x for x in Int.compatibleTypes if isinstance(value, x)]):
          value = Int.create(value)
        else:
          raise ApiError("""%s.checkValid: port:
           memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('protocol')
      if (not (value in ['file', 'ftp', 'http', 'shttp'])):
        raise ApiError("""%s.checkValid: protocol:
         memops.Implementation.UrlProtocol input is not in enumeration ['file', 'ftp', 'http', 'shttp']""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.checkValid: protocol:
         UrlProtocol constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('user')
      if (value is not None):
        if (isinstance(value, String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: user:
           memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 80):
          raise ApiError("""%s.checkValid: user:
           memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: user:
           memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.splitlines()) <= 1)):
          raise ApiError("""%s.checkValid: user:
           Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

    if (dataDict.get('override')):
      raise ApiError("""%s.checkValid:
       override is on""" % self.qualifiedName
       + ": %s" % (self,)
      )

    # check explicit class constraints
    # check attributes
    value = dataDict.get('host')
    value = dataDict.get('password')
    value = dataDict.get('path')
    if (value is None):
      raise ApiError("""%s.checkValid: path:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('port')
    value = dataDict.get('protocol')
    if (value is None):
      raise ApiError("""%s.checkValid: protocol:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('user')
  
  def clone(self, **attrDict):
    """
    Clone function for memops.Implementation.Url
    """
    dataDict = self.__dict__
    attrlinks = {}
    attrlinks['host'] = dataDict.get('host')
    attrlinks['password'] = dataDict.get('password')
    attrlinks['path'] = dataDict.get('path')
    attrlinks['port'] = dataDict.get('port')
    attrlinks['protocol'] = dataDict.get('protocol')
    attrlinks['user'] = dataDict.get('user')
    for kk in attrDict.keys():
      attrlinks[kk] = attrDict.get(kk)

    return Url(**attrlinks)

  endOverride = MemopsDataTypeObject.endOverride
  
  def get(self, name):
    """
    GetAttr for memops.Implementation.Url
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getClassName = ComplexDataType.getClassName
  
  def getDataLocation(self):
    """
    getter for derived attribute dataLocation
    """
    dataDict = self.__dict__
    if self.host:
      result = '%s:%s' % (self.host, self.path)
    else:
      result = self.path
    return result

  getFieldNames = ComplexDataType.getFieldNames
  
  def getHost(self):
    """
    Get for memops.Implementation.Url.host
    """
    dataDict = self.__dict__
    result = dataDict.get('host')
    return result

  getInConstructor = ComplexDataType.getInConstructor

  getMetaclass = ComplexDataType.getMetaclass

  getOverride = MemopsDataTypeObject.getOverride

  getPackageName = ComplexDataType.getPackageName

  getPackageShortName = ComplexDataType.getPackageShortName
  
  def getPassword(self):
    """
    Get for memops.Implementation.Url.password
    """
    dataDict = self.__dict__
    result = dataDict.get('password')
    return result
  
  def getPath(self):
    """
    Get for memops.Implementation.Url.path
    """
    dataDict = self.__dict__
    result = dataDict.get('path')
    return result
  
  def getPort(self):
    """
    Get for memops.Implementation.Url.port
    """
    dataDict = self.__dict__
    result = dataDict.get('port')
    return result
  
  def getProtocol(self):
    """
    Get for memops.Implementation.Url.protocol
    """
    dataDict = self.__dict__
    result = dataDict.get('protocol')
    return result

  getQualifiedName = ComplexDataType.getQualifiedName
  
  def getUser(self):
    """
    Get for memops.Implementation.Url.user
    """
    dataDict = self.__dict__
    result = dataDict.get('user')
    return result
  
  def set(self, name, value):
    """
    SetAttr for memops.Implementation.Url
    """
    dataDict = self.__dict__
    setattr(self, name, value)
  
  def setHost(self, value):
    """
    Set for memops.Implementation.Url.host
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setHost:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.setHost:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setHost:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.setHost:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    currentValue = dataDict.get('host')
    notInConstructor = not (dataDict.get('inConstructor'))

    notOverride = not (dataDict.get('override'))
    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setHost:
         cannot set host, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['host'] = value

    # doNotifies
  
  def setPassword(self, value):
    """
    Set for memops.Implementation.Url.password
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setPassword:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.setPassword:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setPassword:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.setPassword:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    currentValue = dataDict.get('password')
    notInConstructor = not (dataDict.get('inConstructor'))

    notOverride = not (dataDict.get('override'))
    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setPassword:
         cannot set password, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['password'] = value

    # doNotifies
  
  def setPath(self, value):
    """
    Set for memops.Implementation.Url.path
    """
    dataDict = self.__dict__
    if (isinstance(value, String.PythonType)):
      pass
    else:
      raise ApiError("""%s.setPath:
       memops.Implementation.PathString input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value.find(chr(92)) == -1)):
      raise ApiError("""%s.setPath:
       PathString constraint contains_no_backslash violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.splitlines()) <= 1)):
      raise ApiError("""%s.setPath:
       PathString constraint contains_no_linebreak violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    currentValue = dataDict.get('path')
    notInConstructor = not (dataDict.get('inConstructor'))

    notOverride = not (dataDict.get('override'))
    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setPath:
         cannot set path, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setPath:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['path'] = value

    # doNotifies
  
  def setPort(self, value):
    """
    Set for memops.Implementation.Url.port
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, Int.PythonType)):
        pass
      elif ([x for x in Int.compatibleTypes if isinstance(value, x)]):
        value = Int.create(value)
      else:
        raise ApiError("""%s.setPort:
         memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

    currentValue = dataDict.get('port')
    notInConstructor = not (dataDict.get('inConstructor'))

    notOverride = not (dataDict.get('override'))
    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setPort:
         cannot set port, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['port'] = value

    # doNotifies
  
  def setProtocol(self, value):
    """
    Set for memops.Implementation.Url.protocol
    """
    dataDict = self.__dict__
    if (not (value in ['file', 'ftp', 'http', 'shttp'])):
      raise ApiError("""%s.setProtocol:
       memops.Implementation.UrlProtocol input is not in enumeration ['file', 'ftp', 'http', 'shttp']""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.split()) == 1)):
      raise ApiError("""%s.setProtocol:
       UrlProtocol constraint contains_no_white_space violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    currentValue = dataDict.get('protocol')
    notInConstructor = not (dataDict.get('inConstructor'))

    notOverride = not (dataDict.get('override'))
    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setProtocol:
         cannot set protocol, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setProtocol:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['protocol'] = value

    # doNotifies
  
  def setUser(self, value):
    """
    Set for memops.Implementation.Url.user
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setUser:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.setUser:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setUser:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.setUser:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    currentValue = dataDict.get('user')
    notInConstructor = not (dataDict.get('inConstructor'))

    notOverride = not (dataDict.get('override'))
    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setUser:
         cannot set user, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['user'] = value

    # doNotifies

  toDetailedString = ComplexDataType.toDetailedString

  className = ComplexDataType.className
  
  dataLocation = property(getDataLocation, None, None,
  r"""Full data location as a single string.
  """)

  fieldNames = ComplexDataType.fieldNames
  
  host = property(getHost, setHost, None,
  r"""Host computer or web site.
  """)

  inConstructor = ComplexDataType.inConstructor

  metaclass = ComplexDataType.metaclass

  override = MemopsDataTypeObject.override

  packageName = ComplexDataType.packageName

  packageShortName = ComplexDataType.packageShortName
  
  password = property(getPassword, setPassword, None,
  r"""User password for URL
  """)
  
  path = property(getPath, setPath, None,
  r"""Absolute URL path. 
  """)
  
  port = property(getPort, setPort, None,
  r"""Port number to use for the URL.
  """)
  
  protocol = property(getProtocol, setProtocol, None,
  r"""URL transfer protocol. 
  """)

  qualifiedName = ComplexDataType.qualifiedName
  
  user = property(getUser, setUser, None,
  r"""User ID for URL
  """)

###############################################################################
class AbstractMatrix(MemopsDataTypeObject):
  r"""nD Matrix of simple data type elements
  """
  #   from data model element memops.Implementation.AbstractMatrix revision 1.7
  _metaclass = metaPackage.getElement('AbstractMatrix')
  _packageName = 'memops.Implementation'
  _packageShortName = 'IMPL'
  _fieldNames = ('className', 'data', 'fieldNames', 'inConstructor', 'metaclass', 'ndim', 'override', 'packageName', 'packageShortName', 'qualifiedName', 'shape', 'size', 'strides', 'value',)

  __init__ = ComplexDataType.__init__

  checkAllValid = ComplexDataType.checkAllValid

  checkValid = ComplexDataType.checkValid

  endOverride = MemopsDataTypeObject.endOverride

  getClassName = ComplexDataType.getClassName
  
  def getData(self):
    """
    Get for memops.Implementation.AbstractMatrix.data
    """
    dataDict = self.__dict__
    raise ApiError("""%s.getData:
     getData should never be called - must be overridden in subclass""" % self.qualifiedName
     + ": %s" % (self,)
    )

  getFieldNames = ComplexDataType.getFieldNames

  getInConstructor = ComplexDataType.getInConstructor

  getMetaclass = ComplexDataType.getMetaclass
  
  def getNdim(self):
    """
    getter for derived attribute ndim
    """
    dataDict = self.__dict__
    result = len(self.shape)
    return result

  getOverride = MemopsDataTypeObject.getOverride

  getPackageName = ComplexDataType.getPackageName

  getPackageShortName = ComplexDataType.getPackageShortName

  getQualifiedName = ComplexDataType.getQualifiedName
  
  def getShape(self):
    """
    Get for memops.Implementation.AbstractMatrix.shape
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('shape')
    result = tuple(tempVar)
    return result
  
  def getSize(self):
    """
    getter for serived attribute size
    """
    dataDict = self.__dict__
    from operator import mul as multiply
    result = reduce(multiply, self.shape)
    return result
  
  def getStrides(self):
    """
    getter for derived link strides
    """
    dataDict = self.__dict__
    from memops.universal.BlockData import strides
    result = tuple(strides(self.shape))
    return result
  
  def getValue(self):
    """
    getter for derived attribute value
    """
    dataDict = self.__dict__
    result = self.__dict__['data']
    for step in reversed(shape[1:]):
      newval = tuple(tuple(result[x:x+step]) 
                             for x in range(0, len(result), step))
      result = newval
    return result
  
  def pointValue(self, point):
    """
    get value of point - type is the type of the matrix element
    """
    dataDict = self.__dict__
    strides = self.strides
    
    index = sum(ind*strides[i] for i,ind in enumerate(point))
    result = self.__dict__['data'][index]
    return result
  
  def setData(self, values):
    """
    Set for memops.Implementation.AbstractMatrix.data
    """
    dataDict = self.__dict__
    raise ApiError("""%s.setData:
     setData should never be called - must be overridden in subclass""" % self.qualifiedName
     + ": %s" % (self,)
    )
  
  def setShape(self, values):
    """
    Set for memops.Implementation.AbstractMatrix.shape
    """
    dataDict = self.__dict__
    values = list(values)
    for value in values:
      if (isinstance(value, Int.PythonType)):
        pass
      elif ([x for x in Int.compatibleTypes if isinstance(value, x)]):
        castValue = Int.create(value)
        replaceIndex = values.index(value)
        values[replaceIndex] = castValue
        value = castValue
      else:
        raise ApiError("""%s.setShape:
         memops.Implementation.PositiveInt input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value > 0)):
        raise ApiError("""%s.setShape:
         PositiveInt constraint int_value_gt_0 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    currentValues = dataDict.get('shape')
    notInConstructor = not (dataDict.get('inConstructor'))

    notOverride = not (dataDict.get('override'))
    if (values == currentValues):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setShape:
         cannot set shape, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (len(values) < 1):
        raise ApiError("""%s.setShape:
         locard: values must be of length >= 1""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['shape'] = values

    # doNotifies
  
  def subMatrix(self, point, widths):
    """
    get subMatrix of current Matrix, in ranges point:point+width. Type is
    the same type as the current matrix
    """
    dataDict = self.__dict__
    # read in data
    ndim = self.ndim
    data = self.__dict__['data']
    strides = self.strides
    shape = self.shape
    
    # set widths - padding to dimension sizes.
    ll = list(shape)
    if widths is not None:
      ll[:len(widths)] = widths
    widths = ll
    
    #set point - padding with zero
    ll = ndim * [0]
    if point is not None:
      ll[:len(point)] = point
    point = ll
    
    # adjust widths for cases where width==0, and set new shape.
    newshape = []
    for ii,width in enumerate(widths):
      if width:
        newshape.append(width) # use only dims with non-zero widths
      else:
        widths[ii] = 1 # replace width 0 with width 1 for further processing
    
    
    # find start indices for stretches of data used
    indices = [0] 
    for dim,stride in enumerate(strides[:-1]):
      offset = point[dim] * stride
      width = widths[dim] 
      ll = []
      for index in indices:
        newindex = index + offset
        for dummy in range(width):
          ll.append(newindex)
          newindex += stride
      indices = ll
    
    # get actual data and create new data array
    width = widths[-1]
    newdata = [None] * (width * len(indices))
    start = 0
    for index in indices:
      end = start + width
      newdata[start:end] = data[index:index+width]
      start = end
        
    # create subMatrix object
    result = self.__class__(shape=newshape, data=newdata)
    return result

  toDetailedString = ComplexDataType.toDetailedString

  className = ComplexDataType.className
  
  data = property(getData, setData, None,
  r"""
  """)

  fieldNames = ComplexDataType.fieldNames

  inConstructor = ComplexDataType.inConstructor

  metaclass = ComplexDataType.metaclass
  
  ndim = property(getNdim, None, None,
  r"""Number of dimensions of matrix
  """)

  override = MemopsDataTypeObject.override

  packageName = ComplexDataType.packageName

  packageShortName = ComplexDataType.packageShortName

  qualifiedName = ComplexDataType.qualifiedName
  
  shape = property(getShape, setShape, None,
  r"""Dimension sizes of matrix - slowest varying first.
  """)
  
  size = property(getSize, None, None,
  r"""Number of elements in matrix
  """)
  
  strides = property(getStrides, None, None,
  r"""strides[i] is the distance between two points in the linear data 
  representation that differ by 1 in dimension i. strides[i] is equal to 
  the product of the length of all faster-changing dimensions.
  """)
  
  value = property(getValue, None, None,
  r"""Matrix value, represented as nested tuples of elements.
  """)

###############################################################################
class ApplicationData(MemopsDataTypeObject):
  r"""Stores program-specific data. Intended for application-specific 
extensions to the data model. ApplicationData objects should be used 
only by the application that wrote them originally. 
ApplicationData 
objects all have an attribute 'value' holding the data value. The data 
type of the value differs between the different subclasses of 
ApplicationData
  """
  #   from data model element memops.Implementation.ApplicationData revision 1.46
  _metaclass = metaPackage.getElement('ApplicationData')
  _packageName = 'memops.Implementation'
  _packageShortName = 'IMPL'
  _fieldNames = ('application', 'className', 'fieldNames', 'inConstructor', 'keyword', 'metaclass', 'override', 'packageName', 'packageShortName', 'qualifiedName',)

  __init__ = ComplexDataType.__init__

  checkAllValid = ComplexDataType.checkAllValid

  checkValid = ComplexDataType.checkValid

  endOverride = MemopsDataTypeObject.endOverride
  
  def getApplication(self):
    """
    Get for memops.Implementation.ApplicationData.application
    """
    dataDict = self.__dict__
    result = dataDict.get('application')
    return result

  getClassName = ComplexDataType.getClassName

  getFieldNames = ComplexDataType.getFieldNames

  getInConstructor = ComplexDataType.getInConstructor
  
  def getKeyword(self):
    """
    Get for memops.Implementation.ApplicationData.keyword
    """
    dataDict = self.__dict__
    result = dataDict.get('keyword')
    return result

  getMetaclass = ComplexDataType.getMetaclass

  getOverride = MemopsDataTypeObject.getOverride

  getPackageName = ComplexDataType.getPackageName

  getPackageShortName = ComplexDataType.getPackageShortName

  getQualifiedName = ComplexDataType.getQualifiedName
  
  def setApplication(self, value):
    """
    Set for memops.Implementation.ApplicationData.application
    """
    dataDict = self.__dict__
    if (isinstance(value, String.PythonType)):
      pass
    else:
      raise ApiError("""%s.setApplication:
       memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 80):
      raise ApiError("""%s.setApplication:
       memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.setApplication:
       memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.splitlines()) <= 1)):
      raise ApiError("""%s.setApplication:
       Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    currentValue = dataDict.get('application')
    notInConstructor = not (dataDict.get('inConstructor'))

    notOverride = not (dataDict.get('override'))
    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setApplication:
         cannot set application, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setApplication:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['application'] = value

    # doNotifies
  
  def setKeyword(self, value):
    """
    Set for memops.Implementation.ApplicationData.keyword
    """
    dataDict = self.__dict__
    if (isinstance(value, String.PythonType)):
      pass
    else:
      raise ApiError("""%s.setKeyword:
       memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 80):
      raise ApiError("""%s.setKeyword:
       memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.setKeyword:
       memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.splitlines()) <= 1)):
      raise ApiError("""%s.setKeyword:
       Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    currentValue = dataDict.get('keyword')
    notInConstructor = not (dataDict.get('inConstructor'))

    notOverride = not (dataDict.get('override'))
    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setKeyword:
         cannot set keyword, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setKeyword:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['keyword'] = value

    # doNotifies

  toDetailedString = ComplexDataType.toDetailedString
  
  application = property(getApplication, setApplication, None,
  r"""Name of application owning the data.
  """)

  className = ComplexDataType.className

  fieldNames = ComplexDataType.fieldNames

  inConstructor = ComplexDataType.inConstructor
  
  keyword = property(getKeyword, setKeyword, None,
  r"""keyword or name of variable
  """)

  metaclass = ComplexDataType.metaclass

  override = MemopsDataTypeObject.override

  packageName = ComplexDataType.packageName

  packageShortName = ComplexDataType.packageShortName

  qualifiedName = ComplexDataType.qualifiedName

###############################################################################
class SymmTracelessMatrix(MemopsDataTypeObject):
  r"""Symmetric traceless tenaor, used for instance for alignment tensors.
  """
  #   from data model element memops.Implementation.SymmTracelessMatrix revision 1.12
  _metaclass = metaPackage.getElement('SymmTracelessMatrix')
  _packageName = 'memops.Implementation'
  _packageShortName = 'IMPL'
  _fieldNames = ('aAxial', 'aRhombic', 'alpha', 'beta', 'className', 'fieldNames', 'gamma', 'inConstructor', 'metaclass', 'override', 'packageName', 'packageShortName', 'qualifiedName',)
  
  def __init__(self, **attrlinks):
    """
    Constructor for memops.Implementation.SymmTracelessMatrix
    """
    dataDict = self.__dict__

    override = attrlinks.get('override')
    if (override is None):
      override = False
    else:
      del attrlinks['override']

    if (override):
      dataDict['override'] = override

    notOverride = not (dataDict.get('override'))

    dataDict['aAxial'] = None
    dataDict['aRhombic'] = None
    dataDict['alpha'] = None
    dataDict['beta'] = None
    dataDict['gamma'] = None

    dataDict['inConstructor'] = True
    try:
      
      for key, value in attrlinks.iteritems():
        try:
          func = getattr(self.__class__, key).fset
        except:
          raise ApiError("%s: error setting %s - not a modeled attribute"
                         % (self, key))
        if func is None:
          raise ApiError("%s: error setting %s - not a settable attribute"
                         % (self, key))
        else:
          func(self, value)
      del dataDict['inConstructor']
    except:
      print "ERROR in memops.Implementation.SymmTracelessMatrix.__init__"
      del dataDict['inConstructor']
      raise

    if (notOverride):
      self.checkValid()

    # doNotifies
  
  def checkAllValid(self, complete=False):
    """
    CheckAllValid for memops.Implementation.SymmTracelessMatrix
    """
    dataDict = self.__dict__
    self.checkValid(complete)
  
  def checkValid(self, complete=False):
    """
    CheckValid for memops.Implementation.SymmTracelessMatrix
    """
    dataDict = self.__dict__
    if (complete):
      # check attributes
      value = dataDict.get('aAxial')
      if (isinstance(value, Float.PythonType)):
        pass
      elif ([x for x in Float.compatibleTypes if isinstance(value, x)]):
        value = Float.create(value)
      else:
        raise ApiError("""%s.checkValid: aAxial:
         memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value - value == 0.0)):
        raise ApiError("""%s.checkValid: aAxial:
         Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('aRhombic')
      if (isinstance(value, Float.PythonType)):
        pass
      elif ([x for x in Float.compatibleTypes if isinstance(value, x)]):
        value = Float.create(value)
      else:
        raise ApiError("""%s.checkValid: aRhombic:
         memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value - value == 0.0)):
        raise ApiError("""%s.checkValid: aRhombic:
         Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('alpha')
      if (isinstance(value, Float.PythonType)):
        pass
      elif ([x for x in Float.compatibleTypes if isinstance(value, x)]):
        value = Float.create(value)
      else:
        raise ApiError("""%s.checkValid: alpha:
         memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value - value == 0.0)):
        raise ApiError("""%s.checkValid: alpha:
         Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('beta')
      if (isinstance(value, Float.PythonType)):
        pass
      elif ([x for x in Float.compatibleTypes if isinstance(value, x)]):
        value = Float.create(value)
      else:
        raise ApiError("""%s.checkValid: beta:
         memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value - value == 0.0)):
        raise ApiError("""%s.checkValid: beta:
         Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('gamma')
      if (isinstance(value, Float.PythonType)):
        pass
      elif ([x for x in Float.compatibleTypes if isinstance(value, x)]):
        value = Float.create(value)
      else:
        raise ApiError("""%s.checkValid: gamma:
         memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value - value == 0.0)):
        raise ApiError("""%s.checkValid: gamma:
         Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    if (dataDict.get('override')):
      raise ApiError("""%s.checkValid:
       override is on""" % self.qualifiedName
       + ": %s" % (self,)
      )

    # check explicit class constraints
    # check attributes
    value = dataDict.get('aAxial')
    if (value is None):
      raise ApiError("""%s.checkValid: aAxial:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('aRhombic')
    if (value is None):
      raise ApiError("""%s.checkValid: aRhombic:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('alpha')
    if (value is None):
      raise ApiError("""%s.checkValid: alpha:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('beta')
    if (value is None):
      raise ApiError("""%s.checkValid: beta:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('gamma')
    if (value is None):
      raise ApiError("""%s.checkValid: gamma:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

  def clone(self, **attrDict):
    """
    Clone function for memops.Implementation.SymmTracelessMatrix
    """
    dataDict = self.__dict__
    attrlinks = {}
    attrlinks['aAxial'] = dataDict.get('aAxial')
    attrlinks['aRhombic'] = dataDict.get('aRhombic')
    attrlinks['alpha'] = dataDict.get('alpha')
    attrlinks['beta'] = dataDict.get('beta')
    attrlinks['gamma'] = dataDict.get('gamma')
    for kk in attrDict.keys():
      attrlinks[kk] = attrDict.get(kk)

    return SymmTracelessMatrix(**attrlinks)

  endOverride = MemopsDataTypeObject.endOverride
  
  def get(self, name):
    """
    GetAttr for memops.Implementation.SymmTracelessMatrix
    """
    dataDict = self.__dict__
    return getattr(self, name)
  
  def getAAxial(self):
    """
    Get for memops.Implementation.SymmTracelessMatrix.aAxial
    """
    dataDict = self.__dict__
    result = dataDict.get('aAxial')
    return result
  
  def getARhombic(self):
    """
    Get for memops.Implementation.SymmTracelessMatrix.aRhombic
    """
    dataDict = self.__dict__
    result = dataDict.get('aRhombic')
    return result
  
  def getAlpha(self):
    """
    Get for memops.Implementation.SymmTracelessMatrix.alpha
    """
    dataDict = self.__dict__
    result = dataDict.get('alpha')
    return result
  
  def getBeta(self):
    """
    Get for memops.Implementation.SymmTracelessMatrix.beta
    """
    dataDict = self.__dict__
    result = dataDict.get('beta')
    return result

  getClassName = ComplexDataType.getClassName

  getFieldNames = ComplexDataType.getFieldNames
  
  def getGamma(self):
    """
    Get for memops.Implementation.SymmTracelessMatrix.gamma
    """
    dataDict = self.__dict__
    result = dataDict.get('gamma')
    return result

  getInConstructor = ComplexDataType.getInConstructor

  getMetaclass = ComplexDataType.getMetaclass

  getOverride = MemopsDataTypeObject.getOverride

  getPackageName = ComplexDataType.getPackageName

  getPackageShortName = ComplexDataType.getPackageShortName

  getQualifiedName = ComplexDataType.getQualifiedName
  
  def set(self, name, value):
    """
    SetAttr for memops.Implementation.SymmTracelessMatrix
    """
    dataDict = self.__dict__
    setattr(self, name, value)
  
  def setAAxial(self, value):
    """
    Set for memops.Implementation.SymmTracelessMatrix.aAxial
    """
    dataDict = self.__dict__
    if (isinstance(value, Float.PythonType)):
      pass
    elif ([x for x in Float.compatibleTypes if isinstance(value, x)]):
      value = Float.create(value)
    else:
      raise ApiError("""%s.setAAxial:
       memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value - value == 0.0)):
      raise ApiError("""%s.setAAxial:
       Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    currentValue = dataDict.get('aAxial')
    notInConstructor = not (dataDict.get('inConstructor'))

    notOverride = not (dataDict.get('override'))
    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setAAxial:
         cannot set aAxial, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setAAxial:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['aAxial'] = value

    # doNotifies
  
  def setARhombic(self, value):
    """
    Set for memops.Implementation.SymmTracelessMatrix.aRhombic
    """
    dataDict = self.__dict__
    if (isinstance(value, Float.PythonType)):
      pass
    elif ([x for x in Float.compatibleTypes if isinstance(value, x)]):
      value = Float.create(value)
    else:
      raise ApiError("""%s.setARhombic:
       memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value - value == 0.0)):
      raise ApiError("""%s.setARhombic:
       Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    currentValue = dataDict.get('aRhombic')
    notInConstructor = not (dataDict.get('inConstructor'))

    notOverride = not (dataDict.get('override'))
    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setARhombic:
         cannot set aRhombic, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setARhombic:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['aRhombic'] = value

    # doNotifies
  
  def setAlpha(self, value):
    """
    Set for memops.Implementation.SymmTracelessMatrix.alpha
    """
    dataDict = self.__dict__
    if (isinstance(value, Float.PythonType)):
      pass
    elif ([x for x in Float.compatibleTypes if isinstance(value, x)]):
      value = Float.create(value)
    else:
      raise ApiError("""%s.setAlpha:
       memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value - value == 0.0)):
      raise ApiError("""%s.setAlpha:
       Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    currentValue = dataDict.get('alpha')
    notInConstructor = not (dataDict.get('inConstructor'))

    notOverride = not (dataDict.get('override'))
    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setAlpha:
         cannot set alpha, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setAlpha:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['alpha'] = value

    # doNotifies
  
  def setBeta(self, value):
    """
    Set for memops.Implementation.SymmTracelessMatrix.beta
    """
    dataDict = self.__dict__
    if (isinstance(value, Float.PythonType)):
      pass
    elif ([x for x in Float.compatibleTypes if isinstance(value, x)]):
      value = Float.create(value)
    else:
      raise ApiError("""%s.setBeta:
       memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value - value == 0.0)):
      raise ApiError("""%s.setBeta:
       Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    currentValue = dataDict.get('beta')
    notInConstructor = not (dataDict.get('inConstructor'))

    notOverride = not (dataDict.get('override'))
    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setBeta:
         cannot set beta, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setBeta:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['beta'] = value

    # doNotifies
  
  def setGamma(self, value):
    """
    Set for memops.Implementation.SymmTracelessMatrix.gamma
    """
    dataDict = self.__dict__
    if (isinstance(value, Float.PythonType)):
      pass
    elif ([x for x in Float.compatibleTypes if isinstance(value, x)]):
      value = Float.create(value)
    else:
      raise ApiError("""%s.setGamma:
       memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value - value == 0.0)):
      raise ApiError("""%s.setGamma:
       Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    currentValue = dataDict.get('gamma')
    notInConstructor = not (dataDict.get('inConstructor'))

    notOverride = not (dataDict.get('override'))
    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setGamma:
         cannot set gamma, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setGamma:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['gamma'] = value

    # doNotifies

  toDetailedString = ComplexDataType.toDetailedString
  
  aAxial = property(getAAxial, setAAxial, None,
  r"""Axial component
  """)
  
  aRhombic = property(getARhombic, setARhombic, None,
  r"""rhombic component
  """)
  
  alpha = property(getAlpha, setAlpha, None,
  r"""Euler angle alpha in radians
  """)
  
  beta = property(getBeta, setBeta, None,
  r"""Euler angle beta in radians
  """)

  className = ComplexDataType.className

  fieldNames = ComplexDataType.fieldNames
  
  gamma = property(getGamma, setGamma, None,
  r"""Euler angle gamma in radians
  """)

  inConstructor = ComplexDataType.inConstructor

  metaclass = ComplexDataType.metaclass

  override = MemopsDataTypeObject.override

  packageName = ComplexDataType.packageName

  packageShortName = ComplexDataType.packageShortName

  qualifiedName = ComplexDataType.qualifiedName

###############################################################################
class IntMatrix(AbstractMatrix):
  r"""nD Matrix of Int elements.
  """
  #   from data model element memops.Implementation.IntMatrix revision 1.5
  _metaclass = metaPackage.getElement('IntMatrix')
  _packageName = 'memops.Implementation'
  _packageShortName = 'IMPL'
  _fieldNames = ('className', 'data', 'fieldNames', 'inConstructor', 'metaclass', 'ndim', 'override', 'packageName', 'packageShortName', 'qualifiedName', 'shape', 'size', 'strides', 'value',)
  
  def __init__(self, **attrlinks):
    """
    Constructor for memops.Implementation.IntMatrix
    """
    dataDict = self.__dict__

    override = attrlinks.get('override')
    if (override is None):
      override = False
    else:
      del attrlinks['override']

    if (override):
      dataDict['override'] = override

    notOverride = not (dataDict.get('override'))

    dataDict['data'] = list()
    dataDict['shape'] = list()

    dataDict['inConstructor'] = True
    try:
      
      for key, value in attrlinks.iteritems():
        try:
          func = getattr(self.__class__, key).fset
        except:
          raise ApiError("%s: error setting %s - not a modeled attribute"
                         % (self, key))
        if func is None:
          raise ApiError("%s: error setting %s - not a settable attribute"
                         % (self, key))
        else:
          func(self, value)
      del dataDict['inConstructor']
    except:
      print "ERROR in memops.Implementation.IntMatrix.__init__"
      del dataDict['inConstructor']
      raise

    if (notOverride):
      self.checkValid()

    # doNotifies
  
  def checkAllValid(self, complete=False):
    """
    CheckAllValid for memops.Implementation.IntMatrix
    """
    dataDict = self.__dict__
    self.checkValid(complete)
  
  def checkValid(self, complete=False):
    """
    CheckValid for memops.Implementation.IntMatrix
    """
    dataDict = self.__dict__
    if (complete):
      # check attributes
      values = dataDict.get('data')
      for value in values:
        if (isinstance(value, Int.PythonType)):
          pass
        elif ([x for x in Int.compatibleTypes if isinstance(value, x)]):
          castValue = Int.create(value)
          replaceIndex = values.index(value)
          values[replaceIndex] = castValue
          value = castValue
        else:
          raise ApiError("""%s.checkValid: data:
           memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = self.getNdim()
      if (value is None):
        raise ApiError("""%s.checkValid: ndim:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, Int.PythonType)):
        pass
      elif ([x for x in Int.compatibleTypes if isinstance(value, x)]):
        value = Int.create(value)
      else:
        raise ApiError("""%s.checkValid: ndim:
         memops.Implementation.NonNegativeInt input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value >= 0)):
        raise ApiError("""%s.checkValid: ndim:
         NonNegativeInt constraint int_value_ge_0 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      values = dataDict.get('shape')
      for value in values:
        if (isinstance(value, Int.PythonType)):
          pass
        elif ([x for x in Int.compatibleTypes if isinstance(value, x)]):
          castValue = Int.create(value)
          replaceIndex = values.index(value)
          values[replaceIndex] = castValue
          value = castValue
        else:
          raise ApiError("""%s.checkValid: shape:
           memops.Implementation.PositiveInt input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (value > 0)):
          raise ApiError("""%s.checkValid: shape:
           PositiveInt constraint int_value_gt_0 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = self.getSize()
      if (value is None):
        raise ApiError("""%s.checkValid: size:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, Int.PythonType)):
        pass
      elif ([x for x in Int.compatibleTypes if isinstance(value, x)]):
        value = Int.create(value)
      else:
        raise ApiError("""%s.checkValid: size:
         memops.Implementation.NonNegativeInt input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value >= 0)):
        raise ApiError("""%s.checkValid: size:
         NonNegativeInt constraint int_value_ge_0 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      values = self.getStrides()
      for value in values:
        if (isinstance(value, Int.PythonType)):
          pass
        elif ([x for x in Int.compatibleTypes if isinstance(value, x)]):
          castValue = Int.create(value)
          replaceIndex = values.index(value)
          values[replaceIndex] = castValue
          value = castValue
        else:
          raise ApiError("""%s.checkValid: strides:
           memops.Implementation.PositiveInt input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (value > 0)):
          raise ApiError("""%s.checkValid: strides:
           PositiveInt constraint int_value_gt_0 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      values = self.getValue()
      for value in values:
        pass

    if (dataDict.get('override')):
      raise ApiError("""%s.checkValid:
       override is on""" % self.qualifiedName
       + ": %s" % (self,)
      )

    # check explicit class constraints
    if (not (self.size == len(self.data))):
      raise ApiError("""%s.checkValid:
       constraint matrix_size_eq_data_size violated""" % self.qualifiedName
       + ": %s" % (self,)
      )

    # check attributes
    values = dataDict.get('data')
    if (len(values) < 1):
      raise ApiError("""%s.checkValid: data:
       locard: values must be of length >= 1""" % self.qualifiedName
       + ": %s" % (self,)
      )

    values = dataDict.get('shape')
    if (len(values) < 1):
      raise ApiError("""%s.checkValid: shape:
       locard: values must be of length >= 1""" % self.qualifiedName
       + ": %s" % (self,)
      )

  def clone(self, **attrDict):
    """
    Clone function for memops.Implementation.IntMatrix
    """
    dataDict = self.__dict__
    attrlinks = {}
    attrlinks['data'] = dataDict.get('data')
    attrlinks['shape'] = dataDict.get('shape')
    for kk in attrDict.keys():
      attrlinks[kk] = attrDict.get(kk)

    return IntMatrix(**attrlinks)

  endOverride = MemopsDataTypeObject.endOverride
  
  def get(self, name):
    """
    GetAttr for memops.Implementation.IntMatrix
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getClassName = ComplexDataType.getClassName
  
  def getData(self):
    """
    Get for memops.Implementation.IntMatrix.data
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('data')
    result = tuple(tempVar)
    return result

  getFieldNames = ComplexDataType.getFieldNames

  getInConstructor = ComplexDataType.getInConstructor

  getMetaclass = ComplexDataType.getMetaclass

  getNdim = AbstractMatrix.getNdim

  getOverride = MemopsDataTypeObject.getOverride

  getPackageName = ComplexDataType.getPackageName

  getPackageShortName = ComplexDataType.getPackageShortName

  getQualifiedName = ComplexDataType.getQualifiedName

  getShape = AbstractMatrix.getShape

  getSize = AbstractMatrix.getSize

  getStrides = AbstractMatrix.getStrides

  getValue = AbstractMatrix.getValue

  pointValue = AbstractMatrix.pointValue
  
  def set(self, name, value):
    """
    SetAttr for memops.Implementation.IntMatrix
    """
    dataDict = self.__dict__
    setattr(self, name, value)
  
  def setData(self, values):
    """
    Set for memops.Implementation.IntMatrix.data
    """
    dataDict = self.__dict__
    values = list(values)
    for value in values:
      if (isinstance(value, Int.PythonType)):
        pass
      elif ([x for x in Int.compatibleTypes if isinstance(value, x)]):
        castValue = Int.create(value)
        replaceIndex = values.index(value)
        values[replaceIndex] = castValue
        value = castValue
      else:
        raise ApiError("""%s.setData:
         memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

    currentValues = dataDict.get('data')
    notInConstructor = not (dataDict.get('inConstructor'))

    notOverride = not (dataDict.get('override'))
    if (values == currentValues):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setData:
         cannot set data, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (len(values) < 1):
        raise ApiError("""%s.setData:
         locard: values must be of length >= 1""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['data'] = values

    # doNotifies

  setShape = AbstractMatrix.setShape

  subMatrix = AbstractMatrix.subMatrix

  toDetailedString = ComplexDataType.toDetailedString

  className = ComplexDataType.className
  
  data = property(getData, setData, None,
  r"""
  """)

  fieldNames = ComplexDataType.fieldNames

  inConstructor = ComplexDataType.inConstructor

  metaclass = ComplexDataType.metaclass

  ndim = AbstractMatrix.ndim

  override = MemopsDataTypeObject.override

  packageName = ComplexDataType.packageName

  packageShortName = ComplexDataType.packageShortName

  qualifiedName = ComplexDataType.qualifiedName

  shape = AbstractMatrix.shape

  size = AbstractMatrix.size

  strides = AbstractMatrix.strides

  value = AbstractMatrix.value

###############################################################################
class BooleanMatrix(AbstractMatrix):
  r"""nD Matrix of Boolean elements.
  """
  #   from data model element memops.Implementation.BooleanMatrix revision 1.5
  _metaclass = metaPackage.getElement('BooleanMatrix')
  _packageName = 'memops.Implementation'
  _packageShortName = 'IMPL'
  _fieldNames = ('className', 'data', 'fieldNames', 'inConstructor', 'metaclass', 'ndim', 'override', 'packageName', 'packageShortName', 'qualifiedName', 'shape', 'size', 'strides', 'value',)
  
  def __init__(self, **attrlinks):
    """
    Constructor for memops.Implementation.BooleanMatrix
    """
    dataDict = self.__dict__

    override = attrlinks.get('override')
    if (override is None):
      override = False
    else:
      del attrlinks['override']

    if (override):
      dataDict['override'] = override

    notOverride = not (dataDict.get('override'))

    dataDict['data'] = list()
    dataDict['shape'] = list()

    dataDict['inConstructor'] = True
    try:
      
      for key, value in attrlinks.iteritems():
        try:
          func = getattr(self.__class__, key).fset
        except:
          raise ApiError("%s: error setting %s - not a modeled attribute"
                         % (self, key))
        if func is None:
          raise ApiError("%s: error setting %s - not a settable attribute"
                         % (self, key))
        else:
          func(self, value)
      del dataDict['inConstructor']
    except:
      print "ERROR in memops.Implementation.BooleanMatrix.__init__"
      del dataDict['inConstructor']
      raise

    if (notOverride):
      self.checkValid()

    # doNotifies
  
  def checkAllValid(self, complete=False):
    """
    CheckAllValid for memops.Implementation.BooleanMatrix
    """
    dataDict = self.__dict__
    self.checkValid(complete)
  
  def checkValid(self, complete=False):
    """
    CheckValid for memops.Implementation.BooleanMatrix
    """
    dataDict = self.__dict__
    if (complete):
      # check attributes
      values = dataDict.get('data')
      for value in values:
        if (not (value in [True, False])):
          raise ApiError("""%s.checkValid: data:
           memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = self.getNdim()
      if (value is None):
        raise ApiError("""%s.checkValid: ndim:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, Int.PythonType)):
        pass
      elif ([x for x in Int.compatibleTypes if isinstance(value, x)]):
        value = Int.create(value)
      else:
        raise ApiError("""%s.checkValid: ndim:
         memops.Implementation.NonNegativeInt input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value >= 0)):
        raise ApiError("""%s.checkValid: ndim:
         NonNegativeInt constraint int_value_ge_0 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      values = dataDict.get('shape')
      for value in values:
        if (isinstance(value, Int.PythonType)):
          pass
        elif ([x for x in Int.compatibleTypes if isinstance(value, x)]):
          castValue = Int.create(value)
          replaceIndex = values.index(value)
          values[replaceIndex] = castValue
          value = castValue
        else:
          raise ApiError("""%s.checkValid: shape:
           memops.Implementation.PositiveInt input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (value > 0)):
          raise ApiError("""%s.checkValid: shape:
           PositiveInt constraint int_value_gt_0 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = self.getSize()
      if (value is None):
        raise ApiError("""%s.checkValid: size:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, Int.PythonType)):
        pass
      elif ([x for x in Int.compatibleTypes if isinstance(value, x)]):
        value = Int.create(value)
      else:
        raise ApiError("""%s.checkValid: size:
         memops.Implementation.NonNegativeInt input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value >= 0)):
        raise ApiError("""%s.checkValid: size:
         NonNegativeInt constraint int_value_ge_0 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      values = self.getStrides()
      for value in values:
        if (isinstance(value, Int.PythonType)):
          pass
        elif ([x for x in Int.compatibleTypes if isinstance(value, x)]):
          castValue = Int.create(value)
          replaceIndex = values.index(value)
          values[replaceIndex] = castValue
          value = castValue
        else:
          raise ApiError("""%s.checkValid: strides:
           memops.Implementation.PositiveInt input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (value > 0)):
          raise ApiError("""%s.checkValid: strides:
           PositiveInt constraint int_value_gt_0 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      values = self.getValue()
      for value in values:
        pass

    if (dataDict.get('override')):
      raise ApiError("""%s.checkValid:
       override is on""" % self.qualifiedName
       + ": %s" % (self,)
      )

    # check explicit class constraints
    if (not (self.size == len(self.data))):
      raise ApiError("""%s.checkValid:
       constraint matrix_size_eq_data_size violated""" % self.qualifiedName
       + ": %s" % (self,)
      )

    # check attributes
    values = dataDict.get('data')
    if (len(values) < 1):
      raise ApiError("""%s.checkValid: data:
       locard: values must be of length >= 1""" % self.qualifiedName
       + ": %s" % (self,)
      )

    values = dataDict.get('shape')
    if (len(values) < 1):
      raise ApiError("""%s.checkValid: shape:
       locard: values must be of length >= 1""" % self.qualifiedName
       + ": %s" % (self,)
      )

  def clone(self, **attrDict):
    """
    Clone function for memops.Implementation.BooleanMatrix
    """
    dataDict = self.__dict__
    attrlinks = {}
    attrlinks['data'] = dataDict.get('data')
    attrlinks['shape'] = dataDict.get('shape')
    for kk in attrDict.keys():
      attrlinks[kk] = attrDict.get(kk)

    return BooleanMatrix(**attrlinks)

  endOverride = MemopsDataTypeObject.endOverride
  
  def get(self, name):
    """
    GetAttr for memops.Implementation.BooleanMatrix
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getClassName = ComplexDataType.getClassName
  
  def getData(self):
    """
    Get for memops.Implementation.BooleanMatrix.data
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('data')
    result = tuple(tempVar)
    return result

  getFieldNames = ComplexDataType.getFieldNames

  getInConstructor = ComplexDataType.getInConstructor

  getMetaclass = ComplexDataType.getMetaclass

  getNdim = AbstractMatrix.getNdim

  getOverride = MemopsDataTypeObject.getOverride

  getPackageName = ComplexDataType.getPackageName

  getPackageShortName = ComplexDataType.getPackageShortName

  getQualifiedName = ComplexDataType.getQualifiedName

  getShape = AbstractMatrix.getShape

  getSize = AbstractMatrix.getSize

  getStrides = AbstractMatrix.getStrides

  getValue = AbstractMatrix.getValue

  pointValue = AbstractMatrix.pointValue
  
  def set(self, name, value):
    """
    SetAttr for memops.Implementation.BooleanMatrix
    """
    dataDict = self.__dict__
    setattr(self, name, value)
  
  def setData(self, values):
    """
    Set for memops.Implementation.BooleanMatrix.data
    """
    dataDict = self.__dict__
    values = list(values)
    for value in values:
      if (not (value in [True, False])):
        raise ApiError("""%s.setData:
         memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
         + ": %s" % (value,)
        )

    currentValues = dataDict.get('data')
    notInConstructor = not (dataDict.get('inConstructor'))

    notOverride = not (dataDict.get('override'))
    if (values == currentValues):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setData:
         cannot set data, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (len(values) < 1):
        raise ApiError("""%s.setData:
         locard: values must be of length >= 1""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['data'] = values

    # doNotifies

  setShape = AbstractMatrix.setShape

  subMatrix = AbstractMatrix.subMatrix

  toDetailedString = ComplexDataType.toDetailedString

  className = ComplexDataType.className
  
  data = property(getData, setData, None,
  r"""
  """)

  fieldNames = ComplexDataType.fieldNames

  inConstructor = ComplexDataType.inConstructor

  metaclass = ComplexDataType.metaclass

  ndim = AbstractMatrix.ndim

  override = MemopsDataTypeObject.override

  packageName = ComplexDataType.packageName

  packageShortName = ComplexDataType.packageShortName

  qualifiedName = ComplexDataType.qualifiedName

  shape = AbstractMatrix.shape

  size = AbstractMatrix.size

  strides = AbstractMatrix.strides

  value = AbstractMatrix.value

###############################################################################
class StringMatrix(AbstractMatrix):
  r"""nD Matrix of String elements.
  """
  #   from data model element memops.Implementation.StringMatrix revision 1.5
  _metaclass = metaPackage.getElement('StringMatrix')
  _packageName = 'memops.Implementation'
  _packageShortName = 'IMPL'
  _fieldNames = ('className', 'data', 'fieldNames', 'inConstructor', 'metaclass', 'ndim', 'override', 'packageName', 'packageShortName', 'qualifiedName', 'shape', 'size', 'strides', 'value',)
  
  def __init__(self, **attrlinks):
    """
    Constructor for memops.Implementation.StringMatrix
    """
    dataDict = self.__dict__

    override = attrlinks.get('override')
    if (override is None):
      override = False
    else:
      del attrlinks['override']

    if (override):
      dataDict['override'] = override

    notOverride = not (dataDict.get('override'))

    dataDict['data'] = list()
    dataDict['shape'] = list()

    dataDict['inConstructor'] = True
    try:
      
      for key, value in attrlinks.iteritems():
        try:
          func = getattr(self.__class__, key).fset
        except:
          raise ApiError("%s: error setting %s - not a modeled attribute"
                         % (self, key))
        if func is None:
          raise ApiError("%s: error setting %s - not a settable attribute"
                         % (self, key))
        else:
          func(self, value)
      del dataDict['inConstructor']
    except:
      print "ERROR in memops.Implementation.StringMatrix.__init__"
      del dataDict['inConstructor']
      raise

    if (notOverride):
      self.checkValid()

    # doNotifies
  
  def checkAllValid(self, complete=False):
    """
    CheckAllValid for memops.Implementation.StringMatrix
    """
    dataDict = self.__dict__
    self.checkValid(complete)
  
  def checkValid(self, complete=False):
    """
    CheckValid for memops.Implementation.StringMatrix
    """
    dataDict = self.__dict__
    if (complete):
      # check attributes
      values = dataDict.get('data')
      for value in values:
        if (isinstance(value, String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: data:
           memops.Implementation.String input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = self.getNdim()
      if (value is None):
        raise ApiError("""%s.checkValid: ndim:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, Int.PythonType)):
        pass
      elif ([x for x in Int.compatibleTypes if isinstance(value, x)]):
        value = Int.create(value)
      else:
        raise ApiError("""%s.checkValid: ndim:
         memops.Implementation.NonNegativeInt input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value >= 0)):
        raise ApiError("""%s.checkValid: ndim:
         NonNegativeInt constraint int_value_ge_0 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      values = dataDict.get('shape')
      for value in values:
        if (isinstance(value, Int.PythonType)):
          pass
        elif ([x for x in Int.compatibleTypes if isinstance(value, x)]):
          castValue = Int.create(value)
          replaceIndex = values.index(value)
          values[replaceIndex] = castValue
          value = castValue
        else:
          raise ApiError("""%s.checkValid: shape:
           memops.Implementation.PositiveInt input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (value > 0)):
          raise ApiError("""%s.checkValid: shape:
           PositiveInt constraint int_value_gt_0 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = self.getSize()
      if (value is None):
        raise ApiError("""%s.checkValid: size:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, Int.PythonType)):
        pass
      elif ([x for x in Int.compatibleTypes if isinstance(value, x)]):
        value = Int.create(value)
      else:
        raise ApiError("""%s.checkValid: size:
         memops.Implementation.NonNegativeInt input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value >= 0)):
        raise ApiError("""%s.checkValid: size:
         NonNegativeInt constraint int_value_ge_0 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      values = self.getStrides()
      for value in values:
        if (isinstance(value, Int.PythonType)):
          pass
        elif ([x for x in Int.compatibleTypes if isinstance(value, x)]):
          castValue = Int.create(value)
          replaceIndex = values.index(value)
          values[replaceIndex] = castValue
          value = castValue
        else:
          raise ApiError("""%s.checkValid: strides:
           memops.Implementation.PositiveInt input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (value > 0)):
          raise ApiError("""%s.checkValid: strides:
           PositiveInt constraint int_value_gt_0 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      values = self.getValue()
      for value in values:
        pass

    if (dataDict.get('override')):
      raise ApiError("""%s.checkValid:
       override is on""" % self.qualifiedName
       + ": %s" % (self,)
      )

    # check explicit class constraints
    if (not (self.size == len(self.data))):
      raise ApiError("""%s.checkValid:
       constraint matrix_size_eq_data_size violated""" % self.qualifiedName
       + ": %s" % (self,)
      )

    # check attributes
    values = dataDict.get('data')
    if (len(values) < 1):
      raise ApiError("""%s.checkValid: data:
       locard: values must be of length >= 1""" % self.qualifiedName
       + ": %s" % (self,)
      )

    values = dataDict.get('shape')
    if (len(values) < 1):
      raise ApiError("""%s.checkValid: shape:
       locard: values must be of length >= 1""" % self.qualifiedName
       + ": %s" % (self,)
      )

  def clone(self, **attrDict):
    """
    Clone function for memops.Implementation.StringMatrix
    """
    dataDict = self.__dict__
    attrlinks = {}
    attrlinks['data'] = dataDict.get('data')
    attrlinks['shape'] = dataDict.get('shape')
    for kk in attrDict.keys():
      attrlinks[kk] = attrDict.get(kk)

    return StringMatrix(**attrlinks)

  endOverride = MemopsDataTypeObject.endOverride
  
  def get(self, name):
    """
    GetAttr for memops.Implementation.StringMatrix
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getClassName = ComplexDataType.getClassName
  
  def getData(self):
    """
    Get for memops.Implementation.StringMatrix.data
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('data')
    result = tuple(tempVar)
    return result

  getFieldNames = ComplexDataType.getFieldNames

  getInConstructor = ComplexDataType.getInConstructor

  getMetaclass = ComplexDataType.getMetaclass

  getNdim = AbstractMatrix.getNdim

  getOverride = MemopsDataTypeObject.getOverride

  getPackageName = ComplexDataType.getPackageName

  getPackageShortName = ComplexDataType.getPackageShortName

  getQualifiedName = ComplexDataType.getQualifiedName

  getShape = AbstractMatrix.getShape

  getSize = AbstractMatrix.getSize

  getStrides = AbstractMatrix.getStrides

  getValue = AbstractMatrix.getValue

  pointValue = AbstractMatrix.pointValue
  
  def set(self, name, value):
    """
    SetAttr for memops.Implementation.StringMatrix
    """
    dataDict = self.__dict__
    setattr(self, name, value)
  
  def setData(self, values):
    """
    Set for memops.Implementation.StringMatrix.data
    """
    dataDict = self.__dict__
    values = list(values)
    for value in values:
      if (isinstance(value, String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setData:
         memops.Implementation.String input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

    currentValues = dataDict.get('data')
    notInConstructor = not (dataDict.get('inConstructor'))

    notOverride = not (dataDict.get('override'))
    if (values == currentValues):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setData:
         cannot set data, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (len(values) < 1):
        raise ApiError("""%s.setData:
         locard: values must be of length >= 1""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['data'] = values

    # doNotifies

  setShape = AbstractMatrix.setShape

  subMatrix = AbstractMatrix.subMatrix

  toDetailedString = ComplexDataType.toDetailedString

  className = ComplexDataType.className
  
  data = property(getData, setData, None,
  r"""
  """)

  fieldNames = ComplexDataType.fieldNames

  inConstructor = ComplexDataType.inConstructor

  metaclass = ComplexDataType.metaclass

  ndim = AbstractMatrix.ndim

  override = MemopsDataTypeObject.override

  packageName = ComplexDataType.packageName

  packageShortName = ComplexDataType.packageShortName

  qualifiedName = ComplexDataType.qualifiedName

  shape = AbstractMatrix.shape

  size = AbstractMatrix.size

  strides = AbstractMatrix.strides

  value = AbstractMatrix.value

###############################################################################
class FloatMatrix(AbstractMatrix):
  r"""nD Matrix of Float elements.
  """
  #   from data model element memops.Implementation.FloatMatrix revision 1.5
  _metaclass = metaPackage.getElement('FloatMatrix')
  _packageName = 'memops.Implementation'
  _packageShortName = 'IMPL'
  _fieldNames = ('className', 'data', 'fieldNames', 'inConstructor', 'metaclass', 'ndim', 'override', 'packageName', 'packageShortName', 'qualifiedName', 'shape', 'size', 'strides', 'value',)
  
  def __init__(self, **attrlinks):
    """
    Constructor for memops.Implementation.FloatMatrix
    """
    dataDict = self.__dict__

    override = attrlinks.get('override')
    if (override is None):
      override = False
    else:
      del attrlinks['override']

    if (override):
      dataDict['override'] = override

    notOverride = not (dataDict.get('override'))

    dataDict['data'] = list()
    dataDict['shape'] = list()

    dataDict['inConstructor'] = True
    try:
      
      for key, value in attrlinks.iteritems():
        try:
          func = getattr(self.__class__, key).fset
        except:
          raise ApiError("%s: error setting %s - not a modeled attribute"
                         % (self, key))
        if func is None:
          raise ApiError("%s: error setting %s - not a settable attribute"
                         % (self, key))
        else:
          func(self, value)
      del dataDict['inConstructor']
    except:
      print "ERROR in memops.Implementation.FloatMatrix.__init__"
      del dataDict['inConstructor']
      raise

    if (notOverride):
      self.checkValid()

    # doNotifies
  
  def checkAllValid(self, complete=False):
    """
    CheckAllValid for memops.Implementation.FloatMatrix
    """
    dataDict = self.__dict__
    self.checkValid(complete)
  
  def checkValid(self, complete=False):
    """
    CheckValid for memops.Implementation.FloatMatrix
    """
    dataDict = self.__dict__
    if (complete):
      # check attributes
      values = dataDict.get('data')
      for value in values:
        if (isinstance(value, Float.PythonType)):
          pass
        elif ([x for x in Float.compatibleTypes if isinstance(value, x)]):
          castValue = Float.create(value)
          replaceIndex = values.index(value)
          values[replaceIndex] = castValue
          value = castValue
        else:
          raise ApiError("""%s.checkValid: data:
           memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (value - value == 0.0)):
          raise ApiError("""%s.checkValid: data:
           Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = self.getNdim()
      if (value is None):
        raise ApiError("""%s.checkValid: ndim:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, Int.PythonType)):
        pass
      elif ([x for x in Int.compatibleTypes if isinstance(value, x)]):
        value = Int.create(value)
      else:
        raise ApiError("""%s.checkValid: ndim:
         memops.Implementation.NonNegativeInt input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value >= 0)):
        raise ApiError("""%s.checkValid: ndim:
         NonNegativeInt constraint int_value_ge_0 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      values = dataDict.get('shape')
      for value in values:
        if (isinstance(value, Int.PythonType)):
          pass
        elif ([x for x in Int.compatibleTypes if isinstance(value, x)]):
          castValue = Int.create(value)
          replaceIndex = values.index(value)
          values[replaceIndex] = castValue
          value = castValue
        else:
          raise ApiError("""%s.checkValid: shape:
           memops.Implementation.PositiveInt input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (value > 0)):
          raise ApiError("""%s.checkValid: shape:
           PositiveInt constraint int_value_gt_0 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = self.getSize()
      if (value is None):
        raise ApiError("""%s.checkValid: size:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, Int.PythonType)):
        pass
      elif ([x for x in Int.compatibleTypes if isinstance(value, x)]):
        value = Int.create(value)
      else:
        raise ApiError("""%s.checkValid: size:
         memops.Implementation.NonNegativeInt input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value >= 0)):
        raise ApiError("""%s.checkValid: size:
         NonNegativeInt constraint int_value_ge_0 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      values = self.getStrides()
      for value in values:
        if (isinstance(value, Int.PythonType)):
          pass
        elif ([x for x in Int.compatibleTypes if isinstance(value, x)]):
          castValue = Int.create(value)
          replaceIndex = values.index(value)
          values[replaceIndex] = castValue
          value = castValue
        else:
          raise ApiError("""%s.checkValid: strides:
           memops.Implementation.PositiveInt input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (value > 0)):
          raise ApiError("""%s.checkValid: strides:
           PositiveInt constraint int_value_gt_0 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      values = self.getValue()
      for value in values:
        pass

    if (dataDict.get('override')):
      raise ApiError("""%s.checkValid:
       override is on""" % self.qualifiedName
       + ": %s" % (self,)
      )

    # check explicit class constraints
    if (not (self.size == len(self.data))):
      raise ApiError("""%s.checkValid:
       constraint matrix_size_eq_data_size violated""" % self.qualifiedName
       + ": %s" % (self,)
      )

    # check attributes
    values = dataDict.get('data')
    if (len(values) < 1):
      raise ApiError("""%s.checkValid: data:
       locard: values must be of length >= 1""" % self.qualifiedName
       + ": %s" % (self,)
      )

    values = dataDict.get('shape')
    if (len(values) < 1):
      raise ApiError("""%s.checkValid: shape:
       locard: values must be of length >= 1""" % self.qualifiedName
       + ": %s" % (self,)
      )

  def clone(self, **attrDict):
    """
    Clone function for memops.Implementation.FloatMatrix
    """
    dataDict = self.__dict__
    attrlinks = {}
    attrlinks['data'] = dataDict.get('data')
    attrlinks['shape'] = dataDict.get('shape')
    for kk in attrDict.keys():
      attrlinks[kk] = attrDict.get(kk)

    return FloatMatrix(**attrlinks)

  endOverride = MemopsDataTypeObject.endOverride
  
  def get(self, name):
    """
    GetAttr for memops.Implementation.FloatMatrix
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getClassName = ComplexDataType.getClassName
  
  def getData(self):
    """
    Get for memops.Implementation.FloatMatrix.data
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('data')
    result = tuple(tempVar)
    return result

  getFieldNames = ComplexDataType.getFieldNames

  getInConstructor = ComplexDataType.getInConstructor

  getMetaclass = ComplexDataType.getMetaclass

  getNdim = AbstractMatrix.getNdim

  getOverride = MemopsDataTypeObject.getOverride

  getPackageName = ComplexDataType.getPackageName

  getPackageShortName = ComplexDataType.getPackageShortName

  getQualifiedName = ComplexDataType.getQualifiedName

  getShape = AbstractMatrix.getShape

  getSize = AbstractMatrix.getSize

  getStrides = AbstractMatrix.getStrides

  getValue = AbstractMatrix.getValue

  pointValue = AbstractMatrix.pointValue
  
  def set(self, name, value):
    """
    SetAttr for memops.Implementation.FloatMatrix
    """
    dataDict = self.__dict__
    setattr(self, name, value)
  
  def setData(self, values):
    """
    Set for memops.Implementation.FloatMatrix.data
    """
    dataDict = self.__dict__
    values = list(values)
    for value in values:
      if (isinstance(value, Float.PythonType)):
        pass
      elif ([x for x in Float.compatibleTypes if isinstance(value, x)]):
        castValue = Float.create(value)
        replaceIndex = values.index(value)
        values[replaceIndex] = castValue
        value = castValue
      else:
        raise ApiError("""%s.setData:
         memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value - value == 0.0)):
        raise ApiError("""%s.setData:
         Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    currentValues = dataDict.get('data')
    notInConstructor = not (dataDict.get('inConstructor'))

    notOverride = not (dataDict.get('override'))
    if (values == currentValues):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setData:
         cannot set data, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (len(values) < 1):
        raise ApiError("""%s.setData:
         locard: values must be of length >= 1""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['data'] = values

    # doNotifies

  setShape = AbstractMatrix.setShape

  subMatrix = AbstractMatrix.subMatrix

  toDetailedString = ComplexDataType.toDetailedString

  className = ComplexDataType.className
  
  data = property(getData, setData, None,
  r"""
  """)

  fieldNames = ComplexDataType.fieldNames

  inConstructor = ComplexDataType.inConstructor

  metaclass = ComplexDataType.metaclass

  ndim = AbstractMatrix.ndim

  override = MemopsDataTypeObject.override

  packageName = ComplexDataType.packageName

  packageShortName = ComplexDataType.packageShortName

  qualifiedName = ComplexDataType.qualifiedName

  shape = AbstractMatrix.shape

  size = AbstractMatrix.size

  strides = AbstractMatrix.strides

  value = AbstractMatrix.value

###############################################################################
class AppDataString(ApplicationData):
  r"""String type application data.
  """
  #   from data model element memops.Implementation.AppDataString revision 1.46
  _metaclass = metaPackage.getElement('AppDataString')
  _packageName = 'memops.Implementation'
  _packageShortName = 'IMPL'
  _fieldNames = ('application', 'className', 'fieldNames', 'inConstructor', 'keyword', 'metaclass', 'override', 'packageName', 'packageShortName', 'qualifiedName', 'value',)
  
  def __init__(self, **attrlinks):
    """
    Constructor for memops.Implementation.AppDataString
    """
    dataDict = self.__dict__

    override = attrlinks.get('override')
    if (override is None):
      override = False
    else:
      del attrlinks['override']

    if (override):
      dataDict['override'] = override

    notOverride = not (dataDict.get('override'))

    dataDict['application'] = None
    dataDict['keyword'] = None
    dataDict['value'] = None

    dataDict['inConstructor'] = True
    try:
      
      for key, value in attrlinks.iteritems():
        try:
          func = getattr(self.__class__, key).fset
        except:
          raise ApiError("%s: error setting %s - not a modeled attribute"
                         % (self, key))
        if func is None:
          raise ApiError("%s: error setting %s - not a settable attribute"
                         % (self, key))
        else:
          func(self, value)
      del dataDict['inConstructor']
    except:
      print "ERROR in memops.Implementation.AppDataString.__init__"
      del dataDict['inConstructor']
      raise

    if (notOverride):
      self.checkValid()

    # doNotifies
  
  def checkAllValid(self, complete=False):
    """
    CheckAllValid for memops.Implementation.AppDataString
    """
    dataDict = self.__dict__
    self.checkValid(complete)
  
  def checkValid(self, complete=False):
    """
    CheckValid for memops.Implementation.AppDataString
    """
    dataDict = self.__dict__
    if (complete):
      # check attributes
      value = dataDict.get('application')
      if (isinstance(value, String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: application:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: application:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: application:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: application:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('keyword')
      if (isinstance(value, String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: keyword:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: keyword:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: keyword:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: keyword:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('value')
      if (isinstance(value, String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: value:
         memops.Implementation.String input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

    if (dataDict.get('override')):
      raise ApiError("""%s.checkValid:
       override is on""" % self.qualifiedName
       + ": %s" % (self,)
      )

    # check explicit class constraints
    # check attributes
    value = dataDict.get('application')
    if (value is None):
      raise ApiError("""%s.checkValid: application:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('keyword')
    if (value is None):
      raise ApiError("""%s.checkValid: keyword:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('value')
    if (value is None):
      raise ApiError("""%s.checkValid: value:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

  def clone(self, **attrDict):
    """
    Clone function for memops.Implementation.AppDataString
    """
    dataDict = self.__dict__
    attrlinks = {}
    attrlinks['application'] = dataDict.get('application')
    attrlinks['keyword'] = dataDict.get('keyword')
    attrlinks['value'] = dataDict.get('value')
    for kk in attrDict.keys():
      attrlinks[kk] = attrDict.get(kk)

    return AppDataString(**attrlinks)

  endOverride = MemopsDataTypeObject.endOverride
  
  def get(self, name):
    """
    GetAttr for memops.Implementation.AppDataString
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getApplication = ApplicationData.getApplication

  getClassName = ComplexDataType.getClassName

  getFieldNames = ComplexDataType.getFieldNames

  getInConstructor = ComplexDataType.getInConstructor

  getKeyword = ApplicationData.getKeyword

  getMetaclass = ComplexDataType.getMetaclass

  getOverride = MemopsDataTypeObject.getOverride

  getPackageName = ComplexDataType.getPackageName

  getPackageShortName = ComplexDataType.getPackageShortName

  getQualifiedName = ComplexDataType.getQualifiedName
  
  def getValue(self):
    """
    Get for memops.Implementation.AppDataString.value
    """
    dataDict = self.__dict__
    result = dataDict.get('value')
    return result
  
  def set(self, name, value):
    """
    SetAttr for memops.Implementation.AppDataString
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setApplication = ApplicationData.setApplication

  setKeyword = ApplicationData.setKeyword
  
  def setValue(self, value):
    """
    Set for memops.Implementation.AppDataString.value
    """
    dataDict = self.__dict__
    if (isinstance(value, String.PythonType)):
      pass
    else:
      raise ApiError("""%s.setValue:
       memops.Implementation.String input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    currentValue = dataDict.get('value')
    notInConstructor = not (dataDict.get('inConstructor'))

    notOverride = not (dataDict.get('override'))
    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setValue:
         cannot set value, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setValue:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['value'] = value

    # doNotifies

  toDetailedString = ComplexDataType.toDetailedString

  application = ApplicationData.application

  className = ComplexDataType.className

  fieldNames = ComplexDataType.fieldNames

  inConstructor = ComplexDataType.inConstructor

  keyword = ApplicationData.keyword

  metaclass = ComplexDataType.metaclass

  override = MemopsDataTypeObject.override

  packageName = ComplexDataType.packageName

  packageShortName = ComplexDataType.packageShortName

  qualifiedName = ComplexDataType.qualifiedName
  
  value = property(getValue, setValue, None,
  r"""Data value
  """)

###############################################################################
class AppDataDouble(ApplicationData):
  r"""Double type application data.
  """
  #   from data model element memops.Implementation.AppDataDouble revision 1.46
  _metaclass = metaPackage.getElement('AppDataDouble')
  _packageName = 'memops.Implementation'
  _packageShortName = 'IMPL'
  _fieldNames = ('application', 'className', 'fieldNames', 'inConstructor', 'keyword', 'metaclass', 'override', 'packageName', 'packageShortName', 'qualifiedName', 'value',)
  
  def __init__(self, **attrlinks):
    """
    Constructor for memops.Implementation.AppDataDouble
    """
    dataDict = self.__dict__

    override = attrlinks.get('override')
    if (override is None):
      override = False
    else:
      del attrlinks['override']

    if (override):
      dataDict['override'] = override

    notOverride = not (dataDict.get('override'))

    dataDict['application'] = None
    dataDict['keyword'] = None
    dataDict['value'] = None

    dataDict['inConstructor'] = True
    try:
      
      for key, value in attrlinks.iteritems():
        try:
          func = getattr(self.__class__, key).fset
        except:
          raise ApiError("%s: error setting %s - not a modeled attribute"
                         % (self, key))
        if func is None:
          raise ApiError("%s: error setting %s - not a settable attribute"
                         % (self, key))
        else:
          func(self, value)
      del dataDict['inConstructor']
    except:
      print "ERROR in memops.Implementation.AppDataDouble.__init__"
      del dataDict['inConstructor']
      raise

    if (notOverride):
      self.checkValid()

    # doNotifies
  
  def checkAllValid(self, complete=False):
    """
    CheckAllValid for memops.Implementation.AppDataDouble
    """
    dataDict = self.__dict__
    self.checkValid(complete)
  
  def checkValid(self, complete=False):
    """
    CheckValid for memops.Implementation.AppDataDouble
    """
    dataDict = self.__dict__
    if (complete):
      # check attributes
      value = dataDict.get('application')
      if (isinstance(value, String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: application:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: application:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: application:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: application:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('keyword')
      if (isinstance(value, String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: keyword:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: keyword:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: keyword:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: keyword:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('value')
      if (isinstance(value, Double.PythonType)):
        pass
      elif ([x for x in Double.compatibleTypes if isinstance(value, x)]):
        value = Double.create(value)
      else:
        raise ApiError("""%s.checkValid: value:
         memops.Implementation.Double input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value - value == 0.0)):
        raise ApiError("""%s.checkValid: value:
         Double constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    if (dataDict.get('override')):
      raise ApiError("""%s.checkValid:
       override is on""" % self.qualifiedName
       + ": %s" % (self,)
      )

    # check explicit class constraints
    # check attributes
    value = dataDict.get('application')
    if (value is None):
      raise ApiError("""%s.checkValid: application:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('keyword')
    if (value is None):
      raise ApiError("""%s.checkValid: keyword:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('value')
    if (value is None):
      raise ApiError("""%s.checkValid: value:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

  def clone(self, **attrDict):
    """
    Clone function for memops.Implementation.AppDataDouble
    """
    dataDict = self.__dict__
    attrlinks = {}
    attrlinks['application'] = dataDict.get('application')
    attrlinks['keyword'] = dataDict.get('keyword')
    attrlinks['value'] = dataDict.get('value')
    for kk in attrDict.keys():
      attrlinks[kk] = attrDict.get(kk)

    return AppDataDouble(**attrlinks)

  endOverride = MemopsDataTypeObject.endOverride
  
  def get(self, name):
    """
    GetAttr for memops.Implementation.AppDataDouble
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getApplication = ApplicationData.getApplication

  getClassName = ComplexDataType.getClassName

  getFieldNames = ComplexDataType.getFieldNames

  getInConstructor = ComplexDataType.getInConstructor

  getKeyword = ApplicationData.getKeyword

  getMetaclass = ComplexDataType.getMetaclass

  getOverride = MemopsDataTypeObject.getOverride

  getPackageName = ComplexDataType.getPackageName

  getPackageShortName = ComplexDataType.getPackageShortName

  getQualifiedName = ComplexDataType.getQualifiedName
  
  def getValue(self):
    """
    Get for memops.Implementation.AppDataDouble.value
    """
    dataDict = self.__dict__
    result = dataDict.get('value')
    return result
  
  def set(self, name, value):
    """
    SetAttr for memops.Implementation.AppDataDouble
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setApplication = ApplicationData.setApplication

  setKeyword = ApplicationData.setKeyword
  
  def setValue(self, value):
    """
    Set for memops.Implementation.AppDataDouble.value
    """
    dataDict = self.__dict__
    if (isinstance(value, Double.PythonType)):
      pass
    elif ([x for x in Double.compatibleTypes if isinstance(value, x)]):
      value = Double.create(value)
    else:
      raise ApiError("""%s.setValue:
       memops.Implementation.Double input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value - value == 0.0)):
      raise ApiError("""%s.setValue:
       Double constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    currentValue = dataDict.get('value')
    notInConstructor = not (dataDict.get('inConstructor'))

    notOverride = not (dataDict.get('override'))
    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setValue:
         cannot set value, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setValue:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['value'] = value

    # doNotifies

  toDetailedString = ComplexDataType.toDetailedString

  application = ApplicationData.application

  className = ComplexDataType.className

  fieldNames = ComplexDataType.fieldNames

  inConstructor = ComplexDataType.inConstructor

  keyword = ApplicationData.keyword

  metaclass = ComplexDataType.metaclass

  override = MemopsDataTypeObject.override

  packageName = ComplexDataType.packageName

  packageShortName = ComplexDataType.packageShortName

  qualifiedName = ComplexDataType.qualifiedName
  
  value = property(getValue, setValue, None,
  r"""Data value
  """)

###############################################################################
class AppDataFloat(ApplicationData):
  r"""Float type application data.
  """
  #   from data model element memops.Implementation.AppDataFloat revision 1.46
  _metaclass = metaPackage.getElement('AppDataFloat')
  _packageName = 'memops.Implementation'
  _packageShortName = 'IMPL'
  _fieldNames = ('application', 'className', 'fieldNames', 'inConstructor', 'keyword', 'metaclass', 'override', 'packageName', 'packageShortName', 'qualifiedName', 'value',)
  
  def __init__(self, **attrlinks):
    """
    Constructor for memops.Implementation.AppDataFloat
    """
    dataDict = self.__dict__

    override = attrlinks.get('override')
    if (override is None):
      override = False
    else:
      del attrlinks['override']

    if (override):
      dataDict['override'] = override

    notOverride = not (dataDict.get('override'))

    dataDict['application'] = None
    dataDict['keyword'] = None
    dataDict['value'] = None

    dataDict['inConstructor'] = True
    try:
      
      for key, value in attrlinks.iteritems():
        try:
          func = getattr(self.__class__, key).fset
        except:
          raise ApiError("%s: error setting %s - not a modeled attribute"
                         % (self, key))
        if func is None:
          raise ApiError("%s: error setting %s - not a settable attribute"
                         % (self, key))
        else:
          func(self, value)
      del dataDict['inConstructor']
    except:
      print "ERROR in memops.Implementation.AppDataFloat.__init__"
      del dataDict['inConstructor']
      raise

    if (notOverride):
      self.checkValid()

    # doNotifies
  
  def checkAllValid(self, complete=False):
    """
    CheckAllValid for memops.Implementation.AppDataFloat
    """
    dataDict = self.__dict__
    self.checkValid(complete)
  
  def checkValid(self, complete=False):
    """
    CheckValid for memops.Implementation.AppDataFloat
    """
    dataDict = self.__dict__
    if (complete):
      # check attributes
      value = dataDict.get('application')
      if (isinstance(value, String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: application:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: application:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: application:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: application:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('keyword')
      if (isinstance(value, String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: keyword:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: keyword:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: keyword:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: keyword:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('value')
      if (isinstance(value, Float.PythonType)):
        pass
      elif ([x for x in Float.compatibleTypes if isinstance(value, x)]):
        value = Float.create(value)
      else:
        raise ApiError("""%s.checkValid: value:
         memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (value - value == 0.0)):
        raise ApiError("""%s.checkValid: value:
         Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    if (dataDict.get('override')):
      raise ApiError("""%s.checkValid:
       override is on""" % self.qualifiedName
       + ": %s" % (self,)
      )

    # check explicit class constraints
    # check attributes
    value = dataDict.get('application')
    if (value is None):
      raise ApiError("""%s.checkValid: application:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('keyword')
    if (value is None):
      raise ApiError("""%s.checkValid: keyword:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('value')
    if (value is None):
      raise ApiError("""%s.checkValid: value:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

  def clone(self, **attrDict):
    """
    Clone function for memops.Implementation.AppDataFloat
    """
    dataDict = self.__dict__
    attrlinks = {}
    attrlinks['application'] = dataDict.get('application')
    attrlinks['keyword'] = dataDict.get('keyword')
    attrlinks['value'] = dataDict.get('value')
    for kk in attrDict.keys():
      attrlinks[kk] = attrDict.get(kk)

    return AppDataFloat(**attrlinks)

  endOverride = MemopsDataTypeObject.endOverride
  
  def get(self, name):
    """
    GetAttr for memops.Implementation.AppDataFloat
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getApplication = ApplicationData.getApplication

  getClassName = ComplexDataType.getClassName

  getFieldNames = ComplexDataType.getFieldNames

  getInConstructor = ComplexDataType.getInConstructor

  getKeyword = ApplicationData.getKeyword

  getMetaclass = ComplexDataType.getMetaclass

  getOverride = MemopsDataTypeObject.getOverride

  getPackageName = ComplexDataType.getPackageName

  getPackageShortName = ComplexDataType.getPackageShortName

  getQualifiedName = ComplexDataType.getQualifiedName
  
  def getValue(self):
    """
    Get for memops.Implementation.AppDataFloat.value
    """
    dataDict = self.__dict__
    result = dataDict.get('value')
    return result
  
  def set(self, name, value):
    """
    SetAttr for memops.Implementation.AppDataFloat
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setApplication = ApplicationData.setApplication

  setKeyword = ApplicationData.setKeyword
  
  def setValue(self, value):
    """
    Set for memops.Implementation.AppDataFloat.value
    """
    dataDict = self.__dict__
    if (isinstance(value, Float.PythonType)):
      pass
    elif ([x for x in Float.compatibleTypes if isinstance(value, x)]):
      value = Float.create(value)
    else:
      raise ApiError("""%s.setValue:
       memops.Implementation.Float input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (value - value == 0.0)):
      raise ApiError("""%s.setValue:
       Float constraint value_is_not_NaN_or_Infinity violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    currentValue = dataDict.get('value')
    notInConstructor = not (dataDict.get('inConstructor'))

    notOverride = not (dataDict.get('override'))
    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setValue:
         cannot set value, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setValue:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['value'] = value

    # doNotifies

  toDetailedString = ComplexDataType.toDetailedString

  application = ApplicationData.application

  className = ComplexDataType.className

  fieldNames = ComplexDataType.fieldNames

  inConstructor = ComplexDataType.inConstructor

  keyword = ApplicationData.keyword

  metaclass = ComplexDataType.metaclass

  override = MemopsDataTypeObject.override

  packageName = ComplexDataType.packageName

  packageShortName = ComplexDataType.packageShortName

  qualifiedName = ComplexDataType.qualifiedName
  
  value = property(getValue, setValue, None,
  r"""Data value
  """)

###############################################################################
class AppDataLong(ApplicationData):
  r"""Long Int type application data.
  """
  #   from data model element memops.Implementation.AppDataLong revision 1.46
  _metaclass = metaPackage.getElement('AppDataLong')
  _packageName = 'memops.Implementation'
  _packageShortName = 'IMPL'
  _fieldNames = ('application', 'className', 'fieldNames', 'inConstructor', 'keyword', 'metaclass', 'override', 'packageName', 'packageShortName', 'qualifiedName', 'value',)
  
  def __init__(self, **attrlinks):
    """
    Constructor for memops.Implementation.AppDataLong
    """
    dataDict = self.__dict__

    override = attrlinks.get('override')
    if (override is None):
      override = False
    else:
      del attrlinks['override']

    if (override):
      dataDict['override'] = override

    notOverride = not (dataDict.get('override'))

    dataDict['application'] = None
    dataDict['keyword'] = None
    dataDict['value'] = None

    dataDict['inConstructor'] = True
    try:
      
      for key, value in attrlinks.iteritems():
        try:
          func = getattr(self.__class__, key).fset
        except:
          raise ApiError("%s: error setting %s - not a modeled attribute"
                         % (self, key))
        if func is None:
          raise ApiError("%s: error setting %s - not a settable attribute"
                         % (self, key))
        else:
          func(self, value)
      del dataDict['inConstructor']
    except:
      print "ERROR in memops.Implementation.AppDataLong.__init__"
      del dataDict['inConstructor']
      raise

    if (notOverride):
      self.checkValid()

    # doNotifies
  
  def checkAllValid(self, complete=False):
    """
    CheckAllValid for memops.Implementation.AppDataLong
    """
    dataDict = self.__dict__
    self.checkValid(complete)
  
  def checkValid(self, complete=False):
    """
    CheckValid for memops.Implementation.AppDataLong
    """
    dataDict = self.__dict__
    if (complete):
      # check attributes
      value = dataDict.get('application')
      if (isinstance(value, String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: application:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: application:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: application:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: application:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('keyword')
      if (isinstance(value, String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: keyword:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: keyword:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: keyword:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: keyword:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('value')
      if (isinstance(value, Long.PythonType)):
        pass
      elif ([x for x in Long.compatibleTypes if isinstance(value, x)]):
        value = Long.create(value)
      else:
        raise ApiError("""%s.checkValid: value:
         memops.Implementation.Long input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

    if (dataDict.get('override')):
      raise ApiError("""%s.checkValid:
       override is on""" % self.qualifiedName
       + ": %s" % (self,)
      )

    # check explicit class constraints
    # check attributes
    value = dataDict.get('application')
    if (value is None):
      raise ApiError("""%s.checkValid: application:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('keyword')
    if (value is None):
      raise ApiError("""%s.checkValid: keyword:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('value')
    if (value is None):
      raise ApiError("""%s.checkValid: value:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

  def clone(self, **attrDict):
    """
    Clone function for memops.Implementation.AppDataLong
    """
    dataDict = self.__dict__
    attrlinks = {}
    attrlinks['application'] = dataDict.get('application')
    attrlinks['keyword'] = dataDict.get('keyword')
    attrlinks['value'] = dataDict.get('value')
    for kk in attrDict.keys():
      attrlinks[kk] = attrDict.get(kk)

    return AppDataLong(**attrlinks)

  endOverride = MemopsDataTypeObject.endOverride
  
  def get(self, name):
    """
    GetAttr for memops.Implementation.AppDataLong
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getApplication = ApplicationData.getApplication

  getClassName = ComplexDataType.getClassName

  getFieldNames = ComplexDataType.getFieldNames

  getInConstructor = ComplexDataType.getInConstructor

  getKeyword = ApplicationData.getKeyword

  getMetaclass = ComplexDataType.getMetaclass

  getOverride = MemopsDataTypeObject.getOverride

  getPackageName = ComplexDataType.getPackageName

  getPackageShortName = ComplexDataType.getPackageShortName

  getQualifiedName = ComplexDataType.getQualifiedName
  
  def getValue(self):
    """
    Get for memops.Implementation.AppDataLong.value
    """
    dataDict = self.__dict__
    result = dataDict.get('value')
    return result
  
  def set(self, name, value):
    """
    SetAttr for memops.Implementation.AppDataLong
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setApplication = ApplicationData.setApplication

  setKeyword = ApplicationData.setKeyword
  
  def setValue(self, value):
    """
    Set for memops.Implementation.AppDataLong.value
    """
    dataDict = self.__dict__
    if (isinstance(value, Long.PythonType)):
      pass
    elif ([x for x in Long.compatibleTypes if isinstance(value, x)]):
      value = Long.create(value)
    else:
      raise ApiError("""%s.setValue:
       memops.Implementation.Long input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    currentValue = dataDict.get('value')
    notInConstructor = not (dataDict.get('inConstructor'))

    notOverride = not (dataDict.get('override'))
    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setValue:
         cannot set value, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setValue:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['value'] = value

    # doNotifies

  toDetailedString = ComplexDataType.toDetailedString

  application = ApplicationData.application

  className = ComplexDataType.className

  fieldNames = ComplexDataType.fieldNames

  inConstructor = ComplexDataType.inConstructor

  keyword = ApplicationData.keyword

  metaclass = ComplexDataType.metaclass

  override = MemopsDataTypeObject.override

  packageName = ComplexDataType.packageName

  packageShortName = ComplexDataType.packageShortName

  qualifiedName = ComplexDataType.qualifiedName
  
  value = property(getValue, setValue, None,
  r"""Data value
  """)

###############################################################################
class AppDataInt(ApplicationData):
  r"""Int type application data.
  """
  #   from data model element memops.Implementation.AppDataInt revision 1.46
  _metaclass = metaPackage.getElement('AppDataInt')
  _packageName = 'memops.Implementation'
  _packageShortName = 'IMPL'
  _fieldNames = ('application', 'className', 'fieldNames', 'inConstructor', 'keyword', 'metaclass', 'override', 'packageName', 'packageShortName', 'qualifiedName', 'value',)
  
  def __init__(self, **attrlinks):
    """
    Constructor for memops.Implementation.AppDataInt
    """
    dataDict = self.__dict__

    override = attrlinks.get('override')
    if (override is None):
      override = False
    else:
      del attrlinks['override']

    if (override):
      dataDict['override'] = override

    notOverride = not (dataDict.get('override'))

    dataDict['application'] = None
    dataDict['keyword'] = None
    dataDict['value'] = None

    dataDict['inConstructor'] = True
    try:
      
      for key, value in attrlinks.iteritems():
        try:
          func = getattr(self.__class__, key).fset
        except:
          raise ApiError("%s: error setting %s - not a modeled attribute"
                         % (self, key))
        if func is None:
          raise ApiError("%s: error setting %s - not a settable attribute"
                         % (self, key))
        else:
          func(self, value)
      del dataDict['inConstructor']
    except:
      print "ERROR in memops.Implementation.AppDataInt.__init__"
      del dataDict['inConstructor']
      raise

    if (notOverride):
      self.checkValid()

    # doNotifies
  
  def checkAllValid(self, complete=False):
    """
    CheckAllValid for memops.Implementation.AppDataInt
    """
    dataDict = self.__dict__
    self.checkValid(complete)
  
  def checkValid(self, complete=False):
    """
    CheckValid for memops.Implementation.AppDataInt
    """
    dataDict = self.__dict__
    if (complete):
      # check attributes
      value = dataDict.get('application')
      if (isinstance(value, String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: application:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: application:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: application:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: application:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('keyword')
      if (isinstance(value, String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: keyword:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: keyword:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: keyword:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: keyword:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('value')
      if (isinstance(value, Int.PythonType)):
        pass
      elif ([x for x in Int.compatibleTypes if isinstance(value, x)]):
        value = Int.create(value)
      else:
        raise ApiError("""%s.checkValid: value:
         memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

    if (dataDict.get('override')):
      raise ApiError("""%s.checkValid:
       override is on""" % self.qualifiedName
       + ": %s" % (self,)
      )

    # check explicit class constraints
    # check attributes
    value = dataDict.get('application')
    if (value is None):
      raise ApiError("""%s.checkValid: application:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('keyword')
    if (value is None):
      raise ApiError("""%s.checkValid: keyword:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('value')
    if (value is None):
      raise ApiError("""%s.checkValid: value:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

  def clone(self, **attrDict):
    """
    Clone function for memops.Implementation.AppDataInt
    """
    dataDict = self.__dict__
    attrlinks = {}
    attrlinks['application'] = dataDict.get('application')
    attrlinks['keyword'] = dataDict.get('keyword')
    attrlinks['value'] = dataDict.get('value')
    for kk in attrDict.keys():
      attrlinks[kk] = attrDict.get(kk)

    return AppDataInt(**attrlinks)

  endOverride = MemopsDataTypeObject.endOverride
  
  def get(self, name):
    """
    GetAttr for memops.Implementation.AppDataInt
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getApplication = ApplicationData.getApplication

  getClassName = ComplexDataType.getClassName

  getFieldNames = ComplexDataType.getFieldNames

  getInConstructor = ComplexDataType.getInConstructor

  getKeyword = ApplicationData.getKeyword

  getMetaclass = ComplexDataType.getMetaclass

  getOverride = MemopsDataTypeObject.getOverride

  getPackageName = ComplexDataType.getPackageName

  getPackageShortName = ComplexDataType.getPackageShortName

  getQualifiedName = ComplexDataType.getQualifiedName
  
  def getValue(self):
    """
    Get for memops.Implementation.AppDataInt.value
    """
    dataDict = self.__dict__
    result = dataDict.get('value')
    return result
  
  def set(self, name, value):
    """
    SetAttr for memops.Implementation.AppDataInt
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setApplication = ApplicationData.setApplication

  setKeyword = ApplicationData.setKeyword
  
  def setValue(self, value):
    """
    Set for memops.Implementation.AppDataInt.value
    """
    dataDict = self.__dict__
    if (isinstance(value, Int.PythonType)):
      pass
    elif ([x for x in Int.compatibleTypes if isinstance(value, x)]):
      value = Int.create(value)
    else:
      raise ApiError("""%s.setValue:
       memops.Implementation.Int input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    currentValue = dataDict.get('value')
    notInConstructor = not (dataDict.get('inConstructor'))

    notOverride = not (dataDict.get('override'))
    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setValue:
         cannot set value, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setValue:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['value'] = value

    # doNotifies

  toDetailedString = ComplexDataType.toDetailedString

  application = ApplicationData.application

  className = ComplexDataType.className

  fieldNames = ComplexDataType.fieldNames

  inConstructor = ComplexDataType.inConstructor

  keyword = ApplicationData.keyword

  metaclass = ComplexDataType.metaclass

  override = MemopsDataTypeObject.override

  packageName = ComplexDataType.packageName

  packageShortName = ComplexDataType.packageShortName

  qualifiedName = ComplexDataType.qualifiedName
  
  value = property(getValue, setValue, None,
  r"""Data value
  """)

###############################################################################
class AppDataBoolean(ApplicationData):
  r"""Boolean type application data.
  """
  #   from data model element memops.Implementation.AppDataBoolean revision 1.46
  _metaclass = metaPackage.getElement('AppDataBoolean')
  _packageName = 'memops.Implementation'
  _packageShortName = 'IMPL'
  _fieldNames = ('application', 'className', 'fieldNames', 'inConstructor', 'keyword', 'metaclass', 'override', 'packageName', 'packageShortName', 'qualifiedName', 'value',)
  
  def __init__(self, **attrlinks):
    """
    Constructor for memops.Implementation.AppDataBoolean
    """
    dataDict = self.__dict__

    override = attrlinks.get('override')
    if (override is None):
      override = False
    else:
      del attrlinks['override']

    if (override):
      dataDict['override'] = override

    notOverride = not (dataDict.get('override'))

    dataDict['application'] = None
    dataDict['keyword'] = None
    dataDict['value'] = None

    dataDict['inConstructor'] = True
    try:
      
      for key, value in attrlinks.iteritems():
        try:
          func = getattr(self.__class__, key).fset
        except:
          raise ApiError("%s: error setting %s - not a modeled attribute"
                         % (self, key))
        if func is None:
          raise ApiError("%s: error setting %s - not a settable attribute"
                         % (self, key))
        else:
          func(self, value)
      del dataDict['inConstructor']
    except:
      print "ERROR in memops.Implementation.AppDataBoolean.__init__"
      del dataDict['inConstructor']
      raise

    if (notOverride):
      self.checkValid()

    # doNotifies
  
  def checkAllValid(self, complete=False):
    """
    CheckAllValid for memops.Implementation.AppDataBoolean
    """
    dataDict = self.__dict__
    self.checkValid(complete)
  
  def checkValid(self, complete=False):
    """
    CheckValid for memops.Implementation.AppDataBoolean
    """
    dataDict = self.__dict__
    if (complete):
      # check attributes
      value = dataDict.get('application')
      if (isinstance(value, String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: application:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: application:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: application:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: application:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('keyword')
      if (isinstance(value, String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: keyword:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: keyword:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: keyword:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: keyword:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('value')
      if (not (value in [True, False])):
        raise ApiError("""%s.checkValid: value:
         memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
         + ": %s" % (value,)
        )

    if (dataDict.get('override')):
      raise ApiError("""%s.checkValid:
       override is on""" % self.qualifiedName
       + ": %s" % (self,)
      )

    # check explicit class constraints
    # check attributes
    value = dataDict.get('application')
    if (value is None):
      raise ApiError("""%s.checkValid: application:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('keyword')
    if (value is None):
      raise ApiError("""%s.checkValid: keyword:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('value')
    if (value is None):
      raise ApiError("""%s.checkValid: value:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

  def clone(self, **attrDict):
    """
    Clone function for memops.Implementation.AppDataBoolean
    """
    dataDict = self.__dict__
    attrlinks = {}
    attrlinks['application'] = dataDict.get('application')
    attrlinks['keyword'] = dataDict.get('keyword')
    attrlinks['value'] = dataDict.get('value')
    for kk in attrDict.keys():
      attrlinks[kk] = attrDict.get(kk)

    return AppDataBoolean(**attrlinks)

  endOverride = MemopsDataTypeObject.endOverride
  
  def get(self, name):
    """
    GetAttr for memops.Implementation.AppDataBoolean
    """
    dataDict = self.__dict__
    return getattr(self, name)

  getApplication = ApplicationData.getApplication

  getClassName = ComplexDataType.getClassName

  getFieldNames = ComplexDataType.getFieldNames

  getInConstructor = ComplexDataType.getInConstructor

  getKeyword = ApplicationData.getKeyword

  getMetaclass = ComplexDataType.getMetaclass

  getOverride = MemopsDataTypeObject.getOverride

  getPackageName = ComplexDataType.getPackageName

  getPackageShortName = ComplexDataType.getPackageShortName

  getQualifiedName = ComplexDataType.getQualifiedName
  
  def getValue(self):
    """
    Get for memops.Implementation.AppDataBoolean.value
    """
    dataDict = self.__dict__
    result = dataDict.get('value')
    return result
  
  def set(self, name, value):
    """
    SetAttr for memops.Implementation.AppDataBoolean
    """
    dataDict = self.__dict__
    setattr(self, name, value)

  setApplication = ApplicationData.setApplication

  setKeyword = ApplicationData.setKeyword
  
  def setValue(self, value):
    """
    Set for memops.Implementation.AppDataBoolean.value
    """
    dataDict = self.__dict__
    if (not (value in [True, False])):
      raise ApiError("""%s.setValue:
       memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
       + ": %s" % (value,)
      )

    currentValue = dataDict.get('value')
    notInConstructor = not (dataDict.get('inConstructor'))

    notOverride = not (dataDict.get('override'))
    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setValue:
         cannot set value, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setValue:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['value'] = value

    # doNotifies

  toDetailedString = ComplexDataType.toDetailedString

  application = ApplicationData.application

  className = ComplexDataType.className

  fieldNames = ComplexDataType.fieldNames

  inConstructor = ComplexDataType.inConstructor

  keyword = ApplicationData.keyword

  metaclass = ComplexDataType.metaclass

  override = MemopsDataTypeObject.override

  packageName = ComplexDataType.packageName

  packageShortName = ComplexDataType.packageShortName

  qualifiedName = ComplexDataType.qualifiedName
  
  value = property(getValue, setValue, None,
  r"""Data value
  """)

###############################################################################
class MemopsObject(ComplexDataType):
  r"""Base class for Memops data model classes. 
Contains elements common to 
all classes, e.g. the link to ApplicationData, and the root and parent 
links. 
  """
  #   from data model element memops.Implementation.MemopsObject revision 1.62
  _metaclass = metaPackage.getElement('MemopsObject')
  _packageName = 'memops.Implementation'
  _packageShortName = 'IMPL'
  _fieldNames = ('className', 'fieldNames', 'inConstructor', 'isDeleted', 'metaclass', 'packageName', 'packageShortName', 'qualifiedName', 'root',)
  
  def __repr__(self):
    """
     string representation of object.
        identifies object uniquely, but can not be executed to regenerate it.
    
    """
    dataDict = self.__dict__
    try:
      className = self.getQualifiedName()
    except:
      className = self.__class__.__name__
    try:
      key = self.getFullKey()
    except:
      key = None
    if (dataDict.get('isDeleted')):
      ss = ' (deleted)'
    else:
      ss = ' '

    if (not (key)):
      key = id(self)
      ss = ss + 'id:'

    return '<%s%s%s>' % (className, ss, key)
  
  _notifies = {'':[]}

  __init__ = ComplexDataType.__init__

  checkAllValid = ComplexDataType.checkAllValid

  checkValid = ComplexDataType.checkValid
  
  def getByNavigation(self, *navigation):
    """
    Return object or element given a navigation sequence, or None if none
    found
        
    Intended to provide fast, one-function-call access to
    long 
    range navigation, mainly for UML-embedded code.
    NB there is no error 
    checking on the input. 
    The function may fail without proper warning for 
    incorrect input.
    Also the function bypasses the API on get commands, so 
    that load is
    not triggered on MemopsRoot->TopObject links or partially 
    filled
    interpackage crosslinks
    Programmer beware!
    
    Navigation starts at 
    self and follows the navigation sequence,
    which consists of either 
    string tags, or (tag,key) tuples.
    - For a string tag the function gets 
    the corresponding element.
    Except at the end of the navigation sequence, 
    this assumes that 
    the element has hicard==1, and is a link or complex 
    data type attribute.
    If the result evaluates false, a getattr is done 
    instead.
    This may trigger loading and follow derived links.
    - For a 
    (tag,key) tuple this assumes that the tag is the name of a 
    child link, 
    and gets the child with the given key.
    If no children are found and the 
    object has an attribute isLoaded==False, 
    object.load() is tried.
    - If 
    at any stage in the lookup no object is found, None is returned
    
    """
    dataDict = self.__dict__
    
    isa = isinstance
    
    result = self
    
    for xx in navigation:
      dd = result.__dict__
      if isa(xx,str):
        # xx is a role name - get the link
        result = dd.get(xx) or getattr(result,xx)
      
      else:
        # xx must be a (childlink,key) tuple. 
        tag,key = xx
        dd2 = dd[tag]
        if not dd2 and dd.get('isLoaded') == False:
          # we might need to load this
          try:
            result.load()
          except AttributeError:
            pass
        # Now get the child
        result = dd2.get(key)
      
      if result is None:
        break
    else:
    
      # freeze internal representations
      if isa(result, list):
        result = tuple(result)
      elif isa(result, set):
        result = frozenset(result)
      elif isa(result, dict):
        result = frozenset(result.values())
    return result

  getClassName = ComplexDataType.getClassName
  
  def getExpandedKey(self):
    """
    get expanded (object-free) version of full key, for comparing objects
    from different trees.
    """
    dataDict = self.__dict__
    result = self.getFullKey()
    
    for ii in range(len(result)):
      if isinstance(result[ii], MemopsObject):
        result[ii] = result[ii].getExpandedKey()
    return result

  getFieldNames = ComplexDataType.getFieldNames

  getInConstructor = ComplexDataType.getInConstructor
  
  def getIsDeleted(self):
    """
    Get for memops.Implementation.MemopsObject.isDeleted
    """
    dataDict = self.__dict__
    result = bool(dataDict.get('isDeleted'))
    return result

  getMetaclass = ComplexDataType.getMetaclass

  getPackageName = ComplexDataType.getPackageName

  getPackageShortName = ComplexDataType.getPackageShortName

  getQualifiedName = ComplexDataType.getQualifiedName
  
  def getRoot(self):
    """
    Get for memops.Implementation.MemopsObject.root
    """
    dataDict = self.__dict__
    result = dataDict.get('topObject').__dict__.get('memopsRoot')
    return result

  toDetailedString = ComplexDataType.toDetailedString

  className = ComplexDataType.className

  fieldNames = ComplexDataType.fieldNames

  inConstructor = ComplexDataType.inConstructor
  
  isDeleted = property(getIsDeleted, None, None,
  r"""Implementation attribute, set automatically. If True the object has been 
  deleted. Deleted objects are never returned by any API call, so there is 
  normally no need to check this attribute. But if you keep your own lists 
  (or other data structures) containing CCP objects, you may need to look.
  """)

  metaclass = ComplexDataType.metaclass

  packageName = ComplexDataType.packageName

  packageShortName = ComplexDataType.packageShortName

  qualifiedName = ComplexDataType.qualifiedName
  
  root = property(getRoot, None, None,
  r"""MemopsRoot object at top of parent tree.
  """)

###############################################################################
class ImplementationObject(MemopsObject):
  r"""Superclass for Implementation package objects
  """
  #   from data model element memops.Implementation.ImplementationObject revision 1.39
  _metaclass = metaPackage.getElement('ImplementationObject')
  _packageName = 'memops.Implementation'
  _packageShortName = 'IMPL'
  _fieldNames = ('className', 'fieldNames', 'inConstructor', 'isDeleted', 'metaclass', 'packageName', 'packageShortName', 'qualifiedName', 'root', 'topObject',)
  
  _notifies = {'':[]}

  __init__ = ComplexDataType.__init__

  checkAllValid = ComplexDataType.checkAllValid

  checkValid = ComplexDataType.checkValid

  getByNavigation = MemopsObject.getByNavigation

  getClassName = ComplexDataType.getClassName

  getExpandedKey = MemopsObject.getExpandedKey

  getFieldNames = ComplexDataType.getFieldNames

  getInConstructor = ComplexDataType.getInConstructor

  getIsDeleted = MemopsObject.getIsDeleted

  getMetaclass = ComplexDataType.getMetaclass

  getPackageName = ComplexDataType.getPackageName

  getPackageShortName = ComplexDataType.getPackageShortName

  getQualifiedName = ComplexDataType.getQualifiedName

  getRoot = MemopsObject.getRoot
  
  def getTopObject(self):
    """
    Get for memops.Implementation.ImplementationObject.topObject
    """
    dataDict = self.__dict__
    result = dataDict.get('topObject')
    return result

  toDetailedString = ComplexDataType.toDetailedString

  className = ComplexDataType.className

  fieldNames = ComplexDataType.fieldNames

  inConstructor = ComplexDataType.inConstructor

  isDeleted = MemopsObject.isDeleted

  metaclass = ComplexDataType.metaclass

  packageName = ComplexDataType.packageName

  packageShortName = ComplexDataType.packageShortName

  qualifiedName = ComplexDataType.qualifiedName

  root = MemopsObject.root
  
  topObject = property(getTopObject, None, None,
  r"""TopObject - topmost parent in package.
  """)

###############################################################################
class DataObject(MemopsObject):
  r"""Superclass for non-implementation classes
  """
  #   from data model element memops.Implementation.DataObject revision 1.41
  _metaclass = metaPackage.getElement('DataObject')
  _packageName = 'memops.Implementation'
  _packageShortName = 'IMPL'
  _fieldNames = ('applicationData', 'className', 'fieldNames', 'inConstructor', 'isDeleted', 'metaclass', 'packageName', 'packageShortName', 'qualifiedName', 'access', 'activeAccess', 'root', 'topObject',)
  
  _notifies = {'':[]}

  __init__ = ComplexDataType.__init__
  
  def addApplicationData(self, value):
    """
    Add for memops.Implementation.DataObject.applicationData
    """
    dataDict = self.__dict__
    if (not isinstance(value, ApplicationData)):
      raise ApiError("""%s.addApplicationData:
       value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    currentValues = dataDict.get('applicationData')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.addApplicationData:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.addApplicationData:
       called on deleted object""" % self.qualifiedName
      )

    if (notOverride):
      pass

    currentValues.append(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('addApplicationData')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  checkAllValid = ComplexDataType.checkAllValid

  checkValid = ComplexDataType.checkValid
  
  def delete(self):
    """
    FullDelete for memops.Implementation.DataObject
    """
    dataDict = self.__dict__
    topObject = dataDict.get('topObject')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    # objects to be deleted
    objsToBeDeleted = set()
    # objects still to be checked for cascading delete (each object to be deleted gets checked)
    objsToBeChecked = list()
    # counter keyed on (obj, roleName) for how many objects at other end of link are to be deleted
    linkCounter = {}

    # topObjects to check if modifiable
    topObjectsToCheck = set()

    objsToBeChecked.append(self)
    while len(objsToBeChecked) > 0:
      obj = objsToBeChecked.pop()
      obj._checkDelete(objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck)

    if (notInConstructor):
      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.delete:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.delete:
       called on deleted object""" % self.qualifiedName
      )

    for obj in objsToBeDeleted:
      obj._singleDelete(objsToBeDeleted)

    for topObjectModify in topObjectsToCheck:
      if (not (topObjectModify.__dict__.get('isLoaded'))):
        topObjectModify.load()

      topObjectModify.__dict__['isModified'] = True

    if (notOverride):
      if (notInConstructor):

        # doNotifies
        
        for obj in objsToBeDeleted:
          for notify in obj.__class__._notifies.get('delete', ()):
            notify(obj)

  def findAllApplicationData(self, **conditions):
    """
    FindAll for memops.Implementation.DataObject.applicationData
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      currentValues = dataDict.get('applicationData')
      result = list(currentValues)

    else:
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      currentValues = dataDict.get('applicationData')
      result = list()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('application', 'keyword',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.append(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result.append(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result.append(v)

    return result
  
  def findFirstApplicationData(self, **conditions):
    """
    FindFirst for memops.Implementation.DataObject.applicationData
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      currentValues = dataDict.get('applicationData')
      if (currentValues):
        result = currentValues[0]
      else:
        result = None

    else:
      if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
        dataDict.get('topObject').load()

      currentValues = dataDict.get('applicationData')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('application', 'keyword',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result = v; break

    return result
  
  def getAccess(self):
    """
    Get for memops.Implementation.DataObject.access
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    result = dataDict.get('access')
    return result
  
  def getActiveAccess(self):
    """
    Get Access object controlling access, either from object itself or one
    of its parents, recursively. Getter for derived link activeAccess.
    """
    dataDict = self.__dict__
    obj = self
    while hasattr(obj, 'access'):
      result = obj.access
      if result is not None:
        break
      obj = obj.parent
    return result
  
  def getApplicationData(self):
    """
    Get for memops.Implementation.DataObject.applicationData
    """
    dataDict = self.__dict__
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    tempVar = dataDict.get('applicationData')
    result = tuple(tempVar)
    return result

  getByNavigation = MemopsObject.getByNavigation

  getClassName = ComplexDataType.getClassName

  getExpandedKey = MemopsObject.getExpandedKey

  getFieldNames = ComplexDataType.getFieldNames

  getInConstructor = ComplexDataType.getInConstructor

  getIsDeleted = MemopsObject.getIsDeleted

  getMetaclass = ComplexDataType.getMetaclass

  getPackageName = ComplexDataType.getPackageName

  getPackageShortName = ComplexDataType.getPackageShortName

  getQualifiedName = ComplexDataType.getQualifiedName

  getRoot = MemopsObject.getRoot
  
  def getTopObject(self):
    """
    Get for memops.Implementation.DataObject.topObject
    """
    dataDict = self.__dict__
    result = dataDict.get('topObject')
    return result
  
  def removeApplicationData(self, value):
    """
    Remove for memops.Implementation.DataObject.applicationData
    """
    dataDict = self.__dict__
    if (not isinstance(value, ApplicationData)):
      raise ApiError("""%s.removeApplicationData:
       value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    currentValues = dataDict.get('applicationData')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.removeApplicationData:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.removeApplicationData:
       called on deleted object""" % self.qualifiedName
      )

    if (not (value in currentValues)):
      raise ApiError("""%s.removeApplicationData:
       value not in list""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      pass

    currentValues.remove(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('removeApplicationData')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setAccess(self, value):
    """
    Set for memops.Implementation.DataObject.access
    """
    dataDict = self.__dict__
    if (value is not None):
      from memops.api.AccessControl import AccessObject as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setAccess:
         value is not of class memops.AccessControl.AccessObject""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    currentValue = dataDict.get('access')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    topObjectsToCheck = None
    if (notIsReading):
      topObjectsToCheck = set()
      if (notInConstructor):
        topObject = dataDict.get('topObject')
        topObjectsToCheck.add(topObject)

      if (value is not None):
        topObject = value.__dict__.get('topObject')
        topObjectsToCheck.add(topObject)
        oldSelf = value.__dict__.get('dataObject')
        if (oldSelf is not None):
          if (notIsReading):
            topObject = oldSelf.__dict__.get('topObject')
            topObjectsToCheck.add(topObject)
          else:
            raise ApiError("""%s.setAccess:
             Read link incompatible with pre-existing link""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (currentValue is not None):
        topObject = currentValue.__dict__.get('topObject')
        topObjectsToCheck.add(topObject)

      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setAccess:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setAccess:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setAccess:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setAccess:
           Link access between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    if (currentValue is not None):
      currentValue.__dict__['dataObject'] = None

    if (value is not None):
      oldSelf = value.__dict__.get('dataObject')
      if (oldSelf is not None):
        oldSelf.__dict__['access'] = None

      value.__dict__['dataObject'] = self

    dataDict['access'] = value
    if (notIsReading):
      for topObjectModify in topObjectsToCheck:
        topObjectModify.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setAccess')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setApplicationData(self, values):
    """
    Set for memops.Implementation.DataObject.applicationData
    """
    dataDict = self.__dict__
    values = list(values)
    for value in values:
      if (not isinstance(value, ApplicationData)):
        raise ApiError("""%s.setApplicationData:
         value is not of class memops.Implementation.ApplicationData""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('topObject').__dict__.get('isLoaded') or dataDict.get('topObject').__dict__.get('isReading')))):
      dataDict.get('topObject').load()

    currentValues = dataDict.get('applicationData')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('topObject').__dict__.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setApplicationData:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setApplicationData:
       called on deleted object""" % self.qualifiedName
      )

    if (values == currentValues):
      return

    if (notOverride):
      pass

    dataDict['applicationData'] = values
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setApplicationData')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  toDetailedString = ComplexDataType.toDetailedString
  
  applicationData = property(getApplicationData, setApplicationData, None,
  r"""Application-specific data
  """)

  className = ComplexDataType.className

  fieldNames = ComplexDataType.fieldNames

  inConstructor = ComplexDataType.inConstructor

  isDeleted = MemopsObject.isDeleted

  metaclass = ComplexDataType.metaclass

  packageName = ComplexDataType.packageName

  packageShortName = ComplexDataType.packageShortName

  qualifiedName = ComplexDataType.qualifiedName
  
  access = property(getAccess, setAccess, None,
  r"""Access object that controls object access
  """)
  
  activeAccess = property(getActiveAccess, None, None,
  r"""Access object that is active for DataObject. NB This is a derived link 
  tha depends on the access permissions on the (recursive) parents.
  """)

  root = MemopsObject.root
  
  topObject = property(getTopObject, None, None,
  r"""TopObject - topmost parent in package.
  """)

###############################################################################
class MemopsRoot(ImplementationObject):
  r"""Unique root class, located at the top of the parent-child tree of 
objects. The  attributes adn operations are different in the File and Db 
Implementations
  """
  #   from data model element memops.Implementation.MemopsRoot revision 1.69
  _metaclass = metaPackage.getElement('MemopsRoot')
  _packageName = 'memops.Implementation'
  _packageShortName = 'IMPL'
  _fieldNames = ('accessControlOn', 'className', 'createdBy', 'currentGroupName', 'currentUserId', 'fieldNames', 'inConstructor', 'isDeleted', 'isLoaded', 'isModifiable', 'isModified', 'isReading', 'lastUnlockedBy', 'metaclass', 'name', 'override', 'packageName', 'packageShortName', 'qualifiedName', 'accessControlStores', 'activeRepositories', 'affiliationStores', 'analysisProfiles', 'analysisProjects', 'annealProtocolStores', 'annotationStores', 'chemCompCharges', 'chemCompCoords', 'chemComps', 'chemElementStores', 'citationStores', 'classifications', 'crystallizationStores', 'currentAccessControlStore', 'currentAffiliationStore', 'currentAnalysisProfile', 'currentAnalysisProject', 'currentAnnealProtocolStore', 'currentAnnotationStore', 'currentChemComp', 'currentChemCompCharge', 'currentChemCompCoord', 'currentChemElementStore', 'currentCitationStore', 'currentClassification', 'currentCrystallizationStore', 'currentDangleStore', 'currentDataLocationStore', 'currentDatabase', 'currentExpBlueprintStore', 'currentExperimentStore', 'currentHaddockProject', 'currentHolderStore', 'currentInstrumentStore', 'currentKeywordDefinitionStore', 'currentLabeledMolecule', 'currentLabelingScheme', 'currentLocationStore', 'currentMethodStore', 'currentMolSystem', 'currentMolSystemSymmetrySet', 'currentMolecule', 'currentNameMappingStore', 'currentNmrCalcStore', 'currentNmrConstraintStore', 'currentNmrEntryStore', 'currentNmrExpPrototype', 'currentNmrProject', 'currentNmrReferenceStore', 'currentNmrScreenStore', 'currentProtocolStore', 'currentRefSampleComponentStore', 'currentSampleStore', 'currentStereochemistryStore', 'currentStructureEnsemble', 'currentTargetStore', 'currentTaxonomy', 'currentValidationStore', 'dangleStores', 'dataLocationStores', 'databases', 'expBlueprintStores', 'experimentStores', 'haddockProjects', 'holderStores', 'instrumentStores', 'keywordDefinitionStores', 'labeledMolecules', 'labelingSchemes', 'locationStores', 'methodStores', 'molSystemSymmetrySets', 'molSystems', 'molecules', 'nameMappingStores', 'nmrCalcStores', 'nmrConstraintStores', 'nmrEntryStores', 'nmrExpPrototypes', 'nmrProjects', 'nmrReferenceStores', 'nmrScreenStores', 'packageLocator', 'packageLocators', 'parent', 'protocolStores', 'refSampleComponentStores', 'repositories', 'root', 'sampleStores', 'stereochemistryStores', 'structureEnsembles', 'targetStores', 'taxonomies', 'topObject', 'topObjects', 'validationStores',)
  
  _notifies = {'':[]}
  
  def __init__(self, **attrlinks):
    """
    Constructor for memops.Implementation.MemopsRoot
    """
    dataDict = self.__dict__

    topObject = self
    dataDict['topObject'] = topObject
    bb = attrlinks.get('isReading', False)
    if ((bb is not None and bb)):
      del attrlinks['isReading']
      dataDict['isLoaded'] = False
      dataDict['isModified'] = False
      dataDict['isReading'] = True
    else:
      dataDict['isLoaded'] = True
      dataDict['isModified'] = True
      dataDict['isReading'] = False

    override = attrlinks.get('override')
    if (override is None):
      dataDict['override'] = False
    else:
      dataDict['override'] = override

    root = self
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    try:

      dataDict['accessControlOn'] = False
      dataDict['createdBy'] = None
      dataDict['currentGroupName'] = 'user'
      dataDict['currentUserId'] = 'user'
      dataDict['isModifiable'] = True
      dataDict['lastUnlockedBy'] = None
      dataDict['name'] = 'ccpProject'
      dataDict['override'] = False
      dataDict['accessControlStores'] = {}
      dataDict['affiliationStores'] = {}
      dataDict['analysisProfiles'] = {}
      dataDict['analysisProjects'] = {}
      dataDict['annealProtocolStores'] = {}
      dataDict['annotationStores'] = {}
      dataDict['chemCompCharges'] = {}
      dataDict['chemCompCoords'] = {}
      dataDict['chemComps'] = {}
      dataDict['chemElementStores'] = {}
      dataDict['citationStores'] = {}
      dataDict['classifications'] = {}
      dataDict['crystallizationStores'] = {}
      dataDict['currentAccessControlStore'] = None
      dataDict['currentAffiliationStore'] = None
      dataDict['currentAnalysisProfile'] = None
      dataDict['currentAnalysisProject'] = None
      dataDict['currentAnnealProtocolStore'] = None
      dataDict['currentAnnotationStore'] = None
      dataDict['currentChemComp'] = None
      dataDict['currentChemCompCharge'] = None
      dataDict['currentChemCompCoord'] = None
      dataDict['currentChemElementStore'] = None
      dataDict['currentCitationStore'] = None
      dataDict['currentClassification'] = None
      dataDict['currentCrystallizationStore'] = None
      dataDict['currentDangleStore'] = None
      dataDict['currentDataLocationStore'] = None
      dataDict['currentDatabase'] = None
      dataDict['currentExpBlueprintStore'] = None
      dataDict['currentExperimentStore'] = None
      dataDict['currentHaddockProject'] = None
      dataDict['currentHolderStore'] = None
      dataDict['currentInstrumentStore'] = None
      dataDict['currentKeywordDefinitionStore'] = None
      dataDict['currentLabeledMolecule'] = None
      dataDict['currentLabelingScheme'] = None
      dataDict['currentLocationStore'] = None
      dataDict['currentMethodStore'] = None
      dataDict['currentMolSystem'] = None
      dataDict['currentMolSystemSymmetrySet'] = None
      dataDict['currentMolecule'] = None
      dataDict['currentNameMappingStore'] = None
      dataDict['currentNmrCalcStore'] = None
      dataDict['currentNmrConstraintStore'] = None
      dataDict['currentNmrEntryStore'] = None
      dataDict['currentNmrExpPrototype'] = None
      dataDict['currentNmrProject'] = None
      dataDict['currentNmrReferenceStore'] = None
      dataDict['currentNmrScreenStore'] = None
      dataDict['currentProtocolStore'] = None
      dataDict['currentRefSampleComponentStore'] = None
      dataDict['currentSampleStore'] = None
      dataDict['currentStereochemistryStore'] = None
      dataDict['currentStructureEnsemble'] = None
      dataDict['currentTargetStore'] = None
      dataDict['currentTaxonomy'] = None
      dataDict['currentValidationStore'] = None
      dataDict['dangleStores'] = {}
      dataDict['dataLocationStores'] = {}
      dataDict['databases'] = {}
      dataDict['expBlueprintStores'] = {}
      dataDict['experimentStores'] = {}
      dataDict['haddockProjects'] = {}
      dataDict['holderStores'] = {}
      dataDict['instrumentStores'] = {}
      dataDict['keywordDefinitionStores'] = {}
      dataDict['labeledMolecules'] = {}
      dataDict['labelingSchemes'] = {}
      dataDict['locationStores'] = {}
      dataDict['methodStores'] = {}
      dataDict['molSystemSymmetrySets'] = {}
      dataDict['molSystems'] = {}
      dataDict['molecules'] = {}
      dataDict['nameMappingStores'] = {}
      dataDict['nmrCalcStores'] = {}
      dataDict['nmrConstraintStores'] = {}
      dataDict['nmrEntryStores'] = {}
      dataDict['nmrExpPrototypes'] = {}
      dataDict['nmrProjects'] = {}
      dataDict['nmrReferenceStores'] = {}
      dataDict['nmrScreenStores'] = {}
      dataDict['packageLocators'] = {}
      dataDict['protocolStores'] = {}
      dataDict['refSampleComponentStores'] = {}
      dataDict['repositories'] = {}
      dataDict['sampleStores'] = {}
      dataDict['stereochemistryStores'] = {}
      dataDict['structureEnsembles'] = {}
      dataDict['targetStores'] = {}
      dataDict['taxonomies'] = {}
      dataDict['validationStores'] = {}
      dataDict['topObjects'] = {}
      dataDict['activeRepositories'] = list()

      dataDict['inConstructor'] = True
      # Hack for handling the root implementation atribute
      dataDict['memopsRoot'] = self
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in memops.Implementation.MemopsRoot.__init__"
        del dataDict['inConstructor']
        raise

      serialDict = {}
      serialDict['nmrConstraintStores'] = 0
      serialDict['nmrExpPrototypes'] = 0
      dataDict['_serialDict'] = serialDict

      dataDict['createdBy'] = dataDict.get('currentUserId')

      if (notOverride):
        
        from memops.universal import Io as uniIo
        from memops.general.Util import configParameter
        import os.path
        rootDir = uniIo.normalisePath(uniIo.os.getcwd())
        
        # repositories from configuration
        for (name, urlPath) in configParameter('repositories'):
          self.newRepository(name=name, url=Url(path=urlPath))
        
        # default repositories
        inData = (
         ('userData', uniIo.normalisePath(uniIo.joinPath(rootDir, self.name))),
         ('backup', 
          uniIo.normalisePath(uniIo.joinPath(rootDir, self.name + '_backup'))),
         ('refData', 
          uniIo.normalisePath(uniIo.joinPath(uniIo.getTopDirectory(), 'data'))),
         ('generalData', uniIo.normalisePath(os.path.expanduser('~/.ccpn/data'))),
        )
        for (name, urlPath) in inData:
          if not self.findFirstRepository(name=name):
            self.newRepository(name=name, url=Url(path=urlPath))
        
        # packageLocators from configuration
        for (targetName,repository) in configParameter('packageLocators'):
          loc = self.findFirstPackageLocator(targetName=targetName)
          if loc is None:
            loc = self.newPackageLocator(targetName=targetName,
             repositories=self.findAllRepositories(name=repository)
            )
          else:
            loc.addRepository(self.findFirstRepository(name=repository))
        
        # default packageLocators
        inData = (
         ('any', 'userData'),
        )
        for (targetName,repository) in inData:
          if not self.findFirstPackageLocator(targetName=targetName):
            self.newPackageLocator(targetName=targetName,
             repositories=self.findAllRepositories(name=repository)
            )
        
      if (notOverride):
        self.checkValid()

    except:
    
      raise

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def backup(self):
    """
    back up TopObject to current backup location
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.backup:
       called on deleted object""" % self.qualifiedName
      )

    repository = self.memopsRoot.findFirstRepository(name='backup')
    if repository:
      if not self.isLoaded:
        self.load()
      self.saveTo(repository)
    else:
      raise ApiError('No backup repository found for TopObject %s' % self)
  
  def backupAll(self):
    """
    back up memopsRoot and all known top objects
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.backupAll:
       called on deleted object""" % self.qualifiedName
      )

    if self.findFirstRepository(name='backup'):
      self.backup()
    
      for topObj in self.topObjects:
          topObj.backup()
  
  def checkAllValid(self, complete=False):
    """
    CheckAllValid for memops.Implementation.MemopsRoot
    """
    dataDict = self.__dict__
    self.checkValid(complete)
    root = self
    root.refreshTopObjects('memops.AccessControl')
    values = dataDict.get('accessControlStores').values()
    for value in values:
      value.checkAllValid(complete)

    root = self
    root.refreshTopObjects('ccp.general.Affiliation')
    values = dataDict.get('affiliationStores').values()
    for value in values:
      value.checkAllValid(complete)

    root = self
    root.refreshTopObjects('ccpnmr.AnalysisProfile')
    values = dataDict.get('analysisProfiles').values()
    for value in values:
      value.checkAllValid(complete)

    root = self
    root.refreshTopObjects('ccpnmr.Analysis')
    values = dataDict.get('analysisProjects').values()
    for value in values:
      value.checkAllValid(complete)

    root = self
    root.refreshTopObjects('molsim.AnnealProtocol')
    values = dataDict.get('annealProtocolStores').values()
    for value in values:
      value.checkAllValid(complete)

    root = self
    root.refreshTopObjects('ccp.general.Annotation')
    values = dataDict.get('annotationStores').values()
    for value in values:
      value.checkAllValid(complete)

    root = self
    root.refreshTopObjects('ccp.molecule.ChemCompCharge')
    values = dataDict.get('chemCompCharges').values()
    for value in values:
      value.checkAllValid(complete)

    root = self
    root.refreshTopObjects('ccp.molecule.ChemCompCoord')
    values = dataDict.get('chemCompCoords').values()
    for value in values:
      value.checkAllValid(complete)

    root = self
    root.refreshTopObjects('ccp.molecule.ChemComp')
    values = dataDict.get('chemComps').values()
    for value in values:
      value.checkAllValid(complete)

    root = self
    root.refreshTopObjects('ccp.molecule.ChemElement')
    values = dataDict.get('chemElementStores').values()
    for value in values:
      value.checkAllValid(complete)

    root = self
    root.refreshTopObjects('ccp.general.Citation')
    values = dataDict.get('citationStores').values()
    for value in values:
      value.checkAllValid(complete)

    root = self
    root.refreshTopObjects('ccp.lims.Classification')
    values = dataDict.get('classifications').values()
    for value in values:
      value.checkAllValid(complete)

    root = self
    root.refreshTopObjects('ccp.lims.Crystallization')
    values = dataDict.get('crystallizationStores').values()
    for value in values:
      value.checkAllValid(complete)

    root = self
    root.refreshTopObjects('cambridge.Dangle')
    values = dataDict.get('dangleStores').values()
    for value in values:
      value.checkAllValid(complete)

    root = self
    root.refreshTopObjects('ccp.general.DataLocation')
    values = dataDict.get('dataLocationStores').values()
    for value in values:
      value.checkAllValid(complete)

    root = self
    root.refreshTopObjects('ccp.general.DbRef')
    values = dataDict.get('databases').values()
    for value in values:
      value.checkAllValid(complete)

    root = self
    root.refreshTopObjects('ccp.lims.ExpBlueprint')
    values = dataDict.get('expBlueprintStores').values()
    for value in values:
      value.checkAllValid(complete)

    root = self
    root.refreshTopObjects('ccp.lims.Experiment')
    values = dataDict.get('experimentStores').values()
    for value in values:
      value.checkAllValid(complete)

    root = self
    root.refreshTopObjects('utrecht.Haddock')
    values = dataDict.get('haddockProjects').values()
    for value in values:
      value.checkAllValid(complete)

    root = self
    root.refreshTopObjects('ccp.lims.Holder')
    values = dataDict.get('holderStores').values()
    for value in values:
      value.checkAllValid(complete)

    root = self
    root.refreshTopObjects('ccp.general.Instrument')
    values = dataDict.get('instrumentStores').values()
    for value in values:
      value.checkAllValid(complete)

    root = self
    root.refreshTopObjects('ccp.general.KeywordDefinition')
    values = dataDict.get('keywordDefinitionStores').values()
    for value in values:
      value.checkAllValid(complete)

    root = self
    root.refreshTopObjects('ccp.molecule.LabeledMolecule')
    values = dataDict.get('labeledMolecules').values()
    for value in values:
      value.checkAllValid(complete)

    root = self
    root.refreshTopObjects('ccp.molecule.ChemCompLabel')
    values = dataDict.get('labelingSchemes').values()
    for value in values:
      value.checkAllValid(complete)

    root = self
    root.refreshTopObjects('ccp.lims.Location')
    values = dataDict.get('locationStores').values()
    for value in values:
      value.checkAllValid(complete)

    root = self
    root.refreshTopObjects('ccp.general.Method')
    values = dataDict.get('methodStores').values()
    for value in values:
      value.checkAllValid(complete)

    root = self
    root.refreshTopObjects('molsim.Symmetry')
    values = dataDict.get('molSystemSymmetrySets').values()
    for value in values:
      value.checkAllValid(complete)

    root = self
    root.refreshTopObjects('ccp.molecule.MolSystem')
    values = dataDict.get('molSystems').values()
    for value in values:
      value.checkAllValid(complete)

    root = self
    root.refreshTopObjects('ccp.molecule.Molecule')
    values = dataDict.get('molecules').values()
    for value in values:
      value.checkAllValid(complete)

    root = self
    root.refreshTopObjects('ccpnmr.NameMapping')
    values = dataDict.get('nameMappingStores').values()
    for value in values:
      value.checkAllValid(complete)

    root = self
    root.refreshTopObjects('ccp.nmr.NmrCalc')
    values = dataDict.get('nmrCalcStores').values()
    for value in values:
      value.checkAllValid(complete)

    root = self
    root.refreshTopObjects('ccp.nmr.NmrConstraint')
    values = dataDict.get('nmrConstraintStores').values()
    for value in values:
      value.checkAllValid(complete)

    root = self
    root.refreshTopObjects('ccp.nmr.NmrEntry')
    values = dataDict.get('nmrEntryStores').values()
    for value in values:
      value.checkAllValid(complete)

    root = self
    root.refreshTopObjects('ccp.nmr.NmrExpPrototype')
    values = dataDict.get('nmrExpPrototypes').values()
    for value in values:
      value.checkAllValid(complete)

    root = self
    root.refreshTopObjects('ccp.nmr.Nmr')
    values = dataDict.get('nmrProjects').values()
    for value in values:
      value.checkAllValid(complete)

    root = self
    root.refreshTopObjects('ccp.nmr.NmrReference')
    values = dataDict.get('nmrReferenceStores').values()
    for value in values:
      value.checkAllValid(complete)

    root = self
    root.refreshTopObjects('ccp.nmr.NmrScreen')
    values = dataDict.get('nmrScreenStores').values()
    for value in values:
      value.checkAllValid(complete)

    values = dataDict.get('packageLocators').values()
    for value in values:
      value.checkAllValid(complete)

    root = self
    root.refreshTopObjects('ccp.lims.Protocol')
    values = dataDict.get('protocolStores').values()
    for value in values:
      value.checkAllValid(complete)

    root = self
    root.refreshTopObjects('ccp.lims.RefSampleComponent')
    values = dataDict.get('refSampleComponentStores').values()
    for value in values:
      value.checkAllValid(complete)

    values = dataDict.get('repositories').values()
    for value in values:
      value.checkAllValid(complete)

    root = self
    root.refreshTopObjects('ccp.lims.Sample')
    values = dataDict.get('sampleStores').values()
    for value in values:
      value.checkAllValid(complete)

    root = self
    root.refreshTopObjects('ccp.molecule.Stereochemistry')
    values = dataDict.get('stereochemistryStores').values()
    for value in values:
      value.checkAllValid(complete)

    root = self
    root.refreshTopObjects('ccp.molecule.MolStructure')
    values = dataDict.get('structureEnsembles').values()
    for value in values:
      value.checkAllValid(complete)

    root = self
    root.refreshTopObjects('ccp.lims.Target')
    values = dataDict.get('targetStores').values()
    for value in values:
      value.checkAllValid(complete)

    root = self
    root.refreshTopObjects('ccp.general.Taxonomy')
    values = dataDict.get('taxonomies').values()
    for value in values:
      value.checkAllValid(complete)

    root = self
    root.refreshTopObjects('ccp.molecule.Validation')
    values = dataDict.get('validationStores').values()
    for value in values:
      value.checkAllValid(complete)

  def checkValid(self, complete=False):
    """
    CheckValid for memops.Implementation.MemopsRoot
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      # check attributes
      value = dataDict.get('accessControlOn')
      if (not (value in [True, False])):
        raise ApiError("""%s.checkValid: accessControlOn:
         memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('createdBy')
      if (value is None):
        raise ApiError("""%s.checkValid: createdBy:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: createdBy:
         memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 32):
        raise ApiError("""%s.checkValid: createdBy:
         memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: createdBy:
         memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.checkValid: createdBy:
         Word constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('currentGroupName')
      if (isinstance(value, String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: currentGroupName:
         memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 32):
        raise ApiError("""%s.checkValid: currentGroupName:
         memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: currentGroupName:
         memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.checkValid: currentGroupName:
         Word constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('currentUserId')
      if (isinstance(value, String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: currentUserId:
         memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 32):
        raise ApiError("""%s.checkValid: currentUserId:
         memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: currentUserId:
         memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.checkValid: currentUserId:
         Word constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('isModifiable')
      if (not (value in [True, False])):
        raise ApiError("""%s.checkValid: isModifiable:
         memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('lastUnlockedBy')
      if (value is not None):
        if (isinstance(value, String.PythonType)):
          pass
        else:
          raise ApiError("""%s.checkValid: lastUnlockedBy:
           memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
           + ": %s" % (value,)
          )

        _lenValue = len(value)
        if (_lenValue > 32):
          raise ApiError("""%s.checkValid: lastUnlockedBy:
           memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (_lenValue < 1):
          raise ApiError("""%s.checkValid: lastUnlockedBy:
           memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
           + ": %s" % (value,)
          )

        if (not (len(value.split()) == 1)):
          raise ApiError("""%s.checkValid: lastUnlockedBy:
           Word constraint contains_no_white_space violated by value""" % self.qualifiedName
           + ": %s" % (value,)
          )

      value = dataDict.get('name')
      if (isinstance(value, String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: name:
         memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 32):
        raise ApiError("""%s.checkValid: name:
         memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: name:
         memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.checkValid: name:
         Word constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('override')
      if (not (value in [True, False])):
        raise ApiError("""%s.checkValid: override:
         memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      # check roles
      root = self
      root.refreshTopObjects('memops.AccessControl')
      values = dataDict.get('accessControlStores').values()
      for value in values:
        from memops.api.AccessControl import AccessControlStore as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: accessControlStores:
           value is not of class memops.AccessControl.AccessControlStore""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('memopsRoot')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: accessControlStores:
           non-reciprocal link accessControlStores from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      root = self
      root.refreshTopObjects('ccp.general.Affiliation')
      values = dataDict.get('affiliationStores').values()
      for value in values:
        from ccp.api.general.Affiliation import AffiliationStore as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: affiliationStores:
           value is not of class ccp.general.Affiliation.AffiliationStore""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('memopsRoot')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: affiliationStores:
           non-reciprocal link affiliationStores from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      root = self
      root.refreshTopObjects('ccpnmr.AnalysisProfile')
      values = dataDict.get('analysisProfiles').values()
      for value in values:
        from ccpnmr.api.AnalysisProfile import AnalysisProfile as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: analysisProfiles:
           value is not of class ccpnmr.AnalysisProfile.AnalysisProfile""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('memopsRoot')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: analysisProfiles:
           non-reciprocal link analysisProfiles from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      root = self
      root.refreshTopObjects('ccpnmr.Analysis')
      values = dataDict.get('analysisProjects').values()
      for value in values:
        from ccpnmr.api.Analysis import AnalysisProject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: analysisProjects:
           value is not of class ccpnmr.Analysis.AnalysisProject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('memopsRoot')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: analysisProjects:
           non-reciprocal link analysisProjects from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      root = self
      root.refreshTopObjects('molsim.AnnealProtocol')
      values = dataDict.get('annealProtocolStores').values()
      for value in values:
        from molsim.api.AnnealProtocol import AnnealProtocolStore as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: annealProtocolStores:
           value is not of class molsim.AnnealProtocol.AnnealProtocolStore""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('memopsRoot')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: annealProtocolStores:
           non-reciprocal link annealProtocolStores from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      root = self
      root.refreshTopObjects('ccp.general.Annotation')
      values = dataDict.get('annotationStores').values()
      for value in values:
        from ccp.api.general.Annotation import AnnotationStore as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: annotationStores:
           value is not of class ccp.general.Annotation.AnnotationStore""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('memopsRoot')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: annotationStores:
           non-reciprocal link annotationStores from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      root = self
      root.refreshTopObjects('ccp.molecule.ChemCompCharge')
      values = dataDict.get('chemCompCharges').values()
      for value in values:
        from ccp.api.molecule.ChemCompCharge import ChemCompCharge as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: chemCompCharges:
           value is not of class ccp.molecule.ChemCompCharge.ChemCompCharge""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('memopsRoot')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: chemCompCharges:
           non-reciprocal link chemCompCharges from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      root = self
      root.refreshTopObjects('ccp.molecule.ChemCompCoord')
      values = dataDict.get('chemCompCoords').values()
      for value in values:
        from ccp.api.molecule.ChemCompCoord import ChemCompCoord as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: chemCompCoords:
           value is not of class ccp.molecule.ChemCompCoord.ChemCompCoord""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('memopsRoot')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: chemCompCoords:
           non-reciprocal link chemCompCoords from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      root = self
      root.refreshTopObjects('ccp.molecule.ChemComp')
      values = dataDict.get('chemComps').values()
      for value in values:
        from ccp.api.molecule.ChemComp import ChemComp as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: chemComps:
           value is not of class ccp.molecule.ChemComp.ChemComp""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('memopsRoot')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: chemComps:
           non-reciprocal link chemComps from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      root = self
      root.refreshTopObjects('ccp.molecule.ChemElement')
      values = dataDict.get('chemElementStores').values()
      for value in values:
        from ccp.api.molecule.ChemElement import ChemElementStore as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: chemElementStores:
           value is not of class ccp.molecule.ChemElement.ChemElementStore""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('memopsRoot')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: chemElementStores:
           non-reciprocal link chemElementStores from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      root = self
      root.refreshTopObjects('ccp.general.Citation')
      values = dataDict.get('citationStores').values()
      for value in values:
        from ccp.api.general.Citation import CitationStore as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: citationStores:
           value is not of class ccp.general.Citation.CitationStore""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('memopsRoot')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: citationStores:
           non-reciprocal link citationStores from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      root = self
      root.refreshTopObjects('ccp.lims.Classification')
      values = dataDict.get('classifications').values()
      for value in values:
        from ccp.api.lims.Classification import Classification as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: classifications:
           value is not of class ccp.lims.Classification.Classification""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('memopsRoot')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: classifications:
           non-reciprocal link classifications from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      root = self
      root.refreshTopObjects('ccp.lims.Crystallization')
      values = dataDict.get('crystallizationStores').values()
      for value in values:
        from ccp.api.lims.Crystallization import CrystallizationStore as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: crystallizationStores:
           value is not of class ccp.lims.Crystallization.CrystallizationStore""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('memopsRoot')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: crystallizationStores:
           non-reciprocal link crystallizationStores from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      value = dataDict.get('currentAccessControlStore')
      if (value is not None):
        from memops.api.AccessControl import AccessControlStore as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: currentAccessControlStore:
           value is not of class memops.AccessControl.AccessControlStore""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: currentAccessControlStore:
           Link currentAccessControlStore between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('currentAffiliationStore')
      if (value is not None):
        from ccp.api.general.Affiliation import AffiliationStore as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: currentAffiliationStore:
           value is not of class ccp.general.Affiliation.AffiliationStore""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: currentAffiliationStore:
           Link currentAffiliationStore between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('currentAnalysisProfile')
      if (value is not None):
        from ccpnmr.api.AnalysisProfile import AnalysisProfile as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: currentAnalysisProfile:
           value is not of class ccpnmr.AnalysisProfile.AnalysisProfile""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: currentAnalysisProfile:
           Link currentAnalysisProfile between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('currentAnalysisProject')
      if (value is not None):
        from ccpnmr.api.Analysis import AnalysisProject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: currentAnalysisProject:
           value is not of class ccpnmr.Analysis.AnalysisProject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: currentAnalysisProject:
           Link currentAnalysisProject between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('currentAnnealProtocolStore')
      if (value is not None):
        from molsim.api.AnnealProtocol import AnnealProtocolStore as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: currentAnnealProtocolStore:
           value is not of class molsim.AnnealProtocol.AnnealProtocolStore""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: currentAnnealProtocolStore:
           Link currentAnnealProtocolStore between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('currentAnnotationStore')
      if (value is not None):
        from ccp.api.general.Annotation import AnnotationStore as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: currentAnnotationStore:
           value is not of class ccp.general.Annotation.AnnotationStore""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: currentAnnotationStore:
           Link currentAnnotationStore between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('currentChemComp')
      if (value is not None):
        from ccp.api.molecule.ChemComp import ChemComp as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: currentChemComp:
           value is not of class ccp.molecule.ChemComp.ChemComp""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: currentChemComp:
           Link currentChemComp between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('currentChemCompCharge')
      if (value is not None):
        from ccp.api.molecule.ChemCompCharge import ChemCompCharge as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: currentChemCompCharge:
           value is not of class ccp.molecule.ChemCompCharge.ChemCompCharge""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: currentChemCompCharge:
           Link currentChemCompCharge between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('currentChemCompCoord')
      if (value is not None):
        from ccp.api.molecule.ChemCompCoord import ChemCompCoord as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: currentChemCompCoord:
           value is not of class ccp.molecule.ChemCompCoord.ChemCompCoord""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: currentChemCompCoord:
           Link currentChemCompCoord between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('currentChemElementStore')
      if (value is not None):
        from ccp.api.molecule.ChemElement import ChemElementStore as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: currentChemElementStore:
           value is not of class ccp.molecule.ChemElement.ChemElementStore""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: currentChemElementStore:
           Link currentChemElementStore between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('currentCitationStore')
      if (value is not None):
        from ccp.api.general.Citation import CitationStore as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: currentCitationStore:
           value is not of class ccp.general.Citation.CitationStore""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: currentCitationStore:
           Link currentCitationStore between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('currentClassification')
      if (value is not None):
        from ccp.api.lims.Classification import Classification as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: currentClassification:
           value is not of class ccp.lims.Classification.Classification""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: currentClassification:
           Link currentClassification between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('currentCrystallizationStore')
      if (value is not None):
        from ccp.api.lims.Crystallization import CrystallizationStore as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: currentCrystallizationStore:
           value is not of class ccp.lims.Crystallization.CrystallizationStore""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: currentCrystallizationStore:
           Link currentCrystallizationStore between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('currentDangleStore')
      if (value is not None):
        from cambridge.api.Dangle import DangleStore as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: currentDangleStore:
           value is not of class cambridge.Dangle.DangleStore""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: currentDangleStore:
           Link currentDangleStore between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('currentDataLocationStore')
      if (value is not None):
        from ccp.api.general.DataLocation import DataLocationStore as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: currentDataLocationStore:
           value is not of class ccp.general.DataLocation.DataLocationStore""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: currentDataLocationStore:
           Link currentDataLocationStore between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('currentDatabase')
      if (value is not None):
        from ccp.api.general.DbRef import Database as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: currentDatabase:
           value is not of class ccp.general.DbRef.Database""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: currentDatabase:
           Link currentDatabase between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('currentExpBlueprintStore')
      if (value is not None):
        from ccp.api.lims.ExpBlueprint import ExpBlueprintStore as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: currentExpBlueprintStore:
           value is not of class ccp.lims.ExpBlueprint.ExpBlueprintStore""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: currentExpBlueprintStore:
           Link currentExpBlueprintStore between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('currentExperimentStore')
      if (value is not None):
        from ccp.api.lims.Experiment import ExperimentStore as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: currentExperimentStore:
           value is not of class ccp.lims.Experiment.ExperimentStore""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: currentExperimentStore:
           Link currentExperimentStore between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('currentHaddockProject')
      if (value is not None):
        from utrecht.api.Haddock import HaddockProject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: currentHaddockProject:
           value is not of class utrecht.Haddock.HaddockProject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: currentHaddockProject:
           Link currentHaddockProject between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('currentHolderStore')
      if (value is not None):
        from ccp.api.lims.Holder import HolderStore as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: currentHolderStore:
           value is not of class ccp.lims.Holder.HolderStore""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: currentHolderStore:
           Link currentHolderStore between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('currentInstrumentStore')
      if (value is not None):
        from ccp.api.general.Instrument import InstrumentStore as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: currentInstrumentStore:
           value is not of class ccp.general.Instrument.InstrumentStore""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: currentInstrumentStore:
           Link currentInstrumentStore between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('currentKeywordDefinitionStore')
      if (value is not None):
        from ccp.api.general.KeywordDefinition import KeywordDefinitionStore as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: currentKeywordDefinitionStore:
           value is not of class ccp.general.KeywordDefinition.KeywordDefinitionStore""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: currentKeywordDefinitionStore:
           Link currentKeywordDefinitionStore between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('currentLabeledMolecule')
      if (value is not None):
        from ccp.api.molecule.LabeledMolecule import LabeledMolecule as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: currentLabeledMolecule:
           value is not of class ccp.molecule.LabeledMolecule.LabeledMolecule""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: currentLabeledMolecule:
           Link currentLabeledMolecule between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('currentLabelingScheme')
      if (value is not None):
        from ccp.api.molecule.ChemCompLabel import LabelingScheme as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: currentLabelingScheme:
           value is not of class ccp.molecule.ChemCompLabel.LabelingScheme""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: currentLabelingScheme:
           Link currentLabelingScheme between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('currentLocationStore')
      if (value is not None):
        from ccp.api.lims.Location import LocationStore as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: currentLocationStore:
           value is not of class ccp.lims.Location.LocationStore""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: currentLocationStore:
           Link currentLocationStore between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('currentMethodStore')
      if (value is not None):
        from ccp.api.general.Method import MethodStore as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: currentMethodStore:
           value is not of class ccp.general.Method.MethodStore""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: currentMethodStore:
           Link currentMethodStore between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('currentMolSystem')
      if (value is not None):
        from ccp.api.molecule.MolSystem import MolSystem as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: currentMolSystem:
           value is not of class ccp.molecule.MolSystem.MolSystem""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: currentMolSystem:
           Link currentMolSystem between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('currentMolSystemSymmetrySet')
      if (value is not None):
        from molsim.api.Symmetry import MolSystemSymmetrySet as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: currentMolSystemSymmetrySet:
           value is not of class molsim.Symmetry.MolSystemSymmetrySet""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: currentMolSystemSymmetrySet:
           Link currentMolSystemSymmetrySet between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('currentMolecule')
      if (value is not None):
        from ccp.api.molecule.Molecule import Molecule as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: currentMolecule:
           value is not of class ccp.molecule.Molecule.Molecule""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: currentMolecule:
           Link currentMolecule between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('currentNameMappingStore')
      if (value is not None):
        from ccpnmr.api.NameMapping import NameMappingStore as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: currentNameMappingStore:
           value is not of class ccpnmr.NameMapping.NameMappingStore""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: currentNameMappingStore:
           Link currentNameMappingStore between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('currentNmrCalcStore')
      if (value is not None):
        from ccp.api.nmr.NmrCalc import NmrCalcStore as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: currentNmrCalcStore:
           value is not of class ccp.nmr.NmrCalc.NmrCalcStore""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: currentNmrCalcStore:
           Link currentNmrCalcStore between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('currentNmrConstraintStore')
      if (value is not None):
        from ccp.api.nmr.NmrConstraint import NmrConstraintStore as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: currentNmrConstraintStore:
           value is not of class ccp.nmr.NmrConstraint.NmrConstraintStore""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: currentNmrConstraintStore:
           Link currentNmrConstraintStore between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('currentNmrEntryStore')
      if (value is not None):
        from ccp.api.nmr.NmrEntry import NmrEntryStore as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: currentNmrEntryStore:
           value is not of class ccp.nmr.NmrEntry.NmrEntryStore""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: currentNmrEntryStore:
           Link currentNmrEntryStore between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('currentNmrExpPrototype')
      if (value is not None):
        from ccp.api.nmr.NmrExpPrototype import NmrExpPrototype as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: currentNmrExpPrototype:
           value is not of class ccp.nmr.NmrExpPrototype.NmrExpPrototype""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: currentNmrExpPrototype:
           Link currentNmrExpPrototype between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('currentNmrProject')
      if (value is not None):
        from ccp.api.nmr.Nmr import NmrProject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: currentNmrProject:
           value is not of class ccp.nmr.Nmr.NmrProject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: currentNmrProject:
           Link currentNmrProject between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('currentNmrReferenceStore')
      if (value is not None):
        from ccp.api.nmr.NmrReference import NmrReferenceStore as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: currentNmrReferenceStore:
           value is not of class ccp.nmr.NmrReference.NmrReferenceStore""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: currentNmrReferenceStore:
           Link currentNmrReferenceStore between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('currentNmrScreenStore')
      if (value is not None):
        from ccp.api.nmr.NmrScreen import NmrScreenStore as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: currentNmrScreenStore:
           value is not of class ccp.nmr.NmrScreen.NmrScreenStore""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: currentNmrScreenStore:
           Link currentNmrScreenStore between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('currentProtocolStore')
      if (value is not None):
        from ccp.api.lims.Protocol import ProtocolStore as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: currentProtocolStore:
           value is not of class ccp.lims.Protocol.ProtocolStore""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: currentProtocolStore:
           Link currentProtocolStore between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('currentRefSampleComponentStore')
      if (value is not None):
        from ccp.api.lims.RefSampleComponent import RefSampleComponentStore as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: currentRefSampleComponentStore:
           value is not of class ccp.lims.RefSampleComponent.RefSampleComponentStore""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: currentRefSampleComponentStore:
           Link currentRefSampleComponentStore between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('currentSampleStore')
      if (value is not None):
        from ccp.api.lims.Sample import SampleStore as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: currentSampleStore:
           value is not of class ccp.lims.Sample.SampleStore""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: currentSampleStore:
           Link currentSampleStore between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('currentStereochemistryStore')
      if (value is not None):
        from ccp.api.molecule.Stereochemistry import StereochemistryStore as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: currentStereochemistryStore:
           value is not of class ccp.molecule.Stereochemistry.StereochemistryStore""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: currentStereochemistryStore:
           Link currentStereochemistryStore between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('currentStructureEnsemble')
      if (value is not None):
        from ccp.api.molecule.MolStructure import StructureEnsemble as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: currentStructureEnsemble:
           value is not of class ccp.molecule.MolStructure.StructureEnsemble""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: currentStructureEnsemble:
           Link currentStructureEnsemble between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('currentTargetStore')
      if (value is not None):
        from ccp.api.lims.Target import TargetStore as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: currentTargetStore:
           value is not of class ccp.lims.Target.TargetStore""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: currentTargetStore:
           Link currentTargetStore between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('currentTaxonomy')
      if (value is not None):
        from ccp.api.general.Taxonomy import Taxonomy as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: currentTaxonomy:
           value is not of class ccp.general.Taxonomy.Taxonomy""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: currentTaxonomy:
           Link currentTaxonomy between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      value = dataDict.get('currentValidationStore')
      if (value is not None):
        from ccp.api.molecule.Validation import ValidationStore as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: currentValidationStore:
           value is not of class ccp.molecule.Validation.ValidationStore""" % self.qualifiedName
           + ": %s" % (value,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: currentValidationStore:
           Link currentValidationStore between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      root = self
      root.refreshTopObjects('cambridge.Dangle')
      values = dataDict.get('dangleStores').values()
      for value in values:
        from cambridge.api.Dangle import DangleStore as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: dangleStores:
           value is not of class cambridge.Dangle.DangleStore""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('memopsRoot')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: dangleStores:
           non-reciprocal link dangleStores from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      root = self
      root.refreshTopObjects('ccp.general.DataLocation')
      values = dataDict.get('dataLocationStores').values()
      for value in values:
        from ccp.api.general.DataLocation import DataLocationStore as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: dataLocationStores:
           value is not of class ccp.general.DataLocation.DataLocationStore""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('memopsRoot')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: dataLocationStores:
           non-reciprocal link dataLocationStores from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      root = self
      root.refreshTopObjects('ccp.general.DbRef')
      values = dataDict.get('databases').values()
      for value in values:
        from ccp.api.general.DbRef import Database as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: databases:
           value is not of class ccp.general.DbRef.Database""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('memopsRoot')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: databases:
           non-reciprocal link databases from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      root = self
      root.refreshTopObjects('ccp.lims.ExpBlueprint')
      values = dataDict.get('expBlueprintStores').values()
      for value in values:
        from ccp.api.lims.ExpBlueprint import ExpBlueprintStore as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: expBlueprintStores:
           value is not of class ccp.lims.ExpBlueprint.ExpBlueprintStore""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('memopsRoot')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: expBlueprintStores:
           non-reciprocal link expBlueprintStores from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      root = self
      root.refreshTopObjects('ccp.lims.Experiment')
      values = dataDict.get('experimentStores').values()
      for value in values:
        from ccp.api.lims.Experiment import ExperimentStore as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: experimentStores:
           value is not of class ccp.lims.Experiment.ExperimentStore""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('memopsRoot')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: experimentStores:
           non-reciprocal link experimentStores from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      root = self
      root.refreshTopObjects('utrecht.Haddock')
      values = dataDict.get('haddockProjects').values()
      for value in values:
        from utrecht.api.Haddock import HaddockProject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: haddockProjects:
           value is not of class utrecht.Haddock.HaddockProject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('memopsRoot')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: haddockProjects:
           non-reciprocal link haddockProjects from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      root = self
      root.refreshTopObjects('ccp.lims.Holder')
      values = dataDict.get('holderStores').values()
      for value in values:
        from ccp.api.lims.Holder import HolderStore as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: holderStores:
           value is not of class ccp.lims.Holder.HolderStore""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('memopsRoot')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: holderStores:
           non-reciprocal link holderStores from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      root = self
      root.refreshTopObjects('ccp.general.Instrument')
      values = dataDict.get('instrumentStores').values()
      for value in values:
        from ccp.api.general.Instrument import InstrumentStore as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: instrumentStores:
           value is not of class ccp.general.Instrument.InstrumentStore""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('memopsRoot')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: instrumentStores:
           non-reciprocal link instrumentStores from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      root = self
      root.refreshTopObjects('ccp.general.KeywordDefinition')
      values = dataDict.get('keywordDefinitionStores').values()
      for value in values:
        from ccp.api.general.KeywordDefinition import KeywordDefinitionStore as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: keywordDefinitionStores:
           value is not of class ccp.general.KeywordDefinition.KeywordDefinitionStore""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('memopsRoot')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: keywordDefinitionStores:
           non-reciprocal link keywordDefinitionStores from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      root = self
      root.refreshTopObjects('ccp.molecule.LabeledMolecule')
      values = dataDict.get('labeledMolecules').values()
      for value in values:
        from ccp.api.molecule.LabeledMolecule import LabeledMolecule as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: labeledMolecules:
           value is not of class ccp.molecule.LabeledMolecule.LabeledMolecule""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('memopsRoot')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: labeledMolecules:
           non-reciprocal link labeledMolecules from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      root = self
      root.refreshTopObjects('ccp.molecule.ChemCompLabel')
      values = dataDict.get('labelingSchemes').values()
      for value in values:
        from ccp.api.molecule.ChemCompLabel import LabelingScheme as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: labelingSchemes:
           value is not of class ccp.molecule.ChemCompLabel.LabelingScheme""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('memopsRoot')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: labelingSchemes:
           non-reciprocal link labelingSchemes from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      root = self
      root.refreshTopObjects('ccp.lims.Location')
      values = dataDict.get('locationStores').values()
      for value in values:
        from ccp.api.lims.Location import LocationStore as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: locationStores:
           value is not of class ccp.lims.Location.LocationStore""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('memopsRoot')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: locationStores:
           non-reciprocal link locationStores from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      root = self
      root.refreshTopObjects('ccp.general.Method')
      values = dataDict.get('methodStores').values()
      for value in values:
        from ccp.api.general.Method import MethodStore as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: methodStores:
           value is not of class ccp.general.Method.MethodStore""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('memopsRoot')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: methodStores:
           non-reciprocal link methodStores from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      root = self
      root.refreshTopObjects('molsim.Symmetry')
      values = dataDict.get('molSystemSymmetrySets').values()
      for value in values:
        from molsim.api.Symmetry import MolSystemSymmetrySet as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: molSystemSymmetrySets:
           value is not of class molsim.Symmetry.MolSystemSymmetrySet""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('memopsRoot')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: molSystemSymmetrySets:
           non-reciprocal link molSystemSymmetrySets from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      root = self
      root.refreshTopObjects('ccp.molecule.MolSystem')
      values = dataDict.get('molSystems').values()
      for value in values:
        from ccp.api.molecule.MolSystem import MolSystem as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: molSystems:
           value is not of class ccp.molecule.MolSystem.MolSystem""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('memopsRoot')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: molSystems:
           non-reciprocal link molSystems from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      root = self
      root.refreshTopObjects('ccp.molecule.Molecule')
      values = dataDict.get('molecules').values()
      for value in values:
        from ccp.api.molecule.Molecule import Molecule as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: molecules:
           value is not of class ccp.molecule.Molecule.Molecule""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('memopsRoot')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: molecules:
           non-reciprocal link molecules from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      root = self
      root.refreshTopObjects('ccpnmr.NameMapping')
      values = dataDict.get('nameMappingStores').values()
      for value in values:
        from ccpnmr.api.NameMapping import NameMappingStore as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: nameMappingStores:
           value is not of class ccpnmr.NameMapping.NameMappingStore""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('memopsRoot')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: nameMappingStores:
           non-reciprocal link nameMappingStores from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      root = self
      root.refreshTopObjects('ccp.nmr.NmrCalc')
      values = dataDict.get('nmrCalcStores').values()
      for value in values:
        from ccp.api.nmr.NmrCalc import NmrCalcStore as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: nmrCalcStores:
           value is not of class ccp.nmr.NmrCalc.NmrCalcStore""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('memopsRoot')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: nmrCalcStores:
           non-reciprocal link nmrCalcStores from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      root = self
      root.refreshTopObjects('ccp.nmr.NmrConstraint')
      values = dataDict.get('nmrConstraintStores').values()
      for value in values:
        from ccp.api.nmr.NmrConstraint import NmrConstraintStore as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: nmrConstraintStores:
           value is not of class ccp.nmr.NmrConstraint.NmrConstraintStore""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('memopsRoot')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: nmrConstraintStores:
           non-reciprocal link nmrConstraintStores from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      root = self
      root.refreshTopObjects('ccp.nmr.NmrEntry')
      values = dataDict.get('nmrEntryStores').values()
      for value in values:
        from ccp.api.nmr.NmrEntry import NmrEntryStore as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: nmrEntryStores:
           value is not of class ccp.nmr.NmrEntry.NmrEntryStore""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('memopsRoot')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: nmrEntryStores:
           non-reciprocal link nmrEntryStores from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      root = self
      root.refreshTopObjects('ccp.nmr.NmrExpPrototype')
      values = dataDict.get('nmrExpPrototypes').values()
      for value in values:
        from ccp.api.nmr.NmrExpPrototype import NmrExpPrototype as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: nmrExpPrototypes:
           value is not of class ccp.nmr.NmrExpPrototype.NmrExpPrototype""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('memopsRoot')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: nmrExpPrototypes:
           non-reciprocal link nmrExpPrototypes from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      root = self
      root.refreshTopObjects('ccp.nmr.Nmr')
      values = dataDict.get('nmrProjects').values()
      for value in values:
        from ccp.api.nmr.Nmr import NmrProject as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: nmrProjects:
           value is not of class ccp.nmr.Nmr.NmrProject""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('memopsRoot')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: nmrProjects:
           non-reciprocal link nmrProjects from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      root = self
      root.refreshTopObjects('ccp.nmr.NmrReference')
      values = dataDict.get('nmrReferenceStores').values()
      for value in values:
        from ccp.api.nmr.NmrReference import NmrReferenceStore as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: nmrReferenceStores:
           value is not of class ccp.nmr.NmrReference.NmrReferenceStore""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('memopsRoot')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: nmrReferenceStores:
           non-reciprocal link nmrReferenceStores from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      root = self
      root.refreshTopObjects('ccp.nmr.NmrScreen')
      values = dataDict.get('nmrScreenStores').values()
      for value in values:
        from ccp.api.nmr.NmrScreen import NmrScreenStore as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: nmrScreenStores:
           value is not of class ccp.nmr.NmrScreen.NmrScreenStore""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('memopsRoot')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: nmrScreenStores:
           non-reciprocal link nmrScreenStores from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      value = self.getPackageLocator()
      if (value is None):
        raise ApiError("""%s.checkValid: packageLocator:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (not isinstance(value, PackageLocator)):
        raise ApiError("""%s.checkValid: packageLocator:
         value is not of class memops.Implementation.PackageLocator""" % self.qualifiedName
         + ": %s" % (value,)
        )

      xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
      yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
      if (not (xx1 is yy1)):
        raise ApiError("""%s.checkValid: packageLocator:
         Link packageLocator between objects from separate partitions
         - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
         + ": %s:%s" % (self, value)
        )

      values = dataDict.get('packageLocators').values()
      for value in values:
        if (not isinstance(value, PackageLocator)):
          raise ApiError("""%s.checkValid: packageLocators:
           value is not of class memops.Implementation.PackageLocator""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('memopsRoot')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: packageLocators:
           non-reciprocal link packageLocators from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      root = self
      root.refreshTopObjects('ccp.lims.Protocol')
      values = dataDict.get('protocolStores').values()
      for value in values:
        from ccp.api.lims.Protocol import ProtocolStore as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: protocolStores:
           value is not of class ccp.lims.Protocol.ProtocolStore""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('memopsRoot')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: protocolStores:
           non-reciprocal link protocolStores from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      root = self
      root.refreshTopObjects('ccp.lims.RefSampleComponent')
      values = dataDict.get('refSampleComponentStores').values()
      for value in values:
        from ccp.api.lims.RefSampleComponent import RefSampleComponentStore as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: refSampleComponentStores:
           value is not of class ccp.lims.RefSampleComponent.RefSampleComponentStore""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('memopsRoot')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: refSampleComponentStores:
           non-reciprocal link refSampleComponentStores from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      values = dataDict.get('repositories').values()
      for value in values:
        if (not isinstance(value, Repository)):
          raise ApiError("""%s.checkValid: repositories:
           value is not of class memops.Implementation.Repository""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('memopsRoot')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: repositories:
           non-reciprocal link repositories from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      root = self
      root.refreshTopObjects('ccp.lims.Sample')
      values = dataDict.get('sampleStores').values()
      for value in values:
        from ccp.api.lims.Sample import SampleStore as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: sampleStores:
           value is not of class ccp.lims.Sample.SampleStore""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('memopsRoot')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: sampleStores:
           non-reciprocal link sampleStores from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      root = self
      root.refreshTopObjects('ccp.molecule.Stereochemistry')
      values = dataDict.get('stereochemistryStores').values()
      for value in values:
        from ccp.api.molecule.Stereochemistry import StereochemistryStore as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: stereochemistryStores:
           value is not of class ccp.molecule.Stereochemistry.StereochemistryStore""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('memopsRoot')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: stereochemistryStores:
           non-reciprocal link stereochemistryStores from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      root = self
      root.refreshTopObjects('ccp.molecule.MolStructure')
      values = dataDict.get('structureEnsembles').values()
      for value in values:
        from ccp.api.molecule.MolStructure import StructureEnsemble as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: structureEnsembles:
           value is not of class ccp.molecule.MolStructure.StructureEnsemble""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('memopsRoot')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: structureEnsembles:
           non-reciprocal link structureEnsembles from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      root = self
      root.refreshTopObjects('ccp.lims.Target')
      values = dataDict.get('targetStores').values()
      for value in values:
        from ccp.api.lims.Target import TargetStore as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: targetStores:
           value is not of class ccp.lims.Target.TargetStore""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('memopsRoot')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: targetStores:
           non-reciprocal link targetStores from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      root = self
      root.refreshTopObjects('ccp.general.Taxonomy')
      values = dataDict.get('taxonomies').values()
      for value in values:
        from ccp.api.general.Taxonomy import Taxonomy as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: taxonomies:
           value is not of class ccp.general.Taxonomy.Taxonomy""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('memopsRoot')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: taxonomies:
           non-reciprocal link taxonomies from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      root = self
      root.refreshTopObjects('ccp.molecule.Validation')
      values = dataDict.get('validationStores').values()
      for value in values:
        from ccp.api.molecule.Validation import ValidationStore as importedType
        if (not isinstance(value, importedType)):
          raise ApiError("""%s.checkValid: validationStores:
           value is not of class ccp.molecule.Validation.ValidationStore""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelf = value.__dict__.get('memopsRoot')
        if (not (oldSelf is self)):
          raise ApiError("""%s.checkValid: validationStores:
           non-reciprocal link validationStores from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

    # check explicit class constraints
    if (not (self.findFirstPackageLocator(targetName='any') is not None)):
      raise ApiError("""%s.checkValid:
       constraint must_have_default_packageLocator violated""" % self.qualifiedName
       + ": %s" % (self,)
      )

    # check attributes
    value = dataDict.get('accessControlOn')
    if (value is None):
      raise ApiError("""%s.checkValid: accessControlOn:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('currentGroupName')
    if (value is None):
      raise ApiError("""%s.checkValid: currentGroupName:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('currentUserId')
    if (value is None):
      raise ApiError("""%s.checkValid: currentUserId:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    isValid = frozenset('abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789').issuperset(value)
    if (not (isValid)):
      raise ApiError("""%s.checkValid: currentUserId:
       currentUserId constraint value_is_alphanumeric violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    value = dataDict.get('isModifiable')
    if (value is None):
      raise ApiError("""%s.checkValid: isModifiable:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('name')
    if (value is None):
      raise ApiError("""%s.checkValid: name:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    isValid = frozenset('abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_0123456789').issuperset(value)
    if (not (isValid)):
      raise ApiError("""%s.checkValid: name:
       name constraint value_is_alphanumeric_or_underscore violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    value = dataDict.get('override')
    if (value is None):
      raise ApiError("""%s.checkValid: override:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    # check roles
    values = dataDict.get('accessControlStores').values()
    values = dataDict.get('affiliationStores').values()
    values = dataDict.get('analysisProfiles').values()
    values = dataDict.get('analysisProjects').values()
    values = dataDict.get('annealProtocolStores').values()
    values = dataDict.get('annotationStores').values()
    values = dataDict.get('chemCompCharges').values()
    values = dataDict.get('chemCompCoords').values()
    values = dataDict.get('chemComps').values()
    values = dataDict.get('chemElementStores').values()
    values = dataDict.get('citationStores').values()
    values = dataDict.get('classifications').values()
    values = dataDict.get('crystallizationStores').values()
    value = dataDict.get('currentAccessControlStore')
    value = dataDict.get('currentAffiliationStore')
    value = dataDict.get('currentAnalysisProfile')
    value = dataDict.get('currentAnalysisProject')
    value = dataDict.get('currentAnnealProtocolStore')
    value = dataDict.get('currentAnnotationStore')
    value = dataDict.get('currentChemComp')
    value = dataDict.get('currentChemCompCharge')
    value = dataDict.get('currentChemCompCoord')
    value = dataDict.get('currentChemElementStore')
    value = dataDict.get('currentCitationStore')
    value = dataDict.get('currentClassification')
    value = dataDict.get('currentCrystallizationStore')
    value = dataDict.get('currentDangleStore')
    value = dataDict.get('currentDataLocationStore')
    value = dataDict.get('currentDatabase')
    value = dataDict.get('currentExpBlueprintStore')
    value = dataDict.get('currentExperimentStore')
    value = dataDict.get('currentHaddockProject')
    value = dataDict.get('currentHolderStore')
    value = dataDict.get('currentInstrumentStore')
    value = dataDict.get('currentKeywordDefinitionStore')
    value = dataDict.get('currentLabeledMolecule')
    value = dataDict.get('currentLabelingScheme')
    value = dataDict.get('currentLocationStore')
    value = dataDict.get('currentMethodStore')
    value = dataDict.get('currentMolSystem')
    value = dataDict.get('currentMolSystemSymmetrySet')
    value = dataDict.get('currentMolecule')
    value = dataDict.get('currentNameMappingStore')
    value = dataDict.get('currentNmrCalcStore')
    value = dataDict.get('currentNmrConstraintStore')
    value = dataDict.get('currentNmrEntryStore')
    value = dataDict.get('currentNmrExpPrototype')
    value = dataDict.get('currentNmrProject')
    value = dataDict.get('currentNmrReferenceStore')
    value = dataDict.get('currentNmrScreenStore')
    value = dataDict.get('currentProtocolStore')
    value = dataDict.get('currentRefSampleComponentStore')
    value = dataDict.get('currentSampleStore')
    value = dataDict.get('currentStereochemistryStore')
    value = dataDict.get('currentStructureEnsemble')
    value = dataDict.get('currentTargetStore')
    value = dataDict.get('currentTaxonomy')
    value = dataDict.get('currentValidationStore')
    values = dataDict.get('dangleStores').values()
    values = dataDict.get('dataLocationStores').values()
    values = dataDict.get('databases').values()
    values = dataDict.get('expBlueprintStores').values()
    values = dataDict.get('experimentStores').values()
    values = dataDict.get('haddockProjects').values()
    values = dataDict.get('holderStores').values()
    values = dataDict.get('instrumentStores').values()
    values = dataDict.get('keywordDefinitionStores').values()
    values = dataDict.get('labeledMolecules').values()
    values = dataDict.get('labelingSchemes').values()
    values = dataDict.get('locationStores').values()
    values = dataDict.get('methodStores').values()
    values = dataDict.get('molSystemSymmetrySets').values()
    values = dataDict.get('molSystems').values()
    values = dataDict.get('molecules').values()
    values = dataDict.get('nameMappingStores').values()
    values = dataDict.get('nmrCalcStores').values()
    values = dataDict.get('nmrConstraintStores').values()
    values = dataDict.get('nmrEntryStores').values()
    values = dataDict.get('nmrExpPrototypes').values()
    values = dataDict.get('nmrProjects').values()
    values = dataDict.get('nmrReferenceStores').values()
    values = dataDict.get('nmrScreenStores').values()
    values = dataDict.get('packageLocators').values()
    values = dataDict.get('protocolStores').values()
    values = dataDict.get('refSampleComponentStores').values()
    values = dataDict.get('repositories').values()
    values = dataDict.get('sampleStores').values()
    values = dataDict.get('stereochemistryStores').values()
    values = dataDict.get('structureEnsembles').values()
    values = dataDict.get('targetStores').values()
    values = dataDict.get('taxonomies').values()
    values = dataDict.get('validationStores').values()
  
  def findAllAccessControlStores(self, **conditions):
    """
    FindAll for memops.Implementation.MemopsRoot.accessControlStores
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = self
      root.refreshTopObjects('memops.AccessControl')
      currentValues = dataDict.get('accessControlStores').values()
      result = set(currentValues)

    else:
      root = self
      root.refreshTopObjects('memops.AccessControl')
      currentValues = dataDict.get('accessControlStores').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('createdBy', 'guid', 'isModifiable', 'lastUnlockedBy', 'name', 'access', 'memopsRoot',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result.add(v)

    return result
  
  def findAllActiveRepositories(self, **conditions):
    """
    FindAll for memops.Implementation.MemopsRoot.activeRepositories
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = self.getActiveRepositories()
      result = list(currentValues)

    else:
      currentValues = self.getActiveRepositories()
      result = list()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('format', 'name', 'url', 'memopsRoot',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.append(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result.append(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result.append(v)

    return result
  
  def findAllAffiliationStores(self, **conditions):
    """
    FindAll for memops.Implementation.MemopsRoot.affiliationStores
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = self
      root.refreshTopObjects('ccp.general.Affiliation')
      currentValues = dataDict.get('affiliationStores').values()
      result = set(currentValues)

    else:
      root = self
      root.refreshTopObjects('ccp.general.Affiliation')
      currentValues = dataDict.get('affiliationStores').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('createdBy', 'guid', 'isModifiable', 'lastUnlockedBy', 'name', 'access', 'memopsRoot',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result.add(v)

    return result
  
  def findAllAnalysisProfiles(self, **conditions):
    """
    FindAll for memops.Implementation.MemopsRoot.analysisProfiles
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = self
      root.refreshTopObjects('ccpnmr.AnalysisProfile')
      currentValues = dataDict.get('analysisProfiles').values()
      result = set(currentValues)

    else:
      root = self
      root.refreshTopObjects('ccpnmr.AnalysisProfile')
      currentValues = dataDict.get('analysisProfiles').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('bgColor', 'createdBy', 'fgColor', 'font', 'graphicsHandler', 'guid', 'isModifiable', 'lastUnlockedBy', 'name', 'panView', 'sendBugReports', 'transientDialogs', 'transientWindows', 'twoCharShortcuts', 'useCrosshair', 'useGlobalShortcuts', 'userEmail', 'userName', 'userOrganisation', 'webBrowser', 'access', 'marksColor', 'memopsRoot', 'rulersColor',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result.add(v)

    return result
  
  def findAllAnalysisProjects(self, **conditions):
    """
    FindAll for memops.Implementation.MemopsRoot.analysisProjects
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = self
      root.refreshTopObjects('ccpnmr.Analysis')
      currentValues = dataDict.get('analysisProjects').values()
      result = set(currentValues)

    else:
      root = self
      root.refreshTopObjects('ccpnmr.Analysis')
      currentValues = dataDict.get('analysisProjects').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('autoBackupFreq', 'contourToUnaliased', 'createdBy', 'defaultSpectrumFileType', 'doAssignmentAnnotations', 'doAutoBackup', 'doChainAnnotations', 'doDetailAnnotations', 'doMeritAnnotations', 'doMinimalAnnotations', 'doMolSysAnnotations', 'doSpinSystemAnnotations', 'globalContourScale', 'guid', 'isModifiable', 'isThreadingAllowed', 'lastUnlockedBy', 'linkPeakListsData', 'linkSeqSpinSystemsData', 'maxMarks', 'maxRulers', 'meritAnnotationBad', 'meritAnnotationGood', 'meritAnnotationMediocre', 'name', 'peakDrawMethod', 'peakFindBuffer', 'peakFindDrop', 'peakFindHaveHigh', 'peakFindHaveLow', 'peakFindNonadjacent', 'peakFindScale', 'peakFindThickness', 'peakFindVolumeMethod', 'peakIntensityScale', 'peakPixelSize', 'peakVolumeScale', 'printWinFileName', 'printWinInColor', 'printWinOrientation', 'printWinOtherHeight', 'printWinOtherUnit', 'printWinOtherWidth', 'printWinOutputFormat', 'printWinPaperSize', 'printWinScaling', 'printWinShowsDateTime', 'printWinShowsFileName', 'printWinTickOutside', 'printWinTickPlacement', 'printWinTitle', 'spectrumFont', 'useBootstrap', 'access', 'activeWindowGroup', 'memopsRoot', 'nmrProject',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result.add(v)

    return result
  
  def findAllAnnealProtocolStores(self, **conditions):
    """
    FindAll for memops.Implementation.MemopsRoot.annealProtocolStores
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = self
      root.refreshTopObjects('molsim.AnnealProtocol')
      currentValues = dataDict.get('annealProtocolStores').values()
      result = set(currentValues)

    else:
      root = self
      root.refreshTopObjects('molsim.AnnealProtocol')
      currentValues = dataDict.get('annealProtocolStores').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('createdBy', 'guid', 'isModifiable', 'lastUnlockedBy', 'name', 'access', 'memopsRoot',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result.add(v)

    return result
  
  def findAllAnnotationStores(self, **conditions):
    """
    FindAll for memops.Implementation.MemopsRoot.annotationStores
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = self
      root.refreshTopObjects('ccp.general.Annotation')
      currentValues = dataDict.get('annotationStores').values()
      result = set(currentValues)

    else:
      root = self
      root.refreshTopObjects('ccp.general.Annotation')
      currentValues = dataDict.get('annotationStores').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('createdBy', 'guid', 'isModifiable', 'lastUnlockedBy', 'name', 'access', 'memopsRoot',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result.add(v)

    return result
  
  def findAllChemCompCharges(self, **conditions):
    """
    FindAll for memops.Implementation.MemopsRoot.chemCompCharges
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = self
      root.refreshTopObjects('ccp.molecule.ChemCompCharge')
      currentValues = dataDict.get('chemCompCharges').values()
      result = set(currentValues)

    else:
      root = self
      root.refreshTopObjects('ccp.molecule.ChemCompCharge')
      currentValues = dataDict.get('chemCompCharges').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('ccpCode', 'createdBy', 'details', 'guid', 'isModifiable', 'lastUnlockedBy', 'molType', 'sourceName', 'access', 'memopsRoot',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result.add(v)

    return result
  
  def findAllChemCompCoords(self, **conditions):
    """
    FindAll for memops.Implementation.MemopsRoot.chemCompCoords
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = self
      root.refreshTopObjects('ccp.molecule.ChemCompCoord')
      currentValues = dataDict.get('chemCompCoords').values()
      result = set(currentValues)

    else:
      root = self
      root.refreshTopObjects('ccp.molecule.ChemCompCoord')
      currentValues = dataDict.get('chemCompCoords').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('ccpCode', 'createdBy', 'details', 'guid', 'isModifiable', 'lastUnlockedBy', 'molType', 'sourceName', 'access', 'memopsRoot',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result.add(v)

    return result
  
  def findAllChemComps(self, **conditions):
    """
    FindAll for memops.Implementation.MemopsRoot.chemComps
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = self
      root.refreshTopObjects('ccp.molecule.ChemComp')
      currentValues = dataDict.get('chemComps').values()
      result = set(currentValues)

    else:
      root = self
      root.refreshTopObjects('ccp.molecule.ChemComp')
      currentValues = dataDict.get('chemComps').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('baseGlycoCtCode', 'beilsteinCode', 'casRegCode', 'ccpCode', 'code3Letter', 'createdBy', 'details', 'guid', 'hasStdChirality', 'isModifiable', 'lastUnlockedBy', 'merckCode', 'molType', 'name', 'sigmaAldrichCode', 'stdChemCompCode', 'access', 'memopsRoot',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result.add(v)

    return result
  
  def findAllChemElementStores(self, **conditions):
    """
    FindAll for memops.Implementation.MemopsRoot.chemElementStores
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = self
      root.refreshTopObjects('ccp.molecule.ChemElement')
      currentValues = dataDict.get('chemElementStores').values()
      result = set(currentValues)

    else:
      root = self
      root.refreshTopObjects('ccp.molecule.ChemElement')
      currentValues = dataDict.get('chemElementStores').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('createdBy', 'guid', 'isModifiable', 'lastUnlockedBy', 'name', 'access', 'memopsRoot',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result.add(v)

    return result
  
  def findAllCitationStores(self, **conditions):
    """
    FindAll for memops.Implementation.MemopsRoot.citationStores
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = self
      root.refreshTopObjects('ccp.general.Citation')
      currentValues = dataDict.get('citationStores').values()
      result = set(currentValues)

    else:
      root = self
      root.refreshTopObjects('ccp.general.Citation')
      currentValues = dataDict.get('citationStores').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('createdBy', 'guid', 'isModifiable', 'lastUnlockedBy', 'name', 'access', 'memopsRoot',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result.add(v)

    return result
  
  def findAllClassifications(self, **conditions):
    """
    FindAll for memops.Implementation.MemopsRoot.classifications
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = self
      root.refreshTopObjects('ccp.lims.Classification')
      currentValues = dataDict.get('classifications').values()
      result = set(currentValues)

    else:
      root = self
      root.refreshTopObjects('ccp.lims.Classification')
      currentValues = dataDict.get('classifications').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('createdBy', 'guid', 'isModifiable', 'lastUnlockedBy', 'namingSystem', 'access', 'memopsRoot',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result.add(v)

    return result
  
  def findAllCrystallizationStores(self, **conditions):
    """
    FindAll for memops.Implementation.MemopsRoot.crystallizationStores
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = self
      root.refreshTopObjects('ccp.lims.Crystallization')
      currentValues = dataDict.get('crystallizationStores').values()
      result = set(currentValues)

    else:
      root = self
      root.refreshTopObjects('ccp.lims.Crystallization')
      currentValues = dataDict.get('crystallizationStores').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('createdBy', 'guid', 'isModifiable', 'lastUnlockedBy', 'name', 'access', 'memopsRoot',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result.add(v)

    return result
  
  def findAllDangleStores(self, **conditions):
    """
    FindAll for memops.Implementation.MemopsRoot.dangleStores
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = self
      root.refreshTopObjects('cambridge.Dangle')
      currentValues = dataDict.get('dangleStores').values()
      result = set(currentValues)

    else:
      root = self
      root.refreshTopObjects('cambridge.Dangle')
      currentValues = dataDict.get('dangleStores').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('colorScheme', 'createdBy', 'dbLocation', 'guid', 'isModifiable', 'lastUnlockedBy', 'name', 'access', 'memopsRoot',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result.add(v)

    return result
  
  def findAllDataLocationStores(self, **conditions):
    """
    FindAll for memops.Implementation.MemopsRoot.dataLocationStores
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = self
      root.refreshTopObjects('ccp.general.DataLocation')
      currentValues = dataDict.get('dataLocationStores').values()
      result = set(currentValues)

    else:
      root = self
      root.refreshTopObjects('ccp.general.DataLocation')
      currentValues = dataDict.get('dataLocationStores').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('createdBy', 'guid', 'isModifiable', 'lastUnlockedBy', 'name', 'access', 'memopsRoot',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result.add(v)

    return result
  
  def findAllDatabases(self, **conditions):
    """
    FindAll for memops.Implementation.MemopsRoot.databases
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = self
      root.refreshTopObjects('ccp.general.DbRef')
      currentValues = dataDict.get('databases').values()
      result = set(currentValues)

    else:
      root = self
      root.refreshTopObjects('ccp.general.DbRef')
      currentValues = dataDict.get('databases').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('createdBy', 'details', 'fullName', 'guid', 'isModifiable', 'lastUnlockedBy', 'name', 'url', 'access', 'memopsRoot',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result.add(v)

    return result
  
  def findAllExpBlueprintStores(self, **conditions):
    """
    FindAll for memops.Implementation.MemopsRoot.expBlueprintStores
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = self
      root.refreshTopObjects('ccp.lims.ExpBlueprint')
      currentValues = dataDict.get('expBlueprintStores').values()
      result = set(currentValues)

    else:
      root = self
      root.refreshTopObjects('ccp.lims.ExpBlueprint')
      currentValues = dataDict.get('expBlueprintStores').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('createdBy', 'guid', 'isModifiable', 'lastUnlockedBy', 'name', 'access', 'memopsRoot',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result.add(v)

    return result
  
  def findAllExperimentStores(self, **conditions):
    """
    FindAll for memops.Implementation.MemopsRoot.experimentStores
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = self
      root.refreshTopObjects('ccp.lims.Experiment')
      currentValues = dataDict.get('experimentStores').values()
      result = set(currentValues)

    else:
      root = self
      root.refreshTopObjects('ccp.lims.Experiment')
      currentValues = dataDict.get('experimentStores').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('createdBy', 'guid', 'isModifiable', 'lastUnlockedBy', 'name', 'access', 'memopsRoot',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result.add(v)

    return result
  
  def findAllHaddockProjects(self, **conditions):
    """
    FindAll for memops.Implementation.MemopsRoot.haddockProjects
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = self
      root.refreshTopObjects('utrecht.Haddock')
      currentValues = dataDict.get('haddockProjects').values()
      result = set(currentValues)

    else:
      root = self
      root.refreshTopObjects('utrecht.Haddock')
      currentValues = dataDict.get('haddockProjects').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('createdBy', 'guid', 'isModifiable', 'lastUnlockedBy', 'name', 'workingDir', 'access', 'memopsRoot',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result.add(v)

    return result
  
  def findAllHolderStores(self, **conditions):
    """
    FindAll for memops.Implementation.MemopsRoot.holderStores
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = self
      root.refreshTopObjects('ccp.lims.Holder')
      currentValues = dataDict.get('holderStores').values()
      result = set(currentValues)

    else:
      root = self
      root.refreshTopObjects('ccp.lims.Holder')
      currentValues = dataDict.get('holderStores').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('createdBy', 'guid', 'isModifiable', 'lastUnlockedBy', 'name', 'access', 'memopsRoot',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result.add(v)

    return result
  
  def findAllInstrumentStores(self, **conditions):
    """
    FindAll for memops.Implementation.MemopsRoot.instrumentStores
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = self
      root.refreshTopObjects('ccp.general.Instrument')
      currentValues = dataDict.get('instrumentStores').values()
      result = set(currentValues)

    else:
      root = self
      root.refreshTopObjects('ccp.general.Instrument')
      currentValues = dataDict.get('instrumentStores').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('createdBy', 'guid', 'isModifiable', 'lastUnlockedBy', 'name', 'access', 'memopsRoot',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result.add(v)

    return result
  
  def findAllKeywordDefinitionStores(self, **conditions):
    """
    FindAll for memops.Implementation.MemopsRoot.keywordDefinitionStores
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = self
      root.refreshTopObjects('ccp.general.KeywordDefinition')
      currentValues = dataDict.get('keywordDefinitionStores').values()
      result = set(currentValues)

    else:
      root = self
      root.refreshTopObjects('ccp.general.KeywordDefinition')
      currentValues = dataDict.get('keywordDefinitionStores').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('context', 'createdBy', 'guid', 'isModifiable', 'lastUnlockedBy', 'access', 'memopsRoot',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result.add(v)

    return result
  
  def findAllLabeledMolecules(self, **conditions):
    """
    FindAll for memops.Implementation.MemopsRoot.labeledMolecules
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = self
      root.refreshTopObjects('ccp.molecule.LabeledMolecule')
      currentValues = dataDict.get('labeledMolecules').values()
      result = set(currentValues)

    else:
      root = self
      root.refreshTopObjects('ccp.molecule.LabeledMolecule')
      currentValues = dataDict.get('labeledMolecules').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('createdBy', 'guid', 'isModifiable', 'lastUnlockedBy', 'name', 'access', 'memopsRoot',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result.add(v)

    return result
  
  def findAllLabelingSchemes(self, **conditions):
    """
    FindAll for memops.Implementation.MemopsRoot.labelingSchemes
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = self
      root.refreshTopObjects('ccp.molecule.ChemCompLabel')
      currentValues = dataDict.get('labelingSchemes').values()
      result = set(currentValues)

    else:
      root = self
      root.refreshTopObjects('ccp.molecule.ChemCompLabel')
      currentValues = dataDict.get('labelingSchemes').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('createdBy', 'details', 'guid', 'isModifiable', 'lastUnlockedBy', 'longName', 'name', 'access', 'memopsRoot',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result.add(v)

    return result
  
  def findAllLocationStores(self, **conditions):
    """
    FindAll for memops.Implementation.MemopsRoot.locationStores
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = self
      root.refreshTopObjects('ccp.lims.Location')
      currentValues = dataDict.get('locationStores').values()
      result = set(currentValues)

    else:
      root = self
      root.refreshTopObjects('ccp.lims.Location')
      currentValues = dataDict.get('locationStores').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('createdBy', 'guid', 'isModifiable', 'lastUnlockedBy', 'name', 'access', 'memopsRoot',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result.add(v)

    return result
  
  def findAllMethodStores(self, **conditions):
    """
    FindAll for memops.Implementation.MemopsRoot.methodStores
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = self
      root.refreshTopObjects('ccp.general.Method')
      currentValues = dataDict.get('methodStores').values()
      result = set(currentValues)

    else:
      root = self
      root.refreshTopObjects('ccp.general.Method')
      currentValues = dataDict.get('methodStores').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('createdBy', 'guid', 'isModifiable', 'lastUnlockedBy', 'name', 'access', 'memopsRoot',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result.add(v)

    return result
  
  def findAllMolSystemSymmetrySets(self, **conditions):
    """
    FindAll for memops.Implementation.MemopsRoot.molSystemSymmetrySets
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = self
      root.refreshTopObjects('molsim.Symmetry')
      currentValues = dataDict.get('molSystemSymmetrySets').values()
      result = set(currentValues)

    else:
      root = self
      root.refreshTopObjects('molsim.Symmetry')
      currentValues = dataDict.get('molSystemSymmetrySets').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('createdBy', 'guid', 'isModifiable', 'lastUnlockedBy', 'symmetrySetId', 'access', 'memopsRoot', 'molSystem',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result.add(v)

    return result
  
  def findAllMolSystems(self, **conditions):
    """
    FindAll for memops.Implementation.MemopsRoot.molSystems
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = self
      root.refreshTopObjects('ccp.molecule.MolSystem')
      currentValues = dataDict.get('molSystems').values()
      result = set(currentValues)

    else:
      root = self
      root.refreshTopObjects('ccp.molecule.MolSystem')
      currentValues = dataDict.get('molSystems').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('code', 'createdBy', 'details', 'guid', 'hasChemExchange', 'isModifiable', 'lastUnlockedBy', 'name', 'access', 'memopsRoot',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result.add(v)

    return result
  
  def findAllMolecules(self, **conditions):
    """
    FindAll for memops.Implementation.MemopsRoot.molecules
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = self
      root.refreshTopObjects('ccp.molecule.Molecule')
      currentValues = dataDict.get('molecules').values()
      result = set(currentValues)

    else:
      root = self
      root.refreshTopObjects('ccp.molecule.Molecule')
      currentValues = dataDict.get('molecules').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('calcIsoelectricPoint', 'createdBy', 'details', 'fragmentDetails', 'guid', 'isFinalised', 'isModifiable', 'lastUnlockedBy', 'longName', 'mutationDetails', 'name', 'seqDetails', 'smiles', 'smilesType', 'access', 'memopsRoot', 'naturalSource',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result.add(v)

    return result
  
  def findAllNameMappingStores(self, **conditions):
    """
    FindAll for memops.Implementation.MemopsRoot.nameMappingStores
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = self
      root.refreshTopObjects('ccpnmr.NameMapping')
      currentValues = dataDict.get('nameMappingStores').values()
      result = set(currentValues)

    else:
      root = self
      root.refreshTopObjects('ccpnmr.NameMapping')
      currentValues = dataDict.get('nameMappingStores').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('createdBy', 'guid', 'isModifiable', 'lastUnlockedBy', 'name', 'access', 'memopsRoot',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result.add(v)

    return result
  
  def findAllNmrCalcStores(self, **conditions):
    """
    FindAll for memops.Implementation.MemopsRoot.nmrCalcStores
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = self
      root.refreshTopObjects('ccp.nmr.NmrCalc')
      currentValues = dataDict.get('nmrCalcStores').values()
      result = set(currentValues)

    else:
      root = self
      root.refreshTopObjects('ccp.nmr.NmrCalc')
      currentValues = dataDict.get('nmrCalcStores').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('createdBy', 'guid', 'isModifiable', 'lastUnlockedBy', 'methodStoreName', 'name', 'nmrProjectName', 'softwareName', 'softwareVersion', 'validationStoreName', 'access', 'memopsRoot',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result.add(v)

    return result
  
  def findAllNmrConstraintStores(self, **conditions):
    """
    FindAll for memops.Implementation.MemopsRoot.nmrConstraintStores
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = self
      root.refreshTopObjects('ccp.nmr.NmrConstraint')
      currentValues = dataDict.get('nmrConstraintStores').values()
      result = set(currentValues)

    else:
      root = self
      root.refreshTopObjects('ccp.nmr.NmrConstraint')
      currentValues = dataDict.get('nmrConstraintStores').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('createdBy', 'guid', 'isModifiable', 'lastUnlockedBy', 'serial', 'access', 'memopsRoot', 'nmrProject',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result.add(v)

    return result
  
  def findAllNmrEntryStores(self, **conditions):
    """
    FindAll for memops.Implementation.MemopsRoot.nmrEntryStores
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = self
      root.refreshTopObjects('ccp.nmr.NmrEntry')
      currentValues = dataDict.get('nmrEntryStores').values()
      result = set(currentValues)

    else:
      root = self
      root.refreshTopObjects('ccp.nmr.NmrEntry')
      currentValues = dataDict.get('nmrEntryStores').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('createdBy', 'guid', 'isModifiable', 'lastUnlockedBy', 'name', 'access', 'memopsRoot',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result.add(v)

    return result
  
  def findAllNmrExpPrototypes(self, **conditions):
    """
    FindAll for memops.Implementation.MemopsRoot.nmrExpPrototypes
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = self
      root.refreshTopObjects('ccp.nmr.NmrExpPrototype')
      currentValues = dataDict.get('nmrExpPrototypes').values()
      result = set(currentValues)

    else:
      root = self
      root.refreshTopObjects('ccp.nmr.NmrExpPrototype')
      currentValues = dataDict.get('nmrExpPrototypes').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('category', 'createdBy', 'details', 'guid', 'isModifiable', 'lastUnlockedBy', 'name', 'priority', 'serial', 'synonym', 'access', 'memopsRoot',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result.add(v)

    return result
  
  def findAllNmrProjects(self, **conditions):
    """
    FindAll for memops.Implementation.MemopsRoot.nmrProjects
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = self
      root.refreshTopObjects('ccp.nmr.Nmr')
      currentValues = dataDict.get('nmrProjects').values()
      result = set(currentValues)

    else:
      root = self
      root.refreshTopObjects('ccp.nmr.Nmr')
      currentValues = dataDict.get('nmrProjects').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('createdBy', 'guid', 'isModifiable', 'lastUnlockedBy', 'name', 'access', 'analysisProject', 'memopsRoot',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result.add(v)

    return result
  
  def findAllNmrReferenceStores(self, **conditions):
    """
    FindAll for memops.Implementation.MemopsRoot.nmrReferenceStores
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = self
      root.refreshTopObjects('ccp.nmr.NmrReference')
      currentValues = dataDict.get('nmrReferenceStores').values()
      result = set(currentValues)

    else:
      root = self
      root.refreshTopObjects('ccp.nmr.NmrReference')
      currentValues = dataDict.get('nmrReferenceStores').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('ccpCode', 'createdBy', 'guid', 'isModifiable', 'lastUnlockedBy', 'molType', 'name', 'access', 'memopsRoot',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result.add(v)

    return result
  
  def findAllNmrScreenStores(self, **conditions):
    """
    FindAll for memops.Implementation.MemopsRoot.nmrScreenStores
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = self
      root.refreshTopObjects('ccp.nmr.NmrScreen')
      currentValues = dataDict.get('nmrScreenStores').values()
      result = set(currentValues)

    else:
      root = self
      root.refreshTopObjects('ccp.nmr.NmrScreen')
      currentValues = dataDict.get('nmrScreenStores').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('code', 'createdBy', 'guid', 'isModifiable', 'lastUnlockedBy', 'name', 'access', 'memopsRoot',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result.add(v)

    return result
  
  def findAllPackageLocators(self, **conditions):
    """
    FindAll for memops.Implementation.MemopsRoot.packageLocators
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('packageLocators').values()
      result = set(currentValues)

    else:
      currentValues = dataDict.get('packageLocators').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('targetName', 'memopsRoot',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result.add(v)

    return result
  
  def findAllProtocolStores(self, **conditions):
    """
    FindAll for memops.Implementation.MemopsRoot.protocolStores
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = self
      root.refreshTopObjects('ccp.lims.Protocol')
      currentValues = dataDict.get('protocolStores').values()
      result = set(currentValues)

    else:
      root = self
      root.refreshTopObjects('ccp.lims.Protocol')
      currentValues = dataDict.get('protocolStores').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('createdBy', 'guid', 'isModifiable', 'lastUnlockedBy', 'name', 'access', 'memopsRoot',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result.add(v)

    return result
  
  def findAllRefSampleComponentStores(self, **conditions):
    """
    FindAll for memops.Implementation.MemopsRoot.refSampleComponentStores
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = self
      root.refreshTopObjects('ccp.lims.RefSampleComponent')
      currentValues = dataDict.get('refSampleComponentStores').values()
      result = set(currentValues)

    else:
      root = self
      root.refreshTopObjects('ccp.lims.RefSampleComponent')
      currentValues = dataDict.get('refSampleComponentStores').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('createdBy', 'guid', 'isModifiable', 'lastUnlockedBy', 'name', 'access', 'memopsRoot',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result.add(v)

    return result
  
  def findAllRepositories(self, **conditions):
    """
    FindAll for memops.Implementation.MemopsRoot.repositories
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('repositories').values()
      result = set(currentValues)

    else:
      currentValues = dataDict.get('repositories').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('format', 'name', 'url', 'memopsRoot',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result.add(v)

    return result
  
  def findAllSampleStores(self, **conditions):
    """
    FindAll for memops.Implementation.MemopsRoot.sampleStores
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = self
      root.refreshTopObjects('ccp.lims.Sample')
      currentValues = dataDict.get('sampleStores').values()
      result = set(currentValues)

    else:
      root = self
      root.refreshTopObjects('ccp.lims.Sample')
      currentValues = dataDict.get('sampleStores').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('createdBy', 'guid', 'isModifiable', 'lastUnlockedBy', 'name', 'access', 'memopsRoot',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result.add(v)

    return result
  
  def findAllStereochemistryStores(self, **conditions):
    """
    FindAll for memops.Implementation.MemopsRoot.stereochemistryStores
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = self
      root.refreshTopObjects('ccp.molecule.Stereochemistry')
      currentValues = dataDict.get('stereochemistryStores').values()
      result = set(currentValues)

    else:
      root = self
      root.refreshTopObjects('ccp.molecule.Stereochemistry')
      currentValues = dataDict.get('stereochemistryStores').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('createdBy', 'guid', 'isModifiable', 'lastUnlockedBy', 'name', 'access', 'memopsRoot',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result.add(v)

    return result
  
  def findAllStructureEnsembles(self, **conditions):
    """
    FindAll for memops.Implementation.MemopsRoot.structureEnsembles
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = self
      root.refreshTopObjects('ccp.molecule.MolStructure')
      currentValues = dataDict.get('structureEnsembles').values()
      result = set(currentValues)

    else:
      root = self
      root.refreshTopObjects('ccp.molecule.MolStructure')
      currentValues = dataDict.get('structureEnsembles').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('atomNamingSystem', 'createdBy', 'details', 'ensembleId', 'guid', 'isModifiable', 'lastUnlockedBy', 'resNamingSystem', 'access', 'memopsRoot', 'molSystem', 'structureGeneration',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result.add(v)

    return result
  
  def findAllTargetStores(self, **conditions):
    """
    FindAll for memops.Implementation.MemopsRoot.targetStores
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = self
      root.refreshTopObjects('ccp.lims.Target')
      currentValues = dataDict.get('targetStores').values()
      result = set(currentValues)

    else:
      root = self
      root.refreshTopObjects('ccp.lims.Target')
      currentValues = dataDict.get('targetStores').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('createdBy', 'guid', 'isModifiable', 'lastUnlockedBy', 'name', 'access', 'memopsRoot',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result.add(v)

    return result
  
  def findAllTaxonomies(self, **conditions):
    """
    FindAll for memops.Implementation.MemopsRoot.taxonomies
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = self
      root.refreshTopObjects('ccp.general.Taxonomy')
      currentValues = dataDict.get('taxonomies').values()
      result = set(currentValues)

    else:
      root = self
      root.refreshTopObjects('ccp.general.Taxonomy')
      currentValues = dataDict.get('taxonomies').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('createdBy', 'guid', 'isModifiable', 'lastUnlockedBy', 'name', 'access', 'memopsRoot',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result.add(v)

    return result
  
  def findAllTopObjects(self, **conditions):
    """
    FindAll for memops.Implementation.MemopsRoot.topObjects
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = self.getTopObjects()
      result = set(currentValues)

    else:
      currentValues = self.getTopObjects()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('createdBy', 'guid', 'isModifiable', 'lastUnlockedBy', 'access', 'memopsRoot',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result.add(v)

    return result
  
  def findAllValidationStores(self, **conditions):
    """
    FindAll for memops.Implementation.MemopsRoot.validationStores
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = self
      root.refreshTopObjects('ccp.molecule.Validation')
      currentValues = dataDict.get('validationStores').values()
      result = set(currentValues)

    else:
      root = self
      root.refreshTopObjects('ccp.molecule.Validation')
      currentValues = dataDict.get('validationStores').values()
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('createdBy', 'guid', 'isModifiable', 'lastUnlockedBy', 'name', 'access', 'memopsRoot', 'nmrConstraintStore', 'nmrProject', 'software', 'structureEnsemble',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result.add(v)

    return result
  
  def findFirstAccessControlStore(self, **conditions):
    """
    FindFirst for memops.Implementation.MemopsRoot.accessControlStores
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = self
      root.refreshTopObjects('memops.AccessControl')
      currentValues = dataDict.get('accessControlStores').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      objKey = conditions.get('name')
      if (objKey is not None):
        result = dataDict.get('accessControlStores').get(objKey)
        if (result is None):
          root = self
          root.refreshTopObjects('memops.AccessControl')
          result = dataDict.get('accessControlStores').get(objKey)

        if (result is None):
          return result

        elif (len(conditions) <= 1):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        root = self
        root.refreshTopObjects('memops.AccessControl')
        currentValues = dataDict.get('accessControlStores').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('createdBy', 'guid', 'isModifiable', 'lastUnlockedBy', 'name', 'access', 'memopsRoot',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result = v; break

    return result
  
  def findFirstActiveRepository(self, **conditions):
    """
    FindFirst for memops.Implementation.MemopsRoot.activeRepositories
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = self.getActiveRepositories()
      if (currentValues):
        result = currentValues[0]
      else:
        result = None

    else:
      currentValues = dataDict.get('activeRepositories')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('format', 'name', 'url', 'memopsRoot',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result = v; break

    return result
  
  def findFirstAffiliationStore(self, **conditions):
    """
    FindFirst for memops.Implementation.MemopsRoot.affiliationStores
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = self
      root.refreshTopObjects('ccp.general.Affiliation')
      currentValues = dataDict.get('affiliationStores').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      objKey = conditions.get('name')
      if (objKey is not None):
        result = dataDict.get('affiliationStores').get(objKey)
        if (result is None):
          root = self
          root.refreshTopObjects('ccp.general.Affiliation')
          result = dataDict.get('affiliationStores').get(objKey)

        if (result is None):
          return result

        elif (len(conditions) <= 1):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        root = self
        root.refreshTopObjects('ccp.general.Affiliation')
        currentValues = dataDict.get('affiliationStores').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('createdBy', 'guid', 'isModifiable', 'lastUnlockedBy', 'name', 'access', 'memopsRoot',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result = v; break

    return result
  
  def findFirstAnalysisProfile(self, **conditions):
    """
    FindFirst for memops.Implementation.MemopsRoot.analysisProfiles
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = self
      root.refreshTopObjects('ccpnmr.AnalysisProfile')
      currentValues = dataDict.get('analysisProfiles').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      objKey = conditions.get('name')
      if (objKey is not None):
        result = dataDict.get('analysisProfiles').get(objKey)
        if (result is None):
          root = self
          root.refreshTopObjects('ccpnmr.AnalysisProfile')
          result = dataDict.get('analysisProfiles').get(objKey)

        if (result is None):
          return result

        elif (len(conditions) <= 1):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        root = self
        root.refreshTopObjects('ccpnmr.AnalysisProfile')
        currentValues = dataDict.get('analysisProfiles').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('bgColor', 'createdBy', 'fgColor', 'font', 'graphicsHandler', 'guid', 'isModifiable', 'lastUnlockedBy', 'name', 'panView', 'sendBugReports', 'transientDialogs', 'transientWindows', 'twoCharShortcuts', 'useCrosshair', 'useGlobalShortcuts', 'userEmail', 'userName', 'userOrganisation', 'webBrowser', 'access', 'marksColor', 'memopsRoot', 'rulersColor',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result = v; break

    return result
  
  def findFirstAnalysisProject(self, **conditions):
    """
    FindFirst for memops.Implementation.MemopsRoot.analysisProjects
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = self
      root.refreshTopObjects('ccpnmr.Analysis')
      currentValues = dataDict.get('analysisProjects').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      objKey = conditions.get('name')
      if (objKey is not None):
        result = dataDict.get('analysisProjects').get(objKey)
        if (result is None):
          root = self
          root.refreshTopObjects('ccpnmr.Analysis')
          result = dataDict.get('analysisProjects').get(objKey)

        if (result is None):
          return result

        elif (len(conditions) <= 1):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        root = self
        root.refreshTopObjects('ccpnmr.Analysis')
        currentValues = dataDict.get('analysisProjects').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('autoBackupFreq', 'contourToUnaliased', 'createdBy', 'defaultSpectrumFileType', 'doAssignmentAnnotations', 'doAutoBackup', 'doChainAnnotations', 'doDetailAnnotations', 'doMeritAnnotations', 'doMinimalAnnotations', 'doMolSysAnnotations', 'doSpinSystemAnnotations', 'globalContourScale', 'guid', 'isModifiable', 'isThreadingAllowed', 'lastUnlockedBy', 'linkPeakListsData', 'linkSeqSpinSystemsData', 'maxMarks', 'maxRulers', 'meritAnnotationBad', 'meritAnnotationGood', 'meritAnnotationMediocre', 'name', 'peakDrawMethod', 'peakFindBuffer', 'peakFindDrop', 'peakFindHaveHigh', 'peakFindHaveLow', 'peakFindNonadjacent', 'peakFindScale', 'peakFindThickness', 'peakFindVolumeMethod', 'peakIntensityScale', 'peakPixelSize', 'peakVolumeScale', 'printWinFileName', 'printWinInColor', 'printWinOrientation', 'printWinOtherHeight', 'printWinOtherUnit', 'printWinOtherWidth', 'printWinOutputFormat', 'printWinPaperSize', 'printWinScaling', 'printWinShowsDateTime', 'printWinShowsFileName', 'printWinTickOutside', 'printWinTickPlacement', 'printWinTitle', 'spectrumFont', 'useBootstrap', 'access', 'activeWindowGroup', 'memopsRoot', 'nmrProject',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result = v; break

    return result
  
  def findFirstAnnealProtocolStore(self, **conditions):
    """
    FindFirst for memops.Implementation.MemopsRoot.annealProtocolStores
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = self
      root.refreshTopObjects('molsim.AnnealProtocol')
      currentValues = dataDict.get('annealProtocolStores').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      objKey = conditions.get('name')
      if (objKey is not None):
        result = dataDict.get('annealProtocolStores').get(objKey)
        if (result is None):
          root = self
          root.refreshTopObjects('molsim.AnnealProtocol')
          result = dataDict.get('annealProtocolStores').get(objKey)

        if (result is None):
          return result

        elif (len(conditions) <= 1):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        root = self
        root.refreshTopObjects('molsim.AnnealProtocol')
        currentValues = dataDict.get('annealProtocolStores').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('createdBy', 'guid', 'isModifiable', 'lastUnlockedBy', 'name', 'access', 'memopsRoot',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result = v; break

    return result
  
  def findFirstAnnotationStore(self, **conditions):
    """
    FindFirst for memops.Implementation.MemopsRoot.annotationStores
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = self
      root.refreshTopObjects('ccp.general.Annotation')
      currentValues = dataDict.get('annotationStores').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      objKey = conditions.get('name')
      if (objKey is not None):
        result = dataDict.get('annotationStores').get(objKey)
        if (result is None):
          root = self
          root.refreshTopObjects('ccp.general.Annotation')
          result = dataDict.get('annotationStores').get(objKey)

        if (result is None):
          return result

        elif (len(conditions) <= 1):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        root = self
        root.refreshTopObjects('ccp.general.Annotation')
        currentValues = dataDict.get('annotationStores').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('createdBy', 'guid', 'isModifiable', 'lastUnlockedBy', 'name', 'access', 'memopsRoot',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result = v; break

    return result
  
  def findFirstChemComp(self, **conditions):
    """
    FindFirst for memops.Implementation.MemopsRoot.chemComps
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = self
      root.refreshTopObjects('ccp.molecule.ChemComp')
      currentValues = dataDict.get('chemComps').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      ll = list()
      objKey = conditions.get('molType')
      ll.append(objKey)
      if (objKey is not None):
        objKey = conditions.get('ccpCode')
        ll.append(objKey)
        if (objKey is not None):
          objKey = tuple(ll)

      if (objKey is not None):
        result = dataDict.get('chemComps').get(objKey)
        if (result is None):
          root = self
          root.refreshTopObjects('ccp.molecule.ChemComp')
          result = dataDict.get('chemComps').get(objKey)

        if (result is None):
          return result

        elif (len(conditions) <= 2):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        root = self
        root.refreshTopObjects('ccp.molecule.ChemComp')
        currentValues = dataDict.get('chemComps').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('baseGlycoCtCode', 'beilsteinCode', 'casRegCode', 'ccpCode', 'code3Letter', 'createdBy', 'details', 'guid', 'hasStdChirality', 'isModifiable', 'lastUnlockedBy', 'merckCode', 'molType', 'name', 'sigmaAldrichCode', 'stdChemCompCode', 'access', 'memopsRoot',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result = v; break

    return result
  
  def findFirstChemCompCharge(self, **conditions):
    """
    FindFirst for memops.Implementation.MemopsRoot.chemCompCharges
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = self
      root.refreshTopObjects('ccp.molecule.ChemCompCharge')
      currentValues = dataDict.get('chemCompCharges').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      ll = list()
      objKey = conditions.get('sourceName')
      ll.append(objKey)
      if (objKey is not None):
        objKey = conditions.get('molType')
        ll.append(objKey)
        if (objKey is not None):
          objKey = conditions.get('ccpCode')
          ll.append(objKey)
          if (objKey is not None):
            objKey = tuple(ll)

      if (objKey is not None):
        result = dataDict.get('chemCompCharges').get(objKey)
        if (result is None):
          root = self
          root.refreshTopObjects('ccp.molecule.ChemCompCharge')
          result = dataDict.get('chemCompCharges').get(objKey)

        if (result is None):
          return result

        elif (len(conditions) <= 3):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        root = self
        root.refreshTopObjects('ccp.molecule.ChemCompCharge')
        currentValues = dataDict.get('chemCompCharges').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('ccpCode', 'createdBy', 'details', 'guid', 'isModifiable', 'lastUnlockedBy', 'molType', 'sourceName', 'access', 'memopsRoot',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result = v; break

    return result
  
  def findFirstChemCompCoord(self, **conditions):
    """
    FindFirst for memops.Implementation.MemopsRoot.chemCompCoords
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = self
      root.refreshTopObjects('ccp.molecule.ChemCompCoord')
      currentValues = dataDict.get('chemCompCoords').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      ll = list()
      objKey = conditions.get('sourceName')
      ll.append(objKey)
      if (objKey is not None):
        objKey = conditions.get('molType')
        ll.append(objKey)
        if (objKey is not None):
          objKey = conditions.get('ccpCode')
          ll.append(objKey)
          if (objKey is not None):
            objKey = tuple(ll)

      if (objKey is not None):
        result = dataDict.get('chemCompCoords').get(objKey)
        if (result is None):
          root = self
          root.refreshTopObjects('ccp.molecule.ChemCompCoord')
          result = dataDict.get('chemCompCoords').get(objKey)

        if (result is None):
          return result

        elif (len(conditions) <= 3):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        root = self
        root.refreshTopObjects('ccp.molecule.ChemCompCoord')
        currentValues = dataDict.get('chemCompCoords').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('ccpCode', 'createdBy', 'details', 'guid', 'isModifiable', 'lastUnlockedBy', 'molType', 'sourceName', 'access', 'memopsRoot',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result = v; break

    return result
  
  def findFirstChemElementStore(self, **conditions):
    """
    FindFirst for memops.Implementation.MemopsRoot.chemElementStores
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = self
      root.refreshTopObjects('ccp.molecule.ChemElement')
      currentValues = dataDict.get('chemElementStores').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      objKey = conditions.get('name')
      if (objKey is not None):
        result = dataDict.get('chemElementStores').get(objKey)
        if (result is None):
          root = self
          root.refreshTopObjects('ccp.molecule.ChemElement')
          result = dataDict.get('chemElementStores').get(objKey)

        if (result is None):
          return result

        elif (len(conditions) <= 1):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        root = self
        root.refreshTopObjects('ccp.molecule.ChemElement')
        currentValues = dataDict.get('chemElementStores').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('createdBy', 'guid', 'isModifiable', 'lastUnlockedBy', 'name', 'access', 'memopsRoot',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result = v; break

    return result
  
  def findFirstCitationStore(self, **conditions):
    """
    FindFirst for memops.Implementation.MemopsRoot.citationStores
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = self
      root.refreshTopObjects('ccp.general.Citation')
      currentValues = dataDict.get('citationStores').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      objKey = conditions.get('name')
      if (objKey is not None):
        result = dataDict.get('citationStores').get(objKey)
        if (result is None):
          root = self
          root.refreshTopObjects('ccp.general.Citation')
          result = dataDict.get('citationStores').get(objKey)

        if (result is None):
          return result

        elif (len(conditions) <= 1):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        root = self
        root.refreshTopObjects('ccp.general.Citation')
        currentValues = dataDict.get('citationStores').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('createdBy', 'guid', 'isModifiable', 'lastUnlockedBy', 'name', 'access', 'memopsRoot',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result = v; break

    return result
  
  def findFirstClassification(self, **conditions):
    """
    FindFirst for memops.Implementation.MemopsRoot.classifications
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = self
      root.refreshTopObjects('ccp.lims.Classification')
      currentValues = dataDict.get('classifications').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      objKey = conditions.get('namingSystem')
      if (objKey is not None):
        result = dataDict.get('classifications').get(objKey)
        if (result is None):
          root = self
          root.refreshTopObjects('ccp.lims.Classification')
          result = dataDict.get('classifications').get(objKey)

        if (result is None):
          return result

        elif (len(conditions) <= 1):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        root = self
        root.refreshTopObjects('ccp.lims.Classification')
        currentValues = dataDict.get('classifications').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('createdBy', 'guid', 'isModifiable', 'lastUnlockedBy', 'namingSystem', 'access', 'memopsRoot',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result = v; break

    return result
  
  def findFirstCrystallizationStore(self, **conditions):
    """
    FindFirst for memops.Implementation.MemopsRoot.crystallizationStores
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = self
      root.refreshTopObjects('ccp.lims.Crystallization')
      currentValues = dataDict.get('crystallizationStores').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      objKey = conditions.get('name')
      if (objKey is not None):
        result = dataDict.get('crystallizationStores').get(objKey)
        if (result is None):
          root = self
          root.refreshTopObjects('ccp.lims.Crystallization')
          result = dataDict.get('crystallizationStores').get(objKey)

        if (result is None):
          return result

        elif (len(conditions) <= 1):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        root = self
        root.refreshTopObjects('ccp.lims.Crystallization')
        currentValues = dataDict.get('crystallizationStores').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('createdBy', 'guid', 'isModifiable', 'lastUnlockedBy', 'name', 'access', 'memopsRoot',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result = v; break

    return result
  
  def findFirstDangleStore(self, **conditions):
    """
    FindFirst for memops.Implementation.MemopsRoot.dangleStores
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = self
      root.refreshTopObjects('cambridge.Dangle')
      currentValues = dataDict.get('dangleStores').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      objKey = conditions.get('name')
      if (objKey is not None):
        result = dataDict.get('dangleStores').get(objKey)
        if (result is None):
          root = self
          root.refreshTopObjects('cambridge.Dangle')
          result = dataDict.get('dangleStores').get(objKey)

        if (result is None):
          return result

        elif (len(conditions) <= 1):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        root = self
        root.refreshTopObjects('cambridge.Dangle')
        currentValues = dataDict.get('dangleStores').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('colorScheme', 'createdBy', 'dbLocation', 'guid', 'isModifiable', 'lastUnlockedBy', 'name', 'access', 'memopsRoot',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result = v; break

    return result
  
  def findFirstDataLocationStore(self, **conditions):
    """
    FindFirst for memops.Implementation.MemopsRoot.dataLocationStores
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = self
      root.refreshTopObjects('ccp.general.DataLocation')
      currentValues = dataDict.get('dataLocationStores').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      objKey = conditions.get('name')
      if (objKey is not None):
        result = dataDict.get('dataLocationStores').get(objKey)
        if (result is None):
          root = self
          root.refreshTopObjects('ccp.general.DataLocation')
          result = dataDict.get('dataLocationStores').get(objKey)

        if (result is None):
          return result

        elif (len(conditions) <= 1):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        root = self
        root.refreshTopObjects('ccp.general.DataLocation')
        currentValues = dataDict.get('dataLocationStores').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('createdBy', 'guid', 'isModifiable', 'lastUnlockedBy', 'name', 'access', 'memopsRoot',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result = v; break

    return result
  
  def findFirstDatabase(self, **conditions):
    """
    FindFirst for memops.Implementation.MemopsRoot.databases
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = self
      root.refreshTopObjects('ccp.general.DbRef')
      currentValues = dataDict.get('databases').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      objKey = conditions.get('name')
      if (objKey is not None):
        result = dataDict.get('databases').get(objKey)
        if (result is None):
          root = self
          root.refreshTopObjects('ccp.general.DbRef')
          result = dataDict.get('databases').get(objKey)

        if (result is None):
          return result

        elif (len(conditions) <= 1):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        root = self
        root.refreshTopObjects('ccp.general.DbRef')
        currentValues = dataDict.get('databases').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('createdBy', 'details', 'fullName', 'guid', 'isModifiable', 'lastUnlockedBy', 'name', 'url', 'access', 'memopsRoot',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result = v; break

    return result
  
  def findFirstExpBlueprintStore(self, **conditions):
    """
    FindFirst for memops.Implementation.MemopsRoot.expBlueprintStores
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = self
      root.refreshTopObjects('ccp.lims.ExpBlueprint')
      currentValues = dataDict.get('expBlueprintStores').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      objKey = conditions.get('name')
      if (objKey is not None):
        result = dataDict.get('expBlueprintStores').get(objKey)
        if (result is None):
          root = self
          root.refreshTopObjects('ccp.lims.ExpBlueprint')
          result = dataDict.get('expBlueprintStores').get(objKey)

        if (result is None):
          return result

        elif (len(conditions) <= 1):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        root = self
        root.refreshTopObjects('ccp.lims.ExpBlueprint')
        currentValues = dataDict.get('expBlueprintStores').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('createdBy', 'guid', 'isModifiable', 'lastUnlockedBy', 'name', 'access', 'memopsRoot',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result = v; break

    return result
  
  def findFirstExperimentStore(self, **conditions):
    """
    FindFirst for memops.Implementation.MemopsRoot.experimentStores
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = self
      root.refreshTopObjects('ccp.lims.Experiment')
      currentValues = dataDict.get('experimentStores').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      objKey = conditions.get('name')
      if (objKey is not None):
        result = dataDict.get('experimentStores').get(objKey)
        if (result is None):
          root = self
          root.refreshTopObjects('ccp.lims.Experiment')
          result = dataDict.get('experimentStores').get(objKey)

        if (result is None):
          return result

        elif (len(conditions) <= 1):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        root = self
        root.refreshTopObjects('ccp.lims.Experiment')
        currentValues = dataDict.get('experimentStores').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('createdBy', 'guid', 'isModifiable', 'lastUnlockedBy', 'name', 'access', 'memopsRoot',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result = v; break

    return result
  
  def findFirstHaddockProject(self, **conditions):
    """
    FindFirst for memops.Implementation.MemopsRoot.haddockProjects
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = self
      root.refreshTopObjects('utrecht.Haddock')
      currentValues = dataDict.get('haddockProjects').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      objKey = conditions.get('name')
      if (objKey is not None):
        result = dataDict.get('haddockProjects').get(objKey)
        if (result is None):
          root = self
          root.refreshTopObjects('utrecht.Haddock')
          result = dataDict.get('haddockProjects').get(objKey)

        if (result is None):
          return result

        elif (len(conditions) <= 1):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        root = self
        root.refreshTopObjects('utrecht.Haddock')
        currentValues = dataDict.get('haddockProjects').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('createdBy', 'guid', 'isModifiable', 'lastUnlockedBy', 'name', 'workingDir', 'access', 'memopsRoot',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result = v; break

    return result
  
  def findFirstHolderStore(self, **conditions):
    """
    FindFirst for memops.Implementation.MemopsRoot.holderStores
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = self
      root.refreshTopObjects('ccp.lims.Holder')
      currentValues = dataDict.get('holderStores').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      objKey = conditions.get('name')
      if (objKey is not None):
        result = dataDict.get('holderStores').get(objKey)
        if (result is None):
          root = self
          root.refreshTopObjects('ccp.lims.Holder')
          result = dataDict.get('holderStores').get(objKey)

        if (result is None):
          return result

        elif (len(conditions) <= 1):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        root = self
        root.refreshTopObjects('ccp.lims.Holder')
        currentValues = dataDict.get('holderStores').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('createdBy', 'guid', 'isModifiable', 'lastUnlockedBy', 'name', 'access', 'memopsRoot',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result = v; break

    return result
  
  def findFirstInstrumentStore(self, **conditions):
    """
    FindFirst for memops.Implementation.MemopsRoot.instrumentStores
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = self
      root.refreshTopObjects('ccp.general.Instrument')
      currentValues = dataDict.get('instrumentStores').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      objKey = conditions.get('name')
      if (objKey is not None):
        result = dataDict.get('instrumentStores').get(objKey)
        if (result is None):
          root = self
          root.refreshTopObjects('ccp.general.Instrument')
          result = dataDict.get('instrumentStores').get(objKey)

        if (result is None):
          return result

        elif (len(conditions) <= 1):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        root = self
        root.refreshTopObjects('ccp.general.Instrument')
        currentValues = dataDict.get('instrumentStores').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('createdBy', 'guid', 'isModifiable', 'lastUnlockedBy', 'name', 'access', 'memopsRoot',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result = v; break

    return result
  
  def findFirstKeywordDefinitionStore(self, **conditions):
    """
    FindFirst for memops.Implementation.MemopsRoot.keywordDefinitionStores
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = self
      root.refreshTopObjects('ccp.general.KeywordDefinition')
      currentValues = dataDict.get('keywordDefinitionStores').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      objKey = conditions.get('context')
      if (objKey is not None):
        result = dataDict.get('keywordDefinitionStores').get(objKey)
        if (result is None):
          root = self
          root.refreshTopObjects('ccp.general.KeywordDefinition')
          result = dataDict.get('keywordDefinitionStores').get(objKey)

        if (result is None):
          return result

        elif (len(conditions) <= 1):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        root = self
        root.refreshTopObjects('ccp.general.KeywordDefinition')
        currentValues = dataDict.get('keywordDefinitionStores').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('context', 'createdBy', 'guid', 'isModifiable', 'lastUnlockedBy', 'access', 'memopsRoot',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result = v; break

    return result
  
  def findFirstLabeledMolecule(self, **conditions):
    """
    FindFirst for memops.Implementation.MemopsRoot.labeledMolecules
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = self
      root.refreshTopObjects('ccp.molecule.LabeledMolecule')
      currentValues = dataDict.get('labeledMolecules').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      objKey = conditions.get('name')
      if (objKey is not None):
        result = dataDict.get('labeledMolecules').get(objKey)
        if (result is None):
          root = self
          root.refreshTopObjects('ccp.molecule.LabeledMolecule')
          result = dataDict.get('labeledMolecules').get(objKey)

        if (result is None):
          return result

        elif (len(conditions) <= 1):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        root = self
        root.refreshTopObjects('ccp.molecule.LabeledMolecule')
        currentValues = dataDict.get('labeledMolecules').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('createdBy', 'guid', 'isModifiable', 'lastUnlockedBy', 'name', 'access', 'memopsRoot',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result = v; break

    return result
  
  def findFirstLabelingScheme(self, **conditions):
    """
    FindFirst for memops.Implementation.MemopsRoot.labelingSchemes
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = self
      root.refreshTopObjects('ccp.molecule.ChemCompLabel')
      currentValues = dataDict.get('labelingSchemes').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      objKey = conditions.get('name')
      if (objKey is not None):
        result = dataDict.get('labelingSchemes').get(objKey)
        if (result is None):
          root = self
          root.refreshTopObjects('ccp.molecule.ChemCompLabel')
          result = dataDict.get('labelingSchemes').get(objKey)

        if (result is None):
          return result

        elif (len(conditions) <= 1):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        root = self
        root.refreshTopObjects('ccp.molecule.ChemCompLabel')
        currentValues = dataDict.get('labelingSchemes').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('createdBy', 'details', 'guid', 'isModifiable', 'lastUnlockedBy', 'longName', 'name', 'access', 'memopsRoot',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result = v; break

    return result
  
  def findFirstLocationStore(self, **conditions):
    """
    FindFirst for memops.Implementation.MemopsRoot.locationStores
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = self
      root.refreshTopObjects('ccp.lims.Location')
      currentValues = dataDict.get('locationStores').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      objKey = conditions.get('name')
      if (objKey is not None):
        result = dataDict.get('locationStores').get(objKey)
        if (result is None):
          root = self
          root.refreshTopObjects('ccp.lims.Location')
          result = dataDict.get('locationStores').get(objKey)

        if (result is None):
          return result

        elif (len(conditions) <= 1):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        root = self
        root.refreshTopObjects('ccp.lims.Location')
        currentValues = dataDict.get('locationStores').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('createdBy', 'guid', 'isModifiable', 'lastUnlockedBy', 'name', 'access', 'memopsRoot',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result = v; break

    return result
  
  def findFirstMethodStore(self, **conditions):
    """
    FindFirst for memops.Implementation.MemopsRoot.methodStores
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = self
      root.refreshTopObjects('ccp.general.Method')
      currentValues = dataDict.get('methodStores').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      objKey = conditions.get('name')
      if (objKey is not None):
        result = dataDict.get('methodStores').get(objKey)
        if (result is None):
          root = self
          root.refreshTopObjects('ccp.general.Method')
          result = dataDict.get('methodStores').get(objKey)

        if (result is None):
          return result

        elif (len(conditions) <= 1):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        root = self
        root.refreshTopObjects('ccp.general.Method')
        currentValues = dataDict.get('methodStores').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('createdBy', 'guid', 'isModifiable', 'lastUnlockedBy', 'name', 'access', 'memopsRoot',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result = v; break

    return result
  
  def findFirstMolSystem(self, **conditions):
    """
    FindFirst for memops.Implementation.MemopsRoot.molSystems
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = self
      root.refreshTopObjects('ccp.molecule.MolSystem')
      currentValues = dataDict.get('molSystems').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      objKey = conditions.get('code')
      if (objKey is not None):
        result = dataDict.get('molSystems').get(objKey)
        if (result is None):
          root = self
          root.refreshTopObjects('ccp.molecule.MolSystem')
          result = dataDict.get('molSystems').get(objKey)

        if (result is None):
          return result

        elif (len(conditions) <= 1):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        root = self
        root.refreshTopObjects('ccp.molecule.MolSystem')
        currentValues = dataDict.get('molSystems').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('code', 'createdBy', 'details', 'guid', 'hasChemExchange', 'isModifiable', 'lastUnlockedBy', 'name', 'access', 'memopsRoot',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result = v; break

    return result
  
  def findFirstMolSystemSymmetrySet(self, **conditions):
    """
    FindFirst for memops.Implementation.MemopsRoot.molSystemSymmetrySets
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = self
      root.refreshTopObjects('molsim.Symmetry')
      currentValues = dataDict.get('molSystemSymmetrySets').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      ll = list()
      objKey = conditions.get('molSystem')
      ll.append(objKey)
      if (objKey is not None):
        objKey = conditions.get('symmetrySetId')
        ll.append(objKey)
        if (objKey is not None):
          objKey = tuple(ll)

      if (objKey is not None):
        result = dataDict.get('molSystemSymmetrySets').get(objKey)
        if (result is None):
          root = self
          root.refreshTopObjects('molsim.Symmetry')
          result = dataDict.get('molSystemSymmetrySets').get(objKey)

        if (result is None):
          return result

        elif (len(conditions) <= 2):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        root = self
        root.refreshTopObjects('molsim.Symmetry')
        currentValues = dataDict.get('molSystemSymmetrySets').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('createdBy', 'guid', 'isModifiable', 'lastUnlockedBy', 'symmetrySetId', 'access', 'memopsRoot', 'molSystem',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result = v; break

    return result
  
  def findFirstMolecule(self, **conditions):
    """
    FindFirst for memops.Implementation.MemopsRoot.molecules
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = self
      root.refreshTopObjects('ccp.molecule.Molecule')
      currentValues = dataDict.get('molecules').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      objKey = conditions.get('name')
      if (objKey is not None):
        result = dataDict.get('molecules').get(objKey)
        if (result is None):
          root = self
          root.refreshTopObjects('ccp.molecule.Molecule')
          result = dataDict.get('molecules').get(objKey)

        if (result is None):
          return result

        elif (len(conditions) <= 1):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        root = self
        root.refreshTopObjects('ccp.molecule.Molecule')
        currentValues = dataDict.get('molecules').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('calcIsoelectricPoint', 'createdBy', 'details', 'fragmentDetails', 'guid', 'isFinalised', 'isModifiable', 'lastUnlockedBy', 'longName', 'mutationDetails', 'name', 'seqDetails', 'smiles', 'smilesType', 'access', 'memopsRoot', 'naturalSource',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result = v; break

    return result
  
  def findFirstNameMappingStore(self, **conditions):
    """
    FindFirst for memops.Implementation.MemopsRoot.nameMappingStores
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = self
      root.refreshTopObjects('ccpnmr.NameMapping')
      currentValues = dataDict.get('nameMappingStores').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      objKey = conditions.get('name')
      if (objKey is not None):
        result = dataDict.get('nameMappingStores').get(objKey)
        if (result is None):
          root = self
          root.refreshTopObjects('ccpnmr.NameMapping')
          result = dataDict.get('nameMappingStores').get(objKey)

        if (result is None):
          return result

        elif (len(conditions) <= 1):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        root = self
        root.refreshTopObjects('ccpnmr.NameMapping')
        currentValues = dataDict.get('nameMappingStores').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('createdBy', 'guid', 'isModifiable', 'lastUnlockedBy', 'name', 'access', 'memopsRoot',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result = v; break

    return result
  
  def findFirstNmrCalcStore(self, **conditions):
    """
    FindFirst for memops.Implementation.MemopsRoot.nmrCalcStores
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = self
      root.refreshTopObjects('ccp.nmr.NmrCalc')
      currentValues = dataDict.get('nmrCalcStores').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      ll = list()
      objKey = conditions.get('nmrProjectName')
      ll.append(objKey)
      if (objKey is not None):
        objKey = conditions.get('name')
        ll.append(objKey)
        if (objKey is not None):
          objKey = tuple(ll)

      if (objKey is not None):
        result = dataDict.get('nmrCalcStores').get(objKey)
        if (result is None):
          root = self
          root.refreshTopObjects('ccp.nmr.NmrCalc')
          result = dataDict.get('nmrCalcStores').get(objKey)

        if (result is None):
          return result

        elif (len(conditions) <= 2):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        root = self
        root.refreshTopObjects('ccp.nmr.NmrCalc')
        currentValues = dataDict.get('nmrCalcStores').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('createdBy', 'guid', 'isModifiable', 'lastUnlockedBy', 'methodStoreName', 'name', 'nmrProjectName', 'softwareName', 'softwareVersion', 'validationStoreName', 'access', 'memopsRoot',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result = v; break

    return result
  
  def findFirstNmrConstraintStore(self, **conditions):
    """
    FindFirst for memops.Implementation.MemopsRoot.nmrConstraintStores
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = self
      root.refreshTopObjects('ccp.nmr.NmrConstraint')
      currentValues = dataDict.get('nmrConstraintStores').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      objKey = conditions.get('serial')
      if (objKey is not None):
        result = dataDict.get('nmrConstraintStores').get(objKey)
        if (result is None):
          root = self
          root.refreshTopObjects('ccp.nmr.NmrConstraint')
          result = dataDict.get('nmrConstraintStores').get(objKey)

        if (result is None):
          return result

        elif (len(conditions) <= 1):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        root = self
        root.refreshTopObjects('ccp.nmr.NmrConstraint')
        currentValues = dataDict.get('nmrConstraintStores').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('createdBy', 'guid', 'isModifiable', 'lastUnlockedBy', 'serial', 'access', 'memopsRoot', 'nmrProject',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result = v; break

    return result
  
  def findFirstNmrEntryStore(self, **conditions):
    """
    FindFirst for memops.Implementation.MemopsRoot.nmrEntryStores
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = self
      root.refreshTopObjects('ccp.nmr.NmrEntry')
      currentValues = dataDict.get('nmrEntryStores').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      objKey = conditions.get('name')
      if (objKey is not None):
        result = dataDict.get('nmrEntryStores').get(objKey)
        if (result is None):
          root = self
          root.refreshTopObjects('ccp.nmr.NmrEntry')
          result = dataDict.get('nmrEntryStores').get(objKey)

        if (result is None):
          return result

        elif (len(conditions) <= 1):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        root = self
        root.refreshTopObjects('ccp.nmr.NmrEntry')
        currentValues = dataDict.get('nmrEntryStores').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('createdBy', 'guid', 'isModifiable', 'lastUnlockedBy', 'name', 'access', 'memopsRoot',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result = v; break

    return result
  
  def findFirstNmrExpPrototype(self, **conditions):
    """
    FindFirst for memops.Implementation.MemopsRoot.nmrExpPrototypes
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = self
      root.refreshTopObjects('ccp.nmr.NmrExpPrototype')
      currentValues = dataDict.get('nmrExpPrototypes').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      objKey = conditions.get('serial')
      if (objKey is not None):
        result = dataDict.get('nmrExpPrototypes').get(objKey)
        if (result is None):
          root = self
          root.refreshTopObjects('ccp.nmr.NmrExpPrototype')
          result = dataDict.get('nmrExpPrototypes').get(objKey)

        if (result is None):
          return result

        elif (len(conditions) <= 1):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        root = self
        root.refreshTopObjects('ccp.nmr.NmrExpPrototype')
        currentValues = dataDict.get('nmrExpPrototypes').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('category', 'createdBy', 'details', 'guid', 'isModifiable', 'lastUnlockedBy', 'name', 'priority', 'serial', 'synonym', 'access', 'memopsRoot',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result = v; break

    return result
  
  def findFirstNmrProject(self, **conditions):
    """
    FindFirst for memops.Implementation.MemopsRoot.nmrProjects
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = self
      root.refreshTopObjects('ccp.nmr.Nmr')
      currentValues = dataDict.get('nmrProjects').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      objKey = conditions.get('name')
      if (objKey is not None):
        result = dataDict.get('nmrProjects').get(objKey)
        if (result is None):
          root = self
          root.refreshTopObjects('ccp.nmr.Nmr')
          result = dataDict.get('nmrProjects').get(objKey)

        if (result is None):
          return result

        elif (len(conditions) <= 1):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        root = self
        root.refreshTopObjects('ccp.nmr.Nmr')
        currentValues = dataDict.get('nmrProjects').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('createdBy', 'guid', 'isModifiable', 'lastUnlockedBy', 'name', 'access', 'analysisProject', 'memopsRoot',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result = v; break

    return result
  
  def findFirstNmrReferenceStore(self, **conditions):
    """
    FindFirst for memops.Implementation.MemopsRoot.nmrReferenceStores
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = self
      root.refreshTopObjects('ccp.nmr.NmrReference')
      currentValues = dataDict.get('nmrReferenceStores').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      ll = list()
      objKey = conditions.get('molType')
      ll.append(objKey)
      if (objKey is not None):
        objKey = conditions.get('ccpCode')
        ll.append(objKey)
        if (objKey is not None):
          objKey = tuple(ll)

      if (objKey is not None):
        result = dataDict.get('nmrReferenceStores').get(objKey)
        if (result is None):
          root = self
          root.refreshTopObjects('ccp.nmr.NmrReference')
          result = dataDict.get('nmrReferenceStores').get(objKey)

        if (result is None):
          return result

        elif (len(conditions) <= 2):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        root = self
        root.refreshTopObjects('ccp.nmr.NmrReference')
        currentValues = dataDict.get('nmrReferenceStores').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('ccpCode', 'createdBy', 'guid', 'isModifiable', 'lastUnlockedBy', 'molType', 'name', 'access', 'memopsRoot',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result = v; break

    return result
  
  def findFirstNmrScreenStore(self, **conditions):
    """
    FindFirst for memops.Implementation.MemopsRoot.nmrScreenStores
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = self
      root.refreshTopObjects('ccp.nmr.NmrScreen')
      currentValues = dataDict.get('nmrScreenStores').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      objKey = conditions.get('code')
      if (objKey is not None):
        result = dataDict.get('nmrScreenStores').get(objKey)
        if (result is None):
          root = self
          root.refreshTopObjects('ccp.nmr.NmrScreen')
          result = dataDict.get('nmrScreenStores').get(objKey)

        if (result is None):
          return result

        elif (len(conditions) <= 1):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        root = self
        root.refreshTopObjects('ccp.nmr.NmrScreen')
        currentValues = dataDict.get('nmrScreenStores').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('code', 'createdBy', 'guid', 'isModifiable', 'lastUnlockedBy', 'name', 'access', 'memopsRoot',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result = v; break

    return result
  
  def findFirstPackageLocator(self, **conditions):
    """
    FindFirst for memops.Implementation.MemopsRoot.packageLocators
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('packageLocators').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      objKey = conditions.get('targetName')
      if (objKey is not None):
        result = dataDict.get('packageLocators').get(objKey)
        if (result is None):
          result = dataDict.get('packageLocators').get(objKey)

        if (result is None):
          return result

        elif (len(conditions) <= 1):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        currentValues = dataDict.get('packageLocators').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('targetName', 'memopsRoot',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result = v; break

    return result
  
  def findFirstProtocolStore(self, **conditions):
    """
    FindFirst for memops.Implementation.MemopsRoot.protocolStores
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = self
      root.refreshTopObjects('ccp.lims.Protocol')
      currentValues = dataDict.get('protocolStores').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      objKey = conditions.get('name')
      if (objKey is not None):
        result = dataDict.get('protocolStores').get(objKey)
        if (result is None):
          root = self
          root.refreshTopObjects('ccp.lims.Protocol')
          result = dataDict.get('protocolStores').get(objKey)

        if (result is None):
          return result

        elif (len(conditions) <= 1):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        root = self
        root.refreshTopObjects('ccp.lims.Protocol')
        currentValues = dataDict.get('protocolStores').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('createdBy', 'guid', 'isModifiable', 'lastUnlockedBy', 'name', 'access', 'memopsRoot',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result = v; break

    return result
  
  def findFirstRefSampleComponentStore(self, **conditions):
    """
    FindFirst for memops.Implementation.MemopsRoot.refSampleComponentStores
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = self
      root.refreshTopObjects('ccp.lims.RefSampleComponent')
      currentValues = dataDict.get('refSampleComponentStores').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      objKey = conditions.get('name')
      if (objKey is not None):
        result = dataDict.get('refSampleComponentStores').get(objKey)
        if (result is None):
          root = self
          root.refreshTopObjects('ccp.lims.RefSampleComponent')
          result = dataDict.get('refSampleComponentStores').get(objKey)

        if (result is None):
          return result

        elif (len(conditions) <= 1):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        root = self
        root.refreshTopObjects('ccp.lims.RefSampleComponent')
        currentValues = dataDict.get('refSampleComponentStores').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('createdBy', 'guid', 'isModifiable', 'lastUnlockedBy', 'name', 'access', 'memopsRoot',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result = v; break

    return result
  
  def findFirstRepository(self, **conditions):
    """
    FindFirst for memops.Implementation.MemopsRoot.repositories
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('repositories').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      objKey = conditions.get('name')
      if (objKey is not None):
        result = dataDict.get('repositories').get(objKey)
        if (result is None):
          result = dataDict.get('repositories').get(objKey)

        if (result is None):
          return result

        elif (len(conditions) <= 1):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        currentValues = dataDict.get('repositories').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('format', 'name', 'url', 'memopsRoot',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result = v; break

    return result
  
  def findFirstSampleStore(self, **conditions):
    """
    FindFirst for memops.Implementation.MemopsRoot.sampleStores
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = self
      root.refreshTopObjects('ccp.lims.Sample')
      currentValues = dataDict.get('sampleStores').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      objKey = conditions.get('name')
      if (objKey is not None):
        result = dataDict.get('sampleStores').get(objKey)
        if (result is None):
          root = self
          root.refreshTopObjects('ccp.lims.Sample')
          result = dataDict.get('sampleStores').get(objKey)

        if (result is None):
          return result

        elif (len(conditions) <= 1):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        root = self
        root.refreshTopObjects('ccp.lims.Sample')
        currentValues = dataDict.get('sampleStores').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('createdBy', 'guid', 'isModifiable', 'lastUnlockedBy', 'name', 'access', 'memopsRoot',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result = v; break

    return result
  
  def findFirstStereochemistryStore(self, **conditions):
    """
    FindFirst for memops.Implementation.MemopsRoot.stereochemistryStores
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = self
      root.refreshTopObjects('ccp.molecule.Stereochemistry')
      currentValues = dataDict.get('stereochemistryStores').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      objKey = conditions.get('name')
      if (objKey is not None):
        result = dataDict.get('stereochemistryStores').get(objKey)
        if (result is None):
          root = self
          root.refreshTopObjects('ccp.molecule.Stereochemistry')
          result = dataDict.get('stereochemistryStores').get(objKey)

        if (result is None):
          return result

        elif (len(conditions) <= 1):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        root = self
        root.refreshTopObjects('ccp.molecule.Stereochemistry')
        currentValues = dataDict.get('stereochemistryStores').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('createdBy', 'guid', 'isModifiable', 'lastUnlockedBy', 'name', 'access', 'memopsRoot',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result = v; break

    return result
  
  def findFirstStructureEnsemble(self, **conditions):
    """
    FindFirst for memops.Implementation.MemopsRoot.structureEnsembles
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = self
      root.refreshTopObjects('ccp.molecule.MolStructure')
      currentValues = dataDict.get('structureEnsembles').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      ll = list()
      objKey = conditions.get('molSystem')
      ll.append(objKey)
      if (objKey is not None):
        objKey = conditions.get('ensembleId')
        ll.append(objKey)
        if (objKey is not None):
          objKey = tuple(ll)

      if (objKey is not None):
        result = dataDict.get('structureEnsembles').get(objKey)
        if (result is None):
          root = self
          root.refreshTopObjects('ccp.molecule.MolStructure')
          result = dataDict.get('structureEnsembles').get(objKey)

        if (result is None):
          return result

        elif (len(conditions) <= 2):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        root = self
        root.refreshTopObjects('ccp.molecule.MolStructure')
        currentValues = dataDict.get('structureEnsembles').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('atomNamingSystem', 'createdBy', 'details', 'ensembleId', 'guid', 'isModifiable', 'lastUnlockedBy', 'resNamingSystem', 'access', 'memopsRoot', 'molSystem', 'structureGeneration',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result = v; break

    return result
  
  def findFirstTargetStore(self, **conditions):
    """
    FindFirst for memops.Implementation.MemopsRoot.targetStores
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = self
      root.refreshTopObjects('ccp.lims.Target')
      currentValues = dataDict.get('targetStores').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      objKey = conditions.get('name')
      if (objKey is not None):
        result = dataDict.get('targetStores').get(objKey)
        if (result is None):
          root = self
          root.refreshTopObjects('ccp.lims.Target')
          result = dataDict.get('targetStores').get(objKey)

        if (result is None):
          return result

        elif (len(conditions) <= 1):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        root = self
        root.refreshTopObjects('ccp.lims.Target')
        currentValues = dataDict.get('targetStores').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('createdBy', 'guid', 'isModifiable', 'lastUnlockedBy', 'name', 'access', 'memopsRoot',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result = v; break

    return result
  
  def findFirstTaxonomy(self, **conditions):
    """
    FindFirst for memops.Implementation.MemopsRoot.taxonomies
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = self
      root.refreshTopObjects('ccp.general.Taxonomy')
      currentValues = dataDict.get('taxonomies').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      objKey = conditions.get('name')
      if (objKey is not None):
        result = dataDict.get('taxonomies').get(objKey)
        if (result is None):
          root = self
          root.refreshTopObjects('ccp.general.Taxonomy')
          result = dataDict.get('taxonomies').get(objKey)

        if (result is None):
          return result

        elif (len(conditions) <= 1):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        root = self
        root.refreshTopObjects('ccp.general.Taxonomy')
        currentValues = dataDict.get('taxonomies').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('createdBy', 'guid', 'isModifiable', 'lastUnlockedBy', 'name', 'access', 'memopsRoot',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result = v; break

    return result
  
  def findFirstTopObject(self, **conditions):
    """
    FindFirst for memops.Implementation.MemopsRoot.topObjects
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = self.getTopObjects()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      currentValues = set(x for x in dataDict.get('topObjects').values() if not x.isDeleted)
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('createdBy', 'guid', 'isModifiable', 'lastUnlockedBy', 'access', 'memopsRoot',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result = v; break

    return result
  
  def findFirstValidationStore(self, **conditions):
    """
    FindFirst for memops.Implementation.MemopsRoot.validationStores
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      root = self
      root.refreshTopObjects('ccp.molecule.Validation')
      currentValues = dataDict.get('validationStores').values()
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      objKey = conditions.get('name')
      if (objKey is not None):
        result = dataDict.get('validationStores').get(objKey)
        if (result is None):
          root = self
          root.refreshTopObjects('ccp.molecule.Validation')
          result = dataDict.get('validationStores').get(objKey)

        if (result is None):
          return result

        elif (len(conditions) <= 1):
          return result

        else:
          currentValues = set()
          currentValues.add(result)

      else:
        root = self
        root.refreshTopObjects('ccp.molecule.Validation')
        currentValues = dataDict.get('validationStores').values()

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('createdBy', 'guid', 'isModifiable', 'lastUnlockedBy', 'name', 'access', 'memopsRoot', 'nmrConstraintStore', 'nmrProject', 'software', 'structureEnsemble',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result = v; break

    return result
  
  def get(self, name):
    """
    GetAttr for memops.Implementation.MemopsRoot
    """
    dataDict = self.__dict__
    return getattr(self, name)
  
  def getAccessControlOn(self):
    """
    Get for memops.Implementation.MemopsRoot.accessControlOn
    """
    dataDict = self.__dict__
    result = dataDict.get('accessControlOn')
    return result
  
  def getAccessControlStores(self):
    """
    Get for memops.Implementation.MemopsRoot.accessControlStores
    """
    dataDict = self.__dict__
    root = self
    root.refreshTopObjects('memops.AccessControl')
    tempVar = dataDict.get('accessControlStores').values()
    result = frozenset(tempVar)
    return result
  
  def getActiveRepositories(self):
    """
    Get for memops.Implementation.MemopsRoot.activeRepositories
    """
    dataDict = self.__dict__
    result = dataDict.get('activeRepositories')
    result = tuple(result)
    return result
  
  def getAffiliationStores(self):
    """
    Get for memops.Implementation.MemopsRoot.affiliationStores
    """
    dataDict = self.__dict__
    root = self
    root.refreshTopObjects('ccp.general.Affiliation')
    tempVar = dataDict.get('affiliationStores').values()
    result = frozenset(tempVar)
    return result
  
  def getAnalysisProfiles(self):
    """
    Get for memops.Implementation.MemopsRoot.analysisProfiles
    """
    dataDict = self.__dict__
    root = self
    root.refreshTopObjects('ccpnmr.AnalysisProfile')
    tempVar = dataDict.get('analysisProfiles').values()
    result = frozenset(tempVar)
    return result
  
  def getAnalysisProjects(self):
    """
    Get for memops.Implementation.MemopsRoot.analysisProjects
    """
    dataDict = self.__dict__
    root = self
    root.refreshTopObjects('ccpnmr.Analysis')
    tempVar = dataDict.get('analysisProjects').values()
    result = frozenset(tempVar)
    return result
  
  def getAnnealProtocolStores(self):
    """
    Get for memops.Implementation.MemopsRoot.annealProtocolStores
    """
    dataDict = self.__dict__
    root = self
    root.refreshTopObjects('molsim.AnnealProtocol')
    tempVar = dataDict.get('annealProtocolStores').values()
    result = frozenset(tempVar)
    return result
  
  def getAnnotationStores(self):
    """
    Get for memops.Implementation.MemopsRoot.annotationStores
    """
    dataDict = self.__dict__
    root = self
    root.refreshTopObjects('ccp.general.Annotation')
    tempVar = dataDict.get('annotationStores').values()
    result = frozenset(tempVar)
    return result

  getByNavigation = MemopsObject.getByNavigation
  
  def getChemCompCharges(self):
    """
    Get for memops.Implementation.MemopsRoot.chemCompCharges
    """
    dataDict = self.__dict__
    root = self
    root.refreshTopObjects('ccp.molecule.ChemCompCharge')
    tempVar = dataDict.get('chemCompCharges').values()
    result = frozenset(tempVar)
    return result
  
  def getChemCompCoords(self):
    """
    Get for memops.Implementation.MemopsRoot.chemCompCoords
    """
    dataDict = self.__dict__
    root = self
    root.refreshTopObjects('ccp.molecule.ChemCompCoord')
    tempVar = dataDict.get('chemCompCoords').values()
    result = frozenset(tempVar)
    return result
  
  def getChemComps(self):
    """
    Get for memops.Implementation.MemopsRoot.chemComps
    """
    dataDict = self.__dict__
    root = self
    root.refreshTopObjects('ccp.molecule.ChemComp')
    tempVar = dataDict.get('chemComps').values()
    result = frozenset(tempVar)
    return result
  
  def getChemElementStores(self):
    """
    Get for memops.Implementation.MemopsRoot.chemElementStores
    """
    dataDict = self.__dict__
    root = self
    root.refreshTopObjects('ccp.molecule.ChemElement')
    tempVar = dataDict.get('chemElementStores').values()
    result = frozenset(tempVar)
    return result
  
  def getCitationStores(self):
    """
    Get for memops.Implementation.MemopsRoot.citationStores
    """
    dataDict = self.__dict__
    root = self
    root.refreshTopObjects('ccp.general.Citation')
    tempVar = dataDict.get('citationStores').values()
    result = frozenset(tempVar)
    return result

  getClassName = ComplexDataType.getClassName
  
  def getClassifications(self):
    """
    Get for memops.Implementation.MemopsRoot.classifications
    """
    dataDict = self.__dict__
    root = self
    root.refreshTopObjects('ccp.lims.Classification')
    tempVar = dataDict.get('classifications').values()
    result = frozenset(tempVar)
    return result
  
  def getCreatedBy(self):
    """
    Get for memops.Implementation.MemopsRoot.createdBy
    """
    dataDict = self.__dict__
    result = dataDict.get('createdBy')
    return result
  
  def getCrystallizationStores(self):
    """
    Get for memops.Implementation.MemopsRoot.crystallizationStores
    """
    dataDict = self.__dict__
    root = self
    root.refreshTopObjects('ccp.lims.Crystallization')
    tempVar = dataDict.get('crystallizationStores').values()
    result = frozenset(tempVar)
    return result
  
  def getCurrentAccessControlStore(self):
    """
    Get for memops.Implementation.MemopsRoot.currentAccessControlStore
    """
    dataDict = self.__dict__
    
    result = dataDict.get('currentAccessControlStore')
    if result is None:
      self.findFirstAccessControlStore()
      result = dataDict.get('currentAccessControlStore')
    return result
  
  def getCurrentAffiliationStore(self):
    """
    Get for memops.Implementation.MemopsRoot.currentAffiliationStore
    """
    dataDict = self.__dict__
    
    result = dataDict.get('currentAffiliationStore')
    if result is None:
      self.findFirstAffiliationStore()
      result = dataDict.get('currentAffiliationStore')
    return result
  
  def getCurrentAnalysisProfile(self):
    """
    Get for memops.Implementation.MemopsRoot.currentAnalysisProfile
    """
    dataDict = self.__dict__
    
    result = dataDict.get('currentAnalysisProfile')
    if result is None:
      self.findFirstAnalysisProfile()
      result = dataDict.get('currentAnalysisProfile')
    return result
  
  def getCurrentAnalysisProject(self):
    """
    Get for memops.Implementation.MemopsRoot.currentAnalysisProject
    """
    dataDict = self.__dict__
    
    result = dataDict.get('currentAnalysisProject')
    if result is None:
      self.findFirstAnalysisProject()
      result = dataDict.get('currentAnalysisProject')
    return result
  
  def getCurrentAnnealProtocolStore(self):
    """
    Get for memops.Implementation.MemopsRoot.currentAnnealProtocolStore
    """
    dataDict = self.__dict__
    
    result = dataDict.get('currentAnnealProtocolStore')
    if result is None:
      self.findFirstAnnealProtocolStore()
      result = dataDict.get('currentAnnealProtocolStore')
    return result
  
  def getCurrentAnnotationStore(self):
    """
    Get for memops.Implementation.MemopsRoot.currentAnnotationStore
    """
    dataDict = self.__dict__
    
    result = dataDict.get('currentAnnotationStore')
    if result is None:
      self.findFirstAnnotationStore()
      result = dataDict.get('currentAnnotationStore')
    return result
  
  def getCurrentChemComp(self):
    """
    Get for memops.Implementation.MemopsRoot.currentChemComp
    """
    dataDict = self.__dict__
    
    result = dataDict.get('currentChemComp')
    if result is None:
      self.findFirstChemComp()
      result = dataDict.get('currentChemComp')
    return result
  
  def getCurrentChemCompCharge(self):
    """
    Get for memops.Implementation.MemopsRoot.currentChemCompCharge
    """
    dataDict = self.__dict__
    
    result = dataDict.get('currentChemCompCharge')
    if result is None:
      self.findFirstChemCompCharge()
      result = dataDict.get('currentChemCompCharge')
    return result
  
  def getCurrentChemCompCoord(self):
    """
    Get for memops.Implementation.MemopsRoot.currentChemCompCoord
    """
    dataDict = self.__dict__
    
    result = dataDict.get('currentChemCompCoord')
    if result is None:
      self.findFirstChemCompCoord()
      result = dataDict.get('currentChemCompCoord')
    return result
  
  def getCurrentChemElementStore(self):
    """
    Get for memops.Implementation.MemopsRoot.currentChemElementStore
    """
    dataDict = self.__dict__
    
    result = dataDict.get('currentChemElementStore')
    if result is None:
      self.findFirstChemElementStore()
      result = dataDict.get('currentChemElementStore')
    return result
  
  def getCurrentCitationStore(self):
    """
    Get for memops.Implementation.MemopsRoot.currentCitationStore
    """
    dataDict = self.__dict__
    
    result = dataDict.get('currentCitationStore')
    if result is None:
      self.findFirstCitationStore()
      result = dataDict.get('currentCitationStore')
    return result
  
  def getCurrentClassification(self):
    """
    Get for memops.Implementation.MemopsRoot.currentClassification
    """
    dataDict = self.__dict__
    
    result = dataDict.get('currentClassification')
    if result is None:
      self.findFirstClassification()
      result = dataDict.get('currentClassification')
    return result
  
  def getCurrentCrystallizationStore(self):
    """
    Get for memops.Implementation.MemopsRoot.currentCrystallizationStore
    """
    dataDict = self.__dict__
    
    result = dataDict.get('currentCrystallizationStore')
    if result is None:
      self.findFirstCrystallizationStore()
      result = dataDict.get('currentCrystallizationStore')
    return result
  
  def getCurrentDangleStore(self):
    """
    Get for memops.Implementation.MemopsRoot.currentDangleStore
    """
    dataDict = self.__dict__
    
    result = dataDict.get('currentDangleStore')
    if result is None:
      self.findFirstDangleStore()
      result = dataDict.get('currentDangleStore')
    return result
  
  def getCurrentDataLocationStore(self):
    """
    Get for memops.Implementation.MemopsRoot.currentDataLocationStore
    """
    dataDict = self.__dict__
    
    result = dataDict.get('currentDataLocationStore')
    if result is None:
      self.findFirstDataLocationStore()
      result = dataDict.get('currentDataLocationStore')
    return result
  
  def getCurrentDatabase(self):
    """
    Get for memops.Implementation.MemopsRoot.currentDatabase
    """
    dataDict = self.__dict__
    
    result = dataDict.get('currentDatabase')
    if result is None:
      self.findFirstDatabase()
      result = dataDict.get('currentDatabase')
    return result
  
  def getCurrentExpBlueprintStore(self):
    """
    Get for memops.Implementation.MemopsRoot.currentExpBlueprintStore
    """
    dataDict = self.__dict__
    
    result = dataDict.get('currentExpBlueprintStore')
    if result is None:
      self.findFirstExpBlueprintStore()
      result = dataDict.get('currentExpBlueprintStore')
    return result
  
  def getCurrentExperimentStore(self):
    """
    Get for memops.Implementation.MemopsRoot.currentExperimentStore
    """
    dataDict = self.__dict__
    
    result = dataDict.get('currentExperimentStore')
    if result is None:
      self.findFirstExperimentStore()
      result = dataDict.get('currentExperimentStore')
    return result
  
  def getCurrentGroupName(self):
    """
    Get for memops.Implementation.MemopsRoot.currentGroupName
    """
    dataDict = self.__dict__
    result = dataDict.get('currentGroupName')
    return result
  
  def getCurrentHaddockProject(self):
    """
    Get for memops.Implementation.MemopsRoot.currentHaddockProject
    """
    dataDict = self.__dict__
    
    result = dataDict.get('currentHaddockProject')
    if result is None:
      self.findFirstHaddockProject()
      result = dataDict.get('currentHaddockProject')
    return result
  
  def getCurrentHolderStore(self):
    """
    Get for memops.Implementation.MemopsRoot.currentHolderStore
    """
    dataDict = self.__dict__
    
    result = dataDict.get('currentHolderStore')
    if result is None:
      self.findFirstHolderStore()
      result = dataDict.get('currentHolderStore')
    return result
  
  def getCurrentInstrumentStore(self):
    """
    Get for memops.Implementation.MemopsRoot.currentInstrumentStore
    """
    dataDict = self.__dict__
    
    result = dataDict.get('currentInstrumentStore')
    if result is None:
      self.findFirstInstrumentStore()
      result = dataDict.get('currentInstrumentStore')
    return result
  
  def getCurrentKeywordDefinitionStore(self):
    """
    Get for memops.Implementation.MemopsRoot.currentKeywordDefinitionStore
    """
    dataDict = self.__dict__
    
    result = dataDict.get('currentKeywordDefinitionStore')
    if result is None:
      self.findFirstKeywordDefinitionStore()
      result = dataDict.get('currentKeywordDefinitionStore')
    return result
  
  def getCurrentLabeledMolecule(self):
    """
    Get for memops.Implementation.MemopsRoot.currentLabeledMolecule
    """
    dataDict = self.__dict__
    
    result = dataDict.get('currentLabeledMolecule')
    if result is None:
      self.findFirstLabeledMolecule()
      result = dataDict.get('currentLabeledMolecule')
    return result
  
  def getCurrentLabelingScheme(self):
    """
    Get for memops.Implementation.MemopsRoot.currentLabelingScheme
    """
    dataDict = self.__dict__
    
    result = dataDict.get('currentLabelingScheme')
    if result is None:
      self.findFirstLabelingScheme()
      result = dataDict.get('currentLabelingScheme')
    return result
  
  def getCurrentLocationStore(self):
    """
    Get for memops.Implementation.MemopsRoot.currentLocationStore
    """
    dataDict = self.__dict__
    
    result = dataDict.get('currentLocationStore')
    if result is None:
      self.findFirstLocationStore()
      result = dataDict.get('currentLocationStore')
    return result
  
  def getCurrentMethodStore(self):
    """
    Get for memops.Implementation.MemopsRoot.currentMethodStore
    """
    dataDict = self.__dict__
    
    result = dataDict.get('currentMethodStore')
    if result is None:
      self.findFirstMethodStore()
      result = dataDict.get('currentMethodStore')
    return result
  
  def getCurrentMolSystem(self):
    """
    Get for memops.Implementation.MemopsRoot.currentMolSystem
    """
    dataDict = self.__dict__
    
    result = dataDict.get('currentMolSystem')
    if result is None:
      self.findFirstMolSystem()
      result = dataDict.get('currentMolSystem')
    return result
  
  def getCurrentMolSystemSymmetrySet(self):
    """
    Get for memops.Implementation.MemopsRoot.currentMolSystemSymmetrySet
    """
    dataDict = self.__dict__
    
    result = dataDict.get('currentMolSystemSymmetrySet')
    if result is None:
      self.findFirstMolSystemSymmetrySet()
      result = dataDict.get('currentMolSystemSymmetrySet')
    return result
  
  def getCurrentMolecule(self):
    """
    Get for memops.Implementation.MemopsRoot.currentMolecule
    """
    dataDict = self.__dict__
    
    result = dataDict.get('currentMolecule')
    if result is None:
      self.findFirstMolecule()
      result = dataDict.get('currentMolecule')
    return result
  
  def getCurrentNameMappingStore(self):
    """
    Get for memops.Implementation.MemopsRoot.currentNameMappingStore
    """
    dataDict = self.__dict__
    
    result = dataDict.get('currentNameMappingStore')
    if result is None:
      self.findFirstNameMappingStore()
      result = dataDict.get('currentNameMappingStore')
    return result
  
  def getCurrentNmrCalcStore(self):
    """
    Get for memops.Implementation.MemopsRoot.currentNmrCalcStore
    """
    dataDict = self.__dict__
    
    result = dataDict.get('currentNmrCalcStore')
    if result is None:
      self.findFirstNmrCalcStore()
      result = dataDict.get('currentNmrCalcStore')
    return result
  
  def getCurrentNmrConstraintStore(self):
    """
    Get for memops.Implementation.MemopsRoot.currentNmrConstraintStore
    """
    dataDict = self.__dict__
    
    result = dataDict.get('currentNmrConstraintStore')
    if result is None:
      self.findFirstNmrConstraintStore()
      result = dataDict.get('currentNmrConstraintStore')
    return result
  
  def getCurrentNmrEntryStore(self):
    """
    Get for memops.Implementation.MemopsRoot.currentNmrEntryStore
    """
    dataDict = self.__dict__
    
    result = dataDict.get('currentNmrEntryStore')
    if result is None:
      self.findFirstNmrEntryStore()
      result = dataDict.get('currentNmrEntryStore')
    return result
  
  def getCurrentNmrExpPrototype(self):
    """
    Get for memops.Implementation.MemopsRoot.currentNmrExpPrototype
    """
    dataDict = self.__dict__
    
    result = dataDict.get('currentNmrExpPrototype')
    if result is None:
      self.findFirstNmrExpPrototype()
      result = dataDict.get('currentNmrExpPrototype')
    return result
  
  def getCurrentNmrProject(self):
    """
    Get for memops.Implementation.MemopsRoot.currentNmrProject
    """
    dataDict = self.__dict__
    
    result = dataDict.get('currentNmrProject')
    if result is None:
      self.findFirstNmrProject()
      result = dataDict.get('currentNmrProject')
    return result
  
  def getCurrentNmrReferenceStore(self):
    """
    Get for memops.Implementation.MemopsRoot.currentNmrReferenceStore
    """
    dataDict = self.__dict__
    
    result = dataDict.get('currentNmrReferenceStore')
    if result is None:
      self.findFirstNmrReferenceStore()
      result = dataDict.get('currentNmrReferenceStore')
    return result
  
  def getCurrentNmrScreenStore(self):
    """
    Get for memops.Implementation.MemopsRoot.currentNmrScreenStore
    """
    dataDict = self.__dict__
    
    result = dataDict.get('currentNmrScreenStore')
    if result is None:
      self.findFirstNmrScreenStore()
      result = dataDict.get('currentNmrScreenStore')
    return result
  
  def getCurrentProtocolStore(self):
    """
    Get for memops.Implementation.MemopsRoot.currentProtocolStore
    """
    dataDict = self.__dict__
    
    result = dataDict.get('currentProtocolStore')
    if result is None:
      self.findFirstProtocolStore()
      result = dataDict.get('currentProtocolStore')
    return result
  
  def getCurrentRefSampleComponentStore(self):
    """
    Get for memops.Implementation.MemopsRoot.currentRefSampleComponentStore
    """
    dataDict = self.__dict__
    
    result = dataDict.get('currentRefSampleComponentStore')
    if result is None:
      self.findFirstRefSampleComponentStore()
      result = dataDict.get('currentRefSampleComponentStore')
    return result
  
  def getCurrentSampleStore(self):
    """
    Get for memops.Implementation.MemopsRoot.currentSampleStore
    """
    dataDict = self.__dict__
    
    result = dataDict.get('currentSampleStore')
    if result is None:
      self.findFirstSampleStore()
      result = dataDict.get('currentSampleStore')
    return result
  
  def getCurrentStereochemistryStore(self):
    """
    Get for memops.Implementation.MemopsRoot.currentStereochemistryStore
    """
    dataDict = self.__dict__
    
    result = dataDict.get('currentStereochemistryStore')
    if result is None:
      self.findFirstStereochemistryStore()
      result = dataDict.get('currentStereochemistryStore')
    return result
  
  def getCurrentStructureEnsemble(self):
    """
    Get for memops.Implementation.MemopsRoot.currentStructureEnsemble
    """
    dataDict = self.__dict__
    
    result = dataDict.get('currentStructureEnsemble')
    if result is None:
      self.findFirstStructureEnsemble()
      result = dataDict.get('currentStructureEnsemble')
    return result
  
  def getCurrentTargetStore(self):
    """
    Get for memops.Implementation.MemopsRoot.currentTargetStore
    """
    dataDict = self.__dict__
    
    result = dataDict.get('currentTargetStore')
    if result is None:
      self.findFirstTargetStore()
      result = dataDict.get('currentTargetStore')
    return result
  
  def getCurrentTaxonomy(self):
    """
    Get for memops.Implementation.MemopsRoot.currentTaxonomy
    """
    dataDict = self.__dict__
    
    result = dataDict.get('currentTaxonomy')
    if result is None:
      self.findFirstTaxonomy()
      result = dataDict.get('currentTaxonomy')
    return result
  
  def getCurrentUserId(self):
    """
    Get for memops.Implementation.MemopsRoot.currentUserId
    """
    dataDict = self.__dict__
    result = dataDict.get('currentUserId')
    return result
  
  def getCurrentValidationStore(self):
    """
    Get for memops.Implementation.MemopsRoot.currentValidationStore
    """
    dataDict = self.__dict__
    
    result = dataDict.get('currentValidationStore')
    if result is None:
      self.findFirstValidationStore()
      result = dataDict.get('currentValidationStore')
    return result
  
  def getDangleStores(self):
    """
    Get for memops.Implementation.MemopsRoot.dangleStores
    """
    dataDict = self.__dict__
    root = self
    root.refreshTopObjects('cambridge.Dangle')
    tempVar = dataDict.get('dangleStores').values()
    result = frozenset(tempVar)
    return result
  
  def getDataLocationStores(self):
    """
    Get for memops.Implementation.MemopsRoot.dataLocationStores
    """
    dataDict = self.__dict__
    root = self
    root.refreshTopObjects('ccp.general.DataLocation')
    tempVar = dataDict.get('dataLocationStores').values()
    result = frozenset(tempVar)
    return result
  
  def getDatabases(self):
    """
    Get for memops.Implementation.MemopsRoot.databases
    """
    dataDict = self.__dict__
    root = self
    root.refreshTopObjects('ccp.general.DbRef')
    tempVar = dataDict.get('databases').values()
    result = frozenset(tempVar)
    return result
  
  def getExpBlueprintStores(self):
    """
    Get for memops.Implementation.MemopsRoot.expBlueprintStores
    """
    dataDict = self.__dict__
    root = self
    root.refreshTopObjects('ccp.lims.ExpBlueprint')
    tempVar = dataDict.get('expBlueprintStores').values()
    result = frozenset(tempVar)
    return result

  getExpandedKey = MemopsObject.getExpandedKey
  
  def getExperimentStores(self):
    """
    Get for memops.Implementation.MemopsRoot.experimentStores
    """
    dataDict = self.__dict__
    root = self
    root.refreshTopObjects('ccp.lims.Experiment')
    tempVar = dataDict.get('experimentStores').values()
    result = frozenset(tempVar)
    return result

  getFieldNames = ComplexDataType.getFieldNames
  
  def getFullKey(self, useGuid=False):
    """
    GetFullKey for memops.Implementation.MemopsRoot
    """
    dataDict = self.__dict__
    result = list()
    return result
  
  def getHaddockProjects(self):
    """
    Get for memops.Implementation.MemopsRoot.haddockProjects
    """
    dataDict = self.__dict__
    root = self
    root.refreshTopObjects('utrecht.Haddock')
    tempVar = dataDict.get('haddockProjects').values()
    result = frozenset(tempVar)
    return result
  
  def getHolderStores(self):
    """
    Get for memops.Implementation.MemopsRoot.holderStores
    """
    dataDict = self.__dict__
    root = self
    root.refreshTopObjects('ccp.lims.Holder')
    tempVar = dataDict.get('holderStores').values()
    result = frozenset(tempVar)
    return result

  getInConstructor = ComplexDataType.getInConstructor
  
  def getInstrumentStores(self):
    """
    Get for memops.Implementation.MemopsRoot.instrumentStores
    """
    dataDict = self.__dict__
    root = self
    root.refreshTopObjects('ccp.general.Instrument')
    tempVar = dataDict.get('instrumentStores').values()
    result = frozenset(tempVar)
    return result

  getIsDeleted = MemopsObject.getIsDeleted
  
  def getIsLoaded(self):
    """
    Get for memops.Implementation.MemopsRoot.isLoaded
    """
    dataDict = self.__dict__
    result = bool(dataDict.get('isLoaded'))
    return result
  
  def getIsModifiable(self):
    """
    Get for memops.Implementation.MemopsRoot.isModifiable
    """
    dataDict = self.__dict__
    result = dataDict.get('isModifiable')
    return result
  
  def getIsModified(self):
    """
    Get for memops.Implementation.MemopsRoot.isModified
    """
    dataDict = self.__dict__
    result = bool(dataDict.get('isModified'))
    return result
  
  def getIsReading(self):
    """
    Get for memops.Implementation.MemopsRoot.isReading
    """
    dataDict = self.__dict__
    result = bool(dataDict.get('isReading'))
    return result
  
  def getKeywordDefinitionStores(self):
    """
    Get for memops.Implementation.MemopsRoot.keywordDefinitionStores
    """
    dataDict = self.__dict__
    root = self
    root.refreshTopObjects('ccp.general.KeywordDefinition')
    tempVar = dataDict.get('keywordDefinitionStores').values()
    result = frozenset(tempVar)
    return result
  
  def getLabeledMolecules(self):
    """
    Get for memops.Implementation.MemopsRoot.labeledMolecules
    """
    dataDict = self.__dict__
    root = self
    root.refreshTopObjects('ccp.molecule.LabeledMolecule')
    tempVar = dataDict.get('labeledMolecules').values()
    result = frozenset(tempVar)
    return result
  
  def getLabelingSchemes(self):
    """
    Get for memops.Implementation.MemopsRoot.labelingSchemes
    """
    dataDict = self.__dict__
    root = self
    root.refreshTopObjects('ccp.molecule.ChemCompLabel')
    tempVar = dataDict.get('labelingSchemes').values()
    result = frozenset(tempVar)
    return result
  
  def getLastUnlockedBy(self):
    """
    Get for memops.Implementation.MemopsRoot.lastUnlockedBy
    """
    dataDict = self.__dict__
    result = dataDict.get('lastUnlockedBy')
    return result
  
  def getLocalKey(self):
    """
    GetLocalKey for memops.Implementation.MemopsRoot
    """
    dataDict = self.__dict__
    result = None
    return result
  
  def getLocationStores(self):
    """
    Get for memops.Implementation.MemopsRoot.locationStores
    """
    dataDict = self.__dict__
    root = self
    root.refreshTopObjects('ccp.lims.Location')
    tempVar = dataDict.get('locationStores').values()
    result = frozenset(tempVar)
    return result

  getMetaclass = ComplexDataType.getMetaclass
  
  def getMethodStores(self):
    """
    Get for memops.Implementation.MemopsRoot.methodStores
    """
    dataDict = self.__dict__
    root = self
    root.refreshTopObjects('ccp.general.Method')
    tempVar = dataDict.get('methodStores').values()
    result = frozenset(tempVar)
    return result
  
  def getMolSystemSymmetrySets(self):
    """
    Get for memops.Implementation.MemopsRoot.molSystemSymmetrySets
    """
    dataDict = self.__dict__
    root = self
    root.refreshTopObjects('molsim.Symmetry')
    tempVar = dataDict.get('molSystemSymmetrySets').values()
    result = frozenset(tempVar)
    return result
  
  def getMolSystems(self):
    """
    Get for memops.Implementation.MemopsRoot.molSystems
    """
    dataDict = self.__dict__
    root = self
    root.refreshTopObjects('ccp.molecule.MolSystem')
    tempVar = dataDict.get('molSystems').values()
    result = frozenset(tempVar)
    return result
  
  def getMolecules(self):
    """
    Get for memops.Implementation.MemopsRoot.molecules
    """
    dataDict = self.__dict__
    root = self
    root.refreshTopObjects('ccp.molecule.Molecule')
    tempVar = dataDict.get('molecules').values()
    result = frozenset(tempVar)
    return result
  
  def getName(self):
    """
    Get for memops.Implementation.MemopsRoot.name
    """
    dataDict = self.__dict__
    result = dataDict.get('name')
    return result
  
  def getNameMappingStores(self):
    """
    Get for memops.Implementation.MemopsRoot.nameMappingStores
    """
    dataDict = self.__dict__
    root = self
    root.refreshTopObjects('ccpnmr.NameMapping')
    tempVar = dataDict.get('nameMappingStores').values()
    result = frozenset(tempVar)
    return result
  
  def getNmrCalcStores(self):
    """
    Get for memops.Implementation.MemopsRoot.nmrCalcStores
    """
    dataDict = self.__dict__
    root = self
    root.refreshTopObjects('ccp.nmr.NmrCalc')
    tempVar = dataDict.get('nmrCalcStores').values()
    result = frozenset(tempVar)
    return result
  
  def getNmrConstraintStores(self):
    """
    Get for memops.Implementation.MemopsRoot.nmrConstraintStores
    """
    dataDict = self.__dict__
    root = self
    root.refreshTopObjects('ccp.nmr.NmrConstraint')
    tempVar = dataDict.get('nmrConstraintStores').values()
    result = frozenset(tempVar)
    return result
  
  def getNmrEntryStores(self):
    """
    Get for memops.Implementation.MemopsRoot.nmrEntryStores
    """
    dataDict = self.__dict__
    root = self
    root.refreshTopObjects('ccp.nmr.NmrEntry')
    tempVar = dataDict.get('nmrEntryStores').values()
    result = frozenset(tempVar)
    return result
  
  def getNmrExpPrototypes(self):
    """
    Get for memops.Implementation.MemopsRoot.nmrExpPrototypes
    """
    dataDict = self.__dict__
    root = self
    root.refreshTopObjects('ccp.nmr.NmrExpPrototype')
    tempVar = dataDict.get('nmrExpPrototypes').values()
    result = frozenset(tempVar)
    return result
  
  def getNmrProjects(self):
    """
    Get for memops.Implementation.MemopsRoot.nmrProjects
    """
    dataDict = self.__dict__
    root = self
    root.refreshTopObjects('ccp.nmr.Nmr')
    tempVar = dataDict.get('nmrProjects').values()
    result = frozenset(tempVar)
    return result
  
  def getNmrReferenceStores(self):
    """
    Get for memops.Implementation.MemopsRoot.nmrReferenceStores
    """
    dataDict = self.__dict__
    root = self
    root.refreshTopObjects('ccp.nmr.NmrReference')
    tempVar = dataDict.get('nmrReferenceStores').values()
    result = frozenset(tempVar)
    return result
  
  def getNmrScreenStores(self):
    """
    Get for memops.Implementation.MemopsRoot.nmrScreenStores
    """
    dataDict = self.__dict__
    root = self
    root.refreshTopObjects('ccp.nmr.NmrScreen')
    tempVar = dataDict.get('nmrScreenStores').values()
    result = frozenset(tempVar)
    return result
  
  def getOverride(self):
    """
    Get for memops.Implementation.MemopsRoot.override
    """
    dataDict = self.__dict__
    result = dataDict.get('override')
    return result
  
  def getPackageLocator(self):
    """
    getter for derived link packageLocator
    """
    dataDict = self.__dict__
    ff = self.findFirstPackageLocator
    result = ff(targetName=self.packageName) or ff(targetName='any')
    return result
  
  def getPackageLocators(self):
    """
    Get for memops.Implementation.MemopsRoot.packageLocators
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('packageLocators').values()
    result = frozenset(tempVar)
    return result

  getPackageName = ComplexDataType.getPackageName

  getPackageShortName = ComplexDataType.getPackageShortName
  
  def getParent(self):
    """
    Get for memops.Implementation.MemopsRoot.parent
    """
    dataDict = self.__dict__
    result = None
    return result
  
  def getProtocolStores(self):
    """
    Get for memops.Implementation.MemopsRoot.protocolStores
    """
    dataDict = self.__dict__
    root = self
    root.refreshTopObjects('ccp.lims.Protocol')
    tempVar = dataDict.get('protocolStores').values()
    result = frozenset(tempVar)
    return result

  getQualifiedName = ComplexDataType.getQualifiedName
  
  def getRefSampleComponentStores(self):
    """
    Get for memops.Implementation.MemopsRoot.refSampleComponentStores
    """
    dataDict = self.__dict__
    root = self
    root.refreshTopObjects('ccp.lims.RefSampleComponent')
    tempVar = dataDict.get('refSampleComponentStores').values()
    result = frozenset(tempVar)
    return result
  
  def getRepositories(self):
    """
    Get for memops.Implementation.MemopsRoot.repositories
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('repositories').values()
    result = frozenset(tempVar)
    return result

  getRoot = MemopsObject.getRoot
  
  def getSampleStores(self):
    """
    Get for memops.Implementation.MemopsRoot.sampleStores
    """
    dataDict = self.__dict__
    root = self
    root.refreshTopObjects('ccp.lims.Sample')
    tempVar = dataDict.get('sampleStores').values()
    result = frozenset(tempVar)
    return result
  
  def getStereochemistryStores(self):
    """
    Get for memops.Implementation.MemopsRoot.stereochemistryStores
    """
    dataDict = self.__dict__
    root = self
    root.refreshTopObjects('ccp.molecule.Stereochemistry')
    tempVar = dataDict.get('stereochemistryStores').values()
    result = frozenset(tempVar)
    return result
  
  def getStructureEnsembles(self):
    """
    Get for memops.Implementation.MemopsRoot.structureEnsembles
    """
    dataDict = self.__dict__
    root = self
    root.refreshTopObjects('ccp.molecule.MolStructure')
    tempVar = dataDict.get('structureEnsembles').values()
    result = frozenset(tempVar)
    return result
  
  def getTargetStores(self):
    """
    Get for memops.Implementation.MemopsRoot.targetStores
    """
    dataDict = self.__dict__
    root = self
    root.refreshTopObjects('ccp.lims.Target')
    tempVar = dataDict.get('targetStores').values()
    result = frozenset(tempVar)
    return result
  
  def getTaxonomies(self):
    """
    Get for memops.Implementation.MemopsRoot.taxonomies
    """
    dataDict = self.__dict__
    root = self
    root.refreshTopObjects('ccp.general.Taxonomy')
    tempVar = dataDict.get('taxonomies').values()
    result = frozenset(tempVar)
    return result

  getTopObject = ImplementationObject.getTopObject
  
  def getTopObjects(self):
    """
    Get for memops.Implementation.MemopsRoot.topObjects
    """
    dataDict = self.__dict__
    result = set(x for x in dataDict.get('topObjects').values() if not x.isDeleted)
    result = frozenset(result)
    return result
  
  def getValidationStores(self):
    """
    Get for memops.Implementation.MemopsRoot.validationStores
    """
    dataDict = self.__dict__
    root = self
    root.refreshTopObjects('ccp.molecule.Validation')
    tempVar = dataDict.get('validationStores').values()
    result = frozenset(tempVar)
    return result
  
  def importData(self, filePath):
    """
    Load data from file, without triggering any other loads. If the guid or
    code of the file TopObject are already in memory you will get an error. 
    The loaded file will be saved in the first repository on the search 
    path, overriding anything that might be there already
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.importData:
       called on deleted object""" % self.qualifiedName
      )

    from memops.format.xml import XmlIO
    result = XmlIO.loadFromFile(self, filePath)
    # set to modified, as the loaded version may not come from the topmost repository
    result.__dict__['isModified'] = True
    
    # Fix activeRepositories - NB must be done bypassing API
    useRepository = result.packageLocator.findFirstRepository()
    activeRepositories = dataDict.get('activeRepositories')
    if not useRepository in activeRepositories:
      activeRepositories.insert(0, useRepository)
    return result
  
  def newAccessControlStore(self, **attrlinks):
    """
    Factory function to create memops.AccessControl.AccessControlStore
    """
    from memops.api.AccessControl import AccessControlStore
    return AccessControlStore(self, **attrlinks)
  
  def newAffiliationStore(self, **attrlinks):
    """
    Factory function to create ccp.general.Affiliation.AffiliationStore
    """
    from ccp.api.general.Affiliation import AffiliationStore
    return AffiliationStore(self, **attrlinks)
  
  def newAnalysisProfile(self, **attrlinks):
    """
    Factory function to create ccpnmr.AnalysisProfile.AnalysisProfile
    """
    from ccpnmr.api.AnalysisProfile import AnalysisProfile
    return AnalysisProfile(self, **attrlinks)
  
  def newAnalysisProject(self, **attrlinks):
    """
    Factory function to create ccpnmr.Analysis.AnalysisProject
    """
    from ccpnmr.api.Analysis import AnalysisProject
    return AnalysisProject(self, **attrlinks)
  
  def newAnnealProtocolStore(self, **attrlinks):
    """
    Factory function to create molsim.AnnealProtocol.AnnealProtocolStore
    """
    from molsim.api.AnnealProtocol import AnnealProtocolStore
    return AnnealProtocolStore(self, **attrlinks)
  
  def newAnnotationStore(self, **attrlinks):
    """
    Factory function to create ccp.general.Annotation.AnnotationStore
    """
    from ccp.api.general.Annotation import AnnotationStore
    return AnnotationStore(self, **attrlinks)
  
  def newChemCompCharge(self, **attrlinks):
    """
    Factory function to create ccp.molecule.ChemCompCharge.ChemCompCharge
    """
    from ccp.api.molecule.ChemCompCharge import ChemCompCharge
    return ChemCompCharge(self, **attrlinks)
  
  def newChemCompCoord(self, **attrlinks):
    """
    Factory function to create ccp.molecule.ChemCompCoord.ChemCompCoord
    """
    from ccp.api.molecule.ChemCompCoord import ChemCompCoord
    return ChemCompCoord(self, **attrlinks)
  
  def newChemElementStore(self, **attrlinks):
    """
    Factory function to create ccp.molecule.ChemElement.ChemElementStore
    """
    from ccp.api.molecule.ChemElement import ChemElementStore
    return ChemElementStore(self, **attrlinks)
  
  def newCitationStore(self, **attrlinks):
    """
    Factory function to create ccp.general.Citation.CitationStore
    """
    from ccp.api.general.Citation import CitationStore
    return CitationStore(self, **attrlinks)
  
  def newClassification(self, **attrlinks):
    """
    Factory function to create ccp.lims.Classification.Classification
    """
    from ccp.api.lims.Classification import Classification
    return Classification(self, **attrlinks)
  
  def newCrystallizationStore(self, **attrlinks):
    """
    Factory function to create ccp.lims.Crystallization.CrystallizationStore
    """
    from ccp.api.lims.Crystallization import CrystallizationStore
    return CrystallizationStore(self, **attrlinks)
  
  def newDangleStore(self, **attrlinks):
    """
    Factory function to create cambridge.Dangle.DangleStore
    """
    from cambridge.api.Dangle import DangleStore
    return DangleStore(self, **attrlinks)
  
  def newDataLocationStore(self, **attrlinks):
    """
    Factory function to create ccp.general.DataLocation.DataLocationStore
    """
    from ccp.api.general.DataLocation import DataLocationStore
    return DataLocationStore(self, **attrlinks)
  
  def newDatabase(self, **attrlinks):
    """
    Factory function to create ccp.general.DbRef.Database
    """
    from ccp.api.general.DbRef import Database
    return Database(self, **attrlinks)
  
  def newExpBlueprintStore(self, **attrlinks):
    """
    Factory function to create ccp.lims.ExpBlueprint.ExpBlueprintStore
    """
    from ccp.api.lims.ExpBlueprint import ExpBlueprintStore
    return ExpBlueprintStore(self, **attrlinks)
  
  def newExperimentStore(self, **attrlinks):
    """
    Factory function to create ccp.lims.Experiment.ExperimentStore
    """
    from ccp.api.lims.Experiment import ExperimentStore
    return ExperimentStore(self, **attrlinks)
  
  def newGuid(self):
    """
    get new globally unique identifier
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.newGuid:
       called on deleted object""" % self.qualifiedName
      )

    # NBNB HACK TBD
    # This is a weak GUID generator - should be replaced with a proper one
    # NB must be done by direct access
    
    import time
    dataDict = self.__dict__
    
    tt = time.time()
    timeStamp = ''.join((time.strftime("%Y-%m-%d-%H-%M-%S", time.localtime(tt)), '-',  ("%.3f" % (tt%1))[2:]))
    if timeStamp == dataDict.get('_lastTimeStamp'):
      serial = dataDict.get('_lastTimeSerial',0) + 1
      dataDict['_lastTimeSerial'] = serial
    else:
      dataDict['_lastTimeStamp'] = timeStamp
      serial = dataDict['_lastTimeSerial'] = 1
          
    result =  "%s_%s_%s_%05d" % (dataDict['name'], dataDict['currentUserId'], 
                                   timeStamp, serial)
    return result
  
  def newHaddockProject(self, **attrlinks):
    """
    Factory function to create utrecht.Haddock.HaddockProject
    """
    from utrecht.api.Haddock import HaddockProject
    return HaddockProject(self, **attrlinks)
  
  def newHolderStore(self, **attrlinks):
    """
    Factory function to create ccp.lims.Holder.HolderStore
    """
    from ccp.api.lims.Holder import HolderStore
    return HolderStore(self, **attrlinks)
  
  def newInstrumentStore(self, **attrlinks):
    """
    Factory function to create ccp.general.Instrument.InstrumentStore
    """
    from ccp.api.general.Instrument import InstrumentStore
    return InstrumentStore(self, **attrlinks)
  
  def newKeywordDefinitionStore(self, **attrlinks):
    """
    Factory function to create
    ccp.general.KeywordDefinition.KeywordDefinitionStore
    """
    from ccp.api.general.KeywordDefinition import KeywordDefinitionStore
    return KeywordDefinitionStore(self, **attrlinks)
  
  def newLabeledMolecule(self, **attrlinks):
    """
    Factory function to create ccp.molecule.LabeledMolecule.LabeledMolecule
    """
    from ccp.api.molecule.LabeledMolecule import LabeledMolecule
    return LabeledMolecule(self, **attrlinks)
  
  def newLabelingScheme(self, **attrlinks):
    """
    Factory function to create ccp.molecule.ChemCompLabel.LabelingScheme
    """
    from ccp.api.molecule.ChemCompLabel import LabelingScheme
    return LabelingScheme(self, **attrlinks)
  
  def newLocationStore(self, **attrlinks):
    """
    Factory function to create ccp.lims.Location.LocationStore
    """
    from ccp.api.lims.Location import LocationStore
    return LocationStore(self, **attrlinks)
  
  def newMethodStore(self, **attrlinks):
    """
    Factory function to create ccp.general.Method.MethodStore
    """
    from ccp.api.general.Method import MethodStore
    return MethodStore(self, **attrlinks)
  
  def newMolSystem(self, **attrlinks):
    """
    Factory function to create ccp.molecule.MolSystem.MolSystem
    """
    from ccp.api.molecule.MolSystem import MolSystem
    return MolSystem(self, **attrlinks)
  
  def newMolSystemSymmetrySet(self, **attrlinks):
    """
    Factory function to create molsim.Symmetry.MolSystemSymmetrySet
    """
    from molsim.api.Symmetry import MolSystemSymmetrySet
    return MolSystemSymmetrySet(self, **attrlinks)
  
  def newMolecule(self, **attrlinks):
    """
    Factory function to create ccp.molecule.Molecule.Molecule
    """
    from ccp.api.molecule.Molecule import Molecule
    return Molecule(self, **attrlinks)
  
  def newNameMappingStore(self, **attrlinks):
    """
    Factory function to create ccpnmr.NameMapping.NameMappingStore
    """
    from ccpnmr.api.NameMapping import NameMappingStore
    return NameMappingStore(self, **attrlinks)
  
  def newNmrCalcStore(self, **attrlinks):
    """
    Factory function to create ccp.nmr.NmrCalc.NmrCalcStore
    """
    from ccp.api.nmr.NmrCalc import NmrCalcStore
    return NmrCalcStore(self, **attrlinks)
  
  def newNmrConstraintStore(self, **attrlinks):
    """
    Factory function to create ccp.nmr.NmrConstraint.NmrConstraintStore
    """
    from ccp.api.nmr.NmrConstraint import NmrConstraintStore
    return NmrConstraintStore(self, **attrlinks)
  
  def newNmrEntryStore(self, **attrlinks):
    """
    Factory function to create ccp.nmr.NmrEntry.NmrEntryStore
    """
    from ccp.api.nmr.NmrEntry import NmrEntryStore
    return NmrEntryStore(self, **attrlinks)
  
  def newNmrExpPrototype(self, **attrlinks):
    """
    Factory function to create ccp.nmr.NmrExpPrototype.NmrExpPrototype
    """
    from ccp.api.nmr.NmrExpPrototype import NmrExpPrototype
    return NmrExpPrototype(self, **attrlinks)
  
  def newNmrProject(self, **attrlinks):
    """
    Factory function to create ccp.nmr.Nmr.NmrProject
    """
    from ccp.api.nmr.Nmr import NmrProject
    return NmrProject(self, **attrlinks)
  
  def newNmrReferenceStore(self, **attrlinks):
    """
    Factory function to create ccp.nmr.NmrReference.NmrReferenceStore
    """
    from ccp.api.nmr.NmrReference import NmrReferenceStore
    return NmrReferenceStore(self, **attrlinks)
  
  def newNmrScreenStore(self, **attrlinks):
    """
    Factory function to create ccp.nmr.NmrScreen.NmrScreenStore
    """
    from ccp.api.nmr.NmrScreen import NmrScreenStore
    return NmrScreenStore(self, **attrlinks)
  
  def newNonStdChemComp(self, **attrlinks):
    """
    Factory function to create ccp.molecule.ChemComp.NonStdChemComp
    """
    from ccp.api.molecule.ChemComp import NonStdChemComp
    return NonStdChemComp(self, **attrlinks)
  
  def newPackageLocator(self, **attrlinks):
    """
    Factory function to create memops.Implementation.PackageLocator
    """
    return PackageLocator(self, **attrlinks)
  
  def newProtocolStore(self, **attrlinks):
    """
    Factory function to create ccp.lims.Protocol.ProtocolStore
    """
    from ccp.api.lims.Protocol import ProtocolStore
    return ProtocolStore(self, **attrlinks)
  
  def newRefSampleComponentStore(self, **attrlinks):
    """
    Factory function to create
    ccp.lims.RefSampleComponent.RefSampleComponentStore
    """
    from ccp.api.lims.RefSampleComponent import RefSampleComponentStore
    return RefSampleComponentStore(self, **attrlinks)
  
  def newRepository(self, **attrlinks):
    """
    Factory function to create memops.Implementation.Repository
    """
    return Repository(self, **attrlinks)
  
  def newSampleStore(self, **attrlinks):
    """
    Factory function to create ccp.lims.Sample.SampleStore
    """
    from ccp.api.lims.Sample import SampleStore
    return SampleStore(self, **attrlinks)
  
  def newStdChemComp(self, **attrlinks):
    """
    Factory function to create ccp.molecule.ChemComp.StdChemComp
    """
    from ccp.api.molecule.ChemComp import StdChemComp
    return StdChemComp(self, **attrlinks)
  
  def newStereochemistryStore(self, **attrlinks):
    """
    Factory function to create
    ccp.molecule.Stereochemistry.StereochemistryStore
    """
    from ccp.api.molecule.Stereochemistry import StereochemistryStore
    return StereochemistryStore(self, **attrlinks)
  
  def newStructureEnsemble(self, **attrlinks):
    """
    Factory function to create ccp.molecule.MolStructure.StructureEnsemble
    """
    from ccp.api.molecule.MolStructure import StructureEnsemble
    return StructureEnsemble(self, **attrlinks)
  
  def newTargetStore(self, **attrlinks):
    """
    Factory function to create ccp.lims.Target.TargetStore
    """
    from ccp.api.lims.Target import TargetStore
    return TargetStore(self, **attrlinks)
  
  def newTaxonomy(self, **attrlinks):
    """
    Factory function to create ccp.general.Taxonomy.Taxonomy
    """
    from ccp.api.general.Taxonomy import Taxonomy
    return Taxonomy(self, **attrlinks)
  
  def newValidationStore(self, **attrlinks):
    """
    Factory function to create ccp.molecule.Validation.ValidationStore
    """
    from ccp.api.molecule.Validation import ValidationStore
    return ValidationStore(self, **attrlinks)
  
  def refreshTopObjects(self, packageName):
    """
    Check on disk to make sure all topObjects in package packageName are
    present.
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.refreshTopObjects:
       called on deleted object""" % self.qualifiedName
      )

    # NB must be done by direct access
    if packageName == 'memops.Implementation':
        raise ApiError("refreshTopObjects not allowed for memops.Implementation")
    
    import os, os.path
    from memops.format.xml import XmlIO
    from memops.format.xml import Util as xmlUtil
    
    topObjects = self.__dict__['topObjects']
    ff = self.findFirstPackageLocator
    
    activeRepositories = {}
    
    repositories = (ff(targetName=packageName) or ff(targetName='any')).repositories
    for repository in repositories:
    
      fileLocation = repository.getFileLocation(packageName)
      if not os.path.exists(fileLocation):
        continue
      if not os.path.isdir(fileLocation):
        raise ApiError("%s is not a directory" % fileLocation)
      
      fileSuffix = xmlUtil.fileSuffix
      lenSuffix = xmlUtil.lenFileSuffix
      sep = xmlUtil.keySep
      for filename in os.listdir(fileLocation):
    
        if filename.startswith('.'):
          # skip hidden files (on *nix/Mac)
          continue
    
        elif filename.endswith(fileSuffix):
          guid = filename.split(sep)[-1][:-lenSuffix]
          
          topObject = topObjects.get(guid)
          if topObject is None:
            filePath = os.path.join(fileLocation, filename)
            topObject = XmlIO.loadFromFile(self, filePath, partialLoad=True)
          
          ll = activeRepositories.setdefault(topObject, [])
          ll.append(repository)
    
    # set activeRepositories
    for topObject, ll in activeRepositories.iteritems():
      topObject.__dict__['activeRepositories'] = ll
    
  def removeFrom(self, repository):
    """
    Remove data from specified repository. Will remove from disk. NB This
    operation is marked as a query because this means it may be executed on 
    a deleted object. It does have the lasting side effect of changing the 
    contents of the repository.
    """
    dataDict = self.__dict__
    # NB must be done by direct access
    activeRepositories = self.activeRepositories
    if (repository in activeRepositories and len(activeRepositories) <= 1
        and not self.isDeleted):
        raise ApiError("%s: cannot remove TopObject from last repository %s" % (self, repository))
    
    from memops.format.xml import Util as xmlUtil
    fileLocation = xmlUtil.findTopObjectPath(repository.url.getDataLocation(), self)
    import os
    try:
      os.remove(fileLocation)
    except:
      print ("%s: could not remove %s" % (self, fileLocation))
      raise
    
    if repository in activeRepositories:
      if repository is activeRepositories[0]:
        self.__dict__['isModified'] = True
      dataDict['activeRepositories'].remove(repository)
  
  def save(self):
    """
    Save data corresponding to TopObject
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.save:
       called on deleted object""" % self.qualifiedName
      )

    # NB must be done by direct access
    repositories = self.activeRepositories
    if repositories:
      repository = repositories[0]
    else:
      repository = self.packageLocator.findFirstRepository()
    self.saveTo(repository)
    dataDict['isModified'] = False
  
  def saveAll(self):
    """
    force save of all data
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.saveAll:
       called on deleted object""" % self.qualifiedName
      )

    # NB must be done by direct access
    for topObj in self.__dict__['topObjects'].values():
      if topObj.isDeleted:
        for repository in topObj.activeRepositories:
          topObj.removeFrom(repository)
        del  self.__dict__['topObjects'][topObj.guid]
      elif topObj.isLoaded:
        topObj.save()
    self.save()
  
  def saveModified(self):
    """
    Save all modified data
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.saveModified:
       called on deleted object""" % self.qualifiedName
      )

    # NB must be done by direct access
    for topObj in self.__dict__['topObjects'].values():
      if topObj.isDeleted:
        for repository in topObj.activeRepositories:
          topObj.removeFrom(repository)
        del  self.__dict__['topObjects'][topObj.guid]
      elif topObj.isModified:
        topObj.save()
    if self.isModified:
      self.save()
  
  def saveTo(self, repository):
    """
    Save topObject to specified repository
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.saveTo:
       called on deleted object""" % self.qualifiedName
      )

    # NB must be done by direct access
    if not self.isLoaded or self.inConstructor or self.isReading:
      raise ApiError("%s: cannot be saved while isLoaded:%s, inConstructor:%s, isReading:%s"
                           % (self, self.isLoaded, self.inConstructor, self.isReading))
    
    if repository.format == 'xml' and repository.url.protocol == 'file':
      
      # must be done before saving
      activeRepositories = self.activeRepositories
    
      from memops.format.xml import XmlIO
      XmlIO.save(repository.url.getDataLocation(), self)
    
      if repository not in activeRepositories:
        aSet = set(activeRepositories)
        aSet.add(repository)
        dataDict['activeRepositories'][:] = (x for x in self.packageLocator.repositories if x in aSet)
    
    else:
      raise ApiError(" format %s, protocol %s not supported"
                           % (repository.format, repository.url.protocol))
  
  def set(self, name, value):
    """
    SetAttr for memops.Implementation.MemopsRoot
    """
    dataDict = self.__dict__
    setattr(self, name, value)
  
  def setAccessControlOn(self, value):
    """
    Set for memops.Implementation.MemopsRoot.accessControlOn
    """
    dataDict = self.__dict__
    if (not (value in [True, False])):
      raise ApiError("""%s.setAccessControlOn:
       memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('accessControlOn')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = self
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setAccessControlOn:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setAccessControlOn:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setAccessControlOn:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['accessControlOn'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setAccessControlOn')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setCreatedBy(self, value):
    """
    Set for memops.Implementation.MemopsRoot.createdBy
    """
    dataDict = self.__dict__
    if (isinstance(value, String.PythonType)):
      pass
    else:
      raise ApiError("""%s.setCreatedBy:
       memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 32):
      raise ApiError("""%s.setCreatedBy:
       memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.setCreatedBy:
       memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.split()) == 1)):
      raise ApiError("""%s.setCreatedBy:
       Word constraint contains_no_white_space violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('createdBy')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = self
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setCreatedBy:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setCreatedBy:
         cannot set createdBy, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setCreatedBy:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['createdBy'] = value

    # doNotifies
  
  def setCurrentAccessControlStore(self, value):
    """
    Set for memops.Implementation.MemopsRoot.currentAccessControlStore
    """
    dataDict = self.__dict__
    if (value is not None):
      from memops.api.AccessControl import AccessControlStore as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setCurrentAccessControlStore:
         value is not of class memops.AccessControl.AccessControlStore""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('currentAccessControlStore')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = self
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setCurrentAccessControlStore:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setCurrentAccessControlStore:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setCurrentAccessControlStore:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setCurrentAccessControlStore:
           Link currentAccessControlStore between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    dataDict['currentAccessControlStore'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setCurrentAccessControlStore')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setCurrentAffiliationStore(self, value):
    """
    Set for memops.Implementation.MemopsRoot.currentAffiliationStore
    """
    dataDict = self.__dict__
    if (value is not None):
      from ccp.api.general.Affiliation import AffiliationStore as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setCurrentAffiliationStore:
         value is not of class ccp.general.Affiliation.AffiliationStore""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('currentAffiliationStore')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = self
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setCurrentAffiliationStore:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setCurrentAffiliationStore:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setCurrentAffiliationStore:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setCurrentAffiliationStore:
           Link currentAffiliationStore between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    dataDict['currentAffiliationStore'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setCurrentAffiliationStore')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setCurrentAnalysisProfile(self, value):
    """
    Set for memops.Implementation.MemopsRoot.currentAnalysisProfile
    """
    dataDict = self.__dict__
    if (value is not None):
      from ccpnmr.api.AnalysisProfile import AnalysisProfile as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setCurrentAnalysisProfile:
         value is not of class ccpnmr.AnalysisProfile.AnalysisProfile""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('currentAnalysisProfile')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = self
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setCurrentAnalysisProfile:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setCurrentAnalysisProfile:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setCurrentAnalysisProfile:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setCurrentAnalysisProfile:
           Link currentAnalysisProfile between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    dataDict['currentAnalysisProfile'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setCurrentAnalysisProfile')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setCurrentAnalysisProject(self, value):
    """
    Set for memops.Implementation.MemopsRoot.currentAnalysisProject
    """
    dataDict = self.__dict__
    if (value is not None):
      from ccpnmr.api.Analysis import AnalysisProject as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setCurrentAnalysisProject:
         value is not of class ccpnmr.Analysis.AnalysisProject""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('currentAnalysisProject')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = self
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setCurrentAnalysisProject:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setCurrentAnalysisProject:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setCurrentAnalysisProject:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setCurrentAnalysisProject:
           Link currentAnalysisProject between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    dataDict['currentAnalysisProject'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setCurrentAnalysisProject')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setCurrentAnnealProtocolStore(self, value):
    """
    Set for memops.Implementation.MemopsRoot.currentAnnealProtocolStore
    """
    dataDict = self.__dict__
    if (value is not None):
      from molsim.api.AnnealProtocol import AnnealProtocolStore as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setCurrentAnnealProtocolStore:
         value is not of class molsim.AnnealProtocol.AnnealProtocolStore""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('currentAnnealProtocolStore')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = self
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setCurrentAnnealProtocolStore:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setCurrentAnnealProtocolStore:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setCurrentAnnealProtocolStore:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setCurrentAnnealProtocolStore:
           Link currentAnnealProtocolStore between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    dataDict['currentAnnealProtocolStore'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setCurrentAnnealProtocolStore')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setCurrentAnnotationStore(self, value):
    """
    Set for memops.Implementation.MemopsRoot.currentAnnotationStore
    """
    dataDict = self.__dict__
    if (value is not None):
      from ccp.api.general.Annotation import AnnotationStore as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setCurrentAnnotationStore:
         value is not of class ccp.general.Annotation.AnnotationStore""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('currentAnnotationStore')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = self
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setCurrentAnnotationStore:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setCurrentAnnotationStore:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setCurrentAnnotationStore:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setCurrentAnnotationStore:
           Link currentAnnotationStore between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    dataDict['currentAnnotationStore'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setCurrentAnnotationStore')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setCurrentChemComp(self, value):
    """
    Set for memops.Implementation.MemopsRoot.currentChemComp
    """
    dataDict = self.__dict__
    if (value is not None):
      from ccp.api.molecule.ChemComp import ChemComp as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setCurrentChemComp:
         value is not of class ccp.molecule.ChemComp.ChemComp""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('currentChemComp')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = self
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setCurrentChemComp:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setCurrentChemComp:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setCurrentChemComp:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setCurrentChemComp:
           Link currentChemComp between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    dataDict['currentChemComp'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setCurrentChemComp')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setCurrentChemCompCharge(self, value):
    """
    Set for memops.Implementation.MemopsRoot.currentChemCompCharge
    """
    dataDict = self.__dict__
    if (value is not None):
      from ccp.api.molecule.ChemCompCharge import ChemCompCharge as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setCurrentChemCompCharge:
         value is not of class ccp.molecule.ChemCompCharge.ChemCompCharge""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('currentChemCompCharge')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = self
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setCurrentChemCompCharge:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setCurrentChemCompCharge:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setCurrentChemCompCharge:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setCurrentChemCompCharge:
           Link currentChemCompCharge between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    dataDict['currentChemCompCharge'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setCurrentChemCompCharge')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setCurrentChemCompCoord(self, value):
    """
    Set for memops.Implementation.MemopsRoot.currentChemCompCoord
    """
    dataDict = self.__dict__
    if (value is not None):
      from ccp.api.molecule.ChemCompCoord import ChemCompCoord as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setCurrentChemCompCoord:
         value is not of class ccp.molecule.ChemCompCoord.ChemCompCoord""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('currentChemCompCoord')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = self
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setCurrentChemCompCoord:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setCurrentChemCompCoord:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setCurrentChemCompCoord:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setCurrentChemCompCoord:
           Link currentChemCompCoord between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    dataDict['currentChemCompCoord'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setCurrentChemCompCoord')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setCurrentChemElementStore(self, value):
    """
    Set for memops.Implementation.MemopsRoot.currentChemElementStore
    """
    dataDict = self.__dict__
    if (value is not None):
      from ccp.api.molecule.ChemElement import ChemElementStore as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setCurrentChemElementStore:
         value is not of class ccp.molecule.ChemElement.ChemElementStore""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('currentChemElementStore')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = self
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setCurrentChemElementStore:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setCurrentChemElementStore:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setCurrentChemElementStore:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setCurrentChemElementStore:
           Link currentChemElementStore between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    dataDict['currentChemElementStore'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setCurrentChemElementStore')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setCurrentCitationStore(self, value):
    """
    Set for memops.Implementation.MemopsRoot.currentCitationStore
    """
    dataDict = self.__dict__
    if (value is not None):
      from ccp.api.general.Citation import CitationStore as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setCurrentCitationStore:
         value is not of class ccp.general.Citation.CitationStore""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('currentCitationStore')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = self
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setCurrentCitationStore:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setCurrentCitationStore:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setCurrentCitationStore:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setCurrentCitationStore:
           Link currentCitationStore between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    dataDict['currentCitationStore'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setCurrentCitationStore')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setCurrentClassification(self, value):
    """
    Set for memops.Implementation.MemopsRoot.currentClassification
    """
    dataDict = self.__dict__
    if (value is not None):
      from ccp.api.lims.Classification import Classification as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setCurrentClassification:
         value is not of class ccp.lims.Classification.Classification""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('currentClassification')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = self
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setCurrentClassification:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setCurrentClassification:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setCurrentClassification:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setCurrentClassification:
           Link currentClassification between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    dataDict['currentClassification'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setCurrentClassification')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setCurrentCrystallizationStore(self, value):
    """
    Set for memops.Implementation.MemopsRoot.currentCrystallizationStore
    """
    dataDict = self.__dict__
    if (value is not None):
      from ccp.api.lims.Crystallization import CrystallizationStore as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setCurrentCrystallizationStore:
         value is not of class ccp.lims.Crystallization.CrystallizationStore""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('currentCrystallizationStore')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = self
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setCurrentCrystallizationStore:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setCurrentCrystallizationStore:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setCurrentCrystallizationStore:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setCurrentCrystallizationStore:
           Link currentCrystallizationStore between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    dataDict['currentCrystallizationStore'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setCurrentCrystallizationStore')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setCurrentDangleStore(self, value):
    """
    Set for memops.Implementation.MemopsRoot.currentDangleStore
    """
    dataDict = self.__dict__
    if (value is not None):
      from cambridge.api.Dangle import DangleStore as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setCurrentDangleStore:
         value is not of class cambridge.Dangle.DangleStore""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('currentDangleStore')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = self
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setCurrentDangleStore:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setCurrentDangleStore:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setCurrentDangleStore:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setCurrentDangleStore:
           Link currentDangleStore between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    dataDict['currentDangleStore'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setCurrentDangleStore')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setCurrentDataLocationStore(self, value):
    """
    Set for memops.Implementation.MemopsRoot.currentDataLocationStore
    """
    dataDict = self.__dict__
    if (value is not None):
      from ccp.api.general.DataLocation import DataLocationStore as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setCurrentDataLocationStore:
         value is not of class ccp.general.DataLocation.DataLocationStore""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('currentDataLocationStore')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = self
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setCurrentDataLocationStore:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setCurrentDataLocationStore:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setCurrentDataLocationStore:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setCurrentDataLocationStore:
           Link currentDataLocationStore between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    dataDict['currentDataLocationStore'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setCurrentDataLocationStore')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setCurrentDatabase(self, value):
    """
    Set for memops.Implementation.MemopsRoot.currentDatabase
    """
    dataDict = self.__dict__
    if (value is not None):
      from ccp.api.general.DbRef import Database as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setCurrentDatabase:
         value is not of class ccp.general.DbRef.Database""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('currentDatabase')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = self
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setCurrentDatabase:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setCurrentDatabase:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setCurrentDatabase:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setCurrentDatabase:
           Link currentDatabase between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    dataDict['currentDatabase'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setCurrentDatabase')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setCurrentExpBlueprintStore(self, value):
    """
    Set for memops.Implementation.MemopsRoot.currentExpBlueprintStore
    """
    dataDict = self.__dict__
    if (value is not None):
      from ccp.api.lims.ExpBlueprint import ExpBlueprintStore as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setCurrentExpBlueprintStore:
         value is not of class ccp.lims.ExpBlueprint.ExpBlueprintStore""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('currentExpBlueprintStore')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = self
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setCurrentExpBlueprintStore:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setCurrentExpBlueprintStore:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setCurrentExpBlueprintStore:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setCurrentExpBlueprintStore:
           Link currentExpBlueprintStore between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    dataDict['currentExpBlueprintStore'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setCurrentExpBlueprintStore')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setCurrentExperimentStore(self, value):
    """
    Set for memops.Implementation.MemopsRoot.currentExperimentStore
    """
    dataDict = self.__dict__
    if (value is not None):
      from ccp.api.lims.Experiment import ExperimentStore as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setCurrentExperimentStore:
         value is not of class ccp.lims.Experiment.ExperimentStore""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('currentExperimentStore')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = self
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setCurrentExperimentStore:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setCurrentExperimentStore:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setCurrentExperimentStore:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setCurrentExperimentStore:
           Link currentExperimentStore between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    dataDict['currentExperimentStore'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setCurrentExperimentStore')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setCurrentGroupName(self, value):
    """
    Set for memops.Implementation.MemopsRoot.currentGroupName
    """
    dataDict = self.__dict__
    if (isinstance(value, String.PythonType)):
      pass
    else:
      raise ApiError("""%s.setCurrentGroupName:
       memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 32):
      raise ApiError("""%s.setCurrentGroupName:
       memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.setCurrentGroupName:
       memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.split()) == 1)):
      raise ApiError("""%s.setCurrentGroupName:
       Word constraint contains_no_white_space violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('currentGroupName')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = self
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setCurrentGroupName:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setCurrentGroupName:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setCurrentGroupName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['currentGroupName'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setCurrentGroupName')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setCurrentHaddockProject(self, value):
    """
    Set for memops.Implementation.MemopsRoot.currentHaddockProject
    """
    dataDict = self.__dict__
    if (value is not None):
      from utrecht.api.Haddock import HaddockProject as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setCurrentHaddockProject:
         value is not of class utrecht.Haddock.HaddockProject""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('currentHaddockProject')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = self
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setCurrentHaddockProject:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setCurrentHaddockProject:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setCurrentHaddockProject:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setCurrentHaddockProject:
           Link currentHaddockProject between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    dataDict['currentHaddockProject'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setCurrentHaddockProject')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setCurrentHolderStore(self, value):
    """
    Set for memops.Implementation.MemopsRoot.currentHolderStore
    """
    dataDict = self.__dict__
    if (value is not None):
      from ccp.api.lims.Holder import HolderStore as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setCurrentHolderStore:
         value is not of class ccp.lims.Holder.HolderStore""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('currentHolderStore')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = self
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setCurrentHolderStore:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setCurrentHolderStore:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setCurrentHolderStore:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setCurrentHolderStore:
           Link currentHolderStore between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    dataDict['currentHolderStore'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setCurrentHolderStore')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setCurrentInstrumentStore(self, value):
    """
    Set for memops.Implementation.MemopsRoot.currentInstrumentStore
    """
    dataDict = self.__dict__
    if (value is not None):
      from ccp.api.general.Instrument import InstrumentStore as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setCurrentInstrumentStore:
         value is not of class ccp.general.Instrument.InstrumentStore""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('currentInstrumentStore')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = self
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setCurrentInstrumentStore:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setCurrentInstrumentStore:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setCurrentInstrumentStore:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setCurrentInstrumentStore:
           Link currentInstrumentStore between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    dataDict['currentInstrumentStore'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setCurrentInstrumentStore')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setCurrentKeywordDefinitionStore(self, value):
    """
    Set for memops.Implementation.MemopsRoot.currentKeywordDefinitionStore
    """
    dataDict = self.__dict__
    if (value is not None):
      from ccp.api.general.KeywordDefinition import KeywordDefinitionStore as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setCurrentKeywordDefinitionStore:
         value is not of class ccp.general.KeywordDefinition.KeywordDefinitionStore""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('currentKeywordDefinitionStore')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = self
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setCurrentKeywordDefinitionStore:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setCurrentKeywordDefinitionStore:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setCurrentKeywordDefinitionStore:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setCurrentKeywordDefinitionStore:
           Link currentKeywordDefinitionStore between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    dataDict['currentKeywordDefinitionStore'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setCurrentKeywordDefinitionStore')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setCurrentLabeledMolecule(self, value):
    """
    Set for memops.Implementation.MemopsRoot.currentLabeledMolecule
    """
    dataDict = self.__dict__
    if (value is not None):
      from ccp.api.molecule.LabeledMolecule import LabeledMolecule as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setCurrentLabeledMolecule:
         value is not of class ccp.molecule.LabeledMolecule.LabeledMolecule""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('currentLabeledMolecule')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = self
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setCurrentLabeledMolecule:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setCurrentLabeledMolecule:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setCurrentLabeledMolecule:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setCurrentLabeledMolecule:
           Link currentLabeledMolecule between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    dataDict['currentLabeledMolecule'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setCurrentLabeledMolecule')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setCurrentLabelingScheme(self, value):
    """
    Set for memops.Implementation.MemopsRoot.currentLabelingScheme
    """
    dataDict = self.__dict__
    if (value is not None):
      from ccp.api.molecule.ChemCompLabel import LabelingScheme as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setCurrentLabelingScheme:
         value is not of class ccp.molecule.ChemCompLabel.LabelingScheme""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('currentLabelingScheme')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = self
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setCurrentLabelingScheme:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setCurrentLabelingScheme:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setCurrentLabelingScheme:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setCurrentLabelingScheme:
           Link currentLabelingScheme between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    dataDict['currentLabelingScheme'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setCurrentLabelingScheme')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setCurrentLocationStore(self, value):
    """
    Set for memops.Implementation.MemopsRoot.currentLocationStore
    """
    dataDict = self.__dict__
    if (value is not None):
      from ccp.api.lims.Location import LocationStore as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setCurrentLocationStore:
         value is not of class ccp.lims.Location.LocationStore""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('currentLocationStore')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = self
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setCurrentLocationStore:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setCurrentLocationStore:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setCurrentLocationStore:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setCurrentLocationStore:
           Link currentLocationStore between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    dataDict['currentLocationStore'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setCurrentLocationStore')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setCurrentMethodStore(self, value):
    """
    Set for memops.Implementation.MemopsRoot.currentMethodStore
    """
    dataDict = self.__dict__
    if (value is not None):
      from ccp.api.general.Method import MethodStore as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setCurrentMethodStore:
         value is not of class ccp.general.Method.MethodStore""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('currentMethodStore')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = self
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setCurrentMethodStore:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setCurrentMethodStore:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setCurrentMethodStore:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setCurrentMethodStore:
           Link currentMethodStore between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    dataDict['currentMethodStore'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setCurrentMethodStore')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setCurrentMolSystem(self, value):
    """
    Set for memops.Implementation.MemopsRoot.currentMolSystem
    """
    dataDict = self.__dict__
    if (value is not None):
      from ccp.api.molecule.MolSystem import MolSystem as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setCurrentMolSystem:
         value is not of class ccp.molecule.MolSystem.MolSystem""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('currentMolSystem')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = self
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setCurrentMolSystem:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setCurrentMolSystem:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setCurrentMolSystem:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setCurrentMolSystem:
           Link currentMolSystem between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    dataDict['currentMolSystem'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setCurrentMolSystem')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setCurrentMolSystemSymmetrySet(self, value):
    """
    Set for memops.Implementation.MemopsRoot.currentMolSystemSymmetrySet
    """
    dataDict = self.__dict__
    if (value is not None):
      from molsim.api.Symmetry import MolSystemSymmetrySet as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setCurrentMolSystemSymmetrySet:
         value is not of class molsim.Symmetry.MolSystemSymmetrySet""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('currentMolSystemSymmetrySet')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = self
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setCurrentMolSystemSymmetrySet:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setCurrentMolSystemSymmetrySet:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setCurrentMolSystemSymmetrySet:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setCurrentMolSystemSymmetrySet:
           Link currentMolSystemSymmetrySet between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    dataDict['currentMolSystemSymmetrySet'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setCurrentMolSystemSymmetrySet')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setCurrentMolecule(self, value):
    """
    Set for memops.Implementation.MemopsRoot.currentMolecule
    """
    dataDict = self.__dict__
    if (value is not None):
      from ccp.api.molecule.Molecule import Molecule as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setCurrentMolecule:
         value is not of class ccp.molecule.Molecule.Molecule""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('currentMolecule')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = self
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setCurrentMolecule:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setCurrentMolecule:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setCurrentMolecule:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setCurrentMolecule:
           Link currentMolecule between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    dataDict['currentMolecule'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setCurrentMolecule')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setCurrentNameMappingStore(self, value):
    """
    Set for memops.Implementation.MemopsRoot.currentNameMappingStore
    """
    dataDict = self.__dict__
    if (value is not None):
      from ccpnmr.api.NameMapping import NameMappingStore as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setCurrentNameMappingStore:
         value is not of class ccpnmr.NameMapping.NameMappingStore""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('currentNameMappingStore')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = self
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setCurrentNameMappingStore:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setCurrentNameMappingStore:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setCurrentNameMappingStore:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setCurrentNameMappingStore:
           Link currentNameMappingStore between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    dataDict['currentNameMappingStore'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setCurrentNameMappingStore')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setCurrentNmrCalcStore(self, value):
    """
    Set for memops.Implementation.MemopsRoot.currentNmrCalcStore
    """
    dataDict = self.__dict__
    if (value is not None):
      from ccp.api.nmr.NmrCalc import NmrCalcStore as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setCurrentNmrCalcStore:
         value is not of class ccp.nmr.NmrCalc.NmrCalcStore""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('currentNmrCalcStore')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = self
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setCurrentNmrCalcStore:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setCurrentNmrCalcStore:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setCurrentNmrCalcStore:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setCurrentNmrCalcStore:
           Link currentNmrCalcStore between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    dataDict['currentNmrCalcStore'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setCurrentNmrCalcStore')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setCurrentNmrConstraintStore(self, value):
    """
    Set for memops.Implementation.MemopsRoot.currentNmrConstraintStore
    """
    dataDict = self.__dict__
    if (value is not None):
      from ccp.api.nmr.NmrConstraint import NmrConstraintStore as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setCurrentNmrConstraintStore:
         value is not of class ccp.nmr.NmrConstraint.NmrConstraintStore""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('currentNmrConstraintStore')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = self
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setCurrentNmrConstraintStore:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setCurrentNmrConstraintStore:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setCurrentNmrConstraintStore:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setCurrentNmrConstraintStore:
           Link currentNmrConstraintStore between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    dataDict['currentNmrConstraintStore'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setCurrentNmrConstraintStore')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setCurrentNmrEntryStore(self, value):
    """
    Set for memops.Implementation.MemopsRoot.currentNmrEntryStore
    """
    dataDict = self.__dict__
    if (value is not None):
      from ccp.api.nmr.NmrEntry import NmrEntryStore as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setCurrentNmrEntryStore:
         value is not of class ccp.nmr.NmrEntry.NmrEntryStore""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('currentNmrEntryStore')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = self
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setCurrentNmrEntryStore:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setCurrentNmrEntryStore:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setCurrentNmrEntryStore:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setCurrentNmrEntryStore:
           Link currentNmrEntryStore between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    dataDict['currentNmrEntryStore'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setCurrentNmrEntryStore')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setCurrentNmrExpPrototype(self, value):
    """
    Set for memops.Implementation.MemopsRoot.currentNmrExpPrototype
    """
    dataDict = self.__dict__
    if (value is not None):
      from ccp.api.nmr.NmrExpPrototype import NmrExpPrototype as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setCurrentNmrExpPrototype:
         value is not of class ccp.nmr.NmrExpPrototype.NmrExpPrototype""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('currentNmrExpPrototype')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = self
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setCurrentNmrExpPrototype:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setCurrentNmrExpPrototype:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setCurrentNmrExpPrototype:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setCurrentNmrExpPrototype:
           Link currentNmrExpPrototype between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    dataDict['currentNmrExpPrototype'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setCurrentNmrExpPrototype')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setCurrentNmrProject(self, value):
    """
    Set for memops.Implementation.MemopsRoot.currentNmrProject
    """
    dataDict = self.__dict__
    if (value is not None):
      from ccp.api.nmr.Nmr import NmrProject as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setCurrentNmrProject:
         value is not of class ccp.nmr.Nmr.NmrProject""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('currentNmrProject')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = self
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setCurrentNmrProject:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setCurrentNmrProject:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setCurrentNmrProject:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setCurrentNmrProject:
           Link currentNmrProject between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    dataDict['currentNmrProject'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setCurrentNmrProject')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setCurrentNmrReferenceStore(self, value):
    """
    Set for memops.Implementation.MemopsRoot.currentNmrReferenceStore
    """
    dataDict = self.__dict__
    if (value is not None):
      from ccp.api.nmr.NmrReference import NmrReferenceStore as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setCurrentNmrReferenceStore:
         value is not of class ccp.nmr.NmrReference.NmrReferenceStore""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('currentNmrReferenceStore')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = self
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setCurrentNmrReferenceStore:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setCurrentNmrReferenceStore:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setCurrentNmrReferenceStore:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setCurrentNmrReferenceStore:
           Link currentNmrReferenceStore between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    dataDict['currentNmrReferenceStore'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setCurrentNmrReferenceStore')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setCurrentNmrScreenStore(self, value):
    """
    Set for memops.Implementation.MemopsRoot.currentNmrScreenStore
    """
    dataDict = self.__dict__
    if (value is not None):
      from ccp.api.nmr.NmrScreen import NmrScreenStore as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setCurrentNmrScreenStore:
         value is not of class ccp.nmr.NmrScreen.NmrScreenStore""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('currentNmrScreenStore')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = self
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setCurrentNmrScreenStore:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setCurrentNmrScreenStore:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setCurrentNmrScreenStore:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setCurrentNmrScreenStore:
           Link currentNmrScreenStore between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    dataDict['currentNmrScreenStore'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setCurrentNmrScreenStore')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setCurrentProtocolStore(self, value):
    """
    Set for memops.Implementation.MemopsRoot.currentProtocolStore
    """
    dataDict = self.__dict__
    if (value is not None):
      from ccp.api.lims.Protocol import ProtocolStore as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setCurrentProtocolStore:
         value is not of class ccp.lims.Protocol.ProtocolStore""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('currentProtocolStore')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = self
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setCurrentProtocolStore:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setCurrentProtocolStore:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setCurrentProtocolStore:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setCurrentProtocolStore:
           Link currentProtocolStore between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    dataDict['currentProtocolStore'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setCurrentProtocolStore')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setCurrentRefSampleComponentStore(self, value):
    """
    Set for memops.Implementation.MemopsRoot.currentRefSampleComponentStore
    """
    dataDict = self.__dict__
    if (value is not None):
      from ccp.api.lims.RefSampleComponent import RefSampleComponentStore as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setCurrentRefSampleComponentStore:
         value is not of class ccp.lims.RefSampleComponent.RefSampleComponentStore""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('currentRefSampleComponentStore')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = self
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setCurrentRefSampleComponentStore:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setCurrentRefSampleComponentStore:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setCurrentRefSampleComponentStore:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setCurrentRefSampleComponentStore:
           Link currentRefSampleComponentStore between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    dataDict['currentRefSampleComponentStore'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setCurrentRefSampleComponentStore')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setCurrentSampleStore(self, value):
    """
    Set for memops.Implementation.MemopsRoot.currentSampleStore
    """
    dataDict = self.__dict__
    if (value is not None):
      from ccp.api.lims.Sample import SampleStore as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setCurrentSampleStore:
         value is not of class ccp.lims.Sample.SampleStore""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('currentSampleStore')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = self
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setCurrentSampleStore:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setCurrentSampleStore:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setCurrentSampleStore:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setCurrentSampleStore:
           Link currentSampleStore between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    dataDict['currentSampleStore'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setCurrentSampleStore')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setCurrentStereochemistryStore(self, value):
    """
    Set for memops.Implementation.MemopsRoot.currentStereochemistryStore
    """
    dataDict = self.__dict__
    if (value is not None):
      from ccp.api.molecule.Stereochemistry import StereochemistryStore as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setCurrentStereochemistryStore:
         value is not of class ccp.molecule.Stereochemistry.StereochemistryStore""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('currentStereochemistryStore')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = self
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setCurrentStereochemistryStore:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setCurrentStereochemistryStore:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setCurrentStereochemistryStore:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setCurrentStereochemistryStore:
           Link currentStereochemistryStore between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    dataDict['currentStereochemistryStore'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setCurrentStereochemistryStore')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setCurrentStructureEnsemble(self, value):
    """
    Set for memops.Implementation.MemopsRoot.currentStructureEnsemble
    """
    dataDict = self.__dict__
    if (value is not None):
      from ccp.api.molecule.MolStructure import StructureEnsemble as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setCurrentStructureEnsemble:
         value is not of class ccp.molecule.MolStructure.StructureEnsemble""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('currentStructureEnsemble')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = self
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setCurrentStructureEnsemble:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setCurrentStructureEnsemble:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setCurrentStructureEnsemble:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setCurrentStructureEnsemble:
           Link currentStructureEnsemble between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    dataDict['currentStructureEnsemble'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setCurrentStructureEnsemble')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setCurrentTargetStore(self, value):
    """
    Set for memops.Implementation.MemopsRoot.currentTargetStore
    """
    dataDict = self.__dict__
    if (value is not None):
      from ccp.api.lims.Target import TargetStore as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setCurrentTargetStore:
         value is not of class ccp.lims.Target.TargetStore""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('currentTargetStore')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = self
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setCurrentTargetStore:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setCurrentTargetStore:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setCurrentTargetStore:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setCurrentTargetStore:
           Link currentTargetStore between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    dataDict['currentTargetStore'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setCurrentTargetStore')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setCurrentTaxonomy(self, value):
    """
    Set for memops.Implementation.MemopsRoot.currentTaxonomy
    """
    dataDict = self.__dict__
    if (value is not None):
      from ccp.api.general.Taxonomy import Taxonomy as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setCurrentTaxonomy:
         value is not of class ccp.general.Taxonomy.Taxonomy""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('currentTaxonomy')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = self
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setCurrentTaxonomy:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setCurrentTaxonomy:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setCurrentTaxonomy:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setCurrentTaxonomy:
           Link currentTaxonomy between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    dataDict['currentTaxonomy'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setCurrentTaxonomy')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setCurrentUserId(self, value):
    """
    Set for memops.Implementation.MemopsRoot.currentUserId
    """
    dataDict = self.__dict__
    if (isinstance(value, String.PythonType)):
      pass
    else:
      raise ApiError("""%s.setCurrentUserId:
       memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 32):
      raise ApiError("""%s.setCurrentUserId:
       memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.setCurrentUserId:
       memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.split()) == 1)):
      raise ApiError("""%s.setCurrentUserId:
       Word constraint contains_no_white_space violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('currentUserId')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = self
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setCurrentUserId:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setCurrentUserId:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setCurrentUserId:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (notInConstructor):
        if (value is not None):
          isValid = frozenset('abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789').issuperset(value)
          if (not (isValid)):
            raise ApiError("""%s.setCurrentUserId:
             currentUserId constraint value_is_alphanumeric violated by value""" % self.qualifiedName
             + ": %s" % (value,)
            )

    dataDict['currentUserId'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setCurrentUserId')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setCurrentValidationStore(self, value):
    """
    Set for memops.Implementation.MemopsRoot.currentValidationStore
    """
    dataDict = self.__dict__
    if (value is not None):
      from ccp.api.molecule.Validation import ValidationStore as importedType
      if (not isinstance(value, importedType)):
        raise ApiError("""%s.setCurrentValidationStore:
         value is not of class ccp.molecule.Validation.ValidationStore""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('currentValidationStore')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = self
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setCurrentValidationStore:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setCurrentValidationStore:
       called on deleted object""" % self.qualifiedName
      )

    if (value is not None):
      if (value.__dict__.get('isDeleted')):
        raise ApiError("""%s.setCurrentValidationStore:
         called with deleted value""" % self.qualifiedName
        )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setCurrentValidationStore:
           Link currentValidationStore between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    dataDict['currentValidationStore'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setCurrentValidationStore')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setIsModifiable(self, value):
    """
    Special setter for isModifiable. Sets lastUnlockedBy
    """
    dataDict = self.__dict__
    if (not (value in [True, False])):
      raise ApiError("""%s.setIsModifiable:
       memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('isModifiable')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = self
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setIsModifiable:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setIsModifiable:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    # NB must be done by direct access
    if self.isModified:
      raise ApiError("Modified and unsaved Storage can not be set to non-modifiable")
    
    if value:
      dataDict['lastUnlockedBy'] = self.root.currentUserId
    
    dataDict['isModifiable'] = bool(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setIsModifiable')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setLastUnlockedBy(self, value):
    """
    Set for memops.Implementation.MemopsRoot.lastUnlockedBy
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setLastUnlockedBy:
         memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 32):
        raise ApiError("""%s.setLastUnlockedBy:
         memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setLastUnlockedBy:
         memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.setLastUnlockedBy:
         Word constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('lastUnlockedBy')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = self
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setLastUnlockedBy:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setLastUnlockedBy:
         cannot set lastUnlockedBy, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['lastUnlockedBy'] = value

    # doNotifies
  
  def setName(self, value):
    """
    Set for memops.Implementation.MemopsRoot.name
    """
    dataDict = self.__dict__
    if (isinstance(value, String.PythonType)):
      pass
    else:
      raise ApiError("""%s.setName:
       memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 32):
      raise ApiError("""%s.setName:
       memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.setName:
       memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.split()) == 1)):
      raise ApiError("""%s.setName:
       Word constraint contains_no_white_space violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('name')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = self
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setName:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setName:
         cannot set name, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (notInConstructor):
        if (value is not None):
          isValid = frozenset('abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_0123456789').issuperset(value)
          if (not (isValid)):
            raise ApiError("""%s.setName:
             name constraint value_is_alphanumeric_or_underscore violated by value""" % self.qualifiedName
             + ": %s" % (value,)
            )

    dataDict['name'] = value

    # doNotifies
  
  def setOverride(self, value):
    """
    Set for memops.Implementation.MemopsRoot.override
    """
    dataDict = self.__dict__
    if (not (value in [True, False])):
      raise ApiError("""%s.setOverride:
       memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('override')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = self
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setOverride:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setOverride:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setOverride:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['override'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setOverride')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def sortedAccessControlStores(self):
    """
    Sorted for memops.Implementation.MemopsRoot.accessControlStores
    """
    dataDict = self.__dict__
    root = self
    root.refreshTopObjects('memops.AccessControl')
    sortdd = dataDict.get('accessControlStores')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result
  
  def sortedAffiliationStores(self):
    """
    Sorted for memops.Implementation.MemopsRoot.affiliationStores
    """
    dataDict = self.__dict__
    root = self
    root.refreshTopObjects('ccp.general.Affiliation')
    sortdd = dataDict.get('affiliationStores')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result
  
  def sortedAnalysisProfiles(self):
    """
    Sorted for memops.Implementation.MemopsRoot.analysisProfiles
    """
    dataDict = self.__dict__
    root = self
    root.refreshTopObjects('ccpnmr.AnalysisProfile')
    sortdd = dataDict.get('analysisProfiles')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result
  
  def sortedAnalysisProjects(self):
    """
    Sorted for memops.Implementation.MemopsRoot.analysisProjects
    """
    dataDict = self.__dict__
    root = self
    root.refreshTopObjects('ccpnmr.Analysis')
    sortdd = dataDict.get('analysisProjects')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result
  
  def sortedAnnealProtocolStores(self):
    """
    Sorted for memops.Implementation.MemopsRoot.annealProtocolStores
    """
    dataDict = self.__dict__
    root = self
    root.refreshTopObjects('molsim.AnnealProtocol')
    sortdd = dataDict.get('annealProtocolStores')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result
  
  def sortedAnnotationStores(self):
    """
    Sorted for memops.Implementation.MemopsRoot.annotationStores
    """
    dataDict = self.__dict__
    root = self
    root.refreshTopObjects('ccp.general.Annotation')
    sortdd = dataDict.get('annotationStores')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result
  
  def sortedChemCompCharges(self):
    """
    Sorted for memops.Implementation.MemopsRoot.chemCompCharges
    """
    dataDict = self.__dict__
    root = self
    root.refreshTopObjects('ccp.molecule.ChemCompCharge')
    sortdd = dataDict.get('chemCompCharges')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result
  
  def sortedChemCompCoords(self):
    """
    Sorted for memops.Implementation.MemopsRoot.chemCompCoords
    """
    dataDict = self.__dict__
    root = self
    root.refreshTopObjects('ccp.molecule.ChemCompCoord')
    sortdd = dataDict.get('chemCompCoords')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result
  
  def sortedChemComps(self):
    """
    Sorted for memops.Implementation.MemopsRoot.chemComps
    """
    dataDict = self.__dict__
    root = self
    root.refreshTopObjects('ccp.molecule.ChemComp')
    sortdd = dataDict.get('chemComps')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result
  
  def sortedChemElementStores(self):
    """
    Sorted for memops.Implementation.MemopsRoot.chemElementStores
    """
    dataDict = self.__dict__
    root = self
    root.refreshTopObjects('ccp.molecule.ChemElement')
    sortdd = dataDict.get('chemElementStores')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result
  
  def sortedCitationStores(self):
    """
    Sorted for memops.Implementation.MemopsRoot.citationStores
    """
    dataDict = self.__dict__
    root = self
    root.refreshTopObjects('ccp.general.Citation')
    sortdd = dataDict.get('citationStores')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result
  
  def sortedClassifications(self):
    """
    Sorted for memops.Implementation.MemopsRoot.classifications
    """
    dataDict = self.__dict__
    root = self
    root.refreshTopObjects('ccp.lims.Classification')
    sortdd = dataDict.get('classifications')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result
  
  def sortedCrystallizationStores(self):
    """
    Sorted for memops.Implementation.MemopsRoot.crystallizationStores
    """
    dataDict = self.__dict__
    root = self
    root.refreshTopObjects('ccp.lims.Crystallization')
    sortdd = dataDict.get('crystallizationStores')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result
  
  def sortedDangleStores(self):
    """
    Sorted for memops.Implementation.MemopsRoot.dangleStores
    """
    dataDict = self.__dict__
    root = self
    root.refreshTopObjects('cambridge.Dangle')
    sortdd = dataDict.get('dangleStores')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result
  
  def sortedDataLocationStores(self):
    """
    Sorted for memops.Implementation.MemopsRoot.dataLocationStores
    """
    dataDict = self.__dict__
    root = self
    root.refreshTopObjects('ccp.general.DataLocation')
    sortdd = dataDict.get('dataLocationStores')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result
  
  def sortedDatabases(self):
    """
    Sorted for memops.Implementation.MemopsRoot.databases
    """
    dataDict = self.__dict__
    root = self
    root.refreshTopObjects('ccp.general.DbRef')
    sortdd = dataDict.get('databases')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result
  
  def sortedExpBlueprintStores(self):
    """
    Sorted for memops.Implementation.MemopsRoot.expBlueprintStores
    """
    dataDict = self.__dict__
    root = self
    root.refreshTopObjects('ccp.lims.ExpBlueprint')
    sortdd = dataDict.get('expBlueprintStores')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result
  
  def sortedExperimentStores(self):
    """
    Sorted for memops.Implementation.MemopsRoot.experimentStores
    """
    dataDict = self.__dict__
    root = self
    root.refreshTopObjects('ccp.lims.Experiment')
    sortdd = dataDict.get('experimentStores')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result
  
  def sortedHaddockProjects(self):
    """
    Sorted for memops.Implementation.MemopsRoot.haddockProjects
    """
    dataDict = self.__dict__
    root = self
    root.refreshTopObjects('utrecht.Haddock')
    sortdd = dataDict.get('haddockProjects')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result
  
  def sortedHolderStores(self):
    """
    Sorted for memops.Implementation.MemopsRoot.holderStores
    """
    dataDict = self.__dict__
    root = self
    root.refreshTopObjects('ccp.lims.Holder')
    sortdd = dataDict.get('holderStores')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result
  
  def sortedInstrumentStores(self):
    """
    Sorted for memops.Implementation.MemopsRoot.instrumentStores
    """
    dataDict = self.__dict__
    root = self
    root.refreshTopObjects('ccp.general.Instrument')
    sortdd = dataDict.get('instrumentStores')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result
  
  def sortedKeywordDefinitionStores(self):
    """
    Sorted for memops.Implementation.MemopsRoot.keywordDefinitionStores
    """
    dataDict = self.__dict__
    root = self
    root.refreshTopObjects('ccp.general.KeywordDefinition')
    sortdd = dataDict.get('keywordDefinitionStores')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result
  
  def sortedLabeledMolecules(self):
    """
    Sorted for memops.Implementation.MemopsRoot.labeledMolecules
    """
    dataDict = self.__dict__
    root = self
    root.refreshTopObjects('ccp.molecule.LabeledMolecule')
    sortdd = dataDict.get('labeledMolecules')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result
  
  def sortedLabelingSchemes(self):
    """
    Sorted for memops.Implementation.MemopsRoot.labelingSchemes
    """
    dataDict = self.__dict__
    root = self
    root.refreshTopObjects('ccp.molecule.ChemCompLabel')
    sortdd = dataDict.get('labelingSchemes')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result
  
  def sortedLocationStores(self):
    """
    Sorted for memops.Implementation.MemopsRoot.locationStores
    """
    dataDict = self.__dict__
    root = self
    root.refreshTopObjects('ccp.lims.Location')
    sortdd = dataDict.get('locationStores')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result
  
  def sortedMethodStores(self):
    """
    Sorted for memops.Implementation.MemopsRoot.methodStores
    """
    dataDict = self.__dict__
    root = self
    root.refreshTopObjects('ccp.general.Method')
    sortdd = dataDict.get('methodStores')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result
  
  def sortedMolSystemSymmetrySets(self):
    """
    Sorted for memops.Implementation.MemopsRoot.molSystemSymmetrySets
    """
    dataDict = self.__dict__
    root = self
    root.refreshTopObjects('molsim.Symmetry')
    sortdd = dataDict.get('molSystemSymmetrySets')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result
  
  def sortedMolSystems(self):
    """
    Sorted for memops.Implementation.MemopsRoot.molSystems
    """
    dataDict = self.__dict__
    root = self
    root.refreshTopObjects('ccp.molecule.MolSystem')
    sortdd = dataDict.get('molSystems')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result
  
  def sortedMolecules(self):
    """
    Sorted for memops.Implementation.MemopsRoot.molecules
    """
    dataDict = self.__dict__
    root = self
    root.refreshTopObjects('ccp.molecule.Molecule')
    sortdd = dataDict.get('molecules')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result
  
  def sortedNameMappingStores(self):
    """
    Sorted for memops.Implementation.MemopsRoot.nameMappingStores
    """
    dataDict = self.__dict__
    root = self
    root.refreshTopObjects('ccpnmr.NameMapping')
    sortdd = dataDict.get('nameMappingStores')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result
  
  def sortedNmrCalcStores(self):
    """
    Sorted for memops.Implementation.MemopsRoot.nmrCalcStores
    """
    dataDict = self.__dict__
    root = self
    root.refreshTopObjects('ccp.nmr.NmrCalc')
    sortdd = dataDict.get('nmrCalcStores')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result
  
  def sortedNmrConstraintStores(self):
    """
    Sorted for memops.Implementation.MemopsRoot.nmrConstraintStores
    """
    dataDict = self.__dict__
    root = self
    root.refreshTopObjects('ccp.nmr.NmrConstraint')
    sortdd = dataDict.get('nmrConstraintStores')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result
  
  def sortedNmrEntryStores(self):
    """
    Sorted for memops.Implementation.MemopsRoot.nmrEntryStores
    """
    dataDict = self.__dict__
    root = self
    root.refreshTopObjects('ccp.nmr.NmrEntry')
    sortdd = dataDict.get('nmrEntryStores')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result
  
  def sortedNmrExpPrototypes(self):
    """
    Sorted for memops.Implementation.MemopsRoot.nmrExpPrototypes
    """
    dataDict = self.__dict__
    root = self
    root.refreshTopObjects('ccp.nmr.NmrExpPrototype')
    sortdd = dataDict.get('nmrExpPrototypes')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result
  
  def sortedNmrProjects(self):
    """
    Sorted for memops.Implementation.MemopsRoot.nmrProjects
    """
    dataDict = self.__dict__
    root = self
    root.refreshTopObjects('ccp.nmr.Nmr')
    sortdd = dataDict.get('nmrProjects')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result
  
  def sortedNmrReferenceStores(self):
    """
    Sorted for memops.Implementation.MemopsRoot.nmrReferenceStores
    """
    dataDict = self.__dict__
    root = self
    root.refreshTopObjects('ccp.nmr.NmrReference')
    sortdd = dataDict.get('nmrReferenceStores')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result
  
  def sortedNmrScreenStores(self):
    """
    Sorted for memops.Implementation.MemopsRoot.nmrScreenStores
    """
    dataDict = self.__dict__
    root = self
    root.refreshTopObjects('ccp.nmr.NmrScreen')
    sortdd = dataDict.get('nmrScreenStores')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result
  
  def sortedPackageLocators(self):
    """
    Sorted for memops.Implementation.MemopsRoot.packageLocators
    """
    dataDict = self.__dict__
    sortdd = dataDict.get('packageLocators')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result
  
  def sortedProtocolStores(self):
    """
    Sorted for memops.Implementation.MemopsRoot.protocolStores
    """
    dataDict = self.__dict__
    root = self
    root.refreshTopObjects('ccp.lims.Protocol')
    sortdd = dataDict.get('protocolStores')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result
  
  def sortedRefSampleComponentStores(self):
    """
    Sorted for memops.Implementation.MemopsRoot.refSampleComponentStores
    """
    dataDict = self.__dict__
    root = self
    root.refreshTopObjects('ccp.lims.RefSampleComponent')
    sortdd = dataDict.get('refSampleComponentStores')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result
  
  def sortedRepositories(self):
    """
    Sorted for memops.Implementation.MemopsRoot.repositories
    """
    dataDict = self.__dict__
    sortdd = dataDict.get('repositories')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result
  
  def sortedSampleStores(self):
    """
    Sorted for memops.Implementation.MemopsRoot.sampleStores
    """
    dataDict = self.__dict__
    root = self
    root.refreshTopObjects('ccp.lims.Sample')
    sortdd = dataDict.get('sampleStores')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result
  
  def sortedStereochemistryStores(self):
    """
    Sorted for memops.Implementation.MemopsRoot.stereochemistryStores
    """
    dataDict = self.__dict__
    root = self
    root.refreshTopObjects('ccp.molecule.Stereochemistry')
    sortdd = dataDict.get('stereochemistryStores')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result
  
  def sortedStructureEnsembles(self):
    """
    Sorted for memops.Implementation.MemopsRoot.structureEnsembles
    """
    dataDict = self.__dict__
    root = self
    root.refreshTopObjects('ccp.molecule.MolStructure')
    sortdd = dataDict.get('structureEnsembles')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result
  
  def sortedTargetStores(self):
    """
    Sorted for memops.Implementation.MemopsRoot.targetStores
    """
    dataDict = self.__dict__
    root = self
    root.refreshTopObjects('ccp.lims.Target')
    sortdd = dataDict.get('targetStores')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result
  
  def sortedTaxonomies(self):
    """
    Sorted for memops.Implementation.MemopsRoot.taxonomies
    """
    dataDict = self.__dict__
    root = self
    root.refreshTopObjects('ccp.general.Taxonomy')
    sortdd = dataDict.get('taxonomies')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result
  
  def sortedTopObjects(self):
    """
    Sorted for memops.Implementation.MemopsRoot.topObjects
    """
    dataDict = self.__dict__
    ll = self.getTopObjects()
    ll = [(repr(x),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result
  
  def sortedValidationStores(self):
    """
    Sorted for memops.Implementation.MemopsRoot.validationStores
    """
    dataDict = self.__dict__
    root = self
    root.refreshTopObjects('ccp.molecule.Validation')
    sortdd = dataDict.get('validationStores')
    
    ll = sortdd.keys()
    ll.sort()
    result = [sortdd[x] for x in ll]
    return result

  toDetailedString = ComplexDataType.toDetailedString
  
  def touch(self):
    """
    Set storage.isModified to True, so that the storage is saved at the next
    saveModified command. Fails if the storage is not loaded or not 
    modifiable.
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.touch:
       called on deleted object""" % self.qualifiedName
      )

    # NB must be done by direct access
    if not self.isLoaded:
      raise ApiError("Attempt to touch non-loaded TopObject %s" % self)
    
    if not self.isModifiable:
      raise ApiError("Attempt to touch non-modifiable TopObject %s" % self)
    
    dataDict['isModified'] = True
  
  accessControlOn = property(getAccessControlOn, setAccessControlOn, None,
  r"""Is access control active?
  """)

  className = ComplexDataType.className
  
  createdBy = property(getCreatedBy, setCreatedBy, None,
  r"""user who created TopObject.
  """)
  
  currentGroupName = property(getCurrentGroupName, setCurrentGroupName, None,
  r"""name of current group. Used for access control, record of who creates 
  and modifies objects, etc.
  """)
  
  currentUserId = property(getCurrentUserId, setCurrentUserId, None,
  r"""user Id for current user. Used for access control, record of who creates 
  and modifies objects, etc.
  """)

  fieldNames = ComplexDataType.fieldNames

  inConstructor = ComplexDataType.inConstructor

  isDeleted = MemopsObject.isDeleted
  
  isLoaded = property(getIsLoaded, None, None,
  r"""Implementation attribute, set automatically. True if the data in the 
  Storage are loaded into memory. As data are loaded automatically, this 
  attribute should be of interest only for the implementation.
  """)
  
  isModifiable = property(getIsModifiable, setIsModifiable, None,
  r"""True if the data corresponding to the storage may be modified. If 
  isModifiable is false for a given package, attemps to modify the data 
  will raise an error. Note that isModifiable can be set to true even if 
  the corresponding file is read-only. 
  
  For a Project, this atribute 
  defines whether the Implementation package (not the entire project 
  contents) can be modified. If the Implementation package is Read-Only, 
  this will prohibit many changes in the other packages as well.
  
  This 
  parameter can be freely modified by users, so it is not a security 
  feature, but rather a protection against accidental changes. 
  """)
  
  isModified = property(getIsModified, None, None,
  r"""Implementation attribute. True if the data corresponding to the Storage 
  have been modified since being loaded. Serves to indicate which data 
  need to be saved.
  """)
  
  isReading = property(getIsReading, None, None,
  r"""Implementation attribute, set automatically. True if the data 
  corresponding to the Storage are in the process of being read. As data 
  loading is handled automatically, this attribute should be relevant only 
  for the implementation, or possibly for programmers of multithreaded 
  programs. Serves to suppress notifiers and validity checking during 
  reading. Note that objects are not valid until the data loading is 
  completed.
  """)
  
  lastUnlockedBy = property(getLastUnlockedBy, setLastUnlockedBy, None,
  r"""User who last set TopObject.isModifiable to True.  Used to track if data 
  have been modified. Provided data have isModifiable set to False, any 
  modification in the underlying data will show up on lastUnlockedBy.
  """)

  metaclass = ComplexDataType.metaclass
  
  name = property(getName, setName, None,
  r"""Memops root name - used in naming files etc
  """)
  
  override = property(getOverride, setOverride, None,
  r"""Override switch - switches off validity and constraint checking. NB 
  anyone setting override takes reponsibility for unsetting it again and 
  ensuring that the final result is valid. It is strongly recommended to 
  check the validity of any changes afterwards. NBNB TBD we need to 
  prevent the storing of override=True data somehow.
  """)

  packageName = ComplexDataType.packageName

  packageShortName = ComplexDataType.packageShortName

  qualifiedName = ComplexDataType.qualifiedName
  
  accessControlStores = property(getAccessControlStores,  None, None,
  r"""child link
  """)
  
  activeRepositories = property(getActiveRepositories, None, None,
  r"""Repositories on package search path that contains a copy of TopObject
  """)
  
  affiliationStores = property(getAffiliationStores,  None, None,
  r"""child link
  """)
  
  analysisProfiles = property(getAnalysisProfiles,  None, None,
  r"""child link
  """)
  
  analysisProjects = property(getAnalysisProjects,  None, None,
  r"""child link
  """)
  
  annealProtocolStores = property(getAnnealProtocolStores,  None, None,
  r"""child link
  """)
  
  annotationStores = property(getAnnotationStores,  None, None,
  r"""child link
  """)
  
  chemCompCharges = property(getChemCompCharges,  None, None,
  r"""child link
  """)
  
  chemCompCoords = property(getChemCompCoords,  None, None,
  r"""child link
  """)
  
  chemComps = property(getChemComps,  None, None,
  r"""child link
  """)
  
  chemElementStores = property(getChemElementStores,  None, None,
  r"""child link
  """)
  
  citationStores = property(getCitationStores,  None, None,
  r"""child link
  """)
  
  classifications = property(getClassifications,  None, None,
  r"""child link
  """)
  
  crystallizationStores = property(getCrystallizationStores,  None, None,
  r"""child link
  """)
  
  currentAccessControlStore = property(getCurrentAccessControlStore, setCurrentAccessControlStore, None,
  r"""current accessControlStore - may be reset by implementation.
  """)
  
  currentAffiliationStore = property(getCurrentAffiliationStore, setCurrentAffiliationStore, None,
  r"""current affiliationStore - may be reset by implementation.
  """)
  
  currentAnalysisProfile = property(getCurrentAnalysisProfile, setCurrentAnalysisProfile, None,
  r"""current analysisProfile - may be reset by implementation.
  """)
  
  currentAnalysisProject = property(getCurrentAnalysisProject, setCurrentAnalysisProject, None,
  r"""current analysisProject - may be reset by implementation.
  """)
  
  currentAnnealProtocolStore = property(getCurrentAnnealProtocolStore, setCurrentAnnealProtocolStore, None,
  r"""current annealProtocolStore - may be reset by implementation.
  """)
  
  currentAnnotationStore = property(getCurrentAnnotationStore, setCurrentAnnotationStore, None,
  r"""current annotationStore - may be reset by implementation.
  """)
  
  currentChemComp = property(getCurrentChemComp, setCurrentChemComp, None,
  r"""current chemComp - may be reset by implementation.
  """)
  
  currentChemCompCharge = property(getCurrentChemCompCharge, setCurrentChemCompCharge, None,
  r"""current chemCompCharge - may be reset by implementation.
  """)
  
  currentChemCompCoord = property(getCurrentChemCompCoord, setCurrentChemCompCoord, None,
  r"""current chemCompCoord - may be reset by implementation.
  """)
  
  currentChemElementStore = property(getCurrentChemElementStore, setCurrentChemElementStore, None,
  r"""current chemElementStore - may be reset by implementation.
  """)
  
  currentCitationStore = property(getCurrentCitationStore, setCurrentCitationStore, None,
  r"""current citationStore - may be reset by implementation.
  """)
  
  currentClassification = property(getCurrentClassification, setCurrentClassification, None,
  r"""current classification - may be reset by implementation.
  """)
  
  currentCrystallizationStore = property(getCurrentCrystallizationStore, setCurrentCrystallizationStore, None,
  r"""current crystallizationStore - may be reset by implementation.
  """)
  
  currentDangleStore = property(getCurrentDangleStore, setCurrentDangleStore, None,
  r"""current dangleStore - may be reset by implementation.
  """)
  
  currentDataLocationStore = property(getCurrentDataLocationStore, setCurrentDataLocationStore, None,
  r"""current dataLocationStore - may be reset by implementation.
  """)
  
  currentDatabase = property(getCurrentDatabase, setCurrentDatabase, None,
  r"""current database - may be reset by implementation.
  """)
  
  currentExpBlueprintStore = property(getCurrentExpBlueprintStore, setCurrentExpBlueprintStore, None,
  r"""current expBlueprintStore - may be reset by implementation.
  """)
  
  currentExperimentStore = property(getCurrentExperimentStore, setCurrentExperimentStore, None,
  r"""current experimentStore - may be reset by implementation.
  """)
  
  currentHaddockProject = property(getCurrentHaddockProject, setCurrentHaddockProject, None,
  r"""current haddockProject - may be reset by implementation.
  """)
  
  currentHolderStore = property(getCurrentHolderStore, setCurrentHolderStore, None,
  r"""current holderStore - may be reset by implementation.
  """)
  
  currentInstrumentStore = property(getCurrentInstrumentStore, setCurrentInstrumentStore, None,
  r"""current instrumentStore - may be reset by implementation.
  """)
  
  currentKeywordDefinitionStore = property(getCurrentKeywordDefinitionStore, setCurrentKeywordDefinitionStore, None,
  r"""current keywordDefinitionStore - may be reset by implementation.
  """)
  
  currentLabeledMolecule = property(getCurrentLabeledMolecule, setCurrentLabeledMolecule, None,
  r"""current labeledMolecule - may be reset by implementation.
  """)
  
  currentLabelingScheme = property(getCurrentLabelingScheme, setCurrentLabelingScheme, None,
  r"""current labelingScheme - may be reset by implementation.
  """)
  
  currentLocationStore = property(getCurrentLocationStore, setCurrentLocationStore, None,
  r"""current locationStore - may be reset by implementation.
  """)
  
  currentMethodStore = property(getCurrentMethodStore, setCurrentMethodStore, None,
  r"""current methodStore - may be reset by implementation.
  """)
  
  currentMolSystem = property(getCurrentMolSystem, setCurrentMolSystem, None,
  r"""current molSystem - may be reset by implementation.
  """)
  
  currentMolSystemSymmetrySet = property(getCurrentMolSystemSymmetrySet, setCurrentMolSystemSymmetrySet, None,
  r"""current molSystemSymmetrySet - may be reset by implementation.
  """)
  
  currentMolecule = property(getCurrentMolecule, setCurrentMolecule, None,
  r"""current molecule - may be reset by implementation.
  """)
  
  currentNameMappingStore = property(getCurrentNameMappingStore, setCurrentNameMappingStore, None,
  r"""current nameMappingStore - may be reset by implementation.
  """)
  
  currentNmrCalcStore = property(getCurrentNmrCalcStore, setCurrentNmrCalcStore, None,
  r"""current nmrCalcStore - may be reset by implementation.
  """)
  
  currentNmrConstraintStore = property(getCurrentNmrConstraintStore, setCurrentNmrConstraintStore, None,
  r"""current nmrConstraintStore - may be reset by implementation.
  """)
  
  currentNmrEntryStore = property(getCurrentNmrEntryStore, setCurrentNmrEntryStore, None,
  r"""current nmrEntryStore - may be reset by implementation.
  """)
  
  currentNmrExpPrototype = property(getCurrentNmrExpPrototype, setCurrentNmrExpPrototype, None,
  r"""current nmrExpPrototype - may be reset by implementation.
  """)
  
  currentNmrProject = property(getCurrentNmrProject, setCurrentNmrProject, None,
  r"""current nmrProject - may be reset by implementation.
  """)
  
  currentNmrReferenceStore = property(getCurrentNmrReferenceStore, setCurrentNmrReferenceStore, None,
  r"""current nmrReferenceStore - may be reset by implementation.
  """)
  
  currentNmrScreenStore = property(getCurrentNmrScreenStore, setCurrentNmrScreenStore, None,
  r"""current nmrScreenStore - may be reset by implementation.
  """)
  
  currentProtocolStore = property(getCurrentProtocolStore, setCurrentProtocolStore, None,
  r"""current protocolStore - may be reset by implementation.
  """)
  
  currentRefSampleComponentStore = property(getCurrentRefSampleComponentStore, setCurrentRefSampleComponentStore, None,
  r"""current refSampleComponentStore - may be reset by implementation.
  """)
  
  currentSampleStore = property(getCurrentSampleStore, setCurrentSampleStore, None,
  r"""current sampleStore - may be reset by implementation.
  """)
  
  currentStereochemistryStore = property(getCurrentStereochemistryStore, setCurrentStereochemistryStore, None,
  r"""current stereochemistryStore - may be reset by implementation.
  """)
  
  currentStructureEnsemble = property(getCurrentStructureEnsemble, setCurrentStructureEnsemble, None,
  r"""current structureEnsemble - may be reset by implementation.
  """)
  
  currentTargetStore = property(getCurrentTargetStore, setCurrentTargetStore, None,
  r"""current targetStore - may be reset by implementation.
  """)
  
  currentTaxonomy = property(getCurrentTaxonomy, setCurrentTaxonomy, None,
  r"""current taxonomy - may be reset by implementation.
  """)
  
  currentValidationStore = property(getCurrentValidationStore, setCurrentValidationStore, None,
  r"""current validationStore - may be reset by implementation.
  """)
  
  dangleStores = property(getDangleStores,  None, None,
  r"""child link
  """)
  
  dataLocationStores = property(getDataLocationStores,  None, None,
  r"""child link
  """)
  
  databases = property(getDatabases,  None, None,
  r"""child link
  """)
  
  expBlueprintStores = property(getExpBlueprintStores,  None, None,
  r"""child link
  """)
  
  experimentStores = property(getExperimentStores,  None, None,
  r"""child link
  """)
  
  haddockProjects = property(getHaddockProjects,  None, None,
  r"""child link
  """)
  
  holderStores = property(getHolderStores,  None, None,
  r"""child link
  """)
  
  instrumentStores = property(getInstrumentStores,  None, None,
  r"""child link
  """)
  
  keywordDefinitionStores = property(getKeywordDefinitionStores,  None, None,
  r"""child link
  """)
  
  labeledMolecules = property(getLabeledMolecules,  None, None,
  r"""child link
  """)
  
  labelingSchemes = property(getLabelingSchemes,  None, None,
  r"""child link
  """)
  
  locationStores = property(getLocationStores,  None, None,
  r"""child link
  """)
  
  methodStores = property(getMethodStores,  None, None,
  r"""child link
  """)
  
  molSystemSymmetrySets = property(getMolSystemSymmetrySets,  None, None,
  r"""child link
  """)
  
  molSystems = property(getMolSystems,  None, None,
  r"""child link
  """)
  
  molecules = property(getMolecules,  None, None,
  r"""child link
  """)
  
  nameMappingStores = property(getNameMappingStores,  None, None,
  r"""child link
  """)
  
  nmrCalcStores = property(getNmrCalcStores,  None, None,
  r"""child link to class NmrCalcStore
  """)
  
  nmrConstraintStores = property(getNmrConstraintStores,  None, None,
  r"""child link
  """)
  
  nmrEntryStores = property(getNmrEntryStores,  None, None,
  r"""child link
  """)
  
  nmrExpPrototypes = property(getNmrExpPrototypes,  None, None,
  r"""child link
  """)
  
  nmrProjects = property(getNmrProjects,  None, None,
  r"""child link
  """)
  
  nmrReferenceStores = property(getNmrReferenceStores,  None, None,
  r"""child link
  """)
  
  nmrScreenStores = property(getNmrScreenStores,  None, None,
  r"""child link to class NmrScreenStore
  """)
  
  packageLocator = property(getPackageLocator, None, None,
  r"""Package locator relevant for MemopsRoot
  """)
  
  packageLocators = property(getPackageLocators,  None, None,
  r"""child link to class PackageLocator
  """)
  
  parent = property(getParent, None, None,
  r"""link to parent object - returns None
  """)
  
  protocolStores = property(getProtocolStores,  None, None,
  r"""child link
  """)
  
  refSampleComponentStores = property(getRefSampleComponentStores,  None, None,
  r"""child link
  """)
  
  repositories = property(getRepositories,  None, None,
  r"""child link to class Repository
  """)

  root = MemopsObject.root
  
  sampleStores = property(getSampleStores,  None, None,
  r"""child link
  """)
  
  stereochemistryStores = property(getStereochemistryStores,  None, None,
  r"""child link
  """)
  
  structureEnsembles = property(getStructureEnsembles,  None, None,
  r"""child link
  """)
  
  targetStores = property(getTargetStores,  None, None,
  r"""child link
  """)
  
  taxonomies = property(getTaxonomies,  None, None,
  r"""child link to class Taxonomy
  """)

  topObject = ImplementationObject.topObject
  
  topObjects = property(getTopObjects, None, None,
  r"""All TopObjects of whatever kind (not including MemopsRoot)
  """)
  
  validationStores = property(getValidationStores,  None, None,
  r"""child link
  """)

###############################################################################
class PackageLocator(ImplementationObject):
  r"""Storage locations for one or more packages
  """
  #   from data model element memops.Implementation.PackageLocator revision 1.40
  _metaclass = metaPackage.getElement('PackageLocator')
  _packageName = 'memops.Implementation'
  _packageShortName = 'IMPL'
  _fieldNames = ('className', 'fieldNames', 'inConstructor', 'isDeleted', 'metaclass', 'packageName', 'packageShortName', 'qualifiedName', 'targetName', 'memopsRoot', 'parent', 'repositories', 'root', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for memops.Implementation.PackageLocator
    """
    dataDict = self.__dict__
    dataDict['memopsRoot'] = parent
    if (not isinstance(parent, MemopsRoot)):
      raise ApiError("""%s.__init__:
       value is not of class memops.Implementation.MemopsRoot""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = parent.__dict__.get('topObject')
    dataDict['topObject'] = topObject

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    if (notIsReading):
      if (not (topObject.__dict__.get('isModifiable'))):
        raise ApiError("""%s.__init__:
         Storage not modifiable""" % self.qualifiedName
         + ": %s" % (topObject,)
        )

    try:

      dataDict['targetName'] = 'any'
      dataDict['repositories'] = list()

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in memops.Implementation.PackageLocator.__init__"
        del dataDict['inConstructor']
        raise

      if (notIsReading):
        childrenDict = parent.__dict__.get('packageLocators')
        objKey = dataDict.get('targetName')
        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['targetName'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notOverride):
        self.checkValid()

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for memops.Implementation.PackageLocator:
       determines 
    cascading deletes to follow from delete of object.
       *Implementation 
    function* - should be called only by API delete function.
    """
    dataDict = self.__dict__
    objsToBeDeleted.add(self)
    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for memops.Implementation.PackageLocator:   deletes
    objects
    *Implementation function* - will CORRUPT DATA if called outside 
    the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    for repository in dataDict.get('repositories'):
      if (not (repository in objsToBeDeleted)):
        stored = repository.__dict__.get('stored')
        stored.remove(self)

    memopsRoot = dataDict.get('memopsRoot')
    if (not (memopsRoot in objsToBeDeleted)):
      objKey = dataDict.get('targetName')
      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = memopsRoot.__dict__.get('packageLocators')
        if (self is dd.get(objKey)):
          del dd[objKey]

  def addRepository(self, value):
    """
    Add for memops.Implementation.PackageLocator.repositories
    """
    dataDict = self.__dict__
    if (not isinstance(value, Repository)):
      raise ApiError("""%s.addRepository:
       value is not of class memops.Implementation.Repository""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('repositories')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.addRepository:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.addRepository:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.addRepository:
       called with deleted value""" % self.qualifiedName
      )

    if (value in currentValues):
      raise ApiError("""%s.addRepository:
       value is in list already""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.addRepository:
           Link repositories between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      if (notInConstructor):
        if (value is not None):
          if (not (value.name  != 'backup')):
            raise ApiError("""%s.addRepository:
             repositories constraint value_is_not_backup_repository violated by value""" % self.qualifiedName
             + ": %s" % (value,)
            )

    oldSelves = value.__dict__.get('stored')
    oldSelves.add(self)
    currentValues.append(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('addRepository')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def checkAllValid(self, complete=False):
    """
    CheckAllValid for memops.Implementation.PackageLocator
    """
    dataDict = self.__dict__
    self.checkValid(complete)
  
  def checkValid(self, complete=False):
    """
    CheckValid for memops.Implementation.PackageLocator
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      objKey = dataDict.get('targetName')
      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('memopsRoot')
        dd = value.__dict__.get('packageLocators')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'memopsRoot' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      # check attributes
      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('targetName')
      if (isinstance(value, String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: targetName:
         memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 32):
        raise ApiError("""%s.checkValid: targetName:
         memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: targetName:
         memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.checkValid: targetName:
         Word constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      # check roles
      value = dataDict.get('memopsRoot')
      if (not isinstance(value, MemopsRoot)):
        raise ApiError("""%s.checkValid: memopsRoot:
         value is not of class memops.Implementation.MemopsRoot""" % self.qualifiedName
         + ": %s" % (value,)
        )

      values = dataDict.get('repositories')
      for value in values:
        if (not isinstance(value, Repository)):
          raise ApiError("""%s.checkValid: repositories:
           value is not of class memops.Implementation.Repository""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('stored')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: repositories:
           non-reciprocal link repositories from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.checkValid: repositories:
           Link repositories between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

    # check explicit class constraints
    # check attributes
    value = dataDict.get('targetName')
    if (value is None):
      raise ApiError("""%s.checkValid: targetName:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    # check roles
    value = dataDict.get('memopsRoot')
    if (value is None):
      raise ApiError("""%s.checkValid: memopsRoot:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    values = dataDict.get('repositories')
    if (len(values) < 1):
      raise ApiError("""%s.checkValid: repositories:
       locard: values must be of length >= 1""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      if (not (value.name  != 'backup')):
        raise ApiError("""%s.checkValid: repositories:
         repositories constraint value_is_not_backup_repository violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

  def delete(self):
    """
    FullDelete for memops.Implementation.PackageLocator
    """
    dataDict = self.__dict__
    topObject = dataDict.get('topObject')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    # objects to be deleted
    objsToBeDeleted = set()
    # objects still to be checked for cascading delete (each object to be deleted gets checked)
    objsToBeChecked = list()
    # counter keyed on (obj, roleName) for how many objects at other end of link are to be deleted
    linkCounter = {}

    # topObjects to check if modifiable
    topObjectsToCheck = set()

    objsToBeChecked.append(self)
    while len(objsToBeChecked) > 0:
      obj = objsToBeChecked.pop()
      obj._checkDelete(objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck)

    if (notInConstructor):
      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.delete:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.delete:
       called on deleted object""" % self.qualifiedName
      )

    for obj in objsToBeDeleted:
      obj._singleDelete(objsToBeDeleted)

    for topObjectModify in topObjectsToCheck:
      if (not (topObjectModify.__dict__.get('isLoaded'))):
        topObjectModify.load()

      topObjectModify.__dict__['isModified'] = True

    if (notOverride):
      if (notInConstructor):

        # doNotifies
        
        for obj in objsToBeDeleted:
          for notify in obj.__class__._notifies.get('delete', ()):
            notify(obj)

  def findAllRepositories(self, **conditions):
    """
    FindAll for memops.Implementation.PackageLocator.repositories
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('repositories')
      result = list(currentValues)

    else:
      currentValues = dataDict.get('repositories')
      result = list()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('format', 'name', 'url', 'memopsRoot',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.append(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result.append(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result.append(v)

    return result
  
  def findFirstRepository(self, **conditions):
    """
    FindFirst for memops.Implementation.PackageLocator.repositories
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('repositories')
      if (currentValues):
        result = currentValues[0]
      else:
        result = None

    else:
      currentValues = dataDict.get('repositories')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('format', 'name', 'url', 'memopsRoot',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result = v; break

    return result
  
  def get(self, name):
    """
    GetAttr for memops.Implementation.PackageLocator
    """
    dataDict = self.__dict__
    return getattr(self, name)
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for memops.Implementation.PackageLocator
    """

    result = None
    if (1 != len(fullKey)):
      raise ApiError("""'memops.Implementation.PackageLocator'.getByKey:
       getByKey called with fullKey of wrong length. Parameters:"""
       + ": %s:%s" % (startObj, fullKey)
      )

    objKey = fullKey[0]
    obj1 = startObj.__dict__.get('packageLocators').get(objKey)
    result = obj1
    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = MemopsObject.getByNavigation

  getClassName = ComplexDataType.getClassName

  getExpandedKey = MemopsObject.getExpandedKey

  getFieldNames = ComplexDataType.getFieldNames
  
  def getFullKey(self, useGuid=False):
    """
    GetFullKey for memops.Implementation.PackageLocator
    """
    dataDict = self.__dict__
    result = list()

    result.append(dataDict.get('targetName'))

    return result

  getInConstructor = ComplexDataType.getInConstructor

  getIsDeleted = MemopsObject.getIsDeleted
  
  def getLocalKey(self):
    """
    GetLocalKey for memops.Implementation.PackageLocator
    """
    dataDict = self.__dict__
    result = dataDict.get('targetName')
    return result
  
  def getMemopsRoot(self):
    """
    Get for memops.Implementation.PackageLocator.memopsRoot
    """
    dataDict = self.__dict__
    result = dataDict.get('memopsRoot')
    return result

  getMetaclass = ComplexDataType.getMetaclass

  getPackageName = ComplexDataType.getPackageName

  getPackageShortName = ComplexDataType.getPackageShortName
  
  def getParent(self):
    """
    Get for memops.Implementation.PackageLocator.parent
    """
    dataDict = self.__dict__
    result = dataDict.get('memopsRoot')
    return result

  getQualifiedName = ComplexDataType.getQualifiedName
  
  def getRepositories(self):
    """
    Get for memops.Implementation.PackageLocator.repositories
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('repositories')
    result = tuple(tempVar)
    return result

  getRoot = MemopsObject.getRoot
  
  def getTargetName(self):
    """
    Get for memops.Implementation.PackageLocator.targetName
    """
    dataDict = self.__dict__
    result = dataDict.get('targetName')
    return result

  getTopObject = ImplementationObject.getTopObject
  
  def removeRepository(self, value):
    """
    Remove for memops.Implementation.PackageLocator.repositories
    """
    dataDict = self.__dict__
    if (not isinstance(value, Repository)):
      raise ApiError("""%s.removeRepository:
       value is not of class memops.Implementation.Repository""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('repositories')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.removeRepository:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.removeRepository:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.removeRepository:
       called with deleted value""" % self.qualifiedName
      )

    if (not (value in currentValues)):
      raise ApiError("""%s.removeRepository:
       value not in list""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      if (len(currentValues) < (1 + 1)):
        raise ApiError("""%s.removeRepository:
         locard: currentValues: cannot remove value""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    oldSelves = value.__dict__.get('stored')
    oldSelves.remove(self)
    currentValues.remove(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('removeRepository')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def set(self, name, value):
    """
    SetAttr for memops.Implementation.PackageLocator
    """
    dataDict = self.__dict__
    setattr(self, name, value)
  
  def setRepositories(self, values):
    """
    Set for memops.Implementation.PackageLocator.repositories
    """
    dataDict = self.__dict__
    xx = set(values)
    values = list(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setRepositories:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      if (not isinstance(value, Repository)):
        raise ApiError("""%s.setRepositories:
         value is not of class memops.Implementation.Repository""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('repositories')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setRepositories:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setRepositories:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setRepositories:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      if (len(values) < 1):
        raise ApiError("""%s.setRepositories:
         locard: values must be of length >= 1""" % self.qualifiedName
         + ": %s" % (self,)
        )

      xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
      for value in values:
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setRepositories:
           Link repositories between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      if (notInConstructor):
        for value in values:
          if (not (value.name  != 'backup')):
            raise ApiError("""%s.setRepositories:
             repositories constraint value_is_not_backup_repository violated by value""" % self.qualifiedName
             + ": %s" % (value,)
            )

    for cv in currentValues:
      if (not (cv in values)):
        oldSelves = cv.__dict__.get('stored')
        oldSelves.remove(self)

    for cv in values:
      if (not (cv in currentValues)):
        oldSelves = cv.__dict__.get('stored')
        oldSelves.add(self)

    dataDict['repositories'] = values
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setRepositories')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setTargetName(self, value):
    """
    Set for memops.Implementation.PackageLocator.targetName
    """
    dataDict = self.__dict__
    if (isinstance(value, String.PythonType)):
      pass
    else:
      raise ApiError("""%s.setTargetName:
       memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 32):
      raise ApiError("""%s.setTargetName:
       memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.setTargetName:
       memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.split()) == 1)):
      raise ApiError("""%s.setTargetName:
       Word constraint contains_no_white_space violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('targetName')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setTargetName:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setTargetName:
         cannot set targetName, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setTargetName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['targetName'] = value

    # doNotifies

  toDetailedString = ComplexDataType.toDetailedString

  className = ComplexDataType.className

  fieldNames = ComplexDataType.fieldNames

  inConstructor = ComplexDataType.inConstructor

  isDeleted = MemopsObject.isDeleted

  metaclass = ComplexDataType.metaclass

  packageName = ComplexDataType.packageName

  packageShortName = ComplexDataType.packageShortName

  qualifiedName = ComplexDataType.qualifiedName
  
  targetName = property(getTargetName, setTargetName, None,
  r"""Qualified name of relevant package. If set to 'any' covers all packages 
  that do not have  a specific PackageLocator.
  """)
  
  memopsRoot = property(getMemopsRoot,  None, None,
  r"""parent link
  """)
  
  parent = property(getParent, None, None,
  r"""link to parent object - synonym for memopsRoot
  """)
  
  repositories = property(getRepositories, setRepositories, None,
  r"""repositories to search for data for packageLocaator packages - ordered 
  to form a search path
  """)

  root = MemopsObject.root

  topObject = ImplementationObject.topObject

###############################################################################
class Repository(ImplementationObject):
  r"""Data repository - database, directory, or server, where data are stored
  """
  #   from data model element memops.Implementation.Repository revision 1.57
  _metaclass = metaPackage.getElement('Repository')
  _packageName = 'memops.Implementation'
  _packageShortName = 'IMPL'
  _fieldNames = ('className', 'fieldNames', 'format', 'inConstructor', 'isDeleted', 'metaclass', 'name', 'packageName', 'packageShortName', 'qualifiedName', 'url', 'memopsRoot', 'parent', 'root', 'stored', 'topObject',)
  
  _notifies = {'':[]}
  
  def __init__(self, parent, **attrlinks):
    """
    Constructor for memops.Implementation.Repository
    """
    dataDict = self.__dict__
    dataDict['memopsRoot'] = parent
    if (not isinstance(parent, MemopsRoot)):
      raise ApiError("""%s.__init__:
       value is not of class memops.Implementation.MemopsRoot""" % self.qualifiedName
       + ": %s" % (parent,)
      )

    if (parent.__dict__.get('isDeleted')):
      raise ApiError("""%s.__init__:
       called with deleted parent""" % self.qualifiedName
      )

    topObject = parent.__dict__.get('topObject')
    dataDict['topObject'] = topObject

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    if (notIsReading):
      if (not (topObject.__dict__.get('isModifiable'))):
        raise ApiError("""%s.__init__:
         Storage not modifiable""" % self.qualifiedName
         + ": %s" % (topObject,)
        )

    try:

      dataDict['format'] = 'xml'
      dataDict['name'] = None
      dataDict['url'] = None
      dataDict['stored'] = set()

      dataDict['inConstructor'] = True
      try:
        
        for key, value in attrlinks.iteritems():
          try:
            func = getattr(self.__class__, key).fset
          except:
            raise ApiError("%s: error setting %s - not a modeled attribute"
                           % (self, key))
          if func is None:
            raise ApiError("%s: error setting %s - not a settable attribute"
                           % (self, key))
          else:
            func(self, value)
        del dataDict['inConstructor']
      except:
        print "ERROR in memops.Implementation.Repository.__init__"
        del dataDict['inConstructor']
        raise

      if (notIsReading):
        childrenDict = parent.__dict__.get('repositories')
        objKey = dataDict.get('name')
        if (objKey is None):
          raise ApiError("""%s.__init__:
           Key attribute or link not set (from ['name'])""" % self.qualifiedName
           + ": %s" % (self,)
          )
        else:
          if (childrenDict.get(objKey) is None):
            childrenDict[objKey] = self
          else:
            raise ApiError("""%s.__init__:
             Could not create, pre-existing object had same key""" % self.qualifiedName
             + ": %s" % (self,)
            )

      if (notOverride):
        self.checkValid()

      if (notIsReading):
        topObject.__dict__['isModified'] = True

    except:
      import sys
      exc_info = sys.exc_info()
      try:
        dataDict['inConstructor'] = True
        self.delete()
        del dataDict['inConstructor']
      except:
        print '''WARNING Error in clean-up of incorrectly created object. 
        Data may be left in an illegal state'''
        del dataDict['inConstructor']
      raise exc_info[0], exc_info[1], exc_info[2]

    # doNotifies

    if (notOverride):
      
      ll = self.__class__._notifies.get('__init__')
      if ll:
        for notify in ll:
          notify(self)

  def _checkDelete(self, objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck):
    """
    checkDelete for memops.Implementation.Repository:
       determines 
    cascading deletes to follow from delete of object.
       *Implementation 
    function* - should be called only by API delete function.
    """
    dataDict = self.__dict__
    objsToBeDeleted.add(self)
    stored_s = dataDict.get('stored')
    for stored in stored_s:
      if (not (stored in objsToBeDeleted)):
        backlink = stored.__dict__.get('repositories')
        key = (stored, 'repositories')
        nFound = linkCounter.get(key)
        if (nFound is None):
          nFound = 1
        else:
          nFound = nFound + 1
          del linkCounter[key]

        if (len(backlink) - nFound < 1):
          objsToBeDeleted.add(stored)
          objsToBeChecked.append(stored)
        else:
          linkCounter[key] = nFound

    topObject = dataDict.get('topObject')
    topObjectsToCheck.add(topObject)
  
  def _singleDelete(self, objsToBeDeleted):
    """
    singleDelete for memops.Implementation.Repository:   deletes
    objects
    *Implementation function* - will CORRUPT DATA if called outside 
    the API delete function.
    """
    dataDict = self.__dict__
    dataDict['isDeleted'] = True
    for stored in dataDict.get('stored'):
      if (not (stored in objsToBeDeleted)):
        repositories = stored.__dict__.get('repositories')
        repositories.remove(self)

    memopsRoot = dataDict.get('memopsRoot')
    if (not (memopsRoot in objsToBeDeleted)):
      objKey = dataDict.get('name')
      if (objKey is None):
        raise ApiError("""%s._singleDelete:
         Key could not be calculated for object to be deleted""" % self.qualifiedName
        )
      else:
        dd = memopsRoot.__dict__.get('repositories')
        if (self is dd.get(objKey)):
          del dd[objKey]

  def addStored(self, value):
    """
    Add for memops.Implementation.Repository.stored
    """
    dataDict = self.__dict__
    if (not isinstance(value, PackageLocator)):
      raise ApiError("""%s.addStored:
       value is not of class memops.Implementation.PackageLocator""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('stored')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.addStored:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.addStored:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.addStored:
       called with deleted value""" % self.qualifiedName
      )

    if (value in currentValues):
      raise ApiError("""%s.addStored:
       value is in list already""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      if (value is not None):
        xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.addStored:
           Link stored between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      if (notInConstructor):
        if (value is not None):
          (self, value) = (value, self)
          if (not (value.name  != 'backup')):
            raise ApiError("""%s.addStored:
             repositories constraint value_is_not_backup_repository violated by value""" % self.qualifiedName
             + ": %s" % (value,)
            )

          (value, self) = (self, value)

    oldSelves = value.__dict__.get('repositories')
    oldSelves.append(self)
    currentValues.add(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('addStored')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def checkAllValid(self, complete=False):
    """
    CheckAllValid for memops.Implementation.Repository
    """
    dataDict = self.__dict__
    self.checkValid(complete)
  
  def checkValid(self, complete=False):
    """
    CheckValid for memops.Implementation.Repository
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.checkValid:
       called on deleted object""" % self.qualifiedName
      )

    if (complete):
      objKey = dataDict.get('name')
      if (objKey is None):
        raise ApiError("""%s.checkValid:
         Key could not be calculated for object""" % self.qualifiedName
         + ": %s" % (self,)
        )
      else:
        value = dataDict.get('memopsRoot')
        dd = value.__dict__.get('repositories')
        if (not (self is dd.get(objKey))):
          raise ApiError("""%s.checkValid:
           non-reciprocal parent link 'memopsRoot' from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

      # check attributes
      value = dataDict.get('format')
      if (not (value in ['xml', 'sql'])):
        raise ApiError("""%s.checkValid: format:
         memops.Implementation.StorageFormat input is not in enumeration ['xml', 'sql']""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.checkValid: format:
         StorageFormat constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('name')
      if (isinstance(value, String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: name:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: name:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: name:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: name:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = self.getQualifiedName()
      if (value is None):
        raise ApiError("""%s.checkValid: qualifiedName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (isinstance(value, String.PythonType)):
        pass
      else:
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 80):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.checkValid: qualifiedName:
         memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.splitlines()) <= 1)):
        raise ApiError("""%s.checkValid: qualifiedName:
         Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      value = dataDict.get('url')
      if (not isinstance(value, Url)):
        raise ApiError("""%s.checkValid: url:
         value is not of class memops.Implementation.Url""" % self.qualifiedName
         + ": %s" % (value,)
        )

      # check roles
      value = dataDict.get('memopsRoot')
      if (not isinstance(value, MemopsRoot)):
        raise ApiError("""%s.checkValid: memopsRoot:
         value is not of class memops.Implementation.MemopsRoot""" % self.qualifiedName
         + ": %s" % (value,)
        )

      values = dataDict.get('stored')
      for value in values:
        if (not isinstance(value, PackageLocator)):
          raise ApiError("""%s.checkValid: stored:
           value is not of class memops.Implementation.PackageLocator""" % self.qualifiedName
           + ": %s" % (value,)
          )

        oldSelves = value.__dict__.get('repositories')
        if (not (self in oldSelves)):
          raise ApiError("""%s.checkValid: stored:
           non-reciprocal link stored from object""" % self.qualifiedName
           + ": %s" % (self,)
          )

    # check explicit class constraints
    # check attributes
    value = dataDict.get('format')
    if (value is None):
      raise ApiError("""%s.checkValid: format:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('name')
    if (value is None):
      raise ApiError("""%s.checkValid: name:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value = dataDict.get('url')
    if (value is None):
      raise ApiError("""%s.checkValid: url:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    value.checkAllValid(complete)
    # check roles
    value = dataDict.get('memopsRoot')
    if (value is None):
      raise ApiError("""%s.checkValid: memopsRoot:
       value cannot be None""" % self.qualifiedName
       + ": %s" % (self,)
      )

    values = dataDict.get('stored')
    for value in values:
      (self, value) = (value, self)
      if (not (value.name  != 'backup')):
        raise ApiError("""%s.checkValid: stored:
         repositories constraint value_is_not_backup_repository violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      (value, self) = (self, value)

  def delete(self):
    """
    FullDelete for memops.Implementation.Repository
    """
    dataDict = self.__dict__
    topObject = dataDict.get('topObject')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)

    # objects to be deleted
    objsToBeDeleted = set()
    # objects still to be checked for cascading delete (each object to be deleted gets checked)
    objsToBeChecked = list()
    # counter keyed on (obj, roleName) for how many objects at other end of link are to be deleted
    linkCounter = {}

    # topObjects to check if modifiable
    topObjectsToCheck = set()

    objsToBeChecked.append(self)
    while len(objsToBeChecked) > 0:
      obj = objsToBeChecked.pop()
      obj._checkDelete(objsToBeDeleted, objsToBeChecked, linkCounter, topObjectsToCheck)

    if (notInConstructor):
      for topObjectToCheck in topObjectsToCheck:
        if (not (topObjectToCheck.__dict__.get('isModifiable'))):
          raise ApiError("""%s.delete:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObjectToCheck,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.delete:
       called on deleted object""" % self.qualifiedName
      )

    for obj in objsToBeDeleted:
      obj._singleDelete(objsToBeDeleted)

    for topObjectModify in topObjectsToCheck:
      if (not (topObjectModify.__dict__.get('isLoaded'))):
        topObjectModify.load()

      topObjectModify.__dict__['isModified'] = True

    if (notOverride):
      if (notInConstructor):

        # doNotifies
        
        for obj in objsToBeDeleted:
          for notify in obj.__class__._notifies.get('delete', ()):
            notify(obj)

  def findAllStored(self, **conditions):
    """
    FindAll for memops.Implementation.Repository.stored
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('stored')
      result = set(currentValues)

    else:
      currentValues = dataDict.get('stored')
      result = set()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('targetName', 'memopsRoot',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.add(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result.add(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result.add(v)

    return result
  
  def findFirstStored(self, **conditions):
    """
    FindFirst for memops.Implementation.Repository.stored
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = dataDict.get('stored')
      if (currentValues):
        result = iter(currentValues).next()
      else:
        result = None

    else:
      currentValues = dataDict.get('stored')
      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('targetName', 'memopsRoot',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result = v; break

    return result
  
  def get(self, name):
    """
    GetAttr for memops.Implementation.Repository
    """
    dataDict = self.__dict__
    return getattr(self, name)
  
  def getByKey(startObj, fullKey):
    """
    GetByKey for memops.Implementation.Repository
    """

    result = None
    if (1 != len(fullKey)):
      raise ApiError("""'memops.Implementation.Repository'.getByKey:
       getByKey called with fullKey of wrong length. Parameters:"""
       + ": %s:%s" % (startObj, fullKey)
      )

    objKey = fullKey[0]
    obj1 = startObj.__dict__.get('repositories').get(objKey)
    result = obj1
    return result

  getByKey = staticmethod(getByKey)

  getByNavigation = MemopsObject.getByNavigation

  getClassName = ComplexDataType.getClassName

  getExpandedKey = MemopsObject.getExpandedKey

  getFieldNames = ComplexDataType.getFieldNames
  
  def getFileLocation(self, packageName):
    """
    get absolute file location for TopObject in repository
    """
    dataDict = self.__dict__
    url = self.url
    protocol = url.protocol
    
    if protocol == 'file':
      from memops.universal import Io as uniIo
      result = uniIo.joinPath(url.getDataLocation(), *packageName.split('.'))
    
    else:
      raise ApiError("getFileLocation not implemented for url.protocol == '%s'" % protocol)
    return result
  
  def getFormat(self):
    """
    Get for memops.Implementation.Repository.format
    """
    dataDict = self.__dict__
    result = dataDict.get('format')
    return result
  
  def getFullKey(self, useGuid=False):
    """
    GetFullKey for memops.Implementation.Repository
    """
    dataDict = self.__dict__
    result = list()

    result.append(dataDict.get('name'))

    return result

  getInConstructor = ComplexDataType.getInConstructor

  getIsDeleted = MemopsObject.getIsDeleted
  
  def getLocalKey(self):
    """
    GetLocalKey for memops.Implementation.Repository
    """
    dataDict = self.__dict__
    result = dataDict.get('name')
    return result
  
  def getMemopsRoot(self):
    """
    Get for memops.Implementation.Repository.memopsRoot
    """
    dataDict = self.__dict__
    result = dataDict.get('memopsRoot')
    return result

  getMetaclass = ComplexDataType.getMetaclass
  
  def getName(self):
    """
    Get for memops.Implementation.Repository.name
    """
    dataDict = self.__dict__
    result = dataDict.get('name')
    return result

  getPackageName = ComplexDataType.getPackageName

  getPackageShortName = ComplexDataType.getPackageShortName
  
  def getParent(self):
    """
    Get for memops.Implementation.Repository.parent
    """
    dataDict = self.__dict__
    result = dataDict.get('memopsRoot')
    return result

  getQualifiedName = ComplexDataType.getQualifiedName

  getRoot = MemopsObject.getRoot
  
  def getStored(self):
    """
    Get for memops.Implementation.Repository.stored
    """
    dataDict = self.__dict__
    tempVar = dataDict.get('stored')
    result = frozenset(tempVar)
    return result

  getTopObject = ImplementationObject.getTopObject
  
  def getUrl(self):
    """
    Get for memops.Implementation.Repository.url
    """
    dataDict = self.__dict__
    result = dataDict.get('url')
    return result
  
  def removeStored(self, value):
    """
    Remove for memops.Implementation.Repository.stored
    """
    dataDict = self.__dict__
    if (not isinstance(value, PackageLocator)):
      raise ApiError("""%s.removeStored:
       value is not of class memops.Implementation.PackageLocator""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('stored')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.removeStored:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.removeStored:
       called on deleted object""" % self.qualifiedName
      )

    if (value.__dict__.get('isDeleted')):
      raise ApiError("""%s.removeStored:
       called with deleted value""" % self.qualifiedName
      )

    if (not (value in currentValues)):
      raise ApiError("""%s.removeStored:
       value not in list""" % self.qualifiedName
       + ": %s" % (self,)
      )

    if (notOverride):
      oldSelves = value.__dict__.get('repositories')
      if (len(oldSelves) < (1 + 1)):
        raise ApiError("""%s.removeStored:
         locard: oldSelves: cannot remove value""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    oldSelves = value.__dict__.get('repositories')
    oldSelves.remove(self)
    currentValues.remove(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('removeStored')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def set(self, name, value):
    """
    SetAttr for memops.Implementation.Repository
    """
    dataDict = self.__dict__
    setattr(self, name, value)
  
  def setFormat(self, value):
    """
    Set for memops.Implementation.Repository.format
    """
    dataDict = self.__dict__
    if (not (value in ['xml', 'sql'])):
      raise ApiError("""%s.setFormat:
       memops.Implementation.StorageFormat input is not in enumeration ['xml', 'sql']""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.split()) == 1)):
      raise ApiError("""%s.setFormat:
       StorageFormat constraint contains_no_white_space violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('format')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setFormat:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setFormat:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setFormat:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['format'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setFormat')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setName(self, value):
    """
    Set for memops.Implementation.Repository.name
    """
    dataDict = self.__dict__
    if (isinstance(value, String.PythonType)):
      pass
    else:
      raise ApiError("""%s.setName:
       memops.Implementation.Line input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 80):
      raise ApiError("""%s.setName:
       memops.Implementation.Line maximum length is 80 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.setName:
       memops.Implementation.Line: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.splitlines()) <= 1)):
      raise ApiError("""%s.setName:
       Line constraint contains_no_linebreak violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('name')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setName:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setName:
         cannot set name, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setName:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['name'] = value

    # doNotifies
  
  def setStored(self, values):
    """
    Set for memops.Implementation.Repository.stored
    """
    dataDict = self.__dict__
    xx = values
    values = set(values)
    if (len(values) != len(xx)):
      raise ApiError("""%s.setStored:
       values may not contain duplicates""" % self.qualifiedName
       + ": %s" % (self,)
      )

    for value in values:
      if (not isinstance(value, PackageLocator)):
        raise ApiError("""%s.setStored:
         value is not of class memops.Implementation.PackageLocator""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    currentValues = dataDict.get('stored')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setStored:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setStored:
       called on deleted object""" % self.qualifiedName
      )

    for obj in values:
      if (obj.__dict__.get('isDeleted')):
        raise ApiError("""%s.setStored:
         an object in values is deleted""" % self.qualifiedName
        )

    if (values == currentValues):
      return

    if (notOverride):
      for cv in currentValues:
        if (not (cv in values)):
          oldSelves = cv.__dict__.get('repositories')
          if (len(oldSelves) < (1 + 1)):
            raise ApiError("""%s.setStored:
             locard: oldSelves: cannot remove value""" % self.qualifiedName
             + ": %s" % (self,)
            )

      xx1 = dataDict.get('topObject').__dict__.get('memopsRoot')
      for value in values:
        yy1 = value.__dict__.get('topObject').__dict__.get('memopsRoot')
        if (not (xx1 is yy1)):
          raise ApiError("""%s.setStored:
           Link stored between objects from separate partitions
           - memops.Implementation.MemopsRoot does not match""" % self.qualifiedName
           + ": %s:%s" % (self, value)
          )

      if (notInConstructor):
        for value in values:
          (self, value) = (value, self)
          if (not (value.name  != 'backup')):
            raise ApiError("""%s.setStored:
             repositories constraint value_is_not_backup_repository violated by value""" % self.qualifiedName
             + ": %s" % (value,)
            )

          (value, self) = (self, value)

    for cv in currentValues:
      if (not (cv in values)):
        oldSelves = cv.__dict__.get('repositories')
        oldSelves.remove(self)

    for cv in values:
      if (not (cv in currentValues)):
        oldSelves = cv.__dict__.get('repositories')
        oldSelves.append(self)

    dataDict['stored'] = values
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setStored')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setUrl(self, value):
    """
    Set for memops.Implementation.Repository.url
    """
    dataDict = self.__dict__
    if (not isinstance(value, Url)):
      raise ApiError("""%s.setUrl:
       value is not of class memops.Implementation.Url""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    currentValue = dataDict.get('url')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (notIsReading):
      if (notInConstructor):
        if (not (topObject.__dict__.get('isModifiable'))):
          raise ApiError("""%s.setUrl:
           Storage not modifiable""" % self.qualifiedName
           + ": %s" % (topObject,)
          )

    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setUrl:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setUrl:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['url'] = value
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setUrl')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def sortedStored(self):
    """
    Sorted for memops.Implementation.Repository.stored
    """
    dataDict = self.__dict__
    ll = dataDict.get('stored')
    ll = [(x.getFullKey(),x) for x in ll]
    
    ll.sort()
    result = [x[1] for x in ll]
    return result

  toDetailedString = ComplexDataType.toDetailedString

  className = ComplexDataType.className

  fieldNames = ComplexDataType.fieldNames
  
  format = property(getFormat, setFormat, None,
  r"""Format in which data are supplied (default is 'xml', meaning standard 
  CCPN XML). May differ from the format in which data are actually stored.
  """)

  inConstructor = ComplexDataType.inConstructor

  isDeleted = MemopsObject.isDeleted

  metaclass = ComplexDataType.metaclass
  
  name = property(getName, setName, None,
  r"""name of repository
  """)

  packageName = ComplexDataType.packageName

  packageShortName = ComplexDataType.packageShortName

  qualifiedName = ComplexDataType.qualifiedName
  
  url = property(getUrl, setUrl, None,
  r"""Url of data repository
  """)
  
  memopsRoot = property(getMemopsRoot,  None, None,
  r"""parent link
  """)
  
  parent = property(getParent, None, None,
  r"""link to parent object - synonym for memopsRoot
  """)

  root = MemopsObject.root
  
  stored = property(getStored, setStored, None,
  r"""Groups of packages (LocationInfo) stored in repository.
  """)

  topObject = ImplementationObject.topObject

###############################################################################
class TopObject(DataObject):
  r"""Superclass for TopObjects (except for MemopsRoot). The attributes and 
operations are different in File and Db implementations
  """
  #   from data model element memops.Implementation.TopObject revision 1.52
  _metaclass = metaPackage.getElement('TopObject')
  _packageName = 'memops.Implementation'
  _packageShortName = 'IMPL'
  _fieldNames = ('applicationData', 'className', 'createdBy', 'fieldNames', 'guid', 'inConstructor', 'isDeleted', 'isLoaded', 'isModifiable', 'isModified', 'isReading', 'lastUnlockedBy', 'metaclass', 'packageName', 'packageShortName', 'qualifiedName', 'access', 'activeAccess', 'activeRepositories', 'memopsRoot', 'packageLocator', 'root', 'topObject',)
  
  _notifies = {'':[]}

  __init__ = ComplexDataType.__init__

  addApplicationData = DataObject.addApplicationData
  
  def backup(self):
    """
    back up TopObject to current backup location
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.backup:
       called on deleted object""" % self.qualifiedName
      )

    repository = self.memopsRoot.findFirstRepository(name='backup')
    if repository:
      if not self.isLoaded:
        self.load()
      self.saveTo(repository)
    else:
      raise ApiError('No backup repository found for TopObject %s' % self)

  checkAllValid = ComplexDataType.checkAllValid

  checkValid = ComplexDataType.checkValid

  delete = DataObject.delete
  
  def findAllActiveRepositories(self, **conditions):
    """
    FindAll for memops.Implementation.TopObject.activeRepositories
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = self.getActiveRepositories()
      result = list(currentValues)

    else:
      currentValues = self.getActiveRepositories()
      result = list()
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('format', 'name', 'url', 'memopsRoot',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result.append(v)

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result.append(v)

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result.append(v)

    return result

  findAllApplicationData = DataObject.findAllApplicationData
  
  def findFirstActiveRepository(self, **conditions):
    """
    FindFirst for memops.Implementation.TopObject.activeRepositories
    """
    dataDict = self.__dict__
    nConditions = len(conditions)
    if (nConditions == 0):
      currentValues = self.getActiveRepositories()
      if (currentValues):
        result = currentValues[0]
      else:
        result = None

    else:
      currentValues = dataDict.get('activeRepositories')
      if (not currentValues):
        dataDict.get('topObject').__dict__.get('memopsRoot').refreshTopObjects(self.__class__._packageName)
        currentValues = dataDict.get('activeRepositories')

      result = None
      
      items = conditions.items()
      if ((nConditions == 1)):
        (key, condition) = items[0]
        directAttrs = frozenset(('format', 'name', 'url', 'memopsRoot',))
        if (key in directAttrs):
          for v in currentValues:
            if (condition == v.__dict__.get(key)):
              result = v; break

        else:
          
          if isinstance(condition, list):
            condition = tuple(condition)
          elif isinstance(condition, set):
            condition = frozenset(condition)
          
          for v in currentValues:
            if (hasattr(v, key) and getattr(v, key) == condition):
              result = v; break

      else:
        
        for ii in range(nConditions):
          (key, condition) = items[ii]
          if isinstance(condition, list):
            items[ii] = (key, tuple(condition))
          elif isinstance(condition, set):
            items[ii] = (key, frozenset(condition))
        
        for v in currentValues:
        
          for (key, condition) in items:
            if (not hasattr(v, key)):
              break
            elif (getattr(v, key) != condition):
              break
          else:
            result = v; break

    return result

  findFirstApplicationData = DataObject.findFirstApplicationData

  getAccess = DataObject.getAccess

  getActiveAccess = DataObject.getActiveAccess
  
  def getActiveRepositories(self):
    """
    Get for memops.Implementation.TopObject.activeRepositories
    """
    dataDict = self.__dict__
    result = dataDict.get('activeRepositories')
    if (not result):
      dataDict.get('topObject').__dict__.get('memopsRoot').refreshTopObjects(self.__class__._packageName)
      result = dataDict.get('activeRepositories')

    result = tuple(result)
    return result

  getApplicationData = DataObject.getApplicationData

  getByNavigation = MemopsObject.getByNavigation

  getClassName = ComplexDataType.getClassName
  
  def getCreatedBy(self):
    """
    Get for memops.Implementation.TopObject.createdBy
    """
    dataDict = self.__dict__
    result = dataDict.get('createdBy')
    return result

  getExpandedKey = MemopsObject.getExpandedKey

  getFieldNames = ComplexDataType.getFieldNames
  
  def getGuid(self):
    """
    Get for memops.Implementation.TopObject.guid
    """
    dataDict = self.__dict__
    result = dataDict.get('guid')
    return result

  getInConstructor = ComplexDataType.getInConstructor

  getIsDeleted = MemopsObject.getIsDeleted
  
  def getIsLoaded(self):
    """
    Get for memops.Implementation.TopObject.isLoaded
    """
    dataDict = self.__dict__
    result = bool(dataDict.get('isLoaded'))
    return result
  
  def getIsModifiable(self):
    """
    Get for memops.Implementation.TopObject.isModifiable
    """
    dataDict = self.__dict__
    result = dataDict.get('isModifiable')
    return result
  
  def getIsModified(self):
    """
    Get for memops.Implementation.TopObject.isModified
    """
    dataDict = self.__dict__
    result = bool(dataDict.get('isModified'))
    return result
  
  def getIsReading(self):
    """
    Get for memops.Implementation.TopObject.isReading
    """
    dataDict = self.__dict__
    result = bool(dataDict.get('isReading'))
    return result
  
  def getLastUnlockedBy(self):
    """
    Get for memops.Implementation.TopObject.lastUnlockedBy
    """
    dataDict = self.__dict__
    result = dataDict.get('lastUnlockedBy')
    return result
  
  def getMemopsRoot(self):
    """
    Get for memops.Implementation.TopObject.memopsRoot
    """
    dataDict = self.__dict__
    raise ApiError("""%s.getMemopsRoot:
     getMemopsRoot should never be called - must be overridden in subclass""" % self.qualifiedName
     + ": %s" % (self,)
    )

  getMetaclass = ComplexDataType.getMetaclass
  
  def getPackageLocator(self):
    """
    getter for derived link packageLocator
    """
    dataDict = self.__dict__
    ff = self.root.findFirstPackageLocator
    result = ff(targetName=self.packageName) or ff(targetName='any')
    return result

  getPackageName = ComplexDataType.getPackageName

  getPackageShortName = ComplexDataType.getPackageShortName

  getQualifiedName = ComplexDataType.getQualifiedName

  getRoot = MemopsObject.getRoot

  getTopObject = DataObject.getTopObject
  
  def load(self):
    """
    Load data corresponding to TopObject
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.load:
       called on deleted object""" % self.qualifiedName
      )

    repositories = self.activeRepositories
    if repositories:
      self.loadFrom(repositories[0])
    else:
      raise ApiError('No active repository found for TopObject %s' % self)
  
  def loadFrom(self, repository):
    """
    Load TopObject from specific Repository
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.loadFrom:
       called on deleted object""" % self.qualifiedName
      )

    # NB must be done by direct access
    if self.isLoaded or self.inConstructor or self.isReading:
      print ("WARNING %s: cannot be loaded while isLoaded:%s, inConstructor:%s, isReading:%s"
                           % (self, self.isLoaded, self.inConstructor, self.isReading))
      return
    
    if  repository.format == 'xml' and repository.url.protocol == 'file':
    
      if self.parent is None:
        # MemopsRoot
          raise ApiError(" %s: MemopsRoot can not be (re)loaded" % self)
        
      if repository is not self.activeRepositories[0]:
        if self.isModifiable:
          dataDict['isModified'] = True
    
        else:
          raise ApiError(" %s: attempt to load non-modifiable TopObject from alternative repository %s" % (self, repository))
      
      from memops.format.xml import XmlIO
      XmlIO.loadTopObject(repository.url.getDataLocation(), self)
      
      # NBNB recent addition
      # resets upgraded refData objects to unmodified
      if repository.name == 'refData' and repository is self.activeRepositories[0]:
        self.__dict__['isModified'] = False
      
    else:
      raise ApiError(" %s: format %s, protocol %s not supported"
                           % (repository, repository.format, repository.url.protocol))

  removeApplicationData = DataObject.removeApplicationData
  
  def removeFrom(self, repository):
    """
    Remove data from specified repository. Will remove from disk. NB This
    operation is marked as a query because this means it may be executed on 
    a deleted object. It does have the lasting side effect of changing the 
    contents of the repository.
    """
    dataDict = self.__dict__
    # NB must be done by direct access
    activeRepositories = self.activeRepositories
    if (repository in activeRepositories and len(activeRepositories) <= 1
        and not self.isDeleted):
        raise ApiError("%s: cannot remove TopObject from last repository %s" % (self, repository))
    
    from memops.format.xml import Util as xmlUtil
    fileLocation = xmlUtil.findTopObjectPath(repository.url.getDataLocation(), self)
    import os
    try:
      os.remove(fileLocation)
    except:
      print ("%s: could not remove %s" % (self, fileLocation))
      raise
    
    if repository in activeRepositories:
      if repository is activeRepositories[0]:
        self.__dict__['isModified'] = True
      dataDict['activeRepositories'].remove(repository)
  
  def restore(self):
    """
    restore data from current backup location
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.restore:
       called on deleted object""" % self.qualifiedName
      )

    repository = self.root.findFirstRepository(name="backup")
    if repository:
      self.loadFrom(repository)
    else:
      raise ApiError('No backup repository found for TopObject %s' % self)
  
  def save(self):
    """
    Save data corresponding to TopObject
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.save:
       called on deleted object""" % self.qualifiedName
      )

    # NB must be done by direct access
    repositories = self.activeRepositories
    if repositories:
      repository = repositories[0]
    else:
      repository = self.packageLocator.findFirstRepository()
    self.saveTo(repository)
    dataDict['isModified'] = False
  
  def saveTo(self, repository):
    """
    Save topObject to specified repository
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.saveTo:
       called on deleted object""" % self.qualifiedName
      )

    # NB must be done by direct access
    if not self.isLoaded or self.inConstructor or self.isReading:
      raise ApiError("%s: cannot be saved while isLoaded:%s, inConstructor:%s, isReading:%s"
                           % (self, self.isLoaded, self.inConstructor, self.isReading))
    
    if repository.format == 'xml' and repository.url.protocol == 'file':
      
      # must be done before saving
      activeRepositories = self.activeRepositories
    
      from memops.format.xml import XmlIO
      XmlIO.save(repository.url.getDataLocation(), self)
    
      if repository not in activeRepositories:
        aSet = set(activeRepositories)
        aSet.add(repository)
        dataDict['activeRepositories'][:] = (x for x in self.packageLocator.repositories if x in aSet)
    
    else:
      raise ApiError(" format %s, protocol %s not supported"
                           % (repository.format, repository.url.protocol))

  setAccess = DataObject.setAccess

  setApplicationData = DataObject.setApplicationData
  
  def setCreatedBy(self, value):
    """
    Set for memops.Implementation.TopObject.createdBy
    """
    dataDict = self.__dict__
    if (isinstance(value, String.PythonType)):
      pass
    else:
      raise ApiError("""%s.setCreatedBy:
       memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 32):
      raise ApiError("""%s.setCreatedBy:
       memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.setCreatedBy:
       memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.split()) == 1)):
      raise ApiError("""%s.setCreatedBy:
       Word constraint contains_no_white_space violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValue = dataDict.get('createdBy')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setCreatedBy:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setCreatedBy:
         cannot set createdBy, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setCreatedBy:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['createdBy'] = value

    # doNotifies
  
  def setGuid(self, value):
    """
    Set for memops.Implementation.TopObject.guid
    """
    dataDict = self.__dict__
    if (isinstance(value, String.PythonType)):
      pass
    else:
      raise ApiError("""%s.setGuid:
       memops.Implementation.GuidString input is not of a valid type""" % self.qualifiedName
       + ": %s" % (value,)
      )

    _lenValue = len(value)
    if (_lenValue > 80):
      raise ApiError("""%s.setGuid:
       memops.Implementation.GuidString maximum length is 80 violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (_lenValue < 1):
      raise ApiError("""%s.setGuid:
       memops.Implementation.GuidString: Empty string not allowed""" % self.qualifiedName
       + ": %s" % (value,)
      )

    if (not (len(value.splitlines()) <= 1)):
      raise ApiError("""%s.setGuid:
       GuidString constraint contains_no_linebreak violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    isValid = frozenset('abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_0123456789-').issuperset(value)
    if (not (isValid)):
      raise ApiError("""%s.setGuid:
       GuidString constraint value_is_url_safe violated by value""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValue = dataDict.get('guid')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setGuid:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setGuid:
         cannot set guid, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      if (value is None):
        raise ApiError("""%s.setGuid:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['guid'] = value

    # doNotifies
  
  def setIsModifiable(self, value):
    """
    Special setter for isModifiable. Sets lastUnlockedBy
    """
    dataDict = self.__dict__
    if (not (value in [True, False])):
      raise ApiError("""%s.setIsModifiable:
       memops.Implementation.Boolean input is not in enumeration [True, False]""" % self.qualifiedName
       + ": %s" % (value,)
      )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValue = dataDict.get('isModifiable')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setIsModifiable:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (value is None):
        raise ApiError("""%s.setIsModifiable:
         value cannot be None""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    # NB must be done by direct access
    if self.isModified:
      raise ApiError("Modified and unsaved Storage can not be set to non-modifiable")
    
    if value:
      dataDict['lastUnlockedBy'] = self.root.currentUserId
    
    dataDict['isModifiable'] = bool(value)
    if (notIsReading):
      if (notInConstructor):
        topObject.__dict__['isModified'] = True

    # doNotifies

    if ((notInConstructor and notOverride)):
      
      _notifies = self.__class__._notifies
      
      ll1 = _notifies['']
      for notify in ll1:
        notify(self)
      
      ll = _notifies.get('setIsModifiable')
      if ll:
        for notify in ll:
          if notify not in ll1:
            notify(self)

  def setLastUnlockedBy(self, value):
    """
    Set for memops.Implementation.TopObject.lastUnlockedBy
    """
    dataDict = self.__dict__
    if (value is not None):
      if (isinstance(value, String.PythonType)):
        pass
      else:
        raise ApiError("""%s.setLastUnlockedBy:
         memops.Implementation.Word input is not of a valid type""" % self.qualifiedName
         + ": %s" % (value,)
        )

      _lenValue = len(value)
      if (_lenValue > 32):
        raise ApiError("""%s.setLastUnlockedBy:
         memops.Implementation.Word maximum length is 32 violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (_lenValue < 1):
        raise ApiError("""%s.setLastUnlockedBy:
         memops.Implementation.Word: Empty string not allowed""" % self.qualifiedName
         + ": %s" % (value,)
        )

      if (not (len(value.split()) == 1)):
        raise ApiError("""%s.setLastUnlockedBy:
         Word constraint contains_no_white_space violated by value""" % self.qualifiedName
         + ": %s" % (value,)
        )

    topObject = dataDict.get('topObject')
    if (not ((dataDict.get('isLoaded') or dataDict.get('isReading')))):
      self.load()

    currentValue = dataDict.get('lastUnlockedBy')
    notInConstructor = not (dataDict.get('inConstructor'))

    root = dataDict.get('memopsRoot')
    notOverride = not (root.__dict__.get('override'))
    notIsReading = not (topObject.__dict__.get('isReading'))
    notOverride = (notOverride and notIsReading)
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.setLastUnlockedBy:
       called on deleted object""" % self.qualifiedName
      )

    if (value == currentValue):
      return

    if (notOverride):
      if (notInConstructor):
        raise ApiError("""%s.setLastUnlockedBy:
         cannot set lastUnlockedBy, frozen""" % self.qualifiedName
         + ": %s" % (self,)
        )

      pass

    dataDict['lastUnlockedBy'] = value

    # doNotifies

  toDetailedString = ComplexDataType.toDetailedString
  
  def touch(self):
    """
    Set storage.isModified to True, so that the storage is saved at the next
    saveModified command. Fails if the storage is not loaded or not 
    modifiable.
    """
    dataDict = self.__dict__
    if (dataDict.get('isDeleted')):
      raise ApiError("""%s.touch:
       called on deleted object""" % self.qualifiedName
      )

    # NB must be done by direct access
    if not self.isLoaded:
      raise ApiError("Attempt to touch non-loaded TopObject %s" % self)
    
    if not self.isModifiable:
      raise ApiError("Attempt to touch non-modifiable TopObject %s" % self)
    
    dataDict['isModified'] = True

  applicationData = DataObject.applicationData

  className = ComplexDataType.className
  
  createdBy = property(getCreatedBy, setCreatedBy, None,
  r"""user who created TopObject.
  """)

  fieldNames = ComplexDataType.fieldNames
  
  guid = property(getGuid, setGuid, None,
  r"""global unique identifier - set by implementation.
  """)

  inConstructor = ComplexDataType.inConstructor

  isDeleted = MemopsObject.isDeleted
  
  isLoaded = property(getIsLoaded, None, None,
  r"""Implementation attribute, set automatically. True if the data in the 
  Storage are loaded into memory. As data are loaded automatically, this 
  attribute should be of interest only for the implementation.
  """)
  
  isModifiable = property(getIsModifiable, setIsModifiable, None,
  r"""True if the data corresponding to the storage may be modified. If 
  isModifiable is false for a given package, attemps to modify the data 
  will raise an error. Note that isModifiable can be set to true even if 
  the corresponding file is read-only. 
  
  For a Project, this atribute 
  defines whether the Implementation package (not the entire project 
  contents) can be modified. If the Implementation package is Read-Only, 
  this will prohibit many changes in the other packages as well.
  
  This 
  parameter can be freely modified by users, so it is not a security 
  feature, but rather a protection against accidental changes. 
  """)
  
  isModified = property(getIsModified, None, None,
  r"""Implementation attribute. True if the data corresponding to the Storage 
  have been modified since being loaded. Serves to indicate which data 
  need to be saved.
  """)
  
  isReading = property(getIsReading, None, None,
  r"""Implementation attribute, set automatically. True if the data 
  corresponding to the Storage are in the process of being read. As data 
  loading is handled automatically, this attribute should be relevant only 
  for the implementation, or possibly for programmers of multithreaded 
  programs. Serves to suppress notifiers and validity checking during 
  reading. Note that objects are not valid until the data loading is 
  completed.
  """)
  
  lastUnlockedBy = property(getLastUnlockedBy, setLastUnlockedBy, None,
  r"""User who last set TopObject.isModifiable to True.  Used to track if data 
  have been modified. Provided data have isModifiable set to False, any 
  modification in the underlying data will show up on lastUnlockedBy.
  """)

  metaclass = ComplexDataType.metaclass

  packageName = ComplexDataType.packageName

  packageShortName = ComplexDataType.packageShortName

  qualifiedName = ComplexDataType.qualifiedName

  access = DataObject.access

  activeAccess = DataObject.activeAccess
  
  activeRepositories = property(getActiveRepositories, None, None,
  r"""Repositories on package search path that contains a copy of TopObject
  """)
  
  memopsRoot = property(getMemopsRoot,  None, None,
  r"""parent link
  """)
  
  packageLocator = property(getPackageLocator, None, None,
  r"""Package locator relevant for TopObject
  """)

  root = MemopsObject.root

  topObject = DataObject.topObject
